package config

import (
	"testing"
)

func TestToCpeURI(t *testing.T) {
	var tests = []struct {
		in       string
		expected string
		err      bool
	}{
		{
			in:       "",
			expected: "",
			err:      true,
		},
		{
			in:       "cpe:/a:microsoft:internet_explorer:10",
			expected: "cpe:/a:microsoft:internet_explorer:10",
			err:      false,
		},
		{
			in:       "cpe:2.3:a:microsoft:internet_explorer:10:*:*:*:*:*:*:*",
			expected: "cpe:/a:microsoft:internet_explorer:10",
			err:      false,
		},
	}

	for i, tt := range tests {
		actual, err := toCpeURI(tt.in)
		if err != nil && !tt.err {
			t.Errorf("[%d] unexpected error occurred, in: %s act: %s, exp: %s",
				i, tt.in, actual, tt.expected)
		} else if err == nil && tt.err {
			t.Errorf("[%d] expected error is not occurred, in: %s act: %s, exp: %s",
				i, tt.in, actual, tt.expected)
		}
		if actual != tt.expected {
			t.Errorf("[%d] in: %s, actual: %s, expected: %s",
				i, tt.in, actual, tt.expected)
		}
	}
}
