// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See stateless_validation_helper_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2024 The Khronos Group Inc.
 * Copyright (c) 2015-2024 Valve Corporation
 * Copyright (c) 2015-2024 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#include "chassis.h"

#include "stateless/stateless_validation.h"
#include "enum_flag_bits.h"

bool StatelessValidation::ValidatePnextStructContents(const Location& loc, const VkBaseOutStructure* header, const char* pnext_vuid,
                                                      bool is_physdev_api, bool is_const_param) const {
    bool skip = false;
    switch (header->sType) {
        // Validation code for VkShaderModuleCreateInfo structure members
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: {  // Covers VUID-VkShaderModuleCreateInfo-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkShaderModuleCreateInfo);
                VkShaderModuleCreateInfo* structure = (VkShaderModuleCreateInfo*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkShaderModuleCreateInfo-flags-zerobitmask");

                skip |= ValidateArray(pNext_loc.dot(Field::codeSize), pNext_loc.dot(Field::pCode), structure->codeSize / 4,
                                      &structure->pCode, true, true, "VUID-VkShaderModuleCreateInfo-codeSize-01085",
                                      "VUID-VkShaderModuleCreateInfo-pCode-parameter");
            }
        } break;

        // Validation code for VkPipelineLayoutCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: {  // Covers VUID-VkPipelineLayoutCreateInfo-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineLayoutCreateInfo);
                VkPipelineLayoutCreateInfo* structure = (VkPipelineLayoutCreateInfo*)header;
                skip |=
                    ValidateFlags(pNext_loc.dot(Field::flags), "VkPipelineLayoutCreateFlagBits", AllVkPipelineLayoutCreateFlagBits,
                                  structure->flags, kOptionalFlags, "VUID-VkPipelineLayoutCreateInfo-flags-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::pushConstantRangeCount), pNext_loc.dot(Field::pPushConstantRanges),
                                      structure->pushConstantRangeCount, &structure->pPushConstantRanges, false, true,
                                      kVUIDUndefined, "VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-parameter");

                if (structure->pPushConstantRanges != nullptr) {
                    for (uint32_t pushConstantRangeIndex = 0; pushConstantRangeIndex < structure->pushConstantRangeCount;
                         ++pushConstantRangeIndex) {
                        [[maybe_unused]] const Location pPushConstantRanges_loc =
                            pNext_loc.dot(Field::pPushConstantRanges, pushConstantRangeIndex);
                        skip |= ValidateFlags(
                            pPushConstantRanges_loc.dot(Field::stageFlags), "VkShaderStageFlagBits", AllVkShaderStageFlagBits,
                            structure->pPushConstantRanges[pushConstantRangeIndex].stageFlags, kRequiredFlags,
                            "VUID-VkPushConstantRange-stageFlags-parameter", "VUID-VkPushConstantRange-stageFlags-requiredbitmask");
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceSubgroupProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: {  // Covers VUID-VkPhysicalDeviceSubgroupProperties-sType-sType

            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES) "
                                 "which was added in VK_API_VERSION_1_1 but the "
                                 "current effective API version is %s.",
                                 StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkPhysicalDevice16BitStorageFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {  // Covers
                                                                          // VUID-VkPhysicalDevice16BitStorageFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_16BIT_STORAGE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_16bit_storage))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES), but its parent extension "
                                 "VK_KHR_16bit_storage has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevice16BitStorageFeatures);
                VkPhysicalDevice16BitStorageFeatures* structure = (VkPhysicalDevice16BitStorageFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::storageBuffer16BitAccess), structure->storageBuffer16BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::uniformAndStorageBuffer16BitAccess),
                                       structure->uniformAndStorageBuffer16BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::storagePushConstant16), structure->storagePushConstant16);

                skip |= ValidateBool32(pNext_loc.dot(Field::storageInputOutput16), structure->storageInputOutput16);
            }
        } break;

        // Validation code for VkMemoryDedicatedRequirements structure members
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: {  // Covers VUID-VkMemoryDedicatedRequirements-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dedicated_allocation))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS), but "
                                 "its parent extension "
                                 "VK_KHR_dedicated_allocation has not been enabled.");
            }
        } break;

        // Validation code for VkMemoryDedicatedAllocateInfo structure members
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: {  // Covers VUID-VkMemoryDedicatedAllocateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dedicated_allocation))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_dedicated_allocation has not been enabled.");
            }
        } break;

        // Validation code for VkMemoryAllocateFlagsInfo structure members
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: {  // Covers VUID-VkMemoryAllocateFlagsInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO), but its "
                                 "parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkMemoryAllocateFlagsInfo);
                VkMemoryAllocateFlagsInfo* structure = (VkMemoryAllocateFlagsInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkMemoryAllocateFlagBits", AllVkMemoryAllocateFlagBits,
                                      structure->flags, kOptionalFlags, "VUID-VkMemoryAllocateFlagsInfo-flags-parameter");
            }
        } break;

        // Validation code for VkDeviceGroupRenderPassBeginInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: {  // Covers VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceGroupRenderPassBeginInfo);
                VkDeviceGroupRenderPassBeginInfo* structure = (VkDeviceGroupRenderPassBeginInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::deviceRenderAreaCount), pNext_loc.dot(Field::pDeviceRenderAreas),
                                      structure->deviceRenderAreaCount, &structure->pDeviceRenderAreas, false, true, kVUIDUndefined,
                                      "VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter");

                if (structure->pDeviceRenderAreas != nullptr) {
                    for (uint32_t deviceRenderAreaIndex = 0; deviceRenderAreaIndex < structure->deviceRenderAreaCount;
                         ++deviceRenderAreaIndex) {
                        [[maybe_unused]] const Location pDeviceRenderAreas_loc =
                            pNext_loc.dot(Field::pDeviceRenderAreas, deviceRenderAreaIndex);
                    }
                }
            }
        } break;

        // Validation code for VkDeviceGroupCommandBufferBeginInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: {  // Covers
                                                                          // VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO), but its parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
        } break;

        // Validation code for VkDeviceGroupSubmitInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: {  // Covers VUID-VkDeviceGroupSubmitInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO), but its "
                                 "parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceGroupSubmitInfo);
                VkDeviceGroupSubmitInfo* structure = (VkDeviceGroupSubmitInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::waitSemaphoreCount), pNext_loc.dot(Field::pWaitSemaphoreDeviceIndices),
                                      structure->waitSemaphoreCount, &structure->pWaitSemaphoreDeviceIndices, false, true,
                                      kVUIDUndefined, "VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::commandBufferCount), pNext_loc.dot(Field::pCommandBufferDeviceMasks),
                                      structure->commandBufferCount, &structure->pCommandBufferDeviceMasks, false, true,
                                      kVUIDUndefined, "VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter");

                skip |=
                    ValidateArray(pNext_loc.dot(Field::signalSemaphoreCount), pNext_loc.dot(Field::pSignalSemaphoreDeviceIndices),
                                  structure->signalSemaphoreCount, &structure->pSignalSemaphoreDeviceIndices, false, true,
                                  kVUIDUndefined, "VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter");
            }
        } break;

        // Validation code for VkDeviceGroupBindSparseInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: {  // Covers VUID-VkDeviceGroupBindSparseInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
        } break;

        // Validation code for VkBindBufferMemoryDeviceGroupInfo structure members
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: {  // Covers VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO), but its parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBindBufferMemoryDeviceGroupInfo);
                VkBindBufferMemoryDeviceGroupInfo* structure = (VkBindBufferMemoryDeviceGroupInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::deviceIndexCount), pNext_loc.dot(Field::pDeviceIndices),
                                      structure->deviceIndexCount, &structure->pDeviceIndices, false, true, kVUIDUndefined,
                                      "VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter");
            }
        } break;

        // Validation code for VkBindImageMemoryDeviceGroupInfo structure members
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: {  // Covers VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_device_group has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBindImageMemoryDeviceGroupInfo);
                VkBindImageMemoryDeviceGroupInfo* structure = (VkBindImageMemoryDeviceGroupInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::deviceIndexCount), pNext_loc.dot(Field::pDeviceIndices),
                                      structure->deviceIndexCount, &structure->pDeviceIndices, false, true, kVUIDUndefined,
                                      "VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::splitInstanceBindRegionCount),
                                      pNext_loc.dot(Field::pSplitInstanceBindRegions), structure->splitInstanceBindRegionCount,
                                      &structure->pSplitInstanceBindRegions, false, true, kVUIDUndefined,
                                      "VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter");

                if (structure->pSplitInstanceBindRegions != nullptr) {
                    for (uint32_t splitInstanceBindRegionIndex = 0;
                         splitInstanceBindRegionIndex < structure->splitInstanceBindRegionCount; ++splitInstanceBindRegionIndex) {
                        [[maybe_unused]] const Location pSplitInstanceBindRegions_loc =
                            pNext_loc.dot(Field::pSplitInstanceBindRegions, splitInstanceBindRegionIndex);
                    }
                }
            }
        } break;

        // Validation code for VkDeviceGroupDeviceCreateInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: {  // Covers VUID-VkDeviceGroupDeviceCreateInfo-sType-sType

            if (!instance_extensions.vk_khr_device_group_creation) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_device_group_creation has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceGroupDeviceCreateInfo);
                VkDeviceGroupDeviceCreateInfo* structure = (VkDeviceGroupDeviceCreateInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::physicalDeviceCount), pNext_loc.dot(Field::pPhysicalDevices),
                                      structure->physicalDeviceCount, &structure->pPhysicalDevices, false, true, kVUIDUndefined,
                                      "VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceFeatures2 structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {  // Covers VUID-VkPhysicalDeviceFeatures2-sType-sType

            if (!instance_extensions.vk_khr_get_physical_device_properties2) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2), but its "
                                 "parent extension "
                                 "VK_KHR_get_physical_device_properties2 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFeatures2);
                VkPhysicalDeviceFeatures2* structure = (VkPhysicalDeviceFeatures2*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::robustBufferAccess), structure->features.robustBufferAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::fullDrawIndexUint32), structure->features.fullDrawIndexUint32);

                skip |= ValidateBool32(pNext_loc.dot(Field::imageCubeArray), structure->features.imageCubeArray);

                skip |= ValidateBool32(pNext_loc.dot(Field::independentBlend), structure->features.independentBlend);

                skip |= ValidateBool32(pNext_loc.dot(Field::geometryShader), structure->features.geometryShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::tessellationShader), structure->features.tessellationShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::sampleRateShading), structure->features.sampleRateShading);

                skip |= ValidateBool32(pNext_loc.dot(Field::dualSrcBlend), structure->features.dualSrcBlend);

                skip |= ValidateBool32(pNext_loc.dot(Field::logicOp), structure->features.logicOp);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiDrawIndirect), structure->features.multiDrawIndirect);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::drawIndirectFirstInstance), structure->features.drawIndirectFirstInstance);

                skip |= ValidateBool32(pNext_loc.dot(Field::depthClamp), structure->features.depthClamp);

                skip |= ValidateBool32(pNext_loc.dot(Field::depthBiasClamp), structure->features.depthBiasClamp);

                skip |= ValidateBool32(pNext_loc.dot(Field::fillModeNonSolid), structure->features.fillModeNonSolid);

                skip |= ValidateBool32(pNext_loc.dot(Field::depthBounds), structure->features.depthBounds);

                skip |= ValidateBool32(pNext_loc.dot(Field::wideLines), structure->features.wideLines);

                skip |= ValidateBool32(pNext_loc.dot(Field::largePoints), structure->features.largePoints);

                skip |= ValidateBool32(pNext_loc.dot(Field::alphaToOne), structure->features.alphaToOne);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiViewport), structure->features.multiViewport);

                skip |= ValidateBool32(pNext_loc.dot(Field::samplerAnisotropy), structure->features.samplerAnisotropy);

                skip |= ValidateBool32(pNext_loc.dot(Field::textureCompressionETC2), structure->features.textureCompressionETC2);

                skip |= ValidateBool32(pNext_loc.dot(Field::textureCompressionASTC_LDR),
                                       structure->features.textureCompressionASTC_LDR);

                skip |= ValidateBool32(pNext_loc.dot(Field::textureCompressionBC), structure->features.textureCompressionBC);

                skip |= ValidateBool32(pNext_loc.dot(Field::occlusionQueryPrecise), structure->features.occlusionQueryPrecise);

                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineStatisticsQuery), structure->features.pipelineStatisticsQuery);

                skip |= ValidateBool32(pNext_loc.dot(Field::vertexPipelineStoresAndAtomics),
                                       structure->features.vertexPipelineStoresAndAtomics);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::fragmentStoresAndAtomics), structure->features.fragmentStoresAndAtomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderTessellationAndGeometryPointSize),
                                       structure->features.shaderTessellationAndGeometryPointSize);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::shaderImageGatherExtended), structure->features.shaderImageGatherExtended);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageExtendedFormats),
                                       structure->features.shaderStorageImageExtendedFormats);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageMultisample),
                                       structure->features.shaderStorageImageMultisample);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageReadWithoutFormat),
                                       structure->features.shaderStorageImageReadWithoutFormat);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageWriteWithoutFormat),
                                       structure->features.shaderStorageImageWriteWithoutFormat);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformBufferArrayDynamicIndexing),
                                       structure->features.shaderUniformBufferArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSampledImageArrayDynamicIndexing),
                                       structure->features.shaderSampledImageArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageBufferArrayDynamicIndexing),
                                       structure->features.shaderStorageBufferArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageArrayDynamicIndexing),
                                       structure->features.shaderStorageImageArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderClipDistance), structure->features.shaderClipDistance);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderCullDistance), structure->features.shaderCullDistance);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderFloat64), structure->features.shaderFloat64);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInt64), structure->features.shaderInt64);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInt16), structure->features.shaderInt16);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderResourceResidency), structure->features.shaderResourceResidency);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderResourceMinLod), structure->features.shaderResourceMinLod);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseBinding), structure->features.sparseBinding);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidencyBuffer), structure->features.sparseResidencyBuffer);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidencyImage2D), structure->features.sparseResidencyImage2D);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidencyImage3D), structure->features.sparseResidencyImage3D);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidency2Samples), structure->features.sparseResidency2Samples);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidency4Samples), structure->features.sparseResidency4Samples);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidency8Samples), structure->features.sparseResidency8Samples);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::sparseResidency16Samples), structure->features.sparseResidency16Samples);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseResidencyAliased), structure->features.sparseResidencyAliased);

                skip |= ValidateBool32(pNext_loc.dot(Field::variableMultisampleRate), structure->features.variableMultisampleRate);

                skip |= ValidateBool32(pNext_loc.dot(Field::inheritedQueries), structure->features.inheritedQueries);
            }
        } break;

        // Validation code for VkPhysicalDevicePointClippingProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: {  // Covers
                                                                             // VUID-VkPhysicalDevicePointClippingProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES), but its parent extension "
                                 "VK_KHR_maintenance2 has not been enabled.");
            }
        } break;

        // Validation code for VkRenderPassInputAttachmentAspectCreateInfo structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: {  // Covers
                                                                                   // VUID-VkRenderPassInputAttachmentAspectCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO), but its parent extension "
                                 "VK_KHR_maintenance2 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassInputAttachmentAspectCreateInfo);
                VkRenderPassInputAttachmentAspectCreateInfo* structure = (VkRenderPassInputAttachmentAspectCreateInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::aspectReferenceCount), pNext_loc.dot(Field::pAspectReferences),
                                      structure->aspectReferenceCount, &structure->pAspectReferences, true, true,
                                      "VUID-VkRenderPassInputAttachmentAspectCreateInfo-aspectReferenceCount-arraylength",
                                      "VUID-VkRenderPassInputAttachmentAspectCreateInfo-pAspectReferences-parameter");

                if (structure->pAspectReferences != nullptr) {
                    for (uint32_t aspectReferenceIndex = 0; aspectReferenceIndex < structure->aspectReferenceCount;
                         ++aspectReferenceIndex) {
                        [[maybe_unused]] const Location pAspectReferences_loc =
                            pNext_loc.dot(Field::pAspectReferences, aspectReferenceIndex);
                        skip |=
                            ValidateFlags(pAspectReferences_loc.dot(Field::aspectMask), "VkImageAspectFlagBits",
                                          AllVkImageAspectFlagBits, structure->pAspectReferences[aspectReferenceIndex].aspectMask,
                                          kRequiredFlags, "VUID-VkInputAttachmentAspectReference-aspectMask-parameter",
                                          "VUID-VkInputAttachmentAspectReference-aspectMask-requiredbitmask");
                    }
                }
            }
        } break;

        // Validation code for VkImageViewUsageCreateInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: {  // Covers VUID-VkImageViewUsageCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_maintenance2 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImageViewUsageCreateInfo);
                VkImageViewUsageCreateInfo* structure = (VkImageViewUsageCreateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::usage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits,
                                      structure->usage, kRequiredFlags, "VUID-VkImageViewUsageCreateInfo-usage-parameter",
                                      "VUID-VkImageViewUsageCreateInfo-usage-requiredbitmask");
            }
        } break;

        // Validation code for VkPipelineTessellationDomainOriginStateCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: {  // Covers
                                                                                         // VUID-VkPipelineTessellationDomainOriginStateCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType "
                             "(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO), but its parent extension "
                             "VK_KHR_maintenance2 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineTessellationDomainOriginStateCreateInfo);
                VkPipelineTessellationDomainOriginStateCreateInfo* structure =
                    (VkPipelineTessellationDomainOriginStateCreateInfo*)header;
                skip |=
                    ValidateRangedEnum(pNext_loc.dot(Field::domainOrigin), "VkTessellationDomainOrigin", structure->domainOrigin,
                                       "VUID-VkPipelineTessellationDomainOriginStateCreateInfo-domainOrigin-parameter");
            }
        } break;

        // Validation code for VkRenderPassMultiviewCreateInfo structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: {  // Covers VUID-VkRenderPassMultiviewCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MULTIVIEW_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_multiview))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_multiview has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassMultiviewCreateInfo);
                VkRenderPassMultiviewCreateInfo* structure = (VkRenderPassMultiviewCreateInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::subpassCount), pNext_loc.dot(Field::pViewMasks), structure->subpassCount,
                                      &structure->pViewMasks, false, true, kVUIDUndefined,
                                      "VUID-VkRenderPassMultiviewCreateInfo-pViewMasks-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::dependencyCount), pNext_loc.dot(Field::pViewOffsets),
                                      structure->dependencyCount, &structure->pViewOffsets, false, true, kVUIDUndefined,
                                      "VUID-VkRenderPassMultiviewCreateInfo-pViewOffsets-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::correlationMaskCount), pNext_loc.dot(Field::pCorrelationMasks),
                                      structure->correlationMaskCount, &structure->pCorrelationMasks, false, true, kVUIDUndefined,
                                      "VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceMultiviewFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {  // Covers VUID-VkPhysicalDeviceMultiviewFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MULTIVIEW_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_multiview))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES), "
                                 "but its parent extension "
                                 "VK_KHR_multiview has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMultiviewFeatures);
                VkPhysicalDeviceMultiviewFeatures* structure = (VkPhysicalDeviceMultiviewFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::multiview), structure->multiview);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewGeometryShader), structure->multiviewGeometryShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewTessellationShader), structure->multiviewTessellationShader);
            }
        } break;

        // Validation code for VkPhysicalDeviceMultiviewProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: {  // Covers
                                                                        // VUID-VkPhysicalDeviceMultiviewProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MULTIVIEW_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_multiview))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES), but its parent extension "
                                 "VK_KHR_multiview has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceVariablePointersFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {  // Covers
                                                                              // VUID-VkPhysicalDeviceVariablePointersFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_variable_pointers))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES), but its parent extension "
                                 "VK_KHR_variable_pointers has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVariablePointersFeatures);
                VkPhysicalDeviceVariablePointersFeatures* structure = (VkPhysicalDeviceVariablePointersFeatures*)header;
                skip |=
                    ValidateBool32(pNext_loc.dot(Field::variablePointersStorageBuffer), structure->variablePointersStorageBuffer);

                skip |= ValidateBool32(pNext_loc.dot(Field::variablePointers), structure->variablePointers);
            }
        } break;

        // Validation code for VkPhysicalDeviceProtectedMemoryFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {  // Covers
                                                                             // VUID-VkPhysicalDeviceProtectedMemoryFeatures-sType-sType

            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES) which "
                    "was added in VK_API_VERSION_1_1 but the "
                    "current effective API version is %s.",
                    StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceProtectedMemoryFeatures);
                VkPhysicalDeviceProtectedMemoryFeatures* structure = (VkPhysicalDeviceProtectedMemoryFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::protectedMemory), structure->protectedMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceProtectedMemoryProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: {  // Covers
                                                                               // VUID-VkPhysicalDeviceProtectedMemoryProperties-sType-sType

            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES) which "
                    "was added in VK_API_VERSION_1_1 but the "
                    "current effective API version is %s.",
                    StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkProtectedSubmitInfo structure members
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: {  // Covers VUID-VkProtectedSubmitInfo-sType-sType

            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO) which was "
                                 "added in VK_API_VERSION_1_1 but the "
                                 "current effective API version is %s.",
                                 StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkProtectedSubmitInfo);
                VkProtectedSubmitInfo* structure = (VkProtectedSubmitInfo*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::protectedSubmit), structure->protectedSubmit);
            }
        } break;

        // Validation code for VkSamplerYcbcrConversionInfo structure members
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: {  // Covers VUID-VkSamplerYcbcrConversionInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_sampler_ycbcr_conversion has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerYcbcrConversionInfo);
                VkSamplerYcbcrConversionInfo* structure = (VkSamplerYcbcrConversionInfo*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::conversion), structure->conversion);
            }
        } break;

        // Validation code for VkBindImagePlaneMemoryInfo structure members
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: {  // Covers VUID-VkBindImagePlaneMemoryInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_sampler_ycbcr_conversion has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBindImagePlaneMemoryInfo);
                VkBindImagePlaneMemoryInfo* structure = (VkBindImagePlaneMemoryInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::planeAspect), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      structure->planeAspect, kRequiredSingleBit,
                                      "VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter",
                                      "VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter");
            }
        } break;

        // Validation code for VkImagePlaneMemoryRequirementsInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: {  // Covers
                                                                        // VUID-VkImagePlaneMemoryRequirementsInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO), but its parent extension "
                                 "VK_KHR_sampler_ycbcr_conversion has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImagePlaneMemoryRequirementsInfo);
                VkImagePlaneMemoryRequirementsInfo* structure = (VkImagePlaneMemoryRequirementsInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::planeAspect), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      structure->planeAspect, kRequiredSingleBit,
                                      "VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter",
                                      "VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSamplerYcbcrConversionFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceSamplerYcbcrConversionFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES), but its parent extension "
                                 "VK_KHR_sampler_ycbcr_conversion has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSamplerYcbcrConversionFeatures);
                VkPhysicalDeviceSamplerYcbcrConversionFeatures* structure = (VkPhysicalDeviceSamplerYcbcrConversionFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::samplerYcbcrConversion), structure->samplerYcbcrConversion);
            }
        } break;

        // Validation code for VkSamplerYcbcrConversionImageFormatProperties structure members
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: {  // Covers
                                                                                    // VUID-VkSamplerYcbcrConversionImageFormatProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES), but its parent extension "
                                 "VK_KHR_sampler_ycbcr_conversion has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceExternalImageFormatInfo structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: {  // Covers
                                                                              // VUID-VkPhysicalDeviceExternalImageFormatInfo-sType-sType

            if (!instance_extensions.vk_khr_external_memory_capabilities) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO), but its parent extension "
                                 "VK_KHR_external_memory_capabilities has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExternalImageFormatInfo);
                VkPhysicalDeviceExternalImageFormatInfo* structure = (VkPhysicalDeviceExternalImageFormatInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit,
                                      "VUID-VkPhysicalDeviceExternalImageFormatInfo-handleType-parameter");
            }
        } break;

        // Validation code for VkExternalImageFormatProperties structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: {  // Covers VUID-VkExternalImageFormatProperties-sType-sType

            if (!instance_extensions.vk_khr_external_memory_capabilities) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES), "
                                 "but its parent extension "
                                 "VK_KHR_external_memory_capabilities has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceIDProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: {  // Covers VUID-VkPhysicalDeviceIDProperties-sType-sType

            if (!instance_extensions.vk_khr_external_fence_capabilities) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES), but "
                                 "its parent extension "
                                 "VK_KHR_external_fence_capabilities has not been enabled.");
            }
        } break;

        // Validation code for VkExternalMemoryImageCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: {  // Covers VUID-VkExternalMemoryImageCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_memory))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_external_memory has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExternalMemoryImageCreateInfo);
                VkExternalMemoryImageCreateInfo* structure = (VkExternalMemoryImageCreateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExternalMemoryBufferCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: {  // Covers VUID-VkExternalMemoryBufferCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_memory))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_external_memory has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExternalMemoryBufferCreateInfo);
                VkExternalMemoryBufferCreateInfo* structure = (VkExternalMemoryBufferCreateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportMemoryAllocateInfo structure members
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: {  // Covers VUID-VkExportMemoryAllocateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_memory))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO), but its "
                                 "parent extension "
                                 "VK_KHR_external_memory has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMemoryAllocateInfo);
                VkExportMemoryAllocateInfo* structure = (VkExportMemoryAllocateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExportMemoryAllocateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportFenceCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: {  // Covers VUID-VkExportFenceCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_fence))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO), but its "
                                 "parent extension "
                                 "VK_KHR_external_fence has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportFenceCreateInfo);
                VkExportFenceCreateInfo* structure = (VkExportFenceCreateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalFenceHandleTypeFlagBits",
                                      AllVkExternalFenceHandleTypeFlagBits, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExportFenceCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportSemaphoreCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: {  // Covers VUID-VkExportSemaphoreCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_semaphore))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_external_semaphore has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportSemaphoreCreateInfo);
                VkExportSemaphoreCreateInfo* structure = (VkExportSemaphoreCreateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalSemaphoreHandleTypeFlagBits",
                                      AllVkExternalSemaphoreHandleTypeFlagBits, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance3Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: {  // Covers
                                                                            // VUID-VkPhysicalDeviceMaintenance3Properties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_3_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance3))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES), but its parent extension "
                                 "VK_KHR_maintenance3 has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderDrawParametersFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceShaderDrawParametersFeatures-sType-sType

            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES) "
                    "which was added in VK_API_VERSION_1_1 but the "
                    "current effective API version is %s.",
                    StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderDrawParametersFeatures);
                VkPhysicalDeviceShaderDrawParametersFeatures* structure = (VkPhysicalDeviceShaderDrawParametersFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderDrawParameters), structure->shaderDrawParameters);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan11Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {  // Covers VUID-VkPhysicalDeviceVulkan11Features-sType-sType

            if (api_version < VK_API_VERSION_1_2) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES) "
                                 "which was added in VK_API_VERSION_1_2 but the "
                                 "current effective API version is %s.",
                                 StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVulkan11Features);
                VkPhysicalDeviceVulkan11Features* structure = (VkPhysicalDeviceVulkan11Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::storageBuffer16BitAccess), structure->storageBuffer16BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::uniformAndStorageBuffer16BitAccess),
                                       structure->uniformAndStorageBuffer16BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::storagePushConstant16), structure->storagePushConstant16);

                skip |= ValidateBool32(pNext_loc.dot(Field::storageInputOutput16), structure->storageInputOutput16);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiview), structure->multiview);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewGeometryShader), structure->multiviewGeometryShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewTessellationShader), structure->multiviewTessellationShader);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::variablePointersStorageBuffer), structure->variablePointersStorageBuffer);

                skip |= ValidateBool32(pNext_loc.dot(Field::variablePointers), structure->variablePointers);

                skip |= ValidateBool32(pNext_loc.dot(Field::protectedMemory), structure->protectedMemory);

                skip |= ValidateBool32(pNext_loc.dot(Field::samplerYcbcrConversion), structure->samplerYcbcrConversion);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderDrawParameters), structure->shaderDrawParameters);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan11Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: {  // Covers
                                                                         // VUID-VkPhysicalDeviceVulkan11Properties-sType-sType

            if (api_version < VK_API_VERSION_1_2) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES) "
                             "which was added in VK_API_VERSION_1_2 but the "
                             "current effective API version is %s.",
                             StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan12Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {  // Covers VUID-VkPhysicalDeviceVulkan12Features-sType-sType

            if (api_version < VK_API_VERSION_1_2) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES) "
                                 "which was added in VK_API_VERSION_1_2 but the "
                                 "current effective API version is %s.",
                                 StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVulkan12Features);
                VkPhysicalDeviceVulkan12Features* structure = (VkPhysicalDeviceVulkan12Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::samplerMirrorClampToEdge), structure->samplerMirrorClampToEdge);

                skip |= ValidateBool32(pNext_loc.dot(Field::drawIndirectCount), structure->drawIndirectCount);

                skip |= ValidateBool32(pNext_loc.dot(Field::storageBuffer8BitAccess), structure->storageBuffer8BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::uniformAndStorageBuffer8BitAccess),
                                       structure->uniformAndStorageBuffer8BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::storagePushConstant8), structure->storagePushConstant8);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferInt64Atomics), structure->shaderBufferInt64Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedInt64Atomics), structure->shaderSharedInt64Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderFloat16), structure->shaderFloat16);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInt8), structure->shaderInt8);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorIndexing), structure->descriptorIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInputAttachmentArrayDynamicIndexing),
                                       structure->shaderInputAttachmentArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformTexelBufferArrayDynamicIndexing),
                                       structure->shaderUniformTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageTexelBufferArrayDynamicIndexing),
                                       structure->shaderStorageTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformBufferArrayNonUniformIndexing),
                                       structure->shaderUniformBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSampledImageArrayNonUniformIndexing),
                                       structure->shaderSampledImageArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageBufferArrayNonUniformIndexing),
                                       structure->shaderStorageBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageArrayNonUniformIndexing),
                                       structure->shaderStorageImageArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInputAttachmentArrayNonUniformIndexing),
                                       structure->shaderInputAttachmentArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformTexelBufferArrayNonUniformIndexing),
                                       structure->shaderUniformTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageTexelBufferArrayNonUniformIndexing),
                                       structure->shaderStorageTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingUniformBufferUpdateAfterBind),
                                       structure->descriptorBindingUniformBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingSampledImageUpdateAfterBind),
                                       structure->descriptorBindingSampledImageUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingStorageImageUpdateAfterBind),
                                       structure->descriptorBindingStorageImageUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingStorageBufferUpdateAfterBind),
                                       structure->descriptorBindingStorageBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingUniformTexelBufferUpdateAfterBind),
                                       structure->descriptorBindingUniformTexelBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingStorageTexelBufferUpdateAfterBind),
                                       structure->descriptorBindingStorageTexelBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingUpdateUnusedWhilePending),
                                       structure->descriptorBindingUpdateUnusedWhilePending);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingPartiallyBound),
                                       structure->descriptorBindingPartiallyBound);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingVariableDescriptorCount),
                                       structure->descriptorBindingVariableDescriptorCount);

                skip |= ValidateBool32(pNext_loc.dot(Field::runtimeDescriptorArray), structure->runtimeDescriptorArray);

                skip |= ValidateBool32(pNext_loc.dot(Field::samplerFilterMinmax), structure->samplerFilterMinmax);

                skip |= ValidateBool32(pNext_loc.dot(Field::scalarBlockLayout), structure->scalarBlockLayout);

                skip |= ValidateBool32(pNext_loc.dot(Field::imagelessFramebuffer), structure->imagelessFramebuffer);

                skip |= ValidateBool32(pNext_loc.dot(Field::uniformBufferStandardLayout), structure->uniformBufferStandardLayout);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSubgroupExtendedTypes), structure->shaderSubgroupExtendedTypes);

                skip |= ValidateBool32(pNext_loc.dot(Field::separateDepthStencilLayouts), structure->separateDepthStencilLayouts);

                skip |= ValidateBool32(pNext_loc.dot(Field::hostQueryReset), structure->hostQueryReset);

                skip |= ValidateBool32(pNext_loc.dot(Field::timelineSemaphore), structure->timelineSemaphore);

                skip |= ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddress), structure->bufferDeviceAddress);

                skip |= ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddressCaptureReplay),
                                       structure->bufferDeviceAddressCaptureReplay);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddressMultiDevice), structure->bufferDeviceAddressMultiDevice);

                skip |= ValidateBool32(pNext_loc.dot(Field::vulkanMemoryModel), structure->vulkanMemoryModel);

                skip |= ValidateBool32(pNext_loc.dot(Field::vulkanMemoryModelDeviceScope), structure->vulkanMemoryModelDeviceScope);

                skip |= ValidateBool32(pNext_loc.dot(Field::vulkanMemoryModelAvailabilityVisibilityChains),
                                       structure->vulkanMemoryModelAvailabilityVisibilityChains);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderOutputViewportIndex), structure->shaderOutputViewportIndex);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderOutputLayer), structure->shaderOutputLayer);

                skip |= ValidateBool32(pNext_loc.dot(Field::subgroupBroadcastDynamicId), structure->subgroupBroadcastDynamicId);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan12Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: {  // Covers
                                                                         // VUID-VkPhysicalDeviceVulkan12Properties-sType-sType

            if (api_version < VK_API_VERSION_1_2) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES) "
                             "which was added in VK_API_VERSION_1_2 but the "
                             "current effective API version is %s.",
                             StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkImageFormatListCreateInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: {  // Covers VUID-VkImageFormatListCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_image_format_list))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_image_format_list has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImageFormatListCreateInfo);
                VkImageFormatListCreateInfo* structure = (VkImageFormatListCreateInfo*)header;
                skip |= ValidateRangedEnumArray(pNext_loc.dot(Field::viewFormatCount), pNext_loc.dot(Field::pViewFormats),
                                                "VkFormat", structure->viewFormatCount, structure->pViewFormats, false, true);
            }
        } break;

        // Validation code for VkPhysicalDevice8BitStorageFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {  // Covers
                                                                         // VUID-VkPhysicalDevice8BitStorageFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_8BIT_STORAGE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_8bit_storage))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES), but its parent extension "
                                 "VK_KHR_8bit_storage has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevice8BitStorageFeatures);
                VkPhysicalDevice8BitStorageFeatures* structure = (VkPhysicalDevice8BitStorageFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::storageBuffer8BitAccess), structure->storageBuffer8BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::uniformAndStorageBuffer8BitAccess),
                                       structure->uniformAndStorageBuffer8BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::storagePushConstant8), structure->storagePushConstant8);
            }
        } break;

        // Validation code for VkPhysicalDeviceDriverProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: {  // Covers VUID-VkPhysicalDeviceDriverProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DRIVER_PROPERTIES_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_driver_properties))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES), "
                                 "but its parent extension "
                                 "VK_KHR_driver_properties has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderAtomicInt64Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {  // Covers
                                                                                // VUID-VkPhysicalDeviceShaderAtomicInt64Features-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_atomic_int64))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES), but its parent extension "
                                 "VK_KHR_shader_atomic_int64 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderAtomicInt64Features);
                VkPhysicalDeviceShaderAtomicInt64Features* structure = (VkPhysicalDeviceShaderAtomicInt64Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferInt64Atomics), structure->shaderBufferInt64Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedInt64Atomics), structure->shaderSharedInt64Atomics);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderFloat16Int8Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {  // Covers
                                                                                // VUID-VkPhysicalDeviceShaderFloat16Int8Features-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_float16_int8))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES), but its parent extension "
                                 "VK_KHR_shader_float16_int8 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderFloat16Int8Features);
                VkPhysicalDeviceShaderFloat16Int8Features* structure = (VkPhysicalDeviceShaderFloat16Int8Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderFloat16), structure->shaderFloat16);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInt8), structure->shaderInt8);
            }
        } break;

        // Validation code for VkPhysicalDeviceFloatControlsProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: {  // Covers
                                                                             // VUID-VkPhysicalDeviceFloatControlsProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_float_controls))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES), but its parent extension "
                                 "VK_KHR_shader_float_controls has not been enabled.");
            }
        } break;

        // Validation code for VkDescriptorSetLayoutBindingFlagsCreateInfo structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: {  // Covers
                                                                                   // VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO), but its parent extension "
                                 "VK_EXT_descriptor_indexing has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDescriptorSetLayoutBindingFlagsCreateInfo);
                VkDescriptorSetLayoutBindingFlagsCreateInfo* structure = (VkDescriptorSetLayoutBindingFlagsCreateInfo*)header;
                skip |= ValidateFlagsArray(pNext_loc.dot(Field::bindingCount), pNext_loc.dot(Field::pBindingFlags),
                                           "VkDescriptorBindingFlagBits", AllVkDescriptorBindingFlagBits, structure->bindingCount,
                                           structure->pBindingFlags, false,
                                           "VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceDescriptorIndexingFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {  // Covers
                                                                                // VUID-VkPhysicalDeviceDescriptorIndexingFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES), but its parent extension "
                                 "VK_EXT_descriptor_indexing has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDescriptorIndexingFeatures);
                VkPhysicalDeviceDescriptorIndexingFeatures* structure = (VkPhysicalDeviceDescriptorIndexingFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInputAttachmentArrayDynamicIndexing),
                                       structure->shaderInputAttachmentArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformTexelBufferArrayDynamicIndexing),
                                       structure->shaderUniformTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageTexelBufferArrayDynamicIndexing),
                                       structure->shaderStorageTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformBufferArrayNonUniformIndexing),
                                       structure->shaderUniformBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSampledImageArrayNonUniformIndexing),
                                       structure->shaderSampledImageArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageBufferArrayNonUniformIndexing),
                                       structure->shaderStorageBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageImageArrayNonUniformIndexing),
                                       structure->shaderStorageImageArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderInputAttachmentArrayNonUniformIndexing),
                                       structure->shaderInputAttachmentArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderUniformTexelBufferArrayNonUniformIndexing),
                                       structure->shaderUniformTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderStorageTexelBufferArrayNonUniformIndexing),
                                       structure->shaderStorageTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingUniformBufferUpdateAfterBind),
                                       structure->descriptorBindingUniformBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingSampledImageUpdateAfterBind),
                                       structure->descriptorBindingSampledImageUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingStorageImageUpdateAfterBind),
                                       structure->descriptorBindingStorageImageUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingStorageBufferUpdateAfterBind),
                                       structure->descriptorBindingStorageBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingUniformTexelBufferUpdateAfterBind),
                                       structure->descriptorBindingUniformTexelBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingStorageTexelBufferUpdateAfterBind),
                                       structure->descriptorBindingStorageTexelBufferUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingUpdateUnusedWhilePending),
                                       structure->descriptorBindingUpdateUnusedWhilePending);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingPartiallyBound),
                                       structure->descriptorBindingPartiallyBound);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingVariableDescriptorCount),
                                       structure->descriptorBindingVariableDescriptorCount);

                skip |= ValidateBool32(pNext_loc.dot(Field::runtimeDescriptorArray), structure->runtimeDescriptorArray);
            }
        } break;

        // Validation code for VkPhysicalDeviceDescriptorIndexingProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceDescriptorIndexingProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES), but its parent extension "
                                 "VK_EXT_descriptor_indexing has not been enabled.");
            }
        } break;

        // Validation code for VkDescriptorSetVariableDescriptorCountAllocateInfo structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: {  // Covers
                                                                                          // VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType "
                             "(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO), but its parent extension "
                             "VK_EXT_descriptor_indexing has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDescriptorSetVariableDescriptorCountAllocateInfo);
                VkDescriptorSetVariableDescriptorCountAllocateInfo* structure =
                    (VkDescriptorSetVariableDescriptorCountAllocateInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::descriptorSetCount), pNext_loc.dot(Field::pDescriptorCounts),
                                      structure->descriptorSetCount, &structure->pDescriptorCounts, false, true, kVUIDUndefined,
                                      "VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter");
            }
        } break;

        // Validation code for VkDescriptorSetVariableDescriptorCountLayoutSupport structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: {  // Covers
                                                                                           // VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT), but its parent extension "
                    "VK_EXT_descriptor_indexing has not been enabled.");
            }
        } break;

        // Validation code for VkSubpassDescriptionDepthStencilResolve structure members
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: {  // Covers
                                                                             // VUID-VkSubpassDescriptionDepthStencilResolve-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_depth_stencil_resolve))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE), but its parent extension "
                                 "VK_KHR_depth_stencil_resolve has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSubpassDescriptionDepthStencilResolve);
                VkSubpassDescriptionDepthStencilResolve* structure = (VkSubpassDescriptionDepthStencilResolve*)header;
                skip |= ValidateStructType(pNext_loc.dot(Field::pDepthStencilResolveAttachment),
                                           "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", structure->pDepthStencilResolveAttachment,
                                           VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false,
                                           "VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-parameter",
                                           "VUID-VkAttachmentReference2-sType-sType");

                if (structure->pDepthStencilResolveAttachment != nullptr) {
                    [[maybe_unused]] const Location pDepthStencilResolveAttachment_loc =
                        pNext_loc.dot(Field::pDepthStencilResolveAttachment);
                    skip |= ValidateRangedEnum(pDepthStencilResolveAttachment_loc.dot(Field::layout), "VkImageLayout",
                                               structure->pDepthStencilResolveAttachment->layout,
                                               "VUID-VkAttachmentReference2-layout-parameter");
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthStencilResolveProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceDepthStencilResolveProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_depth_stencil_resolve))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES), but its parent extension "
                                 "VK_KHR_depth_stencil_resolve has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceScalarBlockLayoutFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {  // Covers
                                                                                // VUID-VkPhysicalDeviceScalarBlockLayoutFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_scalar_block_layout))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES), but its parent extension "
                                 "VK_EXT_scalar_block_layout has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceScalarBlockLayoutFeatures);
                VkPhysicalDeviceScalarBlockLayoutFeatures* structure = (VkPhysicalDeviceScalarBlockLayoutFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::scalarBlockLayout), structure->scalarBlockLayout);
            }
        } break;

        // Validation code for VkImageStencilUsageCreateInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: {  // Covers VUID-VkImageStencilUsageCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_separate_stencil_usage))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_EXT_separate_stencil_usage has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImageStencilUsageCreateInfo);
                VkImageStencilUsageCreateInfo* structure = (VkImageStencilUsageCreateInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::stencilUsage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits,
                                      structure->stencilUsage, kRequiredFlags,
                                      "VUID-VkImageStencilUsageCreateInfo-stencilUsage-parameter",
                                      "VUID-VkImageStencilUsageCreateInfo-stencilUsage-requiredbitmask");
            }
        } break;

        // Validation code for VkSamplerReductionModeCreateInfo structure members
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: {  // Covers VUID-VkSamplerReductionModeCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_sampler_filter_minmax))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO), "
                                 "but its parent extension "
                                 "VK_EXT_sampler_filter_minmax has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerReductionModeCreateInfo);
                VkSamplerReductionModeCreateInfo* structure = (VkSamplerReductionModeCreateInfo*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::reductionMode), "VkSamplerReductionMode", structure->reductionMode,
                                           "VUID-VkSamplerReductionModeCreateInfo-reductionMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSamplerFilterMinmaxProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceSamplerFilterMinmaxProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_sampler_filter_minmax))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES), but its parent extension "
                                 "VK_EXT_sampler_filter_minmax has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkanMemoryModelFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {  // Covers
                                                                                // VUID-VkPhysicalDeviceVulkanMemoryModelFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_vulkan_memory_model))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES), but its parent extension "
                                 "VK_KHR_vulkan_memory_model has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVulkanMemoryModelFeatures);
                VkPhysicalDeviceVulkanMemoryModelFeatures* structure = (VkPhysicalDeviceVulkanMemoryModelFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::vulkanMemoryModel), structure->vulkanMemoryModel);

                skip |= ValidateBool32(pNext_loc.dot(Field::vulkanMemoryModelDeviceScope), structure->vulkanMemoryModelDeviceScope);

                skip |= ValidateBool32(pNext_loc.dot(Field::vulkanMemoryModelAvailabilityVisibilityChains),
                                       structure->vulkanMemoryModelAvailabilityVisibilityChains);
            }
        } break;

        // Validation code for VkPhysicalDeviceImagelessFramebufferFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceImagelessFramebufferFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_imageless_framebuffer))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES), but its parent extension "
                                 "VK_KHR_imageless_framebuffer has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImagelessFramebufferFeatures);
                VkPhysicalDeviceImagelessFramebufferFeatures* structure = (VkPhysicalDeviceImagelessFramebufferFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::imagelessFramebuffer), structure->imagelessFramebuffer);
            }
        } break;

        // Validation code for VkFramebufferAttachmentsCreateInfo structure members
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: {  // Covers VUID-VkFramebufferAttachmentsCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_imageless_framebuffer))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_imageless_framebuffer has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkFramebufferAttachmentsCreateInfo);
                VkFramebufferAttachmentsCreateInfo* structure = (VkFramebufferAttachmentsCreateInfo*)header;
                skip |= ValidateStructTypeArray(
                    pNext_loc.dot(Field::attachmentImageInfoCount), pNext_loc.dot(Field::pAttachmentImageInfos),
                    "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", structure->attachmentImageInfoCount,
                    structure->pAttachmentImageInfos, VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO, false, true,
                    "VUID-VkFramebufferAttachmentImageInfo-sType-sType",
                    "VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", kVUIDUndefined);

                if (structure->pAttachmentImageInfos != nullptr) {
                    for (uint32_t attachmentImageInfoIndex = 0; attachmentImageInfoIndex < structure->attachmentImageInfoCount;
                         ++attachmentImageInfoIndex) {
                        [[maybe_unused]] const Location pAttachmentImageInfos_loc =
                            pNext_loc.dot(Field::pAttachmentImageInfos, attachmentImageInfoIndex);
                        skip |= ValidateFlags(pAttachmentImageInfos_loc.dot(Field::flags), "VkImageCreateFlagBits",
                                              AllVkImageCreateFlagBits,
                                              structure->pAttachmentImageInfos[attachmentImageInfoIndex].flags, kOptionalFlags,
                                              "VUID-VkFramebufferAttachmentImageInfo-flags-parameter");

                        skip |=
                            ValidateFlags(pAttachmentImageInfos_loc.dot(Field::usage), "VkImageUsageFlagBits",
                                          AllVkImageUsageFlagBits, structure->pAttachmentImageInfos[attachmentImageInfoIndex].usage,
                                          kRequiredFlags, "VUID-VkFramebufferAttachmentImageInfo-usage-parameter",
                                          "VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask");

                        skip |= ValidateRangedEnumArray(pAttachmentImageInfos_loc.dot(Field::viewFormatCount),
                                                        pAttachmentImageInfos_loc.dot(Field::pViewFormats), "VkFormat",
                                                        structure->pAttachmentImageInfos[attachmentImageInfoIndex].viewFormatCount,
                                                        structure->pAttachmentImageInfos[attachmentImageInfoIndex].pViewFormats,
                                                        false, true);
                    }
                }
            }
        } break;

        // Validation code for VkRenderPassAttachmentBeginInfo structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: {  // Covers VUID-VkRenderPassAttachmentBeginInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_imageless_framebuffer))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO), "
                                 "but its parent extension "
                                 "VK_KHR_imageless_framebuffer has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassAttachmentBeginInfo);
                VkRenderPassAttachmentBeginInfo* structure = (VkRenderPassAttachmentBeginInfo*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::attachmentCount), pNext_loc.dot(Field::pAttachments),
                                      structure->attachmentCount, &structure->pAttachments, false, true, kVUIDUndefined,
                                      "VUID-VkRenderPassAttachmentBeginInfo-pAttachments-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceUniformBufferStandardLayoutFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceUniformBufferStandardLayoutFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_uniform_buffer_standard_layout))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES), but its parent extension "
                    "VK_KHR_uniform_buffer_standard_layout has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceUniformBufferStandardLayoutFeatures);
                VkPhysicalDeviceUniformBufferStandardLayoutFeatures* structure =
                    (VkPhysicalDeviceUniformBufferStandardLayoutFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::uniformBufferStandardLayout), structure->uniformBufferStandardLayout);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_subgroup_extended_types))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES), but its parent extension "
                    "VK_KHR_shader_subgroup_extended_types has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_separate_depth_stencil_layouts))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES), but its parent extension "
                    "VK_KHR_separate_depth_stencil_layouts has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures);
                VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* structure =
                    (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::separateDepthStencilLayouts), structure->separateDepthStencilLayouts);
            }
        } break;

        // Validation code for VkAttachmentReferenceStencilLayout structure members
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: {  // Covers VUID-VkAttachmentReferenceStencilLayout-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_separate_depth_stencil_layouts))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT), "
                                 "but its parent extension "
                                 "VK_KHR_separate_depth_stencil_layouts has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkAttachmentReferenceStencilLayout);
                VkAttachmentReferenceStencilLayout* structure = (VkAttachmentReferenceStencilLayout*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::stencilLayout), "VkImageLayout", structure->stencilLayout,
                                           "VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter");
            }
        } break;

        // Validation code for VkAttachmentDescriptionStencilLayout structure members
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: {  // Covers
                                                                         // VUID-VkAttachmentDescriptionStencilLayout-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_separate_depth_stencil_layouts))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT), but its parent extension "
                                 "VK_KHR_separate_depth_stencil_layouts has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkAttachmentDescriptionStencilLayout);
                VkAttachmentDescriptionStencilLayout* structure = (VkAttachmentDescriptionStencilLayout*)header;
                skip |=
                    ValidateRangedEnum(pNext_loc.dot(Field::stencilInitialLayout), "VkImageLayout", structure->stencilInitialLayout,
                                       "VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::stencilFinalLayout), "VkImageLayout", structure->stencilFinalLayout,
                                           "VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceHostQueryResetFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {  // Covers
                                                                             // VUID-VkPhysicalDeviceHostQueryResetFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_HOST_QUERY_RESET_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_host_query_reset))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES), but its parent extension "
                                 "VK_EXT_host_query_reset has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceHostQueryResetFeatures);
                VkPhysicalDeviceHostQueryResetFeatures* structure = (VkPhysicalDeviceHostQueryResetFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::hostQueryReset), structure->hostQueryReset);
            }
        } break;

        // Validation code for VkPhysicalDeviceTimelineSemaphoreFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {  // Covers
                                                                               // VUID-VkPhysicalDeviceTimelineSemaphoreFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES), but its parent extension "
                                 "VK_KHR_timeline_semaphore has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceTimelineSemaphoreFeatures);
                VkPhysicalDeviceTimelineSemaphoreFeatures* structure = (VkPhysicalDeviceTimelineSemaphoreFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::timelineSemaphore), structure->timelineSemaphore);
            }
        } break;

        // Validation code for VkPhysicalDeviceTimelineSemaphoreProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceTimelineSemaphoreProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES), but its parent extension "
                                 "VK_KHR_timeline_semaphore has not been enabled.");
            }
        } break;

        // Validation code for VkSemaphoreTypeCreateInfo structure members
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: {  // Covers VUID-VkSemaphoreTypeCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO), but its "
                                 "parent extension "
                                 "VK_KHR_timeline_semaphore has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSemaphoreTypeCreateInfo);
                VkSemaphoreTypeCreateInfo* structure = (VkSemaphoreTypeCreateInfo*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::semaphoreType), "VkSemaphoreType", structure->semaphoreType,
                                           "VUID-VkSemaphoreTypeCreateInfo-semaphoreType-parameter");
            }
        } break;

        // Validation code for VkTimelineSemaphoreSubmitInfo structure members
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: {  // Covers VUID-VkTimelineSemaphoreSubmitInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_timeline_semaphore has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceBufferDeviceAddressFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceBufferDeviceAddressFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_buffer_device_address))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES), but its parent extension "
                                 "VK_KHR_buffer_device_address has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceBufferDeviceAddressFeatures);
                VkPhysicalDeviceBufferDeviceAddressFeatures* structure = (VkPhysicalDeviceBufferDeviceAddressFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddress), structure->bufferDeviceAddress);

                skip |= ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddressCaptureReplay),
                                       structure->bufferDeviceAddressCaptureReplay);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddressMultiDevice), structure->bufferDeviceAddressMultiDevice);
            }
        } break;

        // Validation code for VkBufferOpaqueCaptureAddressCreateInfo structure members
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: {  // Covers
                                                                             // VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_buffer_device_address))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO), but its parent extension "
                                 "VK_KHR_buffer_device_address has not been enabled.");
            }
        } break;

        // Validation code for VkMemoryOpaqueCaptureAddressAllocateInfo structure members
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: {  // Covers
                                                                               // VUID-VkMemoryOpaqueCaptureAddressAllocateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_buffer_device_address))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO), but its parent extension "
                                 "VK_KHR_buffer_device_address has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan13Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {  // Covers VUID-VkPhysicalDeviceVulkan13Features-sType-sType

            if (api_version < VK_API_VERSION_1_3) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES) "
                                 "which was added in VK_API_VERSION_1_3 but the "
                                 "current effective API version is %s.",
                                 StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVulkan13Features);
                VkPhysicalDeviceVulkan13Features* structure = (VkPhysicalDeviceVulkan13Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::robustImageAccess), structure->robustImageAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::inlineUniformBlock), structure->inlineUniformBlock);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingInlineUniformBlockUpdateAfterBind),
                                       structure->descriptorBindingInlineUniformBlockUpdateAfterBind);

                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineCreationCacheControl), structure->pipelineCreationCacheControl);

                skip |= ValidateBool32(pNext_loc.dot(Field::privateData), structure->privateData);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::shaderDemoteToHelperInvocation), structure->shaderDemoteToHelperInvocation);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderTerminateInvocation), structure->shaderTerminateInvocation);

                skip |= ValidateBool32(pNext_loc.dot(Field::subgroupSizeControl), structure->subgroupSizeControl);

                skip |= ValidateBool32(pNext_loc.dot(Field::computeFullSubgroups), structure->computeFullSubgroups);

                skip |= ValidateBool32(pNext_loc.dot(Field::synchronization2), structure->synchronization2);

                skip |= ValidateBool32(pNext_loc.dot(Field::textureCompressionASTC_HDR), structure->textureCompressionASTC_HDR);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderZeroInitializeWorkgroupMemory),
                                       structure->shaderZeroInitializeWorkgroupMemory);

                skip |= ValidateBool32(pNext_loc.dot(Field::dynamicRendering), structure->dynamicRendering);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderIntegerDotProduct), structure->shaderIntegerDotProduct);

                skip |= ValidateBool32(pNext_loc.dot(Field::maintenance4), structure->maintenance4);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan13Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: {  // Covers
                                                                         // VUID-VkPhysicalDeviceVulkan13Properties-sType-sType

            if (api_version < VK_API_VERSION_1_3) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES) "
                             "which was added in VK_API_VERSION_1_3 but the "
                             "current effective API version is %s.",
                             StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkPipelineCreationFeedbackCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: {  // Covers
                                                                          // VUID-VkPipelineCreationFeedbackCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_pipeline_creation_feedback))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO), but its parent extension "
                                 "VK_EXT_pipeline_creation_feedback has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineCreationFeedbackCreateInfo);
                VkPipelineCreationFeedbackCreateInfo* structure = (VkPipelineCreationFeedbackCreateInfo*)header;
                skip |=
                    ValidateRequiredPointer(pNext_loc.dot(Field::pPipelineCreationFeedback), structure->pPipelineCreationFeedback,
                                            "VUID-VkPipelineCreationFeedbackCreateInfo-pPipelineCreationFeedback-parameter");

                if (structure->pPipelineCreationFeedback != nullptr) {
                    [[maybe_unused]] const Location pPipelineCreationFeedback_loc = pNext_loc.dot(Field::pPipelineCreationFeedback);
                }

                skip |= ValidateArray(
                    pNext_loc.dot(Field::pipelineStageCreationFeedbackCount), pNext_loc.dot(Field::pPipelineStageCreationFeedbacks),
                    structure->pipelineStageCreationFeedbackCount, &structure->pPipelineStageCreationFeedbacks, false, true,
                    kVUIDUndefined, "VUID-VkPipelineCreationFeedbackCreateInfo-pPipelineStageCreationFeedbacks-parameter");

                if (structure->pPipelineStageCreationFeedbacks != nullptr) {
                    for (uint32_t pipelineStageCreationFeedbackIndex = 0;
                         pipelineStageCreationFeedbackIndex < structure->pipelineStageCreationFeedbackCount;
                         ++pipelineStageCreationFeedbackIndex) {
                        [[maybe_unused]] const Location pPipelineStageCreationFeedbacks_loc =
                            pNext_loc.dot(Field::pPipelineStageCreationFeedbacks, pipelineStageCreationFeedbackIndex);
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderTerminateInvocationFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {  // Covers
                                                                                        // VUID-VkPhysicalDeviceShaderTerminateInvocationFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_terminate_invocation))) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType "
                             "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES), but its parent extension "
                             "VK_KHR_shader_terminate_invocation has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderTerminateInvocationFeatures);
                VkPhysicalDeviceShaderTerminateInvocationFeatures* structure =
                    (VkPhysicalDeviceShaderTerminateInvocationFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderTerminateInvocation), structure->shaderTerminateInvocation);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {  // Covers
                                                                                               // VUID-VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_shader_demote_to_helper_invocation))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES), but its parent extension "
                    "VK_EXT_shader_demote_to_helper_invocation has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures);
                VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* structure =
                    (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*)header;
                skip |=
                    ValidateBool32(pNext_loc.dot(Field::shaderDemoteToHelperInvocation), structure->shaderDemoteToHelperInvocation);
            }
        } break;

        // Validation code for VkPhysicalDevicePrivateDataFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {  // Covers
                                                                         // VUID-VkPhysicalDevicePrivateDataFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PRIVATE_DATA_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_private_data))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES), but its parent extension "
                                 "VK_EXT_private_data has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePrivateDataFeatures);
                VkPhysicalDevicePrivateDataFeatures* structure = (VkPhysicalDevicePrivateDataFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::privateData), structure->privateData);
            }
        } break;

        // Validation code for VkDevicePrivateDataCreateInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: {  // Covers VUID-VkDevicePrivateDataCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PRIVATE_DATA_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_private_data))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_EXT_private_data has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineCreationCacheControlFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {  // Covers
                                                                                            // VUID-VkPhysicalDevicePipelineCreationCacheControlFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_pipeline_creation_cache_control))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES), but its parent extension "
                    "VK_EXT_pipeline_creation_cache_control has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePipelineCreationCacheControlFeatures);
                VkPhysicalDevicePipelineCreationCacheControlFeatures* structure =
                    (VkPhysicalDevicePipelineCreationCacheControlFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineCreationCacheControl), structure->pipelineCreationCacheControl);
            }
        } break;

        // Validation code for VkMemoryBarrier2 structure members
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: {  // Covers VUID-VkMemoryBarrier2-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_synchronization2))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_BARRIER_2), but its parent extension "
                    "VK_KHR_synchronization2 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkMemoryBarrier2);
                VkMemoryBarrier2* structure = (VkMemoryBarrier2*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2,
                                      structure->srcStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      structure->srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2,
                                      structure->dstStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      structure->dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSynchronization2Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {  // Covers
                                                                              // VUID-VkPhysicalDeviceSynchronization2Features-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_synchronization2))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES), but its parent extension "
                                 "VK_KHR_synchronization2 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSynchronization2Features);
                VkPhysicalDeviceSynchronization2Features* structure = (VkPhysicalDeviceSynchronization2Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::synchronization2), structure->synchronization2);
            }
        } break;

        // Validation code for VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {  // Covers
                                                                                             // VUID-VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_zero_initialize_workgroup_memory))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES), but its parent extension "
                    "VK_KHR_zero_initialize_workgroup_memory has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures);
                VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* structure =
                    (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderZeroInitializeWorkgroupMemory),
                                       structure->shaderZeroInitializeWorkgroupMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageRobustnessFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {  // Covers
                                                                             // VUID-VkPhysicalDeviceImageRobustnessFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_image_robustness))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES), but its parent extension "
                                 "VK_EXT_image_robustness has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageRobustnessFeatures);
                VkPhysicalDeviceImageRobustnessFeatures* structure = (VkPhysicalDeviceImageRobustnessFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::robustImageAccess), structure->robustImageAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceSubgroupSizeControlFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceSubgroupSizeControlFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_subgroup_size_control))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES), but its parent extension "
                                 "VK_EXT_subgroup_size_control has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSubgroupSizeControlFeatures);
                VkPhysicalDeviceSubgroupSizeControlFeatures* structure = (VkPhysicalDeviceSubgroupSizeControlFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::subgroupSizeControl), structure->subgroupSizeControl);

                skip |= ValidateBool32(pNext_loc.dot(Field::computeFullSubgroups), structure->computeFullSubgroups);
            }
        } break;

        // Validation code for VkPhysicalDeviceSubgroupSizeControlProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceSubgroupSizeControlProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_subgroup_size_control))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES), but its parent extension "
                                 "VK_EXT_subgroup_size_control has not been enabled.");
            }
        } break;

        // Validation code for VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: {  // Covers
                                                                                            // VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_subgroup_size_control))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType "
                    "(VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO), but its parent extension "
                    "VK_EXT_subgroup_size_control has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceInlineUniformBlockFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceInlineUniformBlockFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES), but its parent extension "
                                 "VK_EXT_inline_uniform_block has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceInlineUniformBlockFeatures);
                VkPhysicalDeviceInlineUniformBlockFeatures* structure = (VkPhysicalDeviceInlineUniformBlockFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::inlineUniformBlock), structure->inlineUniformBlock);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingInlineUniformBlockUpdateAfterBind),
                                       structure->descriptorBindingInlineUniformBlockUpdateAfterBind);
            }
        } break;

        // Validation code for VkPhysicalDeviceInlineUniformBlockProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceInlineUniformBlockProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES), but its parent extension "
                                 "VK_EXT_inline_uniform_block has not been enabled.");
            }
        } break;

        // Validation code for VkWriteDescriptorSetInlineUniformBlock structure members
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: {  // Covers
                                                                             // VUID-VkWriteDescriptorSetInlineUniformBlock-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK), but its parent extension "
                                 "VK_EXT_inline_uniform_block has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkWriteDescriptorSetInlineUniformBlock);
                VkWriteDescriptorSetInlineUniformBlock* structure = (VkWriteDescriptorSetInlineUniformBlock*)header;
                skip |=
                    ValidateArray(pNext_loc.dot(Field::dataSize), pNext_loc.dot(Field::pData), structure->dataSize,
                                  &structure->pData, true, true, "VUID-VkWriteDescriptorSetInlineUniformBlock-dataSize-arraylength",
                                  "VUID-VkWriteDescriptorSetInlineUniformBlock-pData-parameter");
            }
        } break;

        // Validation code for VkDescriptorPoolInlineUniformBlockCreateInfo structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: {  // Covers
                                                                                    // VUID-VkDescriptorPoolInlineUniformBlockCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO), but its parent extension "
                                 "VK_EXT_inline_uniform_block has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceTextureCompressionASTCHDRFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceTextureCompressionASTCHDRFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_texture_compression_astc_hdr))) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType "
                             "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES), but its parent extension "
                             "VK_EXT_texture_compression_astc_hdr has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceTextureCompressionASTCHDRFeatures);
                VkPhysicalDeviceTextureCompressionASTCHDRFeatures* structure =
                    (VkPhysicalDeviceTextureCompressionASTCHDRFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::textureCompressionASTC_HDR), structure->textureCompressionASTC_HDR);
            }
        } break;

        // Validation code for VkPipelineRenderingCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: {  // Covers VUID-VkPipelineRenderingCreateInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO), but "
                                 "its parent extension "
                                 "VK_KHR_dynamic_rendering has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceDynamicRenderingFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {  // Covers
                                                                              // VUID-VkPhysicalDeviceDynamicRenderingFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES), but its parent extension "
                                 "VK_KHR_dynamic_rendering has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDynamicRenderingFeatures);
                VkPhysicalDeviceDynamicRenderingFeatures* structure = (VkPhysicalDeviceDynamicRenderingFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::dynamicRendering), structure->dynamicRendering);
            }
        } break;

        // Validation code for VkCommandBufferInheritanceRenderingInfo structure members
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: {  // Covers
                                                                             // VUID-VkCommandBufferInheritanceRenderingInfo-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO), but its parent extension "
                                 "VK_KHR_dynamic_rendering has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkCommandBufferInheritanceRenderingInfo);
                VkCommandBufferInheritanceRenderingInfo* structure = (VkCommandBufferInheritanceRenderingInfo*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkRenderingFlagBits", AllVkRenderingFlagBits, structure->flags,
                                      kOptionalFlags, "VUID-VkCommandBufferInheritanceRenderingInfo-flags-parameter");

                skip |= ValidateRangedEnumArray(pNext_loc.dot(Field::colorAttachmentCount),
                                                pNext_loc.dot(Field::pColorAttachmentFormats), "VkFormat",
                                                structure->colorAttachmentCount, structure->pColorAttachmentFormats, false, true);

                skip |=
                    ValidateRangedEnum(pNext_loc.dot(Field::depthAttachmentFormat), "VkFormat", structure->depthAttachmentFormat,
                                       "VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::stencilAttachmentFormat), "VkFormat",
                                           structure->stencilAttachmentFormat,
                                           "VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::rasterizationSamples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                                      structure->rasterizationSamples, kOptionalSingleBit,
                                      "VUID-VkCommandBufferInheritanceRenderingInfo-rasterizationSamples-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderIntegerDotProductFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceShaderIntegerDotProductFeatures-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_integer_dot_product))) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType "
                             "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES), but its parent extension "
                             "VK_KHR_shader_integer_dot_product has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderIntegerDotProductFeatures);
                VkPhysicalDeviceShaderIntegerDotProductFeatures* structure =
                    (VkPhysicalDeviceShaderIntegerDotProductFeatures*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderIntegerDotProduct), structure->shaderIntegerDotProduct);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderIntegerDotProductProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceShaderIntegerDotProductProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_integer_dot_product))) {
                skip |=
                    LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                             "includes a pointer to a VkStructureType "
                             "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES), but its parent extension "
                             "VK_KHR_shader_integer_dot_product has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceTexelBufferAlignmentProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceTexelBufferAlignmentProperties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_texel_buffer_alignment))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES), but its parent extension "
                                 "VK_EXT_texel_buffer_alignment has not been enabled.");
            }
        } break;

        // Validation code for VkFormatProperties3 structure members
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: {  // Covers VUID-VkFormatProperties3-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_FORMAT_FEATURE_FLAGS_2_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_format_feature_flags2))) {
                skip |= LogError(
                    pnext_vuid, instance, loc.dot(Field::pNext),
                    "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3), but its parent extension "
                    "VK_KHR_format_feature_flags2 has not been enabled.");
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance4Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {  // Covers
                                                                          // VUID-VkPhysicalDeviceMaintenance4Features-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_4_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance4))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES), but its parent extension "
                                 "VK_KHR_maintenance4 has not been enabled.");
            }
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMaintenance4Features);
                VkPhysicalDeviceMaintenance4Features* structure = (VkPhysicalDeviceMaintenance4Features*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::maintenance4), structure->maintenance4);
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance4Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: {  // Covers
                                                                            // VUID-VkPhysicalDeviceMaintenance4Properties-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_4_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance4))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType "
                                 "(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES), but its parent extension "
                                 "VK_KHR_maintenance4 has not been enabled.");
            }
        } break;

        // No Validation code for VkImageSwapchainCreateInfoKHR structure members  -- Covers
        // VUID-VkImageSwapchainCreateInfoKHR-sType-sType

        // Validation code for VkBindImageMemorySwapchainInfoKHR structure members
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: {  // Covers VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBindImageMemorySwapchainInfoKHR);
                VkBindImageMemorySwapchainInfoKHR* structure = (VkBindImageMemorySwapchainInfoKHR*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::swapchain), structure->swapchain);
            }
        } break;

        // Validation code for VkDeviceGroupPresentInfoKHR structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: {  // Covers VUID-VkDeviceGroupPresentInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceGroupPresentInfoKHR);
                VkDeviceGroupPresentInfoKHR* structure = (VkDeviceGroupPresentInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::swapchainCount), pNext_loc.dot(Field::pDeviceMasks),
                                      structure->swapchainCount, &structure->pDeviceMasks, false, true, kVUIDUndefined,
                                      "VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::mode), "VkDeviceGroupPresentModeFlagBitsKHR",
                                      AllVkDeviceGroupPresentModeFlagBitsKHR, structure->mode, kRequiredSingleBit,
                                      "VUID-VkDeviceGroupPresentInfoKHR-mode-parameter",
                                      "VUID-VkDeviceGroupPresentInfoKHR-mode-parameter");
            }
        } break;

        // Validation code for VkDeviceGroupSwapchainCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR: {  // Covers
                                                                          // VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceGroupSwapchainCreateInfoKHR);
                VkDeviceGroupSwapchainCreateInfoKHR* structure = (VkDeviceGroupSwapchainCreateInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::modes), "VkDeviceGroupPresentModeFlagBitsKHR",
                                      AllVkDeviceGroupPresentModeFlagBitsKHR, structure->modes, kRequiredFlags,
                                      "VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter",
                                      "VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask");
            }
        } break;

        // Validation code for VkDisplayPresentInfoKHR structure members
        case VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: {  // Covers VUID-VkDisplayPresentInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDisplayPresentInfoKHR);
                VkDisplayPresentInfoKHR* structure = (VkDisplayPresentInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::persistent), structure->persistent);
            }
        } break;

        // No Validation code for VkQueueFamilyQueryResultStatusPropertiesKHR structure members  -- Covers
        // VUID-VkQueueFamilyQueryResultStatusPropertiesKHR-sType-sType

        // No Validation code for VkQueueFamilyVideoPropertiesKHR structure members  -- Covers
        // VUID-VkQueueFamilyVideoPropertiesKHR-sType-sType

        // Validation code for VkVideoProfileInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR: {  // Covers VUID-VkVideoProfileInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoProfileInfoKHR);
                VkVideoProfileInfoKHR* structure = (VkVideoProfileInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::videoCodecOperation), "VkVideoCodecOperationFlagBitsKHR",
                                      AllVkVideoCodecOperationFlagBitsKHR, structure->videoCodecOperation, kRequiredSingleBit,
                                      "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter",
                                      "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::chromaSubsampling), "VkVideoChromaSubsamplingFlagBitsKHR",
                                      AllVkVideoChromaSubsamplingFlagBitsKHR, structure->chromaSubsampling, kRequiredFlags,
                                      "VUID-VkVideoProfileInfoKHR-chromaSubsampling-parameter",
                                      "VUID-VkVideoProfileInfoKHR-chromaSubsampling-requiredbitmask");

                skip |= ValidateFlags(pNext_loc.dot(Field::lumaBitDepth), "VkVideoComponentBitDepthFlagBitsKHR",
                                      AllVkVideoComponentBitDepthFlagBitsKHR, structure->lumaBitDepth, kRequiredFlags,
                                      "VUID-VkVideoProfileInfoKHR-lumaBitDepth-parameter",
                                      "VUID-VkVideoProfileInfoKHR-lumaBitDepth-requiredbitmask");

                skip |= ValidateFlags(pNext_loc.dot(Field::chromaBitDepth), "VkVideoComponentBitDepthFlagBitsKHR",
                                      AllVkVideoComponentBitDepthFlagBitsKHR, structure->chromaBitDepth, kOptionalFlags,
                                      "VUID-VkVideoProfileInfoKHR-chromaBitDepth-parameter");
            }
        } break;

        // Validation code for VkVideoProfileListInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR: {  // Covers VUID-VkVideoProfileListInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoProfileListInfoKHR);
                VkVideoProfileListInfoKHR* structure = (VkVideoProfileListInfoKHR*)header;
                skip |= ValidateStructTypeArray(
                    pNext_loc.dot(Field::profileCount), pNext_loc.dot(Field::pProfiles), "VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR",
                    structure->profileCount, structure->pProfiles, VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR, false, true,
                    "VUID-VkVideoProfileInfoKHR-sType-sType", "VUID-VkVideoProfileListInfoKHR-pProfiles-parameter", kVUIDUndefined);

                if (structure->pProfiles != nullptr) {
                    for (uint32_t profileIndex = 0; profileIndex < structure->profileCount; ++profileIndex) {
                        [[maybe_unused]] const Location pProfiles_loc = pNext_loc.dot(Field::pProfiles, profileIndex);
                        skip |= ValidateFlags(pProfiles_loc.dot(Field::videoCodecOperation), "VkVideoCodecOperationFlagBitsKHR",
                                              AllVkVideoCodecOperationFlagBitsKHR,
                                              structure->pProfiles[profileIndex].videoCodecOperation, kRequiredSingleBit,
                                              "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter",
                                              "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter");

                        skip |= ValidateFlags(pProfiles_loc.dot(Field::chromaSubsampling), "VkVideoChromaSubsamplingFlagBitsKHR",
                                              AllVkVideoChromaSubsamplingFlagBitsKHR,
                                              structure->pProfiles[profileIndex].chromaSubsampling, kRequiredFlags,
                                              "VUID-VkVideoProfileInfoKHR-chromaSubsampling-parameter",
                                              "VUID-VkVideoProfileInfoKHR-chromaSubsampling-requiredbitmask");

                        skip |=
                            ValidateFlags(pProfiles_loc.dot(Field::lumaBitDepth), "VkVideoComponentBitDepthFlagBitsKHR",
                                          AllVkVideoComponentBitDepthFlagBitsKHR, structure->pProfiles[profileIndex].lumaBitDepth,
                                          kRequiredFlags, "VUID-VkVideoProfileInfoKHR-lumaBitDepth-parameter",
                                          "VUID-VkVideoProfileInfoKHR-lumaBitDepth-requiredbitmask");

                        skip |=
                            ValidateFlags(pProfiles_loc.dot(Field::chromaBitDepth), "VkVideoComponentBitDepthFlagBitsKHR",
                                          AllVkVideoComponentBitDepthFlagBitsKHR, structure->pProfiles[profileIndex].chromaBitDepth,
                                          kOptionalFlags, "VUID-VkVideoProfileInfoKHR-chromaBitDepth-parameter");
                    }
                }
            }
        } break;

        // No Validation code for VkVideoDecodeCapabilitiesKHR structure members  -- Covers
        // VUID-VkVideoDecodeCapabilitiesKHR-sType-sType

        // Validation code for VkVideoDecodeUsageInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR: {  // Covers VUID-VkVideoDecodeUsageInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeUsageInfoKHR);
                VkVideoDecodeUsageInfoKHR* structure = (VkVideoDecodeUsageInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::videoUsageHints), "VkVideoDecodeUsageFlagBitsKHR",
                                      AllVkVideoDecodeUsageFlagBitsKHR, structure->videoUsageHints, kOptionalFlags,
                                      "VUID-VkVideoDecodeUsageInfoKHR-videoUsageHints-parameter");
            }
        } break;

        // No Validation code for VkVideoEncodeH264CapabilitiesKHR structure members  -- Covers
        // VUID-VkVideoEncodeH264CapabilitiesKHR-sType-sType

        // No Validation code for VkVideoEncodeH264QualityLevelPropertiesKHR structure members  -- Covers
        // VUID-VkVideoEncodeH264QualityLevelPropertiesKHR-sType-sType

        // Validation code for VkVideoEncodeH264SessionCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR: {  // Covers
                                                                             // VUID-VkVideoEncodeH264SessionCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264SessionCreateInfoKHR);
                VkVideoEncodeH264SessionCreateInfoKHR* structure = (VkVideoEncodeH264SessionCreateInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::useMaxLevelIdc), structure->useMaxLevelIdc);
            }
        } break;

        // No Validation code for VkVideoEncodeH264SessionParametersAddInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeH264SessionParametersAddInfoKHR-sType-sType

        // Validation code for VkVideoEncodeH264SessionParametersCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR: {  // Covers
                                                                                        // VUID-VkVideoEncodeH264SessionParametersCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264SessionParametersCreateInfoKHR);
                VkVideoEncodeH264SessionParametersCreateInfoKHR* structure =
                    (VkVideoEncodeH264SessionParametersCreateInfoKHR*)header;
                skip |= ValidateStructType(
                    pNext_loc.dot(Field::pParametersAddInfo), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR",
                    structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR, false,
                    "VUID-VkVideoEncodeH264SessionParametersCreateInfoKHR-pParametersAddInfo-parameter",
                    "VUID-VkVideoEncodeH264SessionParametersAddInfoKHR-sType-sType");

                if (structure->pParametersAddInfo != nullptr) {
                    [[maybe_unused]] const Location pParametersAddInfo_loc = pNext_loc.dot(Field::pParametersAddInfo);
                }
            }
        } break;

        // Validation code for VkVideoEncodeH264SessionParametersGetInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR: {  // Covers
                                                                                     // VUID-VkVideoEncodeH264SessionParametersGetInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264SessionParametersGetInfoKHR);
                VkVideoEncodeH264SessionParametersGetInfoKHR* structure = (VkVideoEncodeH264SessionParametersGetInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::writeStdSPS), structure->writeStdSPS);

                skip |= ValidateBool32(pNext_loc.dot(Field::writeStdPPS), structure->writeStdPPS);
            }
        } break;

        // No Validation code for VkVideoEncodeH264SessionParametersFeedbackInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeH264SessionParametersFeedbackInfoKHR-sType-sType

        // Validation code for VkVideoEncodeH264PictureInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR: {  // Covers VUID-VkVideoEncodeH264PictureInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264PictureInfoKHR);
                VkVideoEncodeH264PictureInfoKHR* structure = (VkVideoEncodeH264PictureInfoKHR*)header;
                skip |= ValidateStructTypeArray(pNext_loc.dot(Field::naluSliceEntryCount), pNext_loc.dot(Field::pNaluSliceEntries),
                                                "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR",
                                                structure->naluSliceEntryCount, structure->pNaluSliceEntries,
                                                VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR, true, true,
                                                "VUID-VkVideoEncodeH264NaluSliceInfoKHR-sType-sType",
                                                "VUID-VkVideoEncodeH264PictureInfoKHR-pNaluSliceEntries-parameter",
                                                "VUID-VkVideoEncodeH264PictureInfoKHR-naluSliceEntryCount-arraylength");

                if (structure->pNaluSliceEntries != nullptr) {
                    for (uint32_t naluSliceEntryIndex = 0; naluSliceEntryIndex < structure->naluSliceEntryCount;
                         ++naluSliceEntryIndex) {
                        [[maybe_unused]] const Location pNaluSliceEntries_loc =
                            pNext_loc.dot(Field::pNaluSliceEntries, naluSliceEntryIndex);
                        skip |= ValidateRequiredPointer(pNaluSliceEntries_loc.dot(Field::pStdSliceHeader),
                                                        structure->pNaluSliceEntries[naluSliceEntryIndex].pStdSliceHeader,
                                                        "VUID-VkVideoEncodeH264NaluSliceInfoKHR-pStdSliceHeader-parameter");
                    }
                }

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdPictureInfo), structure->pStdPictureInfo,
                                                "VUID-VkVideoEncodeH264PictureInfoKHR-pStdPictureInfo-parameter");

                skip |= ValidateBool32(pNext_loc.dot(Field::generatePrefixNalu), structure->generatePrefixNalu);
            }
        } break;

        // Validation code for VkVideoEncodeH264DpbSlotInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR: {  // Covers VUID-VkVideoEncodeH264DpbSlotInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264DpbSlotInfoKHR);
                VkVideoEncodeH264DpbSlotInfoKHR* structure = (VkVideoEncodeH264DpbSlotInfoKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdReferenceInfo), structure->pStdReferenceInfo,
                                                "VUID-VkVideoEncodeH264DpbSlotInfoKHR-pStdReferenceInfo-parameter");
            }
        } break;

        // No Validation code for VkVideoEncodeH264ProfileInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeH264ProfileInfoKHR-sType-sType

        // Validation code for VkVideoEncodeH264RateControlInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR: {  // Covers
                                                                           // VUID-VkVideoEncodeH264RateControlInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264RateControlInfoKHR);
                VkVideoEncodeH264RateControlInfoKHR* structure = (VkVideoEncodeH264RateControlInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkVideoEncodeH264RateControlFlagBitsKHR",
                                      AllVkVideoEncodeH264RateControlFlagBitsKHR, structure->flags, kOptionalFlags,
                                      "VUID-VkVideoEncodeH264RateControlInfoKHR-flags-parameter");
            }
        } break;

        // Validation code for VkVideoEncodeH264RateControlLayerInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR: {  // Covers
                                                                                 // VUID-VkVideoEncodeH264RateControlLayerInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264RateControlLayerInfoKHR);
                VkVideoEncodeH264RateControlLayerInfoKHR* structure = (VkVideoEncodeH264RateControlLayerInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::useMinQp), structure->useMinQp);

                skip |= ValidateBool32(pNext_loc.dot(Field::useMaxQp), structure->useMaxQp);

                skip |= ValidateBool32(pNext_loc.dot(Field::useMaxFrameSize), structure->useMaxFrameSize);
            }
        } break;

        // Validation code for VkVideoEncodeH264GopRemainingFrameInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR: {  // Covers
                                                                                  // VUID-VkVideoEncodeH264GopRemainingFrameInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH264GopRemainingFrameInfoKHR);
                VkVideoEncodeH264GopRemainingFrameInfoKHR* structure = (VkVideoEncodeH264GopRemainingFrameInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::useGopRemainingFrames), structure->useGopRemainingFrames);
            }
        } break;

        // No Validation code for VkVideoEncodeH265CapabilitiesKHR structure members  -- Covers
        // VUID-VkVideoEncodeH265CapabilitiesKHR-sType-sType

        // Validation code for VkVideoEncodeH265SessionCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR: {  // Covers
                                                                             // VUID-VkVideoEncodeH265SessionCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265SessionCreateInfoKHR);
                VkVideoEncodeH265SessionCreateInfoKHR* structure = (VkVideoEncodeH265SessionCreateInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::useMaxLevelIdc), structure->useMaxLevelIdc);
            }
        } break;

        // No Validation code for VkVideoEncodeH265QualityLevelPropertiesKHR structure members  -- Covers
        // VUID-VkVideoEncodeH265QualityLevelPropertiesKHR-sType-sType

        // No Validation code for VkVideoEncodeH265SessionParametersAddInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeH265SessionParametersAddInfoKHR-sType-sType

        // Validation code for VkVideoEncodeH265SessionParametersCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR: {  // Covers
                                                                                        // VUID-VkVideoEncodeH265SessionParametersCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265SessionParametersCreateInfoKHR);
                VkVideoEncodeH265SessionParametersCreateInfoKHR* structure =
                    (VkVideoEncodeH265SessionParametersCreateInfoKHR*)header;
                skip |= ValidateStructType(
                    pNext_loc.dot(Field::pParametersAddInfo), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR",
                    structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR, false,
                    "VUID-VkVideoEncodeH265SessionParametersCreateInfoKHR-pParametersAddInfo-parameter",
                    "VUID-VkVideoEncodeH265SessionParametersAddInfoKHR-sType-sType");

                if (structure->pParametersAddInfo != nullptr) {
                    [[maybe_unused]] const Location pParametersAddInfo_loc = pNext_loc.dot(Field::pParametersAddInfo);
                }
            }
        } break;

        // Validation code for VkVideoEncodeH265SessionParametersGetInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR: {  // Covers
                                                                                     // VUID-VkVideoEncodeH265SessionParametersGetInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265SessionParametersGetInfoKHR);
                VkVideoEncodeH265SessionParametersGetInfoKHR* structure = (VkVideoEncodeH265SessionParametersGetInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::writeStdVPS), structure->writeStdVPS);

                skip |= ValidateBool32(pNext_loc.dot(Field::writeStdSPS), structure->writeStdSPS);

                skip |= ValidateBool32(pNext_loc.dot(Field::writeStdPPS), structure->writeStdPPS);
            }
        } break;

        // No Validation code for VkVideoEncodeH265SessionParametersFeedbackInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeH265SessionParametersFeedbackInfoKHR-sType-sType

        // Validation code for VkVideoEncodeH265PictureInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR: {  // Covers VUID-VkVideoEncodeH265PictureInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265PictureInfoKHR);
                VkVideoEncodeH265PictureInfoKHR* structure = (VkVideoEncodeH265PictureInfoKHR*)header;
                skip |= ValidateStructTypeArray(
                    pNext_loc.dot(Field::naluSliceSegmentEntryCount), pNext_loc.dot(Field::pNaluSliceSegmentEntries),
                    "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR", structure->naluSliceSegmentEntryCount,
                    structure->pNaluSliceSegmentEntries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR, true,
                    true, "VUID-VkVideoEncodeH265NaluSliceSegmentInfoKHR-sType-sType",
                    "VUID-VkVideoEncodeH265PictureInfoKHR-pNaluSliceSegmentEntries-parameter",
                    "VUID-VkVideoEncodeH265PictureInfoKHR-naluSliceSegmentEntryCount-arraylength");

                if (structure->pNaluSliceSegmentEntries != nullptr) {
                    for (uint32_t naluSliceSegmentEntryIndex = 0;
                         naluSliceSegmentEntryIndex < structure->naluSliceSegmentEntryCount; ++naluSliceSegmentEntryIndex) {
                        [[maybe_unused]] const Location pNaluSliceSegmentEntries_loc =
                            pNext_loc.dot(Field::pNaluSliceSegmentEntries, naluSliceSegmentEntryIndex);
                        skip |= ValidateRequiredPointer(
                            pNaluSliceSegmentEntries_loc.dot(Field::pStdSliceSegmentHeader),
                            structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pStdSliceSegmentHeader,
                            "VUID-VkVideoEncodeH265NaluSliceSegmentInfoKHR-pStdSliceSegmentHeader-parameter");
                    }
                }

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdPictureInfo), structure->pStdPictureInfo,
                                                "VUID-VkVideoEncodeH265PictureInfoKHR-pStdPictureInfo-parameter");
            }
        } break;

        // Validation code for VkVideoEncodeH265DpbSlotInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR: {  // Covers VUID-VkVideoEncodeH265DpbSlotInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265DpbSlotInfoKHR);
                VkVideoEncodeH265DpbSlotInfoKHR* structure = (VkVideoEncodeH265DpbSlotInfoKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdReferenceInfo), structure->pStdReferenceInfo,
                                                "VUID-VkVideoEncodeH265DpbSlotInfoKHR-pStdReferenceInfo-parameter");
            }
        } break;

        // No Validation code for VkVideoEncodeH265ProfileInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeH265ProfileInfoKHR-sType-sType

        // Validation code for VkVideoEncodeH265RateControlInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR: {  // Covers
                                                                           // VUID-VkVideoEncodeH265RateControlInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265RateControlInfoKHR);
                VkVideoEncodeH265RateControlInfoKHR* structure = (VkVideoEncodeH265RateControlInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkVideoEncodeH265RateControlFlagBitsKHR",
                                      AllVkVideoEncodeH265RateControlFlagBitsKHR, structure->flags, kOptionalFlags,
                                      "VUID-VkVideoEncodeH265RateControlInfoKHR-flags-parameter");
            }
        } break;

        // Validation code for VkVideoEncodeH265RateControlLayerInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR: {  // Covers
                                                                                 // VUID-VkVideoEncodeH265RateControlLayerInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265RateControlLayerInfoKHR);
                VkVideoEncodeH265RateControlLayerInfoKHR* structure = (VkVideoEncodeH265RateControlLayerInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::useMinQp), structure->useMinQp);

                skip |= ValidateBool32(pNext_loc.dot(Field::useMaxQp), structure->useMaxQp);

                skip |= ValidateBool32(pNext_loc.dot(Field::useMaxFrameSize), structure->useMaxFrameSize);
            }
        } break;

        // Validation code for VkVideoEncodeH265GopRemainingFrameInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR: {  // Covers
                                                                                  // VUID-VkVideoEncodeH265GopRemainingFrameInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeH265GopRemainingFrameInfoKHR);
                VkVideoEncodeH265GopRemainingFrameInfoKHR* structure = (VkVideoEncodeH265GopRemainingFrameInfoKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::useGopRemainingFrames), structure->useGopRemainingFrames);
            }
        } break;

        // Validation code for VkVideoDecodeH264ProfileInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR: {  // Covers VUID-VkVideoDecodeH264ProfileInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH264ProfileInfoKHR);
                VkVideoDecodeH264ProfileInfoKHR* structure = (VkVideoDecodeH264ProfileInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::pictureLayout), "VkVideoDecodeH264PictureLayoutFlagBitsKHR",
                                      AllVkVideoDecodeH264PictureLayoutFlagBitsKHR, structure->pictureLayout, kOptionalSingleBit,
                                      "VUID-VkVideoDecodeH264ProfileInfoKHR-pictureLayout-parameter");
            }
        } break;

        // No Validation code for VkVideoDecodeH264CapabilitiesKHR structure members  -- Covers
        // VUID-VkVideoDecodeH264CapabilitiesKHR-sType-sType

        // Validation code for VkVideoDecodeH264SessionParametersAddInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR: {  // Covers
                                                                                     // VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH264SessionParametersAddInfoKHR);
                VkVideoDecodeH264SessionParametersAddInfoKHR* structure = (VkVideoDecodeH264SessionParametersAddInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::stdSPSCount), pNext_loc.dot(Field::pStdSPSs), structure->stdSPSCount,
                                      &structure->pStdSPSs, false, true, kVUIDUndefined,
                                      "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdSPSs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::stdPPSCount), pNext_loc.dot(Field::pStdPPSs), structure->stdPPSCount,
                                      &structure->pStdPPSs, false, true, kVUIDUndefined,
                                      "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdPPSs-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH264SessionParametersCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR: {  // Covers
                                                                                        // VUID-VkVideoDecodeH264SessionParametersCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH264SessionParametersCreateInfoKHR);
                VkVideoDecodeH264SessionParametersCreateInfoKHR* structure =
                    (VkVideoDecodeH264SessionParametersCreateInfoKHR*)header;
                skip |= ValidateStructType(
                    pNext_loc.dot(Field::pParametersAddInfo), "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR",
                    structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR, false,
                    "VUID-VkVideoDecodeH264SessionParametersCreateInfoKHR-pParametersAddInfo-parameter",
                    "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-sType-sType");

                if (structure->pParametersAddInfo != nullptr) {
                    [[maybe_unused]] const Location pParametersAddInfo_loc = pNext_loc.dot(Field::pParametersAddInfo);
                    skip |=
                        ValidateArray(pParametersAddInfo_loc.dot(Field::stdSPSCount), pParametersAddInfo_loc.dot(Field::pStdSPSs),
                                      structure->pParametersAddInfo->stdSPSCount, &structure->pParametersAddInfo->pStdSPSs, false,
                                      true, kVUIDUndefined, "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdSPSs-parameter");

                    skip |=
                        ValidateArray(pParametersAddInfo_loc.dot(Field::stdPPSCount), pParametersAddInfo_loc.dot(Field::pStdPPSs),
                                      structure->pParametersAddInfo->stdPPSCount, &structure->pParametersAddInfo->pStdPPSs, false,
                                      true, kVUIDUndefined, "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdPPSs-parameter");
                }
            }
        } break;

        // Validation code for VkVideoDecodeH264PictureInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR: {  // Covers VUID-VkVideoDecodeH264PictureInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH264PictureInfoKHR);
                VkVideoDecodeH264PictureInfoKHR* structure = (VkVideoDecodeH264PictureInfoKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdPictureInfo), structure->pStdPictureInfo,
                                                "VUID-VkVideoDecodeH264PictureInfoKHR-pStdPictureInfo-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::sliceCount), pNext_loc.dot(Field::pSliceOffsets), structure->sliceCount,
                                      &structure->pSliceOffsets, true, true,
                                      "VUID-VkVideoDecodeH264PictureInfoKHR-sliceCount-arraylength",
                                      "VUID-VkVideoDecodeH264PictureInfoKHR-pSliceOffsets-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH264DpbSlotInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR: {  // Covers VUID-VkVideoDecodeH264DpbSlotInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH264DpbSlotInfoKHR);
                VkVideoDecodeH264DpbSlotInfoKHR* structure = (VkVideoDecodeH264DpbSlotInfoKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdReferenceInfo), structure->pStdReferenceInfo,
                                                "VUID-VkVideoDecodeH264DpbSlotInfoKHR-pStdReferenceInfo-parameter");
            }
        } break;

        // Validation code for VkRenderingFragmentShadingRateAttachmentInfoKHR structure members
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {  // Covers
                                                                                       // VUID-VkRenderingFragmentShadingRateAttachmentInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderingFragmentShadingRateAttachmentInfoKHR);
                VkRenderingFragmentShadingRateAttachmentInfoKHR* structure =
                    (VkRenderingFragmentShadingRateAttachmentInfoKHR*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::imageLayout), "VkImageLayout", structure->imageLayout,
                                           "VUID-VkRenderingFragmentShadingRateAttachmentInfoKHR-imageLayout-parameter");
            }
        } break;

        // Validation code for VkRenderingFragmentDensityMapAttachmentInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: {  // Covers
                                                                                      // VUID-VkRenderingFragmentDensityMapAttachmentInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderingFragmentDensityMapAttachmentInfoEXT);
                VkRenderingFragmentDensityMapAttachmentInfoEXT* structure = (VkRenderingFragmentDensityMapAttachmentInfoEXT*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::imageView), structure->imageView);

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::imageLayout), "VkImageLayout", structure->imageLayout,
                                           "VUID-VkRenderingFragmentDensityMapAttachmentInfoEXT-imageLayout-parameter");
            }
        } break;

        // Validation code for VkAttachmentSampleCountInfoAMD structure members
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: {  // Covers VUID-VkAttachmentSampleCountInfoAMD-sType-sType

            if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) ||
                (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                skip |= LogError(pnext_vuid, instance, loc.dot(Field::pNext),
                                 "includes a pointer to a VkStructureType (VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD), "
                                 "but its parent extension "
                                 "VK_KHR_dynamic_rendering has not been enabled.");
            }
        } break;

        // Validation code for VkMultiviewPerViewAttributesInfoNVX structure members
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: {  // Covers
                                                                          // VUID-VkMultiviewPerViewAttributesInfoNVX-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkMultiviewPerViewAttributesInfoNVX);
                VkMultiviewPerViewAttributesInfoNVX* structure = (VkMultiviewPerViewAttributesInfoNVX*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::perViewAttributes), structure->perViewAttributes);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::perViewAttributesPositionXOnly), structure->perViewAttributesPositionXOnly);
            }
        } break;
#ifdef VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkImportMemoryWin32HandleInfoKHR structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: {  // Covers VUID-VkImportMemoryWin32HandleInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMemoryWin32HandleInfoKHR);
                VkImportMemoryWin32HandleInfoKHR* structure = (VkImportMemoryWin32HandleInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit,
                                      "VUID-VkImportMemoryWin32HandleInfoKHR-handleType-parameter");
            }
        } break;

        // No Validation code for VkExportMemoryWin32HandleInfoKHR structure members  -- Covers
        // VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType
#endif  // VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkImportMemoryFdInfoKHR structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: {  // Covers VUID-VkImportMemoryFdInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMemoryFdInfoKHR);
                VkImportMemoryFdInfoKHR* structure = (VkImportMemoryFdInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit,
                                      "VUID-VkImportMemoryFdInfoKHR-handleType-parameter");
            }
        } break;
#ifdef VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkWin32KeyedMutexAcquireReleaseInfoKHR structure members
        case VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR: {  // Covers
                                                                              // VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkWin32KeyedMutexAcquireReleaseInfoKHR);
                VkWin32KeyedMutexAcquireReleaseInfoKHR* structure = (VkWin32KeyedMutexAcquireReleaseInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::acquireCount), pNext_loc.dot(Field::pAcquireSyncs),
                                      structure->acquireCount, &structure->pAcquireSyncs, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::acquireCount), pNext_loc.dot(Field::pAcquireKeys),
                                      structure->acquireCount, &structure->pAcquireKeys, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireKeys-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::acquireCount), pNext_loc.dot(Field::pAcquireTimeouts),
                                      structure->acquireCount, &structure->pAcquireTimeouts, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireTimeouts-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::releaseCount), pNext_loc.dot(Field::pReleaseSyncs),
                                      structure->releaseCount, &structure->pReleaseSyncs, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseSyncs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::releaseCount), pNext_loc.dot(Field::pReleaseKeys),
                                      structure->releaseCount, &structure->pReleaseKeys, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseKeys-parameter");
            }
        } break;

        // No Validation code for VkExportSemaphoreWin32HandleInfoKHR structure members  -- Covers
        // VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType

        // No Validation code for VkD3D12FenceSubmitInfoKHR structure members  -- Covers VUID-VkD3D12FenceSubmitInfoKHR-sType-sType
#endif  // VK_USE_PLATFORM_WIN32_KHR

        // No Validation code for VkPhysicalDevicePushDescriptorPropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDevicePushDescriptorPropertiesKHR-sType-sType

        // Validation code for VkPresentRegionsKHR structure members
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: {  // Covers VUID-VkPresentRegionsKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPresentRegionsKHR);
                VkPresentRegionsKHR* structure = (VkPresentRegionsKHR*)header;
                skip |=
                    ValidateArray(pNext_loc.dot(Field::swapchainCount), pNext_loc.dot(Field::pRegions), structure->swapchainCount,
                                  &structure->pRegions, true, false, "VUID-VkPresentRegionsKHR-swapchainCount-arraylength",
                                  "VUID-VkPresentRegionsKHR-pRegions-parameter");

                if (structure->pRegions != nullptr) {
                    for (uint32_t swapchainIndex = 0; swapchainIndex < structure->swapchainCount; ++swapchainIndex) {
                        [[maybe_unused]] const Location pRegions_loc = pNext_loc.dot(Field::pRegions, swapchainIndex);
                        if (structure->pRegions[swapchainIndex].pRectangles != nullptr) {
                            for (uint32_t rectangleIndex = 0; rectangleIndex < structure->pRegions[swapchainIndex].rectangleCount;
                                 ++rectangleIndex) {
                                [[maybe_unused]] const Location pRectangles_loc =
                                    pRegions_loc.dot(Field::pRectangles, rectangleIndex);
                            }
                        }
                    }
                }
            }
        } break;

        // No Validation code for VkSharedPresentSurfaceCapabilitiesKHR structure members  -- Covers
        // VUID-VkSharedPresentSurfaceCapabilitiesKHR-sType-sType
#ifdef VK_USE_PLATFORM_WIN32_KHR

        // No Validation code for VkExportFenceWin32HandleInfoKHR structure members  -- Covers
        // VUID-VkExportFenceWin32HandleInfoKHR-sType-sType
#endif  // VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkPhysicalDevicePerformanceQueryFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: {  // Covers
                                                                                  // VUID-VkPhysicalDevicePerformanceQueryFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePerformanceQueryFeaturesKHR);
                VkPhysicalDevicePerformanceQueryFeaturesKHR* structure = (VkPhysicalDevicePerformanceQueryFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::performanceCounterQueryPools), structure->performanceCounterQueryPools);

                skip |= ValidateBool32(pNext_loc.dot(Field::performanceCounterMultipleQueryPools),
                                       structure->performanceCounterMultipleQueryPools);
            }
        } break;

        // No Validation code for VkPhysicalDevicePerformanceQueryPropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDevicePerformanceQueryPropertiesKHR-sType-sType

        // Validation code for VkQueryPoolPerformanceCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR: {  // Covers
                                                                          // VUID-VkQueryPoolPerformanceCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkQueryPoolPerformanceCreateInfoKHR);
                VkQueryPoolPerformanceCreateInfoKHR* structure = (VkQueryPoolPerformanceCreateInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::counterIndexCount), pNext_loc.dot(Field::pCounterIndices),
                                      structure->counterIndexCount, &structure->pCounterIndices, true, true,
                                      "VUID-VkQueryPoolPerformanceCreateInfoKHR-counterIndexCount-arraylength",
                                      "VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-parameter");
            }
        } break;

        // No Validation code for VkPerformanceQuerySubmitInfoKHR structure members  -- Covers
        // VUID-VkPerformanceQuerySubmitInfoKHR-sType-sType
#ifdef VK_ENABLE_BETA_EXTENSIONS

        // Validation code for VkPhysicalDevicePortabilitySubsetFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR: {  // Covers
                                                                                   // VUID-VkPhysicalDevicePortabilitySubsetFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePortabilitySubsetFeaturesKHR);
                VkPhysicalDevicePortabilitySubsetFeaturesKHR* structure = (VkPhysicalDevicePortabilitySubsetFeaturesKHR*)header;
                skip |=
                    ValidateBool32(pNext_loc.dot(Field::constantAlphaColorBlendFactors), structure->constantAlphaColorBlendFactors);

                skip |= ValidateBool32(pNext_loc.dot(Field::events), structure->events);

                skip |= ValidateBool32(pNext_loc.dot(Field::imageViewFormatReinterpretation),
                                       structure->imageViewFormatReinterpretation);

                skip |= ValidateBool32(pNext_loc.dot(Field::imageViewFormatSwizzle), structure->imageViewFormatSwizzle);

                skip |= ValidateBool32(pNext_loc.dot(Field::imageView2DOn3DImage), structure->imageView2DOn3DImage);

                skip |= ValidateBool32(pNext_loc.dot(Field::multisampleArrayImage), structure->multisampleArrayImage);

                skip |= ValidateBool32(pNext_loc.dot(Field::mutableComparisonSamplers), structure->mutableComparisonSamplers);

                skip |= ValidateBool32(pNext_loc.dot(Field::pointPolygons), structure->pointPolygons);

                skip |= ValidateBool32(pNext_loc.dot(Field::samplerMipLodBias), structure->samplerMipLodBias);

                skip |= ValidateBool32(pNext_loc.dot(Field::separateStencilMaskRef), structure->separateStencilMaskRef);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSampleRateInterpolationFunctions),
                                       structure->shaderSampleRateInterpolationFunctions);

                skip |= ValidateBool32(pNext_loc.dot(Field::tessellationIsolines), structure->tessellationIsolines);

                skip |= ValidateBool32(pNext_loc.dot(Field::tessellationPointMode), structure->tessellationPointMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::triangleFans), structure->triangleFans);

                skip |= ValidateBool32(pNext_loc.dot(Field::vertexAttributeAccessBeyondStride),
                                       structure->vertexAttributeAccessBeyondStride);
            }
        } break;

        // No Validation code for VkPhysicalDevicePortabilitySubsetPropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDevicePortabilitySubsetPropertiesKHR-sType-sType
#endif  // VK_ENABLE_BETA_EXTENSIONS

        // Validation code for VkPhysicalDeviceShaderClockFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: {  // Covers
                                                                             // VUID-VkPhysicalDeviceShaderClockFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderClockFeaturesKHR);
                VkPhysicalDeviceShaderClockFeaturesKHR* structure = (VkPhysicalDeviceShaderClockFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSubgroupClock), structure->shaderSubgroupClock);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderDeviceClock), structure->shaderDeviceClock);
            }
        } break;

        // No Validation code for VkVideoDecodeH265ProfileInfoKHR structure members  -- Covers
        // VUID-VkVideoDecodeH265ProfileInfoKHR-sType-sType

        // No Validation code for VkVideoDecodeH265CapabilitiesKHR structure members  -- Covers
        // VUID-VkVideoDecodeH265CapabilitiesKHR-sType-sType

        // Validation code for VkVideoDecodeH265SessionParametersAddInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR: {  // Covers
                                                                                     // VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH265SessionParametersAddInfoKHR);
                VkVideoDecodeH265SessionParametersAddInfoKHR* structure = (VkVideoDecodeH265SessionParametersAddInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::stdVPSCount), pNext_loc.dot(Field::pStdVPSs), structure->stdVPSCount,
                                      &structure->pStdVPSs, false, true, kVUIDUndefined,
                                      "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdVPSs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::stdSPSCount), pNext_loc.dot(Field::pStdSPSs), structure->stdSPSCount,
                                      &structure->pStdSPSs, false, true, kVUIDUndefined,
                                      "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdSPSs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::stdPPSCount), pNext_loc.dot(Field::pStdPPSs), structure->stdPPSCount,
                                      &structure->pStdPPSs, false, true, kVUIDUndefined,
                                      "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdPPSs-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH265SessionParametersCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR: {  // Covers
                                                                                        // VUID-VkVideoDecodeH265SessionParametersCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH265SessionParametersCreateInfoKHR);
                VkVideoDecodeH265SessionParametersCreateInfoKHR* structure =
                    (VkVideoDecodeH265SessionParametersCreateInfoKHR*)header;
                skip |= ValidateStructType(
                    pNext_loc.dot(Field::pParametersAddInfo), "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR",
                    structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR, false,
                    "VUID-VkVideoDecodeH265SessionParametersCreateInfoKHR-pParametersAddInfo-parameter",
                    "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-sType-sType");

                if (structure->pParametersAddInfo != nullptr) {
                    [[maybe_unused]] const Location pParametersAddInfo_loc = pNext_loc.dot(Field::pParametersAddInfo);
                    skip |=
                        ValidateArray(pParametersAddInfo_loc.dot(Field::stdVPSCount), pParametersAddInfo_loc.dot(Field::pStdVPSs),
                                      structure->pParametersAddInfo->stdVPSCount, &structure->pParametersAddInfo->pStdVPSs, false,
                                      true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdVPSs-parameter");

                    skip |=
                        ValidateArray(pParametersAddInfo_loc.dot(Field::stdSPSCount), pParametersAddInfo_loc.dot(Field::pStdSPSs),
                                      structure->pParametersAddInfo->stdSPSCount, &structure->pParametersAddInfo->pStdSPSs, false,
                                      true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdSPSs-parameter");

                    skip |=
                        ValidateArray(pParametersAddInfo_loc.dot(Field::stdPPSCount), pParametersAddInfo_loc.dot(Field::pStdPPSs),
                                      structure->pParametersAddInfo->stdPPSCount, &structure->pParametersAddInfo->pStdPPSs, false,
                                      true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdPPSs-parameter");
                }
            }
        } break;

        // Validation code for VkVideoDecodeH265PictureInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR: {  // Covers VUID-VkVideoDecodeH265PictureInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH265PictureInfoKHR);
                VkVideoDecodeH265PictureInfoKHR* structure = (VkVideoDecodeH265PictureInfoKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdPictureInfo), structure->pStdPictureInfo,
                                                "VUID-VkVideoDecodeH265PictureInfoKHR-pStdPictureInfo-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::sliceSegmentCount), pNext_loc.dot(Field::pSliceSegmentOffsets),
                                      structure->sliceSegmentCount, &structure->pSliceSegmentOffsets, true, true,
                                      "VUID-VkVideoDecodeH265PictureInfoKHR-sliceSegmentCount-arraylength",
                                      "VUID-VkVideoDecodeH265PictureInfoKHR-pSliceSegmentOffsets-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH265DpbSlotInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR: {  // Covers VUID-VkVideoDecodeH265DpbSlotInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoDecodeH265DpbSlotInfoKHR);
                VkVideoDecodeH265DpbSlotInfoKHR* structure = (VkVideoDecodeH265DpbSlotInfoKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pStdReferenceInfo), structure->pStdReferenceInfo,
                                                "VUID-VkVideoDecodeH265DpbSlotInfoKHR-pStdReferenceInfo-parameter");
            }
        } break;

        // Validation code for VkDeviceQueueGlobalPriorityCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR: {  // Covers
                                                                                // VUID-VkDeviceQueueGlobalPriorityCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceQueueGlobalPriorityCreateInfoKHR);
                VkDeviceQueueGlobalPriorityCreateInfoKHR* structure = (VkDeviceQueueGlobalPriorityCreateInfoKHR*)header;
                skip |=
                    ValidateRangedEnum(pNext_loc.dot(Field::globalPriority), "VkQueueGlobalPriorityKHR", structure->globalPriority,
                                       "VUID-VkDeviceQueueGlobalPriorityCreateInfoKHR-globalPriority-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR);
                VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR* structure = (VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::globalPriorityQuery), structure->globalPriorityQuery);
            }
        } break;

        // No Validation code for VkQueueFamilyGlobalPriorityPropertiesKHR structure members  -- Covers
        // VUID-VkQueueFamilyGlobalPriorityPropertiesKHR-sType-sType

        // Validation code for VkFragmentShadingRateAttachmentInfoKHR structure members
        case VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {  // Covers
                                                                             // VUID-VkFragmentShadingRateAttachmentInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkFragmentShadingRateAttachmentInfoKHR);
                VkFragmentShadingRateAttachmentInfoKHR* structure = (VkFragmentShadingRateAttachmentInfoKHR*)header;
                skip |= ValidateStructType(pNext_loc.dot(Field::pFragmentShadingRateAttachment),
                                           "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", structure->pFragmentShadingRateAttachment,
                                           VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false,
                                           "VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-parameter",
                                           "VUID-VkAttachmentReference2-sType-sType");

                if (structure->pFragmentShadingRateAttachment != nullptr) {
                    [[maybe_unused]] const Location pFragmentShadingRateAttachment_loc =
                        pNext_loc.dot(Field::pFragmentShadingRateAttachment);
                    skip |= ValidateRangedEnum(pFragmentShadingRateAttachment_loc.dot(Field::layout), "VkImageLayout",
                                               structure->pFragmentShadingRateAttachment->layout,
                                               "VUID-VkAttachmentReference2-layout-parameter");
                }
            }
        } break;

        // No Validation code for VkPipelineFragmentShadingRateStateCreateInfoKHR structure members  -- Covers
        // VUID-VkPipelineFragmentShadingRateStateCreateInfoKHR-sType-sType

        // Validation code for VkPhysicalDeviceFragmentShadingRateFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceFragmentShadingRateFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentShadingRateFeaturesKHR);
                VkPhysicalDeviceFragmentShadingRateFeaturesKHR* structure = (VkPhysicalDeviceFragmentShadingRateFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineFragmentShadingRate), structure->pipelineFragmentShadingRate);

                skip |= ValidateBool32(pNext_loc.dot(Field::primitiveFragmentShadingRate), structure->primitiveFragmentShadingRate);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::attachmentFragmentShadingRate), structure->attachmentFragmentShadingRate);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentShadingRatePropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceFragmentShadingRatePropertiesKHR-sType-sType

        // Validation code for VkSurfaceProtectedCapabilitiesKHR structure members
        case VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: {  // Covers VUID-VkSurfaceProtectedCapabilitiesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSurfaceProtectedCapabilitiesKHR);
                VkSurfaceProtectedCapabilitiesKHR* structure = (VkSurfaceProtectedCapabilitiesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::supportsProtected), structure->supportsProtected);
            }
        } break;

        // Validation code for VkPhysicalDevicePresentWaitFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR: {  // Covers
                                                                             // VUID-VkPhysicalDevicePresentWaitFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePresentWaitFeaturesKHR);
                VkPhysicalDevicePresentWaitFeaturesKHR* structure = (VkPhysicalDevicePresentWaitFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::presentWait), structure->presentWait);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {  // Covers
                                                                                               // VUID-VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR);
                VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* structure =
                    (VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineExecutableInfo), structure->pipelineExecutableInfo);
            }
        } break;

        // Validation code for VkPipelineLibraryCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: {  // Covers VUID-VkPipelineLibraryCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineLibraryCreateInfoKHR);
                VkPipelineLibraryCreateInfoKHR* structure = (VkPipelineLibraryCreateInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::libraryCount), pNext_loc.dot(Field::pLibraries), structure->libraryCount,
                                      &structure->pLibraries, false, true, kVUIDUndefined,
                                      "VUID-VkPipelineLibraryCreateInfoKHR-pLibraries-parameter");
            }
        } break;

        // Validation code for VkPresentIdKHR structure members
        case VK_STRUCTURE_TYPE_PRESENT_ID_KHR: {  // Covers VUID-VkPresentIdKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPresentIdKHR);
                VkPresentIdKHR* structure = (VkPresentIdKHR*)header;
                skip |=
                    ValidateArray(pNext_loc.dot(Field::swapchainCount), pNext_loc.dot(Field::pPresentIds),
                                  structure->swapchainCount, &structure->pPresentIds, true, false,
                                  "VUID-VkPresentIdKHR-swapchainCount-arraylength", "VUID-VkPresentIdKHR-pPresentIds-parameter");
            }
        } break;

        // Validation code for VkPhysicalDevicePresentIdFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR: {  // Covers
                                                                           // VUID-VkPhysicalDevicePresentIdFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePresentIdFeaturesKHR);
                VkPhysicalDevicePresentIdFeaturesKHR* structure = (VkPhysicalDevicePresentIdFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::presentId), structure->presentId);
            }
        } break;

        // No Validation code for VkVideoEncodeCapabilitiesKHR structure members  -- Covers
        // VUID-VkVideoEncodeCapabilitiesKHR-sType-sType

        // Validation code for VkQueryPoolVideoEncodeFeedbackCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR: {  // Covers
                                                                                    // VUID-VkQueryPoolVideoEncodeFeedbackCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkQueryPoolVideoEncodeFeedbackCreateInfoKHR);
                VkQueryPoolVideoEncodeFeedbackCreateInfoKHR* structure = (VkQueryPoolVideoEncodeFeedbackCreateInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::encodeFeedbackFlags), "VkVideoEncodeFeedbackFlagBitsKHR",
                                      AllVkVideoEncodeFeedbackFlagBitsKHR, structure->encodeFeedbackFlags, kRequiredFlags,
                                      "VUID-VkQueryPoolVideoEncodeFeedbackCreateInfoKHR-encodeFeedbackFlags-parameter",
                                      "VUID-VkQueryPoolVideoEncodeFeedbackCreateInfoKHR-encodeFeedbackFlags-requiredbitmask");
            }
        } break;

        // Validation code for VkVideoEncodeUsageInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR: {  // Covers VUID-VkVideoEncodeUsageInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeUsageInfoKHR);
                VkVideoEncodeUsageInfoKHR* structure = (VkVideoEncodeUsageInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::videoUsageHints), "VkVideoEncodeUsageFlagBitsKHR",
                                      AllVkVideoEncodeUsageFlagBitsKHR, structure->videoUsageHints, kOptionalFlags,
                                      "VUID-VkVideoEncodeUsageInfoKHR-videoUsageHints-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::videoContentHints), "VkVideoEncodeContentFlagBitsKHR",
                                      AllVkVideoEncodeContentFlagBitsKHR, structure->videoContentHints, kOptionalFlags,
                                      "VUID-VkVideoEncodeUsageInfoKHR-videoContentHints-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::tuningMode), "VkVideoEncodeTuningModeKHR", structure->tuningMode,
                                           "VUID-VkVideoEncodeUsageInfoKHR-tuningMode-parameter");
            }
        } break;

        // Validation code for VkVideoEncodeRateControlInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR: {  // Covers VUID-VkVideoEncodeRateControlInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkVideoEncodeRateControlInfoKHR);
                VkVideoEncodeRateControlInfoKHR* structure = (VkVideoEncodeRateControlInfoKHR*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkVideoEncodeRateControlInfoKHR-flags-zerobitmask");

                skip |= ValidateFlags(pNext_loc.dot(Field::rateControlMode), "VkVideoEncodeRateControlModeFlagBitsKHR",
                                      AllVkVideoEncodeRateControlModeFlagBitsKHR, structure->rateControlMode, kOptionalSingleBit,
                                      "VUID-VkVideoEncodeRateControlInfoKHR-rateControlMode-parameter");

                skip |= ValidateStructTypeArray(pNext_loc.dot(Field::layerCount), pNext_loc.dot(Field::pLayers),
                                                "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR", structure->layerCount,
                                                structure->pLayers, VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR,
                                                false, true, "VUID-VkVideoEncodeRateControlLayerInfoKHR-sType-sType",
                                                "VUID-VkVideoEncodeRateControlInfoKHR-pLayers-parameter", kVUIDUndefined);

                if (structure->pLayers != nullptr) {
                    for (uint32_t layerIndex = 0; layerIndex < structure->layerCount; ++layerIndex) {
                        [[maybe_unused]] const Location pLayers_loc = pNext_loc.dot(Field::pLayers, layerIndex);
                    }
                }
            }
        } break;

        // No Validation code for VkVideoEncodeQualityLevelInfoKHR structure members  -- Covers
        // VUID-VkVideoEncodeQualityLevelInfoKHR-sType-sType

        // No Validation code for VkQueueFamilyCheckpointProperties2NV structure members  -- Covers
        // VUID-VkQueueFamilyCheckpointProperties2NV-sType-sType

        // Validation code for VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR: {  // Covers
                                                                                            // VUID-VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR);
                VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR* structure =
                    (VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentShaderBarycentric), structure->fragmentShaderBarycentric);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR: {  // Covers
                                                                                                     // VUID-VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR);
                VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* structure =
                    (VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSubgroupUniformControlFlow),
                                       structure->shaderSubgroupUniformControlFlow);
            }
        } break;

        // Validation code for VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR: {  // Covers
                                                                                                 // VUID-VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR);
                VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* structure =
                    (VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR*)header;
                skip |=
                    ValidateBool32(pNext_loc.dot(Field::workgroupMemoryExplicitLayout), structure->workgroupMemoryExplicitLayout);

                skip |= ValidateBool32(pNext_loc.dot(Field::workgroupMemoryExplicitLayoutScalarBlockLayout),
                                       structure->workgroupMemoryExplicitLayoutScalarBlockLayout);

                skip |= ValidateBool32(pNext_loc.dot(Field::workgroupMemoryExplicitLayout8BitAccess),
                                       structure->workgroupMemoryExplicitLayout8BitAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::workgroupMemoryExplicitLayout16BitAccess),
                                       structure->workgroupMemoryExplicitLayout16BitAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR);
                VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR* structure =
                    (VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingMaintenance1), structure->rayTracingMaintenance1);

                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingPipelineTraceRaysIndirect2),
                                       structure->rayTracingPipelineTraceRaysIndirect2);
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance5FeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES_KHR: {  // Covers
                                                                              // VUID-VkPhysicalDeviceMaintenance5FeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMaintenance5FeaturesKHR);
                VkPhysicalDeviceMaintenance5FeaturesKHR* structure = (VkPhysicalDeviceMaintenance5FeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::maintenance5), structure->maintenance5);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMaintenance5PropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceMaintenance5PropertiesKHR-sType-sType

        // Validation code for VkPipelineCreateFlags2CreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR: {  // Covers
                                                                           // VUID-VkPipelineCreateFlags2CreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineCreateFlags2CreateInfoKHR);
                VkPipelineCreateFlags2CreateInfoKHR* structure = (VkPipelineCreateFlags2CreateInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkPipelineCreateFlagBits2KHR", AllVkPipelineCreateFlagBits2KHR,
                                      structure->flags, kRequiredFlags, "VUID-VkPipelineCreateFlags2CreateInfoKHR-flags-parameter",
                                      "VUID-VkPipelineCreateFlags2CreateInfoKHR-flags-requiredbitmask");
            }
        } break;

        // Validation code for VkBufferUsageFlags2CreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR: {  // Covers VUID-VkBufferUsageFlags2CreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBufferUsageFlags2CreateInfoKHR);
                VkBufferUsageFlags2CreateInfoKHR* structure = (VkBufferUsageFlags2CreateInfoKHR*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::usage), "VkBufferUsageFlagBits2KHR", AllVkBufferUsageFlagBits2KHR,
                                      structure->usage, kRequiredFlags, "VUID-VkBufferUsageFlags2CreateInfoKHR-usage-parameter",
                                      "VUID-VkBufferUsageFlags2CreateInfoKHR-usage-requiredbitmask");
            }
        } break;

        // Validation code for VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR);
                VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR* structure =
                    (VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingPositionFetch), structure->rayTracingPositionFetch);
            }
        } break;

        // Validation code for VkPhysicalDeviceCooperativeMatrixFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceCooperativeMatrixFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCooperativeMatrixFeaturesKHR);
                VkPhysicalDeviceCooperativeMatrixFeaturesKHR* structure = (VkPhysicalDeviceCooperativeMatrixFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::cooperativeMatrix), structure->cooperativeMatrix);

                skip |= ValidateBool32(pNext_loc.dot(Field::cooperativeMatrixRobustBufferAccess),
                                       structure->cooperativeMatrixRobustBufferAccess);
            }
        } break;

        // No Validation code for VkPhysicalDeviceCooperativeMatrixPropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceCooperativeMatrixPropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceVideoMaintenance1FeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceVideoMaintenance1FeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVideoMaintenance1FeaturesKHR);
                VkPhysicalDeviceVideoMaintenance1FeaturesKHR* structure = (VkPhysicalDeviceVideoMaintenance1FeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::videoMaintenance1), structure->videoMaintenance1);
            }
        } break;

        // No Validation code for VkVideoInlineQueryInfoKHR structure members  -- Covers VUID-VkVideoInlineQueryInfoKHR-sType-sType

        // No Validation code for VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR-sType-sType

        // Validation code for VkPipelineVertexInputDivisorStateCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_KHR: {  // Covers
                                                                                       // VUID-VkPipelineVertexInputDivisorStateCreateInfoKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineVertexInputDivisorStateCreateInfoKHR);
                VkPipelineVertexInputDivisorStateCreateInfoKHR* structure = (VkPipelineVertexInputDivisorStateCreateInfoKHR*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::vertexBindingDivisorCount), pNext_loc.dot(Field::pVertexBindingDivisors),
                                      structure->vertexBindingDivisorCount, &structure->pVertexBindingDivisors, true, true,
                                      "VUID-VkPipelineVertexInputDivisorStateCreateInfoKHR-vertexBindingDivisorCount-arraylength",
                                      "VUID-VkPipelineVertexInputDivisorStateCreateInfoKHR-pVertexBindingDivisors-parameter");

                if (structure->pVertexBindingDivisors != nullptr) {
                    for (uint32_t vertexBindingDivisorIndex = 0; vertexBindingDivisorIndex < structure->vertexBindingDivisorCount;
                         ++vertexBindingDivisorIndex) {
                        [[maybe_unused]] const Location pVertexBindingDivisors_loc =
                            pNext_loc.dot(Field::pVertexBindingDivisors, vertexBindingDivisorIndex);
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_KHR: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR);
                VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR* structure =
                    (VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::vertexAttributeInstanceRateDivisor),
                                       structure->vertexAttributeInstanceRateDivisor);

                skip |= ValidateBool32(pNext_loc.dot(Field::vertexAttributeInstanceRateZeroDivisor),
                                       structure->vertexAttributeInstanceRateZeroDivisor);
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance6FeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES_KHR: {  // Covers
                                                                              // VUID-VkPhysicalDeviceMaintenance6FeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMaintenance6FeaturesKHR);
                VkPhysicalDeviceMaintenance6FeaturesKHR* structure = (VkPhysicalDeviceMaintenance6FeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::maintenance6), structure->maintenance6);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMaintenance6PropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceMaintenance6PropertiesKHR-sType-sType

        // Validation code for VkBindMemoryStatusKHR structure members
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS_KHR: {  // Covers VUID-VkBindMemoryStatusKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBindMemoryStatusKHR);
                VkBindMemoryStatusKHR* structure = (VkBindMemoryStatusKHR*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pResult), structure->pResult,
                                                "VUID-VkBindMemoryStatusKHR-pResult-parameter");
            }
        } break;

        // Validation code for VkDebugReportCallbackCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: {  // Covers
                                                                         // VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDebugReportCallbackCreateInfoEXT);
                VkDebugReportCallbackCreateInfoEXT* structure = (VkDebugReportCallbackCreateInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkDebugReportFlagBitsEXT", AllVkDebugReportFlagBitsEXT,
                                      structure->flags, kOptionalFlags, "VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter");

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pfnCallback),
                                                reinterpret_cast<const void*>(structure->pfnCallback),
                                                "VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter");
            }
        } break;

        // Validation code for VkPipelineRasterizationStateRasterizationOrderAMD structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD: {  // Covers
                                                                                        // VUID-VkPipelineRasterizationStateRasterizationOrderAMD-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineRasterizationStateRasterizationOrderAMD);
                VkPipelineRasterizationStateRasterizationOrderAMD* structure =
                    (VkPipelineRasterizationStateRasterizationOrderAMD*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::rasterizationOrder), "VkRasterizationOrderAMD",
                                           structure->rasterizationOrder,
                                           "VUID-VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder-parameter");
            }
        } break;

        // Validation code for VkDedicatedAllocationImageCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV: {  // Covers
                                                                             // VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDedicatedAllocationImageCreateInfoNV);
                VkDedicatedAllocationImageCreateInfoNV* structure = (VkDedicatedAllocationImageCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::dedicatedAllocation), structure->dedicatedAllocation);
            }
        } break;

        // Validation code for VkDedicatedAllocationBufferCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV: {  // Covers
                                                                              // VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDedicatedAllocationBufferCreateInfoNV);
                VkDedicatedAllocationBufferCreateInfoNV* structure = (VkDedicatedAllocationBufferCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::dedicatedAllocation), structure->dedicatedAllocation);
            }
        } break;

        // No Validation code for VkDedicatedAllocationMemoryAllocateInfoNV structure members  -- Covers
        // VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType

        // Validation code for VkPhysicalDeviceTransformFeedbackFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceTransformFeedbackFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceTransformFeedbackFeaturesEXT);
                VkPhysicalDeviceTransformFeedbackFeaturesEXT* structure = (VkPhysicalDeviceTransformFeedbackFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::transformFeedback), structure->transformFeedback);

                skip |= ValidateBool32(pNext_loc.dot(Field::geometryStreams), structure->geometryStreams);
            }
        } break;

        // No Validation code for VkPhysicalDeviceTransformFeedbackPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceTransformFeedbackPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationStateStreamCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: {  // Covers
                                                                                       // VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineRasterizationStateStreamCreateInfoEXT);
                VkPipelineRasterizationStateStreamCreateInfoEXT* structure =
                    (VkPipelineRasterizationStateStreamCreateInfoEXT*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-flags-zerobitmask");
            }
        } break;

        // No Validation code for VkTextureLODGatherFormatPropertiesAMD structure members  -- Covers
        // VUID-VkTextureLODGatherFormatPropertiesAMD-sType-sType

        // Validation code for VkPhysicalDeviceCornerSampledImageFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceCornerSampledImageFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCornerSampledImageFeaturesNV);
                VkPhysicalDeviceCornerSampledImageFeaturesNV* structure = (VkPhysicalDeviceCornerSampledImageFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::cornerSampledImage), structure->cornerSampledImage);
            }
        } break;

        // Validation code for VkExternalMemoryImageCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: {  // Covers VUID-VkExternalMemoryImageCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExternalMemoryImageCreateInfoNV);
                VkExternalMemoryImageCreateInfoNV* structure = (VkExternalMemoryImageCreateInfoNV*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalMemoryHandleTypeFlagBitsNV",
                                      AllVkExternalMemoryHandleTypeFlagBitsNV, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportMemoryAllocateInfoNV structure members
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: {  // Covers VUID-VkExportMemoryAllocateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMemoryAllocateInfoNV);
                VkExportMemoryAllocateInfoNV* structure = (VkExportMemoryAllocateInfoNV*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleTypes), "VkExternalMemoryHandleTypeFlagBitsNV",
                                      AllVkExternalMemoryHandleTypeFlagBitsNV, structure->handleTypes, kOptionalFlags,
                                      "VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter");
            }
        } break;
#ifdef VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkImportMemoryWin32HandleInfoNV structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: {  // Covers VUID-VkImportMemoryWin32HandleInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMemoryWin32HandleInfoNV);
                VkImportMemoryWin32HandleInfoNV* structure = (VkImportMemoryWin32HandleInfoNV*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBitsNV",
                                      AllVkExternalMemoryHandleTypeFlagBitsNV, structure->handleType, kOptionalFlags,
                                      "VUID-VkImportMemoryWin32HandleInfoNV-handleType-parameter");
            }
        } break;

        // No Validation code for VkExportMemoryWin32HandleInfoNV structure members  -- Covers
        // VUID-VkExportMemoryWin32HandleInfoNV-sType-sType

        // Validation code for VkWin32KeyedMutexAcquireReleaseInfoNV structure members
        case VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV: {  // Covers
                                                                             // VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkWin32KeyedMutexAcquireReleaseInfoNV);
                VkWin32KeyedMutexAcquireReleaseInfoNV* structure = (VkWin32KeyedMutexAcquireReleaseInfoNV*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::acquireCount), pNext_loc.dot(Field::pAcquireSyncs),
                                      structure->acquireCount, &structure->pAcquireSyncs, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireSyncs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::acquireCount), pNext_loc.dot(Field::pAcquireKeys),
                                      structure->acquireCount, &structure->pAcquireKeys, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireKeys-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::acquireCount), pNext_loc.dot(Field::pAcquireTimeoutMilliseconds),
                                      structure->acquireCount, &structure->pAcquireTimeoutMilliseconds, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireTimeoutMilliseconds-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::releaseCount), pNext_loc.dot(Field::pReleaseSyncs),
                                      structure->releaseCount, &structure->pReleaseSyncs, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseSyncs-parameter");

                skip |= ValidateArray(pNext_loc.dot(Field::releaseCount), pNext_loc.dot(Field::pReleaseKeys),
                                      structure->releaseCount, &structure->pReleaseKeys, false, true, kVUIDUndefined,
                                      "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseKeys-parameter");
            }
        } break;
#endif  // VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkValidationFlagsEXT structure members
        case VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: {  // Covers VUID-VkValidationFlagsEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkValidationFlagsEXT);
                VkValidationFlagsEXT* structure = (VkValidationFlagsEXT*)header;
                skip |= ValidateRangedEnumArray(pNext_loc.dot(Field::disabledValidationCheckCount),
                                                pNext_loc.dot(Field::pDisabledValidationChecks), "VkValidationCheckEXT",
                                                structure->disabledValidationCheckCount, structure->pDisabledValidationChecks, true,
                                                true);
            }
        } break;

        // Validation code for VkImageViewASTCDecodeModeEXT structure members
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: {  // Covers VUID-VkImageViewASTCDecodeModeEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImageViewASTCDecodeModeEXT);
                VkImageViewASTCDecodeModeEXT* structure = (VkImageViewASTCDecodeModeEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::decodeMode), "VkFormat", structure->decodeMode,
                                           "VUID-VkImageViewASTCDecodeModeEXT-decodeMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceASTCDecodeFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: {  // Covers
                                                                            // VUID-VkPhysicalDeviceASTCDecodeFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceASTCDecodeFeaturesEXT);
                VkPhysicalDeviceASTCDecodeFeaturesEXT* structure = (VkPhysicalDeviceASTCDecodeFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::decodeModeSharedExponent), structure->decodeModeSharedExponent);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineRobustnessFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT: {  // Covers
                                                                                    // VUID-VkPhysicalDevicePipelineRobustnessFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePipelineRobustnessFeaturesEXT);
                VkPhysicalDevicePipelineRobustnessFeaturesEXT* structure = (VkPhysicalDevicePipelineRobustnessFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineRobustness), structure->pipelineRobustness);
            }
        } break;

        // No Validation code for VkPhysicalDevicePipelineRobustnessPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDevicePipelineRobustnessPropertiesEXT-sType-sType

        // Validation code for VkPipelineRobustnessCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT: {  // Covers VUID-VkPipelineRobustnessCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineRobustnessCreateInfoEXT);
                VkPipelineRobustnessCreateInfoEXT* structure = (VkPipelineRobustnessCreateInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::storageBuffers), "VkPipelineRobustnessBufferBehaviorEXT",
                                           structure->storageBuffers,
                                           "VUID-VkPipelineRobustnessCreateInfoEXT-storageBuffers-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::uniformBuffers), "VkPipelineRobustnessBufferBehaviorEXT",
                                           structure->uniformBuffers,
                                           "VUID-VkPipelineRobustnessCreateInfoEXT-uniformBuffers-parameter");

                skip |=
                    ValidateRangedEnum(pNext_loc.dot(Field::vertexInputs), "VkPipelineRobustnessBufferBehaviorEXT",
                                       structure->vertexInputs, "VUID-VkPipelineRobustnessCreateInfoEXT-vertexInputs-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::images), "VkPipelineRobustnessImageBehaviorEXT", structure->images,
                                           "VUID-VkPipelineRobustnessCreateInfoEXT-images-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceConditionalRenderingFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceConditionalRenderingFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceConditionalRenderingFeaturesEXT);
                VkPhysicalDeviceConditionalRenderingFeaturesEXT* structure =
                    (VkPhysicalDeviceConditionalRenderingFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::conditionalRendering), structure->conditionalRendering);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::inheritedConditionalRendering), structure->inheritedConditionalRendering);
            }
        } break;

        // Validation code for VkCommandBufferInheritanceConditionalRenderingInfoEXT structure members
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT: {  // Covers
                                                                                             // VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkCommandBufferInheritanceConditionalRenderingInfoEXT);
                VkCommandBufferInheritanceConditionalRenderingInfoEXT* structure =
                    (VkCommandBufferInheritanceConditionalRenderingInfoEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::conditionalRenderingEnable), structure->conditionalRenderingEnable);
            }
        } break;

        // Validation code for VkPipelineViewportWScalingStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV: {  // Covers
                                                                                    // VUID-VkPipelineViewportWScalingStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineViewportWScalingStateCreateInfoNV);
                VkPipelineViewportWScalingStateCreateInfoNV* structure = (VkPipelineViewportWScalingStateCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::viewportWScalingEnable), structure->viewportWScalingEnable);

                skip |= ValidateArray(pNext_loc.dot(Field::viewportCount), loc, structure->viewportCount,
                                      &structure->pViewportWScalings, true, false,
                                      "VUID-VkPipelineViewportWScalingStateCreateInfoNV-viewportCount-arraylength", kVUIDUndefined);
            }
        } break;

        // Validation code for VkSwapchainCounterCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: {  // Covers VUID-VkSwapchainCounterCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainCounterCreateInfoEXT);
                VkSwapchainCounterCreateInfoEXT* structure = (VkSwapchainCounterCreateInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::surfaceCounters), "VkSurfaceCounterFlagBitsEXT",
                                      AllVkSurfaceCounterFlagBitsEXT, structure->surfaceCounters, kOptionalFlags,
                                      "VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-parameter");
            }
        } break;

        // Validation code for VkPresentTimesInfoGOOGLE structure members
        case VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: {  // Covers VUID-VkPresentTimesInfoGOOGLE-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPresentTimesInfoGOOGLE);
                VkPresentTimesInfoGOOGLE* structure = (VkPresentTimesInfoGOOGLE*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::swapchainCount), pNext_loc.dot(Field::pTimes), structure->swapchainCount,
                                      &structure->pTimes, true, false, "VUID-VkPresentTimesInfoGOOGLE-swapchainCount-arraylength",
                                      "VUID-VkPresentTimesInfoGOOGLE-pTimes-parameter");

                if (structure->pTimes != nullptr) {
                    for (uint32_t swapchainIndex = 0; swapchainIndex < structure->swapchainCount; ++swapchainIndex) {
                        [[maybe_unused]] const Location pTimes_loc = pNext_loc.dot(Field::pTimes, swapchainIndex);
                    }
                }
            }
        } break;

        // No Validation code for VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX structure members  -- Covers
        // VUID-VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-sType-sType

        // Validation code for VkPipelineViewportSwizzleStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV: {  // Covers
                                                                                  // VUID-VkPipelineViewportSwizzleStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineViewportSwizzleStateCreateInfoNV);
                VkPipelineViewportSwizzleStateCreateInfoNV* structure = (VkPipelineViewportSwizzleStateCreateInfoNV*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineViewportSwizzleStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateArray(pNext_loc.dot(Field::viewportCount), pNext_loc.dot(Field::pViewportSwizzles),
                                      structure->viewportCount, &structure->pViewportSwizzles, true, true,
                                      "VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-arraylength",
                                      "VUID-VkPipelineViewportSwizzleStateCreateInfoNV-pViewportSwizzles-parameter");

                if (structure->pViewportSwizzles != nullptr) {
                    for (uint32_t viewportIndex = 0; viewportIndex < structure->viewportCount; ++viewportIndex) {
                        [[maybe_unused]] const Location pViewportSwizzles_loc =
                            pNext_loc.dot(Field::pViewportSwizzles, viewportIndex);
                        skip |= ValidateRangedEnum(pViewportSwizzles_loc.dot(Field::x), "VkViewportCoordinateSwizzleNV",
                                                   structure->pViewportSwizzles[viewportIndex].x,
                                                   "VUID-VkViewportSwizzleNV-x-parameter");

                        skip |= ValidateRangedEnum(pViewportSwizzles_loc.dot(Field::y), "VkViewportCoordinateSwizzleNV",
                                                   structure->pViewportSwizzles[viewportIndex].y,
                                                   "VUID-VkViewportSwizzleNV-y-parameter");

                        skip |= ValidateRangedEnum(pViewportSwizzles_loc.dot(Field::z), "VkViewportCoordinateSwizzleNV",
                                                   structure->pViewportSwizzles[viewportIndex].z,
                                                   "VUID-VkViewportSwizzleNV-z-parameter");

                        skip |= ValidateRangedEnum(pViewportSwizzles_loc.dot(Field::w), "VkViewportCoordinateSwizzleNV",
                                                   structure->pViewportSwizzles[viewportIndex].w,
                                                   "VUID-VkViewportSwizzleNV-w-parameter");
                    }
                }
            }
        } break;

        // No Validation code for VkPhysicalDeviceDiscardRectanglePropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceDiscardRectanglePropertiesEXT-sType-sType

        // Validation code for VkPipelineDiscardRectangleStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                    // VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineDiscardRectangleStateCreateInfoEXT);
                VkPipelineDiscardRectangleStateCreateInfoEXT* structure = (VkPipelineDiscardRectangleStateCreateInfoEXT*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::discardRectangleMode), "VkDiscardRectangleModeEXT",
                                           structure->discardRectangleMode,
                                           "VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleMode-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceConservativeRasterizationPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceConservativeRasterizationPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationConservativeStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                             // VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPipelineRasterizationConservativeStateCreateInfoEXT);
                VkPipelineRasterizationConservativeStateCreateInfoEXT* structure =
                    (VkPipelineRasterizationConservativeStateCreateInfoEXT*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateRangedEnum(
                    pNext_loc.dot(Field::conservativeRasterizationMode), "VkConservativeRasterizationModeEXT",
                    structure->conservativeRasterizationMode,
                    "VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-conservativeRasterizationMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthClipEnableFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceDepthClipEnableFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDepthClipEnableFeaturesEXT);
                VkPhysicalDeviceDepthClipEnableFeaturesEXT* structure = (VkPhysicalDeviceDepthClipEnableFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::depthClipEnable), structure->depthClipEnable);
            }
        } break;

        // Validation code for VkPipelineRasterizationDepthClipStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                           // VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineRasterizationDepthClipStateCreateInfoEXT);
                VkPipelineRasterizationDepthClipStateCreateInfoEXT* structure =
                    (VkPipelineRasterizationDepthClipStateCreateInfoEXT*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateBool32(pNext_loc.dot(Field::depthClipEnable), structure->depthClipEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG);
                VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG* structure =
                    (VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::relaxedLineRasterization), structure->relaxedLineRasterization);
            }
        } break;

        // Validation code for VkDebugUtilsObjectNameInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: {  // Covers VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDebugUtilsObjectNameInfoEXT);
                VkDebugUtilsObjectNameInfoEXT* structure = (VkDebugUtilsObjectNameInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::objectType), "VkObjectType", structure->objectType,
                                           "VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter");
            }
        } break;

        // Validation code for VkDebugUtilsMessengerCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: {  // Covers
                                                                         // VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDebugUtilsMessengerCreateInfoEXT);
                VkDebugUtilsMessengerCreateInfoEXT* structure = (VkDebugUtilsMessengerCreateInfoEXT*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateFlags(pNext_loc.dot(Field::messageSeverity), "VkDebugUtilsMessageSeverityFlagBitsEXT",
                                      AllVkDebugUtilsMessageSeverityFlagBitsEXT, structure->messageSeverity, kRequiredFlags,
                                      "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter",
                                      "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask");

                skip |= ValidateFlags(pNext_loc.dot(Field::messageType), "VkDebugUtilsMessageTypeFlagBitsEXT",
                                      AllVkDebugUtilsMessageTypeFlagBitsEXT, structure->messageType, kRequiredFlags,
                                      "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter",
                                      "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask");

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pfnUserCallback),
                                                reinterpret_cast<const void*>(structure->pfnUserCallback),
                                                "VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter");
            }
        } break;
#ifdef VK_USE_PLATFORM_ANDROID_KHR

        // No Validation code for VkAndroidHardwareBufferUsageANDROID structure members  -- Covers
        // VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType

        // No Validation code for VkAndroidHardwareBufferFormatPropertiesANDROID structure members  -- Covers
        // VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType

        // Validation code for VkImportAndroidHardwareBufferInfoANDROID structure members
        case VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID: {  // Covers
                                                                               // VUID-VkImportAndroidHardwareBufferInfoANDROID-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportAndroidHardwareBufferInfoANDROID);
                VkImportAndroidHardwareBufferInfoANDROID* structure = (VkImportAndroidHardwareBufferInfoANDROID*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::buffer), structure->buffer,
                                                "VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-parameter");
            }
        } break;

        // No Validation code for VkExternalFormatANDROID structure members  -- Covers VUID-VkExternalFormatANDROID-sType-sType

        // No Validation code for VkAndroidHardwareBufferFormatProperties2ANDROID structure members  -- Covers
        // VUID-VkAndroidHardwareBufferFormatProperties2ANDROID-sType-sType
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS

        // Validation code for VkPhysicalDeviceShaderEnqueueFeaturesAMDX structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX: {  // Covers
                                                                                // VUID-VkPhysicalDeviceShaderEnqueueFeaturesAMDX-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderEnqueueFeaturesAMDX);
                VkPhysicalDeviceShaderEnqueueFeaturesAMDX* structure = (VkPhysicalDeviceShaderEnqueueFeaturesAMDX*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderEnqueue), structure->shaderEnqueue);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderEnqueuePropertiesAMDX structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderEnqueuePropertiesAMDX-sType-sType

        // No Validation code for VkPipelineShaderStageNodeCreateInfoAMDX structure members  -- Covers
        // VUID-VkPipelineShaderStageNodeCreateInfoAMDX-sType-sType
#endif  // VK_ENABLE_BETA_EXTENSIONS

        // Validation code for VkSampleLocationsInfoEXT structure members
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: {  // Covers VUID-VkSampleLocationsInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSampleLocationsInfoEXT);
                VkSampleLocationsInfoEXT* structure = (VkSampleLocationsInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::sampleLocationsCount), pNext_loc.dot(Field::pSampleLocations),
                                      structure->sampleLocationsCount, &structure->pSampleLocations, false, true, kVUIDUndefined,
                                      "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                if (structure->pSampleLocations != nullptr) {
                    for (uint32_t sampleLocationsIndex = 0; sampleLocationsIndex < structure->sampleLocationsCount;
                         ++sampleLocationsIndex) {
                        [[maybe_unused]] const Location pSampleLocations_loc =
                            pNext_loc.dot(Field::pSampleLocations, sampleLocationsIndex);
                    }
                }
            }
        } break;

        // Validation code for VkRenderPassSampleLocationsBeginInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT: {  // Covers
                                                                               // VUID-VkRenderPassSampleLocationsBeginInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassSampleLocationsBeginInfoEXT);
                VkRenderPassSampleLocationsBeginInfoEXT* structure = (VkRenderPassSampleLocationsBeginInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::attachmentInitialSampleLocationsCount),
                                      pNext_loc.dot(Field::pAttachmentInitialSampleLocations),
                                      structure->attachmentInitialSampleLocationsCount,
                                      &structure->pAttachmentInitialSampleLocations, false, true, kVUIDUndefined,
                                      "VUID-VkRenderPassSampleLocationsBeginInfoEXT-pAttachmentInitialSampleLocations-parameter");

                if (structure->pAttachmentInitialSampleLocations != nullptr) {
                    for (uint32_t attachmentInitialSampleLocationsIndex = 0;
                         attachmentInitialSampleLocationsIndex < structure->attachmentInitialSampleLocationsCount;
                         ++attachmentInitialSampleLocationsIndex) {
                        [[maybe_unused]] const Location pAttachmentInitialSampleLocations_loc =
                            pNext_loc.dot(Field::pAttachmentInitialSampleLocations, attachmentInitialSampleLocationsIndex);
                        skip |=
                            ValidateStructType(pAttachmentInitialSampleLocations_loc.dot(Field::sampleLocationsInfo),
                                               "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT",
                                               &(structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex]
                                                     .sampleLocationsInfo),
                                               VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, false, kVUIDUndefined,
                                               "VUID-VkSampleLocationsInfoEXT-sType-sType");

                        skip |=
                            ValidateArray(pAttachmentInitialSampleLocations_loc.dot(Field::sampleLocationsCount),
                                          pAttachmentInitialSampleLocations_loc.dot(Field::pSampleLocations),
                                          structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex]
                                              .sampleLocationsInfo.sampleLocationsCount,
                                          &structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex]
                                               .sampleLocationsInfo.pSampleLocations,
                                          false, true, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                        if (structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex]
                                .sampleLocationsInfo.pSampleLocations != nullptr) {
                            for (uint32_t sampleLocationsIndex = 0;
                                 sampleLocationsIndex <
                                 structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex]
                                     .sampleLocationsInfo.sampleLocationsCount;
                                 ++sampleLocationsIndex) {
                                [[maybe_unused]] const Location pSampleLocations_loc =
                                    pAttachmentInitialSampleLocations_loc.dot(Field::pSampleLocations, sampleLocationsIndex);
                            }
                        }
                    }
                }

                skip |= ValidateArray(pNext_loc.dot(Field::postSubpassSampleLocationsCount),
                                      pNext_loc.dot(Field::pPostSubpassSampleLocations), structure->postSubpassSampleLocationsCount,
                                      &structure->pPostSubpassSampleLocations, false, true, kVUIDUndefined,
                                      "VUID-VkRenderPassSampleLocationsBeginInfoEXT-pPostSubpassSampleLocations-parameter");

                if (structure->pPostSubpassSampleLocations != nullptr) {
                    for (uint32_t postSubpassSampleLocationsIndex = 0;
                         postSubpassSampleLocationsIndex < structure->postSubpassSampleLocationsCount;
                         ++postSubpassSampleLocationsIndex) {
                        [[maybe_unused]] const Location pPostSubpassSampleLocations_loc =
                            pNext_loc.dot(Field::pPostSubpassSampleLocations, postSubpassSampleLocationsIndex);
                        skip |= ValidateStructType(
                            pPostSubpassSampleLocations_loc.dot(Field::sampleLocationsInfo),
                            "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT",
                            &(structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex].sampleLocationsInfo),
                            VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, false, kVUIDUndefined,
                            "VUID-VkSampleLocationsInfoEXT-sType-sType");

                        skip |=
                            ValidateArray(pPostSubpassSampleLocations_loc.dot(Field::sampleLocationsCount),
                                          pPostSubpassSampleLocations_loc.dot(Field::pSampleLocations),
                                          structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex]
                                              .sampleLocationsInfo.sampleLocationsCount,
                                          &structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex]
                                               .sampleLocationsInfo.pSampleLocations,
                                          false, true, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                        if (structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex]
                                .sampleLocationsInfo.pSampleLocations != nullptr) {
                            for (uint32_t sampleLocationsIndex = 0;
                                 sampleLocationsIndex < structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex]
                                                            .sampleLocationsInfo.sampleLocationsCount;
                                 ++sampleLocationsIndex) {
                                [[maybe_unused]] const Location pSampleLocations_loc =
                                    pPostSubpassSampleLocations_loc.dot(Field::pSampleLocations, sampleLocationsIndex);
                            }
                        }
                    }
                }
            }
        } break;

        // Validation code for VkPipelineSampleLocationsStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                   // VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineSampleLocationsStateCreateInfoEXT);
                VkPipelineSampleLocationsStateCreateInfoEXT* structure = (VkPipelineSampleLocationsStateCreateInfoEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::sampleLocationsEnable), structure->sampleLocationsEnable);

                skip |= ValidateStructType(pNext_loc.dot(Field::sampleLocationsInfo), "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT",
                                           &(structure->sampleLocationsInfo), VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, false,
                                           kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-sType-sType");

                skip |= ValidateArray(pNext_loc.dot(Field::sampleLocationsCount), pNext_loc.dot(Field::pSampleLocations),
                                      structure->sampleLocationsInfo.sampleLocationsCount,
                                      &structure->sampleLocationsInfo.pSampleLocations, false, true, kVUIDUndefined,
                                      "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                if (structure->sampleLocationsInfo.pSampleLocations != nullptr) {
                    for (uint32_t sampleLocationsIndex = 0;
                         sampleLocationsIndex < structure->sampleLocationsInfo.sampleLocationsCount; ++sampleLocationsIndex) {
                        [[maybe_unused]] const Location pSampleLocations_loc =
                            pNext_loc.dot(Field::pSampleLocations, sampleLocationsIndex);
                    }
                }
            }
        } break;

        // No Validation code for VkPhysicalDeviceSampleLocationsPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceSampleLocationsPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT);
                VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* structure =
                    (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::advancedBlendCoherentOperations),
                                       structure->advancedBlendCoherentOperations);
            }
        } break;

        // No Validation code for VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-sType-sType

        // Validation code for VkPipelineColorBlendAdvancedStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                       // VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineColorBlendAdvancedStateCreateInfoEXT);
                VkPipelineColorBlendAdvancedStateCreateInfoEXT* structure = (VkPipelineColorBlendAdvancedStateCreateInfoEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::srcPremultiplied), structure->srcPremultiplied);

                skip |= ValidateBool32(pNext_loc.dot(Field::dstPremultiplied), structure->dstPremultiplied);

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::blendOverlap), "VkBlendOverlapEXT", structure->blendOverlap,
                                           "VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-parameter");
            }
        } break;

        // Validation code for VkPipelineCoverageToColorStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV: {  // Covers
                                                                                   // VUID-VkPipelineCoverageToColorStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineCoverageToColorStateCreateInfoNV);
                VkPipelineCoverageToColorStateCreateInfoNV* structure = (VkPipelineCoverageToColorStateCreateInfoNV*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineCoverageToColorStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateBool32(pNext_loc.dot(Field::coverageToColorEnable), structure->coverageToColorEnable);
            }
        } break;

        // Validation code for VkPipelineCoverageModulationStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV: {  // Covers
                                                                                     // VUID-VkPipelineCoverageModulationStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineCoverageModulationStateCreateInfoNV);
                VkPipelineCoverageModulationStateCreateInfoNV* structure = (VkPipelineCoverageModulationStateCreateInfoNV*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineCoverageModulationStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::coverageModulationMode), "VkCoverageModulationModeNV",
                                           structure->coverageModulationMode,
                                           "VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationMode-parameter");

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::coverageModulationTableEnable), structure->coverageModulationTableEnable);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderSMBuiltinsPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceShaderSMBuiltinsFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderSMBuiltinsFeaturesNV);
                VkPhysicalDeviceShaderSMBuiltinsFeaturesNV* structure = (VkPhysicalDeviceShaderSMBuiltinsFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSMBuiltins), structure->shaderSMBuiltins);
            }
        } break;

        // No Validation code for VkDrmFormatModifierPropertiesListEXT structure members  -- Covers
        // VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType

        // Validation code for VkPhysicalDeviceImageDrmFormatModifierInfoEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageDrmFormatModifierInfoEXT);
                VkPhysicalDeviceImageDrmFormatModifierInfoEXT* structure = (VkPhysicalDeviceImageDrmFormatModifierInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::sharingMode), "VkSharingMode", structure->sharingMode,
                                           "VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-parameter");
            }
        } break;

        // Validation code for VkImageDrmFormatModifierListCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT: {  // Covers
                                                                                  // VUID-VkImageDrmFormatModifierListCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImageDrmFormatModifierListCreateInfoEXT);
                VkImageDrmFormatModifierListCreateInfoEXT* structure = (VkImageDrmFormatModifierListCreateInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::drmFormatModifierCount), pNext_loc.dot(Field::pDrmFormatModifiers),
                                      structure->drmFormatModifierCount, &structure->pDrmFormatModifiers, true, true,
                                      "VUID-VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount-arraylength",
                                      "VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-parameter");
            }
        } break;

        // Validation code for VkImageDrmFormatModifierExplicitCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT: {  // Covers
                                                                                      // VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImageDrmFormatModifierExplicitCreateInfoEXT);
                VkImageDrmFormatModifierExplicitCreateInfoEXT* structure = (VkImageDrmFormatModifierExplicitCreateInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::drmFormatModifierPlaneCount), pNext_loc.dot(Field::pPlaneLayouts),
                                      structure->drmFormatModifierPlaneCount, &structure->pPlaneLayouts, true, true,
                                      "VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount-arraylength",
                                      "VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts-parameter");

                if (structure->pPlaneLayouts != nullptr) {
                    for (uint32_t drmFormatModifierPlaneIndex = 0;
                         drmFormatModifierPlaneIndex < structure->drmFormatModifierPlaneCount; ++drmFormatModifierPlaneIndex) {
                        [[maybe_unused]] const Location pPlaneLayouts_loc =
                            pNext_loc.dot(Field::pPlaneLayouts, drmFormatModifierPlaneIndex);
                    }
                }
            }
        } break;

        // No Validation code for VkDrmFormatModifierPropertiesList2EXT structure members  -- Covers
        // VUID-VkDrmFormatModifierPropertiesList2EXT-sType-sType

        // Validation code for VkShaderModuleValidationCacheCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT: {  // Covers
                                                                                  // VUID-VkShaderModuleValidationCacheCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkShaderModuleValidationCacheCreateInfoEXT);
                VkShaderModuleValidationCacheCreateInfoEXT* structure = (VkShaderModuleValidationCacheCreateInfoEXT*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::validationCache), structure->validationCache);
            }
        } break;

        // Validation code for VkPipelineViewportShadingRateImageStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV: {  // Covers
                                                                                             // VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineViewportShadingRateImageStateCreateInfoNV);
                VkPipelineViewportShadingRateImageStateCreateInfoNV* structure =
                    (VkPipelineViewportShadingRateImageStateCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shadingRateImageEnable), structure->shadingRateImageEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceShadingRateImageFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceShadingRateImageFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShadingRateImageFeaturesNV);
                VkPhysicalDeviceShadingRateImageFeaturesNV* structure = (VkPhysicalDeviceShadingRateImageFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shadingRateImage), structure->shadingRateImage);

                skip |= ValidateBool32(pNext_loc.dot(Field::shadingRateCoarseSampleOrder), structure->shadingRateCoarseSampleOrder);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShadingRateImagePropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceShadingRateImagePropertiesNV-sType-sType

        // Validation code for VkPipelineViewportCoarseSampleOrderStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV: {  // Covers
                                                                                              // VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineViewportCoarseSampleOrderStateCreateInfoNV);
                VkPipelineViewportCoarseSampleOrderStateCreateInfoNV* structure =
                    (VkPipelineViewportCoarseSampleOrderStateCreateInfoNV*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::sampleOrderType), "VkCoarseSampleOrderTypeNV",
                                           structure->sampleOrderType,
                                           "VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-parameter");

                skip |=
                    ValidateArray(pNext_loc.dot(Field::customSampleOrderCount), pNext_loc.dot(Field::pCustomSampleOrders),
                                  structure->customSampleOrderCount, &structure->pCustomSampleOrders, false, true, kVUIDUndefined,
                                  "VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-parameter");

                if (structure->pCustomSampleOrders != nullptr) {
                    for (uint32_t customSampleOrderIndex = 0; customSampleOrderIndex < structure->customSampleOrderCount;
                         ++customSampleOrderIndex) {
                        [[maybe_unused]] const Location pCustomSampleOrders_loc =
                            pNext_loc.dot(Field::pCustomSampleOrders, customSampleOrderIndex);
                        skip |= ValidateRangedEnum(pCustomSampleOrders_loc.dot(Field::shadingRate), "VkShadingRatePaletteEntryNV",
                                                   structure->pCustomSampleOrders[customSampleOrderIndex].shadingRate,
                                                   "VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter");

                        skip |= ValidateArray(pCustomSampleOrders_loc.dot(Field::sampleLocationCount),
                                              pCustomSampleOrders_loc.dot(Field::pSampleLocations),
                                              structure->pCustomSampleOrders[customSampleOrderIndex].sampleLocationCount,
                                              &structure->pCustomSampleOrders[customSampleOrderIndex].pSampleLocations, true, true,
                                              "VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength",
                                              "VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter");

                        if (structure->pCustomSampleOrders[customSampleOrderIndex].pSampleLocations != nullptr) {
                            for (uint32_t sampleLocationIndex = 0;
                                 sampleLocationIndex < structure->pCustomSampleOrders[customSampleOrderIndex].sampleLocationCount;
                                 ++sampleLocationIndex) {
                                [[maybe_unused]] const Location pSampleLocations_loc =
                                    pCustomSampleOrders_loc.dot(Field::pSampleLocations, sampleLocationIndex);
                            }
                        }
                    }
                }
            }
        } break;

        // Validation code for VkWriteDescriptorSetAccelerationStructureNV structure members
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV: {  // Covers
                                                                                  // VUID-VkWriteDescriptorSetAccelerationStructureNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkWriteDescriptorSetAccelerationStructureNV);
                VkWriteDescriptorSetAccelerationStructureNV* structure = (VkWriteDescriptorSetAccelerationStructureNV*)header;
                skip |=
                    ValidateArray(pNext_loc.dot(Field::accelerationStructureCount), pNext_loc.dot(Field::pAccelerationStructures),
                                  structure->accelerationStructureCount, &structure->pAccelerationStructures, true, false,
                                  "VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-arraylength",
                                  "VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceRayTracingPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceRayTracingPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: {  // Covers
                                                                                            // VUID-VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV);
                VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV* structure =
                    (VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::representativeFragmentTest), structure->representativeFragmentTest);
            }
        } break;

        // Validation code for VkPipelineRepresentativeFragmentTestStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV: {  // Covers
                                                                                              // VUID-VkPipelineRepresentativeFragmentTestStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPipelineRepresentativeFragmentTestStateCreateInfoNV);
                VkPipelineRepresentativeFragmentTestStateCreateInfoNV* structure =
                    (VkPipelineRepresentativeFragmentTestStateCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::representativeFragmentTestEnable),
                                       structure->representativeFragmentTestEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageViewImageFormatInfoEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageViewImageFormatInfoEXT);
                VkPhysicalDeviceImageViewImageFormatInfoEXT* structure = (VkPhysicalDeviceImageViewImageFormatInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::imageViewType), "VkImageViewType", structure->imageViewType,
                                           "VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-imageViewType-parameter");
            }
        } break;

        // No Validation code for VkFilterCubicImageViewImageFormatPropertiesEXT structure members  -- Covers
        // VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType

        // Validation code for VkImportMemoryHostPointerInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: {  // Covers VUID-VkImportMemoryHostPointerInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMemoryHostPointerInfoEXT);
                VkImportMemoryHostPointerInfoEXT* structure = (VkImportMemoryHostPointerInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kRequiredSingleBit,
                                      "VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter",
                                      "VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter");

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pHostPointer), structure->pHostPointer,
                                                "VUID-VkImportMemoryHostPointerInfoEXT-pHostPointer-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceExternalMemoryHostPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceExternalMemoryHostPropertiesEXT-sType-sType

        // Validation code for VkPipelineCompilerControlCreateInfoAMD structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD: {  // Covers
                                                                             // VUID-VkPipelineCompilerControlCreateInfoAMD-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineCompilerControlCreateInfoAMD);
                VkPipelineCompilerControlCreateInfoAMD* structure = (VkPipelineCompilerControlCreateInfoAMD*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::compilerControlFlags), structure->compilerControlFlags,
                                              "VUID-VkPipelineCompilerControlCreateInfoAMD-compilerControlFlags-zerobitmask");
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCorePropertiesAMD structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderCorePropertiesAMD-sType-sType

        // Validation code for VkDeviceMemoryOverallocationCreateInfoAMD structure members
        case VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD: {  // Covers
                                                                                // VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceMemoryOverallocationCreateInfoAMD);
                VkDeviceMemoryOverallocationCreateInfoAMD* structure = (VkDeviceMemoryOverallocationCreateInfoAMD*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::overallocationBehavior), "VkMemoryOverallocationBehaviorAMD",
                                           structure->overallocationBehavior,
                                           "VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-sType-sType
#ifdef VK_USE_PLATFORM_GGP

        // No Validation code for VkPresentFrameTokenGGP structure members  -- Covers VUID-VkPresentFrameTokenGGP-sType-sType
#endif  // VK_USE_PLATFORM_GGP

        // Validation code for VkPhysicalDeviceComputeShaderDerivativesFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceComputeShaderDerivativesFeaturesNV);
                VkPhysicalDeviceComputeShaderDerivativesFeaturesNV* structure =
                    (VkPhysicalDeviceComputeShaderDerivativesFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::computeDerivativeGroupQuads), structure->computeDerivativeGroupQuads);

                skip |= ValidateBool32(pNext_loc.dot(Field::computeDerivativeGroupLinear), structure->computeDerivativeGroupLinear);
            }
        } break;

        // Validation code for VkPhysicalDeviceMeshShaderFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: {  // Covers
                                                                           // VUID-VkPhysicalDeviceMeshShaderFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMeshShaderFeaturesNV);
                VkPhysicalDeviceMeshShaderFeaturesNV* structure = (VkPhysicalDeviceMeshShaderFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::taskShader), structure->taskShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::meshShader), structure->meshShader);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMeshShaderPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceMeshShaderPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceShaderImageFootprintFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceShaderImageFootprintFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderImageFootprintFeaturesNV);
                VkPhysicalDeviceShaderImageFootprintFeaturesNV* structure = (VkPhysicalDeviceShaderImageFootprintFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::imageFootprint), structure->imageFootprint);
            }
        } break;

        // No Validation code for VkPipelineViewportExclusiveScissorStateCreateInfoNV structure members  -- Covers
        // VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-sType-sType

        // Validation code for VkPhysicalDeviceExclusiveScissorFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceExclusiveScissorFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExclusiveScissorFeaturesNV);
                VkPhysicalDeviceExclusiveScissorFeaturesNV* structure = (VkPhysicalDeviceExclusiveScissorFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::exclusiveScissor), structure->exclusiveScissor);
            }
        } break;

        // No Validation code for VkQueueFamilyCheckpointPropertiesNV structure members  -- Covers
        // VUID-VkQueueFamilyCheckpointPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: {  // Covers
                                                                                             // VUID-VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL);
                VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL* structure =
                    (VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderIntegerFunctions2), structure->shaderIntegerFunctions2);
            }
        } break;

        // Validation code for VkQueryPoolPerformanceQueryCreateInfoINTEL structure members
        case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL: {  // Covers
                                                                                  // VUID-VkQueryPoolPerformanceQueryCreateInfoINTEL-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkQueryPoolPerformanceQueryCreateInfoINTEL);
                VkQueryPoolPerformanceQueryCreateInfoINTEL* structure = (VkQueryPoolPerformanceQueryCreateInfoINTEL*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::performanceCountersSampling), "VkQueryPoolSamplingModeINTEL",
                                           structure->performanceCountersSampling,
                                           "VUID-VkQueryPoolPerformanceQueryCreateInfoINTEL-performanceCountersSampling-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDevicePCIBusInfoPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDevicePCIBusInfoPropertiesEXT-sType-sType

        // No Validation code for VkDisplayNativeHdrSurfaceCapabilitiesAMD structure members  -- Covers
        // VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType

        // Validation code for VkSwapchainDisplayNativeHdrCreateInfoAMD structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD: {  // Covers
                                                                                // VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainDisplayNativeHdrCreateInfoAMD);
                VkSwapchainDisplayNativeHdrCreateInfoAMD* structure = (VkSwapchainDisplayNativeHdrCreateInfoAMD*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::localDimmingEnable), structure->localDimmingEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentDensityMapFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceFragmentDensityMapFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentDensityMapFeaturesEXT);
                VkPhysicalDeviceFragmentDensityMapFeaturesEXT* structure = (VkPhysicalDeviceFragmentDensityMapFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentDensityMap), structure->fragmentDensityMap);

                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentDensityMapDynamic), structure->fragmentDensityMapDynamic);

                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentDensityMapNonSubsampledImages),
                                       structure->fragmentDensityMapNonSubsampledImages);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentDensityMapPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceFragmentDensityMapPropertiesEXT-sType-sType

        // Validation code for VkRenderPassFragmentDensityMapCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT: {  // Covers
                                                                                    // VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassFragmentDensityMapCreateInfoEXT);
                VkRenderPassFragmentDensityMapCreateInfoEXT* structure = (VkRenderPassFragmentDensityMapCreateInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::layout), "VkImageLayout",
                                           structure->fragmentDensityMapAttachment.layout,
                                           "VUID-VkAttachmentReference-layout-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCoreProperties2AMD structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderCoreProperties2AMD-sType-sType

        // Validation code for VkPhysicalDeviceCoherentMemoryFeaturesAMD structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: {  // Covers
                                                                                // VUID-VkPhysicalDeviceCoherentMemoryFeaturesAMD-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCoherentMemoryFeaturesAMD);
                VkPhysicalDeviceCoherentMemoryFeaturesAMD* structure = (VkPhysicalDeviceCoherentMemoryFeaturesAMD*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::deviceCoherentMemory), structure->deviceCoherentMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT);
                VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT* structure =
                    (VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderImageInt64Atomics), structure->shaderImageInt64Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseImageInt64Atomics), structure->sparseImageInt64Atomics);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMemoryBudgetPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceMemoryBudgetPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceMemoryPriorityFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: {  // Covers
                                                                                // VUID-VkPhysicalDeviceMemoryPriorityFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMemoryPriorityFeaturesEXT);
                VkPhysicalDeviceMemoryPriorityFeaturesEXT* structure = (VkPhysicalDeviceMemoryPriorityFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::memoryPriority), structure->memoryPriority);
            }
        } break;

        // No Validation code for VkMemoryPriorityAllocateInfoEXT structure members  -- Covers
        // VUID-VkMemoryPriorityAllocateInfoEXT-sType-sType

        // Validation code for VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: {  // Covers
                                                                                                   // VUID-VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV);
                VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV* structure =
                    (VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::dedicatedAllocationImageAliasing),
                                       structure->dedicatedAllocationImageAliasing);
            }
        } break;

        // Validation code for VkPhysicalDeviceBufferDeviceAddressFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceBufferDeviceAddressFeaturesEXT);
                VkPhysicalDeviceBufferDeviceAddressFeaturesEXT* structure = (VkPhysicalDeviceBufferDeviceAddressFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddress), structure->bufferDeviceAddress);

                skip |= ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddressCaptureReplay),
                                       structure->bufferDeviceAddressCaptureReplay);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::bufferDeviceAddressMultiDevice), structure->bufferDeviceAddressMultiDevice);
            }
        } break;

        // No Validation code for VkBufferDeviceAddressCreateInfoEXT structure members  -- Covers
        // VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType

        // Validation code for VkValidationFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: {  // Covers VUID-VkValidationFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkValidationFeaturesEXT);
                VkValidationFeaturesEXT* structure = (VkValidationFeaturesEXT*)header;
                skip |= ValidateRangedEnumArray(pNext_loc.dot(Field::enabledValidationFeatureCount),
                                                pNext_loc.dot(Field::pEnabledValidationFeatures), "VkValidationFeatureEnableEXT",
                                                structure->enabledValidationFeatureCount, structure->pEnabledValidationFeatures,
                                                false, true);

                skip |= ValidateRangedEnumArray(pNext_loc.dot(Field::disabledValidationFeatureCount),
                                                pNext_loc.dot(Field::pDisabledValidationFeatures), "VkValidationFeatureDisableEXT",
                                                structure->disabledValidationFeatureCount, structure->pDisabledValidationFeatures,
                                                false, true);
            }
        } break;

        // Validation code for VkPhysicalDeviceCooperativeMatrixFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceCooperativeMatrixFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCooperativeMatrixFeaturesNV);
                VkPhysicalDeviceCooperativeMatrixFeaturesNV* structure = (VkPhysicalDeviceCooperativeMatrixFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::cooperativeMatrix), structure->cooperativeMatrix);

                skip |= ValidateBool32(pNext_loc.dot(Field::cooperativeMatrixRobustBufferAccess),
                                       structure->cooperativeMatrixRobustBufferAccess);
            }
        } break;

        // No Validation code for VkPhysicalDeviceCooperativeMatrixPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceCooperativeMatrixPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceCoverageReductionModeFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceCoverageReductionModeFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCoverageReductionModeFeaturesNV);
                VkPhysicalDeviceCoverageReductionModeFeaturesNV* structure =
                    (VkPhysicalDeviceCoverageReductionModeFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::coverageReductionMode), structure->coverageReductionMode);
            }
        } break;

        // Validation code for VkPipelineCoverageReductionStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV: {  // Covers
                                                                                    // VUID-VkPipelineCoverageReductionStateCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineCoverageReductionStateCreateInfoNV);
                VkPipelineCoverageReductionStateCreateInfoNV* structure = (VkPipelineCoverageReductionStateCreateInfoNV*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkPipelineCoverageReductionStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::coverageReductionMode), "VkCoverageReductionModeNV",
                                           structure->coverageReductionMode,
                                           "VUID-VkPipelineCoverageReductionStateCreateInfoNV-coverageReductionMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT);
                VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT* structure =
                    (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT*)header;
                skip |=
                    ValidateBool32(pNext_loc.dot(Field::fragmentShaderSampleInterlock), structure->fragmentShaderSampleInterlock);

                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentShaderPixelInterlock), structure->fragmentShaderPixelInterlock);

                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentShaderShadingRateInterlock),
                                       structure->fragmentShaderShadingRateInterlock);
            }
        } break;

        // Validation code for VkPhysicalDeviceYcbcrImageArraysFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceYcbcrImageArraysFeaturesEXT);
                VkPhysicalDeviceYcbcrImageArraysFeaturesEXT* structure = (VkPhysicalDeviceYcbcrImageArraysFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::ycbcrImageArrays), structure->ycbcrImageArrays);
            }
        } break;

        // Validation code for VkPhysicalDeviceProvokingVertexFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceProvokingVertexFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceProvokingVertexFeaturesEXT);
                VkPhysicalDeviceProvokingVertexFeaturesEXT* structure = (VkPhysicalDeviceProvokingVertexFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::provokingVertexLast), structure->provokingVertexLast);

                skip |= ValidateBool32(pNext_loc.dot(Field::transformFeedbackPreservesProvokingVertex),
                                       structure->transformFeedbackPreservesProvokingVertex);
            }
        } break;

        // No Validation code for VkPhysicalDeviceProvokingVertexPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceProvokingVertexPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationProvokingVertexStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                                 // VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPipelineRasterizationProvokingVertexStateCreateInfoEXT);
                VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* structure =
                    (VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*)header;
                skip |= ValidateRangedEnum(
                    pNext_loc.dot(Field::provokingVertexMode), "VkProvokingVertexModeEXT", structure->provokingVertexMode,
                    "VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-provokingVertexMode-parameter");
            }
        } break;
#ifdef VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkSurfaceFullScreenExclusiveInfoEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT: {  // Covers
                                                                          // VUID-VkSurfaceFullScreenExclusiveInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSurfaceFullScreenExclusiveInfoEXT);
                VkSurfaceFullScreenExclusiveInfoEXT* structure = (VkSurfaceFullScreenExclusiveInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::fullScreenExclusive), "VkFullScreenExclusiveEXT",
                                           structure->fullScreenExclusive,
                                           "VUID-VkSurfaceFullScreenExclusiveInfoEXT-fullScreenExclusive-parameter");
            }
        } break;

        // Validation code for VkSurfaceCapabilitiesFullScreenExclusiveEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT: {  // Covers
                                                                                  // VUID-VkSurfaceCapabilitiesFullScreenExclusiveEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSurfaceCapabilitiesFullScreenExclusiveEXT);
                VkSurfaceCapabilitiesFullScreenExclusiveEXT* structure = (VkSurfaceCapabilitiesFullScreenExclusiveEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::fullScreenExclusiveSupported), structure->fullScreenExclusiveSupported);
            }
        } break;

        // No Validation code for VkSurfaceFullScreenExclusiveWin32InfoEXT structure members  -- Covers
        // VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-sType-sType
#endif  // VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkPhysicalDeviceLineRasterizationFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceLineRasterizationFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceLineRasterizationFeaturesEXT);
                VkPhysicalDeviceLineRasterizationFeaturesEXT* structure = (VkPhysicalDeviceLineRasterizationFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rectangularLines), structure->rectangularLines);

                skip |= ValidateBool32(pNext_loc.dot(Field::bresenhamLines), structure->bresenhamLines);

                skip |= ValidateBool32(pNext_loc.dot(Field::smoothLines), structure->smoothLines);

                skip |= ValidateBool32(pNext_loc.dot(Field::stippledRectangularLines), structure->stippledRectangularLines);

                skip |= ValidateBool32(pNext_loc.dot(Field::stippledBresenhamLines), structure->stippledBresenhamLines);

                skip |= ValidateBool32(pNext_loc.dot(Field::stippledSmoothLines), structure->stippledSmoothLines);
            }
        } break;

        // No Validation code for VkPhysicalDeviceLineRasterizationPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceLineRasterizationPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationLineStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: {  // Covers
                                                                                     // VUID-VkPipelineRasterizationLineStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineRasterizationLineStateCreateInfoEXT);
                VkPipelineRasterizationLineStateCreateInfoEXT* structure = (VkPipelineRasterizationLineStateCreateInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::lineRasterizationMode), "VkLineRasterizationModeEXT",
                                           structure->lineRasterizationMode,
                                           "VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-parameter");

                skip |= ValidateBool32(pNext_loc.dot(Field::stippledLineEnable), structure->stippledLineEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderAtomicFloatFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderAtomicFloatFeaturesEXT);
                VkPhysicalDeviceShaderAtomicFloatFeaturesEXT* structure = (VkPhysicalDeviceShaderAtomicFloatFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat32Atomics), structure->shaderBufferFloat32Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat32AtomicAdd), structure->shaderBufferFloat32AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat64Atomics), structure->shaderBufferFloat64Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat64AtomicAdd), structure->shaderBufferFloat64AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat32Atomics), structure->shaderSharedFloat32Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat32AtomicAdd), structure->shaderSharedFloat32AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat64Atomics), structure->shaderSharedFloat64Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat64AtomicAdd), structure->shaderSharedFloat64AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderImageFloat32Atomics), structure->shaderImageFloat32Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderImageFloat32AtomicAdd), structure->shaderImageFloat32AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseImageFloat32Atomics), structure->sparseImageFloat32Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::sparseImageFloat32AtomicAdd), structure->sparseImageFloat32AtomicAdd);
            }
        } break;

        // Validation code for VkPhysicalDeviceIndexTypeUint8FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceIndexTypeUint8FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceIndexTypeUint8FeaturesEXT);
                VkPhysicalDeviceIndexTypeUint8FeaturesEXT* structure = (VkPhysicalDeviceIndexTypeUint8FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::indexTypeUint8), structure->indexTypeUint8);
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicStateFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceExtendedDynamicStateFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExtendedDynamicStateFeaturesEXT);
                VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* structure =
                    (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState), structure->extendedDynamicState);
            }
        } break;

        // Validation code for VkPhysicalDeviceHostImageCopyFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES_EXT: {  // Covers
                                                                                // VUID-VkPhysicalDeviceHostImageCopyFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceHostImageCopyFeaturesEXT);
                VkPhysicalDeviceHostImageCopyFeaturesEXT* structure = (VkPhysicalDeviceHostImageCopyFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::hostImageCopy), structure->hostImageCopy);
            }
        } break;

        // Validation code for VkPhysicalDeviceHostImageCopyPropertiesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES_EXT: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceHostImageCopyPropertiesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceHostImageCopyPropertiesEXT);
                VkPhysicalDeviceHostImageCopyPropertiesEXT* structure = (VkPhysicalDeviceHostImageCopyPropertiesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::identicalMemoryTypeRequirements),
                                       structure->identicalMemoryTypeRequirements);
            }
        } break;

        // No Validation code for VkSubresourceHostMemcpySizeEXT structure members  -- Covers
        // VUID-VkSubresourceHostMemcpySizeEXT-sType-sType

        // No Validation code for VkHostImageCopyDevicePerformanceQueryEXT structure members  -- Covers
        // VUID-VkHostImageCopyDevicePerformanceQueryEXT-sType-sType

        // Validation code for VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT);
                VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT* structure = (VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat16Atomics), structure->shaderBufferFloat16Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat16AtomicAdd), structure->shaderBufferFloat16AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat16AtomicMinMax),
                                       structure->shaderBufferFloat16AtomicMinMax);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat32AtomicMinMax),
                                       structure->shaderBufferFloat32AtomicMinMax);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderBufferFloat64AtomicMinMax),
                                       structure->shaderBufferFloat64AtomicMinMax);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat16Atomics), structure->shaderSharedFloat16Atomics);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat16AtomicAdd), structure->shaderSharedFloat16AtomicAdd);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat16AtomicMinMax),
                                       structure->shaderSharedFloat16AtomicMinMax);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat32AtomicMinMax),
                                       structure->shaderSharedFloat32AtomicMinMax);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderSharedFloat64AtomicMinMax),
                                       structure->shaderSharedFloat64AtomicMinMax);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::shaderImageFloat32AtomicMinMax), structure->shaderImageFloat32AtomicMinMax);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::sparseImageFloat32AtomicMinMax), structure->sparseImageFloat32AtomicMinMax);
            }
        } break;

        // Validation code for VkSurfacePresentModeEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT: {  // Covers VUID-VkSurfacePresentModeEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSurfacePresentModeEXT);
                VkSurfacePresentModeEXT* structure = (VkSurfacePresentModeEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::presentMode), "VkPresentModeKHR", structure->presentMode,
                                           "VUID-VkSurfacePresentModeEXT-presentMode-parameter");
            }
        } break;

        // Validation code for VkSurfacePresentScalingCapabilitiesEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT: {  // Covers
                                                                            // VUID-VkSurfacePresentScalingCapabilitiesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSurfacePresentScalingCapabilitiesEXT);
                VkSurfacePresentScalingCapabilitiesEXT* structure = (VkSurfacePresentScalingCapabilitiesEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::supportedPresentScaling), "VkPresentScalingFlagBitsEXT",
                                      AllVkPresentScalingFlagBitsEXT, structure->supportedPresentScaling, kOptionalFlags,
                                      "VUID-VkSurfacePresentScalingCapabilitiesEXT-supportedPresentScaling-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::supportedPresentGravityX), "VkPresentGravityFlagBitsEXT",
                                      AllVkPresentGravityFlagBitsEXT, structure->supportedPresentGravityX, kOptionalFlags,
                                      "VUID-VkSurfacePresentScalingCapabilitiesEXT-supportedPresentGravityX-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::supportedPresentGravityY), "VkPresentGravityFlagBitsEXT",
                                      AllVkPresentGravityFlagBitsEXT, structure->supportedPresentGravityY, kOptionalFlags,
                                      "VUID-VkSurfacePresentScalingCapabilitiesEXT-supportedPresentGravityY-parameter");
            }
        } break;

        // No Validation code for VkSurfacePresentModeCompatibilityEXT structure members  -- Covers
        // VUID-VkSurfacePresentModeCompatibilityEXT-sType-sType

        // Validation code for VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {  // Covers
                                                                                        // VUID-VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT);
                VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT* structure =
                    (VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::swapchainMaintenance1), structure->swapchainMaintenance1);
            }
        } break;

        // Validation code for VkSwapchainPresentFenceInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: {  // Covers VUID-VkSwapchainPresentFenceInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainPresentFenceInfoEXT);
                VkSwapchainPresentFenceInfoEXT* structure = (VkSwapchainPresentFenceInfoEXT*)header;
                skip |= ValidateHandleArray(pNext_loc.dot(Field::swapchainCount), pNext_loc.dot(Field::pFences),
                                            structure->swapchainCount, structure->pFences, true, true, kVUIDUndefined);
            }
        } break;

        // Validation code for VkSwapchainPresentModesCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: {  // Covers
                                                                           // VUID-VkSwapchainPresentModesCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainPresentModesCreateInfoEXT);
                VkSwapchainPresentModesCreateInfoEXT* structure = (VkSwapchainPresentModesCreateInfoEXT*)header;
                skip |=
                    ValidateRangedEnumArray(pNext_loc.dot(Field::presentModeCount), pNext_loc.dot(Field::pPresentModes),
                                            "VkPresentModeKHR", structure->presentModeCount, structure->pPresentModes, true, true);
            }
        } break;

        // Validation code for VkSwapchainPresentModeInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: {  // Covers VUID-VkSwapchainPresentModeInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainPresentModeInfoEXT);
                VkSwapchainPresentModeInfoEXT* structure = (VkSwapchainPresentModeInfoEXT*)header;
                skip |=
                    ValidateRangedEnumArray(pNext_loc.dot(Field::swapchainCount), pNext_loc.dot(Field::pPresentModes),
                                            "VkPresentModeKHR", structure->swapchainCount, structure->pPresentModes, true, true);
            }
        } break;

        // Validation code for VkSwapchainPresentScalingCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: {  // Covers
                                                                             // VUID-VkSwapchainPresentScalingCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainPresentScalingCreateInfoEXT);
                VkSwapchainPresentScalingCreateInfoEXT* structure = (VkSwapchainPresentScalingCreateInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::scalingBehavior), "VkPresentScalingFlagBitsEXT",
                                      AllVkPresentScalingFlagBitsEXT, structure->scalingBehavior, kOptionalFlags,
                                      "VUID-VkSwapchainPresentScalingCreateInfoEXT-scalingBehavior-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::presentGravityX), "VkPresentGravityFlagBitsEXT",
                                      AllVkPresentGravityFlagBitsEXT, structure->presentGravityX, kOptionalFlags,
                                      "VUID-VkSwapchainPresentScalingCreateInfoEXT-presentGravityX-parameter");

                skip |= ValidateFlags(pNext_loc.dot(Field::presentGravityY), "VkPresentGravityFlagBitsEXT",
                                      AllVkPresentGravityFlagBitsEXT, structure->presentGravityY, kOptionalFlags,
                                      "VUID-VkSwapchainPresentScalingCreateInfoEXT-presentGravityY-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV);
                VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV* structure =
                    (VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::deviceGeneratedCommands), structure->deviceGeneratedCommands);
            }
        } break;

        // Validation code for VkGraphicsPipelineShaderGroupsCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV: {  // Covers
                                                                                  // VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkGraphicsPipelineShaderGroupsCreateInfoNV);
                VkGraphicsPipelineShaderGroupsCreateInfoNV* structure = (VkGraphicsPipelineShaderGroupsCreateInfoNV*)header;
                skip |=
                    ValidateStructTypeArray(pNext_loc.dot(Field::groupCount), pNext_loc.dot(Field::pGroups),
                                            "VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV", structure->groupCount,
                                            structure->pGroups, VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV, false, true,
                                            "VUID-VkGraphicsShaderGroupCreateInfoNV-sType-sType",
                                            "VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-parameter", kVUIDUndefined);

                if (structure->pGroups != nullptr) {
                    for (uint32_t groupIndex = 0; groupIndex < structure->groupCount; ++groupIndex) {
                        [[maybe_unused]] const Location pGroups_loc = pNext_loc.dot(Field::pGroups, groupIndex);
                        skip |= ValidateStructTypeArray(
                            pGroups_loc.dot(Field::stageCount), pGroups_loc.dot(Field::pStages),
                            "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO", structure->pGroups[groupIndex].stageCount,
                            structure->pGroups[groupIndex].pStages, VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO, true, true,
                            "VUID-VkPipelineShaderStageCreateInfo-sType-sType",
                            "VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-parameter",
                            "VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-arraylength");

                        if (structure->pGroups[groupIndex].pStages != nullptr) {
                            for (uint32_t stageIndex = 0; stageIndex < structure->pGroups[groupIndex].stageCount; ++stageIndex) {
                                [[maybe_unused]] const Location pStages_loc = pGroups_loc.dot(Field::pStages, stageIndex);
                                skip |= ValidateFlags(pStages_loc.dot(Field::flags), "VkPipelineShaderStageCreateFlagBits",
                                                      AllVkPipelineShaderStageCreateFlagBits,
                                                      structure->pGroups[groupIndex].pStages[stageIndex].flags, kOptionalFlags,
                                                      "VUID-VkPipelineShaderStageCreateInfo-flags-parameter");

                                skip |=
                                    ValidateFlags(pStages_loc.dot(Field::stage), "VkShaderStageFlagBits", AllVkShaderStageFlagBits,
                                                  structure->pGroups[groupIndex].pStages[stageIndex].stage, kRequiredSingleBit,
                                                  "VUID-VkPipelineShaderStageCreateInfo-stage-parameter",
                                                  "VUID-VkPipelineShaderStageCreateInfo-stage-parameter");

                                skip |= ValidateRequiredPointer(pStages_loc.dot(Field::pName),
                                                                structure->pGroups[groupIndex].pStages[stageIndex].pName,
                                                                "VUID-VkPipelineShaderStageCreateInfo-pName-parameter");

                                if (structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo != nullptr) {
                                    [[maybe_unused]] const Location pSpecializationInfo_loc =
                                        pStages_loc.dot(Field::pSpecializationInfo);
                                    skip |= ValidateArray(
                                        pSpecializationInfo_loc.dot(Field::mapEntryCount),
                                        pSpecializationInfo_loc.dot(Field::pMapEntries),
                                        structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->mapEntryCount,
                                        &structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->pMapEntries, false,
                                        true, kVUIDUndefined, "VUID-VkSpecializationInfo-pMapEntries-parameter");

                                    if (structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->pMapEntries !=
                                        nullptr) {
                                        for (uint32_t mapEntryIndex = 0;
                                             mapEntryIndex <
                                             structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->mapEntryCount;
                                             ++mapEntryIndex) {
                                            [[maybe_unused]] const Location pMapEntries_loc =
                                                pSpecializationInfo_loc.dot(Field::pMapEntries, mapEntryIndex);
                                        }
                                    }

                                    skip |= ValidateArray(
                                        pSpecializationInfo_loc.dot(Field::dataSize), pSpecializationInfo_loc.dot(Field::pData),
                                        structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->dataSize,
                                        &structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->pData, false, true,
                                        kVUIDUndefined, "VUID-VkSpecializationInfo-pData-parameter");
                                }
                            }
                        }
                    }
                }

                skip |= ValidateArray(pNext_loc.dot(Field::pipelineCount), pNext_loc.dot(Field::pPipelines),
                                      structure->pipelineCount, &structure->pPipelines, false, true, kVUIDUndefined,
                                      "VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceInheritedViewportScissorFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceInheritedViewportScissorFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceInheritedViewportScissorFeaturesNV);
                VkPhysicalDeviceInheritedViewportScissorFeaturesNV* structure =
                    (VkPhysicalDeviceInheritedViewportScissorFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::inheritedViewportScissor2D), structure->inheritedViewportScissor2D);
            }
        } break;

        // Validation code for VkCommandBufferInheritanceViewportScissorInfoNV structure members
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV: {  // Covers
                                                                                       // VUID-VkCommandBufferInheritanceViewportScissorInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkCommandBufferInheritanceViewportScissorInfoNV);
                VkCommandBufferInheritanceViewportScissorInfoNV* structure =
                    (VkCommandBufferInheritanceViewportScissorInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::viewportScissor2D), structure->viewportScissor2D);
            }
        } break;

        // Validation code for VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT);
                VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* structure =
                    (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::texelBufferAlignment), structure->texelBufferAlignment);
            }
        } break;

        // No Validation code for VkRenderPassTransformBeginInfoQCOM structure members  -- Covers
        // VUID-VkRenderPassTransformBeginInfoQCOM-sType-sType

        // No Validation code for VkCommandBufferInheritanceRenderPassTransformInfoQCOM structure members  -- Covers
        // VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType-sType

        // Validation code for VkPhysicalDeviceDepthBiasControlFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceDepthBiasControlFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDepthBiasControlFeaturesEXT);
                VkPhysicalDeviceDepthBiasControlFeaturesEXT* structure = (VkPhysicalDeviceDepthBiasControlFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::depthBiasControl), structure->depthBiasControl);

                skip |= ValidateBool32(pNext_loc.dot(Field::leastRepresentableValueForceUnormRepresentation),
                                       structure->leastRepresentableValueForceUnormRepresentation);

                skip |= ValidateBool32(pNext_loc.dot(Field::floatRepresentation), structure->floatRepresentation);

                skip |= ValidateBool32(pNext_loc.dot(Field::depthBiasExact), structure->depthBiasExact);
            }
        } break;

        // Validation code for VkDepthBiasRepresentationInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT: {  // Covers VUID-VkDepthBiasRepresentationInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDepthBiasRepresentationInfoEXT);
                VkDepthBiasRepresentationInfoEXT* structure = (VkDepthBiasRepresentationInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::depthBiasRepresentation), "VkDepthBiasRepresentationEXT",
                                           structure->depthBiasRepresentation,
                                           "VUID-VkDepthBiasRepresentationInfoEXT-depthBiasRepresentation-parameter");

                skip |= ValidateBool32(pNext_loc.dot(Field::depthBiasExact), structure->depthBiasExact);
            }
        } break;

        // Validation code for VkPhysicalDeviceDeviceMemoryReportFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceDeviceMemoryReportFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDeviceMemoryReportFeaturesEXT);
                VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* structure = (VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::deviceMemoryReport), structure->deviceMemoryReport);
            }
        } break;

        // Validation code for VkDeviceDeviceMemoryReportCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: {  // Covers
                                                                               // VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceDeviceMemoryReportCreateInfoEXT);
                VkDeviceDeviceMemoryReportCreateInfoEXT* structure = (VkDeviceDeviceMemoryReportCreateInfoEXT*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pfnUserCallback),
                                                reinterpret_cast<const void*>(structure->pfnUserCallback),
                                                "VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback-parameter");

                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pUserData), structure->pUserData,
                                                "VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pUserData-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceRobustness2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: {  // Covers
                                                                             // VUID-VkPhysicalDeviceRobustness2FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRobustness2FeaturesEXT);
                VkPhysicalDeviceRobustness2FeaturesEXT* structure = (VkPhysicalDeviceRobustness2FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::robustBufferAccess2), structure->robustBufferAccess2);

                skip |= ValidateBool32(pNext_loc.dot(Field::robustImageAccess2), structure->robustImageAccess2);

                skip |= ValidateBool32(pNext_loc.dot(Field::nullDescriptor), structure->nullDescriptor);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRobustness2PropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceRobustness2PropertiesEXT-sType-sType

        // Validation code for VkSamplerCustomBorderColorCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: {  // Covers
                                                                               // VUID-VkSamplerCustomBorderColorCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerCustomBorderColorCreateInfoEXT);
                VkSamplerCustomBorderColorCreateInfoEXT* structure = (VkSamplerCustomBorderColorCreateInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::format), "VkFormat", structure->format,
                                           "VUID-VkSamplerCustomBorderColorCreateInfoEXT-format-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceCustomBorderColorPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceCustomBorderColorPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceCustomBorderColorFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceCustomBorderColorFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCustomBorderColorFeaturesEXT);
                VkPhysicalDeviceCustomBorderColorFeaturesEXT* structure = (VkPhysicalDeviceCustomBorderColorFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::customBorderColors), structure->customBorderColors);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::customBorderColorWithoutFormat), structure->customBorderColorWithoutFormat);
            }
        } break;

        // Validation code for VkPhysicalDevicePresentBarrierFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV: {  // Covers
                                                                               // VUID-VkPhysicalDevicePresentBarrierFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePresentBarrierFeaturesNV);
                VkPhysicalDevicePresentBarrierFeaturesNV* structure = (VkPhysicalDevicePresentBarrierFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::presentBarrier), structure->presentBarrier);
            }
        } break;

        // Validation code for VkSurfaceCapabilitiesPresentBarrierNV structure members
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV: {  // Covers
                                                                           // VUID-VkSurfaceCapabilitiesPresentBarrierNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSurfaceCapabilitiesPresentBarrierNV);
                VkSurfaceCapabilitiesPresentBarrierNV* structure = (VkSurfaceCapabilitiesPresentBarrierNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::presentBarrierSupported), structure->presentBarrierSupported);
            }
        } break;

        // Validation code for VkSwapchainPresentBarrierCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV: {  // Covers
                                                                            // VUID-VkSwapchainPresentBarrierCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainPresentBarrierCreateInfoNV);
                VkSwapchainPresentBarrierCreateInfoNV* structure = (VkSwapchainPresentBarrierCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::presentBarrierEnable), structure->presentBarrierEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceDiagnosticsConfigFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceDiagnosticsConfigFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDiagnosticsConfigFeaturesNV);
                VkPhysicalDeviceDiagnosticsConfigFeaturesNV* structure = (VkPhysicalDeviceDiagnosticsConfigFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::diagnosticsConfig), structure->diagnosticsConfig);
            }
        } break;

        // Validation code for VkDeviceDiagnosticsConfigCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV: {  // Covers
                                                                            // VUID-VkDeviceDiagnosticsConfigCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceDiagnosticsConfigCreateInfoNV);
                VkDeviceDiagnosticsConfigCreateInfoNV* structure = (VkDeviceDiagnosticsConfigCreateInfoNV*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkDeviceDiagnosticsConfigFlagBitsNV",
                                      AllVkDeviceDiagnosticsConfigFlagBitsNV, structure->flags, kOptionalFlags,
                                      "VUID-VkDeviceDiagnosticsConfigCreateInfoNV-flags-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceCudaKernelLaunchFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_FEATURES_NV: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceCudaKernelLaunchFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCudaKernelLaunchFeaturesNV);
                VkPhysicalDeviceCudaKernelLaunchFeaturesNV* structure = (VkPhysicalDeviceCudaKernelLaunchFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::cudaKernelLaunchFeatures), structure->cudaKernelLaunchFeatures);
            }
        } break;

        // No Validation code for VkPhysicalDeviceCudaKernelLaunchPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceCudaKernelLaunchPropertiesNV-sType-sType

        // Validation code for VkQueryLowLatencySupportNV structure members
        case VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV: {  // Covers VUID-VkQueryLowLatencySupportNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkQueryLowLatencySupportNV);
                VkQueryLowLatencySupportNV* structure = (VkQueryLowLatencySupportNV*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pQueriedLowLatencyData), structure->pQueriedLowLatencyData,
                                                "VUID-VkQueryLowLatencySupportNV-pQueriedLowLatencyData-parameter");
            }
        } break;
#ifdef VK_USE_PLATFORM_METAL_EXT

        // Validation code for VkExportMetalObjectCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT: {  // Covers VUID-VkExportMetalObjectCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMetalObjectCreateInfoEXT);
                VkExportMetalObjectCreateInfoEXT* structure = (VkExportMetalObjectCreateInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::exportObjectType), "VkExportMetalObjectTypeFlagBitsEXT",
                                      AllVkExportMetalObjectTypeFlagBitsEXT, structure->exportObjectType, kOptionalSingleBit,
                                      "VUID-VkExportMetalObjectCreateInfoEXT-exportObjectType-parameter");
            }
        } break;

        // No Validation code for VkExportMetalDeviceInfoEXT structure members  -- Covers
        // VUID-VkExportMetalDeviceInfoEXT-sType-sType

        // Validation code for VkExportMetalCommandQueueInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT: {  // Covers VUID-VkExportMetalCommandQueueInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMetalCommandQueueInfoEXT);
                VkExportMetalCommandQueueInfoEXT* structure = (VkExportMetalCommandQueueInfoEXT*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::queue), structure->queue);
            }
        } break;

        // Validation code for VkExportMetalBufferInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT: {  // Covers VUID-VkExportMetalBufferInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMetalBufferInfoEXT);
                VkExportMetalBufferInfoEXT* structure = (VkExportMetalBufferInfoEXT*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::memory), structure->memory);
            }
        } break;

        // No Validation code for VkImportMetalBufferInfoEXT structure members  -- Covers
        // VUID-VkImportMetalBufferInfoEXT-sType-sType

        // Validation code for VkExportMetalTextureInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT: {  // Covers VUID-VkExportMetalTextureInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMetalTextureInfoEXT);
                VkExportMetalTextureInfoEXT* structure = (VkExportMetalTextureInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::plane), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      structure->plane, kRequiredSingleBit, "VUID-VkExportMetalTextureInfoEXT-plane-parameter",
                                      "VUID-VkExportMetalTextureInfoEXT-plane-parameter");
            }
        } break;

        // Validation code for VkImportMetalTextureInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT: {  // Covers VUID-VkImportMetalTextureInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMetalTextureInfoEXT);
                VkImportMetalTextureInfoEXT* structure = (VkImportMetalTextureInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::plane), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      structure->plane, kRequiredSingleBit, "VUID-VkImportMetalTextureInfoEXT-plane-parameter",
                                      "VUID-VkImportMetalTextureInfoEXT-plane-parameter");
            }
        } break;

        // Validation code for VkExportMetalIOSurfaceInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT: {  // Covers VUID-VkExportMetalIOSurfaceInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExportMetalIOSurfaceInfoEXT);
                VkExportMetalIOSurfaceInfoEXT* structure = (VkExportMetalIOSurfaceInfoEXT*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::image), structure->image);
            }
        } break;

        // No Validation code for VkImportMetalIOSurfaceInfoEXT structure members  -- Covers
        // VUID-VkImportMetalIOSurfaceInfoEXT-sType-sType

        // No Validation code for VkExportMetalSharedEventInfoEXT structure members  -- Covers
        // VUID-VkExportMetalSharedEventInfoEXT-sType-sType

        // No Validation code for VkImportMetalSharedEventInfoEXT structure members  -- Covers
        // VUID-VkImportMetalSharedEventInfoEXT-sType-sType
#endif  // VK_USE_PLATFORM_METAL_EXT

        // No Validation code for VkPhysicalDeviceDescriptorBufferPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceDescriptorBufferPropertiesEXT-sType-sType

        // No Validation code for VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceDescriptorBufferFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceDescriptorBufferFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDescriptorBufferFeaturesEXT);
                VkPhysicalDeviceDescriptorBufferFeaturesEXT* structure = (VkPhysicalDeviceDescriptorBufferFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBuffer), structure->descriptorBuffer);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::descriptorBufferCaptureReplay), structure->descriptorBufferCaptureReplay);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBufferImageLayoutIgnored),
                                       structure->descriptorBufferImageLayoutIgnored);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBufferPushDescriptors),
                                       structure->descriptorBufferPushDescriptors);
            }
        } break;

        // Validation code for VkDescriptorBufferBindingPushDescriptorBufferHandleEXT structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT: {  // Covers
                                                                                               // VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkDescriptorBufferBindingPushDescriptorBufferHandleEXT);
                VkDescriptorBufferBindingPushDescriptorBufferHandleEXT* structure =
                    (VkDescriptorBufferBindingPushDescriptorBufferHandleEXT*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::buffer), structure->buffer);
            }
        } break;

        // Validation code for VkOpaqueCaptureDescriptorDataCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT: {  // Covers
                                                                                  // VUID-VkOpaqueCaptureDescriptorDataCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkOpaqueCaptureDescriptorDataCreateInfoEXT);
                VkOpaqueCaptureDescriptorDataCreateInfoEXT* structure = (VkOpaqueCaptureDescriptorDataCreateInfoEXT*)header;
                skip |= ValidateRequiredPointer(
                    pNext_loc.dot(Field::opaqueCaptureDescriptorData), structure->opaqueCaptureDescriptorData,
                    "VUID-VkOpaqueCaptureDescriptorDataCreateInfoEXT-opaqueCaptureDescriptorData-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT);
                VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* structure =
                    (VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::graphicsPipelineLibrary), structure->graphicsPipelineLibrary);
            }
        } break;

        // Validation code for VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT: {  // Covers
                                                                                            // VUID-VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT);
                VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* structure =
                    (VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::graphicsPipelineLibraryFastLinking),
                                       structure->graphicsPipelineLibraryFastLinking);

                skip |= ValidateBool32(pNext_loc.dot(Field::graphicsPipelineLibraryIndependentInterpolationDecoration),
                                       structure->graphicsPipelineLibraryIndependentInterpolationDecoration);
            }
        } break;

        // Validation code for VkGraphicsPipelineLibraryCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT: {  // Covers
                                                                             // VUID-VkGraphicsPipelineLibraryCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkGraphicsPipelineLibraryCreateInfoEXT);
                VkGraphicsPipelineLibraryCreateInfoEXT* structure = (VkGraphicsPipelineLibraryCreateInfoEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkGraphicsPipelineLibraryFlagBitsEXT",
                                      AllVkGraphicsPipelineLibraryFlagBitsEXT, structure->flags, kRequiredFlags,
                                      "VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-parameter",
                                      "VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-requiredbitmask");
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD: {  // Covers
                                                                                                     // VUID-VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD);
                VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD* structure =
                    (VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderEarlyAndLateFragmentTests),
                                       structure->shaderEarlyAndLateFragmentTests);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV);
                VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV* structure =
                    (VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentShadingRateEnums), structure->fragmentShadingRateEnums);

                skip |= ValidateBool32(pNext_loc.dot(Field::supersampleFragmentShadingRates),
                                       structure->supersampleFragmentShadingRates);

                skip |= ValidateBool32(pNext_loc.dot(Field::noInvocationFragmentShadingRates),
                                       structure->noInvocationFragmentShadingRates);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV: {  // Covers
                                                                                             // VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV);
                VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV* structure =
                    (VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV*)header;
                skip |= ValidateFlags(
                    pNext_loc.dot(Field::maxFragmentShadingRateInvocationCount), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                    structure->maxFragmentShadingRateInvocationCount, kRequiredSingleBit,
                    "VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-maxFragmentShadingRateInvocationCount-parameter",
                    "VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-maxFragmentShadingRateInvocationCount-parameter");
            }
        } break;

        // No Validation code for VkPipelineFragmentShadingRateEnumStateCreateInfoNV structure members  -- Covers
        // VUID-VkPipelineFragmentShadingRateEnumStateCreateInfoNV-sType-sType

        // No Validation code for VkAccelerationStructureGeometryMotionTrianglesDataNV structure members  -- Covers
        // VUID-VkAccelerationStructureGeometryMotionTrianglesDataNV-sType-sType

        // Validation code for VkAccelerationStructureMotionInfoNV structure members
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV: {  // Covers
                                                                         // VUID-VkAccelerationStructureMotionInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkAccelerationStructureMotionInfoNV);
                VkAccelerationStructureMotionInfoNV* structure = (VkAccelerationStructureMotionInfoNV*)header;
                skip |= ValidateReservedFlags(pNext_loc.dot(Field::flags), structure->flags,
                                              "VUID-VkAccelerationStructureMotionInfoNV-flags-zerobitmask");
            }
        } break;

        // Validation code for VkPhysicalDeviceRayTracingMotionBlurFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRayTracingMotionBlurFeaturesNV);
                VkPhysicalDeviceRayTracingMotionBlurFeaturesNV* structure = (VkPhysicalDeviceRayTracingMotionBlurFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingMotionBlur), structure->rayTracingMotionBlur);

                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingMotionBlurPipelineTraceRaysIndirect),
                                       structure->rayTracingMotionBlurPipelineTraceRaysIndirect);
            }
        } break;

        // Validation code for VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT);
                VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* structure =
                    (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::ycbcr2plane444Formats), structure->ycbcr2plane444Formats);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentDensityMap2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceFragmentDensityMap2FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentDensityMap2FeaturesEXT);
                VkPhysicalDeviceFragmentDensityMap2FeaturesEXT* structure = (VkPhysicalDeviceFragmentDensityMap2FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentDensityMapDeferred), structure->fragmentDensityMapDeferred);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentDensityMap2PropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-sType-sType

        // No Validation code for VkCopyCommandTransformInfoQCOM structure members  -- Covers
        // VUID-VkCopyCommandTransformInfoQCOM-sType-sType

        // Validation code for VkPhysicalDeviceImageCompressionControlFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceImageCompressionControlFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageCompressionControlFeaturesEXT);
                VkPhysicalDeviceImageCompressionControlFeaturesEXT* structure =
                    (VkPhysicalDeviceImageCompressionControlFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::imageCompressionControl), structure->imageCompressionControl);
            }
        } break;

        // No Validation code for VkImageCompressionControlEXT structure members  -- Covers
        // VUID-VkImageCompressionControlEXT-sType-sType

        // No Validation code for VkImageCompressionPropertiesEXT structure members  -- Covers
        // VUID-VkImageCompressionPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT: {  // Covers
                                                                                                // VUID-VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT);
                VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT* structure =
                    (VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::attachmentFeedbackLoopLayout), structure->attachmentFeedbackLoopLayout);
            }
        } break;

        // Validation code for VkPhysicalDevice4444FormatsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {  // Covers
                                                                             // VUID-VkPhysicalDevice4444FormatsFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevice4444FormatsFeaturesEXT);
                VkPhysicalDevice4444FormatsFeaturesEXT* structure = (VkPhysicalDevice4444FormatsFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::formatA4R4G4B4), structure->formatA4R4G4B4);

                skip |= ValidateBool32(pNext_loc.dot(Field::formatA4B4G4R4), structure->formatA4B4G4R4);
            }
        } break;

        // Validation code for VkPhysicalDeviceFaultFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT: {  // Covers VUID-VkPhysicalDeviceFaultFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFaultFeaturesEXT);
                VkPhysicalDeviceFaultFeaturesEXT* structure = (VkPhysicalDeviceFaultFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::deviceFault), structure->deviceFault);

                skip |= ValidateBool32(pNext_loc.dot(Field::deviceFaultVendorBinary), structure->deviceFaultVendorBinary);
            }
        } break;

        // Validation code for VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT: {  // Covers
                                                                                                      // VUID-VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT);
                VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT* structure =
                    (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rasterizationOrderColorAttachmentAccess),
                                       structure->rasterizationOrderColorAttachmentAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::rasterizationOrderDepthAttachmentAccess),
                                       structure->rasterizationOrderDepthAttachmentAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::rasterizationOrderStencilAttachmentAccess),
                                       structure->rasterizationOrderStencilAttachmentAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT);
                VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT* structure = (VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::formatRgba10x6WithoutYCbCrSampler),
                                       structure->formatRgba10x6WithoutYCbCrSampler);
            }
        } break;

        // Validation code for VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT: {  // Covers
                                                                                        // VUID-VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT);
                VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT* structure =
                    (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::mutableDescriptorType), structure->mutableDescriptorType);
            }
        } break;

        // Validation code for VkMutableDescriptorTypeCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT: {  // Covers
                                                                           // VUID-VkMutableDescriptorTypeCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkMutableDescriptorTypeCreateInfoEXT);
                VkMutableDescriptorTypeCreateInfoEXT* structure = (VkMutableDescriptorTypeCreateInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::mutableDescriptorTypeListCount),
                                      pNext_loc.dot(Field::pMutableDescriptorTypeLists), structure->mutableDescriptorTypeListCount,
                                      &structure->pMutableDescriptorTypeLists, false, true, kVUIDUndefined,
                                      "VUID-VkMutableDescriptorTypeCreateInfoEXT-pMutableDescriptorTypeLists-parameter");

                if (structure->pMutableDescriptorTypeLists != nullptr) {
                    for (uint32_t mutableDescriptorTypeListIndex = 0;
                         mutableDescriptorTypeListIndex < structure->mutableDescriptorTypeListCount;
                         ++mutableDescriptorTypeListIndex) {
                        [[maybe_unused]] const Location pMutableDescriptorTypeLists_loc =
                            pNext_loc.dot(Field::pMutableDescriptorTypeLists, mutableDescriptorTypeListIndex);
                        skip |= ValidateRangedEnumArray(
                            pMutableDescriptorTypeLists_loc.dot(Field::descriptorTypeCount),
                            pMutableDescriptorTypeLists_loc.dot(Field::pDescriptorTypes), "VkDescriptorType",
                            structure->pMutableDescriptorTypeLists[mutableDescriptorTypeListIndex].descriptorTypeCount,
                            structure->pMutableDescriptorTypeLists[mutableDescriptorTypeListIndex].pDescriptorTypes, false, true);
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT);
                VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT* structure =
                    (VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::vertexInputDynamicState), structure->vertexInputDynamicState);
            }
        } break;

        // No Validation code for VkPhysicalDeviceDrmPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceDrmPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceAddressBindingReportFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceAddressBindingReportFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceAddressBindingReportFeaturesEXT);
                VkPhysicalDeviceAddressBindingReportFeaturesEXT* structure =
                    (VkPhysicalDeviceAddressBindingReportFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::reportAddressBinding), structure->reportAddressBinding);
            }
        } break;

        // Validation code for VkDeviceAddressBindingCallbackDataEXT structure members
        case VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT: {  // Covers
                                                                            // VUID-VkDeviceAddressBindingCallbackDataEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDeviceAddressBindingCallbackDataEXT);
                VkDeviceAddressBindingCallbackDataEXT* structure = (VkDeviceAddressBindingCallbackDataEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkDeviceAddressBindingFlagBitsEXT",
                                      AllVkDeviceAddressBindingFlagBitsEXT, structure->flags, kOptionalFlags,
                                      "VUID-VkDeviceAddressBindingCallbackDataEXT-flags-parameter");

                skip |=
                    ValidateRangedEnum(pNext_loc.dot(Field::bindingType), "VkDeviceAddressBindingTypeEXT", structure->bindingType,
                                       "VUID-VkDeviceAddressBindingCallbackDataEXT-bindingType-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthClipControlFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceDepthClipControlFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDepthClipControlFeaturesEXT);
                VkPhysicalDeviceDepthClipControlFeaturesEXT* structure = (VkPhysicalDeviceDepthClipControlFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::depthClipControl), structure->depthClipControl);
            }
        } break;

        // Validation code for VkPipelineViewportDepthClipControlCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT: {  // Covers
                                                                                        // VUID-VkPipelineViewportDepthClipControlCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineViewportDepthClipControlCreateInfoEXT);
                VkPipelineViewportDepthClipControlCreateInfoEXT* structure =
                    (VkPipelineViewportDepthClipControlCreateInfoEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::negativeOneToOne), structure->negativeOneToOne);
            }
        } break;

        // Validation code for VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {  // Covers
                                                                                                // VUID-VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT);
                VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* structure =
                    (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::primitiveTopologyListRestart), structure->primitiveTopologyListRestart);

                skip |= ValidateBool32(pNext_loc.dot(Field::primitiveTopologyPatchListRestart),
                                       structure->primitiveTopologyPatchListRestart);
            }
        } break;
#ifdef VK_USE_PLATFORM_FUCHSIA

        // Validation code for VkImportMemoryZirconHandleInfoFUCHSIA structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA: {  // Covers
                                                                            // VUID-VkImportMemoryZirconHandleInfoFUCHSIA-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMemoryZirconHandleInfoFUCHSIA);
                VkImportMemoryZirconHandleInfoFUCHSIA* structure = (VkImportMemoryZirconHandleInfoFUCHSIA*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBits",
                                      AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit,
                                      "VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handleType-parameter");
            }
        } break;

        // Validation code for VkImportMemoryBufferCollectionFUCHSIA structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA: {  // Covers
                                                                           // VUID-VkImportMemoryBufferCollectionFUCHSIA-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkImportMemoryBufferCollectionFUCHSIA);
                VkImportMemoryBufferCollectionFUCHSIA* structure = (VkImportMemoryBufferCollectionFUCHSIA*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::collection), structure->collection);
            }
        } break;

        // Validation code for VkBufferCollectionImageCreateInfoFUCHSIA structure members
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA: {  // Covers
                                                                               // VUID-VkBufferCollectionImageCreateInfoFUCHSIA-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBufferCollectionImageCreateInfoFUCHSIA);
                VkBufferCollectionImageCreateInfoFUCHSIA* structure = (VkBufferCollectionImageCreateInfoFUCHSIA*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::collection), structure->collection);
            }
        } break;

        // Validation code for VkBufferCollectionBufferCreateInfoFUCHSIA structure members
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA: {  // Covers
                                                                                // VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBufferCollectionBufferCreateInfoFUCHSIA);
                VkBufferCollectionBufferCreateInfoFUCHSIA* structure = (VkBufferCollectionBufferCreateInfoFUCHSIA*)header;
                skip |= ValidateRequiredHandle(pNext_loc.dot(Field::collection), structure->collection);
            }
        } break;
#endif  // VK_USE_PLATFORM_FUCHSIA

        // No Validation code for VkSubpassShadingPipelineCreateInfoHUAWEI structure members  -- Covers
        // VUID-VkSubpassShadingPipelineCreateInfoHUAWEI-sType-sType

        // Validation code for VkPhysicalDeviceSubpassShadingFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceSubpassShadingFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSubpassShadingFeaturesHUAWEI);
                VkPhysicalDeviceSubpassShadingFeaturesHUAWEI* structure = (VkPhysicalDeviceSubpassShadingFeaturesHUAWEI*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::subpassShading), structure->subpassShading);
            }
        } break;

        // No Validation code for VkPhysicalDeviceSubpassShadingPropertiesHUAWEI structure members  -- Covers
        // VUID-VkPhysicalDeviceSubpassShadingPropertiesHUAWEI-sType-sType

        // Validation code for VkPhysicalDeviceInvocationMaskFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceInvocationMaskFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceInvocationMaskFeaturesHUAWEI);
                VkPhysicalDeviceInvocationMaskFeaturesHUAWEI* structure = (VkPhysicalDeviceInvocationMaskFeaturesHUAWEI*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::invocationMask), structure->invocationMask);
            }
        } break;

        // Validation code for VkPhysicalDeviceExternalMemoryRDMAFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceExternalMemoryRDMAFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExternalMemoryRDMAFeaturesNV);
                VkPhysicalDeviceExternalMemoryRDMAFeaturesNV* structure = (VkPhysicalDeviceExternalMemoryRDMAFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::externalMemoryRDMA), structure->externalMemoryRDMA);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelinePropertiesFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT: {  // Covers
                                                                                    // VUID-VkPhysicalDevicePipelinePropertiesFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePipelinePropertiesFeaturesEXT);
                VkPhysicalDevicePipelinePropertiesFeaturesEXT* structure = (VkPhysicalDevicePipelinePropertiesFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelinePropertiesIdentifier), structure->pipelinePropertiesIdentifier);
            }
        } break;

        // Validation code for VkPhysicalDeviceFrameBoundaryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT: {  // Covers
                                                                               // VUID-VkPhysicalDeviceFrameBoundaryFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFrameBoundaryFeaturesEXT);
                VkPhysicalDeviceFrameBoundaryFeaturesEXT* structure = (VkPhysicalDeviceFrameBoundaryFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::frameBoundary), structure->frameBoundary);
            }
        } break;

        // Validation code for VkFrameBoundaryEXT structure members
        case VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT: {  // Covers VUID-VkFrameBoundaryEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkFrameBoundaryEXT);
                VkFrameBoundaryEXT* structure = (VkFrameBoundaryEXT*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::flags), "VkFrameBoundaryFlagBitsEXT", AllVkFrameBoundaryFlagBitsEXT,
                                      structure->flags, kOptionalFlags, "VUID-VkFrameBoundaryEXT-flags-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT: {  // Covers
                                                                                                      // VUID-VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT);
                VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT* structure =
                    (VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::multisampledRenderToSingleSampled),
                                       structure->multisampledRenderToSingleSampled);
            }
        } break;

        // No Validation code for VkSubpassResolvePerformanceQueryEXT structure members  -- Covers
        // VUID-VkSubpassResolvePerformanceQueryEXT-sType-sType

        // Validation code for VkMultisampledRenderToSingleSampledInfoEXT structure members
        case VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT: {  // Covers
                                                                                  // VUID-VkMultisampledRenderToSingleSampledInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkMultisampledRenderToSingleSampledInfoEXT);
                VkMultisampledRenderToSingleSampledInfoEXT* structure = (VkMultisampledRenderToSingleSampledInfoEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::multisampledRenderToSingleSampledEnable),
                                       structure->multisampledRenderToSingleSampledEnable);

                skip |= ValidateFlags(pNext_loc.dot(Field::rasterizationSamples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                                      structure->rasterizationSamples, kRequiredSingleBit,
                                      "VUID-VkMultisampledRenderToSingleSampledInfoEXT-rasterizationSamples-parameter",
                                      "VUID-VkMultisampledRenderToSingleSampledInfoEXT-rasterizationSamples-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicState2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExtendedDynamicState2FeaturesEXT);
                VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* structure =
                    (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState2), structure->extendedDynamicState2);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState2LogicOp), structure->extendedDynamicState2LogicOp);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState2PatchControlPoints),
                                       structure->extendedDynamicState2PatchControlPoints);
            }
        } break;

        // Validation code for VkPhysicalDeviceColorWriteEnableFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceColorWriteEnableFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceColorWriteEnableFeaturesEXT);
                VkPhysicalDeviceColorWriteEnableFeaturesEXT* structure = (VkPhysicalDeviceColorWriteEnableFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::colorWriteEnable), structure->colorWriteEnable);
            }
        } break;

        // Validation code for VkPipelineColorWriteCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT: {  // Covers VUID-VkPipelineColorWriteCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineColorWriteCreateInfoEXT);
                VkPipelineColorWriteCreateInfoEXT* structure = (VkPipelineColorWriteCreateInfoEXT*)header;
                skip |= ValidateBool32Array(pNext_loc.dot(Field::attachmentCount), pNext_loc.dot(Field::pColorWriteEnables),
                                            structure->attachmentCount, structure->pColorWriteEnables, false, true);
            }
        } break;

        // Validation code for VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT: {  // Covers
                                                                                           // VUID-VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT);
                VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT* structure =
                    (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::primitivesGeneratedQuery), structure->primitivesGeneratedQuery);

                skip |= ValidateBool32(pNext_loc.dot(Field::primitivesGeneratedQueryWithRasterizerDiscard),
                                       structure->primitivesGeneratedQueryWithRasterizerDiscard);

                skip |= ValidateBool32(pNext_loc.dot(Field::primitivesGeneratedQueryWithNonZeroStreams),
                                       structure->primitivesGeneratedQueryWithNonZeroStreams);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageViewMinLodFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT: {  // Covers
                                                                                   // VUID-VkPhysicalDeviceImageViewMinLodFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageViewMinLodFeaturesEXT);
                VkPhysicalDeviceImageViewMinLodFeaturesEXT* structure = (VkPhysicalDeviceImageViewMinLodFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::minLod), structure->minLod);
            }
        } break;

        // No Validation code for VkImageViewMinLodCreateInfoEXT structure members  -- Covers
        // VUID-VkImageViewMinLodCreateInfoEXT-sType-sType

        // Validation code for VkPhysicalDeviceMultiDrawFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT: {  // Covers
                                                                           // VUID-VkPhysicalDeviceMultiDrawFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMultiDrawFeaturesEXT);
                VkPhysicalDeviceMultiDrawFeaturesEXT* structure = (VkPhysicalDeviceMultiDrawFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::multiDraw), structure->multiDraw);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMultiDrawPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceMultiDrawPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceImage2DViewOf3DFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceImage2DViewOf3DFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImage2DViewOf3DFeaturesEXT);
                VkPhysicalDeviceImage2DViewOf3DFeaturesEXT* structure = (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::image2DViewOf3D), structure->image2DViewOf3D);

                skip |= ValidateBool32(pNext_loc.dot(Field::sampler2DViewOf3D), structure->sampler2DViewOf3D);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderTileImageFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceShaderTileImageFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderTileImageFeaturesEXT);
                VkPhysicalDeviceShaderTileImageFeaturesEXT* structure = (VkPhysicalDeviceShaderTileImageFeaturesEXT*)header;
                skip |=
                    ValidateBool32(pNext_loc.dot(Field::shaderTileImageColorReadAccess), structure->shaderTileImageColorReadAccess);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::shaderTileImageDepthReadAccess), structure->shaderTileImageDepthReadAccess);

                skip |= ValidateBool32(pNext_loc.dot(Field::shaderTileImageStencilReadAccess),
                                       structure->shaderTileImageStencilReadAccess);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderTileImagePropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderTileImagePropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceOpacityMicromapFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceOpacityMicromapFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceOpacityMicromapFeaturesEXT);
                VkPhysicalDeviceOpacityMicromapFeaturesEXT* structure = (VkPhysicalDeviceOpacityMicromapFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::micromap), structure->micromap);

                skip |= ValidateBool32(pNext_loc.dot(Field::micromapCaptureReplay), structure->micromapCaptureReplay);

                skip |= ValidateBool32(pNext_loc.dot(Field::micromapHostCommands), structure->micromapHostCommands);
            }
        } break;

        // No Validation code for VkPhysicalDeviceOpacityMicromapPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceOpacityMicromapPropertiesEXT-sType-sType

        // Validation code for VkAccelerationStructureTrianglesOpacityMicromapEXT structure members
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT: {  // Covers
                                                                                         // VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkAccelerationStructureTrianglesOpacityMicromapEXT);
                VkAccelerationStructureTrianglesOpacityMicromapEXT* structure =
                    (VkAccelerationStructureTrianglesOpacityMicromapEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::indexType), "VkIndexType", structure->indexType,
                                           "VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-parameter");

                if (structure->pUsageCounts != nullptr) {
                    for (uint32_t usageIndexsIndex = 0; usageIndexsIndex < structure->usageCountsCount; ++usageIndexsIndex) {
                        [[maybe_unused]] const Location pUsageCounts_loc = pNext_loc.dot(Field::pUsageCounts, usageIndexsIndex);
                    }
                }

                if (structure->ppUsageCounts != nullptr) {
                    for (uint32_t usageIndexsIndex = 0; usageIndexsIndex < structure->usageCountsCount; ++usageIndexsIndex) {
                        [[maybe_unused]] const Location ppUsageCounts_loc = pNext_loc.dot(Field::ppUsageCounts, usageIndexsIndex);
                    }
                }
            }
        } break;
#ifdef VK_ENABLE_BETA_EXTENSIONS

        // Validation code for VkPhysicalDeviceDisplacementMicromapFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceDisplacementMicromapFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDisplacementMicromapFeaturesNV);
                VkPhysicalDeviceDisplacementMicromapFeaturesNV* structure = (VkPhysicalDeviceDisplacementMicromapFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::displacementMicromap), structure->displacementMicromap);
            }
        } break;

        // No Validation code for VkPhysicalDeviceDisplacementMicromapPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceDisplacementMicromapPropertiesNV-sType-sType

        // Validation code for VkAccelerationStructureTrianglesDisplacementMicromapNV structure members
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV: {  // Covers
                                                                                             // VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkAccelerationStructureTrianglesDisplacementMicromapNV);
                VkAccelerationStructureTrianglesDisplacementMicromapNV* structure =
                    (VkAccelerationStructureTrianglesDisplacementMicromapNV*)header;
                skip |= ValidateRangedEnum(
                    pNext_loc.dot(Field::displacementBiasAndScaleFormat), "VkFormat", structure->displacementBiasAndScaleFormat,
                    "VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-parameter");

                skip |= ValidateRangedEnum(
                    pNext_loc.dot(Field::displacementVectorFormat), "VkFormat", structure->displacementVectorFormat,
                    "VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::indexType), "VkIndexType", structure->indexType,
                                           "VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-indexType-parameter");

                if (structure->pUsageCounts != nullptr) {
                    for (uint32_t usageIndexsIndex = 0; usageIndexsIndex < structure->usageCountsCount; ++usageIndexsIndex) {
                        [[maybe_unused]] const Location pUsageCounts_loc = pNext_loc.dot(Field::pUsageCounts, usageIndexsIndex);
                    }
                }

                if (structure->ppUsageCounts != nullptr) {
                    for (uint32_t usageIndexsIndex = 0; usageIndexsIndex < structure->usageCountsCount; ++usageIndexsIndex) {
                        [[maybe_unused]] const Location ppUsageCounts_loc = pNext_loc.dot(Field::ppUsageCounts, usageIndexsIndex);
                    }
                }
            }
        } break;
#endif  // VK_ENABLE_BETA_EXTENSIONS

        // Validation code for VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI: {  // Covers
                                                                                          // VUID-VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI);
                VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI* structure =
                    (VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::clustercullingShader), structure->clustercullingShader);

                skip |=
                    ValidateBool32(pNext_loc.dot(Field::multiviewClusterCullingShader), structure->multiviewClusterCullingShader);
            }
        } break;

        // No Validation code for VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI structure members  -- Covers
        // VUID-VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI-sType-sType

        // Validation code for VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI: {  // Covers
                                                                                              // VUID-VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI);
                VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI* structure =
                    (VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::clusterShadingRate), structure->clusterShadingRate);
            }
        } break;

        // Validation code for VkPhysicalDeviceBorderColorSwizzleFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceBorderColorSwizzleFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceBorderColorSwizzleFeaturesEXT);
                VkPhysicalDeviceBorderColorSwizzleFeaturesEXT* structure = (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::borderColorSwizzle), structure->borderColorSwizzle);

                skip |= ValidateBool32(pNext_loc.dot(Field::borderColorSwizzleFromImage), structure->borderColorSwizzleFromImage);
            }
        } break;

        // Validation code for VkSamplerBorderColorComponentMappingCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT: {  // Covers
                                                                                          // VUID-VkSamplerBorderColorComponentMappingCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerBorderColorComponentMappingCreateInfoEXT);
                VkSamplerBorderColorComponentMappingCreateInfoEXT* structure =
                    (VkSamplerBorderColorComponentMappingCreateInfoEXT*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::r), "VkComponentSwizzle", structure->components.r,
                                           "VUID-VkComponentMapping-r-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::g), "VkComponentSwizzle", structure->components.g,
                                           "VUID-VkComponentMapping-g-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::b), "VkComponentSwizzle", structure->components.b,
                                           "VUID-VkComponentMapping-b-parameter");

                skip |= ValidateRangedEnum(pNext_loc.dot(Field::a), "VkComponentSwizzle", structure->components.a,
                                           "VUID-VkComponentMapping-a-parameter");

                skip |= ValidateBool32(pNext_loc.dot(Field::srgb), structure->srgb);
            }
        } break;

        // Validation code for VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT: {  // Covers
                                                                                             // VUID-VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT);
                VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT* structure =
                    (VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pageableDeviceLocalMemory), structure->pageableDeviceLocalMemory);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCorePropertiesARM structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderCorePropertiesARM-sType-sType

        // No Validation code for VkDeviceQueueShaderCoreControlCreateInfoARM structure members  -- Covers
        // VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-sType-sType

        // Validation code for VkPhysicalDeviceSchedulingControlsFeaturesARM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceSchedulingControlsFeaturesARM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSchedulingControlsFeaturesARM);
                VkPhysicalDeviceSchedulingControlsFeaturesARM* structure = (VkPhysicalDeviceSchedulingControlsFeaturesARM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::schedulingControls), structure->schedulingControls);
            }
        } break;

        // Validation code for VkPhysicalDeviceSchedulingControlsPropertiesARM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceSchedulingControlsPropertiesARM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSchedulingControlsPropertiesARM);
                VkPhysicalDeviceSchedulingControlsPropertiesARM* structure =
                    (VkPhysicalDeviceSchedulingControlsPropertiesARM*)header;
                skip |= ValidateFlags(
                    pNext_loc.dot(Field::schedulingControlsFlags), "VkPhysicalDeviceSchedulingControlsFlagBitsARM",
                    AllVkPhysicalDeviceSchedulingControlsFlagBitsARM, structure->schedulingControlsFlags, kRequiredFlags,
                    "VUID-VkPhysicalDeviceSchedulingControlsPropertiesARM-schedulingControlsFlags-parameter",
                    "VUID-VkPhysicalDeviceSchedulingControlsPropertiesARM-schedulingControlsFlags-requiredbitmask");
            }
        } break;

        // Validation code for VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT: {  // Covers
                                                                                        // VUID-VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT);
                VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT* structure = (VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::imageSlicedViewOf3D), structure->imageSlicedViewOf3D);
            }
        } break;

        // No Validation code for VkImageViewSlicedCreateInfoEXT structure members  -- Covers
        // VUID-VkImageViewSlicedCreateInfoEXT-sType-sType

        // Validation code for VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE: {  // Covers
                                                                                              // VUID-VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE);
                VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE* structure =
                    (VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorSetHostMapping), structure->descriptorSetHostMapping);
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthClampZeroOneFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceDepthClampZeroOneFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceDepthClampZeroOneFeaturesEXT);
                VkPhysicalDeviceDepthClampZeroOneFeaturesEXT* structure = (VkPhysicalDeviceDepthClampZeroOneFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::depthClampZeroOne), structure->depthClampZeroOne);
            }
        } break;

        // Validation code for VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT);
                VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT* structure = (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::nonSeamlessCubeMap), structure->nonSeamlessCubeMap);
            }
        } break;

        // Validation code for VkPhysicalDeviceRenderPassStripedFeaturesARM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceRenderPassStripedFeaturesARM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRenderPassStripedFeaturesARM);
                VkPhysicalDeviceRenderPassStripedFeaturesARM* structure = (VkPhysicalDeviceRenderPassStripedFeaturesARM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::renderPassStriped), structure->renderPassStriped);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRenderPassStripedPropertiesARM structure members  -- Covers
        // VUID-VkPhysicalDeviceRenderPassStripedPropertiesARM-sType-sType

        // Validation code for VkRenderPassStripeBeginInfoARM structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM: {  // Covers VUID-VkRenderPassStripeBeginInfoARM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassStripeBeginInfoARM);
                VkRenderPassStripeBeginInfoARM* structure = (VkRenderPassStripeBeginInfoARM*)header;
                skip |= ValidateStructTypeArray(pNext_loc.dot(Field::stripeInfoCount), pNext_loc.dot(Field::pStripeInfos),
                                                "VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM", structure->stripeInfoCount,
                                                structure->pStripeInfos, VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM, true, true,
                                                "VUID-VkRenderPassStripeInfoARM-sType-sType",
                                                "VUID-VkRenderPassStripeBeginInfoARM-pStripeInfos-parameter",
                                                "VUID-VkRenderPassStripeBeginInfoARM-stripeInfoCount-arraylength");

                if (structure->pStripeInfos != nullptr) {
                    for (uint32_t stripeInfoIndex = 0; stripeInfoIndex < structure->stripeInfoCount; ++stripeInfoIndex) {
                        [[maybe_unused]] const Location pStripeInfos_loc = pNext_loc.dot(Field::pStripeInfos, stripeInfoIndex);
                    }
                }
            }
        } break;

        // Validation code for VkRenderPassStripeSubmitInfoARM structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM: {  // Covers VUID-VkRenderPassStripeSubmitInfoARM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassStripeSubmitInfoARM);
                VkRenderPassStripeSubmitInfoARM* structure = (VkRenderPassStripeSubmitInfoARM*)header;
                skip |= ValidateStructTypeArray(pNext_loc.dot(Field::stripeSemaphoreInfoCount),
                                                pNext_loc.dot(Field::pStripeSemaphoreInfos),
                                                "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO", structure->stripeSemaphoreInfoCount,
                                                structure->pStripeSemaphoreInfos, VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO, true,
                                                true, "VUID-VkSemaphoreSubmitInfo-sType-sType",
                                                "VUID-VkRenderPassStripeSubmitInfoARM-pStripeSemaphoreInfos-parameter",
                                                "VUID-VkRenderPassStripeSubmitInfoARM-stripeSemaphoreInfoCount-arraylength");

                if (structure->pStripeSemaphoreInfos != nullptr) {
                    for (uint32_t stripeSemaphoreInfoIndex = 0; stripeSemaphoreInfoIndex < structure->stripeSemaphoreInfoCount;
                         ++stripeSemaphoreInfoIndex) {
                        [[maybe_unused]] const Location pStripeSemaphoreInfos_loc =
                            pNext_loc.dot(Field::pStripeSemaphoreInfos, stripeSemaphoreInfoIndex);
                        skip |= ValidateRequiredHandle(pStripeSemaphoreInfos_loc.dot(Field::semaphore),
                                                       structure->pStripeSemaphoreInfos[stripeSemaphoreInfoIndex].semaphore);

                        skip |= ValidateFlags(pStripeSemaphoreInfos_loc.dot(Field::stageMask), "VkPipelineStageFlagBits2",
                                              AllVkPipelineStageFlagBits2,
                                              structure->pStripeSemaphoreInfos[stripeSemaphoreInfoIndex].stageMask, kOptionalFlags,
                                              "VUID-VkSemaphoreSubmitInfo-stageMask-parameter");
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM: {  // Covers
                                                                                             // VUID-VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM);
                VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM* structure =
                    (VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::fragmentDensityMapOffset), structure->fragmentDensityMapOffset);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM structure members  -- Covers
        // VUID-VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM-sType-sType

        // Validation code for VkSubpassFragmentDensityMapOffsetEndInfoQCOM structure members
        case VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM: {  // Covers
                                                                                     // VUID-VkSubpassFragmentDensityMapOffsetEndInfoQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSubpassFragmentDensityMapOffsetEndInfoQCOM);
                VkSubpassFragmentDensityMapOffsetEndInfoQCOM* structure = (VkSubpassFragmentDensityMapOffsetEndInfoQCOM*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::fragmentDensityOffsetCount),
                                      pNext_loc.dot(Field::pFragmentDensityOffsets), structure->fragmentDensityOffsetCount,
                                      &structure->pFragmentDensityOffsets, false, true, kVUIDUndefined,
                                      "VUID-VkSubpassFragmentDensityMapOffsetEndInfoQCOM-pFragmentDensityOffsets-parameter");

                if (structure->pFragmentDensityOffsets != nullptr) {
                    for (uint32_t fragmentDensityOffsetIndex = 0;
                         fragmentDensityOffsetIndex < structure->fragmentDensityOffsetCount; ++fragmentDensityOffsetIndex) {
                        [[maybe_unused]] const Location pFragmentDensityOffsets_loc =
                            pNext_loc.dot(Field::pFragmentDensityOffsets, fragmentDensityOffsetIndex);
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceCopyMemoryIndirectFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceCopyMemoryIndirectFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCopyMemoryIndirectFeaturesNV);
                VkPhysicalDeviceCopyMemoryIndirectFeaturesNV* structure = (VkPhysicalDeviceCopyMemoryIndirectFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::indirectCopy), structure->indirectCopy);
            }
        } break;

        // No Validation code for VkPhysicalDeviceCopyMemoryIndirectPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceCopyMemoryIndirectPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceMemoryDecompressionFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceMemoryDecompressionFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMemoryDecompressionFeaturesNV);
                VkPhysicalDeviceMemoryDecompressionFeaturesNV* structure = (VkPhysicalDeviceMemoryDecompressionFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::memoryDecompression), structure->memoryDecompression);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMemoryDecompressionPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceMemoryDecompressionPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV: {  // Covers
                                                                                                 // VUID-VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV);
                VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV* structure =
                    (VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::deviceGeneratedCompute), structure->deviceGeneratedCompute);

                skip |= ValidateBool32(pNext_loc.dot(Field::deviceGeneratedComputePipelines),
                                       structure->deviceGeneratedComputePipelines);

                skip |= ValidateBool32(pNext_loc.dot(Field::deviceGeneratedComputeCaptureReplay),
                                       structure->deviceGeneratedComputeCaptureReplay);
            }
        } break;

        // Validation code for VkPhysicalDeviceLinearColorAttachmentFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceLinearColorAttachmentFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceLinearColorAttachmentFeaturesNV);
                VkPhysicalDeviceLinearColorAttachmentFeaturesNV* structure =
                    (VkPhysicalDeviceLinearColorAttachmentFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::linearColorAttachment), structure->linearColorAttachment);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {  // Covers
                                                                                                    // VUID-VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT);
                VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* structure =
                    (VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::imageCompressionControlSwapchain),
                                       structure->imageCompressionControlSwapchain);
            }
        } break;

        // No Validation code for VkImageViewSampleWeightCreateInfoQCOM structure members  -- Covers
        // VUID-VkImageViewSampleWeightCreateInfoQCOM-sType-sType

        // Validation code for VkPhysicalDeviceImageProcessingFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM: {  // Covers
                                                                                  // VUID-VkPhysicalDeviceImageProcessingFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageProcessingFeaturesQCOM);
                VkPhysicalDeviceImageProcessingFeaturesQCOM* structure = (VkPhysicalDeviceImageProcessingFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::textureSampleWeighted), structure->textureSampleWeighted);

                skip |= ValidateBool32(pNext_loc.dot(Field::textureBoxFilter), structure->textureBoxFilter);

                skip |= ValidateBool32(pNext_loc.dot(Field::textureBlockMatch), structure->textureBlockMatch);
            }
        } break;

        // No Validation code for VkPhysicalDeviceImageProcessingPropertiesQCOM structure members  -- Covers
        // VUID-VkPhysicalDeviceImageProcessingPropertiesQCOM-sType-sType

        // Validation code for VkPhysicalDeviceNestedCommandBufferFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT: {  // Covers
                                                                                      // VUID-VkPhysicalDeviceNestedCommandBufferFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceNestedCommandBufferFeaturesEXT);
                VkPhysicalDeviceNestedCommandBufferFeaturesEXT* structure = (VkPhysicalDeviceNestedCommandBufferFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::nestedCommandBuffer), structure->nestedCommandBuffer);

                skip |= ValidateBool32(pNext_loc.dot(Field::nestedCommandBufferRendering), structure->nestedCommandBufferRendering);

                skip |= ValidateBool32(pNext_loc.dot(Field::nestedCommandBufferSimultaneousUse),
                                       structure->nestedCommandBufferSimultaneousUse);
            }
        } break;

        // No Validation code for VkPhysicalDeviceNestedCommandBufferPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceNestedCommandBufferPropertiesEXT-sType-sType

        // Validation code for VkExternalMemoryAcquireUnmodifiedEXT structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT: {  // Covers
                                                                          // VUID-VkExternalMemoryAcquireUnmodifiedEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkExternalMemoryAcquireUnmodifiedEXT);
                VkExternalMemoryAcquireUnmodifiedEXT* structure = (VkExternalMemoryAcquireUnmodifiedEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::acquireUnmodifiedMemory), structure->acquireUnmodifiedMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicState3FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceExtendedDynamicState3FeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExtendedDynamicState3FeaturesEXT);
                VkPhysicalDeviceExtendedDynamicState3FeaturesEXT* structure =
                    (VkPhysicalDeviceExtendedDynamicState3FeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3TessellationDomainOrigin),
                                       structure->extendedDynamicState3TessellationDomainOrigin);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3DepthClampEnable),
                                       structure->extendedDynamicState3DepthClampEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3PolygonMode),
                                       structure->extendedDynamicState3PolygonMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3RasterizationSamples),
                                       structure->extendedDynamicState3RasterizationSamples);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3SampleMask),
                                       structure->extendedDynamicState3SampleMask);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3AlphaToCoverageEnable),
                                       structure->extendedDynamicState3AlphaToCoverageEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3AlphaToOneEnable),
                                       structure->extendedDynamicState3AlphaToOneEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3LogicOpEnable),
                                       structure->extendedDynamicState3LogicOpEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ColorBlendEnable),
                                       structure->extendedDynamicState3ColorBlendEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ColorBlendEquation),
                                       structure->extendedDynamicState3ColorBlendEquation);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ColorWriteMask),
                                       structure->extendedDynamicState3ColorWriteMask);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3RasterizationStream),
                                       structure->extendedDynamicState3RasterizationStream);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ConservativeRasterizationMode),
                                       structure->extendedDynamicState3ConservativeRasterizationMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ExtraPrimitiveOverestimationSize),
                                       structure->extendedDynamicState3ExtraPrimitiveOverestimationSize);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3DepthClipEnable),
                                       structure->extendedDynamicState3DepthClipEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3SampleLocationsEnable),
                                       structure->extendedDynamicState3SampleLocationsEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ColorBlendAdvanced),
                                       structure->extendedDynamicState3ColorBlendAdvanced);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ProvokingVertexMode),
                                       structure->extendedDynamicState3ProvokingVertexMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3LineRasterizationMode),
                                       structure->extendedDynamicState3LineRasterizationMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3LineStippleEnable),
                                       structure->extendedDynamicState3LineStippleEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3DepthClipNegativeOneToOne),
                                       structure->extendedDynamicState3DepthClipNegativeOneToOne);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ViewportWScalingEnable),
                                       structure->extendedDynamicState3ViewportWScalingEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ViewportSwizzle),
                                       structure->extendedDynamicState3ViewportSwizzle);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3CoverageToColorEnable),
                                       structure->extendedDynamicState3CoverageToColorEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3CoverageToColorLocation),
                                       structure->extendedDynamicState3CoverageToColorLocation);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3CoverageModulationMode),
                                       structure->extendedDynamicState3CoverageModulationMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3CoverageModulationTableEnable),
                                       structure->extendedDynamicState3CoverageModulationTableEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3CoverageModulationTable),
                                       structure->extendedDynamicState3CoverageModulationTable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3CoverageReductionMode),
                                       structure->extendedDynamicState3CoverageReductionMode);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3RepresentativeFragmentTestEnable),
                                       structure->extendedDynamicState3RepresentativeFragmentTestEnable);

                skip |= ValidateBool32(pNext_loc.dot(Field::extendedDynamicState3ShadingRateImageEnable),
                                       structure->extendedDynamicState3ShadingRateImageEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicState3PropertiesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT: {  // Covers
                                                                                           // VUID-VkPhysicalDeviceExtendedDynamicState3PropertiesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExtendedDynamicState3PropertiesEXT);
                VkPhysicalDeviceExtendedDynamicState3PropertiesEXT* structure =
                    (VkPhysicalDeviceExtendedDynamicState3PropertiesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::dynamicPrimitiveTopologyUnrestricted),
                                       structure->dynamicPrimitiveTopologyUnrestricted);
            }
        } break;

        // Validation code for VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT);
                VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT* structure =
                    (VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::subpassMergeFeedback), structure->subpassMergeFeedback);
            }
        } break;

        // Validation code for VkRenderPassCreationControlEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT: {  // Covers VUID-VkRenderPassCreationControlEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassCreationControlEXT);
                VkRenderPassCreationControlEXT* structure = (VkRenderPassCreationControlEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::disallowMerging), structure->disallowMerging);
            }
        } break;

        // Validation code for VkRenderPassCreationFeedbackCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT: {  // Covers
                                                                                 // VUID-VkRenderPassCreationFeedbackCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassCreationFeedbackCreateInfoEXT);
                VkRenderPassCreationFeedbackCreateInfoEXT* structure = (VkRenderPassCreationFeedbackCreateInfoEXT*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pRenderPassFeedback), structure->pRenderPassFeedback,
                                                "VUID-VkRenderPassCreationFeedbackCreateInfoEXT-pRenderPassFeedback-parameter");

                if (structure->pRenderPassFeedback != nullptr) {
                    [[maybe_unused]] const Location pRenderPassFeedback_loc = pNext_loc.dot(Field::pRenderPassFeedback);
                }
            }
        } break;

        // Validation code for VkRenderPassSubpassFeedbackCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT: {  // Covers
                                                                                // VUID-VkRenderPassSubpassFeedbackCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkRenderPassSubpassFeedbackCreateInfoEXT);
                VkRenderPassSubpassFeedbackCreateInfoEXT* structure = (VkRenderPassSubpassFeedbackCreateInfoEXT*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pSubpassFeedback), structure->pSubpassFeedback,
                                                "VUID-VkRenderPassSubpassFeedbackCreateInfoEXT-pSubpassFeedback-parameter");

                if (structure->pSubpassFeedback != nullptr) {
                    [[maybe_unused]] const Location pSubpassFeedback_loc = pNext_loc.dot(Field::pSubpassFeedback);
                }
            }
        } break;

        // Validation code for VkDirectDriverLoadingListLUNARG structure members
        case VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG: {  // Covers VUID-VkDirectDriverLoadingListLUNARG-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkDirectDriverLoadingListLUNARG);
                VkDirectDriverLoadingListLUNARG* structure = (VkDirectDriverLoadingListLUNARG*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::mode), "VkDirectDriverLoadingModeLUNARG", structure->mode,
                                           "VUID-VkDirectDriverLoadingListLUNARG-mode-parameter");

                skip |= ValidateStructTypeArray(pNext_loc.dot(Field::driverCount), pNext_loc.dot(Field::pDrivers),
                                                "VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG", structure->driverCount,
                                                structure->pDrivers, VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG, true,
                                                true, "VUID-VkDirectDriverLoadingInfoLUNARG-sType-sType",
                                                "VUID-VkDirectDriverLoadingListLUNARG-pDrivers-parameter",
                                                "VUID-VkDirectDriverLoadingListLUNARG-driverCount-arraylength");

                if (structure->pDrivers != nullptr) {
                    for (uint32_t driverIndex = 0; driverIndex < structure->driverCount; ++driverIndex) {
                        [[maybe_unused]] const Location pDrivers_loc = pNext_loc.dot(Field::pDrivers, driverIndex);
                        skip |= ValidateReservedFlags(pDrivers_loc.dot(Field::flags), structure->pDrivers[driverIndex].flags,
                                                      "VUID-VkDirectDriverLoadingInfoLUNARG-flags-zerobitmask");
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT: {  // Covers
                                                                                         // VUID-VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT);
                VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT* structure =
                    (VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderModuleIdentifier), structure->shaderModuleIdentifier);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT-sType-sType

        // Validation code for VkPipelineShaderStageModuleIdentifierCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT: {  // Covers
                                                                                           // VUID-VkPipelineShaderStageModuleIdentifierCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPipelineShaderStageModuleIdentifierCreateInfoEXT);
                VkPipelineShaderStageModuleIdentifierCreateInfoEXT* structure =
                    (VkPipelineShaderStageModuleIdentifierCreateInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::identifierSize), pNext_loc.dot(Field::pIdentifier),
                                      structure->identifierSize, &structure->pIdentifier, false, true, kVUIDUndefined,
                                      "VUID-VkPipelineShaderStageModuleIdentifierCreateInfoEXT-pIdentifier-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceOpticalFlowFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV: {  // Covers
                                                                            // VUID-VkPhysicalDeviceOpticalFlowFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceOpticalFlowFeaturesNV);
                VkPhysicalDeviceOpticalFlowFeaturesNV* structure = (VkPhysicalDeviceOpticalFlowFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::opticalFlow), structure->opticalFlow);
            }
        } break;

        // No Validation code for VkPhysicalDeviceOpticalFlowPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceOpticalFlowPropertiesNV-sType-sType

        // Validation code for VkOpticalFlowImageFormatInfoNV structure members
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV: {  // Covers VUID-VkOpticalFlowImageFormatInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkOpticalFlowImageFormatInfoNV);
                VkOpticalFlowImageFormatInfoNV* structure = (VkOpticalFlowImageFormatInfoNV*)header;
                skip |= ValidateFlags(pNext_loc.dot(Field::usage), "VkOpticalFlowUsageFlagBitsNV", AllVkOpticalFlowUsageFlagBitsNV,
                                      structure->usage, kRequiredFlags, "VUID-VkOpticalFlowImageFormatInfoNV-usage-parameter",
                                      "VUID-VkOpticalFlowImageFormatInfoNV-usage-requiredbitmask");
            }
        } break;

        // Validation code for VkOpticalFlowSessionCreatePrivateDataInfoNV structure members
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV: {  // Covers
                                                                                    // VUID-VkOpticalFlowSessionCreatePrivateDataInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkOpticalFlowSessionCreatePrivateDataInfoNV);
                VkOpticalFlowSessionCreatePrivateDataInfoNV* structure = (VkOpticalFlowSessionCreatePrivateDataInfoNV*)header;
                skip |= ValidateRequiredPointer(pNext_loc.dot(Field::pPrivateData), structure->pPrivateData,
                                                "VUID-VkOpticalFlowSessionCreatePrivateDataInfoNV-pPrivateData-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceLegacyDitheringFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceLegacyDitheringFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceLegacyDitheringFeaturesEXT);
                VkPhysicalDeviceLegacyDitheringFeaturesEXT* structure = (VkPhysicalDeviceLegacyDitheringFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::legacyDithering), structure->legacyDithering);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineProtectedAccessFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT: {  // Covers
                                                                                          // VUID-VkPhysicalDevicePipelineProtectedAccessFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePipelineProtectedAccessFeaturesEXT);
                VkPhysicalDevicePipelineProtectedAccessFeaturesEXT* structure =
                    (VkPhysicalDevicePipelineProtectedAccessFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineProtectedAccess), structure->pipelineProtectedAccess);
            }
        } break;
#ifdef VK_USE_PLATFORM_ANDROID_KHR

        // Validation code for VkPhysicalDeviceExternalFormatResolveFeaturesANDROID structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID: {  // Covers
                                                                                            // VUID-VkPhysicalDeviceExternalFormatResolveFeaturesANDROID-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExternalFormatResolveFeaturesANDROID);
                VkPhysicalDeviceExternalFormatResolveFeaturesANDROID* structure =
                    (VkPhysicalDeviceExternalFormatResolveFeaturesANDROID*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::externalFormatResolve), structure->externalFormatResolve);
            }
        } break;

        // No Validation code for VkPhysicalDeviceExternalFormatResolvePropertiesANDROID structure members  -- Covers
        // VUID-VkPhysicalDeviceExternalFormatResolvePropertiesANDROID-sType-sType

        // No Validation code for VkAndroidHardwareBufferFormatResolvePropertiesANDROID structure members  -- Covers
        // VUID-VkAndroidHardwareBufferFormatResolvePropertiesANDROID-sType-sType
#endif  // VK_USE_PLATFORM_ANDROID_KHR

        // Validation code for VkPhysicalDeviceShaderObjectFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT: {  // Covers
                                                                              // VUID-VkPhysicalDeviceShaderObjectFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderObjectFeaturesEXT);
                VkPhysicalDeviceShaderObjectFeaturesEXT* structure = (VkPhysicalDeviceShaderObjectFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderObject), structure->shaderObject);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderObjectPropertiesEXT structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderObjectPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceTilePropertiesFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM: {  // Covers
                                                                                 // VUID-VkPhysicalDeviceTilePropertiesFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceTilePropertiesFeaturesQCOM);
                VkPhysicalDeviceTilePropertiesFeaturesQCOM* structure = (VkPhysicalDeviceTilePropertiesFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::tileProperties), structure->tileProperties);
            }
        } break;

        // Validation code for VkPhysicalDeviceAmigoProfilingFeaturesSEC structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC: {  // Covers
                                                                                // VUID-VkPhysicalDeviceAmigoProfilingFeaturesSEC-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceAmigoProfilingFeaturesSEC);
                VkPhysicalDeviceAmigoProfilingFeaturesSEC* structure = (VkPhysicalDeviceAmigoProfilingFeaturesSEC*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::amigoProfiling), structure->amigoProfiling);
            }
        } break;

        // No Validation code for VkAmigoProfilingSubmitInfoSEC structure members  -- Covers
        // VUID-VkAmigoProfilingSubmitInfoSEC-sType-sType

        // Validation code for VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM: {  // Covers
                                                                                              // VUID-VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM);
                VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM* structure =
                    (VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewPerViewViewports), structure->multiviewPerViewViewports);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV: {  // Covers
                                                                                              // VUID-VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV);
                VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV* structure =
                    (VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingInvocationReorder), structure->rayTracingInvocationReorder);
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV: {  // Covers
                                                                                             // VUID-VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV);
                VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV* structure =
                    (VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::extendedSparseAddressSpace), structure->extendedSparseAddressSpace);
            }
        } break;

        // No Validation code for VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV structure members  -- Covers
        // VUID-VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV-sType-sType

        // Validation code for VkLayerSettingsCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT: {  // Covers VUID-VkLayerSettingsCreateInfoEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkLayerSettingsCreateInfoEXT);
                VkLayerSettingsCreateInfoEXT* structure = (VkLayerSettingsCreateInfoEXT*)header;
                skip |= ValidateArray(pNext_loc.dot(Field::settingCount), pNext_loc.dot(Field::pSettings), structure->settingCount,
                                      &structure->pSettings, false, true, kVUIDUndefined,
                                      "VUID-VkLayerSettingsCreateInfoEXT-pSettings-parameter");

                if (structure->pSettings != nullptr) {
                    for (uint32_t settingIndex = 0; settingIndex < structure->settingCount; ++settingIndex) {
                        [[maybe_unused]] const Location pSettings_loc = pNext_loc.dot(Field::pSettings, settingIndex);
                        skip |= ValidateRequiredPointer(pSettings_loc.dot(Field::pLayerName),
                                                        structure->pSettings[settingIndex].pLayerName,
                                                        "VUID-VkLayerSettingEXT-pLayerName-parameter");

                        skip |= ValidateRequiredPointer(pSettings_loc.dot(Field::pSettingName),
                                                        structure->pSettings[settingIndex].pSettingName,
                                                        "VUID-VkLayerSettingEXT-pSettingName-parameter");

                        skip |=
                            ValidateRangedEnum(pSettings_loc.dot(Field::type), "VkLayerSettingTypeEXT",
                                               structure->pSettings[settingIndex].type, "VUID-VkLayerSettingEXT-type-parameter");

                        skip |= ValidateArray(pSettings_loc.dot(Field::valueCount), pSettings_loc.dot(Field::pValues),
                                              structure->pSettings[settingIndex].valueCount,
                                              &structure->pSettings[settingIndex].pValues, false, true, kVUIDUndefined,
                                              "VUID-VkLayerSettingEXT-pValues-parameter");
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM);
                VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM* structure = (VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::shaderCoreBuiltins), structure->shaderCoreBuiltins);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM structure members  -- Covers
        // VUID-VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM-sType-sType

        // Validation code for VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT: {  // Covers
                                                                                               // VUID-VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT);
                VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT* structure =
                    (VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::pipelineLibraryGroupHandles), structure->pipelineLibraryGroupHandles);
            }
        } break;

        // Validation code for VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT: {  // Covers
                                                                                                     // VUID-VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT);
                VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT* structure =
                    (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::dynamicRenderingUnusedAttachments),
                                       structure->dynamicRenderingUnusedAttachments);
            }
        } break;

        // No Validation code for VkLatencySubmissionPresentIdNV structure members  -- Covers
        // VUID-VkLatencySubmissionPresentIdNV-sType-sType

        // Validation code for VkSwapchainLatencyCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV: {  // Covers VUID-VkSwapchainLatencyCreateInfoNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSwapchainLatencyCreateInfoNV);
                VkSwapchainLatencyCreateInfoNV* structure = (VkSwapchainLatencyCreateInfoNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::latencyModeEnable), structure->latencyModeEnable);
            }
        } break;

        // No Validation code for VkLatencySurfaceCapabilitiesNV structure members  -- Covers
        // VUID-VkLatencySurfaceCapabilitiesNV-sType-sType

        // Validation code for VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM: {  // Covers
                                                                                                 // VUID-VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM);
                VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM* structure =
                    (VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewPerViewRenderAreas), structure->multiviewPerViewRenderAreas);
            }
        } break;

        // Validation code for VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM structure members
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM: {  // Covers
                                                                                               // VUID-VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM);
                VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM* structure =
                    (VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM*)header;
                skip |=
                    ValidateArray(pNext_loc.dot(Field::perViewRenderAreaCount), pNext_loc.dot(Field::pPerViewRenderAreas),
                                  structure->perViewRenderAreaCount, &structure->pPerViewRenderAreas, false, true, kVUIDUndefined,
                                  "VUID-VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM-pPerViewRenderAreas-parameter");

                if (structure->pPerViewRenderAreas != nullptr) {
                    for (uint32_t perViewRenderAreaIndex = 0; perViewRenderAreaIndex < structure->perViewRenderAreaCount;
                         ++perViewRenderAreaIndex) {
                        [[maybe_unused]] const Location pPerViewRenderAreas_loc =
                            pNext_loc.dot(Field::pPerViewRenderAreas, perViewRenderAreaIndex);
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDevicePerStageDescriptorSetFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV: {  // Covers
                                                                                        // VUID-VkPhysicalDevicePerStageDescriptorSetFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDevicePerStageDescriptorSetFeaturesNV);
                VkPhysicalDevicePerStageDescriptorSetFeaturesNV* structure =
                    (VkPhysicalDevicePerStageDescriptorSetFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::perStageDescriptorSet), structure->perStageDescriptorSet);

                skip |= ValidateBool32(pNext_loc.dot(Field::dynamicPipelineLayout), structure->dynamicPipelineLayout);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageProcessing2FeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM: {  // Covers
                                                                                    // VUID-VkPhysicalDeviceImageProcessing2FeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceImageProcessing2FeaturesQCOM);
                VkPhysicalDeviceImageProcessing2FeaturesQCOM* structure = (VkPhysicalDeviceImageProcessing2FeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::textureBlockMatch2), structure->textureBlockMatch2);
            }
        } break;

        // No Validation code for VkPhysicalDeviceImageProcessing2PropertiesQCOM structure members  -- Covers
        // VUID-VkPhysicalDeviceImageProcessing2PropertiesQCOM-sType-sType

        // Validation code for VkSamplerBlockMatchWindowCreateInfoQCOM structure members
        case VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM: {  // Covers
                                                                               // VUID-VkSamplerBlockMatchWindowCreateInfoQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerBlockMatchWindowCreateInfoQCOM);
                VkSamplerBlockMatchWindowCreateInfoQCOM* structure = (VkSamplerBlockMatchWindowCreateInfoQCOM*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::windowCompareMode), "VkBlockMatchWindowCompareModeQCOM",
                                           structure->windowCompareMode,
                                           "VUID-VkSamplerBlockMatchWindowCreateInfoQCOM-windowCompareMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceCubicWeightsFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM: {  // Covers
                                                                               // VUID-VkPhysicalDeviceCubicWeightsFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCubicWeightsFeaturesQCOM);
                VkPhysicalDeviceCubicWeightsFeaturesQCOM* structure = (VkPhysicalDeviceCubicWeightsFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::selectableCubicWeights), structure->selectableCubicWeights);
            }
        } break;

        // Validation code for VkSamplerCubicWeightsCreateInfoQCOM structure members
        case VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM: {  // Covers
                                                                          // VUID-VkSamplerCubicWeightsCreateInfoQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerCubicWeightsCreateInfoQCOM);
                VkSamplerCubicWeightsCreateInfoQCOM* structure = (VkSamplerCubicWeightsCreateInfoQCOM*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::cubicWeights), "VkCubicFilterWeightsQCOM", structure->cubicWeights,
                                           "VUID-VkSamplerCubicWeightsCreateInfoQCOM-cubicWeights-parameter");
            }
        } break;

        // Validation code for VkBlitImageCubicWeightsInfoQCOM structure members
        case VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM: {  // Covers VUID-VkBlitImageCubicWeightsInfoQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkBlitImageCubicWeightsInfoQCOM);
                VkBlitImageCubicWeightsInfoQCOM* structure = (VkBlitImageCubicWeightsInfoQCOM*)header;
                skip |= ValidateRangedEnum(pNext_loc.dot(Field::cubicWeights), "VkCubicFilterWeightsQCOM", structure->cubicWeights,
                                           "VUID-VkBlitImageCubicWeightsInfoQCOM-cubicWeights-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceYcbcrDegammaFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM: {  // Covers
                                                                               // VUID-VkPhysicalDeviceYcbcrDegammaFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceYcbcrDegammaFeaturesQCOM);
                VkPhysicalDeviceYcbcrDegammaFeaturesQCOM* structure = (VkPhysicalDeviceYcbcrDegammaFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::ycbcrDegamma), structure->ycbcrDegamma);
            }
        } break;

        // Validation code for VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM structure members
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM: {  // Covers
                                                                                           // VUID-VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM);
                VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM* structure =
                    (VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::enableYDegamma), structure->enableYDegamma);

                skip |= ValidateBool32(pNext_loc.dot(Field::enableCbCrDegamma), structure->enableCbCrDegamma);
            }
        } break;

        // Validation code for VkPhysicalDeviceCubicClampFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM: {  // Covers
                                                                             // VUID-VkPhysicalDeviceCubicClampFeaturesQCOM-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceCubicClampFeaturesQCOM);
                VkPhysicalDeviceCubicClampFeaturesQCOM* structure = (VkPhysicalDeviceCubicClampFeaturesQCOM*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::cubicRangeClamp), structure->cubicRangeClamp);
            }
        } break;

        // Validation code for VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT: {  // Covers
                                                                                                       // VUID-VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT);
                VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT* structure =
                    (VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::attachmentFeedbackLoopDynamicState),
                                       structure->attachmentFeedbackLoopDynamicState);
            }
        } break;
#ifdef VK_USE_PLATFORM_SCREEN_QNX

        // No Validation code for VkScreenBufferFormatPropertiesQNX structure members  -- Covers
        // VUID-VkScreenBufferFormatPropertiesQNX-sType-sType

        // No Validation code for VkImportScreenBufferInfoQNX structure members  -- Covers
        // VUID-VkImportScreenBufferInfoQNX-sType-sType

        // No Validation code for VkExternalFormatQNX structure members  -- Covers VUID-VkExternalFormatQNX-sType-sType

        // Validation code for VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX: {  // Covers
                                                                                              // VUID-VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX);
                VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX* structure =
                    (VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::screenBufferImport), structure->screenBufferImport);
            }
        } break;
#endif  // VK_USE_PLATFORM_SCREEN_QNX

        // No Validation code for VkPhysicalDeviceLayeredDriverPropertiesMSFT structure members  -- Covers
        // VUID-VkPhysicalDeviceLayeredDriverPropertiesMSFT-sType-sType

        // Validation code for VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV: {  // Covers
                                                                                              // VUID-VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc =
                    loc.pNext(Struct::VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV);
                VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV* structure =
                    (VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorPoolOverallocation), structure->descriptorPoolOverallocation);
            }
        } break;

        // Validation code for VkWriteDescriptorSetAccelerationStructureKHR structure members
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR: {  // Covers
                                                                                   // VUID-VkWriteDescriptorSetAccelerationStructureKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkWriteDescriptorSetAccelerationStructureKHR);
                VkWriteDescriptorSetAccelerationStructureKHR* structure = (VkWriteDescriptorSetAccelerationStructureKHR*)header;
                skip |=
                    ValidateArray(pNext_loc.dot(Field::accelerationStructureCount), pNext_loc.dot(Field::pAccelerationStructures),
                                  structure->accelerationStructureCount, &structure->pAccelerationStructures, true, false,
                                  "VUID-VkWriteDescriptorSetAccelerationStructureKHR-accelerationStructureCount-arraylength",
                                  "VUID-VkWriteDescriptorSetAccelerationStructureKHR-pAccelerationStructures-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceAccelerationStructureFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR: {  // Covers
                                                                                       // VUID-VkPhysicalDeviceAccelerationStructureFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceAccelerationStructureFeaturesKHR);
                VkPhysicalDeviceAccelerationStructureFeaturesKHR* structure =
                    (VkPhysicalDeviceAccelerationStructureFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::accelerationStructure), structure->accelerationStructure);

                skip |= ValidateBool32(pNext_loc.dot(Field::accelerationStructureCaptureReplay),
                                       structure->accelerationStructureCaptureReplay);

                skip |= ValidateBool32(pNext_loc.dot(Field::accelerationStructureIndirectBuild),
                                       structure->accelerationStructureIndirectBuild);

                skip |= ValidateBool32(pNext_loc.dot(Field::accelerationStructureHostCommands),
                                       structure->accelerationStructureHostCommands);

                skip |= ValidateBool32(pNext_loc.dot(Field::descriptorBindingAccelerationStructureUpdateAfterBind),
                                       structure->descriptorBindingAccelerationStructureUpdateAfterBind);
            }
        } break;

        // No Validation code for VkPhysicalDeviceAccelerationStructurePropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceAccelerationStructurePropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceRayTracingPipelineFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR: {  // Covers
                                                                                     // VUID-VkPhysicalDeviceRayTracingPipelineFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRayTracingPipelineFeaturesKHR);
                VkPhysicalDeviceRayTracingPipelineFeaturesKHR* structure = (VkPhysicalDeviceRayTracingPipelineFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingPipeline), structure->rayTracingPipeline);

                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingPipelineShaderGroupHandleCaptureReplay),
                                       structure->rayTracingPipelineShaderGroupHandleCaptureReplay);

                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingPipelineShaderGroupHandleCaptureReplayMixed),
                                       structure->rayTracingPipelineShaderGroupHandleCaptureReplayMixed);

                skip |= ValidateBool32(pNext_loc.dot(Field::rayTracingPipelineTraceRaysIndirect),
                                       structure->rayTracingPipelineTraceRaysIndirect);

                skip |= ValidateBool32(pNext_loc.dot(Field::rayTraversalPrimitiveCulling), structure->rayTraversalPrimitiveCulling);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRayTracingPipelinePropertiesKHR structure members  -- Covers
        // VUID-VkPhysicalDeviceRayTracingPipelinePropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceRayQueryFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR: {  // Covers
                                                                          // VUID-VkPhysicalDeviceRayQueryFeaturesKHR-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceRayQueryFeaturesKHR);
                VkPhysicalDeviceRayQueryFeaturesKHR* structure = (VkPhysicalDeviceRayQueryFeaturesKHR*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::rayQuery), structure->rayQuery);
            }
        } break;

        // Validation code for VkPhysicalDeviceMeshShaderFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT: {  // Covers
                                                                            // VUID-VkPhysicalDeviceMeshShaderFeaturesEXT-sType-sType
            if (is_const_param) {
                [[maybe_unused]] const Location pNext_loc = loc.pNext(Struct::VkPhysicalDeviceMeshShaderFeaturesEXT);
                VkPhysicalDeviceMeshShaderFeaturesEXT* structure = (VkPhysicalDeviceMeshShaderFeaturesEXT*)header;
                skip |= ValidateBool32(pNext_loc.dot(Field::taskShader), structure->taskShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::meshShader), structure->meshShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::multiviewMeshShader), structure->multiviewMeshShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::primitiveFragmentShadingRateMeshShader),
                                       structure->primitiveFragmentShadingRateMeshShader);

                skip |= ValidateBool32(pNext_loc.dot(Field::meshShaderQueries), structure->meshShaderQueries);
            }
        } break;

            // No Validation code for VkPhysicalDeviceMeshShaderPropertiesEXT structure members  -- Covers
            // VUID-VkPhysicalDeviceMeshShaderPropertiesEXT-sType-sType

        default:
            skip = false;
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateInstance(const VkInstanceCreateInfo* pCreateInfo,
                                                        const VkAllocationCallbacks* pAllocator, VkInstance* pInstance,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO, true, "VUID-vkCreateInstance-pCreateInfo-parameter",
                               "VUID-VkInstanceCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkInstanceCreateInfo = {VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG,
                                                                     VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT,
                                                                     VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkInstanceCreateInfo.size(),
                                    allowed_structs_VkInstanceCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkInstanceCreateInfo-pNext-pNext", "VUID-VkInstanceCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkInstanceCreateFlagBits", AllVkInstanceCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkInstanceCreateInfo-flags-parameter");

        skip |= ValidateStructType(pCreateInfo_loc.dot(Field::pApplicationInfo), "VK_STRUCTURE_TYPE_APPLICATION_INFO",
                                   pCreateInfo->pApplicationInfo, VK_STRUCTURE_TYPE_APPLICATION_INFO, false,
                                   "VUID-VkInstanceCreateInfo-pApplicationInfo-parameter", "VUID-VkApplicationInfo-sType-sType");

        if (pCreateInfo->pApplicationInfo != nullptr) {
            [[maybe_unused]] const Location pApplicationInfo_loc = pCreateInfo_loc.dot(Field::pApplicationInfo);
            skip |= ValidateStructPnext(pApplicationInfo_loc, pCreateInfo->pApplicationInfo->pNext, 0, nullptr,
                                        GeneratedVulkanHeaderVersion, "VUID-VkApplicationInfo-pNext-pNext", kVUIDUndefined, false,
                                        true);
        }

        skip |= ValidateStringArray(pCreateInfo_loc.dot(Field::enabledLayerCount), pCreateInfo_loc.dot(Field::ppEnabledLayerNames),
                                    pCreateInfo->enabledLayerCount, pCreateInfo->ppEnabledLayerNames, false, true, kVUIDUndefined,
                                    "VUID-VkInstanceCreateInfo-ppEnabledLayerNames-parameter");

        skip |= ValidateStringArray(pCreateInfo_loc.dot(Field::enabledExtensionCount),
                                    pCreateInfo_loc.dot(Field::ppEnabledExtensionNames), pCreateInfo->enabledExtensionCount,
                                    pCreateInfo->ppEnabledExtensionNames, false, true, kVUIDUndefined,
                                    "VUID-VkInstanceCreateInfo-ppEnabledExtensionNames-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pInstance), pInstance, "VUID-vkCreateInstance-pInstance-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateInstance(pCreateInfo, pAllocator, pInstance, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateEnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount,
                                                                  VkPhysicalDevice* pPhysicalDevices,
                                                                  const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateArray(loc.dot(Field::pPhysicalDeviceCount), loc.dot(Field::pPhysicalDevices), pPhysicalDeviceCount,
                          &pPhysicalDevices, true, false, false, kVUIDUndefined,
                          "VUID-vkEnumeratePhysicalDevices-pPhysicalDevices-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice,
                                                                   VkPhysicalDeviceFeatures* pFeatures,
                                                                   const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredPointer(loc.dot(Field::pFeatures), pFeatures, "VUID-vkGetPhysicalDeviceFeatures-pFeatures-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                           VkFormatProperties* pFormatProperties,
                                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateRangedEnum(loc.dot(Field::format), "VkFormat", format, "VUID-vkGetPhysicalDeviceFormatProperties-format-parameter");
    skip |= ValidateRequiredPointer(loc.dot(Field::pFormatProperties), pFormatProperties,
                                    "VUID-vkGetPhysicalDeviceFormatProperties-pFormatProperties-parameter");
    if (pFormatProperties != nullptr) {
        [[maybe_unused]] const Location pFormatProperties_loc = loc.dot(Field::pFormatProperties);
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                                VkImageType type, VkImageTiling tiling,
                                                                                VkImageUsageFlags usage, VkImageCreateFlags flags,
                                                                                VkImageFormatProperties* pImageFormatProperties,
                                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRangedEnum(loc.dot(Field::format), "VkFormat", format,
                               "VUID-vkGetPhysicalDeviceImageFormatProperties-format-parameter");
    skip |= ValidateRangedEnum(loc.dot(Field::type), "VkImageType", type,
                               "VUID-vkGetPhysicalDeviceImageFormatProperties-type-parameter");
    skip |= ValidateRangedEnum(loc.dot(Field::tiling), "VkImageTiling", tiling,
                               "VUID-vkGetPhysicalDeviceImageFormatProperties-tiling-parameter");
    skip |= ValidateFlags(loc.dot(Field::usage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits, usage, kRequiredFlags,
                          "VUID-vkGetPhysicalDeviceImageFormatProperties-usage-parameter",
                          "VUID-vkGetPhysicalDeviceImageFormatProperties-usage-requiredbitmask");
    skip |= ValidateFlags(loc.dot(Field::flags), "VkImageCreateFlagBits", AllVkImageCreateFlagBits, flags, kOptionalFlags,
                          "VUID-vkGetPhysicalDeviceImageFormatProperties-flags-parameter");
    skip |= ValidateRequiredPointer(loc.dot(Field::pImageFormatProperties), pImageFormatProperties,
                                    "VUID-vkGetPhysicalDeviceImageFormatProperties-pImageFormatProperties-parameter");
    if (pImageFormatProperties != nullptr) {
        [[maybe_unused]] const Location pImageFormatProperties_loc = loc.dot(Field::pImageFormatProperties);
        // No xml-driven validation
    }
    if (!skip)
        skip |= manual_PreCallValidateGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                             pImageFormatProperties, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice,
                                                                     VkPhysicalDeviceProperties* pProperties,
                                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredPointer(loc.dot(Field::pProperties), pProperties,
                                    "VUID-vkGetPhysicalDeviceProperties-pProperties-parameter");
    if (pProperties != nullptr) {
        [[maybe_unused]] const Location pProperties_loc = loc.dot(Field::pProperties);
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice,
                                                                                uint32_t* pQueueFamilyPropertyCount,
                                                                                VkQueueFamilyProperties* pQueueFamilyProperties,
                                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateArray(loc.dot(Field::pQueueFamilyPropertyCount), loc.dot(Field::pQueueFamilyProperties),
                          pQueueFamilyPropertyCount, &pQueueFamilyProperties, true, false, false, kVUIDUndefined,
                          "VUID-vkGetPhysicalDeviceQueueFamilyProperties-pQueueFamilyProperties-parameter");
    if (pQueueFamilyProperties != nullptr) {
        for (uint32_t pQueueFamilyPropertyIndex = 0; pQueueFamilyPropertyIndex < *pQueueFamilyPropertyCount;
             ++pQueueFamilyPropertyIndex) {
            [[maybe_unused]] const Location pQueueFamilyProperties_loc =
                loc.dot(Field::pQueueFamilyProperties, pQueueFamilyPropertyIndex);
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice,
                                                                           VkPhysicalDeviceMemoryProperties* pMemoryProperties,
                                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredPointer(loc.dot(Field::pMemoryProperties), pMemoryProperties,
                                    "VUID-vkGetPhysicalDeviceMemoryProperties-pMemoryProperties-parameter");
    if (pMemoryProperties != nullptr) {
        [[maybe_unused]] const Location pMemoryProperties_loc = loc.dot(Field::pMemoryProperties);
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo,
                                                      const VkAllocationCallbacks* pAllocator, VkDevice* pDevice,
                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO, true, "VUID-vkCreateDevice-pCreateInfo-parameter",
                               "VUID-VkDeviceCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkDeviceCreateInfo = {
            VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV,
            VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO,
            VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD,
            VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO,
            VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkDeviceCreateInfo.size(),
                                    allowed_structs_VkDeviceCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkDeviceCreateInfo-pNext-pNext", "VUID-VkDeviceCreateInfo-sType-unique", true, true);

        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkDeviceCreateInfo-flags-zerobitmask");

        skip |= ValidateStructTypeArray(
            pCreateInfo_loc.dot(Field::queueCreateInfoCount), pCreateInfo_loc.dot(Field::pQueueCreateInfos),
            "VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", pCreateInfo->queueCreateInfoCount, pCreateInfo->pQueueCreateInfos,
            VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO, true, true, "VUID-VkDeviceQueueCreateInfo-sType-sType",
            "VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", "VUID-VkDeviceCreateInfo-queueCreateInfoCount-arraylength");

        if (pCreateInfo->pQueueCreateInfos != nullptr) {
            for (uint32_t queueCreateInfoIndex = 0; queueCreateInfoIndex < pCreateInfo->queueCreateInfoCount;
                 ++queueCreateInfoIndex) {
                [[maybe_unused]] const Location pQueueCreateInfos_loc =
                    pCreateInfo_loc.dot(Field::pQueueCreateInfos, queueCreateInfoIndex);
                constexpr std::array allowed_structs_VkDeviceQueueCreateInfo = {
                    VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR,
                    VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM};

                skip |= ValidateStructPnext(pQueueCreateInfos_loc, pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].pNext,
                                            allowed_structs_VkDeviceQueueCreateInfo.size(),
                                            allowed_structs_VkDeviceQueueCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                            "VUID-VkDeviceQueueCreateInfo-pNext-pNext", "VUID-VkDeviceQueueCreateInfo-sType-unique",
                                            true, true);

                skip |= ValidateFlags(pQueueCreateInfos_loc.dot(Field::flags), "VkDeviceQueueCreateFlagBits",
                                      AllVkDeviceQueueCreateFlagBits, pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].flags,
                                      kOptionalFlags, "VUID-VkDeviceQueueCreateInfo-flags-parameter");

                skip |=
                    ValidateArray(pQueueCreateInfos_loc.dot(Field::queueCount), pQueueCreateInfos_loc.dot(Field::pQueuePriorities),
                                  pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].queueCount,
                                  &pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].pQueuePriorities, true, true,
                                  "VUID-VkDeviceQueueCreateInfo-queueCount-arraylength",
                                  "VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter");
            }
        }

        skip |= ValidateStringArray(pCreateInfo_loc.dot(Field::enabledLayerCount), pCreateInfo_loc.dot(Field::ppEnabledLayerNames),
                                    pCreateInfo->enabledLayerCount, pCreateInfo->ppEnabledLayerNames, false, true, kVUIDUndefined,
                                    "VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter");

        skip |= ValidateStringArray(pCreateInfo_loc.dot(Field::enabledExtensionCount),
                                    pCreateInfo_loc.dot(Field::ppEnabledExtensionNames), pCreateInfo->enabledExtensionCount,
                                    pCreateInfo->ppEnabledExtensionNames, false, true, kVUIDUndefined,
                                    "VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter");

        if (pCreateInfo->pEnabledFeatures != nullptr) {
            [[maybe_unused]] const Location pEnabledFeatures_loc = pCreateInfo_loc.dot(Field::pEnabledFeatures);
            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::robustBufferAccess),
                                   pCreateInfo->pEnabledFeatures->robustBufferAccess);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::fullDrawIndexUint32),
                                   pCreateInfo->pEnabledFeatures->fullDrawIndexUint32);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::imageCubeArray), pCreateInfo->pEnabledFeatures->imageCubeArray);

            skip |=
                ValidateBool32(pEnabledFeatures_loc.dot(Field::independentBlend), pCreateInfo->pEnabledFeatures->independentBlend);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::geometryShader), pCreateInfo->pEnabledFeatures->geometryShader);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::tessellationShader),
                                   pCreateInfo->pEnabledFeatures->tessellationShader);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sampleRateShading),
                                   pCreateInfo->pEnabledFeatures->sampleRateShading);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::dualSrcBlend), pCreateInfo->pEnabledFeatures->dualSrcBlend);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::logicOp), pCreateInfo->pEnabledFeatures->logicOp);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::multiDrawIndirect),
                                   pCreateInfo->pEnabledFeatures->multiDrawIndirect);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::drawIndirectFirstInstance),
                                   pCreateInfo->pEnabledFeatures->drawIndirectFirstInstance);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::depthClamp), pCreateInfo->pEnabledFeatures->depthClamp);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::depthBiasClamp), pCreateInfo->pEnabledFeatures->depthBiasClamp);

            skip |=
                ValidateBool32(pEnabledFeatures_loc.dot(Field::fillModeNonSolid), pCreateInfo->pEnabledFeatures->fillModeNonSolid);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::depthBounds), pCreateInfo->pEnabledFeatures->depthBounds);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::wideLines), pCreateInfo->pEnabledFeatures->wideLines);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::largePoints), pCreateInfo->pEnabledFeatures->largePoints);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::alphaToOne), pCreateInfo->pEnabledFeatures->alphaToOne);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::multiViewport), pCreateInfo->pEnabledFeatures->multiViewport);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::samplerAnisotropy),
                                   pCreateInfo->pEnabledFeatures->samplerAnisotropy);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::textureCompressionETC2),
                                   pCreateInfo->pEnabledFeatures->textureCompressionETC2);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::textureCompressionASTC_LDR),
                                   pCreateInfo->pEnabledFeatures->textureCompressionASTC_LDR);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::textureCompressionBC),
                                   pCreateInfo->pEnabledFeatures->textureCompressionBC);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::occlusionQueryPrecise),
                                   pCreateInfo->pEnabledFeatures->occlusionQueryPrecise);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::pipelineStatisticsQuery),
                                   pCreateInfo->pEnabledFeatures->pipelineStatisticsQuery);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::vertexPipelineStoresAndAtomics),
                                   pCreateInfo->pEnabledFeatures->vertexPipelineStoresAndAtomics);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::fragmentStoresAndAtomics),
                                   pCreateInfo->pEnabledFeatures->fragmentStoresAndAtomics);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderTessellationAndGeometryPointSize),
                                   pCreateInfo->pEnabledFeatures->shaderTessellationAndGeometryPointSize);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderImageGatherExtended),
                                   pCreateInfo->pEnabledFeatures->shaderImageGatherExtended);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderStorageImageExtendedFormats),
                                   pCreateInfo->pEnabledFeatures->shaderStorageImageExtendedFormats);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderStorageImageMultisample),
                                   pCreateInfo->pEnabledFeatures->shaderStorageImageMultisample);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderStorageImageReadWithoutFormat),
                                   pCreateInfo->pEnabledFeatures->shaderStorageImageReadWithoutFormat);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderStorageImageWriteWithoutFormat),
                                   pCreateInfo->pEnabledFeatures->shaderStorageImageWriteWithoutFormat);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderUniformBufferArrayDynamicIndexing),
                                   pCreateInfo->pEnabledFeatures->shaderUniformBufferArrayDynamicIndexing);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderSampledImageArrayDynamicIndexing),
                                   pCreateInfo->pEnabledFeatures->shaderSampledImageArrayDynamicIndexing);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderStorageBufferArrayDynamicIndexing),
                                   pCreateInfo->pEnabledFeatures->shaderStorageBufferArrayDynamicIndexing);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderStorageImageArrayDynamicIndexing),
                                   pCreateInfo->pEnabledFeatures->shaderStorageImageArrayDynamicIndexing);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderClipDistance),
                                   pCreateInfo->pEnabledFeatures->shaderClipDistance);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderCullDistance),
                                   pCreateInfo->pEnabledFeatures->shaderCullDistance);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderFloat64), pCreateInfo->pEnabledFeatures->shaderFloat64);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderInt64), pCreateInfo->pEnabledFeatures->shaderInt64);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderInt16), pCreateInfo->pEnabledFeatures->shaderInt16);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderResourceResidency),
                                   pCreateInfo->pEnabledFeatures->shaderResourceResidency);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::shaderResourceMinLod),
                                   pCreateInfo->pEnabledFeatures->shaderResourceMinLod);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseBinding), pCreateInfo->pEnabledFeatures->sparseBinding);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidencyBuffer),
                                   pCreateInfo->pEnabledFeatures->sparseResidencyBuffer);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidencyImage2D),
                                   pCreateInfo->pEnabledFeatures->sparseResidencyImage2D);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidencyImage3D),
                                   pCreateInfo->pEnabledFeatures->sparseResidencyImage3D);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidency2Samples),
                                   pCreateInfo->pEnabledFeatures->sparseResidency2Samples);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidency4Samples),
                                   pCreateInfo->pEnabledFeatures->sparseResidency4Samples);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidency8Samples),
                                   pCreateInfo->pEnabledFeatures->sparseResidency8Samples);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidency16Samples),
                                   pCreateInfo->pEnabledFeatures->sparseResidency16Samples);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::sparseResidencyAliased),
                                   pCreateInfo->pEnabledFeatures->sparseResidencyAliased);

            skip |= ValidateBool32(pEnabledFeatures_loc.dot(Field::variableMultisampleRate),
                                   pCreateInfo->pEnabledFeatures->variableMultisampleRate);

            skip |=
                ValidateBool32(pEnabledFeatures_loc.dot(Field::inheritedQueries), pCreateInfo->pEnabledFeatures->inheritedQueries);
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pDevice), pDevice, "VUID-vkCreateDevice-pDevice-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDevice(physicalDevice, pCreateInfo, pAllocator, pDevice, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex,
                                                        VkQueue* pQueue, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredPointer(loc.dot(Field::pQueue), pQueue, "VUID-vkGetDeviceQueue-pQueue-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateQueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits,
                                                     VkFence fence, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(loc.dot(Field::submitCount), loc.dot(Field::pSubmits), "VK_STRUCTURE_TYPE_SUBMIT_INFO",
                                    submitCount, pSubmits, VK_STRUCTURE_TYPE_SUBMIT_INFO, false, true,
                                    "VUID-VkSubmitInfo-sType-sType", "VUID-vkQueueSubmit-pSubmits-parameter", kVUIDUndefined);
    if (pSubmits != nullptr) {
        for (uint32_t submitIndex = 0; submitIndex < submitCount; ++submitIndex) {
            [[maybe_unused]] const Location pSubmits_loc = loc.dot(Field::pSubmits, submitIndex);
            constexpr std::array allowed_structs_VkSubmitInfo = {VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC,
                                                                 VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR,
                                                                 VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO,
                                                                 VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT,
                                                                 VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV,
                                                                 VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR,
                                                                 VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO,
                                                                 VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO,
                                                                 VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR,
                                                                 VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV};

            skip |= ValidateStructPnext(pSubmits_loc, pSubmits[submitIndex].pNext, allowed_structs_VkSubmitInfo.size(),
                                        allowed_structs_VkSubmitInfo.data(), GeneratedVulkanHeaderVersion,
                                        "VUID-VkSubmitInfo-pNext-pNext", "VUID-VkSubmitInfo-sType-unique", false, true);

            skip |= ValidateArray(pSubmits_loc.dot(Field::waitSemaphoreCount), pSubmits_loc.dot(Field::pWaitSemaphores),
                                  pSubmits[submitIndex].waitSemaphoreCount, &pSubmits[submitIndex].pWaitSemaphores, false, true,
                                  kVUIDUndefined, "VUID-VkSubmitInfo-pWaitSemaphores-parameter");

            skip |=
                ValidateFlagsArray(pSubmits_loc.dot(Field::waitSemaphoreCount), pSubmits_loc.dot(Field::pWaitDstStageMask),
                                   "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pSubmits[submitIndex].waitSemaphoreCount,
                                   pSubmits[submitIndex].pWaitDstStageMask, false, "VUID-VkSubmitInfo-pWaitDstStageMask-parameter");

            skip |= ValidateArray(pSubmits_loc.dot(Field::commandBufferCount), pSubmits_loc.dot(Field::pCommandBuffers),
                                  pSubmits[submitIndex].commandBufferCount, &pSubmits[submitIndex].pCommandBuffers, false, true,
                                  kVUIDUndefined, "VUID-VkSubmitInfo-pCommandBuffers-parameter");

            skip |= ValidateArray(pSubmits_loc.dot(Field::signalSemaphoreCount), pSubmits_loc.dot(Field::pSignalSemaphores),
                                  pSubmits[submitIndex].signalSemaphoreCount, &pSubmits[submitIndex].pSignalSemaphores, false, true,
                                  kVUIDUndefined, "VUID-VkSubmitInfo-pSignalSemaphores-parameter");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateQueueWaitIdle(VkQueue queue, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateDeviceWaitIdle(VkDevice device, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateAllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo,
                                                        const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pAllocateInfo), "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO", pAllocateInfo,
                               VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO, true, "VUID-vkAllocateMemory-pAllocateInfo-parameter",
                               "VUID-VkMemoryAllocateInfo-sType-sType");
    if (pAllocateInfo != nullptr) {
        [[maybe_unused]] const Location pAllocateInfo_loc = loc.dot(Field::pAllocateInfo);
        constexpr std::array allowed_structs_VkMemoryAllocateInfo = {VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV,
                                                                     VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO,
                                                                     VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV,
                                                                     VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR,
                                                                     VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV,
                                                                     VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID,
                                                                     VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA,
                                                                     VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR,
                                                                     VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR,
                                                                     VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV,
                                                                     VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA,
                                                                     VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT,
                                                                     VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX,
                                                                     VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO,
                                                                     VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO,
                                                                     VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO,
                                                                     VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT};

        skip |= ValidateStructPnext(pAllocateInfo_loc, pAllocateInfo->pNext, allowed_structs_VkMemoryAllocateInfo.size(),
                                    allowed_structs_VkMemoryAllocateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkMemoryAllocateInfo-pNext-pNext", "VUID-VkMemoryAllocateInfo-sType-unique", false, true);
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pMemory), pMemory, "VUID-vkAllocateMemory-pMemory-parameter");
    if (!skip) skip |= manual_PreCallValidateAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateFreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator,
                                                    const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateMapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size,
                                                   VkMemoryMapFlags flags, void** ppData, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::memory), memory);
    skip |= ValidateReservedFlags(loc.dot(Field::flags), flags, "VUID-vkMapMemory-flags-zerobitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateUnmapMemory(VkDevice device, VkDeviceMemory memory, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::memory), memory);
    return skip;
}

bool StatelessValidation::PreCallValidateFlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount,
                                                                 const VkMappedMemoryRange* pMemoryRanges,
                                                                 const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::memoryRangeCount), loc.dot(Field::pMemoryRanges), "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", memoryRangeCount,
        pMemoryRanges, VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE, true, true, "VUID-VkMappedMemoryRange-sType-sType",
        "VUID-vkFlushMappedMemoryRanges-pMemoryRanges-parameter", "VUID-vkFlushMappedMemoryRanges-memoryRangeCount-arraylength");
    if (pMemoryRanges != nullptr) {
        for (uint32_t memoryRangeIndex = 0; memoryRangeIndex < memoryRangeCount; ++memoryRangeIndex) {
            [[maybe_unused]] const Location pMemoryRanges_loc = loc.dot(Field::pMemoryRanges, memoryRangeIndex);
            skip |= ValidateStructPnext(pMemoryRanges_loc, pMemoryRanges[memoryRangeIndex].pNext, 0, nullptr,
                                        GeneratedVulkanHeaderVersion, "VUID-VkMappedMemoryRange-pNext-pNext", kVUIDUndefined, false,
                                        true);

            skip |= ValidateRequiredHandle(pMemoryRanges_loc.dot(Field::memory), pMemoryRanges[memoryRangeIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateInvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount,
                                                                      const VkMappedMemoryRange* pMemoryRanges,
                                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(loc.dot(Field::memoryRangeCount), loc.dot(Field::pMemoryRanges),
                                    "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", memoryRangeCount, pMemoryRanges,
                                    VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE, true, true, "VUID-VkMappedMemoryRange-sType-sType",
                                    "VUID-vkInvalidateMappedMemoryRanges-pMemoryRanges-parameter",
                                    "VUID-vkInvalidateMappedMemoryRanges-memoryRangeCount-arraylength");
    if (pMemoryRanges != nullptr) {
        for (uint32_t memoryRangeIndex = 0; memoryRangeIndex < memoryRangeCount; ++memoryRangeIndex) {
            [[maybe_unused]] const Location pMemoryRanges_loc = loc.dot(Field::pMemoryRanges, memoryRangeIndex);
            skip |= ValidateStructPnext(pMemoryRanges_loc, pMemoryRanges[memoryRangeIndex].pNext, 0, nullptr,
                                        GeneratedVulkanHeaderVersion, "VUID-VkMappedMemoryRange-pNext-pNext", kVUIDUndefined, false,
                                        true);

            skip |= ValidateRequiredHandle(pMemoryRanges_loc.dot(Field::memory), pMemoryRanges[memoryRangeIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory,
                                                                   VkDeviceSize* pCommittedMemoryInBytes,
                                                                   const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::memory), memory);
    skip |= ValidateRequiredPointer(loc.dot(Field::pCommittedMemoryInBytes), pCommittedMemoryInBytes,
                                    "VUID-vkGetDeviceMemoryCommitment-pCommittedMemoryInBytes-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateBindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory,
                                                          VkDeviceSize memoryOffset, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    skip |= ValidateRequiredHandle(loc.dot(Field::memory), memory);
    return skip;
}

bool StatelessValidation::PreCallValidateBindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory,
                                                         VkDeviceSize memoryOffset, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::image), image);
    skip |= ValidateRequiredHandle(loc.dot(Field::memory), memory);
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferMemoryRequirements(VkDevice device, VkBuffer buffer,
                                                                     VkMemoryRequirements* pMemoryRequirements,
                                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    skip |= ValidateRequiredPointer(loc.dot(Field::pMemoryRequirements), pMemoryRequirements,
                                    "VUID-vkGetBufferMemoryRequirements-pMemoryRequirements-parameter");
    if (pMemoryRequirements != nullptr) {
        [[maybe_unused]] const Location pMemoryRequirements_loc = loc.dot(Field::pMemoryRequirements);
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageMemoryRequirements(VkDevice device, VkImage image,
                                                                    VkMemoryRequirements* pMemoryRequirements,
                                                                    const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::image), image);
    skip |= ValidateRequiredPointer(loc.dot(Field::pMemoryRequirements), pMemoryRequirements,
                                    "VUID-vkGetImageMemoryRequirements-pMemoryRequirements-parameter");
    if (pMemoryRequirements != nullptr) {
        [[maybe_unused]] const Location pMemoryRequirements_loc = loc.dot(Field::pMemoryRequirements);
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageSparseMemoryRequirements(
    VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements* pSparseMemoryRequirements, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::image), image);
    skip |= ValidateArray(loc.dot(Field::pSparseMemoryRequirementCount), loc.dot(Field::pSparseMemoryRequirements),
                          pSparseMemoryRequirementCount, &pSparseMemoryRequirements, true, false, false, kVUIDUndefined,
                          "VUID-vkGetImageSparseMemoryRequirements-pSparseMemoryRequirements-parameter");
    if (pSparseMemoryRequirements != nullptr) {
        for (uint32_t pSparseMemoryRequirementIndex = 0; pSparseMemoryRequirementIndex < *pSparseMemoryRequirementCount;
             ++pSparseMemoryRequirementIndex) {
            [[maybe_unused]] const Location pSparseMemoryRequirements_loc =
                loc.dot(Field::pSparseMemoryRequirements, pSparseMemoryRequirementIndex);
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSparseImageFormatProperties(
    VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage,
    VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties,
    const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRangedEnum(loc.dot(Field::format), "VkFormat", format,
                               "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-format-parameter");
    skip |= ValidateRangedEnum(loc.dot(Field::type), "VkImageType", type,
                               "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-type-parameter");
    skip |= ValidateFlags(loc.dot(Field::samples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits, samples, kRequiredSingleBit,
                          "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-samples-parameter",
                          "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-samples-parameter");
    skip |= ValidateFlags(loc.dot(Field::usage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits, usage, kRequiredFlags,
                          "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-usage-parameter",
                          "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-usage-requiredbitmask");
    skip |= ValidateRangedEnum(loc.dot(Field::tiling), "VkImageTiling", tiling,
                               "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-tiling-parameter");
    skip |= ValidateArray(loc.dot(Field::pPropertyCount), loc.dot(Field::pProperties), pPropertyCount, &pProperties, true, false,
                          false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-pProperties-parameter");
    if (pProperties != nullptr) {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex) {
            [[maybe_unused]] const Location pProperties_loc = loc.dot(Field::pProperties, pPropertyIndex);
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateQueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo,
                                                         VkFence fence, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateStructTypeArray(loc.dot(Field::bindInfoCount), loc.dot(Field::pBindInfo), "VK_STRUCTURE_TYPE_BIND_SPARSE_INFO",
                                bindInfoCount, pBindInfo, VK_STRUCTURE_TYPE_BIND_SPARSE_INFO, false, true,
                                "VUID-VkBindSparseInfo-sType-sType", "VUID-vkQueueBindSparse-pBindInfo-parameter", kVUIDUndefined);
    if (pBindInfo != nullptr) {
        for (uint32_t bindInfoIndex = 0; bindInfoIndex < bindInfoCount; ++bindInfoIndex) {
            [[maybe_unused]] const Location pBindInfo_loc = loc.dot(Field::pBindInfo, bindInfoIndex);
            constexpr std::array allowed_structs_VkBindSparseInfo = {VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO,
                                                                     VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT,
                                                                     VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO};

            skip |= ValidateStructPnext(pBindInfo_loc, pBindInfo[bindInfoIndex].pNext, allowed_structs_VkBindSparseInfo.size(),
                                        allowed_structs_VkBindSparseInfo.data(), GeneratedVulkanHeaderVersion,
                                        "VUID-VkBindSparseInfo-pNext-pNext", "VUID-VkBindSparseInfo-sType-unique", false, true);

            skip |= ValidateArray(pBindInfo_loc.dot(Field::waitSemaphoreCount), pBindInfo_loc.dot(Field::pWaitSemaphores),
                                  pBindInfo[bindInfoIndex].waitSemaphoreCount, &pBindInfo[bindInfoIndex].pWaitSemaphores, false,
                                  true, kVUIDUndefined, "VUID-VkBindSparseInfo-pWaitSemaphores-parameter");

            skip |= ValidateArray(pBindInfo_loc.dot(Field::bufferBindCount), pBindInfo_loc.dot(Field::pBufferBinds),
                                  pBindInfo[bindInfoIndex].bufferBindCount, &pBindInfo[bindInfoIndex].pBufferBinds, false, true,
                                  kVUIDUndefined, "VUID-VkBindSparseInfo-pBufferBinds-parameter");

            if (pBindInfo[bindInfoIndex].pBufferBinds != nullptr) {
                for (uint32_t bufferBindIndex = 0; bufferBindIndex < pBindInfo[bindInfoIndex].bufferBindCount; ++bufferBindIndex) {
                    [[maybe_unused]] const Location pBufferBinds_loc = pBindInfo_loc.dot(Field::pBufferBinds, bufferBindIndex);
                    skip |= ValidateRequiredHandle(pBufferBinds_loc.dot(Field::buffer),
                                                   pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].buffer);

                    skip |= ValidateArray(pBufferBinds_loc.dot(Field::bindCount), pBufferBinds_loc.dot(Field::pBinds),
                                          pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].bindCount,
                                          &pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].pBinds, true, true,
                                          "VUID-VkSparseBufferMemoryBindInfo-bindCount-arraylength",
                                          "VUID-VkSparseBufferMemoryBindInfo-pBinds-parameter");

                    if (pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].pBinds != nullptr) {
                        for (uint32_t bindIndex = 0; bindIndex < pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].bindCount;
                             ++bindIndex) {
                            [[maybe_unused]] const Location pBinds_loc = pBufferBinds_loc.dot(Field::pBinds, bindIndex);
                            skip |= ValidateFlags(pBinds_loc.dot(Field::flags), "VkSparseMemoryBindFlagBits",
                                                  AllVkSparseMemoryBindFlagBits,
                                                  pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].pBinds[bindIndex].flags,
                                                  kOptionalFlags, "VUID-VkSparseMemoryBind-flags-parameter");
                        }
                    }
                }
            }

            skip |= ValidateArray(pBindInfo_loc.dot(Field::imageOpaqueBindCount), pBindInfo_loc.dot(Field::pImageOpaqueBinds),
                                  pBindInfo[bindInfoIndex].imageOpaqueBindCount, &pBindInfo[bindInfoIndex].pImageOpaqueBinds, false,
                                  true, kVUIDUndefined, "VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter");

            if (pBindInfo[bindInfoIndex].pImageOpaqueBinds != nullptr) {
                for (uint32_t imageOpaqueBindIndex = 0; imageOpaqueBindIndex < pBindInfo[bindInfoIndex].imageOpaqueBindCount;
                     ++imageOpaqueBindIndex) {
                    [[maybe_unused]] const Location pImageOpaqueBinds_loc =
                        pBindInfo_loc.dot(Field::pImageOpaqueBinds, imageOpaqueBindIndex);
                    skip |= ValidateRequiredHandle(pImageOpaqueBinds_loc.dot(Field::image),
                                                   pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].image);

                    skip |= ValidateArray(pImageOpaqueBinds_loc.dot(Field::bindCount), pImageOpaqueBinds_loc.dot(Field::pBinds),
                                          pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].bindCount,
                                          &pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].pBinds, true, true,
                                          "VUID-VkSparseImageOpaqueMemoryBindInfo-bindCount-arraylength",
                                          "VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-parameter");

                    if (pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].pBinds != nullptr) {
                        for (uint32_t bindIndex = 0;
                             bindIndex < pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].bindCount; ++bindIndex) {
                            [[maybe_unused]] const Location pBinds_loc = pImageOpaqueBinds_loc.dot(Field::pBinds, bindIndex);
                            skip |= ValidateFlags(
                                pBinds_loc.dot(Field::flags), "VkSparseMemoryBindFlagBits", AllVkSparseMemoryBindFlagBits,
                                pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].pBinds[bindIndex].flags,
                                kOptionalFlags, "VUID-VkSparseMemoryBind-flags-parameter");
                        }
                    }
                }
            }

            skip |= ValidateArray(pBindInfo_loc.dot(Field::imageBindCount), pBindInfo_loc.dot(Field::pImageBinds),
                                  pBindInfo[bindInfoIndex].imageBindCount, &pBindInfo[bindInfoIndex].pImageBinds, false, true,
                                  kVUIDUndefined, "VUID-VkBindSparseInfo-pImageBinds-parameter");

            if (pBindInfo[bindInfoIndex].pImageBinds != nullptr) {
                for (uint32_t imageBindIndex = 0; imageBindIndex < pBindInfo[bindInfoIndex].imageBindCount; ++imageBindIndex) {
                    [[maybe_unused]] const Location pImageBinds_loc = pBindInfo_loc.dot(Field::pImageBinds, imageBindIndex);
                    skip |= ValidateRequiredHandle(pImageBinds_loc.dot(Field::image),
                                                   pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].image);

                    skip |= ValidateArray(pImageBinds_loc.dot(Field::bindCount), pImageBinds_loc.dot(Field::pBinds),
                                          pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].bindCount,
                                          &pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds, true, true,
                                          "VUID-VkSparseImageMemoryBindInfo-bindCount-arraylength",
                                          "VUID-VkSparseImageMemoryBindInfo-pBinds-parameter");

                    if (pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds != nullptr) {
                        for (uint32_t bindIndex = 0; bindIndex < pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].bindCount;
                             ++bindIndex) {
                            [[maybe_unused]] const Location pBinds_loc = pImageBinds_loc.dot(Field::pBinds, bindIndex);
                            skip |= ValidateFlags(
                                pBinds_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds[bindIndex].subresource.aspectMask,
                                kRequiredFlags, "VUID-VkImageSubresource-aspectMask-parameter",
                                "VUID-VkImageSubresource-aspectMask-requiredbitmask");

                            // No xml-driven validation

                            // No xml-driven validation

                            skip |= ValidateFlags(pBinds_loc.dot(Field::flags), "VkSparseMemoryBindFlagBits",
                                                  AllVkSparseMemoryBindFlagBits,
                                                  pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds[bindIndex].flags,
                                                  kOptionalFlags, "VUID-VkSparseImageMemoryBind-flags-parameter");
                        }
                    }
                }
            }

            skip |= ValidateArray(pBindInfo_loc.dot(Field::signalSemaphoreCount), pBindInfo_loc.dot(Field::pSignalSemaphores),
                                  pBindInfo[bindInfoIndex].signalSemaphoreCount, &pBindInfo[bindInfoIndex].pSignalSemaphores, false,
                                  true, kVUIDUndefined, "VUID-VkBindSparseInfo-pSignalSemaphores-parameter");
        }
    }
    if (!skip) skip |= manual_PreCallValidateQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkFence* pFence,
                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_FENCE_CREATE_INFO, true, "VUID-vkCreateFence-pCreateInfo-parameter",
                               "VUID-VkFenceCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkFenceCreateInfo = {VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO,
                                                                  VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkFenceCreateInfo.size(),
                                    allowed_structs_VkFenceCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkFenceCreateInfo-pNext-pNext", "VUID-VkFenceCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkFenceCreateFlagBits", AllVkFenceCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkFenceCreateInfo-flags-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pFence), pFence, "VUID-vkCreateFence-pFence-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator,
                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences,
                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateHandleArray(loc.dot(Field::fenceCount), loc.dot(Field::pFences), fenceCount, pFences, true, true,
                                "VUID-vkResetFences-fenceCount-arraylength");
    return skip;
}

bool StatelessValidation::PreCallValidateGetFenceStatus(VkDevice device, VkFence fence, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::fence), fence);
    return skip;
}

bool StatelessValidation::PreCallValidateWaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences,
                                                       VkBool32 waitAll, uint64_t timeout, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateHandleArray(loc.dot(Field::fenceCount), loc.dot(Field::pFences), fenceCount, pFences, true, true,
                                "VUID-vkWaitForFences-fenceCount-arraylength");
    skip |= ValidateBool32(loc.dot(Field::waitAll), waitAll);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO, true, "VUID-vkCreateSemaphore-pCreateInfo-parameter",
                               "VUID-VkSemaphoreCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkSemaphoreCreateInfo = {
            VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT,    VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO,
            VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT,
            VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV,           VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO};

        skip |=
            ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkSemaphoreCreateInfo.size(),
                                allowed_structs_VkSemaphoreCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkSemaphoreCreateInfo-pNext-pNext", "VUID-VkSemaphoreCreateInfo-sType-unique", false, true);

        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkSemaphoreCreateInfo-flags-zerobitmask");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pSemaphore), pSemaphore, "VUID-vkCreateSemaphore-pSemaphore-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySemaphore(VkDevice device, VkSemaphore semaphore,
                                                          const VkAllocationCallbacks* pAllocator,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkEvent* pEvent,
                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_EVENT_CREATE_INFO, true, "VUID-vkCreateEvent-pCreateInfo-parameter",
                               "VUID-VkEventCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkEventCreateInfo = {VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT,
                                                                  VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkEventCreateInfo.size(),
                                    allowed_structs_VkEventCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkEventCreateInfo-pNext-pNext", "VUID-VkEventCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkEventCreateFlagBits", AllVkEventCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkEventCreateInfo-flags-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pEvent), pEvent, "VUID-vkCreateEvent-pEvent-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateEvent(device, pCreateInfo, pAllocator, pEvent, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator,
                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetEventStatus(VkDevice device, VkEvent event, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    return skip;
}

bool StatelessValidation::PreCallValidateSetEvent(VkDevice device, VkEvent event, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    return skip;
}

bool StatelessValidation::PreCallValidateResetEvent(VkDevice device, VkEvent event, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO, true, "VUID-vkCreateQueryPool-pCreateInfo-parameter",
                               "VUID-VkQueryPoolCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkQueryPoolCreateInfo = {
            VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR,
            VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL,
            VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR,
            VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR};

        skip |=
            ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkQueryPoolCreateInfo.size(),
                                allowed_structs_VkQueryPoolCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkQueryPoolCreateInfo-pNext-pNext", "VUID-VkQueryPoolCreateInfo-sType-unique", false, true);

        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkQueryPoolCreateInfo-flags-zerobitmask");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::queryType), "VkQueryType", pCreateInfo->queryType,
                                   "VUID-VkQueryPoolCreateInfo-queryType-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pQueryPool), pQueryPool, "VUID-vkCreateQueryPool-pQueryPool-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyQueryPool(VkDevice device, VkQueryPool queryPool,
                                                          const VkAllocationCallbacks* pAllocator,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery,
                                                             uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride,
                                                             VkQueryResultFlags flags, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    skip |= ValidateArray(loc.dot(Field::dataSize), loc.dot(Field::pData), dataSize, &pData, true, true,
                          "VUID-vkGetQueryPoolResults-dataSize-arraylength", "VUID-vkGetQueryPoolResults-pData-parameter");
    skip |= ValidateFlags(loc.dot(Field::flags), "VkQueryResultFlagBits", AllVkQueryResultFlagBits, flags, kOptionalFlags,
                          "VUID-vkGetQueryPoolResults-flags-parameter");
    if (!skip)
        skip |= manual_PreCallValidateGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags,
                                                          error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo,
                                                      const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer,
                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO, true, "VUID-vkCreateBuffer-pCreateInfo-parameter",
                               "VUID-VkBufferCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkBufferCreateInfo = {VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA,
                                                                   VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT,
                                                                   VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO,
                                                                   VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR,
                                                                   VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV,
                                                                   VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO,
                                                                   VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT,
                                                                   VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkBufferCreateInfo.size(),
                                    allowed_structs_VkBufferCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkBufferCreateInfo-pNext-pNext", "VUID-VkBufferCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkBufferCreateFlagBits", AllVkBufferCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkBufferCreateInfo-flags-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::sharingMode), "VkSharingMode", pCreateInfo->sharingMode,
                                   "VUID-VkBufferCreateInfo-sharingMode-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pBuffer), pBuffer, "VUID-vkCreateBuffer-pBuffer-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateBuffer(device, pCreateInfo, pAllocator, pBuffer, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo,
                                                          const VkAllocationCallbacks* pAllocator, VkBufferView* pView,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO, true, "VUID-vkCreateBufferView-pCreateInfo-parameter",
                               "VUID-VkBufferViewCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkBufferViewCreateInfo = {VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR,
                                                                       VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT};

        skip |=
            ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkBufferViewCreateInfo.size(),
                                allowed_structs_VkBufferViewCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkBufferViewCreateInfo-pNext-pNext", "VUID-VkBufferViewCreateInfo-sType-unique", false, true);

        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkBufferViewCreateInfo-flags-zerobitmask");

        skip |= ValidateRequiredHandle(pCreateInfo_loc.dot(Field::buffer), pCreateInfo->buffer);

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::format), "VkFormat", pCreateInfo->format,
                                   "VUID-VkBufferViewCreateInfo-format-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pView), pView, "VUID-vkCreateBufferView-pView-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateBufferView(device, pCreateInfo, pAllocator, pView, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyBufferView(VkDevice device, VkBufferView bufferView,
                                                           const VkAllocationCallbacks* pAllocator,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkImage* pImage,
                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO, true, "VUID-vkCreateImage-pCreateInfo-parameter",
                               "VUID-VkImageCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkImageCreateInfo = {
            VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA,
            VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV,
            VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID,
            VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX,
            VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO,
            VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV,
            VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT,
            VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO,
            VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO,
            VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR,
            VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT,
            VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT,
            VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV,
            VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkImageCreateInfo.size(),
                                    allowed_structs_VkImageCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkImageCreateInfo-pNext-pNext", "VUID-VkImageCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkImageCreateFlagBits", AllVkImageCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkImageCreateInfo-flags-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::imageType), "VkImageType", pCreateInfo->imageType,
                                   "VUID-VkImageCreateInfo-imageType-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::format), "VkFormat", pCreateInfo->format,
                                   "VUID-VkImageCreateInfo-format-parameter");

        // No xml-driven validation

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::samples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                              pCreateInfo->samples, kRequiredSingleBit, "VUID-VkImageCreateInfo-samples-parameter",
                              "VUID-VkImageCreateInfo-samples-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::tiling), "VkImageTiling", pCreateInfo->tiling,
                                   "VUID-VkImageCreateInfo-tiling-parameter");

        skip |=
            ValidateFlags(pCreateInfo_loc.dot(Field::usage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pCreateInfo->usage,
                          kRequiredFlags, "VUID-VkImageCreateInfo-usage-parameter", "VUID-VkImageCreateInfo-usage-requiredbitmask");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::sharingMode), "VkSharingMode", pCreateInfo->sharingMode,
                                   "VUID-VkImageCreateInfo-sharingMode-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::initialLayout), "VkImageLayout", pCreateInfo->initialLayout,
                                   "VUID-VkImageCreateInfo-initialLayout-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pImage), pImage, "VUID-vkCreateImage-pImage-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateImage(device, pCreateInfo, pAllocator, pImage, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator,
                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageSubresourceLayout(VkDevice device, VkImage image,
                                                                   const VkImageSubresource* pSubresource,
                                                                   VkSubresourceLayout* pLayout,
                                                                   const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::image), image);
    skip |= ValidateRequiredPointer(loc.dot(Field::pSubresource), pSubresource,
                                    "VUID-vkGetImageSubresourceLayout-pSubresource-parameter");
    if (pSubresource != nullptr) {
        [[maybe_unused]] const Location pSubresource_loc = loc.dot(Field::pSubresource);
        skip |= ValidateFlags(pSubresource_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                              pSubresource->aspectMask, kRequiredFlags, "VUID-VkImageSubresource-aspectMask-parameter",
                              "VUID-VkImageSubresource-aspectMask-requiredbitmask");
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pLayout), pLayout, "VUID-vkGetImageSubresourceLayout-pLayout-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator, VkImageView* pView,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO, true, "VUID-vkCreateImageView-pCreateInfo-parameter",
                               "VUID-VkImageViewCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkImageViewCreateInfo = {
            VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT,
            VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM,
            VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO,
            VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO};

        skip |=
            ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkImageViewCreateInfo.size(),
                                allowed_structs_VkImageViewCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkImageViewCreateInfo-pNext-pNext", "VUID-VkImageViewCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkImageViewCreateFlagBits", AllVkImageViewCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkImageViewCreateInfo-flags-parameter");

        skip |= ValidateRequiredHandle(pCreateInfo_loc.dot(Field::image), pCreateInfo->image);

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::viewType), "VkImageViewType", pCreateInfo->viewType,
                                   "VUID-VkImageViewCreateInfo-viewType-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::format), "VkFormat", pCreateInfo->format,
                                   "VUID-VkImageViewCreateInfo-format-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::r), "VkComponentSwizzle", pCreateInfo->components.r,
                                   "VUID-VkComponentMapping-r-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::g), "VkComponentSwizzle", pCreateInfo->components.g,
                                   "VUID-VkComponentMapping-g-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::b), "VkComponentSwizzle", pCreateInfo->components.b,
                                   "VUID-VkComponentMapping-b-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::a), "VkComponentSwizzle", pCreateInfo->components.a,
                                   "VUID-VkComponentMapping-a-parameter");

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                              pCreateInfo->subresourceRange.aspectMask, kRequiredFlags,
                              "VUID-VkImageSubresourceRange-aspectMask-parameter",
                              "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pView), pView, "VUID-vkCreateImageView-pView-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateImageView(device, pCreateInfo, pAllocator, pView, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyImageView(VkDevice device, VkImageView imageView,
                                                          const VkAllocationCallbacks* pAllocator,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO, true, "VUID-vkCreateShaderModule-pCreateInfo-parameter",
                               "VUID-VkShaderModuleCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkShaderModuleCreateInfo-flags-zerobitmask");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::codeSize), pCreateInfo_loc.dot(Field::pCode), pCreateInfo->codeSize / 4,
                              &pCreateInfo->pCode, true, true, "VUID-VkShaderModuleCreateInfo-codeSize-01085",
                              "VUID-VkShaderModuleCreateInfo-pCode-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |=
        ValidateRequiredPointer(loc.dot(Field::pShaderModule), pShaderModule, "VUID-vkCreateShaderModule-pShaderModule-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyShaderModule(VkDevice device, VkShaderModule shaderModule,
                                                             const VkAllocationCallbacks* pAllocator,
                                                             const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo,
                                                             const VkAllocationCallbacks* pAllocator,
                                                             VkPipelineCache* pPipelineCache, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO, true,
                               "VUID-vkCreatePipelineCache-pCreateInfo-parameter", "VUID-VkPipelineCacheCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkPipelineCacheCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkPipelineCacheCreateFlagBits", AllVkPipelineCacheCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkPipelineCacheCreateInfo-flags-parameter");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::initialDataSize), pCreateInfo_loc.dot(Field::pInitialData),
                              pCreateInfo->initialDataSize, &pCreateInfo->pInitialData, false, true, kVUIDUndefined,
                              "VUID-VkPipelineCacheCreateInfo-pInitialData-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pPipelineCache), pPipelineCache,
                                    "VUID-vkCreatePipelineCache-pPipelineCache-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache,
                                                              const VkAllocationCallbacks* pAllocator,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize,
                                                              void* pData, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::pipelineCache), pipelineCache);
    skip |= ValidateArray(loc.dot(Field::pDataSize), loc.dot(Field::pData), pDataSize, &pData, true, false, false, kVUIDUndefined,
                          "VUID-vkGetPipelineCacheData-pData-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateMergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount,
                                                             const VkPipelineCache* pSrcCaches,
                                                             const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::dstCache), dstCache);
    skip |= ValidateHandleArray(loc.dot(Field::srcCacheCount), loc.dot(Field::pSrcCaches), srcCacheCount, pSrcCaches, true, true,
                                "VUID-vkMergePipelineCaches-srcCacheCount-arraylength");
    if (!skip) skip |= manual_PreCallValidateMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache,
                                                                 uint32_t createInfoCount,
                                                                 const VkGraphicsPipelineCreateInfo* pCreateInfos,
                                                                 const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines,
                                                                 const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::createInfoCount), loc.dot(Field::pCreateInfos), "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO",
        createInfoCount, pCreateInfos, VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO, true, true,
        "VUID-VkGraphicsPipelineCreateInfo-sType-sType", "VUID-vkCreateGraphicsPipelines-pCreateInfos-parameter",
        "VUID-vkCreateGraphicsPipelines-createInfoCount-arraylength");
    if (pCreateInfos != nullptr) {
        for (uint32_t createInfoIndex = 0; createInfoIndex < createInfoCount; ++createInfoIndex) {
            [[maybe_unused]] const Location pCreateInfos_loc = loc.dot(Field::pCreateInfos, createInfoIndex);
            constexpr std::array allowed_structs_VkGraphicsPipelineCreateInfo = {
                VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD,
                VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID,
                VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT,
                VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV,
                VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX,
                VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD,
                VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR,
                VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO,
                VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT,
                VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV,
                VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR,
                VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR,
                VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO,
                VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV,
                VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT};

            skip |= ValidateStructPnext(
                pCreateInfos_loc, pCreateInfos[createInfoIndex].pNext, allowed_structs_VkGraphicsPipelineCreateInfo.size(),
                allowed_structs_VkGraphicsPipelineCreateInfo.data(), GeneratedVulkanHeaderVersion,
                "VUID-VkGraphicsPipelineCreateInfo-pNext-pNext", "VUID-VkGraphicsPipelineCreateInfo-sType-unique", false, true);

            skip |= ValidateStructType(
                pCreateInfos_loc.dot(Field::pDynamicState), "VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO",
                pCreateInfos[createInfoIndex].pDynamicState, VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO, false,
                "VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter", "VUID-VkPipelineDynamicStateCreateInfo-sType-sType");

            if (pCreateInfos[createInfoIndex].pDynamicState != nullptr) {
                [[maybe_unused]] const Location pDynamicState_loc = pCreateInfos_loc.dot(Field::pDynamicState);
                skip |= ValidateStructPnext(pDynamicState_loc, pCreateInfos[createInfoIndex].pDynamicState->pNext, 0, nullptr,
                                            GeneratedVulkanHeaderVersion, "VUID-VkPipelineDynamicStateCreateInfo-pNext-pNext",
                                            kVUIDUndefined, false, true);

                skip |=
                    ValidateReservedFlags(pDynamicState_loc.dot(Field::flags), pCreateInfos[createInfoIndex].pDynamicState->flags,
                                          "VUID-VkPipelineDynamicStateCreateInfo-flags-zerobitmask");

                skip |= ValidateRangedEnumArray(pDynamicState_loc.dot(Field::dynamicStateCount),
                                                pDynamicState_loc.dot(Field::pDynamicStates), "VkDynamicState",
                                                pCreateInfos[createInfoIndex].pDynamicState->dynamicStateCount,
                                                pCreateInfos[createInfoIndex].pDynamicState->pDynamicStates, false, true);
            }
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateArray(loc.dot(Field::createInfoCount), loc.dot(Field::pPipelines), createInfoCount, &pPipelines, true, true,
                          "VUID-vkCreateGraphicsPipelines-createInfoCount-arraylength",
                          "VUID-vkCreateGraphicsPipelines-pPipelines-parameter");
    if (!skip)
        skip |= manual_PreCallValidateCreateGraphicsPipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator,
                                                              pPipelines, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache,
                                                                uint32_t createInfoCount,
                                                                const VkComputePipelineCreateInfo* pCreateInfos,
                                                                const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines,
                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::createInfoCount), loc.dot(Field::pCreateInfos), "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO",
        createInfoCount, pCreateInfos, VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO, true, true,
        "VUID-VkComputePipelineCreateInfo-sType-sType", "VUID-vkCreateComputePipelines-pCreateInfos-parameter",
        "VUID-vkCreateComputePipelines-createInfoCount-arraylength");
    if (pCreateInfos != nullptr) {
        for (uint32_t createInfoIndex = 0; createInfoIndex < createInfoCount; ++createInfoIndex) {
            [[maybe_unused]] const Location pCreateInfos_loc = loc.dot(Field::pCreateInfos, createInfoIndex);
            constexpr std::array allowed_structs_VkComputePipelineCreateInfo = {
                VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD,
                VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO,
                VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT,
                VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI};

            skip |= ValidateStructPnext(
                pCreateInfos_loc, pCreateInfos[createInfoIndex].pNext, allowed_structs_VkComputePipelineCreateInfo.size(),
                allowed_structs_VkComputePipelineCreateInfo.data(), GeneratedVulkanHeaderVersion,
                "VUID-VkComputePipelineCreateInfo-pNext-pNext", "VUID-VkComputePipelineCreateInfo-sType-unique", false, true);

            skip |= ValidateStructType(pCreateInfos_loc.dot(Field::stage), "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO",
                                       &(pCreateInfos[createInfoIndex].stage), VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO,
                                       false, kVUIDUndefined, "VUID-VkPipelineShaderStageCreateInfo-sType-sType");

            constexpr std::array allowed_structs_VkPipelineShaderStageCreateInfo = {
                VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT,
                VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT,
                VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT,
                VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX,
                VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO,
                VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO,
                VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT};

            skip |= ValidateStructPnext(pCreateInfos_loc, pCreateInfos[createInfoIndex].stage.pNext,
                                        allowed_structs_VkPipelineShaderStageCreateInfo.size(),
                                        allowed_structs_VkPipelineShaderStageCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                        "VUID-VkPipelineShaderStageCreateInfo-pNext-pNext",
                                        "VUID-VkPipelineShaderStageCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags(pCreateInfos_loc.dot(Field::flags), "VkPipelineShaderStageCreateFlagBits",
                                  AllVkPipelineShaderStageCreateFlagBits, pCreateInfos[createInfoIndex].stage.flags, kOptionalFlags,
                                  "VUID-VkPipelineShaderStageCreateInfo-flags-parameter");

            skip |= ValidateFlags(pCreateInfos_loc.dot(Field::stage), "VkShaderStageFlagBits", AllVkShaderStageFlagBits,
                                  pCreateInfos[createInfoIndex].stage.stage, kRequiredSingleBit,
                                  "VUID-VkPipelineShaderStageCreateInfo-stage-parameter",
                                  "VUID-VkPipelineShaderStageCreateInfo-stage-parameter");

            skip |= ValidateRequiredPointer(pCreateInfos_loc.dot(Field::pName), pCreateInfos[createInfoIndex].stage.pName,
                                            "VUID-VkPipelineShaderStageCreateInfo-pName-parameter");

            if (pCreateInfos[createInfoIndex].stage.pSpecializationInfo != nullptr) {
                [[maybe_unused]] const Location pSpecializationInfo_loc = pCreateInfos_loc.dot(Field::pSpecializationInfo);
                skip |= ValidateArray(pSpecializationInfo_loc.dot(Field::mapEntryCount),
                                      pSpecializationInfo_loc.dot(Field::pMapEntries),
                                      pCreateInfos[createInfoIndex].stage.pSpecializationInfo->mapEntryCount,
                                      &pCreateInfos[createInfoIndex].stage.pSpecializationInfo->pMapEntries, false, true,
                                      kVUIDUndefined, "VUID-VkSpecializationInfo-pMapEntries-parameter");

                if (pCreateInfos[createInfoIndex].stage.pSpecializationInfo->pMapEntries != nullptr) {
                    for (uint32_t mapEntryIndex = 0;
                         mapEntryIndex < pCreateInfos[createInfoIndex].stage.pSpecializationInfo->mapEntryCount; ++mapEntryIndex) {
                        [[maybe_unused]] const Location pMapEntries_loc =
                            pSpecializationInfo_loc.dot(Field::pMapEntries, mapEntryIndex);
                        // No xml-driven validation
                    }
                }

                skip |= ValidateArray(pSpecializationInfo_loc.dot(Field::dataSize), pSpecializationInfo_loc.dot(Field::pData),
                                      pCreateInfos[createInfoIndex].stage.pSpecializationInfo->dataSize,
                                      &pCreateInfos[createInfoIndex].stage.pSpecializationInfo->pData, false, true, kVUIDUndefined,
                                      "VUID-VkSpecializationInfo-pData-parameter");
            }

            skip |= ValidateRequiredHandle(pCreateInfos_loc.dot(Field::layout), pCreateInfos[createInfoIndex].layout);
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateArray(loc.dot(Field::createInfoCount), loc.dot(Field::pPipelines), createInfoCount, &pPipelines, true, true,
                          "VUID-vkCreateComputePipelines-createInfoCount-arraylength",
                          "VUID-vkCreateComputePipelines-pPipelines-parameter");
    if (!skip)
        skip |= manual_PreCallValidateCreateComputePipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator,
                                                             pPipelines, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPipeline(VkDevice device, VkPipeline pipeline,
                                                         const VkAllocationCallbacks* pAllocator,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo,
                                                              const VkAllocationCallbacks* pAllocator,
                                                              VkPipelineLayout* pPipelineLayout,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO, true,
                               "VUID-vkCreatePipelineLayout-pCreateInfo-parameter", "VUID-VkPipelineLayoutCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, kVUIDUndefined,
                                    kVUIDUndefined, false, true);

        skip |=
            ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkPipelineLayoutCreateFlagBits", AllVkPipelineLayoutCreateFlagBits,
                          pCreateInfo->flags, kOptionalFlags, "VUID-VkPipelineLayoutCreateInfo-flags-parameter");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::pushConstantRangeCount), pCreateInfo_loc.dot(Field::pPushConstantRanges),
                              pCreateInfo->pushConstantRangeCount, &pCreateInfo->pPushConstantRanges, false, true, kVUIDUndefined,
                              "VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-parameter");

        if (pCreateInfo->pPushConstantRanges != nullptr) {
            for (uint32_t pushConstantRangeIndex = 0; pushConstantRangeIndex < pCreateInfo->pushConstantRangeCount;
                 ++pushConstantRangeIndex) {
                [[maybe_unused]] const Location pPushConstantRanges_loc =
                    pCreateInfo_loc.dot(Field::pPushConstantRanges, pushConstantRangeIndex);
                skip |= ValidateFlags(pPushConstantRanges_loc.dot(Field::stageFlags), "VkShaderStageFlagBits",
                                      AllVkShaderStageFlagBits, pCreateInfo->pPushConstantRanges[pushConstantRangeIndex].stageFlags,
                                      kRequiredFlags, "VUID-VkPushConstantRange-stageFlags-parameter",
                                      "VUID-VkPushConstantRange-stageFlags-requiredbitmask");
            }
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pPipelineLayout), pPipelineLayout,
                                    "VUID-vkCreatePipelineLayout-pPipelineLayout-parameter");
    if (!skip) skip |= manual_PreCallValidateCreatePipelineLayout(device, pCreateInfo, pAllocator, pPipelineLayout, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkSampler* pSampler,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO, true, "VUID-vkCreateSampler-pCreateInfo-parameter",
                               "VUID-VkSamplerCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkSamplerCreateInfo = {
            VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM,
            VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM,
            VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO,
            VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkSamplerCreateInfo.size(),
                                    allowed_structs_VkSamplerCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkSamplerCreateInfo-pNext-pNext", "VUID-VkSamplerCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkSamplerCreateFlagBits", AllVkSamplerCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkSamplerCreateInfo-flags-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::magFilter), "VkFilter", pCreateInfo->magFilter,
                                   "VUID-VkSamplerCreateInfo-magFilter-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::minFilter), "VkFilter", pCreateInfo->minFilter,
                                   "VUID-VkSamplerCreateInfo-minFilter-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::mipmapMode), "VkSamplerMipmapMode", pCreateInfo->mipmapMode,
                                   "VUID-VkSamplerCreateInfo-mipmapMode-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::addressModeU), "VkSamplerAddressMode", pCreateInfo->addressModeU,
                                   "VUID-VkSamplerCreateInfo-addressModeU-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::addressModeV), "VkSamplerAddressMode", pCreateInfo->addressModeV,
                                   "VUID-VkSamplerCreateInfo-addressModeV-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::addressModeW), "VkSamplerAddressMode", pCreateInfo->addressModeW,
                                   "VUID-VkSamplerCreateInfo-addressModeW-parameter");

        skip |= ValidateBool32(pCreateInfo_loc.dot(Field::anisotropyEnable), pCreateInfo->anisotropyEnable);

        skip |= ValidateBool32(pCreateInfo_loc.dot(Field::compareEnable), pCreateInfo->compareEnable);

        skip |= ValidateBool32(pCreateInfo_loc.dot(Field::unnormalizedCoordinates), pCreateInfo->unnormalizedCoordinates);
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pSampler), pSampler, "VUID-vkCreateSampler-pSampler-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSampler(device, pCreateInfo, pAllocator, pSampler, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDescriptorSetLayout(VkDevice device,
                                                                   const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                                   const VkAllocationCallbacks* pAllocator,
                                                                   VkDescriptorSetLayout* pSetLayout,
                                                                   const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO, true,
                               "VUID-vkCreateDescriptorSetLayout-pCreateInfo-parameter",
                               "VUID-VkDescriptorSetLayoutCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkDescriptorSetLayoutCreateInfo = {
            VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO,
            VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkDescriptorSetLayoutCreateInfo.size(),
                                    allowed_structs_VkDescriptorSetLayoutCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext",
                                    "VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkDescriptorSetLayoutCreateFlagBits",
                              AllVkDescriptorSetLayoutCreateFlagBits, pCreateInfo->flags, kOptionalFlags,
                              "VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::bindingCount), pCreateInfo_loc.dot(Field::pBindings),
                              pCreateInfo->bindingCount, &pCreateInfo->pBindings, false, true, kVUIDUndefined,
                              "VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter");

        if (pCreateInfo->pBindings != nullptr) {
            for (uint32_t bindingIndex = 0; bindingIndex < pCreateInfo->bindingCount; ++bindingIndex) {
                [[maybe_unused]] const Location pBindings_loc = pCreateInfo_loc.dot(Field::pBindings, bindingIndex);
                skip |= ValidateRangedEnum(pBindings_loc.dot(Field::descriptorType), "VkDescriptorType",
                                           pCreateInfo->pBindings[bindingIndex].descriptorType,
                                           "VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter");
            }
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |=
        ValidateRequiredPointer(loc.dot(Field::pSetLayout), pSetLayout, "VUID-vkCreateDescriptorSetLayout-pSetLayout-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout,
                                                                    const VkAllocationCallbacks* pAllocator,
                                                                    const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo,
                                                              const VkAllocationCallbacks* pAllocator,
                                                              VkDescriptorPool* pDescriptorPool,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO, true,
                               "VUID-vkCreateDescriptorPool-pCreateInfo-parameter", "VUID-VkDescriptorPoolCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkDescriptorPoolCreateInfo = {
            VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO,
            VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkDescriptorPoolCreateInfo.size(),
                                    allowed_structs_VkDescriptorPoolCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkDescriptorPoolCreateInfo-pNext-pNext", "VUID-VkDescriptorPoolCreateInfo-sType-unique",
                                    false, true);

        skip |=
            ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkDescriptorPoolCreateFlagBits", AllVkDescriptorPoolCreateFlagBits,
                          pCreateInfo->flags, kOptionalFlags, "VUID-VkDescriptorPoolCreateInfo-flags-parameter");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::poolSizeCount), pCreateInfo_loc.dot(Field::pPoolSizes),
                              pCreateInfo->poolSizeCount, &pCreateInfo->pPoolSizes, false, true, kVUIDUndefined,
                              "VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter");

        if (pCreateInfo->pPoolSizes != nullptr) {
            for (uint32_t poolSizeIndex = 0; poolSizeIndex < pCreateInfo->poolSizeCount; ++poolSizeIndex) {
                [[maybe_unused]] const Location pPoolSizes_loc = pCreateInfo_loc.dot(Field::pPoolSizes, poolSizeIndex);
                skip |= ValidateRangedEnum(pPoolSizes_loc.dot(Field::type), "VkDescriptorType",
                                           pCreateInfo->pPoolSizes[poolSizeIndex].type, "VUID-VkDescriptorPoolSize-type-parameter");
            }
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pDescriptorPool), pDescriptorPool,
                                    "VUID-vkCreateDescriptorPool-pDescriptorPool-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool,
                                                             VkDescriptorPoolResetFlags flags, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::descriptorPool), descriptorPool);
    skip |= ValidateReservedFlags(loc.dot(Field::flags), flags, "VUID-vkResetDescriptorPool-flags-zerobitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateAllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo,
                                                                VkDescriptorSet* pDescriptorSets,
                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateStructType(loc.dot(Field::pAllocateInfo), "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", pAllocateInfo,
                           VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO, true,
                           "VUID-vkAllocateDescriptorSets-pAllocateInfo-parameter", "VUID-VkDescriptorSetAllocateInfo-sType-sType");
    if (pAllocateInfo != nullptr) {
        [[maybe_unused]] const Location pAllocateInfo_loc = loc.dot(Field::pAllocateInfo);
        constexpr std::array allowed_structs_VkDescriptorSetAllocateInfo = {
            VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO};

        skip |= ValidateStructPnext(pAllocateInfo_loc, pAllocateInfo->pNext, allowed_structs_VkDescriptorSetAllocateInfo.size(),
                                    allowed_structs_VkDescriptorSetAllocateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkDescriptorSetAllocateInfo-pNext-pNext", "VUID-VkDescriptorSetAllocateInfo-sType-unique",
                                    false, true);

        skip |= ValidateRequiredHandle(pAllocateInfo_loc.dot(Field::descriptorPool), pAllocateInfo->descriptorPool);

        skip |= ValidateHandleArray(pAllocateInfo_loc.dot(Field::descriptorSetCount), pAllocateInfo_loc.dot(Field::pSetLayouts),
                                    pAllocateInfo->descriptorSetCount, pAllocateInfo->pSetLayouts, true, true, kVUIDUndefined);
    }
    if (pAllocateInfo != nullptr) {
        skip |= ValidateArray(loc.dot(Field::pAllocateInfo).dot(Field::descriptorSetCount), loc.dot(Field::pDescriptorSets),
                              pAllocateInfo->descriptorSetCount, &pDescriptorSets, true, true,
                              "VUID-vkAllocateDescriptorSets-pAllocateInfo::descriptorSetCount-arraylength",
                              "VUID-vkAllocateDescriptorSets-pDescriptorSets-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateFreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool,
                                                            uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::descriptorPool), descriptorPool);
    skip |= ValidateArray(loc.dot(Field::descriptorSetCount), loc, descriptorSetCount, &pDescriptorSets, true, false,
                          "VUID-vkFreeDescriptorSets-descriptorSetCount-arraylength", kVUIDUndefined);
    if (!skip)
        skip |= manual_PreCallValidateFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateUpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount,
                                                              const VkWriteDescriptorSet* pDescriptorWrites,
                                                              uint32_t descriptorCopyCount,
                                                              const VkCopyDescriptorSet* pDescriptorCopies,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(loc.dot(Field::descriptorWriteCount), loc.dot(Field::pDescriptorWrites),
                                    "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET", descriptorWriteCount, pDescriptorWrites,
                                    VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET, false, true, "VUID-VkWriteDescriptorSet-sType-sType",
                                    "VUID-vkUpdateDescriptorSets-pDescriptorWrites-parameter", kVUIDUndefined);
    if (pDescriptorWrites != nullptr) {
        for (uint32_t descriptorWriteIndex = 0; descriptorWriteIndex < descriptorWriteCount; ++descriptorWriteIndex) {
            [[maybe_unused]] const Location pDescriptorWrites_loc = loc.dot(Field::pDescriptorWrites, descriptorWriteIndex);
            constexpr std::array allowed_structs_VkWriteDescriptorSet = {
                VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR,
                VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV,
                VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK};

            skip |= ValidateStructPnext(pDescriptorWrites_loc, pDescriptorWrites[descriptorWriteIndex].pNext,
                                        allowed_structs_VkWriteDescriptorSet.size(), allowed_structs_VkWriteDescriptorSet.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkWriteDescriptorSet-pNext-pNext",
                                        "VUID-VkWriteDescriptorSet-sType-unique", false, true);

            skip |= ValidateRangedEnum(pDescriptorWrites_loc.dot(Field::descriptorType), "VkDescriptorType",
                                       pDescriptorWrites[descriptorWriteIndex].descriptorType,
                                       "VUID-VkWriteDescriptorSet-descriptorType-parameter");

            skip |= ValidateArray(pDescriptorWrites_loc.dot(Field::descriptorCount), loc,
                                  pDescriptorWrites[descriptorWriteIndex].descriptorCount,
                                  &pDescriptorWrites[descriptorWriteIndex].pImageInfo, true, false,
                                  "VUID-VkWriteDescriptorSet-descriptorCount-arraylength", kVUIDUndefined);
        }
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::descriptorCopyCount), loc.dot(Field::pDescriptorCopies),
                                    "VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", descriptorCopyCount, pDescriptorCopies,
                                    VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET, false, true, "VUID-VkCopyDescriptorSet-sType-sType",
                                    "VUID-vkUpdateDescriptorSets-pDescriptorCopies-parameter", kVUIDUndefined);
    if (pDescriptorCopies != nullptr) {
        for (uint32_t descriptorCopyIndex = 0; descriptorCopyIndex < descriptorCopyCount; ++descriptorCopyIndex) {
            [[maybe_unused]] const Location pDescriptorCopies_loc = loc.dot(Field::pDescriptorCopies, descriptorCopyIndex);
            skip |= ValidateStructPnext(pDescriptorCopies_loc, pDescriptorCopies[descriptorCopyIndex].pNext, 0, nullptr,
                                        GeneratedVulkanHeaderVersion, "VUID-VkCopyDescriptorSet-pNext-pNext", kVUIDUndefined, false,
                                        true);

            skip |= ValidateRequiredHandle(pDescriptorCopies_loc.dot(Field::srcSet), pDescriptorCopies[descriptorCopyIndex].srcSet);

            skip |= ValidateRequiredHandle(pDescriptorCopies_loc.dot(Field::dstSet), pDescriptorCopies[descriptorCopyIndex].dstSet);
        }
    }
    if (!skip)
        skip |= manual_PreCallValidateUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                           pDescriptorCopies, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo,
                                                           const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO, true, "VUID-vkCreateFramebuffer-pCreateInfo-parameter",
                               "VUID-VkFramebufferCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkFramebufferCreateInfo = {VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkFramebufferCreateInfo.size(),
                                    allowed_structs_VkFramebufferCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkFramebufferCreateInfo-pNext-pNext", "VUID-VkFramebufferCreateInfo-sType-unique", false,
                                    true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkFramebufferCreateFlagBits", AllVkFramebufferCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkFramebufferCreateInfo-flags-parameter");

        skip |= ValidateRequiredHandle(pCreateInfo_loc.dot(Field::renderPass), pCreateInfo->renderPass);
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pFramebuffer), pFramebuffer, "VUID-vkCreateFramebuffer-pFramebuffer-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo,
                                                          const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO, true, "VUID-vkCreateRenderPass-pCreateInfo-parameter",
                               "VUID-VkRenderPassCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkRenderPassCreateInfo = {
            VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO, VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO};

        skip |=
            ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkRenderPassCreateInfo.size(),
                                allowed_structs_VkRenderPassCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkRenderPassCreateInfo-pNext-pNext", "VUID-VkRenderPassCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkRenderPassCreateFlagBits", AllVkRenderPassCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkRenderPassCreateInfo-flags-parameter");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::attachmentCount), pCreateInfo_loc.dot(Field::pAttachments),
                              pCreateInfo->attachmentCount, &pCreateInfo->pAttachments, false, true, kVUIDUndefined,
                              "VUID-VkRenderPassCreateInfo-pAttachments-parameter");

        if (pCreateInfo->pAttachments != nullptr) {
            for (uint32_t attachmentIndex = 0; attachmentIndex < pCreateInfo->attachmentCount; ++attachmentIndex) {
                [[maybe_unused]] const Location pAttachments_loc = pCreateInfo_loc.dot(Field::pAttachments, attachmentIndex);
                skip |= ValidateFlags(pAttachments_loc.dot(Field::flags), "VkAttachmentDescriptionFlagBits",
                                      AllVkAttachmentDescriptionFlagBits, pCreateInfo->pAttachments[attachmentIndex].flags,
                                      kOptionalFlags, "VUID-VkAttachmentDescription-flags-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::format), "VkFormat",
                                           pCreateInfo->pAttachments[attachmentIndex].format,
                                           "VUID-VkAttachmentDescription-format-parameter");

                skip |= ValidateFlags(pAttachments_loc.dot(Field::samples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                                      pCreateInfo->pAttachments[attachmentIndex].samples, kRequiredSingleBit,
                                      "VUID-VkAttachmentDescription-samples-parameter",
                                      "VUID-VkAttachmentDescription-samples-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::loadOp), "VkAttachmentLoadOp",
                                           pCreateInfo->pAttachments[attachmentIndex].loadOp,
                                           "VUID-VkAttachmentDescription-loadOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::storeOp), "VkAttachmentStoreOp",
                                           pCreateInfo->pAttachments[attachmentIndex].storeOp,
                                           "VUID-VkAttachmentDescription-storeOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::stencilLoadOp), "VkAttachmentLoadOp",
                                           pCreateInfo->pAttachments[attachmentIndex].stencilLoadOp,
                                           "VUID-VkAttachmentDescription-stencilLoadOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::stencilStoreOp), "VkAttachmentStoreOp",
                                           pCreateInfo->pAttachments[attachmentIndex].stencilStoreOp,
                                           "VUID-VkAttachmentDescription-stencilStoreOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::initialLayout), "VkImageLayout",
                                           pCreateInfo->pAttachments[attachmentIndex].initialLayout,
                                           "VUID-VkAttachmentDescription-initialLayout-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::finalLayout), "VkImageLayout",
                                           pCreateInfo->pAttachments[attachmentIndex].finalLayout,
                                           "VUID-VkAttachmentDescription-finalLayout-parameter");
            }
        }

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::subpassCount), pCreateInfo_loc.dot(Field::pSubpasses),
                              pCreateInfo->subpassCount, &pCreateInfo->pSubpasses, true, true,
                              "VUID-VkRenderPassCreateInfo-subpassCount-arraylength",
                              "VUID-VkRenderPassCreateInfo-pSubpasses-parameter");

        if (pCreateInfo->pSubpasses != nullptr) {
            for (uint32_t subpassIndex = 0; subpassIndex < pCreateInfo->subpassCount; ++subpassIndex) {
                [[maybe_unused]] const Location pSubpasses_loc = pCreateInfo_loc.dot(Field::pSubpasses, subpassIndex);
                skip |= ValidateFlags(pSubpasses_loc.dot(Field::flags), "VkSubpassDescriptionFlagBits",
                                      AllVkSubpassDescriptionFlagBits, pCreateInfo->pSubpasses[subpassIndex].flags, kOptionalFlags,
                                      "VUID-VkSubpassDescription-flags-parameter");

                skip |= ValidateRangedEnum(pSubpasses_loc.dot(Field::pipelineBindPoint), "VkPipelineBindPoint",
                                           pCreateInfo->pSubpasses[subpassIndex].pipelineBindPoint,
                                           "VUID-VkSubpassDescription-pipelineBindPoint-parameter");

                skip |= ValidateArray(pSubpasses_loc.dot(Field::inputAttachmentCount), pSubpasses_loc.dot(Field::pInputAttachments),
                                      pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount,
                                      &pCreateInfo->pSubpasses[subpassIndex].pInputAttachments, false, true, kVUIDUndefined,
                                      "VUID-VkSubpassDescription-pInputAttachments-parameter");

                if (pCreateInfo->pSubpasses[subpassIndex].pInputAttachments != nullptr) {
                    for (uint32_t inputAttachmentIndex = 0;
                         inputAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount;
                         ++inputAttachmentIndex) {
                        [[maybe_unused]] const Location pInputAttachments_loc =
                            pSubpasses_loc.dot(Field::pInputAttachments, inputAttachmentIndex);
                        skip |=
                            ValidateRangedEnum(pInputAttachments_loc.dot(Field::layout), "VkImageLayout",
                                               pCreateInfo->pSubpasses[subpassIndex].pInputAttachments[inputAttachmentIndex].layout,
                                               "VUID-VkAttachmentReference-layout-parameter");
                    }
                }

                skip |= ValidateArray(pSubpasses_loc.dot(Field::colorAttachmentCount), pSubpasses_loc.dot(Field::pColorAttachments),
                                      pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount,
                                      &pCreateInfo->pSubpasses[subpassIndex].pColorAttachments, false, true, kVUIDUndefined,
                                      "VUID-VkSubpassDescription-pColorAttachments-parameter");

                if (pCreateInfo->pSubpasses[subpassIndex].pColorAttachments != nullptr) {
                    for (uint32_t colorAttachmentIndex = 0;
                         colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount;
                         ++colorAttachmentIndex) {
                        [[maybe_unused]] const Location pColorAttachments_loc =
                            pSubpasses_loc.dot(Field::pColorAttachments, colorAttachmentIndex);
                        skip |=
                            ValidateRangedEnum(pColorAttachments_loc.dot(Field::layout), "VkImageLayout",
                                               pCreateInfo->pSubpasses[subpassIndex].pColorAttachments[colorAttachmentIndex].layout,
                                               "VUID-VkAttachmentReference-layout-parameter");
                    }
                }

                if (pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments != nullptr) {
                    for (uint32_t colorAttachmentIndex = 0;
                         colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount;
                         ++colorAttachmentIndex) {
                        [[maybe_unused]] const Location pResolveAttachments_loc =
                            pSubpasses_loc.dot(Field::pResolveAttachments, colorAttachmentIndex);
                        skip |= ValidateRangedEnum(
                            pResolveAttachments_loc.dot(Field::layout), "VkImageLayout",
                            pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments[colorAttachmentIndex].layout,
                            "VUID-VkAttachmentReference-layout-parameter");
                    }
                }

                if (pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment != nullptr) {
                    [[maybe_unused]] const Location pDepthStencilAttachment_loc =
                        pSubpasses_loc.dot(Field::pDepthStencilAttachment);
                    skip |= ValidateRangedEnum(pDepthStencilAttachment_loc.dot(Field::layout), "VkImageLayout",
                                               pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment->layout,
                                               "VUID-VkAttachmentReference-layout-parameter");
                }

                skip |= ValidateArray(pSubpasses_loc.dot(Field::preserveAttachmentCount),
                                      pSubpasses_loc.dot(Field::pPreserveAttachments),
                                      pCreateInfo->pSubpasses[subpassIndex].preserveAttachmentCount,
                                      &pCreateInfo->pSubpasses[subpassIndex].pPreserveAttachments, false, true, kVUIDUndefined,
                                      "VUID-VkSubpassDescription-pPreserveAttachments-parameter");
            }
        }

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::dependencyCount), pCreateInfo_loc.dot(Field::pDependencies),
                              pCreateInfo->dependencyCount, &pCreateInfo->pDependencies, false, true, kVUIDUndefined,
                              "VUID-VkRenderPassCreateInfo-pDependencies-parameter");

        if (pCreateInfo->pDependencies != nullptr) {
            for (uint32_t dependencyIndex = 0; dependencyIndex < pCreateInfo->dependencyCount; ++dependencyIndex) {
                [[maybe_unused]] const Location pDependencies_loc = pCreateInfo_loc.dot(Field::pDependencies, dependencyIndex);
                skip |= ValidateFlags(pDependencies_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits",
                                      AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].srcStageMask,
                                      kOptionalFlags, "VUID-VkSubpassDependency-srcStageMask-parameter");

                skip |= ValidateFlags(pDependencies_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits",
                                      AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].dstStageMask,
                                      kOptionalFlags, "VUID-VkSubpassDependency-dstStageMask-parameter");

                skip |= ValidateFlags(pDependencies_loc.dot(Field::srcAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                      pCreateInfo->pDependencies[dependencyIndex].srcAccessMask, kOptionalFlags,
                                      "VUID-VkSubpassDependency-srcAccessMask-parameter");

                skip |= ValidateFlags(pDependencies_loc.dot(Field::dstAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                      pCreateInfo->pDependencies[dependencyIndex].dstAccessMask, kOptionalFlags,
                                      "VUID-VkSubpassDependency-dstAccessMask-parameter");

                skip |= ValidateFlags(pDependencies_loc.dot(Field::dependencyFlags), "VkDependencyFlagBits",
                                      AllVkDependencyFlagBits, pCreateInfo->pDependencies[dependencyIndex].dependencyFlags,
                                      kOptionalFlags, "VUID-VkSubpassDependency-dependencyFlags-parameter");
            }
        }
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pRenderPass), pRenderPass, "VUID-vkCreateRenderPass-pRenderPass-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyRenderPass(VkDevice device, VkRenderPass renderPass,
                                                           const VkAllocationCallbacks* pAllocator,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass,
                                                                  VkExtent2D* pGranularity, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::renderPass), renderPass);
    skip |= ValidateRequiredPointer(loc.dot(Field::pGranularity), pGranularity,
                                    "VUID-vkGetRenderAreaGranularity-pGranularity-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo,
                                                           const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO, true, "VUID-vkCreateCommandPool-pCreateInfo-parameter",
                               "VUID-VkCommandPoolCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkCommandPoolCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkCommandPoolCreateFlagBits", AllVkCommandPoolCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkCommandPoolCreateInfo-flags-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pCommandPool), pCommandPool, "VUID-vkCreateCommandPool-pCommandPool-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyCommandPool(VkDevice device, VkCommandPool commandPool,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::commandPool), commandPool);
    skip |= ValidateFlags(loc.dot(Field::flags), "VkCommandPoolResetFlagBits", AllVkCommandPoolResetFlagBits, flags, kOptionalFlags,
                          "VUID-vkResetCommandPool-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateAllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo,
                                                                VkCommandBuffer* pCommandBuffers,
                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateStructType(loc.dot(Field::pAllocateInfo), "VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", pAllocateInfo,
                           VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO, true,
                           "VUID-vkAllocateCommandBuffers-pAllocateInfo-parameter", "VUID-VkCommandBufferAllocateInfo-sType-sType");
    if (pAllocateInfo != nullptr) {
        [[maybe_unused]] const Location pAllocateInfo_loc = loc.dot(Field::pAllocateInfo);
        skip |= ValidateStructPnext(pAllocateInfo_loc, pAllocateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkCommandBufferAllocateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pAllocateInfo_loc.dot(Field::commandPool), pAllocateInfo->commandPool);

        skip |= ValidateRangedEnum(pAllocateInfo_loc.dot(Field::level), "VkCommandBufferLevel", pAllocateInfo->level,
                                   "VUID-VkCommandBufferAllocateInfo-level-parameter");
    }
    if (pAllocateInfo != nullptr) {
        skip |= ValidateArray(loc.dot(Field::pAllocateInfo).dot(Field::commandBufferCount), loc.dot(Field::pCommandBuffers),
                              pAllocateInfo->commandBufferCount, &pCommandBuffers, true, true,
                              "VUID-vkAllocateCommandBuffers-pAllocateInfo::commandBufferCount-arraylength",
                              "VUID-vkAllocateCommandBuffers-pCommandBuffers-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateFreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount,
                                                            const VkCommandBuffer* pCommandBuffers,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::commandPool), commandPool);
    skip |= ValidateArray(loc.dot(Field::commandBufferCount), loc, commandBufferCount, &pCommandBuffers, true, false,
                          "VUID-vkFreeCommandBuffers-commandBufferCount-arraylength", kVUIDUndefined);
    if (!skip)
        skip |= manual_PreCallValidateFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateBeginCommandBuffer(VkCommandBuffer commandBuffer,
                                                            const VkCommandBufferBeginInfo* pBeginInfo,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pBeginInfo), "VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", pBeginInfo,
                               VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO, true, "VUID-vkBeginCommandBuffer-pBeginInfo-parameter",
                               "VUID-VkCommandBufferBeginInfo-sType-sType");
    if (pBeginInfo != nullptr) {
        [[maybe_unused]] const Location pBeginInfo_loc = loc.dot(Field::pBeginInfo);
        constexpr std::array allowed_structs_VkCommandBufferBeginInfo = {VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO};

        skip |= ValidateStructPnext(pBeginInfo_loc, pBeginInfo->pNext, allowed_structs_VkCommandBufferBeginInfo.size(),
                                    allowed_structs_VkCommandBufferBeginInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkCommandBufferBeginInfo-pNext-pNext", "VUID-VkCommandBufferBeginInfo-sType-unique",
                                    false, true);

        skip |= ValidateFlags(pBeginInfo_loc.dot(Field::flags), "VkCommandBufferUsageFlagBits", AllVkCommandBufferUsageFlagBits,
                              pBeginInfo->flags, kOptionalFlags, "VUID-VkCommandBufferBeginInfo-flags-parameter");
    }
    if (!skip) skip |= manual_PreCallValidateBeginCommandBuffer(commandBuffer, pBeginInfo, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateEndCommandBuffer(VkCommandBuffer commandBuffer, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateFlags(loc.dot(Field::flags), "VkCommandBufferResetFlagBits", AllVkCommandBufferResetFlagBits, flags,
                          kOptionalFlags, "VUID-vkResetCommandBuffer-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                         VkPipeline pipeline, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRangedEnum(loc.dot(Field::pipelineBindPoint), "VkPipelineBindPoint", pipelineBindPoint,
                               "VUID-vkCmdBindPipeline-pipelineBindPoint-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::pipeline), pipeline);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport,
                                                        uint32_t viewportCount, const VkViewport* pViewports,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateArray(loc.dot(Field::viewportCount), loc.dot(Field::pViewports), viewportCount, &pViewports, true, true,
                          "VUID-vkCmdSetViewport-viewportCount-arraylength", "VUID-vkCmdSetViewport-pViewports-parameter");
    if (pViewports != nullptr) {
        for (uint32_t viewportIndex = 0; viewportIndex < viewportCount; ++viewportIndex) {
            [[maybe_unused]] const Location pViewports_loc = loc.dot(Field::pViewports, viewportIndex);
            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount,
                                                       const VkRect2D* pScissors, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateArray(loc.dot(Field::scissorCount), loc.dot(Field::pScissors), scissorCount, &pScissors, true, true,
                          "VUID-vkCmdSetScissor-scissorCount-arraylength", "VUID-vkCmdSetScissor-pScissors-parameter");
    if (pScissors != nullptr) {
        for (uint32_t scissorIndex = 0; scissorIndex < scissorCount; ++scissorIndex) {
            [[maybe_unused]] const Location pScissors_loc = loc.dot(Field::pScissors, scissorIndex);
            // No xml-driven validation

            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    if (!skip) skip |= manual_PreCallValidateCmdSetLineWidth(commandBuffer, lineWidth, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor,
                                                         float depthBiasClamp, float depthBiasSlopeFactor,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4],
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds,
                                                           float maxDepthBounds, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask,
                                                                  uint32_t compareMask, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateFlags(loc.dot(Field::faceMask), "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags,
                          "VUID-vkCmdSetStencilCompareMask-faceMask-parameter",
                          "VUID-vkCmdSetStencilCompareMask-faceMask-requiredbitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask,
                                                                uint32_t writeMask, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateFlags(loc.dot(Field::faceMask), "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags,
                      "VUID-vkCmdSetStencilWriteMask-faceMask-parameter", "VUID-vkCmdSetStencilWriteMask-faceMask-requiredbitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask,
                                                                uint32_t reference, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateFlags(loc.dot(Field::faceMask), "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags,
                      "VUID-vkCmdSetStencilReference-faceMask-parameter", "VUID-vkCmdSetStencilReference-faceMask-requiredbitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                               VkPipelineLayout layout, uint32_t firstSet,
                                                               uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets,
                                                               uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets,
                                                               const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRangedEnum(loc.dot(Field::pipelineBindPoint), "VkPipelineBindPoint", pipelineBindPoint,
                               "VUID-vkCmdBindDescriptorSets-pipelineBindPoint-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::layout), layout);
    skip |= ValidateArray(loc.dot(Field::descriptorSetCount), loc.dot(Field::pDescriptorSets), descriptorSetCount, &pDescriptorSets,
                          true, false, "VUID-vkCmdBindDescriptorSets-descriptorSetCount-arraylength",
                          "VUID-vkCmdBindDescriptorSets-pDescriptorSets-parameter");
    skip |= ValidateArray(loc.dot(Field::dynamicOffsetCount), loc.dot(Field::pDynamicOffsets), dynamicOffsetCount, &pDynamicOffsets,
                          false, true, kVUIDUndefined, "VUID-vkCmdBindDescriptorSets-pDynamicOffsets-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                            VkIndexType indexType, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateRangedEnum(loc.dot(Field::indexType), "VkIndexType", indexType, "VUID-vkCmdBindIndexBuffer-indexType-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding,
                                                              uint32_t bindingCount, const VkBuffer* pBuffers,
                                                              const VkDeviceSize* pOffsets, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateArray(loc.dot(Field::bindingCount), loc.dot(Field::pBuffers), bindingCount, &pBuffers, true, false,
                          "VUID-vkCmdBindVertexBuffers-bindingCount-arraylength", "VUID-vkCmdBindVertexBuffers-pBuffers-parameter");
    skip |= ValidateArray(loc.dot(Field::bindingCount), loc.dot(Field::pOffsets), bindingCount, &pOffsets, true, true,
                          "VUID-vkCmdBindVertexBuffers-bindingCount-arraylength", "VUID-vkCmdBindVertexBuffers-pOffsets-parameter");
    if (!skip)
        skip |=
            manual_PreCallValidateCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount,
                                                 uint32_t firstVertex, uint32_t firstInstance, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount,
                                                        uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                         uint32_t drawCount, uint32_t stride, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                                uint32_t drawCount, uint32_t stride,
                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY,
                                                     uint32_t groupCountZ, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                             const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer,
                                                       uint32_t regionCount, const VkBufferCopy* pRegions,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::srcBuffer), srcBuffer);
    skip |= ValidateRequiredHandle(loc.dot(Field::dstBuffer), dstBuffer);
    skip |= ValidateArray(loc.dot(Field::regionCount), loc.dot(Field::pRegions), regionCount, &pRegions, true, true,
                          "VUID-vkCmdCopyBuffer-regionCount-arraylength", "VUID-vkCmdCopyBuffer-pRegions-parameter");
    if (pRegions != nullptr) {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
            [[maybe_unused]] const Location pRegions_loc = loc.dot(Field::pRegions, regionIndex);
            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                                      VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                                      const VkImageCopy* pRegions, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::srcImage), srcImage);
    skip |= ValidateRangedEnum(loc.dot(Field::srcImageLayout), "VkImageLayout", srcImageLayout,
                               "VUID-vkCmdCopyImage-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::dstImage), dstImage);
    skip |= ValidateRangedEnum(loc.dot(Field::dstImageLayout), "VkImageLayout", dstImageLayout,
                               "VUID-vkCmdCopyImage-dstImageLayout-parameter");
    skip |= ValidateArray(loc.dot(Field::regionCount), loc.dot(Field::pRegions), regionCount, &pRegions, true, true,
                          "VUID-vkCmdCopyImage-regionCount-arraylength", "VUID-vkCmdCopyImage-pRegions-parameter");
    if (pRegions != nullptr) {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
            [[maybe_unused]] const Location pRegions_loc = loc.dot(Field::pRegions, regionIndex);
            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                                      VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                                      const VkImageBlit* pRegions, VkFilter filter,
                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::srcImage), srcImage);
    skip |= ValidateRangedEnum(loc.dot(Field::srcImageLayout), "VkImageLayout", srcImageLayout,
                               "VUID-vkCmdBlitImage-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::dstImage), dstImage);
    skip |= ValidateRangedEnum(loc.dot(Field::dstImageLayout), "VkImageLayout", dstImageLayout,
                               "VUID-vkCmdBlitImage-dstImageLayout-parameter");
    skip |= ValidateArray(loc.dot(Field::regionCount), loc.dot(Field::pRegions), regionCount, &pRegions, true, true,
                          "VUID-vkCmdBlitImage-regionCount-arraylength", "VUID-vkCmdBlitImage-pRegions-parameter");
    if (pRegions != nullptr) {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
            [[maybe_unused]] const Location pRegions_loc = loc.dot(Field::pRegions, regionIndex);
            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");
        }
    }
    skip |= ValidateRangedEnum(loc.dot(Field::filter), "VkFilter", filter, "VUID-vkCmdBlitImage-filter-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage,
                                                              VkImageLayout dstImageLayout, uint32_t regionCount,
                                                              const VkBufferImageCopy* pRegions,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::srcBuffer), srcBuffer);
    skip |= ValidateRequiredHandle(loc.dot(Field::dstImage), dstImage);
    skip |= ValidateRangedEnum(loc.dot(Field::dstImageLayout), "VkImageLayout", dstImageLayout,
                               "VUID-vkCmdCopyBufferToImage-dstImageLayout-parameter");
    skip |= ValidateArray(loc.dot(Field::regionCount), loc.dot(Field::pRegions), regionCount, &pRegions, true, true,
                          "VUID-vkCmdCopyBufferToImage-regionCount-arraylength", "VUID-vkCmdCopyBufferToImage-pRegions-parameter");
    if (pRegions != nullptr) {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
            [[maybe_unused]] const Location pRegions_loc = loc.dot(Field::pRegions, regionIndex);
            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage,
                                                              VkImageLayout srcImageLayout, VkBuffer dstBuffer,
                                                              uint32_t regionCount, const VkBufferImageCopy* pRegions,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::srcImage), srcImage);
    skip |= ValidateRangedEnum(loc.dot(Field::srcImageLayout), "VkImageLayout", srcImageLayout,
                               "VUID-vkCmdCopyImageToBuffer-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::dstBuffer), dstBuffer);
    skip |= ValidateArray(loc.dot(Field::regionCount), loc.dot(Field::pRegions), regionCount, &pRegions, true, true,
                          "VUID-vkCmdCopyImageToBuffer-regionCount-arraylength", "VUID-vkCmdCopyImageToBuffer-pRegions-parameter");
    if (pRegions != nullptr) {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
            [[maybe_unused]] const Location pRegions_loc = loc.dot(Field::pRegions, regionIndex);
            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                                         VkDeviceSize dataSize, const void* pData,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::dstBuffer), dstBuffer);
    skip |= ValidateArray(loc.dot(Field::dataSize), loc.dot(Field::pData), dataSize, &pData, true, true,
                          "VUID-vkCmdUpdateBuffer-dataSize-arraylength", "VUID-vkCmdUpdateBuffer-pData-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                                       VkDeviceSize size, uint32_t data, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::dstBuffer), dstBuffer);
    if (!skip) skip |= manual_PreCallValidateCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
                                                            const VkClearColorValue* pColor, uint32_t rangeCount,
                                                            const VkImageSubresourceRange* pRanges,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::image), image);
    skip |= ValidateRangedEnum(loc.dot(Field::imageLayout), "VkImageLayout", imageLayout,
                               "VUID-vkCmdClearColorImage-imageLayout-parameter");
    skip |= ValidateArray(loc.dot(Field::rangeCount), loc.dot(Field::pRanges), rangeCount, &pRanges, true, true,
                          "VUID-vkCmdClearColorImage-rangeCount-arraylength", "VUID-vkCmdClearColorImage-pRanges-parameter");
    if (pRanges != nullptr) {
        for (uint32_t rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex) {
            [[maybe_unused]] const Location pRanges_loc = loc.dot(Field::pRanges, rangeIndex);
            skip |=
                ValidateFlags(pRanges_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                              pRanges[rangeIndex].aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter",
                              "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    if (!skip)
        skip |= manual_PreCallValidateCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image,
                                                                   VkImageLayout imageLayout,
                                                                   const VkClearDepthStencilValue* pDepthStencil,
                                                                   uint32_t rangeCount, const VkImageSubresourceRange* pRanges,
                                                                   const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::image), image);
    skip |= ValidateRangedEnum(loc.dot(Field::imageLayout), "VkImageLayout", imageLayout,
                               "VUID-vkCmdClearDepthStencilImage-imageLayout-parameter");
    skip |= ValidateRequiredPointer(loc.dot(Field::pDepthStencil), pDepthStencil,
                                    "VUID-vkCmdClearDepthStencilImage-pDepthStencil-parameter");
    if (pDepthStencil != nullptr) {
        [[maybe_unused]] const Location pDepthStencil_loc = loc.dot(Field::pDepthStencil);
        // No xml-driven validation
    }
    skip |= ValidateArray(loc.dot(Field::rangeCount), loc.dot(Field::pRanges), rangeCount, &pRanges, true, true,
                          "VUID-vkCmdClearDepthStencilImage-rangeCount-arraylength",
                          "VUID-vkCmdClearDepthStencilImage-pRanges-parameter");
    if (pRanges != nullptr) {
        for (uint32_t rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex) {
            [[maybe_unused]] const Location pRanges_loc = loc.dot(Field::pRanges, rangeIndex);
            skip |=
                ValidateFlags(pRanges_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                              pRanges[rangeIndex].aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter",
                              "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount,
                                                             const VkClearAttachment* pAttachments, uint32_t rectCount,
                                                             const VkClearRect* pRects, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateArray(loc.dot(Field::attachmentCount), loc.dot(Field::pAttachments), attachmentCount, &pAttachments, true, true,
                          "VUID-vkCmdClearAttachments-attachmentCount-arraylength",
                          "VUID-vkCmdClearAttachments-pAttachments-parameter");
    if (pAttachments != nullptr) {
        for (uint32_t attachmentIndex = 0; attachmentIndex < attachmentCount; ++attachmentIndex) {
            [[maybe_unused]] const Location pAttachments_loc = loc.dot(Field::pAttachments, attachmentIndex);
            skip |=
                ValidateFlags(pAttachments_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                              pAttachments[attachmentIndex].aspectMask, kRequiredFlags,
                              "VUID-VkClearAttachment-aspectMask-parameter", "VUID-VkClearAttachment-aspectMask-requiredbitmask");
        }
    }
    skip |= ValidateArray(loc.dot(Field::rectCount), loc.dot(Field::pRects), rectCount, &pRects, true, true,
                          "VUID-vkCmdClearAttachments-rectCount-arraylength", "VUID-vkCmdClearAttachments-pRects-parameter");
    if (pRects != nullptr) {
        for (uint32_t rectIndex = 0; rectIndex < rectCount; ++rectIndex) {
            [[maybe_unused]] const Location pRects_loc = loc.dot(Field::pRects, rectIndex);
            // No xml-driven validation

            // No xml-driven validation
        }
    }
    if (!skip)
        skip |=
            manual_PreCallValidateCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage,
                                                         VkImageLayout srcImageLayout, VkImage dstImage,
                                                         VkImageLayout dstImageLayout, uint32_t regionCount,
                                                         const VkImageResolve* pRegions, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::srcImage), srcImage);
    skip |= ValidateRangedEnum(loc.dot(Field::srcImageLayout), "VkImageLayout", srcImageLayout,
                               "VUID-vkCmdResolveImage-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::dstImage), dstImage);
    skip |= ValidateRangedEnum(loc.dot(Field::dstImageLayout), "VkImageLayout", dstImageLayout,
                               "VUID-vkCmdResolveImage-dstImageLayout-parameter");
    skip |= ValidateArray(loc.dot(Field::regionCount), loc.dot(Field::pRegions), regionCount, &pRegions, true, true,
                          "VUID-vkCmdResolveImage-regionCount-arraylength", "VUID-vkCmdResolveImage-pRegions-parameter");
    if (pRegions != nullptr) {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
            [[maybe_unused]] const Location pRegions_loc = loc.dot(Field::pRegions, regionIndex);
            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                  pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags,
                                  "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                  "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask,
                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    skip |= ValidateFlags(loc.dot(Field::stageMask), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, stageMask,
                          kOptionalFlags, "VUID-vkCmdSetEvent-stageMask-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    skip |= ValidateFlags(loc.dot(Field::stageMask), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, stageMask,
                          kOptionalFlags, "VUID-vkCmdResetEvent-stageMask-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWaitEvents(
    VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask,
    VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
    uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount,
    const VkImageMemoryBarrier* pImageMemoryBarriers, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateHandleArray(loc.dot(Field::eventCount), loc.dot(Field::pEvents), eventCount, pEvents, true, true,
                                "VUID-vkCmdWaitEvents-eventCount-arraylength");
    skip |= ValidateFlags(loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, srcStageMask,
                          kOptionalFlags, "VUID-vkCmdWaitEvents-srcStageMask-parameter");
    skip |= ValidateFlags(loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, dstStageMask,
                          kOptionalFlags, "VUID-vkCmdWaitEvents-dstStageMask-parameter");
    skip |= ValidateStructTypeArray(loc.dot(Field::memoryBarrierCount), loc.dot(Field::pMemoryBarriers),
                                    "VK_STRUCTURE_TYPE_MEMORY_BARRIER", memoryBarrierCount, pMemoryBarriers,
                                    VK_STRUCTURE_TYPE_MEMORY_BARRIER, false, true, "VUID-VkMemoryBarrier-sType-sType",
                                    "VUID-vkCmdWaitEvents-pMemoryBarriers-parameter", kVUIDUndefined);
    if (pMemoryBarriers != nullptr) {
        for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < memoryBarrierCount; ++memoryBarrierIndex) {
            [[maybe_unused]] const Location pMemoryBarriers_loc = loc.dot(Field::pMemoryBarriers, memoryBarrierIndex);
            skip |=
                ValidateStructPnext(pMemoryBarriers_loc, pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr,
                                    GeneratedVulkanHeaderVersion, "VUID-VkMemoryBarrier-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                  pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                  "VUID-VkMemoryBarrier-srcAccessMask-parameter");

            skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                  pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                  "VUID-VkMemoryBarrier-dstAccessMask-parameter");
        }
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::bufferMemoryBarrierCount), loc.dot(Field::pBufferMemoryBarriers),
                                    "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                    VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER, false, true, "VUID-VkBufferMemoryBarrier-sType-sType",
                                    "VUID-vkCmdWaitEvents-pBufferMemoryBarriers-parameter", kVUIDUndefined);
    if (pBufferMemoryBarriers != nullptr) {
        for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < bufferMemoryBarrierCount;
             ++bufferMemoryBarrierIndex) {
            [[maybe_unused]] const Location pBufferMemoryBarriers_loc =
                loc.dot(Field::pBufferMemoryBarriers, bufferMemoryBarrierIndex);
            constexpr std::array allowed_structs_VkBufferMemoryBarrier = {VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT};

            skip |= ValidateStructPnext(pBufferMemoryBarriers_loc, pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext,
                                        allowed_structs_VkBufferMemoryBarrier.size(), allowed_structs_VkBufferMemoryBarrier.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier-pNext-pNext",
                                        "VUID-VkBufferMemoryBarrier-sType-unique", false, true);

            skip |= ValidateRequiredHandle(pBufferMemoryBarriers_loc.dot(Field::buffer),
                                           pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
        }
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::imageMemoryBarrierCount), loc.dot(Field::pImageMemoryBarriers),
                                    "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", imageMemoryBarrierCount, pImageMemoryBarriers,
                                    VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER, false, true, "VUID-VkImageMemoryBarrier-sType-sType",
                                    "VUID-vkCmdWaitEvents-pImageMemoryBarriers-parameter", kVUIDUndefined);
    if (pImageMemoryBarriers != nullptr) {
        for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < imageMemoryBarrierCount; ++imageMemoryBarrierIndex) {
            [[maybe_unused]] const Location pImageMemoryBarriers_loc =
                loc.dot(Field::pImageMemoryBarriers, imageMemoryBarrierIndex);
            constexpr std::array allowed_structs_VkImageMemoryBarrier = {VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT,
                                                                         VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT};

            skip |= ValidateStructPnext(pImageMemoryBarriers_loc, pImageMemoryBarriers[imageMemoryBarrierIndex].pNext,
                                        allowed_structs_VkImageMemoryBarrier.size(), allowed_structs_VkImageMemoryBarrier.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier-pNext-pNext",
                                        "VUID-VkImageMemoryBarrier-sType-unique", false, true);

            skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::oldLayout), "VkImageLayout",
                                       pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout,
                                       "VUID-VkImageMemoryBarrier-oldLayout-parameter");

            skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::newLayout), "VkImageLayout",
                                       pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout,
                                       "VUID-VkImageMemoryBarrier-newLayout-parameter");

            skip |= ValidateRequiredHandle(pImageMemoryBarriers_loc.dot(Field::image),
                                           pImageMemoryBarriers[imageMemoryBarrierIndex].image);

            skip |= ValidateFlags(
                pImageMemoryBarriers_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags,
                "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdPipelineBarrier(
    VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask,
    VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
    uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount,
    const VkImageMemoryBarrier* pImageMemoryBarriers, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateFlags(loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, srcStageMask,
                          kOptionalFlags, "VUID-vkCmdPipelineBarrier-srcStageMask-parameter");
    skip |= ValidateFlags(loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, dstStageMask,
                          kOptionalFlags, "VUID-vkCmdPipelineBarrier-dstStageMask-parameter");
    skip |= ValidateFlags(loc.dot(Field::dependencyFlags), "VkDependencyFlagBits", AllVkDependencyFlagBits, dependencyFlags,
                          kOptionalFlags, "VUID-vkCmdPipelineBarrier-dependencyFlags-parameter");
    skip |= ValidateStructTypeArray(loc.dot(Field::memoryBarrierCount), loc.dot(Field::pMemoryBarriers),
                                    "VK_STRUCTURE_TYPE_MEMORY_BARRIER", memoryBarrierCount, pMemoryBarriers,
                                    VK_STRUCTURE_TYPE_MEMORY_BARRIER, false, true, "VUID-VkMemoryBarrier-sType-sType",
                                    "VUID-vkCmdPipelineBarrier-pMemoryBarriers-parameter", kVUIDUndefined);
    if (pMemoryBarriers != nullptr) {
        for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < memoryBarrierCount; ++memoryBarrierIndex) {
            [[maybe_unused]] const Location pMemoryBarriers_loc = loc.dot(Field::pMemoryBarriers, memoryBarrierIndex);
            skip |=
                ValidateStructPnext(pMemoryBarriers_loc, pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr,
                                    GeneratedVulkanHeaderVersion, "VUID-VkMemoryBarrier-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                  pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                  "VUID-VkMemoryBarrier-srcAccessMask-parameter");

            skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                  pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                  "VUID-VkMemoryBarrier-dstAccessMask-parameter");
        }
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::bufferMemoryBarrierCount), loc.dot(Field::pBufferMemoryBarriers),
                                    "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                    VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER, false, true, "VUID-VkBufferMemoryBarrier-sType-sType",
                                    "VUID-vkCmdPipelineBarrier-pBufferMemoryBarriers-parameter", kVUIDUndefined);
    if (pBufferMemoryBarriers != nullptr) {
        for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < bufferMemoryBarrierCount;
             ++bufferMemoryBarrierIndex) {
            [[maybe_unused]] const Location pBufferMemoryBarriers_loc =
                loc.dot(Field::pBufferMemoryBarriers, bufferMemoryBarrierIndex);
            constexpr std::array allowed_structs_VkBufferMemoryBarrier = {VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT};

            skip |= ValidateStructPnext(pBufferMemoryBarriers_loc, pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext,
                                        allowed_structs_VkBufferMemoryBarrier.size(), allowed_structs_VkBufferMemoryBarrier.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier-pNext-pNext",
                                        "VUID-VkBufferMemoryBarrier-sType-unique", false, true);

            skip |= ValidateRequiredHandle(pBufferMemoryBarriers_loc.dot(Field::buffer),
                                           pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
        }
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::imageMemoryBarrierCount), loc.dot(Field::pImageMemoryBarriers),
                                    "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", imageMemoryBarrierCount, pImageMemoryBarriers,
                                    VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER, false, true, "VUID-VkImageMemoryBarrier-sType-sType",
                                    "VUID-vkCmdPipelineBarrier-pImageMemoryBarriers-parameter", kVUIDUndefined);
    if (pImageMemoryBarriers != nullptr) {
        for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < imageMemoryBarrierCount; ++imageMemoryBarrierIndex) {
            [[maybe_unused]] const Location pImageMemoryBarriers_loc =
                loc.dot(Field::pImageMemoryBarriers, imageMemoryBarrierIndex);
            constexpr std::array allowed_structs_VkImageMemoryBarrier = {VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT,
                                                                         VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT};

            skip |= ValidateStructPnext(pImageMemoryBarriers_loc, pImageMemoryBarriers[imageMemoryBarrierIndex].pNext,
                                        allowed_structs_VkImageMemoryBarrier.size(), allowed_structs_VkImageMemoryBarrier.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier-pNext-pNext",
                                        "VUID-VkImageMemoryBarrier-sType-unique", false, true);

            skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::oldLayout), "VkImageLayout",
                                       pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout,
                                       "VUID-VkImageMemoryBarrier-oldLayout-parameter");

            skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::newLayout), "VkImageLayout",
                                       pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout,
                                       "VUID-VkImageMemoryBarrier-newLayout-parameter");

            skip |= ValidateRequiredHandle(pImageMemoryBarriers_loc.dot(Field::image),
                                           pImageMemoryBarriers[imageMemoryBarrierIndex].image);

            skip |= ValidateFlags(
                pImageMemoryBarriers_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags,
                "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                                       VkQueryControlFlags flags, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    skip |= ValidateFlags(loc.dot(Field::flags), "VkQueryControlFlagBits", AllVkQueryControlFlagBits, flags, kOptionalFlags,
                          "VUID-vkCmdBeginQuery-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool,
                                                           uint32_t firstQuery, uint32_t queryCount,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage,
                                                           VkQueryPool queryPool, uint32_t query,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateFlags(loc.dot(Field::pipelineStage), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pipelineStage,
                          kRequiredSingleBit, "VUID-vkCmdWriteTimestamp-pipelineStage-parameter",
                          "VUID-vkCmdWriteTimestamp-pipelineStage-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool,
                                                                 uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer,
                                                                 VkDeviceSize dstOffset, VkDeviceSize stride,
                                                                 VkQueryResultFlags flags, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    skip |= ValidateRequiredHandle(loc.dot(Field::dstBuffer), dstBuffer);
    skip |= ValidateFlags(loc.dot(Field::flags), "VkQueryResultFlagBits", AllVkQueryResultFlagBits, flags, kOptionalFlags,
                          "VUID-vkCmdCopyQueryPoolResults-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout,
                                                          VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size,
                                                          const void* pValues, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::layout), layout);
    skip |= ValidateFlags(loc.dot(Field::stageFlags), "VkShaderStageFlagBits", AllVkShaderStageFlagBits, stageFlags, kRequiredFlags,
                          "VUID-vkCmdPushConstants-stageFlags-parameter", "VUID-vkCmdPushConstants-stageFlags-requiredbitmask");
    skip |= ValidateArray(loc.dot(Field::size), loc.dot(Field::pValues), size, &pValues, true, true,
                          "VUID-vkCmdPushConstants-size-arraylength", "VUID-vkCmdPushConstants-pValues-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginRenderPass(VkCommandBuffer commandBuffer,
                                                            const VkRenderPassBeginInfo* pRenderPassBegin,
                                                            VkSubpassContents contents, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pRenderPassBegin), "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO", pRenderPassBegin,
                               VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO, true,
                               "VUID-vkCmdBeginRenderPass-pRenderPassBegin-parameter", "VUID-VkRenderPassBeginInfo-sType-sType");
    if (pRenderPassBegin != nullptr) {
        [[maybe_unused]] const Location pRenderPassBegin_loc = loc.dot(Field::pRenderPassBegin);
        constexpr std::array allowed_structs_VkRenderPassBeginInfo = {
            VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO,
            VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM,
            VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO,
            VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT,
            VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM,
            VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM};

        skip |=
            ValidateStructPnext(pRenderPassBegin_loc, pRenderPassBegin->pNext, allowed_structs_VkRenderPassBeginInfo.size(),
                                allowed_structs_VkRenderPassBeginInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkRenderPassBeginInfo-pNext-pNext", "VUID-VkRenderPassBeginInfo-sType-unique", false, true);

        skip |= ValidateRequiredHandle(pRenderPassBegin_loc.dot(Field::renderPass), pRenderPassBegin->renderPass);

        skip |= ValidateRequiredHandle(pRenderPassBegin_loc.dot(Field::framebuffer), pRenderPassBegin->framebuffer);

        // No xml-driven validation

        // No xml-driven validation
    }
    skip |=
        ValidateRangedEnum(loc.dot(Field::contents), "VkSubpassContents", contents, "VUID-vkCmdBeginRenderPass-contents-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRangedEnum(loc.dot(Field::contents), "VkSubpassContents", contents, "VUID-vkCmdNextSubpass-contents-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndRenderPass(VkCommandBuffer commandBuffer, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount,
                                                            const VkCommandBuffer* pCommandBuffers,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateHandleArray(loc.dot(Field::commandBufferCount), loc.dot(Field::pCommandBuffers), commandBufferCount,
                                pCommandBuffers, true, true, "VUID-vkCmdExecuteCommands-commandBufferCount-arraylength");
    return skip;
}

bool StatelessValidation::PreCallValidateBindBufferMemory2(VkDevice device, uint32_t bindInfoCount,
                                                           const VkBindBufferMemoryInfo* pBindInfos,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::bindInfoCount), loc.dot(Field::pBindInfos), "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", bindInfoCount,
        pBindInfos, VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO, true, true, "VUID-VkBindBufferMemoryInfo-sType-sType",
        "VUID-vkBindBufferMemory2-pBindInfos-parameter", "VUID-vkBindBufferMemory2-bindInfoCount-arraylength");
    if (pBindInfos != nullptr) {
        for (uint32_t bindInfoIndex = 0; bindInfoIndex < bindInfoCount; ++bindInfoIndex) {
            [[maybe_unused]] const Location pBindInfos_loc = loc.dot(Field::pBindInfos, bindInfoIndex);
            constexpr std::array allowed_structs_VkBindBufferMemoryInfo = {VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO,
                                                                           VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS_KHR};

            skip |= ValidateStructPnext(
                pBindInfos_loc, pBindInfos[bindInfoIndex].pNext, allowed_structs_VkBindBufferMemoryInfo.size(),
                allowed_structs_VkBindBufferMemoryInfo.data(), GeneratedVulkanHeaderVersion,
                "VUID-VkBindBufferMemoryInfo-pNext-pNext", "VUID-VkBindBufferMemoryInfo-sType-unique", false, true);

            skip |= ValidateRequiredHandle(pBindInfos_loc.dot(Field::buffer), pBindInfos[bindInfoIndex].buffer);

            skip |= ValidateRequiredHandle(pBindInfos_loc.dot(Field::memory), pBindInfos[bindInfoIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateBindImageMemory2(VkDevice device, uint32_t bindInfoCount,
                                                          const VkBindImageMemoryInfo* pBindInfos,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::bindInfoCount), loc.dot(Field::pBindInfos), "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", bindInfoCount,
        pBindInfos, VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO, true, true, "VUID-VkBindImageMemoryInfo-sType-sType",
        "VUID-vkBindImageMemory2-pBindInfos-parameter", "VUID-vkBindImageMemory2-bindInfoCount-arraylength");
    if (pBindInfos != nullptr) {
        for (uint32_t bindInfoIndex = 0; bindInfoIndex < bindInfoCount; ++bindInfoIndex) {
            [[maybe_unused]] const Location pBindInfos_loc = loc.dot(Field::pBindInfos, bindInfoIndex);
            constexpr std::array allowed_structs_VkBindImageMemoryInfo = {
                VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO, VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR,
                VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO, VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS_KHR};

            skip |= ValidateStructPnext(pBindInfos_loc, pBindInfos[bindInfoIndex].pNext,
                                        allowed_structs_VkBindImageMemoryInfo.size(), allowed_structs_VkBindImageMemoryInfo.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkBindImageMemoryInfo-pNext-pNext",
                                        "VUID-VkBindImageMemoryInfo-sType-unique", false, true);

            skip |= ValidateRequiredHandle(pBindInfos_loc.dot(Field::image), pBindInfos[bindInfoIndex].image);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex,
                                                                          uint32_t localDeviceIndex, uint32_t remoteDeviceIndex,
                                                                          VkPeerMemoryFeatureFlags* pPeerMemoryFeatures,
                                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredPointer(loc.dot(Field::pPeerMemoryFeatures), pPeerMemoryFeatures,
                                    "VUID-vkGetDeviceGroupPeerMemoryFeatures-pPeerMemoryFeatures-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask,
                                                          const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY,
                                                         uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY,
                                                         uint32_t groupCountZ, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateEnumeratePhysicalDeviceGroups(
    VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties,
    const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkEnumeratePhysicalDeviceGroups &&
        CheckPromotedApiAgainstVulkanVersion(instance, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::pPhysicalDeviceGroupCount), loc.dot(Field::pPhysicalDeviceGroupProperties),
        "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES", pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
        VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES, true, false, false, "VUID-VkPhysicalDeviceGroupProperties-sType-sType",
        "VUID-vkEnumeratePhysicalDeviceGroups-pPhysicalDeviceGroupProperties-parameter", kVUIDUndefined);
    if (pPhysicalDeviceGroupProperties != nullptr) {
        for (uint32_t pPhysicalDeviceGroupIndex = 0; pPhysicalDeviceGroupIndex < *pPhysicalDeviceGroupCount;
             ++pPhysicalDeviceGroupIndex) {
            [[maybe_unused]] const Location pPhysicalDeviceGroupProperties_loc =
                loc.dot(Field::pPhysicalDeviceGroupProperties, pPhysicalDeviceGroupIndex);
            skip |= ValidateStructPnext(
                pPhysicalDeviceGroupProperties_loc, pPhysicalDeviceGroupProperties[pPhysicalDeviceGroupIndex].pNext, 0, nullptr,
                GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceGroupProperties-pNext-pNext", kVUIDUndefined, false, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo,
                                                                     VkMemoryRequirements2* pMemoryRequirements,
                                                                     const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateStructType(loc.dot(Field::pInfo), "VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2", pInfo,
                           VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2, true,
                           "VUID-vkGetImageMemoryRequirements2-pInfo-parameter", "VUID-VkImageMemoryRequirementsInfo2-sType-sType");
    if (pInfo != nullptr) {
        [[maybe_unused]] const Location pInfo_loc = loc.dot(Field::pInfo);
        constexpr std::array allowed_structs_VkImageMemoryRequirementsInfo2 = {
            VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO};

        skip |= ValidateStructPnext(pInfo_loc, pInfo->pNext, allowed_structs_VkImageMemoryRequirementsInfo2.size(),
                                    allowed_structs_VkImageMemoryRequirementsInfo2.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkImageMemoryRequirementsInfo2-pNext-pNext",
                                    "VUID-VkImageMemoryRequirementsInfo2-sType-unique", false, true);

        skip |= ValidateRequiredHandle(pInfo_loc.dot(Field::image), pInfo->image);
    }
    skip |= ValidateStructType(loc.dot(Field::pMemoryRequirements), "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", pMemoryRequirements,
                               VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, true,
                               "VUID-vkGetImageMemoryRequirements2-pMemoryRequirements-parameter",
                               "VUID-VkMemoryRequirements2-sType-sType");
    if (pMemoryRequirements != nullptr) {
        [[maybe_unused]] const Location pMemoryRequirements_loc = loc.dot(Field::pMemoryRequirements);
        constexpr std::array allowed_structs_VkMemoryRequirements2 = {VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS};

        skip |=
            ValidateStructPnext(pMemoryRequirements_loc, pMemoryRequirements->pNext, allowed_structs_VkMemoryRequirements2.size(),
                                allowed_structs_VkMemoryRequirements2.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkMemoryRequirements2-pNext-pNext", "VUID-VkMemoryRequirements2-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo,
                                                                      VkMemoryRequirements2* pMemoryRequirements,
                                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pInfo), "VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", pInfo,
                               VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2, true,
                               "VUID-vkGetBufferMemoryRequirements2-pInfo-parameter",
                               "VUID-VkBufferMemoryRequirementsInfo2-sType-sType");
    if (pInfo != nullptr) {
        [[maybe_unused]] const Location pInfo_loc = loc.dot(Field::pInfo);
        skip |= ValidateStructPnext(pInfo_loc, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pInfo_loc.dot(Field::buffer), pInfo->buffer);
    }
    skip |= ValidateStructType(loc.dot(Field::pMemoryRequirements), "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", pMemoryRequirements,
                               VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, true,
                               "VUID-vkGetBufferMemoryRequirements2-pMemoryRequirements-parameter",
                               "VUID-VkMemoryRequirements2-sType-sType");
    if (pMemoryRequirements != nullptr) {
        [[maybe_unused]] const Location pMemoryRequirements_loc = loc.dot(Field::pMemoryRequirements);
        constexpr std::array allowed_structs_VkMemoryRequirements2 = {VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS};

        skip |=
            ValidateStructPnext(pMemoryRequirements_loc, pMemoryRequirements->pNext, allowed_structs_VkMemoryRequirements2.size(),
                                allowed_structs_VkMemoryRequirements2.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkMemoryRequirements2-pNext-pNext", "VUID-VkMemoryRequirements2-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageSparseMemoryRequirements2(
    VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pInfo), "VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2", pInfo,
                               VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2, true,
                               "VUID-vkGetImageSparseMemoryRequirements2-pInfo-parameter",
                               "VUID-VkImageSparseMemoryRequirementsInfo2-sType-sType");
    if (pInfo != nullptr) {
        [[maybe_unused]] const Location pInfo_loc = loc.dot(Field::pInfo);
        skip |= ValidateStructPnext(pInfo_loc, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkImageSparseMemoryRequirementsInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pInfo_loc.dot(Field::image), pInfo->image);
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::pSparseMemoryRequirementCount), loc.dot(Field::pSparseMemoryRequirements),
                                    "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2", pSparseMemoryRequirementCount,
                                    pSparseMemoryRequirements, VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2, true, false,
                                    false, "VUID-VkSparseImageMemoryRequirements2-sType-sType",
                                    "VUID-vkGetImageSparseMemoryRequirements2-pSparseMemoryRequirements-parameter", kVUIDUndefined);
    if (pSparseMemoryRequirements != nullptr) {
        for (uint32_t pSparseMemoryRequirementIndex = 0; pSparseMemoryRequirementIndex < *pSparseMemoryRequirementCount;
             ++pSparseMemoryRequirementIndex) {
            [[maybe_unused]] const Location pSparseMemoryRequirements_loc =
                loc.dot(Field::pSparseMemoryRequirements, pSparseMemoryRequirementIndex);
            skip |= ValidateStructPnext(
                pSparseMemoryRequirements_loc, pSparseMemoryRequirements[pSparseMemoryRequirementIndex].pNext, 0, nullptr,
                GeneratedVulkanHeaderVersion, "VUID-VkSparseImageMemoryRequirements2-pNext-pNext", kVUIDUndefined, false, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice,
                                                                    VkPhysicalDeviceFeatures2* pFeatures,
                                                                    const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceFeatures2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |=
        ValidateStructType(loc.dot(Field::pFeatures), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2", pFeatures,
                           VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2, true,
                           "VUID-vkGetPhysicalDeviceFeatures2-pFeatures-parameter", "VUID-VkPhysicalDeviceFeatures2-sType-sType");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice,
                                                                      VkPhysicalDeviceProperties2* pProperties,
                                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceProperties2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pProperties), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2", pProperties,
                               VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2, true,
                               "VUID-vkGetPhysicalDeviceProperties2-pProperties-parameter",
                               "VUID-VkPhysicalDeviceProperties2-sType-sType");
    if (pProperties != nullptr) {
        [[maybe_unused]] const Location pProperties_loc = loc.dot(Field::pProperties);
        constexpr std::array allowed_structs_VkPhysicalDeviceProperties2 = {
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_KHR,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES};

        skip |= ValidateStructPnext(pProperties_loc, pProperties->pNext, allowed_structs_VkPhysicalDeviceProperties2.size(),
                                    allowed_structs_VkPhysicalDeviceProperties2.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkPhysicalDeviceProperties2-pNext-pNext", "VUID-VkPhysicalDeviceProperties2-sType-unique",
                                    true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                            VkFormatProperties2* pFormatProperties,
                                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceFormatProperties2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateRangedEnum(loc.dot(Field::format), "VkFormat", format,
                               "VUID-vkGetPhysicalDeviceFormatProperties2-format-parameter");
    skip |= ValidateStructType(loc.dot(Field::pFormatProperties), "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", pFormatProperties,
                               VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2, true,
                               "VUID-vkGetPhysicalDeviceFormatProperties2-pFormatProperties-parameter",
                               "VUID-VkFormatProperties2-sType-sType");
    if (pFormatProperties != nullptr) {
        [[maybe_unused]] const Location pFormatProperties_loc = loc.dot(Field::pFormatProperties);
        constexpr std::array allowed_structs_VkFormatProperties2 = {
            VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT, VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT,
            VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3, VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT};

        skip |= ValidateStructPnext(pFormatProperties_loc, pFormatProperties->pNext, allowed_structs_VkFormatProperties2.size(),
                                    allowed_structs_VkFormatProperties2.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkFormatProperties2-pNext-pNext", "VUID-VkFormatProperties2-sType-unique", true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceImageFormatProperties2(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
    VkImageFormatProperties2* pImageFormatProperties, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceImageFormatProperties2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pImageFormatInfo), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2",
                               pImageFormatInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2, true,
                               "VUID-vkGetPhysicalDeviceImageFormatProperties2-pImageFormatInfo-parameter",
                               "VUID-VkPhysicalDeviceImageFormatInfo2-sType-sType");
    if (pImageFormatInfo != nullptr) {
        [[maybe_unused]] const Location pImageFormatInfo_loc = loc.dot(Field::pImageFormatInfo);
        constexpr std::array allowed_structs_VkPhysicalDeviceImageFormatInfo2 = {
            VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT,
            VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO,
            VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO,
            VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT,
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT,
            VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR};

        skip |= ValidateStructPnext(
            pImageFormatInfo_loc, pImageFormatInfo->pNext, allowed_structs_VkPhysicalDeviceImageFormatInfo2.size(),
            allowed_structs_VkPhysicalDeviceImageFormatInfo2.data(), GeneratedVulkanHeaderVersion,
            "VUID-VkPhysicalDeviceImageFormatInfo2-pNext-pNext", "VUID-VkPhysicalDeviceImageFormatInfo2-sType-unique", true, true);

        skip |= ValidateRangedEnum(pImageFormatInfo_loc.dot(Field::format), "VkFormat", pImageFormatInfo->format,
                                   "VUID-VkPhysicalDeviceImageFormatInfo2-format-parameter");

        skip |= ValidateRangedEnum(pImageFormatInfo_loc.dot(Field::type), "VkImageType", pImageFormatInfo->type,
                                   "VUID-VkPhysicalDeviceImageFormatInfo2-type-parameter");

        skip |= ValidateRangedEnum(pImageFormatInfo_loc.dot(Field::tiling), "VkImageTiling", pImageFormatInfo->tiling,
                                   "VUID-VkPhysicalDeviceImageFormatInfo2-tiling-parameter");

        skip |= ValidateFlags(pImageFormatInfo_loc.dot(Field::usage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits,
                              pImageFormatInfo->usage, kRequiredFlags, "VUID-VkPhysicalDeviceImageFormatInfo2-usage-parameter",
                              "VUID-VkPhysicalDeviceImageFormatInfo2-usage-requiredbitmask");

        skip |= ValidateFlags(pImageFormatInfo_loc.dot(Field::flags), "VkImageCreateFlagBits", AllVkImageCreateFlagBits,
                              pImageFormatInfo->flags, kOptionalFlags, "VUID-VkPhysicalDeviceImageFormatInfo2-flags-parameter");
    }
    skip |= ValidateStructType(loc.dot(Field::pImageFormatProperties), "VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2",
                               pImageFormatProperties, VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2, true,
                               "VUID-vkGetPhysicalDeviceImageFormatProperties2-pImageFormatProperties-parameter",
                               "VUID-VkImageFormatProperties2-sType-sType");
    if (pImageFormatProperties != nullptr) {
        [[maybe_unused]] const Location pImageFormatProperties_loc = loc.dot(Field::pImageFormatProperties);
        constexpr std::array allowed_structs_VkImageFormatProperties2 = {
            VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID,
            VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES,
            VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY_EXT,
            VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT,
            VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES,
            VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD};

        skip |= ValidateStructPnext(
            pImageFormatProperties_loc, pImageFormatProperties->pNext, allowed_structs_VkImageFormatProperties2.size(),
            allowed_structs_VkImageFormatProperties2.data(), GeneratedVulkanHeaderVersion,
            "VUID-VkImageFormatProperties2-pNext-pNext", "VUID-VkImageFormatProperties2-sType-unique", true, false);
    }
    if (!skip)
        skip |= manual_PreCallValidateGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo,
                                                                              pImageFormatProperties, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice,
                                                                                 uint32_t* pQueueFamilyPropertyCount,
                                                                                 VkQueueFamilyProperties2* pQueueFamilyProperties,
                                                                                 const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructTypeArray(
        loc.dot(Field::pQueueFamilyPropertyCount), loc.dot(Field::pQueueFamilyProperties),
        "VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2", pQueueFamilyPropertyCount, pQueueFamilyProperties,
        VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2, true, false, false, "VUID-VkQueueFamilyProperties2-sType-sType",
        "VUID-vkGetPhysicalDeviceQueueFamilyProperties2-pQueueFamilyProperties-parameter", kVUIDUndefined);
    if (pQueueFamilyProperties != nullptr) {
        for (uint32_t pQueueFamilyPropertyIndex = 0; pQueueFamilyPropertyIndex < *pQueueFamilyPropertyCount;
             ++pQueueFamilyPropertyIndex) {
            [[maybe_unused]] const Location pQueueFamilyProperties_loc =
                loc.dot(Field::pQueueFamilyProperties, pQueueFamilyPropertyIndex);
            constexpr std::array allowed_structs_VkQueueFamilyProperties2 = {
                VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV, VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV,
                VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR,
                VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR,
                VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR};

            skip |= ValidateStructPnext(pQueueFamilyProperties_loc, pQueueFamilyProperties[pQueueFamilyPropertyIndex].pNext,
                                        allowed_structs_VkQueueFamilyProperties2.size(),
                                        allowed_structs_VkQueueFamilyProperties2.data(), GeneratedVulkanHeaderVersion,
                                        "VUID-VkQueueFamilyProperties2-pNext-pNext", "VUID-VkQueueFamilyProperties2-sType-unique",
                                        true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice,
                                                                            VkPhysicalDeviceMemoryProperties2* pMemoryProperties,
                                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceMemoryProperties2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pMemoryProperties), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2",
                               pMemoryProperties, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2, true,
                               "VUID-vkGetPhysicalDeviceMemoryProperties2-pMemoryProperties-parameter",
                               "VUID-VkPhysicalDeviceMemoryProperties2-sType-sType");
    if (pMemoryProperties != nullptr) {
        [[maybe_unused]] const Location pMemoryProperties_loc = loc.dot(Field::pMemoryProperties);
        constexpr std::array allowed_structs_VkPhysicalDeviceMemoryProperties2 = {
            VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT};

        skip |= ValidateStructPnext(pMemoryProperties_loc, pMemoryProperties->pNext,
                                    allowed_structs_VkPhysicalDeviceMemoryProperties2.size(),
                                    allowed_structs_VkPhysicalDeviceMemoryProperties2.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkPhysicalDeviceMemoryProperties2-pNext-pNext",
                                    "VUID-VkPhysicalDeviceMemoryProperties2-sType-unique", true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSparseImageFormatProperties2(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount,
    VkSparseImageFormatProperties2* pProperties, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2 &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pFormatInfo), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2",
                               pFormatInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2, true,
                               "VUID-vkGetPhysicalDeviceSparseImageFormatProperties2-pFormatInfo-parameter",
                               "VUID-VkPhysicalDeviceSparseImageFormatInfo2-sType-sType");
    if (pFormatInfo != nullptr) {
        [[maybe_unused]] const Location pFormatInfo_loc = loc.dot(Field::pFormatInfo);
        skip |= ValidateStructPnext(pFormatInfo_loc, pFormatInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkPhysicalDeviceSparseImageFormatInfo2-pNext-pNext", kVUIDUndefined, true, true);

        skip |= ValidateRangedEnum(pFormatInfo_loc.dot(Field::format), "VkFormat", pFormatInfo->format,
                                   "VUID-VkPhysicalDeviceSparseImageFormatInfo2-format-parameter");

        skip |= ValidateRangedEnum(pFormatInfo_loc.dot(Field::type), "VkImageType", pFormatInfo->type,
                                   "VUID-VkPhysicalDeviceSparseImageFormatInfo2-type-parameter");

        skip |=
            ValidateFlags(pFormatInfo_loc.dot(Field::samples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                          pFormatInfo->samples, kRequiredSingleBit, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter",
                          "VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter");

        skip |= ValidateFlags(pFormatInfo_loc.dot(Field::usage), "VkImageUsageFlagBits", AllVkImageUsageFlagBits,
                              pFormatInfo->usage, kRequiredFlags, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-parameter",
                              "VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-requiredbitmask");

        skip |= ValidateRangedEnum(pFormatInfo_loc.dot(Field::tiling), "VkImageTiling", pFormatInfo->tiling,
                                   "VUID-VkPhysicalDeviceSparseImageFormatInfo2-tiling-parameter");
    }
    skip |= ValidateStructTypeArray(loc.dot(Field::pPropertyCount), loc.dot(Field::pProperties),
                                    "VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2", pPropertyCount, pProperties,
                                    VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2, true, false, false,
                                    "VUID-VkSparseImageFormatProperties2-sType-sType",
                                    "VUID-vkGetPhysicalDeviceSparseImageFormatProperties2-pProperties-parameter", kVUIDUndefined);
    if (pProperties != nullptr) {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex) {
            [[maybe_unused]] const Location pProperties_loc = loc.dot(Field::pProperties, pPropertyIndex);
            skip |=
                ValidateStructPnext(pProperties_loc, pProperties[pPropertyIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkSparseImageFormatProperties2-pNext-pNext", kVUIDUndefined, true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateTrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::commandPool), commandPool);
    skip |= ValidateReservedFlags(loc.dot(Field::flags), flags, "VUID-vkTrimCommandPool-flags-zerobitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pQueueInfo), "VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", pQueueInfo,
                               VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2, true, "VUID-vkGetDeviceQueue2-pQueueInfo-parameter",
                               "VUID-VkDeviceQueueInfo2-sType-sType");
    if (pQueueInfo != nullptr) {
        [[maybe_unused]] const Location pQueueInfo_loc = loc.dot(Field::pQueueInfo);
        skip |= ValidateStructPnext(pQueueInfo_loc, pQueueInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkDeviceQueueInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags(pQueueInfo_loc.dot(Field::flags), "VkDeviceQueueCreateFlagBits", AllVkDeviceQueueCreateFlagBits,
                              pQueueInfo->flags, kOptionalFlags, "VUID-VkDeviceQueueInfo2-flags-parameter");
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pQueue), pQueue, "VUID-vkGetDeviceQueue2-pQueue-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCreateSamplerYcbcrConversion(VkDevice device,
                                                                      const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                                                      const VkAllocationCallbacks* pAllocator,
                                                                      VkSamplerYcbcrConversion* pYcbcrConversion,
                                                                      const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO, true,
                               "VUID-vkCreateSamplerYcbcrConversion-pCreateInfo-parameter",
                               "VUID-VkSamplerYcbcrConversionCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkSamplerYcbcrConversionCreateInfo = {
            VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID, VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX,
            VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkSamplerYcbcrConversionCreateInfo.size(),
                                    allowed_structs_VkSamplerYcbcrConversionCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkSamplerYcbcrConversionCreateInfo-pNext-pNext",
                                    "VUID-VkSamplerYcbcrConversionCreateInfo-sType-unique", false, true);

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::format), "VkFormat", pCreateInfo->format,
                                   "VUID-VkSamplerYcbcrConversionCreateInfo-format-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::ycbcrModel), "VkSamplerYcbcrModelConversion", pCreateInfo->ycbcrModel,
                                   "VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::ycbcrRange), "VkSamplerYcbcrRange", pCreateInfo->ycbcrRange,
                                   "VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::r), "VkComponentSwizzle", pCreateInfo->components.r,
                                   "VUID-VkComponentMapping-r-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::g), "VkComponentSwizzle", pCreateInfo->components.g,
                                   "VUID-VkComponentMapping-g-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::b), "VkComponentSwizzle", pCreateInfo->components.b,
                                   "VUID-VkComponentMapping-b-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::a), "VkComponentSwizzle", pCreateInfo->components.a,
                                   "VUID-VkComponentMapping-a-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::xChromaOffset), "VkChromaLocation", pCreateInfo->xChromaOffset,
                                   "VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::yChromaOffset), "VkChromaLocation", pCreateInfo->yChromaOffset,
                                   "VUID-VkSamplerYcbcrConversionCreateInfo-yChromaOffset-parameter");

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::chromaFilter), "VkFilter", pCreateInfo->chromaFilter,
                                   "VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-parameter");

        skip |= ValidateBool32(pCreateInfo_loc.dot(Field::forceExplicitReconstruction), pCreateInfo->forceExplicitReconstruction);
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pYcbcrConversion), pYcbcrConversion,
                                    "VUID-vkCreateSamplerYcbcrConversion-pYcbcrConversion-parameter");
    if (!skip)
        skip |= manual_PreCallValidateCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
                                                                       const VkAllocationCallbacks* pAllocator,
                                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDescriptorUpdateTemplate(VkDevice device,
                                                                        const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
                                                                        const VkAllocationCallbacks* pAllocator,
                                                                        VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate,
                                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO, true,
                               "VUID-vkCreateDescriptorUpdateTemplate-pCreateInfo-parameter",
                               "VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::descriptorUpdateEntryCount),
                              pCreateInfo_loc.dot(Field::pDescriptorUpdateEntries), pCreateInfo->descriptorUpdateEntryCount,
                              &pCreateInfo->pDescriptorUpdateEntries, true, true,
                              "VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength",
                              "VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter");

        if (pCreateInfo->pDescriptorUpdateEntries != nullptr) {
            for (uint32_t descriptorUpdateEntryIndex = 0; descriptorUpdateEntryIndex < pCreateInfo->descriptorUpdateEntryCount;
                 ++descriptorUpdateEntryIndex) {
                [[maybe_unused]] const Location pDescriptorUpdateEntries_loc =
                    pCreateInfo_loc.dot(Field::pDescriptorUpdateEntries, descriptorUpdateEntryIndex);
                skip |= ValidateRangedEnum(pDescriptorUpdateEntries_loc.dot(Field::descriptorType), "VkDescriptorType",
                                           pCreateInfo->pDescriptorUpdateEntries[descriptorUpdateEntryIndex].descriptorType,
                                           "VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter");
            }
        }

        skip |= ValidateRangedEnum(pCreateInfo_loc.dot(Field::templateType), "VkDescriptorUpdateTemplateType",
                                   pCreateInfo->templateType, "VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pDescriptorUpdateTemplate), pDescriptorUpdateTemplate,
                                    "VUID-vkCreateDescriptorUpdateTemplate-pDescriptorUpdateTemplate-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDescriptorUpdateTemplate(VkDevice device,
                                                                         VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                                         const VkAllocationCallbacks* pAllocator,
                                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateUpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet,
                                                                         VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                                         const void* pData, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::descriptorSet), descriptorSet);
    skip |= ValidateRequiredHandle(loc.dot(Field::descriptorUpdateTemplate), descriptorUpdateTemplate);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceExternalBufferProperties(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceExternalBufferProperties &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pExternalBufferInfo), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO",
                               pExternalBufferInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO, true,
                               "VUID-vkGetPhysicalDeviceExternalBufferProperties-pExternalBufferInfo-parameter",
                               "VUID-VkPhysicalDeviceExternalBufferInfo-sType-sType");
    if (pExternalBufferInfo != nullptr) {
        [[maybe_unused]] const Location pExternalBufferInfo_loc = loc.dot(Field::pExternalBufferInfo);
        constexpr std::array allowed_structs_VkPhysicalDeviceExternalBufferInfo = {
            VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR};

        skip |= ValidateStructPnext(pExternalBufferInfo_loc, pExternalBufferInfo->pNext,
                                    allowed_structs_VkPhysicalDeviceExternalBufferInfo.size(),
                                    allowed_structs_VkPhysicalDeviceExternalBufferInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkPhysicalDeviceExternalBufferInfo-pNext-pNext",
                                    "VUID-VkPhysicalDeviceExternalBufferInfo-sType-unique", true, true);

        skip |=
            ValidateFlags(pExternalBufferInfo_loc.dot(Field::flags), "VkBufferCreateFlagBits", AllVkBufferCreateFlagBits,
                          pExternalBufferInfo->flags, kOptionalFlags, "VUID-VkPhysicalDeviceExternalBufferInfo-flags-parameter");

        skip |= ValidateFlags(pExternalBufferInfo_loc.dot(Field::handleType), "VkExternalMemoryHandleTypeFlagBits",
                              AllVkExternalMemoryHandleTypeFlagBits, pExternalBufferInfo->handleType, kRequiredSingleBit,
                              "VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter",
                              "VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter");
    }
    skip |= ValidateStructType(loc.dot(Field::pExternalBufferProperties), "VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES",
                               pExternalBufferProperties, VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES, true,
                               "VUID-vkGetPhysicalDeviceExternalBufferProperties-pExternalBufferProperties-parameter",
                               "VUID-VkExternalBufferProperties-sType-sType");
    if (pExternalBufferProperties != nullptr) {
        [[maybe_unused]] const Location pExternalBufferProperties_loc = loc.dot(Field::pExternalBufferProperties);
        skip |= ValidateStructPnext(pExternalBufferProperties_loc, pExternalBufferProperties->pNext, 0, nullptr,
                                    GeneratedVulkanHeaderVersion, "VUID-VkExternalBufferProperties-pNext-pNext", kVUIDUndefined,
                                    true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceExternalFenceProperties(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
    VkExternalFenceProperties* pExternalFenceProperties, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceExternalFenceProperties &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pExternalFenceInfo), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO",
                               pExternalFenceInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO, true,
                               "VUID-vkGetPhysicalDeviceExternalFenceProperties-pExternalFenceInfo-parameter",
                               "VUID-VkPhysicalDeviceExternalFenceInfo-sType-sType");
    if (pExternalFenceInfo != nullptr) {
        [[maybe_unused]] const Location pExternalFenceInfo_loc = loc.dot(Field::pExternalFenceInfo);
        skip |= ValidateStructPnext(pExternalFenceInfo_loc, pExternalFenceInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkPhysicalDeviceExternalFenceInfo-pNext-pNext", kVUIDUndefined, true, true);

        skip |= ValidateFlags(pExternalFenceInfo_loc.dot(Field::handleType), "VkExternalFenceHandleTypeFlagBits",
                              AllVkExternalFenceHandleTypeFlagBits, pExternalFenceInfo->handleType, kRequiredSingleBit,
                              "VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter",
                              "VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter");
    }
    skip |= ValidateStructType(loc.dot(Field::pExternalFenceProperties), "VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES",
                               pExternalFenceProperties, VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES, true,
                               "VUID-vkGetPhysicalDeviceExternalFenceProperties-pExternalFenceProperties-parameter",
                               "VUID-VkExternalFenceProperties-sType-sType");
    if (pExternalFenceProperties != nullptr) {
        [[maybe_unused]] const Location pExternalFenceProperties_loc = loc.dot(Field::pExternalFenceProperties);
        skip |= ValidateStructPnext(pExternalFenceProperties_loc, pExternalFenceProperties->pNext, 0, nullptr,
                                    GeneratedVulkanHeaderVersion, "VUID-VkExternalFenceProperties-pNext-pNext", kVUIDUndefined,
                                    true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceExternalSemaphoreProperties(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceExternalSemaphoreProperties &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_1))
        return true;
    skip |= ValidateStructType(loc.dot(Field::pExternalSemaphoreInfo), "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO",
                               pExternalSemaphoreInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO, true,
                               "VUID-vkGetPhysicalDeviceExternalSemaphoreProperties-pExternalSemaphoreInfo-parameter",
                               "VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-sType");
    if (pExternalSemaphoreInfo != nullptr) {
        [[maybe_unused]] const Location pExternalSemaphoreInfo_loc = loc.dot(Field::pExternalSemaphoreInfo);
        constexpr std::array allowed_structs_VkPhysicalDeviceExternalSemaphoreInfo = {VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO};

        skip |= ValidateStructPnext(pExternalSemaphoreInfo_loc, pExternalSemaphoreInfo->pNext,
                                    allowed_structs_VkPhysicalDeviceExternalSemaphoreInfo.size(),
                                    allowed_structs_VkPhysicalDeviceExternalSemaphoreInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkPhysicalDeviceExternalSemaphoreInfo-pNext-pNext",
                                    "VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-unique", true, true);

        skip |= ValidateFlags(pExternalSemaphoreInfo_loc.dot(Field::handleType), "VkExternalSemaphoreHandleTypeFlagBits",
                              AllVkExternalSemaphoreHandleTypeFlagBits, pExternalSemaphoreInfo->handleType, kRequiredSingleBit,
                              "VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter",
                              "VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter");
    }
    skip |= ValidateStructType(loc.dot(Field::pExternalSemaphoreProperties), "VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES",
                               pExternalSemaphoreProperties, VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES, true,
                               "VUID-vkGetPhysicalDeviceExternalSemaphoreProperties-pExternalSemaphoreProperties-parameter",
                               "VUID-VkExternalSemaphoreProperties-sType-sType");
    if (pExternalSemaphoreProperties != nullptr) {
        [[maybe_unused]] const Location pExternalSemaphoreProperties_loc = loc.dot(Field::pExternalSemaphoreProperties);
        skip |= ValidateStructPnext(pExternalSemaphoreProperties_loc, pExternalSemaphoreProperties->pNext, 0, nullptr,
                                    GeneratedVulkanHeaderVersion, "VUID-VkExternalSemaphoreProperties-pNext-pNext", kVUIDUndefined,
                                    true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDescriptorSetLayoutSupport(VkDevice device,
                                                                       const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                                       VkDescriptorSetLayoutSupport* pSupport,
                                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", pCreateInfo,
                               VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO, true,
                               "VUID-vkGetDescriptorSetLayoutSupport-pCreateInfo-parameter",
                               "VUID-VkDescriptorSetLayoutCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkDescriptorSetLayoutCreateInfo = {
            VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO,
            VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkDescriptorSetLayoutCreateInfo.size(),
                                    allowed_structs_VkDescriptorSetLayoutCreateInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext",
                                    "VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkDescriptorSetLayoutCreateFlagBits",
                              AllVkDescriptorSetLayoutCreateFlagBits, pCreateInfo->flags, kOptionalFlags,
                              "VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter");

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::bindingCount), pCreateInfo_loc.dot(Field::pBindings),
                              pCreateInfo->bindingCount, &pCreateInfo->pBindings, false, true, kVUIDUndefined,
                              "VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter");

        if (pCreateInfo->pBindings != nullptr) {
            for (uint32_t bindingIndex = 0; bindingIndex < pCreateInfo->bindingCount; ++bindingIndex) {
                [[maybe_unused]] const Location pBindings_loc = pCreateInfo_loc.dot(Field::pBindings, bindingIndex);
                skip |= ValidateRangedEnum(pBindings_loc.dot(Field::descriptorType), "VkDescriptorType",
                                           pCreateInfo->pBindings[bindingIndex].descriptorType,
                                           "VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter");
            }
        }
    }
    skip |= ValidateStructType(loc.dot(Field::pSupport), "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", pSupport,
                               VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT, true,
                               "VUID-vkGetDescriptorSetLayoutSupport-pSupport-parameter",
                               "VUID-VkDescriptorSetLayoutSupport-sType-sType");
    if (pSupport != nullptr) {
        [[maybe_unused]] const Location pSupport_loc = loc.dot(Field::pSupport);
        constexpr std::array allowed_structs_VkDescriptorSetLayoutSupport = {
            VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT};

        skip |= ValidateStructPnext(pSupport_loc, pSupport->pNext, allowed_structs_VkDescriptorSetLayoutSupport.size(),
                                    allowed_structs_VkDescriptorSetLayoutSupport.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkDescriptorSetLayoutSupport-pNext-pNext",
                                    "VUID-VkDescriptorSetLayoutSupport-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                              VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                              uint32_t maxDrawCount, uint32_t stride,
                                                              const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    skip |= ValidateRequiredHandle(loc.dot(Field::countBuffer), countBuffer);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer,
                                                                     VkDeviceSize offset, VkBuffer countBuffer,
                                                                     VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                                     uint32_t stride, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::buffer), buffer);
    skip |= ValidateRequiredHandle(loc.dot(Field::countBuffer), countBuffer);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
                                                           const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2", pCreateInfo,
                               VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2, true, "VUID-vkCreateRenderPass2-pCreateInfo-parameter",
                               "VUID-VkRenderPassCreateInfo2-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        constexpr std::array allowed_structs_VkRenderPassCreateInfo2 = {
            VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT,
            VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT};

        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, allowed_structs_VkRenderPassCreateInfo2.size(),
                                    allowed_structs_VkRenderPassCreateInfo2.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkRenderPassCreateInfo2-pNext-pNext", "VUID-VkRenderPassCreateInfo2-sType-unique", false,
                                    true);

        skip |= ValidateFlags(pCreateInfo_loc.dot(Field::flags), "VkRenderPassCreateFlagBits", AllVkRenderPassCreateFlagBits,
                              pCreateInfo->flags, kOptionalFlags, "VUID-VkRenderPassCreateInfo2-flags-parameter");

        skip |= ValidateStructTypeArray(pCreateInfo_loc.dot(Field::attachmentCount), pCreateInfo_loc.dot(Field::pAttachments),
                                        "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", pCreateInfo->attachmentCount,
                                        pCreateInfo->pAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2, false, true,
                                        "VUID-VkAttachmentDescription2-sType-sType",
                                        "VUID-VkRenderPassCreateInfo2-pAttachments-parameter", kVUIDUndefined);

        if (pCreateInfo->pAttachments != nullptr) {
            for (uint32_t attachmentIndex = 0; attachmentIndex < pCreateInfo->attachmentCount; ++attachmentIndex) {
                [[maybe_unused]] const Location pAttachments_loc = pCreateInfo_loc.dot(Field::pAttachments, attachmentIndex);
                constexpr std::array allowed_structs_VkAttachmentDescription2 = {
                    VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT, VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID};

                skip |= ValidateStructPnext(pAttachments_loc, pCreateInfo->pAttachments[attachmentIndex].pNext,
                                            allowed_structs_VkAttachmentDescription2.size(),
                                            allowed_structs_VkAttachmentDescription2.data(), GeneratedVulkanHeaderVersion,
                                            "VUID-VkAttachmentDescription2-pNext-pNext",
                                            "VUID-VkAttachmentDescription2-sType-unique", false, true);

                skip |= ValidateFlags(pAttachments_loc.dot(Field::flags), "VkAttachmentDescriptionFlagBits",
                                      AllVkAttachmentDescriptionFlagBits, pCreateInfo->pAttachments[attachmentIndex].flags,
                                      kOptionalFlags, "VUID-VkAttachmentDescription2-flags-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::format), "VkFormat",
                                           pCreateInfo->pAttachments[attachmentIndex].format,
                                           "VUID-VkAttachmentDescription2-format-parameter");

                skip |= ValidateFlags(pAttachments_loc.dot(Field::samples), "VkSampleCountFlagBits", AllVkSampleCountFlagBits,
                                      pCreateInfo->pAttachments[attachmentIndex].samples, kRequiredSingleBit,
                                      "VUID-VkAttachmentDescription2-samples-parameter",
                                      "VUID-VkAttachmentDescription2-samples-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::loadOp), "VkAttachmentLoadOp",
                                           pCreateInfo->pAttachments[attachmentIndex].loadOp,
                                           "VUID-VkAttachmentDescription2-loadOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::storeOp), "VkAttachmentStoreOp",
                                           pCreateInfo->pAttachments[attachmentIndex].storeOp,
                                           "VUID-VkAttachmentDescription2-storeOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::stencilLoadOp), "VkAttachmentLoadOp",
                                           pCreateInfo->pAttachments[attachmentIndex].stencilLoadOp,
                                           "VUID-VkAttachmentDescription2-stencilLoadOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::stencilStoreOp), "VkAttachmentStoreOp",
                                           pCreateInfo->pAttachments[attachmentIndex].stencilStoreOp,
                                           "VUID-VkAttachmentDescription2-stencilStoreOp-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::initialLayout), "VkImageLayout",
                                           pCreateInfo->pAttachments[attachmentIndex].initialLayout,
                                           "VUID-VkAttachmentDescription2-initialLayout-parameter");

                skip |= ValidateRangedEnum(pAttachments_loc.dot(Field::finalLayout), "VkImageLayout",
                                           pCreateInfo->pAttachments[attachmentIndex].finalLayout,
                                           "VUID-VkAttachmentDescription2-finalLayout-parameter");
            }
        }

        skip |= ValidateStructTypeArray(
            pCreateInfo_loc.dot(Field::subpassCount), pCreateInfo_loc.dot(Field::pSubpasses),
            "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2", pCreateInfo->subpassCount, pCreateInfo->pSubpasses,
            VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2, true, true, "VUID-VkSubpassDescription2-sType-sType",
            "VUID-VkRenderPassCreateInfo2-pSubpasses-parameter", "VUID-VkRenderPassCreateInfo2-subpassCount-arraylength");

        if (pCreateInfo->pSubpasses != nullptr) {
            for (uint32_t subpassIndex = 0; subpassIndex < pCreateInfo->subpassCount; ++subpassIndex) {
                [[maybe_unused]] const Location pSubpasses_loc = pCreateInfo_loc.dot(Field::pSubpasses, subpassIndex);
                constexpr std::array allowed_structs_VkSubpassDescription2 = {
                    VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR,
                    VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT,
                    VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT,
                    VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT,
                    VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE};

                skip |= ValidateStructPnext(
                    pSubpasses_loc, pCreateInfo->pSubpasses[subpassIndex].pNext, allowed_structs_VkSubpassDescription2.size(),
                    allowed_structs_VkSubpassDescription2.data(), GeneratedVulkanHeaderVersion,
                    "VUID-VkSubpassDescription2-pNext-pNext", "VUID-VkSubpassDescription2-sType-unique", false, true);

                skip |= ValidateFlags(pSubpasses_loc.dot(Field::flags), "VkSubpassDescriptionFlagBits",
                                      AllVkSubpassDescriptionFlagBits, pCreateInfo->pSubpasses[subpassIndex].flags, kOptionalFlags,
                                      "VUID-VkSubpassDescription2-flags-parameter");

                skip |= ValidateRangedEnum(pSubpasses_loc.dot(Field::pipelineBindPoint), "VkPipelineBindPoint",
                                           pCreateInfo->pSubpasses[subpassIndex].pipelineBindPoint,
                                           "VUID-VkSubpassDescription2-pipelineBindPoint-parameter");

                skip |= ValidateStructTypeArray(
                    pSubpasses_loc.dot(Field::inputAttachmentCount), pSubpasses_loc.dot(Field::pInputAttachments),
                    "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount,
                    pCreateInfo->pSubpasses[subpassIndex].pInputAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, true,
                    "VUID-VkAttachmentReference2-sType-sType", "VUID-VkSubpassDescription2-pInputAttachments-parameter",
                    kVUIDUndefined);

                if (pCreateInfo->pSubpasses[subpassIndex].pInputAttachments != nullptr) {
                    for (uint32_t inputAttachmentIndex = 0;
                         inputAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount;
                         ++inputAttachmentIndex) {
                        [[maybe_unused]] const Location pInputAttachments_loc =
                            pSubpasses_loc.dot(Field::pInputAttachments, inputAttachmentIndex);
                        constexpr std::array allowed_structs_VkAttachmentReference2 = {
                            VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT};

                        skip |= ValidateStructPnext(
                            pInputAttachments_loc,
                            pCreateInfo->pSubpasses[subpassIndex].pInputAttachments[inputAttachmentIndex].pNext,
                            allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(),
                            GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext",
                            "VUID-VkAttachmentReference2-sType-unique", false, true);

                        skip |=
                            ValidateRangedEnum(pInputAttachments_loc.dot(Field::layout), "VkImageLayout",
                                               pCreateInfo->pSubpasses[subpassIndex].pInputAttachments[inputAttachmentIndex].layout,
                                               "VUID-VkAttachmentReference2-layout-parameter");
                    }
                }

                skip |= ValidateStructTypeArray(
                    pSubpasses_loc.dot(Field::colorAttachmentCount), pSubpasses_loc.dot(Field::pColorAttachments),
                    "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount,
                    pCreateInfo->pSubpasses[subpassIndex].pColorAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, true,
                    "VUID-VkAttachmentReference2-sType-sType", "VUID-VkSubpassDescription2-pColorAttachments-parameter",
                    kVUIDUndefined);

                if (pCreateInfo->pSubpasses[subpassIndex].pColorAttachments != nullptr) {
                    for (uint32_t colorAttachmentIndex = 0;
                         colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount;
                         ++colorAttachmentIndex) {
                        [[maybe_unused]] const Location pColorAttachments_loc =
                            pSubpasses_loc.dot(Field::pColorAttachments, colorAttachmentIndex);
                        constexpr std::array allowed_structs_VkAttachmentReference2 = {
                            VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT};

                        skip |= ValidateStructPnext(
                            pColorAttachments_loc,
                            pCreateInfo->pSubpasses[subpassIndex].pColorAttachments[colorAttachmentIndex].pNext,
                            allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(),
                            GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext",
                            "VUID-VkAttachmentReference2-sType-unique", false, true);

                        skip |=
                            ValidateRangedEnum(pColorAttachments_loc.dot(Field::layout), "VkImageLayout",
                                               pCreateInfo->pSubpasses[subpassIndex].pColorAttachments[colorAttachmentIndex].layout,
                                               "VUID-VkAttachmentReference2-layout-parameter");
                    }
                }

                skip |= ValidateStructTypeArray(
                    pSubpasses_loc.dot(Field::colorAttachmentCount), pSubpasses_loc.dot(Field::pResolveAttachments),
                    "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount,
                    pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false,
                    false, "VUID-VkAttachmentReference2-sType-sType", "VUID-VkSubpassDescription2-pResolveAttachments-parameter",
                    kVUIDUndefined);

                if (pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments != nullptr) {
                    for (uint32_t colorAttachmentIndex = 0;
                         colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount;
                         ++colorAttachmentIndex) {
                        [[maybe_unused]] const Location pResolveAttachments_loc =
                            pSubpasses_loc.dot(Field::pResolveAttachments, colorAttachmentIndex);
                        constexpr std::array allowed_structs_VkAttachmentReference2 = {
                            VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT};

                        skip |= ValidateStructPnext(
                            pResolveAttachments_loc,
                            pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments[colorAttachmentIndex].pNext,
                            allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(),
                            GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext",
                            "VUID-VkAttachmentReference2-sType-unique", false, true);

                        skip |= ValidateRangedEnum(
                            pResolveAttachments_loc.dot(Field::layout), "VkImageLayout",
                            pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments[colorAttachmentIndex].layout,
                            "VUID-VkAttachmentReference2-layout-parameter");
                    }
                }

                skip |= ValidateStructType(
                    pSubpasses_loc.dot(Field::pDepthStencilAttachment), "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2",
                    pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false,
                    "VUID-VkSubpassDescription2-pDepthStencilAttachment-parameter", "VUID-VkAttachmentReference2-sType-sType");

                if (pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment != nullptr) {
                    [[maybe_unused]] const Location pDepthStencilAttachment_loc =
                        pSubpasses_loc.dot(Field::pDepthStencilAttachment);
                    constexpr std::array allowed_structs_VkAttachmentReference2 = {
                        VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT};

                    skip |= ValidateStructPnext(
                        pDepthStencilAttachment_loc, pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment->pNext,
                        allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(),
                        GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext",
                        "VUID-VkAttachmentReference2-sType-unique", false, true);

                    skip |= ValidateRangedEnum(pDepthStencilAttachment_loc.dot(Field::layout), "VkImageLayout",
                                               pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment->layout,
                                               "VUID-VkAttachmentReference2-layout-parameter");
                }

                skip |= ValidateArray(pSubpasses_loc.dot(Field::preserveAttachmentCount),
                                      pSubpasses_loc.dot(Field::pPreserveAttachments),
                                      pCreateInfo->pSubpasses[subpassIndex].preserveAttachmentCount,
                                      &pCreateInfo->pSubpasses[subpassIndex].pPreserveAttachments, false, true, kVUIDUndefined,
                                      "VUID-VkSubpassDescription2-pPreserveAttachments-parameter");
            }
        }

        skip |= ValidateStructTypeArray(pCreateInfo_loc.dot(Field::dependencyCount), pCreateInfo_loc.dot(Field::pDependencies),
                                        "VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2", pCreateInfo->dependencyCount,
                                        pCreateInfo->pDependencies, VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2, false, true,
                                        "VUID-VkSubpassDependency2-sType-sType",
                                        "VUID-VkRenderPassCreateInfo2-pDependencies-parameter", kVUIDUndefined);

        if (pCreateInfo->pDependencies != nullptr) {
            for (uint32_t dependencyIndex = 0; dependencyIndex < pCreateInfo->dependencyCount; ++dependencyIndex) {
                [[maybe_unused]] const Location pDependencies_loc = pCreateInfo_loc.dot(Field::pDependencies, dependencyIndex);
                constexpr std::array allowed_structs_VkSubpassDependency2 = {VK_STRUCTURE_TYPE_MEMORY_BARRIER_2};

                skip |=
                    ValidateStructPnext(pDependencies_loc, pCreateInfo->pDependencies[dependencyIndex].pNext,
                                        allowed_structs_VkSubpassDependency2.size(), allowed_structs_VkSubpassDependency2.data(),
                                        GeneratedVulkanHeaderVersion, "VUID-VkSubpassDependency2-pNext-pNext",
                                        "VUID-VkSubpassDependency2-sType-unique", false, true);

                if (!vku::FindStructInPNextChain<VkMemoryBarrier2>(pCreateInfo->pDependencies[dependencyIndex].pNext)) {
                    skip |= ValidateFlags(pDependencies_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits",
                                          AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].srcStageMask,
                                          kOptionalFlags, "VUID-VkSubpassDependency2-srcStageMask-parameter");
                }

                if (!vku::FindStructInPNextChain<VkMemoryBarrier2>(pCreateInfo->pDependencies[dependencyIndex].pNext)) {
                    skip |= ValidateFlags(pDependencies_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits",
                                          AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].dstStageMask,
                                          kOptionalFlags, "VUID-VkSubpassDependency2-dstStageMask-parameter");
                }

                if (!vku::FindStructInPNextChain<VkMemoryBarrier2>(pCreateInfo->pDependencies[dependencyIndex].pNext)) {
                    skip |= ValidateFlags(pDependencies_loc.dot(Field::srcAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                          pCreateInfo->pDependencies[dependencyIndex].srcAccessMask, kOptionalFlags,
                                          "VUID-VkSubpassDependency2-srcAccessMask-parameter");
                }

                if (!vku::FindStructInPNextChain<VkMemoryBarrier2>(pCreateInfo->pDependencies[dependencyIndex].pNext)) {
                    skip |= ValidateFlags(pDependencies_loc.dot(Field::dstAccessMask), "VkAccessFlagBits", AllVkAccessFlagBits,
                                          pCreateInfo->pDependencies[dependencyIndex].dstAccessMask, kOptionalFlags,
                                          "VUID-VkSubpassDependency2-dstAccessMask-parameter");
                }

                skip |= ValidateFlags(pDependencies_loc.dot(Field::dependencyFlags), "VkDependencyFlagBits",
                                      AllVkDependencyFlagBits, pCreateInfo->pDependencies[dependencyIndex].dependencyFlags,
                                      kOptionalFlags, "VUID-VkSubpassDependency2-dependencyFlags-parameter");
            }
        }

        skip |= ValidateArray(pCreateInfo_loc.dot(Field::correlatedViewMaskCount), pCreateInfo_loc.dot(Field::pCorrelatedViewMasks),
                              pCreateInfo->correlatedViewMaskCount, &pCreateInfo->pCorrelatedViewMasks, false, true, kVUIDUndefined,
                              "VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-parameter");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pRenderPass), pRenderPass, "VUID-vkCreateRenderPass2-pRenderPass-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginRenderPass2(VkCommandBuffer commandBuffer,
                                                             const VkRenderPassBeginInfo* pRenderPassBegin,
                                                             const VkSubpassBeginInfo* pSubpassBeginInfo,
                                                             const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pRenderPassBegin), "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO", pRenderPassBegin,
                               VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO, true,
                               "VUID-vkCmdBeginRenderPass2-pRenderPassBegin-parameter", "VUID-VkRenderPassBeginInfo-sType-sType");
    if (pRenderPassBegin != nullptr) {
        [[maybe_unused]] const Location pRenderPassBegin_loc = loc.dot(Field::pRenderPassBegin);
        constexpr std::array allowed_structs_VkRenderPassBeginInfo = {
            VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO,
            VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM,
            VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO,
            VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT,
            VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM,
            VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM};

        skip |=
            ValidateStructPnext(pRenderPassBegin_loc, pRenderPassBegin->pNext, allowed_structs_VkRenderPassBeginInfo.size(),
                                allowed_structs_VkRenderPassBeginInfo.data(), GeneratedVulkanHeaderVersion,
                                "VUID-VkRenderPassBeginInfo-pNext-pNext", "VUID-VkRenderPassBeginInfo-sType-unique", false, true);

        skip |= ValidateRequiredHandle(pRenderPassBegin_loc.dot(Field::renderPass), pRenderPassBegin->renderPass);

        skip |= ValidateRequiredHandle(pRenderPassBegin_loc.dot(Field::framebuffer), pRenderPassBegin->framebuffer);

        // No xml-driven validation

        // No xml-driven validation
    }
    skip |= ValidateStructType(loc.dot(Field::pSubpassBeginInfo), "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO", pSubpassBeginInfo,
                               VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO, true, "VUID-vkCmdBeginRenderPass2-pSubpassBeginInfo-parameter",
                               "VUID-VkSubpassBeginInfo-sType-sType");
    if (pSubpassBeginInfo != nullptr) {
        [[maybe_unused]] const Location pSubpassBeginInfo_loc = loc.dot(Field::pSubpassBeginInfo);
        skip |= ValidateStructPnext(pSubpassBeginInfo_loc, pSubpassBeginInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkSubpassBeginInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRangedEnum(pSubpassBeginInfo_loc.dot(Field::contents), "VkSubpassContents", pSubpassBeginInfo->contents,
                                   "VUID-VkSubpassBeginInfo-contents-parameter");
    }
    if (!skip) skip |= manual_PreCallValidateCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo,
                                                         const VkSubpassEndInfo* pSubpassEndInfo,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pSubpassBeginInfo), "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO", pSubpassBeginInfo,
                               VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO, true, "VUID-vkCmdNextSubpass2-pSubpassBeginInfo-parameter",
                               "VUID-VkSubpassBeginInfo-sType-sType");
    if (pSubpassBeginInfo != nullptr) {
        [[maybe_unused]] const Location pSubpassBeginInfo_loc = loc.dot(Field::pSubpassBeginInfo);
        skip |= ValidateStructPnext(pSubpassBeginInfo_loc, pSubpassBeginInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkSubpassBeginInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRangedEnum(pSubpassBeginInfo_loc.dot(Field::contents), "VkSubpassContents", pSubpassBeginInfo->contents,
                                   "VUID-VkSubpassBeginInfo-contents-parameter");
    }
    skip |= ValidateStructType(loc.dot(Field::pSubpassEndInfo), "VK_STRUCTURE_TYPE_SUBPASS_END_INFO", pSubpassEndInfo,
                               VK_STRUCTURE_TYPE_SUBPASS_END_INFO, true, "VUID-vkCmdNextSubpass2-pSubpassEndInfo-parameter",
                               "VUID-VkSubpassEndInfo-sType-sType");
    if (pSubpassEndInfo != nullptr) {
        [[maybe_unused]] const Location pSubpassEndInfo_loc = loc.dot(Field::pSubpassEndInfo);
        constexpr std::array allowed_structs_VkSubpassEndInfo = {
            VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM};

        skip |= ValidateStructPnext(pSubpassEndInfo_loc, pSubpassEndInfo->pNext, allowed_structs_VkSubpassEndInfo.size(),
                                    allowed_structs_VkSubpassEndInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkSubpassEndInfo-pNext-pNext", "VUID-VkSubpassEndInfo-sType-unique", false, true);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo,
                                                           const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pSubpassEndInfo), "VK_STRUCTURE_TYPE_SUBPASS_END_INFO", pSubpassEndInfo,
                               VK_STRUCTURE_TYPE_SUBPASS_END_INFO, true, "VUID-vkCmdEndRenderPass2-pSubpassEndInfo-parameter",
                               "VUID-VkSubpassEndInfo-sType-sType");
    if (pSubpassEndInfo != nullptr) {
        [[maybe_unused]] const Location pSubpassEndInfo_loc = loc.dot(Field::pSubpassEndInfo);
        constexpr std::array allowed_structs_VkSubpassEndInfo = {
            VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM};

        skip |= ValidateStructPnext(pSubpassEndInfo_loc, pSubpassEndInfo->pNext, allowed_structs_VkSubpassEndInfo.size(),
                                    allowed_structs_VkSubpassEndInfo.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkSubpassEndInfo-pNext-pNext", "VUID-VkSubpassEndInfo-sType-unique", false, true);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery,
                                                        uint32_t queryCount, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateGetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue,
                                                                  const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::semaphore), semaphore);
    skip |= ValidateRequiredPointer(loc.dot(Field::pValue), pValue, "VUID-vkGetSemaphoreCounterValue-pValue-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateWaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pWaitInfo), "VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO", pWaitInfo,
                               VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO, true, "VUID-vkWaitSemaphores-pWaitInfo-parameter",
                               "VUID-VkSemaphoreWaitInfo-sType-sType");
    if (pWaitInfo != nullptr) {
        [[maybe_unused]] const Location pWaitInfo_loc = loc.dot(Field::pWaitInfo);
        skip |= ValidateStructPnext(pWaitInfo_loc, pWaitInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkSemaphoreWaitInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags(pWaitInfo_loc.dot(Field::flags), "VkSemaphoreWaitFlagBits", AllVkSemaphoreWaitFlagBits,
                              pWaitInfo->flags, kOptionalFlags, "VUID-VkSemaphoreWaitInfo-flags-parameter");

        skip |= ValidateHandleArray(pWaitInfo_loc.dot(Field::semaphoreCount), pWaitInfo_loc.dot(Field::pSemaphores),
                                    pWaitInfo->semaphoreCount, pWaitInfo->pSemaphores, true, true, kVUIDUndefined);

        skip |= ValidateArray(pWaitInfo_loc.dot(Field::semaphoreCount), pWaitInfo_loc.dot(Field::pValues),
                              pWaitInfo->semaphoreCount, &pWaitInfo->pValues, true, true,
                              "VUID-VkSemaphoreWaitInfo-semaphoreCount-arraylength", "VUID-VkSemaphoreWaitInfo-pValues-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateSignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo,
                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pSignalInfo), "VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO", pSignalInfo,
                               VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO, true, "VUID-vkSignalSemaphore-pSignalInfo-parameter",
                               "VUID-VkSemaphoreSignalInfo-sType-sType");
    if (pSignalInfo != nullptr) {
        [[maybe_unused]] const Location pSignalInfo_loc = loc.dot(Field::pSignalInfo);
        skip |= ValidateStructPnext(pSignalInfo_loc, pSignalInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkSemaphoreSignalInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pSignalInfo_loc.dot(Field::semaphore), pSignalInfo->semaphore);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo,
                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pInfo), "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", pInfo,
                               VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO, true, "VUID-vkGetBufferDeviceAddress-pInfo-parameter",
                               "VUID-VkBufferDeviceAddressInfo-sType-sType");
    if (pInfo != nullptr) {
        [[maybe_unused]] const Location pInfo_loc = loc.dot(Field::pInfo);
        skip |= ValidateStructPnext(pInfo_loc, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkBufferDeviceAddressInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pInfo_loc.dot(Field::buffer), pInfo->buffer);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo,
                                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(
        loc.dot(Field::pInfo), "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", pInfo, VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO,
        true, "VUID-vkGetBufferOpaqueCaptureAddress-pInfo-parameter", "VUID-VkBufferDeviceAddressInfo-sType-sType");
    if (pInfo != nullptr) {
        [[maybe_unused]] const Location pInfo_loc = loc.dot(Field::pInfo);
        skip |= ValidateStructPnext(pInfo_loc, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkBufferDeviceAddressInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pInfo_loc.dot(Field::buffer), pInfo->buffer);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceMemoryOpaqueCaptureAddress(VkDevice device,
                                                                             const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo,
                                                                             const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pInfo), "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", pInfo,
                               VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO, true,
                               "VUID-vkGetDeviceMemoryOpaqueCaptureAddress-pInfo-parameter",
                               "VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType");
    if (pInfo != nullptr) {
        [[maybe_unused]] const Location pInfo_loc = loc.dot(Field::pInfo);
        skip |= ValidateStructPnext(pInfo_loc, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pInfo_loc.dot(Field::memory), pInfo->memory);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount,
                                                                         VkPhysicalDeviceToolProperties* pToolProperties,
                                                                         const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (loc.function == vvl::Func::vkGetPhysicalDeviceToolProperties &&
        CheckPromotedApiAgainstVulkanVersion(physicalDevice, loc, VK_API_VERSION_1_3))
        return true;
    skip |= ValidateStructTypeArray(loc.dot(Field::pToolCount), loc.dot(Field::pToolProperties),
                                    "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES", pToolCount, pToolProperties,
                                    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES, true, false, false,
                                    "VUID-VkPhysicalDeviceToolProperties-sType-sType",
                                    "VUID-vkGetPhysicalDeviceToolProperties-pToolProperties-parameter", kVUIDUndefined);
    if (pToolProperties != nullptr) {
        for (uint32_t pToolIndex = 0; pToolIndex < *pToolCount; ++pToolIndex) {
            [[maybe_unused]] const Location pToolProperties_loc = loc.dot(Field::pToolProperties, pToolIndex);
            skip |= ValidateStructPnext(pToolProperties_loc, pToolProperties[pToolIndex].pNext, 0, nullptr,
                                        GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceToolProperties-pNext-pNext",
                                        kVUIDUndefined, true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               VkPrivateDataSlot* pPrivateDataSlot,
                                                               const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateStructType(loc.dot(Field::pCreateInfo), "VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO", pCreateInfo,
                           VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO, true,
                           "VUID-vkCreatePrivateDataSlot-pCreateInfo-parameter", "VUID-VkPrivateDataSlotCreateInfo-sType-sType");
    if (pCreateInfo != nullptr) {
        [[maybe_unused]] const Location pCreateInfo_loc = loc.dot(Field::pCreateInfo);
        skip |= ValidateStructPnext(pCreateInfo_loc, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkPrivateDataSlotCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags(pCreateInfo_loc.dot(Field::flags), pCreateInfo->flags,
                                      "VUID-VkPrivateDataSlotCreateInfo-flags-zerobitmask");
    }
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    skip |= ValidateRequiredPointer(loc.dot(Field::pPrivateDataSlot), pPrivateDataSlot,
                                    "VUID-vkCreatePrivateDataSlot-pPrivateDataSlot-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot,
                                                                const VkAllocationCallbacks* pAllocator,
                                                                const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    if (pAllocator != nullptr) {
        [[maybe_unused]] const Location pAllocator_loc = loc.dot(Field::pAllocator);
        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnAllocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnAllocation),
                                        "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnReallocation),
                                        reinterpret_cast<const void*>(pAllocator->pfnReallocation),
                                        "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnFree), reinterpret_cast<const void*>(pAllocator->pfnFree),
                                        "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalAllocation),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalFree),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }

        if (pAllocator->pfnInternalFree != nullptr) {
            skip |= ValidateRequiredPointer(pAllocator_loc.dot(Field::pfnInternalFree),
                                            reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation),
                                            "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateSetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                                        VkPrivateDataSlot privateDataSlot, uint64_t data,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateRangedEnum(loc.dot(Field::objectType), "VkObjectType", objectType, "VUID-vkSetPrivateData-objectType-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::privateDataSlot), privateDataSlot);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                                        VkPrivateDataSlot privateDataSlot, uint64_t* pData,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |=
        ValidateRangedEnum(loc.dot(Field::objectType), "VkObjectType", objectType, "VUID-vkGetPrivateData-objectType-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::privateDataSlot), privateDataSlot);
    skip |= ValidateRequiredPointer(loc.dot(Field::pData), pData, "VUID-vkGetPrivateData-pData-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetEvent2(VkCommandBuffer commandBuffer, VkEvent event,
                                                      const VkDependencyInfo* pDependencyInfo, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    skip |= ValidateStructType(loc.dot(Field::pDependencyInfo), "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", pDependencyInfo,
                               VK_STRUCTURE_TYPE_DEPENDENCY_INFO, true, "VUID-vkCmdSetEvent2-pDependencyInfo-parameter",
                               "VUID-VkDependencyInfo-sType-sType");
    if (pDependencyInfo != nullptr) {
        [[maybe_unused]] const Location pDependencyInfo_loc = loc.dot(Field::pDependencyInfo);
        skip |= ValidateStructPnext(pDependencyInfo_loc, pDependencyInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkDependencyInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags(pDependencyInfo_loc.dot(Field::dependencyFlags), "VkDependencyFlagBits", AllVkDependencyFlagBits,
                              pDependencyInfo->dependencyFlags, kOptionalFlags, "VUID-VkDependencyInfo-dependencyFlags-parameter");

        skip |= ValidateStructTypeArray(pDependencyInfo_loc.dot(Field::memoryBarrierCount),
                                        pDependencyInfo_loc.dot(Field::pMemoryBarriers), "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2",
                                        pDependencyInfo->memoryBarrierCount, pDependencyInfo->pMemoryBarriers,
                                        VK_STRUCTURE_TYPE_MEMORY_BARRIER_2, false, true, "VUID-VkMemoryBarrier2-sType-sType",
                                        "VUID-VkDependencyInfo-pMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pMemoryBarriers != nullptr) {
            for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < pDependencyInfo->memoryBarrierCount; ++memoryBarrierIndex) {
                [[maybe_unused]] const Location pMemoryBarriers_loc =
                    pDependencyInfo_loc.dot(Field::pMemoryBarriers, memoryBarrierIndex);
                skip |= ValidateStructPnext(pMemoryBarriers_loc, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].pNext, 0,
                                            nullptr, GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

                skip |=
                    ValidateFlags(pMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                  AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcStageMask,
                                  kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                      "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                skip |=
                    ValidateFlags(pMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                  AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstStageMask,
                                  kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                      "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
            }
        }

        skip |= ValidateStructTypeArray(
            pDependencyInfo_loc.dot(Field::bufferMemoryBarrierCount), pDependencyInfo_loc.dot(Field::pBufferMemoryBarriers),
            "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", pDependencyInfo->bufferMemoryBarrierCount,
            pDependencyInfo->pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2, false, true,
            "VUID-VkBufferMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pBufferMemoryBarriers != nullptr) {
            for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < pDependencyInfo->bufferMemoryBarrierCount;
                 ++bufferMemoryBarrierIndex) {
                [[maybe_unused]] const Location pBufferMemoryBarriers_loc =
                    pDependencyInfo_loc.dot(Field::pBufferMemoryBarriers, bufferMemoryBarrierIndex);
                constexpr std::array allowed_structs_VkBufferMemoryBarrier2 = {
                    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT};

                skip |= ValidateStructPnext(
                    pBufferMemoryBarriers_loc, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext,
                    allowed_structs_VkBufferMemoryBarrier2.size(), allowed_structs_VkBufferMemoryBarrier2.data(),
                    GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier2-pNext-pNext",
                    "VUID-VkBufferMemoryBarrier2-sType-unique", false, true);

                skip |= ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcStageMask, kOptionalFlags,
                                      "VUID-VkBufferMemoryBarrier2-srcStageMask-parameter");

                skip |=
                    ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                  pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                  "VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstStageMask, kOptionalFlags,
                                      "VUID-VkBufferMemoryBarrier2-dstStageMask-parameter");

                skip |=
                    ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                  pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                  "VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRequiredHandle(pBufferMemoryBarriers_loc.dot(Field::buffer),
                                               pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
            }
        }

        skip |= ValidateStructTypeArray(
            pDependencyInfo_loc.dot(Field::imageMemoryBarrierCount), pDependencyInfo_loc.dot(Field::pImageMemoryBarriers),
            "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", pDependencyInfo->imageMemoryBarrierCount,
            pDependencyInfo->pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2, false, true,
            "VUID-VkImageMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pImageMemoryBarriers != nullptr) {
            for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < pDependencyInfo->imageMemoryBarrierCount;
                 ++imageMemoryBarrierIndex) {
                [[maybe_unused]] const Location pImageMemoryBarriers_loc =
                    pDependencyInfo_loc.dot(Field::pImageMemoryBarriers, imageMemoryBarrierIndex);
                constexpr std::array allowed_structs_VkImageMemoryBarrier2 = {
                    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT, VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT};

                skip |= ValidateStructPnext(
                    pImageMemoryBarriers_loc, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].pNext,
                    allowed_structs_VkImageMemoryBarrier2.size(), allowed_structs_VkImageMemoryBarrier2.data(),
                    GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier2-pNext-pNext",
                    "VUID-VkImageMemoryBarrier2-sType-unique", false, true);

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcStageMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstStageMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::oldLayout), "VkImageLayout",
                                           pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout,
                                           "VUID-VkImageMemoryBarrier2-oldLayout-parameter");

                skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::newLayout), "VkImageLayout",
                                           pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout,
                                           "VUID-VkImageMemoryBarrier2-newLayout-parameter");

                skip |= ValidateRequiredHandle(pImageMemoryBarriers_loc.dot(Field::image),
                                               pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].image);

                skip |= ValidateFlags(
                    pImageMemoryBarriers_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                    pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags,
                    "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResetEvent2(VkCommandBuffer commandBuffer, VkEvent event,
                                                        VkPipelineStageFlags2 stageMask, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateRequiredHandle(loc.dot(Field::event), event);
    skip |= ValidateFlags(loc.dot(Field::stageMask), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, stageMask,
                          kOptionalFlags, "VUID-vkCmdResetEvent2-stageMask-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWaitEvents2(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                                        const VkDependencyInfo* pDependencyInfos,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateHandleArray(loc.dot(Field::eventCount), loc.dot(Field::pEvents), eventCount, pEvents, true, true,
                                "VUID-vkCmdWaitEvents2-eventCount-arraylength");
    skip |= ValidateStructTypeArray(
        loc.dot(Field::eventCount), loc.dot(Field::pDependencyInfos), "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", eventCount,
        pDependencyInfos, VK_STRUCTURE_TYPE_DEPENDENCY_INFO, true, true, "VUID-VkDependencyInfo-sType-sType",
        "VUID-vkCmdWaitEvents2-pDependencyInfos-parameter", "VUID-vkCmdWaitEvents2-eventCount-arraylength");
    if (pDependencyInfos != nullptr) {
        for (uint32_t eventIndex = 0; eventIndex < eventCount; ++eventIndex) {
            [[maybe_unused]] const Location pDependencyInfos_loc = loc.dot(Field::pDependencyInfos, eventIndex);
            skip |=
                ValidateStructPnext(pDependencyInfos_loc, pDependencyInfos[eventIndex].pNext, 0, nullptr,
                                    GeneratedVulkanHeaderVersion, "VUID-VkDependencyInfo-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateFlags(pDependencyInfos_loc.dot(Field::dependencyFlags), "VkDependencyFlagBits", AllVkDependencyFlagBits,
                                  pDependencyInfos[eventIndex].dependencyFlags, kOptionalFlags,
                                  "VUID-VkDependencyInfo-dependencyFlags-parameter");

            skip |= ValidateStructTypeArray(
                pDependencyInfos_loc.dot(Field::memoryBarrierCount), pDependencyInfos_loc.dot(Field::pMemoryBarriers),
                "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2", pDependencyInfos[eventIndex].memoryBarrierCount,
                pDependencyInfos[eventIndex].pMemoryBarriers, VK_STRUCTURE_TYPE_MEMORY_BARRIER_2, false, true,
                "VUID-VkMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pMemoryBarriers-parameter", kVUIDUndefined);

            if (pDependencyInfos[eventIndex].pMemoryBarriers != nullptr) {
                for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < pDependencyInfos[eventIndex].memoryBarrierCount;
                     ++memoryBarrierIndex) {
                    [[maybe_unused]] const Location pMemoryBarriers_loc =
                        pDependencyInfos_loc.dot(Field::pMemoryBarriers, memoryBarrierIndex);
                    skip |= ValidateStructPnext(pMemoryBarriers_loc,
                                                pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr,
                                                GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

                    skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].srcStageMask,
                                          kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                    skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                          pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].srcAccessMask,
                                          kOptionalFlags, "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                    skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].dstStageMask,
                                          kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                    skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                          pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].dstAccessMask,
                                          kOptionalFlags, "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
                }
            }

            skip |= ValidateStructTypeArray(
                pDependencyInfos_loc.dot(Field::bufferMemoryBarrierCount), pDependencyInfos_loc.dot(Field::pBufferMemoryBarriers),
                "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", pDependencyInfos[eventIndex].bufferMemoryBarrierCount,
                pDependencyInfos[eventIndex].pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2, false, true,
                "VUID-VkBufferMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", kVUIDUndefined);

            if (pDependencyInfos[eventIndex].pBufferMemoryBarriers != nullptr) {
                for (uint32_t bufferMemoryBarrierIndex = 0;
                     bufferMemoryBarrierIndex < pDependencyInfos[eventIndex].bufferMemoryBarrierCount; ++bufferMemoryBarrierIndex) {
                    [[maybe_unused]] const Location pBufferMemoryBarriers_loc =
                        pDependencyInfos_loc.dot(Field::pBufferMemoryBarriers, bufferMemoryBarrierIndex);
                    constexpr std::array allowed_structs_VkBufferMemoryBarrier2 = {
                        VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT};

                    skip |= ValidateStructPnext(pBufferMemoryBarriers_loc,
                                                pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext,
                                                allowed_structs_VkBufferMemoryBarrier2.size(),
                                                allowed_structs_VkBufferMemoryBarrier2.data(), GeneratedVulkanHeaderVersion,
                                                "VUID-VkBufferMemoryBarrier2-pNext-pNext",
                                                "VUID-VkBufferMemoryBarrier2-sType-unique", false, true);

                    skip |= ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcStageMask,
                                          kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcStageMask-parameter");

                    skip |= ValidateFlags(
                        pBufferMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                        pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcAccessMask, kOptionalFlags,
                        "VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter");

                    skip |= ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstStageMask,
                                          kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstStageMask-parameter");

                    skip |= ValidateFlags(
                        pBufferMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                        pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstAccessMask, kOptionalFlags,
                        "VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter");

                    skip |=
                        ValidateRequiredHandle(pBufferMemoryBarriers_loc.dot(Field::buffer),
                                               pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
                }
            }

            skip |= ValidateStructTypeArray(
                pDependencyInfos_loc.dot(Field::imageMemoryBarrierCount), pDependencyInfos_loc.dot(Field::pImageMemoryBarriers),
                "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", pDependencyInfos[eventIndex].imageMemoryBarrierCount,
                pDependencyInfos[eventIndex].pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2, false, true,
                "VUID-VkImageMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", kVUIDUndefined);

            if (pDependencyInfos[eventIndex].pImageMemoryBarriers != nullptr) {
                for (uint32_t imageMemoryBarrierIndex = 0;
                     imageMemoryBarrierIndex < pDependencyInfos[eventIndex].imageMemoryBarrierCount; ++imageMemoryBarrierIndex) {
                    [[maybe_unused]] const Location pImageMemoryBarriers_loc =
                        pDependencyInfos_loc.dot(Field::pImageMemoryBarriers, imageMemoryBarrierIndex);
                    constexpr std::array allowed_structs_VkImageMemoryBarrier2 = {
                        VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT, VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT};

                    skip |= ValidateStructPnext(
                        pImageMemoryBarriers_loc, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].pNext,
                        allowed_structs_VkImageMemoryBarrier2.size(), allowed_structs_VkImageMemoryBarrier2.data(),
                        GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier2-pNext-pNext",
                        "VUID-VkImageMemoryBarrier2-sType-unique", false, true);

                    skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].srcStageMask,
                                          kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcStageMask-parameter");

                    skip |=
                        ValidateFlags(pImageMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].srcAccessMask,
                                      kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcAccessMask-parameter");

                    skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].dstStageMask,
                                          kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstStageMask-parameter");

                    skip |=
                        ValidateFlags(pImageMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].dstAccessMask,
                                      kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstAccessMask-parameter");

                    skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::oldLayout), "VkImageLayout",
                                               pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout,
                                               "VUID-VkImageMemoryBarrier2-oldLayout-parameter");

                    skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::newLayout), "VkImageLayout",
                                               pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout,
                                               "VUID-VkImageMemoryBarrier2-newLayout-parameter");

                    skip |=
                        ValidateRequiredHandle(pImageMemoryBarriers_loc.dot(Field::image),
                                               pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].image);

                    skip |= ValidateFlags(
                        pImageMemoryBarriers_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                        pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask,
                        kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter",
                        "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
                }
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdPipelineBarrier2(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo,
                                                             const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pDependencyInfo), "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", pDependencyInfo,
                               VK_STRUCTURE_TYPE_DEPENDENCY_INFO, true, "VUID-vkCmdPipelineBarrier2-pDependencyInfo-parameter",
                               "VUID-VkDependencyInfo-sType-sType");
    if (pDependencyInfo != nullptr) {
        [[maybe_unused]] const Location pDependencyInfo_loc = loc.dot(Field::pDependencyInfo);
        skip |= ValidateStructPnext(pDependencyInfo_loc, pDependencyInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkDependencyInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags(pDependencyInfo_loc.dot(Field::dependencyFlags), "VkDependencyFlagBits", AllVkDependencyFlagBits,
                              pDependencyInfo->dependencyFlags, kOptionalFlags, "VUID-VkDependencyInfo-dependencyFlags-parameter");

        skip |= ValidateStructTypeArray(pDependencyInfo_loc.dot(Field::memoryBarrierCount),
                                        pDependencyInfo_loc.dot(Field::pMemoryBarriers), "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2",
                                        pDependencyInfo->memoryBarrierCount, pDependencyInfo->pMemoryBarriers,
                                        VK_STRUCTURE_TYPE_MEMORY_BARRIER_2, false, true, "VUID-VkMemoryBarrier2-sType-sType",
                                        "VUID-VkDependencyInfo-pMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pMemoryBarriers != nullptr) {
            for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < pDependencyInfo->memoryBarrierCount; ++memoryBarrierIndex) {
                [[maybe_unused]] const Location pMemoryBarriers_loc =
                    pDependencyInfo_loc.dot(Field::pMemoryBarriers, memoryBarrierIndex);
                skip |= ValidateStructPnext(pMemoryBarriers_loc, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].pNext, 0,
                                            nullptr, GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

                skip |=
                    ValidateFlags(pMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                  AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcStageMask,
                                  kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                      "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                skip |=
                    ValidateFlags(pMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                  AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstStageMask,
                                  kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags(pMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                      "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
            }
        }

        skip |= ValidateStructTypeArray(
            pDependencyInfo_loc.dot(Field::bufferMemoryBarrierCount), pDependencyInfo_loc.dot(Field::pBufferMemoryBarriers),
            "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", pDependencyInfo->bufferMemoryBarrierCount,
            pDependencyInfo->pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2, false, true,
            "VUID-VkBufferMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pBufferMemoryBarriers != nullptr) {
            for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < pDependencyInfo->bufferMemoryBarrierCount;
                 ++bufferMemoryBarrierIndex) {
                [[maybe_unused]] const Location pBufferMemoryBarriers_loc =
                    pDependencyInfo_loc.dot(Field::pBufferMemoryBarriers, bufferMemoryBarrierIndex);
                constexpr std::array allowed_structs_VkBufferMemoryBarrier2 = {
                    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT};

                skip |= ValidateStructPnext(
                    pBufferMemoryBarriers_loc, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext,
                    allowed_structs_VkBufferMemoryBarrier2.size(), allowed_structs_VkBufferMemoryBarrier2.data(),
                    GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier2-pNext-pNext",
                    "VUID-VkBufferMemoryBarrier2-sType-unique", false, true);

                skip |= ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcStageMask, kOptionalFlags,
                                      "VUID-VkBufferMemoryBarrier2-srcStageMask-parameter");

                skip |=
                    ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                  pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                  "VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstStageMask, kOptionalFlags,
                                      "VUID-VkBufferMemoryBarrier2-dstStageMask-parameter");

                skip |=
                    ValidateFlags(pBufferMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                  pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                  "VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRequiredHandle(pBufferMemoryBarriers_loc.dot(Field::buffer),
                                               pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
            }
        }

        skip |= ValidateStructTypeArray(
            pDependencyInfo_loc.dot(Field::imageMemoryBarrierCount), pDependencyInfo_loc.dot(Field::pImageMemoryBarriers),
            "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", pDependencyInfo->imageMemoryBarrierCount,
            pDependencyInfo->pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2, false, true,
            "VUID-VkImageMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pImageMemoryBarriers != nullptr) {
            for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < pDependencyInfo->imageMemoryBarrierCount;
                 ++imageMemoryBarrierIndex) {
                [[maybe_unused]] const Location pImageMemoryBarriers_loc =
                    pDependencyInfo_loc.dot(Field::pImageMemoryBarriers, imageMemoryBarrierIndex);
                constexpr std::array allowed_structs_VkImageMemoryBarrier2 = {
                    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT, VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT};

                skip |= ValidateStructPnext(
                    pImageMemoryBarriers_loc, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].pNext,
                    allowed_structs_VkImageMemoryBarrier2.size(), allowed_structs_VkImageMemoryBarrier2.data(),
                    GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier2-pNext-pNext",
                    "VUID-VkImageMemoryBarrier2-sType-unique", false, true);

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::srcStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcStageMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::srcAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcAccessMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::dstStageMask), "VkPipelineStageFlagBits2",
                                      AllVkPipelineStageFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstStageMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags(pImageMemoryBarriers_loc.dot(Field::dstAccessMask), "VkAccessFlagBits2", AllVkAccessFlagBits2,
                                      pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstAccessMask, kOptionalFlags,
                                      "VUID-VkImageMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::oldLayout), "VkImageLayout",
                                           pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout,
                                           "VUID-VkImageMemoryBarrier2-oldLayout-parameter");

                skip |= ValidateRangedEnum(pImageMemoryBarriers_loc.dot(Field::newLayout), "VkImageLayout",
                                           pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout,
                                           "VUID-VkImageMemoryBarrier2-newLayout-parameter");

                skip |= ValidateRequiredHandle(pImageMemoryBarriers_loc.dot(Field::image),
                                               pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].image);

                skip |= ValidateFlags(
                    pImageMemoryBarriers_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                    pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags,
                    "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWriteTimestamp2(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage,
                                                            VkQueryPool queryPool, uint32_t query,
                                                            const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateFlags(loc.dot(Field::stage), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, stage, kOptionalFlags,
                          "VUID-vkCmdWriteTimestamp2-stage-parameter");
    skip |= ValidateRequiredHandle(loc.dot(Field::queryPool), queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateQueueSubmit2(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits,
                                                      VkFence fence, const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructTypeArray(loc.dot(Field::submitCount), loc.dot(Field::pSubmits), "VK_STRUCTURE_TYPE_SUBMIT_INFO_2",
                                    submitCount, pSubmits, VK_STRUCTURE_TYPE_SUBMIT_INFO_2, false, true,
                                    "VUID-VkSubmitInfo2-sType-sType", "VUID-vkQueueSubmit2-pSubmits-parameter", kVUIDUndefined);
    if (pSubmits != nullptr) {
        for (uint32_t submitIndex = 0; submitIndex < submitCount; ++submitIndex) {
            [[maybe_unused]] const Location pSubmits_loc = loc.dot(Field::pSubmits, submitIndex);
            constexpr std::array allowed_structs_VkSubmitInfo2 = {
                VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT, VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV,
                VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR, VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR,
                VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV};

            skip |= ValidateStructPnext(pSubmits_loc, pSubmits[submitIndex].pNext, allowed_structs_VkSubmitInfo2.size(),
                                        allowed_structs_VkSubmitInfo2.data(), GeneratedVulkanHeaderVersion,
                                        "VUID-VkSubmitInfo2-pNext-pNext", "VUID-VkSubmitInfo2-sType-unique", false, true);

            skip |= ValidateFlags(pSubmits_loc.dot(Field::flags), "VkSubmitFlagBits", AllVkSubmitFlagBits,
                                  pSubmits[submitIndex].flags, kOptionalFlags, "VUID-VkSubmitInfo2-flags-parameter");

            skip |= ValidateStructTypeArray(
                pSubmits_loc.dot(Field::waitSemaphoreInfoCount), pSubmits_loc.dot(Field::pWaitSemaphoreInfos),
                "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO", pSubmits[submitIndex].waitSemaphoreInfoCount,
                pSubmits[submitIndex].pWaitSemaphoreInfos, VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO, false, true,
                "VUID-VkSemaphoreSubmitInfo-sType-sType", "VUID-VkSubmitInfo2-pWaitSemaphoreInfos-parameter", kVUIDUndefined);

            if (pSubmits[submitIndex].pWaitSemaphoreInfos != nullptr) {
                for (uint32_t waitSemaphoreInfoIndex = 0; waitSemaphoreInfoIndex < pSubmits[submitIndex].waitSemaphoreInfoCount;
                     ++waitSemaphoreInfoIndex) {
                    [[maybe_unused]] const Location pWaitSemaphoreInfos_loc =
                        pSubmits_loc.dot(Field::pWaitSemaphoreInfos, waitSemaphoreInfoIndex);
                    skip |= ValidateStructPnext(pWaitSemaphoreInfos_loc,
                                                pSubmits[submitIndex].pWaitSemaphoreInfos[waitSemaphoreInfoIndex].pNext, 0, nullptr,
                                                GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreSubmitInfo-pNext-pNext",
                                                kVUIDUndefined, false, true);

                    skip |= ValidateRequiredHandle(pWaitSemaphoreInfos_loc.dot(Field::semaphore),
                                                   pSubmits[submitIndex].pWaitSemaphoreInfos[waitSemaphoreInfoIndex].semaphore);

                    skip |= ValidateFlags(pWaitSemaphoreInfos_loc.dot(Field::stageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pSubmits[submitIndex].pWaitSemaphoreInfos[waitSemaphoreInfoIndex].stageMask,
                                          kOptionalFlags, "VUID-VkSemaphoreSubmitInfo-stageMask-parameter");
                }
            }

            skip |= ValidateStructTypeArray(
                pSubmits_loc.dot(Field::commandBufferInfoCount), pSubmits_loc.dot(Field::pCommandBufferInfos),
                "VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO", pSubmits[submitIndex].commandBufferInfoCount,
                pSubmits[submitIndex].pCommandBufferInfos, VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO, false, true,
                "VUID-VkCommandBufferSubmitInfo-sType-sType", "VUID-VkSubmitInfo2-pCommandBufferInfos-parameter", kVUIDUndefined);

            if (pSubmits[submitIndex].pCommandBufferInfos != nullptr) {
                for (uint32_t commandBufferInfoIndex = 0; commandBufferInfoIndex < pSubmits[submitIndex].commandBufferInfoCount;
                     ++commandBufferInfoIndex) {
                    [[maybe_unused]] const Location pCommandBufferInfos_loc =
                        pSubmits_loc.dot(Field::pCommandBufferInfos, commandBufferInfoIndex);
                    constexpr std::array allowed_structs_VkCommandBufferSubmitInfo = {
                        VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM};

                    skip |= ValidateStructPnext(
                        pCommandBufferInfos_loc, pSubmits[submitIndex].pCommandBufferInfos[commandBufferInfoIndex].pNext,
                        allowed_structs_VkCommandBufferSubmitInfo.size(), allowed_structs_VkCommandBufferSubmitInfo.data(),
                        GeneratedVulkanHeaderVersion, "VUID-VkCommandBufferSubmitInfo-pNext-pNext",
                        "VUID-VkCommandBufferSubmitInfo-sType-unique", false, true);

                    skip |= ValidateRequiredHandle(pCommandBufferInfos_loc.dot(Field::commandBuffer),
                                                   pSubmits[submitIndex].pCommandBufferInfos[commandBufferInfoIndex].commandBuffer);
                }
            }

            skip |= ValidateStructTypeArray(
                pSubmits_loc.dot(Field::signalSemaphoreInfoCount), pSubmits_loc.dot(Field::pSignalSemaphoreInfos),
                "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO", pSubmits[submitIndex].signalSemaphoreInfoCount,
                pSubmits[submitIndex].pSignalSemaphoreInfos, VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO, false, true,
                "VUID-VkSemaphoreSubmitInfo-sType-sType", "VUID-VkSubmitInfo2-pSignalSemaphoreInfos-parameter", kVUIDUndefined);

            if (pSubmits[submitIndex].pSignalSemaphoreInfos != nullptr) {
                for (uint32_t signalSemaphoreInfoIndex = 0;
                     signalSemaphoreInfoIndex < pSubmits[submitIndex].signalSemaphoreInfoCount; ++signalSemaphoreInfoIndex) {
                    [[maybe_unused]] const Location pSignalSemaphoreInfos_loc =
                        pSubmits_loc.dot(Field::pSignalSemaphoreInfos, signalSemaphoreInfoIndex);
                    skip |= ValidateStructPnext(pSignalSemaphoreInfos_loc,
                                                pSubmits[submitIndex].pSignalSemaphoreInfos[signalSemaphoreInfoIndex].pNext, 0,
                                                nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreSubmitInfo-pNext-pNext",
                                                kVUIDUndefined, false, true);

                    skip |= ValidateRequiredHandle(pSignalSemaphoreInfos_loc.dot(Field::semaphore),
                                                   pSubmits[submitIndex].pSignalSemaphoreInfos[signalSemaphoreInfoIndex].semaphore);

                    skip |= ValidateFlags(pSignalSemaphoreInfos_loc.dot(Field::stageMask), "VkPipelineStageFlagBits2",
                                          AllVkPipelineStageFlagBits2,
                                          pSubmits[submitIndex].pSignalSemaphoreInfos[signalSemaphoreInfoIndex].stageMask,
                                          kOptionalFlags, "VUID-VkSemaphoreSubmitInfo-stageMask-parameter");
                }
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo,
                                                        const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCopyBufferInfo), "VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2", pCopyBufferInfo,
                               VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2, true, "VUID-vkCmdCopyBuffer2-pCopyBufferInfo-parameter",
                               "VUID-VkCopyBufferInfo2-sType-sType");
    if (pCopyBufferInfo != nullptr) {
        [[maybe_unused]] const Location pCopyBufferInfo_loc = loc.dot(Field::pCopyBufferInfo);
        skip |= ValidateStructPnext(pCopyBufferInfo_loc, pCopyBufferInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkCopyBufferInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pCopyBufferInfo_loc.dot(Field::srcBuffer), pCopyBufferInfo->srcBuffer);

        skip |= ValidateRequiredHandle(pCopyBufferInfo_loc.dot(Field::dstBuffer), pCopyBufferInfo->dstBuffer);

        skip |=
            ValidateStructTypeArray(pCopyBufferInfo_loc.dot(Field::regionCount), pCopyBufferInfo_loc.dot(Field::pRegions),
                                    "VK_STRUCTURE_TYPE_BUFFER_COPY_2", pCopyBufferInfo->regionCount, pCopyBufferInfo->pRegions,
                                    VK_STRUCTURE_TYPE_BUFFER_COPY_2, true, true, "VUID-VkBufferCopy2-sType-sType",
                                    "VUID-VkCopyBufferInfo2-pRegions-parameter", "VUID-VkCopyBufferInfo2-regionCount-arraylength");

        if (pCopyBufferInfo->pRegions != nullptr) {
            for (uint32_t regionIndex = 0; regionIndex < pCopyBufferInfo->regionCount; ++regionIndex) {
                [[maybe_unused]] const Location pRegions_loc = pCopyBufferInfo_loc.dot(Field::pRegions, regionIndex);
                skip |= ValidateStructPnext(pRegions_loc, pCopyBufferInfo->pRegions[regionIndex].pNext, 0, nullptr,
                                            GeneratedVulkanHeaderVersion, "VUID-VkBufferCopy2-pNext-pNext", kVUIDUndefined, false,
                                            true);
            }
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, error_obj);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCopyImageInfo), "VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2", pCopyImageInfo,
                               VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2, true, "VUID-vkCmdCopyImage2-pCopyImageInfo-parameter",
                               "VUID-VkCopyImageInfo2-sType-sType");
    if (pCopyImageInfo != nullptr) {
        [[maybe_unused]] const Location pCopyImageInfo_loc = loc.dot(Field::pCopyImageInfo);
        skip |= ValidateStructPnext(pCopyImageInfo_loc, pCopyImageInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                    "VUID-VkCopyImageInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pCopyImageInfo_loc.dot(Field::srcImage), pCopyImageInfo->srcImage);

        skip |= ValidateRangedEnum(pCopyImageInfo_loc.dot(Field::srcImageLayout), "VkImageLayout", pCopyImageInfo->srcImageLayout,
                                   "VUID-VkCopyImageInfo2-srcImageLayout-parameter");

        skip |= ValidateRequiredHandle(pCopyImageInfo_loc.dot(Field::dstImage), pCopyImageInfo->dstImage);

        skip |= ValidateRangedEnum(pCopyImageInfo_loc.dot(Field::dstImageLayout), "VkImageLayout", pCopyImageInfo->dstImageLayout,
                                   "VUID-VkCopyImageInfo2-dstImageLayout-parameter");

        skip |=
            ValidateStructTypeArray(pCopyImageInfo_loc.dot(Field::regionCount), pCopyImageInfo_loc.dot(Field::pRegions),
                                    "VK_STRUCTURE_TYPE_IMAGE_COPY_2", pCopyImageInfo->regionCount, pCopyImageInfo->pRegions,
                                    VK_STRUCTURE_TYPE_IMAGE_COPY_2, true, true, "VUID-VkImageCopy2-sType-sType",
                                    "VUID-VkCopyImageInfo2-pRegions-parameter", "VUID-VkCopyImageInfo2-regionCount-arraylength");

        if (pCopyImageInfo->pRegions != nullptr) {
            for (uint32_t regionIndex = 0; regionIndex < pCopyImageInfo->regionCount; ++regionIndex) {
                [[maybe_unused]] const Location pRegions_loc = pCopyImageInfo_loc.dot(Field::pRegions, regionIndex);
                skip |=
                    ValidateStructPnext(pRegions_loc, pCopyImageInfo->pRegions[regionIndex].pNext, 0, nullptr,
                                        GeneratedVulkanHeaderVersion, "VUID-VkImageCopy2-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      pCopyImageInfo->pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags,
                                      "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                      "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      pCopyImageInfo->pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags,
                                      "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                      "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBufferToImage2(VkCommandBuffer commandBuffer,
                                                               const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo,
                                                               const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCopyBufferToImageInfo), "VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2",
                               pCopyBufferToImageInfo, VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2, true,
                               "VUID-vkCmdCopyBufferToImage2-pCopyBufferToImageInfo-parameter",
                               "VUID-VkCopyBufferToImageInfo2-sType-sType");
    if (pCopyBufferToImageInfo != nullptr) {
        [[maybe_unused]] const Location pCopyBufferToImageInfo_loc = loc.dot(Field::pCopyBufferToImageInfo);
        skip |=
            ValidateStructPnext(pCopyBufferToImageInfo_loc, pCopyBufferToImageInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                "VUID-VkCopyBufferToImageInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pCopyBufferToImageInfo_loc.dot(Field::srcBuffer), pCopyBufferToImageInfo->srcBuffer);

        skip |= ValidateRequiredHandle(pCopyBufferToImageInfo_loc.dot(Field::dstImage), pCopyBufferToImageInfo->dstImage);

        skip |=
            ValidateRangedEnum(pCopyBufferToImageInfo_loc.dot(Field::dstImageLayout), "VkImageLayout",
                               pCopyBufferToImageInfo->dstImageLayout, "VUID-VkCopyBufferToImageInfo2-dstImageLayout-parameter");

        skip |= ValidateStructTypeArray(
            pCopyBufferToImageInfo_loc.dot(Field::regionCount), pCopyBufferToImageInfo_loc.dot(Field::pRegions),
            "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", pCopyBufferToImageInfo->regionCount, pCopyBufferToImageInfo->pRegions,
            VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2, true, true, "VUID-VkBufferImageCopy2-sType-sType",
            "VUID-VkCopyBufferToImageInfo2-pRegions-parameter", "VUID-VkCopyBufferToImageInfo2-regionCount-arraylength");

        if (pCopyBufferToImageInfo->pRegions != nullptr) {
            for (uint32_t regionIndex = 0; regionIndex < pCopyBufferToImageInfo->regionCount; ++regionIndex) {
                [[maybe_unused]] const Location pRegions_loc = pCopyBufferToImageInfo_loc.dot(Field::pRegions, regionIndex);
                constexpr std::array allowed_structs_VkBufferImageCopy2 = {VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM};

                skip |= ValidateStructPnext(pRegions_loc, pCopyBufferToImageInfo->pRegions[regionIndex].pNext,
                                            allowed_structs_VkBufferImageCopy2.size(), allowed_structs_VkBufferImageCopy2.data(),
                                            GeneratedVulkanHeaderVersion, "VUID-VkBufferImageCopy2-pNext-pNext",
                                            "VUID-VkBufferImageCopy2-sType-unique", false, true);

                skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      pCopyBufferToImageInfo->pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags,
                                      "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                      "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImageToBuffer2(VkCommandBuffer commandBuffer,
                                                               const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo,
                                                               const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pCopyImageToBufferInfo), "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2",
                               pCopyImageToBufferInfo, VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2, true,
                               "VUID-vkCmdCopyImageToBuffer2-pCopyImageToBufferInfo-parameter",
                               "VUID-VkCopyImageToBufferInfo2-sType-sType");
    if (pCopyImageToBufferInfo != nullptr) {
        [[maybe_unused]] const Location pCopyImageToBufferInfo_loc = loc.dot(Field::pCopyImageToBufferInfo);
        skip |=
            ValidateStructPnext(pCopyImageToBufferInfo_loc, pCopyImageToBufferInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion,
                                "VUID-VkCopyImageToBufferInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle(pCopyImageToBufferInfo_loc.dot(Field::srcImage), pCopyImageToBufferInfo->srcImage);

        skip |=
            ValidateRangedEnum(pCopyImageToBufferInfo_loc.dot(Field::srcImageLayout), "VkImageLayout",
                               pCopyImageToBufferInfo->srcImageLayout, "VUID-VkCopyImageToBufferInfo2-srcImageLayout-parameter");

        skip |= ValidateRequiredHandle(pCopyImageToBufferInfo_loc.dot(Field::dstBuffer), pCopyImageToBufferInfo->dstBuffer);

        skip |= ValidateStructTypeArray(
            pCopyImageToBufferInfo_loc.dot(Field::regionCount), pCopyImageToBufferInfo_loc.dot(Field::pRegions),
            "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", pCopyImageToBufferInfo->regionCount, pCopyImageToBufferInfo->pRegions,
            VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2, true, true, "VUID-VkBufferImageCopy2-sType-sType",
            "VUID-VkCopyImageToBufferInfo2-pRegions-parameter", "VUID-VkCopyImageToBufferInfo2-regionCount-arraylength");

        if (pCopyImageToBufferInfo->pRegions != nullptr) {
            for (uint32_t regionIndex = 0; regionIndex < pCopyImageToBufferInfo->regionCount; ++regionIndex) {
                [[maybe_unused]] const Location pRegions_loc = pCopyImageToBufferInfo_loc.dot(Field::pRegions, regionIndex);
                constexpr std::array allowed_structs_VkBufferImageCopy2 = {VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM};

                skip |= ValidateStructPnext(pRegions_loc, pCopyImageToBufferInfo->pRegions[regionIndex].pNext,
                                            allowed_structs_VkBufferImageCopy2.size(), allowed_structs_VkBufferImageCopy2.data(),
                                            GeneratedVulkanHeaderVersion, "VUID-VkBufferImageCopy2-pNext-pNext",
                                            "VUID-VkBufferImageCopy2-sType-unique", false, true);

                skip |= ValidateFlags(pRegions_loc.dot(Field::aspectMask), "VkImageAspectFlagBits", AllVkImageAspectFlagBits,
                                      pCopyImageToBufferInfo->pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags,
                                      "VUID-VkImageSubresourceLayers-aspectMask-parameter",
                                      "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo,
                                                       const ErrorObject& error_obj) const {
    bool skip = false;
    [[maybe_unused]] const Location loc = error_obj.location;
    skip |= ValidateStructType(loc.dot(Field::pBlitImageInfo), "VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2", pBlitImageInfo,
                               VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2, true, "VUID-vkCmdBlitImage2-pBlitImageInfo-parameter",
                               "VUID-VkBlitImageInfo2-sType-sType");
    if (pBlitImageInfo != nullptr) {
        [[maybe_unused]] const Location pBlitImageInfo_loc = loc.dot(Field::pBlitImageInfo);
        constexpr std::array allowed_structs_VkBlitImageInfo2 = {VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM};

        skip |= ValidateStructPnext(pBlitImageInfo_loc, pBlitImageInfo->pNext, allowed_structs_VkBlitImageInfo2.size(),
                                    allowed_structs_VkBlitImageInfo2.data(), GeneratedVulkanHeaderVersion,
                                    "VUID-VkBlitImageInfo2-pNext-pNext", "VUID-VkBlitImageInfo2-sType-unique", false, true);

        skip |= ValidateRequiredHandle(pBlitImageInfo_loc.dot(Field::srcImage), pBlitImageInfo->srcImage);

        skip |= ValidateRangedEnum(pBlitImageInfo_loc.dot(Field::srcImageLayout), "VkImageLayout"