/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.particle;

import java.util.HashMap;
import org.j3d.geom.particle.PolylineEmitter;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeComponentListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticleEmitterNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.particle.BaseEmitter;

public abstract class BasePolylineEmitter
extends BaseEmitter
implements VRMLNodeComponentListener {
    protected static final int FIELD_COORDS = 5;
    protected static final int FIELD_COORDINDEX = 6;
    protected static final int FIELD_SET_COORDINDEX = 7;
    protected static final int FIELD_DIRECTION = 8;
    protected static final int LAST_LINE_EMITTER_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    protected static final String COORD_PROTO_MSG = "Proto does not describe a Coord object";
    protected static final String COORD_NODE_MSG = "Node does not describe a Coord object";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected VRMLProtoInstance pCoord;
    protected VRMLCoordinateNodeType vfCoord;
    protected int[] vfCoordIndex;
    protected int numCoordIndex;
    protected float[] vfDirection;
    private float[] coordTmp;

    protected BasePolylineEmitter() {
        super("PolylineEmitter");
        this.hasChanged = new boolean[9];
        this.vfDirection = new float[]{0.0f, 1.0f, 0.0f};
        this.vfCoordIndex = FieldConstants.EMPTY_MFINT32;
        this.numCoordIndex = 0;
        this.initializer = new PolylineEmitter();
        ((PolylineEmitter)this.initializer).setDirection(0.0f, 1.0f, 0.0f);
        this.initializer.setMass(this.vfMass);
        this.initializer.setSurfaceArea(this.vfSurfaceArea);
        this.initializer.setSpeed(this.vfSpeed);
        this.initializer.setParticleVariation(this.vfVariation);
    }

    public BasePolylineEmitter(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLParticleEmitterNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("direction");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirection[0] = vRMLFieldData.floatArrayValue[0];
            this.vfDirection[1] = vRMLFieldData.floatArrayValue[1];
            this.vfDirection[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("coordIndex");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfCoordIndex = new int[vRMLFieldData.numElements];
                this.numCoordIndex = vRMLFieldData.numElements;
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfCoordIndex, 0, vRMLFieldData.numElements);
            }
            ((PolylineEmitter)this.initializer).setDirection(this.vfDirection[0], this.vfDirection[1], this.vfDirection[2]);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        this.updateLineCoords();
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pCoord != null ? this.pCoord : this.vfCoord;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfCoordIndex;
                vRMLFieldData.numElements = this.numCoordIndex;
                vRMLFieldData.dataType = (short)9;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfDirection;
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pCoord != null) {
            this.pCoord.setupFinished();
        } else if (this.vfCoord != null) {
            this.vfCoord.setupFinished();
        }
        if (this.numCoordIndex != 0) {
            this.updateLineCoords();
        }
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfCoord);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfDirection, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 7: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Attempting to write an inputOnly field at setup time");
                }
                this.setCoordIndex(nArray, n2);
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Attempting to write an initializeOnly field at runtime");
                }
                this.vfCoordIndex = nArray;
                this.numCoordIndex = n2;
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 8: {
                this.setDirection(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setCoord(n, vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setCoordIndex(int[] nArray, int n) {
        this.vfCoordIndex = nArray;
        this.numCoordIndex = n;
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
        }
    }

    protected void setCoord(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        if (vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
            vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
        } else {
            vRMLProtoInstance = null;
        }
        if (this.vfCoord != null) {
            this.vfCoord.removeComponentListener(this);
        }
        this.pCoord = vRMLProtoInstance;
        this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
        if (this.vfCoord != null) {
            this.vfCoord.addComponentListener(this);
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    protected void setDirection(float[] fArray) {
        this.vfDirection[0] = fArray[0];
        this.vfDirection[1] = fArray[1];
        this.vfDirection[2] = fArray[2];
        ((PolylineEmitter)this.initializer).setDirection(fArray[0], fArray[1], fArray[2]);
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void updateLineCoords() {
        if (this.vfCoord == null) {
            return;
        }
        if (this.coordTmp == null || this.coordTmp.length < this.numCoordIndex * 3) {
            this.coordTmp = new float[this.numCoordIndex * 3];
        }
        float[] fArray = this.vfCoord.getPointRef();
        for (int i = 0; i < this.numCoordIndex; ++i) {
            this.coordTmp[i * 3] = fArray[this.vfCoordIndex[i] * 3];
            this.coordTmp[i * 3 + 1] = fArray[this.vfCoordIndex[i] * 3 + 1];
            this.coordTmp[i * 3 + 2] = fArray[this.vfCoordIndex[i] * 3 + 2];
        }
        ((PolylineEmitter)this.initializer).setEmitterLine(this.coordTmp, this.numCoordIndex);
    }

    static {
        nodeFields = new int[]{5, 0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BasePolylineEmitter.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePolylineEmitter.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFNode", "coords");
        BasePolylineEmitter.fieldDecl[6] = new VRMLFieldDeclaration(2, "MFInt32", "coordIndex");
        BasePolylineEmitter.fieldDecl[7] = new VRMLFieldDeclaration(1, "MFInt32", "set_coordIndex");
        BasePolylineEmitter.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        BasePolylineEmitter.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFFloat", "variation");
        BasePolylineEmitter.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "speed");
        BasePolylineEmitter.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFFloat", "mass");
        BasePolylineEmitter.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFFloat", "surfaceArea");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(5);
        fieldMap.put("coords", n);
        fieldMap.put("set_coords", n);
        fieldMap.put("coords_changed", n);
        fieldMap.put("coordIndex", new Integer(6));
        n = new Integer(8);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
        n = new Integer(1);
        fieldMap.put("speed", n);
        fieldMap.put("set_speed", n);
        fieldMap.put("speed_changed", n);
        n = new Integer(4);
        fieldMap.put("variation", n);
        fieldMap.put("set_variation", n);
        fieldMap.put("variation_changed", n);
        n = new Integer(2);
        fieldMap.put("mass", n);
        fieldMap.put("set_mass", n);
        fieldMap.put("mass_changed", n);
        n = new Integer(3);
        fieldMap.put("surfaceArea", n);
        fieldMap.put("set_surfaceArea", n);
        fieldMap.put("surfaceArea_changed", n);
        fieldMap.put("set_coordIndex", new Integer(7));
    }
}

