package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayRouteTableEntryAttribute invokes the vpc.UpdateGatewayRouteTableEntryAttribute API synchronously
func (client *Client) UpdateGatewayRouteTableEntryAttribute(request *UpdateGatewayRouteTableEntryAttributeRequest) (response *UpdateGatewayRouteTableEntryAttributeResponse, err error) {
	response = CreateUpdateGatewayRouteTableEntryAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayRouteTableEntryAttributeWithChan invokes the vpc.UpdateGatewayRouteTableEntryAttribute API asynchronously
func (client *Client) UpdateGatewayRouteTableEntryAttributeWithChan(request *UpdateGatewayRouteTableEntryAttributeRequest) (<-chan *UpdateGatewayRouteTableEntryAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayRouteTableEntryAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayRouteTableEntryAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayRouteTableEntryAttributeWithCallback invokes the vpc.UpdateGatewayRouteTableEntryAttribute API asynchronously
func (client *Client) UpdateGatewayRouteTableEntryAttributeWithCallback(request *UpdateGatewayRouteTableEntryAttributeRequest, callback func(response *UpdateGatewayRouteTableEntryAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayRouteTableEntryAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayRouteTableEntryAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayRouteTableEntryAttributeRequest is the request struct for api UpdateGatewayRouteTableEntryAttribute
type UpdateGatewayRouteTableEntryAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken             string           `position:"Query" name:"ClientToken"`
	Description             string           `position:"Query" name:"Description"`
	IPv4GatewayRouteTableId string           `position:"Query" name:"IPv4GatewayRouteTableId"`
	NextHopId               string           `position:"Query" name:"NextHopId"`
	NextHopType             string           `position:"Query" name:"NextHopType"`
	DryRun                  requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	DestinationCidrBlock    string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	Name                    string           `position:"Query" name:"Name"`
}

// UpdateGatewayRouteTableEntryAttributeResponse is the response struct for api UpdateGatewayRouteTableEntryAttribute
type UpdateGatewayRouteTableEntryAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateGatewayRouteTableEntryAttributeRequest creates a request to invoke UpdateGatewayRouteTableEntryAttribute API
func CreateUpdateGatewayRouteTableEntryAttributeRequest() (request *UpdateGatewayRouteTableEntryAttributeRequest) {
	request = &UpdateGatewayRouteTableEntryAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateGatewayRouteTableEntryAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayRouteTableEntryAttributeResponse creates a response to parse from UpdateGatewayRouteTableEntryAttribute response
func CreateUpdateGatewayRouteTableEntryAttributeResponse() (response *UpdateGatewayRouteTableEntryAttributeResponse) {
	response = &UpdateGatewayRouteTableEntryAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
