[comment {-*- tcl -*- doctools manpage}]
[manpage_begin base32::core n 0.1]
[keywords base32]
[copyright {Public domain}]
[moddesc   {Base32 encoding}]
[titledesc {Expanding basic base32 maps}]
[category  {Text processing}]
[require Tcl 8.4]
[require base32::core [opt 0.1]]
[description]
[para]

This package provides generic commands for the construction of full
base32 mappings from a basic mapping listing just the codes and
associated characters. The full mappings, regular and inverse, created
here map to and from bit sequences, and also handle the partial
mappings at the end of a string.

[para]

This is in essence an internal package to be used by implementors of a
base32 en- and decoder. A regular user has no need of this package at
all.

[section API]

[list_begin definitions]

[call [cmd ::base32::core::define] [arg map] [arg forwvar] [arg backwvar] [arg ivar]]

This command computes full forward and backward (inverse) mappings
from the basic [arg map] and stores them in the variables named by
[arg forwvar] and [arg backwvar] resp. It also constructs a regexp
pattern for the detection of invalid characters in supposedly base32
encoded input and stores it in the variable named by [arg ivar].

[call [cmd ::base32::core::valid] [arg string] [arg pattern] [arg mvar]]

This command checks if the input [arg string] is a valid base32
encoded string, based on the [arg pattern] of invalid characters as
generated by [cmd ::base32::core::define], and some other general
rules.

[para]

The result of the command is a boolean flag. Its value is [const True]
for a valid [arg string], and [const False] otherwise. In the latter
case an error message describing the problem with the input is stored
into the variable named by [arg mvar]. The variable is not touched if
the input was found to be valid.

[para]

The rules checked by the command, beyond rejection of bad characters,
are:

[list_begin enumerated]
[enum] The length of the input is not a multiple of eight,
[enum] The padding appears not at the end of input, but in the middle,
[enum] The padding has not of length six, four, three, or one characters,
[list_end]
[list_end]

[vset CATEGORY base32]
[include ../common-text/feedback.inc]
[manpage_end]
