/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.ArrayList;
import java.util.List;
import uk.me.nxg.unity.Dimensions;
import uk.me.nxg.unity.SimpleUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnwritableExpression;

public abstract class OneUnit
implements Comparable<OneUnit> {
    private final float exponent;
    private final boolean isQuoted;

    protected OneUnit(float f, boolean bl) {
        if ((double)f == 0.0) {
            throw new IllegalArgumentException("Unit exponent cannot be zero");
        }
        this.exponent = f;
        this.isQuoted = bl;
    }

    protected OneUnit(float f) {
        this(f, false);
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    abstract OneUnit reciprocate();

    abstract OneUnit pow(double var1);

    public abstract int getPrefix();

    public abstract UnitDefinition getBaseUnitDefinition();

    public abstract String getBaseUnitName();

    abstract String getBaseUnitString();

    public abstract Dimensions getDimensions();

    public float getExponent() {
        return this.exponent;
    }

    public boolean wasGuessed() {
        return false;
    }

    abstract UnitDefinitionMap.Resolver getUnitResolver();

    public abstract boolean isRecognisedUnit(Syntax var1);

    public abstract boolean isRecognisedUnit();

    public abstract boolean isRecommendedUnit(Syntax var1);

    public abstract boolean satisfiesUsageConstraints(Syntax var1);

    public abstract String toString();

    public abstract String toString(Syntax var1) throws UnwritableExpression;

    public abstract String unitString(Syntax var1) throws UnwritableExpression;

    public abstract String getOriginalUnitString();

    public abstract String toDebugString();

    public static List<OneUnit> reciprocate(Iterable<OneUnit> iterable) {
        ArrayList<OneUnit> arrayList = new ArrayList<OneUnit>();
        for (OneUnit oneUnit : iterable) {
            arrayList.add(oneUnit.reciprocate());
        }
        return arrayList;
    }

    public static List<OneUnit> divide(List<OneUnit> list, Iterable<OneUnit> iterable) {
        ArrayList<OneUnit> arrayList = new ArrayList<OneUnit>(list);
        for (OneUnit oneUnit : iterable) {
            arrayList.add(oneUnit.reciprocate());
        }
        return arrayList;
    }

    @Override
    public abstract int compareTo(OneUnit var1);

    static class Maker {
        final UnitDefinitionMap.Resolver unitResolver;
        private boolean guessUnits = false;

        Maker(UnitDefinitionMap.Resolver resolver) {
            if (resolver == null) {
                throw new IllegalArgumentException("Can't make SimpleUnit.Maker with null resolver");
            }
            this.unitResolver = resolver;
        }

        public SimpleUnit make(String string, int n) {
            return SimpleUnit.makeSimpleUnit(this.unitResolver, string, n, this.guessUnits);
        }

        public SimpleUnit make(String string, double d) {
            return SimpleUnit.makeSimpleUnit(this.unitResolver, string, (float)d, this.guessUnits);
        }

        public SimpleUnit makeQuotedUnit(String string, String string2, double d) {
            try {
                return SimpleUnit.makeQuotedSimpleUnit(this.unitResolver, string, string2, (float)d);
            }
            catch (UnitParserException unitParserException) {
                return null;
            }
        }

        public void setGuessing(boolean bl) {
            this.guessUnits = bl;
        }
    }
}

