/*
  File autogenerated by gengetopt version 2.22.5
  generated with the following command:
  gengetopt -C --unamed-opts=URL --output-dir src/quvi --no-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: quvi [OPTIONS]... [URL]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                   Print help and exit",
  "      --version                Print version and exit",
  "      --license                Print license and exit",
  "      --support                Print supported websites and exit",
  "  -F, --query-formats          Query available formats to URL",
  "      --agent=value            Identify as  (default=`Mozilla/5.0')",
  "      --proxy=value            Use proxy with HTTP connections",
  "      --connect-timeout=value  Seconds connecting allowed to take  \n                                 (default=`30')",
  "      --exec=value             Execute command when done parsing",
  "  -f, --format=value           Query for format of media  (default=`default')",
  "  -v, --verbosity=value        Verbosity level of printed messages  (possible \n                                 values=\"debug\", \"verbose\", \"quiet\", \n                                 \"mute\" default=`verbose')",
  "  -c, --category=value         Level of libquvi scripts to enable  (possible \n                                 values=\"http\", \"mms\", \"rtsp\", \"rtmp\", \n                                 \"all\" default=`all')",
  "  -d, --export-format=value    Export in data interchange format  (possible \n                                 values=\"json\", \"xml\" default=`json')",
  "  -l, --export-level=value     Level of exported data  (possible \n                                 values=\"media\", \"+errors\" default=`media')",
  "  -e, --feature=value          Enable (or disable) feature  (possible \n                                 values=\"resolve\", \"-resolve\", \"verify\", \n                                 \"-verify\", \"proxy\", \"-proxy\")",
  "\nDeprecated:",
  "  -a, --category-all           All website script categories",
  "      --category-http          Category HTTP website scripts",
  "      --category-mms           Category MMS website scripts",
  "      --category-rtsp          Category RTSP website scripts",
  "      --category-rtmp          Category RTMP website scripts",
  "      --xml                    Print details in XML",
  "  -q, --quiet                  Turn off output to stderr",
  "      --verbose-libcurl        Turn on libcurl verbose mode",
  "  -r, --no-resolve             Do not resolve redirections",
  "  -n, --no-verify              Do not verify media URL",
  "      --no-proxy               Disable use of HTTP proxy",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *cmdline_parser_verbosity_values[] = {"debug", "verbose", "quiet", "mute", 0}; /*< Possible values for verbosity. */
const char *cmdline_parser_category_values[] = {"http", "mms", "rtsp", "rtmp", "all", 0}; /*< Possible values for category. */
const char *cmdline_parser_export_format_values[] = {"json", "xml", 0}; /*< Possible values for export-format. */
const char *cmdline_parser_export_level_values[] = {"media", "+errors", 0}; /*< Possible values for export-level. */
const char *cmdline_parser_feature_values[] = {"resolve", "-resolve", "verify", "-verify", "proxy", "-proxy", 0}; /*< Possible values for feature. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->license_given = 0 ;
  args_info->support_given = 0 ;
  args_info->query_formats_given = 0 ;
  args_info->agent_given = 0 ;
  args_info->proxy_given = 0 ;
  args_info->connect_timeout_given = 0 ;
  args_info->exec_given = 0 ;
  args_info->format_given = 0 ;
  args_info->verbosity_given = 0 ;
  args_info->category_given = 0 ;
  args_info->export_format_given = 0 ;
  args_info->export_level_given = 0 ;
  args_info->feature_given = 0 ;
  args_info->category_all_given = 0 ;
  args_info->category_http_given = 0 ;
  args_info->category_mms_given = 0 ;
  args_info->category_rtsp_given = 0 ;
  args_info->category_rtmp_given = 0 ;
  args_info->xml_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->verbose_libcurl_given = 0 ;
  args_info->no_resolve_given = 0 ;
  args_info->no_verify_given = 0 ;
  args_info->no_proxy_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->agent_arg = gengetopt_strdup ("Mozilla/5.0");
  args_info->agent_orig = NULL;
  args_info->proxy_arg = NULL;
  args_info->proxy_orig = NULL;
  args_info->connect_timeout_arg = 30;
  args_info->connect_timeout_orig = NULL;
  args_info->exec_arg = NULL;
  args_info->exec_orig = NULL;
  args_info->format_arg = gengetopt_strdup ("default");
  args_info->format_orig = NULL;
  args_info->verbosity_arg = verbosity_arg_verbose;
  args_info->verbosity_orig = NULL;
  args_info->category_arg = NULL;
  args_info->category_orig = NULL;
  args_info->export_format_arg = export_format_arg_json;
  args_info->export_format_orig = NULL;
  args_info->export_level_arg = export_level_arg_media;
  args_info->export_level_orig = NULL;
  args_info->feature_arg = NULL;
  args_info->feature_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->license_help = gengetopt_args_info_help[2] ;
  args_info->support_help = gengetopt_args_info_help[3] ;
  args_info->query_formats_help = gengetopt_args_info_help[4] ;
  args_info->agent_help = gengetopt_args_info_help[5] ;
  args_info->proxy_help = gengetopt_args_info_help[6] ;
  args_info->connect_timeout_help = gengetopt_args_info_help[7] ;
  args_info->exec_help = gengetopt_args_info_help[8] ;
  args_info->exec_min = 0;
  args_info->exec_max = 0;
  args_info->format_help = gengetopt_args_info_help[9] ;
  args_info->verbosity_help = gengetopt_args_info_help[10] ;
  args_info->category_help = gengetopt_args_info_help[11] ;
  args_info->category_min = 0;
  args_info->category_max = 0;
  args_info->export_format_help = gengetopt_args_info_help[12] ;
  args_info->export_level_help = gengetopt_args_info_help[13] ;
  args_info->feature_help = gengetopt_args_info_help[14] ;
  args_info->feature_min = 0;
  args_info->feature_max = 0;
  args_info->category_all_help = gengetopt_args_info_help[16] ;
  args_info->category_http_help = gengetopt_args_info_help[17] ;
  args_info->category_mms_help = gengetopt_args_info_help[18] ;
  args_info->category_rtsp_help = gengetopt_args_info_help[19] ;
  args_info->category_rtmp_help = gengetopt_args_info_help[20] ;
  args_info->xml_help = gengetopt_args_info_help[21] ;
  args_info->quiet_help = gengetopt_args_info_help[22] ;
  args_info->verbose_libcurl_help = gengetopt_args_info_help[23] ;
  args_info->no_resolve_help = gengetopt_args_info_help[24] ;
  args_info->no_verify_help = gengetopt_args_info_help[25] ;
  args_info->no_proxy_help = gengetopt_args_info_help[26] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}

/**
 * The passed arg parameter is NOT set to 0 from this function
 */
static void
free_multiple_field(unsigned int len, void *arg, char ***orig)
{
  unsigned int i;
  if (arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*orig)[i]));
      }

    free (arg);
    free (*orig);
    *orig = 0;
  }
}

static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->agent_arg));
  free_string_field (&(args_info->agent_orig));
  free_string_field (&(args_info->proxy_arg));
  free_string_field (&(args_info->proxy_orig));
  free_string_field (&(args_info->connect_timeout_orig));
  free_multiple_string_field (args_info->exec_given, &(args_info->exec_arg), &(args_info->exec_orig));
  free_string_field (&(args_info->format_arg));
  free_string_field (&(args_info->format_orig));
  free_string_field (&(args_info->verbosity_orig));
  free_multiple_field (args_info->category_given, (void *)(args_info->category_arg), &(args_info->category_orig));
  args_info->category_arg = 0;
  free_string_field (&(args_info->export_format_orig));
  free_string_field (&(args_info->export_level_orig));
  free_multiple_field (args_info->feature_given, (void *)(args_info->feature_arg), &(args_info->feature_orig));
  args_info->feature_arg = 0;
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->license_given)
    write_into_file(outfile, "license", 0, 0 );
  if (args_info->support_given)
    write_into_file(outfile, "support", 0, 0 );
  if (args_info->query_formats_given)
    write_into_file(outfile, "query-formats", 0, 0 );
  if (args_info->agent_given)
    write_into_file(outfile, "agent", args_info->agent_orig, 0);
  if (args_info->proxy_given)
    write_into_file(outfile, "proxy", args_info->proxy_orig, 0);
  if (args_info->connect_timeout_given)
    write_into_file(outfile, "connect-timeout", args_info->connect_timeout_orig, 0);
  write_multiple_into_file(outfile, args_info->exec_given, "exec", args_info->exec_orig, 0);
  if (args_info->format_given)
    write_into_file(outfile, "format", args_info->format_orig, 0);
  if (args_info->verbosity_given)
    write_into_file(outfile, "verbosity", args_info->verbosity_orig, cmdline_parser_verbosity_values);
  write_multiple_into_file(outfile, args_info->category_given, "category", args_info->category_orig, cmdline_parser_category_values);
  if (args_info->export_format_given)
    write_into_file(outfile, "export-format", args_info->export_format_orig, cmdline_parser_export_format_values);
  if (args_info->export_level_given)
    write_into_file(outfile, "export-level", args_info->export_level_orig, cmdline_parser_export_level_values);
  write_multiple_into_file(outfile, args_info->feature_given, "feature", args_info->feature_orig, cmdline_parser_feature_values);
  if (args_info->category_all_given)
    write_into_file(outfile, "category-all", 0, 0 );
  if (args_info->category_http_given)
    write_into_file(outfile, "category-http", 0, 0 );
  if (args_info->category_mms_given)
    write_into_file(outfile, "category-mms", 0, 0 );
  if (args_info->category_rtsp_given)
    write_into_file(outfile, "category-rtsp", 0, 0 );
  if (args_info->category_rtmp_given)
    write_into_file(outfile, "category-rtmp", 0, 0 );
  if (args_info->xml_given)
    write_into_file(outfile, "xml", 0, 0 );
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  if (args_info->verbose_libcurl_given)
    write_into_file(outfile, "verbose-libcurl", 0, 0 );
  if (args_info->no_resolve_given)
    write_into_file(outfile, "no-resolve", 0, 0 );
  if (args_info->no_verify_given)
    write_into_file(outfile, "no-verify", 0, 0 );
  if (args_info->no_proxy_given)
    write_into_file(outfile, "no-proxy", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error = 1;
            }
        }
    }
    
  return error;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->exec_given, args_info->exec_min, args_info->exec_max, "'--exec'"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->category_given, args_info->category_min, args_info->category_max, "'--category' ('-c')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->feature_given, args_info->feature_min, args_info->feature_max, "'--feature' ('-e')"))
     error = 1;
  
  
  /* checks for dependences among options */

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
    case ARG_ENUM:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_ENUM:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
      case ARG_ENUM:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  union generic_value multiple_default_value;

  struct generic_list * exec_list = NULL;
  struct generic_list * category_list = NULL;
  struct generic_list * feature_list = NULL;
  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 0 },
        { "license",	0, NULL, 0 },
        { "support",	0, NULL, 0 },
        { "query-formats",	0, NULL, 'F' },
        { "agent",	1, NULL, 0 },
        { "proxy",	1, NULL, 0 },
        { "connect-timeout",	1, NULL, 0 },
        { "exec",	1, NULL, 0 },
        { "format",	1, NULL, 'f' },
        { "verbosity",	1, NULL, 'v' },
        { "category",	1, NULL, 'c' },
        { "export-format",	1, NULL, 'd' },
        { "export-level",	1, NULL, 'l' },
        { "feature",	1, NULL, 'e' },
        { "category-all",	0, NULL, 'a' },
        { "category-http",	0, NULL, 0 },
        { "category-mms",	0, NULL, 0 },
        { "category-rtsp",	0, NULL, 0 },
        { "category-rtmp",	0, NULL, 0 },
        { "xml",	0, NULL, 0 },
        { "quiet",	0, NULL, 'q' },
        { "verbose-libcurl",	0, NULL, 0 },
        { "no-resolve",	0, NULL, 'r' },
        { "no-verify",	0, NULL, 'n' },
        { "no-proxy",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hFf:v:c:d:l:e:aqrn", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'F':	/* Query available formats to URL.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->query_formats_given),
              &(local_args_info.query_formats_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "query-formats", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Query for format of media.  */
        
        
          if (update_arg( (void *)&(args_info->format_arg), 
               &(args_info->format_orig), &(args_info->format_given),
              &(local_args_info.format_given), optarg, 0, "default", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "format", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Verbosity level of printed messages.  */
        
        
          if (update_arg( (void *)&(args_info->verbosity_arg), 
               &(args_info->verbosity_orig), &(args_info->verbosity_given),
              &(local_args_info.verbosity_given), optarg, cmdline_parser_verbosity_values, "verbose", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "verbosity", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Level of libquvi scripts to enable.  */
        
          if (update_multiple_arg_temp(&category_list, 
              &(local_args_info.category_given), optarg, cmdline_parser_category_values, "all", ARG_ENUM,
              "category", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Export in data interchange format.  */
        
        
          if (update_arg( (void *)&(args_info->export_format_arg), 
               &(args_info->export_format_orig), &(args_info->export_format_given),
              &(local_args_info.export_format_given), optarg, cmdline_parser_export_format_values, "json", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "export-format", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Level of exported data.  */
        
        
          if (update_arg( (void *)&(args_info->export_level_arg), 
               &(args_info->export_level_orig), &(args_info->export_level_given),
              &(local_args_info.export_level_given), optarg, cmdline_parser_export_level_values, "media", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "export-level", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Enable (or disable) feature.  */
        
          if (update_multiple_arg_temp(&feature_list, 
              &(local_args_info.feature_given), optarg, cmdline_parser_feature_values, 0, ARG_ENUM,
              "feature", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* All website script categories.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->category_all_given),
              &(local_args_info.category_all_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "category-all", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Turn off output to stderr.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "quiet", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Do not resolve redirections.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->no_resolve_given),
              &(local_args_info.no_resolve_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "no-resolve", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Do not verify media URL.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->no_verify_given),
              &(local_args_info.no_verify_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "no-verify", 'n',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Print version and exit.  */
          if (strcmp (long_options[option_index].name, "version") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->version_given),
                &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "version", '-',
                additional_error))
              goto failure;
          
          }
          /* Print license and exit.  */
          else if (strcmp (long_options[option_index].name, "license") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->license_given),
                &(local_args_info.license_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "license", '-',
                additional_error))
              goto failure;
          
          }
          /* Print supported websites and exit.  */
          else if (strcmp (long_options[option_index].name, "support") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->support_given),
                &(local_args_info.support_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "support", '-',
                additional_error))
              goto failure;
          
          }
          /* Identify as.  */
          else if (strcmp (long_options[option_index].name, "agent") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->agent_arg), 
                 &(args_info->agent_orig), &(args_info->agent_given),
                &(local_args_info.agent_given), optarg, 0, "Mozilla/5.0", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "agent", '-',
                additional_error))
              goto failure;
          
          }
          /* Use proxy with HTTP connections.  */
          else if (strcmp (long_options[option_index].name, "proxy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->proxy_arg), 
                 &(args_info->proxy_orig), &(args_info->proxy_given),
                &(local_args_info.proxy_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "proxy", '-',
                additional_error))
              goto failure;
          
          }
          /* Seconds connecting allowed to take.  */
          else if (strcmp (long_options[option_index].name, "connect-timeout") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->connect_timeout_arg), 
                 &(args_info->connect_timeout_orig), &(args_info->connect_timeout_given),
                &(local_args_info.connect_timeout_given), optarg, 0, "30", ARG_INT,
                check_ambiguity, override, 0, 0,
                "connect-timeout", '-',
                additional_error))
              goto failure;
          
          }
          /* Execute command when done parsing.  */
          else if (strcmp (long_options[option_index].name, "exec") == 0)
          {
          
            if (update_multiple_arg_temp(&exec_list, 
                &(local_args_info.exec_given), optarg, 0, 0, ARG_STRING,
                "exec", '-',
                additional_error))
              goto failure;
          
          }
          /* Category HTTP website scripts.  */
          else if (strcmp (long_options[option_index].name, "category-http") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->category_http_given),
                &(local_args_info.category_http_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "category-http", '-',
                additional_error))
              goto failure;
          
          }
          /* Category MMS website scripts.  */
          else if (strcmp (long_options[option_index].name, "category-mms") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->category_mms_given),
                &(local_args_info.category_mms_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "category-mms", '-',
                additional_error))
              goto failure;
          
          }
          /* Category RTSP website scripts.  */
          else if (strcmp (long_options[option_index].name, "category-rtsp") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->category_rtsp_given),
                &(local_args_info.category_rtsp_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "category-rtsp", '-',
                additional_error))
              goto failure;
          
          }
          /* Category RTMP website scripts.  */
          else if (strcmp (long_options[option_index].name, "category-rtmp") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->category_rtmp_given),
                &(local_args_info.category_rtmp_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "category-rtmp", '-',
                additional_error))
              goto failure;
          
          }
          /* Print details in XML.  */
          else if (strcmp (long_options[option_index].name, "xml") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->xml_given),
                &(local_args_info.xml_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "xml", '-',
                additional_error))
              goto failure;
          
          }
          /* Turn on libcurl verbose mode.  */
          else if (strcmp (long_options[option_index].name, "verbose-libcurl") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->verbose_libcurl_given),
                &(local_args_info.verbose_libcurl_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "verbose-libcurl", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable use of HTTP proxy.  */
          else if (strcmp (long_options[option_index].name, "no-proxy") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_proxy_given),
                &(local_args_info.no_proxy_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-proxy", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->exec_arg),
    &(args_info->exec_orig), args_info->exec_given,
    local_args_info.exec_given, 0,
    ARG_STRING, exec_list);
  multiple_default_value.int_arg = category_arg_all;
  update_multiple_arg((void *)&(args_info->category_arg),
    &(args_info->category_orig), args_info->category_given,
    local_args_info.category_given, &multiple_default_value,
    ARG_ENUM, category_list);
  update_multiple_arg((void *)&(args_info->feature_arg),
    &(args_info->feature_orig), args_info->feature_given,
    local_args_info.feature_given, 0,
    ARG_ENUM, feature_list);

  args_info->exec_given += local_args_info.exec_given;
  local_args_info.exec_given = 0;
  args_info->category_given += local_args_info.category_given;
  local_args_info.category_given = 0;
  args_info->feature_given += local_args_info.feature_given;
  local_args_info.feature_given = 0;
  
  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  free_list (exec_list, 1 );
  free_list (category_list, 0 );
  free_list (feature_list, 0 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
