/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtNfc module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QNEARFIELDTARGET_EMULATOR_P_H
#define QNEARFIELDTARGET_EMULATOR_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qnearfieldtagtype1_p.h"
#include "qnearfieldtagtype2_p.h"
#include "targetemulator_p.h"

#include <QtCore/QMap>

QT_BEGIN_NAMESPACE

class TagType1 : public QNearFieldTagType1
{
    Q_OBJECT

public:
    TagType1(TagBase *tag, QObject *parent = nullptr);
    ~TagType1();

    QByteArray uid() const override;

    QNearFieldTarget::AccessMethods accessMethods() const override;

    QNearFieldTarget::RequestId sendCommand(const QByteArray &command) override;
    bool waitForRequestCompleted(const QNearFieldTarget::RequestId &id, int msecs);

private:
    TagBase *tag;
};

class TagType2 : public QNearFieldTagType2
{
    Q_OBJECT

public:
    TagType2(TagBase *tag, QObject *parent = nullptr);
    ~TagType2();

    QByteArray uid() const override;

    QNearFieldTarget::AccessMethods accessMethods() const override;

    QNearFieldTarget::RequestId sendCommand(const QByteArray &command) override;
    bool waitForRequestCompleted(const QNearFieldTarget::RequestId &id, int msecs);

private:
    TagBase *tag;
};

class TagActivator : public QObject
{
    Q_OBJECT

public:
    TagActivator();
    ~TagActivator();

    void initialize();
    void reset();

    void start();
    void stop();

    static TagActivator *instance();

protected:
    void timerEvent(QTimerEvent *e) override;

signals:
    void tagActivated(TagBase *tag);
    void tagDeactivated(TagBase *tag);

private:
    void stopInternal();

    QMap<TagBase *, bool>::Iterator current;
    int timerId = -1;
};

QT_END_NAMESPACE

#endif // QNEARFIELDTARGET_EMULATOR_P_H
