/*
 * Bittorrent Client using Qt and libtorrent.
 * Copyright (C) 2017  Vladimir Golovnev <glassez@yandex.ru>
 * Copyright (C) 2010  Christophe Dumez <chris@qbittorrent.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give permission to
 * link this program with the OpenSSL project's "OpenSSL" library (or with
 * modified versions of it that use the same license as the "OpenSSL" library),
 * and distribute the linked executables. You must obey the GNU General Public
 * License in all respects for all of the code used other than "OpenSSL".  If you
 * modify file(s), you may extend this exception to your version of the file(s),
 * but you are not obligated to do so. If you do not wish to do so, delete this
 * exception statement from your version.
 */

#pragma once

#include <QDateTime>
#include <QSharedDataPointer>
#include <QVariant>

class QJsonObject;
class QRegularExpression;
class TriStateBool;

namespace RSS
{
    struct AutoDownloadRuleData;

    class AutoDownloadRule
    {
    public:
        explicit AutoDownloadRule(const QString &name = "");
        AutoDownloadRule(const AutoDownloadRule &other);
        ~AutoDownloadRule();

        QString name() const;
        void setName(const QString &name);

        bool isEnabled() const;
        void setEnabled(bool enable);

        QString mustContain() const;
        void setMustContain(const QString &tokens);
        QString mustNotContain() const;
        void setMustNotContain(const QString &tokens);
        QStringList feedURLs() const;
        void setFeedURLs(const QStringList &urls);
        int ignoreDays() const;
        void setIgnoreDays(int d);
        QDateTime lastMatch() const;
        void setLastMatch(const QDateTime &lastMatch);
        bool useRegex() const;
        void setUseRegex(bool enabled);
        QString episodeFilter() const;
        void setEpisodeFilter(const QString &e);

        QString savePath() const;
        void setSavePath(const QString &savePath);
        TriStateBool addPaused() const;
        void setAddPaused(const TriStateBool &addPaused);
        QString assignedCategory() const;
        void setCategory(const QString &category);

        bool matches(const QString &articleTitle) const;

        AutoDownloadRule &operator=(const AutoDownloadRule &other);
        bool operator==(const AutoDownloadRule &other) const;
        bool operator!=(const AutoDownloadRule &other) const;

        QJsonObject toJsonObject() const;
        static AutoDownloadRule fromJsonObject(const QJsonObject &jsonObj, const QString &name = "");

        QVariantHash toLegacyDict() const;
        static AutoDownloadRule fromLegacyDict(const QVariantHash &dict);

    private:
        bool matches(const QString &articleTitle, const QString &expression) const;
        QRegularExpression cachedRegex(const QString &expression, bool isRegex = true) const;

        QSharedDataPointer<AutoDownloadRuleData> m_dataPtr;
    };
}
