# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.keyvault.aio import KeyVaultManagementClient
from devtools_testutils.aio import recorded_by_proxy_async
from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from utils import all_api_versions

AZURE_LOCATION = 'eastus'

class TestKeyVaultManagementVaultsPatchAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KeyVaultManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self):
        api_versions = all_api_versions()
        assert api_versions
        for api_version in api_versions:
            # make sure the client uses api_version we set
            self.client._get_api_version = lambda x: api_version
            response = self.client.vaults.list(
                filter="resourceType eq 'Microsoft.KeyVault/vaults'",
            )
            result = [r async for r in response]
            assert result
