# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessLevel."""

    NONE = "None"
    READ = "Read"
    WRITE = "Write"


class DiskCreateOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This enumerates the possible sources of a disk's creation."""

    EMPTY = "Empty"
    ATTACH = "Attach"
    FROM_IMAGE = "FromImage"
    IMPORT = "Import"
    COPY = "Copy"
    RESTORE = "Restore"
    UPLOAD = "Upload"
    IMPORT_ENUM = "Import"


class DiskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the disk."""

    UNATTACHED = "Unattached"
    ATTACHED = "Attached"
    RESERVED = "Reserved"
    ACTIVE_SAS = "ActiveSAS"
    READY_TO_UPLOAD = "ReadyToUpload"
    ACTIVE_UPLOAD = "ActiveUpload"


class DiskStorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    ULTRA_SSD_LRS = "UltraSSD_LRS"


class HyperVGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The hypervisor generation of the Virtual Machine. Applicable to OS disks only."""

    V1 = "V1"
    V2 = "V2"


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Operating System type."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class SnapshotStorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"
    STANDARD_ZRS = "Standard_ZRS"
