# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._microsoft_resource_health_enums import *


class AvailabilityStatus(msrest.serialization.Model):
    """availabilityStatus of a resource.

    :param id: Azure Resource Manager Identity for the availabilityStatuses resource.
    :type id: str
    :param name: current.
    :type name: str
    :param type: Microsoft.ResourceHealth/AvailabilityStatuses.
    :type type: str
    :param location: Azure Resource Manager geo location of the resource.
    :type location: str
    :param properties: Properties of availability state.
    :type properties: ~azure.mgmt.resourcehealth.v2015_01_01.models.AvailabilityStatusProperties
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AvailabilityStatusProperties'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        properties: Optional["AvailabilityStatusProperties"] = None,
        **kwargs
    ):
        super(AvailabilityStatus, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.properties = properties


class AvailabilityStatusListResult(msrest.serialization.Model):
    """The List availabilityStatus operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of availabilityStatuses.
    :type value: list[~azure.mgmt.resourcehealth.v2015_01_01.models.AvailabilityStatus]
    :param next_link: The URI to fetch the next page of availabilityStatuses. Call ListNext() with
     this URI to fetch the next page of availabilityStatuses.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailabilityStatus]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AvailabilityStatus"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AvailabilityStatusListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailabilityStatusProperties(msrest.serialization.Model):
    """Properties of availability state.

    :param availability_state: Availability status of the resource. Possible values include:
     "Available", "Unavailable", "Unknown".
    :type availability_state: str or
     ~azure.mgmt.resourcehealth.v2015_01_01.models.AvailabilityStateValues
    :param summary: Summary description of the availability state.
    :type summary: str
    :param detailed_status: Details of the availability status.
    :type detailed_status: str
    :param reason_type: When the resource's availabilityState is Unavailable, it describes where
     the health impacting event was originated. Examples are planned, unplanned, user initiated or
     an outage etc.
    :type reason_type: str
    :param root_cause_attribution_time: When the resource's availabilityState is Unavailable, it
     provides the Timestamp for when the health impacting event was received.
    :type root_cause_attribution_time: ~datetime.datetime
    :param resolution_eta: When the resource's availabilityState is Unavailable and the reasonType
     is not User Initiated, it provides the date and time for when the issue is expected to be
     resolved.
    :type resolution_eta: ~datetime.datetime
    :param occured_time: Timestamp for when last change in health status occurred.
    :type occured_time: ~datetime.datetime
    :param reason_chronicity: Chronicity of the availability transition. Possible values include:
     "Transient", "Persistent".
    :type reason_chronicity: str or
     ~azure.mgmt.resourcehealth.v2015_01_01.models.ReasonChronicityTypes
    :param reported_time: Timestamp for when the health was last checked.
    :type reported_time: ~datetime.datetime
    :param is_arm_resource: flag to show if child resource need detail health.
    :type is_arm_resource: bool
    :param recently_resolved_state: An annotation describing a change in the availabilityState to
     Available from Unavailable with a reasonType of type Unplanned.
    :type recently_resolved_state:
     ~azure.mgmt.resourcehealth.v2015_01_01.models.AvailabilityStatusPropertiesRecentlyResolvedState
    :param recommended_actions: Lists actions the user can take based on the current
     availabilityState of the resource.
    :type recommended_actions:
     list[~azure.mgmt.resourcehealth.v2015_01_01.models.RecommendedAction]
    :param service_impacting_events: Lists the service impacting events that may be affecting the
     health of the resource.
    :type service_impacting_events:
     list[~azure.mgmt.resourcehealth.v2015_01_01.models.ServiceImpactingEvent]
    """

    _attribute_map = {
        'availability_state': {'key': 'availabilityState', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'str'},
        'detailed_status': {'key': 'detailedStatus', 'type': 'str'},
        'reason_type': {'key': 'reasonType', 'type': 'str'},
        'root_cause_attribution_time': {'key': 'rootCauseAttributionTime', 'type': 'iso-8601'},
        'resolution_eta': {'key': 'resolutionETA', 'type': 'iso-8601'},
        'occured_time': {'key': 'occuredTime', 'type': 'iso-8601'},
        'reason_chronicity': {'key': 'reasonChronicity', 'type': 'str'},
        'reported_time': {'key': 'reportedTime', 'type': 'iso-8601'},
        'is_arm_resource': {'key': 'isArmResource', 'type': 'bool'},
        'recently_resolved_state': {'key': 'recentlyResolvedState', 'type': 'AvailabilityStatusPropertiesRecentlyResolvedState'},
        'recommended_actions': {'key': 'recommendedActions', 'type': '[RecommendedAction]'},
        'service_impacting_events': {'key': 'serviceImpactingEvents', 'type': '[ServiceImpactingEvent]'},
    }

    def __init__(
        self,
        *,
        availability_state: Optional[Union[str, "AvailabilityStateValues"]] = None,
        summary: Optional[str] = None,
        detailed_status: Optional[str] = None,
        reason_type: Optional[str] = None,
        root_cause_attribution_time: Optional[datetime.datetime] = None,
        resolution_eta: Optional[datetime.datetime] = None,
        occured_time: Optional[datetime.datetime] = None,
        reason_chronicity: Optional[Union[str, "ReasonChronicityTypes"]] = None,
        reported_time: Optional[datetime.datetime] = None,
        is_arm_resource: Optional[bool] = None,
        recently_resolved_state: Optional["AvailabilityStatusPropertiesRecentlyResolvedState"] = None,
        recommended_actions: Optional[List["RecommendedAction"]] = None,
        service_impacting_events: Optional[List["ServiceImpactingEvent"]] = None,
        **kwargs
    ):
        super(AvailabilityStatusProperties, self).__init__(**kwargs)
        self.availability_state = availability_state
        self.summary = summary
        self.detailed_status = detailed_status
        self.reason_type = reason_type
        self.root_cause_attribution_time = root_cause_attribution_time
        self.resolution_eta = resolution_eta
        self.occured_time = occured_time
        self.reason_chronicity = reason_chronicity
        self.reported_time = reported_time
        self.is_arm_resource = is_arm_resource
        self.recently_resolved_state = recently_resolved_state
        self.recommended_actions = recommended_actions
        self.service_impacting_events = service_impacting_events


class AvailabilityStatusPropertiesRecentlyResolvedState(msrest.serialization.Model):
    """An annotation describing a change in the availabilityState to Available from Unavailable with a reasonType of type Unplanned.

    :param unavailable_occurred_time: Timestamp for when the availabilityState changed to
     Unavailable.
    :type unavailable_occurred_time: ~datetime.datetime
    :param resolved_time: Timestamp when the availabilityState changes to Available.
    :type resolved_time: ~datetime.datetime
    :param unavailability_summary: Brief description of cause of the resource becoming unavailable.
    :type unavailability_summary: str
    """

    _attribute_map = {
        'unavailable_occurred_time': {'key': 'unavailableOccurredTime', 'type': 'iso-8601'},
        'resolved_time': {'key': 'resolvedTime', 'type': 'iso-8601'},
        'unavailability_summary': {'key': 'unavailabilitySummary', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        unavailable_occurred_time: Optional[datetime.datetime] = None,
        resolved_time: Optional[datetime.datetime] = None,
        unavailability_summary: Optional[str] = None,
        **kwargs
    ):
        super(AvailabilityStatusPropertiesRecentlyResolvedState, self).__init__(**kwargs)
        self.unavailable_occurred_time = unavailable_occurred_time
        self.resolved_time = resolved_time
        self.unavailability_summary = unavailability_summary


class ErrorResponse(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class Operation(msrest.serialization.Model):
    """Operation available in the resourcehealth resource provider.

    :param name: Name of the operation.
    :type name: str
    :param display: Properties of the operation.
    :type display: ~azure.mgmt.resourcehealth.v2015_01_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """Properties of the operation.

    :param provider: Provider name.
    :type provider: str
    :param resource: Resource name.
    :type resource: str
    :param operation: Operation name.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Lists the operations response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of operations available in the resourcehealth resource provider.
    :type value: list[~azure.mgmt.resourcehealth.v2015_01_01.models.Operation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: List["Operation"],
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class RecommendedAction(msrest.serialization.Model):
    """Lists actions the user can take based on the current availabilityState of the resource.

    :param action: Recommended action.
    :type action: str
    :param action_url: Link to the action.
    :type action_url: str
    :param action_url_text: Substring of action, it describes which text should host the action
     url.
    :type action_url_text: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'action_url': {'key': 'actionUrl', 'type': 'str'},
        'action_url_text': {'key': 'actionUrlText', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action: Optional[str] = None,
        action_url: Optional[str] = None,
        action_url_text: Optional[str] = None,
        **kwargs
    ):
        super(RecommendedAction, self).__init__(**kwargs)
        self.action = action
        self.action_url = action_url
        self.action_url_text = action_url_text


class ServiceImpactingEvent(msrest.serialization.Model):
    """Lists the service impacting events that may be affecting the health of the resource.

    :param event_start_time: Timestamp for when the event started.
    :type event_start_time: ~datetime.datetime
    :param event_status_last_modified_time: Timestamp for when event was submitted/detected.
    :type event_status_last_modified_time: ~datetime.datetime
    :param correlation_id: Correlation id for the event.
    :type correlation_id: str
    :param status: Status of the service impacting event.
    :type status: ~azure.mgmt.resourcehealth.v2015_01_01.models.ServiceImpactingEventStatus
    :param incident_properties: Properties of the service impacting event.
    :type incident_properties:
     ~azure.mgmt.resourcehealth.v2015_01_01.models.ServiceImpactingEventIncidentProperties
    """

    _attribute_map = {
        'event_start_time': {'key': 'eventStartTime', 'type': 'iso-8601'},
        'event_status_last_modified_time': {'key': 'eventStatusLastModifiedTime', 'type': 'iso-8601'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'ServiceImpactingEventStatus'},
        'incident_properties': {'key': 'incidentProperties', 'type': 'ServiceImpactingEventIncidentProperties'},
    }

    def __init__(
        self,
        *,
        event_start_time: Optional[datetime.datetime] = None,
        event_status_last_modified_time: Optional[datetime.datetime] = None,
        correlation_id: Optional[str] = None,
        status: Optional["ServiceImpactingEventStatus"] = None,
        incident_properties: Optional["ServiceImpactingEventIncidentProperties"] = None,
        **kwargs
    ):
        super(ServiceImpactingEvent, self).__init__(**kwargs)
        self.event_start_time = event_start_time
        self.event_status_last_modified_time = event_status_last_modified_time
        self.correlation_id = correlation_id
        self.status = status
        self.incident_properties = incident_properties


class ServiceImpactingEventIncidentProperties(msrest.serialization.Model):
    """Properties of the service impacting event.

    :param title: Title of the incident.
    :type title: str
    :param service: Service impacted by the event.
    :type service: str
    :param region: Region impacted by the event.
    :type region: str
    :param incident_type: Type of Event.
    :type incident_type: str
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'service': {'key': 'service', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'incident_type': {'key': 'incidentType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        service: Optional[str] = None,
        region: Optional[str] = None,
        incident_type: Optional[str] = None,
        **kwargs
    ):
        super(ServiceImpactingEventIncidentProperties, self).__init__(**kwargs)
        self.title = title
        self.service = service
        self.region = region
        self.incident_type = incident_type


class ServiceImpactingEventStatus(msrest.serialization.Model):
    """Status of the service impacting event.

    :param value: Current status of the event.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ServiceImpactingEventStatus, self).__init__(**kwargs)
        self.value = value
