# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class X12ValidationOverride(Model):
    """The X12 validation override settings.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id on which the validation
     settings has to be applied.
    :type message_id: str
    :param validate_edi_types: Required. The value indicating whether to
     validate EDI types.
    :type validate_edi_types: bool
    :param validate_xsd_types: Required. The value indicating whether to
     validate XSD types.
    :type validate_xsd_types: bool
    :param allow_leading_and_trailing_spaces_and_zeroes: Required. The value
     indicating whether to allow leading and trailing spaces and zeroes.
    :type allow_leading_and_trailing_spaces_and_zeroes: bool
    :param validate_character_set: Required. The value indicating whether to
     validate character Set.
    :type validate_character_set: bool
    :param trim_leading_and_trailing_spaces_and_zeroes: Required. The value
     indicating whether to trim leading and trailing spaces and zeroes.
    :type trim_leading_and_trailing_spaces_and_zeroes: bool
    :param trailing_separator_policy: Required. The trailing separator policy.
     Possible values include: 'NotSpecified', 'NotAllowed', 'Optional',
     'Mandatory'
    :type trailing_separator_policy: str or
     ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'message_id': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'validate_character_set': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(X12ValidationOverride, self).__init__(**kwargs)
        self.message_id = kwargs.get('message_id', None)
        self.validate_edi_types = kwargs.get('validate_edi_types', None)
        self.validate_xsd_types = kwargs.get('validate_xsd_types', None)
        self.allow_leading_and_trailing_spaces_and_zeroes = kwargs.get('allow_leading_and_trailing_spaces_and_zeroes', None)
        self.validate_character_set = kwargs.get('validate_character_set', None)
        self.trim_leading_and_trailing_spaces_and_zeroes = kwargs.get('trim_leading_and_trailing_spaces_and_zeroes', None)
        self.trailing_separator_policy = kwargs.get('trailing_separator_policy', None)
