# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=12.1.0 --output=unicodedb_12_1_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '12.1.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x07 ABOVE '
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x03 AN'
'\x05 AND '
'\n AND ARROW'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x06 ARROW'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\t ASTERISK'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x05 BACK'
'\r BAT AND BALL'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\x07 CER-WA'
'\n CHARACTER'
'\x07 CHIKI '
'\x05 CHWV'
'\x07 CIRCLE'
'\x05 COAT'
'\n CONJOINED'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING ESH2'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\t DRACHMAS'
'\x02 E'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x08 FACING '
'\x06 FINAL'
'\x13 FLUTTERING IN WIND'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\t HITTING '
'\x05 HOOK'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ICON'
'\x05 ILUT'
'\x03 IN'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x04 KEY'
'\x02 L'
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x13 LOVE YOU HAND SIGN'
'\x02 M'
'\x08 MACHINE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x08 MAKSURA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x06 MURDA'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\t OF BLOOD'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\t OF PAPER'
'\r OF THE HORNS'
'\x08 OF YARN'
'\x05 OPEN'
'\x07 OPEN-O'
'\r OPPOSING KUR'
'\x04 ORE'
'\x04 OUT'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
'\x12 OVER HI TIMES ASH'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x16 OVER STAMPED ENVELOPE'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DA'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GAL'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\x10 PLUS KAK PLUS A'
'\x0c PLUS KASKAL'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x12 PLUS PAP PLUS LU3'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\t PLUS SAG'
'\x11 PLUS SHA3 PLUS A'
'\t PLUS SHU'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x07 PLUS U'
'\t PLUS ZA7'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x0c PUNCTUATION'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\t RICKSHAW'
'\x0c RING LITTLE'
'\t ROTATED '
'\x17 ROTATED NINETY DEGREES'
'\x08 ROTUNDA'
'\x06 RULER'
'\x02 S'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x07 SECANT'
'\n SEPARATOR'
'\x04 SET'
'\x06 SEVEN'
'\x05 SHOE'
'\x05 SIDE'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x12 THROUGH DESCENDER'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES BAD'
'\x10 TIMES DISH TENU'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\t TIMES HA'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x0b TIMES TAK4'
'\x08 TIMES U'
'\t TIMES UD'
'\x07 TO BAR'
'\x05 TONE'
'\x06 TONE-'
'\x0f TOUCHING INDEX'
'\x08 TTUDDAG'
'\x02 U'
'\x04 U U'
'\r VARIANT FORM'
'\x04 WEB'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE MIDDLE TILDE'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x0b WITH FLASH'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\r WITH JEGOGAN'
'\x12 WITH KAVYKA ABOVE'
'\x0e WITH LONG LEG'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\x0e WITH ORNAMENT'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\x0f WITH RIGHT LEG'
'\n WITH RING'
'\x11 WITH SOUND WAVES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x13 WITH VERTICAL TAIL'
'\x0b WITHIN DOT'
'\x07 WOLOSO'
'\x0b WRIST FLEX'
'\x02 X'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x02-A'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\t-LOW TONE'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x07-MU-MO-'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x0b-OFF SYMBOL'
'\x0f-PIECE SWIMSUIT'
'\x06-PIEUP'
'\n-POINTING '
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x08-X BELOW'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x080 BRONZE'
'\x050 DOO'
'\x050 DWO'
'\x030 E'
'\x0b0 FOOTSTOOL'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\x040 KO'
'\t0 LONG LE'
'\x040 MA'
'\x050 MAN'
'\x060 NGGI'
'\x060 NGGO'
'\x040 NI'
'\x060 NYON'
'\x060 NYUN'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x040 SA'
'\x070 SPEAR'
'\x030 U'
'\x030 W'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 YE'
'\x040 ZO'
'\x030-0'
'\x050-VAS'
'\x0200'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0304A'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x031 A'
'\x071 ARROW'
'\x041 BA'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DO'
'\x041 DU'
'\x051 DWE'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x061 GOLD'
'\x041 HA'
'\x081 HELMET'
'\x061 HORN'
'\x041 IN'
'\x041 KI'
'\x041 KU'
'\n1 LONG MBE'
'\x061 NDEE'
'\x031 O'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 PO'
'\x041 QI'
'\x041 RA'
'\x041 SA'
'\x041 SI'
'\x041 SU'
'\x051 TEE'
'\x051 TWO'
'\x041 VU'
'\x061 WINE'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-0'
'\x031-2'
'\x051-VAS'
'\x0211'
'\x03121'
'\x0314D'
'\x03155'
'\x0216'
'\x0217'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x032 B'
'\x042 BU'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\x072 PLUS '
'\n2 PLUS ASH'
'\x052 POO'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x052 SEE'
'\x042 SO'
'\x042 TI'
'\x042 VI'
'\x042 WO'
'\x072 WOMAN'
'\x032 Y'
'\x042 YA'
'\x032-0'
'\x052-VAS'
'\x0220'
'\x0320B'
'\x0221'
'\x0222'
'\x0224'
'\t247 DIPTE'
'\x03253'
'\x0726 EYYY'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 PA'
'\t3 PLUS AN'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x043 TA'
'\x053 VEE'
'\x053 WEI'
'\x073 WHEEL'
'\x043 YU'
'\x033-0'
'\x053-VAS'
'\x0230'
'\x03305'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0233'
'\x0234'
'\x0236'
'\x0238'
'\x0239'
'\x014'
'\x034 A'
'\x054 ABB'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x044 KE'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x044 NE'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x044 TE'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WA'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x044 ZE'
'\x034-0'
'\x054-VAS'
'\x0240'
'\x0242'
'\x0248'
'\x0249'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AN'
'\x045 AU'
'\t5 BATHTUB'
'\x045 BB'
'\t5 CYPERUS'
'\x045 DE'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 JU'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x065 MERI'
'\x045 MO'
'\x055 NDU'
'\x075 NGGEE'
'\x045 NU'
'\x045 OO'
'\x045 TE'
'\x045 TO'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WE'
'\x045 WO'
'\x065 WOOL'
'\x035-0'
'\x055-VAS'
'\x0250'
'\x0253'
'\x0255'
'\x03550'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x046 JE'
'\x046 JO'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x046 NA'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 TA2'
'\x066 TREE'
'\x056 WEE'
'\x046 WU'
'\x036-0'
'\x056-VAS'
'\x0262'
'\x03620'
'\x0264'
'\x036D7'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 DI'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x047 JA'
'\x057 JEE'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 VO'
'\x047 ZA'
'\x057-VAS'
'\x0270'
'\x0271'
'\x0272'
'\x0372C'
'\x0279'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x038 A'
'\x048 BO'
'\x048 DU'
'\x038 E'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x038 I'
'\x048 JI'
'\x038 K'
'\x088 KANAKO'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x058 NWA'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 SI'
'\x049 SO'
'\x049 TA'
'\x049 TO'
'\x049 TU'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x0292'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A HAAM'
'\x06A MFON'
'\x0cA NAME REIWA'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\tA PLUS NA'
'\x08A SIGN A'
'\nA TANG LAI'
'\x07A WITH '
'\rA WITH STROKE'
'\x05A YUE'
'\x02A-'
'\x04A-HA'
'\x06A-KARA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x04AACU'
'\x03AAF'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\tAAZHAAKKU'
'\x02AB'
'\x03AB2'
'\nAB2 TIMES '
'\x03ABA'
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x05ABOVE'
'\x06ABOVE '
'\x15ABOVE LEFTWARDS ARROW'
'\x0eABOVE REVERSE '
'\x03AC '
'\x13ACCENT ATNAH HAFUKH'
'\rACCOMMODATION'
'\x03ACE'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x03AD3'
'\x03ADA'
'\x04ADA '
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x05ADULT'
'\x02AE'
'\x03AEA'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\tAF PERSON'
'\x04AFEL'
'\x0eAFETY SCISSORS'
'\tAFFE FACE'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x04AGE '
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\x02AH'
'\x08AH WITH '
'\x16AH WITH TWO DOTS ABOVE'
'\x04AHAD'
'\x08AHAPRANA'
'\x02AI'
'\x0fAI LAING DIGIT '
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\x1fAISED HAND WITH FINGERS SPLAYED'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\x02AJ'
'\x06AJANI '
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x03AK4'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x05ALLOT'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x05ALPHA'
'\x0cALT PAN SIGN'
'\x08ALTERNAT'
'\nALTERNATE '
'\x13ALTERNATE LAKH MARK'
'\x11ALTERNATE NUMBER '
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x08AM WITH '
'\x04AMBA'
'\tAME WITH '
'\x05AMEDH'
'\x03AMI'
'\x04AMLA'
'\x04AMMA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\rAN RUPEE SIGN'
'\x04AN X'
'\x03AN2'
'\x03ANA'
'\x10ANABAZAR SQUARE '
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x11AND BLACK SQUARES'
'\x0eAND COLD SWEAT'
'\x0fAND FEMALE SIGN'
'\x12AND LOW RIGHT RING'
'\x18AND MALE AND FEMALE SIGN'
'\x08AND SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\nANDHI MARK'
'\nANDRABINDU'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANG CITI '
'\x05ANGEL'
'\tANGGEUAET'
'\x05ANGKA'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x08ANI SIGN'
'\x06ANIMAL'
'\x05ANNON'
'\x08ANS SIGN'
'\x0fANS-SERIF ARROW'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\tANTAYALAN'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x0eANUSVARA ABOVE'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x03AR '
'\x04ARA3'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x04ARAE'
'\x04ARAM'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDNESS'
'\x03ARE'
'\nARFUL FACE'
'\x05ARGE '
'\x03ARK'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x03ARL'
'\x03ARM'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x08ARRIVING'
'\x05ARROW'
'\x06ARROW '
'\x07ARROW O'
'\x12ARROW SHAFT WIDTH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x0eARSI YEH WITH '
'\x03ART'
'\x05ARTAR'
'\x17ARTY HORN AND PARTY HAT'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\x07AS SIGN'
'\x05ASAL '
'\x10ASALIZATION MARK'
'\x04ASAT'
'\x17ASCENDING MUSICAL NOTES'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x07ASHTRA '
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x03ASS'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATAKANA '
'\x08ATEBOARD'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x07AUGHTS '
'\x03AUJ'
'\x04AULA'
'\x07AULDRON'
'\x03AUM'
'\x07AUNTLET'
'\x03AUS'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x02AW'
'\x05AWAY '
'\rAWELLEMET YAZ'
'\x0bAWNING FACE'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x03AYD'
'\nAYER BEADS'
'\x06AYEROK'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x05BACUS'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x03BAL'
'\x05BALAG'
'\x04BALD'
'\x04BALL'
'\rBALL AND HOOP'
'\rBALLPOINT PEN'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rBASAN LETTER '
'\tBASE UNIT'
'\x04BASH'
'\x08BATAEAN '
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x05BENDE'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x08BEVERAGE'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\tBIAL SIGN'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x03BIN'
'\x05BINDU'
'\tBING CANE'
'\x07BINING '
'\x0cBINING MARK '
'\x08BINOVILE'
'\x0bBIRGA WITH '
'\x05BISAH'
'\x06BISCUS'
'\x06BISHOP'
'\x0fBISHOP ROTATED '
'\tBITE LIPS'
'\x0fBJOINED LETTER '
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\nBLACK FLAG'
'\rBLACK SQUARES'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\x04BLOW'
'\x0cBLOWING FACE'
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x07BOTTOM '
'\x11BOTTOM HALF BLACK'
'\x15BOTTOM U-SHAPED ARROW'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x08BRA FACE'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x19BREVE WITH INVERTED BREVE'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x12BSERVER EYE SYMBOL'
'\x04BSET'
'\x03BSP'
'\x05BSTER'
'\nBSTRUCTION'
'\x02BU'
'\x03BU '
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C CLEF'
'\x06C SIGN'
'\x08C SIYAQ '
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x03CAI'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x11CANDRABINDU ABOVE'
'\x04CANO'
'\x05CANUS'
'\x04CAP '
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\tCAPITAL I'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x04CASE'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\x05CCOLI'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x05CECAK'
'\x05CECEK'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x08CER BALL'
'\x06CER-WA'
'\x05CEREK'
'\x0eCERTAINTY SIGN'
'\x06CEVITU'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x11CHA WITH TWO DOTS'
'\x06CHAMKO'
'\tCHANICAL '
'\x14CHARACTER INTRODUCER'
'\x0cCHARACTER-1B'
'\x05CHART'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x06CHESS '
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x05CHIME'
'\x08CHINESE '
'\x0bCHING CHICK'
'\nCHING HAND'
'\x06CHIRET'
'\x03CHO'
'\x04CHO '
'\x05CHOOI'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x03CHU'
'\x06CHURCH'
'\x05CHUTE'
'\x04CHWA'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x04CIM '
'\x06CIRCLE'
'\rCIRCLE INSIDE'
'\x12CIRCLE NUKTA ABOVE'
'\x0fCIRCLE WITH DOT'
'\x08CIRCLED '
'\nCIRCLED CA'
'\x0cCIRCLED PLUS'
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x11CIRCLES WITH DOTS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\rCITATION MARK'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x1dCKED FACE WITH EXPLODING HEAD'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x05CKING'
'\x05CKTIE'
'\x02CL'
'\x07CLEAVER'
'\x08CLIMBING'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x17CLUSTER-INITIAL LETTER '
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLATE BAR'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\nCOMPONENT '
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\x10CONSONANT JOINER'
'\x16CONSONANT MODIFIER BAR'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x16CONSONANT SIGN MEDIAL '
'\x11CONSONANT SIGN PA'
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x04COON'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0bCREDIT SIGN'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x15CROSSE STICK AND BALL'
'\x07CROSSED'
'\x0cCROSSED-TAIL'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GABA'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x04CURL'
'\x08CURLICUE'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY HAIR'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x04D HA'
'\x0bD MIDDLE UP'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x08D SYMBOL'
'\x0eD-UP NEWSPAPER'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\x07DA FACE'
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DA2'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\tDATE MARK'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDDA'
'\x04DDHI'
'\x05DDING'
'\x08DDY BEAR'
'\x02DE'
'\x06DE DOG'
'\x18DE INVERTED BRIDGE BELOW'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\nDED PERSON'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\x16DEOGRAPHIC TALLY MARK '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\x03DES'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x06DGEHOG'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x07DHALATH'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\tDIAERESIS'
'\rDIAERESIZED U'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\rDIC MARK SIGN'
'\x0cDICTION SIGN'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x08DIM GUNU'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x04DIUM'
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x03DNA'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x0fDOT PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x10DOTTED CRESCENTS'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\x1cDOUBLE ANUSVARA ANTARGOMUKHA'
'\nDOUBLE BAR'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\rDOUBLE MUCAAD'
'\x0fDOUBLE ORNAMENT'
'\x0bDOUBLE RING'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x16DOUBLE-LINED HEAD MARK'
'\x04DOWN'
'\x05DOWN '
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\x18DOWNSCALING FACTOR KIIZH'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x02DR'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\tDRAM SIGN'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x03DUG'
'\x0cDUG TIMES NI'
'\tDUN3 GUNU'
'\x0eDUN3 GUNU GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\x05DWICH'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\tE AT LEFT'
'\x14E CONSONANT MODIFIER'
'\x07E DRINK'
'\x05E GEE'
'\x07E GLASS'
'\x06E HOOK'
'\x11E LIGHT MOON ARTA'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\x10E PLUS GAN2 TENU'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E-'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x04EACE'
'\x03EAD'
'\x07EAD ORE'
'\x05EAGLE'
'\x04EANS'
'\nEARLY FORM'
'\x0bEARS OF JOY'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EATH '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'\x08ED BRICK'
'\x06ED CAP'
'\x07ED FACE'
'\x06ED ICE'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x0eED PARAGRAPHOS'
'\tED PLANET'
'\x07ED RICE'
'\tED SYMBOL'
'\x0eED SYMBOL FOR '
'\tEDESTRIAN'
'\nEDESTRIANS'
'\x06EDIAL '
'\x05EDIC '
'\rEDIC ANUSVARA'
'\x0bEDICAL MASK'
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x04EEM '
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x06EENTH-'
'\x06EENTHS'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\x02EF'
'\tEFAIDRIN '
'\x10EFORE COMPLETION'
'\tEFORMED T'
'\x03EFT'
'\x04EFT '
'\x15EFT HORIZONTAL SECANT'
'\x15EFT-POINTING TRIANGLE'
'\x14EFTWARDS ARROW WITH '
'\x0fEFTWARDS ARROWS'
'\x0cEGIN SEGMENT'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\x17EH WITH SMALL TEH ABOVE'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x05EIDON'
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x16EIGHTY ON BLACK SQUARE'
'\x03EIN'
'\x04EIPT'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x08ELEPHANT'
'\x03ELF'
'\x03ELI'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x03ELT'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0bEN STRAIGHT'
'\x0bEN THOUSAND'
'\x0bEN TWELFTHS'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x05ENDAR'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x08ENICIAN '
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x08ENVELOPE'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x08EOUT BOX'
'\x03EOW'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x04EPHA'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\nEQUIHOPPER'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\tER BUBBLE'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x05ERN W'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x06ERTED '
'\x0eERTICAL JOINER'
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x08ESCENDER'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x06ESTAN '
'\x02ET'
'\x03ET '
'\x06ET KUT'
'\x08ET SHOES'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x04ETOS'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\tETTER SHA'
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\nEUTRAL YER'
'\x03EUX'
'\nEVAL COMMA'
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\rEVEN TWELFTHS'
'\x08EVENTEEN'
'\x06EVENTY'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0eEXCLAMATION OH'
'\x06EXHALE'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EYK'
'\nEZING FACE'
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\rF WITH STROKE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x06FAMILY'
'\x04FAST'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FETH'
'\x05FETY '
'\x04FEUQ'
'\x06FF OF '
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x04FFLE'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIER '
'\x05FIFTY'
'\x06FIFTY '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\x14FINAL CONSONANT MARK'
'\x15FINAL CONSONANT SIGN '
'\rFINAL LETTER '
'\tFINAL NGA'
'\tFINAL NUN'
'\x08FINAL TH'
'\x07FINAL Y'
'\x08FINGER C'
'\x1bFINGER COVERING CLOSED LIPS'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x0cFIVE HUNDRED'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x05FLAME'
'\x15FLATTENED PARENTHESIS'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLICT'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\nFLUTTERING'
'\x03FLY'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x04FOR '
'\x08FOR STOP'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x06FORMEE'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x12FORTY-FIVE DEGREES'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\nFOUR BELOW'
'\tFOUR BENT'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\rFRACTION ONE '
'\x11FRACTION ONE HALF'
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x08FROM BAR'
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT RERENGGAN'
'\x13FT-POINTING FLEURON'
'\x05FTEEN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x02FU'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x18GAF WITH INVERTED STROKE'
'\x03GAG'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x03GAR'
'\rGAR FRACTION '
'\x08GARITIC '
'\x05GAROO'
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x05GAZE-'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x06GDIAN '
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x07GEMINAT'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x07GENERAL'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x05GGER '
'\nGGING FACE'
'\x05GGLES'
'\x06GGLING'
'\x0fGGLY LINE BELOW'
'\x12GGLY VERTICAL LINE'
'\nGGRAVATION'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\x04GIDA'
'\x04GIEA'
'\rGIFT ENVELOPE'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GIR2'
'\x04GISH'
'\x12GISH CROSSING GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x08GOLITIC '
'\x0bGONEK ABOVE'
'\x04GONG'
'\x03GOU'
'\x07GRADUAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x05GRAPH'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0bGREEK CROSS'
'\x06GREEN '
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x0eGUNU TIMES ASH'
'\x03GUR'
'\x05GVANG'
'#GVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x02GW'
'\x02GY'
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x03HAB'
'\x05HADDA'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x04HALA'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x11HALF BLACK CIRCLE'
'\x14HALF CIRCLE WITH DOT'
'\x08HALF GUR'
'\tHALF NOTE'
'\x0fHALF RING ABOVE'
'\tHALF SIGN'
'\x05HALF-'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x13HAND COVERING MOUTH'
'\x0cHAND FORMAT '
'\tHAND SIGN'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\x08HARBAHAY'
'\tHARD SIGN'
'\x06HARIOT'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x04HAYN'
'\x02HD'
'\x02HE'
'\x03HE '
'\x03HEA'
'\x04HEAD'
'\x05HEAD '
'\tHEAD MARK'
'\x1bHEAD MARK WITH MOON AND SUN'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\tHEADSCARF'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x0bHEATED FACE'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x08HEAVY YA'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\nHEMATICAL '
'\x12HEN WITH DIAERESIS'
'\x04HENG'
'\x03HER'
'\rHER CHRISTMAS'
'\x06HERMES'
'\nHERMOMETER'
'\x04HERO'
'\x04HERU'
'\x06HESHIG'
'\x0eHESIVE BANDAGE'
'\x08HESPIAN '
'\x05HESS '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x07HEXAGON'
'\x16HEXIFORM LONG ANUSVARA'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\rHI TIMES ASH2'
'\x0cHIBITED SIGN'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x04HIGH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x03HII'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x05HIMEL'
'\x03HIN'
'\rHINESE TONE Y'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x07HIRTEEN'
'\x05HIRTY'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x08HITTING '
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x04HMI '
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOM'
'\x04HOM '
'\x03HOO'
'\x04HOOK'
'\x05HOOK '
'\rHOOK AND TAIL'
'\tHOOK MARK'
'\tHOOK TAIL'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x05HORSE'
'\x06HORT A'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\rHOUGHT BUBBLE'
'\x08HOULDER '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\x06HREE D'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
' HREE DOTS POINTING UPWARDS BELOW'
'\x0cHREE FINGERS'
'\tHREE FOR '
'\x1cHREE HUNDRED FIFTEEN DEGREES'
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x14HREE-DOT NUKTA ABOVE'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x04HSHU'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x02HU'
'\x04HUB2'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x03HUR'
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\x02HW'
'\x03HWA'
'\tHWA WITH '
'\x04HWAH'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x06I GUNU'
'\x06I HOOK'
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES BAD'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x05I-RES'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x06IAMOND'
'\x07IAMOND '
'\x04IAN '
'\x0bIAN LETTER '
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IARDS'
'\x05IAUDA'
'\x06IB YAM'
'\x02IC'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x05ICKET'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\x06IDE ES'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x03IDO'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IETH'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\rIFI ROHINGYA '
'\x06IFIED '
'\x07IFIED E'
'\x06IFTEEN'
'\x04IFTH'
'\x04IFTY'
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\nIGATING RA'
'\x13IGATURE AYIN-DALETH'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x12IGATURE ZAYIN-YODH'
'\x06IGGLES'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\nIGHT ANGLE'
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\rIGHT TWELFTHS'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\x07IGHTEEN'
'\tIGHTH ASH'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\x0cIGN AVAGRAHA'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\tIGN TOMPI'
'\x12IGSAW PUZZLE PIECE'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\x12IN POSSESSION SIGN'
'\tIN SQUARE'
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x10INDEPENDENT SHIN'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\nINDU BELOW'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\x08ING FACE'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\tING LANES'
'\nING LITTLE'
'\x08ING MASK'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x0cING ROTATED '
'\x13ING SHIRT WITH SASH'
'\tING STONE'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x06INHALE'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x11INITIAL LETTER RA'
'\x06INKING'
'\x05INNA '
'\x07INNABAR'
'\tINNYIIYHE'
'\nINOCULAR O'
'\x0eINOLOGICAL DOT'
'\x0eINSERTION SIGN'
'\x06INSHIP'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x0cINVERTEBRATE'
'\x08INVERTED'
'\tINVERTED '
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INY '
'\x04INYA'
'\x03ION'
'\x08ION MARK'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x05IRACY'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x05IRCLE'
'#IRCLE CONTAINING BLACK SMALL CIRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x06IRCLES'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x0eIRCULAR VIRAMA'
'\x05IRCUT'
'\x04IRED'
'\x04IRON'
'\x08IRPLANE '
'\x0cIRST SUBUNIT'
'\x06IRTEEN'
'\x04IRTY'
'\x0bIRTY-SECOND'
'\x03IRY'
'\x02IS'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\rISH LIRA SIGN'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x0eISSION TICKETS'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x0eITALIC LETTER '
'\x15ITALIC SMALL DOTLESS '
'\x0bITARY MEDAL'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x0eITERATION MARK'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\x05ITLO '
'\x03ITO'
'\tITRA SIGN'
'\x04ITSA'
'\x07ITTING '
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\rIVE SLOW SIGN'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x06IXTEEN'
'\nIXTHS DISH'
'\x04IXTY'
'\x14IXTY ON BLACK SQUARE'
'\x06IXTY P'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x03IYO'
'\x0fIZED WHEELCHAIR'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x03JOA'
'\x06JOINED'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\nJONG TILE '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x07K WITH '
'\x02K-'
'\x05K-020'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x08KAIYARAA'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x03KAM'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x05KAROR'
'\x06KASAR '
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x03KAU'
'\x06KAVYKA'
'\rKAVYKA ABOVE '
'\x06KAYAH '
'\x05KBALL'
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\tKEN HEART'
'\x05KERET'
'\x05KESH2'
'\x03KET'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x02KH'
'\x07KHA YAT'
'\x04KHAH'
'\x07KHAMTI '
'\x14KHAMTI REDUPLICATION'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x07KIEVAN '
'\x06KILLER'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING BOOT'
'\tKING FACE'
'\x04KINI'
'\rKISIM5 TIMES '
'\x0fKISIM5 TIMES BI'
'\x04KISS'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x07KKURUNI'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x03KOI'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x02KS'
'\x0bKTAIL GLASS'
'\x0bKTIESELSKAB'
'\x05KTOP '
'\x02KU'
'\x03KU3'
'\x03KUE'
'\x03KUG'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x06KY WAY'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL OF THREAD'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x04LAAM'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x0bLACK CIRCLE'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x0bLACKLETTER '
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x03LAI'
'\x07LAK-050'
'\x04LAKH'
'\tLAKH MARK'
'\x03LAL'
'\x03LAM'
'\x04LAM '
'\x04LAMA'
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\nLANE MERGE'
'\x1aLANTED SOUTH ARROW WITH HO'
'\x03LAP'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\tLARGEMENT'
'\x03LAS'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x08LATION X'
'\x15LATTENED OPEN A ABOVE'
'\x03LAU'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x04LBOX'
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDE '
'\x04LDER'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x0cLEADING EYES'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
'\nLEFT-HAND '
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x17LEFT-SHADED WHITE ARROW'
'\x12LEFT-STEM TONE BAR'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\x03LEG'
'\x03LEI'
'\nLEK ATTAK '
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x05LENIS'
'\x04LEPH'
'\x03LES'
'\x08LESS SHA'
'\x08LESSER Y'
'\x03LET'
'\x04LETH'
'\x0bLETION MARK'
'\x06LETTER'
'\x07LETTER '
'\x0bLETTER LLLA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\x15LETTER SMALL CAPITAL '
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x02LF'
'\x03LF '
'\rLF BLACK STAR'
'\x07LF FACE'
'\x03LFA'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x04LIFI'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\nLIMITATION'
'\x04LINE'
'\x05LINE '
'\x0eLINE EXTENSION'
'\x0bLINE FILLER'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x04LIPS'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x08LL MOON '
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x07LLEYBUS'
'\x06LLHORN'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x10LLOW PAN OF FOOD'
'\x07LLOWING'
'\tLLY MARK '
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOAN '
'\x05LOBE '
'\x08LOCATION'
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x04LONG'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG FINAL'
'\x0fLONG HOOK BELOW'
'\nLONG OVER '
'\tLONG TIP '
'\nLONG TSHEG'
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\x07LOTTAL '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x0eLOTUS POSITION'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\nLOW KAVYKA'
'\x16LOW PARAPHRASE BRACKET'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x08LOW TONE'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x17LSCHREIBER PAUSE SYMBOL'
'\x02LT'
'\tLT SHAKER'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\nLTERNATE U'
'\x0bLTERNATE YA'
'\nLTIC CROSS'
'\x06LTILLO'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x0cLU PLUS ESH2'
'\x0bLU PLUS IGI'
'\x03LU3'
'\x03LUB'
'\x04LUE '
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x03LUS'
'\x05LWAY '
'\x02LX'
'\x02LY'
'\x04LY H'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x08M SYMBOL'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x06MADDAH'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\nMALAYALAM '
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x06MALL F'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x13MANCHU ALI GALI LHA'
'\x08MANDARIN'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAQ'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\nMARK ABOVE'
'\tMARK CIM '
'\x0eMARK LOWER DOT'
'\tMARK SHAD'
'\rMARKS CHAPTER'
'\x08MARRATAN'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x03MAY'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x0bMBLER GLASS'
'\x05MBOL '
'\x07MBOL B0'
'\tMBOL FOR '
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\x06ME DIE'
'\nME PLUS EN'
'\x08MEASURE '
'\x04MED '
'\x0cMEDARY CAMEL'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x07MENIAN '
'\x05MENOE'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x0bMIC LETTER '
'\x03MID'
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE HOOK'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIM'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\nMILLE SIGN'
'\x08MILLIONS'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\rMINDER RIBBON'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\x05MINGO'
'\nMINO TILE '
'\x1eMINTON RACQUET AND SHUTTLECOCK'
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\nMISMA SIGN'
'\x05MISRA'
'\x03MIT'
'\x04MIZE'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'\x1aMODIFIER FITZPATRICK TYPE-'
'\x10MODIFIER LETTER '
'"MODIFIER LETTER LABIALIZATION MARK'
'\rMODIFIER MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\x0bMONOCULAR O'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x04MPET'
'\x05MPIRE'
'\x03MPL'
'\x06MPLING'
'\x05MROCK'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x18MTAVRULI CAPITAL LETTER '
'\x02MU'
'\x04MUAS'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x08MULTIPLE'
'\x15MULTIPLE MEASURE REST'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x07N WITH '
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x0fNA DOUBLE HELIX'
'\tNA KHONNA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x05NADA '
'\x03NAH'
'\x04NAKE'
'\nNAKE BELOW'
'\x03NAM'
'\x04NAM2'
'\x04NANT'
'\x03NAP'
'\x03NAR'
'\x0cNARROW SHAFT'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x03NAU'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\tNCH FRIES'
'\x05NCORA'
'\x13NCTUS ELEVATUS MARK'
'\x02ND'
'\x03ND '
'\x0bND ODD SIGN'
'\x0bND OF PIECE'
'\nND SEGMENT'
'\x15ND TELEPHONE RECEIVER'
'\x0bND TWO DOTS'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\nNDINAGARI '
'\x0cNDING PERSON'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\nNDU TEMPLE'
'\x02NE'
'\x03NE '
'\x11NE EYEBROW RAISED'
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x06NE OF '
'\x04NED '
'\x08NED FOOD'
'\x0eNEELING PERSON'
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x03NEL'
'\x04NEMA'
'\x05NENOE'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x03NET'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x0bNEUTRAL YER'
'\x03NEY'
'\x07NFINITY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x03NG '
'\x08NG ABOVE'
'\x0bNG LEFT LEG'
'\x11NG STROKE OVERLAY'
'\x14NG WITH CROSSED-TAIL'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\x0bNGER BUBBLE'
'\tNGER SHIP'
'\x05NGINE'
'\nNGLICANA W'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x05NGUE '
'\tNGUN SIGN'
'\x02NI'
'\x08NI ABOVE'
'\x03NIE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\x05NIGHT'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x0bNIKOLSBURG '
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x08NINETEEN'
'\x06NINETY'
'\x0eNINETY DEGREES'
'\tNING MOOD'
'\rNING MOVEMENT'
'\tNING SIGN'
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x0cNJALA GONDI '
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x03NNI'
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\nNOON ABOVE'
'\x0bNOON GHUNNA'
'\nNOON WITH '
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x0cNORTHERN TSE'
'\x04NOSE'
'\x05NOTCH'
'\x0cNOTCHED HOOK'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x06NOVILE'
'\x04NOWC'
'\x08NOWLEDGE'
'\x06NOWMAN'
'\x08NRES TOS'
'\x04NRUA'
'\x02NS'
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\tNSERT AT '
'\x04NSHE'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x07NSPLUTO'
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x10NTAIGANA LETTER '
'\x05NTAIN'
'\x18NTED NORTH ARROW WITH HO'
'\tNTESSENCE'
'\x05NTHA '
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x05NTXIV'
'\x02NU'
'\x03NUB'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUTS'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x03NYA'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x02O '
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\x06O MARK'
'\x07O WITH '
'\x10O WITH DOT ABOVE'
'\x02O-'
'\x03O-I'
'\x04O-YO'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x05OCADO'
'\x07OCALIC '
'\x08OCALIC M'
'\x08OCALIC R'
'\x07OCATION'
'\tOCCLUSION'
'\x06OCENCE'
'\x03OCK'
'\x08OCK SALT'
'\x05OCKET'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x03ODA'
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\nOF HYGIEIA'
'\x0bOF MASHFAAT'
'\x07OF SOAP'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x02OG'
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0cOGOGRAM NYAJ'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x06OITIC '
'\x04OJI '
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\x05OKARA'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x07OLAPUK '
'\x03OLD'
'\x04OLD '
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x10OLD WHITE CIRCLE'
'\x05OLDER'
'\x0bOLDING BACK'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\x05OLLON'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x03OM '
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\x0bOMAN SIYAQ '
'\x08OMANIAN '
'\x05OMBIE'
'\tOMBINING '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x0eOMING ENVELOPE'
'\x04OMMA'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x0fON BLACK SQUARE'
'\x08ON CROSS'
'\x07ON FACE'
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\rONAL COMPUTER'
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x1fONE HUNDRED THIRTY-FIVE DEGREES'
'\x14ONE HUNDRED THOUSAND'
'\x1bONE LARGE AND ONE SMALL EYE'
'\x14ONE MARK SGAW KAREN '
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x03ONG'
'\x04ONG '
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\tONG GRAVE'
'\x05ONG S'
'\x0bONG S WITH '
'\rONG-LEGGED DE'
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x10ONJOINING MACRON'
'\x06ONOCLE'
'\x1aONOMICAL SYMBOL FOR URANUS'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x04ONUT'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\nOON SELENA'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x03OPH'
'\x05OPLET'
'\x04OPOD'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x0bORCE SYMBOL'
'\x04ORD '
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x10ORIZONTAL JOINER'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\nOROME SIGN'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x06OSING '
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\tOTAL SIGN'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x0cOTTOM HALF O'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\tOURA SIGN'
'\x07OURTEEN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\nOUT HANDLE'
'\x07OUT HUB'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\tOUTH WIND'
'\nOUTHERN TA'
'\x04OVAL'
'\x15OVAL WITH OVAL INSIDE'
'\x05OVER '
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\tOVER LONG'
'\tOVER MUSH'
'\x16OVER NU11 BUR OVER BUR'
'\x08OVER NUN'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SAG'
'\x08OVER SHE'
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x03OWN'
'\rOWN POINTING '
'\x15OWN-POINTING TRIANGLE'
'\x03OX '
'\x07OX BACK'
'\x02OY'
'\x07OYSTICK'
'\x03OZE'
'\x06OZENGE'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\tP ELAMITE'
'\x07P PIEET'
'\nP STREAMER'
'\x0cP TACK ABOVE'
'\x07P WITH '
'\x17P WITH EXCLAMATION MARK'
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x05PALI '
'\x07PALLAWA'
'\x04PALM'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x0ePARATED SYMBOL'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\nPASSIMBANG'
'\x04PAWN'
'\rPAWN ROTATED '
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x0cPE CARTRIDGE'
'\x11PE WITH DESCENDER'
'\x06PEAKS '
'\x0cPEECH BUBBLE'
'\x04PEEI'
'\x04PEEP'
'\x19PEH WITH SMALL MEEM ABOVE'
'\x03PEN'
'\x04PEN '
'\x05PEN E'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\tPENT SIGN'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x06PEPPER'
'\x03PER'
'\x04PER '
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x08PERSIAN '
'\x06PERSON'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x04PHAB'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\x06PICKET'
'\x07PICTURE'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x05PING '
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x0bPLACEHOLDER'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\nPLE DAGGER'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x07PLOYAN '
'\x04PLUG'
'\x04PLUM'
'\x05PLUS '
'\nPLUS ERIN2'
'\x14PLUS GISH TIMES TAK4'
'\x08PLUS LAL'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x18POINTING DOWNWARDS ABOVE'
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\tPPOINTED '
'\nPPOPOTAMUS'
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\tPREFIXED '
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x06PRINTS'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x07PSTICKS'
'\x05PTIVE'
'\x0ePTUNE FORM TWO'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'\x17PUNCTUATION END OF TEXT'
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x07PURPLE '
'\x08PUSHPIKA'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x06PWATCH'
'\x01Q'
'\x07Q WITH '
'\x10Q WITH HOOK TAIL'
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\tQUADCOLON'
'\x0fQUADRUPLE ARROW'
'\x13QUADRUPLE CRESCENTS'
'\x0bQUALS SIGN '
'\x05QUARE'
'\x06QUARE '
'\x06QUARED'
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x0cQUARTER SIGN'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\x05QUEEN'
'\tQUEEN OF '
'\x0eQUEEN ROTATED '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x08QUINTILE'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\tR COASTER'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x03R S'
'\x06R SIGN'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x02R0'
'\x02R2'
'\x07R2 GUNU'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x03RA '
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RAAKAN'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x0bRADITIONAL '
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x04RAN '
'\x0cRANCHING OUT'
'\x06RANGE '
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x14RANSPOSITION BRACKET'
'\x07RARIETY'
'\x05RASHA'
'\x03RAT'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x08RAUGHTS '
'\x06RAVEL-'
'\x03RAY'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\nRCHAIC KHA'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\nRDHACANDRA'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x04REAM'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x08RECEIVER'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\x04RED '
'\nRED DRAGON'
'\x08RED HAIR'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x19REE-HUNDRED-AND-TWENTIETH'
'\x13REE-QUARTER CIRCLE '
'\x05REEK '
'\tREFORMED '
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x05RELAA'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x03REN'
'\x0cREN CROSSING'
'\x06RENGTH'
'\x04REPA'
'\x10REPETITION MARK-'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\nRESH BELOW'
'\tRESH-AYIN'
'\x10RESH-AYIN-DALETH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x0bREVE-MACRON'
'\x08REVERSE '
'\x0fREVERSE SOLIDUS'
'\tREVERSED '
'\nREVERSED I'
'\x0fREVERSED OPEN E'
'\x0eREVERSED-SCHWA'
'\x03REX'
'\x02RF'
'\x04RFER'
'\nRGE CIRCLE'
'\nRGE SQUARE'
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x03RI '
'\x0cRIAGE SYMBOL'
'\x0cRIAL TRAMWAY'
'\x07RIANGLE'
'\x12RIANGLE ARROWHEADS'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x17RIGHT HORIZONTAL SECANT'
'\x14RIGHT POINTING INDEX'
'\x0fRIGHT RERENGGAN'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'\x0bRIGHT-HAND '
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x14RIGHT-POINTING ANGLE'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x06RIKRIK'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\nRING BELOW'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\nRING THUMB'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x07RINKLES'
'&RIOUS FACE WITH SYMBOLS COVERING MOUTH'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x07RIPPLE '
'\x05RIPT '
'\x06RIPT G'
'\tRIS FORM '
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x03RK '
'\rRK SUNGLASSES'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x04RLIC'
'\x06RLICUE'
'\x03RMT'
'\x07RMUKHI '
'\x05RNED '
'\x13RNISH VERSE DIVIDER'
'\x02RO'
'\x03RO '
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\x06ROCKET'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x0cROLLING EYES'
'\x03ROM'
'\x03RON'
'\x05RONOS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x04ROOK'
'\rROOK ROTATED '
'\x04ROSH'
'\x04ROSS'
'\x0eROSS ON SHIELD'
'\x08ROSSED O'
'\x0bROSSED-TAIL'
'\x03ROT'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\x05ROWN '
'\rRPENTRY PLANE'
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\nRROW WITH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x04RSO-'
'\x02RT'
'\rRTABLE STEREO'
'\tRTER MARK'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x05RUMP-'
'\x04RUNG'
'\x04RUNI'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x13RY CULTIVATION SIGN'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0cS ABOVE SIGN'
'\x07S BELOW'
'\x1dS DIGRAPH WITH RETROFLEX HOOK'
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\rS UP TOGETHER'
'\x07S-SAJDA'
'\x08S-SERIF '
'\x02S0'
'\x02SA'
'\x07SA VAH '
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAD'
'\x05SADHE'
'\x03SAG'
'\x03SAH'
'\x05SAKIN'
'\x05SAKTA'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x03SAM'
'\x10SAMARITAN SOURCE'
'\x06SANDAL'
'\x07SANDHI '
'\x04SANG'
'\x07SANGAN '
'\x10SANS-SERIF ARROW'
'\nSANSKRIT S'
'\x03SAR'
'\x0cSARAM GONDI '
'\x05SARGA'
'\x05SASAK'
'\x03SAU'
'\x06SAUCER'
'\x03SAW'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x07SCOOTER'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x08SCRIPT X'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\tSEMICOLON'
'\x08SENTAGON'
'\x1cSENTATION FORM FOR VERTICAL '
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x07SERPINA'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x15SET PRECEDING SOLIDUS'
'\x07SEVENTH'
'\x0fSEVENTY DEGREES'
'\x02SH'
'\x03SH '
'\x15SH AMPERSAND ORNAMENT'
'\x13SH PLUS HU PLUS ASH'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\tSHAB CEEB'
'\x04SHAD'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x12SHAN REDUPLICATION'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x07SHESHIG'
'\x0eSHESHIG TIMES '
'\x05SHGAB'
'\x03SHI'
'\x07SHIFT T'
'\x05SHIMA'
'\x04SHIN'
'\x05SHIRT'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x0bSHOGI PIECE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x08SHORT ER'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x05SHTIN'
'\x04SHU '
'\x04SHU2'
'\x10SHU2 PLUS KASKAL'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\nSIDEWAYS I'
'\x14SIDEWAYS NOON GHUNNA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x11SIGN O WITH CROSS'
'\x10SIGN PALI VIRAMA'
'\x07SIGN UD'
'\x03SII'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\rSIX LATE FORM'
'\x04SIXT'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x13SLANTED NORTH ARROW'
'\x05SLASH'
'\x05SMALL'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\x07SMALL W'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\x02SO'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x07SOLDIER'
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x06SOUTH '
'\x0cSOUTHERN TSE'
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x05SPINE'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x03SQU'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x07SQUARES'
'\x08SQUEEZED'
'\x0cSQUIQUADRATE'
'\x02SS'
'\nSS OF MILK'
'\x03SSA'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x03SSI'
'\x1aSSIAN ASTROLOGICAL SYMBOL '
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x04SSUS'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x07ST TUBE'
'\nST-FEEDING'
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x05START'
'\x07STATERS'
'\x0bSTEAMY ROOM'
'\tSTEBASKET'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x04STLE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x04STOP'
'\x0bSTORIC SITE'
'\x03STR'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x0cSTROKE BELOW'
'\x18STROKE THROUGH DESCENDER'
'\x0eSTRONG ISOLATE'
'\nSTRUCTION '
'\x1bSTRUMENTAL NOTATION SYMBOL-'
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x13SUBSTITUTION MARKER'
'\x04SUCK'
'\x06SUCKED'
'\x04SUKU'
'\x06SULAR '
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x03SUU'
'\x07SVARITA'
'\x0bSVASTI SIGN'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\x06SWORDS'
'\x02SY'
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x05T OF '
'\tT OF MEAT'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x0cTACKED COMMA'
'\x05TAGON'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x0fTAI LAING TONE-'
'\x08TAI LUE '
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\nTAMAN SIGN'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x03TAR'
'\x08TAR EYES'
'\x06TARGET'
'\x11TARTING FROM SIGN'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAW'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\nTCOIN SIGN'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\x06TEDUNG'
'\x03TEE'
'\x04TEEN'
'\x05TEGEH'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENSE'
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
'\x0eTERMINAL MARK-'
'\x0cTERNATE AYIN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x0bTH-THALATHA'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x06THAKKU'
'\x07THALIYA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x07THIEUTH'
'\x05THING'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOSCOPE'
'\x08THOUSAND'
'\tTHOUSAND '
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0fTHREE DISH TENU'
'\x10THREE DOTS ABOVE'
'\x0cTHREE HEARTS'
'\x0eTHREE POINTED '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x03THW'
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x04TIC '
'\x06TICAL '
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x07TIKRAMA'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES KUR'
'\tTIMES NA2'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\tTIN CROSS'
'\x05TING '
'\nTING HEART'
'\x0bTION BOTTLE'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x03TIU'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x07TLESS J'
'\x05TMAAU'
'\x02TO'
'\x06TO BAR'
'\x08TO FORM '
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x0bTONAL MARK '
'\x04TONE'
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x05TONE-'
'\x06TONGUE'
'\x04TOP '
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x05TRACK'
'\x0cTRAGRAM FOR '
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x03TRE'
'\tTREDECILE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x03TRI'
'\x08TRI DISH'
'\x0bTRIAN CAMEL'
'\x08TRIANGLE'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x0cTRIPLE FLAME'
'\x05TROKE'
'\x05TROL '
'\x07TROLLEY'
'!TRONG CENTRALIZATION STROKE BELOW'
'\x03TSA'
'\x03TSE'
'\x05TSEEB'
'\x05TSHEG'
'\x02TT'
'\x03TTA'
'\x03TTE'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x04TTER'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x03TUJ'
'\x04TUKI'
'\tTUKWENTIS'
'\x0bTUNE COOKIE'
'\x03TUP'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\x05TURN '
'\x07TURNED '
'\nTURNED AYB'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x13TURNED SECTION MARK'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x13TWENTY-FIVE DEGREES'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\x1bTWO HUNDRED SEVENTY DEGREES'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x04TZEL'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x05U U U'
'\x07U WITH '
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x02U0'
'\x02U2'
'\nU2 PLUS BA'
'\x02U3'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x0eUAL WHEELCHAIR'
'\x03UAM'
'\nUAM TSHOOJ'
'\x06UANGXI'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB '
'\x03UB2'
'\x03UBE'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x08UBJOINER'
'\x04UBLE'
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x10UBLE PARENTHESIS'
'\x06UBLE R'
'\x0fUBLE RING BELOW'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x05UDAAT'
'\x06UDATTA'
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\x03UG2'
'\x06UGGAGE'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x04UHUR'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x04UKTA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x05ULAR '
'\x07ULATION'
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULT'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x03UM '
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x12UM WITH DRUMSTICKS'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\x0cUNBLENDED UK'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x03UND'
'\x05UNDER'
'\x06UNDER '
'\x08UNDERTIE'
'\x07UNDRED '
'\x1aUNEVEN EYES AND WAVY MOUTH'
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\x06UR OF '
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URL'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x11URNED DAMMA BELOW'
'\tURNED GAN'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x0bURRENT SIGN'
'\x03URT'
'\x03URU'
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US MARK'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\x06USHPIN'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x06USTER-'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\x04UTAN'
'\x05UTEUX'
'\x04UTH '
'\x0cUTH ARABIAN '
'\x0bUTH CORNERS'
'\nUTH OR SPY'
'\x05UTIES'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\tUVUZHAKKU'
'\x02UX'
'\x02UZ'
'\x07UZHAKKU'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x07VAPOURS'
'\x07VARIANT'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\x08VE SASAK'
'\tVE THUMB '
'\x03VE-'
'\x04VEDE'
'\x0eVEDIC ANUSVARA'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\tVELOPMENT'
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\nVERAGE BOX'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\rVERLAY MIDDLE'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x13VERTICAL BAR VIRAMA'
'\x17VERTICAL BAR WITH QUILL'
'\rVERTICAL BARS'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VES'
'\x08VESSEL B'
'\x04VEST'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x10VIEWING CEREMONY'
'\tVIGINTILE'
'\x07VILLAIN'
'\x03VIN'
'\x04VINE'
'\tVINE LEAF'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC L'
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x08VOMITING'
'\x0eVONIC ASTERISK'
'\x03VOP'
'\x04VOS '
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VUU'
'\x02VW'
'\x03VY '
'\rVY CHECK MARK'
'\x05VZMET'
'\x01W'
'\nW OR MODEL'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x03WAN'
'\x05WAQFA'
'\x04WARD'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x0bWE PALAUNG '
'\x05WELVE'
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x04WER '
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x14WET CULTIVATION SIGN'
'\x05WFISH'
'\x02WG'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\nWHITE HAIR'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x0cWHITE SQUARE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\nWHOLE NOTE'
'\x02WI'
'\x05WIANG'
'\x04WIDE'
'\x05WIDTH'
'\x07WIFRUIT'
'\x07WIGNYAN'
'\x06WINDOW'
'\x05WINDU'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x10WITH HEARING AID'
'\x13WITH INFINITY BELOW'
'\x12WITH JUSTIFICATION'
'\x0eWITH LEFT HOOK'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\nWITH SPOON'
'\nWITH STRAW'
'\x0cWITH STROKE '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x07WN FACE'
'\x08WN HEART'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x07WO DOTS'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\nWO FINGERS'
'\x07WO FOR '
'\x0bWO HUNDRED '
'\x06WO OF '
'\nWO SHORTS '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\x15WO-CIRCLE NUKTA ABOVE'
'\nWO-HEADED '
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\x06WRENCH'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x16XCLAMATION MARK SYMBOL'
'\x02XE'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x04XEYN'
'\x02XG'
'\tXHAUSTION'
'\nXHEEJ CEEV'
'\x02XI'
'\x08XIANGQI '
'\x06XIMIZE'
'\x05XING '
'\nXING GLOVE'
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x0bXTINGUISHER'
'\x15XTRA SHORT VOWEL MARK'
'\x05XTRA-'
'\x05XW XW'
'\x03XWG'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x07Y GREEN'
'\x06Y LOOP'
'\x08Y POPPER'
'\x08Y SMALL '
'\x0eY SMALL SQUARE'
'\nY THOUSAND'
'\x07Y WITH '
'\x08Y-FOURTH'
'\tY-FOURTHS'
'\x03Y00'
'\x02YA'
'\x07YA LAMP'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x03YAN'
'\x0cYAN NUMERAL '
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x07YELLOW '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\x08YESIEUNG'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x0eYI WITH STROKE'
'\x16YIAKENG PUACHUE HMONG '
'\x03YIN'
'\x06YIN-DO'
'\x05YING '
'\nYING CARD '
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x05YIZET'
'\x0cYLEFT SYMBOL'
'\x08YLLABLE '
'\x12YLLABLE LENGTHENER'
'\x07YMAIC L'
'\x05YMBOL'
'\x06YMBOL '
'\nYMBOL AIVA'
'\x0cYMBOL BINDU '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x0cYOD TRIANGLE'
'\x04YODH'
'\x06YOMBO '
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x12YPTIAN HIEROGLYPH '
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x06YRENE '
'\x08YRILLIC '
'\x05YSTER'
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x1dZ DIGRAPH WITH RETROFLEX HOOK'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\nZAR AMULET'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x03ZHE'
'\x03ZHI'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\tZIR SASAK'
'\x04ZIZ2'
'\x02ZO'
'\x03ZOA'
'\x03ZOO'
'\x03ZOR'
'\nZU OVER ZU'
'\x08ZWARAKAY'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68923,
 -53853,
 -1,
 132661,
 54170,
 -1,
 198179,
 102078,
 -1,
 263553,
 180153,
 -1,
 327930,
 227087,
 -1,
 393401,
 268678,
 74167,
 458852,
 357229,
 -1,
 524324,
 398963,
 -1,
 589846,
 463444,
 75009,
 720895,
 526935,
 -1,
 720910,
 643994,
 -1,
 -65524,
 702812,
 75019,
 -65523,
 735501,
 75018,
 -1,
 791143,
 75017,
 983057,
 706465,
 -1,
 -65520,
 934398,
 75016,
 -1,
 991916,
 75015,
 -65518,
 948057,
 75014,
 -65517,
 1144503,
 75013,
 -65516,
 1196453,
 75012,
 -65515,
 1255369,
 75011,
 -1,
 1320186,
 75010,
 1507362,
 529775,
 75021,
 1638399,
 1444439,
 -1,
 1638427,
 1561498,
 -1,
 -65510,
 1620316,
 75030,
 -1,
 1653005,
 75029,
 1835037,
 1599317,
 75024,
 -1,
 1770293,
 75025,
 -65506,
 1818216,
 75028,
 -65505,
 1942516,
 75027,
 -65504,
 2002941,
 75026,
 -65503,
 2053399,
 75023,
 -1,
 2113919,
 75022,
 -65501,
 1447073,
 75020,
 -1,
 2232626,
 75008,
 2424889,
 464042,
 -1,
 2490415,
 2364586,
 -1,
 2555950,
 2431188,
 74993,
 2686975,
 2493015,
 -1,
 2687019,
 2597840,
 -1,
 -65494,
 2663386,
 74997,
 -1,
 2720550,
 74996,
 -65492,
 2675749,
 74998,
 -65491,
 2844501,
 74995,
 -1,
 2906501,
 74994,
 -1,
 2494780,
 74992,
 3145780,
 2431188,
 -1,
 -65487,
 3085694,
 75006,
 -65486,
 3150732,
 75005,
 -65485,
 3215975,
 75004,
 -1,
 3280940,
 75003,
 3473463,
 3085694,
 -1,
 -65482,
 3413827,
 75000,
 -1,
 3477548,
 74999,
 -65480,
 3414218,
 75002,
 -1,
 3610622,
 75001,
 3801160,
 2363436,
 -1,
 3866685,
 3741731,
 -1,
 -65476,
 3805642,
 74974,
 -1,
 3870764,
 74973,
 4063296,
 3806590,
 -1,
 -65473,
 4002108,
 74970,
 -1,
 4067372,
 74969,
 4259907,
 4002407,
 -1,
 -65470,
 4199806,
 74967,
 -1,
 4264252,
 74966,
 -65468,
 4200821,
 74975,
 -65467,
 4397070,
 74972,
 -65466,
 4462389,
 74971,
 -65465,
 4527239,
 74968,
 -1,
 4591912,
 74965,
 4784212,
 3740263,
 -1,
 4849741,
 4723303,
 -1,
 -65461,
 4790307,
 74982,
 -65460,
 4855166,
 74981,
 -1,
 4919340,
 74980,
 5111888,
 4789875,
 -1,
 -65457,
 5052019,
 74985,
 -1,
 5117310,
 74984,
 5308499,
 5050684,
 -1,
 -65454,
 5249236,
 74979,
 -1,
 5312556,
 74978,
 -1,
 5248164,
 74983,
 5570653,
 4723596,
 -1,
 5636185,
 5510314,
 -1,
 -65449,
 5576739,
 74988,
 -65448,
 5642051,
 74987,
 -1,
 5706636,
 74986,
 5898332,
 5576739,
 -1,
 -65445,
 5837994,
 74990,
 -1,
 5903244,
 74989,
 -1,
 5839215,
 74991,
 6160480,
 5510979,
 -1,
 -65441,
 6100338,
 75032,
 -1,
 6165353,
 75031,
 6357091,
 6099260,
 -1,
 -65438,
 6296940,
 74977,
 -1,
 6362247,
 74976,
 -1,
 6297179,
 75007,
 6619315,
 414999,
 -1,
 6684845,
 6563679,
 74168,
 6815743,
 6619136,
 -1,
 6815916,
 6737261,
 -1,
 6881392,
 6756742,
 74169,
 6946925,
 6817526,
 -1,
 -65429,
 6912057,
 74172,
 -65428,
 6968793,
 74171,
 -1,
 7027115,
 74170,
 -65426,
 6929801,
 74175,
 -65425,
 7179308,
 74174,
 -1,
 7239439,
 74173,
 7405687,
 6869914,
 74213,
 7471220,
 7341814,
 -1,
 -65421,
 7459761,
 74215,
 -1,
 7477638,
 74214,
 -65419,
 7454031,
 74218,
 -65418,
 7616781,
 74217,
 -1,
 7672582,
 74216,
 7864448,
 7387649,
 -1,
 7929983,
 7821835,
 -1,
 7995515,
 7918626,
 74207,
 -1,
 7931913,
 74208,
 8126590,
 7958546,
 -1,
 -65411,
 8112699,
 74206,
 -1,
 8169315,
 74205,
 -1,
 8078011,
 74204,
 -1,
 7919289,
 74209,
 8454279,
 7828281,
 -1,
 8519813,
 8442778,
 -1,
 8585348,
 8484623,
 74194,
 -1,
 8521543,
 74195,
 -1,
 8524684,
 74193,
 8847359,
 8479661,
 74191,
 -1,
 8752172,
 74192,
 8913037,
 8410312,
 -1,
 8978570,
 8902069,
 74182,
 -1,
 8914749,
 74183,
 9109644,
 8919430,
 74180,
 -1,
 9088198,
 74181,
 -1,
 9069485,
 74632,
 9306258,
 8877839,
 -1,
 9371792,
 9294746,
 74198,
 -1,
 9336591,
 74199,
 -65391,
 9334601,
 74197,
 -1,
 9444632,
 74196,
 9633944,
 9266093,
 -1,
 9699479,
 9601907,
 74188,
 9830399,
 9635574,
 -1,
 -65386,
 9732874,
 74190,
 -1,
 9787933,
 74189,
 -1,
 9656287,
 74187,
 10027165,
 9619361,
 -1,
 10092700,
 9968006,
 -1,
 -65381,
 10056584,
 74211,
 -1,
 10114248,
 74210,
 -1,
 10044039,
 74212,
 10354849,
 9995123,
 -1,
 10420384,
 10306046,
 74200,
 -1,
 10356522,
 74201,
 -1,
 10410712,
 74202,
 10616997,
 10312203,
 -1,
 10682532,
 10557830,
 74184,
 -1,
 10647311,
 74185,
 -1,
 10642437,
 74186,
 10879144,
 10561375,
 -1,
 -65369,
 10838957,
 74177,
 -1,
 10886115,
 74176,
 -65367,
 10874308,
 74964,
 -65366,
 11046416,
 74203,
 -65365,
 11093959,
 74179,
 -1,
 11156010,
 74178,
 -1,
 6800243,
 74219,
 11468799,
 6663366,
 74220,
 11534335,
 11337728,
 -1,
 11534513,
 11455900,
 74221,
 -1,
 11470868,
 74222,
 11730943,
 11491764,
 74223,
 -1,
 11601438,
 74224,
 11796662,
 6587251,
 74228,
 11927551,
 11733715,
 74229,
 -1,
 11798490,
 74230,
 11993272,
 11761423,
 74226,
 -1,
 11930334,
 74227,
 -1,
 11952875,
 74225,
 12189942,
 381850,
 74235,
 12255465,
 12128871,
 74237,
 12386303,
 12189696,
 -1,
 12386530,
 12306337,
 -1,
 12452065,
 12347508,
 -1,
 12517572,
 12415801,
 -1,
 12583107,
 12458979,
 -1,
 12648642,
 12522380,
 74246,
 -1,
 12584709,
 74247,
 -1,
 12587623,
 74245,
 -1,
 12542893,
 74248,
 12910793,
 12499457,
 -1,
 12976328,
 12870573,
 -1,
 -65337,
 12940157,
 74255,
 -1,
 12977925,
 74254,
 -1,
 12935954,
 74635,
 13238477,
 12864328,
 74240,
 13369343,
 13172736,
 -1,
 -65332,
 13290043,
 74241,
 -1,
 13346691,
 74634,
 13500624,
 13223841,
 -1,
 -65329,
 13489690,
 74256,
 -1,
 13508213,
 75038,
 13697234,
 13476812,
 75036,
 -1,
 13633470,
 75037,
 13828309,
 13667372,
 -1,
 -65324,
 13816730,
 74253,
 -1,
 13844990,
 74252,
 14024920,
 13793113,
 -1,
 -65321,
 13980975,
 74250,
 -1,
 14026501,
 74249,
 14221531,
 13982219,
 -1,
 -65318,
 14181369,
 74243,
 -1,
 14229143,
 75035,
 -65316,
 14190247,
 74251,
 -65315,
 14379076,
 74244,
 -65314,
 14439846,
 74242,
 -65313,
 14499026,
 75034,
 -65312,
 14559177,
 74239,
 -1,
 14622359,
 74238,
 -1,
 12405070,
 74257,
 14876902,
 12368385,
 -1,
 14942437,
 14835167,
 74261,
 -1,
 14879327,
 74633,
 -1,
 14920645,
 74260,
 -65305,
 14851036,
 74259,
 -65304,
 15096249,
 75033,
 -1,
 15153075,
 74258,
 15335663,
 12211585,
 74263,
 15466495,
 15269888,
 -1,
 15466734,
 15373335,
 -1,
 -65299,
 15457592,
 74264,
 -1,
 15509805,
 74265,
 -1,
 15449718,
 74266,
 15728882,
 15303539,
 74269,
 15859711,
 15664691,
 74270,
 -1,
 15729441,
 74271,
 -65293,
 15693583,
 74268,
 -65292,
 15882763,
 74267,
 -65291,
 15930252,
 74262,
 -1,
 15993439,
 74236,
 16252927,
 12149677,
 74231,
 -65288,
 16170319,
 74234,
 -65287,
 16222675,
 74233,
 -1,
 16283407,
 74232,
 16449977,
 283848,
 -1,
 16515448,
 16390534,
 73909,
 16580964,
 16454247,
 73911,
 16711679,
 16515072,
 -1,
 16712035,
 16633197,
 -1,
 16777482,
 16667848,
 -1,
 16843014,
 16718214,
 74939,
 16908549,
 16821446,
 73932,
 17039359,
 16844534,
 -1,
 -65276,
 16944656,
 74941,
 -1,
 16989123,
 74940,
 -1,
 16878702,
 73931,
 17301503,
 16802733,
 73933,
 17301769,
 17175722,
 73934,
 -1,
 17237757,
 73935,
 -1,
 17280306,
 73936,
 17498389,
 16718214,
 -1,
 17563918,
 17481039,
 73917,
 17694719,
 17502823,
 74618,
 -1,
 17565491,
 73918,
 17760530,
 17499894,
 -1,
 -65264,
 17721173,
 73914,
 -65263,
 17783325,
 73913,
 -1,
 17840555,
 73912,
 18022676,
 17730604,
 73916,
 -1,
 17958743,
 74617,
 -1,
 17966964,
 73915,
 18219296,
 17480193,
 -1,
 18284828,
 18176523,
 -1,
 18350362,
 18244525,
 -1,
 -65255,
 18318195,
 74951,
 -1,
 18364685,
 73959,
 18612223,
 18301438,
 73957,
 -1,
 18483230,
 73958,
 18678047,
 18225542,
 -1,
 -65250,
 18656454,
 73956,
 -1,
 18708239,
 73955,
 -1,
 18667193,
 73960,
 18940203,
 18168077,
 -1,
 19005734,
 18928538,
 -1,
 19071269,
 18961627,
 -1,
 -65244,
 19035198,
 74937,
 -1,
 19097433,
 74936,
 -1,
 19015519,
 73926,
 19333418,
 18965421,
 73924,
 19464191,
 19301237,
 -1,
 -65239,
 19385756,
 73925,
 -1,
 19421620,
 74935,
 -1,
 19274118,
 73923,
 19661108,
 18903865,
 -1,
 19726639,
 19649434,
 -1,
 -65234,
 19709742,
 74943,
 -1,
 19731514,
 73948,
 19923249,
 19686724,
 73946,
 -1,
 19859336,
 73947,
 20119551,
 19863942,
 -1,
 -65229,
 20037861,
 73945,
 -1,
 20083513,
 73944,
 20250941,
 19618315,
 -1,
 20316475,
 20191622,
 -1,
 20382008,
 20281103,
 73938,
 -1,
 20318079,
 73939,
 20578303,
 20317942,
 -1,
 -65222,
 20480781,
 73937,
 -1,
 20519302,
 74942,
 -65220,
 20305054,
 73941,
 -1,
 20669390,
 73940,
 20840772,
 20220972,
 -1,
 20906306,
 20791806,
 74948,
 21037055,
 20842230,
 -1,
 -65215,
 20928476,
 74950,
 -1,
 20988700,
 74949,
 21233663,
 20895507,
 73952,
 -1,
 21104227,
 73953,
 21299530,
 20791806,
 -1,
 21365063,
 21269548,
 73929,
 -1,
 21301914,
 73930,
 21496137,
 21329679,
 73927,
 -1,
 21432191,
 73928,
 -1,
 21475660,
 74938,
 21692753,
 21243743,
 -1,
 21758287,
 21633414,
 -1,
 -65203,
 21736686,
 73920,
 -65202,
 21781526,
 74934,
 -1,
 21838093,
 73919,
 22085631,
 21748156,
 73921,
 -1,
 21956561,
 73922,
 22151510,
 21657359,
 -1,
 22217045,
 22092166,
 73949,
 22347775,
 22184819,
 74944,
 -1,
 22219475,
 74945,
 -1,
 22205994,
 74946,
 22479193,
 22139802,
 73962,
 22609919,
 22427917,
 73963,
 -1,
 22480673,
 73964,
 22675805,
 22446963,
 -1,
 -65189,
 22665944,
 74947,
 -65188,
 22700973,
 73951,
 -1,
 22758048,
 73950,
 22937952,
 22635437,
 -1,
 -65185,
 22920556,
 73943,
 -1,
 22960095,
 73942,
 -65183,
 22932912,
 74952,
 -65182,
 23120042,
 73961,
 -1,
 23175947,
 73954,
 -1,
 16687224,
 73965,
 23396714,
 16550956,
 73974,
 23527423,
 23335527,
 73975,
 23592959,
 23396352,
 -1,
 -65176,
 23513659,
 73976,
 -65175,
 23568513,
 73977,
 -1,
 23607141,
 73978,
 23789933,
 23361295,
 73970,
 -65172,
 23732222,
 73972,
 -1,
 23790342,
 73971,
 23986545,
 23734160,
 73966,
 24117247,
 23920640,
 -1,
 -65168,
 24033368,
 74953,
 -1,
 24065879,
 73967,
 24248691,
 23964870,
 73979,
 -1,
 24187788,
 73980,
 24379765,
 24197389,
 73968,
 -1,
 24315283,
 73969,
 -65162,
 24362449,
 73981,
 -65161,
 24478579,
 73973,
 -1,
 24511285,
 73910,
 24707481,
 16475053,
 73984,
 24772995,
 24685766,
 -1,
 24838529,
 24712076,
 73994,
 24969215,
 24775255,
 -1,
 -65155,
 24879883,
 73999,
 -65154,
 24937242,
 73998,
 -65153,
 24995669,
 73997,
 -65152,
 25056678,
 73996,
 -1,
 25106901,
 73995,
 25362431,
 24777319,
 73992,
 -1,
 25232181,
 73993,
 25428366,
 24754689,
 -1,
 25493901,
 25385483,
 74001,
 25624575,
 25427968,
 -1,
 25624972,
 25544609,
 -1,
 25690507,
 25585780,
 -1,
 -65143,
 25675946,
 74004,
 -65142,
 25712718,
 74955,
 -1,
 25765833,
 74003,
 -1,
 25643342,
 74005,
 -1,
 25573260,
 74002,
 -1,
 25435799,
 74000,
 26149266,
 25367722,
 73988,
 26279935,
 26083328,
 -1,
 -65135,
 26189963,
 73989,
 -1,
 26228607,
 73990,
 26411415,
 26083328,
 -1,
 26476950,
 26398061,
 -1,
 -65131,
 26465178,
 73986,
 -1,
 26493438,
 73985,
 -1,
 26425203,
 73987,
 -65128,
 26367176,
 74620,
 -1,
 26688629,
 73991,
 26870195,
 24695706,
 74006,
 26935715,
 26808935,
 74008,
 27066367,
 26869760,
 -1,
 27066786,
 26987885,
 -1,
 27132319,
 27030503,
 74009,
 -1,
 27069109,
 74010,
 -65120,
 27114259,
 74012,
 -65119,
 27235209,
 74011,
 -1,
 27289433,
 74956,
 -1,
 27023796,
 74013,
 27525546,
 26884365,
 74014,
 27656191,
 27459584,
 -1,
 27656616,
 27577709,
 -1,
 -65113,
 27621079,
 74016,
 -1,
 27662816,
 74015,
 -65111,
 27633518,
 74957,
 -1,
 27828372,
 74017,
 27984303,
 27503814,
 74021,
 28049838,
 27972506,
 -1,
 -65107,
 28032335,
 74024,
 -1,
 28085292,
 74023,
 -1,
 27989827,
 74022,
 28311985,
 27951987,
 74019,
 -1,
 28248809,
 74020,
 -65102,
 28276495,
 74018,
 -1,
 28377644,
 74007,
 28639231,
 26821118,
 -1,
 28639672,
 28557086,
 73982,
 28770303,
 28576343,
 -1,
 -65097,
 28693402,
 74954,
 -1,
 28735191,
 73983,
 -1,
 28578662,
 74619,
 28967488,
 16413497,
 -1,
 29032998,
 28907910,
 74071,
 29098511,
 28969559,
 -1,
 29163979,
 29054152,
 -1,
 29229507,
 29123501,
 74087,
 29295042,
 29211983,
 74624,
 29425663,
 29229056,
 -1,
 -65087,
 29337495,
 74089,
 -1,
 29374348,
 74090,
 -1,
 29273383,
 74088,
 29622728,
 29170054,
 74082,
 29688262,
 29600966,
 74085,
 -1,
 29624301,
 74086,
 -65081,
 29658222,
 74084,
 -1,
 29783823,
 74083,
 30015487,
 29610906,
 74091,
 -65078,
 29928765,
 74092,
 -1,
 29964557,
 74625,
 30147030,
 29145601,
 -1,
 30212562,
 30104075,
 -1,
 30278095,
 30200730,
 74115,
 -1,
 30242575,
 74629,
 -65072,
 30238020,
 74114,
 -65071,
 30360062,
 74113,
 -1,
 30415238,
 74112,
 30605780,
 30153094,
 74110,
 -1,
 30584006,
 74111,
 -65067,
 30594618,
 74117,
 -1,
 30697003,
 74116,
 30867934,
 30135194,
 74119,
 30933465,
 30846150,
 74963,
 -1,
 30872167,
 74631,
 -65062,
 30915919,
 74123,
 -65061,
 31034285,
 74122,
 -65060,
 31078669,
 74121,
 -65059,
 31134311,
 74120,
 -1,
 31198020,
 74962,
 31392230,
 30835571,
 -1,
 31457764,
 31343102,
 74100,
 31588351,
 31393526,
 -1,
 -65054,
 31508850,
 74103,
 -65053,
 31545308,
 74102,
 -1,
 31605096,
 74101,
 31850495,
 31417261,
 74104,
 -1,
 31721394,
 74105,
 31916525,
 31332742,
 74072,
 31982058,
 31898959,
 -1,
 -65047,
 31921036,
 74623,
 -1,
 31986279,
 74075,
 32178668,
 31930637,
 74073,
 -1,
 32114549,
 74074,
 -1,
 32150109,
 74622,
 32375284,
 31860575,
 -1,
 32440818,
 32315782,
 -1,
 -65040,
 32419014,
 74078,
 -65039,
 32470981,
 74077,
 -1,
 32520461,
 74076,
 -65037,
 32428954,
 74960,
 -1,
 32662445,
 74079,
 32834041,
 32338745,
 -1,
 32899575,
 32793517,
 74096,
 -1,
 32848141,
 74097,
 33095679,
 32840070,
 74961,
 -1,
 32994105,
 74095,
 33161725,
 32798479,
 -1,
 33227260,
 33149850,
 74099,
 -1,
 33194867,
 74627,
 -1,
 33186733,
 74098,
 33423872,
 33146785,
 -1,
 -65025,
 33411994,
 74630,
 -1,
 33432236,
 74118,
 33620483,
 33399471,
 -1,
 -65022,
 33579949,
 74108,
 -1,
 33626502,
 74628,
 33817094,
 33590316,
 -1,
 -65019,
 33806099,
 74107,
 -1,
 33833470,
 74106,
 34013705,
 33776557,
 -1,
 -65016,
 33981299,
 74094,
 -1,
 34035676,
 74093,
 34210316,
 33964542,
 -1,
 -65013,
 34192790,
 74081,
 -1,
 34256245,
 74080,
 -65011,
 34205060,
 74124,
 -65010,
 34388308,
 74109,
 -1,
 34430554,
 74626,
 34603541,
 29047053,
 -1,
 34669074,
 34542974,
 74131,
 -1,
 34604550,
 74132,
 -65005,
 34608298,
 74130,
 -65004,
 34739084,
 74129,
 -1,
 34804327,
 74128,
 34996761,
 34586853,
 74140,
 35127295,
 34930688,
 -1,
 -65000,
 35037382,
 74142,
 -1,
 35092431,
 74141,
 35258909,
 34961167,
 74135,
 35389439,
 35192832,
 -1,
 -64996,
 35310964,
 74136,
 -1,
 35338150,
 74137,
 35521056,
 35226483,
 -1,
 -64993,
 35460266,
 74139,
 -1,
 35525223,
 74138,
 35717666,
 35484473,
 74133,
 -1,
 35654325,
 74134,
 35848740,
 35656295,
 74125,
 -1,
 35783225,
 74126,
 -64987,
 35824318,
 74607,
 -1,
 35923807,
 74127,
 36110898,
 29021082,
 74154,
 36176425,
 36089030,
 74163,
 -1,
 36111717,
 74164,
 36307499,
 36140815,
 74160,
 -1,
 36242229,
 74161,
 36438573,
 36246698,
 74157,
 -1,
 36375369,
 74158,
 -64978,
 36421417,
 74165,
 -64977,
 36539436,
 74162,
 -64976,
 36575043,
 74159,
 -64975,
 36639628,
 74156,
 -1,
 36701629,
 74155,
 36897342,
 36070317,
 74144,
 36962872,
 36878849,
 -1,
 37028406,
 36923463,
 74152,
 -1,
 36963857,
 74153,
 -64969,
 36985355,
 74151,
 -1,
 37101207,
 74150,
 37290556,
 36899415,
 -1,
 37356091,
 37278618,
 74146,
 -1,
 37304589,
 74147,
 -1,
 37300169,
 74145,
 -64963,
 37260332,
 74149,
 -1,
 37501197,
 74148,
 -64961,
 36890623,
 74166,
 -1,
 37636936,
 74143,
 37814969,
 28948993,
 -1,
 37880449,
 37771787,
 -1,
 37945947,
 37839789,
 -1,
 38011473,
 37913459,
 74438,
 38141951,
 37947991,
 -1,
 38142535,
 38037333,
 74444,
 -1,
 38077237,
 74445,
 38273610,
 38086495,
 -1,
 -64951,
 38262452,
 74441,
 -1,
 38280855,
 74440,
 -64949,
 38255375,
 74449,
 -64948,
 38439789,
 74448,
 -64947,
 38503223,
 74447,
 -64946,
 38565595,
 74446,
 -64945,
 38622681,
 74443,
 -64944,
 38681735,
 74442,
 -1,
 38738310,
 74439,
 38928981,
 37989574,
 74451,
 39059455,
 38862848,
 -1,
 -64940,
 38980155,
 74452,
 -1,
 39035268,
 74453,
 39191129,
 38877453,
 74435,
 39321599,
 39127639,
 -1,
 -64936,
 39217220,
 74437,
 -1,
 39262598,
 74436,
 -64934,
 39176231,
 74454,
 -1,
 39424026,
 74450,
 39584362,
 37886342,
 74413,
 39649894,
 39523212,
 74414,
 39780351,
 39586391,
 -1,
 39780960,
 39703450,
 74421,
 -1,
 39716605,
 74422,
 -64927,
 39768532,
 74420,
 -64926,
 39894825,
 74419,
 -64925,
 39947792,
 74418,
 -64924,
 39999561,
 74417,
 -64923,
 40052681,
 74416,
 -1,
 40114566,
 74415,
 40305256,
 39589491,
 74423,
 -1,
 40241619,
 75057,
 -64919,
 40283431,
 74425,
 -1,
 40380297,
 74424,
 40567418,
 39535102,
 74426,
 40632949,
 40501248,
 -1,
 40698480,
 40609629,
 -1,
 -64914,
 40680352,
 75061,
 -64913,
 40733904,
 75060,
 -1,
 40788757,
 75059,
 40960628,
 40673659,
 75058,
 41091071,
 40894464,
 -1,
 -64909,
 41011257,
 74429,
 -1,
 41047351,
 74428,
 -1,
 40919826,
 74427,
 41288312,
 40615247,
 74432,
 -64905,
 41252925,
 74434,
 -1,
 41292391,
 74433,
 -64903,
 41258028,
 74431,
 -1,
 41440532,
 74430,
 41680895,
 40555418,
 74455,
 41681535,
 41554535,
 74457,
 41811967,
 41617142,
 -1,
 -64898,
 41698079,
 75063,
 -1,
 41763214,
 75062,
 -64896,
 41626941,
 74458,
 -1,
 41879027,
 74456,
 42074791,
 37820806,
 74387,
 42140323,
 42030280,
 74389,
 42270719,
 42074112,
 -1,
 42271391,
 42192237,
 -1,
 42336907,
 42259354,
 -1,
 -64889,
 42319183,
 74406,
 -64888,
 42380486,
 74405,
 -64887,
 42435443,
 74404,
 -64886,
 42477407,
 74403,
 -1,
 42537575,
 74402,
 42730128,
 42318337,
 -1,
 42795663,
 42686987,
 -1,
 -64882,
 42755396,
 74400,
 -1,
 42811946,
 75055,
 -1,
 42737303,
 74399,
 43057811,
 42715175,
 -1,
 -64878,
 43021192,
 75056,
 -1,
 43067231,
 74401,
 43254422,
 43021113,
 -1,
 -64875,
 43243964,
 74395,
 -1,
 43261543,
 74394,
 43451032,
 43204968,
 74391,
 -1,
 43394911,
 74392,
 -64871,
 43422601,
 74398,
 -64870,
 43550717,
 74397,
 -64869,
 43615035,
 74396,
 -64868,
 43673433,
 74646,
 -64867,
 43735581,
 74393,
 -64866,
 43796423,
 75054,
 -1,
 43850118,
 74390,
 44040865,
 42228148,
 74408,
 -1,
 43977387,
 75053,
 -64862,
 44015986,
 74407,
 -1,
 44143523,
 74388,
 44303013,
 42104591,
 74409,
 -1,
 44237794,
 74410,
 -64858,
 44281030,
 74412,
 -1,
 44404632,
 74411,
 44565168,
 42062746,
 74466,
 44630698,
 44543174,
 74473,
 -1,
 44570836,
 74474,
 44761772,
 44598131,
 74471,
 -1,
 44705018,
 74472,
 44892846,
 44710157,
 74468,
 -1,
 44831335,
 74469,
 -64849,
 44852079,
 74470,
 -1,
 44959406,
 74467,
 45219839,
 44524461,
 74459,
 45220532,
 45110472,
 74461,
 45350911,
 45159594,
 74462,
 -1,
 45221511,
 74463,
 45417143,
 45154304,
 -1,
 -64842,
 45403573,
 75064,
 -1,
 45439412,
 74460,
 -64840,
 45381477,
 74465,
 -1,
 45577082,
 74464,
 45744939,
 37763341,
 -1,
 45810420,
 45732762,
 73850,
 45875940,
 45765832,
 73857,
 45941475,
 45812311,
 -1,
 46006979,
 45905679,
 -1,
 46072514,
 45947270,
 -1,
 46138049,
 46039923,
 74911,
 -1,
 46074579,
 74912,
 -1,
 46101360,
 74910,
 -1,
 46061101,
 74913,
 46400201,
 45970233,
 -1,
 46465736,
 46388122,
 -1,
 46531271,
 46448425,
 74908,
 -1,
 46466920,
 74909,
 -1,
 46509254,
 74907,
 -1,
 46408978,
 74906,
 46793422,
 46355656,
 -1,
 46858957,
 46752685,
 74900,
 -64820,
 46841167,
 74902,
 -1,
 46902570,
 74901,
 -1,
 46799238,
 74899,
 47121106,
 46760819,
 -1,
 -64816,
 47080365,
 74916,
 -64815,
 47139616,
 74915,
 -1,
 47195386,
 74914,
 47383254,
 47061382,
 -1,
 47448789,
 47365455,
 74894,
 -1,
 47382838,
 74895,
 -1,
 47419997,
 74893,
 47645401,
 47364609,
 -1,
 -64808,
 47604658,
 74920,
 -1,
 47668378,
 74919,
 47842012,
 47602187,
 -1,
 -64805,
 47801261,
 74904,
 -1,
 47847814,
 74903,
 48038623,
 47790349,
 -1,
 -64802,
 48027411,
 74897,
 -1,
 48064686,
 74896,
 -64800,
 48014915,
 74918,
 -64799,
 48205821,
 74917,
 -64798,
 48260953,
 74905,
 -1,
 48319137,
 74898,
 -1,
 45929909,
 73858,
 48562921,
 45845548,
 73860,
 48628456,
 48501644,
 73861,
 48758783,
 48562997,
 73862,
 -1,
 48628533,
 73863,
 -1,
 48567466,
 73864,
 48890606,
 48506719,
 73854,
 48956141,
 48826967,
 -1,
 -64788,
 48938547,
 74614,
 -1,
 48974664,
 73855,
 -1,
 48894567,
 73856,
 49218290,
 48824320,
 -1,
 -64784,
 49200758,
 73853,
 -64783,
 49258588,
 73851,
 -1,
 49306036,
 73852,
 -64781,
 49196327,
 73865,
 -1,
 49437195,
 73859,
 49611550,
 45750662,
 73813,
 49677080,
 49566920,
 73814,
 49742615,
 49610752,
 -1,
 49808150,
 49706437,
 -1,
 49873662,
 49763528,
 -1,
 49939195,
 49832877,
 73821,
 -1,
 49917223,
 73822,
 50070269,
 49879430,
 73819,
 -1,
 50005915,
 73820,
 -1,
 50058677,
 73823,
 50266883,
 49837839,
 -1,
 50332418,
 50254746,
 73829,
 -64767,
 50299763,
 73831,
 -1,
 50333606,
 73830,
 -1,
 50272646,
 73828,
 50594568,
 50254746,
 -1,
 50660103,
 50533118,
 -1,
 -64762,
 50628095,
 74611,
 -1,
 50681924,
 73836,
 -1,
 50642255,
 73837,
 50922250,
 50556467,
 73825,
 -1,
 50857874,
 73826,
 51053325,
 50866015,
 -1,
 -64756,
 51012525,
 73818,
 -1,
 51060423,
 73817,
 51249936,
 50993542,
 -1,
 -64753,
 51217766,
 73816,
 -1,
 51251099,
 73815,
 -64751,
 51234986,
 73835,
 -64750,
 51429188,
 73834,
 -64749,
 51487719,
 73833,
 -64748,
 51547664,
 73832,
 -64747,
 51606503,
 73827,
 -1,
 51665437,
 73824,
 -1,
 49794430,
 74889,
 -1,
 49681292,
 74612,
 51970844,
 49654982,
 73839,
 52101119,
 51911046,
 -1,
 -64741,
 51975338,
 73841,
 -1,
 52040588,
 73840,
 -64739,
 51938163,
 73838,
 -1,
 52169460,
 74888,
 52428799,
 49570733,
 73842,
 52429606,
 52331379,
 73844,
 52495140,
 52365911,
 -1,
 -64734,
 52483045,
 74891,
 -64733,
 52543027,
 73845,
 -1,
 52586325,
 74890,
 52822015,
 52433511,
 73846,
 -1,
 52693769,
 74892,
 52888360,
 52411727,
 73849,
 -1,
 52824063,
 74613,
 53019434,
 52857900,
 73847,
 -1,
 52954033,
 73848,
 -1,
 52963167,
 73843,
 53216155,
 45732762,
 74507,
 53281641,
 53193926,
 74536,
 53347154,
 53269402,
 74551,
 53412688,
 53283415,
 -1,
 53478197,
 53368008,
 -1,
 53543732,
 53418374,
 74556,
 -64718,
 53521606,
 74559,
 -64717,
 53578862,
 74558,
 -1,
 53638927,
 74557,
 -1,
 53531546,
 74560,
 53871417,
 53466010,
 -1,
 -64713,
 53852508,
 74574,
 -64712,
 53885197,
 74573,
 -1,
 53937981,
 74572,
 54133566,
 53835535,
 -1,
 54199101,
 54121370,
 -1,
 -64708,
 54166387,
 74566,
 -1,
 54203276,
 75072,
 -1,
 54140526,
 75071,
 54461250,
 54092717,
 -1,
 -64704,
 54443343,
 74564,
 -64703,
 54494067,
 74563,
 -1,
 54548444,
 74562,
 54723397,
 54442497,
 -1,
 -64700,
 54683189,
 74570,
 -1,
 54746266,
 74569,
 54920008,
 54671629,
 -1,
 -64697,
 54908691,
 74555,
 -1,
 54928051,
 75070,
 55116618,
 54860166,
 74552,
 -1,
 55099021,
 74553,
 -64693,
 55103875,
 74571,
 -64692,
 55223051,
 74568,
 -64691,
 55281962,
 74567,
 -64690,
 55342465,
 74565,
 -64689,
 55400989,
 74561,
 -1,
 55453748,
 74554,
 55705599,
 53361052,
 74575,
 -1,
 55577344,
 74576,
 55772003,
 53285479,
 74539,
 55902207,
 55705600,
 -1,
 55903074,
 55823725,
 -1,
 55968603,
 55890842,
 -1,
 56034138,
 55906919,
 74545,
 56164351,
 55969526,
 -1,
 -64679,
 56044056,
 74547,
 -1,
 56108282,
 74546,
 -1,
 55982349,
 75069,
 56361824,
 55908742,
 -1,
 56427359,
 56297206,
 -1,
 -64674,
 56396918,
 74541,
 -1,
 56449565,
 74540,
 -1,
 56391439,
 74542,
 -64671,
 56333193,
 74544,
 -1,
 56646173,
 74543,
 -1,
 55864563,
 75068,
 56886117,
 55731117,
 74549,
 -1,
 56824716,
 74550,
 57017192,
 56819712,
 -1,
 -64665,
 56999542,
 74538,
 -1,
 57030631,
 74537,
 -1,
 56956074,
 74548,
 57279349,
 53248883,
 74525,
 57344880,
 57215575,
 -1,
 57410413,
 57312916,
 74648,
 -1,
 57345807,
 74527,
 -64658,
 57398170,
 74529,
 -64657,
 57523614,
 74528,
 -1,
 57571273,
 74526,
 57738100,
 57333433,
 74531,
 57868287,
 57674327,
 -1,
 -64653,
 57778955,
 74533,
 -1,
 57832510,
 74532,
 -1,
 57682532,
 74530,
 58065793,
 57227533,
 74515,
 58131328,
 57999360,
 -1,
 58196860,
 58117485,
 -1,
 58262394,
 58184634,
 74519,
 -1,
 58196789,
 74520,
 -64645,
 58230781,
 74518,
 -1,
 58337225,
 74517,
 58524542,
 58179190,
 74522,
 -1,
 58460767,
 74523,
 -64641,
 58488539,
 74516,
 -1,
 58612148,
 74521,
 -1,
 58119703,
 74524,
 58852234,
 58047823,
 74577,
 58917767,
 58788439,
 -1,
 58983301,
 58881716,
 74579,
 -1,
 58961094,
 74580,
 -64634,
 58968234,
 74581,
 -1,
 59054470,
 74578,
 -64632,
 58910739,
 74582,
 -64631,
 59234063,
 74584,
 -1,
 59249255,
 74583,
 59442066,
 58785792,
 -1,
 59507599,
 59417031,
 -1,
 -64627,
 59495370,
 74512,
 -64626,
 59557598,
 74511,
 -1,
 59613980,
 74510,
 59769745,
 59495322,
 74649,
 -1,
 59706177,
 74509,
 -1,
 59726240,
 74508,
 59966358,
 59436080,
 -1,
 60031893,
 59904908,
 74586,
 -1,
 59968197,
 74587,
 -1,
 60019610,
 74588,
 60228504,
 59935788,
 74534,
 -1,
 60162869,
 74535,
 -64615,
 60215733,
 74585,
 -64614,
 60303199,
 74514,
 -1,
 60363367,
 74513,
 60556283,
 53185580,
 -1,
 60621768,
 60515245,
 74316,
 60687297,
 60591148,
 74639,
 60752832,
 60635585,
 74322,
 60882943,
 60688983,
 -1,
 60883877,
 60806042,
 75050,
 -64606,
 60865871,
 74335,
 -64605,
 60930396,
 75052,
 -64604,
 60953350,
 74334,
 -1,
 61016104,
 75051,
 61211562,
 60866099,
 74330,
 61341695,
 61146877,
 -1,
 61342633,
 61259087,
 74332,
 -1,
 61277957,
 74333,
 -1,
 61276222,
 74331,
 61539248,
 61166792,
 -1,
 61604782,
 61526938,
 -1,
 -64595,
 61568783,
 75044,
 -1,
 61618445,
 74326,
 61865983,
 61563821,
 74642,
 -1,
 61783375,
 75043,
 61932468,
 61479302,
 -1,
 61998003,
 61914447,
 74324,
 -1,
 61933317,
 74325,
 -1,
 61967404,
 74323,
 62194615,
 61901868,
 -1,
 -64586,
 62183187,
 74329,
 -1,
 62210558,
 74328,
 62391226,
 62161779,
 -1,
 -64583,
 62341802,
 74327,
 -1,
 62399738,
 75048,
 -64581,
 62366695,
 75049,
 -64580,
 62552098,
 75047,
 -64579,
 62616834,
 75046,
 -64578,
 62676561,
 75045,
 -64577,
 62733433,
 75042,
 -1,
 62793703,
 74641,
 -1,
 60692692,
 74640,
 63046597,
 60654451,
 74319,
 63176703,
 62982800,
 -1,
 -64572,
 63089885,
 74321,
 -1,
 63147118,
 74320,
 -64570,
 63027963,
 74336,
 -64569,
 63246951,
 74318,
 -1,
 63310459,
 74317,
 63505385,
 60609434,
 74337,
 63570916,
 63474732,
 74339,
 63636441,
 63560613,
 74349,
 63766527,
 63569920,
 -1,
 63767511,
 63642248,
 -1,
 -64562,
 63755298,
 74359,
 -64561,
 63815690,
 74358,
 -64560,
 63868432,
 74357,
 -64559,
 63928153,
 74356,
 -64558,
 63992774,
 74355,
 -64557,
 64055129,
 74354,
 -64556,
 64117152,
 74353,
 -64555,
 64176522,
 74352,
 -64554,
 64236056,
 74351,
 -1,
 64300291,
 74350,
 64552959,
 63731155,
 74360,
 -1,
 64424769,
 74361,
 64684031,
 63569920,
 -1,
 64685024,
 64583675,
 -1,
 64750557,
 64666383,
 74342,
 -1,
 64685677,
 74343,
 -64546,
 64740056,
 74344,
 -64545,
 64849407,
 74341,
 -1,
 64902617,
 74340,
 65078242,
 64632782,
 74347,
 -1,
 65012724,
 74348,
 -64541,
 65063483,
 74345,
 -1,
 65184067,
 74346,
 65404927,
 63509058,
 74338,
 65470463,
 65273856,
 -1,
 -64537,
 65391163,
 983260,
 -64536,
 65452120,
 74643,
 -1,
 65511724,
 983261,
 65668085,
 63445382,
 74302,
 65733616,
 65623319,
 74304,
 65799151,
 65667072,
 -1,
 -64531,
 65785254,
 74306,
 -64530,
 65838057,
 74307,
 -1,
 65891571,
 74305,
 -1,
 65776838,
 74308,
 66126835,
 65700723,
 74310,
 -64526,
 66064999,
 74311,
 -1,
 66127092,
 74309,
 -64524,
 66065578,
 74638,
 -1,
 66261607,
 74303,
 66519039,
 65618430,
 74312,
 66584575,
 66387968,
 -1,
 66585594,
 66506093,
 -1,
 -64519,
 66573749,
 74314,
 -1,
 66591110,
 74313,
 -1,
 66567798,
 74315,
 66847826,
 60496262,
 73728,
 66913304,
 66791263,
 73738,
 66978832,
 66846720,
 -1,
 67044367,
 66964845,
 -1,
 67109890,
 67026255,
 -1,
 -64511,
 67097634,
 74881,
 -1,
 67128132,
 73747,
 67306500,
 67081097,
 74608,
 -1,
 67242451,
 74880,
 67437575,
 67265453,
 -1,
 -64506,
 67406122,
 73745,
 -1,
 67459039,
 73744,
 67634186,
 67392791,
 -1,
 -64503,
 67603566,
 73742,
 -1,
 67663631,
 73741,
 -64501,
 67621818,
 73748,
 -64500,
 67794889,
 73746,
 -64499,
 67852829,
 73743,
 -64498,
 67912091,
 73740,
 -1,
 67970302,
 73739,
 -1,
 67000756,
 73749,
 68288511,
 66916967,
 73750,
 68354047,
 68160087,
 -1,
 -64493,
 68274346,
 73755,
 -64492,
 68337054,
 73754,
 -64491,
 68388519,
 73753,
 -64490,
 68441510,
 73752,
 -64489,
 68495339,
 73751,
 -1,
 68557190,
 74609,
 68748325,
 66877199,
 73760,
 68813859,
 68684375,
 -1,
 68879389,
 68776761,
 -1,
 -64484,
 68838317,
 73766,
 -1,
 68885511,
 73765,
 -64482,
 68868824,
 73768,
 -64481,
 69058099,
 73767,
 -64480,
 69098013,
 73764,
 -64479,
 69163081,
 73763,
 -64478,
 69221506,
 73762,
 -1,
 69279383,
 73761,
 -64476,
 68766119,
 73770,
 -1,
 69410885,
 73769,
 69600305,
 68729345,
 -1,
 69665840,
 69556747,
 73784,
 69731374,
 69599232,
 -1,
 69796908,
 69705801,
 -1,
 69862443,
 69771328,
 73788,
 -1,
 69796349,
 73789,
 -1,
 69849487,
 73787,
 -64467,
 69791111,
 73785,
 -1,
 70022072,
 73786,
 -64465,
 69686575,
 73791,
 -1,
 70128231,
 73790,
 -1,
 69607102,
 73783,
 70386746,
 69536343,
 -1,
 -64461,
 70367995,
 73736,
 -64460,
 70421487,
 73735,
 -64459,
 70481904,
 73734,
 -64458,
 70543189,
 73733,
 -64457,
 70605341,
 73732,
 -64456,
 70669734,
 73731,
 -64455,
 70723529,
 73730,
 -1,
 70785414,
 73729,
 70976578,
 70356012,
 73773,
 71042113,
 70909952,
 -1,
 71107647,
 71018380,
 -1,
 -64450,
 71091059,
 73777,
 -1,
 71146414,
 73776,
 -64448,
 71093308,
 73775,
 -1,
 71278648,
 73774,
 -1,
 71024179,
 73778,
 71500870,
 70954182,
 -1,
 71566405,
 71441379,
 73780,
 -1,
 71502547,
 73781,
 -1,
 71529396,
 73782,
 71763018,
 71468390,
 73771,
 71892991,
 71699031,
 -1,
 -64439,
 71810611,
 73772,
 -1,
 71857855,
 74610,
 72025166,
 71725881,
 73757,
 72155135,
 71961175,
 -1,
 -64435,
 72072880,
 73759,
 -1,
 72108705,
 73758,
 72287312,
 71973133,
 73756,
 -1,
 72223364,
 74882,
 -64431,
 72263311,
 73779,
 -1,
 72356455,
 73737,
 72549529,
 66798078,
 73866,
 72615033,
 72543489,
 73889,
 72744959,
 72548352,
 -1,
 72746096,
 72666477,
 -1,
 72811611,
 72709903,
 -1,
 72877145,
 72751494,
 73903,
 -1,
 72841005,
 73904,
 -64422,
 72864666,
 73906,
 -1,
 72967085,
 73905,
 73139295,
 72751494,
 73890,
 73204830,
 73074568,
 73891,
 -1,
 73140958,
 73892,
 -1,
 73174060,
 73893,
 73401443,
 73102137,
 -1,
 73466978,
 73344274,
 73900,
 -1,
 73402741,
 73901,
 -1,
 73454640,
 73902,
 73663590,
 73388954,
 -1,
 -64411,
 73611533,
 73908,
 -1,
 73667175,
 73907,
 73860201,
 73644545,
 -1,
 -64408,
 73847706,
 74933,
 -1,
 73882778,
 74616,
 74056811,
 73816605,
 73897,
 -1,
 73990965,
 73898,
 74187885,
 74006939,
 73895,
 -1,
 74122037,
 73896,
 -64402,
 74147673,
 73899,
 -64401,
 74275232,
 74615,
 -1,
 74328009,
 73894,
 74579967,
 72728190,
 -1,
 74581107,
 74483348,
 74930,
 -1,
 74562049,
 74931,
 74712181,
 74544985,
 74928,
 -1,
 74675983,
 74929,
 -64394,
 74696321,
 74932,
 -64393,
 74803033,
 74927,
 -64392,
 74866257,
 74926,
 -1,
 74917114,
 74925,
 75105412,
 72553063,
 73869,
 75235327,
 75041367,
 -1,
 75236478,
 75151873,
 -1,
 -64387,
 75193498,
 73874,
 -1,
 75243159,
 73873,
 -64385,
 75223962,
 73875,
 -64384,
 75408332,
 74922,
 -64383,
 75466749,
 73872,
 -64382,
 75527895,
 74921,
 -64381,
 75584985,
 73871,
 -1,
 75635139,
 73870,
 75826317,
 75074604,
 73879,
 75956223,
 75759616,
 -1,
 75957386,
 75877741,
 -1,
 76022921,
 75912609,
 73880,
 -1,
 75958739,
 73881,
 -1,
 75990676,
 73882,
 -64373,
 75940723,
 73885,
 -64372,
 76192708,
 73884,
 -1,
 76232523,
 73883,
 76416145,
 75803846,
 -1,
 76481680,
 76376297,
 73887,
 -1,
 76418713,
 74923,
 -1,
 76433351,
 73886,
 76678291,
 76397974,
 73888,
 -1,
 76612125,
 74924,
 76809366,
 76611584,
 -1,
 -64363,
 76795282,
 73867,
 -1,
 76849252,
 73868,
 -64361,
 76773135,
 73878,
 -64360,
 76961856,
 73877,
 -1,
 77020295,
 73876,
 77202629,
 72533921,
 -1,
 77268145,
 77142406,
 74475,
 77333668,
 77223112,
 74483,
 77463551,
 77269591,
 -1,
 77464736,
 77380943,
 -1,
 -64353,
 77452186,
 74487,
 -1,
 77480446,
 74486,
 -64351,
 77452725,
 74489,
 -64350,
 77648266,
 74488,
 -64349,
 77683104,
 74485,
 -1,
 77736472,
 74484,
 77923498,
 77266944,
 -1,
 77989032,
 77909357,
 -1,
 -64345,
 77957117,
 74478,
 -1,
 78011985,
 74477,
 -64343,
 77945268,
 74479,
 -1,
 78128464,
 74476,
 78316718,
 77866847,
 74480,
 78446591,
 78249984,
 -1,
 -64339,
 78365555,
 74482,
 -1,
 78422427,
 74481,
 78578864,
 78279560,
 74490,
 -1,
 78514147,
 75065,
 -1,
 78556358,
 74491,
 78775482,
 77255578,
 74501,
 78841014,
 78742387,
 74504,
 78970879,
 78776919,
 -1,
 -64331,
 78891987,
 75067,
 -1,
 78927270,
 75066,
 79103160,
 78818502,
 74505,
 -1,
 79038135,
 74506,
 -64327,
 79065913,
 74503,
 -1,
 79189262,
 74502,
 79365315,
 78734253,
 74494,
 79430848,
 79342790,
 74497,
 79560703,
 79364096,
 -1,
 79561919,
 79471038,
 74499,
 -1,
 79495942,
 74500,
 -1,
 79547829,
 74498,
 -64319,
 79394575,
 74496,
 -64318,
 79696487,
 74647,
 -1,
 79759827,
 74495,
 80019455,
 79315454,
 74492,
 -1,
 79889205,
 74493,
 80086255,
 77169523,
 -1,
 80151776,
 80073626,
 74284,
 80217307,
 80133455,
 74290,
 80282835,
 80150528,
 -1,
 80348366,
 80257314,
 74294,
 80478207,
 80284247,
 -1,
 -64308,
 80376807,
 75041,
 -64307,
 80434455,
 75040,
 -1,
 80484843,
 74295,
 80676050,
 80334189,
 -1,
 -64304,
 80669790,
 74293,
 -64303,
 80705239,
 74292,
 -1,
 80746886,
 74291,
 -1,
 80623552,
 74296,
 81068031,
 80221068,
 74297,
 81133567,
 80936960,
 -1,
 81134810,
 81055085,
 -1,
 81200344,
 81074566,
 74298,
 -1,
 81135384,
 74299,
 -64295,
 81194078,
 74637,
 -1,
 81279939,
 74300,
 -1,
 81090996,
 74301,
 81528029,
 80172232,
 74286,
 -1,
 81462069,
 74287,
 -64290,
 81506971,
 74289,
 -64289,
 81629828,
 74288,
 -1,
 81659482,
 74285,
 81855721,
 80091526,
 74272,
 81921251,
 81837391,
 74278,
 -1,
 81859175,
 74279,
 82052326,
 81854464,
 -1,
 -64283,
 82038197,
 74273,
 -1,
 82074036,
 74274,
 -64281,
 82029766,
 74277,
 -64280,
 82205195,
 74276,
 -1,
 82252391,
 74275,
 82445548,
 81814445,
 74282,
 -64277,
 82414636,
 74283,
 -1,
 82446384,
 75039,
 82706431,
 82395646,
 74280,
 82771967,
 82622977,
 74281,
 -1,
 82663947,
 74636,
 82838798,
 80029535,
 -1,
 82904318,
 82778502,
 73792,
 82969846,
 82861078,
 73795,
 83099647,
 82905687,
 -1,
 -64268,
 83029086,
 74886,
 -64267,
 83070973,
 74885,
 -1,
 83106436,
 74884,
 83297529,
 82933519,
 73796,
 -64264,
 83238165,
 73798,
 -1,
 83297661,
 73797,
 83494139,
 83274950,
 73799,
 -1,
 83434049,
 73800,
 83625213,
 83441933,
 73793,
 -1,
 83561066,
 74883,
 -1,
 83580177,
 73794,
 83821833,
 82891674,
 73805,
 83887365,
 83755008,
 -1,
 83952900,
 83861587,
 -1,
 -64254,
 83941139,
 73807,
 -64253,
 84004232,
 74887,
 -1,
 84023937,
 73806,
 -1,
 83900223,
 73808,
 84280583,
 83864774,
 73811,
 -1,
 84218471,
 73812,
 84475903,
 84247347,
 73809,
 -1,
 84346247,
 73810,
 84606975,
 83780525,
 73801,
 84672511,
 84478551,
 -1,
 -64244,
 84567897,
 73804,
 -64243,
 84628953,
 73803,
 -1,
 84679046,
 73802,
 84870443,
 82795019,
 -1,
 84935963,
 84829101,
 74029,
 85065727,
 84871767,
 -1,
 85067028,
 84944122,
 74030,
 -64237,
 85004903,
 74031,
 -1,
 85067178,
 74959,
 -64235,
 85054362,
 74038,
 -64234,
 85245491,
 74037,
 -64233,
 85300105,
 74036,
 -64232,
 85357976,
 74035,
 -64231,
 85415219,
 74034,
 -64230,
 85474514,
 74033,
 -1,
 85534665,
 74032,
 85722405,
 84923290,
 74039,
 85787939,
 85665649,
 74040,
 85917695,
 85723735,
 -1,
 -64225,
 85841333,
 74045,
 -64224,
 85884804,
 74044,
 -64223,
 85947454,
 74043,
 -64222,
 86006434,
 74042,
 -1,
 86057029,
 74041,
 -64220,
 85769551,
 74621,
 -1,
 86210390,
 74046,
 86441983,
 85662086,
 74025,
 86443306,
 86310912,
 -1,
 86508841,
 86428219,
 74026,
 -1,
 86442805,
 74958,
 -1,
 86464948,
 74027,
 -1,
 86406927,
 74028,
 86771014,
 84829101,
 74047,
 86836531,
 86737779,
 74062,
 86902066,
 86769664,
 -1,
 -64209,
 86887861,
 74063,
 -64208,
 86950771,
 74066,
 -64207,
 87006160,
 74065,
 -1,
 87046042,
 74064,
 -1,
 86861998,
 74067,
 87295290,
 86791368,
 74053,
 87425023,
 87253933,
 74054,
 87490559,
 87293952,
 -1,
 -64201,
 87405243,
 74056,
 -64200,
 87466147,
 74057,
 -64199,
 87513524,
 74058,
 -1,
 87571519,
 74055,
 87754045,
 87258895,
 74059,
 -64196,
 87691879,
 74061,
 -1,
 87755418,
 74060,
 87950657,
 87702645,
 74050,
 88080383,
 87885287,
 -1,
 -64192,
 87999347,
 74052,
 -1,
 88026429,
 74051,
 -64190,
 87932239,
 74070,
 -64189,
 88190150,
 74069,
 -64188,
 88247340,
 74068,
 -64187,
 88287071,
 74049,
 -1,
 88342530,
 74048,
 88540516,
 86745775,
 -1,
 88606046,
 88499117,
 74367,
 88671573,
 88539136,
 -1,
 88737108,
 88657261,
 -1,
 88802636,
 88724378,
 74375,
 -1,
 88740455,
 74376,
 88933710,
 88761261,
 74373,
 -1,
 88876895,
 74374,
 89064785,
 88876895,
 -1,
 -64176,
 89052058,
 74371,
 -1,
 89088941,
 74370,
 89261395,
 89004422,
 74368,
 -1,
 89204575,
 74369,
 -1,
 89211390,
 74372,
 -1,
 88684507,
 74377,
 89587711,
 88648902,
 -1,
 89589085,
 89482795,
 74378,
 89718783,
 89522176,
 -1,
 89720156,
 89640301,
 -1,
 -64166,
 89713758,
 74381,
 -64165,
 89773493,
 74380,
 -1,
 89814000,
 74379,
 -1,
 89693175,
 74382,
 -1,
 89526887,
 74645,
 90113378,
 88545670,
 74362,
 -64160,
 90088111,
 74365,
 -64159,
 90147884,
 74364,
 -1,
 90192141,
 74363,
 90439679,
 90065736,
 74366,
 -1,
 90308899,
 74644,
 90506620,
 88534064,
 -1,
 90572141,
 90493850,
 74602,
 90637674,
 90510718,
 74603,
 90767359,
 90573399,
 -1,
 -64151,
 90688478,
 75075,
 -1,
 90708358,
 74604,
 -64149,
 90604403,
 74606,
 -64148,
 90844477,
 74605,
 -1,
 90900181,
 75074,
 91096436,
 90530733,
 74595,
 91161968,
 91039583,
 74598,
 -1,
 91095967,
 74599,
 -64143,
 91155547,
 74601,
 -64142,
 91247816,
 74600,
 -64141,
 91296652,
 74597,
 -1,
 91358924,
 74596,
 91555195,
 91036038,
 74589,
 91620728,
 91488256,
 -1,
 -64137,
 91605563,
 74590,
 -1,
 91669380,
 74591,
 -64135,
 91589648,
 74593,
 -64134,
 91772104,
 74592,
 -1,
 91821891,
 75073,
 -1,
 91505436,
 74594,
 92143615,
 90483910,
 -1,
 92145023,
 92019078,
 74383,
 -1,
 92088159,
 74384,
 -64128,
 92132250,
 74386,
 -1,
 92234669,
 74385,
 92407324,
 234363,
 -1,
 92472746,
 92360337,
 -1,
 92538264,
 92446465,
 -1,
 92603785,
 92527704,
 74812,
 92669320,
 92536832,
 -1,
 -64121,
 92612447,
 74815,
 -1,
 92674438,
 74814,
 -1,
 92607658,
 74813,
 92931469,
 92546911,
 -1,
 92997004,
 92872799,
 74834,
 -1,
 92932937,
 74835,
 -1,
 92986002,
 74808,
 93193615,
 92918682,
 74767,
 -1,
 93129545,
 74857,
 93324690,
 93175324,
 -1,
 -64111,
 93311898,
 74800,
 -1,
 93327975,
 74790,
 93521301,
 93279980,
 -1,
 -64108,
 93508506,
 74785,
 -1,
 93524583,
 74776,
 93717911,
 93463802,
 74754,
 -1,
 93653459,
 74828,
 -1,
 93666514,
 74761,
 93978623,
 92500162,
 -1,
 93980062,
 93895169,
 -1,
 94045597,
 93936658,
 -1,
 -64100,
 94032794,
 74801,
 -1,
 94048871,
 74791,
 -1,
 94007725,
 74844,
 94307746,
 93923167,
 -1,
 94373281,
 94249055,
 74836,
 -1,
 94309193,
 74837,
 -1,
 94362258,
 74809,
 94569892,
 94294938,
 74768,
 -1,
 94505801,
 74858,
 94700967,
 94525164,
 -1,
 -64090,
 94688154,
 74786,
 -1,
 94704231,
 74777,
 94897577,
 94643450,
 74755,
 -1,
 94833107,
 74829,
 -1,
 94846162,
 74762,
 95094222,
 92456865,
 -1,
 95159742,
 95052261,
 -1,
 95225265,
 95141404,
 -1,
 95290799,
 95212442,
 74798,
 -1,
 95226697,
 74799,
 95485951,
 95228519,
 74788,
 -1,
 95357769,
 74789,
 95552949,
 95168351,
 -1,
 95618484,
 95541906,
 74806,
 -1,
 95554377,
 74807,
 -1,
 95559775,
 74833,
 95815096,
 95542305,
 -1,
 -64073,
 95753059,
 74811,
 -1,
 95818321,
 74810,
 96011707,
 95770348,
 -1,
 -64070,
 95998874,
 74784,
 -1,
 96014951,
 74775,
 96208317,
 95954170,
 74753,
 -1,
 96143827,
 74827,
 -1,
 96156882,
 74760,
 96468991,
 95151641,
 -1,
 96470466,
 96390015,
 -1,
 -64063,
 96459776,
 74846,
 -1,
 96484562,
 74843,
 96667077,
 96452124,
 -1,
 -64060,
 96654234,
 74797,
 -1,
 96670311,
 74787,
 96863688,
 96622316,
 -1,
 -64057,
 96850842,
 74783,
 -1,
 96866919,
 74774,
 97060299,
 96806751,
 -1,
 -64054,
 97049234,
 74805,
 -1,
 97067103,
 74832,
 97256909,
 97002746,
 74752,
 -1,
 97192403,
 74826,
 -1,
 97209165,
 74841,
 97453543,
 95074817,
 -1,
 97519067,
 97406106,
 -1,
 97584597,
 97508422,
 -1,
 97650132,
 97517568,
 -1,
 -64045,
 97593183,
 74819,
 -1,
 97655174,
 74818,
 -1,
 97588108,
 74817,
 97912279,
 97571738,
 74770,
 -1,
 97848137,
 74860,
 -64040,
 97893921,
 74793,
 -64039,
 97998577,
 74779,
 -64038,
 98057426,
 74764,
 -1,
 98116858,
 74757,
 98305508,
 97481075,
 -1,
 98371038,
 98292634,
 74769,
 -1,
 98306889,
 74859,
 98502112,
 98313466,
 74756,
 -1,
 98437587,
 74830,
 -64031,
 98491407,
 74816,
 -64030,
 98614817,
 74792,
 -64029,
 98653937,
 74778,
 -1,
 98712786,
 74763,
 98959359,
 98262043,
 -1,
 -64026,
 98863402,
 74803,
 -1,
 98909394,
 74802,
 99091965,
 97424407,
 -1,
 99157498,
 99061267,
 -1,
 99223020,
 99142506,
 -1,
 -64021,
 99212288,
 74845,
 -1,
 99237074,
 74842,
 99419631,
 99199969,
 -1,
 -64018,
 99375560,
 74851,
 -1,
 99427578,
 74848,
 99616242,
 99374828,
 -1,
 -64015,
 99603354,
 74782,
 -1,
 99619431,
 74773,
 99812853,
 99566078,
 -1,
 -64012,
 99794487,
 74840,
 -1,
 99837754,
 74847,
 100009464,
 99755871,
 -1,
 -64009,
 99998354,
 74804,
 -1,
 100016223,
 74831,
 -64007,
 99991085,
 74796,
 -1,
 100162283,
 74852,
 100401151,
 99121597,
 -1,
 -64004,
 100319432,
 74849,
 -1,
 100379609,
 74850,
 100533772,
 99061757,
 -1,
 100599305,
 100503059,
 -1,
 100664835,
 100588594,
 74822,
 -63999,
 100603050,
 74824,
 -63998,
 100668300,
 74823,
 -1,
 100728834,
 74825,
 100926981,
 100651930,
 74772,
 -1,
 100862793,
 74862,
 -63994,
 100908577,
 74795,
 -63993,
 101013233,
 74781,
 -63992,
 101072082,
 74766,
 -1,
 101131514,
 74759,
 101384191,
 100554754,
 -1,
 -63989,
 101288234,
 74838,
 -1,
 101337924,
 74839,
 101580799,
 100483582,
 -1,
 101582358,
 101476050,
 -1,
 101647888,
 101571691,
 74820,
 -1,
 101585804,
 74821,
 101778962,
 101634970,
 74771,
 -1,
 101714761,
 74861,
 -63981,
 101760545,
 74794,
 -63980,
 101865201,
 74780,
 -63979,
 101924050,
 74765,
 -1,
 101983482,
 74758,
 102236159,
 101546077,
 -1,
 102237722,
 102125201,
 -1,
 -63975,
 102210897,
 74855,
 -1,
 102262289,
 74856,
 -63973,
 102224755,
 74854,
 -1,
 102406405,
 74853,
 102629375,
 92383915,
 -1,
 102630945,
 102513663,
 -1,
 -63969,
 102617226,
 74867,
 -63968,
 102673278,
 74868,
 -1,
 102708310,
 74866,
 -63966,
 102620642,
 74865,
 -1,
 102864530,
 74864,
 103024170,
 175302,
 -1,
 103089703,
 103001286,
 -1,
 -63962,
 103082281,
 127835,
 -1,
 103106630,
 128177,
 103350271,
 103053071,
 -1,
 -63959,
 103278925,
 10160,
 -1,
 103312195,
 129356,
 103482928,
 102998703,
 -1,
 103548462,
 103415808,
 -1,
 -63955,
 103540032,
 129380,
 -1,
 103585729,
 9982,
 -63953,
 103507366,
 11232,
 -1,
 103689741,
 129473,
 103876147,
 103466053,
 -1,
 -63950,
 103847862,
 128707,
 -1,
 103883553,
 127854,
 -63948,
 103860225,
 129385,
 -1,
 104020059,
 129362,
 104204435,
 103447,
 -1,
 104269701,
 104170355,
 -1,
 104335234,
 104213112,
 -1,
 104400518,
 104289480,
 -1,
 104466027,
 104364040,
 -1,
 104531523,
 104458532,
 -1,
 104597056,
 104481278,
 -1,
 104662591,
 104574150,
 -1,
 -63938,
 104649626,
 122911,
 -1,
 104686509,
 122912,
 -1,
 104646252,
 122885,
 -63935,
 104584090,
 122915,
 -63934,
 104895511,
 122918,
 -1,
 104932869,
 122913,
 105121353,
 104489901,
 122891,
 105186887,
 105094603,
 -1,
 -63930,
 105169444,
 122919,
 -1,
 105196104,
 122921,
 -63928,
 105180540,
 122889,
 -1,
 105353419,
 122890,
 105514575,
 105101825,
 -1,
 105580109,
 105470475,
 -1,
 -63924,
 105564199,
 122907,
 -1,
 105585030,
 122910,
 -63922,
 105547008,
 122916,
 -1,
 105742736,
 122900,
 105907794,
 105507888,
 -1,
 -63919,
 105865184,
 122886,
 -1,
 105924525,
 122888,
 106104405,
 105891745,
 -1,
 -63916,
 106094731,
 122901,
 -1,
 106151748,
 122908,
 106301016,
 106057361,
 -1,
 -63913,
 106280719,
 122903,
 -1,
 106328069,
 122922,
 106497627,
 106248461,
 -1,
 -63910,
 106468514,
 122884,
 -1,
 106525336,
 122892,
 106694238,
 106440543,
 -1,
 -63907,
 106681971,
 122881,
 -1,
 106718766,
 122920,
 -63905,
 106683605,
 122882,
 -63904,
 106878570,
 122902,
 -63903,
 106936073,
 122899,
 -63902,
 106997876,
 122898,
 -63901,
 107059764,
 122897,
 -63900,
 107121921,
 122896,
 -63899,
 107187236,
 122895,
 -63898,
 107249608,
 122894,
 -63897,
 107312107,
 122893,
 -63896,
 107371994,
 122904,
 -63895,
 107436132,
 122883,
 -63894,
 107491726,
 122909,
 -1,
 107554651,
 122880,
 107806719,
 104443078,
 -1,
 107808385,
 107682182,
 -1,
 107873918,
 107778801,
 -1,
 107939448,
 107822179,
 -1,
 108004978,
 107923361,
 -1,
 -63887,
 107996694,
 70504,
 -1,
 108028384,
 70505,
 108201589,
 107957905,
 -1,
 -63884,
 108175101,
 70506,
 -1,
 108228798,
 70507,
 -63882,
 108195099,
 70502,
 -63881,
 108380307,
 70508,
 -1,
 108435541,
 70503,
 108658687,
 107904342,
 -1,
 -63878,
 108584637,
 70515,
 -63877,
 108634891,
 70516,
 -63876,
 108694646,
 70514,
 -63875,
 108753803,
 70513,
 -1,
 108796294,
 70512,
 109051903,
 107863249,
 -1,
 -63872,
 108954610,
 7621,
 -1,
 108993495,
 7624,
 109248511,
 107758882,
 -1,
 109250181,
 109168545,
 -1,
 -63868,
 109229751,
 119362,
 -1,
 109267883,
 119363,
 -1,
 109225367,
 119364,
 109512394,
 104344995,
 -1,
 109577928,
 109505553,
 -1,
 109643452,
 109542742,
 -1,
 109708945,
 109593086,
 -1,
 109774476,
 109689345,
 11757,
 -1,
 109711383,
 11765,
 -63859,
 109751494,
 11756,
 -63858,
 109874220,
 11753,
 -63857,
 109937523,
 11752,
 -63856,
 109999887,
 11751,
 -1,
 110055057,
 42654,
 110233239,
 109667245,
 42613,
 110298774,
 110206467,
 -1,
 -63852,
 110248446,
 42655,
 -63851,
 110307912,
 11775,
 -1,
 110369158,
 11772,
 -1,
 110248446,
 11767,
 110626460,
 110225700,
 -1,
 -63847,
 110613402,
 11771,
 -63846,
 110650285,
 42614,
 -63845,
 110709514,
 42617,
 -1,
 110765401,
 11770,
 110954145,
 110606849,
 -1,
 111019680,
 110909963,
 -1,
 -63841,
 110964847,
 11763,
 -1,
 111024518,
 11762,
 -1,
 110990742,
 42618,
 111281828,
 110947376,
 -1,
 -63837,
 111238298,
 11748,
 -1,
 111297022,
 11749,
 111478438,
 111268762,
 42615,
 -1,
 111441543,
 42612,
 111609513,
 111462305,
 -1,
 -63832,
 111590425,
 11760,
 -1,
 111624702,
 11758,
 111806123,
 111580183,
 11754,
 -1,
 111773533,
 42619,
 111937197,
 111761949,
 11759,
 -1,
 111914865,
 42616,
 112068272,
 111884557,
 -1,
 -63825,
 112030355,
 11768,
 -1,
 112083454,
 11747,
 112264883,
 112011103,
 -1,
 -63822,
 112223790,
 11774,
 -1,
 112280062,
 11744,
 -63820,
 112254104,
 11745,
 -63819,
 112436431,
 11755,
 -63818,
 112495239,
 11769,
 -63817,
 112557998,
 11773,
 -63816,
 112620427,
 11750,
 -63815,
 112678746,
 11746,
 -63814,
 112742693,
 11764,
 -63813,
 112799939,
 11761,
 -1,
 112859526,
 11766,
 113051330,
 109627297,
 -1,
 113116864,
 113012884,
 -1,
 -63809,
 113095550,
 65071,
 -1,
 113146625,
 65070,
 -63807,
 113074605,
 42610,
 -1,
 113264598,
 42608,
 113444549,
 113025711,
 -1,
 -63804,
 113415798,
 1159,
 -1,
 113452875,
 42621,
 -63802,
 113434805,
 42607,
 -63801,
 113603721,
 42620,
 -1,
 113664827,
 42609,
 113901567,
 109550033,
 65062,
 -1,
 113770856,
 65069,
 113968901,
 109475599,
 -1,
 114034422,
 113911305,
 -1,
 114099952,
 114016654,
 -1,
 114165459,
 114039174,
 -1,
 -63793,
 114154416,
 7638,
 -63792,
 114201623,
 7637,
 -63791,
 114262643,
 7655,
 -63790,
 114311678,
 7636,
 -1,
 114363393,
 7666,
 114558678,
 114128655,
 7645,
 -63787,
 114530677,
 7653,
 -1,
 114560077,
 7660,
 114755289,
 114545643,
 -1,
 -63784,
 114720412,
 7664,
 -1,
 114768862,
 7668,
 114951899,
 114735617,
 7652,
 -1,
 114897346,
 7658,
 115082974,
 114928840,
 -1,
 -63779,
 115062914,
 7651,
 -1,
 115091786,
 7626,
 115279585,
 115053623,
 -1,
 -63776,
 115244700,
 7661,
 -1,
 115293150,
 7667,
 115476195,
 115232401,
 7659,
 -1,
 115439984,
 7635,
 115607270,
 115425790,
 -1,
 -63771,
 115591870,
 7641,
 -1,
 115653967,
 7663,
 115803880,
 115550047,
 7656,
 -1,
 115755912,
 7657,
 -63767,
 115797040,
 7654,
 -63766,
 115925179,
 7665,
 -63765,
 115974831,
 7662,
 -63764,
 116034604,
 7648,
 -63763,
 116093753,
 7644,
 -63762,
 116157572,
 7640,
 -63761,
 116217032,
 7642,
 -1,
 116272552,
 7639,
 116523007,
 114064771,
 -1,
 -63758,
 116436166,
 7650,
 -63757,
 116493356,
 7649,
 -63756,
 116556659,
 7647,
 -63755,
 116619023,
 7646,
 -1,
 116675784,
 7643,
 116852479,
 113984966,
 -1,
 116918014,
 116785152,
 -1,
 116983549,
 116859922,
 -1,
 117049084,
 116939946,
 -1,
 -63749,
 116992330,
 852,
 -1,
 117054174,
 7678,
 -1,
 116982120,
 8430,
 -1,
 116939518,
 849,
 -1,
 116908453,
 8429,
 117442308,
 116811307,
 -1,
 117507843,
 117384792,
 -1,
 -63742,
 117486473,
 65064,
 -1,
 117537547,
 65063,
 -1,
 117465843,
 6841,
 -1,
 117414224,
 8427,
 117835574,
 113916173,
 -1,
 117901088,
 117785086,
 -1,
 117966623,
 117890014,
 -1,
 118032150,
 117914723,
 -1,
 118097676,
 118015905,
 -1,
 -63733,
 118089238,
 43234,
 -1,
 118120928,
 43235,
 118294287,
 118077953,
 -1,
 -63730,
 118255984,
 43238,
 -1,
 118312085,
 43239,
 118490898,
 118247057,
 -1,
 -63727,
 118464253,
 43236,
 -1,
 118517950,
 43237,
 -63725,
 118484251,
 43232,
 -63724,
 118659157,
 43233,
 -63723,
 118722632,
 43241,
 -1,
 118769286,
 43240,
 118949662,
 117996886,
 -1,
 -63720,
 118939325,
 43248,
 -63719,
 119002010,
 43243,
 -63718,
 119057728,
 43247,
 -63717,
 119120651,
 43246,
 -63716,
 119180406,
 43245,
 -63715,
 119239563,
 43244,
 -1,
 119282054,
 43242,
 -1,
 118931391,
 43249,
 -1,
 117931331,
 7675,
 119605045,
 117871639,
 -1,
 119670573,
 119592158,
 -1,
 119736108,
 119603200,
 -1,
 119801637,
 119702514,
 862,
 -1,
 119734632,
 863,
 119932711,
 119745686,
 861,
 -1,
 119865704,
 860,
 -63704,
 119911824,
 858,
 -63703,
 120038466,
 6844,
 -63702,
 120101698,
 6840,
 -63701,
 120155413,
 7676,
 -1,
 120205980,
 7629,
 -1,
 119683355,
 6832,
 120457012,
 119654305,
 -1,
 120522545,
 120441252,
 -1,
 -63696,
 120477989,
 7616,
 -1,
 120527818,
 7617,
 120782847,
 120455180,
 -1,
 -63693,
 120697701,
 856,
 -1,
 120748779,
 7672,
 -1,
 120448500,
 6835,
 -1,
 119563312,
 6833,
 121046851,
 117814117,
 -1,
 121112386,
 120979456,
 -1,
 121177921,
 121054226,
 -1,
 121243456,
 121134250,
 -1,
 121308991,
 121182598,
 -1,
 121374526,
 121277780,
 -1,
 -63683,
 121362490,
 854,
 -1,
 121389040,
 7679,
 -1,
 121318478,
 848,
 -1,
 121252170,
 853,
 -1,
 121176424,
 8431,
 -1,
 121133822,
 855,
 -1,
 121102757,
 8428,
 121898828,
 121017367,
 -1,
 121964362,
 121862613,
 -1,
 -63674,
 121957609,
 66424,
 -63673,
 122011649,
 66426,
 -63672,
 122064592,
 66425,
 -63671,
 122109218,
 66423,
 -1,
 122167365,
 66422,
 -63669,
 121939256,
 6839,
 -1,
 122312889,
 7630,
 122488662,
 121865202,
 -1,
 122554194,
 122421248,
 -1,
 122619728,
 122532734,
 65061,
 -1,
 122552680,
 65068,
 122814463,
 122583809,
 65060,
 -1,
 122683752,
 65067,
 122945535,
 122490533,
 -1,
 -63660,
 122837279,
 7622,
 -63659,
 122891414,
 7628,
 -1,
 122952644,
 7620,
 123144030,
 122427782,
 -1,
 123209562,
 123127015,
 -1,
 -63655,
 123152714,
 857,
 -1,
 123214558,
 8432,
 123406173,
 123156719,
 -1,
 -63652,
 123372530,
 7623,
 -1,
 123427122,
 7625,
 -1,
 123371633,
 7677,
 123668322,
 123130778,
 -1,
 -63648,
 123648518,
 7634,
 -63647,
 123710667,
 7633,
 -1,
 123773659,
 7669,
 123930471,
 123652001,
 -1,
 123996006,
 123889666,
 -1,
 -63643,
 123974537,
 65066,
 -1,
 124025611,
 65065,
 -1,
 123975264,
 6836,
 124258155,
 123910657,
 -1,
 -63639,
 124246807,
 7619,
 -63638,
 124309766,
 6842,
 -1,
 124357825,
 7618,
 124520303,
 124232757,
 -1,
 -63635,
 124494287,
 6846,
 -63634,
 124528970,
 6845,
 -1,
 124590814,
 6843,
 124782450,
 124513681,
 -1,
 -63631,
 124725578,
 7631,
 -1,
 124787422,
 859,
 124979061,
 124774419,
 -1,
 -63628,
 124915747,
 6837,
 -1,
 124977512,
 851,
 125175672,
 124969956,
 -1,
 -63625,
 125130520,
 6838,
 -1,
 125188737,
 7673,
 125372283,
 125138064,
 -1,
 -63622,
 125350757,
 7670,
 -1,
 125401835,
 7671,
 125568894,
 125330349,
 -1,
 -63619,
 125549083,
 7632,
 -1,
 125603639,
 6834,
 125765505,
 125511519,
 -1,
 -63616,
 125743623,
 7627,
 -1,
 125790719,
 70459,
 -1,
 125718407,
 850,
 126091263,
 104309423,
 -1,
 -63612,
 126005720,
 128476,
 -1,
 126035241,
 129517,
 126224475,
 104243887,
 -1,
 126290010,
 126209202,
 -1,
 126355416,
 126269953,
 -1,
 126420942,
 126321876,
 -1,
 126486432,
 126391319,
 11423,
 126551967,
 126450105,
 -1,
 126617497,
 126498330,
 -1,
 126683025,
 126573067,
 -1,
 126748559,
 126622086,
 11471,
 -1,
 126732193,
 11477,
 -63600,
 126721175,
 11469,
 -1,
 126830197,
 11475,
 127010708,
 126664015,
 -1,
 -63597,
 126969931,
 11483,
 -1,
 127026805,
 11461,
 -63595,
 126982852,
 11455,
 -63594,
 127161787,
 11479,
 -63593,
 127224644,
 11463,
 -63592,
 127286527,
 11481,
 -1,
 127344068,
 11445,
 127598591,
 126587701,
 -1,
 127600541,
 127503404,
 -1,
 -63588,
 127593141,
 11489,
 -1,
 127621084,
 11487,
 -63586,
 127590855,
 11491,
 -1,
 127778463,
 11485,
 -1,
 126525052,
 11441,
 127993767,
 126433549,
 -1,
 128059302,
 127951971,
 -1,
 -63581,
 128028669,
 11451,
 -63580,
 128087042,
 11449,
 -63579,
 128147671,
 11467,
 -1,
 128196325,
 11443,
 -1,
 127999708,
 11399,
 128452526,
 127940211,
 -1,
 128518061,
 128445416,
 -1,
 -63574,
 128499270,
 11500,
 -63573,
 128552957,
 11453,
 -63572,
 128603579,
 11502,
 -1,
 128665218,
 11447,
 -1,
 128490889,
 11459,
 128911282,
 128432641,
 -1,
 -63568,
 128884348,
 11403,
 -63567,
 128936011,
 11429,
 -1,
 128983092,
 11457,
 129173430,
 128873273,
 -1,
 -63564,
 129154884,
 11421,
 -63563,
 129195601,
 11437,
 -1,
 129245764,
 11413,
 129435577,
 129157025,
 -1,
 -63560,
 129392142,
 11409,
 -1,
 129443446,
 11431,
 129632188,
 129409711,
 -1,
 -63557,
 129613636,
 11439,
 -1,
 129655725,
 11425,
 129828799,
 129595151,
 -1,
 -63554,
 129771164,
 11415,
 -1,
 129830871,
 11473,
 130025410,
 129767814,
 -1,
 -63551,
 129990119,
 11393,
 -1,
 130053486,
 11465,
 -63549,
 130018537,
 11405,
 -63548,
 130211533,
 11395,
 -63547,
 130274355,
 11433,
 -63546,
 130332540,
 11427,
 -63545,
 130387965,
 11419,
 -63544,
 130451453,
 11417,
 -63543,
 130507973,
 11411,
 -63542,
 130571373,
 11407,
 -63541,
 130635163,
 11397,
 -63540,
 130699267,
 11435,
 -63539,
 130762370,
 11401,
 -1,
 130821041,
 11507,
 131071999,
 126413648,
 -1,
 131074002,
 130988545,
 -1,
 -63535,
 131057998,
 11495,
 -1,
 131096378,
 11498,
 131270613,
 131035961,
 -1,
 -63532,
 131227220,
 11497,
 -1,
 131276176,
 11492,
 -63530,
 131254599,
 11496,
 -63529,
 131442246,
 11494,
 -1,
 131500036,
 11493,
 131663908,
 126299555,
 -1,
 131729439,
 131605093,
 -1,
 131794929,
 131699735,
 11422,
 131860464,
 131758521,
 -1,
 131925994,
 131806746,
 -1,
 131991522,
 131881483,
 -1,
 132057056,
 131930502,
 11470,
 -1,
 132040609,
 11476,
 -63519,
 132029591,
 11468,
 -1,
 132138613,
 11474,
 132319205,
 131972431,
 -1,
 -63516,
 132278347,
 11482,
 -1,
 132335221,
 11460,
 -63514,
 132291268,
 11454,
 -63513,
 132470203,
 11478,
 -63512,
 132533060,
 11462,
 -63511,
 132594943,
 11480,
 -1,
 132652484,
 11444,
 132907007,
 131896117,
 -1,
 132909038,
 132811820,
 -1,
 -63507,
 132901557,
 11488,
 -1,
 132929500,
 11486,
 -63505,
 132899271,
 11490,
 -1,
 133086879,
 11484,
 -1,
 131833468,
 11440,
 133302264,
 131741965,
 -1,
 133367799,
 133260387,
 -1,
 -63500,
 133337085,
 11450,
 -63499,
 133395458,
 11448,
 -63498,
 133456087,
 11466,
 -1,
 133504741,
 11442,
 -1,
 133308124,
 11398,
 133761023,
 133248627,
 -1,
 133826558,
 133753832,
 -1,
 -63493,
 133807686,
 11499,
 -63492,
 133861373,
 11452,
 -63491,
 133911995,
 11501,
 -1,
 133973634,
 11446,
 -1,
 133799305,
 11458,
 134219779,
 133741057,
 -1,
 -63487,
 134192764,
 11402,
 -63486,
 134244427,
 11428,
 -1,
 134291508,
 11456,
 134481927,
 134181689,
 -1,
 -63483,
 134463300,
 11420,
 -63482,
 134504017,
 11436,
 -1,
 134554180,
 11412,
 134744074,
 134465441,
 -1,
 -63479,
 134700558,
 11408,
 -1,
 134751862,
 11430,
 134940685,
 134718127,
 -1,
 -63476,
 134922052,
 11438,
 -1,
 134964141,
 11424,
 135137296,
 134903567,
 -1,
 -63473,
 135079580,
 11414,
 -1,
 135139287,
 11472,
 135333907,
 135076230,
 -1,
 -63470,
 135298535,
 11392,
 -1,
 135361902,
 11464,
 -63468,
 135326953,
 11404,
 -63467,
 135519949,
 11394,
 -63466,
 135582771,
 11432,
 -63465,
 135640956,
 11426,
 -63464,
 135696381,
 11418,
 -63463,
 135759869,
 11416,
 -63462,
 135816389,
 11410,
 -63461,
 135879789,
 11406,
 -63460,
 135943579,
 11396,
 -63459,
 136007683,
 11434,
 -63458,
 136070786,
 11400,
 -1,
 136129457,
 11506,
 136380415,
 131700583,
 -1,
 136382499,
 136299313,
 -1,
 -63454,
 136346905,
 11505,
 -1,
 136389912,
 11504,
 -1,
 136351744,
 11503,
 136644689,
 131615115,
 -1,
 136710211,
 136614733,
 -1,
 136775726,
 136693665,
 -1,
 136841258,
 136765627,
 -1,
 -63447,
 136811554,
 66292,
 -1,
 136857910,
 66283,
 137037869,
 136796683,
 -1,
 -63444,
 137015474,
 66293,
 -1,
 137064211,
 66284,
 -1,
 136988615,
 66282,
 137300021,
 136755713,
 -1,
 137365554,
 137261424,
 -1,
 -63439,
 137352062,
 66287,
 -1,
 137364312,
 66296,
 137625599,
 137317525,
 -1,
 -63436,
 137548670,
 66288,
 -1,
 137560920,
 66297,
 137758780,
 137252497,
 -1,
 137824313,
 137729047,
 -1,
 -63432,
 137812415,
 66294,
 -1,
 137869648,
 66285,
 138084351,
 137782189,
 -1,
 -63429,
 138009767,
 66295,
 -1,
 138040492,
 66286,
 138217535,
 137728072,
 -1,
 -63426,
 138204030,
 66290,
 -1,
 138216280,
 66299,
 138414146,
 138167942,
 -1,
 -63423,
 138406180,
 66289,
 -1,
 138412888,
 66298,
 -1,
 138385530,
 66291,
 138676304,
 136658019,
 -1,
 138741831,
 138659745,
 -1,
 -63418,
 138733078,
 66274,
 -1,
 138764768,
 66275,
 138938442,
 138721793,
 -1,
 -63415,
 138899824,
 66278,
 -1,
 138955925,
 66279,
 139135053,
 138890897,
 -1,
 -63412,
 139108093,
 66276,
 -1,
 139161790,
 66277,
 -63410,
 139106389,
 66273,
 -63409,
 139300936,
 66281,
 -1,
 139347590,
 66280,
 -1,
 138660797,
 66272,
 139593814,
 136615596,
 -1,
 -63405,
 139582844,
 11516,
 -63404,
 139618792,
 11515,
 -63403,
 139678903,
 11513,
 -1,
 139738285,
 11514,
 139921497,
 139546257,
 -1,
 -63400,
 139908757,
 11518,
 -1,
 139963757,
 11517,
 -1,
 139889317,
 11519,
 -1,
 126282521,
 127279,
 140249209,
 126210970,
 -1,
 140314743,
 140219143,
 -1,
 140380266,
 140302311,
 -1,
 140445793,
 140363681,
 -1,
 -63392,
 140437014,
 119649,
 -1,
 140468704,
 119650,
 140642404,
 140425729,
 -1,
 -63389,
 140603760,
 119653,
 -1,
 140659861,
 119654,
 140839015,
 140594833,
 -1,
 -63386,
 140812029,
 119651,
 -1,
 140865726,
 119652,
 -63384,
 140810325,
 119648,
 -63383,
 141004872,
 119656,
 -1,
 141051526,
 119655,
 141295615,
 140364323,
 -1,
 141297774,
 141215649,
 -1,
 -63379,
 141288982,
 119658,
 -1,
 141320672,
 119659,
 141494385,
 141277697,
 -1,
 -63376,
 141455728,
 119662,
 -1,
 141511829,
 119663,
 141690996,
 141446801,
 -1,
 -63373,
 141663997,
 119660,
 -1,
 141717694,
 119661,
 -63371,
 141662293,
 119657,
 -63370,
 141856840,
 119665,
 -1,
 141903494,
 119664,
 -63368,
 140289798,
 128145,
 -1,
 142028871,
 128715,
 142215301,
 140217388,
 -1,
 142280830,
 142167697,
 -1,
 -63364,
 142269134,
 128533,
 -63363,
 142319335,
 128534,
 -1,
 142363623,
 127882,
 142542977,
 142266616,
 -1,
 -63360,
 142523619,
 983186,
 -1,
 142571041,
 127899,
 142739588,
 142526021,
 -1,
 -63357,
 142731180,
 128119,
 -1,
 142786484,
 128679,
 -1,
 142728485,
 127978,
 143001738,
 142186035,
 -1,
 143067273,
 142959533,
 -1,
 -63352,
 143036241,
 127859,
 -1,
 143081982,
 127850,
 -1,
 143017123,
 127834,
 143329420,
 142991547,
 128004,
 -1,
 143262396,
 128046,
 143460495,
 143273379,
 -1,
 -63346,
 143432248,
 129381,
 -1,
 143488662,
 127864,
 -63344,
 143439720,
 11855,
 -63343,
 143622202,
 128165,
 -63342,
 143675369,
 9904,
 -1,
 143730009,
 129509,
 143919591,
 104159755,
 -1,
 143985004,
 143858054,
 -1,
 144050434,
 143950709,
 -1,
 144115929,
 144014678,
 -1,
 144181411,
 144068656,
 -1,
 144246938,
 144149548,
 43590,
 -1,
 144200904,
 43586,
 -63333,
 144238884,
 43592,
 -63332,
 144361377,
 43589,
 -63331,
 144425908,
 43595,
 -63330,
 144485574,
 43593,
 -63329,
 144548527,
 43591,
 -63328,
 144602895,
 43594,
 -63327,
 144667449,
 43584,
 -63326,
 144725192,
 43585,
 -1,
 144781380,
 43588,
 144967853,
 144149548,
 -1,
 145033384,
 144923147,
 -1,
 -63322,
 145020392,
 43536,
 -63321,
 145060395,
 43538,
 -1,
 145103238,
 43537,
 145295531,
 144987336,
 -1,
 -63318,
 145282536,
 43530,
 -1,
 145299846,
 43531,
 -63316,
 145282536,
 43543,
 -1,
 145430918,
 43544,
 145623217,
 144941743,
 -1,
 -63313,
 145597195,
 43547,
 -63312,
 145644061,
 43548,
 -1,
 145693062,
 43546,
 145885365,
 145570061,
 -1,
 -63309,
 145840669,
 43542,
 -63308,
 145897884,
 43545,
 -1,
 145955206,
 43541,
 146147513,
 145827679,
 -1,
 -63305,
 146102813,
 43550,
 -63304,
 146155408,
 43553,
 -1,
 146217350,
 43549,
 146409660,
 146130849,
 -1,
 -63301,
 146364957,
 43540,
 -1,
 146413958,
 43539,
 146606271,
 146389505,
 -1,
 -63298,
 146586326,
 43558,
 -1,
 146610566,
 43559,
 146802882,
 146572147,
 -1,
 -63295,
 146789864,
 43551,
 -1,
 146807174,
 43552,
 146999493,
 146764601,
 -1,
 -63292,
 146954781,
 43527,
 -1,
 147003782,
 43526,
 147196104,
 146960909,
 -1,
 -63289,
 147151389,
 43535,
 -1,
 147200390,
 43534,
 147392715,
 147150024,
 -1,
 -63286,
 147347997,
 43529,
 -1,
 147396998,
 43528,
 147589326,
 147337284,
 -1,
 -63283,
 147544605,
 43533,
 -1,
 147593606,
 43532,
 147785936,
 147528070,
 43520,
 -1,
 147743661,
 43524,
 -63279,
 147777951,
 43554,
 -63278,
 147905475,
 43557,
 -63277,
 147968922,
 43522,
 -63276,
 148024640,
 43555,
 -63275,
 148083735,
 43525,
 -63274,
 148141913,
 43556,
 -63273,
 148202413,
 43521,
 -63272,
 148265501,
 43560,
 -1,
 148324862,
 43523,
 148506853,
 144105526,
 -1,
 148572382,
 148445574,
 -1,
 -63268,
 148558746,
 43569,
 -63267,
 148595629,
 43568,
 -1,
 148642182,
 43561,
 148834528,
 148558746,
 43565,
 -1,
 148783614,
 43570,
 148965602,
 148804631,
 43567,
 -1,
 148914686,
 43566,
 149096676,
 148923309,
 43562,
 -1,
 149054381,
 43563,
 -1,
 149046901,
 43564,
 149293299,
 148454499,
 -1,
 149358825,
 149276577,
 -1,
 -63256,
 149349910,
 43602,
 -1,
 149381600,
 43603,
 149555436,
 149338625,
 -1,
 -63253,
 149516656,
 43606,
 -1,
 149572757,
 43607,
 149752047,
 149507729,
 -1,
 -63250,
 149724925,
 43604,
 -1,
 149778622,
 43605,
 -63248,
 149744923,
 43600,
 -63247,
 149919829,
 43601,
 -63246,
 149983304,
 43609,
 -1,
 150029958,
 43608,
 150210812,
 149239128,
 -1,
 150276344,
 150163504,
 -1,
 -63242,
 150245201,
 43587,
 -63241,
 150307699,
 43596,
 -1,
 150362635,
 43597,
 -63239,
 150268319,
 43571,
 -63238,
 150528251,
 43574,
 -63237,
 150580544,
 43572,
 -1,
 150632281,
 43573,
 150863871,
 150186581,
 -1,
 150866176,
 150747405,
 -1,
 -63233,
 150838918,
 43614,
 -1,
 150872350,
 43613,
 -63231,
 150851782,
 43615,
 -1,
 151044894,
 43612,
 151193952,
 144012822,
 -1,
 151259446,
 151158102,
 -1,
 151324938,
 151242657,
 -1,
 151390472,
 151308193,
 -1,
 -63225,
 151345714,
 69906,
 -1,
 151394891,
 69905,
 -63223,
 151345714,
 69911,
 -1,
 151525963,
 69910,
 151718159,
 151292972,
 -1,
 -63220,
 151710122,
 69904,
 -63219,
 151751842,
 69909,
 -63218,
 151803162,
 69899,
 -1,
 151853643,
 69914,
 152045845,
 151664909,
 -1,
 152111379,
 151992589,
 -1,
 -63214,
 152066610,
 69908,
 -1,
 152115787,
 69907,
 -63212,
 152066610,
 69913,
 -1,
 152246859,
 69912,
 152439064,
 152037668,
 -1,
 -63209,
 152431018,
 69920,
 -1,
 152443467,
 69921,
 152635675,
 152412847,
 -1,
 -63206,
 152590898,
 69916,
 -1,
 152640075,
 69915,
 152832286,
 152598287,
 -1,
 -63203,
 152787506,
 69956,
 -1,
 152836683,
 69923,
 153028897,
 152793913,
 -1,
 -63200,
 152984114,
 69896,
 -1,
 153033291,
 69895,
 153225508,
 152990221,
 -1,
 -63197,
 153180722,
 69903,
 -1,
 153229899,
 69902,
 153422119,
 153179336,
 -1,
 -63194,
 153377330,
 69898,
 -1,
 153426507,
 69897,
 153618730,
 153365923,
 -1,
 -63191,
 153573938,
 69901,
 -1,
 153623115,
 69900,
 153815341,
 153560927,
 -1,
 -63188,
 153770546,
 69918,
 -1,
 153819723,
 69917,
 -63186,
 153805054,
 69924,
 -63185,
 153998234,
 69893,
 -63184,
 154057446,
 69925,
 -63183,
 154119515,
 69922,
 -63182,
 154174412,
 69919,
 -63181,
 154231725,
 69892,
 -63180,
 154294834,
 69926,
 -63179,
 154354174,
 69894,
 -1,
 154409547,
 69891,
 154601797,
 151247792,
 -1,
 154667332,
 154575407,
 -1,
 154732860,
 154605958,
 69927,
 -63174,
 154719130,
 69935,
 -63173,
 154756013,
 69933,
 -1,
 154802566,
 69957,
 154995006,
 154719130,
 69930,
 -1,
 154981274,
 69931,
 155126080,
 154965015,
 69934,
 -1,
 155083693,
 69936,
 155257154,
 155083693,
 69928,
 -1,
 155214765,
 69929,
 155451391,
 155206142,
 69932,
 -1,
 155345837,
 69958,
 -1,
 154627657,
 69939,
 155584854,
 154548493,
 -1,
 155650388,
 155543394,
 -1,
 155715914,
 155633569,
 -1,
 -63159,
 155706902,
 69944,
 -1,
 155738592,
 69945,
 155912525,
 155695617,
 -1,
 -63156,
 155873648,
 69948,
 -1,
 155929749,
 69949,
 156109136,
 155864721,
 -1,
 -63153,
 156081917,
 69946,
 -1,
 156135614,
 69947,
 -63151,
 156101915,
 69942,
 -63150,
 156276821,
 69943,
 -63149,
 156340296,
 69951,
 -1,
 156386950,
 69950,
 -63147,
 155623046,
 69954,
 -1,
 156508446,
 69953,
 156698972,
 155564545,
 -1,
 156764507,
 156657529,
 -1,
 -63143,
 156753696,
 69890,
 -63142,
 156774007,
 69888,
 -1,
 156836389,
 69889,
 -1,
 156714047,
 69952,
 -63139,
 156675179,
 69955,
 -63138,
 157062192,
 69937,
 -63137,
 157123542,
 69940,
 -1,
 157165192,
 69938,
 157354345,
 151170246,
 -1,
 157419877,
 157337628,
 -1,
 157485412,
 157407649,
 128200,
 -1,
 157417672,
 128185,
 -1,
 157434123,
 128201,
 157745151,
 157359027,
 983058,
 157810687,
 157614080,
 -1,
 -63128,
 157738141,
 983139,
 -1,
 157793546,
 983136,
 158007295,
 157311917,
 -1,
 -63125,
 157920454,
 129681,
 -1,
 157979167,
 9939,
 158140892,
 143933950,
 -1,
 158206422,
 158117062,
 -1,
 158271955,
 158176861,
 -1,
 158337490,
 158253454,
 -1,
 158402946,
 158320545,
 -1,
 158468472,
 158382593,
 -1,
 -63117,
 158456752,
 43960,
 -63116,
 158520218,
 43959,
 -63115,
 158569495,
 43958,
 -63114,
 158622637,
 43957,
 -63113,
 158679550,
 43956,
 -1,
 158734726,
 43955,
 158927231,
 158430991,
 -1,
 -63110,
 158915504,
 43954,
 -63109,
 158978970,
 43953,
 -63108,
 159028247,
 43952,
 -63107,
 159081389,
 43951,
 -63106,
 159138302,
 43950,
 -1,
 159193478,
 43949,
 -63104,
 158884781,
 43944,
 -63103,
 159334910,
 43942,
 -1,
 159390086,
 43940,
 159582601,
 158382593,
 43933,
 -63100,
 159570864,
 43938,
 -63099,
 159634330,
 43937,
 -63098,
 159683607,
 43936,
 -63097,
 159736749,
 43935,
 -63096,
 159793662,
 43934,
 -1,
 159848838,
 43932,
 160041361,
 159550508,
 -1,
 160106892,
 159979910,
 43918,
 -1,
 160061963,
 43920,
 -63091,
 160095152,
 43925,
 -63090,
 160224154,
 43924,
 -63089,
 160273431,
 43923,
 -63088,
 160326573,
 43922,
 -1,
 160383486,
 43921,
 160565657,
 159996427,
 -1,
 -63085,
 160553904,
 43906,
 -63084,
 160617370,
 43905,
 -63083,
 160666647,
 43904,
 -63082,
 160730230,
 43919,
 -63081,
 160785325,
 43903,
 -63080,
 160842238,
 43902,
 -1,
 160897414,
 43901,
 161089953,
 160512269,
 -1,
 -63077,
 161078192,
 43947,
 -63076,
 161141658,
 43946,
 -63075,
 161190935,
 43945,
 -63074,
 161249113,
 43948,
 -63073,
 161309613,
 43943,
 -63072,
 161366526,
 43941,
 -1,
 161421702,
 43939,
 161614248,
 161081636,
 -1,
 -63069,
 161602480,
 5116,
 -63068,
 161665946,
 5115,
 -63067,
 161715223,
 5114,
 -63066,
 161768365,
 5113,
 -63065,
 161825278,
 5112,
 -1,
 161880454,
 43967,
 162073007,
 161603771,
 -1,
 -63062,
 162061232,
 43966,
 -63061,
 162124698,
 43965,
 -63060,
 162173975,
 43964,
 -63059,
 162227117,
 43963,
 -63058,
 162284030,
 43962,
 -1,
 162339206,
 43961,
 162531766,
 162048887,
 -1,
 -63055,
 162519984,
 43931,
 -63054,
 162583450,
 43930,
 -63053,
 162632727,
 43929,
 -63052,
 162685869,
 43928,
 -63051,
 162742782,
 43927,
 -1,
 162797958,
 43926,
 162990525,
 162497395,
 -1,
 -63048,
 162978736,
 5117,
 -63047,
 163042202,
 43917,
 -63046,
 163091479,
 43916,
 -63045,
 163144621,
 43915,
 -63044,
 163201534,
 43914,
 -1,
 163256710,
 43913,
 163449284,
 162952975,
 -1,
 -63041,
 163437488,
 43912,
 -63040,
 163500954,
 43911,
 -63039,
 163550231,
 43910,
 -63038,
 163603373,
 43909,
 -63037,
 163660286,
 43908,
 -1,
 163715462,
 43907,
 163908043,
 163402952,
 -1,
 -63034,
 163896240,
 43900,
 -63033,
 163959706,
 43899,
 -63032,
 164008983,
 43898,
 -63031,
 164062125,
 43897,
 -63030,
 164119038,
 43896,
 -1,
 164174214,
 43894,
 -63028,
 163896240,
 43893,
 -63027,
 164352922,
 43892,
 -63026,
 164402199,
 43891,
 -63025,
 164459403,
 43895,
 -63024,
 164520877,
 43890,
 -63023,
 164577790,
 43889,
 -1,
 164632966,
 43888,
 -1,
 158301546,
 5109,
 164954111,
 158248134,
 -1,
 -63019,
 164882740,
 127800,
 -1,
 164914632,
 127826,
 165087705,
 158155262,
 -1,
 -63016,
 165067808,
 129472,
 -1,
 165131709,
 128227,
 -63014,
 165070128,
 127792,
 -63013,
 165260374,
 127937,
 -1,
 165294921,
 128638,
 165480930,
 158098349,
 -1,
 165546463,
 165444022,
 129490,
 -1,
 165523792,
 128696,
 -63008,
 165525466,
 9911,
 -63007,
 165652400,
 128063,
 -1,
 165688132,
 128020,
 165874149,
 165450775,
 -1,
 -63004,
 165849611,
 129378,
 -1,
 165884992,
 127851,
 -63002,
 165861869,
 9962,
 -1,
 166049532,
 127876,
 166202106,
 143858054,
 -1,
 166267489,
 166169644,
 983098,
 166333017,
 166206509,
 -1,
 166398458,
 166302743,
 -1,
 166463993,
 166359718,
 -1,
 166529522,
 166431788,
 6361,
 166658047,
 166518971,
 -1,
 166660592,
 166564887,
 6347,
 -1,
 166630423,
 6349,
 166854655,
 166618029,
 6343,
 -1,
 166749101,
 6345,
 166922740,
 166509057,
 6362,
 -1,
 166877707,
 6363,
 -62987,
 166905761,
 6357,
 -62986,
 167027375,
 6356,
 -62985,
 167084915,
 6360,
 -62984,
 167146297,
 6358,
 -1,
 167194019,
 6359,
 -1,
 166455588,
 6320,
 167447051,
 166387899,
 -1,
 167512581,
 167418442,
 -1,
 167578116,
 167496857,
 -1,
 167643647,
 167547927,
 5754,
 -1,
 167613463,
 5755,
 167774721,
 167601069,
 5752,
 -1,
 167732141,
 5753,
 167905795,
 167713158,
 5756,
 -1,
 167844230,
 5757,
 -1,
 167855373,
 5751,
 -1,
 167530643,
 5758,
 168167946,
 167463767,
 -1,
 168233481,
 168103644,
 -1,
 -62968,
 168204861,
 6369,
 -1,
 168237643,
 6370,
 -1,
 168184518,
 6365,
 -1,
 168109856,
 6323,
 168561176,
 167426561,
 -1,
 168626707,
 168503072,
 6335,
 168755199,
 168587099,
 -1,
 168757777,
 168672591,
 -1,
 -62960,
 168747554,
 6378,
 -1,
 168794685,
 6379,
 -62958,
 168719153,
 6385,
 -1,
 168910967,
 6380,
 169085463,
 168581643,
 -1,
 -62955,
 169076659,
 6338,
 -62954,
 169124467,
 6336,
 -1,
 169158432,
 6337,
 -1,
 169058931,
 6334,
 169413156,
 168544161,
 -1,
 169478685,
 169396926,
 -1,
 -62949,
 169468450,
 6373,
 -62948,
 169515581,
 6374,
 -1,
 169548363,
 6375,
 169740832,
 169442810,
 -1,
 -62945,
 169730594,
 6376,
 -1,
 169777725,
 6377,
 169937443,
 169698177,
 -1,
 -62942,
 169886206,
 6371,
 -1,
 169941382,
 6372,
 -1,
 169879328,
 6327,
 170199598,
 169389254,
 -1,
 170265132,
 170188987,
 -1,
 170330664,
 170234903,
 6353,
 -1,
 170300439,
 6354,
 170461738,
 170288045,
 6351,
 -1,
 170419117,
 6352,
 -62933,
 170411277,
 6350,
 -1,
 170531206,
 6355,
 -62931,
 170207008,
 6341,
 -1,
 170659556,
 6368,
 170854966,
 170167340,
 -1,
 170920500,
 170844347,
 -1,
 170986034,
 170890263,
 6346,
 -1,
 170955799,
 6348,
 171180031,
 170943405,
 6342,
 -1,
 171074477,
 6344,
 -62923,
 170893939,
 6331,
 -1,
 171190048,
 6332,
 171379264,
 170798860,
 -1,
 171444796,
 171332808,
 -1,
 171510331,
 171434171,
 -1,
 -62918,
 171496346,
 6381,
 -1,
 171514246,
 6384,
 -1,
 171448907,
 6383,
 171772479,
 171391731,
 -1,
 -62914,
 171755720,
 6389,
 -1,
 171786833,
 6382,
 -1,
 171733813,
 6386,
 172034628,
 171352751,
 -1,
 -62910,
 172025779,
 6326,
 -62909,
 172073587,
 6324,
 -1,
 172107552,
 6325,
 172296777,
 171976543,
 -1,
 172362312,
 172246019,
 -1,
 -62905,
 172338374,
 6388,
 -1,
 172390159,
 6387,
 -1,
 172324782,
 5759,
 172624460,
 172288292,
 -1,
 -62901,
 172597875,
 6339,
 -1,
 172631840,
 6340,
 172821071,
 172585785,
 -1,
 -62898,
 172810749,
 6329,
 -1,
 172828448,
 6328,
 173017682,
 172773424,
 -1,
 -62895,
 172999133,
 6366,
 -1,
 173059538,
 6367,
 173214293,
 172956038,
 -1,
 -62892,
 173205796,
 6321,
 -1,
 173221664,
 6322,
 -62890,
 173180437,
 6330,
 -62889,
 173373838,
 6333,
 -62888,
 173433766,
 5120,
 -1,
 173491155,
 6364,
 173673052,
 166277083,
 983097,
 -62885,
 173635943,
 128473,
 -1,
 173670859,
 983170,
 173869663,
 173619469,
 -1,
 -62882,
 173861156,
 127852,
 -1,
 173898256,
 128367,
 -62880,
 173839699,
 128758,
 -1,
 174034513,
 129387,
 174197407,
 166243526,
 -1,
 174262933,
 174154881,
 -1,
 174328425,
 174248858,
 66226,
 174456831,
 174314394,
 66239,
 174522367,
 174379930,
 66212,
 -62873,
 174445466,
 66235,
 -62872,
 174461836,
 66256,
 -1,
 174527079,
 66248,
 174721647,
 174307841,
 66224,
 174787180,
 174704545,
 66242,
 -1,
 174723687,
 66243,
 174918254,
 174742027,
 66222,
 -1,
 174854759,
 66223,
 -1,
 174897665,
 66232,
 175114868,
 174687091,
 66218,
 175243263,
 175056735,
 66250,
 -62862,
 175117482,
 66253,
 -62861,
 175182732,
 66252,
 -1,
 175247975,
 66251,
 175442552,
 175082540,
 66229,
 -62858,
 175410220,
 66227,
 -62857,
 175461576,
 66244,
 -1,
 175520013,
 66238,
 175704699,
 175425441,
 66221,
 175833087,
 175687585,
 66247,
 -1,
 175706727,
 66230,
 175901310,
 175666959,
 66211,
 176029695,
 175847693,
 66214,
 -1,
 175903335,
 66254,
 176097920,
 175877318,
 66213,
 -1,
 176073926,
 66249,
 176228994,
 176071343,
 66231,
 -1,
 176165479,
 66209,
 176360068,
 176190265,
 66236,
 -1,
 176296551,
 66237,
 176491142,
 176317357,
 66233,
 -1,
 176448429,
 66245,
 176622216,
 176444616,
 66240,
 -1,
 176558695,
 66241,
 176753290,
 176570878,
 66234,
 -1,
 176689767,
 66255,
 176884364,
 176699661,
 66210,
 -1,
 176820839,
 66220,
 177015439,
 176827860,
 -1,
 -62834,
 176952487,
 66246,
 -1,
 177017431,
 66225,
 177212049,
 176953734,
 66208,
 -1,
 177148519,
 66215,
 -62830,
 177203219,
 66228,
 -62829,
 177318657,
 66216,
 -62828,
 177378327,
 66219,
 -1,
 177416031,
 66217,
 177605273,
 174209295,
 -1,
 177670808,
 177563990,
 128199,
 -1,
 177603185,
 128450,
 -1,
 177623065,
 128451,
 177867420,
 177581254,
 -1,
 -62821,
 177839514,
 129365,
 -1,
 177890366,
 983073,
 -62819,
 177840848,
 127887,
 -62818,
 178036647,
 127904,
 -1,
 178063671,
 9936,
 178260715,
 174183831,
 -1,
 178326250,
 178224470,
 -1,
 178391725,
 178269603,
 -1,
 178457255,
 178346507,
 -1,
 178522789,
 178395526,
 66873,
 -1,
 178505633,
 66902,
 -62810,
 178496115,
 66889,
 -1,
 178611117,
 66890,
 178784938,
 178448799,
 -1,
 -62807,
 178776356,
 66891,
 -1,
 178839739,
 66911,
 179044351,
 178723206,
 -1,
 -62804,
 178973574,
 66912,
 -1,
 179023046,
 66882,
 179178163,
 178371073,
 -1,
 179243698,
 179132939,
 -1,
 179309233,
 179181958,
 66877,
 -1,
 179270457,
 66896,
 -1,
 179282547,
 66909,
 -1,
 179195522,
 66906,
 179571385,
 179124493,
 -1,
 179636919,
 179563568,
 -1,
 -62794,
 179628581,
 66895,
 -1,
 179644192,
 66901,
 -62792,
 179628530,
 66881,
 -1,
 179774809,
 66867,
 179964606,
 179563568,
 -1,
 180030141,
 179919371,
 -1,
 -62788,
 179988449,
 66871,
 -1,
 180033926,
 66875,
 -1,
 179970944,
 66869,
 180292290,
 179947425,
 -1,
 -62784,
 180283941,
 66899,
 -62783,
 180318572,
 66908,
 -1,
 180364471,
 66872,
 180554438,
 180249517,
 -1,
 -62780,
 180544952,
 66910,
 -62779,
 180596512,
 66876,
 -1,
 180655079,
 66879,
 180816585,
 180545828,
 -1,
 -62776,
 180789797,
 66874,
 -1,
 180823868,
 66913,
 181013196,
 180792096,
 -1,
 -62773,
 181004580,
 66887,
 -1,
 181054662,
 66893,
 181209807,
 180986543,
 -1,
 -62770,
 181170540,
 66914,
 -1,
 181225415,
 66903,
 181406418,
 181171983,
 -1,
 -62767,
 181398287,
 66885,
 -1,
 181411909,
 66878,
 181603029,
 181367609,
 -1,
 -62764,
 181563753,
 66915,
 -1,
 181609132,
 66884,
 181799640,
 181563917,
 -1,
 -62761,
 181756380,
 66883,
 -1,
 181806935,
 66897,
 181996251,
 181753032,
 -1,
 -62758,
 181954628,
 66866,
 -1,
 182017600,
 66904,
 182192862,
 181944830,
 -1,
 -62755,
 182184838,
 66870,
 -1,
 182200159,
 66868,
 182389473,
 182131078,
 -1,
 -62752,
 182361125,
 66888,
 -1,
 182420143,
 66864,
 -62750,
 182380686,
 66880,
 -62749,
 182574776,
 66907,
 -62748,
 182628018,
 66905,
 -62747,
 182687674,
 66898,
 -62746,
 182751740,
 66894,
 -62745,
 182814050,
 66892,
 -62744,
 182869573,
 66886,
 -62743,
 182931237,
 66900,
 -1,
 182987155,
 66865,
 -1,
 178270938,
 66927,
 183241456,
 178243489,
 128008,
 183369727,
 183173820,
 128049,
 183435263,
 183241570,
 -1,
 -62737,
 183363570,
 128572,
 -1,
 183421335,
 128569,
 183569140,
 183206771,
 -1,
 183634675,
 183519824,
 128247,
 -1,
 183569584,
 128248,
 -1,
 183608979,
 127957,
 183831287,
 183531279,
 -1,
 -62730,
 183793425,
 129305,
 -1,
 183847037,
 128197,
 -62728,
 183813412,
 9963,
 -62727,
 184002226,
 11839,
 -1,
 184039472,
 127797,
 184224763,
 166193444,
 -1,
 184290230,
 184202592,
 -1,
 184355678,
 184271246,
 -1,
 184421129,
 184338337,
 -1,
 184486658,
 184360785,
 -1,
 -62720,
 184478232,
 7303,
 -62719,
 184535410,
 7300,
 -1,
 184572995,
 7302,
 184748805,
 184465921,
 -1,
 -62716,
 184738338,
 42639,
 -1,
 184794137,
 42641,
 -62714,
 184738338,
 42637,
 -62713,
 184902358,
 7301,
 -62712,
 184959716,
 42635,
 -1,
 185020611,
 42643,
 185207574,
 184367373,
 -1,
 185273104,
 185199664,
 -1,
 185338638,
 185265200,
 -1,
 -62707,
 185293978,
 1323,
 -1,
 185352702,
 42633,
 -62705,
 185328162,
 42627,
 -1,
 185485168,
 42563,
 185666323,
 185245311,
 -1,
 -62702,
 185635863,
 42649,
 -1,
 185698928,
 42605,
 -62700,
 185655842,
 42625,
 -62699,
 185823891,
 42569,
 -1,
 185872579,
 1325,
 186059550,
 185183430,
 -1,
 186125084,
 186010899,
 -1,
 -62695,
 186117369,
 1297,
 -62694,
 186182688,
 42581,
 -62693,
 186241324,
 42593,
 -1,
 186270197,
 42565,
 -62691,
 186097395,
 7296,
 -1,
 186407453,
 1303,
 186583847,
 186038785,
 -1,
 186649380,
 186553745,
 -1,
 186714915,
 186597886,
 -1,
 -62686,
 186680179,
 42599,
 -1,
 186742543,
 42597,
 -1,
 186661495,
 42595,
 187039743,
 186604043,
 -1,
 -62682,
 186966562,
 42647,
 -1,
 186997280,
 1319,
 187173679,
 186532350,
 -1,
 187239212,
 187135801,
 -1,
 -62678,
 187205714,
 1313,
 -62677,
 187261051,
 1299,
 -1,
 187317072,
 1327,
 187564031,
 187206728,
 -1,
 -62674,
 187467858,
 1315,
 -1,
 187530061,
 1321,
 187697973,
 187133411,
 -1,
 187763508,
 187655670,
 -1,
 -62670,
 187755032,
 42579,
 -62669,
 187773879,
 42589,
 -1,
 187832710,
 42583,
 -1,
 187701638,
 42567,
 188091193,
 187689252,
 -1,
 -62665,
 188058668,
 42591,
 -62664,
 188107534,
 42577,
 -1,
 188161096,
 1305,
 188353342,
 188045835,
 -1,
 188418877,
 188291593,
 -1,
 -62660,
 188401111,
 1279,
 -1,
 188440699,
 1277,
 -1,
 188408354,
 42645,
 188681026,
 188296611,
 -1,
 -62656,
 188659761,
 42651,
 -62655,
 188711238,
 42585,
 -1,
 188756163,
 42631,
 188943174,
 188622687,
 -1,
 -62652,
 188921735,
 42573,
 -62651,
 188972282,
 42587,
 -1,
 189033515,
 42603,
 189205321,
 188935216,
 -1,
 -62648,
 189162391,
 42629,
 -1,
 189220787,
 42561,
 189401932,
 189194427,
 -1,
 -62645,
 189359459,
 7299,
 -1,
 189415934,
 1309,
 189598543,
 189375151,
 -1,
 -62642,
 189547206,
 1317,
 -1,
 189603703,
 1231,
 189795154,
 189565996,
 -1,
 -62639,
 189746299,
 42575,
 -1,
 189801503,
 7298,
 189991765,
 189762155,
 -1,
 -62636,
 189946098,
 42571,
 -1,
 190003269,
 42601,
 190188376,
 189953807,
 -1,
 -62633,
 190159239,
 7297,
 -1,
 190208541,
 1301,
 190384987,
 190142302,
 -1,
 -62630,
 190367206,
 1275,
 -1,
 190397264,
 1271,
 -62628,
 190371633,
 7304,
 -62627,
 190556960,
 1307,
 -1,
 190586632,
 1311,
 190778289,
 184299221,
 -1,
 190843756,
 190724365,
 -1,
 190909286,
 190835760,
 -1,
 190974820,
 190901296,
 -1,
 -62621,
 190930074,
 1322,
 -1,
 190988798,
 42632,
 -62619,
 190964258,
 42626,
 -1,
 191121264,
 42562,
 191302505,
 190881407,
 -1,
 -62616,
 191271959,
 42648,
 -1,
 191335024,
 42604,
 -62614,
 191291938,
 42624,
 -62613,
 191459987,
 42568,
 -1,
 191508675,
 1324,
 191695731,
 190826401,
 -1,
 191761264,
 191674881,
 -1,
 -62609,
 191750690,
 42638,
 -1,
 191806489,
 42640,
 -62607,
 191750690,
 42636,
 -62606,
 191906532,
 42634,
 -1,
 191967427,
 42642,
 192154492,
 191674881,
 -1,
 192220025,
 192124305,
 -1,
 192285560,
 192168446,
 -1,
 -62601,
 192250739,
 42598,
 -1,
 192313103,
 42596,
 -1,
 192232055,
 42594,
 192610303,
 192174603,
 -1,
 -62597,
 192537122,
 42646,
 -1,
 192567840,
 1318,
 192744323,
 192130246,
 -1,
 192809858,
 192695571,
 -1,
 -62593,
 192802041,
 1296,
 -62592,
 192867360,
 42580,
 -62591,
 192925996,
 42592,
 -1,
 192954869,
 42564,
 -1,
 192764445,
 1302,
 193203083,
 192692734,
 -1,
 193268616,
 193165113,
 -1,
 -62586,
 193235026,
 1312,
 -62585,
 193290363,
 1298,
 -1,
 193346384,
 1326,
 193593343,
 193236040,
 -1,
 -62582,
 193497170,
 1314,
 -1,
 193559373,
 1320,
 193727377,
 193162723,
 -1,
 193792912,
 193684982,
 -1,
 -62578,
 193784344,
 42578,
 -62577,
 193803191,
 42588,
 -1,
 193862022,
 42582,
 -1,
 193730950,
 42566,
 194120597,
 193718564,
 -1,
 -62573,
 194087980,
 42590,
 -62572,
 194136846,
 42576,
 -1,
 194190408,
 1304,
 194382746,
 194075147,
 -1,
 194448281,
 194320905,
 -1,
 -62568,
 194430423,
 1278,
 -1,
 194470011,
 1276,
 -1,
 194437666,
 42644,
 194710430,
 194325923,
 -1,
 -62564,
 194689073,
 42650,
 -62563,
 194740550,
 42584,
 -1,
 194785475,
 42630,
 194972578,
 194651999,
 -1,
 -62560,
 194951047,
 42572,
 -62559,
 195001594,
 42586,
 -1,
 195062827,
 42602,
 195234725,
 194964528,
 -1,
 -62556,
 195191703,
 42628,
 -1,
 195250099,
 42560,
 195431336,
 195201643,
 -1,
 -62553,
 195385586,
 42570,
 -1,
 195442757,
 42600,
 195627947,
 195385182,
 -1,
 -62550,
 195610086,
 1274,
 -1,
 195640144,
 1270,
 -62548,
 195617314,
 1308,
 -62547,
 195799840,
 1306,
 -62546,
 195863775,
 1316,
 -62545,
 195923751,
 42574,
 -62544,
 195984893,
 1300,
 -1,
 196026120,
 1310,
 196217780,
 190741846,
 -1,
 -62541,
 196198741,
 7467,
 -1,
 196250491,
 42606,
 -62539,
 196191418,
 42623,
 -1,
 196375689,
 42622,
 196545530,
 184265141,
 -1,
 196611005,
 196528033,
 -1,
 -62535,
 196596634,
 67633,
 -62534,
 196645911,
 67632,
 -62533,
 196699053,
 67631,
 -62532,
 196755966,
 67630,
 -1,
 196811142,
 67629,
 197004227,
 196590081,
 -1,
 -62529,
 196989850,
 67628,
 -62528,
 197039127,
 67627,
 -62527,
 197092269,
 67626,
 -62526,
 197149182,
 67625,
 -1,
 197204358,
 67624,
 197397449,
 196979910,
 -1,
 -62523,
 197383066,
 67623,
 -62522,
 197432343,
 67622,
 -62521,
 197485485,
 67621,
 -62520,
 197542398,
 67620,
 -1,
 197597574,
 67619,
 197790671,
 197370543,
 -1,
 -62517,
 197776282,
 67618,
 -62516,
 197825559,
 67617,
 -62515,
 197878701,
 67616,
 -62514,
 197935614,
 67615,
 -1,
 197990790,
 67614,
 198183893,
 197757996,
 -1,
 -62511,
 198169498,
 67613,
 -62510,
 198218775,
 67612,
 -62509,
 198271917,
 67611,
 -62508,
 198328830,
 67610,
 -1,
 198384006,
 67609,
 198577115,
 198148979,
 -1,
 -62505,
 198562714,
 67608,
 -62504,
 198611991,
 67607,
 -62503,
 198665133,
 67606,
 -62502,
 198722046,
 67605,
 -1,
 198777222,
 67604,
 198970337,
 198539023,
 -1,
 -62499,
 198955930,
 67603,
 -62498,
 199005207,
 67602,
 -62497,
 199058349,
 67601,
 -62496,
 199115262,
 67600,
 -1,
 199170438,
 67599,
 199363559,
 198931257,
 -1,
 -62493,
 199349146,
 67598,
 -62492,
 199398423,
 67597,
 -62491,
 199451565,
 67596,
 -62490,
 199508478,
 67595,
 -1,
 199563654,
 67594,
 199756780,
 199352507,
 -1,
 -62487,
 199726103,
 67637,
 -62486,
 199779245,
 67636,
 -62485,
 199836158,
 67635,
 -1,
 199891334,
 67634,
 200084463,
 199748656,
 -1,
 -62482,
 200053783,
 67647,
 -1,
 200087942,
 67644,
 200281074,
 200075283,
 -1,
 -62479,
 200229374,
 67640,
 -1,
 200284550,
 67639,
 200477685,
 200241677,
 -1,
 -62476,
 200446999,
 67592,
 -1,
 200481158,
 67589,
 -62474,
 200463258,
 67588,
 -62473,
 200643607,
 67587,
 -62472,
 200696749,
 67586,
 -62471,
 200753662,
 67585,
 -1,
 200808838,
 67584,
 -1,
 196490121,
 127744,
 201067674,
 184185539,
 -1,
 201133173,
 201012414,
 -1,
 201198606,
 201076131,
 -1,
 -62465,
 201150097,
 64207,
 -62464,
 201212414,
 64206,
 -62463,
 201275661,
 64205,
 -62462,
 201338275,
 64204,
 -62461,
 201402207,
 64203,
 -62460,
 201464198,
 64202,
 -62459,
 201529556,
 64201,
 -62458,
 201594915,
 64200,
 -62457,
 201660227,
 64199,
 -62456,
 201725555,
 64198,
 -62455,
 201790846,
 64197,
 -62454,
 201856170,
 64196,
 -62453,
 201921420,
 64195,
 -62452,
 201986663,
 64194,
 -62451,
 202051900,
 64193,
 -1,
 202117164,
 64192,
 202312735,
 201140063,
 -1,
 -62448,
 202264209,
 64191,
 -62447,
 202326526,
 64190,
 -62446,
 202389773,
 64189,
 -62445,
 202452387,
 64188,
 -62444,
 202516319,
 64187,
 -62443,
 202578310,
 64186,
 -62442,
 202643668,
 64185,
 -62441,
 202709027,
 64184,
 -62440,
 202774339,
 64183,
 -62439,
 202839667,
 64182,
 -62438,
 202904958,
 64181,
 -62437,
 202970282,
 64180,
 -62436,
 203035532,
 64179,
 -62435,
 203100775,
 64178,
 -62434,
 203166012,
 64177,
 -1,
 203231276,
 64176,
 203426864,
 202250630,
 -1,
 -62431,
 203378321,
 64175,
 -62430,
 203440638,
 64174,
 -62429,
 203503885,
 64173,
 -62428,
 203566499,
 64172,
 -62427,
 203630431,
 64171,
 -62426,
 203692422,
 64170,
 -62425,
 203757780,
 64169,
 -62424,
 203823139,
 64168,
 -62423,
 203888451,
 64167,
 -62422,
 203953779,
 64166,
 -62421,
 204019070,
 64165,
 -62420,
 204084394,
 64164,
 -62419,
 204149644,
 64163,
 -62418,
 204214887,
 64162,
 -62417,
 204280124,
 64161,
 -1,
 204345388,
 64160,
 204540993,
 203364564,
 -1,
 -62414,
 204492433,
 64159,
 -62413,
 204554750,
 64158,
 -62412,
 204617997,
 64157,
 -62411,
 204680611,
 64156,
 -62410,
 204744543,
 64155,
 -62409,
 204806534,
 64154,
 -62408,
 204871892,
 64153,
 -62407,
 204937251,
 64152,
 -62406,
 205002563,
 64151,
 -62405,
 205067891,
 64150,
 -62404,
 205133182,
 64149,
 -62403,
 205198506,
 64148,
 -62402,
 205263756,
 64147,
 -62401,
 205328999,
 64146,
 -62400,
 205394236,
 64145,
 -1,
 205459500,
 64144,
 205655122,
 204478499,
 -1,
 -62397,
 205606545,
 64143,
 -62396,
 205668862,
 64142,
 -62395,
 205732109,
 64141,
 -62394,
 205794723,
 64140,
 -62393,
 205858655,
 64139,
 -62392,
 205920646,
 64138,
 -62391,
 205986004,
 64137,
 -62390,
 206051363,
 64136,
 -62389,
 206116675,
 64135,
 -62388,
 206182003,
 64134,
 -62387,
 206247294,
 64133,
 -62386,
 206312618,
 64132,
 -62385,
 206377868,
 64131,
 -62384,
 206443111,
 64130,
 -62383,
 206508348,
 64129,
 -1,
 206573612,
 64128,
 206769251,
 205592387,
 -1,
 -62380,
 206720657,
 64127,
 -62379,
 206782974,
 64126,
 -62378,
 206846221,
 64125,
 -62377,
 206908835,
 64124,
 -62376,
 206972767,
 64123,
 -62375,
 207034758,
 64122,
 -62374,
 207100116,
 64121,
 -62373,
 207165475,
 64120,
 -62372,
 207230787,
 64119,
 -62371,
 207296115,
 64118,
 -62370,
 207361406,
 64117,
 -62369,
 207426730,
 64116,
 -62368,
 207491980,
 64115,
 -62367,
 207557223,
 64114,
 -62366,
 207622460,
 64113,
 -1,
 207687724,
 64112,
 207883374,
 206715149,
 -1,
 -62363,
 207821012,
 64217,
 -62362,
 207886371,
 64216,
 -62361,
 207951683,
 64215,
 -62360,
 208017011,
 64214,
 -62359,
 208082302,
 64213,
 -62358,
 208147626,
 64212,
 -62357,
 208212876,
 64211,
 -62356,
 208278119,
 64210,
 -62355,
 208343356,
 64209,
 -1,
 208408620,
 64208,
 208604274,
 207820403,
 -1,
 -62352,
 208550157,
 64109,
 -62351,
 208612771,
 64108,
 -1,
 208676703,
 64107,
 208928767,
 208540263,
 -1,
 -62348,
 208817809,
 64047,
 -1,
 208880126,
 64046,
 209125375,
 201115102,
 -1,
 209128580,
 209017355,
 12752,
 209194112,
 209120304,
 12757,
 209259644,
 209185840,
 12741,
 209325179,
 209251376,
 12750,
 -1,
 209278152,
 12769,
 -1,
 209298095,
 12747,
 209521790,
 209248443,
 12749,
 -1,
 209474760,
 12744,
 -62337,
 209504161,
 12746,
 -1,
 209605832,
 12742,
 209783938,
 209167023,
 12743,
 -1,
 209773292,
 12748,
 -62333,
 209774870,
 12768,
 -1,
 209867976,
 12758,
 210046094,
 209107457,
 12753,
 210111624,
 210037808,
 12759,
 -62329,
 210103344,
 12766,
 -1,
 210166508,
 12745,
 210308235,
 210100411,
 12740,
 -62326,
 210299952,
 12760,
 -1,
 210326728,
 12767,
 -62324,
 210290593,
 12761,
 -62323,
 210477743,
 12755,
 -1,
 210523336,
 12762,
 210701458,
 210018991,
 12754,
 -62320,
 210693168,
 12764,
 -62319,
 210719944,
 12770,
 -1,
 210778381,
 12763,
 210963604,
 210683809,
 12736,
 -1,
 210930732,
 12765,
 -62315,
 210954387,
 12738,
 -62314,
 211084012,
 12737,
 -62313,
 211135233,
 12771,
 -62312,
 211192876,
 12751,
 -62311,
 211237133,
 12756,
 -1,
 211299727,
 12739,
 211487974,
 201029391,
 -1,
 211553499,
 211457047,
 -1,
 211619022,
 211497727,
 -1,
 211684551,
 211550914,
 -1,
 211750060,
 211666849,
 -1,
 211815590,
 211738811,
 -1,
 211881123,
 211784727,
 -1,
 -62302,
 211816475,
 128349,
 -1,
 211879165,
 128337,
 212140031,
 211830653,
 -1,
 -62299,
 212013083,
 128359,
 -1,
 212075773,
 128347,
 212274345,
 211771872,
 -1,
 -62296,
 212209691,
 128350,
 -1,
 212272381,
 128338,
 212533247,
 212223943,
 -1,
 -62293,
 212406299,
 128357,
 -1,
 212468989,
 128345,
 212667571,
 211728897,
 -1,
 212733104,
 212627824,
 -1,
 -62289,
 212668443,
 128353,
 -1,
 212731133,
 128341,
 212991999,
 212683925,
 -1,
 -62286,
 212865051,
 128354,
 -1,
 212927741,
 128342,
 213126330,
 212618897,
 -1,
 213191863,
 213098237,
 -1,
 -62282,
 213127195,
 128351,
 -1,
 213189885,
 128339,
 213450751,
 213151934,
 -1,
 -62279,
 213323803,
 128352,
 -1,
 213386493,
 128340,
 213585089,
 213074430,
 -1,
 213650622,
 213548461,
 -1,
 -62275,
 213585947,
 128358,
 -1,
 213648637,
 128346,
 213909503,
 213608141,
 -1,
 -62272,
 213782555,
 128355,
 -1,
 213845245,
 128343,
 214043844,
 213555285,
 -1,
 -62269,
 213979163,
 128348,
 -1,
 214041853,
 128336,
 214302719,
 214011976,
 -1,
 -62266,
 214175771,
 128356,
 -1,
 214238461,
 128344,
 214499327,
 211674177,
 -1,
 214502604,
 214414181,
 -1,
 214568139,
 214491490,
 128257,
 -1,
 214502310,
 128258,
 -1,
 214499443,
 128472,
 -62259,
 214487128,
 11118,
 -1,
 214712508,
 128259,
 214895829,
 211598425,
 -1,
 214961362,
 214860874,
 -1,
 -62255,
 214937053,
 128235,
 -1,
 214991450,
 128234,
 -62253,
 214947574,
 127746,
 -62252,
 215122087,
 128272,
 -1,
 215165937,
 128213,
 215354586,
 214881720,
 -1,
 -62249,
 215338753,
 127786,
 -62248,
 215401064,
 127784,
 -62247,
 215461317,
 127783,
 -1,
 215514861,
 127785,
 -1,
 215344584,
 129313,
 215747809,
 211491206,
 -1,
 215813343,
 215722233,
 -1,
 -62242,
 215771780,
 128079,
 -1,
 215829005,
 127916,
 -62240,
 215794724,
 127963,
 -1,
 215976744,
 128385,
 216203263,
 215704493,
 -1,
 216206565,
 216109304,
 -1,
 -62236,
 216160364,
 129346,
 -1,
 216213790,
 127867,
 -1,
 216179906,
 128203,
 216468762,
 211444653,
 -1,
 216534295,
 216444707,
 -1,
 216599830,
 216496809,
 -1,
 216665335,
 216556461,
 -1,
 216730867,
 216611607,
 -1,
 216796398,
 216691513,
 -1,
 -62227,
 216768052,
 12871,
 -1,
 216820042,
 12869,
 216993009,
 216734086,
 -1,
 -62224,
 216941007,
 127568,
 -1,
 217001861,
 127569,
 -62222,
 216972253,
 12870,
 -1,
 217164898,
 12868,
 217320694,
 216713430,
 -1,
 -62219,
 217296070,
 127276,
 -1,
 217329059,
 127275,
 -1,
 217288511,
 128712,
 217582851,
 216634189,
 -1,
 217648380,
 217565089,
 -1,
 -62214,
 217637471,
 12873,
 -62213,
 217669540,
 12874,
 -1,
 217729015,
 12872,
 217910527,
 217627137,
 -1,
 -62210,
 217870781,
 12877,
 -1,
 217926886,
 12878,
 218107138,
 217861777,
 -1,
 -62207,
 218078550,
 12875,
 -1,
 218129942,
 12876,
 -1,
 218056416,
 12879,
 218369293,
 217525667,
 -1,
 218434828,
 218347549,
 -1,
 218500363,
 218365952,
 -1,
 218565898,
 218452613,
 129282,
 218693631,
 218499938,
 -1,
 -62199,
 218616516,
 129281,
 -1,
 218649358,
 129280,
 -1,
 218540171,
 128320,
 -1,
 218458824,
 9938,
 -1,
 218380557,
 127277,
 219024656,
 218330705,
 -1,
 -62193,
 218985259,
 12925,
 -1,
 219033733,
 12924,
 -62191,
 219015187,
 11198,
 -62190,
 219211792,
 127278,
 -62189,
 219271155,
 128981,
 -62188,
 219333469,
 128983,
 -62187,
 219372532,
 12926,
 -1,
 219425770,
 11199,
 -1,
 216586937,
 127914,
 219680025,
 216519565,
 127961,
 -1,
 219611437,
 127750,
 -1,
 219647691,
 127910,
 219876660,
 216444102,
 983074,
 219942185,
 219845655,
 -1,
 220007718,
 219923380,
 -1,
 220073249,
 219956302,
 -1,
 -62177,
 220055344,
 9876,
 -62176,
 220106390,
 127370,
 -1,
 220156280,
 127884,
 220335397,
 220004352,
 -1,
 220400932,
 220309643,
 128322,
 -1,
 220335292,
 128321,
 -1,
 220366195,
 10060,
 -1,
 220293832,
 9932,
 -62169,
 219997624,
 128081,
 -62168,
 220622768,
 129360,
 -1,
 220673072,
 128010,
 220859694,
 219932964,
 -1,
 220925229,
 220817975,
 -1,
 -62164,
 220876521,
 128546,
 -1,
 220933930,
 128575,
 -1,
 220906623,
 128302,
 221187376,
 220816651,
 129431,
 -1,
 221118789,
 127951,
 221318451,
 221135358,
 -1,
 -62158,
 221297618,
 127769,
 -1,
 221330647,
 128179,
 -1,
 221256321,
 129408,
 221580600,
 219824638,
 -1,
 -62154,
 221557141,
 9907,
 -62153,
 221610729,
 128328,
 -1,
 221658070,
 8373,
 -62151,
 221560644,
 983187,
 -62150,
 221796449,
 983200,
 -1,
 221851716,
 983171,
 222041564,
 51105,
 -1,
 222106572,
 221976966,
 -1,
 222171275,
 222071852,
 -1,
 222236810,
 222123208,
 -1,
 222302345,
 222223152,
 -1,
 222367880,
 222246116,
 -1,
 222432688,
 222303859,
 -1,
 222498125,
 222370004,
 -1,
 -62140,
 222435540,
 101050,
 -62139,
 222500899,
 101049,
 -62138,
 222566211,
 101048,
 -62137,
 222631539,
 101047,
 -62136,
 222696830,
 101046,
 -62135,
 222762154,
 101045,
 -62134,
 222827404,
 101044,
 -62133,
 222892647,
 101043,
 -62132,
 222957884,
 101042,
 -1,
 223023148,
 101041,
 223219032,
 222435363,
 -1,
 -62129,
 223156436,
 101040,
 -62128,
 223221795,
 101039,
 -62127,
 223287107,
 101038,
 -62126,
 223352435,
 101037,
 -62125,
 223417726,
 101036,
 -62124,
 223483050,
 101035,
 -62123,
 223548300,
 101034,
 -62122,
 223613543,
 101033,
 -62121,
 223678780,
 101032,
 -1,
 223744044,
 101031,
 223939939,
 223156035,
 -1,
 -62118,
 223877332,
 101030,
 -62117,
 223942691,
 101029,
 -62116,
 224008003,
 101028,
 -62115,
 224073331,
 101027,
 -62114,
 224138622,
 101026,
 -62113,
 224203946,
 101025,
 -62112,
 224269196,
 101024,
 -62111,
 224334439,
 101023,
 -62110,
 224399676,
 101022,
 -1,
 224464940,
 101021,
 224660846,
 223876723,
 -1,
 -62107,
 224598228,
 101020,
 -62106,
 224663587,
 101019,
 -62105,
 224728899,
 101018,
 -62104,
 224794227,
 101017,
 -62103,
 224859518,
 101016,
 -62102,
 224924842,
 101015,
 -62101,
 224990092,
 101014,
 -62100,
 225055335,
 101013,
 -62099,
 225120572,
 101012,
 -1,
 225185836,
 101011,
 225381753,
 224597374,
 -1,
 -62096,
 225319124,
 101010,
 -62095,
 225384483,
 101009,
 -62094,
 225449795,
 101008,
 -62093,
 225515123,
 101007,
 -62092,
 225580414,
 101006,
 -62091,
 225645738,
 101005,
 -62090,
 225710988,
 101004,
 -62089,
 225776231,
 101003,
 -62088,
 225841468,
 101002,
 -1,
 225906732,
 101001,
 226102660,
 225318058,
 -1,
 -62085,
 226040020,
 101000,
 -62084,
 226105379,
 100999,
 -62083,
 226170691,
 100998,
 -62082,
 226236019,
 100997,
 -62081,
 226301310,
 100996,
 -62080,
 226366634,
 100995,
 -62079,
 226431884,
 100994,
 -62078,
 226497127,
 100993,
 -62077,
 226562364,
 100992,
 -1,
 226627628,
 100991,
 226823567,
 226038668,
 -1,
 -62074,
 226760916,
 100990,
 -62073,
 226826275,
 100989,
 -62072,
 226891587,
 100988,
 -62071,
 226956915,
 100987,
 -62070,
 227022206,
 100986,
 -62069,
 227087530,
 100985,
 -62068,
 227152780,
 100984,
 -62067,
 227218023,
 100983,
 -62066,
 227283260,
 100982,
 -1,
 227348524,
 100981,
 227544474,
 226759271,
 -1,
 -62063,
 227481812,
 100980,
 -62062,
 227547171,
 100979,
 -62061,
 227612483,
 100978,
 -62060,
 227677811,
 100977,
 -62059,
 227743102,
 100976,
 -62058,
 227808426,
 100975,
 -62057,
 227873676,
 100974,
 -62056,
 227938919,
 100973,
 -62055,
 228004156,
 100972,
 -1,
 228069420,
 100971,
 228265381,
 227479868,
 -1,
 -62052,
 228202708,
 100970,
 -62051,
 228268067,
 100969,
 -62050,
 228333379,
 100968,
 -62049,
 228398707,
 100967,
 -62048,
 228463998,
 100966,
 -62047,
 228529322,
 100965,
 -62046,
 228594572,
 100964,
 -62045,
 228659815,
 100963,
 -62044,
 228725052,
 100962,
 -1,
 228790316,
 100961,
 229048319,
 228200492,
 -1,
 -62041,
 228923604,
 100960,
 -62040,
 228988963,
 100959,
 -62039,
 229054275,
 100958,
 -62038,
 229119603,
 100957,
 -62037,
 229184894,
 100956,
 -62036,
 229250218,
 100955,
 -62035,
 229315468,
 100954,
 -62034,
 229380711,
 100953,
 -62033,
 229445948,
 100952,
 -1,
 229511212,
 100951,
 229707295,
 222369150,
 -1,
 229772732,
 229644500,
 -1,
 -62029,
 229710036,
 100950,
 -62028,
 229775395,
 100949,
 -62027,
 229840707,
 100948,
 -62026,
 229906035,
 100947,
 -62025,
 229971326,
 100946,
 -62024,
 230036650,
 100945,
 -62023,
 230101900,
 100944,
 -62022,
 230167143,
 100943,
 -62021,
 230232380,
 100942,
 -1,
 230297644,
 100941,
 230493639,
 229709859,
 -1,
 -62018,
 230430932,
 100940,
 -62017,
 230496291,
 100939,
 -62016,
 230561603,
 100938,
 -62015,
 230626931,
 100937,
 -62014,
 230692222,
 100936,
 -62013,
 230757546,
 100935,
 -62012,
 230822796,
 100934,
 -62011,
 230888039,
 100933,
 -62010,
 230953276,
 100932,
 -1,
 231018540,
 100931,
 231214546,
 230430531,
 -1,
 -62007,
 231151828,
 100930,
 -62006,
 231217187,
 100929,
 -62005,
 231282499,
 100928,
 -62004,
 231347827,
 100927,
 -62003,
 231413118,
 100926,
 -62002,
 231478442,
 100925,
 -62001,
 231543692,
 100924,
 -62000,
 231608935,
 100923,
 -61999,
 231674172,
 100922,
 -1,
 231739436,
 100921,
 231935453,
 231151219,
 -1,
 -61996,
 231872724,
 100920,
 -61995,
 231938083,
 100919,
 -61994,
 232003395,
 100918,
 -61993,
 232068723,
 100917,
 -61992,
 232134014,
 100916,
 -61991,
 232199338,
 100915,
 -61990,
 232264588,
 100914,
 -61989,
 232329831,
 100913,
 -61988,
 232395068,
 100912,
 -1,
 232460332,
 100911,
 232656360,
 231871870,
 -1,
 -61985,
 232593620,
 100910,
 -61984,
 232658979,
 100909,
 -61983,
 232724291,
 100908,
 -61982,
 232789619,
 100907,
 -61981,
 232854910,
 100906,
 -61980,
 232920234,
 100905,
 -61979,
 232985484,
 100904,
 -61978,
 233050727,
 100903,
 -61977,
 233115964,
 100902,
 -1,
 233181228,
 100901,
 233377267,
 232592554,
 -1,
 -61974,
 233314516,
 100900,
 -61973,
 233379875,
 100899,
 -61972,
 233445187,
 100898,
 -61971,
 233510515,
 100897,
 -61970,
 233575806,
 100896,
 -61969,
 233641130,
 100895,
 -61968,
 233706380,
 100894,
 -61967,
 233771623,
 100893,
 -61966,
 233836860,
 100892,
 -1,
 233902124,
 100891,
 234098174,
 233313164,
 -1,
 -61963,
 234035412,
 100890,
 -61962,
 234100771,
 100889,
 -61961,
 234166083,
 100888,
 -61960,
 234231411,
 100887,
 -61959,
 234296702,
 100886,
 -61958,
 234362026,
 100885,
 -61957,
 234427276,
 100884,
 -61956,
 234492519,
 100883,
 -61955,
 234557756,
 100882,
 -1,
 234623020,
 100881,
 234819081,
 234033767,
 -1,
 -61952,
 234756308,
 100880,
 -61951,
 234821667,
 100879,
 -61950,
 234886979,
 100878,
 -61949,
 234952307,
 100877,
 -61948,
 235017598,
 100876,
 -61947,
 235082922,
 100875,
 -61946,
 235148172,
 100874,
 -61945,
 235213415,
 100873,
 -61944,
 235278652,
 100872,
 -1,
 235343916,
 100871,
 235539988,
 234754364,
 -1,
 -61941,
 235477204,
 100870,
 -61940,
 235542563,
 100869,
 -61939,
 235607875,
 100868,
 -61938,
 235673203,
 100867,
 -61937,
 235738494,
 100866,
 -61936,
 235803818,
 100865,
 -61935,
 235869068,
 100864,
 -61934,
 235934311,
 100863,
 -61933,
 235999548,
 100862,
 -1,
 236064812,
 100861,
 236322815,
 235474988,
 -1,
 -61930,
 236198100,
 100860,
 -61929,
 236263459,
 100859,
 -61928,
 236328771,
 100858,
 -61927,
 236394099,
 100857,
 -61926,
 236459390,
 100856,
 -61925,
 236524714,
 100855,
 -61924,
 236589964,
 100854,
 -61923,
 236655207,
 100853,
 -61922,
 236720444,
 100852,
 -1,
 236785708,
 100851,
 236981902,
 229643434,
 -1,
 237047339,
 236918996,
 -1,
 -61918,
 236984532,
 100850,
 -61917,
 237049891,
 100849,
 -61916,
 237115203,
 100848,
 -61915,
 237180531,
 100847,
 -61914,
 237245822,
 100846,
 -61913,
 237311146,
 100845,
 -61912,
 237376396,
 100844,
 -61911,
 237441639,
 100843,
 -61910,
 237506876,
 100842,
 -1,
 237572140,
 100841,
 237768246,
 236984355,
 -1,
 -61907,
 237705428,
 100840,
 -61906,
 237770787,
 100839,
 -61905,
 237836099,
 100838,
 -61904,
 237901427,
 100837,
 -61903,
 237966718,
 100836,
 -61902,
 238032042,
 100835,
 -61901,
 238097292,
 100834,
 -61900,
 238162535,
 100833,
 -61899,
 238227772,
 100832,
 -1,
 238293036,
 100831,
 238489153,
 237705027,
 -1,
 -61896,
 238426324,
 100830,
 -61895,
 238491683,
 100829,
 -61894,
 238556995,
 100828,
 -61893,
 238622323,
 100827,
 -61892,
 238687614,
 100826,
 -61891,
 238752938,
 100825,
 -61890,
 238818188,
 100824,
 -61889,
 238883431,
 100823,
 -61888,
 238948668,
 100822,
 -1,
 239013932,
 100821,
 239210060,
 238425715,
 -1,
 -61885,
 239147220,
 100820,
 -61884,
 239212579,
 100819,
 -61883,
 239277891,
 100818,
 -61882,
 239343219,
 100817,
 -61881,
 239408510,
 100816,
 -61880,
 239473834,
 100815,
 -61879,
 239539084,
 100814,
 -61878,
 239604327,
 100813,
 -61877,
 239669564,
 100812,
 -1,
 239734828,
 100811,
 239930967,
 239146366,
 -1,
 -61874,
 239868116,
 100810,
 -61873,
 239933475,
 100809,
 -61872,
 239998787,
 100808,
 -61871,
 240064115,
 100807,
 -61870,
 240129406,
 100806,
 -61869,
 240194730,
 100805,
 -61868,
 240259980,
 100804,
 -61867,
 240325223,
 100803,
 -61866,
 240390460,
 100802,
 -1,
 240455724,
 100801,
 240651874,
 239867050,
 -1,
 -61863,
 240589012,
 100800,
 -61862,
 240654371,
 100799,
 -61861,
 240719683,
 100798,
 -61860,
 240785011,
 100797,
 -61859,
 240850302,
 100796,
 -61858,
 240915626,
 100795,
 -61857,
 240980876,
 100794,
 -61856,
 241046119,
 100793,
 -61855,
 241111356,
 100792,
 -1,
 241176620,
 100791,
 241372781,
 240587660,
 -1,
 -61852,
 241309908,
 100790,
 -61851,
 241375267,
 100789,
 -61850,
 241440579,
 100788,
 -61849,
 241505907,
 100787,
 -61848,
 241571198,
 100786,
 -61847,
 241636522,
 100785,
 -61846,
 241701772,
 100784,
 -61845,
 241767015,
 100783,
 -61844,
 241832252,
 100782,
 -1,
 241897516,
 100781,
 242093688,
 241308263,
 -1,
 -61841,
 242030804,
 100780,
 -61840,
 242096163,
 100779,
 -61839,
 242161475,
 100778,
 -61838,
 242226803,
 100777,
 -61837,
 242292094,
 100776,
 -61836,
 242357418,
 100775,
 -61835,
 242422668,
 100774,
 -61834,
 242487911,
 100773,
 -61833,
 242553148,
 100772,
 -1,
 242618412,
 100771,
 242814595,
 242028860,
 -1,
 -61830,
 242751700,
 100770,
 -61829,
 242817059,
 100769,
 -61828,
 242882371,
 100768,
 -61827,
 242947699,
 100767,
 -61826,
 243012990,
 100766,
 -61825,
 243078314,
 100765,
 -61824,
 243143564,
 100764,
 -61823,
 243208807,
 100763,
 -61822,
 243274044,
 100762,
 -1,
 243339308,
 100761,
 243597311,
 242749484,
 -1,
 -61819,
 243472596,
 100760,
 -61818,
 243537955,
 100759,
 -61817,
 243603267,
 100758,
 -61816,
 243668595,
 100757,
 -61815,
 243733886,
 100756,
 -61814,
 243799210,
 100755,
 -61813,
 243864460,
 100754,
 -61812,
 243929703,
 100753,
 -61811,
 243994940,
 100752,
 -1,
 244060204,
 100751,
 244256509,
 236917644,
 -1,
 244321946,
 244193492,
 -1,
 -61807,
 244259028,
 100750,
 -61806,
 244324387,
 100749,
 -61805,
 244389699,
 100748,
 -61804,
 244455027,
 100747,
 -61803,
 244520318,
 100746,
 -61802,
 244585642,
 100745,
 -61801,
 244650892,
 100744,
 -61800,
 244716135,
 100743,
 -61799,
 244781372,
 100742,
 -1,
 244846636,
 100741,
 245042853,
 244258851,
 -1,
 -61796,
 244979924,
 100740,
 -61795,
 245045283,
 100739,
 -61794,
 245110595,
 100738,
 -61793,
 245175923,
 100737,
 -61792,
 245241214,
 100736,
 -61791,
 245306538,
 100735,
 -61790,
 245371788,
 100734,
 -61789,
 245437031,
 100733,
 -61788,
 245502268,
 100732,
 -1,
 245567532,
 100731,
 245763760,
 244979523,
 -1,
 -61785,
 245700820,
 100730,
 -61784,
 245766179,
 100729,
 -61783,
 245831491,
 100728,
 -61782,
 245896819,
 100727,
 -61781,
 245962110,
 100726,
 -61780,
 246027434,
 100725,
 -61779,
 246092684,
 100724,
 -61778,
 246157927,
 100723,
 -61777,
 246223164,
 100722,
 -1,
 246288428,
 100721,
 246484667,
 245700211,
 -1,
 -61774,
 246421716,
 100720,
 -61773,
 246487075,
 100719,
 -61772,
 246552387,
 100718,
 -61771,
 246617715,
 100717,
 -61770,
 246683006,
 100716,
 -61769,
 246748330,
 100715,
 -61768,
 246813580,
 100714,
 -61767,
 246878823,
 100713,
 -61766,
 246944060,
 100712,
 -1,
 247009324,
 100711,
 247205574,
 246420862,
 -1,
 -61763,
 247142612,
 100710,
 -61762,
 247207971,
 100709,
 -61761,
 247273283,
 100708,
 -61760,
 247338611,
 100707,
 -61759,
 247403902,
 100706,
 -61758,
 247469226,
 100705,
 -61757,
 247534476,
 100704,
 -61756,
 247599719,
 100703,
 -61755,
 247664956,
 100702,
 -1,
 247730220,
 100701,
 247926481,
 247141546,
 -1,
 -61752,
 247863508,
 100700,
 -61751,
 247928867,
 100699,
 -61750,
 247994179,
 100698,
 -61749,
 248059507,
 100697,
 -61748,
 248124798,
 100696,
 -61747,
 248190122,
 100695,
 -61746,
 248255372,
 100694,
 -61745,
 248320615,
 100693,
 -61744,
 248385852,
 100692,
 -1,
 248451116,
 100691,
 248647388,
 247862156,
 -1,
 -61741,
 248584404,
 100690,
 -61740,
 248649763,
 100689,
 -61739,
 248715075,
 100688,
 -61738,
 248780403,
 100687,
 -61737,
 248845694,
 100686,
 -61736,
 248911018,
 100685,
 -61735,
 248976268,
 100684,
 -61734,
 249041511,
 100683,
 -61733,
 249106748,
 100682,
 -1,
 249172012,
 100681,
 249368295,
 248582759,
 -1,
 -61730,
 249305300,
 100680,
 -61729,
 249370659,
 100679,
 -61728,
 249435971,
 100678,
 -61727,
 249501299,
 100677,
 -61726,
 249566590,
 100676,
 -61725,
 249631914,
 100675,
 -61724,
 249697164,
 100674,
 -61723,
 249762407,
 100673,
 -61722,
 249827644,
 100672,
 -1,
 249892908,
 100671,
 250089202,
 249303356,
 -1,
 -61719,
 250026196,
 100670,
 -61718,
 250091555,
 100669,
 -61717,
 250156867,
 100668,
 -61716,
 250222195,
 100667,
 -61715,
 250287486,
 100666,
 -61714,
 250352810,
 100665,
 -61713,
 250418060,
 100664,
 -61712,
 250483303,
 100663,
 -61711,
 250548540,
 100662,
 -1,
 250613804,
 100661,
 250871807,
 250023980,
 -1,
 -61708,
 250747092,
 100660,
 -61707,
 250812451,
 100659,
 -61706,
 250877763,
 100658,
 -61705,
 250943091,
 100657,
 -61704,
 251008382,
 100656,
 -61703,
 251073706,
 100655,
 -61702,
 251138956,
 100654,
 -61701,
 251204199,
 100653,
 -61700,
 251269436,
 100652,
 -1,
 251334700,
 100651,
 251531116,
 244191847,
 -1,
 251596553,
 251467988,
 -1,
 -61696,
 251533524,
 100650,
 -61695,
 251598883,
 100649,
 -61694,
 251664195,
 100648,
 -61693,
 251729523,
 100647,
 -61692,
 251794814,
 100646,
 -61691,
 251860138,
 100645,
 -61690,
 251925388,
 100644,
 -61689,
 251990631,
 100643,
 -61688,
 252055868,
 100642,
 -1,
 252121132,
 100641,
 252317460,
 251533347,
 -1,
 -61685,
 252254420,
 100640,
 -61684,
 252319779,
 100639,
 -61683,
 252385091,
 100638,
 -61682,
 252450419,
 100637,
 -61681,
 252515710,
 100636,
 -61680,
 252581034,
 100635,
 -61679,
 252646284,
 100634,
 -61678,
 252711527,
 100633,
 -61677,
 252776764,
 100632,
 -1,
 252842028,
 100631,
 253038367,
 252254019,
 -1,
 -61674,
 252975316,
 100630,
 -61673,
 253040675,
 100629,
 -61672,
 253105987,
 100628,
 -61671,
 253171315,
 100627,
 -61670,
 253236606,
 100626,
 -61669,
 253301930,
 100625,
 -61668,
 253367180,
 100624,
 -61667,
 253432423,
 100623,
 -61666,
 253497660,
 100622,
 -1,
 253562924,
 100621,
 253759274,
 252974707,
 -1,
 -61663,
 253696212,
 100620,
 -61662,
 253761571,
 100619,
 -61661,
 253826883,
 100618,
 -61660,
 253892211,
 100617,
 -61659,
 253957502,
 100616,
 -61658,
 254022826,
 100615,
 -61657,
 254088076,
 100614,
 -61656,
 254153319,
 100613,
 -61655,
 254218556,
 100612,
 -1,
 254283820,
 100611,
 254480181,
 253695358,
 -1,
 -61652,
 254417108,
 100610,
 -61651,
 254482467,
 100609,
 -61650,
 254547779,
 100608,
 -61649,
 254613107,
 100607,
 -61648,
 254678398,
 100606,
 -61647,
 254743722,
 100605,
 -61646,
 254808972,
 100604,
 -61645,
 254874215,
 100603,
 -61644,
 254939452,
 100602,
 -1,
 255004716,
 100601,
 255201088,
 254416042,
 -1,
 -61641,
 255138004,
 100600,
 -61640,
 255203363,
 100599,
 -61639,
 255268675,
 100598,
 -61638,
 255334003,
 100597,
 -61637,
 255399294,
 100596,
 -61636,
 255464618,
 100595,
 -61635,
 255529868,
 100594,
 -61634,
 255595111,
 100593,
 -61633,
 255660348,
 100592,
 -1,
 255725612,
 100591,
 255921995,
 255136652,
 -1,
 -61630,
 255858900,
 100590,
 -61629,
 255924259,
 100589,
 -61628,
 255989571,
 100588,
 -61627,
 256054899,
 100587,
 -61626,
 256120190,
 100586,
 -61625,
 256185514,
 100585,
 -61624,
 256250764,
 100584,
 -61623,
 256316007,
 100583,
 -61622,
 256381244,
 100582,
 -1,
 256446508,
 100581,
 256642902,
 255857255,
 -1,
 -61619,
 256579796,
 100580,
 -61618,
 256645155,
 100579,
 -61617,
 256710467,
 100578,
 -61616,
 256775795,
 100577,
 -61615,
 256841086,
 100576,
 -61614,
 256906410,
 100575,
 -61613,
 256971660,
 100574,
 -61612,
 257036903,
 100573,
 -61611,
 257102140,
 100572,
 -1,
 257167404,
 100571,
 257363809,
 256577852,
 -1,
 -61608,
 257300692,
 100570,
 -61607,
 257366051,
 100569,
 -61606,
 257431363,
 100568,
 -61605,
 257496691,
 100567,
 -61604,
 257561982,
 100566,
 -61603,
 257627306,
 100565,
 -61602,
 257692556,
 100564,
 -61601,
 257757799,
 100563,
 -61600,
 257823036,
 100562,
 -1,
 257888300,
 100561,
 258146303,
 257298476,
 -1,
 -61597,
 258021588,
 100560,
 -61596,
 258086947,
 100559,
 -61595,
 258152259,
 100558,
 -61594,
 258217587,
 100557,
 -61593,
 258282878,
 100556,
 -61592,
 258348202,
 100555,
 -61591,
 258413452,
 100554,
 -61590,
 258478695,
 100553,
 -61589,
 258543932,
 100552,
 -1,
 258609196,
 100551,
 258805723,
 251466044,
 -1,
 258871160,
 258742484,
 -1,
 -61585,
 258808020,
 100550,
 -61584,
 258873379,
 100549,
 -61583,
 258938691,
 100548,
 -61582,
 259004019,
 100547,
 -61581,
 259069310,
 100546,
 -61580,
 259134634,
 100545,
 -61579,
 259199884,
 100544,
 -61578,
 259265127,
 100543,
 -61577,
 259330364,
 100542,
 -1,
 259395628,
 100541,
 259592067,
 258807843,
 -1,
 -61574,
 259528916,
 100540,
 -61573,
 259594275,
 100539,
 -61572,
 259659587,
 100538,
 -61571,
 259724915,
 100537,
 -61570,
 259790206,
 100536,
 -61569,
 259855530,
 100535,
 -61568,
 259920780,
 100534,
 -61567,
 259986023,
 100533,
 -61566,
 260051260,
 100532,
 -1,
 260116524,
 100531,
 260312974,
 259528515,
 -1,
 -61563,
 260249812,
 100530,
 -61562,
 260315171,
 100529,
 -61561,
 260380483,
 100528,
 -61560,
 260445811,
 100527,
 -61559,
 260511102,
 100526,
 -61558,
 260576426,
 100525,
 -61557,
 260641676,
 100524,
 -61556,
 260706919,
 100523,
 -61555,
 260772156,
 100522,
 -1,
 260837420,
 100521,
 261033881,
 260249203,
 -1,
 -61552,
 260970708,
 100520,
 -61551,
 261036067,
 100519,
 -61550,
 261101379,
 100518,
 -61549,
 261166707,
 100517,
 -61548,
 261231998,
 100516,
 -61547,
 261297322,
 100515,
 -61546,
 261362572,
 100514,
 -61545,
 261427815,
 100513,
 -61544,
 261493052,
 100512,
 -1,
 261558316,
 100511,
 261754788,
 260969854,
 -1,
 -61541,
 261691604,
 100510,
 -61540,
 261756963,
 100509,
 -61539,
 261822275,
 100508,
 -61538,
 261887603,
 100507,
 -61537,
 261952894,
 100506,
 -61536,
 262018218,
 100505,
 -61535,
 262083468,
 100504,
 -61534,
 262148711,
 100503,
 -61533,
 262213948,
 100502,
 -1,
 262279212,
 100501,
 262475695,
 261690538,
 -1,
 -61530,
 262412500,
 100500,
 -61529,
 262477859,
 100499,
 -61528,
 262543171,
 100498,
 -61527,
 262608499,
 100497,
 -61526,
 262673790,
 100496,
 -61525,
 262739114,
 100495,
 -61524,
 262804364,
 100494,
 -61523,
 262869607,
 100493,
 -61522,
 262934844,
 100492,
 -1,
 263000108,
 100491,
 263196602,
 262411148,
 -1,
 -61519,
 263133396,
 100490,
 -61518,
 263198755,
 100489,
 -61517,
 263264067,
 100488,
 -61516,
 263329395,
 100487,
 -61515,
 263394686,
 100486,
 -61514,
 263460010,
 100485,
 -61513,
 263525260,
 100484,
 -61512,
 263590503,
 100483,
 -61511,
 263655740,
 100482,
 -1,
 263721004,
 100481,
 263917509,
 263131751,
 -1,
 -61508,
 263854292,
 100480,
 -61507,
 263919651,
 100479,
 -61506,
 263984963,
 100478,
 -61505,
 264050291,
 100477,
 -61504,
 264115582,
 100476,
 -61503,
 264180906,
 100475,
 -61502,
 264246156,
 100474,
 -61501,
 264311399,
 100473,
 -61500,
 264376636,
 100472,
 -1,
 264441900,
 100471,
 264638416,
 263852348,
 -1,
 -61497,
 264575188,
 100470,
 -61496,
 264640547,
 100469,
 -61495,
 264705859,
 100468,
 -61494,
 264771187,
 100467,
 -61493,
 264836478,
 100466,
 -61492,
 264901802,
 100465,
 -61491,
 264967052,
 100464,
 -61490,
 265032295,
 100463,
 -61489,
 265097532,
 100462,
 -1,
 265162796,
 100461,
 265420799,
 264572972,
 -1,
 -61486,
 265296084,
 100460,
 -61485,
 265361443,
 100459,
 -61484,
 265426755,
 100458,
 -61483,
 265492083,
 100457,
 -61482,
 265557374,
 100456,
 -61481,
 265622698,
 100455,
 -61480,
 265687948,
 100454,
 -61479,
 265753191,
 100453,
 -61478,
 265818428,
 100452,
 -1,
 265883692,
 100451,
 266080329,
 258740268,
 -1,
 266145767,
 266016980,
 -1,
 -61474,
 266082516,
 100450,
 -61473,
 266147875,
 100449,
 -61472,
 266213187,
 100448,
 -61471,
 266278515,
 100447,
 -61470,
 266343806,
 100446,
 -61469,
 266409130,
 100445,
 -61468,
 266474380,
 100444,
 -61467,
 266539623,
 100443,
 -61466,
 266604860,
 100442,
 -1,
 266670124,
 100441,
 266866674,
 266082339,
 -1,
 -61463,
 266803412,
 100440,
 -61462,
 266868771,
 100439,
 -61461,
 266934083,
 100438,
 -61460,
 266999411,
 100437,
 -61459,
 267064702,
 100436,
 -61458,
 267130026,
 100435,
 -61457,
 267195276,
 100434,
 -61456,
 267260519,
 100433,
 -61455,
 267325756,
 100432,
 -1,
 267391020,
 100431,
 267587581,
 266803011,
 -1,
 -61452,
 267524308,
 100430,
 -61451,
 267589667,
 100429,
 -61450,
 267654979,
 100428,
 -61449,
 267720307,
 100427,
 -61448,
 267785598,
 100426,
 -61447,
 267850922,
 100425,
 -61446,
 267916172,
 100424,
 -61445,
 267981415,
 100423,
 -61444,
 268046652,
 100422,
 -1,
 268111916,
 100421,
 268308488,
 267523699,
 -1,
 -61441,
 268245204,
 100420,
 -61440,
 268310563,
 100419,
 -61439,
 268375875,
 100418,
 -61438,
 268441203,
 100417,
 -61437,
 268506494,
 100416,
 -61436,
 268571818,
 100415,
 -61435,
 268637068,
 100414,
 -61434,
 268702311,
 100413,
 -61433,
 268767548,
 100412,
 -1,
 268832812,
 100411,
 269029395,
 268244350,
 -1,
 -61430,
 268966100,
 100410,
 -61429,
 269031459,
 100409,
 -61428,
 269096771,
 100408,
 -61427,
 269162099,
 100407,
 -61426,
 269227390,
 100406,
 -61425,
 269292714,
 100405,
 -61424,
 269357964,
 100404,
 -61423,
 269423207,
 100403,
 -61422,
 269488444,
 100402,
 -1,
 269553708,
 100401,
 269750302,
 268965034,
 -1,
 -61419,
 269686996,
 100400,
 -61418,
 269752355,
 100399,
 -61417,
 269817667,
 100398,
 -61416,
 269882995,
 100397,
 -61415,
 269948286,
 100396,
 -61414,
 270013610,
 100395,
 -61413,
 270078860,
 100394,
 -61412,
 270144103,
 100393,
 -61411,
 270209340,
 100392,
 -1,
 270274604,
 100391,
 270471209,
 269685644,
 -1,
 -61408,
 270407892,
 100390,
 -61407,
 270473251,
 100389,
 -61406,
 270538563,
 100388,
 -61405,
 270603891,
 100387,
 -61404,
 270669182,
 100386,
 -61403,
 270734506,
 100385,
 -61402,
 270799756,
 100384,
 -61401,
 270864999,
 100383,
 -61400,
 270930236,
 100382,
 -1,
 270995500,
 100381,
 271192116,
 270406247,
 -1,
 -61397,
 271128788,
 100380,
 -61396,
 271194147,
 100379,
 -61395,
 271259459,
 100378,
 -61394,
 271324787,
 100377,
 -61393,
 271390078,
 100376,
 -61392,
 271455402,
 100375,
 -61391,
 271520652,
 100374,
 -61390,
 271585895,
 100373,
 -61389,
 271651132,
 100372,
 -1,
 271716396,
 100371,
 271913023,
 271126844,
 -1,
 -61386,
 271849684,
 100370,
 -61385,
 271915043,
 100369,
 -61384,
 271980355,
 100368,
 -61383,
 272045683,
 100367,
 -61382,
 272110974,
 100366,
 -61381,
 272176298,
 100365,
 -61380,
 272241548,
 100364,
 -61379,
 272306791,
 100363,
 -61378,
 272372028,
 100362,
 -1,
 272437292,
 100361,
 272695295,
 271847468,
 -1,
 -61375,
 272570580,
 100360,
 -61374,
 272635939,
 100359,
 -61373,
 272701251,
 100358,
 -61372,
 272766579,
 100357,
 -61371,
 272831870,
 100356,
 -61370,
 272897194,
 100355,
 -61369,
 272962444,
 100354,
 -61368,
 273027687,
 100353,
 -1,
 273092924,
 100352,
 273350655,
 266016579,
 -1,
 273354837,
 273224874,
 -1,
 -61364,
 273291476,
 101100,
 -61363,
 273356835,
 101099,
 -61362,
 273422147,
 101098,
 -61361,
 273487475,
 101097,
 -61360,
 273552766,
 101096,
 -61359,
 273618090,
 101095,
 -61358,
 273683340,
 101094,
 -61357,
 273748583,
 101093,
 -61356,
 273813820,
 101092,
 -1,
 273879084,
 101091,
 274075744,
 273290124,
 -1,
 -61353,
 274012372,
 101090,
 -61352,
 274077731,
 101089,
 -61351,
 274143043,
 101088,
 -61350,
 274208371,
 101087,
 -61349,
 274273662,
 101086,
 -61348,
 274338986,
 101085,
 -61347,
 274404236,
 101084,
 -61346,
 274469479,
 101083,
 -61345,
 274534716,
 101082,
 -1,
 274599980,
 101081,
 274796651,
 274010727,
 -1,
 -61342,
 274733268,
 101080,
 -61341,
 274798627,
 101079,
 -61340,
 274863939,
 101078,
 -61339,
 274929267,
 101077,
 -61338,
 274994558,
 101076,
 -61337,
 275059882,
 101075,
 -61336,
 275125132,
 101074,
 -61335,
 275190375,
 101073,
 -61334,
 275255612,
 101072,
 -1,
 275320876,
 101071,
 275517558,
 274731324,
 -1,
 -61331,
 275454164,
 101070,
 -61330,
 275519523,
 101069,
 -61329,
 275584835,
 101068,
 -61328,
 275650163,
 101067,
 -61327,
 275715454,
 101066,
 -61326,
 275780778,
 101065,
 -61325,
 275846028,
 101064,
 -61324,
 275911271,
 101063,
 -61323,
 275976508,
 101062,
 -1,
 276041772,
 101061,
 276238465,
 275451948,
 -1,
 -61320,
 276175060,
 101060,
 -61319,
 276240419,
 101059,
 -61318,
 276305731,
 101058,
 -61317,
 276371059,
 101057,
 -61316,
 276436350,
 101056,
 -61315,
 276501674,
 101055,
 -61314,
 276566924,
 101054,
 -61313,
 276632167,
 101053,
 -61312,
 276697404,
 101052,
 -1,
 276762668,
 101051,
 277020671,
 276174206,
 -1,
 -61309,
 276895102,
 101106,
 -61308,
 276960426,
 101105,
 -61307,
 277025676,
 101104,
 -61306,
 277090919,
 101103,
 -61305,
 277156156,
 101102,
 -1,
 277221420,
 101101,
 -1,
 222326891,
 94176,
 -1,
 222251687,
 127818,
 -1,
 222173847,
 127883,
 277615159,
 222136554,
 -1,
 277680611,
 277592577,
 -1,
 277746119,
 277670694,
 -1,
 277811407,
 277711916,
 -1,
 277876905,
 277777452,
 -1,
 277942429,
 277842988,
 -1,
 278007957,
 277879174,
 -1,
 -61293,
 277992346,
 983864,
 -61292,
 278029229,
 983861,
 -1,
 278075782,
 983854,
 278270103,
 277992346,
 983857,
 -1,
 278254490,
 983858,
 278401177,
 278238231,
 983862,
 -1,
 278369303,
 983863,
 278532251,
 278356909,
 983855,
 -1,
 278487981,
 983856,
 278724607,
 278479358,
 983859,
 -1,
 278610430,
 983860,
 278794401,
 277879174,
 -1,
 -61281,
 278778778,
 983732,
 -61280,
 278815661,
 983729,
 -1,
 278862214,
 983722,
 279056547,
 278778778,
 983725,
 -1,
 279040922,
 983726,
 279187621,
 279024663,
 983730,
 -1,
 279155735,
 983731,
 279318695,
 279143341,
 983723,
 -1,
 279274413,
 983724,
 279511039,
 279265790,
 983727,
 -1,
 279396862,
 983728,
 279580854,
 277866788,
 -1,
 279646382,
 279517574,
 -1,
 -61268,
 279630746,
 983710,
 -61267,
 279667629,
 983707,
 -1,
 279714182,
 983700,
 279908528,
 279630746,
 983703,
 -1,
 279892890,
 983704,
 280039602,
 279876631,
 983708,
 -1,
 280007703,
 983709,
 280170676,
 279995309,
 983701,
 -1,
 280126381,
 983702,
 280363007,
 280117758,
 983705,
 -1,
 280248830,
 983706,
 280432835,
 279532744,
 -1,
 280498363,
 280369542,
 -1,
 -61255,
 280482714,
 983688,
 -61254,
 280519597,
 983685,
 -1,
 280566150,
 983678,
 280760509,
 280482714,
 983681,
 -1,
 280744858,
 983682,
 280891583,
 280728599,
 983686,
 -1,
 280859671,
 983687,
 281022657,
 280847277,
 983679,
 -1,
 280978349,
 983680,
 281214975,
 280969726,
 983683,
 -1,
 281100798,
 983684,
 281284807,
 280369542,
 -1,
 -61243,
 281269146,
 983754,
 -61242,
 281306029,
 983751,
 -1,
 281352582,
 983744,
 281546953,
 281269146,
 983747,
 -1,
 281531290,
 983748,
 281678027,
 281515031,
 983752,
 -1,
 281646103,
 983753,
 281809101,
 281633709,
 983745,
 -1,
 281764781,
 983746,
 282001407,
 281756158,
 983749,
 -1,
 281887230,
 983750,
 282071287,
 277789185,
 -1,
 282136798,
 282024459,
 -1,
 282202325,
 282073478,
 -1,
 -61229,
 282186650,
 983886,
 -61228,
 282223533,
 983883,
 -1,
 282270086,
 983876,
 282464471,
 282186650,
 983879,
 -1,
 282448794,
 983880,
 282595545,
 282432535,
 983884,
 -1,
 282563607,
 983885,
 282726619,
 282551213,
 983877,
 -1,
 282682285,
 983878,
 282857693,
 282673662,
 983881,
 -1,
 282804734,
 983882,
 -1,
 282834255,
 983932,
 283054315,
 282114561,
 -1,
 283119843,
 282990982,
 -1,
 -61215,
 283104154,
 983897,
 -61214,
 283141037,
 983894,
 -1,
 283187590,
 983887,
 283381989,
 283104154,
 983890,
 -1,
 283366298,
 983891,
 283513063,
 283350039,
 983895,
 -1,
 283481111,
 983896,
 283644137,
 283468717,
 983888,
 -1,
 283599789,
 983889,
 283836415,
 283591166,
 983892,
 -1,
 283722238,
 983893,
 283906287,
 282990982,
 -1,
 -61203,
 283890586,
 983908,
 -61202,
 283927469,
 983905,
 -1,
 283974022,
 983898,
 284168433,
 283890586,
 983901,
 -1,
 284152730,
 983902,
 284299507,
 284136471,
 983906,
 -1,
 284267543,
 983907,
 284430581,
 284255149,
 983899,
 -1,
 284386221,
 983900,
 284622847,
 284377598,
 983903,
 -1,
 284508670,
 983904,
 284692766,
 282031887,
 -1,
 284758290,
 284653327,
 -1,
 284823814,
 284718863,
 -1,
 284889342,
 284760454,
 -1,
 -61188,
 284873626,
 983831,
 -61187,
 284910509,
 983828,
 -1,
 284957062,
 983821,
 285151488,
 284873626,
 983824,
 -1,
 285135770,
 983825,
 285282562,
 285119511,
 983829,
 -1,
 285250583,
 983830,
 285413636,
 285238189,
 983822,
 -1,
 285369261,
 983823,
 285605887,
 285360638,
 983826,
 -1,
 285491710,
 983827,
 285675786,
 284760454,
 -1,
 -61176,
 285660058,
 983842,
 -61175,
 285696941,
 983839,
 -1,
 285743494,
 983832,
 285937932,
 285660058,
 983835,
 -1,
 285922202,
 983836,
 286069006,
 285905943,
 983840,
 -1,
 286037015,
 983841,
 286200080,
 286024621,
 983833,
 -1,
 286155693,
 983834,
 286392319,
 286147070,
 983837,
 -1,
 286278142,
 983838,
 286462230,
 284694918,
 -1,
 -61164,
 286446490,
 983809,
 -61163,
 286483373,
 983806,
 -1,
 286529926,
 983799,
 286724376,
 286446490,
 983802,
 -1,
 286708634,
 983803,
 286855450,
 286692375,
 983807,
 -1,
 286823447,
 983808,
 286986524,
 286811053,
 983800,
 -1,
 286942125,
 983801,
 287178751,
 286933502,
 983804,
 -1,
 287064574,
 983805,
 287248696,
 284652345,
 -1,
 287314220,
 287228852,
 -1,
 287379748,
 287250822,
 983920,
 -61150,
 287363994,
 983931,
 -61149,
 287400877,
 983928,
 -1,
 287447430,
 983921,
 287641894,
 287363994,
 983924,
 -1,
 287626138,
 983925,
 287772968,
 287609879,
 983929,
 -1,
 287740951,
 983930,
 287904042,
 287728557,
 983922,
 -1,
 287859629,
 983923,
 288096255,
 287851006,
 983926,
 -1,
 287982078,
 983927,
 288166192,
 287250822,
 -1,
 -61138,
 288150426,
 983677,
 -61137,
 288187309,
 983674,
 -1,
 288233862,
 983667,
 288428338,
 288150426,
 983670,
 -1,
 288412570,
 983671,
 288559412,
 288396311,
 983675,
 -1,
 288527383,
 983676,
 288690486,
 288514989,
 983668,
 -1,
 288646061,
 983669,
 288882687,
 288637438,
 983672,
 -1,
 288768510,
 983673,
 288952658,
 287229857,
 -1,
 289018182,
 288933793,
 -1,
 289083710,
 288954758,
 -1,
 -61124,
 289067930,
 983721,
 -61123,
 289104813,
 983718,
 -1,
 289151366,
 983711,
 289345856,
 289067930,
 983714,
 -1,
 289330074,
 983715,
 289476930,
 289313815,
 983719,
 -1,
 289444887,
 983720,
 289608004,
 289432493,
 983712,
 -1,
 289563565,
 983713,
 289800191,
 289554942,
 983716,
 -1,
 289686014,
 983717,
 289870154,
 288954758,
 -1,
 -61112,
 289854362,
 983743,
 -61111,
 289891245,
 983740,
 -1,
 289937798,
 983733,
 290132300,
 289854362,
 983736,
 -1,
 290116506,
 983737,
 290263374,
 290100247,
 983741,
 -1,
 290231319,
 983742,
 290394448,
 290218925,
 983734,
 -1,
 290349997,
 983735,
 290586623,
 290341374,
 983738,
 -1,
 290472446,
 983739,
 290656620,
 288926918,
 -1,
 290722144,
 290630854,
 -1,
 290787672,
 290658694,
 -1,
 -61098,
 290771866,
 983853,
 -61097,
 290808749,
 983850,
 -1,
 290855302,
 983843,
 291049818,
 290771866,
 983846,
 -1,
 291034010,
 983847,
 291180892,
 291017751,
 983851,
 -1,
 291148823,
 983852,
 291311966,
 291136429,
 983844,
 -1,
 291267501,
 983845,
 291504127,
 291258878,
 983848,
 -1,
 291389950,
 983849,
 291574116,
 290658694,
 -1,
 -61086,
 291558298,
 983798,
 -61085,
 291595181,
 983795,
 -1,
 291641734,
 983788,
 291836262,
 291558298,
 983791,
 -1,
 291820442,
 983792,
 291967336,
 291804183,
 983796,
 -1,
 291935255,
 983797,
 292098410,
 291922861,
 983789,
 -1,
 292053933,
 983790,
 292290559,
 292045310,
 983793,
 -1,
 292176382,
 983794,
 292360569,
 290646308,
 -1,
 292426097,
 292297094,
 -1,
 -61073,
 292410266,
 983787,
 -61072,
 292447149,
 983784,
 -1,
 292493702,
 983777,
 292688243,
 292410266,
 983780,
 -1,
 292672410,
 983781,
 292819317,
 292656151,
 983785,
 -1,
 292787223,
 983786,
 292950391,
 292774829,
 983778,
 -1,
 292905901,
 983779,
 293142527,
 292897278,
 983782,
 -1,
 293028350,
 983783,
 293212550,
 292346800,
 -1,
 293278078,
 293149062,
 -1,
 -61060,
 293262234,
 983820,
 -61059,
 293299117,
 983817,
 -1,
 293345670,
 983810,
 293540224,
 293262234,
 983813,
 -1,
 293524378,
 983814,
 293671298,
 293508119,
 983818,
 -1,
 293639191,
 983819,
 293802372,
 293626797,
 983811,
 -1,
 293757869,
 983812,
 293994495,
 293749246,
 983815,
 -1,
 293880318,
 983816,
 294064531,
 293184175,
 -1,
 294130059,
 294001030,
 -1,
 -61047,
 294114202,
 983765,
 -61046,
 294151085,
 983762,
 -1,
 294197638,
 983755,
 294392205,
 294114202,
 983758,
 -1,
 294376346,
 983759,
 294523279,
 294360087,
 983763,
 -1,
 294491159,
 983764,
 294654353,
 294478765,
 983756,
 -1,
 294609837,
 983757,
 294846463,
 294601214,
 983760,
 -1,
 294732286,
 983761,
 294916512,
 294028147,
 -1,
 294982040,
 294852998,
 -1,
 -61034,
 294966170,
 983776,
 -61033,
 295003053,
 983773,
 -1,
 295049606,
 983766,
 295244186,
 294966170,
 983769,
 -1,
 295228314,
 983770,
 295375260,
 295212055,
 983774,
 -1,
 295343127,
 983775,
 295506334,
 295330733,
 983767,
 -1,
 295461805,
 983768,
 295698431,
 295453182,
 983771,
 -1,
 295584254,
 983772,
 295768493,
 294875661,
 -1,
 295834021,
 295704966,
 -1,
 -61021,
 295818138,
 983875,
 -61020,
 295855021,
 983872,
 -1,
 295901574,
 983865,
 296096167,
 295818138,
 983868,
 -1,
 296080282,
 983869,
 296227241,
 296064023,
 983873,
 -1,
 296195095,
 983874,
 296358315,
 296182701,
 983866,
 -1,
 296313773,
 983867,
 296550399,
 296305150,
 983870,
 -1,
 296436222,
 983871,
 296620474,
 295721483,
 -1,
 296686002,
 296556934,
 -1,
 -61008,
 296670106,
 983919,
 -61007,
 296706989,
 983916,
 -1,
 296753542,
 983909,
 296948148,
 296670106,
 983912,
 -1,
 296932250,
 983913,
 297079222,
 296915991,
 983917,
 -1,
 297047063,
 983918,
 297210296,
 297034669,
 983910,
 -1,
 297165741,
 983911,
 297402367,
 297157118,
 983914,
 -1,
 297288190,
 983915,
 297533439,
 296562083,
 -1,
 297537983,
 297408902,
 -1,
 -60995,
 297522074,
 983699,
 -60994,
 297558957,
 983696,
 -1,
 297605510,
 983689,
 297800129,
 297522074,
 983692,
 -1,
 297784218,
 983693,
 297931203,
 297767959,
 983697,
 -1,
 297899031,
 983698,
 298062277,
 297886637,
 983690,
 -1,
 298017709,
 983691,
 298254335,
 298009086,
 983694,
 -1,
 298140158,
 983695,
 298324448,
 277702521,
 -1,
 298389966,
 298295983,
 -1,
 298455501,
 298326406,
 -1,
 -60981,
 298437349,
 73691,
 -60980,
 298486988,
 73694,
 -1,
 298525404,
 73697,
 -1,
 298424250,
 73695,
 298783187,
 298376112,
 -1,
 298848722,
 298719622,
 -1,
 -60975,
 298823007,
 73696,
 -1,
 298873822,
 73713,
 -1,
 298796876,
 73699,
 299110871,
 298748761,
 -1,
 -60971,
 299096984,
 73689,
 -60970,
 299158252,
 73712,
 -1,
 299202062,
 73692,
 299373020,
 299070265,
 -1,
 299438555,
 299357082,
 -1,
 -60966,
 299429248,
 73698,
 -1,
 299481513,
 73690,
 -1,
 299375182,
 73693,
 -60963,
 299359144,
 73688,
 -60962,
 299667143,
 73685,
 -60961,
 299708477,
 73686,
 -1,
 299768439,
 73687,
 -60959,
 298305838,
 73711,
 -60958,
 299935098,
 73708,
 -1,
 299966351,
 73703,
 300159487,
 277622179,
 -1,
 300225021,
 300128772,
 -1,
 300290538,
 300190764,
 983650,
 300356072,
 300256300,
 983648,
 -1,
 300321836,
 983660,
 -60951,
 300345636,
 983646,
 -1,
 300438728,
 983644,
 300618221,
 300268033,
 983664,
 -60948,
 300595713,
 983663,
 -1,
 300636683,
 983662,
 300814832,
 300578575,
 983655,
 300941311,
 300775183,
 983658,
 -1,
 300840719,
 983657,
 301011442,
 300795809,
 983649,
 -1,
 300992417,
 983647,
 301142516,
 300985542,
 983654,
 -1,
 301116614,
 983659,
 301273590,
 301101881,
 983643,
 -1,
 301253556,
 983666,
 -60937,
 301263140,
 983653,
 -60936,
 301390768,
 983656,
 -60935,
 301441711,
 983651,
 -60934,
 301499251,
 983652,
 -60933,
 301560333,
 983661,
 -60932,
 301619723,
 983665,
 -1,
 301673891,
 983645,
 -60930,
 300210818,
 73706,
 -1,
 301838499,
 3063,
 301994527,
 300110772,
 -1,
 302060055,
 301963353,
 -1,
 302125575,
 302040993,
 -1,
 302191109,
 302078475,
 -1,
 -60924,
 302166229,
 73664,
 -1,
 302214936,
 73669,
 -60922,
 302178896,
 73672,
 -1,
 302336263,
 73675,
 302518796,
 302104750,
 -1,
 302584331,
 302466409,
 -1,
 -60918,
 302518887,
 73674,
 -1,
 302584124,
 73673,
 -1,
 302573960,
 73667,
 302846479,
 302471960,
 -1,
 -60914,
 302781031,
 73682,
 -1,
 302846268,
 73681,
 303043090,
 302796433,
 -1,
 -60911,
 303013193,
 73668,
 -1,
 303064588,
 73679,
 303239701,
 302990982,
 -1,
 -60908,
 303195596,
 73666,
 -1,
 303258123,
 73676,
 -60906,
 303213529,
 73680,
 -1,
 303405358,
 73665,
 303567390,
 302042060,
 -1,
 303632923,
 303546542,
 -1,
 -60902,
 303622545,
 73671,
 -1,
 303646064,
 73678,
 -60900,
 303616668,
 73677,
 -60899,
 303803416,
 73683,
 -1,
 303843022,
 73670,
 -1,
 303513727,
 73684,
 304091684,
 301938957,
 -1,
 -60895,
 304069063,
 73701,
 -60894,
 304113519,
 3046,
 -60893,
 304170015,
 3062,
 -1,
 304228131,
 3059,
 304419369,
 304072609,
 -1,
 304484904,
 304393598,
 -1,
 -60889,
 304452437,
 73705,
 -1,
 304494237,
 73704,
 -1,
 304455105,
 73709,
 304747052,
 304379663,
 -1,
 -60885,
 304696264,
 2998,
 -1,
 304750823,
 73702,
 304943663,
 304683398,
 -1,
 -60882,
 304921102,
 3064,
 -1,
 304975192,
 73707,
 -60880,
 304933420,
 3061,
 -60879,
 305128145,
 73700,
 -60878,
 305183161,
 3065,
 -60877,
 305244819,
 73727,
 -60876,
 305305389,
 3024,
 -60875,
 305369941,
 3066,
 -60874,
 305433236,
 3060,
 -1,
 305490114,
 73710,
 305664872,
 277570479,
 -1,
 305730272,
 305646324,
 -1,
 305795709,
 305691990,
 -1,
 305861202,
 305755919,
 -1,
 305926734,
 305832410,
 -1,
 305992256,
 305886009,
 -1,
 -60866,
 305981494,
 6692,
 -60865,
 306010653,
 6693,
 -1,
 306059654,
 6691,
 306254403,
 305973153,
 -1,
 -60862,
 306207261,
 6709,
 -1,
 306256262,
 6708,
 306451014,
 306225839,
 -1,
 -60859,
 306403869,
 6717,
 -1,
 306452870,
 6715,
 306647625,
 306392483,
 -1,
 -60856,
 306600477,
 6699,
 -1,
 306649478,
 6697,
 -60854,
 306637215,
 6719,
 -60853,
 306821846,
 6698,
 -60852,
 306884284,
 6704,
 -60851,
 306928157,
 6732,
 -1,
 306990822,
 6716,
 307171920,
 305863046,
 6723,
 -1,
 307118590,
 6739,
 -60847,
 307156456,
 6724,
 -1,
 307263321,
 6730,
 307434088,
 305815234,
 -1,
 307499607,
 307411457,
 -1,
 -60843,
 307477206,
 6727,
 -60842,
 307517981,
 6726,
 -1,
 307566982,
 6728,
 307761755,
 307458873,
 -1,
 -60839,
 307750966,
 6690,
 -60838,
 307780125,
 6689,
 -1,
 307829126,
 6688,
 308023902,
 307742625,
 -1,
 -60835,
 307976733,
 6707,
 -1,
 308025734,
 6706,
 308220513,
 307995311,
 -1,
 -60832,
 308173341,
 6713,
 -1,
 308222342,
 6712,
 308417124,
 308161955,
 -1,
 -60829,
 308369949,
 6696,
 -1,
 308418950,
 6695,
 -60827,
 308406687,
 6720,
 -60826,
 308588220,
 6702,
 -60825,
 308632093,
 6729,
 -1,
 308694758,
 6714,
 308875885,
 307408070,
 -1,
 308941420,
 308812166,
 6721,
 -60821,
 308922407,
 6701,
 -1,
 308972662,
 6705,
 -1,
 308925928,
 6722,
 309203569,
 308841516,
 -1,
 -60817,
 309193119,
 6700,
 -60816,
 309220631,
 6694,
 -1,
 309270918,
 6710,
 309465715,
 309187482,
 6735,
 -1,
 309449626,
 6736,
 309596789,
 309420973,
 6733,
 -1,
 309552045,
 6734,
 -60810,
 309584123,
 6725,
 -60809,
 309697085,
 6738,
 -60808,
 309756873,
 6718,
 -60807,
 309811518,
 6740,
 -60806,
 309871885,
 6737,
 -60805,
 309934492,
 6703,
 -60804,
 309995408,
 6711,
 -1,
 310057350,
 6731,
 310252191,
 305774521,
 -1,
 310317704,
 310211385,
 -1,
 310383237,
 310272794,
 -1,
 310448772,
 310315809,
 -1,
 -60798,
 310383998,
 6777,
 -60797,
 310449322,
 6776,
 -1,
 310514572,
 6775,
 -1,
 310382391,
 6780,
 310776455,
 310319718,
 6824,
 -1,
 310736610,
 6825,
 -1,
 310724996,
 6819,
 310973069,
 310295254,
 -1,
 311038603,
 310955567,
 6826,
 -1,
 310998754,
 6827,
 -60788,
 311025996,
 6818,
 -1,
 311129718,
 6752,
 311300754,
 310936631,
 -1,
 311366288,
 311260157,
 6772,
 -1,
 311297030,
 6744,
 -60783,
 311355884,
 6823,
 -1,
 311475027,
 6779,
 311628436,
 311288807,
 6816,
 -1,
 311615746,
 6817,
 311759511,
 311611052,
 -1,
 -60778,
 311693927,
 6774,
 -1,
 311759164,
 6773,
 311956122,
 311733446,
 -1,
 -60775,
 311905578,
 6822,
 -1,
 311957919,
 6778,
 312152733,
 311908875,
 -1,
 -60772,
 312124019,
 6820,
 -1,
 312156498,
 6828,
 -60770,
 312098102,
 6821,
 -1,
 312290785,
 6829,
 312480437,
 310239286,
 -1,
 312545958,
 312448023,
 6763,
 312611492,
 312482184,
 -1,
 -60765,
 312551754,
 6764,
 -1,
 312613598,
 6771,
 -60763,
 312600868,
 6765,
 -1,
 312775703,
 6768,
 312939178,
 312529818,
 6761,
 313004713,
 312923034,
 6762,
 -1,
 312951294,
 6760,
 -1,
 312951294,
 6759,
 313201326,
 312875398,
 6753,
 -60756,
 313156525,
 6769,
 -60755,
 313213438,
 6767,
 -1,
 313268614,
 6755,
 313463473,
 313182113,
 -1,
 -60752,
 313416488,
 6770,
 -1,
 313466710,
 6756,
 313660083,
 313418669,
 6757,
 -1,
 313615277,
 6758,
 -60748,
 313623618,
 6754,
 -1,
 313737726,
 6766,
 313922243,
 312462074,
 -1,
 313987769,
 313903009,
 -1,
 -60744,
 313976342,
 6802,
 -1,
 314008032,
 6803,
 314184380,
 313965057,
 -1,
 -60741,
 314143088,
 6806,
 -1,
 314199189,
 6807,
 314380991,
 314134161,
 -1,
 -60738,
 314351357,
 6804,
 -1,
 314405054,
 6805,
 -60736,
 314371355,
 6800,
 -60735,
 314546261,
 6801,
 -60734,
 314609736,
 6809,
 -1,
 314656390,
 6808,
 314839761,
 313876683,
 -1,
 314905287,
 314820513,
 -1,
 -60730,
 314893846,
 6786,
 -1,
 314925536,
 6787,
 315101898,
 314882561,
 -1,
 -60727,
 315060592,
 6790,
 -1,
 315116693,
 6791,
 315298509,
 315051665,
 -1,
 -60724,
 315268861,
 6788,
 -1,
 315322558,
 6789,
 -60722,
 315288859,
 6784,
 -60721,
 315463765,
 6785,
 -60720,
 315527240,
 6793,
 -1,
 315573894,
 6792,
 315817983,
 314782765,
 -1,
 315822815,
 315724392,
 -1,
 315888344,
 315786099,
 -1,
 315953879,
 315835609,
 -1,
 -60714,
 315927872,
 6741,
 -1,
 315979609,
 6742,
 -1,
 315890054,
 6748,
 316216027,
 315848463,
 -1,
 -60710,
 316187110,
 6746,
 -1,
 316217854,
 6743,
 -60708,
 316193494,
 6750,
 -60707,
 316366536,
 6747,
 -60706,
 316428415,
 6745,
 -1,
 316483472,
 6749,
 -1,
 315786810,
 6783,
 316740414,
 305716957,
 -1,
 316805920,
 316702038,
 -1,
 316871425,
 316768665,
 -1,
 316936935,
 316836908,
 -1,
 -60699,
 316926865,
 43664,
 -60698,
 316970007,
 43672,
 -1,
 317020312,
 43656,
 317199084,
 316896057,
 -1,
 317264619,
 317151755,
 -1,
 -60694,
 317232151,
 43650,
 -1,
 317284381,
 43652,
 -1,
 317232151,
 43648,
 317526767,
 317179809,
 -1,
 -60690,
 317494295,
 43668,
 -1,
 317546525,
 43670,
 317723378,
 317498031,
 -1,
 -60687,
 317690903,
 43676,
 -1,
 317743133,
 43678,
 317919989,
 317664675,
 -1,
 -60684,
 317887511,
 43658,
 -1,
 317939741,
 43660,
 -60682,
 317909905,
 43684,
 -60681,
 318103363,
 43690,
 -60680,
 318161517,
 43662,
 -60679,
 318224252,
 43686,
 -60678,
 318280727,
 43694,
 -60677,
 318343668,
 43682,
 -60676,
 318406790,
 43688,
 -60675,
 318464029,
 43692,
 -60674,
 318527640,
 43654,
 -60673,
 318591529,
 43680,
 -60672,
 318651666,
 43666,
 -1,
 318712721,
 43674,
 318963711,
 316825282,
 -1,
 318968582,
 318868524,
 -1,
 -60668,
 318958481,
 43665,
 -60667,
 319001623,
 43673,
 -1,
 319051928,
 43657,
 319230731,
 318927673,
 -1,
 319296266,
 319183371,
 -1,
 -60663,
 319263767,
 43651,
 -1,
 319315997,
 43653,
 -1,
 319263767,
 43649,
 319558414,
 319211425,
 -1,
 -60659,
 319525911,
 43669,
 -1,
 319578141,
 43671,
 319755025,
 319529647,
 -1,
 -60656,
 319722519,
 43677,
 -1,
 319774749,
 43679,
 319951636,
 319696291,
 -1,
 -60653,
 319919127,
 43659,
 -1,
 319971357,
 43661,
 -60651,
 319941521,
 43685,
 -60650,
 320134979,
 43691,
 -60649,
 320193133,
 43663,
 -60648,
 320255868,
 43687,
 -60647,
 320312343,
 43695,
 -60646,
 320375284,
 43683,
 -60645,
 320438406,
 43689,
 -60644,
 320495645,
 43693,
 -60643,
 320559256,
 43655,
 -60642,
 320623145,
 43681,
 -60641,
 320683282,
 43667,
 -1,
 320744337,
 43675,
 320934703,
 316792820,
 -1,
 321000231,
 320870790,
 -1,
 -60637,
 320989476,
 43708,
 -60636,
 321050088,
 43707,
 -60635,
 321096748,
 43709,
 -60634,
 321160051,
 43710,
 -1,
 321198470,
 43697,
 321393451,
 320983962,
 43700,
 321458986,
 321339902,
 43699,
 -1,
 321395078,
 43705,
 -1,
 321395078,
 43706,
 321655597,
 321348525,
 43698,
 -1,
 321591686,
 43704,
 -60626,
 321623063,
 43702,
 -1,
 321733118,
 43701,
 321917750,
 320915301,
 -1,
 321983283,
 321877543,
 -1,
 -60622,
 321948716,
 43739,
 -1,
 322003904,
 43743,
 -60620,
 321960787,
 43741,
 -60619,
 322147133,
 43740,
 -1,
 322199584,
 43742,
 322376507,
 321900194,
 -1,
 -60616,
 322358163,
 43713,
 -60615,
 322421431,
 43714,
 -60614,
 322474813,
 43712,
 -1,
 322520832,
 43711,
 322764799,
 322339900,
 -1,
 -60611,
 322658234,
 43703,
 -1,
 322707794,
 43696,
 322961407,
 316701215,
 -1,
 322966347,
 322881441,
 -1,
 323031878,
 322935081,
 -1,
 -60606,
 322967155,
 6516,
 -60605,
 323032446,
 6515,
 -60604,
 323097770,
 6514,
 -60603,
 323163020,
 6513,
 -1,
 323228263,
 6512,
 323425097,
 323009025,
 -1,
 -60600,
 323377693,
 6497,
 -1,
 323426694,
 6483,
 -60598,
 323377693,
 6487,
 -1,
 323557766,
 6486,
 323752782,
 322912766,
 6507,
 -60595,
 323705355,
 6502,
 -1,
 323764734,
 6501,
 323949393,
 323688838,
 6499,
 -60592,
 323933672,
 6508,
 -1,
 323969965,
 6509,
 324146003,
 323933082,
 6503,
 -1,
 324092414,
 6506,
 324277078,
 324117167,
 -1,
 -60587,
 324229661,
 6490,
 -1,
 324278662,
 6489,
 324473688,
 324244503,
 6505,
 -1,
 324441111,
 6504,
 324604763,
 324439084,
 -1,
 -60582,
 324556055,
 6482,
 -1,
 324606342,
 6498,
 324801374,
 324563769,
 -1,
 -60579,
 324753949,
 6496,
 -1,
 324802950,
 6480,
 -60577,
 324790687,
 6485,
 -60576,
 324986934,
 6481,
 -60575,
 325049283,
 6493,
 -60574,
 325106390,
 6484,
 -60573,
 325167904,
 6495,
 -60572,
 325223369,
 6491,
 -60571,
 325285721,
 6488,
 -60570,
 325346221,
 6500,
 -60569,
 325409309,
 6494,
 -1,
 325471974,
 6492,
 325653444,
 305623865,
 -1,
 325718979,
 325628606,
 -1,
 325784484,
 325680470,
 -1,
 325849968,
 325720454,
 71296,
 -60563,
 325833626,
 71305,
 -60562,
 325889847,
 71352,
 -60561,
 325936045,
 71303,
 -1,
 325982598,
 71297,
 326177654,
 325830561,
 -1,
 326243188,
 326158241,
 -1,
 -60557,
 326195741,
 71317,
 -1,
 326244742,
 71316,
 -60555,
 326195741,
 71322,
 -1,
 326375814,
 71321,
 326570875,
 326143020,
 -1,
 -60552,
 326560159,
 71315,
 -60551,
 326601846,
 71320,
 -60550,
 326653207,
 71310,
 -1,
 326703494,
 71325,
 326898561,
 326514957,
 -1,
 326964095,
 326842637,
 -1,
 -60546,
 326916637,
 71319,
 -1,
 326965638,
 71318,
 -60544,
 326916637,
 71324,
 -1,
 327096710,
 71323,
 327291779,
 326882202,
 71300,
 -1,
 327275418,
 71301,
 327422854,
 327268865,
 -1,
 -60539,
 327375389,
 71335,
 -1,
 327424390,
 71336,
 327619465,
 327396550,
 -1,
 -60536,
 327593280,
 71338,
 -1,
 327620998,
 71332,
 327816076,
 327590575,
 -1,
 -60533,
 327768605,
 71327,
 -1,
 327817606,
 71326,
 328012687,
 327775033,
 -1,
 -60530,
 327965213,
 71307,
 -1,
 328014214,
 71306,
 328209298,
 327971341,
 -1,
 -60527,
 328161821,
 71314,
 -1,
 328210822,
 71313,
 328405908,
 328164269,
 71298,
 -1,
 328360877,
 71299,
 328536983,
 328357064,
 -1,
 -60522,
 328489501,
 71309,
 -1,
 328538502,
 71308,
 328733594,
 328478115,
 -1,
 -60519,
 328686109,
 71312,
 -1,
 328735110,
 71311,
 328930205,
 328673119,
 -1,
 -60516,
 328882717,
 71329,
 -1,
 328931718,
 71328,
 -60514,
 328919455,
 71331,
 -60513,
 329112515,
 71334,
 -60512,
 329159703,
 71304,
 -60511,
 329221065,
 71330,
 -60510,
 329283417,
 71333,
 -60509,
 329341469,
 71337,
 -1,
 329400830,
 71302,
 329585586,
 325729379,
 -1,
 329651112,
 329566113,
 -1,
 -60505,
 329639446,
 71362,
 -1,
 329671136,
 71363,
 329847723,
 329628161,
 -1,
 -60502,
 329806192,
 71366,
 -1,
 329862293,
 71367,
 330044334,
 329797265,
 -1,
 -60499,
 330014461,
 71364,
 -1,
 330068158,
 71365,
 -60497,
 330034459,
 71360,
 -60496,
 330209365,
 71361,
 -60495,
 330272840,
 71369,
 -1,
 330319494,
 71368,
 330503101,
 329572406,
 -1,
 330568631,
 330439046,
 -1,
 -60491,
 330552218,
 71349,
 -60490,
 330589101,
 71347,
 -1,
 330635654,
 71341,
 330830777,
 330552218,
 71344,
 -1,
 330814362,
 71345,
 330961851,
 330785709,
 71342,
 -1,
 330916781,
 71343,
 -60484,
 330929175,
 71348,
 -1,
 331039230,
 71346,
 331284479,
 330481593,
 -1,
 331289537,
 331210429,
 -1,
 -60480,
 331266993,
 71340,
 -1,
 331329113,
 71350,
 -60478,
 331256643,
 71351,
 -1,
 331424293,
 71339,
 -1,
 325667195,
 129377,
 331682759,
 325615719,
 -1,
 -60474,
 331651157,
 119671,
 -1,
 331698474,
 119672,
 331879369,
 331622239,
 983061,
 -1,
 331840042,
 127955,
 -60470,
 331868331,
 128661,
 -60469,
 331982034,
 128429,
 -1,
 332018733,
 127790,
 332207266,
 222061485,
 -1,
 332272701,
 332180678,
 -1,
 332338236,
 332227443,
 -1,
 332403725,
 332299606,
 -1,
 332469207,
 332389296,
 -1,
 332534742,
 332436653,
 -1,
 332600276,
 332508358,
 70791,
 -1,
 332573894,
 70792,
 332791807,
 332560143,
 70793,
 -1,
 332691215,
 70794,
 -1,
 332470662,
 70827,
 332927965,
 332449697,
 -1,
 332993499,
 332908449,
 -1,
 -60454,
 332945949,
 70810,
 -1,
 332994950,
 70809,
 -60452,
 332945949,
 70815,
 -1,
 333126022,
 70814,
 333321186,
 332893228,
 -1,
 -60449,
 333310367,
 70808,
 -60448,
 333352054,
 70813,
 -60447,
 333403415,
 70803,
 -1,
 333453702,
 70818,
 333648872,
 333265165,
 -1,
 333714406,
 333592845,
 -1,
 -60443,
 333666845,
 70812,
 -1,
 333715846,
 70811,
 -60441,
 333666845,
 70817,
 -1,
 333846918,
 70816,
 334042092,
 333584774,
 70785,
 -60438,
 334025626,
 70798,
 -60437,
 334062509,
 70796,
 -1,
 334109062,
 70786,
 334304240,
 334019073,
 -1,
 -60434,
 334281430,
 70829,
 -60433,
 334322205,
 70828,
 -1,
 334371206,
 70830,
 334566386,
 334287770,
 70789,
 -1,
 334549914,
 70790,
 334697461,
 334537391,
 -1,
 -60428,
 334649885,
 70820,
 -1,
 334698886,
 70819,
 334894072,
 334656313,
 -1,
 -60425,
 334846493,
 70800,
 -1,
 334895494,
 70799,
 335090683,
 334852621,
 -1,
 -60422,
 335043101,
 70807,
 -1,
 335092102,
 70806,
 335287293,
 335045549,
 70787,
 -1,
 335242157,
 70788,
 335418368,
 335238344,
 -1,
 -60417,
 335370781,
 70802,
 -1,
 335419782,
 70801,
 335614979,
 335359395,
 -1,
 -60414,
 335567389,
 70805,
 -1,
 335616390,
 70804,
 335811590,
 335554399,
 -1,
 -60411,
 335763997,
 70822,
 -1,
 335812998,
 70821,
 -60409,
 335800735,
 70824,
 -60408,
 335981888,
 70825,
 -60407,
 336040983,
 70797,
 -60406,
 336102345,
 70823,
 -60405,
 336164697,
 70826,
 -60404,
 336222749,
 70831,
 -1,
 336282110,
 70795,
 336466976,
 332390454,
 -1,
 336532499,
 336453469,
 -1,
 336598033,
 336506054,
 70837,
 -1,
 336571590,
 70838,
 336789503,
 336557839,
 70839,
 -1,
 336688911,
 70840,
 336860183,
 336468358,
 -1,
 -60395,
 336843674,
 70846,
 -60394,
 336880557,
 70843,
 -1,
 336927110,
 70832,
 337122329,
 336843674,
 70835,
 -1,
 337105818,
 70836,
 337253404,
 337100515,
 -1,
 -60389,
 337220631,
 70845,
 -1,
 337265150,
 70842,
 337450014,
 337208237,
 70833,
 -1,
 337404845,
 70834,
 -60385,
 337417239,
 70844,
 -1,
 337527294,
 70841,
 337712174,
 336411747,
 -1,
 337777700,
 337692577,
 -1,
 -60381,
 337765910,
 70866,
 -1,
 337797600,
 70867,
 337974311,
 337754625,
 -1,
 -60378,
 337932656,
 70870,
 -1,
 337988757,
 70871,
 338170922,
 337923729,
 -1,
 -60375,
 338140925,
 70868,
 -1,
 338194622,
 70869,
 -60373,
 338160923,
 70864,
 -60372,
 338335829,
 70865,
 -60371,
 338399304,
 70873,
 -1,
 338445958,
 70872,
 338629687,
 337690553,
 -1,
 338695218,
 338615997,
 -1,
 -60367,
 338672561,
 70849,
 -1,
 338734681,
 70850,
 338891829,
 338631046,
 -1,
 -60364,
 338877382,
 70852,
 -1,
 338924434,
 70848,
 -60362,
 338858819,
 70851,
 -1,
 339029623,
 70847,
 339219514,
 338565510,
 -1,
 -60359,
 339185905,
 70784,
 -1,
 339224820,
 70854,
 -60357,
 339187501,
 70855,
 -1,
 339368396,
 70853,
 -1,
 332285026,
 128555,
 339612800,
 332222498,
 -1,
 339678333,
 339574102,
 -1,
 339743851,
 339667236,
 -1,
 339809382,
 339679622,
 11568,
 339874885,
 339753229,
 11575,
 339940420,
 339818765,
 11577,
 -1,
 339892747,
 11578,
 -1,
 339892747,
 11576,
 340137032,
 339864624,
 11619,
 -60345,
 340126768,
 11621,
 -1,
 340154891,
 11594,
 340333643,
 340117409,
 11612,
 -60342,
 340314017,
 11615,
 -1,
 340351499,
 11613,
 340530254,
 340310529,
 11609,
 -60339,
 340507137,
 11610,
 -1,
 340548107,
 11611,
 340726865,
 340489017,
 11581,
 340852735,
 340679179,
 11589,
 -1,
 340744715,
 11583,
 340923476,
 340677832,
 11571,
 341049343,
 340875787,
 11606,
 -1,
 340941323,
 11572,
 341120086,
 340896966,
 11604,
 -1,
 341093574,
 11605,
 341251160,
 341072395,
 11584,
 -1,
 341203467,
 11587,
 341382234,
 341190495,
 11569,
 -1,
 341334539,
 11570,
 -60325,
 341371172,
 11618,
 -60324,
 341500091,
 11617,
 -60323,
 341564336,
 11616,
 -60322,
 341617409,
 11591,
 -60321,
 341680815,
 11602,
 -60320,
 341740588,
 11599,
 -60319,
 341803891,
 11598,
 -60318,
 341866255,
 11597,
 -60317,
 341930509,
 11574,
 -60316,
 341986961,
 11580,
 -60315,
 342044740,
 11614,
 -1,
 342104454,
 11588,
 342299752,
 339755518,
 11622,
 -1,
 342288676,
 11579,
 -60311,
 342283162,
 11603,
 -60310,
 342397975,
 11623,
 -1,
 342451117,
 11593,
 342627447,
 339724193,
 -1,
 342692982,
 342611077,
 -1,
 342758511,
 342651705,
 11582,
 -1,
 342710795,
 11590,
 342889586,
 342709448,
 -1,
 -60303,
 342854700,
 11600,
 -1,
 342907403,
 11607,
 -60301,
 342879576,
 11596,
 -60300,
 343059201,
 11592,
 -60299,
 343117649,
 11601,
 -1,
 343169547,
 11586,
 -1,
 342632198,
 11620,
 343413882,
 342567289,
 -1,
 -60295,
 343372301,
 11573,
 -1,
 343431691,
 11585,
 343670783,
 343349638,
 -1,
 -60292,
 343599764,
 11608,
 -1,
 343628360,
 11595,
 -60290,
 339655873,
 11632,
 -60289,
 343771697,
 11631,
 -1,
 343815472,
 11647,
 344003734,
 339552668,
 -1,
 344069259,
 343967096,
 -1,
 344134789,
 344008543,
 -1,
 -60284,
 344113358,
 4048,
 -1,
 344159129,
 983208,
 -60282,
 344117109,
 4058,
 -60281,
 344298498,
 4050,
 -60280,
 344361437,
 4049,
 -60279,
 344423038,
 4057,
 -60278,
 344484822,
 4051,
 -1,
 344536035,
 4052,
 344724627,
 344046081,
 -1,
 344790160,
 344708294,
 -1,
 -60274,
 344753803,
 3982,
 -60273,
 344816042,
 3981,
 -1,
 344878456,
 3983,
 345112575,
 344745849,
 -1,
 -60270,
 345026425,
 4046,
 -1,
 345075064,
 3980,
 345309183,
 344685910,
 -1,
 -60267,
 345225400,
 3948,
 -1,
 345273866,
 3947,
 345445533,
 343964166,
 -1,
 345511068,
 345433164,
 -1,
 345576603,
 345455959,
 -1,
 -60262,
 345516362,
 11807,
 -1,
 345578206,
 11806,
 -1,
 345552261,
 11803,
 -1,
 345480057,
 11081,
 345904287,
 345396968,
 128005,
 -1,
 345834172,
 128047,
 -60256,
 345871298,
 68410,
 -60255,
 345999287,
 9202,
 -1,
 346043220,
 127915,
 346232133,
 332153342,
 -1,
 346297625,
 346214236,
 -1,
 346363062,
 346238371,
 -1,
 346428591,
 346330135,
 -1,
 346494124,
 346393644,
 -1,
 346559659,
 346474401,
 -1,
 -60247,
 346533540,
 119563,
 -60246,
 346573091,
 119582,
 -1,
 346626991,
 119573,
 -1,
 346539152,
 119608,
 346947583,
 346458897,
 -1,
 -60242,
 346842253,
 119634,
 -1,
 346901408,
 119630,
 347083956,
 346390843,
 -1,
 347149491,
 347030014,
 -1,
 -60238,
 347115257,
 119590,
 -1,
 347158857,
 119613,
 -1,
 347134461,
 119631,
 -60235,
 347036654,
 119585,
 -1,
 347359530,
 119558,
 347542724,
 346306829,
 -1,
 347608253,
 347497389,
 -1,
 347673787,
 347571059,
 -1,
 -60230,
 347638076,
 119625,
 -1,
 347696067,
 119612,
 -60228,
 347659597,
 119568,
 -1,
 347819972,
 119636,
 348001473,
 347554302,
 -1,
 -60225,
 347972756,
 119623,
 -60224,
 348016463,
 119567,
 -1,
 348074703,
 119586,
 -60222,
 347986797,
 119584,
 -60221,
 348233390,
 119619,
 -1,
 348267361,
 119624,
 348460237,
 347488766,
 -1,
 348525769,
 348425260,
 -1,
 -60217,
 348485877,
 119603,
 -60216,
 348535482,
 119583,
 -1,
 348599908,
 119600,
 -60214,
 348514454,
 119626,
 -60213,
 348768928,
 119610,
 -60212,
 348816936,
 119618,
 -1,
 348857590,
 119580,
 349050071,
 348433606,
 -1,
 349115606,
 348996094,
 -1,
 349181140,
 349092353,
 -1,
 349246675,
 349135789,
 -1,
 -60206,
 349226121,
 119579,
 -1,
 349256439,
 119596,
 -1,
 349218977,
 119598,
 -60203,
 349141667,
 119578,
 -1,
 349444959,
 119572,
 -1,
 349073589,
 119605,
 349705440,
 348999313,
 -1,
 349770971,
 349689489,
 -1,
 -60198,
 349736697,
 119595,
 -1,
 349766116,
 119559,
 349967582,
 349738007,
 -1,
 -60195,
 349947103,
 119638,
 -1,
 349995103,
 119576,
 -60193,
 349929082,
 119606,
 -1,
 350100925,
 119632,
 350295272,
 349682177,
 -1,
 350360806,
 350275489,
 -1,
 350426341,
 350327831,
 -1,
 -60188,
 350411928,
 119601,
 -1,
 350464252,
 119628,
 -1,
 350400861,
 119593,
 -60185,
 350317580,
 119621,
 -1,
 350637309,
 119627,
 350819566,
 350246088,
 -1,
 350885099,
 350758378,
 119592,
 -1,
 350815085,
 119615,
 -60180,
 350868602,
 119614,
 -60179,
 350990358,
 119602,
 -1,
 351049230,
 119599,
 351212788,
 350790319,
 -1,
 351278322,
 351148422,
 -1,
 -60175,
 351261042,
 119604,
 -1,
 351286121,
 119588,
 -60173,
 351263258,
 119594,
 -1,
 351422607,
 119571,
 351606009,
 351148422,
 -1,
 -60170,
 351583180,
 119564,
 -60169,
 351622971,
 119633,
 -60168,
 351683016,
 119577,
 -1,
 351743889,
 119617,
 351933693,
 351568755,
 -1,
 -60165,
 351891180,
 119560,
 -60164,
 351945693,
 119609,
 -1,
 352003373,
 119616,
 352195842,
 351893263,
 -1,
 352261377,
 352131462,
 -1,
 -60160,
 352247997,
 119597,
 -1,
 352267334,
 119637,
 -1,
 352208429,
 119589,
 352523526,
 352135007,
 -1,
 -60156,
 352497255,
 119566,
 -60155,
 352556728,
 119587,
 -1,
 352592898,
 119561,
 352785673,
 352510203,
 -1,
 -60152,
 352766307,
 119620,
 -1,
 352809088,
 119575,
 352982284,
 352752663,
 -1,
 -60149,
 352954683,
 119565,
 -1,
 353012796,
 119635,
 353178895,
 352940857,
 -1,
 -60146,
 353135700,
 119591,
 -1,
 353191291,
 119562,
 353375506,
 353134766,
 -1,
 -60143,
 353341150,
 119622,
 -1,
 353384086,
 119570,
 353572117,
 353327627,
 -1,
 -60140,
 353539806,
 119574,
 -1,
 353575739,
 119629,
 -60138,
 353561544,
 119569,
 -60137,
 353754237,
 119607,
 -60136,
 353818611,
 119611,
 -1,
 353858312,
 119581,
 354030908,
 346257167,
 -1,
 354096437,
 354014757,
 -1,
 354161959,
 354046910,
 -1,
 354227491,
 354142113,
 -1,
 354293024,
 354215594,
 -1,
 -60129,
 354260248,
 3194,
 -1,
 354307252,
 3197,
 354549759,
 354247275,
 -1,
 -60126,
 354456856,
 3195,
 -1,
 354503860,
 3198,
 354686246,
 354195569,
 -1,
 -60123,
 354653464,
 3193,
 -1,
 354700468,
 3196,
 -1,
 354676006,
 3192,
 354948398,
 354140089,
 -1,
 355013931,
 354890869,
 -1,
 -60118,
 354954896,
 3072,
 -1,
 355017262,
 3076,
 -60116,
 354996855,
 3199,
 -60115,
 355188565,
 3191,
 -1,
 355215054,
 3133,
 355407155,
 354909526,
 -1,
 -60112,
 355389736,
 3160,
 -60111,
 355449066,
 3162,
 -60110,
 355500105,
 3124,
 -1,
 355549681,
 3161,
 355794943,
 355393636,
 3170,
 -1,
 355694351,
 3171,
 355926015,
 354042366,
 -1,
 355931450,
 355837494,
 -1,
 355996985,
 355905567,
 128222,
 -1,
 355929529,
 128380,
 -1,
 355964929,
 128384,
 -60101,
 355917617,
 128250,
 -1,
 356170732,
 128301,
 356324672,
 353995820,
 -1,
 -60098,
 356304801,
 9978,
 -60097,
 356356278,
 127934,
 -1,
 356406907,
 8376,
 356586819,
 356260230,
 -1,
 -60094,
 356560143,
 128198,
 -1,
 356595817,
 127861,
 -60092,
 356566120,
 129514,
 -1,
 356727406,
 129528,
 356914543,
 346184203,
 -1,
 356980065,
 356888750,
 -1,
 357045593,
 356909056,
 -1,
 357111117,
 357019401,
 -1,
 -60086,
 357086053,
 128487,
 -60085,
 357137131,
 128486,
 -60084,
 357181770,
 128485,
 -1,
 357243614,
 128484,
 357438802,
 357070607,
 -1,
 357504337,
 357394971,
 -1,
 -60080,
 357479269,
 9886,
 -1,
 357530347,
 9887,
 -1,
 357451280,
 11057,
 357766485,
 357382413,
 -1,
 -60076,
 357735854,
 8278,
 -1,
 357787747,
 10176,
 -60074,
 357745396,
 128491,
 -60073,
 357935073,
 128962,
 -60072,
 357994242,
 128423,
 -1,
 358034814,
 128433,
 358285311,
 356978341,
 -1,
 358290784,
 358168847,
 -1,
 358356318,
 358272746,
 -1,
 -60067,
 358331694,
 11162,
 -1,
 358382678,
 11160,
 -60065,
 358331503,
 11161,
 -1,
 358513589,
 11163,
 -1,
 358238085,
 11835,
 358749544,
 356934573,
 -1,
 358815079,
 358714412,
 -1,
 358880614,
 358744064,
 -1,
 -60059,
 358857547,
 128936,
 -1,
 358898014,
 128929,
 -1,
 358839734,
 129300,
 -1,
 358788962,
 129353,
 359208301,
 358732698,
 -1,
 359273836,
 359171718,
 -1,
 -60053,
 359258273,
 128077,
 -1,
 359284820,
 128078,
 -1,
 359239099,
 9928,
 -60050,
 359177939,
 128173,
 -1,
 359484077,
 127777,
 359667091,
 356881431,
 -1,
 359732608,
 359643438,
 -1,
 359798143,
 359674600,
 -1,
 359863670,
 359732851,
 -1,
 -60044,
 359798791,
 127552,
 -60043,
 359863903,
 127560,
 -1,
 359928694,
 127557,
 360125817,
 359798595,
 -1,
 -60040,
 360060735,
 127558,
 -1,
 360124728,
 127556,
 360322428,
 360060286,
 -1,
 -60037,
 360261516,
 127555,
 -1,
 360321928,
 127559,
 360579071,
 360256891,
 -1,
 -60034,
 360454349,
 127554,
 -1,
 360517941,
 127553,
 -1,
 359758160,
 127274,
 360781196,
 359703217,
 -1,
 360846726,
 360733213,
 -1,
 360912261,
 360807885,
 -1,
 -60028,
 360889420,
 11833,
 -1,
 360917747,
 11210,
 -1,
 360892321,
 127913,
 -60025,
 360834417,
 128285,
 -60024,
 361156372,
 9184,
 -60023,
 361214891,
 11811,
 -60022,
 361276500,
 9180,
 -60021,
 361331499,
 11810,
 -1,
 361379992,
 9182,
 361567631,
 360748055,
 -1,
 -60018,
 361548478,
 129463,
 -1,
 361593253,
 129520,
 -60016,
 361533416,
 128069,
 -60015,
 361727500,
 127813,
 -60014,
 361789189,
 128508,
 -1,
 361850925,
 128701,
 362026416,
 359650202,
 -1,
 362091950,
 361999558,
 -1,
 362157482,
 362057292,
 -1,
 362223004,
 362134017,
 -1,
 362288538,
 362192892,
 -1,
 -60007,
 362275475,
 128597,
 -1,
 362300310,
 128599,
 -60005,
 362251469,
 8526,
 -1,
 362432416,
 11829,
 362616225,
 362166541,
 -1,
 362681760,
 362571624,
 -1,
 -60001,
 362669590,
 8586,
 -1,
 362701280,
 8587,
 -1,
 362618146,
 11832,
 362943908,
 362582420,
 -1,
 -59997,
 362930835,
 128596,
 -1,
 362955670,
 128598,
 363140519,
 362883808,
 -1,
 -59994,
 363118283,
 9930,
 -1,
 363177348,
 11202,
 -59992,
 363127709,
 9929,
 -59991,
 363304502,
 128399,
 -1,
 363345050,
 11826,
 363533741,
 362115897,
 -1,
 -59988,
 363491149,
 8378,
 -1,
 363548287,
 129411,
 -1,
 363515445,
 128034,
 -59985,
 362055252,
 129347,
 -1,
 363757406,
 127799,
 363926988,
 361999558,
 -1,
 363992506,
 363881389,
 -1,
 364058039,
 363929938,
 -1,
 364123574,
 364041859,
 -1,
 -59979,
 364099954,
 128208,
 -1,
 364138859,
 128681,
 -1,
 364083801,
 128710,
 -59976,
 364029681,
 11851,
 -59975,
 364329735,
 128305,
 -1,
 364393558,
 8285,
 364582338,
 363927942,
 -1,
 364647869,
 364544883,
 128650,
 -1,
 364577205,
 128651,
 364778944,
 364588451,
 -1,
 -59969,
 364760823,
 128668,
 -1,
 364803237,
 128434,
 -59967,
 364745334,
 11223,
 -1,
 364931246,
 128646,
 365106633,
 364549143,
 -1,
 365172168,
 365077167,
 -1,
 365237703,
 365126880,
 -1,
 -59962,
 365187329,
 128032,
 -1,
 365248834,
 127865,
 -1,
 365192091,
 127942,
 -1,
 365133860,
 128654,
 365625343,
 365089690,
 -1,
 -59957,
 365529862,
 127930,
 -1,
 365576806,
 11231,
 365762009,
 363913403,
 -1,
 365827544,
 365728791,
 -1,
 365893079,
 365756416,
 -1,
 365958610,
 365837651,
 -1,
 -59951,
 365935204,
 11818,
 -1,
 365955167,
 8282,
 -59949,
 365946718,
 128109,
 -59948,
 366134004,
 128490,
 -59947,
 366184328,
 128108,
 -59946,
 366239000,
 128149,
 -1,
 366292350,
 128432,
 -1,
 365825774,
 11834,
 -1,
 365785034,
 128256,
 366673919,
 365694629,
 -1,
 -59941,
 366591658,
 128085,
 -1,
 366654048,
 129430,
 366813039,
 222018049,
 -1,
 366877314,
 366764973,
 983080,
 366942649,
 366827653,
 -1,
 367008184,
 366929884,
 -1,
 367073110,
 366959115,
 -1,
 367138633,
 367008134,
 -1,
 367204168,
 367103389,
 -1,
 367269553,
 367152785,
 -1,
 367335053,
 367226822,
 121091,
 367460351,
 367263744,
 -1,
 367466052,
 367356246,
 120832,
 367591423,
 367394816,
 -1,
 367597078,
 367495223,
 120846,
 367722495,
 367525888,
 -1,
 367728125,
 367603107,
 -1,
 367793657,
 367696312,
 120853,
 367919103,
 367722496,
 -1,
 367924723,
 367840369,
 -1,
 367990258,
 367902557,
 120877,
 368115711,
 367919104,
 -1,
 -59919,
 367998246,
 120878,
 -1,
 368060758,
 120879,
 -1,
 367940275,
 120884,
 368317941,
 367877993,
 120857,
 -1,
 368249394,
 120882,
 368449015,
 368261244,
 120856,
 -1,
 368380432,
 120885,
 -59912,
 368412742,
 120855,
 -1,
 368535907,
 120854,
 368771071,
 367769629,
 -1,
 368776700,
 368657483,
 120858,
 -1,
 368708146,
 120883,
 -1,
 368706602,
 121001,
 368973321,
 367709291,
 120862,
 369098751,
 368902144,
 -1,
 369104387,
 368979363,
 -1,
 -59903,
 369088760,
 120872,
 -59902,
 369138113,
 120893,
 -1,
 369192586,
 120873,
 369366534,
 369056267,
 -1,
 -59899,
 369334877,
 120874,
 -1,
 369388403,
 120875,
 369563144,
 369303952,
 120895,
 -1,
 369493368,
 120894,
 -1,
 369502550,
 120866,
 369759759,
 368946374,
 -1,
 369825294,
 369715763,
 120966,
 369950719,
 369754112,
 -1,
 -59891,
 369833254,
 120972,
 -1,
 369895766,
 120971,
 -1,
 369761806,
 120849,
 370152977,
 369713001,
 120850,
 -1,
 370084194,
 120867,
 370284051,
 370092374,
 120848,
 -1,
 370215486,
 120865,
 -59884,
 370268329,
 120871,
 -59883,
 370394525,
 120864,
 -1,
 370442133,
 120996,
 370611765,
 367578225,
 -1,
 370677281,
 370589533,
 121052,
 370802687,
 370606080,
 -1,
 370808349,
 370723953,
 -1,
 -59877,
 370752502,
 121054,
 -59876,
 370816294,
 121055,
 -1,
 370878806,
 121056,
 371070496,
 370764124,
 -1,
 -59873,
 371023708,
 121059,
 -1,
 371075414,
 121057,
 -1,
 371010565,
 121058,
 371332651,
 370617763,
 -1,
 371398185,
 371315610,
 -1,
 371463720,
 371371206,
 -1,
 371529255,
 371449031,
 -1,
 -59866,
 371513216,
 121066,
 -1,
 371551323,
 121064,
 -1,
 371490345,
 121063,
 -1,
 371435778,
 120887,
 371916799,
 371355215,
 121067,
 -1,
 371800381,
 120892,
 371988015,
 371286139,
 121062,
 372113407,
 371934321,
 -1,
 -59858,
 372037661,
 120881,
 -1,
 372072297,
 120899,
 372250162,
 371937979,
 -1,
 -59855,
 372229479,
 121060,
 -1,
 372255062,
 121061,
 372506623,
 372187543,
 -1,
 -59852,
 372416484,
 120890,
 -1,
 372467893,
 120891,
 372643386,
 370564969,
 120843,
 372768767,
 372572160,
 -1,
 372774457,
 372672701,
 120852,
 -1,
 372705842,
 120870,
 -1,
 372736405,
 120844,
 372971070,
 372627533,
 120851,
 373096447,
 372902408,
 -1,
 -59843,
 373014365,
 120868,
 -1,
 373044518,
 120869,
 373233217,
 372944070,
 -1,
 -59840,
 373189330,
 121018,
 -1,
 373235200,
 120841,
 373429827,
 373172566,
 120838,
 -1,
 373360189,
 120861,
 -1,
 373373052,
 120842,
 373626459,
 367447147,
 121077,
 373751807,
 373555200,
 -1,
 373757517,
 373675910,
 -1,
 373823050,
 373737377,
 -1,
 -59831,
 373810847,
 121086,
 -1,
 373842526,
 121088,
 -59829,
 373784484,
 120979,
 -59828,
 373975395,
 120840,
 -1,
 374035283,
 121089,
 374216274,
 373696944,
 -1,
 374281808,
 374172014,
 121083,
 -1,
 374213005,
 120876,
 -59823,
 374257051,
 121085,
 -1,
 374376542,
 121084,
 374543958,
 374194018,
 -1,
 -59820,
 374488054,
 121079,
 -59819,
 374551846,
 121080,
 -1,
 374614358,
 121081,
 374806105,
 374513714,
 -1,
 -59816,
 374788928,
 121087,
 -1,
 374821779,
 121090,
 -59814,
 374758767,
 121078,
 -1,
 374952627,
 121082,
 375133809,
 373590078,
 -1,
 375199337,
 375114865,
 -1,
 375264866,
 375139747,
 -1,
 375330401,
 375221905,
 -1,
 -59808,
 375314461,
 120888,
 -1,
 375349097,
 120889,
 -1,
 375314686,
 120886,
 375592551,
 375202199,
 -1,
 375658086,
 375562201,
 -1,
 -59803,
 375642141,
 120896,
 -1,
 375666474,
 120897,
 -1,
 375613907,
 120898,
 -59800,
 375553941,
 121035,
 -1,
 375873704,
 120880,
 376051307,
 375183389,
 121030,
 -1,
 375982642,
 121033,
 376182382,
 376024262,
 -1,
 -59795,
 376138450,
 121037,
 -1,
 376184320,
 121032,
 -59793,
 376143765,
 121036,
 -59792,
 376324058,
 121028,
 -1,
 376383835,
 120860,
 376575616,
 375095196,
 -1,
 376641144,
 376520666,
 120974,
 376766463,
 376569856,
 -1,
 376772215,
 376682131,
 -1,
 -59786,
 376751463,
 120975,
 -1,
 376781010,
 120976,
 -1,
 376741364,
 120977,
 377034363,
 376620961,
 -1,
 -59782,
 377003699,
 120985,
 -1,
 377053992,
 120986,
 377230973,
 376990038,
 120992,
 -1,
 377162241,
 120988,
 -59778,
 377215005,
 120978,
 -59777,
 377335273,
 120983,
 -1,
 377366870,
 120984,
 377558667,
 376550783,
 -1,
 377624197,
 377522231,
 121012,
 377749503,
 377552896,
 -1,
 -59772,
 377662968,
 121014,
 -1,
 377697574,
 121013,
 -59770,
 377608221,
 121006,
 -59769,
 377867371,
 121016,
 -59768,
 377925097,
 121007,
 -59767,
 377978773,
 121008,
 -59766,
 378038614,
 121015,
 -1,
 378093530,
 121003,
 -59764,
 377511279,
 121092,
 -1,
 378229623,
 120906,
 378470399,
 367294752,
 120922,
 378535935,
 378339328,
 -1,
 378541727,
 378424977,
 -1,
 378607257,
 378499281,
 120908,
 378732543,
 378535936,
 -1,
 378738326,
 378625897,
 120919,
 378863615,
 378667008,
 -1,
 -59755,
 378784902,
 120920,
 -1,
 378835248,
 120921,
 -59753,
 378719352,
 120914,
 -59752,
 378950391,
 120910,
 -1,
 379005270,
 120912,
 379256831,
 378576656,
 120900,
 379322367,
 379125760,
 -1,
 379328157,
 379204902,
 120903,
 -1,
 379259227,
 120904,
 -59746,
 379281257,
 120902,
 -1,
 379398486,
 120901,
 379590309,
 378520386,
 -1,
 379655843,
 379531231,
 120930,
 379781119,
 379587122,
 120931,
 -1,
 379650415,
 120932,
 -59740,
 379617173,
 120933,
 -1,
 379808194,
 120929,
 379983532,
 379542895,
 120924,
 380108799,
 379912192,
 -1,
 380114603,
 379998517,
 120909,
 380239871,
 380043264,
 -1,
 -59734,
 380130039,
 120911,
 -1,
 380184918,
 120913,
 -1,
 380095622,
 120926,
 380442288,
 379964529,
 -1,
 -59730,
 380419933,
 120925,
 -59729,
 380457651,
 120928,
 -1,
 380512598,
 120927,
 -1,
 380381658,
 120923,
 380770029,
 367209891,
 -1,
 380835532,
 380752794,
 -1,
 380901063,
 380805807,
 120941,
 381026303,
 380829696,
 -1,
 381032123,
 380934908,
 120940,
 381157375,
 380960768,
 -1,
 381163194,
 381078641,
 -1,
 -59719,
 381140829,
 120942,
 -1,
 381178547,
 120946,
 -1,
 381129008,
 120944,
 381425344,
 380987734,
 120834,
 381550591,
 381353984,
 -1,
 381556415,
 381471851,
 121068,
 -1,
 381486423,
 121069,
 -1,
 381531547,
 121024,
 381753027,
 381406321,
 -1,
 -59710,
 381730653,
 120943,
 -1,
 381768371,
 120947,
 381949637,
 381702453,
 120915,
 -1,
 381879639,
 120916,
 -59706,
 381915440,
 120945,
 -1,
 382044266,
 121040,
 382271487,
 380876623,
 120949,
 382337023,
 382140416,
 -1,
 -59702,
 382245628,
 120948,
 -59701,
 382306458,
 121039,
 -1,
 382364046,
 121020,
 382539491,
 380792399,
 120950,
 382664703,
 382468096,
 -1,
 382670555,
 382560598,
 120833,
 382795775,
 382599168,
 -1,
 382801624,
 382699575,
 120847,
 382926847,
 382730240,
 -1,
 382932693,
 382809859,
 -1,
 -59692,
 382878795,
 120859,
 -1,
 382927914,
 121002,
 -59690,
 382913643,
 120863,
 -59689,
 383104378,
 120967,
 -1,
 383156117,
 120997,
 -59687,
 382776731,
 121019,
 -59686,
 383278940,
 120845,
 -1,
 383330646,
 120839,
 383522527,
 382634046,
 -1,
 383588062,
 383497627,
 121038,
 -1,
 383517039,
 121045,
 -1,
 383571997,
 121031,
 383784674,
 383483804,
 -1,
 -59679,
 383768605,
 120980,
 -1,
 383805782,
 120993,
 -1,
 383759771,
 121009,
 384106495,
 382499210,
 120934,
 384172031,
 383975424,
 -1,
 384177896,
 384093297,
 -1,
 -59673,
 384155485,
 120935,
 -1,
 384193203,
 120937,
 384374506,
 384141437,
 121046,
 -1,
 384305444,
 121047,
 -59669,
 384340272,
 120936,
 -59668,
 384461219,
 121065,
 -1,
 384521056,
 120905,
 384702245,
 380721675,
 -1,
 384767767,
 384658286,
 120957,
 384892927,
 384696320,
 -1,
 384898815,
 384788822,
 120836,
 385023999,
 384827392,
 -1,
 385029881,
 384945259,
 121072,
 385155071,
 384958464,
 -1,
 385160951,
 385071617,
 -1,
 -59658,
 385123492,
 121073,
 -1,
 385181023,
 121053,
 -59656,
 385129212,
 121070,
 -1,
 385317017,
 121071,
 385488637,
 384993342,
 -1,
 385554172,
 385463674,
 120968,
 -1,
 385483250,
 120973,
 -1,
 385515413,
 120998,
 -59650,
 385463707,
 121025,
 -1,
 385703785,
 121051,
 385881861,
 384867068,
 120955,
 386007039,
 385810432,
 -1,
 386012932,
 385928305,
 -1,
 -59645,
 385990493,
 120959,
 -1,
 386028211,
 120956,
 -1,
 385978672,
 120961,
 386275082,
 385843093,
 120970,
 386400255,
 386203648,
 -1,
 386406153,
 386296150,
 120994,
 -1,
 386337281,
 120989,
 -1,
 386387051,
 120987,
 386602766,
 386255985,
 -1,
 386668301,
 386580317,
 120960,
 -1,
 386599720,
 120963,
 -1,
 386607558,
 120964,
 386864912,
 386577786,
 120999,
 -1,
 386794115,
 121004,
 386995986,
 386828343,
 121029,
 -1,
 386926751,
 121041,
 387127061,
 386944657,
 -1,
 -59628,
 387096348,
 120907,
 -1,
 387150052,
 120917,
 -59626,
 387105034,
 120958,
 -1,
 387289392,
 120962,
 387514367,
 384735833,
 120939,
 387579903,
 387383296,
 -1,
 387585823,
 387483710,
 -1,
 387651358,
 387560871,
 121050,
 387776511,
 387579904,
 -1,
 -59619,
 387686338,
 121048,
 -1,
 387737774,
 121049,
 -1,
 387632235,
 121034,
 387979043,
 387541371,
 -1,
 -59615,
 387962752,
 121023,
 -59614,
 388014018,
 121021,
 -1,
 388065454,
 121022,
 -59612,
 387954156,
 121017,
 -1,
 388184200,
 120938,
 388372286,
 384639370,
 120965,
 388497407,
 388300800,
 -1,
 388503346,
 388393302,
 120837,
 388628479,
 388431872,
 -1,
 388634413,
 388549739,
 121076,
 388759551,
 388562944,
 -1,
 -59604,
 388669378,
 121074,
 -1,
 388720814,
 121075,
 388896559,
 388609435,
 121027,
 -1,
 388826488,
 121026,
 389087231,
 388859966,
 -1,
 -59599,
 389002618,
 120969,
 -1,
 389054357,
 121000,
 389224247,
 388464540,
 -1,
 389289782,
 389179734,
 120995,
 389414911,
 389220895,
 120991,
 -1,
 389285240,
 120990,
 -1,
 389273629,
 120982,
 389551931,
 389187690,
 121044,
 389677055,
 389480448,
 -1,
 -59590,
 389586882,
 121042,
 -1,
 389638318,
 121043,
 389873663,
 389526911,
 -1,
 -59587,
 389775253,
 121011,
 -1,
 389824517,
 121005,
 390070271,
 388341783,
 120951,
 390135807,
 389939200,
 -1,
 390141763,
 390057073,
 -1,
 -59582,
 390119261,
 120952,
 -1,
 390156979,
 120954,
 -59580,
 390116763,
 121010,
 -59579,
 390304048,
 120953,
 -59578,
 390365092,
 120981,
 -59577,
 390424918,
 120835,
 -1,
 390484277,
 120918,
 -1,
 367160883,
 121451,
 390791167,
 367084348,
 121343,
 390856703,
 390660096,
 -1,
 390862677,
 390761158,
 -1,
 390928212,
 390794917,
 -1,
 390993745,
 390914325,
 -1,
 -59569,
 390974805,
 121346,
 -59568,
 391038311,
 121345,
 -1,
 391067845,
 121348,
 391315455,
 390943179,
 -1,
 -59565,
 391234919,
 121347,
 -1,
 391264453,
 121349,
 -1,
 390857188,
 121350,
 -1,
 390837617,
 121344,
 391583888,
 367036916,
 -1,
 391649386,
 391568655,
 -1,
 391714769,
 391635221,
 -1,
 391780220,
 391654819,
 -1,
 391845746,
 391764630,
 -1,
 391911279,
 391774208,
 -1,
 391976805,
 391862795,
 -1,
 392042338,
 391913248,
 -1,
 392107872,
 392001689,
 121230,
 -1,
 392086597,
 121231,
 -59551,
 392085770,
 121228,
 -1,
 392201933,
 121229,
 392429567,
 391999661,
 -1,
 -59548,
 392320050,
 121254,
 -1,
 392376611,
 121261,
 392566634,
 391949281,
 -1,
 392632168,
 392525977,
 121226,
 -1,
 392610885,
 121227,
 -59543,
 392610058,
 121224,
 -1,
 392726221,
 121225,
 392953855,
 392547006,
 -1,
 392959854,
 392868079,
 -1,
 -59539,
 392937738,
 121232,
 -1,
 392988365,
 121233,
 -1,
 392906762,
 121247,
 393281535,
 391854383,
 -1,
 -59535,
 393199882,
 121248,
 -1,
 393250509,
 121249,
 393418615,
 391814406,
 -1,
 -59532,
 393396490,
 121147,
 -59531,
 393459823,
 121150,
 -59530,
 393512653,
 121148,
 -1,
 393574553,
 121149,
 393746299,
 393370973,
 -1,
 -59527,
 393724170,
 121151,
 -59526,
 393774797,
 121152,
 -1,
 393836697,
 121153,
 -1,
 393721885,
 121139,
 394074001,
 391766203,
 -1,
 394139534,
 394012375,
 -1,
 394205063,
 394082507,
 -1,
 394270595,
 394186925,
 -1,
 -59519,
 394248458,
 121244,
 -59518,
 394299085,
 121245,
 -1,
 394360985,
 121246,
 394592255,
 394215028,
 -1,
 -59515,
 394510602,
 121241,
 -59514,
 394561229,
 121242,
 -1,
 394623129,
 121243,
 394794891,
 394148873,
 -1,
 -59511,
 394772746,
 121268,
 -59510,
 394823373,
 121269,
 -1,
 394885273,
 121270,
 395116543,
 394747850,
 -1,
 -59507,
 395007026,
 121257,
 -1,
 395063587,
 121264,
 395313151,
 394114767,
 -1,
 -59504,
 395231274,
 121325,
 -1,
 395263597,
 121326,
 395450266,
 394050049,
 -1,
 395515801,
 395406218,
 -1,
 395581336,
 395494768,
 -1,
 395646870,
 395540633,
 121132,
 -1,
 395625541,
 121133,
 -59497,
 395624714,
 121130,
 -1,
 395740877,
 121131,
 -1,
 395569105,
 121134,
 -1,
 395467403,
 121253,
 396040098,
 395411765,
 -1,
 396105629,
 396017930,
 121237,
 -1,
 396034683,
 121240,
 396236704,
 396058570,
 -1,
 -59489,
 396186674,
 121256,
 -1,
 396243235,
 121263,
 -59487,
 396199629,
 121238,
 -1,
 396392601,
 121239,
 396564395,
 395978591,
 -1,
 396629927,
 396534375,
 -1,
 -59483,
 396607754,
 121154,
 -59482,
 396658381,
 121155,
 -1,
 396720281,
 121156,
 396951551,
 396576856,
 -1,
 -59479,
 396869898,
 121144,
 -59478,
 396920525,
 121145,
 -1,
 396982425,
 121146,
 397154226,
 396518189,
 -1,
 397219759,
 397107146,
 -1,
 -59474,
 397169714,
 121255,
 -1,
 397226275,
 121262,
 -59472,
 397197578,
 121234,
 -59471,
 397379277,
 121235,
 -1,
 397441177,
 121236,
 397612983,
 397136045,
 -1,
 397678517,
 397549526,
 121142,
 -1,
 397610637,
 121143,
 -59466,
 397666257,
 121141,
 -1,
 397788538,
 121140,
 397940668,
 397557364,
 -1,
 398006202,
 397877206,
 121137,
 -1,
 397938317,
 121138,
 -59461,
 397993937,
 121136,
 -1,
 398116199,
 121135,
 398268355,
 397878152,
 -1,
 398333888,
 398246160,
 -1,
 -59457,
 398311466,
 121315,
 -1,
 398343789,
 121317,
 398589951,
 398296788,
 -1,
 -59454,
 398508074,
 121316,
 -1,
 398540397,
 121318,
 398727111,
 398257553,
 -1,
 -59451,
 398704906,
 121157,
 -59450,
 398755533,
 121158,
 -1,
 398817433,
 121159,
 398989259,
 398697713,
 -1,
 -59447,
 398967050,
 121160,
 -59446,
 399017677,
 121161,
 -1,
 399079577,
 121162,
 399251408,
 398938276,
 -1,
 399316943,
 399208114,
 -1,
 -59442,
 399294506,
 121329,
 -1,
 399326829,
 121330,
 -1,
 399284768,
 121128,
 -1,
 399209045,
 121448,
 399644745,
 391664075,
 -1,
 399710182,
 399584675,
 -1,
 399775712,
 399694491,
 -1,
 399841243,
 399728586,
 -1,
 399906776,
 399790532,
 -1,
 -59433,
 399884554,
 121286,
 -1,
 399931545,
 121287,
 400162815,
 399847378,
 -1,
 -59430,
 400081162,
 121271,
 -1,
 400128153,
 121272,
 400299997,
 399800473,
 121303,
 -1,
 400278597,
 121304,
 -59426,
 400277770,
 121301,
 -59425,
 400393933,
 121302,
 -1,
 400438380,
 121305,
 400627684,
 399744262,
 -1,
 -59422,
 400605450,
 121204,
 -59421,
 400656077,
 121205,
 -1,
 400717977,
 121206,
 -59419,
 400603165,
 121198,
 -1,
 400842072,
 121207,
 401020918,
 399696059,
 -1,
 401086451,
 400959191,
 -1,
 401151983,
 401039306,
 -1,
 401217516,
 401101252,
 -1,
 -59413,
 401195274,
 121296,
 -1,
 401242265,
 121297,
 401473535,
 401158098,
 -1,
 -59410,
 401391882,
 121281,
 -1,
 401438873,
 121282,
 401610738,
 401127937,
 -1,
 -59407,
 401575100,
 121308,
 -1,
 401638564,
 121309,
 -1,
 401569945,
 121310,
 401932287,
 401061602,
 -1,
 -59403,
 401850410,
 121327,
 -1,
 401882733,
 121328,
 402069511,
 400982325,
 -1,
 402135046,
 402022346,
 -1,
 402200575,
 402084292,
 -1,
 402266108,
 402178320,
 -1,
 -59397,
 402243626,
 121292,
 -1,
 402275949,
 121294,
 402522111,
 402225311,
 -1,
 -59394,
 402440234,
 121293,
 -1,
 402472557,
 121295,
 402718719,
 402141138,
 -1,
 402724867,
 402637072,
 -1,
 -59390,
 402702378,
 121277,
 -1,
 402734701,
 121279,
 402980863,
 402684063,
 -1,
 -59387,
 402898986,
 121278,
 -1,
 402931309,
 121280,
 -1,
 402112778,
 121307,
 403183639,
 402023213,
 -1,
 403249174,
 403136458,
 -1,
 403314703,
 403198404,
 -1,
 403380237,
 403296429,
 -1,
 -59380,
 403358195,
 121290,
 -1,
 403405032,
 121291,
 -59378,
 403358081,
 121288,
 -1,
 403536038,
 121289,
 403767295,
 403255250,
 -1,
 403773459,
 403685648,
 -1,
 -59374,
 403755174,
 121275,
 -1,
 403783277,
 121273,
 404029439,
 403732639,
 -1,
 -59371,
 403951782,
 121276,
 -1,
 403979885,
 121274,
 -1,
 403226890,
 121306,
 404232224,
 403159553,
 -1,
 404297759,
 404188042,
 -1,
 404363294,
 404276592,
 -1,
 404428828,
 404322457,
 121191,
 -1,
 404407365,
 121192,
 -59363,
 404406538,
 121189,
 -1,
 404522701,
 121190,
 -1,
 404350929,
 121193,
 -1,
 404249234,
 121314,
 404822058,
 404169620,
 -1,
 404887588,
 404799760,
 -1,
 -59357,
 404865066,
 121319,
 -1,
 404897389,
 121322,
 405084199,
 404850388,
 -1,
 -59354,
 405061674,
 121320,
 -1,
 405093997,
 121323,
 405340159,
 405043359,
 -1,
 -59351,
 405258282,
 121321,
 -1,
 405290605,
 121324,
 405477424,
 404803757,
 -1,
 405542958,
 405413858,
 -1,
 -59347,
 405530577,
 121202,
 -1,
 405572294,
 121201,
 -59345,
 405530577,
 121200,
 -1,
 405718394,
 121199,
 405870645,
 405421684,
 -1,
 405936179,
 405807062,
 121196,
 -1,
 405868173,
 121197,
 -59340,
 405923793,
 121195,
 -1,
 406046055,
 121194,
 406198331,
 405808991,
 -1,
 406263866,
 406168167,
 -1,
 -59336,
 406241546,
 121208,
 -59335,
 406292173,
 121209,
 -1,
 406354073,
 121210,
 -1,
 406210644,
 121203,
 406591551,
 406187409,
 -1,
 -59331,
 406569226,
 121211,
 -59330,
 406619853,
 121212,
 -1,
 406681753,
 121213,
 406853699,
 406562033,
 -1,
 -59327,
 406831370,
 121214,
 -59326,
 406881997,
 121215,
 -1,
 406943897,
 121216,
 407115848,
 406802596,
 -1,
 407181383,
 407072442,
 -1,
 -59322,
 407158826,
 121331,
 -1,
 407191149,
 121332,
 -1,
 407149088,
 121129,
 -1,
 407073365,
 121449,
 407509087,
 399588351,
 -1,
 407574613,
 407447984,
 -1,
 407640144,
 407555914,
 -1,
 407705678,
 407599257,
 121187,
 -1,
 407684165,
 121188,
 -59313,
 407683338,
 121185,
 -1,
 407799501,
 121186,
 408027135,
 407578368,
 -1,
 408033363,
 407926937,
 121183,
 -1,
 408011845,
 121184,
 -59308,
 408011018,
 121181,
 -1,
 408127181,
 121182,
 408295514,
 407555914,
 -1,
 408361048,
 408254617,
 121179,
 -1,
 408339525,
 121180,
 -59303,
 408338698,
 121177,
 -1,
 408454861,
 121178,
 408682495,
 408233728,
 -1,
 408688733,
 408582297,
 121175,
 -1,
 408667205,
 121176,
 -59298,
 408666378,
 121173,
 -1,
 408782541,
 121174,
 409010175,
 407461730,
 -1,
 409016424,
 408934432,
 -1,
 409081959,
 408960991,
 -1,
 409147493,
 409018338,
 -1,
 -59292,
 409125130,
 121126,
 -1,
 409172121,
 121125,
 -59290,
 409125130,
 121122,
 -1,
 409303193,
 121121,
 -1,
 409058551,
 121123,
 -59287,
 408993640,
 121127,
 -1,
 409485380,
 121124,
 409731071,
 391633732,
 -1,
 409737335,
 409639681,
 -1,
 409802864,
 409710684,
 121418,
 409927679,
 409731072,
 -1,
 -59281,
 409856544,
 121420,
 -1,
 409921470,
 121419,
 410065012,
 409772055,
 121415,
 410189823,
 409993216,
 -1,
 -59277,
 410118688,
 121417,
 -1,
 410183614,
 121416,
 -59275,
 410052542,
 121414,
 -59274,
 410276531,
 121413,
 -1,
 410333682,
 121412,
 410523773,
 409677219,
 -1,
 410589308,
 410485055,
 -1,
 -59270,
 410554134,
 121403,
 -59269,
 410604211,
 121404,
 -1,
 410662332,
 121405,
 -1,
 410557709,
 121430,
 410916993,
 410503727,
 121424,
 411041791,
 410845184,
 -1,
 -59264,
 410961602,
 121426,
 -1,
 410997427,
 121425,
 411179141,
 410894894,
 121406,
 411303935,
 411107328,
 -1,
 -59260,
 411232190,
 121407,
 -1,
 411278076,
 121408,
 411441289,
 411137507,
 121421,
 411566079,
 411369472,
 -1,
 -59256,
 411494334,
 121423,
 -1,
 411521715,
 121422,
 411703437,
 411391037,
 121409,
 411828223,
 411631616,
 -1,
 -59252,
 411756478,
 121410,
 -1,
 411802364,
 121411,
 412024831,
 411690951,
 -1,
 -59249,
 411942954,
 121431,
 -1,
 411975277,
 121432,
 412162255,
 391563169,
 -1,
 412227756,
 412135161,
 -1,
 412293281,
 412213525,
 -1,
 412358812,
 412268664,
 -1,
 412424344,
 412344597,
 -1,
 -59242,
 412401706,
 121163,
 -59241,
 412434029,
 121164,
 -1,
 412491734,
 121165,
 412745727,
 412373451,
 -1,
 -59238,
 412663850,
 121166,
 -59237,
 412696173,
 121167,
 -1,
 412753878,
 121168,
 412948640,
 412296119,
 -1,
 -59234,
 412930214,
 121172,
 -59233,
 412991530,
 121170,
 -1,
 413023853,
 121171,
 -1,
 412925385,
 121169,
 413335551,
 412242379,
 -1,
 413341867,
 413251704,
 -1,
 413407399,
 413327637,
 -1,
 -59227,
 413384746,
 121220,
 -59226,
 413417069,
 121221,
 -1,
 413474774,
 121222,
 413728767,
 413356491,
 -1,
 -59223,
 413646890,
 121217,
 -59222,
 413679213,
 121218,
 -1,
 413736918,
 121219,
 -1,
 413318601,
 121223,
 413997249,
 412193815,
 -1,
 414062776,
 413962221,
 -1,
 414128305,
 414043640,
 -1,
 -59216,
 414109488,
 121436,
 -1,
 414132665,
 121435,
 414324916,
 414068710,
 -1,
 -59213,
 414303486,
 121439,
 -1,
 414346338,
 121440,
 -59211,
 414303499,
 121433,
 -59210,
 414485199,
 121438,
 -59209,
 414547484,
 121434,
 -1,
 414608495,
 121437,
 414783676,
 414045609,
 -1,
 -59206,
 414761002,
 121093,
 -59205,
 414813065,
 121094,
 -1,
 414853544,
 121095,
 415105023,
 414759174,
 -1,
 415111360,
 415031573,
 -1,
 -59201,
 415090060,
 121458,
 -1,
 415119577,
 121459,
 -1,
 415060456,
 121460,
 415432703,
 413942270,
 -1,
 415439051,
 415320988,
 121441,
 415563775,
 415367168,
 -1,
 415570121,
 415471549,
 -1,
 415635655,
 415551154,
 121443,
 -1,
 415564993,
 121444,
 415825919,
 415596386,
 121445,
 -1,
 415696065,
 121446,
 -59190,
 415533766,
 121442,
 -1,
 415836870,
 121447,
 416088063,
 415404615,
 -1,
 -59187,
 415991863,
 121390,
 -59186,
 416055701,
 121391,
 -1,
 416112317,
 121389,
 416291074,
 412134598,
 -1,
 416356606,
 416259559,
 -1,
 416422125,
 416288421,
 -1,
 416487648,
 416407829,
 -1,
 416553175,
 416464938,
 121250,
 416677887,
 416482116,
 -1,
 -59178,
 416568370,
 121258,
 -1,
 416624931,
 121265,
 416815323,
 416497261,
 121251,
 416940031,
 416744260,
 -1,
 -59174,
 416830514,
 121259,
 -1,
 416887075,
 121266,
 417136639,
 416751516,
 -1,
 417143007,
 417032884,
 -1,
 -59170,
 417092658,
 121260,
 -1,
 417149219,
 121267,
 -1,
 417087998,
 121252,
 417464319,
 416436683,
 -1,
 417470693,
 417382442,
 121311,
 417595391,
 417399620,
 -1,
 -59164,
 417485246,
 121298,
 -1,
 417542090,
 121283,
 417732841,
 417414765,
 121312,
 417857535,
 417661764,
 -1,
 -59160,
 417747390,
 121299,
 -1,
 417804234,
 121284,
 418054143,
 417669078,
 121313,
 418119679,
 417923908,
 -1,
 -59156,
 418009534,
 121300,
 -1,
 418066378,
 121285,
 418316287,
 416351414,
 -1,
 418322678,
 418189628,
 -1,
 -59152,
 418256499,
 121519,
 -59151,
 418321790,
 121518,
 -59150,
 418387114,
 121517,
 -59149,
 418452364,
 121516,
 -59148,
 418517607,
 121515,
 -59147,
 418582844,
 121514,
 -1,
 418648108,
 121513,
 -59145,
 418257108,
 121512,
 -59144,
 418781219,
 121511,
 -59143,
 418846531,
 121510,
 -59142,
 418911859,
 121509,
 -59141,
 418977150,
 121508,
 -59140,
 419042474,
 121507,
 -59139,
 419107724,
 121506,
 -1,
 419172967,
 121505,
 419430399,
 416339098,
 -1,
 -59136,
 419348522,
 121105,
 -59135,
 419400585,
 121106,
 -1,
 419441064,
 121107,
 419633452,
 416236030,
 -1,
 419698986,
 419621417,
 -1,
 419764499,
 419649053,
 -1,
 419830029,
 419750165,
 -1,
 419895562,
 419808615,
 121377,
 420020223,
 419823616,
 -1,
 -59127,
 419905133,
 121378,
 -1,
 419962838,
 121379,
 420216831,
 419835299,
 -1,
 -59124,
 420141729,
 121383,
 -1,
 420179663,
 121385,
 420413439,
 419779019,
 -1,
 420419858,
 420332903,
 121380,
 420544511,
 420347904,
 -1,
 -59119,
 420429421,
 121381,
 -1,
 420487126,
 121382,
 -1,
 420362450,
 121384,
 420747549,
 419740163,
 -1,
 420813079,
 420733933,
 -1,
 -59114,
 420778136,
 121372,
 -1,
 420808023,
 121370,
 421009690,
 420764350,
 -1,
 -59111,
 420977404,
 121369,
 -1,
 421016471,
 121371,
 -59109,
 420987806,
 121365,
 -59108,
 421174012,
 121364,
 -1,
 421213079,
 121366,
 421402913,
 420706563,
 -1,
 -59105,
 421386269,
 121374,
 -59104,
 421417498,
 121376,
 -1,
 421478362,
 121375,
 421665061,
 421342414,
 -1,
 -59101,
 421648413,
 121354,
 -59100,
 421695254,
 121355,
 -1,
 421740506,
 121356,
 421986303,
 421593088,
 -1,
 421992745,
 421866347,
 -1,
 -59096,
 421969962,
 121367,
 -1,
 422022025,
 121368,
 -1,
 421979178,
 121373,
 -59093,
 419686483,
 121452,
 -1,
 422192226,
 121392,
 422385993,
 419591951,
 -1,
 422451517,
 422339501,
 -1,
 422517048,
 422413852,
 -1,
 422582583,
 422477073,
 -1,
 -59087,
 422516547,
 121469,
 -59086,
 422581875,
 121468,
 -59085,
 422647166,
 121467,
 -59084,
 422712490,
 121466,
 -59083,
 422777740,
 121465,
 -59082,
 422842983,
 121464,
 -1,
 422908220,
 121463,
 -1,
 422524000,
 121462,
 423231487,
 422486703,
 -1,
 423237948,
 423100416,
 -1,
 -59077,
 423221552,
 121429,
 -1,
 423264841,
 121428,
 -1,
 423213695,
 121427,
 423559167,
 422417607,
 -1,
 423565638,
 423428096,
 -1,
 423631170,
 423517338,
 -1,
 -59071,
 423585485,
 121473,
 -1,
 423631846,
 121476,
 -59069,
 423617522,
 121474,
 -59068,
 423808777,
 121477,
 -59067,
 423853815,
 121478,
 -1,
 423902018,
 121475,
 424148991,
 423497381,
 -1,
 -59064,
 424075580,
 121471,
 -1,
 424104407,
 121472,
 424286566,
 422334097,
 -1,
 424352085,
 424245007,
 -1,
 424417620,
 424305926,
 -1,
 424483153,
 424393217,
 -1,
 424548688,
 424445097,
 -1,
 -59057,
 424525866,
 121116,
 -1,
 424577929,
 121118,
 -1,
 424495579,
 121119,
 424869887,
 424442015,
 -1,
 -59053,
 424788010,
 121115,
 -1,
 424840073,
 121117,
 -1,
 424385178,
 121456,
 425072989,
 424305581,
 -1,
 425138524,
 425033683,
 -1,
 -59048,
 425072243,
 121503,
 -59047,
 425137534,
 121502,
 -59046,
 425202858,
 121501,
 -59045,
 425268108,
 121500,
 -1,
 425333351,
 121499,
 -1,
 425103278,
 121470,
 425597281,
 425041030,
 -1,
 -59041,
 425584574,
 121363,
 -59040,
 425627414,
 121361,
 -1,
 425670076,
 121362,
 425859429,
 425532218,
 -1,
 425924964,
 425842793,
 121352,
 -1,
 425855566,
 121353,
 -1,
 425874122,
 121351,
 -1,
 425842325,
 121480,
 426187134,
 424262145,
 -1,
 426252657,
 426159182,
 -1,
 426318189,
 426228225,
 -1,
 426383724,
 426280105,
 -1,
 -59029,
 426360874,
 121111,
 -1,
 426412937,
 121113,
 -1,
 426330587,
 121114,
 426645872,
 426277023,
 -1,
 -59025,
 426623018,
 121110,
 -1,
 426675081,
 121112,
 -1,
 426594726,
 121120,
 426908021,
 426234003,
 -1,
 -59021,
 426885162,
 121099,
 -59020,
 426937225,
 121100,
 -1,
 426977704,
 121101,
 427170170,
 426860956,
 -1,
 427235705,
 427122562,
 -1,
 -59016,
 427213592,
 121453,
 -1,
 427272395,
 121454,
 -1,
 427216218,
 121457,
 427497853,
 427153921,
 -1,
 -59012,
 427476877,
 121108,
 -1,
 427501992,
 121109,
 -1,
 427444128,
 121481,
 427760018,
 426129677,
 -1,
 427825548,
 427748233,
 -1,
 427891076,
 427801089,
 -1,
 427956611,
 427845794,
 121339,
 -1,
 427884593,
 121340,
 -1,
 427917717,
 121336,
 428153223,
 427828282,
 -1,
 -59002,
 428130570,
 121333,
 -1,
 428177561,
 121334,
 -59000,
 428132911,
 121337,
 -58999,
 428323111,
 121338,
 -58998,
 428366030,
 121342,
 -58997,
 428429104,
 121335,
 -1,
 428494160,
 121341,
 428736511,
 427798473,
 -1,
 428743056,
 428642078,
 -1,
 -58993,
 428726301,
 121360,
 -1,
 428752858,
 121357,
 -58991,
 428726366,
 121359,
 -1,
 428884003,
 121358,
 429070746,
 427723820,
 -1,
 429136281,
 429038958,
 -1,
 429201815,
 429121723,
 -1,
 -58986,
 429176343,
 121395,
 -1,
 429221570,
 121396,
 -58984,
 429166358,
 121393,
 -1,
 429340092,
 121394,
 -1,
 429081652,
 121450,
 429595042,
 429010339,
 -1,
 429660575,
 429546856,
 -1,
 -58979,
 429639362,
 121388,
 -58978,
 429697593,
 121386,
 -1,
 429756182,
 121387,
 429981695,
 429626391,
 -1,
 -58975,
 429885890,
 121479,
 -1,
 429949114,
 121482,
 430119338,
 429534322,
 -1,
 430184871,
 430103260,
 -1,
 -58971,
 430161962,
 121102,
 -58970,
 430214025,
 121103,
 -1,
 430254504,
 121104,
 430505983,
 430130153,
 -1,
 -58967,
 430402471,
 121401,
 -1,
 430460340,
 121402,
 430643633,
 430054866,
 -1,
 430709166,
 430622397,
 -1,
 -58963,
 430664385,
 121398,
 -1,
 430704960,
 121400,
 430964735,
 430648178,
 -1,
 -58960,
 430861064,
 121397,
 -1,
 430901568,
 121399,
 431102389,
 430594328,
 -1,
 -58957,
 431079466,
 121096,
 -58956,
 431131529,
 121097,
 -1,
 431172008,
 121098,
 -58954,
 431087904,
 121455,
 -58953,
 431347981,
 121461,
 -1,
 431400020,
 121483,
 -1,
 366937408,
 129304,
 431626817,
 366885133,
 -1,
 431692342,
 431569849,
 -1,
 431757822,
 431652182,
 -1,
 431823302,
 431736737,
 -1,
 431888831,
 431810268,
 71129,
 -1,
 431842221,
 71130,
 432019906,
 431867809,
 -1,
 -58943,
 431970845,
 71065,
 -1,
 432019846,
 71064,
 432216517,
 431970827,
 -1,
 -58940,
 432189630,
 71128,
 -1,
 432216454,
 71070,
 -1,
 432150918,
 71069,
 432478669,
 431807408,
 -1,
 432544204,
 432444589,
 -1,
 432609738,
 432516294,
 71046,
 -1,
 432581830,
 71047,
 432799743,
 432568079,
 71048,
 -1,
 432699151,
 71049,
 -1,
 432478598,
 71082,
 432937426,
 432413062,
 71040,
 -58929,
 432919450,
 71053,
 -58928,
 432964306,
 71131,
 -58927,
 433021869,
 71051,
 -1,
 433068422,
 71041,
 433265111,
 432901164,
 -1,
 -58924,
 433252767,
 71063,
 -58923,
 433294454,
 71068,
 -58922,
 433345815,
 71058,
 -1,
 433396102,
 71073,
 433592797,
 433207565,
 -1,
 433658331,
 433535245,
 -1,
 -58918,
 433609245,
 71067,
 -1,
 433658246,
 71066,
 -58916,
 433609245,
 71072,
 -1,
 433789318,
 71071,
 433986017,
 433568257,
 -1,
 -58913,
 433961686,
 71084,
 -58912,
 434002461,
 71083,
 -1,
 434051462,
 71085,
 434248163,
 433968026,
 71044,
 -1,
 434230170,
 71045,
 434379238,
 434217647,
 -1,
 -58907,
 434330141,
 71075,
 -1,
 434379142,
 71074,
 434575849,
 434336569,
 -1,
 -58904,
 434526749,
 71055,
 -1,
 434575750,
 71054,
 434772460,
 434532877,
 -1,
 -58901,
 434723357,
 71062,
 -1,
 434772358,
 71061,
 434969070,
 434725805,
 71042,
 -1,
 434922413,
 71043,
 435100145,
 434918600,
 -1,
 -58896,
 435051037,
 71057,
 -1,
 435100038,
 71056,
 435296756,
 435039651,
 -1,
 -58893,
 435247645,
 71060,
 -1,
 435296646,
 71059,
 435493367,
 435234655,
 -1,
 -58890,
 435444253,
 71077,
 -1,
 435493254,
 71076,
 -58888,
 435480991,
 71079,
 -58887,
 435662144,
 71080,
 -58886,
 435721239,
 71052,
 -58885,
 435782601,
 71078,
 -58884,
 435844953,
 71081,
 -58883,
 435903005,
 71086,
 -1,
 435962366,
 71050,
 436148767,
 431733249,
 -1,
 436214295,
 436093438,
 -1,
 436279828,
 436156428,
 -1,
 436345362,
 436266060,
 -1,
 436410887,
 436326362,
 -1,
 436476422,
 436353789,
 -1,
 -58875,
 436458508,
 71114,
 -1,
 436485658,
 71115,
 -1,
 436446947,
 71122,
 436738571,
 436383503,
 -1,
 -58871,
 436719797,
 71118,
 -58870,
 436748046,
 71117,
 -1,
 436811467,
 71116,
 437000719,
 436679293,
 -1,
 -58867,
 436982577,
 71126,
 -58866,
 437038852,
 71125,
 -1,
 437080899,
 71127,
 -58864,
 436976848,
 71124,
 -58863,
 437234584,
 71123,
 -1,
 437272334,
 71121,
 437518335,
 436289412,
 71119,
 -1,
 437390830,
 71120,
 437649407,
 436249644,
 -1,
 -58858,
 437534035,
 71108,
 -1,
 437594164,
 71109,
 437846015,
 436168569,
 -1,
 437852699,
 437771965,
 -1,
 -58854,
 437828529,
 71102,
 -1,
 437890649,
 71103,
 -58852,
 437829461,
 71105,
 -58851,
 438014787,
 71104,
 -58850,
 438054519,
 71100,
 -1,
 438116901,
 71101,
 438311470,
 436133942,
 -1,
 438376998,
 438245766,
 -1,
 438442531,
 438338258,
 71132,
 -1,
 438424474,
 71133,
 -58844,
 438424474,
 71099,
 -58843,
 438526893,
 71097,
 -1,
 438573446,
 71087,
 438770216,
 438361968,
 71092,
 -1,
 438742214,
 71093,
 438901290,
 438752154,
 71090,
 -1,
 438883226,
 71091,
 439032364,
 438854573,
 71088,
 -1,
 438985645,
 71089,
 -58835,
 438998039,
 71098,
 -1,
 439108094,
 71096,
 439294514,
 438284649,
 -1,
 -58832,
 439227276,
 71112,
 -58831,
 439292519,
 71111,
 -1,
 439357756,
 71110,
 439556661,
 439236877,
 -1,
 -58828,
 439524998,
 71107,
 -1,
 439558430,
 71106,
 -1,
 439502956,
 71113,
 439877631,
 431639908,
 -1,
 439884348,
 439804655,
 -1,
 -58823,
 439867535,
 128414,
 -58822,
 439923681,
 128409,
 -58821,
 439974743,
 128408,
 -1,
 440025136,
 128415,
 440270847,
 439823072,
 -1,
 -58818,
 440195215,
 128416,
 -58817,
 440251361,
 128411,
 -58816,
 440302423,
 128410,
 -1,
 440352816,
 128417,
 440539774,
 431590444,
 -1,
 440605300,
 440490667,
 -1,
 440670817,
 440541930,
 -1,
 440736340,
 440636237,
 -1,
 440801865,
 440715169,
 -1,
 -58809,
 440787545,
 70123,
 -58808,
 440819614,
 70124,
 -1,
 440879047,
 70122,
 441064012,
 440777217,
 -1,
 -58805,
 441020856,
 70127,
 -1,
 441076959,
 70128,
 441260623,
 441030745,
 -1,
 -58802,
 441240480,
 70132,
 -1,
 441279283,
 70131,
 441457234,
 441208465,
 -1,
 -58799,
 441425233,
 70125,
 -1,
 441476625,
 70126,
 -58797,
 441421944,
 70130,
 -1,
 441599705,
 70129,
 441843711,
 440679523,
 -1,
 441850456,
 441763745,
 -1,
 -58793,
 441837078,
 70114,
 -1,
 441868768,
 70115,
 442047067,
 441825793,
 -1,
 -58790,
 442003824,
 70118,
 -1,
 442059925,
 70119,
 442243678,
 441994897,
 -1,
 -58787,
 442212093,
 70116,
 -1,
 442265790,
 70117,
 -58785,
 442210389,
 70113,
 -58784,
 442404936,
 70121,
 -1,
 442451590,
 70120,
 442636911,
 440631177,
 -1,
 442702437,
 442615713,
 -1,
 -58780,
 442689046,
 3560,
 -1,
 442720736,
 3561,
 442899048,
 442677761,
 -1,
 -58777,
 442855792,
 3564,
 -1,
 442911893,
 3565,
 443095659,
 442846865,
 -1,
 -58774,
 443064061,
 3562,
 -1,
 443117758,
 3563,
 -58772,
 443084059,
 3558,
 -58771,
 443258965,
 3559,
 -58770,
 443322440,
 3567,
 -1,
 443369094,
 3566,
 443613183,
 442578264,
 -1,
 443619955,
 443526342,
 -1,
 -58766,
 443566482,
 983935,
 -1,
 443620985,
 983934,
 -1,
 443607568,
 983933,
 443940863,
 440555636,
 -1,
 443947643,
 443809792,
 -1,
 444013177,
 443924119,
 -1,
 -58760,
 443999766,
 983154,
 -1,
 444031456,
 983157,
 -58758,
 443963643,
 983182,
 -1,
 444149910,
 983184,
 444399615,
 443879407,
 -1,
 -58755,
 444273548,
 983158,
 -1,
 444338791,
 983155,
 444537473,
 440526879,
 -1,
 -58752,
 444515484,
 128303,
 -1,
 444573342,
 128973,
 -1,
 444497409,
 128510,
 444799865,
 366842903,
 983077,
 444865266,
 444787630,
 -1,
 444930748,
 444824918,
 -1,
 444996238,
 444909473,
 -1,
 445061769,
 444975009,
 -1,
 -58744,
 445012509,
 72295,
 -1,
 445061510,
 72294,
 445258380,
 445037057,
 -1,
 -58741,
 445209117,
 72310,
 -1,
 445258118,
 72309,
 -58739,
 445209117,
 72300,
 -1,
 445389190,
 72299,
 445586069,
 444938509,
 -1,
 445651602,
 445528333,
 -1,
 -58735,
 445602333,
 72297,
 -1,
 445651334,
 72296,
 -58733,
 445639774,
 72311,
 -58732,
 445798941,
 72302,
 -1,
 445847942,
 72301,
 446044826,
 445549612,
 -1,
 -58729,
 446032287,
 72293,
 -58728,
 446073974,
 72298,
 -58727,
 446125335,
 72288,
 -1,
 446175622,
 72303,
 446372510,
 446020097,
 -1,
 -58724,
 446347990,
 72320,
 -58723,
 446388765,
 72319,
 -1,
 446437766,
 72321,
 446634658,
 446329657,
 -1,
 -58720,
 446612418,
 72323,
 -58719,
 446650909,
 72285,
 -1,
 446699910,
 72284,
 446896805,
 446622768,
 -1,
 -58716,
 446847517,
 72312,
 -1,
 446896518,
 72313,
 447093416,
 446866095,
 -1,
 -58713,
 447044125,
 72305,
 -1,
 447093126,
 72304,
 447290027,
 447050253,
 -1,
 -58710,
 447240733,
 72292,
 -1,
 447289734,
 72291,
 447486638,
 447239368,
 -1,
 -58707,
 447437341,
 72287,
 -1,
 447486342,
 72286,
 447683249,
 447425955,
 -1,
 -58704,
 447633949,
 72290,
 -1,
 447682950,
 72289,
 447879860,
 447620959,
 -1,
 -58701,
 447830557,
 72307,
 -1,
 447879558,
 72306,
 -58699,
 447867295,
 72315,
 -58698,
 448060355,
 72318,
 -58697,
 448113984,
 72316,
 -58696,
 448168905,
 72308,
 -58695,
 448231257,
 72317,
 -58694,
 448289309,
 72322,
 -58693,
 448338310,
 72272,
 -1,
 448401069,
 72314,
 448600777,
 444878939,
 -1,
 448666303,
 448576001,
 72340,
 -1,
 448616971,
 72339,
 448797377,
 448629804,
 72334,
 -1,
 448746696,
 72332,
 -58686,
 448769222,
 72337,
 -58685,
 448889715,
 72336,
 -58684,
 448952079,
 72338,
 -58683,
 449016633,
 72331,
 -58682,
 449074376,
 72330,
 -58681,
 449132813,
 72333,
 -58680,
 449193823,
 72335,
 -1,
 449253037,
 72341,
 449452760,
 448585716,
 -1,
 449518295,
 449429433,
 -1,
 449583822,
 449503069,
 -1,
 -58675,
 449555654,
 72281,
 -1,
 449607439,
 72282,
 449780432,
 449565594,
 72275,
 -1,
 449724926,
 72274,
 449911506,
 449745943,
 72277,
 -1,
 449855998,
 72278,
 450042581,
 449845638,
 -1,
 -58668,
 450024346,
 72280,
 -1,
 450061229,
 72279,
 -58666,
 449995693,
 72273,
 -1,
 450183678,
 72276,
 -1,
 449477893,
 72283,
 450435807,
 449427969,
 -1,
 450501342,
 450389881,
 -1,
 -58661,
 450486048,
 72343,
 -58660,
 450549982,
 72325,
 -58659,
 450589358,
 72324,
 -1,
 450634277,
 72342,
 -1,
 450483413,
 72345,
 450894564,
 450397560,
 -1,
 -58655,
 450875702,
 72346,
 -58654,
 450936249,
 72347,
 -58653,
 450996138,
 72349,
 -1,
 451035024,
 72348,
 451222250,
 450835477,
 -1,
 451287784,
 451197441,
 -1,
 -58649,
 451238429,
 72328,
 -1,
 451287430,
 72329,
 -58647,
 451259712,
 72326,
 -1,
 451442521,
 72327,
 451615470,
 451173562,
 72352,
 451739647,
 451543106,
 -1,
 -58643,
 451662053,
 72350,
 -1,
 451694974,
 72351,
 451877617,
 451594851,
 -1,
 -58640,
 451809895,
 72354,
 -1,
 451875132,
 72353,
 -1,
 451827379,
 72344,
 452139819,
 444814945,
 -1,
 452205325,
 452099414,
 -1,
 452270841,
 452180481,
 -1,
 452336376,
 452204934,
 -1,
 -58633,
 452298594,
 69436,
 -1,
 452344767,
 69439,
 -1,
 452288330,
 69441,
 452598524,
 452228879,
 -1,
 -58629,
 452545348,
 69444,
 -1,
 452599833,
 69433,
 452795134,
 452549786,
 69427,
 -1,
 452774590,
 69430,
 452926209,
 452729222,
 -1,
 -58624,
 452913890,
 69437,
 -1,
 452951327,
 69424,
 -58622,
 452914414,
 69429,
 -58621,
 453110697,
 69431,
 -58620,
 453173729,
 69428,
 -58619,
 453232981,
 69442,
 -58618,
 453292469,
 69440,
 -58617,
 453354703,
 69438,
 -58616,
 453415817,
 69435,
 -58615,
 453478267,
 69434,
 -58614,
 453538823,
 69432,
 -58613,
 453597210,
 69426,
 -58612,
 453660559,
 69443,
 -1,
 453716387,
 69425,
 453909277,
 452146293,
 -1,
 453974801,
 453890765,
 -1,
 -58608,
 453912906,
 69447,
 -1,
 453974750,
 69449,
 454171412,
 453927040,
 -1,
 -58605,
 454109514,
 69453,
 -1,
 454171358,
 69452,
 454368023,
 454114647,
 -1,
 -58602,
 454306122,
 69446,
 -1,
 454367966,
 69448,
 454564634,
 454310091,
 -1,
 -58599,
 454502730,
 69451,
 -1,
 454564574,
 69450,
 -58597,
 454542864,
 69456,
 -58596,
 454734250,
 69455,
 -1,
 454787308,
 69454,
 454957860,
 453880405,
 -1,
 455023394,
 454939327,
 -1,
 455088929,
 455007700,
 69461,
 -1,
 455019586,
 69462,
 -1,
 455029386,
 69464,
 -58589,
 454974166,
 69465,
 -1,
 455225882,
 69463,
 455416618,
 454923085,
 -1,
 455482152,
 455395233,
 -1,
 -58585,
 455467609,
 69459,
 -1,
 455493575,
 69458,
 455737343,
 455448661,
 69457,
 -1,
 455607128,
 69460,
 -1,
 455371015,
 69445,
 455875415,
 452111695,
 -1,
 455940937,
 455834966,
 -1,
 456006449,
 455904300,
 -1,
 -58577,
 455993774,
 69857,
 -58576,
 456021369,
 69847,
 -1,
 456072543,
 69849,
 456268596,
 455967689,
 -1,
 -58573,
 456219147,
 69846,
 -1,
 456278526,
 69864,
 456465207,
 456212990,
 -1,
 -58570,
 456415755,
 69863,
 -1,
 456476211,
 69859,
 -58568,
 456452526,
 69852,
 -58567,
 456645582,
 69850,
 -58566,
 456709674,
 69861,
 -58565,
 456771714,
 69841,
 -58564,
 456833791,
 69840,
 -58563,
 456895920,
 69853,
 -58562,
 456958801,
 69851,
 -58561,
 457020920,
 69862,
 -58560,
 457078810,
 69848,
 -58559,
 457143247,
 69855,
 -58558,
 457208375,
 69856,
 -58557,
 457271241,
 69860,
 -58556,
 457333332,
 69854,
 -58555,
 457397625,
 69845,
 -58554,
 457456084,
 69844,
 -58553,
 457518597,
 69843,
 -58552,
 457582550,
 69842,
 -1,
 457645407,
 69858,
 457900031,
 455883875,
 -1,
 457907021,
 457820065,
 -1,
 -58548,
 457893398,
 69874,
 -1,
 457925088,
 69875,
 458103632,
 457882113,
 -1,
 -58545,
 458060144,
 69878,
 -1,
 458116245,
 69879,
 458300243,
 458051217,
 -1,
 -58542,
 458268413,
 69876,
 -1,
 458322110,
 69877,
 -58540,
 458288411,
 69872,
 -58539,
 458463317,
 69873,
 -58538,
 458526792,
 69881,
 -1,
 458573446,
 69880,
 458759020,
 455859012,
 -1,
 458824546,
 458744446,
 -1,
 458890077,
 458794996,
 -1,
 -58533,
 458874639,
 128601,
 -58532,
 458914450,
 128593,
 -1,
 458960146,
 128609,
 459152223,
 458870850,
 11113,
 -1,
 459082515,
 11129,
 -58528,
 459137782,
 11011,
 -58527,
 459258756,
 129111,
 -1,
 459287271,
 11019,
 459538431,
 458769281,
 -1,
 459545447,
 459450356,
 -1,
 -58523,
 459529999,
 128603,
 -58522,
 459569810,
 128595,
 -1,
 459615506,
 128611,
 459807593,
 459526210,
 11112,
 -1,
 459737875,
 11128,
 -58518,
 459793142,
 11010,
 -58517,
 459914116,
 129110,
 -1,
 459942631,
 11018,
 460135281,
 458708064,
 -1,
 460200816,
 460062720,
 -1,
 -58513,
 460176977,
 128428,
 -1,
 460219635,
 127846,
 -1,
 460138486,
 129358,
 460462963,
 460095023,
 128618,
 -1,
 460391281,
 128619,
 460594038,
 460402083,
 -1,
 -58507,
 460551827,
 129510,
 -1,
 460599320,
 9917,
 -58505,
 460569089,
 983181,
 -58504,
 460757022,
 128284,
 -1,
 460806667,
 983043,
 460987486,
 444750347,
 -1,
 461052990,
 460921222,
 -1,
 461118460,
 461024454,
 -1,
 461183995,
 461052943,
 -1,
 461249469,
 461143382,
 -1,
 461314949,
 461233072,
 -1,
 461380484,
 461280429,
 -1,
 461446018,
 461352134,
 70025,
 -1,
 461417670,
 70026,
 461635583,
 461403919,
 70027,
 -1,
 461534991,
 70028,
 -1,
 461314438,
 70062,
 461773707,
 461293473,
 -1,
 461839241,
 461752225,
 -1,
 -58488,
 461789725,
 70044,
 -1,
 461838726,
 70043,
 -58486,
 461789725,
 70049,
 -1,
 461969798,
 70048,
 462166928,
 461737004,
 -1,
 -58483,
 462154143,
 70042,
 -58482,
 462195830,
 70047,
 -58481,
 462247191,
 70037,
 -1,
 462297478,
 70052,
 462494614,
 462108941,
 -1,
 462560148,
 462436621,
 -1,
 -58477,
 462510621,
 70046,
 -1,
 462559622,
 70045,
 -58475,
 462510621,
 70051,
 -1,
 462690694,
 70050,
 462887834,
 462428550,
 70019,
 -58472,
 462869402,
 70032,
 -58471,
 462906285,
 70030,
 -1,
 462952838,
 70020,
 463149982,
 462862849,
 -1,
 -58468,
 463125206,
 70064,
 -58467,
 463165981,
 70063,
 -1,
 463214982,
 70065,
 463412128,
 463131546,
 70023,
 -1,
 463393690,
 70024,
 463543203,
 463381167,
 -1,
 -58462,
 463493661,
 70054,
 -1,
 463542662,
 70053,
 463739814,
 463501071,
 -1,
 -58459,
 463697753,
 70061,
 -1,
 463739270,
 70060,
 463936425,
 463696697,
 -1,
 -58456,
 463886877,
 70034,
 -1,
 463935878,
 70033,
 464133036,
 463893005,
 -1,
 -58453,
 464083485,
 70041,
 -1,
 464132486,
 70040,
 464329646,
 464085933,
 70021,
 -1,
 464282541,
 70022,
 464460721,
 464278728,
 -1,
 -58448,
 464411165,
 70036,
 -1,
 464460166,
 70035,
 464657332,
 464399779,
 -1,
 -58445,
 464607773,
 70039,
 -1,
 464656774,
 70038,
 464853943,
 464594783,
 -1,
 -58442,
 464804381,
 70056,
 -1,
 464853382,
 70055,
 -58440,
 464841119,
 70058,
 -58439,
 465022272,
 70059,
 -58438,
 465081367,
 70031,
 -58437,
 465142729,
 70057,
 -58436,
 465197597,
 70066,
 -1,
 465256958,
 70029,
 465443791,
 461234164,
 -1,
 465509326,
 465420217,
 -1,
 465574852,
 465493853,
 -1,
 465640386,
 465546438,
 70072,
 -1,
 465611974,
 70073,
 465829887,
 465598223,
 70074,
 -1,
 465729295,
 70075,
 465902536,
 465508742,
 -1,
 -58426,
 465884058,
 70079,
 -58425,
 465920941,
 70077,
 -1,
 465967494,
 70067,
 466164682,
 465884058,
 70070,
 -1,
 466146202,
 70071,
 466295756,
 466117549,
 70068,
 -1,
 466248621,
 70069,
 -58419,
 466261015,
 70078,
 -1,
 466371070,
 70076,
 -1,
 465472084,
 70091,
 466623459,
 465418753,
 -1,
 466688988,
 466577273,
 -1,
 466754516,
 466673341,
 -1,
 -58413,
 466729905,
 70018,
 -1,
 466792025,
 70080,
 466951127,
 466688390,
 -1,
 -58410,
 466934726,
 70081,
 -1,
 466981778,
 70017,
 -58408,
 466933982,
 70083,
 -58407,
 467124053,
 70107,
 -58406,
 467178307,
 70090,
 -58405,
 467235502,
 70082,
 -1,
 467283575,
 70016,
 467475425,
 466633214,
 -1,
 467540960,
 467417112,
 -1,
 -58401,
 467472999,
 70111,
 -1,
 467538236,
 70110,
 -1,
 467510308,
 70088,
 -58398,
 467458943,
 70093,
 -1,
 467738931,
 70089,
 467934196,
 466565389,
 -1,
 467999730,
 467887970,
 -1,
 468065256,
 467978145,
 -1,
 -58393,
 468051478,
 70098,
 -1,
 468083168,
 70099,
 468261867,
 468040193,
 -1,
 -58390,
 468218224,
 70102,
 -1,
 468274325,
 70103,
 468458478,
 468209297,
 -1,
 -58387,
 468426493,
 70100,
 -1,
 468480190,
 70101,
 -58385,
 468446491,
 70096,
 -58384,
 468621397,
 70097,
 -58383,
 468684872,
 70105,
 -1,
 468731526,
 70104,
 -58381,
 467967622,
 70086,
 -1,
 468853022,
 70085,
 469048311,
 467878398,
 -1,
 -58378,
 469035252,
 70092,
 -1,
 469070841,
 70106,
 -58376,
 469014317,
 70084,
 -58375,
 469196021,
 70108,
 -58374,
 469251542,
 70109,
 -1,
 469310151,
 70087,
 -1,
 461140793,
 129416,
 469572668,
 461102000,
 -1,
 469638203,
 469525633,
 -1,
 469703688,
 469571974,
 -1,
 469769218,
 469675206,
 -1,
 -58367,
 469741312,
 66684,
 -1,
 469778942,
 66680,
 -58365,
 469754402,
 66679,
 -58364,
 469941583,
 66664,
 -58363,
 469986867,
 66682,
 -58362,
 470047243,
 66669,
 -58361,
 470111848,
 66673,
 -1,
 470170898,
 66665,
 470359055,
 469668887,
 -1,
 -58358,
 470342445,
 66668,
 -58357,
 470396102,
 66681,
 -58356,
 470459006,
 66677,
 -58355,
 470518828,
 66666,
 -58354,
 470575073,
 66678,
 -1,
 470621799,
 66676,
 470817813,
 470303230,
 -1,
 470883347,
 470751622,
 -1,
 -58350,
 470861729,
 66672,
 -1,
 470920390,
 66685,
 -58348,
 470857909,
 66683,
 -1,
 471029495,
 66663,
 471211034,
 470796193,
 -1,
 471276569,
 471161355,
 -1,
 -58344,
 471230153,
 66644,
 -1,
 471289471,
 66654,
 -1,
 471244186,
 66641,
 471538718,
 471163821,
 -1,
 -58340,
 471486097,
 66662,
 -58339,
 471543709,
 66674,
 -1,
 471605317,
 66686,
 471800865,
 471525929,
 -1,
 -58336,
 471785659,
 66687,
 -1,
 471800198,
 66648,
 471997476,
 471787030,
 -1,
 -58333,
 471963262,
 66667,
 -1,
 472007166,
 66658,
 472194087,
 471972353,
 -1,
 -58330,
 472177149,
 66646,
 -1,
 472224791,
 66645,
 472390698,
 472154995,
 -1,
 -58327,
 472344666,
 66661,
 -1,
 472400861,
 66656,
 472587309,
 472341003,
 -1,
 -58324,
 472569785,
 66649,
 -1,
 472586792,
 66659,
 -58322,
 472575420,
 66655,
 -58321,
 472768490,
 66653,
 -58320,
 472832029,
 66675,
 -58319,
 472889234,
 66670,
 -58318,
 472950026,
 66640,
 -58317,
 473011081,
 66671,
 -58316,
 473071797,
 66660,
 -58315,
 473134468,
 66642,
 -58314,
 473199384,
 66657,
 -58313,
 473257322,
 66652,
 -58312,
 473321321,
 66643,
 -58311,
 473381557,
 66651,
 -58310,
 473444789,
 66647,
 -1,
 473508389,
 66650,
 -1,
 469582954,
 127847,
 -58307,
 469535516,
 9752,
 -1,
 473727054,
 129368,
 473898066,
 461018135,
 -1,
 473963596,
 473872651,
 -1,
 474029125,
 473914243,
 -1,
 -58302,
 474011841,
 113827,
 -58301,
 474054004,
 113824,
 -58300,
 474103902,
 113826,
 -1,
 474166760,
 113825,
 474356810,
 473956352,
 -1,
 474422345,
 474294111,
 -1,
 -58296,
 474368218,
 11103,
 -1,
 474422168,
 11087,
 -1,
 474398960,
 11086,
 -58293,
 474331649,
 129651,
 -1,
 474623501,
 127856,
 474815567,
 473934097,
 -1,
 -58290,
 474796286,
 128722,
 -1,
 474818513,
 128717,
 -58288,
 474800757,
 128703,
 -58287,
 474979852,
 127776,
 -1,
 475018022,
 129327,
 475208793,
 473850797,
 -1,
 475274326,
 475157603,
 -1,
 -58283,
 475242434,
 983075,
 -1,
 475293870,
 983078,
 -58281,
 475243183,
 128674,
 -58280,
 475435805,
 9961,
 -1,
 475481876,
 128737,
 475667548,
 475180230,
 -1,
 -58277,
 475649559,
 129335,
 -1,
 475687070,
 129424,
 -58275,
 475654436,
 983197,
 -1,
 475809143,
 128017,
 475995439,
 460921222,
 -1,
 476060878,
 475978172,
 -1,
 476126413,
 475997450,
 -1,
 476191907,
 476085590,
 -1,
 476257385,
 476175280,
 -1,
 476322920,
 476222637,
 -1,
 476388454,
 476294342,
 43144,
 -1,
 476359878,
 43145,
 476577791,
 476346127,
 43146,
 -1,
 476477199,
 43147,
 -1,
 476256646,
 43182,
 476716143,
 476235681,
 -1,
 476781677,
 476694433,
 -1,
 -58260,
 476731933,
 43165,
 -1,
 476780934,
 43164,
 -58258,
 476731933,
 43170,
 -1,
 476912006,
 43169,
 477109364,
 476679212,
 -1,
 -58255,
 477096351,
 43163,
 -58254,
 477138038,
 43168,
 -58253,
 477189399,
 43158,
 -1,
 477239686,
 43173,
 477437050,
 477051149,
 -1,
 477502584,
 477378829,
 -1,
 -58249,
 477452829,
 43167,
 -1,
 477501830,
 43166,
 -58247,
 477452829,
 43172,
 -1,
 477632902,
 43171,
 477830270,
 477370758,
 43138,
 -58244,
 477811610,
 43153,
 -58243,
 477848493,
 43150,
 -1,
 477895046,
 43139,
 478092418,
 477805057,
 -1,
 -58240,
 478067414,
 43184,
 -58239,
 478108189,
 43183,
 -1,
 478157190,
 43185,
 478354564,
 478073754,
 43142,
 -1,
 478335898,
 43143,
 478485639,
 478323375,
 -1,
 -58234,
 478435869,
 43175,
 -1,
 478484870,
 43174,
 478682249,
 478450711,
 43151,
 -1,
 478647319,
 43152,
 478813324,
 478639887,
 -1,
 -58229,
 478771033,
 43187,
 -1,
 478812550,
 43181,
 479009935,
 478769977,
 -1,
 -58226,
 478960157,
 43155,
 -1,
 479009158,
 43154,
 479206546,
 478966285,
 -1,
 -58223,
 479156765,
 43162,
 -1,
 479205766,
 43161,
 479403156,
 479159213,
 43140,
 -1,
 479355821,
 43141,
 479534231,
 479352008,
 -1,
 -58218,
 479484445,
 43157,
 -1,
 479533446,
 43156,
 479730841,
 479478270,
 43148,
 -1,
 479674878,
 43149,
 479861916,
 479669667,
 -1,
 -58213,
 479812125,
 43160,
 -1,
 479861126,
 43159,
 480058527,
 479799135,
 -1,
 -58210,
 480008733,
 43177,
 -1,
 480057734,
 43176,
 -58208,
 480045471,
 43179,
 -58207,
 480226624,
 43180,
 -58206,
 480281545,
 43178,
 -1,
 480336413,
 43186,
 480517301,
 476176438,
 -1,
 480582825,
 480501597,
 -1,
 480648359,
 480554182,
 43194,
 -1,
 480619718,
 43195,
 480837631,
 480605967,
 43196,
 -1,
 480737039,
 43197,
 480910509,
 480516486,
 -1,
 -58197,
 480891802,
 43203,
 -58196,
 480928685,
 43200,
 -1,
 480975238,
 43189,
 481172655,
 480891802,
 43192,
 -1,
 481153946,
 43193,
 481303729,
 481137687,
 43201,
 -1,
 481268759,
 43202,
 481434803,
 481256365,
 43190,
 -1,
 481387437,
 43191,
 481624063,
 481378814,
 43198,
 -1,
 481509886,
 43199,
 481696966,
 480459021,
 -1,
 481762500,
 481650530,
 -1,
 481828026,
 481740705,
 -1,
 -58183,
 481814038,
 43218,
 -1,
 481845728,
 43219,
 482024637,
 481802753,
 -1,
 -58180,
 481980784,
 43222,
 -1,
 482036885,
 43223,
 482221248,
 481971857,
 -1,
 -58177,
 482189053,
 43220,
 -1,
 482242750,
 43221,
 -58175,
 482209051,
 43216,
 -58174,
 482383957,
 43217,
 -58173,
 482447432,
 43225,
 -1,
 482494086,
 43224,
 -58171,
 481730182,
 43215,
 -1,
 482615582,
 43214,
 482811084,
 481673145,
 -1,
 482876618,
 482795197,
 -1,
 -58167,
 482851761,
 43137,
 -1,
 482913881,
 43204,
 -58165,
 482815607,
 43205,
 -1,
 483009061,
 43136,
 -1,
 482751870,
 43188,
 -1,
 476093346,
 129429,
 483335452,
 476022122,
 -1,
 483400938,
 483294550,
 -1,
 483466452,
 483379105,
 -1,
 -58158,
 483441386,
 2065,
 -58157,
 483487731,
 2056,
 -1,
 483531347,
 2069,
 483728600,
 483419053,
 -1,
 -58154,
 483715364,
 2052,
 -58153,
 483772321,
 2055,
 -1,
 483822636,
 2063,
 483990747,
 483703297,
 -1,
 -58150,
 483945319,
 2062,
 -1,
 484006742,
 2068,
 484187358,
 483927903,
 -1,
 -58147,
 484143091,
 2049,
 -1,
 484186699,
 2053,
 -58145,
 484175105,
 2054,
 -58144,
 484371496,
 2057,
 -58143,
 484423358,
 2067,
 -58142,
 484486288,
 2066,
 -58141,
 484545417,
 2061,
 -58140,
 484608294,
 2060,
 -58139,
 484669299,
 2059,
 -58138,
 484733871,
 2058,
 -58137,
 484791691,
 2050,
 -58136,
 484855811,
 2064,
 -58135,
 484915688,
 2051,
 -1,
 484974274,
 2048,
 485170428,
 483385398,
 -1,
 485235953,
 485130445,
 -1,
 485301486,
 485169542,
 2082,
 -1,
 485235078,
 2079,
 -58129,
 485282714,
 2086,
 -58128,
 485385133,
 2089,
 -1,
 485442046,
 2076,
 485629172,
 485200919,
 2091,
 485752831,
 485612914,
 2081,
 -1,
 485628294,
 2078,
 485825783,
 485603841,
 -1,
 -58122,
 485807726,
 2092,
 -1,
 485843288,
 2085,
 486022393,
 485759366,
 2083,
 -1,
 485955974,
 2080,
 -58118,
 486003610,
 2087,
 -58117,
 486106029,
 2090,
 -1,
 486162942,
 2077,
 486350095,
 485141077,
 -1,
 486415620,
 486283654,
 -1,
 486481153,
 486378540,
 -1,
 -58112,
 486444198,
 2110,
 -1,
 486495894,
 2098,
 -58110,
 486461000,
 2100,
 -58109,
 486651700,
 2108,
 -1,
 486691930,
 2097,
 486874375,
 486403120,
 -1,
 -58106,
 486829614,
 2104,
 -1,
 486874191,
 2106,
 487070986,
 486849025,
 -1,
 -58103,
 487036273,
 2109,
 -1,
 487088103,
 2101,
 -58101,
 487051880,
 2107,
 -58100,
 487238496,
 2105,
 -58099,
 487296726,
 2096,
 -58098,
 487360359,
 2103,
 -1,
 487401690,
 2099,
 487595291,
 486310771,
 -1,
 487660823,
 487531356,
 -1,
 487726355,
 487614638,
 2070,
 -1,
 487657136,
 2071,
 -58092,
 487691471,
 2072,
 -58091,
 487821014,
 2093,
 -58090,
 487868824,
 2075,
 -1,
 487930317,
 2073,
 488177663,
 487626046,
 -1,
 -58087,
 488095466,
 2084,
 -58086,
 488137645,
 2088,
 -1,
 488196504,
 2074,
 -1,
 487529122,
 2102,
 488447269,
 483298348,
 -1,
 488512804,
 488422090,
 -1,
 488578339,
 488463659,
 -1,
 488643874,
 488521332,
 -1,
 -58079,
 488624647,
 128630,
 -1,
 488649888,
 128631,
 -1,
 488604062,
 128632,
 -1,
 488533183,
 128634,
 -1,
 488456673,
 129386,
 489037095,
 488425958,
 128752,
 -1,
 488964310,
 128225,
 489168170,
 488984468,
 -1,
 -58071,
 489152155,
 129466,
 -1,
 489203343,
 129527,
 -58069,
 489154767,
 127927,
 -58068,
 489337531,
 129403,
 -58067,
 489390770,
 129474,
 -58066,
 489452723,
 127862,
 -1,
 489514998,
 9973,
 489692641,
 475966327,
 -1,
 489758176,
 489628483,
 -1,
 489823685,
 489699599,
 -1,
 489889137,
 489762211,
 -1,
 489954671,
 489845447,
 -1,
 490020168,
 489887102,
 -1,
 490085689,
 489951847,
 -1,
 -58057,
 490018820,
 127545,
 -58056,
 490083704,
 127516,
 -1,
 490148449,
 127520,
 490347836,
 490019028,
 -1,
 -58053,
 490279810,
 127511,
 -1,
 490345054,
 127509,
 490544447,
 490280106,
 -1,
 -58050,
 490476711,
 127525,
 -1,
 490541362,
 127540,
 490741058,
 490476428,
 -1,
 -58047,
 490688223,
 127534,
 -1,
 490745730,
 127506,
 -58045,
 490688226,
 127517,
 -58044,
 490879665,
 127532,
 -58043,
 490940293,
 127505,
 -58042,
 491002064,
 127524,
 -58041,
 491066991,
 127546,
 -1,
 491131482,
 127518,
 491330905,
 489952883,
 -1,
 491396429,
 491262567,
 -1,
 -58037,
 491329912,
 127527,
 -58036,
 491394645,
 127537,
 -1,
 491459957,
 127504,
 491658576,
 491329534,
 -1,
 -58033,
 491591892,
 127542,
 -1,
 491657251,
 127543,
 491855187,
 491591038,
 -1,
 -58030,
 491792238,
 127519,
 -1,
 491854207,
 127515,
 492051798,
 491787148,
 -1,
 -58027,
 491984472,
 127528,
 -1,
 492048687,
 127535,
 -58025,
 491998939,
 127526,
 -58024,
 492192555,
 127541,
 -1,
 492246840,
 127513,
 492445025,
 491263811,
 -1,
 492510557,
 492377470,
 -1,
 -58020,
 492442779,
 127544,
 -1,
 492507748,
 127522,
 -58018,
 492452244,
 127521,
 -58017,
 492640839,
 127539,
 -58016,
 492706171,
 127538,
 -1,
 492769861,
 127514,
 492969320,
 492377467,
 -1,
 493034853,
 492900396,
 -1,
 -58012,
 492968148,
 127530,
 -1,
 493031468,
 127529,
 -58010,
 492968516,
 127512,
 -58009,
 493164749,
 127508,
 -1,
 493228933,
 127533,
 493428076,
 492902435,
 -1,
 -58006,
 493369752,
 127536,
 -58005,
 493432285,
 127523,
 -1,
 493492610,
 127510,
 493748223,
 493361364,
 -1,
 -58002,
 493621833,
 127547,
 -1,
 493687083,
 127531,
 -58000,
 489921141,
 127378,
 -1,
 493844239,
 127377,
 494017940,
 489846543,
 -1,
 494083471,
 493954569,
 -1,
 494149006,
 494022357,
 -1,
 -57995,
 494136368,
 127305,
 -57994,
 494201124,
 127304,
 -57993,
 494266387,
 127303,
 -57992,
 494330043,
 127302,
 -57991,
 494394288,
 127301,
 -57990,
 494457754,
 127300,
 -57989,
 494520225,
 127299,
 -57988,
 494582273,
 127298,
 -57987,
 494644422,
 127297,
 -57986,
 494709505,
 127296,
 -57985,
 494772911,
 127295,
 -57984,
 494834711,
 127294,
 -57983,
 494898220,
 127293,
 -57982,
 494961523,
 127292,
 -57981,
 495023887,
 127291,
 -57980,
 495088441,
 127290,
 -57979,
 495153677,
 127289,
 -57978,
 495215533,
 127288,
 -57977,
 495278603,
 127287,
 -57976,
 495342792,
 127286,
 -57975,
 495406737,
 127285,
 -57974,
 495469054,
 127284,
 -57973,
 495532301,
 127283,
 -57972,
 495594915,
 127282,
 -57971,
 495658847,
 127281,
 -1,
 495720838,
 127280,
 -1,
 494125468,
 127397,
 496041983,
 494048279,
 -1,
 496049555,
 495933435,
 -1,
 -57966,
 496016421,
 10191,
 -1,
 496050310,
 10190,
 -1,
 496026676,
 127401,
 496311710,
 493992449,
 -1,
 496377240,
 496255486,
 -1,
 -57961,
 496360727,
 127393,
 -1,
 496383258,
 127388,
 -57959,
 496351745,
 127309,
 -57958,
 496541035,
 127384,
 -57957,
 496595410,
 127395,
 -57956,
 496657278,
 127402,
 -57955,
 496711949,
 127308,
 -1,
 496771063,
 9949,
 496967076,
 496268089,
 -1,
 497032611,
 496903539,
 -1,
 -57951,
 497007318,
 127490,
 -57950,
 497055292,
 127489,
 -1,
 497105527,
 127507,
 -1,
 496979583,
 9919,
 497360297,
 496917003,
 -1,
 -57946,
 497343408,
 127306,
 -57945,
 497378342,
 127400,
 -57944,
 497434907,
 127399,
 -1,
 497495459,
 127398,
 497687983,
 497307281,
 -1,
 497753517,
 497655553,
 -1,
 -57940,
 497709881,
 127390,
 -1,
 497761744,
 11820,
 -57938,
 497725614,
 127379,
 -1,
 497905939,
 127392,
 498081204,
 497665953,
 -1,
 498146739,
 498065595,
 -1,
 -57934,
 498111532,
 127389,
 -1,
 498157883,
 127394,
 -1,
 498098689,
 127387,
 498408887,
 498064304,
 -1,
 -57930,
 498383361,
 127386,
 -1,
 498439441,
 127404,
 498605498,
 498389914,
 -1,
 -57927,
 498574064,
 127385,
 -1,
 498621591,
 127403,
 498802109,
 498570263,
 -1,
 -57924,
 498765361,
 127396,
 -1,
 498823993,
 127383,
 498998720,
 498764844,
 -1,
 -57921,
 498947272,
 127382,
 -1,
 499010913,
 127381,
 -57919,
 498983450,
 127311,
 -57918,
 499165517,
 127310,
 -57917,
 499223556,
 127307,
 -57916,
 499279172,
 127380,
 -1,
 499336863,
 127391,
 499580927,
 489750528,
 -1,
 499588555,
 499508300,
 -1,
 -57912,
 499571009,
 11028,
 -57911,
 499633854,
 11026,
 -57910,
 499679786,
 11029,
 -1,
 499723294,
 11027,
 499916241,
 499529997,
 -1,
 499981776,
 499876723,
 13175,
 500105215,
 499908608,
 -1,
 -57905,
 500024179,
 13176,
 -1,
 500054079,
 13177,
 -1,
 499937805,
 127376,
 500309462,
 499859966,
 -1,
 500374997,
 500280518,
 -1,
 -57900,
 500323528,
 13005,
 -1,
 500373933,
 13055,
 -1,
 500358064,
 13006,
 500637145,
 500259339,
 -1,
 -57896,
 500592188,
 127488,
 -1,
 500651208,
 13004,
 -57894,
 500620210,
 13278,
 -57893,
 500812071,
 128918,
 -57892,
 500869304,
 11216,
 -57891,
 500920507,
 13178,
 -57890,
 500979073,
 13311,
 -57889,
 501043969,
 9974,
 -1,
 501094842,
 13279,
 -1,
 489710916,
 129425,
 501358165,
 489673626,
 -1,
 501423691,
 501320748,
 -1,
 501489220,
 501365278,
 -1,
 501554706,
 501448022,
 -1,
 501620201,
 501517356,
 -1,
 -57881,
 501606815,
 7057,
 -57880,
 501634327,
 7053,
 -1,
 501684614,
 7060,
 501882350,
 501567121,
 -1,
 501947885,
 501836013,
 -1,
 -57876,
 501908339,
 7103,
 -1,
 501969721,
 7102,
 -1,
 501881222,
 7062,
 502210033,
 501856769,
 -1,
 -57872,
 502196639,
 7087,
 -1,
 502208902,
 7070,
 502406644,
 502181062,
 -1,
 -57869,
 502352881,
 7099,
 -1,
 502405510,
 7067,
 502603255,
 502363919,
 -1,
 -57866,
 502549489,
 7100,
 -1,
 502602118,
 7068,
 502799866,
 502559545,
 -1,
 -57863,
 502749725,
 7086,
 -1,
 502798726,
 7050,
 502996476,
 502743550,
 7048,
 -1,
 502977434,
 7049,
 503127551,
 502933343,
 -1,
 -57858,
 503077405,
 7101,
 -1,
 503126406,
 7064,
 503324161,
 503060870,
 7043,
 -1,
 503267838,
 7046,
 -57854,
 503311454,
 7056,
 -57853,
 503441823,
 7066,
 -57852,
 503506998,
 7071,
 -57851,
 503570683,
 7069,
 -57850,
 503634883,
 7063,
 -57849,
 503698330,
 7045,
 -57848,
 503760935,
 7058,
 -57847,
 503819040,
 7051,
 -57846,
 503882507,
 7061,
 -57845,
 503944215,
 7047,
 -57844,
 504005577,
 7065,
 -57843,
 504066603,
 7055,
 -57842,
 504128429,
 7044,
 -57841,
 504191517,
 7072,
 -57840,
 504255767,
 7052,
 -57839,
 504314268,
 7059,
 -1,
 504376794,
 7054,
 504569376,
 501496931,
 -1,
 504634902,
 504547233,
 -1,
 -57835,
 504620566,
 7090,
 -1,
 504652256,
 7091,
 504831513,
 504609281,
 -1,
 -57832,
 504787312,
 7094,
 -1,
 504843413,
 7095,
 505028124,
 504778385,
 -1,
 -57829,
 504995581,
 7092,
 -1,
 505049278,
 7093,
 -57827,
 505015579,
 7088,
 -57826,
 505190485,
 7089,
 -57825,
 505253960,
 7097,
 -1,
 505300614,
 7096,
 505486890,
 504539746,
 -1,
 505552420,
 505455279,
 -1,
 -57821,
 505535016,
 7362,
 -1,
 505553311,
 7361,
 -57819,
 505530098,
 7360,
 -57818,
 505707937,
 7364,
 -57817,
 505770894,
 7365,
 -57816,
 505821622,
 7366,
 -57815,
 505884184,
 7363,
 -1,
 505948051,
 7367,
 506142258,
 505471042,
 -1,
 506207793,
 506104876,
 -1,
 -57811,
 506194979,
 7077,
 -57810,
 506238745,
 7079,
 -57809,
 506288081,
 7076,
 -57808,
 506350630,
 7081,
 -1,
 506403923,
 7078,
 -1,
 506169256,
 7080,
 506666555,
 506118073,
 -1,
 506732090,
 506635019,
 -1,
 506797625,
 506694700,
 -1,
 506863160,
 506746056,
 -1,
 -57801,
 506848315,
 7042,
 -1,
 506886546,
 7041,
 -1,
 506849846,
 7040,
 -1,
 506758096,
 7082,
 -1,
 506715929,
 7083,
 507256387,
 506607018,
 -1,
 507321919,
 507231100,
 -1,
 -57794,
 507306235,
 7085,
 -1,
 507347913,
 7084,
 507518530,
 507286463,
 -1,
 -57791,
 507471837,
 7075,
 -1,
 507518610,
 7074,
 -1,
 507480398,
 7073,
 -1,
 507193038,
 7098,
 507846214,
 501462706,
 127749,
 -1,
 507774538,
 127748,
 507977289,
 507772928,
 -1,
 -57784,
 507962466,
 127774,
 -1,
 507980093,
 9925,
 -57782,
 507952398,
 127751,
 -1,
 508121605,
 127803,
 508304975,
 501392814,
 -1,
 -57779,
 508288766,
 129465,
 -57778,
 508345633,
 10185,
 -1,
 508386773,
 129464,
 508567122,
 508279297,
 -1,
 -57775,
 508536170,
 128671,
 -1,
 508583505,
 127843,
 508763732,
 508503903,
 983102,
 -1,
 508740892,
 983101,
 -1,
 508736103,
 127940,
 508960436,
 501344548,
 -1,
 509025938,
 508920151,
 -1,
 509091459,
 508984662,
 -1,
 509156958,
 509069217,
 -1,
 509222492,
 509134753,
 -1,
 -57765,
 509187095,
 43024,
 -1,
 509239325,
 43025,
 -57763,
 509187095,
 43028,
 -1,
 509370397,
 43029,
 509550180,
 509098253,
 -1,
 509615714,
 509491469,
 -1,
 -57759,
 509580311,
 43026,
 -1,
 509632541,
 43027,
 -57757,
 509580311,
 43030,
 -1,
 509763613,
 43031,
 509943399,
 509521094,
 -1,
 -57754,
 509917052,
 43040,
 -1,
 509973527,
 43038,
 510140010,
 509911727,
 -1,
 -57751,
 510104599,
 43033,
 -1,
 510156829,
 43034,
 510336621,
 510096185,
 -1,
 -57748,
 510301207,
 43015,
 -1,
 510353437,
 43016,
 510533232,
 510292493,
 -1,
 -57745,
 510497815,
 43022,
 -1,
 510550045,
 43023,
 510729843,
 510481608,
 -1,
 -57742,
 510694423,
 43017,
 -1,
 510746653,
 43018,
 510926454,
 510668195,
 -1,
 -57739,
 510891031,
 43020,
 -1,
 510943261,
 43021,
 511123065,
 510863199,
 -1,
 -57736,
 511087639,
 43035,
 -1,
 511139869,
 43036,
 -57734,
 511103898,
 43011,
 -57733,
 511296109,
 43041,
 -57732,
 511349783,
 43013,
 -57731,
 511414557,
 43032,
 -57730,
 511478260,
 43037,
 -57729,
 511541382,
 43039,
 -57728,
 511599533,
 43009,
 -57727,
 511664157,
 43042,
 -57726,
 511721982,
 43012,
 -1,
 511777158,
 43008,
 511975049,
 509075510,
 -1,
 -57723,
 511955866,
 43045,
 -57722,
 512006717,
 43047,
 -57721,
 512058285,
 43044,
 -57720,
 512115198,
 43046,
 -1,
 512170374,
 43043,
 512368270,
 511944651,
 -1,
 -57717,
 512300202,
 43051,
 -57716,
 512365452,
 43050,
 -57715,
 512430695,
 43049,
 -1,
 512495932,
 43048,
 512753663,
 512343993,
 -1,
 -57712,
 512646235,
 43014,
 -57711,
 512704984,
 43010,
 -1,
 512762405,
 43019,
 512958126,
 508998331,
 -1,
 513023661,
 512891664,
 -1,
 513089196,
 512982358,
 -1,
 513154724,
 513049714,
 -1,
 513220252,
 513117228,
 -1,
 513285786,
 513182764,
 -1,
 -57703,
 513248374,
 2149,
 -1,
 513284486,
 2148,
 -57701,
 513272223,
 2146,
 -1,
 513430807,
 2144,
 513613471,
 513179600,
 -1,
 -57698,
 513570649,
 2153,
 -1,
 513612166,
 2152,
 -57696,
 513593663,
 2147,
 -57695,
 513786818,
 2154,
 -57694,
 513846592,
 2151,
 -57693,
 513897003,
 2145,
 -1,
 513944063,
 2150,
 514137768,
 513131139,
 -1,
 -57690,
 514125174,
 1869,
 -57689,
 514159968,
 1870,
 -1,
 514215756,
 1871,
 514457599,
 514106873,
 -1,
 -57686,
 514348883,
 1838,
 -57685,
 514407345,
 1839,
 -1,
 514468370,
 1837,
 -1,
 513066637,
 983202,
 -1,
 512987044,
 128137,
 514793137,
 512920620,
 983094,
 -57680,
 514732437,
 983093,
 -1,
 514792775,
 128333,
 515047423,
 514754158,
 -1,
 -57677,
 514964311,
 8527,
 -1,
 515016108,
 128325,
 515186401,
 508938145,
 983189,
 515251915,
 515119494,
 -1,
 515317442,
 515222726,
 -1,
 515382975,
 515295227,
 -1,
 515448507,
 515357185,
 -1,
 -57670,
 515428506,
 983180,
 -1,
 515458866,
 983132,
 -57668,
 515426996,
 983044,
 -57667,
 515615199,
 983175,
 -57666,
 515661027,
 983042,
 -1,
 515725715,
 983174,
 515964927,
 515312482,
 -1,
 -57663,
 515879834,
 11243,
 -1,
 515930907,
 11242,
 516103877,
 515295137,
 -1,
 -57660,
 516085241,
 128509,
 -1,
 516124109,
 128649,
 516300488,
 516050847,
 -1,
 -57657,
 516251075,
 9882,
 -1,
 516299923,
 9877,
 -57655,
 516263386,
 129485,
 -57654,
 516459238,
 128387,
 -1,
 516504817,
 127967,
 516693714,
 515222726,
 -1,
 516759249,
 516626822,
 -1,
 516824784,
 516712141,
 -1,
 -57649,
 516787961,
 9188,
 -1,
 516819159,
 128207,
 -1,
 516809220,
 127827,
 -1,
 516713293,
 983188,
 517152472,
 516637182,
 -1,
 517218006,
 517087230,
 -1,
 -57643,
 517171781,
 127836,
 -1,
 517211186,
 128642,
 -57641,
 517196695,
 129658,
 -1,
 517378361,
 11836,
 517545692,
 517133210,
 -1,
 -57638,
 517513995,
 128723,
 -57637,
 517558182,
 129369,
 -1,
 517618846,
 127897,
 517807839,
 517510167,
 -1,
 -57634,
 517778170,
 9201,
 -1,
 517812994,
 128480,
 -57632,
 517793811,
 983045,
 -1,
 517978625,
 983169,
 518135555,
 515154607,
 983117,
 518201071,
 518078974,
 -1,
 518266603,
 518135399,
 -1,
 518332137,
 518212102,
 128264,
 518455295,
 518261602,
 -1,
 -57625,
 518376490,
 128266,
 -57624,
 518428918,
 128265,
 -1,
 518467133,
 128263,
 -57622,
 518285971,
 128483,
 -1,
 518590317,
 128586,
 518790894,
 518210046,
 -1,
 -57619,
 518732369,
 128676,
 -1,
 518795347,
 128172,
 -1,
 518767182,
 8375,
 519053046,
 518165527,
 -1,
 519118579,
 519017495,
 -1,
 -57614,
 519081004,
 129348,
 -1,
 519141153,
 129525,
 -57612,
 519101299,
 128051,
 -57611,
 519289158,
 127941,
 -1,
 519344036,
 129533,
 519511805,
 519005101,
 -1,
 519577339,
 519482946,
 -1,
 -57607,
 519552587,
 128026,
 -57606,
 519606753,
 128466,
 -1,
 519646750,
 128467,
 519897087,
 519519048,
 128375,
 -1,
 519768919,
 128376,
 519970562,
 519444870,
 983176,
 520036097,
 519944006,
 -1,
 -57600,
 519989930,
 128150,
 -1,
 520047392,
 10024,
 -1,
 519985000,
 127837,
 -1,
 519928075,
 128166,
 520363808,
 518095731,
 -1,
 520429338,
 520315821,
 -1,
 520494873,
 520388427,
 -1,
 520560406,
 520441582,
 -1,
 520625933,
 520534529,
 -1,
 520691468,
 520587503,
 128522,
 520814591,
 520618050,
 -1,
 -57589,
 520735743,
 129392,
 -1,
 520772463,
 129325,
 -1,
 520673235,
 128526,
 521019154,
 520592210,
 128515,
 521142271,
 520945730,
 -1,
 -57584,
 521063668,
 128518,
 -57583,
 521126452,
 128516,
 -1,
 521155659,
 128517,
 521404415,
 520968715,
 -1,
 -57580,
 521313556,
 128520,
 -57579,
 521356138,
 128525,
 -1,
 521412467,
 128519,
 521666559,
 520498995,
 -1,
 -57576,
 521575250,
 128570,
 -1,
 521624838,
 128571,
 -1,
 520468283,
 128527,
 521871135,
 520363857,
 -1,
 -57572,
 521851637,
 68411,
 -57571,
 521903168,
 128312,
 -57570,
 521939844,
 128313,
 -1,
 522001879,
 128745,
 -1,
 521836131,
 128684,
 522264375,
 520320783,
 -1,
 522329898,
 522207742,
 -1,
 522395432,
 522275208,
 -1,
 522460967,
 522349111,
 -1,
 -57563,
 522438494,
 128164,
 -57562,
 522473193,
 128564,
 -1,
 522525480,
 128716,
 -1,
 522447166,
 128554,
 -57559,
 522378082,
 128373,
 -1,
 522729741,
 128759,
 522919727,
 522281901,
 -1,
 522985262,
 522868682,
 -1,
 -57555,
 522961473,
 128578,
 -1,
 522998860,
 128577,
 -1,
 522923940,
 127829,
 523247412,
 522852742,
 -1,
 523312947,
 523211470,
 -1,
 -57550,
 523286292,
 11100,
 -1,
 523343433,
 11098,
 -1,
 523296722,
 42611,
 523632639,
 523214234,
 -1,
 -57546,
 523524619,
 129445,
 -1,
 523568228,
 127920,
 523771717,
 522207742,
 -1,
 523837243,
 523715070,
 -1,
 -57542,
 523779336,
 127793,
 -1,
 523833197,
 128584,
 -57540,
 523823330,
 9913,
 -57539,
 524011531,
 983168,
 -57538,
 524075943,
 9916,
 -57537,
 524138015,
 129324,
 -57536,
 524198933,
 11259,
 -57535,
 524257690,
 9914,
 -57534,
 524320240,
 129331,
 -57533,
 524369166,
 11250,
 -57532,
 524432649,
 129352,
 -1,
 524494169,
 128186,
 524689235,
 523709859,
 -1,
 524754762,
 524659910,
 -1,
 -57528,
 524719873,
 128220,
 -57527,
 524774930,
 128624,
 -1,
 524830038,
 128437,
 525016909,
 524719127,
 -1,
 -57524,
 524990639,
 129410,
 -1,
 525049327,
 128756,
 525213519,
 524968120,
 127979,
 -1,
 525142251,
 127890,
 525344594,
 525146502,
 -1,
 -57519,
 525316708,
 129507,
 -1,
 525368612,
 9878,
 -1,
 525296557,
 983185,
 525606748,
 524651564,
 -1,
 525672280,
 525574615,
 -1,
 -57514,
 525632786,
 9924,
 -57513,
 525675428,
 127938,
 -1,
 525730212,
 127956,
 525934427,
 525605254,
 -1,
 -57510,
 525890736,
 128013,
 -1,
 525952993,
 128012,
 -1,
 525878674,
 129319,
 526196580,
 525562681,
 -1,
 526262112,
 526177178,
 -1,
 -57505,
 526225653,
 129448,
 -1,
 526286800,
 128128,
 526458723,
 526214061,
 -1,
 -57502,
 526404102,
 9975,
 -1,
 526450844,
 127935,
 -1,
 526394748,
 128761,
 526720874,
 526180539,
 -1,
 526786408,
 526653830,
 -1,
 -57497,
 526761302,
 128629,
 -1,
 526814252,
 129442,
 -57495,
 526768061,
 8275,
 -1,
 526936212,
 127946,
 527114094,
 526694913,
 -1,
 -57492,
 527047046,
 983133,
 -57491,
 527111052,
 983159,
 -1,
 527176295,
 983156,
 -1,
 527062622,
 983183,
 527443980,
 366773107,
 -1,
 527507989,
 527385086,
 -1,
 527573098,
 527469612,
 -1,
 527638632,
 527514266,
 -1,
 527704143,
 527615802,
 -1,
 527769570,
 527634476,
 -1,
 527835008,
 527702228,
 -1,
 -57481,
 527767849,
 125069,
 -57480,
 527833248,
 125123,
 -57479,
 527898437,
 124959,
 -57478,
 527963792,
 125036,
 -57477,
 528029130,
 124932,
 -57476,
 528094465,
 124952,
 -57475,
 528159681,
 125097,
 -57474,
 528224925,
 125088,
 -57473,
 528290306,
 124999,
 -1,
 528355488,
 125047,
 528555915,
 527767587,
 -1,
 -57470,
 528488670,
 124993,
 -57469,
 528554050,
 125024,
 -57468,
 528619377,
 125043,
 -57467,
 528684736,
 125056,
 -57466,
 528750125,
 125117,
 -57465,
 528815343,
 124985,
 -57464,
 528880584,
 125039,
 -57463,
 528945881,
 125049,
 -57462,
 529011166,
 125071,
 -1,
 529076485,
 125015,
 529276822,
 528488259,
 -1,
 -57459,
 529209667,
 124980,
 -57458,
 529274940,
 125021,
 -57457,
 529340398,
 125119,
 -57456,
 529405616,
 124933,
 -57455,
 529470902,
 125022,
 -57454,
 529536228,
 125089,
 -57453,
 529601523,
 124986,
 -57452,
 529666758,
 125080,
 -57451,
 529731970,
 125099,
 -1,
 529797214,
 125100,
 529997729,
 529208947,
 -1,
 -57448,
 529930573,
 125002,
 -57447,
 529995943,
 125068,
 -57446,
 530061232,
 125107,
 -57445,
 530126573,
 125074,
 -57444,
 530191823,
 124931,
 -57443,
 530257166,
 125108,
 -57442,
 530322404,
 125009,
 -57441,
 530387648,
 125076,
 -57440,
 530453018,
 124945,
 -1,
 530518195,
 125124,
 530718636,
 529929598,
 -1,
 -57437,
 530651375,
 124951,
 -57436,
 530716825,
 125121,
 -57435,
 530782149,
 125066,
 -57434,
 530847359,
 125095,
 -57433,
 530912794,
 125000,
 -57432,
 530978037,
 124987,
 -57431,
 531043279,
 125041,
 -57430,
 531108492,
 125044,
 -57429,
 531173849,
 125072,
 -1,
 531239111,
 125070,
 531439543,
 530650282,
 -1,
 -57426,
 531372375,
 124946,
 -57425,
 531437679,
 124934,
 -57424,
 531503004,
 125078,
 -57423,
 531568287,
 125046,
 -57422,
 531633724,
 124942,
 -57421,
 531698909,
 125090,
 -57420,
 531764262,
 125048,
 -57419,
 531829394,
 125037,
 -57418,
 531894672,
 125033,
 -1,
 531959920,
 125035,
 532160450,
 531370892,
 -1,
 -57415,
 532093219,
 125029,
 -57414,
 532158605,
 125028,
 -57413,
 532223956,
 125027,
 -57412,
 532289146,
 125020,
 -57411,
 532354481,
 125019,
 -57410,
 532419789,
 125018,
 -57409,
 532485240,
 125013,
 -57408,
 532550477,
 125012,
 -57407,
 532615716,
 125011,
 -1,
 532680833,
 125005,
 532881357,
 532091495,
 -1,
 -57404,
 532814052,
 125004,
 -57403,
 532879453,
 125003,
 -57402,
 532944791,
 124984,
 -57401,
 533010107,
 124983,
 -57400,
 533075413,
 124982,
 -57399,
 533140793,
 124998,
 -57398,
 533206111,
 124997,
 -57397,
 533271346,
 124996,
 -57396,
 533336573,
 124976,
 -1,
 533401809,
 124975,
 533602264,
 532812092,
 -1,
 -57393,
 533535038,
 124974,
 -57392,
 533600302,
 124992,
 -57391,
 533665610,
 124991,
 -57390,
 533730933,
 124990,
 -57389,
 533796388,
 124964,
 -57388,
 533861548,
 124963,
 -57387,
 533926875,
 124962,
 -57386,
 533992045,
 124957,
 -57385,
 534057290,
 124956,
 -1,
 534122548,
 124955,
 534380543,
 533532716,
 -1,
 -57382,
 534255868,
 124950,
 -57381,
 534321280,
 124949,
 -57380,
 534386602,
 124948,
 -57379,
 534452006,
 124938,
 -57378,
 534517298,
 124937,
 -57377,
 534582601,
 124936,
 -57376,
 534647785,
 124930,
 -57375,
 534712984,
 124929,
 -1,
 534778282,
 124928,
 535035903,
 527700284,
 -1,
 535044078,
 534911011,
 -1,
 -57371,
 534976757,
 124954,
 -57370,
 535042182,
 125079,
 -57369,
 535107491,
 125083,
 -57368,
 535172762,
 125034,
 -57367,
 535238184,
 125114,
 -57366,
 535303449,
 125065,
 -57365,
 535368701,
 125058,
 -57364,
 535434039,
 125113,
 -57363,
 535499111,
 124995,
 -1,
 535564354,
 124994,
 535764985,
 534976323,
 -1,
 -57360,
 535697641,
 124935,
 -57359,
 535762999,
 124973,
 -57358,
 535828428,
 125067,
 -57357,
 535893653,
 125032,
 -57356,
 535959002,
 125010,
 -57355,
 536024315,
 125082,
 -57354,
 536089700,
 125116,
 -57353,
 536154828,
 125081,
 -57352,
 536220142,
 125101,
 -1,
 536285370,
 125122,
 536485892,
 535697011,
 -1,
 -57349,
 536418589,
 125031,
 -57348,
 536483917,
 125061,
 -57347,
 536549226,
 125064,
 -57346,
 536614533,
 125063,
 -57345,
 536679957,
 124967,
 -57344,
 536745255,
 125120,
 -57343,
 536810414,
 124965,
 -57342,
 536875815,
 124977,
 -57341,
 536940980,
 125084,
 -1,
 537006203,
 125008,
 537206799,
 536417662,
 -1,
 -57338,
 537139470,
 125054,
 -57337,
 537204858,
 125093,
 -57336,
 537270144,
 125006,
 -57335,
 537335525,
 125052,
 -57334,
 537400763,
 125059,
 -57333,
 537466119,
 124953,
 -57332,
 537531384,
 124988,
 -57331,
 537596640,
 125109,
 -57330,
 537661966,
 125115,
 -1,
 537727022,
 124958,
 537927706,
 537138346,
 -1,
 -57327,
 537860374,
 125111,
 -57326,
 537925703,
 125096,
 -57325,
 537991130,
 124968,
 -57324,
 538056414,
 125051,
 -57323,
 538121712,
 125075,
 -57322,
 538187070,
 125118,
 -57321,
 538252394,
 124944,
 -57320,
 538317493,
 125086,
 -57319,
 538382894,
 125016,
 -1,
 538447990,
 125038,
 538648613,
 537858956,
 -1,
 -57316,
 538581341,
 124947,
 -57315,
 538646569,
 124961,
 -57314,
 538711897,
 124969,
 -57313,
 538777357,
 124979,
 -57312,
 538842560,
 124971,
 -57311,
 538907936,
 125112,
 -57310,
 538973115,
 125023,
 -57309,
 539038371,
 125087,
 -57308,
 539103653,
 124970,
 -1,
 539168874,
 125042,
 539369520,
 538579559,
 -1,
 -57305,
 539302146,
 125103,
 -57304,
 539367506,
 125040,
 -57303,
 539432893,
 125055,
 -57302,
 539498272,
 124939,
 -57301,
 539563522,
 125104,
 -57300,
 539628754,
 125094,
 -57299,
 539694112,
 125102,
 -57298,
 539759315,
 125077,
 -57297,
 539824681,
 125017,
 -1,
 539889831,
 125053,
 540090427,
 539300156,
 -1,
 -57294,
 540023048,
 125106,
 -57293,
 540088508,
 124940,
 -57292,
 540153783,
 125030,
 -57291,
 540219138,
 124978,
 -57290,
 540284424,
 125050,
 -57289,
 540349774,
 124941,
 -57288,
 540414943,
 125007,
 -57287,
 540480169,
 125092,
 -57286,
 540545405,
 125060,
 -1,
 540610699,
 124989,
 540811334,
 540020780,
 -1,
 -57283,
 540744035,
 125014,
 -57282,
 540809332,
 125091,
 -57281,
 540874596,
 125098,
 -57280,
 540939980,
 125057,
 -57279,
 541005284,
 125085,
 -57278,
 541070643,
 125001,
 -57277,
 541135780,
 124960,
 -57276,
 541201169,
 125073,
 -57275,
 541266295,
 125026,
 -1,
 541331534,
 124966,
 541589503,
 540743892,
 -1,
 -57272,
 541464414,
 125025,
 -57271,
 541529863,
 124981,
 -57270,
 541595013,
 124972,
 -57269,
 541660500,
 124943,
 -57268,
 541725653,
 125045,
 -57267,
 541790950,
 125110,
 -57266,
 541856191,
 125105,
 -1,
 541921380,
 125062,
 542122076,
 527645795,
 -1,
 542187603,
 542099361,
 -1,
 -57262,
 542172694,
 125128,
 -1,
 542204384,
 125129,
 542384214,
 542161409,
 -1,
 -57259,
 542339440,
 125132,
 -1,
 542395541,
 125133,
 542580825,
 542330513,
 -1,
 -57256,
 542547709,
 125130,
 -1,
 542601406,
 125131,
 -57254,
 542546005,
 125127,
 -57253,
 542740552,
 125135,
 -1,
 542787206,
 125134,
 543031295,
 542061696,
 -1,
 543039588,
 542951329,
 -1,
 543105123,
 542982654,
 -1,
 543170658,
 543067180,
 -1,
 -57247,
 543144449,
 125137,
 -1,
 543164899,
 125140,
 -1,
 543115459,
 125136,
 -1,
 543056339,
 125139,
 543498343,
 542991155,
 -1,
 -57242,
 543472129,
 125138,
 -1,
 543492579,
 125141,
 -1,
 543459608,
 125142,
 -57239,
 527612587,
 128697,
 -1,
 543726632,
 128334,
 543891724,
 527543494,
 -1,
 543957259,
 543856161,
 -1,
 544022757,
 543897788,
 -1,
 544088242,
 543986509,
 -1,
 544153729,
 544065441,
 -1,
 544219255,
 544137403,
 -1,
 544284789,
 544183319,
 68033,
 544407551,
 544210944,
 -1,
 544415860,
 544301875,
 68051,
 -1,
 544344537,
 68078,
 -1,
 544394144,
 68060,
 544669695,
 544229686,
 68042,
 -1,
 544541145,
 68069,
 544743551,
 544168459,
 -1,
 544809085,
 544714926,
 68034,
 544931839,
 544735232,
 -1,
 544940156,
 544826163,
 68052,
 -1,
 544868825,
 68079,
 -1,
 544918432,
 68061,
 545193983,
 544763667,
 68043,
 -1,
 545065433,
 68070,
 545325055,
 544688071,
 68041,
 -1,
 545196505,
 68068,
 545398928,
 544127489,
 -1,
 545464457,
 545354096,
 68037,
 545529991,
 545390592,
 -1,
 545595526,
 545481523,
 68055,
 -1,
 545524185,
 68082,
 -1,
 545573792,
 68064,
 545849343,
 545510270,
 68046,
 -1,
 545720793,
 68073,
 545980415,
 545410197,
 68038,
 545988750,
 545849344,
 -1,
 546054285,
 545940275,
 68056,
 -1,
 545982937,
 68083,
 -1,
 546032544,
 68065,
 546308095,
 545969022,
 68047,
 -1,
 546179545,
 68074,
 546381985,
 545345169,
 -1,
 546447513,
 546346007,
 -1,
 546513047,
 546429372,
 68035,
 546635775,
 546439168,
 -1,
 546644118,
 546530099,
 68053,
 -1,
 546572761,
 68080,
 -1,
 546622368,
 68062,
 546897919,
 546486608,
 68044,
 -1,
 546769369,
 68071,
 547028991,
 546399149,
 -1,
 547037343,
 546954392,
 68036,
 547160063,
 546963456,
 -1,
 547168414,
 547054387,
 68054,
 -1,
 547097049,
 68081,
 -1,
 547146656,
 68063,
 547422207,
 546985132,
 68045,
 -1,
 547293657,
 68072,
 547496103,
 546345032,
 68040,
 547561638,
 547422208,
 -1,
 547627173,
 547513139,
 68058,
 -1,
 547555801,
 68085,
 -1,
 547605408,
 68067,
 -1,
 547541889,
 68076,
 547889325,
 547440262,
 68039,
 547954860,
 547815424,
 -1,
 548020395,
 547906355,
 68057,
 -1,
 547949017,
 68084,
 -1,
 547998624,
 68066,
 -1,
 547940725,
 68075,
 548339711,
 547854421,
 68032,
 548405247,
 548208640,
 -1,
 548413617,
 548299571,
 68050,
 -1,
 548342233,
 68077,
 -1,
 548391840,
 68059,
 548610259,
 544044815,
 -1,
 548675792,
 548555713,
 -1,
 548741304,
 548652961,
 -1,
 -57162,
 548705303,
 68022,
 -57161,
 548749822,
 68021,
 -1,
 548804998,
 68020,
 549003451,
 548715009,
 -1,
 -57158,
 548946430,
 68017,
 -1,
 549001606,
 68015,
 549200062,
 548965420,
 -1,
 -57155,
 549143038,
 68010,
 -1,
 549198214,
 68009,
 549396673,
 549155641,
 -1,
 -57152,
 549345821,
 68013,
 -1,
 549394822,
 68018,
 549593283,
 549329286,
 68000,
 -1,
 549564226,
 68016,
 -57148,
 549579167,
 68004,
 -57147,
 549708027,
 68005,
 -57146,
 549760320,
 68011,
 -57145,
 549825312,
 68019,
 -57144,
 549888779,
 68007,
 -57143,
 549950487,
 68003,
 -57142,
 550011849,
 68008,
 -57141,
 550074201,
 68012,
 -57140,
 550134701,
 68002,
 -57139,
 550198861,
 68014,
 -57138,
 550257150,
 68001,
 -57137,
 550320540,
 68023,
 -1,
 550381456,
 68006,
 550633471,
 548640167,
 -1,
 -57134,
 550549334,
 68030,
 -1,
 550594714,
 68031,
 550830079,
 548557748,
 -1,
 550838488,
 550750113,
 -1,
 -57130,
 550823632,
 68087,
 -57129,
 550855347,
 68088,
 -1,
 550914082,
 68095,
 551100635,
 550812161,
 -1,
 -57126,
 551055770,
 68091,
 -1,
 551111880,
 68092,
 551297246,
 551065689,
 -1,
 -57123,
 551277188,
 68086,
 -1,
 551312057,
 68029,
 551493857,
 551243409,
 -1,
 -57120,
 551460730,
 68089,
 -1,
 551514435,
 68090,
 551690468,
 551436798,
 -1,
 -57117,
 551648691,
 68028,
 -1,
 551708412,
 68093,
 -1,
 551653473,
 68094,
 552009727,
 543972987,
 -1,
 552018185,
 551910742,
 -1,
 552083693,
 551995297,
 -1,
 552149226,
 552026622,
 67994,
 -1,
 552079018,
 67995,
 552280300,
 552081798,
 67992,
 -1,
 552210090,
 67993,
 -1,
 552244247,
 67996,
 552476914,
 552045612,
 -1,
 552542448,
 552419838,
 67980,
 -1,
 552472234,
 67981,
 552730623,
 552475014,
 67978,
 -1,
 552603306,
 67979,
 552804598,
 552450561,
 -1,
 552870133,
 552737158,
 67987,
 -1,
 552799914,
 67988,
 -1,
 552813054,
 67989,
 553066744,
 552774976,
 67982,
 -1,
 552996522,
 67983,
 553197819,
 553022265,
 -1,
 -57094,
 553146909,
 67985,
 -1,
 553195910,
 67990,
 553394429,
 553133968,
 67974,
 -1,
 553324202,
 67975,
 -57090,
 553380255,
 67972,
 -57089,
 553509115,
 67973,
 -57088,
 553560864,
 67991,
 -57087,
 553624331,
 67976,
 -57086,
 553686039,
 67971,
 -57085,
 553747401,
 67977,
 -57084,
 553809753,
 67984,
 -57083,
 553870253,
 67970,
 -57082,
 553934413,
 67986,
 -57081,
 553992702,
 67969,
 -57080,
 554056092,
 67997,
 -1,
 554113414,
 67968,
 554369023,
 551995265,
 67998,
 -1,
 554241706,
 67999,
 -1,
 543925762,
 129500,
 554508693,
 543832333,
 -1,
 554574202,
 554452385,
 -1,
 554639667,
 554547713,
 -1,
 554705202,
 554599636,
 -1,
 554770707,
 554667052,
 93819,
 -57070,
 554756388,
 93815,
 -1,
 554783944,
 983265,
 554967318,
 554703238,
 93805,
 -57067,
 554946091,
 93796,
 -1,
 554984365,
 93822,
 555163928,
 554952996,
 93823,
 -1,
 555144090,
 93811,
 555295002,
 555127831,
 93821,
 -1,
 555237886,
 93818,
 555426076,
 555250489,
 93804,
 -1,
 555393711,
 93798,
 555557150,
 555375115,
 983264,
 -1,
 555524783,
 93814,
 -57057,
 555543600,
 93797,
 -57056,
 555673619,
 93816,
 -57055,
 555737275,
 93795,
 -57054,
 555801520,
 93794,
 -57053,
 555864986,
 93810,
 -57052,
 555927457,
 93800,
 -57051,
 555989505,
 93793,
 -57050,
 556051654,
 93820,
 -57049,
 556116737,
 93813,
 -57048,
 556180143,
 93799,
 -57047,
 556237683,
 93792,
 -57046,
 556300047,
 93812,
 -57045,
 556364301,
 93806,
 -57044,
 556426157,
 93803,
 -57043,
 556487880,
 93801,
 -57042,
 556551825,
 93802,
 -57041,
 556614142,
 93807,
 -57040,
 556677389,
 93817,
 -57039,
 556740003,
 93809,
 -1,
 556803935,
 93808,
 -1,
 554691415,
 93849,
 557064536,
 554577315,
 -1,
 557130071,
 556999269,
 -1,
 557195576,
 557091884,
 93787,
 -57033,
 557181220,
 93783,
 -1,
 557208776,
 983263,
 557392187,
 557128070,
 93773,
 -57030,
 557370923,
 93764,
 -1,
 557409197,
 93790,
 557588797,
 557377828,
 93791,
 -1,
 557568922,
 93779,
 557719871,
 557552663,
 93789,
 -1,
 557662718,
 93786,
 557850945,
 557675321,
 93772,
 -1,
 557818543,
 93766,
 557982019,
 557799947,
 983262,
 -1,
 557949615,
 93782,
 -57020,
 557968432,
 93765,
 -57019,
 558098451,
 93784,
 -57018,
 558162107,
 93763,
 -57017,
 558226352,
 93762,
 -57016,
 558289818,
 93778,
 -57015,
 558352289,
 93768,
 -57014,
 558414337,
 93761,
 -57013,
 558476486,
 93788,
 -57012,
 558541569,
 93781,
 -57011,
 558604975,
 93767,
 -57010,
 558662515,
 93760,
 -57009,
 558724879,
 93780,
 -57008,
 558789133,
 93774,
 -57007,
 558850989,
 93771,
 -57006,
 558912712,
 93769,
 -57005,
 558976657,
 93770,
 -57004,
 559038974,
 93775,
 -57003,
 559102221,
 93785,
 -57002,
 559164835,
 93777,
 -1,
 559228767,
 93776,
 -1,
 557094827,
 93847,
 559489385,
 557005923,
 -1,
 559554910,
 559466401,
 -1,
 559620444,
 559539734,
 93826,
 -1,
 559546401,
 93845,
 559808511,
 559571424,
 93827,
 -1,
 559677473,
 93846,
 559882593,
 559528449,
 -1,
 -56992,
 559837552,
 93830,
 -1,
 559893653,
 93831,
 560079203,
 559847509,
 93825,
 -1,
 560005153,
 93844,
 560210278,
 560025233,
 -1,
 -56987,
 560176893,
 93828,
 -1,
 560230590,
 93829,
 -56985,
 560196891,
 93824,
 -56984,
 560369736,
 93833,
 -1,
 560416390,
 93832,
 560603512,
 559453005,
 -1,
 560669038,
 560580513,
 -1,
 -56980,
 560652849,
 93836,
 -56979,
 560684950,
 93837,
 -1,
 560744391,
 93834,
 560931185,
 560642561,
 -1,
 -56976,
 560886182,
 93840,
 -1,
 560942294,
 93841,
 561127796,
 560877201,
 -1,
 -56973,
 561094545,
 93838,
 -1,
 561145349,
 93839,
 561324407,
 561070590,
 -1,
 -56970,
 561282477,
 93835,
 -1,
 561342258,
 93842,
 -1,
 561287279,
 93843,
 -56967,
 560551095,
 93848,
 -1,
 561532325,
 93850,
 561774591,
 554525613,
 -1,
 561783188,
 561698492,
 -1,
 561848706,
 561756673,
 -1,
 561914240,
 561803635,
 -1,
 -56961,
 561890121,
 128950,
 -1,
 561948641,
 128971,
 -56959,
 561874158,
 9900,
 -1,
 562044919,
 128938,
 562241927,
 561794705,
 -1,
 562307462,
 562208585,
 -1,
 -56955,
 562275998,
 128967,
 -1,
 562309913,
 128965,
 -1,
 562262319,
 128944,
 562569610,
 562225903,
 -1,
 -56951,
 562545501,
 128911,
 -1,
 562573810,
 9898,
 562766221,
 562547724,
 -1,
 -56948,
 562734750,
 128963,
 -1,
 562768665,
 128961,
 562962832,
 562710156,
 -1,
 -56945,
 562938697,
 128956,
 -1,
 562997217,
 128974,
 563159443,
 562898783,
 -1,
 -56942,
 563123911,
 128901,
 -1,
 563181451,
 9899,
 -1,
 563108190,
 128931,
 -1,
 561728650,
 11852,
 563487231,
 554453904,
 -1,
 563552723,
 563443471,
 -1,
 563618258,
 563497921,
 -1,
 563683743,
 563579948,
 -1,
 563749275,
 563632330,
 43977,
 -1,
 563676229,
 44001,
 563880349,
 563681670,
 43973,
 -1,
 563807301,
 43999,
 -56930,
 563866015,
 43747,
 -1,
 563973238,
 43752,
 564142502,
 563660705,
 -1,
 564208035,
 564119457,
 -1,
 -56926,
 564156957,
 43749,
 -1,
 564205958,
 43748,
 564404645,
 564160481,
 43975,
 -1,
 564331589,
 44000,
 -1,
 564355466,
 43978,
 564601260,
 564082957,
 -1,
 564666794,
 564541709,
 -1,
 -56919,
 564615709,
 43751,
 -1,
 564664710,
 43750,
 -56917,
 564619233,
 43991,
 -1,
 564814218,
 43993,
 564994480,
 564574721,
 -1,
 -56914,
 564968150,
 43754,
 -56913,
 565008925,
 43753,
 -1,
 565059582,
 43969,
 565256628,
 564961967,
 -1,
 565322163,
 565188998,
 43972,
 -1,
 565249093,
 43998,
 -1,
 565271332,
 43984,
 565518776,
 565211961,
 -1,
 565584311,
 565483059,
 43968,
 -1,
 565511237,
 43995,
 -1,
 565535114,
 43976,
 565780922,
 565479861,
 43971,
 -1,
 565707845,
 43997,
 565911996,
 565737502,
 43970,
 -1,
 565838917,
 43996,
 566043071,
 565867021,
 -1,
 -56898,
 565995489,
 43990,
 -1,
 566057764,
 43987,
 566239681,
 565994413,
 43983,
 -1,
 566166597,
 44002,
 566370756,
 566187208,
 -1,
 -56893,
 566335027,
 43986,
 -1,
 566387082,
 43992,
 566567367,
 566308932,
 -1,
 -56890,
 566519777,
 43974,
 -1,
 566565254,
 43746,
 566763978,
 566503263,
 -1,
 -56887,
 566713124,
 43994,
 -1,
 566761862,
 43989,
 -56885,
 566749699,
 43980,
 -56884,
 566944017,
 43979,
 -56883,
 567006995,
 43982,
 -56882,
 567061940,
 43988,
 -56881,
 567120919,
 43745,
 -56880,
 567173924,
 43981,
 -56879,
 567230974,
 43744,
 -1,
 567289375,
 43985,
 -1,
 563599040,
 44012,
 567550440,
 563534768,
 -1,
 567615975,
 567517743,
 -1,
 567681499,
 567548294,
 -1,
 567747033,
 567613830,
 -1,
 -56872,
 567727002,
 43759,
 -1,
 567763885,
 43757,
 -56870,
 567727002,
 43758,
 -1,
 567905498,
 44005,
 568074718,
 567661466,
 -1,
 -56867,
 568054682,
 43756,
 -1,
 568102106,
 44008,
 568271329,
 568026029,
 -1,
 -56864,
 568233178,
 44004,
 -1,
 568288173,
 43755,
 -56862,
 568257141,
 44006,
 -56861,
 568450848,
 43765,
 -56860,
 568509120,
 44007,
 -56859,
 568563792,
 44003,
 -56858,
 568628109,
 44010,
 -1,
 568668403,
 44009,
 -1,
 567569993,
 43766,
 568926710,
 567491683,
 -1,
 568992236,
 568903585,
 -1,
 -56853,
 568976918,
 44018,
 -1,
 569008608,
 44019,
 569188847,
 568965633,
 -1,
 -56850,
 569143664,
 44022,
 -1,
 569199765,
 44023,
 569385458,
 569134737,
 -1,
 -56847,
 569351933,
 44020,
 -1,
 569405630,
 44021,
 -56845,
 569371931,
 44016,
 -56844,
 569546837,
 44017,
 -56843,
 569610312,
 44025,
 -1,
 569656966,
 44024,
 569844218,
 568859014,
 -1,
 -56840,
 569813568,
 44013,
 -56839,
 569872625,
 43762,
 -1,
 569924578,
 43761,
 570106365,
 569782508,
 -1,
 -56836,
 570050165,
 44011,
 -1,
 570105925,
 43760,
 -56834,
 570091395,
 43764,
 -1,
 570279749,
 43763,
 570434062,
 563466067,
 -1,
 570499597,
 570385632,
 -1,
 570565127,
 570476449,
 -1,
 570630661,
 570549957,
 -1,
 -56828,
 570597656,
 9173,
 -1,
 570651364,
 9174,
 -56826,
 570603191,
 9175,
 -1,
 570772395,
 9176,
 570958346,
 570523900,
 -1,
 -56823,
 570938216,
 9172,
 -1,
 570998493,
 9170,
 -56821,
 570932987,
 9171,
 -56820,
 571123095,
 9177,
 -1,
 571157654,
 9169,
 -1,
 570463255,
 128647,
 571417105,
 570372236,
 -1,
 -56816,
 571374823,
 129471,
 -1,
 571417476,
 129470,
 -56814,
 571392966,
 983172,
 -56813,
 571574772,
 128221,
 -56812,
 571637946,
 127816,
 -1,
 571680092,
 127830,
 571876442,
 527440262,
 -1,
 571941516,
 571837484,
 128104,
 572007005,
 571892989,
 -1,
 572072521,
 571964758,
 -1,
 572138015,
 572045825,
 -1,
 572203549,
 572070278,
 -1,
 -56804,
 572163938,
 68312,
 -1,
 572210111,
 68317,
 -56802,
 572178085,
 68323,
 -1,
 572350282,
 68322,
 572531235,
 572114849,
 -1,
 -56799,
 572480317,
 68309,
 -56798,
 572541852,
 68302,
 -1,
 572598013,
 68324,
 572793383,
 572463494,
 -1,
 -56795,
 572779234,
 68313,
 -56794,
 572816671,
 68288,
 -1,
 572860242,
 68314,
 573055530,
 572779568,
 -1,
 -56791,
 573004940,
 68298,
 -1,
 573056850,
 68297,
 573252141,
 573040659,
 -1,
 -56788,
 573217688,
 68319,
 -1,
 573252185,
 68305,
 573448752,
 573221633,
 -1,
 -56785,
 573414296,
 68318,
 -1,
 573464774,
 68320,
 573645363,
 573403961,
 -1,
 -56782,
 573594633,
 68306,
 -1,
 573645401,
 68304,
 573841974,
 573600269,
 -1,
 -56779,
 573791372,
 68300,
 -1,
 573843282,
 68299,
 574038584,
 573791386,
 68294,
 -1,
 574016190,
 68301,
 574169659,
 573985992,
 -1,
 -56774,
 574122078,
 68291,
 -1,
 574185284,
 68292,
 574366270,
 574109965,
 -1,
 -56771,
 574315325,
 68308,
 -1,
 574365442,
 68293,
 574562881,
 574302047,
 -1,
 -56768,
 574512649,
 68290,
 -1,
 574573468,
 68289,
 -56766,
 574548905,
 68303,
 -56765,
 574743009,
 68295,
 -56764,
 574796197,
 68321,
 -56763,
 574858447,
 68315,
 -56762,
 574919561,
 68311,
 -56761,
 574982011,
 68310,
 -56760,
 575043670,
 68307,
 -1,
 575098700,
 68316,
 575283794,
 572041813,
 -1,
 575349326,
 575225106,
 -1,
 575414861,
 575326113,
 68340,
 -1,
 575344249,
 68339,
 -1,
 575395069,
 68338,
 -56753,
 575328964,
 68341,
 -56752,
 575587479,
 68336,
 -56751,
 575635241,
 68342,
 -1,
 575689118,
 68337,
 575873625,
 575247181,
 -1,
 575939158,
 575850401,
 -1,
 -56747,
 575922777,
 68334,
 -1,
 575948743,
 68333,
 576135768,
 575903829,
 68331,
 -1,
 576062296,
 68335,
 -1,
 576082218,
 68332,
 576332380,
 575806132,
 -1,
 -56741,
 576268618,
 68326,
 -1,
 576330462,
 68325,
 -1,
 576307193,
 68296,
 576594558,
 571947480,
 -1,
 576660090,
 576552278,
 -1,
 576725619,
 576592262,
 -1,
 576791139,
 576698881,
 2126,
 -56734,
 576777264,
 2129,
 -1,
 576805387,
 2132,
 576987749,
 576767905,
 2133,
 -1,
 576964513,
 2120,
 577118823,
 576942905,
 2122,
 -1,
 577092310,
 2121,
 -56728,
 577104944,
 2118,
 -56727,
 577219782,
 2131,
 -56726,
 577284865,
 2130,
 -56725,
 577348271,
 2128,
 -56724,
 577408044,
 2125,
 -56723,
 577471347,
 2124,
 -56722,
 577533711,
 2123,
 -56721,
 577595566,
 2136,
 -56720,
 577657355,
 2116,
 -56719,
 577721544,
 2114,
 -56718,
 577779981,
 2115,
 -1,
 577840991,
 2113,
 578036342,
 576676781,
 -1,
 -56715,
 578013089,
 2119,
 -1,
 578063404,
 2127,
 -56713,
 578018028,
 2117,
 -56712,
 578188226,
 2135,
 -56711,
 578247454,
 2112,
 -1,
 578306495,
 2134,
 -56709,
 576642938,
 2138,
 -56708,
 578464329,
 2142,
 -56707,
 578508467,
 2139,
 -1,
 578559223,
 2137,
 578757255,
 576520192,
 -1,
 578822786,
 578741324,
 -1,
 -56703,
 578802136,
 128115,
 -1,
 578836872,
 128114,
 579019397,
 578775217,
 -1,
 -56700,
 578998909,
 129333,
 -1,
 579022156,
 128372,
 -56698,
 578959888,
 128378,
 -1,
 579150086,
 128107,
 -56696,
 578737237,
 129469,
 -56695,
 579324398,
 128368,
 -56694,
 579386020,
 128094,
 -56693,
 579426456,
 129389,
 -1,
 579478887,
 8380,
 579674891,
 571890187,
 -1,
 579740372,
 579629821,
 -1,
 579805852,
 579713537,
 -1,
 579871380,
 579760512,
 -1,
 579936915,
 579808675,
 -1,
 -56686,
 579890859,
 127006,
 -1,
 579951664,
 126988,
 -1,
 579872791,
 126997,
 580199065,
 579816619,
 -1,
 580264600,
 580136355,
 -1,
 -56681,
 580218539,
 127007,
 -1,
 580279344,
 126989,
 -1,
 580200471,
 126998,
 -56678,
 580179721,
 127015,
 -56677,
 580495784,
 127014,
 -1,
 580558850,
 126977,
 580723367,
 579782561,
 -1,
 580788898,
 580708030,
 -1,
 580854433,
 580726179,
 -1,
 -56672,
 580808363,
 127002,
 -1,
 580869168,
 126984,
 -1,
 580790295,
 126993,
 581173247,
 580739730,
 -1,
 581182118,
 581053859,
 -1,
 -56667,
 581136043,
 127003,
 -1,
 581196848,
 126985,
 -1,
 581117975,
 126994,
 581444274,
 580669073,
 -1,
 581509805,
 581410625,
 -1,
 581575340,
 581447075,
 -1,
 -56661,
 581529259,
 127004,
 -1,
 581590064,
 126986,
 -1,
 581511191,
 126995,
 581894143,
 581464331,
 -1,
 581903025,
 581774755,
 -1,
 -56656,
 581856939,
 127005,
 -1,
 581917744,
 126987,
 -1,
 581838871,
 126996,
 582165177,
 581407767,
 -1,
 582230712,
 582127173,
 -1,
 582296247,
 582167971,
 -1,
 -56650,
 582250155,
 127001,
 -1,
 582310960,
 126983,
 -1,
 582232087,
 126992,
 -1,
 582201164,
 127011,
 582623936,
 582126636,
 -1,
 582689471,
 582576654,
 -1,
 582755006,
 582626723,
 -1,
 -56643,
 582708907,
 127009,
 -1,
 582769712,
 126991,
 -1,
 582690839,
 127000,
 -1,
 582655284,
 126979,
 583082695,
 582566398,
 -1,
 583148230,
 583034611,
 -1,
 583213765,
 583085475,
 -1,
 -56636,
 583167659,
 127008,
 -1,
 583228464,
 126990,
 -1,
 583149591,
 126999,
 -1,
 583083316,
 126976,
 583541451,
 583065787,
 -1,
 -56631,
 583494808,
 127017,
 -56630,
 583557054,
 126982,
 -1,
 583617371,
 126978,
 583803598,
 583477136,
 -1,
 -56627,
 583763576,
 127012,
 -1,
 583807743,
 127019,
 -56625,
 583774315,
 126980,
 -56624,
 583968600,
 127010,
 -56623,
 584020722,
 127018,
 -56622,
 584079729,
 126981,
 -56621,
 584135075,
 127013,
 -1,
 584197828,
 127016,
 584450047,
 579673686,
 -1,
 584459015,
 584349455,
 -1,
 584524550,
 584403905,
 -1,
 584590045,
 584501153,
 -1,
 584655579,
 584566689,
 -1,
 -56614,
 584604189,
 69983,
 -1,
 584653190,
 69982,
 -56612,
 584604189,
 69988,
 -1,
 584784262,
 69987,
 584983267,
 584530189,
 -1,
 585048801,
 584923405,
 -1,
 -56608,
 584997405,
 69985,
 -1,
 585046406,
 69984,
 -56606,
 584997405,
 69990,
 -1,
 585177478,
 69989,
 585376487,
 584944684,
 -1,
 -56603,
 585361823,
 69981,
 -56602,
 585403510,
 69986,
 -1,
 585439622,
 69991,
 585638634,
 585346246,
 -1,
 -56599,
 585608512,
 70002,
 -1,
 585636230,
 69997,
 585835245,
 585605807,
 -1,
 -56596,
 585783837,
 69993,
 -1,
 585832838,
 69992,
 586031856,
 585790265,
 -1,
 -56593,
 585980445,
 69974,
 -1,
 586029446,
 69973,
 586228467,
 585986573,
 -1,
 -56590,
 586177053,
 69980,
 -1,
 586226054,
 69979,
 586425078,
 586175688,
 -1,
 -56587,
 586373661,
 69976,
 -1,
 586422662,
 69975,
 586621689,
 586362275,
 -1,
 -56584,
 586570269,
 69978,
 -1,
 586619270,
 69977,
 586818300,
 586557279,
 -1,
 -56581,
 586766877,
 69995,
 -1,
 586815878,
 69994,
 -56579,
 586800067,
 69999,
 -56578,
 586994586,
 69970,
 -56577,
 587053782,
 70000,
 -56576,
 587109399,
 69972,
 -56575,
 587170761,
 69996,
 -56574,
 587233113,
 69998,
 -56573,
 587293613,
 69969,
 -56572,
 587356701,
 70001,
 -56571,
 587416062,
 69971,
 -1,
 587471238,
 69968,
 -1,
 584476322,
 70006,
 587735818,
 584432129,
 -1,
 -56567,
 587687832,
 70003,
 -1,
 587744319,
 70005,
 -1,
 587668167,
 70004,
 587998062,
 579648420,
 -1,
 588063561,
 587955542,
 -1,
 588129044,
 588040097,
 -1,
 588194577,
 588105633,
 -1,
 -56560,
 588143133,
 72983,
 -1,
 588192134,
 72982,
 -56558,
 588164416,
 73008,
 -56557,
 588339741,
 72988,
 -1,
 588388742,
 72987,
 588587801,
 588090412,
 -1,
 -56554,
 588573087,
 72981,
 -56553,
 588614774,
 72986,
 -56552,
 588666135,
 72976,
 -1,
 588716422,
 72991,
 588915487,
 588527885,
 -1,
 588981021,
 588855565,
 -1,
 -56548,
 588929565,
 72985,
 -1,
 588978566,
 72984,
 -56546,
 588929565,
 72990,
 -1,
 589109638,
 72989,
 589308707,
 588847494,
 72960,
 -56543,
 589288346,
 72971,
 -56542,
 589325229,
 72968,
 -1,
 589371782,
 72961,
 589570855,
 589281793,
 -1,
 -56539,
 589544150,
 73002,
 -56538,
 589584925,
 73001,
 -1,
 589633926,
 73003,
 589833003,
 589525817,
 -1,
 -56535,
 589808578,
 73006,
 -56534,
 589847069,
 72973,
 -1,
 589896070,
 72972,
 590095151,
 589787661,
 -1,
 -56531,
 590058471,
 73007,
 -56530,
 590109213,
 72980,
 -1,
 590158214,
 72979,
 590357297,
 590074778,
 72964,
 -1,
 590336922,
 72965,
 590488372,
 590324399,
 -1,
 -56525,
 590436893,
 72993,
 -1,
 590485894,
 72992,
 590684983,
 590444303,
 -1,
 -56522,
 590640985,
 73005,
 -1,
 590682502,
 72999,
 590881593,
 590635949,
 72962,
 -1,
 590832557,
 72963,
 591012668,
 590828744,
 -1,
 -56517,
 590961181,
 72975,
 -1,
 591010182,
 72974,
 591209279,
 590949795,
 -1,
 -56514,
 591157789,
 72978,
 -1,
 591206790,
 72977,
 591405890,
 591144799,
 -1,
 -56511,
 591354397,
 72995,
 -1,
 591403398,
 72994,
 -56509,
 591391135,
 72997,
 -56508,
 591584195,
 73000,
 -56507,
 591637824,
 72998,
 -56506,
 591696919,
 72969,
 -56505,
 591758281,
 72996,
 -56504,
 591813149,
 73004,
 -1,
 591872510,
 72966,
 592061271,
 588045232,
 -1,
 592126806,
 592028207,
 -1,
 592192335,
 592058758,
 -1,
 -56499,
 592171930,
 73023,
 -56498,
 592208813,
 73020,
 -1,
 592255366,
 73009,
 592454481,
 592171930,
 73012,
 -1,
 592434074,
 73013,
 592585555,
 592405421,
 73010,
 -1,
 592536493,
 73011,
 -56492,
 592568176,
 73014,
 -56491,
 592679959,
 73021,
 -1,
 592724478,
 73018,
 -1,
 592080457,
 73029,
 592978789,
 592002147,
 -1,
 593044315,
 592955297,
 -1,
 -56486,
 593028630,
 73042,
 -1,
 593060320,
 73043,
 593240926,
 593017345,
 -1,
 -56483,
 593195376,
 73046,
 -1,
 593251477,
 73047,
 593437537,
 593186449,
 -1,
 -56480,
 593403645,
 73044,
 -1,
 593457342,
 73045,
 -56478,
 593423643,
 73040,
 -56477,
 593598549,
 73041,
 -56476,
 593662024,
 73049,
 -1,
 593708678,
 73048,
 593896299,
 592953273,
 -1,
 -56473,
 593878816,
 73025,
 -56472,
 593924931,
 73026,
 -56471,
 593975985,
 73028,
 -56470,
 594030161,
 73027,
 -1,
 594092581,
 73024,
 594345983,
 593865926,
 -1,
 -56467,
 594233771,
 73030,
 -1,
 594287149,
 73031,
 594486221,
 587967686,
 -1,
 594551755,
 594424080,
 -1,
 594617243,
 594524673,
 -1,
 594682776,
 594597045,
 -1,
 594748280,
 594659233,
 -1,
 594813814,
 594721281,
 -1,
 -56459,
 594762269,
 72867,
 -1,
 594811270,
 72866,
 -56457,
 594762269,
 72859,
 -1,
 594942342,
 72858,
 595141500,
 594709548,
 -1,
 -56454,
 595126687,
 72857,
 -56453,
 595154199,
 72853,
 -1,
 595204486,
 72861,
 595403647,
 595127344,
 -1,
 -56450,
 595352093,
 72870,
 -1,
 595401094,
 72871,
 595600258,
 595376641,
 -1,
 -56447,
 595548701,
 72876,
 -1,
 595597702,
 72877,
 595796869,
 595567279,
 -1,
 -56444,
 595745309,
 72863,
 -1,
 595794310,
 72862,
 595993480,
 595751737,
 -1,
 -56441,
 595941917,
 72851,
 -1,
 595990918,
 72850,
 596190091,
 595933453,
 -1,
 -56438,
 596175966,
 72868,
 -1,
 596187526,
 72860,
 596386702,
 596127139,
 -1,
 -56435,
 596335133,
 72855,
 -1,
 596384134,
 72854,
 -56433,
 596371871,
 72873,
 -56432,
 596566267,
 72869,
 -56431,
 596618560,
 72874,
 -56430,
 596673481,
 72865,
 -56429,
 596735833,
 72875,
 -56428,
 596800043,
 72856,
 -56427,
 596859421,
 72878,
 -56426,
 596923671,
 72852,
 -56425,
 596977552,
 72864,
 -1,
 597039494,
 72879,
 597295103,
 594634617,
 -1,
 -56422,
 597175927,
 72886,
 -1,
 597238309,
 72885,
 597435331,
 594574678,
 -1,
 597500834,
 597411745,
 -1,
 597566368,
 597473793,
 -1,
 -56417,
 597514781,
 72835,
 -1,
 597563782,
 72834,
 -56415,
 597514781,
 72827,
 -1,
 597694854,
 72826,
 597894054,
 597462060,
 -1,
 -56412,
 597879199,
 72825,
 -56411,
 597906711,
 72821,
 -1,
 597956998,
 72829,
 598156201,
 597879856,
 -1,
 -56408,
 598104605,
 72838,
 -1,
 598153606,
 72839,
 598352812,
 598129153,
 -1,
 -56405,
 598301213,
 72844,
 -1,
 598350214,
 72845,
 598549423,
 598319791,
 -1,
 -56402,
 598497821,
 72831,
 -1,
 598546822,
 72830,
 598746034,
 598504249,
 -1,
 -56399,
 598694429,
 72819,
 -1,
 598743430,
 72818,
 598942645,
 598685965,
 -1,
 -56396,
 598928478,
 72836,
 -1,
 598940038,
 72828,
 599139256,
 598879651,
 -1,
 -56393,
 599087645,
 72823,
 -1,
 599136646,
 72822,
 -56391,
 599124383,
 72841,
 -56390,
 599318779,
 72837,
 -56389,
 599371072,
 72842,
 -56388,
 599425993,
 72833,
 -56387,
 599488345,
 72843,
 -56386,
 599552555,
 72824,
 -56385,
 599611933,
 72846,
 -56384,
 599676183,
 72820,
 -56383,
 599730064,
 72832,
 -56382,
 599792006,
 72847,
 -1,
 599854765,
 72840,
 600056777,
 597418038,
 -1,
 -56379,
 600036250,
 72882,
 -56378,
 600085527,
 72884,
 -56377,
 600138669,
 72881,
 -56376,
 600195582,
 72883,
 -1,
 600250955,
 72880,
 -56374,
 600016290,
 72817,
 -1,
 600399024,
 72816,
 -56372,
 594529440,
 129355,
 -1,
 600552130,
 9901,
 600712199,
 594441999,
 -1,
 600777730,
 600647476,
 -1,
 600843230,
 600735062,
 -1,
 600908762,
 600781115,
 -1,
 600974292,
 600864527,
 3453,
 601096191,
 600930063,
 3454,
 -1,
 600995599,
 3414,
 601170902,
 600935468,
 3451,
 -1,
 601132076,
 3450,
 -56361,
 601155876,
 3413,
 -56360,
 601274549,
 3452,
 -56359,
 601326451,
 3412,
 -1,
 601387833,
 3455,
 -56357,
 600887678,
 3386,
 -56356,
 601526552,
 3369,
 -56355,
 601570784,
 3406,
 -1,
 601629427,
 3423,
 601826288,
 600789940,
 -1,
 601891819,
 601790553,
 -1,
 601957347,
 601868193,
 -1,
 -56350,
 601940560,
 3419,
 -1,
 601966855,
 3420,
 602153958,
 601902737,
 -1,
 -56347,
 602119497,
 3417,
 -1,
 602170892,
 3422,
 -56345,
 602128563,
 3446,
 -56344,
 602319833,
 3443,
 -56343,
 602380590,
 3416,
 -56342,
 602430137,
 3444,
 -1,
 602490567,
 3447,
 602734591,
 601869260,
 -1,
 -56339,
 602657436,
 3421,
 -56338,
 602718397,
 3448,
 -56337,
 602778648,
 3445,
 -1,
 602818254,
 3418,
 603005944,
 601800633,
 -1,
 603071477,
 602942883,
 -1,
 -56333,
 603035505,
 3328,
 -56332,
 603090647,
 3388,
 -1,
 603136318,
 3329,
 -56330,
 603053480,
 3387,
 -56329,
 603300874,
 3407,
 -1,
 603334350,
 3389,
 603530236,
 602988624,
 -1,
 603595771,
 603485967,
 3426,
 -1,
 603551503,
 3427,
 -1,
 603568309,
 3396,
 603792385,
 603493197,
 -1,
 603857920,
 603756633,
 -1,
 -56321,
 603835296,
 3442,
 -1,
 603874099,
 3441,
 -1,
 603834888,
 3440,
 -1,
 603732551,
 3449,
 604241919,
 600719872,
 -1,
 604251142,
 604169547,
 -1,
 -56315,
 604225460,
 9894,
 -1,
 604250318,
 9895,
 -1,
 604184747,
 9893,
 604513316,
 600667191,
 -1,
 604578844,
 604470614,
 -1,
 604644365,
 604539948,
 -1,
 -56309,
 604629407,
 73451,
 -56308,
 604656919,
 73442,
 -1,
 604707206,
 73448,
 -56306,
 604629407,
 73452,
 -56305,
 604888003,
 73455,
 -56304,
 604948519,
 73446,
 -56303,
 605010646,
 73456,
 -56302,
 605072704,
 73453,
 -56301,
 605135627,
 73443,
 -56300,
 605193161,
 73445,
 -56299,
 605255513,
 73454,
 -56298,
 605320075,
 73440,
 -56297,
 605385259,
 73450,
 -56296,
 605443351,
 73441,
 -56295,
 605501852,
 73447,
 -56294,
 605564378,
 73449,
 -56293,
 605628304,
 73444,
 -1,
 605690246,
 73457,
 605889569,
 604561462,
 -1,
 -56290,
 605868954,
 73460,
 -56289,
 605918231,
 73462,
 -56288,
 605971373,
 73459,
 -1,
 606028286,
 73461,
 -56286,
 605856924,
 73463,
 -56285,
 606160989,
 73464,
 -1,
 606216565,
 73458,
 606413888,
 604498422,
 -1,
 606479405,
 606390177,
 -1,
 606544937,
 606462139,
 -1,
 -56280,
 606508055,
 119522,
 -1,
 606553981,
 119532,
 606741548,
 606493195,
 -1,
 -56277,
 606711982,
 119523,
 -1,
 606760716,
 119533,
 -1,
 606685127,
 119530,
 607003698,
 606452225,
 -1,
 607069232,
 606957936,
 119526,
 -1,
 607046107,
 119536,
 607256575,
 607014037,
 119527,
 -1,
 607177179,
 119537,
 607331384,
 606949009,
 -1,
 607396917,
 607297277,
 119524,
 -1,
 607373787,
 119534,
 607584255,
 607347629,
 -1,
 -56265,
 607509656,
 119525,
 -1,
 607540374,
 119535,
 607724604,
 607273470,
 -1,
 607790139,
 607676109,
 119528,
 -1,
 607733078,
 119538,
 -1,
 607747501,
 119531,
 607986750,
 607686728,
 119529,
 -1,
 607963611,
 119539,
 -56257,
 607972635,
 119520,
 -1,
 608082005,
 119521,
 608248915,
 606390177,
 -1,
 608314450,
 608198030,
 -1,
 608379975,
 608285371,
 -1,
 608445510,
 608327565,
 -1,
 -56251,
 608428988,
 10221,
 -1,
 608457092,
 10223,
 -1,
 608419868,
 10187,
 608707658,
 608336624,
 -1,
 -56247,
 608691132,
 10220,
 -1,
 608719236,
 10222,
 608904269,
 608661552,
 -1,
 -56244,
 608858637,
 120485,
 -1,
 608920493,
 120484,
 609100880,
 608840648,
 -1,
 -56241,
 609075571,
 120779,
 -1,
 609103547,
 120778,
 -56239,
 609074162,
 120001,
 -1,
 609242900,
 10189,
 -1,
 608256585,
 129481,
 609494102,
 608215727,
 -1,
 -56235,
 609450519,
 127809,
 -1,
 609487263,
 9967,
 609690713,
 609440968,
 -1,
 -56232,
 609652478,
 129522,
 -1,
 609698302,
 129497,
 -1,
 609675447,
 128470,
 609953246,
 571839511,
 -1,
 610018713,
 609892621,
 -1,
 610084248,
 609969069,
 -1,
 610149677,
 610029574,
 -1,
 610215212,
 610106710,
 -1,
 610280636,
 610187777,
 -1,
 610346166,
 610239657,
 -1,
 610411631,
 610322337,
 7511,
 610477164,
 610392623,
 -1,
 610542694,
 610408838,
 7492,
 -56219,
 610501235,
 7579,
 -1,
 610550270,
 7494,
 610739304,
 610501491,
 7514,
 -1,
 610667899,
 7597,
 -56215,
 610720688,
 7610,
 -56214,
 610835232,
 7500,
 -56213,
 610886573,
 7502,
 -1,
 610949643,
 7587,
 -56211,
 610441931,
 7508,
 -56210,
 611081732,
 7615,
 -1,
 611126724,
 7605,
 611329144,
 610348451,
 7580,
 611394678,
 611263069,
 -1,
 611460211,
 611345325,
 7590,
 -1,
 611388986,
 7591,
 -56204,
 611439514,
 7608,
 -56203,
 611552300,
 7600,
 -1,
 611612431,
 7595,
 -56201,
 611343953,
 7521,
 -1,
 611716063,
 7581,
 611918975,
 611284751,
 -1,
 611984510,
 611847010,
 -1,
 -56197,
 611955168,
 7593,
 -56196,
 612017004,
 7594,
 -56195,
 612075696,
 43870,
 -1,
 612134248,
 43869,
 -1,
 611935870,
 43001,
 612377732,
 611860990,
 7497,
 -56191,
 612363608,
 7614,
 -56190,
 612420286,
 7582,
 -56189,
 612482383,
 7604,
 -1,
 612536145,
 7505,
 612705417,
 612357018,
 7512,
 612770952,
 612630528,
 -1,
 -56185,
 612754608,
 43871,
 -1,
 612771892,
 7606,
 -1,
 612739569,
 7607,
 613033103,
 612678145,
 -1,
 613098637,
 612969891,
 -1,
 -56180,
 613070497,
 7586,
 -1,
 613114756,
 7498,
 -56178,
 613049738,
 7513,
 -1,
 613223636,
 7603,
 613426323,
 612968287,
 7495,
 -56175,
 613391928,
 7509,
 -56174,
 613436296,
 7517,
 -1,
 613491692,
 7601,
 613688471,
 613411888,
 7611,
 613810175,
 613616482,
 -1,
 -56170,
 613724640,
 7612,
 -1,
 613759107,
 7613,
 613950619,
 613651479,
 7506,
 614072319,
 613917997,
 -1,
 -56166,
 613979159,
 7507,
 -1,
 614023678,
 7499,
 614212767,
 613897416,
 7501,
 614334463,
 614183171,
 -1,
 -56162,
 614245924,
 7520,
 -1,
 614290843,
 7518,
 614474914,
 614152461,
 7496,
 -56159,
 614440479,
 7585,
 -1,
 614483832,
 7519,
 614671525,
 614406534,
 7491,
 -56156,
 614630003,
 7493,
 -1,
 614688942,
 7516,
 614868135,
 614652848,
 7515,
 -1,
 614796500,
 7609,
 614999209,
 614834863,
 7510,
 -1,
 614948433,
 7602,
 615130284,
 614960200,
 -1,
 -56149,
 615100896,
 7599,
 -1,
 615152461,
 7598,
 615326894,
 615089011,
 7504,
 -1,
 615255252,
 7596,
 615457969,
 615277485,
 -1,
 -56144,
 615423421,
 7589,
 -1,
 615452218,
 7588,
 -56142,
 615428673,
 7583,
 -56141,
 615609145,
 7503,
 -56140,
 615674391,
 7592,
 -56139,
 615734700,
 43868,
 -1,
 615796369,
 7584,
 615982265,
 610324421,
 -1,
 -56136,
 615940611,
 42785,
 -1,
 615997178,
 42784,
 616235007,
 615930379,
 -1,
 -56133,
 616144164,
 42890,
 -1,
 616187720,
 765,
 616375528,
 610217379,
 -1,
 616441048,
 616309341,
 -1,
 616506562,
 616410310,
 7487,
 616628223,
 616451347,
 -1,
 -56127,
 616533036,
 7483,
 -1,
 616579582,
 7474,
 616768708,
 616469527,
 7484,
 -1,
 616747930,
 7485,
 616899782,
 616716811,
 7476,
 -1,
 616828474,
 43000,
 617030856,
 616834911,
 7470,
 -1,
 616965092,
 7471,
 617161930,
 616962438,
 7468,
 -1,
 617103870,
 7469,
 -56117,
 617144507,
 7490,
 -56116,
 617274288,
 11389,
 -56115,
 617337754,
 7489,
 -56114,
 617400225,
 7488,
 -56113,
 617456303,
 7486,
 -56112,
 617516076,
 7482,
 -56111,
 617579379,
 7481,
 -56110,
 617641743,
 7480,
 -56109,
 617706297,
 7479,
 -56108,
 617771533,
 7478,
 -56107,
 617833389,
 7477,
 -56106,
 617895112,
 7475,
 -56105,
 617955838,
 7473,
 -1,
 618019085,
 7472,
 618210531,
 616390478,
 -1,
 618276062,
 618162353,
 -1,
 -56101,
 618249726,
 42754,
 -56100,
 618314068,
 42758,
 -56099,
 618376055,
 42756,
 -1,
 618440339,
 42752,
 618659839,
 618209622,
 -1,
 -56096,
 618577406,
 42755,
 -56095,
 618641748,
 42759,
 -56094,
 618703735,
 42757,
 -1,
 618768019,
 42753,
 618931431,
 618195985,
 -1,
 -56091,
 618906224,
 42653,
 -56090,
 618945603,
 42652,
 -1,
 619005895,
 7544,
 -1,
 618895124,
 42889,
 619259131,
 616333717,
 -1,
 619324666,
 619184128,
 -1,
 619390190,
 619281131,
 -1,
 619455725,
 619315423,
 767,
 -1,
 619404453,
 753,
 -1,
 619384823,
 42773,
 619652339,
 619330834,
 -1,
 619717874,
 619630919,
 -1,
 -56079,
 619695769,
 42763,
 -1,
 619740154,
 42768,
 -1,
 619701691,
 751,
 619980022,
 619623099,
 -1,
 -56075,
 619941713,
 755,
 -1,
 619992978,
 754,
 -56073,
 619960365,
 752,
 -56072,
 620154143,
 759,
 -56071,
 620195150,
 42783,
 -1,
 620245677,
 42888,
 -1,
 619268647,
 42778,
 620504332,
 619201022,
 -1,
 620569865,
 620488970,
 -1,
 620635395,
 620528025,
 -1,
 620700929,
 620576274,
 -1,
 -56064,
 620678809,
 42764,
 -1,
 620723194,
 42769,
 -56062,
 620657658,
 42774,
 -1,
 620842568,
 983993,
 621084671,
 620584642,
 -1,
 621094151,
 620969490,
 -1,
 -56058,
 621072025,
 42760,
 -1,
 621116410,
 42765,
 -56056,
 621050874,
 42770,
 -1,
 621235812,
 983992,
 621477887,
 620531028,
 -1,
 -56053,
 621380099,
 764,
 -1,
 621436666,
 762,
 621618455,
 620464150,
 -1,
 621683986,
 621559043,
 -1,
 621749521,
 621624948,
 -1,
 -56048,
 621697317,
 757,
 -1,
 621747146,
 758,
 -1,
 621697317,
 756,
 622067711,
 621608960,
 -1,
 622077206,
 621952530,
 -1,
 -56043,
 622055065,
 42762,
 -1,
 622099450,
 42767,
 -1,
 622033914,
 42772,
 622339357,
 621587914,
 -1,
 -56039,
 622319652,
 42779,
 -56038,
 622357838,
 42782,
 -56037,
 622415226,
 42781,
 -56036,
 622477285,
 42780,
 -1,
 622539862,
 760,
 622732578,
 622288578,
 -1,
 622798113,
 622673426,
 -1,
 -56032,
 622775961,
 42761,
 -1,
 622820346,
 42766,
 -1,
 622754810,
 42771,
 623060262,
 622673239,
 -1,
 -56028,
 623041947,
 42775,
 -56027,
 623100164,
 42776,
 -1,
 623141095,
 42777,
 623322409,
 622995752,
 -1,
 -56024,
 623280643,
 763,
 -1,
 623337210,
 761,
 -56022,
 623303342,
 42864,
 -56021,
 623483748,
 766,
 -1,
 623531739,
 4348,
 -1,
 610151580,
 43867,
 623837183,
 610074624,
 -1,
 623846766,
 623738198,
 -1,
 623912246,
 623827888,
 -1,
 623977781,
 623875245,
 -1,
 624043315,
 623946950,
 71174,
 -1,
 624012486,
 71175,
 624230399,
 623998735,
 71176,
 -1,
 624129807,
 71177,
 -1,
 623909254,
 71210,
 624371004,
 623888289,
 -1,
 624436538,
 624347041,
 -1,
 -56007,
 624384541,
 71193,
 -1,
 624433542,
 71192,
 -56005,
 624384541,
 71198,
 -1,
 624564614,
 71197,
 624764225,
 624331820,
 -1,
 -56002,
 624748959,
 71191,
 -56001,
 624790646,
 71196,
 -56000,
 624842007,
 71186,
 -1,
 624892294,
 71201,
 625091911,
 624703757,
 -1,
 625157445,
 625031437,
 -1,
 -55996,
 625105437,
 71195,
 -1,
 625154438,
 71194,
 -55994,
 625105437,
 71200,
 -1,
 625285510,
 71199,
 625485131,
 625023366,
 71168,
 -55991,
 625464218,
 71181,
 -55990,
 625501101,
 71179,
 -1,
 625547654,
 71169,
 625747279,
 625457665,
 -1,
 -55987,
 625720022,
 71212,
 -55986,
 625760797,
 71211,
 -1,
 625809798,
 71213,
 626009425,
 625726362,
 71172,
 -1,
 625988506,
 71173,
 626140500,
 625975983,
 -1,
 -55981,
 626088477,
 71203,
 -1,
 626137478,
 71202,
 626337111,
 626095887,
 -1,
 -55978,
 626292569,
 71215,
 -1,
 626334086,
 71209,
 626533722,
 626291513,
 -1,
 -55975,
 626481693,
 71183,
 -1,
 626530694,
 71182,
 626730333,
 626487821,
 -1,
 -55972,
 626678301,
 71190,
 -1,
 626727302,
 71189,
 626926943,
 626680749,
 71170,
 -1,
 626877357,
 71171,
 627058018,
 626873544,
 -1,
 -55967,
 627005981,
 71185,
 -1,
 627054982,
 71184,
 627254629,
 626994595,
 -1,
 -55964,
 627202589,
 71188,
 -1,
 627251590,
 71187,
 627451240,
 627189599,
 -1,
 -55961,
 627399197,
 71205,
 -1,
 627448198,
 71204,
 -55959,
 627435935,
 71207,
 -55958,
 627617088,
 71208,
 -55957,
 627676183,
 71180,
 -55956,
 627737545,
 71206,
 -55955,
 627792413,
 71214,
 -1,
 627851774,
 71178,
 628041086,
 623829046,
 -1,
 628106612,
 628023133,
 -1,
 628172146,
 628075718,
 71221,
 -1,
 628141254,
 71222,
 628359167,
 628127503,
 71223,
 -1,
 628258575,
 71224,
 628434296,
 628038022,
 -1,
 -55946,
 628413338,
 71228,
 -55945,
 628450221,
 71226,
 -1,
 628496774,
 71216,
 628696442,
 628413338,
 71219,
 -1,
 628675482,
 71220,
 628827516,
 628646829,
 71217,
 -1,
 628777901,
 71218,
 -55939,
 628790295,
 71227,
 -1,
 628900350,
 71225,
 629089679,
 627980557,
 -1,
 629155213,
 629040994,
 -1,
 629220739,
 629131169,
 -1,
 -55934,
 629204502,
 71250,
 -1,
 629236192,
 71251,
 629417350,
 629193217,
 -1,
 -55931,
 629371248,
 71254,
 -1,
 629427349,
 71255,
 629613961,
 629362321,
 -1,
 -55928,
 629579517,
 71252,
 -1,
 629633214,
 71253,
 -55926,
 629599515,
 71248,
 -55925,
 629774421,
 71249,
 -55924,
 629837896,
 71257,
 -1,
 629884550,
 71256,
 -55922,
 629120646,
 71234,
 -1,
 630006046,
 71233,
 630203799,
 629063609,
 -1,
 630269331,
 630185661,
 -1,
 -55918,
 630242225,
 71230,
 -1,
 630304345,
 71231,
 630465942,
 630200710,
 -1,
 -55915,
 630435724,
 71232,
 -1,
 630494098,
 71229,
 -1,
 630416249,
 71236,
 -1,
 630135495,
 71235,
 -1,
 610028215,
 129339,
 630859197,
 609979436,
 -1,
 630924719,
 630806696,
 -1,
 630990239,
 630900516,
 71273,
 631111679,
 630917986,
 -1,
 -55906,
 631020797,
 71274,
 -1,
 631062388,
 71275,
 631252387,
 630962250,
 71265,
 631373823,
 631180130,
 -1,
 -55902,
 631282941,
 71269,
 -1,
 631324532,
 71270,
 631514534,
 631228321,
 -1,
 -55899,
 631495250,
 71276,
 -1,
 631551558,
 71267,
 631711145,
 631471446,
 -1,
 -55896,
 631670051,
 6314,
 -1,
 631713907,
 6264,
 631907755,
 631663878,
 71271,
 -1,
 631835751,
 71272,
 632038830,
 631843478,
 -1,
 -55891,
 632003837,
 71264,
 -1,
 632045428,
 71268,
 -1,
 631979700,
 71266,
 632300982,
 630887447,
 -1,
 632366517,
 632248534,
 -1,
 632432052,
 632351012,
 -1,
 -55885,
 632383662,
 9867,
 -1,
 632430930,
 9866,
 -1,
 632374139,
 119552,
 -1,
 632335800,
 128669,
 632759739,
 632245887,
 -1,
 632825274,
 632684544,
 -1,
 -55879,
 632808842,
 128184,
 -1,
 632825805,
 128176,
 -1,
 632754009,
 129297,
 633143295,
 632714521,
 128018,
 -1,
 633012924,
 128053,
 633218504,
 630838170,
 -1,
 633284037,
 633180826,
 -1,
 633349572,
 633216452,
 9968,
 633470975,
 633274368,
 -1,
 -55870,
 633384381,
 128670,
 -55869,
 633417212,
 128672,
 -1,
 633481769,
 128693,
 -1,
 633275136,
 128507,
 633742791,
 633256985,
 128001,
 -1,
 633668284,
 128045,
 -1,
 633719486,
 128068,
 633939408,
 633194401,
 -1,
 634004943,
 633904165,
 -1,
 634070477,
 633929728,
 -1,
 -55860,
 634043364,
 128757,
 -1,
 634071980,
 128741,
 -55858,
 634053117,
 128739,
 -1,
 634221044,
 129468,
 -1,
 633953717,
 129334,
 634463701,
 633902103,
 -1,
 634529236,
 634424366,
 -1,
 -55853,
 634511075,
 127889,
 -1,
 634531341,
 129390,
 -1,
 634468626,
 128496,
 634791385,
 634399312,
 128241,
 634912767,
 634716160,
 -1,
 -55848,
 634840315,
 128242,
 -1,
 634885509,
 128244,
 635053532,
 634766169,
 -1,
 -55845,
 635007130,
 129439,
 -1,
 635060734,
 128332,
 -55843,
 635038138,
 128511,
 -1,
 635231954,
 127909,
 635381421,
 609903533,
 -1,
 635446942,
 635314749,
 -1,
 635512413,
 635403606,
 -1,
 635577845,
 635488161,
 -1,
 635643370,
 635541801,
 -1,
 -55836,
 635574307,
 94105,
 -55835,
 635639619,
 94104,
 -55834,
 635704947,
 94103,
 -55833,
 635770238,
 94102,
 -55832,
 635835562,
 94101,
 -55831,
 635900812,
 94100,
 -1,
 635966055,
 94099,
 636167663,
 635615745,
 -1,
 -55828,
 636140246,
 93994,
 -55827,
 636181021,
 93998,
 -55826,
 636240382,
 94025,
 -1,
 636295558,
 94007,
 636495346,
 636124666,
 -1,
 -55823,
 636479903,
 93980,
 -1,
 636492166,
 93978,
 -55821,
 636471335,
 93966,
 -55820,
 636633598,
 94024,
 -1,
 636688774,
 93962,
 636888578,
 635538476,
 -1,
 636954105,
 636872996,
 -1,
 -55816,
 636901917,
 93997,
 -1,
 636950918,
 93996,
 637150716,
 636914732,
 -1,
 -55813,
 637098525,
 93973,
 -1,
 637147526,
 93972,
 637347327,
 637097160,
 -1,
 -55810,
 637295133,
 93988,
 -1,
 637344134,
 93987,
 637543937,
 637278598,
 93968,
 -1,
 637516583,
 94032,
 -1,
 637491741,
 93969,
 637740558,
 636873776,
 -1,
 637806089,
 637725744,
 -1,
 637871623,
 637778433,
 -1,
 -55802,
 637856159,
 94017,
 -1,
 637868422,
 94014,
 -55800,
 637856159,
 94016,
 -1,
 637999494,
 94013,
 638199308,
 637778433,
 -1,
 -55797,
 638147101,
 94006,
 -1,
 638196102,
 94012,
 -55795,
 638147101,
 94005,
 -1,
 638327174,
 94011,
 638527001,
 637725368,
 -1,
 638592533,
 638502817,
 -1,
 638658067,
 638564865,
 -1,
 -55790,
 638605853,
 94000,
 -1,
 638654854,
 94009,
 -55788,
 638634023,
 93964,
 -1,
 638785926,
 93965,
 -55786,
 638558987,
 93954,
 -55785,
 638947593,
 93970,
 -55784,
 639005579,
 93984,
 -1,
 639058425,
 94001,
 639247908,
 638495942,
 -1,
 639313443,
 639190460,
 -1,
 639378978,
 639277353,
 -1,
 -55779,
 639309859,
 94111,
 -55778,
 639374963,
 94110,
 -55777,
 639440254,
 94109,
 -55776,
 639505578,
 94108,
 -55775,
 639570535,
 94107,
 -1,
 639635772,
 94106,
 -1,
 639352218,
 94002,
 -1,
 639289714,
 94026,
 639968815,
 639187213,
 -1,
 640034346,
 639953968,
 -1,
 -55769,
 640019550,
 93995,
 -55768,
 640084661,
 94023,
 -55767,
 640113181,
 93999,
 -1,
 640162182,
 94008,
 640362029,
 639991290,
 -1,
 -55764,
 640346527,
 93981,
 -1,
 640358790,
 93979,
 -55762,
 640301468,
 93967,
 -1,
 640489862,
 93963,
 640689719,
 639900038,
 -1,
 640755254,
 640659238,
 -1,
 640820788,
 640715820,
 -1,
 -55757,
 640767255,
 93989,
 -1,
 640817542,
 93971,
 -55755,
 640806372,
 94015,
 -1,
 640975817,
 93958,
 -1,
 640702987,
 94019,
 641214012,
 640662017,
 -1,
 -55751,
 641198773,
 94022,
 -55750,
 641252054,
 94004,
 -55749,
 641292829,
 94003,
 -1,
 641341830,
 94010,
 641541698,
 641169167,
 -1,
 641607232,
 641489419,
 -1,
 -55745,
 641591711,
 93977,
 -1,
 641603974,
 93976,
 -55743,
 641591711,
 93975,
 -1,
 641735046,
 93974,
 641934919,
 641488072,
 -1,
 642000454,
 641882635,
 -1,
 -55739,
 641948189,
 93993,
 -1,
 641997190,
 93992,
 -1,
 641931654,
 93983,
 642262602,
 641915824,
 -1,
 -55735,
 642207462,
 93961,
 -1,
 642259334,
 93960,
 642459213,
 642231041,
 -1,
 -55732,
 642405655,
 93986,
 -1,
 642455942,
 93985,
 642655824,
 642425519,
 -1,
 -55729,
 642611033,
 93955,
 -1,
 642652550,
 93952,
 642852435,
 642614131,
 -1,
 -55726,
 642800157,
 93957,
 -1,
 642849158,
 93956,
 643049046,
 642800139,
 -1,
 -55723,
 642996765,
 94020,
 -1,
 643045766,
 93990,
 643245657,
 642983775,
 -1,
 -55720,
 643216059,
 94021,
 -1,
 643242374,
 93953,
 -55718,
 643229750,
 93991,
 -55717,
 643424507,
 94018,
 -55716,
 643462027,
 93982,
 -1,
 643518182,
 93959,
 643704467,
 635494454,
 -1,
 643769961,
 643654573,
 94049,
 643835490,
 643701126,
 94050,
 643956735,
 643796012,
 94051,
 -1,
 643847368,
 94052,
 644032100,
 643798039,
 94053,
 -1,
 643993425,
 94086,
 -55707,
 644010906,
 94056,
 -55706,
 644124497,
 94057,
 -55705,
 644178861,
 94055,
 -55704,
 644240584,
 94084,
 -1,
 644301310,
 94054,
 644490866,
 643748762,
 94058,
 644556397,
 644422022,
 94059,
 644677631,
 644516908,
 94060,
 -1,
 644568264,
 94061,
 -55698,
 644535194,
 94062,
 -55697,
 644715940,
 94079,
 -55696,
 644779857,
 94064,
 -55695,
 644834221,
 94087,
 -1,
 644892277,
 94063,
 645080699,
 644422022,
 94036,
 645146229,
 645041196,
 94039,
 -1,
 645092552,
 94040,
 645277303,
 645087742,
 94067,
 -1,
 645218814,
 94068,
 -55688,
 645256090,
 94075,
 -55687,
 645358509,
 94073,
 -55686,
 645422666,
 94038,
 -1,
 645470598,
 94037,
 645670530,
 645022206,
 94045,
 645736062,
 645639366,
 94071,
 -1,
 645704902,
 94069,
 645867136,
 645696556,
 94046,
 -1,
 645813448,
 94047,
 -55679,
 645817261,
 94074,
 -1,
 645929350,
 94085,
 646129289,
 645633047,
 94041,
 646194822,
 646070782,
 -1,
 -55675,
 646179108,
 94048,
 -1,
 646229190,
 94082,
 -55673,
 646173594,
 94076,
 -55672,
 646353943,
 94042,
 -1,
 646403272,
 94081,
 646588044,
 646113572,
 94065,
 -55669,
 646567487,
 94080,
 -1,
 646603693,
 94066,
 646784654,
 646570171,
 94044,
 -1,
 646747159,
 94043,
 646915728,
 646756496,
 94072,
 -1,
 646884550,
 94070,
 647046802,
 646876204,
 94077,
 -1,
 646993096,
 94078,
 -1,
 647028896,
 94083,
 647243416,
 643681939,
 -1,
 -55659,
 647220941,
 94096,
 -55658,
 647279461,
 94095,
 -55657,
 647309642,
 94098,
 -1,
 647371486,
 94097,
 647626751,
 647217081,
 -1,
 647636636,
 647541001,
 -1,
 -55653,
 647618475,
 94034,
 -1,
 647636254,
 94035,
 -55651,
 647574849,
 94031,
 -1,
 647767326,
 94033,
 647964326,
 635385459,
 -1,
 648029859,
 647926807,
 -1,
 -55647,
 648002540,
 128300,
 -55646,
 648062512,
 127908,
 -1,
 648096005,
 129440,
 648347647,
 647954432,
 -1,
 -55643,
 648255505,
 983235,
 -1,
 648297006,
 983236,
 648488618,
 647925757,
 -1,
 -55640,
 648448441,
 128469,
 -55639,
 648494285,
 128189,
 -1,
 648555848,
 128656,
 648806399,
 648443663,
 -1,
 -55636,
 648705772,
 127756,
 -1,
 648769606,
 127894,
 648947583,
 635365896,
 -1,
 649013012,
 648902415,
 -1,
 649078544,
 648956865,
 -1,
 649144015,
 649050625,
 -1,
 649209550,
 649091595,
 -1,
 649275083,
 649142344,
 -1,
 649340599,
 649235500,
 -1,
 -55627,
 649324959,
 4218,
 -55626,
 649366646,
 43491,
 -1,
 649402758,
 4220,
 649602746,
 649294649,
 -1,
 -55623,
 649550365,
 4214,
 -1,
 649599366,
 4213,
 649799357,
 649549000,
 -1,
 -55620,
 649746973,
 43488,
 -1,
 649795974,
 4215,
 649995968,
 649735587,
 -1,
 -55617,
 649943581,
 43489,
 -1,
 649992582,
 4216,
 650192579,
 649930591,
 -1,
 -55614,
 650140189,
 43492,
 -1,
 650189190,
 4223,
 -55612,
 650177630,
 4217,
 -55611,
 650365650,
 4224,
 -55610,
 650421781,
 4221,
 -55609,
 650474146,
 43490,
 -55608,
 650533405,
 4225,
 -55607,
 650596070,
 4222,
 -55606,
 650656156,
 4219,
 -1,
 650713478,
 4130,
 650969087,
 649257509,
 -1,
 -55603,
 650886554,
 43647,
 -1,
 650915951,
 43646,
 -1,
 649156111,
 4193,
 651175658,
 649098550,
 -1,
 651241173,
 651114765,
 -1,
 651306708,
 651180301,
 -1,
 -55597,
 651254301,
 43625,
 -1,
 651303302,
 43624,
 -1,
 651254301,
 43626,
 651568856,
 651219260,
 -1,
 -55593,
 651516445,
 43623,
 -1,
 651565446,
 43622,
 651765467,
 651529260,
 -1,
 -55590,
 651749791,
 43621,
 -1,
 651762054,
 43627,
 651962078,
 651719181,
 -1,
 -55587,
 651909661,
 43620,
 -1,
 651958662,
 43619,
 652158689,
 651909643,
 -1,
 -55584,
 652106269,
 43630,
 -1,
 652155270,
 43629,
 652355300,
 652094883,
 -1,
 -55581,
 652302877,
 43618,
 -1,
 652351878,
 43617,
 -55579,
 652340318,
 43634,
 -55578,
 652535862,
 43633,
 -55577,
 652589782,
 43628,
 -55576,
 652651840,
 43635,
 -55575,
 652694807,
 43616,
 -1,
 652758758,
 43631,
 652945151,
 651151494,
 -1,
 653010673,
 652884237,
 -1,
 653076207,
 652949773,
 -1,
 -55570,
 653023773,
 43502,
 -1,
 653072774,
 43501,
 -55568,
 653023773,
 43516,
 -1,
 653203846,
 43515,
 653403892,
 652971052,
 -1,
 -55565,
 653388191,
 43495,
 -1,
 653429878,
 43503,
 653600503,
 653357581,
 -1,
 -55562,
 653548061,
 43500,
 -1,
 653597062,
 43499,
 653797114,
 653546696,
 -1,
 -55559,
 653744669,
 43498,
 -1,
 653793670,
 43497,
 653993725,
 653731679,
 -1,
 -55556,
 653941277,
 43518,
 -1,
 653990278,
 43517,
 -55554,
 653950953,
 43514,
 -1,
 654135014,
 43496,
 654321414,
 652905062,
 -1,
 654386947,
 654256355,
 -1,
 -55550,
 654328318,
 4189,
 -1,
 654383494,
 4188,
 -55548,
 654348180,
 4186,
 -55547,
 654537378,
 4187,
 -1,
 654590462,
 4136,
 654780170,
 654263232,
 -1,
 -55544,
 654765100,
 4207,
 -55543,
 654807305,
 4206,
 -1,
 654858199,
 4208,
 655042317,
 654762662,
 -1,
 -55540,
 655018706,
 4197,
 -1,
 655076086,
 4198,
 -55538,
 655014264,
 4238,
 -55537,
 655186238,
 4159,
 -1,
 655236682,
 43642,
 655491071,
 649041328,
 -1,
 -55534,
 655403878,
 43637,
 -55533,
 655463528,
 43636,
 -1,
 655515652,
 43638,
 655697735,
 648985089,
 -1,
 655763249,
 655648633,
 -1,
 655828770,
 655736278,
 -1,
 655894300,
 655806124,
 -1,
 -55527,
 655824499,
 4234,
 -55526,
 655889790,
 4233,
 -55525,
 655954828,
 4232,
 -1,
 656020071,
 4231,
 656221985,
 655832667,
 -1,
 656287520,
 656199340,
 -1,
 -55521,
 656216972,
 4236,
 -1,
 656282215,
 4235,
 -1,
 656230329,
 4237,
 -1,
 656194504,
 43493,
 656615208,
 655811257,
 -1,
 -55516,
 656545150,
 4205,
 -55515,
 656610474,
 4204,
 -55514,
 656675724,
 4203,
 -55513,
 656740967,
 4202,
 -1,
 656806204,
 4201,
 657008427,
 656590993,
 -1,
 -55510,
 656938366,
 43645,
 -1,
 657003111,
 43644,
 657205038,
 656962899,
 -1,
 -55507,
 657134476,
 4251,
 -1,
 657199420,
 4250,
 -55505,
 657176969,
 4239,
 -55504,
 657367997,
 43643,
 -1,
 657401049,
 4154,
 657598271,
 655711071,
 -1,
 657663797,
 657573793,
 -1,
 -55500,
 657647126,
 4242,
 -1,
 657678816,
 4243,
 657860408,
 657635841,
 -1,
 -55497,
 657813872,
 4246,
 -1,
 657869973,
 4247,
 658057019,
 657804945,
 -1,
 -55494,
 658022141,
 4244,
 -1,
 658075838,
 4245,
 -55492,
 658042139,
 4240,
 -55491,
 658217045,
 4241,
 -55490,
 658280520,
 4249,
 -1,
 658327174,
 4248,
 658571263,
 657582928,
 -1,
 658581316,
 658447931,
 -1,
 -55486,
 658559675,
 43641,
 -55485,
 658610261,
 43640,
 -1,
 658656622,
 43639,
 658898943,
 658554326,
 -1,
 -55482,
 658806869,
 4254,
 -1,
 658853230,
 4255,
 659040094,
 655679542,
 -1,
 659105615,
 659012097,
 -1,
 659171150,
 659053402,
 -1,
 659236684,
 659112446,
 4228,
 -1,
 659161093,
 4229,
 -55475,
 659181724,
 4230,
 -1,
 659298891,
 4227,
 -1,
 659117570,
 4194,
 659564371,
 659059870,
 -1,
 -55471,
 659542938,
 4211,
 -55470,
 659592531,
 4210,
 -1,
 659637517,
 4212,
 659826518,
 659546790,
 -1,
 -55467,
 659805672,
 4200,
 -1,
 659835889,
 4199,
 660023129,
 659786342,
 -1,
 -55464,
 659985431,
 4148,
 -1,
 660039628,
 4147,
 660219739,
 659955266,
 4252,
 -1,
 660169645,
 4253,
 -55460,
 660195570,
 4139,
 -55459,
 660297353,
 4209,
 -1,
 660357635,
 4149,
 660547440,
 659015585,
 -1,
 660612973,
 660479379,
 -1,
 660678499,
 660588449,
 -1,
 -55454,
 660661782,
 43506,
 -1,
 660693472,
 43507,
 660875110,
 660650497,
 -1,
 -55451,
 660828528,
 43510,
 -1,
 660884629,
 43511,
 661071721,
 660819601,
 -1,
 -55448,
 661036797,
 43508,
 -1,
 661090494,
 43509,
 -55446,
 661056795,
 43504,
 -55445,
 661231701,
 43505,
 -55444,
 661295176,
 43513,
 -1,
 661341830,
 43512,
 661585919,
 660576471,
 -1,
 -55441,
 661484741,
 4196,
 -1,
 661544050,
 4195,
 661727100,
 660485464,
 -1,
 661792635,
 661685107,
 -1,
 661858167,
 661734617,
 -1,
 -55436,
 661842335,
 4155,
 -55435,
 661905659,
 4157,
 -55434,
 661957952,
 4156,
 -1,
 662002205,
 4158,
 662241279,
 661821420,
 -1,
 -55431,
 662146166,
 4190,
 -55430,
 662209481,
 4191,
 -1,
 662271833,
 4192,
 -1,
 661765596,
 4226,
 662568959,
 661686816,
 -1,
 -55426,
 662486507,
 43494,
 -1,
 662533438,
 43632,
 662710224,
 648926106,
 -1,
 662775734,
 662667951,
 -1,
 662841269,
 662708660,
 -1,
 662906804,
 662797654,
 -1,
 662972298,
 662845709,
 -1,
 663037832,
 662911245,
 -1,
 -55418,
 662985245,
 70292,
 -55417,
 663042460,
 70291,
 -1,
 663099782,
 70290,
 -55415,
 662985245,
 70297,
 -1,
 663230854,
 70296,
 663431056,
 662947745,
 -1,
 663496590,
 663406497,
 -1,
 -55411,
 663443997,
 70289,
 -1,
 663492998,
 70288,
 -55409,
 663443997,
 70295,
 -1,
 663624070,
 70294,
 663824276,
 663399622,
 -1,
 -55406,
 663792960,
 70311,
 -55405,
 663837213,
 70312,
 -1,
 663886214,
 70306,
 664086424,
 663784492,
 -1,
 -55402,
 664070559,
 70287,
 -55401,
 664112246,
 70293,
 -1,
 664148358,
 70298,
 664348571,
 664052399,
 -1,
 -55398,
 664295965,
 70300,
 -1,
 664344966,
 70299,
 664545182,
 664302393,
 -1,
 -55395,
 664492573,
 70277,
 -1,
 664541574,
 70276,
 664741793,
 664498701,
 -1,
 -55392,
 664695339,
 70285,
 -1,
 664738182,
 70284,
 664938404,
 664687816,
 -1,
 -55389,
 664885789,
 70280,
 -1,
 664934790,
 70278,
 665135015,
 664874403,
 -1,
 -55386,
 665082397,
 70283,
 -1,
 665131398,
 70282,
 665331626,
 665069407,
 -1,
 -55383,
 665279005,
 70303,
 -1,
 665328006,
 70301,
 -55381,
 665315743,
 70305,
 -55380,
 665508803,
 70308,
 -55379,
 665572250,
 70274,
 -55378,
 665631446,
 70309,
 -55377,
 665682889,
 70304,
 -55376,
 665745241,
 70307,
 -55375,
 665805741,
 70273,
 -55374,
 665868829,
 70310,
 -55373,
 665928190,
 70275,
 -1,
 665983366,
 70272,
 -1,
 662879295,
 70313,
 -1,
 662793710,
 127926,
 666370047,
 662747649,
 -1,
 666380239,
 666264800,
 -1,
 666445772,
 666352129,
 -1,
 666511307,
 666430288,
 -1,
 666576842,
 666465673,
 -1,
 666642368,
 666518014,
 -1,
 666707903,
 666593092,
 -1,
 -55362,
 666687517,
 119271,
 -1,
 666714074,
 119270,
 -1,
 666668388,
 119263,
 666970051,
 666610680,
 -1,
 -55358,
 666949661,
 119269,
 -1,
 666976218,
 119268,
 667166662,
 666914449,
 -1,
 -55355,
 667121956,
 119272,
 -1,
 667183347,
 119264,
 -55353,
 667149273,
 119266,
 -55352,
 667332675,
 119265,
 -55351,
 667376372,
 119267,
 -1,
 667430322,
 119262,
 -1,
 666536850,
 119081,
 -1,
 666449442,
 127932,
 667756494,
 666400029,
 127929,
 -1,
 667684174,
 127896,
 -1,
 667718108,
 127925,
 -1,
 666329829,
 127812,
 668018697,
 662681471,
 -1,
 668084216,
 667974998,
 -1,
 668149718,
 668059553,
 -1,
 -55340,
 668097697,
 92757,
 -55339,
 668157696,
 92766,
 -1,
 668211590,
 92736,
 668411865,
 668111895,
 92754,
 -55336,
 668374039,
 92753,
 -1,
 668432143,
 92749,
 668608477,
 668365625,
 -1,
 -55333,
 668570647,
 92761,
 -55332,
 668621413,
 92744,
 -1,
 668681010,
 92748,
 668870624,
 668576966,
 -1,
 -55329,
 668832791,
 92755,
 -1,
 668885933,
 92765,
 669067235,
 668836527,
 -1,
 -55326,
 669015633,
 92743,
 -1,
 669063558,
 92752,
 669263846,
 669027372,
 -1,
 -55323,
 669214894,
 92751,
 -1,
 669276124,
 92737,
 669460457,
 669221747,
 -1,
 -55320,
 669411396,
 92739,
 -1,
 669457499,
 92750,
 669657067,
 669415257,
 92763,
 -1,
 669617196,
 92762,
 669788142,
 669604381,
 -1,
 -55315,
 669750295,
 92745,
 -1,
 669803437,
 92764,
 669984752,
 669729278,
 92760,
 -1,
 669915526,
 92758,
 670115826,
 669923740,
 92741,
 -1,
 670065581,
 92746,
 -55309,
 670100369,
 92738,
 -55308,
 670228731,
 92759,
 -55307,
 670285459,
 92756,
 -55306,
 670314929,
 92747,
 -55305,
 670377872,
 92740,
 -1,
 670439814,
 92742,
 670695423,
 668023053,
 -1,
 670705671,
 670590818,
 -1,
 670771197,
 670680993,
 -1,
 -55300,
 670754326,
 92770,
 -1,
 670786016,
 92771,
 670967808,
 670743041,
 -1,
 -55297,
 670921072,
 92774,
 -1,
 670977173,
 92775,
 671164419,
 670912145,
 -1,
 -55294,
 671129341,
 92772,
 -1,
 671183038,
 92773,
 -55292,
 671149339,
 92768,
 -55291,
 671324245,
 92769,
 -55290,
 671387720,
 92777,
 -1,
 671434374,
 92776,
 -55288,
 670670470,
 92783,
 -1,
 671555870,
 92782,
 -55286,
 668000443,
 983173,
 -55285,
 671735953,
 983216,
 -1,
 671779644,
 983228,
 671952762,
 527398671,
 -1,
 672017251,
 671900589,
 -1,
 672082601,
 671976492,
 -1,
 672148134,
 672023038,
 -1,
 672213666,
 672080559,
 -1,
 672278942,
 672143861,
 -1,
 672344178,
 672212831,
 -1,
 672409699,
 672272428,
 -1,
 672475171,
 672338535,
 -1,
 672540696,
 672404071,
 67090,
 -55273,
 672498547,
 67092,
 -1,
 672550545,
 67091,
 672737307,
 672469308,
 67087,
 -55270,
 672695155,
 67089,
 -1,
 672747153,
 67088,
 672933917,
 672666508,
 67093,
 -1,
 672891763,
 67094,
 -55266,
 672864468,
 67100,
 -55265,
 672995363,
 67098,
 -55264,
 673060675,
 67097,
 -55263,
 673126003,
 67096,
 -55262,
 673191082,
 67095,
 -1,
 673255468,
 67086,
 673458221,
 672404862,
 -1,
 -55259,
 673388756,
 67123,
 -55258,
 673454115,
 67122,
 -55257,
 673519427,
 67121,
 -55256,
 673584755,
 67120,
 -55255,
 673650046,
 67119,
 -55254,
 673715370,
 67118,
 -55253,
 673780620,
 67117,
 -55252,
 673845564,
 67116,
 -1,
 673910828,
 67115,
 674113591,
 673386540,
 -1,
 -55249,
 674044116,
 67080,
 -55248,
 674109475,
 67079,
 -55247,
 674174787,
 67078,
 -55246,
 674240115,
 67077,
 -55245,
 674305406,
 67076,
 -55244,
 674370730,
 67075,
 -55243,
 674435980,
 67074,
 -55242,
 674501223,
 67073,
 -1,
 674566460,
 67072,
 674768960,
 674043050,
 -1,
 -55239,
 674699476,
 67114,
 -55238,
 674764835,
 67113,
 -55237,
 674830147,
 67112,
 -55236,
 674895475,
 67111,
 -55235,
 674960766,
 67110,
 -55234,
 675026090,
 67109,
 -55233,
 675090748,
 67108,
 -1,
 675156012,
 67107,
 675358792,
 674699075,
 -1,
 -55230,
 675289300,
 67136,
 -55229,
 675354659,
 67135,
 -55228,
 675419971,
 67134,
 -55227,
 675485299,
 67133,
 -55226,
 675550378,
 67132,
 -55225,
 675615628,
 67131,
 -1,
 675680300,
 67130,
 675883087,
 675289123,
 -1,
 -55222,
 675813187,
 67142,
 -55221,
 675878515,
 67141,
 -55220,
 675943806,
 67140,
 -55219,
 676008551,
 67139,
 -55218,
 676073788,
 67138,
 -1,
 676139052,
 67137,
 676341846,
 675812979,
 -1,
 -55215,
 676272340,
 67129,
 -55214,
 676337475,
 67128,
 -55213,
 676402803,
 67127,
 -55212,
 676468094,
 67126,
 -55211,
 676532540,
 67125,
 -1,
 676597804,
 67124,
 676800605,
 676270988,
 -1,
 -55208,
 676731092,
 67106,
 -55207,
 676796451,
 67105,
 -55206,
 676861763,
 67104,
 -55205,
 676926634,
 67103,
 -55204,
 676991292,
 67102,
 -1,
 677056556,
 67101,
 677314559,
 676729148,
 -1,
 -55201,
 677189443,
 67085,
 -55200,
 677254771,
 67084,
 -55199,
 677319564,
 67083,
 -55198,
 677384508,
 67082,
 -1,
 677449772,
 67081,
 677707775,
 672338236,
 -1,
 677718120,
 677581415,
 -1,
 -55194,
 677647244,
 67148,
 -55193,
 677712487,
 67147,
 -1,
 677777452,
 67145,
 677980267,
 677648419,
 -1,
 -55190,
 677910563,
 67155,
 -1,
 677974060,
 67154,
 678176878,
 677909646,
 -1,
 -55187,
 678111071,
 67150,
 -1,
 678173062,
 67149,
 -55185,
 678107506,
 67156,
 -55184,
 678303745,
 67153,
 -55183,
 678369084,
 67152,
 -1,
 678433367,
 67144,
 678635725,
 672273790,
 -1,
 678701182,
 678565923,
 -1,
 -55179,
 678631636,
 67324,
 -55178,
 678696995,
 67323,
 -55177,
 678762307,
 67322,
 -55176,
 678827635,
 67321,
 -55175,
 678892926,
 67320,
 -55174,
 678958250,
 67319,
 -55173,
 679023500,
 67318,
 -55172,
 679088743,
 67317,
 -55171,
 679153980,
 67316,
 -1,
 679219244,
 67315,
 679422089,
 678631235,
 -1,
 -55168,
 679352532,
 67314,
 -55167,
 679417891,
 67313,
 -55166,
 679483203,
 67312,
 -55165,
 679548531,
 67311,
 -55164,
 679613822,
 67310,
 -55163,
 679679146,
 67309,
 -55162,
 679744396,
 67308,
 -55161,
 679809639,
 67307,
 -55160,
 679874876,
 67306,
 -1,
 679940140,
 67305,
 680142995,
 679351678,
 -1,
 -55157,
 680073428,
 67298,
 -55156,
 680138563,
 67297,
 -55155,
 680203891,
 67296,
 -55154,
 680269182,
 67295,
 -55153,
 680334506,
 67294,
 -55152,
 680399756,
 67293,
 -55151,
 680464999,
 67292,
 -55150,
 680530236,
 67291,
 -1,
 680595500,
 67290,
 680798365,
 680072076,
 -1,
 -55147,
 680728788,
 67282,
 -55146,
 680794147,
 67281,
 -55145,
 680859459,
 67280,
 -55144,
 680924787,
 67279,
 -55143,
 680990078,
 67278,
 -55142,
 681055402,
 67277,
 -55141,
 681120359,
 67276,
 -55140,
 681185596,
 67275,
 -1,
 681250860,
 67274,
 681453735,
 680727143,
 -1,
 -55137,
 681384148,
 67273,
 -55136,
 681449507,
 67272,
 -55135,
 681514819,
 67271,
 -55134,
 681580147,
 67270,
 -55133,
 681645438,
 67269,
 -55132,
 681710762,
 67268,
 -55131,
 681776012,
 67267,
 -55130,
 681840956,
 67266,
 -1,
 681906220,
 67265,
 682109104,
 681381932,
 -1,
 -55127,
 682039508,
 67258,
 -55126,
 682104867,
 67257,
 -55125,
 682169971,
 67256,
 -55124,
 682235262,
 67255,
 -55123,
 682300586,
 67254,
 -55122,
 682365836,
 67253,
 -55121,
 682431079,
 67252,
 -1,
 682496316,
 67251,
 682698936,
 682038442,
 -1,
 -55118,
 682629332,
 67289,
 -55117,
 682694691,
 67288,
 -55116,
 682760003,
 67287,
 -55115,
 682825086,
 67286,
 -55114,
 682889831,
 67285,
 -55113,
 682955068,
 67284,
 -1,
 683020332,
 67283,
 683223231,
 682629332,
 -1,
 -55110,
 683153443,
 67330,
 -55109,
 683218547,
 67329,
 -55108,
 683283838,
 67328,
 -55107,
 683349162,
 67327,
 -55106,
 683414119,
 67326,
 -1,
 683479356,
 67325,
 683681990,
 683153011,
 -1,
 -55103,
 683612372,
 67304,
 -55102,
 683677731,
 67303,
 -55101,
 683742835,
 67302,
 -55100,
 683808126,
 67301,
 -55099,
 683873450,
 67300,
 -1,
 683938700,
 67299,
 684195839,
 683610428,
 -1,
 -55096,
 684070515,
 67264,
 -55095,
 684135806,
 67263,
 -55094,
 684200844,
 67262,
 -55093,
 684266087,
 67261,
 -55092,
 684331324,
 67260,
 -1,
 684396588,
 67259,
 684599587,
 678564748,
 -1,
 684665052,
 684527932,
 -1,
 684730579,
 684594060,
 -1,
 -55087,
 684666275,
 67173,
 -55086,
 684730207,
 67172,
 -1,
 684792198,
 67171,
 -55084,
 684660948,
 67179,
 -55083,
 684922915,
 67178,
 -55082,
 684988227,
 67177,
 -55081,
 685053555,
 67176,
 -55080,
 685118846,
 67175,
 -55079,
 685184170,
 67174,
 -55078,
 685249127,
 67170,
 -55077,
 685314364,
 67169,
 -1,
 685379628,
 67168,
 685582569,
 684593196,
 -1,
 685648097,
 685512916,
 -1,
 -55073,
 685583779,
 67167,
 -55072,
 685647711,
 67166,
 -1,
 685709702,
 67165,
 -55070,
 685578275,
 67164,
 -55069,
 685840195,
 67163,
 -55068,
 685905523,
 67162,
 -55067,
 685970814,
 67161,
 -55066,
 686036138,
 67160,
 -55065,
 686101388,
 67159,
 -55064,
 686166631,
 67158,
 -1,
 686231868,
 67157,
 686434548,
 685512307,
 -1,
 -55061,
 686364884,
 67229,
 -55060,
 686430243,
 67228,
 -55059,
 686495555,
 67227,
 -55058,
 686560883,
 67226,
 -55057,
 686626174,
 67225,
 -55056,
 686691498,
 67224,
 -55055,
 686756748,
 67223,
 -55054,
 686821991,
 67222,
 -55053,
 686887228,
 67221,
 -1,
 686952492,
 67220,
 687155455,
 686364030,
 -1,
 -55050,
 687085780,
 67219,
 -55049,
 687151139,
 67218,
 -55048,
 687216451,
 67217,
 -55047,
 687281779,
 67216,
 -55046,
 687347070,
 67215,
 -55045,
 687412394,
 67214,
 -55044,
 687477644,
 67213,
 -55043,
 687542887,
 67212,
 -55042,
 687608124,
 67211,
 -1,
 687673388,
 67210,
 687876362,
 687084714,
 -1,
 -55039,
 687806676,
 67209,
 -55038,
 687872035,
 67208,
 -55037,
 687937347,
 67207,
 -55036,
 688002675,
 67206,
 -55035,
 688067966,
 67205,
 -55034,
 688133290,
 67204,
 -55033,
 688198540,
 67203,
 -55032,
 688263783,
 67202,
 -55031,
 688329020,
 67201,
 -1,
 688394284,
 67200,
 688597269,
 687805324,
 -1,
 -55028,
 688527572,
 67199,
 -55027,
 688592931,
 67198,
 -55026,
 688658243,
 67197,
 -55025,
 688723571,
 67196,
 -55024,
 688788862,
 67195,
 -55023,
 688854186,
 67194,
 -55022,
 688919436,
 67193,
 -55021,
 688984679,
 67192,
 -55020,
 689049916,
 67191,
 -1,
 689115180,
 67190,
 689318176,
 688525927,
 -1,
 -55017,
 689248468,
 67189,
 -55016,
 689313827,
 67188,
 -55015,
 689379139,
 67187,
 -55014,
 689444467,
 67186,
 -55013,
 689509758,
 67185,
 -55012,
 689575082,
 67184,
 -55011,
 689640332,
 67183,
 -55010,
 689705575,
 67182,
 -55009,
 689770812,
 67181,
 -1,
 689836076,
 67180,
 690094079,
 689248067,
 -1,
 -55006,
 689967420,
 67231,
 -1,
 690032684,
 67230,
 690235743,
 684529267,
 -1,
 690301231,
 690164028,
 -1,
 -55002,
 690231508,
 67348,
 -55001,
 690296867,
 67347,
 -55000,
 690362179,
 67346,
 -54999,
 690427507,
 67345,
 -54998,
 690492798,
 67344,
 -54997,
 690558122,
 67343,
 -54996,
 690623372,
 67342,
 -54995,
 690688615,
 67341,
 -54994,
 690753852,
 67340,
 -1,
 690819116,
 67339,
 691022137,
 690230654,
 -1,
 -54991,
 690952404,
 67377,
 -54990,
 691017763,
 67376,
 -54989,
 691083075,
 67375,
 -54988,
 691148403,
 67374,
 -54987,
 691213694,
 67373,
 -54986,
 691279018,
 67372,
 -54985,
 691344268,
 67371,
 -54984,
 691409511,
 67370,
 -1,
 691474748,
 67369,
 691677507,
 690950759,
 -1,
 -54981,
 691607764,
 67357,
 -54980,
 691673123,
 67356,
 -54979,
 691738435,
 67355,
 -54978,
 691803763,
 67354,
 -54977,
 691868842,
 67353,
 -54976,
 691934092,
 67352,
 -54975,
 691999335,
 67351,
 -54974,
 692064572,
 67350,
 -1,
 692129836,
 67349,
 692332876,
 691606698,
 -1,
 -54971,
 692263124,
 67368,
 -54970,
 692328483,
 67367,
 -54969,
 692393587,
 67366,
 -54968,
 692458878,
 67365,
 -54967,
 692524202,
 67364,
 -54966,
 692589452,
 67363,
 -54965,
 692654695,
 67362,
 -1,
 692719660,
 67361,
 692922709,
 692260908,
 -1,
 -54962,
 692852948,
 67338,
 -54961,
 692918307,
 67337,
 -54960,
 692983411,
 67336,
 -54959,
 693048490,
 67335,
 -54958,
 693113740,
 67334,
 -54957,
 693178983,
 67333,
 -54956,
 693244220,
 67332,
 -1,
 693309484,
 67331,
 693512539,
 692852339,
 -1,
 -54953,
 693441706,
 67382,
 -54952,
 693506956,
 67381,
 -54951,
 693572199,
 67380,
 -54950,
 693637436,
 67379,
 -1,
 693702700,
 67378,
 693960703,
 693441420,
 -1,
 -54947,
 693835811,
 67360,
 -54946,
 693901123,
 67359,
 -1,
 693965994,
 67358,
 694167930,
 690165571,
 -1,
 694233456,
 694095916,
 -1,
 694298984,
 694163668,
 -1,
 694364519,
 694226597,
 -1,
 -54940,
 694294198,
 67404,
 -54939,
 694359274,
 67403,
 -54938,
 694424558,
 67402,
 -1,
 694489776,
 67401,
 -1,
 694289369,
 67400,
 -54935,
 694229090,
 67399,
 -54934,
 694687607,
 67398,
 -54933,
 694752908,
 67397,
 -54932,
 694818221,
 67396,
 -54931,
 694883529,
 67395,
 -54930,
 694948778,
 67394,
 -54929,
 695013993,
 67393,
 -1,
 695079230,
 67392,
 695282040,
 694161724,
 -1,
 -54926,
 695211855,
 67411,
 -54925,
 695276953,
 67410,
 -54924,
 695342256,
 67409,
 -54923,
 695407661,
 67408,
 -54922,
 695472969,
 67407,
 -54921,
 695538208,
 67406,
 -1,
 695603426,
 67405,
 -54919,
 695211157,
 67413,
 -1,
 695735162,
 67412,
 695937424,
 694097066,
 -1,
 696002950,
 695865388,
 -1,
 -54915,
 695933289,
 67241,
 -54914,
 695998657,
 67240,
 -54913,
 696063992,
 67239,
 -54912,
 696129327,
 67238,
 -54911,
 696194636,
 67237,
 -54910,
 696259939,
 67236,
 -54909,
 696325249,
 67235,
 -54908,
 696390486,
 67234,
 -54907,
 696455740,
 67233,
 -1,
 696520979,
 67232,
 696778751,
 695931196,
 -1,
 -54904,
 696654017,
 67250,
 -54903,
 696719352,
 67249,
 -54902,
 696784687,
 67248,
 -54901,
 696849996,
 67247,
 -54900,
 696915299,
 67246,
 -54899,
 696980609,
 67245,
 -54898,
 697045846,
 67244,
 -54897,
 697111100,
 67243,
 -1,
 697176339,
 67242,
 697379225,
 695867591,
 -1,
 -54894,
 697308995,
 67431,
 -54893,
 697374323,
 67430,
 -54892,
 697439614,
 67429,
 -54891,
 697504938,
 67428,
 -54890,
 697570188,
 67427,
 -54889,
 697635431,
 67426,
 -54888,
 697700668,
 67425,
 -1,
 697765932,
 67424,
 697969053,
 697307452,
 -1,
 -54885,
 697898129,
 67151,
 -54884,
 697963359,
 67146,
 -1,
 698028316,
 67143,
 -1,
 697897251,
 67099,
 698351615,
 672212833,
 -1,
 698362415,
 698246506,
 -1,
 698427917,
 698296159,
 -1,
 698493423,
 698356028,
 -1,
 698558902,
 698421292,
 -1,
 698624423,
 698488190,
 -1,
 -54875,
 698581930,
 65669,
 -54874,
 698633890,
 65668,
 -1,
 698679989,
 65667,
 698886570,
 698554580,
 -1,
 -54871,
 698844031,
 65677,
 -1,
 698896022,
 65676,
 699083181,
 698816547,
 -1,
 -54868,
 699040632,
 65675,
 -1,
 699092668,
 65674,
 699279792,
 699012931,
 -1,
 -54865,
 699237261,
 65673,
 -1,
 699289265,
 65672,
 699476403,
 699209331,
 -1,
 -54862,
 699433892,
 65671,
 -1,
 699485852,
 65670,
 -54860,
 699405501,
 65666,
 -54859,
 699601729,
 65665,
 -1,
 699666586,
 65664,
 699869633,
 698488435,
 -1,
 -54856,
 699799764,
 65713,
 -54855,
 699865123,
 65712,
 -54854,
 699930435,
 65711,
 -54853,
 699995763,
 65710,
 -54852,
 700061054,
 65709,
 -54851,
 700126378,
 65708,
 -54850,
 700191643,
 65707,
 -54849,
 700256898,
 65706,
 -54848,
 700322108,
 65705,
 -1,
 700387372,
 65704,
 700590539,
 699799363,
 -1,
 -54845,
 700520660,
 65722,
 -54844,
 700586019,
 65721,
 -54843,
 700651331,
 65720,
 -54842,
 700716825,
 65719,
 -54841,
 700781738,
 65718,
 -54840,
 700847123,
 65717,
 -54839,
 700912231,
 65716,
 -54838,
 700977468,
 65715,
 -1,
 701042732,
 65714,
 701245908,
 700519806,
 -1,
 -54835,
 701176022,
 65703,
 -54834,
 701241379,
 65702,
 -54833,
 701306691,
 65701,
 -54832,
 701371562,
 65699,
 -54831,
 701436812,
 65698,
 -54830,
 701502055,
 65697,
 -54829,
 701567390,
 65696,
 -1,
 701632556,
 65695,
 701835740,
 701175843,
 -1,
 -54826,
 701765844,
 65729,
 -54825,
 701830526,
 65728,
 -54824,
 701895850,
 65727,
 -54823,
 701961100,
 65726,
 -54822,
 702026343,
 65725,
 -54821,
 702091580,
 65724,
 -1,
 702156844,
 65723,
 702360034,
 701764778,
 -1,
 -54818,
 702289523,
 65694,
 -54817,
 702355009,
 65693,
 -54816,
 702419559,
 65692,
 -54815,
 702484873,
 65691,
 -1,
 702550073,
 65690,
 702753256,
 702288487,
 -1,
 -54812,
 702682526,
 65682,
 -54811,
 702747727,
 65681,
 -54810,
 702812913,
 65680,
 -54809,
 702878031,
 65679,
 -1,
 702943462,
 65678,
 703146476,
 702681996,
 -1,
 -54806,
 703074919,
 65687,
 -54805,
 703140371,
 65686,
 -1,
 703205569,
 65685,
 703463423,
 703076564,
 -1,
 -54802,
 703336853,
 65731,
 -1,
 703402028,
 65730,
 703660031,
 698421863,
 -1,
 703670778,
 703534462,
 -1,
 -54798,
 703600852,
 65757,
 -54797,
 703666211,
 65756,
 -54796,
 703731523,
 65755,
 -54795,
 703796851,
 65754,
 -54794,
 703862142,
 65753,
 -54793,
 703927478,
 65752,
 -54792,
 703992716,
 65751,
 -54791,
 704057959,
 65750,
 -1,
 704123196,
 65749,
 704326147,
 703599786,
 -1,
 -54788,
 704256212,
 65748,
 -54787,
 704321571,
 65747,
 -54786,
 704386675,
 65745,
 -54785,
 704451966,
 65744,
 -54784,
 704517232,
 65743,
 -54783,
 704582258,
 65742,
 -54782,
 704647512,
 65741,
 -1,
 704712942,
 65740,
 704915978,
 704254860,
 -1,
 -54779,
 704845427,
 65739,
 -54778,
 704910506,
 65738,
 -54777,
 704975959,
 65737,
 -54776,
 705040999,
 65736,
 -54775,
 705106242,
 65735,
 -1,
 705171670,
 65734,
 705429503,
 704844391,
 -1,
 -54772,
 705303951,
 65733,
 -1,
 705368146,
 65732,
 705626111,
 698408594,
 -1,
 705636909,
 705499751,
 -1,
 705702426,
 705564988,
 -1,
 -54767,
 705632468,
 65778,
 -54766,
 705697827,
 65777,
 -54765,
 705763139,
 65776,
 -54764,
 705828467,
 65775,
 -54763,
 705893758,
 65774,
 -54762,
 705959082,
 65773,
 -54761,
 706024332,
 65772,
 -54760,
 706089575,
 65771,
 -54759,
 706154812,
 65770,
 -1,
 706220076,
 65769,
 706423333,
 705630252,
 -1,
 -54756,
 706353364,
 65768,
 -54755,
 706418723,
 65767,
 -54754,
 706484035,
 65766,
 -54753,
 706549363,
 65765,
 -54752,
 706614654,
 65764,
 -54751,
 706679978,
 65763,
 -54750,
 706745228,
 65762,
 -54749,
 706810471,
 65761,
 -54748,
 706875708,
 65760,
 -1,
 706940972,
 65759,
 707144236,
 706351719,
 -1,
 -54745,
 707074260,
 65784,
 -54744,
 707139619,
 65783,
 -54743,
 707204931,
 65782,
 -54742,
 707270259,
 65781,
 -54741,
 707334759,
 65780,
 -1,
 707399996,
 65779,
 -1,
 707073618,
 65785,
 -54738,
 705565834,
 65786,
 -1,
 707596877,
 65758,
 707799704,
 698337079,
 -1,
 707865221,
 707756021,
 -1,
 707930683,
 707794755,
 -1,
 -54733,
 707860652,
 65572,
 -54732,
 707925894,
 65551,
 -54731,
 707991287,
 65608,
 -54730,
 708056631,
 65592,
 -54729,
 708121946,
 65597,
 -54728,
 708187150,
 65558,
 -54727,
 708252409,
 65567,
 -54726,
 708317553,
 65603,
 -1,
 708382854,
 65554,
 708586053,
 707859838,
 -1,
 -54723,
 708516168,
 65586,
 -54722,
 708581559,
 65585,
 -54721,
 708646779,
 65546,
 -54720,
 708711952,
 65565,
 -54719,
 708777284,
 65591,
 -54718,
 708842570,
 65578,
 -54717,
 708907756,
 65564,
 -54716,
 708972908,
 65545,
 -1,
 709038279,
 65570,
 709241423,
 708514407,
 -1,
 -54713,
 709171507,
 65606,
 -54712,
 709236825,
 65538,
 -54711,
 709302238,
 65577,
 -54710,
 709367549,
 65580,
 -54709,
 709432704,
 65600,
 -54708,
 709498132,
 65562,
 -54707,
 709563419,
 65560,
 -54706,
 709628393,
 65573,
 -1,
 709693706,
 65599,
 709896793,
 709169196,
 -1,
 -54703,
 709826873,
 65582,
 -54702,
 709892133,
 65536,
 -54701,
 709957460,
 65543,
 -54700,
 710022873,
 65561,
 -54699,
 710088223,
 65589,
 -54698,
 710153518,
 65587,
 -54697,
 710218805,
 65566,
 -54696,
 710284066,
 65579,
 -1,
 710349154,
 65541,
 710552162,
 709826163,
 -1,
 -54693,
 710482258,
 65590,
 -54692,
 710547633,
 65610,
 -54691,
 710612882,
 65553,
 -54690,
 710678291,
 65611,
 -54689,
 710743493,
 65550,
 -54688,
 710808343,
 65607,
 -54687,
 710873542,
 65539,
 -1,
 710938828,
 65576,
 711141995,
 710481066,
 -1,
 -54684,
 711071891,
 65605,
 -54683,
 711136934,
 65547,
 -54682,
 711202216,
 65542,
 -54681,
 711267544,
 65552,
 -54680,
 711332750,
 65601,
 -54679,
 711398204,
 65594,
 -54678,
 711463416,
 65583,
 -1,
 711528704,
 65593,
 711731828,
 711070604,
 -1,
 -54675,
 711661870,
 65568,
 -54674,
 711727155,
 65537,
 -54673,
 711792611,
 65588,
 -54672,
 711857835,
 65549,
 -54671,
 711922756,
 65609,
 -54670,
 711987997,
 65574,
 -54669,
 712053235,
 65581,
 -1,
 712118446,
 65563,
 712321661,
 711659836,
 -1,
 -54666,
 712251379,
 65596,
 -54665,
 712316658,
 65571,
 -54664,
 712381949,
 65559,
 -54663,
 712447172,
 65544,
 -54662,
 712512521,
 65557,
 -54661,
 712577837,
 65584,
 -54660,
 712643044,
 65569,
 -1,
 712708318,
 65540,
 712911490,
 712251427,
 -1,
 -54657,
 712841192,
 65612,
 -54656,
 712906122,
 65602,
 -54655,
 712970671,
 65555,
 -1,
 713035925,
 65556,
 713293823,
 712841428,
 -1,
 -54652,
 713167368,
 65613,
 -1,
 713232456,
 65604,
 713490431,
 707823206,
 -1,
 713501323,
 713365539,
 -1,
 -54648,
 713431252,
 65629,
 -54647,
 713496179,
 65628,
 -54646,
 713560972,
 65627,
 -1,
 713626215,
 65626,
 713829006,
 713430643,
 -1,
 -54643,
 713757866,
 65624,
 -1,
 713823116,
 65623,
 714025617,
 713757866,
 -1,
 -54640,
 713955540,
 65621,
 -1,
 714020675,
 65620,
 714222228,
 713953596,
 -1,
 -54637,
 714152148,
 65617,
 -1,
 714217507,
 65616,
 -54635,
 714151947,
 65625,
 -54634,
 714348131,
 65622,
 -54633,
 714413214,
 65619,
 -1,
 714478438,
 65618,
 714735615,
 707758716,
 -1,
 714746529,
 714608956,
 -1,
 714812061,
 714675084,
 -1,
 -54628,
 714741238,
 65689,
 -1,
 714806163,
 65688,
 715008672,
 714740327,
 -1,
 -54625,
 714938470,
 65684,
 -1,
 715003787,
 65683,
 -1,
 714937958,
 65700,
 -1,
 714675052,
 65746,
 715390975,
 672137216,
 -1,
 715401893,
 715311197,
 983068,
 -1,
 715327762,
 983142,
 -1,
 715345773,
 983062,
 715653119,
 672101177,
 -1,
 -54616,
 715539580,
 128391,
 -1,
 715590039,
 128279,
 715795206,
 672039795,
 -1,
 715860741,
 715730190,
 -1,
 715926228,
 715816278,
 -1,
 715991728,
 715900833,
 -1,
 -54610,
 715959616,
 6430,
 -54609,
 716003869,
 6412,
 -1,
 716052870,
 6411,
 716253876,
 715962881,
 -1,
 -54606,
 716225238,
 6426,
 -54605,
 716266013,
 6425,
 -1,
 716315014,
 6427,
 716516024,
 716199112,
 -1,
 -54602,
 716499442,
 6429,
 -54601,
 716528157,
 6404,
 -1,
 716577158,
 6403,
 716778170,
 716499359,
 6421,
 -1,
 716737580,
 6410,
 716909245,
 716743343,
 -1,
 -54596,
 716855837,
 6417,
 -1,
 716904838,
 6416,
 717105856,
 716868652,
 -1,
 -54593,
 717051159,
 6405,
 -1,
 717101446,
 6415,
 717302467,
 717058873,
 -1,
 -54590,
 717249053,
 6402,
 -1,
 717298054,
 6401,
 717499078,
 717255181,
 -1,
 -54587,
 717445661,
 6409,
 -1,
 717494662,
 6408,
 717695689,
 717437197,
 -1,
 -54584,
 717642269,
 6414,
 -1,
 717691270,
 6413,
 717892300,
 717630883,
 -1,
 -54581,
 717838877,
 6407,
 -1,
 717887878,
 6406,
 718088911,
 717825887,
 -1,
 -54578,
 718035485,
 6419,
 -1,
 718084486,
 6418,
 -54576,
 718070011,
 6424,
 -54575,
 718253376,
 6422,
 -54574,
 718308297,
 6420,
 -54573,
 718370649,
 6423,
 -1,
 718428701,
 6428,
 718613225,
 715897345,
 -1,
 718678752,
 718570708,
 -1,
 718744281,
 718638124,
 -1,
 -54568,
 718689559,
 6449,
 -1,
 718739846,
 6452,
 -54566,
 718719015,
 6451,
 -54565,
 718908736,
 6455,
 -54564,
 718971659,
 6453,
 -54563,
 719029193,
 6454,
 -54562,
 719091545,
 6456,
 -54561,
 719156107,
 6448,
 -1,
 719200805,
 6450,
 719399653,
 718628729,
 -1,
 -54558,
 719370977,
 6459,
 -54557,
 719424369,
 6457,
 -54556,
 719487260,
 6464,
 -1,
 719549672,
 6458,
 719781887,
 719377589,
 -1,
 -54553,
 719710623,
 6441,
 -54552,
 719773947,
 6443,
 -1,
 719826240,
 6442,
 719989493,
 718594030,
 -1,
 720055028,
 719915312,
 -1,
 720120558,
 719985030,
 6432,
 -54547,
 720098202,
 6438,
 -1,
 720135085,
 6436,
 720317168,
 720081943,
 6440,
 -1,
 720278551,
 6437,
 720448242,
 720257534,
 6439,
 -1,
 720388606,
 6435,
 -54541,
 720425882,
 6434,
 -1,
 720528301,
 6433,
 -1,
 719982272,
 6400,
 720775939,
 719928419,
 -1,
 720841465,
 720750497,
 -1,
 -54536,
 720823830,
 6472,
 -1,
 720855520,
 6473,
 721038076,
 720812545,
 -1,
 -54533,
 720990576,
 6476,
 -1,
 721046677,
 6477,
 721234687,
 720981649,
 -1,
 -54530,
 721198845,
 6474,
 -1,
 721252542,
 6475,
 -54528,
 721218843,
 6470,
 -54527,
 721393749,
 6471,
 -54526,
 721457224,
 6479,
 -1,
 721503878,
 6478,
 -54524,
 720743531,
 6469,
 -1,
 721636730,
 6468,
 -1,
 715812951,
 13007,
 721890118,
 715769476,
 -1,
 721955651,
 721845590,
 -1,
 722021142,
 721930145,
 -1,
 722086673,
 721983577,
 -1,
 722152208,
 722045983,
 -1,
 -54516,
 722128029,
 42232,
 -54515,
 722177142,
 42236,
 -54514,
 722236062,
 42237,
 -54513,
 722286852,
 42234,
 -1,
 722348945,
 42235,
 -1,
 722111644,
 42233,
 722610964,
 722057729,
 -1,
 -54509,
 722557469,
 42206,
 -1,
 722606470,
 42205,
 -54507,
 722557469,
 42197,
 -1,
 722737542,
 42196,
 722938649,
 721998746,
 42228,
 -54504,
 722885131,
 42230,
 -1,
 722944510,
 42229,
 723135260,
 722922544,
 -1,
 -54501,
 723081757,
 42211,
 -1,
 723130758,
 42212,
 723331871,
 723106305,
 -1,
 -54498,
 723278365,
 42219,
 -1,
 723327366,
 42210,
 723528482,
 723296943,
 -1,
 -54495,
 723474973,
 42194,
 -1,
 723523974,
 42193,
 723725092,
 723489815,
 42227,
 -1,
 723665406,
 42231,
 723856167,
 723684396,
 -1,
 -54490,
 723801367,
 42213,
 -1,
 723851654,
 42208,
 724052778,
 723809081,
 -1,
 -54487,
 723999261,
 42200,
 -1,
 724048262,
 42199,
 724249389,
 723999243,
 -1,
 -54484,
 724195869,
 42216,
 -1,
 724244870,
 42214,
 724446000,
 724194504,
 -1,
 -54481,
 724392477,
 42221,
 -1,
 724441478,
 42198,
 724642610,
 724386302,
 42224,
 -1,
 724620186,
 42225,
 724773685,
 724580621,
 -1,
 -54476,
 724757598,
 42204,
 -1,
 724769158,
 42195,
 724970296,
 724708771,
 -1,
 -54473,
 724916765,
 42203,
 -1,
 724965766,
 42202,
 725166906,
 724900230,
 42222,
 -1,
 725107198,
 42223,
 -54469,
 725150111,
 42220,
 -54468,
 725280822,
 42215,
 -54467,
 725344507,
 42218,
 -54466,
 725386185,
 42207,
 -54465,
 725448537,
 42209,
 -54464,
 725512747,
 42201,
 -54463,
 725574573,
 42226,
 -54462,
 725634790,
 42217,
 -1,
 725690256,
 42192,
 725942271,
 721922645,
 -1,
 -54459,
 725832887,
 42239,
 -1,
 725890202,
 42238,
 726084446,
 721835208,
 -1,
 726149981,
 726033136,
 -1,
 726215515,
 726073344,
 -1,
 726281040,
 726158993,
 -1,
 726346573,
 726245206,
 -1,
 -54452,
 726320279,
 128964,
 -1,
 726350053,
 11212,
 726597631,
 726298818,
 -1,
 -54449,
 726516553,
 128943,
 -1,
 726575073,
 128969,
 726739795,
 726255521,
 -1,
 -54446,
 726721079,
 128978,
 -1,
 726753947,
 128960,
 726936406,
 726710785,
 -1,
 -54443,
 726888839,
 128949,
 -1,
 726933495,
 128937,
 -54441,
 726918063,
 128910,
 -54440,
 727100856,
 128648,
 -54439,
 727144798,
 128930,
 -54438,
 727205553,
 128955,
 -1,
 727265485,
 128504,
 727515135,
 726175886,
 128498,
 -1,
 727384444,
 128497,
 -1,
 726083167,
 128626,
 727657312,
 726051310,
 128482,
 -1,
 727633111,
 128132,
 -54431,
 727641316,
 129422,
 -54430,
 727769209,
 8374,
 -1,
 727816154,
 129409,
 727985700,
 671947142,
 -1,
 728051163,
 727961024,
 -1,
 728116453,
 728021505,
 -1,
 728181970,
 728073385,
 -1,
 728247503,
 728137046,
 -1,
 728312717,
 728221601,
 -1,
 728378240,
 728290202,
 -1,
 728443775,
 728348514,
 -1,
 728509299,
 728405015,
 -1,
 728574832,
 728449534,
 7444,
 728694783,
 728501090,
 -1,
 -54417,
 728614359,
 43841,
 -1,
 728654108,
 43842,
 728836978,
 728499549,
 43843,
 -1,
 728763962,
 43844,
 -1,
 728802610,
 7432,
 729033590,
 728488891,
 -1,
 -54411,
 728979743,
 983627,
 -1,
 729029572,
 983628,
 729230200,
 728982445,
 7433,
 -1,
 729191057,
 42879,
 729361274,
 729176589,
 686,
 -1,
 729284778,
 687,
 -54405,
 729339455,
 43857,
 -54404,
 729459971,
 11385,
 -54403,
 729511695,
 42881,
 -54402,
 729568456,
 7543,
 -1,
 729619528,
 7426,
 -1,
 728400755,
 42871,
 729885572,
 728324619,
 -1,
 729951107,
 729849069,
 42853,
 -1,
 729876974,
 42855,
 -1,
 729878054,
 7546,
 730147720,
 729811810,
 -1,
 -54394,
 730106032,
 7541,
 -54393,
 730151960,
 11366,
 -1,
 730216579,
 566,
 -54391,
 730131504,
 42793,
 -54390,
 730380835,
 43879,
 -54389,
 730444240,
 42795,
 -54388,
 730503883,
 7446,
 -1,
 730537393,
 11383,
 730737576,
 728283649,
 -1,
 730803093,
 730686849,
 -1,
 730868626,
 730764311,
 7441,
 -54383,
 730834257,
 7442,
 -1,
 730861114,
 7443,
 -54381,
 730846106,
 7453,
 -54380,
 731042359,
 7455,
 -1,
 731069416,
 7454,
 731261854,
 730738083,
 -1,
 731327386,
 731231899,
 -1,
 731392921,
 731294918,
 43851,
 -1,
 731319817,
 43852,
 -1,
 731337956,
 43830,
 731643903,
 731276168,
 -1,
 -54372,
 731558368,
 7573,
 -54371,
 731601183,
 983629,
 -1,
 731651012,
 983630,
 731851684,
 731188066,
 -1,
 -54368,
 731831793,
 983587,
 -54367,
 731891472,
 575,
 -54366,
 731947884,
 7562,
 -54365,
 732009608,
 42921,
 -1,
 732072112,
 7540,
 732244903,
 731781510,
 -1,
 -54362,
 732201716,
 42892,
 -1,
 732263721,
 43872,
 -1,
 732220941,
 43845,
 732507076,
 730677758,
 -1,
 732572603,
 732433250,
 -1,
 732638126,
 732552689,
 983567,
 732758015,
 732561474,
 -1,
 -54355,
 732649759,
 983569,
 -1,
 732699588,
 983571,
 732900273,
 732599757,
 -1,
 -54352,
 732876063,
 983597,
 -1,
 732896196,
 983595,
 733096884,
 732839270,
 -1,
 -54349,
 733072671,
 983601,
 -1,
 733092804,
 983599,
 733293495,
 733033151,
 -1,
 -54346,
 733250546,
 983573,
 -1,
 733294342,
 983575,
 -54344,
 733267415,
 583,
 -54343,
 733458912,
 7570,
 -54342,
 733516220,
 11384,
 -1,
 733565436,
 43828,
 733752254,
 732544384,
 -1,
 -54339,
 733721056,
 7576,
 -1,
 733782892,
 7563,
 733948865,
 733698556,
 -1,
 -54336,
 733903552,
 42787,
 -1,
 733964462,
 42789,
 -54334,
 733932891,
 7578,
 -54333,
 734119841,
 42859,
 -1,
 734171007,
 43836,
 734342110,
 732455853,
 -1,
 734407632,
 734301228,
 -1,
 734473165,
 734381774,
 -1,
 -54328,
 734447521,
 42887,
 -54327,
 734509569,
 42885,
 -54326,
 734571718,
 42883,
 -54325,
 734614728,
 7545,
 -54324,
 734678673,
 42876,
 -1,
 734738701,
 42874,
 734986239,
 734453130,
 -1,
 -54321,
 734893395,
 43840,
 -1,
 734928777,
 43876,
 735128538,
 734333794,
 -1,
 735194069,
 735067494,
 -1,
 -54317,
 735169823,
 983603,
 -54316,
 735205663,
 983602,
 -1,
 735255492,
 983578,
 735456216,
 735155673,
 -1,
 -54313,
 735431967,
 983607,
 -1,
 735452100,
 983605,
 -54311,
 735424992,
 7574,
 -1,
 735609861,
 983577,
 735783901,
 735092122,
 -1,
 -54308,
 735733245,
 43873,
 -1,
 735779345,
 7548,
 -1,
 735754753,
 42861,
 736046067,
 734319514,
 -1,
 736111598,
 735969280,
 -1,
 736177133,
 736093260,
 -1,
 736242661,
 736134137,
 -1,
 -54301,
 736218399,
 983623,
 -54300,
 736254239,
 983589,
 -1,
 736304068,
 983621,
 736504808,
 736213505,
 -1,
 -54297,
 736481522,
 42937,
 -1,
 736518502,
 43854,
 736701419,
 736466381,
 -1,
 -54294,
 736677151,
 983619,
 -1,
 736697284,
 983617,
 -54292,
 736670176,
 7577,
 -1,
 736852813,
 43858,
 -1,
 736110685,
 43855,
 -54289,
 736078328,
 7551,
 -54288,
 737055767,
 43875,
 -54287,
 737117043,
 42872,
 -54286,
 737174445,
 43856,
 -1,
 737231358,
 7531,
 737422342,
 735975814,
 -1,
 737487869,
 737345536,
 -1,
 737553404,
 737469516,
 -1,
 737618937,
 737514957,
 -1,
 -54280,
 737594655,
 983593,
 -1,
 737614788,
 983591,
 -54278,
 737592791,
 11365,
 -54277,
 737784288,
 7567,
 -1,
 737838085,
 983565,
 -1,
 737522257,
 43825,
 738077695,
 737467312,
 42809,
 -1,
 738004191,
 42811,
 -54272,
 738060580,
 42813,
 -54271,
 738186138,
 42807,
 -54270,
 738235415,
 42805,
 -54269,
 738299855,
 42947,
 -54268,
 738361976,
 7568,
 -54267,
 738411223,
 983624,
 -1,
 738466182,
 42803,
 738667545,
 737389766,
 -1,
 738733075,
 738590720,
 -1,
 738798610,
 738714695,
 -1,
 738864145,
 738721792,
 -1,
 -54261,
 738839839,
 983615,
 -54260,
 738903511,
 589,
 -54259,
 738960236,
 7561,
 -54258,
 739021960,
 42919,
 -54257,
 739084464,
 7538,
 -54256,
 739135750,
 7539,
 -1,
 739194674,
 43849,
 -1,
 738828230,
 43847,
 -1,
 738769026,
 42843,
 739519511,
 738675987,
 -1,
 739585046,
 739454371,
 8580,
 -1,
 739511335,
 42815,
 -1,
 739547943,
 7572,
 739835903,
 739497657,
 42869,
 -1,
 739707086,
 42845,
 739912750,
 738628631,
 -1,
 739978275,
 739878189,
 -1,
 740043810,
 739939351,
 -1,
 740109345,
 739969890,
 -1,
 -54242,
 740083159,
 43839,
 -54241,
 740143584,
 7575,
 -54240,
 740186399,
 983625,
 -1,
 740236228,
 983626,
 -1,
 740049406,
 43874,
 -1,
 739984119,
 7571,
 740568108,
 739904354,
 -1,
 740633640,
 740548081,
 983581,
 740753407,
 740556866,
 -1,
 -54233,
 740645151,
 983583,
 -1,
 740694980,
 983585,
 740950015,
 740589702,
 -1,
 -54230,
 740876510,
 11386,
 -54229,
 740924104,
 42829,
 -1,
 740986733,
 42827,
 -54227,
 740529175,
 42831,
 -1,
 741115741,
 42935,
 741289023,
 739866383,
 -1,
 741354554,
 741215074,
 -1,
 741420083,
 741293684,
 -1,
 -54222,
 741378224,
 43832,
 -1,
 741419060,
 11361,
 -54220,
 741395743,
 983611,
 -54219,
 741585391,
 42894,
 -54218,
 741647212,
 7557,
 -54217,
 741705822,
 43833,
 -54216,
 741764456,
 43831,
 -54215,
 741826286,
 42825,
 -1,
 741881987,
 564,
 742075453,
 741316987,
 -1,
 -54212,
 742022894,
 7837,
 -1,
 742079512,
 7836,
 -54210,
 742053561,
 42866,
 -1,
 742213799,
 43829,
 742403152,
 741222239,
 -1,
 742468676,
 742356921,
 -1,
 742534211,
 742429719,
 43837,
 -1,
 742460986,
 43838,
 -1,
 742474238,
 43826,
 742730825,
 742398342,
 -1,
 742796360,
 742701244,
 -1,
 -54201,
 742736382,
 43827,
 -1,
 742793097,
 43824,
 -1,
 742767729,
 43853,
 743058509,
 742656866,
 -1,
 -54197,
 743023468,
 7552,
 -54196,
 743082160,
 7532,
 -1,
 743133692,
 42903,
 -54194,
 743028661,
 42823,
 -54193,
 743284280,
 7447,
 -1,
 743328648,
 42933,
 743517278,
 742340877,
 -1,
 743582806,
 743443298,
 -1,
 -54189,
 743547756,
 7553,
 -54188,
 743606448,
 7533,
 -54187,
 743661702,
 7569,
 -1,
 743716995,
 545,
 743910490,
 743543831,
 -1,
 743976025,
 743888162,
 43848,
 -1,
 743902156,
 43850,
 -1,
 743951936,
 567,
 -54181,
 743894066,
 43878,
 -54180,
 744150713,
 42865,
 -54179,
 744179576,
 7839,
 -1,
 744236900,
 568,
 744434795,
 743496624,
 -1,
 744500324,
 744360802,
 -1,
 -54175,
 744469438,
 11377,
 -54174,
 744530796,
 7564,
 -54173,
 744569880,
 42847,
 -1,
 744634499,
 11380,
 744828008,
 744461953,
 -1,
 -54170,
 744805864,
 42911,
 -54169,
 744854867,
 42909,
 -1,
 744889416,
 42907,
 -54167,
 744810788,
 42849,
 -54166,
 745041772,
 42851,
 -1,
 745097300,
 42857,
 745286775,
 744369571,
 -1,
 745352304,
 745234001,
 43859,
 745471999,
 745278858,
 -1,
 -54161,
 745387014,
 43860,
 -1,
 745438091,
 43861,
 745614452,
 745278306,
 -1,
 -54158,
 745588183,
 572,
 -54157,
 745644908,
 42900,
 -1,
 745678900,
 42899,
 745876598,
 745591950,
 42797,
 -1,
 745802688,
 42799,
 -1,
 745838522,
 42863,
 746073218,
 745245740,
 -1,
 746138752,
 745999202,
 -1,
 746204284,
 746073507,
 -1,
 -54149,
 746183200,
 565,
 -1,
 746240058,
 43835,
 -54147,
 746169196,
 7559,
 -54146,
 746361992,
 42917,
 -54145,
 746424496,
 7536,
 -1,
 746470224,
 42897,
 -54143,
 746116793,
 42868,
 -1,
 746607864,
 983579,
 746794124,
 746029939,
 -1,
 746859656,
 746720098,
 -1,
 -54139,
 746835231,
 983613,
 -54138,
 746890092,
 7558,
 -54137,
 746948784,
 7535,
 -1,
 746993458,
 43834,
 747187339,
 746808658,
 -1,
 -54134,
 747166640,
 7933,
 -1,
 747208656,
 7931,
 -1,
 747165369,
 42867,
 747449494,
 746738888,
 -1,
 747515026,
 747405667,
 -1,
 -54129,
 747492250,
 42943,
 -54128,
 747554130,
 578,
 -54127,
 747594669,
 42941,
 -1,
 747641222,
 42939,
 747842709,
 747440994,
 -1,
 -54124,
 747807596,
 7555,
 -1,
 747869320,
 42913,
 -1,
 747788829,
 983199,
 748104862,
 747414248,
 -1,
 748170395,
 748075521,
 -1,
 748235930,
 748146930,
 7549,
 -1,
 748161518,
 42833,
 -1,
 748203193,
 42837,
 -54116,
 748135276,
 7560,
 -54115,
 748390576,
 7537,
 -1,
 748442108,
 42835,
 748629158,
 748057445,
 -1,
 748694689,
 748602839,
 42817,
 -1,
 748617811,
 42821,
 748825764,
 748632333,
 -1,
 -54109,
 748774474,
 42819,
 -1,
 748833579,
 11370,
 -54107,
 748790636,
 7556,
 -1,
 748983432,
 42915,
 749153455,
 748575243,
 -1,
 749218986,
 749116003,
 -1,
 -54103,
 749164831,
 983631,
 -1,
 749214660,
 983632,
 749415597,
 749144930,
 -1,
 -54100,
 749380460,
 42901,
 -1,
 749419344,
 11368,
 -54098,
 749357210,
 42791,
 -1,
 749543194,
 11382,
 749743287,
 749135914,
 -1,
 749808822,
 749699206,
 -1,
 749874357,
 749768545,
 43863,
 749993983,
 749797376,
 -1,
 -54092,
 749921561,
 43865,
 -1,
 749936827,
 43864,
 -1,
 749854929,
 43862,
 -1,
 749773676,
 7565,
 750267580,
 749726800,
 -1,
 -54087,
 750241552,
 576,
 -54086,
 750297964,
 7566,
 -54085,
 750356656,
 7542,
 -1,
 750402384,
 11372,
 750595266,
 750234369,
 -1,
 750660801,
 750521186,
 -1,
 -54081,
 750634525,
 42839,
 -54080,
 750674078,
 587,
 -1,
 750730264,
 42841,
 -1,
 750625460,
 569,
 750988487,
 750578048,
 -1,
 751054022,
 750959105,
 -1,
 -54075,
 751030514,
 591,
 -1,
 751067494,
 43866,
 -1,
 751010096,
 7935,
 751316171,
 750931650,
 -1,
 -54071,
 751289815,
 42905,
 -54070,
 751346540,
 7554,
 -1,
 751405232,
 7534,
 751578318,
 751268367,
 -1,
 -54067,
 751551959,
 585,
 -1,
 751582581,
 983609,
 -1,
 751558892,
 11379,
 751894527,
 728182485,
 -1,
 -54063,
 751817715,
 7550,
 -1,
 751854609,
 7547,
 752091135,
 728159596,
 -1,
 752102613,
 752007681,
 8347,
 -1,
 752038338,
 8340,
 -54058,
 752085011,
 8339,
 -54057,
 752212912,
 7525,
 -54056,
 752276378,
 7524,
 -54055,
 752338849,
 8348,
 -54054,
 752397510,
 7523,
 -54053,
 752460463,
 8346,
 -54052,
 752522263,
 8338,
 -54051,
 752585772,
 8345,
 -54050,
 752649075,
 8344,
 -54049,
 752711439,
 8343,
 -54048,
 752775993,
 8342,
 -54047,
 752841229,
 11388,
 -54046,
 752903085,
 7522,
 -54045,
 752966155,
 8341,
 -54044,
 753025534,
 8337,
 -1,
 753080710,
 8336,
 753282474,
 728051413,
 -1,
 753347829,
 753256353,
 -1,
 753413360,
 753326639,
 -1,
 753478890,
 753342854,
 11375,
 -1,
 753435251,
 11376,
 -54037,
 753458096,
 581,
 -54036,
 753584033,
 42929,
 -54035,
 753628943,
 42880,
 -54034,
 753693497,
 42928,
 -54033,
 753757326,
 42878,
 -1,
 753818123,
 42893,
 754003186,
 753361217,
 42852,
 -1,
 753928686,
 42854,
 -54029,
 753986608,
 42792,
 -54028,
 754102736,
 42794,
 -1,
 754125841,
 574,
 754330889,
 753287678,
 -1,
 754396421,
 754256738,
 -1,
 754461947,
 754376177,
 983566,
 754581503,
 754384962,
 -1,
 -54022,
 754473247,
 983568,
 -1,
 754523076,
 983570,
 754724094,
 754423245,
 -1,
 -54019,
 754699551,
 983596,
 -1,
 754719684,
 983594,
 754920705,
 754662758,
 -1,
 -54016,
 754896159,
 983600,
 -1,
 754916292,
 983598,
 755117316,
 754856639,
 -1,
 -54013,
 755074034,
 983572,
 -1,
 755117830,
 983574,
 -1,
 755090903,
 582,
 755379464,
 754342396,
 -1,
 -54009,
 755333824,
 42786,
 -1,
 755394734,
 42788,
 -1,
 755353505,
 42858,
 755641624,
 754260358,
 -1,
 755707152,
 755567458,
 -1,
 755772686,
 755668429,
 -1,
 -54003,
 755748127,
 983592,
 -1,
 755768260,
 983590,
 -54001,
 755746263,
 570,
 -1,
 755926021,
 983564,
 756100370,
 755686320,
 42808,
 -1,
 756026591,
 42810,
 -53997,
 756082980,
 42812,
 -53996,
 756208538,
 42806,
 -53995,
 756257815,
 42804,
 -53994,
 756322255,
 42946,
 -53993,
 756384371,
 11373,
 -1,
 756423046,
 42802,
 756624678,
 755590061,
 -1,
 756690208,
 756585097,
 -1,
 -53989,
 756664225,
 42886,
 -53988,
 756726273,
 42884,
 -53987,
 756788422,
 42882,
 -53986,
 756831432,
 42877,
 -53985,
 756895377,
 42875,
 -1,
 756955405,
 42873,
 757148965,
 756616034,
 -1,
 757214500,
 757110221,
 -1,
 -53981,
 757189919,
 983606,
 -1,
 757210052,
 983604,
 -1,
 757171205,
 983576,
 -1,
 757119489,
 42860,
 757542194,
 756595201,
 -1,
 757607724,
 757468002,
 -1,
 -53975,
 757587441,
 983586,
 -53974,
 757647120,
 11390,
 -53973,
 757699720,
 42920,
 -1,
 757751931,
 42949,
 757935407,
 757564585,
 -1,
 -53970,
 757902091,
 586,
 -1,
 757935819,
 42926,
 -53968,
 757881940,
 7838,
 -53967,
 758068949,
 42924,
 -1,
 758128623,
 42891,
 758328639,
 757509318,
 -1,
 758394171,
 758251520,
 -1,
 758459706,
 758375500,
 -1,
 758525240,
 758433697,
 -1,
 -53961,
 758474749,
 983614,
 -1,
 758521251,
 11364,
 -53959,
 758498775,
 588,
 -1,
 758682760,
 42918,
 -1,
 758429826,
 42842,
 758918462,
 758336787,
 -1,
 -53955,
 758881056,
 42923,
 -1,
 758918601,
 42814,
 -1,
 758896328,
 42844,
 759180616,
 758307760,
 -1,
 759246148,
 759142017,
 -1,
 -53950,
 759223784,
 42910,
 -53949,
 759272787,
 42908,
 -1,
 759307336,
 42906,
 -53947,
 759228708,
 42848,
 -53946,
 759459692,
 42850,
 -53945,
 759515220,
 42856,
 -1,
 759565329,
 42846,
 759770451,
 759157660,
 -1,
 759835986,
 759751756,
 -1,
 759901518,
 759792633,
 -1,
 -53940,
 759876895,
 983622,
 -53939,
 759912735,
 983588,
 -1,
 759962564,
 983620,
 760163665,
 759862733,
 -1,
 -53936,
 760139039,
 983618,
 -1,
 760159172,
 983616,
 -1,
 760137175,
 42936,
 -1,
 759769140,
 580,
 760491358,
 759731223,
 -1,
 760556892,
 760417122,
 -1,
 760622425,
 760536561,
 983580,
 760741887,
 760545346,
 -1,
 -53928,
 760633631,
 983582,
 -1,
 760683460,
 983584,
 760938495,
 760578182,
 -1,
 -53925,
 760847048,
 42828,
 -1,
 760909677,
 42826,
 -53923,
 760517655,
 42830,
 -1,
 761038685,
 42934,
 761212263,
 760425891,
 -1,
 761277795,
 761138018,
 -1,
 -53919,
 761251287,
 571,
 -53918,
 761308012,
 42948,
 -1,
 761342004,
 42898,
 761539941,
 761255054,
 42796,
 -1,
 761465792,
 42798,
 -53914,
 761501626,
 42862,
 -1,
 761618001,
 42931,
 761802095,
 761165625,
 -1,
 761867627,
 761735007,
 -1,
 -53910,
 761808756,
 42925,
 -1,
 761864876,
 573,
 -53908,
 761842975,
 983610,
 -53907,
 762022064,
 11362,
 -53906,
 762076910,
 42824,
 -1,
 762134185,
 11360,
 762326391,
 761746632,
 -1,
 762391925,
 762282339,
 -1,
 -53902,
 762368922,
 42942,
 -53901,
 762430802,
 577,
 -53900,
 762471341,
 42940,
 -1,
 762517894,
 42938,
 -53898,
 762337821,
 983198,
 -1,
 762645909,
 42912,
 762850686,
 762278757,
 -1,
 762916218,
 762824151,
 42816,
 -1,
 762839123,
 42820,
 763047293,
 762853645,
 -1,
 -53892,
 762995786,
 42818,
 -1,
 763054891,
 11369,
 -1,
 763008136,
 42914,
 763309444,
 762815208,
 -1,
 763374979,
 763279873,
 -1,
 763440514,
 763351282,
 11363,
 -1,
 763365870,
 42832,
 -1,
 763407545,
 42836,
 -1,
 763318780,
 42834,
 763702667,
 763265907,
 -1,
 763768200,
 763651410,
 -1,
 -53881,
 763747248,
 7932,
 -1,
 763789264,
 7930,
 764018687,
 763693922,
 -1,
 -53878,
 763940127,
 983612,
 -1,
 763977851,
 11374,
 764161425,
 763648523,
 -1,
 764226959,
 764087138,
 -1,
 -53874,
 764174459,
 42922,
 -1,
 764230480,
 11367,
 -53872,
 764168346,
 42790,
 -1,
 764354330,
 11381,
 764554647,
 764094303,
 -1,
 764620181,
 764480354,
 -1,
 -53868,
 764593623,
 579,
 -1,
 764629500,
 42902,
 -53866,
 764590005,
 42822,
 -1,
 764758920,
 42932,
 764947867,
 764537936,
 -1,
 -53863,
 764921616,
 11391,
 -53862,
 764978028,
 42950,
 -1,
 765016912,
 11371,
 765210015,
 764899855,
 -1,
 -53859,
 765185311,
 983608,
 -53858,
 765248983,
 584,
 -1,
 765278002,
 42930,
 765472162,
 765192576,
 -1,
 -53855,
 765445591,
 590,
 -1,
 765493552,
 7934,
 765668773,
 765438723,
 -1,
 -53852,
 765642269,
 42838,
 -1,
 765672472,
 42840,
 765865384,
 765627464,
 -1,
 -53849,
 765826184,
 42916,
 -1,
 765868880,
 42896,
 -53847,
 765845740,
 11378,
 -1,
 766004938,
 42904,
 766193106,
 753237334,
 -1,
 766258640,
 766163457,
 -1,
 766324175,
 766215359,
 -1,
 766389682,
 766298017,
 7451,
 766509055,
 766368303,
 -1,
 -53840,
 766422214,
 7450,
 -53839,
 766477171,
 43002,
 -1,
 766525950,
 11387,
 766717368,
 766356678,
 -1,
 766782902,
 766659859,
 -1,
 -53835,
 766749894,
 7449,
 -1,
 766807084,
 7438,
 -53833,
 766760633,
 42870,
 -1,
 766905849,
 43846,
 767110587,
 766678039,
 7439,
 -53830,
 767087514,
 7445,
 -1,
 767141201,
 7440,
 767307198,
 767050238,
 7431,
 -53827,
 767290712,
 7459,
 -1,
 767347390,
 7430,
 767503808,
 767236486,
 7424,
 -1,
 767443454,
 7425,
 -53823,
 767487024,
 7458,
 -53822,
 767615163,
 7457,
 -53821,
 767679408,
 7456,
 -53820,
 767742874,
 7452,
 -53819,
 767801857,
 42801,
 -53818,
 767863553,
 42927,
 -53817,
 767926959,
 7448,
 -53816,
 767984499,
 7437,
 -53815,
 768046913,
 7436,
 -53814,
 768111417,
 7435,
 -53813,
 768176653,
 7434,
 -53812,
 768233105,
 42800,
 -53811,
 768293133,
 7429,
 -53810,
 768355747,
 7428,
 -1,
 768419969,
 7427,
 -1,
 766274614,
 42895,
 -53807,
 766238610,
 7460,
 -1,
 768613828,
 7461,
 768868351,
 766134716,
 -1,
 768880086,
 768782892,
 -1,
 -53803,
 768844463,
 43004,
 -1,
 768888465,
 43003,
 769076697,
 768828333,
 -1,
 -53800,
 769037237,
 43005,
 -1,
 769066046,
 43006,
 -53798,
 769048461,
 42999,
 -1,
 769204990,
 43007,
 769404413,
 728018118,
 -1,
 769469948,
 769349227,
 -1,
 769535461,
 769430551,
 -1,
 769600994,
 769502836,
 -1,
 -53792,
 769573725,
 128999,
 -53791,
 769604648,
 128310,
 -1,
 769667570,
 128992,
 769916927,
 769560083,
 -1,
 -53788,
 769832396,
 68415,
 -1,
 769867186,
 68413,
 770059757,
 769468255,
 -1,
 770125290,
 770016046,
 -1,
 -53784,
 770098013,
 128998,
 -53783,
 770128936,
 128311,
 -1,
 770191858,
 128309,
 770441215,
 770095259,
 -1,
 -53780,
 770360157,
 129003,
 -1,
 770388466,
 128996,
 770584048,
 770042468,
 -1,
 -53777,
 770556765,
 129000,
 -1,
 770585074,
 128993,
 770780659,
 770560703,
 -1,
 -53774,
 770749943,
 68414,
 -1,
 770784756,
 68412,
 770977270,
 770748518,
 -1,
 -53771,
 770949981,
 128997,
 -1,
 770978290,
 128308,
 771173881,
 770943681,
 -1,
 -53768,
 771146589,
 129002,
 -1,
 771174898,
 128995,
 771424255,
 771119466,
 -1,
 -53765,
 771343197,
 129001,
 -1,
 771371506,
 128994,
 -1,
 769418200,
 8382,
 771632668,
 769365017,
 -1,
 771698203,
 771587414,
 -1,
 771763728,
 771662713,
 -1,
 771829253,
 771701005,
 -1,
 771894788,
 771766541,
 -1,
 -53757,
 771840541,
 3730,
 -1,
 771889542,
 3729,
 -1,
 771840541,
 3736,
 772156936,
 771805500,
 -1,
 -53753,
 772102685,
 3728,
 -1,
 772151686,
 3727,
 772353547,
 772115500,
 -1,
 -53750,
 772336031,
 3726,
 -1,
 772377718,
 3731,
 -53748,
 772308969,
 3756,
 -53747,
 772502178,
 3724,
 -53746,
 772560713,
 3718,
 -53745,
 772616303,
 3721,
 -1,
 772680191,
 3744,
 772877843,
 771734421,
 -1,
 -53742,
 772848342,
 3753,
 -1,
 772889117,
 3752,
 773074454,
 772830587,
 -1,
 -53739,
 773035021,
 3807,
 -1,
 773085336,
 3806,
 773271065,
 773018156,
 -1,
 -53736,
 773232570,
 983204,
 -1,
 773269280,
 983205,
 -53734,
 773240700,
 983206,
 -1,
 773423238,
 983207,
 -1,
 771669992,
 3770,
 773664287,
 771605591,
 -1,
 -53730,
 773645410,
 127772,
 -1,
 773703518,
 127767,
 773860898,
 773597023,
 -1,
 -53727,
 773801737,
 127991,
 -1,
 773849580,
 129404,
 -53725,
 773800423,
 128030,
 -1,
 773994260,
 129357,
 774188823,
 727925246,
 -1,
 774254250,
 774132832,
 -1,
 774319736,
 774234459,
 -1,
 774385227,
 774293409,
 -1,
 774450749,
 774353628,
 -1,
 774516284,
 774377229,
 -1,
 774581818,
 774448146,
 11104,
 774701055,
 774504448,
 -1,
 774712888,
 774628428,
 -1,
 774778416,
 774668551,
 -1,
 -53713,
 774756705,
 11172,
 -1,
 774783128,
 11174,
 774975027,
 774717044,
 -1,
 -53710,
 774954517,
 983237,
 -1,
 774988060,
 11130,
 -53708,
 774954584,
 129072,
 -53707,
 775130338,
 129056,
 -53706,
 775194365,
 129060,
 -53705,
 775249219,
 129068,
 -1,
 775302111,
 129064,
 -53703,
 774688337,
 11120,
 -1,
 775463244,
 11136,
 -53701,
 774546261,
 11140,
 -1,
 775567930,
 11114,
 -1,
 774439192,
 129168,
 775827018,
 774432520,
 -1,
 775892553,
 775758872,
 -1,
 775958088,
 775873612,
 -1,
 776023622,
 775931809,
 -1,
 776089157,
 775953827,
 11067,
 776208383,
 776014690,
 -1,
 -53692,
 776134165,
 11068,
 -1,
 776159148,
 11069,
 -1,
 776057572,
 11244,
 -53689,
 776003093,
 11060,
 -1,
 776355756,
 11061,
 -1,
 775902220,
 11062,
 -1,
 775868627,
 11063,
 -1,
 775789280,
 129186,
 776744546,
 774317080,
 -1,
 776810076,
 776725580,
 -1,
 776875604,
 776783777,
 -1,
 776941137,
 776826346,
 -1,
 -53680,
 776919393,
 11025,
 -1,
 776945816,
 11024,
 777191423,
 776871335,
 -1,
 -53677,
 777117205,
 11065,
 -1,
 777142188,
 11066,
 777334359,
 776847632,
 -1,
 -53674,
 777310204,
 129024,
 -1,
 777341424,
 129040,
 -53672,
 777294287,
 129176,
 -53671,
 777488152,
 129028,
 -53670,
 777550031,
 129032,
 -53669,
 777603568,
 129044,
 -1,
 777666118,
 11064,
 777858657,
 776739556,
 -1,
 777924192,
 777826835,
 -1,
 -53665,
 777899301,
 11083,
 -1,
 777920355,
 11074,
 -1,
 777854819,
 11082,
 -1,
 777833553,
 11070,
 778251880,
 776677215,
 -1,
 778317414,
 778205061,
 -1,
 -53659,
 778252905,
 11144,
 -1,
 778314770,
 11013,
 -53657,
 778280542,
 129184,
 -1,
 778443628,
 129192,
 778645099,
 778222081,
 -1,
 -53654,
 778611660,
 129080,
 -1,
 778641880,
 129104,
 778841710,
 778611910,
 -1,
 -53651,
 778802413,
 128620,
 -1,
 778856218,
 129190,
 779038321,
 778788139,
 -1,
 -53648,
 778974447,
 129088,
 -1,
 779035666,
 129092,
 779234932,
 778981009,
 -1,
 -53645,
 779204580,
 129194,
 -1,
 779250553,
 129076,
 -53643,
 779215631,
 129172,
 -53642,
 779398024,
 11077,
 -53641,
 779451362,
 129188,
 -1,
 779498735,
 129084,
 779693729,
 774242304,
 -1,
 779759236,
 779639325,
 -1,
 779824771,
 779713997,
 -1,
 779890306,
 779760114,
 129287,
 780009471,
 779815778,
 -1,
 780021376,
 779929505,
 -1,
 -53633,
 780002863,
 129285,
 -1,
 780034568,
 129284,
 -53631,
 779965198,
 129283,
 -1,
 780156243,
 129286,
 -1,
 779823897,
 11240,
 -1,
 779783547,
 128379,
 780480139,
 779726022,
 -1,
 780545674,
 780429010,
 -1,
 -53625,
 780526326,
 11012,
 -53624,
 780587074,
 11108,
 -53623,
 780647300,
 129112,
 -1,
 780675815,
 11020,
 -1,
 780475933,
 11788,
 780938896,
 780450305,
 -1,
 -53619,
 780916099,
 11778,
 -53618,
 780969208,
 128488,
 -53617,
 781018516,
 11814,
 -1,
 781062081,
 10181,
 781266581,
 780867974,
 -1,
 781332116,
 781236447,
 -1,
 -53613,
 781304166,
 11056,
 -1,
 781333054,
 11058,
 -1,
 781291443,
 128494,
 781594264,
 781240225,
 -1,
 -53609,
 781561487,
 11785,
 -1,
 781607310,
 128492,
 781790875,
 781547279,
 -1,
 -53606,
 781768222,
 128709,
 -1,
 781820396,
 11804,
 781987486,
 781729042,
 -1,
 -53603,
 781964561,
 11816,
 -1,
 782029133,
 11780,
 -53601,
 781969381,
 128398,
 -53600,
 782163388,
 11808,
 -1,
 782185374,
 9948,
 782434303,
 779620005,
 -1,
 782446247,
 782323449,
 -1,
 782511781,
 782419716,
 4054,
 -1,
 782437442,
 4056,
 -53594,
 782455072,
 129307,
 -1,
 782574531,
 1422,
 -53592,
 782421617,
 8294,
 -53591,
 782739523,
 128269,
 -1,
 782785467,
 9958,
 782970639,
 774218953,
 -1,
 783036129,
 782925142,
 -1,
 783101621,
 783009697,
 -1,
 783167152,
 783075233,
 -1,
 -53585,
 783112733,
 7246,
 -1,
 783161734,
 7245,
 783363763,
 783137281,
 -1,
 -53582,
 783309341,
 7192,
 -1,
 783358342,
 7191,
 -53580,
 783309341,
 7179,
 -1,
 783489414,
 7178,
 783691449,
 783065775,
 -1,
 -53577,
 783644505,
 7183,
 -53576,
 783702557,
 7184,
 -1,
 783751558,
 7182,
 783953597,
 783649836,
 -1,
 -53573,
 783935903,
 7177,
 -53572,
 783963415,
 7173,
 -1,
 784013702,
 7181,
 784215745,
 783905593,
 -1,
 -53569,
 784168793,
 7169,
 -53568,
 784226845,
 7170,
 -1,
 784275846,
 7168,
 784477893,
 784152845,
 -1,
 -53565,
 784460894,
 7193,
 -53564,
 784480668,
 7247,
 -1,
 784537990,
 7180,
 784740040,
 784448001,
 -1,
 -53561,
 784685597,
 7201,
 -1,
 784734598,
 7200,
 784936651,
 784696179,
 -1,
 -53558,
 784889689,
 7190,
 -1,
 784931206,
 7189,
 785133262,
 784882187,
 -1,
 -53555,
 785086297,
 7198,
 -1,
 785127814,
 7197,
 785329873,
 785077448,
 -1,
 -53552,
 785282905,
 7172,
 -1,
 785324422,
 7171,
 785526484,
 785272465,
 -1,
 -53549,
 785479513,
 7186,
 -1,
 785521030,
 7185,
 785723095,
 785460643,
 -1,
 -53546,
 785668637,
 7175,
 -1,
 785717638,
 7174,
 785919706,
 785655647,
 -1,
 -53543,
 785872729,
 7188,
 -1,
 785914246,
 7187,
 -53541,
 785901983,
 7194,
 -53540,
 786096379,
 7202,
 -53539,
 786160579,
 7199,
 -53538,
 786214208,
 7195,
 -53537,
 786265945,
 7196,
 -53536,
 786330155,
 7176,
 -1,
 786372998,
 7203,
 786575087,
 782974051,
 -1,
 786640613,
 786548641,
 -1,
 -53532,
 786621974,
 7234,
 -1,
 786653664,
 7235,
 786837224,
 786610689,
 -1,
 -53529,
 786788720,
 7238,
 -1,
 786844821,
 7239,
 787033835,
 786779793,
 -1,
 -53526,
 786996989,
 7236,
 -1,
 787050686,
 7237,
 -53524,
 787016987,
 7232,
 -53523,
 787191893,
 7233,
 -53522,
 787255368,
 7241,
 -1,
 787302022,
 7240,
 787492601,
 786511192,
 -1,
 787558130,
 787450924,
 7216,
 -1,
 787540710,
 7220,
 787689204,
 787510073,
 7213,
 -1,
 787620178,
 7221,
 -53515,
 787662753,
 7219,
 -53514,
 787786950,
 7218,
 -53513,
 787849903,
 7217,
 -53512,
 787907443,
 7214,
 -1,
 787969807,
 7215,
 788147969,
 787472438,
 -1,
 788213500,
 788124570,
 7210,
 -1,
 788190106,
 7211,
 788344574,
 788173847,
 7208,
 -1,
 788304919,
 7209,
 -53505,
 788292525,
 7207,
 -53504,
 788414974,
 7212,
 -1,
 788470347,
 7206,
 788672264,
 788114005,
 -1,
 788737798,
 788645793,
 -1,
 788803333,
 788709079,
 7231,
 -1,
 788726211,
 7230,
 -1,
 788732468,
 7227,
 -53497,
 788698091,
 7228,
 -1,
 788934689,
 7229,
 789184511,
 788642305,
 -1,
 789196556,
 789107893,
 -1,
 -53493,
 789178783,
 7204,
 -1,
 789228864,
 7205,
 789446655,
 789145465,
 -1,
 -53490,
 789360222,
 7222,
 -1,
 789418819,
 7223,
 789589778,
 782900421,
 -1,
 -53487,
 789571909,
 129388,
 -1,
 789578457,
 127811,
 -53485,
 789568749,
 127898,
 -53484,
 789748470,
 128006,
 -53483,
 789809762,
 127819,
 -53482,
 789861576,
 129461,
 -1,
 789920677,
 128210,
 790114132,
 774170916,
 -1,
 790179638,
 790049223,
 -1,
 790245148,
 790153121,
 66199,
 -53477,
 790218657,
 66200,
 -1,
 790256139,
 66185,
 790441758,
 790203436,
 66191,
 -1,
 790400044,
 66193,
 790572832,
 790397811,
 66190,
 -1,
 790528883,
 66192,
 790703906,
 790524729,
 66187,
 -1,
 790655801,
 66196,
 790834980,
 790643198,
 66177,
 -1,
 790793260,
 66202,
 790966054,
 790767455,
 66178,
 -1,
 790911499,
 66179,
 791097128,
 790894982,
 66176,
 -1,
 791055404,
 66201,
 -53463,
 791079984,
 66184,
 -53462,
 791210003,
 66204,
 -53461,
 791273659,
 66183,
 -53460,
 791335834,
 66194,
 -53459,
 791394817,
 66198,
 -53458,
 791456966,
 66197,
 -53457,
 791522049,
 66188,
 -53456,
 791585455,
 66195,
 -53455,
 791639823,
 66189,
 -53454,
 791704077,
 66186,
 -53453,
 791765933,
 66182,
 -53452,
 791829003,
 66203,
 -53451,
 791893192,
 66180,
 -1,
 791951629,
 66181,
 792145747,
 790117433,
 -1,
 792211282,
 792100182,
 -1,
 792276794,
 792184737,
 67887,
 -1,
 792250273,
 67892,
 792407868,
 792246785,
 67891,
 -1,
 792377857,
 67886,
 792538942,
 792366124,
 67883,
 -1,
 792497196,
 67896,
 792670016,
 792491791,
 67881,
 -1,
 792652068,
 67895,
 792801090,
 792609278,
 67876,
 -1,
 792759340,
 67894,
 792932164,
 792729990,
 67872,
 -1,
 792890412,
 67893,
 -53435,
 792914212,
 67879,
 -53434,
 793041840,
 67877,
 -53433,
 793105306,
 67888,
 -53432,
 793160902,
 67885,
 -53431,
 793225985,
 67890,
 -53430,
 793285655,
 67884,
 -53429,
 793346931,
 67882,
 -53428,
 793408313,
 67880,
 -53427,
 793469869,
 67878,
 -53426,
 793531592,
 67874,
 -53425,
 793595537,
 67889,
 -53424,
 793655565,
 67875,
 -53423,
 793718179,
 67897,
 -1,
 793782111,
 67873,
 -1,
 792187002,
 67903,
 -1,
 792095355,
 129317,
 794111858,
 790074391,
 -1,
 794177379,
 794091707,
 -1,
 794242911,
 794118665,
 -1,
 794308446,
 794196720,
 -1,
 794373979,
 794272431,
 -1,
 -53414,
 794314816,
 128393,
 -1,
 794369480,
 128396,
 -53412,
 794317530,
 128395,
 -53411,
 794506878,
 128397,
 -1,
 794568713,
 128394,
 -1,
 794276914,
 128318,
 794886143,
 794165248,
 -1,
 794898274,
 794784905,
 11847,
 -1,
 794823719,
 11848,
 -1,
 794832060,
 128261,
 795094888,
 794112767,
 128274,
 795160423,
 795044700,
 -1,
 -53402,
 795143451,
 983079,
 -1,
 795187285,
 983076,
 -1,
 795086144,
 128271,
 795422571,
 795073691,
 -1,
 -53398,
 795376975,
 128140,
 -1,
 795435396,
 127977,
 795619182,
 795381588,
 -1,
 -53395,
 795573454,
 11059,
 -1,
 795622646,
 10188,
 -53393,
 795596247,
 128557,
 -53392,
 795790816,
 129524,
 -53391,
 795836467,
 127853,
 -1,
 795880698,
 129438,
 796077943,
 794078406,
 -1,
 -53388,
 796038167,
 983225,
 -53387,
 796099443,
 983220,
 -53386,
 796156845,
 983230,
 -1,
 796213758,
 983222,
 -53384,
 796055070,
 129523,
 -53383,
 796358726,
 129433,
 -1,
 796413585,
 983065,
 796603822,
 671891966,
 -1,
 796668981,
 796546248,
 -1,
 796734516,
 796650453,
 -1,
 796798973,
 796662150,
 -1,
 796864470,
 796725292,
 -1,
 796929934,
 796791978,
 -1,
 796995458,
 796857726,
 77877,
 -1,
 796924294,
 77878,
 797126532,
 796922764,
 77874,
 -1,
 797055366,
 77875,
 797257606,
 797053543,
 77872,
 -1,
 797186438,
 77873,
 797388680,
 797184044,
 77869,
 -1,
 797317510,
 77870,
 -53367,
 797317332,
 77882,
 -53366,
 797448227,
 77881,
 -53365,
 797513539,
 77880,
 -53364,
 797578867,
 77879,
 -53363,
 797643946,
 77876,
 -1,
 797708604,
 77871,
 797912987,
 796856636,
 -1,
 797978513,
 797841219,
 77844,
 -1,
 797907334,
 77845,
 798109587,
 797906090,
 77840,
 -1,
 798038406,
 77841,
 -53356,
 798038228,
 77847,
 -53355,
 798169123,
 77846,
 -53354,
 798234227,
 77843,
 -53353,
 798299518,
 77842,
 -53352,
 798364556,
 77839,
 -53351,
 798429799,
 77838,
 -53350,
 798495036,
 77837,
 -1,
 798560300,
 77836,
 798764968,
 797839404,
 -1,
 798830495,
 798692979,
 77830,
 -53346,
 798762847,
 77832,
 -1,
 798824838,
 77831,
 799027105,
 798758270,
 77828,
 -1,
 798955910,
 77829,
 -53342,
 798955732,
 77835,
 -53341,
 799086627,
 77834,
 -53340,
 799151939,
 77833,
 -53339,
 799216810,
 77827,
 -53338,
 799282060,
 77826,
 -53337,
 799347303,
 77825,
 -1,
 799412540,
 77824,
 799616948,
 798692236,
 -1,
 799682475,
 799543911,
 77860,
 -1,
 799611270,
 77861,
 -53332,
 799611092,
 77868,
 -53331,
 799741987,
 77867,
 -53330,
 799807299,
 77866,
 -53329,
 799872627,
 77865,
 -53328,
 799937918,
 77864,
 -53327,
 800003242,
 77863,
 -53326,
 800068492,
 77862,
 -53325,
 800133436,
 77859,
 -1,
 800198700,
 77858,
 800403391,
 799544947,
 -1,
 -53322,
 800331988,
 77902,
 -53321,
 800397347,
 77901,
 -53320,
 800462659,
 77900,
 -53319,
 800527987,
 77899,
 -53318,
 800593278,
 77898,
 -53317,
 800658602,
 77897,
 -53316,
 800723852,
 77896,
 -53315,
 800789095,
 77895,
 -53314,
 800854332,
 77894,
 -1,
 800919596,
 77893,
 801124298,
 800331134,
 -1,
 -53311,
 801052884,
 77892,
 -53310,
 801118243,
 77891,
 -53309,
 801183555,
 77890,
 -53308,
 801248883,
 77889,
 -53307,
 801314174,
 77888,
 -53306,
 801379498,
 77887,
 -53305,
 801444748,
 77886,
 -53304,
 801509991,
 77885,
 -53303,
 801575228,
 77884,
 -1,
 801640492,
 77883,
 801845205,
 801051239,
 -1,
 -53300,
 801773780,
 77857,
 -53299,
 801839139,
 77856,
 -53298,
 801904451,
 77855,
 -53297,
 801969779,
 77854,
 -53296,
 802035070,
 77853,
 -53295,
 802100394,
 77852,
 -53294,
 802165644,
 77851,
 -53293,
 802230887,
 77850,
 -53292,
 802296124,
 77849,
 -1,
 802361388,
 77848,
 -1,
 801773566,
 77903,
 802684927,
 796793406,
 -1,
 802697187,
 802557996,
 -1,
 802762715,
 802625347,
 78867,
 -53286,
 802695007,
 78869,
 -1,
 802756998,
 78868,
 -53284,
 802691284,
 78871,
 -53283,
 802887715,
 78870,
 -53282,
 802952819,
 78866,
 -53281,
 803018110,
 78865,
 -53280,
 803083434,
 78864,
 -53279,
 803148684,
 78863,
 -53278,
 803213927,
 78862,
 -1,
 803279164,
 78861,
 803483630,
 802624103,
 -1,
 -53275,
 803412180,
 78891,
 -53274,
 803477539,
 78890,
 -53273,
 803542851,
 78889,
 -53272,
 803608179,
 78888,
 -53271,
 803673470,
 78887,
 -53270,
 803738794,
 78886,
 -53269,
 803804044,
 78885,
 -53268,
 803869287,
 78884,
 -53267,
 803934524,
 78883,
 -1,
 803999788,
 78882,
 804204537,
 803410236,
 -1,
 -53264,
 804133076,
 78881,
 -53263,
 804198435,
 78880,
 -53262,
 804263747,
 78879,
 -53261,
 804329075,
 78878,
 -53260,
 804394366,
 78877,
 -53259,
 804459690,
 78876,
 -53258,
 804524940,
 78875,
 -53257,
 804590183,
 78874,
 -53256,
 804655420,
 78873,
 -1,
 804720684,
 78872,
 804978687,
 804131724,
 -1,
 -53253,
 804852327,
 78894,
 -53252,
 804917564,
 78893,
 -1,
 804982828,
 78892,
 805187692,
 796757036,
 -1,
 805253173,
 805113900,
 -1,
 805318670,
 805180300,
 -1,
 805384194,
 805246787,
 78361,
 -1,
 805312902,
 78362,
 805515268,
 805311870,
 78358,
 -1,
 805443974,
 78359,
 805646342,
 805442730,
 78356,
 -1,
 805575046,
 78357,
 805777416,
 805573516,
 78354,
 -1,
 805706118,
 78355,
 -53239,
 805705940,
 78364,
 -53238,
 805836835,
 78363,
 -53237,
 805901939,
 78360,
 -53236,
 805966439,
 78353,
 -53235,
 806031676,
 78352,
 -1,
 806096940,
 78351,
 806301723,
 805245244,
 -1,
 806367250,
 806230051,
 78336,
 -53231,
 806299487,
 78338,
 -1,
 806361478,
 78337,
 -53229,
 806295764,
 78339,
 -53228,
 806491971,
 78335,
 -53227,
 806557299,
 78334,
 -53226,
 806622590,
 78333,
 -53225,
 806687914,
 78332,
 -53224,
 806753164,
 78331,
 -53223,
 806818407,
 78330,
 -53222,
 806883644,
 78329,
 -1,
 806948908,
 78328,
 807153703,
 806228583,
 -1,
 807219230,
 807081342,
 78345,
 -1,
 807147910,
 78346,
 -53217,
 807147732,
 78350,
 -53216,
 807278627,
 78349,
 -53215,
 807343939,
 78348,
 -53214,
 807409267,
 78347,
 -53213,
 807474346,
 78344,
 -53212,
 807539596,
 78343,
 -53211,
 807604839,
 78342,
 -53210,
 807670076,
 78341,
 -1,
 807735340,
 78340,
 807940145,
 807079980,
 -1,
 -53207,
 807868628,
 78327,
 -53206,
 807933987,
 78326,
 -53205,
 807999299,
 78325,
 -53204,
 808064627,
 78324,
 -53203,
 808129918,
 78323,
 -53202,
 808195242,
 78322,
 -53201,
 808260492,
 78321,
 -53200,
 808325735,
 78320,
 -1,
 808390972,
 78319,
 808648703,
 807867562,
 -1,
 -53197,
 808522343,
 78367,
 -53196,
 808587580,
 78366,
 -1,
 808652844,
 78365,
 808857683,
 805229599,
 -1,
 808923204,
 808784188,
 -1,
 808988729,
 808851491,
 78409,
 -1,
 808917382,
 78410,
 809119803,
 808915260,
 78401,
 -1,
 809048454,
 78402,
 809250877,
 809046060,
 78399,
 -1,
 809179526,
 78400,
 -53186,
 809179348,
 78411,
 -53185,
 809310019,
 78408,
 -53184,
 809375347,
 78407,
 -53183,
 809440638,
 78406,
 -53182,
 809505962,
 78405,
 -53181,
 809571212,
 78404,
 -1,
 809636455,
 78403,
 809840718,
 808849452,
 -1,
 -53178,
 809769172,
 78398,
 -53177,
 809834531,
 78397,
 -53176,
 809899843,
 78396,
 -53175,
 809965171,
 78395,
 -53174,
 810030462,
 78394,
 -53173,
 810095786,
 78393,
 -53172,
 810161036,
 78392,
 -53171,
 810226279,
 78391,
 -1,
 810291516,
 78390,
 810549247,
 809767527,
 -1,
 810561617,
 810422887,
 78414,
 -1,
 810490246,
 78415,
 -53166,
 810488124,
 78413,
 -1,
 810618924,
 78412,
 810876927,
 808810319,
 -1,
 810889312,
 810750268,
 -1,
 810954839,
 810817347,
 78385,
 -1,
 810883462,
 78386,
 -53160,
 810883284,
 78388,
 -53159,
 811014179,
 78387,
 -53158,
 811079283,
 78384,
 -53157,
 811144574,
 78383,
 -53156,
 811209898,
 78382,
 -53155,
 811275148,
 78381,
 -53154,
 811340391,
 78380,
 -53153,
 811405628,
 78379,
 -1,
 811470892,
 78378,
 811675755,
 810815532,
 -1,
 811741283,
 811603326,
 78372,
 -1,
 811669894,
 78373,
 -53148,
 811669716,
 78377,
 -53147,
 811800611,
 78376,
 -53146,
 811865923,
 78375,
 -53145,
 811931251,
 78374,
 -53144,
 811996330,
 78371,
 -53143,
 812061580,
 78370,
 -53142,
 812126823,
 78369,
 -1,
 812192060,
 78368,
 -1,
 811602780,
 78389,
 812462288,
 805124497,
 -1,
 812527747,
 812389758,
 -1,
 812593272,
 812453932,
 77997,
 -53136,
 812540845,
 78006,
 -53135,
 812603915,
 78005,
 -53134,
 812668104,
 78004,
 -53133,
 812732049,
 78003,
 -53132,
 812794366,
 78002,
 -53131,
 812857613,
 78001,
 -53130,
 812920227,
 78000,
 -53129,
 812984159,
 77999,
 -1,
 813046150,
 77998,
 813248634,
 812520618,
 78011,
 -1,
 813177222,
 78012,
 813379708,
 813175399,
 78008,
 -1,
 813308294,
 78009,
 -53123,
 813308116,
 78017,
 -53122,
 813439011,
 78016,
 -53121,
 813504323,
 78015,
 -53120,
 813569651,
 78014,
 -53119,
 813634942,
 78013,
 -53118,
 813699980,
 78010,
 -1,
 813764924,
 78007,
 813969556,
 812455539,
 -1,
 814035085,
 813897539,
 78025,
 -53114,
 813980171,
 78033,
 -53113,
 814044360,
 78032,
 -53112,
 814108305,
 78031,
 -53111,
 814170622,
 78030,
 -53110,
 814233869,
 78029,
 -53109,
 814296483,
 78028,
 -53108,
 814360415,
 78027,
 -1,
 814422406,
 78026,
 -53106,
 813962867,
 78024,
 -53105,
 814552446,
 78023,
 -53104,
 814617770,
 78022,
 -53103,
 814683020,
 78021,
 -53102,
 814748263,
 78020,
 -53101,
 814813500,
 78019,
 -1,
 814878764,
 78018,
 815083681,
 813896874,
 -1,
 815149207,
 815011875,
 77994,
 -1,
 815077766,
 77995,
 815280281,
 815076979,
 77991,
 -1,
 815208838,
 77992,
 -53094,
 815208660,
 77996,
 -53093,
 815339331,
 77993,
 -53092,
 815404414,
 77990,
 -53091,
 815469738,
 77989,
 -53090,
 815534988,
 77988,
 -53089,
 815600231,
 77987,
 -53088,
 815665468,
 77986,
 -1,
 815730732,
 77985,
 815935662,
 815010700,
 -1,
 816001188,
 815862954,
 77978,
 -1,
 815929734,
 77979,
 816132262,
 815927612,
 77974,
 -1,
 816060806,
 77975,
 -53081,
 816060628,
 77984,
 -53080,
 816191523,
 77983,
 -53079,
 816256835,
 77982,
 -53078,
 816322163,
 77981,
 -53077,
 816387454,
 77980,
 -53076,
 816452492,
 77977,
 -53075,
 816517735,
 77976,
 -1,
 816582700,
 77973,
 816787642,
 815862375,
 -1,
 816853169,
 816715587,
 77969,
 -1,
 816781702,
 77970,
 -53070,
 816781524,
 77972,
 -53069,
 816912419,
 77971,
 -53068,
 816977523,
 77968,
 -53067,
 817042814,
 77967,
 -53066,
 817108138,
 77966,
 -53065,
 817173388,
 77965,
 -53064,
 817238631,
 77964,
 -53063,
 817303868,
 77963,
 -1,
 817369132,
 77962,
 817574085,
 816714044,
 -1,
 -53060,
 817502420,
 77961,
 -53059,
 817567779,
 77960,
 -53058,
 817633091,
 77959,
 -53057,
 817698419,
 77958,
 -53056,
 817763710,
 77957,
 -53055,
 817829034,
 77956,
 -53054,
 817894284,
 77955,
 -53053,
 817959527,
 77954,
 -53052,
 818024764,
 77953,
 -1,
 818090028,
 77952,
 818348031,
 817500204,
 -1,
 818360520,
 818223139,
 77949,
 -1,
 818289030,
 77950,
 -53047,
 818288852,
 77951,
 -53046,
 818419523,
 77948,
 -53045,
 818484851,
 77947,
 -53044,
 818550142,
 77946,
 -53043,
 818615466,
 77945,
 -53042,
 818680716,
 77944,
 -53041,
 818745959,
 77943,
 -1,
 818811196,
 77942,
 819015972,
 812440496,
 -1,
 819081507,
 818941996,
 -1,
 819146988,
 819008103,
 -1,
 819212512,
 819073068,
 78726,
 -53035,
 819164943,
 78738,
 -53034,
 819229497,
 78737,
 -53033,
 819294733,
 78736,
 -53032,
 819356589,
 78735,
 -53031,
 819419659,
 78734,
 -53030,
 819483848,
 78733,
 -53029,
 819547793,
 78732,
 -53028,
 819610110,
 78731,
 -53027,
 819673357,
 78730,
 -53026,
 819735971,
 78729,
 -53025,
 819799903,
 78728,
 -1,
 819861894,
 78727,
 820064482,
 819140820,
 78749,
 -1,
 819992966,
 78750,
 820195556,
 819992611,
 78747,
 -1,
 820124038,
 78748,
 820326630,
 820122508,
 78741,
 -1,
 820255110,
 78742,
 -53017,
 820254531,
 78746,
 -53016,
 820385395,
 78745,
 -53015,
 820450686,
 78744,
 -53014,
 820516010,
 78743,
 -53013,
 820580967,
 78740,
 -1,
 820646204,
 78739,
 820850946,
 819073068,
 -1,
 820916471,
 820777276,
 78690,
 -53009,
 820863917,
 78699,
 -53008,
 820926987,
 78698,
 -53007,
 820991176,
 78697,
 -53006,
 821055121,
 78696,
 -53005,
 821117438,
 78695,
 -53004,
 821180685,
 78694,
 -53003,
 821243299,
 78693,
 -53002,
 821307231,
 78692,
 -1,
 821369222,
 78691,
 821571834,
 820844355,
 78706,
 -52999,
 821503839,
 78708,
 -1,
 821565830,
 78707,
 821768444,
 821498471,
 78700,
 -1,
 821696902,
 78701,
 -52995,
 821696724,
 78710,
 -52994,
 821827619,
 78709,
 -52993,
 821892723,
 78705,
 -52992,
 821958014,
 78704,
 -52991,
 822023338,
 78703,
 -1,
 822088588,
 78702,
 822292754,
 820777276,
 -1,
 822358279,
 822219068,
 78712,
 -52987,
 822291875,
 78715,
 -52986,
 822355807,
 78714,
 -1,
 822417798,
 78713,
 822620426,
 822284903,
 78716,
 -52983,
 822552415,
 78718,
 -1,
 822614406,
 78717,
 -52981,
 822548692,
 78725,
 -52980,
 822745123,
 78724,
 -52979,
 822810435,
 78723,
 -52978,
 822875763,
 78722,
 -52977,
 822941054,
 78721,
 -52976,
 823006378,
 78720,
 -52975,
 823071628,
 78719,
 -1,
 823136300,
 78711,
 823341345,
 822219660,
 -1,
 823406869,
 823269187,
 78761,
 -1,
 823335302,
 78762,
 823537943,
 823333772,
 78756,
 -1,
 823466374,
 78757,
 823669017,
 823464252,
 78753,
 -1,
 823597446,
 78754,
 823800091,
 823595052,
 78751,
 -1,
 823728518,
 78752,
 -52964,
 823728340,
 78764,
 -52963,
 823859235,
 78763,
 -52962,
 823924339,
 78760,
 -52961,
 823989630,
 78759,
 -52960,
 824054954,
 78758,
 -1,
 824119911,
 78755,
 824377343,
 823268713,
 78765,
 -1,
 824252806,
 78766,
 -1,
 819022587,
 78896,
 824521080,
 818975767,
 -1,
 824586615,
 824447020,
 -1,
 824652088,
 824512556,
 -1,
 824717614,
 824579699,
 78423,
 -52951,
 824659601,
 78429,
 -52950,
 824721918,
 78428,
 -52949,
 824785165,
 78427,
 -52948,
 824847779,
 78426,
 -52947,
 824911711,
 78425,
 -1,
 824973702,
 78424,
 825176368,
 824644990,
 78421,
 -1,
 825104774,
 78422,
 825307442,
 825102652,
 78416,
 -1,
 825235846,
 78417,
 -52941,
 825235668,
 78432,
 -52940,
 825366563,
 78431,
 -52939,
 825431875,
 78430,
 -52938,
 825496746,
 78420,
 -52937,
 825561996,
 78419,
 -1,
 825627239,
 78418,
 825831753,
 824578956,
 -1,
 825897278,
 825759347,
 78469,
 -52933,
 825833741,
 78473,
 -52932,
 825896355,
 78472,
 -52931,
 825960287,
 78471,
 -1,
 826022278,
 78470,
 826224960,
 825824140,
 78465,
 -1,
 826153350,
 78466,
 826356034,
 826150956,
 78461,
 -1,
 826284422,
 78462,
 -52925,
 826284244,
 78476,
 -52924,
 826415139,
 78475,
 -52923,
 826480451,
 78474,
 -52922,
 826545534,
 78468,
 -52921,
 826610858,
 78467,
 -52920,
 826675815,
 78464,
 -1,
 826741052,
 78463,
 826945880,
 825758311,
 -1,
 827011404,
 826874068,
 78459,
 -1,
 826939782,
 78460,
 827142478,
 826938750,
 78454,
 -1,
 827070854,
 78455,
 827273552,
 827069610,
 78452,
 -1,
 827201926,
 78453,
 827404626,
 827199532,
 78447,
 -1,
 827332998,
 78448,
 -52909,
 827332643,
 78458,
 -52908,
 827463491,
 78457,
 -52907,
 827528819,
 78456,
 -52906,
 827593612,
 78451,
 -52905,
 827658855,
 78450,
 -1,
 827724092,
 78449,
 827928935,
 826872124,
 -1,
 827994461,
 827854892,
 78433,
 -52901,
 827927971,
 78436,
 -52900,
 827991903,
 78435,
 -1,
 828053894,
 78434,
 828256607,
 827922644,
 78445,
 -1,
 828184966,
 78446,
 -52896,
 828184611,
 78444,
 -52895,
 828315459,
 78443,
 -52894,
 828380787,
 78442,
 -52893,
 828446078,
 78441,
 -52892,
 828511402,
 78440,
 -52891,
 828576652,
 78439,
 -52890,
 828641895,
 78438,
 -1,
 828707132,
 78437,
 828911986,
 827856042,
 -1,
 -52887,
 828840148,
 78486,
 -52886,
 828905507,
 78485,
 -52885,
 828970819,
 78484,
 -52884,
 829036147,
 78483,
 -52883,
 829101438,
 78482,
 -52882,
 829166762,
 78481,
 -52881,
 829232012,
 78480,
 -52880,
 829297255,
 78479,
 -52879,
 829362492,
 78478,
 -1,
 829427756,
 78477,
 829685759,
 828839294,
 -1,
 829698422,
 829558828,
 78487,
 -52875,
 829630303,
 78489,
 -1,
 829692294,
 78488,
 -1,
 829624636,
 78490,
 -1,
 824565092,
 78902,
 830026176,
 824476614,
 -1,
 830091664,
 829952316,
 -1,
 830157187,
 830018151,
 78268,
 -52868,
 830102027,
 78276,
 -52867,
 830166216,
 78275,
 -52866,
 830230161,
 78274,
 -52865,
 830292478,
 78273,
 -52864,
 830355725,
 78272,
 -52863,
 830418339,
 78271,
 -52862,
 830482271,
 78270,
 -1,
 830544262,
 78269,
 830747013,
 830084931,
 78283,
 -1,
 830675334,
 78284,
 830878087,
 830674547,
 78281,
 -1,
 830806406,
 78282,
 831009161,
 830805374,
 78279,
 -1,
 830937478,
 78280,
 831140235,
 830935084,
 78265,
 -1,
 831068550,
 78266,
 -52852,
 831068372,
 78286,
 -52851,
 831199267,
 78285,
 -52850,
 831263914,
 78278,
 -52849,
 831329164,
 78277,
 -1,
 831394108,
 78267,
 831599006,
 830018444,
 -1,
 831664532,
 831525772,
 78304,
 -52845,
 831596383,
 78306,
 -1,
 831658374,
 78305,
 831861142,
 831590716,
 78301,
 -1,
 831789446,
 78302,
 -52841,
 831789268,
 78312,
 -52840,
 831920163,
 78311,
 -52839,
 831985475,
 78310,
 -52838,
 832050803,
 78309,
 -52837,
 832116094,
 78308,
 -52836,
 832181418,
 78307,
 -52835,
 832246375,
 78303,
 -1,
 832311340,
 78300,
 832516524,
 831525479,
 -1,
 832582049,
 832444451,
 78297,
 -1,
 832510342,
 78298,
 832713123,
 832509098,
 78292,
 -1,
 832641414,
 78293,
 832844197,
 832639591,
 78289,
 -1,
 832772486,
 78290,
 -52826,
 832772308,
 78299,
 -52825,
 832902979,
 78296,
 -52824,
 832968307,
 78295,
 -52823,
 833033598,
 78294,
 -52822,
 833098636,
 78291,
 -52821,
 833163580,
 78288,
 -1,
 833228844,
 78287,
 833434041,
 832442412,
 -1,
 833499568,
 833360188,
 78253,
 -52817,
 833431391,
 78255,
 -1,
 833493382,
 78254,
 833696178,
 833426316,
 78257,
 -1,
 833624454,
 78258,
 -52813,
 833624276,
 78264,
 -52812,
 833755171,
 78263,
 -52811,
 833820483,
 78262,
 -52810,
 833885811,
 78261,
 -52809,
 833951102,
 78260,
 -52808,
 834016426,
 78259,
 -1,
 834081383,
 78256,
 834338815,
 833361066,
 -1,
 834351548,
 834211884,
 78313,
 -1,
 834279814,
 78314,
 -52803,
 834278570,
 78318,
 -52802,
 834409356,
 78317,
 -52801,
 834474599,
 78316,
 -1,
 834539836,
 78315,
 834744840,
 829968088,
 -1,
 834810319,
 834671786,
 -1,
 834875844,
 834737987,
 78132,
 -1,
 834804102,
 78133,
 835006918,
 834803315,
 78130,
 -1,
 834935174,
 78131,
 835137992,
 834934142,
 78128,
 -1,
 835066246,
 78129,
 -52791,
 835066068,
 78135,
 -52790,
 835196963,
 78134,
 -52789,
 835261610,
 78127,
 -52788,
 835326860,
 78126,
 -52787,
 835392103,
 78125,
 -52786,
 835457340,
 78124,
 -1,
 835522604,
 78123,
 835727837,
 834737036,
 -1,
 835793362,
 835655715,
 78120,
 -1,
 835721606,
 78121,
 835924436,
 835721027,
 78118,
 -1,
 835852678,
 78119,
 836055510,
 835850556,
 78111,
 -1,
 835983750,
 78112,
 -52777,
 835983572,
 78122,
 -52776,
 836114035,
 78117,
 -52775,
 836179326,
 78116,
 -52774,
 836244650,
 78115,
 -52773,
 836309900,
 78114,
 -52772,
 836375143,
 78113,
 -1,
 836440108,
 78110,
 836645353,
 835654247,
 -1,
 836710880,
 836571452,
 78100,
 -1,
 836639110,
 78101,
 -52767,
 836638932,
 78109,
 -52766,
 836769827,
 78108,
 -52765,
 836835139,
 78107,
 -52764,
 836900467,
 78106,
 -52763,
 836965758,
 78105,
 -52762,
 837031082,
 78104,
 -52761,
 837096332,
 78103,
 -52760,
 837161575,
 78102,
 -1,
 837226540,
 78099,
 837431797,
 836571452,
 -1,
 837497324,
 837358476,
 78091,
 -1,
 837425542,
 78092,
 -52755,
 837425364,
 78098,
 -52754,
 837556259,
 78097,
 -52753,
 837621571,
 78096,
 -52752,
 837686899,
 78095,
 -52751,
 837752190,
 78094,
 -52750,
 837817514,
 78093,
 -52749,
 837882471,
 78090,
 -52748,
 837947708,
 78089,
 -1,
 838012972,
 78088,
 838218240,
 837357612,
 -1,
 838283768,
 838144316,
 78078,
 -1,
 838211974,
 78079,
 -52743,
 838211796,
 78087,
 -52742,
 838342691,
 78086,
 -52741,
 838408003,
 78085,
 -52740,
 838473331,
 78084,
 -52739,
 838538622,
 78083,
 -52738,
 838603946,
 78082,
 -52737,
 838669196,
 78081,
 -1,
 838734439,
 78080,
 838991871,
 838145406,
 -1,
 839004677,
 838865212,
 78137,
 -52733,
 838938019,
 78140,
 -52732,
 839001951,
 78139,
 -1,
 839063942,
 78138,
 -52730,
 838931340,
 78142,
 -52729,
 839193191,
 78141,
 -1,
 839258156,
 78136,
 839463503,
 834688267,
 -1,
 839528982,
 839390378,
 -1,
 839594508,
 839456126,
 78196,
 -1,
 839522694,
 78197,
 839725582,
 839521164,
 78193,
 -1,
 839653766,
 78194,
 -52721,
 839653588,
 78201,
 -52720,
 839784483,
 78200,
 -52719,
 839849795,
 78199,
 -52718,
 839915123,
 78198,
 -52717,
 839980202,
 78195,
 -52716,
 840045159,
 78192,
 -52715,
 840110396,
 78191,
 -1,
 840175660,
 78190,
 840380963,
 839455628,
 -1,
 840446489,
 840308547,
 78186,
 -1,
 840374662,
 78187,
 840577563,
 840373875,
 78184,
 -1,
 840505734,
 78185,
 -52708,
 840505556,
 78189,
 -52707,
 840636451,
 78188,
 -52706,
 840701310,
 78183,
 -52705,
 840766634,
 78182,
 -52704,
 840831884,
 78181,
 -52703,
 840897127,
 78180,
 -52702,
 840962364,
 78179,
 -1,
 841027628,
 78178,
 841232944,
 840307303,
 -1,
 841298470,
 841160307,
 78173,
 -1,
 841226630,
 78174,
 841429544,
 841224236,
 78166,
 -1,
 841357702,
 78167,
 -52695,
 841357524,
 78177,
 -52694,
 841488419,
 78176,
 -52693,
 841553731,
 78175,
 -52692,
 841618814,
 78172,
 -52691,
 841684138,
 78171,
 -52690,
 841749388,
 78170,
 -52689,
 841814631,
 78169,
 -1,
 841879868,
 78168,
 842084925,
 841158700,
 -1,
 842150452,
 842012483,
 78150,
 -52685,
 842082143,
 78152,
 -1,
 842144134,
 78151,
 842347062,
 842077811,
 78148,
 -1,
 842275206,
 78149,
 -52681,
 842275028,
 78154,
 -52680,
 842405923,
 78153,
 -52679,
 842470782,
 78147,
 -52678,
 842536106,
 78146,
 -52677,
 842601356,
 78145,
 -52676,
 842666599,
 78144,
 -1,
 842731836,
 78143,
 842936905,
 842010940,
 -1,
 843002432,
 842862908,
 78156,
 -1,
 842930566,
 78157,
 -52671,
 842930388,
 78165,
 -52670,
 843061283,
 78164,
 -52669,
 843126595,
 78163,
 -52668,
 843191923,
 78162,
 -52667,
 843257214,
 78161,
 -52666,
 843322538,
 78160,
 -52665,
 843387788,
 78159,
 -52664,
 843453031,
 78158,
 -1,
 843517996,
 78155,
 843775999,
 842863998,
 -1,
 -52661,
 843650218,
 78206,
 -52660,
 843715468,
 78205,
 -52659,
 843780711,
 78204,
 -52658,
 843845948,
 78203,
 -1,
 843911212,
 78202,
 844116619,
 839432915,
 -1,
 844182110,
 844042556,
 -1,
 844247636,
 844108970,
 78560,
 -52653,
 844179295,
 78562,
 -1,
 844241286,
 78561,
 844444246,
 844175171,
 78565,
 -1,
 844372358,
 78566,
 -52649,
 844372180,
 78568,
 -52648,
 844503075,
 78567,
 -52647,
 844568179,
 78564,
 -52646,
 844633470,
 78563,
 -52645,
 844698508,
 78559,
 -52644,
 844763751,
 78558,
 -52643,
 844828988,
 78557,
 -1,
 844894252,
 78556,
 845099627,
 844108391,
 -1,
 845165154,
 845026931,
 78575,
 -52639,
 845096799,
 78577,
 -1,
 845158790,
 78576,
 -52637,
 845093076,
 78580,
 -52636,
 845289507,
 78579,
 -52635,
 845354819,
 78578,
 -52634,
 845419902,
 78574,
 -52633,
 845485226,
 78573,
 -52632,
 845550476,
 78572,
 -52631,
 845615719,
 78571,
 -52630,
 845680956,
 78570,
 -1,
 845746220,
 78569,
 845951607,
 845026188,
 -1,
 846017134,
 845878654,
 78586,
 -1,
 845945222,
 78587,
 -52625,
 845945044,
 78591,
 -52624,
 846075939,
 78590,
 -52623,
 846141251,
 78589,
 -52622,
 846206579,
 78588,
 -52621,
 846271658,
 78585,
 -52620,
 846336908,
 78584,
 -52619,
 846402151,
 78583,
 -52618,
 846467388,
 78582,
 -1,
 846532652,
 78581,
 846738051,
 845877292,
 -1,
 846803578,
 846665331,
 78551,
 -1,
 846731654,
 78552,
 846934652,
 846729831,
 78546,
 -1,
 846862726,
 78547,
 -52611,
 846862548,
 78555,
 -52610,
 846993443,
 78554,
 -52609,
 847058755,
 78553,
 -52608,
 847123838,
 78550,
 -52607,
 847189162,
 78549,
 -52606,
 847254412,
 78548,
 -1,
 847319356,
 78545,
 847577087,
 846664874,
 -1,
 -52603,
 847451763,
 78598,
 -52602,
 847517054,
 78597,
 -52601,
 847582378,
 78596,
 -52600,
 847647628,
 78595,
 -52599,
 847712871,
 78594,
 -52598,
 847778108,
 78593,
 -1,
 847843372,
 78592,
 848048832,
 844092447,
 -1,
 848114329,
 847975015,
 -1,
 848179855,
 848042196,
 78674,
 -1,
 848107910,
 78675,
 848310929,
 848106380,
 78667,
 -1,
 848238982,
 78668,
 -52590,
 848238627,
 78673,
 -52589,
 848369475,
 78672,
 -52588,
 848434803,
 78671,
 -52587,
 848500094,
 78670,
 -52586,
 848565418,
 78669,
 -52585,
 848630375,
 78666,
 -52584,
 848695612,
 78665,
 -1,
 848760876,
 78664,
 848966309,
 848040844,
 -1,
 849031836,
 848892519,
 78678,
 -1,
 848959878,
 78679,
 -52579,
 848959700,
 78686,
 -52578,
 849090595,
 78685,
 -52577,
 849155907,
 78684,
 -52576,
 849221235,
 78683,
 -52575,
 849286526,
 78682,
 -52574,
 849351850,
 78681,
 -52573,
 849417100,
 78680,
 -52572,
 849482044,
 78677,
 -1,
 849547308,
 78676,
 849752753,
 848891948,
 -1,
 849818281,
 849679987,
 78648,
 -52568,
 849749855,
 78650,
 -1,
 849811846,
 78649,
 -52566,
 849746132,
 78653,
 -52565,
 849942563,
 78652,
 -52564,
 850007875,
 78651,
 -52563,
 850072958,
 78647,
 -52562,
 850138282,
 78646,
 -52561,
 850203532,
 78645,
 -52560,
 850268775,
 78644,
 -1,
 850334012,
 78643,
 850539196,
 849678652,
 -1,
 -52557,
 850467028,
 78663,
 -52556,
 850532387,
 78662,
 -52555,
 850597699,
 78661,
 -52554,
 850663027,
 78660,
 -52553,
 850728318,
 78659,
 -52552,
 850793642,
 78658,
 -52551,
 850858892,
 78657,
 -52550,
 850924135,
 78656,
 -52549,
 850989372,
 78655,
 -1,
 851054636,
 78654,
 851312639,
 850465962,
 -1,
 -52546,
 851186279,
 78689,
 -52545,
 851251516,
 78688,
 -1,
 851316780,
 78687,
 851522291,
 847987198,
 -1,
 851587826,
 851447852,
 -1,
 851653327,
 851513959,
 -1,
 851718853,
 851580963,
 78066,
 -1,
 851646854,
 78067,
 851849927,
 851644460,
 78057,
 -1,
 851777926,
 78058,
 -52536,
 851777748,
 78068,
 -52535,
 851908419,
 78065,
 -52534,
 851973747,
 78064,
 -52533,
 852039038,
 78063,
 -52532,
 852104362,
 78062,
 -52531,
 852169612,
 78061,
 -52530,
 852234855,
 78060,
 -1,
 852300092,
 78059,
 852505308,
 851579196,
 -1,
 852570834,
 852432707,
 78053,
 -1,
 852498822,
 78054,
 852701908,
 852498035,
 78051,
 -1,
 852629894,
 78052,
 -52523,
 852629716,
 78056,
 -52522,
 852760611,
 78055,
 -52521,
 852825470,
 78050,
 -52520,
 852890794,
 78049,
 -52519,
 852956044,
 78048,
 -52518,
 853021287,
 78047,
 -52517,
 853086524,
 78046,
 -1,
 853151788,
 78045,
 853357288,
 852430892,
 -1,
 853422815,
 853285076,
 78043,
 -1,
 853350790,
 78044,
 853553889,
 853350435,
 78041,
 -1,
 853481862,
 78042,
 -52510,
 853481283,
 78040,
 -52509,
 853612147,
 78039,
 -52508,
 853677438,
 78038,
 -52507,
 853742762,
 78037,
 -52506,
 853808012,
 78036,
 -52505,
 853873255,
 78035,
 -1,
 853938492,
 78034,
 854196223,
 853283724,
 -1,
 854209259,
 854070442,
 78073,
 -1,
 854137222,
 78074,
 -52500,
 854136867,
 78077,
 -52499,
 854267715,
 78076,
 -52498,
 854333043,
 78075,
 -52497,
 854397836,
 78072,
 -52496,
 854463079,
 78071,
 -52495,
 854528316,
 78070,
 -1,
 854593580,
 78069,
 -1,
 851545456,
 78904,
 854864676,
 851494948,
 -1,
 854930178,
 854790188,
 -1,
 854995703,
 854857940,
 78610,
 -1,
 854923654,
 78611,
 855126777,
 854923299,
 78608,
 -1,
 855054726,
 78609,
 855257851,
 855054147,
 78606,
 -1,
 855185798,
 78607,
 855388925,
 855184268,
 78601,
 -1,
 855316870,
 78602,
 -52482,
 855316083,
 78605,
 -52481,
 855446910,
 78604,
 -52480,
 855512234,
 78603,
 -52479,
 855577191,
 78600,
 -1,
 855642428,
 78599,
 855847695,
 854855996,
 -1,
 855913221,
 855774835,
 78619,
 -1,
 855841158,
 78620,
 856044295,
 855839036,
 78613,
 -1,
 855972230,
 78614,
 -52472,
 855972052,
 78623,
 -52471,
 856102947,
 78622,
 -52470,
 856168259,
 78621,
 -52469,
 856233342,
 78618,
 -52468,
 856298666,
 78617,
 -52467,
 856363916,
 78616,
 -52466,
 856429159,
 78615,
 -1,
 856494124,
 78612,
 856699674,
 855773799,
 -1,
 -52463,
 856627412,
 78633,
 -52462,
 856692771,
 78632,
 -52461,
 856758083,
 78631,
 -52460,
 856823411,
 78630,
 -52459,
 856888702,
 78629,
 -52458,
 856954026,
 78628,
 -52457,
 857019276,
 78627,
 -52456,
 857084519,
 78626,
 -52455,
 857149756,
 78625,
 -1,
 857215020,
 78624,
 857473023,
 856626060,
 -1,
 857486109,
 857346956,
 78638,
 -1,
 857414022,
 78639,
 857617183,
 857412199,
 78636,
 -1,
 857545094,
 78637,
 -52448,
 857544307,
 78642,
 -52447,
 857675134,
 78641,
 -52446,
 857740458,
 78640,
 -52445,
 857805116,
 78635,
 -1,
 857870380,
 78634,
 858075984,
 854846552,
 -1,
 858141502,
 858001724,
 -1,
 858207024,
 858068350,
 78842,
 -52440,
 858153901,
 78851,
 -52439,
 858216971,
 78850,
 -52438,
 858281160,
 78849,
 -52437,
 858345105,
 78848,
 -52436,
 858407422,
 78847,
 -52435,
 858470669,
 78846,
 -52434,
 858533283,
 78845,
 -52433,
 858597215,
 78844,
 -1,
 858659206,
 78843,
 858862393,
 858134131,
 78852,
 -52430,
 858806795,
 78860,
 -52429,
 858870984,
 78859,
 -52428,
 858934929,
 78858,
 -52427,
 858997246,
 78857,
 -52426,
 859060493,
 78856,
 -52425,
 859123107,
 78855,
 -52424,
 859187039,
 78854,
 -1,
 859249030,
 78853,
 -52422,
 858789034,
 78841,
 -52421,
 859378572,
 78840,
 -52420,
 859443815,
 78839,
 -52419,
 859509052,
 78838,
 -1,
 859574316,
 78837,
 859832319,
 858066988,
 -1,
 859845444,
 859705959,
 78821,
 -52415,
 859781389,
 78825,
 -52414,
 859844003,
 78824,
 -52413,
 859907935,
 78823,
 -1,
 859969926,
 78822,
 860173127,
 859771788,
 78826,
 -52410,
 860104543,
 78828,
 -1,
 860166534,
 78827,
 860369737,
 860099966,
 78831,
 -1,
 860297606,
 78832,
 860500811,
 860296362,
 78829,
 -1,
 860428678,
 78830,
 -52404,
 860428500,
 78836,
 -52403,
 860559395,
 78835,
 -52402,
 860624707,
 78834,
 -52401,
 860690035,
 78833,
 -1,
 860754236,
 78820,
 860959606,
 858041636,
 -1,
 861025118,
 860885308,
 -1,
 861090644,
 860952179,
 78530,
 -1,
 861018502,
 78531,
 861221718,
 861016108,
 78523,
 -1,
 861149574,
 78524,
 -52393,
 861149396,
 78534,
 -52392,
 861280291,
 78533,
 -52391,
 861345603,
 78532,
 -52390,
 861410686,
 78529,
 -52389,
 861476010,
 78528,
 -52388,
 861541260,
 78527,
 -52387,
 861606503,
 78526,
 -1,
 861671740,
 78525,
 861877099,
 860950572,
 -1,
 861942626,
 861803404,
 78514,
 -52383,
 861874015,
 78516,
 -1,
 861936006,
 78515,
 862139236,
 861868647,
 78512,
 -1,
 862067078,
 78513,
 -52379,
 862066900,
 78522,
 -52378,
 862197795,
 78521,
 -52377,
 862263107,
 78520,
 -52376,
 862328435,
 78519,
 -52375,
 862393726,
 78518,
 -52374,
 862459050,
 78517,
 -1,
 862523708,
 78511,
 862781439,
 861803111,
 -1,
 -52371,
 862656724,
 78544,
 -52370,
 862722083,
 78543,
 -52369,
 862787395,
 78542,
 -52368,
 862852723,
 78541,
 -52367,
 862918014,
 78540,
 -52366,
 862983338,
 78539,
 -52365,
 863048588,
 78538,
 -52364,
 863113831,
 78537,
 -52363,
 863179068,
 78536,
 -1,
 863244332,
 78535,
 863450010,
 860938488,
 -1,
 863515526,
 863375676,
 -1,
 863581050,
 863442979,
 78789,
 -1,
 863508870,
 78790,
 863712124,
 863508291,
 78787,
 -1,
 863639942,
 78788,
 863843198,
 863638698,
 78783,
 -1,
 863771014,
 78784,
 863974272,
 863768620,
 78778,
 -1,
 863902086,
 78779,
 -52351,
 863901908,
 78791,
 -52350,
 864032371,
 78786,
 -52349,
 864097662,
 78785,
 -52348,
 864162700,
 78782,
 -52347,
 864227943,
 78781,
 -1,
 864293180,
 78780,
 864498578,
 863440940,
 -1,
 864564105,
 864426196,
 78776,
 -1,
 864491910,
 78777,
 864695179,
 864490380,
 78769,
 -1,
 864622982,
 78770,
 -52340,
 864622627,
 78775,
 -52339,
 864753475,
 78774,
 -52338,
 864818803,
 78773,
 -52337,
 864884094,
 78772,
 -52336,
 864949418,
 78771,
 -52335,
 865014375,
 78768,
 -1,
 865079612,
 78767,
 865337343,
 864424551,
 -1,
 865350549,
 865211562,
 78796,
 -1,
 865278342,
 78797,
 -52330,
 865277310,
 78798,
 -52329,
 865407884,
 78795,
 -52328,
 865473127,
 78794,
 -52327,
 865538364,
 78793,
 -1,
 865603628,
 78792,
 865809338,
 863382999,
 -1,
 865874856,
 865734700,
 -1,
 865940384,
 865800807,
 77915,
 -52322,
 865873315,
 77918,
 -52321,
 865937247,
 77917,
 -1,
 865999238,
 77916,
 -52319,
 865867988,
 77925,
 -52318,
 866129955,
 77924,
 -52317,
 866195267,
 77923,
 -52316,
 866260595,
 77922,
 -52315,
 866325886,
 77921,
 -52314,
 866391210,
 77920,
 -52313,
 866456460,
 77919,
 -1,
 866521404,
 77914,
 866726836,
 865800508,
 -1,
 866792363,
 866652204,
 77926,
 -1,
 866720134,
 77927,
 -52308,
 866719956,
 77936,
 -52307,
 866850851,
 77935,
 -52306,
 866916163,
 77934,
 -52305,
 866981491,
 77933,
 -52304,
 867046782,
 77932,
 -52303,
 867112106,
 77931,
 -52302,
 867177356,
 77930,
 -52301,
 867242599,
 77929,
 -1,
 867307836,
 77928,
 867565567,
 866652775,
 -1,
 -52298,
 867439786,
 77941,
 -52297,
 867505036,
 77940,
 -52296,
 867570279,
 77939,
 -52295,
 867635516,
 77938,
 -1,
 867700780,
 77937,
 867906520,
 865756077,
 -1,
 867972049,
 867831852,
 -1,
 868037576,
 867897388,
 -1,
 868103103,
 867965140,
 78225,
 -1,
 868030854,
 78226,
 868234177,
 868029822,
 78220,
 -1,
 868161926,
 78221,
 -52286,
 868161571,
 78224,
 -52285,
 868292419,
 78223,
 -52284,
 868357747,
 78222,
 -52283,
 868422826,
 78219,
 -52282,
 868488076,
 78218,
 -52281,
 868553319,
 78217,
 -1,
 868618556,
 78216,
 868876287,
 867963196,
 -1,
 868889547,
 868749628,
 78229,
 -1,
 868817286,
 78230,
 869020621,
 868814892,
 78227,
 -1,
 868948358,
 78228,
 -52274,
 868947326,
 78234,
 -52273,
 869078186,
 78233,
 -52272,
 869143436,
 78232,
 -1,
 869208679,
 78231,
 869466111,
 867930707,
 -1,
 869479381,
 869387961,
 -1,
 -52268,
 869450929,
 78898,
 -1,
 869484628,
 78900,
 869728255,
 869411862,
 -1,
 -52265,
 869647537,
 78899,
 -1,
 869681236,
 78901,
 869872616,
 867869448,
 -1,
 869938149,
 869797932,
 -1,
 870003676,
 869864332,
 78494,
 -1,
 869931398,
 78495,
 870134750,
 869929276,
 78491,
 -1,
 870062470,
 78492,
 -52257,
 870062292,
 78501,
 -52256,
 870193187,
 78500,
 -52255,
 870258499,
 78499,
 -52254,
 870323827,
 78498,
 -52253,
 870389118,
 78497,
 -52252,
 870454442,
 78496,
 -1,
 870519399,
 78493,
 870776831,
 869863740,
 -1,
 -52249,
 870650172,
 78503,
 -1,
 870715436,
 78502,
 870921205,
 869853234,
 -1,
 870986732,
 870847658,
 78802,
 -52245,
 870917983,
 78804,
 -1,
 870979974,
 78803,
 871183342,
 870914083,
 78809,
 -1,
 871111046,
 78810,
 871314416,
 871110259,
 78806,
 -1,
 871242118,
 78807,
 -52239,
 871241539,
 78808,
 -52238,
 871372158,
 78805,
 -52237,
 871437196,
 78801,
 -52236,
 871502439,
 78800,
 -1,
 871567676,
 78799,
 871773186,
 870852447,
 -1,
 871838721,
 871698713,
 -1,
 871904249,
 871765374,
 77908,
 -1,
 871831942,
 77909,
 -52230,
 871831764,
 77913,
 -52229,
 871962659,
 77912,
 -52228,
 872027971,
 77911,
 -52227,
 872093299,
 77910,
 -52226,
 872158378,
 77907,
 -52225,
 872223628,
 77906,
 -52224,
 872288871,
 77905,
 -1,
 872354108,
 77904,
 -1,
 871777824,
 78903,
 872625165,
 871724882,
 -1,
 872690693,
 872552051,
 78249,
 -1,
 872618374,
 78250,
 872821767,
 872616551,
 78244,
 -1,
 872749446,
 78245,
 -52216,
 872749091,
 78252,
 -52215,
 872879939,
 78251,
 -52214,
 872945022,
 78248,
 -52213,
 873010346,
 78247,
 -52212,
 873075596,
 78246,
 -1,
 873140540,
 78243,
 873346073,
 872569355,
 -1,
 873411608,
 873271577,
 -1,
 873477137,
 873338483,
 78212,
 -1,
 873404806,
 78213,
 -52206,
 873404451,
 78215,
 -52205,
 873535299,
 78214,
 -52204,
 873600382,
 78211,
 -52203,
 873665706,
 78210,
 -52202,
 873730956,
 78209,
 -52201,
 873796199,
 78208,
 -1,
 873861436,
 78207,
 -1,
 873372861,
 78897,
 874132515,
 873327003,
 -1,
 874198044,
 874058044,
 78811,
 -1,
 874125702,
 78812,
 -52195,
 874125347,
 78819,
 -52194,
 874256195,
 78818,
 -52193,
 874321523,
 78817,
 -52192,
 874386814,
 78816,
 -52191,
 874452138,
 78815,
 -52190,
 874517388,
 78814,
 -1,
 874582631,
 78813,
 874787884,
 874083190,
 -1,
 -52187,
 874715171,
 78242,
 -52186,
 874780483,
 78241,
 -52185,
 874845811,
 78240,
 -52184,
 874911102,
 78239,
 -52183,
 874976426,
 78238,
 -52182,
 875041676,
 78237,
 -52181,
 875106919,
 78236,
 -1,
 875172156,
 78235,
 875429887,
 874752796,
 -1,
 -52178,
 875304771,
 78510,
 -52177,
 875370099,
 78509,
 -52176,
 875435390,
 78508,
 -52175,
 875500714,
 78507,
 -52174,
 875565964,
 78506,
 -52173,
 875631207,
 78505,
 -1,
 875696444,
 78504,
 -1,
 796677320,
 129370,
 875967735,
 796641185,
 -1,
 876033269,
 875913082,
 -1,
 876098787,
 876001793,
 -1,
 876164322,
 876079910,
 -1,
 876229716,
 876096931,
 -1,
 876295250,
 876162467,
 -1,
 876360779,
 876239371,
 -1,
 876426308,
 876304907,
 -1,
 876491839,
 876364286,
 43813,
 -1,
 876429822,
 43812,
 876622913,
 876419462,
 43808,
 -1,
 876550534,
 43811,
 -52158,
 876598170,
 43809,
 -52157,
 876712983,
 43814,
 -1,
 876766125,
 43810,
 876950598,
 876364286,
 11709,
 -1,
 876888574,
 11708,
 877081672,
 876878214,
 11704,
 -1,
 877009286,
 11707,
 -52151,
 877056922,
 11705,
 -52150,
 877171735,
 11710,
 -1,
 877224877,
 11706,
 877409357,
 876298750,
 11693,
 -1,
 877347326,
 11692,
 877540431,
 877336966,
 11688,
 -1,
 877468038,
 11691,
 -52144,
 877515674,
 11689,
 -52143,
 877630487,
 11694,
 -1,
 877683629,
 11690,
 -52141,
 876254300,
 11655,
 -1,
 877813799,
 11664,
 877999205,
 876172488,
 -1,
 878064733,
 877979940,
 -1,
 878130264,
 878002686,
 11741,
 -1,
 878068222,
 11740,
 878261338,
 878057862,
 11736,
 -1,
 878188934,
 11739,
 -52133,
 878236570,
 11737,
 -52132,
 878351383,
 11742,
 -1,
 878404525,
 11738,
 878589027,
 878008822,
 -1,
 878654560,
 878526974,
 11670,
 -1,
 878592510,
 11669,
 878785634,
 878582150,
 11667,
 -1,
 878713222,
 4895,
 -1,
 878732205,
 11668,
 -52124,
 878548060,
 4879,
 -1,
 878936427,
 11658,
 879113335,
 877934861,
 -1,
 879178863,
 879048973,
 -1,
 879244398,
 879122955,
 -1,
 879309930,
 879182334,
 43789,
 -1,
 879247870,
 43788,
 -52117,
 879285146,
 43785,
 -52116,
 879399959,
 43790,
 -52115,
 879453101,
 43786,
 -1,
 879499851,
 43787,
 -1,
 879203420,
 11661,
 879768694,
 879160368,
 -1,
 879834226,
 879706622,
 43797,
 -1,
 879772158,
 43796,
 -52109,
 879809434,
 43793,
 -52108,
 879924247,
 43798,
 -52107,
 879977389,
 43794,
 -1,
 880024139,
 43795,
 -1,
 879727708,
 11660,
 880292999,
 879081985,
 -1,
 880358528,
 880261633,
 -1,
 880424059,
 880296446,
 11685,
 -1,
 880361982,
 11684,
 880555133,
 880351622,
 11680,
 -1,
 880482694,
 11683,
 -52098,
 880530330,
 11681,
 -52097,
 880645143,
 11686,
 -1,
 880698285,
 11682,
 880882821,
 880296981,
 -1,
 -52094,
 880847606,
 5004,
 -52093,
 880905228,
 4992,
 -52092,
 880956612,
 5000,
 -1,
 881012107,
 4996,
 -52090,
 880841820,
 11651,
 -1,
 881156135,
 11652,
 881341589,
 880224095,
 -1,
 881407120,
 881272671,
 -1,
 881472651,
 881345022,
 43821,
 -1,
 881410558,
 43820,
 881603725,
 881400198,
 43816,
 -1,
 881531270,
 43819,
 -52082,
 881578906,
 43817,
 -52081,
 881693719,
 43822,
 -1,
 881746861,
 43818,
 881931412,
 881385659,
 -1,
 881996947,
 881869310,
 4999,
 -1,
 881934846,
 4998,
 -1,
 881943469,
 4997,
 -1,
 881890396,
 11653,
 882259104,
 881313697,
 -1,
 882324637,
 882231998,
 -1,
 882390169,
 882262526,
 43781,
 -1,
 882328062,
 43780,
 -52070,
 882365338,
 43777,
 -52069,
 882480151,
 43782,
 -52068,
 882533293,
 43778,
 -1,
 882580043,
 43779,
 -52066,
 882306488,
 4935,
 -52065,
 882742364,
 11654,
 -1,
 882794535,
 11663,
 882980010,
 882240560,
 -1,
 883045545,
 882961456,
 -1,
 883111076,
 882983422,
 11701,
 -1,
 883048958,
 11700,
 883242150,
 883038598,
 11696,
 -1,
 883169670,
 11699,
 -52057,
 883217306,
 11697,
 -52056,
 883332119,
 11702,
 -1,
 883385261,
 11698,
 -1,
 883004508,
 11659,
 883635380,
 882960403,
 -1,
 883700915,
 883616036,
 -1,
 883766446,
 883638782,
 11733,
 -1,
 883704318,
 11732,
 883897520,
 883693958,
 11728,
 -1,
 883825030,
 11731,
 -52047,
 883872666,
 11729,
 -52046,
 883987479,
 11734,
 -1,
 884040621,
 11730,
 -1,
 883659868,
 4743,
 884290750,
 883600129,
 -1,
 884356285,
 884271396,
 -1,
 884421816,
 884294142,
 11717,
 -1,
 884359678,
 11716,
 884552890,
 884349318,
 11712,
 -1,
 884480390,
 11715,
 -52037,
 884528026,
 11713,
 -52036,
 884642839,
 11718,
 -1,
 884695981,
 11714,
 -1,
 884315228,
 4679,
 884946120,
 884241209,
 -1,
 885011655,
 884926756,
 -1,
 885077186,
 884949502,
 11725,
 -1,
 885015038,
 11724,
 885208260,
 885004678,
 11720,
 -1,
 885135750,
 11723,
 -52027,
 885183386,
 11721,
 -52026,
 885298199,
 11726,
 -1,
 885351341,
 11722,
 -1,
 884970588,
 4783,
 885601487,
 884908719,
 -1,
 885667021,
 885579963,
 -1,
 885732556,
 885604862,
 5007,
 -1,
 885670398,
 5006,
 -1,
 885679021,
 5005,
 -52018,
 885625948,
 11666,
 -1,
 885874727,
 11665,
 886060245,
 885556083,
 -1,
 886125780,
 886038715,
 -1,
 886191315,
 886063614,
 4995,
 -1,
 886129150,
 4994,
 -1,
 886137773,
 4993,
 -1,
 886084700,
 11649,
 886453465,
 886002881,
 -1,
 886519000,
 886391294,
 5003,
 -1,
 886456830,
 5002,
 -1,
 886465453,
 5001,
 886715612,
 886410284,
 -1,
 -52005,
 886696852,
 11657,
 -1,
 886740060,
 11656,
 -52003,
 886696852,
 4847,
 -52002,
 886892372,
 4815,
 -52001,
 886945667,
 11650,
 -52000,
 886997129,
 11648,
 -51999,
 887059168,
 11662,
 -1,
 887119911,
 4615,
 -1,
 876102719,
 4960,
 887370992,
 876072578,
 -1,
 887436520,
 887306509,
 -1,
 887502055,
 887376494,
 5009,
 -1,
 887426838,
 5016,
 -1,
 887449059,
 5012,
 887698667,
 887386937,
 -1,
 -51990,
 887675534,
 5017,
 -1,
 887703611,
 5013,
 -51988,
 887679763,
 5008,
 -51987,
 887865099,
 5011,
 -51986,
 887928147,
 5010,
 -51985,
 887971445,
 5015,
 -1,
 888025449,
 5014,
 888274943,
 887305333,
 -1,
 888288500,
 888166055,
 -1,
 -51981,
 888243571,
 4959,
 -1,
 888283376,
 4957,
 -1,
 888266755,
 4958,
 -51978,
 876013587,
 983047,
 -1,
 888481631,
 983096,
 888681810,
 875919119,
 -1,
 888747308,
 888613044,
 -1,
 888812798,
 888704044,
 -1,
 -51973,
 888762969,
 66837,
 -51972,
 888816126,
 66835,
 -51971,
 888879735,
 66821,
 -1,
 888936838,
 66836,
 889140484,
 888755400,
 -1,
 889206018,
 889084427,
 -1,
 -51967,
 889143806,
 66853,
 -1,
 889200680,
 66854,
 -51965,
 889156185,
 66827,
 -1,
 889340414,
 66826,
 889533703,
 889121840,
 -1,
 -51962,
 889478298,
 66852,
 -1,
 889537022,
 66851,
 889730314,
 889505697,
 -1,
 -51959,
 889674906,
 66846,
 -1,
 889733630,
 66845,
 889926925,
 889698817,
 -1,
 -51956,
 889871514,
 66844,
 -1,
 889930238,
 66843,
 890123536,
 889892038,
 -1,
 -51953,
 890089379,
 66842,
 -1,
 890126846,
 66841,
 890320147,
 890074895,
 -1,
 -51950,
 890272272,
 66833,
 -1,
 890323454,
 66832,
 890516758,
 890270521,
 -1,
 -51947,
 890461338,
 66855,
 -1,
 890520062,
 66831,
 890713368,
 890454526,
 66824,
 -1,
 890659757,
 66823,
 890844443,
 890648845,
 -1,
 -51942,
 890789018,
 66822,
 -1,
 890847742,
 66820,
 891041054,
 890776995,
 -1,
 -51939,
 890985626,
 66819,
 -1,
 891044350,
 66818,
 -51937,
 891021604,
 66850,
 -51936,
 891218036,
 66849,
 -51935,
 891280536,
 66848,
 -51934,
 891343770,
 66847,
 -51933,
 891398992,
 66840,
 -51932,
 891462863,
 66839,
 -51931,
 891524119,
 66838,
 -51930,
 891586196,
 66834,
 -51929,
 891646553,
 66830,
 -51928,
 891708333,
 66829,
 -51927,
 891772058,
 66828,
 -51926,
 891834188,
 66825,
 -51925,
 891889925,
 66817,
 -1,
 891951494,
 66816,
 892155209,
 888728386,
 -1,
 892220744,
 892095425,
 -1,
 892286259,
 892189185,
 -1,
 892351794,
 892213638,
 -1,
 -51919,
 892307298,
 69614,
 -1,
 892353471,
 69617,
 -1,
 892297034,
 69620,
 892613942,
 892258209,
 -1,
 -51915,
 892554140,
 69608,
 -1,
 892610301,
 69621,
 892810552,
 892558490,
 69604,
 -1,
 892783294,
 69607,
 892941627,
 892737926,
 -1,
 -51910,
 892922594,
 69615,
 -1,
 892960031,
 69600,
 -51908,
 892923118,
 69606,
 -51907,
 893119401,
 69609,
 -51906,
 893182433,
 69605,
 -51905,
 893235621,
 69619,
 -51904,
 893299570,
 69618,
 -51903,
 893363407,
 69616,
 -51902,
 893424521,
 69613,
 -51901,
 893486971,
 69612,
 -51900,
 893548630,
 69611,
 -51899,
 893613063,
 69610,
 -51898,
 893671450,
 69602,
 -51897,
 893729262,
 69603,
 -1,
 893790627,
 69601,
 -1,
 892167855,
 69622,
 894055761,
 892092926,
 -1,
 894121296,
 893990948,
 -1,
 894186831,
 894042112,
 -1,
 -51891,
 894160635,
 128294,
 -51890,
 894216019,
 128268,
 -1,
 894271121,
 128161,
 -1,
 894115502,
 9191,
 -1,
 894084638,
 128024,
 -1,
 893996689,
 129501,
 894645607,
 888636275,
 -1,
 894711135,
 894604840,
 -1,
 894776666,
 894667269,
 -1,
 -51882,
 894703219,
 127999,
 -51881,
 894768510,
 127998,
 -51880,
 894833834,
 127997,
 -51879,
 894899084,
 127996,
 -1,
 894964280,
 127995,
 895221759,
 894711001,
 -1,
 -51876,
 895148888,
 129459,
 -51875,
 895201398,
 129456,
 -51874,
 895236262,
 129457,
 -1,
 895297521,
 129458,
 895549439,
 894675496,
 -1,
 895563108,
 895455708,
 128453,
 895680511,
 895485674,
 -1,
 -51869,
 895571560,
 128454,
 -1,
 895629581,
 128455,
 895825254,
 895525708,
 128460,
 -1,
 895793665,
 128461,
 -1,
 895761685,
 128459,
 896021881,
 894602284,
 -1,
 896087412,
 895957263,
 -1,
 896152947,
 896046422,
 -1,
 896218478,
 896124833,
 -1,
 896284013,
 896183939,
 983048,
 -1,
 896205173,
 983095,
 -1,
 896224699,
 983046,
 -51857,
 896187491,
 983134,
 -51856,
 896444895,
 983178,
 -51855,
 896501453,
 983099,
 -51854,
 896565007,
 983064,
 -1,
 896620947,
 983177,
 -1,
 896132304,
 128282,
 896873847,
 896064760,
 -1,
 -51850,
 896827117,
 128388,
 -1,
 896876789,
 128233,
 897122303,
 896838401,
 983051,
 -1,
 897046082,
 983050,
 897201544,
 895949190,
 -1,
 897267079,
 897166534,
 128066,
 897332610,
 897239745,
 -1,
 897398145,
 897286291,
 -1,
 897463680,
 897325446,
 -1,
 -51841,
 897433415,
 127759,
 -1,
 897484737,
 127758,
 -1,
 897404009,
 127757,
 -1,
 897366154,
 9178,
 897843199,
 897253376,
 -1,
 897856902,
 897750358,
 -1,
 -51835,
 897823504,
 127806,
 -1,
 897877080,
 127805,
 -1,
 897836152,
 129467,
 -1,
 897210484,
 129413,
 898184597,
 897181715,
 -1,
 898250132,
 898158419,
 -1,
 898315667,
 898189203,
 -1,
 898381198,
 898294511,
 -1,
 -51827,
 898351965,
 128915,
 -1,
 898380274,
 128905,
 898577809,
 898349569,
 -1,
 -51824,
 898527623,
 128954,
 -1,
 898572279,
 128942,
 -51822,
 898521438,
 128935,
 -1,
 898715990,
 128948,
 -1,
 898246041,
 128125,
 -1,
 898214294,
 128529,
 899036568,
 898165289,
 128065,
 -51817,
 899004929,
 128064,
 -1,
 899045484,
 128083,
 899233180,
 899004929,
 -1,
 899298715,
 899165603,
 983104,
 -1,
 899228237,
 983103,
 -1,
 899225990,
 983135,
 899495328,
 899191831,
 -1,
 -51810,
 899467169,
 983049,
 -51809,
 899515251,
 983100,
 -1,
 899577615,
 983067,
 899757475,
 899471993,
 -1,
 -51806,
 899721429,
 127972,
 -1,
 899755811,
 127984,
 899954086,
 899724968,
 -1,
 -51803,
 899928763,
 11249,
 -1,
 899979349,
 11248,
 900150697,
 899918764,
 -1,
 -51800,
 900129929,
 11257,
 -1,
 900143851,
 11072,
 -51798,
 900128086,
 127794,
 -51797,
 900309771,
 983179,
 -51796,
 900362844,
 9167,
 -51795,
 900414688,
 11790,
 -1,
 900468546,
 128231,
 900676888,
 796534623,
 -1,
 900741800,
 900602246,
 -1,
 900806998,
 900697000,
 -1,
 900872523,
 900758870,
 -1,
 900937965,
 900833967,
 -1,
 901003493,
 900881507,
 -1,
 901068435,
 900940288,
 -1,
 901133809,
 901024812,
 -1,
 901199312,
 901076168,
 -1,
 901264832,
 901149497,
 -1,
 901330363,
 901239706,
 -1,
 -51782,
 901292719,
 92598,
 -1,
 901350259,
 92619,
 901526974,
 901270513,
 -1,
 -51779,
 901507091,
 92543,
 -1,
 901520475,
 92553,
 901775359,
 901454214,
 92531,
 -1,
 901652511,
 92601,
 901854665,
 901207240,
 -1,
 901920197,
 901829530,
 -1,
 -51773,
 901885322,
 92550,
 -51772,
 901948079,
 92624,
 -1,
 901979295,
 92563,
 902234111,
 901857790,
 -1,
 902247880,
 902157366,
 92607,
 -1,
 902219681,
 92535,
 -1,
 902186256,
 92557,
 902444491,
 901829686,
 92640,
 -1,
 902416289,
 92657,
 902575566,
 902403095,
 -1,
 -51763,
 902540033,
 92544,
 -1,
 902603439,
 92541,
 -51761,
 902515795,
 92579,
 -1,
 902699398,
 92658,
 902903258,
 901134605,
 -1,
 902968790,
 902830470,
 -1,
 903034325,
 902896008,
 -1,
 -51756,
 903004794,
 92562,
 -1,
 903056406,
 92637,
 -1,
 902996655,
 92518,
 903296473,
 902914989,
 -1,
 -51752,
 903260929,
 92558,
 -1,
 903291561,
 92592,
 -1,
 903272211,
 92528,
 903558624,
 902853133,
 -1,
 903624159,
 903496190,
 -1,
 903689694,
 903561726,
 92628,
 -1,
 903611054,
 92648,
 -1,
 903666594,
 92547,
 -1,
 903552101,
 92554,
 903951845,
 903527759,
 -1,
 904017380,
 903926682,
 -1,
 -51741,
 903977672,
 92527,
 -1,
 904020478,
 92545,
 -1,
 903964088,
 92540,
 904279528,
 903932976,
 -1,
 -51737,
 904255919,
 92609,
 -1,
 904274601,
 92583,
 904476139,
 904260280,
 -1,
 -51734,
 904409976,
 92589,
 -1,
 904473000,
 92608,
 904672750,
 904447905,
 -1,
 -51731,
 904648377,
 92604,
 -1,
 904667713,
 92622,
 904869360,
 904599942,
 92662,
 -1,
 904806910,
 92613,
 -1,
 904820289,
 92584,
 905065993,
 901096111,
 -1,
 905131512,
 905040794,
 92576,
 905197046,
 905058694,
 -1,
 -51723,
 905161473,
 92618,
 -1,
 905200126,
 92529,
 -51721,
 905151347,
 92561,
 -1,
 905331198,
 92649,
 905524734,
 905058694,
 -1,
 905590267,
 905451910,
 92524,
 -1,
 905544563,
 92536,
 905773055,
 905512679,
 -1,
 -51715,
 905675608,
 92634,
 -1,
 905726325,
 92625,
 905917954,
 905470893,
 92663,
 906035199,
 905855486,
 -1,
 -51711,
 905955233,
 92621,
 -1,
 905988559,
 92593,
 906180103,
 905855486,
 -1,
 906245638,
 906154906,
 -1,
 -51707,
 906225683,
 92647,
 -1,
 906282913,
 92605,
 -1,
 906184578,
 92548,
 906559487,
 906138647,
 92568,
 -1,
 906467258,
 92610,
 906638876,
 905020275,
 -1,
 906704399,
 906566022,
 92667,
 906769933,
 906641918,
 92600,
 -1,
 906724211,
 92542,
 -51698,
 906734337,
 92668,
 -1,
 906863279,
 92555,
 907032081,
 906650541,
 92654,
 -1,
 906970381,
 92611,
 907163156,
 906974755,
 -1,
 -51693,
 907102151,
 92581,
 -1,
 907155846,
 92551,
 907359767,
 907094277,
 -1,
 -51690,
 907335353,
 92520,
 -1,
 907362814,
 92582,
 -51688,
 907337405,
 92617,
 -51687,
 907531318,
 92614,
 -51686,
 907581370,
 92671,
 -51685,
 907628442,
 92591,
 -1,
 907691975,
 92666,
 907884079,
 906610593,
 -1,
 907949603,
 907811206,
 -1,
 908015136,
 907876742,
 92635,
 -1,
 907979521,
 92577,
 -51679,
 907979521,
 92636,
 -51678,
 908100467,
 92530,
 -1,
 908150759,
 92559,
 908342823,
 907924378,
 -1,
 908408358,
 908297075,
 92586,
 -1,
 908336200,
 92569,
 -1,
 908336200,
 92566,
 908604971,
 908301335,
 -1,
 908670506,
 908563479,
 92537,
 -1,
 908626988,
 92519,
 -1,
 908634881,
 92630,
 908918783,
 908542462,
 -1,
 908932654,
 908841882,
 92669,
 -1,
 908860553,
 92572,
 -1,
 908889132,
 92672,
 909129281,
 907864356,
 -1,
 909194805,
 909104026,
 -1,
 -51662,
 909159169,
 92644,
 -51661,
 909216812,
 92645,
 -51660,
 909265359,
 92594,
 -1,
 909319282,
 92641,
 909522490,
 909134833,
 -1,
 909588024,
 909450312,
 92567,
 -1,
 909559713,
 92623,
 -51655,
 909568019,
 92639,
 -1,
 909673331,
 92606,
 909850173,
 909483022,
 -1,
 -51652,
 909821723,
 92642,
 -1,
 909850221,
 92643,
 910046784,
 909796269,
 -1,
 -51649,
 910018465,
 92590,
 -1,
 910050573,
 92564,
 -1,
 909976129,
 92588,
 910308941,
 909097473,
 -1,
 910374471,
 910252555,
 -1,
 910440005,
 910332951,
 92659,
 -1,
 910404353,
 92660,
 -51642,
 910388779,
 92638,
 -1,
 910511127,
 92580,
 910702154,
 910311934,
 -1,
 -51639,
 910673825,
 92560,
 -1,
 910705150,
 92534,
 -51637,
 910677055,
 92571,
 -51636,
 910858029,
 92525,
 -1,
 910891595,
 92549,
 911095386,
 910259983,
 -1,
 911160916,
 911053847,
 -1,
 911226450,
 911119383,
 -1,
 -51631,
 911198113,
 92556,
 -1,
 911248428,
 92523,
 -51629,
 911190785,
 92664,
 -1,
 911377267,
 92539,
 911554136,
 911088006,
 -1,
 -51626,
 911518465,
 92633,
 -51625,
 911581871,
 92521,
 -1,
 911613950,
 92575,
 -51623,
 911528858,
 92653,
 -1,
 911756292,
 92595,
 911947367,
 911045433,
 -1,
 912012895,
 911922074,
 -1,
 -51619,
 911984545,
 92620,
 -51618,
 912038600,
 92538,
 -1,
 912083819,
 92587,
 912275044,
 911950334,
 -1,
 912340579,
 912249754,
 -1,
 -51614,
 912320531,
 92646,
 -1,
 912333896,
 92570,
 -1,
 912312225,
 92599,
 -51611,
 912238093,
 92532,
 -51610,
 912561175,
 92665,
 -1,
 912614317,
 92670,
 912799347,
 911888017,
 -1,
 912864879,
 912774042,
 -1,
 912930413,
 912785408,
 -1,
 -51605,
 912896325,
 92661,
 -51604,
 912941997,
 92616,
 -1,
 912993835,
 92626,
 913244159,
 912867838,
 92596,
 -1,
 913164193,
 92612,
 913323633,
 912791942,
 92603,
 -1,
 913287937,
 92673,
 -51598,
 913282861,
 92627,
 -1,
 913392909,
 92651,
 913585792,
 912741576,
 -1,
 913651325,
 913529355,
 -1,
 913716859,
 913588734,
 -1,
 913782394,
 913691546,
 -1,
 -51592,
 913762323,
 92552,
 -51591,
 913804332,
 92565,
 -1,
 913841224,
 92615,
 -1,
 913754017,
 92602,
 -51588,
 913676077,
 92674,
 -1,
 914037344,
 92578,
 914292735,
 913582341,
 -1,
 -51585,
 914217890,
 92597,
 -1,
 914278305,
 92585,
 914437766,
 913550534,
 -1,
 914503300,
 914364806,
 -1,
 -51581,
 914467585,
 92526,
 -1,
 914506238,
 92656,
 -51579,
 914450554,
 92546,
 -1,
 914640006,
 92655,
 914830987,
 914415803,
 -1,
 914896522,
 914805658,
 -1,
 -51575,
 914854935,
 92533,
 -1,
 914899454,
 92650,
 -1,
 914836614,
 92574,
 915158672,
 914807728,
 -1,
 915224207,
 915096062,
 -1,
 -51570,
 915199030,
 92573,
 -1,
 915227134,
 92652,
 -1,
 915183405,
 92522,
 -51567,
 915117079,
 92631,
 -51566,
 915432365,
 92632,
 -1,
 915478918,
 92629,
 915683130,
 901003535,
 -1,
 915748552,
 915639340,
 -1,
 915814054,
 915690696,
 -1,
 915879582,
 915764025,
 -1,
 915945114,
 915819505,
 -1,
 -51559,
 915911355,
 92432,
 -1,
 915938441,
 92457,
 -51557,
 915925564,
 92435,
 -51556,
 916117267,
 92412,
 -51555,
 916153784,
 92476,
 -1,
 916202049,
 92414,
 916455423,
 915821768,
 -1,
 916469411,
 916330886,
 -1,
 916534946,
 916398078,
 92465,
 -1,
 916462664,
 92409,
 -1,
 916497071,
 92483,
 -51548,
 916447495,
 92467,
 -51547,
 916707340,
 92485,
 -1,
 916737158,
 92475,
 916928174,
 915763725,
 -1,
 916993705,
 916874157,
 92403,
 -1,
 916931853,
 92405,
 917124780,
 916933617,
 -1,
 -51541,
 917096353,
 92407,
 -1,
 917118043,
 92430,
 -51539,
 917100039,
 92487,
 -1,
 917250625,
 92418,
 917452470,
 916896257,
 -1,
 917518002,
 917398968,
 -1,
 -51535,
 917489569,
 92459,
 -1,
 917545647,
 92447,
 917714613,
 917461515,
 -1,
 -51532,
 917691181,
 92486,
 -1,
 917718285,
 92408,
 -1,
 917690041,
 92480,
 917976763,
 917432612,
 -1,
 -51528,
 917951976,
 92463,
 -51527,
 917988269,
 92493,
 -51526,
 918047595,
 92450,
 -1,
 918102014,
 92410,
 918304449,
 917911821,
 -1,
 918369983,
 918241790,
 -1,
 -51522,
 918346658,
 92425,
 -1,
 918372862,
 92437,
 -51520,
 918329274,
 92440,
 -1,
 918495230,
 92471,
 918697670,
 918276001,
 -1,
 918763205,
 918635006,
 -1,
 -51516,
 918738617,
 92472,
 -1,
 918766078,
 92505,
 -1,
 918739854,
 92514,
 -51513,
 918672282,
 92503,
 -1,
 918971309,
 92507,
 919156451,
 915702643,
 92497,
 919221968,
 919096977,
 -1,
 919287500,
 919180311,
 92445,
 -1,
 919243820,
 92404,
 919418575,
 919227377,
 -1,
 -51506,
 919390113,
 92424,
 -1,
 919411784,
 92458,
 -1,
 919365048,
 92466,
 919680724,
 919164451,
 -1,
 -51502,
 919639455,
 92438,
 -51501,
 919692728,
 92444,
 -1,
 919751730,
 92442,
 919942873,
 919618046,
 -1,
 920008408,
 919917466,
 -1,
 -51497,
 919979937,
 92427,
 -1,
 920030252,
 92478,
 -1,
 919946512,
 92496,
 920270557,
 919873375,
 -1,
 920336092,
 920197707,
 92448,
 -1,
 920258839,
 92515,
 -1,
 920311817,
 92401,
 920532704,
 920197510,
 -1,
 -51489,
 920484538,
 92426,
 -1,
 920537262,
 92482,
 -51487,
 920510433,
 92510,
 -51486,
 920703898,
 92499,
 -1,
 920754599,
 92441,
 920925942,
 919124481,
 -1,
 920991469,
 920869387,
 -1,
 921057002,
 920928766,
 -1,
 921122537,
 921031578,
 -1,
 -51480,
 921102355,
 92501,
 -1,
 921115720,
 92417,
 -1,
 921059838,
 92413,
 -51477,
 921031578,
 92504,
 -51476,
 921345035,
 92508,
 -1,
 921397196,
 92500,
 921581297,
 920966042,
 -1,
 -51473,
 921555866,
 92498,
 -51472,
 921584126,
 92419,
 -1,
 921640008,
 92473,
 921843444,
 921508230,
 -1,
 -51469,
 921807617,
 92516,
 -1,
 921871023,
 92423,
 -51467,
 921804186,
 92452,
 -1,
 921979927,
 92428,
 922171140,
 920875833,
 -1,
 922236670,
 922108414,
 -1,
 922302205,
 922211226,
 -1,
 -51462,
 922264239,
 92460,
 -51461,
 922328477,
 92431,
 -51460,
 922387315,
 92454,
 -1,
 922426539,
 92415,
 -1,
 922273697,
 92420,
 922695426,
 922211226,
 92489,
 -51456,
 922659585,
 92479,
 -51455,
 922720045,
 92422,
 -1,
 922782764,
 92474,
 -51453,
 922675772,
 92502,
 -1,
 922935564,
 92449,
 923088656,
 922142625,
 -1,
 923154187,
 923025918,
 -1,
 923219722,
 923128730,
 -1,
 -51448,
 923191201,
 92416,
 -51447,
 923241516,
 92481,
 -1,
 923278450,
 92451,
 -1,
 923157776,
 92456,
 923547405,
 923128730,
 92433,
 -1,
 923508122,
 92477,
 -51442,
 923507723,
 92492,
 -51441,
 923624365,
 92513,
 -1,
 923671624,
 92491,
 923875098,
 923039503,
 -1,
 923940631,
 923812350,
 -1,
 924006165,
 923915162,
 -1,
 -51436,
 923960179,
 92484,
 -1,
 923999359,
 92439,
 -51434,
 923977633,
 92464,
 -1,
 924140816,
 92495,
 -51432,
 923915961,
 92446,
 -51431,
 924294155,
 92511,
 -1,
 924345784,
 92406,
 924530467,
 923837103,
 -1,
 924595998,
 924504986,
 -1,
 -51427,
 924572461,
 92443,
 -1,
 924625665,
 92509,
 924792609,
 924533246,
 -1,
 -51424,
 924769076,
 92462,
 -1,
 924795390,
 92506,
 -51422,
 924741095,
 92461,
 -1,
 924918337,
 92469,
 925120299,
 924510500,
 -1,
 925185833,
 925094810,
 -1,
 925251368,
 925144087,
 -1,
 -51417,
 925213359,
 92470,
 -1,
 925270899,
 92468,
 -1,
 925230962,
 92453,
 -51414,
 925124551,
 92429,
 -1,
 925441131,
 92421,
 925644593,
 925084870,
 -1,
 925710127,
 925583306,
 -1,
 -51410,
 925669001,
 92490,
 -1,
 925731688,
 92512,
 -51408,
 925657036,
 92494,
 -1,
 925834331,
 92455,
 926037812,
 925622459,
 -1,
 -51405,
 926012479,
 92411,
 -1,
 926032449,
 92402,
 926234423,
 925980486,
 -1,
 -51402,
 926174207,
 92488,
 -1,
 926227019,
 92434,
 926482431,
 926174865,
 -1,
 -51399,
 926370845,
 92436,
 -1,
 926423627,
 92517,
 926627789,
 915615141,
 -1,
 926693231,
 926583852,
 -1,
 926758729,
 926635208,
 -1,
 926824260,
 926700744,
 -1,
 926889795,
 926798746,
 92362,
 -51392,
 926848954,
 92341,
 -51391,
 926909299,
 92347,
 -51390,
 926958990,
 92370,
 -1,
 927014006,
 92336,
 -1,
 926828487,
 92307,
 927283015,
 926774073,
 -1,
 -51386,
 927258095,
 92303,
 -1,
 927277737,
 92309,
 -51384,
 927242029,
 92368,
 -1,
 927408809,
 92395,
 927610705,
 926726657,
 -1,
 927676237,
 927585178,
 -1,
 -51380,
 927636902,
 92359,
 -1,
 927697964,
 92374,
 -51378,
 927635245,
 92371,
 -51377,
 927816718,
 92351,
 -51376,
 927878154,
 92325,
 -1,
 927930758,
 92350,
 928135002,
 927545613,
 -1,
 928200533,
 928074737,
 -1,
 -51372,
 928171937,
 92349,
 -1,
 928193677,
 92308,
 928397144,
 928127366,
 -1,
 -51369,
 928359087,
 92378,
 -1,
 928416627,
 92375,
 -51367,
 928356233,
 92317,
 -1,
 928539975,
 92331,
 928724834,
 928084493,
 -1,
 928790366,
 928662014,
 -1,
 -51363,
 928766882,
 92389,
 -1,
 928793872,
 92360,
 928986977,
 928717190,
 -1,
 -51360,
 928940915,
 92367,
 -1,
 928991106,
 92356,
 -1,
 928962055,
 92333,
 929249128,
 928696225,
 -1,
 929314662,
 929186302,
 -1,
 -51355,
 929290189,
 92345,
 -1,
 929336364,
 92372,
 -51353,
 929289130,
 92314,
 -1,
 929438283,
 92340,
 929642347,
 929229872,
 -1,
 -51350,
 929582126,
 92323,
 -1,
 929634694,
 92304,
 929838958,
 929569158,
 -1,
 -51347,
 929803009,
 92396,
 -1,
 929862208,
 92338,
 -1,
 929819390,
 92313,
 930101132,
 926647155,
 -1,
 930166658,
 930031455,
 -1,
 930232183,
 930103806,
 -1,
 930297717,
 930206618,
 -1,
 -51340,
 930277395,
 92385,
 -1,
 930317171,
 92315,
 -51338,
 930262410,
 92354,
 -1,
 930432771,
 92311,
 930625402,
 930177965,
 92381,
 -51335,
 930596769,
 92326,
 -1,
 930657073,
 92343,
 930822015,
 930552198,
 -1,
 930887550,
 930748808,
 -1,
 -51331,
 930850389,
 92387,
 -1,
 930885095,
 92318,
 -1,
 930845694,
 92383,
 931201023,
 930796442,
 -1,
 -51327,
 931086846,
 92324,
 -1,
 931142747,
 92364,
 931346313,
 930093446,
 -1,
 931411846,
 931283454,
 -1,
 -51323,
 931381060,
 92363,
 -1,
 931431968,
 92382,
 931659775,
 931332096,
 -1,
 -51320,
 931566178,
 92376,
 -1,
 931624204,
 92339,
 -51318,
 931320886,
 92391,
 -51317,
 931751352,
 92390,
 -1,
 931812923,
 92344,
 932001693,
 930050873,
 -1,
 932067224,
 931938814,
 -1,
 932132756,
 932041626,
 -1,
 932198290,
 932100609,
 -1,
 -51311,
 932142618,
 92319,
 -1,
 932203654,
 92384,
 -51309,
 932152179,
 92386,
 -1,
 932344858,
 92321,
 932525975,
 932088878,
 -1,
 -51306,
 932477322,
 92393,
 -1,
 932532036,
 92394,
 -1,
 932497313,
 92361,
 932788123,
 932041626,
 -1,
 -51302,
 932759457,
 92366,
 -1,
 932813525,
 92373,
 -51300,
 932750351,
 92328,
 -1,
 932911691,
 92329,
 933115812,
 931981604,
 -1,
 933181346,
 933090202,
 -1,
 -51296,
 933160818,
 92388,
 -51295,
 933200755,
 92305,
 -1,
 933233867,
 92322,
 -51293,
 933121097,
 92327,
 -1,
 933370443,
 92377,
 933574572,
 933087137,
 -1,
 933640104,
 933523443,
 -1,
 -51289,
 933614660,
 92358,
 -1,
 933632543,
 92334,
 933836715,
 933577214,
 -1,
 -51286,
 933813054,
 92346,
 -1,
 933873569,
 92400,
 -1,
 933763696,
 92332,
 934098868,
 933542401,
 -1,
 934164400,
 934042123,
 -1,
 -51281,
 934139399,
 92379,
 -1,
 934178347,
 92392,
 934361011,
 934101502,
 -1,
 -51278,
 934337442,
 92330,
 -1,
 934398649,
 92380,
 -1,
 934335568,
 92335,
 934623162,
 934049551,
 -1,
 934688696,
 934549894,
 -1,
 -51273,
 934650543,
 92342,
 -1,
 934708083,
 92357,
 -51271,
 934663066,
 92365,
 -1,
 934833707,
 92397,
 935016383,
 934585007,
 -1,
 935081918,
 934962093,
 -1,
 -51267,
 935047985,
 92316,
 -1,
 935103532,
 92398,
 -1,
 935020487,
 92399,
 935344068,
 934958280,
 -1,
 935409603,
 935287325,
 -1,
 -51262,
 935374218,
 92310,
 -1,
 935436975,
 92320,
 -1,
 935340254,
 92312,
 935671751,
 935321787,
 -1,
 -51258,
 935647261,
 92369,
 -1,
 935666050,
 92306,
 935868362,
 935648928,
 -1,
 -51255,
 935847955,
 92337,
 -1,
 935861379,
 92353,
 -51253,
 935835988,
 92355,
 -51252,
 936006835,
 92348,
 -1,
 936062264,
 92352,
 936261707,
 926554504,
 -1,
 936327153,
 936217644,
 -1,
 936392661,
 936298401,
 -1,
 936458196,
 936321601,
 92223,
 936574975,
 936378368,
 -1,
 -51245,
 936481458,
 92194,
 -1,
 936544236,
 92185,
 -1,
 936418335,
 92178,
 936785883,
 936334536,
 -1,
 936851417,
 936736443,
 -1,
 -51240,
 936809489,
 92182,
 -1,
 936838310,
 92160,
 -51238,
 936793795,
 92229,
 -1,
 936976815,
 92173,
 937179103,
 936765732,
 -1,
 937244638,
 937124781,
 92239,
 -1,
 937215966,
 92225,
 -1,
 937184107,
 92233,
 937441250,
 937159728,
 -1,
 -51231,
 937416470,
 92191,
 -1,
 937433510,
 92167,
 937637861,
 937409871,
 -1,
 -51228,
 937584056,
 92237,
 -1,
 937630086,
 92241,
 937834472,
 937587513,
 -1,
 -51225,
 937781724,
 92180,
 -1,
 937826922,
 92227,
 938031083,
 937769372,
 -1,
 -51222,
 937959787,
 92212,
 -1,
 938017810,
 92201,
 938227694,
 937957766,
 -1,
 -51219,
 938191617,
 92245,
 -1,
 938219942,
 92164,
 -51217,
 938177091,
 92231,
 -51216,
 938371027,
 92204,
 -1,
 938428359,
 92244,
 938620936,
 936280947,
 -1,
 938686461,
 938547590,
 -1,
 938751995,
 938623486,
 -1,
 938817528,
 938705779,
 92238,
 -51210,
 938794675,
 92174,
 -51209,
 938833538,
 92203,
 -1,
 938879480,
 92171,
 -51207,
 938786628,
 92230,
 -51206,
 939037694,
 92210,
 -1,
 939095316,
 92186,
 -51204,
 938713800,
 92221,
 -1,
 939233918,
 92175,
 939407362,
 938644503,
 -1,
 939472897,
 939366189,
 -1,
 -51200,
 939436733,
 92198,
 -1,
 939478135,
 92214,
 -1,
 939428913,
 92190,
 939735045,
 939337616,
 -1,
 -51196,
 939698945,
 92246,
 -1,
 939758590,
 92232,
 -51194,
 939712164,
 92176,
 -51193,
 939873845,
 92196,
 -1,
 939936822,
 92197,
 940128280,
 938588673,
 -1,
 940193809,
 940071435,
 -1,
 940259341,
 940168090,
 -1,
 -51188,
 940213107,
 92215,
 -1,
 940263634,
 92165,
 940455952,
 940204973,
 -1,
 -51185,
 940420490,
 92222,
 -1,
 940477857,
 92168,
 -1,
 940416018,
 92224,
 940718101,
 940151831,
 -1,
 -51181,
 940689313,
 92235,
 -51180,
 940747521,
 92220,
 -1,
 940806380,
 92208,
 -51178,
 940694414,
 92181,
 -51177,
 940928820,
 92195,
 -1,
 940985410,
 92177,
 941176873,
 940090031,
 -1,
 941242400,
 941103494,
 -1,
 941307933,
 941169030,
 -1,
 -51172,
 941272458,
 92226,
 -1,
 941327219,
 92236,
 -51170,
 941276606,
 92187,
 -51169,
 941460258,
 92189,
 -1,
 941491218,
 92200,
 941701159,
 941201341,
 -1,
 941766692,
 941662990,
 -1,
 -51165,
 941708875,
 92169,
 -1,
 941762448,
 92170,
 942014463,
 941721585,
 -1,
 -51162,
 941905483,
 92162,
 -1,
 941959056,
 92163,
 -51160,
 941676573,
 92205,
 -1,
 942099307,
 92202,
 942290994,
 941126457,
 -1,
 942356525,
 942227966,
 -1,
 -51156,
 942331484,
 92179,
 -1,
 942393249,
 92211,
 942553136,
 942283142,
 -1,
 -51153,
 942516993,
 92240,
 -1,
 942558950,
 92199,
 -51151,
 942528537,
 92213,
 -1,
 942712999,
 92219,
 942880826,
 942262177,
 -1,
 942946358,
 942855066,
 -1,
 -51147,
 942873727,
 92206,
 -1,
 942933109,
 92172,
 943142969,
 942885873,
 -1,
 -51144,
 943114925,
 92209,
 -1,
 943135858,
 92234,
 -1,
 943091721,
 92166,
 943405120,
 942831375,
 -1,
 943470653,
 943379354,
 92243,
 -1,
 943398015,
 92207,
 -51138,
 943429552,
 92216,
 -51137,
 943541106,
 92184,
 -1,
 943596104,
 92183,
 943798341,
 943346888,
 -1,
 943863876,
 943742484,
 -1,
 -51133,
 943828362,
 92188,
 -1,
 943871855,
 92193,
 -1,
 943794751,
 92161,
 944126024,
 943772570,
 -1,
 -51129,
 944083199,
 92228,
 -1,
 944115356,
 92192,
 -51127,
 944102633,
 92242,
 -51126,
 944289750,
 92218,
 -1,
 944328956,
 92217,
 944519324,
 936191841,
 -1,
 944584799,
 944472947,
 -1,
 944650324,
 944514911,
 -1,
 944715857,
 944576902,
 -1,
 -51120,
 944644823,
 92255,
 -1,
 944702573,
 92252,
 -51118,
 944691225,
 92292,
 -51117,
 944861178,
 92268,
 -1,
 944917594,
 92286,
 945109080,
 944576902,
 92300,
 945225727,
 945030365,
 -1,
 -51113,
 945150386,
 92296,
 -1,
 945179664,
 92295,
 945371227,
 945049233,
 -1,
 -51110,
 945330167,
 92267,
 -1,
 945385950,
 92284,
 945567838,
 945310705,
 -1,
 -51107,
 945539051,
 92290,
 -1,
 945597185,
 92281,
 -1,
 945527340,
 92287,
 945830000,
 944540716,
 -1,
 945895528,
 945771720,
 -1,
 945961062,
 945837256,
 -1,
 946026596,
 945936409,
 92282,
 -1,
 945947659,
 92283,
 -51099,
 945966068,
 92277,
 -1,
 946084444,
 92298,
 -51097,
 945919789,
 92302,
 -1,
 946238876,
 92276,
 946419819,
 945875236,
 -1,
 -51094,
 946365382,
 92269,
 -1,
 946412639,
 92288,
 946616430,
 946387457,
 -1,
 -51091,
 946561823,
 92247,
 -1,
 946620359,
 92299,
 -51089,
 946588892,
 92260,
 -1,
 946749803,
 92261,
 946944120,
 945797633,
 -1,
 947009652,
 946887834,
 -1,
 -51085,
 946984009,
 92266,
 -1,
 947046388,
 92265,
 -51083,
 946984424,
 92285,
 -51082,
 947152312,
 92249,
 -51081,
 947211138,
 92250,
 -1,
 947265163,
 92279,
 947468417,
 946893625,
 -1,
 947533949,
 947407857,
 -1,
 -51077,
 947514032,
 92272,
 -51076,
 947563197,
 92270,
 -1,
 947592283,
 92294,
 947796096,
 947479469,
 -1,
 -51073,
 947759873,
 92301,
 -1,
 947799363,
 92253,
 -1,
 947724286,
 92256,
 948058246,
 947430063,
 -1,
 -51069,
 948033478,
 92289,
 -51068,
 948072435,
 92263,
 -51067,
 948127112,
 92257,
 -1,
 948184215,
 92274,
 948385932,
 948008719,
 -1,
 948451466,
 948312454,
 -1,
 -51063,
 948405143,
 92259,
 -1,
 948445304,
 92273,
 -51061,
 948410164,
 92251,
 -1,
 948587371,
 92297,
 948779153,
 948357025,
 -1,
 948844688,
 948753308,
 -1,
 -51057,
 948802146,
 92264,
 -1,
 948864035,
 92248,
 -1,
 948771420,
 92280,
 949106836,
 948758820,
 -1,
 -51053,
 949046349,
 92254,
 -1,
 949099784,
 92258,
 949303447,
 949049206,
 -1,
 -51050,
 949277754,
 92262,
 -1,
 949324844,
 92271,
 949500058,
 949243724,
 -1,
 -51047,
 949476258,
 92291,
 -1,
 949502462,
 92293,
 -51045,
 949479429,
 92278,
 -1,
 949673646,
 92275,
 949878783,
 944459411,
 -1,
 949893291,
 949783596,
 -1,
 949958816,
 949867418,
 92697,
 -1,
 949886024,
 92696,
 950089891,
 949907981,
 -1,
 -51038,
 950064182,
 92698,
 -1,
 950082651,
 92688,
 950286502,
 950031560,
 -1,
 -51035,
 950236902,
 92711,
 -1,
 950293783,
 92712,
 -51033,
 950266549,
 92681,
 -51032,
 950454743,
 92704,
 -51031,
 950517146,
 92702,
 -51030,
 950559661,
 92708,
 -1,
 950614469,
 92687,
 950810804,
 949860865,
 -1,
 950876336,
 950753803,
 -1,
 -51026,
 950850458,
 92700,
 -51025,
 950899735,
 92713,
 -1,
 950953932,
 92691,
 -51023,
 950852494,
 92690,
 -51022,
 951083949,
 92692,
 -51021,
 951143558,
 92693,
 -1,
 951197706,
 92727,
 951400637,
 950760249,
 -1,
 951466168,
 951337470,
 -1,
 -51017,
 951437217,
 92695,
 -1,
 951487532,
 92710,
 -51015,
 951446076,
 92694,
 -51014,
 951636890,
 92677,
 -51013,
 951689995,
 92726,
 -51012,
 951751703,
 92719,
 -1,
 951785862,
 92675,
 951990470,
 951364806,
 -1,
 952056002,
 951927294,
 -1,
 -51008,
 952032162,
 92709,
 -51007,
 952077356,
 92721,
 -1,
 952123902,
 92679,
 952318149,
 952001453,
 -1,
 -51004,
 952263597,
 92683,
 -1,
 952321293,
 92684,
 -1,
 952292250,
 92707,
 952580301,
 951944051,
 92689,
 952645834,
 952510303,
 -1,
 -50999,
 952584135,
 92720,
 -1,
 952638027,
 92724,
 -50997,
 952603671,
 92723,
 -50996,
 952780052,
 92685,
 -1,
 952834438,
 92722,
 953039058,
 952551329,
 -1,
 953104593,
 952965510,
 -1,
 -50992,
 953041406,
 92680,
 -1,
 953096582,
 92686,
 -1,
 953043819,
 92725,
 953366743,
 953000623,
 -1,
 953432278,
 953303550,
 -1,
 -50987,
 953408418,
 92703,
 -1,
 953434622,
 92706,
 -1,
 953406518,
 92714,
 953694427,
 953317135,
 -1,
 -50983,
 953654283,
 92718,
 -50982,
 953705389,
 92717,
 -1,
 953751942,
 92682,
 953956574,
 953674020,
 -1,
 -50979,
 953916427,
 92699,
 -1,
 953948550,
 92701,
 954153185,
 953934011,
 -1,
 -50976,
 954127848,
 92705,
 -1,
 954145158,
 92716,
 -50974,
 954130583,
 92728,
 -50973,
 954323866,
 92676,
 -50972,
 954356293,
 92715,
 -1,
 954418445,
 92678,
 954611944,
 900977562,
 -1,
 -50969,
 954548734,
 42696,
 -1,
 954604616,
 42711,
 954808555,
 954548734,
 -1,
 -50966,
 954784674,
 42693,
 -1,
 954810878,
 42698,
 -50964,
 954753965,
 42717,
 -1,
 954931590,
 42667,
 955136256,
 900893740,
 -1,
 955201778,
 955085325,
 -1,
 -50960,
 955175990,
 42686,
 -50959,
 955204877,
 42694,
 -1,
 955259995,
 42674,
 955463926,
 955143368,
 -1,
 -50956,
 955414246,
 42707,
 -50955,
 955471127,
 42708,
 -1,
 955521414,
 42709,
 955726072,
 955437978,
 42685,
 -1,
 955653192,
 42684,
 955857147,
 955697057,
 -1,
 -50950,
 955833230,
 42731,
 -1,
 955860237,
 42695,
 -50948,
 955837109,
 42664,
 -50947,
 956022170,
 42691,
 -50946,
 956064685,
 42703,
 -50945,
 956119493,
 42673,
 -1,
 956176774,
 42715,
 956381453,
 955085625,
 -1,
 956446980,
 956339223,
 42719,
 -50941,
 956424348,
 42734,
 -1,
 956454788,
 42735,
 956643592,
 956383742,
 -1,
 -50938,
 956619682,
 42692,
 -50937,
 956680097,
 42683,
 -1,
 956730412,
 42706,
 -50935,
 956623420,
 42682,
 -50934,
 956879770,
 42659,
 -50933,
 956932875,
 42729,
 -50932,
 956982189,
 42725,
 -1,
 957028742,
 42657,
 957233432,
 956334963,
 42675,
 957298961,
 957170174,
 -1,
 -50928,
 957254700,
 42722,
 -1,
 957302032,
 42671,
 957495572,
 957228895,
 -1,
 -50925,
 957433799,
 42720,
 -1,
 957487691,
 42727,
 -50923,
 957469594,
 42677,
 -50922,
 957649943,
 42726,
 -50921,
 957703085,
 42702,
 -1,
 957749638,
 42723,
 957954338,
 957200897,
 -1,
 958019870,
 957897227,
 -1,
 -50917,
 957993882,
 42688,
 -50916,
 958043159,
 42710,
 -50915,
 958097356,
 42678,
 -1,
 958155910,
 42680,
 -50913,
 957995918,
 42676,
 -50912,
 958292909,
 42679,
 -50911,
 958352518,
 42681,
 -1,
 958406666,
 42732,
 958609708,
 957918406,
 -1,
 958675239,
 958546430,
 -1,
 -50907,
 958651298,
 42704,
 -50906,
 958696492,
 42721,
 -1,
 958743038,
 42661,
 958937386,
 958620589,
 -1,
 -50903,
 958882733,
 42668,
 -1,
 958940429,
 42669,
 -50901,
 958911386,
 42700,
 -1,
 959061064,
 42705,
 959265076,
 958580641,
 -1,
 959330608,
 959201790,
 -1,
 -50897,
 959301537,
 42728,
 -1,
 959351852,
 42730,
 959527219,
 959256966,
 -1,
 -50894,
 959463934,
 42662,
 -1,
 959519110,
 42672,
 -1,
 959472557,
 42724,
 959789370,
 959215375,
 -1,
 -50890,
 959763354,
 42701,
 -50889,
 959814667,
 42718,
 -50888,
 959865773,
 42716,
 -50887,
 959923476,
 42670,
 -1,
 959977862,
 42666,
 960182591,
 959729297,
 -1,
 -50884,
 960156570,
 42712,
 -50883,
 960206637,
 42713,
 -50882,
 960251149,
 42699,
 -1,
 960305760,
 42733,
 960510275,
 960162084,
 -1,
 -50879,
 960485807,
 42689,
 -50878,
 960535563,
 42687,
 -1,
 960567686,
 42690,
 960772422,
 960487611,
 -1,
 -50875,
 960746984,
 42697,
 -1,
 960764294,
 42714,
 -50873,
 960746394,
 42658,
 -50872,
 960926743,
 42663,
 -50871,
 960979885,
 42665,
 -50870,
 961037581,
 42660,
 -1,
 961091974,
 42656,
 961296722,
 900805677,
 -1,
 961362257,
 961250163,
 -1,
 961427792,
 961292928,
 -1,
 -50865,
 961401274,
 42737,
 -1,
 961443401,
 42736,
 -1,
 961381321,
 42741,
 -1,
 961315002,
 42740,
 -50861,
 961264764,
 42742,
 -50860,
 961719403,
 42743,
 -50859,
 961777879,
 42738,
 -1,
 961828023,
 42739,
 962017798,
 900757263,
 -1,
 962083317,
 961964588,
 -1,
 962148760,
 962035030,
 -1,
 962214240,
 962119585,
 -1,
 962279775,
 962140550,
 6946,
 962396159,
 962199552,
 -1,
 -50851,
 962316633,
 6947,
 -50850,
 962366431,
 6942,
 -1,
 962427181,
 6941,
 -1,
 962260390,
 6983,
 962672997,
 962169900,
 -1,
 962738531,
 962599302,
 6950,
 -1,
 962660478,
 6945,
 -50844,
 962718111,
 6940,
 -1,
 962811159,
 6935,
 963000682,
 962622265,
 -1,
 963066217,
 962926982,
 6931,
 -50840,
 963006121,
 6981,
 -1,
 963052669,
 6932,
 -1,
 963010938,
 6982,
 963328368,
 962935196,
 6948,
 963444735,
 963249249,
 -1,
 963459439,
 963369463,
 -1,
 -50834,
 963413037,
 6944,
 -1,
 963452799,
 6943,
 -1,
 963386430,
 6949,
 963721589,
 963254662,
 -1,
 963787123,
 963671070,
 6917,
 -1,
 963709381,
 6918,
 -50828,
 963757973,
 6987,
 -1,
 963864535,
 6928,
 964049273,
 963689174,
 6962,
 964165631,
 963971297,
 -1,
 -50824,
 964076299,
 6961,
 -1,
 964121879,
 6960,
 964311420,
 964013376,
 6957,
 964427775,
 964233359,
 6923,
 -1,
 964299205,
 6924,
 964508031,
 964261721,
 6958,
 964624383,
 964428835,
 6925,
 -1,
 964495813,
 6926,
 964704641,
 964482646,
 6921,
 -1,
 964626885,
 6922,
 964835715,
 964666123,
 6951,
 -1,
 964756394,
 6952,
 964966789,
 964793923,
 6929,
 -1,
 964889029,
 6930,
 965097863,
 964915755,
 6938,
 -1,
 965018521,
 6939,
 965228937,
 965044183,
 6919,
 -1,
 965151173,
 6920,
 965360011,
 965170455,
 6933,
 -1,
 965280559,
 6934,
 965491086,
 965296638,
 -1,
 -50803,
 965440542,
 6927,
 -1,
 965496489,
 6984,
 965687696,
 965422554,
 6936,
 -1,
 965608412,
 6937,
 965818770,
 965617552,
 6953,
 -1,
 965739467,
 6954,
 -50797,
 965799068,
 6986,
 -50796,
 965929375,
 6956,
 -50795,
 965992699,
 6959,
 -50794,
 966057150,
 6985,
 -50793,
 966099913,
 6955,
 -1,
 966154781,
 6963,
 966343105,
 962104308,
 -1,
 966408615,
 966277389,
 -1,
 966474145,
 966334854,
 -1,
 966539679,
 966430545,
 7012,
 966655999,
 966459392,
 -1,
 -50786,
 966575851,
 7013,
 -1,
 966612634,
 7018,
 -50784,
 966486579,
 7017,
 -1,
 966740122,
 7015,
 966932900,
 966410750,
 -1,
 -50781,
 966907833,
 7016,
 -1,
 966954833,
 7010,
 -50779,
 966907833,
 7011,
 -50778,
 967088455,
 7009,
 -1,
 967141939,
 7014,
 967326130,
 966341749,
 -1,
 967391661,
 967275747,
 -1,
 967457195,
 967366263,
 7021,
 -1,
 967380314,
 7024,
 967639039,
 967409171,
 7022,
 -1,
 967511386,
 7025,
 -50770,
 967363040,
 7019,
 -50769,
 967668358,
 7023,
 -50768,
 967727301,
 7027,
 -50767,
 967788675,
 7020,
 -1,
 967846224,
 7026,
 968047034,
 967277482,
 -1,
 968112567,
 968006493,
 -1,
 -50763,
 968087481,
 7033,
 -50762,
 968124979,
 7036,
 -1,
 968171858,
 7032,
 968425471,
 968045513,
 -1,
 -50759,
 968349267,
 7035,
 -1,
 968367719,
 7034,
 968622079,
 968012899,
 -1,
 968636862,
 968530713,
 -1,
 -50755,
 968611351,
 7028,
 -1,
 968629525,
 7029,
 968884223,
 968569811,
 -1,
 -50752,
 968808019,
 7030,
 -1,
 968826471,
 7031,
 969030099,
 966320182,
 -1,
 969095625,
 969000865,
 -1,
 969161160,
 969023303,
 6974,
 969277439,
 969080832,
 -1,
 969292231,
 969191780,
 6975,
 -1,
 969214405,
 6977,
 -1,
 969263568,
 6976,
 -1,
 969098503,
 6965,
 969554379,
 969070251,
 6966,
 -1,
 969476325,
 6967,
 969685453,
 969524937,
 6968,
 -1,
 969605991,
 6969,
 969816527,
 969649479,
 6970,
 -1,
 969738693,
 6971,
 969947601,
 969778593,
 6978,
 -1,
 969869765,
 6979,
 970129407,
 969897820,
 6972,
 -1,
 970000837,
 6973,
 970209761,
 968965219,
 -1,
 970275287,
 970180513,
 -1,
 -50730,
 970253846,
 6994,
 -1,
 970285536,
 6995,
 970471898,
 970242561,
 -1,
 -50727,
 970420592,
 6998,
 -1,
 970476693,
 6999,
 970668509,
 970411665,
 -1,
 -50724,
 970628861,
 6996,
 -1,
 970682558,
 6997,
 -50722,
 970648859,
 6992,
 -50721,
 970823765,
 6993,
 -50720,
 970887240,
 7001,
 -1,
 970933894,
 7000,
 971127273,
 970178489,
 -1,
 971192805,
 971101871,
 -1,
 -50716,
 971158293,
 6912,
 -1,
 971189841,
 6913,
 -50714,
 971163371,
 6915,
 -50713,
 971354503,
 6964,
 -50712,
 971386820,
 6914,
 -1,
 971451042,
 6916,
 971651566,
 971088651,
 -1,
 971717101,
 971604851,
 -1,
 -50708,
 971655305,
 7008,
 -1,
 971709451,
 7003,
 -1,
 971674359,
 7002,
 971979251,
 971583231,
 -1,
 972044786,
 971940619,
 -1,
 -50703,
 972009871,
 7007,
 -1,
 972065734,
 7005,
 -1,
 972013573,
 7006,
 -50700,
 971957263,
 7004,
 -1,
 972233763,
 6980,
 972488703,
 962033423,
 -1,
 972503556,
 972395543,
 -1,
 972569091,
 972474275,
 -1,
 972634626,
 972499857,
 -1,
 972700161,
 972613674,
 -1,
 972765695,
 972629855,
 -1,
 972831230,
 972723853,
 -1,
 -50691,
 972798977,
 128503,
 -1,
 972828871,
 128505,
 -1,
 972758877,
 128499,
 -50688,
 972733441,
 128501,
 -1,
 973045462,
 11197,
 -1,
 972650983,
 128502,
 -1,
 972602369,
 128500,
 -1,
 972527546,
 127880,
 -50683,
 972442489,
 129648,
 -1,
 973342030,
 129526,
 973552208,
 961988513,
 129415,
 973617741,
 973479530,
 -1,
 973683252,
 973569366,
 -1,
 973748759,
 973650433,
 -1,
 973814293,
 973695055,
 -1,
 -50676,
 973793695,
 7132,
 -50675,
 973857019,
 7116,
 -50674,
 973912790,
 7129,
 -50673,
 973974848,
 7123,
 -50672,
 974037771,
 7112,
 -50671,
 974095305,
 7125,
 -50670,
 974157657,
 7135,
 -50669,
 974215709,
 7107,
 -50668,
 974279959,
 7119,
 -1,
 974330246,
 7105,
 -50666,
 973774860,
 7126,
 -1,
 974461318,
 7128,
 974666269,
 973704236,
 -1,
 -50663,
 974645663,
 7136,
 -50662,
 974691646,
 7127,
 -50661,
 974738711,
 7133,
 -50660,
 974797212,
 7138,
 -1,
 974854534,
 7113,
 975059492,
 974619507,
 -1,
 975125027,
 974985606,
 7124,
 975241215,
 975080876,
 -1,
 -50655,
 975157974,
 7130,
 -50654,
 975211638,
 7114,
 -1,
 975264285,
 7108,
 -1,
 975054736,
 7139,
 975518246,
 975020811,
 7111,
 -1,
 975468154,
 7117,
 -50649,
 975497631,
 7131,
 -50648,
 975626491,
 7115,
 -50647,
 975688602,
 7141,
 -50646,
 975744320,
 7122,
 -50645,
 975796057,
 7134,
 -50644,
 975860777,
 7110,
 -50643,
 975925803,
 7120,
 -50642,
 975987629,
 7140,
 -50641,
 976050717,
 7106,
 -50640,
 976114967,
 7118,
 -50639,
 976173468,
 7121,
 -50638,
 976235994,
 7137,
 -50637,
 976299920,
 7109,
 -1,
 976361862,
 7104,
 976566847,
 973660214,
 -1,
 976632375,
 976540570,
 7150,
 -1,
 976552685,
 7151,
 976763450,
 976581667,
 -1,
 -50631,
 976720919,
 7149,
 -1,
 976774061,
 7147,
 976960060,
 976699902,
 7143,
 -1,
 976896510,
 7145,
 -50627,
 976921443,
 7144,
 -50626,
 977048599,
 7148,
 -1,
 977101741,
 7146,
 977287751,
 976534017,
 -1,
 977353286,
 977267554,
 -1,
 977418820,
 977314479,
 -1,
 -50621,
 977365245,
 7165,
 -1,
 977412519,
 7167,
 -50619,
 977374355,
 7164,
 -1,
 977564453,
 7166,
 -1,
 977299372,
 7142,
 977812042,
 977249183,
 -1,
 -50615,
 977770901,
 7155,
 -1,
 977819810,
 7154,
 978059263,
 977745240,
 -1,
 -50612,
 977964881,
 7152,
 -1,
 978016779,
 7153,
 978205263,
 973560331,
 128704,
 -1,
 978178438,
 128705,
 -1,
 978176680,
 128267,
 978401921,
 973519361,
 -1,
 978467454,
 978369241,
 -1,
 978532981,
 978419030,
 -1,
 978598486,
 978469374,
 92908,
 -50603,
 978555149,
 92880,
 -1,
 978600446,
 92907,
 978795097,
 978577700,
 -1,
 -50600,
 978740650,
 92885,
 -1,
 978798327,
 92900,
 978991707,
 978772219,
 92891,
 -1,
 978926170,
 92902,
 979122781,
 978965402,
 92906,
 -1,
 979101692,
 92896,
 979253855,
 979080215,
 92904,
 -1,
 979211287,
 92905,
 979384930,
 979202873,
 -1,
 -50591,
 979346257,
 92888,
 -1,
 979376518,
 92881,
 979581541,
 979326152,
 -1,
 -50588,
 979512587,
 92893,
 -1,
 979574111,
 92886,
 979778152,
 979515661,
 -1,
 -50585,
 979735575,
 92894,
 -1,
 979787545,
 92887,
 -50583,
 979758517,
 92892,
 -50582,
 979951764,
 92899,
 -50581,
 980012622,
 92897,
 -50580,
 980073497,
 92882,
 -50579,
 980132619,
 92901,
 -50578,
 980190756,
 92884,
 -50577,
 980251357,
 92889,
 -50576,
 980313005,
 92909,
 -50575,
 980378514,
 92890,
 -50574,
 980438758,
 92883,
 -50573,
 980496285,
 92895,
 -50572,
 980559760,
 92898,
 -1,
 980621702,
 92903,
 980826749,
 978465909,
 -1,
 980892281,
 980779413,
 -1,
 -50568,
 980815695,
 92915,
 -1,
 980880155,
 92913,
 981088892,
 980836029,
 -1,
 -50565,
 981012269,
 92916,
 -1,
 981076763,
 92912,
 -1,
 981043231,
 92914,
 -1,
 980767927,
 92917,
 981416576,
 978416904,
 129530,
 -1,
 981346299,
 127936,
 -1,
 981353487,
 9918,
 981613194,
 978357292,
 -1,
 981678728,
 981562169,
 127974,
 981794815,
 981635562,
 -1,
 -50555,
 981723756,
 128180,
 -50554,
 981772513,
 128183,
 -50553,
 981814367,
 128182,
 -1,
 981876029,
 128181,
 -50551,
 981627613,
 129685,
 -1,
 981999715,
 127820,
 982203030,
 981544355,
 -1,
 982268564,
 982151993,
 -1,
 982334097,
 982235649,
 -1,
 982399632,
 982284410,
 -1,
 -50545,
 982365972,
 11101,
 -1,
 982423123,
 11099,
 -1,
 982360884,
 983056,
 982712319,
 982253568,
 -1,
 -50541,
 982639824,
 128281,
 -1,
 982685018,
 128386,
 -50539,
 982241255,
 128043,
 -1,
 982816698,
 129363,
 982989468,
 982134163,
 128118,
 983105535,
 982908928,
 -1,
 -50535,
 983025502,
 128700,
 -50534,
 983052589,
 128036,
 -50533,
 983116815,
 127868,
 -1,
 983179621,
 128124,
 983382689,
 982953158,
 -1,
 983448224,
 983302144,
 -1,
 -50529,
 983405949,
 129532,
 -1,
 983445688,
 128202,
 -1,
 983378288,
 128136,
 983710373,
 983323848,
 -1,
 -50525,
 983684619,
 129366,
 -50524,
 983717230,
 128708,
 -1,
 983779081,
 129391,
 984023039,
 983644429,
 -1,
 -50521,
 983927143,
 127992,
 -1,
 983979752,
 129441,
 984169297,
 900705478,
 -1,
 984234816,
 984095110,
 -1,
 984300351,
 984178712,
 -1,
 984365807,
 984251734,
 -1,
 984431283,
 984341424,
 -1,
 984496818,
 984388781,
 -1,
 984562352,
 984460486,
 69643,
 -1,
 984526022,
 69644,
 984743935,
 984512271,
 69645,
 -1,
 984643343,
 69646,
 -1,
 984422790,
 69679,
 984890041,
 984401825,
 -1,
 984955575,
 984860577,
 -1,
 -50506,
 984898077,
 69662,
 -1,
 984947078,
 69661,
 -50504,
 984898077,
 69667,
 -1,
 985078150,
 69666,
 985283262,
 984847383,
 69649,
 985399295,
 985233916,
 -1,
 -50500,
 985315512,
 69686,
 -50499,
 985370904,
 69687,
 -1,
 985432137,
 69685,
 985610947,
 985238572,
 -1,
 -50496,
 985590175,
 69660,
 -50495,
 985631862,
 69665,
 -50494,
 985683223,
 69655,
 -1,
 985733510,
 69670,
 985938633,
 985544973,
 -1,
 986004167,
 985872653,
 -1,
 -50490,
 985946653,
 69664,
 -1,
 985995654,
 69663,
 -50488,
 985946653,
 69669,
 -1,
 986126726,
 69668,
 986331853,
 985864582,
 69637,
 -50485,
 986305434,
 69650,
 -50484,
 986342317,
 69648,
 -1,
 986388870,
 69638,
 986594001,
 986298881,
 -1,
 -50481,
 986561238,
 69681,
 -50480,
 986602013,
 69680,
 -1,
 986651014,
 69682,
 986856147,
 986567578,
 69641,
 -1,
 986829722,
 69642,
 986987222,
 986817199,
 -1,
 -50475,
 986929693,
 69672,
 -1,
 986978694,
 69671,
 987183833,
 986937103,
 -1,
 -50472,
 987133785,
 69684,
 -1,
 987175302,
 69678,
 987380444,
 987132729,
 -1,
 -50469,
 987322909,
 69652,
 -1,
 987371910,
 69651,
 987577055,
 987329037,
 -1,
 -50466,
 987519517,
 69659,
 -1,
 987568518,
 69658,
 987773665,
 987521965,
 69639,
 -1,
 987718573,
 69640,
 987904740,
 987714760,
 -1,
 -50461,
 987847197,
 69654,
 -1,
 987896198,
 69653,
 988101351,
 987835811,
 -1,
 -50458,
 988043805,
 69657,
 -1,
 988092806,
 69656,
 988297962,
 988030815,
 -1,
 -50455,
 988240413,
 69674,
 -1,
 988289414,
 69673,
 -50453,
 988277151,
 69676,
 -50452,
 988458304,
 69677,
 -50451,
 988513225,
 69675,
 -50450,
 988568093,
 69683,
 -1,
 988627454,
 69647,
 988822285,
 984322893,
 -1,
 988887800,
 988792737,
 -1,
 988953332,
 988864699,
 -1,
 -50445,
 988910615,
 69715,
 -1,
 988956982,
 69724,
 989149943,
 988895755,
 -1,
 -50442,
 989114542,
 69716,
 -1,
 989163283,
 69725,
 -1,
 989087687,
 69723,
 989412093,
 988854785,
 -1,
 989477627,
 989360496,
 69719,
 -1,
 989451134,
 69728,
 989659135,
 989416597,
 69720,
 -1,
 989582206,
 69729,
 989739780,
 989351569,
 -1,
 989805313,
 989697047,
 -1,
 -50432,
 989780412,
 69717,
 -1,
 989837648,
 69726,
 990052351,
 989750189,
 -1,
 -50429,
 989977752,
 69718,
 -1,
 990008492,
 69727,
 990198536,
 989698133,
 69714,
 990314495,
 990117888,
 -1,
 -50425,
 990235552,
 69733,
 -1,
 990274355,
 69732,
 990460682,
 990154824,
 69722,
 -1,
 990434174,
 69731,
 990591756,
 990398086,
 69721,
 -1,
 990570788,
 69730,
 -1,
 990540523,
 69759,
 990788384,
 988797872,
 -1,
 990853919,
 990749231,
 -1,
 990919444,
 990830429,
 -1,
 990984978,
 990883014,
 69694,
 -1,
 990948550,
 69695,
 991166463,
 990934799,
 69696,
 -1,
 991065871,
 69697,
 991247128,
 990845318,
 -1,
 -50410,
 991220634,
 69701,
 -50409,
 991257517,
 69699,
 -1,
 991304070,
 69688,
 991509274,
 991220634,
 69692,
 -1,
 991482778,
 69693,
 991640348,
 991454125,
 69690,
 -1,
 991585197,
 69691,
 -50403,
 991597591,
 69700,
 -50402,
 991707646,
 69698,
 -1,
 991767043,
 69689,
 -1,
 990801481,
 69702,
 992033585,
 990722317,
 -1,
 992099119,
 991979362,
 -1,
 992164645,
 992069537,
 -1,
 -50396,
 992142870,
 69736,
 -1,
 992174560,
 69737,
 992361256,
 992131585,
 -1,
 -50393,
 992309616,
 69740,
 -1,
 992365717,
 69741,
 992557867,
 992300689,
 -1,
 -50390,
 992517885,
 69738,
 -1,
 992571582,
 69739,
 -50388,
 992537883,
 69734,
 -50387,
 992712789,
 69735,
 -50386,
 992776264,
 69743,
 -1,
 992822918,
 69742,
 -50384,
 992059014,
 69704,
 -1,
 992944414,
 69703,
 993147703,
 992001977,
 -1,
 -50381,
 993124128,
 69634,
 -50380,
 993188062,
 69636,
 -50379,
 993227438,
 69635,
 -50378,
 993275511,
 69632,
 -1,
 993337893,
 69633,
 993591295,
 993110613,
 -1,
 993606459,
 993490703,
 -1,
 -50374,
 993566327,
 69709,
 -1,
 993618442,
 69707,
 993803070,
 993541394,
 -1,
 -50371,
 993776884,
 69706,
 -1,
 993839009,
 69705,
 -1,
 993736361,
 69708,
 -1,
 984246446,
 129504,
 994130760,
 984179629,
 -1,
 994196292,
 994067870,
 -1,
 -50365,
 994163201,
 129650,
 -1,
 994193173,
 128188,
 994392903,
 994130189,
 -1,
 -50362,
 994334319,
 127753,
 -1,
 994394893,
 128112,
 -1,
 994325247,
 129521,
 994655053,
 994087959,
 -1,
 -50358,
 994633168,
 129294,
 -50357,
 994678573,
 129529,
 -50356,
 994735346,
 128148,
 -1,
 994783115,
 129382,
 995033087,
 994591535,
 -1,
 -50353,
 994952304,
 129329,
 -50352,
 994997076,
 983124,
 -1,
 995047693,
 127838,
 995245054,
 984119055,
 -1,
 995310584,
 995171175,
 -1,
 995376012,
 995241379,
 -1,
 995441533,
 995319294,
 -1,
 995507047,
 995390265,
 -1,
 995572580,
 995463198,
 -1,
 995638112,
 995494060,
 -1,
 995703645,
 995608481,
 -1,
 995769180,
 995681970,
 -1,
 -50341,
 995742375,
 129585,
 -1,
 995802431,
 129597,
 -1,
 995713653,
 129606,
 -50338,
 995661958,
 129564,
 -50337,
 995987583,
 129555,
 -1,
 996037280,
 129543,
 996278271,
 995561125,
 -1,
 -50334,
 996194309,
 129618,
 -50333,
 996256815,
 129617,
 -1,
 996289199,
 129619,
 996540415,
 995519266,
 -1,
 -50330,
 996463436,
 129593,
 -1,
 996511871,
 129551,
 996686703,
 995480052,
 -1,
 996752235,
 996635449,
 -1,
 -50326,
 996708382,
 129576,
 -1,
 996764211,
 129572,
 -50324,
 996718597,
 129574,
 -50323,
 996912175,
 129573,
 -50322,
 996975783,
 129577,
 -1,
 997010095,
 129575,
 997210994,
 996653066,
 -1,
 -50319,
 997184332,
 129595,
 -1,
 997232767,
 129553,
 997407605,
 997174335,
 -1,
 -50316,
 997380940,
 129594,
 -1,
 997429375,
 129552,
 997604216,
 997369004,
 -1,
 -50313,
 997577548,
 129598,
 -1,
 997625983,
 129556,
 997800826,
 997542373,
 129609,
 -1,
 997722294,
 129612,
 997982207,
 997730998,
 -1,
 -50308,
 997905228,
 129596,
 -1,
 997953663,
 129554,
 998128522,
 995416743,
 -1,
 998194049,
 998103410,
 -1,
 -50304,
 998159622,
 11179,
 -1,
 998210630,
 11178,
 998390660,
 998159606,
 -1,
 -50301,
 998365567,
 11181,
 -1,
 998392037,
 11183,
 998587271,
 998341687,
 -1,
 -50298,
 998562175,
 11180,
 -1,
 998588645,
 11182,
 998834175,
 998523053,
 -1,
 -50295,
 998749446,
 11177,
 -1,
 998800454,
 11176,
 -50293,
 998094882,
 9960,
 -1,
 998927993,
 9210,
 999111582,
 995328883,
 -1,
 999177117,
 999048448,
 -1,
 999242642,
 999126799,
 -1,
 999308177,
 999179749,
 9204,
 -1,
 999227834,
 11207,
 -1,
 999268994,
 11047,
 999504790,
 999176461,
 -1,
 999570325,
 999465553,
 9207,
 -1,
 999489978,
 11206,
 -1,
 999515245,
 11045,
 999766936,
 999479497,
 9206,
 -1,
 999686586,
 11205,
 999898011,
 999735568,
 -1,
 -50278,
 999850599,
 128927,
 -1,
 999898152,
 128921,
 1000144895,
 999863495,
 9205,
 -1,
 1000014266,
 11208,
 -1,
 999135869,
 9912,
 1000291245,
 999078401,
 -1,
 1000356771,
 1000254398,
 -1,
 -50271,
 1000297054,
 9209,
 -50270,
 1000353774,
 11200,
 -1,
 1000418679,
 128306,
 1000618919,
 1000309929,
 -1,
 -50267,
 1000588439,
 11089,
 -50266,
 1000637031,
 11050,
 -1,
 1000684584,
 11049,
 1000881066,
 1000570590,
 -1,
 -50263,
 1000850269,
 128909,
 -1,
 1000878578,
 128900,
 -50261,
 1000837642,
 9927,
 -50260,
 1001027267,
 128369,
 -1,
 1001069783,
 9984,
 1001274300,
 1000225037,
 -1,
 1001339828,
 1001235007,
 -1,
 1001405362,
 1001263011,
 -1,
 -50255,
 1001353091,
 128899,
 -1,
 1001406364,
 9196,
 -50253,
 1001382281,
 11167,
 -1,
 1001523265,
 128419,
 1001733049,
 1001303238,
 -1,
 1001798584,
 1001662096,
 -1,
 -50249,
 1001751817,
 9922,
 -1,
 1001813415,
 9923,
 -1,
 1001757596,
 127778,
 1002110975,
 1001677940,
 -1,
 -50245,
 1002018769,
 11230,
 -1,
 1002057710,
 11201,
 1002257351,
 1001237702,
 -1,
 1002322886,
 1002202829,
 -1,
 1002388420,
 1002246051,
 -1,
 1002453953,
 1002323868,
 9193,
 -1,
 1002376786,
 9197,
 -50238,
 1002426383,
 9199,
 -50237,
 1002546564,
 11091,
 -1,
 1002598275,
 128898,
 -50235,
 1002365321,
 11166,
 -1,
 1002702913,
 128413,
 -1,
 1002282355,
 127990,
 1002978260,
 1002206991,
 -1,
 1003043793,
 1002915270,
 -1,
 1003109325,
 1002966947,
 -1,
 1003174860,
 1003044764,
 9194,
 -1,
 1003097682,
 9198,
 -1,
 1003122563,
 128896,
 1003371472,
 1003028480,
 -1,
 -50225,
 1003333630,
 128412,
 -1,
 1003386991,
 9944,
 -1,
 1003348361,
 11164,
 1003683839,
 1002971986,
 -1,
 -50221,
 1003602781,
 11035,
 -1,
 1003631090,
 11044,
 1003830236,
 1002948513,
 -1,
 1003895769,
 1003777475,
 -1,
 -50217,
 1003864925,
 128908,
 -50216,
 1003913831,
 128925,
 -1,
 1003961384,
 128919,
 -50214,
 1003874108,
 9942,
 -50213,
 1004124503,
 9951,
 -1,
 1004183232,
 128383,
 1004354530,
 1003806004,
 -1,
 1004420065,
 1004333405,
 -1,
 -50209,
 1004389213,
 11037,
 -50208,
 1004438119,
 128926,
 -1,
 1004485672,
 128920,
 -1,
 1004391625,
 11054,
 1004747752,
 1004328989,
 -1,
 1004813286,
 1004670883,
 -1,
 -50203,
 1004760963,
 128897,
 -1,
 1004814236,
 9195,
 -50201,
 1004790153,
 11165,
 -1,
 1004931137,
 128418,
 1005140974,
 1004689931,
 -1,
 1005206508,
 1005076990,
 -1,
 -50197,
 1005185081,
 11042,
 -1,
 1005200501,
 128420,
 -50195,
 1005165739,
 11052,
 -1,
 1005331237,
 128426,
 1005534195,
 1005101743,
 -1,
 1005599730,
 1005471687,
 -1,
 -50191,
 1005570165,
 11039,
 -1,
 1005620437,
 127986,
 -1,
 1005574914,
 128392,
 1005861878,
 1005473425,
 -1,
 -50187,
 1005819608,
 128447,
 -1,
 1005877189,
 9873,
 -50185,
 1005825145,
 10067,
 -1,
 1006015731,
 11204,
 1006189563,
 995284459,
 -1,
 -50182,
 1006132480,
 128153,
 -1,
 1006185457,
 128216,
 1006436351,
 1006146583,
 -1,
 -50179,
 1006363366,
 128033,
 -1,
 1006421051,
 127804,
 1006582915,
 995187305,
 -1,
 1006648380,
 1006533974,
 -1,
 1006713862,
 1006623664,
 -1,
 1006779397,
 1006671021,
 -1,
 1006844932,
 1006742726,
 72710,
 -1,
 1006808262,
 72711,
 -1,
 1006794511,
 72712,
 -1,
 1006705030,
 72746,
 1007107084,
 1006684065,
 -1,
 1007172618,
 1007077281,
 -1,
 -50167,
 1007114781,
 72729,
 -1,
 1007163782,
 72728,
 -50165,
 1007114781,
 72734,
 -1,
 1007294854,
 72733,
 1007500305,
 1007062060,
 -1,
 -50162,
 1007479199,
 72727,
 -50161,
 1007520886,
 72732,
 -50160,
 1007572247,
 72722,
 -1,
 1007622534,
 72737,
 1007827991,
 1007433997,
 -1,
 1007893525,
 1007761677,
 -1,
 -50156,
 1007835677,
 72731,
 -1,
 1007884678,
 72730,
 -50154,
 1007835677,
 72736,
 -1,
 1008015750,
 72735,
 1008221211,
 1007753606,
 72704,
 -50151,
 1008194458,
 72717,
 -50150,
 1008231341,
 72715,
 -1,
 1008277894,
 72705,
 1008483359,
 1008187905,
 -1,
 -50147,
 1008450262,
 72748,
 -50146,
 1008491037,
 72747,
 -1,
 1008540038,
 72749,
 1008745505,
 1008456602,
 72708,
 -1,
 1008718746,
 72709,
 1008876580,
 1008706223,
 -1,
 -50141,
 1008818717,
 72739,
 -1,
 1008867718,
 72738,
 1009073191,
 1008825145,
 -1,
 -50138,
 1009015325,
 72719,
 -1,
 1009064326,
 72718,
 1009269802,
 1009021453,
 -1,
 -50135,
 1009211933,
 72726,
 -1,
 1009260934,
 72725,
 1009466412,
 1009214381,
 72706,
 -1,
 1009410989,
 72707,
 1009597487,
 1009407176,
 -1,
 -50130,
 1009539613,
 72721,
 -1,
 1009588614,
 72720,
 1009794098,
 1009528227,
 -1,
 -50127,
 1009736221,
 72724,
 -1,
 1009785222,
 72723,
 1009990709,
 1009723231,
 -1,
 -50124,
 1009932829,
 72741,
 -1,
 1009981830,
 72740,
 -50122,
 1009969567,
 72743,
 -50121,
 1010150720,
 72744,
 -50120,
 1010209815,
 72716,
 -50119,
 1010271177,
 72742,
 -50118,
 1010333529,
 72745,
 -50117,
 1010391581,
 72750,
 -1,
 1010450942,
 72714,
 1010646102,
 1006605133,
 -1,
 1010711621,
 1010616225,
 -1,
 1010777153,
 1010688187,
 -1,
 -50112,
 1010734103,
 72795,
 -1,
 1010780470,
 72804,
 1010973764,
 1010719243,
 -1,
 -50109,
 1010938030,
 72796,
 -1,
 1010986771,
 72805,
 -1,
 1010911175,
 72803,
 1011235914,
 1010678273,
 -1,
 1011301448,
 1011183984,
 72799,
 -1,
 1011274622,
 72808,
 1011482623,
 1011240085,
 72800,
 -1,
 1011405694,
 72809,
 1011563601,
 1011175057,
 -1,
 1011629134,
 1011520535,
 -1,
 -50099,
 1011603900,
 72797,
 -1,
 1011661136,
 72806,
 1011875839,
 1011573677,
 -1,
 -50096,
 1011801240,
 72798,
 -1,
 1011831980,
 72807,
 1012022355,
 1011519560,
 72802,
 -1,
 1011995518,
 72811,
 1012153429,
 1011959430,
 72801,
 -1,
 1012132132,
 72810,
 -1,
 1012111445,
 72794,
 1012350053,
 1010622518,
 -1,
 1012415579,
 1012326237,
 -1,
 1012481114,
 1012378822,
 72756,
 -1,
 1012444358,
 72757,
 -1,
 1012430607,
 72758,
 1012677727,
 1012341126,
 -1,
 -50083,
 1012650906,
 72763,
 -50082,
 1012687789,
 72761,
 -1,
 1012734342,
 72751,
 1012939873,
 1012650906,
 72754,
 -1,
 1012913050,
 72755,
 1013070947,
 1012884397,
 72752,
 -1,
 1013015469,
 72753,
 -50076,
 1013027863,
 72762,
 -1,
 1013137918,
 72760,
 1013333110,
 1012283661,
 -1,
 1013398644,
 1013278562,
 -1,
 1013464170,
 1013368737,
 -1,
 -50071,
 1013442070,
 72786,
 -1,
 1013473760,
 72787,
 1013660781,
 1013430785,
 -1,
 -50068,
 1013608816,
 72790,
 -1,
 1013664917,
 72791,
 1013857392,
 1013599889,
 -1,
 -50065,
 1013817085,
 72788,
 -1,
 1013870782,
 72789,
 -50063,
 1013837083,
 72784,
 -50062,
 1014011989,
 72785,
 -50061,
 1014075464,
 72793,
 -1,
 1014122118,
 72792,
 -50059,
 1013358214,
 72770,
 -1,
 1014243614,
 72769,
 1014447230,
 1013301177,
 -1,
 1014512762,
 1014423229,
 -1,
 -50055,
 1014479793,
 72766,
 -1,
 1014541913,
 72767,
 1014709373,
 1014438278,
 -1,
 -50052,
 1014684614,
 72768,
 -1,
 1014731666,
 72765,
 -1,
 1014640247,
 72764,
 1014971521,
 1014388173,
 -1,
 -50048,
 1014895207,
 72773,
 -1,
 1014960444,
 72772,
 -50046,
 1014949784,
 72771,
 -1,
 1015112529,
 72812,
 1015299253,
 1006556058,
 -1,
 1015364778,
 1015239880,
 128027,
 1015480319,
 1015310892,
 -1,
 1015495842,
 1015381334,
 -1,
 1015561360,
 1015450668,
 -1,
 1015626891,
 1015540004,
 -1,
 -50038,
 1015557594,
 6671,
 -1,
 1015617926,
 6670,
 1015823502,
 1015567560,
 -1,
 -50035,
 1015772043,
 6659,
 -1,
 1015814534,
 6658,
 -50033,
 1015786816,
 6667,
 -1,
 1015945606,
 6666,
 1016151187,
 1015513971,
 -1,
 -50030,
 1016111883,
 6663,
 -1,
 1016142214,
 6662,
 -50028,
 1016129951,
 6672,
 -50027,
 1016323011,
 6675,
 -50026,
 1016383527,
 6664,
 -50025,
 1016445654,
 6676,
 -50024,
 1016507712,
 6673,
 -50023,
 1016570635,
 6660,
 -50022,
 1016624985,
 6674,
 -50021,
 1016689547,
 6656,
 -50020,
 1016754731,
 6669,
 -50019,
 1016814109,
 6678,
 -50018,
 1016878359,
 6657,
 -50017,
 1016936860,
 6665,
 -50016,
 1016999386,
 6668,
 -50015,
 1017063312,
 6661,
 -1,
 1017125254,
 6677,
 1017330856,
 1015472182,
 -1,
 -50012,
 1017303962,
 6680,
 -50011,
 1017353239,
 6682,
 -50010,
 1017406381,
 6679,
 -50009,
 1017463294,
 6681,
 -1,
 1017519176,
 6683,
 -50007,
 1017291647,
 6686,
 -1,
 1017661533,
 6687,
 1017855151,
 1015331329,
 128652,
 1017920686,
 1017825185,
 -1,
 -50003,
 1017887297,
 128101,
 -1,
 1017906050,
 128100,
 -1,
 1017842055,
 128655,
 1018182833,
 1017827687,
 129480,
 -1,
 1018122789,
 129419,
 1018313907,
 1018134572,
 128363,
 -1,
 1018236436,
 128364,
 -49996,
 1018280130,
 127791,
 -1,
 1018390536,
 127959,
 1018576100,
 1015256087,
 -1,
 1018641599,
 1018548540,
 -1,
 1018707134,
 1018599216,
 -1,
 -49991,
 1018679060,
 9185,
 -49990,
 1018737579,
 11813,
 -49989,
 1018799188,
 9181,
 -49988,
 1018854187,
 11812,
 -49987,
 1018911428,
 11211,
 -1,
 1018968216,
 9183,
 -1,
 1018657348,
 127870,
 1019231433,
 1018591673,
 -1,
 1019296963,
 1019208431,
 -1,
 -49982,
 1019265885,
 128912,
 -1,
 1019294194,
 128902,
 1019493574,
 1019263489,
 -1,
 -49979,
 1019441543,
 128951,
 -1,
 1019486199,
 128939,
 -49977,
 1019435358,
 128932,
 -49976,
 1019629910,
 128945,
 -1,
 1019692721,
 128957,
 1019886800,
 1019193490,
 -1,
 -49973,
 1019866593,
 12730,
 -49972,
 1019909183,
 12590,
 -49971,
 1019973894,
 12591,
 -49970,
 1020034554,
 12729,
 -49969,
 1020094409,
 12589,
 -1,
 1020155718,
 12728,
 1020345559,
 1019863227,
 -1,
 1020411094,
 1020294927,
 -1,
 1020476629,
 1020329984,
 -1,
 -49964,
 1020454197,
 129379,
 -1,
 1020499302,
 128335,
 -1,
 1020422707,
 127923,
 -1,
 1020330056,
 127993,
 1020804315,
 1020302899,
 128366,
 1020869850,
 1020757363,
 128278,
 -1,
 1020791222,
 128209,
 -1,
 1020836353,
 128218,
 1021066461,
 1020782884,
 128102,
 -1,
 1021033131,
 128713,
 1021197535,
 1021041078,
 128144,
 -1,
 1021117729,
 127893,
 1021328609,
 1021150067,
 983258,
 -1,
 1021257567,
 128163,
 -49950,
 1021307076,
 129354,
 -49949,
 1021414928,
 129460,
 -1,
 1021452972,
 128023,
 1021656327,
 1018511870,
 -1,
 1021721847,
 1021611052,
 -1,
 1021787379,
 1021662597,
 -1,
 1021852908,
 1021738326,
 -1,
 1021918443,
 1021801766,
 -1,
 -49942,
 1021865416,
 983642,
 -1,
 1021911331,
 2510,
 -1,
 1021893850,
 2556,
 1022180591,
 1021819393,
 -1,
 -49938,
 1022125963,
 2493,
 -1,
 1022173491,
 2558,
 1022377202,
 1022105990,
 -1,
 -49935,
 1022333169,
 2432,
 -1,
 1022372084,
 2557,
 -1,
 1022318000,
 2555,
 1022639350,
 1021757345,
 -1,
 -49931,
 1022596124,
 127857,
 -1,
 1022623982,
 11102,
 -1,
 1022618885,
 9187,
 1022901504,
 1021647238,
 -1,
 1022967035,
 1022864582,
 -1,
 -49926,
 1022900941,
 129492,
 -1,
 1022952124,
 128059,
 1023163646,
 1022920379,
 -1,
 -49923,
 1023097690,
 127901,
 -1,
 1023157470,
 127900,
 -49921,
 1023135189,
 128147,
 -1,
 1023291486,
 127958,
 1023491332,
 1022850831,
 983055,
 1023606783,
 1023440655,
 128276,
 -49917,
 1023500477,
 128718,
 -1,
 1023544204,
 128277,
 -49915,
 1023466818,
 129475,
 -49914,
 1023691296,
 127866,
 -1,
 1023752461,
 128719,
 1023950099,
 1021600685,
 -1,
 1024015627,
 1023913158,
 -1,
 -49910,
 1023986458,
 127874,
 -1,
 1024014605,
 128038,
 1024212238,
 1023967184,
 -1,
 -49907,
 1024156863,
 127921,
 -1,
 1024214107,
 129506,
 1024408849,
 1024145672,
 -1,
 -49904,
 1024356294,
 128692,
 -1,
 1024410110,
 128690,
 -49902,
 1024379239,
 8383,
 -1,
 1024554432,
 128089,
 1024736534,
 1023928612,
 -1,
 -49899,
 1024715942,
 983267,
 -1,
 1024772469,
 983257,
 -49897,
 1024702977,
 983057,
 -1,
 1024894482,
 983125,
 1025065926,
 900602246,
 -1,
 1025130415,
 1025018924,
 -1,
 1025195936,
 1025058341,
 -1,
 1025260954,
 1025118524,
 -1,
 1025326386,
 1025183788,
 -1,
 1025391905,
 1025251139,
 83070,
 -49889,
 1025322403,
 83073,
 -49888,
 1025386335,
 83072,
 -1,
 1025448326,
 83071,
 1025654053,
 1025316010,
 83062,
 -49885,
 1025584547,
 83065,
 -49884,
 1025648479,
 83064,
 -1,
 1025710470,
 83063,
 1025916200,
 1025578366,
 83066,
 -49881,
 1025845087,
 83068,
 -1,
 1025907078,
 83067,
 1026112810,
 1025839719,
 83059,
 -1,
 1026038150,
 83060,
 1026243884,
 1026036028,
 83057,
 -1,
 1026169222,
 83058,
 1026374958,
 1026166828,
 83055,
 -1,
 1026300294,
 83056,
 -49873,
 1026300116,
 83075,
 -49872,
 1026431011,
 83074,
 -49871,
 1026496115,
 83069,
 -1,
 1026560908,
 83061,
 1026768192,
 1025249596,
 -1,
 1026833718,
 1026691116,
 83076,
 -49867,
 1026762591,
 83078,
 -1,
 1026824582,
 83077,
 1027030328,
 1026758014,
 83083,
 -1,
 1026955654,
 83084,
 -49863,
 1026955476,
 83088,
 -49862,
 1027086371,
 83087,
 -49861,
 1027151683,
 83086,
 -49860,
 1027217011,
 83085,
 -49859,
 1027282090,
 83082,
 -49858,
 1027347340,
 83081,
 -49857,
 1027412583,
 83080,
 -1,
 1027477820,
 83079,
 1027685708,
 1026691980,
 -1,
 1027751235,
 1027609982,
 83105,
 -1,
 1027676550,
 83106,
 -49852,
 1027676372,
 83110,
 -49851,
 1027807267,
 83109,
 -49850,
 1027872579,
 83108,
 -49849,
 1027937907,
 83107,
 -49848,
 1028002986,
 83104,
 -49847,
 1028068236,
 83103,
 -49846,
 1028133479,
 83102,
 -49845,
 1028198716,
 83101,
 -1,
 1028263980,
 83100,
 1028472152,
 1027609191,
 -1,
 1028537679,
 1028396414,
 83094,
 -1,
 1028462982,
 83095,
 -49840,
 1028462804,
 83099,
 -49839,
 1028593699,
 83098,
 -49838,
 1028659011,
 83097,
 -49837,
 1028724339,
 83096,
 -49836,
 1028789418,
 83093,
 -49835,
 1028854668,
 83092,
 -49834,
 1028919911,
 83091,
 -49833,
 1028985148,
 83090,
 -1,
 1029050412,
 83089,
 1029258595,
 1028397268,
 -1,
 -49830,
 1029183700,
 83170,
 -49829,
 1029249059,
 83169,
 -49828,
 1029314371,
 83168,
 -49827,
 1029379699,
 83167,
 -49826,
 1029444990,
 83166,
 -49825,
 1029510314,
 83165,
 -49824,
 1029575564,
 83164,
 -49823,
 1029640807,
 83163,
 -49822,
 1029706044,
 83162,
 -1,
 1029771308,
 83161,
 1029979502,
 1029183523,
 -1,
 -49819,
 1029904596,
 83160,
 -49818,
 1029969955,
 83159,
 -49817,
 1030035267,
 83158,
 -49816,
 1030100595,
 83157,
 -49815,
 1030165886,
 83156,
 -49814,
 1030231210,
 83155,
 -49813,
 1030296460,
 83154,
 -49812,
 1030361703,
 83153,
 -49811,
 1030426940,
 83152,
 -1,
 1030492204,
 83151,
 1030700409,
 1029904195,
 -1,
 -49808,
 1030625492,
 83150,
 -49807,
 1030690851,
 83149,
 -49806,
 1030756163,
 83148,
 -49805,
 1030821491,
 83147,
 -49804,
 1030886782,
 83146,
 -49803,
 1030952106,
 83145,
 -49802,
 1031017356,
 83144,
 -49801,
 1031082599,
 83143,
 -49800,
 1031147836,
 83142,
 -1,
 1031213100,
 83141,
 1031421316,
 1030624883,
 -1,
 -49797,
 1031346388,
 83140,
 -49796,
 1031411747,
 83139,
 -49795,
 1031477059,
 83138,
 -49794,
 1031542387,
 83137,
 -49793,
 1031607678,
 83136,
 -49792,
 1031673002,
 83135,
 -49791,
 1031738252,
 83134,
 -49790,
 1031803495,
 83133,
 -49789,
 1031868732,
 83132,
 -1,
 1031933996,
 83131,
 1032142223,
 1031345534,
 -1,
 -49786,
 1032067284,
 83130,
 -49785,
 1032132643,
 83129,
 -49784,
 1032197955,
 83128,
 -49783,
 1032263283,
 83127,
 -49782,
 1032328574,
 83126,
 -49781,
 1032393898,
 83125,
 -49780,
 1032459148,
 83124,
 -49779,
 1032524391,
 83123,
 -49778,
 1032589628,
 83122,
 -1,
 1032654892,
 83121,
 1032912895,
 1032066218,
 -1,
 -49775,
 1032788180,
 83120,
 -49774,
 1032853539,
 83119,
 -49773,
 1032918851,
 83118,
 -49772,
 1032984179,
 83117,
 -49771,
 1033049470,
 83116,
 -49770,
 1033114794,
 83115,
 -49769,
 1033180044,
 83114,
 -49768,
 1033245287,
 83113,
 -49767,
 1033310524,
 83112,
 -1,
 1033375788,
 83111,
 1033584153,
 1025184652,
 -1,
 1033649580,
 1033507724,
 -1,
 1033715104,
 1033574003,
 83322,
 -49762,
 1033645475,
 83325,
 -49761,
 1033709407,
 83324,
 -1,
 1033771398,
 83323,
 1033977252,
 1033638503,
 -1,
 -49758,
 1033907619,
 83318,
 -49757,
 1033971551,
 83317,
 -1,
 1034033542,
 83316,
 -49755,
 1033902292,
 83328,
 -49754,
 1034164259,
 83327,
 -49753,
 1034229571,
 83326,
 -49752,
 1034294654,
 83321,
 -49751,
 1034359978,
 83320,
 -49750,
 1034425228,
 83319,
 -49749,
 1034490172,
 83315,
 -1,
 1034555436,
 83314,
 1034763707,
 1033574435,
 -1,
 1034829231,
 1034688115,
 83381,
 -1,
 1034754438,
 83382,
 1034960306,
 1034752908,
 -1,
 -49743,
 1034885510,
 83378,
 -1,
 1034946676,
 83377,
 1035156916,
 1034883388,
 83374,
 -1,
 1035082118,
 83375,
 -49739,
 1035081940,
 83385,
 -49738,
 1035212835,
 83384,
 -49737,
 1035278147,
 83383,
 -49736,
 1035343230,
 83380,
 -49735,
 1035408554,
 83379,
 -49734,
 1035473511,
 83376,
 -1,
 1035538476,
 83373,
 1035746760,
 1034688115,
 -1,
 1035812286,
 1035671587,
 83359,
 -1,
 1035737478,
 83360,
 1035943360,
 1035736234,
 83354,
 -1,
 1035868550,
 83355,
 -49727,
 1035868372,
 83361,
 -49726,
 1035999043,
 83358,
 -49725,
 1036064371,
 83357,
 -49724,
 1036129662,
 83356,
 -49723,
 1036194700,
 83353,
 -49722,
 1036259943,
 83352,
 -49721,
 1036325180,
 83351,
 -1,
 1036390444,
 83350,
 1036598740,
 1035671363,
 -1,
 1036664267,
 1036521788,
 83363,
 -1,
 1036589446,
 83364,
 -49716,
 1036589268,
 83372,
 -49715,
 1036720163,
 83371,
 -49714,
 1036785475,
 83370,
 -49713,
 1036850803,
 83369,
 -49712,
 1036916094,
 83368,
 -49711,
 1036981418,
 83367,
 -49710,
 1037046668,
 83366,
 -49709,
 1037111911,
 83365,
 -1,
 1037176876,
 83362,
 1037385184,
 1036522878,
 -1,
 1037450711,
 1037310164,
 83348,
 -1,
 1037375878,
 83349,
 -49704,
 1037375523,
 83347,
 -49703,
 1037506371,
 83346,
 -49702,
 1037571699,
 83345,
 -49701,
 1037636990,
 83344,
 -49700,
 1037702314,
 83343,
 -49699,
 1037767564,
 83342,
 -49698,
 1037832807,
 83341,
 -49697,
 1037898044,
 83340,
 -1,
 1037963308,
 83339,
 1038171628,
 1037308519,
 -1,
 1038237155,
 1038096596,
 83312,
 -1,
 1038162310,
 83313,
 -49692,
 1038161955,
 83311,
 -49691,
 1038292803,
 83310,
 -49690,
 1038358131,
 83309,
 -49689,
 1038423422,
 83308,
 -49688,
 1038488746,
 83307,
 -49687,
 1038553996,
 83306,
 -49686,
 1038619239,
 83305,
 -49685,
 1038684476,
 83304,
 -1,
 1038749740,
 83303,
 1038958072,
 1038094380,
 -1,
 1039023599,
 1038883028,
 83291,
 -1,
 1038948742,
 83292,
 -49680,
 1038948387,
 83290,
 -49679,
 1039079235,
 83289,
 -49678,
 1039144563,
 83288,
 -49677,
 1039209854,
 83287,
 -49676,
 1039275178,
 83286,
 -49675,
 1039340428,
 83285,
 -49674,
 1039405671,
 83284,
 -49673,
 1039470908,
 83283,
 -1,
 1039536172,
 83282,
 1039744515,
 1038883028,
 -1,
 -49670,
 1039669460,
 83395,
 -49669,
 1039734819,
 83394,
 -49668,
 1039800131,
 83393,
 -49667,
 1039865459,
 83392,
 -49666,
 1039930750,
 83391,
 -49665,
 1039996074,
 83390,
 -49664,
 1040061363,
 83389,
 -49663,
 1040126567,
 83388,
 -49662,
 1040191804,
 83387,
 -1,
 1040257068,
 83386,
 1040465422,
 1039668394,
 -1,
 -49659,
 1040390356,
 83338,
 -49658,
 1040455715,
 83337,
 -49657,
 1040521027,
 83336,
 -49656,
 1040586355,
 83335,
 -49655,
 1040651646,
 83334,
 -49654,
 1040716970,
 83333,
 -49653,
 1040782220,
 83332,
 -49652,
 1040847463,
 83331,
 -49651,
 1040912700,
 83330,
 -1,
 1040977964,
 83329,
 1041235967,
 1040388412,
 -1,
 -49648,
 1041111252,
 83302,
 -49647,
 1041176611,
 83301,
 -49646,
 1041241923,
 83300,
 -49645,
 1041307251,
 83299,
 -49644,
 1041372542,
 83298,
 -49643,
 1041437866,
 83297,
 -49642,
 1041503116,
 83296,
 -49641,
 1041568359,
 83295,
 -49640,
 1041633596,
 83294,
 -1,
 1041698860,
 83293,
 1041907347,
 1033507431,
 -1,
 1041972777,
 1041829932,
 -1,
 1042038302,
 1041896039,
 83173,
 -49635,
 1041966943,
 83175,
 -1,
 1042028934,
 83174,
 1042234912,
 1041963220,
 83183,
 -1,
 1042160006,
 83184,
 1042365986,
 1042159427,
 83180,
 -1,
 1042291078,
 83181,
 -49629,
 1042290723,
 83182,
 -49628,
 1042421363,
 83179,
 -49627,
 1042486654,
 83178,
 -49626,
 1042551978,
 83177,
 -49625,
 1042617228,
 83176,
 -49624,
 1042682172,
 83172,
 -1,
 1042747436,
 83171,
 1042955830,
 1041897684,
 -1,
 1043021356,
 1042880724,
 83280,
 -1,
 1042946438,
 83281,
 1043152430,
 1042945194,
 83274,
 -1,
 1043077510,
 83275,
 -49617,
 1043077155,
 83279,
 -49616,
 1043208003,
 83278,
 -49615,
 1043273331,
 83277,
 -49614,
 1043338622,
 83276,
 -49613,
 1043403660,
 83273,
 -49612,
 1043468903,
 83272,
 -49611,
 1043534140,
 83271,
 -1,
 1043599404,
 83270,
 1043807811,
 1042878780,
 -1,
 1043873337,
 1043732083,
 83192,
 -1,
 1043798406,
 83193,
 1044004411,
 1043797374,
 83190,
 -1,
 1043929478,
 83191,
 -49604,
 1043929300,
 83196,
 -49603,
 1044060195,
 83195,
 -49602,
 1044125507,
 83194,
 -49601,
 1044190378,
 83189,
 -49600,
 1044255628,
 83188,
 -49599,
 1044320871,
 83187,
 -49598,
 1044386108,
 83186,
 -1,
 1044451372,
 83185,
 1044659791,
 1043732515,
 -1,
 1044725318,
 1044584660,
 83268,
 -1,
 1044650374,
 83269,
 -49593,
 1044650019,
 83267,
 -49592,
 1044780867,
 83266,
 -49591,
 1044846195,
 83265,
 -49590,
 1044911486,
 83264,
 -49589,
 1044976810,
 83263,
 -49588,
 1045042060,
 83262,
 -49587,
 1045107303,
 83261,
 -49586,
 1045172540,
 83260,
 -1,
 1045237804,
 83259,
 1045446235,
 1044584051,
 -1,
 1045511762,
 1045370691,
 83245,
 -1,
 1045436806,
 83246,
 -49581,
 1045436628,
 83248,
 -49580,
 1045567523,
 83247,
 -49579,
 1045632627,
 83244,
 -49578,
 1045697918,
 83243,
 -49577,
 1045763242,
 83242,
 -49576,
 1045828492,
 83241,
 -49575,
 1045893735,
 83240,
 -49574,
 1045958972,
 83239,
 -1,
 1046024236,
 83238,
 1046232679,
 1045369447,
 -1,
 1046298206,
 1046157123,
 83204,
 -1,
 1046223238,
 83205,
 -49569,
 1046223060,
 83207,
 -49568,
 1046353955,
 83206,
 -49567,
 1046419059,
 83203,
 -49566,
 1046484350,
 83202,
 -49565,
 1046549674,
 83201,
 -49564,
 1046614924,
 83200,
 -49563,
 1046680167,
 83199,
 -49562,
 1046745404,
 83198,
 -1,
 1046810668,
 83197,
 1047019122,
 1046157123,
 -1,
 -49559,
 1046943956,
 83258,
 -49558,
 1047009315,
 83257,
 -49557,
 1047074627,
 83256,
 -49556,
 1047139955,
 83255,
 -49555,
 1047205246,
 83254,
 -49554,
 1047270570,
 83253,
 -49553,
 1047335820,
 83252,
 -49552,
 1047401063,
 83251,
 -49551,
 1047466300,
 83250,
 -1,
 1047531564,
 83249,
 1047740029,
 1046943102,
 -1,
 -49548,
 1047664852,
 83237,
 -49547,
 1047730211,
 83236,
 -49546,
 1047795523,
 83235,
 -49545,
 1047860851,
 83234,
 -49544,
 1047926142,
 83233,
 -49543,
 1047991466,
 83232,
 -49542,
 1048056716,
 83231,
 -49541,
 1048121959,
 83230,
 -49540,
 1048187196,
 83229,
 -1,
 1048252460,
 83228,
 1048460936,
 1047663786,
 -1,
 -49537,
 1048385748,
 83227,
 -49536,
 1048451107,
 83226,
 -49535,
 1048516419,
 83225,
 -49534,
 1048581747,
 83224,
 -49533,
 1048647038,
 83223,
 -49532,
 1048712362,
 83222,
 -49531,
 1048777612,
 83221,
 -49530,
 1048842855,
 83220,
 -49529,
 1048908092,
 83219,
 -1,
 1048973356,
 83218,
 1049231359,
 1048384396,
 -1,
 -49526,
 1049106644,
 83217,
 -49525,
 1049172003,
 83216,
 -49524,
 1049237315,
 83215,
 -49523,
 1049302643,
 83214,
 -49522,
 1049367934,
 83213,
 -49521,
 1049433258,
 83212,
 -49520,
 1049498508,
 83211,
 -49519,
 1049563751,
 83210,
 -49518,
 1049628988,
 83209,
 -1,
 1049694252,
 83208,
 1049902861,
 1041829932,
 -1,
 1049968291,
 1049826474,
 -1,
 1050033816,
 1049892467,
 82994,
 -49513,
 1049962335,
 82996,
 -1,
 1050024326,
 82995,
 1050230426,
 1049957758,
 82992,
 -1,
 1050155398,
 82993,
 1050361500,
 1050153276,
 82987,
 -1,
 1050286470,
 82988,
 -49507,
 1050286292,
 82999,
 -49506,
 1050417187,
 82998,
 -49505,
 1050482499,
 82997,
 -49504,
 1050547370,
 82991,
 -49503,
 1050612620,
 82990,
 -49502,
 1050677863,
 82989,
 -1,
 1050742828,
 82986,
 1050951345,
 1049892467,
 -1,
 1051016872,
 1050875507,
 83016,
 -49498,
 1050946979,
 83019,
 -49497,
 1051010911,
 83018,
 -1,
 1051072902,
 83017,
 -49495,
 1050941652,
 83022,
 -49494,
 1051203619,
 83021,
 -49493,
 1051268931,
 83020,
 -49492,
 1051334014,
 83015,
 -49491,
 1051399338,
 83014,
 -49490,
 1051464588,
 83013,
 -49489,
 1051529831,
 83012,
 -49488,
 1051595068,
 83011,
 -1,
 1051660332,
 83010,
 1051868862,
 1050876116,
 -1,
 1051934388,
 1051793443,
 83052,
 -1,
 1051859334,
 83053,
 1052065462,
 1051858755,
 83050,
 -1,
 1051990406,
 83051,
 -49481,
 1051990228,
 83054,
 -49480,
 1052120691,
 83049,
 -49479,
 1052185982,
 83048,
 -49478,
 1052251306,
 83047,
 -49477,
 1052316556,
 83046,
 -49476,
 1052381799,
 83045,
 -49475,
 1052447036,
 83044,
 -1,
 1052512300,
 83043,
 1052720842,
 1051792268,
 -1,
 1052786369,
 1052645588,
 82984,
 -1,
 1052711302,
 82985,
 -49470,
 1052710947,
 82983,
 -49469,
 1052841795,
 82982,
 -49468,
 1052907123,
 82981,
 -49467,
 1052972414,
 82980,
 -49466,
 1053037738,
 82979,
 -49465,
 1053102988,
 82978,
 -49464,
 1053168231,
 82977,
 -49463,
 1053233468,
 82976,
 -1,
 1053298732,
 82975,
 1053507286,
 1052643943,
 -1,
 1053572813,
 1053431411,
 82970,
 -1,
 1053497734,
 82971,
 -49458,
 1053497556,
 82974,
 -49457,
 1053628451,
 82973,
 -49456,
 1053693763,
 82972,
 -49455,
 1053758846,
 82969,
 -49454,
 1053824170,
 82968,
 -49453,
 1053889420,
 82967,
 -49452,
 1053954663,
 82966,
 -49451,
 1054019900,
 82965,
 -1,
 1054085164,
 82964,
 1054293730,
 1053430076,
 -1,
 1054359257,
 1054216236,
 82953,
 -1,
 1054284166,
 82954,
 -49446,
 1054283988,
 82963,
 -49445,
 1054414883,
 82962,
 -49444,
 1054480195,
 82961,
 -49443,
 1054545523,
 82960,
 -49442,
 1054610814,
 82959,
 -49441,
 1054676138,
 82958,
 -49440,
 1054741388,
 82957,
 -49439,
 1054806631,
 82956,
 -1,
 1054871868,
 82955,
 1055080173,
 1054218275,
 -1,
 -49436,
 1055004884,
 83042,
 -49435,
 1055070243,
 83041,
 -49434,
 1055135555,
 83040,
 -49433,
 1055200883,
 83039,
 -49432,
 1055266174,
 83038,
 -49431,
 1055331498,
 83037,
 -49430,
 1055396748,
 83036,
 -49429,
 1055461991,
 83035,
 -49428,
 1055527228,
 83034,
 -1,
 1055592492,
 83033,
 1055801080,
 1055004483,
 -1,
 -49425,
 1055725780,
 83032,
 -49424,
 1055791139,
 83031,
 -49423,
 1055856451,
 83030,
 -49422,
 1055921779,
 83029,
 -49421,
 1055987070,
 83028,
 -49420,
 1056052394,
 83027,
 -49419,
 1056117644,
 83026,
 -49418,
 1056182887,
 83025,
 -49417,
 1056248124,
 83024,
 -1,
 1056313388,
 83023,
 1056521987,
 1055724926,
 -1,
 -49414,
 1056446676,
 83009,
 -49413,
 1056512035,
 83008,
 -49412,
 1056577347,
 83007,
 -49411,
 1056642675,
 83006,
 -49410,
 1056707966,
 83005,
 -49409,
 1056773290,
 83004,
 -49408,
 1056838540,
 83003,
 -49407,
 1056903783,
 83002,
 -49406,
 1056969020,
 83001,
 -1,
 1057034284,
 83000,
 1057292287,
 1056444460,
 -1,
 -49403,
 1057167572,
 82952,
 -49402,
 1057232931,
 82951,
 -49401,
 1057298243,
 82950,
 -49400,
 1057363571,
 82949,
 -49399,
 1057428862,
 82948,
 -49398,
 1057494186,
 82947,
 -49397,
 1057559436,
 82946,
 -49396,
 1057624679,
 82945,
 -1,
 1057689916,
 82944,
 1057898366,
 1049826474,
 -1,
 1057963803,
 1057822078,
 -1,
 1058029329,
 1057888067,
 83455,
 -1,
 1057954182,
 83456,
 1058160403,
 1057951788,
 83447,
 -1,
 1058085254,
 83448,
 -49388,
 1058085076,
 83458,
 -49387,
 1058215971,
 83457,
 -49386,
 1058281075,
 83454,
 -49385,
 1058346366,
 83453,
 -49384,
 1058411690,
 83452,
 -49383,
 1058476940,
 83451,
 -49382,
 1058542183,
 83450,
 -1,
 1058607420,
 83449,
 1058815784,
 1057886524,
 -1,
 1058881311,
 1058738220,
 -1,
 -49378,
 1058806155,
 83407,
 -1,
 1058865491,
 83406,
 -49376,
 1058805972,
 83416,
 -49375,
 1059002403,
 83415,
 -49374,
 1059067715,
 83414,
 -49373,
 1059133043,
 83413,
 -49372,
 1059198334,
 83412,
 -49371,
 1059263658,
 83411,
 -49370,
 1059328908,
 83410,
 -49369,
 1059394151,
 83409,
 -1,
 1059459388,
 83408,
 1059667763,
 1058740259,
 -1,
 -49366,
 1059592404,
 83488,
 -49365,
 1059657763,
 83487,
 -49364,
 1059723075,
 83486,
 -49363,
 1059788403,
 83485,
 -49362,
 1059853694,
 83484,
 -49361,
 1059919018,
 83483,
 -49360,
 1059984268,
 83482,
 -49359,
 1060049511,
 83481,
 -49358,
 1060114748,
 83480,
 -1,
 1060180012,
 83479,
 1060388670,
 1059592003,
 -1,
 -49355,
 1060313300,
 83478,
 -49354,
 1060378659,
 83477,
 -49353,
 1060443971,
 83476,
 -49352,
 1060509299,
 83475,
 -49351,
 1060574590,
 83474,
 -49350,
 1060639914,
 83473,
 -49349,
 1060705164,
 83472,
 -49348,
 1060770407,
 83471,
 -49347,
 1060835644,
 83470,
 -1,
 1060900908,
 83469,
 1061109577,
 1060312691,
 -1,
 -49344,
 1061034196,
 83468,
 -49343,
 1061099555,
 83467,
 -49342,
 1061164867,
 83466,
 -49341,
 1061230195,
 83465,
 -49340,
 1061295486,
 83464,
 -49339,
 1061360810,
 83463,
 -49338,
 1061426060,
 83462,
 -49337,
 1061491303,
 83461,
 -49336,
 1061556540,
 83460,
 -1,
 1061621804,
 83459,
 1061830484,
 1061033130,
 -1,
 -49333,
 1061755092,
 83446,
 -49332,
 1061820451,
 83445,
 -49331,
 1061885763,
 83444,
 -49330,
 1061951091,
 83443,
 -49329,
 1062016382,
 83442,
 -49328,
 1062081706,
 83441,
 -49327,
 1062146956,
 83440,
 -49326,
 1062212199,
 83439,
 -49325,
 1062277436,
 83438,
 -1,
 1062342700,
 83437,
 1062551391,
 1061753740,
 -1,
 -49322,
 1062475988,
 83436,
 -49321,
 1062541347,
 83435,
 -49320,
 1062606659,
 83434,
 -49319,
 1062671987,
 83433,
 -49318,
 1062737278,
 83432,
 -49317,
 1062802602,
 83431,
 -49316,
 1062867852,
 83430,
 -49315,
 1062933095,
 83429,
 -49314,
 1062998332,
 83428,
 -1,
 1063063596,
 83427,
 1063272298,
 1062474343,
 -1,
 -49311,
 1063196884,
 83426,
 -49310,
 1063262243,
 83425,
 -49309,
 1063327555,
 83424,
 -49308,
 1063392883,
 83423,
 -49307,
 1063458174,
 83422,
 -49306,
 1063523498,
 83421,
 -49305,
 1063588748,
 83420,
 -49304,
 1063653991,
 83419,
 -49303,
 1063719228,
 83418,
 -1,
 1063784492,
 83417,
 1063993205,
 1063194668,
 -1,
 -49300,
 1063917780,
 83405,
 -49299,
 1063983139,
 83404,
 -49298,
 1064048451,
 83403,
 -49297,
 1064113779,
 83402,
 -49296,
 1064179070,
 83401,
 -49295,
 1064244394,
 83400,
 -49294,
 1064309644,
 83399,
 -49293,
 1064374887,
 83398,
 -49292,
 1064440124,
 83397,
 -1,
 1064505388,
 83396,
 1064763391,
 1063917780,
 -1,
 -49289,
 1064638275,
 83496,
 -49288,
 1064703603,
 83495,
 -49287,
 1064768894,
 83494,
 -49286,
 1064834218,
 83493,
 -49285,
 1064899468,
 83492,
 -49284,
 1064964711,
 83491,
 -49283,
 1065029948,
 83490,
 -1,
 1065095212,
 83489,
 1065353215,
 1057822078,
 -1,
 1065369482,
 1065226855,
 -1,
 -49279,
 1065294036,
 83525,
 -49278,
 1065359395,
 83524,
 -49277,
 1065424707,
 83523,
 -49276,
 1065490035,
 83522,
 -49275,
 1065555326,
 83521,
 -49274,
 1065620650,
 83520,
 -49273,
 1065685900,
 83519,
 -49272,
 1065751143,
 83518,
 -49271,
 1065816380,
 83517,
 -1,
 1065881644,
 83516,
 1066090389,
 1065292092,
 -1,
 -49268,
 1066014932,
 83515,
 -49267,
 1066080291,
 83514,
 -49266,
 1066145603,
 83513,
 -49265,
 1066210931,
 83512,
 -49264,
 1066276222,
 83511,
 -49263,
 1066341546,
 83510,
 -49262,
 1066406796,
 83509,
 -49261,
 1066472039,
 83508,
 -49260,
 1066537276,
 83507,
 -1,
 1066602540,
 83506,
 1066811295,
 1066012716,
 -1,
 -49257,
 1066735828,
 83505,
 -49256,
 1066801187,
 83504,
 -49255,
 1066866499,
 83503,
 -49254,
 1066931827,
 83502,
 -49253,
 1066997118,
 83501,
 -49252,
 1067062442,
 83500,
 -49251,
 1067127692,
 83499,
 -49250,
 1067192935,
 83498,
 -1,
 1067258172,
 83497,
 -1,
 1066734727,
 83526,
 1067532202,
 1025165217,
 128028,
 1067597737,
 1067476241,
 -1,
 1067663272,
 1067569201,
 -1,
 -49244,
 1067634391,
 11151,
 -49243,
 1067693134,
 11148,
 -49242,
 1067752199,
 11119,
 -49241,
 1067809686,
 11150,
 -1,
 1067854896,
 11149,
 -1,
 1067598012,
 128260,
 -1,
 1067534516,
 128246,
 1068187566,
 1067472072,
 -1,
 -49236,
 1068160583,
 128551,
 -49235,
 1068218843,
 128544,
 -1,
 1068255805,
 128162,
 -1,
 1068118399,
 9875,
 1068515736,
 1025092806,
 -1,
 1068581264,
 1068440281,
 -1,
 1068646794,
 1068498944,
 -1,
 1068712049,
 1068598217,
 -1,
 1068777582,
 1068682021,
 -1,
 1068842973,
 1068710157,
 -1,
 1068908506,
 1068798999,
 -1,
 1068974037,
 1068881233,
 -1,
 1069039549,
 1068943265,
 -1,
 1069105083,
 1068980747,
 -1,
 -49222,
 1069041203,
 126646,
 -1,
 1069096599,
 126648,
 -49220,
 1069041203,
 126645,
 -1,
 1069227359,
 126632,
 1069432769,
 1069005313,
 -1,
 -49217,
 1069374853,
 126644,
 -49216,
 1069434198,
 126638,
 -1,
 1069489123,
 126641,
 1069694916,
 1069411422,
 -1,
 -49213,
 1069639854,
 126630,
 -1,
 1069701643,
 126650,
 1069891527,
 1069627804,
 -1,
 -49210,
 1069840143,
 126627,
 -1,
 1069889805,
 126649,
 -49208,
 1069869632,
 126633,
 -49207,
 1070064097,
 126629,
 -49206,
 1070117145,
 126643,
 -49205,
 1070181160,
 126642,
 -49204,
 1070240077,
 126637,
 -49203,
 1070303026,
 126636,
 -49202,
 1070364733,
 126635,
 -49201,
 1070429489,
 126647,
 -49200,
 1070494312,
 126626,
 -49199,
 1070553684,
 126631,
 -49198,
 1070618445,
 126651,
 -49197,
 1070681975,
 126640,
 -49196,
 1070737711,
 126625,
 -1,
 1070800324,
 126639,
 1071054847,
 1068944953,
 -1,
 -49193,
 1070967592,
 126495,
 -49192,
 1071026509,
 126493,
 -49191,
 1071075191,
 126494,
 -1,
 1071130927,
 126492,
 1071382527,
 1068833158,
 -1,
 -49188,
 1071281935,
 126467,
 -1,
 1071331597,
 126489,
 1071529986,
 1068791567,
 -1,
 1071595521,
 1071487635,
 -1,
 1071661029,
 1071564705,
 -1,
 1071726563,
 1071602187,
 -1,
 -49182,
 1071662643,
 126614,
 -1,
 1071718039,
 126616,
 -49180,
 1071662643,
 126613,
 -1,
 1071848799,
 126600,
 1072054249,
 1071626753,
 -1,
 -49177,
 1071996293,
 126612,
 -49176,
 1072055638,
 126606,
 -1,
 1072110563,
 126609,
 1072316396,
 1072032862,
 -1,
 -49173,
 1072261294,
 126598,
 -1,
 1072323083,
 126618,
 1072513007,
 1072257547,
 -1,
 -49170,
 1072449075,
 126596,
 -1,
 1072504159,
 126599,
 1072709618,
 1072445852,
 -1,
 -49167,
 1072658191,
 126595,
 -1,
 1072707853,
 126617,
 1072906229,
 1072634246,
 -1,
 -49164,
 1072855744,
 126592,
 -1,
 1072916654,
 126607,
 -49162,
 1072884288,
 126601,
 -49161,
 1073078753,
 126597,
 -49160,
 1073131801,
 126611,
 -49159,
 1073195816,
 126610,
 -49158,
 1073254733,
 126605,
 -49157,
 1073317682,
 126604,
 -49156,
 1073379389,
 126603,
 -49155,
 1073444145,
 126615,
 -49154,
 1073508968,
 126594,
 -49153,
 1073567565,
 126619,
 -49152,
 1073631095,
 126608,
 -1,
 1073686831,
 126593,
 -1,
 1071521790,
 126475,
 1073954852,
 1071495681,
 -1,
 1074020385,
 1073926096,
 -1,
 1074085896,
 1073989537,
 -1,
 -49146,
 1074027914,
 126582,
 -49145,
 1074087475,
 126581,
 -1,
 1074142559,
 126568,
 1074348044,
 1074051585,
 -1,
 -49142,
 1074290053,
 126580,
 -49141,
 1074349398,
 126574,
 -1,
 1074404323,
 126577,
 1074610193,
 1074280717,
 -1,
 1074675728,
 1074568727,
 -1,
 -49137,
 1074614135,
 126590,
 -1,
 1074669871,
 126588,
 -1,
 1074600931,
 126585,
 1074937876,
 1074557753,
 -1,
 -49133,
 1074879060,
 126583,
 -1,
 1074928837,
 126570,
 1075134487,
 1074878987,
 -1,
 -49130,
 1075070515,
 126564,
 -1,
 1075125599,
 126567,
 -49128,
 1075113057,
 126586,
 -49127,
 1075309120,
 126569,
 -49126,
 1075358504,
 126578,
 -49125,
 1075417421,
 126573,
 -49124,
 1075480370,
 126572,
 -49123,
 1075540584,
 126562,
 -49122,
 1075599181,
 126587,
 -49121,
 1075662711,
 126576,
 -49120,
 1075718447,
 126561,
 -1,
 1075781060,
 126575,
 -49118,
 1073962373,
 126484,
 -49117,
 1075922262,
 126478,
 -1,
 1075977187,
 126481,
 1076183101,
 1073900493,
 -1,
 1076248617,
 1076148737,
 -1,
 -49113,
 1076190597,
 126516,
 -49112,
 1076249942,
 126510,
 -1,
 1076304867,
 126513,
 1076510764,
 1076217761,
 -1,
 -49109,
 1076452746,
 126518,
 -1,
 1076512307,
 126517,
 1076707375,
 1076458297,
 -1,
 -49106,
 1076648532,
 126519,
 -1,
 1076698309,
 126506,
 1076903986,
 1076648459,
 -1,
 -49103,
 1076839987,
 126500,
 -1,
 1076895071,
 126503,
 -49101,
 1076881984,
 126505,
 -49100,
 1077062440,
 126514,
 -49099,
 1077121357,
 126509,
 -49098,
 1077184306,
 126508,
 -49097,
 1077246013,
 126507,
 -49096,
 1077310056,
 126498,
 -49095,
 1077368653,
 126523,
 -49094,
 1077432183,
 126512,
 -49093,
 1077492169,
 126521,
 -49092,
 1077553455,
 126497,
 -1,
 1077616068,
 126511,
 1077821527,
 1076152225,
 -1,
 1077887059,
 1077746054,
 -1,
 1077952594,
 1077831719,
 -1,
 1078018116,
 1077918209,
 -1,
 -49086,
 1077960069,
 126548,
 -49085,
 1078019414,
 126542,
 -1,
 1078074339,
 126545,
 1078280265,
 1077950733,
 -1,
 1078345800,
 1078238743,
 -1,
 -49081,
 1078307624,
 126559,
 -1,
 1078366541,
 126557,
 -1,
 1078270947,
 126553,
 -49078,
 1078258240,
 126537,
 -49077,
 1078569768,
 126546,
 -49076,
 1078628685,
 126541,
 -49075,
 1078687805,
 126539,
 -49074,
 1078752561,
 126551,
 -49073,
 1078817384,
 126530,
 -49072,
 1078876756,
 126535,
 -49071,
 1078941517,
 126555,
 -1,
 1078992324,
 126543,
 -1,
 1077893643,
 126472,
 1079263318,
 1077828107,
 -1,
 -49067,
 1079199283,
 126486,
 -1,
 1079254679,
 126488,
 -1,
 1079199283,
 126485,
 1079525466,
 1077800030,
 -1,
 -49063,
 1079470254,
 126470,
 -1,
 1079532043,
 126490,
 1079722077,
 1079483247,
 -1,
 -49060,
 1079674690,
 126704,
 -1,
 1079728728,
 126705,
 1079918688,
 1079669561,
 -1,
 -49057,
 1079859796,
 126487,
 -1,
 1079909573,
 126474,
 1080115299,
 1079843206,
 -1,
 -49054,
 1080064704,
 126464,
 -1,
 1080125614,
 126479,
 -49052,
 1080093248,
 126473,
 -49051,
 1080287713,
 126469,
 -49050,
 1080340761,
 126483,
 -49049,
 1080404776,
 126482,
 -49048,
 1080463693,
 126477,
 -49047,
 1080526642,
 126476,
 -49046,
 1080586856,
 126466,
 -49045,
 1080646228,
 126471,
 -49044,
 1080710989,
 126491,
 -49043,
 1080774519,
 126480,
 -1,
 1080830255,
 126465,
 1081081855,
 1068742434,
 -1,
 -49040,
 1080999832,
 2303,
 -1,
 1081053533,
 1624,
 1081229569,
 1068660495,
 -1,
 1081295104,
 1081164286,
 -1,
 1081360637,
 1081266540,
 -1,
 1081426050,
 1081289011,
 -1,
 1081491579,
 1081395105,
 -1,
 1081557114,
 1081434642,
 -1,
 1081622649,
 1081518173,
 1874,
 -1,
 1081540788,
 1875,
 -1,
 1081565486,
 1872,
 -1,
 1081534044,
 1876,
 1081884799,
 1081458960,
 -1,
 1081950334,
 1081858992,
 1878,
 -1,
 1081868648,
 2208,
 -1,
 1081902903,
 2230,
 -49024,
 1081830817,
 1877,
 -49023,
 1082088266,
 2209,
 -1,
 1082146195,
 1873,
 1082343570,
 1081364113,
 -1,
 1082409101,
 1082270822,
 -1,
 1082474633,
 1082346943,
 -1,
 1082540168,
 1082443681,
 -1,
 -49017,
 1082517021,
 1909,
 -1,
 1082548715,
 1910,
 -1,
 1082479340,
 1911,
 1082802316,
 1082443681,
 -1,
 -49013,
 1082779200,
 1598,
 -1,
 1082810909,
 1599,
 -1,
 1082748344,
 1597,
 1083113471,
 1082345014,
 -1,
 1083130001,
 1083033505,
 -1,
 -49008,
 1083106894,
 1888,
 -1,
 1083138621,
 1889,
 -1,
 1083063699,
 2212,
 1083392161,
 1082268038,
 -1,
 1083457690,
 1083336927,
 -1,
 1083523223,
 1083434551,
 -1,
 -49002,
 1083498033,
 1887,
 -1,
 1083513566,
 1885,
 1083768831,
 1083466258,
 -1,
 -48999,
 1083680810,
 1886,
 -1,
 1083713866,
 2227,
 1083916446,
 1083397124,
 -1,
 -48996,
 1083878184,
 2236,
 -48995,
 1083937101,
 2237,
 -1,
 1083985783,
 2235,
 1084227583,
 1083865796,
 -1,
 -48992,
 1084155421,
 1907,
 -1,
 1084187115,
 1908,
 1084375213,
 1083354310,
 -1,
 1084440748,
 1084311094,
 -1,
 1084506280,
 1084406273,
 -1,
 1084571815,
 1084458153,
 -1,
 -48986,
 1084526930,
 2233,
 -1,
 1084564152,
 1905,
 -1,
 1084543218,
 1883,
 -48983,
 1084478231,
 1899,
 -48982,
 1084784944,
 2218,
 -48981,
 1084845496,
 1775,
 -1,
 1084906314,
 1900,
 -1,
 1084397051,
 2220,
 1085161659,
 1084322617,
 -1,
 1085227190,
 1085097578,
 -1,
 1085292725,
 1085196193,
 -1,
 1085358260,
 1085235730,
 -1,
 -48974,
 1085319261,
 1892,
 -48973,
 1085352266,
 1596,
 -1,
 1085414110,
 1891,
 -1,
 1085335104,
 1595,
 -1,
 1085226332,
 1890,
 1085800447,
 1085151622,
 -1,
 1085817018,
 1085689538,
 -1,
 -48967,
 1085788887,
 1919,
 -1,
 1085816201,
 2228,
 -1,
 1085783744,
 1568,
 1086079172,
 1085127169,
 -1,
 1086144706,
 1086014810,
 -1,
 -48962,
 1086116631,
 1901,
 -48961,
 1086177584,
 1904,
 -48960,
 1086221752,
 1918,
 -48959,
 1086280483,
 1884,
 -1,
 1086344668,
 1917,
 -48957,
 1086115689,
 2225,
 -1,
 1086462958,
 2223,
 1086669008,
 1086020107,
 -1,
 1086734543,
 1086594402,
 -1,
 1086800075,
 1086701847,
 -1,
 1086865610,
 1086724486,
 -1,
 -48951,
 1086819729,
 1903,
 -1,
 1086860366,
 1906,
 -1,
 1086794058,
 1902,
 1087127758,
 1086769057,
 -1,
 -48947,
 1087104576,
 1879,
 -1,
 1087136317,
 1880,
 -1,
 1087065603,
 1916,
 -1,
 1086670399,
 1791,
 1087455448,
 1086646852,
 -1,
 1087520981,
 1087432024,
 -1,
 -48941,
 1087488441,
 2234,
 -48940,
 1087527754,
 2216,
 -1,
 1087585628,
 2217,
 1087832063,
 1087449226,
 -1,
 -48937,
 1087759901,
 1914,
 -1,
 1087791595,
 1915,
 1087979743,
 1087406963,
 -1,
 1088045278,
 1087915340,
 -1,
 1088110813,
 1087978839,
 -1,
 -48932,
 1088039242,
 1894,
 -1,
 1088101086,
 1893,
 -1,
 1088080878,
 2215,
 -1,
 1087972184,
 1564,
 1088438502,
 1087912414,
 -1,
 1088504035,
 1088407457,
 -1,
 -48926,
 1088480888,
 1881,
 -1,
 1088512557,
 2222,
 1088749567,
 1088449788,
 -1,
 -48923,
 1088674736,
 1774,
 -1,
 1088733710,
 1882,
 1088897259,
 1088414181,
 -1,
 1088962794,
 1088835114,
 -1,
 -48919,
 1088939549,
 1912,
 -1,
 1088971243,
 1913,
 -1,
 1088896489,
 2219,
 1089224944,
 1088852329,
 -1,
 1089290479,
 1089192208,
 -1,
 -48914,
 1089264560,
 1897,
 -1,
 1089325186,
 1896,
 -1,
 1089262310,
 1895,
 1089552629,
 1089173263,
 -1,
 1089618164,
 1089478657,
 -1,
 -48909,
 1089552041,
 2214,
 -1,
 1089611828,
 1898,
 -1,
 1089577438,
 2221,
 1089880312,
 1089521569,
 -1,
 -48905,
 1089816146,
 2232,
 -1,
 1089871211,
 2211,
 -48903,
 1089858670,
 2226,
 -48902,
 1090038572,
 2213,
 -48901,
 1090102543,
 2231,
 -48900,
 1090155117,
 2210,
 -1,
 1090213201,
 2224,
 1090453503,
 1081300071,
 -1,
 -48897,
 1090333002,
 2297,
 -1,
 1090394846,
 2295,
 -1,
 1081239128,
 65021,
 1090666834,
 1081195009,
 -1,
 1090732319,
 1090618537,
 -1,
 1090797849,
 1090674370,
 -1,
 1090863375,
 1090773179,
 -1,
 1090928910,
 1090821216,
 -1,
 1090994443,
 1090853254,
 -1,
 -48888,
 1090964166,
 2266,
 -48887,
 1091025602,
 2267,
 -48886,
 1091087646,
 2260,
 -1,
 1091144784,
 2268,
 -48884,
 1090969936,
 2271,
 -48883,
 1091287817,
 2269,
 -1,
 1091349336,
 2270,
 -1,
 1090856701,
 2291,
 1091584274,
 1090828801,
 -1,
 -48879,
 1091528610,
 2273,
 -1,
 1091574755,
 2261,
 -48877,
 1091562601,
 1559,
 -48876,
 1091750018,
 1557,
 -48875,
 1091808040,
 2263,
 -48874,
 1091866996,
 2264,
 -48873,
 1091927642,
 1558,
 -48872,
 1091981897,
 2272,
 -1,
 1092033988,
 2262,
 1092239644,
 1090748825,
 -1,
 -48869,
 1092215265,
 2259,
 -1,
 1092260212,
 2265,
 -48867,
 1092187205,
 1562,
 -48866,
 1092374325,
 1560,
 -1,
 1092434433,
 1561,
 1092632889,
 1090710352,
 -1,
 1092698413,
 1092601761,
 -1,
 1092763943,
 1092675127,
 -1,
 1092829477,
 1092738597,
 -1,
 -48860,
 1092757834,
 64446,
 -1,
 1092819678,
 64445,
 -48858,
 1092757834,
 64437,
 -1,
 1092950750,
 64436,
 1093206015,
 1092706834,
 -1,
 1093222699,
 1093117974,
 -1,
 -48854,
 1093151050,
 64441,
 -1,
 1093212894,
 64440,
 -48852,
 1093151050,
 64439,
 -1,
 1093343966,
 64438,
 1093550386,
 1092631826,
 -1,
 1093615921,
 1093519267,
 -1,
 -48848,
 1093544266,
 64435,
 -1,
 1093606110,
 64434,
 -1,
 1093588281,
 64444,
 1093878069,
 1093517800,
 -1,
 -48844,
 1093806410,
 64449,
 -1,
 1093868254,
 64448,
 1094074680,
 1093817112,
 -1,
 -48841,
 1094003018,
 64443,
 -1,
 1094064862,
 64442,
 -1,
 1094038906,
 64447,
 1094336837,
 1092577145,
 -1,
 1094402367,
 1094302422,
 -1,
 -48836,
 1094356152,
 1537,
 -48835,
 1094421511,
 1540,
 -48834,
 1094483967,
 1552,
 -1,
 1094537215,
 1539,
 1094730050,
 1094364480,
 -1,
 -48831,
 1094672391,
 1554,
 -1,
 1094728646,
 1555,
 -48829,
 1094699198,
 1556,
 -48828,
 1094879663,
 1551,
 -1,
 1094917836,
 1553,
 1095123281,
 1094273490,
 -1,
 1095188816,
 1095101001,
 -1,
 1095254347,
 1095113094,
 -1,
 1095319882,
 1095203520,
 983633,
 -1,
 1095238792,
 983635,
 -1,
 1095254526,
 983640,
 -48820,
 1095232544,
 983638,
 -48819,
 1095492065,
 983634,
 -48818,
 1095553946,
 983637,
 -48817,
 1095603539,
 983636,
 -1,
 1095647742,
 983639,
 -1,
 1095143812,
 983641,
 -1,
 1095095646,
 1622,
 1095975263,
 1090635681,
 -1,
 1096040797,
 1095931993,
 -1,
 1096106327,
 1096012493,
 -1,
 -48810,
 1096034634,
 2286,
 -1,
 1096096478,
 2283,
 1096302938,
 1096063080,
 -1,
 -48807,
 1096231242,
 2285,
 -1,
 1096293086,
 2282,
 1096548351,
 1096253749,
 -1,
 -48804,
 1096427850,
 2287,
 -1,
 1096489694,
 2284,
 -48802,
 1096014390,
 2275,
 -1,
 1096660586,
 1566,
 1096827238,
 1095907473,
 -1,
 1096892770,
 1096774725,
 2278,
 -1,
 1096861964,
 2281,
 1097023844,
 1096830773,
 2276,
 -1,
 1096993036,
 2279,
 1097203711,
 1096956417,
 2277,
 -1,
 1097124108,
 2280,
 1097285997,
 1096789190,
 -1,
 1097351531,
 1097230051,
 -1,
 1097417066,
 1097276126,
 2296,
 -1,
 1097337895,
 2301,
 -1,
 1097345354,
 2298,
 -48788,
 1097288988,
 1629,
 -1,
 1097541408,
 1544,
 1097744756,
 1097218317,
 -1,
 1097810288,
 1097703058,
 2299,
 -1,
 1097731111,
 2300,
 1097941363,
 1097734534,
 -1,
 -48782,
 1097910659,
 1549,
 -1,
 1097959878,
 2302,
 -1,
 1097887644,
 2274,
 1098203514,
 1097682577,
 -1,
 1098269049,
 1098130868,
 -1,
 -48777,
 1098240708,
 1630,
 -48776,
 1098298746,
 2292,
 -1,
 1098333532,
 2293,
 -1,
 1098226357,
 1538,
 1098596734,
 1098178614,
 -1,
 -48772,
 1098564096,
 1626,
 -48771,
 1098608010,
 1627,
 -1,
 1098661257,
 1628,
 1098858882,
 1098554113,
 -1,
 -48768,
 1098806368,
 2290,
 -48767,
 1098862395,
 2288,
 -1,
 1098922503,
 2289,
 1099121029,
 1098814285,
 -1,
 -48764,
 1099087796,
 1536,
 -1,
 1099138430,
 1541,
 -48762,
 1099099599,
 1625,
 -48761,
 1099293136,
 1631,
 -48760,
 1099343801,
 1550,
 -48759,
 1099396171,
 2294,
 -1,
 1099459903,
 1623,
 1099694079,
 1068568349,
 -1,
 1099710862,
 1099605426,
 -1,
 -48755,
 1099680273,
 1546,
 -1,
 1099729165,
 1545,
 -48753,
 1099649960,
 1543,
 -1,
 1099839541,
 1542,
 1100038549,
 1068533658,
 -1,
 1100104084,
 1100005774,
 -1,
 -48749,
 1100081852,
 1416,
 -1,
 1100141052,
 1376,
 -1,
 1100038456,
 1423,
 1100414975,
 1100008605,
 -1,
 -48745,
 1100334156,
 127912,
 -1,
 1100363853,
 128667,
 1100563011,
 1068463887,
 -1,
 1100628540,
 1100493051,
 -1,
 1100693939,
 1100593665,
 -1,
 1100759461,
 1100665754,
 -1,
 1100824996,
 1100688228,
 -1,
 1100890531,
 1100759672,
 -1,
 1100956065,
 1100856114,
 -1,
 -48736,
 1100887552,
 128807,
 -1,
 1100947987,
 128814,
 -48734,
 1100887552,
 128802,
 -1,
 1101079059,
 128812,
 -1,
 1100836301,
 128862,
 -1,
 1100774901,
 128781,
 1101414827,
 1100684951,
 -1,
 1101480362,
 1101383585,
 128788,
 1101594623,
 1101399301,
 -1,
 -48727,
 1101477383,
 128806,
 -1,
 1101537811,
 128813,
 -1,
 1101401782,
 128825,
 1101808047,
 1101383585,
 -1,
 1101873582,
 1101770456,
 128860,
 -1,
 1101794986,
 128861,
 -1,
 1101800436,
 128850,
 -48720,
 1101768364,
 128839,
 -48719,
 1102025828,
 128852,
 -48718,
 1102080062,
 128795,
 -1,
 1102131205,
 128847,
 1102332358,
 1100618118,
 -1,
 1102397883,
 1102293882,
 -1,
 1102463418,
 1102315520,
 -1,
 1102528952,
 1102438200,
 128776,
 -1,
 1102450346,
 128777,
 1102708735,
 1102491923,
 128774,
 -1,
 1102581418,
 128775,
 -1,
 1102402201,
 128773,
 1102856640,
 1102345999,
 -1,
 1102922174,
 1102803956,
 128822,
 -1,
 1102843562,
 128823,
 -48705,
 1102894777,
 128837,
 -1,
 1102989197,
 128874,
 -48703,
 1102830095,
 128829,
 -48702,
 1103150691,
 128855,
 -48701,
 1103214840,
 128826,
 -48700,
 1103270651,
 128811,
 -48699,
 1103332509,
 128859,
 -1,
 1103392307,
 128769,
 1103577562,
 1102261667,
 -1,
 1103643090,
 1103539398,
 -1,
 1103708622,
 1103615406,
 128869,
 1103822847,
 1103629989,
 -1,
 -48693,
 1103697278,
 128873,
 -48692,
 1103762602,
 128872,
 -48691,
 1103827852,
 128871,
 -1,
 1103893095,
 128870,
 1104150527,
 1103664392,
 -1,
 1104167377,
 1104033280,
 128803,
 -1,
 1104088746,
 128804,
 -1,
 1104113393,
 128798,
 1104363990,
 1103567238,
 -1,
 -48684,
 1104325338,
 128846,
 -48683,
 1104380776,
 128844,
 -1,
 1104429443,
 128848,
 1104626137,
 1104321447,
 -1,
 -48680,
 1104583810,
 128800,
 -1,
 1104617991,
 128805,
 -1,
 1104571417,
 128787,
 1104888298,
 1103539398,
 -1,
 1104953832,
 1104822782,
 -1,
 1105019365,
 1104894382,
 128818,
 1105084897,
 1104940709,
 -1,
 -48673,
 1105007786,
 128821,
 -48672,
 1105073036,
 128820,
 -1,
 1105138279,
 128819,
 1105395711,
 1105003781,
 -1,
 1105412580,
 1105273363,
 128816,
 -1,
 1105333930,
 128817,
 -1,
 1105358577,
 128799,
 1105609191,
 1104944940,
 128827,
 -1,
 1105530538,
 128828,
 -1,
 1105579791,
 128877,
 1105854463,
 1104909540,
 128792,
 -1,
 1105727146,
 128793,
 1105936885,
 1104815967,
 -1,
 1106002415,
 1105894479,
 128834,
 1106116607,
 1105923749,
 -1,
 -48658,
 1105990540,
 128836,
 -1,
 1106055783,
 128835,
 1106264562,
 1105929644,
 -1,
 -48655,
 1106238448,
 128876,
 -1,
 1106281978,
 128875,
 -48653,
 1106227995,
 128857,
 -48652,
 1106409378,
 128783,
 -1,
 1106472824,
 128830,
 1106657791,
 1105910704,
 -1,
 1106723326,
 1106600877,
 -1,
 1106788860,
 1106677353,
 128778,
 1106854395,
 1106710181,
 -1,
 -48646,
 1106776972,
 128780,
 -1,
 1106842215,
 128779,
 -1,
 1106773258,
 128815,
 1107165183,
 1106759840,
 128790,
 -1,
 1107037866,
 128791,
 -1,
 1106659941,
 128808,
 1107313161,
 1106617007,
 -1,
 1107378692,
 1107268631,
 -1,
 1107444227,
 1107354141,
 128843,
 -1,
 1107379282,
 128858,
 -1,
 1107412913,
 128856,
 1107640839,
 1107350426,
 -1,
 -48634,
 1107611578,
 128868,
 -1,
 1107669856,
 128867,
 -48632,
 1107603512,
 128863,
 -1,
 1107779367,
 128782,
 1107968529,
 1107281825,
 -1,
 1108034061,
 1107912878,
 -1,
 -48628,
 1107965994,
 128840,
 -1,
 1108018547,
 128809,
 1108230671,
 1107960953,
 128831,
 -1,
 1108151978,
 128832,
 -48624,
 1108204425,
 128845,
 -1,
 1108325152,
 128849,
 1108492824,
 1107919731,
 -1,
 1108558358,
 1108429396,
 128784,
 1108672511,
 1108479653,
 -1,
 -48619,
 1108546444,
 128786,
 -1,
 1108611687,
 128785,
 -48617,
 1108515367,
 128881,
 -1,
 1108746977,
 128824,
 1108951583,
 1108433419,
 -1,
 1109017116,
 1108907031,
 -1,
 -48613,
 1108990396,
 128878,
 -1,
 1109047535,
 128854,
 1109262335,
 1108942613,
 -1,
 -48610,
 1109171937,
 128883,
 -1,
 1109213491,
 128882,
 1109410341,
 1108883725,
 -1,
 1109475876,
 1109356328,
 -1,
 1109541411,
 1109443245,
 128865,
 -1,
 1109462698,
 128866,
 -1,
 1109511504,
 128864,
 -1,
 1109403435,
 128880,
 1109803561,
 1109356273,
 -1,
 1109869096,
 1109722483,
 128796,
 -1,
 1109790378,
 128797,
 -1,
 1109790416,
 128801,
 1110065708,
 1109778683,
 -1,
 -48597,
 1110042643,
 128842,
 -1,
 1110100544,
 128772,
 1110262319,
 1110027412,
 -1,
 -48594,
 1110217447,
 128768,
 -1,
 1110258443,
 128833,
 1110458930,
 1110216701,
 -1,
 -48591,
 1110429607,
 128789,
 -1,
 1110464393,
 128879,
 1110655541,
 1110406927,
 -1,
 -48588,
 1110611243,
 128851,
 -1,
 1110655808,
 128810,
 1110852152,
 1110594760,
 -1,
 -48585,
 1110824633,
 128841,
 -1,
 1110873737,
 128794,
 -48583,
 1110825481,
 128853,
 -48582,
 1111004682,
 128838,
 -48581,
 1111052523,
 128770,
 -1,
 1111114619,
 128771,
 1111310911,
 1100562942,
 -1,
 -48578,
 1111275787,
 983054,
 -1,
 1111328309,
 9879,
 -48576,
 1111280255,
 9941,
 -48575,
 1111458675,
 983201,
 -48574,
 1111516604,
 128126,
 -1,
 1111565229,
 9200,
 1111769786,
 1100495117,
 -1,
 1111835317,
 1111717953,
 -1,
 1111900785,
 1111764387,
 -1,
 1111966320,
 1111827045,
 -1,
 1112031819,
 1111919660,
 -1,
 -48567,
 1112009119,
 125209,
 -48566,
 1112069907,
 125200,
 -1,
 1112103453,
 125211,
 1112293967,
 1111978809,
 -1,
 -48563,
 1112254390,
 125216,
 -48562,
 1112300061,
 125213,
 -1,
 1112349893,
 125201,
 1112556114,
 1112271140,
 -1,
 -48559,
 1112497306,
 125198,
 -1,
 1112545670,
 125202,
 1112752725,
 1112521217,
 -1,
 -48556,
 1112697889,
 125189,
 -1,
 1112758813,
 125217,
 1112949336,
 1112691912,
 -1,
 -48553,
 1112877317,
 125214,
 -1,
 1112938886,
 125208,
 1113145947,
 1112881421,
 -1,
 -48550,
 1113086493,
 125197,
 -1,
 1113135703,
 125185,
 1113342558,
 1113073503,
 -1,
 -48547,
 1113283738,
 125191,
 -1,
 1113332102,
 125188,
 -48545,
 1113320600,
 125215,
 -48544,
 1113514465,
 125199,
 -48543,
 1113578435,
 125212,
 -48542,
 1113641882,
 125203,
 -48541,
 1113706883,
 125210,
 -48540,
 1113763136,
 125192,
 -48539,
 1113828131,
 125207,
 -48538,
 1113892047,
 125190,
 -48537,
 1113953303,
 125196,
 -48536,
 1114015968,
 125187,
 -48535,
 1114077033,
 125186,
 -48534,
 1114141370,
 125204,
 -48533,
 1114203053,
 125195,
 -48532,
 1114266141,
 125206,
 -48531,
 1114328806,
 125194,
 -48530,
 1114391038,
 125193,
 -48529,
 1114452265,
 125205,
 -1,
 1114513202,
 125184,
 -1,
 1111923214,
 125256,
 1114784411,
 1111867790,
 -1,
 1114849910,
 1114737708,
 -1,
 -48524,
 1114827167,
 125243,
 -48523,
 1114887955,
 125234,
 -1,
 1114921501,
 125245,
 1115112058,
 1114796857,
 -1,
 -48520,
 1115072438,
 125250,
 -48519,
 1115118109,
 125247,
 -1,
 1115167941,
 125235,
 1115374205,
 1115089188,
 -1,
 -48516,
 1115315354,
 125232,
 -1,
 1115363718,
 125236,
 1115570816,
 1115339265,
 -1,
 -48513,
 1115515937,
 125223,
 -1,
 1115576861,
 125251,
 1115767427,
 1115509960,
 -1,
 -48510,
 1115695365,
 125248,
 -1,
 1115756934,
 125242,
 1115964038,
 1115699469,
 -1,
 -48507,
 1115904541,
 125231,
 -1,
 1115953751,
 125219,
 1116160649,
 1115891551,
 -1,
 -48504,
 1116101786,
 125225,
 -1,
 1116150150,
 125222,
 -48502,
 1116138648,
 125249,
 -48501,
 1116332513,
 125233,
 -48500,
 1116396483,
 125246,
 -48499,
 1116459930,
 125237,
 -48498,
 1116524931,
 125244,
 -48497,
 1116581184,
 125226,
 -48496,
 1116646179,
 125241,
 -48495,
 1116710095,
 125224,
 -48494,
 1116771351,
 125230,
 -48493,
 1116834016,
 125221,
 -48492,
 1116895081,
 125220,
 -48491,
 1116959418,
 125238,
 -48490,
 1117021101,
 125229,
 -48489,
 1117084189,
 125240,
 -48488,
 1117146854,
 125228,
 -48487,
 1117209086,
 125227,
 -48486,
 1117270313,
 125239,
 -1,
 1117331250,
 125218,
 1117536937,
 1114717283,
 -1,
 1117602463,
 1117505441,
 -1,
 -48482,
 1117578774,
 125266,
 -1,
 1117610464,
 125267,
 1117799074,
 1117567489,
 -1,
 -48479,
 1117745520,
 125270,
 -1,
 1117801621,
 125271,
 1117995685,
 1117736593,
 -1,
 -48476,
 1117953789,
 125268,
 -1,
 1118007486,
 125269,
 -48474,
 1117973787,
 125264,
 -48473,
 1118148693,
 125265,
 -48472,
 1118212168,
 125273,
 -1,
 1118258822,
 125272,
 1118454444,
 1117490220,
 -1,
 -48469,
 1118426725,
 125258,
 -1,
 1118446792,
 125259,
 1118651055,
 1118399437,
 -1,
 -48466,
 1118612587,
 125279,
 -1,
 1118653818,
 125278,
 1118847666,
 1118590623,
 -1,
 -48463,
 1118793169,
 125254,
 -1,
 1118847540,
 125257,
 -48461,
 1118822421,
 125253,
 -48460,
 1118985028,
 125255,
 -1,
 1119035191,
 125252,
 1119240888,
 1111786355,
 -1,
 -48457,
 1119186871,
 127903,
 -1,
 1119243174,
 11237,
 -48455,
 1119213223,
 129489,
 -1,
 1119378918,
 129657,
 1119568650,
 1111711858,
 -1,
 1119634144,
 1119518038,
 -1,
 1119699649,
 1119558022,
 71442,
 1119813631,
 1119650504,
 -1,
 -48449,
 1119733799,
 71429,
 -48448,
 1119769879,
 71446,
 -1,
 1119823760,
 71450,
 1120027333,
 1119652908,
 -1,
 -48445,
 1120004511,
 71440,
 -48444,
 1120032023,
 71426,
 -1,
 1120082310,
 71427,
 1120289480,
 1119995809,
 -1,
 -48441,
 1120229917,
 71436,
 -1,
 1120278918,
 71428,
 1120486091,
 1120248495,
 -1,
 -48438,
 1120426525,
 71431,
 -1,
 1120475526,
 71430,
 1120682702,
 1120432953,
 -1,
 -48435,
 1120623133,
 71425,
 -1,
 1120672134,
 71424,
 1120879313,
 1120629261,
 -1,
 -48432,
 1120819741,
 71449,
 -1,
 1120868742,
 71434,
 1121075924,
 1120818376,
 -1,
 -48429,
 1121016349,
 71447,
 -1,
 1121065350,
 71445,
 1121272535,
 1121007885,
 -1,
 -48426,
 1121212957,
 71444,
 -1,
 1121261958,
 71443,
 1121469146,
 1121199967,
 -1,
 -48423,
 1121409565,
 71448,
 -1,
 1121458566,
 71432,
 -48421,
 1121434326,
 71439,
 -48420,
 1121627456,
 71437,
 -48419,
 1121682377,
 71433,
 -48418,
 1121744729,
 71438,
 -48417,
 1121802781,
 71441,
 -1,
 1121857647,
 71435,
 1122058988,
 1119608886,
 -1,
 1122124518,
 1121982854,
 71456,
 -48413,
 1122099387,
 71463,
 -48412,
 1122141043,
 71466,
 -48411,
 1122198445,
 71465,
 -1,
 1122244998,
 71457,
 1122452200,
 1122096026,
 71460,
 -1,
 1122423706,
 71461,
 1122583274,
 1122395053,
 71458,
 -1,
 1122526125,
 71459,
 -48405,
 1122538519,
 71464,
 -1,
 1122648574,
 71462,
 1122845434,
 1121991779,
 -1,
 1122910960,
 1122813857,
 -1,
 -48401,
 1122887190,
 71474,
 -1,
 1122918880,
 71475,
 1123107571,
 1122875905,
 -1,
 -48398,
 1123053936,
 71478,
 -1,
 1123110037,
 71479,
 1123304182,
 1123045009,
 -1,
 -48395,
 1123262205,
 71476,
 -1,
 1123315902,
 71477,
 -48393,
 1123282203,
 71472,
 -48392,
 1123457109,
 71473,
 -48391,
 1123520584,
 71481,
 -1,
 1123567238,
 71480,
 1123762946,
 1122810369,
 -1,
 1123828481,
 1123706745,
 -1,
 1123894015,
 1123793409,
 -1,
 -48386,
 1123845345,
 71484,
 -1,
 1123894328,
 71485,
 -48384,
 1123858796,
 71486,
 -1,
 1124038033,
 71467,
 -1,
 1123806077,
 71487,
 1124287239,
 1123693971,
 -1,
 1124352774,
 1124235023,
 -1,
 -48379,
 1124296249,
 71455,
 -1,
 1124342150,
 71453,
 -1,
 1124314432,
 71454,
 1124663295,
 1124242273,
 -1,
 -48375,
 1124590169,
 71483,
 -1,
 1124616135,
 71482,
 1124811612,
 1119502846,
 -1,
 1124877147,
 1124750979,
 -1,
 1124942666,
 1124832077,
 -1,
 1125008158,
 1124911009,
 -1,
 1125073685,
 1124982971,
 -1,
 1125139219,
 1125028887,
 65800,
 1125253119,
 1125056512,
 -1,
 -48366,
 1125174176,
 65827,
 -1,
 1125212979,
 65818,
 1125449727,
 1125075254,
 65809,
 -1,
 1125321177,
 65836,
 1125532444,
 1125014027,
 -1,
 1125597978,
 1125494958,
 65801,
 1125711871,
 1125515264,
 -1,
 -48359,
 1125632928,
 65828,
 -1,
 1125671731,
 65819,
 1125908479,
 1125543699,
 65810,
 -1,
 1125779929,
 65837,
 1126039551,
 1125468103,
 65808,
 -1,
 1125911001,
 65835,
 1126122283,
 1124973057,
 -1,
 1126187813,
 1126068592,
 65804,
 1126253346,
 1126159230,
 65813,
 -1,
 1126173145,
 65840,
 1126432767,
 1126170624,
 -1,
 -48348,
 1126353824,
 65831,
 -1,
 1126392627,
 65822,
 1126629375,
 1126124693,
 65805,
 1126646568,
 1126552446,
 65814,
 -1,
 1126566361,
 65841,
 1126825983,
 1126563840,
 -1,
 -48342,
 1126747040,
 65832,
 -1,
 1126785843,
 65823,
 1126974266,
 1126059665,
 -1,
 1127039795,
 1126929431,
 -1,
 1127105329,
 1127012796,
 65802,
 1127219199,
 1127022592,
 -1,
 -48336,
 1127140256,
 65829,
 -1,
 1127179059,
 65820,
 1127415807,
 1127070032,
 65811,
 -1,
 1127287257,
 65838,
 1127546879,
 1126982573,
 -1,
 1127564088,
 1127472280,
 65803,
 1127677951,
 1127481344,
 -1,
 -48329,
 1127599008,
 65830,
 -1,
 1127637811,
 65821,
 1127874559,
 1127503020,
 65812,
 -1,
 1127746009,
 65839,
 1127957312,
 1126928456,
 65807,
 1128022845,
 1127928702,
 65816,
 -1,
 1127942617,
 65843,
 1128202239,
 1127940096,
 -1,
 -48321,
 1128123296,
 65834,
 -1,
 1128162099,
 65825,
 1128350534,
 1127892614,
 65806,
 1128416067,
 1128327460,
 65815,
 -1,
 1128335833,
 65842,
 1128595455,
 1128333312,
 -1,
 -48315,
 1128516512,
 65833,
 -1,
 1128555315,
 65824,
 1128792063,
 1128306773,
 65799,
 1128857599,
 1128660992,
 -1,
 -48311,
 1128778656,
 65826,
 -1,
 1128817459,
 65817,
 1129005909,
 1124917435,
 -1,
 1129071442,
 1128941196,
 -1,
 1129136975,
 1129008785,
 -1,
 -48306,
 1129095065,
 65851,
 -1,
 1129148159,
 65848,
 -48304,
 1129106289,
 65850,
 -48303,
 1129298992,
 65849,
 -1,
 1129326786,
 65847,
 1129578495,
 1129028723,
 -1,
 -48300,
 1129479951,
 65792,
 -1,
 1129528659,
 65793,
 1129726808,
 1128957618,
 -1,
 -48297,
 1129696113,
 65855,
 -1,
 1129757744,
 65854,
 -48295,
 1129676647,
 65853,
 -48294,
 1129857352,
 65852,
 -1,
 1129918669,
 65794,
 -1,
 1124840143,
 128673,
 1130185635,
 1124785072,
 -1,
 1130251170,
 1130122084,
 -1,
 1130316705,
 1130200406,
 -1,
 1130382183,
 1130240390,
 68352,
 1130447715,
 1130305926,
 68353,
 -48286,
 1130402839,
 68355,
 -1,
 1130466348,
 68357,
 1130644325,
 1130381822,
 68358,
 -1,
 1130578430,
 68359,
 -48282,
 1130599447,
 68354,
 -1,
 1130728492,
 68356,
 1130906479,
 1130335276,
 -1,
 1130972012,
 1130845384,
 -1,
 -48278,
 1130949161,
 68387,
 -48277,
 1131011224,
 68388,
 -1,
 1131037182,
 68386,
 -48275,
 1130949161,
 68390,
 -48274,
 1131187728,
 68391,
 -1,
 1131233790,
 68389,
 1131430773,
 1130871297,
 -1,
 1131496307,
 1131371019,
 -1,
 -48270,
 1131473449,
 68403,
 -1,
 1131495934,
 68401,
 -48268,
 1131462195,
 68404,
 -1,
 1131627006,
 68399,
 1131823993,
 1131407379,
 -1,
 -48265,
 1131801129,
 68370,
 -48264,
 1131863192,
 68371,
 -1,
 1131889150,
 68369,
 1132086141,
 1131792289,
 -1,
 -48261,
 1132054898,
 68381,
 -48260,
 1132092570,
 68378,
 -1,
 1132151294,
 68377,
 1132348289,
 1132025032,
 -1,
 -48257,
 1132289178,
 68374,
 -48256,
 1132353128,
 68373,
 -1,
 1132413438,
 68372,
 1132610436,
 1132325936,
 -1,
 -48253,
 1132551322,
 68402,
 -1,
 1132610046,
 68400,
 1132807047,
 1132587300,
 -1,
 -48250,
 1132784169,
 68394,
 -1,
 1132806654,
 68395,
 1133003657,
 1132778394,
 68366,
 -1,
 1132975002,
 68367,
 1133134731,
 1132958743,
 68362,
 -1,
 1133089815,
 68363,
 1133265805,
 1133077421,
 68364,
 -1,
 1133208493,
 68365,
 1133396880,
 1133206027,
 -1,
 -48241,
 1133348500,
 68393,
 -1,
 1133396478,
 68405,
 1133593490,
 1133330942,
 68360,
 -1,
 1133527550,
 68361,
 1133724565,
 1133525261,
 -1,
 -48236,
 1133665434,
 68380,
 -1,
 1133724158,
 68379,
 1133921176,
 1133651807,
 -1,
 -48233,
 1133862042,
 68385,
 -1,
 1133920766,
 68384,
 -48231,
 1133894808,
 68396,
 -48230,
 1134079907,
 68397,
 -48229,
 1134142671,
 68382,
 -48228,
 1134200468,
 68392,
 -48227,
 1134262800,
 68398,
 -48226,
 1134326960,
 68368,
 -48225,
 1134391897,
 68376,
 -48224,
 1134448460,
 68383,
 -1,
 1134505885,
 68375,
 -1,
 1130240674,
 68409,
 -1,
 1130206375,
 129361,
 1134838699,
 1130156954,
 -1,
 1134904233,
 1134808654,
 -1,
 1134969768,
 1134855027,
 -1,
 -48217,
 1134924915,
 128663,
 -1,
 1134962053,
 127975,
 -1,
 1134889109,
 128762,
 -48214,
 1134871985,
 8371,
 -1,
 1135159691,
 127814,
 1135362992,
 1134806085,
 -1,
 1135428527,
 1135324358,
 -1,
 -48210,
 1135385065,
 9954,
 -1,
 1135418443,
 11225,
 -1,
 1135385003,
 128562,
 1135690676,
 1135321775,
 -1,
 -48206,
 1135650587,
 983194,
 -48205,
 1135712005,
 11236,
 -1,
 1135750563,
 983195,
 1135952824,
 1135641459,
 -1,
 -48202,
 1135912509,
 127994,
 -48201,
 1135954577,
 127944,
 -1,
 1136012583,
 128657,
 1136214972,
 1135881635,
 -1,
 1136280507,
 1136161593,
 983053,
 -1,
 1136235009,
 983052,
 -1,
 1136198215,
 9190,
 1136477119,
 1136183201,
 -1,
 -48194,
 1136432957,
 9883,
 -1,
 1136484344,
 128095,
 1136673730,
 1136422646,
 -1,
 -48191,
 1136606008,
 128747,
 -1,
 1136665609,
 128748,
 -48189,
 1136650356,
 129683,
 -48188,
 1136817826,
 8525,
 -48187,
 1136873459,
 1547,
 -1,
 1136928707,
 129518,
 1137133670,
 1025018924,
 -1,
 1137198453,
 1137103770,
 -1,
 1137263986,
 1137164068,
 -1,
 1137329521,
 1137193131,
 -1,
 1137394903,
 1137250919,
 -1,
 1137460188,
 1137328638,
 -1,
 -48179,
 1137397393,
 111343,
 -48178,
 1137459710,
 111342,
 -48177,
 1137522957,
 111341,
 -48176,
 1137585571,
 111340,
 -48175,
 1137649503,
 111339,
 -48174,
 1137711494,
 111338,
 -48173,
 1137776852,
 111337,
 -48172,
 1137842211,
 111336,
 -48171,
 1137907523,
 111335,
 -48170,
 1137972851,
 111334,
 -48169,
 1138038142,
 111333,
 -48168,
 1138103466,
 111332,
 -48167,
 1138168716,
 111331,
 -48166,
 1138233959,
 111330,
 -48165,
 1138299196,
 111329,
 -1,
 1138364460,
 111328,
 1138574317,
 1137391885,
 -1,
 -48162,
 1138511505,
 111327,
 -48161,
 1138573822,
 111326,
 -48160,
 1138637069,
 111325,
 -48159,
 1138699683,
 111324,
 -48158,
 1138763615,
 111323,
 -48157,
 1138825606,
 111322,
 -48156,
 1138890964,
 111321,
 -48155,
 1138956323,
 111320,
 -48154,
 1139021635,
 111319,
 -48153,
 1139086963,
 111318,
 -48152,
 1139152254,
 111317,
 -48151,
 1139217578,
 111316,
 -48150,
 1139282828,
 111315,
 -48149,
 1139348071,
 111314,
 -48148,
 1139413308,
 111313,
 -1,
 1139478572,
 111312,
 1139688446,
 1138503075,
 -1,
 -48145,
 1139625617,
 111311,
 -48144,
 1139687934,
 111310,
 -48143,
 1139751181,
 111309,
 -48142,
 1139813795,
 111308,
 -48141,
 1139877727,
 111307,
 -48140,
 1139939718,
 111306,
 -48139,
 1140005076,
 111305,
 -48138,
 1140070435,
 111304,
 -48137,
 1140135747,
 111303,
 -48136,
 1140201075,
 111302,
 -48135,
 1140266366,
 111301,
 -48134,
 1140331690,
 111300,
 -48133,
 1140396940,
 111299,
 -48132,
 1140462183,
 111298,
 -48131,
 1140527420,
 111297,
 -1,
 1140592684,
 111296,
 1140802575,
 1139615583,
 -1,
 -48128,
 1140739729,
 111295,
 -48127,
 1140802046,
 111294,
 -48126,
 1140865293,
 111293,
 -48125,
 1140927907,
 111292,
 -48124,
 1140991839,
 111291,
 -48123,
 1141053830,
 111290,
 -48122,
 1141119188,
 111289,
 -48121,
 1141184547,
 111288,
 -48120,
 1141249859,
 111287,
 -48119,
 1141315187,
 111286,
 -48118,
 1141380478,
 111285,
 -48117,
 1141445802,
 111284,
 -48116,
 1141511052,
 111283,
 -48115,
 1141576295,
 111282,
 -48114,
 1141641532,
 111281,
 -1,
 1141706796,
 111280,
 1141916704,
 1140726150,
 -1,
 -48111,
 1141853841,
 111279,
 -48110,
 1141916158,
 111278,
 -48109,
 1141979405,
 111277,
 -48108,
 1142042019,
 111276,
 -48107,
 1142105951,
 111275,
 -48106,
 1142167942,
 111274,
 -48105,
 1142233300,
 111273,
 -48104,
 1142298659,
 111272,
 -48103,
 1142363971,
 111271,
 -48102,
 1142429299,
 111270,
 -48101,
 1142494590,
 111269,
 -48100,
 1142559914,
 111268,
 -48099,
 1142625164,
 111267,
 -48098,
 1142690407,
 111266,
 -48097,
 1142755644,
 111265,
 -1,
 1142820908,
 111264,
 1143030833,
 1141840084,
 -1,
 -48094,
 1142967953,
 111263,
 -48093,
 1143030270,
 111262,
 -48092,
 1143093517,
 111261,
 -48091,
 1143156131,
 111260,
 -48090,
 1143220063,
 111259,
 -48089,
 1143282054,
 111258,
 -48088,
 1143347412,
 111257,
 -48087,
 1143412771,
 111256,
 -48086,
 1143478083,
 111255,
 -48085,
 1143543411,
 111254,
 -48084,
 1143608702,
 111253,
 -48083,
 1143674026,
 111252,
 -48082,
 1143739276,
 111251,
 -48081,
 1143804519,
 111250,
 -48080,
 1143869756,
 111249,
 -1,
 1143935020,
 111248,
 1144144962,
 1142954019,
 -1,
 -48077,
 1144082065,
 111247,
 -48076,
 1144144382,
 111246,
 -48075,
 1144207629,
 111245,
 -48074,
 1144270243,
 111244,
 -48073,
 1144334175,
 111243,
 -48072,
 1144396166,
 111242,
 -48071,
 1144461524,
 111241,
 -48070,
 1144526883,
 111240,
 -48069,
 1144592195,
 111239,
 -48068,
 1144657523,
 111238,
 -48067,
 1144722814,
 111237,
 -48066,
 1144788138,
 111236,
 -48065,
 1144853388,
 111235,
 -48064,
 1144918631,
 111234,
 -48063,
 1144983868,
 111233,
 -1,
 1145049132,
 111232,
 1145259091,
 1144067907,
 -1,
 -48060,
 1145196177,
 111231,
 -48059,
 1145258494,
 111230,
 -48058,
 1145321741,
 111229,
 -48057,
 1145384355,
 111228,
 -48056,
 1145448287,
 111227,
 -48055,
 1145510278,
 111226,
 -48054,
 1145575636,
 111225,
 -48053,
 1145640995,
 111224,
 -48052,
 1145706307,
 111223,
 -48051,
 1145771635,
 111222,
 -48050,
 1145836926,
 111221,
 -48049,
 1145902250,
 111220,
 -48048,
 1145967500,
 111219,
 -48047,
 1146032743,
 111218,
 -48046,
 1146097980,
 111217,
 -1,
 1146163244,
 111216,
 1146373220,
 1145181811,
 -1,
 -48043,
 1146310289,
 111215,
 -48042,
 1146372606,
 111214,
 -48041,
 1146435853,
 111213,
 -48040,
 1146498467,
 111212,
 -48039,
 1146562399,
 111211,
 -48038,
 1146624390,
 111210,
 -48037,
 1146689748,
 111209,
 -48036,
 1146755107,
 111208,
 -48035,
 1146820419,
 111207,
 -48034,
 1146885747,
 111206,
 -48033,
 1146951038,
 111205,
 -48032,
 1147016362,
 111204,
 -48031,
 1147081612,
 111203,
 -48030,
 1147146855,
 111202,
 -48029,
 1147212092,
 111201,
 -1,
 1147277356,
 111200,
 1147487349,
 1146295678,
 -1,
 -48026,
 1147424401,
 111199,
 -48025,
 1147486718,
 111198,
 -48024,
 1147549965,
 111197,
 -48023,
 1147612579,
 111196,
 -48022,
 1147676511,
 111195,
 -48021,
 1147738502,
 111194,
 -48020,
 1147803860,
 111193,
 -48019,
 1147869219,
 111192,
 -48018,
 1147934531,
 111191,
 -48017,
 1147999859,
 111190,
 -48016,
 1148065150,
 111189,
 -48015,
 1148130474,
 111188,
 -48014,
 1148195724,
 111187,
 -48013,
 1148260967,
 111186,
 -48012,
 1148326204,
 111185,
 -1,
 1148391468,
 111184,
 1148601478,
 1147409578,
 -1,
 -48009,
 1148538513,
 111183,
 -48008,
 1148600830,
 111182,
 -48007,
 1148664077,
 111181,
 -48006,
 1148726691,
 111180,
 -48005,
 1148790623,
 111179,
 -48004,
 1148852614,
 111178,
 -48003,
 1148917972,
 111177,
 -48002,
 1148983331,
 111176,
 -48001,
 1149048643,
 111175,
 -48000,
 1149113971,
 111174,
 -47999,
 1149179262,
 111173,
 -47998,
 1149244586,
 111172,
 -47997,
 1149309836,
 111171,
 -47996,
 1149375079,
 111170,
 -47995,
 1149440316,
 111169,
 -1,
 1149505580,
 111168,
 1149715607,
 1148523404,
 -1,
 -47992,
 1149652625,
 111167,
 -47991,
 1149714942,
 111166,
 -47990,
 1149778189,
 111165,
 -47989,
 1149840803,
 111164,
 -47988,
 1149904735,
 111163,
 -47987,
 1149966726,
 111162,
 -47986,
 1150032084,
 111161,
 -47985,
 1150097443,
 111160,
 -47984,
 1150162755,
 111159,
 -47983,
 1150228083,
 111158,
 -47982,
 1150293374,
 111157,
 -47981,
 1150358698,
 111156,
 -47980,
 1150423948,
 111155,
 -47979,
 1150489191,
 111154,
 -47978,
 1150554428,
 111153,
 -1,
 1150619692,
 111152,
 1150829736,
 1149637223,
 -1,
 -47975,
 1150766737,
 111151,
 -47974,
 1150829054,
 111150,
 -47973,
 1150892301,
 111149,
 -47972,
 1150954915,
 111148,
 -47971,
 1151018847,
 111147,
 -47970,
 1151080838,
 111146,
 -47969,
 1151146196,
 111145,
 -47968,
 1151211555,
 111144,
 -47967,
 1151276867,
 111143,
 -47966,
 1151342195,
 111142,
 -47965,
 1151407486,
 111141,
 -47964,
 1151472810,
 111140,
 -47963,
 1151538060,
 111139,
 -47962,
 1151603303,
 111138,
 -47961,
 1151668540,
 111137,
 -1,
 1151733804,
 111136,
 1151943865,
 1150751036,
 -1,
 -47958,
 1151880849,
 111135,
 -47957,
 1151943166,
 111134,
 -47956,
 1152006413,
 111133,
 -47955,
 1152069027,
 111132,
 -47954,
 1152132959,
 111131,
 -47953,
 1152194950,
 111130,
 -47952,
 1152260308,
 111129,
 -47951,
 1152325667,
 111128,
 -47950,
 1152390979,
 111127,
 -47949,
 1152456307,
 111126,
 -47948,
 1152521598,
 111125,
 -47947,
 1152586922,
 111124,
 -47946,
 1152652172,
 111123,
 -47945,
 1152717415,
 111122,
 -47944,
 1152782652,
 111121,
 -1,
 1152847916,
 111120,
 1153057994,
 1151864876,
 -1,
 -47941,
 1152994961,
 111119,
 -47940,
 1153057278,
 111118,
 -47939,
 1153120525,
 111117,
 -47938,
 1153183139,
 111116,
 -47937,
 1153247071,
 111115,
 -47936,
 1153309062,
 111114,
 -47935,
 1153374420,
 111113,
 -47934,
 1153439779,
 111112,
 -47933,
 1153505091,
 111111,
 -47932,
 1153570419,
 111110,
 -47931,
 1153635710,
 111109,
 -47930,
 1153701034,
 111108,
 -47929,
 1153766284,
 111107,
 -47928,
 1153831527,
 111106,
 -47927,
 1153896764,
 111105,
 -1,
 1153962028,
 111104,
 1154220031,
 1152994961,
 -1,
 -47924,
 1154099039,
 111355,
 -47923,
 1154161030,
 111354,
 -47922,
 1154226388,
 111353,
 -47921,
 1154291747,
 111352,
 -47920,
 1154357059,
 111351,
 -47919,
 1154422387,
 111350,
 -47918,
 1154487678,
 111349,
 -47917,
 1154553002,
 111348,
 -47916,
 1154618252,
 111347,
 -47915,
 1154683495,
 111346,
 -47914,
 1154748732,
 111345,
 -1,
 1154813996,
 111344,
 1155071999,
 1137316156,
 -1,
 1155089641,
 1154961041,
 -1,
 -47910,
 1155026577,
 111103,
 -47909,
 1155088894,
 111102,
 -47908,
 1155152141,
 111101,
 -47907,
 1155214755,
 111100,
 -47906,
 1155278687,
 111099,
 -47905,
 1155340678,
 111098,
 -47904,
 1155406036,
 111097,
 -47903,
 1155471395,
 111096,
 -47902,
 1155536707,
 111095,
 -47901,
 1155602035,
 111094,
 -47900,
 1155667326,
 111093,
 -47899,
 1155732650,
 111092,
 -47898,
 1155797900,
 111091,
 -47897,
 1155863143,
 111090,
 -47896,
 1155928380,
 111089,
 -1,
 1155993644,
 111088,
 1156203770,
 1155023358,
 -1,
 -47893,
 1156140689,
 111087,
 -47892,
 1156203006,
 111086,
 -47891,
 1156266253,
 111085,
 -47890,
 1156328867,
 111084,
 -47889,
 1156392799,
 111083,
 -47888,
 1156454790,
 111082,
 -47887,
 1156520148,
 111081,
 -47886,
 1156585507,
 111080,
 -47885,
 1156650819,
 111079,
 -47884,
 1156716147,
 111078,
 -47883,
 1156781438,
 111077,
 -47882,
 1156846762,
 111076,
 -47881,
 1156912012,
 111075,
 -47880,
 1156977255,
 111074,
 -47879,
 1157042492,
 111073,
 -1,
 1157107756,
 111072,
 1157317899,
 1156135181,
 -1,
 -47876,
 1157254801,
 111071,
 -47875,
 1157317118,
 111070,
 -47874,
 1157380365,
 111069,
 -47873,
 1157442979,
 111068,
 -47872,
 1157506911,
 111067,
 -47871,
 1157568902,
 111066,
 -47870,
 1157634260,
 111065,
 -47869,
 1157699619,
 111064,
 -47868,
 1157764931,
 111063,
 -47867,
 1157830259,
 111062,
 -47866,
 1157895550,
 111061,
 -47865,
 1157960874,
 111060,
 -47864,
 1158026124,
 111059,
 -47863,
 1158091367,
 111058,
 -47862,
 1158156604,
 111057,
 -1,
 1158221868,
 111056,
 1158432028,
 1157246371,
 -1,
 -47859,
 1158368913,
 111055,
 -47858,
 1158431230,
 111054,
 -47857,
 1158494477,
 111053,
 -47856,
 1158557091,
 111052,
 -47855,
 1158621023,
 111051,
 -47854,
 1158683014,
 111050,
 -47853,
 1158748372,
 111049,
 -47852,
 1158813731,
 111048,
 -47851,
 1158879043,
 111047,
 -47850,
 1158944371,
 111046,
 -47849,
 1159009662,
 111045,
 -47848,
 1159074986,
 111044,
 -47847,
 1159140236,
 111043,
 -47846,
 1159205479,
 111042,
 -47845,
 1159270716,
 111041,
 -1,
 1159335980,
 111040,
 1159546157,
 1158358879,
 -1,
 -47842,
 1159483025,
 111039,
 -47841,
 1159545342,
 111038,
 -47840,
 1159608589,
 111037,
 -47839,
 1159671203,
 111036,
 -47838,
 1159735135,
 111035,
 -47837,
 1159797126,
 111034,
 -47836,
 1159862484,
 111033,
 -47835,
 1159927843,
 111032,
 -47834,
 1159993155,
 111031,
 -47833,
 1160058483,
 111030,
 -47832,
 1160123774,
 111029,
 -47831,
 1160189098,
 111028,
 -47830,
 1160254348,
 111027,
 -47829,
 1160319591,
 111026,
 -47828,
 1160384828,
 111025,
 -1,
 1160450092,
 111024,
 1160660286,
 1159469446,
 -1,
 -47825,
 1160597137,
 111023,
 -47824,
 1160659454,
 111022,
 -47823,
 1160722701,
 111021,
 -47822,
 1160785315,
 111020,
 -47821,
 1160849247,
 111019,
 -47820,
 1160911238,
 111018,
 -47819,
 1160976596,
 111017,
 -47818,
 1161041955,
 111016,
 -47817,
 1161107267,
 111015,
 -47816,
 1161172595,
 111014,
 -47815,
 1161237886,
 111013,
 -47814,
 1161303210,
 111012,
 -47813,
 1161368460,
 111011,
 -47812,
 1161433703,
 111010,
 -47811,
 1161498940,
 111009,
 -1,
 1161564204,
 111008,
 1161774415,
 1160583380,
 -1,
 -47808,
 1161711249,
 111007,
 -47807,
 1161773566,
 111006,
 -47806,
 1161836813,
 111005,
 -47805,
 1161899427,
 111004,
 -47804,
 1161963359,
 111003,
 -47803,
 1162025350,
 111002,
 -47802,
 1162090708,
 111001,
 -47801,
 1162156067,
 111000,
 -47800,
 1162221379,
 110999,
 -47799,
 1162286707,
 110998,
 -47798,
 1162351998,
 110997,
 -47797,
 1162417322,
 110996,
 -47796,
 1162482572,
 110995,
 -47795,
 1162547815,
 110994,
 -47794,
 1162613052,
 110993,
 -1,
 1162678316,
 110992,
 1162888544,
 1161697315,
 -1,
 -47791,
 1162825361,
 110991,
 -47790,
 1162887678,
 110990,
 -47789,
 1162950925,
 110989,
 -47788,
 1163013539,
 110988,
 -47787,
 1163077471,
 110987,
 -47786,
 1163139462,
 110986,
 -47785,
 1163204820,
 110985,
 -47784,
 1163270179,
 110984,
 -47783,
 1163335491,
 110983,
 -47782,
 1163400819,
 110982,
 -47781,
 1163466110,
 110981,
 -47780,
 1163531434,
 110980,
 -47779,
 1163596684,
 110979,
 -47778,
 1163661927,
 110978,
 -47777,
 1163727164,
 110977,
 -1,
 1163792428,
 110976,
 1164050431,
 1162811203,
 -1,
 -47774,
 1163939473,
 110975,
 -47773,
 1164001790,
 110974,
 -47772,
 1164065037,
 110973,
 -47771,
 1164127651,
 110972,
 -47770,
 1164191583,
 110971,
 -47769,
 1164253574,
 110970,
 -47768,
 1164318932,
 110969,
 -47767,
 1164384291,
 110968,
 -47766,
 1164449603,
 110967,
 -47765,
 1164514931,
 110966,
 -47764,
 1164580222,
 110965,
 -47763,
 1164645546,
 110964,
 -47762,
 1164710796,
 110963,
 -47761,
 1164776039,
 110962,
 -47760,
 1164841276,
 110961,
 -1,
 1164906540,
 110960,
 -1,
 1137274987,
 94177,
 1165182324,
 1137211151,
 983041,
 -1,
 1165129487,
 983040,
 -1,
 1165150118,
 128297,
 1165379300,
 1137132030,
 -1,
 1165444717,
 1165353147,
 -1,
 1165510135,
 1165367688,
 -1,
 1165575618,
 1165458774,
 -1,
 1165641091,
 1165528108,
 -1,
 1165706621,
 1165617444,
 -1,
 -47748,
 1165646365,
 70681,
 -1,
 1165695366,
 70680,
 1165903232,
 1165645000,
 -1,
 -47745,
 1165842973,
 70675,
 -1,
 1165891974,
 70674,
 -47743,
 1165855862,
 70686,
 -47742,
 1166039581,
 70692,
 -1,
 1166088582,
 70691,
 1166296458,
 1165614000,
 -1,
 1166361993,
 1166251181,
 -1,
 1166427527,
 1166322886,
 70662,
 -1,
 1166388422,
 70663,
 1166606335,
 1166374671,
 70664,
 -1,
 1166505743,
 70665,
 -1,
 1166296294,
 70751,
 1166755216,
 1166264225,
 -1,
 1166820750,
 1166722977,
 -1,
 -47731,
 1166760477,
 70683,
 -1,
 1166809478,
 70682,
 -47729,
 1166760477,
 70688,
 -1,
 1166940550,
 70687,
 1167148438,
 1166686477,
 -1,
 1167213972,
 1167079693,
 -1,
 -47725,
 1167153693,
 70685,
 -1,
 1167202694,
 70684,
 -47723,
 1167153693,
 70690,
 -1,
 1167333766,
 70689,
 1167541658,
 1167071622,
 70656,
 -47720,
 1167512474,
 70669,
 -47719,
 1167549357,
 70667,
 -1,
 1167595910,
 70657,
 1167803806,
 1167505921,
 -1,
 -47716,
 1167768278,
 70706,
 -47715,
 1167809053,
 70705,
 -1,
 1167858054,
 70707,
 1168065952,
 1167774618,
 70660,
 -1,
 1168036762,
 70661,
 1168197027,
 1168026822,
 -1,
 -47710,
 1168136733,
 70701,
 -1,
 1168185734,
 70700,
 1168393638,
 1168155311,
 -1,
 -47707,
 1168333341,
 70694,
 -1,
 1168382342,
 70693,
 1168590249,
 1168343923,
 -1,
 -47704,
 1168529949,
 70698,
 -1,
 1168578950,
 70697,
 1168786860,
 1168537359,
 -1,
 -47701,
 1168726557,
 70703,
 -1,
 1168775558,
 70702,
 1168983471,
 1168732985,
 -1,
 -47698,
 1168923165,
 70671,
 -1,
 1168972166,
 70670,
 1169180082,
 1168929293,
 -1,
 -47695,
 1169119773,
 70679,
 -1,
 1169168774,
 70678,
 1169376692,
 1169122221,
 70658,
 -1,
 1169318829,
 70659,
 1169507767,
 1169315016,
 -1,
 -47690,
 1169447453,
 70673,
 -1,
 1169496454,
 70672,
 1169704378,
 1169436067,
 -1,
 -47687,
 1169644061,
 70677,
 -1,
 1169693062,
 70676,
 1169900989,
 1169631071,
 -1,
 -47684,
 1169840669,
 70696,
 -1,
 1169889670,
 70695,
 -47682,
 1169877407,
 70699,
 -47681,
 1170071803,
 70704,
 -47680,
 1170117655,
 70668,
 -47679,
 1170168349,
 70708,
 -1,
 1170227710,
 70666,
 1170425298,
 1165549622,
 -1,
 1170490824,
 1170399069,
 -1,
 1170556358,
 1170451654,
 70714,
 -1,
 1170517190,
 70715,
 1170735103,
 1170503439,
 70716,
 -1,
 1170634511,
 70717,
 1170818508,
 1170413958,
 -1,
 -47670,
 1170789274,
 70721,
 -47669,
 1170826157,
 70719,
 -1,
 1170872710,
 70709,
 1171080654,
 1170789274,
 70712,
 -1,
 1171051418,
 70713,
 1171211728,
 1171022765,
 70710,
 -1,
 1171153837,
 70711,
 -47663,
 1171166231,
 70720,
 -1,
 1171276286,
 70718,
 1171473891,
 1170356493,
 -1,
 1171539425,
 1171416930,
 -1,
 1171604951,
 1171507105,
 -1,
 -47658,
 1171580438,
 70738,
 -1,
 1171612128,
 70739,
 1171801562,
 1171569153,
 -1,
 -47655,
 1171747184,
 70742,
 -1,
 1171803285,
 70743,
 1171998173,
 1171738257,
 -1,
 -47652,
 1171955453,
 70740,
 -1,
 1172009150,
 70741,
 -47650,
 1171975451,
 70736,
 -47649,
 1172150357,
 70737,
 -47648,
 1172213832,
 70745,
 -1,
 1172260486,
 70744,
 -47646,
 1171496582,
 70732,
 -1,
 1172381982,
 70731,
 1172588017,
 1171438081,
 -1,
 1172653552,
 1172530093,
 -1,
 1172719087,
 1172592776,
 -1,
 1172784617,
 1172692669,
 -1,
 -47640,
 1172749233,
 70725,
 -1,
 1172811353,
 70722,
 1172981228,
 1172707718,
 -1,
 -47637,
 1172954054,
 70727,
 -1,
 1173001106,
 70724,
 -47635,
 1172935491,
 70726,
 -47634,
 1173114935,
 70728,
 -1,
 1173171831,
 70723,
 -1,
 1172650595,
 70730,
 -1,
 1172578611,
 70750,
 -47630,
 1172547282,
 70747,
 -47629,
 1173460781,
 70729,
 -47628,
 1173515333,
 70749,
 -47627,
 1173575106,
 70734,
 -47626,
 1173632154,
 70733,
 -1,
 1173691079,
 70735,
 1173898857,
 1165426688,
 -1,
 1173964389,
 1173866657,
 -1,
 1174029884,
 1173912918,
 -1,
 1174095383,
 1173979545,
 -1,
 1174160895,
 1174063009,
 -1,
 -47619,
 1174125270,
 6539,
 -47618,
 1174166045,
 6546,
 -1,
 1174215046,
 6545,
 1174423042,
 1174136851,
 -1,
 -47615,
 1174395843,
 6569,
 -1,
 1174411654,
 6534,
 1174619653,
 1174387201,
 -1,
 -47612,
 1174590515,
 6571,
 -1,
 1174608262,
 6540,
 1174816264,
 1174577839,
 -1,
 -47609,
 1174755869,
 6552,
 -1,
 1174804870,
 6551,
 1175012875,
 1174768684,
 -1,
 -47606,
 1174951191,
 6535,
 -1,
 1175001478,
 6547,
 1175209486,
 1174958905,
 -1,
 -47603,
 1175182275,
 6568,
 -1,
 1175198086,
 6533,
 -47601,
 1175185823,
 6541,
 -47600,
 1175378883,
 6558,
 -47599,
 1175431968,
 6529,
 -47598,
 1175487433,
 6553,
 -47597,
 1175549785,
 6559,
 -47596,
 1175607837,
 6563,
 -47595,
 1175670502,
 6557,
 -47594,
 1175730588,
 6564,
 -1,
 1175791504,
 6565,
 1175995956,
 1174036162,
 -1,
 1176061468,
 1175963553,
 -1,
 -47590,
 1176025814,
 6536,
 -47589,
 1176066589,
 6543,
 -1,
 1176115590,
 6542,
 1176323615,
 1176037395,
 -1,
 -47586,
 1176296387,
 6567,
 -1,
 1176312198,
 6531,
 1176520226,
 1176287745,
 -1,
 -47583,
 1176491059,
 6570,
 -1,
 1176508806,
 6537,
 1176716837,
 1176478383,
 -1,
 -47580,
 1176656413,
 6549,
 -1,
 1176705414,
 6548,
 1176913448,
 1176669228,
 -1,
 -47577,
 1176851735,
 6532,
 -1,
 1176902022,
 6544,
 1177110059,
 1176859449,
 -1,
 -47574,
 1177082819,
 6566,
 -1,
 1177098630,
 6530,
 -47572,
 1177086367,
 6538,
 -47571,
 1177279427,
 6555,
 -47570,
 1177332512,
 6528,
 -47569,
 1177387977,
 6550,
 -47568,
 1177450329,
 6556,
 -47567,
 1177508381,
 6560,
 -47566,
 1177571046,
 6554,
 -47565,
 1177631132,
 6561,
 -1,
 1177692048,
 6562,
 1177944063,
 1175932976,
 -1,
 1177962039,
 1177848876,
 6595,
 -1,
 1177900232,
 6594,
 -47560,
 1177934768,
 6593,
 -47559,
 1178043251,
 6596,
 -47558,
 1178104633,
 6597,
 -47557,
 1178155277,
 6598,
 -1,
 1178216287,
 6599,
 1178420816,
 1174003766,
 -1,
 1178486338,
 1178391450,
 6579,
 1178551872,
 1178419710,
 6585,
 -1,
 1178528036,
 6591,
 -47551,
 1178528036,
 6588,
 -1,
 1178653594,
 6580,
 1178814022,
 1178440727,
 6583,
 1178879557,
 1178737030,
 6584,
 -1,
 1178855716,
 6590,
 -1,
 1178855716,
 6589,
 1179076171,
 1178737030,
 -1,
 1179141705,
 1178999174,
 6577,
 -1,
 1179117860,
 6587,
 -47542,
 1179117860,
 6586,
 -1,
 1179206142,
 6582,
 1179403854,
 1179018157,
 -1,
 -47539,
 1179380004,
 6592,
 -1,
 1179411373,
 6578,
 -47537,
 1179377702,
 6576,
 -1,
 1179533822,
 6581,
 1179731550,
 1178352739,
 -1,
 1179797076,
 1179699105,
 -1,
 -47533,
 1179772438,
 6610,
 -1,
 1179804128,
 6611,
 1179993687,
 1179761153,
 -1,
 -47530,
 1179939184,
 6614,
 -1,
 1179995285,
 6615,
 1180190298,
 1179930257,
 -1,
 -47527,
 1180147453,
 6612,
 -1,
 1180201150,
 6613,
 -47525,
 1180167451,
 6608,
 -47524,
 1180342357,
 6609,
 -47523,
 1180405832,
 6617,
 -1,
 1180452486,
 6616,
 1180649059,
 1179699105,
 -1,
 1180714594,
 1180604652,
 -1,
 -47519,
 1180635751,
 6601,
 -1,
 1180700988,
 6600,
 -1,
 1180654383,
 6618,
 1181024255,
 1180614605,
 6622,
 -1,
 1180949424,
 6623,
 1181107816,
 1173916319,
 -1,
 -47513,
 1181082722,
 127770,
 -1,
 1181140830,
 127761,
 -1,
 1181056783,
 983063,
 1181369964,
 1173847828,
 -1,
 -47509,
 1181332325,
 11155,
 -1,
 1181383403,
 11154,
 -1,
 1181336301,
 128240,
 1181632176,
 1165383162,
 -1,
 1181697680,
 1181598587,
 -1,
 1181763210,
 1181645114,
 -1,
 -47503,
 1181740080,
 127369,
 -47502,
 1181804836,
 127368,
 -47501,
 1181870099,
 127367,
 -47500,
 1181933755,
 127366,
 -47499,
 1181998000,
 127365,
 -47498,
 1182061466,
 127364,
 -47497,
 1182123937,
 127363,
 -47496,
 1182185985,
 127362,
 -47495,
 1182248134,
 127361,
 -47494,
 1182313217,
 127360,
 -47493,
 1182376623,
 127359,
 -47492,
 1182438423,
 127358,
 -47491,
 1182501932,
 127357,
 -47490,
 1182565235,
 127356,
 -47489,
 1182627599,
 127355,
 -47488,
 1182692153,
 127354,
 -47487,
 1182757389,
 127353,
 -47486,
 1182819245,
 127352,
 -47485,
 1182882315,
 127351,
 -47484,
 1182946504,
 127350,
 -47483,
 1183010449,
 127349,
 -47482,
 1183072766,
 127348,
 -47481,
 1183136013,
 127347,
 -47480,
 1183198627,
 127346,
 -47479,
 1183262559,
 127345,
 -1,
 1183324550,
 127344,
 -47477,
 1181737498,
 127375,
 -47476,
 1183496918,
 127373,
 -47475,
 1183556363,
 127372,
 -47474,
 1183605970,
 127371,
 -47473,
 1183659785,
 10062,
 -1,
 1183718017,
 127374,
 1183925935,
 1181626922,
 -1,
 1183991468,
 1183873338,
 -1,
 -47469,
 1183968304,
 127337,
 -47468,
 1184033060,
 127336,
 -47467,
 1184098323,
 127335,
 -47466,
 1184161979,
 127334,
 -47465,
 1184226224,
 127333,
 -47464,
 1184289690,
 127332,
 -47463,
 1184352161,
 127331,
 -47462,
 1184414209,
 127330,
 -47461,
 1184476358,
 127329,
 -47460,
 1184541441,
 127328,
 -47459,
 1184604847,
 127327,
 -47458,
 1184666647,
 127326,
 -47457,
 1184730156,
 127325,
 -47456,
 1184793459,
 127324,
 -47455,
 1184855823,
 127323,
 -47454,
 1184920377,
 127322,
 -47453,
 1184985613,
 127321,
 -47452,
 1185047469,
 127320,
 -47451,
 1185110539,
 127319,
 -47450,
 1185174728,
 127318,
 -47449,
 1185238673,
 127317,
 -47448,
 1185300990,
 127316,
 -47447,
 1185364237,
 127315,
 -47446,
 1185426851,
 127314,
 -47445,
 1185490783,
 127313,
 -1,
 1185552774,
 127312,
 -47443,
 1183961075,
 128982,
 -47442,
 1185727325,
 128984,
 -1,
 1185758314,
 9471,
 -1,
 1183849356,
 983091,
 1186023134,
 1181604653,
 -1,
 1186088669,
 1185984066,
 -1,
 1186154204,
 1186017564,
 -1,
 1186219714,
 1186100025,
 -1,
 1186285246,
 1186172958,
 129540,
 1186398207,
 1186203820,
 -1,
 1186416315,
 1186318241,
 -1,
 1186481850,
 1186391730,
 -1,
 -47431,
 1186452135,
 129586,
 -1,
 1186512191,
 129603,
 -1,
 1186423413,
 129607,
 -47428,
 1186371718,
 129565,
 -47427,
 1186697343,
 129561,
 -1,
 1186747040,
 129544,
 1186988031,
 1186228787,
 129536,
 1187053567,
 1186859180,
 -1,
 -47423,
 1186976588,
 129599,
 -1,
 1187025023,
 129557,
 1187202762,
 1186189812,
 -1,
 1187268294,
 1187148601,
 -1,
 -47419,
 1187221534,
 129582,
 -1,
 1187277363,
 129578,
 -47417,
 1187231749,
 129580,
 -47416,
 1187425327,
 129579,
 -47415,
 1187488935,
 129583,
 -1,
 1187523247,
 129581,
 1187727054,
 1187166213,
 129538,
 1187839999,
 1187645612,
 -1,
 -47411,
 1187763020,
 129601,
 -1,
 1187811455,
 129559,
 1187989202,
 1187687471,
 129537,
 1188102143,
 1187907756,
 -1,
 -47407,
 1188025164,
 129600,
 -1,
 1188073599,
 129558,
 1188251350,
 1187947687,
 129541,
 1188364287,
 1188169900,
 -1,
 -47403,
 1188287308,
 129604,
 -1,
 1188335743,
 129562,
 1188513498,
 1188178607,
 129539,
 1188626431,
 1188432044,
 -1,
 -47399,
 1188549452,
 129602,
 -1,
 1188597887,
 129560,
 1188823039,
 1188448741,
 129610,
 -1,
 1188694198,
 129613,
 -1,
 1186090729,
 128528,
 -1,
 1186023942,
 9906,
 -47393,
 1185999066,
 983130,
 -47392,
 1189004352,
 11228,
 -47391,
 1189064538,
 129299,
 -47390,
 1189128729,
 11209,
 -47389,
 1189181199,
 983131,
 -1,
 1189229423,
 128084,
 1189431157,
 1165302150,
 -1,
 1189496636,
 1189383631,
 -1,
 1189562149,
 1189444950,
 -1,
 1189627629,
 1189529505,
 -1,
 1189693163,
 1189595041,
 -1,
 -47382,
 1189632541,
 72121,
 -1,
 1189681542,
 72120,
 -47380,
 1189632541,
 72126,
 -1,
 1189812614,
 72125,
 1190020850,
 1189579820,
 -1,
 -47377,
 1189996959,
 72119,
 -47376,
 1190038646,
 72124,
 -47375,
 1190090007,
 72114,
 -1,
 1190140294,
 72129,
 1190348536,
 1189951757,
 -1,
 1190414070,
 1190279437,
 -1,
 -47371,
 1190353437,
 72123,
 -1,
 1190402438,
 72122,
 -47369,
 1190353437,
 72128,
 -1,
 1190533510,
 72127,
 1190741756,
 1190271366,
 72096,
 -47366,
 1190712218,
 72109,
 -47365,
 1190749101,
 72107,
 -1,
 1190795654,
 72097,
 1191003904,
 1190714288,
 -1,
 1191069439,
 1190958270,
 72102,
 -1,
 1191029958,
 72103,
 -1,
 1190992262,
 72138,
 1191266052,
 1190967809,
 -1,
 -47358,
 1191230166,
 72140,
 -47357,
 1191270941,
 72139,
 -1,
 1191319942,
 72141,
 1191528198,
 1191236506,
 72100,
 -1,
 1191498650,
 72101,
 1191659273,
 1191488710,
 -1,
 -47352,
 1191619904,
 72144,
 -1,
 1191647622,
 72136,
 1191855884,
 1191617199,
 -1,
 -47349,
 1191795229,
 72131,
 -1,
 1191844230,
 72130,
 1192052495,
 1191802639,
 -1,
 -47346,
 1191999321,
 72143,
 -1,
 1192040838,
 72137,
 1192249106,
 1191998265,
 -1,
 -47343,
 1192188445,
 72111,
 -1,
 1192237446,
 72110,
 1192445717,
 1192194573,
 -1,
 -47340,
 1192385053,
 72118,
 -1,
 1192434054,
 72117,
 1192642327,
 1192387501,
 72098,
 -1,
 1192584109,
 72099,
 1192773402,
 1192580296,
 -1,
 -47335,
 1192712733,
 72113,
 -1,
 1192761734,
 72112,
 1192970013,
 1192701347,
 -1,
 -47332,
 1192909341,
 72116,
 -1,
 1192958342,
 72115,
 1193166624,
 1192896351,
 -1,
 -47329,
 1193105949,
 72133,
 -1,
 1193154950,
 72132,
 -47327,
 1193142687,
 72135,
 -47326,
 1193317399,
 72108,
 -47325,
 1193378761,
 72134,
 -47324,
 1193433629,
 72142,
 -1,
 1193492990,
 72106,
 1193690931,
 1189535798,
 -1,
 1193756458,
 1193613702,
 -1,
 -47320,
 1193726874,
 72157,
 -47319,
 1193763757,
 72155,
 -1,
 1193810310,
 72145,
 1194018604,
 1193729904,
 72150,
 -1,
 1193979078,
 72151,
 1194149678,
 1193989018,
 72148,
 -1,
 1194120090,
 72149,
 1194280752,
 1194091437,
 72146,
 -1,
 1194222509,
 72147,
 -47311,
 1194240453,
 72164,
 -47310,
 1194365975,
 72156,
 -1,
 1194410494,
 72154,
 1194608443,
 1193656249,
 -1,
 1194673975,
 1194581693,
 -1,
 -47306,
 1194638257,
 72159,
 -1,
 1194700377,
 72160,
 1194870586,
 1194596742,
 -1,
 -47303,
 1194843078,
 72161,
 -1,
 1194890130,
 72158,
 -1,
 1194835797,
 72162,
 -1,
 1194548469,
 72163,
 1195198319,
 1189423313,
 -1,
 1195263842,
 1195146582,
 -1,
 1195329352,
 1195200560,
 -1,
 -47296,
 1195305897,
 67724,
 -47295,
 1195359909,
 67740,
 -47294,
 1195414409,
 67732,
 -47293,
 1195476859,
 67730,
 -47292,
 1195538518,
 67728,
 -47291,
 1195602951,
 67726,
 -47290,
 1195662490,
 67718,
 -47289,
 1195714979,
 67714,
 -1,
 1195777788,
 67712,
 1195984717,
 1195293185,
 -1,
 1196050252,
 1195907462,
 -1,
 -47285,
 1196001122,
 67734,
 -1,
 1196047295,
 67737,
 -1,
 1195990858,
 67741,
 1196312400,
 1195952033,
 -1,
 -47281,
 1196247964,
 67723,
 -1,
 1196304125,
 67742,
 1196509010,
 1196252314,
 67719,
 -1,
 1196477118,
 67722,
 1196640085,
 1196431750,
 -1,
 -47276,
 1196616418,
 67735,
 -1,
 1196653855,
 67713,
 -47274,
 1196616942,
 67721,
 -47273,
 1196813225,
 67725,
 -47272,
 1196876257,
 67720,
 -47271,
 1196929445,
 67739,
 -47270,
 1196993394,
 67738,
 -47269,
 1197057231,
 67736,
 -47268,
 1197118345,
 67733,
 -47267,
 1197180795,
 67731,
 -47266,
 1197242454,
 67729,
 -47265,
 1197306887,
 67727,
 -47264,
 1197365274,
 67716,
 -47263,
 1197423086,
 67717,
 -1,
 1197484451,
 67715,
 1197688686,
 1195217741,
 -1,
 1197754217,
 1197655969,
 -1,
 1197819751,
 1197727931,
 -1,
 -47258,
 1197773847,
 67752,
 -1,
 1197820214,
 67758,
 -47256,
 1197760992,
 67753,
 -1,
 1197950919,
 67757,
 1198147435,
 1197709397,
 67751,
 -1,
 1198064472,
 67759,
 1198325759,
 1198083729,
 -1,
 -47251,
 1198235389,
 67754,
 -1,
 1198289086,
 67756,
 -1,
 1197619187,
 67755,
 -47248,
 1195175129,
 129535,
 -47247,
 1198512833,
 129314,
 -47246,
 1198575084,
 127966,
 -47245,
 1198622359,
 128219,
 -47244,
 1198682937,
 983092,
 -1,
 1198745580,
 128133,
 1198933968,
 1189407435,
 -1,
 1198999471,
 1198880527,
 -1,
 1199065006,
 1198934977,
 -1,
 1199130502,
 1199017004,
 -1,
 1199196029,
 1199097761,
 -1,
 -47237,
 1199171638,
 123155,
 -47236,
 1199225558,
 123149,
 -1,
 1199249798,
 123138,
 1199458176,
 1199153839,
 -1,
 -47233,
 1199404889,
 123166,
 -1,
 1199446406,
 123164,
 -47231,
 1199434143,
 123152,
 -47230,
 1199615296,
 123153,
 -47229,
 1199680288,
 123161,
 -47228,
 1199731595,
 123143,
 -47227,
 1199779290,
 123148,
 -1,
 1199839622,
 123141,
 1200048010,
 1199097761,
 -1,
 -47224,
 1200023606,
 123156,
 -47223,
 1200077526,
 123137,
 -1,
 1200101766,
 123139,
 1200310157,
 1200023571,
 -1,
 -47220,
 1200286111,
 123163,
 -1,
 1200298374,
 123142,
 1200506768,
 1200270534,
 -1,
 -47217,
 1200467264,
 123171,
 -1,
 1200494982,
 123158,
 1200703379,
 1200464559,
 -1,
 -47214,
 1200650073,
 123169,
 -1,
 1200691590,
 123162,
 1200899989,
 1200657431,
 123176,
 -1,
 1200854039,
 123177,
 1201031064,
 1200849779,
 -1,
 -47209,
 1200977753,
 123168,
 -1,
 1201019270,
 123136,
 1201227674,
 1200970269,
 123140,
 -1,
 1201166859,
 123167,
 1201358748,
 1201160702,
 123178,
 -1,
 1201291774,
 123179,
 1201489823,
 1201289485,
 -1,
 -47202,
 1201436505,
 123165,
 -1,
 1201478022,
 123151,
 1201686433,
 1201412486,
 123172,
 -1,
 1201609094,
 123173,
 -47198,
 1201663070,
 123147,
 -47197,
 1201793439,
 123160,
 -47196,
 1201856699,
 123180,
 -47195,
 1201920963,
 123154,
 -47194,
 1201984410,
 123175,
 -47193,
 1202043606,
 123146,
 -47192,
 1202105120,
 123159,
 -47191,
 1202157401,
 123145,
 -47190,
 1202221963,
 123150,
 -47189,
 1202283437,
 123174,
 -47188,
 1202345239,
 123170,
 -47187,
 1202409190,
 123157,
 -1,
 1202466266,
 123144,
 -1,
 1199019456,
 123214,
 1202735037,
 1198931043,
 -1,
 1202800563,
 1202702241,
 -1,
 -47182,
 1202775574,
 123202,
 -1,
 1202807264,
 123203,
 1202997174,
 1202764289,
 -1,
 -47179,
 1202942320,
 123206,
 -1,
 1202998421,
 123207,
 1203193785,
 1202933393,
 -1,
 -47176,
 1203150589,
 123204,
 -1,
 1203204286,
 123205,
 -47174,
 1203170587,
 123200,
 -47173,
 1203345493,
 123201,
 -47172,
 1203408968,
 123209,
 -1,
 1203455622,
 123208,
 1203652549,
 1202704044,
 -1,
 -47169,
 1203624880,
 123187,
 -47168,
 1203681793,
 123188,
 -47167,
 1203733363,
 123185,
 -47166,
 1203794445,
 123186,
 -47165,
 1203852488,
 123189,
 -47164,
 1203910925,
 123190,
 -1,
 1203971935,
 123184,
 1204176847,
 1203616257,
 -1,
 1204242382,
 1204119417,
 -1,
 1204307917,
 1204179545,
 -1,
 -47159,
 1204276062,
 123192,
 -47158,
 1204332034,
 123191,
 -47157,
 1204387993,
 123193,
 -47156,
 1204448486,
 123195,
 -1,
 1204494786,
 123194,
 -1,
 1204283664,
 123196,
 -1,
 1204218671,
 123197,
 -1,
 1204105779,
 123215,
 1204897822,
 1198880298,
 -1,
 1204963321,
 1204844303,
 -1,
 1205028855,
 1204898753,
 -1,
 1205094360,
 1204980780,
 2002,
 1205159894,
 1205070239,
 2018,
 -1,
 1205079685,
 2023,
 1205338111,
 1205082502,
 2019,
 -1,
 1205210757,
 2016,
 1205422046,
 1205039629,
 -1,
 1205487581,
 1205377085,
 -1,
 -47141,
 1205448000,
 2026,
 -47140,
 1205498411,
 2024,
 -1,
 1205547119,
 2025,
 -1,
 1205410182,
 2006,
 1205815265,
 1205382342,
 -1,
 -47136,
 1205775680,
 2010,
 -1,
 1205803398,
 2009,
 1206011875,
 1205769239,
 2000,
 -1,
 1205965847,
 1999,
 1206142949,
 1205944830,
 1997,
 -1,
 1206075902,
 1995,
 1206274023,
 1206073756,
 2008,
 -1,
 1206212162,
 2001,
 -47128,
 1206249887,
 2022,
 -47127,
 1206378747,
 2021,
 -47126,
 1206440858,
 1998,
 -47125,
 1206503463,
 2005,
 -47124,
 1206565590,
 2011,
 -47123,
 1206625035,
 2004,
 -47122,
 1206682569,
 2017,
 -47121,
 1206744921,
 2015,
 -47120,
 1206809483,
 2014,
 -47119,
 1206870957,
 1996,
 -47118,
 1206934045,
 2020,
 -47117,
 1206998566,
 2012,
 -47116,
 1207062246,
 2013,
 -47115,
 1207119983,
 2007,
 -47114,
 1207183248,
 2003,
 -1,
 1207245190,
 1994,
 -47112,
 1204986370,
 2037,
 -1,
 1207377501,
 2042,
 1207584778,
 1204893965,
 -1,
 1207650312,
 1207527266,
 -1,
 1207715838,
 1207617441,
 -1,
 -47107,
 1207690774,
 1986,
 -1,
 1207722464,
 1987,
 1207912449,
 1207679489,
 -1,
 -47104,
 1207857520,
 1990,
 -1,
 1207913621,
 1991,
 1208109060,
 1207848593,
 -1,
 -47101,
 1208065789,
 1988,
 -1,
 1208119486,
 1989,
 -47099,
 1208085787,
 1984,
 -47098,
 1208260693,
 1985,
 -47097,
 1208324168,
 1993,
 -1,
 1208370822,
 1992,
 -47095,
 1207606553,
 2046,
 -1,
 1208492541,
 2045,
 1208698904,
 1207514204,
 -1,
 1208764439,
 1208625784,
 -1,
 1208829969,
 1208713421,
 -1,
 -47090,
 1208792771,
 2033,
 -47089,
 1208844803,
 2032,
 -47088,
 1208901370,
 2031,
 -1,
 1208957811,
 2030,
 1209157653,
 1208794851,
 -1,
 -47085,
 1209120451,
 2029,
 -47084,
 1209172483,
 2028,
 -1,
 1209229050,
 2027,
 -47082,
 1209109743,
 2034,
 -1,
 1209351967,
 2035,
 -1,
 1208714185,
 2040,
 1209616411,
 1208665957,
 -1,
 -47078,
 1209571904,
 2038,
 -1,
 1209620010,
 2039,
 -47076,
 1209583866,
 2047,
 -47075,
 1209753348,
 2036,
 -1,
 1209814394,
 2041,
 1210009696,
 1204851735,
 -1,
 1210075207,
 1209969862,
 -1,
 1210140742,
 1210043070,
 -1,
 1210206277,
 1210056704,
 -1,
 1210271793,
 1210149345,
 -1,
 1210337324,
 1210209204,
 -1,
 1210402857,
 1210292313,
 -1,
 -47066,
 1210368179,
 43059,
 -47065,
 1210428377,
 43056,
 -47064,
 1210473145,
 43057,
 -1,
 1210533575,
 43060,
 1210777599,
 1210371020,
 -1,
 -47061,
 1210695869,
 43061,
 -1,
 1210756120,
 43058,
 1210927151,
 1210297210,
 -1,
 -47058,
 1210890524,
 43062,
 -1,
 1210946322,
 43065,
 -47056,
 1210890670,
 43064,
 -1,
 1211082450,
 43063,
 1211254843,
 1210245758,
 -1,
 1211320374,
 1211213812,
 -1,
 -47052,
 1211293455,
 128600,
 -47051,
 1211333266,
 128592,
 -1,
 1211378962,
 128608,
 1211582520,
 1211289666,
 11110,
 -1,
 1211501331,
 11126,
 -47047,
 1211556598,
 11009,
 -47046,
 1211677572,
 129108,
 -1,
 1211706087,
 11017,
 1211957247,
 1211188097,
 -1,
 1211975744,
 1211869172,
 -1,
 -47042,
 1211948815,
 128602,
 -47041,
 1211988626,
 128594,
 -1,
 1212034322,
 128610,
 1212237890,
 1211945026,
 11111,
 -1,
 1212156691,
 11127,
 -47037,
 1212211958,
 11008,
 -47036,
 1212332932,
 129109,
 -1,
 1212361447,
 11016,
 -1,
 1210139561,
 128746,
 -1,
 1210072136,
 8379,
 1212696659,
 1209991168,
 -1,
 1212762187,
 1212654255,
 -1,
 -47030,
 1212706358,
 128370,
 -1,
 1212761294,
 128695,
 1212958797,
 1212696880,
 9940,
 -1,
 1212877098,
 128683,
 1213089872,
 1212884831,
 -1,
 -47025,
 1213050798,
 983126,
 -1,
 1213097276,
 128691,
 -47023,
 1213055577,
 128685,
 -47022,
 1213241615,
 128286,
 -1,
 1213303287,
 128245,
 1213483101,
 1212663713,
 -1,
 1213548634,
 1213415934,
 128456,
 1213614167,
 1213475825,
 128211,
 -1,
 1213533162,
 128212,
 1213792255,
 1213531882,
 -1,
 -47015,
 1213683304,
 128457,
 -1,
 1213741325,
 128458,
 1213988863,
 1213477094,
 -1,
 -47012,
 1213903889,
 128324,
 -1,
 1213954923,
 128323,
 -47010,
 1213447193,
 128067,
 -47009,
 1214090327,
 128689,
 -1,
 1214155172,
 65934,
 1214335075,
 1209935711,
 -1,
 -47006,
 1214300899,
 983196,
 -1,
 1214339595,
 983127,
 -47004,
 1214287135,
 983227,
 -47003,
 1214478095,
 983066,
 -1,
 1214539530,
 127747,
 1214729269,
 1137105840,
 -1,
 1214794437,
 1214650758,
 -1,
 1214859715,
 1214735279,
 -1,
 1214925234,
 1214826295,
 -1,
 1214990751,
 1214873581,
 -1,
 1215056030,
 1214942252,
 -1,
 1215121529,
 1214993608,
 42507,
 1215187062,
 1215059144,
 -1,
 1215252593,
 1215119870,
 42500,
 -46992,
 1215204396,
 42501,
 -1,
 1215250942,
 42271,
 1215449203,
 1215206423,
 42460,
 -1,
 1215403031,
 42384,
 -46988,
 1215419290,
 42421,
 -46987,
 1215521709,
 42308,
 -1,
 1215568262,
 42348,
 -46985,
 1215141818,
 42428,
 -46984,
 1215711175,
 42467,
 -1,
 1215766597,
 42315,
 1215973511,
 1215052045,
 -1,
 1216039042,
 1215927319,
 42450,
 1216104577,
 1215986195,
 -1,
 -46979,
 1216070332,
 42514,
 -46978,
 1216119753,
 42538,
 -46977,
 1216181131,
 42513,
 -46976,
 1216237286,
 42512,
 -1,
 1216298258,
 42539,
 -1,
 1216058391,
 42374,
 1216563332,
 1215971838,
 42490,
 -1,
 1216496126,
 42261,
 -46971,
 1216533402,
 42411,
 -46970,
 1216635821,
 42298,
 -1,
 1216682374,
 42337,
 1216891023,
 1215949092,
 -1,
 1216956554,
 1216844823,
 42464,
 -1,
 1216910359,
 42388,
 1217087628,
 1216889342,
 42506,
 -1,
 1217020414,
 42275,
 -46963,
 1217057690,
 42425,
 -46962,
 1217160109,
 42312,
 -1,
 1217206662,
 42352,
 1217415319,
 1216836109,
 -1,
 1217480850,
 1217369111,
 42457,
 -1,
 1217434647,
 42381,
 1217611924,
 1217413630,
 42497,
 -1,
 1217544702,
 42268,
 -46955,
 1217581978,
 42418,
 -46954,
 1217684397,
 42305,
 -1,
 1217730950,
 42344,
 1217939609,
 1217369111,
 42463,
 -1,
 1217893399,
 42387,
 1218070683,
 1217872382,
 42505,
 -1,
 1218003454,
 42274,
 -46948,
 1218040730,
 42424,
 -46947,
 1218143149,
 42311,
 -1,
 1218189702,
 42351,
 1218398390,
 1215005555,
 -1,
 1218463911,
 1218336291,
 -1,
 1218529442,
 1218417687,
 42438,
 -1,
 1218483223,
 42363,
 1218660516,
 1218462206,
 42478,
 -1,
 1218593278,
 42250,
 -46939,
 1218630554,
 42400,
 -46938,
 1218732973,
 42287,
 -1,
 1218779526,
 42326,
 1218988207,
 1218389855,
 -1,
 1219053738,
 1218941975,
 42436,
 -1,
 1219007511,
 42361,
 1219184812,
 1218986494,
 42475,
 -1,
 1219117566,
 42248,
 -46931,
 1219154842,
 42398,
 -46930,
 1219257261,
 42285,
 -1,
 1219303814,
 42323,
 1219512497,
 1218941975,
 42462,
 -1,
 1219466263,
 42386,
 1219643571,
 1219445246,
 42504,
 -1,
 1219576318,
 42273,
 -46924,
 1219613594,
 42423,
 -46923,
 1219716013,
 42310,
 -1,
 1219762566,
 42350,
 1219971278,
 1218328845,
 -1,
 1220036807,
 1219910155,
 -1,
 1220102336,
 1219975691,
 -1,
 1220167867,
 1220056087,
 42446,
 -1,
 1220121623,
 42370,
 1220298941,
 1220100606,
 42486,
 -1,
 1220231678,
 42257,
 -46914,
 1220268954,
 42407,
 -46913,
 1220371373,
 42294,
 -1,
 1220417926,
 42333,
 1220626626,
 1220056087,
 42445,
 -1,
 1220580375,
 42369,
 1220757700,
 1220559358,
 42485,
 -1,
 1220690430,
 42256,
 -46907,
 1220727706,
 42406,
 -46906,
 1220830125,
 42293,
 -1,
 1220876678,
 42332,
 1221085385,
 1219990551,
 42449,
 -1,
 1221039127,
 42373,
 1221216459,
 1221018110,
 42489,
 -1,
 1221149182,
 42260,
 -46900,
 1221186458,
 42410,
 -46899,
 1221288877,
 42297,
 -1,
 1221335430,
 42336,
 1221544161,
 1219916601,
 -1,
 1221609689,
 1221501615,
 -1,
 1221675219,
 1221542398,
 42476,
 -46894,
 1221626924,
 42477,
 -1,
 1221673470,
 42249,
 1221871829,
 1221628951,
 42437,
 -1,
 1221825559,
 42362,
 1222002903,
 1221794182,
 42324,
 -1,
 1221954604,
 42325,
 -46888,
 1221972890,
 42399,
 -1,
 1222075309,
 42286,
 1222265051,
 1221563415,
 42459,
 -1,
 1222218775,
 42383,
 1222396125,
 1222197758,
 42499,
 -1,
 1222328830,
 42270,
 1222527199,
 1222318470,
 42346,
 -1,
 1222478892,
 42347,
 -46880,
 1222497178,
 42420,
 -1,
 1222599597,
 42307,
 1222789364,
 1221481672,
 -1,
 1222854892,
 1222715231,
 -1,
 1222920422,
 1222808599,
 42439,
 -46875,
 1222874135,
 42364,
 -1,
 1222937644,
 42440,
 1223117033,
 1222853118,
 42479,
 -46872,
 1223068716,
 42480,
 -1,
 1223115262,
 42251,
 -46870,
 1223087002,
 42401,
 -46869,
 1223254957,
 42288,
 -1,
 1223301510,
 42327,
 1223510255,
 1222787582,
 42502,
 -46866,
 1223461932,
 42503,
 -1,
 1223508478,
 42272,
 1223706865,
 1223463959,
 42461,
 -1,
 1223660567,
 42385,
 -46862,
 1223676826,
 42422,
 -46861,
 1223779245,
 42309,
 -1,
 1223825798,
 42349,
 1224034564,
 1222765616,
 -1,
 1224100093,
 1223973387,
 -1,
 1224165624,
 1224053783,
 42454,
 -1,
 1224119319,
 42378,
 1224296698,
 1224098302,
 42494,
 -1,
 1224229374,
 42265,
 -46853,
 1224266650,
 42415,
 -46852,
 1224369069,
 42302,
 -1,
 1224415622,
 42341,
 1224624383,
 1224053783,
 42453,
 -1,
 1224578071,
 42377,
 1224755457,
 1224557054,
 42493,
 -1,
 1224688126,
 42264,
 -46846,
 1224725402,
 42414,
 -46845,
 1224827821,
 42301,
 -1,
 1224874374,
 42340,
 1225083155,
 1224007867,
 -1,
 1225148681,
 1225036823,
 42431,
 1225214216,
 1225102359,
 42356,
 -1,
 1225165868,
 42357,
 -1,
 1225165868,
 42432,
 1225410829,
 1225081342,
 42470,
 1225476364,
 1225343486,
 42243,
 -1,
 1225428012,
 42244,
 -1,
 1225428012,
 42471,
 1225672975,
 1225380762,
 42393,
 -1,
 1225624620,
 42394,
 1225804049,
 1225614253,
 42280,
 -1,
 1225755692,
 42281,
 1225981951,
 1225726342,
 42318,
 -1,
 1225886764,
 42319,
 1226066211,
 1225050017,
 -1,
 1226131740,
 1226005003,
 -1,
 1226197271,
 1226085399,
 42444,
 -1,
 1226150935,
 42368,
 1226328345,
 1226129918,
 42484,
 -1,
 1226260990,
 42255,
 -46822,
 1226298266,
 42405,
 -46821,
 1226400685,
 42292,
 -1,
 1226447238,
 42331,
 1226656030,
 1226085399,
 42443,
 -1,
 1226609687,
 42367,
 1226787104,
 1226588670,
 42483,
 -1,
 1226719742,
 42254,
 -46815,
 1226757018,
 42404,
 -46814,
 1226859437,
 42291,
 -1,
 1226905990,
 42330,
 1227114803,
 1226029569,
 -1,
 1227180332,
 1227053579,
 -1,
 1227245863,
 1227133975,
 42452,
 -1,
 1227199511,
 42376,
 1227376937,
 1227178494,
 42492,
 -1,
 1227309566,
 42263,
 -46806,
 1227346842,
 42413,
 -46805,
 1227449261,
 42300,
 -1,
 1227495814,
 42339,
 1227704622,
 1227133975,
 42451,
 -1,
 1227658263,
 42375,
 1227835696,
 1227637246,
 42491,
 -1,
 1227768318,
 42262,
 -46799,
 1227805594,
 42412,
 -46798,
 1227908013,
 42299,
 -1,
 1227954566,
 42338,
 1228163395,
 1227040607,
 -1,
 1228228924,
 1228102155,
 -1,
 1228294455,
 1228182551,
 42434,
 -1,
 1228248087,
 42359,
 1228425529,
 1228227070,
 42473,
 -1,
 1228358142,
 42246,
 -46790,
 1228395418,
 42396,
 -46789,
 1228497837,
 42283,
 -1,
 1228544390,
 42321,
 1228753214,
 1228182551,
 42435,
 -1,
 1228706839,
 42360,
 1228884288,
 1228685822,
 42474,
 -1,
 1228816894,
 42247,
 -46783,
 1228854170,
 42397,
 -46782,
 1228956589,
 42284,
 -1,
 1229003142,
 42322,
 1229211984,
 1228102155,
 -1,
 1229277511,
 1229165591,
 42429,
 -46778,
 1229231127,
 42355,
 -1,
 1229294636,
 42430,
 1229474122,
 1229210110,
 42468,
 -46775,
 1229425708,
 42469,
 -1,
 1229472254,
 42242,
 1229670732,
 1229443994,
 42391,
 -1,
 1229622316,
 42392,
 1229801806,
 1229611949,
 42278,
 -1,
 1229753388,
 42279,
 1229979647,
 1229724038,
 42316,
 -1,
 1229884460,
 42317,
 1230063961,
 1229158159,
 -1,
 1230129492,
 1229996542,
 42487,
 -46765,
 1230082015,
 42508,
 -1,
 1230127614,
 42258,
 1230326102,
 1230083095,
 42447,
 -1,
 1230279703,
 42371,
 -46761,
 1230295962,
 42408,
 -46760,
 1230398381,
 42295,
 -1,
 1230444934,
 42334,
 1230653793,
 1230039332,
 -1,
 1230719324,
 1230607383,
 42458,
 -1,
 1230672919,
 42382,
 1230850398,
 1230651902,
 42498,
 -1,
 1230782974,
 42269,
 -46753,
 1230820250,
 42419,
 -46752,
 1230922669,
 42306,
 -1,
 1230969222,
 42345,
 1231178089,
 1230625712,
 -1,
 1231243620,
 1231131671,
 42442,
 -1,
 1231197207,
 42366,
 1231374694,
 1231176190,
 42482,
 -1,
 1231307262,
 42253,
 -46745,
 1231344538,
 42403,
 -46744,
 1231446957,
 42290,
 -1,
 1231493510,
 42329,
 1231702385,
 1231137990,
 -1,
 1231767916,
 1231655959,
 42448,
 -1,
 1231721495,
 42372,
 1231898990,
 1231700478,
 42488,
 -1,
 1231831550,
 42259,
 -46737,
 1231868826,
 42409,
 -46736,
 1231971245,
 42296,
 -1,
 1232017798,
 42335,
 1232226681,
 1231659695,
 -1,
 1232292212,
 1232180247,
 42433,
 -1,
 1232245783,
 42358,
 1232423286,
 1232224766,
 42472,
 -1,
 1232355838,
 42245,
 -46729,
 1232393114,
 42395,
 -46728,
 1232495533,
 42282,
 -1,
 1232542086,
 42320,
 1232750977,
 1232171533,
 -1,
 1232816508,
 1232704535,
 42456,
 -1,
 1232770071,
 42380,
 1232947582,
 1232749054,
 42496,
 -1,
 1232880126,
 42267,
 -46721,
 1232917402,
 42417,
 -46720,
 1233019821,
 42304,
 -1,
 1233066374,
 42343,
 1233275273,
 1232686737,
 -1,
 1233340804,
 1233228823,
 42441,
 -1,
 1233294359,
 42365,
 1233471878,
 1233273342,
 42481,
 -1,
 1233404414,
 42252,
 -46713,
 1233441690,
 42402,
 -46712,
 1233544109,
 42289,
 -1,
 1233590662,
 42328,
 1233799569,
 1233202595,
 -1,
 1233865100,
 1233753111,
 42455,
 -1,
 1233818647,
 42379,
 1233996174,
 1233797630,
 42495,
 -1,
 1233928702,
 42266,
 -46705,
 1233965978,
 42416,
 -46704,
 1234068397,
 42303,
 -1,
 1234114950,
 42342,
 1234323861,
 1233753111,
 42426,
 1234389396,
 1234277399,
 42353,
 -1,
 1234340908,
 42354,
 -1,
 1234340908,
 42427,
 1234586009,
 1234256382,
 42465,
 1234651544,
 1234518526,
 42240,
 -1,
 1234603052,
 42241,
 -1,
 1234603052,
 42466,
 1234848155,
 1234555802,
 42389,
 -1,
 1234799660,
 42390,
 1234979229,
 1234789293,
 42276,
 -1,
 1234930732,
 42277,
 1235156991,
 1234901382,
 42313,
 -1,
 1235061804,
 42314,
 1235288063,
 1214940768,
 -1,
 1235306916,
 1235208097,
 -1,
 -46686,
 1235261767,
 42525,
 -46685,
 1235315251,
 42517,
 -1,
 1235360331,
 42521,
 1235569065,
 1235237133,
 -1,
 1235634600,
 1235522583,
 -1,
 -46681,
 1235589447,
 42523,
 -1,
 1235619709,
 42526,
 -1,
 1235558738,
 42522,
 1235896748,
 1235514169,
 -1,
 -46677,
 1235867577,
 42524,
 -1,
 1235895652,
 42516,
 1236093359,
 1235832465,
 -1,
 -46674,
 1236026724,
 42515,
 -1,
 1236081227,
 42520,
 -46672,
 1236045880,
 42518,
 -46671,
 1236235000,
 42527,
 -1,
 1236281379,
 42519,
 1236486592,
 1214856291,
 -1,
 1236552118,
 1236453281,
 -1,
 -46667,
 1236526614,
 42530,
 -1,
 1236558304,
 42531,
 1236748729,
 1236515329,
 -1,
 -46664,
 1236693360,
 42534,
 -1,
 1236749461,
 42535,
 1236945340,
 1236684433,
 -1,
 -46661,
 1236901629,
 42532,
 -1,
 1236955326,
 42533,
 -46659,
 1236921627,
 42528,
 -46658,
 1237096533,
 42529,
 -46657,
 1237160008,
 42537,
 -1,
 1237206662,
 42536,
 -46655,
 1236446315,
 42511,
 -46654,
 1237341367,
 42510,
 -1,
 1237398682,
 42509,
 1237600964,
 1214821111,
 -1,
 1237666355,
 1237520700,
 -1,
 1237731792,
 1237588180,
 917762,
 -46649,
 1237653716,
 917942,
 -46648,
 1237719075,
 917941,
 -46647,
 1237784387,
 917940,
 -46646,
 1237849715,
 917939,
 -46645,
 1237915006,
 917938,
 -46644,
 1237980330,
 917937,
 -46643,
 1238045580,
 917936,
 -46642,
 1238110823,
 917935,
 -46641,
 1238176060,
 917934,
 -1,
 1238241324,
 917933,
 1238452699,
 1237653539,
 917761,
 -46638,
 1238374612,
 917932,
 -46637,
 1238439971,
 917931,
 -46636,
 1238505283,
 917930,
 -46635,
 1238570611,
 917929,
 -46634,
 1238635902,
 917928,
 -46633,
 1238701226,
 917927,
 -46632,
 1238766476,
 917926,
 -46631,
 1238831719,
 917925,
 -46630,
 1238896956,
 917924,
 -1,
 1238962220,
 917923,
 1239173606,
 1238374211,
 917760,
 -46627,
 1239095508,
 917922,
 -46626,
 1239160867,
 917921,
 -46625,
 1239226179,
 917920,
 -46624,
 1239291507,
 917919,
 -46623,
 1239356798,
 917918,
 -46622,
 1239422122,
 917917,
 -46621,
 1239487372,
 917916,
 -46620,
 1239552615,
 917915,
 -46619,
 1239617852,
 917914,
 -1,
 1239683116,
 917913,
 1239894513,
 1239094899,
 -1,
 -46616,
 1239816404,
 917912,
 -46615,
 1239881763,
 917911,
 -46614,
 1239947075,
 917910,
 -46613,
 1240012403,
 917909,
 -46612,
 1240077694,
 917908,
 -46611,
 1240143018,
 917907,
 -46610,
 1240208268,
 917906,
 -46609,
 1240273511,
 917905,
 -46608,
 1240338748,
 917904,
 -1,
 1240404012,
 917903,
 1240615420,
 1239815550,
 -1,
 -46605,
 1240537300,
 917902,
 -46604,
 1240602659,
 917901,
 -46603,
 1240667971,
 917900,
 -46602,
 1240733299,
 917899,
 -46601,
 1240798590,
 917898,
 -46600,
 1240863914,
 917897,
 -46599,
 1240929164,
 917896,
 -46598,
 1240994407,
 917895,
 -46597,
 1241059644,
 917894,
 -1,
 1241124908,
 917893,
 1241336327,
 1240536234,
 -1,
 -46594,
 1241258196,
 917892,
 -46593,
 1241323555,
 917891,
 -46592,
 1241388867,
 917890,
 -46591,
 1241454195,
 917889,
 -46590,
 1241519486,
 917888,
 -46589,
 1241584810,
 917887,
 -46588,
 1241650060,
 917886,
 -46587,
 1241715303,
 917885,
 -46586,
 1241780540,
 917884,
 -1,
 1241845804,
 917883,
 1242057234,
 1241256844,
 -1,
 -46583,
 1241979092,
 917882,
 -46582,
 1242044451,
 917881,
 -46581,
 1242109763,
 917880,
 -46580,
 1242175091,
 917879,
 -46579,
 1242240382,
 917878,
 -46578,
 1242305706,
 917877,
 -46577,
 1242370956,
 917876,
 -46576,
 1242436199,
 917875,
 -46575,
 1242501436,
 917874,
 -1,
 1242566700,
 917873,
 1242778141,
 1241977447,
 -1,
 -46572,
 1242699988,
 917872,
 -46571,
 1242765347,
 917871,
 -46570,
 1242830659,
 917870,
 -46569,
 1242895987,
 917869,
 -46568,
 1242961278,
 917868,
 -46567,
 1243026602,
 917867,
 -46566,
 1243091852,
 917866,
 -46565,
 1243157095,
 917865,
 -46564,
 1243222332,
 917864,
 -1,
 1243287596,
 917863,
 1243499048,
 1242698044,
 -1,
 -46561,
 1243420884,
 917862,
 -46560,
 1243486243,
 917861,
 -46559,
 1243551555,
 917860,
 -46558,
 1243616883,
 917859,
 -46557,
 1243682174,
 917858,
 -46556,
 1243747498,
 917857,
 -46555,
 1243812748,
 917856,
 -46554,
 1243877991,
 917855,
 -46553,
 1243943228,
 917854,
 -1,
 1244008492,
 917853,
 1244266495,
 1243418668,
 -1,
 -46550,
 1244141780,
 917852,
 -46549,
 1244207139,
 917851,
 -46548,
 1244272451,
 917850,
 -46547,
 1244337779,
 917849,
 -46546,
 1244403070,
 917848,
 -46545,
 1244468394,
 917847,
 -46544,
 1244533644,
 917846,
 -46543,
 1244598887,
 917845,
 -46542,
 1244664124,
 917844,
 -1,
 1244729388,
 917843,
 1244940919,
 1237586535,
 -1,
 1245006399,
 1244861610,
 917767,
 -46538,
 1244928212,
 917992,
 -46537,
 1244993571,
 917991,
 -46536,
 1245058883,
 917990,
 -46535,
 1245124211,
 917989,
 -46534,
 1245189502,
 917988,
 -46533,
 1245254826,
 917987,
 -46532,
 1245320076,
 917986,
 -46531,
 1245385319,
 917985,
 -46530,
 1245450556,
 917984,
 -1,
 1245515820,
 917983,
 1245727306,
 1244926860,
 917766,
 -46527,
 1245649108,
 917982,
 -46526,
 1245714467,
 917981,
 -46525,
 1245779779,
 917980,
 -46524,
 1245845107,
 917979,
 -46523,
 1245910398,
 917978,
 -46522,
 1245975722,
 917977,
 -46521,
 1246040972,
 917976,
 -46520,
 1246106215,
 917975,
 -46519,
 1246171452,
 917974,
 -1,
 1246236716,
 917973,
 1246448213,
 1245647463,
 917765,
 -46516,
 1246370004,
 917972,
 -46515,
 1246435363,
 917971,
 -46514,
 1246500675,
 917970,
 -46513,
 1246566003,
 917969,
 -46512,
 1246631294,
 917968,
 -46511,
 1246696618,
 917967,
 -46510,
 1246761868,
 917966,
 -46509,
 1246827111,
 917965,
 -46508,
 1246892348,
 917964,
 -1,
 1246957612,
 917963,
 1247169120,
 1246368060,
 917764,
 -46505,
 1247090900,
 917962,
 -46504,
 1247156259,
 917961,
 -46503,
 1247221571,
 917960,
 -46502,
 1247286899,
 917959,
 -46501,
 1247352190,
 917958,
 -46500,
 1247417514,
 917957,
 -46499,
 1247482764,
 917956,
 -46498,
 1247548007,
 917955,
 -46497,
 1247613244,
 917954,
 -1,
 1247678508,
 917953,
 1247890027,
 1247088684,
 917763,
 -46494,
 1247811796,
 917952,
 -46493,
 1247877155,
 917951,
 -46492,
 1247942467,
 917950,
 -46491,
 1248007795,
 917949,
 -46490,
 1248073086,
 917948,
 -46489,
 1248138410,
 917947,
 -46488,
 1248203660,
 917946,
 -46487,
 1248268903,
 917945,
 -46486,
 1248334140,
 917944,
 -1,
 1248399404,
 917943,
 1248610931,
 1247810942,
 917768,
 -46483,
 1248532083,
 917999,
 -46482,
 1248597374,
 917998,
 -46481,
 1248662698,
 917997,
 -46480,
 1248727948,
 917996,
 -46479,
 1248793191,
 917995,
 -46478,
 1248858428,
 917994,
 -1,
 1248923692,
 917993,
 -46476,
 1248532692,
 917772,
 -46475,
 1249056803,
 917771,
 -46474,
 1249122115,
 917770,
 -1,
 1249187443,
 917769,
 1249397378,
 1244862676,
 -1,
 -46471,
 1249319124,
 917842,
 -46470,
 1249384483,
 917841,
 -46469,
 1249449795,
 917840,
 -46468,
 1249515123,
 917839,
 -46467,
 1249580414,
 917838,
 -46466,
 1249645738,
 917837,
 -46465,
 1249710988,
 917836,
 -46464,
 1249776231,
 917835,
 -46463,
 1249841468,
 917834,
 -1,
 1249906732,
 917833,
 1250118285,
 1249318947,
 -1,
 -46460,
 1250040020,
 917832,
 -46459,
 1250105379,
 917831,
 -46458,
 1250170691,
 917830,
 -46457,
 1250236019,
 917829,
 -46456,
 1250301310,
 917828,
 -46455,
 1250366634,
 917827,
 -46454,
 1250431884,
 917826,
 -46453,
 1250497127,
 917825,
 -46452,
 1250562364,
 917824,
 -1,
 1250627628,
 917823,
 1250839192,
 1250039619,
 -1,
 -46449,
 1250760916,
 917822,
 -46448,
 1250826275,
 917821,
 -46447,
 1250891587,
 917820,
 -46446,
 1250956915,
 917819,
 -46445,
 1251022206,
 917818,
 -46444,
 1251087530,
 917817,
 -46443,
 1251152780,
 917816,
 -46442,
 1251218023,
 917815,
 -46441,
 1251283260,
 917814,
 -1,
 1251348524,
 917813,
 1251560099,
 1250760307,
 -1,
 -46438,
 1251481812,
 917812,
 -46437,
 1251547171,
 917811,
 -46436,
 1251612483,
 917810,
 -46435,
 1251677811,
 917809,
 -46434,
 1251743102,
 917808,
 -46433,
 1251808426,
 917807,
 -46432,
 1251873676,
 917806,
 -46431,
 1251938919,
 917805,
 -46430,
 1252004156,
 917804,
 -1,
 1252069420,
 917803,
 1252281006,
 1251480958,
 -1,
 -46427,
 1252202708,
 917802,
 -46426,
 1252268067,
 917801,
 -46425,
 1252333379,
 917800,
 -46424,
 1252398707,
 917799,
 -46423,
 1252463998,
 917798,
 -46422,
 1252529322,
 917797,
 -46421,
 1252594572,
 917796,
 -46420,
 1252659815,
 917795,
 -46419,
 1252725052,
 917794,
 -1,
 1252790316,
 917793,
 1253001913,
 1252201642,
 -1,
 -46416,
 1252923604,
 917792,
 -46415,
 1252988963,
 917791,
 -46414,
 1253054275,
 917790,
 -46413,
 1253119603,
 917789,
 -46412,
 1253184894,
 917788,
 -46411,
 1253250218,
 917787,
 -46410,
 1253315468,
 917786,
 -46409,
 1253380711,
 917785,
 -46408,
 1253445948,
 917784,
 -1,
 1253511212,
 917783,
 1253769215,
 1252922252,
 -1,
 -46405,
 1253644500,
 917782,
 -46404,
 1253709859,
 917781,
 -46403,
 1253775171,
 917780,
 -46402,
 1253840499,
 917779,
 -46401,
 1253905790,
 917778,
 -46400,
 1253971114,
 917777,
 -46399,
 1254036364,
 917776,
 -46398,
 1254101607,
 917775,
 -46397,
 1254166844,
 917774,
 -1,
 1254232108,
 917773,
 -1,
 1237551883,
 129499,
 1254509510,
 1214757377,
 -1,
 1254574901,
 1254428988,
 983240,
 1254640338,
 1254496468,
 983270,
 -46391,
 1254562004,
 983450,
 -46390,
 1254627363,
 983449,
 -46389,
 1254692675,
 983448,
 -46388,
 1254758003,
 983447,
 -46387,
 1254823294,
 983446,
 -46386,
 1254888618,
 983445,
 -46385,
 1254953868,
 983444,
 -46384,
 1255019111,
 983443,
 -46383,
 1255084348,
 983442,
 -1,
 1255149612,
 983441,
 1255361245,
 1254561827,
 983269,
 -46380,
 1255282900,
 983440,
 -46379,
 1255348259,
 983439,
 -46378,
 1255413571,
 983438,
 -46377,
 1255478899,
 983437,
 -46376,
 1255544190,
 983436,
 -46375,
 1255609514,
 983435,
 -46374,
 1255674764,
 983434,
 -46373,
 1255740007,
 983433,
 -46372,
 1255805244,
 983432,
 -1,
 1255870508,
 983431,
 1256082152,
 1255282499,
 983268,
 -46369,
 1256003796,
 983430,
 -46368,
 1256069155,
 983429,
 -46367,
 1256134467,
 983428,
 -46366,
 1256199795,
 983427,
 -46365,
 1256265086,
 983426,
 -46364,
 1256330410,
 983425,
 -46363,
 1256395660,
 983424,
 -46362,
 1256460903,
 983423,
 -46361,
 1256526140,
 983422,
 -1,
 1256591404,
 983421,
 1256803059,
 1256003187,
 983255,
 -46358,
 1256724692,
 983420,
 -46357,
 1256790051,
 983419,
 -46356,
 1256855363,
 983418,
 -46355,
 1256920691,
 983417,
 -46354,
 1256985982,
 983416,
 -46353,
 1257051306,
 983415,
 -46352,
 1257116556,
 983414,
 -46351,
 1257181799,
 983413,
 -46350,
 1257247036,
 983412,
 -1,
 1257312300,
 983411,
 1257523966,
 1256723838,
 983254,
 -46347,
 1257445588,
 983410,
 -46346,
 1257510947,
 983409,
 -46345,
 1257576259,
 983408,
 -46344,
 1257641587,
 983407,
 -46343,
 1257706878,
 983406,
 -46342,
 1257772202,
 983405,
 -46341,
 1257837452,
 983404,
 -46340,
 1257902695,
 983403,
 -46339,
 1257967932,
 983402,
 -1,
 1258033196,
 983401,
 1258244873,
 1257444522,
 983253,
 -46336,
 1258166484,
 983400,
 -46335,
 1258231843,
 983399,
 -46334,
 1258297155,
 983398,
 -46333,
 1258362483,
 983397,
 -46332,
 1258427774,
 983396,
 -46331,
 1258493098,
 983395,
 -46330,
 1258558348,
 983394,
 -46329,
 1258623591,
 983393,
 -46328,
 1258688828,
 983392,
 -1,
 1258754092,
 983391,
 1258965780,
 1258165132,
 983252,
 -46325,
 1258887380,
 983390,
 -46324,
 1258952739,
 983389,
 -46323,
 1259018051,
 983388,
 -46322,
 1259083379,
 983387,
 -46321,
 1259148670,
 983386,
 -46320,
 1259213994,
 983385,
 -46319,
 1259279244,
 983384,
 -46318,
 1259344487,
 983383,
 -46317,
 1259409724,
 983382,
 -1,
 1259474988,
 983381,
 1259686687,
 1258885735,
 983251,
 -46314,
 1259608276,
 983380,
 -46313,
 1259673635,
 983379,
 -46312,
 1259738947,
 983378,
 -46311,
 1259804275,
 983377,
 -46310,
 1259869566,
 983376,
 -46309,
 1259934890,
 983375,
 -46308,
 1260000140,
 983374,
 -46307,
 1260065383,
 983373,
 -46306,
 1260130620,
 983372,
 -1,
 1260195884,
 983371,
 1260407594,
 1259606332,
 983250,
 -46303,
 1260329172,
 983370,
 -46302,
 1260394531,
 983369,
 -46301,
 1260459843,
 983368,
 -46300,
 1260525171,
 983367,
 -46299,
 1260590462,
 983366,
 -46298,
 1260655786,
 983365,
 -46297,
 1260721036,
 983364,
 -46296,
 1260786279,
 983363,
 -46295,
 1260851516,
 983362,
 -1,
 1260916780,
 983361,
 1261174783,
 1260326956,
 983249,
 -46292,
 1261050068,
 983360,
 -46291,
 1261115427,
 983359,
 -46290,
 1261180739,
 983358,
 -46289,
 1261246067,
 983357,
 -46288,
 1261311358,
 983356,
 -46287,
 1261376682,
 983355,
 -46286,
 1261441932,
 983354,
 -46285,
 1261507175,
 983353,
 -46284,
 1261572412,
 983352,
 -1,
 1261637676,
 983351,
 1261849465,
 1254494823,
 983241,
 1261914945,
 1261769898,
 983275,
 -46280,
 1261836500,
 983500,
 -46279,
 1261901859,
 983499,
 -46278,
 1261967171,
 983498,
 -46277,
 1262032499,
 983497,
 -46276,
 1262097790,
 983496,
 -46275,
 1262163114,
 983495,
 -46274,
 1262228364,
 983494,
 -46273,
 1262293607,
 983493,
 -46272,
 1262358844,
 983492,
 -1,
 1262424108,
 983491,
 1262635852,
 1261835148,
 983274,
 -46269,
 1262557396,
 983490,
 -46268,
 1262622755,
 983489,
 -46267,
 1262688067,
 983488,
 -46266,
 1262753395,
 983487,
 -46265,
 1262818686,
 983486,
 -46264,
 1262884010,
 983485,
 -46263,
 1262949260,
 983484,
 -46262,
 1263014503,
 983483,
 -46261,
 1263079740,
 983482,
 -1,
 1263145004,
 983481,
 1263356759,
 1262555751,
 983273,
 -46258,
 1263278292,
 983480,
 -46257,
 1263343651,
 983479,
 -46256,
 1263408963,
 983478,
 -46255,
 1263474291,
 983477,
 -46254,
 1263539582,
 983476,
 -46253,
 1263604906,
 983475,
 -46252,
 1263670156,
 983474,
 -46251,
 1263735399,
 983473,
 -46250,
 1263800636,
 983472,
 -1,
 1263865900,
 983471,
 1264077666,
 1263276348,
 983272,
 -46247,
 1263999188,
 983470,
 -46246,
 1264064547,
 983469,
 -46245,
 1264129859,
 983468,
 -46244,
 1264195187,
 983467,
 -46243,
 1264260478,
 983466,
 -46242,
 1264325802,
 983465,
 -46241,
 1264391052,
 983464,
 -46240,
 1264456295,
 983463,
 -46239,
 1264521532,
 983462,
 -1,
 1264586796,
 983461,
 1264798573,
 1263996972,
 983271,
 -46236,
 1264720084,
 983460,
 -46235,
 1264785443,
 983459,
 -46234,
 1264850755,
 983458,
 -46233,
 1264916083,
 983457,
 -46232,
 1264981374,
 983456,
 -46231,
 1265046698,
 983455,
 -46230,
 1265111948,
 983454,
 -46229,
 1265177191,
 983453,
 -46228,
 1265242428,
 983452,
 -1,
 1265307692,
 983451,
 1265519477,
 1264719230,
 983276,
 -46225,
 1265440371,
 983507,
 -46224,
 1265505662,
 983506,
 -46223,
 1265570986,
 983505,
 -46222,
 1265636236,
 983504,
 -46221,
 1265701479,
 983503,
 -46220,
 1265766716,
 983502,
 -1,
 1265831980,
 983501,
 -46218,
 1265440980,
 983280,
 -46217,
 1265965091,
 983279,
 -46216,
 1266030403,
 983278,
 -1,
 1266095731,
 983277,
 1266305924,
 1261770964,
 983248,
 -46213,
 1266227412,
 983350,
 -46212,
 1266292771,
 983349,
 -46211,
 1266358083,
 983348,
 -46210,
 1266423411,
 983347,
 -46209,
 1266488702,
 983346,
 -46208,
 1266554026,
 983345,
 -46207,
 1266619276,
 983344,
 -46206,
 1266684519,
 983343,
 -46205,
 1266749756,
 983342,
 -1,
 1266815020,
 983341,
 1267026831,
 1266227235,
 983247,
 -46202,
 1266948308,
 983340,
 -46201,
 1267013667,
 983339,
 -46200,
 1267078979,
 983338,
 -46199,
 1267144307,
 983337,
 -46198,
 1267209598,
 983336,
 -46197,
 1267274922,
 983335,
 -46196,
 1267340172,
 983334,
 -46195,
 1267405415,
 983333,
 -46194,
 1267470652,
 983332,
 -1,
 1267535916,
 983331,
 1267747738,
 1266947907,
 983246,
 -46191,
 1267669204,
 983330,
 -46190,
 1267734563,
 983329,
 -46189,
 1267799875,
 983328,
 -46188,
 1267865203,
 983327,
 -46187,
 1267930494,
 983326,
 -46186,
 1267995818,
 983325,
 -46185,
 1268061068,
 983324,
 -46184,
 1268126311,
 983323,
 -46183,
 1268191548,
 983322,
 -1,
 1268256812,
 983321,
 1268468645,
 1267668595,
 983245,
 -46180,
 1268390100,
 983320,
 -46179,
 1268455459,
 983319,
 -46178,
 1268520771,
 983318,
 -46177,
 1268586099,
 983317,
 -46176,
 1268651390,
 983316,
 -46175,
 1268716714,
 983315,
 -46174,
 1268781964,
 983314,
 -46173,
 1268847207,
 983313,
 -46172,
 1268912444,
 983312,
 -1,
 1268977708,
 983311,
 1269189552,
 1268389246,
 983244,
 -46169,
 1269110996,
 983310,
 -46168,
 1269176355,
 983309,
 -46167,
 1269241667,
 983308,
 -46166,
 1269306995,
 983307,
 -46165,
 1269372286,
 983306,
 -46164,
 1269437610,
 983305,
 -46163,
 1269502860,
 983304,
 -46162,
 1269568103,
 983303,
 -46161,
 1269633340,
 983302,
 -1,
 1269698604,
 983301,
 1269910459,
 1269109930,
 983243,
 -46158,
 1269831892,
 983300,
 -46157,
 1269897251,
 983299,
 -46156,
 1269962563,
 983298,
 -46155,
 1270027891,
 983297,
 -46154,
 1270093182,
 983296,
 -46153,
 1270158506,
 983295,
 -46152,
 1270223756,
 983294,
 -46151,
 1270288999,
 983293,
 -46150,
 1270354236,
 983292,
 -1,
 1270419500,
 983291,
 1270677503,
 1269830540,
 983242,
 -46147,
 1270552788,
 983290,
 -46146,
 1270618147,
 983289,
 -46145,
 1270683459,
 983288,
 -46144,
 1270748787,
 983287,
 -46143,
 1270814078,
 983286,
 -46142,
 1270879402,
 983285,
 -46141,
 1270944652,
 983284,
 -46140,
 1271009895,
 983283,
 -46139,
 1271075132,
 983282,
 -1,
 1271140396,
 983281,
 1271352352,
 1254441470,
 -1,
 1271417857,
 1271282755,
 -1,
 1271483366,
 1271381945,
 -1,
 1271548882,
 1271404934,
 -1,
 1271614416,
 1271501722,
 -1,
 1271679949,
 1271585746,
 7403,
 -1,
 1271598663,
 7404,
 -46130,
 1271649446,
 7409,
 -46129,
 1271736282,
 7402,
 -1,
 1271800304,
 7401,
 -46127,
 1271581975,
 7415,
 -1,
 1271967639,
 7410,
 1272138712,
 1271521064,
 -1,
 1272204245,
 1272108487,
 7395,
 -1,
 1272122951,
 7399,
 1272335319,
 1272128028,
 7397,
 -1,
 1272254023,
 7400,
 -1,
 1272301308,
 7394,
 1272531934,
 1272097990,
 -1,
 1272597468,
 1272466751,
 -1,
 -46117,
 1272567239,
 7396,
 -1,
 1272586780,
 7398,
 -46115,
 1272564486,
 7408,
 -1,
 1272749523,
 7411,
 -46113,
 1272506826,
 7380,
 -46112,
 1272895710,
 7414,
 -46111,
 1272958500,
 7405,
 -46110,
 1273008174,
 7379,
 -46109,
 1273069779,
 7407,
 -46108,
 1273131694,
 7413,
 -46107,
 1273191977,
 7406,
 -1,
 1273249420,
 7418,
 1273495551,
 1271451283,
 -1,
 1273514988,
 1273424318,
 -1,
 1273580522,
 1273459817,
 7383,
 -1,
 1273497844,
 7385,
 -46101,
 1273522456,
 7382,
 -1,
 1273634088,
 7381,
 1273842672,
 1273481121,
 -1,
 -46098,
 1273816654,
 7390,
 -46097,
 1273869957,
 7387,
 -1,
 1273913901,
 7391,
 1274104821,
 1273773330,
 -1,
 1274170356,
 1274074339,
 -1,
 -46093,
 1274136316,
 7386,
 -1,
 1274197381,
 7417,
 -1,
 1274136505,
 7389,
 1274432504,
 1274065595,
 -1,
 -46089,
 1274384216,
 7416,
 -1,
 1274436050,
 7392,
 1274629115,
 1274377099,
 -1,
 -46086,
 1274596054,
 7388,
 -1,
 1274657023,
 7376,
 1274825726,
 1274555992,
 -1,
 -46083,
 1274751306,
 7384,
 -1,
 1274813150,
 7412,
 -46081,
 1274789415,
 7377,
 -46080,
 1274980736,
 7378,
 -1,
 1275012553,
 7393,
 1275218975,
 1271377094,
 -1,
 1275284498,
 1275193638,
 -1,
 1275350033,
 1275223339,
 -1,
 1275415560,
 1275312641,
 -1,
 -46074,
 1275369194,
 128636,
 -46073,
 1275425159,
 128953,
 -1,
 1275469815,
 128941,
 1275677707,
 1275388655,
 -1,
 -46070,
 1275642717,
 128914,
 -1,
 1275671026,
 128904,
 1275874318,
 1275610764,
 -1,
 -46067,
 1275839305,
 128959,
 -1,
 1275897825,
 128976,
 -46065,
 1275834908,
 128637,
 -46064,
 1276008798,
 128934,
 -1,
 1276072278,
 128947,
 -1,
 1275276238,
 128933,
 1276379135,
 1275251895,
 -1,
 1276398618,
 1276299169,
 -1,
 1276464152,
 1276320385,
 -1,
 1276529687,
 1276434057,
 983069,
 -1,
 1276446994,
 983143,
 -1,
 1276445652,
 11135,
 -46055,
 1276423572,
 128678,
 -1,
 1276667901,
 11823,
 -46053,
 1276362903,
 11837,
 -46052,
 1276806279,
 9896,
 -46051,
 1276870426,
 9168,
 -46050,
 1276924686,
 8286,
 -1,
 1276979266,
 10186,
 -1,
 1275184251,
 9910,
 1277250600,
 1271322231,
 -1,
 1277316135,
 1277187549,
 -1,
 1277381670,
 1277270105,
 -1,
 -46044,
 1277348405,
 8530,
 -46043,
 1277410615,
 8528,
 -1,
 1277464752,
 8529,
 -1,
 1277357388,
 8585,
 -1,
 1277243047,
 11238,
 1277774896,
 1277191085,
 -1,
 1277840430,
 1277704979,
 -1,
 1277905965,
 1277755392,
 -1,
 -46036,
 1277842833,
 127918,
 -1,
 1277898294,
 128249,
 -1,
 1277832986,
 128252,
 -46033,
 1277794033,
 127931,
 -1,
 1278094473,
 128243,
 1278299186,
 1277740961,
 983070,
 -1,
 1278261761,
 983144,
 1278476287,
 1278252670,
 -1,
 -46028,
 1278377410,
 127952,
 -1,
 1278422690,
 127755,
 1278627792,
 1214667275,
 -1,
 1278692954,
 1278558718,
 -1,
 1278758287,
 1278644919,
 -1,
 1278823523,
 1278702393,
 -1,
 1278889030,
 1278745125,
 -1,
 1278954557,
 1278808380,
 110615,
 -46020,
 1278873916,
 110625,
 -1,
 1278939180,
 110624,
 -46018,
 1278899376,
 110626,
 -46017,
 1279072468,
 110623,
 -46016,
 1279137827,
 110622,
 -46015,
 1279203139,
 110621,
 -46014,
 1279268467,
 110620,
 -46013,
 1279333758,
 110619,
 -46012,
 1279399082,
 110618,
 -46011,
 1279464332,
 110617,
 -1,
 1279529575,
 110616,
 1279741007,
 1278829599,
 -1,
 -46008,
 1279662115,
 110634,
 -46007,
 1279727427,
 110633,
 -46006,
 1279792755,
 110632,
 -46005,
 1279858046,
 110631,
 -46004,
 1279923370,
 110630,
 -46003,
 1279988620,
 110629,
 -46002,
 1280053863,
 110628,
 -1,
 1280119100,
 110627,
 1280330839,
 1279710209,
 -1,
 -45999,
 1280251715,
 110641,
 -45998,
 1280317043,
 110640,
 -45997,
 1280382334,
 110639,
 -45996,
 1280447658,
 110638,
 -45995,
 1280512908,
 110637,
 -45994,
 1280578151,
 110636,
 -1,
 1280643388,
 110635,
 1280855134,
 1280262937,
 -1,
 -45991,
 1280775795,
 110647,
 -45990,
 1280841086,
 110646,
 -45989,
 1280906410,
 110645,
 -45988,
 1280971660,
 110644,
 -45987,
 1281036903,
 110643,
 -1,
 1281102140,
 110642,
 1281359871,
 1280808016,
 -1,
 -45984,
 1281258881,
 110651,
 -45983,
 1281299340,
 110650,
 -45982,
 1281364583,
 110649,
 -1,
 1281429820,
 110648,
 1281641613,
 1278761483,
 -1,
 1281707120,
 1281563173,
 -1,
 1281772648,
 1281626428,
 110750,
 -45977,
 1281691964,
 110760,
 -1,
 1281757228,
 110759,
 -45975,
 1281693908,
 110758,
 -45974,
 1281890339,
 110757,
 -45973,
 1281955651,
 110756,
 -45972,
 1282020979,
 110755,
 -45971,
 1282086270,
 110754,
 -45970,
 1282151594,
 110753,
 -45969,
 1282216844,
 110752,
 -1,
 1282282087,
 110751,
 1282493561,
 1281659984,
 -1,
 -45966,
 1282414627,
 110785,
 -45965,
 1282479939,
 110784,
 -45964,
 1282545267,
 110783,
 -45963,
 1282610558,
 110782,
 -45962,
 1282675882,
 110781,
 -45961,
 1282741132,
 110780,
 -45960,
 1282806375,
 110779,
 -1,
 1282871612,
 110778,
 1283083393,
 1282434079,
 -1,
 -45957,
 1283004227,
 110767,
 -45956,
 1283069555,
 110766,
 -45955,
 1283134846,
 110765,
 -45954,
 1283200170,
 110764,
 -45953,
 1283265420,
 110763,
 -45952,
 1283330663,
 110762,
 -1,
 1283395900,
 110761,
 1283607689,
 1283015449,
 -1,
 -45949,
 1283528515,
 110777,
 -45948,
 1283593843,
 110776,
 -45947,
 1283659134,
 110775,
 -45946,
 1283724458,
 110774,
 -45945,
 1283789708,
 110773,
 -45944,
 1283854951,
 110772,
 -1,
 1283920188,
 110771,
 1284177919,
 1283576833,
 -1,
 -45941,
 1284051852,
 110770,
 -45940,
 1284117095,
 110769,
 -1,
 1284182332,
 110768,
 1284394165,
 1281604097,
 -1,
 1284459671,
 1284363265,
 -1,
 -45936,
 1284380707,
 110673,
 -45935,
 1284446019,
 110672,
 -45934,
 1284511347,
 110671,
 -45933,
 1284576638,
 110670,
 -45932,
 1284641962,
 110669,
 -45931,
 1284707212,
 110668,
 -45930,
 1284772455,
 110667,
 -1,
 1284837692,
 110666,
 1285049504,
 1284381221,
 -1,
 -45927,
 1284970531,
 110659,
 -45926,
 1285035843,
 110658,
 -45925,
 1285101171,
 110657,
 -45924,
 1285166462,
 110656,
 -45923,
 1285231786,
 110655,
 -45922,
 1285297036,
 110654,
 -45921,
 1285362279,
 110653,
 -1,
 1285427516,
 110652,
 1285639336,
 1285002320,
 -1,
 -45918,
 1285560131,
 110685,
 -45917,
 1285625459,
 110684,
 -45916,
 1285690750,
 110683,
 -45915,
 1285756074,
 110682,
 -45914,
 1285821324,
 110681,
 -45913,
 1285886567,
 110680,
 -1,
 1285951804,
 110679,
 1286163631,
 1285579807,
 -1,
 -45910,
 1286084211,
 110665,
 -45909,
 1286149502,
 110664,
 -45908,
 1286214826,
 110663,
 -45907,
 1286280076,
 110662,
 -45906,
 1286345319,
 110661,
 -1,
 1286410556,
 110660,
 1286668287,
 1286095641,
 -1,
 -45903,
 1286542718,
 110678,
 -45902,
 1286608042,
 110677,
 -45901,
 1286673292,
 110676,
 -45900,
 1286738535,
 110675,
 -1,
 1286803772,
 110674,
 1287015646,
 1284344876,
 -1,
 1287081152,
 1286937125,
 -1,
 -45896,
 1287002324,
 110726,
 -45895,
 1287067683,
 110725,
 -45894,
 1287132995,
 110724,
 -45893,
 1287198323,
 110723,
 -45892,
 1287263614,
 110722,
 -45891,
 1287328938,
 110721,
 -45890,
 1287394188,
 110720,
 -45889,
 1287459431,
 110719,
 -1,
 1287524668,
 110718,
 1287736521,
 1287021599,
 -1,
 -45886,
 1287702898,
 110734,
 -45885,
 1287722819,
 110733,
 -45884,
 1287788147,
 110732,
 -45883,
 1287853438,
 110731,
 -45882,
 1287918762,
 110730,
 -45881,
 1287984012,
 110729,
 -45880,
 1288049255,
 110728,
 -1,
 1288114492,
 110727,
 1288326353,
 1287668505,
 -1,
 -45877,
 1288271399,
 110744,
 -45876,
 1288312435,
 110743,
 -45875,
 1288377726,
 110742,
 -45874,
 1288443050,
 110741,
 -45873,
 1288508300,
 110740,
 -45872,
 1288573543,
 110739,
 -1,
 1288638780,
 110738,
 1288850647,
 1288279120,
 -1,
 -45869,
 1288770942,
 110749,
 -45868,
 1288836266,
 110748,
 -45867,
 1288901516,
 110747,
 -45866,
 1288966759,
 110746,
 -1,
 1289031996,
 110745,
 1289243867,
 1288819713,
 -1,
 -45863,
 1289163660,
 110737,
 -45862,
 1289228903,
 110736,
 -1,
 1289294140,
 110735,
 1289551871,
 1289162597,
 -1,
 -45859,
 1289425511,
 110878,
 -1,
 1289490748,
 110877,
 1289702660,
 1286981537,
 -1,
 1289768169,
 1289634585,
 -1,
 -45855,
 1289689300,
 110710,
 -45854,
 1289754659,
 110709,
 -45853,
 1289819971,
 110708,
 -45852,
 1289885299,
 110707,
 -45851,
 1289950590,
 110706,
 -45850,
 1290015914,
 110705,
 -45849,
 1290081164,
 110704,
 -45848,
 1290146407,
 110703,
 -1,
 1290211644,
 110702,
 1290423537,
 1289720912,
 -1,
 -45845,
 1290382656,
 110717,
 -45844,
 1290409587,
 110716,
 -45843,
 1290474878,
 110715,
 -45842,
 1290540202,
 110714,
 -45841,
 1290605452,
 110713,
 -45840,
 1290670695,
 110712,
 -1,
 1290735932,
 110711,
 1290947833,
 1290363935,
 -1,
 -45837,
 1290868547,
 110696,
 -45836,
 1290933875,
 110695,
 -45835,
 1290999166,
 110694,
 -45834,
 1291064490,
 110693,
 -45833,
 1291129740,
 110692,
 -45832,
 1291194983,
 110691,
 -1,
 1291260220,
 110690,
 1291472127,
 1290916865,
 -1,
 -45829,
 1291439694,
 110701,
 -45828,
 1291457706,
 110700,
 -45827,
 1291522956,
 110699,
 -45826,
 1291588199,
 110698,
 -1,
 1291653436,
 110697,
 1291911167,
 1291393573,
 -1,
 -45823,
 1291785386,
 110689,
 -45822,
 1291850636,
 110688,
 -45821,
 1291915879,
 110687,
 -1,
 1291981116,
 110686,
 1292193061,
 1289661638,
 -1,
 1292258573,
 1292133407,
 -1,
 -45817,
 1292179267,
 110839,
 -45816,
 1292244595,
 110838,
 -45815,
 1292309886,
 110837,
 -45814,
 1292375210,
 110836,
 -45813,
 1292440460,
 110835,
 -45812,
 1292505703,
 110834,
 -1,
 1292570940,
 110833,
 1292782868,
 1292227585,
 -1,
 -45809,
 1292703347,
 110845,
 -45808,
 1292768638,
 110844,
 -45807,
 1292833962,
 110843,
 -45806,
 1292899212,
 110842,
 -45805,
 1292964455,
 110841,
 -1,
 1293029692,
 110840,
 1293241627,
 1292735568,
 -1,
 -45802,
 1293162099,
 110855,
 -45801,
 1293227390,
 110854,
 -45800,
 1293292714,
 110853,
 -45799,
 1293357964,
 110852,
 -45798,
 1293423207,
 110851,
 -1,
 1293488444,
 110850,
 1293700384,
 1293173529,
 -1,
 -45795,
 1293620394,
 110849,
 -45794,
 1293685644,
 110848,
 -45793,
 1293750887,
 110847,
 -1,
 1293816124,
 110846,
 1294073855,
 1293621797,
 -1,
 -45790,
 1293948074,
 110832,
 -45789,
 1294013324,
 110831,
 -45788,
 1294078567,
 110830,
 -1,
 1294143804,
 110829,
 1294355782,
 1292141427,
 -1,
 1294421294,
 1294296095,
 -1,
 -45784,
 1294341955,
 110799,
 -45783,
 1294407283,
 110798,
 -45782,
 1294472574,
 110797,
 -45781,
 1294537898,
 110796,
 -45780,
 1294603148,
 110795,
 -45779,
 1294668391,
 110794,
 -1,
 1294733628,
 110793,
 1294945590,
 1294342693,
 -1,
 -45776,
 1294866243,
 110792,
 -45775,
 1294931571,
 110791,
 -45774,
 1294996862,
 110790,
 -45773,
 1295062186,
 110789,
 -45772,
 1295127436,
 110788,
 -45771,
 1295192679,
 110787,
 -1,
 1295257916,
 110786,
 1295469885,
 1294898256,
 -1,
 -45768,
 1295390323,
 110812,
 -45767,
 1295455614,
 110811,
 -45766,
 1295520938,
 110810,
 -45765,
 1295586188,
 110809,
 -45764,
 1295651431,
 110808,
 -1,
 1295716668,
 110807,
 1295928642,
 1295438849,
 -1,
 -45761,
 1295848618,
 110803,
 -45760,
 1295913868,
 110802,
 -45759,
 1295979111,
 110801,
 -1,
 1296044348,
 110800,
 1296302079,
 1295860505,
 -1,
 -45756,
 1296204745,
 110806,
 -45755,
 1296241255,
 110805,
 -1,
 1296306492,
 110804,
 1296518496,
 1294327995,
 -1,
 1296584015,
 1296471120,
 -1,
 -45751,
 1296504643,
 110876,
 -45750,
 1296569971,
 110875,
 -45749,
 1296635262,
 110874,
 -45748,
 1296700586,
 110873,
 -45747,
 1296765836,
 110872,
 -45746,
 1296831079,
 110871,
 -1,
 1296896316,
 110870,
 1297108309,
 1296524319,
 -1,
 -45743,
 1297028478,
 110865,
 -45742,
 1297093802,
 110864,
 -45741,
 1297159052,
 110863,
 -45740,
 1297224295,
 110862,
 -1,
 1297289532,
 110861,
 1297501531,
 1297029669,
 -1,
 -45737,
 1297421694,
 110860,
 -45736,
 1297487018,
 110859,
 -45735,
 1297552268,
 110858,
 -45734,
 1297617511,
 110857,
 -1,
 1297682748,
 110856,
 1297940479,
 1297433369,
 -1,
 -45731,
 1297814698,
 110869,
 -45730,
 1297879948,
 110868,
 -45729,
 1297945191,
 110867,
 -1,
 1298010428,
 110866,
 1298222452,
 1296492836,
 -1,
 1298287976,
 1298175056,
 -1,
 -45725,
 1298208371,
 110828,
 -45724,
 1298273662,
 110827,
 -45723,
 1298338986,
 110826,
 -45722,
 1298404236,
 110825,
 -45721,
 1298469479,
 110824,
 -1,
 1298534716,
 110823,
 1298746735,
 1298209317,
 -1,
 -45718,
 1298721681,
 110818,
 -45717,
 1298732414,
 110817,
 -45716,
 1298797738,
 110816,
 -45715,
 1298862988,
 110815,
 -45714,
 1298928231,
 110814,
 -1,
 1298993468,
 110813,
 1299251199,
 1298715649,
 -1,
 -45711,
 1299125418,
 110822,
 -45710,
 1299190668,
 110821,
 -45709,
 1299255911,
 110820,
 -1,
 1299321148,
 110819,
 1299533179,
 1298154265,
 -1,
 -45706,
 1299453555,
 110611,
 -45705,
 1299518846,
 110610,
 -45704,
 1299584170,
 110609,
 -45703,
 1299649420,
 110608,
 -45702,
 1299714663,
 110607,
 -1,
 1299779900,
 983266,
 1299991937,
 1299502081,
 -1,
 -45699,
 1299912062,
 110606,
 -45698,
 1299977386,
 110605,
 -45697,
 1300042636,
 110604,
 -45696,
 1300107879,
 110603,
 -1,
 1300173116,
 110602,
 1300385158,
 1299932191,
 -1,
 -45693,
 1300305066,
 110601,
 -45692,
 1300370316,
 110600,
 -45691,
 1300435559,
 110599,
 -1,
 1300500796,
 110598,
 1300712843,
 1300306469,
 -1,
 -45688,
 1300686358,
 110597,
 -45687,
 1300697996,
 110596,
 -45686,
 1300763239,
 110595,
 -1,
 1300828476,
 110594,
 1301086207,
 1300665424,
 -1,
 -45683,
 1300960140,
 110614,
 -45682,
 1301025383,
 110613,
 -1,
 1301090620,
 110612,
 1301302766,
 1278732351,
 -1,
 1301368229,
 1301268385,
 -1,
 1301433764,
 1301306525,
 -1,
 1301499286,
 1301360035,
 -1,
 -45676,
 1301458951,
 19904,
 -45675,
 1301512017,
 19933,
 -1,
 1301554849,
 19953,
 1301761435,
 1301420422,
 -1,
 1301826970,
 1301720262,
 -1,
 -45671,
 1301782451,
 19954,
 -1,
 1301842963,
 19910,
 -1,
 1301753238,
 19932,
 1302089118,
 1301733563,
 -1,
 -45667,
 1302021968,
 19951,
 -1,
 1302077739,
 19959,
 -45665,
 1302048808,
 19905,
 -45664,
 1302234590,
 19957,
 -45663,
 1302295756,
 19955,
 -45662,
 1302360844,
 19961,
 -45661,
 1302419151,
 19960,
 -1,
 1302482729,
 19940,
 -1,
 1301393318,
 19913,
 1302744495,
 1301297421,
 -1,
 1302810026,
 1302675966,
 -1,
 -45656,
 1302781189,
 19956,
 -45655,
 1302822846,
 19943,
 -1,
 1302869654,
 19944,
 1303072173,
 1302750125,
 -1,
 -45652,
 1303036687,
 19962,
 -1,
 1303072719,
 19906,
 -45650,
 1303042533,
 19935,
 -1,
 1303192426,
 19939,
 1303399866,
 1302680776,
 -1,
 1303465401,
 1303358662,
 -1,
 1303530936,
 1303397348,
 -1,
 1303596471,
 1303487151,
 -1,
 1303662006,
 1303548951,
 -1,
 -45643,
 1303634549,
 19937,
 -1,
 1303692284,
 19917,
 -1,
 1303622010,
 19931,
 -1,
 1303562501,
 19929,
 -1,
 1303452470,
 19925,
 -1,
 1303389683,
 19948,
 1304120768,
 1303362049,
 -1,
 1304186302,
 1304069289,
 -1,
 -45635,
 1304152325,
 19912,
 -1,
 1304209800,
 19965,
 -45633,
 1304152336,
 19915,
 -1,
 1304340277,
 19926,
 1304513990,
 1304062126,
 -1,
 1304579524,
 1304464428,
 -1,
 -45629,
 1304532185,
 19928,
 -1,
 1304578631,
 19964,
 -45627,
 1304515084,
 19934,
 -1,
 1304704662,
 19945,
 1304907211,
 1304473507,
 -1,
 1304972746,
 1304872865,
 -1,
 -45623,
 1304943140,
 19927,
 -1,
 1304997872,
 19936,
 -1,
 1304944576,
 19952,
 1305234895,
 1304863407,
 -1,
 -45619,
 1305205492,
 19949,
 -45618,
 1305261997,
 19938,
 -1,
 1305297719,
 19914,
 1305497044,
 1305187351,
 -1,
 1305562579,
 1305454841,
 -1,
 -45614,
 1305522648,
 19950,
 -1,
 1305582977,
 19941,
 -1,
 1305488640,
 19942,
 1305824729,
 1305424941,
 -1,
 1305890264,
 1305775148,
 -1,
 -45609,
 1305856509,
 19923,
 -1,
 1305891256,
 19909,
 -1,
 1305839937,
 19947,
 1306152413,
 1305749343,
 -1,
 -45605,
 1306111928,
 19946,
 -45604,
 1306161286,
 19924,
 -1,
 1306215851,
 19967,
 1306414561,
 1306073478,
 -1,
 -45601,
 1306372421,
 19922,
 -45600,
 1306416284,
 19966,
 -1,
 1306471727,
 19958,
 1306676708,
 1306386619,
 -1,
 -45597,
 1306631374,
 19921,
 -1,
 1306664500,
 19908,
 1306873319,
 1306626548,
 -1,
 -45594,
 1306843990,
 19930,
 -1,
 1306868632,
 19918,
 1307069930,
 1306807953,
 -1,
 -45591,
 1307023115,
 19920,
 -1,
 1307068256,
 19916,
 -45589,
 1307044793,
 19907,
 -45588,
 1307213572,
 19963,
 -45587,
 1307271261,
 19911,
 -1,
 1307330840,
 19919,
 1307528779,
 1301223814,
 -1,
 1307594304,
 1307500707,
 -1,
 1307659775,
 1307556353,
 -1,
 1307725304,
 1307615228,
 -1,
 1307790837,
 1307697796,
 -1,
 -45580,
 1307762447,
 128605,
 -1,
 1307782418,
 128613,
 1308033023,
 1307722631,
 -1,
 -45577,
 1307959055,
 128607,
 -1,
 1307979026,
 128615,
 1308184059,
 1307668851,
 -1,
 -45574,
 1308148553,
 128952,
 -1,
 1308207073,
 128972,
 1308380670,
 1308105094,
 -1,
 -45571,
 1308332578,
 128635,
 -1,
 1308394235,
 128940,
 -1,
 1308309213,
 128625,
 1308642826,
 1307604751,
 -1,
 1308708355,
 1308598746,
 -1,
 -45566,
 1308672049,
 10079,
 -1,
 1308704489,
 10080,
 1308904966,
 1308640763,
 -1,
 -45563,
 1308850355,
 129052,
 -1,
 1308903920,
 129048,
 1309101577,
 1308825990,
 -1,
 -45560,
 1309068741,
 128327,
 -1,
 1309127276,
 11093,
 -1,
 1309042313,
 128627,
 1309363730,
 1308563846,
 -1,
 1309429265,
 1309325517,
 -1,
 1309494800,
 1309382741,
 129180,
 1309605887,
 1309409280,
 -1,
 -45553,
 1309526884,
 129183,
 -1,
 1309563577,
 129182,
 -1,
 1309463411,
 129181,
 -1,
 1309379316,
 128628,
 1309888025,
 1309315476,
 -1,
 1309953558,
 1309860484,
 -1,
 -45547,
 1309925135,
 128604,
 -1,
 1309945106,
 128612,
 1310195711,
 1309885319,
 -1,
 -45544,
 1310121743,
 128606,
 -1,
 1310141714,
 128614,
 1310346784,
 1309819390,
 -1,
 1310412319,
 1310287570,
 -1,
 1310477854,
 1310369752,
 -1,
 -45539,
 1310434974,
 128977,
 -1,
 1310468889,
 128975,
 -1,
 1310442313,
 128958,
 -1,
 1310386269,
 10071,
 1310805543,
 1310275853,
 -1,
 1310871078,
 1310757911,
 -1,
 1310936613,
 1310844418,
 -1,
 -45532,
 1310881971,
 129055,
 -1,
 1310935536,
 129051,
 -1,
 1310883866,
 128178,
 -1,
 1310814556,
 10135,
 1311264300,
 1310732786,
 11096,
 1311329835,
 1311181666,
 -1,
 -45526,
 1311294966,
 9955,
 -1,
 1311322617,
 11095,
 -1,
 1311258961,
 11097,
 1311591984,
 1311236847,
 -1,
 -45522,
 1311556445,
 128913,
 -45521,
 1311588456,
 9947,
 -1,
 1311650290,
 128903,
 1311854131,
 1311562125,
 -1,
 -45518,
 1311799475,
 129053,
 -1,
 1311853040,
 129049,
 1312050742,
 1311822476,
 -1,
 -45515,
 1312007838,
 128980,
 -1,
 1312041753,
 128979,
 1312247353,
 1312011543,
 -1,
 -45512,
 1312192691,
 129054,
 -1,
 1312246256,
 129050,
 1312443964,
 1312182575,
 -1,
 -45509,
 1312408393,
 128946,
 -1,
 1312466913,
 128970,
 -45507,
 1312401312,
 10133,
 -45506,
 1312595996,
 11094,
 -45505,
 1312655750,
 10134,
 -1,
 1312713919,
 128633,
 1312902728,
 1307552966,
 -1,
 1312968263,
 1312868259,
 -1,
 1313033798,
 1312941132,
 -1,
 -45500,
 1313000957,
 127892,
 -45499,
 1313059593,
 128157,
 -1,
 1313088530,
 128152,
 -1,
 1312963266,
 128159,
 -1,
 1312886637,
 128585,
 1313472511,
 1312831757,
 -1,
 -45494,
 1313391931,
 9980,
 -1,
 1313449520,
 127911,
 1313623636,
 1307454646,
 -1,
 1313689169,
 1313579695,
 -1,
 1313754704,
 1313642011,
 -1,
 -45489,
 1313712959,
 1479,
 -1,
 1313759305,
 1466,
 -1,
 1313724261,
 1478,
 -45486,
 1313663900,
 1519,
 -45485,
 1313965459,
 1477,
 -1,
 1314003732,
 1442,
 1314213464,
 1313568527,
 -1,
 -45482,
 1314162647,
 9937,
 -45481,
 1314226839,
 11263,
 -1,
 1314284834,
 128641,
 -45479,
 1314172704,
 127807,
 -1,
 1314405278,
 129428,
 1314606975,
 1278613894,
 -1,
 1314672464,
 1314556972,
 -1,
 1314737927,
 1314609577,
 -1,
 1314803417,
 1314681357,
 -1,
 1314868912,
 1314757021,
 -1,
 1314934389,
 1314830849,
 -1,
 1314999916,
 1314896759,
 -1,
 1315065443,
 1314966792,
 55245,
 -1,
 1314983836,
 55246,
 1315196518,
 1315029083,
 -1,
 -45467,
 1315163400,
 55277,
 -1,
 1315206632,
 55276,
 -45465,
 1315170973,
 983211,
 -45464,
 1315353412,
 55255,
 -45463,
 1315415662,
 55270,
 -45462,
 1315475469,
 4607,
 -45461,
 1315539143,
 55264,
 -1,
 1315582420,
 55289,
 1315831807,
 1314942430,
 -1,
 1315851888,
 1315712419,
 -1,
 -45457,
 1315792337,
 55279,
 -1,
 1315856009,
 55280,
 -45455,
 1315818326,
 55281,
 -45454,
 1316004779,
 55278,
 -45453,
 1316063431,
 55274,
 -45452,
 1316123660,
 55275,
 -1,
 1316183696,
 55282,
 1316376196,
 1314890415,
 -1,
 1316441726,
 1316316637,
 -1,
 1316507258,
 1316367779,
 -1,
 -45447,
 1316447697,
 55272,
 -1,
 1316511369,
 55273,
 -45445,
 1316474120,
 55267,
 -45444,
 1316667513,
 55271,
 -45443,
 1316729682,
 55268,
 -1,
 1316784327,
 55269,
 1316966017,
 1316380328,
 -1,
 -45440,
 1316932438,
 55291,
 -1,
 1316995158,
 55290,
 1317208063,
 1316889064,
 -1,
 -45437,
 1317119598,
 55283,
 -1,
 1317172236,
 55284,
 1317359246,
 1316336445,
 -1,
 1317424776,
 1317333545,
 -1,
 -45433,
 1317388205,
 55259,
 -1,
 1317444763,
 55260,
 1317621387,
 1317381748,
 -1,
 -45430,
 1317588232,
 55257,
 -1,
 1317643816,
 55258,
 -45428,
 1317585882,
 55253,
 -45427,
 1317767380,
 55256,
 -1,
 1317828079,
 55254,
 1318014614,
 1317326095,
 -1,
 1318080145,
 1317978198,
 55248,
 -1,
 1317998373,
 55249,
 1318211220,
 1318006179,
 -1,
 -45421,
 1318151633,
 55250,
 -1,
 1318215305,
 55251,
 -45419,
 1318177622,
 55252,
 -1,
 1318364782,
 55247,
 1318538910,
 1317958457,
 -1,
 1318604445,
 1318482409,
 -1,
 -45415,
 1318561390,
 4603,
 -45414,
 1318621197,
 4602,
 -45413,
 1318679910,
 4605,
 -45412,
 1318739600,
 4606,
 -1,
 1318793523,
 4604,
 -1,
 1318527637,
 55261,
 1319063205,
 1318513318,
 -1,
 1319128738,
 1319007033,
 -1,
 -45407,
 1319072227,
 983209,
 -1,
 1319132833,
 983212,
 -45405,
 1319093210,
 983210,
 -45404,
 1319274695,
 55285,
 -1,
 1319329424,
 55286,
 1319521962,
 1319012557,
 -1,
 -45401,
 1319486438,
 55263,
 -45400,
 1319544443,
 55265,
 -45399,
 1319604237,
 55262,
 -1,
 1319645652,
 55266,
 1319849645,
 1319473171,
 -1,
 -45396,
 1319809847,
 55243,
 -1,
 1319842099,
 55244,
 1320091647,
 1319776730,
 -1,
 -45393,
 1320010737,
 55288,
 -1,
 1320068718,
 55287,
 1320288255,
 1314838493,
 -1,
 1320308412,
 1320182815,
 -1,
 1320373946,
 1320282404,
 -1,
 1320439477,
 1320305150,
 55232,
 -1,
 1320391703,
 55231,
 1320570552,
 1320360326,
 -1,
 -45385,
 1320501758,
 55230,
 -1,
 1320554365,
 55229,
 -45383,
 1320539034,
 55235,
 -1,
 1320719383,
 55234,
 -45381,
 1320326227,
 55233,
 -1,
 1320838061,
 55236,
 1321029318,
 1320282404,
 -1,
 1321094849,
 1320981584,
 -1,
 1321160384,
 1321015686,
 55218,
 -1,
 1321091582,
 55219,
 -1,
 1321093484,
 55220,
 1321356996,
 1321063425,
 -1,
 -45373,
 1321309207,
 55224,
 -1,
 1321344072,
 55223,
 -45371,
 1321290095,
 4517,
 -1,
 1321474618,
 4516,
 1321684684,
 1320981584,
 -1,
 1321750219,
 1321658660,
 -1,
 1321815754,
 1321671046,
 4518,
 -1,
 1321746942,
 4519,
 -1,
 1321748844,
 55216,
 -1,
 1321702483,
 55217,
 1322077905,
 1321618427,
 -1,
 1322143439,
 1322009086,
 55227,
 -1,
 1322095639,
 55226,
 -45360,
 1322095639,
 55228,
 -1,
 1322195334,
 55225,
 1322405590,
 1321998726,
 -1,
 1322471125,
 1322364302,
 -1,
 -45356,
 1322402302,
 55238,
 -1,
 1322457478,
 55237,
 -1,
 1322389239,
 4515,
 1322778623,
 1322374145,
 -1,
 -45352,
 1322707588,
 55221,
 -1,
 1322738722,
 55222,
 1322975231,
 1314730372,
 -1,
 1322995433,
 1322890045,
 -1,
 1323060961,
 1322957313,
 -1,
 1323126496,
 1323023223,
 -1,
 -45346,
 1323093256,
 43367,
 -45345,
 1323148910,
 43370,
 -1,
 1323202024,
 43365,
 -1,
 1323068890,
 43372,
 1323454181,
 1323004729,
 -1,
 -45341,
 1323397603,
 43364,
 -45340,
 1323458209,
 43374,
 -1,
 1323508360,
 43371,
 -45338,
 1323420936,
 43366,
 -45337,
 1323673198,
 43369,
 -45336,
 1323731143,
 43368,
 -1,
 1323774420,
 43373,
 1323978479,
 1322962191,
 -1,
 -45333,
 1323941974,
 43362,
 -45332,
 1324004151,
 4446,
 -45331,
 1324066414,
 43361,
 -45330,
 1324124359,
 43360,
 -1,
 1324167636,
 43363,
 1324371700,
 1323942868,
 -1,
 -45327,
 1324345992,
 43388,
 -45326,
 1324403542,
 43385,
 -45325,
 1324466273,
 43381,
 -1,
 1324495329,
 43384,
 1324699386,
 1324327599,
 -1,
 1324764921,
 1324639709,
 -1,
 -45321,
 1324728428,
 43378,
 -45320,
 1324774758,
 43379,
 -1,
 1324834448,
 43380,
 -1,
 1324703408,
 43386,
 1325092606,
 1324650515,
 -1,
 -45316,
 1325056086,
 4443,
 -45315,
 1325096592,
 4445,
 -1,
 1325150676,
 4444,
 1325354754,
 1325041869,
 -1,
 -45312,
 1325321480,
 43376,
 -45311,
 1325383766,
 43377,
 -1,
 1325430248,
 43375,
 1325616901,
 1325295062,
 -1,
 -45308,
 1325577015,
 43382,
 -1,
 1325620880,
 43383,
 -45306,
 1325561340,
 4442,
 -1,
 1325751958,
 43387,
 1325944650,
 1314678248,
 -1,
 1326010157,
 1325890902,
 -1,
 1326075663,
 1325953849,
 -1,
 1326141197,
 1326017555,
 -1,
 -45300,
 1326115231,
 68889,
 -1,
 1326178555,
 68887,
 -45298,
 1326078493,
 68872,
 -1,
 1326258566,
 68881,
 1326468883,
 1326025772,
 -1,
 -45295,
 1326442911,
 68891,
 -45294,
 1326470423,
 68890,
 -1,
 1326520710,
 68885,
 1326731030,
 1326434209,
 -1,
 -45291,
 1326696487,
 68868,
 -1,
 1326717318,
 68867,
 1326927641,
 1326692865,
 -1,
 -45288,
 1326864925,
 68880,
 -1,
 1326913926,
 68879,
 1327124252,
 1326886086,
 -1,
 -45285,
 1327082816,
 68877,
 -1,
 1327110534,
 68876,
 1327320863,
 1327053069,
 -1,
 -45282,
 1327249820,
 68875,
 -1,
 1327307142,
 68874,
 -45280,
 1327295582,
 68878,
 -45279,
 1327491487,
 68888,
 -45278,
 1327554811,
 68886,
 -45277,
 1327619011,
 68892,
 -45276,
 1327670027,
 68866,
 -45275,
 1327727561,
 68884,
 -45274,
 1327789913,
 68883,
 -45273,
 1327854123,
 68869,
 -45272,
 1327913501,
 68871,
 -45271,
 1327977751,
 68882,
 -45270,
 1328041702,
 68873,
 -45269,
 1328098778,
 68870,
 -45268,
 1328162704,
 68865,
 -1,
 1328224646,
 68864,
 1328435003,
 1325939811,
 -1,
 1328500529,
 1328400289,
 -1,
 -45264,
 1328473622,
 68914,
 -1,
 1328505312,
 68915,
 1328697140,
 1328462337,
 -1,
 -45261,
 1328640368,
 68918,
 -1,
 1328696469,
 68919,
 1328893751,
 1328631441,
 -1,
 -45258,
 1328848637,
 68916,
 -1,
 1328902334,
 68917,
 -45256,
 1328868635,
 68912,
 -45255,
 1329043541,
 68913,
 -45254,
 1329107016,
 68921,
 -1,
 1329153670,
 68920,
 1329352513,
 1328406516,
 -1,
 -45251,
 1329320858,
 68895,
 -45250,
 1329370135,
 68897,
 -45249,
 1329423277,
 68894,
 -45248,
 1329480190,
 68896,
 -1,
 1329535366,
 68893,
 1329745735,
 1329315769,
 -1,
 1329811270,
 1329711143,
 -1,
 -45244,
 1329775621,
 68903,
 -45243,
 1329826934,
 68902,
 -1,
 1329879718,
 68901,
 -1,
 1329749050,
 68900,
 1330184191,
 1329694072,
 -1,
 -45239,
 1330100995,
 68898,
 -1,
 1330154633,
 68899,
 1330380799,
 1325873421,
 -1,
 1330401102,
 1330259856,
 -1,
 -45235,
 1330347984,
 129342,
 -1,
 1330402504,
 128092,
 -45233,
 1330363843,
 129309,
 -1,
 1330515225,
 129310,
 1330728820,
 1314637729,
 -1,
 1330794355,
 1330687586,
 -1,
 1330859884,
 1330740566,
 -1,
 1330925400,
 1330821633,
 -1,
 1330990935,
 1330846086,
 -1,
 -45226,
 1330939746,
 67822,
 -1,
 1330985919,
 67825,
 -1,
 1330929482,
 67828,
 1331253083,
 1330890657,
 -1,
 -45222,
 1331186588,
 67816,
 -1,
 1331242749,
 67829,
 1331449693,
 1331190938,
 67812,
 -1,
 1331415742,
 67815,
 1331580768,
 1331370374,
 -1,
 -45217,
 1331555206,
 67823,
 -1,
 1331592479,
 67808,
 -45215,
 1331555572,
 67814,
 -45214,
 1331751849,
 67817,
 -45213,
 1331814881,
 67813,
 -45212,
 1331866482,
 67826,
 -45211,
 1331930319,
 67824,
 -45210,
 1331991433,
 67821,
 -45209,
 1332053883,
 67820,
 -45208,
 1332115542,
 67819,
 -45207,
 1332179975,
 67818,
 -45206,
 1332238362,
 67810,
 -45205,
 1332296181,
 67811,
 -1,
 1332357539,
 67809,
 1332609023,
 1330811725,
 -1,
 1332629360,
 1332529057,
 -1,
 -45201,
 1332601433,
 67838,
 -1,
 1332627399,
 67837,
 1332825970,
 1332582485,
 67835,
 -1,
 1332740952,
 67839,
 -1,
 1332760874,
 67836,
 -1,
 1330721106,
 128035,
 1333088123,
 1330676595,
 -1,
 1333153657,
 1333036974,
 128296,
 1333264383,
 1333067842,
 -1,
 -45192,
 1333192631,
 128736,
 -1,
 1333241424,
 9874,
 -45190,
 1333118165,
 128057,
 -1,
 1333341505,
 127828,
 -45188,
 1333047122,
 128436,
 -45187,
 1333504346,
 128587,
 -45186,
 1333554918,
 128135,
 -1,
 1333607244,
 11233,
 1333809064,
 1314558999,
 -1,
 1333874578,
 1333767366,
 -1,
 1333940110,
 1333817860,
 -1,
 1334005642,
 1333905313,
 -1,
 1334071177,
 1333926529,
 -1,
 1334136712,
 1334040201,
 983059,
 1334247423,
 1334050816,
 -1,
 -45177,
 1334174877,
 983140,
 -1,
 1334230282,
 983137,
 -1,
 1334051796,
 11134,
 -1,
 1334029716,
 128677,
 1334529933,
 1333930720,
 -1,
 -45172,
 1334482163,
 11203,
 -1,
 1334533665,
 11043,
 -1,
 1334477959,
 9897,
 1334837247,
 1333902361,
 128014,
 1334902783,
 1334706176,
 -1,
 -45167,
 1334816102,
 127943,
 -1,
 1334857449,
 128052,
 1335054232,
 1333842842,
 -1,
 1335119767,
 1335016476,
 -1,
 1335185302,
 1335045406,
 127968,
 -1,
 1335147009,
 127960,
 -1,
 1335157868,
 127969,
 -1,
 1335079554,
 9203,
 1335447454,
 1335019425,
 -1,
 1335512989,
 1335361536,
 -1,
 -45157,
 1335469479,
 127798,
 -45156,
 1335508254,
 127789,
 -1,
 1335568879,
 9749,
 -1,
 1335445257,
 127976,
 1335840674,
 1335392015,
 -1,
 1335906209,
 1335788009,
 128616,
 -1,
 1335821169,
 128617,
 -1,
 1335837182,
 128371,
 1336102821,
 1335791411,
 -1,
 -45148,
 1336027418,
 128029,
 -1,
 1336084570,
 127855,
 -45146,
 1336066875,
 127973,
 -45145,
 1336255151,
 983123,
 -1,
 1336291696,
 128298,
 1336496067,
 1333748653,
 -1,
 1336561589,
 1336454561,
 -1,
 1336627120,
 1336486451,
 -1,
 -45140,
 1336595354,
 983980,
 -45139,
 1336644631,
 983982,
 -45138,
 1336697773,
 983979,
 -45137,
 1336754686,
 983981,
 -1,
 1336809862,
 983978,
 1337020340,
 1336590876,
 -1,
 -45134,
 1336972311,
 110930,
 -45133,
 1337025453,
 110928,
 -1,
 1337082366,
 110929,
 -1,
 1336943382,
 110593,
 1337348030,
 1336497990,
 -1,
 1337413562,
 1337265829,
 -1,
 1337479097,
 1337377539,
 128644,
 -1,
 1337396073,
 128645,
 -1,
 1337417076,
 128096,
 1337720831,
 1337327616,
 -1,
 -45124,
 1337647027,
 9889,
 -45123,
 1337693435,
 983122,
 -1,
 1337732284,
 128262,
 -45121,
 1337312599,
 9964,
 -45120,
 1337895202,
 129435,
 -45119,
 1337953797,
 128725,
 -45118,
 1338013100,
 129406,
 -1,
 1338059432,
 127802,
 1338265544,
 1336469796,
 -1,
 1338331079,
 1338221231,
 -1,
 -45114,
 1338283316,
 11794,
 -1,
 1338334617,
 11802,
 -1,
 1338267655,
 11226,
 1338593228,
 1338233754,
 -1,
 -45110,
 1338555964,
 128559,
 -45109,
 1338609137,
 128175,
 -1,
 1338660608,
 129303,
 1338855375,
 1338558369,
 983060,
 -45106,
 1338817025,
 983138,
 -1,
 1338864141,
 983141,
 -1,
 1338817013,
 8372,
 1339118369,
 1278579735,
 -1,
 1339183597,
 1339062031,
 -1,
 1339249069,
 1339111693,
 -1,
 1339314601,
 1339162624,
 -1,
 1339379786,
 1339253604,
 -1,
 1339445259,
 1339343246,
 -1,
 1339510773,
 1339376126,
 68809,
 1339576284,
 1339460652,
 68825,
 1339641818,
 1339541409,
 68839,
 -1,
 1339559906,
 68849,
 -45093,
 1339615524,
 68826,
 -1,
 1339698595,
 68805,
 1339903967,
 1339501987,
 68804,
 -45090,
 1339865601,
 68806,
 -1,
 1339906571,
 68841,
 1340100577,
 1339878448,
 68847,
 -1,
 1340062209,
 68848,
 1340231651,
 1340065697,
 68838,
 -1,
 1340205348,
 68840,
 1340362725,
 1340193281,
 68836,
 -1,
 1340337200,
 68837,
 1340493799,
 1340310387,
 68824,
 -1,
 1340449455,
 68833,
 1340624873,
 1340438287,
 68822,
 -1,
 1340598564,
 68823,
 1340755947,
 1340560584,
 68813,
 -1,
 1340729636,
 68814,
 -45076,
 1340726192,
 68846,
 -45075,
 1340845254,
 68834,
 -45074,
 1340908207,
 68832,
 -45073,
 1340961593,
 68819,
 -45072,
 1341026829,
 68818,
 -45071,
 1341086219,
 68815,
 -45070,
 1341148817,
 68812,
 -45069,
 1341211134,
 68811,
 -45068,
 1341274381,
 68807,
 -1,
 1341335391,
 68802,
 1341542394,
 1339431302,
 68800,
 -45065,
 1341492561,
 68808,
 -45064,
 1341556249,
 68803,
 -45063,
 1341616953,
 68820,
 -1,
 1341659526,
 68801,
 1341870078,
 1341510554,
 68842,
 -45060,
 1341838234,
 68843,
 -45059,
 1341897217,
 68850,
 -1,
 1341952245,
 68821,
 1342132225,
 1341821975,
 68827,
 -45056,
 1342084119,
 68828,
 -1,
 1342129421,
 68831,
 1342328836,
 1342093665,
 -1,
 -45053,
 1342297576,
 68845,
 -1,
 1342346579,
 68830,
 1342525447,
 1342279740,
 -1,
 -45050,
 1342494184,
 68844,
 -1,
 1342543187,
 68829,
 1342722057,
 1342464941,
 68816,
 -1,
 1342661549,
 68817,
 -45046,
 1342684914,
 68835,
 -1,
 1342780303,
 68810,
 1342984257,
 1339371221,
 -1,
 1343049771,
 1342915070,
 68745,
 1343115282,
 1342999596,
 68761,
 1343180816,
 1343080353,
 68775,
 -1,
 1343098850,
 68785,
 -45039,
 1343154468,
 68762,
 -1,
 1343237539,
 68741,
 1343442965,
 1343040931,
 68740,
 -45036,
 1343404545,
 68742,
 -1,
 1343445515,
 68777,
 1343639575,
 1343417392,
 68783,
 -1,
 1343601153,
 68784,
 1343770649,
 1343604641,
 68774,
 -1,
 1343744292,
 68776,
 1343901723,
 1343732225,
 68772,
 -1,
 1343876144,
 68773,
 1344032797,
 1343849331,
 68760,
 -1,
 1343988399,
 68769,
 1344163871,
 1343977231,
 68758,
 -1,
 1344137508,
 68759,
 1344294945,
 1344099528,
 68749,
 -1,
 1344268580,
 68750,
 -45022,
 1344265136,
 68782,
 -45021,
 1344384198,
 68770,
 -45020,
 1344447151,
 68768,
 -45019,
 1344500537,
 68755,
 -45018,
 1344565773,
 68754,
 -45017,
 1344625163,
 68751,
 -45016,
 1344687761,
 68748,
 -45015,
 1344750078,
 68747,
 -45014,
 1344813325,
 68743,
 -1,
 1344874335,
 68738,
 1345081392,
 1342970246,
 68736,
 -45011,
 1345031505,
 68744,
 -45010,
 1345095193,
 68739,
 -45009,
 1345155897,
 68756,
 -1,
 1345198470,
 68737,
 1345409076,
 1345049498,
 68778,
 -45006,
 1345377178,
 68779,
 -45005,
 1345436161,
 68786,
 -1,
 1345491189,
 68757,
 1345671223,
 1345360919,
 68763,
 -45002,
 1345623063,
 68764,
 -1,
 1345668365,
 68767,
 1345867834,
 1345632609,
 -1,
 -44999,
 1345836520,
 68781,
 -1,
 1345885523,
 68766,
 1346064445,
 1345818684,
 -1,
 -44996,
 1346033128,
 68780,
 -1,
 1346082131,
 68765,
 1346261055,
 1346003885,
 68752,
 -1,
 1346200493,
 68753,
 -44992,
 1346223858,
 68771,
 -1,
 1346319247,
 68746,
 1346568191,
 1342935885,
 -1,
 1346588742,
 1346476117,
 68858,
 1346699263,
 1346502656,
 -1,
 -44987,
 1346620320,
 68863,
 -1,
 1346659123,
 68862,
 1346850889,
 1346523139,
 -1,
 -44984,
 1346821272,
 68859,
 -1,
 1346852012,
 68861,
 -1,
 1346816520,
 68860,
 1347113151,
 1339336110,
 -1,
 1347178640,
 1347074561,
 -1,
 1347244175,
 1347118204,
 -1,
 1347309702,
 1347207097,
 -1,
 1347375188,
 1347238157,
 -1,
 1347440722,
 1347295622,
 66477,
 1347551231,
 1347380126,
 66508,
 -1,
 1347423914,
 66509,
 -44973,
 1347408794,
 66479,
 -1,
 1347576749,
 66478,
 1347768408,
 1347295622,
 66464,
 1347878911,
 1347738075,
 66504,
 -44969,
 1347770909,
 66506,
 -1,
 1347817130,
 66505,
 1348030556,
 1347733409,
 -1,
 -44966,
 1347998618,
 66476,
 -44965,
 1348033053,
 66480,
 -1,
 1348082054,
 66475,
 1348292704,
 1347992065,
 -1,
 -44962,
 1348254422,
 66498,
 -44961,
 1348295197,
 66497,
 -1,
 1348344198,
 66495,
 1348554852,
 1348240243,
 -1,
 -44958,
 1348522906,
 66488,
 -44957,
 1348559789,
 66487,
 -1,
 1348606342,
 66486,
 1348817000,
 1348478815,
 -1,
 1348882535,
 1348737414,
 66482,
 -1,
 1348818199,
 66510,
 -1,
 1348852625,
 66511,
 1349079147,
 1348790291,
 -1,
 -44950,
 1349041571,
 66507,
 -1,
 1349065094,
 66471,
 1349275758,
 1349049264,
 -1,
 -44947,
 1349215149,
 66491,
 -1,
 1349261702,
 66490,
 1349472369,
 1349233862,
 -1,
 -44944,
 1349440410,
 66493,
 -1,
 1349458310,
 66492,
 1349668980,
 1349422124,
 -1,
 -44941,
 1349637018,
 66485,
 -1,
 1349654918,
 66484,
 1349865591,
 1349612345,
 -1,
 -44938,
 1349833626,
 66468,
 -1,
 1349851526,
 66467,
 1350062202,
 1349808653,
 -1,
 -44935,
 1350001581,
 66474,
 -1,
 1350048134,
 66473,
 1350258813,
 1349997768,
 -1,
 -44932,
 1350226842,
 66470,
 -1,
 1350244742,
 66469,
 -44930,
 1350233182,
 66496,
 -44929,
 1350429087,
 66489,
 -44928,
 1350488986,
 66466,
 -44927,
 1350542091,
 66481,
 -44926,
 1350596441,
 66494,
 -44925,
 1350656941,
 66465,
 -44924,
 1350720029,
 66499,
 -44923,
 1350782694,
 66483,
 -1,
 1350839770,
 66472,
 1351045262,
 1347261261,
 -1,
 1351110796,
 1351010209,
 -1,
 1351176331,
 1351082171,
 -1,
 -44918,
 1351128087,
 66514,
 -1,
 1351174454,
 66516,
 -1,
 1351108551,
 66515,
 -44915,
 1351063637,
 66513,
 -1,
 1351377715,
 66517,
 -1,
 1351018358,
 66512,
 -1,
 1347196994,
 128435,
 1351745535,
 1347127306,
 -1,
 1351766169,
 1351674148,
 -1,
 1351831701,
 1351698950,
 66415,
 -44908,
 1351799706,
 66408,
 -1,
 1351836589,
 66416,
 1352028311,
 1351752070,
 66420,
 -1,
 1351993249,
 66417,
 -44904,
 1351996314,
 66419,
 -1,
 1352120772,
 66407,
 1352290462,
 1351727617,
 -1,
 1352355997,
 1352227339,
 -1,
 -44900,
 1352309333,
 66405,
 -1,
 1352348025,
 66406,
 -1,
 1352296396,
 66401,
 1352618145,
 1352229805,
 66393,
 -44896,
 1352548862,
 66418,
 -1,
 1352604038,
 66421,
 1352814758,
 1352546573,
 -1,
 1352880293,
 1352789040,
 -1,
 -44892,
 1352822789,
 66392,
 -1,
 1352884289,
 66390,
 -1,
 1352832519,
 66387,
 1353142441,
 1352789040,
 -1,
 -44888,
 1353080897,
 66389,
 -1,
 1353131375,
 66391,
 1353339052,
 1353112496,
 -1,
 -44885,
 1353292373,
 66398,
 -1,
 1353337350,
 66414,
 1353535663,
 1353303969,
 -1,
 -44882,
 1353498757,
 66413,
 -1,
 1353522576,
 66402,
 1353732273,
 1353487383,
 66409,
 -1,
 1353683991,
 66410,
 1353863347,
 1353662974,
 66388,
 -1,
 1353797265,
 66411,
 -44876,
 1353831322,
 66403,
 -44875,
 1353953565,
 66400,
 -44874,
 1354016005,
 66399,
 -44873,
 1354075856,
 66397,
 -44872,
 1354139554,
 66396,
 -44871,
 1354202347,
 66395,
 -44870,
 1354266167,
 66394,
 -44869,
 1354324509,
 66412,
 -44868,
 1354388861,
 66386,
 -44867,
 1354445078,
 66404,
 -44866,
 1354509629,
 66385,
 -1,
 1354571845,
 66384,
 1354780944,
 1347080671,
 -1,
 1354846446,
 1354734817,
 -1,
 1354911960,
 1354766726,
 68608,
 1354977485,
 1354842622,
 -1,
 -44860,
 1354950948,
 68632,
 -44859,
 1355007905,
 68677,
 -44858,
 1355069953,
 68670,
 -44857,
 1355132102,
 68668,
 -44856,
 1355189292,
 68644,
 -44855,
 1355249423,
 68640,
 -44854,
 1355313977,
 68634,
 -44853,
 1355371720,
 68623,
 -44852,
 1355430157,
 68627,
 -1,
 1355491167,
 68619,
 1355698383,
 1354938881,
 68669,
 -1,
 1355635211,
 68671,
 -44848,
 1355671844,
 68630,
 -44847,
 1355794337,
 68675,
 -44846,
 1355852998,
 68666,
 -44845,
 1355918081,
 68660,
 -44844,
 1355975724,
 68643,
 -44843,
 1356035855,
 68638,
 -44842,
 1356092616,
 68621,
 -44841,
 1356151053,
 68625,
 -1,
 1356212063,
 68617,
 1356419300,
 1354842622,
 -1,
 1356484830,
 1356368940,
 -1,
 -44837,
 1356458276,
 68650,
 -44836,
 1356515233,
 68646,
 -44835,
 1356551368,
 68653,
 -1,
 1356606883,
 68648,
 -44833,
 1356459056,
 68628,
 -44832,
 1356774735,
 68673,
 -44831,
 1356833455,
 68655,
 -44830,
 1356890995,
 68642,
 -44829,
 1356956335,
 68641,
 -1,
 1357000099,
 68658,
 1357205738,
 1356370967,
 68614,
 1357271271,
 1357136382,
 68615,
 -1,
 1357214521,
 68636,
 -44824,
 1357236129,
 68679,
 -44823,
 1357359873,
 68664,
 -1,
 1357423279,
 68656,
 1357598957,
 1357145005,
 68611,
 -44820,
 1357556481,
 68662,
 -1,
 1357589923,
 68657,
 -1,
 1357523148,
 68680,
 1357905919,
 1354820219,
 -1,
 1357926658,
 1357781382,
 68609,
 1357992184,
 1357857278,
 68610,
 1358057715,
 1357941804,
 68645,
 -1,
 1357993160,
 68654,
 -44812,
 1358031140,
 68633,
 -44811,
 1358153633,
 68678,
 -44810,
 1358197561,
 68635,
 -44809,
 1358255304,
 68624,
 -1,
 1358309215,
 68620,
 -44807,
 1357965604,
 68631,
 -44806,
 1358481313,
 68676,
 -44805,
 1358544207,
 68672,
 -44804,
 1358605510,
 68667,
 -44803,
 1358670593,
 68661,
 -44802,
 1358729041,
 68652,
 -44801,
 1358788367,
 68639,
 -44800,
 1358845128,
 68622,
 -44799,
 1358903565,
 68626,
 -1,
 1358964575,
 68618,
 1359171850,
 1357857278,
 68613,
 1359237383,
 1359121452,
 -1,
 -44795,
 1359210788,
 68651,
 -44794,
 1359267745,
 68647,
 -1,
 1359293859,
 68649,
 -44792,
 1359211568,
 68629,
 -44791,
 1359461711,
 68674,
 -1,
 1359490467,
 68659,
 1359696142,
 1359123479,
 -1,
 1359761677,
 1359626750,
 68616,
 -1,
 1359704889,
 68637,
 -1,
 1359719169,
 68665,
 1360003071,
 1359635373,
 68612,
 -1,
 1359915777,
 68663,
 1360089459,
 1354744429,
 -1,
 1360154950,
 1360025185,
 -1,
 1360220471,
 1360099087,
 -1,
 1360286006,
 1360153537,
 -1,
 1360351518,
 1360220208,
 -1,
 1360417047,
 1360316757,
 69403,
 -1,
 1360334437,
 69404,
 1360548121,
 1360378613,
 69398,
 -1,
 1360465509,
 69399,
 1360679195,
 1360499593,
 69391,
 -1,
 1360596581,
 69392,
 -44772,
 1360616602,
 69382,
 -44771,
 1360734627,
 69379,
 -1,
 1360797436,
 69377,
 1361006883,
 1360312833,
 -1,
 1361072418,
 1360927110,
 -1,
 -44767,
 1361020770,
 69393,
 -1,
 1361066943,
 69397,
 -1,
 1361010506,
 69401,
 1361334568,
 1360927110,
 -1,
 1361400103,
 1361278735,
 -1,
 -44762,
 1361365618,
 69395,
 -1,
 1361398183,
 69376,
 -1,
 1361373922,
 69394,
 1361662250,
 1361271962,
 69381,
 -1,
 1361627838,
 69385,
 -44757,
 1361636590,
 69384,
 -44756,
 1361767337,
 69386,
 -44755,
 1361830369,
 69383,
 -44754,
 1361889621,
 69402,
 -44753,
 1361949119,
 69400,
 -44752,
 1362011343,
 69396,
 -44751,
 1362072457,
 69390,
 -44750,
 1362134907,
 69389,
 -44749,
 1362196566,
 69388,
 -44748,
 1362260999,
 69387,
 -44747,
 1362319386,
 69380,
 -1,
 1362373027,
 69378,
 -1,
 1360225860,
 69415,
 1362645317,
 1360171853,
 -1,
 1362710848,
 1362610081,
 -1,
 1362776380,
 1362682043,
 -1,
 -44741,
 1362727959,
 69406,
 -1,
 1362774326,
 69411,
 1362972991,
 1362713099,
 -1,
 -44738,
 1362931886,
 69407,
 -1,
 1362980627,
 69412,
 -1,
 1362905031,
 69410,
 1363235138,
 1362663509,
 69405,
 -1,
 1363149656,
 69413,
 1363410943,
 1363168913,
 -1,
 -44732,
 1363320573,
 69408,
 -1,
 1363374270,
 69409,
 -1,
 1362580444,
 69414,
 1363673087,
 1360124745,
 -1,
 1363693934,
 1363574102,
 -1,
 1363759438,
 1363658657,
 -1,
 1363824972,
 1363696139,
 -1,
 -44725,
 1363757980,
 68220,
 -1,
 1363814141,
 68219,
 -44723,
 1363757980,
 68215,
 -1,
 1363945213,
 68201,
 1364152660,
 1363720705,
 -1,
 1364218195,
 1364072838,
 -1,
 -44719,
 1364182945,
 68202,
 -44718,
 1364232034,
 68207,
 -1,
 1364278207,
 68206,
 -1,
 1364156234,
 68198,
 1364545881,
 1364080909,
 -1,
 1364611416,
 1364482589,
 -1,
 -44713,
 1364557118,
 68217,
 -1,
 1364605887,
 68211,
 -1,
 1364532994,
 68213,
 1364873564,
 1364489017,
 -1,
 -44709,
 1364811273,
 68205,
 -1,
 1364861529,
 68203,
 1365070174,
 1364810906,
 68192,
 -1,
 1365035710,
 68194,
 1365201249,
 1365005512,
 -1,
 -44704,
 1365141598,
 68212,
 -1,
 1365204114,
 68214,
 1365397860,
 1365121414,
 -1,
 -44701,
 1365371782,
 68210,
 -1,
 1365408448,
 68209,
 -44699,
 1365372148,
 68216,
 -44698,
 1365568425,
 68218,
 -44697,
 1365631457,
 68197,
 -44696,
 1365684645,
 68199,
 -44695,
 1365748594,
 68196,
 -44694,
 1365808009,
 68204,
 -44693,
 1365870459,
 68195,
 -44692,
 1365932118,
 68193,
 -44691,
 1365987148,
 68208,
 -1,
 1366043043,
 68200,
 1366294527,
 1363645257,
 -1,
 1366315378,
 1366174059,
 -1,
 -44687,
 1366267989,
 68221,
 -1,
 1366315020,
 68222,
 -1,
 1366248066,
 68223,
 1366577568,
 1360040347,
 -1,
 1366643099,
 1366523222,
 -1,
 1366708603,
 1366607777,
 -1,
 1366774137,
 1366645259,
 -1,
 -44680,
 1366705715,
 68251,
 -1,
 1366761111,
 68249,
 -44678,
 1366705715,
 68233,
 -1,
 1366891871,
 68247,
 1367101823,
 1366641443,
 -1,
 -44675,
 1367020428,
 68239,
 -44674,
 1367085671,
 68230,
 -1,
 1367150908,
 68234,
 1367363970,
 1367075934,
 -1,
 -44671,
 1367304366,
 68248,
 -1,
 1367366155,
 68252,
 1367560581,
 1367307065,
 -1,
 -44668,
 1367497300,
 68237,
 -1,
 1367547077,
 68235,
 1367757192,
 1367497227,
 -1,
 -44665,
 1367688755,
 68224,
 -1,
 1367743839,
 68226,
 1367953803,
 1367692488,
 -1,
 -44662,
 1367890547,
 68246,
 -1,
 1367950659,
 68244,
 1368150414,
 1367882140,
 -1,
 -44659,
 1368094479,
 68245,
 -1,
 1368144141,
 68243,
 1368347025,
 1368070534,
 -1,
 -44656,
 1368292032,
 68241,
 -1,
 1368352942,
 68242,
 -44654,
 1368320576,
 68250,
 -44653,
 1368515041,
 68229,
 -44652,
 1368570609,
 68238,
 -44651,
 1368633625,
 68231,
 -44650,
 1368697640,
 68228,
 -44649,
 1368756557,
 68236,
 -44648,
 1368819506,
 68227,
 -44647,
 1368881213,
 68225,
 -44646,
 1368936311,
 68240,
 -1,
 1368992047,
 68232,
 1369243647,
 1366594381,
 -1,
 1369264543,
 1369163681,
 -1,
 -44642,
 1369236057,
 68255,
 -1,
 1369262023,
 68254,
 -1,
 1369217109,
 68253,
 1369526693,
 1366519841,
 -1,
 -44638,
 1369500201,
 66349,
 -44637,
 1369555662,
 66351,
 -44636,
 1369608618,
 66350,
 -1,
 1369656147,
 66335,
 1369854376,
 1369452873,
 -1,
 -44633,
 1369796715,
 94179,
 -1,
 1369858196,
 94178,
 -1,
 1369797913,
 128477,
 1370161151,
 1339247113,
 -1,
 -44629,
 1370089304,
 128117,
 -44628,
 1370129673,
 128116,
 -1,
 1370168386,
 129491,
 1370423295,
 1339163094,
 -1,
 1370444244,
 1370324310,
 -1,
 1370509753,
 1370364294,
 -1,
 1370575285,
 1370429830,
 -1,
 -44622,
 1370546363,
 7267,
 -44621,
 1370588019,
 7266,
 -44620,
 1370649401,
 7264,
 -1,
 1370714637,
 7265,
 -44618,
 1370539937,
 7259,
 -44617,
 1370853201,
 7261,
 -44616,
 1370912527,
 7262,
 -1,
 1370969288,
 7260,
 1371165120,
 1370453775,
 -1,
 1371230652,
 1371085190,
 7258,
 -1,
 1371150726,
 7263,
 -44611,
 1371198362,
 7273,
 -44610,
 1371313175,
 7283,
 -44609,
 1371366317,
 7268,
 -1,
 1371423230,
 7278,
 1371623877,
 1371132826,
 -1,
 -44606,
 1371597092,
 7277,
 -44605,
 1371640070,
 7276,
 -44604,
 1371683085,
 7275,
 -1,
 1371745699,
 7274,
 1371951562,
 1371575319,
 -1,
 -44601,
 1371921328,
 7286,
 -44600,
 1371984188,
 7284,
 -44599,
 1372019211,
 7287,
 -1,
 1372071775,
 7285,
 1372279247,
 1371890605,
 -1,
 -44596,
 1372240385,
 7269,
 -44595,
 1372302534,
 7272,
 -44594,
 1372361663,
 7271,
 -1,
 1372412427,
 7270,
 1372651519,
 1372209662,
 -1,
 -44591,
 1372567733,
 7282,
 -44590,
 1372627631,
 7279,
 -44589,
 1372687404,
 7281,
 -1,
 1372731991,
 7280,
 1372934626,
 1370373219,
 -1,
 1373000152,
 1372899233,
 -1,
 -44585,
 1372972566,
 7250,
 -1,
 1373004256,
 7251,
 1373196763,
 1372961281,
 -1,
 -44582,
 1373139312,
 7254,
 -1,
 1373195413,
 7255,
 1373393374,
 1373130385,
 -1,
 -44579,
 1373347581,
 7252,
 -1,
 1373401278,
 7253,
 -44577,
 1373367579,
 7248,
 -44576,
 1373542485,
 7249,
 -44575,
 1373605960,
 7257,
 -1,
 1373652614,
 7256,
 1373852135,
 1372889775,
 -1,
 1373917670,
 1373820745,
 -1,
 -44571,
 1373866849,
 7294,
 -1,
 1373912934,
 7295,
 -1,
 1373854262,
 7292,
 1374179818,
 1373801305,
 -1,
 -44567,
 1374097147,
 7290,
 -1,
 1374161720,
 7288,
 -44565,
 1374138657,
 7291,
 -44564,
 1374311710,
 7289,
 -1,
 1374363010,
 7293,
 1374573179,
 1339144705,
 -1,
 1374638665,
 1374493981,
 -1,
 1374704156,
 1374601614,
 -1,
 1374769657,
 1374634494,
 66783,
 1374835192,
 1374706187,
 -1,
 1374900725,
 1374799777,
 -1,
 -44556,
 1374862038,
 66803,
 -1,
 1374886278,
 66801,
 -44554,
 1374855947,
 66797,
 -44553,
 1375040395,
 66789,
 -1,
 1375088751,
 66782,
 -1,
 1374775470,
 66784,
 1375359485,
 1374689670,
 66776,
 1375425020,
 1375298477,
 66777,
 -1,
 1375374380,
 66778,
 -1,
 1375361547,
 66779,
 1375621634,
 1375324065,
 -1,
 1375687169,
 1375582721,
 -1,
 -44544,
 1375623709,
 66804,
 -1,
 1375672710,
 66802,
 -1,
 1375607174,
 66800,
 1375949318,
 1375564601,
 -1,
 -44540,
 1375922591,
 66790,
 -44539,
 1375951389,
 66808,
 -1,
 1376000390,
 66788,
 1376211465,
 1375923248,
 -1,
 -44536,
 1376147997,
 66811,
 -1,
 1376196998,
 66810,
 1376408076,
 1376172545,
 -1,
 -44533,
 1376344605,
 66799,
 -1,
 1376393606,
 66798,
 1376604686,
 1376359447,
 66794,
 -1,
 1376544942,
 66795,
 1376735761,
 1376541195,
 -1,
 -44528,
 1376709023,
 66786,
 -1,
 1376721286,
 66785,
 -44526,
 1376706811,
 66807,
 -44525,
 1376899994,
 66806,
 -44524,
 1376953099,
 66796,
 -44523,
 1377012854,
 66793,
 -44522,
 1377076169,
 66792,
 -44521,
 1377138521,
 66791,
 -44520,
 1377199021,
 66787,
 -44519,
 1377261385,
 66809,
 -44518,
 1377319853,
 66805,
 -44517,
 1377382511,
 66781,
 -1,
 1377447029,
 66780,
 1377697791,
 1374629589,
 -1,
 1377718822,
 1377583614,
 66743,
 1377784357,
 1377655307,
 -1,
 1377849890,
 1377748897,
 -1,
 -44511,
 1377811158,
 66763,
 -1,
 1377835398,
 66761,
 -44509,
 1377805067,
 66757,
 -44508,
 1377989515,
 66749,
 -1,
 1378037871,
 66742,
 -1,
 1377724590,
 66744,
 1378308650,
 1377638790,
 66736,
 1378374185,
 1378247597,
 66737,
 -1,
 1378323500,
 66738,
 -1,
 1378310667,
 66739,
 1378570799,
 1378273185,
 -1,
 1378636334,
 1378531841,
 -1,
 -44499,
 1378572829,
 66764,
 -1,
 1378621830,
 66762,
 -1,
 1378556294,
 66760,
 1378898483,
 1378513721,
 -1,
 -44495,
 1378871711,
 66750,
 -44494,
 1378900509,
 66768,
 -1,
 1378949510,
 66748,
 1379160630,
 1378872368,
 -1,
 -44491,
 1379097117,
 66771,
 -1,
 1379146118,
 66770,
 1379357241,
 1379121665,
 -1,
 -44488,
 1379293725,
 66759,
 -1,
 1379342726,
 66758,
 1379553851,
 1379308567,
 66754,
 -1,
 1379494062,
 66755,
 1379684926,
 1379490315,
 -1,
 -44483,
 1379658143,
 66746,
 -1,
 1379670406,
 66745,
 -44481,
 1379655931,
 66767,
 -44480,
 1379849114,
 66766,
 -44479,
 1379902219,
 66756,
 -44478,
 1379961974,
 66753,
 -44477,
 1380025289,
 66752,
 -44476,
 1380087641,
 66751,
 -44475,
 1380148141,
 66747,
 -44474,
 1380210505,
 66769,
 -44473,
 1380268973,
 66765,
 -44472,
 1380331631,
 66741,
 -1,
 1380396149,
 66740,
 1380602490,
 1374586203,
 -1,
 1380668012,
 1380547926,
 -1,
 1380733518,
 1380587910,
 66710,
 -44467,
 1380678336,
 66688,
 -1,
 1380718982,
 66715,
 1380930129,
 1380694529,
 -1,
 -44464,
 1380867869,
 66697,
 -1,
 1380915590,
 66696,
 1381126739,
 1380881431,
 66713,
 -1,
 1381078039,
 66717,
 1381257814,
 1381069625,
 -1,
 -44459,
 1381194269,
 66693,
 -1,
 1381243475,
 66703,
 1381454424,
 1381188094,
 66711,
 -1,
 1381384702,
 66716,
 1381585499,
 1381382413,
 -1,
 -44454,
 1381521949,
 66698,
 -1,
 1381582127,
 66694,
 -44452,
 1381558687,
 66709,
 -44451,
 1381754934,
 66692,
 -44450,
 1381818849,
 66707,
 -44449,
 1381880730,
 66714,
 -44448,
 1381943335,
 66690,
 -44447,
 1382001984,
 66695,
 -44446,
 1382066979,
 66702,
 -44445,
 1382126512,
 66706,
 -44444,
 1382189285,
 66705,
 -44443,
 1382250350,
 66704,
 -44442,
 1382314539,
 66691,
 -44441,
 1382376365,
 66712,
 -44440,
 1382439453,
 66708,
 -44439,
 1382503703,
 66700,
 -44438,
 1382567654,
 66701,
 -44437,
 1382625149,
 66699,
 -1,
 1382688656,
 66689,
 1382940671,
 1380596835,
 -1,
 1382961776,
 1382860705,
 -1,
 -44433,
 1382934038,
 66722,
 -1,
 1382965728,
 66723,
 1383158387,
 1382922753,
 -1,
 -44430,
 1383100784,
 66726,
 -1,
 1383156885,
 66727,
 1383354998,
 1383091857,
 -1,
 -44427,
 1383309053,
 66724,
 -1,
 1383362750,
 66725,
 -44425,
 1383329051,
 66720,
 -44424,
 1383503957,
 66721,
 -44423,
 1383567432,
 66729,
 -1,
 1383614086,
 66728,
 -1,
 1380527523,
 983191,
 1383879377,
 1374540092,
 -1,
 1383944912,
 1383831372,
 -1,
 1384010427,
 1383895885,
 -1,
 1384075919,
 1383974817,
 -1,
 1384141446,
 1384046779,
 -1,
 1384206980,
 1384092695,
 126210,
 1384316927,
 1384120320,
 -1,
 -44413,
 1384237984,
 126237,
 -1,
 1384276787,
 126228,
 1384513535,
 1384139062,
 126219,
 -1,
 1384384985,
 126246,
 1384600205,
 1384077835,
 -1,
 1384665739,
 1384558766,
 126211,
 1384775679,
 1384579072,
 -1,
 -44406,
 1384696736,
 126238,
 -1,
 1384735539,
 126229,
 1384972287,
 1384607507,
 126220,
 -1,
 1384843737,
 126247,
 1385103359,
 1384531911,
 126218,
 -1,
 1384974809,
 126245,
 1385190044,
 1384036865,
 -1,
 1385255574,
 1385132400,
 126214,
 1385321107,
 1385223038,
 126223,
 -1,
 1385236953,
 126250,
 1385496575,
 1385234432,
 -1,
 -44395,
 1385417632,
 126241,
 -1,
 1385456435,
 126232,
 1385693183,
 1385188501,
 126215,
 1385714329,
 1385616254,
 126224,
 -1,
 1385630169,
 126251,
 1385889791,
 1385627648,
 -1,
 -44389,
 1385810848,
 126242,
 -1,
 1385849651,
 126233,
 1386042027,
 1385123473,
 -1,
 1386107556,
 1385993239,
 -1,
 1386173090,
 1386076604,
 126212,
 1386283007,
 1386086400,
 -1,
 -44383,
 1386204064,
 126239,
 -1,
 1386242867,
 126230,
 1386479615,
 1386133840,
 126221,
 -1,
 1386351065,
 126248,
 1386610687,
 1386046381,
 -1,
 1386631849,
 1386536088,
 126213,
 1386741759,
 1386545152,
 -1,
 -44376,
 1386662816,
 126240,
 -1,
 1386701619,
 126231,
 1386938367,
 1386566828,
 126222,
 -1,
 1386809817,
 126249,
 1387025073,
 1385992264,
 126217,
 1387090606,
 1386992510,
 126226,
 -1,
 1387006425,
 126253,
 1387266047,
 1387003904,
 -1,
 -44368,
 1387187104,
 126244,
 -1,
 1387225907,
 126235,
 1387418295,
 1386956422,
 126216,
 1387483828,
 1387391268,
 126225,
 -1,
 1387399641,
 126252,
 1387659263,
 1387397120,
 -1,
 -44362,
 1387580320,
 126243,
 -1,
 1387619123,
 126234,
 1387855871,
 1387370581,
 126209,
 1387921407,
 1387724800,
 -1,
 -44358,
 1387842464,
 126236,
 -1,
 1387881267,
 126227,
 1388073676,
 1383931844,
 -1,
 1388139202,
 1388038049,
 -1,
 1388204735,
 1388111382,
 126255,
 -1,
 1388120537,
 126266,
 1388335809,
 1388136391,
 126263,
 -1,
 1388251609,
 126267,
 -1,
 1388274144,
 126256,
 1388532422,
 1388100097,
 -1,
 1388597957,
 1388474736,
 126259,
 -1,
 1388512088,
 126265,
 -1,
 1388530837,
 126260,
 1388794570,
 1388465809,
 -1,
 1388860105,
 1388748541,
 126257,
 -1,
 1388774232,
 126264,
 -1,
 1388802238,
 126258,
 -44341,
 1388744776,
 126262,
 -1,
 1388988038,
 126261,
 1389187791,
 1388008398,
 -1,
 -44338,
 1389150408,
 126269,
 -1,
 1389189817,
 126268,
 -1,
 1389135290,
 126254,
 -1,
 1383877126,
 129446,
 1389515497,
 1383836870,
 -1,
 1389581027,
 1389457881,
 -1,
 1389646556,
 1389515700,
 -1,
 1389712089,
 1389598809,
 -1,
 -44330,
 1389674675,
 2933,
 -44329,
 1389734873,
 2930,
 -44328,
 1389779641,
 2931,
 -1,
 1389840071,
 2934,
 1390084095,
 1389677516,
 -1,
 -44325,
 1390002365,
 2935,
 -1,
 1390062616,
 2932,
 1390236384,
 1389617232,
 -1,
 1390301919,
 1390180111,
 2914,
 -1,
 1390245647,
 2915,
 -1,
 1390262453,
 2884,
 1390542847,
 1390181718,
 -1,
 -44318,
 1390469371,
 2929,
 -1,
 1390533571,
 2869,
 1390695144,
 1389502802,
 -1,
 1390760679,
 1390625280,
 -1,
 -44314,
 1390697728,
 129505,
 -1,
 1390750705,
 128217,
 -1,
 1390730041,
 129447,
 -1,
 1390611505,
 10183,
 1391088380,
 1389470383,
 -1,
 1391153913,
 1391018494,
 -1,
 1391219448,
 1391103022,
 -1,
 1391284975,
 1391183489,
 -1,
 -44306,
 1391240690,
 10180,
 -1,
 1391275249,
 10179,
 1391481586,
 1391232074,
 -1,
 -44303,
 1391439325,
 128236,
 -1,
 1391493722,
 128237,
 1391678197,
 1391414929,
 -1,
 -44300,
 1391630040,
 128449,
 -1,
 1391683612,
 128194,
 -44298,
 1391624354,
 128275,
 -44297,
 1391811543,
 128080,
 -1,
 1391864817,
 128214,
 -1,
 1391177410,
 983190,
 1392136955,
 1391119550,
 128191,
 -1,
 1392051041,
 128440,
 -1,
 1392074707,
 9934,
 1392333578,
 1391037484,
 -1,
 1392399107,
 1392260242,
 -1,
 -44289,
 1392363870,
 128662,
 -44288,
 1392420987,
 128660,
 -44287,
 1392464112,
 128753,
 -44286,
 1392520520,
 128653,
 -1,
 1392584377,
 128664,
 1392792328,
 1392329214,
 -1,
 1392857863,
 1392705536,
 -1,
 -44282,
 1392786866,
 11819,
 -1,
 1392848254,
 128431,
 -1,
 1392775052,
 129649,
 -44279,
 1392733645,
 129477,
 -1,
 1393036413,
 128283,
 1393251090,
 1392303412,
 -1,
 1393316625,
 1393195157,
 128471,
 1393426431,
 1393272472,
 -1,
 1393447696,
 1393353455,
 -1,
 -44273,
 1393410966,
 11194,
 -1,
 1393434762,
 11195,
 -1,
 1393371915,
 11196,
 -1,
 1393253663,
 129397,
 1393775381,
 1393220397,
 -1,
 -44268,
 1393721141,
 9885,
 -1,
 1393765481,
 128228,
 1393971992,
 1393702921,
 -1,
 -44265,
 1393925126,
 128025,
 -1,
 1393958227,
 128721,
 -44263,
 1393945626,
 129450,
 -44262,
 1394141203,
 128002,
 -44261,
 1394206130,
 129417,
 -44260,
 1394246589,
 128329,
 -44259,
 1394307912,
 128076,
 -44258,
 1394370532,
 128738,
 -44257,
 1394429877,
 127970,
 -44256,
 1394490099,
 127842,
 -1,
 1394552030,
 9215,
 1394759290,
 1339073199,
 -1,
 1394824348,
 1394678150,
 -1,
 1394889692,
 1394760832,
 -1,
 1394955097,
 1394814371,
 -1,
 1395020606,
 1394907652,
 -1,
 1395086126,
 1394969644,
 -1,
 1395151658,
 1395050401,
 -1,
 -44247,
 1395112893,
 92957,
 -1,
 1395154040,
 92971,
 -44245,
 1395095942,
 92960,
 -44244,
 1395291269,
 92962,
 -44243,
 1395339454,
 92968,
 -1,
 1395402358,
 92972,
 1395610418,
 1395022347,
 -1,
 -44240,
 1395559687,
 92969,
 -44239,
 1395620230,
 92965,
 -1,
 1395664502,
 92959,
 1395872565,
 1395535267,
 -1,
 -44236,
 1395809400,
 92967,
 -1,
 1395861110,
 92975,
 -44234,
 1395845660,
 92964,
 -44233,
 1396041807,
 92974,
 -44232,
 1396104337,
 92956,
 -44231,
 1396158188,
 92961,
 -44230,
 1396222803,
 92963,
 -44229,
 1396287253,
 92970,
 -44228,
 1396344337,
 92966,
 -44227,
 1396406662,
 92958,
 -1,
 1396450934,
 92973,
 1396703231,
 1394964581,
 -1,
 1396724549,
 1396623265,
 -1,
 1396790084,
 1396685313,
 -1,
 -44222,
 1396761089,
 93069,
 -44221,
 1396792675,
 93053,
 -1,
 1396841089,
 93062,
 -1,
 1396727877,
 93061,
 1397117769,
 1396667193,
 -1,
 -44217,
 1397089717,
 93070,
 -44216,
 1397135933,
 93058,
 -1,
 1397185086,
 93064,
 1397379916,
 1397090596,
 -1,
 -44213,
 1397310745,
 93054,
 -1,
 1397366355,
 93068,
 1397576527,
 1397349296,
 -1,
 -44210,
 1397548463,
 93071,
 -1,
 1397562963,
 93066,
 1397773138,
 1397520143,
 -1,
 -44207,
 1397714728,
 93055,
 -1,
 1397761688,
 93056,
 1397969749,
 1397709341,
 -1,
 -44204,
 1397941679,
 93059,
 -1,
 1397982067,
 93065,
 -44202,
 1397942558,
 93057,
 -44201,
 1398122009,
 93063,
 -44200,
 1398180700,
 93060,
 -1,
 1398230800,
 93067,
 1398428556,
 1394917305,
 -1,
 1398494053,
 1398354413,
 -1,
 1398559583,
 1398458273,
 -1,
 1398625118,
 1398532378,
 93044,
 -1,
 1398538718,
 93045,
 -1,
 1398588123,
 92997,
 1398821730,
 1398484387,
 -1,
 -44191,
 1398789224,
 93043,
 -1,
 1398824320,
 92985,
 -44189,
 1398778416,
 93046,
 -44188,
 1398968849,
 93047,
 -1,
 1399020152,
 93042,
 1399214959,
 1398466579,
 -1,
 1399280493,
 1399187748,
 -1,
 1399346028,
 1399211335,
 -1,
 -44183,
 1399312198,
 92990,
 -44182,
 1399370400,
 92989,
 -44181,
 1399427880,
 92988,
 -1,
 1399475979,
 92991,
 -1,
 1399298621,
 93028,
 -44178,
 1399219244,
 93034,
 -1,
 1399662261,
 92996,
 1399870329,
 1399185381,
 -1,
 1399935861,
 1399834529,
 -1,
 1400001396,
 1399872011,
 -1,
 -44173,
 1399953197,
 92983,
 -1,
 1400005676,
 92986,
 -1,
 1399963055,
 92984,
 -44170,
 1399897182,
 92992,
 -44169,
 1400214042,
 92994,
 -44168,
 1400275754,
 93027,
 -1,
 1400328050,
 92987,
 1400525693,
 1399834529,
 -1,
 -44165,
 1400498336,
 93037,
 -44164,
 1400528775,
 93030,
 -1,
 1400579702,
 93039,
 1400787842,
 1400472435,
 -1,
 1400853377,
 1400718621,
 -1,
 -44160,
 1400820016,
 93038,
 -1,
 1400882824,
 92993,
 -1,
 1400822446,
 93041,
 1401115525,
 1400736812,
 -1,
 -44156,
 1401082289,
 93035,
 -1,
 1401138012,
 93033,
 1401312136,
 1401051659,
 -1,
 -44153,
 1401262897,
 93032,
 -1,
 1401323027,
 93029,
 -44151,
 1401286104,
 93031,
 -44150,
 1401454907,
 93040,
 -44149,
 1401513163,
 92995,
 -1,
 1401562827,
 93036,
 1401770935,
 1398398971,
 -1,
 1401836444,
 1401690502,
 -1,
 1401901969,
 1401807035,
 -1,
 -44144,
 1401871280,
 92943,
 -1,
 1401890655,
 92942,
 1402098580,
 1401869210,
 -1,
 -44141,
 1402067888,
 92933,
 -1,
 1402087263,
 92932,
 1402295191,
 1402037165,
 -1,
 -44138,
 1402264496,
 92939,
 -1,
 1402283871,
 92938,
 1402491802,
 1402214790,
 -1,
 -44135,
 1402461104,
 92955,
 -1,
 1402480479,
 92954,
 -44133,
 1402461104,
 92951,
 -1,
 1402611551,
 92950,
 1402819490,
 1401803674,
 -1,
 1402885024,
 1402739078,
 -1,
 -44129,
 1402854320,
 92945,
 -1,
 1402873695,
 92944,
 -44127,
 1402854320,
 92935,
 -1,
 1403004767,
 92934,
 1403212712,
 1402770455,
 -1,
 1403278246,
 1403163671,
 -1,
 -44123,
 1403247536,
 92941,
 -1,
 1403266911,
 92940,
 -44121,
 1403247536,
 92947,
 -1,
 1403397983,
 92946,
 1403605934,
 1403151277,
 -1,
 1403671468,
 1403525510,
 -1,
 -44117,
 1403640752,
 92949,
 -1,
 1403660127,
 92948,
 -44115,
 1403640752,
 92931,
 -1,
 1403791199,
 92930,
 1403999156,
 1403535870,
 -1,
 1404064690,
 1403929086,
 -1,
 -44111,
 1404033968,
 92929,
 -1,
 1404053343,
 92928,
 -44109,
 1404033968,
 92937,
 -1,
 1404184415,
 92936,
 1404436479,
 1403969723,
 -1,
 -44106,
 1404361648,
 92953,
 -1,
 1404381023,
 92952,
 1404588997,
 1401699427,
 -1,
 1404654523,
 1404553121,
 -1,
 -44102,
 1404626454,
 93010,
 -1,
 1404658144,
 93011,
 1404851134,
 1404615169,
 -1,
 -44099,
 1404793200,
 93014,
 -1,
 1404849301,
 93015,
 1405047745,
 1404784273,
 -1,
 -44096,
 1405001469,
 93012,
 -1,
 1405055166,
 93013,
 -44094,
 1405021467,
 93008,
 -44093,
 1405196373,
 93009,
 -44092,
 1405259848,
 93017,
 -1,
 1405306502,
 93016,
 1405506513,
 1404539725,
 -1,
 1405572045,
 1405470625,
 -1,
 1405637580,
 1405503431,
 -1,
 1405703115,
 1405550592,
 -1,
 -44086,
 1405668275,
 93021,
 -1,
 1405692507,
 93024,
 -1,
 1405663745,
 93019,
 -1,
 1405597032,
 93025,
 1406030800,
 1405510451,
 -1,
 -44081,
 1405991425,
 93020,
 -1,
 1406010540,
 93023,
 -1,
 1405978904,
 93022,
 1406337023,
 1405453705,
 -1,
 1406358485,
 1406257057,
 -1,
 -44076,
 1406325911,
 92976,
 -1,
 1406346921,
 92982,
 1406555096,
 1406319105,
 -1,
 -44073,
 1406522468,
 92980,
 -1,
 1406571543,
 92977,
 1406751707,
 1406497593,
 -1,
 -44070,
 1406688380,
 92979,
 -1,
 1406749472,
 92978,
 -1,
 1406689390,
 92981,
 1407013925,
 1394856863,
 -1,
 1407079440,
 1406957327,
 -1,
 1407144971,
 1407011777,
 -1,
 1407210475,
 1407078033,
 -1,
 1407276010,
 1407150317,
 -1,
 1407341539,
 1407224876,
 72416,
 -1,
 1407276232,
 72419,
 -44060,
 1407314212,
 72420,
 -44059,
 1407443131,
 72418,
 -44058,
 1407502241,
 72414,
 -44057,
 1407558319,
 72412,
 -44056,
 1407615859,
 72415,
 -44055,
 1407678223,
 72417,
 -1,
 1407742777,
 72413,
 -1,
 1407195526,
 72403,
 1407996909,
 1407177626,
 72409,
 -1,
 1407916422,
 72410,
 1408127984,
 1407960993,
 -1,
 -44049,
 1408064029,
 72399,
 -1,
 1408113030,
 72398,
 1408324595,
 1408082607,
 -1,
 -44046,
 1408260637,
 72401,
 -1,
 1408309638,
 72384,
 1408521206,
 1408273452,
 -1,
 -44043,
 1408455959,
 72391,
 -1,
 1408506246,
 72400,
 1408717817,
 1408463673,
 -1,
 -44040,
 1408653853,
 72394,
 -1,
 1408702854,
 72385,
 1408914427,
 1408656301,
 72407,
 -1,
 1408833926,
 72411,
 1409045502,
 1408839075,
 -1,
 -44035,
 1408981533,
 72404,
 -1,
 1409030534,
 72397,
 -44033,
 1409018974,
 72389,
 -44032,
 1409211331,
 72390,
 -44031,
 1409268438,
 72395,
 -44030,
 1409330496,
 72402,
 -44029,
 1409389591,
 72408,
 -44028,
 1409450953,
 72387,
 -44027,
 1409513305,
 72386,
 -44026,
 1409571357,
 72392,
 -44025,
 1409635607,
 72393,
 -44024,
 1409696254,
 72406,
 -44023,
 1409759644,
 72388,
 -44022,
 1409820560,
 72396,
 -1,
 1409882502,
 72405,
 1410138111,
 1407099413,
 72436,
 1410203647,
 1410007040,
 -1,
 1410225167,
 1410105544,
 72435,
 -1,
 1410138834,
 72438,
 -1,
 1410158634,
 72439,
 1410421784,
 1407040367,
 -1,
 1410487318,
 1410387598,
 72428,
 1410596863,
 1410400256,
 -1,
 1410618389,
 1410498760,
 72427,
 -1,
 1410532050,
 72429,
 -1,
 1410551850,
 72430,
 1410859007,
 1410422904,
 72423,
 -1,
 1410728658,
 72426,
 1410946077,
 1410381507,
 72422,
 1411055615,
 1410859008,
 -1,
 1411077148,
 1410957512,
 72421,
 -1,
 1410990802,
 72424,
 -1,
 1411010602,
 72425,
 1411273761,
 1410893864,
 72431,
 1411383295,
 1411186688,
 -1,
 -44000,
 1411285217,
 72433,
 -1,
 1411338282,
 72434,
 1411579903,
 1411209336,
 72437,
 1411645439,
 1411448832,
 -1,
 -43996,
 1411570680,
 72432,
 -1,
 1411600426,
 72440,
 1411798099,
 1406971078,
 -1,
 1411863621,
 1411729676,
 -1,
 1411929154,
 1411807546,
 -1,
 -43991,
 1411902512,
 127273,
 -43990,
 1411967268,
 127272,
 -43989,
 1412032531,
 127271,
 -43988,
 1412096187,
 127270,
 -43987,
 1412160432,
 127269,
 -43986,
 1412223898,
 127268,
 -43985,
 1412286369,
 127267,
 -43984,
 1412348417,
 127266,
 -43983,
 1412410566,
 127265,
 -43982,
 1412475649,
 127264,
 -43981,
 1412539055,
 127263,
 -43980,
 1412600855,
 127262,
 -43979,
 1412664364,
 127261,
 -43978,
 1412727667,
 127260,
 -43977,
 1412790031,
 127259,
 -43976,
 1412854585,
 127258,
 -43975,
 1412919821,
 127257,
 -43974,
 1412981677,
 127256,
 -43973,
 1413044747,
 127255,
 -43972,
 1413108936,
 127254,
 -43971,
 1413172881,
 127253,
 -43970,
 1413235198,
 127252,
 -43969,
 1413298445,
 127251,
 -43968,
 1413361059,
 127250,
 -43967,
 1413424991,
 127249,
 -1,
 1413486982,
 127248,
 1413742591,
 1411872355,
 -1,
 -43964,
 1413640846,
 12829,
 -1,
 1413677908,
 12830,
 1413895245,
 1411827617,
 -1,
 1413960779,
 1413833817,
 -1,
 -43960,
 1413928989,
 983149,
 -43959,
 1413960371,
 983145,
 -43958,
 1414021082,
 983146,
 -1,
 1414080442,
 983148,
 -43956,
 1413933396,
 127881,
 -1,
 1414237932,
 12880,
 1414419538,
 1413814662,
 -1,
 1414485073,
 1414355180,
 -1,
 -43952,
 1414453937,
 11853,
 -1,
 1414503787,
 11791,
 -1,
 1414410684,
 129666,
 -1,
 1414379590,
 129436,
 1414812805,
 1411741455,
 -1,
 1414878340,
 1414759283,
 -1,
 1414943872,
 1414851594,
 -1,
 1415009396,
 1414887952,
 -1,
 1415074931,
 1414975852,
 -1,
 1415140445,
 1415035393,
 -1,
 1415205980,
 1415059846,
 -1,
 -43941,
 1415153506,
 67695,
 -1,
 1415199679,
 67698,
 -1,
 1415143242,
 67701,
 1415468128,
 1415104417,
 -1,
 -43937,
 1415400348,
 67688,
 -1,
 1415456509,
 67702,
 1415664738,
 1415404698,
 67684,
 -1,
 1415629502,
 67687,
 1415795813,
 1415584134,
 -1,
 -43932,
 1415768802,
 67696,
 -1,
 1415806239,
 67680,
 -43930,
 1415769326,
 67686,
 -43929,
 1415965609,
 67689,
 -43928,
 1416028641,
 67685,
 -43927,
 1416081829,
 67700,
 -43926,
 1416145778,
 67699,
 -43925,
 1416209615,
 67697,
 -43924,
 1416270729,
 67694,
 -43923,
 1416333179,
 67692,
 -43922,
 1416394838,
 67691,
 -43921,
 1416459271,
 67690,
 -43920,
 1416517658,
 67682,
 -43919,
 1416581257,
 67693,
 -43918,
 1416641006,
 67683,
 -1,
 1416702371,
 67681,
 -1,
 1415009410,
 67703,
 1416975487,
 1414959949,
 -1,
 1417041019,
 1416939425,
 -1,
 1417106553,
 1417011387,
 -1,
 -43912,
 1417057303,
 67706,
 -1,
 1417103670,
 67711,
 -43910,
 1417044448,
 67707,
 -1,
 1417234375,
 67710,
 1417434238,
 1416973969,
 -1,
 -43907,
 1417387773,
 67708,
 -1,
 1417441470,
 67709,
 -1,
 1417386069,
 67705,
 -1,
 1416934576,
 67704,
 1417761923,
 1414856704,
 -1,
 -43902,
 1417727925,
 127796,
 -1,
 1417751682,
 11801,
 -1,
 1417722548,
 129330,
 -1,
 1414822143,
 9908,
 1418089615,
 1414747336,
 -1,
 1418155150,
 1418019326,
 128463,
 1418220684,
 1418067968,
 -1,
 1418286219,
 1418191954,
 -1,
 -43894,
 1418254880,
 128195,
 -1,
 1418292895,
 128479,
 -1,
 1418219265,
 128196,
 -43891,
 1418181121,
 128464,
 -1,
 1418505414,
 128223,
 -1,
 1418106132,
 128724,
 1418744980,
 1418052532,
 -1,
 1418810515,
 1418674686,
 -1,
 -43886,
 1418760127,
 128755,
 -1,
 1418803577,
 11261,
 -1,
 1418766507,
 128706,
 1419072663,
 1418693676,
 -1,
 -43882,
 1419000227,
 128060,
 -1,
 1419062802,
 129374,
 1419269273,
 1419000077,
 983121,
 -1,
 1419197579,
 983120,
 -43878,
 1419239624,
 128062,
 -43877,
 1419355607,
 128206,
 -1,
 1419391776,
 128230,
 1419597135,
 1394760203,
 -1,
 1419662632,
 1419516294,
 -1,
 1419728104,
 1419598206,
 -1,
 1419793628,
 1419672918,
 -1,
 1419859113,
 1419757473,
 -1,
 1419924644,
 1419823009,
 -1,
 -43869,
 1419860509,
 43114,
 -1,
 1419909510,
 43113,
 1420121255,
 1419885057,
 -1,
 -43866,
 1420057117,
 43089,
 -1,
 1420106118,
 43088,
 -43864,
 1420057117,
 43081,
 -1,
 1420237190,
 43080,
 1420448942,
 1419807788,
 -1,
 -43861,
 1420421535,
 43079,
 -43860,
 1420463222,
 43116,
 -43859,
 1420514583,
 43075,
 -1,
 1420564870,
 43083,
 1420776626,
 1420409345,
 -1,
 -43856,
 1420723375,
 43094,
 -43855,
 1420778013,
 43098,
 -1,
 1420827014,
 43099,
 1421038774,
 1420704013,
 -1,
 -43852,
 1421012062,
 43090,
 -43851,
 1421031836,
 43115,
 -1,
 1421089158,
 43082,
 1421300922,
 1420963235,
 -1,
 1421366457,
 1421220230,
 43076,
 -1,
 1421315559,
 43123,
 -1,
 1421302301,
 43077,
 1421563069,
 1421220230,
 43101,
 -43844,
 1421525797,
 43120,
 -1,
 1421574877,
 43117,
 1421759680,
 1421536304,
 -1,
 -43841,
 1421695517,
 43092,
 -1,
 1421744518,
 43093,
 1421956291,
 1421729676,
 -1,
 -43838,
 1421901096,
 43118,
 -1,
 1421949240,
 43119,
 1422152902,
 1421910703,
 -1,
 -43835,
 1422088733,
 43085,
 -1,
 1422137734,
 43084,
 1422349513,
 1422095161,
 -1,
 -43832,
 1422285341,
 43073,
 -1,
 1422334342,
 43072,
 1422546124,
 1422283976,
 -1,
 -43829,
 1422480663,
 43109,
 -1,
 1422530950,
 43074,
 1422742734,
 1422475774,
 43104,
 -1,
 1422672382,
 43110,
 -43825,
 1422715295,
 43095,
 -43824,
 1422846006,
 43107,
 -43823,
 1422909691,
 43091,
 -43822,
 1422971802,
 43103,
 -43821,
 1423027520,
 43096,
 -43820,
 1423092512,
 43106,
 -43819,
 1423152151,
 43105,
 -43818,
 1423213513,
 43087,
 -43817,
 1423275865,
 43097,
 -43816,
 1423340075,
 43078,
 -43815,
 1423401901,
 43102,
 -43814,
 1423464989,
 43100,
 -43813,
 1423527654,
 43108,
 -1,
 1423583120,
 43086,
 1423791332,
 1419753985,
 -1,
 1423856867,
 1423758234,
 -1,
 1423922402,
 1423780560,
 -1,
 -43808,
 1423894943,
 43112,
 -43807,
 1423958267,
 43111,
 -1,
 1424010560,
 43121,
 -1,
 1423877599,
 43122,
 -1,
 1423797137,
 43124,
 1424315623,
 1423738232,
 -1,
 -43802,
 1424276921,
 43126,
 -1,
 1424310160,
 43127,
 -1,
 1424244528,
 43125,
 1424621567,
 1419669474,
 -1,
 1424643316,
 1424502179,
 -1,
 1424708846,
 1424593943,
 -1,
 1424774381,
 1424655897,
 66020,
 -1,
 1424714670,
 66045,
 -1,
 1424720703,
 66022,
 1424970994,
 1424628102,
 -1,
 -43792,
 1424934817,
 66028,
 -43791,
 1424996513,
 66018,
 -1,
 1425058323,
 66003,
 -43789,
 1424917290,
 66012,
 -1,
 1425170210,
 66004,
 1425364220,
 1424603649,
 -1,
 1425429752,
 1425301073,
 -1,
 -43785,
 1425384111,
 66024,
 -1,
 1425426196,
 66011,
 -43783,
 1425395594,
 66042,
 -43782,
 1425573046,
 66043,
 -43781,
 1425637190,
 66021,
 -1,
 1425680125,
 66015,
 1425888515,
 1425287007,
 -1,
 1425954048,
 1425839127,
 -1,
 -43777,
 1425924283,
 66010,
 -1,
 1425971092,
 66017,
 1426150658,
 1425884429,
 66033,
 -1,
 1426087899,
 66023,
 -1,
 1426118302,
 66027,
 1426347273,
 1425842863,
 -1,
 1426412807,
 1426290447,
 -1,
 -43770,
 1426380543,
 66001,
 -1,
 1426399561,
 66034,
 -43768,
 1426343108,
 66000,
 -1,
 1426530978,
 66036,
 1426740493,
 1426311073,
 -1,
 -43765,
 1426708484,
 66032,
 -43764,
 1426744506,
 66008,
 -1,
 1426794059,
 66002,
 1427002641,
 1426676235,
 -1,
 -43761,
 1426955497,
 66025,
 -43760,
 1427006815,
 66026,
 -1,
 1427064682,
 66006,
 1427264788,
 1426972859,
 -1,
 -43757,
 1427216199,
 66005,
 -1,
 1427252980,
 66044,
 1427461399,
 1427221702,
 -1,
 -43754,
 1427414387,
 66037,
 -1,
 1427447806,
 66029,
 1427658010,
 1427407817,
 -1,
 -43751,
 1427624312,
 66014,
 -1,
 1427672235,
 66013,
 1427854621,
 1427602963,
 -1,
 -43748,
 1427800939,
 66038,
 -1,
 1427847437,
 66016,
 1428051232,
 1427789000,
 -1,
 -43745,
 1428008630,
 66041,
 -1,
 1428039341,
 66007,
 1428247843,
 1427979538,
 -1,
 -43742,
 1428216984,
 66031,
 -1,
 1428258745,
 66019,
 -43740,
 1428217610,
 66035,
 -43739,
 1428398699,
 66039,
 -43738,
 1428443668,
 66040,
 -43737,
 1428505416,
 66030,
 -1,
 1428562962,
 66009,
 1428815871,
 1419613207,
 -1,
 1428837710,
 1428703390,
 -1,
 1428903236,
 1428782422,
 -1,
 1428968751,
 1428863489,
 -1,
 -43731,
 1428905802,
 67860,
 -43730,
 1428965289,
 67854,
 -1,
 1429019679,
 67857,
 1429230898,
 1428932513,
 -1,
 -43727,
 1429162859,
 67848,
 -1,
 1429218934,
 67861,
 1429427508,
 1429167258,
 67844,
 -1,
 1429391265,
 67847,
 1429558583,
 1429346694,
 -1,
 -43722,
 1429503434,
 67840,
 -1,
 1429563566,
 67855,
 -43720,
 1429531749,
 67846,
 -43719,
 1429728152,
 67849,
 -43718,
 1429791175,
 67845,
 -43717,
 1429846040,
 67859,
 -43716,
 1429908329,
 67858,
 -43715,
 1429972175,
 67856,
 -43714,
 1430033289,
 67853,
 -43713,
 1430095739,
 67852,
 -43712,
 1430157387,
 67851,
 -43711,
 1430221771,
 67850,
 -43710,
 1430279574,
 67842,
 -43709,
 1430338286,
 67843,
 -1,
 1430399379,
 67841,
 1430607181,
 1428853581,
 -1,
 1430672715,
 1430570913,
 -1,
 1430738249,
 1430642875,
 -1,
 -43704,
 1430688791,
 67866,
 -1,
 1430735158,
 67864,
 -43702,
 1430675936,
 67867,
 -1,
 1430865863,
 67863,
 1431109631,
 1430624341,
 67862,
 -1,
 1430979416,
 67865,
 -1,
 1430579096,
 67871,
 -1,
 1428783966,
 11227,
 1431328195,
 1419540239,
 -1,
 1431393722,
 1431247238,
 -1,
 1431459257,
 1431366387,
 -1,
 1431524728,
 1431422881,
 -1,
 1431590249,
 1431484830,
 -1,
 1431655775,
 1431507260,
 127201,
 -43690,
 1431574740,
 127219,
 -43689,
 1431640099,
 127218,
 -43688,
 1431705411,
 127217,
 -43687,
 1431770739,
 127216,
 -43686,
 1431836030,
 127215,
 -43685,
 1431901354,
 127214,
 -43684,
 1431966604,
 127213,
 -43683,
 1432031847,
 127212,
 -43682,
 1432097084,
 127211,
 -1,
 1432162348,
 127210,
 1432376674,
 1431573095,
 127202,
 -43679,
 1432293692,
 127221,
 -1,
 1432358956,
 127220,
 -43677,
 1432295636,
 127209,
 -43676,
 1432492067,
 127208,
 -43675,
 1432557379,
 127207,
 -43674,
 1432622707,
 127206,
 -43673,
 1432687998,
 127205,
 -43672,
 1432753322,
 127204,
 -1,
 1432818572,
 127203,
 1433032046,
 1431561918,
 -1,
 -43669,
 1432994534,
 127138,
 -43668,
 1433034008,
 127154,
 -43667,
 1433091120,
 127170,
 -1,
 1433154575,
 127186,
 1433359731,
 1432969874,
 -1,
 -43664,
 1433322214,
 127139,
 -43663,
 1433361688,
 127155,
 -43662,
 1433418800,
 127171,
 -1,
 1433482255,
 127187,
 1433731071,
 1433290736,
 -1,
 -43659,
 1433649894,
 127146,
 -43658,
 1433689368,
 127162,
 -43657,
 1433746480,
 127178,
 -1,
 1433809935,
 127194,
 1434015109,
 1431457425,
 -1,
 1434080640,
 1433965591,
 -1,
 1434146175,
 1434048970,
 -1,
 -43652,
 1434108646,
 127140,
 -43651,
 1434148120,
 127156,
 -43650,
 1434205232,
 127172,
 -1,
 1434268687,
 127188,
 -1,
 1434097278,
 127200,
 1434583039,
 1434022155,
 -1,
 -43646,
 1434501862,
 127141,
 -43645,
 1434541336,
 127157,
 -43644,
 1434598448,
 127173,
 -1,
 1434661903,
 127189,
 1434867088,
 1433975297,
 -1,
 1434932619,
 1434808704,
 -1,
 -43640,
 1434895078,
 127142,
 -43639,
 1434934552,
 127158,
 -43638,
 1434991664,
 127174,
 -1,
 1435055119,
 127190,
 1435303935,
 1434864811,
 -1,
 -43635,
 1435222758,
 127143,
 -43634,
 1435262232,
 127159,
 -43633,
 1435319344,
 127175,
 -1,
 1435382799,
 127191,
 1435587995,
 1434809145,
 -1,
 1435653526,
 1435537444,
 -1,
 -43629,
 1435615974,
 127148,
 -43628,
 1435655448,
 127164,
 -43627,
 1435712560,
 127180,
 -1,
 1435776015,
 127196,
 1436024831,
 1435593446,
 -1,
 -43624,
 1435943654,
 127150,
 -43623,
 1435983128,
 127166,
 -43622,
 1436040240,
 127182,
 -1,
 1436103695,
 127198,
 1436308896,
 1435544629,
 -1,
 -43619,
 1436271334,
 127149,
 -43618,
 1436310808,
 127165,
 -43617,
 1436367920,
 127181,
 -1,
 1436431375,
 127197,
 1436636581,
 1436258392,
 -1,
 -43614,
 1436599014,
 127145,
 -43613,
 1436638488,
 127161,
 -43612,
 1436695600,
 127177,
 -1,
 1436759055,
 127193,
 1436964266,
 1436578350,
 -1,
 -43609,
 1436926694,
 127147,
 -43608,
 1436966168,
 127163,
 -43607,
 1437023280,
 127179,
 -1,
 1437086735,
 127195,
 1437291951,
 1436894887,
 -1,
 -43604,
 1437254374,
 127144,
 -43603,
 1437293848,
 127160,
 -43602,
 1437350960,
 127176,
 -1,
 1437414415,
 127192,
 1437619636,
 1437211479,
 -1,
 -43599,
 1437582054,
 127137,
 -43598,
 1437621528,
 127153,
 -43597,
 1437678640,
 127169,
 -1,
 1437742095,
 127185,
 1437947319,
 1437542239,
 -1,
 -43594,
 1437890455,
 127183,
 -1,
 1437932387,
 127136,
 -43592,
 1437918051,
 127199,
 -1,
 1438101631,
 127167,
 -1,
 1431383984,
 128720,
 1438340546,
 1431360410,
 983150,
 1438449663,
 1438305880,
 -1,
 1438471615,
 1438369697,
 -1,
 -43586,
 1438443030,
 11219,
 -1,
 1438474720,
 11220,
 1438711807,
 1438404241,
 -1,
 -43583,
 1438621437,
 11221,
 -1,
 1438675134,
 11222,
 -1,
 1438267661,
 983147,
 1438930408,
 1431288635,
 -1,
 1438995929,
 1438874966,
 -1,
 1439061450,
 1438956033,
 -1,
 1439126985,
 1438980486,
 -1,
 -43576,
 1439074146,
 68493,
 -1,
 1439120319,
 68495,
 -1,
 1439063882,
 68496,
 1439389132,
 1438997658,
 68484,
 -1,
 1439353534,
 68487,
 -43571,
 1439362286,
 68486,
 -43570,
 1439493033,
 68488,
 -43569,
 1439556079,
 68485,
 -43568,
 1439615317,
 68497,
 -43567,
 1439671503,
 68494,
 -43566,
 1439732617,
 68492,
 -43565,
 1439795071,
 68491,
 -43564,
 1439856726,
 68490,
 -43563,
 1439921159,
 68489,
 -43562,
 1439979546,
 68482,
 -43561,
 1440037358,
 68483,
 -43560,
 1440098723,
 68481,
 -1,
 1440161532,
 68480,
 1440372195,
 1438946125,
 -1,
 1440437728,
 1440335777,
 -1,
 1440503262,
 1440407739,
 -1,
 -43555,
 1440453655,
 68522,
 -1,
 1440500022,
 68526,
 -43553,
 1440440800,
 68523,
 -1,
 1440630727,
 68525,
 1440830946,
 1440389205,
 68521,
 -1,
 1440744280,
 68527,
 -1,
 1440764647,
 68524,
 1441027558,
 1440305971,
 -1,
 -43547,
 1440955731,
 68508,
 -1,
 1441019651,
 68507,
 -43545,
 1440993876,
 68506,
 -1,
 1441184831,
 68505,
 1441355283,
 1438887110,
 -1,
 1441420799,
 1441284606,
 -1,
 1441486333,
 1441381519,
 -1,
 1441551856,
 1441444715,
 -1,
 1441617391,
 1441522543,
 -1,
 -43538,
 1441559723,
 65048,
 -1,
 1441608532,
 983256,
 -1,
 1441579876,
 65096,
 1441879539,
 1441495792,
 -1,
 -43534,
 1441850244,
 65047,
 -1,
 1441907556,
 65095,
 1442076150,
 1441817972,
 -1,
 -43531,
 1442010295,
 65042,
 -1,
 1442067610,
 65041,
 1442272761,
 1442001965,
 -1,
 -43528,
 1442220482,
 65040,
 -1,
 1442283706,
 65043,
 -43526,
 1442233468,
 65044,
 -43525,
 1442425963,
 65046,
 -43524,
 1442472182,
 65049,
 -1,
 1442532730,
 65045,
 -43522,
 1441452949,
 129384,
 -1,
 1442666636,
 129328,
 1442862606,
 1441358765,
 -1,
 1442928137,
 1442831299,
 -1,
 1442993672,
 1442892176,
 -1,
 1443059205,
 1442909861,
 -1,
 -43516,
 1442976359,
 983166,
 -1,
 1443041596,
 983163,
 1443299327,
 1442971648,
 -1,
 -43513,
 1443222203,
 983165,
 -1,
 1443272789,
 983162,
 -1,
 1442920697,
 983192,
 1443561471,
 1442876460,
 -1,
 1443583500,
 1443482176,
 128424,
 -1,
 1443496801,
 128438,
 1443758079,
 1443508125,
 129332,
 -1,
 1443677108,
 128120,
 1443845650,
 1442812951,
 -1,
 -43504,
 1443806466,
 11224,
 -43503,
 1443847784,
 128711,
 -1,
 1443900014,
 129455,
 -1,
 1443768128,
 128255,
 1444173370,
 1441284606,
 -1,
 1444238893,
 1444129990,
 -1,
 1444304425,
 1444198913,
 -1,
 1444369960,
 1444255674,
 -1,
 1444435495,
 1444282368,
 -1,
 1444501023,
 1444406348,
 -1,
 1444566556,
 1444423519,
 -1,
 -43493,
 1444511934,
 128113,
 -1,
 1444552525,
 9977,
 -43491,
 1444522220,
 128590,
 -43490,
 1444699371,
 129493,
 -1,
 1444762161,
 128591,
 1444959778,
 1444440241,
 -1,
 -43487,
 1444922559,
 129494,
 -1,
 1444970881,
 129496,
 -43485,
 1444916768,
 128588,
 -43484,
 1445090371,
 128589,
 -43483,
 1445149990,
 129336,
 -43482,
 1445213056,
 129495,
 -1,
 1445276759,
 128583,
 -1,
 1444355738,
 128187,
 -1,
 1444302086,
 128547,
 -43478,
 1444259159,
 10178,
 -43477,
 1445561664,
 9854,
 -43476,
 1445614220,
 127917,
 -1,
 1445660970,
 8524,
 1445877298,
 1444187180,
 -1,
 -43473,
 1445841019,
 9956,
 -43472,
 1445904521,
 128532,
 -43471,
 1445943716,
 128039,
 -1,
 1445987991,
 128390,
 1446204984,
 1445796230,
 -1,
 1446270518,
 1446129059,
 -1,
 -43467,
 1446221024,
 129434,
 -1,
 1446271499,
 127825,
 -43465,
 1446227142,
 127824,
 -1,
 1446417323,
 129372,
 -43463,
 1446170590,
 129515,
 -1,
 1446525839,
 128694,
 1446729308,
 1444123671,
 -1,
 1446794818,
 1446699641,
 -1,
 1446860351,
 1446754817,
 -1,
 -43458,
 1446832970,
 9211,
 -1,
 1446869678,
 9214,
 1447100415,
 1446811578,
 -1,
 -43455,
 1446973312,
 9212,
 -1,
 1447037335,
 9213,
 1447253576,
 1446761370,
 -1,
 1447319110,
 1447218639,
 -1,
 -43451,
 1447251689,
 128545,
 -1,
 1447309098,
 128574,
 -43449,
 1447265025,
 127831,
 -1,
 1447440452,
 128093,
 1447646797,
 1447217057,
 -1,
 1447712332,
 1447565702,
 -1,
 -43445,
 1447677518,
 129364,
 -1,
 1447701297,
 128688,
 -1,
 1447626029,
 127858,
 1447974482,
 1447606785,
 -1,
 1448040017,
 1447937953,
 -1,
 -43440,
 1447963749,
 128238,
 -1,
 1448025766,
 128239,
 -1,
 1447970428,
 11239,
 1448302166,
 1447919126,
 -1,
 1448367701,
 1448226549,
 128659,
 -1,
 1448327826,
 128680,
 -1,
 1448318345,
 128110,
 1448564313,
 1448256175,
 -1,
 -43432,
 1448490535,
 127871,
 -1,
 1448542812,
 8297,
 -43430,
 1448524046,
 128254,
 -43429,
 1448711502,
 128041,
 -1,
 1448751961,
 128425,
 1448957548,
 1446667181,
 -1,
 1449023074,
 1448905772,
 -1,
 1449088609,
 1448952318,
 -1,
 -43424,
 1449009794,
 127821,
 -1,
 1449067088,
 127885,
 -1,
 1449013598,
 129295,
 1449350758,
 1448957128,
 128022,
 1449459711,
 1449263104,
 -1,
 -43419,
 1449365943,
 128061,
 -1,
 1449414377,
 128055,
 1449612905,
 1449293583,
 -1,
 -43416,
 1449555727,
 128138,
 -1,
 1449607806,
 128169,
 -43414,
 1449575734,
 128299,
 -43413,
 1449738750,
 129383,
 -1,
 1449800447,
 9935,
 1450006134,
 1448924058,
 -1,
 1450071664,
 1449962694,
 -1,
 -43409,
 1450032153,
 128091,
 -1,
 1450092284,
 128156,
 -43407,
 1450035137,
 128686,
 -43406,
 1450229528,
 128204,
 -43405,
 1450282301,
 11854,
 -43404,
 1450322763,
 128226,
 -43403,
 1450381927,
 983167,
 -1,
 1450447164,
 983164,
 1450661497,
 1449933069,
 -1,
 -43400,
 1450599341,
 983233,
 -1,
 1450659473,
 983224,
 -1,
 1450607475,
 983193,
 1450924399,
 1394693320,
 -1,
 1450989534,
 1450880198,
 -1,
 1451054954,
 1450919181,
 -1,
 1451120485,
 1450996539,
 -1,
 1451185874,
 1451039110,
 -1,
 1451251407,
 1451112184,
 -1,
 1451316901,
 1451173444,
 -1,
 1451382420,
 1451249667,
 -1,
 1451447949,
 1451351192,
 65859,
 1451556863,
 1451360256,
 -1,
 1451579016,
 1451476897,
 -1,
 1451644551,
 1451516325,
 65862,
 -1,
 1451559356,
 65870,
 -1,
 1451564789,
 65864,
 1451841164,
 1451516723,
 65861,
 1451950079,
 1451753472,
 -1,
 -43381,
 1451870414,
 65868,
 -1,
 1451934903,
 65875,
 -1,
 1451803831,
 65871,
 1452212223,
 1451381932,
 65860,
 1452277759,
 1452081152,
 -1,
 1452299923,
 1452197793,
 -1,
 1452365458,
 1452237221,
 65863,
 -1,
 1452280190,
 65878,
 -1,
 1452285685,
 65866,
 -1,
 1452262583,
 65873,
 1452627615,
 1451333721,
 -1,
 1452693146,
 1452562955,
 -1,
 1452758681,
 1452660630,
 -1,
 -43368,
 1452722382,
 65867,
 -1,
 1452786871,
 65874,
 -1,
 1452678929,
 65857,
 1453020829,
 1452657577,
 -1,
 -43364,
 1452984526,
 65869,
 -1,
 1453049015,
 65876,
 -43362,
 1452977113,
 65856,
 -1,
 1453146398,
 65858,
 1453391871,
 1452591628,
 -1,
 1453414051,
 1453311905,
 -1,
 -43358,
 1453351363,
 65877,
 -1,
 1453399797,
 65865,
 -43356,
 1453376695,
 65872,
 -1,
 1453558232,
 65879,
 1453741758,
 1451280289,
 -1,
 1453807286,
 1453678069,
 -1,
 1453872813,
 1453770657,
 -1,
 1453938347,
 1453808139,
 -1,
 -43350,
 1453895858,
 65899,
 -1,
 1453944595,
 65893,
 -43348,
 1453909526,
 65884,
 -1,
 1454065607,
 65892,
 1454266033,
 1453824085,
 65881,
 1454374911,
 1454178304,
 -1,
 -43344,
 1454295968,
 65905,
 -1,
 1454334771,
 65898,
 1454571519,
 1454198787,
 -1,
 1454593717,
 1454496923,
 -1,
 -43340,
 1454558112,
 65906,
 -1,
 1454596915,
 65902,
 -1,
 1454527660,
 65897,
 1454899199,
 1453766562,
 -1,
 1454921404,
 1454788611,
 -1,
 1454986938,
 1454890136,
 65887,
 -1,
 1454900056,
 65901,
 1455161343,
 1454920876,
 65894,
 -1,
 1455030305,
 65895,
 1455292415,
 1454885384,
 65888,
 -1,
 1455161377,
 65889,
 1455380164,
 1453678001,
 -1,
 1455445699,
 1455327633,
 -1,
 -43327,
 1455409672,
 65890,
 -43326,
 1455462485,
 65882,
 -1,
 1455509516,
 65896,
 -1,
 1455365299,
 65880,
 1455773384,
 1455311280,
 -1,
 1455838919,
 1455739579,
 65883,
 -1,
 1455751841,
 65886,
 -1,
 1455771977,
 65900,
 1456035531,
 1455697315,
 -1,
 -43318,
 1456008181,
 65885,
 -1,
 1456022689,
 65903,
 -43316,
 1455998396,
 65908,
 -43315,
 1456180491,
 65904,
 -43314,
 1456244681,
 65891,
 -1,
 1456290524,
 65907,
 1456537599,
 1451207878,
 -1,
 -43311,
 1456457811,
 65926,
 -1,
 1456512903,
 65927,
 1456690939,
 1451124910,
 -1,
 1456756474,
 1456653904,
 -1,
 1456821980,
 1456673962,
 119327,
 -43306,
 1456740564,
 119356,
 -43305,
 1456805923,
 119355,
 -43304,
 1456871235,
 119354,
 -43303,
 1456936318,
 119353,
 -43302,
 1457001356,
 119352,
 -43301,
 1457066599,
 119351,
 -1,
 1457131564,
 119350,
 1457346276,
 1456738620,
 119325,
 -43298,
 1457264852,
 119337,
 -43297,
 1457330211,
 119336,
 -43296,
 1457395523,
 119335,
 -43295,
 1457460394,
 119334,
 -43294,
 1457525644,
 119333,
 -43293,
 1457590887,
 119332,
 -1,
 1457656124,
 119331,
 1457870571,
 1457263207,
 119326,
 -43290,
 1457789140,
 119343,
 -43289,
 1457854275,
 119342,
 -43288,
 1457919603,
 119341,
 -43287,
 1457984894,
 119340,
 -43286,
 1458050218,
 119339,
 -1,
 1458115468,
 119338,
 1458329329,
 1457788286,
 119328,
 -43283,
 1458246826,
 119361,
 -43282,
 1458312076,
 119360,
 -43281,
 1458377319,
 119359,
 -43280,
 1458442556,
 119358,
 -1,
 1458507820,
 119357,
 1458722552,
 1458246540,
 -1,
 -43277,
 1458641108,
 119349,
 -43276,
 1458706467,
 119348,
 -43275,
 1458771779,
 119347,
 -43274,
 1458837107,
 119346,
 -43273,
 1458901607,
 119345,
 -1,
 1458966572,
 119344,
 -43271,
 1458640931,
 119330,
 -1,
 1459099459,
 119329,
 -1,
 1456684118,
 65933,
 1459377945,
 1456660294,
 -1,
 1459443463,
 1459294524,
 119296,
 -43266,
 1459362004,
 119314,
 -43265,
 1459427363,
 119313,
 -43264,
 1459492675,
 119312,
 -43263,
 1459558003,
 119311,
 -43262,
 1459623294,
 119310,
 -43261,
 1459688618,
 119309,
 -43260,
 1459753868,
 119308,
 -43259,
 1459819111,
 119307,
 -43258,
 1459884348,
 119306,
 -1,
 1459949612,
 119305,
 1460164365,
 1459361150,
 119300,
 -43255,
 1460081834,
 119324,
 -43254,
 1460147084,
 119323,
 -43253,
 1460212327,
 119322,
 -43252,
 1460277564,
 119321,
 -1,
 1460342828,
 119320,
 1460557587,
 1460081255,
 119297,
 -43249,
 1460475050,
 119319,
 -43248,
 1460540300,
 119318,
 -43247,
 1460605543,
 119317,
 -43246,
 1460670780,
 119316,
 -1,
 1460736044,
 119315,
 -43244,
 1460476116,
 119304,
 -43243,
 1460869155,
 119303,
 -43242,
 1460934467,
 119302,
 -43241,
 1460999795,
 119301,
 -43240,
 1461064874,
 119299,
 -1,
 1461130124,
 119298,
 1461344046,
 1459337729,
 -1,
 1461409574,
 1461290153,
 -1,
 1461475106,
 1461353814,
 -1,
 1461540639,
 1461434881,
 -1,
 -43234,
 1461477405,
 1016,
 -1,
 1461526597,
 1019,
 -43232,
 1461494668,
 887,
 -43231,
 1461673476,
 881,
 -1,
 1461723912,
 883,
 1461933861,
 1461432876,
 -1,
 -43228,
 1461879620,
 891,
 -1,
 1461927467,
 893,
 -1,
 1461861931,
 892,
 1462196012,
 1461376364,
 -1,
 -43224,
 1462153888,
 7528,
 -43223,
 1462216228,
 7529,
 -43222,
 1462261147,
 7527,
 -43221,
 1462317353,
 7530,
 -1,
 1462380951,
 7526,
 -43219,
 1462168431,
 65952,
 -1,
 1462529241,
 65932,
 1462720318,
 1461268146,
 -1,
 1462785849,
 1462662927,
 -1,
 1462851384,
 1462717377,
 -1,
 1462916916,
 1462811137,
 -1,
 -43213,
 1462853661,
 1015,
 -1,
 1462902853,
 1018,
 -43211,
 1462889397,
 895,
 -43210,
 1463067532,
 886,
 -43209,
 1463115268,
 880,
 -1,
 1463165704,
 882,
 -1,
 1462818590,
 1017,
 1463441212,
 1462743596,
 -1,
 -43205,
 1463386948,
 1021,
 -1,
 1463434795,
 1023,
 -43203,
 1463382995,
 975,
 -1,
 1463565867,
 1022,
 1463768904,
 1462662927,
 -1,
 1463834439,
 1463700434,
 -1,
 1463899971,
 1463788207,
 -1,
 -43198,
 1463861060,
 7466,
 -1,
 1463903149,
 7464,
 -43196,
 1463857824,
 7465,
 -43195,
 1464047502,
 43877,
 -43194,
 1464105040,
 7463,
 -1,
 1464161691,
 7462,
 -1,
 1463775390,
 65923,
 1464424273,
 1463732129,
 -1,
 1464489804,
 1464395289,
 -1,
 -43189,
 1464454023,
 65911,
 -1,
 1464505495,
 65917,
 1464686415,
 1464426981,
 -1,
 -43186,
 1464642593,
 65912,
 -1,
 1464702103,
 65918,
 -43184,
 1464646115,
 65929,
 -1,
 1464803050,
 65914,
 1465014104,
 1464374295,
 -1,
 1465079638,
 1464962579,
 -1,
 1465145173,
 1465015054,
 65909,
 -1,
 1465057313,
 65910,
 -1,
 1465101323,
 65931,
 -43177,
 1465047033,
 65924,
 -1,
 1465265087,
 65916,
 1465472859,
 1464959859,
 -1,
 -43174,
 1465441033,
 119365,
 -1,
 1465469876,
 65921,
 1465669470,
 1465405073,
 -1,
 -43171,
 1465622322,
 65919,
 -1,
 1465676028,
 65920,
 -43169,
 1465642306,
 65930,
 -43168,
 1465838124,
 65913,
 -43167,
 1465903234,
 65925,
 -43166,
 1465954980,
 1020,
 -43165,
 1466005235,
 65922,
 -43164,
 1466063072,
 65928,
 -1,
 1466122534,
 65915,
 1466367999,
 1451068462,
 -1,
 -43161,
 1466284833,
 129367,
 -43160,
 1466326272,
 128154,
 -43159,
 1466379249,
 128215,
 -1,
 1466442370,
 127823,
 1466652623,
 1450973574,
 -1,
 1466718157,
 1466602225,
 -1,
 1466783663,
 1466662230,
 -1,
 1466849143,
 1466751920,
 -1,
 1466914675,
 1466799277,
 -1,
 1466980209,
 1466870982,
 70411,
 -1,
 1466936518,
 70496,
 1467154431,
 1466922767,
 70412,
 -1,
 1467053839,
 70497,
 1467242358,
 1466844384,
 -1,
 -43147,
 1467170428,
 70495,
 -1,
 1467228709,
 70494,
 -1,
 1467160966,
 70453,
 1467504509,
 1466812321,
 -1,
 1467570043,
 1467467681,
 -1,
 -43142,
 1467505181,
 70432,
 -1,
 1467554182,
 70431,
 -43140,
 1467505181,
 70437,
 -1,
 1467685254,
 70436,
 1467897730,
 1467452460,
 -1,
 -43137,
 1467869599,
 70430,
 -43136,
 1467911286,
 70435,
 -43135,
 1467962647,
 70425,
 -1,
 1468012934,
 70440,
 1468225416,
 1467824397,
 -1,
 1468290950,
 1468152077,
 -1,
 -43131,
 1468226077,
 70434,
 -1,
 1468275078,
 70433,
 -43129,
 1468226077,
 70439,
 -1,
 1468406150,
 70438,
 1468618636,
 1468144006,
 70405,
 -43126,
 1468584858,
 70420,
 -43125,
 1468621741,
 70416,
 -1,
 1468668294,
 70406,
 1468880784,
 1468578305,
 -1,
 -43122,
 1468840662,
 70455,
 -43121,
 1468881437,
 70454,
 -1,
 1468930438,
 70456,
 1469142930,
 1468847002,
 70409,
 -1,
 1469109146,
 70410,
 1469274005,
 1469096623,
 -1,
 -43116,
 1469209117,
 70443,
 -1,
 1469258118,
 70442,
 1469470616,
 1469216527,
 -1,
 -43113,
 1469413209,
 70451,
 -1,
 1469454726,
 70450,
 1469667227,
 1469412153,
 -1,
 -43110,
 1469602333,
 70422,
 -1,
 1469651334,
 70421,
 1469863838,
 1469608461,
 -1,
 -43107,
 1469798941,
 70429,
 -1,
 1469847942,
 70428,
 1470060448,
 1469801389,
 70407,
 -1,
 1469997997,
 70408,
 1470191523,
 1469994184,
 -1,
 -43102,
 1470126621,
 70424,
 -1,
 1470175622,
 70423,
 1470388134,
 1470115235,
 -1,
 -43099,
 1470323229,
 70427,
 -1,
 1470372230,
 70426,
 1470584745,
 1470310239,
 -1,
 -43096,
 1470519837,
 70445,
 -1,
 1470568838,
 70444,
 -43094,
 1470556575,
 70447,
 -43093,
 1470737728,
 70448,
 -43092,
 1470798397,
 70419,
 -43091,
 1470858185,
 70446,
 -43090,
 1470913053,
 70457,
 -1,
 1470973197,
 70415,
 1471174591,
 1466753078,
 -1,
 1471240117,
 1471143773,
 -1,
 1471305651,
 1471196358,
 70467,
 -1,
 1471261894,
 70468,
 1471479807,
 1471248143,
 70498,
 -1,
 1471379215,
 70499,
 1471567801,
 1471158662,
 -1,
 -43081,
 1471533978,
 70476,
 -43080,
 1471570861,
 70472,
 -1,
 1471617414,
 70462,
 1471829947,
 1471533978,
 70465,
 -1,
 1471796122,
 70466,
 1471961021,
 1471767469,
 70463,
 -1,
 1471898541,
 70464,
 -43074,
 1471912509,
 70475,
 -1,
 1472021773,
 70471,
 1472223179,
 1471135673,
 -1,
 1472288707,
 1472192189,
 -1,
 -43070,
 1472248753,
 70403,
 -1,
 1472310873,
 70477,
 1472485318,
 1472212387,
 -1,
 -43067,
 1472436081,
 70400,
 -1,
 1472471358,
 70401,
 1472681929,
 1472403846,
 -1,
 -43064,
 1472650182,
 70461,
 -1,
 1472697234,
 70402,
 -43062,
 1472636842,
 70493,
 -1,
 1472828227,
 70460,
 -43060,
 1472173869,
 70480,
 -1,
 1472931449,
 70487,
 -43058,
 1466672649,
 127815,
 -1,
 1473069427,
 127891,
 1473271769,
 1466590125,
 -1,
 1473337304,
 1473220881,
 -1,
 1473402839,
 1473269481,
 128512,
 1473511423,
 1473317730,
 -1,
 1473533910,
 1473427969,
 -1,
 -43051,
 1473497374,
 129321,
 -1,
 1473546479,
 128513,
 -1,
 1473484987,
 129322,
 -1,
 1473326940,
 128568,
 -1,
 1473283046,
 128556,
 1473970175,
 1473221655,
 -1,
 1473992669,
 1473894432,
 -1,
 -43044,
 1473952940,
 983109,
 -1,
 1474004339,
 11218,
 -1,
 1473963029,
 128151,
 1474254948,
 1450918398,
 -1,
 1474320478,
 1474206863,
 -1,
 1474385950,
 1474267968,
 -1,
 1474451433,
 1474320907,
 -1,
 1474516966,
 1474369926,
 -1,
 1474582501,
 1474473158,
 7348,
 -1,
 1474509170,
 7358,
 -1,
 1474511358,
 7344,
 -43033,
 1474467155,
 7349,
 -43032,
 1474717098,
 7346,
 -1,
 1474773502,
 7345,
 1474975727,
 1474375075,
 -1,
 1475041261,
 1474910731,
 -1,
 -43028,
 1474980014,
 7337,
 -1,
 1475027628,
 7341,
 -43026,
 1474979809,
 7340,
 -1,
 1475158085,
 7338,
 1475368948,
 1474938785,
 -1,
 1475434483,
 1475287430,
 -1,
 -43022,
 1475390662,
 7330,
 -1,
 1475447852,
 7319,
 -1,
 1475402312,
 7353,
 1475696632,
 1475287430,
 -1,
 -43018,
 1475644460,
 7312,
 -43017,
 1475700910,
 7354,
 -1,
 1475758023,
 7357,
 1475958779,
 1475669040,
 -1,
 -43014,
 1475894290,
 7327,
 -1,
 1475954631,
 7318,
 1476155390,
 1475918337,
 -1,
 -43011,
 1476091722,
 7336,
 -1,
 1476141125,
 7329,
 1476352001,
 1476108975,
 -1,
 -43008,
 1476287506,
 7332,
 -1,
 1476338348,
 7326,
 1476548612,
 1476294489,
 -1,
 -43005,
 1476508161,
 7322,
 -1,
 1476536859,
 7359,
 1476745223,
 1476490041,
 -1,
 -43002,
 1476680722,
 7333,
 -1,
 1476730949,
 7321,
 1476941834,
 1476686349,
 -1,
 -42999,
 1476880353,
 7339,
 -1,
 1476942678,
 7343,
 1477138445,
 1476875464,
 -1,
 -42996,
 1477073750,
 7334,
 -1,
 1477124165,
 7314,
 1477335056,
 1477067262,
 -1,
 -42993,
 1477282860,
 7316,
 -1,
 1477344853,
 7352,
 -42991,
 1477307270,
 7351,
 -42990,
 1477503051,
 7342,
 -42989,
 1477567010,
 7347,
 -42988,
 1477631750,
 7317,
 -42987,
 1477695251,
 7331,
 -42986,
 1477750154,
 7328,
 -42985,
 1477815116,
 7335,
 -42984,
 1477875642,
 7325,
 -42983,
 1477938398,
 7324,
 -42982,
 1478001929,
 7323,
 -42981,
 1478060206,
 7320,
 -42980,
 1478119427,
 7350,
 -42979,
 1478180175,
 7315,
 -1,
 1478240287,
 7313,
 1478449235,
 1474347406,
 -1,
 1478514726,
 1478384139,
 -1,
 1478580259,
 1478433158,
 -1,
 -42974,
 1478536390,
 11556,
 -1,
 1478574590,
 11552,
 -42972,
 1478530387,
 11557,
 -42971,
 1478714794,
 11554,
 -1,
 1478771198,
 11553,
 1478973484,
 1478438307,
 -1,
 1479039018,
 1478908427,
 -1,
 -42967,
 1478977710,
 11545,
 -1,
 1479025324,
 11549,
 -42965,
 1478977505,
 11548,
 -1,
 1479155781,
 11546,
 1479366703,
 1478945840,
 -1,
 -42962,
 1479302162,
 11535,
 -1,
 1479362503,
 11526,
 1479563314,
 1479329831,
 -1,
 -42959,
 1479519430,
 11538,
 -1,
 1479576620,
 11527,
 1479759925,
 1479522817,
 -1,
 -42956,
 1479696202,
 11544,
 -1,
 1479745605,
 11537,
 1479956536,
 1479713455,
 -1,
 -42953,
 1479891986,
 11540,
 -1,
 1479942828,
 11534,
 1480153147,
 1479897913,
 -1,
 -42950,
 1480088594,
 11541,
 -1,
 1480138821,
 11529,
 1480349758,
 1480094221,
 -1,
 -42947,
 1480288225,
 11547,
 -1,
 1480350550,
 11551,
 1480546369,
 1480283336,
 -1,
 -42944,
 1480481622,
 11542,
 -1,
 1480532037,
 11522,
 1480742980,
 1480464774,
 -1,
 -42941,
 1480690732,
 11520,
 -1,
 1480738759,
 11565,
 -42939,
 1480715142,
 11559,
 -42938,
 1480910923,
 11550,
 -42937,
 1480974882,
 11555,
 -42936,
 1481039622,
 11525,
 -42935,
 1481103123,
 11539,
 -42934,
 1481158026,
 11536,
 -42933,
 1481222988,
 11543,
 -42932,
 1481283514,
 11533,
 -42931,
 1481346270,
 11532,
 -42930,
 1481409801,
 11531,
 -42929,
 1481472255,
 11530,
 -42928,
 1481533614,
 11528,
 -42927,
 1481590727,
 11524,
 -42926,
 1481653583,
 11523,
 -1,
 1481713695,
 11521,
 1481922651,
 1478393174,
 -1,
 1481988183,
 1481841030,
 -1,
 -42922,
 1481926830,
 4346,
 -1,
 1481983943,
 4349,
 -42920,
 1481954308,
 983936,
 -42919,
 1482150444,
 4345,
 -42918,
 1482192761,
 4351,
 -1,
 1482251331,
 4350,
 1482489855,
 1481846485,
 -1,
 -42915,
 1482419078,
 4295,
 -1,
 1482431602,
 4301,
 1482643554,
 1474241196,
 9881,
 1482751999,
 1482558300,
 -1,
 -42911,
 1482661841,
 9965,
 -1,
 1482687291,
 9966,
 -42909,
 1482592265,
 129502,
 -1,
 1482851253,
 128142,
 1483036906,
 1474197263,
 -1,
 1483102438,
 1482955142,
 -1,
 1483167973,
 1483036848,
 -1,
 1483233446,
 1483129230,
 -1,
 1483298929,
 1483192833,
 -1,
 1483364461,
 1483233803,
 -1,
 1483429996,
 1483327527,
 11339,
 -1,
 1483384396,
 11356,
 -1,
 1483348358,
 11342,
 1483626607,
 1483310336,
 11348,
 -1,
 1483542087,
 11349,
 -42896,
 1483581028,
 11346,
 -1,
 1483702672,
 11332,
 1483888762,
 1483270436,
 -1,
 1483954295,
 1483817470,
 -1,
 1484019830,
 1483910342,
 -1,
 -42891,
 1483985818,
 11343,
 -1,
 1484022701,
 11344,
 -1,
 1483982444,
 11317,
 -42888,
 1483920282,
 11347,
 -42887,
 1484231703,
 11350,
 -1,
 1484269061,
 11345,
 1484478594,
 1483826093,
 11323,
 1484544126,
 1484451160,
 -1,
 -42883,
 1484484776,
 11355,
 -1,
 1484538366,
 11321,
 1484740737,
 1484496331,
 -1,
 -42880,
 1484702244,
 11351,
 -1,
 1484728904,
 11353,
 -1,
 1484689611,
 11322,
 1485002886,
 1484441505,
 -1,
 -42876,
 1484972171,
 11333,
 -42875,
 1485029188,
 11340,
 -1,
 1485092797,
 11357,
 1485265034,
 1484929293,
 -1,
 -42872,
 1485237500,
 11319,
 -42871,
 1485280418,
 11316,
 -1,
 1485337240,
 11324,
 1485527181,
 1485237296,
 -1,
 -42868,
 1485463520,
 11318,
 -1,
 1485522861,
 11320,
 1485723792,
 1485480623,
 -1,
 -42865,
 1485674096,
 11330,
 -1,
 1485718014,
 11338,
 1485920403,
 1485673495,
 -1,
 -42862,
 1485885827,
 11337,
 -1,
 1485935406,
 11329,
 1486117014,
 1485862671,
 -1,
 -42859,
 1486058270,
 11326,
 -1,
 1486104079,
 11358,
 1486313625,
 1486048913,
 -1,
 -42856,
 1486272271,
 11335,
 -1,
 1486319621,
 11354,
 1486510236,
 1486235487,
 -1,
 -42853,
 1486476915,
 11313,
 -1,
 1486513710,
 11352,
 -42851,
 1486478549,
 11314,
 -42850,
 1486673514,
 11334,
 -42849,
 1486731017,
 11331,
 -42848,
 1486785793,
 11328,
 -42847,
 1486851108,
 11327,
 -42846,
 1486910443,
 11325,
 -42845,
 1486970330,
 11336,
 -42844,
 1487034468,
 11315,
 -42843,
 1487090062,
 11341,
 -1,
 1487152987,
 11312,
 1487405055,
 1483157205,
 -1,
 1487427760,
 1487321601,
 -1,
 1487493292,
 1487362571,
 -1,
 1487558827,
 1487456295,
 11291,
 -1,
 1487513164,
 11308,
 -1,
 1487477126,
 11294,
 1487755438,
 1487439104,
 11300,
 -1,
 1487670855,
 11301,
 -42833,
 1487709796,
 11298,
 -1,
 1487831440,
 11284,
 1488017593,
 1487399204,
 -1,
 1488083126,
 1487946238,
 -1,
 1488148661,
 1488039110,
 -1,
 -42828,
 1488114586,
 11295,
 -1,
 1488151469,
 11296,
 -1,
 1488111212,
 11269,
 -42825,
 1488049050,
 11299,
 -42824,
 1488360471,
 11302,
 -1,
 1488397829,
 11297,
 1488607425,
 1487954861,
 11275,
 1488672957,
 1488579928,
 -1,
 -42820,
 1488613544,
 11307,
 -1,
 1488667134,
 11273,
 1488869568,
 1488625099,
 -1,
 -42817,
 1488831012,
 11303,
 -1,
 1488857672,
 11305,
 -1,
 1488818379,
 11274,
 1489131717,
 1488570273,
 -1,
 -42813,
 1489100939,
 11285,
 -42812,
 1489157956,
 11292,
 -1,
 1489221565,
 11309,
 1489393865,
 1489058061,
 -1,
 -42809,
 1489366268,
 11271,
 -42808,
 1489409186,
 11268,
 -1,
 1489466008,
 11276,
 1489656012,
 1489366064,
 -1,
 -42805,
 1489592288,
 11270,
 -1,
 1489651629,
 11272,
 1489852623,
 1489609391,
 -1,
 -42802,
 1489802864,
 11282,
 -1,
 1489846782,
 11290,
 1490049234,
 1489802263,
 -1,
 -42799,
 1490014595,
 11289,
 -1,
 1490064174,
 11281,
 1490245845,
 1489991439,
 -1,
 -42796,
 1490187038,
 11278,
 -1,
 1490232847,
 11310,
 1490442456,
 1490177681,
 -1,
 -42793,
 1490401039,
 11287,
 -1,
 1490448389,
 11306,
 1490639067,
 1490364255,
 -1,
 -42790,
 1490605683,
 11265,
 -1,
 1490642478,
 11304,
 -42788,
 1490607317,
 11266,
 -42787,
 1490802282,
 11286,
 -42786,
 1490859785,
 11283,
 -42785,
 1490914561,
 11280,
 -42784,
 1490979876,
 11279,
 -42783,
 1491039211,
 11277,
 -42782,
 1491099098,
 11288,
 -42781,
 1491163236,
 11267,
 -42780,
 1491218830,
 11293,
 -1,
 1491281755,
 11264,
 -1,
 1483129783,
 129371,
 1491599359,
 1483052055,
 -1,
 -42776,
 1491526688,
 127775,
 -42775,
 1491590798,
 129508,
 -1,
 1491609864,
 127760,
 1491818847,
 1483002778,
 -1,
 1491884352,
 1491767519,
 -1,
 1491949857,
 1491828054,
 -1,
 1492015347,
 1491912609,
 -1,
 1492080881,
 1491978145,
 -1,
 -42768,
 1492015645,
 73086,
 -1,
 1492064646,
 73085,
 -42766,
 1492015645,
 73076,
 -1,
 1492195718,
 73075,
 1492408569,
 1491941645,
 -1,
 1492474103,
 1492334861,
 -1,
 -42762,
 1492408861,
 73091,
 -1,
 1492457862,
 73090,
 -42760,
 1492408861,
 73081,
 -1,
 1492588934,
 73080,
 1492801789,
 1492326790,
 73056,
 -42757,
 1492767642,
 73067,
 -42756,
 1492804525,
 73064,
 -1,
 1492851078,
 73057,
 1493063935,
 1492767642,
 73060,
 -1,
 1493029786,
 73061,
 1493195010,
 1493017263,
 -1,
 -42751,
 1493129757,
 73094,
 -1,
 1493178758,
 73093,
 1493391621,
 1493142572,
 -1,
 -42748,
 1493325079,
 73092,
 -1,
 1493375366,
 73082,
 1493588232,
 1493333775,
 -1,
 -42745,
 1493530457,
 73087,
 -1,
 1493571974,
 73077,
 1493784843,
 1493529401,
 -1,
 -42742,
 1493719581,
 73074,
 -1,
 1493768582,
 73073,
 1493981454,
 1493725709,
 -1,
 -42739,
 1493916189,
 73089,
 -1,
 1493965190,
 73088,
 1494178064,
 1493918637,
 73058,
 -1,
 1494115245,
 73059,
 1494309139,
 1494111432,
 -1,
 -42734,
 1494243869,
 73079,
 -1,
 1494292870,
 73078,
 1494505750,
 1494232483,
 -1,
 -42731,
 1494440477,
 73084,
 -1,
 1494489478,
 73083,
 1494702361,
 1494427487,
 -1,
 -42728,
 1494637085,
 73071,
 -1,
 1494686086,
 73070,
 -42726,
 1494673823,
 73068,
 -42725,
 1494866883,
 73069,
 -42724,
 1494923990,
 73097,
 -42723,
 1494986048,
 73096,
 -42722,
 1495046717,
 73066,
 -42721,
 1495106505,
 73072,
 -42720,
 1495161373,
 73095,
 -1,
 1495221517,
 73063,
 1495423278,
 1491917744,
 -1,
 1495488813,
 1495376431,
 -1,
 1495554343,
 1495406982,
 -1,
 -42715,
 1495520154,
 73108,
 -42714,
 1495557037,
 73105,
 -1,
 1495603590,
 73098,
 1495816489,
 1495520154,
 73101,
 -1,
 1495782298,
 73102,
 1495947563,
 1495753645,
 73099,
 -1,
 1495884717,
 73100,
 -42708,
 1495898685,
 73107,
 -1,
 1496007949,
 73104,
 -1,
 1495428681,
 73111,
 1496275260,
 1495350371,
 -1,
 1496340786,
 1496237985,
 -1,
 -42703,
 1496311318,
 73122,
 -1,
 1496343008,
 73123,
 1496537397,
 1496300033,
 -1,
 -42700,
 1496478064,
 73126,
 -1,
 1496534165,
 73127,
 1496734008,
 1496469137,
 -1,
 -42697,
 1496686333,
 73124,
 -1,
 1496740030,
 73125,
 -42695,
 1496706331,
 73120,
 -42694,
 1496881237,
 73121,
 -42693,
 1496944712,
 73129,
 -1,
 1496991366,
 73128,
 1497192767,
 1496235961,
 -1,
 -42690,
 1497161504,
 73110,
 -1,
 1497178661,
 73109,
 -1,
 1497143085,
 73112,
 1497454930,
 1491825229,
 -1,
 1497520458,
 1497415609,
 -1,
 1497585989,
 1497483169,
 -1,
 -42684,
 1497556722,
 2815,
 -1,
 1497588417,
 2813,
 1497782600,
 1497545217,
 -1,
 -42681,
 1497749102,
 2810,
 -1,
 1497782850,
 2811,
 -42679,
 1497728022,
 2812,
 -1,
 1497903623,
 2814,
 1498110286,
 1497464150,
 -1,
 1498175821,
 1498079078,
 2700,
 -1,
 1498117903,
 2785,
 -1,
 1498148210,
 2809,
 1498372432,
 1498079332,
 2786,
 -1,
 1498314511,
 2787,
 -42671,
 1498331577,
 2801,
 -1,
 1498421959,
 2800,
 1498634585,
 1497413466,
 -1,
 1498700120,
 1498595257,
 -1,
 -42667,
 1498671589,
 2677,
 -42666,
 1498734368,
 2563,
 -42665,
 1498797505,
 2641,
 -1,
 1498815508,
 2561,
 -1,
 1498618567,
 2678,
 1499093340,
 1498571693,
 -1,
 -42661,
 1499056410,
 127928,
 -1,
 1499085434,
 129454,
 1499332607,
 1499013804,
 -1,
 -42658,
 1499218274,
 128130,
 -1,
 1499275705,
 8370,
 1499486566,
 1491768343,
 -1,
 1499552099,
 1499404678,
 -1,
 -42654,
 1499514785,
 128016,
 -1,
 1499559707,
 129349,
 -42652,
 1499510106,
 129421,
 -42651,
 1499692523,
 127948,
 -1,
 1499748107,
 129405,
 1499945322,
 1499426355,
 -1,
 1500010857,
 1499887375,
 128103,
 -1,
 1499970219,
 128714,
 -1,
 1499929830,
 129426,
 1500207469,
 1499863430,
 -1,
 -42644,
 1500165962,
 129476,
 -1,
 1500219040,
 127922,
 -42642,
 1500166657,
 983110,
 -1,
 1500340597,
 128123,
 1500535793,
 1450850573,
 -1,
 1500600979,
 1500484631,
 -1,
 1500666344,
 1500547420,
 -1,
 1500731821,
 1500634514,
 -1,
 1500797356,
 1500647079,
 -1,
 1500862844,
 1500714795,
 -1,
 -42634,
 1500780147,
 127123,
 -42633,
 1500845438,
 127122,
 -42632,
 1500910762,
 127121,
 -42631,
 1500976012,
 127120,
 -42630,
 1501041255,
 127119,
 -42629,
 1501106492,
 127118,
 -1,
 1501171756,
 127117,
 1501387140,
 1500780104,
 -1,
 -42626,
 1501304435,
 127116,
 -42625,
 1501369726,
 127115,
 -42624,
 1501435050,
 127114,
 -42623,
 1501500300,
 127113,
 -42622,
 1501565543,
 127112,
 -42621,
 1501630780,
 127111,
 -1,
 1501696044,
 127110,
 1501911436,
 1501304159,
 -1,
 -42618,
 1501828723,
 127109,
 -42617,
 1501894014,
 127108,
 -42616,
 1501959338,
 127107,
 -42615,
 1502024588,
 127106,
 -42614,
 1502089831,
 127105,
 -42613,
 1502155068,
 127104,
 -1,
 1502220332,
 127103,
 1502435732,
 1501828221,
 -1,
 -42610,
 1502353011,
 127102,
 -42609,
 1502418302,
 127101,
 -42608,
 1502483626,
 127100,
 -42607,
 1502548876,
 127099,
 -42606,
 1502614119,
 127098,
 -42605,
 1502679356,
 127097,
 -1,
 1502744620,
 127096,
 1502960028,
 1502352210,
 -1,
 -42602,
 1502877299,
 127095,
 -42601,
 1502942590,
 127094,
 -42600,
 1503007914,
 127093,
 -42599,
 1503073164,
 127092,
 -42598,
 1503138407,
 127091,
 -42597,
 1503203644,
 127090,
 -1,
 1503268908,
 127089,
 1503484324,
 1502876212,
 -1,
 -42594,
 1503401587,
 127088,
 -42593,
 1503466878,
 127087,
 -42592,
 1503532202,
 127086,
 -42591,
 1503597452,
 127085,
 -42590,
 1503662695,
 127084,
 -42589,
 1503727932,
 127083,
 -1,
 1503793196,
 127082,
 1504051199,
 1503400207,
 -1,
 -42586,
 1503925875,
 127081,
 -42585,
 1503991166,
 127080,
 -42584,
 1504056490,
 127079,
 -42583,
 1504121740,
 127078,
 -42582,
 1504186983,
 127077,
 -42581,
 1504252220,
 127076,
 -1,
 1504317484,
 127075,
 -1,
 1500709183,
 127074,
 1504641023,
 1500668124,
 -1,
 1504664039,
 1504513703,
 -1,
 1504729527,
 1504581419,
 -1,
 -42575,
 1504646771,
 127073,
 -42574,
 1504712062,
 127072,
 -42573,
 1504777386,
 127071,
 -42572,
 1504842636,
 127070,
 -42571,
 1504907879,
 127069,
 -42570,
 1504973116,
 127068,
 -1,
 1505038380,
 127067,
 1505253823,
 1504646728,
 -1,
 -42567,
 1505171059,
 127066,
 -42566,
 1505236350,
 127065,
 -42565,
 1505301674,
 127064,
 -42564,
 1505366924,
 127063,
 -42563,
 1505432167,
 127062,
 -42562,
 1505497404,
 127061,
 -1,
 1505562668,
 127060,
 1505778119,
 1505170783,
 -1,
 -42559,
 1505695347,
 127059,
 -42558,
 1505760638,
 127058,
 -42557,
 1505825962,
 127057,
 -42556,
 1505891212,
 127056,
 -42555,
 1505956455,
 127055,
 -42554,
 1506021692,
 127054,
 -1,
 1506086956,
 127053,
 1506302415,
 1505694845,
 -1,
 -42551,
 1506219635,
 127052,
 -42550,
 1506284926,
 127051,
 -42549,
 1506350250,
 127050,
 -42548,
 1506415500,
 127049,
 -42547,
 1506480743,
 127048,
 -42546,
 1506545980,
 127047,
 -1,
 1506611244,
 127046,
 1506826711,
 1506218834,
 -1,
 -42543,
 1506743923,
 127045,
 -42542,
 1506809214,
 127044,
 -42541,
 1506874538,
 127043,
 -42540,
 1506939788,
 127042,
 -42539,
 1507005031,
 127041,
 -42538,
 1507070268,
 127040,
 -1,
 1507135532,
 127039,
 1507351007,
 1506742836,
 -1,
 -42535,
 1507268211,
 127038,
 -42534,
 1507333502,
 127037,
 -42533,
 1507398826,
 127036,
 -42532,
 1507464076,
 127035,
 -42531,
 1507529319,
 127034,
 -42530,
 1507594556,
 127033,
 -1,
 1507659820,
 127032,
 1507917823,
 1507266831,
 -1,
 -42527,
 1507792499,
 127031,
 -42526,
 1507857790,
 127030,
 -42525,
 1507923114,
 127029,
 -42524,
 1507988364,
 127028,
 -42523,
 1508053607,
 127027,
 -42522,
 1508118844,
 127026,
 -1,
 1508184108,
 127025,
 -1,
 1504575807,
 127024,
 1508465209,
 1500599496,
 128021,
 1508530744,
 1508420931,
 -1,
 1508596260,
 1508474198,
 -1,
 1508661745,
 1508558753,
 -1,
 1508727279,
 1508624289,
 -1,
 -42514,
 1508661789,
 71701,
 -1,
 1508710790,
 71700,
 -42512,
 1508661789,
 71706,
 -1,
 1508841862,
 71705,
 1509054966,
 1508609068,
 -1,
 -42509,
 1509026207,
 71699,
 -42508,
 1509067894,
 71704,
 -42507,
 1509119255,
 71694,
 -1,
 1509169542,
 71709,
 1509382652,
 1508981005,
 -1,
 1509448186,
 1509308685,
 -1,
 -42503,
 1509382685,
 71703,
 -1,
 1509431686,
 71702,
 -42501,
 1509382685,
 71708,
 -1,
 1509562758,
 71707,
 1509775872,
 1509300614,
 71680,
 -42498,
 1509741466,
 71689,
 -42497,
 1509778349,
 71687,
 -1,
 1509824902,
 71681,
 1510038020,
 1509734913,
 -1,
 -42494,
 1509997270,
 71720,
 -42493,
 1510038045,
 71719,
 -1,
 1510087046,
 71721,
 1510300166,
 1510003610,
 71684,
 -1,
 1510265754,
 71685,
 1510431241,
 1510255814,
 -1,
 -42488,
 1510387008,
 71723,
 -1,
 1510414726,
 71716,
 1510627852,
 1510384303,
 -1,
 -42485,
 1510562333,
 71711,
 -1,
 1510611334,
 71710,
 1510824463,
 1510568761,
 -1,
 -42482,
 1510758941,
 71691,
 -1,
 1510807942,
 71690,
 1511021074,
 1510765069,
 -1,
 -42479,
 1510955549,
 71698,
 -1,
 1511004550,
 71697,
 1511217684,
 1510957997,
 71682,
 -1,
 1511154605,
 71683,
 1511348759,
 1511150792,
 -1,
 -42474,
 1511283229,
 71693,
 -1,
 1511332230,
 71692,
 1511545370,
 1511271843,
 -1,
 -42471,
 1511479837,
 71696,
 -1,
 1511528838,
 71695,
 1511741981,
 1511466847,
 -1,
 -42468,
 1511676445,
 71713,
 -1,
 1511725446,
 71712,
 -42466,
 1511713183,
 71715,
 -42465,
 1511906243,
 71718,
 -42464,
 1511953431,
 71688,
 -42463,
 1512014793,
 71714,
 -42462,
 1512077145,
 71717,
 -42461,
 1512135197,
 71722,
 -1,
 1512194558,
 71686,
 1512397361,
 1508565046,
 -1,
 1512462889,
 1512315270,
 -1,
 -42457,
 1512428442,
 71734,
 -42456,
 1512465325,
 71732,
 -1,
 1512511878,
 71724,
 1512725035,
 1512431472,
 71729,
 -1,
 1512680646,
 71730,
 1512856109,
 1512690586,
 71727,
 -1,
 1512821658,
 71728,
 1512987183,
 1512793005,
 71725,
 -1,
 1512924077,
 71726,
 -42448,
 1512936471,
 71733,
 -1,
 1513046526,
 71731,
 1513249335,
 1512357817,
 -1,
 1513314869,
 1513217725,
 -1,
 -42444,
 1513274289,
 71736,
 -1,
 1513336409,
 71737,
 -42442,
 1513263939,
 71738,
 -1,
 1513431589,
 71735,
 -1,
 1513167559,
 71739,
 -1,
 1508442812,
 128054,
 1513773681,
 1508435384,
 -1,
 1513839214,
 1513742678,
 -1,
 1513904745,
 1513798147,
 -1,
 1513970258,
 1513867169,
 -1,
 1514035793,
 1513927388,
 -1,
 1514101328,
 1513950989,
 -1,
 1514166861,
 1514021906,
 11107,
 1514274815,
 1514078208,
 -1,
 1514297931,
 1514202188,
 -1,
 1514363461,
 1514242311,
 -1,
 -42428,
 1514321119,
 11169,
 -1,
 1514372130,
 11168,
 -42426,
 1514331736,
 129075,
 -42425,
 1514507490,
 129059,
 -42424,
 1514571517,
 129063,
 -42423,
 1514626371,
 129071,
 -42422,
 1514684225,
 11133,
 -1,
 1514744799,
 129067,
 -42420,
 1514262097,
 11123,
 -1,
 1514896547,
 11139,
 -42418,
 1514139033,
 11085,
 -42417,
 1515037525,
 11143,
 -1,
 1515076154,
 11117,
 -1,
 1514012952,
 129171,
 -1,
 1514006291,
 11247,
 1515412060,
 1513888134,
 -1,
 1515477595,
 1515370719,
 -1,
 1515543127,
 1515438352,
 -1,
 -42410,
 1515507708,
 129027,
 -1,
 1515538928,
 129043,
 -42408,
 1515491791,
 129179,
 -42407,
 1515685656,
 129031,
 -42406,
 1515747535,
 129035,
 -1,
 1515801072,
 129047,
 -1,
 1515425079,
 11796,
 1516067423,
 1515371009,
 -1,
 -42402,
 1516022732,
 129083,
 -1,
 1516052952,
 129107,
 1516264034,
 1516002603,
 -1,
 -42399,
 1516188911,
 129091,
 -1,
 1516250130,
 129095,
 1516460645,
 1516186336,
 -1,
 -42396,
 1516384873,
 11147,
 -1,
 1516446738,
 11015,
 -42394,
 1516430095,
 129175,
 -42393,
 1516615579,
 128623,
 -42392,
 1516654793,
 129079,
 -1,
 1516713199,
 129087,
 1516961791,
 1513816777,
 -1,
 1516984940,
 1516868034,
 129289,
 -1,
 1516899367,
 129291,
 1517158399,
 1516920955,
 129288,
 -1,
 1517030439,
 129290,
 1517289471,
 1513754531,
 -1,
 -42384,
 1517208010,
 128317,
 -1,
 1517269142,
 128315,
 1517443714,
 1513739162,
 -1,
 1517509249,
 1517366052,
 -1,
 1517574780,
 1517420544,
 -1,
 1517640311,
 1517533697,
 -1,
 -42378,
 1517607703,
 11844,
 -1,
 1517668456,
 11849,
 -42376,
 1517608347,
 9208,
 -42375,
 1517786233,
 11799,
 -42374,
 1517847052,
 11842,
 -42373,
 1517904806,
 11840,
 -1,
 1517959345,
 10175,
 1518164608,
 1517500687,
 -1,
 -42370,
 1518126942,
 11260,
 -42369,
 1518175357,
 9891,
 -1,
 1518227323,
 9890,
 -1,
 1518080006,
 8508,
 -1,
 1517442942,
 127849,
 1518557834,
 1517408583,
 -1,
 1518623366,
 1518516737,
 -1,
 -42363,
 1518578616,
 11034,
 -1,
 1518638826,
 11850,
 -42361,
 1518587794,
 11784,
 -42360,
 1518777499,
 11798,
 -42359,
 1518834796,
 11795,
 -1,
 1518876419,
 8284,
 1519082127,
 1518483554,
 128462,
 1519190015,
 1518996322,
 -1,
 1519213198,
 1519110836,
 128441,
 -1,
 1519124623,
 128442,
 -1,
 1519167068,
 128443,
 -42352,
 1519049906,
 128330,
 -42351,
 1519361061,
 128682,
 -42350,
 1519420049,
 128044,
 -1,
 1519453409,
 128687,
 1519672126,
 1500566426,
 -1,
 1519737660,
 1519626059,
 -1,
 1519803150,
 1519680854,
 -1,
 1519868594,
 1519761921,
 113692,
 1519934117,
 1519779840,
 -1,
 1519999642,
 1519903833,
 113701,
 -1,
 1519911272,
 113702,
 1520130716,
 1519962017,
 113714,
 -1,
 1520044140,
 113715,
 1520261790,
 1520083631,
 113716,
 -1,
 1520175212,
 113717,
 1520392864,
 1520202553,
 113727,
 -1,
 1520306284,
 113728,
 1520523938,
 1520333325,
 113696,
 -1,
 1520437470,
 113710,
 -42333,
 1520482817,
 113706,
 -42332,
 1520602156,
 113723,
 -1,
 1520665459,
 113724,
 1520851633,
 1519878285,
 -1,
 1520917162,
 1520779774,
 -1,
 -42328,
 1520864300,
 113767,
 -42327,
 1520917003,
 113740,
 -1,
 1520976382,
 113742,
 1521179309,
 1520866327,
 -1,
 -42324,
 1521148091,
 113730,
 -1,
 1521191980,
 113769,
 -42322,
 1521144730,
 113752,
 -42321,
 1521316365,
 113685,
 -42320,
 1521367978,
 113682,
 -1,
 1521426501,
 113768,
 -1,
 1520787807,
 113737,
 1521703613,
 1519815724,
 113690,
 1521769144,
 1521624258,
 -1,
 -42315,
 1521734554,
 113761,
 -42314,
 1521783831,
 113762,
 -42313,
 1521836973,
 113763,
 -1,
 1521883526,
 113764,
 1522139135,
 1521680384,
 -1,
 1522162363,
 1522041715,
 113694,
 -1,
 1522075870,
 113708,
 -42308,
 1522132057,
 113698,
 -1,
 1522252289,
 113704,
 1522424519,
 1521644045,
 113691,
 1522532351,
 1522335744,
 -1,
 1522555585,
 1522459737,
 113699,
 -1,
 1522514513,
 113700,
 1522686659,
 1522514433,
 113705,
 -1,
 1522600999,
 113711,
 1522817733,
 1522633772,
 113712,
 -1,
 1522731230,
 113713,
 1522991103,
 1522762611,
 113695,
 -1,
 1522862302,
 113709,
 1523079887,
 1522393275,
 113720,
 1523145418,
 1523029015,
 113757,
 -1,
 1523114171,
 113760,
 -42293,
 1523082157,
 113758,
 -42292,
 1523210763,
 113721,
 -42291,
 1523271285,
 113759,
 -42290,
 1523325318,
 113756,
 -1,
 1523386476,
 113722,
 1523604181,
 1523035334,
 113675,
 1523669715,
 1523554136,
 -1,
 -42286,
 1523635098,
 113750,
 -1,
 1523671981,
 113741,
 -42284,
 1523603979,
 113688,
 -1,
 1523779806,
 113680,
 1523997402,
 1523553303,
 113732,
 -42281,
 1523966139,
 113754,
 -42280,
 1524028314,
 113755,
 -42279,
 1524078072,
 113753,
 -1,
 1524111750,
 113731,
 1524325088,
 1523942259,
 113689,
 1524432895,
 1524236288,
 -1,
 1524456158,
 1524337708,
 113693,
 -1,
 1524369630,
 113707,
 -42273,
 1524425817,
 113697,
 -1,
 1524546049,
 113703,
 1524718308,
 1524290458,
 113745,
 -42270,
 1524655021,
 113738,
 -42269,
 1524718091,
 113751,
 -1,
 1524761818,
 113748,
 1524980457,
 1524680609,
 113667,
 1525045992,
 1524891648,
 -1,
 -42265,
 1525004801,
 113718,
 -1,
 1525067000,
 113719,
 -1,
 1524980235,
 113681,
 1525308142,
 1524933295,
 113666,
 1525373677,
 1525238476,
 -1,
 -42260,
 1525320748,
 113765,
 -1,
 1525384051,
 113766,
 -1,
 1525286106,
 113676,
 1525635827,
 1525249807,
 113670,
 1525701362,
 1525586251,
 -1,
 -42255,
 1525666714,
 113749,
 -1,
 1525703597,
 113743,
 -1,
 1525635595,
 113687,
 1525963512,
 1525576505,
 113669,
 1526029047,
 1525874688,
 -1,
 -42250,
 1525984504,
 113725,
 -1,
 1526039411,
 113679,
 -1,
 1525969721,
 113684,
 1526291195,
 1525891582,
 113735,
 -42246,
 1526256538,
 113746,
 -1,
 1526284798,
 113739,
 1526487806,
 1526216973,
 113672,
 -42243,
 1526422027,
 113683,
 -1,
 1526466782,
 113677,
 1526684416,
 1526458387,
 113665,
 -1,
 1526653115,
 113747,
 1526815490,
 1526651824,
 113673,
 -1,
 1526764725,
 113770,
 1526946564,
 1526752173,
 113734,
 -1,
 1526874622,
 113736,
 1527077638,
 1526880779,
 113664,
 -1,
 1527019279,
 113686,
 1527208712,
 1527010504,
 113674,
 -1,
 1527122031,
 113726,
 1527339786,
 1527139985,
 113668,
 -1,
 1527252186,
 113678,
 1527470860,
 1527257478,
 113729,
 -1,
 1527422588,
 113733,
 -42227,
 1527441961,
 113744,
 -1,
 1527523167,
 113671,
 1527733048,
 1519721712,
 -1,
 1527798559,
 1527674639,
 -1,
 1527864094,
 1527751130,
 -1,
 1527929619,
 1527831954,
 113816,
 -1,
 1527843071,
 113779,
 1528060694,
 1527871247,
 -1,
 -42219,
 1528011115,
 113811,
 -1,
 1528064522,
 113814,
 1528257305,
 1527978374,
 -1,
 -42216,
 1528215752,
 113817,
 -1,
 1528248554,
 113808,
 -42214,
 1528226251,
 113815,
 -42213,
 1528417512,
 113809,
 -42212,
 1528453407,
 113810,
 -42211,
 1528511827,
 113812,
 -1,
 1528574450,
 113813,
 -1,
 1527793103,
 113776,
 1528847147,
 1527733954,
 -1,
 1528912674,
 1528814994,
 113800,
 -1,
 1528826111,
 113781,
 1529043749,
 1528854287,
 -1,
 -42204,
 1528994155,
 113795,
 -1,
 1529047562,
 113798,
 -42202,
 1529012683,
 113799,
 -42201,
 1529203944,
 113793,
 -42200,
 1529239839,
 113794,
 -42199,
 1529298259,
 113796,
 -42198,
 1529360882,
 113797,
 -1,
 1529420740,
 113792,
 1529633588,
 1528768058,
 -1,
 1529699120,
 1529595943,
 -1,
 1529764655,
 1529647016,
 113784,
 -1,
 1529676622,
 113788,
 -1,
 1529702369,
 113785,
 -42191,
 1529658409,
 113782,
 -42190,
 1529904141,
 113783,
 -42189,
 1529963449,
 113787,
 -1,
 1530020447,
 113786,
 1530223415,
 1529579546,
 -1,
 -42186,
 1530191365,
 113780,
 -1,
 1530224906,
 113777,
 -1,
 1530180553,
 113778,
 -42183,
 1527696192,
 113821,
 -42182,
 1530445782,
 113820,
 -42181,
 1530505845,
 113823,
 -1,
 1530543962,
 113822,
 -42179,
 1519684373,
 129375,
 -1,
 1530671871,
 129414,
 1530878869,
 1519600126,
 -1,
 1530944379,
 1530846128,
 -1,
 1531009908,
 1530863741,
 -1,
 1531075414,
 1530953046,
 -1,
 1531140933,
 1531040666,
 -1,
 -42172,
 1531106792,
 2423,
 -1,
 1531134462,
 2422,
 1531337544,
 1531089943,
 -1,
 -42169,
 1531286867,
 2420,
 -1,
 1531331070,
 2419,
 1531534155,
 1531270344,
 -1,
 -42166,
 1531478389,
 2429,
 -1,
 1531532567,
 2427,
 1531730766,
 1531451782,
 -1,
 -42163,
 1531701540,
 43262,
 -1,
 1531764923,
 2421,
 -42161,
 1531702642,
 2425,
 -42160,
 1531887338,
 2308,
 -42159,
 1531938286,
 2424,
 -42158,
 1531998911,
 2428,
 -42157,
 1532058959,
 2426,
 -42156,
 1532115550,
 2430,
 -42155,
 1532178016,
 2418,
 -1,
 1532242150,
 2431,
 1532451684,
 1531035577,
 -1,
 1532517213,
 1532374659,
 -1,
 1532582747,
 1532479393,
 -1,
 -42150,
 1532552726,
 43253,
 -1,
 1532584416,
 43254,
 -42148,
 1532550937,
 43251,
 -1,
 1532700366,
 43255,
 1532910432,
 1532475905,
 -1,
 -42145,
 1532863289,
 43250,
 -1,
 1532912971,
 43260,
 -42143,
 1532865225,
 43256,
 -42142,
 1533046058,
 2304,
 -42141,
 1533107933,
 2417,
 -1,
 1533165263,
 43252,
 1533369200,
 1532420150,
 -1,
 1533434728,
 1533334426,
 -1,
 -42137,
 1533400552,
 2391,
 -1,
 1533428222,
 2390,
 1533631339,
 1533383703,
 -1,
 -42134,
 1533580627,
 2363,
 -1,
 1533624830,
 2362,
 1533827950,
 1533548934,
 -1,
 -42131,
 1533798692,
 43263,
 -1,
 1533862075,
 2383,
 -42129,
 1533782469,
 2382,
 -1,
 1533947497,
 2389,
 -42127,
 1533309499,
 43261,
 -42126,
 1534090485,
 43259,
 -42125,
 1534154178,
 43257,
 -1,
 1534209785,
 43258,
 1534459903,
 1530946790,
 -1,
 1534483320,
 1534379937,
 -1,
 -42121,
 1534453270,
 983085,
 -1,
 1534484960,
 983087,
 -42119,
 1534445008,
 983160,
 -42118,
 1534629973,
 983083,
 -1,
 1534677735,
 983089,
 1534876553,
 1530903041,
 -1,
 1534942086,
 1534806534,
 -1,
 1535007620,
 1534872430,
 -1,
 1535073153,
 1534968206,
 -1,
 -42112,
 1535022599,
 66638,
 -1,
 1535069537,
 66639,
 1535311871,
 1534996181,
 -1,
 -42109,
 1535219207,
 66598,
 -1,
 1535266145,
 66599,
 1535508479,
 1534969761,
 127964,
 -1,
 1535378321,
 127965,
 1535639551,
 1534883502,
 -1,
 -42104,
 1535566856,
 128468,
 -1,
 1535587584,
 128421,
 1535794060,
 1534818063,
 983119,
 -42101,
 1535734096,
 128666,
 -1,
 1535789964,
 983118,
 1535990673,
 1535716771,
 -1,
 1536056208,
 1535927213,
 -1,
 -42097,
 1536001118,
 9192,
 -1,
 1536049588,
 127795,
 -1,
 1536012249,
 128475,
 -42094,
 1535947055,
 127962,
 -42093,
 1536271493,
 127980,
 -42092,
 1536313862,
 129420,
 -1,
 1536367816,
 129487,
 1536580558,
 1530815405,
 -1,
 1536646069,
 1536513224,
 -1,
 1536711591,
 1536585718,
 -1,
 1536777115,
 1536683296,
 -1,
 -42086,
 1536709815,
 127232,
 -1,
 1536767130,
 127233,
 1536973726,
 1536739233,
 -1,
 -42083,
 1536943654,
 127235,
 -1,
 1536975350,
 127236,
 1537170337,
 1536932353,
 -1,
 -42080,
 1537110391,
 127239,
 -1,
 1537166496,
 127240,
 1537366948,
 1537101457,
 -1,
 -42077,
 1537318662,
 127237,
 -1,
 1537372359,
 127238,
 -42075,
 1537316958,
 127234,
 -42074,
 1537511501,
 127242,
 -1,
 1537558163,
 127241,
 1537802239,
 1536667216,
 -1,
 1537825708,
 1537688443,
 119557,
 1537933311,
 1537770350,
 -1,
 -42069,
 1537857254,
 119556,
 -1,
 1537885167,
 119555,
 1538087855,
 1537768753,
 -1,
 -42066,
 1538025646,
 9869,
 -1,
 1538072914,
 9870,
 1538284466,
 1538021899,
 -1,
 -42063,
 1538250475,
 119554,
 -1,
 1538278389,
 119553,
 1538523135,
 1538218311,
 -1,
 -42060,
 1538418862,
 9871,
 -1,
 1538466130,
 9868,
 1538677693,
 1536565293,
 -1,
 1538743227,
 1538647116,
 -1,
 -42056,
 1538707134,
 11032,
 -42055,
 1538765722,
 11031,
 -42054,
 1538816795,
 11030,
 -1,
 1538862110,
 11033,
 -42052,
 1538705703,
 128924,
 -1,
 1539030532,
 128160,
 1539201986,
 1538636502,
 -1,
 1539267521,
 1539156248,
 -1,
 -42048,
 1539198697,
 128542,
 -1,
 1539255653,
 128549,
 -1,
 1539189570,
 9933,
 1539529669,
 1539173864,
 -1,
 -42044,
 1539491678,
 128171,
 -1,
 1539526377,
 128565,
 1539726280,
 1539496880,
 -1,
 -42041,
 1539677268,
 9902,
 -1,
 1539730141,
 129343,
 1539922891,
 1539674013,
 -1,
 -42038,
 1539870319,
 127244,
 -1,
 1539912267,
 127243,
 -42036,
 1539893666,
 129684,
 -42035,
 1540075603,
 127919,
 -1,
 1540115252,
 128754,
 1540316122,
 1536535750,
 -1,
 1540381653,
 1540264983,
 -1,
 1540447187,
 1540334255,
 -1,
 -42030,
 1540390202,
 128167,
 -1,
 1540424983,
 129656,
 -42028,
 1540396790,
 129316,
 -1,
 1540589248,
 128042,
 1540774871,
 1540300110,
 128009,
 -1,
 1540686524,
 128050,
 -42024,
 1540740819,
 129345,
 -42023,
 1540845857,
 9946,
 -1,
 1540901715,
 128087,
 1541102568,
 1540233606,
 -1,
 1541168096,
 1541035770,
 -1,
 1541233631,
 1541137484,
 -1,
 -42018,
 1541190514,
 11831,
 -1,
 1541241590,
 11830,
 -1,
 1541174811,
 128481,
 1541495779,
 1541127506,
 -1,
 -42014,
 1541465279,
 11843,
 -1,
 1541523294,
 128168,
 1541692390,
 1541442604,
 -1,
 -42011,
 1541626008,
 127841,
 -1,
 1541681172,
 128131,
 -42009,
 1541654570,
 983081,
 -1,
 1541846822,
 128374,
 1542020078,
 1541025187,
 -1,
 -42006,
 1541978625,
 983161,
 -42005,
 1542001834,
 983090,
 -42004,
 1542067084,
 983088,
 -42003,
 1542132327,
 983086,
 -1,
 1542197564,
 983084,
 -42001,
 1541987477,
 128192,
 -42000,
 1542360185,
 129516,
 -1,
 1542421008,
 983082,
 1542610538,
 1500476217,
 -1,
 1542675848,
 1542543883,
 -1,
 1542741112,
 1542621106,
 -1,
 1542806590,
 1542699521,
 -1,
 1542872125,
 1542777680,
 -1,
 1542937613,
 1542824623,
 -1,
 1543003145,
 1542893127,
 -1,
 1543068678,
 1542917797,
 -1,
 1543134208,
 1542989663,
 -1,
 1543199741,
 1543100436,
 -1,
 -41988,
 1543157655,
 6649,
 -1,
 1543206446,
 6633,
 1543438335,
 1543128696,
 -1,
 -41985,
 1543354263,
 6648,
 -1,
 1543403054,
 6632,
 1543592963,
 1543087754,
 -1,
 -41982,
 1543550871,
 6647,
 -1,
 1543599662,
 6631,
 1543831551,
 1543539667,
 -1,
 -41979,
 1543747479,
 6646,
 -1,
 1543796270,
 6630,
 1544028159,
 1542979584,
 -1,
 -41976,
 1543944087,
 6645,
 -1,
 1543992878,
 6629,
 1544182796,
 1542940623,
 -1,
 -41973,
 1544140695,
 6642,
 -1,
 1544189486,
 6626,
 -1,
 1544103359,
 6624,
 1544444963,
 1542863398,
 -1,
 1544510496,
 1544359589,
 -1,
 1544576022,
 1544463023,
 -1,
 1544641555,
 1544531531,
 -1,
 -41966,
 1544599447,
 6655,
 -1,
 1544648238,
 6639,
 1544880127,
 1544579023,
 -1,
 -41963,
 1544796055,
 6652,
 -1,
 1544844846,
 6636,
 1545034781,
 1544496991,
 -1,
 1545100314,
 1545000980,
 -1,
 -41959,
 1545058199,
 6654,
 -1,
 1545106990,
 6638,
 1545338879,
 1545029240,
 -1,
 -41956,
 1545254807,
 6653,
 -1,
 1545303598,
 6637,
 1545535487,
 1544981459,
 -1,
 -41953,
 1545451415,
 6651,
 -1,
 1545500206,
 6635,
 1545732095,
 1544421376,
 -1,
 -41950,
 1545648023,
 6650,
 -1,
 1545696814,
 6634,
 1545886770,
 1544387823,
 -1,
 1545952301,
 1545839279,
 -1,
 1546017836,
 1545907783,
 6133,
 1546125311,
 1545932453,
 -1,
 1546148906,
 1546004319,
 -1,
 -41943,
 1546115088,
 6137,
 -1,
 1546143349,
 6136,
 -41941,
 1546102406,
 6135,
 -1,
 1546292174,
 6134,
 -1,
 1545955276,
 6130,
 1546542128,
 1545873247,
 -1,
 -41937,
 1546508304,
 6132,
 -1,
 1546536565,
 6131,
 -41935,
 1546502835,
 6128,
 -1,
 1546685390,
 6129,
 1546869817,
 1545807711,
 -1,
 1546935350,
 1546835988,
 -1,
 -41931,
 1546893207,
 6644,
 -1,
 1546941998,
 6628,
 1547173887,
 1546864248,
 -1,
 -41928,
 1547089815,
 6643,
 -1,
 1547138606,
 6627,
 1547328572,
 1546816467,
 -1,
 -41925,
 1547286423,
 6641,
 -1,
 1547335214,
 6625,
 -1,
 1547293293,
 6640,
 -1,
 1542809470,
 6109,
 1547656302,
 1542731112,
 -1,
 1547721800,
 1547618209,
 -1,
 1547787331,
 1547684542,
 -1,
 -41918,
 1547736087,
 983950,
 -1,
 1547770246,
 983948,
 1547983942,
 1547721227,
 -1,
 -41915,
 1547932695,
 983955,
 -1,
 1547966854,
 983953,
 -41913,
 1547932695,
 983954,
 -1,
 1548097926,
 983952,
 1548311629,
 1547668524,
 -1,
 -41910,
 1548282769,
 983946,
 -41909,
 1548325911,
 983956,
 -41908,
 1548376216,
 983941,
 -1,
 1548425606,
 983951,
 1548639315,
 1548251961,
 -1,
 1548704849,
 1548573195,
 -1,
 -41904,
 1548653591,
 983940,
 -1,
 1548687750,
 983938,
 -41902,
 1548653591,
 983939,
 -1,
 1548818822,
 983937,
 1549032537,
 1548561827,
 -1,
 1549098071,
 1548966411,
 -1,
 -41898,
 1549046807,
 983945,
 -1,
 1549080966,
 983943,
 -41896,
 1549046807,
 983944,
 -1,
 1549212038,
 983942,
 1549425757,
 1548990977,
 -1,
 -41893,
 1549384406,
 983967,
 -41892,
 1549425181,
 983966,
 -1,
 1549474182,
 983968,
 1549687906,
 1549378223,
 -1,
 1549753441,
 1549621771,
 -1,
 -41888,
 1549702167,
 983960,
 -1,
 1549736326,
 983958,
 -1,
 1549702167,
 983959,
 1550015589,
 1549629199,
 -1,
 -41884,
 1549964311,
 983964,
 -1,
 1549998470,
 983970,
 1550212200,
 1549941005,
 -1,
 -41881,
 1550160919,
 983949,
 -1,
 1550195078,
 983947,
 -41879,
 1550183313,
 983962,
 -41878,
 1550376771,
 983965,
 -41877,
 1550432124,
 983963,
 -41876,
 1550486004,
 983961,
 -41875,
 1550539293,
 983969,
 -1,
 1550591888,
 983957,
 1550802036,
 1547594028,
 -1,
 1550867569,
 1550760388,
 983973,
 -1,
 1550838052,
 983974,
 1551040511,
 1550822145,
 -1,
 -41869,
 1550963610,
 983972,
 -1,
 1550991870,
 983975,
 1551237119,
 1550770230,
 -1,
 -41866,
 1551144749,
 983976,
 -41865,
 1551184951,
 983971,
 -1,
 1551243868,
 983977,
 1551457491,
 1542706638,
 -1,
 1551522998,
 1551400278,
 -1,
 1551588481,
 1551448333,
 -1,
 1551654015,
 1551513869,
 -1,
 -41859,
 1551587869,
 70347,
 -41858,
 1551645084,
 70345,
 -1,
 1551702406,
 70344,
 -41856,
 1551587869,
 70352,
 -1,
 1551833478,
 70351,
 1552047239,
 1551550369,
 -1,
 1552112773,
 1552009121,
 -1,
 -41852,
 1552046621,
 70343,
 -1,
 1552095622,
 70342,
 -41850,
 1552046621,
 70350,
 -1,
 1552226694,
 70349,
 1552440460,
 1551993900,
 -1,
 -41847,
 1552411039,
 70341,
 -41846,
 1552452726,
 70348,
 -41845,
 1552504087,
 70335,
 -1,
 1552554374,
 70353,
 1552768144,
 1552357766,
 70320,
 -41842,
 1552733082,
 70329,
 -41841,
 1552769965,
 70327,
 -1,
 1552816518,
 70321,
 1553030292,
 1552708109,
 -1,
 -41838,
 1552970283,
 70339,
 -41837,
 1553029661,
 70340,
 -1,
 1553078662,
 70338,
 1553292440,
 1552962760,
 -1,
 -41834,
 1553226269,
 70334,
 -41833,
 1553290519,
 70333,
 -1,
 1553340806,
 70332,
 1553554588,
 1553213279,
 -1,
 -41830,
 1553488413,
 70358,
 -41829,
 1553541008,
 70357,
 -1,
 1553602950,
 70356,
 1553816734,
 1553519514,
 70324,
 -1,
 1553781658,
 70325,
 1553947809,
 1553775105,
 -1,
 -41824,
 1553881629,
 70364,
 -1,
 1553930630,
 70365,
 1554144420,
 1553902790,
 -1,
 -41821,
 1554099520,
 70346,
 -1,
 1554127238,
 70361,
 1554341031,
 1554096815,
 -1,
 -41818,
 1554274845,
 70355,
 -1,
 1554323846,
 70354,
 1554537642,
 1554281273,
 -1,
 -41815,
 1554471453,
 70331,
 -1,
 1554520454,
 70330,
 1554734252,
 1554473901,
 70322,
 -1,
 1554670509,
 70323,
 1554865327,
 1554656675,
 -1,
 -41810,
 1554799133,
 70337,
 -1,
 1554848134,
 70336,
 -41808,
 1554835871,
 70360,
 -41807,
 1555028931,
 70363,
 -41806,
 1555076119,
 70328,
 -41805,
 1555137481,
 70359,
 -41804,
 1555199833,
 70362,
 -41803,
 1555257885,
 70366,
 -1,
 1555317246,
 70326,
 1555520708,
 1551449187,
 -1,
 1555586234,
 1555482529,
 -1,
 -41799,
 1555555862,
 70386,
 -1,
 1555587552,
 70387,
 1555782845,
 1555544577,
 -1,
 -41796,
 1555722608,
 70390,
 -1,
 1555778709,
 70391,
 1555979456,
 1555713681,
 -1,
 -41793,
 1555930877,
 70388,
 -1,
 1555984574,
 70389,
 -41791,
 1555950875,
 70384,
 -41790,
 1556125781,
 70385,
 -41789,
 1556189256,
 70393,
 -1,
 1556235910,
 70392,
 1556438223,
 1555488822,
 -1,
 1556503753,
 1556355462,
 -1,
 -41785,
 1556468634,
 70376,
 -41784,
 1556505517,
 70374,
 -1,
 1556552070,
 70368,
 1556765899,
 1556468634,
 70371,
 -1,
 1556730778,
 70372,
 1556896973,
 1556702125,
 70369,
 -1,
 1556833197,
 70370,
 -41778,
 1556845591,
 70375,
 -1,
 1556955646,
 70373,
 1557200895,
 1556398009,
 -1,
 -41775,
 1557126937,
 70378,
 -41774,
 1557173059,
 70377,
 -1,
 1557209637,
 70367,
 1557421365,
 1551377370,
 -1,
 1557486855,
 1557364054,
 -1,
 1557552350,
 1557448609,
 -1,
 1557617884,
 1557514145,
 -1,
 1557683418,
 1557579681,
 -1,
 -41767,
 1557617181,
 68147,
 -1,
 1557666182,
 68148,
 -41765,
 1557617181,
 68123,
 -1,
 1557797254,
 68122,
 -41763,
 1557551645,
 68128,
 -1,
 1557928326,
 68127,
 1558142180,
 1557477645,
 -1,
 1558207714,
 1558067469,
 -1,
 -41759,
 1558141469,
 68125,
 -1,
 1558190470,
 68124,
 -41757,
 1558141469,
 68130,
 -1,
 1558321542,
 68129,
 1558535400,
 1558100481,
 -1,
 -41754,
 1558493910,
 68142,
 -41753,
 1558534685,
 68141,
 -1,
 1558583686,
 68143,
 1558797548,
 1558481964,
 -1,
 -41750,
 1558768031,
 68121,
 -41749,
 1558809718,
 68126,
 -1,
 1558845830,
 68131,
 1559059696,
 1558737721,
 -1,
 -41746,
 1558999947,
 68146,
 -41745,
 1559058973,
 68113,
 -1,
 1559107974,
 68112,
 1559321843,
 1559026608,
 -1,
 -41742,
 1559255581,
 68149,
 -1,
 1559304582,
 68140,
 1559518454,
 1559274159,
 -1,
 -41739,
 1559452189,
 68133,
 -1,
 1559501190,
 68132,
 1559715065,
 1559450824,
 -1,
 -41736,
 1559648797,
 68115,
 -1,
 1559697798,
 68114,
 1559911676,
 1559637411,
 -1,
 -41733,
 1559845405,
 68118,
 -1,
 1559894406,
 68117,
 1560108287,
 1559832415,
 -1,
 -41730,
 1560042013,
 68135,
 -1,
 1560091014,
 68134,
 -41728,
 1560079454,
 68144,
 -41727,
 1560275359,
 68137,
 -41726,
 1560325440,
 68138,
 -41725,
 1560380361,
 68136,
 -41724,
 1560442713,
 68139,
 -41723,
 1560506923,
 68119,
 -41722,
 1560566301,
 68145,
 -1,
 1560615302,
 68096,
 1560829205,
 1557441109,
 -1,
 1560894733,
 1560754445,
 -1,
 1560960268,
 1560843287,
 -1,
 -41717,
 1560925417,
 68183,
 -1,
 1560987553,
 68176,
 -1,
 1560879390,
 68182,
 1561222416,
 1560835855,
 -1,
 -41713,
 1561173623,
 68181,
 -1,
 1561225750,
 68184,
 1561419027,
 1561144739,
 -1,
 -41710,
 1561375129,
 68179,
 -1,
 1561423439,
 68178,
 -41708,
 1561379174,
 68177,
 -1,
 1561560402,
 68180,
 1561746719,
 1560796080,
 -1,
 1561812254,
 1561698857,
 -1,
 1561877789,
 1561771961,
 -1,
 -41703,
 1561845616,
 68099,
 -41702,
 1561908122,
 68098,
 -41701,
 1561957399,
 68102,
 -41700,
 1562010541,
 68097,
 -1,
 1562067454,
 68101,
 -1,
 1561820421,
 68108,
 -1,
 1561751113,
 68159,
 1562402087,
 1561706425,
 -1,
 1562467619,
 1562328338,
 -1,
 -41694,
 1562432809,
 68109,
 -1,
 1562494905,
 68154,
 -41692,
 1562435360,
 68111,
 -41691,
 1562586999,
 68153,
 -41690,
 1562650680,
 68152,
 -1,
 1562714661,
 68110,
 1562926382,
 1562350413,
 -1,
 1562991915,
 1562888097,
 -1,
 -41686,
 1562960473,
 68165,
 -1,
 1562986439,
 68164,
 1563230207,
 1562941529,
 -1,
 -41683,
 1563151264,
 68167,
 -1,
 1563190067,
 68166,
 1563385140,
 1562852451,
 -1,
 1563450674,
 1563346849,
 -1,
 -41679,
 1563420182,
 68161,
 -1,
 1563451872,
 68162,
 -41677,
 1563400277,
 68160,
 -1,
 1563579111,
 68163,
 -1,
 1563317212,
 68168,
 1563885567,
 1557370413,
 -1,
 1563909486,
 1563786582,
 -1,
 1563974974,
 1563834637,
 -1,
 1564040508,
 1563900173,
 -1,
 -41670,
 1563974173,
 70167,
 -41669,
 1564031388,
 70172,
 -1,
 1564088710,
 70166,
 -41667,
 1563974173,
 70173,
 -1,
 1564219782,
 70171,
 1564433732,
 1563936673,
 -1,
 1564499266,
 1564395425,
 -1,
 -41663,
 1564432925,
 70165,
 -1,
 1564481926,
 70164,
 -41661,
 1564432925,
 70170,
 -1,
 1564612998,
 70169,
 1564826953,
 1564380204,
 -1,
 -41658,
 1564797343,
 70163,
 -41657,
 1564839030,
 70168,
 -41656,
 1564890391,
 70157,
 -1,
 1564940678,
 70174,
 1565154637,
 1564744070,
 70144,
 -41653,
 1565119386,
 70151,
 -41652,
 1565156269,
 70149,
 -1,
 1565202822,
 70145,
 1565416785,
 1565086920,
 -1,
 -41649,
 1565350429,
 70156,
 -41648,
 1565414679,
 70155,
 -1,
 1565464966,
 70154,
 1565678933,
 1565337439,
 -1,
 -41645,
 1565612573,
 70179,
 -41644,
 1565665168,
 70178,
 -1,
 1565727110,
 70177,
 1565941080,
 1565631151,
 -1,
 -41641,
 1565874717,
 70176,
 -1,
 1565923718,
 70175,
 1566137691,
 1565882127,
 -1,
 -41638,
 1566078809,
 70187,
 -1,
 1566120326,
 70183,
 1566334302,
 1566077753,
 -1,
 -41635,
 1566267933,
 70153,
 -1,
 1566316934,
 70152,
 1566530913,
 1566274061,
 -1,
 -41632,
 1566470699,
 70161,
 -1,
 1566513542,
 70160,
 1566727524,
 1566453155,
 -1,
 -41629,
 1566661149,
 70159,
 -1,
 1566710150,
 70158,
 -41627,
 1566697887,
 70181,
 -41626,
 1566890947,
 70184,
 -41625,
 1566954394,
 70147,
 -41624,
 1567013590,
 70185,
 -41623,
 1567075648,
 70182,
 -41622,
 1567134743,
 70150,
 -41621,
 1567196105,
 70180,
 -41620,
 1567253421,
 70146,
 -41619,
 1567316509,
 70186,
 -1,
 1567375870,
 70148,
 1567579512,
 1563877430,
 -1,
 1567645043,
 1567496582,
 -1,
 -41615,
 1567609754,
 70195,
 -41614,
 1567646637,
 70193,
 -1,
 1567693190,
 70188,
 1567907189,
 1567581101,
 70189,
 -1,
 1567843245,
 70190,
 -41610,
 1567871898,
 70191,
 -41609,
 1567986711,
 70194,
 -1,
 1568031230,
 70192,
 1568234881,
 1567537665,
 -1,
 1568300416,
 1568171897,
 -1,
 1568365949,
 1568258561,
 -1,
 -41604,
 1568331374,
 70206,
 -1,
 1568365122,
 70199,
 -41602,
 1568333593,
 70197,
 -41601,
 1568510787,
 70198,
 -1,
 1568547365,
 70196,
 -1,
 1568228415,
 70203,
 1568824710,
 1568160013,
 -1,
 1568890245,
 1568775807,
 -1,
 -41596,
 1568848959,
 70204,
 -1,
 1568881176,
 70201,
 -1,
 1568809246,
 70200,
 -41593,
 1568794520,
 70202,
 -1,
 1569069767,
 70205,
 1569283655,
 1542592902,
 -1,
 1569349090,
 1569222778,
 -1,
 1569414597,
 1569291606,
 -1,
 1569480082,
 1569339661,
 -1,
 1569545616,
 1569405197,
 -1,
 -41586,
 1569479197,
 69787,
 -41585,
 1569536941,
 69786,
 -1,
 1569593734,
 69785,
 -41583,
 1569479197,
 69793,
 -1,
 1569724806,
 69792,
 1569938840,
 1569441697,
 -1,
 1570004374,
 1569900449,
 -1,
 -41579,
 1569937949,
 69784,
 -1,
 1569986950,
 69783,
 -41577,
 1569937949,
 69791,
 -1,
 1570118022,
 69790,
 1570332061,
 1569885228,
 -1,
 -41574,
 1570302367,
 69782,
 -41573,
 1570344054,
 69789,
 -41572,
 1570395415,
 69777,
 -1,
 1570445702,
 69794,
 1570659745,
 1570249094,
 69763,
 -41569,
 1570624410,
 69772,
 -41568,
 1570661293,
 69770,
 -1,
 1570707846,
 69764,
 1570921893,
 1570617857,
 -1,
 -41565,
 1570880214,
 69805,
 -41564,
 1570920989,
 69804,
 -1,
 1570969990,
 69806,
 1571184039,
 1570886554,
 69767,
 -1,
 1571148698,
 69768,
 1571315114,
 1571138758,
 -1,
 -41559,
 1571248669,
 69788,
 -1,
 1571297670,
 69801,
 1571511725,
 1571267247,
 -1,
 -41556,
 1571445277,
 69796,
 -1,
 1571494278,
 69795,
 1571708336,
 1571451705,
 -1,
 -41553,
 1571641885,
 69774,
 -1,
 1571690886,
 69773,
 1571904947,
 1571648013,
 -1,
 -41550,
 1571838493,
 69781,
 -1,
 1571887494,
 69780,
 1572101557,
 1571840941,
 69765,
 -1,
 1572037549,
 69766,
 1572232632,
 1572033736,
 -1,
 -41545,
 1572166173,
 69776,
 -1,
 1572215174,
 69775,
 1572429243,
 1572154787,
 -1,
 -41542,
 1572362781,
 69779,
 -1,
 1572411782,
 69778,
 1572625854,
 1572349791,
 -1,
 -41539,
 1572559389,
 69798,
 -1,
 1572608390,
 69797,
 -41537,
 1572596127,
 69800,
 -41536,
 1572789187,
 69803,
 -41535,
 1572836375,
 69771,
 -41534,
 1572897737,
 69799,
 -41533,
 1572960089,
 69802,
 -41532,
 1573018141,
 69807,
 -1,
 1573077502,
 69769,
 1573281232,
 1569382454,
 -1,
 1573346762,
 1573198214,
 -1,
 -41528,
 1573311386,
 69816,
 -41527,
 1573348269,
 69814,
 -1,
 1573394822,
 69808,
 1573608908,
 1573311386,
 69811,
 -1,
 1573573530,
 69812,
 1573739982,
 1573544877,
 69809,
 -1,
 1573675949,
 69810,
 -41521,
 1573688343,
 69815,
 -1,
 1573798398,
 69813,
 1574002137,
 1573239297,
 -1,
 1574067672,
 1573939065,
 -1,
 1574133205,
 1574035133,
 -1,
 -41516,
 1574091697,
 69762,
 -1,
 1574153817,
 69817,
 -41514,
 1574081347,
 69818,
 -41513,
 1574252151,
 69760,
 -1,
 1574314533,
 69761,
 -1,
 1573995583,
 69822,
 1574591966,
 1573927181,
 -1,
 1574657501,
 1574542975,
 -1,
 -41508,
 1574616127,
 69823,
 -1,
 1574648344,
 69825,
 -1,
 1574576414,
 69824,
 1574919648,
 1574540117,
 69821,
 -1,
 1574830085,
 69837,
 -41503,
 1574848850,
 69820,
 -1,
 1574968007,
 69819,
 1575181858,
 1569319346,
 -1,
 1575247367,
 1575124310,
 -1,
 1575312872,
 1575193644,
 -1,
 -41498,
 1575283103,
 43281,
 -41497,
 1575310615,
 43277,
 -1,
 1575360902,
 43284,
 1575575019,
 1575274401,
 -1,
 -41494,
 1575508509,
 43294,
 -1,
 1575557510,
 43282,
 1575771630,
 1575533057,
 -1,
 -41491,
 1575705117,
 43279,
 -1,
 1575754118,
 43278,
 1575968241,
 1575723695,
 -1,
 -41488,
 1575901725,
 43286,
 -1,
 1575950726,
 43285,
 1576164852,
 1575916567,
 -1,
 -41485,
 1576113175,
 43301,
 -1,
 1576157694,
 43299,
 1576361463,
 1576104761,
 -1,
 -41482,
 1576294941,
 43275,
 -1,
 1576343942,
 43274,
 1576558074,
 1576294923,
 -1,
 -41479,
 1576519719,
 43283,
 -1,
 1576540550,
 43295,
 -41477,
 1576528990,
 43280,
 -41476,
 1576724895,
 43291,
 -41475,
 1576788219,
 43293,
 -41474,
 1576852419,
 43296,
 -41473,
 1576906048,
 43290,
 -41472,
 1576960969,
 43287,
 -41471,
 1577023321,
 43292,
 -41470,
 1577083821,
 43300,
 -41469,
 1577145623,
 43276,
 -41468,
 1577204124,
 43288,
 -41467,
 1577266650,
 43297,
 -41466,
 1577330576,
 43289,
 -1,
 1577392518,
 43298,
 1577606677,
 1575173219,
 -1,
 1577672203,
 1577568161,
 -1,
 -41462,
 1577641494,
 43266,
 -1,
 1577673184,
 43267,
 1577868814,
 1577630209,
 -1,
 -41459,
 1577808240,
 43270,
 -1,
 1577864341,
 43271,
 1578065425,
 1577799313,
 -1,
 -41456,
 1578016509,
 43268,
 -1,
 1578070206,
 43269,
 -41454,
 1578036507,
 43264,
 -41453,
 1578211413,
 43265,
 -41452,
 1578274888,
 43273,
 -1,
 1578321542,
 43272,
 1578524187,
 1577574388,
 -1,
 1578589720,
 1578488730,
 43304,
 -1,
 1578516990,
 43302,
 1578720794,
 1578516990,
 43303,
 -1,
 1578648062,
 43305,
 -1,
 1578669079,
 43306,
 1578917407,
 1578487443,
 -1,
 1578982942,
 1578839600,
 43308,
 -1,
 1578895086,
 43309,
 -1,
 1578936132,
 43307,
 1579220991,
 1578876857,
 -1,
 -41439,
 1579138879,
 43311,
 -1,
 1579170037,
 43310,
 1579376183,
 1575143599,
 -1,
 1579441705,
 1579297331,
 -1,
 -41435,
 1579406234,
 983985,
 -41434,
 1579455511,
 983987,
 -41433,
 1579508653,
 983984,
 -41432,
 1579565566,
 983986,
 -1,
 1579620742,
 983983,
 1579834929,
 1579358598,
 -1,
 1579900464,
 1579773140,
 -1,
 1579965998,
 1579861921,
 -1,
 -41427,
 1579930522,
 983989,
 -1,
 1579979799,
 983990,
 -41425,
 1579917999,
 983991,
 -1,
 1580085149,
 983988,
 -1,
 1579855662,
 110592,
 1580400639,
 1579794704,
 -1,
 1580424758,
 1580327099,
 -1,
 -41420,
 1580373015,
 110950,
 -41419,
 1580426157,
 110948,
 -1,
 1580483070,
 110949,
 -1,
 1580370988,
 110951,
 1580752454,
 1579322412,
 -1,
 1580817989,
 1580698802,
 -1,
 1580883522,
 1580777401,
 -1,
 1580949053,
 1580841473,
 -1,
 -41412,
 1580901177,
 3200,
 -1,
 1580950859,
 3204,
 -41410,
 1580914910,
 3314,
 -41409,
 1581093699,
 3260,
 -41408,
 1581150894,
 3313,
 -41407,
 1581198967,
 3201,
 -1,
 1581262542,
 3261,
 1581473348,
 1580851300,
 3298,
 -1,
 1581414159,
 3299,
 -1,
 1581415774,
 983203,
 -1,
 1580750324,
 129432,
 -1,
 1580669587,
 128331,
 1581801051,
 1569214079,
 128273,
 1581866586,
 1581723309,
 -1,
 1581932119,
 1581792355,
 -1,
 1581997645,
 1581893537,
 -1,
 -41396,
 1581966870,
 983556,
 -1,
 1581998560,
 983557,
 1582194256,
 1581955585,
 -1,
 -41393,
 1582133616,
 983560,
 -1,
 1582189717,
 983561,
 1582390867,
 1582124689,
 -1,
 -41390,
 1582341885,
 983558,
 -1,
 1582395582,
 983559,
 -41388,
 1582361883,
 983554,
 -41387,
 1582536789,
 983555,
 -41386,
 1582600264,
 983563,
 -1,
 1582646918,
 983562,
 -41384,
 1581894152,
 128287,
 -41383,
 1582797653,
 983552,
 -1,
 1582835024,
 983553,
 -1,
 1581788052,
 128422,
 1583111783,
 1581736877,
 -1,
 1583177316,
 1583072180,
 128143,
 1583242851,
 1583114807,
 -1,
 1583308386,
 1583173353,
 128535,
 1583415295,
 1583221602,
 -1,
 -41375,
 1583333940,
 128537,
 -1,
 1583362987,
 128538,
 -1,
 1583230786,
 128573,
 -1,
 1583154321,
 128139,
 -41371,
 1583145976,
 129373,
 -41370,
 1583663474,
 129665,
 -1,
 1583712875,
 128088,
 -41368,
 1583069150,
 11235,
 -41367,
 1583846495,
 128040,
 -1,
 1583910490,
 129486,
 1584095246,
 1542578363,
 -1,
 1584160570,
 1584011654,
 -1,
 1584226011,
 1584114886,
 -1,
 1584291546,
 1584144731,
 -1,
 1584357014,
 1584251278,
 -1,
 1584422516,
 1584326948,
 -1,
 1584488050,
 1584386970,
 71875,
 -1,
 1584427533,
 71886,
 -41357,
 1584436247,
 71877,
 -1,
 1584535942,
 71876,
 1584750202,
 1584355851,
 -1,
 1584815736,
 1584698391,
 -1,
 -41353,
 1584773301,
 71899,
 -1,
 1584824454,
 71898,
 -41351,
 1584755184,
 71897,
 -1,
 1584931500,
 71900,
 1585143422,
 1584667014,
 71873,
 -41348,
 1585104801,
 71893,
 -41347,
 1585155921,
 71882,
 -1,
 1585218419,
 71894,
 1585405570,
 1585070590,
 71880,
 1585512447,
 1585351724,
 -1,
 -41343,
 1585441060,
 71885,
 -1,
 1585482796,
 71888,
 1585667717,
 1585370010,
 -1,
 -41340,
 1585632154,
 71879,
 -1,
 1585655203,
 71887,
 1585864328,
 1585625601,
 -1,
 -41337,
 1585825528,
 71901,
 -1,
 1585866700,
 71902,
 1586060938,
 1585812503,
 71881,
 -1,
 1585986135,
 71889,
 1586192013,
 1586007084,
 -1,
 -41332,
 1586157497,
 71891,
 -1,
 1586189594,
 71872,
 -41330,
 1586160612,
 71874,
 -41329,
 1586356030,
 71903,
 -41328,
 1586417987,
 71890,
 -41327,
 1586473517,
 71896,
 -41326,
 1586525735,
 71884,
 -41325,
 1586587596,
 71878,
 -41324,
 1586648343,
 71883,
 -41323,
 1586706844,
 71892,
 -1,
 1586769163,
 71895,
 1586978494,
 1584279253,
 -1,
 1587043996,
 1586948388,
 -1,
 1587109530,
 1587008410,
 71843,
 -1,
 1587048973,
 71854,
 -41317,
 1587057687,
 71845,
 -1,
 1587157382,
 71844,
 1587371682,
 1586977291,
 -1,
 1587437216,
 1587319831,
 -1,
 -41313,
 1587394741,
 71867,
 -1,
 1587445894,
 71866,
 -41311,
 1587376624,
 71865,
 -1,
 1587552940,
 71868,
 1587764902,
 1587288454,
 71841,
 -41308,
 1587726241,
 71861,
 -41307,
 1587777361,
 71850,
 -1,
 1587839859,
 71862,
 1588027050,
 1587692030,
 71848,
 1588133887,
 1587973164,
 -1,
 -41303,
 1588062500,
 71853,
 -1,
 1588104236,
 71856,
 1588289197,
 1587991450,
 -1,
 -41300,
 1588253594,
 71847,
 -1,
 1588276643,
 71855,
 1588485808,
 1588247041,
 -1,
 -41297,
 1588446968,
 71869,
 -1,
 1588488140,
 71870,
 1588682418,
 1588433943,
 71849,
 -1,
 1588607575,
 71857,
 1588813493,
 1588628524,
 -1,
 -41292,
 1588778937,
 71859,
 -1,
 1588811034,
 71840,
 -41290,
 1588782052,
 71842,
 -41289,
 1588977470,
 71871,
 -41288,
 1589039427,
 71858,
 -41287,
 1589094957,
 71864,
 -41286,
 1589147175,
 71852,
 -41285,
 1589209036,
 71846,
 -41284,
 1589269783,
 71851,
 -41283,
 1589328284,
 71860,
 -1,
 1589390603,
 71863,
 1589599948,
 1586904163,
 -1,
 1589665474,
 1589561249,
 -1,
 -41279,
 1589634582,
 71906,
 -1,
 1589666272,
 71907,
 1589862085,
 1589623297,
 -1,
 -41276,
 1589801328,
 71910,
 -1,
 1589857429,
 71911,
 1590058696,
 1589792401,
 -1,
 -41273,
 1590009597,
 71908,
 -1,
 1590063294,
 71909,
 -41271,
 1590029595,
 71904,
 -41270,
 1590204501,
 71905,
 -41269,
 1590267976,
 71913,
 -1,
 1590314630,
 71912,
 1590517465,
 1589547853,
 -1,
 1590582993,
 1590478753,
 -1,
 -41265,
 1590551129,
 71915,
 -41264,
 1590583198,
 71916,
 -1,
 1590642631,
 71914,
 1590845140,
 1590540801,
 -1,
 -41261,
 1590784440,
 71919,
 -1,
 1590840543,
 71920,
 1591041751,
 1590775441,
 -1,
 -41258,
 1590992209,
 71917,
 -1,
 1591043601,
 71918,
 -41256,
 1590988920,
 71922,
 -1,
 1591166681,
 71921,
 -1,
 1590466349,
 71935,
 -1,
 1584238758,
 9888,
 1591500584,
 1584172076,
 -1,
 1591566117,
 1591423348,
 -1,
 1591631633,
 1591508310,
 -1,
 1591697124,
 1591548294,
 123585,
 1591762658,
 1591613830,
 123584,
 1591869439,
 1591708716,
 123624,
 -1,
 1591760072,
 123619,
 -41245,
 1591727002,
 123606,
 -1,
 1591906129,
 123620,
 1592090345,
 1591658401,
 -1,
 -41242,
 1592048342,
 123616,
 -41241,
 1592110400,
 123617,
 -41240,
 1592154653,
 123596,
 -1,
 1592203654,
 123595,
 1592418028,
 1592038423,
 123605,
 1592524799,
 1592364076,
 123622,
 -1,
 1592415432,
 123618,
 1592614640,
 1592364076,
 -1,
 -41234,
 1592584607,
 123625,
 -41233,
 1592612119,
 123613,
 -1,
 1592662406,
 123593,
 1592876787,
 1592584484,
 -1,
 -41230,
 1592813513,
 123627,
 -1,
 1592859014,
 123590,
 1593073397,
 1592841114,
 123614,
 -1,
 1593001927,
 123626,
 1593204472,
 1593031169,
 -1,
 -41225,
 1593137693,
 123599,
 -1,
 1593186694,
 123598,
 1593401083,
 1593156271,
 -1,
 -41222,
 1593334301,
 123591,
 -1,
 1593383302,
 123594,
 1593597694,
 1593341711,
 -1,
 -41219,
 1593540093,
 123615,
 -1,
 1593579910,
 123592,
 1593794305,
 1593537337,
 -1,
 -41216,
 1593727517,
 123609,
 -1,
 1593776518,
 123604,
 1593990915,
 1593729965,
 123612,
 -1,
 1593937745,
 123621,
 1594121989,
 1593917950,
 123611,
 -1,
 1594068012,
 123623,
 -41210,
 1594092638,
 123601,
 -41209,
 1594220795,
 123602,
 -41208,
 1594284995,
 123603,
 -41207,
 1594338624,
 123607,
 -41206,
 1594393545,
 123608,
 -41205,
 1594454571,
 123600,
 -41204,
 1594513949,
 123610,
 -41203,
 1594578199,
 123589,
 -41202,
 1594642150,
 123597,
 -41201,
 1594702236,
 123588,
 -41200,
 1594764762,
 123587,
 -1,
 1594828688,
 123586,
 1595039519,
 1591557219,
 -1,
 1595105045,
 1595000737,
 -1,
 -41196,
 1595074070,
 123634,
 -1,
 1595105760,
 123635,
 1595301656,
 1595062785,
 -1,
 -41193,
 1595240816,
 123638,
 -1,
 1595296917,
 123639,
 1595498267,
 1595231889,
 -1,
 -41190,
 1595449085,
 123636,
 -1,
 1595502782,
 123637,
 -41188,
 1595469083,
 123632,
 -41187,
 1595643989,
 123633,
 -41186,
 1595707464,
 123641,
 -1,
 1595754118,
 123640,
 1595957028,
 1595002515,
 -1,
 1596022562,
 1595920848,
 123628,
 -1,
 1595969533,
 123629,
 1596194815,
 1595962931,
 123630,
 -1,
 1596100605,
 123631,
 -1,
 1595903987,
 123647,
 1596391423,
 1591503415,
 -1,
 -41177,
 1596282855,
 127766,
 -1,
 1596339894,
 127768,
 1596546863,
 1591462464,
 -1,
 1596612398,
 1596456960,
 -1,
 -41173,
 1596580299,
 127754,
 -41172,
 1596631174,
 129341,
 -41171,
 1596666844,
 128702,
 -1,
 1596730646,
 128003,
 -1,
 1596557173,
 127817,
 1597005621,
 1596513200,
 -1,
 1597071156,
 1596942903,
 -1,
 -41166,
 1597039413,
 127987,
 -41165,
 1597070224,
 128075,
 -1,
 1597123328,
 127988,
 -1,
 1596998155,
 11071,
 1597398840,
 1596975294,
 -1,
 -41161,
 1597331431,
 127764,
 -1,
 1597388470,
 127762,
 -41159,
 1597359307,
 128465,
 -1,
 1597525998,
 129479,
 1597726644,
 1584093707,
 -1,
 1597792178,
 1597665362,
 -1,
 1597857639,
 1597713827,
 -1,
 1597923174,
 1597791742,
 -1,
 1597988688,
 1597862713,
 -1,
 1598054221,
 1597935646,
 -1,
 1598119753,
 1597966508,
 -1,
 1598185286,
 1598080929,
 -1,
 1598250821,
 1598154418,
 -1,
 -41148,
 1598214823,
 129584,
 -1,
 1598274879,
 129591,
 -1,
 1598186101,
 129605,
 -41145,
 1598134406,
 129563,
 -41144,
 1598460031,
 129549,
 -1,
 1598509728,
 129542,
 1598750719,
 1598033573,
 -1,
 -41141,
 1598666757,
 129615,
 -41140,
 1598729263,
 129614,
 -1,
 1598761647,
 129616,
 1599012863,
 1597991714,
 -1,
 -41137,
 1598935884,
 129587,
 -1,
 1598984319,
 129545,
 1599168344,
 1597952500,
 -1,
 1599233876,
 1599107897,
 -1,
 -41133,
 1599180830,
 129570,
 -1,
 1599236659,
 129566,
 -41131,
 1599191045,
 129568,
 -41130,
 1599384623,
 129567,
 -41129,
 1599448231,
 129571,
 -1,
 1599482543,
 129569,
 1599692635,
 1599125514,
 -1,
 -41126,
 1599656780,
 129589,
 -1,
 1599705215,
 129547,
 1599889246,
 1599646783,
 -1,
 -41123,
 1599853388,
 129588,
 -1,
 1599901823,
 129546,
 1600085857,
 1599841452,
 -1,
 -41120,
 1600049996,
 129592,
 -1,
 1600098431,
 129550,
 1600282467,
 1600014821,
 129608,
 -1,
 1600194742,
 129611,
 1600454655,
 1600203446,
 -1,
 -41115,
 1600377676,
 129590,
 -1,
 1600426111,
 129548,
 -1,
 1597861461,
 128906,
 1600675701,
 1597815297,
 -1,
 1600741229,
 1600640787,
 127779,
 1600847871,
 1600651264,
 -1,
 1600872300,
 1600727357,
 127781,
 -1,
 1600785891,
 127782,
 -1,
 1600840996,
 127780,
 1601068914,
 1600695230,
 -1,
 1601134449,
 1600992708,
 -1,
 -41104,
 1601101436,
 128916,
 -1,
 1601144586,
 128917,
 -1,
 1601056119,
 128307,
 1601437695,
 1601012905,
 -1,
 -41100,
 1601356951,
 11090,
 -1,
 1601405543,
 11051,
 1601593217,
 1600600333,
 -1,
 1601658747,
 1601528948,
 -1,
 1601724282,
 1601582532,
 -1,
 -41095,
 1601691241,
 128922,
 -1,
 1601734382,
 128923,
 -1,
 1601661141,
 9931,
 1601986430,
 1601613552,
 -1,
 -41091,
 1601930505,
 9920,
 -1,
 1601992103,
 9921,
 1602224127,
 1601937987,
 -1,
 -41088,
 1602124605,
 128407,
 -1,
 1602168747,
 128071,
 1602379657,
 1601533711,
 -1,
 1602445189,
 1602307530,
 -1,
 -41084,
 1602398206,
 128072,
 -1,
 1602451567,
 9945,
 1602641800,
 1602361734,
 -1,
 -41081,
 1602604485,
 128326,
 -1,
 1602663031,
 11036,
 -1,
 1602593417,
 128928,
 1602903953,
 1602312715,
 -1,
 1602969487,
 1602830846,
 -1,
 1603035022,
 1602886022,
 -1,
 -41075,
 1603002535,
 9989,
 -1,
 1603057931,
 129293,
 -1,
 1603004473,
 11041,
 -41072,
 1602919595,
 11053,
 -1,
 1603216165,
 128427,
 1603428247,
 1602865057,
 -1,
 1603493781,
 1603382470,
 -1,
 -41068,
 1603429523,
 10177,
 -1,
 1603478097,
 9186,
 -41066,
 1603462972,
 9943,
 -1,
 1603641024,
 128382,
 1603821469,
 1603371891,
 -1,
 1603887004,
 1603749120,
 -1,
 -41062,
 1603847319,
 11088,
 -41061,
 1603895911,
 11048,
 -1,
 1603943464,
 11046,
 -1,
 1603836552,
 11229,
 1604214691,
 1603751569,
 -1,
 1604280226,
 1604155151,
 -1,
 1604345761,
 1604197653,
 9872,
 -1,
 1604259060,
 9983,
 -1,
 1604297274,
 128174,
 -1,
 1604231017,
 11214,
 1604607910,
 1604181300,
 -1,
 -41051,
 1604577638,
 11038,
 -1,
 1604635849,
 11055,
 1604804521,
 1604563813,
 -1,
 -41048,
 1604718510,
 11092,
 -1,
 1604782145,
 128073,
 1605001132,
 1604756777,
 -1,
 -41045,
 1604962421,
 11040,
 -1,
 1605012693,
 127985,
 1605197743,
 1604920359,
 -1,
 -41042,
 1605161843,
 129197,
 -1,
 1605212245,
 129196,
 -41040,
 1605163124,
 128070,
 -41039,
 1605348473,
 10068,
 -1,
 1605389707,
 10069,
 -41037,
 1597719859,
 9855,
 -1,
 1605508833,
 128011,
 1605722097,
 1597662125,
 -1,
 1605787624,
 1605647014,
 -1,
 1605853123,
 1605747399,
 -1,
 1605918653,
 1605821054,
 -1,
 -41031,
 1605885506,
 129159,
 -41030,
 1605928668,
 129143,
 -41029,
 1605992064,
 129127,
 -41028,
 1606049074,
 129151,
 -1,
 1606101110,
 129135,
 1606352895,
 1605845889,
 -1,
 -41025,
 1606278722,
 129158,
 -41024,
 1606321884,
 129142,
 -41023,
 1606385280,
 129126,
 -41022,
 1606442290,
 129150,
 -1,
 1606494326,
 129134,
 1606705104,
 1605800340,
 -1,
 1606770634,
 1606673022,
 -1,
 -41018,
 1606737474,
 129156,
 -41017,
 1606780636,
 129140,
 -41016,
 1606844032,
 129124,
 -41015,
 1606901042,
 129148,
 -1,
 1606953078,
 129132,
 1607204863,
 1606697857,
 -1,
 -41012,
 1607130690,
 129157,
 -41011,
 1607173852,
 129141,
 -41010,
 1607237248,
 129125,
 -41009,
 1607294258,
 129149,
 -1,
 1607346294,
 129133,
 1607557078,
 1606670697,
 -1,
 -41006,
 1607523906,
 129153,
 -41005,
 1607567068,
 129137,
 -41004,
 1607630464,
 129121,
 -41003,
 1607687474,
 129145,
 -1,
 1607739510,
 129129,
 1607950300,
 1607513322,
 -1,
 -41000,
 1607917122,
 129154,
 -40999,
 1607960284,
 129138,
 -40998,
 1608023680,
 129122,
 -40997,
 1608080690,
 129146,
 -1,
 1608132726,
 129130,
 1608343522,
 1607892012,
 -1,
 -40994,
 1608310338,
 129152,
 -40993,
 1608353500,
 129136,
 -40992,
 1608416896,
 129120,
 -40991,
 1608473906,
 129144,
 -1,
 1608525942,
 129128,
 1608777727,
 1608269986,
 -1,
 -40988,
 1608703554,
 129155,
 -40987,
 1608746716,
 129139,
 -40986,
 1608810112,
 129123,
 -40985,
 1608867122,
 129147,
 -1,
 1608919158,
 129131,
 1609129966,
 1605733420,
 -1,
 1609195500,
 1609054479,
 -1,
 -40981,
 1609118019,
 127888,
 -1,
 1609182071,
 127788,
 -40979,
 1609135542,
 128521,
 -1,
 1609318999,
 127863,
 -40977,
 1609085065,
 128430,
 -40976,
 1609466556,
 129344,
 -1,
 1609520936,
 11838,
 1609719808,
 1605669911,
 -1,
 1609785339,
 1609663347,
 -1,
 1609850874,
 1609703493,
 128105,
 1609916409,
 1609808387,
 -1,
 -40970,
 1609874280,
 128097,
 -40969,
 1609915497,
 128082,
 -40968,
 1609970695,
 128090,
 -1,
 1610034166,
 128098,
 -1,
 1609829243,
 128111,
 -1,
 1609779399,
 128698,
 1610375167,
 1609739462,
 -1,
 -40963,
 1610330919,
 128543,
 -40962,
 1610381774,
 128506,
 -1,
 1610430811,
 11825,
 -1,
 1610317279,
 128058,
 1610702856,
 1609646590,
 -1,
 1610768388,
 1610638253,
 -1,
 -40957,
 1610700735,
 127947,
 -1,
 1610762969,
 983234,
 1610964999,
 1610687644,
 -1,
 -40954,
 1610895081,
 128553,
 -1,
 1610952490,
 128576,
 -1,
 1610889832,
 128146,
 1611227149,
 1610656966,
 -1,
 1611292684,
 1611153918,
 -1,
 -40949,
 1611253033,
 129340,
 -1,
 1611304233,
 128295,
 -1,
 1611211380,
 127873,
 -1,
 1611166221,
 983229,
 1611620779,
 1584049350,
 -1,
 1611686020,
 1611547134,
 -1,
 1611751487,
 1611625031,
 -1,
 1611817005,
 1611693398,
 -1,
 1611882523,
 1611762732,
 -1,
 1611948054,
 1611852068,
 -1,
 -40939,
 1611887147,
 43333,
 -1,
 1611929990,
 43323,
 1612144665,
 1611879624,
 -1,
 -40936,
 1612076311,
 43331,
 -1,
 1612126598,
 43314,
 -40934,
 1612069276,
 43332,
 -1,
 1612257670,
 43317,
 1612472350,
 1611826035,
 -1,
 -40931,
 1612392336,
 43330,
 -1,
 1612454278,
 43320,
 -40929,
 1612442015,
 43327,
 -40928,
 1612636411,
 43328,
 -40927,
 1612695591,
 43315,
 -40926,
 1612757718,
 43324,
 -40925,
 1612819776,
 43325,
 -40924,
 1612882699,
 43318,
 -40923,
 1612937049,
 43326,
 -40922,
 1613001611,
 43312,
 -40921,
 1613066795,
 43322,
 -40920,
 1613126173,
 43329,
 -40919,
 1613190423,
 43313,
 -40918,
 1613248924,
 43316,
 -40917,
 1613311450,
 43321,
 -40916,
 1613375376,
 43319,
 -1,
 1613437318,
 43334,
 1613652025,
 1611783088,
 -1,
 1613717560,
 1613603375,
 -1,
 1613783090,
 1613644286,
 43337,
 -40911,
 1613747098,
 43341,
 -1,
 1613764998,
 43342,
 1613979701,
 1613699462,
 -1,
 -40908,
 1613943706,
 43340,
 -1,
 1613980589,
 43338,
 -40906,
 1613943706,
 43336,
 -40905,
 1614124055,
 43339,
 -1,
 1614177197,
 43335,
 -1,
 1613655625,
 43347,
 1614438462,
 1613575512,
 -1,
 1614503996,
 1614384172,
 43344,
 -1,
 1614435528,
 43343,
 -40899,
 1614458054,
 43345,
 -1,
 1614567947,
 43346,
 -1,
 1614396479,
 43359,
 1614831706,
 1611683872,
 -1,
 -40895,
 1614801968,
 127487,
 -40894,
 1614866724,
 127486,
 -40893,
 1614931987,
 127485,
 -40892,
 1614995643,
 127484,
 -40891,
 1615059888,
 127483,
 -40890,
 1615123354,
 127482,
 -40889,
 1615185825,
 127481,
 -40888,
 1615247873,
 127480,
 -40887,
 1615310022,
 127479,
 -40886,
 1615375105,
 127478,
 -40885,
 1615438511,
 127477,
 -40884,
 1615500311,
 127476,
 -40883,
 1615563820,
 127475,
 -40882,
 1615627123,
 127474,
 -40881,
 1615689487,
 127473,
 -40880,
 1615754041,
 127472,
 -40879,
 1615819277,
 127471,
 -40878,
 1615881133,
 127470,
 -40877,
 1615944203,
 127469,
 -40876,
 1616008392,
 127468,
 -40875,
 1616072337,
 127467,
 -40874,
 1616134654,
 127466,
 -40873,
 1616197901,
 127465,
 -40872,
 1616260515,
 127464,
 -40871,
 1616324447,
 127463,
 -1,
 1616386438,
 127462,
 1616601203,
 1614797744,
 -1,
 1616666738,
 1616530132,
 -1,
 1616732264,
 1616591119,
 -1,
 1616797792,
 1616694417,
 -1,
 -40865,
 1616763041,
 128402,
 -1,
 1616789588,
 128403,
 1616994403,
 1616751814,
 -1,
 -40862,
 1616930520,
 11262,
 -1,
 1616977376,
 128401,
 -40860,
 1616961216,
 128404,
 -40859,
 1617144939,
 11822,
 -40858,
 1617189786,
 128405,
 -40857,
 1617252967,
 11793,
 -1,
 1617310874,
 11841,
 1617559551,
 1616642048,
 -1,
 1617584236,
 1617481012,
 -1,
 -40853,
 1617540358,
 11079,
 -1,
 1617591366,
 11073,
 1617780847,
 1617526291,
 -1,
 -40850,
 1617727017,
 983151,
 -1,
 1617778592,
 128968,
 -40848,
 1617740436,
 10184,
 -40847,
 1617914198,
 983152,
 -1,
 1617965272,
 128639,
 -1,
 1616615199,
 128158,
 1618239608,
 1616561507,
 -1,
 1618305143,
 1618175274,
 -1,
 -40842,
 1618219623,
 9953,
 -1,
 1618284860,
 9952,
 -1,
 1618254457,
 128699,
 1618567292,
 1618161059,
 -1,
 -40838,
 1618522101,
 128665,
 -40837,
 1618582629,
 983112,
 -1,
 1618626299,
 129534,
 1618829439,
 1618530798,
 -1,
 -40834,
 1618785125,
 11153,
 -1,
 1618836203,
 11152,
 1619026050,
 1618753807,
 -1,
 -40831,
 1618958348,
 129511,
 -1,
 1619010178,
 127822,
 -40829,
 1618970926,
 127895,
 -1,
 1619164745,
 128524,
 1619353858,
 1611621293,
 983153,
 1619419372,
 1619285897,
 -1,
 1619484871,
 1619386715,
 -1,
 1619550367,
 1619445665,
 -1,
 1619615901,
 1619505884,
 -1,
 1619681436,
 1619529485,
 -1,
 1619746970,
 1619600402,
 11106,
 1619853311,
 1619656704,
 -1,
 1619878040,
 1619780684,
 -1,
 1619943568,
 1619820807,
 -1,
 -40817,
 1619908961,
 11173,
 -1,
 1619935384,
 11175,
 1620140179,
 1619869300,
 -1,
 -40814,
 1620106773,
 983238,
 -1,
 1620140316,
 11132,
 -40812,
 1620106840,
 129074,
 -40811,
 1620282594,
 129058,
 -40810,
 1620346621,
 129062,
 -40809,
 1620401475,
 129070,
 -1,
 1620454367,
 129066,
 -40807,
 1619840593,
 11122,
 -1,
 1620615411,
 11138,
 -40805,
 1619698517,
 11142,
 -1,
 1620720186,
 11116,
 -1,
 1619591448,
 129170,
 -40802,
 1619584787,
 11246,
 -1,
 1620941536,
 129187,
 1621123249,
 1619469336,
 -1,
 1621188779,
 1621091404,
 -1,
 1621254308,
 1621151224,
 -1,
 -40797,
 1621219681,
 11023,
 -1,
 1621246104,
 11022,
 1621450919,
 1621213456,
 -1,
 -40794,
 1621413884,
 129026,
 -1,
 1621445104,
 129042,
 -40792,
 1621397967,
 129178,
 -40791,
 1621591832,
 129030,
 -40790,
 1621653711,
 129034,
 -1,
 1621707248,
 129046,
 1621909678,
 1621150792,
 -1,
 -40787,
 1621870293,
 11076,
 -1,
 1621907793,
 11075,
 1622147071,
 1621826305,
 -1,
 -40784,
 1622068517,
 11084,
 -1,
 1622089571,
 11080,
 1622302903,
 1621043039,
 -1,
 1622368437,
 1622243205,
 -1,
 -40780,
 1622291049,
 11146,
 -1,
 1622352914,
 11157,
 -40778,
 1622318661,
 129185,
 -1,
 1622481772,
 129193,
 1622696122,
 1622260225,
 -1,
 -40775,
 1622649804,
 129082,
 -1,
 1622680024,
 129106,
 1622892733,
 1622650054,
 -1,
 -40772,
 1622840557,
 128622,
 -1,
 1622894362,
 129189,
 1623089344,
 1622826283,
 -1,
 -40769,
 1623012591,
 129090,
 -1,
 1623073810,
 129094,
 1623285955,
 1623019153,
 -1,
 -40766,
 1623242724,
 129195,
 -1,
 1623288697,
 129078,
 -40764,
 1623253775,
 129174,
 -40763,
 1623436168,
 11078,
 -40762,
 1623489506,
 129191,
 -1,
 1623536879,
 129086,
 1623744739,
 1619394560,
 -1,
 1623810258,
 1623702017,
 -1,
 1623875791,
 1623762127,
 -1,
 1623941326,
 1623793286,
 128360,
 1624047615,
 1623853922,
 -1,
 -40755,
 1623968810,
 128362,
 -1,
 1624021238,
 128361,
 -1,
 1623868457,
 128489,
 -40752,
 1623840131,
 11779,
 -40751,
 1624204692,
 11815,
 -1,
 1624248257,
 10182,
 1624465623,
 1623728466,
 -1,
 1624531158,
 1624406547,
 -1,
 -40747,
 1624491689,
 11776,
 -1,
 1624522322,
 11777,
 -1,
 1624459798,
 128495,
 1624793306,
 1624426401,
 -1,
 -40743,
 1624747663,
 11786,
 -1,
 1624793486,
 128493,
 1624989917,
 1624726045,
 -1,
 -40740,
 1624935803,
 128381,
 -1,
 1624997329,
 11241,
 1625186528,
 1624915218,
 -1,
 -40737,
 1625150737,
 11817,
 -1,
 1625215309,
 11781,
 -40735,
 1625152956,
 11809,
 -40734,
 1625337352,
 11789,
 -1,
 1625391570,
 11805,
 1625620479,
 1623658149,
 -1,
 1625645289,
 1625509625,
 -1,
 1625710823,
 1625605892,
 4053,
 -1,
 1625623618,
 4055,
 -40728,
 1625641248,
 129308,
 -1,
 1625760707,
 1421,
 -40726,
 1625607777,
 8295,
 -40725,
 1625925699,
 128270,
 -1,
 1625971643,
 9957,
 1626169594,
 1619339503,
 127872,
 1626275839,
 1626079462,
 -1,
 1626300657,
 1626200096,
 -1,
 -40720,
 1626256229,
 11187,
 -1,
 1626307307,
 11186,
 1626497268,
 1626256235,
 -1,
 -40717,
 1626462237,
 11189,
 -1,
 1626488794,
 11191,
 1626693879,
 1626438384,
 -1,
 -40714,
 1626658845,
 11188,
 -1,
 1626685402,
 11190,
 1626931199,
 1626619871,
 -1,
 -40711,
 1626846053,
 11185,
 -1,
 1626897131,
 11184,
 1627087102,
 1626115921,
 128141,
 -40708,
 1627023932,
 128365,
 -40707,
 1627079833,
 129680,
 -1,
 1627129914,
 11824,
 1627349249,
 1627008928,
 -1,
 -40704,
 1627272822,
 127832,
 -1,
 1627334646,
 127833,
 -1,
 1627279770,
 129350,
 1627611469,
 1619317658,
 -1,
 1627676981,
 1627555840,
 -1,
 1627742498,
 1627624269,
 -1,
 1627808013,
 1627703201,
 -1,
 1627873545,
 1627775163,
 -1,
 -40696,
 1627821090,
 69235,
 -1,
 1627867446,
 69226,
 1628070156,
 1627806219,
 -1,
 -40693,
 1628025010,
 69236,
 -1,
 1628073747,
 69227,
 -1,
 1627998151,
 69225,
 1628332308,
 1627765249,
 -1,
 1628397841,
 1628270960,
 -1,
 -40688,
 1628361598,
 69230,
 -1,
 1628373848,
 69239,
 1628635135,
 1628327061,
 -1,
 -40685,
 1628558206,
 69231,
 -1,
 1628570456,
 69240,
 1628791067,
 1628262033,
 -1,
 1628856600,
 1628738583,
 -1,
 -40681,
 1628821951,
 69237,
 -1,
 1628879184,
 69228,
 1629093887,
 1628791725,
 -1,
 -40678,
 1629019303,
 69238,
 -1,
 1629050028,
 69229,
 1629249822,
 1628737608,
 -1,
 -40675,
 1629213566,
 69233,
 -1,
 1629225816,
 69242,
 1629446433,
 1629177478,
 -1,
 -40672,
 1629415716,
 69232,
 -1,
 1629422424,
 69241,
 -1,
 1629395066,
 69234,
 1629708591,
 1627667555,
 -1,
 1629774118,
 1629669281,
 -1,
 -40667,
 1629742614,
 69217,
 -1,
 1629774304,
 69218,
 1629970729,
 1629731329,
 -1,
 -40664,
 1629909360,
 69221,
 -1,
 1629965461,
 69222,
 1630167340,
 1629900433,
 -1,
 -40661,
 1630117629,
 69219,
 -1,
 1630171326,
 69220,
 -40659,
 1630115925,
 69216,
 -40658,
 1630310472,
 69224,
 -1,
 1630357126,
 69223,
 1630601215,
 1629639604,
 -1,
 1630626100,
 1630509145,
 -1,
 -40654,
 1630587748,
 69245,
 -40653,
 1630645209,
 69244,
 -1,
 1630689977,
 69243,
 -1,
 1630589811,
 69246,
 1630953796,
 1627622444,
 -1,
 1631019329,
 1630889173,
 -1,
 1631084862,
 1630950389,
 -1,
 1631150395,
 1631000966,
 -1,
 -40646,
 1631079207,
 5880,
 -1,
 1631137187,
 5879,
 -40644,
 1631100267,
 5876,
 -40643,
 1631285032,
 5877,
 -1,
 1631340083,
 5878,
 -40641,
 1631042895,
 5874,
 -40640,
 1631492669,
 5875,
 -1,
 1631548217,
 5873,
 1631780863,
 1630964780,
 -1,
 -40637,
 1631677231,
 127933,
 -1,
 1631734278,
 127939,
 1631936843,
 1630913545,
 -1,
 -40634,
 1631903476,
 11251,
 -40633,
 1631965099,
 11256,
 -40632,
 1632025734,
 11255,
 -40631,
 1632087216,
 11253,
 -40630,
 1632145909,
 11252,
 -1,
 1632184973,
 11254,
 -40628,
 1631868497,
 127945,
 -1,
 1632316200,
 8381,
 1632526721,
 1627558935,
 -1,
 1632592229,
 1632470285,
 -1,
 1632657751,
 1632549377,
 -1,
 1632723286,
 1632584190,
 -1,
 1632788820,
 1632692439,
 -1,
 -40621,
 1632753274,
 65939,
 -1,
 1632772559,
 65936,
 -40619,
 1632748784,
 65944,
 -1,
 1632930746,
 65938,
 -1,
 1632659506,
 65941,
 1633182045,
 1632605042,
 -1,
 1633247579,
 1633112082,
 -1,
 -40614,
 1633209248,
 8583,
 -1,
 1633239891,
 8582,
 -40612,
 1633206432,
 8581,
 -1,
 1633392806,
 8584,
 1633575265,
 1633106189,
 -1,
 -40609,
 1633540330,
 65945,
 -40608,
 1633577088,
 65940,
 -1,
 1633634350,
 65942,
 -40606,
 1633539902,
 65937,
 -40605,
 1633791128,
 65943,
 -40604,
 1633824758,
 65947,
 -1,
 1633887418,
 65946,
 1634099569,
 1632556924,
 -1,
 1634165102,
 1634026677,
 -1,
 1634230634,
 1634123087,
 -1,
 -40599,
 1634194547,
 127588,
 -1,
 1634246268,
 127586,
 -40597,
 1634199723,
 127587,
 -40596,
 1634370314,
 127585,
 -40595,
 1634423984,
 127584,
 -1,
 1634479625,
 127589,
 1634729983,
 1634074624,
 -1,
 -40592,
 1634650407,
 128907,
 -1,
 1634708178,
 128205,
 1634886007,
 1634041808,
 -1,
 1634951541,
 1634812414,
 -1,
 -40588,
 1634905299,
 127906,
 -1,
 1634941314,
 128478,
 -40586,
 1634888430,
 129315,
 -1,
 1635058998,
 129531,
 1635279226,
 1634847040,
 -1,
 -40583,
 1635246912,
 11215,
 -1,
 1635286712,
 11213,
 1635475836,
 1635236889,
 127801,
 -1,
 1635438915,
 127989,
 -40579,
 1635443211,
 128675,
 -40578,
 1635556756,
 128019,
 -40577,
 1635595092,
 128640,
 -40576,
 1635658748,
 129302,
 -1,
 1635722557,
 127840,
 1635934628,
 1632442758,
 -1,
 1636000152,
 1635869613,
 -1,
 1636065683,
 1635957849,
 -1,
 1636131208,
 1636008819,
 -1,
 -40570,
 1636084988,
 127340,
 -40569,
 1636120946,
 127339,
 -1,
 1636183481,
 127338,
 1636393356,
 1636064106,
 9995,
 1636499455,
 1636305762,
 -1,
 -40565,
 1636410464,
 128406,
 -1,
 1636454619,
 128400,
 1636655502,
 1636318547,
 11827,
 -1,
 1636616631,
 11783,
 -40561,
 1636615005,
 11787,
 -40560,
 1636723870,
 11782,
 -40559,
 1636782368,
 9994,
 -40558,
 1636840602,
 11828,
 -1,
 1636902814,
 129306,
 1637114261,
 1636011052,
 9926,
 -1,
 1637035091,
 127752,
 1637285887,
 1637057378,
 -1,
 -40553,
 1637207894,
 128740,
 -1,
 1637232373,
 128643,
 1637441949,
 1635921315,
 -1,
 1637507484,
 1637378615,
 -1,
 -40549,
 1637452475,
 127949,
 -1,
 1637494517,
 127950,
 -1,
 1637430779,
 129437,
 1637769631,
 1637366938,
 128251,
 -1,
 1637679492,
 128280,
 1637900705,
 1637689578,
 128007,
 -1,
 1637810876,
 128048,
 -40542,
 1637871040,
 129682,
 -40541,
 1637992353,
 128000,
 -1,
 1638040435,
 128015,
 1638228393,
 1635874575,
 -1,
 -40538,
 1638175767,
 983226,
 -40537,
 1638237043,
 983221,
 -40536,
 1638294445,
 983231,
 -1,
 1638351358,
 983223,
 -40534,
 1638185473,
 983113,
 -1,
 1638489968,
 129423,
 1638687410,
 1611555757,
 -1,
 1638752888,
 1638632492,
 -1,
 1638818319,
 1638676749,
 983129,
 1638883854,
 1638753197,
 -1,
 1638949389,
 1638804928,
 -1,
 1639014916,
 1638896461,
 -1,
 1639080386,
 1638975393,
 -1,
 1639145913,
 1639047355,
 -1,
 1639211447,
 1639093271,
 126066,
 1639317503,
 1639120896,
 -1,
 -40522,
 1639238560,
 126093,
 -1,
 1639277363,
 126084,
 1639514111,
 1639139638,
 126075,
 -1,
 1639385561,
 126102,
 1639604672,
 1639078411,
 -1,
 1639670206,
 1639559342,
 126067,
 1639776255,
 1639579648,
 -1,
 -40515,
 1639697312,
 126094,
 -1,
 1639736115,
 126085,
 1639972863,
 1639608083,
 126076,
 -1,
 1639844313,
 126103,
 1640103935,
 1639532487,
 126074,
 -1,
 1639975385,
 126101,
 1640194511,
 1639037441,
 -1,
 1640260041,
 1640132976,
 126070,
 1640325574,
 1640223614,
 126079,
 -1,
 1640237529,
 126106,
 1640497151,
 1640235008,
 -1,
 -40504,
 1640418208,
 126097,
 -1,
 1640457011,
 126088,
 1640693759,
 1640189077,
 126071,
 1640718796,
 1640616830,
 126080,
 -1,
 1640630745,
 126107,
 1640890367,
 1640628224,
 -1,
 -40498,
 1640811424,
 126098,
 -1,
 1640850227,
 126089,
 1641046494,
 1640124049,
 -1,
 1641112023,
 1640993815,
 -1,
 1641177557,
 1641077180,
 126068,
 1641283583,
 1641086976,
 -1,
 -40492,
 1641204640,
 126095,
 -1,
 1641243443,
 126086,
 1641480191,
 1641134416,
 126077,
 -1,
 1641351641,
 126104,
 1641611263,
 1641046957,
 -1,
 1641636316,
 1641536664,
 126069,
 1641742335,
 1641545728,
 -1,
 -40485,
 1641663392,
 126096,
 -1,
 1641702195,
 126087,
 1641938943,
 1641567404,
 126078,
 -1,
 1641810393,
 126105,
 1642029547,
 1640999286,
 -1,
 1642095074,
 1641990049,
 -1,
 -40479,
 1642063382,
 126116,
 -1,
 1642095072,
 126117,
 1642291685,
 1642052097,
 -1,
 -40476,
 1642230128,
 126120,
 -1,
 1642286229,
 126121,
 1642488296,
 1642221201,
 -1,
 -40473,
 1642438397,
 126118,
 -1,
 1642492094,
 126119,
 -40471,
 1642436693,
 126115,
 -40470,
 1642631240,
 126123,
 -1,
 1642677894,
 126122,
 1642881521,
 1641975880,
 126073,
 1642947054,
 1642845054,
 126082,
 -1,
 1642858969,
 126109,
 1643118591,
 1642856448,
 -1,
 -40464,
 1643039648,
 126100,
 -1,
 1643078451,
 126091,
 1643274743,
 1642808966,
 126072,
 1643340276,
 1643243812,
 126081,
 -1,
 1643252185,
 126108,
 1643511807,
 1643249664,
 -1,
 -40458,
 1643432864,
 126099,
 -1,
 1643471667,
 126090,
 1643667963,
 1643223125,
 126065,
 1643773951,
 1643577344,
 -1,
 -40454,
 1643695008,
 126092,
 -1,
 1643733811,
 126083,
 1643930112,
 1643585445,
 -1,
 1643995647,
 1643890593,
 -1,
 -40450,
 1643963926,
 126130,
 -1,
 1643989014,
 126131,
 -1,
 1643944021,
 126129,
 1644257794,
 1643870250,
 126110,
 -1,
 1644175429,
 126111,
 1644429311,
 1644196913,
 126113,
 -1,
 1644306501,
 126114,
 1644519945,
 1638945716,
 -1,
 1644585480,
 1644468313,
 -1,
 -40441,
 1644538841,
 126125,
 -1,
 1644583609,
 126126,
 -1,
 1644547099,
 126127,
 -40438,
 1644476846,
 126128,
 -40437,
 1644799686,
 126124,
 -40436,
 1644853295,
 126112,
 -1,
 1644896176,
 126132,
 -1,
 1638867020,
 8377,
 -1,
 1638813035,
 983128,
 1645240924,
 1638775818,
 -1,
 1645306424,
 1645197606,
 -1,
 1645371948,
 1645247830,
 -1,
 1645437463,
 1645328897,
 -1,
 1645502998,
 1645353350,
 -1,
 -40427,
 1645447010,
 68430,
 -1,
 1645493183,
 68433,
 -1,
 1645436746,
 68436,
 1645765146,
 1645397921,
 -1,
 -40423,
 1645693852,
 68424,
 -1,
 1645750013,
 68437,
 1645961756,
 1645698202,
 68420,
 -1,
 1645923006,
 68423,
 1646092831,
 1645877638,
 -1,
 -40418,
 1646062306,
 68431,
 -1,
 1646099743,
 68416,
 -40416,
 1646062830,
 68422,
 -40415,
 1646259113,
 68425,
 -40414,
 1646322145,
 68421,
 -40413,
 1646375333,
 68435,
 -40412,
 1646439282,
 68434,
 -40411,
 1646503119,
 68432,
 -40410,
 1646564233,
 68429,
 -40409,
 1646626683,
 68428,
 -40408,
 1646688342,
 68427,
 -40407,
 1646752775,
 68426,
 -40406,
 1646811162,
 68418,
 -40405,
 1646868974,
 68419,
 -1,
 1646930339,
 68417,
 1647181823,
 1645318989,
 -1,
 1647206963,
 1647101857,
 -1,
 1647272497,
 1647173819,
 -1,
 -40400,
 1647219735,
 68441,
 -1,
 1647266102,
 68445,
 -40398,
 1647206880,
 68442,
 -1,
 1647396807,
 68444,
 1647600183,
 1647155285,
 68440,
 1647706111,
 1647509504,
 -1,
 -40394,
 1647627168,
 68447,
 -1,
 1647665971,
 68446,
 -1,
 1647530727,
 68443,
 1647968255,
 1645240305,
 -1,
 1647993424,
 1647869270,
 -1,
 1648058943,
 1647950337,
 -1,
 1648124478,
 1647974790,
 -1,
 -40387,
 1648068450,
 68462,
 -1,
 1648114623,
 68464,
 -1,
 1648058186,
 68465,
 1648386626,
 1648019361,
 -1,
 -40383,
 1648315292,
 68456,
 -1,
 1648371453,
 68466,
 1648583236,
 1648319642,
 68452,
 -1,
 1648544446,
 68455,
 -40379,
 1648553198,
 68454,
 -40378,
 1648683945,
 68457,
 -40377,
 1648746991,
 68453,
 -40376,
 1648796879,
 68463,
 -40375,
 1648857993,
 68461,
 -40374,
 1648920447,
 68460,
 -40373,
 1648982102,
 68459,
 -40372,
 1649046535,
 68458,
 -40371,
 1649104922,
 68450,
 -40370,
 1649162734,
 68451,
 -40369,
 1649224099,
 68449,
 -1,
 1649286908,
 68448,
 1649541119,
 1647940429,
 -1,
 1649566295,
 1649461153,
 -1,
 1649631829,
 1649533115,
 -1,
 -40364,
 1649579031,
 68473,
 -1,
 1649625398,
 68477,
 -40362,
 1649566176,
 68474,
 -1,
 1649756103,
 68476,
 1649959515,
 1649514581,
 68472,
 1650065407,
 1649868800,
 -1,
 -40358,
 1649986464,
 68479,
 -1,
 1650025267,
 68478,
 -1,
 1649890023,
 68475,
 1650287204,
 1645206448,
 -1,
 1650352739,
 1650215668,
 -1,
 1650418272,
 1650295239,
 11845,
 -1,
 1650330984,
 11846,
 -40351,
 1650382733,
 8276,
 -40350,
 1650501005,
 9959,
 -1,
 1650551987,
 11800,
 -1,
 1650290528,
 8292,
 1650811499,
 1650240230,
 -1,
 1650877033,
 1650751795,
 -1,
 -40345,
 1650835883,
 128289,
 -40344,
 1650883993,
 128292,
 -1,
 1650929381,
 128288,
 -40342,
 1650837389,
 128291,
 -1,
 1651086186,
 128290,
 1651270259,
 1650741882,
 -1,
 1651335794,
 1651227830,
 -1,
 1651401328,
 1651296161,
 -1,
 -40337,
 1651369494,
 983111,
 -1,
 1651401184,
 983108,
 -40335,
 1651349589,
 983114,
 -1,
 1651528423,
 983105,
 -1,
 1651260291,
 128129,
 1651794550,
 1651191203,
 -1,
 -40331,
 1651748825,
 128474,
 -1,
 1651808156,
 128232,
 -40329,
 1651755588,
 9892,
 -1,
 1651911785,
 128229,
 1652122274,
 1638697699,
 128127,
 1652228095,
 1652050547,
 -1,
 1652253333,
 1652129110,
 -1,
 1652318848,
 1652210177,
 -1,
 1652384383,
 1652234630,
 -1,
 -40322,
 1652328290,
 67662,
 -1,
 1652374463,
 67665,
 -1,
 1652318026,
 67668,
 1652646531,
 1652279201,
 -1,
 -40318,
 1652575132,
 67656,
 -1,
 1652631293,
 67669,
 1652843141,
 1652579482,
 67652,
 -1,
 1652804286,
 67655,
 1652974216,
 1652758918,
 -1,
 -40313,
 1652943586,
 67663,
 -1,
 1652981023,
 67648,
 -40311,
 1652944110,
 67654,
 -40310,
 1653140393,
 67657,
 -40309,
 1653203425,
 67653,
 -40308,
 1653256613,
 67667,
 -40307,
 1653320562,
 67666,
 -40306,
 1653384399,
 67664,
 -40305,
 1653445513,
 67661,
 -40304,
 1653507963,
 67660,
 -40303,
 1653569622,
 67659,
 -40302,
 1653634055,
 67658,
 -40301,
 1653692442,
 67650,
 -40300,
 1653750254,
 67651,
 -1,
 1653811619,
 67649,
 1654022817,
 1652200269,
 -1,
 1654088349,
 1653983137,
 -1,
 1654153882,
 1654055099,
 -1,
 -40295,
 1654101015,
 67673,
 -1,
 1654147382,
 67676,
 1654350492,
 1654081479,
 67675,
 -1,
 1654262233,
 67679,
 -1,
 1654284768,
 67674,
 1654587391,
 1654036565,
 67672,
 1654652927,
 1654456320,
 -1,
 -40288,
 1654573984,
 67678,
 -1,
 1654612787,
 67677,
 -1,
 1653980236,
 67671,
 1654874794,
 1652046625,
 -1,
 1654940326,
 1654835105,
 -1,
 -40283,
 1654908438,
 119667,
 -1,
 1654940128,
 119668,
 1655136937,
 1654869649,
 -1,
 -40280,
 1655086845,
 119669,
 -1,
 1655140542,
 119670,
 -1,
 1655085141,
 119666,
 1655399088,
 1654796192,
 -1,
 1655464622,
 1655319971,
 -1,
 -40275,
 1655428258,
 129482,
 -1,
 1655484356,
 127848,
 -40273,
 1655423210,
 9976,
 -1,
 1655595051,
 127954,
 -40271,
 1655368841,
 127982,
 -1,
 1655702605,
 129311,
 1655923543,
 1638616721,
 -1,
 1655988969,
 1655839110,
 -1,
 1656054494,
 1655909795,
 -1,
 1656120028,
 1655980544,
 -1,
 1656185558,
 1656087623,
 -1,
 1656251093,
 1656094720,
 -1,
 1656316607,
 1656198167,
 -1,
 1656382141,
 1656268103,
 128558,
 1656487935,
 1656291328,
 -1,
 -40260,
 1656414153,
 129326,
 -1,
 1656430748,
 128560,
 -40258,
 1656327703,
 129320,
 -1,
 1656582974,
 128582,
 1656775363,
 1656276592,
 128539,
 1656881151,
 1656684610,
 -1,
 -40254,
 1656808495,
 128540,
 -1,
 1656868084,
 128541,
 1657037510,
 1656735649,
 -1,
 -40251,
 1656970698,
 129298,
 -1,
 1657029470,
 128514,
 1657234121,
 1656988335,
 -1,
 -40248,
 1657174641,
 129402,
 -1,
 1657218175,
 129395,
 1657430732,
 1657176947,
 -1,
 -40245,
 1657379298,
 129488,
 -1,
 1657423092,
 128567,
 1657627343,
 1657353261,
 -1,
 -40242,
 1657594385,
 129312,
 -1,
 1657633267,
 128531,
 -40240,
 1657591710,
 129396,
 -40239,
 1657780169,
 128580,
 -40238,
 1657835808,
 128581,
 -40237,
 1657897248,
 128548,
 -40236,
 1657953494,
 129301,
 -1,
 1658015917,
 129323,
 -1,
 1656201202,
 128566,
 1658282713,
 1656142337,
 -1,
 -40232,
 1658205829,
 128561,
 -1,
 1658267356,
 128523,
 -40230,
 1658244187,
 128536,
 -40229,
 1658430343,
 129318,
 -1,
 1658488324,
 128134,
 -40227,
 1656082219,
 127981,
 -1,
 1658634256,
 8507,
 1658807011,
 1655994127,
 -1,
 1658872546,
 1658746639,
 -1,
 -40223,
 1658808910,
 9950,
 -1,
 1658865614,
 127810,
 -1,
 1658789074,
 129478,
 1659134694,
 1658775573,
 -1,
 -40219,
 1659077598,
 128224,
 -1,
 1659135261,
 128439,
 -40217,
 1659095857,
 127877,
 -40216,
 1659275553,
 128106,
 -1,
 1659334436,
 129498,
 1659527946,
 1655923629,
 -1,
 1659593465,
 1659481286,
 -1,
 1659658995,
 1659519486,
 128293,
 1659724527,
 1659627431,
 -1,
 -40210,
 1659681281,
 127878,
 -1,
 1659701585,
 127879,
 1659921138,
 1659634347,
 -1,
 -40207,
 1659889896,
 129519,
 -1,
 1659932617,
 128658,
 -1,
 1659844214,
 129512,
 1660223487,
 1659618376,
 -1,
 1660248823,
 1660136426,
 -1,
 -40202,
 1660216418,
 127771,
 -1,
 1660274526,
 127763,
 -40200,
 1660208694,
 8296,
 -1,
 1660397242,
 129351,
 1660576513,
 1659533071,
 -1,
 1660642046,
 1660502528,
 -1,
 -40196,
 1660599468,
 983106,
 -40195,
 1660637758,
 128193,
 -1,
 1660694004,
 128452,
 1660944383,
 1660584821,
 -1,
 -40192,
 1660856789,
 128253,
 -1,
 1660900334,
 127902,
 1661100806,
 1660533249,
 -1,
 1661166341,
 1661032971,
 128031,
 -40188,
 1661102864,
 127907,
 -1,
 1661141388,
 127845,
 -1,
 1661127081,
 128074,
 1661428489,
 1661066399,
 -1,
 -40184,
 1661381193,
 8281,
 -1,
 1661437299,
 11821,
 -1,
 1661355800,
 127953,
 1661690657,
 1659474967,
 -1,
 1661756180,
 1661653914,
 -1,
 1661821715,
 1661709512,
 -1,
 1661887248,
 1661746519,
 -1,
 -40177,
 1661839945,
 8280,
 -1,
 1661896051,
 8283,
 -40175,
 1661839329,
 128966,
 -40174,
 1662024343,
 127808,
 -1,
 1662072374,
 11156,
 -1,
 1661768392,
 9970,
 1662346011,
 1661709510,
 -1,
 1662411545,
 1662284601,
 -1,
 1662477080,
 1662320744,
 127860,
 -1,
 1662389719,
 127869,
 -1,
 1662403722,
 11792,
 -40166,
 1662374340,
 129376,
 -1,
 1662616454,
 983071,
 1662804765,
 1662295450,
 129462,
 -1,
 1662757294,
 128099,
 1662935839,
 1662735560,
 127787,
 -1,
 1662867961,
 127745,
 -40160,
 1662904344,
 129418,
 -1,
 1663007243,
 128448,
 1663198006,
 1661630223,
 -1,
 1663263528,
 1663144983,
 -1,
 1663329063,
 1663230581,
 9880,
 1663434751,
 1663239911,
 -1,
 -40154,
 1663358805,
 8277,
 -1,
 1663400344,
 127924,
 -1,
 1663281489,
 128190,
 1663656750,
 1663179142,
 -1,
 1663722284,
 1663616929,
 -1,
 -40149,
 1663667961,
 9189,
 -1,
 1663699230,
 129407,
 -40147,
 1663666518,
 129449,
 -1,
 1663849681,
 9971,
 1664049970,
 1663625965,
 -1,
 -40144,
 1664007105,
 128760,
 -40143,
 1664043363,
 128389,
 -1,
 1664105677,
 129359,
 1664312117,
 1663975934,
 -1,
 -40140,
 1664280695,
 128170,
 -1,
 1664342481,
 9884,
 -1,
 1664277217,
 128563,
 1664574275,
 1663151302,
 -1,
 1664639803,
 1664521239,
 -1,
 -40135,
 1664607705,
 128550,
 -40134,
 1664651933,
 128037,
 -1,
 1664701642,
 128056,
 1664901951,
 1664557071,
 -1,
 -40131,
 1664863562,
 128445,
 -40130,
 1664919132,
 128444,
 -1,
 1664950362,
 128446,
 1665164098,
 1664827902,
 -1,
 -40127,
 1665109293,
 127839,
 -1,
 1665158790,
 129398,
 -1,
 1665099181,
 127844,
 1665426250,
 1664537498,
 -1,
 1665491783,
 1665368032,
 -1,
 -40122,
 1665459298,
 127773,
 -1,
 1665517406,
 127765,
 -40120,
 1665448985,
 9179,
 -40119,
 1665634018,
 9905,
 -1,
 1665681164,
 9981,
 1665885008,
 1665352190,
 -1,
 1665950542,
 1665841333,
 -1,
 -40115,
 1665919268,
 9972,
 -1,
 1665953579,
 127905,
 -40113,
 1665895716,
 129338,
 -1,
 1666065223,
 128552,
 1666278228,
 1665851537,
 -1,
 -40110,
 1666192268,
 983215,
 -40109,
 1666257511,
 983214,
 -1,
 1666322748,
 983213,
 1666540374,
 1666234881,
 983107,
 -1,
 1666474925,
 983232,
 -1,
 1666469521,
 983072,
 1666737116,
 1655861773,
 -1,
 1666802646,
 1666652550,
 -1,
 1666868173,
 1666767848,
 -1,
 1666933650,
 1666808336,
 -1,
 1666999185,
 1666896236,
 -1,
 1667064676,
 1666944044,
 -1,
 1667130208,
 1666995479,
 43412,
 1667235839,
 1667040284,
 43402,
 -1,
 1667106950,
 43403,
 1667326818,
 1667099039,
 43418,
 -1,
 1667237075,
 43416,
 1667497983,
 1667242374,
 43428,
 -1,
 1667368147,
 43423,
 1667588969,
 1667024801,
 -1,
 1667654503,
 1667549223,
 43419,
 -1,
 1667564669,
 43420,
 1667825663,
 1667570054,
 43424,
 -1,
 1667695827,
 43425,
 1667916654,
 1667512589,
 -1,
 1667982188,
 1667840412,
 43421,
 -1,
 1667892349,
 43422,
 1668153343,
 1667897734,
 43426,
 -1,
 1668023421,
 43427,
 1668244338,
 1667873494,
 43441,
 1668349951,
 1668154465,
 -1,
 -40079,
 1668274674,
 43439,
 -1,
 1668291975,
 43440,
 1668506486,
 1668195083,
 43429,
 1668612095,
 1668415488,
 -1,
 -40075,
 1668516825,
 43430,
 -1,
 1668558888,
 43401,
 1668768634,
 1668445067,
 43407,
 1668874239,
 1668677632,
 -1,
 -40071,
 1668791223,
 43408,
 -1,
 1668844505,
 43409,
 1669030781,
 1668703149,
 43398,
 -40068,
 1668965293,
 43399,
 -1,
 1669006277,
 43397,
 1669227391,
 1668984128,
 43435,
 -1,
 1669136410,
 43436,
 1669358465,
 1669165611,
 43415,
 -1,
 1669268605,
 43417,
 1669489539,
 1669289239,
 43410,
 -1,
 1669399763,
 43411,
 1669620613,
 1669410266,
 43413,
 -1,
 1669530835,
 43414,
 1669751687,
 1669539728,
 43431,
 -1,
 1669661907,
 43432,
 1669882761,
 1669667206,
 43396,
 -1,
 1669817261,
 43405,
 -40054,
 1669851551,
 43434,
 -40053,
 1669980411,
 43438,
 -40052,
 1670042522,
 43400,
 -40051,
 1670091799,
 43406,
 -40050,
 1670153161,
 43433,
 -40049,
 1670215513,
 43437,
 -40048,
 1670273565,
 43442,
 -1,
 1670332926,
 43404,
 -1,
 1666929781,
 43457,
 1670603687,
 1666884363,
 -1,
 1670669220,
 1670527391,
 -1,
 1670734745,
 1670608655,
 -1,
 1670800280,
 1670697882,
 -1,
 -40041,
 1670746074,
 43465,
 -1,
 1670800239,
 43461,
 -1,
 1670736801,
 43464,
 1671062429,
 1670650246,
 -1,
 1671127964,
 1670986456,
 43466,
 -1,
 1671036948,
 43467,
 -1,
 1671073206,
 43459,
 1671324576,
 1671013039,
 -1,
 -40033,
 1671262008,
 43468,
 -1,
 1671307643,
 43463,
 -40031,
 1671291919,
 43462,
 -40030,
 1671482902,
 43486,
 -40029,
 1671529501,
 43460,
 -1,
 1671589695,
 43487,
 1671823359,
 1670614865,
 -1,
 -40026,
 1671736955,
 43471,
 -1,
 1671788101,
 43456,
 1671979957,
 1670528099,
 -1,
 1672045483,
 1671940001,
 -1,
 -40022,
 1672013334,
 43474,
 -1,
 1672045024,
 43475,
 1672242094,
 1672002049,
 -1,
 -40019,
 1672180080,
 43478,
 -1,
 1672236181,
 43479,
 1672438705,
 1672171153,
 -1,
 -40016,
 1672388349,
 43476,
 -1,
 1672442046,
 43477,
 -40014,
 1672408347,
 43472,
 -40013,
 1672583253,
 43473,
 -40012,
 1672646728,
 43481,
 -1,
 1672693382,
 43480,
 1672897473,
 1671946294,
 -1,
 1672963003,
 1672857505,
 -1,
 1673028538,
 1672878470,
 -1,
 -40007,
 1672984996,
 43444,
 -1,
 1673035590,
 43450,
 -1,
 1672976153,
 43445,
 1673290685,
 1672931339,
 43446,
 -1,
 1673200791,
 43447,
 1673421759,
 1673250505,
 43448,
 -1,
 1673331870,
 43449,
 -40000,
 1673373089,
 43452,
 -1,
 1673477314,
 43451,
 1673683911,
 1672855481,
 -1,
 1673749444,
 1673605054,
 43393,
 -1,
 1673660877,
 43443,
 -39995,
 1673716736,
 43395,
 -39994,
 1673831347,
 43392,
 -1,
 1673886098,
 43394,
 1674077131,
 1673606488,
 -1,
 -39991,
 1674028386,
 43454,
 -39990,
 1674081532,
 43453,
 -1,
 1674128920,
 43455,
 -39988,
 1674039872,
 43469,
 -1,
 1674294262,
 43458,
 1674470357,
 1666818979,
 -1,
 -39985,
 1674430317,
 128304,
 -39984,
 1674488021,
 127971,
 -39983,
 1674548723,
 128121,
 -39982,
 1674598555,
 128122,
 -39981,
 1674657097,
 127886,
 -39980,
 1674719011,
 127983,
 -1,
 1674782760,
 9979,
 -1,
 1674392339,
 127875,
 1675060185,
 1666765722,
 -1,
 -39976,
 1675006237,
 9909,
 -1,
 1675056913,
 129337,
 -39974,
 1675010678,
 128377,
 -39973,
 1675192246,
 129513,
 -1,
 1675248462,
 128086,
 1675453522,
 1666700186,
 -1,
 1675519004,
 1675403951,
 -1,
 1675584525,
 1675485531,
 -1,
 1675650036,
 1675544481,
 -1,
 1675715571,
 1675604700,
 -1,
 1675781106,
 1675628301,
 -1,
 1675846640,
 1675699218,
 11105,
 1675952127,
 1675755520,
 -1,
 1675977710,
 1675879500,
 -1,
 1676043240,
 1675919623,
 -1,
 -39961,
 1675998431,
 11171,
 -1,
 1676049442,
 11170,
 -39959,
 1676009048,
 129073,
 -39958,
 1676184802,
 129057,
 -39957,
 1676248829,
 129061,
 -39956,
 1676303683,
 129069,
 -39955,
 1676361537,
 11131,
 -1,
 1676422111,
 129065,
 -39953,
 1675939409,
 11121,
 -1,
 1676573814,
 11137,
 -39951,
 1675797333,
 11141,
 -1,
 1676687930,
 11115,
 -1,
 1675690264,
 129169,
 -1,
 1675683603,
 11245,
 1677026302,
 1675565446,
 -1,
 1677091837,
 1676982495,
 -1,
 1677157369,
 1677050128,
 -1,
 -39944,
 1677119484,
 129025,
 -1,
 1677150704,
 129041,
 -39942,
 1677103567,
 129177,
 -39941,
 1677297432,
 129029,
 -39940,
 1677359311,
 129033,
 -1,
 1677412848,
 129045,
 -1,
 1677036855,
 11797,
 1677681665,
 1676993282,
 -1,
 -39936,
 1677649301,
 129173,
 -1,
 1677677589,
 11192,
 1677878276,
 1677638145,
 -1,
 -39933,
 1677831116,
 129081,
 -1,
 1677861336,
 129105,
 1678074887,
 1677810987,
 -1,
 -39930,
 1677997295,
 129089,
 -1,
 1678058514,
 129093,
 1678271498,
 1677994720,
 -1,
 -39927,
 1678193257,
 11145,
 -1,
 1678255122,
 11014,
 -39925,
 1678227355,
 128621,
 -39924,
 1678397641,
 129077,
 -1,
 1678456047,
 129085,
 1678664724,
 1675497379,
 -1,
 1678730257,
 1678622992,
 -1,
 -39920,
 1678684310,
 128316,
 -1,
 1678712279,
 128744,
 -39918,
 1678684310,
 128314,
 -39917,
 1678870779,
 128742,
 -1,
 1678908887,
 128743,
 1679123482,
 1678573568,
 -1,
 1679189017,
 1679048671,
 -1,
 -39913,
 1679151170,
 11109,
 -39912,
 1679211396,
 129113,
 -1,
 1679239911,
 11021,
 -1,
 1679107141,
 11193,
 -39909,
 1679081342,
 128579,
 -1,
 1679467959,
 128319,
 1679647813,
 1675449835,
 -1,
 1679713348,
 1679588694,
 -1,
 1679778852,
 1679669761,
 -1,
 1679844386,
 1679694214,
 -1,
 -39903,
 1679788478,
 66450,
 -1,
 1679833719,
 66453,
 -39901,
 1679804033,
 66461,
 -1,
 1679974218,
 66444,
 1680172072,
 1679738785,
 -1,
 -39898,
 1680118807,
 66458,
 -39897,
 1680169987,
 66456,
 -1,
 1680231275,
 66441,
 1680434219,
 1680141360,
 -1,
 -39894,
 1680397210,
 66449,
 -1,
 1680427912,
 66439,
 1680630830,
 1680372537,
 -1,
 -39891,
 1680562717,
 66435,
 -1,
 1680612549,
 66443,
 1680827440,
 1680564253,
 66437,
 -1,
 1680787495,
 66440,
 1680958515,
 1680757960,
 -1,
 -39886,
 1680890483,
 66457,
 -1,
 1680941091,
 66434,
 1681155126,
 1680881933,
 -1,
 -39883,
 1681087138,
 66447,
 -1,
 1681147768,
 66436,
 1681351737,
 1681070470,
 -1,
 -39880,
 1681293935,
 66432,
 -1,
 1681352878,
 66451,
 -39878,
 1681320856,
 66442,
 -39877,
 1681516054,
 66438,
 -39876,
 1681576858,
 66460,
 -39875,
 1681632940,
 66455,
 -39874,
 1681697645,
 66454,
 -39873,
 1681762861,
 66452,
 -39872,
 1681822601,
 66448,
 -39871,
 1681885051,
 66446,
 -39870,
 1681946704,
 66445,
 -39869,
 1682006957,
 66459,
 -1,
 1682057623,
 66433,
 -1,
 1679681398,
 66463,
 1682334798,
 1679592492,
 -1,
 1682400331,
 1682269101,
 -1,
 1682465866,
 1682360225,
 -1,
 -39863,
 1682392235,
 11258,
 -1,
 1682442503,
 983115,
 -1,
 1682388524,
 129412,
 -39860,
 1682343363,
 9903,
 -39859,
 1682649134,
 11217,
 -1,
 1682710585,
 128530,
 1682924625,
 1682278013,
 -1,
 -39856,
 1682892011,
 9748,
 -1,
 1682937826,
 9969,
 -1,
 1682881025,
 983116,
 1683186883,
 1675422768,
 -1,
 1683252408,
 1683103847,
 -1,
 1683317900,
 1683193174,
 -1,
 1683383390,
 1683277729,
 -1,
 1683448921,
 1683343265,
 -1,
 -39848,
 1683380765,
 72213,
 -1,
 1683429766,
 72212,
 1683645532,
 1683405313,
 -1,
 -39845,
 1683577373,
 72228,
 -1,
 1683626374,
 72227,
 -39843,
 1683577373,
 72218,
 -1,
 1683757446,
 72217,
 1683973223,
 1683306765,
 -1,
 1684038754,
 1683942448,
 -1,
 -39839,
 1683970589,
 72230,
 -1,
 1684019590,
 72229,
 1684235365,
 1683962125,
 -1,
 -39836,
 1684167197,
 72215,
 -1,
 1684216198,
 72214,
 -39834,
 1684167197,
 72220,
 -1,
 1684347270,
 72219,
 1684563052,
 1683917868,
 -1,
 -39831,
 1684531615,
 72211,
 -39830,
 1684573302,
 72216,
 -39829,
 1684624663,
 72207,
 -1,
 1684674950,
 72221,
 1684890736,
 1684519425,
 -1,
 -39826,
 1684847318,
 72239,
 -39825,
 1684888093,
 72238,
 -1,
 1684937094,
 72240,
 1685152884,
 1684828985,
 -1,
 -39822,
 1685111746,
 72242,
 -39821,
 1685150237,
 72204,
 -1,
 1685199238,
 72203,
 1685415031,
 1685122096,
 -1,
 -39818,
 1685346845,
 72231,
 -1,
 1685395846,
 72232,
 1685611642,
 1685365423,
 -1,
 -39815,
 1685543453,
 72223,
 -1,
 1685592454,
 72222,
 1685808253,
 1685542088,
 -1,
 -39812,
 1685740061,
 72206,
 -1,
 1685789062,
 72205,
 1686004864,
 1685728675,
 -1,
 -39809,
 1685936669,
 72209,
 -1,
 1685985670,
 72208,
 1686201475,
 1685923679,
 -1,
 -39806,
 1686133277,
 72225,
 -1,
 1686182278,
 72224,
 -39804,
 1686170015,
 72234,
 -39803,
 1686363075,
 72237,
 -39802,
 1686416704,
 72235,
 -39801,
 1686471625,
 72226,
 -39800,
 1686533977,
 72236,
 -39799,
 1686598187,
 72210,
 -39798,
 1686657565,
 72241,
 -39797,
 1686706566,
 72192,
 -1,
 1686769325,
 72233,
 1686987929,
 1683283956,
 -1,
 1687053464,
 1686945721,
 -1,
 1687118992,
 1687016346,
 72195,
 -1,
 1687044606,
 72194,
 1687250066,
 1687065623,
 72198,
 -1,
 1687175678,
 72197,
 1687381141,
 1687165318,
 -1,
 -39788,
 1687344026,
 72200,
 -1,
 1687380909,
 72199,
 -39786,
 1687335478,
 72201,
 -39785,
 1687511981,
 72193,
 -1,
 1687568894,
 72196,
 -1,
 1686994181,
 72202,
 1687839908,
 1686944257,
 -1,
 1687905443,
 1687775097,
 -1,
 1687970975,
 1687826001,
 -1,
 1688036510,
 1687890536,
 72245,
 -1,
 1687948714,
 72246,
 -1,
 1687948714,
 72247,
 1688233122,
 1687936701,
 -1,
 -39775,
 1688189873,
 72249,
 -1,
 1688251993,
 72244,
 -1,
 1688150565,
 72248,
 -1,
 1687868629,
 72263,
 1688560815,
 1687761781,
 -1,
 1688626348,
 1688525606,
 -1,
 1688691883,
 1688555633,
 -1,
 -39768,
 1688660383,
 72251,
 -39767,
 1688722371,
 72254,
 -39766,
 1688776000,
 72252,
 -1,
 1688827737,
 72253,
 -1,
 1688628218,
 72250,
 1689124863,
 1688575354,
 -1,
 -39762,
 1689017520,
 72256,
 -1,
 1689075651,
 72262,
 1689281716,
 1688503672,
 -1,
 -39759,
 1689243958,
 72257,
 -39758,
 1689304505,
 72258,
 -39757,
 1689354513,
 72260,
 -1,
 1689403280,
 72259,
 1689609399,
 1689217997,
 -1,
 -39754,
 1689541808,
 72255,
 -1,
 1689599939,
 72261,
 -1,
 1689538630,
 72243,
 1689871550,
 1683218619,
 -1,
 1689937084,
 1689816108,
 -1,
 -39749,
 1689874957,
 983218,
 -1,
 1689922806,
 983259,
 -39747,
 1689895651,
 983217,
 -1,
 1690071565,
 983219,
 1690264769,
 1689797118,
 -1,
 -39744,
 1690229422,
 11234,
 -1,
 1690250361,
 129427,
 -39742,
 1690212193,
 129503,
 -1,
 1690398209,
 129296,
 1690592470,
 1683155118,
 -1,
 1690657997,
 1690546278,
 -1,
 1690723528,
 1690578339,
 -1,
 -39737,
 1690655821,
 129636,
 -1,
 1690706377,
 129637,
 -39735,
 1690681996,
 129638,
 -39734,
 1690862903,
 129633,
 -39733,
 1690919250,
 129635,
 -39732,
 1690982087,
 129632,
 -1,
 1691043647,
 129634,
 1691287551,
 1690577632,
 -1,
 1691313361,
 1691168163,
 -1,
 -39728,
 1691245645,
 129643,
 -1,
 1691296201,
 129644,
 -39726,
 1691271820,
 129645,
 -39725,
 1691452727,
 129640,
 -39724,
 1691509074,
 129642,
 -39723,
 1691571911,
 129639,
 -1,
 1691633471,
 129641,
 1691837659,
 1690560804,
 -1,
 -39720,
 1691784279,
 129664,
 -39719,
 1691837407,
 983239,
 -39718,
 1691895636,
 128155,
 -1,
 1691952916,
 129393,
 -1,
 1691790503,
 9915]
_charnames_564 = [
11321,
11386,
11143,
11353,
11357,
11457,
11534,
11616,
11377,
11626,
11508,
11168,
11448,
11634,
11407,
11667,
11602,
11498,
11524,
11191,
11677,
11468,
11565,
11455,
11576,
11275,
11680,
11460,
]

_charnames_751 = [
9458,
9462,
9452,
9461,
9460,
9489,
9487,
9488,
9463,
9500,
9512,
9483,
9511,
9482,
9403,
9514,
9451,
]

_charnames_848 = [
1854,
1789,
1921,
1908,
1786,
1855,
1852,
1857,
1842,
1880,
1831,
1905,
1830,
1829,
1827,
1828,
]

_charnames_880 = [
22326,
22304,
22327,
22305,
-1,
-1,
22325,
22303,
-1,
-1,
-1,
22307,
22309,
22308,
-1,
22324,
]

_charnames_1015 = [
22322,
22301,
22328,
22323,
22302,
22369,
22330,
22333,
22331,
]

_charnames_1270 = [
2986,
2906,
-1,
-1,
2985,
2905,
2968,
2876,
2967,
2875,
]

_charnames_1296 = [
2942,
2840,
2950,
2858,
2991,
2903,
2946,
2845,
2964,
2872,
2988,
2908,
2987,
2891,
2992,
2909,
2949,
2857,
2953,
2861,
2989,
2893,
2939,
2854,
2954,
2862,
2914,
2828,
2923,
2837,
2951,
2859,
]

_charnames_1416 = [
16786,
-1,
-1,
-1,
-1,
24808,
11942,
16788,
]

_charnames_1536 = [
16771,
16699,
16761,
16702,
16700,
16772,
16783,
16782,
16748,
16781,
16780,
17348,
-1,
16753,
16775,
16707,
16701,
16708,
16704,
16705,
16706,
16659,
16662,
16658,
16669,
16670,
16668,
-1,
16606,
-1,
16734,
-1,
16570,
]

_charnames_1622 = [
16721,
16777,
16496,
16773,
16763,
16764,
16765,
16747,
16758,
16774,
]

_charnames_1869 = [
7845,
7846,
7847,
16505,
16513,
16503,
16504,
16506,
16511,
16508,
16588,
16589,
16609,
16613,
16551,
16576,
16534,
16536,
16533,
16527,
16528,
16565,
16563,
16561,
16604,
16603,
16623,
16622,
16621,
16627,
16552,
16555,
16573,
16586,
16584,
16574,
16550,
16585,
16543,
16544,
16518,
16519,
16520,
16616,
16617,
16598,
16599,
16590,
16577,
16575,
16568,
]

_charnames_1984 = [
18436,
18437,
18428,
18429,
18434,
18435,
18431,
18432,
18439,
18438,
18422,
18404,
18416,
18403,
18409,
18402,
18401,
18406,
18387,
18421,
18412,
18410,
18397,
18420,
18405,
18400,
18399,
18411,
18418,
18419,
18415,
18414,
18391,
18413,
18388,
18390,
18417,
18408,
18407,
18389,
18395,
18396,
18394,
18452,
18451,
18450,
18448,
18447,
18446,
18445,
18453,
18454,
18460,
18423,
18457,
18458,
18455,
18461,
18424,
-1,
-1,
18441,
18440,
18459,
7401,
7388,
7398,
7400,
7381,
7389,
7390,
7382,
7378,
7391,
7397,
7396,
7395,
7394,
7385,
7383,
7399,
7377,
7393,
7392,
7386,
7379,
7441,
7442,
7443,
7446,
7450,
7445,
7408,
7419,
7411,
7405,
7416,
7410,
7404,
7415,
7448,
7414,
7406,
7417,
7449,
7407,
7418,
7409,
7413,
7444,
-1,
-1,
7436,
7427,
7424,
7438,
7425,
7433,
7451,
7437,
7429,
7435,
7430,
7434,
7426,
7432,
7423,
-1,
8824,
8818,
8816,
8817,
8815,
8822,
8807,
8820,
8804,
8806,
8805,
8813,
8812,
8811,
8800,
8821,
8810,
8801,
8809,
8808,
8802,
8803,
8825,
8823,
8814,
8829,
8826,
8828,
-1,
-1,
8827,
-1,
7835,
7842,
7834,
7839,
7833,
7832,
7843,
7841,
7838,
7837,
7840,
]

_charnames_2208 = [
16509,
16512,
16635,
16631,
16529,
16633,
16626,
16605,
16595,
16596,
16553,
16618,
16556,
16628,
16610,
16579,
16636,
16578,
16632,
16537,
16569,
-1,
16510,
16634,
16630,
16549,
16594,
16541,
16539,
16540,
]

_charnames_2259 = [
16666,
16649,
16657,
16664,
16660,
16661,
16667,
16647,
16648,
16650,
16652,
16653,
16651,
16663,
16656,
16755,
16733,
16738,
16740,
16736,
16739,
16741,
16737,
16729,
16726,
16732,
16728,
16725,
16731,
16768,
16769,
16767,
16654,
16759,
16760,
16776,
16639,
16744,
16638,
16746,
16750,
16751,
16745,
16754,
16495,
23393,
-1,
-1,
-1,
23375,
]

_charnames_2382 = [
23406,
23405,
-1,
-1,
-1,
-1,
-1,
23407,
23399,
23398,
]

_charnames_2417 = [
23394,
23380,
23367,
23366,
23373,
23364,
23363,
23376,
23374,
23378,
23370,
23377,
23369,
23379,
23381,
15600,
]

_charnames_2555 = [
15602,
15595,
15601,
15598,
-1,
-1,
22871,
-1,
22869,
]

_charnames_2809 = [
22861,
22854,
22855,
22856,
22852,
22857,
22851,
]

_charnames_2929 = [
21217,
21206,
21207,
21211,
21205,
21208,
21210,
]

_charnames_3059 = [
4643,
4661,
4655,
4642,
4606,
4653,
4657,
4660,
-1,
-1,
-1,
-1,
-1,
5417,
-1,
-1,
-1,
5418,
]

_charnames_3191 = [
5420,
5414,
5412,
5406,
5409,
5413,
5407,
5410,
5419,
24123,
24128,
-1,
-1,
24124,
]

_charnames_3386 = [
9178,
9205,
9203,
9207,
-1,
-1,
-1,
-1,
-1,
-1,
9211,
]

_charnames_3406 = [
9180,
9206,
-1,
-1,
-1,
-1,
9176,
9174,
9171,
-1,
9192,
9188,
9199,
9185,
9186,
9196,
9189,
9181,
-1,
-1,
9209,
9210,
]

_charnames_3440 = [
9216,
9215,
9214,
9191,
9193,
9198,
9190,
9194,
9197,
9217,
9173,
9172,
9175,
9169,
9170,
9177,
]

_charnames_3558 = [
6763,
6764,
6755,
6756,
6761,
6762,
6758,
6759,
6766,
6765,
]

_charnames_3718 = [
11789,
-1,
-1,
11790,
-1,
-1,
11788,
-1,
11785,
11783,
11782,
11779,
11778,
11786,
-1,
-1,
-1,
-1,
11780,
]

_charnames_4046 = [
5265,
-1,
5251,
5255,
5254,
5257,
5258,
24805,
11939,
24806,
11940,
5256,
5253,
]

_charnames_4130 = [
9930,
-1,
-1,
-1,
-1,
-1,
9989,
-1,
-1,
10075,
]

_charnames_4147 = [
10072,
10071,
10077,
-1,
-1,
-1,
-1,
10032,
10099,
10101,
10100,
10102,
9998,
]

_charnames_4186 = [
9987,
9988,
9986,
9985,
10104,
10105,
10106,
9934,
10062,
10095,
10094,
9995,
9996,
10069,
10068,
10023,
10022,
10021,
10020,
10019,
9992,
9991,
9993,
10076,
10065,
10064,
10066,
9913,
9912,
9916,
9919,
9923,
9908,
9929,
9910,
9925,
9928,
9922,
9924,
9927,
10107,
10061,
10058,
10059,
10060,
10011,
10010,
10009,
10008,
10015,
10014,
10016,
9997,
10030,
10043,
10044,
10035,
10036,
10041,
10042,
10038,
10039,
10046,
10045,
10029,
10028,
10073,
10074,
10053,
10054,
]

_charnames_4295 = [
22620,
-1,
-1,
-1,
-1,
-1,
22621,
]

_charnames_4345 = [
22616,
22613,
-1,
9515,
22614,
22618,
22617,
]

_charnames_4992 = [
13442,
13523,
13522,
13521,
13444,
13459,
13458,
13457,
13443,
13528,
13527,
13526,
13441,
13516,
13515,
13514,
13547,
13541,
13549,
13548,
13543,
13546,
13551,
13550,
13542,
13545,
]

_charnames_5109 = [
2514,
-1,
-1,
2470,
2469,
2468,
2467,
2466,
2487,
-1,
-1,
2647,
]

_charnames_5751 = [
2563,
2559,
2560,
2557,
2558,
2561,
2562,
2564,
2632,
]

_charnames_5873 = [
24896,
24894,
24895,
24891,
24892,
24893,
24890,
24889,
]

_charnames_6128 = [
23600,
23601,
23596,
23599,
23598,
23589,
23595,
23594,
23593,
23592,
]

_charnames_6314 = [
9639,
-1,
-1,
-1,
-1,
-1,
2553,
2643,
2644,
2570,
2626,
2627,
2625,
2595,
2638,
2637,
2645,
2612,
2613,
2646,
2583,
2572,
2581,
2582,
2580,
2634,
2635,
2604,
2610,
2544,
2611,
2545,
2608,
2542,
2609,
2543,
2602,
2600,
2601,
2598,
2599,
2603,
2549,
2548,
2551,
2552,
2550,
2540,
2546,
2547,
2648,
2569,
2640,
2641,
2605,
2567,
2568,
2593,
2594,
2586,
2587,
2588,
2590,
2591,
2575,
2576,
2578,
2617,
2622,
2619,
2618,
2577,
2623,
2631,
2630,
2621,
]

_charnames_6400 = [
10996,
10946,
10945,
10935,
10934,
10942,
10955,
10954,
10949,
10948,
10937,
10927,
10926,
10952,
10951,
10943,
10940,
10939,
10958,
10957,
10961,
10936,
10960,
10962,
10959,
10930,
10929,
10931,
10963,
10933,
10925,
-1,
10987,
10995,
10994,
10993,
10989,
10991,
10988,
10992,
10990,
10982,
10984,
10983,
-1,
-1,
-1,
-1,
10974,
10967,
10975,
10969,
10968,
10971,
10972,
10970,
10973,
10978,
10980,
10977,
-1,
-1,
-1,
-1,
10979,
-1,
-1,
-1,
11012,
11011,
11007,
11008,
10999,
11000,
11005,
11006,
11002,
11003,
11010,
11009,
4957,
4959,
4953,
4936,
4961,
4958,
4938,
4937,
4964,
4949,
4948,
4963,
4967,
4960,
4966,
4962,
4956,
4935,
4954,
4942,
4965,
4941,
4940,
4945,
4951,
4950,
4946,
4939,
4943,
4944,
-1,
-1,
4933,
4932,
4931,
4930,
4929,
]

_charnames_6528 = [
17965,
17936,
17962,
17950,
17958,
17933,
17921,
17929,
17945,
17953,
17963,
17916,
17924,
17934,
17947,
17946,
17959,
17918,
17917,
17930,
17956,
17955,
17966,
17927,
17926,
17937,
17969,
17964,
17967,
17940,
17935,
17938,
17968,
17970,
17971,
17939,
17941,
17942,
17961,
17949,
17932,
17920,
17952,
17923,
-1,
-1,
-1,
-1,
17998,
17991,
17997,
17981,
17985,
17999,
17994,
17986,
17987,
17982,
17993,
17992,
17984,
17989,
17988,
17983,
17996,
17975,
17974,
17973,
17976,
17977,
17978,
17979,
18017,
18016,
-1,
-1,
-1,
-1,
-1,
-1,
18010,
18011,
18002,
18003,
18008,
18009,
18005,
18006,
18013,
18012,
18018,
-1,
-1,
-1,
18019,
18020,
23564,
23611,
23563,
23608,
23605,
23560,
23557,
23554,
23551,
23548,
23586,
23583,
23573,
23580,
23577,
23570,
23612,
23610,
23562,
23607,
23604,
23559,
23556,
23553,
23550,
23547,
23585,
23582,
23572,
23579,
23576,
23569,
15514,
15517,
15501,
15500,
15512,
15520,
15506,
15505,
15509,
15518,
15503,
15502,
15519,
15515,
15498,
15497,
15507,
15511,
15513,
15508,
15510,
15521,
15516,
15525,
15523,
15526,
15524,
15527,
-1,
-1,
15528,
15529,
4698,
4697,
4696,
4671,
4669,
4670,
4719,
4707,
4706,
4680,
4682,
4679,
4718,
4714,
4709,
4730,
4683,
4715,
4701,
4700,
4674,
4673,
4720,
4731,
4704,
4703,
4711,
4677,
4685,
4676,
4727,
4681,
4708,
4713,
4716,
4686,
4688,
4725,
4693,
4692,
4694,
4710,
4689,
4732,
4684,
4723,
4724,
4721,
4722,
4729,
4726,
4687,
4728,
4821,
4822,
4826,
4751,
4829,
4825,
4828,
4823,
4830,
4827,
-1,
4748,
4778,
4787,
4781,
4784,
4785,
4786,
4777,
4776,
4774,
4775,
4768,
4770,
4772,
4788,
4780,
4773,
4779,
4783,
4771,
4750,
4758,
4757,
4739,
4738,
4737,
4761,
4753,
4740,
-1,
-1,
4831,
4813,
4814,
4805,
4806,
4811,
4812,
4808,
4809,
4816,
4815,
-1,
-1,
-1,
-1,
-1,
-1,
4799,
4800,
4791,
4792,
4797,
4798,
4794,
4795,
4802,
4801,
-1,
-1,
-1,
-1,
-1,
-1,
4754,
4755,
4747,
4743,
4763,
4765,
4760,
4752,
4741,
4742,
4745,
4746,
4764,
4766,
-1,
-1,
1836,
1845,
1917,
1844,
1894,
1907,
1910,
1866,
1833,
1795,
1897,
1902,
1832,
1901,
1900,
]

_charnames_6912 = [
14819,
14820,
14823,
14821,
14824,
14705,
14706,
14727,
14728,
14719,
14720,
14714,
14715,
14717,
14718,
14732,
14708,
14723,
14724,
14694,
14696,
14729,
14730,
14692,
14734,
14735,
14725,
14726,
14691,
14686,
14685,
14702,
14701,
14690,
14682,
14684,
14698,
14703,
14689,
14721,
14722,
14736,
14737,
14742,
14739,
14713,
14716,
14740,
14712,
14711,
14709,
14743,
14822,
14792,
14793,
14794,
14795,
14796,
14797,
14798,
14801,
14802,
14787,
14789,
14791,
14790,
14799,
14800,
14836,
14695,
14697,
14687,
14733,
14741,
14738,
14707,
-1,
-1,
-1,
-1,
14813,
14814,
14805,
14806,
14811,
14812,
14808,
14809,
14816,
14815,
14829,
14828,
14835,
14833,
14834,
14832,
14827,
14757,
14755,
14756,
14747,
14749,
14758,
14752,
14754,
14751,
14750,
14765,
14768,
14761,
14763,
14766,
14762,
14764,
14769,
14767,
14780,
14781,
14783,
14784,
14774,
14772,
14777,
14776,
14773,
-1,
-1,
-1,
7736,
7735,
7734,
7679,
7693,
7686,
7680,
7690,
7674,
7675,
7673,
7688,
7695,
7655,
7697,
7692,
7681,
7654,
7687,
7696,
7656,
7689,
7661,
7685,
7678,
7691,
7682,
7667,
7670,
7684,
7664,
7683,
7694,
7746,
7745,
7744,
7726,
7724,
7728,
7725,
7729,
7727,
7737,
7738,
7742,
7741,
7672,
7663,
7708,
7709,
7700,
7701,
7706,
7707,
7703,
7704,
7711,
7710,
7747,
7666,
7669,
7677,
7660,
7659,
14899,
14868,
14894,
14866,
14882,
14898,
14891,
14884,
14863,
14876,
14881,
14887,
14860,
14885,
14895,
14867,
14892,
14896,
14889,
14862,
14878,
14864,
14869,
14873,
14870,
14861,
14880,
14886,
14859,
14874,
14890,
14865,
14872,
14897,
14875,
14883,
14893,
14888,
14918,
14906,
14908,
14907,
14910,
14905,
14909,
14904,
14901,
14902,
14923,
14924,
14921,
14920,
]

_charnames_7164 = [
14916,
14914,
14917,
14915,
11968,
11966,
11967,
11984,
11983,
11963,
11990,
11989,
11999,
11962,
11956,
11955,
11972,
11964,
11960,
11958,
11959,
11987,
11986,
11993,
11992,
11978,
11977,
11954,
11953,
11970,
11994,
11997,
11998,
11981,
11980,
11996,
11975,
11974,
11995,
12000,
12042,
12043,
12032,
12030,
12028,
12029,
12026,
12027,
12031,
12018,
12023,
12024,
12016,
12022,
12021,
12020,
12017,
12019,
12045,
12046,
-1,
-1,
-1,
12037,
12038,
12039,
12036,
12035,
12011,
12012,
12003,
12004,
12009,
12010,
12006,
12007,
12014,
12013,
-1,
-1,
-1,
11951,
11950,
11971,
20958,
20959,
20950,
20951,
20956,
20957,
20953,
20954,
20961,
20960,
20922,
20917,
20920,
20918,
20919,
20923,
20915,
20916,
20914,
20913,
20926,
20939,
20942,
20941,
20940,
20924,
20932,
20931,
20930,
20929,
20927,
20945,
20947,
20946,
20944,
20925,
20935,
20937,
20934,
20936,
20969,
20971,
20968,
20970,
20966,
20972,
20964,
20965,
2844,
2902,
2897,
2890,
2816,
2822,
2817,
2815,
2907,
]

_charnames_7312 = [
22517,
22557,
22540,
22556,
22542,
22547,
22522,
22514,
22554,
22534,
22530,
22553,
22552,
22551,
22528,
22521,
22549,
22525,
22513,
22548,
22527,
22533,
22539,
22550,
22524,
22507,
22510,
22536,
22509,
22508,
22545,
22537,
22501,
22504,
22503,
22546,
22499,
22502,
22555,
22544,
22543,
22515,
22518,
-1,
-1,
22519,
22500,
22531,
7716,
7715,
7714,
7720,
7717,
7718,
7719,
7721,
]

_charnames_7376 = [
19450,
19454,
19455,
19425,
19422,
19435,
19434,
19432,
19452,
19433,
19442,
19438,
19449,
19444,
19437,
19439,
19447,
19456,
19415,
19411,
19418,
19413,
19419,
19412,
19414,
19407,
19406,
19403,
19404,
19424,
19428,
19426,
19420,
19405,
19409,
19421,
19453,
19427,
19423,
19408,
19446,
19443,
19429,
-1,
-1,
-1,
-1,
-1,
11710,
11711,
11134,
11726,
11725,
11724,
11709,
11707,
11122,
11126,
11722,
11721,
11720,
11719,
11701,
11704,
11706,
11151,
11152,
11153,
11116,
11705,
11147,
11342,
11718,
11700,
11695,
11693,
11715,
11154,
11156,
11155,
11714,
11713,
11712,
11708,
11728,
11729,
22342,
22341,
22338,
22339,
22337,
2994,
9416,
9417,
9414,
9415,
9431,
9430,
9409,
9429,
9412,
9428,
9427,
9426,
9425,
9424,
9423,
9408,
9410,
9411,
9422,
9406,
9421,
9420,
9418,
9378,
9315,
9379,
9317,
9359,
9375,
9343,
9356,
9370,
9321,
9371,
9322,
9394,
9388,
9347,
9367,
9369,
9324,
9360,
9383,
9313,
9348,
9357,
9318,
9381,
9380,
9361,
9374,
9377,
9373,
9334,
11489,
11481,
11479,
11478,
22315,
22313,
22311,
22312,
22314,
11250,
11339,
11347,
11466,
11398,
11390,
11420,
11278,
11279,
11171,
11141,
11450,
11133,
9446,
11210,
11139,
11473,
11228,
11416,
11472,
11246,
11338,
11346,
11465,
11411,
11428,
11317,
11397,
11388,
11419,
11276,
11169,
11197,
11361,
11446,
11449,
11258,
11267,
11348,
11192,
11298,
11286,
11163,
11224,
11294,
11196,
11243,
11201,
9316,
9327,
9335,
9345,
9393,
9397,
9376,
9355,
9323,
9392,
9391,
9329,
9330,
9395,
9338,
9339,
9333,
9389,
9319,
9387,
9386,
9332,
9362,
9384,
9358,
9346,
9326,
9351,
9352,
9331,
9382,
9320,
9363,
9365,
9366,
9344,
9325,
1839,
1840,
1898,
1896,
1877,
1663,
1875,
1883,
1664,
1884,
1757,
1919,
1876,
1835,
1867,
1904,
1916,
1888,
1887,
1762,
1745,
1743,
1742,
1775,
1773,
1764,
1774,
1781,
1772,
1747,
1780,
1779,
1771,
1778,
1777,
1756,
1753,
1748,
1768,
1744,
1766,
1767,
1754,
1761,
1749,
1759,
1770,
1765,
1751,
1769,
1746,
1760,
1752,
1889,
1913,
1914,
1843,
1911,
-1,
1823,
1834,
1885,
1787,
1853,
]

_charnames_8275 = [
8040,
25184,
25381,
5459,
-1,
25358,
25351,
5585,
25359,
23177,
5561,
19485,
-1,
-1,
-1,
-1,
-1,
25187,
-1,
11943,
24809,
25335,
22104,
]

_charnames_8336 = [
11492,
11491,
11483,
11477,
11476,
11490,
11487,
11486,
11485,
11484,
11482,
11475,
11480,
]

_charnames_8370 = [
22878,
17321,
20431,
3383,
11105,
7918,
5439,
25101,
5547,
18502,
8843,
24908,
11772,
15633,
]

_charnames_8524 = [
22060,
17347,
5530,
7858,
19492,
19493,
19491,
]

_charnames_8580 = [
11284,
24923,
24922,
24921,
24924,
19494,
5534,
5535,
]

_charnames_9167 = [
13739,
19484,
8716,
8713,
8714,
8712,
8707,
8708,
8709,
8710,
8715,
13697,
25415,
5513,
15546,
5515,
15549,
5511,
15544,
24468,
15606,
7886,
25386,
17339,
13647,
23438,
15295,
15306,
15333,
15281,
15296,
15307,
15297,
16962,
7901,
5280,
20375,
15247,
15259,
15254,
15251,
23159,
15264,
15243,
22077,
22080,
22081,
22078,
21280,
]

_charnames_9866 = [
9651,
9650,
23476,
23469,
23470,
23475,
24479,
15349,
20344,
16302,
3358,
7879,
8017,
16958,
25379,
22622,
7878,
17341,
25396,
21267,
5455,
5456,
24282,
20411,
23167,
23166,
25206,
9222,
9220,
9221,
19483,
20365,
8585,
8594,
8576,
9164,
23494,
25675,
2193,
25416,
18141,
3381,
21636,
25559,
19487,
2527,
15261,
7995,
8000,
25819,
7997,
7029,
14976,
7587,
24444,
24445,
15286,
15287,
8021,
7752,
24979,
15274,
5484,
5543,
5541,
24442,
3365,
23489,
21243,
22123,
2718,
20053,
3339,
2411,
18507,
16959,
15321,
24469,
15311,
24452,
23512,
20014,
11936,
7581,
25312,
15322,
24694,
24693,
17325,
20009,
22062,
24811,
11945,
25185,
15242,
7255,
2533,
2807,
20414,
22624,
22625,
9301,
9663,
25680,
25363,
25389,
25420,
7470,
7646,
8033,
25262,
22043,
5437,
25556,
20041,
25417,
1581,
24480,
15276,
-1,
-1,
-1,
-1,
24460,
-1,
-1,
-1,
-1,
24976,
24968,
]

_charnames_10060 = [
3364,
-1,
18062,
-1,
-1,
-1,
-1,
15350,
24496,
24497,
-1,
19999,
]

_charnames_10175 = [
23163,
5460,
24467,
22057,
21230,
21229,
11919,
24785,
21224,
24687,
7757,
19486,
9286,
12141,
9297,
7570,
7569,
]

_charnames_11008 = [
18498,
18488,
7017,
7007,
11910,
11877,
25609,
23140,
18500,
18490,
7019,
7009,
11913,
25624,
24739,
24738,
11856,
11855,
7624,
7626,
7623,
7625,
23481,
23480,
23479,
23482,
23172,
15314,
24455,
15326,
24484,
15344,
24490,
24462,
15338,
20364,
15315,
15253,
24475,
15249,
24474,
15270,
15269,
24436,
15340,
24463,
15329,
24485,
11922,
5457,
11923,
12140,
11846,
11847,
11848,
11849,
11867,
11858,
11859,
11841,
11843,
11844,
11873,
24372,
13736,
24683,
11871,
24749,
24748,
11893,
24772,
24682,
24752,
5276,
11872,
11870,
24751,
23117,
7241,
7240,
24473,
15268,
24435,
15298,
24487,
19976,
20029,
20010,
20007,
20011,
7986,
14991,
7985,
14990,
15605,
7239,
11818,
25570,
24714,
23103,
11911,
25622,
18486,
18496,
7015,
7005,
11835,
25585,
24731,
23119,
3276,
16293,
11832,
25582,
24728,
23115,
-1,
-1,
18487,
18497,
7016,
7006,
11826,
25580,
24722,
23113,
20360,
19479,
11833,
25583,
24729,
23116,
11834,
25584,
24730,
23118,
11876,
25608,
24755,
23139,
16292,
16295,
16294,
16291,
24702,
24701,
18027,
18026,
25362,
24756,
-1,
-1,
5469,
5470,
5468,
5471,
15312,
15334,
15300,
15282,
23108,
23107,
25575,
25574,
11822,
24718,
11823,
24719,
15241,
15240,
15232,
15231,
15237,
15234,
15238,
15235,
24825,
24824,
24816,
24815,
24821,
24818,
24822,
24819,
25600,
25625,
21262,
21263,
21264,
14848,
3344,
3349,
15265,
15291,
5542,
20363,
15351,
15255,
15252,
15248,
15260,
18145,
5508,
15548,
11084,
24953,
24482,
24952,
7643,
25676,
22492,
21949,
21950,
21952,
21953,
5568,
22031,
17326,
20423,
21838,
18143,
24476,
15290,
5579,
1582,
20350,
25791,
24167,
17330,
17079,
19495,
22097,
11906,
24796,
7873,
7872,
11845,
25587,
24733,
23121,
13733,
13732,
8002,
24901,
24905,
24904,
24906,
24903,
24902,
13735,
25672,
7999,
23165,
21650,
24673,
20054,
22756,
22745,
22747,
22754,
22727,
22709,
22730,
22726,
22731,
22716,
22720,
22713,
22728,
22752,
22739,
22751,
22750,
22737,
22733,
22749,
22703,
22722,
22748,
22742,
22753,
22736,
22734,
22697,
22723,
22755,
22699,
22707,
22708,
22712,
22702,
22710,
22700,
22701,
22711,
22718,
22746,
22719,
22743,
22715,
22698,
22724,
22740,
-1,
22693,
22682,
22684,
22691,
22664,
22646,
22667,
22663,
22668,
22653,
22657,
22650,
22665,
22689,
22676,
22688,
22687,
22674,
22670,
22686,
22640,
22659,
22685,
22679,
22690,
22673,
22671,
22634,
22660,
22692,
22636,
22644,
22645,
22649,
22639,
22647,
22637,
22638,
22648,
22655,
22683,
22656,
22680,
22652,
22635,
22661,
22677,
-1,
11630,
11314,
11628,
11648,
11575,
11257,
11142,
11662,
11436,
11644,
11427,
11674,
11451,
11542,
11658,
11496,
11497,
11360,
11688,
11470,
11363,
11664,
11438,
11148,
11193,
11131,
11305,
11697,
11488,
9419,
11561,
11672,
2065,
1984,
2068,
1987,
2075,
1994,
2039,
1958,
2077,
1996,
2048,
1967,
2067,
1986,
2074,
1993,
2056,
1975,
2073,
1992,
2054,
1973,
2062,
1981,
2072,
1991,
2071,
1990,
2052,
1971,
2010,
1929,
2060,
1979,
2070,
1989,
2049,
1968,
2057,
1976,
2069,
1988,
2076,
1995,
2053,
1972,
2059,
1978,
2032,
1951,
2038,
1957,
2025,
1944,
2045,
1964,
2036,
1955,
2035,
1954,
2043,
1962,
2021,
1940,
2050,
1969,
2046,
1965,
2020,
1939,
2023,
1942,
2066,
1985,
2037,
1956,
2016,
1935,
2014,
1933,
2063,
1982,
2017,
1936,
2015,
1934,
2022,
1941,
2024,
1943,
2019,
1938,
2031,
1950,
2029,
1948,
2028,
1947,
2030,
1949,
2004,
2007,
2006,
2000,
2005,
2003,
2001,
2042,
1961,
2044,
1963,
2083,
2082,
2081,
2078,
1997,
-1,
-1,
-1,
-1,
-1,
2132,
2133,
2131,
2130,
2136,
2135,
2137,
22594,
22610,
22592,
22609,
22608,
22599,
22574,
22577,
22607,
22586,
22606,
22605,
22604,
22603,
22583,
22573,
22601,
22580,
22576,
22600,
22582,
22585,
22591,
22602,
22579,
22568,
22571,
22588,
22570,
22569,
22597,
22589,
22562,
22565,
22564,
22598,
22561,
22563,
-1,
22596,
-1,
-1,
-1,
-1,
-1,
22595,
-1,
-1,
5184,
5208,
5209,
5201,
5203,
5240,
5218,
5185,
5188,
5186,
5187,
5223,
5219,
5198,
5229,
5200,
5206,
5241,
5237,
5207,
5221,
5199,
5230,
5213,
5235,
5226,
5191,
5244,
5234,
5217,
5216,
5215,
5232,
5236,
5214,
5224,
5204,
5205,
5202,
5233,
5243,
5195,
5196,
5197,
5192,
5194,
5220,
5193,
5212,
5211,
5210,
5189,
5238,
5190,
5222,
5225,
]

_charnames_11647 = [
5247,
13535,
13524,
13534,
13445,
13446,
13460,
13470,
13394,
13531,
13530,
13412,
13481,
13430,
13422,
13536,
13471,
13395,
13518,
13517,
13408,
13410,
13407,
13406,
]

_charnames_11680 = [
13435,
13437,
13439,
13436,
13434,
13433,
13438,
-1,
13389,
13391,
13393,
13390,
13388,
13387,
13392,
-1,
13476,
13478,
13480,
13477,
13475,
13474,
13479,
-1,
13382,
13384,
13386,
13383,
13381,
13380,
13385,
-1,
13496,
13498,
13500,
13497,
13495,
13494,
13499,
-1,
13506,
13508,
13510,
13507,
13505,
13504,
13509,
-1,
13486,
13488,
13490,
13487,
13485,
13484,
13489,
-1,
13400,
13402,
13404,
13401,
13399,
13398,
13403,
-1,
1714,
1715,
1720,
1711,
1698,
1699,
1719,
1679,
1678,
1677,
1705,
1716,
1676,
1674,
1704,
1707,
1703,
1722,
1695,
1694,
1721,
1675,
1723,
1686,
1710,
1717,
1691,
1688,
1685,
1718,
1713,
1684,
24788,
24789,
11916,
24783,
11933,
24799,
24975,
24973,
23174,
11926,
24792,
24974,
11914,
24801,
13740,
21584,
25368,
24678,
20421,
23176,
23131,
25597,
23175,
23160,
25186,
21634,
20422,
5275,
11930,
24802,
5274,
5273,
11935,
24800,
5514,
5512,
15547,
15545,
11918,
24784,
11932,
24798,
5584,
21253,
7596,
25352,
24676,
19481,
24829,
24574,
5545,
24972,
24977,
5531,
23518,
23517,
5536,
5507,
5591,
5472,
7895,
19482,
24560,
2808,
23162,
24679,
23161,
23521,
23157,
25182,
25183,
12128,
12129,
23158,
23173,
5559,
8596,
21583,
22130,
2191,
]

_charnames_12728 = [
15567,
15565,
15562,
-1,
-1,
-1,
-1,
-1,
3218,
3221,
3220,
3225,
3208,
3192,
3199,
3200,
3197,
3207,
3198,
3195,
3201,
3196,
3193,
3223,
3190,
3204,
3214,
3212,
3224,
3191,
3203,
3205,
3209,
3211,
3213,
3217,
3215,
3219,
3206,
3210,
3202,
3194,
3216,
3222,
]

_charnames_12868 = [
3314,
3309,
3313,
3308,
3323,
3321,
3322,
3328,
3329,
3325,
3326,
3330,
21580,
]

_charnames_19904 = [
19859,
19870,
19884,
19946,
19939,
19927,
19865,
19948,
19900,
19876,
19918,
19902,
19945,
19893,
19942,
19949,
19944,
19938,
19934,
19926,
19931,
19896,
19903,
19912,
19906,
19895,
19941,
19894,
19866,
19860,
19908,
19885,
19913,
19892,
19917,
19886,
19875,
19922,
19923,
19880,
19881,
19909,
19930,
19928,
19897,
19916,
19921,
19868,
19914,
19861,
19864,
19872,
19879,
19871,
19936,
19869,
19874,
19873,
19883,
19947,
19907,
19901,
19935,
19932,
]

_charnames_42192 = [
11074,
11041,
11040,
11060,
11029,
11028,
11055,
11049,
11048,
11071,
11063,
11062,
11059,
11027,
11026,
11069,
11046,
11070,
11038,
11034,
11035,
11045,
11052,
11067,
11051,
11073,
11068,
11037,
11066,
11054,
11064,
11065,
11056,
11057,
11072,
11042,
11030,
11032,
11031,
11043,
11019,
11024,
11022,
11023,
11020,
11021,
11077,
11076,
18838,
18839,
18761,
18698,
18699,
18805,
18744,
18751,
18603,
18642,
18595,
18664,
18821,
18789,
18719,
18712,
18627,
18620,
18771,
18797,
18634,
18563,
18735,
18728,
18688,
18681,
18829,
18813,
18579,
18781,
18652,
18544,
18670,
18610,
18586,
18571,
18843,
18844,
18764,
18765,
18703,
18704,
18807,
18746,
18753,
18605,
18648,
18597,
18666,
18823,
18791,
18721,
18714,
18629,
18622,
18775,
18799,
18636,
18565,
18737,
18730,
18690,
18683,
18831,
18815,
18581,
18783,
18656,
18548,
18674,
18612,
18588,
18573,
18845,
18846,
18552,
18766,
18767,
18705,
18706,
18808,
18747,
18754,
18606,
18645,
18646,
18598,
18667,
18824,
18792,
18722,
18715,
18630,
18623,
18776,
18800,
18637,
18566,
18738,
18731,
18691,
18684,
18832,
18816,
18582,
18784,
18653,
18654,
18549,
18675,
18613,
18589,
18574,
18834,
18835,
18757,
18694,
18695,
18803,
18742,
18749,
18601,
18644,
18593,
18660,
18819,
18787,
18717,
18710,
18625,
18618,
18773,
18795,
18632,
18561,
18733,
18726,
18686,
18679,
18827,
18811,
18577,
18779,
18650,
18546,
18672,
18608,
18584,
18569,
18841,
18842,
18762,
18763,
18701,
18702,
18806,
18745,
18752,
18604,
18647,
18596,
18665,
18822,
18790,
18720,
18713,
18628,
18621,
18774,
18798,
18635,
18564,
18736,
18729,
18689,
18682,
18830,
18814,
18580,
18782,
18655,
18547,
18673,
18611,
18587,
18572,
18833,
18836,
18550,
18756,
18758,
18693,
18696,
18802,
18741,
18748,
18600,
18643,
18592,
18659,
18661,
18818,
18786,
18716,
18709,
18624,
18617,
18772,
18794,
18631,
18554,
18732,
18725,
18685,
18678,
18826,
18810,
18576,
18778,
18649,
18545,
18671,
18607,
18583,
18568,
18837,
18840,
18551,
18759,
18760,
18697,
18700,
18804,
18743,
18750,
18602,
18640,
18641,
18594,
18662,
18663,
18820,
18788,
18718,
18711,
18626,
18619,
18769,
18796,
18633,
18562,
18734,
18727,
18687,
18680,
18828,
18812,
18578,
18780,
18651,
18542,
18543,
18668,
18669,
18609,
18585,
18570,
18540,
18770,
18882,
18881,
18880,
18559,
18558,
18556,
18861,
18859,
18850,
18863,
18865,
18862,
18851,
18856,
18854,
18858,
18849,
18855,
18864,
18876,
18877,
18868,
18869,
18874,
18875,
18871,
18872,
18879,
18878,
18557,
18560,
]

_charnames_42560 = [
2980,
2888,
2917,
2831,
2945,
2843,
2960,
2868,
2922,
2836,
2982,
2899,
2975,
2883,
2990,
2896,
2963,
2871,
2957,
2865,
2943,
2841,
2959,
2867,
2972,
2880,
2976,
2884,
2958,
2866,
2962,
2870,
2944,
2842,
2936,
2851,
2935,
2850,
2934,
2849,
2983,
2900,
2977,
2885,
2920,
2834,
2995,
1733,
1729,
1735,
1728,
7987,
1701,
1681,
1689,
1700,
1708,
1690,
1696,
1706,
1734,
1732,
2997,
2996,
2921,
2835,
2916,
2830,
2979,
2887,
2973,
2881,
2915,
2829,
2929,
2823,
2928,
2821,
2926,
2819,
2927,
2820,
2930,
2824,
2969,
2877,
2938,
2853,
2919,
2833,
2971,
2879,
9445,
9444,
1680,
1683,
14666,
14604,
14662,
14601,
14665,
14630,
14641,
14663,
14587,
14664,
14649,
14572,
14632,
14633,
14648,
14608,
14642,
14590,
14577,
14605,
14622,
14612,
14620,
14623,
14621,
14624,
14600,
14598,
14583,
14582,
14575,
14657,
14618,
14656,
14658,
14588,
14597,
14569,
14576,
14586,
14566,
14660,
14570,
14653,
14634,
14645,
14614,
14589,
14628,
14635,
14599,
14579,
14580,
14581,
14619,
14567,
14651,
14652,
14661,
14591,
14647,
14571,
14646,
14593,
14610,
14629,
14607,
14615,
14643,
14603,
14613,
14611,
14638,
14602,
14639,
14585,
14625,
14654,
14594,
14595,
14671,
14670,
14676,
14677,
14673,
14672,
14674,
14675,
]

_charnames_42752 = [
9437,
9442,
9434,
9439,
9436,
9441,
9435,
9440,
9477,
9503,
9492,
9456,
9471,
9478,
9504,
9493,
9457,
9472,
9479,
9505,
9494,
9453,
9473,
9507,
9508,
9509,
9466,
9496,
9499,
9498,
9497,
9464,
9400,
9399,
11526,
11199,
11527,
11200,
11663,
11437,
11506,
11144,
11507,
11146,
11619,
11380,
11620,
11381,
11723,
11716,
11543,
11269,
11540,
11265,
11539,
11264,
11536,
11261,
11537,
11262,
11538,
11263,
11581,
11285,
11640,
11423,
11643,
11426,
11641,
11424,
11669,
11341,
11629,
11320,
11611,
11307,
11610,
11306,
11612,
11308,
11649,
11417,
11651,
11421,
11650,
11418,
11683,
11454,
11684,
11456,
11578,
11282,
11582,
11288,
11591,
11362,
11588,
11368,
11589,
11369,
11504,
11137,
11505,
11138,
11590,
11370,
11528,
11202,
11557,
11229,
11621,
11382,
9513,
11355,
11325,
11403,
11392,
11287,
11702,
11135,
11248,
11551,
11212,
11550,
11211,
11549,
11502,
11127,
11500,
11132,
11548,
11209,
11547,
11208,
11546,
11207,
9465,
9447,
9402,
11569,
11173,
11503,
11316,
11727,
11687,
11391,
11618,
11379,
11378,
11435,
11668,
11340,
11689,
11464,
11587,
11367,
11586,
11366,
11585,
11365,
11638,
11412,
11645,
11429,
11686,
11389,
11577,
11277,
11562,
11170,
11661,
11580,
11568,
11625,
11566,
11717,
11501,
11499,
11678,
11622,
11670,
11343,
11613,
11309,
11601,
11238,
11636,
11409,
11635,
11408,
11633,
11406,
-1,
-1,
11541,
11266,
11617,
11563,
11673,
]

_charnames_42999 = [
11737,
9413,
9342,
11696,
11733,
11732,
11735,
11736,
11738,
7810,
7807,
7824,
7801,
7809,
7803,
7823,
7787,
7788,
7793,
7794,
7825,
7796,
7797,
7790,
7791,
7770,
7771,
7776,
7777,
7772,
7773,
7778,
7779,
7804,
7784,
7785,
7799,
7800,
7805,
7782,
7806,
7781,
7802,
7808,
7816,
7814,
7812,
7815,
7813,
7821,
7820,
7819,
7818,
-1,
-1,
-1,
-1,
18470,
18471,
18475,
18469,
18472,
18474,
18477,
18480,
18479,
18478,
-1,
-1,
-1,
-1,
-1,
-1,
21704,
21703,
21707,
21676,
21687,
21689,
21719,
21674,
21672,
21671,
21685,
21677,
21701,
21700,
21723,
21717,
21670,
21669,
21683,
21712,
21694,
21695,
21679,
21710,
21714,
21718,
21680,
21681,
21721,
21690,
21720,
21713,
21708,
21716,
21715,
21711,
21722,
21706,
21709,
21728,
21727,
21667,
21666,
21684,
21675,
21692,
21697,
21698,
21691,
21729,
21730,
21688,
21731,
21735,
21733,
21734,
]

_charnames_43136 = [
7371,
7368,
7290,
7293,
7314,
7315,
7298,
7299,
7268,
7269,
7270,
7271,
7319,
7320,
7292,
7303,
7304,
7291,
7310,
7309,
7318,
7317,
7282,
7323,
7322,
7313,
7312,
7280,
7276,
7275,
7287,
7286,
7281,
7278,
7277,
7289,
7288,
7283,
7302,
7301,
7326,
7325,
7329,
7327,
7328,
7307,
7272,
7296,
7295,
7297,
7330,
7306,
7372,
7340,
7345,
7346,
7341,
7342,
7333,
7334,
7335,
7336,
7347,
7348,
7339,
7343,
7344,
7338,
7369,
7370,
]

_charnames_43214 = [
7365,
7364,
7360,
7361,
7352,
7353,
7358,
7359,
7355,
7356,
7363,
7362,
-1,
-1,
-1,
-1,
-1,
-1,
1810,
1811,
1802,
1803,
1808,
1809,
1805,
1806,
1813,
1812,
1821,
1816,
1820,
1819,
1818,
1817,
1815,
1822,
23390,
23387,
23395,
23385,
23386,
23388,
23392,
23410,
23411,
23409,
23391,
23408,
23372,
23404,
24081,
24082,
24073,
24074,
24079,
24080,
24076,
24077,
24084,
24083,
24054,
24053,
24066,
24038,
24045,
24044,
24058,
24037,
24042,
24056,
24039,
24048,
24047,
24063,
24067,
24069,
24062,
24059,
24064,
24060,
24041,
24057,
24061,
24068,
24070,
24051,
24065,
24050,
24087,
24088,
24086,
24089,
24090,
24094,
24092,
24093,
24097,
24096,
24613,
24616,
24600,
24608,
24617,
24602,
24611,
24619,
24605,
24618,
24614,
24597,
24609,
24610,
24612,
24606,
24607,
24615,
24604,
24599,
24601,
24596,
24620,
24631,
24629,
24623,
24628,
24630,
24627,
24624,
24625,
24635,
24634,
24636,
24637,
24632,
]

_charnames_43359 = [
24638,
20205,
20204,
20202,
20206,
20194,
20191,
20197,
20189,
20199,
20198,
20190,
20196,
20192,
20200,
20195,
20225,
20223,
20224,
20214,
20215,
20216,
20210,
20227,
20228,
20211,
20209,
20217,
20230,
20208,
-1,
-1,
-1,
25541,
25538,
25542,
25540,
25479,
25468,
25466,
25467,
25483,
25461,
25438,
25439,
25488,
25480,
25484,
25462,
25464,
25465,
25473,
25474,
25437,
25475,
25476,
25471,
25441,
25472,
25440,
25445,
25446,
25450,
25451,
25443,
25447,
25448,
25452,
25453,
25442,
25458,
25460,
25477,
25478,
25485,
25481,
25469,
25470,
25486,
25482,
25456,
25457,
25454,
25487,
25539,
25528,
25530,
25531,
25532,
25533,
25534,
25529,
25536,
25535,
25545,
25544,
25546,
25510,
25489,
25548,
25500,
25506,
25495,
25504,
25503,
25496,
25494,
25498,
25499,
25502,
25547,
-1,
25509,
25521,
25522,
25513,
25514,
25519,
25520,
25516,
25517,
25524,
25523,
-1,
-1,
-1,
-1,
25505,
25507,
9915,
9918,
9926,
9909,
9921,
10017,
10109,
9970,
9982,
9977,
9976,
9974,
9973,
9966,
9965,
9971,
10089,
10090,
10081,
10082,
10087,
10088,
10084,
10085,
10092,
10091,
9981,
9968,
9967,
9980,
9979,
-1,
2254,
2262,
2258,
2264,
2255,
2260,
2244,
2243,
2250,
2249,
2217,
2218,
2253,
2252,
2247,
2246,
2213,
2215,
2214,
2235,
2234,
2228,
2226,
2219,
2220,
2227,
2224,
2222,
2223,
2232,
2230,
2240,
2241,
2231,
2256,
2259,
2261,
2257,
2237,
2238,
2263,
2269,
2274,
2275,
2276,
2270,
2273,
2272,
2268,
2267,
2271,
2296,
2298,
2299,
2297,
]

_charnames_43584 = [
2208,
2209,
2201,
2293,
2210,
2203,
2200,
2206,
2202,
2205,
2207,
2204,
2294,
2295,
-1,
-1,
2287,
2288,
2279,
2280,
2285,
2286,
2282,
2283,
2290,
2289,
-1,
-1,
2305,
2303,
2302,
2304,
9960,
9955,
9954,
9949,
9948,
9945,
9943,
9942,
9939,
9938,
9940,
9946,
9958,
9952,
9951,
9961,
10110,
9957,
9956,
9959,
10002,
10001,
10003,
10051,
10050,
10049,
9999,
10031,
10026,
10025,
9933,
9932,
4843,
4874,
4841,
4872,
4842,
4873,
4861,
4892,
4838,
4869,
4851,
4882,
4852,
4883,
4855,
4886,
4836,
4867,
4863,
4894,
4845,
4876,
4846,
4877,
4837,
4868,
4864,
4895,
4848,
4879,
4849,
4880,
4862,
4893,
4858,
4889,
4853,
4884,
4856,
4887,
4859,
4890,
4854,
4885,
4860,
4891,
4857,
4888,
4925,
4902,
4907,
4904,
4903,
4910,
4909,
4924,
4908,
4905,
4906,
4899,
4898,
4900,
4901,
4922,
4921,
4919,
4920,
]

_charnames_43739 = [
4913,
4916,
4915,
4917,
4914,
8656,
8654,
8646,
8605,
8610,
8609,
8617,
8616,
8606,
8622,
8621,
8672,
8668,
8664,
8665,
8663,
8700,
8697,
8696,
8702,
8701,
8674,
8679,
]

_charnames_43777 = [
13465,
13467,
13468,
13464,
13463,
13466,
-1,
-1,
13418,
13420,
13421,
13417,
13416,
13419,
-1,
-1,
13426,
13428,
13429,
13425,
13424,
13427,
]

_charnames_43808 = [
13375,
13377,
13379,
13376,
13374,
13373,
13378,
-1,
13451,
13453,
13455,
13452,
13450,
13449,
13454,
-1,
11335,
11260,
11331,
11334,
11194,
11326,
11161,
11319,
11313,
11318,
11399,
11387,
11203,
11329,
11330,
11293,
11214,
11118,
11119,
11120,
11121,
11175,
11703,
11281,
11351,
11280,
11352,
11159,
11160,
11336,
11239,
11245,
11249,
11130,
11244,
11372,
11374,
11375,
11445,
11441,
11444,
11443,
11461,
9516,
9396,
9341,
9340,
9350,
11174,
11227,
11297,
11247,
11215,
22340,
11354,
11145,
]

_charnames_43888 = [
2513,
2512,
2511,
2509,
2508,
2507,
2506,
2510,
2505,
2504,
2503,
2502,
2501,
2456,
2455,
2454,
2452,
2451,
2450,
2499,
2498,
2497,
2496,
2495,
2494,
2492,
2491,
2490,
2489,
2488,
2442,
2453,
2443,
2448,
2447,
2446,
2445,
2444,
2485,
2484,
2483,
2482,
2481,
2480,
2440,
2434,
2439,
2438,
2437,
2436,
2435,
2464,
2433,
2463,
2432,
2462,
2431,
2460,
2459,
2458,
2461,
2430,
2429,
2428,
2427,
2426,
2425,
2423,
2422,
2421,
2420,
2419,
2418,
2478,
2477,
2476,
2475,
2474,
2473,
2471,
8629,
8623,
8634,
8632,
8625,
8603,
8645,
8611,
8631,
8601,
8613,
8651,
8650,
8655,
8652,
8639,
8627,
8657,
8642,
8638,
8653,
8649,
8637,
8618,
8643,
8619,
8648,
8630,
8635,
8633,
8626,
8604,
8612,
8602,
8640,
8676,
8671,
8666,
8673,
8675,
8669,
8678,
8677,
8699,
8658,
8695,
-1,
-1,
8690,
8691,
8682,
8683,
8688,
8689,
8685,
8686,
8693,
8692,
]

_charnames_55216 = [
20170,
20171,
20158,
20159,
20160,
20183,
20184,
20163,
20162,
20176,
20174,
20173,
20175,
20151,
20150,
20148,
20147,
20154,
20153,
20152,
20155,
20180,
20179,
-1,
-1,
-1,
-1,
20139,
20140,
20065,
20066,
20117,
20111,
20112,
20114,
20115,
20116,
20107,
20109,
20071,
20108,
20105,
20106,
20102,
20103,
20125,
20136,
20134,
20074,
20135,
20137,
20090,
20092,
20093,
20072,
20091,
20088,
20089,
20082,
20083,
20069,
20068,
20081,
20078,
20079,
20080,
20084,
20098,
20099,
20131,
20132,
20143,
20142,
20075,
20096,
20095,
]

_charnames_64107 = [
3185,
3184,
3183,
-1,
-1,
3170,
3169,
3168,
3167,
3166,
3165,
3164,
3163,
3162,
3161,
3160,
3159,
3158,
3157,
3156,
3155,
3153,
3152,
3151,
3150,
3149,
3148,
3147,
3146,
3145,
3144,
3143,
3142,
3141,
3140,
3139,
3138,
3136,
3135,
3134,
3133,
3132,
3131,
3130,
3129,
3128,
3127,
3126,
3125,
3124,
3123,
3122,
3121,
3119,
3118,
3117,
3116,
3115,
3114,
3113,
3112,
3111,
3110,
3109,
3108,
3107,
3106,
3105,
3104,
3102,
3101,
3100,
3099,
3098,
3097,
3096,
3095,
3094,
3093,
3092,
3091,
3090,
3089,
3088,
3087,
3085,
3084,
3083,
3082,
3081,
3080,
3079,
3078,
3077,
3076,
3075,
3074,
3073,
3072,
3071,
3070,
3181,
3180,
3179,
3178,
3177,
3176,
3175,
3174,
3173,
3172,
]

_charnames_64434 = [
16688,
16687,
16678,
16677,
16684,
16683,
16682,
16681,
16695,
16694,
16689,
16676,
16675,
16696,
16692,
16691,
]

_charnames_65040 = [
22007,
22005,
22004,
22008,
22009,
22012,
22010,
22001,
21997,
22011,
]

_charnames_65060 = [
1872,
1870,
1736,
1794,
1793,
1893,
1892,
1873,
1871,
1737,
1727,
1726,
]

_charnames_65536 = [
10833,
10861,
10823,
10848,
10876,
10840,
10853,
10834,
10872,
10819,
10814,
10852,
-1,
10863,
10846,
10803,
10854,
10844,
10810,
10880,
10881,
10873,
10807,
10871,
10828,
10835,
10827,
10867,
10818,
10815,
10838,
10808,
10860,
10875,
10820,
10870,
10802,
10829,
10865,
-1,
10849,
10824,
10817,
10839,
10825,
10866,
10832,
10857,
10874,
10813,
10812,
10837,
10862,
10836,
10842,
10816,
10805,
10858,
10856,
-1,
10869,
10806,
-1,
10830,
10826,
10855,
10879,
10809,
10884,
10851,
10822,
10847,
10804,
10864,
10843,
10845,
10878,
10883,
-1,
-1,
10899,
10898,
10903,
10902,
10896,
10895,
10901,
10893,
10892,
10900,
10890,
10889,
10888,
10887,
]

_charnames_65664 = [
10677,
10676,
10675,
10662,
10661,
10660,
10674,
10673,
10671,
10670,
10668,
10667,
10665,
10664,
10727,
10726,
10725,
10724,
10723,
10911,
10910,
10731,
10730,
10729,
10908,
10907,
10721,
10720,
10719,
10718,
10717,
10707,
10706,
10705,
10704,
10703,
10912,
10702,
10701,
10700,
10688,
10687,
10686,
10685,
10684,
10683,
10682,
10681,
10680,
10679,
10698,
10697,
10696,
10695,
10694,
10693,
10692,
10691,
10690,
10715,
10714,
10713,
10712,
10711,
10710,
10709,
10734,
10733,
10764,
10763,
10761,
10760,
10759,
10758,
10757,
10756,
10754,
10753,
10752,
10751,
10750,
10749,
10913,
10748,
10747,
10745,
10744,
10743,
10742,
10741,
10740,
10739,
10738,
10737,
10798,
10788,
10787,
10786,
10785,
10784,
10783,
10782,
10781,
10780,
10779,
10777,
10776,
10775,
10774,
10773,
10772,
10771,
10770,
10769,
10768,
10795,
10794,
10793,
10792,
10791,
10790,
10796,
10797,
-1,
-1,
-1,
-1,
-1,
17235,
17236,
17242,
-1,
-1,
-1,
-1,
17222,
17167,
17174,
17197,
17204,
17183,
17189,
17216,
17210,
17180,
17171,
17178,
17201,
17208,
17184,
17190,
17217,
17211,
17225,
17170,
17177,
17200,
17207,
17188,
17194,
17221,
17215,
17224,
17169,
17176,
17199,
17206,
17187,
17193,
17220,
17214,
17181,
17172,
17179,
17202,
17209,
17185,
17191,
17218,
17212,
-1,
-1,
-1,
17233,
17230,
17232,
17231,
17229,
17241,
17240,
17239,
17238,
22173,
22169,
22174,
22146,
22157,
22152,
22149,
22160,
22151,
22178,
22162,
22167,
22154,
22171,
22150,
22156,
22179,
22163,
22168,
22155,
22172,
22177,
22161,
22180,
22211,
22189,
22209,
22213,
22187,
22217,
22214,
22200,
22204,
22205,
22208,
22221,
22188,
22186,
22202,
22203,
22210,
22197,
22192,
22185,
22215,
22201,
22196,
22218,
22220,
22191,
22195,
22222,
22219,
22355,
22356,
22346,
22349,
22367,
22352,
22372,
22359,
22347,
22350,
22364,
22365,
22362,
22370,
22343,
22358,
22368,
22224,
22225,
22371,
22351,
22366,
22357,
22317,
22266,
18527,
-1,
24915,
24929,
24917,
24914,
24927,
24918,
24928,
24930,
24916,
24926,
24932,
24931,
-1,
-1,
-1,
-1,
22316,
]

_charnames_66000 = [
21767,
21765,
21772,
21745,
21747,
21778,
21776,
21791,
21771,
21799,
21758,
21751,
21746,
21785,
21784,
21755,
21788,
21759,
21744,
21794,
21739,
21754,
21741,
21761,
21750,
21774,
21775,
21762,
21743,
21782,
21798,
21793,
21770,
21760,
21766,
21795,
21768,
21781,
21787,
21796,
21797,
21790,
21752,
21753,
21779,
21740,
]

_charnames_66176 = [
12070,
12066,
12068,
12069,
12084,
12085,
12082,
12074,
12072,
12059,
12081,
12064,
12078,
12080,
12062,
12060,
12063,
12061,
12075,
12079,
12065,
12077,
12076,
12057,
12058,
12071,
12067,
12083,
12073,
-1,
-1,
-1,
2703,
2689,
2698,
2683,
2661,
2686,
2684,
2704,
2706,
2708,
2671,
2707,
2699,
2680,
2668,
2669,
2665,
2702,
2659,
2677,
2705,
2676,
2682,
2688,
2670,
2692,
2696,
2662,
2690,
2691,
2679,
2660,
2694,
2695,
2666,
2667,
2678,
2693,
2701,
2681,
2664,
2687,
2672,
2675,
2674,
2673,
2685,
2697,
2663,
]

_charnames_66272 = [
2128,
2125,
2117,
2118,
2123,
2124,
2120,
2121,
2127,
2126,
2093,
2089,
2092,
2104,
2107,
2096,
2099,
2112,
2109,
2114,
2088,
2091,
2103,
2106,
2097,
2100,
2113,
2110,
]

_charnames_66384 = [
20670,
20669,
20667,
20645,
20657,
20647,
20644,
20648,
20643,
20638,
20665,
20664,
20663,
20662,
20650,
20661,
20660,
20637,
20654,
20659,
20668,
20635,
20636,
20632,
20627,
20655,
20656,
20658,
20666,
20653,
20651,
20626,
20628,
20630,
20639,
20631,
20629,
20640,
1865,
1864,
1861,
1863,
1862,
-1,
-1,
-1,
-1,
-1,
25655,
25667,
25650,
25644,
25653,
25646,
25658,
25642,
25647,
25639,
25657,
25645,
25635,
25665,
25664,
25652,
25663,
25641,
25632,
25656,
25662,
25633,
25661,
25660,
25638,
25649,
25637,
25666,
25659,
25634,
-1,
25668,
20564,
20610,
20607,
20598,
20597,
20604,
20603,
20586,
20613,
20601,
20600,
20571,
20569,
20559,
20563,
20562,
20570,
20608,
20581,
20612,
20595,
20594,
20579,
20578,
20577,
20606,
20589,
20588,
20592,
20591,
20609,
20575,
20605,
20574,
20573,
20611,
-1,
-1,
-1,
-1,
20565,
20567,
20566,
20585,
20560,
20561,
20582,
20583,
20622,
20620,
20617,
20619,
20618,
20621,
]

_charnames_66638 = [
23423,
23424,
7217,
7193,
7220,
7223,
7191,
7206,
7205,
7225,
7200,
7211,
7226,
7224,
7222,
7214,
7192,
7213,
7209,
7221,
7203,
7212,
7219,
7208,
7195,
7188,
7171,
7175,
7180,
7202,
7177,
7173,
7216,
7218,
7185,
7174,
7196,
7215,
7182,
7179,
7181,
7170,
7169,
7178,
7172,
7187,
7168,
7186,
7197,
7199,
21068,
21099,
21087,
21093,
21084,
21076,
21082,
21088,
21072,
21071,
21081,
21098,
21096,
21097,
21089,
21077,
21092,
21091,
21090,
21085,
21095,
21083,
21067,
21078,
21094,
21073,
21086,
21069,
21079,
21074,
-1,
-1,
21110,
21111,
21102,
21103,
21108,
21109,
21105,
21106,
21113,
21112,
-1,
-1,
-1,
-1,
-1,
-1,
21030,
21031,
21032,
21033,
21064,
21063,
21028,
21021,
21029,
21053,
21052,
21060,
21042,
21027,
21040,
21059,
21058,
21057,
21049,
21050,
21056,
21026,
21048,
21047,
21038,
21025,
21037,
21024,
21036,
21062,
21055,
21054,
21041,
21061,
21045,
21044,
-1,
-1,
-1,
-1,
20985,
20986,
20987,
20988,
21019,
21018,
20983,
20976,
20984,
21008,
21007,
21015,
20997,
20982,
20995,
21014,
21013,
21012,
21004,
21005,
21011,
20981,
21003,
21002,
20993,
20980,
20992,
20979,
20991,
21017,
21010,
21009,
20996,
21016,
21000,
20999,
-1,
-1,
-1,
-1,
13611,
13610,
13597,
13596,
13594,
13564,
13593,
13591,
13590,
13609,
13571,
13570,
13608,
13607,
13606,
13589,
13586,
13585,
13605,
13563,
13565,
13562,
13604,
13603,
13602,
13583,
13582,
13580,
13579,
13577,
13576,
13601,
13600,
13599,
13598,
13574,
13573,
13568,
13569,
13588,
]

_charnames_66864 = [
2784,
2793,
2777,
2744,
2781,
2749,
2780,
2747,
2753,
2723,
2759,
2748,
2756,
2735,
2769,
2757,
2785,
2743,
2732,
2774,
2772,
2768,
2791,
2762,
2783,
2725,
2726,
2728,
2790,
2763,
2789,
2741,
2736,
2775,
2788,
2751,
2792,
2742,
2724,
2766,
2778,
2787,
2738,
2786,
2752,
2737,
2755,
2729,
2731,
2760,
2765,
2771,
]

_charnames_67072 = [
10294,
10293,
10292,
10291,
10290,
10289,
10288,
10287,
10286,
10338,
10337,
10336,
10335,
10334,
10274,
10264,
10266,
10265,
10261,
10263,
10262,
10267,
10268,
10273,
10272,
10271,
10270,
10653,
10269,
10332,
10331,
10330,
10329,
10328,
10327,
10303,
10302,
10301,
10300,
10299,
10298,
10297,
10296,
10284,
10283,
10282,
10281,
10280,
10279,
10278,
10277,
10276,
10325,
10324,
10323,
10322,
10321,
10320,
10311,
10310,
10309,
10308,
10307,
10306,
10305,
10318,
10317,
10316,
10315,
10314,
10313,
10652,
10353,
10343,
10651,
10342,
10341,
10349,
10348,
10650,
10352,
10351,
10346,
10345,
10350,
10472,
10471,
10470,
10469,
10468,
10467,
10466,
10465,
10464,
10463,
10462,
10459,
10458,
10457,
10450,
10449,
10448,
10456,
10455,
10454,
10453,
10452,
10451,
10527,
10526,
10525,
10524,
10523,
10522,
10521,
10520,
10519,
10518,
10516,
10515,
10514,
10513,
10512,
10511,
10510,
10509,
10508,
10507,
10505,
10504,
10503,
10502,
10501,
10500,
10499,
10498,
10497,
10496,
10494,
10493,
10492,
10491,
10490,
10489,
10488,
10487,
10486,
10485,
10483,
10482,
10481,
10480,
10479,
10478,
10477,
10476,
10475,
10474,
10530,
10529,
10629,
10628,
10627,
10626,
10625,
10624,
10623,
10622,
10621,
10620,
10639,
10638,
10637,
10636,
10635,
10634,
10633,
10632,
10631,
10415,
10414,
10413,
10412,
10411,
10410,
10409,
10408,
10444,
10443,
10442,
10441,
10440,
10439,
10406,
10405,
10404,
10403,
10402,
10401,
10400,
10399,
10398,
10396,
10395,
10394,
10393,
10392,
10391,
10390,
10389,
10388,
10423,
10422,
10421,
10420,
10419,
10418,
10417,
10386,
10385,
10384,
10383,
10382,
10381,
10380,
10379,
10378,
10437,
10436,
10435,
10434,
10433,
10432,
10376,
10375,
10374,
10373,
10372,
10371,
10370,
10369,
10368,
10367,
10365,
10364,
10363,
10362,
10361,
10360,
10359,
10358,
10357,
10356,
10430,
10429,
10428,
10427,
10426,
10425,
10580,
10579,
10578,
10577,
10576,
10575,
10574,
10573,
10542,
10541,
10540,
10539,
10538,
10537,
10536,
10535,
10534,
10533,
10562,
10561,
10560,
10559,
10558,
10557,
10556,
10555,
10554,
10590,
10589,
10588,
10571,
10570,
10569,
10568,
10567,
10566,
10565,
10564,
10552,
10551,
10550,
10549,
10548,
10547,
10546,
10545,
10544,
10586,
10585,
10584,
10583,
10582,
]

_charnames_67392 = [
10607,
10606,
10605,
10604,
10603,
10602,
10601,
10600,
10599,
10598,
10597,
10596,
10595,
10615,
10614,
10613,
10612,
10611,
10610,
10609,
10617,
10616,
]

_charnames_67424 = [
10648,
10647,
10646,
10645,
10644,
10643,
10642,
10641,
]

_charnames_67584 = [
3065,
3064,
3063,
3062,
3061,
3060,
-1,
-1,
3059,
-1,
3046,
3045,
3044,
3043,
3042,
3040,
3039,
3038,
3037,
3036,
3034,
3033,
3032,
3031,
3030,
3028,
3027,
3026,
3025,
3024,
3022,
3021,
3020,
3019,
3018,
3016,
3015,
3014,
3013,
3012,
3010,
3009,
3008,
3007,
3006,
3004,
3003,
3002,
3001,
3000,
3051,
3050,
3049,
3048,
-1,
3057,
3056,
-1,
-1,
-1,
3054,
-1,
-1,
3053,
25223,
25236,
25234,
25235,
25219,
25226,
25224,
25220,
25217,
25225,
25233,
25232,
25231,
25230,
25213,
25222,
25229,
25214,
25228,
25227,
25215,
25218,
-1,
25249,
25245,
25240,
25244,
25242,
25241,
25248,
25247,
25243,
21604,
21618,
21615,
21617,
21600,
21607,
21605,
21601,
21598,
21606,
21614,
21613,
21612,
21616,
21611,
21594,
21603,
21610,
21595,
21609,
21608,
21596,
21599,
21619,
21631,
21630,
21623,
21625,
21628,
21629,
21626,
21624,
18247,
18260,
18246,
18273,
18271,
18272,
18245,
18256,
18263,
18261,
18257,
18254,
18239,
18262,
18244,
18270,
18243,
18269,
18242,
18268,
18241,
18267,
18250,
18259,
18266,
18251,
18265,
18264,
18240,
18252,
18255,
]

_charnames_67751 = [
18281,
18277,
18279,
18284,
18286,
18285,
18280,
18278,
18282,
]

_charnames_67808 = [
20319,
20331,
20329,
20330,
20315,
20322,
20320,
20316,
20313,
20321,
20328,
20327,
20326,
20325,
20309,
20318,
20324,
20310,
20323,
-1,
20311,
20314,
-1,
-1,
-1,
-1,
-1,
20336,
20338,
20335,
20334,
20337,
21813,
21827,
21825,
21826,
21810,
21817,
21815,
21811,
21808,
21816,
21824,
21823,
21822,
21821,
21805,
21814,
21820,
21806,
21819,
21818,
21804,
21809,
21835,
21834,
21832,
21836,
21831,
21833,
-1,
-1,
-1,
21837,
12098,
12113,
12109,
12111,
12096,
12101,
12108,
12100,
12107,
12094,
12106,
12092,
12105,
12103,
12091,
12088,
12102,
12110,
12104,
12090,
12089,
12099,
12097,
12095,
12093,
12112,
-1,
-1,
-1,
-1,
-1,
12114,
]

_charnames_67968 = [
8456,
8454,
8452,
8449,
8445,
8446,
8443,
8444,
8448,
8450,
8432,
8433,
8430,
8431,
8438,
8439,
8451,
8441,
8453,
8435,
8436,
8437,
8442,
8447,
8426,
8427,
8424,
8425,
8428,
8455,
8457,
8458,
8385,
8397,
8395,
8392,
8387,
8388,
8399,
8391,
8393,
8381,
8380,
8389,
8394,
8383,
8396,
8378,
8386,
8377,
8384,
8390,
8375,
8374,
8373,
8398,
-1,
-1,
-1,
-1,
8418,
8413,
8401,
8402,
8365,
8304,
8312,
8338,
8346,
8322,
8329,
8359,
8353,
8319,
8309,
8317,
8343,
8351,
8327,
8334,
-1,
-1,
8367,
8306,
8314,
8340,
8348,
8324,
8331,
8361,
8355,
8369,
8308,
8316,
8342,
8350,
8326,
8333,
8363,
8357,
8320,
8310,
8318,
8344,
8352,
8328,
8335,
8364,
8358,
8368,
8307,
8315,
8341,
8349,
8325,
8332,
8362,
8356,
8412,
8405,
8406,
8415,
8416,
8409,
8410,
8419,
8420,
8407,
23814,
23835,
23833,
23832,
-1,
23836,
23834,
-1,
-1,
-1,
-1,
-1,
23837,
23841,
23846,
23843,
23791,
23790,
23800,
23799,
-1,
23803,
23802,
23812,
-1,
23785,
23771,
23770,
23777,
23776,
23786,
23773,
23772,
23779,
23778,
23787,
23797,
23796,
23806,
23805,
23810,
23808,
23809,
23811,
23794,
23782,
23781,
23783,
23807,
23813,
23789,
23768,
23769,
23793,
-1,
-1,
23845,
23844,
23842,
-1,
-1,
-1,
-1,
23838,
23858,
23856,
23857,
23859,
23850,
23849,
23853,
23852,
23860,
]

_charnames_68176 = [
23819,
23827,
23826,
23825,
23828,
23822,
23820,
23818,
23823,
]

_charnames_68192 = [
20828,
20843,
20829,
20842,
20840,
20838,
20819,
20839,
20845,
20813,
20816,
20827,
20841,
20826,
20818,
20817,
20844,
20835,
20834,
20823,
20831,
20824,
20832,
20812,
20836,
20822,
20837,
20811,
20810,
20848,
20849,
20850,
20870,
20888,
20871,
20887,
20885,
20882,
20861,
20884,
20890,
20857,
20862,
20868,
20886,
20867,
20883,
20860,
20889,
20879,
20880,
20877,
20874,
20876,
20873,
20858,
20864,
20856,
20881,
20855,
20865,
20895,
20894,
20893,
]

_charnames_68288 = [
8741,
8768,
8767,
8761,
8762,
8765,
8758,
8770,
8796,
8745,
8744,
8757,
8756,
8759,
8737,
8769,
8754,
8748,
8753,
8775,
8764,
8736,
8774,
8773,
8731,
8740,
8742,
8772,
8776,
8732,
8750,
8747,
8751,
8771,
8734,
8733,
8738,
8795,
8794,
-1,
-1,
-1,
-1,
8790,
8792,
8789,
8788,
8791,
8783,
8785,
8781,
8780,
8779,
8782,
8784,
]

_charnames_68352 = [
17247,
17248,
17253,
17249,
17254,
17250,
17251,
17252,
17296,
17297,
17289,
17290,
17291,
17292,
17287,
17288,
17309,
17272,
17270,
17271,
17280,
17279,
17278,
17312,
17310,
17276,
17275,
17300,
17299,
17274,
17306,
17311,
17303,
17302,
17259,
17257,
17258,
17262,
17260,
17261,
17307,
17294,
17285,
17286,
17304,
17305,
17308,
17268,
17283,
17266,
17282,
17265,
17267,
17295,
-1,
-1,
-1,
17313,
5279,
7963,
11762,
11748,
11761,
11747,
25118,
25131,
25129,
25130,
25114,
25121,
25119,
25115,
25112,
25120,
25128,
25127,
25126,
25125,
25108,
25117,
25124,
25109,
25123,
25122,
25110,
25113,
-1,
-1,
25139,
25135,
25137,
25143,
25138,
25136,
25142,
25141,
25167,
25166,
25164,
25165,
25154,
25158,
25156,
25155,
25152,
25157,
25163,
25162,
25161,
25160,
25148,
25159,
25149,
25150,
25153,
-1,
-1,
-1,
-1,
-1,
25175,
25171,
25173,
25179,
25174,
25172,
25178,
25177,
21976,
21975,
21973,
21974,
21962,
21966,
21964,
21963,
21965,
21972,
21971,
21970,
21969,
21959,
21968,
21960,
21961,
21967,
]

_charnames_68521 = [
21984,
21980,
21982,
21986,
21983,
21981,
21985,
]

_charnames_68608 = [
20673,
20719,
20720,
20714,
20750,
20738,
20708,
20709,
20747,
20695,
20737,
20684,
20727,
20693,
20735,
20682,
20726,
20694,
20736,
20683,
20702,
20743,
20687,
20728,
20675,
20723,
20681,
20725,
20710,
20748,
20692,
20734,
20680,
20706,
20705,
20691,
20679,
20721,
20699,
20741,
20701,
20742,
20698,
20740,
20733,
20700,
20722,
20704,
20713,
20716,
20707,
20745,
20690,
20732,
20715,
20751,
20712,
20749,
20689,
20731,
20678,
20685,
20677,
20686,
20730,
20703,
20744,
20688,
20729,
20676,
20724,
20711,
20717,
]

_charnames_68736 = [
20523,
20527,
20522,
20525,
20498,
20497,
20499,
20521,
20524,
20492,
20544,
20520,
20519,
20511,
20512,
20518,
20541,
20542,
20517,
20516,
20526,
20531,
20509,
20510,
20507,
20493,
20496,
20532,
20533,
20540,
20537,
20534,
20515,
20508,
20514,
20543,
20505,
20506,
20503,
20494,
20504,
20500,
20528,
20529,
20539,
20536,
20513,
20501,
20502,
20495,
20530,
]

_charnames_68800 = [
20469,
20473,
20468,
20471,
20444,
20443,
20445,
20467,
20470,
20438,
20490,
20466,
20465,
20457,
20458,
20464,
20487,
20488,
20463,
20462,
20472,
20477,
20455,
20456,
20453,
20439,
20442,
20478,
20479,
20486,
20483,
20480,
20461,
20454,
20460,
20489,
20451,
20452,
20449,
20440,
20450,
20446,
20474,
20475,
20485,
20482,
20459,
20447,
20448,
20441,
20476,
]

_charnames_68858 = [
20546,
20551,
20553,
20552,
20549,
20548,
20268,
20267,
20259,
20245,
20244,
20262,
20266,
20263,
20237,
20265,
20254,
20253,
20251,
20250,
20255,
20248,
20247,
20238,
20264,
20261,
20260,
20242,
20257,
20236,
20256,
20235,
20241,
20240,
20258,
20288,
20286,
20284,
20287,
20285,
20296,
20297,
20294,
20293,
20292,
20291,
]

_charnames_68912 = [
20279,
20280,
20271,
20272,
20277,
20278,
20274,
20275,
20282,
20281,
]

_charnames_69216 = [
24876,
24868,
24869,
24874,
24875,
24871,
24872,
24878,
24877,
24844,
24840,
24843,
24855,
24858,
24847,
24850,
24863,
24860,
24865,
24839,
24842,
24854,
24857,
24848,
24851,
24864,
24861,
24883,
24882,
24881,
24884,
]

_charnames_69376 = [
20774,
20765,
20789,
20764,
20788,
20776,
20763,
20780,
20778,
20777,
20779,
20787,
20786,
20785,
20784,
20761,
20762,
20768,
20775,
20773,
20783,
20769,
20759,
20760,
20782,
20770,
20781,
20757,
20758,
20800,
20794,
20797,
20803,
20804,
20799,
20795,
20798,
20801,
20805,
20790,
]

_charnames_69424 = [
6912,
6924,
6922,
6908,
6915,
6913,
6909,
6914,
6921,
6907,
6920,
6919,
6902,
6911,
6918,
6903,
6917,
6904,
6916,
6923,
6906,
6954,
6933,
6927,
6934,
6928,
6937,
6936,
6931,
6930,
6940,
6939,
6938,
6952,
6951,
6950,
6953,
6943,
6944,
6947,
6945,
6946,
]

_charnames_69600 = [
13626,
13639,
13637,
13638,
13622,
13629,
13627,
13623,
13620,
13628,
13636,
13635,
13634,
13633,
13616,
13625,
13632,
13617,
13631,
13630,
13618,
13621,
13640,
]

_charnames_69632 = [
15157,
15158,
15154,
15156,
15155,
15049,
15052,
15071,
15072,
15057,
15058,
15022,
15023,
15024,
15025,
15086,
15051,
15033,
15050,
15067,
15066,
15075,
15074,
15041,
15078,
15077,
15070,
15069,
15039,
15030,
15029,
15046,
15045,
15040,
15032,
15031,
15048,
15047,
15042,
15061,
15060,
15081,
15080,
15084,
15082,
15083,
15064,
15026,
15055,
15054,
15056,
15085,
15063,
15037,
15035,
15036,
15127,
15134,
15130,
15131,
15128,
15129,
15120,
15121,
15122,
15123,
15133,
15126,
15132,
15125,
15135,
15152,
15151,
15165,
15164,
15162,
15166,
15161,
-1,
-1,
-1,
-1,
15108,
15090,
15093,
15103,
15106,
15097,
15099,
15114,
15112,
15095,
15091,
15094,
15104,
15107,
15098,
15100,
15115,
15113,
15111,
15110,
15147,
15148,
15139,
15140,
15145,
15146,
15142,
15143,
15150,
15149,
]

_charnames_69759 = [
15116,
24022,
24023,
24019,
23965,
23968,
23987,
23988,
23973,
23974,
24004,
23967,
24000,
23966,
23983,
23982,
23991,
23990,
23963,
23994,
23993,
23986,
23985,
23961,
23957,
23956,
23951,
23950,
23949,
23976,
23962,
23959,
23958,
23953,
23952,
23964,
23980,
23979,
23997,
23996,
24001,
23998,
23977,
24002,
23999,
23971,
23970,
23972,
24003,
24009,
24012,
24013,
24010,
24011,
24015,
24008,
24014,
24007,
24020,
24021,
24033,
24032,
24030,
24024,
24027,
24029,
24028,
]

_charnames_69837 = [
24031,
-1,
-1,
6971,
6970,
6983,
6982,
6981,
6980,
6962,
6959,
6975,
6960,
6968,
6973,
6967,
6972,
6979,
6976,
6977,
6958,
6984,
6966,
6978,
6969,
6974,
6965,
6963,
]

_charnames_69872 = [
6995,
6996,
6987,
6988,
6993,
6994,
6990,
6991,
6998,
6997,
-1,
-1,
-1,
-1,
-1,
-1,
2393,
2394,
2392,
2357,
2354,
2350,
2356,
2336,
2335,
2342,
2341,
2317,
2345,
2344,
2339,
2338,
2315,
2311,
2310,
2322,
2321,
2316,
2313,
2312,
2324,
2323,
2318,
2330,
2329,
2348,
2347,
2353,
2326,
2327,
2352,
2333,
2349,
2351,
2355,
2360,
2368,
2369,
2364,
2365,
2370,
2362,
2366,
2361,
2367,
2397,
2399,
2372,
2398,
-1,
2384,
2385,
2376,
2377,
2382,
2383,
2379,
2380,
2387,
2386,
2395,
2389,
2388,
2396,
2332,
2363,
2371,
]

_charnames_69968 = [
8965,
8962,
8957,
8964,
8959,
8943,
8942,
8949,
8948,
8952,
8951,
8946,
8945,
8932,
8922,
8921,
8928,
8927,
8933,
8924,
8923,
8930,
8929,
8934,
8940,
8939,
8955,
8954,
8960,
8937,
8961,
8956,
8958,
8963,
8936,
8968,
8970,
8969,
8966,
]

_charnames_70016 = [
7131,
7126,
7122,
7062,
7065,
7084,
7085,
7070,
7071,
7040,
7041,
7042,
7043,
7100,
7064,
7097,
7063,
7080,
7079,
7088,
7087,
7054,
7091,
7090,
7083,
7082,
7052,
7048,
7047,
7059,
7058,
7053,
7050,
7049,
7061,
7060,
7055,
7074,
7073,
7094,
7093,
7098,
7095,
7096,
7077,
7076,
7044,
7068,
7067,
7069,
7099,
7111,
7114,
7115,
7112,
7113,
7104,
7105,
7106,
7107,
7117,
7110,
7116,
7109,
7123,
7125,
7130,
7127,
7159,
7155,
7154,
7162,
7136,
7138,
7129,
7118,
7157,
7137,
-1,
-1,
7150,
7151,
7142,
7143,
7148,
7149,
7145,
7146,
7153,
7152,
7158,
7128,
7160,
7161,
7135,
7134,
-1,
6750,
6742,
6743,
6748,
6749,
6745,
6746,
6752,
6751,
6728,
6726,
6727,
6736,
6737,
6730,
6731,
6739,
6738,
6734,
6733,
]

_charnames_70144 = [
23881,
23884,
23915,
23910,
23917,
23883,
23913,
23882,
23901,
23900,
23888,
23887,
23886,
23879,
23907,
23906,
23904,
23903,
-1,
23877,
23873,
23872,
23867,
23865,
23878,
23875,
23874,
23869,
23866,
23868,
23880,
23895,
23894,
23892,
23891,
23890,
23914,
23908,
23912,
23898,
23909,
23911,
23916,
23897,
23922,
23923,
23924,
23925,
23927,
23921,
23926,
23920,
23935,
23933,
23934,
23932,
23941,
23940,
23942,
23936,
23939,
23943,
23931,
]

_charnames_70272 = [
10163,
10160,
10156,
10162,
10141,
10140,
10147,
-1,
10146,
-1,
10150,
10149,
10144,
10143,
-1,
10133,
10125,
10124,
10119,
10118,
10117,
10134,
10127,
10126,
10121,
10120,
10135,
10138,
10137,
10153,
-1,
10152,
10158,
10154,
10131,
10159,
10155,
10157,
10161,
10129,
10130,
10164,
-1,
-1,
-1,
-1,
-1,
-1,
23692,
23695,
23722,
23723,
23708,
23709,
23733,
23694,
23729,
23693,
23721,
23720,
23703,
23702,
23701,
23690,
23726,
23725,
23699,
23697,
23698,
23688,
23684,
23683,
23678,
23677,
23714,
23676,
23689,
23686,
23685,
23680,
23679,
23691,
23718,
23717,
23707,
23706,
23705,
23730,
23727,
23715,
23731,
23728,
23711,
23712,
23732,
23762,
23752,
23755,
23756,
23753,
23754,
23758,
23751,
23757,
23750,
23761,
23760,
-1,
-1,
-1,
-1,
-1,
23744,
23745,
23736,
23737,
23742,
23743,
23739,
23740,
23747,
23746,
-1,
-1,
-1,
-1,
-1,
-1,
22468,
22469,
22472,
22465,
-1,
22408,
22411,
22430,
22431,
22416,
22417,
22383,
22385,
-1,
-1,
22446,
22410,
-1,
-1,
22443,
22409,
22426,
22425,
22434,
22433,
22400,
22437,
22436,
22429,
22428,
22398,
22394,
22393,
22405,
22404,
22399,
22396,
22395,
22407,
22406,
22401,
-1,
22420,
22419,
22440,
22439,
22444,
22441,
22442,
-1,
22423,
22422,
-1,
22390,
22414,
22413,
22415,
22445,
-1,
1920,
22474,
22471,
22456,
22459,
22460,
22457,
22458,
22449,
22450,
-1,
-1,
22462,
22455,
-1,
-1,
22461,
22454,
22466,
-1,
-1,
22475,
-1,
-1,
-1,
-1,
-1,
-1,
22476,
-1,
-1,
-1,
-1,
-1,
22473,
22389,
22388,
22384,
22386,
22451,
22452,
-1,
-1,
1653,
1655,
1648,
1649,
1651,
1652,
1654,
-1,
-1,
-1,
1661,
1660,
1659,
1657,
1658,
]

_charnames_70656 = [
17814,
17817,
17842,
17843,
17822,
17823,
17797,
17798,
17799,
17800,
17857,
17816,
17855,
17815,
17838,
17837,
17846,
17845,
17791,
17790,
17849,
17848,
17841,
17840,
17788,
17787,
17805,
17804,
17811,
17810,
17792,
17807,
17806,
17813,
17812,
17794,
17793,
17829,
17828,
17852,
17851,
17832,
17831,
17853,
17826,
17825,
17835,
17834,
17854,
17820,
17819,
17821,
17856,
17867,
17870,
17871,
17868,
17869,
17860,
17861,
17862,
17863,
17873,
17866,
17872,
17865,
17896,
17902,
17899,
17895,
17900,
17898,
17901,
17906,
17903,
17890,
17889,
17909,
17908,
17910,
17885,
17886,
17877,
17878,
17883,
17884,
17880,
17881,
17888,
17887,
-1,
17905,
-1,
17907,
17904,
17801,
]

_charnames_70784 = [
5176,
5096,
5099,
5115,
5116,
5104,
5105,
5074,
5075,
5076,
5077,
5132,
5098,
5128,
5097,
5111,
5110,
5119,
5118,
5088,
5122,
5121,
5114,
5113,
5086,
5082,
5081,
5093,
5092,
5087,
5084,
5083,
5095,
5094,
5089,
5108,
5107,
5125,
5124,
5129,
5126,
5127,
5130,
5078,
5102,
5101,
5103,
5131,
5142,
5148,
5149,
5143,
5144,
5135,
5136,
5137,
5138,
5151,
5147,
5141,
5150,
5146,
5140,
5174,
5172,
5168,
5169,
5173,
5171,
5179,
5177,
5178,
]

_charnames_70864 = [
5162,
5163,
5154,
5155,
5160,
5161,
5157,
5158,
5165,
5164,
]

_charnames_71040 = [
6605,
6609,
6636,
6637,
6625,
6626,
6600,
6601,
6602,
6603,
6653,
6608,
6649,
6606,
6632,
6631,
6640,
6639,
6613,
6643,
6642,
6635,
6634,
6611,
6593,
6592,
6618,
6617,
6612,
6597,
6596,
6620,
6619,
6614,
6629,
6628,
6646,
6645,
6650,
6647,
6648,
6651,
6604,
6623,
6622,
6624,
6652,
6693,
6698,
6699,
6696,
6697,
6694,
6695,
-1,
-1,
6701,
6692,
6700,
6691,
6685,
6686,
6681,
6682,
6684,
6683,
6708,
6707,
6677,
6678,
6705,
6704,
6703,
6709,
6660,
6661,
6666,
6665,
6664,
6674,
6675,
6673,
6662,
6672,
6671,
6669,
6668,
6670,
6595,
6589,
6590,
6607,
6689,
6690,
]

_charnames_71168 = [
9543,
9546,
9565,
9566,
9551,
9552,
9521,
9522,
9523,
9524,
9581,
9545,
9578,
9544,
9561,
9560,
9569,
9568,
9535,
9572,
9571,
9564,
9563,
9533,
9529,
9528,
9540,
9539,
9534,
9531,
9530,
9542,
9541,
9536,
9555,
9554,
9575,
9574,
9579,
9576,
9577,
9558,
9525,
9549,
9548,
9550,
9580,
9557,
9591,
9594,
9595,
9592,
9593,
9584,
9585,
9586,
9587,
9597,
9590,
9596,
9589,
9621,
9617,
9618,
9620,
9614,
9613,
9623,
9622,
]

_charnames_71248 = [
9609,
9610,
9601,
9602,
9607,
9608,
9604,
9605,
9612,
9611,
-1,
-1,
-1,
-1,
-1,
-1,
9644,
9631,
9646,
9637,
9645,
9633,
9634,
9641,
9642,
9627,
9629,
9630,
9636,
]

_charnames_71296 = [
4971,
4975,
5010,
5011,
4993,
4994,
5027,
4974,
5023,
4972,
5006,
5005,
5014,
5013,
4985,
5017,
5016,
5009,
5008,
4983,
4979,
4978,
4990,
4989,
4984,
4981,
4980,
4992,
4991,
4986,
5003,
5002,
5020,
5019,
5024,
5021,
5000,
5025,
5022,
4996,
4997,
5026,
4999,
5058,
5055,
5046,
5049,
5050,
5047,
5048,
5052,
5045,
5051,
5044,
5056,
5057,
4973,
]

_charnames_71360 = [
5038,
5039,
5030,
5031,
5036,
5037,
5033,
5034,
5041,
5040,
]

_charnames_71424 = [
17101,
17100,
17091,
17092,
17095,
17086,
17098,
17097,
17113,
17116,
17104,
17119,
17094,
17115,
17117,
17114,
17090,
17118,
17084,
17110,
17109,
17107,
17087,
17106,
17112,
17103,
17088,
-1,
-1,
17157,
17158,
17156,
17121,
17125,
17128,
17129,
17126,
17127,
17131,
17122,
17130,
17124,
17123,
17152,
-1,
-1,
-1,
-1,
17142,
17143,
17134,
17135,
17140,
17141,
17137,
17138,
17145,
17144,
17161,
17160,
17149,
17150,
17151,
17153,
]

_charnames_71680 = [
23036,
23039,
23058,
23059,
23044,
23045,
23075,
23038,
23071,
23037,
23054,
23053,
23062,
23061,
23028,
23065,
23064,
23057,
23056,
23026,
23022,
23021,
23033,
23032,
23027,
23024,
23023,
23035,
23034,
23029,
23051,
23050,
23068,
23067,
23072,
23069,
23048,
23073,
23070,
23042,
23041,
23043,
23074,
23047,
23080,
23085,
23086,
23083,
23084,
23081,
23082,
23088,
23079,
23087,
23078,
23094,
23091,
23092,
23093,
23095,
]

_charnames_71840 = [
24244,
24226,
24245,
24216,
24219,
24218,
24250,
24235,
24230,
24240,
24228,
24251,
24249,
24232,
24217,
24236,
24233,
24241,
24247,
24243,
24252,
24227,
24229,
24253,
24248,
24224,
24223,
24222,
24225,
24238,
24239,
24246,
24204,
24186,
24205,
24176,
24179,
24178,
24210,
24195,
24190,
24200,
24188,
24211,
24209,
24192,
24177,
24196,
24193,
24201,
24207,
24203,
24212,
24187,
24189,
24213,
24208,
24184,
24183,
24182,
24185,
24198,
24199,
24206,
24264,
24265,
24256,
24257,
24262,
24263,
24259,
24260,
24267,
24266,
24272,
24270,
24271,
24277,
24278,
24274,
24275,
24280,
24279,
]

_charnames_72096 = [
18168,
18171,
18197,
18198,
18180,
18181,
18173,
18174,
-1,
-1,
18212,
18170,
18209,
18169,
18193,
18192,
18201,
18200,
18160,
18204,
18203,
18196,
18195,
18158,
18154,
18153,
18165,
18164,
18159,
18156,
18155,
18167,
18166,
18161,
18187,
18186,
18207,
18206,
18210,
18208,
18184,
18190,
18175,
18178,
18177,
18179,
18211,
18189,
18183,
18217,
18222,
18223,
18220,
18221,
18218,
18219,
-1,
-1,
18226,
18216,
18225,
18215,
18233,
18229,
18230,
18232,
18234,
18235,
18224,
]

_charnames_72192 = [
25738,
25750,
25743,
25742,
25751,
25745,
25744,
25748,
25747,
25749,
25752,
25715,
25714,
25724,
25723,
25706,
25727,
25726,
25736,
25704,
25688,
25687,
25700,
25699,
25705,
25693,
25692,
25702,
25701,
25707,
25721,
25720,
25730,
25729,
25734,
25691,
25690,
25697,
25696,
25717,
25718,
25739,
25731,
25733,
25735,
25732,
25710,
25709,
25711,
25737,
25713,
25783,
25761,
25756,
25757,
25758,
25762,
25760,
25771,
25767,
25769,
25770,
25768,
25781,
25773,
25776,
25777,
25779,
25778,
25782,
25774,
25763,
]

_charnames_72272 = [
6842,
6869,
6863,
6862,
6870,
6864,
6865,
6868,
6867,
6860,
6861,
6871,
6817,
6816,
6829,
6828,
6808,
6832,
6831,
6826,
6825,
6806,
6792,
6791,
6801,
6800,
6807,
6797,
6796,
6804,
6803,
6809,
6823,
6822,
6835,
6834,
6839,
6795,
6794,
6802,
6819,
6820,
6843,
6836,
6838,
6840,
6837,
6812,
6811,
6813,
6841,
6815,
6876,
6875,
6888,
6889,
6886,
6887,
6853,
6852,
6848,
6854,
6847,
6855,
6850,
6849,
6851,
6846,
6845,
6856,
6877,
6874,
6897,
6878,
6880,
6881,
6883,
6882,
6892,
6893,
6890,
6896,
6895,
]

_charnames_72384 = [
21490,
21496,
21508,
21507,
21512,
21502,
21503,
21492,
21509,
21510,
21495,
21504,
21513,
21501,
21487,
21486,
21493,
21489,
21505,
21482,
21500,
21514,
21511,
21497,
21506,
21483,
21484,
21498,
21478,
21481,
21477,
21479,
21473,
21480,
21476,
21474,
21475,
21530,
21528,
21526,
21531,
21532,
21527,
21523,
21521,
21524,
21525,
21533,
21539,
21535,
21536,
21517,
21515,
21537,
21518,
21519,
21540,
]

_charnames_72704 = [
15383,
15386,
15402,
15403,
15391,
15392,
15362,
15363,
15364,
-1,
15419,
15385,
15415,
15384,
15398,
15397,
15406,
15405,
15375,
15409,
15408,
15401,
15400,
15373,
15369,
15368,
15380,
15379,
15374,
15371,
15370,
15382,
15381,
15376,
15395,
15394,
15412,
15411,
15416,
15413,
15414,
15417,
15365,
15389,
15388,
15390,
15418,
15454,
15457,
15458,
15455,
15456,
15448,
15449,
15450,
-1,
15460,
15453,
15459,
15452,
15485,
15484,
15480,
15481,
15483,
15477,
15476,
15489,
15488,
15487,
]

_charnames_72784 = [
15472,
15473,
15464,
15465,
15470,
15471,
15467,
15468,
15475,
15474,
15445,
15423,
15426,
15436,
15439,
15430,
15432,
15443,
15441,
15428,
15424,
15427,
15437,
15440,
15431,
15433,
15444,
15442,
15490,
-1,
-1,
-1,
9162,
9161,
9137,
9136,
9151,
9124,
9143,
9142,
9149,
9123,
9121,
9120,
9140,
9125,
9134,
9133,
9152,
9147,
9119,
9118,
9139,
9145,
9127,
9128,
9154,
9144,
9146,
9148,
9130,
9131,
9150,
9153,
-1,
-1,
9095,
9094,
9109,
9082,
9101,
9100,
9107,
9081,
9079,
9078,
9098,
9083,
9092,
9091,
9110,
9105,
9077,
9076,
9097,
9103,
9085,
9086,
-1,
9102,
9104,
9106,
9088,
9089,
9108,
9111,
9160,
9158,
9156,
9159,
9157,
9114,
9113,
]

_charnames_72960 = [
8991,
8994,
9015,
9016,
9007,
9008,
9032,
-1,
8993,
9029,
-1,
8992,
9002,
9001,
9019,
9018,
8983,
9022,
9021,
9006,
9005,
8981,
8976,
8975,
8988,
8987,
8982,
8979,
8978,
8990,
8989,
8984,
9011,
9010,
9025,
9024,
9030,
9026,
9028,
9014,
9027,
8997,
8996,
8998,
9031,
9013,
9000,
9004,
8977,
9038,
9041,
9042,
9039,
9040,
9043,
-1,
-1,
-1,
9045,
-1,
9037,
9044,
-1,
9036,
9066,
9062,
9063,
9065,
9064,
9046,
9068,
9069,
]

_charnames_73040 = [
9057,
9058,
9049,
9050,
9055,
9056,
9052,
9053,
9060,
9059,
-1,
-1,
-1,
-1,
-1,
-1,
22777,
22780,
22798,
22799,
22781,
22782,
-1,
22816,
22779,
-1,
22813,
22778,
22809,
22810,
22808,
22807,
22814,
22794,
22793,
22770,
22769,
22791,
22802,
22801,
22776,
22775,
22788,
22805,
22804,
22768,
22767,
22790,
22797,
22796,
22774,
22773,
22787,
22785,
22784,
22815,
22812,
22811,
22822,
22825,
22826,
22823,
22824,
-1,
22828,
22821,
-1,
22827,
22820,
22846,
22845,
22829,
22847,
]

_charnames_73120 = [
22840,
22841,
22832,
22833,
22838,
22839,
22835,
22836,
22843,
22842,
]

_charnames_73440 = [
9237,
9239,
9227,
9234,
9242,
9235,
9231,
9240,
9228,
9241,
9238,
9226,
9229,
9233,
9236,
9230,
9232,
9243,
9251,
9247,
9245,
9248,
9246,
9249,
9250,
]

_charnames_73664 = [
4611,
4630,
4627,
4619,
4624,
4612,
4637,
4633,
4613,
4618,
4617,
4614,
4628,
4635,
4634,
4625,
4629,
4622,
4621,
4636,
4638,
4573,
4574,
4575,
4572,
4564,
4570,
4554,
4566,
4571,
4555,
4557,
4560,
4556,
4569,
4562,
4656,
4640,
4651,
4578,
4647,
4646,
4605,
4654,
4577,
4648,
4662,
4576,
4565,
4561,
]

_charnames_73727 = [
4658,
1019,
1081,
1080,
1079,
1078,
1077,
1076,
1075,
1074,
1105,
1020,
1038,
1037,
1033,
1032,
1036,
1030,
1029,
1035,
1025,
1034,
1039,
1040,
1046,
1045,
1044,
1043,
1042,
1102,
1098,
1101,
1100,
1048,
1058,
1057,
1056,
1055,
1052,
1051,
1054,
1053,
1060,
1059,
1094,
1096,
1082,
1088,
1087,
1086,
1085,
1089,
1104,
1091,
1092,
1093,
1072,
1062,
1068,
1069,
1067,
1065,
1066,
1071,
1070,
1264,
1275,
1277,
1265,
1270,
1272,
1271,
1273,
1274,
1289,
1293,
1292,
1291,
1278,
1283,
1281,
1284,
1287,
1288,
1285,
1286,
756,
757,
783,
782,
780,
779,
763,
764,
761,
762,
765,
789,
776,
777,
788,
770,
767,
769,
768,
787,
786,
785,
784,
774,
775,
796,
792,
795,
794,
798,
810,
799,
802,
804,
808,
809,
806,
698,
752,
753,
751,
745,
748,
749,
699,
739,
755,
740,
741,
742,
743,
744,
754,
1106,
1172,
1173,
1145,
1155,
1154,
1152,
1149,
1148,
1150,
1176,
1175,
1174,
1156,
1159,
1160,
1161,
1164,
1163,
1162,
1168,
1166,
1169,
1107,
1115,
1116,
1117,
1118,
1135,
1131,
1132,
1129,
1130,
1133,
1120,
1121,
1122,
1111,
1112,
1114,
1113,
1125,
1124,
251,
375,
252,
273,
272,
271,
276,
274,
267,
269,
334,
332,
335,
336,
298,
294,
296,
293,
327,
328,
325,
326,
261,
257,
262,
263,
264,
265,
313,
310,
311,
316,
315,
351,
350,
307,
306,
303,
304,
302,
338,
348,
347,
322,
323,
354,
286,
285,
282,
283,
281,
287,
353,
342,
343,
344,
355,
365,
368,
371,
372,
362,
364,
363,
374,
356,
357,
359,
360,
361,
369,
370,
373,
436,
439,
376,
405,
404,
406,
398,
400,
401,
408,
385,
386,
378,
384,
383,
382,
381,
380,
397,
388,
396,
394,
392,
395,
409,
434,
410,
413,
414,
416,
415,
418,
419,
423,
422,
425,
433,
431,
432,
426,
430,
429,
428,
1317,
1319,
1321,
1322,
1295,
1297,
1298,
1306,
1305,
1304,
1303,
1302,
1301,
1300,
1307,
1308,
1314,
1313,
1312,
1311,
1310,
1316,
1323,
1349,
1348,
1341,
1344,
1343,
1331,
1332,
1337,
1334,
1335,
1336,
1338,
1340,
1339,
1324,
1326,
1329,
1328,
1327,
1330,
1347,
1346,
1345,
442,
486,
490,
491,
489,
497,
496,
495,
499,
523,
522,
451,
455,
454,
452,
453,
445,
450,
448,
449,
456,
457,
520,
519,
504,
501,
502,
508,
506,
479,
483,
482,
481,
484,
485,
517,
516,
513,
525,
466,
467,
465,
464,
463,
461,
469,
468,
511,
470,
476,
475,
474,
473,
524,
546,
547,
549,
532,
531,
530,
528,
529,
544,
545,
537,
539,
540,
543,
542,
533,
536,
535,
575,
562,
571,
569,
570,
573,
572,
567,
566,
564,
565,
550,
561,
560,
555,
556,
559,
553,
554,
558,
551,
552,
557,
574,
5,
101,
104,
108,
107,
106,
111,
110,
109,
167,
166,
171,
170,
138,
139,
136,
137,
162,
163,
164,
151,
147,
150,
149,
133,
134,
132,
130,
131,
145,
144,
142,
143,
158,
159,
160,
169,
126,
125,
124,
121,
122,
127,
155,
154,
156,
112,
115,
114,
118,
117,
116,
172,
173,
175,
176,
177,
178,
184,
182,
183,
179,
180,
181,
246,
249,
248,
247,
185,
245,
186,
224,
223,
201,
203,
221,
217,
220,
194,
192,
193,
195,
215,
214,
219,
212,
211,
199,
198,
206,
225,
232,
230,
229,
227,
244,
233,
236,
237,
238,
243,
242,
239,
240,
241,
1248,
1252,
1253,
1256,
1255,
1254,
1249,
1250,
1260,
1261,
1257,
1258,
1222,
1247,
1243,
1244,
1246,
1245,
1223,
1233,
1232,
1231,
1225,
1229,
1234,
1235,
1238,
1239,
1241,
1242,
1001,
1012,
1002,
1006,
1004,
1005,
1007,
1010,
1008,
1009,
1013,
1017,
1016,
1018,
924,
967,
966,
961,
964,
963,
926,
947,
945,
946,
941,
952,
950,
949,
933,
937,
935,
936,
931,
929,
965,
968,
996,
969,
991,
990,
987,
988,
989,
994,
995,
992,
993,
970,
982,
981,
980,
979,
978,
977,
976,
975,
974,
973,
983,
984,
1374,
1377,
1376,
1375,
1378,
1351,
1361,
1362,
1360,
1359,
1363,
1356,
1357,
1354,
1355,
1364,
1366,
1371,
1370,
1369,
1372,
1405,
1406,
1408,
1407,
641,
674,
642,
670,
662,
663,
668,
661,
660,
666,
665,
664,
655,
653,
658,
650,
649,
648,
647,
646,
673,
671,
675,
676,
678,
677,
603,
604,
613,
612,
611,
610,
609,
608,
606,
607,
614,
617,
616,
618,
628,
627,
626,
633,
632,
629,
631,
630,
597,
600,
599,
579,
592,
585,
584,
591,
590,
581,
582,
589,
588,
587,
586,
602,
593,
595,
596,
601,
634,
640,
635,
639,
688,
694,
689,
690,
691,
696,
695,
679,
687,
684,
685,
686,
682,
683,
680,
681,
1178,
1193,
1191,
1190,
1192,
1194,
1197,
1196,
1179,
1187,
1186,
1183,
1182,
1185,
1184,
1198,
1200,
1219,
1220,
1210,
1218,
1216,
1211,
1215,
1213,
1214,
1201,
1209,
1208,
1202,
1206,
1207,
811,
913,
912,
910,
909,
908,
922,
921,
885,
894,
891,
890,
888,
889,
895,
892,
893,
896,
873,
879,
876,
878,
877,
884,
880,
883,
882,
918,
919,
812,
871,
870,
850,
862,
861,
863,
865,
864,
854,
857,
856,
872,
867,
868,
813,
840,
841,
847,
838,
816,
819,
818,
817,
820,
846,
833,
832,
831,
845,
827,
844,
843,
836,
835,
842,
824,
823,
822,
848,
849,
897,
902,
899,
900,
901,
903,
905,
904,
920,
915,
916,
917,
1396,
1398,
1399,
1401,
1400,
1403,
1389,
1395,
1394,
1390,
1391,
1393,
1392,
1381,
1382,
1385,
1387,
1386,
548,
1026,
1047,
1097,
773,
791,
807,
747,
1134,
1128,
275,
268,
440,
407,
1315,
492,
488,
446,
458,
526,
507,
514,
462,
510,
472,
140,
228,
204,
200,
1262,
1240,
1011,
925,
960,
959,
942,
999,
1379,
1373,
667,
1217,
875,
911,
]

_charnames_74752 = [
1483,
1467,
1429,
1447,
1502,
1498,
1557,
1544,
1469,
1431,
1449,
1507,
1497,
1556,
1543,
1421,
1442,
1500,
1493,
1552,
1539,
1521,
1479,
1466,
1428,
1446,
1506,
1496,
1555,
1542,
1520,
1478,
1465,
1427,
1445,
1476,
1455,
1456,
1425,
1436,
1505,
1495,
1554,
1541,
1528,
1475,
1453,
1454,
1424,
1435,
1510,
1509,
1526,
1481,
1458,
1459,
1420,
1441,
1463,
1462,
1412,
1416,
1415,
1414,
1504,
1492,
1491,
1490,
1550,
1551,
1535,
1537,
1536,
1538,
1484,
1468,
1430,
1448,
1503,
1527,
1482,
1460,
1418,
1419,
1439,
1440,
1546,
1547,
1523,
1485,
1515,
1473,
1437,
1514,
1472,
1524,
1518,
1531,
1532,
1517,
1529,
1563,
1562,
1560,
1561,
1422,
1443,
1501,
1494,
1553,
1540,
-1,
1570,
1569,
1568,
1566,
1567,
]

_charnames_74880 = [
1027,
1024,
1103,
1276,
1269,
1268,
1267,
1282,
797,
790,
803,
801,
805,
725,
723,
724,
734,
733,
738,
717,
714,
716,
715,
731,
730,
737,
712,
711,
709,
710,
705,
703,
704,
706,
721,
720,
719,
736,
735,
728,
727,
1153,
1151,
1167,
1170,
1144,
1143,
1142,
1139,
1140,
1137,
1138,
1141,
1127,
333,
297,
292,
291,
329,
256,
260,
259,
314,
301,
339,
340,
341,
346,
318,
321,
320,
280,
352,
367,
438,
393,
417,
424,
1320,
1299,
498,
503,
477,
471,
168,
71,
66,
65,
70,
63,
62,
69,
68,
60,
59,
67,
98,
97,
82,
81,
76,
75,
74,
83,
79,
78,
88,
87,
86,
91,
90,
92,
46,
38,
45,
44,
42,
41,
43,
54,
53,
56,
55,
51,
50,
49,
48,
99,
35,
8,
21,
20,
19,
18,
17,
16,
15,
13,
12,
11,
34,
22,
33,
32,
27,
28,
31,
30,
29,
26,
25,
95,
94,
231,
222,
218,
208,
209,
207,
1259,
1228,
1227,
958,
943,
940,
957,
956,
955,
953,
954,
928,
932,
930,
672,
669,
654,
657,
615,
624,
623,
622,
621,
638,
637,
693,
1199,
1205,
1204,
866,
858,
839,
829,
828,
1402,
1388,
1384,
]

_charnames_77824 = [
12199,
12198,
12197,
12196,
12191,
12192,
12188,
12190,
12189,
12195,
12194,
12193,
12186,
12185,
12184,
12183,
12177,
12178,
12182,
12181,
12175,
12176,
12180,
12179,
12244,
12243,
12242,
12241,
12240,
12239,
12238,
12237,
12236,
12235,
12211,
12210,
12201,
12202,
12209,
12208,
12207,
12206,
12205,
12204,
12203,
12166,
12167,
12173,
12164,
12165,
12162,
12163,
12172,
12160,
12161,
12171,
12170,
12169,
12168,
12233,
12232,
12231,
12230,
12229,
12228,
12227,
12226,
12225,
12224,
12222,
12221,
12220,
12219,
12218,
12217,
12216,
12215,
12214,
12213,
12245,
13312,
13311,
13310,
13309,
13303,
13304,
13308,
13307,
13306,
13305,
13223,
13212,
13215,
13214,
13213,
13222,
13221,
13220,
13219,
13218,
13217,
13216,
13225,
13226,
13235,
13234,
13233,
13232,
13231,
13230,
13229,
13228,
13227,
13241,
13240,
13239,
13238,
13237,
12495,
12494,
12493,
12492,
12491,
12490,
12489,
12486,
12487,
12488,
12484,
12483,
12482,
12481,
12480,
12479,
12478,
12477,
12476,
12475,
12473,
12472,
12471,
12470,
12469,
12468,
12467,
12463,
12464,
12466,
12465,
12461,
12452,
12453,
12460,
12459,
12450,
12451,
12458,
12457,
12456,
12455,
12454,
12448,
12447,
12446,
12445,
12444,
12443,
12439,
12440,
12442,
12437,
12438,
12441,
12398,
12407,
12406,
12405,
12404,
12403,
12402,
12401,
12400,
12399,
12418,
12410,
12411,
12417,
12408,
12409,
12416,
12415,
12414,
12413,
12412,
12435,
12434,
12433,
12432,
12431,
12430,
12429,
12420,
12428,
12427,
12426,
12425,
12424,
12423,
12422,
12421,
13031,
13030,
13029,
13028,
13027,
13026,
13025,
13023,
13024,
13021,
13022,
13019,
13018,
13017,
13016,
13015,
13014,
13010,
13011,
13008,
13009,
13013,
13012,
12997,
12998,
13006,
13005,
13004,
13003,
13002,
13001,
13000,
12995,
12996,
12999,
13041,
13040,
13039,
13038,
13033,
13034,
13037,
13036,
13035,
12790,
12791,
12799,
12798,
12797,
12796,
12795,
12794,
12793,
12792,
12788,
12787,
12786,
12778,
12779,
12785,
12784,
12783,
12782,
12781,
12780,
12776,
12766,
12767,
12775,
12774,
12773,
12772,
12771,
12770,
12769,
12768,
12764,
12756,
12757,
12763,
12762,
12761,
12760,
12759,
12754,
12755,
12752,
12753,
12758,
12750,
12749,
12748,
12747,
12746,
12742,
12743,
12740,
12741,
12738,
12739,
12745,
12744,
12807,
12801,
12804,
12803,
12802,
12806,
12805,
12860,
12859,
12858,
12857,
12856,
12852,
12853,
12849,
12851,
12850,
12855,
12854,
12872,
12862,
12863,
12871,
12870,
12869,
12868,
12867,
12866,
12865,
12864,
12838,
12839,
12847,
12846,
12845,
12844,
12843,
12836,
12837,
12842,
12841,
12840,
12834,
12833,
12832,
12831,
12830,
12829,
12825,
12826,
12823,
12824,
12828,
12827,
12821,
12820,
12819,
12812,
12813,
12818,
12810,
12811,
12817,
12816,
12815,
12814,
12878,
12877,
12876,
12875,
12874,
13335,
13334,
13333,
13332,
13331,
13327,
13328,
13330,
13329,
13255,
13254,
13253,
13252,
13247,
13248,
13251,
13250,
13249,
13245,
13246,
13259,
13260,
13257,
13258,
13264,
13263,
13262,
13261,
13355,
13354,
13353,
13352,
13351,
13350,
13349,
13348,
13324,
13317,
13318,
13323,
13322,
13321,
13315,
13316,
13320,
13319,
12717,
12719,
12718,
12728,
12720,
12721,
12727,
12726,
12725,
12724,
12723,
12722,
12681,
12682,
12687,
12666,
12674,
12673,
12672,
12671,
12670,
12669,
12668,
12667,
12686,
12685,
12679,
12680,
12677,
12678,
12675,
12676,
12684,
12683,
12715,
12714,
12707,
12708,
12713,
12705,
12706,
12712,
12711,
12710,
12703,
12704,
12709,
12701,
12692,
12693,
12700,
12689,
12691,
12690,
12699,
12698,
12697,
12696,
12695,
12694,
12730,
12731,
12735,
12734,
12733,
12732,
12336,
12335,
12334,
12333,
12332,
12331,
12330,
12329,
12328,
12314,
12313,
12312,
12311,
12310,
12309,
12308,
12307,
12303,
12305,
12304,
12306,
12326,
12325,
12324,
12323,
12322,
12316,
12317,
12321,
12320,
12319,
12318,
12301,
12300,
12299,
12294,
12295,
12292,
12293,
12290,
12291,
12298,
12288,
12289,
12297,
12296,
12340,
12339,
12338,
12394,
12393,
12392,
12391,
12385,
12386,
12390,
12389,
12388,
12387,
12383,
12382,
12381,
12380,
12379,
12378,
12377,
12373,
12374,
12376,
12375,
12395,
12365,
12364,
12363,
12362,
12361,
12360,
12359,
12358,
12357,
12347,
12348,
12345,
12346,
12355,
12354,
12353,
12352,
12351,
12350,
12343,
12344,
12349,
12370,
12369,
12367,
12368,
12592,
12593,
12599,
12598,
12597,
12590,
12591,
12583,
12589,
12588,
12587,
12586,
12585,
12584,
12596,
12595,
12594,
12633,
12636,
12635,
12634,
12646,
12645,
12644,
12643,
12642,
12641,
12640,
12639,
12637,
12638,
12624,
12625,
12631,
12630,
12629,
12622,
12623,
12620,
12621,
12628,
12627,
12626,
12618,
12619,
12608,
12609,
12616,
12615,
12606,
12607,
12614,
12613,
12601,
12605,
12604,
12603,
12602,
12612,
12611,
12610,
12657,
12656,
12655,
12654,
12653,
12652,
12651,
12650,
12649,
12648,
12659,
12661,
12660,
12662,
13276,
13277,
13284,
13274,
13275,
13283,
13282,
13281,
13280,
13279,
13278,
13287,
13286,
13363,
13362,
13361,
13360,
13359,
13358,
13357,
13162,
13154,
13155,
13151,
13153,
13152,
13161,
13160,
13159,
13158,
13157,
13156,
13140,
13141,
13149,
13148,
13147,
13146,
13145,
13138,
13139,
13144,
13143,
13142,
13173,
13172,
13171,
13170,
13169,
13168,
13167,
13166,
13165,
13164,
12930,
12922,
12923,
12929,
12928,
12927,
12920,
12921,
12926,
12925,
12924,
12893,
12892,
12891,
12890,
12881,
12883,
12882,
12889,
12888,
12884,
12885,
12887,
12886,
12906,
12905,
12904,
12903,
12902,
12901,
12895,
12897,
12896,
12900,
12899,
12898,
12918,
12917,
12916,
12915,
12914,
12908,
12909,
12913,
12912,
12911,
12910,
12938,
12937,
12936,
12935,
12934,
12933,
12932,
13057,
13056,
13051,
13052,
13055,
13054,
13053,
13049,
13050,
13047,
13048,
13045,
13046,
13070,
13061,
13062,
13069,
13068,
13067,
13066,
13059,
13060,
13065,
13064,
13063,
13081,
13080,
13079,
13078,
13077,
13076,
13075,
13074,
13073,
13072,
13091,
13090,
13085,
13086,
13083,
13084,
13089,
13088,
13087,
12976,
12975,
12974,
12973,
12972,
12966,
12968,
12967,
12971,
12970,
12969,
12987,
12986,
12985,
12984,
12983,
12982,
12981,
12980,
12979,
12978,
12952,
12951,
12950,
12943,
12944,
12949,
12948,
12947,
12946,
12945,
12941,
12942,
12964,
12963,
12954,
12955,
12962,
12961,
12960,
12959,
12958,
12957,
12956,
12991,
12990,
12989,
12525,
12534,
12533,
12532,
12531,
12530,
12529,
12528,
12527,
12526,
12538,
12539,
12545,
12544,
12543,
12542,
12535,
12537,
12536,
12541,
12540,
12561,
12547,
12550,
12549,
12548,
12551,
12553,
12552,
12560,
12559,
12558,
12557,
12556,
12555,
12554,
12499,
12511,
12510,
12509,
12508,
12507,
12506,
12505,
12504,
12503,
12502,
12501,
12500,
12523,
12522,
12516,
12517,
12521,
12520,
12519,
12518,
12514,
12515,
12512,
12513,
12569,
12570,
12567,
12568,
12576,
12565,
12566,
12575,
12574,
12573,
12563,
12564,
12572,
12571,
12577,
12578,
13201,
13200,
13193,
13194,
13199,
13198,
13197,
13196,
13195,
13191,
13192,
13182,
13183,
13189,
13188,
13187,
13180,
13181,
13186,
13185,
13178,
13179,
13176,
13177,
13184,
13209,
13208,
13207,
13206,
13203,
13204,
13205,
13300,
13299,
13298,
13289,
13291,
13290,
13297,
13294,
13295,
13296,
13292,
13293,
13338,
13339,
13346,
13345,
13344,
13343,
13342,
13341,
13340,
13135,
13119,
13123,
13122,
13121,
13120,
13124,
13126,
13125,
13129,
13130,
13127,
13128,
13134,
13133,
13132,
13131,
13117,
13116,
13115,
13114,
13113,
13094,
13103,
13102,
13101,
13100,
13099,
13098,
13097,
13096,
13095,
13104,
13112,
13111,
13110,
13109,
13108,
13107,
13106,
13105,
12258,
12257,
12256,
12255,
12254,
12253,
12248,
12250,
12249,
12252,
12251,
12280,
12279,
12278,
12277,
12276,
12275,
12274,
12273,
12272,
12271,
12269,
12268,
12267,
12266,
12265,
12264,
12263,
12262,
12261,
12260,
12284,
12283,
12282,
-1,
12579,
13336,
13267,
13270,
13268,
13271,
12663,
13313,
13042,
]

_charnames_82944 = [
16140,
16139,
16138,
16137,
16136,
16135,
16134,
16133,
16132,
16087,
16088,
16097,
16096,
16095,
16094,
16093,
16092,
16091,
16090,
16089,
16085,
16084,
16083,
16082,
16081,
16080,
16075,
16076,
16079,
16078,
16077,
16073,
16072,
16071,
16070,
16069,
16068,
16067,
16066,
16065,
16063,
16064,
16034,
16026,
16027,
16033,
16032,
16031,
16024,
16025,
16021,
16023,
16022,
16030,
16029,
16028,
16130,
16129,
16128,
16127,
16126,
16125,
16124,
16123,
16122,
16121,
16048,
16047,
16046,
16045,
16044,
16043,
16036,
16039,
16038,
16037,
16042,
16041,
16040,
16119,
16118,
16117,
16116,
16115,
16114,
16113,
16112,
16111,
16110,
16108,
16107,
16106,
16105,
16104,
16103,
16102,
16101,
16100,
16099,
16061,
16060,
16059,
16058,
16057,
16056,
16055,
16052,
16053,
16050,
16051,
16054,
15660,
15661,
15658,
15659,
15656,
15657,
15665,
15649,
15652,
15651,
15650,
15653,
15655,
15654,
15664,
15645,
15648,
15647,
15646,
15663,
15662,
15667,
15669,
15668,
15679,
15678,
15677,
15676,
15670,
15671,
15675,
15674,
15673,
15672,
15703,
15702,
15701,
15700,
15699,
15693,
15694,
15698,
15697,
15696,
15695,
15691,
15690,
15689,
15688,
15687,
15681,
15682,
15686,
15685,
15684,
15683,
15769,
15768,
15767,
15766,
15765,
15764,
15763,
15762,
15761,
15760,
15758,
15757,
15756,
15755,
15754,
15753,
15752,
15751,
15750,
15749,
15747,
15746,
15745,
15744,
15743,
15742,
15741,
15740,
15739,
15738,
15736,
15735,
15734,
15733,
15732,
15731,
15730,
15729,
15728,
15727,
15725,
15724,
15723,
15722,
15721,
15720,
15719,
15718,
15717,
15716,
15714,
15713,
15712,
15711,
15710,
15709,
15708,
15707,
15706,
15705,
15912,
15911,
15899,
15901,
15900,
15910,
15909,
15908,
15907,
15904,
15905,
15906,
15902,
15903,
15938,
15937,
15936,
15935,
15934,
15929,
15930,
15927,
15928,
15933,
15932,
15931,
15974,
15973,
15972,
15971,
15970,
15969,
15968,
15964,
15965,
15967,
15966,
16018,
16017,
16016,
16015,
16014,
16013,
16012,
16011,
16010,
16009,
16007,
16006,
16005,
16004,
16003,
16002,
16001,
16000,
15999,
15998,
15996,
15995,
15994,
15993,
15992,
15991,
15990,
15989,
15988,
15987,
15962,
15961,
15960,
15959,
15958,
15957,
15956,
15952,
15953,
15955,
15954,
15985,
15984,
15983,
15982,
15981,
15980,
15979,
15978,
15977,
15976,
15950,
15949,
15948,
15947,
15946,
15945,
15944,
15943,
15942,
15940,
15941,
15925,
15924,
15923,
15922,
15916,
15917,
15921,
15920,
15919,
15918,
15914,
15915,
15863,
15862,
15861,
15860,
15859,
15858,
15857,
15856,
15855,
15853,
15854,
15896,
15895,
15894,
15893,
15892,
15891,
15890,
15889,
15888,
15887,
15851,
15850,
15849,
15848,
15847,
15846,
15845,
15844,
15843,
15841,
15842,
15787,
15786,
15779,
15778,
15777,
15785,
15784,
15783,
15772,
15775,
15774,
15773,
15782,
15781,
15780,
15885,
15884,
15883,
15882,
15881,
15880,
15879,
15878,
15877,
15876,
15839,
15838,
15837,
15836,
15835,
15834,
15833,
15832,
15831,
15829,
15830,
15815,
15814,
15813,
15812,
15806,
15807,
15811,
15810,
15809,
15804,
15805,
15808,
15827,
15817,
15818,
15826,
15825,
15824,
15823,
15822,
15821,
15820,
15819,
15802,
15794,
15795,
15801,
15793,
15792,
15800,
15799,
15789,
15790,
15798,
15797,
15796,
15874,
15873,
15872,
15871,
15870,
15869,
15868,
15867,
15866,
15865,
16244,
16243,
16242,
16241,
16240,
16239,
16238,
16237,
16236,
16235,
16158,
16157,
16167,
16166,
16165,
16164,
16163,
16162,
16161,
16160,
16159,
16233,
16232,
16231,
16230,
16229,
16228,
16227,
16226,
16225,
16224,
16222,
16221,
16220,
16219,
16218,
16217,
16216,
16215,
16214,
16213,
16211,
16210,
16209,
16208,
16207,
16206,
16205,
16204,
16203,
16202,
16145,
16146,
16154,
16153,
16152,
16151,
16150,
16149,
16143,
16144,
16148,
16147,
16200,
16199,
16198,
16197,
16196,
16195,
16194,
16193,
16192,
16191,
16189,
16188,
16187,
16186,
16185,
16184,
16183,
16182,
16181,
16180,
16178,
16177,
16176,
16175,
16174,
16173,
16172,
16171,
16170,
16169,
16253,
16252,
16251,
16250,
16249,
16248,
16247,
16246,
16286,
16285,
16284,
16283,
16282,
16281,
16280,
16279,
16278,
16276,
16275,
16274,
16273,
16272,
16271,
16270,
16269,
16268,
16267,
16265,
16264,
16263,
16262,
16261,
16260,
16259,
16258,
16257,
16256,
16287,
]

_charnames_92160 = [
14296,
14404,
14373,
14374,
14317,
14348,
14393,
14305,
14351,
14370,
14371,
14327,
14389,
14298,
14325,
14332,
14341,
14359,
14292,
14379,
14310,
14357,
14295,
14399,
14398,
14291,
14330,
14365,
14402,
14366,
14337,
14304,
14407,
14403,
14290,
14358,
14342,
14343,
14335,
14383,
14367,
14314,
14376,
14326,
14319,
14375,
14388,
14396,
14356,
14391,
14329,
14380,
14313,
14384,
14336,
14347,
14397,
14410,
14409,
14385,
14355,
14331,
14350,
14288,
14352,
14301,
14363,
14311,
14406,
14297,
14328,
14318,
14340,
14302,
14392,
14354,
14364,
14307,
14324,
14300,
14382,
14308,
14408,
14395,
14320,
14316,
14339,
14444,
14479,
14453,
14454,
14474,
14416,
14463,
14482,
14415,
14464,
14468,
14483,
14472,
14446,
14447,
14485,
14467,
14478,
14451,
14450,
14425,
14418,
14441,
14459,
14486,
14458,
14473,
14469,
14491,
14439,
14436,
14490,
14455,
14480,
14429,
14434,
14435,
14426,
14452,
14419,
14430,
14442,
14466,
14428,
14488,
14417,
14489,
14460,
14423,
14422,
14475,
14437,
14445,
14420,
14462,
14438,
14149,
14186,
14240,
14278,
14147,
14164,
14150,
14273,
14198,
14275,
14190,
14182,
14196,
14268,
14168,
14205,
14224,
14274,
14227,
14241,
14185,
14208,
14159,
14200,
14242,
14235,
14236,
14257,
14169,
14251,
14177,
14247,
14259,
14146,
14280,
14189,
14216,
14183,
14143,
14262,
14201,
14219,
14180,
14249,
14144,
14283,
14163,
14160,
14158,
14284,
14281,
14197,
14282,
14176,
14263,
14246,
14155,
14173,
14231,
14142,
14212,
14209,
14264,
14233,
14175,
14151,
14277,
14145,
14157,
14181,
14234,
14156,
14167,
14215,
14243,
14166,
14254,
14258,
14199,
14213,
14206,
14225,
14195,
14226,
14204,
14239,
14172,
14218,
14217,
14255,
14229,
14230,
14152,
14188,
14265,
14269,
14270,
14250,
14044,
14131,
13991,
14027,
13992,
14105,
13994,
14004,
13985,
14010,
14130,
13979,
14057,
13981,
14076,
14087,
14056,
13997,
14063,
14077,
14122,
14080,
14067,
14029,
14013,
14046,
14038,
14069,
14121,
13995,
14074,
13976,
14091,
14134,
13978,
14136,
14014,
14033,
14100,
14015,
14050,
14035,
14108,
14034,
14026,
14103,
14001,
14042,
14083,
14009,
14089,
14068,
14120,
14075,
14128,
14090,
13977,
14030,
14000,
14073,
14113,
14111,
14007,
14101,
13984,
14031,
13987,
14119,
14114,
14118,
14016,
14019,
14064,
14081,
13989,
13980,
14092,
14039,
14079,
14005,
14088,
14047,
13986,
14099,
13988,
14003,
13996,
14133,
14078,
14125,
14095,
14093,
14008,
14127,
14102,
14040,
14024,
14062,
14049,
14060,
14055,
14082,
14022,
14058,
14020,
14112,
14023,
14059,
14109,
14048,
14104,
14126,
14094,
14021,
14043,
14066,
14137,
13781,
13865,
13845,
13910,
13967,
13905,
13817,
13899,
13954,
13794,
13785,
13813,
13857,
13758,
13924,
13960,
13897,
13767,
13818,
13864,
13917,
13907,
13796,
13773,
13836,
13756,
13772,
13795,
13956,
13790,
13830,
13900,
13762,
13843,
13943,
13757,
13791,
13838,
13904,
13768,
13783,
13858,
13896,
13814,
13779,
13764,
13887,
13944,
13862,
13878,
13831,
13861,
13922,
13898,
13869,
13965,
13962,
13911,
13810,
13855,
13948,
13774,
13894,
13842,
13846,
13799,
13808,
13951,
13860,
13918,
13888,
13801,
13886,
13850,
13784,
13825,
13875,
13913,
13933,
13950,
13753,
13923,
13835,
13759,
13946,
13935,
13804,
13829,
13881,
13766,
13802,
13798,
13832,
13840,
13934,
13807,
13848,
13945,
13931,
13847,
13812,
13754,
13916,
13824,
13805,
13879,
13763,
13821,
13932,
13937,
13788,
13970,
13866,
13968,
13969,
13909,
13820,
13854,
13856,
13780,
13893,
13880,
13769,
13876,
13883,
13884,
13873,
13874,
13921,
13828,
13789,
13815,
13961,
13938,
13966,
13912,
13839,
13957,
13955,
13770,
13775,
13891,
13892,
13930,
13806,
13822,
13906,
13925,
13851,
13834,
13837,
13868,
13926,
13849,
13870,
13936,
13947,
14524,
14562,
14521,
14564,
14529,
14543,
14502,
14554,
14531,
14532,
14539,
14544,
14506,
14498,
14534,
14512,
14511,
14513,
14514,
14520,
14518,
14495,
14494,
14497,
14556,
14509,
14557,
14504,
14548,
14503,
14559,
14549,
14533,
14505,
14527,
14519,
14500,
14501,
14510,
14550,
14563,
14560,
14553,
14552,
14523,
14536,
14528,
14540,
14538,
14537,
14545,
14522,
14515,
14561,
]

_charnames_92736 = [
10197,
10213,
10226,
10215,
10230,
10224,
10231,
10209,
10203,
10220,
10225,
10229,
10204,
10200,
10216,
10212,
10210,
10199,
10198,
10206,
10228,
10195,
10223,
10227,
10222,
10202,
10218,
10217,
10221,
10207,
10196,
-1,
10243,
10244,
10235,
10236,
10241,
10242,
10238,
10239,
10246,
10245,
-1,
-1,
-1,
-1,
10248,
10247,
]

_charnames_92880 = [
14932,
14945,
14955,
14961,
14957,
14935,
14948,
14951,
14944,
14958,
14960,
14937,
14952,
14947,
14950,
14962,
14940,
14954,
14963,
14953,
14936,
14956,
14938,
14964,
14941,
14942,
14939,
14933,
14931,
14959,
-1,
-1,
14971,
14968,
14972,
14967,
14970,
14973,
]

_charnames_92928 = [
21425,
21424,
21421,
21420,
21395,
21394,
21409,
21408,
21427,
21426,
21398,
21397,
21413,
21412,
21392,
21391,
21407,
21406,
21415,
21414,
21419,
21418,
21403,
21402,
21430,
21429,
21401,
21400,
21303,
21288,
21308,
21297,
21290,
21304,
21291,
21305,
21301,
21296,
21307,
21299,
21292,
21295,
21306,
21289,
21293,
21309,
21302,
21300,
21459,
21463,
21466,
21465,
21462,
21467,
21460,
21362,
21364,
21345,
21363,
21368,
21354,
21353,
21352,
21355,
21365,
21376,
21366,
21386,
21358,
21342,
]

_charnames_93008 = [
21441,
21442,
21433,
21434,
21439,
21440,
21436,
21437,
21444,
21443,
-1,
21451,
21454,
21449,
21456,
21455,
21450,
21452,
-1,
21367,
21356,
21383,
21371,
21384,
21382,
21380,
21357,
21379,
21387,
21370,
21375,
21372,
21385,
21377,
21348,
21344,
21340,
21341,
21346,
21347,
-1,
-1,
-1,
-1,
-1,
21314,
21322,
21328,
21329,
21333,
21319,
21331,
21335,
21316,
21315,
21334,
21320,
21332,
21326,
21336,
21323,
21313,
21318,
21325,
]

_charnames_93760 = [
8525,
8521,
8518,
8517,
8505,
8515,
8512,
8524,
8520,
8529,
8530,
8528,
8511,
8504,
8527,
8531,
8534,
8533,
8519,
8508,
8526,
8523,
8514,
8502,
8516,
8532,
8510,
8501,
8522,
8509,
8506,
8507,
8488,
8484,
8481,
8480,
8468,
8478,
8475,
8487,
8483,
8492,
8493,
8491,
8474,
8467,
8490,
8494,
8497,
8496,
8482,
8471,
8489,
8486,
8477,
8465,
8479,
8495,
8473,
8464,
8485,
8472,
8469,
8470,
8550,
8545,
8538,
8540,
8548,
8549,
8543,
8544,
8552,
8551,
8557,
8565,
8555,
8556,
8562,
8563,
8559,
8560,
8566,
8567,
8546,
8539,
8541,
8535,
8568,
8498,
8569,
]

_charnames_93952 = [
9807,
9816,
9749,
9806,
9810,
9809,
9781,
9820,
9801,
9800,
9716,
9774,
9747,
9748,
9714,
9773,
9727,
9729,
9750,
9779,
9723,
9722,
9793,
9792,
9791,
9790,
9713,
9772,
9712,
9771,
9819,
9798,
9751,
9804,
9803,
9726,
9725,
9778,
9813,
9817,
9797,
9796,
9707,
9766,
9720,
9719,
9708,
9768,
9745,
9752,
9762,
9786,
9785,
9740,
9738,
9710,
9769,
9746,
9787,
9741,
9739,
9736,
9734,
9780,
9735,
9733,
9818,
9782,
9812,
9815,
9784,
9767,
9715,
9709,
9763,
-1,
-1,
-1,
-1,
9884,
9728,
9885,
9882,
9883,
9842,
9850,
9849,
9843,
9844,
9858,
9863,
9869,
9868,
9851,
9854,
9855,
9860,
9822,
9823,
9824,
9825,
9826,
9832,
9830,
9828,
9829,
9833,
9834,
9835,
9836,
9837,
9841,
9839,
9865,
9867,
9845,
9846,
9853,
9871,
9852,
9870,
9848,
9856,
9847,
9862,
9872,
9873,
9838,
9866,
9864,
9861,
9874,
9831,
9857,
9827,
9840,
]

_charnames_94095 = [
9877,
9876,
9879,
9878,
9705,
9704,
9703,
9702,
9701,
9700,
9699,
9761,
9760,
9759,
9758,
9757,
9756,
]

_charnames_100352 = [
4168,
4167,
4166,
4165,
4164,
4163,
4162,
4161,
4160,
4158,
4157,
4156,
4155,
4154,
4153,
4152,
4151,
4150,
4149,
4147,
4146,
4145,
4144,
4143,
4142,
4141,
4140,
4139,
4138,
4136,
4135,
4134,
4133,
4132,
4131,
4130,
4129,
4128,
4127,
4125,
4124,
4123,
4122,
4121,
4120,
4119,
4118,
4117,
4116,
4114,
4113,
4112,
4111,
4110,
4109,
4108,
4107,
4106,
4105,
4103,
4102,
4101,
4100,
4099,
4098,
4097,
4096,
4095,
4094,
4092,
4091,
4090,
4089,
4088,
4087,
4086,
4085,
4084,
4083,
4081,
4080,
4079,
4078,
4077,
4076,
4075,
4074,
4073,
4072,
4070,
4069,
4068,
4067,
4066,
4065,
4064,
4063,
4062,
4061,
4058,
4057,
4056,
4055,
4054,
4053,
4052,
4051,
4050,
4049,
4047,
4046,
4045,
4044,
4043,
4042,
4041,
4040,
4039,
4038,
4036,
4035,
4034,
4033,
4032,
4031,
4030,
4029,
4028,
4027,
4025,
4024,
4023,
4022,
4021,
4020,
4019,
4018,
4017,
4016,
4014,
4013,
4012,
4011,
4010,
4009,
4008,
4007,
4006,
4005,
4003,
4002,
4001,
4000,
3999,
3998,
3997,
3996,
3995,
3994,
3992,
3991,
3990,
3989,
3988,
3987,
3986,
3985,
3984,
3983,
3981,
3980,
3979,
3978,
3977,
3976,
3975,
3974,
3973,
3972,
3970,
3969,
3968,
3967,
3966,
3965,
3964,
3963,
3962,
3961,
3959,
3958,
3957,
3956,
3955,
3954,
3953,
3952,
3951,
3950,
3947,
3946,
3945,
3944,
3943,
3942,
3941,
3940,
3939,
3938,
3936,
3935,
3934,
3933,
3932,
3931,
3930,
3929,
3928,
3927,
3925,
3924,
3923,
3922,
3921,
3920,
3919,
3918,
3917,
3916,
3914,
3913,
3912,
3911,
3910,
3909,
3908,
3907,
3906,
3905,
3903,
3902,
3901,
3900,
3899,
3898,
3897,
3896,
3895,
3894,
3892,
3891,
3890,
3889,
3888,
3887,
3886,
3885,
3884,
3883,
3881,
3880,
3879,
3878,
3877,
3876,
3875,
3874,
3873,
3872,
3870,
3869,
3868,
3867,
3866,
3865,
3864,
3863,
3862,
3861,
3859,
3858,
3857,
3856,
3855,
3854,
3853,
3852,
3851,
3850,
3848,
3847,
3846,
3845,
3844,
3843,
3842,
3841,
3840,
3839,
3836,
3835,
3834,
3833,
3832,
3831,
3830,
3829,
3828,
3827,
3825,
3824,
3823,
3822,
3821,
3820,
3819,
3818,
3817,
3816,
3814,
3813,
3812,
3811,
3810,
3809,
3808,
3807,
3806,
3805,
3803,
3802,
3801,
3800,
3799,
3798,
3797,
3796,
3795,
3794,
3792,
3791,
3790,
3789,
3788,
3787,
3786,
3785,
3784,
3783,
3781,
3780,
3779,
3778,
3777,
3776,
3775,
3774,
3773,
3772,
3770,
3769,
3768,
3767,
3766,
3765,
3764,
3763,
3762,
3761,
3759,
3758,
3757,
3756,
3755,
3754,
3753,
3752,
3751,
3750,
3748,
3747,
3746,
3745,
3744,
3743,
3742,
3741,
3740,
3739,
3737,
3736,
3735,
3734,
3733,
3732,
3731,
3730,
3729,
3728,
3725,
3724,
3723,
3722,
3721,
3720,
3719,
3718,
3717,
3716,
3714,
3713,
3712,
3711,
3710,
3709,
3708,
3707,
3706,
3705,
3703,
3702,
3701,
3700,
3699,
3698,
3697,
3696,
3695,
3694,
3692,
3691,
3690,
3689,
3688,
3687,
3686,
3685,
3684,
3683,
3681,
3680,
3679,
3678,
3677,
3676,
3675,
3674,
3673,
3672,
3670,
3669,
3668,
3667,
3666,
3665,
3664,
3663,
3662,
3661,
3659,
3658,
3657,
3656,
3655,
3654,
3653,
3652,
3651,
3650,
3648,
3647,
3646,
3645,
3644,
3643,
3642,
3641,
3640,
3639,
3637,
3636,
3635,
3634,
3633,
3632,
3631,
3630,
3629,
3628,
3626,
3625,
3624,
3623,
3622,
3621,
3620,
3619,
3618,
3617,
3614,
3613,
3612,
3611,
3610,
3609,
3608,
3607,
3606,
3605,
3603,
3602,
3601,
3600,
3599,
3598,
3597,
3596,
3595,
3594,
3592,
3591,
3590,
3589,
3588,
3587,
3586,
3585,
3584,
3583,
3581,
3580,
3579,
3578,
3577,
3576,
3575,
3574,
3573,
3572,
3570,
3569,
3568,
3567,
3566,
3565,
3564,
3563,
3562,
3561,
3559,
3558,
3557,
3556,
3555,
3554,
3553,
3552,
3551,
3550,
3548,
3547,
3546,
3545,
3544,
3543,
3542,
3541,
3540,
3539,
3537,
3536,
3535,
3534,
3533,
3532,
3531,
3530,
3529,
3528,
3526,
3525,
3524,
3523,
3522,
3521,
3520,
3519,
3518,
3517,
3515,
3514,
3513,
3512,
3511,
3510,
3509,
3508,
3507,
3506,
3503,
3502,
3501,
3500,
3499,
3498,
3497,
3496,
3495,
3494,
3492,
3491,
3490,
3489,
3488,
3487,
3486,
3485,
3484,
3483,
3481,
3480,
3479,
3478,
3477,
3476,
3475,
3474,
3473,
3472,
3470,
3469,
3468,
3467,
3466,
3465,
3464,
3463,
3462,
3461,
3459,
3458,
3457,
3456,
3455,
3454,
3453,
3452,
3451,
3450,
3448,
3447,
3446,
3445,
3444,
3443,
3442,
3441,
3440,
3439,
3437,
3436,
3435,
3434,
3433,
3432,
3431,
3430,
3429,
3428,
3426,
3425,
3424,
3423,
3422,
3421,
3420,
3419,
3418,
3417,
3415,
3414,
3413,
3412,
3411,
3410,
3409,
3408,
3407,
3406,
3404,
3403,
3402,
3401,
3400,
3399,
3398,
3397,
3396,
3395,
4224,
4223,
4222,
4221,
4220,
4219,
4218,
4217,
4216,
4215,
4213,
4212,
4211,
4210,
4209,
4208,
4207,
4206,
4205,
4204,
4202,
4201,
4200,
4199,
4198,
4197,
4196,
4195,
4194,
4193,
4191,
4190,
4189,
4188,
4187,
4186,
4185,
4184,
4183,
4182,
4180,
4179,
4178,
4177,
4176,
4175,
4174,
4173,
4172,
4171,
4231,
4230,
4229,
4228,
4227,
4226,
]

_charnames_110592 = [
24112,
20404,
19850,
19849,
19848,
19847,
19845,
19844,
19843,
19842,
19840,
19839,
19838,
19837,
19836,
19833,
19832,
19831,
19830,
19829,
19854,
19853,
19852,
19514,
19525,
19524,
19523,
19522,
19521,
19520,
19519,
19518,
19516,
19515,
19517,
19534,
19533,
19532,
19531,
19530,
19529,
19528,
19527,
19542,
19541,
19540,
19539,
19538,
19537,
19536,
19549,
19548,
19547,
19546,
19545,
19544,
19554,
19553,
19552,
19551,
19615,
19614,
19613,
19612,
19611,
19610,
19609,
19608,
19630,
19629,
19628,
19627,
19626,
19625,
19606,
19605,
19604,
19603,
19602,
19601,
19600,
19599,
19636,
19635,
19634,
19633,
19632,
19623,
19622,
19621,
19620,
19619,
19618,
19617,
19715,
19714,
19713,
19712,
19704,
19703,
19702,
19701,
19700,
19699,
19698,
19710,
19709,
19708,
19707,
19706,
19688,
19687,
19686,
19685,
19684,
19683,
19682,
19681,
19680,
19696,
19695,
19694,
19693,
19692,
19691,
19690,
19647,
19646,
19645,
19644,
19643,
19642,
19641,
19640,
19639,
19656,
19655,
19654,
19653,
19652,
19651,
19650,
19649,
19674,
19673,
19672,
19664,
19663,
19662,
19661,
19660,
19659,
19658,
19670,
19669,
19668,
19667,
19666,
19557,
19567,
19566,
19565,
19564,
19563,
19562,
19561,
19560,
19559,
19558,
19584,
19583,
19582,
19581,
19580,
19579,
19578,
19596,
19595,
19594,
19592,
19591,
19590,
19589,
19588,
19587,
19586,
19576,
19575,
19574,
19573,
19572,
19571,
19570,
19569,
19765,
19764,
19763,
19762,
19761,
19760,
19759,
19757,
19756,
19755,
19754,
19753,
19752,
19751,
19777,
19776,
19775,
19774,
19781,
19780,
19779,
19772,
19771,
19770,
19769,
19768,
19767,
19822,
19821,
19820,
19819,
19818,
19817,
19827,
19826,
19825,
19824,
19815,
19814,
19813,
19812,
19811,
19810,
19748,
19747,
19746,
19745,
19724,
19723,
19722,
19721,
19720,
19719,
19718,
19731,
19730,
19729,
19728,
19727,
19726,
19743,
19742,
19741,
19740,
19738,
19737,
19736,
19735,
19734,
19733,
19802,
19801,
19800,
19799,
19798,
19796,
19795,
19794,
19793,
19792,
19807,
19806,
19805,
19804,
19790,
19789,
19788,
19787,
19786,
19785,
19784,
19677,
19676,
]

_charnames_110960 = [
17776,
17775,
17774,
17773,
17772,
17771,
17770,
17769,
17768,
17767,
17766,
17765,
17764,
17763,
17762,
17761,
17759,
17758,
17757,
17756,
17755,
17754,
17753,
17752,
17751,
17750,
17749,
17748,
17747,
17746,
17745,
17744,
17742,
17741,
17740,
17739,
17738,
17737,
17736,
17735,
17734,
17733,
17732,
17731,
17730,
17729,
17728,
17727,
17725,
17724,
17723,
17722,
17721,
17720,
17719,
17718,
17717,
17716,
17715,
17714,
17713,
17712,
17711,
17710,
17708,
17707,
17706,
17705,
17704,
17703,
17702,
17701,
17700,
17699,
17698,
17697,
17696,
17695,
17694,
17693,
17691,
17690,
17689,
17688,
17687,
17686,
17685,
17684,
17683,
17682,
17681,
17680,
17679,
17678,
17677,
17676,
17674,
17673,
17672,
17671,
17670,
17669,
17668,
17667,
17666,
17665,
17664,
17663,
17662,
17661,
17660,
17659,
17657,
17656,
17655,
17654,
17653,
17652,
17651,
17650,
17649,
17648,
17647,
17646,
17645,
17644,
17643,
17642,
17640,
17639,
17638,
17637,
17636,
17635,
17634,
17633,
17632,
17631,
17630,
17629,
17628,
17627,
17626,
17625,
17609,
17608,
17607,
17606,
17605,
17604,
17603,
17602,
17601,
17600,
17599,
17598,
17597,
17596,
17595,
17594,
17592,
17591,
17590,
17589,
17588,
17587,
17586,
17585,
17584,
17583,
17582,
17581,
17580,
17579,
17578,
17577,
17575,
17574,
17573,
17572,
17571,
17570,
17569,
17568,
17567,
17566,
17565,
17564,
17563,
17562,
17561,
17560,
17558,
17557,
17556,
17555,
17554,
17553,
17552,
17551,
17550,
17549,
17548,
17547,
17546,
17545,
17544,
17543,
17541,
17540,
17539,
17538,
17537,
17536,
17535,
17534,
17533,
17532,
17531,
17530,
17529,
17528,
17527,
17526,
17524,
17523,
17522,
17521,
17520,
17519,
17518,
17517,
17516,
17515,
17514,
17513,
17512,
17511,
17510,
17509,
17507,
17506,
17505,
17504,
17503,
17502,
17501,
17500,
17499,
17498,
17497,
17496,
17495,
17494,
17493,
17492,
17490,
17489,
17488,
17487,
17486,
17485,
17484,
17483,
17482,
17481,
17480,
17479,
17478,
17477,
17476,
17475,
17473,
17472,
17471,
17470,
17469,
17468,
17467,
17466,
17465,
17464,
17463,
17462,
17461,
17460,
17459,
17458,
17456,
17455,
17454,
17453,
17452,
17451,
17450,
17449,
17448,
17447,
17446,
17445,
17444,
17443,
17442,
17441,
17439,
17438,
17437,
17436,
17435,
17434,
17433,
17432,
17431,
17430,
17429,
17428,
17427,
17426,
17425,
17424,
17422,
17421,
17420,
17419,
17418,
17417,
17416,
17415,
17414,
17413,
17412,
17411,
17410,
17409,
17408,
17407,
17405,
17404,
17403,
17402,
17401,
17400,
17399,
17398,
17397,
17396,
17395,
17394,
17393,
17392,
17391,
17390,
17388,
17387,
17386,
17385,
17384,
17383,
17382,
17381,
17380,
17379,
17378,
17377,
17376,
17375,
17374,
17373,
17371,
17370,
17369,
17368,
17367,
17366,
17365,
17364,
17363,
17362,
17361,
17360,
17359,
17358,
17357,
17356,
17622,
17621,
17620,
17619,
17618,
17617,
17616,
17615,
17614,
17613,
17612,
17611,
]

_charnames_113664 = [
23300,
23294,
23273,
23268,
23304,
23283,
23278,
23309,
23291,
23296,
23302,
23247,
23277,
23293,
23305,
23286,
23252,
23272,
23215,
23292,
23287,
23214,
23301,
23282,
23251,
23258,
23218,
23229,
23190,
23260,
23225,
23237,
23200,
23262,
23227,
23231,
23232,
23192,
23193,
23263,
23228,
23233,
23202,
23261,
23226,
23238,
23201,
23234,
23235,
23236,
23194,
23195,
23196,
23197,
23270,
23271,
23239,
23243,
23246,
23203,
23204,
23285,
23303,
23198,
23199,
23306,
23211,
23257,
23253,
23307,
23298,
23288,
23299,
23217,
23265,
23290,
23208,
23250,
23209,
23281,
23308,
23264,
23289,
23295,
23267,
23280,
23249,
23266,
23213,
23256,
23254,
23255,
23245,
23240,
23242,
23244,
23241,
23220,
23221,
23222,
23223,
23275,
23276,
23207,
23216,
23212,
23297,
-1,
-1,
-1,
-1,
-1,
23326,
23350,
23351,
23314,
23349,
23329,
23344,
23345,
23341,
23343,
23347,
23346,
23342,
-1,
-1,
-1,
23338,
23334,
23335,
23331,
23336,
23337,
23332,
23333,
23328,
]

_charnames_113808 = [
23320,
23322,
23323,
23316,
23324,
23325,
23317,
23321,
23313,
23319,
-1,
-1,
23353,
23352,
23355,
23354,
7234,
7236,
7235,
7233,
]

_charnames_119262 = [
10185,
10175,
10181,
10183,
10182,
10184,
10178,
10177,
10174,
10173,
10180,
]

_charnames_119296 = [
22268,
22285,
22296,
22295,
22279,
22294,
22293,
22292,
22291,
22278,
22277,
22276,
22275,
22274,
22273,
22272,
22271,
22270,
22269,
22290,
22289,
22288,
22287,
22286,
22284,
22283,
22282,
22281,
22280,
22236,
22244,
22228,
22251,
22265,
22264,
22243,
22242,
22241,
22240,
22239,
22238,
22237,
22250,
22249,
22248,
22247,
22246,
22245,
22263,
22262,
22261,
22260,
22259,
22258,
22235,
22234,
22233,
22232,
22231,
22230,
22229,
22256,
22255,
22254,
22253,
22252,
1667,
1668,
1669,
22361,
]

_charnames_119520 = [
9278,
9279,
9255,
9258,
9267,
9270,
9262,
9264,
9273,
9276,
9260,
9275,
9256,
9259,
9268,
9271,
9263,
9265,
9274,
9277,
]

_charnames_119552 = [
9652,
23473,
23472,
23467,
23466,
23464,
5301,
5338,
5370,
5381,
5390,
5288,
5365,
5386,
5379,
5311,
5307,
5397,
5393,
5363,
5333,
5290,
5395,
5384,
5341,
5367,
5332,
5329,
5324,
5400,
5289,
5319,
5313,
5300,
5312,
5380,
5361,
5377,
5297,
5389,
5353,
5349,
5362,
5337,
5330,
5375,
5331,
5357,
5320,
5347,
5356,
5318,
5360,
5334,
5342,
5398,
5291,
5371,
5322,
5399,
5306,
5298,
5355,
5354,
5372,
5368,
5323,
5314,
5383,
5350,
5392,
5310,
5315,
5305,
5321,
5351,
5348,
5396,
5294,
5299,
5343,
5366,
5293,
5387,
5308,
5376,
5340,
]

_charnames_119648 = [
2151,
2143,
2144,
2149,
2150,
2146,
2147,
2153,
2152,
2164,
2156,
2157,
2162,
2163,
2159,
2160,
2166,
2165,
25257,
25252,
25253,
25255,
25256,
5061,
5062,
]

_charnames_120832 = [
5606,
5838,
5819,
5958,
5872,
5927,
5697,
5850,
5707,
5696,
5699,
5685,
5689,
5849,
5608,
5840,
5649,
5646,
5647,
5690,
5687,
5611,
5624,
5623,
5621,
5619,
5626,
5843,
5744,
5698,
5629,
5845,
5652,
5650,
5640,
5648,
5692,
5693,
5688,
5651,
5632,
5634,
5636,
5637,
5711,
5614,
5616,
5617,
5736,
5677,
5620,
5627,
5618,
5622,
5729,
5672,
5727,
5728,
5683,
5684,
5674,
5633,
5639,
5638,
5732,
5733,
5734,
5678,
5785,
5790,
5789,
5787,
5788,
5868,
5772,
5907,
5776,
5799,
5783,
5801,
5784,
5802,
5782,
5827,
5828,
5908,
5959,
5778,
5780,
5781,
5773,
5808,
5797,
5805,
5803,
5807,
5806,
5796,
5792,
5793,
5794,
5795,
5859,
5862,
5866,
5863,
5924,
5911,
5813,
5811,
5816,
5825,
5818,
5829,
5817,
5826,
5833,
5831,
5836,
5950,
5953,
5956,
5954,
5887,
5891,
5870,
5909,
5890,
5899,
5892,
5910,
5900,
5901,
5925,
5642,
5846,
5882,
5936,
5893,
5645,
5644,
5883,
5746,
5749,
5750,
5751,
5757,
5706,
5856,
5957,
5942,
5758,
5759,
5753,
5754,
5897,
5756,
5896,
5941,
5940,
5755,
5857,
5895,
5939,
5653,
5847,
5884,
5902,
5937,
5628,
5844,
5770,
5903,
5949,
5765,
5767,
5768,
5858,
5955,
5948,
5761,
5764,
5763,
5769,
5766,
5923,
5695,
5848,
5835,
5921,
5922,
5920,
5823,
5885,
5934,
5933,
5743,
5904,
5737,
5854,
5741,
5738,
5918,
5735,
5742,
5740,
5852,
5834,
5830,
5905,
5945,
5946,
5943,
5853,
5864,
5865,
5916,
5917,
5914,
5886,
5655,
5878,
5658,
5659,
5660,
5663,
5664,
5662,
5680,
5681,
5675,
5671,
5670,
5867,
5669,
5673,
5821,
5822,
5879,
5880,
5874,
5877,
5931,
5932,
5929,
5700,
5721,
5715,
5716,
5717,
5722,
5710,
5713,
5712,
5704,
5719,
5705,
5708,
5720,
5604,
5771,
6329,
6330,
6331,
6578,
6579,
6580,
6514,
6515,
6516,
6564,
6565,
6566,
6399,
6400,
6401,
6523,
6524,
6510,
6506,
6511,
6507,
6508,
6482,
6478,
6483,
6479,
6480,
6512,
6246,
6245,
6247,
6249,
6244,
6243,
6248,
6095,
6215,
6038,
6039,
6036,
6037,
6040,
6075,
6074,
6072,
6073,
6011,
6070,
6069,
6067,
6068,
6056,
6057,
6058,
6003,
6005,
6006,
6004,
6008,
6009,
6010,
6052,
6053,
6054,
6084,
6085,
6086,
6088,
6089,
6090,
6293,
6294,
6295,
6297,
6298,
6299,
6304,
6302,
6303,
6301,
6237,
6238,
6235,
6236,
6232,
6233,
6230,
6231,
6227,
6228,
6225,
6226,
6222,
6223,
6220,
6221,
6172,
6173,
6170,
6171,
6174,
6196,
6195,
6193,
6194,
6116,
6191,
6190,
6189,
6188,
6202,
6113,
6114,
6115,
6117,
6199,
6200,
6201,
6204,
6205,
6206,
6208,
6209,
6210,
6312,
6313,
6314,
6308,
6309,
6310,
6315,
5992,
5993,
5990,
5991,
5984,
5985,
5982,
5983,
5996,
5997,
6063,
6064,
6065,
6043,
6048,
6049,
6044,
6020,
6021,
6022,
6016,
6017,
6018,
5998,
6000,
6001,
6355,
6359,
6367,
6041,
5987,
6061,
6046,
6028,
6357,
6361,
6365,
5988,
6062,
6047,
6029,
6358,
6362,
6366,
6024,
6025,
6026,
6105,
6106,
6162,
6165,
6161,
6164,
6145,
6148,
6146,
6149,
6125,
6126,
6372,
6376,
6380,
6102,
6103,
6157,
6158,
6155,
6156,
6138,
6141,
6139,
6142,
6122,
6123,
6371,
6375,
6379,
6109,
6110,
6107,
6108,
6111,
6166,
6150,
6128,
6129,
6130,
6369,
6373,
6377,
6175,
6078,
6081,
6079,
6082,
6178,
6181,
6184,
6179,
6182,
6185,
6031,
6032,
6132,
6133,
6093,
6094,
6213,
6214,
6533,
6534,
6538,
6531,
6535,
6536,
6529,
6530,
6539,
6537,
5961,
5973,
5967,
5966,
5970,
5968,
5971,
5972,
6500,
6498,
6499,
6434,
6435,
6436,
6543,
6545,
6544,
6542,
6495,
6496,
6494,
6427,
6426,
6428,
6439,
6440,
6424,
6422,
6425,
6421,
6441,
6430,
6432,
6431,
6406,
6408,
6409,
6414,
6416,
6417,
6411,
6418,
6412,
6557,
6558,
6556,
6350,
6348,
6349,
6443,
6551,
6552,
6549,
6550,
6575,
6572,
6576,
6573,
6568,
6569,
6265,
6266,
6267,
6273,
6275,
6276,
6281,
6283,
6284,
6262,
6261,
6260,
6256,
6259,
6258,
6252,
6255,
6254,
6277,
6280,
6279,
6269,
6272,
6271,
6460,
6459,
6458,
6268,
6286,
6287,
6324,
6326,
6320,
6319,
6327,
6325,
6322,
6323,
6338,
6345,
6341,
6342,
6343,
6344,
6346,
6096,
6216,
6553,
5960,
6442,
6519,
6520,
6581,
6484,
6521,
6334,
6335,
6336,
6582,
6455,
6454,
6453,
6452,
6451,
6450,
6449,
6448,
6492,
6471,
6472,
6464,
6466,
6469,
6465,
6467,
6468,
6560,
6501,
6525,
6561,
6583,
]

_charnames_121499 = [
6491,
6490,
6489,
6488,
6487,
-1,
6397,
6396,
6395,
6394,
6393,
6392,
6391,
6390,
6389,
6388,
6387,
6386,
6385,
6384,
6383,
]

_charnames_122880 = [
1642,
1628,
1630,
1640,
1625,
1599,
1616,
-1,
1617,
1607,
1608,
1603,
1626,
1638,
1637,
1636,
1635,
1634,
1633,
1632,
1614,
1619,
1631,
1622,
1639,
-1,
-1,
1611,
1620,
1641,
1612,
1597,
1598,
1602,
-1,
1600,
1613,
-1,
1601,
1605,
1629,
1606,
1623,
]

_charnames_123136 = [
18327,
18312,
18300,
18313,
18328,
18309,
18316,
18307,
18349,
18344,
18342,
18337,
18308,
18299,
18345,
18334,
18304,
18305,
18340,
18298,
18311,
18348,
18319,
18343,
18338,
18306,
18322,
18315,
18303,
18333,
18302,
18329,
18326,
18321,
18347,
18318,
18335,
18336,
18346,
18341,
18323,
18324,
18330,
18331,
18339,
-1,
-1,
-1,
18372,
18368,
18369,
18366,
18367,
18370,
18371,
18377,
18376,
18378,
18380,
18379,
18381,
18382,
-1,
-1,
18361,
18362,
18353,
18354,
18359,
18360,
18356,
18357,
18364,
18363,
-1,
-1,
-1,
-1,
18350,
18383,
]

_charnames_123584 = [
24287,
24286,
24336,
24335,
24334,
24332,
24306,
24313,
24317,
24303,
24314,
24296,
24295,
24333,
24311,
24310,
24330,
24325,
24326,
24327,
24320,
24297,
24290,
24328,
24329,
24319,
24331,
24323,
24321,
24302,
24307,
24316,
24293,
24294,
24299,
24289,
24291,
24322,
24298,
24324,
24288,
24301,
24308,
24305,
24352,
24353,
24354,
24355,
24347,
24348,
24339,
24340,
24345,
24346,
24342,
24343,
24350,
24349,
-1,
-1,
-1,
-1,
-1,
24356,
]

_charnames_124928 = [
8161,
8160,
8159,
8091,
8058,
8079,
8110,
8175,
8158,
8157,
8156,
8233,
8242,
8246,
8113,
8266,
8214,
8095,
8109,
8219,
8155,
8154,
8153,
8098,
8059,
8202,
8164,
8151,
8150,
8149,
8206,
8056,
8258,
8220,
8148,
8147,
8146,
8192,
8261,
8190,
8210,
8221,
8227,
8223,
8265,
8176,
8142,
8140,
8139,
8193,
8244,
8222,
8076,
8264,
8135,
8134,
8133,
8070,
8082,
8103,
8203,
8250,
8145,
8144,
8143,
8065,
8173,
8172,
8138,
8137,
8136,
8062,
8102,
8257,
8087,
8132,
8131,
8129,
8199,
8247,
8195,
8093,
8179,
8128,
8127,
8126,
8252,
8074,
8216,
8238,
8125,
8124,
8123,
8077,
8080,
8225,
8066,
8263,
8260,
8122,
8121,
8120,
8243,
8186,
8178,
8117,
8167,
8118,
8057,
8116,
8217,
8071,
8231,
8104,
8228,
8067,
8105,
8267,
8112,
8063,
8115,
8072,
8245,
8211,
8200,
8239,
8197,
8232,
8068,
8255,
8170,
8201,
8249,
8187,
8270,
8189,
8188,
8169,
8100,
8177,
8088,
8054,
8107,
8073,
8106,
8259,
8090,
8212,
8094,
8237,
8111,
8165,
8083,
8182,
8180,
8166,
8194,
8256,
8215,
8226,
8061,
8081,
8114,
8253,
8248,
8198,
8235,
8101,
8209,
8060,
8254,
8084,
8085,
8183,
8236,
8230,
8234,
8269,
8241,
8089,
8092,
8204,
8268,
8208,
8224,
8171,
8168,
8205,
8181,
8069,
8213,
8078,
8191,
8099,
8184,
8055,
8096,
-1,
-1,
8281,
8273,
8274,
8279,
8280,
8276,
8277,
8283,
8282,
8290,
8288,
8293,
8291,
8289,
8294,
8295,
]

_charnames_125184 = [
17007,
16986,
17000,
16999,
16989,
16979,
16997,
16988,
16995,
17005,
17004,
17002,
16998,
16985,
16976,
16991,
16969,
16974,
16977,
16993,
17001,
17006,
17003,
16996,
16983,
16968,
16994,
16970,
16992,
16973,
16982,
16990,
16972,
16980,
17050,
17029,
17043,
17042,
17032,
17022,
17040,
17031,
17038,
17048,
17047,
17045,
17041,
17028,
17019,
17034,
17012,
17017,
17020,
17036,
17044,
17049,
17046,
17039,
17026,
17011,
17037,
17013,
17035,
17016,
17025,
17033,
17015,
17023,
17076,
17074,
17072,
17075,
17008,
17073,
17066,
17067,
-1,
-1,
-1,
-1,
17061,
17062,
17053,
17054,
17059,
17060,
17056,
17057,
17064,
17063,
-1,
-1,
-1,
-1,
17070,
17069,
]

_charnames_126065 = [
25079,
25011,
25018,
25041,
25048,
25027,
25033,
25073,
25067,
25024,
25015,
25022,
25045,
25052,
25028,
25034,
25074,
25068,
25082,
25014,
25021,
25044,
25051,
25032,
25038,
25078,
25072,
25081,
25013,
25020,
25043,
25050,
25031,
25037,
25077,
25071,
25025,
25016,
25023,
25046,
25053,
25029,
25035,
25075,
25069,
25088,
25089,
25099,
25090,
25091,
25064,
25056,
25057,
25062,
25063,
25059,
25060,
25066,
25065,
25098,
25094,
25095,
25096,
25097,
25087,
25085,
25086,
25100,
]

_charnames_126209 = [
21175,
21120,
21127,
21150,
21157,
21136,
21142,
21169,
21163,
21133,
21124,
21131,
21154,
21161,
21137,
21143,
21170,
21164,
21178,
21123,
21130,
21153,
21160,
21141,
21147,
21174,
21168,
21177,
21122,
21129,
21152,
21159,
21140,
21146,
21173,
21167,
21134,
21125,
21132,
21155,
21162,
21138,
21144,
21171,
21165,
21199,
21181,
21185,
21191,
21193,
21187,
21189,
21195,
21194,
21183,
21192,
21188,
21182,
21184,
21198,
21197,
]

_charnames_126464 = [
16481,
16493,
16489,
16347,
-1,
16484,
16472,
16490,
16466,
16483,
16479,
16385,
16488,
16487,
16418,
16482,
16492,
16419,
16486,
16485,
16417,
16470,
16468,
16478,
16469,
16348,
16473,
16491,
16345,
16343,
16344,
16342,
-1,
16443,
16439,
-1,
16432,
-1,
-1,
16433,
-1,
16434,
16430,
16438,
16437,
16436,
16423,
16444,
16441,
16424,
16435,
-1,
16422,
16427,
16426,
16429,
-1,
16442,
-1,
16440,
-1,
-1,
-1,
-1,
-1,
-1,
16462,
-1,
-1,
-1,
-1,
16463,
-1,
16457,
-1,
16460,
-1,
16459,
16450,
16465,
-1,
16451,
16458,
-1,
16449,
-1,
-1,
16461,
-1,
16456,
-1,
16464,
-1,
16455,
-1,
16454,
-1,
16415,
16412,
-1,
16405,
-1,
-1,
16406,
16391,
16408,
16403,
-1,
16411,
16410,
16394,
16416,
16414,
16395,
16409,
-1,
16393,
16390,
16389,
16402,
-1,
16400,
16407,
16413,
16399,
-1,
16398,
-1,
16371,
16384,
16381,
16368,
16365,
16374,
16362,
16366,
16356,
16373,
-1,
16379,
16378,
16377,
16359,
16372,
16383,
16360,
16376,
16375,
16358,
16355,
16353,
16380,
16354,
16369,
16363,
16382,
-1,
-1,
-1,
-1,
-1,
16339,
16335,
16325,
-1,
16328,
16322,
16336,
16316,
16327,
-1,
16333,
16332,
16331,
16319,
16340,
16338,
16320,
16330,
16329,
16318,
16315,
16313,
16334,
16314,
16326,
16323,
16337,
]

_charnames_126976 = [
8902,
8859,
8906,
8895,
8910,
8913,
8905,
8886,
8864,
8869,
8875,
8880,
8850,
8855,
8900,
8893,
8887,
8865,
8870,
8876,
8881,
8851,
8856,
8901,
8894,
8885,
8863,
8868,
8874,
8879,
8849,
8854,
8899,
8892,
8911,
8888,
8908,
8914,
8858,
8857,
8915,
8904,
8912,
8909,
-1,
-1,
-1,
-1,
23015,
23014,
23013,
23012,
23011,
23010,
23009,
23008,
23006,
23005,
23004,
23003,
23002,
23001,
23000,
22998,
22997,
22996,
22995,
22994,
22993,
22992,
22990,
22989,
22988,
22987,
22986,
22985,
22984,
22982,
22981,
22980,
22979,
22978,
22977,
22976,
22974,
22973,
22972,
22971,
22970,
22969,
22968,
22966,
22965,
22964,
22963,
22962,
22961,
22960,
22956,
22955,
22954,
22953,
22952,
22951,
22950,
22949,
22947,
22946,
22945,
22944,
22943,
22942,
22941,
22939,
22938,
22937,
22936,
22935,
22934,
22933,
22931,
22930,
22929,
22928,
22927,
22926,
22925,
22923,
22922,
22921,
22920,
22919,
22918,
22917,
22915,
22914,
22913,
22912,
22911,
22910,
22909,
22907,
22906,
22905,
22904,
22903,
22902,
22901,
]

_charnames_127136 = [
21942,
21936,
21866,
21871,
21883,
21889,
21895,
21900,
21931,
21921,
21876,
21926,
21906,
21916,
21911,
-1,
-1,
21937,
21867,
21872,
21884,
21890,
21896,
21901,
21932,
21922,
21877,
21927,
21907,
21917,
21912,
21944,
-1,
21938,
21868,
21873,
21885,
21891,
21897,
21902,
21933,
21923,
21878,
21928,
21908,
21918,
21913,
21941,
-1,
21939,
21869,
21874,
21886,
21892,
21898,
21903,
21934,
21924,
21879,
21929,
21909,
21919,
21914,
21943,
21887,
21844,
21855,
21864,
21863,
21862,
21861,
21860,
21859,
21858,
21854,
21853,
21852,
21851,
21850,
21849,
21848,
21847,
21846,
21845,
21857,
21856,
]

_charnames_127232 = [
23449,
23450,
23460,
23452,
23453,
23458,
23459,
23455,
23456,
23462,
23461,
23498,
23497,
-1,
-1,
-1,
21569,
21568,
21567,
21566,
21565,
21564,
21563,
21562,
21561,
21560,
21559,
21558,
21557,
21556,
21555,
21554,
21553,
21552,
21551,
21550,
21549,
21548,
21547,
21546,
21545,
21544,
5503,
3317,
3316,
3340,
3345,
2138,
7565,
7564,
7563,
7562,
7561,
7560,
7559,
7558,
7557,
7556,
7555,
7554,
7553,
7552,
7551,
7550,
7549,
7548,
7547,
7546,
7545,
7544,
7543,
7542,
7541,
7540,
7589,
7618,
7580,
7576,
7617,
7616,
18091,
18090,
18089,
18088,
18087,
18086,
18085,
18084,
18083,
18082,
18081,
18080,
18079,
18078,
18077,
18076,
18075,
18074,
18073,
18072,
18071,
18070,
18069,
18068,
18067,
18066,
24967,
24966,
24965,
-1,
-1,
-1,
18057,
18056,
18055,
18054,
18053,
18052,
18051,
18050,
18049,
18048,
18047,
18046,
18045,
18044,
18043,
18042,
18041,
18040,
18039,
18038,
18037,
18036,
18035,
18034,
18033,
18032,
3359,
18061,
18060,
18059,
18063,
18058,
7632,
7536,
7535,
7597,
7619,
7615,
7614,
7612,
7577,
7608,
7605,
7603,
7575,
7601,
7595,
7620,
7598,
7574,
7602,
7578,
7611,
7566,
7592,
7591,
7590,
7571,
7579,
7609,
7606,
]

_charnames_127462 = [
24665,
24664,
24663,
24662,
24661,
24660,
24659,
24658,
24657,
24656,
24655,
24654,
24653,
24652,
24651,
24650,
24649,
24648,
24647,
24646,
24645,
24644,
24643,
24642,
24641,
24640,
7639,
7585,
7584,
]

_charnames_127504 = [
7500,
7492,
7489,
7586,
7526,
7483,
7531,
7482,
7525,
7512,
7520,
7506,
7479,
7490,
7495,
7505,
7480,
7517,
7516,
7530,
7493,
7485,
7510,
7498,
7508,
7524,
7523,
7534,
7491,
7527,
7488,
7509,
7529,
7499,
7519,
7518,
7486,
7511,
7502,
7503,
7515,
7478,
7494,
7533,
-1,
-1,
-1,
-1,
5491,
5502,
5501,
5498,
5496,
5493,
5495,
5499,
5492,
]

_charnames_127744 = [
3066,
25374,
3282,
18533,
7749,
7748,
3352,
7753,
24980,
15173,
24362,
19508,
9899,
13696,
13695,
13694,
22761,
18023,
24375,
25334,
24374,
25414,
24358,
11806,
24359,
3377,
18022,
25333,
11805,
25413,
7751,
22759,
7248,
5486,
15288,
24424,
24428,
24426,
24427,
3288,
3287,
3289,
3286,
25373,
24555,
20379,
5067,
15539,
2521,
7993,
13737,
23439,
21633,
2809,
20378,
5551,
2516,
24954,
20418,
7754,
15357,
13701,
13700,
20056,
25361,
9300,
25313,
12049,
10191,
5520,
17322,
22477,
8723,
24366,
4233,
12052,
14985,
22111,
24705,
22377,
22070,
22069,
2517,
7888,
20346,
7982,
8724,
22086,
24831,
24832,
2185,
1573,
7892,
7937,
15184,
25408,
24960,
23524,
21279,
7761,
25410,
25348,
7023,
7227,
25261,
23169,
2184,
2532,
2653,
12144,
1586,
20388,
7243,
15604,
22092,
2183,
25366,
5442,
7469,
24557,
2190,
5574,
15621,
3300,
15002,
25367,
15550,
22103,
24812,
24588,
15625,
25557,
2534,
25318,
25325,
25326,
14851,
21579,
2173,
4234,
3360,
22112,
25554,
2716,
24554,
9682,
8014,
22478,
20035,
15582,
9900,
24706,
10189,
7899,
12050,
2176,
15613,
15612,
25344,
17078,
2717,
25421,
24947,
25347,
9889,
9693,
3353,
20042,
16790,
5509,
3350,
5281,
3294,
22059,
19499,
23500,
7990,
15628,
22892,
15573,
25382,
10190,
10165,
7466,
22874,
10188,
5578,
19502,
10187,
24898,
5438,
8034,
14975,
2522,
8022,
24899,
7764,
7924,
5575,
20368,
17334,
24907,
8041,
24578,
22884,
24986,
24987,
3375,
19507,
25353,
25263,
5064,
8023,
2803,
15615,
15540,
20373,
3351,
23441,
3295,
23428,
23429,
18289,
7882,
20372,
20374,
21278,
25551,
13729,
20389,
14978,
17319,
20381,
12138,
2180,
8013,
23442,
25308,
25264,
25555,
13730,
24491,
15345,
24369,
24371,
24955,
15302,
11808,
15014,
15574,
17333,
13657,
13656,
13655,
13654,
13653,
24994,
9669,
21273,
24365,
2186,
5277,
12051,
24991,
2795,
23509,
3368,
24499,
8026,
8025,
20366,
24995,
22881,
7261,
9659,
24957,
2529,
23016,
22114,
15587,
13648,
21270,
7928,
15492,
16288,
20387,
11810,
25346,
5573,
15356,
5549,
20339,
15001,
25401,
15626,
22064,
24168,
22106,
23508,
14996,
23185,
9670,
2187,
5278,
24992,
2796,
23510,
7923,
20369,
9660,
23096,
22117,
25402,
20345,
24575,
15610,
21653,
22116,
21657,
2528,
13718,
13717,
13690,
18525,
9671,
5519,
24495,
24448,
24451,
24488,
25349,
24370,
21276,
5482,
5483,
3293,
21238,
3366,
24566,
13719,
18147,
5594,
25563,
23513,
24166,
15634,
24567,
22126,
20301,
22087,
8841,
17342,
20409,
24565,
24568,
25372,
15533,
15532,
15579,
22887,
8726,
24563,
25319,
8838,
5588,
5586,
22101,
24569,
15174,
22042,
8833,
8832,
20907,
20906,
14998,
2178,
22029,
25552,
25553,
22894,
15003,
13715,
16961,
25208,
8031,
25202,
22877,
23525,
11103,
18292,
25307,
20349,
15008,
7853,
22119,
24163,
12137,
24826,
22627,
24156,
15581,
2167,
24583,
15614,
15179,
5589,
7935,
22493,
20037,
15353,
22375,
25817,
22127,
20036,
24690,
20038,
23484,
13646,
16301,
15584,
7972,
2192,
7938,
23505,
23522,
22120,
25395,
23491,
7917,
5485,
24481,
20426,
9657,
1574,
20005,
3378,
14980,
14983,
14982,
14981,
9656,
2403,
8004,
22055,
15171,
9896,
25383,
21241,
23534,
25340,
21236,
21641,
21643,
2806,
5441,
2710,
2402,
2404,
15007,
3301,
22129,
24944,
21658,
7887,
5556,
15577,
12054,
18517,
18518,
3284,
21239,
22376,
15354,
21222,
15578,
18290,
8007,
8722,
5431,
21645,
25316,
7462,
22131,
2520,
21268,
25207,
21659,
13741,
25205,
13686,
3281,
3280,
21232,
21233,
22095,
22096,
18028,
9685,
9687,
19503,
9688,
18514,
16297,
2801,
2802,
19500,
5434,
24989,
19501,
25343,
22105,
22034,
5592,
3273,
3274,
3277,
16296,
12130,
20413,
7912,
7908,
7911,
7910,
14927,
13645,
11944,
24810,
12135,
3283,
24135,
12131,
21237,
15617,
15619,
15576,
10920,
24990,
14994,
13683,
21257,
7031,
5510,
18513,
24151,
25192,
25190,
25194,
25193,
25191,
25323,
13644,
24587,
20341,
17780,
20391,
22121,
9888,
5435,
3373,
6783,
25550,
5560,
15266,
24433,
11765,
11753,
11744,
11752,
7964,
7965,
25617,
23152,
25615,
23151,
12126,
25627,
3338,
3363,
3362,
18524,
18523,
7859,
24454,
19975,
3382,
21275,
23183,
24134,
9691,
7856,
8297,
15572,
3267,
3234,
3240,
3254,
3257,
3247,
3250,
3264,
3270,
3243,
3261,
3237,
3266,
3233,
3239,
3253,
3256,
3246,
3249,
3263,
3269,
3242,
3260,
3236,
24778,
24781,
24780,
15537,
15538,
24827,
15575,
2654,
8840,
15275,
18505,
20385,
8836,
7976,
23527,
7931,
7932,
25561,
8837,
11907,
5432,
24795,
24470,
15323,
5433,
3296,
14995,
7881,
13685,
25392,
22065,
10919,
15346,
12121,
12125,
12123,
12122,
12124,
11934,
5544,
24971,
24674,
24670,
24671,
24675,
24677,
24970,
24447,
6714,
6713,
6719,
6718,
15310,
15301,
6712,
6715,
6717,
6720,
15335,
15283,
15339,
23432,
24154,
5463,
22026,
22107,
15341,
24464,
7022,
5066,
24558,
21254,
5590,
5464,
5567,
20623,
20347,
8009,
22027,
25317,
21242,
23180,
23181,
23182,
25405,
25404,
25406,
15348,
25376,
21235,
2711,
2712,
25341,
13664,
13666,
13667,
18516,
18520,
18521,
13670,
13668,
13669,
23178,
21638,
21644,
24376,
7929,
7930,
23431,
9895,
9305,
21259,
3275,
2650,
25204,
23440,
1923,
20904,
24948,
21642,
7902,
23519,
11102,
7913,
5452,
5451,
5450,
5449,
11917,
24782,
5587,
5461,
11927,
24793,
11924,
24790,
9684,
11100,
11099,
14846,
14850,
14847,
14849,
14844,
11098,
14845,
24573,
9668,
5521,
7875,
6785,
9692,
22481,
22485,
25285,
7949,
7952,
7953,
7951,
7957,
7955,
24556,
7944,
25304,
24707,
7956,
7948,
7961,
18140,
13716,
25677,
25294,
22063,
2171,
2172,
24158,
25305,
24160,
24161,
25279,
25281,
25282,
23487,
24572,
16300,
22084,
3371,
22056,
25298,
23488,
25400,
16299,
25423,
24581,
7975,
5180,
22488,
12142,
25273,
20425,
25276,
25303,
17327,
25397,
7973,
23492,
25301,
25291,
22487,
2799,
7959,
7960,
2798,
24162,
22085,
3372,
24582,
7981,
7980,
25626,
25296,
25297,
25278,
22054,
7994,
20039,
7914,
20348,
22050,
22051,
22044,
22046,
18484,
7003,
18494,
7013,
5538,
5528,
5539,
5529,
18483,
7002,
18493,
7012,
19988,
19955,
19991,
19958,
18485,
7004,
18495,
7014,
19989,
19956,
19992,
19959,
20383,
20384,
7025,
7026,
11884,
25610,
24763,
23142,
8008,
19966,
11101,
19977,
19985,
8038,
7456,
7457,
7458,
20031,
7459,
19964,
19461,
19470,
2523,
24689,
24958,
20055,
7893,
24983,
20407,
20408,
5569,
8717,
11095,
7876,
5563,
5564,
15530,
21249,
5576,
15534,
9897,
17335,
25329,
22099,
21247,
5065,
21246,
17318,
21250,
24697,
23434,
16791,
5566,
9653,
9665,
7760,
9666,
17243,
7254,
24956,
7916,
20361,
19480,
2179,
22100,
5557,
23184,
18508,
7967,
18512,
22128,
23186,
22091,
18526,
15632,
18511,
15631,
9667,
22073,
18506,
2526,
8296,
24570,
24695,
15000,
5522,
24364,
7247,
14925,
14926,
21651,
1585,
15011,
11929,
5558,
22032,
3318,
15580,
22888,
2168,
7974,
7246,
15618,
15622,
21945,
21271,
7245,
7897,
21646,
20416,
]

_charnames_128736 = [
20343,
7256,
21277,
9677,
24982,
9676,
25618,
25619,
25616,
7966,
18501,
17344,
17345,
-1,
-1,
-1,
7461,
21248,
23501,
21649,
8012,
9675,
2655,
7977,
25391,
8035,
17320,
-1,
-1,
-1,
-1,
-1,
16941,
16837,
16954,
16955,
16939,
16826,
16824,
16825,
16822,
16823,
16887,
16890,
16889,
16804,
16904,
16883,
16914,
16917,
16916,
16857,
16806,
16944,
16892,
16893,
16872,
16873,
16951,
16817,
16934,
16935,
16849,
16868,
16855,
16936,
16801,
16847,
16848,
16856,
16808,
16799,
16894,
16908,
16948,
16835,
16802,
16809,
16800,
16891,
16866,
16867,
16860,
16864,
16863,
16862,
16828,
16829,
16919,
16810,
16834,
16869,
16870,
16832,
16884,
16909,
16910,
16942,
16875,
16878,
16877,
16830,
16953,
16815,
16907,
16950,
16938,
16897,
16852,
16911,
16851,
16818,
16853,
16912,
16814,
16947,
16816,
16952,
16923,
16833,
16899,
16882,
16898,
16836,
16812,
16813,
16803,
16903,
16931,
16929,
16930,
16902,
16901,
16840,
16845,
16844,
16843,
16842,
16831,
16881,
16880,
16871,
16922,
16945,
16932,
16918,
16926,
16925,
]

_charnames_128896 = [
15308,
15332,
15299,
15280,
15273,
8593,
15554,
20015,
19466,
13709,
24422,
24943,
15318,
15272,
11094,
8584,
15553,
20013,
19465,
13708,
24431,
24432,
7642,
15320,
15328,
15258,
24440,
24441,
23483,
15319,
15327,
15257,
24456,
5477,
11096,
8595,
15558,
19473,
19471,
13713,
5476,
11093,
8577,
15557,
19965,
19463,
13712,
11086,
8582,
15559,
20026,
19472,
13714,
11092,
8574,
15556,
19961,
19462,
13711,
11097,
8590,
15560,
19998,
19468,
11090,
8588,
5462,
8587,
11083,
8581,
25360,
8580,
24686,
11087,
20027,
8575,
19962,
6784,
8591,
19997,
19469,
19996,
11089,
20021,
20020,
3346,
18092,
3347,
18093,
]

_charnames_128992 = [
11745,
11759,
11771,
11768,
11756,
11764,
11751,
11743,
11758,
11770,
11767,
11755,
]

_charnames_129024 = [
11861,
25591,
24741,
23125,
11864,
25594,
24744,
23128,
11865,
25595,
24745,
23129,
-1,
-1,
-1,
-1,
11862,
25592,
24742,
23126,
11866,
25596,
24746,
23130,
19973,
20018,
20024,
20004,
19972,
20017,
20023,
20003,
11828,
25577,
24724,
23110,
11829,
25578,
24725,
23111,
11831,
25581,
24727,
23114,
11830,
25579,
24726,
23112,
11827,
25576,
24723,
23109,
11891,
25611,
24770,
23143,
11881,
25602,
24760,
23133,
11895,
25612,
24774,
23144,
11887,
25605,
24766,
23136,
11888,
25606,
24767,
23137,
]

_charnames_129104 = [
11882,
25603,
24761,
23134,
18489,
18499,
7018,
7008,
11912,
25623,
-1,
-1,
-1,
-1,
-1,
-1,
24543,
24531,
24537,
24549,
24519,
24525,
24512,
24506,
24545,
24533,
24539,
24551,
24521,
24527,
24514,
24508,
24542,
24530,
24536,
24548,
24518,
24524,
24511,
24505,
24544,
24532,
24538,
24550,
24520,
24526,
24513,
24507,
24541,
24529,
24535,
24547,
24517,
24523,
24510,
24504,
]

_charnames_129168 = [
11836,
25586,
24732,
23120,
11892,
25599,
24771,
23141,
11863,
25593,
24743,
23127,
19980,
19984,
19983,
19982,
11878,
24757,
11850,
24734,
11894,
24764,
11885,
24773,
11879,
24758,
11890,
24769,
24494,
24493,
]

_charnames_129280 = [
3337,
3336,
3334,
11904,
11903,
11902,
11905,
11899,
23148,
23146,
23149,
23147,
-1,
24461,
15177,
22113,
25794,
9658,
25284,
18144,
5478,
25299,
24959,
20427,
6584,
2805,
24978,
11941,
24807,
20302,
20303,
25265,
25293,
3290,
18288,
24949,
23507,
12115,
25306,
8027,
25277,
22484,
22486,
25300,
7998,
7947,
25275,
7249,
22014,
15182,
21635,
8001,
22028,
8835,
9679,
7258,
22052,
25560,
25422,
9624,
24586,
24363,
20300,
23495,
24559,
23511,
3299,
5550,
7921,
22882,
24833,
25336,
8003,
5479,
15585,
9163,
1577,
11811,
7024,
25393,
3367,
17314,
1588,
14997,
22090,
2714,
15010,
22374,
7229,
7898,
13364,
22757,
22071,
24164,
21654,
23356,
25369,
5059,
2531,
15571,
1580,
2189,
15180,
22122,
22013,
1587,
7460,
2656,
12048,
8842,
9683,
15012,
7946,
25818,
-1,
25288,
25295,
21265,
25409,
-1,
-1,
-1,
25287,
7467,
11809,
22885,
20417,
25387,
3379,
11106,
8011,
5548,
25674,
13703,
23357,
14854,
7163,
21274,
25375,
15536,
23443,
22883,
11104,
25002,
7259,
7648,
22889,
25792,
20057,
7373,
5595,
3374,
24133,
12152,
22068,
20415,
21586,
24988,
12145,
9690,
9890,
15015,
8039,
-1,
-1,
7989,
21200,
21223,
8030,
25388,
21272,
-1,
-1,
-1,
22875,
22033,
13660,
13661,
13662,
13659,
15586,
12053,
25371,
5517,
7758,
7756,
7464,
13702,
9678,
8839,
8720,
8719,
2519,
1583,
7468,
15620,
22891,
21256,
25314,
24377,
15535,
9298,
25260,
-1,
-1,
7880,
24169,
23444,
25290,
17080,
2525,
20908,
15609,
22045,
22048,
22053,
22049,
9304,
25320,
19140,
8459,
13649,
22626,
25793,
15167,
21221,
15629,
8016,
22760,
2194,
7028,
24704,
25330,
25562,
5443,
22072,
23535,
1924,
17349,
25328,
5518,
15175,
9303,
12151,
12143,
7922,
14853,
7465,
5444,
15178,
14974,
24950,
15006,
7925,
24699,
18287,
18110,
18126,
18122,
18134,
18100,
18130,
24392,
15199,
18109,
24399,
24413,
24410,
24421,
24391,
24416,
15206,
15220,
15217,
15228,
15198,
15223,
18113,
18129,
18125,
18137,
18108,
18133,
24390,
15197,
18107,
24403,
24405,
24404,
24407,
24402,
24406,
15210,
15212,
15211,
15214,
15209,
15213,
18117,
18119,
18118,
18121,
18116,
18120,
24387,
15194,
18104,
24398,
24412,
24409,
24420,
24388,
24415,
15205,
15219,
15216,
15227,
15195,
15222,
18112,
18128,
18124,
18136,
18105,
18132,
24389,
15196,
18106,
24417,
15224,
18138,
24418,
15225,
18139,
24395,
24394,
24396,
15202,
15201,
15203,
]

_charnames_129632 = [
25803,
25801,
25804,
25802,
25798,
25799,
25800,
25812,
25810,
25813,
25811,
25807,
25808,
25809,
-1,
-1,
14852,
21255,
15170,
7242,
-1,
-1,
-1,
-1,
23506,
17081,
7894,
-1,
-1,
-1,
-1,
-1,
25815,
24165,
21585,
]

_charnames_917760 = [
18907,
18896,
18885,
19040,
19029,
19018,
19007,
18996,
19051,
19062,
19061,
19060,
19059,
19139,
19138,
19137,
19136,
19135,
19134,
19133,
19132,
19131,
19130,
19128,
19127,
19126,
19125,
19124,
19123,
19122,
19121,
19120,
19119,
19117,
19116,
19115,
19114,
19113,
19112,
19111,
19110,
19109,
19108,
19106,
19105,
19104,
19103,
19102,
19101,
19100,
19099,
19098,
19097,
19095,
19094,
19093,
19092,
19091,
19090,
19089,
19088,
19087,
19086,
19084,
19083,
19082,
19081,
19080,
19079,
19078,
19077,
19076,
19075,
19073,
19072,
19071,
19070,
19069,
19068,
19067,
19066,
19065,
19064,
18994,
18993,
18992,
18991,
18990,
18989,
18988,
18987,
18986,
18985,
18983,
18982,
18981,
18980,
18979,
18978,
18977,
18976,
18975,
18974,
18972,
18971,
18970,
18969,
18968,
18967,
18966,
18965,
18964,
18963,
18961,
18960,
18959,
18958,
18957,
18956,
18955,
18954,
18953,
18952,
18950,
18949,
18948,
18947,
18946,
18945,
18944,
18943,
18942,
18941,
18939,
18938,
18937,
18936,
18935,
18934,
18933,
18932,
18931,
18930,
18928,
18927,
18926,
18925,
18924,
18923,
18922,
18921,
18920,
18919,
18917,
18916,
18915,
18914,
18913,
18912,
18911,
18910,
18909,
18908,
18906,
18905,
18904,
18903,
18902,
18901,
18900,
18899,
18898,
18897,
18895,
18894,
18893,
18892,
18891,
18890,
18889,
18888,
18887,
18886,
19050,
19049,
19048,
19047,
19046,
19045,
19044,
19043,
19042,
19041,
19039,
19038,
19037,
19036,
19035,
19034,
19033,
19032,
19031,
19030,
19028,
19027,
19026,
19025,
19024,
19023,
19022,
19021,
19020,
19019,
19017,
19016,
19015,
19014,
19013,
19012,
19011,
19010,
19009,
19008,
19006,
19005,
19004,
19003,
19002,
19001,
19000,
18999,
18998,
18997,
19058,
19057,
19056,
19055,
19054,
19053,
19052,
]

_charnames_983040 = [
17779,
17778,
7869,
7032,
7867,
7903,
13677,
13557,
13675,
13725,
13688,
13687,
17338,
17337,
16957,
15616,
14992,
15638,
2405,
20356,
20428,
5063,
10917,
18024,
13681,
12153,
18532,
13727,
10915,
19477,
19504,
25370,
25430,
2715,
3354,
7252,
12134,
6786,
7253,
12133,
5597,
23526,
23536,
23417,
23533,
23414,
23532,
23415,
23531,
23418,
23530,
18095,
18291,
7855,
7854,
13676,
13558,
2649,
2536,
13680,
13726,
7763,
7762,
13722,
13721,
25201,
25339,
25428,
25199,
22491,
22893,
25198,
24698,
25001,
25200,
25673,
25681,
7905,
23435,
23433,
21656,
21655,
20412,
20390,
15183,
15639,
18510,
18530,
25102,
25005,
18142,
18146,
7866,
8043,
13678,
13723,
2408,
20359,
20429,
2407,
20358,
20430,
10916,
19478,
19505,
21576,
21577,
21954,
21578,
21575,
21946,
24685,
24688,
24708,
6775,
6781,
8045,
6776,
6780,
8044,
23416,
23529,
22023,
22020,
22133,
22022,
22019,
22132,
7996,
7904,
2651,
3386,
8721,
10249,
7870,
7868,
7933,
13682,
13679,
13738,
7865,
7030,
6777,
8046,
6778,
8018,
2175,
3384,
7889,
7860,
21240,
21114,
22024,
22137,
17329,
17331,
18529,
7260,
11637,
11413,
3385,
16960,
7852,
24132,
11799,
11800,
11801,
11802,
5252,
20128,
20130,
20070,
20129,
25427,
25426,
25425,
10250,
25788,
25786,
25789,
12148,
24998,
12150,
25000,
22136,
12147,
24997,
18531,
10251,
24589,
12149,
24999,
25429,
22135,
24579,
9892,
9893,
11825,
24721,
25816,
19142,
19253,
19387,
19376,
19365,
19354,
19343,
19332,
19321,
19242,
19231,
19220,
19209,
19198,
19187,
19176,
21998,
15637,
15583,
25787,
998,
1000,
8513,
8503,
8476,
8466,
19834,
15636,
19165,
19154,
19143,
19298,
19287,
19276,
19265,
19254,
19309,
19320,
19319,
19318,
19317,
19397,
19396,
19395,
19394,
19393,
19392,
19391,
19390,
19389,
19388,
19386,
19385,
19384,
19383,
19382,
19381,
19380,
19379,
19378,
19377,
19375,
19374,
19373,
19372,
19371,
19370,
19369,
19368,
19367,
19366,
19364,
19363,
19362,
19361,
19360,
19359,
19358,
19357,
19356,
19355,
19353,
19352,
19351,
19350,
19349,
19348,
19347,
19346,
19345,
19344,
19342,
19341,
19340,
19339,
19338,
19337,
19336,
19335,
19334,
19333,
19331,
19330,
19329,
19328,
19327,
19326,
19325,
19324,
19323,
19322,
19252,
19251,
19250,
19249,
19248,
19247,
19246,
19245,
19244,
19243,
19241,
19240,
19239,
19238,
19237,
19236,
19235,
19234,
19233,
19232,
19230,
19229,
19228,
19227,
19226,
19225,
19224,
19223,
19222,
19221,
19219,
19218,
19217,
19216,
19215,
19214,
19213,
19212,
19211,
19210,
19208,
19207,
19206,
19205,
19204,
19203,
19202,
19201,
19200,
19199,
19197,
19196,
19195,
19194,
19193,
19192,
19191,
19190,
19189,
19188,
19186,
19185,
19184,
19183,
19182,
19181,
19180,
19179,
19178,
19177,
19175,
19174,
19173,
19172,
19171,
19170,
19169,
19168,
19167,
19166,
19164,
19163,
19162,
19161,
19160,
19159,
19158,
19157,
19156,
19155,
19153,
19152,
19151,
19150,
19149,
19148,
19147,
19146,
19145,
19144,
19308,
19307,
19306,
19305,
19304,
19303,
19302,
19301,
19300,
19299,
19297,
19296,
19295,
19294,
19293,
19292,
19291,
19290,
19289,
19288,
19286,
19285,
19284,
19283,
19282,
19281,
19280,
19279,
19278,
19277,
19275,
19274,
19273,
19272,
19271,
19270,
19269,
19268,
19267,
19266,
19264,
19263,
19262,
19261,
19260,
19259,
19258,
19257,
19256,
19255,
19316,
19315,
19314,
19313,
19312,
19311,
19310,
]

_charnames_983552 = [
24152,
24153,
24147,
24148,
24139,
24140,
24145,
24146,
24142,
24143,
24150,
24149,
11535,
11259,
11511,
11178,
11513,
11180,
11514,
11181,
11522,
11189,
11523,
11190,
11556,
11225,
11220,
11393,
11605,
11300,
11607,
11302,
11608,
11303,
11560,
11167,
11596,
11235,
11533,
11256,
11532,
11255,
11517,
11184,
11516,
11183,
11520,
11187,
11519,
11186,
11219,
11218,
11555,
11223,
11554,
11222,
11676,
11469,
11627,
11315,
11657,
11396,
11574,
11274,
11600,
11242,
11599,
11241,
11597,
11236,
11595,
11234,
11268,
11295,
11296,
11124,
11125,
11164,
11165,
11432,
11433,
16712,
16716,
16713,
16718,
16717,
16715,
16719,
16714,
16720,
15593,
4596,
4585,
4604,
4584,
4593,
4582,
4592,
4581,
4600,
4601,
4598,
4594,
4589,
4599,
4591,
4590,
4595,
4583,
4602,
4588,
4587,
4586,
4603,
4597,
4399,
4404,
4405,
4400,
4401,
4406,
4407,
4398,
4402,
4403,
4397,
4282,
4287,
4288,
4283,
4284,
4289,
4290,
4281,
4285,
4286,
4280,
4542,
4547,
4548,
4543,
4544,
4549,
4550,
4541,
4545,
4546,
4540,
4269,
4274,
4275,
4270,
4271,
4276,
4277,
4268,
4272,
4273,
4267,
4413,
4418,
4419,
4414,
4415,
4420,
4421,
4412,
4416,
4417,
4411,
4256,
4261,
4262,
4257,
4258,
4263,
4264,
4255,
4259,
4260,
4254,
4425,
4430,
4431,
4426,
4427,
4432,
4433,
4424,
4428,
4429,
4423,
4294,
4299,
4300,
4295,
4296,
4301,
4302,
4293,
4297,
4298,
4292,
4490,
4495,
4496,
4491,
4492,
4497,
4498,
4489,
4493,
4494,
4488,
4503,
4508,
4509,
4504,
4505,
4510,
4511,
4502,
4506,
4507,
4501,
4464,
4469,
4470,
4465,
4466,
4471,
4472,
4463,
4467,
4468,
4462,
4451,
4456,
4457,
4452,
4453,
4458,
4459,
4450,
4454,
4455,
4449,
4373,
4378,
4379,
4374,
4375,
4380,
4381,
4372,
4376,
4377,
4371,
4477,
4482,
4483,
4478,
4479,
4484,
4485,
4476,
4480,
4481,
4475,
4349,
4354,
4355,
4350,
4351,
4356,
4357,
4348,
4352,
4353,
4347,
4361,
4366,
4367,
4362,
4363,
4368,
4369,
4360,
4364,
4365,
4359,
4439,
4444,
4445,
4440,
4441,
4446,
4447,
4438,
4442,
4443,
4437,
4244,
4249,
4250,
4245,
4246,
4251,
4252,
4243,
4247,
4248,
4242,
4516,
4521,
4522,
4517,
4518,
4523,
4524,
4515,
4519,
4520,
4514,
4308,
4313,
4314,
4309,
4310,
4315,
4316,
4307,
4311,
4312,
4306,
4322,
4327,
4328,
4323,
4324,
4329,
4330,
4321,
4325,
4326,
4320,
4334,
4339,
4340,
4335,
4336,
4341,
4342,
4333,
4337,
4338,
4332,
4529,
4534,
4535,
4530,
4531,
4536,
4537,
4528,
4532,
4533,
4527,
4384,
4387,
4392,
4393,
4388,
4389,
4394,
4395,
4386,
4390,
4391,
4385,
4317,
6771,
6770,
6769,
22615,
23634,
23632,
23633,
23631,
23627,
23640,
23638,
23639,
23637,
23625,
23655,
23618,
23654,
23617,
23628,
23623,
23621,
23622,
23620,
23626,
23661,
23648,
23649,
23647,
23659,
23656,
23658,
23651,
23657,
23643,
23642,
23644,
23660,
23652,
23670,
23666,
23663,
23664,
23667,
23669,
23671,
20399,
20397,
20395,
20398,
20396,
24104,
24102,
24100,
24103,
24101,
24111,
24108,
24109,
24110,
9480,
9474,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 11349
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 11128
    elif code == 687: res = 11129
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 895: res = _charnames_880[code-880]
    elif code == 975: res = 22332
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1731
    elif code == 1231: res = 2894
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1327: res = _charnames_1296[code-1296]
    elif code == 1376: res = 16787
    elif 1416 <= code <= 1423: res = _charnames_1416[code-1416]
    elif code == 1442: res = 20051
    elif code == 1466: res = 20047
    elif code == 1477: res = 20050
    elif code == 1478: res = 20048
    elif code == 1479: res = 20046
    elif code == 1519: res = 20049
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 16564
    elif code == 1596: res = 16562
    elif code == 1597: res = 16524
    elif code == 1598: res = 16522
    elif code == 1599: res = 16523
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 16612
    elif code == 1775: res = 16554
    elif code == 1791: res = 16591
    elif code == 1837: res = 7851
    elif code == 1838: res = 7849
    elif code == 1839: res = 7850
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2154: res = _charnames_1984[code-1984]
    elif 2208 <= code <= 2237: res = _charnames_2208[code-2208]
    elif 2259 <= code <= 2308: res = _charnames_2259[code-2259]
    elif code == 2362: res = 23402
    elif code == 2363: res = 23401
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2432: res = _charnames_2417[code-2417]
    elif code == 2493: res = 15597
    elif code == 2510: res = 15594
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 22870
    elif code == 2677: res = 22868
    elif code == 2678: res = 22872
    elif code == 2700: res = 22859
    elif code == 2785: res = 22860
    elif code == 2786: res = 22862
    elif code == 2787: res = 22863
    elif code == 2800: res = 22865
    elif code == 2801: res = 22864
    elif 2809 <= code <= 2815: res = _charnames_2809[code-2809]
    elif code == 2869: res = 21218
    elif code == 2884: res = 21215
    elif code == 2914: res = 21213
    elif code == 2915: res = 21214
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 4650
    elif code == 3024: res = 4659
    elif code == 3046: res = 4641
    elif 3059 <= code <= 3076: res = _charnames_3059[code-3059]
    elif code == 3124: res = 5425
    elif code == 3133: res = 5421
    elif code == 3160: res = 5423
    elif code == 3161: res = 5426
    elif code == 3162: res = 5424
    elif code == 3170: res = 5427
    elif code == 3171: res = 5428
    elif 3191 <= code <= 3204: res = _charnames_3191[code-3191]
    elif code == 3260: res = 24126
    elif code == 3261: res = 24129
    elif code == 3298: res = 24130
    elif code == 3299: res = 24131
    elif code == 3313: res = 24127
    elif code == 3314: res = 24125
    elif code == 3328: res = 9202
    elif code == 3329: res = 9204
    elif code == 3369: res = 9179
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif 3406 <= code <= 3427: res = _charnames_3406[code-3406]
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif 3718 <= code <= 3736: res = _charnames_3718[code-3718]
    elif code == 3744: res = 11791
    elif code == 3752: res = 11794
    elif code == 3753: res = 11793
    elif code == 3756: res = 11787
    elif code == 3770: res = 11803
    elif code == 3806: res = 11797
    elif code == 3807: res = 11796
    elif code == 3947: res = 5269
    elif code == 3948: res = 5268
    elif code == 3980: res = 5266
    elif code == 3981: res = 5262
    elif code == 3982: res = 5261
    elif code == 3983: res = 5263
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif 4345 <= code <= 4351: res = _charnames_4345[code-4345]
    elif code == 4442: res = 20229
    elif code == 4443: res = 20219
    elif code == 4444: res = 20221
    elif code == 4445: res = 20220
    elif code == 4446: res = 20203
    elif code == 4515: res = 20181
    elif code == 4516: res = 20165
    elif code == 4517: res = 20164
    elif code == 4518: res = 20168
    elif code == 4519: res = 20169
    elif code == 4602: res = 20121
    elif code == 4603: res = 20120
    elif code == 4604: res = 20124
    elif code == 4605: res = 20122
    elif code == 4606: res = 20123
    elif code == 4607: res = 20073
    elif code == 4615: res = 13537
    elif code == 4679: res = 13501
    elif code == 4743: res = 13491
    elif code == 4783: res = 13511
    elif code == 4815: res = 13533
    elif code == 4847: res = 13532
    elif code == 4879: res = 13411
    elif code == 4895: res = 13409
    elif code == 4935: res = 13469
    elif code == 4957: res = 13555
    elif code == 4958: res = 13556
    elif code == 4959: res = 13554
    elif code == 4960: res = 13538
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif 5109 <= code <= 5120: res = _charnames_5109[code-5109]
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6109: res = 23613
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif code == 6264: res = 9640
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6846: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7304: res = _charnames_7164[code-7164]
    elif 7312 <= code <= 7367: res = _charnames_7312[code-7312]
    elif 7376 <= code <= 7679: res = _charnames_7376[code-7376]
    elif code == 7836: res = 11324
    elif code == 7837: res = 11323
    elif code == 7838: res = 11567
    elif code == 7839: res = 11356
    elif code == 7930: res = 11655
    elif code == 7931: res = 11402
    elif code == 7932: res = 11654
    elif code == 7933: res = 11401
    elif code == 7934: res = 11681
    elif code == 7935: res = 11462
    elif 8275 <= code <= 8297: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8383: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1796
    elif code == 8428: res = 1858
    elif code == 8429: res = 1790
    elif code == 8430: res = 1788
    elif code == 8431: res = 1856
    elif code == 8432: res = 1881
    elif code == 8507: res = 25309
    elif code == 8508: res = 23168
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif 8580 <= code <= 8587: res = _charnames_8580[code-8580]
    elif 9167 <= code <= 9215: res = _charnames_9167[code-9167]
    elif code == 9471: res = 18094
    elif code == 9748: res = 25679
    elif code == 9749: res = 20380
    elif code == 9752: res = 7228
    elif code == 9854: res = 22058
    elif code == 9855: res = 24498
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 7936
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 19969
    elif code == 10080: res = 19970
    elif code == 10133: res = 20028
    elif code == 10134: res = 20030
    elif code == 10135: res = 20006
    elif code == 10160: res = 1576
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 9288
    elif code == 10221: res = 9284
    elif code == 10222: res = 9289
    elif code == 10223: res = 9285
    elif 11008 <= code <= 11623: res = _charnames_11008[code-11008]
    elif code == 11631: res = 5246
    elif code == 11632: res = 5245
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11855: res = _charnames_11680[code-11680]
    elif code == 12589: res = 15566
    elif code == 12590: res = 15563
    elif code == 12591: res = 15564
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 21571
    elif code == 12830: res = 21572
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 3343
    elif code == 12925: res = 3342
    elif code == 12926: res = 3348
    elif code == 13004: res = 7640
    elif code == 13005: res = 7635
    elif code == 13006: res = 7637
    elif code == 13007: res = 11013
    elif code == 13055: res = 7636
    elif code == 13175: res = 7628
    elif code == 13176: res = 7630
    elif code == 13177: res = 7631
    elif code == 13178: res = 7644
    elif code == 13278: res = 7641
    elif code == 13279: res = 7647
    elif code == 13311: res = 7645
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42743: res = _charnames_42560[code-42560]
    elif 42752 <= code <= 42950: res = _charnames_42752[code-42752]
    elif 42999 <= code <= 43127: res = _charnames_42999[code-42999]
    elif 43136 <= code <= 43205: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43574: res = _charnames_43359[code-43359]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif 43739 <= code <= 43766: res = _charnames_43739[code-43739]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43879: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 44025: res = _charnames_43888[code-43888]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif code == 64046: res = 3188
    elif code == 64047: res = 3187
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 16640
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif 65060 <= code <= 65071: res = _charnames_65060[code-65060]
    elif code == 65095: res = 22002
    elif code == 65096: res = 21999
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65952: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 20900
    elif code == 66349: res = 20897
    elif code == 66350: res = 20899
    elif code == 66351: res = 20898
    elif 66384 <= code <= 66517: res = _charnames_66384[code-66384]
    elif code == 66598: res = 23426
    elif code == 66599: res = 23427
    elif 66638 <= code <= 66855: res = _charnames_66638[code-66638]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 2794
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67584 <= code <= 67742: res = _charnames_67584[code-67584]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67903: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68168: res = _charnames_67968[code-67968]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68255: res = _charnames_68192[code-68192]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68352 <= code <= 68497: res = _charnames_68352[code-68352]
    elif code == 68505: res = 21991
    elif code == 68506: res = 21990
    elif code == 68507: res = 21989
    elif code == 68508: res = 21988
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif 68858 <= code <= 68903: res = _charnames_68858[code-68858]
    elif 68912 <= code <= 68921: res = _charnames_68912[code-68912]
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69376 <= code <= 69415: res = _charnames_69376[code-69376]
    elif 69424 <= code <= 69465: res = _charnames_69424[code-69424]
    elif 69600 <= code <= 69622: res = _charnames_69600[code-69600]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69759 <= code <= 69825: res = _charnames_69759[code-69759]
    elif 69837 <= code <= 69864: res = _charnames_69837[code-69837]
    elif 69872 <= code <= 69958: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70206: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70656 <= code <= 70751: res = _charnames_70656[code-70656]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71276: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71352: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71680 <= code <= 71739: res = _charnames_71680[code-71680]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 24281
    elif 72096 <= code <= 72164: res = _charnames_72096[code-72096]
    elif 72192 <= code <= 72263: res = _charnames_72192[code-72192]
    elif 72272 <= code <= 72354: res = _charnames_72272[code-72272]
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 72704 <= code <= 72773: res = _charnames_72704[code-72704]
    elif 72784 <= code <= 72886: res = _charnames_72784[code-72784]
    elif 72960 <= code <= 73031: res = _charnames_72960[code-72960]
    elif 73040 <= code <= 73112: res = _charnames_73040[code-73040]
    elif 73120 <= code <= 73129: res = _charnames_73120[code-73120]
    elif 73440 <= code <= 73464: res = _charnames_73440[code-73440]
    elif 73664 <= code <= 73713: res = _charnames_73664[code-73664]
    elif 73727 <= code <= 74649: res = _charnames_73727[code-73727]
    elif 74752 <= code <= 74868: res = _charnames_74752[code-74752]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 77824 <= code <= 78904: res = _charnames_77824[code-77824]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93760 <= code <= 93850: res = _charnames_93760[code-93760]
    elif 93952 <= code <= 94087: res = _charnames_93952[code-93952]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 94176: res = 4232
    elif code == 94177: res = 17777
    elif code == 94178: res = 20903
    elif code == 94179: res = 20902
    elif 100352 <= code <= 101106: res = _charnames_100352[code-100352]
    elif 110592 <= code <= 110878: res = _charnames_110592[code-110592]
    elif code == 110928: res = 20402
    elif code == 110929: res = 20403
    elif code == 110930: res = 20401
    elif code == 110948: res = 24116
    elif code == 110949: res = 24117
    elif code == 110950: res = 24115
    elif code == 110951: res = 24118
    elif 110960 <= code <= 111355: res = _charnames_110960[code-110960]
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif code == 119081: res = 10186
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119520 <= code <= 119539: res = _charnames_119520[code-119520]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119672: res = _charnames_119648[code-119648]
    elif code == 120001: res = 9296
    elif code == 120484: res = 9292
    elif code == 120485: res = 9291
    elif code == 120778: res = 9295
    elif code == 120779: res = 9294
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 122880 <= code <= 122922: res = _charnames_122880[code-122880]
    elif 123136 <= code <= 123215: res = _charnames_123136[code-123136]
    elif 123584 <= code <= 123647: res = _charnames_123584[code-123584]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 125184 <= code <= 125279: res = _charnames_125184[code-125184]
    elif 126065 <= code <= 126132: res = _charnames_126065[code-126065]
    elif 126209 <= code <= 126269: res = _charnames_126209[code-126209]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 16475
    elif code == 126705: res = 16476
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127404: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 3311
    elif code == 127569: res = 3312
    elif code == 127584: res = 24940
    elif code == 127585: res = 24939
    elif code == 127586: res = 24937
    elif code == 127587: res = 24938
    elif code == 127588: res = 24936
    elif code == 127589: res = 24941
    elif 127744 <= code <= 128725: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128883: res = _charnames_128736[code-128736]
    elif 128896 <= code <= 128984: res = _charnames_128896[code-128896]
    elif 128992 <= code <= 129003: res = _charnames_128992[code-128992]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129280 <= code <= 129619: res = _charnames_129280[code-129280]
    elif 129632 <= code <= 129666: res = _charnames_129632[code-129632]
    elif code == 129680: res = 24828
    elif code == 129681: res = 2410
    elif code == 129682: res = 24993
    elif code == 129683: res = 17346
    elif code == 129684: res = 23499
    elif code == 129685: res = 14984
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983507: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983993: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2CEA1 or 0x2CEB0 <= code <= 0x2EBE0):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not i