# # This file is generated by running the following code on top of the
# # target version of CPython:
# 
# import sys
# with open(sys.argv[0]) as f:
#     for line in f:
#         print('# ' + line.rstrip())
# 
# ranges = [None] + list(range(-4, 5))
# 
# print('')
# print('def check(s1, s2, start, end, bitmask):')
# print('    b1 = bytes(s1, "ascii")')
# print('    b2 = bytes(s2, "ascii")')
# print('    a1 = bytearray(s1, "ascii")')
# print('    a2 = bytearray(s2, "ascii")')
# print('    assert s1.startswith(s2, start, end) == ((bitmask & 1) != 0)')
# print('    assert b1.startswith(b2, start, end) == ((bitmask & 2) != 0)')
# print('    assert a1.startswith(a2, start, end) == ((bitmask & 4) != 0)')
# print('    assert s1.endswith(s2, start, end) == ((bitmask & 8) != 0)')
# print('    assert b1.endswith(b2, start, end) == ((bitmask & 16) != 0)')
# print('    assert a1.endswith(a2, start, end) == ((bitmask & 32) != 0)')
# print('')
# for len1 in range(0, 4):
#     s1 = ''.join(chr(48+n) for n in range(len1))
#     for len2 in range(0, 4):
#         for start in ranges:
#             for end in ranges:
#                 s2 = s1[start:end]
#                 r = 0
#                 b1 = bytes(s1, 'ascii')
#                 b2 = bytes(s2, 'ascii')
#                 a1 = bytearray(s1, 'ascii')
#                 a2 = bytearray(s2, 'ascii')
#                 if s1.startswith(s2, start, end): r |= 1
#                 if b1.startswith(b2, start, end): r |= 2
#                 if a1.startswith(a2, start, end): r |= 4
#                 if s1.endswith(s2, start, end): r |= 8
#                 if b1.endswith(b2, start, end): r |= 16
#                 if a1.endswith(a2, start, end): r |= 32
#                 line = 'check(%r, %r, %r, %r, %d)' % (s1, s2, start, end, r)
#                 if r != 0 and r != 63:
#                     line += '  # IRREGULAR'
#                 print(line)

def check(s1, s2, start, end, bitmask):
    b1 = bytes(s1, "ascii")
    b2 = bytes(s2, "ascii")
    a1 = bytearray(s1, "ascii")
    a2 = bytearray(s2, "ascii")
    assert s1.startswith(s2, start, end) == ((bitmask & 1) != 0)
    assert b1.startswith(b2, start, end) == ((bitmask & 2) != 0)
    assert a1.startswith(a2, start, end) == ((bitmask & 4) != 0)
    assert s1.endswith(s2, start, end) == ((bitmask & 8) != 0)
    assert b1.endswith(b2, start, end) == ((bitmask & 16) != 0)
    assert a1.endswith(a2, start, end) == ((bitmask & 32) != 0)

check('', '', None, None, 63)
check('', '', None, -4, 63)
check('', '', None, -3, 63)
check('', '', None, -2, 63)
check('', '', None, -1, 63)
check('', '', None, 0, 63)
check('', '', None, 1, 63)
check('', '', None, 2, 63)
check('', '', None, 3, 63)
check('', '', None, 4, 63)
check('', '', -4, None, 63)
check('', '', -4, -4, 63)
check('', '', -4, -3, 63)
check('', '', -4, -2, 63)
check('', '', -4, -1, 63)
check('', '', -4, 0, 63)
check('', '', -4, 1, 63)
check('', '', -4, 2, 63)
check('', '', -4, 3, 63)
check('', '', -4, 4, 63)
check('', '', -3, None, 63)
check('', '', -3, -4, 63)
check('', '', -3, -3, 63)
check('', '', -3, -2, 63)
check('', '', -3, -1, 63)
check('', '', -3, 0, 63)
check('', '', -3, 1, 63)
check('', '', -3, 2, 63)
check('', '', -3, 3, 63)
check('', '', -3, 4, 63)
check('', '', -2, None, 63)
check('', '', -2, -4, 63)
check('', '', -2, -3, 63)
check('', '', -2, -2, 63)
check('', '', -2, -1, 63)
check('', '', -2, 0, 63)
check('', '', -2, 1, 63)
check('', '', -2, 2, 63)
check('', '', -2, 3, 63)
check('', '', -2, 4, 63)
check('', '', -1, None, 63)
check('', '', -1, -4, 63)
check('', '', -1, -3, 63)
check('', '', -1, -2, 63)
check('', '', -1, -1, 63)
check('', '', -1, 0, 63)
check('', '', -1, 1, 63)
check('', '', -1, 2, 63)
check('', '', -1, 3, 63)
check('', '', -1, 4, 63)
check('', '', 0, None, 63)
check('', '', 0, -4, 63)
check('', '', 0, -3, 63)
check('', '', 0, -2, 63)
check('', '', 0, -1, 63)
check('', '', 0, 0, 63)
check('', '', 0, 1, 63)
check('', '', 0, 2, 63)
check('', '', 0, 3, 63)
check('', '', 0, 4, 63)
check('', '', 1, None, 0)
check('', '', 1, -4, 0)
check('', '', 1, -3, 0)
check('', '', 1, -2, 0)
check('', '', 1, -1, 0)
check('', '', 1, 0, 0)
check('', '', 1, 1, 0)
check('', '', 1, 2, 0)
check('', '', 1, 3, 0)
check('', '', 1, 4, 0)
check('', '', 2, None, 0)
check('', '', 2, -4, 0)
check('', '', 2, -3, 0)
check('', '', 2, -2, 0)
check('', '', 2, -1, 0)
check('', '', 2, 0, 0)
check('', '', 2, 1, 0)
check('', '', 2, 2, 0)
check('', '', 2, 3, 0)
check('', '', 2, 4, 0)
check('', '', 3, None, 0)
check('', '', 3, -4, 0)
check('', '', 3, -3, 0)
check('', '', 3, -2, 0)
check('', '', 3, -1, 0)
check('', '', 3, 0, 0)
check('', '', 3, 1, 0)
check('', '', 3, 2, 0)
check('', '', 3, 3, 0)
check('', '', 3, 4, 0)
check('', '', 4, None, 0)
check('', '', 4, -4, 0)
check('', '', 4, -3, 0)
check('', '', 4, -2, 0)
check('', '', 4, -1, 0)
check('', '', 4, 0, 0)
check('', '', 4, 1, 0)
check('', '', 4, 2, 0)
check('', '', 4, 3, 0)
check('', '', 4, 4, 0)
check('', '', None, None, 63)
check('', '', None, -4, 63)
check('', '', None, -3, 63)
check('', '', None, -2, 63)
check('', '', None, -1, 63)
check('', '', None, 0, 63)
check('', '', None, 1, 63)
check('', '', None, 2, 63)
check('', '', None, 3, 63)
check('', '', None, 4, 63)
check('', '', -4, None, 63)
check('', '', -4, -4, 63)
check('', '', -4, -3, 63)
check('', '', -4, -2, 63)
check('', '', -4, -1, 63)
check('', '', -4, 0, 63)
check('', '', -4, 1, 63)
check('', '', -4, 2, 63)
check('', '', -4, 3, 63)
check('', '', -4, 4, 63)
check('', '', -3, None, 63)
check('', '', -3, -4, 63)
check('', '', -3, -3, 63)
check('', '', -3, -2, 63)
check('', '', -3, -1, 63)
check('', '', -3, 0, 63)
check('', '', -3, 1, 63)
check('', '', -3, 2, 63)
check('', '', -3, 3, 63)
check('', '', -3, 4, 63)
check('', '', -2, None, 63)
check('', '', -2, -4, 63)
check('', '', -2, -3, 63)
check('', '', -2, -2, 63)
check('', '', -2, -1, 63)
check('', '', -2, 0, 63)
check('', '', -2, 1, 63)
check('', '', -2, 2, 63)
check('', '', -2, 3, 63)
check('', '', -2, 4, 63)
check('', '', -1, None, 63)
check('', '', -1, -4, 63)
check('', '', -1, -3, 63)
check('', '', -1, -2, 63)
check('', '', -1, -1, 63)
check('', '', -1, 0, 63)
check('', '', -1, 1, 63)
check('', '', -1, 2, 63)
check('', '', -1, 3, 63)
check('', '', -1, 4, 63)
check('', '', 0, None, 63)
check('', '', 0, -4, 63)
check('', '', 0, -3, 63)
check('', '', 0, -2, 63)
check('', '', 0, -1, 63)
check('', '', 0, 0, 63)
check('', '', 0, 1, 63)
check('', '', 0, 2, 63)
check('', '', 0, 3, 63)
check('', '', 0, 4, 63)
check('', '', 1, None, 0)
check('', '', 1, -4, 0)
check('', '', 1, -3, 0)
check('', '', 1, -2, 0)
check('', '', 1, -1, 0)
check('', '', 1, 0, 0)
check('', '', 1, 1, 0)
check('', '', 1, 2, 0)
check('', '', 1, 3, 0)
check('', '', 1, 4, 0)
check('', '', 2, None, 0)
check('', '', 2, -4, 0)
check('', '', 2, -3, 0)
check('', '', 2, -2, 0)
check('', '', 2, -1, 0)
check('', '', 2, 0, 0)
check('', '', 2, 1, 0)
check('', '', 2, 2, 0)
check('', '', 2, 3, 0)
check('', '', 2, 4, 0)
check('', '', 3, None, 0)
check('', '', 3, -4, 0)
check('', '', 3, -3, 0)
check('', '', 3, -2, 0)
check('', '', 3, -1, 0)
check('', '', 3, 0, 0)
check('', '', 3, 1, 0)
check('', '', 3, 2, 0)
check('', '', 3, 3, 0)
check('', '', 3, 4, 0)
check('', '', 4, None, 0)
check('', '', 4, -4, 0)
check('', '', 4, -3, 0)
check('', '', 4, -2, 0)
check('', '', 4, -1, 0)
check('', '', 4, 0, 0)
check('', '', 4, 1, 0)
check('', '', 4, 2, 0)
check('', '', 4, 3, 0)
check('', '', 4, 4, 0)
check('', '', None, None, 63)
check('', '', None, -4, 63)
check('', '', None, -3, 63)
check('', '', None, -2, 63)
check('', '', None, -1, 63)
check('', '', None, 0, 63)
check('', '', None, 1, 63)
check('', '', None, 2, 63)
check('', '', None, 3, 63)
check('', '', None, 4, 63)
check('', '', -4, None, 63)
check('', '', -4, -4, 63)
check('', '', -4, -3, 63)
check('', '', -4, -2, 63)
check('', '', -4, -1, 63)
check('', '', -4, 0, 63)
check('', '', -4, 1, 63)
check('', '', -4, 2, 63)
check('', '', -4, 3, 63)
check('', '', -4, 4, 63)
check('', '', -3, None, 63)
check('', '', -3, -4, 63)
check('', '', -3, -3, 63)
check('', '', -3, -2, 63)
check('', '', -3, -1, 63)
check('', '', -3, 0, 63)
check('', '', -3, 1, 63)
check('', '', -3, 2, 63)
check('', '', -3, 3, 63)
check('', '', -3, 4, 63)
check('', '', -2, None, 63)
check('', '', -2, -4, 63)
check('', '', -2, -3, 63)
check('', '', -2, -2, 63)
check('', '', -2, -1, 63)
check('', '', -2, 0, 63)
check('', '', -2, 1, 63)
check('', '', -2, 2, 63)
check('', '', -2, 3, 63)
check('', '', -2, 4, 63)
check('', '', -1, None, 63)
check('', '', -1, -4, 63)
check('', '', -1, -3, 63)
check('', '', -1, -2, 63)
check('', '', -1, -1, 63)
check('', '', -1, 0, 63)
check('', '', -1, 1, 63)
check('', '', -1, 2, 63)
check('', '', -1, 3, 63)
check('', '', -1, 4, 63)
check('', '', 0, None, 63)
check('', '', 0, -4, 63)
check('', '', 0, -3, 63)
check('', '', 0, -2, 63)
check('', '', 0, -1, 63)
check('', '', 0, 0, 63)
check('', '', 0, 1, 63)
check('', '', 0, 2, 63)
check('', '', 0, 3, 63)
check('', '', 0, 4, 63)
check('', '', 1, None, 0)
check('', '', 1, -4, 0)
check('', '', 1, -3, 0)
check('', '', 1, -2, 0)
check('', '', 1, -1, 0)
check('', '', 1, 0, 0)
check('', '', 1, 1, 0)
check('', '', 1, 2, 0)
check('', '', 1, 3, 0)
check('', '', 1, 4, 0)
check('', '', 2, None, 0)
check('', '', 2, -4, 0)
check('', '', 2, -3, 0)
check('', '', 2, -2, 0)
check('', '', 2, -1, 0)
check('', '', 2, 0, 0)
check('', '', 2, 1, 0)
check('', '', 2, 2, 0)
check('', '', 2, 3, 0)
check('', '', 2, 4, 0)
check('', '', 3, None, 0)
check('', '', 3, -4, 0)
check('', '', 3, -3, 0)
check('', '', 3, -2, 0)
check('', '', 3, -1, 0)
check('', '', 3, 0, 0)
check('', '', 3, 1, 0)
check('', '', 3, 2, 0)
check('', '', 3, 3, 0)
check('', '', 3, 4, 0)
check('', '', 4, None, 0)
check('', '', 4, -4, 0)
check('', '', 4, -3, 0)
check('', '', 4, -2, 0)
check('', '', 4, -1, 0)
check('', '', 4, 0, 0)
check('', '', 4, 1, 0)
check('', '', 4, 2, 0)
check('', '', 4, 3, 0)
check('', '', 4, 4, 0)
check('', '', None, None, 63)
check('', '', None, -4, 63)
check('', '', None, -3, 63)
check('', '', None, -2, 63)
check('', '', None, -1, 63)
check('', '', None, 0, 63)
check('', '', None, 1, 63)
check('', '', None, 2, 63)
check('', '', None, 3, 63)
check('', '', None, 4, 63)
check('', '', -4, None, 63)
check('', '', -4, -4, 63)
check('', '', -4, -3, 63)
check('', '', -4, -2, 63)
check('', '', -4, -1, 63)
check('', '', -4, 0, 63)
check('', '', -4, 1, 63)
check('', '', -4, 2, 63)
check('', '', -4, 3, 63)
check('', '', -4, 4, 63)
check('', '', -3, None, 63)
check('', '', -3, -4, 63)
check('', '', -3, -3, 63)
check('', '', -3, -2, 63)
check('', '', -3, -1, 63)
check('', '', -3, 0, 63)
check('', '', -3, 1, 63)
check('', '', -3, 2, 63)
check('', '', -3, 3, 63)
check('', '', -3, 4, 63)
check('', '', -2, None, 63)
check('', '', -2, -4, 63)
check('', '', -2, -3, 63)
check('', '', -2, -2, 63)
check('', '', -2, -1, 63)
check('', '', -2, 0, 63)
check('', '', -2, 1, 63)
check('', '', -2, 2, 63)
check('', '', -2, 3, 63)
check('', '', -2, 4, 63)
check('', '', -1, None, 63)
check('', '', -1, -4, 63)
check('', '', -1, -3, 63)
check('', '', -1, -2, 63)
check('', '', -1, -1, 63)
check('', '', -1, 0, 63)
check('', '', -1, 1, 63)
check('', '', -1, 2, 63)
check('', '', -1, 3, 63)
check('', '', -1, 4, 63)
check('', '', 0, None, 63)
check('', '', 0, -4, 63)
check('', '', 0, -3, 63)
check('', '', 0, -2, 63)
check('', '', 0, -1, 63)
check('', '', 0, 0, 63)
check('', '', 0, 1, 63)
check('', '', 0, 2, 63)
check('', '', 0, 3, 63)
check('', '', 0, 4, 63)
check('', '', 1, None, 0)
check('', '', 1, -4, 0)
check('', '', 1, -3, 0)
check('', '', 1, -2, 0)
check('', '', 1, -1, 0)
check('', '', 1, 0, 0)
check('', '', 1, 1, 0)
check('', '', 1, 2, 0)
check('', '', 1, 3, 0)
check('', '', 1, 4, 0)
check('', '', 2, None, 0)
check('', '', 2, -4, 0)
check('', '', 2, -3, 0)
check('', '', 2, -2, 0)
check('', '', 2, -1, 0)
check('', '', 2, 0, 0)
check('', '', 2, 1, 0)
check('', '', 2, 2, 0)
check('', '', 2, 3, 0)
check('', '', 2, 4, 0)
check('', '', 3, None, 0)
check('', '', 3, -4, 0)
check('', '', 3, -3, 0)
check('', '', 3, -2, 0)
check('', '', 3, -1, 0)
check('', '', 3, 0, 0)
check('', '', 3, 1, 0)
check('', '', 3, 2, 0)
check('', '', 3, 3, 0)
check('', '', 3, 4, 0)
check('', '', 4, None, 0)
check('', '', 4, -4, 0)
check('', '', 4, -3, 0)
check('', '', 4, -2, 0)
check('', '', 4, -1, 0)
check('', '', 4, 0, 0)
check('', '', 4, 1, 0)
check('', '', 4, 2, 0)
check('', '', 4, 3, 0)
check('', '', 4, 4, 0)
check('0', '0', None, None, 63)
check('0', '', None, -4, 63)
check('0', '', None, -3, 63)
check('0', '', None, -2, 63)
check('0', '', None, -1, 63)
check('0', '', None, 0, 63)
check('0', '0', None, 1, 63)
check('0', '0', None, 2, 63)
check('0', '0', None, 3, 63)
check('0', '0', None, 4, 63)
check('0', '0', -4, None, 63)
check('0', '', -4, -4, 63)
check('0', '', -4, -3, 63)
check('0', '', -4, -2, 63)
check('0', '', -4, -1, 63)
check('0', '', -4, 0, 63)
check('0', '0', -4, 1, 63)
check('0', '0', -4, 2, 63)
check('0', '0', -4, 3, 63)
check('0', '0', -4, 4, 63)
check('0', '0', -3, None, 63)
check('0', '', -3, -4, 63)
check('0', '', -3, -3, 63)
check('0', '', -3, -2, 63)
check('0', '', -3, -1, 63)
check('0', '', -3, 0, 63)
check('0', '0', -3, 1, 63)
check('0', '0', -3, 2, 63)
check('0', '0', -3, 3, 63)
check('0', '0', -3, 4, 63)
check('0', '0', -2, None, 63)
check('0', '', -2, -4, 63)
check('0', '', -2, -3, 63)
check('0', '', -2, -2, 63)
check('0', '', -2, -1, 63)
check('0', '', -2, 0, 63)
check('0', '0', -2, 1, 63)
check('0', '0', -2, 2, 63)
check('0', '0', -2, 3, 63)
check('0', '0', -2, 4, 63)
check('0', '0', -1, None, 63)
check('0', '', -1, -4, 63)
check('0', '', -1, -3, 63)
check('0', '', -1, -2, 63)
check('0', '', -1, -1, 63)
check('0', '', -1, 0, 63)
check('0', '0', -1, 1, 63)
check('0', '0', -1, 2, 63)
check('0', '0', -1, 3, 63)
check('0', '0', -1, 4, 63)
check('0', '0', 0, None, 63)
check('0', '', 0, -4, 63)
check('0', '', 0, -3, 63)
check('0', '', 0, -2, 63)
check('0', '', 0, -1, 63)
check('0', '', 0, 0, 63)
check('0', '0', 0, 1, 63)
check('0', '0', 0, 2, 63)
check('0', '0', 0, 3, 63)
check('0', '0', 0, 4, 63)
check('0', '', 1, None, 63)
check('0', '', 1, -4, 0)
check('0', '', 1, -3, 0)
check('0', '', 1, -2, 0)
check('0', '', 1, -1, 0)
check('0', '', 1, 0, 0)
check('0', '', 1, 1, 63)
check('0', '', 1, 2, 63)
check('0', '', 1, 3, 63)
check('0', '', 1, 4, 63)
check('0', '', 2, None, 0)
check('0', '', 2, -4, 0)
check('0', '', 2, -3, 0)
check('0', '', 2, -2, 0)
check('0', '', 2, -1, 0)
check('0', '', 2, 0, 0)
check('0', '', 2, 1, 0)
check('0', '', 2, 2, 0)
check('0', '', 2, 3, 0)
check('0', '', 2, 4, 0)
check('0', '', 3, None, 0)
check('0', '', 3, -4, 0)
check('0', '', 3, -3, 0)
check('0', '', 3, -2, 0)
check('0', '', 3, -1, 0)
check('0', '', 3, 0, 0)
check('0', '', 3, 1, 0)
check('0', '', 3, 2, 0)
check('0', '', 3, 3, 0)
check('0', '', 3, 4, 0)
check('0', '', 4, None, 0)
check('0', '', 4, -4, 0)
check('0', '', 4, -3, 0)
check('0', '', 4, -2, 0)
check('0', '', 4, -1, 0)
check('0', '', 4, 0, 0)
check('0', '', 4, 1, 0)
check('0', '', 4, 2, 0)
check('0', '', 4, 3, 0)
check('0', '', 4, 4, 0)
check('0', '0', None, None, 63)
check('0', '', None, -4, 63)
check('0', '', None, -3, 63)
check('0', '', None, -2, 63)
check('0', '', None, -1, 63)
check('0', '', None, 0, 63)
check('0', '0', None, 1, 63)
check('0', '0', None, 2, 63)
check('0', '0', None, 3, 63)
check('0', '0', None, 4, 63)
check('0', '0', -4, None, 63)
check('0', '', -4, -4, 63)
check('0', '', -4, -3, 63)
check('0', '', -4, -2, 63)
check('0', '', -4, -1, 63)
check('0', '', -4, 0, 63)
check('0', '0', -4, 1, 63)
check('0', '0', -4, 2, 63)
check('0', '0', -4, 3, 63)
check('0', '0', -4, 4, 63)
check('0', '0', -3, None, 63)
check('0', '', -3, -4, 63)
check('0', '', -3, -3, 63)
check('0', '', -3, -2, 63)
check('0', '', -3, -1, 63)
check('0', '', -3, 0, 63)
check('0', '0', -3, 1, 63)
check('0', '0', -3, 2, 63)
check('0', '0', -3, 3, 63)
check('0', '0', -3, 4, 63)
check('0', '0', -2, None, 63)
check('0', '', -2, -4, 63)
check('0', '', -2, -3, 63)
check('0', '', -2, -2, 63)
check('0', '', -2, -1, 63)
check('0', '', -2, 0, 63)
check('0', '0', -2, 1, 63)
check('0', '0', -2, 2, 63)
check('0', '0', -2, 3, 63)
check('0', '0', -2, 4, 63)
check('0', '0', -1, None, 63)
check('0', '', -1, -4, 63)
check('0', '', -1, -3, 63)
check('0', '', -1, -2, 63)
check('0', '', -1, -1, 63)
check('0', '', -1, 0, 63)
check('0', '0', -1, 1, 63)
check('0', '0', -1, 2, 63)
check('0', '0', -1, 3, 63)
check('0', '0', -1, 4, 63)
check('0', '0', 0, None, 63)
check('0', '', 0, -4, 63)
check('0', '', 0, -3, 63)
check('0', '', 0, -2, 63)
check('0', '', 0, -1, 63)
check('0', '', 0, 0, 63)
check('0', '0', 0, 1, 63)
check('0', '0', 0, 2, 63)
check('0', '0', 0, 3, 63)
check('0', '0', 0, 4, 63)
check('0', '', 1, None, 63)
check('0', '', 1, -4, 0)
check('0', '', 1, -3, 0)
check('0', '', 1, -2, 0)
check('0', '', 1, -1, 0)
check('0', '', 1, 0, 0)
check('0', '', 1, 1, 63)
check('0', '', 1, 2, 63)
check('0', '', 1, 3, 63)
check('0', '', 1, 4, 63)
check('0', '', 2, None, 0)
check('0', '', 2, -4, 0)
check('0', '', 2, -3, 0)
check('0', '', 2, -2, 0)
check('0', '', 2, -1, 0)
check('0', '', 2, 0, 0)
check('0', '', 2, 1, 0)
check('0', '', 2, 2, 0)
check('0', '', 2, 3, 0)
check('0', '', 2, 4, 0)
check('0', '', 3, None, 0)
check('0', '', 3, -4, 0)
check('0', '', 3, -3, 0)
check('0', '', 3, -2, 0)
check('0', '', 3, -1, 0)
check('0', '', 3, 0, 0)
check('0', '', 3, 1, 0)
check('0', '', 3, 2, 0)
check('0', '', 3, 3, 0)
check('0', '', 3, 4, 0)
check('0', '', 4, None, 0)
check('0', '', 4, -4, 0)
check('0', '', 4, -3, 0)
check('0', '', 4, -2, 0)
check('0', '', 4, -1, 0)
check('0', '', 4, 0, 0)
check('0', '', 4, 1, 0)
check('0', '', 4, 2, 0)
check('0', '', 4, 3, 0)
check('0', '', 4, 4, 0)
check('0', '0', None, None, 63)
check('0', '', None, -4, 63)
check('0', '', None, -3, 63)
check('0', '', None, -2, 63)
check('0', '', None, -1, 63)
check('0', '', None, 0, 63)
check('0', '0', None, 1, 63)
check('0', '0', None, 2, 63)
check('0', '0', None, 3, 63)
check('0', '0', None, 4, 63)
check('0', '0', -4, None, 63)
check('0', '', -4, -4, 63)
check('0', '', -4, -3, 63)
check('0', '', -4, -2, 63)
check('0', '', -4, -1, 63)
check('0', '', -4, 0, 63)
check('0', '0', -4, 1, 63)
check('0', '0', -4, 2, 63)
check('0', '0', -4, 3, 63)
check('0', '0', -4, 4, 63)
check('0', '0', -3, None, 63)
check('0', '', -3, -4, 63)
check('0', '', -3, -3, 63)
check('0', '', -3, -2, 63)
check('0', '', -3, -1, 63)
check('0', '', -3, 0, 63)
check('0', '0', -3, 1, 63)
check('0', '0', -3, 2, 63)
check('0', '0', -3, 3, 63)
check('0', '0', -3, 4, 63)
check('0', '0', -2, None, 63)
check('0', '', -2, -4, 63)
check('0', '', -2, -3, 63)
check('0', '', -2, -2, 63)
check('0', '', -2, -1, 63)
check('0', '', -2, 0, 63)
check('0', '0', -2, 1, 63)
check('0', '0', -2, 2, 63)
check('0', '0', -2, 3, 63)
check('0', '0', -2, 4, 63)
check('0', '0', -1, None, 63)
check('0', '', -1, -4, 63)
check('0', '', -1, -3, 63)
check('0', '', -1, -2, 63)
check('0', '', -1, -1, 63)
check('0', '', -1, 0, 63)
check('0', '0', -1, 1, 63)
check('0', '0', -1, 2, 63)
check('0', '0', -1, 3, 63)
check('0', '0', -1, 4, 63)
check('0', '0', 0, None, 63)
check('0', '', 0, -4, 63)
check('0', '', 0, -3, 63)
check('0', '', 0, -2, 63)
check('0', '', 0, -1, 63)
check('0', '', 0, 0, 63)
check('0', '0', 0, 1, 63)
check('0', '0', 0, 2, 63)
check('0', '0', 0, 3, 63)
check('0', '0', 0, 4, 63)
check('0', '', 1, None, 63)
check('0', '', 1, -4, 0)
check('0', '', 1, -3, 0)
check('0', '', 1, -2, 0)
check('0', '', 1, -1, 0)
check('0', '', 1, 0, 0)
check('0', '', 1, 1, 63)
check('0', '', 1, 2, 63)
check('0', '', 1, 3, 63)
check('0', '', 1, 4, 63)
check('0', '', 2, None, 0)
check('0', '', 2, -4, 0)
check('0', '', 2, -3, 0)
check('0', '', 2, -2, 0)
check('0', '', 2, -1, 0)
check('0', '', 2, 0, 0)
check('0', '', 2, 1, 0)
check('0', '', 2, 2, 0)
check('0', '', 2, 3, 0)
check('0', '', 2, 4, 0)
check('0', '', 3, None, 0)
check('0', '', 3, -4, 0)
check('0', '', 3, -3, 0)
check('0', '', 3, -2, 0)
check('0', '', 3, -1, 0)
check('0', '', 3, 0, 0)
check('0', '', 3, 1, 0)
check('0', '', 3, 2, 0)
check('0', '', 3, 3, 0)
check('0', '', 3, 4, 0)
check('0', '', 4, None, 0)
check('0', '', 4, -4, 0)
check('0', '', 4, -3, 0)
check('0', '', 4, -2, 0)
check('0', '', 4, -1, 0)
check('0', '', 4, 0, 0)
check('0', '', 4, 1, 0)
check('0', '', 4, 2, 0)
check('0', '', 4, 3, 0)
check('0', '', 4, 4, 0)
check('0', '0', None, None, 63)
check('0', '', None, -4, 63)
check('0', '', None, -3, 63)
check('0', '', None, -2, 63)
check('0', '', None, -1, 63)
check('0', '', None, 0, 63)
check('0', '0', None, 1, 63)
check('0', '0', None, 2, 63)
check('0', '0', None, 3, 63)
check('0', '0', None, 4, 63)
check('0', '0', -4, None, 63)
check('0', '', -4, -4, 63)
check('0', '', -4, -3, 63)
check('0', '', -4, -2, 63)
check('0', '', -4, -1, 63)
check('0', '', -4, 0, 63)
check('0', '0', -4, 1, 63)
check('0', '0', -4, 2, 63)
check('0', '0', -4, 3, 63)
check('0', '0', -4, 4, 63)
check('0', '0', -3, None, 63)
check('0', '', -3, -4, 63)
check('0', '', -3, -3, 63)
check('0', '', -3, -2, 63)
check('0', '', -3, -1, 63)
check('0', '', -3, 0, 63)
check('0', '0', -3, 1, 63)
check('0', '0', -3, 2, 63)
check('0', '0', -3, 3, 63)
check('0', '0', -3, 4, 63)
check('0', '0', -2, None, 63)
check('0', '', -2, -4, 63)
check('0', '', -2, -3, 63)
check('0', '', -2, -2, 63)
check('0', '', -2, -1, 63)
check('0', '', -2, 0, 63)
check('0', '0', -2, 1, 63)
check('0', '0', -2, 2, 63)
check('0', '0', -2, 3, 63)
check('0', '0', -2, 4, 63)
check('0', '0', -1, None, 63)
check('0', '', -1, -4, 63)
check('0', '', -1, -3, 63)
check('0', '', -1, -2, 63)
check('0', '', -1, -1, 63)
check('0', '', -1, 0, 63)
check('0', '0', -1, 1, 63)
check('0', '0', -1, 2, 63)
check('0', '0', -1, 3, 63)
check('0', '0', -1, 4, 63)
check('0', '0', 0, None, 63)
check('0', '', 0, -4, 63)
check('0', '', 0, -3, 63)
check('0', '', 0, -2, 63)
check('0', '', 0, -1, 63)
check('0', '', 0, 0, 63)
check('0', '0', 0, 1, 63)
check('0', '0', 0, 2, 63)
check('0', '0', 0, 3, 63)
check('0', '0', 0, 4, 63)
check('0', '', 1, None, 63)
check('0', '', 1, -4, 0)
check('0', '', 1, -3, 0)
check('0', '', 1, -2, 0)
check('0', '', 1, -1, 0)
check('0', '', 1, 0, 0)
check('0', '', 1, 1, 63)
check('0', '', 1, 2, 63)
check('0', '', 1, 3, 63)
check('0', '', 1, 4, 63)
check('0', '', 2, None, 0)
check('0', '', 2, -4, 0)
check('0', '', 2, -3, 0)
check('0', '', 2, -2, 0)
check('0', '', 2, -1, 0)
check('0', '', 2, 0, 0)
check('0', '', 2, 1, 0)
check('0', '', 2, 2, 0)
check('0', '', 2, 3, 0)
check('0', '', 2, 4, 0)
check('0', '', 3, None, 0)
check('0', '', 3, -4, 0)
check('0', '', 3, -3, 0)
check('0', '', 3, -2, 0)
check('0', '', 3, -1, 0)
check('0', '', 3, 0, 0)
check('0', '', 3, 1, 0)
check('0', '', 3, 2, 0)
check('0', '', 3, 3, 0)
check('0', '', 3, 4, 0)
check('0', '', 4, None, 0)
check('0', '', 4, -4, 0)
check('0', '', 4, -3, 0)
check('0', '', 4, -2, 0)
check('0', '', 4, -1, 0)
check('0', '', 4, 0, 0)
check('0', '', 4, 1, 0)
check('0', '', 4, 2, 0)
check('0', '', 4, 3, 0)
check('0', '', 4, 4, 0)
check('01', '01', None, None, 63)
check('01', '', None, -4, 63)
check('01', '', None, -3, 63)
check('01', '', None, -2, 63)
check('01', '0', None, -1, 63)
check('01', '', None, 0, 63)
check('01', '0', None, 1, 63)
check('01', '01', None, 2, 63)
check('01', '01', None, 3, 63)
check('01', '01', None, 4, 63)
check('01', '01', -4, None, 63)
check('01', '', -4, -4, 63)
check('01', '', -4, -3, 63)
check('01', '', -4, -2, 63)
check('01', '0', -4, -1, 63)
check('01', '', -4, 0, 63)
check('01', '0', -4, 1, 63)
check('01', '01', -4, 2, 63)
check('01', '01', -4, 3, 63)
check('01', '01', -4, 4, 63)
check('01', '01', -3, None, 63)
check('01', '', -3, -4, 63)
check('01', '', -3, -3, 63)
check('01', '', -3, -2, 63)
check('01', '0', -3, -1, 63)
check('01', '', -3, 0, 63)
check('01', '0', -3, 1, 63)
check('01', '01', -3, 2, 63)
check('01', '01', -3, 3, 63)
check('01', '01', -3, 4, 63)
check('01', '01', -2, None, 63)
check('01', '', -2, -4, 63)
check('01', '', -2, -3, 63)
check('01', '', -2, -2, 63)
check('01', '0', -2, -1, 63)
check('01', '', -2, 0, 63)
check('01', '0', -2, 1, 63)
check('01', '01', -2, 2, 63)
check('01', '01', -2, 3, 63)
check('01', '01', -2, 4, 63)
check('01', '1', -1, None, 63)
check('01', '', -1, -4, 0)
check('01', '', -1, -3, 0)
check('01', '', -1, -2, 0)
check('01', '', -1, -1, 63)
check('01', '', -1, 0, 0)
check('01', '', -1, 1, 63)
check('01', '1', -1, 2, 63)
check('01', '1', -1, 3, 63)
check('01', '1', -1, 4, 63)
check('01', '01', 0, None, 63)
check('01', '', 0, -4, 63)
check('01', '', 0, -3, 63)
check('01', '', 0, -2, 63)
check('01', '0', 0, -1, 63)
check('01', '', 0, 0, 63)
check('01', '0', 0, 1, 63)
check('01', '01', 0, 2, 63)
check('01', '01', 0, 3, 63)
check('01', '01', 0, 4, 63)
check('01', '1', 1, None, 63)
check('01', '', 1, -4, 0)
check('01', '', 1, -3, 0)
check('01', '', 1, -2, 0)
check('01', '', 1, -1, 63)
check('01', '', 1, 0, 0)
check('01', '', 1, 1, 63)
check('01', '1', 1, 2, 63)
check('01', '1', 1, 3, 63)
check('01', '1', 1, 4, 63)
check('01', '', 2, None, 63)
check('01', '', 2, -4, 0)
check('01', '', 2, -3, 0)
check('01', '', 2, -2, 0)
check('01', '', 2, -1, 0)
check('01', '', 2, 0, 0)
check('01', '', 2, 1, 0)
check('01', '', 2, 2, 63)
check('01', '', 2, 3, 63)
check('01', '', 2, 4, 63)
check('01', '', 3, None, 0)
check('01', '', 3, -4, 0)
check('01', '', 3, -3, 0)
check('01', '', 3, -2, 0)
check('01', '', 3, -1, 0)
check('01', '', 3, 0, 0)
check('01', '', 3, 1, 0)
check('01', '', 3, 2, 0)
check('01', '', 3, 3, 0)
check('01', '', 3, 4, 0)
check('01', '', 4, None, 0)
check('01', '', 4, -4, 0)
check('01', '', 4, -3, 0)
check('01', '', 4, -2, 0)
check('01', '', 4, -1, 0)
check('01', '', 4, 0, 0)
check('01', '', 4, 1, 0)
check('01', '', 4, 2, 0)
check('01', '', 4, 3, 0)
check('01', '', 4, 4, 0)
check('01', '01', None, None, 63)
check('01', '', None, -4, 63)
check('01', '', None, -3, 63)
check('01', '', None, -2, 63)
check('01', '0', None, -1, 63)
check('01', '', None, 0, 63)
check('01', '0', None, 1, 63)
check('01', '01', None, 2, 63)
check('01', '01', None, 3, 63)
check('01', '01', None, 4, 63)
check('01', '01', -4, None, 63)
check('01', '', -4, -4, 63)
check('01', '', -4, -3, 63)
check('01', '', -4, -2, 63)
check('01', '0', -4, -1, 63)
check('01', '', -4, 0, 63)
check('01', '0', -4, 1, 63)
check('01', '01', -4, 2, 63)
check('01', '01', -4, 3, 63)
check('01', '01', -4, 4, 63)
check('01', '01', -3, None, 63)
check('01', '', -3, -4, 63)
check('01', '', -3, -3, 63)
check('01', '', -3, -2, 63)
check('01', '0', -3, -1, 63)
check('01', '', -3, 0, 63)
check('01', '0', -3, 1, 63)
check('01', '01', -3, 2, 63)
check('01', '01', -3, 3, 63)
check('01', '01', -3, 4, 63)
check('01', '01', -2, None, 63)
check('01', '', -2, -4, 63)
check('01', '', -2, -3, 63)
check('01', '', -2, -2, 63)
check('01', '0', -2, -1, 63)
check('01', '', -2, 0, 63)
check('01', '0', -2, 1, 63)
check('01', '01', -2, 2, 63)
check('01', '01', -2, 3, 63)
check('01', '01', -2, 4, 63)
check('01', '1', -1, None, 63)
check('01', '', -1, -4, 0)
check('01', '', -1, -3, 0)
check('01', '', -1, -2, 0)
check('01', '', -1, -1, 63)
check('01', '', -1, 0, 0)
check('01', '', -1, 1, 63)
check('01', '1', -1, 2, 63)
check('01', '1', -1, 3, 63)
check('01', '1', -1, 4, 63)
check('01', '01', 0, None, 63)
check('01', '', 0, -4, 63)
check('01', '', 0, -3, 63)
check('01', '', 0, -2, 63)
check('01', '0', 0, -1, 63)
check('01', '', 0, 0, 63)
check('01', '0', 0, 1, 63)
check('01', '01', 0, 2, 63)
check('01', '01', 0, 3, 63)
check('01', '01', 0, 4, 63)
check('01', '1', 1, None, 63)
check('01', '', 1, -4, 0)
check('01', '', 1, -3, 0)
check('01', '', 1, -2, 0)
check('01', '', 1, -1, 63)
check('01', '', 1, 0, 0)
check('01', '', 1, 1, 63)
check('01', '1', 1, 2, 63)
check('01', '1', 1, 3, 63)
check('01', '1', 1, 4, 63)
check('01', '', 2, None, 63)
check('01', '', 2, -4, 0)
check('01', '', 2, -3, 0)
check('01', '', 2, -2, 0)
check('01', '', 2, -1, 0)
check('01', '', 2, 0, 0)
check('01', '', 2, 1, 0)
check('01', '', 2, 2, 63)
check('01', '', 2, 3, 63)
check('01', '', 2, 4, 63)
check('01', '', 3, None, 0)
check('01', '', 3, -4, 0)
check('01', '', 3, -3, 0)
check('01', '', 3, -2, 0)
check('01', '', 3, -1, 0)
check('01', '', 3, 0, 0)
check('01', '', 3, 1, 0)
check('01', '', 3, 2, 0)
check('01', '', 3, 3, 0)
check('01', '', 3, 4, 0)
check('01', '', 4, None, 0)
check('01', '', 4, -4, 0)
check('01', '', 4, -3, 0)
check('01', '', 4, -2, 0)
check('01', '', 4, -1, 0)
check('01', '', 4, 0, 0)
check('01', '', 4, 1, 0)
check('01', '', 4, 2, 0)
check('01', '', 4, 3, 0)
check('01', '', 4, 4, 0)
check('01', '01', None, None, 63)
check('01', '', None, -4, 63)
check('01', '', None, -3, 63)
check('01', '', None, -2, 63)
check('01', '0', None, -1, 63)
check('01', '', None, 0, 63)
check('01', '0', None, 1, 63)
check('01', '01', None, 2, 63)
check('01', '01', None, 3, 63)
check('01', '01', None, 4, 63)
check('01', '01', -4, None, 63)
check('01', '', -4, -4, 63)
check('01', '', -4, -3, 63)
check('01', '', -4, -2, 63)
check('01', '0', -4, -1, 63)
check('01', '', -4, 0, 63)
check('01', '0', -4, 1, 63)
check('01', '01', -4, 2, 63)
check('01', '01', -4, 3, 63)
check('01', '01', -4, 4, 63)
check('01', '01', -3, None, 63)
check('01', '', -3, -4, 63)
check('01', '', -3, -3, 63)
check('01', '', -3, -2, 63)
check('01', '0', -3, -1, 63)
check('01', '', -3, 0, 63)
check('01', '0', -3, 1, 63)
check('01', '01', -3, 2, 63)
check('01', '01', -3, 3, 63)
check('01', '01', -3, 4, 63)
check('01', '01', -2, None, 63)
check('01', '', -2, -4, 63)
check('01', '', -2, -3, 63)
check('01', '', -2, -2, 63)
check('01', '0', -2, -1, 63)
check('01', '', -2, 0, 63)
check('01', '0', -2, 1, 63)
check('01', '01', -2, 2, 63)
check('01', '01', -2, 3, 63)
check('01', '01', -2, 4, 63)
check('01', '1', -1, None, 63)
check('01', '', -1, -4, 0)
check('01', '', -1, -3, 0)
check('01', '', -1, -2, 0)
check('01', '', -1, -1, 63)
check('01', '', -1, 0, 0)
check('01', '', -1, 1, 63)
check('01', '1', -1, 2, 63)
check('01', '1', -1, 3, 63)
check('01', '1', -1, 4, 63)
check('01', '01', 0, None, 63)
check('01', '', 0, -4, 63)
check('01', '', 0, -3, 63)
check('01', '', 0, -2, 63)
check('01', '0', 0, -1, 63)
check('01', '', 0, 0, 63)
check('01', '0', 0, 1, 63)
check('01', '01', 0, 2, 63)
check('01', '01', 0, 3, 63)
check('01', '01', 0, 4, 63)
check('01', '1', 1, None, 63)
check('01', '', 1, -4, 0)
check('01', '', 1, -3, 0)
check('01', '', 1, -2, 0)
check('01', '', 1, -1, 63)
check('01', '', 1, 0, 0)
check('01', '', 1, 1, 63)
check('01', '1', 1, 2, 63)
check('01', '1', 1, 3, 63)
check('01', '1', 1, 4, 63)
check('01', '', 2, None, 63)
check('01', '', 2, -4, 0)
check('01', '', 2, -3, 0)
check('01', '', 2, -2, 0)
check('01', '', 2, -1, 0)
check('01', '', 2, 0, 0)
check('01', '', 2, 1, 0)
check('01', '', 2, 2, 63)
check('01', '', 2, 3, 63)
check('01', '', 2, 4, 63)
check('01', '', 3, None, 0)
check('01', '', 3, -4, 0)
check('01', '', 3, -3, 0)
check('01', '', 3, -2, 0)
check('01', '', 3, -1, 0)
check('01', '', 3, 0, 0)
check('01', '', 3, 1, 0)
check('01', '', 3, 2, 0)
check('01', '', 3, 3, 0)
check('01', '', 3, 4, 0)
check('01', '', 4, None, 0)
check('01', '', 4, -4, 0)
check('01', '', 4, -3, 0)
check('01', '', 4, -2, 0)
check('01', '', 4, -1, 0)
check('01', '', 4, 0, 0)
check('01', '', 4, 1, 0)
check('01', '', 4, 2, 0)
check('01', '', 4, 3, 0)
check('01', '', 4, 4, 0)
check('01', '01', None, None, 63)
check('01', '', None, -4, 63)
check('01', '', None, -3, 63)
check('01', '', None, -2, 63)
check('01', '0', None, -1, 63)
check('01', '', None, 0, 63)
check('01', '0', None, 1, 63)
check('01', '01', None, 2, 63)
check('01', '01', None, 3, 63)
check('01', '01', None, 4, 63)
check('01', '01', -4, None, 63)
check('01', '', -4, -4, 63)
check('01', '', -4, -3, 63)
check('01', '', -4, -2, 63)
check('01', '0', -4, -1, 63)
check('01', '', -4, 0, 63)
check('01', '0', -4, 1, 63)
check('01', '01', -4, 2, 63)
check('01', '01', -4, 3, 63)
check('01', '01', -4, 4, 63)
check('01', '01', -3, None, 63)
check('01', '', -3, -4, 63)
check('01', '', -3, -3, 63)
check('01', '', -3, -2, 63)
check('01', '0', -3, -1, 63)
check('01', '', -3, 0, 63)
check('01', '0', -3, 1, 63)
check('01', '01', -3, 2, 63)
check('01', '01', -3, 3, 63)
check('01', '01', -3, 4, 63)
check('01', '01', -2, None, 63)
check('01', '', -2, -4, 63)
check('01', '', -2, -3, 63)
check('01', '', -2, -2, 63)
check('01', '0', -2, -1, 63)
check('01', '', -2, 0, 63)
check('01', '0', -2, 1, 63)
check('01', '01', -2, 2, 63)
check('01', '01', -2, 3, 63)
check('01', '01', -2, 4, 63)
check('01', '1', -1, None, 63)
check('01', '', -1, -4, 0)
check('01', '', -1, -3, 0)
check('01', '', -1, -2, 0)
check('01', '', -1, -1, 63)
check('01', '', -1, 0, 0)
check('01', '', -1, 1, 63)
check('01', '1', -1, 2, 63)
check('01', '1', -1, 3, 63)
check('01', '1', -1, 4, 63)
check('01', '01', 0, None, 63)
check('01', '', 0, -4, 63)
check('01', '', 0, -3, 63)
check('01', '', 0, -2, 63)
check('01', '0', 0, -1, 63)
check('01', '', 0, 0, 63)
check('01', '0', 0, 1, 63)
check('01', '01', 0, 2, 63)
check('01', '01', 0, 3, 63)
check('01', '01', 0, 4, 63)
check('01', '1', 1, None, 63)
check('01', '', 1, -4, 0)
check('01', '', 1, -3, 0)
check('01', '', 1, -2, 0)
check('01', '', 1, -1, 63)
check('01', '', 1, 0, 0)
check('01', '', 1, 1, 63)
check('01', '1', 1, 2, 63)
check('01', '1', 1, 3, 63)
check('01', '1', 1, 4, 63)
check('01', '', 2, None, 63)
check('01', '', 2, -4, 0)
check('01', '', 2, -3, 0)
check('01', '', 2, -2, 0)
check('01', '', 2, -1, 0)
check('01', '', 2, 0, 0)
check('01', '', 2, 1, 0)
check('01', '', 2, 2, 63)
check('01', '', 2, 3, 63)
check('01', '', 2, 4, 63)
check('01', '', 3, None, 0)
check('01', '', 3, -4, 0)
check('01', '', 3, -3, 0)
check('01', '', 3, -2, 0)
check('01', '', 3, -1, 0)
check('01', '', 3, 0, 0)
check('01', '', 3, 1, 0)
check('01', '', 3, 2, 0)
check('01', '', 3, 3, 0)
check('01', '', 3, 4, 0)
check('01', '', 4, None, 0)
check('01', '', 4, -4, 0)
check('01', '', 4, -3, 0)
check('01', '', 4, -2, 0)
check('01', '', 4, -1, 0)
check('01', '', 4, 0, 0)
check('01', '', 4, 1, 0)
check('01', '', 4, 2, 0)
check('01', '', 4, 3, 0)
check('01', '', 4, 4, 0)
check('012', '012', None, None, 63)
check('012', '', None, -4, 63)
check('012', '', None, -3, 63)
check('012', '0', None, -2, 63)
check('012', '01', None, -1, 63)
check('012', '', None, 0, 63)
check('012', '0', None, 1, 63)
check('012', '01', None, 2, 63)
check('012', '012', None, 3, 63)
check('012', '012', None, 4, 63)
check('012', '012', -4, None, 63)
check('012', '', -4, -4, 63)
check('012', '', -4, -3, 63)
check('012', '0', -4, -2, 63)
check('012', '01', -4, -1, 63)
check('012', '', -4, 0, 63)
check('012', '0', -4, 1, 63)
check('012', '01', -4, 2, 63)
check('012', '012', -4, 3, 63)
check('012', '012', -4, 4, 63)
check('012', '012', -3, None, 63)
check('012', '', -3, -4, 63)
check('012', '', -3, -3, 63)
check('012', '0', -3, -2, 63)
check('012', '01', -3, -1, 63)
check('012', '', -3, 0, 63)
check('012', '0', -3, 1, 63)
check('012', '01', -3, 2, 63)
check('012', '012', -3, 3, 63)
check('012', '012', -3, 4, 63)
check('012', '12', -2, None, 63)
check('012', '', -2, -4, 0)
check('012', '', -2, -3, 0)
check('012', '', -2, -2, 63)
check('012', '1', -2, -1, 63)
check('012', '', -2, 0, 0)
check('012', '', -2, 1, 63)
check('012', '1', -2, 2, 63)
check('012', '12', -2, 3, 63)
check('012', '12', -2, 4, 63)
check('012', '2', -1, None, 63)
check('012', '', -1, -4, 0)
check('012', '', -1, -3, 0)
check('012', '', -1, -2, 0)
check('012', '', -1, -1, 63)
check('012', '', -1, 0, 0)
check('012', '', -1, 1, 0)
check('012', '', -1, 2, 63)
check('012', '2', -1, 3, 63)
check('012', '2', -1, 4, 63)
check('012', '012', 0, None, 63)
check('012', '', 0, -4, 63)
check('012', '', 0, -3, 63)
check('012', '0', 0, -2, 63)
check('012', '01', 0, -1, 63)
check('012', '', 0, 0, 63)
check('012', '0', 0, 1, 63)
check('012', '01', 0, 2, 63)
check('012', '012', 0, 3, 63)
check('012', '012', 0, 4, 63)
check('012', '12', 1, None, 63)
check('012', '', 1, -4, 0)
check('012', '', 1, -3, 0)
check('012', '', 1, -2, 63)
check('012', '1', 1, -1, 63)
check('012', '', 1, 0, 0)
check('012', '', 1, 1, 63)
check('012', '1', 1, 2, 63)
check('012', '12', 1, 3, 63)
check('012', '12', 1, 4, 63)
check('012', '2', 2, None, 63)
check('012', '', 2, -4, 0)
check('012', '', 2, -3, 0)
check('012', '', 2, -2, 0)
check('012', '', 2, -1, 63)
check('012', '', 2, 0, 0)
check('012', '', 2, 1, 0)
check('012', '', 2, 2, 63)
check('012', '2', 2, 3, 63)
check('012', '2', 2, 4, 63)
check('012', '', 3, None, 63)
check('012', '', 3, -4, 0)
check('012', '', 3, -3, 0)
check('012', '', 3, -2, 0)
check('012', '', 3, -1, 0)
check('012', '', 3, 0, 0)
check('012', '', 3, 1, 0)
check('012', '', 3, 2, 0)
check('012', '', 3, 3, 63)
check('012', '', 3, 4, 63)
check('012', '', 4, None, 0)
check('012', '', 4, -4, 0)
check('012', '', 4, -3, 0)
check('012', '', 4, -2, 0)
check('012', '', 4, -1, 0)
check('012', '', 4, 0, 0)
check('012', '', 4, 1, 0)
check('012', '', 4, 2, 0)
check('012', '', 4, 3, 0)
check('012', '', 4, 4, 0)
check('012', '012', None, None, 63)
check('012', '', None, -4, 63)
check('012', '', None, -3, 63)
check('012', '0', None, -2, 63)
check('012', '01', None, -1, 63)
check('012', '', None, 0, 63)
check('012', '0', None, 1, 63)
check('012', '01', None, 2, 63)
check('012', '012', None, 3, 63)
check('012', '012', None, 4, 63)
check('012', '012', -4, None, 63)
check('012', '', -4, -4, 63)
check('012', '', -4, -3, 63)
check('012', '0', -4, -2, 63)
check('012', '01', -4, -1, 63)
check('012', '', -4, 0, 63)
check('012', '0', -4, 1, 63)
check('012', '01', -4, 2, 63)
check('012', '012', -4, 3, 63)
check('012', '012', -4, 4, 63)
check('012', '012', -3, None, 63)
check('012', '', -3, -4, 63)
check('012', '', -3, -3, 63)
check('012', '0', -3, -2, 63)
check('012', '01', -3, -1, 63)
check('012', '', -3, 0, 63)
check('012', '0', -3, 1, 63)
check('012', '01', -3, 2, 63)
check('012', '012', -3, 3, 63)
check('012', '012', -3, 4, 63)
check('012', '12', -2, None, 63)
check('012', '', -2, -4, 0)
check('012', '', -2, -3, 0)
check('012', '', -2, -2, 63)
check('012', '1', -2, -1, 63)
check('012', '', -2, 0, 0)
check('012', '', -2, 1, 63)
check('012', '1', -2, 2, 63)
check('012', '12', -2, 3, 63)
check('012', '12', -2, 4, 63)
check('012', '2', -1, None, 63)
check('012', '', -1, -4, 0)
check('012', '', -1, -3, 0)
check('012', '', -1, -2, 0)
check('012', '', -1, -1, 63)
check('012', '', -1, 0, 0)
check('012', '', -1, 1, 0)
check('012', '', -1, 2, 63)
check('012', '2', -1, 3, 63)
check('012', '2', -1, 4, 63)
check('012', '012', 0, None, 63)
check('012', '', 0, -4, 63)
check('012', '', 0, -3, 63)
check('012', '0', 0, -2, 63)
check('012', '01', 0, -1, 63)
check('012', '', 0, 0, 63)
check('012', '0', 0, 1, 63)
check('012', '01', 0, 2, 63)
check('012', '012', 0, 3, 63)
check('012', '012', 0, 4, 63)
check('012', '12', 1, None, 63)
check('012', '', 1, -4, 0)
check('012', '', 1, -3, 0)
check('012', '', 1, -2, 63)
check('012', '1', 1, -1, 63)
check('012', '', 1, 0, 0)
check('012', '', 1, 1, 63)
check('012', '1', 1, 2, 63)
check('012', '12', 1, 3, 63)
check('012', '12', 1, 4, 63)
check('012', '2', 2, None, 63)
check('012', '', 2, -4, 0)
check('012', '', 2, -3, 0)
check('012', '', 2, -2, 0)
check('012', '', 2, -1, 63)
check('012', '', 2, 0, 0)
check('012', '', 2, 1, 0)
check('012', '', 2, 2, 63)
check('012', '2', 2, 3, 63)
check('012', '2', 2, 4, 63)
check('012', '', 3, None, 63)
check('012', '', 3, -4, 0)
check('012', '', 3, -3, 0)
check('012', '', 3, -2, 0)
check('012', '', 3, -1, 0)
check('012', '', 3, 0, 0)
check('012', '', 3, 1, 0)
check('012', '', 3, 2, 0)
check('012', '', 3, 3, 63)
check('012', '', 3, 4, 63)
check('012', '', 4, None, 0)
check('012', '', 4, -4, 0)
check('012', '', 4, -3, 0)
check('012', '', 4, -2, 0)
check('012', '', 4, -1, 0)
check('012', '', 4, 0, 0)
check('012', '', 4, 1, 0)
check('012', '', 4, 2, 0)
check('012', '', 4, 3, 0)
check('012', '', 4, 4, 0)
check('012', '012', None, None, 63)
check('012', '', None, -4, 63)
check('012', '', None, -3, 63)
check('012', '0', None, -2, 63)
check('012', '01', None, -1, 63)
check('012', '', None, 0, 63)
check('012', '0', None, 1, 63)
check('012', '01', None, 2, 63)
check('012', '012', None, 3, 63)
check('012', '012', None, 4, 63)
check('012', '012', -4, None, 63)
check('012', '', -4, -4, 63)
check('012', '', -4, -3, 63)
check('012', '0', -4, -2, 63)
check('012', '01', -4, -1, 63)
check('012', '', -4, 0, 63)
check('012', '0', -4, 1, 63)
check('012', '01', -4, 2, 63)
check('012', '012', -4, 3, 63)
check('012', '012', -4, 4, 63)
check('012', '012', -3, None, 63)
check('012', '', -3, -4, 63)
check('012', '', -3, -3, 63)
check('012', '0', -3, -2, 63)
check('012', '01', -3, -1, 63)
check('012', '', -3, 0, 63)
check('012', '0', -3, 1, 63)
check('012', '01', -3, 2, 63)
check('012', '012', -3, 3, 63)
check('012', '012', -3, 4, 63)
check('012', '12', -2, None, 63)
check('012', '', -2, -4, 0)
check('012', '', -2, -3, 0)
check('012', '', -2, -2, 63)
check('012', '1', -2, -1, 63)
check('012', '', -2, 0, 0)
check('012', '', -2, 1, 63)
check('012', '1', -2, 2, 63)
check('012', '12', -2, 3, 63)
check('012', '12', -2, 4, 63)
check('012', '2', -1, None, 63)
check('012', '', -1, -4, 0)
check('012', '', -1, -3, 0)
check('012', '', -1, -2, 0)
check('012', '', -1, -1, 63)
check('012', '', -1, 0, 0)
check('012', '', -1, 1, 0)
check('012', '', -1, 2, 63)
check('012', '2', -1, 3, 63)
check('012', '2', -1, 4, 63)
check('012', '012', 0, None, 63)
check('012', '', 0, -4, 63)
check('012', '', 0, -3, 63)
check('012', '0', 0, -2, 63)
check('012', '01', 0, -1, 63)
check('012', '', 0, 0, 63)
check('012', '0', 0, 1, 63)
check('012', '01', 0, 2, 63)
check('012', '012', 0, 3, 63)
check('012', '012', 0, 4, 63)
check('012', '12', 1, None, 63)
check('012', '', 1, -4, 0)
check('012', '', 1, -3, 0)
check('012', '', 1, -2, 63)
check('012', '1', 1, -1, 63)
check('012', '', 1, 0, 0)
check('012', '', 1, 1, 63)
check('012', '1', 1, 2, 63)
check('012', '12', 1, 3, 63)
check('012', '12', 1, 4, 63)
check('012', '2', 2, None, 63)
check('012', '', 2, -4, 0)
check('012', '', 2, -3, 0)
check('012', '', 2, -2, 0)
check('012', '', 2, -1, 63)
check('012', '', 2, 0, 0)
check('012', '', 2, 1, 0)
check('012', '', 2, 2, 63)
check('012', '2', 2, 3, 63)
check('012', '2', 2, 4, 63)
check('012', '', 3, None, 63)
check('012', '', 3, -4, 0)
check('012', '', 3, -3, 0)
check('012', '', 3, -2, 0)
check('012', '', 3, -1, 0)
check('012', '', 3, 0, 0)
check('012', '', 3, 1, 0)
check('012', '', 3, 2, 0)
check('012', '', 3, 3, 63)
check('012', '', 3, 4, 63)
check('012', '', 4, None, 0)
check('012', '', 4, -4, 0)
check('012', '', 4, -3, 0)
check('012', '', 4, -2, 0)
check('012', '', 4, -1, 0)
check('012', '', 4, 0, 0)
check('012', '', 4, 1, 0)
check('012', '', 4, 2, 0)
check('012', '', 4, 3, 0)
check('012', '', 4, 4, 0)
check('012', '012', None, None, 63)
check('012', '', None, -4, 63)
check('012', '', None, -3, 63)
check('012', '0', None, -2, 63)
check('012', '01', None, -1, 63)
check('012', '', None, 0, 63)
check('012', '0', None, 1, 63)
check('012', '01', None, 2, 63)
check('012', '012', None, 3, 63)
check('012', '012', None, 4, 63)
check('012', '012', -4, None, 63)
check('012', '', -4, -4, 63)
check('012', '', -4, -3, 63)
check('012', '0', -4, -2, 63)
check('012', '01', -4, -1, 63)
check('012', '', -4, 0, 63)
check('012', '0', -4, 1, 63)
check('012', '01', -4, 2, 63)
check('012', '012', -4, 3, 63)
check('012', '012', -4, 4, 63)
check('012', '012', -3, None, 63)
check('012', '', -3, -4, 63)
check('012', '', -3, -3, 63)
check('012', '0', -3, -2, 63)
check('012', '01', -3, -1, 63)
check('012', '', -3, 0, 63)
check('012', '0', -3, 1, 63)
check('012', '01', -3, 2, 63)
check('012', '012', -3, 3, 63)
check('012', '012', -3, 4, 63)
check('012', '12', -2, None, 63)
check('012', '', -2, -4, 0)
check('012', '', -2, -3, 0)
check('012', '', -2, -2, 63)
check('012', '1', -2, -1, 63)
check('012', '', -2, 0, 0)
check('012', '', -2, 1, 63)
check('012', '1', -2, 2, 63)
check('012', '12', -2, 3, 63)
check('012', '12', -2, 4, 63)
check('012', '2', -1, None, 63)
check('012', '', -1, -4, 0)
check('012', '', -1, -3, 0)
check('012', '', -1, -2, 0)
check('012', '', -1, -1, 63)
check('012', '', -1, 0, 0)
check('012', '', -1, 1, 0)
check('012', '', -1, 2, 63)
check('012', '2', -1, 3, 63)
check('012', '2', -1, 4, 63)
check('012', '012', 0, None, 63)
check('012', '', 0, -4, 63)
check('012', '', 0, -3, 63)
check('012', '0', 0, -2, 63)
check('012', '01', 0, -1, 63)
check('012', '', 0, 0, 63)
check('012', '0', 0, 1, 63)
check('012', '01', 0, 2, 63)
check('012', '012', 0, 3, 63)
check('012', '012', 0, 4, 63)
check('012', '12', 1, None, 63)
check('012', '', 1, -4, 0)
check('012', '', 1, -3, 0)
check('012', '', 1, -2, 63)
check('012', '1', 1, -1, 63)
check('012', '', 1, 0, 0)
check('012', '', 1, 1, 63)
check('012', '1', 1, 2, 63)
check('012', '12', 1, 3, 63)
check('012', '12', 1, 4, 63)
check('012', '2', 2, None, 63)
check('012', '', 2, -4, 0)
check('012', '', 2, -3, 0)
check('012', '', 2, -2, 0)
check('012', '', 2, -1, 63)
check('012', '', 2, 0, 0)
check('012', '', 2, 1, 0)
check('012', '', 2, 2, 63)
check('012', '2', 2, 3, 63)
check('012', '2', 2, 4, 63)
check('012', '', 3, None, 63)
check('012', '', 3, -4, 0)
check('012', '', 3, -3, 0)
check('012', '', 3, -2, 0)
check('012', '', 3, -1, 0)
check('012', '', 3, 0, 0)
check('012', '', 3, 1, 0)
check('012', '', 3, 2, 0)
check('012', '', 3, 3, 63)
check('012', '', 3, 4, 63)
check('012', '', 4, None, 0)
check('012', '', 4, -4, 0)
check('012', '', 4, -3, 0)
check('012', '', 4, -2, 0)
check('012', '', 4, -1, 0)
check('012', '', 4, 0, 0)
check('012', '', 4, 1, 0)
check('012', '', 4, 2, 0)
check('012', '', 4, 3, 0)
check('012', '', 4, 4, 0)
