# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     ./generate_unicodedb.py --unidata_version=5.2.0 --output=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


base_mod = None
version = '5.2.0'


def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright, parentstr, codepoint = _charnodes[charnode:charnode+3]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)
        
        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError, name

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright, parentstr, codepoint = _charnodes[charnode:charnode+3]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.insert(0, substring)

        prevnode = charnode // 3
        charnode = parent

    return ''.join(res)
    

_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x14 ABOVE LEFT TRIANGLE'
'\x14 ABOVE SLANTED EQUAL'
'\x05 ADEG'
'\x06 AGUNG'
'\x04 ALL'
'\x05 ALLO'
'\x0f ALTERNATE FORM'
'\x11 ALTERNATION MARK'
'\x05 AMPS'
'\x03 AN'
'\x05 AND '
'\n AND ACUTE'
'\n AND BREVE'
'\x0e AND DIAERESIS'
'\x14 AND DIAGONAL STROKE'
'\x0e AND DOT ABOVE'
'\x10 AND HEAVY RIGHT'
'\t AND HOOK'
'\x10 AND LIGHT RIGHT'
'\x0f AND LOWER LEFT'
'\x10 AND LOWER RIGHT'
'\x0b AND MACRON'
'\x11 AND MIDDLE TILDE'
'\x13 AND PROSGEGRAMMENI'
'\x06 AND S'
'\x15 AND SLANTED PARALLEL'
'\x0e AND SMALL TAH'
'\x12 AND SMASH PRODUCT'
'\t AND TAIL'
'\x15 AND THREE DOTS ABOVE'
'\x13 AND TWO DOTS ABOVE'
'\x12 AND YPOGEGRAMMENI'
'\x07 APLOUN'
'\t APODEXIA'
'\t ARCHAION'
'\x06 ARROW'
'\r B BAR SYMBOL'
'\x05 BACK'
'\n BACKSLASH'
'\x04 BAR'
'\r BEHIND CLOUD'
'\x06 BELOW'
'\x1c BETWEEN TWO HORIZONTAL BARS'
'\r BLACK SQUARE'
'\x06 BLOCK'
'\r BZHI MIG CAN'
'\x04 C D'
'\x05 CAPO'
'\x06 CARET'
'\x08 CEDILLA'
'\x07 CER-WA'
'\x07 CHIKI '
'\x07 CIRCLE'
'\x05 CLEF'
'\x0f CLOUD AND RAIN'
'\x0f CORNER BRACKET'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING GABA'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x05 DEKA'
'\x0f DEYTEROU ICHOU'
'\r DIFFERENTIAL'
'\x0c DIMINUTION-'
'\r DIMINUTION-1'
'\x06 DIPLI'
'\x1b DIVIDED BY HORIZONTAL RULE'
'\x05 DOTS'
'\t DRACHMAS'
'\n ENCLOSURE'
'\x06 ENTRY'
'\t EQUAL TO'
'\x07 EQUALS'
'\x06 EQUID'
'\x03 FA'
'\x05 FACE'
'\x07 FLEXUS'
'\t FORM TWO'
'\t FROM BAR'
'\n FROM WALL'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\t GARSHUNI'
'\x05 GORA'
'\x07 GROUND'
'\x05 GUNU'
'\x05 HAA '
'\x08 HANDLES'
'\x06 HANDS'
'\x0e HASER FOR VAV'
'\x03 HE'
'\r HEADED ARROW'
'\x03 HU'
'\x08 HUNDRED'
'\x17 HUNDRED TWENTY-EIGHTH '
'\x07 HYPHEN'
'\x05 ILUT'
'\x03 IN'
'\x13 IN A RECTANGLE BOX'
'\x0c IN TRIANGLE'
'\x10 INSERTION POINT'
'\x0e ISOLATED FORM'
'\x05 JERA'
'\x02 K'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x07 KEFULA'
'\x08 KEMBANG'
'\x0e KISIM5 TIMES '
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\n LATE FORM'
'\x05 LEFT'
'\x06 LELET'
'\x06 LENGA'
'\x1a LESS THAN THE DENOMINATOR'
'\x05 LINE'
'\x0c LINE SYMBOL'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\n MAHAPRANA'
'\x05 MARK'
'\x05 MEGA'
'\x06 MELIK'
'\x07 MENDUT'
'\x07 MUQDAM'
'\x06 MURDA'
'\x1a NEGATED WITH VERTICAL BAR'
'\x04 NEO'
'\x04 NOT'
'\n NOTATION '
'\n NOTEHEAD '
'\x08 NUTILLU'
'\x03 OF'
'\x04 OF '
'\n OF DHARMA'
'\x04 OHM'
'\x10 ON BLACK SQUARE'
'\x0c ON PEDESTAL'
'\t OPENING '
'\t OPERATOR'
'\x0f OPERATOR WITH '
'\r OPPOSING KUR'
'\x04 OR '
'\x1a OR APPROXIMATELY EQUAL TO'
'\t OR EQUAL'
'\x0c OR EQUAL TO'
'\x10 OR THE IMAGE OF'
'\x08 OTTAVA '
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x08 OVER KG'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x07 OVER M'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x1d OVER RIGHTWARDS ARROW TO BAR'
'\x07 OVER S'
'\x0f OVER SIG4 SHU2'
'\x08 OVER SU'
'\x18 OVER TOP SQUARE BRACKET'
'\x14 OVER TUR ZA OVER ZA'
'\x0c OVER TWO PI'
'\x08 OVER ZI'
'\x02 P'
'\x0f PARESTIGMENON '
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\x12 PLUS LU PLUS ESH2'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\x11 PLUS SHA3 PLUS A'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x0f POINTING INDEX'
'\x0b PROPORTION'
'\x11 PUNCTUATION MARK'
'\x06 QATAN'
'\x0f QUOTATION MARK'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x05 REST'
'\n RESUPINUS'
'\n RGYA GRAM'
'\x04 RHO'
'\x06 RIGHT'
'\x08 ROTUNDA'
'\x03 SA'
'\x05 SARI'
'\n SCHROEDER'
'\n SEPARATOR'
'\x05 SHAD'
'\x0b SHOE STILE'
'\x05 SIGN'
'\x06 SIGN '
'\x0c SKEWED LEFT'
'\r SKEWED RIGHT'
'\x08 SLIDING'
'\x07 SLOWLY'
'\x06 SMALL'
'\x10 SOLIDUS OVERLAY'
'\x08 SQUARED'
'\x08 STATERS'
'\x07 STRIDE'
'\x03 SU'
'\x07 SYMBOL'
'\x05 TACK'
'\x0b TACK BELOW'
'\x05 TAIL'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\x0f THROUGH CIRCLE'
'\x12 THROUGH DESCENDER'
'\x07 TIMES '
'\x08 TIMES A'
'\x10 TIMES A PLUS NA'
'\n TIMES BAD'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x08 TIMES U'
'\x11 TO BLACK DIAMOND'
'\x06 TONE-'
'\t TROMIKON'
'\x08 TTUDDAG'
'" TWO DOTS OVER ONE DOT PUNCTUATION'
'\x02 U'
'\t UNDERBAR'
'\x03 UP'
'\x0b UPPER HALF'
'\r VARIANT FORM'
'\x05 WITH'
'\x06 WITH '
'\n WITH BASE'
'\x0b WITH CARON'
'\x0c WITH CIRCLE'
'\x12 WITH CIRCLE ABOVE'
'\x12 WITH CIRCLE BELOW'
'\x17 WITH CIRCUMFLEX ACCENT'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x07 WITH D'
'\x0c WITH DAGESH'
'\x0b WITH DASIA'
'\x0f WITH DESCENDER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'\n WITH DOT '
'\x0f WITH DOT ABOVE'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE GRAVE ACCENT'
'\x14 WITH FATHATAN ABOVE'
'\x0e WITH FISHHOOK'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH JEGOGAN'
'\x0e WITH LONG LEG'
'\x0b WITH MAPIQ'
'\r WITH OVERBAR'
'\x12 WITH PALATAL HOOK'
'\n WITH PLUS'
'\x14 WITH RETROFLEX HOOK'
'\x1d WITH REVERSED NEGATION SLASH'
'\x07 WITH S'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\r WITH TEE TOP'
'\n WITH TICK'
'\x11 WITH TILDE ABOVE'
'\x0b WITH TITLO'
'\x0e WITH UNDERBAR'
'\r WITHOUT SNOW'
'\x07 WOLOSO'
'\x01-'
'\x02-0'
'\x02-2'
'\x11-9 QUOTATION MARK'
'\x02-A'
'\x05-ALAF'
'\x05-ARY '
'\x05-BEAM'
'\x0c-BREAK SPACE'
'\x10-BREAKING HYPHEN'
'\x0f-CARRIER LETTER'
'\x06-CREE '
'\x07-CREE R'
'\x08-CREE TH'
'\x0e-CURRENCY SIGN'
'\x0c-DZUD RTAGS '
'\r-ESASA DOTTED'
'\x0b-FEATHERED '
'\x1b-FEATHERED RIGHTWARDS ARROW'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x1f-HEADED ARROW FROM SMALL CIRCLE'
'\x18-HEADED RIGHTWARDS ARROW'
'\x06-HIDET'
'\x06-HIEUH'
'\n-HIRAGANA '
'\x1e-HIRAGANA PROLONGED SOUND MARK'
'\x02-I'
'\x06-IEUNG'
'\x07-INDIC '
'\x08-KHIEUKH'
'\t-KHYUD PA'
'\x07-KIYEOK'
'\x0b-LINE STAFF'
'\n-LUE KARAN'
'\x07-MACRON'
'\x06-MINUS'
'\x0b-MINUS SIGN'
'\x02-O'
'\x04-ONE'
'\r-OR-PLUS SIGN'
'\r-PER-EM SPACE'
'\x08-PHIEUPH'
'\x06-PIEUP'
'\n-POINTING '
'\x10-POINTING ANGLE '
' -POINTING ANGLE BRACKET ORNAMENT'
'\x18-POINTING TRIANGLE WITH '
'\x15-ROUND NOTEHEAD DOWN '
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SIMPLIFIED '
'\x05-SIOS'
'\t-STACCATO'
'\x0e-STEM TONE BAR'
'\x05-TAIL'
'\x03-TE'
'\x07-TIKEUT'
'\x02-U'
'\x04-UM '
'\x02-W'
'\x010'
'\x080 BRONZE'
'\x050 DWO'
'\x0b0 FOOTSTOOL'
'\x040 KO'
'\x040 MA'
'\x050 MAN'
'\x040 NI'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x070 SPEAR'
'\x030 U'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 ZO'
'\x030-0'
'\x0207'
'\x0209'
'\x030B9'
'\x011'
'\x071 ARROW'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DU'
'\x051 DWE'
'\x061 GOLD'
'\x081 HELMET'
'\x061 HORN'
'\x041 KU'
'\x031 O'
'\n1 PLASTICS'
'\x041 PO'
'\x041 QI'
'\x041 SA'
'\x041 SI'
'\x051 TWO'
'\x061 WINE'
'\x031-0'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x012'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\n2 PLASTICS'
'\n2 PLUS ASH'
'\n2 PLUS GAL'
'\x0b2 PLUS GIR2'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x042 SO'
'\x042 WO'
'\x072 WOMAN'
'\x032-0'
'\x0220'
'\x0221'
'\x0222'
'\t247 DIPTE'
'\x03253'
'\x0229'
'\x022D'
'\x032DD'
'\x022F'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x043 PA'
'\n3 PLASTICS'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x073 WHEEL'
'\x033-0'
'\x03305'
'\x0234'
'\x0239'
'\x014'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x044 KE'
'\x044 NE'
'\n4 PLASTICS'
'\x044 TE'
'\x044 WA'
'\x044 ZE'
'\x034-0'
'\x0240'
'\x03439'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AU'
'\t5 BATHTUB'
'\t5 CYPERUS'
'\x045 DE'
'\x045 JU'
'\x065 MERI'
'\x045 MO'
'\x045 NU'
'\n5 PLASTICS'
'\x045 TO'
'\x045 WE'
'\x065 WOOL'
'\x035-0'
'\x0250'
'\x0351F'
'\x0253'
'\x0255'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x016'
'\x046 JE'
'\x046 JO'
'\x046 NA'
'\n6 PLASTICS'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x056 TA2'
'\x066 TREE'
'\x036-0'
'\x03620'
'\x036D7'
'\x017'
'\x047 DI'
'\x047 JA'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\n7 PLASTICS'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 ZA'
'\x0270'
'\x0372C'
'\x0279'
'\x018'
'\x038 A'
'\x038 E'
'\x038 I'
'\x088 KANAKO'
'\x058 NWA'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 TA'
'\x049 TU'
'\x04904A'
'\x0295'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x07A -PHRU'
'\x06A HAAM'
'\x04A IE'
'\x07A NAME '
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\nA TANG LAI'
'\x05A UNA'
'\x14A- SHOG GI MGO RGYAN'
'\x04A-HA'
'\x05A-ROL'
'\x02A0'
'\x02A2'
'\x02A4'
'\x02AA'
'\x05AADHU'
'\x03AAF'
'\x04AAFU'
'\x05AAMAE'
'\x04AAMU'
'\x03AAN'
'\x02AB'
'\nAB2 TIMES '
'\x08ABAAFILI'
'\x11ABBREVIATION MARK'
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x04ABLE'
'\tABLED CAR'
'\x08ABOAFILI'
'\x04ABOR'
'\x05ABOVE'
'\x06ABOVE '
'\x11ABOVE EQUALS SIGN'
'\x12ABOVE GREATER-THAN'
'&ABOVE LEFTWARDS HARPOON WITH BARB DOWN'
'\x0fABOVE LESS-THAN'
"'ABOVE RIGHTWARDS HARPOON WITH BARB DOWN"
'\x15ABOVE SHORT DOWN TACK'
'\tABOVE TO '
'\x02AC'
'\x05ACCAT'
'\x06ACCENT'
'\x07ACCENT '
'\x03ACE'
'\tACE NOTE '
'\nACE SYMBOL'
'\x03ACH'
'\x0fACHES THE LIMIT'
'\x03ACK'
'\nACK CIRCLE'
'\x0bACKNOWLEDGE'
'\x08ACKSPACE'
'\x05ACRON'
'\x03ACT'
'\x07ACTION '
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x15ACUTE AND HOOK SYMBOL'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x04ADDA'
'\nADDA WITH '
'\x05ADDAK'
'\x03ADE'
'\tADEG ADEG'
'\x04ADHE'
'\x04ADHU'
'\x10ADIAN SYLLABICS '
'\tADMA GDAN'
'\x03ADU'
'\x02AE'
'\nAEDA-PILLA'
'\x03AEF'
'\nAELA-PILLA'
'\x07AELAENG'
'\x03AEM'
'\x0bAESCULAPIUS'
'\x06AESURA'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x08AF WITH '
'\x02AG'
'\x03AG-'
'\x04AGAB'
'\x0bAGAZ DAEG D'
'\x06AGE OF'
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x03AGL'
'\x05AGMA '
'\tAGOLITIC '
'\x04AGON'
'\x06AGRANT'
'\x02AH'
'\x03AH '
'\x04AH I'
'\x08AH WITH '
'\x04AHAD'
'\x07AHAPAKH'
'\x08AHAPRANA'
'\x02AI'
'\x0eAI LENGTH MARK'
'\tAIGHTNESS'
'\x03AIL'
'\nAILED BIRD'
'\x0eAILLE PATTERN '
'\x0bAILLESS PHI'
'\x04AILM'
'\x06AILURE'
'\x03AIN'
'\x05AINS '
'\x06AISED '
'\tAISED DOT'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x08AIYANNOI'
'\tAJANYALAN'
'\x02AK'
'\x06AKABAT'
'\x03AKE'
'\x15AKIA TELOUS ICHIMATOS'
'\nAKKHANGYAO'
'\x04AKRA'
'\x02AL'
'\nAL BARLINE'
'\x0fAL INTERSECTION'
'\x07AL SIGN'
'\nAL SYMBOL '
'\x05AL TO'
'&AL WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x03AL2'
'\x03ALA'
'\x04ALAF'
'\x04ALAG'
'\x04ALAI'
'\x05ALAPH'
'\x15ALATALIZED HOOK BELOW'
'\x05ALATH'
'\x0fALAYHE ASSALLAM'
'\x03ALC'
'\x04ALDA'
'\x03ALE'
'\x08ALE SIGN'
'\x04ALEF'
'\x05ALEF '
'\nALEF LAMED'
'\rALEF MAKSURA '
'\x17ALEF MAKSURA FINAL FORM'
'\x1aALEF MAKSURA ISOLATED FORM'
'\x16ALEF WITH LAM WITH YEH'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x07ALESMA '
'\x05ALETH'
'\x03ALF'
'\x05ALF H'
'\x0eALF TREE TRUNK'
'\x14ALF TRIANGULAR COLON'
'\x17ALGAMATION OR COPRODUCT'
'\tALI GALI '
'\x05ALING'
'\x03ALK'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'!ALL BUT UPPER LEFT QUADRANT BLACK'
'\x0eALLAJALALOUHOU'
'\x05ALLEY'
'\x05ALLI '
'\x08ALLIANCE'
'\x15ALLING DIAGONAL SLASH'
'\x07ALLOT X'
'\x08ALLY EQU'
'\x0fALMOST EQUAL TO'
'\x07ALOCHKA'
'\x05ALOG '
'\tALPAPRANA'
'\x05ALPHA'
'\x03ALT'
'\x04ALTA'
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x07AM ALEF'
'\x10AM ISOLATED FORM'
'\x07AMAKKAN'
'\x0fAMARITAN SOURCE'
'\x05AMATS'
'\x04AMBA'
'\x11AMBDA WITH STROKE'
'\x05AMBOO'
'\x04AMDA'
'\x03AME'
'\x04AME '
'\x07AME DOT'
'\x05AMED '
'\x05AMEKH'
'\x04AMIL'
'\x04AMLA'
'\x04AMMA'
'\x0eAMNUC PII KUUH'
'\x05AMOND'
'\x0fAMOUNT OF CHECK'
'\tAMPERSAND'
'\x11AMPHYLIAN DIGAMMA'
'\x04AMPI'
'\x08AMS HORN'
'\x02AN'
'\x07AN MARK'
'\x03AN2'
'\x03ANA'
'\x04ANA '
'\x04ANAP'
'\x04ANCH'
'\x06ANCHOR'
'\x03AND'
'\x04AND '
'\tAND ACUTE'
'\x0cAND CRESCENT'
'\x0fAND FEMALE SIGN'
'\x1eAND JOINED BY DASH WITH SUBSET'
'\x18AND MALE AND FEMALE SIGN'
'\x14AND NORTH EAST ARROW'
'\x14AND NORTH WEST ARROW'
'\x0cAND OPERATOR'
'\x0fAND PARALLEL TO'
'\x14AND SOUTH EAST ARROW'
'\x14AND SOUTH WEST ARROW'
'\x04ANDA'
'\x07ANDERER'
'\x08ANE TREE'
'\tANEROSIS '
'\x03ANG'
'\x04ANG '
'\x17ANG DEPARTING TONE MARK'
'\x0cANG KHANG GY'
'\x14ANGE ANTIRESTRICTION'
'\x06ANGKAT'
'\nANGKHANKHU'
'\x05ANGLE'
'\rANGLE BRACKET'
'\x06ANGUL '
'\x07ANGULAR'
'\nANGULAR TO'
'\rANNED LEATHER'
'\x0bANNOTATION '
'\x03ANO'
'\x08ANS SIGN'
'\nANS-SERIF '
'\x12ANS-SERIF CAPITAL '
'\x13ANS-SERIF CAPITAL L'
'\x06ANSIOS'
'\x13ANSPOSITION BRACKET'
'\x04ANT '
'\x0cANTARGOMUKHA'
'\tANTHAKHAT'
'\x13ANTICLOCKWISE ARROW'
'\x06ANUARY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\tAOS ICHOS'
'\x02AP'
'\tAP FILLER'
'\x03APA'
'\x07APEZIUM'
'\x03APH'
'\x06APISMA'
'\x06APITAL'
'\x07APITAL '
'\x08APITAL L'
'\x0eAPITAL LETTER '
'\x11APLI DYO DODEKATA'
'\x06APLI M'
'\x06APLOUN'
'\x04APON'
'\nAPOSTROPHE'
'\x04APPA'
'\x0bAPPROXIMATE'
'\tAPUN IYEK'
'\x07APYEOUN'
'\x0cAPYEOUNPIEUP'
'\x06APYRUS'
'\x02AR'
'\x04AR A'
'\x05AR AE'
'\x05AR B '
'\x0cAR DIAERESIS'
'\x08AR TSHES'
'\rAR WITH QUILL'
'\x04ARA '
'\x13ARABIC FORM SHAPING'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x06ARADDO'
'\x12ARAGRAPH SEPARATOR'
'\nARAKALESMA'
'\x07ARALLEL'
'\x0cARALLELOGRAM'
'\nARANI SIGN'
'\x04ARB '
'\x06ARBUTA'
'\x03ARC'
'\x04ARC '
'\x17ARC ANTICLOCKWISE ARROW'
'\rARCHAIC KOPPA'
'\tARCHAIC M'
'\x08ARCHAION'
'\x07ARDNESS'
'\x07ARDROP-'
'\x13ARENTHESIS NOTEHEAD'
'\x05ARERU'
'\x05ARET '
'\x03ARG'
'\x04ARGA'
'\x05ARGE '
'\x0bARGE CIRCLE'
'\x0bARGE SQUARE'
'\x04ARGI'
'\rARGOSYNTHETON'
'\x04ARIA'
'\x08ARISTERA'
'\tARISTERA '
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x08ARKLEAN '
'\rARLAUG SYMBOL'
'\x04ARON'
'\tAROSHTHI '
'\x0eAROUND-PROFILE'
'\x04ARP '
'\x0bARPEGGIATO '
'\x07ARRED B'
'\x07ARRED O'
'\x06ARRIER'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW ABOVE'
'\rARROW OVERLAY'
'\x18ARROW POINTING DIRECTLY '
'\tARROWHEAD'
'\x06ARSEOS'
'\x08ARSI YEH'
'\x08ART SUIT'
'\x06ARTER '
'\x04ARTH'
'\x13ARTIAL DIFFERENTIAL'
'\x08ARTYRIA '
'\x03ARU'
'\x14ARXIS KAI FTHORA VOU'
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\x03AS '
'\tAS MEMBER'
'\x07AS SIGN'
'\x03ASE'
'\x0bASE TO THE '
'\x05ASEIA'
'\x07ASES AS'
'\x03ASH'
"'ASH FROM LEFT MEMBER OF DOUBLE VERTICAL"
'\x04ASH2'
'\x0bASHED ARROW'
'&ASHED TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x06ASHGAB'
'\x04ASIA'
'\x05ASKAL'
'\x04ASLA'
'\x13ASOUL ISOLATED FORM'
'\x05ASPER'
'\x06ASSING'
'\x08AST WIND'
'\nASTERISCUS'
'\x08ASTERISK'
'\x1cASTERISKS ALIGNED VERTICALLY'
'\x11ASTERN PWO KAREN '
'\x08ASTERN W'
'\x12ASTROLOGICAL SIGN '
'\x03ASU'
'\x07ASURED '
'\x07ASUTORU'
'\x02AT'
'\x03AT '
'\x0fATA LINK ESCAPE'
'\x05ATAF '
'\x08ATAKANA '
'\nATAKANA DE'
'\x03ATE'
'\x08ATE MARK'
'\x04ATER'
'\nATER-THAN '
'\x03ATH'
'\x08ATH MARK'
'\x04ATHA'
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x04ATIM'
'\x05ATIN '
'\x12ATIN SMALL LETTER '
'\x0fATINATE MYSLITE'
'\x0bATION POINT'
'\x05ATIYA'
'\x0cATNAH HAFUKH'
'\nATRICHISMA'
'\x06ATTIC '
'\x04ATTO'
'\x0cATTOOED HEAD'
'\x07ATURAL '
'\x02AU'
'\x0eAU LENGTH MARK'
'\x11AUKAZ LAGU LOGR L'
'\x04AULA'
'\x07AULDRON'
'\x07AUNTLET'
'\x05AUTHS'
'\x06AUTUMN'
'\x02AV'
'\x03AVA'
'\x08AVAGRAHA'
'\x03AVE'
'\nAVE ACCENT'
'\tAVE ARROW'
'\x07AVIYANI'
'\x05AVROS'
'\x08AVY BAND'
'\x02AW'
'\x03AW '
'\rAWELLEMET YAZ'
'\x05AXIMA'
'\x07AXIMATA'
'\x02AY'
'\x03AY '
'\x07AY SIGN'
'\x07AYALAM '
'\x06AYANNA'
'\x03AYB'
'\x12AYHE ISOLATED FORM'
'\x04AYIN'
'\x03AZU'
'\x01B'
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\x03BAA'
'\x05BAARU'
'\x08BACK YER'
'\tBACKSLASH'
'\rBACKSLASH BAR'
'\x03BAD'
'\x06BAFILI'
'\x0eBAG MEMBERSHIP'
'\x0cBAHIRGOMUKHA'
'\x07BAIRKAN'
'\x05BALAG'
'\x17BALLOON-SPOKED ASTERISK'
'\x06BALUDA'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x06BANWA '
'\x03BAR'
'\x04BAR '
'\tBAR ABOVE'
'\x16BAR ABOVE INTERSECTION'
'\x0fBAR ABOVE UNION'
'\x05BARB '
'\x17BARBED RIGHTWARDS ARROW'
'\x07BARLINE'
'\x06BARREE'
'\x07BARREKH'
'\x04BASA'
'\x05BASA '
'\tBASE UNIT'
'\x04BASH'
'\x05BASSA'
'\x08BATBEIT '
'\x03BAU'
'\x07BAYANNA'
'\x02BB'
'\x10BBREVIATION MARK'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x07BE ROOT'
'\x04BEAM'
'\x03BEE'
'\x06BEFILI'
'\x06BEGIN '
'\x03BEH'
'\x05BEITH'
'\x0fBELGTHOR SYMBOL'
'\x05BELOW'
'\x06BELOW '
'\x0fBELOW LONG DASH'
'\x03BEN'
'\x04BEND'
'\x05BENDE'
'\x04BER '
'\x11BERBER ACADEMY YA'
'\x04BERD'
'\x18BERKANAN BEORC BJARKAN B'
'\x07BESIDE '
'#BESIDE AND JOINED WITH INTERSECTION'
'\x1cBESIDE AND JOINED WITH UNION'
'\x15BESIDE RIGHT TRIANGLE'
'\x03BET'
'\x04BETA'
'\x0bBETA SYMBOL'
'\x06BETAN '
'\x04BETH'
'\x08BEVERAGE'
'\x03BHA'
'\x05BHADH'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\x03BIE'
'\x07BIG YUS'
'\x03BIN'
'\x0fBINARY RELATION'
'\x05BINDI'
'\x0fBINDING BRACKET'
'\x07BINING '
'\x16BINING GEMINATION MARK'
'\x0cBINING MARK '
'\x04BIRD'
'\x05BIRGA'
'\x05BISAH'
'\x06BISHOP'
'\tBJARKAN B'
'\x0fBJOINED LETTER '
'\tBKHASIAN '
'\x03BLA'
'\x05BLACK'
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\x18BLACK LENTICULAR BRACKET'
'\x11BLACK SHOGI PIECE'
'\x0cBLACK SQUARE'
'\nBLACK STAR'
'\x0eBLACK TRIANGLE'
'\x0eBLADE SCISSORS'
'\x05BLANK'
'\x03BLE'
'\x08BLINEAR '
'\x05BLOCK'
'\x02BO'
'\tBO BAIMAI'
'\tBO GYFU G'
'\x06BOFILI'
'\x08BOL FOR '
'\x08BOL SIGN'
'\x05BOLD '
'\x04BORE'
'\x06BOTTOM'
'\x07BOTTOM '
'\rBOTTOM CORNER'
'\x11BOTTOM HALF BLACK'
'\x10BOTTOM HALF RING'
'\x0bBOTTOM MARK'
'#BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD'
'\x07BOURING'
'\x04BOVE'
'\x05BOVE '
'\x06BOWTIE'
'\x03BOX'
'\x02BR'
'\x03BRA'
'\x07BRACKET'
'\x11BRACKET EXTENSION'
'\x10BRACKET ORNAMENT'
'\x1bBRDA RNYING YIG MGO MDUN MA'
'\x1bBRDA RNYING YIG MGO SGAB MA'
'\x05BREVE'
'\x0bBREVE BELOW'
'\x07BREVIS '
'\x05BREW '
'\nBROKEN BAR'
'\tBRUL SHAD'
'\x02BS'
'\x0cBSCRIPT ALEF'
'\x04BSET'
'\x07BSET OF'
'\x14BSET OF NOR EQUAL TO'
'\nBSTRUCTION'
'\x03BU '
'\x06BULLET'
'\x0bBUMPY ABOVE'
'\x08BUNDANCE'
'\x03BUR'
'\x03BUT'
'\x19BUT NOT ACTUALLY EQUAL TO'
'\x0bBUT NOT EQU'
'\x15BUT NOT EQUIVALENT TO'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\rBY DEFINITION'
'\x0cBYSMAL WATER'
'\x0bBZHI -KHYIL'
'\x0cBZHI MIG CAN'
'\x01C'
'\x03C A'
'\x06C CLEF'
'\x13C DIGRAPH WITH CURL'
'\x16C GREATER-THAN BRACKET'
'\x13C LESS-THAN BRACKET'
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x05CAKRA'
'\x03CAL'
'\x11CAL SYMBOL BOTTOM'
'\x06CALATE'
'\x05CALYA'
'\x0bCAN RGYINGS'
'\x11CANCELLATION MARK'
'\x08CANDICUS'
'\x06CANDRA'
'\x07CANDRA '
'\x0cCANDRA BELOW'
'\x0bCANDRABINDU'
'\tCANG TE-U'
'\x12CANTILLATION SIGN '
'\x08CAPITAL '
'\tCAPITAL D'
'\tCAPITAL F'
'\tCAPITAL L'
'\x0fCAPITAL LETTER '
'\tCAPITAL Q'
'\x05CARET'
'\x0bCARET TILDE'
'\x06CARIK '
'\x05CARON'
'\x04CART'
'\x06CATAWA'
'\x05CAUDA'
'\x05CAUSE'
'\x07CAYANNA'
'\x04CAYN'
'\x02CC'
'\x06CCEEDS'
'\x05CCENT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x13CE OF INTEREST SIGN'
'\x08CE SKATE'
'\x05CECAK'
'\x05CECEK'
'\x05CEDES'
'\x0bCELANDIC-YR'
'\x07CELSIUS'
'\x0cCENDING NODE'
'\tCENT SIGN'
'\x07CENTRE '
'\x14CENTRE VERTICAL LINE'
'\x0eCENTURIAL SIGN'
'\x06CER-WA'
'\x05CEREK'
'\x03CES'
'\x02CH'
'\x03CH '
'\x03CHA'
'\nCHAD RTAGS'
'\x05CHADA'
'\x06CHADIN'
'\x0cCHAIR SYMBOL'
'\x06CHAMKO'
'\x08CHATTAWA'
'\tCHAVIYANI'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\x05CHED '
'\x04CHEE'
'\x04CHEH'
'\x08CHEIKHEI'
'\x07CHEINAP'
'\x06CHEMA '
'\x03CHI'
'\x07CHIEUCH'
'\x04CHIL'
'\x06CHIRET'
'\tCHMA SIGN'
'\x06CHO CH'
'\x05CHOOL'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHROMA SYNAFI'
'\rCHRYSANTHEMUM'
'\x07CHU CAN'
'\x05CHULA'
'\x06CHURCH'
'\x04CHWA'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x03CIG'
'\x06CIMAL '
'\x06CIRCLE'
'\x07CIRCLE '
'\rCIRCLE INSIDE'
'\x1bCIRCLE WITH NORTHWEST ARROW'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x13CIRCLED SANS-SERIF '
'\x0fCIRCUIT-OUTPUT '
'\nCIRCUMFLEX'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x17CIRCUMFLEX ACCENT ABOVE'
'\nCISIVENESS'
'\x07CISSORS'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x07CK MARK'
')CK-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x05CKING'
'\x06CKNESS'
'\x07CKWISE '
'\x05CLICK'
'\x05CLIFF'
'\x1aCLOCKWISE ARROW WITH MINUS'
'\x0fCLOSED BY CURVE'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x07CLOSURE'
'\x14CLUB-SPOKED ASTERISK'
'\x02CO'
'\x05COLON'
'\x0eCOLON OPERATOR'
'\x03COM'
'\nCOMBINING '
'\x05COMMA'
'\x0bCOMMA ABOVE'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x18COMPATIBILITY IDEOGRAPH-'
'\tCOMPLETED'
'\x0bCOMPOSITION'
'\x04COND'
'\x05COND '
'\x18CONSECUTIVE EQUALS SIGNS'
'\x0fCONSONANT SIGN '
'\x14CONSONANT SIGN HAARU'
'\x11CONSONANT SIGN PA'
'\x0bCONTAIN AS '
'\x1eCONTAINING BLACK SMALL DIAMOND'
'\x1dCONTAINING BLACK SMALL SQUARE'
'\x1bCONTINUOUS UNDERLINE SYMBOL'
'\x11CONTOURED OUTLINE'
'\x03COO'
'\x07COPTIC '
'\x06CORNER'
'\x0eCORNER BRACKET'
'\x10CORNER DOWNWARDS'
'\x10CORNER LEFTWARDS'
'\x0fCORNER WITH DOT'
'\x08COUNCIL '
'\x08COUNT OF'
'\x08COUNTERS'
'\x02CR'
'\x03CR '
'\x06CREASE'
'\x0bCREDIT SIGN'
'\x05CREEN'
'\tCRESCENDO'
'\x04CRET'
'\x0eCRIFICIAL WINE'
'\x06CRIPT '
'\rCRIPTION TAKE'
'\rCRIPTIONAL PA'
'\x08CRO SIGN'
'\x04CRON'
'\nCROPHONIC '
'\x05CROSS'
'\x11CROSS PUNCTUATION'
'\tCROSSING '
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x19CROSSING NORTH EAST ARROW'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x0cCSIMILE SIGN'
'\x02CT'
'\x11CTION APPLICATION'
'\nCTION MARK'
'\x15CTOR OR CROSS PRODUCT'
'\nCTORY HAND'
'\x05CTRIC'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\x18CULINE ORDINAL INDICATOR'
'\x04CURL'
'\rCURLY BRACKET'
'\x16CURLY BRACKET ORNAMENT'
'\tCURRENCY '
'\x14CURRENCY SYMBOL RIEL'
'\x07CURVED '
'\x14CURVED ANGLE BRACKET'
'\x04CUTE'
'\x0bCUTE ACCENT'
'\x02CW'
'\x03CWA'
'\x04CWAA'
'\x03CWI'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\rD COMMA ABOVE'
'\x04D HA'
'\x07D MOUTH'
'\x05D OF '
'\nD OF PROOF'
'\x08D RIGHT '
'\tD SALTIRE'
'\x08D SYMBOL'
'\x07D WITH '
'\nD WITH DOT'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\x03DAA'
'\tDAD WITH '
'\x06DAGESH'
'\x0fDAGESH OR MAPIQ'
'\x04DAGS'
'\x04DAIR'
'\x04DAL '
'\x05DALAT'
'\x05DALET'
'\x06DALETH'
'\x05DAMMA'
'\x05DANDA'
'\x07DANESE '
'\x08DANTAJA '
'\x03DAP'
'\x03DAR'
'\x04DASH'
'\nDASH ARROW'
'\x05DASIA'
'\x0eDASIA PNEUMATA'
'\x05DATUS'
'\x07DAYANNA'
'\x02DD'
'\nDDAH ABOVE'
'\x02DE'
'\x0cDE MARK SIGN'
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\x03DEE'
'\x03DEG'
'\x03DEK'
'\x04DEL '
'\tDELIMITER'
'\x15DELIMITER TSHEG BSTAR'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x05DELTA'
'\x05DENCE'
'\x13DENOMINATOR SIXTEEN'
'\x0cDENTAL CLICK'
'\x11DENTAL PERCUSSIVE'
'\tDEOGRAPH '
'\x06DERBAR'
'\x06DERMA '
'\x03DES'
'\tDESCENDER'
'\x0fDESCENDING TONE'
'\x05DESTY'
'\x10DEWAYS U BRACKET'
'\x05DEXIA'
'\x0eDEYTEROS ICHOS'
'\x1bDGE-TAILED RIGHTWARDS ARROW'
'\x04DGER'
'\x03DHA'
'\x05DHADH'
'\x07DHALATH'
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\tDIAERESIS'
'\x19DIAERESIS AND HOOK SYMBOL'
'\rDIAERESIZED U'
'\tDIAGONAL '
'\x18DIAGONAL CROSSHATCH FILL'
'\x13DIAGONAL HALF BLACK'
'\x0fDIAGONAL STROKE'
'\x05DIAL '
'\x0fDIALYTIKA TONOS'
'\x07DIAMOND'
'\x05DIAN '
'\x07DIARGON'
'\nDIATONIKI '
'\x0bDIATONON DI'
'\x03DIB'
'\x04DIC '
'\x06DICINE'
'\x06DIESIS'
'\x08DIFONIAS'
'\x05DIGA '
'\x0fDIGA AELA-PILLA'
'\x07DIGAMMA'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x15DIGRAMMOS EX DODEKATA'
'\x07DIGRAPH'
'\x0cDIGRAPH KOTO'
'\x0cDIGRAPH YORI'
'\x03DIM'
'\x04DIM2'
'\x03DIN'
'\x05DIPLI'
'\x07DIPLOUN'
'!DIRECT PRODUCT WITH BOTTOM CLOSED'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISH'
'\x07DISIMOU'
'\x10DITORIAL CORONIS'
'\x05DIUM '
'\x06DIVIDE'
'>DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR'
'\x03DJA'
'\x05DKAR '
'\x04DLE '
'\x07DLE DOT'
'\x03DMA'
'\x02DO'
'\x03DO '
'\x0bDOACHASHMEE'
'\x0eDOES NOT EXIST'
'\x07DOFONON'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x16DOMAIN ANTIRESTRICTION'
'\x03DON'
'\x0bDONG TSHUGS'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\tDOT BELOW'
'\x17DOT BELOW AND DOT ABOVE'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x0cDOT OPERATOR'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x14DOTLESS HEAD OF KHAH'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x05DOTS-'
'\x06DOTTED'
'\x07DOTTED '
'\x1bDOTTED INTERPOLATION MARKER'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x1aDOTTED SUBSTITUTION MARKER'
'\rDOTTED ZLAMA '
'\x07DOUBLE '
'\x0bDOUBLE AND '
'\x14DOUBLE ANGLE BRACKET'
'\x1bDOUBLE ANGLE QUOTATION MARK'
'\x11DOUBLE ARCH BELOW'
'\x0cDOUBLE ARROW'
'\x19DOUBLE CANDRABINDU VIRAMA'
'\rDOUBLE CIRCLE'
'\x10DOUBLE DOT ABOVE'
'\x14DOUBLE DOT TONE MARK'
'\x10DOUBLE HEAD MARK'
'\rDOUBLE HYPHEN'
'\x15DOUBLE LEFT TURNSTILE'
'\rDOUBLE MUCAAD'
'\x1bDOUBLE PRIME QUOTATION MARK'
'\x12DOUBLE PUNCTUATION'
'\x0bDOUBLE SHAD'
'\x16DOUBLE SOLIDUS OVERLAY'
'\rDOUBLE STROKE'
'\x10DOUBLE TURNSTILE'
'\x16DOUBLE VERTICAL STROKE'
'$DOUBLE-LINE EQUAL ABOVE GREATER-THAN'
'!DOUBLE-LINE EQUAL ABOVE LESS-THAN'
'\x0eDOUBLE-STRUCK '
'\x0cDOWED WHITE '
'\x04DOWN'
'\x05DOWN '
'\tDOWN AND '
'\x13DOWN AND HORIZONTAL'
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x0cDOWN HARPOON'
'\nDOWN HEAVY'
'\x1cDOWN HEAVY AND LEFT UP LIGHT'
'\x1dDOWN HEAVY AND RIGHT UP LIGHT'
'\x15DOWN HORIZONTAL HEAVY'
'\x15DOWN HORIZONTAL LIGHT'
'\nDOWN LIGHT'
'\x10DOWN RIGHT BARB '
'\tDOWN TACK'
'\x12DOWN-OUTPUT SYMBOL'
'\tDOWNWARDS'
'\x1eDOWNWARDS AND RIGHTWARDS ARROW'
'\x0fDOWNWARDS ARROW'
'!DOWNWARDS HARPOON WITH BARB RIGHT'
'\x17DOWNWARDS THEN CURVING '
'\x16DOWNWARDS ZIGZAG ARROW'
'\x02DR'
'\x07DRACHMA'
'\x06DRAGON'
'\x16DRESSED TO THE SUBJECT'
'\x07DRIL BU'
'\x1aDROP-SHADOWED WHITE SQUARE'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x08DS-CREE '
'\x17DSTONE GRAVEYARD SYMBOL'
'\x02DU'
'\x03DUG'
'\x03DUN'
'\tDUN3 GUNU'
'\x03DUR'
'\tDUS RTAGS'
'\x06DVANCE'
'\x08DVISVARA'
'\x02DY'
'\x0bDYO CHRONON'
'\x03DZE'
'\x01E'
'\x02E '
'\x07E FACE-'
'\x05E GEE'
'\x1aE ONE-WAY LEFT WAY TRAFFIC'
'\x0fE OVER INFINITY'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\nE PLUS SUM'
'\tE TSA CAN'
'\x06E WAVE'
'\x02E0'
'\x02E2'
'\x02EA'
'\x04EACE'
'\x03EAF'
'\x05EAGLE'
'\x0cEAGULL BELOW'
'\x06EAHMUK'
'\x03EAN'
'\x11EAR SCREEN SYMBOL'
'\x08EAR SIGN'
'\tEARDROP-S'
'\nEARLY FORM'
'\x05EARTH'
'\nEARTH MARK'
'\x05EAST '
'\x06EASURE'
'\x03EAT'
'\x04EAT '
'\x0fEATER-THAN SIGN'
'\x04EATH'
'\x0cEATH PRODUCT'
'\x06EATHER'
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\tEAVY DOWN'
'\x1bEAVY WHITE RIGHTWARDS ARROW'
'\x07EAVY YA'
'\x08EBEEFILI'
'\nEBENSTIMME'
'\tEBIT SIGN'
'\x05ECEDE'
'\x06ECEDES'
'\x07ECEMBER'
'\x03ECH'
'\x08ECH YIWN'
'\x10ECIMAL SEPARATOR'
'\x08ECTANGLE'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'-ED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE'
'\x0bED EQUAL TO'
'\nED FIGURE-'
'\x0fED PAPER SYMBOL'
'\x0eED PARAGRAPHOS'
'\tEDESTRIAN'
'\x1cEDGE-TAILED RIGHTWARDS ARROW'
'\x06EDIAL '
'\nEDIAL FORM'
'\x06EDILLA'
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x04EEK '
'\x03EEL'
'\x05EEM I'
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x06EENTH '
'\x04EENU'
'\x0cEEPING SMALL'
'\x04EESU'
'\x04EETA'
'\x02EF'
'\x03EF '
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x1cEFT ARC GREATER-THAN BRACKET'
'\x0eEFT HALF BLACK'
'\x08EFT HOOK'
'\x15EFT OPEN BOX OPERATOR'
'\x0fEFT PARENTHESIS'
'\x0fEFT REPEAT SIGN'
'\x13EFT-POINTING ANGLE '
'!EFT-POINTING ANGLE QUOTATION MARK'
'\x0fEFTWARDS ARROWS'
'\x1fEFTWARDS HARPOON WITH BARB DOWN'
'\x1dEFTWARDS HARPOON WITH BARB UP'
'\rEFTWARDS TICK'
'\x03EGA'
'\x05EGALI'
'\x06EGEAN '
'\x05EGIN '
'\x05EGION'
'\x05EGL H'
'\x04EGOL'
'\x08EGORIAN '
'\x02EH'
'\x03EH '
'\x0fEH INITIAL FORM'
'\x08EH WITH '
'&EH WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x04EHEH'
'\x03EHI'
'\x02EI'
'\x03EI '
'\nEICH STARK'
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x06EIGHTH'
'\x0cEIGHTH BLOCK'
'\x0cEIGHTH NOTES'
'\x07EIGHTHS'
'\rEIGHTHS BLOCK'
'\x06EIGHTY'
'\x06EILING'
'\x04EIRT'
'\x03EIS'
'\x05EISMA'
'\x04EIWS'
'\x02EK'
'\x03EK '
'\x08EK ONKAR'
'\x04EKAA'
'\x0bEKFONITIKON'
'\x02EL'
'\x07EL PUMP'
'\x15ELATIONAL COMPOSITION'
'\x03ELD'
'\x08ELEPHONE'
'\x03ELF'
'\x03ELL'
'\x07ELLIPSE'
'\x08ELLIPSIS'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELS'
'\x03ELT'
'\nELT BUCKLE'
'\x04ELTA'
'\x04ELVE'
'\x17ELVE POINTED BLACK STAR'
'\x02EM'
'\x05EMALE'
'\x06EMASTI'
'\tEMBEDDING'
'\x1bEMICIRCULAR CLOCKWISE ARROW'
'\x08EMICOLON'
'\x11EMICOLON UNDERBAR'
'\x11EMIDIRECT PRODUCT'
'\x0cEMISOFT SIGN'
'\x03EMK'
'\x06EMKATH'
'\x05EMLJA'
'\x06EMOLO-'
'\rEMPHATIC TONE'
'\tEMPTY SET'
'\x06EMPUS '
'\x02EN'
'\x06EN BOX'
'\x0cEN FULL STOP'
'\x06EN GHE'
'\x10EN MILLIONS SIGN'
'\x07EN SIGN'
'\x05ENANO'
'\x0cENARIUS SIGN'
'\x14ENARMONIOS ANTIFONIA'
'\x04ENAT'
'\x0fENCH FRANC SIGN'
'\x03END'
'\x0eEND OF SECTION'
'\x0eENDED MULTIMAP'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x0bENG DIGRAPH'
'\x06ENIKI '
'\x0cENOS CHRONOU'
'\x03ENT'
'\x08ENT SIGN'
'\x07ENTAGON'
'\x1bENTATION FORM FOR VERTICAL '
'\x12ENTERING TONE MARK'
'\x04ENTH'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTIMA'
'\x06ENTION'
'\x05ENTRE'
'\x10ENTRE WHITE STAR'
'\x07ENTRED '
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x05ENUTO'
'\x02EO'
'\x05EO-EU'
'\nEONGCHIEUM'
'\x0bEORGIAN NAR'
'\x03EOW'
'\x02EP'
'\x05EPEAT'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x07EPHONE '
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x0eEPSILON SYMBOL'
'\x10EPSILON UNDERBAR'
'\x03EQU'
'\x05EQUAL'
'\x06EQUAL '
'\x08EQUAL TO'
'\x0cEQUAL TO OR '
'\x18EQUAL TO OR GREATER-THAN'
'\x15EQUAL TO OR LESS-THAN'
'\x06EQUALS'
'\x0bEQUALS SIGN'
'\x02ER'
'\x03ER '
'\x15ER RIGHT CORNER ANGLE'
'\x07ER THAN'
'\x08ER TRUTH'
'\x08ERAL URN'
'\x0bERCENT SIGN'
'\x07ERCIAL '
'\tERCIAL AT'
'\x06ERESIS'
'\x04ERET'
'\x05ERET '
'\x0eERIC INDICATOR'
'\x05ERIN2'
'\nERISPOMENI'
'\x05ERKHA'
'\x06ERMATA'
'\x05ERN W'
'\x08ERO SIGN'
'\nERO WIDTH '
'\x0cERPENDICULAR'
'\x05ERSON'
'\x0cERTICAL LINE'
'\x05ERTIE'
'\rERTION SYMBOL'
'\tERTY LINE'
'\x03ERU'
'\x07ES NOT '
'\tESAME DOT'
'\x03ESC'
'\x08ESCENDER'
'\x07ESCENDO'
'\x03ESH'
'\x0bESH DIGRAPH'
'\x08ESH LOOP'
'\x04ESH2'
'\x05ESHE3'
'\x06ESHTIN'
'\x03ESI'
'\x0fESIDE LESS-THAN'
'\x05ESIS '
'\x0bESMILO SIGN'
'\x05ESO E'
'\x03ESS'
'\x17ESS OUTLINED WHITE STAR'
'\x08ESS-THAN'
'\x0fESSARON CHRONON'
'\x04EST '
'\x08EST WIND'
'\x11ESTERN PWO KAREN '
'\x06ESTION'
'\x0bESTION MARK'
'\x07ESTIVAL'
'\x02ET'
'\x03ET '
'\x13ET WITH WHITE CROSS'
'\x03ETA'
'\x08ETA SIGN'
'\nETA SYMBOL'
'\x04ETAL'
' ETALLED BLACK AND WHITE FLORETTE'
'\x1fETALLED OUTLINED BLACK FLORETTE'
'\x0cETARTIMORION'
'\x08ETARTOS '
'\x0bETEI MAYEK '
'\tETER SIGN'
'\x03ETH'
'\x05ETION'
'\x07ETNAHTA'
'\x05ETORU'
'\x08ETRASEME'
'\tETRASIMOU'
'\x0cETRETES SIGN'
'\rETROFLEX HOOK'
'\nETTA-PILLA'
'\x06ETTER '
'\x05ETTI '
'\x02EU'
'\x04EUCH'
'\x07EULEUNG'
'\x04EUNG'
'\nEUR-DE-LIS'
'\nEUTRAL YER'
'\x03EUX'
'\x03EVA'
'\nEVANAGARI '
'\x03EVE'
'\x04EVEN'
'\x05EVEN '
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\x05EVENT'
'\x08EVENTEEN'
'\x12EVENTEEN FULL STOP'
'\x06EVENTH'
'\x06EVENTY'
'\x08EVERANCE'
'\x0eEVERSE SOLIDUS'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x1dEVERSED LUNATE EPSILON SYMBOL'
'\nEVERSED PE'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x04EVMA'
'\x02EW'
'\rEWDATA SQUARE'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x06EXISTS'
'\x0fEXPONENT SYMBOL'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\tEXTENSION'
'\x02EY'
'\x06EYANNA'
'\x05EYYAL'
'\x03EZH'
'\x03EZI'
'\x04EZZO'
'\x01F'
'\x06F CLEF'
'\x05F COW'
'\x07F DAVID'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x08F SYMBOL'
'\x0cF TREE TRUNK'
'\x07F WITH '
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x05FAAFU'
'\x12FACING SVASTI SIGN'
'\nFAHRENHEIT'
'\x05FAIHU'
'\x10FALLING DIAGONAL'
'\x0cFALLING DOTS'
'\x06FAMILY'
'\x05FATHA'
'\x06FATHA '
'\x07FAYANNA'
'\x02FE'
'\x05FEARN'
'\x0cFEATHER MARK'
'\nFEATHERED '
'\x08FEBRUARY'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x03FEH'
'\tFEH WITH '
'\x0eFEHU FEOH FE F'
'\x0bFEMALE SIGN'
'\x0cFEMININE DOT'
'\x05FENCE'
'\x0cFERENCE MARK'
'\x06FF OF '
'\x10FFERENCE BETWEEN'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIFTH'
'\x06FIFTHS'
'\x05FIFTY'
'\x06FILLER'
'\x03FIN'
'\x07FINAGH '
'\x06FINAL '
'\nFINAL FORM'
'\rFINAL LETTER '
'\tFINAL MEM'
'\tFINAL NGA'
'\rFINAL SEMKATH'
'\x0bFINAL SIGMA'
'\x08FINAL TH'
'\x07FINAL Y'
'\x04FIRE'
'\tFISH TAIL'
'\x08FISHHOOK'
'\x05FISTO'
'\x04FITA'
'\x04FIVE'
'\x12FIVE EIGHTHS BLOCK'
'\x0cFIVE HUNDRED'
'\x0bFIXED-FORM '
'\rFIXED-FORM RA'
'\x02FL'
'\x05FLAKE'
'\x04FLAT'
'\tFLAT SIGN'
'\nFLATTENED '
'\x16FLATTENED OPEN A ABOVE'
'\x15FLATTENED PARENTHESIS'
'\x05FLICT'
'\x13FLORAL HEART BULLET'
'\x08FLOURISH'
'\x07FLUENCE'
'\x05FLUTE'
'\x02FO'
'\x03FO '
'\x06FONIAS'
'\x05FORCE'
'\x04FORE'
'\rFOREMENTIONED'
'\x04FORK'
'\x12FORKED PARAGRAPHOS'
'\x07FORKING'
'\x14FORMS LIGHT VERTICAL'
'\x04FOUR'
'\x1cFOUR BALLOON-SPOKED ASTERISK'
'\nFOUR BELOW'
'\tFOUR DOTS'
'\x0fFOUR DOTS ABOVE'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x08FRAKTUR '
'\x08FRICAN D'
'\x08FROM BAR'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\x0cFT RERENGGAN'
'\x05FTEEN'
'\x0fFTER COMPLETION'
'\x1cFTING POINT RIGHTWARDS ARROW'
'\nFTOGGOS OU'
'\rFTWARDS ARROW'
'\x03FTY'
'\tFULL STOP'
'\rFULL SURROUND'
'\x03FWA'
'\x04FWAA'
'\x01G'
'\x02G '
'\tG IN HOLE'
'\x05G YUS'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x05GADOL'
'\x03GAG'
'\x04GAIN'
'\x03GAL'
'\x05GALGA'
'\x05GALI '
'\x05GAMAL'
'\x05GAMAN'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\x13GAPPED CIRCLE ARROW'
'\x03GAR'
'\x08GARITIC '
'\nGAS BZUNG '
'\x03GAT'
'\x12GATIVE ACKNOWLEDGE'
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x03GAY'
'\x07GAYANNA'
'\x0bGAYANUKITTA'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x08GBASINNA'
'\x02GE'
'\x07GE SIGN'
'\x06GEADAL'
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x06GEDOLA'
'\x11GENERIC MATERIALS'
'\x08GENITIVE'
'\x0bGENTLE WIND'
'\x03GER'
'\x0eGERED TREMOLO-'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x04GGER'
'\nGGRAVATION'
'\x04GGWS'
'\x0fGH VOLTAGE SIGN'
'\x03GHA'
'\x0bGHAIN WITH '
'\x06GHAMAL'
'\x03GHE'
'\x04GHOM'
'\x03GHT'
'\rGHT ARROWHEAD'
'\rGHT HALF RING'
'\x0cGHT OPEN BOX'
'\x15GHT OPEN BOX OPERATOR'
'\x0fGHT REPEAT SIGN'
'\x18GHT TRIFOLIATE SNOWFLAKE'
'\x14GHTWARDS ARROW BELOW'
'\x05GHULU'
'\x06GHUNNA'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x04GIBA'
'\x06GICAL '
'\x04GIDA'
'\x05GIMEL'
'\x08GINAL OF'
'\x07GINESE '
'\x03GIR'
'\x04GISH'
'\rGISTERED SIGN'
'\x04GIT '
'\tGITTARIUS'
'\x07GLAGOLI'
'\x06GLAZ H'
'\x04GLE '
'\x0bGLE BRACKET'
'\x0cGLOTTAL STOP'
'\x18GLOTTAL STOP WITH STROKE'
'\x05GMENT'
'\x02GN'
'\x03GNO'
'\x02GO'
'\x06GO NGU'
'\x04GOAL'
'\x05GOGI '
'\x07GOLIAN '
'\x0cGONAL STROKE'
'\x05GONEK'
'\x04GONG'
'\x04GORG'
'\x05GORGI'
'\x06GORGON'
'\x04GORT'
'\x03GOU'
'\x02GR'
'\x14GRA GCAN -CHAR RTAGS'
'\x04GRAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x15GRAMMOS OKTO DODEKATA'
'\x05GRAPH'
'\x08GRAPH UK'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'$GREATER-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1eGREATER-THAN ABOVE EQUALS SIGN'
'\x16GREATER-THAN DIAERESIS'
'\x11GREATER-THAN NOR '
'\x18GREATER-THAN OR EQUAL TO'
'\x11GREATER-THAN SIGN'
'\x05GREE '
'\nGREE SLASH'
'\x0bGREEK CROSS'
'\x17GREEK SMALL LETTER IOTA'
'\x0cGREEN DRAGON'
'\tGRIK SIGN'
'\x0fGROUP SEPARATOR'
'\x04GRU '
'\x15GRUENT WITH DOT ABOVE'
'\x02GS'
'\x06GS-PA '
'\x0bGSUM -KHYIL'
'\rGTER TSHEG MA'
'\x03GUD'
'\x04GUNU'
'\x06GURAMU'
'\x05GURE '
'\x0cGXI RADICAL '
'\rGYA GRAM SHAD'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x02H '
'\x06H NOTE'
'\rH-TYPE SYMBOL'
'\x03H00'
'\x02HA'
'\x03HAA'
'\x05HAALU'
'\nHAAPRAANA '
'\x07HAARKAA'
'\x03HAD'
'\x05HADDA'
'\x04HADE'
'\x1cHADED WHITE RIGHTWARDS ARROW'
'\x14HADOWED WHITE SQUARE'
'\x08HAGALL H'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x04HAH '
'\x05HAH I'
'\x10HAH INITIAL FORM'
'\x11HAH ISOLATED FORM'
'\tHAH WITH '
'\x04HAIN'
'\x05HAINU'
'\x04HAIR'
'\rHAKASSIAN CHE'
'\x03HAL'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x07HALF BL'
'\nHALF BLACK'
'\x0cHALF BRACKET'
'\x0fHALF FILL SPACE'
'\rHALF INTEGRAL'
'\tHALF RING'
'\tHALSHELET'
'\x03HAM'
'\x04HAM '
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMZA '
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x08HAN-AKAT'
'\x15HAND INTERIOR PRODUCT'
'\x05HANGE'
'\x07HANGUL '
'\x17HANKED RIGHTWARDS ARROW'
'\x05HANNA'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTER '
'\tHARACTERS'
'\x08HARMONIC'
'\x06HARP S'
'\x08HARPOON '
'\x12HARPOON WITH BARB '
'\x1bHARPOON WITH BARB DOWNWARDS'
'\x07HASANTA'
'\x0cHASIS SYMBOL'
'\x05HATHI'
'\x04HAVE'
'\x08HAVIYANI'
'\x07HAYANNA'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x06HE MGO'
'\x04HEAD'
'\x05HEAD '
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x1fHEART EXCLAMATION MARK ORNAMENT'
'\x04HEAT'
'\x06HEAVEN'
'\x0bHEAVEN MARK'
'\x05HEAVY'
'\x06HEAVY '
'\nHEAVY AND '
'\x0fHEAVY AND LEFT '
'\x10HEAVY AND RIGHT '
'\nHEAVY BEAT'
'\x18HEAVY BLACK HEART BULLET'
'\x03HEE'
'\x04HEEN'
'\x04HEEP'
'\x08HEG SHAD'
'\x03HEH'
'\x0fHEH MEDIAL FORM'
'\x06HEISEI'
'\x04HELL'
'\x03HEN'
'\x03HER'
'\rHERICAL ANGLE'
'\x06HERMES'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x05HESS '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x16HEXIFORM LONG ANUSVARA'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\x07HI SIGN'
'\tHI SYMBOL'
'\x0cHI TIMES BAD'
'\x06HIBIT '
'\x03HID'
'\x04HID '
'\x05HIDET'
'\x06HIEUCH'
'\x05HIEUH'
'\x06HIEUKH'
'\x06HIEUPH'
'\x06HIEUTH'
'\x05HIFT '
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\tHIGH STOP'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x1eHIGH-REVERSED-9 QUOTATION MARK'
'\x04HIIN'
'\x04HILD'
'\tHIMA SIMA'
'\x03HIN'
'\x07HIN DOT'
'\rHINESE TONE Y'
'\x03HIP'
'\x04HIRD'
'\x05HIRIQ'
'\x04HIRT'
'\x07HIRTEEN'
'\x11HIRTEEN FULL STOP'
'\x05HIRTY'
'\x05HISTI'
'\x03HIT'
'\x05HITE '
'\nHITE ARROW'
'\x1bHITE DOWN-POINTING TRIANGLE'
'\x0bHITE DRAGON'
'\x05HIUTH'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x0bHJONG TILE '
'\x06HLAVI '
'\x02HM'
'\x07HM SIGN'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x03HO '
'\x06HO HOI'
'\nHOGI PIECE'
'\x04HOKE'
'\x05HOLAM'
'\x05HOLAR'
'\x10HOLDING TOGETHER'
'\x05HOLE '
'\x04HOOK'
'\nHOOK ABOVE'
'\x0bHOOK SYMBOL'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x14HORIZONTAL BAR WITH '
'\x0fHORIZONTAL DASH'
'\x11HORIZONTAL DOUBLE'
'\x13HORIZONTAL ELLIPSIS'
'\x0fHORIZONTAL FILL'
'\x10HORIZONTAL HEAVY'
'\x10HORIZONTAL LIGHT'
'\x11HORIZONTAL SINGLE'
'\x11HORIZONTAL STROKE'
'\x15HORIZONTAL TABULATION'
'\x12HORIZONTALLY BELOW'
'\x04HORN'
'\x05HORSE'
'\x05HORT '
'\x06HORT A'
'\x16HORT HORIZONTAL STROKE'
'\nHORT-TWIG-'
'\x04HOST'
'\tHOT SASAK'
'\nHOTIC HOOK'
'\x03HOU'
'\x05HOUR '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x12HOUSANDS SEPARATOR'
'\x05HREAD'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\x0bHREE BALUDA'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x19HREE DOTS ABOVE DOWNWARDS'
'\x0fHREE DOTS BELOW'
'\tHREE FOR '
'\x08HREE OF '
'\x07HROUGH '
'\x03HSA'
'\x04HSDA'
'\x04HSHU'
'\x1aHTORA SKLIRON CHROMA VASIS'
'\x02HU'
'\x04HUEN'
'\x03HUK'
'\x07HUNDRED'
'\x08HUNDRED '
'\x03HUR'
'\x06HUR PA'
'\x13HURISAZ THURS THORN'
'\x02HV'
'\x02HW'
'\x03HWA'
'\x04HWAA'
'\tHWAZ EH E'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x0cHYPHEN-MINUS'
'\x02HZ'
'\x01I'
'\x02I '
'\nI ARCHAION'
'\x05I KOI'
'\rI LENGTH MARK'
'\x06I MAIM'
'\tI PLUS LI'
'\x07I RTAGS'
'\x08I SHAKTI'
'\x08I SYMBOL'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x16I YFESIS TETARTIMORION'
'\x03I-I'
'\x02I0'
'\x02IA'
'\x08IAERESIS'
'\x08IAGONAL '
'\x0eIAGONAL STROKE'
'\x03IAL'
'\tIALECT-P '
'\x08IALYTIKA'
'\tIALYTIKA '
'\x06IAMOND'
'\x0fIAMOND UNDERBAR'
'\x0bIAN LETTER '
'\x05IANCE'
'\x06IANGLE'
'\x1aIANGLE BESIDE VERTICAL BAR'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IANO'
'\x04IARA'
'\x06IASMA '
'\x05IAUDA'
'\x04IBE '
'\x07IBIFILI'
'\x0bIBLE-CREE Y'
'\x02IC'
'\nICAL TAPER'
'\x03ICE'
'\x05ICHON'
'\x05ICHOS'
'\x05ICRON'
'\x13ICTLY EQUIVALENT TO'
'\x02ID'
'\nIDDLE MARK'
'\x0bIDDLE TILDE'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\x1bIDE ARC ANTICLOCKWISE ARROW'
'\x17IDE ARC CLOCKWISE ARROW'
'\x1bIDE-HEADED RIGHTWARDS ARROW'
'\x0cIDENTICAL TO'
'\tIDEOGRAM '
'\nIDEOGRAPH '
'\x0cIDEOGRAPHIC '
'\x11IDEOGRAPHIC COMMA'
'\x1aIDEOGRAPHIC ITERATION MARK'
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x05IDGE '
'\nIDGE BELOW'
'\x0fIDING ENCLOSURE'
'\x02IE'
'\x03IER'
'\x03IES'
'\x04IEUC'
'\x05IEUNG'
'\x04IEUP'
'\x04IFAT'
'\x03IFF'
'\x06IFIED '
'\rIFIER LETTER '
'\x03IFT'
'\x06IFTEEN'
'\x10IFTEEN FULL STOP'
'\x04IFTY'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\x06IGAMMA'
'\x08IGATURE '
'\x16IGEL LONG-BRANCH-SOL S'
'\x04IGER'
'\x0bIGGLY FENCE'
'\x03IGH'
'\x04IGH '
'\tIGH HAMZA'
'\x04IGHT'
'\x05IGHT '
'\tIGHT DOWN'
'\x08IGHT OF '
'\x07IGHTEEN'
'\x11IGHTEEN FULL STOP'
'\x06IGHTH '
'\tIGHTH ASH'
'\x0eIGHTWARDS TICK'
'\x0eIGHTWARDS VANE'
'"IGHUR KAZAKH KIRGHIZ ALEF MAKSURA '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x04IGMA'
'\x03IGN'
'\x04IGN '
'\x02IH'
'\x03IHI'
'\x05IHVUS'
'\x02II'
'\x03II '
'\x04IITO'
'\x02IJ'
'\x04IK H'
'\x05IKARA'
'\x05IKEUT'
'\x07IKHAHIT'
'\x04IKRI'
'\nIKRON ISON'
'\x03IKU'
'\x05IKURU'
'\x02IL'
'\x0bIL FRAGMENT'
'\x06ILBOAT'
'\x0bILCROW SIGN'
'\x04ILDE'
'\x03ILE'
'\rILE SEPARATOR'
'\tILE TILDE'
'\nILING FACE'
'\tILIPPINE '
'\x0bILIQUA SIGN'
'\x03ILK'
'\x06ILLAGE'
'\x07ILLEANN'
'\x05ILLU '
'\x04ILUY'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\rIMAGE BRACKET'
'\x14IMAGE OF OR EQUAL TO'
'\x08IMANSIS '
'\x03IME'
'\x04IMEL'
'\x0bIMEL SYMBOL'
'\x10IMENSIONAL ANGLE'
'\x04IMES'
'\x05IMES '
'\x13IMIDIA SEXTULA SIGN'
'\x07IMILAR '
'\x0fIMISEOS CHRONOU'
'\x05IMMA '
'\nIMPERFECTA'
'\x0fIMPERFECTA REST'
'\x1bIMPERFECTUM CUM PROLATIONE '
'\x02IN'
'\x03IN '
'\x13IN CHEN SPUNGS SHAD'
'\x16IN DEPARTING TONE MARK'
'\x06IN DOT'
'\x0bIN EQUAL TO'
'\x08IN SPACE'
'\tIN SQUARE'
'\x0bIN TRIANGLE'
'\x1fIN WHITE CIRCLE IN BLACK SQUARE'
'\x08IN WITH '
'\x03IN2'
'\x06INAGMA'
'\nINAL SIGMA'
'\x04INAP'
'\x06INCUNX'
'\x03IND'
'\x13INDEPENDENT SVARITA'
'\x12INDEPENDENT VOWEL '
'\x0bINDERGARTEN'
'\x06INDHI '
'\x06INDIC '
'\x0bINDICESIMA '
'\x16INDIRECT QUESTION MARK'
'\x1aINDUSTRIAL STANDARD SYMBOL'
'\x03INE'
'\tINE BELOW'
'\x07INE OF '
'\x11INEAR ANNOTATION '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\tING ABOVE'
'\tING LANES'
'\nING LARGE '
'\x0cING OPERATOR'
'\x08ING ROD '
'\x0fING SYMBOL FOR '
'\x06INGAAT'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x04INGU'
'\nINHERENT A'
'\x03INI'
'\x05INIMA'
'\x17ININE ORDINAL INDICATOR'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x0cINITIAL FORM'
'\x05INITY'
'\x06INKING'
'\x04INOR'
'\x03INS'
'\x06INSHIP'
'\x06INSIDE'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR G'
'\x04INTE'
'\x08INTEGRAL'
'\x11INTEGRAL OPERATOR'
'\x0bINTEGRATION'
'\x0cINTEGRATION '
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x15INTERSECTING LOGICAL '
'\x0cINTERSECTION'
'\x15INTERSECTION OPERATOR'
'\x18INTERSECTION WITH SERIFS'
'\x05INTHU'
'\x04INTO'
'\x0bINTO SHRINE'
'\x03INU'
'\x17INUOUS UNDERLINE SYMBOL'
'\x04INUS'
'\x0fINUS SIGN BELOW'
'\x14INVERSE WHITE CIRCLE'
'\x08INVERTED'
'\tINVERTED '
'\x0eINVERTED BREVE'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\rINVERTED FORK'
'\x15INVERTED GLOTTAL STOP'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\rINVERTED TURN'
'\nINVERTED V'
'\x03ION'
'\x08ION SIGN'
'\x0bIOR PRODUCT'
'\x03IOS'
'\x04IOTA'
'\x02IP'
'\x03IP '
'\x07IP SIGN'
'\x05IPEHA'
'\x05IPING'
'\x0bIPLE TONGUE'
'\x04IPOD'
'\x04IPT '
'\x04IQAA'
'\x02IR'
'\x08IR SPACE'
'\x08IRA SIGN'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x03IRC'
'\x05IRCLE'
'\x06IRCLE '
'\x10IRCLE X NOTEHEAD'
'\x07IRCLED '
'\x06IRCLES'
'\tIRCUMFLEX'
'\x10IRCUMFLEX ACCENT'
'\x0fIRCUMFLEX BELOW'
'\x08IRD MARK'
'\x03IRE'
'\x04IRED'
'\x04IRGA'
'\x07IRGHIZ '
'\x03IRI'
'\x06IRINGU'
'\x04IRIQ'
'\x04IRIT'
'\x03IRO'
'\x07IRPLANE'
'\tIRST MARK'
'\x0cIRST SUBUNIT'
'\x03IRT'
'\x06IRTEEN'
'\x04IRTY'
'\x0cIRTY-SECOND '
'\x03IRU'
'\x02IS'
'\x08IS-PILLA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\x08ISH TAIL'
'\x04ISI '
'\x07ISIBLE '
'\x0bISIGOTHIC Z'
'\x1cISMILLAH AR-RAHMAN AR-RAHEEM'
'\rISOLATED FORM'
'\x06ISSHAR'
'\x06ISSIMO'
'\x05ISTLE'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\x03ITA'
'\x0eITA PLUS GISH '
'\x06ITABLE'
'\x07ITALIC '
'\x03ITE'
'\x13ITED LIABILITY SIGN'
'\x04ITEM'
'\x0eITERATION MARK'
'\x04ITH '
'\x0fITH FINGERNAILS'
'\x06ITHER '
'\x05ITHI '
'\x06ITIAL '
'\x05ITING'
'\nITING HAND'
'\rITING THROUGH'
'\x0fITION INDICATOR'
'\x04ITLO'
'\x05ITON '
'\x07ITON RA'
'\tITRA SIGN'
'\x04ITSA'
'\tITTLE YUS'
'\x03ITU'
'\x05ITUAL'
'\x03ITY'
'\nIVALENT TO'
'\x05IVATE'
'\x03IVE'
'\x04IVE '
'\x0eIVE KEY SYMBOL'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\x10IVE POINTED STAR'
'\rIVE SLOW SIGN'
'\tIVINATION'
'\x07IVISION'
'\x0eIWAZ TIR TYR T'
'\x03IWN'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x06IX OF '
'\x03IXT'
'\x06IXTEEN'
'\x04IXTH'
'\nIXTHS DISH'
'\x04IXTY'
'\x06IYANNA'
'\x05IYEOK'
'\x01J'
'\x02JA'
'\x05JANG '
'\x07JARATI '
'\x08JAVIYANI'
'\x07JAYANNA'
'\x02JE'
'\x1aJECT REPLACEMENT CHARACTER'
'\x0bJECT SYMBOL'
'\x07JECTIVE'
'\x03JEE'
'\x04JEEM'
'\x05JEEM '
'\x06JEEM I'
'\x11JEEM INITIAL FORM'
'\x12JEEM ISOLATED FORM'
'\x07JEGOGAN'
'\x04JEON'
'\x03JER'
'\x07JERAN J'
'\tJERUSALEM'
'\x04JERV'
'\x05JERVI'
'\rJES SU NGA RO'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JK '
'\x06JOINED'
'\x0eJOINED SQUARES'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\x03JOT'
'\x04JOT '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x14JUDEO-SPANISH VARIKA'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUEUI'
'\x08JUNCTION'
'\x01K'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\x10KA- SHOG YIG MGO'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x04KAD3'
'\x03KAF'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x0cKANA REPEAT '
'\x04KANG'
'\x12KANTAJA NAASIKYAYA'
'\x04KAPA'
'\x04KAPH'
'\x05KAPPA'
'\x0cKAPPA SYMBOL'
'\rKAPYEOUNPIEUP'
'\x04KARA'
'\x06KASKAL'
'\x05KASRA'
'\x08KATAKANA'
'\x12KATAKANA-HIRAGANA '
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x04KATO'
'\x04KAUN'
'\x06KAVYKA'
'\x03KAY'
'\x06KAYAH '
'\x07KAYANNA'
'\x12KBAR ISOLATED FORM'
'\x02KE'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x03KET'
'\x06KEYCAP'
'\nKFONITIKON'
'\x02KH'
'\x05KHAH '
'\x06KHAH I'
'\x11KHAH INITIAL FORM'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x02KI'
'\x04KICK'
'\x03KIN'
'\x04KING'
'\x0fKISIM5 TIMES BI'
'\x06KIYEOK'
'\x06KLITON'
'\x05KNIFE'
'\x06KNIFE '
'\x02KO'
'\x03KO '
'\x05KO LA'
'\x04KOET'
'\x07KOMBUVA'
'\x03KON'
'\x03KOO'
'\x05KOPPA'
'\x07KOQNDON'
'\x12KOREAN CHARACTER O'
'\x07KORONIS'
'\x03KOT'
'\x08KOUFISMA'
'\x06KRISIS'
'\x02KS'
'\tKSTREPTON'
'\x0bKTIESELSKAB'
'\x06KTIKO '
'\x02KU'
'\tKU RU KHA'
'\x03KUN'
'\x03KUR'
'\x04KURO'
'\x05KURON'
'\x06KUSHU2'
'\x05KUSMA'
'\x07KUTAARU'
'\x03KUU'
'\x02KW'
'\x04KWAA'
'\x05KWAEN'
'\x07KYLISMA'
'\x01L'
'\x02L '
'\x14L FUNCTIONAL SYMBOL '
'\x07L SEGNO'
'\x05L TAG'
'\x0bL TIMES LAL'
'\x08L-LAKUNA'
'\rL-TYPE SYMBOL'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'*LA USED AS KORANIC STOP SIGN ISOLATED FORM'
'\x03LA3'
'\x04LAAN'
'\x05LABAT'
'\x07LABIAL '
'\x05LABOR'
'\x0eLACE OF SAJDAH'
'\x04LACK'
'\x05LACK '
'\x0cLACK DIAMOND'
'\x0cLACK HEXAGON'
'\tLACKFOOT '
'\x06LAFRON'
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x07LAGIOS '
'\x05LAGUS'
'\x11LAH ISOLATED FORM'
'\x03LAI'
'\x04LAKE'
'\x03LAL'
'\x03LAM'
'\x04LAM '
'\tLAM WITH '
'\x06LAMADH'
'\tLAMATION '
'\x04LAMD'
'\x05LAMDA'
'\x05LAMED'
'\x06LAMEDH'
'\nLANE MERGE'
'3LANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL'
'0LANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL'
'\x11LAPPING LESS-THAN'
'\tLARGEMENT'
'\x03LAS'
'\x04LASH'
'\x08LASH BAR'
'\x05LASMA'
'\x06LASTON'
'\x04LAT '
'\x0cLATALIZATION'
'\rLATERAL CLICK'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x0bLATIN CROSS'
'\x0fLATION FUNCTION'
'\x07LAYANNA'
'\x05LAYAR'
'\x06LAZY S'
'\x02LC'
'\nLCROW SIGN'
'\x02LD'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x03LDE'
'\x02LE'
'\x03LE '
'\nLE LETTER '
'\nLE-DELAYED'
'\x06LEADER'
'\x05LEASE'
'\x03LEF'
'\x04LEF '
'\x04LEFT'
'\x05LEFT '
'\tLEFT AND '
'\x14LEFT AND LOWER RIGHT'
'\x10LEFT ARROW ABOVE'
'\x18LEFT DIAGONAL HALF BLACK'
'\x0bLEFT DOUBLE'
'\x0fLEFT DOWN BARB '
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x10LEFT HALF CIRCLE'
'\x0eLEFT HALF RING'
'\x0cLEFT HARPOON'
'\nLEFT HEAVY'
'\tLEFT HOOK'
'\nLEFT LIGHT'
'\x10LEFT PARENTHESIS'
'\x19LEFT PARENTHESIS ORNAMENT'
'\rLEFT QUADRANT'
'\x0bLEFT SINGLE'
'\tLEFT TACK'
'\x08LEFT TO '
'\x13LEFT TO LOWER RIGHT'
'$LEFT TORTOISE SHELL BRACKET ORNAMENT'
'\rLEFT TRIANGLE'
'\x16LEFT TRIANGLE OPERATOR'
'\x0eLEFT TURNSTILE'
'\nLEFT-HAND '
'\x12LEFT-STEM TONE BAR'
'\tLEFTWARDS'
'\x0fLEFTWARDS ARROW'
'\x19LEFTWARDS ARROW WITH HOOK'
'\x1cLEFTWARDS OF DOWNWARDS ARROW'
'\x1aLEFTWARDS OF UPWARDS ARROW'
'\x0eLEFTWARDS TICK'
'\rLEGETOS ICHOS'
'\x04LEIA'
'\nLEK ATTAK '
'\x07LEK TOO'
'\x06LEMENT'
'\tLEMENT OF'
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x05LENIS'
'\x12LENTICULAR BRACKET'
'\x12LENTICULAR BRAKCET'
'\x04LEPH'
'\x0cLER CONSTANT'
'\x08LESS SHA'
'\tLESS-THAN'
'!LESS-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1bLESS-THAN ABOVE EQUALS SIGN'
'\x0eLESS-THAN NOR '
'\x15LESS-THAN OR EQUAL TO'
'\x08LESSER Y'
'\nLET SYMBOL'
'\x04LETE'
'\x04LETH'
'\x07LETTER '
'\x0fLETTER CAPITAL '
'\x15LETTER SMALL CAPITAL '
'\x07LEUT KA'
'\x0fLEVEL TONE MARK'
'\x05LEVEN'
'\x0fLEVEN FULL STOP'
'\x02LF'
'\x03LF '
'\x08LF RING '
'\x03LFA'
'\x08LFWIDTH '
'\nLGIZ EOLHX'
'\x02LH'
'\x03LHA'
'\nLHAG RTAGS'
'\x02LI'
'\x08LI GALI '
'\x05LIDUS'
'\x04LIFI'
'\x04LIFU'
'\x05LIGHT'
'\nLIGHT AND '
'\x0fLIGHT AND LEFT '
'\x10LIGHT AND RIGHT '
'\nLIGHT BEAT'
'\x06LIGION'
'\x06LIGON '
'\nLIMITATION'
'\nLINDRICITY'
'\x04LINE'
'\x05LINE '
'\nLINE BELOW'
'\x0eLINE EXTENSION'
'\tLINE FEED'
'\x1aLINE FEED SEPARATOR SYMBOL'
'\x18LINE HORIZONTAL ELLIPSIS'
'\nLINE STAFF'
'\x04LING'
'\x0cLINGING FIRE'
'\x0cLINKING MARK'
'\x14LIQUE ANGLE OPENING '
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x06LISHA '
'\tLISSANDO '
'\x06LITIKI'
'\x0eLITTLE SECTION'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x04LIWN'
'\x03LJE'
'\x02LK'
'\x03LK '
'\x02LL'
'\x07LL SIGN'
'\tLL SYMBOL'
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\tLLABLE OM'
'\x16LLAHOU ALAYHE WASALLAM'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x05LLEL '
'\x04LLET'
'\x07LLIANCE'
'\x0fLLING DIAGONAL '
'\x03LLO'
'\x07LLOWING'
'\x02LM'
'\x0eLMOST EQUAL TO'
'\x0fLMOST EQUAL TO '
'\x02LO'
'\x04LO L'
'\rLOCATION SIGN'
'\x08LOCATIVE'
'\tLOCKWISE '
'\x08LOGICAL '
'\x0bLOGICAL AND'
'\nLOGICAL OR'
'\x04LOLL'
'\x03LON'
'\x0bLON SKEWED '
'\x05LONG '
'\rLONG ANUSVARA'
'\x08LONG BAR'
'\x06LONG E'
'\x16LONG HORIZONTAL STROKE'
'\x08LONG LEG'
'\nLONG OVER '
'\x08LONG S T'
'\x0fLONG VOWEL SIGN'
'\x03LOO'
'\x04LOOP'
'\x04LOOR'
'\x03LOR'
'\x08LORRAINE'
'\x03LOS'
'\x06LOSED '
'\x12LOSED CIRCLE ARROW'
'\x0bLOSED ENTRY'
'\x10LOSED LITTLE YUS'
'\x07LOSING '
'\x0bLOSING MARK'
'\x0bLOTI NAGRI '
'\x07LOTTAL '
'\x0bLOTTAL STOP'
'\x05LOURE'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'\x08LOW LINE'
'\x16LOW PARAPHRASE BRACKET'
'\x08LOW STOP'
'\x08LOW TONE'
'\x06LOWER '
'\x0cLOWER CORNER'
'\x0eLOWER DIAGONAL'
'\tLOWER DOT'
'\nLOWER HALF'
'\nLOWER HOOK'
'+LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x07LOZENGE'
'\x03LPA'
'\nLPAPRAANA '
'\x04LPHA'
'\x02LT'
'\x0bLT OF CLOTH'
'\x03LTA'
'\x0cLTA EQUAL TO'
'\x0bLTERNATE YA'
'\x03LTI'
'\x05LTIRE'
'\x02LU'
'\x0bLU PLUS IGI'
'\x03LUB'
'\x08LUB SUIT'
'\x03LUE'
'\x03LUG'
'\x04LUIS'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x03LUS'
'\x0cLUS NOTEHEAD'
'\x08LUS SIGN'
'\x0eLUS SIGN BELOW'
'\x03LVE'
'\rLVE FULL STOP'
'\rLVEOLAR CLICK'
'\tLVIN SIGN'
'\x02LY'
'\x03LY '
'\x04LY H'
'\x18LY-RECYCLED PAPER SYMBOL'
'\x07LYGISMA'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x08M BRANCH'
'\x06M BULL'
'\x06M DASH'
'\tM HE-GOAT'
'\x05M RAM'
'\nM STALLION'
'\x0bM TIMES SHE'
'\x02M0'
'\x02MA'
'\x05MAAEH'
'\x06MACRON'
'\x05MACUS'
'\x0bMADDA ABOVE'
'\x0cMADDA ABOVE '
'\x06MADR M'
'\x05MADYA'
'\x07MAGE OF'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\x07MAKSURA'
'\x08MAKSURA '
'\x15MAKSURA ISOLATED FORM'
'\x1eMAKSURA WITH SUPERSCRIPT ALEF '
'\x0fMAL SUBGROUP OF'
'\x0fMALAKON CHROMA '
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x0bMALL CIRCLE'
'\x11MALL CIRCLE ABOVE'
'\x18MALL CIRCLE TO THE RIGHT'
'\x06MALL F'
'\x0cMALL LETTER '
'\rMALL LETTER J'
'\rMALL LETTER Z'
'\x15MALL Q WITH HOOK TAIL'
'\tMALL RING'
'\x0bMALL SQUARE'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x05MALON'
'\x03MAN'
'\x04MAN '
'\x07MANCHU '
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x05MANNA'
'\x0cMANNAZ MAN M'
'\x03MAP'
'\x05MAPIQ'
'\x05MAQAF'
'\x03MAR'
'\x07MARCATO'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x04MARU'
'\x04MASH'
'\rMASORA CIRCLE'
'\x12MATHEMATICAL SPACE'
'\x02MB'
'\x0bMBA BAYANNA'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\x04MBOO'
'\x07MBRELLA'
'\tMBROIDERY'
'\x02ME'
'\x0bME LONG CAN'
'\nME PLUS DA'
'\nME PLUS EN'
'\x11ME PLUS GAN2 TENU'
'\x04MEAR'
'\x08MEASURE '
'\x0bMED RGYINGS'
'\x0bMEDIAL FORM'
'\x06MEDIUM'
'\x07MEDIUM '
'\x04MEEM'
'\x05MEEM '
'\x0fMEEM FINAL FORM'
'\x06MEEM I'
'\x11MEEM INITIAL FORM'
'\x05MEEMU'
'\x07MEETORU'
'\x04MEGA'
'\x05MEIZI'
'\x04MEKH'
'\rMELODIC QITSA'
'\x03MEM'
'\x08MEM-QOPH'
'\x06MEMBER'
'\x03MEN'
'\x04MEN '
'\x07MENIAN '
'\x0eMENSION ORIGIN'
'\x04MENT'
'\x07MENT OF'
'\x05MEPET'
'\x04MER '
'\tMES WITH '
'\x04MESO'
'\rMESSENIAN TEN'
'\x0cMETA STAVROU'
'\x05METEG'
'\tMETOBELUS'
'\x06METRIC'
'\x05METRY'
'\x0cMFLEX ACCENT'
'\tMHANCHOLL'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x07MICOLON'
'\x07MIDDLE '
'\x10MIDDLE AND BELOW'
'\x10MIDDLE AND RIGHT'
'\x0fMIDDLE DIAGONAL'
'\nMIDDLE DOT'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE PIECE'
'\x0bMIDDLE STEM'
'\x0cMIDDLE TILDE'
'\x10MIDIRECT PRODUCT'
'\x05MIEUM'
'\x04MIIN'
'\x04MIL '
'\x06MILAR '
'\nMILLE SIGN'
'\rMILLIONS SIGN'
'\x03MIM'
'\x03MIN'
'\x12MINAL DIGIT SHAPES'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\x04MINI'
'\x07MINIMA '
'\nMINO TILE '
'\x05MINUS'
'\nMINUS SIGN'
'\rMINUS SIMILAR'
'\rMINUS WHITE X'
'\x08MIONIAN '
'\x05MISRA'
'\x03MIT'
'\x03MKA'
'\x04MLYA'
'\x02MM'
'\x03MMA'
'\x04MMA '
'\x08MMATION '
'\tMMER AND '
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x1eMODIFIER LETTER LEFT HALF RING'
'\tMODYNAMIC'
'\x03MOI'
'\x04MON '
'\x08MON TIME'
'\x04MONO'
'\nMONOFONIAS'
'\nMONOGRAM B'
'\x1cMONOGRAMMOS TESSERA DODEKATA'
'\x0cMONOGRAPH UK'
'\nMONOSPACE '
'\nMONTH SIGN'
'\x03MOO'
'\x15MORPHOLOGICAL DIVIDER'
'\x0bMOST EQUAL '
'\x08MOTHETIC'
'\x0eMOTHETIC ABOVE'
'\x08MOUNTAIN'
'\x0bMOVED BELOW'
'\x02MP'
'\x05MPARE'
'\x08MPERSAND'
'\x0cMPHASIS MARK'
'\x03MPI'
'\x03MPL'
'\tMPLIFIED '
'\x0cMPTY CENTRE '
'\x05MROCK'
'\x04MTI '
'\x02MU'
'\x06MUCAAD'
'\x03MUG'
'\x04MUIN'
'\tMUKPHRENG'
'\x08MULTIMAP'
'\rMULTIOCULAR O'
'\x14MULTIPLE PUNCTUATION'
'\x0eMULTIPLICATION'
'\x19MULTIPLICATION SIGN BELOW'
'\x10MULTIPLICATION X'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x05MUSIC'
'\x08MUSICAL '
'\x0fMUSICAL SYMBOL '
'\x03MUT'
'\x0bMUUSIKATOAN'
'\x03MWA'
'\x04MWAA'
'\x02MX'
'\x02MY'
'\x04MYA '
'\x07MYSLITE'
'\x03MZA'
'\x0fMZA ABOVE WITH '
'\x01N'
'\x02N '
'\x06N DASH'
'\x0cN ELEMENT OF'
'\x06N SIGN'
'\x0bN THE VERGE'
'\x07N WITH '
'\x06N YANG'
'\x0fN-ARY SUMMATION'
'\x08N-JOINER'
'\x07N2 TENU'
'\x02NA'
'\x05NA PO'
'\nNAASIKYAYA'
'\x04NAAU'
'\x05NABLA'
'\x06NACLES'
'\x05NADA '
'\x04NAG '
'\x03NAH'
'\nNAKE BELOW'
'\x04NAL '
'\x08NAM BCAD'
'\x04NANA'
'\x07NANCIAL'
'\nNANGMONTHO'
'\rNAP PIZZICATO'
'\x03NAR'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\nNASPIRATED'
'\x05NATE '
'\x0cNATURAL SIGN'
'\x06NAUD N'
'\x11NAUDIZ NYD NAUD N'
'\x08NAVIYANI'
'\x13NAXIAN FIVE HUNDRED'
'\x07NAYANNA'
'\x08NCE SIGN'
'\x04NCEL'
'\x05NCHU '
'\x04NCIL'
'\x0cNCK CONSTANT'
'\tNCLOSING '
'\x05NCORA'
'\x02ND'
'\x03ND '
'\nND OF AYAH'
'\x0fND OF PARAGRAPH'
'\x16ND RECORDING COPYRIGHT'
'\x13ND SLANTED PARALLEL'
'\x13ND SOUTH EAST ARROW'
'\x13ND SOUTH WEST ARROW'
'\x0bND TWO DOTS'
'\x06NDA TA'
'\x04NDA2'
'\x04NDAP'
'\x03NDO'
'\x05NDRA '
'\tNDRABINDU'
'\x02NE'
'\x03NE '
'\x07NE DOT '
'\x0fNE EIGHTH BLOCK'
'\x0cNE HALF SIGN'
'\x06NE OF '
'\x11NEGATIVE CIRCLED '
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x03NEO'
'\x04NEO '
'\x07NEQUDAA'
'\x03NER'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x07NESTED '
'\x04NET '
'\tNFORZANDO'
'\x02NG'
'\x03NG '
'\x08NG BELOW'
'\x08NG RTAGS'
'\x07NG SIGN'
'\x11NG STROKE OVERLAY'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x04NGIA'
'\x04NGLE'
'\x05NGLE '
'\x0cNGLE BARLINE'
'\x0cNGLE BRACKET'
'\x13NGLE QUOTATION MARK'
'\x05NGMAN'
'\x0cNGRATULATION'
'\x04NGSI'
'\tNGTH MARK'
'\x08NGTHENER'
'\nNGUAGE TAG'
'\x04NGUE'
'\x02NI'
'\x08NI ABOVE'
'\x03NIA'
'\x03NIB'
'\x04NIC '
'\x05NIEUN'
'\x03NIG'
'\tNIGGAHITA'
'\x05NIGHT'
'\tNIHSHVASA'
'\x03NII'
'\x07NIKAHIT'
'\x04NINE'
'\x08NINETEEN'
'\x12NINETEEN FULL STOP'
'\x06NINETY'
'\x04NING'
'\x05NINTH'
'\x04NION'
'\x06NIRUGU'
'\x06NISTER'
'\x12NITE PART INTEGRAL'
'\x0bNITIAL FORM'
'\x0bNITIAL IZHE'
'\x08NITIAL Z'
'\x19NIVERSAL RECYCLING SYMBOL'
'\x07NJAEMLI'
'\x03NJE'
'\x0fNJOINING MACRON'
'\tNK SYMBOL'
'\x03NMA'
'\x02NN'
'\x03NNA'
'\x0cNNED LEATHER'
'\x02NO'
'\x08NO SLASH'
'\tNO TELEIA'
'\tNOCULAR O'
'\x06NOKHUK'
'\x03NOO'
'\x04NOON'
'\x0fNOON FINAL FORM'
'\nNOON WITH '
'\x06NOR BU'
' NORMAL FACTOR SEMIDIRECT PRODUCT'
'\x0fNORMAL SUBGROUP'
'\x12NORMAL SUBGROUP OF'
'\x10NORTH EAST ARROW'
'\x10NORTH WEST ARROW'
'\x04NOT '
'\x0fNOT APPROXIMATE'
'\tNOT EQUAL'
'\x0cNOT EQUAL TO'
'\x16NOT INCLUDING THE POLE'
'\x08NOT SIGN'
'\x0fNOT TILDE ABOVE'
'\x05NOTCH'
'\x04NOTE'
'\tNOTEHEAD '
'\x04NOUT'
'\x08NOVEMBER'
'\x03NOW'
'\x06NOWMAN'
'\x04NPEA'
'\rNSONANT SIGN '
'\x03NSU'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR D'
'\x08NSULAR G'
'\x06NSUZ A'
'\x15NSVERSAL INTERSECTION'
'\x05NSYON'
'\x02NT'
'\x10NT SCREEN SYMBOL'
')NT-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x05NTAIN'
'\x07NTAINS '
'\x11NTED EQUAL TO OR '
'\tNTERPRISE'
'\x06NTEVMA'
'\x03NTI'
'\x07NTICAL '
'"NTICLOCKWISE-ROTATED DIVISION SIGN'
'\x06NTIIMU'
'\x15NTISTRY SYMBOL LIGHT '
'\nNTITY MARK'
'\x04NTOC'
'\x06NTOGEN'
'\tNTRACTION'
'\x03NTY'
'\rNTY FULL STOP'
'\x02NU'
'\x07NUBIAN '
'\x05NUENG'
'\x0cNUITY SYMBOL'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\nNUMBER TEN'
'\x0bNUMBER ZERO'
'\x08NUMERAL '
'\x0cNUMERAL SIGN'
'\nNUMERATOR '
'\rNUMERATOR ONE'
'\rNUMERIC SIGN '
'\x03NUN'
'\x0bNUN HAFUKHA'
'\x04NUNG'
'\x08NUS SIGN'
'\x07NUSVARA'
'\x08NUSVARA '
'\x0bNUSVARA ONE'
'\tNUSVARAYA'
'\x07NUTILLU'
'\x04NUUN'
'\x08NVERTED '
'\tNVERTED M'
'\tNVERTED R'
'\x0fNVERTED UBADAMA'
'\x02NW'
'\x04NWAA'
'\x0bNWHEEL STAR'
'\x02NY'
'\x12NYET THYOOM TA-ROL'
'\x07NYI ZLA'
'\x0eNYI ZLA NAA DA'
'\x04NYIS'
'\x0bNYIS -KHYIL'
'\x03NYO'
'\x12NYOOGA NAAKSIKYAYA'
'\x01O'
'\x02O '
'\x05O ANG'
'\x03O B'
'\tO HUNDRED'
'\x05O KAI'
'\x04O MA'
'\x03O N'
'\x05O PLA'
'\x05O RUA'
'\x06O SIGN'
'\x08O SYMBOL'
'\x03O Y'
'\x02O0'
'\x0cOACTIVE SIGN'
'\nOANDAKHIAT'
'\x03OAY'
'\x04OBAT'
'\x06OBELOS'
'\x06OBELUS'
'\x0eOBLIQUE HYPHEN'
'\rOBLIQUE LINE '
'\nOBOLS SIGN'
'\x08OBOOFILI'
'\x04OBRO'
'\x15OCAL NOTATION SYMBOL-'
'\x07OCALIC '
'\tOCCLUSION'
'\x06OCENCE'
'\x06OCIETY'
'\x03OCK'
'\x1aOCKED FEMALE AND MALE SIGN'
'\x07OCTOBER'
'\x12ODD POWERS OF FOUR'
'\x06ODHADH'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODO '
'\x02OE'
'\x03OE '
'\x03OEH'
'\x04OENG'
'\tOENICIAN '
'\x10OETIC VERSE SIGN'
'\x02OF'
'\x0bOF MASHFAAT'
'\tOF STIMME'
'\x06OFOUND'
'\x04OFT '
'\x02OG'
'\x07OGDIAN '
'\x03OGH'
'\x0fOGOGRAM KHAMTI '
'\x06OGONEK'
'\rOGOTYPE SIGN '
'\tOGRAPHIC '
'\x02OH'
'\x15OHAMMAD ISOLATED FORM'
'\x0cOHAZARD SIGN'
'\x08OHM SIGN'
'\x06OICING'
'\x0cOID NOTEHEAD'
'\x03OIN'
'\x0cOING TO MEET'
'\x05OINT '
'\x07OINTED '
'\x11OINTED BLACK STAR'
'\x06OINTER'
'\x03OIX'
'\x02OK'
'\x08OK ABOVE'
'\x05OKARA'
'\x05OKEN '
'\x05OKOJI'
'\tOKOUFISMA'
'\x07OKRYTIE'
'\x02OL'
'\x04OLAM'
'\x03OLD'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x0bOLDING BACK'
'\x03OLE'
'\x06OLIDUS'
'\x0fOLIDUS OPERATOR'
'\x0eOLIDUS OVERLAY'
'\x03OLL'
'\nOLLAR SIGN'
'\x08OLLOWING'
'\x04OLON'
'\nOLON EQUAL'
'\x05OLONG'
'\x0eOLUME INTEGRAL'
'\x02OM'
'\x04OMAN'
'\rOMAN NUMERAL '
'\tOMBINING '
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x05OMIKO'
'\x04OMMA'
'\x08OMMA BAR'
'\nOMMA BELOW'
'\x10OMPLETE INFINITY'
'\x03OMU'
'\x02ON'
'\x03ON '
'\tON GROUND'
'\nON MEDIAL '
'\x0bON PEDESTAL'
'\x0cON WITH BALL'
'\x12ON-SPOKED ASTERISK'
'\x04ONA '
'\x04ONAP'
'%ONCAVE-POINTED BLACK RIGHTWARDS ARROW'
'\x14ONCAVE-SIDED DIAMOND'
'\x04OND '
'\x03ONE'
'\x04ONE '
'\x07ONE BAR'
'\x10ONE EIGHTH BLOCK'
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x08ONE MARK'
'\tONE MARK-'
'\x04ONE-'
'\x04ONEK'
'\x03ONG'
'\x04ONG '
'\x08ONG DASH'
'\x07ONG LEG'
'\rONG RIGHT LEG'
'\x05ONG S'
'\x0bONG-BRANCH-'
'\x04ONGA'
'\rONGRATULATION'
'\tONGSEONG '
'\x04ONON'
'\x04ONOS'
'\x0fONTOUR INTEGRAL'
'\x02OO'
'\tOO DENNEN'
'\x08OO TYPE '
'\x03OOD'
'\x03OOF'
'\x06OOMUUT'
'\x03OON'
'\nOON LILITH'
'\rOON NOTEHEAD '
'\x04OONE'
'\x04OONU'
'\x03OOT'
'\x04OOTH'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\x07OP MARK'
'\x05OPBAR'
'\x1eOPEN CENTRE EIGHT POINTED STAR'
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x06OPEN P'
'\nOPEN SHELF'
'\x11OPEN-HEADED ARROW'
'\x08OPENING '
'\x0cOPENING LEFT'
'\x08OPERATOR'
'\x03OPO'
'\x04OPPA'
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x08OPRODUCT'
'\x02OQ'
'\x02OR'
'\x03OR '
'\x06OR EQU'
'\x08OR EQUAL'
'\x0bOR EQUAL TO'
'#OR LOWER LEFT CURLY BRACKET SECTION'
'$OR LOWER RIGHT CURLY BRACKET SECTION'
'\x0bOR OPERATOR'
'\x0bORCE SYMBOL'
'\x07ORCULUS'
'\x0eORD SEPARATOR '
'\x10OREAN CHARACTER '
'\x15OREAN STANDARD SYMBOL'
'\x06ORETTE'
'\x07OREVMA '
'\x05ORGON'
'\x03ORI'
'\x17ORIGINAL OF OR EQUAL TO'
'\x04ORII'
'\tORINHIEUH'
'\tORIZONTAL'
'\x18ORIZONTAL BAR WITH NOTCH'
'\x0fORIZONTAL COLON'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x08ORM FEED'
'\x0fORMATION SOURCE'
'\x03ORN'
'\x08ORNAMENT'
'\x05ORNER'
'\rORNER BRACKET'
'\x06ORONIS'
'\x06ORPIUS'
'\x04ORT '
'\x0bORT BARLINE'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\x1aORTHOGONAL CROSSHATCH FILL'
'\x06ORTION'
'\x15ORTOISE SHELL BRACKET'
'\x04ORTY'
'\x03ORU'
'\x05ORUTO'
'\x02OS'
'\x06OSETTE'
'\x07OSITION'
'\x0eOSITION SYMBOL'
'\x03OSS'
'\x05OSS O'
'\nOSSED SHEI'
'\nOSTAL MARK'
'\x08OSTROPHE'
'\x02OT'
'\x03OT '
'\x08OT ABOVE'
'\x08OT BELOW'
'\x0bOT OPERATOR'
'\x0eOT PUNCTUATION'
'\x07OT SIGN'
'\x03OTA'
'\x07OTATED '
'\x0cOTATION MARK'
'\x04OTE '
'\rOTEHEAD BLACK'
'\x05OTERI'
'\x03OTH'
'\x05OTHAL'
'\x05OTHES'
'\rOTHIC LETTER '
'\x08OTIFIED '
'\x07OTLESS '
'\x12OTLESS DALATH RISH'
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x06OTTED-'
'\x04OTTO'
'\x0cOTTOM HALF O'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE ACUTE'
'\x0bOUBLE ARROW'
'\x0fOUBLE BACKSLASH'
'\x0bOUBLE DANDA'
'\x11OUBLE MONOCULAR O'
'\x04OUBT'
'\x04OUND'
'\nOUND OMEGA'
'\tOUND SIGN'
'\x1cOUND-TIPPED RIGHTWARDS ARROW'
'\x0eOUNDED CORNERS'
'#OUNDED HIGH STOP WITH FILLED CENTRE'
'\x03OUR'
'\x04OUR '
'\x13OUR DOT PUNCTUATION'
'\x08OUR DOTS'
'\x0eOUR DOTS ABOVE'
'\nOUR FIFTHS'
'\x0cOUR INTEGRAL'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x10OUR POINTED STAR'
'\tOURA SIGN'
'\x05OURCE'
'\x07OURTEEN'
'\x11OURTEEN FULL STOP'
'\rOURTH SUBUNIT'
'\x0eOUSING THUNDER'
'\x03OUT'
'\x04OUT '
'\x07OUT HUB'
'\nOUTER JOIN'
'\x0fOUTH EAST ARROW'
'\tOUTH WIND'
'\x19OUTLINED RIGHTWARDS ARROW'
'\x03OVE'
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\x14OVER LEFTWARDS ARROW'
'\x16OVER LEFTWARDS HARPOON'
'\tOVER LONG'
'\tOVER MUSH'
'\x08OVER NUN'
'\x15OVER RIGHTWARDS ARROW'
'\x17OVER RIGHTWARDS HARPOON'
'\x08OVER SAG'
'\tOVER SHE '
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x19OVER TWO DOTS PUNCTUATION'
'\x07OVER U '
'\x07OVERBAR'
'\x08OVERLAID'
'\x17OVERLAPPING LOGICAL AND'
'\x07OVERLAY'
'\x08OVERLINE'
'\x08OVERRIDE'
'\x02OW'
'\x03OW '
'\x07OW LINE'
'\x05OW PA'
'\x06OW TIE'
'\x12OW TONE APOSTROPHE'
'\x13OW-9 QUOTATION MARK'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x05OWER '
'\x0fOWER HALF BLACK'
'\tOWER LEFT'
'\x11OWER NUMERAL SIGN'
'*OWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x07OWILO S'
'\x03OWN'
'\x08OWN TACK'
'\rOWN-POINTING '
'\x07OX BACK'
'\x07OX LINE'
'\x04OXIA'
'\x02OY'
'\x06OYANNA'
'\x03OZE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\x18P DIRECTIONAL FORMATTING'
'\x08P HALF O'
'\x11P ON BLACK SQUARE'
'\x17P SYMBOL FOR LIGHTHOUSE'
'\x06P TACK'
'\x02P0'
'\x02PA'
'\x17PA OVER PA GAR OVER GAR'
'\tPAA-PILLA'
'\x05PAATO'
'\x04PACE'
'\tPADE SUIT'
'\rPAIRED ARROWS'
'\x08PAIRTHRA'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x08PALOCHKA'
'\x06PALUTA'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x0cPAP PLUS PAP'
'\x13PARAGRAPH SEPARATOR'
'\x0bPARAKALESMA'
'\x0bPARALLEL TO'
'\x0bPARENTHESIS'
'\x14PARENTHESIS ORNAMENT'
'\x0ePARESTIGMENON '
'\x06PARKLE'
'\x11PARTING TONE MARK'
'\x07PARTURE'
'\x05PASEQ'
'\x05PATAH'
'\x05PATAK'
'\x08PAVIYANI'
'\x04PAWN'
'\x07PAYANNA'
'\x07PAYEROK'
'\x05PCHA '
'\x02PE'
'\x08PE DRIVE'
'\x04PEAT'
'\x06PECIAL'
'\x07PECTIVE'
'\nPEDAL MARK'
'\x03PEE'
'\x08PEE SIGN'
'\x05PEECH'
'\x04PEEP'
'\x07PEGERMA'
'\x03PEH'
'\x05PEITH'
'\x04PEN '
'\x10PEN CENTRE CROSS'
'\x05PEN E'
'\x05PEN O'
'\x05PEN-P'
'\x06PENCIL'
'\nPENDICULAR'
'\x07PENGKAL'
'\tPENTASEME'
'\x05PEPET'
'\x04PER '
'\x0cPER-EM SPACE'
'\x07PERATOR'
'\nPERCUSSIVE'
'\x08PERFECTA'
'\rPERFECTA REST'
'\x19PERFECTUM CUM PROLATIONE '
'\x12PERFIXED LETTER RA'
'\x0fPERIAL ARAMAIC '
'\x0bPERISPOMENI'
'\x04PERS'
'\x07PERSAND'
'\x06PERSET'
'\tPERSET OF'
'\x16PERSET OF NOR EQUAL TO'
'\x08PERSIAN '
'\x0fPERTHO PEORTH P'
'\x07PERVISE'
'\x02PH'
'\x03PHA'
'\x1bPHARYNGEAL VOICED FRICATIVE'
'\x0cPHEME JOINER'
'\x03PHI'
'\x07PHIEUPH'
'\x0bPHNAEK MUAN'
'\x06PHRASE'
'\x07PHUTHAO'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\tPIDERY HA'
'\x05PIEUP'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x11PINWHEEL ASTERISK'
'\rPINWHEEL STAR'
'\x06PIRIT '
'\x05PITER'
'\x10PLACEHOLDER MARK'
'\x13PLACEMENT CHARACTER'
'\x04PLE '
'\x10PLE MEASURE REST'
'\x03PLI'
'\nPLICATION '
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUM'
'\x04PLUS'
'\nPLUS BELOW'
'\nPLUS ERIN2'
'\nPLUS NAGA '
'\rPLUS OPERATOR'
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x0fPLUS SIGN BELOW'
'\x02PM'
'\x0cPOETRY MARK-'
'\x0cPOGEGRAMMENI'
'\x05POINT'
'\x1ePOINTED RECTILINEAR BLACK STAR'
'\x07POINTER'
'\tPOINTING '
'\x18POINTING DOWNWARDS ABOVE'
'\x0ePOINTING INDEX'
'\x16POINTING UPWARDS BELOW'
'\x06POKED '
'\x05POLI '
'\x07POMOFO '
'\x05PONSE'
'\x04POSE'
'\x08POSITION'
'\x10POSTPOSITION MEN'
'\tPOSTROPHE'
'\x03POT'
'\x02PP'
'\x03PPA'
'\nPPA SYMBOL'
'\x05PPAGE'
'\x04PPER'
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'"PPROXIMATELY NOR ACTUALLY EQUAL TO'
'\x02PR'
'\nPRALINEAR '
'\x16PRECEDED BY APOSTROPHE'
'\x08PRECEDES'
'\x11PRECEDING SOLIDUS'
'\x10PRECEDING SUBSET'
'\x10PRECHGESANG STEM'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x07PRESENT'
'\x07PRICORN'
'\x04PRIL'
'\x05PRIME'
'\x05PRING'
'\x05PRINT'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\x03PRO'
'\x07PRODUCT'
'\x14PROLONGED SOUND MARK'
'\x0cPROTOS ICHOS'
'\x05PSILI'
'\x06PSILON'
'\x07PTHAHA '
'\x05PTIVE'
'\x05PTUNE'
'\x02PU'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x16PUNCTUATION KUNDDALIYA'
'\x11PUNCTUATION SIGN '
'\x08PUSHPIKA'
'\x02PV'
'\x03PWA'
'\x02PY'
'\x01Q'
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x05QAAFU'
'\x03QAF'
'\x1eQAF WITH LAM WITH ALEF MAKSURA'
'\x08QAIRTHRA'
'\x06QAMATS'
'\x04QAPH'
'\x03QAR'
'\x05QATAN'
'\x04QEF '
'\x06QETANA'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x03QOT'
'\x02QU'
'\x03QUA'
'\x04QUAD'
'\x15QUADRANT CIRCULAR ARC'
'\x0fQUADRUPLE ARROW'
'\x0fQUADRUPLE DASH '
'\nQUALS SIGN'
'\x10QUALS SIGN BELOW'
'\x05QUARE'
'\x06QUARE '
'\x0bQUARE BELOW'
'\rQUARE BRACKET'
'\x06QUARED'
'\x07QUARIUS'
'\x07QUARTER'
'\x0bQUARTER ASH'
'\rQUARTER BLOCK'
'\x08QUARTERS'
'\x0eQUARTERS BLOCK'
'\rQUARTERS SIGN'
'\x11QUAT REVERSED ESH'
'\x05QUEEN'
'\x08QUESTION'
'\rQUESTION MARK'
'\x13QUESTION MARK ABOVE'
'\x03QUF'
'\x05QUILL'
'\x0eQUINARIUS SIGN'
'\x0bQUIQUADRATE'
'\x0cQUIRREL TAIL'
'\x05QUIRY'
'\nQUISH QUAD'
'\x0eQUOTATION MARK'
'\x17QUOTATION MARK ORNAMENT'
'\tQUSHSHAYA'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x06R THAN'
'\x07R TSHES'
'\x0fR WITH FISHHOOK'
'\x02R0'
'\x02R2'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x07RA SIGN'
'\x03RAA'
'\x0bRACHMA SIGN'
'\x05RACHY'
'\nRACTER TIE'
'\x10RACTION ONE HALF'
'\x08RADICAL '
'\x03RAE'
'\x04RAEA'
'\x04RAFE'
'\x07RAGANA '
'\nRAGGISMATA'
'\x0cRAH BEN YOMO'
'\x03RAI'
'\x05RAIDA'
'\x10RAIDO RAD REID R'
'\nRAINIAN IE'
'\x17RAISED OMISSION BRACKET'
'\x07RAKHANG'
'\tRAL HEART'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x08RAMMA GG'
'\x03RAN'
'\x19RANCH BANK IDENTIFICATION'
'\x0cRANCHING OUT'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x05RANUS'
'\x07RARIETY'
'\x05RASHA'
'\x05RASS '
'\x05RATER'
'\x05RATHA'
'\x08RAUGHTS '
'\x0bRAVE ACCENT'
'\x03RAY'
'\x07RAYANNA'
'\x03RCH'
'\x07RCHAIC '
'\x0cRCHAIC SAMPI'
'\x07RCHAION'
'\x05RCHID'
'\x05RCURY'
'\x02RD'
'\x03RD '
'\x07RD SIGN'
'\tRDEL DKAR'
'\x08RDEL NAG'
'\x0bRDHAVISARGA'
'\x07RDO RJE'
'\x02RE'
'\x07READING'
'\x0bREAKTHROUGH'
'\x04REAT'
'\x07REAT SA'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x0fRECEPTIVE EARTH'
'\x10RECORD SEPARATOR'
'\x08RECORDER'
'\x1cRECT CURRENT SYMBOL FORM TWO'
'\tRECTANGLE'
'\x1cRECTANGULAR PATH AROUND POLE'
'\x16RECTILINEAR BLACK STAR'
'\nRED DRAGON'
'\x03REE'
'\x04REE '
'\x0bREE HUNDRED'
'\x08REE MARK'
'\x17REE VARIATION SELECTOR '
'\x0eREE-LINE STAFF'
'\x05REEK '
'\x0cREFACE COLON'
'\x03REH'
'\x04REH '
'\x0eREH FINAL FORM'
'\x04REIA'
'\x05RELAA'
'\nRENCY SIGN'
'\x06RENGTH'
'\x04REPA'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x04REST'
'\x0eRETROFLEX HOOK'
'\x08REVERSE '
'\x0cREVERSE MARK'
'\x0fREVERSE SOLIDUS'
'\x08REVERSED'
'\tREVERSED '
'\x15REVERSED FEATHER MARK'
'\nREVERSED I'
'\x14REVERSED ONE HUNDRED'
'\x0fREVERSED OPEN E'
'\x05REVIA'
'\x0eRFACE INTEGRAL'
'\x03RGE'
'\x06RGIAN '
'\x06RGLASS'
'\x03RGO'
'\x04RGON'
'\x04RGU2'
'\x03RHO'
'\nRHO SYMBOL'
'\x02RI'
'\x05RIAC '
'\x0cRIANGLE DOWN'
'\x1fRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0fRIANGULAR COLON'
'\x11RIATION SELECTOR-'
'\x05RICEM'
'\x05RIEUL'
'\x03RIG'
'\x05RIGHT'
'\x06RIGHT '
'\nRIGHT AND '
'\x14RIGHT ANGLE WITH DOT'
'\x1bRIGHT ARC LESS-THAN BRACKET'
'\x0cRIGHT ARROW '
'\x11RIGHT ARROW ABOVE'
'\x17RIGHT DIAGONAL ELLIPSIS'
'\x19RIGHT DIAGONAL HALF BLACK'
'\x0cRIGHT DOUBLE'
'\x10RIGHT DOWN BARB '
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x11RIGHT HALF CIRCLE'
'\x0fRIGHT HALF RING'
'\rRIGHT HARPOON'
'\x0bRIGHT HEAVY'
'\nRIGHT HOOK'
'\x0bRIGHT LIGHT'
'\x11RIGHT PARENTHESIS'
'\x1aRIGHT PARENTHESIS ORNAMENT'
'\x0eRIGHT QUADRANT'
'\x14RIGHT QUADRANT BLACK'
'\x0fRIGHT RERENGGAN'
'\x0cRIGHT SINGLE'
'\x13RIGHT TO LOWER LEFT'
'%RIGHT TORTOISE SHELL BRACKET ORNAMENT'
'\x0eRIGHT TRIANGLE'
'\x0fRIGHT TURNSTILE'
'\x0bRIGHT-HAND '
'\x14RIGHT-POINTING ANGLE'
'#RIGHT-POINTING ANGLE QUOTATION MARK'
'\nRIGHTWARDS'
'\x10RIGHTWARDS ARROW'
'&RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW'
'\x11RIGHTWARDS ARROWS'
'!RIGHTWARDS HARPOON WITH BARB DOWN'
'\x1fRIGHTWARDS HARPOON WITH BARB UP'
'\x18RIGHTWARDS THEN CURVING '
'\x0fRIGHTWARDS TICK'
'\nRIGINAL OF'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x06RIISAP'
'\x06RIKRIK'
'\x07RILLIC '
'\x04RIME'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x0cRING OVERLAY'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x08RINHIEUH'
'\x0cRION CHRONON'
'\x03RIP'
'\x06RIPLE '
'\x0bRIPLE ARROW'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\x0bRIPLE PRIME'
'\rRIPLE SVARITA'
'\x0eRIPLE UNDERDOT'
'\x1bRIPLE VERTICAL BAR OPERATOR'
'\x04RIPT'
'\x06RIPT G'
'\x06RISEME'
'\x04RISH'
'\x07RISIMOU'
'\x0fRISING DIAGONAL'
'\x15RISING DIAGONAL SLASH'
'\x0bRISING DOTS'
'\x0bRISING TONE'
'\x10RISING TONE MARK'
'\tRISPOMENI'
'\x05RITSI'
'\x04RITU'
'\x08RIYOOSAN'
'\tRIZONTAL '
'\x10RIZONTAL ELLIPSE'
'\x02RK'
'\x0eRK NOON GHUNNA'
'\x08RK SHADE'
'\x06RKAANU'
'\x04RKLE'
'\x03RMA'
'\x0fRMAN PENNY SIGN'
'\x18RMITIAN CONJUGATE MATRIX'
'\x07RMUKHI '
'\x02RN'
'\x0cRNAM BCAD MA'
'\x0fRNAMENT STROKE-'
'\x05RNED '
'\tRNEY PARA'
'\nRNING SIGN'
'\x02RO'
'\x04ROA '
'\nROAD OMEGA'
'\x04ROAR'
'\x06ROBANG'
'\x03ROC'
'\nROEZENIAN '
'\x03ROG'
'\x07ROGRESS'
'\tROJECTION'
'\rROKEE LETTER '
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x03RON'
'\x0eRONIAN SIGN ET'
'\x05RONIS'
'\x0bRONTHISMATA'
'\x04ROOK'
'\x03ROP'
'\x0bROR-BARRED '
'\rROSGEGRAMMENI'
'\x04ROSH'
'\x04ROSS'
'\x0bROSS ACCENT'
'\x0eROSS ON SHIELD'
'\x0bROSSED-TAIL'
'\rROSSING LANES'
'\x1bROTATED FLORAL HEART BULLET'
'\x04ROTO'
'\x07ROTUNDA'
'\x16ROUND A POINT OPERATOR'
'\x0cROUNDED ZERO'
'\x04ROUT'
'\rROW POINTING '
'\tROW WITH '
'\x0cROWNING FACE'
'\rRPENTRY PLANE'
'\x0bRPOON ABOVE'
'\tRPORATION'
'\x04RPSE'
'\x03RQA'
'\x02RR'
'\x05RRECT'
'\x07RRECTUS'
'\x06RRED O'
'\x0cRRESPONDS TO'
'\rRRIAGE RETURN'
'\rRRIAGE SYMBOL'
'\x06RRIER '
'\x04RROI'
'\x04RROW'
'\x13RROW NO-BREAK SPACE'
'\x16RROW WITH ROUNDED HEAD'
'\x03RRY'
'\x08RSECTION'
'\x06RSHANA'
'\nRSI SYMBOL'
'\x06RSIAN '
'\x10RST QUARTER MOON'
'\x02RT'
'\x03RT '
'\x04RT T'
'\x04RTAR'
'\x03RTE'
'\tRTER MARK'
'\tRTER NOTE'
'\x03RTH'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\x05RUDAA'
'\x03RUE'
'\x05RUHUA'
'\x04RUIS'
'\x04RUKU'
'\tRUM CLEF-'
'\x14RUMAI PALAUNG TONE-5'
'\x04RUNA'
'\x04RUNG'
'\x06RUPEE '
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x05RUSH '
'\x04RUSI'
'\x04RUTU'
'\x02RV'
'\nRVICE MARK'
'\x02RY'
'\x11RYBLION BASE SIGN'
'\x08RYNGEAL '
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0cS ABOVE SIGN'
'\x07S BELOW'
'\tS DIGRAPH'
'\x07S ICHOS'
'\x08S INSIDE'
'\rS KAI APOTHES'
'\x03S O'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x0cS SUBPUNCTIS'
'\x02S0'
'\x02SA'
'\x04SA-I'
'\x06SAADIY'
'\x1eSAD WITH LAM WITH ALEF MAKSURA'
'\x04SADI'
'\x03SAG'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x03SAM'
'\x07SAMPHAO'
'\x05SAMPI'
'\rSAMYOK SANNYA'
'\x04SANG'
'\x08SANGSIOS'
'\x0bSANS-SERIF '
'\x08SANYAKA '
'\x05SARGA'
'\x05SASA '
'\x05SASAK'
'\x03SAT'
'\x05SAUIL'
'\x07SAYANNA'
'\x0cSAZ IS ISS I'
'\nSBUB -CHAL'
'\nSCAN LINE-'
'\x05SCAPE'
'\x05SCENT'
'\x04SCES'
'\x05SCHWA'
'\x14SCRIPTION CHARACTER '
'\x02SE'
'\x03SE '
'\nSE-CREE SK'
'\x06SEBALL'
'\x0bSECOND MARK'
'\x0eSECOND SUBUNIT'
'\x04SECT'
'\x07SECTION'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEN'
'\x05SEGOL'
'\x04SELF'
'\x16SEMI-VOICED SOUND MARK'
' SEMICIRCULAR ANTICLOCKWISE ARROW'
'\x1dSEMICIRCULAR PATH AROUND POLE'
'\tSEMICOLON'
'\x0fSEMIVOWEL SIGN '
'\x05SENTO'
'\tSEPARATOR'
'\x14SEPARATOR KEY SYMBOL'
'\x14SEPARATOR MIDDLE DOT'
'\tSEPTEMBER'
'\x10SERIFS AT BOTTOM'
'\x07SERTION'
'\x03SET'
'\rSEVEN EIGHTHS'
'\x13SEVEN EIGHTHS BLOCK'
'\x07SEXTILE'
'\x04SEYE'
'\nSGOR RTAGS'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\nSH PRODUCT'
'\x07SH TAIL'
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\x04SHAD'
'\x05SHADE'
'\x15SHADOWED WHITE SQUARE'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x05SHANG'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARP'
'\nSHARP SIGN'
'\x05SHARU'
'\x06SHAYIM'
'\x03SHE'
'\x04SHE3'
'\x05SHED '
'\x0cSHED BARLINE'
'\x04SHEI'
'\x0bSHEQEL SIGN'
'\x05SHESH'
'\x07SHESHIG'
'\x05SHEYE'
'\x05SHGAB'
'\x05SHIMA'
'\x0fSHITA PLUS GISH'
'\x08SHKIR KA'
'\x08SHOE JOT'
'\nSHOE STILE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x15SHORT LEFTWARDS ARROW'
'\x0fSHORT OVER LONG'
'\x16SHORT RIGHTWARDS ARROW'
'\x0cSHORT RIKRIK'
'\x16SHORT VERTICAL STROKES'
'\x04SHTA'
'\x04SHU2'
'\x04SHYA'
'\x02SI'
'\x1dSIBE SYLLABLE BOUNDARY MARKER'
'\x03SIC'
'\x06SICKLE'
'\x05SICLE'
'\x06SIEUNG'
'\x08SIFISTON'
'\x0cSIGMA SYMBOL'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x07SIGN PA'
'\rSIGN PAMUDPOD'
'\x0bSIGN VIRAMA'
'\x04SIKI'
'\x05SILA3'
'\x04SILI'
'\rSILI PNEUMATA'
'\x17SING DIAGONAL CROSSING '
'\x0bSINGLE AND '
'\x14SINGLE DOT TONE MARK'
'\x12SINGLE PUNCTUATION'
'\x0cSINGLE-LINE '
'\x18SINGLE-LINE NOT EQUAL TO'
'\x04SINK'
'\x05SION '
'\x04SIOS'
'\x04SIS '
'\x03SIX'
'\tSIXTEENTH'
'\x0fSIXTEENTH NOTES'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x06SIXTHS'
'\x03SJE'
'\x04SKAL'
'\x06SKAPI '
'\x08SKLIRON '
'\x08SLANTED '
'\x10SLANTED EQUAL TO'
'\x05SLASH'
'\x04SLUR'
'\x03SMA'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\x12SMALL CIRCLE ABOVE'
'\x07SMALL L'
'\rSMALL LETTER '
'\x0eSMALL LETTER J'
'\x0eSMALL TRIANGLE'
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\tSMALL YUS'
'\x07SMANYA '
'\x08SNA LDAN'
'\x02SO'
'\x03SO '
'\tSOF PASUQ'
'\x05SOL S'
'\x0cSOLATED FORM'
'\x07SOLIDUS'
'\x17SOLIDUS BINARY RELATION'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x0eSOUTH ARABIAN '
'\x10SOUTH EAST ARROW'
'\x05SPACE'
'\nSPACE MARK'
'\x13SPACING CANDRABINDU'
'\x06SPATHI'
'\x08SPERSION'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x0fSPOKED ASTERISK'
'\x07SPRINGS'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x0eSQUIGGLE ARROW'
'\x02SS'
'\x07SS-THAN'
'\x08SS-THAN '
'\x0cSS-THAN SIGN'
'\x03SSA'
'\nSSANGARAEA'
'\x0bSSANGKIYEOK'
'\nSSANGPIEUP'
'\tSSANGSIOS'
'\x05SSERA'
'\x08SSESSION'
'\x0bSSIVE-PULL-'
'\x02ST'
'\x0fST QUARTER MOON'
'\x0fST SYRIAC CROSS'
'\x03STA'
'\rSTABLE SYMBOL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x07STATERS'
'\x0fSTERESIS SYMBOL'
'\x07STERING'
'\x07STERISK'
'\x08STERISK '
'\x10STERISK OPERATOR'
'\rSTERTIUS SIGN'
'\x05STILE'
'\x07STIMATE'
'\x04STLE'
'\x06STOLI '
'\x04STOP'
'\x0bSTORIC SITE'
'\x05STORM'
'\x13STRATIAN FIFTY MNAS'
'\x10STRING FRETBOARD'
'\x06STROFO'
'\x06STROKE'
'\x07STROKE '
'\x19STROKE AND TWO DOTS ABOVE'
'\x0fSTROKE NOT SIGN'
'\x0eSTROKE OVERLAY'
'\x18STROKE THROUGH DESCENDER'
'\nSTROM SIGN'
'\x07STRUCK '
'\x03STU'
'\x02SU'
'\x03SU '
'\x06SUBSET'
'\x13SUBSTITUTION MARKER'
'\x07SUCCEED'
'\x08SUCCEEDS'
'\x04SUIT'
'\x04SUKU'
'\x05SUKUN'
'\x07SUKUUDO'
'\x03SUM'
'\x04SUNG'
'\x1dSUPERSCRIPT ALEF INITIAL FORM'
'\x1eSUPERSCRIPT ALEF ISOLATED FORM'
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x0eSURROUND FROM '
'\x07SVARITA'
'\nSWASH TAIL'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\x06SYMBOL'
'\x07SYMBOL '
'\x0bSYMBOL FOR '
'\x12SYMMETRIC SWAPPING'
'\x16SYMPTOTICALLY EQUAL TO'
'\x07SYNAGMA'
'\rSYNDESMOS NEO'
'\tSYNTHETON'
'\x06SYOUWA'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\x07T ABOVE'
'\x07T BELOW'
'\x18T BLACK RIGHTWARDS ARROW'
'\x07T MINUS'
'\x07T RIGHT'
'\x02T0'
'\x02TA'
'\x03TA '
'\x07TA MARK'
'\x03TAA'
'\x08TAALUJA '
'\x03TAB'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\x04TACK'
'\x05TACK '
'\nTACK BELOW'
'\x03TAH'
'\x08TAI LUE '
'\x06TAIKHU'
'\x04TAIL'
'\x04TAIN'
'\x07TAISYOU'
'\x04TAK4'
'\x06TAKANA'
'\tTAKHALLUS'
'\x03TAL'
'\x08TAL MARK'
'\nTAL RUNOUT'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x03TAM'
'\x06TAMING'
'\x03TAN'
'\x11TAN ISOLATED FORM'
'\tTANDSTILL'
'\x03TAO'
'\x03TAR'
'\x08TART OF '
'\x13TART OF RUB EL HIZB'
'\x03TAS'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAV'
'\x04TAWA'
'\x07TAYANNA'
'\x03TCH'
'\x07TCHFORK'
'\x02TE'
'\x0cTE SEPARATOR'
'\x06TE TSE'
'\x18TEARDROP-SPOKED ASTERISK'
'"TEARDROP-SPOKED PROPELLER ASTERISK'
'\x04TED '
'\x06TEDUNG'
'\x04TEEN'
'\x15TEEN POINTED ASTERISK'
'\x05TEGEH'
'\x03TEH'
'\nTELEGRAPH '
'\x10TELOUS ICHIMATOS'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x1aTENDED ARABIC-INDIC DIGIT '
'\x0bTENS DIGIT '
'\x04TENT'
'\x04TENU'
'\x03TER'
'\x04TER '
'\nTER SYMBOL'
'\x05TERIS'
'\nTERMINATOR'
'\x06TERNAT'
'\nTERNATIVE '
'\x19TERNION INTEGRAL OPERATOR'
'\x07TERNITY'
'\x06TERON '
'\x11TERSYLLABIC TSHEG'
'\nTESE CROSS'
'\x0eTETARTOS ICHOS'
'\x0bTETRAFONIAS'
'\x04TEXT'
'\x02TH'
'\x03TH '
'\x07TH MARK'
'\x07TH ROOT'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x0eTHALAN ETHEL O'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x08THAMASAT'
'\x13THANG LONG ANUSVARA'
'\nTHAPASCAN '
'\x05THEMA'
'\x0bTHEMATICAL '
'\x04THER'
'\x07THESEOS'
'\x0cTHETA SYMBOL'
'\x07THIEUTH'
'\x08THIOPIC '
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x06THIRDS'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\nTHMIKON N '
'\x03THO'
'\x0cTHODOX CROSS'
'\x04THOR'
'\x06THORA '
'\x08THOUSAND'
'\tTHOUSAND '
'\x0eTHOUSANDS SIGN'
'\x06THREE '
'\x0bTHREE DOTS '
'\x10THREE DOTS ABOVE'
'\x1aTHREE DOTS ABOVE DOWNWARDS'
'\x0eTHREE QUARTERS'
'\x0bTHREE TIMES'
'\x14THROUGH SMALL CIRCLE'
'\x07THUNDER'
'\x03THY'
'\x02TI'
'\x04TIC '
'\x06TICAL '
'\x08TICK IN '
'\x0cTICLOCKWISE '
'\x03TIE'
'\x05TIGMA'
'\x06TIKENO'
'\x06TIKEUT'
'\x04TIKI'
'\x05TILDE'
'\x06TILDE '
'\x0fTILDE DIAERESIS'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TIMES'
'\x06TIMES '
'\tTIMES BAD'
'\x0eTIMES OPERATOR'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES SIGN'
'\nTIMES TAK4'
'\x08TIMORION'
'\x04TIN '
'\x08TINGUISH'
'\x05TINNE'
'\x03TIO'
'\x08TION KEY'
'\x13TIONAL DIGIT SHAPES'
'\x04TIP '
'\x05TIPPI'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x08TISMOS E'
'\x03TIV'
'\x07TIVATE '
'\x03TJE'
'\x05TKAAN'
'\x03TLE'
'\x07TLINED '
'\x05TMAAU'
'\x05TNESS'
'\x02TO'
'\x03TO '
'\x06TO BAR'
'\tTO CORNER'
'\x12TO LOWER LEFT FILL'
'\x13TO LOWER RIGHT FILL'
'\x08TO-LEFT '
'\tTO-RIGHT '
'\x10TODO SOFT HYPHEN'
'\nTOM SYMBOL'
'\x03TON'
'\x05TON A'
'\x0bTONAL MARK '
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\tTONE MARK'
'\x15TONE MARK SGAW KAREN '
'\x05TONE-'
'\x05TONOS'
'\x03TOO'
'\x03TOP'
'\x04TOP '
'\nTOP CORNER'
'\x0eTOP HALF BLACK'
'\rTOP HALF RING'
'\x14TOP SEMICIRCLE ARROW'
' TOP-LIGHTED RIGHTWARDS ARROWHEAD'
'\x06TOPBAR'
'\x16TORTOISE SHELL BRACKET'
'\tTOS ICHOS'
'\x0cTRAGRAM FOR '
'\x05TRAIF'
'\tTRAIGHT U'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x06TRAPLI'
'\nTRESS AND '
'\x0bTRESS SIGN '
'\nTRETCHED C'
'\x03TRI'
'\x04TRIA'
'\x08TRIANGLE'
' TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0fTRIANGULAR MARK'
'\x07TRICAL '
'\x08TRICOLON'
'\x13TRICTED LEFT ENTRY-'
'\x0cTRIPLE DANDA'
'\x0cTRIPLE DASH '
'\x11TRIPLE DASH ARROW'
'\x16TRIPLE RIGHT TURNSTILE'
'\x16TRIPLE VERTICAL STROKE'
'\rTROFLEX CLICK'
'\x12TROFLEX HOOK BELOW'
'\x05TROKE'
'\x0eTROKE NOT SIGN'
'\rTROKE OVERLAY'
'\x0bTRUNCATED A'
'\x02TS'
'\x05TSADI'
'\x05TSERE'
'\x05TSHEG'
'\x02TT'
'\x06TTAVA '
'\x05TTED '
'\tTTED STEM'
'\x19TTED SUBSTITUTION BRACKET'
'\x08TTENTION'
'\x04TTER'
'\x05TTER '
'\x05TTERN'
'\x07TTHACAN'
'\x08TTO MARK'
'\x05TTOCK'
'\x05TTOM '
'\x05TTORU'
'\x02TU'
'\x05TUEUM'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x0eTURKIC LETTER '
'\x04TURN'
'\x0bTURN SYMBOL'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x0fTVIMADUR SYMBOL'
'\x03TWA'
'\x04TWAA'
'\x05TWEEL'
'\x03TWO'
'\x0eTWO DOT LEADER'
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'!TWO DOTS ABOVE AND TWO DOTS BELOW'
'\x16TWO HORIZONTAL STROKES'
'#TWO HORIZONTAL STROKES TO THE RIGHT'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x0eTWO WHITE DOTS'
'\x0fTWO WITH STROKE'
'\x02TY'
'\x06TY SET'
'\nTYPE COLON'
'\x05TYPE-'
'\x05TYR T'
'\x01U'
'\x02U '
'\rU LENGTH MARK'
'\x06U MARK'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x03U U'
'\rU WITH STROKE'
'\x02U0'
'\x02U2'
'\x02U3'
'\nU3 PLUS AN'
'\x02UA'
'\x03UAE'
'\x03UAN'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x03UAT'
'\x08UATRILLO'
'\x02UB'
'\x03UB2'
'\x07UBADAMA'
'\x04UBED'
'\x0eUBHAYATO MUKHA'
'\x05UBITO'
'\x10UBJOINED LETTER '
'\x04UBLE'
'\x05UBLE '
'\x08UBLE BAR'
'\nUBLE DANDA'
'\nUBLE DASH '
'\nUBLE GRAVE'
'\x0fUBLE RING BELOW'
'\x0cUBLE SVARITA'
'\x0bUBLE TONGUE'
'\x14UBLE VERTICAL STROKE'
'\x06UBLE X'
'\x16UBSCRIPT SMALL LETTER '
'\x0cUBSCRIPT TWO'
'\tUBSTITUTE'
'\x13UBSTITUTION BRACKET'
'\x07UBUFILI'
'\x05UBURU'
'\x05UBUTS'
'\x05UCEUS'
'\x02UD'
'\x05UDAAT'
'\x06UDATTA'
'\x03UDY'
'\x02UE'
'\x03UEH'
'\rUFFLE PRODUCT'
'\x06UFISMA'
'\x02UG'
'\x0bUG RTAGS GY'
'\x0fUGMENTATION DOT'
'\x04UGU '
'\x05UGUST'
'\x04UHUR'
'6UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA '
'\x03UJA'
'\x02UK'
'\x05UKARA'
'\x07UKKAKHA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x03UL '
'\x08ULA SIGN'
'\x0bULAR BULLET'
'\x10ULDERED OPEN BOX'
'\x06ULDRON'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x12ULL AND CROSSBONES'
'\x0cULL NOTEHEAD'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x0bULO TWO SUM'
'\x04ULTI'
')ULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x0fUMAI PALAUNG FA'
'\x04UMAN'
'\nUMAN EARTH'
'\nUMBER SIGN'
'\tUMED HEAD'
'\x08UMMATION'
'\x05UMMER'
'\x03UMX'
'\x02UN'
'\x0cUN WITH RAYS'
'\x04UNAH'
'\x04UNAP'
'\x06UNATE '
'\x12UNATE SIGMA SYMBOL'
'\x04UNAV'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x10UNCTUATION SPACE'
'\x04UND '
'\x08UND SIGN'
'\x05UNDER'
'\x0eUNDER RELATION'
'\x08UNDERBAR'
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\tUNGSEONG '
'\x05UNION'
'\x0eUNION OPERATOR'
'\x11UNION WITH SERIFS'
'\x0bUNIT DIGIT '
'\x0eUNIT SEPARATOR'
'\x05UNITY'
'\x0bUNJO WYNN W'
'\nUNKIA SIGN'
'\x04UNNY'
'\x05UNOO '
'\x03UNT'
'\x06UNTAIN'
'\x02UO'
'\x03UON'
'\x04UON '
'\x03UOP'
'\x02UP'
'\x03UP '
'\x07UP AND '
'\x11UP AND HORIZONTAL'
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x06UP BOW'
'\nUP HARPOON'
'\x08UP HEAVY'
'\x1cUP HEAVY AND LEFT DOWN LIGHT'
'\x1dUP HEAVY AND RIGHT DOWN LIGHT'
'\x13UP HORIZONTAL HEAVY'
'\x13UP HORIZONTAL LIGHT'
'\x08UP LIGHT'
'\x07UP MARK'
'\x0eUP RIGHT BARB '
'\x07UP TACK'
'\x10UP-OUTPUT SYMBOL'
'\x0bUPADHMANIYA'
'\rUPERIMPOSED X'
'\x10UPERSCRIPT ALAPH'
'\x0fUPERSCRIPT ALEF'
'\x04UPLE'
'\x05UPLE '
'\rUPONDIUS SIGN'
'\x06UPPER '
'\x0cUPPER CORNER'
'\tUPPER DOT'
'\nUPPER HALF'
'\nUPPER HOOK'
'\x16UPPER RIGHT AND LOWER '
'+UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x18UPRIGHT RECTANGULAR ZERO'
'\x07UPSILON'
'\rUPSILON WITH '
'\tUPTSTIMME'
'\x06UPTURN'
'\x18UPWARD POINTING TRIANGLE'
'\x07UPWARDS'
'\x1cUPWARDS AND RIGHTWARDS ARROW'
'\rUPWARDS ARROW'
'\x1fUPWARDS HARPOON WITH BARB RIGHT'
'\x02UQ'
'\x02UR'
'\nUR CORNERS'
'\nUR HUNDRED'
'\nUR YIG MGO'
'\x03UR-'
'\x03URA'
'\tURAMAZDAA'
'\x05URAMU'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URGLASS'
'\x05URITY'
'\x03URL'
'\x0cURLY BRACKET'
'\x03URN'
'\x06URNED '
'\x0bURNED COMMA'
'\x11URNED COMMA ABOVE'
'\tURNED GAN'
'\x13URRENCY SYMBOL BAHT'
'\x03URT'
'\x06URTEEN'
'\x05URTLE'
'\x03URU'
'\x04URUS'
'\tURUZ UR U'
'\x02US'
'\x04USA '
'\x03USE'
"'USED AS KORANIC STOP SIGN ISOLATED FORM"
'\x03USH'
'\rUSHING UPWARD'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x07USSYERU'
'\x0fUSTER NOTEHEAD '
'\x16USTOMER ACCOUNT NUMBER'
'\x0bUSTRAL SIGN'
'\x02UT'
'\x04UT H'
'\nUT NOT EQU'
'\x07UT TIME'
'\x03UTE'
'\x05UTE A'
'\x04UTER'
'\tUTER JOIN'
'\x0bUTH CORNERS'
'\x0cUTH-SLAVEY K'
'\x05UTIES'
'\nUTION SIGN'
'\x12UTLINED BLACK STAR'
'\x02UU'
'\x06UUMISH'
'\tUURDHAJA '
'\x02UX'
'\x06UYANNA'
'\x02UZ'
'\x06UZEIRO'
'\x0bUZEIRO SIGN'
'\x01V'
'\x08V OVER M'
'\x02V0'
'\x02VA'
'\x05VAAVU'
'\x07VAGRAHA'
'\x0cVAKRAHASANYA'
'\x14VAL WITH OVAL INSIDE'
'\x07VALENT '
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x05VARIA'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VARIANT WITH SQUARE'
'\x13VARIATION INDICATOR'
'\x0bVARYS ICHOS'
'\x13VASTNESS OR WASTING'
'\x03VAV'
'\x07VAV YOD'
'\x07VAYANNA'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\x10VE EIGHTHS BLOCK'
'\nVE HUNDRED'
'\x08VE SASAK'
'\rVE-LINE STAFF'
' VED STEM PARAGRAPH SIGN ORNAMENT'
'\x04VEDE'
'\x03VEE'
'\x11VEE WITH UNDERBAR'
'\x06VELOPE'
'\tVELOPMENT'
'\x03VEN'
'\x11VEN EIGHTHS BLOCK'
'\x03VER'
'\x0cVER EQUAL TO'
'\tVER LUGAL'
'\x05VER S'
'\x11VERAGE WITH SLASH'
'\x08VERGENCE'
'\x07VERLINE'
'\tVERLONG A'
'\x17VERSAL RECYCLING SYMBOL'
'\x05VERSE'
'\rVERSE DIVIDER'
'\x13VERSE FINAL BARLINE'
'\x07VERSED '
'\x08VERTICAL'
'\tVERTICAL '
'\x0eVERTICAL ABOVE'
'\nVERTICAL B'
'\x0cVERTICAL BAR'
'\rVERTICAL BAR '
'(VERTICAL BAR AT END OF HORIZONTAL STROKE'
'\x17VERTICAL BISECTING LINE'
'\x0eVERTICAL COLON'
'\rVERTICAL FILL'
'\x0eVERTICAL HEAVY'
'\x0eVERTICAL LIGHT'
'\rVERTICAL LINE'
'\x15VERTICAL LINE OVERLAY'
'\x0fVERTICAL STROKE'
'\x13VERTICAL TABULATION'
'\x10VERTICALLY ABOVE'
'\x08VESSEL B'
'\x07VESTAN '
'\x07VEW NOW'
'\x02VI'
'\x0cVIAN LETTER '
'\rVICE CONTROL '
'\x04VIDA'
'\x04VIDE'
'\x05VIET '
'\x06VILIAN'
'\x07VILIK B'
'\x03VIN'
'\x08VINATION'
'\x04VINE'
'\nVIOUS PAGE'
'\x03VIR'
'\x06VIRAMA'
'\x06VIRIAM'
'\x03VIS'
'\x07VISARGA'
'\x08VISARGA '
'\x0bVISARGA ONE'
'\tVISARGAYA'
'\x08VISION S'
'\x06VIYANI'
'\x02VO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x05VOICE'
'\x15VOICED ITERATION MARK'
'\x18VOICED LARYNGEAL SPIRANT'
'\x11VOICED SOUND MARK'
'\x08VOLUTION'
'\x0eVONIC ASTERISK'
'\x03VOU'
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x0fVOWEL SEPARATOR'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x0eVRON SNOWFLAKE'
'\x02VU'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\x02W '
'\x06W LINE'
'\nW OR MODEL'
'\rW RING INSIDE'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x05WAAVU'
'\x04WAHA'
'\x03WAI'
'\x04WAIR'
'\x03WAN'
'\x05WARDS'
'\x06WARDS '
'\x0bWARDS ARROW'
'\x11WARDS ARROW BELOW'
'\x0cWARDS BULLET'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\nWARDS VANE'
'\x14WARE-FUNCTION SYMBOL'
'\x16WASALLAM ISOLATED FORM'
'\x08WASH KAF'
'\tWASH TAIL'
'\x05WATTO'
'\x03WAU'
'\x04WAVE'
'\x0bWAVY HAMZA '
'\rWAVY LOW LINE'
'\rWAVY OVERLINE'
'\x03WAW'
'\x04WAW '
'\rWAW-AYIN-RESH'
'\x03WAZ'
'\x07WAZ EOH'
'\x02WE'
'\x04WEEN'
'\x04WEET'
'\x05WENTY'
'\x06WEORTH'
'\x03WER'
'\x04WER '
'\x05WEST '
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x02WG'
'\x05WHITE'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x0fWHITE DOT RIGHT'
'\x11WHITE PARENTHESIS'
'\x11WHITE SHOGI PIECE'
'\nWHITE STAR'
'\x12WHITE VERTICAL BAR'
'\x05WIANG'
'\x05WIDE '
'\x11WIDE BRIDGE ABOVE'
'\x06WIDTH '
'\x0cWIGGLY FENCE'
'\x07WIGNYAN'
'\x04WIND'
'\x05WINDU'
'\x05WINJA'
'\x05WISAD'
'\x05WITH '
'\rWITH ASTERISK'
'\nWITH BARB '
'\nWITH CARON'
'\x10WITH CENTRED DOT'
'\x0eWITH DIAERESIS'
'\tWITH DOT '
'\x0eWITH DOT ABOVE'
'\x0eWITH DOT BELOW'
'\x0fWITH DOWN ARROW'
'\x0eWITH FATHATAN '
'\x14WITH FOUR DOTS ABOVE'
'\x10WITH HAMZA ABOVE'
'\tWITH HOOK'
'\x16WITH HORIZONTAL STROKE'
'\rWITH INTEGRAL'
'\x16WITH JEEM INITIAL FORM'
'\nWITH MEEM '
'\x11WITH NOT EQUAL TO'
"'WITH OPEN ARM ENDING IN ARROW POINTING "
'\x0fWITH RAIN DROPS'
'\x0cWITH STROKE '
'\x12WITH STROKE SYMBOL'
'\x06WITH T'
'\x15WITH THREE DOTS ABOVE'
'\rWITH TWO DOTS'
'\rWITH UNDERBAR'
'\x16WITH VOICED SOUND MARK'
'\x13WITH YEH FINAL FORM'
'\x05WLINE'
'\x02WN'
'\x03WN '
'\x08WN ARROW'
'\x0cWN ARROWHEAD'
'\x06WN BOW'
'\x06WN BOX'
'\x07WN TACK'
'\rWN TACK BELOW'
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
' WO DOTS OVER ONE DOT PUNCTUATION'
'\x18WO DOTS VERTICALLY ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\x07WO FOR '
'\x0fWO HEADED ARROW'
'\x07WO MARK'
'\x06WO OF '
'\nWO SHORTS '
'\x11WO VERTICAL DOTS '
'\x07WO WAEN'
'\rWO-LINE STAFF'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x08WON SIGN'
'\x0cWORD DIVIDER'
'\x0eWORD SEPARATOR'
'\tWORDSPACE'
'\x04WTIE'
'\x02WU'
'\x05WU318'
'\x04WULU'
'\tWUNG DASH'
'\x04WYNN'
'\x01X'
'\x02X '
'\x0bX DRAWINGS '
'\nX NOTEHEAD'
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x08XCELLENT'
'\x0fXCLAMATION MARK'
'\x10XCLAMATION MARK '
'\x02XE'
'\x03XEH'
'\x04XEIA'
'\x0bXESTES SIGN'
'\x02XG'
'\tXHAUSTION'
'\x02XI'
'\x03XIA'
'\tXIMATELY '
'\x0cXIRON KLASMA'
'\x02XO'
'\x0eXO EKFONITIKON'
'\x06XO NEO'
'\x02XT'
'\x07XT PAGE'
'\x0fXTEEN FULL STOP'
'\x05XTILE'
'\x05XTRA-'
'\x03XWG'
'\x01Y'
'\x02Y '
'\x07Y MUCH '
'\x11Y ON BLACK SQUARE'
'\x0eY SMALL SQUARE'
'\tY-FOURTH '
'\x03Y00'
'\x02YA'
'\x03YA '
'\x03YAA'
'\x07YAH LI '
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x04YANG'
'\x07YANMAR '
'\x05YANNA'
'\tYANUKITTA'
'\x03YAT'
'\x10YATHOS BASE SIGN'
'\x07YAYANNA'
'\x08YBEYFILI'
'\x06YBOARD'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\tYEH ABOVE'
'\x0eYEH FINAL FORM'
'\x11YEH ISOLATED FORM'
'\tYEH WITH '
'\x06YELLOW'
'\x17YELORUSSIAN-UKRAINIAN I'
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\x05YEROK'
'\x06YFESIS'
'\x06YGISMA'
'\x02YI'
'\x08YIDDISH '
'\x08YIG MGO '
'\x0fYIG MGO MDUN MA'
'\x14YIG MGO PHUR SHAD MA'
'\x0fYIG MGO SGAB MA'
'\x15YIG MGO TSHEG SHAD MA'
'\x03YIN'
'\x06YIN-DO'
'\x04YIS '
'\x05YIZET'
'\x06YLISMA'
'\x08YLLABLE '
'\x06YMBOL '
'\x15YMPTOTICALLY EQUAL TO'
'\x02YN'
'\x0fYNCHRONOUS IDLE'
'\x03YNN'
'\x02YO'
'\x03YOD'
'\rYOD YOD PATAH'
'\x04YODH'
'\x03YOO'
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x05YPHEN'
'\rYPOGEGRAMMENI'
'\x08YPORROON'
'\x0cYPTOGRAMMIC '
'\x02YR'
'\tYRANISMA '
'\x14YRENAIC TWO DRACHMAS'
'\x0bYRIGHT SIGN'
'\x08YRILLIC '
'\nYRILLIC EN'
'\x02YT'
'\x02YU'
'\x04YUDH'
'\x04YUKU'
'\x05YURII'
'\x03YUT'
'\rYUUKALEAPINTU'
'\x03YWA'
'\x04YWAA'
'\x18YZANTINE MUSICAL SYMBOL '
'\x01Z'
'\tZ DIGRAPH'
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x0eZAH WITH MEEM '
'\x03ZAI'
'\x04ZAIN'
'\x0fZAIN FINAL FORM'
'\tZAL SASAK'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\tZENE RING'
'\x05ZENGE'
'\x03ZER'
'\x04ZERO'
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x04ZETA'
'\x02ZH'
'\nZH DIGRAPH'
'\x03ZHA'
'\x05ZHAIN'
'\x06ZHITSA'
'\rZHOU NUMERAL '
'\x02ZI'
'\tZIDA TENU'
'\x04ZIET'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\x0bZIGZAG LINE'
'\x05ZILDE'
'\tZIR SASAK'
'\x03ZJE'
'\x02ZO'
'\x03ZOO'
'\x07ZQAPHA '
'\x03ZUP'
'\x08ZWARAKAY'
'\x05ZYGOS'
)
_charnodes =[70758,
 -54050,
 -1,
 132371,
 28690,
 -1,
 197694,
 78399,
 -1,
 262727,
 136009,
 -1,
 327957,
 202049,
 -1,
 393238,
 282198,
 -1,
 -65529,
 347734,
 195071,
 -65528,
 409735,
 195070,
 -65527,
 472608,
 195069,
 -65526,
 535774,
 195068,
 -65525,
 599670,
 195067,
 -65524,
 660852,
 195066,
 -65523,
 726337,
 195065,
 -65522,
 791821,
 195064,
 -65521,
 857286,
 195063,
 -65520,
 922753,
 195062,
 -65519,
 988169,
 195061,
 -65518,
 1053628,
 195060,
 -65517,
 1119052,
 195059,
 -65516,
 1184423,
 195058,
 -65515,
 1249807,
 195057,
 -1,
 1315215,
 195056,
 1507367,
 344199,
 -1,
 -65512,
 1461846,
 195055,
 -65511,
 1523847,
 195054,
 -65510,
 1586720,
 195053,
 -65509,
 1649886,
 195052,
 -65508,
 1713782,
 195051,
 -65507,
 1774964,
 195050,
 -65506,
 1840449,
 195049,
 -65505,
 1905933,
 195048,
 -65504,
 1971398,
 195047,
 -65503,
 2036865,
 195046,
 -65502,
 2102281,
 195045,
 -65501,
 2167740,
 195044,
 -65500,
 2233164,
 195043,
 -65499,
 2298535,
 195042,
 -65498,
 2363919,
 195041,
 -1,
 2429327,
 195040,
 2621496,
 1455648,
 -1,
 -65495,
 2575958,
 195039,
 -65494,
 2637959,
 195038,
 -65493,
 2700832,
 195037,
 -65492,
 2763998,
 195036,
 -65491,
 2827894,
 195035,
 -65490,
 2889076,
 195034,
 -65489,
 2954561,
 195033,
 -65488,
 3020045,
 195032,
 -65487,
 3085510,
 195031,
 -65486,
 3150977,
 195030,
 -65485,
 3216393,
 195029,
 -65484,
 3281852,
 195028,
 -65483,
 3347276,
 195027,
 -65482,
 3412647,
 195026,
 -65481,
 3478031,
 195025,
 -1,
 3543439,
 195024,
 3735625,
 2567390,
 -1,
 -65478,
 3690070,
 195023,
 -65477,
 3752071,
 195022,
 -65476,
 3814944,
 195021,
 -65475,
 3878110,
 195020,
 -65474,
 3942006,
 195019,
 -65473,
 4003188,
 195018,
 -65472,
 4068673,
 195017,
 -65471,
 4134157,
 195016,
 -65470,
 4199622,
 195015,
 -65469,
 4265089,
 195014,
 -65468,
 4330505,
 195013,
 -65467,
 4395964,
 195012,
 -65466,
 4461388,
 195011,
 -65465,
 4526759,
 195010,
 -65464,
 4592143,
 195009,
 -1,
 4657551,
 195008,
 4849754,
 3679862,
 -1,
 -65461,
 4804182,
 195007,
 -65460,
 4866183,
 195006,
 -65459,
 4929056,
 195005,
 -65458,
 4992222,
 195004,
 -65457,
 5056118,
 195003,
 -65456,
 5117300,
 195002,
 -65455,
 5182785,
 195001,
 -65454,
 5248269,
 195000,
 -65453,
 5313734,
 194999,
 -65452,
 5379201,
 194998,
 -65451,
 5444617,
 194997,
 -65450,
 5510076,
 194996,
 -65449,
 5575500,
 194995,
 -65448,
 5640871,
 194994,
 -65447,
 5706255,
 194993,
 -1,
 5771663,
 194992,
 5963883,
 4789620,
 -1,
 -65444,
 5918294,
 194991,
 -65443,
 5980295,
 194990,
 -65442,
 6043168,
 194989,
 -65441,
 6106334,
 194988,
 -65440,
 6170230,
 194987,
 -65439,
 6231412,
 194986,
 -65438,
 6296897,
 194985,
 -65437,
 6362381,
 194984,
 -65436,
 6427846,
 194983,
 -65435,
 6493313,
 194982,
 -65434,
 6558729,
 194981,
 -65433,
 6624188,
 194980,
 -65432,
 6689612,
 194979,
 -65431,
 6754983,
 194978,
 -65430,
 6820367,
 194977,
 -1,
 6885775,
 194976,
 7078012,
 5903681,
 -1,
 -65427,
 7032406,
 194975,
 -65426,
 7094407,
 194974,
 -65425,
 7157280,
 194973,
 -65424,
 7220446,
 194972,
 -65423,
 7284342,
 194971,
 -65422,
 7345524,
 194970,
 -65421,
 7411009,
 194969,
 -65420,
 7476493,
 194968,
 -65419,
 7541958,
 194967,
 -65418,
 7607425,
 194966,
 -65417,
 7672841,
 194965,
 -65416,
 7738300,
 194964,
 -65415,
 7803724,
 194963,
 -65414,
 7869095,
 194962,
 -65413,
 7934479,
 194961,
 -1,
 7999887,
 194960,
 8192141,
 7017741,
 -1,
 -65410,
 8146518,
 194959,
 -65409,
 8208519,
 194958,
 -65408,
 8271392,
 194957,
 -65407,
 8334558,
 194956,
 -65406,
 8398454,
 194955,
 -65405,
 8459636,
 194954,
 -65404,
 8525121,
 194953,
 -65403,
 8590605,
 194952,
 -65402,
 8656070,
 194951,
 -65401,
 8721537,
 194950,
 -65400,
 8786953,
 194949,
 -65399,
 8852412,
 194948,
 -65398,
 8917836,
 194947,
 -65397,
 8983207,
 194946,
 -65396,
 9048591,
 194945,
 -1,
 9113999,
 194944,
 9306270,
 8131782,
 -1,
 -65393,
 9260630,
 194943,
 -65392,
 9322631,
 194942,
 -65391,
 9385504,
 194941,
 -65390,
 9448670,
 194940,
 -65389,
 9512566,
 194939,
 -65388,
 9573748,
 194938,
 -65387,
 9639233,
 194937,
 -65386,
 9704717,
 194936,
 -65385,
 9770182,
 194935,
 -65384,
 9835649,
 194934,
 -65383,
 9901065,
 194933,
 -65382,
 9966524,
 194932,
 -65381,
 10031948,
 194931,
 -65380,
 10097319,
 194930,
 -65379,
 10162703,
 194929,
 -1,
 10228111,
 194928,
 10420399,
 9245825,
 -1,
 -65376,
 10374742,
 194927,
 -65375,
 10436743,
 194926,
 -65374,
 10499616,
 194925,
 -65373,
 10562782,
 194924,
 -65372,
 10626678,
 194923,
 -65371,
 10687860,
 194922,
 -65370,
 10753345,
 194921,
 -65369,
 10818829,
 194920,
 -65368,
 10884294,
 194919,
 -65367,
 10949761,
 194918,
 -65366,
 11015177,
 194917,
 -65365,
 11080636,
 194916,
 -65364,
 11146060,
 194915,
 -65363,
 11211431,
 194914,
 -65362,
 11276815,
 194913,
 -1,
 11342223,
 194912,
 11534528,
 10359817,
 -1,
 -65359,
 11488854,
 194911,
 -65358,
 11550855,
 194910,
 -65357,
 11613728,
 194909,
 -65356,
 11676894,
 194908,
 -65355,
 11740790,
 194907,
 -65354,
 11801972,
 194906,
 -65353,
 11867457,
 194905,
 -65352,
 11932941,
 194904,
 -65351,
 11998406,
 194903,
 -65350,
 12063873,
 194902,
 -65349,
 12129289,
 194901,
 -65348,
 12194748,
 194900,
 -65347,
 12260172,
 194899,
 -65346,
 12325543,
 194898,
 -65345,
 12390927,
 194897,
 -1,
 12456335,
 194896,
 12648657,
 11473852,
 -1,
 -65342,
 12602966,
 194895,
 -65341,
 12664967,
 194894,
 -65340,
 12727840,
 194893,
 -65339,
 12791006,
 194892,
 -65338,
 12854902,
 194891,
 -65337,
 12916084,
 194890,
 -65336,
 12981569,
 194889,
 -65335,
 13047053,
 194888,
 -65334,
 13112518,
 194887,
 -65333,
 13177985,
 194886,
 -65332,
 13243401,
 194885,
 -65331,
 13308860,
 194884,
 -65330,
 13374284,
 194883,
 -65329,
 13439655,
 194882,
 -65328,
 13505039,
 194881,
 -1,
 13570447,
 194880,
 13762786,
 12587852,
 -1,
 -65325,
 13717078,
 194879,
 -65324,
 13779079,
 194878,
 -65323,
 13841952,
 194877,
 -65322,
 13905118,
 194876,
 -65321,
 13969014,
 194875,
 -65320,
 14030196,
 194874,
 -65319,
 14095681,
 194873,
 -65318,
 14161165,
 194872,
 -65317,
 14226630,
 194871,
 -65316,
 14292097,
 194870,
 -65315,
 14357513,
 194869,
 -65314,
 14422972,
 194868,
 -65313,
 14488396,
 194867,
 -65312,
 14553767,
 194866,
 -65311,
 14619151,
 194865,
 -1,
 14684559,
 194864,
 14876915,
 13701799,
 -1,
 -65308,
 14831190,
 194863,
 -65307,
 14893191,
 194862,
 -65306,
 14956064,
 194861,
 -65305,
 15019230,
 194860,
 -65304,
 15083126,
 194859,
 -65303,
 15144308,
 194858,
 -65302,
 15209793,
 194857,
 -65301,
 15275277,
 194856,
 -65300,
 15340742,
 194855,
 -65299,
 15406209,
 194854,
 -65298,
 15471625,
 194853,
 -65297,
 15537084,
 194852,
 -65296,
 15602508,
 194851,
 -65295,
 15667879,
 194850,
 -65294,
 15733263,
 194849,
 -1,
 15798671,
 194848,
 15991044,
 14815759,
 -1,
 -65291,
 15945302,
 194847,
 -65290,
 16007303,
 194846,
 -65289,
 16070176,
 194845,
 -65288,
 16133342,
 194844,
 -65287,
 16197238,
 194843,
 -65286,
 16258420,
 194842,
 -65285,
 16323905,
 194841,
 -65284,
 16389389,
 194840,
 -65283,
 16454854,
 194839,
 -65282,
 16520321,
 194838,
 -65281,
 16585737,
 194837,
 -65280,
 16651196,
 194836,
 -65279,
 16716620,
 194835,
 -65278,
 16781991,
 194834,
 -65277,
 16847375,
 194833,
 -1,
 16912783,
 194832,
 17170431,
 15929743,
 -1,
 -65274,
 17059414,
 194831,
 -65273,
 17121415,
 194830,
 -65272,
 17184288,
 194829,
 -65271,
 17247454,
 194828,
 -65270,
 17311350,
 194827,
 -65269,
 17372532,
 194826,
 -65268,
 17438017,
 194825,
 -65267,
 17503501,
 194824,
 -65266,
 17568966,
 194823,
 -65265,
 17634433,
 194822,
 -65264,
 17699849,
 194821,
 -65263,
 17765308,
 194820,
 -65262,
 17830732,
 194819,
 -65261,
 17896103,
 194818,
 -65260,
 17961487,
 194817,
 -1,
 18026895,
 194816,
 18219558,
 267533,
 -1,
 18284839,
 18173526,
 -1,
 -65256,
 18239062,
 194815,
 -65255,
 18301063,
 194814,
 -65254,
 18363936,
 194813,
 -65253,
 18427102,
 194812,
 -65252,
 18490998,
 194811,
 -65251,
 18552180,
 194810,
 -65250,
 18617665,
 194809,
 -65249,
 18683149,
 194808,
 -65248,
 18748614,
 194807,
 -65247,
 18814081,
 194806,
 -65246,
 18879497,
 194805,
 -65245,
 18944956,
 194804,
 -65244,
 19010380,
 194803,
 -65243,
 19075751,
 194802,
 -65242,
 19141135,
 194801,
 -1,
 19206543,
 194800,
 19398968,
 18235527,
 -1,
 -65239,
 19353174,
 194799,
 -65238,
 19415175,
 194798,
 -65237,
 19478048,
 194797,
 -65236,
 19541214,
 194796,
 -65235,
 19605110,
 194795,
 -65234,
 19666292,
 194794,
 -65233,
 19731777,
 194793,
 -65232,
 19797261,
 194792,
 -65231,
 19862726,
 194791,
 -65230,
 19928193,
 194790,
 -65229,
 19993609,
 194789,
 -65228,
 20059068,
 194788,
 -65227,
 20124492,
 194787,
 -65226,
 20189863,
 194786,
 -65225,
 20255247,
 194785,
 -1,
 20320655,
 194784,
 20513097,
 19346976,
 -1,
 -65222,
 20467286,
 194783,
 -65221,
 20529287,
 194782,
 -65220,
 20592160,
 194781,
 -65219,
 20655326,
 194780,
 -65218,
 20719222,
 194779,
 -65217,
 20780404,
 194778,
 -65216,
 20845889,
 194777,
 -65215,
 20911373,
 194776,
 -65214,
 20976838,
 194775,
 -65213,
 21042305,
 194774,
 -65212,
 21107721,
 194773,
 -65211,
 21173180,
 194772,
 -65210,
 21238604,
 194771,
 -65209,
 21303975,
 194770,
 -65208,
 21369359,
 194769,
 -1,
 21434767,
 194768,
 21627226,
 20458718,
 -1,
 -65205,
 21581398,
 194767,
 -65204,
 21643399,
 194766,
 -65203,
 21706272,
 194765,
 -65202,
 21769438,
 194764,
 -65201,
 21833334,
 194763,
 -65200,
 21894516,
 194762,
 -65199,
 21960001,
 194761,
 -65198,
 22025485,
 194760,
 -65197,
 22090950,
 194759,
 -65196,
 22156417,
 194758,
 -65195,
 22221833,
 194757,
 -65194,
 22287292,
 194756,
 -65193,
 22352716,
 194755,
 -65192,
 22418087,
 194754,
 -65191,
 22483471,
 194753,
 -1,
 22548879,
 194752,
 22741355,
 21571190,
 -1,
 -65188,
 22695510,
 194751,
 -65187,
 22757511,
 194750,
 -65186,
 22820384,
 194749,
 -65185,
 22883550,
 194748,
 -65184,
 22947446,
 194747,
 -65183,
 23008628,
 194746,
 -65182,
 23074113,
 194745,
 -65181,
 23139597,
 194744,
 -65180,
 23205062,
 194743,
 -65179,
 23270529,
 194742,
 -65178,
 23335945,
 194741,
 -65177,
 23401404,
 194740,
 -65176,
 23466828,
 194739,
 -65175,
 23532199,
 194738,
 -65174,
 23597583,
 194737,
 -1,
 23662991,
 194736,
 23855484,
 22680948,
 -1,
 -65171,
 23809622,
 194735,
 -65170,
 23871623,
 194734,
 -65169,
 23934496,
 194733,
 -65168,
 23997662,
 194732,
 -65167,
 24061558,
 194731,
 -65166,
 24122740,
 194730,
 -65165,
 24188225,
 194729,
 -65164,
 24253709,
 194728,
 -65163,
 24319174,
 194727,
 -65162,
 24384641,
 194726,
 -65161,
 24450057,
 194725,
 -65160,
 24515516,
 194724,
 -65159,
 24580940,
 194723,
 -65158,
 24646311,
 194722,
 -65157,
 24711695,
 194721,
 -1,
 24777103,
 194720,
 24969613,
 23795009,
 -1,
 -65154,
 24923734,
 194719,
 -65153,
 24985735,
 194718,
 -65152,
 25048608,
 194717,
 -65151,
 25111774,
 194716,
 -65150,
 25175670,
 194715,
 -65149,
 25236852,
 194714,
 -65148,
 25302337,
 194713,
 -65147,
 25367821,
 194712,
 -65146,
 25433286,
 194711,
 -65145,
 25498753,
 194710,
 -65144,
 25564169,
 194709,
 -65143,
 25629628,
 194708,
 -65142,
 25695052,
 194707,
 -65141,
 25760423,
 194706,
 -65140,
 25825807,
 194705,
 -1,
 25891215,
 194704,
 26083742,
 24909069,
 -1,
 -65137,
 26037846,
 194703,
 -65136,
 26099847,
 194702,
 -65135,
 26162720,
 194701,
 -65134,
 26225886,
 194700,
 -65133,
 26289782,
 194699,
 -65132,
 26350964,
 194698,
 -65131,
 26416449,
 194697,
 -65130,
 26481933,
 194696,
 -65129,
 26547398,
 194695,
 -65128,
 26612865,
 194694,
 -65127,
 26678281,
 194693,
 -65126,
 26743740,
 194692,
 -65125,
 26809164,
 194691,
 -65124,
 26874535,
 194690,
 -65123,
 26939919,
 194689,
 -1,
 27005327,
 194688,
 27197871,
 26023110,
 -1,
 -65120,
 27151958,
 194687,
 -65119,
 27213959,
 194686,
 -65118,
 27276832,
 194685,
 -65117,
 27339998,
 194684,
 -65116,
 27403894,
 194683,
 -65115,
 27465076,
 194682,
 -65114,
 27530561,
 194681,
 -65113,
 27596045,
 194680,
 -65112,
 27661510,
 194679,
 -65111,
 27726977,
 194678,
 -65110,
 27792393,
 194677,
 -65109,
 27857852,
 194676,
 -65108,
 27923276,
 194675,
 -65107,
 27988647,
 194674,
 -65106,
 28054031,
 194673,
 -1,
 28119439,
 194672,
 28312000,
 27137153,
 -1,
 -65103,
 28266070,
 194671,
 -65102,
 28328071,
 194670,
 -65101,
 28390944,
 194669,
 -65100,
 28454110,
 194668,
 -65099,
 28518006,
 194667,
 -65098,
 28579188,
 194666,
 -65097,
 28644673,
 194665,
 -65096,
 28710157,
 194664,
 -65095,
 28775622,
 194663,
 -65094,
 28841089,
 194662,
 -65093,
 28906505,
 194661,
 -65092,
 28971964,
 194660,
 -65091,
 29037388,
 194659,
 -65090,
 29102759,
 194658,
 -65089,
 29168143,
 194657,
 -1,
 29233551,
 194656,
 29426129,
 28251145,
 -1,
 -65086,
 29380182,
 194655,
 -65085,
 29442183,
 194654,
 -65084,
 29505056,
 194653,
 -65083,
 29568222,
 194652,
 -65082,
 29632118,
 194651,
 -65081,
 29693300,
 194650,
 -65080,
 29758785,
 194649,
 -65079,
 29824269,
 194648,
 -65078,
 29889734,
 194647,
 -65077,
 29955201,
 194646,
 -65076,
 30020617,
 194645,
 -65075,
 30086076,
 194644,
 -65074,
 30151500,
 194643,
 -65073,
 30216871,
 194642,
 -65072,
 30282255,
 194641,
 -1,
 30347663,
 194640,
 30540258,
 29365180,
 -1,
 -65069,
 30494294,
 194639,
 -65068,
 30556295,
 194638,
 -65067,
 30619168,
 194637,
 -65066,
 30682334,
 194636,
 -65065,
 30746230,
 194635,
 -65064,
 30807412,
 194634,
 -65063,
 30872897,
 194633,
 -65062,
 30938381,
 194632,
 -65061,
 31003846,
 194631,
 -65060,
 31069313,
 194630,
 -65059,
 31134729,
 194629,
 -65058,
 31200188,
 194628,
 -65057,
 31265612,
 194627,
 -65056,
 31330983,
 194626,
 -65055,
 31396367,
 194625,
 -1,
 31461775,
 194624,
 31654387,
 30479180,
 -1,
 -65052,
 31608406,
 194623,
 -65051,
 31670407,
 194622,
 -65050,
 31733280,
 194621,
 -65049,
 31796446,
 194620,
 -65048,
 31860342,
 194619,
 -65047,
 31921524,
 194618,
 -65046,
 31987009,
 194617,
 -65045,
 32052493,
 194616,
 -65044,
 32117958,
 194615,
 -65043,
 32183425,
 194614,
 -65042,
 32248841,
 194613,
 -65041,
 32314300,
 194612,
 -65040,
 32379724,
 194611,
 -65039,
 32445095,
 194610,
 -65038,
 32510479,
 194609,
 -1,
 32575887,
 194608,
 32768516,
 31593127,
 -1,
 -65035,
 32722518,
 194607,
 -65034,
 32784519,
 194606,
 -65033,
 32847392,
 194605,
 -65032,
 32910558,
 194604,
 -65031,
 32974454,
 194603,
 -65030,
 33035636,
 194602,
 -65029,
 33101121,
 194601,
 -65028,
 33166605,
 194600,
 -65027,
 33232070,
 194599,
 -65026,
 33297537,
 194598,
 -65025,
 33362953,
 194597,
 -65024,
 33428412,
 194596,
 -65023,
 33493836,
 194595,
 -65022,
 33559207,
 194594,
 -65021,
 33624591,
 194593,
 -1,
 33689999,
 194592,
 33882645,
 32707087,
 -1,
 -65018,
 33836630,
 194591,
 -65017,
 33898631,
 194590,
 -65016,
 33961504,
 194589,
 -65015,
 34024670,
 194588,
 -65014,
 34088566,
 194587,
 -65013,
 34149748,
 194586,
 -65012,
 34215233,
 194585,
 -65011,
 34280717,
 194584,
 -65010,
 34346182,
 194583,
 -65009,
 34411649,
 194582,
 -65008,
 34477065,
 194581,
 -65007,
 34542524,
 194580,
 -65006,
 34607948,
 194579,
 -65005,
 34673319,
 194578,
 -65004,
 34738703,
 194577,
 -1,
 34804111,
 194576,
 35061759,
 33821071,
 -1,
 -65001,
 34950742,
 194575,
 -65000,
 35012743,
 194574,
 -64999,
 35075616,
 194573,
 -64998,
 35138782,
 194572,
 -64997,
 35202678,
 194571,
 -64996,
 35263860,
 194570,
 -64995,
 35329345,
 194569,
 -64994,
 35394829,
 194568,
 -64993,
 35460294,
 194567,
 -64992,
 35525761,
 194566,
 -64991,
 35591177,
 194565,
 -64990,
 35656636,
 194564,
 -64989,
 35722060,
 194563,
 -64988,
 35787431,
 194562,
 -64987,
 35852815,
 194561,
 -1,
 35918223,
 194560,
 36175871,
 18158964,
 -1,
 36176440,
 36049295,
 -1,
 -64983,
 36130390,
 195087,
 -64982,
 36192391,
 195086,
 -64981,
 36255264,
 195085,
 -64980,
 36318430,
 195084,
 -64979,
 36382326,
 195083,
 -64978,
 36443508,
 195082,
 -64977,
 36508993,
 195081,
 -64976,
 36574477,
 195080,
 -64975,
 36639942,
 195079,
 -64974,
 36705409,
 195078,
 -64973,
 36770825,
 195077,
 -64972,
 36836284,
 195076,
 -64971,
 36901708,
 195075,
 -64970,
 36967079,
 195074,
 -64969,
 37032463,
 195073,
 -1,
 37097871,
 195072,
 37355519,
 36114959,
 -1,
 -64966,
 37238304,
 195101,
 -64965,
 37301470,
 195100,
 -64964,
 37365366,
 195099,
 -64963,
 37426548,
 195098,
 -64962,
 37492033,
 195097,
 -64961,
 37557517,
 195096,
 -64960,
 37622982,
 195095,
 -64959,
 37688449,
 195094,
 -64958,
 37753865,
 195093,
 -64957,
 37819324,
 195092,
 -64956,
 37884748,
 195091,
 -64955,
 37950119,
 195090,
 -64954,
 38015503,
 195089,
 -1,
 38080911,
 195088,
 38338559,
 216662,
 -1,
 38339417,
 38212929,
 -1,
 38404698,
 38293078,
 -1,
 -64949,
 38358614,
 63999,
 -64948,
 38420615,
 63998,
 -64947,
 38483488,
 63997,
 -64946,
 38546654,
 63996,
 -64945,
 38610550,
 63995,
 -64944,
 38671732,
 63994,
 -64943,
 38737217,
 63993,
 -64942,
 38802701,
 63992,
 -64941,
 38868166,
 63991,
 -64940,
 38933633,
 63990,
 -64939,
 38999049,
 63989,
 -64938,
 39064508,
 63988,
 -64937,
 39129932,
 63987,
 -64936,
 39195303,
 63986,
 -64935,
 39260687,
 63985,
 -1,
 39326095,
 63984,
 39518827,
 38355079,
 -1,
 -64932,
 39472726,
 63983,
 -64931,
 39534727,
 63982,
 -64930,
 39597600,
 63981,
 -64929,
 39660766,
 63980,
 -64928,
 39724662,
 63979,
 -64927,
 39785844,
 63978,
 -64926,
 39851329,
 63977,
 -64925,
 39916813,
 63976,
 -64924,
 39982278,
 63975,
 -64923,
 40047745,
 63974,
 -64922,
 40113161,
 63973,
 -64921,
 40178620,
 63972,
 -64920,
 40244044,
 63971,
 -64919,
 40309415,
 63970,
 -64918,
 40374799,
 63969,
 -1,
 40440207,
 63968,
 40632956,
 39466528,
 -1,
 -64915,
 40586838,
 63967,
 -64914,
 40648839,
 63966,
 -64913,
 40711712,
 63965,
 -64912,
 40774878,
 63964,
 -64911,
 40838774,
 63963,
 -64910,
 40899956,
 63962,
 -64909,
 40965441,
 63961,
 -64908,
 41030925,
 63960,
 -64907,
 41096390,
 63959,
 -64906,
 41161857,
 63958,
 -64905,
 41227273,
 63957,
 -64904,
 41292732,
 63956,
 -64903,
 41358156,
 63955,
 -64902,
 41423527,
 63954,
 -64901,
 41488911,
 63953,
 -1,
 41554319,
 63952,
 41747085,
 40578270,
 -1,
 -64898,
 41700950,
 63951,
 -64897,
 41762951,
 63950,
 -64896,
 41825824,
 63949,
 -64895,
 41888990,
 63948,
 -64894,
 41952886,
 63947,
 -64893,
 42014068,
 63946,
 -64892,
 42079553,
 63945,
 -64891,
 42145037,
 63944,
 -64890,
 42210502,
 63943,
 -64889,
 42275969,
 63942,
 -64888,
 42341385,
 63941,
 -64887,
 42406844,
 63940,
 -64886,
 42472268,
 63939,
 -64885,
 42537639,
 63938,
 -64884,
 42603023,
 63937,
 -1,
 42668431,
 63936,
 42861214,
 41690742,
 -1,
 -64881,
 42815062,
 63935,
 -64880,
 42877063,
 63934,
 -64879,
 42939936,
 63933,
 -64878,
 43003102,
 63932,
 -64877,
 43066998,
 63931,
 -64876,
 43128180,
 63930,
 -64875,
 43193665,
 63929,
 -64874,
 43259149,
 63928,
 -64873,
 43324614,
 63927,
 -64872,
 43390081,
 63926,
 -64871,
 43455497,
 63925,
 -64870,
 43520956,
 63924,
 -64869,
 43586380,
 63923,
 -64868,
 43651751,
 63922,
 -64867,
 43717135,
 63921,
 -1,
 43782543,
 63920,
 43975343,
 42800500,
 -1,
 -64864,
 43929174,
 63919,
 -64863,
 43991175,
 63918,
 -64862,
 44054048,
 63917,
 -64861,
 44117214,
 63916,
 -64860,
 44181110,
 63915,
 -64859,
 44242292,
 63914,
 -64858,
 44307777,
 63913,
 -64857,
 44373261,
 63912,
 -64856,
 44438726,
 63911,
 -64855,
 44504193,
 63910,
 -64854,
 44569609,
 63909,
 -64853,
 44635068,
 63908,
 -64852,
 44700492,
 63907,
 -64851,
 44765863,
 63906,
 -64850,
 44831247,
 63905,
 -1,
 44896655,
 63904,
 45089472,
 43914561,
 -1,
 -64847,
 45043286,
 63903,
 -64846,
 45105287,
 63902,
 -64845,
 45168160,
 63901,
 -64844,
 45231326,
 63900,
 -64843,
 45295222,
 63899,
 -64842,
 45356404,
 63898,
 -64841,
 45421889,
 63897,
 -64840,
 45487373,
 63896,
 -64839,
 45552838,
 63895,
 -64838,
 45618305,
 63894,
 -64837,
 45683721,
 63893,
 -64836,
 45749180,
 63892,
 -64835,
 45814604,
 63891,
 -64834,
 45879975,
 63890,
 -64833,
 45945359,
 63889,
 -1,
 46010767,
 63888,
 46203601,
 45028621,
 -1,
 -64830,
 46157398,
 63887,
 -64829,
 46219399,
 63886,
 -64828,
 46282272,
 63885,
 -64827,
 46345438,
 63884,
 -64826,
 46409334,
 63883,
 -64825,
 46470516,
 63882,
 -64824,
 46536001,
 63881,
 -64823,
 46601485,
 63880,
 -64822,
 46666950,
 63879,
 -64821,
 46732417,
 63878,
 -64820,
 46797833,
 63877,
 -64819,
 46863292,
 63876,
 -64818,
 46928716,
 63875,
 -64817,
 46994087,
 63874,
 -64816,
 47059471,
 63873,
 -1,
 47124879,
 63872,
 47317730,
 46142662,
 -1,
 -64813,
 47271510,
 63871,
 -64812,
 47333511,
 63870,
 -64811,
 47396384,
 63869,
 -64810,
 47459550,
 63868,
 -64809,
 47523446,
 63867,
 -64808,
 47584628,
 63866,
 -64807,
 47650113,
 63865,
 -64806,
 47715597,
 63864,
 -64805,
 47781062,
 63863,
 -64804,
 47846529,
 63862,
 -64803,
 47911945,
 63861,
 -64802,
 47977404,
 63860,
 -64801,
 48042828,
 63859,
 -64800,
 48108199,
 63858,
 -64799,
 48173583,
 63857,
 -1,
 48238991,
 63856,
 48431859,
 47256705,
 -1,
 -64796,
 48385622,
 63855,
 -64795,
 48447623,
 63854,
 -64794,
 48510496,
 63853,
 -64793,
 48573662,
 63852,
 -64792,
 48637558,
 63851,
 -64791,
 48698740,
 63850,
 -64790,
 48764225,
 63849,
 -64789,
 48829709,
 63848,
 -64788,
 48895174,
 63847,
 -64787,
 48960641,
 63846,
 -64786,
 49026057,
 63845,
 -64785,
 49091516,
 63844,
 -64784,
 49156940,
 63843,
 -64783,
 49222311,
 63842,
 -64782,
 49287695,
 63841,
 -1,
 49353103,
 63840,
 49545988,
 48370697,
 -1,
 -64779,
 49499734,
 63839,
 -64778,
 49561735,
 63838,
 -64777,
 49624608,
 63837,
 -64776,
 49687774,
 63836,
 -64775,
 49751670,
 63835,
 -64774,
 49812852,
 63834,
 -64773,
 49878337,
 63833,
 -64772,
 49943821,
 63832,
 -64771,
 50009286,
 63831,
 -64770,
 50074753,
 63830,
 -64769,
 50140169,
 63829,
 -64768,
 50205628,
 63828,
 -64767,
 50271052,
 63827,
 -64766,
 50336423,
 63826,
 -64765,
 50401807,
 63825,
 -1,
 50467215,
 63824,
 50660117,
 49484732,
 -1,
 -64762,
 50613846,
 63823,
 -64761,
 50675847,
 63822,
 -64760,
 50738720,
 63821,
 -64759,
 50801886,
 63820,
 -64758,
 50865782,
 63819,
 -64757,
 50926964,
 63818,
 -64756,
 50992449,
 63817,
 -64755,
 51057933,
 63816,
 -64754,
 51123398,
 63815,
 -64753,
 51188865,
 63814,
 -64752,
 51254281,
 63813,
 -64751,
 51319740,
 63812,
 -64750,
 51385164,
 63811,
 -64749,
 51450535,
 63810,
 -64748,
 51515919,
 63809,
 -1,
 51581327,
 63808,
 51774246,
 50598732,
 -1,
 -64745,
 51727958,
 63807,
 -64744,
 51789959,
 63806,
 -64743,
 51852832,
 63805,
 -64742,
 51915998,
 63804,
 -64741,
 51979894,
 63803,
 -64740,
 52041076,
 63802,
 -64739,
 52106561,
 63801,
 -64738,
 52172045,
 63800,
 -64737,
 52237510,
 63799,
 -64736,
 52302977,
 63798,
 -64735,
 52368393,
 63797,
 -64734,
 52433852,
 63796,
 -64733,
 52499276,
 63795,
 -64732,
 52564647,
 63794,
 -64731,
 52630031,
 63793,
 -1,
 52695439,
 63792,
 52888375,
 51712679,
 -1,
 -64728,
 52842070,
 63791,
 -64727,
 52904071,
 63790,
 -64726,
 52966944,
 63789,
 -64725,
 53030110,
 63788,
 -64724,
 53094006,
 63787,
 -64723,
 53155188,
 63786,
 -64722,
 53220673,
 63785,
 -64721,
 53286157,
 63784,
 -64720,
 53351622,
 63783,
 -64719,
 53417089,
 63782,
 -64718,
 53482505,
 63781,
 -64717,
 53547964,
 63780,
 -64716,
 53613388,
 63779,
 -64715,
 53678759,
 63778,
 -64714,
 53744143,
 63777,
 -1,
 53809551,
 63776,
 54002504,
 52826639,
 -1,
 -64711,
 53956182,
 63775,
 -64710,
 54018183,
 63774,
 -64709,
 54081056,
 63773,
 -64708,
 54144222,
 63772,
 -64707,
 54208118,
 63771,
 -64706,
 54269300,
 63770,
 -64705,
 54334785,
 63769,
 -64704,
 54400269,
 63768,
 -64703,
 54465734,
 63767,
 -64702,
 54531201,
 63766,
 -64701,
 54596617,
 63765,
 -64700,
 54662076,
 63764,
 -64699,
 54727500,
 63763,
 -64698,
 54792871,
 63762,
 -64697,
 54858255,
 63761,
 -1,
 54923663,
 63760,
 55181311,
 53940623,
 -1,
 -64694,
 55070294,
 63759,
 -64693,
 55132295,
 63758,
 -64692,
 55195168,
 63757,
 -64691,
 55258334,
 63756,
 -64690,
 55322230,
 63755,
 -64689,
 55383412,
 63754,
 -64688,
 55448897,
 63753,
 -64687,
 55514381,
 63752,
 -64686,
 55579846,
 63751,
 -64685,
 55645313,
 63750,
 -64684,
 55710729,
 63749,
 -64683,
 55776188,
 63748,
 -64682,
 55841612,
 63747,
 -64681,
 55906983,
 63746,
 -64680,
 55972367,
 63745,
 -1,
 56037775,
 63744,
 56295423,
 38278516,
 -1,
 56296299,
 56175838,
 -1,
 -64676,
 56249942,
 64207,
 -64675,
 56311943,
 64206,
 -64674,
 56374816,
 64205,
 -64673,
 56437982,
 64204,
 -64672,
 56501878,
 64203,
 -64671,
 56563060,
 64202,
 -64670,
 56628545,
 64201,
 -64669,
 56694029,
 64200,
 -64668,
 56759494,
 64199,
 -64667,
 56824961,
 64198,
 -64666,
 56890377,
 64197,
 -64665,
 56955836,
 64196,
 -64664,
 57021260,
 64195,
 -64663,
 57086631,
 64194,
 -64662,
 57152015,
 64193,
 -1,
 57217423,
 64192,
 57410428,
 56239734,
 -1,
 -64659,
 57364054,
 64191,
 -64658,
 57426055,
 64190,
 -64657,
 57488928,
 64189,
 -64656,
 57552094,
 64188,
 -64655,
 57615990,
 64187,
 -64654,
 57677172,
 64186,
 -64653,
 57742657,
 64185,
 -64652,
 57808141,
 64184,
 -64651,
 57873606,
 64183,
 -64650,
 57939073,
 64182,
 -64649,
 58004489,
 64181,
 -64648,
 58069948,
 64180,
 -64647,
 58135372,
 64179,
 -64646,
 58200743,
 64178,
 -64645,
 58266127,
 64177,
 -1,
 58331535,
 64176,
 58524557,
 57349492,
 -1,
 -64642,
 58478166,
 64175,
 -64641,
 58540167,
 64174,
 -64640,
 58603040,
 64173,
 -64639,
 58666206,
 64172,
 -64638,
 58730102,
 64171,
 -64637,
 58791284,
 64170,
 -64636,
 58856769,
 64169,
 -64635,
 58922253,
 64168,
 -64634,
 58987718,
 64167,
 -64633,
 59053185,
 64166,
 -64632,
 59118601,
 64165,
 -64631,
 59184060,
 64164,
 -64630,
 59249484,
 64163,
 -64629,
 59314855,
 64162,
 -64628,
 59380239,
 64161,
 -1,
 59445647,
 64160,
 59638686,
 58463553,
 -1,
 -64625,
 59592278,
 64159,
 -64624,
 59654279,
 64158,
 -64623,
 59717152,
 64157,
 -64622,
 59780318,
 64156,
 -64621,
 59844214,
 64155,
 -64620,
 59905396,
 64154,
 -64619,
 59970881,
 64153,
 -64618,
 60036365,
 64152,
 -64617,
 60101830,
 64151,
 -64616,
 60167297,
 64150,
 -64615,
 60232713,
 64149,
 -64614,
 60298172,
 64148,
 -64613,
 60363596,
 64147,
 -64612,
 60428967,
 64146,
 -64611,
 60494351,
 64145,
 -1,
 60559759,
 64144,
 60752815,
 59577613,
 -1,
 -64608,
 60706390,
 64143,
 -64607,
 60768391,
 64142,
 -64606,
 60831264,
 64141,
 -64605,
 60894430,
 64140,
 -64604,
 60958326,
 64139,
 -64603,
 61019508,
 64138,
 -64602,
 61084993,
 64137,
 -64601,
 61150477,
 64136,
 -64600,
 61215942,
 64135,
 -64599,
 61281409,
 64134,
 -64598,
 61346825,
 64133,
 -64597,
 61412284,
 64132,
 -64596,
 61477708,
 64131,
 -64595,
 61543079,
 64130,
 -64594,
 61608463,
 64129,
 -1,
 61673871,
 64128,
 61866944,
 60691654,
 -1,
 -64591,
 61820502,
 64127,
 -64590,
 61882503,
 64126,
 -64589,
 61945376,
 64125,
 -64588,
 62008542,
 64124,
 -64587,
 62072438,
 64123,
 -64586,
 62133620,
 64122,
 -64585,
 62199105,
 64121,
 -64584,
 62264589,
 64120,
 -64583,
 62330054,
 64119,
 -64582,
 62395521,
 64118,
 -64581,
 62460937,
 64117,
 -64580,
 62526396,
 64116,
 -64579,
 62591820,
 64115,
 -64578,
 62657191,
 64114,
 -64577,
 62722575,
 64113,
 -1,
 62787983,
 64112,
 62981073,
 61805577,
 -1,
 -64574,
 62934614,
 64095,
 -64573,
 62996615,
 64094,
 -64572,
 63059488,
 64093,
 -64571,
 63122654,
 64092,
 -64570,
 63186550,
 64091,
 -64569,
 63247732,
 64090,
 -64568,
 63313217,
 64089,
 -64567,
 63378701,
 64088,
 -64566,
 63444166,
 64087,
 -64565,
 63509633,
 64086,
 -64564,
 63575049,
 64085,
 -64563,
 63640508,
 64084,
 -64562,
 63705932,
 64083,
 -64561,
 63771303,
 64082,
 -64560,
 63836687,
 64081,
 -1,
 63902095,
 64080,
 64095202,
 62919612,
 -1,
 -64557,
 64048726,
 64079,
 -64556,
 64110727,
 64078,
 -64555,
 64173600,
 64077,
 -64554,
 64236766,
 64076,
 -64553,
 64300662,
 64075,
 -64552,
 64361844,
 64074,
 -64551,
 64427329,
 64073,
 -64550,
 64492813,
 64072,
 -64549,
 64558278,
 64071,
 -64548,
 64623745,
 64070,
 -64547,
 64689161,
 64069,
 -64546,
 64754620,
 64068,
 -64545,
 64820044,
 64067,
 -64544,
 64885415,
 64066,
 -64543,
 64950799,
 64065,
 -1,
 65016207,
 64064,
 65209331,
 64033612,
 -1,
 -64540,
 65162838,
 64063,
 -64539,
 65224839,
 64062,
 -64538,
 65287712,
 64061,
 -64537,
 65350878,
 64060,
 -64536,
 65414774,
 64059,
 -64535,
 65475956,
 64058,
 -64534,
 65541441,
 64057,
 -64533,
 65606925,
 64056,
 -64532,
 65672390,
 64055,
 -64531,
 65737857,
 64054,
 -64530,
 65803273,
 64053,
 -64529,
 65868732,
 64052,
 -64528,
 65934156,
 64051,
 -64527,
 65999527,
 64050,
 -64526,
 66064911,
 64049,
 -1,
 66130319,
 64048,
 66323460,
 65147407,
 -1,
 -64523,
 66276950,
 64031,
 -64522,
 66338951,
 64030,
 -64521,
 66401824,
 64029,
 -64520,
 66464990,
 64028,
 -64519,
 66528886,
 64027,
 -64518,
 66590068,
 64026,
 -64517,
 66655553,
 64025,
 -64516,
 66721037,
 64024,
 -64515,
 66786502,
 64023,
 -64514,
 66851969,
 64022,
 -64513,
 66917385,
 64021,
 -64512,
 66982844,
 64020,
 -64511,
 67048268,
 64019,
 -64510,
 67113639,
 64018,
 -64509,
 67179023,
 64017,
 -1,
 67244431,
 64016,
 67437589,
 66261391,
 -1,
 -64506,
 67391062,
 64015,
 -64505,
 67453063,
 64014,
 -64504,
 67515936,
 64013,
 -64503,
 67579102,
 64012,
 -64502,
 67642998,
 64011,
 -64501,
 67704180,
 64010,
 -64500,
 67769665,
 64009,
 -64499,
 67835149,
 64008,
 -64498,
 67900614,
 64007,
 -64497,
 67966081,
 64006,
 -64496,
 68031497,
 64005,
 -64495,
 68096956,
 64004,
 -64494,
 68162380,
 64003,
 -64493,
 68227751,
 64002,
 -64492,
 68293135,
 64001,
 -1,
 68358543,
 64000,
 68551716,
 67376257,
 -1,
 -64489,
 68498976,
 64109,
 -64488,
 68562142,
 64108,
 -64487,
 68626038,
 64107,
 -64486,
 68687220,
 64106,
 -64485,
 68752705,
 64105,
 -64484,
 68818189,
 64104,
 -64483,
 68883654,
 64103,
 -64482,
 68949121,
 64102,
 -64481,
 69014537,
 64101,
 -64480,
 69079996,
 64100,
 -64479,
 69145420,
 64099,
 -64478,
 69210791,
 64098,
 -64477,
 69276175,
 64097,
 -1,
 69341583,
 64096,
 69534771,
 68489895,
 -1,
 -64474,
 69482016,
 64045,
 -64473,
 69545182,
 64044,
 -64472,
 69609078,
 64043,
 -64471,
 69670260,
 64042,
 -64470,
 69735745,
 64041,
 -64469,
 69801229,
 64040,
 -64468,
 69866694,
 64039,
 -64467,
 69932161,
 64038,
 -64466,
 69997577,
 64037,
 -64465,
 70063036,
 64036,
 -64464,
 70128460,
 64035,
 -64463,
 70193831,
 64034,
 -64462,
 70259215,
 64033,
 -1,
 70324623,
 64032,
 70582271,
 69482016,
 -1,
 -64459,
 70456641,
 64217,
 -64458,
 70522125,
 64216,
 -64457,
 70587590,
 64215,
 -64456,
 70653057,
 64214,
 -64455,
 70718473,
 64213,
 -64454,
 70783932,
 64212,
 -64453,
 70849356,
 64211,
 -64452,
 70914727,
 64210,
 -64451,
 70980111,
 64209,
 -1,
 71045519,
 64208,
 71238894,
 174580,
 -1,
 71304293,
 71183582,
 -1,
 71369821,
 71242054,
 -1,
 71435335,
 71350047,
 -1,
 -64445,
 71410149,
 11976,
 -64444,
 71460417,
 11952,
 -64443,
 71523361,
 11977,
 -64442,
 71582503,
 11973,
 -1,
 71638095,
 12007,
 71828555,
 71418580,
 -1,
 -64439,
 71816786,
 12019,
 -64438,
 71866068,
 12014,
 -1,
 71900899,
 11993,
 72090703,
 71781974,
 -1,
 -64435,
 72070146,
 12010,
 -64434,
 72122296,
 11996,
 -1,
 72183049,
 12005,
 72352850,
 72053592,
 -1,
 -64431,
 72324627,
 11987,
 -1,
 72368402,
 11994,
 72549461,
 72307427,
 -1,
 -64428,
 72520730,
 11984,
 -1,
 72557725,
 11988,
 72746072,
 72499335,
 -1,
 -64425,
 72735107,
 12012,
 -1,
 72754284,
 12000,
 -64423,
 72736603,
 11995,
 -64422,
 72900534,
 12002,
 -64421,
 72957893,
 12016,
 -64420,
 73018941,
 11979,
 -1,
 73083318,
 12006,
 73270368,
 71332696,
 -1,
 -64417,
 73243330,
 11970,
 -1,
 73294928,
 11905,
 73466979,
 73228671,
 -1,
 -64414,
 73456531,
 11936,
 -1,
 73518633,
 11983,
 -64412,
 73441005,
 11943,
 -1,
 73621112,
 11931,
 73794692,
 71284511,
 -1,
 73860208,
 73752959,
 -1,
 73925743,
 73828239,
 -1,
 73991275,
 73915656,
 -1,
 -64406,
 73948026,
 12008,
 -1,
 73997216,
 11980,
 74187886,
 73947275,
 -1,
 -64403,
 74160479,
 11974,
 -1,
 74193748,
 11942,
 -1,
 74179856,
 12009,
 -1,
 73890811,
 11951,
 74515575,
 73810055,
 -1,
 74581110,
 74461811,
 -1,
 74646645,
 74564308,
 -1,
 -64396,
 74637711,
 11907,
 -1,
 74670166,
 11908,
 -1,
 74618303,
 11906,
 -1,
 74521076,
 11915,
 74974332,
 74483935,
 -1,
 75039867,
 74947760,
 -1,
 -64390,
 75025762,
 11925,
 -1,
 75077055,
 11924,
 -1,
 74979786,
 11922,
 75302015,
 74949594,
 -1,
 -64386,
 75287906,
 11949,
 -1,
 75339199,
 11948,
 75498626,
 75268382,
 -1,
 -64383,
 75484514,
 11917,
 -1,
 75535807,
 11916,
 -64381,
 75485651,
 11932,
 -1,
 75652088,
 11958,
 75826319,
 73760741,
 -1,
 75891852,
 75796879,
 -1,
 75957385,
 75878964,
 -1,
 -64376,
 75943266,
 11990,
 -1,
 75994559,
 11989,
 -64374,
 75941524,
 11935,
 -64373,
 76133925,
 11965,
 -1,
 76191021,
 11933,
 76414975,
 75841671,
 -1,
 -64370,
 76331539,
 11957,
 -1,
 76358764,
 11964,
 76547225,
 75769462,
 -1,
 76612756,
 76517775,
 -1,
 -64366,
 76604164,
 11910,
 -64365,
 76647171,
 12003,
 -1,
 76709608,
 11946,
 76874903,
 76592855,
 -1,
 -64362,
 76860770,
 11963,
 -1,
 76912063,
 11962,
 -64360,
 76840759,
 11992,
 -1,
 77012152,
 11950,
 77202596,
 76537096,
 -1,
 77268129,
 77141364,
 -1,
 77333662,
 77251958,
 -1,
 -64355,
 77319522,
 11938,
 -1,
 77370815,
 11937,
 77594623,
 77298686,
 -1,
 -64352,
 77516130,
 11982,
 -1,
 77567423,
 11981,
 77791231,
 77220610,
 -1,
 -64349,
 77712738,
 11972,
 -1,
 77764031,
 11971,
 77923502,
 77165400,
 -1,
 77989035,
 77864135,
 -1,
 78054569,
 77972180,
 -1,
 -64344,
 78045583,
 11919,
 -1,
 78078038,
 11920,
 -64342,
 78026175,
 11918,
 -1,
 78205392,
 11921,
 78446591,
 77960727,
 -1,
 -64339,
 78368098,
 11986,
 -1,
 78419391,
 11985,
 78578870,
 77885225,
 -1,
 78644405,
 78516550,
 -1,
 78709939,
 78627540,
 -1,
 -64334,
 78698066,
 12018,
 -1,
 78747348,
 12013,
 -64332,
 78662786,
 12011,
 -1,
 78856133,
 12015,
 -1,
 78583810,
 11945,
 79103166,
 78534795,
 -1,
 79168700,
 79053066,
 -1,
 79234235,
 79148572,
 -1,
 -64326,
 79220066,
 11927,
 -1,
 79271359,
 11926,
 -1,
 79181344,
 12001,
 -64323,
 79141215,
 11975,
 -1,
 79437159,
 11928,
 79627462,
 79052935,
 -1,
 79692996,
 79570031,
 -1,
 79758531,
 79676116,
 -1,
 -64318,
 79749519,
 11998,
 -1,
 79781974,
 11999,
 -1,
 79730111,
 11997,
 -64315,
 79684795,
 11947,
 -1,
 80010834,
 11960,
 80151755,
 79610580,
 -1,
 -64312,
 80139858,
 12017,
 -64311,
 80176319,
 11969,
 -64310,
 80240720,
 11923,
 -1,
 80287320,
 11911,
 80479441,
 80128340,
 -1,
 80544976,
 80418164,
 -1,
 -64306,
 80519145,
 11929,
 -64305,
 80576485,
 11959,
 -1,
 80635696,
 11991,
 -1,
 80496790,
 11904,
 80872663,
 80448424,
 -1,
 80938197,
 80855764,
 -1,
 -64300,
 80929167,
 11954,
 -1,
 80961622,
 11955,
 -64298,
 80909759,
 11953,
 -1,
 81088976,
 11956,
 81265886,
 80827107,
 -1,
 81331421,
 81242862,
 -1,
 81396956,
 81314516,
 -1,
 -64293,
 81387919,
 11967,
 -1,
 81420374,
 11968,
 -1,
 81368511,
 11966,
 -1,
 81289195,
 12004,
 81724643,
 81240041,
 -1,
 81790178,
 81667608,
 -1,
 -64287,
 81775970,
 11941,
 -1,
 81827263,
 11940,
 -1,
 81742362,
 11909,
 82052327,
 81671712,
 -1,
 -64283,
 82023205,
 11944,
 -64282,
 82079429,
 11914,
 -1,
 82133403,
 11934,
 82314474,
 82014851,
 -1,
 -64279,
 82300258,
 11913,
 -1,
 82351551,
 11912,
 82511085,
 82267734,
 -1,
 -64276,
 82482896,
 11978,
 -1,
 82537597,
 11939,
 -1,
 82482202,
 11961,
 82837503,
 71221511,
 -1,
 82838781,
 82729099,
 12752,
 82904313,
 82831134,
 12757,
 82969845,
 82896670,
 12741,
 83035380,
 82962206,
 12750,
 -1,
 82989795,
 12769,
 -1,
 83009513,
 12747,
 83231991,
 82959624,
 12749,
 -1,
 83186403,
 12744,
 -64264,
 83215060,
 12746,
 -1,
 83317475,
 12742,
 83494139,
 82878441,
 12743,
 -1,
 83484326,
 12748,
 -64260,
 83485674,
 12768,
 -1,
 83579619,
 12758,
 83756295,
 82818847,
 12753,
 83821825,
 83748638,
 12759,
 -64256,
 83814174,
 12766,
 -1,
 83877542,
 12745,
 84018436,
 83811592,
 12740,
 -64253,
 84010782,
 12760,
 -1,
 84038371,
 12767,
 -64251,
 84001492,
 12761,
 -64250,
 84189161,
 12755,
 -1,
 84234979,
 12762,
 84411659,
 83730409,
 12754,
 -64247,
 84403998,
 12764,
 -64246,
 84431587,
 12770,
 -1,
 84489760,
 12763,
 84673805,
 84394708,
 12736,
 -1,
 84642015,
 12765,
 -64242,
 84665215,
 12738,
 -64241,
 84795046,
 12737,
 -64240,
 84846404,
 12771,
 -64239,
 84904159,
 12751,
 -64238,
 84948512,
 12756,
 -1,
 85011619,
 12739,
 85199338,
 118346,
 -1,
 85264864,
 85166960,
 -1,
 85330255,
 85244976,
 -1,
 85394861,
 85283555,
 -1,
 85460340,
 85333364,
 73909,
 85525858,
 85398183,
 73911,
 85655551,
 85458944,
 -1,
 85656929,
 85575748,
 -1,
 85722404,
 85595508,
 -1,
 85787936,
 85657721,
 -1,
 -64226,
 85747053,
 73914,
 -64225,
 85809321,
 73913,
 -1,
 85866130,
 73912,
 86050082,
 85768723,
 73917,
 -1,
 85988075,
 73918,
 -64221,
 86018271,
 73916,
 -1,
 86124172,
 73915,
 86312237,
 85702431,
 -1,
 86377769,
 86268043,
 -1,
 86443304,
 86327431,
 73957,
 -1,
 86378844,
 73958,
 -1,
 86401829,
 73959,
 86639916,
 86316404,
 -1,
 -64213,
 86616404,
 73956,
 -1,
 86668120,
 73955,
 -1,
 86626677,
 73960,
 86902069,
 86266595,
 -1,
 86967602,
 86860159,
 73933,
 87033137,
 86905788,
 73934,
 -1,
 86968448,
 73935,
 -1,
 87009697,
 73936,
 87293951,
 86906228,
 -1,
 -64204,
 87206228,
 73932,
 -1,
 87263539,
 73931,
 87426364,
 86864008,
 -1,
 87491896,
 87384869,
 73946,
 -1,
 87427290,
 73947,
 87622971,
 87430516,
 -1,
 -64198,
 87604558,
 73945,
 -1,
 87650440,
 73944,
 -1,
 87609011,
 73948,
 87885123,
 87382155,
 -1,
 87950657,
 87823732,
 -1,
 88016192,
 87913304,
 73938,
 -1,
 87951569,
 73939,
 -1,
 87951597,
 73937,
 -64190,
 87936749,
 73941,
 -1,
 88170922,
 73940,
 88343880,
 87834759,
 -1,
 88409414,
 88312031,
 73929,
 -1,
 88345418,
 73930,
 88604671,
 88372056,
 73927,
 -1,
 88475857,
 73928,
 88671565,
 88290848,
 -1,
 88737099,
 88629631,
 73924,
 -1,
 88703011,
 73925,
 -64180,
 88723178,
 73926,
 -1,
 88806772,
 73923,
 88999251,
 88614518,
 -1,
 89064784,
 88987007,
 73921,
 -1,
 89000227,
 73922,
 89260031,
 89003380,
 -1,
 -64174,
 89172338,
 73920,
 -1,
 89208352,
 73919,
 89392470,
 88985162,
 73962,
 89522175,
 89339424,
 73963,
 -1,
 89393307,
 73964,
 89589080,
 89362599,
 73952,
 -1,
 89524151,
 73953,
 89720155,
 89554917,
 -1,
 -64166,
 89678207,
 73951,
 -1,
 89735390,
 73950,
 89916766,
 89678207,
 -1,
 -64163,
 89897498,
 73943,
 -1,
 89937268,
 73942,
 -64161,
 89899925,
 73961,
 -64160,
 90087502,
 73954,
 -1,
 90141613,
 73949,
 -1,
 85630272,
 73965,
 90375528,
 85493983,
 73974,
 90505215,
 90313383,
 73975,
 90570751,
 90374144,
 -1,
 -64154,
 90490221,
 73976,
 -64153,
 90545481,
 73977,
 -1,
 90584163,
 73978,
 90768747,
 90338136,
 73970,
 -64150,
 90709095,
 73972,
 -1,
 90768356,
 73971,
 90965357,
 90745172,
 73979,
 -1,
 90903372,
 73980,
 91096431,
 90912288,
 73968,
 -1,
 91031302,
 73969,
 91227505,
 91039400,
 73966,
 -1,
 91161315,
 73967,
 -64142,
 91208328,
 73981,
 -64141,
 91324389,
 73973,
 -1,
 91358245,
 73910,
 91555219,
 85418367,
 73984,
 91620735,
 91531604,
 -1,
 91686269,
 91558732,
 73994,
 91815935,
 91622142,
 -1,
 -64135,
 91725902,
 73999,
 -64134,
 91782942,
 73998,
 -64133,
 91841901,
 73997,
 -64132,
 91902837,
 73996,
 -1,
 91952551,
 73995,
 92209151,
 91624103,
 73992,
 -1,
 92079141,
 73993,
 92276105,
 91600671,
 -1,
 92341640,
 92231819,
 74001,
 92471295,
 92274688,
 -1,
 92472711,
 92390100,
 -1,
 92538246,
 92432065,
 -1,
 -64123,
 92521365,
 74004,
 -1,
 92546774,
 74003,
 -1,
 92489812,
 74005,
 -1,
 92419210,
 74002,
 -1,
 92281332,
 74000,
 92931469,
 92214204,
 73988,
 93061119,
 92864512,
 -1,
 -64116,
 92970323,
 73989,
 -1,
 93009021,
 73990,
 93193618,
 92864512,
 -1,
 93259153,
 93177924,
 -1,
 -64112,
 93245002,
 73986,
 -1,
 93274247,
 73985,
 -1,
 93205617,
 73987,
 -1,
 93141474,
 73991,
 93586859,
 91541066,
 74006,
 93652380,
 93524647,
 74008,
 93782015,
 93585408,
 -1,
 93783451,
 93702212,
 -1,
 93848985,
 93745370,
 74009,
 -1,
 93784923,
 74010,
 -64102,
 93829076,
 74012,
 -1,
 93950119,
 74011,
 -1,
 93739067,
 74013,
 94176673,
 93628756,
 74021,
 94242208,
 94162506,
 -1,
 -64097,
 94222867,
 74024,
 -1,
 94275807,
 74023,
 -1,
 94180550,
 74022,
 94504359,
 94123552,
 74014,
 94633983,
 94437376,
 -1,
 94635430,
 94554180,
 -1,
 -64091,
 94597914,
 74016,
 -1,
 94639538,
 74015,
 -1,
 94608732,
 74017,
 94897577,
 94470117,
 74019,
 -1,
 94833551,
 74020,
 -64086,
 94860120,
 74018,
 -1,
 94962418,
 74007,
 95223807,
 93538970,
 73982,
 -1,
 95095673,
 73983,
 95290934,
 85357400,
 -1,
 95356418,
 95229300,
 74167,
 95421948,
 95310596,
 -1,
 95487478,
 95364726,
 74168,
 95617023,
 95420416,
 -1,
 95618549,
 95537220,
 -1,
 95684027,
 95556980,
 74169,
 95749560,
 95619193,
 -1,
 -64074,
 95712434,
 74172,
 -64073,
 95769509,
 74171,
 -1,
 95827602,
 74170,
 -64071,
 95730241,
 74175,
 -64070,
 95979743,
 74174,
 -1,
 96039768,
 74173,
 96208322,
 95669834,
 74213,
 96273855,
 96143481,
 -1,
 -64066,
 96259684,
 74215,
 -1,
 96277876,
 74214,
 -64064,
 96254483,
 74218,
 -64063,
 96417312,
 74217,
 -1,
 96473824,
 74216,
 96667083,
 96188191,
 -1,
 96732618,
 96622731,
 -1,
 96798150,
 96718509,
 74207,
 -1,
 96733511,
 74208,
 96929225,
 96759178,
 -1,
 -64056,
 96912749,
 74206,
 -1,
 96969820,
 74205,
 -1,
 96878824,
 74204,
 -1,
 96719221,
 74209,
 97256914,
 96628872,
 -1,
 97322448,
 97242698,
 -1,
 97387983,
 97284952,
 74194,
 -1,
 97323191,
 74195,
 -1,
 97325900,
 74193,
 97648639,
 97280383,
 74191,
 -1,
 97552607,
 74192,
 97715671,
 97219416,
 -1,
 97781205,
 97701450,
 74198,
 -1,
 97743704,
 74199,
 -64042,
 97742089,
 74197,
 -1,
 97851546,
 74196,
 98043357,
 97673599,
 -1,
 98108892,
 98009061,
 74188,
 98238463,
 98044025,
 -1,
 -64037,
 98139931,
 74190,
 -1,
 98195625,
 74189,
 -1,
 98063732,
 74187,
 98436578,
 97997539,
 -1,
 98502112,
 98422778,
 74182,
 -1,
 98437293,
 74183,
 98697215,
 98440564,
 74180,
 -1,
 98609492,
 74181,
 98764263,
 98419412,
 -1,
 98829798,
 98702708,
 -1,
 -64027,
 98791580,
 74211,
 -1,
 98849507,
 74210,
 -1,
 98779333,
 74212,
 99091947,
 98729957,
 -1,
 99157482,
 99041415,
 74200,
 -1,
 99092644,
 74201,
 -1,
 99145375,
 74202,
 99354095,
 99047563,
 -1,
 99419630,
 99292532,
 74184,
 -1,
 99382104,
 74185,
 -1,
 99377614,
 74186,
 99616242,
 99296886,
 -1,
 -64015,
 99574143,
 74177,
 -1,
 99620822,
 74176,
 -64013,
 99584771,
 74203,
 -64012,
 99763953,
 74179,
 -1,
 99825413,
 74178,
 -1,
 95600493,
 74219,
 100139007,
 95463764,
 74220,
 100204543,
 100007936,
 -1,
 100206074,
 100124782,
 74221,
 -1,
 100141394,
 74222,
 100401151,
 100161595,
 74223,
 -1,
 100272007,
 74224,
 100468223,
 95387621,
 74228,
 100597759,
 100404089,
 74229,
 -1,
 100469036,
 74230,
 100664833,
 100430680,
 74226,
 -1,
 100600708,
 74227,
 -1,
 100622571,
 74225,
 100861490,
 95342154,
 74235,
 100927013,
 100799143,
 74237,
 101056511,
 100859904,
 -1,
 101058080,
 100975316,
 -1,
 101123615,
 101017281,
 -1,
 101189133,
 101085320,
 -1,
 101254668,
 101128150,
 -1,
 101320203,
 101192524,
 74246,
 -1,
 101255304,
 74247,
 -1,
 101257895,
 74245,
 -1,
 101212543,
 74248,
 101582352,
 101170140,
 -1,
 -63985,
 101544081,
 74255,
 -1,
 101582984,
 74254,
 101778963,
 101550303,
 -1,
 -63982,
 101764682,
 74253,
 -1,
 101793927,
 74252,
 101975574,
 101741485,
 -1,
 -63979,
 101929752,
 74250,
 -1,
 101976200,
 74249,
 102172184,
 101927567,
 74240,
 -1,
 102107851,
 74241,
 -63975,
 102157458,
 74256,
 -63974,
 102269749,
 74251,
 -63973,
 102327903,
 74244,
 -63972,
 102390948,
 74243,
 -63971,
 102454133,
 74242,
 -63970,
 102508246,
 74239,
 -1,
 102570484,
 74238,
 -1,
 101075028,
 74257,
 102827555,
 101037855,
 -1,
 -63966,
 102803526,
 74260,
 -1,
 102849608,
 74261,
 -63964,
 102799296,
 74259,
 -1,
 102970545,
 74258,
 103155243,
 100881225,
 74263,
 103284735,
 103088128,
 -1,
 103286314,
 103190927,
 -1,
 -63959,
 103274922,
 74264,
 -1,
 103327131,
 74265,
 -1,
 103267082,
 74266,
 103548462,
 103120869,
 74269,
 103677951,
 103483292,
 74270,
 -1,
 103547903,
 74271,
 -63953,
 103510872,
 74268,
 -63952,
 103700619,
 74267,
 -63951,
 103748428,
 74262,
 -1,
 103811872,
 74236,
 104071167,
 100819327,
 74231,
 -63948,
 103987731,
 74234,
 -63947,
 104039955,
 74233,
 -1,
 104100696,
 74232,
 104269483,
 95252616,
 -1,
 104334993,
 104207732,
 74071,
 104400507,
 104270590,
 -1,
 104465990,
 104354531,
 -1,
 104531519,
 104404340,
 74082,
 104597053,
 104507732,
 74085,
 -1,
 104532277,
 74086,
 -63938,
 104565043,
 74084,
 -1,
 104690520,
 74083,
 104859204,
 104489343,
 74087,
 104924739,
 104839702,
 -1,
 -63934,
 104899712,
 74089,
 -1,
 104936586,
 74090,
 -1,
 104901022,
 74088,
 105250815,
 104844874,
 74091,
 -1,
 105163180,
 74092,
 105317968,
 104445727,
 -1,
 105383500,
 105273483,
 -1,
 -63927,
 105369162,
 74115,
 -63926,
 105407269,
 74114,
 -63925,
 105463943,
 74113,
 -1,
 105518452,
 74112,
 105711182,
 105321844,
 74110,
 -1,
 105687380,
 74111,
 -63921,
 105697364,
 74117,
 -1,
 105800842,
 74116,
 105973336,
 105283557,
 -1,
 106038870,
 105922695,
 74100,
 106168319,
 105973881,
 -1,
 -63916,
 106087547,
 74103,
 -63915,
 106124657,
 74102,
 -1,
 106184769,
 74101,
 106430463,
 105996671,
 74104,
 -1,
 106301719,
 74105,
 106497629,
 105958986,
 74119,
 -63910,
 106478099,
 74123,
 -63909,
 106530873,
 74122,
 -63908,
 106575392,
 74121,
 -1,
 106631847,
 74120,
 106825315,
 106440310,
 -1,
 106890850,
 106763636,
 -1,
 -63904,
 106867028,
 74078,
 -63903,
 106918982,
 74077,
 -1,
 106968608,
 74076,
 -1,
 106848639,
 74079,
 107218535,
 106763636,
 74072,
 107284070,
 107165216,
 74073,
 -1,
 107219143,
 74074,
 -1,
 107264590,
 74075,
 107480683,
 107180168,
 -1,
 107546218,
 107438463,
 74096,
 -1,
 107492896,
 74097,
 -1,
 107485632,
 74095,
 107742830,
 107448543,
 -1,
 -63891,
 107729363,
 74107,
 -1,
 107757703,
 74106,
 107939441,
 107705176,
 -1,
 -63888,
 107925066,
 74099,
 -1,
 107962751,
 74098,
 108136052,
 107897215,
 -1,
 -63885,
 108101605,
 74094,
 -1,
 108156273,
 74093,
 108332663,
 108085383,
 -1,
 -63882,
 108313166,
 74081,
 -1,
 108376480,
 74080,
 -63880,
 108324862,
 74124,
 -63879,
 108512292,
 74118,
 -63878,
 108574314,
 74109,
 -1,
 108635014,
 74108,
 108791425,
 104347168,
 -1,
 108856958,
 108729353,
 74131,
 -1,
 108791654,
 74132,
 -63873,
 108794812,
 74130,
 -63872,
 108925772,
 74129,
 -1,
 108991143,
 74128,
 109184645,
 108772686,
 74140,
 109314047,
 109117440,
 -1,
 -63868,
 109223310,
 74142,
 -1,
 109278288,
 74141,
 109446793,
 109146968,
 74135,
 109576191,
 109379584,
 -1,
 -63864,
 109496395,
 74136,
 -1,
 109524132,
 74137,
 109708940,
 109412325,
 -1,
 -63861,
 109646780,
 74139,
 -1,
 109712039,
 74138,
 109905550,
 109670536,
 74133,
 -1,
 109841243,
 74134,
 110036624,
 109843111,
 74125,
 -1,
 109970175,
 74126,
 -1,
 109979254,
 74127,
 110233245,
 104320586,
 74154,
 110298772,
 110209364,
 74163,
 -1,
 110233233,
 74164,
 110429846,
 110261080,
 74160,
 -1,
 110363685,
 74161,
 110560920,
 110367676,
 74157,
 -1,
 110496783,
 74158,
 -63847,
 110541778,
 74165,
 -63846,
 110659807,
 74162,
 -63845,
 110695622,
 74159,
 -63844,
 110760780,
 74156,
 -1,
 110823197,
 74155,
 111019689,
 110190975,
 74144,
 111085219,
 110999327,
 -1,
 111150753,
 111044194,
 74152,
 -1,
 111085434,
 74153,
 -63838,
 111106187,
 74151,
 -1,
 111221236,
 74150,
 111412903,
 111020798,
 -1,
 111478438,
 111398474,
 74146,
 -1,
 111425056,
 74147,
 -1,
 111421142,
 74145,
 -63832,
 111380703,
 74149,
 -1,
 111621664,
 74148,
 -63830,
 111010538,
 74166,
 -1,
 111757967,
 74143,
 111937298,
 104249119,
 -1,
 112002787,
 111892619,
 -1,
 112068294,
 111960447,
 -1,
 112133820,
 112033765,
 74438,
 112263167,
 112069374,
 -1,
 112264882,
 112158061,
 74444,
 -1,
 112198693,
 74445,
 112395957,
 112207478,
 -1,
 -63820,
 112382320,
 74441,
 -1,
 112400884,
 74440,
 -63818,
 112375760,
 74449,
 -63817,
 112560059,
 74448,
 -63816,
 112623428,
 74447,
 -63815,
 112685865,
 74446,
 -63814,
 112743333,
 74443,
 -63813,
 112802283,
 74442,
 -1,
 112858484,
 74439,
 113051328,
 112109908,
 74451,
 113180671,
 112984064,
 -1,
 -63809,
 113100141,
 74452,
 -1,
 113155653,
 74453,
 113313476,
 112997920,
 74435,
 113442815,
 113249022,
 -1,
 -63805,
 113337951,
 74437,
 -1,
 113382772,
 74436,
 -63803,
 113296149,
 74454,
 -1,
 113544338,
 74450,
 113706708,
 112006516,
 74413,
 113772241,
 113644364,
 74414,
 113901567,
 113707774,
 -1,
 113903307,
 113823306,
 74421,
 -1,
 113838208,
 74422,
 -63796,
 113888456,
 74420,
 -63795,
 114015186,
 74419,
 -63794,
 114068227,
 74418,
 -63793,
 114120104,
 74417,
 -63792,
 114173654,
 74416,
 -1,
 114234740,
 74415,
 -63790,
 113748382,
 74425,
 -63789,
 114370209,
 74424,
 -1,
 114431105,
 74423,
 114624223,
 113655943,
 74426,
 114689752,
 114604563,
 74432,
 -63785,
 114652342,
 74434,
 -1,
 114692775,
 74433,
 114886365,
 114622464,
 -1,
 114951900,
 114859579,
 -1,
 -63781,
 114934581,
 74429,
 -1,
 114971424,
 74428,
 -1,
 114909451,
 74427,
 -63778,
 114854111,
 74431,
 -1,
 115168001,
 74430,
 115408895,
 114609738,
 74455,
 -63775,
 115289179,
 74458,
 -63774,
 115348135,
 74457,
 -1,
 115410771,
 74456,
 115607298,
 111940980,
 74387,
 115672830,
 115561187,
 74389,
 115802111,
 115605504,
 -1,
 115803899,
 115722308,
 -1,
 115869421,
 115789386,
 -1,
 -63767,
 115849747,
 74406,
 -63766,
 115910996,
 74405,
 -63765,
 115965925,
 74404,
 -63764,
 116008566,
 74403,
 -1,
 116069031,
 74402,
 116262640,
 115848991,
 -1,
 -63761,
 116219064,
 74400,
 -1,
 116267508,
 74399,
 116459251,
 116224136,
 -1,
 -63758,
 116446591,
 74395,
 -1,
 116464064,
 74394,
 116655861,
 116408385,
 74391,
 -1,
 116598390,
 74392,
 -63754,
 116638513,
 74401,
 -63753,
 116756647,
 74398,
 -63752,
 116819089,
 74397,
 -63751,
 116883272,
 74396,
 -63750,
 116938921,
 74393,
 -1,
 116987252,
 74390,
 -63748,
 115777074,
 74407,
 -63747,
 117149932,
 74388,
 -1,
 117200955,
 74408,
 117376768,
 115635032,
 74409,
 -1,
 117310773,
 74410,
 -63743,
 117352788,
 74412,
 -1,
 117476334,
 74411,
 117638923,
 115592778,
 74466,
 117704453,
 117614932,
 74473,
 -1,
 117642561,
 74474,
 117835527,
 117669861,
 74471,
 -1,
 117777236,
 74472,
 117966601,
 117782048,
 74468,
 -1,
 117904039,
 74469,
 -63734,
 117924136,
 74470,
 -1,
 118032401,
 74467,
 118292479,
 117596543,
 74459,
 118294287,
 118182627,
 74461,
 118423551,
 118231996,
 74462,
 -1,
 118294529,
 74463,
 -63728,
 118256612,
 74465,
 -63727,
 118452366,
 74464,
 -1,
 118490149,
 74460,
 118687606,
 111922762,
 74507,
 118753094,
 118663508,
 74536,
 118818611,
 118738506,
 74551,
 118884145,
 118754046,
 -1,
 118949660,
 118837987,
 -1,
 119015195,
 118887796,
 74556,
 -63719,
 118991188,
 74559,
 -63718,
 119048499,
 74558,
 -1,
 119108440,
 74557,
 -1,
 119000650,
 74560,
 119342880,
 118935114,
 -1,
 -63714,
 119322226,
 74574,
 -63713,
 119354912,
 74573,
 -1,
 119408813,
 74572,
 119605028,
 119300479,
 -1,
 -63710,
 119585299,
 74564,
 -63709,
 119635941,
 74563,
 -1,
 119690609,
 74562,
 119867175,
 119584543,
 -1,
 -63706,
 119825556,
 74570,
 -1,
 119888680,
 74569,
 120063785,
 119805300,
 74552,
 -1,
 120044312,
 74553,
 -63702,
 120048777,
 74571,
 -63701,
 120168526,
 74568,
 -63700,
 120227170,
 74567,
 -63699,
 120291144,
 74566,
 -63698,
 120353358,
 74565,
 -63697,
 120412329,
 74561,
 -63696,
 120471624,
 74555,
 -1,
 120530766,
 74554,
 120782847,
 118830731,
 74575,
 -1,
 120654746,
 74576,
 120850240,
 118756007,
 74539,
 120979455,
 120785662,
 -1,
 120981305,
 120901293,
 74545,
 121110527,
 120916089,
 -1,
 -63688,
 120990029,
 74547,
 -1,
 121054036,
 74546,
 121243454,
 120919412,
 -1,
 121308989,
 121178233,
 -1,
 -63684,
 121276731,
 74541,
 -1,
 121329833,
 74540,
 -1,
 121271128,
 74542,
 -63681,
 121213095,
 74544,
 -1,
 121526441,
 74543,
 121702210,
 120807807,
 74549,
 -1,
 121639756,
 74550,
 121833285,
 121634816,
 -1,
 -63676,
 121813770,
 74538,
 -1,
 121844991,
 74537,
 -1,
 121770940,
 74548,
 122095442,
 118699552,
 74515,
 122160977,
 122028032,
 -1,
 122226509,
 122144836,
 -1,
 122292043,
 122211949,
 74519,
 -1,
 122225701,
 74520,
 -63668,
 122258577,
 74518,
 -1,
 122365654,
 74517,
 122554191,
 122206986,
 74522,
 -1,
 122489632,
 74523,
 -63664,
 122516265,
 74516,
 -1,
 122640443,
 74521,
 -1,
 122146858,
 74524,
 122881885,
 122060773,
 74525,
 122947416,
 122817278,
 -1,
 -63659,
 122932810,
 74529,
 -63658,
 122993238,
 74528,
 -63657,
 123044650,
 74527,
 -1,
 123106378,
 74526,
 123275100,
 122933621,
 74531,
 123404287,
 123210494,
 -1,
 -63653,
 123314254,
 74533,
 -1,
 123367740,
 74532,
 -1,
 123218272,
 74530,
 123602790,
 122862099,
 74577,
 123668323,
 123538174,
 -1,
 123733857,
 123630345,
 74579,
 -1,
 123709780,
 74580,
 -63646,
 123716501,
 74581,
 -1,
 123802996,
 74578,
 -63644,
 123659012,
 74582,
 -63643,
 123982287,
 74584,
 -1,
 123998887,
 74583,
 124192621,
 123535360,
 -1,
 124258155,
 124165794,
 -1,
 -63639,
 124243581,
 74512,
 -63638,
 124305938,
 74511,
 -1,
 124362833,
 74510,
 -63636,
 124243608,
 74509,
 -1,
 124475447,
 74508,
 124651377,
 124184350,
 -1,
 124716912,
 124588876,
 74586,
 -1,
 124652395,
 74587,
 -1,
 124702282,
 74588,
 124913523,
 124618975,
 74534,
 -1,
 124847141,
 74535,
 -63628,
 124898489,
 74585,
 -63627,
 124986998,
 74514,
 -1,
 125047463,
 74513,
 125241285,
 118625652,
 73728,
 125306766,
 125183606,
 73738,
 125372295,
 125239296,
 -1,
 125437830,
 125356100,
 -1,
 125503357,
 125395327,
 -1,
 -63620,
 125470050,
 73745,
 -1,
 125523316,
 73744,
 125699968,
 125457156,
 -1,
 -63617,
 125667635,
 73742,
 -1,
 125727576,
 73741,
 -63615,
 125685357,
 73748,
 -63614,
 125876996,
 73747,
 -63613,
 125924426,
 73746,
 -63612,
 125982889,
 73743,
 -63611,
 126042188,
 73740,
 -1,
 126100352,
 73739,
 -1,
 125392955,
 73749,
 126418943,
 125309607,
 73750,
 126484479,
 126290686,
 -1,
 -63606,
 126403477,
 73755,
 -63605,
 126466646,
 73754,
 -63604,
 126518069,
 73753,
 -63603,
 126571381,
 73752,
 -1,
 126625541,
 73751,
 126814107,
 125268824,
 73760,
 126879641,
 126749438,
 -1,
 126945171,
 126840968,
 -1,
 -63598,
 126902655,
 73766,
 -1,
 126949337,
 73765,
 -63596,
 126932639,
 73768,
 -63595,
 127122135,
 73767,
 -63594,
 127162537,
 73764,
 -63593,
 127227304,
 73763,
 -63592,
 127285734,
 73762,
 -1,
 127343092,
 73761,
 -63590,
 126830763,
 73770,
 -1,
 127475006,
 73769,
 127666087,
 126793503,
 -1,
 127731622,
 127621259,
 73784,
 127797156,
 127664128,
 -1,
 127862690,
 127769873,
 -1,
 127928225,
 127835400,
 73788,
 -1,
 127861443,
 73789,
 -1,
 127913111,
 73787,
 -63581,
 127854593,
 73785,
 -1,
 128086204,
 73786,
 -63579,
 127750936,
 73791,
 -1,
 128193191,
 73790,
 -1,
 127670866,
 73783,
 128452528,
 127601406,
 -1,
 -63575,
 128432076,
 73736,
 -63574,
 128485499,
 73735,
 -63573,
 128545905,
 73734,
 -63572,
 128607597,
 73733,
 -63571,
 128669865,
 73732,
 -63570,
 128734069,
 73731,
 -63569,
 128788182,
 73730,
 -1,
 128849268,
 73729,
 129042360,
 128420063,
 73773,
 129107895,
 128974848,
 -1,
 129173429,
 129082471,
 -1,
 -63564,
 129154925,
 73777,
 -1,
 129210258,
 73776,
 -63562,
 129157005,
 73775,
 -1,
 129342720,
 73774,
 -1,
 129088215,
 73778,
 129566652,
 129018196,
 -1,
 129632187,
 129505238,
 73780,
 -1,
 129567609,
 73781,
 -1,
 129593528,
 73782,
 129828800,
 129527944,
 73757,
 129957887,
 129764094,
 -1,
 -63553,
 129874724,
 73759,
 -1,
 129911253,
 73758,
 130090946,
 129794629,
 73771,
 -1,
 130026383,
 73772,
 -63549,
 130065329,
 73779,
 -63548,
 130168352,
 73756,
 -1,
 130224807,
 73737,
 130418703,
 125208799,
 -1,
 130484195,
 130403914,
 74337,
 130549730,
 130451679,
 74339,
 130615255,
 130537368,
 74349,
 130744319,
 130547712,
 -1,
 130746325,
 130618907,
 -1,
 -63540,
 130731693,
 74359,
 -63539,
 130792564,
 74358,
 -63538,
 130845443,
 74357,
 -63537,
 130905005,
 74356,
 -63536,
 130969798,
 74355,
 -63535,
 131032433,
 74354,
 -63534,
 131094583,
 74353,
 -63533,
 131153988,
 74352,
 -63532,
 131213645,
 74351,
 -1,
 131277752,
 74350,
 131530751,
 130708063,
 74360,
 -1,
 131402738,
 74361,
 131661823,
 130547712,
 -1,
 131663838,
 131560572,
 -1,
 131729371,
 131643344,
 74342,
 -1,
 131663809,
 74343,
 -63524,
 131716767,
 74344,
 -63523,
 131826325,
 74341,
 -1,
 131879845,
 74340,
 132057056,
 131609830,
 74347,
 -1,
 131990855,
 74348,
 -63519,
 132040045,
 74345,
 -1,
 132161019,
 74346,
 -1,
 130486924,
 74338,
 132384766,
 130441599,
 74316,
 132450295,
 132352741,
 74322,
 132579327,
 132385534,
 -1,
 132581355,
 132496087,
 74330,
 132710399,
 132515968,
 -1,
 132712426,
 132626963,
 74332,
 -1,
 132647048,
 74333,
 -1,
 132644982,
 74331,
 132909039,
 132519284,
 -1,
 132974574,
 132889107,
 74324,
 -1,
 132909192,
 74325,
 -1,
 132942047,
 74323,
 133171186,
 132894282,
 -1,
 -63503,
 133151251,
 74335,
 -1,
 133173984,
 74334,
 133367797,
 133138655,
 -1,
 -63500,
 133353939,
 74329,
 -1,
 133382279,
 74328,
 -63498,
 133333824,
 74327,
 -1,
 133519415,
 74326,
 133695483,
 132415461,
 74319,
 133824511,
 133630784,
 -1,
 -63494,
 133736801,
 74321,
 -1,
 133794099,
 74320,
 -63492,
 133674956,
 74336,
 -63491,
 133894823,
 74318,
 -1,
 133958443,
 74317,
 134154249,
 132322676,
 74302,
 134219781,
 134107908,
 74304,
 134285316,
 134152192,
 -1,
 -63486,
 134269048,
 74306,
 -63485,
 134322125,
 74307,
 -1,
 134376141,
 74305,
 -1,
 134261076,
 74308,
 134613000,
 134184933,
 74310,
 -63481,
 134550183,
 74311,
 -1,
 134612525,
 74309,
 -1,
 134550183,
 74303,
 134938623,
 134103175,
 74312,
 135004159,
 134807552,
 -1,
 135006222,
 134924356,
 -1,
 -63475,
 134991866,
 74314,
 -1,
 135009652,
 74313,
 -1,
 134986506,
 74315,
 135268429,
 130364960,
 -1,
 135333940,
 135206260,
 73813,
 135399471,
 135287523,
 73814,
 135528447,
 135333152,
 -1,
 135530521,
 135418595,
 -1,
 135596054,
 135487871,
 73821,
 -1,
 135571870,
 73822,
 135727128,
 135533940,
 73819,
 -1,
 135661824,
 73820,
 -1,
 135712762,
 73823,
 135923742,
 135492440,
 -1,
 135989277,
 135908938,
 73829,
 -63460,
 135954405,
 73831,
 -1,
 135989515,
 73830,
 -1,
 135927156,
 73828,
 136251425,
 135908938,
 -1,
 -63456,
 136231443,
 73837,
 -1,
 136254198,
 73836,
 136448035,
 136211440,
 73825,
 -1,
 136382692,
 73826,
 136579110,
 136390262,
 -1,
 -63451,
 136536447,
 73818,
 -1,
 136583775,
 73817,
 136775721,
 136516980,
 -1,
 -63448,
 136741445,
 73816,
 -1,
 136775936,
 73815,
 -63446,
 136758165,
 73835,
 -63445,
 136952796,
 73834,
 -63444,
 137011437,
 73833,
 -63443,
 137071363,
 73832,
 -63442,
 137130202,
 73827,
 -1,
 137189545,
 73824,
 137365555,
 135375188,
 73839,
 137494527,
 137303412,
 -1,
 -63438,
 137368508,
 73841,
 -1,
 137433932,
 73840,
 -1,
 137330661,
 73838,
 137693253,
 135319114,
 73850,
 137758778,
 137660639,
 73860,
 137824313,
 137696076,
 73861,
 137953279,
 137757733,
 73862,
 -1,
 137823269,
 73863,
 -1,
 137761724,
 73864,
 138086461,
 137700982,
 73854,
 -63428,
 138023591,
 73856,
 -1,
 138087220,
 73855,
 138283073,
 138018816,
 -1,
 -63425,
 138263306,
 73853,
 -63424,
 138321188,
 73851,
 -1,
 138369083,
 73852,
 138545219,
 138236643,
 73857,
 -1,
 138530810,
 73858,
 -63420,
 138520990,
 73865,
 -1,
 138631307,
 73859,
 138870783,
 137650559,
 73842,
 138872905,
 138772453,
 73844,
 -63416,
 138810023,
 73846,
 -1,
 138873743,
 73845,
 139069515,
 138840287,
 73847,
 -1,
 139003125,
 73848,
 -63412,
 139049491,
 73849,
 -1,
 139142774,
 73843,
 139331714,
 135217287,
 73866,
 139397222,
 139323261,
 73889,
 139526143,
 139332350,
 -1,
 139528277,
 139424600,
 -1,
 139593811,
 139466100,
 73903,
 -1,
 139555712,
 73904,
 -63404,
 139578954,
 73906,
 -1,
 139682175,
 73905,
 139855961,
 139466100,
 73890,
 139921496,
 139790554,
 73891,
 -1,
 139856772,
 73892,
 -1,
 139888863,
 73893,
 140118109,
 139817096,
 -1,
 140183644,
 140059588,
 73900,
 -1,
 140118646,
 73901,
 -1,
 140168880,
 73902,
 140380256,
 140103242,
 -1,
 -63393,
 140326432,
 73908,
 -1,
 140382887,
 73907,
 140576866,
 140335273,
 73897,
 -1,
 140510245,
 73898,
 140707940,
 140525644,
 73895,
 -1,
 140641317,
 73896,
 -63387,
 140666225,
 73899,
 -1,
 140781270,
 73894,
 140970095,
 139364575,
 73879,
 141099007,
 140902400,
 -1,
 141101164,
 141019204,
 -1,
 141166699,
 141054832,
 73880,
 -1,
 141101771,
 73881,
 -1,
 141132571,
 73882,
 -63379,
 141082477,
 73885,
 -63378,
 141334440,
 73884,
 -1,
 141374551,
 73883,
 141559928,
 140907175,
 73869,
 141688831,
 141495038,
 -1,
 141690996,
 141604639,
 -1,
 -63373,
 141646632,
 73874,
 -1,
 141695476,
 73873,
 -63371,
 141676106,
 73875,
 -63370,
 141853841,
 73872,
 -63369,
 141906853,
 73871,
 -1,
 141956501,
 73870,
 142149755,
 141535572,
 -1,
 -63366,
 142108605,
 73887,
 -1,
 142165745,
 73886,
 142346366,
 142082048,
 -1,
 -63363,
 142329956,
 73867,
 -1,
 142384428,
 73868,
 -63361,
 142326350,
 73888,
 -63360,
 142504792,
 73878,
 -63359,
 142562724,
 73877,
 -1,
 142621163,
 73876,
 142805161,
 139313876,
 -1,
 142870681,
 142742900,
 74475,
 142936205,
 142824163,
 74483,
 143065087,
 142871294,
 -1,
 143067273,
 142981651,
 -1,
 -63352,
 143052362,
 74487,
 -1,
 143081607,
 74486,
 -63350,
 143052794,
 74489,
 -63349,
 143248530,
 74488,
 -63348,
 143284279,
 74485,
 -1,
 143337805,
 74484,
 143526035,
 142868480,
 -1,
 143591569,
 143509572,
 -1,
 -63344,
 143557777,
 74478,
 -1,
 143613065,
 74477,
 -63342,
 143546427,
 74479,
 -1,
 143729668,
 74476,
 143919255,
 143468150,
 74480,
 144048127,
 143851520,
 -1,
 -63338,
 143966061,
 74482,
 -1,
 144023132,
 74481,
 -63336,
 143894868,
 74491,
 -1,
 144142492,
 74490,
 144312481,
 142827903,
 74494,
 144378015,
 144288084,
 74497,
 144506879,
 144310272,
 -1,
 144509086,
 144416383,
 74499,
 -1,
 144442340,
 74500,
 -1,
 144492690,
 74498,
 -63328,
 144339800,
 74496,
 -1,
 144640715,
 74495,
 144836775,
 144297546,
 74501,
 144902308,
 144812372,
 74505,
 -1,
 144836659,
 74506,
 -63323,
 144867301,
 74504,
 -63322,
 144994440,
 74503,
 -1,
 145052411,
 74502,
 145293311,
 144785543,
 74492,
 -1,
 145163301,
 74493,
 145361101,
 142770149,
 -1,
 145426624,
 145346122,
 74284,
 145492155,
 145406483,
 74290,
 145557684,
 145424384,
 -1,
 145623217,
 145541188,
 -1,
 -63313,
 145614640,
 74293,
 -63312,
 145650458,
 74292,
 -1,
 145692020,
 74291,
 145885363,
 145595889,
 74294,
 -1,
 145820431,
 74295,
 -1,
 145831102,
 74296,
 146145279,
 145494860,
 74297,
 146210815,
 146014208,
 -1,
 146213050,
 146131012,
 -1,
 146278585,
 146150772,
 74298,
 -1,
 146213010,
 74299,
 -1,
 146225291,
 74300,
 -1,
 146167867,
 74301,
 146540733,
 145445603,
 74286,
 -1,
 146474021,
 74287,
 -63298,
 146517477,
 74289,
 -63297,
 146640615,
 74288,
 -1,
 146671534,
 74285,
 146868425,
 145364340,
 74272,
 146933955,
 146848275,
 74278,
 -1,
 146870951,
 74279,
 147065030,
 146866176,
 -1,
 -63291,
 147048594,
 74273,
 -1,
 147085371,
 74274,
 -63289,
 147040596,
 74277,
 -63288,
 147216523,
 74276,
 -1,
 147264167,
 74275,
 147458251,
 146825599,
 74282,
 -1,
 147425503,
 74283,
 147652607,
 147406983,
 74280,
 -1,
 147568415,
 74281,
 147720424,
 145318271,
 74047,
 147785941,
 147685349,
 74062,
 147851476,
 147718144,
 -1,
 -63279,
 147835026,
 74063,
 -63278,
 147898221,
 74066,
 -63277,
 147953588,
 74065,
 -1,
 147993752,
 74064,
 -1,
 147810096,
 74067,
 148244700,
 147739363,
 74053,
 148373503,
 148201855,
 74054,
 148439039,
 148242432,
 -1,
 -63271,
 148352505,
 74056,
 -63270,
 148413803,
 74057,
 -63269,
 148461627,
 74058,
 -1,
 148519258,
 74055,
 148703455,
 148206424,
 74059,
 -63266,
 148640423,
 74061,
 -1,
 148704074,
 74060,
 148900067,
 148650466,
 74050,
 149028863,
 148834119,
 -1,
 -63262,
 148946797,
 74052,
 -1,
 148974683,
 74051,
 -63260,
 148879891,
 74070,
 -63259,
 149137748,
 74069,
 -63258,
 149194975,
 74068,
 -63257,
 149235318,
 74049,
 -1,
 149291010,
 74048,
 149489922,
 147675275,
 -1,
 149555444,
 149447039,
 74029,
 149684223,
 149490430,
 -1,
 149686509,
 149562196,
 74030,
 -1,
 149623463,
 74031,
 -63250,
 149671498,
 74038,
 -63249,
 149797591,
 74037,
 -63248,
 149852327,
 74036,
 -63247,
 149910102,
 74035,
 -63246,
 149967644,
 74034,
 -63245,
 150026815,
 74033,
 -1,
 150087382,
 74032,
 150276349,
 149540426,
 74039,
 150341884,
 150218377,
 74040,
 150470655,
 150276862,
 -1,
 -63240,
 150392826,
 74045,
 -63239,
 150436780,
 74044,
 -63238,
 150499644,
 74043,
 -63237,
 150559097,
 74042,
 -1,
 150609214,
 74041,
 -1,
 150303658,
 74046,
 150929407,
 150214004,
 74025,
 150931713,
 150798336,
 -1,
 -63232,
 150914413,
 74026,
 -1,
 150951995,
 74027,
 -1,
 150893400,
 74028,
 151193885,
 149463017,
 -1,
 151259416,
 151150975,
 74367,
 151324945,
 151191552,
 -1,
 151390480,
 151308356,
 -1,
 151456008,
 151375434,
 74375,
 -1,
 151392935,
 74376,
 151587082,
 151413119,
 74373,
 -1,
 151529078,
 74374,
 151718157,
 151529078,
 -1,
 -63220,
 151703114,
 74371,
 -1,
 151740799,
 74370,
 151914767,
 151655796,
 74368,
 -1,
 151856758,
 74369,
 -1,
 151863431,
 74372,
 -1,
 151336179,
 74377,
 152240127,
 151301725,
 74378,
 152305663,
 152109056,
 -1,
 152307991,
 152225860,
 -1,
 -63211,
 152299312,
 74381,
 -63210,
 152358906,
 74380,
 -1,
 152400099,
 74379,
 -1,
 152279003,
 74382,
 152635676,
 151197044,
 74362,
 -63206,
 152608745,
 74365,
 -63205,
 152668383,
 74364,
 -1,
 152712736,
 74363,
 -1,
 152586895,
 74366,
 152963382,
 151135862,
 -1,
 153028903,
 152900980,
 73792,
 153094434,
 152990552,
 73796,
 -63199,
 153032851,
 73798,
 -1,
 153093872,
 73797,
 153291044,
 153069908,
 73799,
 -1,
 153228785,
 73800,
 -63195,
 153246332,
 73795,
 -63194,
 153375486,
 73794,
 -1,
 153433632,
 73793,
 153618737,
 153013834,
 73805,
 153684269,
 153550848,
 -1,
 153749804,
 153656603,
 -1,
 -63189,
 153735635,
 73807,
 -1,
 153753112,
 73806,
 -1,
 153695307,
 73808,
 154011951,
 153659732,
 73811,
 -1,
 153948839,
 73812,
 154206207,
 153976635,
 73809,
 -1,
 154076922,
 73810,
 154337279,
 153575807,
 73801,
 154402815,
 154209022,
 -1,
 -63180,
 154297713,
 73804,
 -63179,
 154358693,
 73803,
 -1,
 154408308,
 73802,
 154601802,
 152954654,
 -1,
 154667326,
 154558847,
 74595,
 154732858,
 154609270,
 74598,
 -1,
 154666211,
 74599,
 -63173,
 154724141,
 74601,
 -63172,
 154817251,
 74600,
 -63171,
 154866508,
 74597,
 -1,
 154929237,
 74596,
 155126083,
 154652234,
 74602,
 155191617,
 155063305,
 74603,
 -1,
 155126534,
 74604,
 -63166,
 155156453,
 74606,
 -1,
 155266139,
 74605,
 155453769,
 155063668,
 74589,
 155519303,
 155385856,
 -1,
 -63162,
 155501933,
 74590,
 -1,
 155565950,
 74591,
 -63160,
 155486392,
 74593,
 -1,
 155669219,
 74592,
 -1,
 155402503,
 74594,
 155975679,
 154577236,
 -1,
 155978061,
 155850100,
 74383,
 -1,
 155919990,
 74384,
 -63154,
 155962954,
 74386,
 -1,
 156066175,
 74385,
 156240346,
 85299353,
 -1,
 156305782,
 156192342,
 -1,
 156371301,
 156277748,
 -1,
 156436823,
 156358771,
 74812,
 156502358,
 156368896,
 -1,
 -63147,
 156444278,
 74815,
 -1,
 156505460,
 74814,
 -1,
 156439484,
 74813,
 156764507,
 156378742,
 -1,
 156830042,
 156704073,
 74834,
 -1,
 156765199,
 74835,
 -1,
 156816984,
 74808,
 157026654,
 156744360,
 -1,
 -63139,
 157011530,
 74800,
 -1,
 157029031,
 74790,
 157223265,
 156980363,
 -1,
 -63136,
 157208138,
 74785,
 -1,
 157225639,
 74776,
 157419875,
 157164372,
 74754,
 -1,
 157354699,
 74828,
 -63132,
 157404746,
 74767,
 -1,
 157497919,
 74761,
 157745151,
 156331643,
 -1,
 157747563,
 157660959,
 -1,
 157813098,
 157702776,
 -1,
 -63127,
 157797962,
 74801,
 -1,
 157815463,
 74791,
 -1,
 157773580,
 74844,
 158075247,
 157689462,
 -1,
 158140782,
 158014793,
 74836,
 -1,
 158075919,
 74837,
 -1,
 158127704,
 74809,
 158337394,
 158028939,
 -1,
 -63119,
 158322250,
 74786,
 -1,
 158339751,
 74777,
 158534004,
 158278484,
 74755,
 -1,
 158468811,
 74829,
 -63115,
 158518858,
 74768,
 -1,
 158612031,
 74762,
 158796186,
 156287700,
 -1,
 158861706,
 158752859,
 -1,
 158927229,
 158841512,
 -1,
 158992763,
 158912074,
 74798,
 -1,
 158927887,
 74799,
 159186943,
 158929575,
 74788,
 -1,
 159058959,
 74789,
 159254913,
 158869110,
 -1,
 159320448,
 159241816,
 74806,
 -1,
 159255567,
 74807,
 -1,
 159259977,
 74833,
 159517060,
 159242300,
 -1,
 -63101,
 159453995,
 74811,
 -1,
 159519383,
 74810,
 159713671,
 159470731,
 -1,
 -63098,
 159698506,
 74784,
 -1,
 159716007,
 74775,
 159910281,
 159654740,
 74753,
 -1,
 159845067,
 74827,
 -1,
 159857215,
 74760,
 160169983,
 158851474,
 -1,
 160172430,
 160089825,
 -1,
 -63091,
 160159771,
 74846,
 -1,
 160184895,
 74843,
 160369041,
 160152232,
 -1,
 -63088,
 160353866,
 74797,
 -1,
 160371367,
 74787,
 160565652,
 160322699,
 -1,
 -63085,
 160550474,
 74783,
 -1,
 160567975,
 74774,
 160762263,
 160507510,
 -1,
 -63082,
 160749144,
 74805,
 -1,
 160767305,
 74832,
 160958873,
 160703316,
 74752,
 -1,
 160893643,
 74826,
 -1,
 160909972,
 74841,
 161155505,
 158775071,
 -1,
 161221030,
 161107079,
 -1,
 161286561,
 161208417,
 -1,
 161352096,
 161218560,
 -1,
 -63073,
 161293942,
 74819,
 -1,
 161355124,
 74818,
 -1,
 161289036,
 74817,
 -63070,
 161271370,
 74770,
 -63069,
 161594029,
 74793,
 -63068,
 161633424,
 74779,
 -63067,
 161692223,
 74764,
 -1,
 161751892,
 74757,
 161941934,
 161181425,
 -1,
 162007465,
 161882964,
 74756,
 -1,
 161942219,
 74830,
 -63062,
 161994794,
 74816,
 -63061,
 162123338,
 74769,
 -63060,
 162183853,
 74792,
 -63059,
 162223248,
 74778,
 -1,
 162282047,
 74763,
 162529279,
 161897089,
 -1,
 -63056,
 162432354,
 74803,
 -1,
 162478655,
 74802,
 162662852,
 161124751,
 -1,
 162728385,
 162630406,
 -1,
 162793910,
 162711237,
 -1,
 -63051,
 162781211,
 74845,
 -1,
 162806335,
 74842,
 162990521,
 162747531,
 -1,
 -63048,
 162975306,
 74782,
 -1,
 162992807,
 74773,
 163187132,
 162939015,
 -1,
 -63045,
 163166939,
 74840,
 -1,
 163210530,
 74847,
 163383743,
 163128950,
 -1,
 -63042,
 163370584,
 74804,
 -1,
 163388745,
 74831,
 -63040,
 163363530,
 74796,
 -1,
 163555421,
 74848,
 163774463,
 162690621,
 -1,
 -63037,
 163691837,
 74849,
 -1,
 163752021,
 74850,
 163908050,
 162630771,
 -1,
 163973583,
 163875590,
 -1,
 164039114,
 163960909,
 74822,
 -63032,
 163976124,
 74824,
 -63031,
 164041548,
 74823,
 -1,
 164102146,
 74825,
 -63029,
 164023882,
 74772,
 -63028,
 164281005,
 74795,
 -63027,
 164320400,
 74781,
 -63026,
 164379199,
 74766,
 -1,
 164438868,
 74759,
 164691967,
 163927432,
 -1,
 -63023,
 164595042,
 74838,
 -1,
 164645494,
 74839,
 164888575,
 163857725,
 -1,
 164891093,
 164812934,
 74820,
 -1,
 164827980,
 74821,
 -63018,
 164875850,
 74771,
 -63017,
 165001901,
 74794,
 -63016,
 165041296,
 74780,
 -63015,
 165100095,
 74765,
 -1,
 165159764,
 74758,
 165412863,
 156215071,
 -1,
 165415390,
 165296336,
 -1,
 -63011,
 165399356,
 74867,
 -1,
 165425643,
 74866,
 -63009,
 165403320,
 74865,
 -1,
 165581854,
 74864,
 165743080,
 85240148,
 -1,
 165808614,
 165707707,
 -1,
 165874149,
 165772525,
 -1,
 -63004,
 165844982,
 8910,
 -1,
 165879143,
 8911,
 -1,
 165817198,
 9130,
 -63001,
 165796150,
 10081,
 -1,
 166112459,
 164,
 -62999,
 165715994,
 9982,
 -1,
 166209562,
 8731,
 166399312,
 85136756,
 -1,
 166464784,
 166365407,
 -1,
 166530317,
 166402074,
 -1,
 166595282,
 166472926,
 5281,
 166660804,
 166532468,
 5264,
 166726338,
 166639014,
 -1,
 166791707,
 166707924,
 -1,
 166857215,
 166773460,
 -1,
 166922745,
 166835999,
 -1,
 166988277,
 166871175,
 5737,
 -1,
 166936711,
 5738,
 -62986,
 166973002,
 5735,
 -62985,
 167088527,
 5736,
 -62984,
 167141759,
 5739,
 -1,
 167187828,
 5740,
 167381499,
 166871175,
 5604,
 -1,
 167329927,
 5605,
 -62980,
 167366218,
 5602,
 -62979,
 167481743,
 5603,
 -62978,
 167534975,
 5606,
 -1,
 167581044,
 5607,
 167774733,
 166818648,
 -1,
 167840263,
 167729291,
 -1,
 167905795,
 167788679,
 5686,
 -1,
 167854215,
 5687,
 -62972,
 167890506,
 5684,
 -62971,
 168006031,
 5685,
 -62970,
 168059263,
 5688,
 -1,
 168105332,
 5689,
 168299017,
 167788679,
 5692,
 -1,
 168247431,
 5693,
 -62966,
 168283722,
 5690,
 -62965,
 168399247,
 5691,
 -62964,
 168452479,
 5694,
 -1,
 168498548,
 5695,
 168692244,
 167753503,
 -1,
 168757776,
 168640647,
 5725,
 -1,
 168706183,
 5726,
 -62959,
 168742474,
 5723,
 -62958,
 168857999,
 5724,
 -62957,
 168911231,
 5727,
 -1,
 168957300,
 5728,
 169213951,
 168646795,
 -1,
 169216535,
 169099399,
 5598,
 -1,
 169164935,
 5599,
 -62952,
 169201226,
 5596,
 -62951,
 169316751,
 5597,
 -62950,
 169369983,
 5600,
 -1,
 169416052,
 5601,
 169609776,
 166737440,
 -1,
 169675299,
 169600798,
 -1,
 169740831,
 169623687,
 5706,
 -1,
 169689223,
 5707,
 -62944,
 169725514,
 5704,
 -62943,
 169841039,
 5705,
 -62942,
 169894271,
 5708,
 -1,
 169940340,
 5709,
 170134058,
 169636696,
 -1,
 170199590,
 170082439,
 5674,
 -1,
 170147975,
 5675,
 -62937,
 170184266,
 5672,
 -62936,
 170299791,
 5673,
 -62935,
 170353023,
 5676,
 -1,
 170399092,
 5677,
 170592815,
 170082439,
 -1,
 170658350,
 170559711,
 -1,
 -62931,
 170640323,
 6389,
 -1,
 170672276,
 6382,
 -1,
 170606727,
 5203,
 -1,
 170549631,
 5204,
 170986050,
 169562851,
 -1,
 171051576,
 170940555,
 -1,
 171117108,
 170999943,
 5574,
 -1,
 171065479,
 5575,
 -62923,
 171101770,
 5572,
 -62922,
 171217295,
 5573,
 -62921,
 171270527,
 5576,
 -1,
 171316596,
 5577,
 171510331,
 171040008,
 -1,
 -62918,
 171494986,
 6381,
 -1,
 171513204,
 6384,
 171706941,
 171458695,
 5617,
 -1,
 171655303,
 5618,
 171838015,
 171644276,
 5620,
 -1,
 171775348,
 6383,
 -62912,
 171822666,
 5615,
 -62911,
 171938191,
 5616,
 -1,
 171991423,
 5619,
 172165712,
 170964767,
 -1,
 172231242,
 172120203,
 5722,
 172296774,
 172179591,
 5718,
 -1,
 172245127,
 5719,
 -62905,
 172281418,
 5716,
 -62904,
 172396943,
 5717,
 -62903,
 172450175,
 5720,
 -1,
 172496244,
 5721,
 172689996,
 172179591,
 5712,
 -1,
 172638343,
 5713,
 -62899,
 172674634,
 5710,
 -62898,
 172790159,
 5711,
 -62897,
 172843391,
 5714,
 -1,
 172889460,
 5715,
 173083231,
 172126344,
 -1,
 173148760,
 173043848,
 5633,
 173214292,
 173097095,
 5629,
 -1,
 173162631,
 5630,
 -62891,
 173198922,
 5627,
 -62890,
 173314447,
 5628,
 -62889,
 173367679,
 5631,
 -1,
 173413748,
 5632,
 173670399,
 173103243,
 -1,
 173673051,
 173555847,
 5623,
 -1,
 173621383,
 5624,
 -62884,
 173657674,
 5621,
 -62883,
 173773199,
 5622,
 -62882,
 173826431,
 5625,
 -1,
 173872500,
 5626,
 174066286,
 173043497,
 -1,
 174131815,
 174026537,
 -1,
 174197347,
 174080135,
 5662,
 -1,
 174145671,
 5663,
 -62876,
 174181962,
 5660,
 -62875,
 174297487,
 5661,
 -62874,
 174350719,
 5664,
 -1,
 174396788,
 5665,
 174590569,
 174080135,
 5655,
 -1,
 174538887,
 5656,
 -62870,
 174578992,
 6386,
 -62869,
 174706250,
 5652,
 -62868,
 174756239,
 5654,
 -62867,
 174809471,
 5657,
 -1,
 174855540,
 5659,
 175049340,
 174027608,
 -1,
 175114870,
 175003787,
 -1,
 175180402,
 175063175,
 5680,
 -1,
 175128711,
 5681,
 -62861,
 175165002,
 5678,
 -62860,
 175280527,
 5679,
 -62859,
 175333759,
 5682,
 -1,
 175379828,
 5683,
 175573624,
 175063175,
 5668,
 -1,
 175521927,
 5669,
 -62855,
 175558218,
 5666,
 -62854,
 175673743,
 5667,
 -62853,
 175726975,
 5670,
 -1,
 175773044,
 5671,
 175966854,
 175003787,
 5195,
 176032388,
 175955208,
 -1,
 176097920,
 175980679,
 5592,
 -1,
 176046215,
 5593,
 -62847,
 176082506,
 5590,
 -62846,
 176198031,
 5591,
 -62845,
 176251263,
 5594,
 -1,
 176297332,
 5595,
 -62843,
 175989119,
 5175,
 -1,
 176440103,
 5174,
 176622221,
 175957790,
 5702,
 176687753,
 176570503,
 5698,
 -1,
 176636039,
 5699,
 -62838,
 176672330,
 5696,
 -62837,
 176787855,
 5697,
 -62836,
 176841087,
 5700,
 -1,
 176887156,
 5701,
 177080980,
 176594921,
 5614,
 177146512,
 177029255,
 5610,
 -1,
 177094791,
 5611,
 -62831,
 177131082,
 5608,
 -62830,
 177246607,
 5609,
 -62829,
 177299839,
 5612,
 -1,
 177345908,
 5613,
 177539740,
 177047775,
 -1,
 177605271,
 177488007,
 5636,
 -1,
 177553543,
 5637,
 -62824,
 177589834,
 5634,
 -62823,
 177705359,
 5635,
 -62822,
 177758591,
 5638,
 -62821,
 177820387,
 5329,
 -1,
 177870196,
 5639,
 178064035,
 177529838,
 -1,
 178129567,
 178012295,
 5648,
 -1,
 178077831,
 5649,
 -62816,
 178114122,
 5646,
 -62815,
 178229647,
 5647,
 -62814,
 178282879,
 5650,
 -1,
 178328948,
 5651,
 178522794,
 178052360,
 -1,
 178588326,
 178471047,
 5586,
 -1,
 178536583,
 5587,
 -62809,
 178572874,
 5584,
 -62808,
 178688399,
 5585,
 -62807,
 178741631,
 5588,
 -1,
 178787700,
 5589,
 178981553,
 178497876,
 -1,
 179047085,
 178929799,
 5580,
 -1,
 178995335,
 5581,
 -62802,
 179031626,
 5578,
 -62801,
 179147151,
 5579,
 -62800,
 179200383,
 5582,
 -1,
 179246452,
 5583,
 179440312,
 178946021,
 -1,
 179505844,
 179388551,
 5642,
 -1,
 179454087,
 5643,
 -62795,
 179490378,
 5640,
 -62794,
 179605903,
 5641,
 -62793,
 179659135,
 5644,
 -1,
 179705204,
 5645,
 179899071,
 179384098,
 -1,
 179964603,
 179847303,
 5731,
 -1,
 179912839,
 5732,
 -62788,
 179949130,
 5729,
 -62787,
 180064655,
 5730,
 -62786,
 180117887,
 5733,
 -1,
 180163956,
 5734,
 180357825,
 179855743,
 5129,
 -1,
 180325677,
 5703,
 -1,
 180306727,
 5128,
 180617215,
 166663540,
 5265,
 -1,
 180511103,
 5258,
 180685516,
 166649096,
 -1,
 180751047,
 180654479,
 5272,
 -1,
 180720015,
 5274,
 180882121,
 180707711,
 5268,
 -1,
 180838783,
 5270,
 181013195,
 180819316,
 5276,
 -1,
 180950388,
 5278,
 -1,
 180961415,
 5266,
 181209806,
 180654479,
 5261,
 -1,
 181178767,
 5262,
 181340880,
 181166463,
 5259,
 -1,
 181297535,
 5260,
 -62767,
 181296274,
 5741,
 -1,
 181420167,
 5257,
 181603156,
 166583560,
 -1,
 181668670,
 181551239,
 5132,
 181796863,
 181649419,
 -1,
 181799741,
 181669680,
 -1,
 181865191,
 181778207,
 -1,
 181930719,
 181853448,
 -1,
 181996250,
 181899663,
 5373,
 -1,
 181965199,
 5375,
 182127324,
 181952895,
 5369,
 -1,
 182083967,
 5371,
 182258398,
 182064500,
 5377,
 -1,
 182195572,
 5379,
 -1,
 182206599,
 5367,
 182517759,
 181887306,
 -1,
 182520546,
 182423951,
 5406,
 -1,
 182489487,
 5408,
 182651620,
 182477183,
 5402,
 -1,
 182608255,
 5404,
 182782694,
 182588788,
 5410,
 -1,
 182719860,
 5412,
 -1,
 182730887,
 5400,
 182979317,
 181826392,
 5355,
 183044848,
 182967560,
 -1,
 183110379,
 183013775,
 5347,
 -1,
 183079311,
 5349,
 183241453,
 183067007,
 5343,
 -1,
 183198079,
 5345,
 183372527,
 183178612,
 5351,
 -1,
 183309684,
 5353,
 -1,
 183320711,
 5341,
 183569138,
 183013775,
 5450,
 -1,
 183538063,
 6369,
 183700212,
 183506292,
 5453,
 -1,
 183637364,
 6370,
 -1,
 183648391,
 5444,
 183896830,
 182969326,
 5440,
 184025087,
 183885064,
 -1,
 184027897,
 183931279,
 5430,
 -1,
 183996815,
 5432,
 184158971,
 183984511,
 5426,
 -1,
 184115583,
 5428,
 184290045,
 184096116,
 5434,
 -1,
 184227188,
 5436,
 -1,
 184238215,
 5424,
 184486664,
 183878356,
 -1,
 184552199,
 184474888,
 -1,
 184617730,
 184521103,
 5214,
 -1,
 184586639,
 5216,
 184748804,
 184574335,
 5210,
 -1,
 184705407,
 5212,
 184879878,
 184685940,
 5218,
 -1,
 184817012,
 5220,
 -1,
 184828039,
 5208,
 -1,
 184508753,
 5481,
 185142033,
 184459241,
 5194,
 185270271,
 185130248,
 -1,
 185273100,
 185176463,
 5185,
 -1,
 185241999,
 5187,
 185404174,
 185229695,
 5181,
 -1,
 185360767,
 5183,
 185535248,
 185341300,
 5189,
 -1,
 185472372,
 5191,
 -1,
 185483399,
 5179,
 185731866,
 185106405,
 5308,
 185860095,
 185720072,
 -1,
 185862933,
 185766287,
 5299,
 -1,
 185831823,
 5301,
 185994007,
 185819519,
 5295,
 -1,
 185950591,
 5297,
 186125081,
 185931124,
 5303,
 -1,
 186062196,
 5305,
 -1,
 186073223,
 5293,
 186321698,
 185720072,
 -1,
 186387229,
 186290575,
 5139,
 -1,
 186356111,
 5141,
 186518303,
 186343807,
 5135,
 -1,
 186474879,
 5137,
 186649377,
 186455412,
 5144,
 -1,
 186586484,
 5146,
 -1,
 186597511,
 5133,
 186845994,
 186282818,
 -1,
 186911525,
 186814863,
 5243,
 -1,
 186880399,
 5245,
 187042599,
 186868095,
 5239,
 -1,
 186999167,
 5241,
 187173673,
 186979700,
 5247,
 -1,
 187110772,
 5249,
 -1,
 187121799,
 5237,
 187370290,
 186791431,
 -1,
 187435821,
 187339151,
 5273,
 -1,
 187404687,
 5275,
 187566895,
 187392383,
 5269,
 -1,
 187523455,
 5271,
 187697969,
 187503988,
 5277,
 -1,
 187635060,
 5279,
 -1,
 187646087,
 5267,
 187894584,
 187345236,
 5457,
 -62668,
 187882803,
 5455,
 -62667,
 187928975,
 5516,
 -62666,
 187982207,
 5515,
 -62665,
 188039303,
 5514,
 -1,
 188093812,
 5517,
 188287804,
 187863334,
 -1,
 188353339,
 188224884,
 5324,
 -1,
 188290420,
 5326,
 -1,
 188301447,
 5322,
 -1,
 188240606,
 5468,
 -1,
 181750259,
 6365,
 188681039,
 181637519,
 5138,
 188809215,
 188649871,
 5140,
 188874751,
 188694560,
 -1,
 188877646,
 188794383,
 5535,
 188943178,
 188865800,
 -1,
 189008709,
 188912015,
 5754,
 -1,
 188977551,
 5755,
 189139783,
 188965247,
 5752,
 -1,
 189096319,
 5753,
 189270857,
 189076852,
 5756,
 -1,
 189207924,
 5757,
 -1,
 189219623,
 5751,
 -62645,
 188912015,
 5533,
 -62644,
 189423999,
 5532,
 -62643,
 189481095,
 5531,
 -1,
 189535604,
 5534,
 -1,
 188829824,
 5758,
 189795154,
 188618100,
 5143,
 -62639,
 189785070,
 6323,
 -1,
 189797748,
 5145,
 190054399,
 189751679,
 5134,
 -1,
 189948287,
 5136,
 190122904,
 181569759,
 5328,
 190188395,
 190059892,
 5319,
 190253928,
 190168403,
 -1,
 190319455,
 190232351,
 -1,
 190384986,
 190280514,
 5386,
 -1,
 190322036,
 5390,
 -62629,
 190373171,
 5380,
 -62628,
 190500179,
 5389,
 -62627,
 190555965,
 5388,
 -62626,
 190592522,
 5391,
 -1,
 190648716,
 5387,
 190843746,
 190307592,
 -1,
 -62623,
 190813828,
 5142,
 -1,
 190846455,
 5147,
 -62621,
 190834432,
 5437,
 -62620,
 191024471,
 5221,
 -62619,
 191074601,
 5327,
 -62618,
 191137971,
 5306,
 -62617,
 191198021,
 5250,
 -1,
 191247886,
 5280,
 191433578,
 190190964,
 5320,
 -1,
 191390079,
 5313,
 -1,
 191423470,
 6332,
 191630197,
 190173703,
 -1,
 191695732,
 191587754,
 5499,
 191761263,
 191664527,
 5495,
 -1,
 191730063,
 5496,
 191892337,
 191717759,
 5493,
 -1,
 191848831,
 5494,
 192023411,
 191829364,
 5497,
 -1,
 191960436,
 5498,
 -1,
 191971463,
 5492,
 -1,
 191682316,
 5500,
 192285566,
 191582947,
 5525,
 192351098,
 192222580,
 5523,
 192416633,
 192288116,
 5524,
 -1,
 192373119,
 5518,
 -1,
 192373119,
 5744,
 192613244,
 192319887,
 5521,
 -1,
 192582031,
 5522,
 192806911,
 192569727,
 5519,
 -1,
 192700799,
 5520,
 192875398,
 192273672,
 -1,
 192940929,
 192844175,
 6346,
 -1,
 192909711,
 6348,
 193072003,
 192897407,
 6342,
 -1,
 193028479,
 6344,
 193203077,
 193009012,
 5323,
 -1,
 193140084,
 5325,
 -1,
 193151111,
 5321,
 193399693,
 192842679,
 5526,
 193465225,
 193368463,
 5747,
 -1,
 193433999,
 5748,
 193596299,
 193421695,
 5745,
 -1,
 193552767,
 5746,
 193789951,
 193533300,
 5749,
 -1,
 193664372,
 5750,
 193858448,
 193368463,
 5316,
 -62577,
 193848302,
 6331,
 -1,
 193892751,
 5317,
 194055060,
 193793855,
 -1,
 194120595,
 194011519,
 5473,
 -1,
 194077055,
 5475,
 -1,
 194068615,
 5471,
 194317206,
 194011519,
 5314,
 -1,
 194273663,
 5315,
 -62569,
 194271371,
 5330,
 -1,
 194396295,
 5312,
 194579415,
 190104276,
 5222,
 194644909,
 194533515,
 5482,
 194710434,
 194580287,
 5550,
 194775965,
 194679183,
 5546,
 -1,
 194744719,
 5547,
 194907039,
 194732415,
 5544,
 -1,
 194863487,
 5545,
 195038113,
 194844020,
 5548,
 -1,
 194975092,
 5549,
 -1,
 194986119,
 5543,
 195234726,
 194698504,
 -1,
 195300261,
 195171700,
 6372,
 -1,
 195237236,
 5480,
 -1,
 195248263,
 6371,
 195496872,
 195203471,
 5476,
 -1,
 195465615,
 5477,
 195627946,
 195453311,
 5472,
 -1,
 195584383,
 5474,
 195759020,
 195564916,
 5478,
 -1,
 195695988,
 5479,
 -1,
 195707015,
 5470,
 195955642,
 194626260,
 -1,
 196021174,
 195909771,
 5487,
 196086705,
 195989903,
 5485,
 -1,
 196055439,
 6374,
 196217779,
 196023668,
 5486,
 -1,
 196154740,
 6375,
 -62540,
 196206162,
 6373,
 -62539,
 196305279,
 5484,
 -1,
 196362375,
 5483,
 -62537,
 195989903,
 5225,
 -62536,
 196501887,
 5224,
 -62535,
 196558983,
 5223,
 -1,
 196613492,
 5226,
 196807618,
 195943688,
 -1,
 196873149,
 196776335,
 5213,
 -1,
 196841871,
 5215,
 197004223,
 196829567,
 5209,
 -1,
 196960639,
 5211,
 197135297,
 196941172,
 5217,
 -1,
 197072244,
 5219,
 -1,
 197083271,
 5207,
 197331913,
 196770398,
 -1,
 197397445,
 197300623,
 5512,
 -1,
 197366159,
 6377,
 -62522,
 197385810,
 6376,
 -62521,
 197484927,
 5511,
 -62520,
 197542023,
 5510,
 -1,
 197596532,
 5513,
 197790670,
 197321710,
 -1,
 -62517,
 197759375,
 5490,
 -62516,
 197812607,
 5489,
 -62515,
 197869703,
 5488,
 -1,
 197924212,
 5491,
 198118354,
 197727604,
 5205,
 198183889,
 198055284,
 5206,
 -1,
 198140287,
 5197,
 -1,
 198173678,
 6327,
 198380500,
 198087055,
 5200,
 -1,
 198349199,
 5201,
 198511574,
 198336895,
 5198,
 -1,
 198467967,
 5199,
 -1,
 198459527,
 5196,
 198708247,
 194557727,
 5381,
 198773745,
 198645108,
 5364,
 198839279,
 198763502,
 6335,
 198967295,
 198798614,
 -1,
 198970338,
 198883859,
 -1,
 199035870,
 198939023,
 5529,
 -1,
 199004559,
 6379,
 -62497,
 199024210,
 6378,
 -62496,
 199123327,
 5528,
 -62495,
 199180423,
 5527,
 -1,
 199234932,
 5530,
 199429096,
 198924427,
 -1,
 199494629,
 199397775,
 5570,
 -1,
 199463311,
 6380,
 -62490,
 199451007,
 5569,
 -62489,
 199573639,
 5568,
 -1,
 199628148,
 5571,
 199822316,
 199388969,
 -1,
 199887851,
 199806538,
 5653,
 -1,
 199872074,
 6385,
 -1,
 199844223,
 5658,
 -62483,
 199812464,
 5441,
 -62482,
 200066575,
 5282,
 -1,
 200114149,
 5311,
 200343551,
 198776180,
 5365,
 -1,
 200237439,
 5358,
 200412164,
 198727819,
 5413,
 200477691,
 200400136,
 -1,
 200543222,
 200446351,
 5405,
 -62475,
 200532974,
 6338,
 -1,
 200577423,
 5407,
 200739832,
 200499583,
 5401,
 -1,
 200696191,
 5403,
 200870906,
 200676724,
 5409,
 -1,
 200807796,
 5411,
 -1,
 200818823,
 5399,
 201067518,
 200446351,
 5395,
 -62467,
 201057262,
 6336,
 -1,
 201101711,
 5396,
 201264129,
 201004404,
 5397,
 -62464,
 201253870,
 6337,
 -1,
 201266548,
 5398,
 201460739,
 201220479,
 5393,
 -1,
 201417087,
 5394,
 -1,
 201408647,
 5392,
 201657356,
 200400136,
 5383,
 201722887,
 201625999,
 5372,
 -1,
 201691535,
 5374,
 201853961,
 201679231,
 5368,
 -1,
 201810303,
 5370,
 201985035,
 201790836,
 5376,
 -1,
 201921908,
 5378,
 -1,
 201932935,
 5366,
 202181652,
 201625999,
 5361,
 202247186,
 202168137,
 -1,
 -62449,
 202216291,
 5255,
 -62448,
 202270094,
 5254,
 -62447,
 202327249,
 5253,
 -1,
 202381559,
 5256,
 -62445,
 202236910,
 6334,
 -1,
 202543503,
 5362,
 202705942,
 202137983,
 5359,
 -1,
 202662271,
 5360,
 -1,
 202653831,
 5357,
 202902584,
 198697966,
 5438,
 202968102,
 202837808,
 -1,
 203033628,
 202940393,
 -1,
 -62437,
 203021619,
 5192,
 -1,
 203069060,
 5173,
 -62435,
 203023940,
 5420,
 -62434,
 203218184,
 5149,
 -62433,
 203278843,
 5202,
 -62432,
 203341506,
 5363,
 -62431,
 203396740,
 5127,
 -62430,
 203460021,
 5318,
 -62429,
 203523861,
 5289,
 -62428,
 203586954,
 5337,
 -62427,
 203649704,
 5233,
 -1,
 203699008,
 5263,
 203885614,
 202956040,
 -1,
 203951145,
 203854223,
 5429,
 -1,
 203919759,
 5431,
 204082219,
 203907455,
 5425,
 -1,
 204038527,
 5427,
 204213293,
 204019060,
 5433,
 -1,
 204150132,
 5435,
 -1,
 204161159,
 5423,
 204409906,
 203822452,
 5421,
 204475441,
 204346740,
 5422,
 -1,
 204431743,
 5415,
 -1,
 204465134,
 6340,
 204672053,
 204378511,
 5418,
 -62412,
 204661742,
 6339,
 -1,
 204706191,
 5419,
 204868663,
 204628351,
 5416,
 -1,
 204824959,
 5417,
 -1,
 204816519,
 5414,
 205065303,
 202853974,
 5469,
 205130831,
 205021567,
 5461,
 205196366,
 205097339,
 -1,
 205261888,
 205171028,
 -1,
 205327423,
 205218175,
 -1,
 -62402,
 205294519,
 5156,
 -1,
 205346032,
 5155,
 -1,
 205265285,
 6367,
 205589573,
 205208260,
 -1,
 205655108,
 205573929,
 -1,
 -62397,
 205634486,
 5158,
 -1,
 205658017,
 5157,
 -1,
 205644153,
 5162,
 205917256,
 205567775,
 -1,
 -62393,
 205881791,
 6366,
 -1,
 205938633,
 5160,
 -62391,
 205900322,
 5154,
 -62390,
 206087244,
 5161,
 -62389,
 206144736,
 5159,
 -62388,
 206198469,
 5152,
 -62387,
 206252800,
 5153,
 -1,
 206313377,
 5151,
 -1,
 205152639,
 5462,
 206572626,
 205067636,
 5465,
 206700543,
 206509428,
 5466,
 -1,
 206594431,
 5460,
 206769236,
 206541199,
 5463,
 -1,
 206737807,
 5464,
 -62379,
 206757171,
 5467,
 -62378,
 206885146,
 5742,
 -1,
 206913671,
 5459,
 207096944,
 205026136,
 5354,
 207162464,
 207084808,
 -1,
 207227995,
 207131023,
 5346,
 -1,
 207196559,
 5348,
 207359069,
 207184255,
 5342,
 -1,
 207315327,
 5344,
 207490143,
 207295860,
 5350,
 -1,
 207426932,
 5352,
 -1,
 207437959,
 5340,
 207686759,
 207116427,
 5542,
 207752291,
 207655311,
 5538,
 -1,
 207720847,
 5539,
 207883365,
 207708543,
 5536,
 -1,
 207839615,
 5537,
 208076799,
 207820148,
 5540,
 -1,
 207951220,
 5541,
 208145515,
 207623540,
 5338,
 208211050,
 208082292,
 5339,
 -1,
 208167295,
 5332,
 -1,
 208200686,
 6333,
 208407661,
 208114063,
 5335,
 -1,
 208376207,
 5336,
 208538735,
 208363903,
 5333,
 -1,
 208494975,
 5334,
 -1,
 208486535,
 5331,
 208735367,
 207060965,
 5307,
 208800889,
 208723208,
 -1,
 208866420,
 208769423,
 5298,
 -1,
 208834959,
 5300,
 208997494,
 208822655,
 5294,
 -1,
 208953727,
 5296,
 209128568,
 208934260,
 5302,
 -1,
 209065332,
 5304,
 -1,
 209076359,
 5292,
 209325181,
 208737652,
 5290,
 209390716,
 209261940,
 5291,
 -1,
 209346943,
 5284,
 -1,
 209380334,
 6330,
 209587328,
 209293711,
 5287,
 209715199,
 209555855,
 5288,
 -1,
 209631391,
 5385,
 209783940,
 209535111,
 5283,
 209911807,
 209729815,
 -1,
 -62333,
 209824084,
 5458,
 -1,
 209875800,
 5356,
 210046086,
 209740159,
 5285,
 -1,
 210002303,
 5286,
 -1,
 210000011,
 5309,
 210242721,
 208676470,
 -1,
 210308253,
 210203701,
 -1,
 210373774,
 210296072,
 5759,
 -62325,
 210342287,
 5558,
 -62324,
 210395519,
 5557,
 -62323,
 210452615,
 5556,
 -1,
 210507124,
 5559,
 210701459,
 210340063,
 -1,
 -62320,
 210669967,
 5562,
 -62319,
 210723199,
 5561,
 -62318,
 210780295,
 5560,
 -1,
 210834804,
 5563,
 211029144,
 210661512,
 -1,
 -62315,
 210997647,
 5566,
 -62314,
 211050879,
 5565,
 -62313,
 211107975,
 5564,
 -1,
 211162484,
 5567,
 -62311,
 211007263,
 5384,
 -62310,
 211325327,
 5554,
 -62309,
 211378559,
 5553,
 -62308,
 211435655,
 5552,
 -1,
 211490164,
 5555,
 211684512,
 210256328,
 -1,
 -62305,
 211659092,
 6388,
 -1,
 211710808,
 6387,
 -1,
 211641057,
 5439,
 211946678,
 210217300,
 5456,
 212012202,
 211934472,
 -1,
 212077733,
 211980687,
 6353,
 -1,
 212046223,
 6354,
 212208807,
 212033919,
 6351,
 -1,
 212164991,
 6352,
 212339881,
 212145524,
 6355,
 -1,
 212276596,
 5454,
 -1,
 212288295,
 6350,
 212536494,
 211948916,
 5451,
 212602029,
 212473204,
 5452,
 -1,
 212558207,
 5445,
 -1,
 212591598,
 6341,
 212798640,
 212504975,
 5448,
 -1,
 212767119,
 5449,
 212929714,
 212754815,
 5446,
 -1,
 212885887,
 5447,
 213060789,
 212864823,
 -1,
 -62284,
 213048914,
 6368,
 -1,
 213074055,
 5443,
 -1,
 213008519,
 5442,
 213322954,
 211918825,
 5193,
 213388480,
 213310728,
 -1,
 213454011,
 213356943,
 5184,
 -62278,
 213443566,
 6326,
 -1,
 213488015,
 5186,
 213650621,
 213410175,
 5180,
 -1,
 213606783,
 5182,
 213781695,
 213587316,
 5188,
 -1,
 213718388,
 5190,
 -1,
 213729415,
 5178,
 213978308,
 213325172,
 5176,
 214043843,
 213914996,
 5177,
 -1,
 213999999,
 5168,
 -1,
 214033390,
 6325,
 214240455,
 213946767,
 5171,
 -62266,
 214229998,
 6324,
 -1,
 214274447,
 5172,
 214437065,
 214196607,
 5169,
 -1,
 214393215,
 5170,
 -1,
 214384775,
 5167,
 214633693,
 213282952,
 5251,
 214699220,
 214621448,
 5252,
 214764751,
 214635892,
 5246,
 -62258,
 214754286,
 6329,
 -1,
 214766964,
 5248,
 214961361,
 214733199,
 5242,
 -1,
 214929807,
 5244,
 215092435,
 214917503,
 5238,
 -1,
 215048575,
 5240,
 -1,
 215040135,
 5236,
 215289048,
 214635892,
 5234,
 215354583,
 215225716,
 5235,
 -1,
 215310719,
 5228,
 -1,
 215344110,
 6328,
 215551194,
 215257487,
 5231,
 -1,
 215519631,
 5232,
 215682268,
 215507327,
 5229,
 -1,
 215638399,
 5230,
 -1,
 215629959,
 5227,
 215878895,
 214602127,
 5125,
 215944428,
 215838718,
 -1,
 216009957,
 215910623,
 6361,
 216137727,
 215997704,
 -1,
 216141027,
 216043919,
 6347,
 -1,
 216109455,
 6349,
 216334335,
 216097151,
 6343,
 -1,
 216228223,
 6345,
 216403175,
 215987999,
 6362,
 -1,
 216357003,
 6363,
 -62232,
 216384212,
 6357,
 -62231,
 216506345,
 6356,
 -62230,
 216563685,
 6360,
 -62229,
 216625288,
 6358,
 -1,
 216673502,
 6359,
 -62227,
 215933934,
 6320,
 -62226,
 216830351,
 5126,
 -1,
 216893663,
 5165,
 217058554,
 215815540,
 5130,
 217124083,
 216995188,
 5131,
 -62222,
 217113582,
 6322,
 -1,
 217145727,
 5122,
 217320694,
 217106039,
 -1,
 -62219,
 217298719,
 5382,
 -1,
 217350117,
 5310,
 217517304,
 217276799,
 5148,
 -1,
 217504666,
 5551,
 -62215,
 217506798,
 6321,
 -1,
 217614559,
 5166,
 217779459,
 217032516,
 5509,
 217844991,
 217716084,
 5507,
 217910526,
 217781620,
 5508,
 -1,
 217866623,
 5502,
 -1,
 217866623,
 5743,
 218107137,
 217813391,
 5505,
 -1,
 218075535,
 5506,
 218300415,
 218063231,
 5503,
 -1,
 218194303,
 5504,
 218369286,
 217735551,
 5123,
 -62203,
 218335455,
 5164,
 -1,
 218390911,
 5124,
 218565897,
 218316935,
 5121,
 -62200,
 218532063,
 5163,
 -1,
 218571836,
 6364,
 218762508,
 218519691,
 -1,
 -62197,
 218752616,
 5120,
 -1,
 218787976,
 5501,
 -1,
 218715626,
 5150,
 219086847,
 166473352,
 -1,
 -62193,
 218999124,
 9803,
 -1,
 219050874,
 917631,
 219221322,
 166439252,
 -1,
 219286852,
 219177570,
 -1,
 219352344,
 219270730,
 66226,
 219480063,
 219336266,
 66239,
 219545599,
 219401802,
 66212,
 -62186,
 219467338,
 66235,
 -62185,
 219485004,
 66256,
 -1,
 219550375,
 66248,
 219745566,
 219330335,
 66224,
 219811099,
 219726548,
 66242,
 -1,
 219746983,
 66243,
 219942173,
 219764875,
 66222,
 -1,
 219878055,
 66223,
 -1,
 219920159,
 66232,
 220138787,
 219709413,
 66218,
 220266495,
 220079734,
 66250,
 -62175,
 220140476,
 66253,
 -62174,
 220205900,
 66252,
 -1,
 220271271,
 66251,
 220466471,
 220104927,
 66229,
 -62171,
 220432607,
 66227,
 -62170,
 220484323,
 66244,
 -1,
 220542496,
 66238,
 220728618,
 220447444,
 66221,
 220856319,
 220709588,
 66247,
 -1,
 220730023,
 66230,
 220925229,
 220689240,
 66211,
 221052927,
 220870176,
 66214,
 -1,
 220926631,
 66254,
 221121839,
 220899668,
 66213,
 -1,
 221096276,
 66249,
 221252913,
 221093865,
 66231,
 -1,
 221188775,
 66209,
 221383987,
 221212808,
 66236,
 -1,
 221319847,
 66237,
 221515061,
 221340031,
 66233,
 -1,
 221471103,
 66245,
 221646135,
 221467363,
 66240,
 -1,
 221581991,
 66241,
 221777209,
 221593735,
 66234,
 -1,
 221713063,
 66255,
 221908283,
 221722144,
 66210,
 -1,
 221844135,
 66220,
 222039358,
 221850933,
 -1,
 -62147,
 221975481,
 66246,
 -1,
 222040730,
 66225,
 222235968,
 221975924,
 66208,
 -1,
 222171815,
 66215,
 -62143,
 222225156,
 66228,
 -62142,
 222340932,
 66216,
 -62141,
 222400911,
 66219,
 -1,
 222439030,
 66217,
 222629192,
 219234439,
 -1,
 222694727,
 222610132,
 8248,
 -1,
 222627002,
 8257,
 -1,
 222627382,
 8453,
 -62135,
 222598445,
 711,
 -1,
 222825037,
 9936,
 223022413,
 219166240,
 -1,
 -62132,
 223006708,
 9764,
 -1,
 223024584,
 8454,
 -62130,
 223008604,
 9761,
 -62129,
 223199409,
 9963,
 -1,
 223258206,
 9809,
 223416263,
 166367631,
 -1,
 223481555,
 223379429,
 -1,
 223547082,
 223422858,
 -1,
 223612320,
 223489246,
 -1,
 223677840,
 223602368,
 -1,
 223743359,
 223640026,
 -1,
 223808861,
 223690887,
 -1,
 223874393,
 223786783,
 11757,
 -1,
 223809912,
 11765,
 -62118,
 223848788,
 11756,
 -62117,
 223971551,
 11753,
 -62116,
 224034789,
 11752,
 -1,
 224097112,
 11751,
 224267618,
 223764863,
 -1,
 224333153,
 224238294,
 -1,
 -62112,
 224274776,
 11775,
 -1,
 224335220,
 11772,
 -1,
 224280711,
 11767,
 224595301,
 224257822,
 -1,
 -62108,
 224549672,
 11748,
 -1,
 224608391,
 11749,
 224791912,
 224584686,
 -1,
 -62105,
 224775754,
 11771,
 -1,
 224797804,
 11770,
 224988523,
 224772820,
 -1,
 -62102,
 224966808,
 11760,
 -1,
 225001607,
 11758,
 225185134,
 224967187,
 -1,
 -62099,
 225128233,
 11763,
 -1,
 225187188,
 11762,
 225381745,
 225130016,
 -1,
 -62096,
 225341405,
 11768,
 -1,
 225394823,
 11747,
 225578356,
 225322614,
 -1,
 -62093,
 225535117,
 11774,
 -1,
 225591431,
 11744,
 -62091,
 225564916,
 11745,
 -62090,
 225747373,
 11755,
 -62089,
 225808783,
 11754,
 -62088,
 225871602,
 11769,
 -62087,
 225934296,
 11773,
 -62086,
 225996959,
 11750,
 -62085,
 226056361,
 11759,
 -62084,
 226120917,
 11746,
 -62083,
 226185391,
 11764,
 -62082,
 226242412,
 11761,
 -1,
 226301300,
 11766,
 226495877,
 223715305,
 -1,
 226561411,
 226432372,
 -1,
 -62078,
 226551132,
 42621,
 -1,
 226588066,
 1156,
 -62076,
 226540671,
 1158,
 -1,
 226726922,
 1159,
 226889097,
 226476756,
 -1,
 -62073,
 226848300,
 1155,
 -62072,
 226910231,
 42610,
 -1,
 226969359,
 42608,
 227151244,
 226844959,
 -1,
 -62069,
 227133232,
 1160,
 -1,
 227181904,
 42609,
 -62067,
 227138818,
 42607,
 -62066,
 227312976,
 1161,
 -62065,
 227373451,
 42620,
 -1,
 227424031,
 1157,
 227610006,
 223646095,
 -1,
 227675541,
 227575291,
 -1,
 227741076,
 227612277,
 787,
 -1,
 227674595,
 789,
 -1,
 227682387,
 806,
 -1,
 227642716,
 65062,
 228003226,
 227546484,
 -1,
 228068761,
 227980346,
 780,
 -1,
 228000291,
 812,
 -1,
 228035321,
 784,
 228265373,
 227966179,
 -1,
 -62052,
 228241883,
 8409,
 -1,
 228270703,
 8405,
 228461983,
 228224083,
 770,
 -1,
 228393507,
 813,
 -1,
 228410131,
 807,
 228658667,
 223572824,
 -1,
 228724167,
 228599067,
 -1,
 228789697,
 228703754,
 -1,
 228855207,
 228726132,
 867,
 -62043,
 228841390,
 7638,
 -62042,
 228888975,
 7637,
 -1,
 228933767,
 7636,
 229117355,
 228829524,
 876,
 229244927,
 229048320,
 -1,
 -62038,
 229160162,
 7651,
 -1,
 229189715,
 7626,
 229379501,
 229077848,
 7645,
 -1,
 229348923,
 7653,
 229510575,
 229335423,
 869,
 -1,
 229478132,
 7640,
 229641649,
 229458055,
 868,
 -1,
 229623311,
 7641,
 229772723,
 229584094,
 872,
 -1,
 229704316,
 7639,
 -62028,
 229762846,
 7654,
 -62027,
 229892868,
 879,
 -62026,
 229955502,
 878,
 -62025,
 230018634,
 871,
 -62024,
 230081236,
 877,
 -62023,
 230143775,
 7652,
 -62022,
 230199695,
 870,
 -62021,
 230263007,
 7648,
 -62020,
 230326245,
 875,
 -62019,
 230387848,
 7644,
 -62018,
 230447243,
 874,
 -62017,
 230511331,
 7642,
 -62016,
 230576406,
 7635,
 -1,
 230635040,
 873,
 230883327,
 228751858,
 -1,
 -62013,
 230795604,
 7650,
 -62012,
 230852831,
 7649,
 -62011,
 230916069,
 7647,
 -62010,
 230978392,
 7646,
 -1,
 231035619,
 7643,
 231214560,
 228672410,
 -1,
 231280093,
 231145472,
 -1,
 231345620,
 231216500,
 -1,
 231411153,
 231323058,
 -1,
 231476686,
 231365435,
 -1,
 -62003,
 231417939,
 852,
 -1,
 231478901,
 7678,
 231735295,
 231407616,
 -1,
 -62000,
 231614547,
 8430,
 -1,
 231675509,
 8406,
 231931903,
 231377924,
 -1,
 -61997,
 231811155,
 841,
 -1,
 231872117,
 794,
 232066521,
 231299241,
 -1,
 232132056,
 232028733,
 -1,
 -61993,
 232073299,
 796,
 -1,
 232134261,
 849,
 -1,
 232109382,
 8400,
 232394204,
 232042154,
 -1,
 -61989,
 232335443,
 845,
 -1,
 232396405,
 8417,
 -1,
 232375140,
 792,
 232718335,
 231267674,
 -1,
 -61985,
 232610518,
 8429,
 -1,
 232661627,
 8426,
 232852968,
 231182735,
 -1,
 232918503,
 232819642,
 -1,
 232984037,
 232896287,
 -1,
 -61980,
 232967145,
 822,
 -1,
 233018490,
 824,
 -61978,
 232971009,
 8402,
 -1,
 233127295,
 8427,
 -1,
 232905997,
 818,
 233439231,
 232809631,
 -1,
 -61974,
 233352985,
 65057,
 -1,
 233404149,
 65056,
 233573927,
 228603424,
 -1,
 233639437,
 233542031,
 -1,
 233704964,
 233623337,
 -1,
 233770483,
 233691704,
 -1,
 233836018,
 233732850,
 -1,
 -61967,
 233777235,
 840,
 -1,
 233838197,
 782,
 -1,
 233816377,
 8422,
 234098167,
 233752572,
 864,
 234225663,
 234029056,
 -1,
 -61962,
 234139417,
 65059,
 -1,
 234190581,
 65058,
 234360314,
 234073593,
 -1,
 -61959,
 234326974,
 858,
 -1,
 234378570,
 866,
 234556924,
 234324027,
 862,
 -1,
 234488355,
 863,
 234687998,
 234499017,
 861,
 -1,
 234619427,
 860,
 -61953,
 234659547,
 831,
 -61952,
 234782248,
 819,
 -61951,
 234842848,
 865,
 -61950,
 234903243,
 783,
 -61949,
 234959040,
 7629,
 -1,
 235018151,
 779,
 235212300,
 233685716,
 -1,
 235277833,
 235143168,
 -1,
 235343368,
 235214453,
 775,
 -1,
 235276771,
 856,
 -1,
 235284563,
 803,
 235601919,
 235259086,
 -1,
 -61941,
 235493067,
 7616,
 -1,
 235542439,
 7617,
 -1,
 235200897,
 798,
 235802149,
 233589875,
 -1,
 235867676,
 235747736,
 -1,
 235933202,
 235848404,
 -1,
 -61935,
 235921807,
 43234,
 -1,
 235954262,
 43235,
 236129813,
 235910943,
 -1,
 -61932,
 236089070,
 43238,
 -1,
 236145794,
 43239,
 236326424,
 236080726,
 -1,
 -61929,
 236297200,
 43236,
 -1,
 236351095,
 43237,
 -61927,
 236316565,
 43232,
 -61926,
 236492223,
 43233,
 -61925,
 236555452,
 43241,
 -1,
 236602679,
 43240,
 236785188,
 235829722,
 -1,
 -61922,
 236772197,
 43248,
 -61921,
 236834378,
 43243,
 -61920,
 236890543,
 43247,
 -61919,
 236953678,
 43246,
 -61918,
 237013307,
 43245,
 -61917,
 237072543,
 43244,
 -1,
 237114740,
 43242,
 -1,
 236764214,
 43249,
 237436927,
 235758089,
 776,
 -1,
 237306403,
 804,
 237506118,
 233548116,
 -1,
 237571649,
 237461887,
 -1,
 237637181,
 237524190,
 -1,
 237702716,
 237568000,
 -1,
 237768246,
 237642338,
 -1,
 237833779,
 237722427,
 -1,
 237899314,
 237770100,
 -1,
 237964849,
 237865568,
 -1,
 -61904,
 237949755,
 854,
 -1,
 237977187,
 7679,
 -1,
 237906761,
 848,
 -1,
 237840467,
 853,
 238354431,
 237764608,
 -1,
 -61899,
 238233683,
 8431,
 -1,
 238294645,
 8407,
 238489147,
 237721769,
 -1,
 238554682,
 238451261,
 -1,
 -61895,
 238495827,
 825,
 -1,
 238556789,
 855,
 -1,
 238531910,
 8401,
 -1,
 238469988,
 793,
 -1,
 237690252,
 8428,
 239009791,
 237603770,
 -1,
 -61889,
 238919379,
 8408,
 -61888,
 238954579,
 805,
 -1,
 239015541,
 778,
 239271935,
 237518983,
 -1,
 239275589,
 239196671,
 -1,
 -61884,
 239220261,
 788,
 -1,
 239274597,
 8421,
 -1,
 239258561,
 802,
 239537755,
 237459053,
 -1,
 239603281,
 239485747,
 -1,
 239668813,
 239569030,
 -1,
 239734348,
 239649492,
 -1,
 -61877,
 239710881,
 119362,
 -1,
 239750138,
 119363,
 -1,
 239706692,
 119364,
 -61874,
 239658606,
 837,
 -61873,
 239968973,
 834,
 -61872,
 240022221,
 835,
 -1,
 240072989,
 836,
 240320511,
 239539572,
 -1,
 240324186,
 240244980,
 -1,
 240389719,
 240254976,
 -1,
 240455254,
 240326447,
 768,
 -1,
 240386595,
 790,
 -1,
 240437711,
 832,
 240713727,
 240324307,
 -1,
 -61863,
 240615483,
 7621,
 -1,
 240654282,
 7624,
 -1,
 240296786,
 847,
 240914031,
 239474036,
 -1,
 240979556,
 240858614,
 -1,
 241045089,
 240910336,
 -1,
 241110624,
 240981807,
 769,
 -1,
 241041955,
 791,
 -1,
 241093071,
 833,
 241369087,
 240979667,
 -1,
 -61853,
 241270843,
 7623,
 -1,
 241325784,
 7625,
 241503849,
 240945375,
 -1,
 241569384,
 241485778,
 -1,
 -61849,
 241545691,
 8410,
 -1,
 241574511,
 8404,
 -1,
 241537064,
 8423,
 241831532,
 241483899,
 -1,
 -61845,
 241772627,
 857,
 -1,
 241833589,
 8432,
 242089983,
 241794228,
 -1,
 -61842,
 241969235,
 7677,
 -1,
 242030197,
 844,
 242224762,
 240877541,
 -1,
 242290297,
 242161551,
 772,
 242355829,
 242224851,
 -1,
 -61837,
 242308805,
 7622,
 -61836,
 242363337,
 7628,
 -1,
 242423713,
 7620,
 242679807,
 242286592,
 -1,
 -61833,
 242593561,
 65061,
 -61832,
 242644725,
 65060,
 -1,
 242690131,
 817,
 -1,
 242248360,
 800,
 242945669,
 242172039,
 -1,
 243011204,
 242911821,
 -1,
 243076735,
 242988831,
 -1,
 -61826,
 243050527,
 8414,
 -1,
 243086281,
 8418,
 243273345,
 243019842,
 8413,
 -1,
 243204613,
 8416,
 -61822,
 243258640,
 8420,
 -61821,
 243364338,
 8419,
 -1,
 243415341,
 8415,
 -1,
 242984974,
 839,
 243666575,
 242923295,
 -1,
 243732107,
 243621820,
 -1,
 243797642,
 243709727,
 -1,
 -61815,
 243780585,
 821,
 -1,
 243831930,
 823,
 -1,
 243784449,
 8403,
 -61812,
 243717823,
 7619,
 -61811,
 244033580,
 827,
 -61810,
 244091248,
 7618,
 -1,
 244138268,
 828,
 244321943,
 243647188,
 -1,
 244387476,
 244278783,
 771,
 244514815,
 244318208,
 -1,
 -61805,
 244424403,
 820,
 -1,
 244459603,
 816,
 -61803,
 244373015,
 786,
 -61802,
 244626026,
 8424,
 -1,
 244670605,
 8411,
 244846239,
 244277631,
 -1,
 244911774,
 244814073,
 -1,
 244977309,
 244853599,
 -1,
 245042844,
 244927614,
 785,
 -1,
 244974115,
 815,
 -1,
 244999189,
 826,
 -1,
 244923540,
 811,
 -1,
 244889401,
 7632,
 245370534,
 244788063,
 -1,
 245436067,
 245320830,
 774,
 -61790,
 245370986,
 7627,
 -1,
 245432867,
 814,
 245694463,
 245392399,
 -1,
 -61787,
 245573715,
 810,
 -1,
 245634677,
 838,
 245829292,
 245354058,
 -1,
 245894826,
 245800937,
 -1,
 -61783,
 245882221,
 846,
 -1,
 245893794,
 797,
 -61781,
 245872420,
 7634,
 -1,
 246065497,
 7633,
 246222513,
 245815864,
 -1,
 246288048,
 246184690,
 -1,
 -61777,
 246229075,
 809,
 -1,
 246290037,
 781,
 -1,
 246269948,
 830,
 246550197,
 246190479,
 -1,
 246615732,
 246502983,
 808,
 -1,
 246546437,
 7630,
 -1,
 246602197,
 773,
 246812345,
 246505055,
 -1,
 -61769,
 246789017,
 795,
 -61768,
 246846437,
 777,
 -1,
 246908740,
 843,
 247074492,
 246802448,
 -1,
 -61765,
 247015507,
 7631,
 -1,
 247076469,
 859,
 247271103,
 247063302,
 -1,
 -61762,
 247212115,
 851,
 -1,
 247273077,
 829,
 247467714,
 247242729,
 -1,
 -61759,
 247431039,
 799,
 -1,
 247470703,
 801,
 247664325,
 247427410,
 -1,
 -61756,
 247651415,
 12441,
 -1,
 247707912,
 12442,
 247860936,
 247615062,
 -1,
 -61753,
 247831574,
 8412,
 -1,
 247876076,
 850,
 -61751,
 247848749,
 8425,
 -1,
 248024722,
 842,
 248188623,
 223510501,
 -1,
 248254158,
 248138146,
 -1,
 -61747,
 248219057,
 8274,
 -1,
 248259692,
 64,
 -1,
 248190324,
 44,
 248516306,
 248160233,
 -1,
 -61743,
 248486418,
 9092,
 -1,
 248543456,
 8705,
 -1,
 248466237,
 9732,
 248778642,
 223453161,
 -1,
 248844177,
 248760253,
 -1,
 248909617,
 248821535,
 -1,
 248975143,
 248873344,
 -1,
 249040622,
 248942991,
 11423,
 249106157,
 249001529,
 -1,
 249171687,
 249049924,
 -1,
 249237215,
 249125003,
 -1,
 249302749,
 249173364,
 11471,
 -1,
 249283284,
 11477,
 -61730,
 249272525,
 11469,
 -1,
 249382177,
 11475,
 249564898,
 249215507,
 -1,
 -61727,
 249521766,
 11483,
 -1,
 249578785,
 11461,
 -61725,
 249534184,
 11455,
 -61724,
 249713546,
 11479,
 -61723,
 249776758,
 11463,
 -61722,
 249838249,
 11481,
 -1,
 249895284,
 11445,
 250150911,
 249139226,
 -1,
 250154731,
 250054879,
 -1,
 -61718,
 250144112,
 11489,
 -1,
 250172785,
 11487,
 -61716,
 250142206,
 11491,
 -1,
 250329886,
 11485,
 -1,
 249076529,
 11441,
 250547958,
 248985120,
 -1,
 250613492,
 250503726,
 -1,
 -61711,
 250580083,
 11451,
 -61710,
 250638604,
 11449,
 -61709,
 250699464,
 11467,
 -1,
 250747569,
 11443,
 -61707,
 250561825,
 1007,
 -1,
 250878623,
 11399,
 251072253,
 250525471,
 -1,
 251137786,
 251025547,
 -1,
 -61703,
 251094630,
 1005,
 -1,
 251151649,
 995,
 -61701,
 251108145,
 11403,
 -61700,
 251291238,
 11429,
 -1,
 251338032,
 11457,
 251531012,
 251016111,
 -1,
 251596547,
 251520645,
 -1,
 -61696,
 251575027,
 11500,
 -61695,
 251628659,
 11453,
 -61694,
 251679626,
 11502,
 -1,
 251741491,
 11447,
 -1,
 251566635,
 11459,
 251989770,
 251490440,
 -1,
 252055304,
 251943051,
 -1,
 -61689,
 252010879,
 11437,
 -1,
 252069153,
 999,
 -61687,
 252034012,
 11421,
 -1,
 252190647,
 11413,
 252382989,
 251970260,
 -1,
 -61684,
 252337256,
 11409,
 -1,
 252388751,
 11431,
 252579600,
 252354537,
 -1,
 -61681,
 252558300,
 11439,
 -1,
 252600703,
 11425,
 252776211,
 252539736,
 -1,
 -61678,
 252716467,
 11415,
 -1,
 252776763,
 11473,
 252972822,
 252729483,
 -1,
 -61675,
 252942541,
 1001,
 -1,
 252978333,
 11407,
 253169433,
 252924676,
 -1,
 -61672,
 253135866,
 1003,
 -1,
 253199863,
 11397,
 253366044,
 253120086,
 -1,
 -61669,
 253321599,
 11435,
 -1,
 253379873,
 997,
 253562655,
 253302132,
 -1,
 -61666,
 253524550,
 11393,
 -1,
 253588033,
 11465,
 -61664,
 253552485,
 11405,
 -61663,
 253746051,
 11395,
 -61662,
 253808318,
 11433,
 -61661,
 253866964,
 11427,
 -61660,
 253922419,
 11419,
 -61659,
 253985937,
 11417,
 -61658,
 254042830,
 11411,
 -1,
 254100787,
 11401,
 254345215,
 248964598,
 -1,
 254349099,
 254261023,
 -1,
 -61654,
 254329943,
 11495,
 -1,
 254369145,
 11498,
 254545710,
 254308488,
 -1,
 -61651,
 254499980,
 11497,
 -1,
 254548258,
 11492,
 -61649,
 254526544,
 11496,
 -61648,
 254714761,
 11494,
 -1,
 254772376,
 11493,
 254939016,
 248851678,
 -1,
 255004547,
 254877670,
 -1,
 255070026,
 254972303,
 11422,
 255135561,
 255030841,
 -1,
 255201091,
 255079236,
 -1,
 255266619,
 255154315,
 -1,
 255332153,
 255202676,
 11470,
 -1,
 255312596,
 11476,
 -61638,
 255301837,
 11468,
 -1,
 255411489,
 11474,
 255594302,
 255244819,
 -1,
 -61635,
 255551078,
 11482,
 -1,
 255608097,
 11460,
 -61633,
 255563496,
 11454,
 -61632,
 255742858,
 11478,
 -61631,
 255806070,
 11462,
 -61630,
 255867561,
 11480,
 -1,
 255924596,
 11444,
 256180223,
 255168538,
 -1,
 256184135,
 256084191,
 -1,
 -61626,
 256173424,
 11488,
 -1,
 256202097,
 11486,
 -61624,
 256171518,
 11490,
 -1,
 256359198,
 11484,
 -1,
 255105841,
 11440,
 256577362,
 255014432,
 -1,
 256642896,
 256533038,
 -1,
 -61619,
 256609395,
 11450,
 -61618,
 256667916,
 11448,
 -61617,
 256728776,
 11466,
 -1,
 256776881,
 11442,
 -61615,
 256591137,
 1006,
 -1,
 256907935,
 11398,
 257101657,
 256554783,
 -1,
 257167190,
 257054859,
 -1,
 -61611,
 257123942,
 1004,
 -1,
 257180961,
 994,
 -61609,
 257137457,
 11402,
 -61608,
 257320550,
 11428,
 -1,
 257367344,
 11456,
 257560416,
 257045423,
 -1,
 257625951,
 257549957,
 -1,
 -61604,
 257604339,
 11499,
 -61603,
 257657971,
 11452,
 -61602,
 257708938,
 11501,
 -1,
 257770803,
 11446,
 -1,
 257595947,
 11458,
 258019174,
 257519752,
 -1,
 258084708,
 257972363,
 -1,
 -61597,
 258040191,
 11436,
 -1,
 258098465,
 998,
 -61595,
 258063324,
 11420,
 -1,
 258219959,
 11412,
 258412393,
 257999572,
 -1,
 -61592,
 258366568,
 11408,
 -1,
 258418063,
 11430,
 258609004,
 258383849,
 -1,
 -61589,
 258587612,
 11438,
 -1,
 258630015,
 11424,
 258805615,
 258569048,
 -1,
 -61586,
 258745779,
 11414,
 -1,
 258806075,
 11472,
 259002226,
 258758795,
 -1,
 -61583,
 258971853,
 1000,
 -1,
 259007645,
 11406,
 259198837,
 258953988,
 -1,
 -61580,
 259165178,
 1002,
 -1,
 259229175,
 11396,
 259395448,
 259149398,
 -1,
 -61577,
 259350911,
 11434,
 -1,
 259409185,
 996,
 259592059,
 259331444,
 -1,
 -61574,
 259553862,
 11392,
 -1,
 259617345,
 11464,
 -61572,
 259581797,
 11404,
 -61571,
 259775363,
 11394,
 -61570,
 259837630,
 11432,
 -61569,
 259896276,
 11426,
 -61568,
 259951731,
 11418,
 -61567,
 260015249,
 11416,
 -61566,
 260072142,
 11410,
 -1,
 260130099,
 11400,
 260374527,
 254973148,
 -1,
 260378503,
 260292405,
 -1,
 -61562,
 260339976,
 11505,
 -1,
 260383715,
 11504,
 -1,
 260344950,
 11503,
 260640653,
 254907448,
 -1,
 -61558,
 260626949,
 11516,
 -61557,
 260663344,
 11515,
 -61556,
 260723394,
 11513,
 -1,
 260782623,
 11514,
 260968336,
 260591190,
 -1,
 -61553,
 260952346,
 11518,
 -1,
 261007843,
 11517,
 -1,
 260933401,
 11519,
 -1,
 248833716,
 169,
 261296049,
 248763113,
 -1,
 261361582,
 261253335,
 -1,
 261427105,
 261345958,
 -1,
 261492632,
 261407444,
 -1,
 -61545,
 261480847,
 119649,
 -1,
 261513302,
 119650,
 261689243,
 261469983,
 -1,
 -61542,
 261648110,
 119653,
 -1,
 261704834,
 119654,
 261885854,
 261639766,
 -1,
 -61539,
 261856240,
 119651,
 -1,
 261910135,
 119652,
 -61537,
 261854655,
 119648,
 -61536,
 262048956,
 119656,
 -1,
 262096183,
 119655,
 262340607,
 261408092,
 -1,
 262344613,
 262259412,
 -1,
 -61532,
 262332815,
 119658,
 -1,
 262365270,
 119659,
 262541224,
 262321951,
 -1,
 -61529,
 262500078,
 119662,
 -1,
 262556802,
 119663,
 262737835,
 262491734,
 -1,
 -61526,
 262708208,
 119660,
 -1,
 262762103,
 119661,
 -61524,
 262706623,
 119657,
 -61523,
 262900924,
 119665,
 -1,
 262948151,
 119664,
 263192575,
 261310815,
 -1,
 -61520,
 263109887,
 9013,
 -1,
 263137996,
 9012,
 263327681,
 261261535,
 -1,
 263393214,
 263307988,
 -1,
 263458748,
 263330168,
 -1,
 263524280,
 263446386,
 -1,
 -61514,
 263510647,
 8955,
 -61513,
 263560874,
 8957,
 -1,
 263617862,
 8954,
 263847935,
 263463712,
 -1,
 263851963,
 263753217,
 8883,
 -1,
 263784137,
 8885,
 -1,
 263816180,
 8715,
 -61507,
 263429168,
 8750,
 -1,
 264006283,
 9089,
 -61505,
 263352447,
 9740,
 -61504,
 264135408,
 9010,
 -1,
 264198141,
 10861,
 264376261,
 263290130,
 58,
 264503295,
 264306688,
 -1,
 -61500,
 264420395,
 8353,
 -1,
 264456524,
 8788,
 -61498,
 264353149,
 8792,
 -1,
 264589300,
 9904,
 264770014,
 223405038,
 -1,
 264835481,
 264745363,
 -1,
 264900782,
 264814082,
 -1,
 264966314,
 264850483,
 -1,
 265031647,
 264913031,
 1101,
 265097170,
 264997087,
 1085,
 265224191,
 265030691,
 -1,
 -61489,
 265143171,
 1226,
 -61488,
 265192683,
 1315,
 -61487,
 265248416,
 1224,
 -1,
 265304078,
 1187,
 265490391,
 265057112,
 1083,
 265617407,
 265423907,
 -1,
 -61483,
 265536387,
 1222,
 -61482,
 265585899,
 1313,
 -1,
 265641632,
 1299,
 265818073,
 265467679,
 1089,
 -1,
 265751767,
 1195,
 265949147,
 265791828,
 1088,
 -1,
 265883269,
 1167,
 266080221,
 265912293,
 1084,
 -1,
 266014316,
 1230,
 -61474,
 266030678,
 1092,
 -1,
 266144999,
 1261,
 266342389,
 264990856,
 -1,
 266407916,
 266310031,
 -1,
 266473451,
 266372244,
 -1,
 266538982,
 266417696,
 -1,
 -61468,
 266528833,
 1287,
 -61467,
 266563405,
 1283,
 -1,
 266616967,
 1281,
 -61465,
 266528833,
 1285,
 -61464,
 266782992,
 1295,
 -61463,
 266845514,
 1293,
 -61462,
 266898776,
 1291,
 -1,
 266959863,
 1289,
 -1,
 266446209,
 1153,
 267194354,
 266343796,
 1082,
 267321343,
 267127843,
 -1,
 -61457,
 267246359,
 1181,
 -61456,
 267305216,
 1183,
 -61455,
 267345568,
 1220,
 -1,
 267401230,
 1179,
 -61453,
 267172828,
 1135,
 -61452,
 267546445,
 1116,
 -1,
 267606379,
 1228,
 267784202,
 266297727,
 1080,
 267849728,
 267751823,
 1105,
 267976703,
 267829972,
 -1,
 267980799,
 267871316,
 -1,
 -61446,
 267969678,
 42579,
 -61445,
 268008408,
 1129,
 -61444,
 268058759,
 1125,
 -61443,
 268120486,
 42589,
 -61442,
 268183896,
 1133,
 -1,
 268244340,
 42583,
 -1,
 267916660,
 42567,
 268505092,
 267796615,
 1077,
 268632063,
 268438563,
 -1,
 -61437,
 268523205,
 1104,
 -1,
 268577737,
 1239,
 268767240,
 268438563,
 -1,
 -61434,
 268730427,
 1251,
 -61433,
 268785349,
 1117,
 -1,
 268843166,
 1253,
 269090815,
 268756969,
 1141,
 -1,
 268963128,
 1143,
 269160479,
 267761439,
 -1,
 269226004,
 269113483,
 -1,
 269291536,
 269195662,
 -1,
 269357071,
 269246847,
 1081,
 -1,
 269291116,
 1163,
 -1,
 269340234,
 1118,
 -61423,
 269278802,
 42647,
 -61422,
 269506729,
 1211,
 -61421,
 269561641,
 1097,
 -1,
 269620596,
 1096,
 269815834,
 269194016,
 -1,
 269881368,
 269762695,
 -1,
 -61417,
 269844453,
 42599,
 -1,
 269906776,
 42597,
 -61415,
 269859883,
 1100,
 -1,
 270022474,
 42595,
 270209052,
 269798049,
 1199,
 -1,
 270143071,
 1201,
 270340126,
 270151711,
 1241,
 -1,
 270273767,
 1243,
 -1,
 270288557,
 1165,
 270536747,
 269104672,
 -1,
 270602278,
 270526238,
 -1,
 270667811,
 270549127,
 1109,
 -1,
 270630084,
 42563,
 -61404,
 270657397,
 42633,
 -61403,
 270786130,
 42627,
 -1,
 270818088,
 1119,
 270995496,
 270561101,
 1106,
 -1,
 270972647,
 42569,
 -61399,
 270982738,
 42625,
 -61398,
 271096687,
 42605,
 -1,
 271138951,
 1076,
 271323193,
 270526238,
 -1,
 271388724,
 271276171,
 -1,
 271454259,
 271335559,
 1078,
 271581183,
 271387683,
 -1,
 271585330,
 271463968,
 -1,
 -61391,
 271540745,
 1245,
 -1,
 271600229,
 1175,
 -1,
 271526857,
 1218,
 -1,
 271441490,
 42629,
 271974399,
 271335559,
 1079,
 271978552,
 271846582,
 -1,
 -61385,
 271933961,
 1247,
 -1,
 271993445,
 1177,
 -1,
 271943151,
 42561,
 272240708,
 271311854,
 -1,
 272306238,
 272190027,
 1099,
 272433151,
 272239651,
 -1,
 -61379,
 272316574,
 1273,
 -1,
 272377525,
 42577,
 272568385,
 272242036,
 1103,
 -61376,
 272548564,
 1123,
 -1,
 272580743,
 1305,
 -61374,
 272551498,
 1102,
 -61373,
 272730335,
 42591,
 -1,
 272785791,
 1111,
 272961616,
 272220884,
 -1,
 273027146,
 272938783,
 -1,
 -61369,
 273014354,
 42639,
 -61368,
 273070232,
 42641,
 -61367,
 273111848,
 1115,
 -1,
 273170567,
 1094,
 273354830,
 272973959,
 1090,
 273481727,
 273288227,
 -1,
 -61363,
 273384683,
 42635,
 -1,
 273430542,
 1197,
 -61361,
 273342034,
 42637,
 -1,
 273559404,
 42643,
 273748060,
 272901750,
 -1,
 273813589,
 273683828,
 -1,
 273879124,
 273790326,
 1257,
 -1,
 273812711,
 1259,
 -1,
 273857332,
 1185,
 274075736,
 273768831,
 -1,
 -61353,
 274042276,
 42603,
 -1,
 274092786,
 1131,
 -61351,
 274064663,
 1110,
 -61350,
 274248668,
 42573,
 -61349,
 274299121,
 42587,
 -1,
 274350215,
 1073,
 274534502,
 273683828,
 1072,
 274600034,
 274475496,
 -1,
 274665568,
 274542444,
 1213,
 -1,
 274599127,
 1215,
 -61343,
 274618537,
 1193,
 -1,
 274743427,
 1249,
 274927717,
 274533411,
 -1,
 -61340,
 274872478,
 1235,
 -1,
 274934729,
 1233,
 -1,
 274889224,
 1311,
 275189871,
 274485987,
 -1,
 275255406,
 275143464,
 1075,
 275382271,
 275188771,
 -1,
 275386475,
 275300608,
 1171,
 -1,
 275316954,
 1275,
 -61332,
 275371273,
 1169,
 -61331,
 275481835,
 1173,
 -1,
 275527694,
 1271,
 -1,
 275214157,
 1107,
 275779703,
 275172938,
 1091,
 275845237,
 275713059,
 -1,
 275910772,
 275789344,
 -1,
 -61325,
 275880763,
 1267,
 -1,
 275931657,
 1265,
 -1,
 275873851,
 1263,
 276234239,
 275804296,
 1145,
 -1,
 276146758,
 1108,
 276303999,
 275732619,
 -1,
 276369534,
 276239732,
 1093,
 276435069,
 276302883,
 -1,
 -61317,
 276414720,
 1279,
 -61316,
 276455072,
 1277,
 -1,
 276510734,
 1203,
 -1,
 276409173,
 1098,
 -1,
 276356690,
 42645,
 276828296,
 276245726,
 -1,
 276893830,
 276781864,
 1095,
 277020671,
 276827171,
 -1,
 277024901,
 276903456,
 -1,
 -61308,
 276980233,
 1269,
 -1,
 277039717,
 1207,
 -1,
 277011223,
 1209,
 -61305,
 276856271,
 42585,
 -1,
 277229420,
 42631,
 277418127,
 276801876,
 -1,
 277483661,
 277368050,
 -1,
 -61301,
 277473141,
 1297,
 -61300,
 277538519,
 42581,
 -1,
 277561475,
 42565,
 -61298,
 277453707,
 1147,
 -1,
 277698729,
 1303,
 277876886,
 277389289,
 -1,
 277942420,
 277823623,
 1087,
 278069247,
 277875747,
 -1,
 -61293,
 277972203,
 1191,
 -1,
 278018062,
 1317,
 -61291,
 277920732,
 1137,
 -1,
 278142001,
 1231,
 278335643,
 277844367,
 1086,
 278401177,
 278299593,
 1121,
 -1,
 278335138,
 1149,
 -61286,
 278381268,
 1151,
 -1,
 278465767,
 1255,
 278663327,
 278295384,
 -1,
 -61283,
 278622029,
 1113,
 -61282,
 278687310,
 1127,
 -1,
 278747305,
 1301,
 278925474,
 278628575,
 -1,
 -61279,
 278884173,
 1114,
 -1,
 278940768,
 42575,
 279122085,
 278890170,
 -1,
 -61276,
 279074492,
 42571,
 -1,
 279131503,
 42601,
 -61274,
 279109202,
 1309,
 -61273,
 279304436,
 1074,
 -61272,
 279357258,
 1307,
 -61271,
 279408461,
 1112,
 -1,
 279466159,
 1139,
 279707647,
 264922271,
 -1,
 -61268,
 279626891,
 1205,
 -61267,
 279660296,
 1189,
 -1,
 279713160,
 1237,
 279908754,
 264842746,
 -1,
 279974286,
 279858227,
 -1,
 280039620,
 279920775,
 1069,
 280105143,
 280004831,
 1053,
 280231935,
 280038435,
 -1,
 -61260,
 280150915,
 1225,
 -61259,
 280200427,
 1314,
 -61258,
 280256160,
 1223,
 -1,
 280311822,
 1186,
 280498364,
 280064856,
 1051,
 280625151,
 280431651,
 -1,
 -61254,
 280544131,
 1221,
 -61253,
 280593643,
 1312,
 -1,
 280649376,
 1298,
 280826046,
 280475423,
 1057,
 -1,
 280759511,
 1194,
 280957120,
 280799572,
 1056,
 -1,
 280891013,
 1166,
 281088194,
 280920037,
 1052,
 -1,
 281022060,
 1229,
 -61245,
 281038422,
 1060,
 -1,
 281152743,
 1260,
 281350362,
 279998600,
 -1,
 281415889,
 281317775,
 -1,
 281481424,
 281379988,
 -1,
 281546955,
 281425440,
 -1,
 -61239,
 281536577,
 1286,
 -61238,
 281571149,
 1282,
 -1,
 281624711,
 1280,
 -61236,
 281536577,
 1284,
 -61235,
 281790736,
 1294,
 -61234,
 281853258,
 1292,
 -61233,
 281906520,
 1290,
 -1,
 281967607,
 1288,
 -1,
 281453953,
 1152,
 282202327,
 281351540,
 1050,
 282329087,
 282135587,
 -1,
 -61228,
 282254103,
 1180,
 -61227,
 282312960,
 1182,
 -61226,
 282353312,
 1219,
 -1,
 282408974,
 1178,
 -61224,
 282180572,
 1134,
 -61223,
 282554189,
 1036,
 -1,
 282614123,
 1227,
 282792175,
 281305471,
 1048,
 282857701,
 282759567,
 1025,
 282984447,
 282837716,
 -1,
 282988772,
 282879060,
 -1,
 -61217,
 282977422,
 42578,
 -61216,
 283016152,
 1128,
 -61215,
 283066503,
 1124,
 -61214,
 283128230,
 42588,
 -61213,
 283191640,
 1132,
 -1,
 283252084,
 42582,
 -1,
 282924404,
 42566,
 283513065,
 282804359,
 1045,
 283639807,
 283446307,
 -1,
 -61208,
 283530949,
 1024,
 -1,
 283585481,
 1238,
 283775213,
 283446307,
 -1,
 -61205,
 283738171,
 1250,
 -61204,
 283793093,
 1037,
 -1,
 283850910,
 1252,
 284098559,
 283764713,
 1140,
 -1,
 283970872,
 1142,
 284168452,
 282769183,
 -1,
 284233977,
 284121227,
 -1,
 284299509,
 284203406,
 -1,
 284365044,
 284254591,
 1049,
 -1,
 284298860,
 1162,
 -1,
 284347978,
 1038,
 -61194,
 284286546,
 42646,
 -61193,
 284514473,
 1210,
 -61192,
 284569385,
 1065,
 -1,
 284628340,
 1064,
 284823807,
 284201760,
 -1,
 284889341,
 284770439,
 -1,
 -61188,
 284852197,
 42598,
 -1,
 284914520,
 42596,
 -61186,
 284867627,
 1068,
 -1,
 285030218,
 42594,
 285217025,
 284805793,
 1198,
 -1,
 285150815,
 1200,
 285348099,
 285159455,
 1240,
 -1,
 285281511,
 1242,
 -1,
 285296301,
 1164,
 285544720,
 284112416,
 -1,
 285610251,
 285533982,
 -1,
 285675784,
 285556871,
 1029,
 -1,
 285637828,
 42562,
 -61175,
 285665141,
 42632,
 -61174,
 285793874,
 42626,
 -1,
 285825832,
 1039,
 286003469,
 285568845,
 1026,
 -1,
 285980391,
 42568,
 -61170,
 285990482,
 42624,
 -61169,
 286104431,
 42604,
 -1,
 286146695,
 1044,
 286331166,
 285533982,
 -1,
 286396697,
 286283915,
 -1,
 286462232,
 286343303,
 1046,
 286588927,
 286395427,
 -1,
 286593303,
 286471712,
 -1,
 -61162,
 286548489,
 1244,
 -1,
 286607973,
 1174,
 -1,
 286534601,
 1217,
 -1,
 286449234,
 42628,
 286982143,
 286343303,
 1047,
 286986525,
 286854326,
 -1,
 -61156,
 286941705,
 1246,
 -1,
 287001189,
 1176,
 -1,
 286950895,
 42560,
 287248681,
 286319598,
 -1,
 287314211,
 287197771,
 1067,
 287440895,
 287247395,
 -1,
 -61150,
 287324318,
 1272,
 -1,
 287385269,
 42576,
 287576358,
 287249780,
 1071,
 -61147,
 287556308,
 1122,
 -1,
 287588487,
 1304,
 -61145,
 287559242,
 1070,
 -61144,
 287738079,
 42590,
 -1,
 287793535,
 1031,
 287969589,
 287228628,
 -1,
 288035119,
 287946527,
 -1,
 -61140,
 288022098,
 42638,
 -61139,
 288077976,
 42640,
 -61138,
 288119592,
 1035,
 -1,
 288178311,
 1062,
 288362803,
 287981703,
 1058,
 288489471,
 288295971,
 -1,
 -61134,
 288392427,
 42634,
 -1,
 288438286,
 1196,
 -61132,
 288349778,
 42636,
 -1,
 288567148,
 42642,
 288756033,
 287909494,
 -1,
 288821562,
 288691572,
 -1,
 288887097,
 288798070,
 1256,
 -1,
 288820455,
 1258,
 -1,
 288865076,
 1184,
 289083709,
 288776575,
 -1,
 -61124,
 289050020,
 42602,
 -1,
 289100530,
 1130,
 -61122,
 289072407,
 1030,
 -61121,
 289256412,
 42572,
 -61120,
 289306865,
 42586,
 -1,
 289357959,
 1041,
 289542475,
 288691572,
 1040,
 289608007,
 289483240,
 -1,
 289673541,
 289550188,
 1212,
 -1,
 289606871,
 1214,
 -61114,
 289626281,
 1192,
 -1,
 289751171,
 1248,
 289935690,
 289541155,
 -1,
 -61111,
 289880222,
 1234,
 -1,
 289942473,
 1232,
 -1,
 289896968,
 1310,
 290197844,
 289493731,
 -1,
 290263379,
 290151208,
 1043,
 290390015,
 290196515,
 -1,
 290394448,
 290308352,
 1170,
 -1,
 290324698,
 1274,
 -61103,
 290379017,
 1168,
 -61102,
 290489579,
 1172,
 -1,
 290535438,
 1270,
 -1,
 290221901,
 1027,
 290787676,
 290180682,
 1059,
 290853210,
 290720803,
 -1,
 290918745,
 290797088,
 -1,
 -61096,
 290888507,
 1266,
 -1,
 290939401,
 1264,
 -1,
 290881595,
 1262,
 291241983,
 290812040,
 1144,
 -1,
 291154502,
 1028,
 291311972,
 290740363,
 -1,
 291377507,
 291247476,
 1061,
 291443042,
 291310627,
 -1,
 -61088,
 291422464,
 1278,
 -61087,
 291462816,
 1276,
 -1,
 291518478,
 1202,
 -1,
 291416917,
 1066,
 -1,
 291364434,
 42644,
 291836269,
 291253470,
 -1,
 291901803,
 291789608,
 1063,
 292028415,
 291834915,
 -1,
 292032874,
 291911200,
 -1,
 -61079,
 291987977,
 1268,
 -1,
 292047461,
 1206,
 -1,
 292018967,
 1208,
 -61076,
 291864015,
 42584,
 -1,
 292237164,
 42630,
 292426100,
 291809620,
 -1,
 292491634,
 292375794,
 -1,
 -61072,
 292480885,
 1296,
 -61071,
 292546263,
 42580,
 -1,
 292569219,
 42564,
 -61069,
 292461451,
 1146,
 -1,
 292706473,
 1302,
 292884857,
 292393359,
 1054,
 292950391,
 292848585,
 1120,
 -1,
 292884130,
 1148,
 -61064,
 292930260,
 1150,
 -1,
 293014759,
 1254,
 293212543,
 292855785,
 -1,
 293278078,
 293159047,
 1055,
 293404671,
 293211171,
 -1,
 -61059,
 293307627,
 1190,
 -1,
 293353486,
 1316,
 -1,
 293256156,
 1136,
 293605763,
 293172056,
 -1,
 -61055,
 293564237,
 1033,
 -61054,
 293629518,
 1126,
 -1,
 293689513,
 1300,
 293867910,
 293570783,
 -1,
 -61051,
 293826381,
 1034,
 -1,
 293882976,
 42574,
 294064521,
 293832378,
 -1,
 -61048,
 294016700,
 42570,
 -1,
 294073711,
 42600,
 -61046,
 294051410,
 1308,
 -61045,
 294246644,
 1042,
 -61044,
 294299466,
 1306,
 -61043,
 294350669,
 1032,
 -1,
 294408367,
 1138,
 294649855,
 279930015,
 -1,
 -61040,
 294569099,
 1204,
 -61039,
 294602504,
 1188,
 -1,
 294655368,
 1236,
 294850966,
 279869914,
 -1,
 -61036,
 294829521,
 7467,
 -61035,
 294887604,
 1216,
 -1,
 294946775,
 42606,
 -61033,
 294831920,
 1154,
 -61032,
 295084447,
 42623,
 -1,
 295137675,
 42622,
 295309789,
 264808061,
 -1,
 295375264,
 295289556,
 -1,
 -61028,
 295358026,
 67633,
 -61027,
 295408015,
 67632,
 -61026,
 295461247,
 67631,
 -61025,
 295518343,
 67630,
 -1,
 295572852,
 67629,
 295768486,
 295352095,
 -1,
 -61022,
 295751242,
 67628,
 -61021,
 295801231,
 67627,
 -61020,
 295854463,
 67626,
 -61019,
 295911559,
 67625,
 -1,
 295966068,
 67624,
 296161708,
 295741780,
 -1,
 -61016,
 296144458,
 67623,
 -61015,
 296194447,
 67622,
 -61014,
 296247679,
 67621,
 -61013,
 296304775,
 67620,
 -1,
 296359284,
 67619,
 296554930,
 296132585,
 -1,
 -61010,
 296537674,
 67618,
 -61009,
 296587663,
 67617,
 -61008,
 296640895,
 67616,
 -61007,
 296697991,
 67615,
 -1,
 296752500,
 67614,
 296948152,
 296519903,
 -1,
 -61004,
 296930890,
 67613,
 -61003,
 296980879,
 67612,
 -61002,
 297034111,
 67611,
 -61001,
 297091207,
 67610,
 -1,
 297145716,
 67609,
 297341374,
 296910821,
 -1,
 -60998,
 297324106,
 67608,
 -60997,
 297374095,
 67607,
 -60996,
 297427327,
 67606,
 -60995,
 297484423,
 67605,
 -1,
 297538932,
 67604,
 297734596,
 297300824,
 -1,
 -60992,
 297717322,
 67603,
 -60991,
 297767311,
 67602,
 -60990,
 297820543,
 67601,
 -60989,
 297877639,
 67600,
 -1,
 297932148,
 67599,
 298127818,
 297693320,
 -1,
 -60986,
 298110538,
 67598,
 -60985,
 298160527,
 67597,
 -60984,
 298213759,
 67596,
 -60983,
 298270855,
 67595,
 -1,
 298325364,
 67594,
 298521039,
 298114312,
 -1,
 -60980,
 298488207,
 67637,
 -60979,
 298541439,
 67636,
 -60978,
 298598535,
 67635,
 -1,
 298653044,
 67634,
 298848722,
 298510110,
 -1,
 -60975,
 298815887,
 67647,
 -1,
 298849652,
 67644,
 299045333,
 298836740,
 -1,
 -60972,
 298991751,
 67640,
 -1,
 299046260,
 67639,
 299241944,
 299003689,
 -1,
 -60969,
 299209103,
 67592,
 -1,
 299242868,
 67589,
 -60967,
 299224650,
 67588,
 -60966,
 299405711,
 67587,
 -60965,
 299458943,
 67586,
 -60964,
 299516039,
 67585,
 -1,
 299570548,
 67584,
 -1,
 295271138,
 9005,
 299832160,
 264727576,
 -1,
 299897693,
 299791954,
 -1,
 299963212,
 299841058,
 -1,
 300028465,
 299917695,
 -1,
 300093998,
 299972594,
 -1,
 300159474,
 300070687,
 -1,
 300225000,
 300142154,
 -1,
 -60954,
 300196647,
 12972,
 -60953,
 300255455,
 12944,
 -1,
 300314009,
 12956,
 300487147,
 300204756,
 -1,
 -60950,
 300470282,
 12971,
 -1,
 300520053,
 12945,
 300683758,
 300433543,
 -1,
 -60947,
 300669315,
 12934,
 -1,
 300692441,
 12953,
 -60945,
 300655038,
 12949,
 -60944,
 300847726,
 12947,
 -60943,
 300904174,
 12933,
 -1,
 300953554,
 12870,
 301142521,
 300109398,
 -1,
 301208055,
 301097343,
 -1,
 -60939,
 301193460,
 12932,
 -60938,
 301247364,
 12939,
 -1,
 301304206,
 12950,
 -60936,
 301177840,
 12931,
 -1,
 301418061,
 12955,
 301601280,
 301115732,
 -1,
 301666815,
 301547655,
 -1,
 301732350,
 301643551,
 -1,
 -60931,
 301712084,
 12961,
 -1,
 301767791,
 12974,
 -1,
 301693641,
 12970,
 -1,
 301622499,
 12968,
 302060038,
 301563877,
 -1,
 302125572,
 302006407,
 -1,
 -60925,
 302105515,
 12942,
 -1,
 302135651,
 12969,
 -60923,
 302093993,
 12938,
 -1,
 302258852,
 12954,
 302453259,
 302006407,
 -1,
 -60920,
 302441277,
 12957,
 -60919,
 302485383,
 12973,
 -60918,
 302540003,
 12935,
 -1,
 302588620,
 12943,
 302780945,
 302394590,
 -1,
 302846480,
 302748047,
 -1,
 -60914,
 302822760,
 12963,
 -60913,
 302884673,
 12962,
 -1,
 302943294,
 12951,
 -1,
 302794800,
 12965,
 303174165,
 302760660,
 -1,
 -60909,
 303161743,
 12929,
 -60908,
 303194198,
 12930,
 -1,
 303253233,
 12937,
 303436314,
 303139039,
 -1,
 303501849,
 303391103,
 -1,
 -60904,
 303467267,
 12936,
 -1,
 303518942,
 12976,
 -1,
 303439043,
 12948,
 303763998,
 303395672,
 -1,
 -60900,
 303734509,
 12966,
 -60899,
 303776666,
 12967,
 -1,
 303830640,
 12952,
 304026145,
 303750408,
 -1,
 -60896,
 303994522,
 12941,
 -1,
 304030890,
 12940,
 304222756,
 303984776,
 -1,
 -60893,
 304192271,
 12871,
 -1,
 304244746,
 12869,
 304419367,
 304175243,
 -1,
 -60890,
 304374992,
 12964,
 -1,
 304424421,
 12946,
 304615978,
 304354676,
 -1,
 -60887,
 304598092,
 12959,
 -1,
 304643198,
 12975,
 -60885,
 304588981,
 12868,
 -60884,
 304785015,
 12958,
 -60883,
 304846271,
 12928,
 -1,
 304901568,
 12960,
 305135615,
 300073937,
 -1,
 -60880,
 305047892,
 127276,
 -1,
 305081566,
 127275,
 305271402,
 299987800,
 -1,
 305336937,
 305210651,
 -1,
 305402446,
 305315338,
 -1,
 -60875,
 305391390,
 9449,
 -60874,
 305456110,
 9448,
 -60873,
 305521412,
 9447,
 -60872,
 305585416,
 9446,
 -60871,
 305649582,
 9445,
 -60870,
 305712714,
 9444,
 -60869,
 305775316,
 9443,
 -60868,
 305837855,
 9442,
 -60867,
 305899860,
 9441,
 -60866,
 305964868,
 9440,
 -60865,
 306028521,
 9439,
 -60864,
 306090383,
 9438,
 -60863,
 306153695,
 9437,
 -60862,
 306216933,
 9436,
 -60861,
 306279256,
 9435,
 -60860,
 306344072,
 9434,
 -60859,
 306409257,
 9433,
 -60858,
 306471295,
 9432,
 -60857,
 306534539,
 9431,
 -60856,
 306598627,
 9430,
 -60855,
 306662998,
 9429,
 -60854,
 306724999,
 9428,
 -60853,
 306787872,
 9427,
 -60852,
 306851038,
 9426,
 -60851,
 306914934,
 9425,
 -1,
 306976116,
 9424,
 307232767,
 305344004,
 -1,
 -60848,
 307160862,
 9423,
 -60847,
 307225582,
 9422,
 -60846,
 307290884,
 9421,
 -60845,
 307354888,
 9420,
 -60844,
 307419054,
 9419,
 -60843,
 307482186,
 9418,
 -60842,
 307544788,
 9417,
 -60841,
 307607327,
 9416,
 -60840,
 307669332,
 9415,
 -60839,
 307734340,
 9414,
 -60838,
 307797993,
 9413,
 -60837,
 307859855,
 9412,
 -60836,
 307923167,
 9411,
 -60835,
 307986405,
 9410,
 -60834,
 308048728,
 9409,
 -60833,
 308113544,
 9408,
 -60832,
 308178729,
 9407,
 -60831,
 308240767,
 9406,
 -60830,
 308304011,
 9405,
 -60829,
 308368099,
 9404,
 -60828,
 308432470,
 9403,
 -60827,
 308494471,
 9402,
 -60826,
 308557344,
 9401,
 -60825,
 308620510,
 9400,
 -60824,
 308684406,
 9399,
 -1,
 308745588,
 9398,
 -1,
 305285865,
 10688,
 309007030,
 305238079,
 -1,
 309072530,
 308986580,
 -1,
 309138046,
 309059154,
 -1,
 309203581,
 309104645,
 9331,
 309329919,
 309133312,
 -1,
 309334642,
 309248724,
 -1,
 -60815,
 309322127,
 12882,
 -1,
 309354582,
 12883,
 309531253,
 309311263,
 -1,
 -60812,
 309489390,
 12886,
 -1,
 309546114,
 12887,
 309727864,
 309499181,
 -1,
 -60809,
 309674119,
 12881,
 -1,
 309723719,
 12873,
 309924475,
 309677654,
 -1,
 -60806,
 309894128,
 12884,
 -1,
 309948023,
 12885,
 -60804,
 309890236,
 12889,
 -1,
 310068535,
 12888,
 -1,
 309165966,
 9323,
 310317712,
 309091756,
 -1,
 310383247,
 310305774,
 12890,
 310509567,
 310312960,
 -1,
 310514308,
 310428372,
 -1,
 -60797,
 310501775,
 12892,
 -1,
 310534230,
 12893,
 310710919,
 310490911,
 -1,
 -60794,
 310669038,
 12977,
 -1,
 310725762,
 12978,
 310907530,
 310678829,
 -1,
 -60791,
 310853767,
 12891,
 -1,
 310903367,
 12874,
 311104141,
 310857302,
 -1,
 -60788,
 311073776,
 12894,
 -1,
 311127671,
 12895,
 -60786,
 311069884,
 12980,
 -1,
 311248183,
 12979,
 -1,
 310330188,
 9324,
 311558143,
 310265585,
 9321,
 -1,
 311428687,
 12872,
 311628457,
 309022294,
 -1,
 311693989,
 311595407,
 -1,
 311759524,
 311670374,
 12981,
 311885823,
 311689216,
 -1,
 311890585,
 311804628,
 -1,
 -60776,
 311878031,
 12983,
 -1,
 311910486,
 12984,
 312087196,
 311867167,
 -1,
 -60773,
 312045294,
 12987,
 -1,
 312102018,
 12988,
 312283807,
 312055085,
 -1,
 -60770,
 312230023,
 12982,
 -1,
 312279623,
 12875,
 312480418,
 312233558,
 -1,
 -60767,
 312450032,
 12985,
 -1,
 312503927,
 12986,
 -60765,
 312446140,
 12990,
 -1,
 312624439,
 12989,
 -1,
 311744075,
 9325,
 312934399,
 311649385,
 -1,
 312939176,
 312861678,
 12991,
 -1,
 312870479,
 12876,
 -1,
 312886092,
 9326,
 313135792,
 311605023,
 -1,
 313201325,
 313093884,
 -1,
 -60756,
 313189371,
 12877,
 -1,
 313213772,
 9327,
 313458687,
 313150634,
 -1,
 -60753,
 313385979,
 12878,
 -1,
 313410380,
 9328,
 313594549,
 313081991,
 -1,
 313660084,
 313550051,
 -1,
 -60749,
 313648123,
 12879,
 -1,
 313672524,
 9329,
 -1,
 313621024,
 9322,
 -1,
 313560257,
 9330,
 313987827,
 308965512,
 -1,
 314053360,
 313926793,
 -1,
 314118846,
 314032852,
 -1,
 -60742,
 314101322,
 13025,
 -60741,
 314151311,
 13027,
 -60740,
 314204543,
 13024,
 -60739,
 314261639,
 13026,
 -1,
 314316148,
 13023,
 314512068,
 314095391,
 -1,
 -60736,
 314494538,
 13020,
 -60735,
 314544527,
 13022,
 -60734,
 314597759,
 13019,
 -60733,
 314654855,
 13021,
 -1,
 314709364,
 13018,
 314905290,
 314485076,
 -1,
 -60730,
 314887754,
 13048,
 -60729,
 314937743,
 13050,
 -60728,
 314990975,
 13047,
 -60727,
 315048071,
 13049,
 -1,
 315102580,
 13046,
 315298512,
 314869983,
 -1,
 -60724,
 315280970,
 13030,
 -60723,
 315330959,
 13032,
 -60722,
 315384191,
 13029,
 -60721,
 315441287,
 13031,
 -1,
 315495796,
 13028,
 315691734,
 315260901,
 -1,
 -60718,
 315674186,
 13040,
 -60717,
 315724175,
 13042,
 -60716,
 315777407,
 13039,
 -60715,
 315834503,
 13041,
 -1,
 315889012,
 13038,
 316084956,
 315650184,
 -1,
 -60712,
 316067402,
 13015,
 -60711,
 316117391,
 13017,
 -60710,
 316170623,
 13014,
 -60709,
 316227719,
 13016,
 -1,
 316282228,
 13013,
 316478178,
 316037259,
 -1,
 -60706,
 316460618,
 13035,
 -60705,
 316510607,
 13037,
 -60704,
 316563839,
 13034,
 -60703,
 316620935,
 13036,
 -1,
 316675444,
 13033,
 316871399,
 316464392,
 -1,
 -60700,
 316838287,
 13054,
 -60699,
 316891519,
 13052,
 -60698,
 316948615,
 13053,
 -1,
 317003124,
 13051,
 317199083,
 316859374,
 -1,
 -60695,
 317181514,
 13044,
 -60694,
 317231503,
 13045,
 -1,
 317265268,
 13043,
 -60692,
 317181514,
 13010,
 -60691,
 317428111,
 13012,
 -60690,
 317481343,
 13009,
 -60689,
 317538439,
 13011,
 -1,
 317592948,
 13008,
 317849599,
 314022033,
 -1,
 -60686,
 317747321,
 12925,
 -1,
 317796178,
 12924,
 317985561,
 313940107,
 -1,
 318051095,
 317923017,
 -1,
 318116602,
 318030548,
 -1,
 318182136,
 318072245,
 12898,
 -1,
 318111746,
 12912,
 318373887,
 318135522,
 12907,
 -1,
 318242818,
 12921,
 318444287,
 318087145,
 -1,
 318509821,
 318399558,
 12901,
 -1,
 318439426,
 12915,
 318701567,
 318463195,
 12908,
 -1,
 318570498,
 12922,
 318771972,
 318402696,
 -1,
 318837506,
 318730019,
 12896,
 -1,
 318767106,
 12910,
 319029247,
 318790868,
 12906,
 -1,
 318898178,
 12920,
 319099657,
 318713054,
 -1,
 319165191,
 319054907,
 12904,
 -1,
 319094786,
 12918,
 319356927,
 319118535,
 12905,
 -1,
 319225858,
 12919,
 319427341,
 319054912,
 12903,
 319553535,
 319356928,
 -1,
 -60660,
 319475274,
 12926,
 -1,
 319493492,
 12917,
 319689487,
 319405322,
 12902,
 -1,
 319619074,
 12916,
 319820561,
 319663703,
 12899,
 -1,
 319750146,
 12913,
 319951635,
 319786124,
 12897,
 -1,
 319881218,
 12911,
 320082709,
 319915310,
 12900,
 -1,
 320012290,
 12914,
 320274431,
 320036046,
 12909,
 -1,
 320143362,
 12923,
 -60648,
 318019842,
 9097,
 -1,
 320291294,
 10162,
 320475950,
 317928992,
 -1,
 320541484,
 320430463,
 -1,
 320607017,
 320492987,
 -1,
 320672543,
 320586452,
 -1,
 -60642,
 320659855,
 9313,
 -1,
 320692310,
 9314,
 320869154,
 320648991,
 -1,
 -60639,
 320827118,
 9317,
 -1,
 320883842,
 9318,
 321065765,
 320818774,
 -1,
 -60636,
 321035248,
 9315,
 -1,
 321089143,
 9316,
 -60634,
 321054613,
 9450,
 -60633,
 321230271,
 9312,
 -60632,
 321293500,
 9320,
 -1,
 321340727,
 9319,
 321585151,
 320592892,
 -1,
 -60629,
 321484162,
 8856,
 -1,
 321545605,
 10808,
 -60627,
 320510563,
 8857,
 -1,
 321659732,
 8861,
 321852211,
 320446441,
 -1,
 -60624,
 321821238,
 12342,
 -60623,
 321879909,
 8853,
 -60622,
 321931789,
 10681,
 -1,
 321986801,
 10679,
 322179896,
 321838344,
 -1,
 322245431,
 322133467,
 -1,
 -60618,
 322224206,
 10026,
 -1,
 322251839,
 10686,
 -1,
 322234142,
 127278,
 322507579,
 322159316,
 -1,
 -60614,
 322481666,
 9098,
 -1,
 322528956,
 8855,
 322704190,
 322480468,
 -1,
 -60611,
 322660554,
 8858,
 -1,
 322718947,
 10680,
 322900801,
 322666469,
 -1,
 -60608,
 322883901,
 10806,
 -1,
 322923171,
 8854,
 323097412,
 322841822,
 -1,
 -60605,
 323073203,
 9938,
 -1,
 323106336,
 127277,
 323294023,
 323032436,
 -1,
 -60602,
 323272836,
 8859,
 -1,
 323325860,
 10684,
 -60600,
 323279452,
 10678,
 -60599,
 323458823,
 10050,
 -60598,
 323507959,
 10689,
 -60597,
 323569996,
 8860,
 -1,
 323628095,
 10687,
 323878911,
 299892736,
 -1,
 323883868,
 323805042,
 -1,
 323949393,
 323867737,
 -1,
 -60592,
 323923908,
 9684,
 -1,
 323967390,
 9683,
 324146004,
 323925791,
 -1,
 -60589,
 324129809,
 10683,
 -1,
 324174176,
 10690,
 324342615,
 324105048,
 -1,
 -60586,
 324312908,
 9682,
 -1,
 324355008,
 9680,
 -60584,
 324328135,
 9677,
 -60583,
 324521424,
 10691,
 -60582,
 324579108,
 9681,
 -60581,
 324624088,
 10677,
 -1,
 324672436,
 9685,
 -1,
 323828330,
 10682,
 324993023,
 299880010,
 -1,
 -60577,
 324895866,
 94,
 -1,
 324957699,
 10768,
 325129273,
 299784331,
 -1,
 325194693,
 325075079,
 -1,
 325260228,
 325170200,
 -1,
 325325685,
 325239508,
 -1,
 325391211,
 325302047,
 -1,
 -60570,
 325375918,
 5096,
 -60569,
 325439050,
 5095,
 -60568,
 325489039,
 5094,
 -60567,
 325542271,
 5093,
 -60566,
 325599367,
 5092,
 -1,
 325653876,
 5091,
 325849970,
 325350232,
 -1,
 -60563,
 325834670,
 5090,
 -60562,
 325897802,
 5089,
 -60561,
 325947791,
 5088,
 -60560,
 326001023,
 5087,
 -60559,
 326058119,
 5086,
 -1,
 326112628,
 5085,
 -60557,
 325804415,
 5080,
 -60556,
 326254727,
 5078,
 -1,
 326309236,
 5076,
 326505340,
 325302047,
 5069,
 -60553,
 326490030,
 5074,
 -60552,
 326553162,
 5073,
 -60551,
 326603151,
 5072,
 -60550,
 326656383,
 5071,
 -60549,
 326713479,
 5070,
 -1,
 326767988,
 5068,
 326964100,
 326469855,
 -1,
 327029631,
 326899060,
 5054,
 -1,
 326981771,
 5056,
 -60544,
 327014318,
 5061,
 -60543,
 327142986,
 5060,
 -60542,
 327192975,
 5059,
 -60541,
 327246207,
 5058,
 -1,
 327303303,
 5057,
 327488396,
 326916235,
 -1,
 -60538,
 327473070,
 5042,
 -60537,
 327536202,
 5041,
 -60536,
 327586191,
 5040,
 -60535,
 327649595,
 5055,
 -60534,
 327704959,
 5039,
 -60533,
 327762055,
 5038,
 -1,
 327816564,
 5037,
 328012692,
 327431712,
 -1,
 -60530,
 327997358,
 5083,
 -60529,
 328060490,
 5082,
 -60528,
 328110479,
 5081,
 -60527,
 328168365,
 5084,
 -60526,
 328229247,
 5079,
 -60525,
 328286343,
 5077,
 -1,
 328340852,
 5075,
 328536987,
 328000494,
 -1,
 -60522,
 328521646,
 5108,
 -60521,
 328584778,
 5107,
 -60520,
 328634767,
 5106,
 -60519,
 328687999,
 5105,
 -60518,
 328745095,
 5104,
 -1,
 328799604,
 5103,
 328995746,
 328523016,
 -1,
 -60515,
 328980398,
 5102,
 -60514,
 329043530,
 5101,
 -60513,
 329093519,
 5100,
 -60512,
 329146751,
 5099,
 -60511,
 329203847,
 5098,
 -1,
 329258356,
 5097,
 329454505,
 328968129,
 -1,
 -60508,
 329439150,
 5067,
 -60507,
 329502282,
 5066,
 -60506,
 329552271,
 5065,
 -60505,
 329605503,
 5064,
 -60504,
 329662599,
 5063,
 -1,
 329717108,
 5062,
 329913264,
 329413464,
 -1,
 -60501,
 329897902,
 5048,
 -60500,
 329961034,
 5047,
 -60499,
 330011023,
 5046,
 -60498,
 330064255,
 5045,
 -60497,
 330121351,
 5044,
 -1,
 330175860,
 5043,
 330372023,
 329863907,
 -1,
 -60494,
 330356654,
 5036,
 -60493,
 330419786,
 5035,
 -60492,
 330469775,
 5034,
 -60491,
 330523007,
 5033,
 -60490,
 330580103,
 5032,
 -1,
 330634612,
 5030,
 330830781,
 330334181,
 -1,
 -60487,
 330813002,
 5053,
 -60486,
 330862991,
 5052,
 -60485,
 330916223,
 5051,
 -60484,
 330973319,
 5050,
 -1,
 331027828,
 5049,
 -60482,
 330815406,
 5029,
 -60481,
 331206218,
 5028,
 -60480,
 331256207,
 5027,
 -60479,
 331313311,
 5031,
 -60478,
 331374975,
 5026,
 -60477,
 331432071,
 5025,
 -1,
 331486580,
 5024,
 -1,
 325202216,
 10003,
 331748405,
 325129588,
 -1,
 331813939,
 331710439,
 -1,
 331879434,
 331774426,
 -1,
 331944916,
 331829298,
 -1,
 332010443,
 331909343,
 43590,
 -1,
 331961059,
 43586,
 -60468,
 331998190,
 43592,
 -60467,
 332120788,
 43589,
 -60466,
 332185503,
 43595,
 -60465,
 332245332,
 43593,
 -60464,
 332308457,
 43591,
 -60463,
 332362584,
 43594,
 -60462,
 332427400,
 43584,
 -60461,
 332485347,
 43585,
 -1,
 332541730,
 43588,
 332731358,
 331909343,
 -1,
 332796889,
 332683403,
 -1,
 -60457,
 332779534,
 43536,
 -60456,
 332820267,
 43538,
 -1,
 332862836,
 43537,
 333059036,
 332747491,
 -1,
 -60453,
 333041678,
 43530,
 -1,
 333059444,
 43531,
 -60451,
 333041678,
 43543,
 -1,
 333190516,
 43544,
 333386722,
 332701673,
 -1,
 -60448,
 333357134,
 43547,
 -60447,
 333404329,
 43548,
 -1,
 333452660,
 43546,
 333648870,
 333329952,
 -1,
 -60444,
 333600937,
 43542,
 -60443,
 333657739,
 43545,
 -1,
 333714804,
 43541,
 333911018,
 333588086,
 -1,
 -60440,
 333863081,
 43550,
 -60439,
 333915816,
 43553,
 -1,
 333976948,
 43549,
 334173165,
 333890260,
 -1,
 -60436,
 334125225,
 43540,
 -1,
 334173556,
 43539,
 334369776,
 334149407,
 -1,
 -60433,
 334346137,
 43558,
 -1,
 334370164,
 43559,
 334566387,
 334331877,
 -1,
 -60430,
 334549006,
 43551,
 -1,
 334566772,
 43552,
 334762998,
 334524552,
 -1,
 -60427,
 334715049,
 43527,
 -1,
 334763380,
 43526,
 334959609,
 334720809,
 -1,
 -60424,
 334911657,
 43535,
 -1,
 334959988,
 43534,
 335156220,
 334910179,
 -1,
 -60421,
 335108265,
 43529,
 -1,
 335156596,
 43528,
 335352831,
 335097634,
 -1,
 -60418,
 335304873,
 43533,
 -1,
 335353204,
 43532,
 335549441,
 335287668,
 43520,
 -1,
 335503743,
 43524,
 -60414,
 335537194,
 43554,
 -60413,
 335665084,
 43557,
 -60412,
 335728202,
 43522,
 -60411,
 335784367,
 43555,
 -60410,
 335843727,
 43525,
 -60409,
 335901613,
 43556,
 -60408,
 335962495,
 43521,
 -60407,
 336025769,
 43560,
 -1,
 336085127,
 43523,
 336270358,
 331865270,
 -1,
 336335887,
 336205172,
 -1,
 -60403,
 336318026,
 43569,
 -60402,
 336355711,
 43568,
 -1,
 336401780,
 43561,
 336598033,
 336318026,
 43565,
 -1,
 336543879,
 43570,
 336729107,
 336564623,
 43567,
 -1,
 336674951,
 43566,
 336860181,
 336683391,
 43562,
 -1,
 336814463,
 43563,
 -1,
 336807201,
 43564,
 337056804,
 336214424,
 -1,
 337122330,
 337035988,
 -1,
 -60391,
 337109391,
 43602,
 -1,
 337141846,
 43603,
 337318941,
 337098527,
 -1,
 -60388,
 337276654,
 43606,
 -1,
 337333378,
 43607,
 337515552,
 337268310,
 -1,
 -60385,
 337484784,
 43604,
 -1,
 337538679,
 43605,
 -60383,
 337504149,
 43600,
 -60382,
 337679807,
 43601,
 -60381,
 337743036,
 43609,
 -1,
 337790263,
 43608,
 337974317,
 336999058,
 -1,
 338039849,
 337924146,
 -1,
 -60377,
 338004919,
 43587,
 -60376,
 338067429,
 43596,
 -1,
 338122891,
 43597,
 -60374,
 338027562,
 43571,
 -60373,
 338287920,
 43574,
 -60372,
 338340271,
 43572,
 -1,
 338391981,
 43573,
 338624511,
 337946363,
 -1,
 338629681,
 338507296,
 -1,
 -60368,
 338598755,
 43614,
 -1,
 338632256,
 43613,
 -60366,
 338611033,
 43615,
 -1,
 338804514,
 43612,
 -60364,
 331786712,
 8256,
 -1,
 338913668,
 9939,
 339088440,
 331702655,
 -1,
 -60361,
 339063866,
 9911,
 -1,
 339085790,
 9767,
 -1,
 339072461,
 9962,
 339350608,
 325088088,
 -1,
 339416143,
 339317135,
 -1,
 339481670,
 339392664,
 -1,
 339547205,
 339424802,
 -1,
 339612738,
 339526008,
 -1,
 339678272,
 339583718,
 10960,
 -1,
 339609289,
 10962,
 339869695,
 339618830,
 10959,
 -1,
 339740361,
 10961,
 339940420,
 339595924,
 10828,
 -1,
 339870068,
 10832,
 -1,
 339896919,
 10829,
 -1,
 339479551,
 8272,
 340202574,
 339423591,
 -1,
 340268106,
 340143326,
 -1,
 -60343,
 340235892,
 8754,
 -1,
 340295088,
 10561,
 -60341,
 340249136,
 8631,
 -60340,
 340432678,
 8635,
 -60339,
 340486595,
 8753,
 -1,
 340546449,
 10227,
 -1,
 340185082,
 9729,
 -1,
 339362100,
 9114,
 340857948,
 339296391,
 -1,
 340923480,
 340823849,
 -1,
 340989015,
 340896644,
 -1,
 341054550,
 340949746,
 -1,
 -60331,
 341024475,
 65098,
 -1,
 341081640,
 65102,
 -1,
 340985246,
 8452,
 -1,
 340920869,
 162,
 341382235,
 340867211,
 -1,
 -60326,
 341343255,
 184,
 -1,
 341379621,
 8373,
 -1,
 341355773,
 9907,
 341704703,
 340830548,
 -1,
 341709925,
 341613089,
 -1,
 341775457,
 341656178,
 -1,
 -60320,
 341754440,
 9876,
 -1,
 341805896,
 127370,
 341972068,
 341706298,
 -1,
 -60317,
 341933468,
 9768,
 -1,
 341995475,
 9769,
 -1,
 341928117,
 9932,
 -1,
 341694370,
 8354,
 342302301,
 32741,
 -1,
 342366592,
 342234484,
 -1,
 342431912,
 342345352,
 -1,
 342496776,
 342406943,
 -1,
 342562268,
 342433546,
 -1,
 342627681,
 342502086,
 -1,
 342693088,
 342584736,
 -1,
 342758562,
 342670732,
 -1,
 342824050,
 342728681,
 120421,
 -60304,
 342801372,
 120769,
 -60303,
 342843775,
 120761,
 -1,
 342908041,
 120767,
 343086197,
 342803156,
 120425,
 -60300,
 343039070,
 120753,
 -1,
 343090575,
 120765,
 343282809,
 343052687,
 120420,
 343408639,
 343244773,
 -1,
 -60296,
 343302923,
 120760,
 -1,
 343360672,
 120770,
 343544956,
 343228551,
 120410,
 -60293,
 343524117,
 120752,
 -1,
 343582417,
 120750,
 343741566,
 343533342,
 120431,
 -1,
 343690072,
 120751,
 343872640,
 343728900,
 120429,
 -1,
 343826815,
 120759,
 344003714,
 343854666,
 120426,
 -1,
 343975633,
 120766,
 344134788,
 343979807,
 120424,
 -1,
 344089984,
 120764,
 344265862,
 344107348,
 120423,
 -1,
 344219231,
 120762,
 344396936,
 344230111,
 120419,
 -1,
 344378954,
 120758,
 344528010,
 344358885,
 120418,
 -1,
 344510026,
 120757,
 344659084,
 344486744,
 120417,
 -1,
 344595646,
 120756,
 344790158,
 344617096,
 120416,
 -1,
 344727589,
 120755,
 344921232,
 344744319,
 120414,
 -1,
 344889990,
 120754,
 345052306,
 344871651,
 120412,
 -1,
 344988906,
 120748,
 345183380,
 345001558,
 120411,
 -1,
 345139144,
 120763,
 345314454,
 345126432,
 120409,
 -1,
 345261608,
 120749,
 345445528,
 345255134,
 120408,
 -1,
 345398409,
 120768,
 345576602,
 345384566,
 120407,
 -1,
 345525080,
 120747,
 345707676,
 345511284,
 120406,
 -1,
 345669344,
 120746,
 -60259,
 345695214,
 120430,
 -60258,
 345824520,
 120428,
 -60257,
 345888686,
 120427,
 -60256,
 345941828,
 120422,
 -60255,
 345993001,
 120415,
 -1,
 346052747,
 120413,
 346232023,
 342699485,
 -1,
 346297511,
 346211028,
 120399,
 346363046,
 346250334,
 120727,
 -1,
 346294932,
 120737,
 -1,
 346301839,
 120739,
 346559659,
 346267625,
 120395,
 -60247,
 346536924,
 120743,
 -60246,
 346579327,
 120735,
 -1,
 346643593,
 120741,
 346821807,
 346526095,
 120394,
 346947583,
 346783717,
 -1,
 -60242,
 346841867,
 120734,
 -1,
 346899616,
 120744,
 347083954,
 346767495,
 120384,
 -60239,
 347063061,
 120726,
 -1,
 347121361,
 120724,
 347280564,
 347072286,
 120405,
 -1,
 347229016,
 120725,
 347411638,
 347267844,
 120403,
 -1,
 347365759,
 120733,
 347542712,
 347393610,
 120400,
 -1,
 347514577,
 120740,
 347673786,
 347518751,
 120398,
 -1,
 347628928,
 120738,
 347804860,
 347646292,
 120397,
 -1,
 347758175,
 120736,
 347935934,
 347769055,
 120393,
 -1,
 347917898,
 120732,
 348067008,
 347897829,
 120392,
 -1,
 348048970,
 120731,
 348198082,
 348025688,
 120391,
 -1,
 348134590,
 120730,
 348329156,
 348156040,
 120390,
 -1,
 348266533,
 120729,
 348460230,
 348283263,
 120388,
 -1,
 348428934,
 120728,
 348591304,
 348410595,
 120386,
 -1,
 348527850,
 120722,
 348722378,
 348534304,
 120383,
 -1,
 348669480,
 120723,
 348853452,
 348663006,
 120382,
 -1,
 348806281,
 120742,
 348984526,
 348792438,
 120381,
 -1,
 348932952,
 120721,
 349115600,
 348919156,
 120380,
 -1,
 349077216,
 120720,
 -60207,
 349103086,
 120404,
 -60206,
 349232392,
 120402,
 -60205,
 349296558,
 120401,
 -60204,
 349349700,
 120396,
 -60203,
 349400873,
 120389,
 -60202,
 349460619,
 120387,
 -1,
 349523542,
 120385,
 349705435,
 346202089,
 -1,
 -60199,
 349659589,
 120777,
 -60198,
 349723802,
 120775,
 -1,
 349774545,
 120771,
 -60196,
 349685409,
 120773,
 -60195,
 349941230,
 120776,
 -60194,
 349997396,
 120745,
 -60193,
 350056732,
 120774,
 -1,
 350111958,
 120772,
 350295317,
 342670732,
 -1,
 350360805,
 350265321,
 120317,
 -60189,
 350338012,
 120711,
 -60188,
 350380415,
 120703,
 -1,
 350444681,
 120709,
 350622952,
 350339796,
 120321,
 -60185,
 350575710,
 120695,
 -1,
 350627215,
 120707,
 350819564,
 350589327,
 120316,
 350945279,
 350781413,
 -1,
 -60181,
 350839563,
 120702,
 -1,
 350897312,
 120712,
 351081711,
 350765191,
 120306,
 -60178,
 351060757,
 120694,
 -1,
 351119057,
 120692,
 351278321,
 351069982,
 120327,
 -1,
 351226712,
 120693,
 351409395,
 351265540,
 120325,
 -1,
 351363455,
 120701,
 351540469,
 351391306,
 120322,
 -1,
 351512273,
 120708,
 351671543,
 351516447,
 120320,
 -1,
 351626624,
 120706,
 351802617,
 351643988,
 120319,
 -1,
 351755871,
 120704,
 351933691,
 351766751,
 120315,
 -1,
 351915594,
 120700,
 352064765,
 351895525,
 120314,
 -1,
 352046666,
 120699,
 352195839,
 352023384,
 120313,
 -1,
 352132286,
 120698,
 352326913,
 352153736,
 120312,
 -1,
 352264229,
 120697,
 352457987,
 352280959,
 120310,
 -1,
 352426630,
 120696,
 352589061,
 352408291,
 120308,
 -1,
 352525546,
 120690,
 352720135,
 352538198,
 120307,
 -1,
 352675784,
 120705,
 352851209,
 352663072,
 120305,
 -1,
 352798248,
 120691,
 352982283,
 352791774,
 120304,
 -1,
 352935049,
 120710,
 353113357,
 352921206,
 120303,
 -1,
 353061720,
 120689,
 353244431,
 353047924,
 120302,
 -1,
 353205984,
 120688,
 -60144,
 353231854,
 120326,
 -60143,
 353361160,
 120324,
 -60142,
 353425326,
 120323,
 -60141,
 353478468,
 120318,
 -60140,
 353529641,
 120311,
 -1,
 353589387,
 120309,
 353768778,
 350236125,
 -1,
 353834266,
 353747668,
 120295,
 353899801,
 353786974,
 120669,
 -1,
 353831572,
 120679,
 -1,
 353838479,
 120681,
 354096414,
 353804265,
 120291,
 -60132,
 354073564,
 120685,
 -60131,
 354115967,
 120677,
 -1,
 354180233,
 120683,
 354358562,
 354062735,
 120290,
 354484223,
 354320357,
 -1,
 -60127,
 354378507,
 120676,
 -1,
 354436256,
 120686,
 354620709,
 354304135,
 120280,
 -60124,
 354599701,
 120668,
 -1,
 354658001,
 120666,
 354817319,
 354608926,
 120301,
 -1,
 354765656,
 120667,
 354948393,
 354804484,
 120299,
 -1,
 354902399,
 120675,
 355079467,
 354930250,
 120296,
 -1,
 355051217,
 120682,
 355210541,
 355055391,
 120294,
 -1,
 355165568,
 120680,
 355341615,
 355182932,
 120293,
 -1,
 355294815,
 120678,
 355472689,
 355305695,
 120289,
 -1,
 355454538,
 120674,
 355603763,
 355434469,
 120288,
 -1,
 355585610,
 120673,
 355734837,
 355562328,
 120287,
 -1,
 355671230,
 120672,
 355865911,
 355692680,
 120286,
 -1,
 355803173,
 120671,
 355996985,
 355819903,
 120284,
 -1,
 355965574,
 120670,
 356128059,
 355947235,
 120282,
 -1,
 356064490,
 120664,
 356259133,
 356070944,
 120279,
 -1,
 356206120,
 120665,
 356390207,
 356199646,
 120278,
 -1,
 356342921,
 120684,
 356521281,
 356329078,
 120277,
 -1,
 356469592,
 120663,
 356652355,
 356455796,
 120276,
 -1,
 356613856,
 120662,
 -60092,
 356639726,
 120300,
 -60091,
 356769032,
 120298,
 -60090,
 356833198,
 120297,
 -60089,
 356886340,
 120292,
 -60088,
 356937513,
 120285,
 -60087,
 356997259,
 120283,
 -1,
 357060182,
 120281,
 357242200,
 353712536,
 -1,
 357307726,
 357221076,
 -1,
 -60083,
 357294479,
 120814,
 -1,
 357326934,
 120815,
 357504337,
 357283615,
 -1,
 -60080,
 357461742,
 120818,
 -1,
 357518466,
 120819,
 357700948,
 357453398,
 -1,
 -60077,
 357669872,
 120816,
 -1,
 357723767,
 120817,
 -60075,
 357689237,
 120812,
 -60074,
 357864895,
 120813,
 -60073,
 357928124,
 120821,
 -1,
 357975351,
 120820,
 358159708,
 357212137,
 -1,
 -60070,
 358113733,
 120719,
 -60069,
 358177946,
 120717,
 -1,
 358228689,
 120713,
 -60067,
 358139553,
 120715,
 -60066,
 358395374,
 120718,
 -60065,
 358451540,
 120687,
 -60064,
 358510876,
 120716,
 -1,
 358566102,
 120714,
 358749592,
 342584736,
 -1,
 358815101,
 358727052,
 -1,
 -60060,
 358803230,
 120379,
 -60059,
 358867950,
 120378,
 -60058,
 358933252,
 120377,
 -60057,
 358997256,
 120376,
 -60056,
 359061422,
 120375,
 -60055,
 359124554,
 120374,
 -60054,
 359187156,
 120373,
 -60053,
 359249695,
 120372,
 -60052,
 359311700,
 120371,
 -60051,
 359376708,
 120370,
 -60050,
 359440361,
 120369,
 -60049,
 359502223,
 120368,
 -60048,
 359565535,
 120367,
 -60047,
 359628773,
 120366,
 -60046,
 359691096,
 120365,
 -60045,
 359755912,
 120364,
 -60044,
 359821097,
 120363,
 -60043,
 359883135,
 120362,
 -60042,
 359946379,
 120361,
 -60041,
 360010467,
 120360,
 -60040,
 360074838,
 120359,
 -60039,
 360136839,
 120358,
 -60038,
 360199712,
 120357,
 -60037,
 360262878,
 120356,
 -60036,
 360326774,
 120355,
 -1,
 360387956,
 120354,
 360644607,
 358755805,
 -1,
 -60033,
 360572702,
 120353,
 -60032,
 360637422,
 120352,
 -60031,
 360702724,
 120351,
 -60030,
 360766728,
 120350,
 -60029,
 360830894,
 120349,
 -60028,
 360894026,
 120348,
 -60027,
 360956628,
 120347,
 -60026,
 361019167,
 120346,
 -60025,
 361081172,
 120345,
 -60024,
 361146180,
 120344,
 -60023,
 361209833,
 120343,
 -60022,
 361271695,
 120342,
 -60021,
 361335007,
 120341,
 -60020,
 361398245,
 120340,
 -60019,
 361460568,
 120339,
 -60018,
 361525384,
 120338,
 -60017,
 361590569,
 120337,
 -60016,
 361652607,
 120336,
 -60015,
 361715851,
 120335,
 -60014,
 361779939,
 120334,
 -60013,
 361844310,
 120333,
 -60012,
 361906311,
 120332,
 -60011,
 361969184,
 120331,
 -60010,
 362032350,
 120330,
 -60009,
 362096246,
 120329,
 -1,
 362157428,
 120328,
 362354099,
 358727052,
 -1,
 -60006,
 362342174,
 120275,
 -60005,
 362406894,
 120274,
 -60004,
 362472196,
 120273,
 -60003,
 362536200,
 120272,
 -60002,
 362600366,
 120271,
 -60001,
 362663498,
 120270,
 -60000,
 362726100,
 120269,
 -59999,
 362788639,
 120268,
 -59998,
 362850644,
 120267,
 -59997,
 362915652,
 120266,
 -59996,
 362979305,
 120265,
 -59995,
 363041167,
 120264,
 -59994,
 363104479,
 120263,
 -59993,
 363167717,
 120262,
 -59992,
 363230040,
 120261,
 -59991,
 363294856,
 120260,
 -59990,
 363360041,
 120259,
 -59989,
 363422079,
 120258,
 -59988,
 363485323,
 120257,
 -59987,
 363549411,
 120256,
 -59986,
 363613782,
 120255,
 -59985,
 363675783,
 120254,
 -59984,
 363738656,
 120253,
 -59983,
 363801822,
 120252,
 -59982,
 363865718,
 120251,
 -1,
 363926900,
 120250,
 364123598,
 362294749,
 -1,
 -59979,
 364111646,
 120249,
 -59978,
 364176366,
 120248,
 -59977,
 364241668,
 120247,
 -59976,
 364305672,
 120246,
 -59975,
 364369838,
 120245,
 -59974,
 364432970,
 120244,
 -59973,
 364495572,
 120243,
 -59972,
 364558111,
 120242,
 -59971,
 364620116,
 120241,
 -59970,
 364685124,
 120240,
 -59969,
 364748777,
 120239,
 -59968,
 364810639,
 120238,
 -59967,
 364873951,
 120237,
 -59966,
 364937189,
 120236,
 -59965,
 364999512,
 120235,
 -59964,
 365064328,
 120234,
 -59963,
 365129513,
 120233,
 -59962,
 365191551,
 120232,
 -59961,
 365254795,
 120231,
 -59960,
 365318883,
 120230,
 -59959,
 365383254,
 120229,
 -59958,
 365445255,
 120228,
 -59957,
 365508128,
 120227,
 -59956,
 365571294,
 120226,
 -59955,
 365635190,
 120225,
 -1,
 365696372,
 120224,
 365953023,
 364067224,
 -1,
 365958610,
 365871828,
 -1,
 -59951,
 365945231,
 120804,
 -1,
 365977686,
 120805,
 366155221,
 365934367,
 -1,
 -59948,
 366112494,
 120808,
 -1,
 366169218,
 120809,
 366351832,
 366104150,
 -1,
 -59945,
 366320624,
 120806,
 -1,
 366374519,
 120807,
 -59943,
 366339989,
 120802,
 -59942,
 366515647,
 120803,
 -59941,
 366578876,
 120811,
 -1,
 366626103,
 120810,
 366870527,
 342504429,
 -1,
 366876149,
 366787980,
 -1,
 -59937,
 366864158,
 120015,
 -59936,
 366928878,
 120014,
 -59935,
 366994180,
 120013,
 -59934,
 367058184,
 120012,
 -59933,
 367122350,
 120011,
 -59932,
 367185482,
 120010,
 -59931,
 367248084,
 120009,
 -59930,
 367310623,
 120008,
 -59929,
 367372628,
 120007,
 -59928,
 367437636,
 120006,
 -59927,
 367501289,
 120005,
 -59926,
 367560927,
 120003,
 -59925,
 367624165,
 120002,
 -59924,
 367686488,
 120001,
 -59923,
 367751304,
 120000,
 -59922,
 367816489,
 119999,
 -59921,
 367878527,
 119998,
 -59920,
 367941771,
 119997,
 -59919,
 368004694,
 119995,
 -59918,
 368064032,
 119993,
 -59917,
 368127198,
 119992,
 -59916,
 368191094,
 119991,
 -1,
 368252276,
 119990,
 368508927,
 366816733,
 -1,
 -59913,
 368437022,
 119989,
 -59912,
 368501742,
 119988,
 -59911,
 368567044,
 119987,
 -59910,
 368631048,
 119986,
 -59909,
 368695214,
 119985,
 -59908,
 368758346,
 119984,
 -59907,
 368820948,
 119983,
 -59906,
 368883487,
 119982,
 -59905,
 368944964,
 119980,
 -59904,
 369008617,
 119979,
 -59903,
 369070479,
 119978,
 -59902,
 369133791,
 119977,
 -59901,
 369193096,
 119974,
 -59900,
 369258281,
 119973,
 -59899,
 369316579,
 119970,
 -59898,
 369374752,
 119967,
 -59897,
 369437918,
 119966,
 -1,
 369497460,
 119964,
 369694575,
 342436550,
 -1,
 369759869,
 369651104,
 -1,
 369825343,
 369737100,
 -1,
 369890831,
 369795049,
 119953,
 -59891,
 369867740,
 120653,
 -59890,
 369910143,
 120645,
 -1,
 369974409,
 120651,
 370152978,
 369869524,
 119957,
 -59887,
 370105438,
 120637,
 -1,
 370156943,
 120649,
 370349590,
 370119055,
 119952,
 370475007,
 370311141,
 -1,
 -59883,
 370369291,
 120644,
 -1,
 370427040,
 120654,
 370611737,
 370294919,
 119942,
 -59880,
 370590485,
 120636,
 -1,
 370648785,
 120634,
 370808347,
 370599710,
 119963,
 -1,
 370756440,
 120635,
 370939421,
 370795268,
 119961,
 -1,
 370893183,
 120643,
 371070495,
 370921034,
 119958,
 -1,
 371042001,
 120650,
 371201569,
 371046175,
 119956,
 -1,
 371156352,
 120648,
 371332643,
 371173716,
 119955,
 -1,
 371285599,
 120646,
 371463717,
 371296479,
 119951,
 -1,
 371445322,
 120642,
 371594791,
 371425253,
 119950,
 -1,
 371576394,
 120641,
 371725865,
 371553112,
 119949,
 -1,
 371662014,
 120640,
 371856939,
 371683464,
 119948,
 -1,
 371793957,
 120639,
 371988013,
 371810687,
 119946,
 -1,
 371956358,
 120638,
 372119087,
 371938019,
 119944,
 -1,
 372055274,
 120632,
 372250161,
 372067926,
 119943,
 -1,
 372205512,
 120647,
 372381235,
 372192800,
 119941,
 -1,
 372327976,
 120633,
 372512309,
 372321502,
 119940,
 -1,
 372464777,
 120652,
 372643383,
 372450934,
 119939,
 -1,
 372591448,
 120631,
 372774457,
 372577652,
 119938,
 -1,
 372735712,
 120630,
 -59846,
 372761582,
 119962,
 -59845,
 372890888,
 119960,
 -59844,
 372955054,
 119959,
 -59843,
 373008196,
 119954,
 -59842,
 373059369,
 119947,
 -1,
 373119115,
 119945,
 373298804,
 369765853,
 -1,
 373364292,
 373277396,
 119931,
 373429827,
 373316702,
 120611,
 -1,
 373361300,
 120621,
 -1,
 373368207,
 120623,
 373626440,
 373333993,
 119927,
 -59834,
 373603292,
 120627,
 -59833,
 373645695,
 120619,
 -1,
 373709961,
 120625,
 373888588,
 373592463,
 119926,
 374013951,
 373850085,
 -1,
 -59829,
 373908235,
 120618,
 -1,
 373965984,
 120628,
 374150735,
 373833863,
 119916,
 -59826,
 374129429,
 120610,
 -1,
 374187729,
 120608,
 374347345,
 374138654,
 119937,
 -1,
 374295384,
 120609,
 374478419,
 374334212,
 119935,
 -1,
 374432127,
 120617,
 374609493,
 374459978,
 119932,
 -1,
 374580945,
 120624,
 374740567,
 374585119,
 119930,
 -1,
 374695296,
 120622,
 374871641,
 374712660,
 119929,
 -1,
 374824543,
 120620,
 375002715,
 374835423,
 119925,
 -1,
 374984266,
 120616,
 375133789,
 374964197,
 119924,
 -1,
 375115338,
 120615,
 375264863,
 375092056,
 119923,
 -1,
 375200958,
 120614,
 375395937,
 375222408,
 119922,
 -1,
 375332901,
 120613,
 375527011,
 375349631,
 119920,
 -1,
 375495302,
 120612,
 375658085,
 375476963,
 119918,
 -1,
 375594218,
 120606,
 375789159,
 375600672,
 119915,
 -1,
 375735848,
 120607,
 375920233,
 375729374,
 119914,
 -1,
 375872649,
 120626,
 376051307,
 375858806,
 119913,
 -1,
 375999320,
 120605,
 376182381,
 375985524,
 119912,
 -1,
 376143584,
 120604,
 -59794,
 376169454,
 119936,
 -59793,
 376298760,
 119934,
 -59792,
 376362926,
 119933,
 -59791,
 376416068,
 119928,
 -59790,
 376467241,
 119921,
 -59789,
 376526987,
 119919,
 -1,
 376589910,
 119917,
 376772216,
 373268457,
 -1,
 -59786,
 376725957,
 120661,
 -59785,
 376790170,
 120659,
 -1,
 376840913,
 120655,
 -59783,
 376751777,
 120657,
 -59782,
 377007598,
 120660,
 -59781,
 377063764,
 120629,
 -59780,
 377123100,
 120658,
 -1,
 377178326,
 120656,
 377362155,
 369735455,
 -1,
 377427636,
 377323806,
 -1,
 377493123,
 377397225,
 119849,
 -59775,
 377469916,
 120537,
 -59774,
 377512319,
 120529,
 -1,
 377576585,
 120535,
 377755270,
 377471700,
 119853,
 -59771,
 377707614,
 120521,
 -1,
 377759119,
 120533,
 377951882,
 377721231,
 119848,
 378077183,
 377913317,
 -1,
 -59767,
 377971467,
 120528,
 -1,
 378029216,
 120538,
 378214029,
 377897095,
 119838,
 -59764,
 378192661,
 120520,
 -1,
 378250961,
 120518,
 378410640,
 378156576,
 119837,
 -59761,
 378365080,
 120779,
 -1,
 378422824,
 120517,
 378607250,
 378398494,
 119859,
 -1,
 378555224,
 120519,
 378738324,
 378594052,
 119857,
 -1,
 378691967,
 120527,
 378869398,
 378719818,
 119854,
 -1,
 378840785,
 120534,
 379000472,
 378844959,
 119852,
 -1,
 378955136,
 120532,
 379131546,
 378972500,
 119851,
 -1,
 379084383,
 120530,
 379262620,
 379095263,
 119847,
 -1,
 379244106,
 120526,
 379393694,
 379224037,
 119846,
 -1,
 379375178,
 120525,
 379524768,
 379351896,
 119845,
 -1,
 379460798,
 120524,
 379655842,
 379482248,
 119844,
 -1,
 379592741,
 120523,
 379786916,
 379609471,
 119842,
 -1,
 379755142,
 120522,
 379917990,
 379736803,
 119840,
 -1,
 379854058,
 120516,
 380049064,
 379866710,
 119839,
 -1,
 380004296,
 120531,
 380180138,
 379989214,
 119836,
 -1,
 380132489,
 120536,
 380311212,
 380118646,
 119835,
 -1,
 380259160,
 120515,
 380442286,
 380245364,
 119834,
 -1,
 380403424,
 120514,
 -59729,
 380429294,
 119858,
 -59728,
 380558600,
 119856,
 -59727,
 380622766,
 119855,
 -59726,
 380675908,
 119850,
 -59725,
 380727081,
 119843,
 -1,
 380786827,
 119841,
 381026303,
 377369581,
 -1,
 381032144,
 380943756,
 -1,
 -59721,
 381019934,
 120067,
 -59720,
 381084654,
 120066,
 -59719,
 381149956,
 120065,
 -59718,
 381213960,
 120064,
 -59717,
 381278126,
 120063,
 -59716,
 381341258,
 120062,
 -59715,
 381403860,
 120061,
 -59714,
 381466399,
 120060,
 -59713,
 381528404,
 120059,
 -59712,
 381593412,
 120058,
 -59711,
 381657065,
 120057,
 -59710,
 381718927,
 120056,
 -59709,
 381782239,
 120055,
 -59708,
 381845477,
 120054,
 -59707,
 381907800,
 120053,
 -59706,
 381972616,
 120052,
 -59705,
 382037801,
 120051,
 -59704,
 382099839,
 120050,
 -59703,
 382163083,
 120049,
 -59702,
 382227171,
 120048,
 -59701,
 382291542,
 120047,
 -59700,
 382353543,
 120046,
 -59699,
 382416416,
 120045,
 -59698,
 382479582,
 120044,
 -59697,
 382543478,
 120043,
 -1,
 382604660,
 120042,
 382861311,
 380972509,
 -1,
 -59694,
 382789406,
 120041,
 -59693,
 382854126,
 120040,
 -59692,
 382919428,
 120039,
 -59691,
 382983432,
 120038,
 -59690,
 383047598,
 120037,
 -59689,
 383110730,
 120036,
 -59688,
 383173332,
 120035,
 -59687,
 383235871,
 120034,
 -59686,
 383297876,
 120033,
 -59685,
 383362884,
 120032,
 -59684,
 383426537,
 120031,
 -59683,
 383488399,
 120030,
 -59682,
 383551711,
 120029,
 -59681,
 383614949,
 120028,
 -59680,
 383677272,
 120027,
 -59679,
 383742088,
 120026,
 -59678,
 383807273,
 120025,
 -59677,
 383869311,
 120024,
 -59676,
 383932555,
 120023,
 -59675,
 383996643,
 120022,
 -59674,
 384061014,
 120021,
 -59673,
 384123015,
 120020,
 -59672,
 384185888,
 120019,
 -59671,
 384249054,
 120018,
 -59670,
 384312950,
 120017,
 -1,
 384374132,
 120016,
 384571170,
 377311805,
 -1,
 384636679,
 384548236,
 -1,
 -59666,
 384624414,
 120223,
 -59665,
 384689134,
 120222,
 -59664,
 384754436,
 120221,
 -59663,
 384818440,
 120220,
 -59662,
 384882606,
 120219,
 -59661,
 384945738,
 120218,
 -59660,
 385008340,
 120217,
 -59659,
 385070879,
 120216,
 -59658,
 385132884,
 120215,
 -59657,
 385197892,
 120214,
 -59656,
 385261545,
 120213,
 -59655,
 385323407,
 120212,
 -59654,
 385386719,
 120211,
 -59653,
 385449957,
 120210,
 -59652,
 385512280,
 120209,
 -59651,
 385577096,
 120208,
 -59650,
 385642281,
 120207,
 -59649,
 385704319,
 120206,
 -59648,
 385767563,
 120205,
 -59647,
 385831651,
 120204,
 -59646,
 385896022,
 120203,
 -59645,
 385958023,
 120202,
 -59644,
 386020896,
 120201,
 -59643,
 386084062,
 120200,
 -59642,
 386147958,
 120199,
 -1,
 386209140,
 120198,
 386465791,
 384576989,
 -1,
 -59639,
 386393886,
 120197,
 -59638,
 386458606,
 120196,
 -59637,
 386523908,
 120195,
 -59636,
 386587912,
 120194,
 -59635,
 386652078,
 120193,
 -59634,
 386715210,
 120192,
 -59633,
 386777812,
 120191,
 -59632,
 386840351,
 120190,
 -59631,
 386902356,
 120189,
 -59630,
 386967364,
 120188,
 -59629,
 387031017,
 120187,
 -59628,
 387092879,
 120186,
 -59627,
 387156191,
 120185,
 -59626,
 387219429,
 120184,
 -59625,
 387281752,
 120183,
 -59624,
 387346568,
 120182,
 -59623,
 387411753,
 120181,
 -59622,
 387473791,
 120180,
 -59621,
 387537035,
 120179,
 -59620,
 387601123,
 120178,
 -59619,
 387665494,
 120177,
 -59618,
 387727495,
 120176,
 -59617,
 387790368,
 120175,
 -59616,
 387853534,
 120174,
 -59615,
 387917430,
 120173,
 -1,
 387978612,
 120172,
 388175704,
 384511453,
 -1,
 388241191,
 388154068,
 119827,
 388306726,
 388193374,
 120495,
 -1,
 388237972,
 120505,
 -1,
 388244879,
 120507,
 388503339,
 388210665,
 119823,
 -59607,
 388479964,
 120511,
 -59606,
 388522367,
 120503,
 -1,
 388586633,
 120509,
 388765487,
 388469135,
 119822,
 388890623,
 388726757,
 -1,
 -59602,
 388784907,
 120502,
 -1,
 388842656,
 120512,
 389027634,
 388710535,
 119812,
 -59599,
 389006101,
 120494,
 -1,
 389064401,
 120492,
 389224245,
 388970016,
 119811,
 -59596,
 389178520,
 120778,
 -1,
 389236264,
 120491,
 389420855,
 389211934,
 119833,
 -1,
 389368664,
 120493,
 389551929,
 389407492,
 119831,
 -1,
 389505407,
 120501,
 389683003,
 389533258,
 119828,
 -1,
 389654225,
 120508,
 389814077,
 389658399,
 119826,
 -1,
 389768576,
 120506,
 389945151,
 389785940,
 119825,
 -1,
 389897823,
 120504,
 390076225,
 389908703,
 119821,
 -1,
 390057546,
 120500,
 390207299,
 390037477,
 119820,
 -1,
 390188618,
 120499,
 390338373,
 390165336,
 119819,
 -1,
 390274238,
 120498,
 390469447,
 390295688,
 119818,
 -1,
 390406181,
 120497,
 390600521,
 390422911,
 119816,
 -1,
 390568582,
 120496,
 390731595,
 390550243,
 119814,
 -1,
 390667498,
 120490,
 390862669,
 390671582,
 119810,
 -1,
 390814857,
 120510,
 390993743,
 390801014,
 119809,
 -1,
 390941528,
 120489,
 391124817,
 390927732,
 119808,
 -1,
 391085792,
 120488,
 -59566,
 391111662,
 119832,
 -59565,
 391240968,
 119830,
 -59564,
 391305134,
 119829,
 -59563,
 391358276,
 119824,
 -59562,
 391409449,
 119817,
 -59561,
 391469195,
 119815,
 -1,
 391532118,
 119813,
 391714662,
 388118936,
 -1,
 391780188,
 391693012,
 -1,
 -59557,
 391766415,
 120784,
 -1,
 391798870,
 120785,
 391976799,
 391755551,
 -1,
 -59554,
 391933678,
 120788,
 -1,
 391990402,
 120789,
 392173410,
 391925334,
 -1,
 -59551,
 392141808,
 120786,
 -1,
 392195703,
 120787,
 -59549,
 392161173,
 120782,
 -59548,
 392336831,
 120783,
 -59547,
 392400060,
 120791,
 -1,
 392447287,
 120790,
 392632170,
 391684073,
 -1,
 -59544,
 392585669,
 120545,
 -59543,
 392649882,
 120543,
 -1,
 392700625,
 120539,
 -59541,
 392611489,
 120541,
 -59540,
 392867310,
 120544,
 -59539,
 392923476,
 120513,
 -59538,
 392982812,
 120542,
 -1,
 393038038,
 120540,
 393222117,
 369651104,
 -1,
 393287591,
 393198988,
 -1,
 393353077,
 393256937,
 119901,
 -59533,
 393329628,
 120595,
 -59532,
 393372031,
 120587,
 -1,
 393436297,
 120593,
 393615226,
 393295392,
 119889,
 393680761,
 393583327,
 -1,
 -59528,
 393637673,
 120485,
 -1,
 393699711,
 120484,
 -1,
 393627176,
 120575,
 393942909,
 393593556,
 119905,
 -59524,
 393895006,
 120579,
 -1,
 393946511,
 120591,
 394139521,
 393908623,
 119900,
 394264575,
 394100709,
 -1,
 -59520,
 394158859,
 120586,
 -1,
 394216608,
 120596,
 394401668,
 394084487,
 119890,
 -59517,
 394380053,
 120578,
 -1,
 394438353,
 120576,
 394598278,
 394389278,
 119911,
 -1,
 394546008,
 120577,
 394729352,
 394584836,
 119909,
 -1,
 394682751,
 120585,
 394860426,
 394710602,
 119906,
 -1,
 394831569,
 120592,
 394991500,
 394835743,
 119904,
 -1,
 394945920,
 120590,
 395122574,
 394963284,
 119903,
 -1,
 395075167,
 120588,
 395253648,
 395086047,
 119899,
 -1,
 395234890,
 120584,
 395384722,
 395214821,
 119898,
 -1,
 395365962,
 120583,
 395515796,
 395342680,
 119897,
 -1,
 395451582,
 120582,
 395646870,
 395473032,
 119896,
 -1,
 395583525,
 120581,
 395777944,
 395600255,
 119894,
 -1,
 395745926,
 120580,
 395909018,
 395727587,
 119892,
 -1,
 395844842,
 120574,
 396040092,
 395857494,
 119891,
 -1,
 395995080,
 120589,
 396171166,
 395979998,
 119888,
 -1,
 396123273,
 120594,
 396302240,
 396109430,
 119887,
 -1,
 396249944,
 120573,
 396433314,
 396236148,
 119886,
 -1,
 396394208,
 120572,
 -59485,
 396420078,
 119910,
 -59484,
 396549384,
 119908,
 -59483,
 396613550,
 119907,
 -59482,
 396666692,
 119902,
 -1,
 396717865,
 119895,
 396892124,
 393227741,
 -1,
 396957612,
 396870356,
 119879,
 397023147,
 396909662,
 120553,
 -1,
 396954260,
 120563,
 -1,
 396961167,
 120565,
 397219760,
 396926953,
 119875,
 -59474,
 397196252,
 120569,
 -59473,
 397238655,
 120561,
 -1,
 397302921,
 120567,
 397481908,
 397185423,
 119874,
 397606911,
 397443045,
 -1,
 -59469,
 397501195,
 120560,
 -1,
 397558944,
 120570,
 397744055,
 397426823,
 119864,
 -59466,
 397722389,
 120552,
 -1,
 397780689,
 120550,
 397940665,
 397731614,
 119885,
 -1,
 397888344,
 120551,
 398071739,
 397927172,
 119883,
 -1,
 398025087,
 120559,
 398202813,
 398052938,
 119880,
 -1,
 398173905,
 120566,
 398333887,
 398178079,
 119878,
 -1,
 398288256,
 120564,
 398464961,
 398305620,
 119877,
 -1,
 398417503,
 120562,
 398596035,
 398428383,
 119873,
 -1,
 398577226,
 120558,
 398727109,
 398557157,
 119872,
 -1,
 398708298,
 120557,
 398858183,
 398685016,
 119871,
 -1,
 398793918,
 120556,
 398989257,
 398815368,
 119870,
 -1,
 398925861,
 120555,
 399120331,
 398942591,
 119868,
 -1,
 399088262,
 120554,
 399251405,
 399069923,
 119866,
 -1,
 399187178,
 120548,
 399382479,
 399193632,
 119863,
 -1,
 399328808,
 120549,
 399513553,
 399322334,
 119862,
 -1,
 399465609,
 120568,
 399644627,
 399451766,
 119861,
 -1,
 399592280,
 120547,
 399775701,
 399578484,
 119860,
 -1,
 399736544,
 120546,
 -59434,
 399762414,
 119884,
 -59433,
 399891720,
 119882,
 -59432,
 399955886,
 119881,
 -59431,
 400009028,
 119876,
 -59430,
 400060201,
 119869,
 -59429,
 400119947,
 119867,
 -1,
 400182870,
 119865,
 400365536,
 396861417,
 -1,
 -59426,
 400318917,
 120603,
 -59425,
 400383130,
 120601,
 -1,
 400433873,
 120597,
 -59423,
 400344737,
 120599,
 -59422,
 400600558,
 120602,
 -59421,
 400656724,
 120571,
 -59420,
 400716060,
 120600,
 -1,
 400771286,
 120598,
 400955434,
 393185023,
 -1,
 401020929,
 400932236,
 -1,
 -59416,
 401008414,
 120483,
 -59415,
 401073134,
 120482,
 -59414,
 401138436,
 120481,
 -59413,
 401202440,
 120480,
 -59412,
 401266606,
 120479,
 -59411,
 401329738,
 120478,
 -59410,
 401392340,
 120477,
 -59409,
 401454879,
 120476,
 -59408,
 401516884,
 120475,
 -59407,
 401581892,
 120474,
 -59406,
 401645545,
 120473,
 -59405,
 401707407,
 120472,
 -59404,
 401770719,
 120471,
 -59403,
 401833957,
 120470,
 -59402,
 401896280,
 120469,
 -59401,
 401961096,
 120468,
 -59400,
 402026281,
 120467,
 -59399,
 402088319,
 120466,
 -59398,
 402151563,
 120465,
 -59397,
 402215651,
 120464,
 -59396,
 402280022,
 120463,
 -59395,
 402342023,
 120462,
 -59394,
 402404896,
 120461,
 -59393,
 402468062,
 120460,
 -59392,
 402531958,
 120459,
 -1,
 402593140,
 120458,
 402790428,
 400960989,
 -1,
 -59389,
 402777886,
 120457,
 -59388,
 402842606,
 120456,
 -59387,
 402907908,
 120455,
 -59386,
 402971912,
 120454,
 -59385,
 403036078,
 120453,
 -59384,
 403099210,
 120452,
 -59383,
 403161812,
 120451,
 -59382,
 403224351,
 120450,
 -59381,
 403286356,
 120449,
 -59380,
 403351364,
 120448,
 -59379,
 403415017,
 120447,
 -59378,
 403476879,
 120446,
 -59377,
 403540191,
 120445,
 -59376,
 403603429,
 120444,
 -59375,
 403665752,
 120443,
 -59374,
 403730568,
 120442,
 -59373,
 403795753,
 120441,
 -59372,
 403857791,
 120440,
 -59371,
 403921035,
 120439,
 -59370,
 403985123,
 120438,
 -59369,
 404049494,
 120437,
 -59368,
 404111495,
 120436,
 -59367,
 404174368,
 120435,
 -59366,
 404237534,
 120434,
 -59365,
 404301430,
 120433,
 -1,
 404362612,
 120432,
 404619263,
 402733464,
 -1,
 404625440,
 404538068,
 -1,
 -59361,
 404611471,
 120824,
 -1,
 404643926,
 120825,
 404822051,
 404600607,
 -1,
 -59358,
 404778734,
 120828,
 -1,
 404835458,
 120829,
 405018662,
 404770390,
 -1,
 -59355,
 404986864,
 120826,
 -1,
 405040759,
 120827,
 -59353,
 405006229,
 120822,
 -59352,
 405181887,
 120823,
 -59351,
 405245116,
 120831,
 -1,
 405292343,
 120830,
 405477480,
 400899603,
 -1,
 405542982,
 405454220,
 -1,
 -59347,
 405530398,
 120171,
 -59346,
 405595118,
 120170,
 -59345,
 405660420,
 120169,
 -59344,
 405724424,
 120168,
 -59343,
 405788590,
 120167,
 -59342,
 405851722,
 120166,
 -59341,
 405914324,
 120165,
 -59340,
 405976863,
 120164,
 -59339,
 406038868,
 120163,
 -59338,
 406103876,
 120162,
 -59337,
 406167529,
 120161,
 -59336,
 406229391,
 120160,
 -59335,
 406292703,
 120159,
 -59334,
 406355941,
 120158,
 -59333,
 406418264,
 120157,
 -59332,
 406483080,
 120156,
 -59331,
 406548265,
 120155,
 -59330,
 406610303,
 120154,
 -59329,
 406673547,
 120153,
 -59328,
 406737635,
 120152,
 -59327,
 406802006,
 120151,
 -59326,
 406864007,
 120150,
 -59325,
 406926880,
 120149,
 -59324,
 406990046,
 120148,
 -59323,
 407053942,
 120147,
 -1,
 407115124,
 120146,
 407312474,
 405482973,
 -1,
 -59320,
 407299054,
 120144,
 -59319,
 407364356,
 120143,
 -59318,
 407428360,
 120142,
 -59317,
 407492526,
 120141,
 -59316,
 407555658,
 120140,
 -59315,
 407618260,
 120139,
 -59314,
 407680799,
 120138,
 -59313,
 407736719,
 120134,
 -59312,
 407797733,
 120132,
 -59311,
 407860056,
 120131,
 -59310,
 407924872,
 120130,
 -59309,
 407990057,
 120129,
 -59308,
 408052095,
 120128,
 -59307,
 408113891,
 120126,
 -59306,
 408178262,
 120125,
 -59305,
 408240263,
 120124,
 -59304,
 408303136,
 120123,
 -59303,
 408364662,
 120121,
 -1,
 408425844,
 120120,
 408682495,
 407255448,
 -1,
 408688734,
 408601300,
 -1,
 -59299,
 408674703,
 120794,
 -1,
 408707158,
 120795,
 408885345,
 408663839,
 -1,
 -59296,
 408841966,
 120798,
 -1,
 408898690,
 120799,
 409081956,
 408833622,
 -1,
 -59293,
 409050096,
 120796,
 -1,
 409103991,
 120797,
 -59291,
 409069461,
 120792,
 -59290,
 409245119,
 120793,
 -59289,
 409308348,
 120801,
 -1,
 409355575,
 120800,
 409540762,
 405426749,
 -1,
 409606276,
 409517452,
 -1,
 -59285,
 409593630,
 120119,
 -59284,
 409658350,
 120118,
 -59283,
 409723652,
 120117,
 -59282,
 409787656,
 120116,
 -59281,
 409851822,
 120115,
 -59280,
 409914954,
 120114,
 -59279,
 409977556,
 120113,
 -59278,
 410040095,
 120112,
 -59277,
 410102100,
 120111,
 -59276,
 410167108,
 120110,
 -59275,
 410230761,
 120109,
 -59274,
 410292623,
 120108,
 -59273,
 410355935,
 120107,
 -59272,
 410419173,
 120106,
 -59271,
 410481496,
 120105,
 -59270,
 410546312,
 120104,
 -59269,
 410611497,
 120103,
 -59268,
 410673535,
 120102,
 -59267,
 410736779,
 120101,
 -59266,
 410800867,
 120100,
 -59265,
 410865238,
 120099,
 -59264,
 410927239,
 120098,
 -59263,
 410990112,
 120097,
 -59262,
 411053278,
 120096,
 -59261,
 411117174,
 120095,
 -1,
 411178356,
 120094,
 411435007,
 409546205,
 -1,
 -59258,
 411362286,
 120092,
 -59257,
 411427588,
 120091,
 -59256,
 411491592,
 120090,
 -59255,
 411555758,
 120089,
 -59254,
 411618890,
 120088,
 -59253,
 411681492,
 120087,
 -59252,
 411744031,
 120086,
 -59251,
 411805508,
 120084,
 -59250,
 411869161,
 120083,
 -59249,
 411931023,
 120082,
 -59248,
 411994335,
 120081,
 -59247,
 412057573,
 120080,
 -59246,
 412119896,
 120079,
 -59245,
 412184712,
 120078,
 -59244,
 412249897,
 120077,
 -59243,
 412308195,
 120074,
 -59242,
 412372566,
 120073,
 -59241,
 412434567,
 120072,
 -59240,
 412497440,
 120071,
 -59239,
 412558966,
 120069,
 -1,
 412620148,
 120068,
 412817569,
 409513575,
 -1,
 412883102,
 412802735,
 -1,
 -59235,
 412863085,
 10221,
 -1,
 412925790,
 10215,
 -59233,
 412832045,
 10223,
 -59232,
 413023331,
 10219,
 -1,
 413081275,
 10217,
 413335551,
 412776074,
 -1,
 413341861,
 413261487,
 -1,
 -59228,
 413321837,
 10220,
 -1,
 413384542,
 10214,
 -59226,
 413290797,
 10222,
 -59225,
 413482083,
 10218,
 -1,
 413540027,
 10216,
 413735219,
 342389592,
 -1,
 413800748,
 413673031,
 -1,
 413866232,
 413759962,
 -1,
 413931702,
 413805790,
 -1,
 413997237,
 413882507,
 -1,
 414062772,
 413951572,
 -1,
 414128304,
 414025951,
 3451,
 -1,
 414091487,
 3450,
 414259378,
 414085976,
 3453,
 -1,
 414217048,
 3454,
 -59213,
 414233957,
 3452,
 -1,
 414347400,
 3455,
 -1,
 413996404,
 3355,
 -1,
 413930868,
 3354,
 414652605,
 413915054,
 -1,
 414718140,
 414618197,
 -1,
 414783674,
 414689620,
 3339,
 -1,
 414755156,
 3424,
 414973951,
 414741336,
 3340,
 -1,
 414872408,
 3425,
 -1,
 414651764,
 3381,
 415111363,
 414630612,
 -1,
 415176897,
 415089364,
 -1,
 -59200,
 415127721,
 3360,
 -1,
 415176052,
 3359,
 -59198,
 415127721,
 3365,
 -1,
 415307124,
 3364,
 415504584,
 415074527,
 -1,
 -59195,
 415491114,
 3358,
 -59194,
 415533371,
 3363,
 -59193,
 415585028,
 3353,
 -1,
 415634804,
 3368,
 415832270,
 415446560,
 -1,
 415897804,
 415774240,
 -1,
 -59189,
 415848617,
 3362,
 -1,
 415896948,
 3361,
 -59187,
 415848617,
 3367,
 -1,
 416028020,
 3366,
 416225490,
 415765876,
 3333,
 -59184,
 416206410,
 3348,
 -59183,
 416244095,
 3344,
 -1,
 416290164,
 3334,
 416487638,
 416200479,
 -1,
 -59180,
 416462745,
 3383,
 -59179,
 416503977,
 3382,
 -1,
 416552308,
 3384,
 416749787,
 416445272,
 -1,
 416815322,
 416707416,
 -1,
 -59175,
 416773037,
 3380,
 -1,
 416814452,
 3379,
 -1,
 416748916,
 3378,
 417077469,
 416730698,
 3337,
 -1,
 417058378,
 3338,
 417208544,
 417048916,
 -1,
 -59169,
 417180079,
 3377,
 -1,
 417207668,
 3376,
 417405155,
 417177577,
 -1,
 -59166,
 417355945,
 3371,
 -1,
 417404276,
 3370,
 417601765,
 417370511,
 3346,
 -1,
 417567119,
 3347,
 417732840,
 417558664,
 -1,
 -59161,
 417683625,
 3350,
 -1,
 417731956,
 3349,
 417929451,
 417689385,
 -1,
 -59158,
 417880233,
 3357,
 -1,
 417928564,
 3356,
 418126061,
 417882495,
 3335,
 -1,
 418079103,
 3336,
 418257136,
 418075363,
 -1,
 -59153,
 418207913,
 3352,
 -1,
 418256244,
 3351,
 418453746,
 418201735,
 3342,
 -1,
 418398343,
 3343,
 418584821,
 418391670,
 -1,
 -59148,
 418535593,
 3373,
 -1,
 418583924,
 3372,
 -59146,
 418571306,
 3375,
 -59145,
 418742322,
 3374,
 -1,
 418797737,
 3385,
 418978058,
 413850806,
 -1,
 419043582,
 418962447,
 -1,
 419109116,
 419014996,
 3395,
 -1,
 419080532,
 3396,
 419299327,
 419066712,
 3426,
 -1,
 419197784,
 3427,
 419371266,
 418977140,
 -1,
 -59136,
 419352138,
 3404,
 -59135,
 419389823,
 3400,
 -1,
 419435892,
 3390,
 419633412,
 419352138,
 3393,
 -1,
 419614282,
 3394,
 419764486,
 419598735,
 3402,
 -1,
 419729807,
 3403,
 419895560,
 419717503,
 3391,
 -1,
 419848575,
 3392,
 420085759,
 419840135,
 3398,
 -1,
 419971207,
 3399,
 420157722,
 418919968,
 -1,
 420223257,
 420111738,
 -1,
 420288783,
 420201172,
 -1,
 -59122,
 420274575,
 3432,
 -1,
 420307030,
 3433,
 420485394,
 420263711,
 -1,
 -59119,
 420441838,
 3436,
 -1,
 420498562,
 3437,
 420682005,
 420433494,
 -1,
 -59116,
 420649968,
 3434,
 -1,
 420703863,
 3435,
 -59114,
 420669333,
 3430,
 -59113,
 420844991,
 3431,
 -59112,
 420908220,
 3439,
 -1,
 420955447,
 3438,
 -1,
 420160673,
 3449,
 421206305,
 420133936,
 -1,
 421271838,
 421190501,
 -1,
 -59107,
 421247013,
 3331,
 -1,
 421309069,
 3405,
 421527551,
 421205364,
 -1,
 -59104,
 421451717,
 3389,
 -1,
 421499077,
 3330,
 421665062,
 421171263,
 -1,
 421730597,
 421631427,
 -1,
 -59100,
 421709597,
 3442,
 -1,
 421749015,
 3441,
 -1,
 421709094,
 3440,
 421992747,
 421614115,
 -1,
 422058282,
 421959107,
 -1,
 -59095,
 422029397,
 3443,
 -1,
 422074763,
 3444,
 -1,
 422037374,
 3445,
 -1,
 421930386,
 3415,
 422385970,
 413745289,
 -1,
 422451504,
 422371524,
 -1,
 -59089,
 422427691,
 9894,
 -1,
 422452662,
 9895,
 -59087,
 422427691,
 9794,
 -1,
 422583687,
 9893,
 -1,
 422364644,
 10016,
 422844794,
 413687344,
 -1,
 422910274,
 422819615,
 -1,
 422975802,
 422866677,
 -1,
 423041337,
 422915294,
 -1,
 -59080,
 422997058,
 127006,
 -1,
 423058080,
 126988,
 -1,
 422979370,
 126997,
 423303487,
 422923405,
 -1,
 423369022,
 423242974,
 -1,
 -59075,
 423324738,
 127007,
 -1,
 423385760,
 126989,
 -1,
 423307050,
 126998,
 -59072,
 423285193,
 127015,
 -59071,
 423601777,
 127014,
 -1,
 423664856,
 126977,
 423827789,
 422888148,
 -1,
 423893320,
 423813729,
 -1,
 423958855,
 423832798,
 -1,
 -59066,
 423914562,
 127002,
 -1,
 423975584,
 126984,
 -1,
 423896874,
 126993,
 424280063,
 423846097,
 -1,
 424286540,
 424160478,
 -1,
 -59061,
 424242242,
 127003,
 -1,
 424303264,
 126985,
 -1,
 424224554,
 126994,
 424548696,
 423775830,
 -1,
 424614227,
 424516684,
 -1,
 424679762,
 424553694,
 -1,
 -59055,
 424635458,
 127004,
 -1,
 424696480,
 126986,
 -1,
 424617770,
 126995,
 425000959,
 424570526,
 -1,
 425007447,
 424881374,
 -1,
 -59050,
 424963138,
 127005,
 -1,
 425024160,
 126987,
 -1,
 424945450,
 126996,
 425269599,
 424513935,
 -1,
 425335134,
 425233199,
 -1,
 425400669,
 425274590,
 -1,
 -59044,
 425356354,
 127001,
 -1,
 425417376,
 126983,
 -1,
 425338666,
 126992,
 -1,
 425306946,
 127011,
 425728358,
 425232607,
 -1,
 425793893,
 425683056,
 -1,
 425859428,
 425733342,
 -1,
 -59037,
 425815106,
 127009,
 -1,
 425876128,
 126991,
 -1,
 425797418,
 127000,
 -1,
 425761199,
 126979,
 426187117,
 425672839,
 -1,
 426252652,
 426140920,
 -1,
 426318187,
 426192094,
 -1,
 -59030,
 426273858,
 127008,
 -1,
 426334880,
 126990,
 -1,
 426256170,
 126999,
 -1,
 426189808,
 126976,
 426645873,
 426171656,
 -1,
 -59025,
 426600951,
 127017,
 -59024,
 426663432,
 126982,
 -1,
 426724103,
 126978,
 426908020,
 426583720,
 -1,
 -59021,
 426869508,
 127012,
 -1,
 426914085,
 127019,
 -59019,
 426880069,
 126980,
 -59018,
 427074631,
 127010,
 -59017,
 427126835,
 127018,
 -59016,
 427186129,
 126981,
 -59015,
 427241468,
 127013,
 -1,
 427304398,
 127016,
 427497853,
 422819615,
 -1,
 -59012,
 427478621,
 12348,
 -1,
 427505015,
 186,
 -59010,
 427472280,
 9901,
 -59009,
 427663404,
 9967,
 -1,
 427701273,
 175,
 427891551,
 342331791,
 -1,
 427956882,
 427832864,
 -1,
 428022416,
 427910235,
 -1,
 428087783,
 427996959,
 -1,
 428153313,
 428048670,
 -1,
 428218773,
 428131028,
 7511,
 428284306,
 428201476,
 -1,
 428349834,
 428217716,
 7492,
 -58999,
 428310240,
 7579,
 -1,
 428359815,
 7494,
 428546444,
 428321108,
 692,
 -1,
 428477814,
 693,
 428677518,
 428507109,
 7514,
 -1,
 428608969,
 7597,
 -58993,
 428660654,
 7610,
 -58992,
 428775231,
 7500,
 -58991,
 428827007,
 7502,
 -1,
 428890251,
 7587,
 -58989,
 428250863,
 7508,
 -58988,
 429022302,
 7615,
 -1,
 429067762,
 7605,
 429267359,
 428158174,
 7580,
 429332893,
 429203413,
 -1,
 429398426,
 429285759,
 7590,
 -58983,
 429363468,
 694,
 -1,
 429395551,
 7591,
 -58981,
 429379146,
 7608,
 -58980,
 429557983,
 7600,
 -1,
 429618008,
 7595,
 -58978,
 429284489,
 7521,
 -1,
 429722795,
 7581,
 429922725,
 429242143,
 738,
 429988259,
 429862110,
 -1,
 -58974,
 429961882,
 7586,
 -1,
 430006605,
 7498,
 -58972,
 429941765,
 7513,
 -1,
 430116214,
 7603,
 430315946,
 429867143,
 7497,
 -58969,
 430303185,
 7614,
 -58968,
 430360079,
 7582,
 -58967,
 430422547,
 7604,
 -1,
 430476215,
 7505,
 430643631,
 430265059,
 7501,
 430709166,
 430615701,
 -1,
 -58963,
 430678879,
 7520,
 -1,
 430723946,
 7518,
 -1,
 430644458,
 736,
 430971315,
 430581366,
 7495,
 -58959,
 430938911,
 7509,
 -58958,
 430984024,
 7517,
 -1,
 431039059,
 7601,
 431233463,
 430958366,
 7611,
 431357951,
 431164451,
 -1,
 -58954,
 431271207,
 7612,
 -1,
 431306128,
 7613,
 431495610,
 431214154,
 7512,
 -58951,
 431466193,
 7607,
 -1,
 431489552,
 7606,
 431692222,
 431466836,
 691,
 431816703,
 431639794,
 -1,
 -58947,
 431724351,
 7583,
 -1,
 431773162,
 740,
 431954370,
 431657359,
 7506,
 432078847,
 431923714,
 -1,
 -58943,
 431985039,
 7507,
 -1,
 432029831,
 7499,
 432216518,
 431911768,
 737,
 432340991,
 432147491,
 -1,
 -58939,
 432254247,
 7593,
 -1,
 432316575,
 7594,
 432478665,
 432158240,
 7496,
 -58936,
 432446202,
 7585,
 -1,
 432490024,
 7519,
 432675276,
 432412020,
 7491,
 -58933,
 432635616,
 7493,
 -1,
 432695088,
 7516,
 432871886,
 432658350,
 7515,
 -1,
 432803190,
 7609,
 433002960,
 432840681,
 7510,
 -1,
 432954505,
 7602,
 433134035,
 432965899,
 -1,
 -58926,
 433106215,
 7599,
 -1,
 433157959,
 7598,
 433330645,
 433094629,
 7504,
 -1,
 433261942,
 7596,
 433461719,
 433286953,
 690,
 -1,
 433392792,
 7592,
 433592794,
 433414527,
 -1,
 -58919,
 433560198,
 7589,
 -1,
 433589855,
 7588,
 433789404,
 433543307,
 688,
 -1,
 433720694,
 689,
 -58915,
 433775598,
 696,
 -58914,
 433906436,
 739,
 -58913,
 433970440,
 695,
 -58912,
 434008200,
 7503,
 -1,
 434064982,
 7584,
 434248164,
 428133071,
 -1,
 -58909,
 434208337,
 42785,
 -1,
 434265393,
 42784,
 434503679,
 434198667,
 -1,
 -58906,
 434411935,
 42890,
 -1,
 434456044,
 765,
 434641428,
 428027102,
 -1,
 434706946,
 434577365,
 -1,
 434772461,
 434678100,
 7487,
 434896895,
 434719986,
 -1,
 -58900,
 434800863,
 7483,
 -1,
 434847879,
 7474,
 435034607,
 434737551,
 7484,
 -1,
 435015242,
 7485,
 435165681,
 434972278,
 7470,
 -1,
 435102283,
 7471,
 435296755,
 435098996,
 7468,
 -1,
 435241095,
 7469,
 -58892,
 435281160,
 7490,
 -58891,
 435410862,
 11389,
 -58890,
 435473994,
 7489,
 -58889,
 435536596,
 7488,
 -58888,
 435593193,
 7486,
 -58887,
 435652831,
 7482,
 -58886,
 435716069,
 7481,
 -58885,
 435778392,
 7480,
 -58884,
 435843208,
 7479,
 -58883,
 435908393,
 7478,
 -58882,
 435970431,
 7477,
 -58881,
 436033675,
 7476,
 -58880,
 436097763,
 7475,
 -58879,
 436158599,
 7473,
 -1,
 436221472,
 7472,
 436410893,
 434658703,
 -1,
 436476424,
 436365107,
 -1,
 -58875,
 436452002,
 42754,
 -58874,
 436516458,
 42758,
 -58873,
 436578241,
 42756,
 -1,
 436642741,
 42752,
 436862975,
 436412004,
 -1,
 -58870,
 436779682,
 42755,
 -58869,
 436844138,
 42759,
 -58868,
 436905921,
 42757,
 -1,
 436970421,
 42753,
 437131792,
 436357191,
 -1,
 -58865,
 437104455,
 722,
 -1,
 437155616,
 723,
 -58863,
 437118665,
 7544,
 -58862,
 437302412,
 735,
 -58861,
 437359777,
 42889,
 -1,
 437414995,
 710,
 437590577,
 434598744,
 -1,
 437656110,
 437559021,
 -1,
 437721645,
 437583872,
 -1,
 437787163,
 437679749,
 -1,
 437852698,
 437715434,
 767,
 -1,
 437803830,
 753,
 -1,
 437784931,
 42773,
 438049312,
 437729988,
 -1,
 438114847,
 438029346,
 -1,
 -58850,
 438094268,
 42763,
 -1,
 438138924,
 42768,
 -1,
 438100318,
 751,
 438376995,
 438026964,
 -1,
 -58846,
 438343112,
 744,
 -1,
 438396415,
 759,
 438573606,
 438349305,
 -1,
 -58843,
 438537143,
 755,
 -1,
 438588642,
 754,
 -58841,
 438557427,
 716,
 -58840,
 438752046,
 752,
 -58839,
 438796347,
 717,
 -58838,
 438856467,
 42783,
 -58837,
 438916811,
 718,
 -58836,
 438972625,
 42888,
 -1,
 439031719,
 719,
 -1,
 437668198,
 42778,
 439353343,
 437601182,
 -1,
 -58832,
 439245268,
 703,
 -1,
 439296674,
 706,
 439491135,
 437561684,
 -1,
 439556664,
 439425406,
 -1,
 -58828,
 439538469,
 42779,
 -58827,
 439577363,
 42782,
 -58826,
 439635322,
 42781,
 -58825,
 439696984,
 42780,
 -1,
 439759339,
 760,
 439949883,
 439510248,
 -1,
 -58822,
 439900628,
 702,
 -1,
 439952034,
 707,
 440146494,
 439897330,
 -1,
 -58819,
 440096234,
 705,
 -1,
 440152591,
 701,
 -1,
 440098810,
 734,
 440408656,
 439435399,
 -1,
 440474189,
 440394724,
 -1,
 440539719,
 440434211,
 -1,
 440605253,
 440482791,
 -1,
 -58812,
 440584636,
 42764,
 -1,
 440629292,
 42769,
 -58810,
 440584636,
 745,
 -1,
 440760364,
 42774,
 440991743,
 440491247,
 -1,
 440998475,
 440876007,
 -1,
 -58806,
 440977852,
 42760,
 -1,
 441022508,
 42765,
 -58804,
 440977852,
 741,
 -1,
 441153580,
 42770,
 441384959,
 440437344,
 -1,
 -58801,
 441286225,
 764,
 -1,
 441343281,
 762,
 441522784,
 440369125,
 -1,
 441588319,
 441475455,
 -1,
 441653854,
 441529888,
 -1,
 441719385,
 441581568,
 -1,
 441784919,
 441662439,
 -1,
 -58794,
 441764284,
 42762,
 -1,
 441808940,
 42767,
 -58792,
 441764284,
 743,
 -1,
 441940012,
 42772,
 442171391,
 441662131,
 -1,
 442178141,
 442055759,
 -1,
 -58788,
 442128075,
 757,
 -1,
 442177447,
 758,
 -1,
 442128075,
 756,
 -1,
 441618620,
 727,
 -1,
 441522063,
 713,
 442571371,
 441465540,
 -1,
 442636901,
 442548950,
 -1,
 -58781,
 442620508,
 42775,
 -58780,
 442678653,
 42776,
 -1,
 442719960,
 42777,
 442899048,
 442622289,
 -1,
 -58777,
 442876761,
 725,
 -1,
 442901154,
 709,
 443154431,
 442879785,
 -1,
 -58774,
 443065963,
 698,
 -1,
 443097114,
 750,
 443292275,
 442521739,
 -1,
 443357810,
 443245780,
 -1,
 443423344,
 443300839,
 -1,
 -58769,
 443402684,
 42761,
 -1,
 443447340,
 42766,
 -58767,
 443402684,
 742,
 -1,
 443578412,
 42771,
 -1,
 443292515,
 721,
 443816569,
 443272778,
 -1,
 443882103,
 443785195,
 -1,
 -58762,
 443859801,
 724,
 -1,
 443884194,
 708,
 -58760,
 443856671,
 42864,
 -1,
 444041675,
 749,
 444209789,
 443765475,
 -1,
 -58757,
 444181257,
 715,
 -58756,
 444235272,
 704,
 -1,
 444287107,
 4348,
 444471936,
 444195822,
 -1,
 -58753,
 444426059,
 746,
 -1,
 444472937,
 747,
 444668547,
 444454830,
 -1,
 -58750,
 444634002,
 748,
 -1,
 444680736,
 712,
 444865158,
 444646100,
 -1,
 -58747,
 444847627,
 699,
 -1,
 444902959,
 720,
 445061769,
 444833769,
 -1,
 -58744,
 445034907,
 697,
 -1,
 445087606,
 726,
 445258380,
 444999730,
 -1,
 -58741,
 445218385,
 763,
 -1,
 445275441,
 761,
 445454991,
 445191540,
 -1,
 -58738,
 445425008,
 700,
 -1,
 445462011,
 714,
 -1,
 445421389,
 766,
 -58735,
 428003628,
 10762,
 -1,
 445662741,
 8871,
 445848414,
 427919583,
 -1,
 445913943,
 445797938,
 -1,
 445979445,
 445872602,
 -1,
 446044858,
 445956820,
 -1,
 446110392,
 446010064,
 -1,
 446175900,
 446043508,
 -1,
 446241435,
 446134899,
 -1,
 -58726,
 446228447,
 6297,
 -1,
 446284565,
 6296,
 -1,
 446204855,
 6218,
 446503582,
 446156362,
 6215,
 -1,
 446447751,
 6217,
 446634657,
 446481108,
 -1,
 -58720,
 446609305,
 6228,
 -1,
 446633332,
 6224,
 446831267,
 446599567,
 6214,
 -1,
 446775431,
 6216,
 446962342,
 446787369,
 -1,
 -58715,
 446915078,
 6234,
 -1,
 446961012,
 6227,
 447158952,
 446911236,
 6222,
 -1,
 447092084,
 6232,
 447290027,
 447100448,
 -1,
 -58710,
 447276848,
 6236,
 -1,
 447288692,
 6225,
 -58708,
 447276074,
 6229,
 -58707,
 447470896,
 6230,
 -58706,
 447522634,
 6221,
 -58705,
 447586382,
 6220,
 -58704,
 447646847,
 6235,
 -58703,
 447709234,
 6223,
 -58702,
 447774074,
 6211,
 -58701,
 447836319,
 6231,
 -58700,
 447897983,
 6213,
 -58699,
 447961260,
 6233,
 -58698,
 448020615,
 6212,
 -58697,
 448081705,
 6226,
 -1,
 448145064,
 6219,
 -58695,
 446085017,
 6204,
 -1,
 448271732,
 6194,
 448469727,
 445977972,
 6176,
 448535262,
 448428659,
 -1,
 448600770,
 448512724,
 -1,
 448666304,
 448578260,
 -1,
 -58689,
 448616617,
 6285,
 -1,
 448664948,
 6284,
 -58687,
 448618604,
 6278,
 -1,
 448796020,
 6288,
 448993991,
 448542240,
 -1,
 449059526,
 448927092,
 6289,
 -58683,
 449020560,
 6274,
 -1,
 449073997,
 6313,
 -1,
 449001099,
 6286,
 449321674,
 448927092,
 6279,
 -58679,
 449286358,
 6272,
 -1,
 449337483,
 6295,
 449518285,
 449308446,
 -1,
 -58676,
 449468585,
 6293,
 -1,
 449516916,
 6294,
 449714896,
 449486825,
 -1,
 -58673,
 449665193,
 6291,
 -1,
 449713524,
 6290,
 449911507,
 449677535,
 -1,
 -58670,
 449874235,
 6287,
 -1,
 449925892,
 6282,
 450108117,
 449864063,
 6280,
 -1,
 450072854,
 6276,
 450239192,
 450058640,
 -1,
 -58665,
 450225194,
 6311,
 -1,
 450285130,
 6310,
 -58663,
 450223078,
 6273,
 -58662,
 450416369,
 6275,
 -58661,
 450478016,
 6292,
 -58660,
 450523295,
 6281,
 -58659,
 450571579,
 6283,
 -1,
 450635555,
 6277,
 -1,
 448498615,
 6185,
 450894587,
 448444191,
 -1,
 450960121,
 450847444,
 -1,
 451025636,
 450946846,
 -1,
 -58653,
 450975913,
 6258,
 -1,
 451024244,
 6255,
 451222246,
 451006026,
 6241,
 -1,
 451166343,
 6240,
 451353321,
 451199700,
 -1,
 -58648,
 451327897,
 6254,
 -1,
 451351924,
 6248,
 451549931,
 451305855,
 6238,
 -1,
 451535854,
 6239,
 451681005,
 451500201,
 6245,
 -1,
 451614068,
 6253,
 451812079,
 451629828,
 6244,
 -1,
 451745140,
 6252,
 -58640,
 451787346,
 6247,
 -58639,
 451914178,
 6256,
 -58638,
 451977294,
 6246,
 -58637,
 452030623,
 6243,
 -58636,
 452095787,
 6250,
 -58635,
 452153023,
 6251,
 -58634,
 452214919,
 6237,
 -58633,
 452277899,
 6249,
 -58632,
 452341545,
 6257,
 -1,
 452402784,
 6242,
 -58630,
 450910377,
 6193,
 -1,
 452531572,
 6192,
 452729621,
 450854962,
 6190,
 452853759,
 452692533,
 -1,
 452860688,
 452729744,
 -1,
 452926209,
 452847390,
 -1,
 -58624,
 452876457,
 6308,
 -1,
 452924788,
 6309,
 453122820,
 452903636,
 -1,
 -58621,
 453100309,
 6302,
 -1,
 453121396,
 6304,
 453319431,
 453064224,
 -1,
 -58618,
 453269673,
 6305,
 -1,
 453326965,
 6303,
 453516042,
 453258462,
 -1,
 -58615,
 453501994,
 6307,
 -1,
 453514612,
 6300,
 -58613,
 453492672,
 6306,
 -58612,
 453676010,
 6299,
 -58611,
 453737057,
 6314,
 -58610,
 453799930,
 6301,
 -58609,
 453858494,
 6298,
 -1,
 453912893,
 6312,
 -58607,
 452847583,
 6263,
 -58606,
 454076847,
 6261,
 -58605,
 454127775,
 6260,
 -58604,
 454189439,
 6259,
 -1,
 454250175,
 6262,
 454433561,
 452716318,
 -1,
 -58601,
 454404527,
 6207,
 -58600,
 454450313,
 6209,
 -1,
 454497652,
 6205,
 454695707,
 454413898,
 6180,
 -1,
 454639751,
 6182,
 454826781,
 454660495,
 6179,
 -1,
 454770823,
 6181,
 454957856,
 454783832,
 -1,
 -58593,
 454908073,
 6208,
 -1,
 454956404,
 6191,
 455154467,
 454914184,
 -1,
 -58590,
 455104681,
 6203,
 -1,
 455153012,
 6202,
 455351077,
 455098503,
 6177,
 -1,
 455295111,
 6183,
 455482152,
 455290658,
 -1,
 -58585,
 455434623,
 6210,
 -1,
 455480692,
 6196,
 -58583,
 455468074,
 6198,
 -58582,
 455662896,
 6200,
 -58581,
 455715247,
 6199,
 -58580,
 455780170,
 6188,
 -58579,
 455843918,
 6187,
 -58578,
 455903547,
 6184,
 -58577,
 455962411,
 6197,
 -58576,
 456024447,
 6178,
 -58575,
 456087724,
 6206,
 -58574,
 456151812,
 6189,
 -58573,
 456216255,
 6201,
 -58572,
 456275595,
 6195,
 -1,
 456337064,
 6186,
 456530755,
 445921688,
 -1,
 456596281,
 456508116,
 -1,
 -58568,
 456581519,
 6162,
 -1,
 456613974,
 6163,
 456792892,
 456570655,
 -1,
 -58565,
 456748782,
 6166,
 -1,
 456805506,
 6167,
 456989503,
 456740438,
 -1,
 -58562,
 456956912,
 6164,
 -1,
 457010807,
 6165,
 -58560,
 456976277,
 6160,
 -58559,
 457151935,
 6161,
 -58558,
 457215164,
 6169,
 -1,
 457262391,
 6168,
 457448267,
 456478294,
 -1,
 457513801,
 457419886,
 -1,
 457579336,
 457491156,
 -1,
 -58553,
 457564559,
 6156,
 -1,
 457597014,
 6157,
 -1,
 457545151,
 6155,
 -58550,
 457494810,
 6147,
 -1,
 457808909,
 6149,
 457972558,
 457409023,
 -1,
 -58547,
 457921218,
 6153,
 -1,
 457978383,
 6152,
 458169169,
 457912808,
 -1,
 -58544,
 458130935,
 6146,
 -1,
 458194194,
 6148,
 -58542,
 458153110,
 6158,
 -58541,
 458344836,
 6150,
 -58540,
 458406879,
 6151,
 -58539,
 458460404,
 6154,
 -58538,
 458507772,
 6145,
 -1,
 458566075,
 6144,
 458817535,
 445878671,
 -1,
 458824541,
 458708618,
 -1,
 458890076,
 458810350,
 -1,
 -58533,
 458843952,
 9867,
 -1,
 458890848,
 9866,
 -1,
 458834276,
 119552,
 -1,
 458801202,
 9101,
 -1,
 445829869,
 9968,
 459283653,
 427871818,
 -1,
 459349168,
 459258877,
 -1,
 459414700,
 459282970,
 -1,
 459479966,
 459353310,
 -1,
 459545488,
 459444623,
 -1,
 459611023,
 459505637,
 -1,
 459676558,
 459549066,
 -1,
 459742063,
 459650847,
 -1,
 459807596,
 459719380,
 -1,
 459873131,
 459740969,
 -1,
 -58518,
 459837839,
 119164,
 -1,
 459894113,
 119166,
 -1,
 459818570,
 119141,
 -58515,
 459777583,
 119142,
 -58514,
 460097953,
 119213,
 -1,
 460161874,
 119176,
 460331895,
 459690227,
 -1,
 460397430,
 460265622,
 -1,
 -58510,
 460329993,
 119154,
 -58509,
 460395452,
 119153,
 -58508,
 460460876,
 119152,
 -58507,
 460526247,
 119151,
 -1,
 460591631,
 119150,
 -1,
 460352442,
 119175,
 460856191,
 460309204,
 -1,
 460921726,
 460826964,
 -1,
 460987261,
 460867275,
 -1,
 -58501,
 460919628,
 119145,
 -58500,
 460984999,
 119144,
 -1,
 461050383,
 119143,
 -1,
 460942293,
 119179,
 -1,
 460867689,
 119165,
 461380483,
 460798660,
 -1,
 -58495,
 461365611,
 119210,
 -58494,
 461426550,
 119178,
 -1,
 461467007,
 119173,
 461642631,
 461313396,
 -1,
 461708166,
 461581932,
 119163,
 -1,
 461640025,
 119169,
 -1,
 461688889,
 119149,
 461904777,
 461603401,
 119167,
 -1,
 461836633,
 119168,
 -58486,
 461886286,
 119211,
 -58485,
 462008862,
 119174,
 -58484,
 462061076,
 119170,
 -58483,
 462117546,
 119212,
 -1,
 462170228,
 119177,
 -1,
 459638449,
 119092,
 -1,
 459552395,
 119052,
 462494615,
 459502424,
 -1,
 462560148,
 462477014,
 -1,
 -58477,
 462544553,
 119130,
 -1,
 462563830,
 119131,
 462815231,
 462512511,
 -1,
 -58474,
 462740433,
 119253,
 -1,
 462782530,
 119255,
 462953370,
 462465364,
 -1,
 -58471,
 462918622,
 119247,
 -1,
 462965358,
 119186,
 -58469,
 462935836,
 119093,
 -58468,
 463105065,
 119109,
 -58467,
 463149166,
 119059,
 -1,
 463209117,
 119073,
 463412172,
 459457236,
 -1,
 463477684,
 463382868,
 119190,
 463601663,
 463430260,
 -1,
 463608753,
 463472162,
 -1,
 463674280,
 463590151,
 -1,
 463739814,
 463646311,
 -1,
 -58459,
 463724201,
 119120,
 -1,
 463743478,
 119121,
 -58457,
 463724201,
 119112,
 -1,
 463874550,
 119113,
 464067499,
 463646311,
 -1,
 -58454,
 464051881,
 119116,
 -1,
 464071158,
 119117,
 464264110,
 464025226,
 -1,
 -58451,
 464248489,
 119114,
 -1,
 464267766,
 119115,
 464519167,
 464207412,
 -1,
 -58448,
 464445097,
 119118,
 -1,
 464464374,
 119119,
 464715775,
 463540495,
 -1,
 -58445,
 464641705,
 119124,
 -1,
 464660982,
 119125,
 464853952,
 463423210,
 -1,
 464919484,
 464807700,
 -1,
 464985019,
 464873209,
 119243,
 465108991,
 464913210,
 -1,
 -58439,
 464982860,
 119246,
 -58438,
 465048231,
 119245,
 -1,
 465113615,
 119244,
 -1,
 464953977,
 119242,
 465436671,
 464888464,
 -1,
 465443775,
 465347193,
 119239,
 -1,
 465371975,
 119241,
 -1,
 465397497,
 119240,
 465640388,
 464836096,
 119191,
 465764351,
 465567744,
 -1,
 -58429,
 465687300,
 119194,
 -1,
 465747325,
 119193,
 465902537,
 465590411,
 -1,
 465968072,
 465857755,
 -1,
 -58425,
 465939746,
 119104,
 -1,
 465997480,
 119138,
 -1,
 465939590,
 119064,
 466230219,
 465868922,
 119256,
 -1,
 466160072,
 119260,
 -1,
 466215565,
 119063,
 466426866,
 463386399,
 -1,
 466492378,
 466379135,
 -1,
 466557913,
 466477828,
 -1,
 466623446,
 466535124,
 -1,
 466688979,
 466609180,
 -1,
 -58414,
 466660642,
 119105,
 -1,
 466718376,
 119139,
 466943999,
 466633567,
 -1,
 -58411,
 466857250,
 119103,
 -1,
 466914984,
 119137,
 467140607,
 466554579,
 -1,
 -58408,
 467058920,
 119068,
 -1,
 467106640,
 119067,
 -1,
 466521098,
 119040,
 467344357,
 466436231,
 -1,
 467409892,
 467305617,
 -1,
 467475424,
 467371416,
 -1,
 -58402,
 467459753,
 119229,
 -58401,
 467512610,
 119238,
 -1,
 467544566,
 119230,
 467795967,
 467413979,
 -1,
 -58398,
 467721897,
 119225,
 -58397,
 467774754,
 119236,
 -1,
 467806710,
 119226,
 -1,
 467359257,
 119051,
 468065258,
 467314725,
 -1,
 468130793,
 468029101,
 -1,
 -58392,
 468115113,
 119110,
 -1,
 468134390,
 119111,
 -1,
 468067958,
 119250,
 468392943,
 468015243,
 -1,
 468458478,
 468329018,
 -1,
 -58387,
 468439812,
 119088,
 -1,
 468467247,
 119089,
 -1,
 468425107,
 119045,
 468720625,
 468331919,
 119254,
 -1,
 468648893,
 119259,
 -1,
 468700941,
 119181,
 468917260,
 466374230,
 -1,
 468982779,
 468869503,
 -1,
 469048314,
 468945119,
 -1,
 469113849,
 468997244,
 -1,
 -58377,
 469046092,
 119148,
 -58376,
 469111463,
 119147,
 -1,
 469176847,
 119146,
 -1,
 469047799,
 119042,
 -1,
 469031208,
 119066,
 469507072,
 468947343,
 -1,
 469572607,
 469489059,
 -1,
 -58370,
 469549288,
 119069,
 -1,
 469597008,
 119065,
 -1,
 469546538,
 119185,
 469834756,
 469435037,
 119074,
 469958655,
 469763815,
 -1,
 -58365,
 469837783,
 119076,
 -1,
 469900371,
 119075,
 470096903,
 469816942,
 -1,
 -58362,
 470081193,
 119231,
 -1,
 470100470,
 119232,
 470293514,
 470054301,
 -1,
 -58359,
 470274820,
 119084,
 -1,
 470302255,
 119085,
 470548479,
 470239724,
 119056,
 -1,
 470417955,
 119057,
 470621217,
 468881807,
 -1,
 470686745,
 470594473,
 -1,
 470752273,
 470618639,
 119195,
 -58352,
 470684175,
 119205,
 -1,
 470749583,
 119204,
 -58350,
 470684993,
 119203,
 -58349,
 470881549,
 119202,
 -58348,
 470947014,
 119201,
 -58347,
 471012481,
 119200,
 -58346,
 471077897,
 119199,
 -58345,
 471143356,
 119198,
 -58344,
 471208780,
 119197,
 -1,
 471274151,
 119196,
 471473182,
 470649603,
 -1,
 471538717,
 471401583,
 -1,
 -58340,
 471510306,
 119106,
 -1,
 471568040,
 119140,
 -1,
 471470163,
 119062,
 471859199,
 471452699,
 -1,
 -58336,
 471738327,
 119095,
 -1,
 471800915,
 119094,
 471997490,
 470562336,
 -1,
 472063016,
 471930228,
 -1,
 472128549,
 472024936,
 119220,
 -1,
 472055875,
 119221,
 -58330,
 472103654,
 119044,
 -58329,
 472216434,
 119049,
 -1,
 472253039,
 119050,
 472456236,
 472030004,
 -1,
 -58326,
 472431289,
 119082,
 -58325,
 472469756,
 119083,
 -1,
 472524710,
 119041,
 472718383,
 472430225,
 -1,
 -58322,
 472650407,
 119078,
 -1,
 472715791,
 119077,
 472973311,
 472662151,
 -1,
 -58319,
 472864674,
 119209,
 -1,
 472921039,
 119187,
 473111618,
 471934582,
 -1,
 473177149,
 473082196,
 -1,
 473242682,
 473120903,
 -1,
 473308217,
 473225134,
 -1,
 473373752,
 473263340,
 119224,
 -1,
 473303490,
 119235,
 -1,
 473317511,
 119132,
 -1,
 473244862,
 119058,
 473694207,
 473175846,
 -1,
 -58308,
 473592302,
 119061,
 -1,
 473645191,
 119060,
 473890815,
 473121969,
 -1,
 -58305,
 473810911,
 119157,
 -58304,
 473873795,
 119159,
 -58303,
 473932663,
 119161,
 -1,
 473966626,
 119155,
 474160207,
 473079785,
 -1,
 474225735,
 474124687,
 -1,
 474291270,
 474199406,
 119257,
 -1,
 474219453,
 119258,
 -1,
 474232622,
 119252,
 474487884,
 474169479,
 -1,
 474553419,
 474429132,
 -1,
 -58294,
 474534869,
 119215,
 -1,
 474579546,
 119214,
 -1,
 474527625,
 119261,
 -58291,
 474447721,
 119108,
 -58290,
 474768061,
 119183,
 -1,
 474816879,
 119126,
 475012188,
 474120165,
 -1,
 475077716,
 474966312,
 119227,
 475201535,
 475004928,
 -1,
 -58285,
 475114786,
 119237,
 -1,
 475146742,
 119228,
 475339863,
 475058488,
 -1,
 -58282,
 475309073,
 119081,
 -1,
 475335106,
 119098,
 475536474,
 475305656,
 -1,
 -58279,
 475520681,
 119122,
 -1,
 475539958,
 119123,
 -58277,
 475483729,
 119184,
 -1,
 475670058,
 119222,
 475864171,
 474960611,
 -1,
 475929700,
 475834708,
 -1,
 475995233,
 475874504,
 -1,
 -58272,
 475942488,
 119249,
 -1,
 475999460,
 119248,
 476250111,
 475928386,
 -1,
 -58269,
 476167549,
 119188,
 -1,
 476220817,
 119189,
 476388456,
 475857565,
 119070,
 476512255,
 476317415,
 -1,
 -58265,
 476391383,
 119072,
 -1,
 476453971,
 119071,
 476708863,
 476347320,
 -1,
 -58262,
 476631812,
 119217,
 -1,
 476659247,
 119218,
 476847223,
 475834708,
 -1,
 476912756,
 476790919,
 -1,
 476978291,
 476881337,
 -1,
 477043826,
 476922544,
 -1,
 -58256,
 476975948,
 119055,
 -58255,
 477041319,
 119054,
 -1,
 477106703,
 119053,
 -1,
 476971896,
 119048,
 -1,
 476961299,
 119043,
 477495295,
 476864895,
 -1,
 -58250,
 477399981,
 119180,
 -1,
 477451553,
 119047,
 477633665,
 476790919,
 -1,
 477699198,
 477596256,
 -1,
 -58246,
 477677535,
 119158,
 -58245,
 477740419,
 119160,
 -58244,
 477799287,
 119162,
 -58243,
 477860623,
 119208,
 -1,
 477898786,
 119156,
 478150655,
 477652251,
 -1,
 -58240,
 478063906,
 119102,
 -1,
 478121640,
 119136,
 478289035,
 477603777,
 -1,
 478354568,
 478225093,
 -1,
 478420102,
 478333366,
 -1,
 -58235,
 478395065,
 119090,
 -1,
 478433532,
 119091,
 -58233,
 478391586,
 119101,
 -1,
 478580392,
 119135,
 478806015,
 478308388,
 -1,
 -58230,
 478685143,
 119097,
 -1,
 478747731,
 119096,
 478944402,
 478251231,
 -1,
 479009935,
 478881159,
 -1,
 -58226,
 478991108,
 119086,
 -1,
 479018543,
 119087,
 -58224,
 478990605,
 119129,
 -58223,
 479173284,
 119128,
 -1,
 479216139,
 119207,
 479403160,
 478901080,
 -1,
 479468695,
 479368781,
 119223,
 479592447,
 479395840,
 -1,
 -58218,
 479502978,
 119233,
 -1,
 479553284,
 119234,
 -1,
 479413246,
 119046,
 479796382,
 479353001,
 -1,
 479861917,
 479754809,
 -1,
 -58213,
 479833378,
 119100,
 -58212,
 479896013,
 119216,
 -1,
 479956648,
 119134,
 -1,
 479843583,
 119206,
 480189603,
 479780104,
 -1,
 480255138,
 480140954,
 -1,
 -58207,
 480226594,
 119099,
 -1,
 480284328,
 119133,
 -1,
 480210393,
 119219,
 480517286,
 480171950,
 -1,
 -58203,
 480482201,
 119127,
 -1,
 480537734,
 119251,
 480713897,
 480453183,
 -1,
 -58200,
 480695044,
 119171,
 -1,
 480722479,
 119172,
 -58198,
 480700190,
 119182,
 -58197,
 480895765,
 119107,
 -1,
 480930687,
 119192,
 481165311,
 459341824,
 -1,
 -58194,
 481082047,
 9839,
 -58193,
 481135068,
 9838,
 -1,
 481186049,
 9837,
 481369282,
 459308817,
 -1,
 481434813,
 481338406,
 -1,
 481500348,
 481410091,
 215,
 481624063,
 481427456,
 -1,
 481631417,
 481519411,
 -1,
 -58186,
 481610490,
 10811,
 -58185,
 481668917,
 10805,
 -58184,
 481720079,
 10804,
 -1,
 481770701,
 10807,
 482017279,
 481615730,
 -1,
 -58181,
 481940055,
 10801,
 -1,
 481966897,
 10800,
 -1,
 481485572,
 10005,
 482221249,
 481409493,
 8844,
 482344959,
 482148352,
 -1,
 -58176,
 482267775,
 8846,
 -1,
 482314234,
 8845,
 -1,
 482181685,
 8888,
 482607103,
 481308453,
 -1,
 -58172,
 482507087,
 8810,
 -1,
 482563831,
 8811,
 482745802,
 459269238,
 -1,
 482811211,
 482702168,
 -1,
 482876743,
 482757683,
 -1,
 482942182,
 482832520,
 -1,
 483007717,
 482891945,
 4097,
 483131391,
 482969516,
 -1,
 483138768,
 483014176,
 -1,
 483204303,
 483079712,
 -1,
 -58162,
 483154089,
 43625,
 -1,
 483202420,
 43624,
 -1,
 483154089,
 43626,
 483466451,
 483118104,
 -1,
 -58158,
 483416233,
 43623,
 -1,
 483464564,
 43622,
 483663062,
 483428575,
 -1,
 -58155,
 483648554,
 43621,
 -1,
 483661172,
 43627,
 483859673,
 483618601,
 -1,
 -58152,
 483809449,
 43620,
 -1,
 483857780,
 43619,
 484056284,
 483809419,
 -1,
 -58149,
 484006057,
 43630,
 -1,
 484054388,
 43629,
 484252895,
 483994846,
 -1,
 -58146,
 484202665,
 43618,
 -1,
 484250996,
 43617,
 -58144,
 484239152,
 43634,
 -58143,
 484434724,
 43633,
 -58142,
 484489113,
 43628,
 -58141,
 484551087,
 43635,
 -58140,
 484594436,
 43616,
 -1,
 484658879,
 43631,
 -1,
 482940276,
 4096,
 484908284,
 482916127,
 -1,
 484973817,
 484858025,
 4176,
 485097471,
 484935905,
 -1,
 485104876,
 485001439,
 -1,
 -58133,
 485090346,
 4218,
 -1,
 485102964,
 4220,
 485301487,
 485060744,
 -1,
 -58130,
 485251241,
 4214,
 -1,
 485299572,
 4213,
 -58128,
 485287728,
 4217,
 -58127,
 485475878,
 4224,
 -58126,
 485532466,
 4221,
 -58125,
 485578921,
 4225,
 -58124,
 485643012,
 4215,
 -58123,
 485707455,
 4222,
 -58122,
 485766795,
 4219,
 -58121,
 485829947,
 4216,
 -58120,
 485893800,
 4223,
 -1,
 485954932,
 4130,
 -58118,
 484947865,
 4177,
 -58117,
 486101985,
 4193,
 -1,
 486151540,
 4126,
 486350085,
 484868069,
 -1,
 486415620,
 486315312,
 -1,
 486481153,
 486352882,
 -1,
 -58112,
 486424711,
 4189,
 -1,
 486479220,
 4188,
 -58110,
 486444010,
 4186,
 -58109,
 486633466,
 4187,
 -1,
 486686855,
 4136,
 -1,
 486348148,
 4121,
 486939916,
 486312159,
 -1,
 487005449,
 486901983,
 -1,
 -58104,
 486990890,
 4106,
 -1,
 487003508,
 4111,
 -58102,
 486990890,
 4105,
 -58101,
 487150340,
 4100,
 -1,
 487200116,
 4116,
 487398673,
 486923279,
 -1,
 487464207,
 487369044,
 4178,
 -1,
 487434580,
 4179,
 487653375,
 487420760,
 4180,
 -1,
 487551832,
 4181,
 487726359,
 487375572,
 -1,
 487791893,
 487703252,
 -1,
 -58092,
 487741609,
 4108,
 -1,
 487789940,
 4107,
 -58090,
 487741609,
 4113,
 -1,
 487921012,
 4112,
 488119580,
 487669895,
 4135,
 488243199,
 488055850,
 -1,
 -58086,
 488171260,
 4207,
 -58085,
 488213885,
 4206,
 -1,
 488265068,
 4208,
 488447266,
 488060448,
 -1,
 488512800,
 488388128,
 -1,
 -58081,
 488462505,
 4110,
 -1,
 488510836,
 4109,
 -58079,
 488462505,
 4115,
 -1,
 488641908,
 4114,
 488840487,
 488430856,
 -1,
 488906022,
 488786704,
 -1,
 -58075,
 488883750,
 4197,
 -1,
 488941373,
 4198,
 -1,
 488838516,
 4125,
 489168171,
 488788707,
 -1,
 -58071,
 489139104,
 4159,
 -58070,
 489183401,
 4099,
 -1,
 489231732,
 4098,
 489430318,
 489100660,
 4129,
 -58067,
 489410122,
 4138,
 -1,
 489451063,
 43642,
 489626928,
 489410122,
 4133,
 -1,
 489606730,
 4134,
 489758003,
 489597268,
 -1,
 -58062,
 489738635,
 4238,
 -1,
 489756020,
 4123,
 489954614,
 489725929,
 -1,
 -58059,
 489904297,
 4118,
 -1,
 489952628,
 4117,
 490151225,
 489911128,
 -1,
 -58056,
 490107821,
 4128,
 -1,
 490149236,
 4124,
 490347836,
 490106665,
 -1,
 -58053,
 490297513,
 4104,
 -1,
 490345844,
 4103,
 490544446,
 490299775,
 4131,
 -1,
 490496383,
 4132,
 490675521,
 490482910,
 -1,
 -58048,
 490625193,
 4102,
 -1,
 490673524,
 4101,
 490872132,
 490612342,
 -1,
 -58045,
 490821801,
 4120,
 -1,
 490870132,
 4119,
 -58043,
 490857514,
 4122,
 -58042,
 491032975,
 4137,
 -1,
 491083945,
 4127,
 491323391,
 482841396,
 -1,
 -58039,
 491235244,
 43637,
 -58038,
 491295218,
 43636,
 -1,
 491347523,
 43638,
 491527560,
 482785055,
 -1,
 491593069,
 491480457,
 -1,
 491658586,
 491566879,
 -1,
 491724121,
 491608605,
 -1,
 491789652,
 491702767,
 -1,
 -58031,
 491721857,
 4234,
 -58030,
 491787273,
 4233,
 -58029,
 491852620,
 4232,
 -1,
 491917991,
 4231,
 492175359,
 491729812,
 -1,
 492182872,
 492095983,
 -1,
 -58025,
 492114764,
 4236,
 -1,
 492180135,
 4235,
 -1,
 492127954,
 4237,
 -1,
 491668060,
 4171,
 492510560,
 491642510,
 -1,
 -58020,
 492442633,
 4205,
 -58019,
 492508092,
 4204,
 -58018,
 492573516,
 4203,
 -58017,
 492638887,
 4202,
 -1,
 492704271,
 4201,
 492903779,
 492493669,
 -1,
 -58014,
 492877861,
 4152,
 -1,
 492939917,
 4153,
 493100390,
 492859942,
 -1,
 -58011,
 493032268,
 4251,
 -1,
 493097487,
 4250,
 493297001,
 493032820,
 -1,
 -58008,
 493271095,
 4154,
 -1,
 493326533,
 4150,
 -58006,
 493270683,
 4239,
 -58005,
 493461726,
 43643,
 -58004,
 493517769,
 4170,
 -1,
 493566779,
 4151,
 493755771,
 491543074,
 -1,
 493821297,
 493732564,
 -1,
 -58000,
 493805967,
 4242,
 -1,
 493838422,
 4243,
 494017908,
 493795103,
 -1,
 -57997,
 493973230,
 4246,
 -1,
 494029954,
 4247,
 494214519,
 493964886,
 -1,
 -57994,
 494181360,
 4244,
 -1,
 494235255,
 4245,
 -57992,
 494200725,
 4240,
 -57991,
 494376383,
 4241,
 -57990,
 494439612,
 4249,
 -1,
 494486839,
 4248,
 494731263,
 493741558,
 -1,
 494738818,
 494605684,
 -1,
 494804353,
 494693937,
 -1,
 -57985,
 494783842,
 43641,
 -57984,
 494835135,
 43640,
 -1,
 494882158,
 43639,
 -1,
 494752141,
 4174,
 495132037,
 494713485,
 -1,
 -57980,
 495097279,
 4254,
 -1,
 495144302,
 4255,
 -57978,
 495090906,
 4172,
 -57977,
 495277155,
 4175,
 -1,
 495333976,
 4173,
 495525292,
 491510966,
 -1,
 495590800,
 495499039,
 -1,
 495656335,
 495540765,
 -1,
 495721869,
 495599751,
 4228,
 -1,
 495648773,
 4229,
 -57970,
 495669385,
 4230,
 -1,
 495785463,
 4227,
 -1,
 495604692,
 4194,
 496049557,
 495574031,
 -1,
 496115091,
 496019796,
 4182,
 -1,
 496085332,
 4183,
 496304127,
 496071512,
 4184,
 -1,
 496202584,
 4185,
 496377242,
 495981940,
 -1,
 496442777,
 496329087,
 4146,
 496566271,
 496421284,
 4252,
 -1,
 496460159,
 4253,
 -1,
 496375156,
 4140,
 496704926,
 496333206,
 -1,
 -57956,
 496684618,
 4211,
 -57955,
 496734933,
 4210,
 -1,
 496780071,
 4212,
 496967073,
 496688763,
 -1,
 -57952,
 496947214,
 4200,
 -1,
 496979008,
 4199,
 497163683,
 496946762,
 4143,
 -1,
 497143370,
 4144,
 497294758,
 497125036,
 -1,
 -57947,
 497258895,
 4148,
 -1,
 497313179,
 4147,
 497491368,
 497246591,
 4141,
 -1,
 497443199,
 4142,
 497622442,
 497434759,
 4145,
 -1,
 497549317,
 4149,
 -57941,
 497599469,
 4139,
 -1,
 497701940,
 4209,
 497884602,
 495466904,
 -1,
 497950128,
 497861332,
 -1,
 -57937,
 497934735,
 4162,
 -1,
 497967190,
 4163,
 498146739,
 497923871,
 -1,
 -57934,
 498101998,
 4166,
 -1,
 498158722,
 4167,
 498343350,
 498093654,
 -1,
 -57931,
 498310128,
 4164,
 -1,
 498364023,
 4165,
 -57929,
 498329493,
 4160,
 -57928,
 498505151,
 4161,
 -57927,
 498568380,
 4169,
 -1,
 498615607,
 4168,
 498802118,
 497824402,
 -1,
 498867653,
 498761701,
 -1,
 498933185,
 498811649,
 -1,
 -57922,
 498918442,
 4155,
 -57921,
 498982192,
 4157,
 -57920,
 499034543,
 4156,
 -1,
 499079337,
 4158,
 499318783,
 498898238,
 -1,
 -57917,
 499222843,
 4190,
 -57916,
 499286066,
 4191,
 -1,
 499348397,
 4192,
 -1,
 498842259,
 4226,
 499588553,
 498780633,
 -1,
 -57912,
 499544507,
 4196,
 -1,
 499604231,
 4195,
 -1,
 499549751,
 43632,
 499850825,
 482689159,
 -1,
 499916307,
 499796940,
 -1,
 499981818,
 499872600,
 -1,
 500047353,
 499928115,
 -1,
 500112851,
 500009183,
 -1,
 500178385,
 500061801,
 43977,
 -1,
 500106674,
 44001,
 500367359,
 500110708,
 43973,
 -1,
 500237746,
 43999,
 500440535,
 500089556,
 -1,
 500506070,
 500393437,
 43975,
 -1,
 500434354,
 44000,
 -1,
 500457477,
 43978,
 500702683,
 500408297,
 -1,
 500768218,
 500634996,
 43972,
 -1,
 500696498,
 43998,
 -1,
 500718056,
 43984,
 500964831,
 500658312,
 -1,
 501030366,
 500929506,
 43968,
 -1,
 500958642,
 43995,
 -1,
 500981765,
 43976,
 501226977,
 500925927,
 43971,
 -1,
 501155250,
 43997,
 501358051,
 501183657,
 43970,
 -1,
 501286322,
 43996,
 501489126,
 501313321,
 -1,
 -57883,
 501442013,
 43990,
 -1,
 501504488,
 43987,
 501685736,
 501440895,
 43983,
 -1,
 501614002,
 44002,
 501816811,
 501633763,
 -1,
 -57878,
 501781474,
 43986,
 -1,
 501833733,
 43992,
 502013422,
 501757472,
 -1,
 -57875,
 501966301,
 43991,
 -1,
 502030341,
 43993,
 502210033,
 501950070,
 -1,
 -57872,
 502159848,
 43994,
 -1,
 502207860,
 43989,
 -57870,
 502195313,
 43980,
 -57869,
 502390087,
 43979,
 -57868,
 502452691,
 43982,
 -57867,
 502511586,
 43969,
 -57866,
 502573611,
 43988,
 -57865,
 502620435,
 43981,
 -57864,
 502673333,
 43974,
 -1,
 502736208,
 43985,
 -1,
 500027768,
 44012,
 502996488,
 499923352,
 -1,
 503062014,
 502973140,
 -1,
 -57859,
 503046543,
 44018,
 -1,
 503078998,
 44019,
 503258625,
 503035679,
 -1,
 -57856,
 503213806,
 44022,
 -1,
 503270530,
 44023,
 503455236,
 503205462,
 -1,
 -57853,
 503421936,
 44020,
 -1,
 503475831,
 44021,
 -57851,
 503441301,
 44016,
 -57850,
 503616959,
 44017,
 -57849,
 503680188,
 44025,
 -1,
 503727415,
 44024,
 503914001,
 502979766,
 -1,
 -57846,
 503899448,
 44006,
 -57845,
 503960040,
 44008,
 -57844,
 504020678,
 44007,
 -57843,
 504075642,
 44003,
 -57842,
 504139959,
 44010,
 -57841,
 504195027,
 44004,
 -57840,
 504246170,
 44009,
 -1,
 504307030,
 44005,
 -57838,
 503852945,
 44011,
 -1,
 504438838,
 44013,
 504634920,
 499858013,
 -1,
 504700441,
 504606305,
 -1,
 504765976,
 504627200,
 -1,
 -57833,
 504734002,
 10089,
 -1,
 504772003,
 10101,
 -1,
 504697045,
 10093,
 505028126,
 504657541,
 -1,
 505093661,
 504954880,
 -1,
 -57828,
 505061682,
 10088,
 -1,
 505099683,
 10100,
 -1,
 505024725,
 10092,
 505355809,
 505001759,
 -1,
 -57824,
 505315797,
 9900,
 -1,
 505370835,
 9618,
 505552420,
 505303307,
 -1,
 -57821,
 505524122,
 10091,
 -1,
 505575277,
 10090,
 -57819,
 505536194,
 9898,
 -57818,
 505731676,
 10073,
 -57817,
 505774760,
 8287,
 -1,
 505817615,
 9899,
 506011195,
 504570972,
 -1,
 506076729,
 505945781,
 8737,
 506200063,
 506003456,
 -1,
 506207800,
 506126476,
 -1,
 506273327,
 506188555,
 -1,
 -57810,
 506244705,
 10664,
 -1,
 506295941,
 10665,
 506469938,
 506244718,
 -1,
 -57807,
 506450692,
 10668,
 -1,
 506478127,
 10670,
 506666549,
 506427024,
 -1,
 -57804,
 506647300,
 10669,
 -1,
 506674735,
 10671,
 506920959,
 506609210,
 -1,
 -57801,
 506834529,
 10666,
 -1,
 506885765,
 10667,
 -1,
 506173299,
 10651,
 -57798,
 506048121,
 10653,
 -1,
 507063463,
 8798,
 507256392,
 505989940,
 -1,
 507321922,
 507232980,
 -1,
 507387456,
 507306600,
 -1,
 -57793,
 507354599,
 9173,
 -1,
 507408406,
 9174,
 -57791,
 507359905,
 9175,
 -1,
 507530234,
 9176,
 507715141,
 507280742,
 -1,
 -57788,
 507694580,
 9172,
 -1,
 507755351,
 9170,
 -57786,
 507689858,
 9171,
 -57785,
 507880004,
 9177,
 -1,
 507915209,
 9169,
 -1,
 507226952,
 9791,
 508231679,
 499802495,
 -1,
 508239448,
 508135647,
 -1,
 508304983,
 508221035,
 -1,
 508370518,
 508231680,
 -1,
 508436053,
 508345387,
 8722,
 508559359,
 508362752,
 -1,
 508567124,
 508485490,
 -1,
 -57775,
 508539611,
 10796,
 -57774,
 508579581,
 10795,
 -57773,
 508640059,
 10794,
 -1,
 508703253,
 10793,
 -1,
 508520328,
 10810,
 -1,
 508413948,
 8770,
 -1,
 508301453,
 8723,
 -1,
 508290030,
 10751,
 509156955,
 508180000,
 -1,
 -57766,
 509115191,
 8943,
 -1,
 509164216,
 183,
 -57764,
 509115397,
 8357,
 -1,
 509293584,
 181,
 509487016,
 342258520,
 -1,
 509551602,
 509416820,
 -1,
 509617032,
 509528230,
 -1,
 509681962,
 509589279,
 -1,
 509747487,
 509640990,
 -1,
 509813020,
 509703000,
 -1,
 509878545,
 509758515,
 -1,
 509943464,
 509854420,
 116,
 510008963,
 509922890,
 -1,
 510074498,
 509981625,
 -1,
 510140012,
 510044500,
 633,
 510263295,
 510069795,
 -1,
 -57750,
 510182275,
 11385,
 -57749,
 510229853,
 634,
 -1,
 510287520,
 635,
 510467695,
 510089355,
 613,
 510590975,
 510397799,
 686,
 -1,
 510460295,
 687,
 510664306,
 510399860,
 592,
 -57743,
 510623456,
 594,
 -1,
 510673031,
 7426,
 510860917,
 510628239,
 -1,
 -57740,
 510829080,
 7432,
 -1,
 510869639,
 7444,
 511057527,
 510820325,
 623,
 -1,
 510987721,
 624,
 511188601,
 511009151,
 7433,
 -1,
 511151869,
 42879,
 -57734,
 511173614,
 654,
 -57733,
 511302920,
 653,
 -57732,
 511367086,
 652,
 -57731,
 511427284,
 647,
 -57730,
 511472472,
 42881,
 -57729,
 511537288,
 670,
 -57728,
 511595235,
 7543,
 -57727,
 511656071,
 477,
 -1,
 511719347,
 397,
 -1,
 510033893,
 42871,
 511975063,
 509938723,
 -1,
 512040586,
 511913182,
 -1,
 -57722,
 512021999,
 566,
 -57721,
 512070925,
 539,
 -57720,
 512126052,
 7793,
 -57719,
 512181011,
 355,
 -1,
 512238108,
 357,
 512433809,
 511981088,
 -1,
 512499342,
 512399949,
 -1,
 -57715,
 512436307,
 7789,
 -1,
 512497269,
 7787,
 512753663,
 512451078,
 -1,
 -57712,
 512644666,
 11366,
 -1,
 512706996,
 7831,
 -57710,
 512409856,
 359,
 -57709,
 512863527,
 648,
 -57708,
 512925855,
 427,
 -57707,
 512984336,
 7541,
 -57706,
 513047288,
 7791,
 -1,
 513105568,
 429,
 513285789,
 511938959,
 -1,
 513351324,
 513248006,
 -1,
 -57702,
 513330530,
 424,
 -57701,
 513391892,
 389,
 -1,
 513429684,
 445,
 -1,
 513318929,
 7446,
 513679010,
 513235083,
 -1,
 513744545,
 513644895,
 254,
 513867775,
 513674847,
 42853,
 -1,
 513739499,
 42855,
 -1,
 513674827,
 7546,
 -57693,
 513664798,
 42793,
 -57692,
 513980225,
 678,
 -57691,
 514043154,
 42795,
 -57690,
 514083450,
 679,
 -57689,
 514141419,
 680,
 -1,
 514201948,
 11383,
 514399972,
 509907343,
 111,
 514465500,
 514329635,
 -1,
 514530995,
 514416223,
 -1,
 514596530,
 514503577,
 417,
 514719743,
 514523258,
 -1,
 -57682,
 514639868,
 7905,
 -57681,
 514678437,
 7903,
 -57680,
 514741957,
 7901,
 -57679,
 514800443,
 7907,
 -1,
 514856865,
 7899,
 -1,
 514560997,
 7887,
 515120830,
 514471456,
 -1,
 515186364,
 515084687,
 -1,
 515251897,
 515162838,
 -1,
 515317432,
 515184245,
 559,
 -1,
 515244310,
 561,
 -1,
 515254355,
 7885,
 515571711,
 515231529,
 -1,
 -57669,
 515462853,
 525,
 -1,
 515512225,
 337,
 515768319,
 515138057,
 246,
 -1,
 515637526,
 555,
 515841735,
 515058910,
 -1,
 515907270,
 515796041,
 244,
 516030463,
 515833978,
 -1,
 -57662,
 515950588,
 7895,
 -57661,
 515989157,
 7893,
 -57660,
 516052677,
 7891,
 -57659,
 516111163,
 7897,
 -1,
 516167585,
 7889,
 -1,
 515842588,
 466,
 516431564,
 515819516,
 245,
 516554751,
 516358266,
 -1,
 -57654,
 516456507,
 557,
 -57653,
 516503710,
 7759,
 -1,
 516560801,
 7757,
 516759248,
 516390971,
 333,
 516882431,
 516685946,
 -1,
 -57649,
 516773573,
 7761,
 -1,
 516822945,
 7763,
 517021396,
 516717764,
 -1,
 -57646,
 517004575,
 11386,
 -57645,
 517052140,
 42829,
 -1,
 517114840,
 42827,
 517283542,
 516997376,
 248,
 -1,
 517210240,
 511,
 517414616,
 517247812,
 491,
 -1,
 517341462,
 493,
 -57639,
 517368544,
 527,
 -57638,
 517494469,
 242,
 -57637,
 517549001,
 335,
 -1,
 517609377,
 243,
 517807841,
 514433538,
 -1,
 517873375,
 517771663,
 596,
 -1,
 517803536,
 7575,
 518062079,
 517816455,
 603,
 -1,
 517934608,
 7571,
 -57630,
 517787210,
 547,
 -57629,
 518099343,
 42831,
 -1,
 518152575,
 419,
 518332189,
 514343047,
 101,
 518397705,
 518261795,
 -1,
 518463219,
 518335710,
 -1,
 518528752,
 518417481,
 234,
 518651903,
 518455296,
 -1,
 518659823,
 518528363,
 -1,
 -57621,
 518637564,
 7877,
 -57620,
 518676133,
 7875,
 -57619,
 518739653,
 7873,
 -57618,
 518798139,
 7879,
 -1,
 518854561,
 7871,
 -1,
 518596691,
 7705,
 519118578,
 518472467,
 553,
 -1,
 519045259,
 7709,
 -1,
 519053852,
 283,
 519315194,
 518403616,
 -1,
 519380729,
 519278991,
 -1,
 519446264,
 519357142,
 -1,
 -57609,
 519383123,
 7865,
 -1,
 519444085,
 279,
 -1,
 519425870,
 517,
 -1,
 519332361,
 235,
 519773950,
 519274555,
 275,
 519897087,
 519700602,
 -1,
 -57603,
 519788229,
 7701,
 -1,
 519837601,
 7703,
 520036096,
 519751676,
 7869,
 -1,
 519963171,
 7707,
 -57599,
 520012032,
 583,
 -57598,
 520138023,
 7570,
 -57597,
 520196932,
 281,
 -57596,
 520261282,
 11384,
 -57595,
 520317664,
 519,
 -57594,
 520380069,
 7867,
 -57593,
 520443589,
 232,
 -57592,
 520498121,
 277,
 -1,
 520558497,
 233,
 520757010,
 518383569,
 658,
 520880127,
 520683520,
 -1,
 520888081,
 520806258,
 -1,
 520953615,
 520826078,
 -1,
 -57586,
 520934895,
 659,
 -1,
 520954396,
 495,
 -57584,
 520930179,
 442,
 -1,
 521121063,
 7578,
 -1,
 520858972,
 441,
 521346839,
 520731155,
 643,
 521469951,
 521276451,
 -1,
 -57579,
 521383207,
 7576,
 -57578,
 521445535,
 7563,
 -1,
 521483664,
 646,
 521674521,
 521323220,
 42859,
 -1,
 521623691,
 240,
 521805596,
 521623676,
 -1,
 -57573,
 521762428,
 42787,
 -1,
 521824048,
 42789,
 -1,
 521767863,
 331,
 522067796,
 518264180,
 97,
 522133320,
 521997347,
 -1,
 522198824,
 522071262,
 -1,
 522264359,
 522153033,
 226,
 522387455,
 522190970,
 -1,
 -57565,
 522307580,
 7851,
 -57564,
 522346149,
 7849,
 -57563,
 522409669,
 7847,
 -57562,
 522468155,
 7853,
 -1,
 522524577,
 7845,
 -1,
 522199580,
 462,
 522788657,
 522139168,
 -1,
 522854191,
 522752399,
 -1,
 522919726,
 522830550,
 -1,
 522985261,
 522851957,
 551,
 -1,
 522912022,
 481,
 -1,
 522922067,
 7841,
 -1,
 522899278,
 513,
 523304959,
 522805769,
 228,
 -1,
 523174166,
 479,
 523378488,
 522726345,
 259,
 523501567,
 523305082,
 -1,
 -57548,
 523421692,
 7861,
 -57547,
 523460261,
 7859,
 -57546,
 523523781,
 7857,
 -57545,
 523582267,
 7863,
 -1,
 523638689,
 7855,
 523837248,
 523348308,
 -1,
 523902783,
 523788671,
 -1,
 523968318,
 523865018,
 -1,
 524033853,
 523900533,
 229,
 -1,
 523960448,
 507,
 -1,
 523970643,
 7681,
 -1,
 523916528,
 7834,
 -1,
 523848730,
 7567,
 -57535,
 523814908,
 227,
 -57534,
 524337408,
 11365,
 -57533,
 524391236,
 261,
 -57532,
 524451899,
 257,
 -57531,
 524511968,
 515,
 -57530,
 524574373,
 7843,
 -57529,
 524637893,
 224,
 -1,
 524687265,
 225,
 524885836,
 522076295,
 230,
 525008895,
 524815395,
 -1,
 -57525,
 524910651,
 483,
 -1,
 524949409,
 509,
 525147982,
 524867502,
 42809,
 -1,
 525077889,
 42811,
 525279056,
 525106912,
 593,
 -1,
 525209104,
 7568,
 -57519,
 525263854,
 42813,
 -57518,
 525389386,
 42807,
 -57517,
 525439375,
 42805,
 -1,
 525473140,
 42803,
 525672325,
 522047050,
 117,
 525737857,
 525598720,
 -1,
 525803392,
 525721458,
 -1,
 525868901,
 525743648,
 -1,
 525934432,
 525820425,
 252,
 526057471,
 525860864,
 -1,
 526065503,
 525933931,
 -1,
 -57508,
 526024763,
 470,
 -57507,
 526079685,
 476,
 -57506,
 526134839,
 474,
 -1,
 526194593,
 472,
 -1,
 526002259,
 7795,
 526516223,
 525898127,
 -1,
 526524260,
 526438185,
 -1,
 -57501,
 526472901,
 533,
 -1,
 526522273,
 369,
 -1,
 526500577,
 7909,
 526786414,
 525819487,
 -1,
 526851949,
 526758809,
 432,
 526974975,
 526778490,
 -1,
 -57495,
 526895100,
 7919,
 -57494,
 526933669,
 7917,
 -57493,
 526997189,
 7915,
 -57492,
 527055675,
 7921,
 -1,
 527112097,
 7913,
 -1,
 526816229,
 7911,
 527376242,
 526764028,
 361,
 527499263,
 527302656,
 -1,
 -57487,
 527378515,
 7797,
 -1,
 527441264,
 7801,
 527638390,
 527314142,
 -1,
 527703925,
 527592521,
 251,
 -1,
 527630883,
 7799,
 -1,
 527639068,
 468,
 527900537,
 527608148,
 -1,
 -57480,
 527853739,
 367,
 -1,
 527911962,
 7577,
 528097147,
 527859771,
 363,
 -1,
 528023702,
 7803,
 -57476,
 528061252,
 371,
 -57475,
 528181984,
 535,
 -57474,
 528242373,
 249,
 -57473,
 528296905,
 365,
 -1,
 528357281,
 250,
 -1,
 525739854,
 649,
 528621443,
 525706961,
 650,
 -1,
 528551519,
 7551,
 -57468,
 528580581,
 42872,
 -1,
 528695431,
 7531,
 528883623,
 525645599,
 115,
 528949143,
 528813091,
 -1,
 529014669,
 528887006,
 -1,
 529080202,
 528949788,
 353,
 -1,
 529006778,
 7783,
 -57461,
 529044749,
 537,
 -57460,
 529165385,
 349,
 -1,
 529220371,
 351,
 529407889,
 528956204,
 -1,
 529473424,
 529344595,
 7779,
 -1,
 529399994,
 7785,
 -1,
 529405557,
 7777,
 529670035,
 529340321,
 347,
 -1,
 529596602,
 7781,
 -57452,
 529646141,
 575,
 -57451,
 529768607,
 7562,
 -57450,
 529827088,
 7540,
 -1,
 529882784,
 642,
 530063262,
 528901116,
 -1,
 530128795,
 530026895,
 7441,
 -57446,
 530096670,
 7442,
 -1,
 530124383,
 7443,
 -57444,
 530107978,
 7453,
 -57443,
 530304273,
 7455,
 -1,
 530331842,
 7454,
 530522020,
 530001118,
 -1,
 530587555,
 530473293,
 601,
 530710527,
 530517027,
 -1,
 -57438,
 530623783,
 7573,
 -1,
 530669216,
 602,
 -1,
 530559642,
 609,
 -57435,
 530491549,
 645,
 -57434,
 530864819,
 223,
 -1,
 530914392,
 42892,
 531111883,
 528853332,
 114,
 531177407,
 531038208,
 -1,
 531242942,
 531160946,
 -1,
 531308464,
 531184324,
 -1,
 531373999,
 531284694,
 -1,
 531439534,
 531310675,
 7771,
 -1,
 531366166,
 7773,
 -1,
 531371637,
 7769,
 -1,
 531353422,
 529,
 531701683,
 531264344,
 -1,
 -57422,
 531666469,
 636,
 -1,
 531720294,
 7775,
 531898293,
 531648672,
 638,
 -1,
 531824930,
 7539,
 532029368,
 531836126,
 -1,
 -57417,
 531972883,
 343,
 -1,
 532029980,
 345,
 -57415,
 532005763,
 637,
 -57414,
 532201728,
 589,
 -57413,
 532258975,
 7561,
 -57412,
 532317456,
 7538,
 -57411,
 532376288,
 531,
 -1,
 532420513,
 341,
 -1,
 531215586,
 42843,
 532684744,
 531123442,
 -1,
 532750276,
 532649791,
 604,
 532873215,
 532679715,
 -1,
 -57405,
 532786471,
 7572,
 -1,
 532831904,
 605,
 533012422,
 532688094,
 8580,
 -1,
 532942071,
 42815,
 -57401,
 532982155,
 639,
 -1,
 533086343,
 600,
 533274570,
 532664693,
 42869,
 -1,
 533203434,
 42845,
 -1,
 533208373,
 612,
 533471214,
 531067736,
 108,
 533536738,
 533400611,
 -1,
 533602258,
 533474526,
 -1,
 -57393,
 533583343,
 564,
 -57392,
 533621860,
 7741,
 -57391,
 533676819,
 316,
 -1,
 533733916,
 318,
 533929942,
 533543620,
 -1,
 533995477,
 533906145,
 7735,
 -1,
 533922070,
 7737,
 -1,
 533974831,
 11361,
 534192089,
 533890214,
 -1,
 -57384,
 534169596,
 619,
 -1,
 534199080,
 320,
 534388700,
 534128246,
 -1,
 -57381,
 534332953,
 620,
 -1,
 534388828,
 410,
 -57379,
 534364416,
 322,
 -57378,
 534555943,
 621,
 -57377,
 534618271,
 7557,
 -57376,
 534674168,
 7739,
 -57375,
 534732069,
 42825,
 -1,
 534779809,
 314,
 534978536,
 533501499,
 383,
 535101439,
 534907939,
 -1,
 535109607,
 534984224,
 -1,
 -57370,
 535075409,
 7835,
 -1,
 535126555,
 7836,
 -1,
 535059749,
 7837,
 -57367,
 534964000,
 683,
 -57366,
 535351669,
 42866,
 -57365,
 535410497,
 682,
 -57364,
 535457577,
 457,
 -57363,
 535514697,
 622,
 -1,
 535567526,
 411,
 535765006,
 533422463,
 105,
 535830532,
 535694371,
 -1,
 535896054,
 535770656,
 -1,
 535961588,
 535859599,
 -1,
 -57357,
 535940942,
 521,
 -1,
 536003297,
 7883,
 536215551,
 535912969,
 239,
 -1,
 536084608,
 7727,
 536289272,
 535873532,
 297,
 -1,
 536216099,
 7725,
 536420347,
 536227038,
 -1,
 -57350,
 536374345,
 238,
 -1,
 536420892,
 464,
 -57348,
 536396032,
 616,
 -57347,
 536587559,
 7574,
 -57346,
 536646468,
 303,
 -57345,
 536707131,
 299,
 -57344,
 536767200,
 523,
 -57343,
 536829605,
 7881,
 -57342,
 536893125,
 236,
 -57341,
 536947657,
 301,
 -1,
 537008033,
 237,
 537206795,
 535793388,
 -1,
 -57338,
 537182932,
 42887,
 -57337,
 537245471,
 42885,
 -57336,
 537307476,
 42883,
 -57335,
 537350883,
 7545,
 -57334,
 537415254,
 42876,
 -1,
 537474592,
 42874,
 537665549,
 537172614,
 617,
 -1,
 537595487,
 7548,
 -1,
 537638687,
 42861,
 537862192,
 535705120,
 100,
 537927713,
 537791523,
 -1,
 537993237,
 537865438,
 -1,
 -57326,
 537974255,
 545,
 -57325,
 538012772,
 7699,
 -57324,
 538067731,
 7697,
 -1,
 538124828,
 271,
 538320920,
 537969364,
 -1,
 -57321,
 538285825,
 396,
 -1,
 538319166,
 598,
 538517530,
 538271392,
 599,
 -1,
 538444167,
 7569,
 538648605,
 538458924,
 -1,
 -57316,
 538585171,
 7693,
 -1,
 538646133,
 7691,
 -57314,
 538624256,
 273,
 -57313,
 538812575,
 7553,
 -57312,
 538871056,
 7533,
 -1,
 538934008,
 7695,
 539107366,
 537913118,
 499,
 539230207,
 539033600,
 -1,
 539238437,
 539113920,
 675,
 -1,
 539167915,
 677,
 -1,
 539221905,
 454,
 539435051,
 539073247,
 -1,
 539500586,
 539389737,
 567,
 539623423,
 539430495,
 607,
 -1,
 539492570,
 644,
 -1,
 539451775,
 305,
 539762734,
 539377799,
 -1,
 -57299,
 539748308,
 676,
 -1,
 539786996,
 7839,
 -57297,
 539742581,
 42865,
 -1,
 539895416,
 568,
 540090440,
 537823455,
 110,
 540155974,
 540016640,
 -1,
 540221509,
 540139378,
 -1,
 540287032,
 540159198,
 -1,
 -57291,
 540268015,
 565,
 -57290,
 540306532,
 7755,
 -57289,
 540361491,
 326,
 -1,
 540418588,
 328,
 540614716,
 540242776,
 -1,
 -57286,
 540579373,
 414,
 -57285,
 540633190,
 7753,
 -1,
 540689359,
 626,
 540876863,
 540556076,
 -1,
 -57282,
 540813395,
 7751,
 -1,
 540874357,
 7749,
 -57280,
 540854268,
 241,
 -57279,
 541044007,
 627,
 -57278,
 541106335,
 7559,
 -57277,
 541164816,
 7536,
 -57276,
 541218501,
 505,
 -1,
 541267873,
 324,
 -1,
 540190188,
 329,
 -57273,
 540135797,
 42868,
 -1,
 541486889,
 460,
 541663324,
 540039307,
 104,
 541728856,
 541592611,
 -1,
 541794384,
 541668896,
 -1,
 541859918,
 541760077,
 -1,
 -57267,
 541796435,
 7717,
 -1,
 541857397,
 7715,
 -57265,
 541811209,
 7719,
 -1,
 542001765,
 11368,
 542187604,
 541732062,
 -1,
 -57262,
 542141513,
 293,
 -57261,
 542196499,
 7721,
 -1,
 542253596,
 543,
 -57259,
 542163200,
 295,
 -57258,
 542407416,
 7830,
 -57257,
 542465696,
 614,
 -1,
 542518223,
 7723,
 542711898,
 541673374,
 42791,
 -1,
 542641526,
 615,
 -57253,
 542693294,
 405,
 -1,
 542776142,
 11382,
 542974064,
 541600990,
 99,
 543039592,
 542903331,
 -1,
 543105124,
 542977246,
 -1,
 543170657,
 543048467,
 231,
 -1,
 543096960,
 7689,
 -57246,
 543151599,
 597,
 -57245,
 543255625,
 265,
 -1,
 543302172,
 269,
 -57243,
 543080704,
 572,
 -57242,
 543448736,
 392,
 -57241,
 543505201,
 267,
 -1,
 543561633,
 263,
 543760493,
 542997929,
 -1,
 543826028,
 543723919,
 -1,
 -57237,
 543793688,
 666,
 -1,
 543851465,
 631,
 -1,
 543796645,
 606,
 544088175,
 543739617,
 42797,
 -1,
 544017548,
 42799,
 -1,
 544052525,
 42863,
 544284804,
 542959390,
 122,
 544407551,
 544214051,
 -1,
 544415863,
 544290336,
 -1,
 544481398,
 544381517,
 -1,
 -57227,
 544417875,
 7827,
 -1,
 544478837,
 380,
 -1,
 544426597,
 11372,
 544743547,
 544353502,
 -1,
 -57223,
 544724463,
 657,
 -57222,
 544762953,
 7825,
 -1,
 544809500,
 382,
 545005694,
 544716575,
 -1,
 -57219,
 544988654,
 576,
 -1,
 545049556,
 438,
 -57217,
 544976167,
 656,
 -57216,
 545169567,
 7566,
 -57215,
 545228048,
 7542,
 -57214,
 545291000,
 7829,
 -57213,
 545349280,
 549,
 -1,
 545396641,
 378,
 545595542,
 544269294,
 121,
 545661077,
 545524771,
 -1,
 545726603,
 545601056,
 -1,
 545792138,
 545692237,
 -1,
 -57207,
 545728595,
 7925,
 -1,
 545789557,
 7823,
 -1,
 545743369,
 255,
 546054285,
 545676960,
 436,
 -1,
 545980421,
 7927,
 -57202,
 546031612,
 7929,
 -57201,
 546160896,
 591,
 -57200,
 546222512,
 7833,
 -57199,
 546275387,
 563,
 -57198,
 546340238,
 7935,
 -57197,
 546395845,
 7923,
 -57196,
 546451637,
 375,
 -1,
 546510753,
 253,
 -1,
 545624880,
 541,
 546775206,
 545550472,
 107,
 546840741,
 546704419,
 -1,
 546906268,
 546780704,
 -1,
 -57190,
 546871898,
 7731,
 -57189,
 546923035,
 42819,
 -1,
 546982501,
 11370,
 547168414,
 546881792,
 42817,
 -1,
 547094693,
 42821,
 547299489,
 547106014,
 -1,
 -57184,
 547242771,
 311,
 -1,
 547299868,
 489,
 -57182,
 547266719,
 7556,
 -57181,
 547453688,
 7733,
 -57180,
 547511968,
 409,
 -1,
 547559329,
 7729,
 -1,
 546810287,
 312,
 547823797,
 546722531,
 103,
 547889331,
 547752995,
 -1,
 547954860,
 547826910,
 -1,
 -57174,
 547908681,
 285,
 -57173,
 547963667,
 291,
 -1,
 548020764,
 487,
 -57171,
 547930368,
 485,
 -57170,
 548184223,
 7555,
 -57169,
 548241467,
 7713,
 -57168,
 548298400,
 608,
 -57167,
 548354865,
 289,
 -57166,
 548416457,
 287,
 -1,
 548476833,
 501,
 -57164,
 547847688,
 578,
 -1,
 548609258,
 611,
 548806851,
 547759734,
 98,
 548872384,
 548736035,
 -1,
 548937914,
 548813612,
 -1,
 -57159,
 548874323,
 7685,
 -1,
 548935285,
 7683,
 -57157,
 548915814,
 387,
 -57156,
 549110016,
 384,
 -57155,
 549167263,
 7552,
 -57154,
 549225744,
 7532,
 -57153,
 549288696,
 7687,
 -1,
 549346976,
 595,
 -57151,
 548844582,
 42823,
 -57150,
 549493535,
 7447,
 -1,
 549528147,
 629,
 549724368,
 548788142,
 118,
 549789901,
 549653539,
 -1,
 549855432,
 549729824,
 -1,
 -57145,
 549821018,
 7807,
 -1,
 549872155,
 42847,
 -57143,
 549832700,
 7805,
 -57142,
 550023025,
 11377,
 -57141,
 550084767,
 7564,
 -57140,
 550133408,
 651,
 -1,
 550188432,
 11380,
 -57138,
 549774318,
 42849,
 -57137,
 550333731,
 42851,
 -1,
 550389605,
 42857,
 550576349,
 549691369,
 112,
 550641884,
 550505507,
 -1,
 550707414,
 550614815,
 -1,
 550772949,
 550685652,
 7549,
 -1,
 550701803,
 42833,
 -1,
 550742277,
 42837,
 -57129,
 550674591,
 7560,
 -57128,
 550929680,
 7537,
 -57127,
 550985376,
 421,
 -57126,
 551047517,
 42835,
 -57125,
 551107377,
 7767,
 -1,
 551163809,
 7765,
 -1,
 550591625,
 632,
 551428330,
 550535141,
 109,
 551493862,
 551357475,
 -1,
 551559394,
 551435052,
 -1,
 -57119,
 551495763,
 7747,
 -1,
 551556725,
 7745,
 -57117,
 551526559,
 7558,
 -57116,
 551716112,
 7535,
 -57115,
 551771808,
 625,
 -1,
 551819169,
 7743,
 552018153,
 551445311,
 -1,
 -57112,
 551999406,
 7933,
 -1,
 552041474,
 7931,
 -1,
 551997813,
 42867,
 552280310,
 551410952,
 119,
 552402943,
 552209443,
 -1,
 552411377,
 552285728,
 -1,
 552476912,
 552376909,
 -1,
 -57105,
 552413267,
 7817,
 -1,
 552474229,
 7815,
 -1,
 552428041,
 7813,
 -57102,
 552382896,
 7832,
 -57101,
 552689312,
 11379,
 -57100,
 552752837,
 7809,
 -57099,
 552808629,
 373,
 -1,
 552867745,
 7811,
 553066749,
 552249156,
 113,
 553132284,
 552995875,
 -1,
 553197818,
 553082528,
 672,
 -1,
 553126574,
 587,
 -57093,
 553173320,
 42839,
 -1,
 553269511,
 42841,
 -1,
 553099246,
 569,
 553525508,
 553012822,
 102,
 553591043,
 553454627,
 -1,
 -57088,
 553558175,
 7554,
 -57087,
 553616656,
 7534,
 -57086,
 553672352,
 402,
 -1,
 553728817,
 7711,
 -1,
 553535394,
 681,
 553984267,
 553479977,
 106,
 554106879,
 553913379,
 -1,
 554115338,
 553987294,
 -1,
 -57080,
 554087591,
 669,
 -57079,
 554134601,
 309,
 -1,
 554181148,
 496,
 -1,
 554090752,
 585,
 554500095,
 553968388,
 120,
 554565631,
 554372131,
 -1,
 554574096,
 554448416,
 -1,
 -57073,
 554539601,
 7819,
 -1,
 554590729,
 7821,
 -1,
 554541215,
 7565,
 554893311,
 509830303,
 -1,
 554901784,
 554782294,
 -1,
 554967318,
 554847830,
 64256,
 -57067,
 554922840,
 64260,
 -1,
 554983807,
 64259,
 -57065,
 554922840,
 64258,
 -1,
 555114879,
 64257,
 -57063,
 554876939,
 64262,
 -57062,
 555258581,
 339,
 -57061,
 555318641,
 64261,
 -1,
 555378087,
 307,
 555614207,
 509750788,
 -1,
 -57058,
 555536028,
 7550,
 -1,
 555573722,
 7547,
 555810815,
 509726622,
 -1,
 -57055,
 555737860,
 8339,
 -57054,
 555800494,
 7525,
 -57053,
 555863626,
 7524,
 -57052,
 555923581,
 8340,
 -57051,
 555985236,
 7523,
 -57050,
 556044687,
 8338,
 -57049,
 556101417,
 11388,
 -57048,
 556163455,
 7522,
 -57047,
 556220551,
 8337,
 -1,
 556275060,
 8336,
 556475195,
 509619422,
 -1,
 556540730,
 556408797,
 -1,
 556606263,
 556485683,
 -1,
 556671336,
 556568975,
 79,
 556736866,
 556600355,
 -1,
 556802360,
 556686943,
 -1,
 556867895,
 556774297,
 416,
 556990463,
 556793978,
 -1,
 -57037,
 556910588,
 7904,
 -57036,
 556949157,
 7902,
 -57035,
 557012677,
 7900,
 -57034,
 557071163,
 7906,
 -1,
 557127585,
 7898,
 -1,
 556831717,
 7886,
 557392195,
 556742176,
 -1,
 557457729,
 557355407,
 -1,
 557523262,
 557433558,
 -1,
 557588797,
 557454965,
 558,
 -1,
 557515030,
 560,
 -1,
 557525075,
 7884,
 557842431,
 557502249,
 -1,
 -57024,
 557733573,
 524,
 -1,
 557782945,
 336,
 558039039,
 557408777,
 214,
 -1,
 557908246,
 554,
 558113100,
 557329630,
 -1,
 558178635,
 558066761,
 212,
 558301183,
 558104698,
 -1,
 -57017,
 558221308,
 7894,
 -57016,
 558259877,
 7892,
 -57015,
 558323397,
 7890,
 -57014,
 558381883,
 7896,
 -1,
 558438305,
 7888,
 -1,
 558113308,
 465,
 558702929,
 558090236,
 213,
 558825471,
 558628986,
 -1,
 -57009,
 558727227,
 556,
 -57008,
 558774430,
 7758,
 -1,
 558831521,
 7756,
 559030615,
 558661605,
 -1,
 559096150,
 558962575,
 332,
 559218687,
 559022202,
 -1,
 -57003,
 559109829,
 7760,
 -1,
 559159201,
 7762,
 -1,
 559047475,
 415,
 559423833,
 559005952,
 216,
 -1,
 559349888,
 510,
 559554907,
 559387460,
 490,
 -1,
 559481110,
 492,
 559685982,
 559512772,
 -1,
 -56995,
 559650540,
 42828,
 -1,
 559713240,
 42826,
 -56993,
 559639264,
 526,
 -56992,
 559830725,
 210,
 -56991,
 559885257,
 334,
 -1,
 559945633,
 211,
 560144741,
 556704258,
 -1,
 -56988,
 560107919,
 390,
 -1,
 560152711,
 400,
 -56986,
 560123466,
 546,
 -56985,
 560304527,
 42830,
 -1,
 560357759,
 418,
 560538011,
 556602740,
 65,
 560603535,
 560466979,
 -1,
 560669043,
 560540894,
 -1,
 560734578,
 560622665,
 194,
 560857087,
 560660602,
 -1,
 -56978,
 560777212,
 7850,
 -56977,
 560815781,
 7848,
 -56976,
 560879301,
 7846,
 -56975,
 560937787,
 7852,
 -1,
 560994209,
 7844,
 -1,
 560669212,
 461,
 561258876,
 560608800,
 -1,
 561324410,
 561222031,
 -1,
 561389945,
 561300182,
 -1,
 561455480,
 561321589,
 550,
 -1,
 561381654,
 480,
 -1,
 561391699,
 7840,
 -1,
 561368910,
 512,
 561774591,
 561275401,
 196,
 -1,
 561643798,
 478,
 561848707,
 561195977,
 258,
 561971199,
 561774714,
 -1,
 -56961,
 561891324,
 7860,
 -56960,
 561929893,
 7858,
 -56959,
 561993413,
 7856,
 -56958,
 562051899,
 7862,
 -1,
 562108321,
 7854,
 562307463,
 561820074,
 -1,
 562372998,
 562239093,
 197,
 -1,
 562299008,
 506,
 -1,
 562309203,
 7680,
 -56952,
 562284540,
 195,
 -56951,
 562544896,
 570,
 -56950,
 562598724,
 260,
 -56949,
 562659387,
 256,
 -56948,
 562719456,
 514,
 -56947,
 562781861,
 7842,
 -56946,
 562845381,
 192,
 -1,
 562894753,
 193,
 563093907,
 560545927,
 198,
 563216383,
 563022883,
 -1,
 -56942,
 563118139,
 482,
 -1,
 563156897,
 508,
 563356053,
 563074990,
 42808,
 -1,
 563285377,
 42810,
 -56938,
 563340270,
 42812,
 -56937,
 563465802,
 42806,
 -56936,
 563515791,
 42804,
 -56935,
 563576544,
 11373,
 -56934,
 563630662,
 393,
 -1,
 563680628,
 42802,
 563880393,
 560480391,
 69,
 563945918,
 563809315,
 -1,
 564011434,
 563883230,
 -1,
 564076967,
 563965001,
 202,
 564199423,
 564002816,
 -1,
 564208038,
 564075883,
 -1,
 -56926,
 564185084,
 7876,
 -56925,
 564223653,
 7874,
 -56924,
 564287173,
 7872,
 -56923,
 564345659,
 7878,
 -1,
 564402081,
 7870,
 -1,
 564144211,
 7704,
 564666793,
 564019987,
 552,
 -1,
 564592779,
 7708,
 -1,
 564601372,
 282,
 564863409,
 563951136,
 -1,
 564928944,
 564826511,
 -1,
 564994479,
 564904662,
 -1,
 -56914,
 564930643,
 7864,
 -1,
 564991605,
 278,
 -1,
 564973390,
 516,
 -1,
 564879881,
 203,
 565322165,
 564822075,
 274,
 565444607,
 565248122,
 -1,
 -56908,
 565335749,
 7700,
 -1,
 565385121,
 7702,
 565584311,
 565299196,
 7868,
 -1,
 565510691,
 7706,
 -56904,
 565559552,
 582,
 -56903,
 565678916,
 280,
 -56902,
 565734112,
 518,
 -56901,
 565796517,
 7866,
 -56900,
 565860037,
 200,
 -56899,
 565914569,
 276,
 -1,
 565974945,
 201,
 566174146,
 563931089,
 439,
 566296575,
 566099968,
 -1,
 -56895,
 566222737,
 494,
 -1,
 566275420,
 440,
 566436292,
 566149844,
 42858,
 -1,
 566384779,
 208,
 566567367,
 566384764,
 -1,
 -56890,
 566523516,
 42786,
 -1,
 566585136,
 42788,
 -56888,
 566540819,
 425,
 -1,
 566725559,
 330,
 566895093,
 563859018,
 85,
 566960628,
 566820864,
 -1,
 567026163,
 566943602,
 -1,
 567091674,
 566965792,
 -1,
 567157205,
 567042569,
 220,
 567279615,
 567083008,
 -1,
 567288276,
 567156075,
 -1,
 -56879,
 567246907,
 469,
 -56878,
 567301829,
 475,
 -56877,
 567356983,
 473,
 -1,
 567416737,
 471,
 -1,
 567224403,
 7794,
 567738367,
 567120271,
 -1,
 567747033,
 567660329,
 -1,
 -56872,
 567695045,
 532,
 -1,
 567744417,
 368,
 -1,
 567722721,
 7908,
 568009187,
 567041631,
 -1,
 568074722,
 567980953,
 431,
 568197119,
 568000634,
 -1,
 -56866,
 568117244,
 7918,
 -56865,
 568155813,
 7916,
 -56864,
 568219333,
 7914,
 -56863,
 568277819,
 7920,
 -1,
 568334241,
 7912,
 -1,
 568038373,
 7910,
 568599015,
 567986172,
 360,
 568721407,
 568524800,
 -1,
 -56858,
 568600659,
 7796,
 -1,
 568663408,
 7800,
 568861163,
 568536286,
 -1,
 568926698,
 568814665,
 219,
 -1,
 568853027,
 7798,
 -1,
 568861212,
 467,
 569123309,
 568819771,
 362,
 -1,
 569049238,
 7802,
 -56850,
 569094576,
 366,
 -56849,
 569217860,
 370,
 -56848,
 569273056,
 534,
 -56847,
 569333445,
 217,
 -56846,
 569387977,
 364,
 -1,
 569448353,
 218,
 -1,
 566961998,
 580,
 -1,
 566929105,
 433,
 569778709,
 566870740,
 84,
 569844229,
 569707555,
 -1,
 569909756,
 569781470,
 -1,
 -56839,
 569873677,
 538,
 -56838,
 569928804,
 7792,
 -56837,
 569983763,
 354,
 -1,
 570040860,
 356,
 570237441,
 569849376,
 -1,
 570302976,
 570202701,
 -1,
 -56833,
 570239059,
 7788,
 -1,
 570300021,
 7786,
 -1,
 570253851,
 574,
 -56830,
 570212608,
 358,
 -56829,
 570535207,
 430,
 -56828,
 570587896,
 7790,
 -1,
 570646176,
 428,
 570827276,
 569824772,
 -1,
 570892808,
 570758516,
 11375,
 -1,
 570851040,
 11376,
 -56823,
 570873774,
 581,
 -56822,
 570982373,
 412,
 -56821,
 571044696,
 42880,
 -1,
 571107764,
 42878,
 571286032,
 570791363,
 -1,
 -56818,
 571264354,
 423,
 -56817,
 571325716,
 388,
 -1,
 571363508,
 444,
 571548179,
 571236273,
 222,
 571670527,
 571477599,
 42852,
 -1,
 571542251,
 42854,
 -56812,
 571533086,
 42792,
 -1,
 571714834,
 42794,
 571875893,
 569729407,
 73,
 571941420,
 571804707,
 -1,
 572006943,
 571880992,
 -1,
 572072477,
 571969935,
 -1,
 572138012,
 572048086,
 -1,
 -56805,
 572074067,
 7882,
 -1,
 572135029,
 304,
 -1,
 572116814,
 520,
 572456959,
 572023305,
 207,
 -1,
 572326016,
 7726,
 572531233,
 571983868,
 296,
 -1,
 572457507,
 7724,
 572662308,
 572468446,
 -1,
 -56797,
 572615753,
 206,
 -1,
 572662300,
 463,
 -56795,
 572637440,
 407,
 -56794,
 572822340,
 302,
 -56793,
 572883003,
 298,
 -56792,
 572943072,
 522,
 -56791,
 573005477,
 7880,
 -56790,
 573068997,
 204,
 -56789,
 573123529,
 300,
 -1,
 573183905,
 205,
 573383219,
 571903724,
 -1,
 -56786,
 573358804,
 42886,
 -56785,
 573421343,
 42884,
 -56784,
 573483348,
 42882,
 -56783,
 573526755,
 42877,
 -56782,
 573591126,
 42875,
 -1,
 573650464,
 42873,
 -56780,
 573355807,
 42860,
 -1,
 573807238,
 406,
 573973064,
 571848479,
 83,
 574038596,
 573901859,
 -1,
 574104125,
 573975774,
 -1,
 574169658,
 574038556,
 352,
 -1,
 574095546,
 7782,
 -56773,
 574133517,
 536,
 -56772,
 574254153,
 348,
 -1,
 574309139,
 350,
 574497345,
 574044972,
 -1,
 574562880,
 574433363,
 7778,
 -1,
 574488762,
 7784,
 -1,
 574494325,
 7776,
 574759491,
 574429089,
 346,
 -1,
 574685370,
 7780,
 -1,
 574734909,
 11390,
 -56763,
 573997481,
 586,
 -56762,
 574905011,
 7838,
 -56761,
 574959647,
 399,
 -1,
 575020120,
 42891,
 575218270,
 573942100,
 82,
 575283802,
 575143936,
 -1,
 575349337,
 575266674,
 -1,
 575414865,
 575290052,
 -1,
 575480400,
 575390422,
 -1,
 575545935,
 575416403,
 7770,
 -1,
 575471894,
 7772,
 -1,
 575477365,
 7768,
 -1,
 575459150,
 528,
 575808084,
 575352030,
 -1,
 -56749,
 575750931,
 342,
 -1,
 575808028,
 344,
 -56747,
 575783811,
 11364,
 -56746,
 575979776,
 588,
 -56745,
 576027384,
 7774,
 -56744,
 576088800,
 530,
 -1,
 576133025,
 340,
 -1,
 575321314,
 42842,
 576397917,
 575229170,
 -1,
 -56740,
 576340103,
 398,
 -1,
 576400682,
 42814,
 -1,
 576377216,
 42844,
 576660083,
 575173464,
 76,
 576725618,
 576588835,
 -1,
 576791140,
 576666308,
 -1,
 576856675,
 576766689,
 7734,
 -1,
 576782614,
 7736,
 -1,
 576835375,
 11360,
 577053288,
 576728286,
 -1,
 -56730,
 577006692,
 7740,
 -56729,
 577061651,
 315,
 -1,
 577118748,
 317,
 577315435,
 577025823,
 -1,
 -56726,
 577293268,
 321,
 -1,
 577339789,
 456,
 577512046,
 577275046,
 -1,
 -56723,
 577488892,
 11362,
 -1,
 577518376,
 319,
 -56721,
 577469176,
 7738,
 -56720,
 577658149,
 42824,
 -56719,
 577709902,
 573,
 -1,
 577771425,
 313,
 -1,
 576679721,
 455,
 578036356,
 576644078,
 89,
 578101891,
 577965091,
 -1,
 578167418,
 578041376,
 -1,
 578232953,
 578132557,
 -1,
 -56712,
 578168915,
 7924,
 -1,
 578229877,
 7822,
 -1,
 578183689,
 376,
 578495100,
 578117280,
 435,
 -1,
 578420741,
 7926,
 -56707,
 578471932,
 7928,
 -56706,
 578601216,
 590,
 -56705,
 578650171,
 562,
 -56704,
 578715022,
 7934,
 -56703,
 578770629,
 7922,
 -56702,
 578826421,
 374,
 -1,
 578885537,
 221,
 -1,
 578065200,
 540,
 579150486,
 577997023,
 78,
 579216021,
 579079203,
 -1,
 579281546,
 579171160,
 -1,
 -56696,
 579245613,
 544,
 -56695,
 579299430,
 7752,
 -1,
 579355599,
 413,
 579543694,
 579218654,
 -1,
 -56692,
 579497060,
 7754,
 -56691,
 579552019,
 325,
 -1,
 579609116,
 327,
 579805841,
 579484460,
 -1,
 -56688,
 579741779,
 7750,
 -1,
 579802741,
 7748,
 -56686,
 579782652,
 209,
 -56685,
 579976728,
 459,
 -56684,
 580015813,
 504,
 -1,
 580065185,
 323,
 -1,
 579170089,
 458,
 580330152,
 579089952,
 68,
 580395686,
 580258851,
 -1,
 580461212,
 580368159,
 -1,
 580526747,
 580419995,
 498,
 -1,
 580455477,
 453,
 -1,
 580504532,
 272,
 580723360,
 580398302,
 -1,
 -56674,
 580676708,
 7698,
 -56673,
 580731667,
 7696,
 -1,
 580788764,
 270,
 580985507,
 580664108,
 -1,
 -56670,
 580921427,
 7692,
 -1,
 580982389,
 7690,
 -56668,
 580962918,
 395,
 -56667,
 581139192,
 7694,
 -1,
 581197472,
 394,
 581435391,
 580380446,
 497,
 -1,
 581307445,
 452,
 581509817,
 580278411,
 72,
 581575350,
 581438499,
 -1,
 581640880,
 581514784,
 -1,
 581706414,
 581605965,
 -1,
 -56659,
 581642323,
 7716,
 -1,
 581703285,
 7714,
 -56657,
 581657097,
 7718,
 -1,
 581847653,
 11367,
 582034100,
 581577950,
 -1,
 -56654,
 581987401,
 292,
 -56653,
 582042387,
 7720,
 -1,
 582099484,
 542,
 -56651,
 582009088,
 294,
 -1,
 582233039,
 7722,
 -56649,
 581557579,
 502,
 -56648,
 582371230,
 42790,
 -1,
 582425422,
 11381,
 582623943,
 581456611,
 71,
 582689477,
 582552611,
 -1,
 582755007,
 582626526,
 -1,
 -56643,
 582708297,
 284,
 -56642,
 582763283,
 290,
 -1,
 582820380,
 486,
 -56640,
 582729984,
 484,
 -56639,
 582975547,
 7712,
 -56638,
 583032480,
 403,
 -56637,
 583088945,
 288,
 -56636,
 583150537,
 286,
 -1,
 583210913,
 500,
 -56634,
 582647304,
 577,
 -1,
 583343338,
 404,
 583541461,
 582560990,
 67,
 583606994,
 583470115,
 -1,
 583672526,
 583544030,
 -1,
 583738060,
 583615251,
 199,
 -1,
 583663744,
 7688,
 -56627,
 583691337,
 264,
 -1,
 583803420,
 268,
 -56625,
 583647488,
 571,
 -56624,
 583949984,
 391,
 -56623,
 584006449,
 266,
 -1,
 584062881,
 262,
 584262356,
 583585505,
 42796,
 -1,
 584191116,
 42798,
 -1,
 584226093,
 42862,
 584458981,
 583526174,
 90,
 584581119,
 584387619,
 -1,
 584590044,
 584463904,
 -1,
 584655579,
 584555085,
 -1,
 -56614,
 584591443,
 7826,
 -1,
 584652405,
 379,
 -1,
 584600165,
 11371,
 584917727,
 584562463,
 -1,
 -56610,
 584900078,
 11391,
 -1,
 584960980,
 437,
 585114338,
 584854750,
 -1,
 -56607,
 585067593,
 7824,
 -1,
 585114140,
 381,
 -56605,
 585071352,
 7828,
 -56604,
 585260704,
 548,
 -1,
 585308065,
 377,
 585507571,
 584413320,
 75,
 585629695,
 585436195,
 -1,
 585638635,
 585512480,
 -1,
 -56599,
 585603674,
 7730,
 -56598,
 585654811,
 42818,
 -1,
 585714277,
 11369,
 585900781,
 585613568,
 42816,
 -1,
 585826469,
 42820,
 586031856,
 585837790,
 -1,
 -56593,
 585974547,
 310,
 -1,
 586031644,
 488,
 -56591,
 585988856,
 7732,
 -56590,
 586178208,
 408,
 -1,
 586225569,
 7728,
 586425087,
 585489672,
 87,
 586490622,
 586353699,
 -1,
 586556154,
 586429984,
 -1,
 586621689,
 586521165,
 -1,
 -56584,
 586557523,
 7816,
 -1,
 586618485,
 7814,
 -1,
 586572297,
 7812,
 -56581,
 586505888,
 11378,
 -56580,
 586831557,
 7808,
 -56579,
 586887349,
 372,
 -1,
 586946465,
 7810,
 -1,
 586475046,
 503,
 587211529,
 586405806,
 86,
 587277062,
 587140131,
 -1,
 587342596,
 587216416,
 -1,
 -56573,
 587307610,
 7806,
 -1,
 587358747,
 42846,
 -56571,
 587319292,
 7804,
 -1,
 587488928,
 434,
 -56569,
 587260910,
 42848,
 -56568,
 587623715,
 42850,
 -1,
 587679589,
 42856,
 587866899,
 587177961,
 80,
 587988991,
 587795491,
 -1,
 587997967,
 587904799,
 -1,
 588063502,
 587975636,
 11363,
 -1,
 587991787,
 42832,
 -1,
 588032261,
 42836,
 -56560,
 587947680,
 420,
 -56559,
 588206429,
 42834,
 -56558,
 588266289,
 7766,
 -1,
 588322721,
 7764,
 588522269,
 587802230,
 66,
 588587804,
 588450851,
 -1,
 588653336,
 588528428,
 -1,
 -56553,
 588589139,
 7684,
 -1,
 588650101,
 7682,
 -56551,
 588630630,
 386,
 -56550,
 588824832,
 579,
 -56549,
 588872440,
 7686,
 -1,
 588930720,
 385,
 -1,
 588559398,
 42822,
 589177639,
 588480485,
 77,
 589243172,
 589106211,
 -1,
 589308706,
 589183788,
 -1,
 -56543,
 589244499,
 7746,
 -1,
 589305461,
 7744,
 -56541,
 589258400,
 11374,
 -1,
 589436833,
 7742,
 589692927,
 589194047,
 -1,
 -56538,
 589617070,
 7932,
 -1,
 589659138,
 7930,
 589833003,
 589161220,
 88,
 589955071,
 589761718,
 -1,
 -56534,
 589863505,
 7818,
 -1,
 589914633,
 7820,
 590095151,
 589801284,
 81,
 590217215,
 590023715,
 -1,
 -56530,
 590135624,
 42838,
 -1,
 590166279,
 42840,
 590357299,
 590049065,
 74,
 590479359,
 590285859,
 -1,
 -56526,
 590397696,
 584,
 -1,
 590426293,
 308,
 590675967,
 590302806,
 70,
 590741503,
 590548003,
 -1,
 -56522,
 590634656,
 401,
 -1,
 590691121,
 7710,
 590938111,
 556557471,
 -1,
 -56519,
 590844629,
 338,
 -1,
 590898599,
 306,
 -1,
 556512391,
 10013,
 591143808,
 556431834,
 -1,
 591209320,
 591116063,
 -1,
 591274855,
 591167796,
 -1,
 591340355,
 591243604,
 640,
 591405890,
 591285490,
 -1,
 -56511,
 591374676,
 7449,
 -1,
 591431903,
 7438,
 -1,
 591384949,
 42870,
 591668039,
 591303055,
 7439,
 -56507,
 591646282,
 7445,
 -56506,
 591700510,
 7440,
 -1,
 591741063,
 630,
 591930187,
 591643348,
 7451,
 592052223,
 591910404,
 -1,
 -56502,
 591964500,
 7450,
 -1,
 592003207,
 11387,
 592192334,
 591872135,
 7431,
 -56499,
 592177105,
 7459,
 -1,
 592233999,
 7430,
 592388944,
 592147288,
 671,
 -1,
 592318047,
 7436,
 592520018,
 592339327,
 618,
 -1,
 592482572,
 641,
 592651092,
 592466659,
 610,
 -1,
 592579958,
 667,
 592782166,
 592586358,
 665,
 -1,
 592716363,
 7427,
 592913240,
 592713076,
 7424,
 -1,
 592855175,
 7425,
 -56487,
 592897822,
 7458,
 -56486,
 593028078,
 655,
 -56485,
 593091848,
 7457,
 -56484,
 593156014,
 7456,
 -56483,
 593219146,
 7452,
 -56482,
 593278751,
 42801,
 -56481,
 593338345,
 7448,
 -56480,
 593397983,
 628,
 -56479,
 593461221,
 7437,
 -56478,
 593522824,
 7435,
 -56477,
 593588009,
 7434,
 -56476,
 593647755,
 668,
 -56475,
 593710678,
 42800,
 -56474,
 593770016,
 7429,
 -1,
 593833182,
 7428,
 -1,
 591252198,
 663,
 594092909,
 591178628,
 -1,
 594158444,
 594074151,
 -1,
 -56469,
 594105847,
 674,
 -1,
 594168454,
 426,
 -1,
 594135987,
 451,
 594420594,
 594028877,
 -1,
 594486129,
 594375667,
 -1,
 -56464,
 594453102,
 684,
 -1,
 594489711,
 664,
 -1,
 594425824,
 685,
 594748276,
 594373435,
 662,
 -1,
 594677343,
 446,
 594879350,
 594695658,
 660,
 -1,
 594808415,
 673,
 595010425,
 594810228,
 -1,
 -56456,
 594968480,
 450,
 -1,
 595027760,
 7461,
 -56454,
 594994834,
 422,
 -56453,
 595190527,
 447,
 -56452,
 595254334,
 7460,
 -56451,
 595316249,
 443,
 -56450,
 595370806,
 661,
 -56449,
 595424687,
 449,
 -1,
 595474387,
 448,
 595722239,
 591087811,
 -1,
 595731332,
 595635557,
 -1,
 -56445,
 595697641,
 43004,
 -1,
 595742294,
 43003,
 595927943,
 595681663,
 -1,
 -56442,
 595890434,
 43005,
 -1,
 595920299,
 43006,
 -1,
 595861836,
 43007,
 596190176,
 509579665,
 -1,
 596255664,
 596146650,
 -1,
 596321167,
 596230868,
 -1,
 596386702,
 596270690,
 -1,
 -56435,
 596362229,
 3735,
 -1,
 596427207,
 3734,
 -1,
 596349327,
 3733,
 596648852,
 596287465,
 -1,
 596714387,
 596598370,
 -1,
 -56430,
 596689909,
 3742,
 -1,
 596754887,
 3740,
 -1,
 596677007,
 3739,
 596976536,
 596609247,
 -1,
 -56426,
 596960810,
 3725,
 -56425,
 597004687,
 3737,
 -1,
 597055005,
 3719,
 597238685,
 596930696,
 -1,
 597304220,
 597188194,
 -1,
 -56421,
 597279733,
 3716,
 -1,
 597344711,
 3714,
 -1,
 597266831,
 3713,
 597566368,
 597212792,
 -1,
 -56417,
 597541877,
 3722,
 -1,
 597606855,
 3754,
 597762979,
 597523655,
 -1,
 -56414,
 597726928,
 3749,
 -1,
 597780647,
 3747,
 597959590,
 597712482,
 -1,
 -56411,
 597935093,
 3758,
 -1,
 598000071,
 3755,
 598156201,
 597905783,
 -1,
 -56408,
 598131701,
 3741,
 -1,
 598196679,
 3743,
 -56406,
 598140458,
 3746,
 -56405,
 598335887,
 3751,
 -56404,
 598380943,
 3757,
 -56403,
 598443572,
 3745,
 -56402,
 598489796,
 3732,
 -56401,
 598553064,
 3720,
 -1,
 598616726,
 3738,
 598811586,
 596237494,
 -1,
 598877110,
 598742388,
 3760,
 -56397,
 598860782,
 3779,
 -56396,
 598900709,
 3763,
 -56395,
 598958463,
 3780,
 -1,
 599004532,
 3762,
 599204792,
 598860782,
 3766,
 -1,
 599188462,
 3767,
 599335866,
 599182922,
 3768,
 -1,
 599313994,
 3769,
 599466941,
 599294085,
 -1,
 -56388,
 599430445,
 3771,
 -1,
 599465278,
 3761,
 599663551,
 599417215,
 3764,
 -1,
 599613823,
 3765,
 599794625,
 599605383,
 3776,
 -1,
 599744895,
 3777,
 -1,
 599757199,
 3778,
 599991248,
 598751640,
 -1,
 600056774,
 599966420,
 -1,
 -56379,
 600039823,
 3794,
 -1,
 600072278,
 3795,
 600253385,
 600028959,
 -1,
 -56376,
 600207086,
 3798,
 -1,
 600263810,
 3799,
 600449996,
 600198742,
 -1,
 -56373,
 600415216,
 3796,
 -1,
 600469111,
 3797,
 -56371,
 600434581,
 3792,
 -56370,
 600610239,
 3793,
 -56369,
 600673468,
 3801,
 -1,
 600720695,
 3800,
 600908758,
 599968197,
 -1,
 600974292,
 600883924,
 -1,
 -56365,
 600924543,
 3786,
 -1,
 600989279,
 3785,
 -56363,
 600917405,
 3784,
 -1,
 601108034,
 3787,
 601301977,
 600881512,
 -1,
 -56360,
 601264504,
 3773,
 -1,
 601324740,
 3772,
 601498588,
 601251426,
 -1,
 -56357,
 601460110,
 3804,
 -1,
 601523764,
 3805,
 -56355,
 601459862,
 3789,
 -56354,
 601649809,
 3782,
 -56353,
 601703932,
 3759,
 -1,
 601763197,
 3788,
 601957360,
 596159946,
 -1,
 602022894,
 601882624,
 -1,
 602088423,
 601998036,
 -1,
 602153958,
 602071442,
 -1,
 -56347,
 602124776,
 68414,
 -1,
 602160060,
 68412,
 -1,
 602124921,
 11004,
 602416106,
 602052035,
 -1,
 -56343,
 602386875,
 68415,
 -1,
 602422153,
 68413,
 -56341,
 602395628,
 10200,
 -56340,
 602568699,
 10782,
 -56339,
 602619667,
 10201,
 -1,
 602681410,
 9711,
 602931199,
 601991548,
 10923,
 -1,
 602801865,
 10925,
 -56335,
 601931790,
 9790,
 -1,
 602967139,
 917505,
 603137444,
 509501823,
 -1,
 603202815,
 603097859,
 -1,
 603268344,
 603136106,
 -1,
 603333765,
 603218861,
 -1,
 603399267,
 603268726,
 -1,
 603464773,
 603329039,
 -1,
 603530252,
 603394447,
 -1,
 603595773,
 603460617,
 -1,
 -56325,
 603553816,
 65669,
 -56324,
 603606643,
 65668,
 -1,
 603653036,
 65667,
 603857920,
 603526465,
 -1,
 -56321,
 603815930,
 65677,
 -1,
 603868767,
 65676,
 604054531,
 603788557,
 -1,
 -56318,
 604012522,
 65675,
 -1,
 604065421,
 65674,
 604251142,
 603985094,
 -1,
 -56315,
 604209160,
 65673,
 -1,
 604262018,
 65672,
 604447753,
 604181633,
 -1,
 -56312,
 604405778,
 65671,
 -1,
 604458605,
 65670,
 -56310,
 604378053,
 65666,
 -56309,
 604574492,
 65665,
 -1,
 604639670,
 65664,
 604840983,
 603460737,
 -1,
 -56306,
 604771649,
 65713,
 -56305,
 604837133,
 65712,
 -56304,
 604902598,
 65711,
 -56303,
 604968065,
 65710,
 -56302,
 605033481,
 65709,
 -56301,
 605098940,
 65708,
 -56300,
 605164379,
 65707,
 -56299,
 605229753,
 65706,
 -56298,
 605295119,
 65705,
 -1,
 605360527,
 65704,
 605561889,
 604771526,
 -1,
 -56295,
 605492545,
 65722,
 -56294,
 605558029,
 65721,
 -56293,
 605623494,
 65720,
 -56292,
 605689011,
 65719,
 -56291,
 605754300,
 65718,
 -56290,
 605819758,
 65717,
 -56289,
 605885095,
 65716,
 -56288,
 605950479,
 65715,
 -1,
 606015887,
 65714,
 606217258,
 605492233,
 -1,
 -56285,
 606147907,
 65703,
 -56284,
 606213389,
 65702,
 -56283,
 606278854,
 65701,
 -56282,
 606344124,
 65699,
 -56281,
 606409548,
 65698,
 -56280,
 606474919,
 65697,
 -56279,
 606540364,
 65696,
 -1,
 606605711,
 65695,
 606807090,
 606147853,
 -1,
 -56276,
 606737729,
 65729,
 -56275,
 606802953,
 65728,
 -56274,
 606868412,
 65727,
 -56273,
 606933836,
 65726,
 -56272,
 606999207,
 65725,
 -56271,
 607064591,
 65724,
 -1,
 607129999,
 65723,
 607331384,
 606737340,
 -1,
 -56268,
 607261825,
 65694,
 -56267,
 607327321,
 65693,
 -56266,
 607392423,
 65692,
 -56265,
 607457852,
 65691,
 -1,
 607523217,
 65690,
 607724606,
 607261351,
 -1,
 -56262,
 607654943,
 65682,
 -56261,
 607720342,
 65681,
 -56260,
 607785672,
 65680,
 -56259,
 607851033,
 65679,
 -1,
 607916509,
 65678,
 608117826,
 607654732,
 -1,
 -56256,
 608047783,
 65687,
 -56255,
 608113281,
 65686,
 -1,
 608178625,
 65685,
 608436223,
 608048449,
 -1,
 -56252,
 608309827,
 65731,
 -1,
 608375183,
 65730,
 608632831,
 603394727,
 -1,
 608642128,
 608506889,
 -1,
 -56248,
 608572737,
 65757,
 -56247,
 608638221,
 65756,
 -56246,
 608703686,
 65755,
 -56245,
 608769153,
 65754,
 -56244,
 608834569,
 65753,
 -56243,
 608900030,
 65752,
 -56242,
 608965452,
 65751,
 -56241,
 609030823,
 65750,
 -1,
 609096207,
 65749,
 609297497,
 608572348,
 -1,
 -56238,
 609228097,
 65748,
 -56237,
 609293581,
 65747,
 -56236,
 609358977,
 65745,
 -56235,
 609424393,
 65744,
 -56234,
 609489830,
 65743,
 -56233,
 609555113,
 65742,
 -56232,
 609620514,
 65741,
 -1,
 609685989,
 65740,
 609887328,
 609227596,
 -1,
 -56229,
 609817729,
 65739,
 -56228,
 609883068,
 65738,
 -56227,
 609948574,
 65737,
 -56226,
 610013863,
 65736,
 -56225,
 610079249,
 65735,
 -1,
 610144721,
 65734,
 610402303,
 609817255,
 -1,
 -56222,
 610276373,
 65733,
 -1,
 610341280,
 65732,
 610598911,
 603380556,
 -1,
 610608259,
 610472615,
 -1,
 610673776,
 610537999,
 -1,
 -56217,
 610604353,
 65778,
 -56216,
 610669837,
 65777,
 -56215,
 610735302,
 65776,
 -56214,
 610800769,
 65775,
 -56213,
 610866185,
 65774,
 -56212,
 610931644,
 65773,
 -56211,
 610997068,
 65772,
 -56210,
 611062439,
 65771,
 -56209,
 611127823,
 65770,
 -1,
 611193231,
 65769,
 611394683,
 610603407,
 -1,
 -56206,
 611325249,
 65768,
 -56205,
 611390733,
 65767,
 -56204,
 611456198,
 65766,
 -56203,
 611521665,
 65765,
 -56202,
 611587081,
 65764,
 -56201,
 611652540,
 65763,
 -56200,
 611717964,
 65762,
 -56199,
 611783335,
 65761,
 -56198,
 611848719,
 65760,
 -1,
 611914127,
 65759,
 612115586,
 611324583,
 -1,
 -56195,
 612046145,
 65784,
 -56194,
 612111629,
 65783,
 -56193,
 612177094,
 65782,
 -56192,
 612242561,
 65781,
 -56191,
 612307623,
 65780,
 -1,
 612373007,
 65779,
 -1,
 612045924,
 65785,
 -56188,
 610538418,
 65786,
 -1,
 612569747,
 65758,
 612771054,
 603308623,
 -1,
 612836571,
 612727843,
 -1,
 612902033,
 612766918,
 -1,
 -56183,
 612832554,
 65572,
 -56182,
 612898002,
 65551,
 -56181,
 612963490,
 65608,
 -56180,
 613028948,
 65592,
 -56179,
 613094384,
 65597,
 -56178,
 613159785,
 65558,
 -56177,
 613225168,
 65567,
 -56176,
 613290550,
 65603,
 -1,
 613355948,
 65554,
 613557403,
 612832265,
 -1,
 -56173,
 613487963,
 65586,
 -56172,
 613553461,
 65585,
 -56171,
 613618893,
 65546,
 -56170,
 613684287,
 65565,
 -56169,
 613749739,
 65591,
 -56168,
 613815185,
 65578,
 -56167,
 613880515,
 65564,
 -56166,
 613945905,
 65545,
 -1,
 614011335,
 65570,
 614212773,
 613487271,
 -1,
 -56163,
 614143312,
 65606,
 -56162,
 614208791,
 65538,
 -56161,
 614274286,
 65577,
 -56160,
 614339752,
 65580,
 -56159,
 614405131,
 65600,
 -56158,
 614470614,
 65562,
 -56157,
 614536054,
 65560,
 -56156,
 614601324,
 65573,
 -1,
 614666748,
 65599,
 614868143,
 614142351,
 -1,
 -56153,
 614798678,
 65582,
 -56152,
 614864143,
 65536,
 -56151,
 614929608,
 65543,
 -56150,
 614995085,
 65561,
 -56149,
 615060559,
 65589,
 -56148,
 615125990,
 65587,
 -56147,
 615191419,
 65566,
 -56146,
 615256845,
 65579,
 -1,
 615322156,
 65541,
 615523512,
 614798465,
 -1,
 -56143,
 615454048,
 65590,
 -56142,
 615519535,
 65610,
 -56141,
 615584990,
 65553,
 -56140,
 615650477,
 65611,
 -56139,
 615715886,
 65550,
 -56138,
 615781122,
 65607,
 -56137,
 615846488,
 65539,
 -1,
 615911884,
 65576,
 616113345,
 615453628,
 -1,
 -56134,
 616043812,
 65605,
 -56133,
 616109187,
 65547,
 -56132,
 616174633,
 65542,
 -56131,
 616240081,
 65552,
 -56130,
 616305486,
 65601,
 -56129,
 616370967,
 65594,
 -56128,
 616436342,
 65583,
 -1,
 616501751,
 65593,
 616703178,
 616043340,
 -1,
 -56125,
 616633675,
 65568,
 -56124,
 616699155,
 65537,
 -56123,
 616764659,
 65588,
 -56122,
 616830088,
 65549,
 -56121,
 616895371,
 65609,
 -56120,
 616960776,
 65574,
 -56119,
 617026161,
 65581,
 -1,
 617091516,
 65563,
 617293011,
 616632847,
 -1,
 -56116,
 617223422,
 65596,
 -56115,
 617288861,
 65571,
 -56114,
 617354298,
 65559,
 -56113,
 617419724,
 65544,
 -56112,
 617485156,
 65557,
 -56111,
 617550610,
 65584,
 -56110,
 617615975,
 65569,
 -1,
 617681369,
 65540,
 617882840,
 617223437,
 -1,
 -56107,
 617813240,
 65612,
 -56106,
 617878544,
 65602,
 -56105,
 617943635,
 65555,
 -1,
 618009009,
 65556,
 618266623,
 617813313,
 -1,
 -56102,
 618140283,
 65613,
 -1,
 618205594,
 65604,
 618463231,
 612795132,
 -1,
 618472673,
 618337549,
 -1,
 -56098,
 618403137,
 65629,
 -56097,
 618468481,
 65628,
 -56096,
 618533708,
 65627,
 -1,
 618599079,
 65626,
 618800356,
 618402945,
 -1,
 -56093,
 618730428,
 65624,
 -1,
 618795852,
 65623,
 618996967,
 618730428,
 -1,
 -56090,
 618927425,
 65621,
 -1,
 618992838,
 65620,
 619193578,
 618926607,
 -1,
 -56087,
 619124033,
 65617,
 -1,
 619189517,
 65616,
 -56085,
 619123978,
 65625,
 -56084,
 619320437,
 65622,
 -56083,
 619385782,
 65619,
 -1,
 619451182,
 65618,
 619708415,
 612730570,
 -1,
 619717879,
 619581967,
 -1,
 619783411,
 619647820,
 -1,
 -56078,
 619713587,
 65689,
 -1,
 619778899,
 65688,
 619980022,
 619713191,
 -1,
 -56075,
 619910427,
 65684,
 -1,
 619975895,
 65683,
 -1,
 619910264,
 65700,
 -1,
 619647793,
 65746,
 620363775,
 603193344,
 -1,
 620373246,
 620259818,
 -1,
 620438781,
 620355442,
 -1,
 -56068,
 620411200,
 10771,
 -1,
 620473361,
 10770,
 -1,
 620400242,
 10772,
 -1,
 620345726,
 8232,
 620766554,
 603160549,
 -1,
 620832089,
 620702779,
 -1,
 620897576,
 620788186,
 -1,
 620963078,
 620869407,
 -1,
 -56060,
 620935065,
 6426,
 -56059,
 620976297,
 6425,
 -1,
 621024628,
 6427,
 621225224,
 620946474,
 6421,
 -1,
 621185247,
 6410,
 621356299,
 621200084,
 -1,
 -56054,
 621303977,
 6412,
 -1,
 621352308,
 6411,
 621552910,
 621322217,
 -1,
 -56051,
 621500585,
 6417,
 -1,
 621548916,
 6416,
 621749521,
 621512927,
 -1,
 -56048,
 621695748,
 6405,
 -1,
 621745524,
 6415,
 621946132,
 621703304,
 -1,
 -56045,
 621893801,
 6402,
 -1,
 621942132,
 6401,
 622142743,
 621899561,
 -1,
 -56042,
 622090409,
 6409,
 -1,
 622138740,
 6408,
 622339354,
 622088931,
 -1,
 -56039,
 622287017,
 6404,
 -1,
 622335348,
 6403,
 622535965,
 622278176,
 -1,
 -56036,
 622483625,
 6414,
 -1,
 622531956,
 6413,
 622732576,
 622472414,
 -1,
 -56033,
 622680233,
 6407,
 -1,
 622728564,
 6406,
 622929187,
 622667382,
 -1,
 -56030,
 622876841,
 6419,
 -1,
 622925172,
 6418,
 -56028,
 622910768,
 6424,
 -56027,
 623094191,
 6422,
 -56026,
 623149106,
 6420,
 -56025,
 623211437,
 6423,
 -1,
 623270057,
 6428,
 623453501,
 620869407,
 -1,
 623519028,
 623411584,
 -1,
 623584557,
 623479007,
 -1,
 -56020,
 623530756,
 6449,
 -1,
 623580532,
 6452,
 -56018,
 623559445,
 6451,
 -56017,
 623749551,
 6455,
 -56016,
 623812686,
 6453,
 -56015,
 623870002,
 6454,
 -56014,
 623932333,
 6456,
 -56013,
 623997087,
 6448,
 -1,
 624041879,
 6450,
 624239929,
 623469961,
 -1,
 -56010,
 624211868,
 6459,
 -56009,
 624265156,
 6457,
 -56008,
 624328074,
 6464,
 -1,
 624390622,
 6458,
 624623615,
 624217875,
 -1,
 -56005,
 624550954,
 6441,
 -56004,
 624614704,
 6443,
 -1,
 624667055,
 6442,
 624829769,
 623434889,
 -1,
 624895304,
 624757291,
 -1,
 624960834,
 624825716,
 6432,
 -55999,
 624938570,
 6438,
 -1,
 624976255,
 6436,
 625157444,
 624923023,
 6440,
 -1,
 625119631,
 6437,
 625288518,
 625098887,
 6439,
 -1,
 625229959,
 6435,
 -55993,
 625266250,
 6434,
 -1,
 625369471,
 6433,
 -1,
 624824096,
 6400,
 625616215,
 624769432,
 -1,
 625681741,
 625590996,
 -1,
 -55988,
 625664399,
 6472,
 -1,
 625696854,
 6473,
 625878352,
 625653535,
 -1,
 -55985,
 625831662,
 6476,
 -1,
 625888386,
 6477,
 626074963,
 625823318,
 -1,
 -55982,
 626039792,
 6474,
 -1,
 626093687,
 6475,
 -55980,
 626059157,
 6470,
 -55979,
 626234815,
 6471,
 -55978,
 626298044,
 6479,
 -1,
 626345271,
 6478,
 -55976,
 625584318,
 6469,
 -1,
 626478458,
 6468,
 -1,
 620785068,
 13007,
 626730394,
 620740987,
 -1,
 626795927,
 626686426,
 -1,
 626861418,
 626770644,
 -1,
 626926949,
 626824643,
 -1,
 626992484,
 626886846,
 -1,
 -55968,
 626968506,
 42232,
 -55967,
 627018043,
 42236,
 -55966,
 627077110,
 42237,
 -55965,
 627127831,
 42234,
 -1,
 627190422,
 42235,
 -1,
 626952510,
 42233,
 627451240,
 626898719,
 -1,
 -55961,
 627398825,
 42206,
 -1,
 627447156,
 42205,
 -55959,
 627398825,
 42197,
 -1,
 627578228,
 42196,
 627778925,
 626839114,
 42228,
 -55956,
 627726475,
 42230,
 -1,
 627785863,
 42229,
 627975536,
 627762974,
 -1,
 -55953,
 627923113,
 42211,
 -1,
 627971444,
 42212,
 628172147,
 627947295,
 -1,
 -55950,
 628119721,
 42219,
 -1,
 628168052,
 42210,
 628368758,
 628137961,
 -1,
 -55947,
 628316329,
 42194,
 -1,
 628364660,
 42193,
 628565368,
 628330895,
 42227,
 -1,
 628506759,
 42231,
 628696443,
 628525279,
 -1,
 -55942,
 628642564,
 42213,
 -1,
 628692340,
 42208,
 628893054,
 628650120,
 -1,
 -55939,
 628840617,
 42200,
 -1,
 628888948,
 42199,
 629089665,
 628840587,
 -1,
 -55936,
 629037225,
 42216,
 -1,
 629085556,
 42214,
 629286276,
 629035747,
 -1,
 -55933,
 629233833,
 42221,
 -1,
 629282164,
 42198,
 629482886,
 629227655,
 42224,
 -1,
 629460554,
 42225,
 629613961,
 629421600,
 -1,
 -55928,
 629598000,
 42204,
 -1,
 629609844,
 42195,
 629810572,
 629550302,
 -1,
 -55925,
 629758121,
 42203,
 -1,
 629806452,
 42202,
 630007182,
 629740916,
 42222,
 -1,
 629948551,
 42223,
 -55921,
 629990442,
 42220,
 -55920,
 630121252,
 42215,
 -55919,
 630185264,
 42218,
 -55918,
 630226994,
 42207,
 -55917,
 630289325,
 42209,
 -55916,
 630353707,
 42201,
 -55915,
 630415743,
 42226,
 -55914,
 630476479,
 42217,
 -1,
 630531752,
 42192,
 630783999,
 626763515,
 -1,
 -55911,
 630674114,
 42239,
 -1,
 630731279,
 42238,
 630924705,
 626676958,
 -1,
 630990240,
 630849536,
 -1,
 -55907,
 630970972,
 10072,
 -55906,
 631028332,
 9617,
 -55905,
 631091210,
 10099,
 -1,
 631142344,
 10098,
 -1,
 630951140,
 9735,
 -55902,
 630906064,
 8374,
 -55901,
 631351738,
 8356,
 -1,
 631384930,
 9806,
 631580442,
 603078791,
 -1,
 631645838,
 631525982,
 -1,
 631711264,
 631570432,
 -1,
 631776699,
 631682847,
 -1,
 631842227,
 631744568,
 91,
 631963647,
 631767040,
 -1,
 631973296,
 631889778,
 -1,
 632038830,
 631949257,
 -1,
 -55891,
 632015368,
 10637,
 -1,
 632040160,
 10639,
 -55889,
 632017495,
 10635,
 -1,
 632203492,
 8261,
 -55887,
 631952480,
 9121,
 -55886,
 632323681,
 9123,
 -1,
 632376879,
 9122,
 632563126,
 631791999,
 -1,
 -55883,
 632523812,
 8216,
 -1,
 632567854,
 11814,
 632759737,
 632504455,
 -1,
 -55880,
 632740231,
 9609,
 -1,
 632784157,
 8907,
 -55878,
 632737740,
 11778,
 -1,
 632885541,
 10181,
 633087438,
 631744852,
 -1,
 633152973,
 633038056,
 -1,
 633218500,
 633086562,
 8596,
 633339903,
 633143296,
 -1,
 633349571,
 633266034,
 -1,
 -55871,
 633330455,
 8697,
 -55870,
 633389312,
 8622,
 -1,
 633421237,
 8700,
 -1,
 633325465,
 10568,
 633677256,
 633158822,
 8660,
 633798655,
 633605155,
 -1,
 -55865,
 633723671,
 10500,
 -1,
 633782528,
 8654,
 633939403,
 633658632,
 -1,
 -55862,
 633888225,
 11012,
 -1,
 633939444,
 8621,
 -55860,
 633902936,
 8703,
 -1,
 634071555,
 11020,
 -1,
 633084303,
 11788,
 634332632,
 633068808,
 -1,
 634398167,
 634281435,
 -1,
 634463699,
 634334430,
 -1,
 -55854,
 634443251,
 10627,
 -1,
 634493298,
 12302,
 -55852,
 634440301,
 12312,
 -55851,
 634634078,
 12314,
 -55850,
 634691878,
 10629,
 -1,
 634747150,
 12310,
 -1,
 634348740,
 10712,
 634988001,
 634268894,
 -1,
 635053534,
 634967539,
 123,
 635174911,
 634978304,
 -1,
 -55844,
 635098242,
 9127,
 -55843,
 635143415,
 9128,
 -1,
 635207314,
 9129,
 -55841,
 635017586,
 12300,
 -55840,
 635338179,
 9948,
 -1,
 635389314,
 8968,
 635577837,
 634918260,
 -1,
 635643368,
 635537631,
 -1,
 635708901,
 635590110,
 12296,
 -1,
 635636983,
 10641,
 635895807,
 635647569,
 -1,
 -55833,
 635814745,
 10203,
 -1,
 635846052,
 10202,
 636092415,
 635611476,
 -1,
 636102124,
 636007713,
 -1,
 -55829,
 636075490,
 11056,
 -1,
 636104836,
 11058,
 -1,
 636038422,
 10643,
 636364278,
 635552468,
 -1,
 636429809,
 636332372,
 -1,
 -55824,
 636379771,
 10703,
 -1,
 636428099,
 11785,
 636626420,
 636379227,
 -1,
 -55821,
 636594304,
 9610,
 -1,
 636634477,
 9613,
 -55819,
 636590555,
 12308,
 -1,
 636753771,
 8867,
 636954113,
 636298870,
 -1,
 637019646,
 636887313,
 -1,
 637085179,
 636998621,
 -1,
 -55814,
 637064021,
 10574,
 -1,
 637091448,
 10570,
 637337599,
 637026050,
 -1,
 -55811,
 637260629,
 10571,
 -1,
 637288056,
 10576,
 637534207,
 636974101,
 -1,
 -55808,
 637454957,
 10647,
 -1,
 637499662,
 12304,
 637675016,
 636893892,
 -1,
 637740551,
 637652777,
 -1,
 -55804,
 637722438,
 10714,
 -55803,
 637774115,
 8220,
 -55802,
 637837606,
 11816,
 -1,
 637869755,
 12298,
 -1,
 637717554,
 11780,
 638133773,
 637640998,
 40,
 638255103,
 638058496,
 -1,
 -55797,
 638178434,
 9115,
 -55796,
 638221970,
 9117,
 -1,
 638275119,
 9116,
 638461458,
 638095759,
 -1,
 638526993,
 638421766,
 -1,
 -55792,
 638494825,
 9614,
 -1,
 638534987,
 9615,
 -1,
 638506803,
 10197,
 638789143,
 638406230,
 -1,
 638854678,
 638738815,
 -1,
 -55787,
 638834947,
 9611,
 -1,
 638892601,
 10620,
 -1,
 638811539,
 8970,
 639116826,
 638769745,
 -1,
 -55783,
 639082446,
 9144,
 -1,
 639115398,
 11808,
 639313437,
 639064470,
 -1,
 -55780,
 639275637,
 9612,
 -1,
 639309679,
 9686,
 -55778,
 639274464,
 8905,
 -55777,
 639469518,
 10204,
 -1,
 639532593,
 11804,
 639706752,
 631692634,
 -1,
 639772232,
 639640162,
 8592,
 639837767,
 639696896,
 -1,
 639903284,
 639819634,
 -1,
 639968812,
 639877844,
 -1,
 640034345,
 639899966,
 8610,
 640155647,
 639962147,
 -1,
 -55768,
 640080663,
 11065,
 -1,
 640105909,
 11066,
 640352255,
 639986621,
 -1,
 -55765,
 640275753,
 11025,
 -1,
 640302896,
 11024,
 640493103,
 639908548,
 -1,
 -55762,
 640470914,
 8698,
 -1,
 640535592,
 11064,
 -55760,
 640473879,
 8695,
 -55759,
 640663808,
 8602,
 -55758,
 640722001,
 10566,
 -55757,
 640777614,
 8619,
 -1,
 640835232,
 8617,
 641017405,
 639877844,
 -1,
 641082937,
 640979354,
 -1,
 641148472,
 641015900,
 8676,
 -1,
 641075163,
 8633,
 -1,
 641102875,
 10525,
 641400831,
 641032410,
 -1,
 -55749,
 641327876,
 11070,
 -55748,
 641384831,
 10618,
 -1,
 641431887,
 10615,
 641607236,
 640947835,
 -1,
 641672769,
 641576246,
 -1,
 -55744,
 641648665,
 11083,
 -1,
 641670177,
 11074,
 -55742,
 641648665,
 10611,
 -55741,
 641842066,
 10563,
 -1,
 641866785,
 11082,
 642065990,
 641552975,
 8612,
 -1,
 641993635,
 10527,
 -1,
 642031108,
 8646,
 -1,
 639766898,
 10521,
 642328156,
 639720122,
 -1,
 642393691,
 642310022,
 -1,
 642459220,
 642372356,
 -1,
 642524755,
 642383872,
 -1,
 642590289,
 642455163,
 -1,
 642655824,
 642544472,
 -1,
 -55729,
 642618908,
 10602,
 -1,
 642663508,
 10594,
 -1,
 642625803,
 10598,
 -55726,
 642566457,
 10578,
 -1,
 642863695,
 10586,
 -1,
 642506068,
 8636,
 643170303,
 642399791,
 -1,
 643180122,
 643039232,
 -1,
 -55721,
 643156281,
 10582,
 -55720,
 643191375,
 10590,
 -55719,
 643246176,
 10603,
 -1,
 643307230,
 10599,
 -1,
 643161428,
 8637,
 -1,
 642358810,
 8651,
 643638893,
 642302676,
 -1,
 643704426,
 643621263,
 -1,
 643769961,
 643633068,
 -1,
 643835496,
 643703400,
 -1,
 643901031,
 643817330,
 -1,
 643966565,
 643875715,
 11067,
 644087807,
 643894307,
 -1,
 -55708,
 644012823,
 11068,
 -1,
 644038069,
 11069,
 -55706,
 643947287,
 11060,
 -1,
 644169141,
 11061,
 -1,
 643846735,
 11062,
 -1,
 643812211,
 11063,
 -1,
 643695700,
 8606,
 644612095,
 643674658,
 -1,
 -55700,
 644495118,
 10510,
 -1,
 644555362,
 8666,
 644753016,
 643577376,
 -1,
 644818551,
 644717364,
 -1,
 644884086,
 644751970,
 8656,
 644949621,
 644808704,
 -1,
 645015156,
 644931442,
 -1,
 -55693,
 644995863,
 10498,
 -1,
 645054720,
 8653,
 -1,
 644960847,
 10502,
 -1,
 644878706,
 10523,
 -1,
 644822798,
 10508,
 -1,
 644752261,
 8672,
 645473915,
 644734216,
 -1,
 -55686,
 645422561,
 8678,
 -1,
 645473780,
 8604,
 -55684,
 645447568,
 8668,
 -55683,
 645638115,
 11077,
 -55682,
 645701768,
 8647,
 -55681,
 645764952,
 8701,
 -1,
 645802499,
 11013,
 646053887,
 639635155,
 -1,
 646063749,
 645974394,
 -1,
 -55677,
 646029028,
 8237,
 -55676,
 646087258,
 8206,
 -1,
 646137434,
 8234,
 646325897,
 646030573,
 -1,
 -55673,
 646265976,
 171,
 -55672,
 646329825,
 10748,
 -1,
 646389435,
 9001,
 646588044,
 646297375,
 -1,
 -55669,
 646538064,
 10553,
 -1,
 646600920,
 10154,
 646840319,
 646532808,
 4054,
 -1,
 646712621,
 4056,
 646915827,
 631611815,
 -1,
 646981317,
 646871514,
 -1,
 647046809,
 646955732,
 -1,
 647112340,
 647021268,
 -1,
 -55661,
 647059625,
 7246,
 -1,
 647107956,
 7245,
 647308951,
 647083807,
 -1,
 -55658,
 647256233,
 7192,
 -1,
 647304564,
 7191,
 -55656,
 647256233,
 7179,
 -1,
 647435636,
 7178,
 647636637,
 647012329,
 -1,
 -55653,
 647590829,
 7183,
 -55652,
 647649449,
 7184,
 -1,
 647697780,
 7182,
 647898785,
 647596255,
 -1,
 -55649,
 647881770,
 7177,
 -55648,
 647910148,
 7173,
 -1,
 647959924,
 7181,
 648160933,
 647852168,
 -1,
 -55645,
 648115117,
 7169,
 -55644,
 648173737,
 7170,
 -1,
 648222068,
 7168,
 648423081,
 648099360,
 -1,
 -55641,
 648406832,
 7193,
 -55640,
 648427147,
 7247,
 -1,
 648484212,
 7180,
 648685228,
 648394527,
 -1,
 -55637,
 648632489,
 7201,
 -1,
 648680820,
 7200,
 648881839,
 648642533,
 -1,
 -55634,
 648836013,
 7190,
 -1,
 648877428,
 7189,
 649078450,
 648829067,
 -1,
 -55631,
 649032621,
 7198,
 -1,
 649074036,
 7197,
 649275061,
 649024227,
 -1,
 -55628,
 649229229,
 7172,
 -1,
 649270644,
 7171,
 649471672,
 649219670,
 -1,
 -55625,
 649425837,
 7186,
 -1,
 649467252,
 7185,
 649668283,
 649407710,
 -1,
 -55622,
 649615529,
 7175,
 -1,
 649663860,
 7174,
 649864894,
 649602678,
 -1,
 -55619,
 649819053,
 7188,
 -1,
 649860468,
 7187,
 -55617,
 649847850,
 7194,
 -55616,
 650042672,
 7202,
 -55615,
 650106812,
 7199,
 -55614,
 650160559,
 7195,
 -55613,
 650212269,
 7196,
 -55612,
 650276651,
 7176,
 -1,
 650319220,
 7203,
 650520275,
 646920600,
 -1,
 650585801,
 650494676,
 -1,
 -55608,
 650568079,
 7234,
 -1,
 650600534,
 7235,
 650782412,
 650557215,
 -1,
 -55605,
 650735342,
 7238,
 -1,
 650792066,
 7239,
 650979023,
 650726998,
 -1,
 -55602,
 650943472,
 7236,
 -1,
 650997367,
 7237,
 -55600,
 650962837,
 7232,
 -55599,
 651138495,
 7233,
 -55598,
 651201724,
 7241,
 -1,
 651248951,
 7240,
 651437789,
 650457746,
 -1,
 651503318,
 651397343,
 7216,
 -1,
 651486676,
 7220,
 651634392,
 651456648,
 7213,
 -1,
 651566688,
 7221,
 -55591,
 651608788,
 7219,
 -55590,
 651733332,
 7218,
 -55589,
 651796457,
 7217,
 -55588,
 651853797,
 7214,
 -1,
 651916120,
 7215,
 652093157,
 651418806,
 -1,
 652158688,
 652070474,
 7210,
 -1,
 652136010,
 7211,
 652289762,
 652120463,
 7208,
 -1,
 652251535,
 7209,
 -55581,
 652239231,
 7207,
 -55580,
 652361863,
 7212,
 -1,
 652416503,
 7206,
 652617452,
 652060411,
 -1,
 652682986,
 652591828,
 -1,
 652748521,
 652655441,
 7231,
 -1,
 652673669,
 7230,
 -1,
 652678632,
 7227,
 -55573,
 652644669,
 7228,
 -1,
 652881681,
 7229,
 653131775,
 652588831,
 -1,
 653141744,
 653053715,
 -1,
 -55569,
 653124650,
 7204,
 -1,
 653175215,
 7205,
 653393919,
 653092233,
 -1,
 -55566,
 653306523,
 7222,
 -1,
 653365301,
 7223,
 653535001,
 646889386,
 -1,
 653600513,
 653496719,
 -1,
 653666048,
 653568342,
 -1,
 653731579,
 653639020,
 10877,
 653852671,
 653659393,
 -1,
 653862650,
 653727349,
 10881,
 -1,
 653789667,
 10883,
 -1,
 653814159,
 10879,
 654059262,
 653674742,
 -1,
 -55555,
 654012006,
 8818,
 -1,
 654055973,
 8804,
 -55553,
 654006007,
 8822,
 -1,
 654188586,
 10885,
 -1,
 653646237,
 8806,
 654452494,
 653530484,
 -1,
 654518027,
 654388046,
 -1,
 654583560,
 654489375,
 -1,
 654649095,
 654534363,
 -1,
 -55546,
 654612484,
 10893,
 -1,
 654644884,
 10895,
 -1,
 654603517,
 10899,
 -55543,
 654538825,
 10614,
 -55542,
 654857988,
 10897,
 -1,
 654917068,
 10891,
 655163391,
 654477920,
 -1,
 -55539,
 655080678,
 10887,
 -1,
 655134283,
 10889,
 655304466,
 654434162,
 -1,
 -55536,
 655272140,
 10875,
 -55535,
 655309608,
 8918,
 -1,
 655372369,
 10873,
 655566612,
 655241622,
 10918,
 -1,
 655491105,
 10920,
 655697687,
 655502461,
 -1,
 -55530,
 655650406,
 8934,
 -1,
 655694373,
 8808,
 -55528,
 655670315,
 60,
 -1,
 655837469,
 8922,
 -1,
 653496719,
 9804,
 656090966,
 631563246,
 -1,
 656156473,
 656027684,
 -1,
 656221983,
 656130772,
 66199,
 -55522,
 656196308,
 66200,
 -1,
 656234635,
 66185,
 656418593,
 656181471,
 66191,
 -1,
 656378079,
 66193,
 656549667,
 656375781,
 66190,
 -1,
 656506853,
 66192,
 656680741,
 656502920,
 66187,
 -1,
 656633992,
 66196,
 656811815,
 656621703,
 66177,
 -1,
 656771295,
 66202,
 656942889,
 656746102,
 66178,
 -1,
 656889995,
 66179,
 657073963,
 656872820,
 66176,
 -1,
 657033439,
 66201,
 -55508,
 657057566,
 66184,
 -55507,
 657187588,
 66204,
 -55506,
 657251592,
 66183,
 -55505,
 657313354,
 66194,
 -55504,
 657372959,
 66198,
 -55503,
 657434964,
 66197,
 -55502,
 657499972,
 66188,
 -55501,
 657563625,
 66195,
 -55500,
 657617752,
 66189,
 -55499,
 657682217,
 66186,
 -55498,
 657744255,
 66182,
 -55497,
 657807499,
 66203,
 -55496,
 657871587,
 66180,
 -1,
 657929760,
 66181,
 658178047,
 656095541,
 -1,
 658188117,
 658078170,
 -1,
 658253629,
 658162388,
 67887,
 -1,
 658227924,
 67892,
 658384703,
 658224927,
 67891,
 -1,
 658355999,
 67886,
 658515777,
 658344159,
 67883,
 -1,
 658475231,
 67896,
 658646851,
 658469720,
 67881,
 -1,
 658629614,
 67895,
 658777925,
 658587783,
 67876,
 -1,
 658737375,
 67894,
 658908999,
 658707828,
 67872,
 -1,
 658868447,
 67893,
 -55480,
 658891758,
 67879,
 -55479,
 659019694,
 67877,
 -55478,
 659082826,
 67888,
 -55477,
 659138900,
 67885,
 -55476,
 659203908,
 67890,
 -55475,
 659263887,
 67884,
 -55474,
 659324901,
 67882,
 -55473,
 659386504,
 67880,
 -55472,
 659448191,
 67878,
 -55471,
 659509987,
 67874,
 -55470,
 659574358,
 67889,
 -55469,
 659633696,
 67875,
 -55468,
 659696862,
 67897,
 -1,
 659760758,
 67873,
 -1,
 658164516,
 67903,
 660023207,
 656052623,
 -1,
 660088695,
 660004104,
 -1,
 660154227,
 660031842,
 -1,
 660219746,
 660123239,
 -1,
 660285277,
 660191007,
 -1,
 -55460,
 660232437,
 10065,
 -1,
 660293220,
 10558,
 -55458,
 660261626,
 9727,
 -55457,
 660449229,
 9694,
 -55456,
 660513322,
 9998,
 -55455,
 660553707,
 10063,
 -1,
 660616068,
 10195,
 660809574,
 660174474,
 -1,
 -55452,
 660785914,
 9722,
 -55451,
 660846879,
 10559,
 -1,
 660907981,
 9695,
 661071722,
 660756880,
 -1,
 -55448,
 661023416,
 9691,
 -55447,
 661073986,
 9697,
 -1,
 661138064,
 9604,
 661333869,
 661047103,
 -1,
 -55444,
 661301376,
 9606,
 -1,
 661341549,
 9603,
 661530480,
 661296579,
 -1,
 -55441,
 661497961,
 9602,
 -1,
 661538123,
 9601,
 -55439,
 661502439,
 9607,
 -55438,
 661672121,
 9605,
 -1,
 661727854,
 9987,
 661979135,
 660078592,
 -1,
 -55435,
 661879533,
 95,
 -55434,
 661929284,
 12319,
 -1,
 661988356,
 8270,
 662185871,
 660048826,
 -1,
 662251396,
 662140549,
 -1,
 662316927,
 662232410,
 -1,
 662382460,
 662256806,
 10232,
 -1,
 662307791,
 10237,
 662513534,
 662315618,
 10229,
 -1,
 662438863,
 10235,
 -1,
 662486928,
 11059,
 662765567,
 662241280,
 -1,
 662775683,
 662679143,
 -1,
 -55422,
 662715558,
 10234,
 -1,
 662774370,
 10231,
 -1,
 662750041,
 10206,
 663037836,
 662220385,
 -1,
 663103371,
 663018842,
 -1,
 663168904,
 663043238,
 10233,
 -1,
 663094223,
 10238,
 663299978,
 663102050,
 10230,
 -1,
 663225295,
 10236,
 -1,
 663273360,
 10239,
 -1,
 663030428,
 10205,
 663617535,
 662976032,
 -1,
 -55410,
 663514831,
 10188,
 -1,
 663561048,
 10982,
 663758757,
 662132097,
 -1,
 663824283,
 663721974,
 8744,
 663945215,
 663748608,
 -1,
 663955354,
 663871346,
 -1,
 664020888,
 663894724,
 -1,
 664086423,
 663998249,
 -1,
 -55402,
 664064599,
 10851,
 -1,
 664116906,
 10850,
 -1,
 664060633,
 10834,
 -55399,
 663979268,
 10843,
 -1,
 664297212,
 10845,
 -1,
 663920315,
 10841,
 664600575,
 663756135,
 8743,
 664666111,
 664472611,
 -1,
 664676258,
 664550084,
 -1,
 664741793,
 664653609,
 -1,
 -55392,
 664719959,
 10848,
 -1,
 664772266,
 10846,
 -1,
 664715993,
 10833,
 -55389,
 664654423,
 10847,
 -55388,
 664962308,
 10842,
 -1,
 665018108,
 10844,
 665255935,
 663742347,
 9674,
 -1,
 665125724,
 10208,
 -1,
 659948017,
 8468,
 665399015,
 509427847,
 -1,
 665463887,
 665344104,
 -1,
 665528362,
 665392500,
 -1,
 665593859,
 665457039,
 -1,
 665659323,
 665523132,
 -1,
 665724847,
 665588745,
 77877,
 -1,
 665654644,
 77878,
 665855921,
 665654092,
 77874,
 -1,
 665785716,
 77875,
 665986995,
 665784999,
 77872,
 -1,
 665916788,
 77873,
 666118069,
 665915791,
 77869,
 -1,
 666047860,
 77870,
 -55370,
 666047809,
 77882,
 -55369,
 666178829,
 77881,
 -55368,
 666244294,
 77880,
 -55367,
 666309761,
 77879,
 -55366,
 666375100,
 77876,
 -1,
 666440207,
 77871,
 666642376,
 665588239,
 -1,
 666707902,
 666571974,
 77844,
 -1,
 666637684,
 77845,
 666838976,
 666637244,
 77840,
 -1,
 666768756,
 77841,
 -55359,
 666768705,
 77847,
 -55358,
 666899725,
 77846,
 -55357,
 666965121,
 77843,
 -55356,
 667030537,
 77842,
 -55355,
 667095884,
 77839,
 -55354,
 667161255,
 77838,
 -55353,
 667226639,
 77837,
 -1,
 667292047,
 77836,
 667494357,
 666571151,
 -1,
 667559884,
 667423873,
 77830,
 -55349,
 667494006,
 77832,
 -1,
 667555188,
 77831,
 667756494,
 667489289,
 77828,
 -1,
 667686260,
 77829,
 -55345,
 667686209,
 77835,
 -55344,
 667817229,
 77834,
 -55343,
 667882694,
 77833,
 -55342,
 667947964,
 77827,
 -55341,
 668013388,
 77826,
 -55340,
 668078759,
 77825,
 -1,
 668144143,
 77824,
 668346337,
 667423564,
 -1,
 668411864,
 668275367,
 77860,
 -1,
 668341620,
 77861,
 -55335,
 668341569,
 77868,
 -55334,
 668472589,
 77867,
 -55333,
 668538054,
 77866,
 -55332,
 668603521,
 77865,
 -55331,
 668668937,
 77864,
 -55330,
 668734396,
 77863,
 -55329,
 668799820,
 77862,
 -55328,
 668865039,
 77859,
 -1,
 668930447,
 77858,
 669132780,
 668275841,
 -1,
 -55325,
 669062465,
 77902,
 -55324,
 669127949,
 77901,
 -55323,
 669193414,
 77900,
 -55322,
 669258881,
 77899,
 -55321,
 669324297,
 77898,
 -55320,
 669389756,
 77897,
 -55319,
 669455180,
 77896,
 -55318,
 669520551,
 77895,
 -55317,
 669585935,
 77894,
 -1,
 669651343,
 77893,
 669853687,
 669062153,
 -1,
 -55314,
 669783361,
 77892,
 -55313,
 669848845,
 77891,
 -55312,
 669914310,
 77890,
 -55311,
 669979777,
 77889,
 -55310,
 670045193,
 77888,
 -55309,
 670110652,
 77887,
 -55308,
 670176076,
 77886,
 -55307,
 670241447,
 77885,
 -55306,
 670306831,
 77884,
 -1,
 670372239,
 77883,
 670574594,
 669782695,
 -1,
 -55303,
 670504257,
 77857,
 -55302,
 670569741,
 77856,
 -55301,
 670635206,
 77855,
 -55300,
 670700673,
 77854,
 -55299,
 670766089,
 77853,
 -55298,
 670831548,
 77852,
 -55297,
 670896972,
 77851,
 -55296,
 670962343,
 77850,
 -55295,
 671027727,
 77849,
 -1,
 671093135,
 77848,
 -1,
 670504195,
 77903,
 671416319,
 665523694,
 -1,
 671426576,
 671289743,
 -1,
 671492104,
 671356102,
 78867,
 -55289,
 671426166,
 78869,
 -1,
 671487348,
 78868,
 -55287,
 671421761,
 78871,
 -55286,
 671618317,
 78870,
 -55285,
 671683713,
 78866,
 -55284,
 671749129,
 78865,
 -55283,
 671814588,
 78864,
 -55282,
 671880012,
 78863,
 -55281,
 671945383,
 78862,
 -1,
 672010767,
 78861,
 672213019,
 671355559,
 -1,
 -55278,
 672142657,
 78891,
 -55277,
 672208141,
 78890,
 -55276,
 672273606,
 78889,
 -55275,
 672339073,
 78888,
 -55274,
 672404489,
 78887,
 -55273,
 672469948,
 78886,
 -55272,
 672535372,
 78885,
 -55271,
 672600743,
 78884,
 -55270,
 672666127,
 78883,
 -1,
 672731535,
 78882,
 672933926,
 672141839,
 -1,
 -55267,
 672863553,
 78881,
 -55266,
 672929037,
 78880,
 -55265,
 672994502,
 78879,
 -55264,
 673059969,
 78878,
 -55263,
 673125385,
 78877,
 -55262,
 673190844,
 78876,
 -55261,
 673256268,
 78875,
 -55260,
 673321639,
 78874,
 -55259,
 673387023,
 78873,
 -1,
 673452431,
 78872,
 673710079,
 672863052,
 -1,
 -55256,
 673583783,
 78894,
 -55255,
 673649167,
 78893,
 -1,
 673714575,
 78892,
 673917081,
 665487583,
 -1,
 673982562,
 673845647,
 -1,
 674048059,
 673911628,
 -1,
 674113583,
 673977542,
 78361,
 -1,
 674043252,
 78362,
 674244657,
 674042889,
 78358,
 -1,
 674174324,
 78359,
 674375731,
 674173884,
 78356,
 -1,
 674305396,
 78357,
 674506805,
 674304844,
 78354,
 -1,
 674436468,
 78355,
 -55242,
 674436417,
 78364,
 -55241,
 674567437,
 78363,
 -55240,
 674632833,
 78360,
 -55239,
 674697895,
 78353,
 -55238,
 674763279,
 78352,
 -1,
 674828687,
 78351,
 675031112,
 673976847,
 -1,
 675096639,
 674960653,
 78336,
 -55234,
 675030646,
 78338,
 -1,
 675091828,
 78337,
 -55232,
 675026241,
 78339,
 -55231,
 675222726,
 78335,
 -55230,
 675288193,
 78334,
 -55229,
 675353609,
 78333,
 -55228,
 675419068,
 78332,
 -55227,
 675484492,
 78331,
 -55226,
 675549863,
 78330,
 -55225,
 675615247,
 78329,
 -1,
 675680655,
 78328,
 675883092,
 674960039,
 -1,
 675948619,
 675812361,
 78345,
 -1,
 675878260,
 78346,
 -55220,
 675878209,
 78350,
 -55219,
 676009229,
 78349,
 -55218,
 676074694,
 78348,
 -55217,
 676140161,
 78347,
 -55216,
 676205500,
 78344,
 -55215,
 676270924,
 78343,
 -55214,
 676336295,
 78342,
 -55213,
 676401679,
 78341,
 -1,
 676467087,
 78340,
 676669534,
 675811727,
 -1,
 -55210,
 676599105,
 78327,
 -55209,
 676664589,
 78326,
 -55208,
 676730054,
 78325,
 -55207,
 676795521,
 78324,
 -55206,
 676860937,
 78323,
 -55205,
 676926396,
 78322,
 -55204,
 676991820,
 78321,
 -55203,
 677057191,
 78320,
 -1,
 677122575,
 78319,
 677380095,
 676598716,
 -1,
 -55200,
 677253799,
 78367,
 -55199,
 677319183,
 78366,
 -1,
 677384591,
 78365,
 677587072,
 673959594,
 -1,
 677652593,
 677515791,
 -1,
 677718118,
 677582093,
 78409,
 -1,
 677647732,
 78410,
 677849192,
 677646863,
 78401,
 -1,
 677778804,
 78402,
 677980266,
 677777807,
 78399,
 -1,
 677909876,
 78400,
 -55189,
 677909825,
 78411,
 -55188,
 678040774,
 78408,
 -55187,
 678106241,
 78407,
 -55186,
 678171657,
 78406,
 -55185,
 678237116,
 78405,
 -55184,
 678302540,
 78404,
 -1,
 678367911,
 78403,
 678570107,
 677581199,
 -1,
 -55181,
 678499649,
 78398,
 -55180,
 678565133,
 78397,
 -55179,
 678630598,
 78396,
 -55178,
 678696065,
 78395,
 -55177,
 678761481,
 78394,
 -55176,
 678826940,
 78393,
 -55175,
 678892364,
 78392,
 -55174,
 678957735,
 78391,
 -1,
 679023119,
 78390,
 679280639,
 678498983,
 -1,
 679291006,
 679154343,
 78414,
 -1,
 679220596,
 78415,
 -55169,
 679219727,
 78413,
 -1,
 679350671,
 78412,
 679608319,
 677540771,
 -1,
 679618701,
 679481871,
 -1,
 679684228,
 679548102,
 78385,
 -1,
 679613812,
 78386,
 -55163,
 679613761,
 78388,
 -55162,
 679744781,
 78387,
 -55161,
 679810177,
 78384,
 -55160,
 679875593,
 78383,
 -55159,
 679941052,
 78382,
 -55158,
 680006476,
 78381,
 -55157,
 680071847,
 78380,
 -55156,
 680137231,
 78379,
 -1,
 680202639,
 78378,
 680405144,
 679547279,
 -1,
 680470672,
 680334345,
 78372,
 -1,
 680400244,
 78373,
 -55151,
 680400193,
 78377,
 -55150,
 680531213,
 78376,
 -55149,
 680596678,
 78375,
 -55148,
 680662145,
 78374,
 -55147,
 680727484,
 78371,
 -55146,
 680792908,
 78370,
 -55145,
 680858279,
 78369,
 -1,
 680923663,
 78368,
 -1,
 680334120,
 78389,
 681191677,
 673855104,
 -1,
 681257136,
 681120777,
 -1,
 681322661,
 681185679,
 77997,
 -55139,
 681271679,
 78006,
 -55138,
 681334923,
 78005,
 -55137,
 681399011,
 78004,
 -55136,
 681463382,
 78003,
 -55135,
 681525383,
 78002,
 -55134,
 681588256,
 78001,
 -55133,
 681651422,
 78000,
 -55132,
 681715318,
 77999,
 -1,
 681776500,
 77998,
 681978023,
 681251772,
 78011,
 -1,
 681907572,
 78012,
 682109097,
 681906855,
 78008,
 -1,
 682038644,
 78009,
 -55126,
 682038593,
 78017,
 -55125,
 682169613,
 78016,
 -55124,
 682235078,
 78015,
 -55123,
 682300545,
 78014,
 -55122,
 682365961,
 78013,
 -55121,
 682431308,
 78010,
 -1,
 682496527,
 78007,
 682698945,
 681186433,
 -1,
 682764474,
 682628294,
 78025,
 -55117,
 682711179,
 78033,
 -55116,
 682775267,
 78032,
 -55115,
 682839638,
 78031,
 -55114,
 682901639,
 78030,
 -55113,
 682964512,
 78029,
 -55112,
 683027678,
 78028,
 -55111,
 683091574,
 78027,
 -1,
 683152756,
 78026,
 -55109,
 682693761,
 78024,
 -55108,
 683283465,
 78023,
 -55107,
 683348924,
 78022,
 -55106,
 683414348,
 78021,
 -55105,
 683479719,
 78020,
 -55104,
 683545103,
 78019,
 -1,
 683610511,
 78018,
 683813070,
 682628028,
 -1,
 683878596,
 683742477,
 77994,
 -1,
 683808116,
 77995,
 684009670,
 683807873,
 77991,
 -1,
 683939188,
 77992,
 -55097,
 683939137,
 77996,
 -55096,
 684070086,
 77993,
 -55095,
 684135433,
 77990,
 -55094,
 684200892,
 77989,
 -55093,
 684266316,
 77988,
 -55092,
 684331687,
 77987,
 -55091,
 684397071,
 77986,
 -1,
 684462479,
 77985,
 684665051,
 683742028,
 -1,
 684730577,
 684594108,
 77978,
 -1,
 684660084,
 77979,
 684861651,
 684659215,
 77974,
 -1,
 684791156,
 77975,
 -55084,
 684791105,
 77984,
 -55083,
 684922125,
 77983,
 -55082,
 684987590,
 77982,
 -55081,
 685053057,
 77981,
 -55080,
 685118473,
 77980,
 -55079,
 685183820,
 77977,
 -55078,
 685249191,
 77976,
 -1,
 685314447,
 77973,
 685517031,
 684593831,
 -1,
 685582558,
 685446342,
 77969,
 -1,
 685512052,
 77970,
 -55073,
 685512001,
 77972,
 -55072,
 685643021,
 77971,
 -55071,
 685708417,
 77968,
 -55070,
 685773833,
 77967,
 -55069,
 685839292,
 77966,
 -55068,
 685904716,
 77965,
 -55067,
 685970087,
 77964,
 -55066,
 686035471,
 77963,
 -1,
 686100879,
 77962,
 686303474,
 685445647,
 -1,
 -55063,
 686232897,
 77961,
 -55062,
 686298381,
 77960,
 -55061,
 686363846,
 77959,
 -55060,
 686429313,
 77958,
 -55059,
 686494729,
 77957,
 -55058,
 686560188,
 77956,
 -55057,
 686625612,
 77955,
 -55056,
 686690983,
 77954,
 -55055,
 686756367,
 77953,
 -1,
 686821775,
 77952,
 687079423,
 686231951,
 -1,
 687089909,
 686953741,
 77949,
 -1,
 687019380,
 77950,
 -55050,
 687019329,
 77951,
 -55049,
 687150278,
 77948,
 -55048,
 687215745,
 77947,
 -55047,
 687281161,
 77946,
 -55046,
 687346620,
 77945,
 -55045,
 687412044,
 77944,
 -55044,
 687477415,
 77943,
 -1,
 687542799,
 77942,
 687745359,
 681170873,
 -1,
 687810840,
 687674023,
 -1,
 687876364,
 687739279,
 78726,
 -55039,
 687829848,
 78738,
 -55038,
 687894664,
 78737,
 -55037,
 687959849,
 78736,
 -55036,
 688021887,
 78735,
 -55035,
 688085131,
 78734,
 -55034,
 688149219,
 78733,
 -55033,
 688213590,
 78732,
 -55032,
 688275591,
 78731,
 -55031,
 688338464,
 78730,
 -55030,
 688401630,
 78729,
 -55029,
 688465526,
 78728,
 -1,
 688526708,
 78727,
 688728334,
 687805761,
 78749,
 -1,
 688657780,
 78750,
 688859408,
 688657677,
 78747,
 -1,
 688788852,
 78748,
 688990482,
 688788300,
 78741,
 -1,
 688919924,
 78742,
 -55021,
 688919750,
 78746,
 -55020,
 689050753,
 78745,
 -55019,
 689116169,
 78744,
 -55018,
 689181628,
 78743,
 -55017,
 689246887,
 78740,
 -1,
 689312271,
 78739,
 689514798,
 687739279,
 -1,
 689580323,
 689443343,
 78690,
 -55013,
 689529215,
 78699,
 -55012,
 689592459,
 78698,
 -55011,
 689656547,
 78697,
 -55010,
 689720918,
 78696,
 -55009,
 689782919,
 78695,
 -55008,
 689845792,
 78694,
 -55007,
 689908958,
 78693,
 -55006,
 689972854,
 78692,
 -1,
 690034036,
 78691,
 690235686,
 689509574,
 78706,
 -55003,
 690169462,
 78708,
 -1,
 690230644,
 78707,
 690432296,
 690164391,
 78700,
 -1,
 690361716,
 78701,
 -54999,
 690361665,
 78710,
 -54998,
 690492685,
 78709,
 -54997,
 690558081,
 78705,
 -54996,
 690623497,
 78704,
 -54995,
 690688956,
 78703,
 -1,
 690754380,
 78702,
 690956606,
 689443343,
 -1,
 691022131,
 690885135,
 78712,
 -54991,
 690957534,
 78715,
 -54990,
 691021430,
 78714,
 -1,
 691082612,
 78713,
 691284278,
 690950823,
 78716,
 -54987,
 691218038,
 78718,
 -1,
 691279220,
 78717,
 -54985,
 691213633,
 78725,
 -54984,
 691410189,
 78724,
 -54983,
 691475654,
 78723,
 -54982,
 691541121,
 78722,
 -54981,
 691606537,
 78721,
 -54980,
 691671996,
 78720,
 -54979,
 691737420,
 78719,
 -1,
 691802511,
 78711,
 692005197,
 690885452,
 -1,
 692070721,
 691934406,
 78761,
 -1,
 692000116,
 78762,
 692201795,
 691999564,
 78756,
 -1,
 692131188,
 78757,
 692332869,
 692130319,
 78753,
 -1,
 692262260,
 78754,
 692463943,
 692261263,
 78751,
 -1,
 692393332,
 78752,
 -54968,
 692393281,
 78764,
 -54967,
 692524301,
 78763,
 -54966,
 692589697,
 78760,
 -54965,
 692655113,
 78759,
 -54964,
 692720572,
 78758,
 -1,
 692785831,
 78755,
 693043199,
 691934201,
 78765,
 -1,
 692917620,
 78766,
 693119393,
 687706583,
 -1,
 693184866,
 693047695,
 -1,
 693250392,
 693113985,
 78423,
 -54957,
 693194326,
 78429,
 -54956,
 693256327,
 78428,
 -54955,
 693319200,
 78427,
 -54954,
 693382366,
 78426,
 -54953,
 693446262,
 78425,
 -1,
 693507444,
 78424,
 693709146,
 693179401,
 78421,
 -1,
 693638516,
 78422,
 693840220,
 693637647,
 78416,
 -1,
 693769588,
 78417,
 -54947,
 693769537,
 78432,
 -54946,
 693900557,
 78431,
 -54945,
 693966022,
 78430,
 -54944,
 694031292,
 78420,
 -54943,
 694096716,
 78419,
 -1,
 694162087,
 78418,
 694364531,
 693113676,
 -1,
 694430056,
 694293633,
 78469,
 -54939,
 694367776,
 78473,
 -54938,
 694430942,
 78472,
 -54937,
 694494838,
 78471,
 -1,
 694556020,
 78470,
 694757738,
 694358860,
 78465,
 -1,
 694687092,
 78466,
 694888812,
 694686095,
 78461,
 -1,
 694818164,
 78462,
 -54931,
 694818113,
 78476,
 -54930,
 694949133,
 78475,
 -54929,
 695014598,
 78474,
 -54928,
 695079945,
 78468,
 -54927,
 695145404,
 78467,
 -54926,
 695210663,
 78464,
 -1,
 695276047,
 78463,
 695478658,
 694293159,
 -1,
 695544182,
 695407937,
 78459,
 -1,
 695473524,
 78460,
 695675256,
 695473161,
 78454,
 -1,
 695604596,
 78455,
 695806330,
 695604156,
 78452,
 -1,
 695735668,
 78453,
 695937404,
 695734671,
 78447,
 -1,
 695866740,
 78448,
 -54915,
 695866637,
 78458,
 -54914,
 695997638,
 78457,
 -54913,
 696063105,
 78456,
 -54912,
 696128332,
 78451,
 -54911,
 696193703,
 78450,
 -1,
 696259087,
 78449,
 696461713,
 695407119,
 -1,
 696527239,
 696390031,
 78433,
 -54907,
 696462558,
 78436,
 -54906,
 696526454,
 78435,
 -1,
 696587636,
 78434,
 696789385,
 696456513,
 78445,
 -1,
 696718708,
 78446,
 -54902,
 696718605,
 78444,
 -54901,
 696849606,
 78443,
 -54900,
 696915073,
 78442,
 -54899,
 696980489,
 78441,
 -54898,
 697045948,
 78440,
 -54897,
 697111372,
 78439,
 -54896,
 697176743,
 78438,
 -1,
 697242127,
 78437,
 697444764,
 696390588,
 -1,
 -54893,
 697374017,
 78486,
 -54892,
 697439501,
 78485,
 -54891,
 697504966,
 78484,
 -54890,
 697570433,
 78483,
 -54889,
 697635849,
 78482,
 -54888,
 697701308,
 78481,
 -54887,
 697766732,
 78480,
 -54886,
 697832103,
 78479,
 -54885,
 697897487,
 78478,
 -1,
 697962895,
 78477,
 698220543,
 697373705,
 -1,
 698231200,
 698093967,
 78487,
 -54881,
 698164854,
 78489,
 -1,
 698226036,
 78488,
 -1,
 698159631,
 78490,
 698493417,
 693076015,
 -1,
 698558905,
 698421775,
 -1,
 698624428,
 698487463,
 78268,
 -54875,
 698570891,
 78276,
 -54874,
 698634979,
 78275,
 -54873,
 698699350,
 78274,
 -54872,
 698761351,
 78273,
 -54871,
 698824224,
 78272,
 -54870,
 698887390,
 78271,
 -54869,
 698951286,
 78270,
 -1,
 699012468,
 78269,
 699214254,
 698553542,
 78283,
 -1,
 699143540,
 78284,
 699345328,
 699143297,
 78281,
 -1,
 699274612,
 78282,
 699476402,
 699274249,
 78279,
 -1,
 699405684,
 78280,
 699607476,
 699404687,
 78265,
 -1,
 699536756,
 78266,
 -54859,
 699536705,
 78286,
 -54858,
 699667725,
 78285,
 -54857,
 699732924,
 78278,
 -54856,
 699798348,
 78277,
 -1,
 699863567,
 78267,
 700066247,
 698487628,
 -1,
 700131773,
 699994956,
 78304,
 -54852,
 700065398,
 78306,
 -1,
 700126580,
 78305,
 700328383,
 700060175,
 78301,
 -1,
 700257652,
 78302,
 -54848,
 700257601,
 78312,
 -54847,
 700388621,
 78311,
 -54846,
 700454086,
 78310,
 -54845,
 700519553,
 78309,
 -54844,
 700584969,
 78308,
 -54843,
 700650428,
 78307,
 -54842,
 700715687,
 78303,
 -1,
 700780943,
 78300,
 700983765,
 699994791,
 -1,
 701049290,
 700912909,
 78297,
 -1,
 700978548,
 78298,
 701180364,
 700978108,
 78292,
 -1,
 701109620,
 78293,
 701311438,
 701108903,
 78289,
 -1,
 701240692,
 78290,
 -54833,
 701240641,
 78299,
 -54832,
 701371590,
 78296,
 -54831,
 701437057,
 78295,
 -54830,
 701502473,
 78294,
 -54829,
 701567820,
 78291,
 -54828,
 701633039,
 78288,
 -1,
 701698447,
 78287,
 701901282,
 700912015,
 -1,
 701966809,
 701829647,
 78253,
 -54824,
 701900406,
 78255,
 -1,
 701961588,
 78254,
 702163419,
 701895500,
 78257,
 -1,
 702092660,
 78258,
 -54820,
 702092609,
 78264,
 -54819,
 702223629,
 78263,
 -54818,
 702289094,
 78262,
 -54817,
 702354561,
 78261,
 -54816,
 702419977,
 78260,
 -54815,
 702485436,
 78259,
 -1,
 702550695,
 78256,
 702808063,
 701830076,
 -1,
 702818789,
 702681487,
 78313,
 -1,
 702748020,
 78314,
 -54810,
 702747580,
 78318,
 -54809,
 702878540,
 78317,
 -54808,
 702943911,
 78316,
 -1,
 703009295,
 78315,
 703212081,
 698437297,
 -1,
 703277560,
 703140796,
 -1,
 703343085,
 703206598,
 78132,
 -1,
 703272308,
 78133,
 703474159,
 703272065,
 78130,
 -1,
 703403380,
 78131,
 703605233,
 703403017,
 78128,
 -1,
 703534452,
 78129,
 -54798,
 703534401,
 78135,
 -54797,
 703665421,
 78134,
 -54796,
 703730620,
 78127,
 -54795,
 703796044,
 78126,
 -54794,
 703861415,
 78125,
 -54793,
 703926799,
 78124,
 -1,
 703992207,
 78123,
 704195078,
 703206220,
 -1,
 704260603,
 704124173,
 78120,
 -1,
 704189812,
 78121,
 704391677,
 704189638,
 78118,
 -1,
 704320884,
 78119,
 704522751,
 704320015,
 78111,
 -1,
 704451956,
 78112,
 -54784,
 704451905,
 78122,
 -54783,
 704582785,
 78117,
 -54782,
 704648201,
 78116,
 -54781,
 704713660,
 78115,
 -54780,
 704779084,
 78114,
 -54779,
 704844455,
 78113,
 -1,
 704909711,
 78110,
 705112594,
 704123559,
 -1,
 705178121,
 705040911,
 78100,
 -1,
 705107316,
 78101,
 -54774,
 705107265,
 78109,
 -54773,
 705238285,
 78108,
 -54772,
 705303750,
 78107,
 -54771,
 705369217,
 78106,
 -54770,
 705434633,
 78105,
 -54769,
 705500092,
 78104,
 -54768,
 705565516,
 78103,
 -54767,
 705630887,
 78102,
 -1,
 705696143,
 78099,
 705899038,
 705040911,
 -1,
 705964565,
 705827660,
 78091,
 -1,
 705893748,
 78092,
 -54762,
 705893697,
 78098,
 -54761,
 706024717,
 78097,
 -54760,
 706090182,
 78096,
 -54759,
 706155649,
 78095,
 -54758,
 706221065,
 78094,
 -54757,
 706286524,
 78093,
 -54756,
 706351783,
 78090,
 -54755,
 706417167,
 78089,
 -1,
 706482575,
 78088,
 706685481,
 705827215,
 -1,
 706751009,
 706613775,
 78078,
 -1,
 706680180,
 78079,
 -54750,
 706680129,
 78087,
 -54749,
 706811149,
 78086,
 -54748,
 706876614,
 78085,
 -54747,
 706942081,
 78084,
 -54746,
 707007497,
 78083,
 -54745,
 707072956,
 78082,
 -54744,
 707138380,
 78081,
 -1,
 707203751,
 78080,
 707461119,
 706614281,
 -1,
 707471918,
 707334671,
 78137,
 -54740,
 707407070,
 78140,
 -54739,
 707470966,
 78139,
 -1,
 707532148,
 78138,
 -54737,
 707400524,
 78142,
 -54736,
 707662503,
 78141,
 -1,
 707727759,
 78136,
 707930744,
 703156984,
 -1,
 707996223,
 707859388,
 -1,
 708061749,
 707925001,
 78196,
 -1,
 707990900,
 78197,
 708192823,
 707990348,
 78193,
 -1,
 708121972,
 78194,
 -54728,
 708121921,
 78201,
 -54727,
 708252941,
 78200,
 -54726,
 708318406,
 78199,
 -54725,
 708383873,
 78198,
 -54724,
 708449212,
 78195,
 -54723,
 708514471,
 78192,
 -54722,
 708579855,
 78191,
 -1,
 708645263,
 78190,
 708848204,
 707924812,
 -1,
 708913730,
 708777158,
 78186,
 -1,
 708842868,
 78187,
 709044804,
 708842625,
 78184,
 -1,
 708973940,
 78185,
 -54715,
 708973889,
 78189,
 -54714,
 709104909,
 78188,
 -54713,
 709170185,
 78183,
 -54712,
 709235644,
 78182,
 -54711,
 709301068,
 78181,
 -54710,
 709366439,
 78180,
 -54709,
 709431823,
 78179,
 -1,
 709497231,
 78178,
 709700185,
 708776615,
 -1,
 709765711,
 709629057,
 78173,
 -1,
 709694836,
 78174,
 709896785,
 709693839,
 78166,
 -1,
 709825908,
 78167,
 -54702,
 709825857,
 78177,
 -54701,
 709956877,
 78176,
 -54700,
 710022342,
 78175,
 -54699,
 710087689,
 78172,
 -54698,
 710153148,
 78171,
 -54697,
 710218572,
 78170,
 -54696,
 710283943,
 78169,
 -1,
 710349327,
 78168,
 710552166,
 709628303,
 -1,
 710617693,
 710481094,
 78150,
 -54692,
 710551158,
 78152,
 -1,
 710612340,
 78151,
 710814303,
 710546561,
 78148,
 -1,
 710743412,
 78149,
 -54688,
 710743361,
 78154,
 -54687,
 710874381,
 78153,
 -54686,
 710939657,
 78147,
 -54685,
 711005116,
 78146,
 -54684,
 711070540,
 78145,
 -54683,
 711135911,
 78144,
 -1,
 711201295,
 78143,
 711404146,
 710480399,
 -1,
 711469673,
 711332367,
 78156,
 -1,
 711398772,
 78157,
 -54678,
 711398721,
 78165,
 -54677,
 711529741,
 78164,
 -54676,
 711595206,
 78163,
 -54675,
 711660673,
 78162,
 -54674,
 711726089,
 78161,
 -54673,
 711791548,
 78160,
 -54672,
 711856972,
 78159,
 -54671,
 711922343,
 78158,
 -1,
 711987599,
 78155,
 712245247,
 711332873,
 -1,
 -54668,
 712119228,
 78206,
 -54667,
 712184652,
 78205,
 -54666,
 712250023,
 78204,
 -54665,
 712315407,
 78203,
 -1,
 712380815,
 78202,
 712583860,
 707901334,
 -1,
 712649351,
 712512015,
 -1,
 712714877,
 712577980,
 78560,
 -54660,
 712648310,
 78562,
 -1,
 712709492,
 78561,
 712911487,
 712643782,
 78565,
 -1,
 712840564,
 78566,
 -54656,
 712840513,
 78568,
 -54655,
 712971533,
 78567,
 -54654,
 713036929,
 78564,
 -54653,
 713102345,
 78563,
 -54652,
 713167692,
 78559,
 -54651,
 713233063,
 78558,
 -54650,
 713298447,
 78557,
 -1,
 713363855,
 78556,
 713566868,
 712577703,
 -1,
 713632395,
 713495681,
 78575,
 -54646,
 713565814,
 78577,
 -1,
 713626996,
 78576,
 -54644,
 713561409,
 78580,
 -54643,
 713757965,
 78579,
 -54642,
 713823430,
 78578,
 -54641,
 713888777,
 78574,
 -54640,
 713954236,
 78573,
 -54639,
 714019660,
 78572,
 -54638,
 714085031,
 78571,
 -54637,
 714150415,
 78570,
 -1,
 714215823,
 78569,
 714418848,
 713495372,
 -1,
 714484375,
 714347529,
 78586,
 -1,
 714413428,
 78587,
 -54632,
 714413377,
 78591,
 -54631,
 714544397,
 78590,
 -54630,
 714609862,
 78589,
 -54629,
 714675329,
 78588,
 -54628,
 714740668,
 78585,
 -54627,
 714806092,
 78584,
 -54626,
 714871463,
 78583,
 -54625,
 714936847,
 78582,
 -1,
 715002255,
 78581,
 715205292,
 714346895,
 -1,
 715270819,
 715134081,
 78551,
 -1,
 715199860,
 78552,
 715401893,
 715199143,
 78546,
 -1,
 715330932,
 78547,
 -54618,
 715330881,
 78555,
 -54617,
 715461901,
 78554,
 -54616,
 715527366,
 78553,
 -54615,
 715592713,
 78550,
 -54614,
 715658172,
 78549,
 -54613,
 715723596,
 78548,
 -1,
 715788815,
 78545,
 716046335,
 715133884,
 -1,
 -54610,
 715920513,
 78598,
 -54609,
 715985929,
 78597,
 -54608,
 716051388,
 78596,
 -54607,
 716116812,
 78595,
 -54606,
 716182183,
 78594,
 -54605,
 716247567,
 78593,
 -1,
 716312975,
 78592,
 716516073,
 712560298,
 -1,
 716581570,
 716444327,
 -1,
 716647096,
 716510529,
 78674,
 -1,
 716576116,
 78675,
 716778170,
 716575564,
 78667,
 -1,
 716707188,
 78668,
 -54597,
 716707085,
 78673,
 -54596,
 716838086,
 78672,
 -54595,
 716903553,
 78671,
 -54594,
 716968969,
 78670,
 -54593,
 717034428,
 78669,
 -54592,
 717099687,
 78666,
 -54591,
 717165071,
 78665,
 -1,
 717230479,
 78664,
 717433550,
 716510028,
 -1,
 717499077,
 717361831,
 78678,
 -1,
 717428084,
 78679,
 -54586,
 717428033,
 78686,
 -54585,
 717559053,
 78685,
 -54584,
 717624518,
 78684,
 -54583,
 717689985,
 78683,
 -54582,
 717755401,
 78682,
 -54581,
 717820860,
 78681,
 -54580,
 717886284,
 78680,
 -54579,
 717951503,
 78677,
 -1,
 718016911,
 78676,
 718219994,
 717361551,
 -1,
 718285522,
 718148737,
 78648,
 -54575,
 718218870,
 78650,
 -1,
 718280052,
 78649,
 -54573,
 718214465,
 78653,
 -54572,
 718411021,
 78652,
 -54571,
 718476486,
 78651,
 -54570,
 718541833,
 78647,
 -54569,
 718607292,
 78646,
 -54568,
 718672716,
 78645,
 -54567,
 718738087,
 78644,
 -1,
 718803471,
 78643,
 719006437,
 718148111,
 -1,
 -54564,
 718935361,
 78663,
 -54563,
 719000845,
 78662,
 -54562,
 719066310,
 78661,
 -54561,
 719131777,
 78660,
 -54560,
 719197193,
 78659,
 -54559,
 719262652,
 78658,
 -54558,
 719328076,
 78657,
 -54557,
 719393447,
 78656,
 -54556,
 719458831,
 78655,
 -1,
 719524239,
 78654,
 719781887,
 718934972,
 -1,
 -54553,
 719655591,
 78689,
 -54552,
 719720975,
 78688,
 -1,
 719786383,
 78687,
 719989530,
 716489490,
 -1,
 720055032,
 719917455,
 -1,
 720120557,
 719983937,
 78610,
 -1,
 720049524,
 78611,
 720251631,
 720049421,
 78608,
 -1,
 720180596,
 78609,
 720382705,
 720180422,
 78606,
 -1,
 720311668,
 78607,
 720513779,
 720311116,
 78601,
 -1,
 720442740,
 78602,
 -54540,
 720442497,
 78605,
 -54539,
 720573449,
 78604,
 -54538,
 720638908,
 78603,
 -54537,
 720704167,
 78600,
 -1,
 720769551,
 78599,
 720972549,
 719983119,
 -1,
 721038075,
 720901249,
 78619,
 -1,
 720967028,
 78620,
 721169149,
 720966159,
 78613,
 -1,
 721098100,
 78614,
 -54530,
 721098049,
 78623,
 -54529,
 721229069,
 78622,
 -54528,
 721294534,
 78621,
 -54527,
 721359881,
 78618,
 -54526,
 721425340,
 78617,
 -54525,
 721490764,
 78616,
 -54524,
 721556135,
 78615,
 -1,
 721621391,
 78612,
 721824528,
 720900775,
 -1,
 -54521,
 721753409,
 78633,
 -54520,
 721818893,
 78632,
 -54519,
 721884358,
 78631,
 -54518,
 721949825,
 78630,
 -54517,
 722015241,
 78629,
 -54516,
 722080700,
 78628,
 -54515,
 722146124,
 78627,
 -54514,
 722211495,
 78626,
 -54513,
 722276879,
 78625,
 -1,
 722342287,
 78624,
 722599935,
 721752908,
 -1,
 722610963,
 722473804,
 78638,
 -1,
 722539892,
 78639,
 722742037,
 722539175,
 78636,
 -1,
 722670964,
 78637,
 -54506,
 722670721,
 78642,
 -54505,
 722801673,
 78641,
 -54504,
 722867132,
 78640,
 -54503,
 722932239,
 78635,
 -1,
 722997647,
 78634,
 723200843,
 719929604,
 -1,
 723266344,
 723128999,
 -1,
 723331870,
 723195149,
 78066,
 -1,
 723260788,
 78067,
 723462944,
 723259791,
 78057,
 -1,
 723391860,
 78058,
 -54495,
 723391809,
 78068,
 -54494,
 723522758,
 78065,
 -54493,
 723588225,
 78064,
 -54492,
 723653641,
 78063,
 -54491,
 723719100,
 78062,
 -54490,
 723784524,
 78061,
 -54489,
 723849895,
 78060,
 -1,
 723915279,
 78059,
 724118325,
 723194383,
 -1,
 724183851,
 724047046,
 78053,
 -1,
 724112756,
 78054,
 724314925,
 724112513,
 78051,
 -1,
 724243828,
 78052,
 -54482,
 724243777,
 78056,
 -54481,
 724374797,
 78055,
 -54480,
 724440073,
 78050,
 -54479,
 724505532,
 78049,
 -54478,
 724570956,
 78048,
 -54477,
 724636327,
 78047,
 -54476,
 724701711,
 78046,
 -1,
 724767119,
 78045,
 724970305,
 724046223,
 -1,
 725035832,
 724899137,
 78043,
 -1,
 724964724,
 78044,
 725166906,
 724964621,
 78041,
 -1,
 725095796,
 78042,
 -54469,
 725095622,
 78040,
 -54468,
 725226625,
 78039,
 -54467,
 725292041,
 78038,
 -54466,
 725357500,
 78037,
 -54465,
 725422924,
 78036,
 -54464,
 725488295,
 78035,
 -1,
 725553679,
 78034,
 725811199,
 724898636,
 -1,
 725822276,
 725685180,
 78073,
 -1,
 725751156,
 78074,
 -54459,
 725751053,
 78077,
 -54458,
 725882054,
 78076,
 -54457,
 725947521,
 78075,
 -54456,
 726012748,
 78072,
 -54455,
 726078119,
 78071,
 -54454,
 726143503,
 78070,
 -1,
 726208911,
 78069,
 726412151,
 723183402,
 -1,
 726477669,
 726340111,
 -1,
 726543191,
 726406153,
 78842,
 -54449,
 726491519,
 78851,
 -54448,
 726554763,
 78850,
 -54447,
 726618851,
 78849,
 -54446,
 726683222,
 78848,
 -54445,
 726745223,
 78847,
 -54444,
 726808096,
 78846,
 -54443,
 726871262,
 78845,
 -54442,
 726935158,
 78844,
 -1,
 726996340,
 78843,
 727198560,
 726471809,
 78852,
 -54439,
 727144587,
 78860,
 -54438,
 727208675,
 78859,
 -54437,
 727273046,
 78858,
 -54436,
 727335047,
 78857,
 -54435,
 727397920,
 78856,
 -54434,
 727461086,
 78855,
 -54433,
 727524982,
 78854,
 -1,
 727586164,
 78853,
 -54431,
 727126972,
 78841,
 -54430,
 727716684,
 78840,
 -54429,
 727782055,
 78839,
 -54428,
 727847439,
 78838,
 -1,
 727912847,
 78837,
 728170495,
 726405519,
 -1,
 728181611,
 728044199,
 78821,
 -54424,
 728118816,
 78825,
 -54423,
 728181982,
 78824,
 -54422,
 728245878,
 78823,
 -1,
 728307060,
 78822,
 728509294,
 728109900,
 78826,
 -54419,
 728442486,
 78828,
 -1,
 728503668,
 78827,
 728705904,
 728437769,
 78831,
 -1,
 728634740,
 78832,
 728836978,
 728634300,
 78829,
 -1,
 728765812,
 78830,
 -54413,
 728765761,
 78836,
 -54412,
 728896781,
 78835,
 -54411,
 728962246,
 78834,
 -54410,
 729027713,
 78833,
 -1,
 729092623,
 78820,
 729295773,
 726378907,
 -1,
 729361285,
 729223695,
 -1,
 729426811,
 729289857,
 78530,
 -1,
 729355636,
 78531,
 729557885,
 729354639,
 78523,
 -1,
 729486708,
 78524,
 -54402,
 729486657,
 78534,
 -54401,
 729617677,
 78533,
 -54400,
 729683142,
 78532,
 -54399,
 729748489,
 78529,
 -54398,
 729813948,
 78528,
 -54397,
 729879372,
 78527,
 -54396,
 729944743,
 78526,
 -1,
 730010127,
 78525,
 730213266,
 729289103,
 -1,
 730278793,
 730141516,
 78514,
 -54392,
 730211958,
 78516,
 -1,
 730273140,
 78515,
 730475403,
 730206887,
 78512,
 -1,
 730404212,
 78513,
 -54388,
 730404161,
 78522,
 -54387,
 730535181,
 78521,
 -54386,
 730600646,
 78520,
 -54385,
 730666113,
 78519,
 -54384,
 730731529,
 78518,
 -54383,
 730796988,
 78517,
 -1,
 730862095,
 78511,
 731119615,
 730141351,
 -1,
 -54380,
 730993985,
 78544,
 -54379,
 731059469,
 78543,
 -54378,
 731124934,
 78542,
 -54377,
 731190401,
 78541,
 -54376,
 731255817,
 78540,
 -54375,
 731321276,
 78539,
 -54374,
 731386700,
 78538,
 -54373,
 731452071,
 78537,
 -54372,
 731517455,
 78536,
 -1,
 731582863,
 78535,
 731786177,
 729275693,
 -1,
 731851693,
 731714063,
 -1,
 731917217,
 731780365,
 78789,
 -1,
 731846004,
 78790,
 732048291,
 731845830,
 78787,
 -1,
 731977076,
 78788,
 732179365,
 731976636,
 78783,
 -1,
 732108148,
 78784,
 732310439,
 732107151,
 78778,
 -1,
 732239220,
 78779,
 -54360,
 732239169,
 78791,
 -54359,
 732370049,
 78786,
 -54358,
 732435465,
 78785,
 -54357,
 732500812,
 78782,
 -54356,
 732566183,
 78781,
 -1,
 732631567,
 78780,
 732834745,
 731779471,
 -1,
 732900272,
 732763457,
 78776,
 -1,
 732829044,
 78777,
 733031346,
 732828492,
 78769,
 -1,
 732960116,
 78770,
 -54349,
 732960013,
 78775,
 -54348,
 733091014,
 78774,
 -54347,
 733156481,
 78773,
 -54346,
 733221897,
 78772,
 -54345,
 733287356,
 78771,
 -54344,
 733352615,
 78768,
 -1,
 733417999,
 78767,
 733675519,
 732762791,
 -1,
 733686716,
 733549500,
 78796,
 -1,
 733615476,
 78797,
 -54339,
 733615113,
 78798,
 -54338,
 733745996,
 78795,
 -54337,
 733811367,
 78794,
 -54336,
 733876751,
 78793,
 -1,
 733942159,
 78792,
 734145505,
 731721016,
 -1,
 734211023,
 734073231,
 -1,
 734276551,
 734139047,
 77915,
 -54331,
 734211294,
 77918,
 -54330,
 734275190,
 77917,
 -1,
 734336372,
 77916,
 -54328,
 734205249,
 77925,
 -54327,
 734467341,
 77924,
 -54326,
 734532806,
 77923,
 -54325,
 734598273,
 77922,
 -54324,
 734663689,
 77921,
 -54323,
 734729148,
 77920,
 -54322,
 734794572,
 77919,
 -1,
 734859791,
 77914,
 735063003,
 734138895,
 -1,
 735128530,
 734990735,
 77926,
 -1,
 735057268,
 77927,
 -54317,
 735057217,
 77936,
 -54316,
 735188237,
 77935,
 -54315,
 735253702,
 77934,
 -54314,
 735319169,
 77933,
 -54313,
 735384585,
 77932,
 -54312,
 735450044,
 77931,
 -54311,
 735515468,
 77930,
 -54310,
 735580839,
 77929,
 -1,
 735646223,
 77928,
 735903743,
 734991015,
 -1,
 -54307,
 735777724,
 77941,
 -54306,
 735843148,
 77940,
 -54305,
 735908519,
 77939,
 -54304,
 735973903,
 77938,
 -1,
 736039311,
 77937,
 736242679,
 734093827,
 -1,
 736308206,
 736170383,
 -1,
 736373733,
 736236865,
 78225,
 -1,
 736302452,
 78226,
 736504807,
 736302089,
 78220,
 -1,
 736433524,
 78221,
 -54296,
 736433421,
 78224,
 -54295,
 736564422,
 78223,
 -54294,
 736629889,
 78222,
 -54293,
 736695228,
 78219,
 -54292,
 736760652,
 78218,
 -54291,
 736826023,
 78217,
 -1,
 736891407,
 78216,
 737148927,
 736236047,
 -1,
 737160177,
 737022479,
 78229,
 -1,
 737088884,
 78230,
 737291251,
 737087887,
 78227,
 -1,
 737219956,
 78228,
 -54284,
 737219593,
 78234,
 -54283,
 737350588,
 78233,
 -54282,
 737416012,
 78232,
 -1,
 737481383,
 78231,
 737684487,
 736206923,
 -1,
 737750020,
 737612175,
 -1,
 737815547,
 737678156,
 78494,
 -1,
 737744244,
 78495,
 737946621,
 737743375,
 78491,
 -1,
 737875316,
 78492,
 -54274,
 737875265,
 78501,
 -54273,
 738006285,
 78500,
 -54272,
 738071750,
 78499,
 -54271,
 738137217,
 78498,
 -54270,
 738202633,
 78497,
 -54269,
 738268092,
 78496,
 -1,
 738333351,
 78493,
 738590719,
 737677839,
 -1,
 -54266,
 738464271,
 78503,
 -1,
 738529679,
 78502,
 738733076,
 737665824,
 -1,
 738798603,
 738661308,
 78802,
 -54262,
 738731638,
 78804,
 -1,
 738792820,
 78803,
 738995213,
 738727181,
 78809,
 -1,
 738923892,
 78810,
 739126287,
 738923649,
 78806,
 -1,
 739054964,
 78807,
 -54256,
 739054790,
 78808,
 -54255,
 739185673,
 78805,
 -54254,
 739251020,
 78801,
 -54253,
 739316391,
 78800,
 -1,
 739381775,
 78799,
 739585055,
 738685862,
 -1,
 739650583,
 739513473,
 78249,
 -1,
 739579252,
 78250,
 739781657,
 739578535,
 78244,
 -1,
 739710324,
 78245,
 -54246,
 739710221,
 78252,
 -54245,
 739841222,
 78251,
 -54244,
 739906569,
 78248,
 -54243,
 739972028,
 78247,
 -54242,
 740037452,
 78246,
 -1,
 740102671,
 78243,
 740305962,
 739518085,
 -1,
 740371490,
 740234249,
 77908,
 -1,
 740300148,
 77909,
 -54237,
 740300097,
 77913,
 -54236,
 740431117,
 77912,
 -54235,
 740496582,
 77911,
 -54234,
 740562049,
 77910,
 -54233,
 740627388,
 77907,
 -54232,
 740692812,
 77906,
 -54231,
 740758183,
 77905,
 -1,
 740823567,
 77904,
 741026868,
 740287526,
 -1,
 741092397,
 740954639,
 78811,
 -1,
 741021044,
 78812,
 -54226,
 741020941,
 78819,
 -54225,
 741151942,
 78818,
 -54224,
 741217409,
 78817,
 -54223,
 741282825,
 78816,
 -54222,
 741348284,
 78815,
 -54221,
 741413708,
 78814,
 -1,
 741479079,
 78813,
 741682238,
 740972709,
 -1,
 741747767,
 741610625,
 78212,
 -1,
 741676404,
 78213,
 -54216,
 741676301,
 78215,
 -54215,
 741807302,
 78214,
 -54214,
 741872649,
 78211,
 -54213,
 741938108,
 78210,
 -54212,
 742003532,
 78209,
 -54211,
 742068903,
 78208,
 -1,
 742134287,
 78207,
 742337607,
 741634186,
 -1,
 -54208,
 742266125,
 78242,
 -54207,
 742331590,
 78241,
 -54206,
 742397057,
 78240,
 -54205,
 742462473,
 78239,
 -54204,
 742527932,
 78238,
 -54203,
 742593356,
 78237,
 -54202,
 742658727,
 78236,
 -1,
 742724111,
 78235,
 742981631,
 742303558,
 -1,
 -54199,
 742855878,
 78510,
 -54198,
 742921345,
 78509,
 -54197,
 742986761,
 78508,
 -54196,
 743052220,
 78507,
 -54195,
 743117644,
 78506,
 -54194,
 743183015,
 78505,
 -1,
 743248399,
 78504,
 743452263,
 665437878,
 -1,
 743517747,
 743421727,
 -1,
 743583280,
 743499245,
 -1,
 743648385,
 743527139,
 -1,
 743713889,
 743592675,
 -1,
 743779418,
 743693576,
 -1,
 743844951,
 743719047,
 11670,
 -1,
 743784583,
 11669,
 743976025,
 743773556,
 11667,
 -1,
 743904628,
 4895,
 -1,
 743924095,
 11668,
 744172636,
 743719047,
 4893,
 -1,
 744112263,
 4892,
 744303710,
 744101236,
 4888,
 -1,
 744232308,
 4891,
 -54177,
 744279626,
 4889,
 -54176,
 744395151,
 4894,
 -1,
 744448383,
 4890,
 744631403,
 743669248,
 -1,
 744696932,
 744591759,
 4774,
 -1,
 744625524,
 11658,
 744828006,
 744636551,
 4773,
 -1,
 744767623,
 4772,
 744959080,
 744756596,
 4768,
 -1,
 744887668,
 4771,
 -54167,
 744938800,
 4775,
 -54166,
 745066058,
 4769,
 -1,
 745103743,
 4770,
 745286771,
 744612846,
 -1,
 745352302,
 745226375,
 11741,
 -1,
 745291911,
 11740,
 745483376,
 745280884,
 11736,
 -1,
 745411956,
 11739,
 -54159,
 745459274,
 11737,
 -54158,
 745574799,
 11742,
 -1,
 745628031,
 11738,
 745811065,
 745266440,
 -1,
 745876598,
 745750663,
 4885,
 -1,
 745816199,
 4884,
 746007672,
 745805172,
 4880,
 -1,
 745936244,
 4883,
 -1,
 745955711,
 4882,
 746204283,
 745771407,
 4878,
 -1,
 746132852,
 4879,
 746335357,
 746143879,
 4877,
 -1,
 746274951,
 4876,
 746466431,
 746263924,
 4872,
 -1,
 746394996,
 4875,
 -54144,
 746442314,
 4873,
 -1,
 746545535,
 4874,
 746728619,
 743618335,
 -1,
 746794124,
 746674315,
 -1,
 746859653,
 746754447,
 4670,
 -1,
 746788212,
 11652,
 746990727,
 746799239,
 4669,
 -1,
 746930311,
 4668,
 747121801,
 746919284,
 4664,
 -1,
 747050356,
 4667,
 -54134,
 747101488,
 4671,
 -54133,
 747228746,
 4665,
 -1,
 747266431,
 4666,
 747449493,
 746776350,
 -1,
 747515023,
 747389063,
 4645,
 -1,
 747454599,
 4644,
 747646097,
 747443572,
 4640,
 -1,
 747574644,
 4643,
 -54126,
 747625776,
 4647,
 -54125,
 747753034,
 4641,
 -54124,
 747803023,
 4646,
 -1,
 747856255,
 4642,
 748039325,
 747419423,
 -1,
 748104856,
 747978887,
 11685,
 -1,
 748044423,
 11684,
 748235930,
 748033396,
 11680,
 -1,
 748164468,
 11683,
 -54117,
 748211786,
 11681,
 -54116,
 748327311,
 11686,
 -1,
 748380543,
 11682,
 748563620,
 747978887,
 4661,
 748629155,
 748496861,
 -1,
 -54112,
 748595005,
 5004,
 -54111,
 748652719,
 4992,
 -54110,
 748704474,
 5000,
 -1,
 748760223,
 4996,
 -1,
 748568711,
 4660,
 749022374,
 748523919,
 4662,
 -1,
 748950900,
 11651,
 749153448,
 748950900,
 4656,
 -1,
 749081972,
 4659,
 -54103,
 749133104,
 4663,
 -54102,
 749260362,
 4657,
 -1,
 749298047,
 4658,
 749481169,
 746701524,
 -1,
 749546678,
 749426827,
 -1,
 749612207,
 749506959,
 4902,
 -1,
 749540724,
 11663,
 749743281,
 749551751,
 4901,
 -1,
 749682823,
 4900,
 749874355,
 749671796,
 4896,
 -1,
 749802868,
 4899,
 -54092,
 749854000,
 4903,
 -54091,
 749981258,
 4897,
 -1,
 750018943,
 4898,
 750202047,
 749528862,
 -1,
 750267577,
 750162319,
 4934,
 -1,
 750196084,
 4935,
 750398651,
 750207111,
 4933,
 -1,
 750338183,
 4932,
 750529725,
 750327156,
 4928,
 -1,
 750458228,
 4931,
 -54082,
 750505546,
 4929,
 -1,
 750608767,
 4930,
 750791880,
 750171935,
 -1,
 750857410,
 750731399,
 4925,
 -1,
 750796935,
 4924,
 750988484,
 750785908,
 4920,
 -1,
 750916980,
 4923,
 -54075,
 750968112,
 4927,
 -54074,
 751095370,
 4921,
 -54073,
 751145359,
 4926,
 -1,
 751198591,
 4922,
 751381706,
 750752143,
 4726,
 -1,
 751310196,
 11654,
 751512780,
 751321223,
 4725,
 -1,
 751452295,
 4724,
 751643854,
 751441268,
 4720,
 -1,
 751572340,
 4723,
 -54065,
 751623472,
 4727,
 -54064,
 751750730,
 4721,
 -1,
 751788415,
 4722,
 751971574,
 749446980,
 -1,
 752037088,
 751917195,
 -1,
 752102617,
 752016648,
 -1,
 752168150,
 752042119,
 4701,
 -1,
 752107655,
 4700,
 752299224,
 752096628,
 4696,
 -1,
 752227700,
 4699,
 -1,
 752247167,
 4698,
 752495835,
 752042119,
 4693,
 -1,
 752435335,
 4692,
 752626909,
 752424308,
 4688,
 -1,
 752555380,
 4691,
 -54050,
 752602698,
 4689,
 -54049,
 752718223,
 4694,
 -1,
 752771455,
 4690,
 752954600,
 752018414,
 -1,
 753020131,
 752894087,
 11717,
 -1,
 752959623,
 11716,
 753151205,
 752948596,
 11712,
 -1,
 753079668,
 11715,
 -54042,
 753126986,
 11713,
 -54041,
 753242511,
 11718,
 -1,
 753295743,
 11714,
 753478894,
 752934152,
 -1,
 753544427,
 753418375,
 4685,
 -1,
 753483911,
 4684,
 753675501,
 753472884,
 4680,
 -1,
 753603956,
 4683,
 -1,
 753623423,
 4682,
 753872112,
 753439119,
 4678,
 -1,
 753800564,
 4679,
 754003186,
 753811591,
 4677,
 -1,
 753942663,
 4676,
 754134260,
 753931636,
 4672,
 -1,
 754062708,
 4675,
 -54027,
 754110026,
 4673,
 -1,
 754213247,
 4674,
 754396443,
 751923336,
 -1,
 754461957,
 754377476,
 -1,
 754527486,
 754441480,
 -1,
 754593019,
 754466951,
 4805,
 -1,
 754532487,
 4804,
 754724093,
 754521460,
 4800,
 -1,
 754652532,
 4803,
 -1,
 754671999,
 4802,
 754920704,
 754466951,
 4797,
 -1,
 754860167,
 4796,
 755051778,
 754849140,
 4792,
 -1,
 754980212,
 4795,
 -54013,
 755027530,
 4793,
 -54012,
 755143055,
 4798,
 -1,
 755196287,
 4794,
 755379469,
 754443246,
 -1,
 755445000,
 755318919,
 11725,
 -1,
 755384455,
 11724,
 755576074,
 755373428,
 11720,
 -1,
 755504500,
 11723,
 -54005,
 755551818,
 11721,
 -54004,
 755667343,
 11726,
 -1,
 755720575,
 11722,
 755903763,
 755358984,
 -1,
 755969296,
 755843207,
 4789,
 -1,
 755908743,
 4788,
 756100370,
 755897716,
 4784,
 -1,
 756028788,
 4787,
 -1,
 756048255,
 4786,
 756296981,
 755863951,
 4782,
 -1,
 756225396,
 4783,
 756428055,
 756236423,
 4781,
 -1,
 756367495,
 4780,
 756559129,
 756356468,
 4776,
 -1,
 756487540,
 4779,
 -53990,
 756534858,
 4777,
 -1,
 756638079,
 4778,
 756821311,
 754330846,
 -1,
 756886828,
 756755678,
 -1,
 756952357,
 756832395,
 -1,
 757017888,
 756891783,
 11709,
 -1,
 756957319,
 11708,
 757148962,
 756946292,
 11704,
 -1,
 757077364,
 11707,
 -53981,
 757124682,
 11705,
 -53980,
 757240207,
 11710,
 -1,
 757293439,
 11706,
 757476647,
 756891783,
 11693,
 -1,
 757416071,
 11692,
 757607721,
 757405044,
 11688,
 -1,
 757536116,
 11691,
 -53974,
 757583434,
 11689,
 -53973,
 757698959,
 11694,
 -1,
 757752191,
 11690,
 757935414,
 756832395,
 -1,
 758000943,
 757895567,
 4910,
 -1,
 757929332,
 11664,
 758132017,
 757940359,
 4909,
 -1,
 758071431,
 4908,
 758263091,
 758060404,
 4904,
 -1,
 758191476,
 4907,
 -53964,
 758242608,
 4911,
 -53963,
 758369866,
 4905,
 -1,
 758407551,
 4906,
 758590776,
 757895567,
 4734,
 -1,
 758519156,
 11655,
 758721850,
 758530183,
 4733,
 -1,
 758661255,
 4732,
 758852924,
 758650228,
 4728,
 -1,
 758781300,
 4731,
 -53955,
 758832432,
 4735,
 -53954,
 758959690,
 4729,
 -1,
 758997375,
 4730,
 759180639,
 756785129,
 -1,
 759246162,
 759126155,
 -1,
 759311691,
 759174516,
 4912,
 759377226,
 759281418,
 -1,
 759442757,
 759316615,
 4821,
 -1,
 759382151,
 4820,
 759573831,
 759371124,
 4816,
 -1,
 759502196,
 4819,
 -53944,
 759549514,
 4817,
 -53943,
 759665039,
 4822,
 -1,
 759718271,
 4818,
 -1,
 759305588,
 4915,
 759967053,
 759271823,
 4918,
 -1,
 759895412,
 11665,
 760098127,
 759906439,
 4917,
 -1,
 760037511,
 4916,
 -53936,
 760077616,
 4919,
 -53935,
 760204874,
 4913,
 -1,
 760242559,
 4914,
 760425815,
 759225608,
 -1,
 760491349,
 760365191,
 5007,
 -1,
 760430727,
 5006,
 -53930,
 760439167,
 5005,
 -1,
 760550772,
 4951,
 760753497,
 760385935,
 4950,
 -1,
 760681844,
 11666,
 760884571,
 760692871,
 4949,
 -1,
 760823943,
 4948,
 761015645,
 760812916,
 4944,
 -1,
 760943988,
 4947,
 -53922,
 760991306,
 4945,
 -1,
 761094527,
 4946,
 761277818,
 759162654,
 -1,
 761343337,
 761223307,
 -1,
 761408867,
 761282695,
 4837,
 -1,
 761348231,
 4836,
 761539941,
 761337204,
 4832,
 -1,
 761468276,
 4835,
 -53914,
 761519408,
 4839,
 -53913,
 761646666,
 4833,
 -53912,
 761696655,
 4838,
 -1,
 761749887,
 4834,
 761933169,
 761325342,
 -1,
 761998700,
 761872519,
 11701,
 -1,
 761938055,
 11700,
 762129774,
 761927028,
 11696,
 -1,
 762058100,
 11699,
 -53905,
 762105418,
 11697,
 -53904,
 762220943,
 11702,
 -1,
 762274175,
 11698,
 762457459,
 761893263,
 4830,
 -1,
 762385780,
 11659,
 762588533,
 762396807,
 4829,
 -1,
 762527879,
 4828,
 762719607,
 762516852,
 4824,
 -1,
 762647924,
 4827,
 -53896,
 762699056,
 4831,
 -53895,
 762826314,
 4825,
 -1,
 762863999,
 4826,
 763047313,
 761258756,
 -1,
 763112835,
 763028462,
 -1,
 763178366,
 763052167,
 11733,
 -1,
 763117703,
 11732,
 763309440,
 763106676,
 11728,
 -1,
 763237748,
 11731,
 -53887,
 763285066,
 11729,
 -53886,
 763400591,
 11734,
 -1,
 763453823,
 11730,
 763637129,
 763092232,
 -1,
 763702662,
 763576455,
 4749,
 -1,
 763641991,
 4748,
 763833736,
 763630964,
 4744,
 -1,
 763762036,
 4747,
 -1,
 763781503,
 4746,
 764030347,
 763597199,
 4742,
 -1,
 763958644,
 4743,
 764161421,
 763969671,
 4741,
 -1,
 764100743,
 4740,
 764292495,
 764089716,
 4736,
 -1,
 764220788,
 4739,
 -53872,
 764268106,
 4737,
 -1,
 764371327,
 4738,
 764554661,
 763005151,
 -1,
 764620188,
 764535790,
 -1,
 764685717,
 764580239,
 4766,
 -1,
 764614004,
 11657,
 764816791,
 764625031,
 4765,
 -1,
 764756103,
 4764,
 764947865,
 764745076,
 4760,
 -1,
 764876148,
 4763,
 -53862,
 764927280,
 4767,
 -53861,
 765054538,
 4761,
 -1,
 765092223,
 4762,
 765275550,
 764580239,
 4758,
 -1,
 765203828,
 11656,
 765406624,
 765214855,
 4757,
 -1,
 765345927,
 4756,
 765537698,
 765334900,
 4752,
 -1,
 765465972,
 4755,
 -53853,
 765517104,
 4759,
 -53852,
 765644362,
 4753,
 -1,
 765682047,
 4754,
 765865401,
 764491296,
 -1,
 765930928,
 765802016,
 -1,
 765996457,
 765890959,
 4862,
 -1,
 765924724,
 11661,
 766127531,
 765935751,
 4861,
 -1,
 766066823,
 4860,
 766258605,
 766055796,
 4856,
 -1,
 766186868,
 4859,
 -53842,
 766238000,
 4863,
 -53841,
 766365258,
 4857,
 -1,
 766402943,
 4858,
 766586290,
 765890959,
 4854,
 -1,
 766514548,
 11660,
 766717364,
 766525575,
 4853,
 -1,
 766656647,
 4852,
 766848438,
 766645620,
 4848,
 -1,
 766776692,
 4851,
 -53833,
 766827824,
 4855,
 -53832,
 766955082,
 4849,
 -1,
 766992767,
 4850,
 767176139,
 765810827,
 -1,
 767241667,
 767121547,
 -1,
 767307197,
 767180935,
 4629,
 -1,
 767246471,
 4628,
 767438271,
 767235444,
 4624,
 -1,
 767366516,
 4627,
 -53824,
 767417648,
 4631,
 -53823,
 767544906,
 4625,
 -53822,
 767594895,
 4630,
 -1,
 767648127,
 4626,
 767831493,
 767201679,
 4614,
 -1,
 767759732,
 4615,
 767962567,
 767770759,
 4613,
 -1,
 767901831,
 4612,
 768093641,
 767890804,
 4608,
 -1,
 768021876,
 4611,
 -53814,
 768069194,
 4609,
 -1,
 768172415,
 4610,
 768355802,
 767131621,
 -1,
 768421329,
 768335112,
 -1,
 768486863,
 768360583,
 4995,
 -1,
 768426119,
 4994,
 -53808,
 768434559,
 4993,
 -1,
 768546164,
 4639,
 768749011,
 768381327,
 4638,
 -1,
 768677236,
 11649,
 768880085,
 768688263,
 4637,
 -1,
 768819335,
 4636,
 769011159,
 768808308,
 4632,
 -1,
 768939380,
 4635,
 -53800,
 768992298,
 4953,
 -53799,
 769117770,
 4633,
 -1,
 769155455,
 4634,
 769338856,
 768298582,
 -1,
 769404384,
 769318152,
 -1,
 769469918,
 769343623,
 5003,
 -1,
 769409159,
 5002,
 -53793,
 769417599,
 5001,
 -1,
 769529204,
 4943,
 769732066,
 769343623,
 4941,
 -1,
 769671303,
 4940,
 769863140,
 769660276,
 4936,
 -1,
 769791348,
 4939,
 -53787,
 769844266,
 4954,
 -53786,
 769969738,
 4937,
 -53785,
 770019727,
 4942,
 -1,
 770072959,
 4938,
 770256374,
 769271414,
 -1,
 770321902,
 770235656,
 -1,
 770387436,
 770261127,
 4999,
 -1,
 770326663,
 4998,
 -53779,
 770335103,
 4997,
 -1,
 770446708,
 4711,
 770649584,
 770281871,
 4710,
 -1,
 770577780,
 11653,
 770780658,
 770588807,
 4709,
 -1,
 770719879,
 4708,
 770911732,
 770708852,
 4704,
 -1,
 770839924,
 4707,
 -53771,
 770887242,
 4705,
 -1,
 770990463,
 4706,
 771173889,
 770222420,
 -1,
 771239417,
 771133839,
 4654,
 -1,
 771167604,
 11650,
 771370491,
 771178631,
 4653,
 -1,
 771309703,
 4652,
 771501565,
 771298676,
 4648,
 -1,
 771429748,
 4651,
 -53762,
 771482666,
 4952,
 -53761,
 771611952,
 4655,
 -53760,
 771673674,
 4649,
 -1,
 771711359,
 4650,
 771894795,
 771126104,
 -1,
 771960324,
 771854735,
 4622,
 -1,
 771888500,
 11648,
 772091398,
 771899527,
 4621,
 -1,
 772030599,
 4620,
 772222472,
 772019572,
 4616,
 -1,
 772150644,
 4619,
 -53751,
 772201776,
 4623,
 -53750,
 772329034,
 4617,
 -1,
 772366719,
 4618,
 772550165,
 771845929,
 -1,
 772615694,
 772510095,
 4870,
 -1,
 772543860,
 11662,
 772746768,
 772554887,
 4869,
 -1,
 772685959,
 4868,
 772877842,
 772674932,
 4864,
 -1,
 772806004,
 4867,
 -53741,
 772857136,
 4871,
 -53740,
 772984394,
 4865,
 -1,
 773022079,
 4866,
 773205534,
 772531182,
 -1,
 773271064,
 773165455,
 4846,
 -1,
 773199220,
 4847,
 773402138,
 773210247,
 4845,
 -1,
 773341319,
 4844,
 773533212,
 773330292,
 4840,
 -1,
 773461364,
 4843,
 -53731,
 773508682,
 4841,
 -1,
 773611903,
 4842,
 773795367,
 773184776,
 -1,
 773860897,
 773755279,
 4814,
 -1,
 773789044,
 4815,
 773991971,
 773800071,
 4813,
 -1,
 773931143,
 4812,
 774123045,
 773920116,
 4808,
 -1,
 774051188,
 4811,
 -53722,
 774098506,
 4809,
 -1,
 774201727,
 4810,
 774438911,
 773773230,
 -1,
 774450730,
 774324359,
 4717,
 -1,
 774389895,
 4716,
 774581804,
 774378868,
 4712,
 -1,
 774509940,
 4715,
 -53715,
 774561072,
 4719,
 -53714,
 774688330,
 4713,
 -53713,
 774738319,
 4718,
 -1,
 774791551,
 4714,
 775028735,
 743522439,
 -1,
 -53710,
 774931614,
 4964,
 -1,
 774976813,
 4960,
 775171650,
 743477311,
 -1,
 775237177,
 775144148,
 -1,
 775302711,
 775177969,
 4978,
 -1,
 775228113,
 4988,
 -53704,
 775282271,
 4979,
 -1,
 775380427,
 4980,
 775564860,
 775206687,
 -1,
 -53701,
 775515927,
 4983,
 -1,
 775572691,
 4984,
 775761471,
 775507542,
 -1,
 -53698,
 775723505,
 4981,
 -1,
 775775365,
 4982,
 -53696,
 775720157,
 4986,
 -53695,
 775905559,
 4987,
 -1,
 775964027,
 4985,
 776154703,
 775145898,
 -1,
 776220231,
 776091168,
 -1,
 776285766,
 776161723,
 5009,
 -1,
 776212462,
 5016,
 -1,
 776234059,
 5012,
 776482378,
 776171656,
 -1,
 -53687,
 776459847,
 5017,
 -1,
 776488784,
 5013,
 -53685,
 776463840,
 5008,
 -53684,
 776649641,
 5011,
 -53683,
 776712588,
 5010,
 -53682,
 776756417,
 5015,
 -1,
 776810426,
 5014,
 777006684,
 776092056,
 -1,
 777072211,
 776979156,
 -1,
 -53678,
 777052559,
 4970,
 -1,
 777085014,
 4971,
 777268822,
 777041695,
 -1,
 -53675,
 777219822,
 4974,
 -1,
 777276546,
 4975,
 777465433,
 777211478,
 -1,
 -53672,
 777427952,
 4972,
 -1,
 777481847,
 4973,
 -53670,
 777426367,
 4969,
 -53669,
 777620668,
 4977,
 -1,
 777667895,
 4976,
 777858657,
 776942056,
 -1,
 777924192,
 777813989,
 -1,
 -53665,
 777879602,
 4963,
 -1,
 777922962,
 4959,
 -1,
 777878802,
 4965,
 778186340,
 777822185,
 -1,
 -53661,
 778153115,
 4966,
 -1,
 778182867,
 4968,
 -53659,
 778167000,
 4961,
 -53658,
 778348734,
 4967,
 -1,
 778392258,
 4962,
 778579592,
 743417793,
 -1,
 778645123,
 778508788,
 -1,
 778710650,
 778614561,
 -1,
 778776184,
 778681387,
 61,
 778895359,
 778698752,
 -1,
 778907252,
 778769780,
 -1,
 778972786,
 778840910,
 -1,
 -53649,
 778946585,
 10867,
 -53648,
 779006111,
 10609,
 -53647,
 779068553,
 10865,
 -1,
 779122761,
 11072,
 779354111,
 778930838,
 10723,
 -1,
 779226768,
 10724,
 779485183,
 778887026,
 -1,
 -53642,
 779406743,
 10871,
 -53641,
 779434811,
 10854,
 -1,
 779496518,
 10926,
 -53639,
 778755960,
 10862,
 -1,
 779629035,
 8789,
 779878399,
 778633216,
 -1,
 779890306,
 779798837,
 -1,
 779955841,
 779851769,
 -1,
 -53634,
 779927970,
 8927,
 -53633,
 779986435,
 8926,
 -53632,
 780040527,
 8924,
 -1,
 780097271,
 8925,
 -1,
 779889834,
 8797,
 -1,
 779820550,
 8917,
 780468223,
 778592639,
 -1,
 780480135,
 780392431,
 -1,
 -53626,
 780460035,
 10872,
 -1,
 780519730,
 8781,
 -1,
 780410584,
 8794,
 780742300,
 778560260,
 -1,
 780807831,
 780715329,
 -1,
 780873357,
 780780244,
 -1,
 -53620,
 780853647,
 1778,
 -1,
 780886102,
 1779,
 781069968,
 780842783,
 -1,
 -53617,
 781020910,
 1782,
 -1,
 781077634,
 1783,
 781266579,
 781012566,
 -1,
 -53614,
 781229040,
 1780,
 -1,
 781282935,
 1781,
 -53612,
 781248405,
 1776,
 -53611,
 781424063,
 1777,
 -53610,
 781487292,
 1785,
 -1,
 781534519,
 1784,
 781778943,
 780741854,
 -1,
 781790875,
 781677776,
 -1,
 -53606,
 781756606,
 8265,
 -1,
 781812314,
 33,
 -1,
 781732557,
 8761,
 782053036,
 780695122,
 -1,
 782118569,
 782009376,
 8712,
 782237695,
 782041088,
 -1,
 782249638,
 782163826,
 -1,
 -53599,
 782228087,
 8947,
 -53598,
 782291543,
 8952,
 -53597,
 782355897,
 8953,
 -53596,
 782409386,
 8950,
 -53595,
 782466374,
 8946,
 -1,
 782514993,
 8949,
 782761983,
 782210922,
 -1,
 -53592,
 782685481,
 10194,
 -1,
 782712624,
 10969,
 782958591,
 782054745,
 -1,
 -53589,
 782834178,
 9191,
 -1,
 782893546,
 8961,
 783101625,
 782008293,
 -1,
 783167157,
 783065065,
 -1,
 783232692,
 783142444,
 8709,
 783351807,
 783158307,
 -1,
 -53583,
 783269359,
 10674,
 -53582,
 783330999,
 10675,
 -53581,
 783392426,
 10673,
 -1,
 783447727,
 10676,
 -1,
 783178490,
 9091,
 783745023,
 783089664,
 -1,
 -53577,
 783662829,
 8195,
 -53576,
 783722440,
 8193,
 -1,
 783759113,
 8212,
 783953606,
 783067476,
 -1,
 784019139,
 783922280,
 -1,
 784084671,
 783998639,
 -1,
 -53571,
 784056151,
 10734,
 -53570,
 784087341,
 10736,
 -1,
 784150594,
 10738,
 784400383,
 784017916,
 -1,
 -53567,
 784318295,
 10735,
 -53566,
 784349485,
 10737,
 -1,
 784412738,
 10739,
 784662527,
 783950650,
 -1,
 -53563,
 784576097,
 8998,
 -1,
 784627333,
 9003,
 784805585,
 783901923,
 -1,
 784871120,
 784728064,
 -1,
 784936654,
 784834537,
 -1,
 785002189,
 784896957,
 -1,
 -53557,
 784968750,
 10039,
 -53556,
 785032140,
 10037,
 -1,
 785066580,
 10036,
 -1,
 784944022,
 10049,
 -53553,
 784909483,
 10058,
 -1,
 785301311,
 10035,
 -1,
 784816272,
 9834,
 785526489,
 784763103,
 -1,
 785592022,
 785448960,
 -1,
 -53548,
 785563373,
 8194,
 -53547,
 785622984,
 8192,
 -1,
 785659657,
 8211,
 -53545,
 785570162,
 9993,
 -53544,
 785827195,
 9094,
 -1,
 785856070,
 8718,
 786050782,
 785501770,
 -1,
 786116317,
 786019284,
 -1,
 -53540,
 786042696,
 8352,
 -1,
 786106917,
 8364,
 -1,
 786069817,
 8455,
 786378466,
 785978740,
 -1,
 786444001,
 786347586,
 9793,
 -1,
 786367517,
 9178,
 -1,
 786415646,
 9841,
 786640613,
 786350249,
 -1,
 -53532,
 786609951,
 8793,
 -1,
 786642532,
 8494,
 -53530,
 786591595,
 9167,
 -1,
 786774604,
 11790,
 786970310,
 665326964,
 -1,
 787035527,
 786934100,
 -1,
 787100930,
 786962003,
 -1,
 787166446,
 787021824,
 -1,
 787231860,
 787116888,
 -1,
 787296756,
 787178655,
 -1,
 787361669,
 787265311,
 -1,
 787427121,
 787306635,
 -1,
 787492642,
 787366736,
 -1,
 787558143,
 787437707,
 -1,
 787623676,
 787486970,
 -1,
 787689207,
 787603314,
 -1,
 787754742,
 787645324,
 -1,
 -53515,
 787704165,
 64872,
 -1,
 787763257,
 64871,
 -1,
 787735781,
 64938,
 788016890,
 787636607,
 -1,
 -53511,
 787988108,
 64778,
 -1,
 788040981,
 64814,
 -53509,
 787972972,
 64824,
 -1,
 788156473,
 64806,
 788398079,
 787563732,
 -1,
 -53506,
 788300652,
 64746,
 -1,
 788359525,
 64818,
 788541196,
 787514252,
 -1,
 788606727,
 788520818,
 -1,
 788672260,
 788562828,
 -1,
 -53501,
 788621669,
 64877,
 -1,
 788680761,
 64876,
 788922367,
 788623879,
 -1,
 -53498,
 788818277,
 64875,
 -1,
 788877369,
 64874,
 789065482,
 788554111,
 -1,
 -53495,
 789036684,
 64780,
 -1,
 789089557,
 64816,
 -53493,
 789021548,
 64745,
 -1,
 789205049,
 64808,
 789393171,
 788492168,
 -1,
 789458704,
 789340543,
 -1,
 -53489,
 789429900,
 64777,
 -1,
 789482773,
 64813,
 -53487,
 789438772,
 64873,
 -53486,
 789611372,
 64823,
 -1,
 789663801,
 64805,
 789851929,
 789344775,
 -1,
 789917463,
 789799295,
 -1,
 -53482,
 789888652,
 64779,
 -1,
 789941525,
 64815,
 -53480,
 789873516,
 64825,
 -1,
 790057017,
 64807,
 790245148,
 789832918,
 -1,
 -53477,
 790195532,
 64766,
 -1,
 790253625,
 64794,
 790441759,
 790211756,
 -1,
 -53474,
 790392140,
 64781,
 -1,
 790450233,
 64809,
 790691839,
 790371015,
 -1,
 -53471,
 790588748,
 64765,
 -1,
 790646841,
 64793,
 790888447,
 787421169,
 -1,
 790900520,
 790786371,
 -1,
 790966055,
 790822912,
 -1,
 -53466,
 790922092,
 64756,
 -1,
 790981964,
 64610,
 -1,
 790938628,
 64607,
 791228205,
 790836964,
 -1,
 791293740,
 791150592,
 -1,
 -53461,
 791249772,
 64755,
 -1,
 791309644,
 64609,
 -1,
 791266308,
 64606,
 791555888,
 791170839,
 -1,
 -53457,
 791511916,
 64754,
 -1,
 791571788,
 64608,
 -1,
 791527914,
 64611,
 791818082,
 787366736,
 -1,
 791883583,
 791774092,
 -1,
 791949115,
 791863154,
 -1,
 792014647,
 791905164,
 -1,
 -53450,
 791964005,
 64867,
 -1,
 792023097,
 64866,
 792211258,
 791959843,
 -1,
 -53447,
 792160613,
 64864,
 -1,
 792219705,
 64863,
 -1,
 792162197,
 64865,
 792473406,
 791896447,
 -1,
 -53443,
 792444556,
 64543,
 -1,
 792497429,
 64688,
 -1,
 792429420,
 64743,
 792735561,
 791828619,
 -1,
 792801094,
 792664314,
 -1,
 792866628,
 792748415,
 -1,
 -53437,
 792837772,
 64541,
 -1,
 792890645,
 64686,
 -53435,
 792846424,
 64860,
 -1,
 793019244,
 64821,
 793247743,
 792741076,
 -1,
 -53432,
 793150316,
 64744,
 -1,
 793209189,
 64817,
 793390929,
 792687111,
 -1,
 793456461,
 793370482,
 -1,
 -53428,
 793437413,
 64966,
 -1,
 793451221,
 64936,
 793653072,
 793403775,
 -1,
 -53425,
 793624204,
 64542,
 -1,
 793677077,
 64687,
 -1,
 793609068,
 64822,
 793915225,
 793341832,
 -1,
 793980757,
 793894770,
 -1,
 -53420,
 793925934,
 64861,
 -1,
 793975509,
 64862,
 794177368,
 793928063,
 -1,
 -53417,
 794148492,
 64540,
 -1,
 794201365,
 64685,
 -1,
 794133356,
 64820,
 794439516,
 793896150,
 -1,
 -53413,
 794389836,
 64764,
 -1,
 794447929,
 64792,
 794636127,
 794406060,
 -1,
 -53410,
 794586444,
 64782,
 -1,
 794644537,
 64810,
 794886143,
 794565319,
 -1,
 -53407,
 794783052,
 64763,
 -1,
 794841145,
 64791,
 795082751,
 791745908,
 -1,
 795094910,
 794965613,
 -1,
 795160429,
 795040035,
 -1,
 795225962,
 795139954,
 -1,
 795291497,
 795171107,
 -1,
 -53400,
 795240805,
 64869,
 -1,
 795299897,
 64868,
 -1,
 795272421,
 64937,
 795607039,
 795173247,
 -1,
 -53396,
 795524748,
 64544,
 -1,
 795577621,
 64689,
 795750260,
 795116428,
 -1,
 795815793,
 795730031,
 -1,
 -53392,
 795765093,
 64965,
 -1,
 795824185,
 64870,
 796065791,
 795763071,
 -1,
 -53389,
 795983500,
 64545,
 -1,
 796036373,
 64691,
 796209015,
 795731158,
 -1,
 -53386,
 796159308,
 64774,
 -1,
 796217401,
 64802,
 796405626,
 796175532,
 -1,
 -53383,
 796355916,
 64783,
 -1,
 796414009,
 64811,
 796602237,
 796334791,
 -1,
 -53380,
 796552524,
 64773,
 -1,
 796610617,
 64801,
 -1,
 796553748,
 64690,
 796917759,
 795046744,
 -1,
 796929924,
 796816301,
 -1,
 796995459,
 796852224,
 -1,
 -53374,
 796972663,
 65008,
 -1,
 797011276,
 65017,
 -1,
 796949559,
 65018,
 -1,
 796859506,
 65013,
 797323234,
 787333844,
 -1,
 797388729,
 797263080,
 -1,
 797454227,
 797344652,
 -1,
 797519758,
 797433714,
 -1,
 -53366,
 797500645,
 64931,
 -53365,
 797536788,
 64855,
 -53364,
 797601685,
 64853,
 -53363,
 797661486,
 64854,
 -1,
 797711061,
 64932,
 797912977,
 797467007,
 -1,
 -53360,
 797884044,
 64526,
 -1,
 797936917,
 64676,
 -53358,
 797868908,
 64739,
 -1,
 798052409,
 64626,
 798240672,
 797399179,
 -1,
 798306205,
 798169338,
 -1,
 798371738,
 798285682,
 -1,
 798437273,
 798322568,
 -1,
 -53352,
 798386533,
 64850,
 -1,
 798445625,
 64849,
 -1,
 798393257,
 64851,
 798752767,
 798318975,
 -1,
 -53348,
 798670476,
 64524,
 -1,
 798723349,
 64674,
 798949375,
 798246100,
 -1,
 -53345,
 798851948,
 64740,
 -1,
 798910821,
 64677,
 799092648,
 798192135,
 -1,
 799158181,
 799072114,
 -1,
 -53341,
 799139045,
 64929,
 -53340,
 799179689,
 64852,
 -1,
 799218389,
 64930,
 799473663,
 799105407,
 -1,
 -53337,
 799391372,
 64525,
 -1,
 799444245,
 64675,
 799616944,
 799043464,
 -1,
 799682477,
 799596402,
 -1,
 -53333,
 799663333,
 64927,
 -53332,
 799703977,
 64848,
 -1,
 799742677,
 64928,
 799997951,
 799629695,
 -1,
 -53329,
 799915660,
 64523,
 -1,
 799968533,
 64673,
 800141235,
 799597782,
 -1,
 -53326,
 800091468,
 64528,
 -1,
 800149561,
 64629,
 800337846,
 800070343,
 -1,
 -53323,
 800288076,
 64527,
 -1,
 800346169,
 64628,
 -53321,
 800319307,
 64625,
 -53320,
 800500913,
 64624,
 -1,
 800558526,
 64627,
 800731085,
 797333643,
 -1,
 800796620,
 800670952,
 -1,
 800862145,
 800752524,
 -1,
 800927679,
 800809343,
 -1,
 -53314,
 800898700,
 64530,
 -1,
 800951573,
 64678,
 -53312,
 800883564,
 64741,
 -1,
 801067065,
 64632,
 801255364,
 800842966,
 -1,
 -53309,
 801205580,
 64532,
 -1,
 801263673,
 64635,
 801451975,
 801184455,
 -1,
 -53306,
 801402188,
 64531,
 -1,
 801460281,
 64634,
 -53304,
 801433419,
 64631,
 -53303,
 801615025,
 64630,
 -53302,
 801672638,
 64633,
 -53301,
 801730471,
 64529,
 -1,
 801790986,
 64742,
 -1,
 800725547,
 64603,
 802095103,
 800659715,
 -1,
 802107353,
 801997708,
 -1,
 802172885,
 802086770,
 -1,
 802238419,
 802117923,
 -1,
 -53294,
 802187621,
 64882,
 -1,
 802246713,
 64881,
 -53292,
 802219237,
 64884,
 -1,
 802390953,
 64883,
 802566104,
 802120063,
 -1,
 -53289,
 802537100,
 64551,
 -1,
 802589973,
 64819,
 -1,
 802521964,
 64826,
 802828252,
 802088150,
 -1,
 -53285,
 802778444,
 64758,
 -1,
 802836537,
 64786,
 803024863,
 802773288,
 -1,
 -53282,
 802995852,
 64550,
 -1,
 803048725,
 64696,
 803274751,
 802953927,
 -1,
 -53279,
 803171660,
 64757,
 -1,
 803229753,
 64785,
 803418173,
 797304070,
 -1,
 803483681,
 803362955,
 -1,
 803549214,
 803411316,
 -1,
 803614745,
 803506383,
 -1,
 803680240,
 803542388,
 -1,
 803745773,
 803632768,
 -1,
 803811307,
 803700891,
 -1,
 -53270,
 803761484,
 64515,
 -1,
 803819577,
 64616,
 -53268,
 803761484,
 64490,
 -1,
 803950649,
 64491,
 804192255,
 803684489,
 -1,
 -53265,
 804089164,
 64492,
 -1,
 804147257,
 64493,
 804335607,
 803660782,
 -1,
 804401140,
 804310604,
 -1,
 -53261,
 804351308,
 64500,
 -1,
 804409401,
 64501,
 804651007,
 804340948,
 -1,
 -53258,
 804547916,
 64516,
 -1,
 804606009,
 64617,
 804794365,
 804291468,
 -1,
 804859899,
 804741503,
 -1,
 -53254,
 804830860,
 64514,
 -1,
 804883733,
 64666,
 -53252,
 804815724,
 64735,
 -1,
 804999225,
 64614,
 805187588,
 804739211,
 -1,
 805253121,
 805127380,
 -1,
 -53248,
 805208940,
 64736,
 -1,
 805267813,
 64667,
 805502975,
 805181694,
 -1,
 -53245,
 805420684,
 64513,
 -1,
 805473557,
 64664,
 805646345,
 805126281,
 -1,
 805711880,
 805593471,
 -1,
 -53241,
 805682828,
 64502,
 -1,
 805735701,
 64504,
 -1,
 805654585,
 64503,
 805974028,
 805625395,
 -1,
 -53237,
 805924172,
 64494,
 -1,
 805982265,
 64495,
 806170639,
 805949004,
 -1,
 -53234,
 806120780,
 64496,
 -1,
 806178873,
 64497,
 806367250,
 806130392,
 -1,
 -53231,
 806317388,
 64498,
 -1,
 806375481,
 64499,
 806563861,
 806317966,
 -1,
 -53228,
 806534796,
 64512,
 -1,
 806587669,
 64663,
 -53226,
 806545227,
 64613,
 -53225,
 806726833,
 64612,
 -53224,
 806784446,
 64615,
 -1,
 806842900,
 64665,
 807075839,
 803559565,
 -1,
 807088157,
 806969727,
 -1,
 -53220,
 807059084,
 64598,
 -1,
 807111957,
 64731,
 -1,
 807067956,
 64942,
 807403519,
 803488980,
 -1,
 -53216,
 807306092,
 64753,
 -1,
 807364965,
 64734,
 807546924,
 803439500,
 -1,
 807612455,
 807526258,
 -1,
 807677990,
 807568268,
 -1,
 -53211,
 807627109,
 64925,
 -1,
 807686201,
 64924,
 -1,
 807658725,
 64944,
 807940138,
 807559551,
 -1,
 -53207,
 807911052,
 64600,
 -1,
 807963925,
 64733,
 -53205,
 807895916,
 64752,
 -1,
 808079417,
 64659,
 808267825,
 807497608,
 -1,
 808333360,
 808214911,
 -1,
 -53201,
 808304268,
 64597,
 -1,
 808357141,
 64730,
 -1,
 808313140,
 64943,
 808595508,
 808248534,
 -1,
 -53197,
 808545612,
 64602,
 -1,
 808603705,
 64662,
 808792119,
 808546829,
 -1,
 -53194,
 808763020,
 64599,
 -1,
 808815893,
 64732,
 808988730,
 808721095,
 -1,
 -53191,
 808938828,
 64601,
 -1,
 808996921,
 64661,
 -53189,
 808970059,
 64658,
 -53188,
 809151665,
 64657,
 -1,
 809209278,
 64660,
 809382012,
 803370175,
 -1,
 809447503,
 809310902,
 -1,
 809513034,
 809426802,
 -1,
 809578567,
 809458182,
 -1,
 809644100,
 809511001,
 -1,
 -53181,
 809594188,
 65273,
 -1,
 809652281,
 65274,
 809893887,
 809571963,
 -1,
 -53178,
 809790796,
 65271,
 -1,
 809848889,
 65272,
 810090495,
 809533524,
 -1,
 -53175,
 809987404,
 65269,
 -1,
 810045497,
 65270,
 810233933,
 809468059,
 -1,
 -53172,
 810184012,
 64579,
 -1,
 810242105,
 64646,
 -53170,
 810184012,
 65275,
 -1,
 810373177,
 65276,
 810561626,
 809403276,
 -1,
 810627157,
 810540914,
 -1,
 810692692,
 810572067,
 -1,
 -53165,
 810641765,
 64904,
 -1,
 810700857,
 64903,
 -1,
 810673381,
 64941,
 810954840,
 810574207,
 -1,
 -53161,
 810925708,
 64578,
 -1,
 810978581,
 64716,
 -53159,
 810910572,
 64749,
 -1,
 811094073,
 64645,
 811282534,
 810512264,
 -1,
 811348067,
 811261810,
 -1,
 811413599,
 811303820,
 -1,
 -53154,
 811362661,
 64954,
 -1,
 811421753,
 64956,
 811610210,
 811364232,
 -1,
 -53151,
 811559269,
 64899,
 -1,
 811618361,
 64900,
 -1,
 811590885,
 64940,
 811925503,
 811295103,
 -1,
 -53147,
 811843212,
 64575,
 -1,
 811896085,
 64713,
 812068978,
 811227275,
 -1,
 812134513,
 811997434,
 -1,
 812200046,
 812113778,
 -1,
 812265580,
 812155788,
 -1,
 -53141,
 812214629,
 64949,
 -1,
 812273721,
 64896,
 -53139,
 812246245,
 64897,
 -1,
 812391125,
 64898,
 812646399,
 812147071,
 -1,
 -53136,
 812564108,
 64576,
 -1,
 812616981,
 64714,
 -1,
 812074200,
 64717,
 812855417,
 812020231,
 -1,
 812920950,
 812834927,
 -1,
 -53131,
 812869989,
 64902,
 -1,
 812929081,
 64901,
 813170687,
 812867967,
 -1,
 -53128,
 813088396,
 64577,
 -1,
 813141269,
 64715,
 813367295,
 812836054,
 -1,
 -53125,
 813264204,
 64580,
 -1,
 813322297,
 64647,
 813510831,
 809332872,
 -1,
 813576353,
 813439114,
 -1,
 813641865,
 813532044,
 -1,
 813707396,
 813621106,
 -1,
 813772931,
 813663116,
 -1,
 -53118,
 813721957,
 64963,
 -1,
 813781049,
 64955,
 -1,
 813753573,
 64951,
 814035079,
 813654399,
 -1,
 -53114,
 814005900,
 64572,
 -1,
 814058773,
 64712,
 -53112,
 813990764,
 64748,
 -1,
 814174265,
 64642,
 814362767,
 813593786,
 -1,
 814428301,
 814309759,
 -1,
 -53108,
 814399116,
 64571,
 -1,
 814451989,
 64711,
 -53106,
 814383980,
 64747,
 -1,
 814567481,
 64641,
 814755989,
 814291638,
 -1,
 814821523,
 814710939,
 -1,
 -53102,
 814771532,
 64573,
 -1,
 814829625,
 64643,
 -53100,
 814771532,
 64567,
 -1,
 814960697,
 64640,
 815149208,
 814736598,
 -1,
 -53097,
 815099212,
 64574,
 -1,
 815157305,
 64644,
 815345819,
 815100429,
 -1,
 -53094,
 815316620,
 64570,
 -1,
 815369493,
 64710,
 815542430,
 815296398,
 -1,
 -53091,
 815513228,
 64568,
 -1,
 815566101,
 64708,
 815792127,
 815487272,
 -1,
 -53088,
 815709836,
 64569,
 -1,
 815762709,
 64709,
 815988735,
 813521233,
 -1,
 816001189,
 815916246,
 -1,
 -53084,
 815951180,
 64772,
 -1,
 816009273,
 64800,
 816197800,
 815956898,
 -1,
 -53081,
 816168588,
 64539,
 -1,
 816221461,
 64684,
 816394411,
 816148366,
 -1,
 -53078,
 816365196,
 64537,
 -1,
 816418069,
 64683,
 816591022,
 816323271,
 -1,
 -53075,
 816541004,
 64771,
 -1,
 816599097,
 64799,
 -1,
 816535871,
 64538,
 816853214,
 813469134,
 -1,
 816918717,
 816803720,
 -1,
 816984250,
 816897906,
 -1,
 817049781,
 816939916,
 -1,
 -53068,
 816998757,
 64920,
 -1,
 817057849,
 64919,
 817246392,
 816994595,
 -1,
 -53065,
 817195365,
 64952,
 -1,
 817254457,
 64957,
 -53063,
 817226981,
 64967,
 -1,
 817371861,
 64921,
 817627135,
 816931199,
 -1,
 -53060,
 817544844,
 64587,
 -1,
 817597717,
 64722,
 817770697,
 816863371,
 -1,
 817836230,
 817699066,
 -1,
 817901763,
 817815410,
 -1,
 -53055,
 817882341,
 64947,
 -53054,
 817922985,
 64917,
 -1,
 817961685,
 64918,
 818216959,
 817848703,
 -1,
 -53051,
 818134668,
 64588,
 -1,
 818187541,
 64723,
 818413567,
 817775828,
 -1,
 -53048,
 818316140,
 64751,
 -1,
 818375013,
 64726,
 818557138,
 817726348,
 -1,
 818622669,
 818536306,
 -1,
 -53044,
 818603237,
 64922,
 -1,
 818617045,
 64923,
 818819280,
 818569599,
 -1,
 -53041,
 818790028,
 64590,
 -1,
 818842901,
 64725,
 -53039,
 818774892,
 64750,
 -1,
 818958393,
 64652,
 819146965,
 818537686,
 -1,
 -53036,
 819096908,
 64592,
 -1,
 819155001,
 64655,
 819343576,
 819098125,
 -1,
 -53033,
 819314316,
 64589,
 -1,
 819367189,
 64724,
 819540187,
 819272391,
 -1,
 -53030,
 819490124,
 64591,
 -1,
 819548217,
 64654,
 -53028,
 819521355,
 64651,
 -53027,
 819702961,
 64650,
 -1,
 819760574,
 64653,
 819933444,
 816807909,
 -1,
 819998979,
 819872578,
 -1,
 820064489,
 819949448,
 -1,
 820130022,
 820043634,
 -1,
 -53021,
 820110565,
 64960,
 -53020,
 820151209,
 64909,
 -53019,
 820212244,
 64914,
 -1,
 820271406,
 64908,
 820510719,
 820076927,
 -1,
 -53016,
 820428428,
 64581,
 -1,
 820481301,
 64718,
 820654321,
 820015623,
 -1,
 820719854,
 820633458,
 -1,
 -53012,
 820700389,
 64953,
 -53011,
 820741033,
 64911,
 -1,
 820801429,
 64910,
 821035007,
 820666751,
 -1,
 -53008,
 820952716,
 64583,
 -1,
 821005589,
 64720,
 821178617,
 820599075,
 -1,
 821244150,
 821157746,
 -1,
 -53004,
 821224677,
 64907,
 -53003,
 821265321,
 64906,
 -1,
 821325717,
 64905,
 821559295,
 821191039,
 -1,
 -53000,
 821477004,
 64582,
 -1,
 821529877,
 64719,
 821702911,
 821134220,
 -1,
 821768445,
 821649791,
 -1,
 -52996,
 821739148,
 64584,
 -1,
 821792021,
 64721,
 -52994,
 821748020,
 64945,
 -1,
 821907513,
 64649,
 822096130,
 821631670,
 -1,
 -52991,
 822050980,
 64585,
 -1,
 822104121,
 64648,
 -1,
 822076660,
 64586,
 -1,
 819958630,
 65012,
 822423847,
 819865206,
 -1,
 822489382,
 822363368,
 -1,
 822554895,
 822433931,
 -1,
 822620428,
 822483194,
 -1,
 822685963,
 822567295,
 -1,
 -52982,
 822656652,
 64518,
 -1,
 822709525,
 64669,
 -1,
 822665524,
 64962,
 823001087,
 822559956,
 -1,
 -52978,
 822903660,
 64738,
 -1,
 822962533,
 64672,
 823144725,
 822510476,
 -1,
 823210259,
 823091583,
 -1,
 -52974,
 823180940,
 64520,
 -1,
 823233813,
 64671,
 -52972,
 823165804,
 64737,
 -1,
 823349305,
 64620,
 823537946,
 823095815,
 -1,
 823603481,
 823484799,
 -1,
 -52968,
 823574156,
 64519,
 -1,
 823627029,
 64670,
 -1,
 823583028,
 64926,
 823865629,
 823518422,
 -1,
 -52964,
 823815500,
 64522,
 -1,
 823873593,
 64623,
 824062240,
 823816078,
 -1,
 -52961,
 824032908,
 64517,
 -1,
 824085781,
 64668,
 824258851,
 823990983,
 -1,
 -52958,
 824208716,
 64521,
 -1,
 824266809,
 64622,
 -52956,
 824239947,
 64619,
 -52955,
 824421553,
 64618,
 -1,
 824479166,
 64621,
 -1,
 822439215,
 65021,
 824717643,
 822351220,
 -1,
 824783168,
 824666036,
 -1,
 824848691,
 824738700,
 -1,
 824914224,
 824827762,
 -1,
 824979758,
 824869772,
 -1,
 -52947,
 824928613,
 64887,
 -1,
 824987705,
 64886,
 -52945,
 824960229,
 64950,
 -1,
 825105109,
 64888,
 825360383,
 824861055,
 -1,
 -52942,
 825278092,
 64554,
 -1,
 825330965,
 64699,
 825504058,
 824799112,
 -1,
 825569591,
 825483375,
 -1,
 -52938,
 825518437,
 64964,
 -1,
 825577529,
 64885,
 825819135,
 825516415,
 -1,
 -52935,
 825736844,
 64553,
 -1,
 825789717,
 64698,
 825962813,
 825484502,
 -1,
 -52932,
 825912652,
 64760,
 -1,
 825970745,
 64788,
 826212351,
 825891527,
 -1,
 -52929,
 826109260,
 64759,
 -1,
 826167353,
 64787,
 826356042,
 824734552,
 -1,
 826421576,
 826295173,
 -1,
 826487109,
 826400756,
 -1,
 -52924,
 826436940,
 64829,
 -1,
 826495033,
 64828,
 826736639,
 826441914,
 -1,
 -52921,
 826633548,
 64605,
 -1,
 826691641,
 64656,
 -52919,
 826373271,
 65010,
 -1,
 826811994,
 65015,
 -1,
 826306981,
 65011,
 827076973,
 824662155,
 -1,
 827142495,
 827005187,
 -1,
 827208020,
 827097996,
 -1,
 827273553,
 827187058,
 -1,
 -52912,
 827253989,
 64858,
 -1,
 827267797,
 64859,
 827523071,
 827220351,
 -1,
 -52909,
 827440780,
 64536,
 -1,
 827493653,
 64682,
 827666777,
 827158408,
 -1,
 827732312,
 827613567,
 -1,
 -52905,
 827702924,
 64535,
 -1,
 827755797,
 64681,
 -1,
 827711796,
 64959,
 827994460,
 827647190,
 -1,
 -52901,
 827944268,
 64768,
 -1,
 828002361,
 64796,
 828243967,
 827923143,
 -1,
 -52898,
 828140876,
 64767,
 -1,
 828198969,
 64795,
 828440575,
 827081960,
 -1,
 828453223,
 828343180,
 -1,
 828518756,
 828432242,
 -1,
 -52893,
 828474281,
 64916,
 -1,
 828534677,
 64915,
 828768255,
 828465535,
 -1,
 -52890,
 828685964,
 64594,
 -1,
 828738837,
 64728,
 828911978,
 828403598,
 -1,
 -52887,
 828882572,
 64593,
 -1,
 828935445,
 64727,
 -52885,
 828892404,
 64596,
 -52884,
 829080012,
 64729,
 -1,
 829102829,
 64595,
 829305227,
 827012769,
 -1,
 829370741,
 829256199,
 -1,
 829436274,
 829349999,
 -1,
 -52879,
 829385061,
 64880,
 -1,
 829444153,
 64879,
 829685759,
 829383039,
 -1,
 -52876,
 829603468,
 64548,
 -1,
 829656341,
 64694,
 829829500,
 829315363,
 -1,
 829895033,
 829808498,
 -1,
 -52872,
 829875429,
 64939,
 -1,
 829889237,
 64878,
 830144511,
 829841791,
 -1,
 -52869,
 830062220,
 64547,
 -1,
 830115093,
 64693,
 830288255,
 829809878,
 -1,
 -52866,
 830238028,
 64776,
 -1,
 830296121,
 64804,
 830484866,
 830254252,
 -1,
 -52863,
 830434636,
 64784,
 -1,
 830492729,
 64812,
 830681477,
 830440354,
 -1,
 -52860,
 830652044,
 64549,
 -1,
 830704917,
 64695,
 830878088,
 830631822,
 -1,
 -52857,
 830848652,
 64546,
 -1,
 830901525,
 64692,
 831127551,
 830806727,
 -1,
 -52854,
 831024460,
 64775,
 -1,
 831082553,
 64803,
 831271333,
 829255465,
 -1,
 831336868,
 831210306,
 -1,
 831402391,
 831292300,
 -1,
 831467924,
 831381362,
 -1,
 831533458,
 831412515,
 -1,
 -52847,
 831482213,
 64857,
 -1,
 831541305,
 64856,
 -52845,
 831513829,
 64933,
 -1,
 831658709,
 64935,
 831913983,
 831414655,
 -1,
 -52842,
 831831692,
 64534,
 -1,
 831884565,
 64680,
 832057758,
 831346979,
 -1,
 832123291,
 832036722,
 -1,
 -52838,
 832103653,
 64958,
 -1,
 832117461,
 64934,
 832372735,
 832070015,
 -1,
 -52835,
 832290444,
 64533,
 -1,
 832343317,
 64679,
 832516513,
 832038102,
 -1,
 -52832,
 832466252,
 64770,
 -1,
 832524345,
 64798,
 832765951,
 832445127,
 -1,
 -52829,
 832662860,
 64769,
 -1,
 832720953,
 64797,
 -1,
 831265750,
 65019,
 832975294,
 831213426,
 -1,
 833040813,
 832926215,
 -1,
 833106346,
 833020015,
 -1,
 -52823,
 833055077,
 64893,
 -1,
 833114169,
 64892,
 833355775,
 833053055,
 -1,
 -52820,
 833273484,
 64559,
 -1,
 833326357,
 64704,
 833499570,
 832996236,
 -1,
 833565105,
 833446271,
 -1,
 -52816,
 833535628,
 64560,
 -1,
 833588501,
 64705,
 -1,
 833544500,
 64961,
 833827253,
 833479894,
 -1,
 -52812,
 833776972,
 64562,
 -1,
 833835065,
 64637,
 834023864,
 833777550,
 -1,
 -52809,
 833994380,
 64557,
 -1,
 834047253,
 64702,
 834220475,
 833968424,
 -1,
 -52806,
 834190988,
 64558,
 -1,
 834243861,
 64703,
 834469887,
 834149063,
 -1,
 -52803,
 834366796,
 64561,
 -1,
 834424889,
 64636,
 834613716,
 832939850,
 -1,
 834679251,
 834555561,
 -1,
 834744778,
 834634636,
 -1,
 834810311,
 834723698,
 -1,
 834875845,
 834754851,
 -1,
 -52796,
 834824549,
 64948,
 -1,
 834883641,
 64894,
 -52794,
 834856165,
 64946,
 -1,
 835027858,
 64895,
 835256319,
 834756991,
 -1,
 -52791,
 835174028,
 64564,
 -1,
 835226901,
 64707,
 835400141,
 834725078,
 -1,
 -52788,
 835349836,
 64566,
 -1,
 835407929,
 64639,
 835596752,
 835344680,
 -1,
 -52785,
 835567244,
 64563,
 -1,
 835620117,
 64706,
 835846143,
 835525319,
 -1,
 -52782,
 835743052,
 64565,
 -1,
 835801145,
 64638,
 -1,
 834630585,
 65009,
 836055526,
 834557122,
 -1,
 836121053,
 836010892,
 -1,
 836186586,
 836099954,
 -1,
 -52776,
 836166885,
 64890,
 -52775,
 836207506,
 64889,
 -1,
 836246229,
 64891,
 836501503,
 836133247,
 -1,
 -52772,
 836419212,
 64556,
 -1,
 836472085,
 64701,
 836645344,
 836101334,
 -1,
 -52769,
 836595020,
 64762,
 -1,
 836653113,
 64790,
 836841955,
 836595598,
 -1,
 -52766,
 836812428,
 64555,
 -1,
 836865301,
 64700,
 837091327,
 836770503,
 -1,
 -52763,
 836988236,
 64761,
 -1,
 837046329,
 64789,
 837235179,
 836036403,
 -1,
 837300714,
 837181823,
 -1,
 -52759,
 837271180,
 64552,
 -1,
 837324053,
 64697,
 -1,
 837256044,
 64827,
 837562864,
 837210201,
 -1,
 837628399,
 837509503,
 -1,
 -52754,
 837598860,
 64505,
 -1,
 837651733,
 64507,
 -1,
 837570617,
 64506,
 837890547,
 837527892,
 -1,
 -52750,
 837829873,
 64604,
 -1,
 837886927,
 65014,
 -1,
 837869006,
 65016,
 838205439,
 787237939,
 -1,
 838218302,
 838124244,
 -1,
 838283789,
 838157521,
 1578,
 838349318,
 838205440,
 -1,
 838414847,
 838303717,
 -1,
 838480382,
 838344982,
 1577,
 838598655,
 838402048,
 -1,
 -52740,
 838495564,
 65171,
 -52739,
 838555175,
 1731,
 -1,
 838619193,
 65172,
 -1,
 838419208,
 65176,
 838873602,
 838393714,
 -1,
 -52735,
 838846307,
 1661,
 -1,
 838906277,
 1660,
 839070213,
 838820223,
 -1,
 -52732,
 839040652,
 65173,
 -1,
 839093525,
 65175,
 -1,
 839012409,
 65174,
 839385087,
 838288593,
 1663,
 839450623,
 839254016,
 -1,
 839463435,
 839344511,
 -1,
 -52726,
 839433868,
 64354,
 -1,
 839486741,
 64356,
 -52724,
 839418732,
 64357,
 -1,
 839602233,
 64355,
 839791132,
 838217612,
 1670,
 839856661,
 839730385,
 1671,
 839974911,
 839778304,
 -1,
 839987731,
 839868799,
 -1,
 -52718,
 839958156,
 64382,
 -1,
 840011029,
 64384,
 -52716,
 839943020,
 64385,
 -1,
 840126521,
 64383,
 840368127,
 839778304,
 -1,
 840380953,
 840262015,
 -1,
 -52712,
 840351372,
 64378,
 -1,
 840404245,
 64380,
 -52710,
 840359878,
 1727,
 -52709,
 840532844,
 64381,
 -1,
 840585273,
 64379,
 840774186,
 839763195,
 1657,
 840839716,
 840713425,
 1658,
 840957951,
 840761344,
 -1,
 840970786,
 840851839,
 -1,
 -52703,
 840941196,
 64350,
 -1,
 840994069,
 64352,
 -52701,
 840926060,
 64353,
 -1,
 841109561,
 64351,
 841351167,
 840761344,
 -1,
 841364008,
 841245055,
 -1,
 -52697,
 841334412,
 64358,
 -1,
 841387285,
 64360,
 -52695,
 841319276,
 64361,
 -1,
 841502777,
 64359,
 841691702,
 840718475,
 -1,
 841757234,
 841630929,
 1579,
 841875455,
 841678848,
 -1,
 841888304,
 841769343,
 -1,
 -52689,
 841858700,
 65177,
 -1,
 841911573,
 65179,
 -52687,
 841843564,
 65180,
 -1,
 842027065,
 65178,
 842268671,
 841685492,
 1584,
 842334207,
 842137600,
 -1,
 -52683,
 842231116,
 65195,
 -1,
 842289209,
 65196,
 842530815,
 841619703,
 1591,
 842596351,
 842399744,
 -1,
 842609211,
 842490239,
 -1,
 -52678,
 842579596,
 65217,
 -1,
 842632469,
 65219,
 -52676,
 842588395,
 1695,
 -52675,
 842761068,
 65220,
 -1,
 842813497,
 65218,
 843002489,
 838162571,
 -1,
 843067995,
 842941649,
 1607,
 843186175,
 842989568,
 -1,
 843199049,
 843077159,
 1729,
 843317247,
 843120640,
 -1,
 843330118,
 843211135,
 -1,
 -52667,
 843300492,
 64422,
 -1,
 843353365,
 64424,
 -52665,
 843309080,
 1730,
 -52664,
 843481964,
 64425,
 -1,
 843534393,
 64423,
 843723344,
 843135691,
 1726,
 843841535,
 843644928,
 -1,
 843854414,
 843735423,
 -1,
 -52659,
 843824780,
 64426,
 -1,
 843877653,
 64428,
 -52657,
 843809644,
 64429,
 -1,
 843993145,
 64427,
 844182102,
 843702130,
 -1,
 844247637,
 844162267,
 1728,
 844365823,
 844169216,
 -1,
 -52652,
 844262732,
 64420,
 -1,
 844320825,
 64421,
 -1,
 844196749,
 1791,
 844575321,
 844128639,
 -1,
 -52648,
 844545676,
 65257,
 -1,
 844598549,
 65259,
 -52646,
 844530540,
 65260,
 -1,
 844714041,
 65258,
 844903028,
 842995060,
 -1,
 844968562,
 844847243,
 1581,
 845086719,
 844890112,
 -1,
 845099629,
 845012850,
 -1,
 845165158,
 845071060,
 -1,
 845230691,
 845144479,
 -1,
 -52638,
 845208130,
 1666,
 -1,
 845223541,
 1879,
 845479935,
 845176962,
 -1,
 -52635,
 845391135,
 1880,
 -1,
 845420149,
 1669,
 845623915,
 845135251,
 -1,
 845689450,
 845550964,
 -1,
 -52631,
 845646546,
 1903,
 -1,
 845687625,
 1906,
 -1,
 845621331,
 1902,
 -52628,
 845568525,
 1665,
 -1,
 845893098,
 1916,
 846082672,
 845046143,
 -1,
 -52625,
 846053004,
 65185,
 -1,
 846105877,
 65187,
 -52623,
 846037868,
 65188,
 -1,
 846221369,
 65186,
 846462975,
 844925131,
 1569,
 -1,
 846333131,
 65152,
 846594047,
 844850393,
 1652,
 846659583,
 846462976,
 -1,
 -52617,
 846587090,
 1656,
 -52616,
 846650927,
 1654,
 -1,
 846666417,
 1653,
 846869166,
 842937888,
 -1,
 846934678,
 846796148,
 -1,
 847000202,
 846885720,
 1583,
 847118335,
 846921728,
 -1,
 847131272,
 847044466,
 -1,
 847196801,
 847102676,
 -1,
 -52608,
 847176218,
 1881,
 -1,
 847208605,
 1679,
 847393412,
 847145686,
 -1,
 -52605,
 847370158,
 1774,
 -1,
 847429196,
 1882,
 847590022,
 847330107,
 1674,
 -1,
 847511909,
 1675,
 -52601,
 847557029,
 1673,
 -1,
 847663623,
 1680,
 -52599,
 847080780,
 65193,
 -1,
 847794233,
 65194,
 847983250,
 846935584,
 1590,
 848101375,
 847904768,
 -1,
 848114319,
 847995263,
 -1,
 -52594,
 848084620,
 65213,
 -1,
 848137493,
 65215,
 -52592,
 848093141,
 1787,
 -52591,
 848266092,
 65216,
 -1,
 848318521,
 65214,
 848560127,
 847927673,
 1676,
 848625663,
 848429056,
 -1,
 -52587,
 848522572,
 64388,
 -1,
 848580665,
 64389,
 848769695,
 846870155,
 -1,
 848835227,
 848720728,
 1672,
 848953343,
 848756736,
 -1,
 -52582,
 848850252,
 64392,
 -1,
 848908345,
 64393,
 849149951,
 848779641,
 1677,
 849215487,
 849018880,
 -1,
 -52578,
 849112396,
 64386,
 -1,
 849170489,
 64387,
 849359526,
 848749778,
 1668,
 849477631,
 849281024,
 -1,
 849490596,
 849371519,
 -1,
 -52573,
 849460876,
 64370,
 -1,
 849513749,
 64372,
 -52571,
 849445740,
 64373,
 -1,
 849629241,
 64371,
 849818282,
 849334450,
 1678,
 849936383,
 849739776,
 -1,
 -52567,
 849833292,
 64390,
 -1,
 849891385,
 64391,
 850132991,
 849779423,
 -1,
 -52564,
 850044760,
 1647,
 -52563,
 850087790,
 1697,
 -1,
 850143289,
 1646,
 850342623,
 846796148,
 -1,
 850408144,
 850294396,
 1575,
 850526207,
 850329600,
 -1,
 850539210,
 850451720,
 -1,
 850604742,
 850488788,
 -1,
 850670268,
 850549254,
 -1,
 850735800,
 850602067,
 1573,
 850853887,
 850657280,
 -1,
 -52553,
 850750796,
 65159,
 -1,
 850808889,
 65160,
 851050495,
 850663029,
 1571,
 851116031,
 850919424,
 -1,
 -52549,
 851012940,
 65155,
 -1,
 851071033,
 65156,
 851260096,
 850624584,
 1570,
 851378175,
 851181568,
 -1,
 -52545,
 851275084,
 65153,
 -1,
 851333177,
 65154,
 851522243,
 851238407,
 -1,
 -52542,
 851454035,
 1651,
 -1,
 851514997,
 1650,
 851771391,
 851463697,
 -1,
 -52539,
 851698070,
 1907,
 -1,
 851730529,
 1908,
 851967999,
 850535370,
 1649,
 852033535,
 851836928,
 -1,
 -52535,
 851930444,
 64336,
 -1,
 851988537,
 64337,
 852177614,
 850493587,
 1609,
 852295679,
 852099072,
 -1,
 -52531,
 852192588,
 65263,
 -1,
 852250681,
 65264,
 -52529,
 852127052,
 65165,
 -1,
 852381753,
 65166,
 852570846,
 850356016,
 1593,
 852688895,
 852492288,
 -1,
 852701913,
 852615396,
 -1,
 852767446,
 852681119,
 -1,
 -52523,
 852745019,
 1887,
 -1,
 852760181,
 1885,
 853016575,
 852713602,
 -1,
 -52520,
 852927735,
 1886,
 -1,
 852956789,
 1696,
 853160668,
 852648319,
 -1,
 -52517,
 853130892,
 65225,
 -1,
 853183765,
 65227,
 -52515,
 853115756,
 65228,
 -1,
 853299257,
 65226,
 -1,
 852508807,
 1749,
 853553932,
 850292872,
 -1,
 853619439,
 853493016,
 1705,
 853737471,
 853540864,
 -1,
 853750506,
 853663602,
 -1,
 853816041,
 853721812,
 -1,
 853881576,
 853762178,
 -1,
 -52506,
 853845279,
 1892,
 -52505,
 853878867,
 1596,
 -1,
 853939829,
 1891,
 -1,
 853860776,
 1595,
 -1,
 853752625,
 1890,
 854274797,
 853696895,
 -1,
 -52500,
 854245004,
 64398,
 -1,
 854297877,
 64400,
 -52498,
 854229868,
 64401,
 -1,
 854413369,
 64399,
 854602492,
 853547143,
 1603,
 854720511,
 854523904,
 -1,
 854733559,
 854646642,
 -1,
 854799093,
 854704852,
 -1,
 -52492,
 854778280,
 1919,
 -1,
 854810807,
 1710,
 -52490,
 854765989,
 1707,
 -1,
 854932273,
 1708,
 855126778,
 854679935,
 -1,
 -52487,
 855096972,
 65241,
 -1,
 855149845,
 65243,
 -52485,
 855081836,
 65244,
 -1,
 855265337,
 65242,
 855454469,
 854551691,
 -1,
 855520001,
 855434967,
 1737,
 855638015,
 855441408,
 -1,
 -52480,
 855534924,
 64482,
 -1,
 855593017,
 64483,
 855834623,
 855478997,
 1733,
 855900159,
 855703552,
 -1,
 -52476,
 855797068,
 64480,
 -1,
 855855161,
 64481,
 856096767,
 855398687,
 1582,
 856162303,
 855965696,
 -1,
 856175370,
 856056191,
 -1,
 -52471,
 856145548,
 65189,
 -1,
 856198421,
 65191,
 -52469,
 856130412,
 65192,
 -1,
 856313913,
 65190,
 856503094,
 853510367,
 -1,
 856568609,
 856463017,
 1606,
 856686591,
 856489984,
 -1,
 856699672,
 856612722,
 -1,
 856765203,
 856670932,
 -1,
 -52462,
 856744374,
 1895,
 -1,
 856776845,
 1725,
 856961814,
 856735116,
 -1,
 -52459,
 856938414,
 1897,
 -1,
 856998767,
 1896,
 -52457,
 856928677,
 1724,
 -1,
 857094971,
 1721,
 857289500,
 856642917,
 1722,
 857407487,
 857210880,
 -1,
 -52453,
 857304396,
 64414,
 -1,
 857362489,
 64415,
 857551647,
 857235839,
 -1,
 -52450,
 857521804,
 65253,
 -1,
 857574677,
 65255,
 -52448,
 857506668,
 65256,
 -1,
 857690169,
 65254,
 857879343,
 856511203,
 1709,
 857944873,
 857838300,
 1713,
 858062847,
 857866240,
 -1,
 858075943,
 857956735,
 -1,
 -52442,
 858046092,
 64410,
 -1,
 858098965,
 64412,
 -52440,
 858030956,
 64413,
 -1,
 858214457,
 64411,
 858456063,
 857866240,
 -1,
 858469165,
 858349951,
 -1,
 -52436,
 858439308,
 64467,
 -1,
 858492181,
 64469,
 -52434,
 858424172,
 64470,
 -1,
 858607673,
 64468,
 858849279,
 857859282,
 1667,
 858914815,
 858718208,
 -1,
 858927924,
 858808703,
 -1,
 -52429,
 858898060,
 64374,
 -1,
 858950933,
 64376,
 -52427,
 858882924,
 64377,
 -1,
 859066425,
 64375,
 859255644,
 856471327,
 -1,
 859321160,
 859194188,
 1587,
 859439103,
 859242496,
 -1,
 859452227,
 859365234,
 -1,
 859517758,
 859423444,
 -1,
 859583293,
 859463863,
 1691,
 -1,
 859505041,
 1692,
 -1,
 859562497,
 1901,
 -52417,
 859487660,
 1904,
 -52416,
 859728781,
 1918,
 -52415,
 859787783,
 1884,
 -52414,
 859852227,
 1917,
 -1,
 859913029,
 1690,
 860107590,
 859398527,
 -1,
 -52411,
 860077708,
 65201,
 -1,
 860130581,
 65203,
 -52409,
 860062572,
 65204,
 -1,
 860246073,
 65202,
 860435282,
 859248598,
 1589,
 860553215,
 860356608,
 -1,
 860566349,
 860479716,
 -1,
 -52404,
 860545462,
 1693,
 -1,
 860577933,
 1694,
 860762960,
 860512639,
 -1,
 -52401,
 860733068,
 65209,
 -1,
 860785941,
 65211,
 -52399,
 860717932,
 65212,
 -1,
 860901433,
 65210,
 861090650,
 860380147,
 1588,
 861208575,
 861011968,
 -1,
 861221719,
 861102463,
 -1,
 -52394,
 861191820,
 65205,
 -1,
 861244693,
 65207,
 -52392,
 861200341,
 1786,
 -52391,
 861373292,
 65208,
 -1,
 861425721,
 65206,
 -52389,
 861068773,
 1706,
 -1,
 861590576,
 1648,
 861746048,
 859235310,
 -1,
 861811580,
 861684945,
 1610,
 861929471,
 861732864,
 -1,
 861942635,
 861855602,
 -1,
 862008167,
 861886989,
 1574,
 862126079,
 861929472,
 -1,
 862139237,
 862019967,
 -1,
 -52380,
 862109324,
 65161,
 -1,
 862162197,
 65163,
 -52378,
 862094188,
 65164,
 -1,
 862277689,
 65162,
 862466922,
 861979348,
 -1,
 -52375,
 862412983,
 1745,
 -1,
 862460222,
 1741,
 -1,
 862436918,
 1742,
 862729079,
 861874094,
 1746,
 862846975,
 862650368,
 -1,
 862860149,
 862773106,
 -1,
 862925682,
 862804493,
 1747,
 863043583,
 862846976,
 -1,
 -52367,
 862940492,
 64432,
 -1,
 862998585,
 64433,
 863240191,
 862866961,
 -1,
 -52364,
 863166870,
 1914,
 -1,
 863199329,
 1915,
 -52362,
 862809420,
 64430,
 -1,
 863326265,
 64431,
 863515514,
 862675327,
 -1,
 -52359,
 863485580,
 65265,
 -1,
 863538453,
 65267,
 -52357,
 863470444,
 65268,
 -1,
 863653945,
 65266,
 863895551,
 861785674,
 1736,
 863961087,
 863764480,
 -1,
 -52353,
 863857996,
 64475,
 -1,
 863916089,
 64476,
 864105376,
 861710676,
 -1,
 864170901,
 864044241,
 1585,
 864288767,
 864092160,
 -1,
 864301971,
 864214898,
 -1,
 864367498,
 864270111,
 -1,
 864433033,
 864321822,
 -1,
 864498568,
 864409518,
 1682,
 -1,
 864420387,
 1685,
 -1,
 864428205,
 1905,
 -1,
 864406484,
 1883,
 864760717,
 864341374,
 -1,
 -52340,
 864738107,
 1899,
 -1,
 864753269,
 1687,
 864957327,
 864697147,
 1684,
 -1,
 864878778,
 1686,
 -52336,
 864924069,
 1683,
 -52335,
 865037197,
 1775,
 -52334,
 865098253,
 1900,
 -1,
 865161735,
 1689,
 -52332,
 864251212,
 65197,
 -1,
 865292345,
 65198,
 865481628,
 864128441,
 1723,
 865599487,
 865402880,
 -1,
 865612698,
 865493375,
 -1,
 -52327,
 865582732,
 64416,
 -1,
 865635605,
 64418,
 -52325,
 865567596,
 64419,
 -1,
 865751097,
 64417,
 865992703,
 865447080,
 1681,
 866058239,
 865861632,
 -1,
 -52321,
 865955148,
 64396,
 -1,
 866013241,
 64397,
 866202560,
 864036887,
 -1,
 866268089,
 866146443,
 1576,
 866333618,
 866189312,
 -1,
 866399149,
 866312050,
 -1,
 866464682,
 866370260,
 -1,
 866530217,
 866410626,
 -1,
 866595752,
 866493727,
 1874,
 -1,
 866517415,
 1875,
 -1,
 866541470,
 1872,
 -1,
 866509252,
 1876,
 -52309,
 866434614,
 1878,
 -52308,
 866806632,
 1877,
 -1,
 866859869,
 1873,
 867054512,
 866345343,
 -1,
 -52305,
 867024524,
 65167,
 -1,
 867077397,
 65169,
 -52303,
 867009388,
 65170,
 -1,
 867192889,
 65168,
 867434495,
 866272465,
 1664,
 867500031,
 867303424,
 -1,
 867513271,
 867393919,
 -1,
 -52298,
 867483276,
 64346,
 -1,
 867536149,
 64348,
 -52296,
 867468140,
 64349,
 -1,
 867651641,
 64347,
 867893247,
 866206929,
 1659,
 867958783,
 867762176,
 -1,
 867972030,
 867852671,
 -1,
 -52291,
 867942028,
 64338,
 -1,
 867994901,
 64340,
 -52289,
 867926892,
 64341,
 -1,
 868110393,
 64339,
 868299746,
 866143830,
 -1,
 868365266,
 868229811,
 1740,
 868483071,
 868286464,
 -1,
 868496333,
 868409202,
 -1,
 868561865,
 868437414,
 -1,
 868627400,
 868532948,
 -1,
 -52281,
 868606358,
 1909,
 -1,
 868638817,
 1910,
 -1,
 868569586,
 1911,
 868889548,
 868532948,
 -1,
 -52277,
 868868520,
 1598,
 -1,
 868901005,
 1599,
 -1,
 868838285,
 1597,
 869151696,
 868442495,
 -1,
 -52273,
 869121676,
 64508,
 -1,
 869174549,
 64510,
 -52271,
 869106540,
 64511,
 -1,
 869290041,
 64509,
 869531647,
 868304081,
 1601,
 869597183,
 869400576,
 -1,
 869610461,
 869523314,
 -1,
 869675994,
 869581524,
 -1,
 869741529,
 869621890,
 -1,
 -52264,
 869704991,
 1889,
 -1,
 869738579,
 1701,
 -1,
 869720502,
 1888,
 870055935,
 869612332,
 -1,
 -52260,
 869959516,
 1698,
 -1,
 870000723,
 1699,
 870200288,
 869556607,
 -1,
 -52257,
 870170252,
 65233,
 -1,
 870223125,
 65235,
 -52255,
 870155116,
 65236,
 -1,
 870338617,
 65234,
 870527998,
 868242147,
 -1,
 870593519,
 870455431,
 1711,
 870711295,
 870514688,
 -1,
 870724586,
 870637426,
 -1,
 870790121,
 870695636,
 -1,
 -52248,
 870769078,
 1714,
 -1,
 870801549,
 1716,
 -1,
 870756773,
 1712,
 871052269,
 870670719,
 -1,
 -52244,
 871022220,
 64402,
 -1,
 871075093,
 64404,
 -52242,
 871007084,
 64405,
 -1,
 871190585,
 64403,
 871379959,
 870537563,
 1594,
 871497727,
 871301120,
 -1,
 871511028,
 871391615,
 -1,
 -52237,
 871480972,
 65229,
 -1,
 871533845,
 65231,
 -52235,
 871489493,
 1788,
 -52234,
 871662444,
 65232,
 -1,
 871714873,
 65230,
 871956479,
 871354385,
 1715,
 872022015,
 871825408,
 -1,
 872035324,
 871915903,
 -1,
 -52229,
 872005260,
 64406,
 -1,
 872058133,
 64408,
 -52227,
 871990124,
 64409,
 -1,
 872173625,
 64407,
 872363021,
 870506031,
 1608,
 872480767,
 872284160,
 -1,
 872494091,
 872406898,
 -1,
 872559621,
 872438285,
 1572,
 872677375,
 872480768,
 -1,
 -52220,
 872574284,
 65157,
 -1,
 872632377,
 65158,
 872821768,
 872500753,
 -1,
 -52217,
 872800662,
 1912,
 -1,
 872833121,
 1913,
 -52215,
 872795528,
 1738,
 -52214,
 872984997,
 1732,
 -1,
 873020209,
 1743,
 -52212,
 872443212,
 65261,
 -1,
 873156665,
 65262,
 873346075,
 872325624,
 1662,
 873411605,
 873284817,
 1702,
 873529343,
 873332736,
 -1,
 873542675,
 873423231,
 -1,
 -52206,
 873512588,
 64366,
 -1,
 873565461,
 64368,
 -52204,
 873497452,
 64369,
 -1,
 873680953,
 64367,
 873922559,
 873332736,
 -1,
 873935897,
 873816447,
 -1,
 -52200,
 873905804,
 64342,
 -1,
 873958677,
 64344,
 -52198,
 873890668,
 64345,
 -1,
 874074169,
 64343,
 874263593,
 873297078,
 1604,
 874381311,
 874184704,
 -1,
 874394660,
 874307442,
 -1,
 874460193,
 874366790,
 -1,
 -52192,
 874391635,
 1720,
 -1,
 874452597,
 1719,
 -52190,
 874430006,
 1717,
 -52189,
 874593073,
 1718,
 -1,
 874653518,
 1898,
 874853415,
 874340735,
 -1,
 -52186,
 874823308,
 65245,
 -1,
 874876181,
 65247,
 -52184,
 874808172,
 65248,
 -1,
 874991673,
 65246,
 875181109,
 874243888,
 -1,
 875246641,
 875124875,
 1592,
 875364351,
 875167744,
 -1,
 875377711,
 875258239,
 -1,
 -52178,
 875347596,
 65221,
 -1,
 875400469,
 65223,
 -52176,
 875332460,
 65224,
 -1,
 875515961,
 65222,
 875757567,
 875194160,
 1586,
 875823103,
 875626496,
 -1,
 -52172,
 875720012,
 65199,
 -1,
 875778105,
 65200,
 875967552,
 875157748,
 1739,
 876033085,
 875911307,
 1700,
 876150783,
 875954176,
 -1,
 876164155,
 876044671,
 -1,
 -52166,
 876134028,
 64362,
 -1,
 876186901,
 64364,
 -52164,
 876118892,
 64365,
 -1,
 876302393,
 64363,
 876543999,
 875954176,
 -1,
 -52161,
 876440908,
 64478,
 -1,
 876499001,
 64479,
 876688460,
 875917133,
 -1,
 876753992,
 876627530,
 1580,
 876871679,
 876675072,
 -1,
 876885062,
 876765567,
 -1,
 -52155,
 876854924,
 65181,
 -1,
 876907797,
 65183,
 -52153,
 876839788,
 65184,
 -1,
 877023289,
 65182,
 877264895,
 876697739,
 1688,
 877330431,
 877133824,
 -1,
 -52149,
 877227340,
 64394,
 -1,
 877285433,
 64395,
 877474901,
 876662346,
 1735,
 877540434,
 877395968,
 -1,
 877605968,
 877518872,
 1655,
 -1,
 877528267,
 64477,
 -52143,
 877555020,
 64471,
 -1,
 877678649,
 64472,
 877920255,
 877487434,
 -1,
 -52140,
 877822828,
 64489,
 -1,
 877881701,
 64488,
 878064735,
 877438808,
 1602,
 878182399,
 877985792,
 -1,
 878195802,
 878108530,
 -1,
 -52135,
 878167890,
 1704,
 -1,
 878197553,
 1703,
 878392413,
 878141823,
 -1,
 -52132,
 878362252,
 65237,
 -1,
 878415125,
 65239,
 -52130,
 878347116,
 65240,
 -1,
 878530617,
 65238,
 878720105,
 878019463,
 1605,
 878837759,
 878641152,
 -1,
 878851172,
 878763964,
 -1,
 -52125,
 878782547,
 1894,
 -1,
 878843509,
 1893,
 879047783,
 878797183,
 -1,
 -52122,
 879017612,
 65249,
 -1,
 879070485,
 65251,
 -52120,
 879002476,
 65252,
 -1,
 879185977,
 65250,
 879375472,
 878657671,
 1744,
 879493119,
 879296512,
 -1,
 879506542,
 879387007,
 -1,
 -52115,
 879476364,
 64484,
 -1,
 879529237,
 64486,
 -52113,
 879461228,
 64487,
 -1,
 879644729,
 64485,
 879886335,
 879334101,
 1734,
 879951871,
 879755264,
 -1,
 -52109,
 879848780,
 64473,
 -1,
 879906873,
 64474,
 880096432,
 787199775,
 -1,
 880161941,
 880050462,
 -1,
 880227469,
 880106735,
 -1,
 880292989,
 880178008,
 -1,
 880358524,
 880239775,
 -1,
 -52102,
 880326568,
 1750,
 -52101,
 880387932,
 1751,
 -1,
 880417544,
 1558,
 -1,
 880286826,
 1753,
 880686210,
 880246757,
 -1,
 880751745,
 880624444,
 -1,
 -52096,
 880721548,
 1762,
 -1,
 880774421,
 1752,
 -1,
 880678892,
 1764,
 881013893,
 880657108,
 -1,
 -52092,
 880959608,
 1755,
 -1,
 881006839,
 1557,
 -52090,
 880994118,
 1559,
 -52089,
 881190098,
 1767,
 -52088,
 881251536,
 1760,
 -52087,
 881309944,
 1756,
 -52086,
 881374465,
 1759,
 -52085,
 881429945,
 1768,
 -52084,
 881487747,
 1754,
 -1,
 881540007,
 1761,
 881734800,
 880180771,
 -1,
 -52081,
 881703160,
 1763,
 -1,
 881755015,
 1773,
 -52079,
 881714386,
 1766,
 -52078,
 881909295,
 1765,
 -52077,
 881946947,
 1562,
 -52076,
 882003729,
 1560,
 -1,
 882063076,
 1561,
 882259108,
 880108937,
 -1,
 882324638,
 882226975,
 -1,
 882390171,
 882251124,
 -1,
 -52071,
 882346348,
 1537,
 -52070,
 882408526,
 1552,
 -1,
 882462725,
 1539,
 882704383,
 882337814,
 -1,
 -52067,
 882615647,
 1790,
 -1,
 882646292,
 1789,
 882848929,
 882289071,
 -1,
 -52064,
 882794062,
 1554,
 -1,
 882849934,
 1555,
 -52062,
 882820001,
 1556,
 -52061,
 883000801,
 1551,
 -1,
 883038859,
 1553,
 883242154,
 882232906,
 -1,
 883307689,
 883192598,
 1618,
 883425279,
 883228672,
 -1,
 -52056,
 883327852,
 65151,
 -1,
 883387724,
 65150,
 -1,
 883239937,
 1622,
 883635374,
 883185869,
 1617,
 883752959,
 883556352,
 -1,
 -52051,
 883655532,
 65149,
 -1,
 883715404,
 65148,
 -52049,
 883606577,
 1758,
 -1,
 883836544,
 1563,
 884028603,
 880037462,
 -1,
 884094136,
 883958983,
 1614,
 884159670,
 884015104,
 -1,
 -52044,
 884138241,
 1630,
 -52043,
 884179820,
 65143,
 -1,
 884239692,
 65142,
 884473855,
 884130816,
 1611,
 -1,
 884344011,
 65136,
 -52039,
 884068634,
 1748,
 -52038,
 884512473,
 1538,
 -1,
 884567718,
 1645,
 884749509,
 883963424,
 -1,
 884815044,
 884675956,
 -1,
 884880579,
 884770295,
 1615,
 884946112,
 884851712,
 1612,
 -1,
 884868299,
 65138,
 885129215,
 884867072,
 -1,
 -52030,
 885031788,
 65145,
 -1,
 885091660,
 65144,
 -1,
 884851838,
 1549,
 -1,
 884752962,
 1643,
 885404876,
 884720340,
 -1,
 885470410,
 885331316,
 -1,
 885535945,
 885443932,
 1600,
 -1,
 885460306,
 65137,
 -1,
 885482976,
 65139,
 -52021,
 885436981,
 1566,
 -1,
 885678141,
 1644,
 885863634,
 885354819,
 1616,
 885929167,
 885834752,
 1613,
 -1,
 885851339,
 65140,
 886112255,
 885850112,
 -1,
 -52015,
 886014828,
 65147,
 -1,
 886074700,
 65146,
 886256854,
 885841078,
 -1,
 -52012,
 886226494,
 1626,
 -52011,
 886270801,
 1627,
 -1,
 886324027,
 1628,
 886519002,
 886221140,
 -1,
 -52008,
 886479820,
 1772,
 -52007,
 886525179,
 1629,
 -1,
 886580792,
 1544,
 886781150,
 886480873,
 -1,
 -52004,
 886739695,
 1550,
 -52003,
 886797313,
 1769,
 -1,
 886851990,
 1642,
 887043299,
 886718599,
 -1,
 887108834,
 886998937,
 -1,
 -51999,
 887062088,
 1770,
 -1,
 887119131,
 1771,
 -1,
 887065188,
 1757,
 887370982,
 886997042,
 -1,
 -51995,
 887337792,
 1624,
 -1,
 887371583,
 1619,
 887567593,
 887314950,
 -1,
 -51992,
 887498835,
 1621,
 -1,
 887559797,
 1620,
 -51990,
 887547992,
 1625,
 -51989,
 887728318,
 1567,
 -51988,
 887787591,
 1536,
 -51987,
 887843588,
 1623,
 -1,
 887894543,
 1548,
 888143871,
 787091504,
 -1,
 888157437,
 888027544,
 -1,
 888222963,
 888128212,
 -1,
 -51982,
 888201615,
 1634,
 -1,
 888234070,
 1635,
 888419574,
 888190751,
 -1,
 -51979,
 888368878,
 1638,
 -1,
 888425602,
 1639,
 888616185,
 888360534,
 -1,
 -51976,
 888577008,
 1636,
 -1,
 888630903,
 1637,
 -51974,
 888596373,
 1632,
 -51973,
 888772031,
 1633,
 -51972,
 888835260,
 1641,
 -1,
 888882487,
 1640,
 889074944,
 888119892,
 -1,
 -51969,
 889046319,
 1546,
 -1,
 889095493,
 1545,
 -51967,
 889016855,
 1543,
 -1,
 889206111,
 1542,
 889402750,
 787055620,
 -1,
 889468223,
 889372162,
 -1,
 889533751,
 889408563,
 -1,
 889599243,
 889466078,
 -1,
 889664777,
 889542795,
 -1,
 -51960,
 889603281,
 1395,
 -1,
 889656692,
 1401,
 -51958,
 889622927,
 1409,
 -1,
 889787764,
 1390,
 889992463,
 889536647,
 -1,
 -51955,
 889963220,
 1384,
 -51954,
 890001547,
 1383,
 -1,
 890056482,
 1381,
 890254610,
 889972510,
 -1,
 -51951,
 890198824,
 1386,
 -1,
 890246516,
 1382,
 890451220,
 890234224,
 1397,
 -1,
 890429774,
 1410,
 890582295,
 890427310,
 -1,
 -51946,
 890540431,
 1400,
 -1,
 890588509,
 1406,
 890778906,
 890553044,
 -1,
 -51943,
 890737039,
 1385,
 -1,
 890793702,
 1407,
 890975517,
 890746655,
 -1,
 -51940,
 890919081,
 1399,
 -1,
 890979537,
 1405,
 891172128,
 890939732,
 -1,
 -51937,
 891110609,
 1408,
 -1,
 891164020,
 1404,
 891368739,
 891133929,
 -1,
 -51934,
 891317994,
 1411,
 -1,
 891372753,
 1402,
 891565350,
 891318712,
 -1,
 -51931,
 891521247,
 1391,
 -1,
 891574411,
 1412,
 891761961,
 891514665,
 -1,
 -51928,
 891706374,
 1403,
 -1,
 891753844,
 1393,
 891958572,
 891704035,
 -1,
 -51925,
 891905631,
 1379,
 -1,
 891967689,
 1394,
 -51923,
 891937642,
 1389,
 -51922,
 892113763,
 1413,
 -51921,
 892178117,
 1398,
 -51920,
 892240891,
 1396,
 -51919,
 892304370,
 1388,
 -51918,
 892365092,
 1387,
 -51917,
 892427871,
 1392,
 -51916,
 892489582,
 1414,
 -51915,
 892548747,
 1380,
 -51914,
 892610672,
 1378,
 -1,
 892675670,
 1377,
 892927999,
 889480351,
 -1,
 892941629,
 892830719,
 -1,
 -51910,
 892920682,
 64279,
 -51909,
 892964549,
 64275,
 -51908,
 893020452,
 64277,
 -1,
 893076021,
 64276,
 -51906,
 892918621,
 64278,
 -1,
 893207097,
 1415,
 893400436,
 889400542,
 -1,
 893465971,
 893329382,
 -1,
 893531463,
 893398238,
 -1,
 893596997,
 893474955,
 -1,
 -51900,
 893535441,
 1347,
 -1,
 893588852,
 1353,
 -51898,
 893555087,
 1361,
 -1,
 893719924,
 1342,
 893924683,
 893468807,
 -1,
 -51895,
 893895380,
 1336,
 -51894,
 893933707,
 1335,
 -1,
 893988642,
 1333,
 894186830,
 893904670,
 -1,
 -51891,
 894130984,
 1338,
 -1,
 894178676,
 1334,
 894383440,
 894166384,
 1349,
 -1,
 894361934,
 1362,
 894514515,
 894359470,
 -1,
 -51886,
 894472591,
 1352,
 -1,
 894520669,
 1358,
 894711126,
 894485204,
 -1,
 -51883,
 894669199,
 1337,
 -1,
 894725862,
 1359,
 894907737,
 894678815,
 -1,
 -51880,
 894851241,
 1351,
 -1,
 894911697,
 1357,
 895104348,
 894871892,
 -1,
 -51877,
 895042769,
 1360,
 -1,
 895096180,
 1356,
 895300959,
 895066089,
 -1,
 -51874,
 895250154,
 1363,
 -1,
 895304913,
 1354,
 895497570,
 895250872,
 -1,
 -51871,
 895453407,
 1343,
 -1,
 895506571,
 1364,
 895694181,
 895446825,
 -1,
 -51868,
 895638534,
 1355,
 -1,
 895686004,
 1345,
 895890792,
 895636195,
 -1,
 -51865,
 895837791,
 1331,
 -1,
 895899849,
 1346,
 -51863,
 895869802,
 1341,
 -51862,
 896045923,
 1365,
 -51861,
 896110277,
 1350,
 -51860,
 896173051,
 1348,
 -51859,
 896236530,
 1340,
 -51858,
 896297252,
 1339,
 -51857,
 896360031,
 1344,
 -51856,
 896421742,
 1366,
 -51855,
 896480907,
 1332,
 -51854,
 896542832,
 1330,
 -1,
 896607830,
 1329,
 -1,
 893424895,
 1373,
 896873847,
 893337735,
 -1,
 -51850,
 896852806,
 1372,
 -1,
 896894842,
 1371,
 897070458,
 896800116,
 -1,
 -51847,
 897033584,
 1370,
 -1,
 897066997,
 1375,
 -51845,
 897034430,
 1374,
 -51844,
 897222271,
 1369,
 -51843,
 897278312,
 1418,
 -1,
 897340098,
 1417,
 897529221,
 889369875,
 -1,
 897594754,
 897495339,
 -1,
 -51839,
 897570089,
 10548,
 -1,
 897597232,
 10549,
 897843199,
 897531787,
 -1,
 -51836,
 897757332,
 10551,
 -1,
 897808447,
 10550,
 -51834,
 897475639,
 9800,
 -1,
 897920222,
 8978,
 898119156,
 786997225,
 -1,
 898184683,
 898069341,
 -1,
 898250153,
 898148289,
 -1,
 898315686,
 898176982,
 9109,
 898433023,
 898236416,
 -1,
 898446741,
 898315808,
 -1,
 898512272,
 898408363,
 -1,
 -51825,
 898489697,
 9047,
 -1,
 898499189,
 9036,
 898708883,
 898457983,
 -1,
 -51822,
 898685832,
 9017,
 -1,
 898702590,
 9018,
 898957311,
 898647486,
 9044,
 -1,
 898876181,
 9037,
 899036568,
 898421508,
 -1,
 -51817,
 899013985,
 9040,
 -1,
 899023477,
 9043,
 899233179,
 898987602,
 -1,
 -51814,
 899202978,
 9027,
 -1,
 899240624,
 9031,
 899429790,
 899165406,
 -1,
 -51811,
 899388577,
 9056,
 -1,
 899443740,
 9020,
 -51809,
 899399037,
 9025,
 -51808,
 899592351,
 9032,
 -51807,
 899655861,
 9072,
 -51806,
 899714651,
 9071,
 -51805,
 899772478,
 9019,
 -51804,
 899831543,
 9028,
 -51803,
 899893498,
 9016,
 -1,
 899950270,
 9026,
 900202495,
 898275999,
 -1,
 -51800,
 900125271,
 9048,
 -1,
 900179912,
 9054,
 900347323,
 898184736,
 -1,
 900412850,
 900308907,
 -1,
 900478385,
 900333568,
 -1,
 900543919,
 900449118,
 -1,
 -51794,
 900518487,
 9034,
 -1,
 900558910,
 9038,
 -51792,
 900512582,
 9062,
 -1,
 900673060,
 9073,
 -1,
 900455854,
 9046,
 900937146,
 900351422,
 -1,
 901002679,
 900857856,
 -1,
 -51787,
 900974588,
 9067,
 -51786,
 901038243,
 9042,
 -1,
 901068958,
 9058,
 901316607,
 900973336,
 -1,
 -51783,
 901239383,
 9049,
 -1,
 901300387,
 9035,
 -1,
 900883026,
 9050,
 901526981,
 900279518,
 -1,
 901592516,
 901475362,
 -1,
 901658048,
 901562379,
 -1,
 -51777,
 901604868,
 9021,
 -1,
 901652572,
 9055,
 -51775,
 901632599,
 9052,
 -51774,
 901804094,
 9022,
 -51773,
 901855390,
 9061,
 -1,
 901916350,
 9033,
 -1,
 901551364,
 9066,
 902182350,
 901501700,
 -1,
 902247885,
 902103040,
 -1,
 902313419,
 902218590,
 -1,
 -51767,
 902274730,
 9041,
 -51766,
 902328382,
 9045,
 -1,
 902379678,
 9057,
 -51764,
 902282045,
 9053,
 -1,
 902508068,
 9074,
 -1,
 902225326,
 9039,
 902772181,
 902149919,
 -1,
 902837714,
 902742740,
 -1,
 -51759,
 902784534,
 9069,
 -1,
 902832240,
 9059,
 -51757,
 902801688,
 9015,
 -51756,
 902985095,
 9023,
 -1,
 903038601,
 9070,
 903230937,
 902717823,
 -1,
 903296472,
 903191174,
 9075,
 -1,
 903220213,
 9080,
 -1,
 903220988,
 9014,
 903493084,
 903194964,
 -1,
 -51749,
 903439675,
 9030,
 -1,
 903503455,
 9076,
 903689694,
 903451883,
 9077,
 -1,
 903613429,
 9081,
 903820769,
 903640709,
 -1,
 -51744,
 903798190,
 9029,
 -1,
 903809561,
 9063,
 904017380,
 903770178,
 -1,
 -51741,
 903991895,
 9051,
 -1,
 904018078,
 9060,
 904213990,
 903945289,
 9082,
 -1,
 904137717,
 9078,
 -51737,
 904194097,
 9068,
 -51736,
 904316937,
 9064,
 -51735,
 904353608,
 9065,
 -51734,
 904415461,
 9079,
 -1,
 904472264,
 9024,
 904672755,
 898147997,
 -1,
 904738290,
 904651667,
 -1,
 904803825,
 904677632,
 -1,
 904869360,
 904775986,
 8773,
 -1,
 904791766,
 8786,
 -1,
 904828941,
 10864,
 -1,
 904735843,
 8774,
 -1,
 904664923,
 8784,
 -1,
 904632897,
 39,
 905262660,
 898057386,
 -1,
 905328179,
 905220159,
 -1,
 905393671,
 905298644,
 -1,
 905459198,
 905370888,
 -1,
 905524732,
 905417103,
 65800,
 905641983,
 905445376,
 -1,
 -51717,
 905561885,
 65827,
 -1,
 905601303,
 65818,
 905838591,
 905463887,
 65809,
 -1,
 905710289,
 65836,
 905917957,
 905402507,
 -1,
 905983491,
 905882704,
 65801,
 906100735,
 905904128,
 -1,
 -51710,
 906020637,
 65828,
 -1,
 906060055,
 65819,
 906297343,
 905931990,
 65810,
 -1,
 906169041,
 65837,
 906428415,
 905856753,
 65808,
 -1,
 906300113,
 65835,
 906507796,
 905361183,
 -1,
 906573326,
 906456814,
 65804,
 906638859,
 906546729,
 65813,
 -1,
 906562257,
 65840,
 906821631,
 906559488,
 -1,
 -51699,
 906741533,
 65831,
 -1,
 906780951,
 65822,
 907018239,
 906513538,
 65805,
 907032081,
 906939945,
 65814,
 -1,
 906955473,
 65841,
 907214847,
 906952704,
 -1,
 -51693,
 907134749,
 65832,
 -1,
 907174167,
 65823,
 907359779,
 906448470,
 -1,
 907425308,
 907317647,
 -1,
 907490842,
 907400575,
 65802,
 907608063,
 907411456,
 -1,
 -51687,
 907527965,
 65829,
 -1,
 907567383,
 65820,
 907804671,
 907458150,
 65811,
 -1,
 907676369,
 65838,
 907935743,
 907370879,
 -1,
 907949601,
 907860212,
 65803,
 908066815,
 907870208,
 -1,
 -51680,
 907986717,
 65830,
 -1,
 908026135,
 65821,
 908263423,
 907891390,
 65812,
 -1,
 908135121,
 65839,
 908342825,
 907316412,
 65807,
 908408358,
 908316201,
 65816,
 -1,
 908331729,
 65843,
 908591103,
 908328960,
 -1,
 -51672,
 908511005,
 65834,
 -1,
 908550423,
 65825,
 908736047,
 908281143,
 65806,
 908801580,
 908714990,
 65815,
 -1,
 908724945,
 65842,
 908984319,
 908722176,
 -1,
 -51666,
 908904221,
 65833,
 -1,
 908943639,
 65824,
 909180927,
 908694975,
 65799,
 909246463,
 909049856,
 -1,
 -51662,
 909166365,
 65826,
 -1,
 909205783,
 65817,
 909391422,
 905305352,
 -1,
 909456955,
 909329725,
 -1,
 909522488,
 909397590,
 -1,
 -51657,
 909483151,
 65851,
 -1,
 909536446,
 65848,
 -51655,
 909493964,
 65850,
 -51654,
 909686973,
 65849,
 -1,
 909715400,
 65847,
 909967359,
 909416578,
 -1,
 -51651,
 909867757,
 65792,
 -1,
 909916968,
 65793,
 910112321,
 909345623,
 -1,
 -51648,
 910083788,
 65855,
 -1,
 910145725,
 65854,
 -51646,
 910064527,
 65853,
 -51645,
 910245894,
 65852,
 -1,
 910307190,
 65794,
 910505609,
 905239381,
 -1,
 910571144,
 910457306,
 -1,
 910636622,
 910497140,
 68352,
 910702154,
 910562676,
 68353,
 -51639,
 910659983,
 68355,
 -1,
 910723295,
 68357,
 910898764,
 910639239,
 68358,
 -1,
 910835847,
 68359,
 -51635,
 910856591,
 68354,
 -1,
 910985439,
 68356,
 911160918,
 910592223,
 -1,
 911226451,
 911102691,
 -1,
 -51631,
 911205563,
 68387,
 -51630,
 911268084,
 68388,
 -1,
 911294599,
 68386,
 -51628,
 911205563,
 68390,
 -51627,
 911444739,
 68391,
 -1,
 911491207,
 68389,
 911685212,
 911128351,
 -1,
 911750746,
 911628427,
 -1,
 -51623,
 911729851,
 68403,
 -1,
 911753351,
 68401,
 -51621,
 911719127,
 68404,
 -1,
 911884423,
 68399,
 912078432,
 911663876,
 -1,
 -51618,
 912057531,
 68370,
 -51617,
 912120052,
 68371,
 -1,
 912146567,
 68369,
 912340580,
 912048852,
 -1,
 -51614,
 912311419,
 68381,
 -51613,
 912349992,
 68378,
 -1,
 912408711,
 68377,
 912602728,
 912282339,
 -1,
 -51610,
 912546600,
 68374,
 -51609,
 912610338,
 68373,
 -1,
 912670855,
 68372,
 912864875,
 912582430,
 -1,
 -51606,
 912808744,
 68402,
 -1,
 912867463,
 68400,
 913061486,
 912843758,
 -1,
 -51603,
 913040571,
 68394,
 -1,
 913064071,
 68395,
 913258096,
 913034826,
 68366,
 -1,
 913231434,
 68367,
 913389170,
 913215887,
 68362,
 -1,
 913346959,
 68363,
 913520244,
 913334655,
 68364,
 -1,
 913465727,
 68365,
 913651319,
 913463435,
 -1,
 -51594,
 913605403,
 68393,
 -1,
 913653895,
 68405,
 913847929,
 913588359,
 68360,
 -1,
 913784967,
 68361,
 913979004,
 913782304,
 -1,
 -51589,
 913922856,
 68380,
 -1,
 913981575,
 68379,
 914175615,
 913909366,
 -1,
 -51586,
 914119464,
 68385,
 -1,
 914178183,
 68384,
 -51584,
 914151668,
 68396,
 -51583,
 914336644,
 68397,
 -51582,
 914399661,
 68382,
 -51581,
 914457371,
 68392,
 -51580,
 914519634,
 68398,
 -51579,
 914583992,
 68368,
 -51578,
 914648909,
 68376,
 -51577,
 914706214,
 68383,
 -1,
 914763400,
 68375,
 -1,
 910497327,
 68409,
 915027611,
 910461151,
 -1,
 915093138,
 914999250,
 -1,
 915158670,
 915025118,
 -1,
 -51571,
 915117684,
 8755,
 -1,
 915176880,
 10560,
 -51569,
 915130928,
 8630,
 -51568,
 915314470,
 8634,
 -51567,
 915368414,
 10769,
 -1,
 915428241,
 10226,
 915617432,
 915034851,
 -1,
 915682967,
 915568210,
 8736,
 915800063,
 915606563,
 -1,
 -51562,
 915722839,
 10660,
 -1,
 915781459,
 10654,
 -1,
 915652961,
 8491,
 -51559,
 915567108,
 9765,
 -51558,
 915945077,
 10193,
 -1,
 916008920,
 9875,
 916207273,
 914977624,
 -1,
 916272800,
 916162351,
 -1,
 916338335,
 916244786,
 8776,
 -1,
 916262004,
 10863,
 -1,
 916297741,
 8778,
 916534947,
 916243863,
 -1,
 -51550,
 916483712,
 9095,
 -1,
 916537498,
 9941,
 916731558,
 916484954,
 -1,
 -51547,
 916670727,
 8780,
 -1,
 916726315,
 9006,
 916979711,
 916668551,
 -1,
 -51544,
 916882135,
 9879,
 -1,
 916934291,
 8501,
 917124785,
 916174623,
 -1,
 917190318,
 917095814,
 -1,
 917255853,
 917139592,
 42,
 -1,
 917177975,
 8727,
 -1,
 917209061,
 8258,
 -51537,
 917169661,
 8771,
 -51536,
 917420493,
 8870,
 -1,
 917450446,
 9738,
 917649082,
 917056734,
 -1,
 917714613,
 917624616,
 -1,
 -51532,
 917670911,
 10655,
 -1,
 917712492,
 180,
 917911224,
 917686536,
 -1,
 -51529,
 917881463,
 8299,
 -1,
 917905561,
 8301,
 -51527,
 917844893,
 8448,
 -1,
 918029069,
 9190,
 918238909,
 917602277,
 -1,
 -51524,
 918201054,
 38,
 -1,
 918231928,
 10815,
 918435520,
 918173216,
 -1,
 -51521,
 918380988,
 9772,
 -1,
 918437836,
 8449,
 -51519,
 918411005,
 8371,
 -51518,
 918604181,
 9883,
 -51517,
 918661197,
 9810,
 -51516,
 918713078,
 8525,
 -51515,
 918777004,
 9992,
 -1,
 918835193,
 1547,
 919026647,
 786949102,
 -1,
 919092182,
 918970751,
 -1,
 919157717,
 919011328,
 -1,
 919223175,
 919126610,
 -1,
 919287695,
 919177439,
 -1,
 919353065,
 919267102,
 -1,
 919418579,
 919326282,
 41727,
 919484111,
 919382356,
 41730,
 -1,
 919462660,
 41729,
 919615185,
 919441807,
 41721,
 -1,
 919593732,
 41720,
 -51502,
 919593732,
 41726,
 -1,
 919707625,
 41728,
 919877338,
 919363967,
 41711,
 919942871,
 919814279,
 41714,
 -51498,
 919921412,
 41713,
 -1,
 919969769,
 41715,
 -51496,
 919921412,
 41710,
 -51495,
 920109780,
 41709,
 -1,
 920166377,
 41712,
 920336096,
 919856110,
 41733,
 920401629,
 920299860,
 41736,
 -1,
 920380164,
 41735,
 -51490,
 920380164,
 41732,
 -51489,
 920502996,
 41731,
 -1,
 920559593,
 41734,
 920729316,
 920262004,
 41718,
 -51486,
 920707844,
 41717,
 -51485,
 920765140,
 41716,
 -1,
 920821737,
 41719,
 920991463,
 920686991,
 -1,
 -51482,
 920969988,
 41722,
 -1,
 921018345,
 41723,
 921239551,
 920928391,
 41725,
 -1,
 921166596,
 41724,
 921319173,
 919283318,
 -1,
 921384689,
 921264511,
 41080,
 921450222,
 921321607,
 41083,
 -51475,
 921428740,
 41082,
 -1,
 921477097,
 41084,
 -51473,
 921428740,
 41079,
 -51472,
 921617108,
 41078,
 -1,
 921673705,
 41081,
 921843447,
 921363438,
 41101,
 921908980,
 921807188,
 41104,
 -1,
 921887492,
 41103,
 -51467,
 921887492,
 41100,
 -51466,
 922010324,
 41099,
 -1,
 922066921,
 41102,
 922236669,
 921816650,
 41095,
 922302202,
 922200404,
 41098,
 -1,
 922280708,
 41097,
 -51461,
 922280708,
 41094,
 -51460,
 922403540,
 41093,
 -1,
 922460137,
 41096,
 922629889,
 922194319,
 41091,
 -51457,
 922608388,
 41090,
 -51456,
 922665684,
 41089,
 -1,
 922722281,
 41092,
 922943487,
 922555764,
 41087,
 -51453,
 922870532,
 41086,
 -51452,
 922927828,
 41085,
 -1,
 922984425,
 41088,
 923154207,
 921268009,
 -1,
 923219726,
 923099519,
 42035,
 923285259,
 923156615,
 42039,
 -51447,
 923263748,
 42038,
 -51446,
 923321044,
 42037,
 -1,
 923377641,
 42040,
 -51444,
 923263748,
 42034,
 -51443,
 923517652,
 42033,
 -1,
 923574249,
 42036,
 923744021,
 923192906,
 42048,
 923809553,
 923707732,
 42051,
 -1,
 923788036,
 42050,
 923940627,
 923767183,
 42042,
 -1,
 923919108,
 42041,
 -51436,
 923919108,
 42047,
 -1,
 924033001,
 42049,
 924202779,
 923722734,
 42054,
 924268312,
 924166484,
 42057,
 -1,
 924246788,
 42056,
 -51431,
 924246788,
 42053,
 -51430,
 924369620,
 42052,
 -1,
 924426217,
 42055,
 924647423,
 924160399,
 42045,
 -51427,
 924574468,
 42044,
 -51426,
 924631764,
 42043,
 -1,
 924688361,
 42046,
 924858167,
 923117908,
 -1,
 924923686,
 924836846,
 41895,
 924989219,
 924887380,
 41898,
 -1,
 924967684,
 41897,
 -51420,
 924967684,
 41894,
 -51419,
 925090516,
 41893,
 -1,
 925147113,
 41896,
 925316908,
 924896842,
 41889,
 925382441,
 925280596,
 41892,
 -1,
 925360900,
 41891,
 -51414,
 925360900,
 41888,
 -51413,
 925483732,
 41887,
 -1,
 925540329,
 41890,
 925710128,
 925253767,
 41885,
 -51410,
 925688580,
 41884,
 -51409,
 925745876,
 41883,
 -1,
 925802473,
 41886,
 925972276,
 925635956,
 41878,
 -51406,
 925950724,
 41877,
 -51405,
 926008020,
 41876,
 -1,
 926064617,
 41879,
 926285823,
 925929871,
 41881,
 -51402,
 926212868,
 41880,
 -1,
 926261225,
 41882,
 926431055,
 924792352,
 -1,
 926496574,
 926404170,
 41316,
 926562107,
 926460244,
 41319,
 -1,
 926540548,
 41318,
 -51396,
 926540548,
 41315,
 -51395,
 926663380,
 41314,
 -1,
 926719977,
 41317,
 926889796,
 926441855,
 41299,
 926955329,
 926826631,
 41302,
 -1,
 926933764,
 41301,
 -51390,
 926933764,
 41298,
 -51389,
 927056596,
 41297,
 -1,
 927113193,
 41300,
 927283016,
 926847375,
 41309,
 -51386,
 927261444,
 41308,
 -51385,
 927318740,
 41307,
 -1,
 927375337,
 41310,
 927545164,
 927208820,
 41305,
 -51382,
 927523588,
 41304,
 -51381,
 927580884,
 41303,
 -1,
 927637481,
 41306,
 927858687,
 927481991,
 41312,
 -51378,
 927785732,
 41311,
 -1,
 927834089,
 41313,
 928003939,
 926409710,
 -1,
 928069464,
 927949183,
 42060,
 928134997,
 928006279,
 42064,
 -51373,
 928113412,
 42063,
 -51372,
 928170708,
 42062,
 -1,
 928227305,
 42065,
 -51370,
 928113412,
 42059,
 -51369,
 928367316,
 42058,
 -1,
 928423913,
 42061,
 928593759,
 928042570,
 42075,
 928659292,
 928551311,
 42067,
 -51365,
 928637700,
 42066,
 -1,
 928686057,
 42068,
 -51363,
 928637700,
 42074,
 -51362,
 928826068,
 42073,
 -1,
 928882665,
 42076,
 929103871,
 928551311,
 42071,
 -51359,
 929030916,
 42070,
 -51358,
 929088212,
 42069,
 -1,
 929144809,
 42072,
 929314677,
 927945443,
 -1,
 929380200,
 929272207,
 41577,
 -51354,
 929358596,
 41576,
 -51353,
 929415892,
 41575,
 -1,
 929472489,
 41578,
 929642348,
 929305972,
 41570,
 -51350,
 929620740,
 41569,
 -51349,
 929678036,
 41568,
 -1,
 929734633,
 41571,
 929904495,
 929616628,
 41574,
 -51346,
 929882884,
 41573,
 -1,
 929940180,
 41572,
 930101106,
 929850416,
 41566,
 -51343,
 930079492,
 41565,
 -1,
 930127849,
 41567,
 930349055,
 930037895,
 41580,
 -51340,
 930276100,
 41579,
 -1,
 930324457,
 41581,
 930494334,
 929287754,
 41363,
 930559865,
 930451855,
 41352,
 -51336,
 930538244,
 41351,
 -1,
 930586601,
 41353,
 930756475,
 930523476,
 41366,
 -1,
 930734852,
 41365,
 -51332,
 930734852,
 41362,
 -51331,
 930857684,
 41361,
 -1,
 930914281,
 41364,
 931084165,
 930439551,
 41343,
 931149698,
 931020935,
 41346,
 -51327,
 931128068,
 41345,
 -1,
 931176425,
 41347,
 -51325,
 931128068,
 41342,
 -51324,
 931316436,
 41341,
 -1,
 931373033,
 41344,
 931542921,
 931041679,
 41356,
 -51321,
 931521284,
 41355,
 -51320,
 931578580,
 41354,
 -1,
 931635177,
 41357,
 931805068,
 931479687,
 41359,
 -51317,
 931783428,
 41358,
 -1,
 931831785,
 41360,
 932052991,
 931730804,
 41349,
 -51314,
 931980036,
 41348,
 -1,
 932028393,
 41350,
 932198418,
 919230603,
 -1,
 932263857,
 932148056,
 -1,
 932329370,
 932236874,
 41389,
 932394901,
 932286863,
 41379,
 -51308,
 932373252,
 41378,
 -1,
 932421609,
 41380,
 932591511,
 932358484,
 41392,
 -1,
 932569860,
 41391,
 -51304,
 932569860,
 41388,
 -51303,
 932692692,
 41387,
 -1,
 932749289,
 41390,
 932919201,
 932274559,
 41369,
 932984734,
 932855943,
 41372,
 -51299,
 932963076,
 41371,
 -1,
 933011433,
 41373,
 -51297,
 932963076,
 41368,
 -51296,
 933151444,
 41367,
 -1,
 933208041,
 41370,
 933377959,
 932897774,
 41395,
 933443492,
 933341524,
 41398,
 -1,
 933421828,
 41397,
 -51291,
 933421828,
 41394,
 -51290,
 933544660,
 41393,
 -1,
 933601257,
 41396,
 933771179,
 933303668,
 41376,
 -51287,
 933749508,
 41375,
 -51286,
 933806804,
 41374,
 -1,
 933863401,
 41377,
 934033326,
 933728655,
 41382,
 -51283,
 934011652,
 41381,
 -1,
 934060009,
 41383,
 934281215,
 933970055,
 41385,
 -51280,
 934208260,
 41384,
 -1,
 934256617,
 41386,
 934426575,
 932216805,
 -1,
 934492091,
 934399562,
 41125,
 934557622,
 934449551,
 41117,
 -51275,
 934535940,
 41116,
 -1,
 934584297,
 41118,
 934754232,
 934521172,
 41128,
 -1,
 934732548,
 41127,
 -51271,
 934732548,
 41124,
 -51270,
 934855380,
 41123,
 -1,
 934911977,
 41126,
 935081922,
 934437247,
 41107,
 935147455,
 935018631,
 41110,
 -51266,
 935125764,
 41109,
 -1,
 935174121,
 41111,
 -51264,
 935125764,
 41106,
 -51263,
 935314132,
 41105,
 -1,
 935370729,
 41108,
 935540679,
 935060462,
 41130,
 935606213,
 935504212,
 41133,
 -1,
 935584516,
 41132,
 -51258,
 935584516,
 41129,
 -1,
 935698409,
 41131,
 935868363,
 935498127,
 41121,
 -51255,
 935846660,
 41120,
 -51254,
 935903956,
 41119,
 -1,
 935960553,
 41122,
 936181759,
 935794036,
 41114,
 -51251,
 936108804,
 41113,
 -51250,
 936166100,
 41112,
 -1,
 936222697,
 41115,
 936392679,
 934404868,
 -1,
 936458200,
 936337791,
 41544,
 936523733,
 936394887,
 41548,
 -51245,
 936502020,
 41547,
 -51244,
 936559316,
 41546,
 -1,
 936615913,
 41549,
 -51242,
 936502020,
 41543,
 -51241,
 936755924,
 41542,
 -1,
 936812521,
 41545,
 936982492,
 936432372,
 41556,
 -51238,
 936960772,
 41555,
 -51237,
 937018068,
 41554,
 -1,
 937074665,
 41557,
 937244640,
 936939919,
 41560,
 -51234,
 937222916,
 41559,
 -51233,
 937280212,
 41558,
 -1,
 937336809,
 41561,
 937506788,
 937170292,
 41552,
 -51230,
 937485060,
 41551,
 -51229,
 937542356,
 41550,
 -1,
 937598953,
 41553,
 937820159,
 937443463,
 41563,
 -51226,
 937747204,
 41562,
 -1,
 937795561,
 41564,
 937965567,
 936347871,
 -1,
 938031088,
 937910655,
 41322,
 938096621,
 937967751,
 41326,
 -51221,
 938074884,
 41325,
 -51220,
 938132180,
 41324,
 -1,
 938188777,
 41327,
 -51218,
 938074884,
 41321,
 -51217,
 938328788,
 41320,
 -1,
 938385385,
 41323,
 938555380,
 937956724,
 41330,
 -51214,
 938533636,
 41329,
 -51213,
 938590932,
 41328,
 -1,
 938647529,
 41331,
 938817528,
 938528330,
 -1,
 938883063,
 938774927,
 41333,
 -1,
 938861316,
 41332,
 -1,
 938853076,
 41340,
 939079676,
 938774927,
 -1,
 -51206,
 939057924,
 41335,
 -51205,
 939115220,
 41334,
 -1,
 939171817,
 41336,
 939393023,
 939016327,
 41338,
 -51202,
 939320068,
 41337,
 -1,
 939368425,
 41339,
 939538435,
 937939700,
 41591,
 -51199,
 939516676,
 41590,
 -51198,
 939573972,
 41589,
 -1,
 939630569,
 41592,
 939800583,
 939495823,
 41595,
 -51195,
 939778820,
 41594,
 -51194,
 939836116,
 41593,
 -1,
 939892713,
 41596,
 940062731,
 939726196,
 41587,
 -51191,
 940040964,
 41586,
 -51190,
 940098260,
 41585,
 -1,
 940154857,
 41588,
 940324879,
 940007807,
 -1,
 940390414,
 940261511,
 41584,
 -1,
 940368644,
 41583,
 -1,
 940360404,
 41582,
 940638207,
 940261511,
 41598,
 -51183,
 940565252,
 41597,
 -1,
 940613609,
 41599,
 940783726,
 932177694,
 -1,
 940849201,
 940762910,
 -1,
 940914716,
 940794239,
 41682,
 940980249,
 940851335,
 41686,
 -51177,
 940958468,
 41685,
 -51176,
 941015764,
 41684,
 -1,
 941072361,
 41687,
 -51174,
 940958468,
 41681,
 -51173,
 941212372,
 41680,
 -1,
 941268969,
 41683,
 941439010,
 940893166,
 41705,
 941504543,
 941402452,
 41708,
 -1,
 941482756,
 41707,
 -51168,
 941482756,
 41704,
 -51167,
 941605588,
 41703,
 -1,
 941662185,
 41706,
 941832231,
 941411914,
 41699,
 941897765,
 941795668,
 41702,
 -1,
 941875972,
 41701,
 -51162,
 941875972,
 41698,
 -1,
 941989865,
 41700,
 942159915,
 941757812,
 41690,
 -51159,
 942138116,
 41689,
 -51158,
 942195412,
 41688,
 -1,
 942252009,
 41691,
 942422062,
 942117263,
 41693,
 -51155,
 942400260,
 41692,
 -1,
 942448617,
 41694,
 942669823,
 942358663,
 41696,
 -51152,
 942596868,
 41695,
 -1,
 942645225,
 41697,
 942815309,
 940791947,
 -1,
 942880827,
 942788170,
 41815,
 942946358,
 942838159,
 41803,
 -51147,
 942924548,
 41802,
 -1,
 942972905,
 41804,
 943142968,
 942909780,
 41818,
 -1,
 943121156,
 41817,
 -51143,
 943121156,
 41814,
 -51142,
 943243988,
 41813,
 -1,
 943300585,
 41816,
 943470657,
 942859246,
 41821,
 943536190,
 943434068,
 41824,
 -1,
 943514372,
 41823,
 -51137,
 943514372,
 41820,
 -51136,
 943637204,
 41819,
 -1,
 943693801,
 41822,
 943863877,
 943427983,
 41807,
 -51133,
 943842052,
 41806,
 -51132,
 943899348,
 41805,
 -1,
 943955945,
 41808,
 944126025,
 943800455,
 41811,
 -51129,
 944104196,
 41810,
 -51128,
 944161492,
 41809,
 -1,
 944218089,
 41812,
 944439295,
 944051572,
 41800,
 -51125,
 944366340,
 41799,
 -51124,
 944423636,
 41798,
 -1,
 944480233,
 41801,
 944650326,
 942788170,
 41636,
 944715857,
 944607631,
 41625,
 -51120,
 944694020,
 41624,
 -1,
 944742377,
 41626,
 944912467,
 944679252,
 41639,
 -1,
 944890628,
 41638,
 -51116,
 944890628,
 41635,
 -51115,
 945013460,
 41634,
 -1,
 945070057,
 41637,
 945240157,
 944595327,
 41615,
 945305690,
 945176711,
 41618,
 -51111,
 945283844,
 41617,
 -1,
 945332201,
 41619,
 -51109,
 945283844,
 41614,
 -51108,
 945472212,
 41613,
 -1,
 945528809,
 41616,
 945698915,
 945218542,
 41642,
 945764448,
 945662292,
 41645,
 -1,
 945742596,
 41644,
 -51103,
 945742596,
 41641,
 -51102,
 945865428,
 41640,
 -1,
 945922025,
 41643,
 946092135,
 945656207,
 41629,
 -51099,
 946070276,
 41628,
 -51098,
 946127572,
 41627,
 -1,
 946184169,
 41630,
 946354283,
 946017652,
 41622,
 -51095,
 946332420,
 41621,
 -51094,
 946389716,
 41620,
 -1,
 946446313,
 41623,
 946667519,
 946290823,
 41632,
 -51091,
 946594564,
 41631,
 -1,
 946642921,
 41633,
 946813129,
 940750623,
 -1,
 946878604,
 946779935,
 -1,
 946944119,
 946823551,
 41772,
 947009652,
 946880647,
 41775,
 -51085,
 946987780,
 41774,
 -1,
 947036137,
 41776,
 -51083,
 946987780,
 41771,
 -51082,
 947176148,
 41770,
 -1,
 947232745,
 41773,
 947402877,
 946922478,
 41794,
 947468410,
 947366228,
 41797,
 -1,
 947446532,
 41796,
 -51077,
 947446532,
 41793,
 -51076,
 947569364,
 41792,
 -1,
 947625961,
 41795,
 947796097,
 947375690,
 41790,
 -51073,
 947774212,
 41789,
 -51072,
 947831508,
 41788,
 -1,
 947888105,
 41791,
 948058245,
 947753359,
 41783,
 -51069,
 948036356,
 41782,
 -51068,
 948093652,
 41781,
 -1,
 948150249,
 41784,
 948320393,
 947983732,
 41779,
 -51065,
 948298500,
 41778,
 -51064,
 948355796,
 41777,
 -1,
 948412393,
 41780,
 948633599,
 948256903,
 41786,
 -51061,
 948560644,
 41785,
 -1,
 948609001,
 41787,
 948779176,
 946821259,
 -1,
 948844694,
 948751946,
 41916,
 948910225,
 948801935,
 41904,
 -51056,
 948888324,
 41903,
 -1,
 948936681,
 41905,
 949106835,
 948873556,
 41919,
 -1,
 949084932,
 41918,
 -51052,
 949084932,
 41915,
 -51051,
 949207764,
 41914,
 -1,
 949264361,
 41917,
 949434524,
 948823022,
 41922,
 949500057,
 949397844,
 41925,
 -1,
 949478148,
 41924,
 -51046,
 949478148,
 41921,
 -51045,
 949600980,
 41920,
 -1,
 949657577,
 41923,
 949827744,
 949391759,
 41908,
 -51042,
 949805828,
 41907,
 -51041,
 949863124,
 41906,
 -1,
 949919721,
 41909,
 950089892,
 949764231,
 41912,
 -51038,
 950067972,
 41911,
 -51037,
 950125268,
 41910,
 -1,
 950181865,
 41913,
 950403071,
 950015348,
 41901,
 -51034,
 950330116,
 41900,
 -51033,
 950387412,
 41899,
 -1,
 950444009,
 41902,
 950614193,
 948751946,
 41760,
 950679724,
 950571407,
 41749,
 -51029,
 950657796,
 41748,
 -1,
 950706153,
 41750,
 950876334,
 950643028,
 41763,
 -1,
 950854404,
 41762,
 -51025,
 950854404,
 41759,
 -51024,
 950977236,
 41758,
 -1,
 951033833,
 41761,
 951204024,
 950559103,
 41739,
 951269557,
 951140487,
 41742,
 -51020,
 951247620,
 41741,
 -1,
 951295977,
 41743,
 -51018,
 951247620,
 41738,
 -51017,
 951435988,
 41737,
 -1,
 951492585,
 41740,
 951662782,
 951182318,
 41766,
 951728315,
 951626068,
 41769,
 -1,
 951706372,
 41768,
 -51012,
 951706372,
 41765,
 -51011,
 951829204,
 41764,
 -1,
 951885801,
 41767,
 952056002,
 951619983,
 41753,
 -51008,
 952034052,
 41752,
 -51007,
 952091348,
 41751,
 -1,
 952147945,
 41754,
 952318150,
 951981428,
 41746,
 -51004,
 952296196,
 41745,
 -51003,
 952353492,
 41744,
 -1,
 952410089,
 41747,
 952631295,
 952254599,
 41756,
 -51000,
 952558340,
 41755,
 -1,
 952606697,
 41757,
 952776973,
 946742902,
 -1,
 952842475,
 952706678,
 -1,
 952907988,
 952815178,
 41070,
 952973519,
 952865167,
 41059,
 -50994,
 952951556,
 41058,
 -1,
 952999913,
 41060,
 953170129,
 952936788,
 41073,
 -1,
 953148164,
 41072,
 -50990,
 953148164,
 41069,
 -50989,
 953270996,
 41068,
 -1,
 953327593,
 41071,
 953497820,
 952852863,
 41048,
 953563353,
 953434247,
 41052,
 -50985,
 953541380,
 41051,
 -50984,
 953598676,
 41050,
 -1,
 953655273,
 41053,
 -50982,
 953541380,
 41047,
 -50981,
 953795284,
 41046,
 -1,
 953851881,
 41049,
 954022112,
 953476078,
 41076,
 -50978,
 954000132,
 41075,
 -50977,
 954057428,
 41074,
 -1,
 954114025,
 41077,
 954284260,
 953979279,
 41063,
 -50974,
 954262276,
 41062,
 -50973,
 954319572,
 41061,
 -1,
 954376169,
 41064,
 954546408,
 954209652,
 41056,
 -50970,
 954524420,
 41055,
 -50969,
 954581716,
 41054,
 -1,
 954638313,
 41057,
 954859519,
 954482823,
 41066,
 -50966,
 954786564,
 41065,
 -1,
 954834921,
 41067,
 955005172,
 952815178,
 41006,
 955070703,
 954962319,
 40995,
 -50962,
 955048708,
 40994,
 -1,
 955097065,
 40996,
 955267313,
 955033940,
 41009,
 -1,
 955245316,
 41008,
 -50958,
 955245316,
 41005,
 -50957,
 955368148,
 41004,
 -1,
 955424745,
 41007,
 955595004,
 954950015,
 40984,
 955660537,
 955531399,
 40988,
 -50953,
 955638532,
 40987,
 -50952,
 955695828,
 40986,
 -1,
 955752425,
 40989,
 -50950,
 955638532,
 40983,
 -50949,
 955892436,
 40982,
 -1,
 955949033,
 40985,
 956119298,
 955573230,
 41012,
 956184831,
 956082516,
 41015,
 -1,
 956162820,
 41014,
 -50944,
 956162820,
 41011,
 -50943,
 956285652,
 41010,
 -1,
 956342249,
 41013,
 956512518,
 956076431,
 40999,
 -50940,
 956490500,
 40998,
 -50939,
 956547796,
 40997,
 -1,
 956604393,
 41000,
 956774666,
 956437876,
 40992,
 -50936,
 956752644,
 40991,
 -50935,
 956809940,
 40990,
 -1,
 956866537,
 40993,
 957087743,
 956711047,
 41002,
 -50932,
 957014788,
 41001,
 -1,
 957063145,
 41003,
 957233484,
 952708318,
 -1,
 957298986,
 957175947,
 -1,
 957364504,
 957271626,
 41842,
 957430036,
 957321615,
 41831,
 -50926,
 957408004,
 41830,
 -50925,
 957465300,
 41829,
 -1,
 957521897,
 41832,
 957692182,
 957393236,
 41845,
 -1,
 957670148,
 41844,
 -50921,
 957670148,
 41841,
 -1,
 957784041,
 41843,
 957954334,
 957342702,
 41848,
 958019867,
 957917524,
 41851,
 -1,
 957997828,
 41850,
 -50916,
 957997828,
 41847,
 -50915,
 958120660,
 41846,
 -1,
 958177257,
 41849,
 958347554,
 957911439,
 41835,
 -50912,
 958325508,
 41834,
 -50911,
 958382804,
 41833,
 -1,
 958439401,
 41836,
 958609702,
 958283911,
 41839,
 -50908,
 958587652,
 41838,
 -50907,
 958644948,
 41837,
 -1,
 958701545,
 41840,
 958922751,
 958535028,
 41827,
 -50904,
 958849796,
 41826,
 -50903,
 958907092,
 41825,
 -1,
 958963689,
 41828,
 959134003,
 957271626,
 41670,
 959199534,
 959091087,
 41659,
 -50899,
 959177476,
 41658,
 -1,
 959225833,
 41660,
 959396144,
 959162708,
 41673,
 -1,
 959374084,
 41672,
 -50895,
 959374084,
 41669,
 -50894,
 959496916,
 41668,
 -1,
 959553513,
 41671,
 959723835,
 959078783,
 41648,
 959789368,
 959660167,
 41652,
 -50890,
 959767300,
 41651,
 -50889,
 959824596,
 41650,
 -1,
 959881193,
 41653,
 -50887,
 959767300,
 41647,
 -50886,
 960021204,
 41646,
 -1,
 960077801,
 41649,
 960248129,
 959701998,
 41676,
 960313662,
 960211284,
 41679,
 -1,
 960291588,
 41678,
 -50881,
 960291588,
 41675,
 -50880,
 960414420,
 41674,
 -1,
 960471017,
 41677,
 960641349,
 960205199,
 41663,
 -50877,
 960619268,
 41662,
 -50876,
 960676564,
 41661,
 -1,
 960733161,
 41664,
 960903497,
 960566644,
 41656,
 -50873,
 960881412,
 41655,
 -50872,
 960938708,
 41654,
 -1,
 960995305,
 41657,
 961216511,
 960839815,
 41666,
 -50869,
 961143556,
 41665,
 -1,
 961191913,
 41667,
 961362312,
 957174499,
 -1,
 961427818,
 961303267,
 -1,
 961493336,
 961400394,
 41516,
 961558867,
 961450383,
 41504,
 -50863,
 961536772,
 41503,
 -50862,
 961594068,
 41502,
 -1,
 961650665,
 41505,
 961821013,
 961522004,
 41519,
 -1,
 961798916,
 41518,
 -50858,
 961798916,
 41515,
 -50857,
 961921748,
 41514,
 -1,
 961978345,
 41517,
 962148702,
 961438079,
 41494,
 962214236,
 962084999,
 41496,
 -50853,
 962192132,
 41495,
 -1,
 962240489,
 41497,
 -50851,
 962192132,
 41493,
 -1,
 962380500,
 41492,
 962541922,
 962105743,
 41508,
 -50848,
 962519812,
 41507,
 -50847,
 962577108,
 41506,
 -1,
 962633705,
 41509,
 962804070,
 962478215,
 41512,
 -50844,
 962781956,
 41511,
 -50843,
 962839252,
 41510,
 -1,
 962895849,
 41513,
 963117055,
 962729332,
 41500,
 -50840,
 963044100,
 41499,
 -50839,
 963101396,
 41498,
 -1,
 963157993,
 41501,
 963328372,
 961400394,
 41460,
 963393903,
 963285391,
 41448,
 -50835,
 963371780,
 41447,
 -50834,
 963429076,
 41446,
 -1,
 963485673,
 41449,
 963656049,
 963357012,
 41463,
 -1,
 963633924,
 41462,
 -50830,
 963633924,
 41459,
 -50829,
 963756756,
 41458,
 -1,
 963813353,
 41461,
 963983740,
 963273087,
 41436,
 964049273,
 963920007,
 41440,
 -50825,
 964027140,
 41439,
 -50824,
 964084436,
 41438,
 -1,
 964141033,
 41441,
 -50822,
 964027140,
 41435,
 -50821,
 964281044,
 41434,
 -1,
 964337641,
 41437,
 964508032,
 963940751,
 41452,
 -50818,
 964485892,
 41451,
 -50817,
 964543188,
 41450,
 -1,
 964599785,
 41453,
 964770180,
 964444295,
 41456,
 -50814,
 964748036,
 41455,
 -50813,
 964805332,
 41454,
 -1,
 964861929,
 41457,
 965083135,
 964695412,
 41444,
 -50810,
 965010180,
 41443,
 -50809,
 965067476,
 41442,
 -1,
 965124073,
 41445,
 965294527,
 961314789,
 -1,
 965360032,
 965235427,
 -1,
 965425555,
 965332554,
 41538,
 965491086,
 965382543,
 41527,
 -50803,
 965468932,
 41526,
 -1,
 965517289,
 41528,
 965687696,
 965454164,
 41541,
 -1,
 965665540,
 41540,
 -50799,
 965665540,
 41537,
 -50798,
 965788372,
 41536,
 -1,
 965844969,
 41539,
 966015383,
 965382543,
 41531,
 -50795,
 965993220,
 41530,
 -50794,
 966050516,
 41529,
 -1,
 966107113,
 41532,
 966277531,
 965940596,
 41524,
 -50791,
 966255364,
 41523,
 -50790,
 966312660,
 41522,
 -1,
 966369257,
 41525,
 966539678,
 966213767,
 41534,
 -50787,
 966517508,
 41533,
 -1,
 966565865,
 41535,
 966787071,
 966485040,
 41521,
 -1,
 966714116,
 41520,
 966867370,
 965332554,
 41157,
 966932901,
 966824335,
 41147,
 -50781,
 966910724,
 41146,
 -50780,
 966968020,
 41145,
 -1,
 967024617,
 41148,
 967195047,
 966895956,
 41160,
 -1,
 967172868,
 41159,
 -50776,
 967172868,
 41156,
 -50775,
 967295700,
 41155,
 -1,
 967352297,
 41158,
 967522737,
 966812031,
 41136,
 967588270,
 967458951,
 41139,
 -50771,
 967566084,
 41138,
 -1,
 967614441,
 41140,
 -50769,
 967566084,
 41135,
 -50768,
 967754452,
 41134,
 -1,
 967811049,
 41137,
 967981493,
 967500782,
 41163,
 -50765,
 967959300,
 41162,
 -50764,
 968016596,
 41161,
 -1,
 968073193,
 41164,
 968243641,
 967938447,
 41151,
 -50761,
 968221444,
 41150,
 -50760,
 968278740,
 41149,
 -1,
 968335337,
 41152,
 968505789,
 968168820,
 41143,
 -50757,
 968483588,
 41142,
 -50756,
 968540884,
 41141,
 -1,
 968597481,
 41144,
 968818687,
 968441991,
 41154,
 -1,
 968745732,
 41153,
 968899062,
 965242665,
 -1,
 968964570,
 968847145,
 -1,
 969030090,
 968937034,
 42025,
 969095621,
 968987023,
 42017,
 -50748,
 969073412,
 42016,
 -1,
 969121769,
 42018,
 969292231,
 969058644,
 42028,
 -1,
 969270020,
 42027,
 -50744,
 969270020,
 42024,
 -50743,
 969392852,
 42023,
 -1,
 969449449,
 42026,
 969619922,
 968974719,
 42010,
 969685455,
 969556103,
 42014,
 -50739,
 969663236,
 42013,
 -50738,
 969720532,
 42012,
 -1,
 969777129,
 42015,
 -50736,
 969663236,
 42009,
 -50735,
 969917140,
 42008,
 -1,
 969973737,
 42011,
 970144214,
 969597934,
 42031,
 -50732,
 970121988,
 42030,
 -50731,
 970179284,
 42029,
 -1,
 970235881,
 42032,
 970457087,
 970101135,
 42021,
 -50728,
 970384132,
 42020,
 -50727,
 970441428,
 42019,
 -1,
 970498025,
 42022,
 970668516,
 968937034,
 41970,
 970734047,
 970625423,
 41962,
 -50723,
 970711812,
 41961,
 -50722,
 970769108,
 41960,
 -1,
 970825705,
 41963,
 970996193,
 970697044,
 41973,
 -1,
 970973956,
 41972,
 -50718,
 970973956,
 41969,
 -50717,
 971096788,
 41968,
 -1,
 971153385,
 41971,
 971323884,
 970613119,
 41954,
 971389417,
 971260039,
 41958,
 -50713,
 971367172,
 41957,
 -50712,
 971424468,
 41956,
 -1,
 971481065,
 41959,
 -50710,
 971367172,
 41953,
 -50709,
 971621076,
 41952,
 -1,
 971677673,
 41955,
 971848178,
 971301870,
 41976,
 971913711,
 971811156,
 41979,
 -1,
 971891460,
 41978,
 -50704,
 971891460,
 41975,
 -50703,
 972014292,
 41974,
 -1,
 972070889,
 41977,
 972292095,
 971805071,
 41966,
 -50700,
 972219140,
 41965,
 -50699,
 972276436,
 41964,
 -1,
 972333033,
 41967,
 972503597,
 968832544,
 -1,
 972569107,
 972437024,
 -1,
 972634625,
 972541514,
 41293,
 972700156,
 972591503,
 41282,
 -50693,
 972677892,
 41281,
 -1,
 972726249,
 41283,
 972896766,
 972663124,
 41296,
 -1,
 972874500,
 41295,
 -50689,
 972874500,
 41292,
 -50688,
 972997332,
 41291,
 -1,
 973053929,
 41294,
 973224456,
 972579199,
 41272,
 973289989,
 973160583,
 41275,
 -50684,
 973267716,
 41274,
 -1,
 973316073,
 41276,
 -50682,
 973267716,
 41271,
 -50681,
 973456084,
 41270,
 -1,
 973512681,
 41273,
 973683212,
 973181327,
 41286,
 -50678,
 973660932,
 41285,
 -50677,
 973718228,
 41284,
 -1,
 973774825,
 41287,
 973945360,
 973608308,
 41279,
 -50674,
 973923076,
 41278,
 -50673,
 973980372,
 41277,
 -1,
 974036969,
 41280,
 974258175,
 973881479,
 41289,
 -50670,
 974185220,
 41288,
 -1,
 974233577,
 41290,
 974404123,
 972541514,
 41238,
 974469654,
 974367060,
 41241,
 -1,
 974447364,
 41240,
 974600728,
 974426511,
 41228,
 -1,
 974578436,
 41227,
 -50663,
 974578436,
 41237,
 -50662,
 974701268,
 41236,
 -1,
 974757865,
 41239,
 974928418,
 974348671,
 41218,
 974993951,
 974864519,
 41221,
 -50658,
 974971652,
 41220,
 -1,
 975020009,
 41222,
 -50656,
 974971652,
 41217,
 -50655,
 975160020,
 41216,
 -1,
 975216617,
 41219,
 975387174,
 974885263,
 41231,
 -50652,
 975364868,
 41230,
 -50651,
 975422164,
 41229,
 -1,
 975478761,
 41232,
 975649322,
 975312244,
 41225,
 -50648,
 975627012,
 41224,
 -50647,
 975684308,
 41223,
 -1,
 975740905,
 41226,
 975962111,
 975585415,
 41234,
 -50644,
 975889156,
 41233,
 -1,
 975937513,
 41235,
 976108129,
 972466516,
 -1,
 976173639,
 976070996,
 -1,
 976239159,
 976145994,
 41866,
 976304690,
 976202068,
 41869,
 -1,
 976282372,
 41868,
 976435764,
 976261519,
 41855,
 -1,
 976413444,
 41854,
 -50635,
 976413444,
 41865,
 -50634,
 976536276,
 41864,
 -1,
 976592873,
 41867,
 976763453,
 976217070,
 41872,
 976828986,
 976726356,
 41875,
 -1,
 976806660,
 41874,
 -50629,
 976806660,
 41871,
 -50628,
 976929492,
 41870,
 -1,
 976986089,
 41873,
 977156673,
 976720271,
 41858,
 -50625,
 977134340,
 41857,
 -50624,
 977191636,
 41856,
 -1,
 977248233,
 41859,
 977418821,
 977092743,
 41862,
 -50621,
 977396484,
 41861,
 -50620,
 977453780,
 41860,
 -1,
 977510377,
 41863,
 977731583,
 977343860,
 41853,
 -1,
 977658628,
 41852,
 977812048,
 976145994,
 41942,
 977877579,
 977768847,
 41931,
 -50614,
 977855236,
 41930,
 -1,
 977903593,
 41932,
 978074189,
 977840468,
 41945,
 -1,
 978051844,
 41944,
 -50610,
 978051844,
 41941,
 -50609,
 978174676,
 41940,
 -1,
 978231273,
 41943,
 978401878,
 977789934,
 41948,
 978467411,
 978364756,
 41951,
 -1,
 978445060,
 41950,
 -50604,
 978445060,
 41947,
 -50603,
 978567892,
 41946,
 -1,
 978624489,
 41949,
 978795098,
 978358671,
 41935,
 -50600,
 978772740,
 41934,
 -50599,
 978830036,
 41933,
 -1,
 978886633,
 41936,
 979057246,
 978720116,
 41928,
 -50596,
 979034884,
 41927,
 -50595,
 979092180,
 41926,
 -1,
 979148777,
 41929,
 979369983,
 978993287,
 41938,
 -50592,
 979297028,
 41937,
 -1,
 979345385,
 41939,
 979516037,
 976057176,
 -1,
 979581548,
 979488330,
 41424,
 979647079,
 979538319,
 41413,
 -50587,
 979624708,
 41412,
 -50586,
 979682004,
 41411,
 -1,
 979738601,
 41414,
 979909225,
 979609940,
 41427,
 -1,
 979886852,
 41426,
 -50582,
 979886852,
 41423,
 -50581,
 980009684,
 41422,
 -1,
 980066281,
 41425,
 980236916,
 979526015,
 41401,
 980302449,
 980172935,
 41405,
 -50577,
 980280068,
 41404,
 -50576,
 980337364,
 41403,
 -1,
 980393961,
 41406,
 -50574,
 980280068,
 41400,
 -50573,
 980533972,
 41399,
 -1,
 980590569,
 41402,
 980761210,
 980214766,
 41430,
 980826743,
 980724052,
 41433,
 -1,
 980804356,
 41432,
 -50568,
 980804356,
 41429,
 -50567,
 980927188,
 41428,
 -1,
 980983785,
 41431,
 981154430,
 980717967,
 41417,
 -50564,
 981132036,
 41416,
 -50563,
 981189332,
 41415,
 -1,
 981245929,
 41418,
 981416578,
 981079412,
 41409,
 -50560,
 981394180,
 41408,
 -50559,
 981451476,
 41407,
 -1,
 981508073,
 41410,
 981729279,
 981352583,
 41420,
 -50556,
 981656324,
 41419,
 -1,
 981704681,
 41421,
 981875365,
 979490734,
 -1,
 981940878,
 981819775,
 41188,
 982006411,
 981876871,
 41192,
 -50551,
 981984004,
 41191,
 -50550,
 982041300,
 41190,
 -1,
 982097897,
 41193,
 -50548,
 981984004,
 41187,
 -50547,
 982237908,
 41186,
 -1,
 982294505,
 41189,
 982465172,
 981918702,
 41212,
 982530705,
 982427988,
 41215,
 -1,
 982508292,
 41214,
 -50542,
 982508292,
 41211,
 -50541,
 982631124,
 41210,
 -1,
 982687721,
 41213,
 982858394,
 982437450,
 41206,
 982923927,
 982821204,
 41209,
 -1,
 982901508,
 41208,
 -50536,
 982901508,
 41205,
 -50535,
 983024340,
 41204,
 -1,
 983080937,
 41207,
 983251614,
 982815119,
 41200,
 -50532,
 983229188,
 41199,
 -50531,
 983286484,
 41198,
 -1,
 983343081,
 41201,
 983513762,
 983176564,
 41196,
 -50528,
 983491332,
 41195,
 -50527,
 983548628,
 41194,
 -1,
 983605225,
 41197,
 983826431,
 983449735,
 -1,
 -50524,
 983753476,
 41202,
 -1,
 983801833,
 41203,
 983972548,
 981835753,
 -1,
 984038063,
 983944778,
 41036,
 984103594,
 983994767,
 41028,
 -50519,
 984081156,
 41027,
 -1,
 984129513,
 41029,
 984300204,
 984066388,
 41039,
 -1,
 984277764,
 41038,
 -50515,
 984277764,
 41035,
 -50514,
 984400596,
 41034,
 -1,
 984457193,
 41037,
 984627894,
 983982463,
 41018,
 984693427,
 984563847,
 41021,
 -50510,
 984670980,
 41020,
 -1,
 984719337,
 41022,
 -50508,
 984670980,
 41017,
 -50507,
 984859348,
 41016,
 -1,
 984915945,
 41019,
 985086652,
 984605678,
 41042,
 985152185,
 985049428,
 41045,
 -1,
 985129732,
 41044,
 -50502,
 985129732,
 41041,
 -50501,
 985252564,
 41040,
 -1,
 985309161,
 41043,
 985479872,
 985043343,
 41032,
 -50498,
 985457412,
 41031,
 -50497,
 985514708,
 41030,
 -1,
 985571305,
 41033,
 985792511,
 985404788,
 41025,
 -50494,
 985719556,
 41024,
 -50493,
 985776852,
 41023,
 -1,
 985833449,
 41026,
 986004193,
 983950318,
 -1,
 986069711,
 985976394,
 42115,
 986135242,
 986026383,
 42107,
 -50488,
 986112772,
 42106,
 -50487,
 986170068,
 42105,
 -1,
 986226665,
 42108,
 986397388,
 986098004,
 42118,
 -1,
 986374916,
 42117,
 -50483,
 986374916,
 42114,
 -50482,
 986497748,
 42113,
 -1,
 986554345,
 42116,
 986725079,
 986014079,
 42099,
 986790612,
 986660999,
 42103,
 -50478,
 986768132,
 42102,
 -50477,
 986825428,
 42101,
 -1,
 986882025,
 42104,
 -50475,
 986768132,
 42098,
 -50474,
 987022036,
 42097,
 -1,
 987078633,
 42100,
 987249373,
 986702830,
 42121,
 987314906,
 987212116,
 42124,
 -1,
 987292420,
 42123,
 -50469,
 987292420,
 42120,
 -50468,
 987415252,
 42119,
 -1,
 987471849,
 42122,
 987693055,
 987206031,
 42111,
 -50465,
 987620100,
 42110,
 -50464,
 987677396,
 42109,
 -1,
 987733993,
 42112,
 987904766,
 985973460,
 -1,
 987970284,
 987876938,
 41266,
 988035815,
 987926927,
 41255,
 -50459,
 988013316,
 41254,
 -50458,
 988070612,
 41253,
 -1,
 988127209,
 41256,
 988297961,
 987998548,
 41269,
 -1,
 988275460,
 41268,
 -50454,
 988275460,
 41265,
 -50453,
 988398292,
 41264,
 -1,
 988454889,
 41267,
 988625651,
 987914623,
 41244,
 988691184,
 988561543,
 41247,
 -50449,
 988668676,
 41246,
 -1,
 988717033,
 41248,
 -50447,
 988668676,
 41243,
 -50446,
 988857044,
 41242,
 -1,
 988913641,
 41245,
 989084407,
 988582287,
 41259,
 -50443,
 989061892,
 41258,
 -50442,
 989119188,
 41257,
 -1,
 989175785,
 41260,
 989346555,
 989009268,
 41251,
 -50439,
 989324036,
 41250,
 -50438,
 989381332,
 41249,
 -1,
 989437929,
 41252,
 989659135,
 989282439,
 41262,
 -50435,
 989586180,
 41261,
 -1,
 989634537,
 41263,
 989805339,
 987866948,
 -1,
 989870857,
 989777482,
 41998,
 989936388,
 989827471,
 41990,
 -50430,
 989913860,
 41989,
 -50429,
 989971156,
 41988,
 -1,
 990027753,
 41991,
 990198534,
 989899092,
 42001,
 -1,
 990176004,
 42000,
 -50425,
 990176004,
 41997,
 -50424,
 990298836,
 41996,
 -1,
 990355433,
 41999,
 990526225,
 989815167,
 41982,
 990591758,
 990462087,
 41986,
 -50420,
 990569220,
 41985,
 -50419,
 990626516,
 41984,
 -1,
 990683113,
 41987,
 -50417,
 990569220,
 41981,
 -50416,
 990823124,
 41980,
 -1,
 990879721,
 41983,
 991050519,
 990503918,
 42004,
 991116052,
 991013204,
 42007,
 -1,
 991093508,
 42006,
 -50411,
 991093508,
 42003,
 -50410,
 991216340,
 42002,
 -1,
 991272937,
 42005,
 991494143,
 991007119,
 41994,
 -50407,
 991421188,
 41993,
 -50406,
 991478484,
 41992,
 -1,
 991535081,
 41995,
 991705912,
 989753480,
 -1,
 991771429,
 991678026,
 41488,
 991836960,
 991728015,
 41476,
 -50401,
 991814404,
 41475,
 -1,
 991862761,
 41477,
 992033570,
 991799636,
 41491,
 -1,
 992011012,
 41490,
 -50397,
 992011012,
 41487,
 -50396,
 992133844,
 41486,
 -1,
 992190441,
 41489,
 992361260,
 991715711,
 41466,
 992426793,
 992297095,
 41469,
 -50392,
 992404228,
 41468,
 -1,
 992452585,
 41470,
 -50390,
 992404228,
 41465,
 -50389,
 992592596,
 41464,
 -1,
 992649193,
 41467,
 992820016,
 992317839,
 41480,
 -50386,
 992797444,
 41479,
 -50385,
 992854740,
 41478,
 -1,
 992911337,
 41481,
 993082164,
 992755847,
 41484,
 -50382,
 993059588,
 41483,
 -50381,
 993116884,
 41482,
 -1,
 993173481,
 41485,
 993394687,
 993006964,
 41473,
 -50378,
 993321732,
 41472,
 -50377,
 993379028,
 41471,
 -1,
 993435625,
 41474,
 993606478,
 991645270,
 -1,
 993671999,
 993578570,
 41178,
 993737532,
 993634644,
 41181,
 -1,
 993714948,
 41180,
 -50371,
 993714948,
 41177,
 -50370,
 993837780,
 41176,
 -1,
 993894377,
 41179,
 994065219,
 993649646,
 41184,
 -50367,
 994042628,
 41183,
 -50366,
 994099924,
 41182,
 -1,
 994156521,
 41185,
 994327367,
 994009471,
 41167,
 -50363,
 994304772,
 41166,
 -50362,
 994362068,
 41165,
 -1,
 994418665,
 41168,
 994589515,
 994252148,
 41171,
 -50359,
 994566916,
 41170,
 -50358,
 994624212,
 41169,
 -1,
 994680809,
 41172,
 994902015,
 994546063,
 41174,
 -50355,
 994829060,
 41173,
 -1,
 994877417,
 41175,
 995048291,
 993583876,
 -1,
 995113815,
 994992511,
 42079,
 995179348,
 995049607,
 42083,
 -50350,
 995156740,
 42082,
 -50349,
 995214036,
 42081,
 -1,
 995270633,
 42084,
 -50347,
 995156740,
 42078,
 -50346,
 995410644,
 42077,
 -1,
 995467241,
 42080,
 995638109,
 995091438,
 42093,
 995703642,
 995600724,
 42096,
 -1,
 995681028,
 42095,
 -50341,
 995681028,
 42092,
 -50340,
 995803860,
 42091,
 -1,
 995860457,
 42094,
 996031329,
 995594639,
 42089,
 -50337,
 996008708,
 42088,
 -50336,
 996066004,
 42087,
 -1,
 996122601,
 42090,
 996343807,
 996004596,
 42086,
 -1,
 996270852,
 42085,
 996424562,
 995024136,
 -1,
 996490088,
 996396618,
 40981,
 996605951,
 996446607,
 41605,
 -50329,
 996532996,
 41604,
 -1,
 996581353,
 41606,
 996752236,
 996414836,
 41602,
 -50326,
 996729604,
 41601,
 -50325,
 996786900,
 41600,
 -1,
 996843497,
 41603,
 997014383,
 996708751,
 41608,
 -50322,
 996991748,
 41607,
 -1,
 997040105,
 41609,
 997261311,
 996950151,
 41611,
 -50319,
 997188356,
 41610,
 -1,
 997236713,
 41612,
 997407610,
 996368767,
 40962,
 997473143,
 997343367,
 40966,
 -50315,
 997450500,
 40965,
 -50314,
 997507796,
 40964,
 -1,
 997564393,
 40967,
 -50312,
 997450500,
 40961,
 -50311,
 997704404,
 40960,
 -1,
 997761001,
 40963,
 997931902,
 997364111,
 40977,
 -50308,
 997909252,
 40976,
 -50307,
 997966548,
 40975,
 -1,
 998023145,
 40978,
 998194050,
 997856628,
 40970,
 -50304,
 998171396,
 40969,
 -50303,
 998228692,
 40968,
 -1,
 998285289,
 40971,
 998456197,
 998167284,
 40973,
 -50300,
 998433540,
 40972,
 -1,
 998481897,
 40974,
 998703103,
 998391943,
 40980,
 -1,
 998630148,
 40979,
 998834175,
 919185908,
 -1,
 998849423,
 998714590,
 -1,
 998914956,
 998826990,
 42172,
 -50293,
 998884052,
 42147,
 -1,
 998940649,
 42132,
 -50291,
 998888192,
 42173,
 -50290,
 999058362,
 42174,
 -1,
 999119656,
 42179,
 999308182,
 998827806,
 -1,
 999373715,
 999280202,
 -1,
 -50286,
 999336276,
 42177,
 -1,
 999399401,
 42146,
 -50284,
 999352331,
 42180,
 -50283,
 999529034,
 42155,
 -1,
 999560564,
 42162,
 999766941,
 999274271,
 -1,
 999832476,
 999708811,
 -1,
 -50279,
 999810030,
 42160,
 -50278,
 999871871,
 42170,
 -50277,
 999921388,
 42178,
 -1,
 999957612,
 42176,
 -1,
 999799772,
 42133,
 1000225700,
 999707363,
 -1,
 1000291233,
 1000166115,
 -1,
 -50272,
 1000264436,
 42150,
 -1,
 1000314604,
 42134,
 -50270,
 1000249930,
 42166,
 -50269,
 1000425619,
 42135,
 -1,
 1000478068,
 42145,
 1000684458,
 1000179935,
 -1,
 1000749992,
 1000661998,
 -1,
 -50265,
 1000707820,
 42151,
 -1,
 1000762298,
 42131,
 -50263,
 1000728660,
 42164,
 -1,
 1000876372,
 42181,
 1001077680,
 1000632105,
 -1,
 1001143215,
 1001025321,
 -1,
 -50259,
 1001120750,
 42165,
 -50258,
 1001182985,
 42154,
 -1,
 1001219120,
 42167,
 -1,
 1001099663,
 42163,
 1001470902,
 1001019531,
 -1,
 1001536437,
 1001448196,
 -1,
 -50253,
 1001509620,
 42143,
 -50252,
 1001559788,
 42175,
 -1,
 1001614719,
 42137,
 -1,
 1001489972,
 42157,
 1001864122,
 1001419608,
 -1,
 1001929657,
 1001808255,
 42129,
 -1,
 1001865351,
 42171,
 -1,
 1001907858,
 42138,
 1002126269,
 1001841646,
 -1,
 -50244,
 1002082703,
 42141,
 -1,
 1002139007,
 42158,
 1002322880,
 1002100654,
 -1,
 -50241,
 1002296703,
 42159,
 -1,
 1002326163,
 42161,
 1002519491,
 1002291924,
 -1,
 -50238,
 1002491466,
 42152,
 -1,
 1002513516,
 42144,
 1002716102,
 1002479593,
 -1,
 -50235,
 1002694356,
 42156,
 -1,
 1002755849,
 42142,
 1002912713,
 1002668005,
 -1,
 -50232,
 1002870508,
 42140,
 -1,
 1002922367,
 42136,
 1003109324,
 1002860680,
 -1,
 -50229,
 1003056511,
 42130,
 -1,
 1003110535,
 42182,
 1003305935,
 1003042336,
 -1,
 -50226,
 1003277898,
 42169,
 -1,
 1003307094,
 42148,
 1003502546,
 1003234934,
 -1,
 -50223,
 1003476351,
 42149,
 -1,
 1003498591,
 42139,
 -50221,
 1003479439,
 42168,
 -50220,
 1003661245,
 42128,
 -1,
 1003722476,
 42153,
 -1,
 919111955,
 9775,
 -1,
 919029536,
 165,
 1004028395,
 918955638,
 -1,
 1004092639,
 1003989332,
 -1,
 1004158171,
 1004017997,
 -1,
 1004223706,
 1004092378,
 -1,
 1004289115,
 1004147215,
 10241,
 1004354588,
 1004212903,
 10243,
 1004420093,
 1004278604,
 10247,
 1004485614,
 1004344252,
 10255,
 1004551143,
 1004409865,
 10271,
 1004616676,
 1004475521,
 10303,
 1004682211,
 1004541126,
 10367,
 -1,
 1004606733,
 10495,
 -1,
 1004606733,
 10431,
 1004878822,
 1004541126,
 10335,
 -1,
 1004803341,
 10463,
 -1,
 1004803341,
 10399,
 1005075435,
 1004475521,
 10287,
 1005140970,
 1004999878,
 10351,
 -1,
 1005065485,
 10479,
 -1,
 1005065485,
 10415,
 1005337581,
 1004999878,
 10319,
 -1,
 1005262093,
 10447,
 -1,
 1005262093,
 10383,
 1005534198,
 1004409865,
 10263,
 1005599731,
 1005458561,
 10295,
 1005665266,
 1005524166,
 10359,
 -1,
 1005589773,
 10487,
 -1,
 1005589773,
 10423,
 1005861877,
 1005524166,
 10327,
 -1,
 1005786381,
 10455,
 -1,
 1005786381,
 10391,
 1006058490,
 1005458561,
 10279,
 1006124025,
 1005982918,
 10343,
 -1,
 1006048525,
 10471,
 -1,
 1006048525,
 10407,
 1006320636,
 1005982918,
 10311,
 -1,
 1006245133,
 10439,
 -1,
 1006245133,
 10375,
 1006517261,
 1004344252,
 10251,
 1006582790,
 1006441481,
 10267,
 1006648323,
 1006507137,
 10299,
 1006713858,
 1006572742,
 10363,
 -1,
 1006638349,
 10491,
 -1,
 1006638349,
 10427,
 1006910469,
 1006572742,
 10331,
 -1,
 1006834957,
 10459,
 -1,
 1006834957,
 10395,
 1007107082,
 1006507137,
 10283,
 1007172617,
 1007031494,
 10347,
 -1,
 1007097101,
 10475,
 -1,
 1007097101,
 10411,
 1007369228,
 1007031494,
 10315,
 -1,
 1007293709,
 10443,
 -1,
 1007293709,
 10379,
 1007565845,
 1006441481,
 10259,
 1007631378,
 1007490177,
 10291,
 1007696913,
 1007555782,
 10355,
 -1,
 1007621389,
 10483,
 -1,
 1007621389,
 10419,
 1007893524,
 1007555782,
 10323,
 -1,
 1007817997,
 10451,
 -1,
 1007817997,
 10387,
 1008090137,
 1007490177,
 10275,
 1008155672,
 1008014534,
 10339,
 -1,
 1008080141,
 10467,
 -1,
 1008080141,
 10403,
 1008352283,
 1008014534,
 10307,
 -1,
 1008276749,
 10435,
 -1,
 1008276749,
 10371,
 1008548924,
 1004278604,
 10245,
 1008614445,
 1008473020,
 10253,
 1008679974,
 1008538633,
 10269,
 1008745507,
 1008604289,
 10301,
 1008811042,
 1008669894,
 10365,
 -1,
 1008735501,
 10493,
 -1,
 1008735501,
 10429,
 1009007653,
 1008669894,
 10333,
 -1,
 1008932109,
 10461,
 -1,
 1008932109,
 10397,
 1009204266,
 1008604289,
 10285,
 1009269801,
 1009128646,
 10349,
 -1,
 1009194253,
 10477,
 -1,
 1009194253,
 10413,
 1009466412,
 1009128646,
 10317,
 -1,
 1009390861,
 10445,
 -1,
 1009390861,
 10381,
 1009663029,
 1008538633,
 10261,
 1009728562,
 1009587329,
 10293,
 1009794097,
 1009652934,
 10357,
 -1,
 1009718541,
 10485,
 -1,
 1009718541,
 10421,
 1009990708,
 1009652934,
 10325,
 -1,
 1009915149,
 10453,
 -1,
 1009915149,
 10389,
 1010187321,
 1009587329,
 10277,
 1010252856,
 1010111686,
 10341,
 -1,
 1010177293,
 10469,
 -1,
 1010177293,
 10405,
 1010449467,
 1010111686,
 10309,
 -1,
 1010373901,
 10437,
 -1,
 1010373901,
 10373,
 1010646092,
 1008473020,
 10249,
 1010711621,
 1010570249,
 10265,
 1010777154,
 1010635905,
 10297,
 1010842689,
 1010701510,
 10361,
 -1,
 1010767117,
 10489,
 -1,
 1010767117,
 10425,
 1011039300,
 1010701510,
 10329,
 -1,
 1010963725,
 10457,
 -1,
 1010963725,
 10393,
 1011235913,
 1010635905,
 10281,
 1011301448,
 1011160262,
 10345,
 -1,
 1011225869,
 10473,
 -1,
 1011225869,
 10409,
 1011498059,
 1011160262,
 10313,
 -1,
 1011422477,
 10441,
 -1,
 1011422477,
 10377,
 1011694676,
 1010570249,
 10257,
 1011760209,
 1011618945,
 10289,
 1011825744,
 1011684550,
 10353,
 -1,
 1011750157,
 10481,
 -1,
 1011750157,
 10417,
 1012022355,
 1011684550,
 10321,
 -1,
 1011946765,
 10449,
 -1,
 1011946765,
 10385,
 1012218968,
 1011618945,
 10273,
 1012284503,
 1012143302,
 10337,
 -1,
 1012208909,
 10465,
 -1,
 1012208909,
 10401,
 1012481114,
 1012143302,
 10305,
 -1,
 1012405517,
 10433,
 -1,
 1012405517,
 10369,
 1012677787,
 1004212903,
 10242,
 1012743292,
 1012601676,
 10246,
 1012808813,
 1012667324,
 10254,
 1012874342,
 1012732937,
 10270,
 1012939875,
 1012798593,
 10302,
 1013005410,
 1012864198,
 10366,
 -1,
 1012929805,
 10494,
 -1,
 1012929805,
 10430,
 1013202021,
 1012864198,
 10334,
 -1,
 1013126413,
 10462,
 -1,
 1013126413,
 10398,
 1013398634,
 1012798593,
 10286,
 1013464169,
 1013322950,
 10350,
 -1,
 1013388557,
 10478,
 -1,
 1013388557,
 10414,
 1013660780,
 1013322950,
 10318,
 -1,
 1013585165,
 10446,
 -1,
 1013585165,
 10382,
 1013857397,
 1012732937,
 10262,
 1013922930,
 1013781633,
 10294,
 1013988465,
 1013847238,
 10358,
 -1,
 1013912845,
 10486,
 -1,
 1013912845,
 10422,
 1014185076,
 1013847238,
 10326,
 -1,
 1014109453,
 10454,
 -1,
 1014109453,
 10390,
 1014381689,
 1013781633,
 10278,
 1014447224,
 1014305990,
 10342,
 -1,
 1014371597,
 10470,
 -1,
 1014371597,
 10406,
 1014643835,
 1014305990,
 10310,
 -1,
 1014568205,
 10438,
 -1,
 1014568205,
 10374,
 1014840460,
 1012667324,
 10250,
 1014905989,
 1014764553,
 10266,
 1014971522,
 1014830209,
 10298,
 1015037057,
 1014895814,
 10362,
 -1,
 1014961421,
 10490,
 -1,
 1014961421,
 10426,
 1015233668,
 1014895814,
 10330,
 -1,
 1015158029,
 10458,
 -1,
 1015158029,
 10394,
 1015430281,
 1014830209,
 10282,
 1015495816,
 1015354566,
 10346,
 -1,
 1015420173,
 10474,
 -1,
 1015420173,
 10410,
 1015692427,
 1015354566,
 10314,
 -1,
 1015616781,
 10442,
 -1,
 1015616781,
 10378,
 1015889044,
 1014764553,
 10258,
 1015954577,
 1015813249,
 10290,
 1016020112,
 1015878854,
 10354,
 -1,
 1015944461,
 10482,
 -1,
 1015944461,
 10418,
 1016216723,
 1015878854,
 10322,
 -1,
 1016141069,
 10450,
 -1,
 1016141069,
 10386,
 1016413336,
 1015813249,
 10274,
 1016478871,
 1016337606,
 10338,
 -1,
 1016403213,
 10466,
 -1,
 1016403213,
 10402,
 1016675482,
 1016337606,
 10306,
 -1,
 1016599821,
 10434,
 -1,
 1016599821,
 10370,
 1016872123,
 1012601676,
 10244,
 1016937644,
 1016796092,
 10252,
 1017003173,
 1016861705,
 10268,
 1017068706,
 1016927361,
 10300,
 1017134241,
 1016992966,
 10364,
 -1,
 1017058573,
 10492,
 -1,
 1017058573,
 10428,
 1017330852,
 1016992966,
 10332,
 -1,
 1017255181,
 10460,
 -1,
 1017255181,
 10396,
 1017527465,
 1016927361,
 10284,
 1017593000,
 1017451718,
 10348,
 -1,
 1017517325,
 10476,
 -1,
 1017517325,
 10412,
 1017789611,
 1017451718,
 10316,
 -1,
 1017713933,
 10444,
 -1,
 1017713933,
 10380,
 1017986228,
 1016861705,
 10260,
 1018051761,
 1017910401,
 10292,
 1018117296,
 1017976006,
 10356,
 -1,
 1018041613,
 10484,
 -1,
 1018041613,
 10420,
 1018313907,
 1017976006,
 10324,
 -1,
 1018238221,
 10452,
 -1,
 1018238221,
 10388,
 1018510520,
 1017910401,
 10276,
 1018576055,
 1018434758,
 10340,
 -1,
 1018500365,
 10468,
 -1,
 1018500365,
 10404,
 1018772666,
 1018434758,
 10308,
 -1,
 1018696973,
 10436,
 -1,
 1018696973,
 10372,
 1018969291,
 1016796092,
 10248,
 1019034820,
 1018893321,
 10264,
 1019100353,
 1018958977,
 10296,
 1019165888,
 1019024582,
 10360,
 -1,
 1019090189,
 10488,
 -1,
 1019090189,
 10424,
 1019362499,
 1019024582,
 10328,
 -1,
 1019286797,
 10456,
 -1,
 1019286797,
 10392,
 1019559112,
 1018958977,
 10280,
 1019624647,
 1019483334,
 10344,
 -1,
 1019548941,
 10472,
 -1,
 1019548941,
 10408,
 1019821258,
 1019483334,
 10312,
 -1,
 1019745549,
 10440,
 -1,
 1019745549,
 10376,
 1020017875,
 1018893321,
 10256,
 1020083408,
 1019942017,
 10288,
 1020148943,
 1020007622,
 10352,
 -1,
 1020073229,
 10480,
 -1,
 1020073229,
 10416,
 1020345554,
 1020007622,
 10320,
 -1,
 1020269837,
 10448,
 -1,
 1020269837,
 10384,
 1020542167,
 1019942017,
 10272,
 1020607702,
 1020466374,
 10336,
 -1,
 1020531981,
 10464,
 -1,
 1020531981,
 10400,
 1020804313,
 1020466374,
 10304,
 -1,
 1020728589,
 10432,
 -1,
 1020728589,
 10368,
 -1,
 1004153469,
 10240,
 1021066462,
 1004114932,
 -1,
 -49955,
 1020997727,
 9099,
 -1,
 1021060942,
 166,
 -1,
 1021004926,
 728,
 1021328991,
 1004070661,
 -1,
 1021394193,
 1021252980,
 -1,
 1021459699,
 1021353961,
 -1,
 1021525231,
 1021415823,
 -1,
 1021590763,
 1021493497,
 -1,
 1021656296,
 1021556511,
 118801,
 1021771775,
 1021575168,
 -1,
 -49945,
 1021676409,
 118865,
 -1,
 1021721071,
 118802,
 1021968383,
 1021600129,
 -1,
 -49942,
 1021887754,
 118957,
 -1,
 1021952681,
 118866,
 1022115054,
 1021523971,
 -1,
 -49939,
 1022069625,
 118916,
 -1,
 1022107990,
 118818,
 -1,
 1022084738,
 118819,
 1022377202,
 1021463239,
 -1,
 -49935,
 1022354364,
 118835,
 -1,
 1022390777,
 118797,
 -1,
 1022327408,
 118917,
 1022639359,
 1021421908,
 -1,
 1022704892,
 1022587650,
 -1,
 -49930,
 1022683205,
 119022,
 -49929,
 1022745729,
 119018,
 -49928,
 1022795854,
 119017,
 -49927,
 1022856307,
 119023,
 -49926,
 1022915000,
 119021,
 -49925,
 1022972676,
 119019,
 -1,
 1023031435,
 119020,
 1023279103,
 1022645789,
 -1,
 -49922,
 1023197879,
 118899,
 -1,
 1023248607,
 118935,
 1023425804,
 1022580268,
 -1,
 1023491331,
 1023386941,
 -1,
 -49918,
 1023432279,
 118945,
 -1,
 1023484342,
 118938,
 1023687942,
 1023443739,
 -1,
 -49915,
 1023658741,
 118941,
 -1,
 1023720412,
 118942,
 1023884553,
 1023628882,
 -1,
 -49912,
 1023842994,
 118944,
 -1,
 1023893887,
 118943,
 1024131071,
 1023811983,
 -1,
 -49909,
 1024039602,
 118939,
 -1,
 1024090495,
 118940,
 1024327679,
 1023379679,
 -1,
 1024343312,
 1024247785,
 -1,
 -49905,
 1024294962,
 118876,
 -1,
 1024357200,
 118882,
 -1,
 1024271715,
 118824,
 1024605500,
 1021341832,
 -1,
 1024671008,
 1024542754,
 -1,
 1024736538,
 1024639765,
 118800,
 1024851967,
 1024655360,
 -1,
 1024867609,
 1024756605,
 -1,
 -49897,
 1024820285,
 119024,
 -49896,
 1024881025,
 119026,
 -1,
 1024925437,
 118862,
 -1,
 1024794966,
 118812,
 1025245183,
 1024655360,
 -1,
 1025260831,
 1025149821,
 -1,
 -49891,
 1025213501,
 119025,
 -49890,
 1025274241,
 119027,
 -1,
 1025318653,
 118863,
 -1,
 1025188182,
 118811,
 1025588525,
 1024633172,
 -1,
 1025654060,
 1025516822,
 -1,
 1025719593,
 1025578356,
 -1,
 1025785128,
 1025638400,
 -1,
 1025850663,
 1025709428,
 -1,
 -49882,
 1025813306,
 118913,
 -1,
 1025866902,
 118914,
 -1,
 1025805177,
 118915,
 -1,
 1025753877,
 118834,
 1026228223,
 1025675663,
 -1,
 -49877,
 1026156156,
 118868,
 -1,
 1026192089,
 118860,
 -1,
 1025590867,
 118796,
 1026440498,
 1025544591,
 -1,
 1026506032,
 1026396049,
 118842,
 -1,
 1026424904,
 118850,
 -49871,
 1026478115,
 118858,
 -1,
 1026602061,
 118921,
 1026768182,
 1026389392,
 118820,
 1026883583,
 1026686976,
 -1,
 -49867,
 1026781569,
 119028,
 -1,
 1026825981,
 118911,
 1027030331,
 1026696300,
 -1,
 1027095866,
 1026958808,
 -1,
 -49863,
 1027063176,
 118906,
 -1,
 1027083196,
 118839,
 -1,
 1027038673,
 118791,
 -1,
 1027007974,
 118881,
 1027423579,
 1024571167,
 -1,
 1027489098,
 1027368589,
 -1,
 1027554628,
 1027458713,
 119006,
 1027670015,
 1027473408,
 -1,
 1027685699,
 1027588820,
 -1,
 -49854,
 1027650221,
 119008,
 -1,
 1027689475,
 119009,
 -1,
 1027619396,
 119007,
 1027997695,
 1027482284,
 119010,
 1028063231,
 1027866624,
 -1,
 1028078921,
 1027982036,
 -1,
 -49848,
 1028043437,
 119012,
 -1,
 1028082691,
 119013,
 -1,
 1028012612,
 119011,
 1028341075,
 1027466222,
 -1,
 1028406609,
 1028294879,
 -1,
 1028472144,
 1028331739,
 -1,
 -49842,
 1028426617,
 118885,
 -49841,
 1028490320,
 118827,
 -1,
 1028530518,
 118826,
 -1,
 1028410712,
 118803,
 1028849663,
 1028371300,
 118886,
 -1,
 1028769783,
 118792,
 1028930904,
 1028309716,
 -1,
 1028996438,
 1028859398,
 118910,
 -1,
 1028915670,
 118815,
 -49833,
 1028958739,
 118852,
 -1,
 1029072256,
 119016,
 1029258586,
 1028867474,
 118825,
 -1,
 1029178893,
 118889,
 -1,
 1029187120,
 118813,
 1029455228,
 1027383273,
 -1,
 1029520742,
 1029422044,
 -1,
 1029586275,
 1029460137,
 -1,
 1029651808,
 1029540063,
 118841,
 -1,
 1029572109,
 118874,
 -49823,
 1029620385,
 118897,
 -49822,
 1029742862,
 118895,
 -1,
 1029799901,
 118892,
 1030029311,
 1029534552,
 -1,
 -49819,
 1029936429,
 118807,
 -1,
 1029988735,
 118784,
 1030176111,
 1029456007,
 -1,
 1030241644,
 1030145093,
 -1,
 1030307179,
 1030210260,
 -1,
 -49814,
 1030263808,
 118859,
 -1,
 1030316415,
 118857,
 -1,
 1030258738,
 118849,
 1030569326,
 1030190486,
 118840,
 -1,
 1030489613,
 118861,
 -1,
 1030533892,
 118786,
 1030765945,
 1030103132,
 -1,
 1030831480,
 1030691264,
 -1,
 1030897013,
 1030781890,
 118793,
 1031012351,
 1030815744,
 -1,
 -49804,
 1030916985,
 118878,
 -1,
 1030955350,
 118846,
 1031208959,
 1030822716,
 -1,
 -49801,
 1031113593,
 118879,
 -1,
 1031151958,
 118845,
 -1,
 1030775551,
 118814,
 1031471103,
 1030709959,
 -1,
 -49797,
 1031375737,
 118873,
 -1,
 1031414102,
 118822,
 1031617946,
 1029394006,
 -1,
 1031683477,
 1031587606,
 -1,
 1031749000,
 1031616835,
 -1,
 1031814532,
 1031702751,
 -1,
 1031880067,
 1031758209,
 -1,
 -49790,
 1031827841,
 118977,
 -1,
 1031872253,
 118978,
 -1,
 1031806285,
 118971,
 -49787,
 1031792709,
 118976,
 -49786,
 1032101966,
 118970,
 -49785,
 1032155576,
 118975,
 -1,
 1032206475,
 118973,
 1032404363,
 1031716186,
 -1,
 -49782,
 1032337742,
 118974,
 -1,
 1032400878,
 118982,
 1032600974,
 1032358111,
 -1,
 -49779,
 1032537896,
 118983,
 -1,
 1032593312,
 118972,
 1032797585,
 1032552681,
 -1,
 -49776,
 1032750783,
 118980,
 -1,
 1032796529,
 118979,
 1032994195,
 1032724822,
 118836,
 -1,
 1032913692,
 118969,
 -49772,
 1032937960,
 118987,
 -1,
 1033062203,
 118988,
 1033256345,
 1031609942,
 -1,
 -49769,
 1033225726,
 118958,
 -49768,
 1033275071,
 118959,
 -1,
 1033320817,
 118960,
 -1,
 1033199856,
 118981,
 1033584058,
 1031550496,
 -1,
 1033649592,
 1033527679,
 -1,
 1033715109,
 1033587381,
 -1,
 1033780642,
 1033683668,
 -1,
 1033846177,
 1033743865,
 -1,
 -49760,
 1033816221,
 118990,
 -1,
 1033852576,
 118995,
 -1,
 1033784246,
 118991,
 -49757,
 1033733845,
 118993,
 -49756,
 1034041770,
 118994,
 -1,
 1034100725,
 118992,
 1034304941,
 1033655011,
 -1,
 1034370476,
 1034262727,
 118930,
 1034485759,
 1034291297,
 -1,
 1034501547,
 1034363351,
 -1,
 -49750,
 1034449281,
 118931,
 -1,
 1034493693,
 118932,
 -1,
 1034434623,
 118933,
 -1,
 1034332818,
 119014,
 1034829237,
 1034229108,
 -1,
 1034894772,
 1034797238,
 -1,
 1034960306,
 1034821639,
 -1,
 -49743,
 1034905027,
 119002,
 -1,
 1034962084,
 119003,
 -49741,
 1034929817,
 119005,
 -1,
 1035090415,
 119004,
 -1,
 1034857952,
 118937,
 1035353527,
 1034789922,
 118918,
 -1,
 1035272672,
 118912,
 -1,
 1035293349,
 119015,
 -49735,
 1033627178,
 118831,
 -1,
 1035477830,
 118785,
 1035681241,
 1033552596,
 -1,
 1035746763,
 1035643220,
 -1,
 1035812295,
 1035703545,
 -1,
 1035877826,
 1035765985,
 -1,
 1035943361,
 1035801972,
 -1,
 -49728,
 1035905850,
 118838,
 -1,
 1035959446,
 118851,
 -1,
 1035897721,
 118883,
 1036205509,
 1035837417,
 -1,
 -49724,
 1036172309,
 118891,
 -1,
 1036198118,
 118894,
 -49722,
 1036173985,
 118896,
 -1,
 1036353501,
 118893,
 1036582911,
 1035755903,
 -1,
 -49719,
 1036493858,
 118919,
 -49718,
 1036539485,
 118934,
 -1,
 1036588404,
 118832,
 1036795348,
 1035688075,
 -1,
 1036860883,
 1036730503,
 -1,
 1036926418,
 1036812338,
 118829,
 1036991953,
 1036896507,
 -1,
 -49712,
 1036968874,
 118903,
 -1,
 1037024885,
 118902,
 -1,
 1036911054,
 118904,
 -1,
 1036891996,
 118905,
 -1,
 1036807558,
 118804,
 1037385176,
 1036730503,
 -1,
 -49706,
 1037355720,
 118920,
 -49705,
 1037418480,
 118833,
 -1,
 1037465800,
 118799,
 -1,
 1037330369,
 118823,
 1037712880,
 1035632613,
 -1,
 1037778415,
 1037640421,
 -1,
 1037843938,
 1037746900,
 -1,
 1037909471,
 1037807097,
 -1,
 -49698,
 1037879940,
 118950,
 -1,
 1037914491,
 118951,
 1038155775,
 1037847491,
 -1,
 -49695,
 1038055610,
 118953,
 -1,
 1038115589,
 118952,
 1038302697,
 1037803497,
 -1,
 1038368230,
 1038267613,
 -1,
 -49691,
 1038342336,
 118962,
 -1,
 1038399307,
 118946,
 1038614527,
 1038316681,
 -1,
 -49688,
 1038534127,
 118963,
 -1,
 1038574341,
 118955,
 1038761452,
 1038228459,
 -1,
 -49685,
 1038722750,
 118947,
 -1,
 1038760005,
 118949,
 -49683,
 1038735552,
 118961,
 -49682,
 1038907578,
 118954,
 -1,
 1038956613,
 118948,
 -1,
 1037723080,
 118871,
 1039220226,
 1037689838,
 -1,
 1039285756,
 1039159078,
 -1,
 1039351289,
 1039252751,
 -1,
 1039416822,
 1039321841,
 -1,
 -49675,
 1039386781,
 118989,
 -1,
 1039423136,
 118999,
 -49673,
 1039369941,
 118997,
 -49672,
 1039546794,
 118998,
 -1,
 1039605749,
 118996,
 1039859711,
 1039304929,
 -1,
 -49669,
 1039757697,
 118908,
 -1,
 1039802109,
 118909,
 1040056319,
 1039245289,
 -1,
 1040072193,
 1039962511,
 -1,
 1040137728,
 1040020194,
 118794,
 -1,
 1040057173,
 118795,
 -1,
 1040102829,
 118867,
 -1,
 1040039034,
 118864,
 1040399893,
 1039160035,
 -1,
 1040465425,
 1040357366,
 -1,
 1040530958,
 1040406045,
 -1,
 1040596493,
 1040484577,
 -1,
 1040662025,
 1040556359,
 -1,
 -49656,
 1040595007,
 118929,
 -1,
 1040654798,
 118928,
 1040858636,
 1040616317,
 -1,
 -49653,
 1040806273,
 119029,
 -1,
 1040850685,
 118927,
 -1,
 1040785750,
 118806,
 -1,
 1040564919,
 118898,
 1041235967,
 1040500469,
 -1,
 -49648,
 1041119733,
 118965,
 -1,
 1041178638,
 118964,
 1041382932,
 1040402350,
 -1,
 -49645,
 1041360226,
 119001,
 -1,
 1041381738,
 119000,
 -1,
 1041347667,
 118853,
 1041645091,
 1040355727,
 -1,
 1041710620,
 1041621870,
 -1,
 1041776155,
 1041629184,
 -1,
 -49639,
 1041730425,
 118856,
 -49638,
 1041778098,
 118787,
 -1,
 1041840623,
 118788,
 -1,
 1041719684,
 118816,
 1042103839,
 1041688213,
 -1,
 -49634,
 1042058105,
 118901,
 -1,
 1042096470,
 118828,
 1042300450,
 1042053840,
 -1,
 -49631,
 1042254713,
 118855,
 -1,
 1042293078,
 118805,
 -1,
 1042252272,
 118875,
 1042562609,
 1041588607,
 -1,
 1042628139,
 1042515089,
 -1,
 1042693674,
 1042566742,
 -1,
 1042759209,
 1042663185,
 -1,
 -49624,
 1042715949,
 118968,
 -1,
 1042748788,
 118837,
 -1,
 1042716266,
 118967,
 -1,
 1042626875,
 118936,
 1043086896,
 1042593567,
 -1,
 1043152431,
 1043043632,
 -1,
 -49618,
 1043106681,
 118854,
 -1,
 1043145046,
 118810,
 -1,
 1043077582,
 118956,
 -1,
 1043017534,
 118847,
 1043480124,
 1042497671,
 -1,
 1043545653,
 1043449291,
 -1,
 -49612,
 1043505422,
 118880,
 -1,
 1043538363,
 118900,
 1043742264,
 1043499231,
 -1,
 -49609,
 1043675878,
 118907,
 -1,
 1043735282,
 118966,
 -49607,
 1043719085,
 118798,
 -49606,
 1043898864,
 118888,
 -49605,
 1043952703,
 118869,
 -1,
 1044017900,
 118884,
 1044201031,
 1043428184,
 -1,
 1044266566,
 1044136071,
 -1,
 1044332101,
 1044211443,
 -1,
 1044397634,
 1044300500,
 -1,
 -49599,
 1044361745,
 118924,
 -1,
 1044400882,
 118925,
 -49597,
 1044342499,
 118926,
 -49596,
 1044531125,
 118922,
 -1,
 1044594807,
 118923,
 -1,
 1044285096,
 118830,
 -1,
 1044243817,
 118877,
 1044921938,
 1044131618,
 -1,
 1044987468,
 1044886487,
 -1,
 -49590,
 1044965473,
 118984,
 -49589,
 1045020434,
 118986,
 -1,
 1045066358,
 118985,
 1045249615,
 1044945087,
 -1,
 -49586,
 1045203833,
 118887,
 -1,
 1045242198,
 118843,
 1045495807,
 1045175520,
 -1,
 -49583,
 1045402925,
 118808,
 -1,
 1045455231,
 118870,
 1045642842,
 1044895676,
 -1,
 1045708377,
 1045605568,
 -1,
 1045773912,
 1045626880,
 -1,
 -49578,
 1045728121,
 118872,
 -49577,
 1045775794,
 118789,
 -1,
 1045838319,
 118790,
 -1,
 1045717380,
 118817,
 -1,
 1045678006,
 118809,
 1046167133,
 1045604692,
 -1,
 -49572,
 1046105432,
 118821,
 -1,
 1046159303,
 118844,
 -49570,
 1046143901,
 118890,
 -1,
 1046317449,
 118848,
 1046495101,
 1021252980,
 -1,
 1046560519,
 1046442840,
 -1,
 1046626047,
 1046505632,
 -1,
 1046691490,
 1046575578,
 -1,
 1046756970,
 1046659796,
 -1,
 1046822505,
 1046680948,
 6946,
 1046937599,
 1046740992,
 -1,
 -49561,
 1046856802,
 6947,
 -49560,
 1046906987,
 6942,
 -1,
 1046967741,
 6941,
 -1,
 1046800439,
 6983,
 1047215727,
 1046710495,
 -1,
 1047281261,
 1047139700,
 6950,
 -1,
 1047202219,
 6945,
 -49554,
 1047258154,
 6940,
 -1,
 1047352068,
 6935,
 1047543412,
 1047163016,
 -1,
 1047608947,
 1047467380,
 6931,
 -49550,
 1047547514,
 6981,
 -1,
 1047594429,
 6932,
 -1,
 1047551984,
 6982,
 1047871098,
 1047475851,
 6948,
 1047986175,
 1047791034,
 -1,
 1048002169,
 1047909847,
 -1,
 -49544,
 1047953526,
 6944,
 -1,
 1047993407,
 6943,
 -1,
 1047926837,
 6949,
 1048264319,
 1047795060,
 -1,
 1048329853,
 1048211767,
 6917,
 -1,
 1048251069,
 6918,
 -49538,
 1048298184,
 6987,
 -1,
 1048405423,
 6928,
 1048592003,
 1048229785,
 6962,
 1048707071,
 1048513011,
 -1,
 -49534,
 1048617038,
 6961,
 -1,
 1048662788,
 6960,
 1048854150,
 1048553903,
 6957,
 1048969215,
 1048775100,
 6923,
 -1,
 1048840893,
 6924,
 1049050761,
 1048802221,
 6958,
 1049165823,
 1048970614,
 6925,
 -1,
 1049037501,
 6926,
 1049247371,
 1049022615,
 6921,
 -1,
 1049168573,
 6922,
 1049378445,
 1049206862,
 6951,
 -1,
 1049298158,
 6952,
 1049509519,
 1049334766,
 6929,
 -1,
 1049430717,
 6930,
 1049640593,
 1049456427,
 6938,
 -1,
 1049560282,
 6939,
 1049771667,
 1049585071,
 6919,
 -1,
 1049692861,
 6920,
 1049902741,
 1049711364,
 6933,
 -1,
 1049822231,
 6934,
 1050033816,
 1049837703,
 -1,
 -49513,
 1049981239,
 6927,
 -1,
 1050037882,
 6984,
 1050230426,
 1049963835,
 6936,
 -1,
 1050150191,
 6937,
 1050361500,
 1050158760,
 6953,
 -1,
 1050281239,
 6954,
 -49507,
 1050339163,
 6986,
 -49506,
 1050469418,
 6956,
 -49505,
 1050533168,
 6959,
 -49504,
 1050597663,
 6985,
 -49503,
 1050640434,
 6955,
 -1,
 1050695849,
 6963,
 1050885835,
 1046644879,
 -1,
 1050951345,
 1050818080,
 -1,
 1051016875,
 1050875252,
 -1,
 1051082409,
 1050971063,
 7012,
 1051197439,
 1051000832,
 -1,
 -49496,
 1051116063,
 7013,
 -1,
 1051153477,
 7018,
 -49494,
 1051027623,
 7017,
 -1,
 1051281310,
 7015,
 1051475630,
 1050951815,
 -1,
 -49491,
 1051447921,
 7016,
 -1,
 1051495351,
 7010,
 -49489,
 1051447921,
 7011,
 -49488,
 1051629075,
 7009,
 -1,
 1051682983,
 7014,
 1051868860,
 1050882564,
 -1,
 1051934391,
 1051816409,
 -1,
 1051999925,
 1051906226,
 7021,
 -1,
 1051921851,
 7024,
 1052180479,
 1051949680,
 7022,
 -1,
 1052052923,
 7025,
 -49480,
 1051903221,
 7019,
 -49479,
 1052209082,
 7023,
 -49478,
 1052268109,
 7027,
 -49477,
 1052329863,
 7020,
 -1,
 1052387449,
 7026,
 1052589764,
 1051818017,
 -1,
 1052655297,
 1052546886,
 -1,
 -49473,
 1052627569,
 7033,
 -49472,
 1052666023,
 7036,
 -1,
 1052712544,
 7032,
 1052966911,
 1052586424,
 -1,
 -49469,
 1052889236,
 7035,
 -1,
 1052907968,
 7034,
 1053163519,
 1052553295,
 -1,
 1053179592,
 1053071160,
 -1,
 -49465,
 1053151274,
 7028,
 -1,
 1053169811,
 7029,
 1053425663,
 1053110722,
 -1,
 -49462,
 1053347988,
 7030,
 -1,
 1053366720,
 7031,
 1053572829,
 1050860726,
 -1,
 1053638355,
 1053541076,
 -1,
 1053703890,
 1053563802,
 6974,
 1053818879,
 1053622272,
 -1,
 1053834961,
 1053732061,
 6975,
 -1,
 1053756093,
 6977,
 -1,
 1053803731,
 6976,
 -1,
 1053639457,
 6965,
 1054097109,
 1053610343,
 6966,
 -1,
 1054018039,
 6967,
 1054228183,
 1054065072,
 6968,
 -1,
 1054147727,
 6969,
 1054359257,
 1054190002,
 6970,
 -1,
 1054280381,
 6971,
 1054490331,
 1054319182,
 6978,
 -1,
 1054411453,
 6979,
 1054670847,
 1054438320,
 6972,
 -1,
 1054542525,
 6973,
 1054752491,
 1053505944,
 -1,
 1054818017,
 1054720724,
 -1,
 -49440,
 1054794127,
 6994,
 -1,
 1054826582,
 6995,
 1055014628,
 1054783263,
 -1,
 -49437,
 1054961390,
 6998,
 -1,
 1055018114,
 6999,
 1055211239,
 1054953046,
 -1,
 -49434,
 1055169520,
 6996,
 -1,
 1055223415,
 6997,
 -49432,
 1055188885,
 6992,
 -49431,
 1055364543,
 6993,
 -49430,
 1055427772,
 7001,
 -1,
 1055474999,
 7000,
 1055670003,
 1054719024,
 -1,
 1055735535,
 1055641963,
 -1,
 -49426,
 1055698513,
 6912,
 -1,
 1055731096,
 6913,
 -49424,
 1055703583,
 6915,
 -49423,
 1055894767,
 6964,
 -49422,
 1055927982,
 6914,
 -1,
 1055992257,
 6916,
 1056194296,
 1055629390,
 -1,
 1056259831,
 1056145381,
 -1,
 -49418,
 1056196493,
 7008,
 -1,
 1056249821,
 7003,
 -1,
 1056214936,
 7002,
 1056521981,
 1056124464,
 -1,
 1056587516,
 1056481358,
 -1,
 -49413,
 1056550135,
 7007,
 -1,
 1056606290,
 7005,
 -1,
 1056554095,
 7006,
 -49410,
 1056497504,
 7004,
 -1,
 1056774150,
 6980,
 1057030143,
 1046576324,
 -1,
 1057046278,
 1056948950,
 -1,
 1057111813,
 1056975707,
 9744,
 1057226751,
 1057033251,
 -1,
 -49404,
 1057153796,
 9746,
 -1,
 1057173360,
 9745,
 -1,
 1057088260,
 10007,
 -1,
 1057002850,
 10057,
 1057505147,
 1046513716,
 -1,
 1057570672,
 1057454554,
 -1,
 1057636124,
 1057523935,
 -1,
 1057701646,
 1057582889,
 -1,
 -49396,
 1057672897,
 42686,
 -49395,
 1057702695,
 42694,
 -1,
 1057757278,
 42674,
 1057963794,
 1057641187,
 -1,
 -49392,
 1057911626,
 42707,
 -49391,
 1057968900,
 42708,
 -1,
 1058018676,
 42709,
 1058225940,
 1057934922,
 42685,
 -1,
 1058150457,
 42684,
 1058357015,
 1058194132,
 -1,
 -49386,
 1058330490,
 42731,
 -1,
 1058358055,
 42695,
 -49384,
 1058334064,
 42664,
 -49383,
 1058519634,
 42691,
 -49382,
 1058562431,
 42703,
 -49381,
 1058616989,
 42673,
 -1,
 1058674036,
 42715,
 1058881321,
 1057583240,
 -1,
 1058946848,
 1058836879,
 42719,
 -49377,
 1058921722,
 42734,
 -1,
 1058952409,
 42735,
 1059143460,
 1058881671,
 -1,
 -49374,
 1059116942,
 42692,
 -49373,
 1059177172,
 42683,
 -1,
 1059227871,
 42706,
 -49371,
 1059120334,
 42682,
 -49370,
 1059376714,
 42659,
 -49369,
 1059430478,
 42729,
 -49368,
 1059479935,
 42725,
 -1,
 1059526004,
 42657,
 1059733300,
 1058832357,
 42675,
 1059798829,
 1059668103,
 -1,
 -49364,
 1059752159,
 42722,
 -1,
 1059799850,
 42671,
 1059995440,
 1059726966,
 -1,
 -49361,
 1059931889,
 42720,
 -1,
 1059984887,
 42727,
 -49359,
 1059966538,
 42677,
 -49358,
 1060147599,
 42726,
 -49357,
 1060200831,
 42702,
 -1,
 1060246900,
 42723,
 1060454206,
 1059698463,
 -1,
 1060519738,
 1060395147,
 -1,
 -49353,
 1060490826,
 42688,
 -49352,
 1060540815,
 42710,
 -49351,
 1060595099,
 42678,
 -1,
 1060654187,
 42680,
 -49349,
 1060493178,
 42676,
 -49348,
 1060790655,
 42679,
 -49347,
 1060850795,
 42681,
 -1,
 1060904097,
 42732,
 1061109576,
 1060415828,
 -1,
 1061175107,
 1061044359,
 -1,
 -49343,
 1061148558,
 42704,
 -49342,
 1061193951,
 42721,
 -1,
 1061240967,
 42661,
 1061437254,
 1061118335,
 -1,
 -49339,
 1061380479,
 42668,
 -1,
 1061438247,
 42669,
 -49337,
 1061408330,
 42700,
 -1,
 1061558329,
 42705,
 1061764945,
 1061068777,
 -1,
 1061830476,
 1061736010,
 -1,
 -49333,
 1061765255,
 42696,
 -1,
 1061820473,
 42711,
 1062027087,
 1061765255,
 -1,
 -49330,
 1062000526,
 42693,
 -1,
 1062027399,
 42698,
 -49328,
 1061970303,
 42717,
 -1,
 1062147444,
 42667,
 1062354777,
 1061733076,
 -1,
 1062420309,
 1062289543,
 -1,
 -49324,
 1062388436,
 42728,
 -1,
 1062439135,
 42730,
 1062616920,
 1062344052,
 -1,
 -49321,
 1062551687,
 42662,
 -1,
 1062606196,
 42672,
 -1,
 1062560127,
 42724,
 1062879071,
 1062302552,
 -1,
 -49317,
 1062850122,
 42701,
 -49316,
 1062901747,
 42718,
 -49315,
 1062953343,
 42716,
 -49314,
 1063011118,
 42670,
 -1,
 1063064948,
 42666,
 1063272292,
 1062817366,
 -1,
 -49311,
 1063243338,
 42712,
 -49310,
 1063294150,
 42713,
 -49309,
 1063338791,
 42699,
 -1,
 1063392777,
 42733,
 1063599976,
 1063248878,
 -1,
 -49306,
 1063572860,
 42689,
 -49305,
 1063622643,
 42687,
 -1,
 1063654772,
 42690,
 1063862123,
 1063574792,
 -1,
 -49302,
 1063833614,
 42697,
 -1,
 1063851380,
 42714,
 -49300,
 1063833162,
 42658,
 -49299,
 1064014223,
 42663,
 -49298,
 1064067455,
 42665,
 -49297,
 1064125223,
 42660,
 -1,
 1064179060,
 42656,
 1064386423,
 1057501672,
 -1,
 1064451958,
 1064337381,
 -1,
 1064517493,
 1064380841,
 -1,
 -49292,
 1064488126,
 42737,
 -1,
 1064530610,
 42736,
 -1,
 1064468530,
 42741,
 -1,
 1064402194,
 42740,
 -49288,
 1064352094,
 42742,
 -49287,
 1064806590,
 42743,
 -49286,
 1064865104,
 42738,
 -1,
 1064915650,
 42739,
 -49284,
 1057470634,
 9918,
 -1,
 1065038128,
 10155,
 1065238677,
 1046450575,
 -1,
 1065304122,
 1065214729,
 -1,
 1065369528,
 1065251672,
 -1,
 1065435053,
 1065313512,
 -1,
 1065500560,
 1065367072,
 -1,
 1065566091,
 1065456015,
 -1,
 1065631624,
 1065541966,
 9591,
 1065746431,
 1065549946,
 -1,
 -49274,
 1065660001,
 9484,
 -49273,
 1065711237,
 9488,
 -1,
 1065770701,
 9516,
 1066008575,
 1065602883,
 -1,
 -49270,
 1065933359,
 9550,
 -1,
 1065967309,
 9548,
 1066205183,
 1065509394,
 -1,
 1066221455,
 1066128473,
 -1,
 -49266,
 1066184694,
 9585,
 -1,
 1066235828,
 9586,
 -1,
 1066153001,
 9587,
 1066483607,
 1065472772,
 9589,
 1066598399,
 1066401914,
 -1,
 1066614677,
 1066489995,
 -1,
 -49260,
 1066572024,
 9524,
 -1,
 1066615252,
 9597,
 -49258,
 1066577505,
 9492,
 -1,
 1066759813,
 9496,
 1066942364,
 1066457647,
 9474,
 1067057151,
 1066860666,
 -1,
 -49254,
 1066970721,
 9500,
 -49253,
 1067021957,
 9508,
 -1,
 1067081421,
 9532,
 1067270051,
 1066869025,
 -1,
 1067335584,
 1067242251,
 -1,
 -49249,
 1067298401,
 9584,
 -1,
 1067349637,
 9583,
 1067581439,
 1067269690,
 -1,
 -49246,
 1067495009,
 9581,
 -1,
 1067546245,
 9582,
 1067728806,
 1067240294,
 -1,
 -49243,
 1067702831,
 9478,
 -1,
 1067736781,
 9476,
 1067925417,
 1067689971,
 -1,
 -49240,
 1067899439,
 9482,
 -1,
 1067933389,
 9480,
 1068122027,
 1067873925,
 9588,
 -1,
 1068040393,
 9596,
 -49236,
 1068084833,
 9590,
 -1,
 1068195533,
 9472,
 1068433407,
 1065370526,
 -1,
 1068449714,
 1068333741,
 -1,
 -49232,
 1068423893,
 9546,
 -49231,
 1068487520,
 9530,
 -1,
 1068514949,
 9522,
 1068711862,
 1068391354,
 -1,
 -49228,
 1068686052,
 9533,
 -49227,
 1068749772,
 9525,
 -1,
 1068777207,
 9517,
 -49225,
 1068684166,
 9539,
 -1,
 1068908205,
 9541,
 1069105123,
 1065302724,
 -1,
 1069170644,
 1069080913,
 -1,
 1069236163,
 1069120146,
 -1,
 1069301694,
 1069198951,
 -1,
 -49219,
 1069273952,
 9505,
 -1,
 1069308818,
 9485,
 1069498305,
 1069250186,
 -1,
 -49216,
 1069470560,
 9513,
 -1,
 1069505426,
 9489,
 -49214,
 1069470628,
 9543,
 -1,
 1069637442,
 9519,
 1069825996,
 1069177759,
 -1,
 1069891527,
 1069788775,
 -1,
 -49210,
 1069863884,
 9503,
 -1,
 1069906572,
 9486,
 1070088138,
 1069840010,
 -1,
 -49207,
 1070060492,
 9511,
 -1,
 1070103180,
 9490,
 -49205,
 1070060472,
 9537,
 -1,
 1070227283,
 9520,
 1070415824,
 1069792421,
 -1,
 -49202,
 1070378747,
 9554,
 -49201,
 1070429913,
 9557,
 -1,
 1070489356,
 9572,
 1070727167,
 1070349399,
 -1,
 -49198,
 1070641129,
 9555,
 -49197,
 1070692245,
 9558,
 -1,
 1070751588,
 9573,
 1070989311,
 1069141801,
 -1,
 1071005658,
 1070914095,
 9553,
 1071120383,
 1070923898,
 -1,
 -49192,
 1071033953,
 9568,
 -49191,
 1071085189,
 9571,
 -1,
 1071144653,
 9580,
 1071333342,
 1070977803,
 -1,
 -49188,
 1071296097,
 9562,
 -49187,
 1071347333,
 9565,
 -1,
 1071406797,
 9577,
 1071595490,
 1071267386,
 -1,
 -49184,
 1071558241,
 9556,
 -49183,
 1071609477,
 9559,
 -1,
 1071668941,
 9574,
 -1,
 1071537869,
 9552,
 1071923203,
 1069046680,
 -1,
 1071988717,
 1071856324,
 -1,
 1072054250,
 1071964494,
 9595,
 1072168959,
 1071972474,
 -1,
 -49176,
 1072082529,
 9487,
 -49175,
 1072133765,
 9491,
 -1,
 1072193229,
 9523,
 1072431103,
 1072025411,
 -1,
 -49172,
 1072355887,
 9551,
 -1,
 1072389837,
 9549,
 1072578548,
 1071960836,
 9593,
 1072693247,
 1072496762,
 -1,
 1072709618,
 1072591704,
 -1,
 -49167,
 1072653550,
 9599,
 -1,
 1072710554,
 9499,
 -49165,
 1072672353,
 9495,
 -1,
 1072848589,
 9531,
 1073037305,
 1072552495,
 9475,
 1073151999,
 1072955514,
 -1,
 -49161,
 1073065569,
 9507,
 -49160,
 1073116805,
 9515,
 -1,
 1073176269,
 9547,
 1073364988,
 1073007462,
 -1,
 -49157,
 1073338927,
 9479,
 -1,
 1073372877,
 9477,
 1073561599,
 1073326067,
 -1,
 -49154,
 1073535535,
 9483,
 -1,
 1073569485,
 9481,
 1073758209,
 1073510021,
 9592,
 -1,
 1073676516,
 9598,
 -49150,
 1073720929,
 9594,
 -1,
 1073831629,
 9473,
 1074020382,
 1071895303,
 -1,
 1074085901,
 1073969810,
 -1,
 1074151432,
 1074048615,
 -1,
 -49145,
 1074092946,
 9493,
 -1,
 1074151045,
 9506,
 1074348043,
 1074099850,
 -1,
 -49142,
 1074289554,
 9497,
 -1,
 1074347653,
 9514,
 -49140,
 1074290498,
 9527,
 -1,
 1074478795,
 9544,
 1074675734,
 1074027423,
 -1,
 1074741265,
 1074638439,
 -1,
 -49136,
 1074690700,
 9494,
 -1,
 1074740983,
 9502,
 1074937876,
 1074689674,
 -1,
 -49133,
 1074887308,
 9498,
 -1,
 1074937591,
 9510,
 -49131,
 1074880339,
 9528,
 -1,
 1075068641,
 9536,
 1075265562,
 1074642085,
 -1,
 -49128,
 1075228411,
 9560,
 -49127,
 1075279577,
 9563,
 -1,
 1075339020,
 9575,
 1075576831,
 1075199063,
 -1,
 -49124,
 1075490793,
 9561,
 -49123,
 1075541909,
 9564,
 -1,
 1075601252,
 9576,
 1075789871,
 1073994296,
 -1,
 1075855395,
 1075756197,
 -1,
 -49119,
 1075818235,
 9566,
 -49118,
 1075869401,
 9569,
 -1,
 1075928844,
 9578,
 1076117543,
 1075804818,
 -1,
 -49115,
 1076080485,
 9501,
 -49114,
 1076131644,
 9509,
 -1,
 1076191042,
 9535,
 1076379691,
 1076059039,
 -1,
 -49111,
 1076342652,
 9504,
 -49110,
 1076393809,
 9512,
 -1,
 1076453203,
 9538,
 1076690943,
 1076313175,
 -1,
 -49107,
 1076604905,
 9567,
 -49106,
 1076656021,
 9570,
 -1,
 1076715364,
 9579,
 1076953087,
 1075752551,
 -1,
 1076969524,
 1076853405,
 -1,
 -49102,
 1076943573,
 9545,
 -49101,
 1077007200,
 9529,
 -1,
 1077034629,
 9521,
 1077231672,
 1076911018,
 -1,
 -49098,
 1077205732,
 9534,
 -49097,
 1077269452,
 9526,
 -1,
 1077296887,
 9518,
 -49095,
 1077203817,
 9540,
 -1,
 1077427856,
 9542,
 1077624959,
 1065264451,
 -1,
 1077690490,
 1077574106,
 -1,
 1077755973,
 1077613940,
 12570,
 1077821504,
 1077709023,
 12578,
 -49089,
 1077774559,
 12713,
 -1,
 1077826275,
 12580,
 1078018114,
 1077792330,
 12576,
 -1,
 1077972346,
 12719,
 1078149188,
 1077961087,
 12574,
 -1,
 1078103418,
 12718,
 -1,
 1078099941,
 12720,
 1078345805,
 1077690503,
 12572,
 1078411337,
 1078298847,
 12579,
 -49080,
 1078364383,
 12709,
 -1,
 1078416099,
 12581,
 -49078,
 1078372692,
 12582,
 -49077,
 1078550911,
 12575,
 -49076,
 1078614155,
 12573,
 -1,
 1078673543,
 12708,
 1078870100,
 1078288767,
 12583,
 1078935632,
 1078824314,
 12714,
 -1,
 1078888671,
 12723,
 -49071,
 1078906442,
 12585,
 -49070,
 1079028052,
 12712,
 -49069,
 1079082981,
 12716,
 -1,
 1079138443,
 12589,
 1079328859,
 1078825359,
 12571,
 1079394392,
 1079281887,
 -1,
 -49065,
 1079347423,
 12711,
 -1,
 1079399139,
 12722,
 -49063,
 1079365194,
 12577,
 -49062,
 1079546255,
 12710,
 -1,
 1079607269,
 12721,
 1079787614,
 1079306014,
 12567,
 -49059,
 1079730559,
 12705,
 -1,
 1079793803,
 12563,
 1079984225,
 1079740639,
 12555,
 1080098815,
 1079923427,
 12587,
 -1,
 1079988963,
 12717,
 1080180836,
 1079923427,
 12557,
 -49053,
 1080151626,
 12707,
 -1,
 1080199391,
 12588,
 1080377446,
 1080151626,
 12584,
 -1,
 1080331642,
 12715,
 1080508520,
 1080342303,
 12569,
 -1,
 1080449163,
 12565,
 1080639594,
 1080454953,
 12560,
 -1,
 1080582527,
 12706,
 1080770668,
 1080569054,
 12568,
 -1,
 1080711307,
 12564,
 1080901742,
 1080698486,
 12549,
 -1,
 1080872522,
 12704,
 -49041,
 1080877828,
 12562,
 -49040,
 1081005998,
 12586,
 -49039,
 1081066196,
 12554,
 -49038,
 1081125204,
 12566,
 -49037,
 1081190212,
 12561,
 -49036,
 1081253865,
 12550,
 -49035,
 1081311205,
 12551,
 -49034,
 1081373528,
 12556,
 -49033,
 1081438344,
 12558,
 -49032,
 1081497739,
 12559,
 -49031,
 1081560662,
 12552,
 -1,
 1081620000,
 12553,
 1081868287,
 1077628996,
 -1,
 -49028,
 1081787092,
 12725,
 -49027,
 1081843689,
 12724,
 -49026,
 1081897096,
 12726,
 -1,
 1081956491,
 12727,
 1082146961,
 1077595261,
 -1,
 1082212485,
 1082109543,
 -1,
 1082278020,
 1082141918,
 -1,
 -49021,
 1082242148,
 8972,
 -1,
 1082300780,
 8991,
 -1,
 1082218921,
 11813,
 1082540170,
 1082160778,
 -1,
 1082605705,
 1082469598,
 -1,
 -49016,
 1082569828,
 8973,
 -1,
 1082628460,
 8990,
 -1,
 1082546601,
 11812,
 1082867852,
 1082507102,
 9141,
 -1,
 1082787866,
 9142,
 -49011,
 1082837613,
 9185,
 -49010,
 1082958118,
 9181,
 -49009,
 1083005382,
 8993,
 -49008,
 1083061653,
 9183,
 -1,
 1083121958,
 10555,
 1083375615,
 1082122978,
 8904,
 1083441151,
 1083247651,
 -1,
 -49004,
 1083354916,
 10706,
 -1,
 1083406079,
 10705,
 1083588893,
 1065173127,
 -1,
 1083654421,
 1083541727,
 -1,
 1083719955,
 1083593555,
 -1,
 1083785437,
 1083668954,
 -1,
 1083850912,
 1083746644,
 -1,
 1083916446,
 1083774324,
 2480,
 1084030975,
 1083837475,
 -1,
 -48995,
 1083933904,
 2544,
 -1,
 1083997806,
 2545,
 -48993,
 1083877807,
 2524,
 -1,
 1084119209,
 2525,
 1084309669,
 1083825167,
 -1,
 1084375203,
 1084270932,
 2443,
 -1,
 1084336468,
 2528,
 1084555263,
 1084322648,
 2444,
 -1,
 1084453720,
 2529,
 1084637355,
 1084277460,
 -1,
 1084702889,
 1084605140,
 -1,
 -48984,
 1084643497,
 2464,
 -1,
 1084691828,
 2463,
 -48982,
 1084643497,
 2469,
 -1,
 1084822900,
 2468,
 1085030576,
 1084590303,
 -1,
 -48979,
 1085006890,
 2462,
 -48978,
 1085049147,
 2467,
 -48977,
 1085100804,
 2457,
 -1,
 1085150580,
 2472,
 1085358262,
 1084962336,
 -1,
 1085423796,
 1085290016,
 -1,
 -48973,
 1085364393,
 2466,
 -1,
 1085412724,
 2465,
 -48971,
 1085364393,
 2471,
 -1,
 1085543796,
 2470,
 1085751482,
 1085281652,
 2437,
 -48968,
 1085722186,
 2452,
 -48967,
 1085759871,
 2448,
 -1,
 1085805940,
 2438,
 1086013630,
 1085716255,
 -1,
 -48964,
 1085978521,
 2487,
 -48963,
 1086019753,
 2486,
 -1,
 1086068084,
 2488,
 1086275778,
 1085960328,
 -1,
 1086341313,
 1086216361,
 2454,
 -1,
 1086294750,
 2510,
 -1,
 1086264692,
 2453,
 1086537925,
 1086252014,
 -1,
 -48956,
 1086514218,
 2527,
 -1,
 1086526836,
 2479,
 1086734535,
 1086508618,
 2441,
 -1,
 1086705226,
 2442,
 1086865610,
 1086693353,
 -1,
 -48951,
 1086806185,
 2475,
 -1,
 1086854516,
 2474,
 1087062221,
 1086811945,
 -1,
 -48948,
 1087002793,
 2461,
 -1,
 1087051124,
 2460,
 1087258831,
 1087005055,
 2439,
 -1,
 1087201663,
 2440,
 1087389906,
 1087197923,
 -1,
 -48943,
 1087330473,
 2456,
 -1,
 1087378804,
 2455,
 1087586517,
 1087319262,
 -1,
 -48940,
 1087527081,
 2459,
 -1,
 1087575412,
 2458,
 1087783128,
 1087514230,
 -1,
 -48937,
 1087723689,
 2477,
 -1,
 1087772020,
 2476,
 -48935,
 1087738255,
 2451,
 -48934,
 1087930418,
 2478,
 -48933,
 1087992749,
 2482,
 -48932,
 1088051369,
 2489,
 -1,
 1088110727,
 2447,
 1088307437,
 1083759798,
 -1,
 1088372963,
 1088281615,
 -1,
 1088438497,
 1088334164,
 2499,
 -1,
 1088399700,
 2500,
 1088618495,
 1088385880,
 2530,
 -1,
 1088516952,
 2531,
 1088700647,
 1088296308,
 -1,
 -48923,
 1088671306,
 2508,
 -48922,
 1088708991,
 2504,
 -1,
 1088755060,
 2494,
 1088962793,
 1088671306,
 2497,
 -1,
 1088933450,
 2498,
 1089093867,
 1088905599,
 2495,
 -1,
 1089036671,
 2496,
 -48916,
 1089048975,
 2507,
 -1,
 1089159303,
 2503,
 1089356027,
 1088240024,
 -1,
 1089421553,
 1089323732,
 -1,
 -48912,
 1089397135,
 2536,
 -1,
 1089429590,
 2537,
 1089618164,
 1089386271,
 -1,
 -48909,
 1089564398,
 2540,
 -1,
 1089621122,
 2541,
 1089814775,
 1089556054,
 -1,
 -48906,
 1089772528,
 2538,
 -1,
 1089826423,
 2539,
 -48904,
 1089791893,
 2534,
 -48903,
 1089967551,
 2535,
 -48902,
 1090030780,
 2543,
 -1,
 1090078007,
 2542,
 1090273540,
 1089322032,
 -1,
 1090339071,
 1090247525,
 -1,
 -48898,
 1090304037,
 2435,
 -1,
 1090366093,
 2509,
 1090535682,
 1090262388,
 -1,
 -48895,
 1090508741,
 2493,
 -1,
 1090556101,
 2434,
 -48893,
 1090490421,
 2492,
 -1,
 1090661812,
 2433,
 1090863373,
 1090205114,
 -1,
 1090928908,
 1090818176,
 -1,
 1090994441,
 1090896596,
 -1,
 -48888,
 1090969999,
 2549,
 -1,
 1091002454,
 2550,
 1091191051,
 1090950591,
 2548,
 -1,
 1091110269,
 2552,
 -1,
 1091129808,
 2551,
 -1,
 1090860991,
 2553,
 1091453200,
 1090827962,
 -1,
 -48881,
 1091419179,
 2547,
 -1,
 1091469914,
 2546,
 -48879,
 1091399002,
 2554,
 -48878,
 1091588991,
 2555,
 -1,
 1091642770,
 2519,
 1091895295,
 1083697025,
 9004,
 -1,
 1091767361,
 9187,
 1091977496,
 1083622100,
 -1,
 -48873,
 1091952213,
 8812,
 -1,
 1091963540,
 8502,
 1092174107,
 1091902676,
 -1,
 -48870,
 1092140322,
 9836,
 -1,
 1092175192,
 9835,
 -48868,
 1092123661,
 9086,
 -1,
 1092300367,
 8757,
 1092501924,
 1083536301,
 -1,
 1092567459,
 1092432165,
 -1,
 1092632984,
 1092485120,
 -1,
 1092698417,
 1092562142,
 -1,
 1092763945,
 1092639832,
 -1,
 1092829477,
 1092710536,
 -1,
 -48860,
 1092783264,
 9822,
 -1,
 1092839591,
 9818,
 -48858,
 1092793439,
 9820,
 -48857,
 1092987055,
 9819,
 -48856,
 1093050770,
 9823,
 -1,
 1093085639,
 9821,
 1093288238,
 1092709404,
 9679,
 1093402623,
 1093209123,
 -1,
 -48852,
 1093328591,
 9864,
 -48851,
 1093389834,
 9865,
 -1,
 1093418584,
 10733,
 -48849,
 1093252248,
 9960,
 -48848,
 1093566254,
 9827,
 -1,
 1093617718,
 10028,
 1093812545,
 1092663071,
 -1,
 1093878074,
 1093763045,
 -1,
 1093943609,
 1093802920,
 -1,
 1094009143,
 1093908255,
 -1,
 -48842,
 1093977124,
 11089,
 -1,
 1094035487,
 9642,
 -48840,
 1093959369,
 11050,
 -1,
 1094138157,
 11049,
 -1,
 1093887520,
 9787,
 -48837,
 1093849558,
 9728,
 -48836,
 1094370340,
 9733,
 -48835,
 1094428703,
 9632,
 -48834,
 1094492286,
 9824,
 -48833,
 1094553289,
 9927,
 -48832,
 1094606445,
 9751,
 -1,
 1094660358,
 9986,
 1094861139,
 1093759832,
 -1,
 1094926667,
 1094796186,
 -1,
 1094992199,
 1094848697,
 -1,
 -48827,
 1094961914,
 9664,
 -48826,
 1095024167,
 9666,
 -1,
 1095083237,
 9668,
 1095254346,
 1094909952,
 -1,
 -48823,
 1095214352,
 9754,
 -1,
 1095267570,
 9944,
 -1,
 1095228799,
 8268,
 1095516496,
 1094881679,
 -1,
 1095582031,
 1095491184,
 -1,
 -48818,
 1095544880,
 9698,
 -1,
 1095596013,
 9699,
 -1,
 1095559051,
 10731,
 1095892991,
 1095442840,
 -1,
 -48814,
 1095810903,
 11035,
 -1,
 1095839810,
 11044,
 1096040801,
 1094822228,
 -1,
 1096106336,
 1095984355,
 -1,
 1096171867,
 1096028345,
 -1,
 1096237401,
 1096130537,
 -1,
 -48808,
 1096192983,
 9658,
 -1,
 1096239055,
 11091,
 -48806,
 1096207098,
 9654,
 -1,
 1096400423,
 9656,
 1096565087,
 1096146266,
 -1,
 1096630622,
 1096491618,
 10145,
 -1,
 1096571702,
 10148,
 -1,
 1096559679,
 8269,
 -1,
 1096485222,
 9755,
 -1,
 1096041043,
 9644,
 1096958317,
 1095972384,
 -1,
 1097023847,
 1096901195,
 9670,
 1097138175,
 1096941568,
 -1,
 -48795,
 1097064420,
 10730,
 -48794,
 1097122219,
 9830,
 -1,
 1097172426,
 10070,
 1097351530,
 1096985344,
 -1,
 -48791,
 1097302518,
 9922,
 -1,
 1097364058,
 9923,
 1097596927,
 1097310136,
 -1,
 -48788,
 1097517818,
 9660,
 -1,
 1097580071,
 9662,
 1097744758,
 1096928842,
 -1,
 1097810293,
 1097703401,
 -1,
 1097875826,
 1097769556,
 -1,
 -48783,
 1097838640,
 9701,
 -1,
 1097889773,
 9700,
 1098121215,
 1097797817,
 -1,
 -48780,
 1098042106,
 9650,
 -1,
 1098104359,
 9652,
 -1,
 1097764150,
 9851,
 1098334590,
 1097695205,
 -1,
 1098400125,
 1098269466,
 -1,
 1098465659,
 1098364703,
 -1,
 -48774,
 1098426399,
 9724,
 -1,
 1098482121,
 9726,
 -48772,
 1098415817,
 11047,
 -1,
 1098594605,
 11045,
 -1,
 1098356397,
 9912,
 1098858885,
 1098274955,
 -1,
 1098924418,
 1098813839,
 -1,
 -48767,
 1098896865,
 10711,
 -1,
 1098953516,
 11052,
 1099169791,
 1098858631,
 -1,
 -48764,
 1099096871,
 11042,
 -1,
 1099113148,
 9829,
 1099317642,
 1098832281,
 -1,
 1099383177,
 1099286466,
 -1,
 -48760,
 1099344903,
 9646,
 -1,
 1099384308,
 11054,
 -1,
 1099359245,
 11037,
 1099645326,
 1099285204,
 -1,
 -48756,
 1099621019,
 9942,
 -48755,
 1099675245,
 9951,
 -1,
 1099711971,
 9742,
 1099907475,
 1099583062,
 -1,
 1099973010,
 1099854680,
 -1,
 -48751,
 1099929784,
 10047,
 -1,
 1099962515,
 9873,
 -1,
 1099930708,
 10022,
 1100235158,
 1099866089,
 -1,
 -48747,
 1100171215,
 11039,
 -1,
 1100226809,
 9648,
 -48745,
 1100188803,
 10002,
 -1,
 1100360532,
 10707,
 1100611583,
 1092554451,
 -1,
 1100628383,
 1100511714,
 -1,
 -48741,
 1100605214,
 8488,
 -48740,
 1100654932,
 8476,
 -48739,
 1100702079,
 8465,
 -48738,
 1100765323,
 8460,
 -1,
 1100819678,
 8493,
 1101070335,
 1100566332,
 -1,
 -48735,
 1100988124,
 10164,
 -48734,
 1101050015,
 10165,
 -1,
 1101106724,
 10166,
 -1,
 1092521324,
 9250,
 1101349350,
 1092472394,
 -1,
 1101414858,
 1101288860,
 -1,
 1101480386,
 1101363674,
 -1,
 1101545904,
 1101433055,
 -1,
 1101611435,
 1101521902,
 -1,
 -48726,
 1101540667,
 6671,
 -1,
 1101600116,
 6670,
 1101808046,
 1101550307,
 -1,
 -48723,
 1101754527,
 6659,
 -1,
 1101796724,
 6658,
 -48721,
 1101769135,
 6667,
 -1,
 1101927796,
 6666,
 1102135731,
 1101496293,
 -1,
 -48718,
 1102094414,
 6663,
 -1,
 1102124404,
 6662,
 -48716,
 1102111786,
 6672,
 -48715,
 1102305212,
 6675,
 -48714,
 1102365461,
 6664,
 -48713,
 1102428057,
 6676,
 -48712,
 1102490031,
 6673,
 -48711,
 1102553166,
 6660,
 -48710,
 1102607277,
 6674,
 -48709,
 1102672031,
 6656,
 -48708,
 1102737195,
 6669,
 -48707,
 1102796969,
 6678,
 -48706,
 1102861060,
 6657,
 -48705,
 1102919307,
 6665,
 -48704,
 1102982459,
 6668,
 -48703,
 1103046312,
 6661,
 -1,
 1103107444,
 6677,
 1103315400,
 1101454518,
 -1,
 -48700,
 1103285834,
 6680,
 -48699,
 1103335823,
 6682,
 -48698,
 1103389055,
 6679,
 -48697,
 1103446151,
 6681,
 -1,
 1103501369,
 6683,
 -48695,
 1103274156,
 6686,
 -1,
 1103644521,
 6687,
 1103839714,
 1101356220,
 -1,
 1103905247,
 1103788506,
 -1,
 1103970767,
 1103857887,
 -1,
 -48690,
 1103909636,
 5957,
 -1,
 1103959412,
 5960,
 -48688,
 1103946794,
 5964,
 -48687,
 1104141616,
 5967,
 -48686,
 1104203338,
 5954,
 -48685,
 1104266005,
 5958,
 -48684,
 1104328601,
 5968,
 -48683,
 1104390575,
 5965,
 -48682,
 1104453710,
 5961,
 -48681,
 1104511026,
 5963,
 -48680,
 1104573357,
 5966,
 -48679,
 1104638111,
 5955,
 -48678,
 1104699775,
 5953,
 -48677,
 1104763049,
 5969,
 -48676,
 1104827140,
 5956,
 -48675,
 1104885387,
 5959,
 -48674,
 1104946856,
 5962,
 -1,
 1105007988,
 5952,
 1105264639,
 1103879350,
 -1,
 -48671,
 1105186378,
 5971,
 -1,
 1105224063,
 5970,
 1105461247,
 1103789058,
 -1,
 1105478117,
 1105349437,
 8226,
 -1,
 1105397367,
 8729,
 -1,
 1105443331,
 9678,
 1105723391,
 1101291903,
 -1,
 1105740266,
 1105613541,
 -1,
 -48663,
 1105706649,
 10744,
 -1,
 1105767756,
 10745,
 -1,
 1105695612,
 9763,
 1106003951,
 1003995860,
 -1,
 1106068514,
 1105925492,
 -1,
 1106133790,
 1106010497,
 -1,
 1106199190,
 1106101832,
 -1,
 1106264627,
 1106147802,
 -1,
 1106330120,
 1106211672,
 -1,
 1106395652,
 1106288368,
 -1,
 1106461174,
 1106342024,
 -1,
 -48652,
 1106436900,
 6692,
 -48651,
 1106466985,
 6693,
 -1,
 1106515316,
 6691,
 1106723321,
 1106428628,
 -1,
 -48648,
 1106663593,
 6709,
 -1,
 1106711924,
 6708,
 1106919932,
 1106681833,
 -1,
 -48645,
 1106860201,
 6717,
 -1,
 1106908532,
 6715,
 1107116543,
 1106848990,
 -1,
 -48642,
 1107056809,
 6699,
 -1,
 1107105140,
 6697,
 -48640,
 1107092522,
 6719,
 -48639,
 1107277721,
 6698,
 -48638,
 1107340026,
 6704,
 -48637,
 1107384489,
 6732,
 -1,
 1107447487,
 6716,
 1107640838,
 1106318708,
 6723,
 -1,
 1107574919,
 6739,
 -48633,
 1107611662,
 6724,
 -1,
 1107719085,
 6730,
 1107903006,
 1106271471,
 -1,
 1107968525,
 1107867423,
 -1,
 -48629,
 1107933081,
 6727,
 -48628,
 1107974313,
 6726,
 -1,
 1108022644,
 6728,
 1108230673,
 1107914888,
 -1,
 -48625,
 1108206372,
 6690,
 -48624,
 1108236457,
 6689,
 -1,
 1108284788,
 6688,
 1108492820,
 1108198100,
 -1,
 -48621,
 1108433065,
 6707,
 -1,
 1108481396,
 6706,
 1108689431,
 1108451305,
 -1,
 -48618,
 1108629673,
 6713,
 -1,
 1108678004,
 6712,
 1108886042,
 1108618462,
 -1,
 -48615,
 1108826281,
 6696,
 -1,
 1108874612,
 6695,
 -48613,
 1108861994,
 6720,
 -48612,
 1109043962,
 6702,
 -48611,
 1109088425,
 6729,
 -1,
 1109151423,
 6714,
 1109344803,
 1107863892,
 -1,
 1109410338,
 1109267828,
 6721,
 -48607,
 1109377813,
 6701,
 -1,
 1109428539,
 6705,
 -1,
 1109381134,
 6722,
 1109672487,
 1109297375,
 -1,
 -48603,
 1109648426,
 6700,
 -48602,
 1109676804,
 6694,
 -1,
 1109726580,
 6710,
 1109934633,
 1109642826,
 6735,
 -1,
 1109904970,
 6736,
 1110065707,
 1109877119,
 6733,
 -1,
 1110008191,
 6734,
 -48596,
 1110039856,
 6725,
 -48595,
 1110152836,
 6738,
 -48594,
 1110212658,
 6718,
 -48593,
 1110267620,
 6740,
 -48592,
 1110328103,
 6737,
 -48591,
 1110390411,
 6703,
 -48590,
 1110451880,
 6711,
 -1,
 1110513012,
 6731,
 1110721109,
 1106230320,
 -1,
 1110786622,
 1110667400,
 -1,
 1110852155,
 1110728974,
 -1,
 1110917690,
 1110772661,
 -1,
 -48584,
 1110840329,
 6777,
 -48583,
 1110905788,
 6776,
 -1,
 1110971212,
 6775,
 -1,
 1110839391,
 6780,
 1111245373,
 1110775316,
 6824,
 -1,
 1111192382,
 6825,
 -1,
 1111181455,
 6819,
 1111441987,
 1110751129,
 -1,
 1111507521,
 1111410964,
 6826,
 -1,
 1111454526,
 6827,
 -48574,
 1111481680,
 6818,
 -1,
 1111585493,
 6752,
 1111769672,
 1111392384,
 -1,
 1111835206,
 1111716084,
 6772,
 -1,
 1111754073,
 6744,
 -48569,
 1111811179,
 6823,
 -1,
 1111930850,
 6779,
 1112097354,
 1111744289,
 6816,
 -1,
 1112071479,
 6817,
 1112228429,
 1112066543,
 -1,
 -48564,
 1112150695,
 6774,
 -1,
 1112216079,
 6773,
 1112425040,
 1112189268,
 -1,
 -48561,
 1112362290,
 6822,
 -1,
 1112413569,
 6778,
 1112621651,
 1112365195,
 -1,
 -48558,
 1112580059,
 6820,
 -1,
 1112612448,
 6828,
 -48556,
 1112554222,
 6821,
 -1,
 1112747330,
 6829,
 1112949355,
 1110695094,
 -1,
 1113014876,
 1112904079,
 6763,
 1113080410,
 1112937846,
 -1,
 -48551,
 1113008211,
 6764,
 -1,
 1113069173,
 6771,
 -48549,
 1113056238,
 6765,
 -1,
 1113231759,
 6768,
 1113408096,
 1112985162,
 6761,
 1113473631,
 1113378378,
 6762,
 -1,
 1113407623,
 6760,
 -1,
 1113407623,
 6759,
 1113670244,
 1113331060,
 6753,
 -48542,
 1113612671,
 6769,
 -48541,
 1113669767,
 6767,
 -1,
 1113724276,
 6755,
 1113932391,
 1113637588,
 -1,
 -48538,
 1113872881,
 6770,
 -1,
 1113922477,
 6756,
 1114129001,
 1113874815,
 6757,
 -1,
 1114071423,
 6758,
 -48534,
 1114079371,
 6754,
 -1,
 1114194055,
 6766,
 1114391161,
 1112917582,
 -1,
 1114456687,
 1114358484,
 -1,
 -48530,
 1114431887,
 6802,
 -1,
 1114464342,
 6803,
 1114653298,
 1114421023,
 -1,
 -48527,
 1114599150,
 6806,
 -1,
 1114655874,
 6807,
 1114849909,
 1114590806,
 -1,
 -48524,
 1114807280,
 6804,
 -1,
 1114861175,
 6805,
 -48522,
 1114826645,
 6800,
 -48521,
 1115002303,
 6801,
 -48520,
 1115065532,
 6809,
 -1,
 1115112759,
 6808,
 1115308679,
 1114332860,
 -1,
 1115374205,
 1115275988,
 -1,
 -48516,
 1115349391,
 6786,
 -1,
 1115381846,
 6787,
 1115570816,
 1115338527,
 -1,
 -48513,
 1115516654,
 6790,
 -1,
 1115573378,
 6791,
 1115767427,
 1115508310,
 -1,
 -48510,
 1115724784,
 6788,
 -1,
 1115778679,
 6789,
 -48508,
 1115744149,
 6784,
 -48507,
 1115919807,
 6785,
 -48506,
 1115983036,
 6793,
 -1,
 1116030263,
 6792,
 1116274687,
 1115238888,
 -1,
 1116291733,
 1116180181,
 -1,
 1116357262,
 1116241893,
 -1,
 1116422797,
 1116291841,
 -1,
 -48500,
 1116383663,
 6741,
 -1,
 1116435373,
 6742,
 -1,
 1116345716,
 6748,
 1116684945,
 1116304216,
 -1,
 -48496,
 1116643068,
 6746,
 -1,
 1116673469,
 6743,
 -48494,
 1116649369,
 6750,
 -48493,
 1116822773,
 6747,
 -48492,
 1116885084,
 6745,
 -1,
 1116939944,
 6749,
 -1,
 1116242652,
 6783,
 1117209332,
 1106172813,
 -1,
 1117274838,
 1117157850,
 -1,
 1117340343,
 1117224483,
 -1,
 1117405853,
 1117292767,
 -1,
 -48485,
 1117382186,
 43664,
 -48484,
 1117426063,
 43672,
 -1,
 1117476381,
 43656,
 1117668002,
 1117352072,
 -1,
 1117733537,
 1117608075,
 -1,
 -48480,
 1117688207,
 43650,
 -1,
 1117740639,
 43652,
 -1,
 1117688207,
 43648,
 1117995685,
 1117635284,
 -1,
 -48476,
 1117950351,
 43668,
 -1,
 1118002783,
 43670,
 1118192296,
 1117954025,
 -1,
 -48473,
 1118146959,
 43676,
 -1,
 1118199391,
 43678,
 1118388907,
 1118121182,
 -1,
 -48470,
 1118343567,
 43658,
 -1,
 1118395999,
 43660,
 -48468,
 1118365226,
 43684,
 -48467,
 1118559244,
 43690,
 -48466,
 1118617205,
 43662,
 -48465,
 1118680020,
 43686,
 -48464,
 1118736783,
 43694,
 -48463,
 1118799412,
 43682,
 -48462,
 1118862532,
 43688,
 -48461,
 1118920287,
 43692,
 -48460,
 1118983709,
 43654,
 -48459,
 1119048052,
 43680,
 -48458,
 1119107780,
 43666,
 -1,
 1119169174,
 43674,
 1119420415,
 1117281519,
 -1,
 1119437500,
 1119324383,
 -1,
 -48454,
 1119413802,
 43665,
 -48453,
 1119457679,
 43673,
 -1,
 1119507997,
 43657,
 1119699649,
 1119383688,
 -1,
 1119765184,
 1119639691,
 -1,
 -48449,
 1119719823,
 43651,
 -1,
 1119772255,
 43653,
 -1,
 1119719823,
 43649,
 1120027332,
 1119666900,
 -1,
 -48445,
 1119981967,
 43669,
 -1,
 1120034399,
 43671,
 1120223943,
 1119985641,
 -1,
 -48442,
 1120178575,
 43677,
 -1,
 1120231007,
 43679,
 1120420554,
 1120152798,
 -1,
 -48439,
 1120375183,
 43659,
 -1,
 1120427615,
 43661,
 -48437,
 1120396842,
 43685,
 -48436,
 1120590860,
 43691,
 -48435,
 1120648821,
 43663,
 -48434,
 1120711636,
 43687,
 -48433,
 1120768399,
 43695,
 -48432,
 1120831028,
 43683,
 -48431,
 1120894148,
 43689,
 -48430,
 1120951903,
 43693,
 -48429,
 1121015325,
 43655,
 -48428,
 1121079668,
 43681,
 -48427,
 1121139396,
 43667,
 -1,
 1121200790,
 43675,
 1121403621,
 1117248655,
 -1,
 1121469149,
 1121326452,
 -1,
 -48423,
 1121444846,
 43708,
 -48422,
 1121505294,
 43707,
 -48421,
 1121552607,
 43709,
 -48420,
 1121615845,
 43710,
 -1,
 1121654132,
 43697,
 1121862369,
 1121439306,
 43700,
 1121927904,
 1121796231,
 43699,
 -1,
 1121850740,
 43705,
 -1,
 1121850740,
 43706,
 1122124515,
 1121804671,
 43698,
 -1,
 1122047348,
 43704,
 -48412,
 1122079119,
 43702,
 -1,
 1122189447,
 43701,
 1122386668,
 1121370723,
 -1,
 1122452201,
 1122333322,
 -1,
 -48408,
 1122404575,
 43739,
 -1,
 1122460047,
 43743,
 -48406,
 1122416610,
 43741,
 -48405,
 1122603042,
 43740,
 -1,
 1122655846,
 43742,
 1122845425,
 1122355653,
 -1,
 -48402,
 1122813696,
 43713,
 -48401,
 1122877117,
 43714,
 -48400,
 1122930722,
 43712,
 -1,
 1122977181,
 43711,
 1123221503,
 1122795653,
 -1,
 -48397,
 1123114455,
 43703,
 -1,
 1123163744,
 43696,
 1123418111,
 1117156953,
 -1,
 1123435265,
 1123336916,
 -1,
 1123500796,
 1123390985,
 -1,
 -48392,
 1123423361,
 6516,
 -48391,
 1123488777,
 6515,
 -48390,
 1123554236,
 6514,
 -48389,
 1123619660,
 6513,
 -1,
 1123685031,
 6512,
 1123894015,
 1123464991,
 -1,
 -48386,
 1123834025,
 6497,
 -1,
 1123882356,
 6483,
 -48384,
 1123834025,
 6487,
 -1,
 1124013428,
 6486,
 1124221700,
 1123369095,
 6507,
 -48381,
 1124161675,
 6502,
 -1,
 1124221063,
 6501,
 1124418311,
 1124144500,
 6499,
 -48378,
 1124388878,
 6508,
 -1,
 1124426111,
 6509,
 1124614921,
 1124388426,
 6503,
 -1,
 1124548743,
 6506,
 1124745996,
 1124573161,
 -1,
 -48373,
 1124685993,
 6490,
 -1,
 1124734324,
 6489,
 1124942606,
 1124700559,
 6505,
 -1,
 1124897167,
 6504,
 1125073681,
 1124894943,
 -1,
 -48368,
 1125012228,
 6482,
 -1,
 1125062004,
 6498,
 1125270292,
 1125019784,
 -1,
 -48365,
 1125210281,
 6496,
 -1,
 1125258612,
 6480,
 -48363,
 1125245994,
 6485,
 -48362,
 1125442340,
 6481,
 -48361,
 1125504956,
 6493,
 -48360,
 1125562265,
 6484,
 -48359,
 1125623626,
 6495,
 -48358,
 1125679154,
 6491,
 -48357,
 1125741485,
 6488,
 -48356,
 1125802367,
 6500,
 -48355,
 1125865641,
 6494,
 -1,
 1125928639,
 6492,
 1126122435,
 1106072291,
 -1,
 1126187925,
 1126039552,
 -1,
 1126253407,
 1126134616,
 -1,
 1126318936,
 1126180123,
 -1,
 1126384445,
 1126284810,
 -1,
 -48348,
 1126360862,
 917626,
 -48347,
 1126425582,
 917625,
 -48346,
 1126490884,
 917624,
 -48345,
 1126554888,
 917623,
 -48344,
 1126619054,
 917622,
 -48343,
 1126682186,
 917621,
 -48342,
 1126744788,
 917620,
 -48341,
 1126807327,
 917619,
 -48340,
 1126869332,
 917618,
 -48339,
 1126934340,
 917617,
 -48338,
 1126997993,
 917616,
 -48337,
 1127059855,
 917615,
 -48336,
 1127123167,
 917614,
 -48335,
 1127186405,
 917613,
 -48334,
 1127248728,
 917612,
 -48333,
 1127313544,
 917611,
 -48332,
 1127378729,
 917610,
 -48331,
 1127440767,
 917609,
 -48330,
 1127504011,
 917608,
 -48329,
 1127568099,
 917607,
 -48328,
 1127632470,
 917606,
 -48327,
 1127694471,
 917605,
 -48326,
 1127757344,
 917604,
 -48325,
 1127820510,
 917603,
 -48324,
 1127884406,
 917602,
 -1,
 1127945588,
 917601,
 1128202239,
 1126313476,
 -1,
 -48321,
 1128130334,
 917594,
 -48320,
 1128195054,
 917593,
 -48319,
 1128260356,
 917592,
 -48318,
 1128324360,
 917591,
 -48317,
 1128388526,
 917590,
 -48316,
 1128451658,
 917589,
 -48315,
 1128514260,
 917588,
 -48314,
 1128576799,
 917587,
 -48313,
 1128638804,
 917586,
 -48312,
 1128703812,
 917585,
 -48311,
 1128767465,
 917584,
 -48310,
 1128829327,
 917583,
 -48309,
 1128892639,
 917582,
 -48308,
 1128955877,
 917581,
 -48307,
 1129018200,
 917580,
 -48306,
 1129083016,
 917579,
 -48305,
 1129148201,
 917578,
 -48304,
 1129210239,
 917577,
 -48303,
 1129273483,
 917576,
 -48302,
 1129337571,
 917575,
 -48301,
 1129401942,
 917574,
 -48300,
 1129463943,
 917573,
 -48299,
 1129526816,
 917572,
 -48298,
 1129589982,
 917571,
 -48297,
 1129653878,
 917570,
 -1,
 1129715060,
 917569,
 1129923422,
 1126252679,
 -1,
 1129988957,
 1129861729,
 -1,
 -48293,
 1129955166,
 917595,
 -48292,
 1130012966,
 917544,
 -1,
 1130050965,
 917627,
 -1,
 1129955251,
 917564,
 -1,
 1129881332,
 917599,
 1130382191,
 1126184480,
 -1,
 1130447726,
 1130325370,
 -1,
 1130513252,
 1130414804,
 -1,
 -48285,
 1130488207,
 917554,
 -1,
 1130520662,
 917555,
 1130709863,
 1130477343,
 -1,
 -48282,
 1130655470,
 917558,
 -1,
 1130712194,
 917559,
 1130906474,
 1130647126,
 -1,
 -48279,
 1130863600,
 917556,
 -1,
 1130917495,
 917557,
 -48277,
 1130882965,
 917552,
 -48276,
 1131058623,
 917553,
 -48275,
 1131121852,
 917561,
 -1,
 1131169079,
 917560,
 -1,
 1130402957,
 917540,
 1131430773,
 1130342740,
 -1,
 1131496308,
 1131373800,
 -1,
 -48270,
 1131462494,
 917597,
 -48269,
 1131520294,
 917545,
 -1,
 1131558293,
 917629,
 -1,
 1131433187,
 917596,
 1131823996,
 1131359454,
 -1,
 1131889531,
 1131778447,
 -1,
 1131955066,
 1131841012,
 -1,
 -48263,
 1131891114,
 917568,
 -1,
 1131943284,
 917548,
 -1,
 1131904274,
 917562,
 -1,
 1131834451,
 917598,
 1132282752,
 1131788063,
 -1,
 -48258,
 1132241017,
 917536,
 -48257,
 1132303459,
 917551,
 -1,
 1132349056,
 917563,
 1132544900,
 1132205428,
 -1,
 -48254,
 1132511347,
 917546,
 -48253,
 1132569968,
 917543,
 -1,
 1132627825,
 917542,
 1132807047,
 1132505025,
 -1,
 -48250,
 1132763794,
 917538,
 -1,
 1132809001,
 917567,
 1133003658,
 1132765161,
 -1,
 -48247,
 1132953462,
 917547,
 -1,
 1133005206,
 917541,
 1133200269,
 1132942957,
 -1,
 -48244,
 1133134219,
 917566,
 -1,
 1133192681,
 917600,
 1133396880,
 1133133959,
 -1,
 -48241,
 1133372230,
 917537,
 -1,
 1133422595,
 917565,
 -48239,
 1133370099,
 917628,
 -48238,
 1133561852,
 917630,
 -48237,
 1133613127,
 917539,
 -48236,
 1133666671,
 917549,
 -1,
 1133728450,
 917550,
 1133921197,
 1126112313,
 -1,
 1133986729,
 1133869530,
 -1,
 1134052250,
 1133938911,
 -1,
 -48231,
 1133990660,
 5893,
 -1,
 1134040436,
 5896,
 -48229,
 1134027818,
 5900,
 -48228,
 1134222640,
 5903,
 -48227,
 1134284362,
 5890,
 -48226,
 1134347029,
 5894,
 -48225,
 1134409625,
 5904,
 -48224,
 1134469198,
 5897,
 -48223,
 1134526514,
 5899,
 -48222,
 1134588845,
 5902,
 -48221,
 1134653599,
 5891,
 -48220,
 1134715263,
 5889,
 -48219,
 1134778537,
 5905,
 -48218,
 1134842628,
 5892,
 -48217,
 1134900875,
 5895,
 -48216,
 1134962344,
 5898,
 -1,
 1135023476,
 5888,
 1135231916,
 1133960374,
 -1,
 -48213,
 1135201866,
 5907,
 -1,
 1135239551,
 5906,
 -1,
 1135197283,
 5908,
 1135542271,
 1133848391,
 -1,
 1135559616,
 1135442394,
 -1,
 1135625138,
 1135511775,
 -1,
 -48207,
 1135563524,
 5989,
 -1,
 1135613300,
 5992,
 -48205,
 1135600682,
 5996,
 -48204,
 1135795504,
 5999,
 -48203,
 1135857226,
 5986,
 -48202,
 1135919893,
 5990,
 -48201,
 1135982489,
 6000,
 -48200,
 1136042062,
 5993,
 -48199,
 1136099378,
 5995,
 -48198,
 1136161709,
 5998,
 -48197,
 1136226463,
 5987,
 -48196,
 1136288127,
 5985,
 -48195,
 1136349956,
 5988,
 -48194,
 1136408203,
 5991,
 -48193,
 1136469672,
 5994,
 -1,
 1136530804,
 5984,
 1136787455,
 1135533238,
 -1,
 -48190,
 1136709194,
 6003,
 -1,
 1136746879,
 6002,
 1136935968,
 1126073657,
 -1,
 1137001455,
 1136884186,
 -1,
 1137066956,
 1136953567,
 -1,
 1137132489,
 1137019103,
 -1,
 -48184,
 1137084731,
 2985,
 -1,
 1137120628,
 2979,
 -48182,
 1137108010,
 2974,
 -48181,
 1137267460,
 2969,
 -1,
 1137317236,
 2984,
 1137525712,
 1136989556,
 2949,
 -48178,
 1137495626,
 2964,
 -48177,
 1137533311,
 2960,
 -1,
 1137579380,
 2950,
 1137787860,
 1137489695,
 -1,
 -48174,
 1137751961,
 2999,
 -48173,
 1137793193,
 2998,
 -1,
 1137841524,
 3000,
 1138050009,
 1137734488,
 -1,
 1138115544,
 1137996632,
 -1,
 -48169,
 1138062253,
 2996,
 -1,
 1138103668,
 2995,
 -1,
 1138038132,
 2994,
 1138377691,
 1138019914,
 2953,
 -1,
 1138347594,
 2954,
 1138508766,
 1138344660,
 -1,
 -48163,
 1138475797,
 2975,
 -1,
 1138496884,
 2980,
 1138705377,
 1138469204,
 -1,
 -48160,
 1138665903,
 2993,
 -1,
 1138693492,
 2992,
 1138901987,
 1138659727,
 2962,
 -1,
 1138856335,
 2963,
 1139033061,
 1138844031,
 2951,
 -1,
 1138975103,
 2952,
 1139164135,
 1138966663,
 2958,
 -1,
 1139097735,
 2959,
 -48152,
 1139139626,
 2991,
 -48151,
 1139267516,
 2997,
 -48150,
 1139318862,
 2986,
 -48149,
 1139376178,
 2990,
 -48148,
 1139437727,
 2965,
 -48147,
 1139502891,
 2972,
 -48146,
 1139562665,
 3001,
 -1,
 1139617083,
 2970,
 1139819520,
 1136932384,
 -1,
 1139885054,
 1139762554,
 -1,
 1139950580,
 1139851988,
 -1,
 -48141,
 1139925391,
 3048,
 -1,
 1139957846,
 3049,
 1140147191,
 1139914527,
 -1,
 -48138,
 1140092654,
 3052,
 -1,
 1140149378,
 3053,
 1140343802,
 1140084310,
 -1,
 -48135,
 1140300784,
 3050,
 -1,
 1140354679,
 3051,
 -48133,
 1140320149,
 3046,
 -48132,
 1140495807,
 3047,
 -48131,
 1140559036,
 3055,
 -1,
 1140606263,
 3054,
 -48129,
 1139819030,
 3062,
 -1,
 1140729407,
 3059,
 1140933645,
 1139793078,
 -1,
 1140999173,
 1140856180,
 -1,
 -48125,
 1140969034,
 3020,
 -48124,
 1141006719,
 3016,
 -1,
 1141052788,
 3006,
 1141261319,
 1140969034,
 3009,
 -1,
 1141231178,
 3010,
 1141392393,
 1141215631,
 3018,
 -1,
 1141346703,
 3019,
 1141523467,
 1141334399,
 3007,
 -1,
 1141465471,
 3008,
 1141702655,
 1141457031,
 3014,
 -1,
 1141588103,
 3015,
 1141785619,
 1140887615,
 -1,
 1141851153,
 1141740995,
 -1,
 -48112,
 1141819165,
 3058,
 -1,
 1141858583,
 3057,
 -48110,
 1141818662,
 3056,
 -1,
 1142012971,
 3066,
 1142178840,
 1141750832,
 -1,
 1142244375,
 1142152037,
 -1,
 -48106,
 1142208549,
 2947,
 -1,
 1142270605,
 3021,
 -1,
 1142169495,
 2946,
 1142506523,
 1142101364,
 -1,
 -48102,
 1142476367,
 3031,
 -1,
 1142535980,
 3064,
 -48100,
 1142482110,
 3061,
 -48099,
 1142666956,
 3065,
 -48098,
 1142723782,
 3024,
 -48097,
 1142785802,
 3060,
 -1,
 1142830013,
 3063,
 -48095,
 1136907868,
 9801,
 -1,
 1142989232,
 9991,
 1143162264,
 1106010495,
 -1,
 1143227714,
 1143089448,
 -1,
 1143293070,
 1143191327,
 -1,
 1143358561,
 1143262995,
 -1,
 1143424047,
 1143325396,
 -1,
 1143489578,
 1143390932,
 -1,
 -48087,
 1143429289,
 3995,
 -1,
 1143477620,
 3994,
 1143686189,
 1143453471,
 -1,
 -48084,
 1143625897,
 4010,
 -1,
 1143674228,
 4009,
 -48082,
 1143625897,
 4000,
 -1,
 1143805300,
 3999,
 1144013880,
 1143354912,
 -1,
 1144079411,
 1143990046,
 -1,
 -48078,
 1144019113,
 4012,
 -1,
 1144067444,
 4011,
 1144276022,
 1144010272,
 -1,
 -48075,
 1144215721,
 3997,
 -1,
 1144264052,
 3996,
 -48073,
 1144215721,
 4002,
 -1,
 1144395124,
 4001,
 1144603709,
 1143965919,
 -1,
 -48070,
 1144579114,
 3993,
 -48069,
 1144621371,
 3998,
 -48068,
 1144673028,
 3988,
 -1,
 1144722804,
 4003,
 1144931393,
 1144567583,
 -1,
 -48065,
 1144895385,
 4021,
 -48064,
 1144936617,
 4020,
 -1,
 1144984948,
 4022,
 1145193541,
 1144877192,
 -1,
 -48061,
 1145159616,
 4025,
 -48060,
 1145198761,
 3985,
 -1,
 1145247092,
 3984,
 1145455689,
 1145131225,
 -1,
 -48057,
 1145431082,
 4027,
 -48056,
 1145494832,
 4026,
 -1,
 1145547183,
 4028,
 1145717836,
 1145431838,
 -1,
 -48053,
 1145657513,
 4014,
 -1,
 1145705844,
 4015,
 1145914447,
 1145675753,
 -1,
 -48050,
 1145854121,
 4005,
 -1,
 1145902452,
 4004,
 1146111058,
 1145852643,
 -1,
 -48047,
 1146050729,
 3987,
 -1,
 1146099060,
 3986,
 1146307669,
 1146039518,
 -1,
 -48044,
 1146247337,
 3990,
 -1,
 1146295668,
 3989,
 1146504280,
 1146234486,
 -1,
 -48041,
 1146443945,
 4007,
 -1,
 1146492276,
 4006,
 -48039,
 1146479658,
 4017,
 -48038,
 1146674480,
 4013,
 -48037,
 1146726831,
 4018,
 -48036,
 1146781746,
 4008,
 -48035,
 1146844077,
 4019,
 -48034,
 1146908459,
 3991,
 -48033,
 1146968233,
 4023,
 -48032,
 1147016564,
 4024,
 -1,
 1147080429,
 4016,
 1147290752,
 1143301513,
 -1,
 1147356274,
 1147251028,
 -1,
 1147421808,
 1147287415,
 -1,
 1147487338,
 1147373927,
 -1,
 1147552873,
 1147425507,
 -1,
 -48025,
 1147519427,
 4047,
 -48024,
 1147572583,
 3870,
 -1,
 1147613239,
 3869,
 -1,
 1147513693,
 4046,
 1147928575,
 1147419309,
 -1,
 1147946095,
 1147818723,
 -1,
 -48019,
 1147912643,
 3868,
 -48018,
 1147965799,
 3867,
 -1,
 1148006455,
 3866,
 -1,
 1147906919,
 3871,
 -48015,
 1147373952,
 3967,
 -1,
 1148219368,
 3966,
 1148404853,
 1147331626,
 -1,
 -48012,
 1148365187,
 3902,
 -1,
 1148423111,
 3975,
 1148601464,
 1148354533,
 -1,
 -48009,
 1148530698,
 3977,
 -1,
 1148592253,
 3903,
 1148798075,
 1148548648,
 -1,
 -48006,
 1148740020,
 3974,
 -1,
 1148797171,
 3976,
 1148994686,
 1148737528,
 -1,
 -48003,
 1148945248,
 3979,
 -1,
 1148988785,
 3978,
 -48001,
 1148960364,
 3971,
 -1,
 1149145432,
 3970,
 1149370367,
 1147266030,
 -1,
 1149387917,
 1149272822,
 -1,
 1149453447,
 1149341145,
 4041,
 1149566975,
 1149370368,
 -1,
 -47995,
 1149473132,
 4042,
 -47994,
 1149523997,
 4043,
 -1,
 1149578437,
 4044,
 1149781129,
 1149414268,
 4037,
 -1,
 1149700563,
 4039,
 1149912204,
 1149738985,
 -1,
 -47989,
 1149853996,
 4040,
 -1,
 1149900843,
 4038,
 -1,
 1149845475,
 4036,
 -1,
 1149336621,
 3840,
 1150239950,
 1143239512,
 -1,
 1150305483,
 1150176307,
 -1,
 1150370969,
 1150272212,
 -1,
 1150436500,
 1150337748,
 -1,
 -47981,
 1150376105,
 3915,
 -1,
 1150424436,
 3914,
 1150633111,
 1150400287,
 -1,
 -47978,
 1150572713,
 3930,
 -1,
 1150621044,
 3929,
 -47976,
 1150572713,
 3920,
 -1,
 1150752116,
 3919,
 1150960802,
 1150301728,
 -1,
 1151026333,
 1150936862,
 -1,
 -47972,
 1150965929,
 3932,
 -1,
 1151014260,
 3931,
 1151222944,
 1150957088,
 -1,
 -47969,
 1151162537,
 3917,
 -1,
 1151210868,
 3916,
 -47967,
 1151162537,
 3922,
 -1,
 1151341940,
 3921,
 1151550631,
 1150912735,
 -1,
 -47964,
 1151525930,
 3913,
 -47963,
 1151568187,
 3918,
 -47962,
 1151619844,
 3908,
 -1,
 1151669620,
 3923,
 1151878316,
 1151496328,
 -1,
 -47959,
 1151844288,
 3945,
 -47958,
 1151889567,
 3947,
 -47957,
 1151948969,
 3905,
 -1,
 1151997300,
 3904,
 1152206000,
 1151842079,
 -1,
 -47954,
 1152169881,
 3941,
 -47953,
 1152211113,
 3940,
 -1,
 1152259444,
 3942,
 1152468147,
 1152182046,
 -1,
 -47950,
 1152407721,
 3934,
 -1,
 1152456052,
 3935,
 1152664758,
 1152428372,
 -1,
 -47947,
 1152625071,
 3948,
 -1,
 1152652660,
 3938,
 1152861369,
 1152622569,
 -1,
 -47944,
 1152800937,
 3925,
 -1,
 1152849268,
 3924,
 1153057980,
 1152799459,
 -1,
 -47941,
 1152997545,
 3907,
 -1,
 1153045876,
 3906,
 1153254591,
 1152986334,
 -1,
 -47938,
 1153194153,
 3910,
 -1,
 1153242484,
 3909,
 1153451202,
 1153181302,
 -1,
 -47935,
 1153390761,
 3927,
 -1,
 1153439092,
 3926,
 -47933,
 1153426474,
 3937,
 -47932,
 1153621296,
 3933,
 -47931,
 1153663026,
 3928,
 -47930,
 1153725357,
 3939,
 -47929,
 1153789739,
 3911,
 -47928,
 1153849513,
 3943,
 -47927,
 1153913061,
 3946,
 -47926,
 1153963380,
 3944,
 -1,
 1154027245,
 3936,
 1154285567,
 1150260043,
 -1,
 -47923,
 1154185829,
 3862,
 -1,
 1154232109,
 3861,
 1154434313,
 1150190175,
 -1,
 1154499802,
 1154372323,
 -1,
 1154565335,
 1154467190,
 -1,
 1154630870,
 1154540924,
 -1,
 1154696405,
 1154552199,
 -1,
 -47916,
 1154659228,
 3842,
 -1,
 1154701353,
 3843,
 -1,
 1154665463,
 3841,
 -1,
 1154599954,
 3860,
 1155071999,
 1154535469,
 -1,
 -47911,
 1154979117,
 3898,
 -1,
 1155015453,
 3899,
 1155220708,
 1154428126,
 -1,
 1155286240,
 1155146121,
 -1,
 1155351775,
 1155206999,
 -1,
 -47906,
 1155302174,
 3859,
 -1,
 1155345617,
 3894,
 -1,
 1155327381,
 3846,
 1155613923,
 1155235296,
 -1,
 -47902,
 1155589546,
 3845,
 -1,
 1155607469,
 4052,
 -1,
 1155554095,
 3896,
 1155876076,
 1155172575,
 -1,
 1155941609,
 1155851739,
 -1,
 1156007144,
 1155910674,
 4050,
 -1,
 1155926547,
 3856,
 -1,
 1155971687,
 3854,
 1156251647,
 1155879858,
 -1,
 -47893,
 1156168200,
 3895,
 -1,
 1156223312,
 3893,
 1156400371,
 1155802742,
 -1,
 1156465906,
 1156364063,
 -1,
 1156531441,
 1156411528,
 -1,
 -47888,
 1156502936,
 3849,
 -1,
 1156519374,
 4048,
 -1,
 1156464730,
 3892,
 -1,
 1156411554,
 3850,
 1156859128,
 1156343600,
 -1,
 1156924663,
 1156804086,
 -1,
 -47882,
 1156900229,
 3844,
 -1,
 1156918161,
 4051,
 -1,
 1156892114,
 3851,
 1157186811,
 1156828163,
 -1,
 -47878,
 1157127165,
 3855,
 -1,
 1157174649,
 3897,
 1157383422,
 1157150495,
 -1,
 -47875,
 1157322953,
 3853,
 -1,
 1157377012,
 3848,
 1157580033,
 1157343572,
 -1,
 -47872,
 1157523255,
 3857,
 -1,
 1157584986,
 3858,
 1157776644,
 1157504641,
 -1,
 -47869,
 1157731629,
 3900,
 -1,
 1157767965,
 3901,
 -47867,
 1157752250,
 3847,
 -47866,
 1157931197,
 3973,
 -47865,
 1157989917,
 4049,
 -47864,
 1158044035,
 3972,
 -1,
 1158100870,
 3852,
 1158300965,
 1154365848,
 -1,
 1158366488,
 1158240656,
 -1,
 1158432014,
 1158333140,
 -1,
 -47859,
 1158406543,
 3883,
 -1,
 1158438998,
 3884,
 1158628625,
 1158395679,
 -1,
 -47856,
 1158573806,
 3887,
 -1,
 1158630530,
 3888,
 1158825236,
 1158565462,
 -1,
 -47853,
 1158781936,
 3885,
 -1,
 1158835831,
 3886,
 -47851,
 1158801301,
 3891,
 -47850,
 1158976959,
 3882,
 -47849,
 1159040188,
 3890,
 -1,
 1159087415,
 3889,
 1159283995,
 1158333140,
 -1,
 -47846,
 1159258511,
 3874,
 -1,
 1159290966,
 3875,
 1159480606,
 1159247647,
 -1,
 -47843,
 1159425774,
 3878,
 -1,
 1159482498,
 3879,
 1159677217,
 1159417430,
 -1,
 -47840,
 1159633904,
 3876,
 -1,
 1159687799,
 3877,
 -47838,
 1159653269,
 3872,
 -47837,
 1159828927,
 3873,
 -47836,
 1159892156,
 3881,
 -1,
 1159939383,
 3880,
 1160135990,
 1158274230,
 -1,
 1160201515,
 1160109071,
 -1,
 1160267049,
 1160161620,
 3958,
 -1,
 1160227156,
 3959,
 1160445951,
 1160213336,
 3960,
 -1,
 1160344408,
 3961,
 1160529197,
 1160171082,
 3956,
 -1,
 1160498762,
 3957,
 1160660271,
 1160490373,
 3968,
 -1,
 1160601983,
 3969,
 1160791345,
 1160614287,
 3964,
 -1,
 1160745359,
 3965,
 1160922419,
 1160733055,
 3954,
 -1,
 1160864127,
 3955,
 1161053493,
 1160855687,
 3962,
 -1,
 1160986759,
 3963,
 -1,
 1160975863,
 3953,
 1161250107,
 1160064458,
 -1,
 -47816,
 1161214038,
 4035,
 -47815,
 1161263806,
 4033,
 -47814,
 1161321419,
 4032,
 -1,
 1161375168,
 4034,
 1161577792,
 1161176133,
 -1,
 1161643327,
 1161541407,
 -1,
 -47810,
 1161582192,
 3863,
 -1,
 1161640732,
 3865,
 -1,
 1161564225,
 3864,
 1161953279,
 1161523980,
 4030,
 -1,
 1161822812,
 4031,
 1162036609,
 1143164970,
 -1,
 1162102144,
 1161984474,
 -1,
 1162167662,
 1162077166,
 -1,
 1162233195,
 1162089844,
 11568,
 1162298698,
 1162163744,
 11575,
 1162364233,
 1162229280,
 11577,
 -1,
 1162303627,
 11578,
 -1,
 1162303627,
 11576,
 1162560845,
 1162274590,
 11619,
 -47796,
 1162536734,
 11621,
 -1,
 1162565771,
 11594,
 1162757456,
 1162527444,
 11612,
 -47793,
 1162724052,
 11615,
 -1,
 1162762379,
 11613,
 1162954067,
 1162721055,
 11609,
 -47790,
 1162917663,
 11610,
 -1,
 1162958987,
 11611,
 1163150678,
 1162899592,
 11581,
 1163263999,
 1163090059,
 11589,
 -1,
 1163155595,
 11583,
 1163347289,
 1163088611,
 11571,
 1163460607,
 1163286667,
 11606,
 -1,
 1163352203,
 11572,
 1163543899,
 1163307348,
 11604,
 -1,
 1163503956,
 11605,
 1163674973,
 1163483275,
 11584,
 -1,
 1163614347,
 11587,
 1163806047,
 1163601526,
 11569,
 -1,
 1163745419,
 11570,
 -47776,
 1163781102,
 11618,
 -47775,
 1163910408,
 11617,
 -47774,
 1163974574,
 11616,
 -47773,
 1164027716,
 11591,
 -47772,
 1164091369,
 11602,
 -47771,
 1164151007,
 11599,
 -47770,
 1164214245,
 11598,
 -47769,
 1164276568,
 11597,
 -47768,
 1164341033,
 11574,
 -47767,
 1164398166,
 11580,
 -47766,
 1164455714,
 11614,
 -1,
 1164514676,
 11588,
 -47764,
 1162202698,
 11603,
 -47763,
 1164665215,
 11593,
 -1,
 1164725817,
 11579,
 1164920186,
 1162134228,
 -1,
 1164985721,
 1164889812,
 -1,
 1165051250,
 1164931208,
 11582,
 -1,
 1164990603,
 11590,
 1165182325,
 1164989155,
 -1,
 -47756,
 1165134047,
 11600,
 -1,
 1165187211,
 11607,
 -47754,
 1165158353,
 11596,
 -47753,
 1165338436,
 11592,
 -47752,
 1165396919,
 11601,
 -1,
 1165449355,
 11586,
 -1,
 1164912156,
 11620,
 1165706621,
 1164847236,
 -1,
 -47748,
 1165651753,
 11573,
 -1,
 1165711499,
 11585,
 1165950975,
 1165628788,
 -1,
 -47745,
 1165878611,
 11608,
 -1,
 1165908243,
 11595,
 -1,
 1162053212,
 11631,
 1166165392,
 1161983566,
 126,
 1166278655,
 1166082048,
 -1,
 1166296459,
 1166186368,
 8764,
 1166409727,
 1166213120,
 -1,
 1166427528,
 1166335858,
 -1,
 -47737,
 1166389979,
 10859,
 -1,
 1166424881,
 10858,
 1166671871,
 1166349947,
 -1,
 -47734,
 1166586015,
 10610,
 -1,
 1166637129,
 11081,
 1166868479,
 1166270322,
 -1,
 1166886287,
 1166752556,
 -1,
 -47730,
 1166813267,
 11807,
 -1,
 1166874229,
 11806,
 -1,
 1166848432,
 11803,
 1167148434,
 1166119226,
 10750,
 -1,
 1167068111,
 68410,
 1167279509,
 1167098931,
 -1,
 -47724,
 1167240996,
 10709,
 -1,
 1167292159,
 10708,
 -47722,
 1167242302,
 8266,
 -47721,
 1167414577,
 10053,
 -1,
 1167474869,
 10717,
 1167672985,
 1143095431,
 -1,
 1167738397,
 1167618904,
 -1,
 1167803929,
 1167708233,
 -1,
 1167869411,
 1167750738,
 -1,
 1167934946,
 1167838298,
 -1,
 1168000420,
 1167906734,
 -1,
 1168065955,
 1167954517,
 -1,
 1168131489,
 1168025940,
 3083,
 -1,
 1168091476,
 3168,
 1168310271,
 1168077656,
 3084,
 -1,
 1168208728,
 3169,
 -1,
 1167988084,
 3125,
 1168459179,
 1167966932,
 -1,
 1168524712,
 1168425684,
 -1,
 -47705,
 1168464041,
 3104,
 -1,
 1168512372,
 3103,
 -47703,
 1168488345,
 3160,
 -47702,
 1168660649,
 3109,
 -1,
 1168708980,
 3108,
 1168917938,
 1168389664,
 -1,
 1168983471,
 1168848416,
 -1,
 -47698,
 1168922793,
 3106,
 -1,
 1168971124,
 3105,
 -47696,
 1168959280,
 3161,
 -47695,
 1169119401,
 3111,
 -1,
 1169167732,
 3110,
 1169376695,
 1168869599,
 -1,
 -47692,
 1169351722,
 3102,
 -47691,
 1169393979,
 3107,
 -47690,
 1169445636,
 3097,
 -1,
 1169495412,
 3112,
 1169704379,
 1169298804,
 3077,
 -47687,
 1169673802,
 3092,
 -47686,
 1169711487,
 3088,
 -1,
 1169757556,
 3078,
 1169966527,
 1169667871,
 -1,
 -47683,
 1169930137,
 3127,
 -47682,
 1169971369,
 3126,
 -1,
 1170019700,
 3128,
 1170228673,
 1169935946,
 3081,
 -1,
 1170198090,
 3082,
 1170359748,
 1170188628,
 -1,
 -47677,
 1170319791,
 3121,
 -1,
 1170347380,
 3120,
 1170556359,
 1170317289,
 -1,
 -47674,
 1170495657,
 3115,
 -1,
 1170543988,
 3114,
 1170752969,
 1170510223,
 3090,
 -1,
 1170706831,
 3091,
 1170884044,
 1170699096,
 -1,
 -47669,
 1170830253,
 3123,
 -1,
 1170871668,
 3122,
 1171080655,
 1170829448,
 -1,
 -47666,
 1171019945,
 3094,
 -1,
 1171068276,
 3093,
 1171277266,
 1171025705,
 -1,
 -47663,
 1171216553,
 3101,
 -1,
 1171264884,
 3100,
 1171473876,
 1171218815,
 3079,
 -1,
 1171415423,
 3080,
 1171604951,
 1171411683,
 -1,
 -47658,
 1171544233,
 3096,
 -1,
 1171592564,
 3095,
 1171801561,
 1171538055,
 3086,
 -1,
 1171734663,
 3087,
 1171932636,
 1171729630,
 -1,
 -47653,
 1171871913,
 3099,
 -1,
 1171920244,
 3098,
 1172129247,
 1171859062,
 -1,
 -47650,
 1172068521,
 3117,
 -1,
 1172116852,
 3116,
 -47648,
 1172104234,
 3119,
 -47647,
 1172275250,
 3118,
 -1,
 1172330665,
 3129,
 -1,
 1167887440,
 3157,
 1172588021,
 1167842486,
 -1,
 1172653545,
 1172560911,
 -1,
 1172719079,
 1172613460,
 3139,
 -1,
 1172678996,
 3140,
 1172897791,
 1172665176,
 3170,
 -1,
 1172796248,
 3171,
 1172981229,
 1172575604,
 -1,
 -47637,
 1172950602,
 3148,
 -47636,
 1172988287,
 3144,
 -1,
 1173034356,
 3134,
 1173243375,
 1172950602,
 3137,
 -1,
 1173212746,
 3138,
 1173374449,
 1173197199,
 3146,
 -1,
 1173328271,
 3147,
 1173505523,
 1173315967,
 3135,
 -1,
 1173447039,
 3136,
 1173684223,
 1173438599,
 3142,
 -1,
 1173569671,
 3143,
 1173767683,
 1172519320,
 -1,
 1173833209,
 1173734100,
 -1,
 -47624,
 1173807503,
 3176,
 -1,
 1173839958,
 3177,
 1174029820,
 1173796639,
 -1,
 -47621,
 1173974766,
 3180,
 -1,
 1174031490,
 3181,
 1174226431,
 1173966422,
 -1,
 -47618,
 1174182896,
 3178,
 -1,
 1174236791,
 3179,
 -47616,
 1174202261,
 3174,
 -47615,
 1174377919,
 3175,
 -47614,
 1174441148,
 3183,
 -1,
 1174488375,
 3182,
 1174685199,
 1173705261,
 -1,
 1174750731,
 1174651604,
 -1,
 1174816264,
 1174725185,
 -1,
 -47609,
 1174770332,
 3194,
 -1,
 1174817942,
 3197,
 1175060479,
 1174757575,
 -1,
 -47606,
 1174966940,
 3195,
 -1,
 1175014550,
 3198,
 1175209486,
 1174705633,
 -1,
 -47603,
 1175163548,
 3193,
 -1,
 1175211158,
 3196,
 -1,
 1175185306,
 3192,
 1175471640,
 1174649904,
 -1,
 1175537171,
 1175444325,
 -1,
 -47598,
 1175500837,
 3075,
 -1,
 1175562893,
 3149,
 1175733782,
 1175459188,
 -1,
 -47595,
 1175705541,
 3133,
 -1,
 1175752901,
 3074,
 -47593,
 1175702845,
 3199,
 -1,
 1175858612,
 3073,
 -1,
 1175394597,
 3158,
 1176174591,
 1167739055,
 -1,
 -47589,
 1176091691,
 8481,
 -47588,
 1176153057,
 8981,
 -1,
 1176206540,
 9990,
 1176389267,
 1167706766,
 -1,
 1176454704,
 1176317150,
 -1,
 1176520233,
 1176408463,
 -1,
 1176585766,
 1176471775,
 -1,
 1176651301,
 1176552148,
 -1,
 -47581,
 1176611552,
 119563,
 -47580,
 1176651817,
 119582,
 -1,
 1176704917,
 119573,
 -1,
 1176617031,
 119608,
 1177026559,
 1176536971,
 -1,
 -47576,
 1176920686,
 119634,
 -1,
 1176980454,
 119630,
 1177175598,
 1176468901,
 -1,
 1177241133,
 1177108615,
 -1,
 -47572,
 1177193371,
 119590,
 -1,
 1177237048,
 119613,
 -1,
 1177212381,
 119631,
 -47569,
 1177115212,
 119585,
 -1,
 1177438256,
 119558,
 1177634366,
 1176385056,
 -1,
 1177699895,
 1177575807,
 -1,
 1177765429,
 1177649125,
 -1,
 -47564,
 1177716089,
 119625,
 -1,
 1177774427,
 119612,
 -47562,
 1177737676,
 119568,
 -1,
 1177898959,
 119636,
 1178093115,
 1177632903,
 -1,
 -47559,
 1178050927,
 119623,
 -47558,
 1178095440,
 119567,
 -1,
 1178153211,
 119586,
 -47556,
 1178064726,
 119584,
 -47555,
 1178311553,
 119619,
 -1,
 1178345958,
 119624,
 1178551879,
 1177567367,
 -1,
 1178617411,
 1178503391,
 -1,
 -47551,
 1178563956,
 119603,
 -47550,
 1178613603,
 119583,
 -1,
 1178678182,
 119600,
 -47548,
 1178592130,
 119626,
 -47547,
 1178846659,
 119610,
 -47546,
 1178895050,
 119618,
 -1,
 1178936118,
 119580,
 1179141713,
 1178511700,
 -1,
 1179207248,
 1179074695,
 -1,
 1179272782,
 1179170591,
 -1,
 1179338317,
 1179214207,
 -1,
 -47540,
 1179304000,
 119579,
 -1,
 1179334585,
 119596,
 -1,
 1179297099,
 119598,
 -47537,
 1179219574,
 119578,
 -1,
 1179522903,
 119572,
 -1,
 1179151964,
 119605,
 1179797082,
 1179078230,
 -1,
 1179862613,
 1179767030,
 -1,
 -47532,
 1179814811,
 119595,
 -1,
 1179845269,
 119559,
 1180059224,
 1179816335,
 -1,
 -47529,
 1180024939,
 119638,
 -1,
 1180073114,
 119576,
 -47527,
 1180007052,
 119606,
 -1,
 1180178797,
 119632,
 1180386914,
 1179760415,
 -1,
 1180452448,
 1180353236,
 -1,
 1180517983,
 1180406159,
 -1,
 -47522,
 1180489972,
 119601,
 -1,
 1180542352,
 119628,
 -1,
 1180478678,
 119593,
 -47519,
 1180395896,
 119621,
 -1,
 1180716250,
 119627,
 1180911208,
 1180324579,
 -1,
 1180976741,
 1180837111,
 119592,
 -1,
 1180894357,
 119615,
 -47514,
 1180946121,
 119614,
 -47513,
 1181068215,
 119602,
 -1,
 1181127594,
 119599,
 1181304430,
 1180868585,
 -1,
 1181369964,
 1181226356,
 -1,
 -47509,
 1181338720,
 119604,
 -1,
 1181364570,
 119588,
 -47507,
 1181341161,
 119594,
 -1,
 1181501331,
 119571,
 1181697651,
 1181226356,
 -1,
 -47504,
 1181661298,
 119564,
 -47503,
 1181701278,
 119633,
 -47502,
 1181761636,
 119577,
 -1,
 1181822588,
 119617,
 1182025335,
 1181646821,
 -1,
 -47499,
 1181969537,
 119560,
 -47498,
 1182024059,
 119609,
 -1,
 1182082025,
 119616,
 1182287484,
 1181971288,
 -1,
 1182353019,
 1182209396,
 -1,
 -47494,
 1182326036,
 119597,
 -1,
 1182346049,
 119637,
 -1,
 1182287031,
 119589,
 1182615168,
 1182213750,
 -1,
 -47490,
 1182575289,
 119566,
 -47489,
 1182635076,
 119587,
 -1,
 1182671451,
 119561,
 1182877315,
 1182588208,
 -1,
 -47486,
 1182844015,
 119620,
 -1,
 1182887421,
 119575,
 1183073926,
 1182830991,
 -1,
 -47483,
 1183032745,
 119565,
 -1,
 1183090943,
 119635,
 1183270537,
 1183019144,
 -1,
 -47480,
 1183213960,
 119591,
 -1,
 1183269739,
 119562,
 1183467148,
 1183213360,
 -1,
 -47477,
 1183419274,
 119622,
 -1,
 1183462326,
 119570,
 1183663759,
 1183406219,
 -1,
 -47474,
 1183618131,
 119574,
 -1,
 1183654239,
 119629,
 -47472,
 1183639131,
 119569,
 -47471,
 1183832268,
 119607,
 -47470,
 1183896257,
 119611,
 -1,
 1183936583,
 119581,
 1184122518,
 1176340703,
 -1,
 -47467,
 1184088788,
 9978,
 -1,
 1184125989,
 8376,
 1184366591,
 1184047463,
 -1,
 -47464,
 1184284479,
 10043,
 -1,
 1184311182,
 10170,
 1184515963,
 1167612043,
 -1,
 1184581471,
 1184437620,
 -1,
 1184646939,
 1184522625,
 -1,
 1184712461,
 1184574686,
 -1,
 1184777996,
 1184651926,
 -1,
 1184843445,
 1184741151,
 -1,
 1184908975,
 1184768148,
 -1,
 1184974503,
 1184830836,
 3632,
 1185040036,
 1184915875,
 -1,
 -47453,
 1185009349,
 3651,
 -1,
 1185028708,
 3652,
 -47451,
 1184989157,
 3635,
 -47450,
 1185169543,
 3649,
 -1,
 1185224052,
 3634,
 1185433259,
 1184943690,
 3640,
 1185498794,
 1185366151,
 3638,
 -1,
 1185431687,
 3639,
 -1,
 1185467978,
 3641,
 1185695405,
 1185374591,
 3636,
 -1,
 1185636735,
 3637,
 -47442,
 1185649039,
 3650,
 -1,
 1185759367,
 3648,
 1186004991,
 1184862609,
 -1,
 1186023092,
 1185920799,
 -1,
 -47438,
 1185992382,
 3626,
 -47437,
 1186042255,
 3595,
 -1,
 1186077270,
 3624,
 -1,
 1185986269,
 3625,
 1186350788,
 1184809684,
 -1,
 1186416321,
 1186289803,
 -1,
 1186481856,
 1186369937,
 -1,
 1186547390,
 1186448911,
 -1,
 1186612924,
 1186469236,
 -1,
 -47429,
 1186564319,
 3600,
 -1,
 1186617881,
 3607,
 -47427,
 1186583153,
 3606,
 -1,
 1186764307,
 3608,
 -47425,
 1186505598,
 3602,
 -1,
 1186892182,
 3601,
 -1,
 1186406249,
 3660,
 1187184639,
 1186369937,
 -1,
 -47421,
 1187103776,
 3605,
 -1,
 1187160451,
 3599,
 1187333840,
 1186299877,
 -1,
 1187399375,
 1187256610,
 -1,
 1187464909,
 1187315712,
 -1,
 1187530442,
 1187431124,
 -1,
 -47415,
 1187491321,
 3658,
 -1,
 1187536479,
 3657,
 -47413,
 1187469869,
 3633,
 -47412,
 1187661213,
 3656,
 -1,
 1187721049,
 3659,
 -47410,
 1187439723,
 3654,
 -1,
 1187890044,
 3655,
 -1,
 1187353006,
 3617,
 1188120283,
 1187278984,
 -1,
 1188185818,
 1188060767,
 -1,
 1188251353,
 1188102144,
 -1,
 1188316888,
 1188196868,
 -1,
 -47403,
 1188289863,
 3588,
 -47402,
 1188351709,
 3587,
 -47401,
 1188402477,
 3589,
 -1,
 1188436258,
 3586,
 -1,
 1188276841,
 3590,
 -1,
 1188202655,
 3675,
 -1,
 1188139432,
 3585,
 1188841189,
 1188077545,
 -1,
 1188906723,
 1188780171,
 -1,
 1188972258,
 1188860305,
 -1,
 1189037793,
 1188930351,
 -1,
 -47392,
 1189007985,
 3612,
 -1,
 1189027134,
 3614,
 -1,
 1189001190,
 3616,
 -1,
 1188915824,
 3642,
 -47388,
 1188860343,
 3611,
 -1,
 1189288365,
 3631,
 1189496555,
 1188792543,
 -1,
 1189562089,
 1189450163,
 -1,
 -47384,
 1189531210,
 3609,
 -1,
 1189562097,
 3603,
 -47382,
 1189504443,
 3661,
 -1,
 1189697056,
 3591,
 1189889777,
 1189442392,
 -1,
 1189955311,
 1189843345,
 -1,
 -47378,
 1189903195,
 3621,
 -1,
 1189949458,
 3628,
 -47376,
 1189924426,
 3622,
 -1,
 1190074852,
 3653,
 1190282998,
 1189818315,
 -1,
 1190348532,
 1190206782,
 3592,
 -1,
 1190286051,
 3594,
 -47371,
 1190302421,
 3596,
 -1,
 1190422695,
 3593,
 1190610683,
 1190257646,
 -1,
 1190676218,
 1190564307,
 -1,
 -47367,
 1190619303,
 3597,
 -1,
 1190664640,
 3618,
 -1,
 1190599811,
 3662,
 1190938367,
 1190547828,
 -1,
 1191003902,
 1190855603,
 3613,
 -1,
 1190955231,
 3615,
 -1,
 1190956088,
 3663,
 1191200514,
 1190898004,
 -1,
 -47359,
 1191169610,
 3620,
 -1,
 1191219645,
 3619,
 1191397125,
 1191140962,
 -1,
 -47356,
 1191349678,
 3630,
 -1,
 1191402909,
 3627,
 1191593736,
 1191328455,
 -1,
 -47353,
 1191524211,
 3604,
 -1,
 1191587640,
 3598,
 -47351,
 1191568005,
 3623,
 -47350,
 1191743892,
 3629,
 -47349,
 1191783065,
 3610,
 -1,
 1191845546,
 3674,
 -1,
 1184749107,
 3647,
 1192165375,
 1184643480,
 -1,
 1192183569,
 1192084180,
 -1,
 -47344,
 1192157583,
 3666,
 -1,
 1192190038,
 3667,
 1192380180,
 1192146719,
 -1,
 -47341,
 1192324846,
 3670,
 -1,
 1192381570,
 3671,
 1192576791,
 1192316502,
 -1,
 -47338,
 1192532976,
 3668,
 -1,
 1192586871,
 3669,
 -47336,
 1192552341,
 3664,
 -47335,
 1192727999,
 3665,
 -47334,
 1192791228,
 3673,
 -1,
 1192838455,
 3672,
 1193082879,
 1184570705,
 -1,
 1193101137,
 1192983002,
 -1,
 1193166627,
 1193067220,
 -1,
 1193232160,
 1193105580,
 1932,
 -1,
 1193180955,
 1947,
 -47327,
 1193198372,
 1944,
 -47326,
 1193316751,
 1952,
 -1,
 1193354750,
 1939,
 1193559849,
 1193129759,
 -1,
 1193625383,
 1193498763,
 -1,
 -47322,
 1193558886,
 1949,
 -1,
 1193616894,
 1921,
 -47320,
 1193558886,
 1936,
 -1,
 1193743866,
 1950,
 1193953070,
 1193535262,
 -1,
 1194018605,
 1193874804,
 -1,
 -47316,
 1193991173,
 1938,
 -1,
 1194005876,
 1948,
 -1,
 1193972111,
 1953,
 1194280754,
 1193890531,
 -1,
 -47312,
 1194232322,
 1935,
 -47311,
 1194285408,
 1955,
 -1,
 1194333700,
 1934,
 1194542903,
 1194210848,
 -1,
 1194608438,
 1194464628,
 -1,
 -47307,
 1194580997,
 1937,
 -1,
 1194596373,
 1951,
 -1,
 1194547376,
 1931,
 1194870586,
 1194494175,
 -1,
 -47303,
 1194825419,
 1922,
 -1,
 1194857975,
 1969,
 1195067197,
 1194816344,
 -1,
 -47300,
 1195006738,
 1925,
 -1,
 1195054607,
 1933,
 1195263808,
 1195012232,
 -1,
 -47297,
 1195202732,
 1946,
 -1,
 1195251204,
 1926,
 1195460419,
 1195202699,
 -1,
 -47294,
 1195399340,
 1945,
 -1,
 1195447799,
 1920,
 1195657030,
 1195382132,
 -1,
 -47291,
 1195604615,
 1927,
 -1,
 1195666055,
 1954,
 -47289,
 1195631665,
 1940,
 -47288,
 1195826492,
 1957,
 -47287,
 1195890623,
 1928,
 -47286,
 1195944386,
 1923,
 -47285,
 1196009298,
 1956,
 -47284,
 1196073353,
 1941,
 -47283,
 1196131259,
 1929,
 -47282,
 1196191548,
 1942,
 -47281,
 1196248770,
 1930,
 -47280,
 1196306274,
 1943,
 -1,
 1196369579,
 1924,
 1196574549,
 1193054607,
 -1,
 -47277,
 1196528177,
 1963,
 -47276,
 1196567213,
 1966,
 -1,
 1196627559,
 1967,
 1196836697,
 1196507271,
 -1,
 -47273,
 1196811435,
 1965,
 -47272,
 1196835330,
 1961,
 -1,
 1196894251,
 1964,
 1197098844,
 1196758388,
 -1,
 -47269,
 1197024986,
 1958,
 -1,
 1197086246,
 1959,
 -47267,
 1197068256,
 1962,
 -47266,
 1197261237,
 1968,
 -1,
 1197302489,
 1960,
 1197492080,
 1184541776,
 -1,
 1197557611,
 1197408256,
 -1,
 1197623142,
 1197503320,
 -1,
 1197688677,
 1197566095,
 -1,
 -47260,
 1197649505,
 9886,
 -1,
 1197700741,
 9887,
 -1,
 1197622340,
 11057,
 1197950825,
 1197553184,
 -1,
 -47256,
 1197906543,
 8278,
 -1,
 1197958827,
 10176,
 -47254,
 1197912279,
 8694,
 -1,
 1198076537,
 10870,
 1198325759,
 1197477587,
 -1,
 1198344047,
 1198208546,
 -1,
 -47250,
 1198312005,
 10146,
 -1,
 1198336797,
 10147,
 -1,
 1198301785,
 8196,
 1198606199,
 1197427039,
 -1,
 1198671734,
 1198538887,
 -1,
 1198737269,
 1198587904,
 -1,
 -47244,
 1198673291,
 8707,
 -1,
 1198734039,
 8708,
 -1,
 1198674312,
 8756,
 -1,
 1198622366,
 10727,
 1199064954,
 1198576194,
 -1,
 -47239,
 1199030478,
 9736,
 -1,
 1199047331,
 9928,
 -1,
 1199007605,
 8201,
 1199327143,
 1184475476,
 -1,
 1199392675,
 1199268223,
 -1,
 1199458192,
 1199350796,
 -1,
 1199523715,
 1199430249,
 -1,
 -47232,
 1199497267,
 10997,
 -47231,
 1199550527,
 8874,
 -47230,
 1199585148,
 10624,
 -1,
 1199647076,
 10996,
 1199851398,
 1199480809,
 -1,
 -47227,
 1199813019,
 8244,
 -1,
 1199865701,
 10747,
 1200048009,
 1199803296,
 -1,
 -47224,
 1199995215,
 10999,
 -1,
 1200051959,
 11000,
 1200244620,
 1199988455,
 -1,
 -47221,
 1200212892,
 10857,
 -1,
 1200242101,
 10856,
 -47219,
 1200211964,
 8779,
 -47218,
 1200406177,
 11003,
 -47217,
 1200449987,
 8749,
 -1,
 1200501233,
 10998,
 1200703386,
 1199396490,
 -1,
 1200768916,
 1200676104,
 -1,
 -47213,
 1200711647,
 9780,
 -1,
 1200759978,
 9781,
 -47211,
 1200736174,
 9779,
 -47210,
 1200916307,
 9782,
 -47209,
 1200977069,
 9777,
 -47208,
 1201036159,
 9776,
 -47207,
 1201098897,
 9778,
 -1,
 1201160548,
 9783,
 1201358754,
 1200627296,
 -1,
 1201424289,
 1201305170,
 -1,
 1201489824,
 1201343523,
 -1,
 -47202,
 1201459799,
 10699,
 -47201,
 1201519036,
 10701,
 -1,
 1201552177,
 10698,
 -1,
 1201410005,
 10141,
 -1,
 1201393858,
 8227,
 -1,
 1201287659,
 8285,
 1201948582,
 1199314292,
 -1,
 -47195,
 1201901325,
 10971,
 -1,
 1201944397,
 8482,
 -1,
 1201917966,
 8872,
 1202210765,
 1199280527,
 -1,
 1202276284,
 1202167787,
 -1,
 1202341806,
 1202237031,
 -1,
 1202407341,
 1202269406,
 -1,
 -47188,
 1202369636,
 8974,
 -1,
 1202428268,
 8989,
 -1,
 1202346409,
 11811,
 1202669491,
 1202288266,
 -1,
 1202735026,
 1202597086,
 -1,
 -47183,
 1202697316,
 8975,
 -1,
 1202755948,
 8988,
 -1,
 1202674089,
 11810,
 1202997175,
 1202594081,
 -1,
 1203062710,
 1202921331,
 10554,
 -1,
 1202982405,
 10557,
 -1,
 1202991483,
 10556,
 -47176,
 1202965101,
 9184,
 -47175,
 1203224414,
 9140,
 -47174,
 1203282214,
 9180,
 -47173,
 1203329478,
 8992,
 -1,
 1203385749,
 9182,
 1203587020,
 1202239054,
 -1,
 1203652555,
 1203515662,
 -1,
 1203718082,
 1203573889,
 -1,
 -47168,
 1203639558,
 127552,
 -47167,
 1203704945,
 127560,
 -1,
 1203770171,
 127557,
 1203980229,
 1203639494,
 -1,
 -47164,
 1203901634,
 127558,
 -1,
 1203966475,
 127556,
 1204176840,
 1203901449,
 -1,
 -47161,
 1204102820,
 127555,
 -1,
 1204163397,
 127559,
 1204420607,
 1204098054,
 -1,
 -47158,
 1204294970,
 127554,
 -1,
 1204359688,
 127553,
 -1,
 1203598816,
 127274,
 -1,
 1203553208,
 9008,
 1204701150,
 1202179658,
 -1,
 1204766685,
 1204663225,
 -1,
 1204832213,
 1204729631,
 -1,
 1204897748,
 1204756245,
 -1,
 -47150,
 1204872174,
 8516,
 -47149,
 1204908888,
 8514,
 -1,
 1204966115,
 8513,
 -1,
 1204846969,
 8526,
 1205225432,
 1204753780,
 -1,
 -47145,
 1205177343,
 10658,
 -1,
 1205241713,
 8523,
 -47143,
 1205198577,
 9929,
 -47142,
 1205374601,
 8985,
 -47141,
 1205426105,
 8489,
 -47140,
 1205480944,
 8498,
 -1,
 1205545525,
 9930,
 -1,
 1204705246,
 8366,
 1205862399,
 1204673800,
 -1,
 1205880814,
 1205768593,
 -1,
 1205946341,
 1205812008,
 -1,
 1206011876,
 1205862400,
 -1,
 -47133,
 1205970671,
 8282,
 -1,
 1206023791,
 8229,
 -1,
 1205974894,
 11818,
 1206274024,
 1205894381,
 -1,
 -47129,
 1206229090,
 10760,
 -1,
 1206263289,
 10759,
 1206470635,
 1206217246,
 -1,
 -47126,
 1206425590,
 10838,
 -1,
 1206459751,
 10837,
 -47124,
 1206415389,
 10697,
 -47123,
 1206596217,
 10869,
 -1,
 1206658061,
 8273,
 -1,
 1205814834,
 10041,
 1206930780,
 1105966879,
 -1,
 1206995308,
 1206888388,
 -1,
 1207060843,
 1206954884,
 -1,
 1207126303,
 1206976512,
 -1,
 1207191588,
 1207074789,
 -1,
 1207257085,
 1207160396,
 -1,
 -47114,
 1207229704,
 13244,
 -47113,
 1207293870,
 13238,
 -47112,
 1207351071,
 13234,
 -47111,
 1207402469,
 13211,
 -47110,
 1207464792,
 13205,
 -47109,
 1207522019,
 13197,
 -47108,
 1207586390,
 13196,
 -1,
 1207637364,
 13186,
 1207846916,
 1207178612,
 13187,
 1207912449,
 1207787903,
 -1,
 -47104,
 1207875178,
 13124,
 -1,
 1207923486,
 13123,
 -47102,
 1207875212,
 13126,
 -47101,
 1208061731,
 13127,
 -1,
 1208114309,
 13125,
 1208305675,
 1207762944,
 -1,
 1208371209,
 1208258959,
 -1,
 1208436744,
 1208342964,
 13223,
 -1,
 1208355446,
 13224,
 -1,
 1208376899,
 13249,
 -47094,
 1208336237,
 13217,
 -1,
 1208563049,
 13221,
 1208764432,
 1208246655,
 -1,
 1208829966,
 1208724985,
 13129,
 -1,
 1208755887,
 13130,
 -47089,
 1208775512,
 13269,
 -1,
 1208906531,
 13128,
 1209092116,
 1208713189,
 13212,
 1209204735,
 1209008128,
 -1,
 -47085,
 1209122669,
 13215,
 -1,
 1209152873,
 13219,
 1209354264,
 1209024647,
 -1,
 1209419799,
 1209291524,
 13131,
 -1,
 1209387424,
 13132,
 -1,
 1209355252,
 13133,
 1209616410,
 1209326856,
 13245,
 -1,
 1209533902,
 13247,
 1209747484,
 1209587630,
 13239,
 -1,
 1209664974,
 13241,
 1209878558,
 1209673334,
 13190,
 -1,
 1209797214,
 13268,
 -47073,
 1209841439,
 13235,
 -47072,
 1209966670,
 13227,
 -47071,
 1210029074,
 13270,
 -47070,
 1210086232,
 13206,
 -47069,
 1210147196,
 13202,
 -1,
 1210208995,
 13198,
 1210402887,
 1207136392,
 -1,
 1210468395,
 1210351589,
 13214,
 1210580991,
 1210384384,
 -1,
 1210599466,
 1210461406,
 -1,
 -47063,
 1210568441,
 13222,
 -1,
 1210589134,
 13262,
 -1,
 1210564461,
 13218,
 1210861615,
 1210412200,
 13076,
 -47059,
 1210834424,
 13079,
 -47058,
 1210876865,
 13078,
 -1,
 1210931264,
 13077,
 1211123764,
 1210783092,
 13188,
 1211189299,
 1211083092,
 -1,
 -47054,
 1211144425,
 13069,
 -1,
 1211180405,
 13068,
 -1,
 1211133075,
 13067,
 1211451447,
 1211094399,
 -1,
 -47050,
 1211422619,
 13082,
 -1,
 1211471558,
 13083,
 1211648058,
 1211404687,
 -1,
 -47047,
 1211610800,
 13085,
 -1,
 1211668361,
 13086,
 -47045,
 1211623140,
 13074,
 -47044,
 1211817224,
 13246,
 -47043,
 1211881390,
 13240,
 -47042,
 1211941588,
 13263,
 -47041,
 1211998286,
 13226,
 -47040,
 1212052312,
 13208,
 -47039,
 1212117128,
 13261,
 -47038,
 1212178812,
 13201,
 -47037,
 1212240611,
 13199,
 -47036,
 1212302200,
 13084,
 -47035,
 1212362062,
 13193,
 -47034,
 1212425846,
 13189,
 -1,
 1212483146,
 13248,
 1212696676,
 1210359785,
 -1,
 1212762190,
 1212629127,
 -1,
 1212827724,
 1212713183,
 -1,
 -47029,
 1212793208,
 13114,
 -1,
 1212835217,
 13112,
 -47027,
 1212792437,
 13111,
 -1,
 1212960333,
 13115,
 1213155411,
 1212683636,
 13225,
 1213220946,
 1213076852,
 -1,
 -47023,
 1213189257,
 13100,
 -1,
 1213249912,
 13099,
 -1,
 1213137008,
 13184,
 1213483096,
 1213096319,
 -1,
 1213548631,
 1213427848,
 -1,
 -47018,
 1213519448,
 13103,
 -1,
 1213567375,
 13104,
 -1,
 1213473892,
 13102,
 1213810779,
 1213436303,
 -1,
 -47014,
 1213762287,
 13120,
 -1,
 1213819510,
 13117,
 -47012,
 1213783304,
 13242,
 -47011,
 1213978542,
 13236,
 -47010,
 1214035743,
 13232,
 -47009,
 1214097748,
 13274,
 -47008,
 1214162083,
 13273,
 -47007,
 1214218213,
 13272,
 -47006,
 1214273675,
 13271,
 -47005,
 1214336598,
 13194,
 -1,
 1214393566,
 13174,
 1214597244,
 1212669192,
 -1,
 1214662778,
 1214541268,
 -1,
 1214728301,
 1214633049,
 -1,
 1214793834,
 1214688871,
 -1,
 -46999,
 1214761290,
 9640,
 -1,
 1214789875,
 11028,
 1215037439,
 1214740106,
 -1,
 -46996,
 1214957917,
 9639,
 -1,
 1214986483,
 9705,
 1215187058,
 1214673752,
 -1,
 1215252593,
 1215143750,
 -1,
 -46992,
 1215213281,
 9706,
 -1,
 1215264448,
 11029,
 -1,
 1215185856,
 9703,
 -46989,
 1215158983,
 9637,
 -46988,
 1215482387,
 11026,
 -46987,
 1215541028,
 9704,
 -46986,
 1215601081,
 9638,
 -46985,
 1215651634,
 9636,
 -46984,
 1215707354,
 9641,
 -46983,
 1215771438,
 10720,
 -1,
 1215834862,
 11027,
 -46981,
 1214588534,
 13277,
 -1,
 1215964533,
 13143,
 1216170128,
 1214535819,
 -1,
 1216235649,
 1216138826,
 -1,
 -46977,
 1216195227,
 13109,
 -46976,
 1216243106,
 13107,
 -1,
 1216291020,
 13106,
 1216497798,
 1216188815,
 -1,
 1216563333,
 1216450959,
 -1,
 -46972,
 1216525930,
 13121,
 -1,
 1216579807,
 13122,
 -1,
 1216514271,
 13119,
 1216825480,
 1216454633,
 13259,
 -1,
 1216746868,
 13169,
 1216956555,
 1216757895,
 -1,
 -46966,
 1216919266,
 13113,
 -1,
 1216967478,
 13110,
 1217153165,
 1216877940,
 13258,
 -1,
 1217097304,
 13098,
 -46962,
 1217128222,
 13200,
 -46961,
 1217227781,
 127488,
 -1,
 1217286883,
 13004,
 1217480863,
 1216107235,
 -1,
 1217546389,
 1217421695,
 -1,
 -46957,
 1217508983,
 13075,
 -46956,
 1217563824,
 13073,
 -1,
 1217614596,
 13072,
 1217808537,
 1217467764,
 -1,
 -46953,
 1217770554,
 13070,
 -46952,
 1217826166,
 13071,
 -1,
 1217885016,
 13311,
 1218070683,
 1217779125,
 13080,
 -1,
 1218038176,
 13081,
 -46948,
 1218044910,
 13257,
 -46947,
 1218158670,
 13228,
 -46946,
 1218208124,
 13203,
 -1,
 1218258550,
 13191,
 1218463918,
 1217440084,
 -1,
 1218529444,
 1218404735,
 -1,
 -46942,
 1218497667,
 13137,
 -46941,
 1218554287,
 13138,
 -1,
 1218598155,
 10958,
 1218791591,
 1218451414,
 13229,
 1218904063,
 1218709497,
 13230,
 -1,
 1218775670,
 13231,
 1218988202,
 1218760266,
 -1,
 -46935,
 1218957288,
 13140,
 -1,
 1219011496,
 13139,
 1219184813,
 1218920583,
 -1,
 -46932,
 1219137524,
 13142,
 -1,
 1219200945,
 13141,
 -1,
 1219139280,
 8730,
 1219446972,
 1218391262,
 -1,
 1219512499,
 1219395557,
 13213,
 1219624959,
 1219428352,
 -1,
 -46926,
 1219542893,
 13216,
 -1,
 1219573097,
 13220,
 1219774645,
 1219465615,
 13255,
 -1,
 1219736914,
 13183,
 1219905720,
 1219695988,
 -1,
 -46921,
 1219862505,
 8851,
 -1,
 1219916632,
 13192,
 -46919,
 1219875588,
 8852,
 -46918,
 1220032032,
 13253,
 -46917,
 1220095198,
 13252,
 -1,
 1220151153,
 13254,
 1220364488,
 1219376672,
 -1,
 1220430017,
 1220313061,
 13175,
 1220542463,
 1220345856,
 -1,
 -46912,
 1220460397,
 13176,
 -1,
 1220490601,
 13177,
 1220692163,
 1220351348,
 13170,
 -1,
 1220617304,
 13092,
 -46908,
 1220647414,
 13094,
 -46907,
 1220768600,
 13207,
 -46906,
 1220833065,
 127376,
 -46905,
 1220889249,
 13093,
 -1,
 1220945526,
 13256,
 1221150929,
 1220315359,
 -1,
 1221216459,
 1221072244,
 13185,
 -1,
 1221168526,
 13096,
 -46900,
 1221188872,
 13243,
 -46899,
 1221318574,
 13237,
 -46898,
 1221375775,
 13233,
 -46897,
 1221434138,
 13097,
 -46896,
 1221492709,
 13210,
 -1,
 1221545558,
 13195,
 1221740764,
 1221083271,
 -1,
 1221806297,
 1221699924,
 -1,
 1221871832,
 1221727629,
 -1,
 -46891,
 1221837709,
 13181,
 -46890,
 1221903041,
 13180,
 -46889,
 1221952462,
 13182,
 -1,
 1222007834,
 13179,
 -1,
 1221808867,
 13005,
 -46886,
 1221777326,
 13006,
 -46885,
 1222230459,
 13063,
 -1,
 1222264237,
 13064,
 1222461670,
 1221703455,
 -1,
 1222527200,
 1222395842,
 -1,
 -46881,
 1222480271,
 13091,
 -1,
 1222533503,
 13090,
 1222723811,
 1222448500,
 -1,
 -46878,
 1222676423,
 13088,
 -1,
 1222731223,
 13087,
 -46876,
 1222694830,
 13276,
 -46875,
 1222879572,
 13275,
 -1,
 1222929559,
 13089,
 1223117039,
 1222402431,
 -1,
 1223182570,
 1223067871,
 13260,
 -46871,
 1223149498,
 13061,
 -1,
 1223190804,
 13060,
 1223379182,
 1223131246,
 8847,
 1223491583,
 1223296671,
 -1,
 -46867,
 1223396965,
 8932,
 -1,
 1223444743,
 8849,
 -1,
 1223347786,
 13178,
 1223706872,
 1223042678,
 -1,
 1223772403,
 1223628148,
 -1,
 -46862,
 1223731540,
 13172,
 -1,
 1223762307,
 13101,
 -46860,
 1223743182,
 13108,
 -46859,
 1223927620,
 13251,
 -46858,
 1223989754,
 13118,
 -46857,
 1224043752,
 13105,
 -1,
 1224098685,
 13116,
 1224296704,
 1223628148,
 -1,
 -46854,
 1224265290,
 13171,
 -46853,
 1224324737,
 13057,
 -46852,
 1224384627,
 13056,
 -46851,
 1224445648,
 13058,
 -46850,
 1224507365,
 13250,
 -46849,
 1224549102,
 13059,
 -1,
 1224607654,
 13279,
 1224821000,
 1224249743,
 -1,
 1224886533,
 1224782164,
 8848,
 1224998911,
 1224803999,
 -1,
 -46844,
 1224904293,
 8933,
 -1,
 1224952071,
 8850,
 -46842,
 1224857518,
 13173,
 -46841,
 1225102633,
 13066,
 -1,
 1225166563,
 13065,
 1225345296,
 1224766296,
 -1,
 1225410828,
 1225298319,
 -1,
 -46837,
 1225385867,
 8977,
 -1,
 1225413347,
 13266,
 -46835,
 1225384708,
 13267,
 -46834,
 1225558239,
 13265,
 -46833,
 1225621477,
 13264,
 -1,
 1225671640,
 10957,
 1225869589,
 1225319406,
 -1,
 1225935124,
 1225790967,
 -1,
 -46829,
 1225897578,
 13135,
 -1,
 1225931460,
 13134,
 -1,
 1225903813,
 13136,
 1226197274,
 1225805398,
 -1,
 1226262809,
 1226150287,
 -1,
 -46824,
 1226233218,
 9974,
 -1,
 1226283594,
 9165,
 -1,
 1226211301,
 13209,
 1226524957,
 1226162900,
 -1,
 -46820,
 1226478893,
 13095,
 -1,
 1226531196,
 13204,
 -46818,
 1226495920,
 13278,
 -1,
 1226691319,
 13062,
 1226899455,
 1207055906,
 -1,
 1226918222,
 1226780942,
 -1,
 1226983729,
 1226839049,
 -1,
 1227049253,
 1226904897,
 -1,
 -46812,
 1226969919,
 127511,
 -1,
 1227035297,
 127509,
 1227245864,
 1226969932,
 -1,
 -46809,
 1227181752,
 127534,
 -1,
 1227239010,
 127506,
 1227442475,
 1227166375,
 -1,
 -46806,
 1227363331,
 127516,
 -1,
 1227428516,
 127520,
 -46804,
 1227378363,
 127517,
 -46803,
 1227568986,
 127532,
 -46802,
 1227630237,
 127505,
 -46801,
 1227691325,
 127524,
 -46800,
 1227756540,
 127525,
 -1,
 1227821725,
 127518,
 1228032318,
 1226904705,
 -1,
 1228097846,
 1227952807,
 -1,
 -46796,
 1228019050,
 127527,
 -46795,
 1228084331,
 127537,
 -1,
 1228149760,
 127504,
 1228359993,
 1228018697,
 -1,
 -46792,
 1228285570,
 127519,
 -1,
 1228346733,
 127515,
 1228556604,
 1228280652,
 -1,
 -46789,
 1228477550,
 127528,
 -1,
 1228542469,
 127535,
 -46787,
 1228492468,
 127526,
 -1,
 1228674238,
 127513,
 1228884293,
 1227953158,
 -1,
 1228949826,
 1228804495,
 -1,
 -46783,
 1228870977,
 127530,
 -1,
 1228935567,
 127529,
 -46781,
 1228871156,
 127512,
 -46780,
 1229067578,
 127508,
 -1,
 1229132610,
 127533,
 1229343049,
 1228805389,
 -1,
 -46777,
 1229272711,
 127536,
 -46776,
 1229335870,
 127523,
 -1,
 1229395312,
 127510,
 1229605197,
 1229264070,
 -1,
 -46773,
 1229534851,
 127521,
 -46772,
 1229591655,
 127522,
 -1,
 1229656719,
 127514,
 -1,
 1229526373,
 127531,
 1229932884,
 1226880799,
 -1,
 -46768,
 1229895455,
 127309,
 -46767,
 1229957151,
 10696,
 -46766,
 1230012738,
 10695,
 -46765,
 1230059040,
 127308,
 -1,
 1230117984,
 9949,
 1230326106,
 1229878730,
 -1,
 -46762,
 1230298376,
 127302,
 -46761,
 1230354207,
 127298,
 -46760,
 1230413801,
 127295,
 -46759,
 1230473439,
 127293,
 -1,
 1230513782,
 127281,
 1230719325,
 1230282729,
 -1,
 -46756,
 1230677818,
 127310,
 -1,
 1230733157,
 8862,
 1230915936,
 1230667749,
 -1,
 -46753,
 1230886830,
 127307,
 -1,
 1230924451,
 8863,
 1231112547,
 1230860424,
 -1,
 -46750,
 1231048249,
 9919,
 -1,
 1231103122,
 127507,
 1231309158,
 1231048278,
 -1,
 -46747,
 1231264761,
 11820,
 -1,
 1231297530,
 10693,
 -46745,
 1231276094,
 8864,
 -46744,
 1231467205,
 10692,
 -46743,
 1231511879,
 127306,
 -46742,
 1231567740,
 8865,
 -1,
 1231627268,
 10694,
 -1,
 1207026409,
 10151,
 1231899211,
 1206969326,
 -1,
 1231964630,
 1231859196,
 -1,
 1232030104,
 1231911386,
 -1,
 1232095608,
 1231992607,
 -1,
 1232161140,
 1232048936,
 -1,
 -46734,
 1232136163,
 1869,
 -46733,
 1232171571,
 1870,
 -1,
 1232228134,
 1871,
 -46731,
 1232131103,
 1809,
 -46730,
 1232362883,
 1835,
 -46729,
 1232422590,
 1827,
 -1,
 1232476176,
 1832,
 1232685437,
 1232052653,
 1830,
 1232797695,
 1232647681,
 -1,
 -46725,
 1232688334,
 1838,
 -46724,
 1232746623,
 1839,
 -1,
 1232808263,
 1837,
 1233013121,
 1232650964,
 -1,
 1233078656,
 1232948194,
 1819,
 -1,
 1232995341,
 1820,
 -1,
 1233004053,
 1836,
 1233275267,
 1232987866,
 1821,
 -1,
 1233192016,
 1822,
 1233406342,
 1233234260,
 -1,
 -46715,
 1233349897,
 1834,
 -1,
 1233407271,
 1831,
 1233602952,
 1233345320,
 1815,
 -1,
 1233569295,
 1818,
 1233734026,
 1233539929,
 1811,
 -1,
 1233650701,
 1812,
 1233865101,
 1233663520,
 -1,
 -46708,
 1233820391,
 1814,
 -1,
 1233853061,
 1813,
 -46706,
 1233839942,
 1817,
 -46705,
 1234034223,
 1816,
 -46704,
 1234085771,
 1833,
 -46703,
 1234145447,
 1826,
 -46702,
 1234208094,
 1825,
 -46701,
 1234269385,
 1824,
 -46700,
 1234333969,
 1823,
 -46699,
 1234391142,
 1828,
 -46698,
 1234452615,
 1829,
 -46697,
 1234512175,
 1810,
 -1,
 1234573929,
 1808,
 1234782627,
 1231968395,
 -1,
 1234848158,
 1234708413,
 -1,
 1234913693,
 1234763776,
 -1,
 -46692,
 1234839635,
 1851,
 -1,
 1234900597,
 1850,
 -1,
 1234833252,
 1852,
 1235175842,
 1234772485,
 -1,
 -46688,
 1235128834,
 1803,
 -46687,
 1235190883,
 1804,
 -1,
 1235231737,
 1805,
 -1,
 1235130651,
 1797,
 1235503532,
 1234747768,
 -1,
 1235569064,
 1235461601,
 -1,
 1235634599,
 1235497451,
 1795,
 -1,
 1235552818,
 1800,
 -1,
 1235571394,
 1793,
 1235877887,
 1235495559,
 -1,
 1235896747,
 1235759595,
 1796,
 -1,
 1235814975,
 1801,
 -1,
 1235833538,
 1794,
 1236093363,
 1235469012,
 -1,
 1236158896,
 1236066931,
 -1,
 -46673,
 1236084819,
 1860,
 -1,
 1236145781,
 1859,
 1236402175,
 1236099202,
 -1,
 -46670,
 1236281427,
 1862,
 -1,
 1236342389,
 1861,
 1236552121,
 1236052308,
 -1,
 1236617655,
 1236477890,
 -1,
 -46666,
 1236543571,
 1847,
 -1,
 1236604533,
 1846,
 -46664,
 1236589890,
 1855,
 -1,
 1236783261,
 1858,
 1236945341,
 1236527180,
 -1,
 -46661,
 1236876256,
 1845,
 -46660,
 1236936787,
 1844,
 -1,
 1236997749,
 1843,
 1237207489,
 1236903640,
 -1,
 -46657,
 1237138400,
 1842,
 -46656,
 1237198931,
 1841,
 -1,
 1237259893,
 1840,
 1237469638,
 1237139591,
 -1,
 1237535173,
 1237432363,
 -1,
 -46652,
 1237461075,
 1854,
 -1,
 1237522037,
 1853,
 -1,
 1237486191,
 1792,
 1237797323,
 1237397992,
 -1,
 1237862858,
 1237744918,
 -1,
 -46647,
 1237823073,
 1799,
 -1,
 1237874309,
 1798,
 -1,
 1237815291,
 1802,
 1238125006,
 1237750296,
 -1,
 -46643,
 1238050899,
 1864,
 -1,
 1238111861,
 1863,
 1238321617,
 1238056001,
 -1,
 -46640,
 1238261453,
 1848,
 -1,
 1238310608,
 1849,
 -46638,
 1238280522,
 1857,
 -46637,
 1238468736,
 1865,
 -46636,
 1238519703,
 1856,
 -46635,
 1238575029,
 1866,
 -1,
 1238636079,
 1807,
 1238845970,
 1231912436,
 -1,
 1238911491,
 1238792666,
 -1,
 1238976990,
 1238876884,
 -1,
 1239042524,
 1238942420,
 -1,
 -46629,
 1238995343,
 43024,
 -1,
 1239047775,
 43025,
 -46627,
 1238995343,
 43028,
 -1,
 1239178847,
 43029,
 1239370212,
 1238906400,
 -1,
 1239435746,
 1239299616,
 -1,
 -46623,
 1239388559,
 43026,
 -1,
 1239440991,
 43027,
 -46621,
 1239388559,
 43030,
 -1,
 1239572063,
 43031,
 1239763431,
 1239329108,
 -1,
 -46618,
 1239725012,
 43040,
 -1,
 1239781775,
 43038,
 1239960042,
 1239719913,
 -1,
 -46615,
 1239912847,
 43033,
 -1,
 1239965279,
 43034,
 1240156653,
 1239904392,
 -1,
 -46612,
 1240109455,
 43015,
 -1,
 1240161887,
 43016,
 1240353264,
 1240100649,
 -1,
 -46609,
 1240306063,
 43022,
 -1,
 1240358495,
 43023,
 1240549875,
 1240290019,
 -1,
 -46606,
 1240502671,
 43017,
 -1,
 1240555103,
 43018,
 1240746486,
 1240476894,
 -1,
 -46603,
 1240699279,
 43020,
 -1,
 1240751711,
 43021,
 1240943097,
 1240671862,
 -1,
 -46600,
 1240895887,
 43035,
 -1,
 1240948319,
 43036,
 -46598,
 1240911434,
 43011,
 -46597,
 1241103989,
 43041,
 -46596,
 1241158031,
 43013,
 -46595,
 1241222542,
 43032,
 -46594,
 1241286196,
 43037,
 -46593,
 1241349316,
 43039,
 -46592,
 1241407871,
 43009,
 -46591,
 1241472607,
 43042,
 -46590,
 1241530503,
 43012,
 -1,
 1241585012,
 43008,
 1241795081,
 1238883510,
 -1,
 -46587,
 1241763402,
 43045,
 -46586,
 1241814660,
 43047,
 -46585,
 1241866623,
 43044,
 -46584,
 1241923719,
 43046,
 -1,
 1241978228,
 43043,
 1242188302,
 1241752742,
 -1,
 -46581,
 1242108860,
 43051,
 -46580,
 1242174284,
 43050,
 -46579,
 1242239655,
 43049,
 -1,
 1242305039,
 43048,
 1242562559,
 1242151984,
 -1,
 -46576,
 1242454770,
 43014,
 -46575,
 1242513515,
 43010,
 -1,
 1242570647,
 43019,
 1242824703,
 1238794213,
 -1,
 1242843722,
 1242704564,
 -1,
 1242909216,
 1242806047,
 -1,
 1242974743,
 1242877890,
 9242,
 -1,
 1242891205,
 9254,
 1243105818,
 1242940456,
 -1,
 -46567,
 1243072010,
 9218,
 -1,
 1243110209,
 9217,
 1243302429,
 1243045097,
 -1,
 -46564,
 1243258028,
 9230,
 -1,
 1243309872,
 9231,
 -46562,
 1243276822,
 9238,
 -46561,
 1243455609,
 9248,
 -1,
 1243487371,
 8527,
 1243695659,
 1242838560,
 -1,
 1243761194,
 1243627655,
 -1,
 1243826728,
 1243732853,
 -1,
 1243892262,
 1243792084,
 -1,
 -46555,
 1243865487,
 9234,
 -1,
 1243897942,
 9235,
 -46553,
 1243846079,
 9233,
 -1,
 1244025296,
 9236,
 1244266495,
 1243773392,
 9249,
 -1,
 1244136389,
 9253,
 -1,
 1243686003,
 9232,
 1244416565,
 1243627655,
 -1,
 1244482100,
 1244367071,
 -1,
 1244547635,
 1244411456,
 -1,
 1244613170,
 1244512980,
 -1,
 1244678705,
 1244572366,
 9220,
 -1,
 1244594773,
 9239,
 -1,
 1244614050,
 9219,
 -1,
 1244562296,
 9241,
 -1,
 1244506386,
 9221,
 -1,
 1244444780,
 9243,
 1245071930,
 1244367071,
 -1,
 1245137465,
 1245003911,
 -1,
 -46536,
 1245110600,
 9252,
 -1,
 1245139905,
 9237,
 -1,
 1245106422,
 9216,
 1245399613,
 1245007446,
 -1,
 -46532,
 1245354310,
 9228,
 -1,
 1245406728,
 9244,
 1245596224,
 1245326651,
 -1,
 -46529,
 1245558154,
 9229,
 -1,
 1245612592,
 9240,
 1245792835,
 1245521526,
 -1,
 -46526,
 1245726192,
 9223,
 -1,
 1245779846,
 9224,
 -46524,
 1245764391,
 9227,
 -46523,
 1245958834,
 9247,
 -46522,
 1246014416,
 9246,
 -46521,
 1246067474,
 9226,
 -46520,
 1246125960,
 9225,
 -46519,
 1246189544,
 9245,
 -1,
 1246238586,
 9222,
 -1,
 1242793076,
 9007,
 1246513930,
 1231820148,
 -1,
 1246579384,
 1246483899,
 -1,
 1246644879,
 1246525914,
 -1,
 1246710357,
 1246615470,
 -1,
 1246775892,
 1246663253,
 -1,
 1246841426,
 1246734676,
 43144,
 -1,
 1246800212,
 43145,
 1247019007,
 1246786392,
 43146,
 -1,
 1246917464,
 43147,
 -1,
 1246696820,
 43182,
 1247169115,
 1246675668,
 -1,
 1247234649,
 1247134420,
 -1,
 -46504,
 1247172777,
 43165,
 -1,
 1247221108,
 43164,
 -46502,
 1247172777,
 43170,
 -1,
 1247352180,
 43169,
 1247562336,
 1247119583,
 -1,
 -46499,
 1247536170,
 43163,
 -46498,
 1247578427,
 43168,
 -46497,
 1247630084,
 43158,
 -1,
 1247679860,
 43173,
 1247890022,
 1247491616,
 -1,
 1247955556,
 1247819296,
 -1,
 -46493,
 1247893673,
 43167,
 -1,
 1247942004,
 43166,
 -46491,
 1247893673,
 43172,
 -1,
 1248073076,
 43171,
 1248283242,
 1247810932,
 43138,
 -46488,
 1248251466,
 43153,
 -46487,
 1248289151,
 43150,
 -1,
 1248335220,
 43139,
 1248545390,
 1248245535,
 -1,
 -46484,
 1248507801,
 43184,
 -46483,
 1248549033,
 43183,
 -1,
 1248597364,
 43185,
 1248807536,
 1248513610,
 43142,
 -1,
 1248775754,
 43143,
 1248938611,
 1248763881,
 -1,
 -46478,
 1248876713,
 43175,
 -1,
 1248925044,
 43174,
 1249135221,
 1248891279,
 43151,
 -1,
 1249087887,
 43152,
 1249266296,
 1249080152,
 -1,
 -46473,
 1249211309,
 43187,
 -1,
 1249252724,
 43181,
 1249462907,
 1249210504,
 -1,
 -46470,
 1249401001,
 43155,
 -1,
 1249449332,
 43154,
 1249659518,
 1249406761,
 -1,
 -46467,
 1249597609,
 43162,
 -1,
 1249645940,
 43161,
 1249856128,
 1249599871,
 43140,
 -1,
 1249796479,
 43141,
 1249987203,
 1249792739,
 -1,
 -46462,
 1249925289,
 43157,
 -1,
 1249973620,
 43156,
 1250183813,
 1249919111,
 43148,
 -1,
 1250115719,
 43149,
 1250314888,
 1250110686,
 -1,
 -46457,
 1250252969,
 43160,
 -1,
 1250301300,
 43159,
 1250511499,
 1250240118,
 -1,
 -46454,
 1250449577,
 43177,
 -1,
 1250497908,
 43176,
 -46452,
 1250485290,
 43179,
 -46451,
 1250666927,
 43180,
 -46450,
 1250721842,
 43178,
 -1,
 1250777257,
 43186,
 1250970273,
 1246616758,
 -1,
 1251035797,
 1250941967,
 -1,
 1251101331,
 1250994516,
 43194,
 -1,
 1251060052,
 43195,
 1251278847,
 1251046232,
 43196,
 -1,
 1251177304,
 43197,
 1251363481,
 1250956660,
 -1,
 -46441,
 1251331658,
 43203,
 -46440,
 1251369343,
 43200,
 -1,
 1251415412,
 43189,
 1251625627,
 1251331658,
 43192,
 -1,
 1251593802,
 43193,
 1251756701,
 1251578255,
 43201,
 -1,
 1251709327,
 43202,
 1251887775,
 1251697023,
 43190,
 -1,
 1251828095,
 43191,
 1252065279,
 1251819655,
 43198,
 -1,
 1251950727,
 43199,
 1252149938,
 1250899488,
 -1,
 1252215472,
 1252091258,
 -1,
 1252280998,
 1252180692,
 -1,
 -46427,
 1252254095,
 43218,
 -1,
 1252286550,
 43219,
 1252477609,
 1252243231,
 -1,
 -46424,
 1252421358,
 43222,
 -1,
 1252478082,
 43223,
 1252674220,
 1252413014,
 -1,
 -46421,
 1252629488,
 43220,
 -1,
 1252683383,
 43221,
 -46419,
 1252648853,
 43216,
 -46418,
 1252824511,
 43217,
 -46417,
 1252887740,
 43225,
 -1,
 1252934967,
 43224,
 -46415,
 1252170595,
 43215,
 -1,
 1253056064,
 43214,
 1253264055,
 1252113456,
 -1,
 1253329590,
 1253235557,
 -1,
 -46411,
 1253292069,
 43137,
 -1,
 1253354125,
 43204,
 -1,
 1253253015,
 43136,
 -1,
 1253192354,
 43188,
 1253657350,
 1246528081,
 -1,
 1253722836,
 1253603802,
 -1,
 1253788350,
 1253688020,
 -1,
 -46404,
 1253750689,
 2065,
 -46403,
 1253797247,
 2056,
 -1,
 1253840384,
 2069,
 1254050498,
 1253728639,
 -1,
 -46400,
 1254024174,
 2052,
 -46399,
 1254081236,
 2055,
 -1,
 1254131935,
 2063,
 1254312645,
 1254012703,
 -1,
 -46396,
 1254254832,
 2062,
 -1,
 1254316569,
 2068,
 1254509256,
 1254237814,
 -1,
 -46393,
 1254452607,
 2049,
 -1,
 1254495735,
 2053,
 -46391,
 1254483837,
 2054,
 -46390,
 1254680298,
 2057,
 -46389,
 1254732456,
 2067,
 -46388,
 1254795488,
 2066,
 -46387,
 1254854823,
 2061,
 -46386,
 1254917470,
 2060,
 -46385,
 1254978541,
 2059,
 -46384,
 1255043251,
 2058,
 -46383,
 1255101279,
 2050,
 -46382,
 1255165961,
 2064,
 -46381,
 1255225041,
 2051,
 -1,
 1255283290,
 2048,
 1255492326,
 1253694646,
 -1,
 1255557851,
 1255439650,
 -1,
 1255623384,
 1255478644,
 2082,
 -1,
 1255544180,
 2079,
 -46375,
 1255591498,
 2086,
 -46374,
 1255694719,
 2089,
 -1,
 1255751815,
 2076,
 1255951070,
 1255510415,
 2091,
 1256062975,
 1255922141,
 2081,
 -1,
 1255937396,
 2078,
 1256147681,
 1255913247,
 -1,
 -46368,
 1256116393,
 2092,
 -1,
 1256153026,
 2085,
 1256344291,
 1256068468,
 2083,
 -1,
 1256265076,
 2080,
 -46364,
 1256312394,
 2087,
 -46363,
 1256415615,
 2090,
 -1,
 1256472711,
 2077,
 1256671993,
 1255450363,
 -1,
 1256737518,
 1256592756,
 -1,
 1256803051,
 1256687839,
 -1,
 -46358,
 1256753487,
 2110,
 -1,
 1256805441,
 2098,
 -46356,
 1256769830,
 2100,
 -46355,
 1256960856,
 2108,
 -1,
 1257001560,
 2097,
 1257196273,
 1256711966,
 -1,
 -46352,
 1257139179,
 2104,
 -1,
 1257183303,
 2106,
 1257392884,
 1257158431,
 -1,
 -46349,
 1257345795,
 2109,
 -1,
 1257397798,
 2101,
 -46347,
 1257360686,
 2107,
 -46346,
 1257547686,
 2105,
 -46345,
 1257606018,
 2096,
 -46344,
 1257669593,
 2103,
 -1,
 1257711590,
 2099,
 1257917189,
 1256620005,
 -1,
 1257982721,
 1257841121,
 -1,
 1258048253,
 1257924400,
 2070,
 -1,
 1257967344,
 2071,
 -46338,
 1258000989,
 2072,
 -46337,
 1258130306,
 2093,
 -46336,
 1258178716,
 2075,
 -1,
 1258239659,
 2073,
 1258487807,
 1257935552,
 -1,
 -46333,
 1258404708,
 2084,
 -46332,
 1258447231,
 2088,
 -1,
 1258506396,
 2074,
 -1,
 1257838127,
 2102,
 -46329,
 1253625051,
 9796,
 -46328,
 1258716949,
 9747,
 -46327,
 1258776044,
 9973,
 -1,
 1258837440,
 9808,
 1259031491,
 1246481994,
 -1,
 1259096916,
 1258981599,
 9737,
 1259162451,
 1259026160,
 -1,
 1259227953,
 1259108826,
 -1,
 1259293458,
 1259178207,
 -1,
 -46320,
 1259267114,
 7057,
 -46319,
 1259295492,
 7053,
 -1,
 1259345268,
 7060,
 1259555605,
 1259255583,
 -1,
 -46316,
 1259529258,
 7087,
 -1,
 1259541876,
 7070,
 1259752216,
 1259499656,
 -1,
 -46313,
 1259690153,
 7086,
 -1,
 1259738484,
 7050,
 1259948826,
 1259683975,
 7048,
 -1,
 1259916874,
 7049,
 1260079900,
 1259869556,
 7043,
 -1,
 1260011655,
 7046,
 -46307,
 1260054320,
 7056,
 -46306,
 1260184618,
 7066,
 -46305,
 1260249892,
 7071,
 -46304,
 1260313904,
 7069,
 -46303,
 1260378044,
 7063,
 -46302,
 1260441162,
 7045,
 -46301,
 1260503829,
 7058,
 -46300,
 1260562863,
 7067,
 -46299,
 1260627786,
 7051,
 -46298,
 1260691534,
 7061,
 -46297,
 1260753295,
 7047,
 -46296,
 1260814386,
 7065,
 -46295,
 1260876717,
 7068,
 -46294,
 1260941099,
 7055,
 -46293,
 1261003135,
 7044,
 -46292,
 1261066409,
 7072,
 -46291,
 1261130500,
 7052,
 -46290,
 1261194943,
 7062,
 -46289,
 1261254283,
 7059,
 -46288,
 1261317435,
 7054,
 -1,
 1261381288,
 7064,
 1261587263,
 1259157912,
 -1,
 1261652789,
 1261552340,
 -1,
 -46284,
 1261625743,
 7090,
 -1,
 1261658198,
 7091,
 1261849400,
 1261614879,
 -1,
 -46281,
 1261793006,
 7094,
 -1,
 1261849730,
 7095,
 1262046011,
 1261784662,
 -1,
 -46278,
 1262001136,
 7092,
 -1,
 1262055031,
 7093,
 -46276,
 1262020501,
 7088,
 -46275,
 1262196159,
 7089,
 -46274,
 1262259388,
 7097,
 -1,
 1262306615,
 7096,
 1262504775,
 1261558978,
 -1,
 1262570310,
 1262455007,
 -1,
 -46270,
 1262544607,
 7077,
 -46269,
 1262589105,
 7079,
 -46268,
 1262638431,
 7076,
 -46267,
 1262701640,
 7081,
 -1,
 1262753878,
 7078,
 -1,
 1262519336,
 7080,
 1263029070,
 1262468173,
 -1,
 1263094605,
 1262979295,
 -1,
 1263160140,
 1263031011,
 -1,
 -46261,
 1263132524,
 7042,
 -1,
 1263171099,
 7041,
 -1,
 1263133896,
 7040,
 -1,
 1263042613,
 7082,
 1263534079,
 1262957239,
 -1,
 1263553362,
 1263440186,
 -1,
 -46255,
 1263494611,
 7075,
 -1,
 1263540719,
 7074,
 -1,
 1263502731,
 7073,
 -1,
 1259078165,
 9925,
 1263881093,
 1259053785,
 -1,
 1263946605,
 1263815488,
 -1,
 1264012128,
 1263899392,
 8835,
 1264123903,
 1263927296,
 -1,
 1264143197,
 1263998587,
 -1,
 -46246,
 1264109593,
 10952,
 -46245,
 1264160357,
 10956,
 -46244,
 1264208211,
 10950,
 -1,
 1264262177,
 10954,
 1264470879,
 1264097293,
 8839,
 -1,
 1264389388,
 10948,
 -1,
 1264443514,
 8843,
 1264667492,
 1263984498,
 -1,
 -46238,
 1264624787,
 10944,
 -46237,
 1264683017,
 10946,
 -1,
 1264728872,
 10942,
 1264929641,
 1264588411,
 -1,
 1264995176,
 1264894328,
 -1,
 -46233,
 1264952038,
 10966,
 -1,
 1264987150,
 10964,
 -1,
 1264941129,
 10619,
 1265257324,
 1264855220,
 -1,
 -46229,
 1265222015,
 10967,
 -1,
 1265245591,
 10968,
 -1,
 1265214988,
 10185,
 1265565695,
 1263875053,
 -1,
 1265585011,
 1265464152,
 -1,
 1265650546,
 1265509665,
 -1,
 -46223,
 1265600735,
 8319,
 -1,
 1265656191,
 8305,
 -1,
 1265583086,
 8317,
 1265912694,
 1265550036,
 -1,
 -46219,
 1265885583,
 178,
 -1,
 1265918038,
 179,
 1266109305,
 1265874719,
 -1,
 -46216,
 1266052846,
 8310,
 -1,
 1266109570,
 8311,
 1266305916,
 1266044502,
 -1,
 -46213,
 1266260976,
 8308,
 -1,
 1266314871,
 8309,
 1266502527,
 1266237575,
 -1,
 -46210,
 1266460675,
 8316,
 -1,
 1266509027,
 8312,
 -46208,
 1266476949,
 8304,
 -46207,
 1266659208,
 8318,
 -46206,
 1266721929,
 8314,
 -46205,
 1266783679,
 185,
 -46204,
 1266846908,
 8313,
 -1,
 1266910635,
 8315,
 1267092398,
 1263807486,
 -1,
 1267157914,
 1267020781,
 -1,
 1267223434,
 1267122900,
 -1,
 -46199,
 1267196303,
 8322,
 -1,
 1267228758,
 8323,
 1267420045,
 1267185439,
 -1,
 -46196,
 1267363566,
 8326,
 -1,
 1267420290,
 8327,
 1267616656,
 1267355222,
 -1,
 -46193,
 1267571696,
 8324,
 -1,
 1267625591,
 8325,
 1267813267,
 1267548295,
 -1,
 -46190,
 1267771395,
 8332,
 -1,
 1267819747,
 8328,
 -46188,
 1267787669,
 8320,
 -46187,
 1267969928,
 8334,
 -46186,
 1268032649,
 8330,
 -46185,
 1268094399,
 8321,
 -46184,
 1268157628,
 8329,
 -46183,
 1268221355,
 8331,
 -1,
 1268283228,
 8333,
 1268514815,
 1267092288,
 -1,
 1268534181,
 1268421376,
 8834,
 1268645887,
 1268449280,
 -1,
 1268665250,
 1268520571,
 -1,
 -46177,
 1268631577,
 10951,
 -46176,
 1268682341,
 10955,
 -46175,
 1268730195,
 10949,
 -1,
 1268784161,
 10953,
 1268992932,
 1268619277,
 8838,
 -1,
 1268911372,
 10947,
 -1,
 1268965498,
 8842,
 1269189545,
 1268506482,
 -1,
 -46169,
 1269146771,
 10943,
 -46168,
 1269205001,
 10945,
 -1,
 1269250856,
 10941,
 1269497855,
 1269110395,
 -1,
 1269517229,
 1269416312,
 -1,
 -46164,
 1269474022,
 10963,
 -1,
 1269509134,
 10965,
 -1,
 1269477535,
 10617,
 1269779390,
 1267019365,
 8827,
 1269891071,
 1269694464,
 -1,
 1269910457,
 1269765755,
 -1,
 1269975988,
 1269873881,
 -1,
 -46157,
 1269927525,
 10930,
 -1,
 1269975379,
 10928,
 1270172599,
 1269927494,
 -1,
 -46154,
 1270106375,
 10934,
 -1,
 1270160417,
 10938,
 -46152,
 1270106451,
 10932,
 -1,
 1270291489,
 10936,
 1270500284,
 1269864445,
 -1,
 -46149,
 1270443622,
 8831,
 -1,
 1270487589,
 8829,
 -46147,
 1270469192,
 8881,
 -1,
 1270623369,
 8937,
 1270827970,
 1269728768,
 -1,
 -46144,
 1270800458,
 10763,
 -46143,
 1270860287,
 9138,
 -1,
 1270885073,
 9139,
 -1,
 1270787515,
 8751,
 1271155788,
 1258971519,
 -1,
 1271221310,
 1271105759,
 -1,
 1271286839,
 1271159165,
 -1,
 1271352344,
 1271232986,
 -1,
 1271417821,
 1271272820,
 -1,
 1271483349,
 1271365333,
 -1,
 1271548876,
 1271448276,
 -1,
 -46133,
 1271514215,
 3495,
 -1,
 1271539279,
 3501,
 1271745487,
 1271477792,
 -1,
 -46130,
 1271674676,
 3497,
 -1,
 1271735887,
 3503,
 -46128,
 1271701911,
 3508,
 -46127,
 1271886237,
 3482,
 -46126,
 1271951173,
 3490,
 -46125,
 1272009715,
 3484,
 -46124,
 1272065621,
 3488,
 -1,
 1272129514,
 3510,
 1272335320,
 1271414919,
 -1,
 -46121,
 1272308862,
 3463,
 -1,
 1272335932,
 3464,
 -46119,
 1272308862,
 3461,
 -46118,
 1272502161,
 3478,
 -46117,
 1272545982,
 3513,
 -46116,
 1272606492,
 3475,
 -1,
 1272653391,
 3462,
 1272859633,
 1271365605,
 -1,
 1272925165,
 1272780148,
 -1,
 1272990700,
 1272862902,
 -1,
 1273056227,
 1272955604,
 -1,
 -46110,
 1273021543,
 3496,
 -1,
 1273046607,
 3502,
 1273252838,
 1272985120,
 -1,
 -46107,
 1273182004,
 3498,
 -1,
 1273243215,
 3504,
 -46105,
 1273209239,
 3509,
 -46104,
 1273393565,
 3483,
 -46103,
 1273458501,
 3491,
 -46102,
 1273517043,
 3485,
 -46101,
 1273572949,
 3489,
 -1,
 1273636842,
 3511,
 -1,
 1272964222,
 3512,
 1273954303,
 1272895364,
 -1,
 -46097,
 1273870401,
 3522,
 -46096,
 1273924127,
 3499,
 -1,
 1273984531,
 3525,
 1274170362,
 1272799615,
 -1,
 1274235893,
 1274132074,
 -1,
 -46092,
 1274209406,
 3469,
 -1,
 1274271633,
 3470,
 1274432504,
 1274183451,
 -1,
 -46089,
 1274406014,
 3471,
 -1,
 1274468241,
 3472,
 -46087,
 1274406014,
 3465,
 -1,
 1274572572,
 3466,
 1274760192,
 1274132508,
 -1,
 1274825726,
 1274689056,
 -1,
 -46083,
 1274754868,
 3500,
 -1,
 1274816079,
 3507,
 -46081,
 1274769221,
 3494,
 -1,
 1274958835,
 3487,
 1275153413,
 1274725160,
 -1,
 1275218948,
 1275115417,
 -1,
 -46077,
 1275192446,
 3521,
 -1,
 1275236732,
 3493,
 -1,
 1275169092,
 3492,
 1275481097,
 1275082488,
 -1,
 -46073,
 1275443265,
 3523,
 -46072,
 1275496991,
 3505,
 -1,
 1275557395,
 3517,
 1275743244,
 1275448906,
 -1,
 -46069,
 1275716734,
 3467,
 -1,
 1275778961,
 3468,
 1275939855,
 1275695503,
 -1,
 -46066,
 1275913342,
 3476,
 -1,
 1275961310,
 3477,
 1276136466,
 1275871367,
 -1,
 -46063,
 1276109950,
 3473,
 -1,
 1276137020,
 3474,
 -46061,
 1276109987,
 3514,
 -46060,
 1276303596,
 3520,
 -46059,
 1276357401,
 3515,
 -46058,
 1276408057,
 3486,
 -46057,
 1276467995,
 3524,
 -1,
 1276530462,
 3526,
 1276726321,
 1271323830,
 -1,
 1276791845,
 1276670088,
 -1,
 1276857377,
 1276744934,
 -1,
 1276922912,
 1276827580,
 3545,
 1277034495,
 1276838955,
 -1,
 -46050,
 1276924923,
 3550,
 -46049,
 1276983680,
 3549,
 -1,
 1277040715,
 3548,
 -1,
 1276838678,
 3547,
 1277362175,
 1276791866,
 -1,
 -46045,
 1277272169,
 3540,
 -46044,
 1277324527,
 3538,
 -1,
 1277368380,
 3536,
 1277578285,
 1276721530,
 -1,
 1277643817,
 1277514500,
 -1,
 -46040,
 1277617284,
 3571,
 -1,
 1277643816,
 3570,
 -46038,
 1277599849,
 3542,
 -46037,
 1277784732,
 3546,
 -46036,
 1277848815,
 3539,
 -1,
 1277892668,
 3537,
 1278102576,
 1277514500,
 -1,
 -46033,
 1278076036,
 3551,
 -1,
 1278102568,
 3544,
 -1,
 1278023755,
 3535,
 1278364726,
 1276689456,
 -1,
 1278430261,
 1278285172,
 -1,
 -46028,
 1278382306,
 3458,
 -1,
 1278440332,
 3530,
 -1,
 1278401522,
 3459,
 -1,
 1278322440,
 3572,
 1278757949,
 1271223769,
 -1,
 1278823483,
 1278702424,
 -1,
 -46022,
 1278779164,
 8218,
 -1,
 1278821410,
 8249,
 -46020,
 1278783600,
 8250,
 -1,
 1278958928,
 8219,
 -1,
 1278689533,
 8767,
 1279216710,
 1271170366,
 -1,
 1279282242,
 1279170553,
 -1,
 -46015,
 1279228239,
 10909,
 -1,
 1279284983,
 10910,
 1279478853,
 1279202939,
 -1,
 -46012,
 1279424891,
 10911,
 -1,
 1279481641,
 10912,
 -1,
 1279428028,
 10860,
 1279787007,
 1279189764,
 -1,
 1279806538,
 1279658078,
 -1,
 -46007,
 1279759301,
 10038,
 -1,
 1279806325,
 10046,
 -46005,
 1279771871,
 10042,
 -1,
 1279922331,
 8198,
 1280134302,
 1271093387,
 -1,
 1280199825,
 1280054644,
 -1,
 1280265356,
 1280170856,
 -1,
 1280330841,
 1280185716,
 -1,
 1280396371,
 1280289108,
 -1,
 -45998,
 1280355093,
 66684,
 -1,
 1280393351,
 66680,
 -45996,
 1280368210,
 66679,
 -45995,
 1280555539,
 66664,
 -45994,
 1280601072,
 66682,
 -45993,
 1280661643,
 66669,
 -45992,
 1280726050,
 66673,
 -1,
 1280785092,
 66665,
 1280986208,
 1280283023,
 -1,
 -45989,
 1280956169,
 66668,
 -45988,
 1281010004,
 66681,
 -45987,
 1281073125,
 66677,
 -45986,
 1281132767,
 66666,
 -45985,
 1281189341,
 66678,
 -1,
 1281235392,
 66676,
 1281444966,
 1280917639,
 -1,
 1281510500,
 1281365364,
 -1,
 -45981,
 1281475284,
 66672,
 -1,
 1281534292,
 66685,
 -45979,
 1281471845,
 66683,
 -1,
 1281643670,
 66663,
 1281838187,
 1281409748,
 -1,
 1281903722,
 1281775755,
 -1,
 -45975,
 1281844432,
 66644,
 -1,
 1281904185,
 66654,
 -1,
 1281858122,
 66641,
 1282165871,
 1281778047,
 -1,
 -45971,
 1282100822,
 66662,
 -45970,
 1282158216,
 66674,
 -1,
 1282219326,
 66686,
 1282428018,
 1282139323,
 -1,
 -45967,
 1282399496,
 66687,
 -1,
 1282413940,
 66648,
 1282624629,
 1282400655,
 -1,
 -45964,
 1282577426,
 66667,
 -1,
 1282621575,
 66658,
 1282821240,
 1282586399,
 -1,
 -45961,
 1282790877,
 66646,
 -1,
 1282838927,
 66645,
 1283017851,
 1282768869,
 -1,
 -45958,
 1282958998,
 66661,
 -1,
 1283015035,
 66656,
 1283214462,
 1282955403,
 -1,
 -45955,
 1283183217,
 66649,
 -1,
 1283200483,
 66659,
 -45953,
 1283188808,
 66655,
 -45952,
 1283382405,
 66653,
 -45951,
 1283445508,
 66675,
 -45950,
 1283503079,
 66670,
 -45949,
 1283564011,
 66640,
 -45948,
 1283625127,
 66671,
 -45947,
 1283685645,
 66660,
 -45946,
 1283748433,
 66642,
 -45945,
 1283813484,
 66657,
 -45944,
 1283871552,
 66652,
 -45943,
 1283936106,
 66643,
 -45942,
 1283995486,
 66651,
 -45941,
 1284059160,
 66647,
 -1,
 1284122960,
 66650,
 1284328592,
 1280196130,
 -1,
 -45938,
 1284292686,
 10032,
 -45937,
 1284339191,
 10014,
 -1,
 1284386882,
 10061,
 -1,
 1284278182,
 9752,
 1284656284,
 1280151951,
 -1,
 1284721819,
 1284617756,
 -1,
 1284787351,
 1284690924,
 10976,
 1284898815,
 1284702208,
 -1,
 -45930,
 1284825359,
 10984,
 -1,
 1284839174,
 10985,
 1285049497,
 1284718355,
 10975,
 -1,
 1284967908,
 10983,
 -45926,
 1285009584,
 10564,
 -1,
 1285126049,
 10974,
 -1,
 1284690126,
 9085,
 -45923,
 1284624405,
 10722,
 -1,
 1285319291,
 9961,
 1285508334,
 1280081893,
 -1,
 1285573869,
 1285428596,
 -1,
 1285639404,
 1285520386,
 -1,
 1285704938,
 1285554176,
 -1,
 1285770432,
 1285663060,
 -1,
 1285835963,
 1285723342,
 -1,
 1285901482,
 1285800660,
 -1,
 1285967016,
 1285872904,
 -1,
 -45913,
 1285919119,
 8561,
 -1,
 1285965357,
 8571,
 -45911,
 1285906518,
 8562,
 -1,
 1286096625,
 8569,
 1286294704,
 1285836374,
 -1,
 1286360239,
 1286234495,
 -1,
 1286425774,
 1286330612,
 8564,
 -1,
 1286341734,
 8574,
 -1,
 1286361790,
 8572,
 -1,
 1286314992,
 8563,
 1286687924,
 1286247871,
 8560,
 1286799359,
 1286602752,
 -1,
 -45901,
 1286719261,
 8575,
 -1,
 1286758679,
 8573,
 1286950071,
 1286649631,
 -1,
 -45898,
 1286893294,
 8565,
 -1,
 1286950018,
 8566,
 1287146682,
 1286881415,
 -1,
 -45895,
 1287092768,
 8570,
 -1,
 1287152867,
 8567,
 -1,
 1287097532,
 8568,
 1287408831,
 1285776616,
 -1,
 -45891,
 1287375469,
 65118,
 -45890,
 1287430438,
 65114,
 -1,
 1287468437,
 65116,
 -1,
 1287343331,
 65128,
 1287736520,
 1285701767,
 -1,
 1287802053,
 1287682279,
 8714,
 1287913471,
 1287719971,
 -1,
 -45884,
 1287838327,
 8948,
 -1,
 1287888554,
 8951,
 -45882,
 1287775046,
 65111,
 -45881,
 1288022019,
 65126,
 -1,
 1288077313,
 65112,
 1288260818,
 1287664104,
 -1,
 1288326350,
 1288212333,
 -1,
 1288391885,
 1288298354,
 -1,
 -45876,
 1288362615,
 8956,
 -1,
 1288412842,
 8958,
 -1,
 1288315684,
 8717,
 1288654033,
 1288275444,
 -1,
 -45872,
 1288587690,
 65131,
 -1,
 1288639860,
 65104,
 -1,
 1288600850,
 65109,
 1288916184,
 1288205906,
 -1,
 1288981719,
 1288852065,
 -1,
 -45867,
 1288948333,
 65117,
 -45866,
 1289003302,
 65113,
 -1,
 1289041301,
 65115,
 -1,
 1288945587,
 65124,
 1289309403,
 1288880852,
 -1,
 -45862,
 1289282016,
 68411,
 -1,
 1289315839,
 732,
 1289506014,
 1289265129,
 -1,
 -45859,
 1289453430,
 65122,
 -1,
 1289505174,
 65130,
 1289702625,
 1289426292,
 -1,
 -45856,
 1289666675,
 65121,
 -1,
 1289717617,
 65120,
 -45854,
 1289673056,
 10849,
 -45853,
 1289861470,
 65108,
 -45852,
 1289922750,
 65110,
 -45851,
 1289982023,
 65119,
 -45850,
 1290036175,
 65105,
 -45849,
 1290101103,
 65123,
 -45848,
 1290164106,
 65125,
 -45847,
 1290228418,
 65106,
 -1,
 1290287861,
 65129,
 1290534911,
 1285638524,
 10922,
 -1,
 1290405577,
 10924,
 -1,
 1285601838,
 10803,
 -1,
 1285514756,
 8995,
 1290751242,
 1285460367,
 -1,
 1290816772,
 1290718794,
 -1,
 1290882307,
 1290782226,
 -1,
 1290947835,
 1290813813,
 -1,
 1291013368,
 1290871394,
 8600,
 1291124735,
 1290928128,
 -1,
 -45835,
 1291051049,
 10533,
 -45834,
 1291110720,
 8690,
 -45833,
 1291138252,
 10541,
 -1,
 1291197995,
 10537,
 -45831,
 1290985142,
 11010,
 -45830,
 1291336870,
 8664,
 -1,
 1291397635,
 11018,
 1291649023,
 1290919541,
 -1,
 1291668736,
 1291526754,
 8601,
 1291780095,
 1291583488,
 -1,
 -45825,
 1291706409,
 10534,
 -1,
 1291722212,
 10538,
 -45823,
 1291640502,
 11011,
 -45822,
 1291861158,
 8665,
 -1,
 1291921923,
 11019,
 -1,
 1290832511,
 8471,
 1292193030,
 1290762876,
 47,
 -1,
 1292111332,
 10742,
 1292324105,
 1292128862,
 -1,
 -45816,
 1292295609,
 9108,
 -1,
 1292305543,
 173,
 -1,
 1292250738,
 9917,
 1292586271,
 1290677470,
 -1,
 1292651805,
 1292544340,
 -1,
 1292717340,
 1292594150,
 -1,
 1292782871,
 1292643805,
 -1,
 -45809,
 1292740948,
 8475,
 -45808,
 1292804073,
 8472,
 -45807,
 1292861413,
 8499,
 -45806,
 1292923736,
 8466,
 -45805,
 1292984703,
 8464,
 -45804,
 1293047947,
 8459,
 -45803,
 1293110870,
 8497,
 -45802,
 1293172871,
 8496,
 -1,
 1293231734,
 8492,
 1293484031,
 1292746124,
 -1,
 -45799,
 1293390223,
 8500,
 -45798,
 1293448024,
 8467,
 -45797,
 1293505251,
 8458,
 -1,
 1293566087,
 8495,
 -1,
 1292686400,
 8456,
 -45794,
 1292605831,
 9807,
 -1,
 1293753143,
 9878,
 1293962542,
 1292517511,
 -1,
 1294028068,
 1293911185,
 -1,
 -45790,
 1293990395,
 9914,
 -45789,
 1294023165,
 10802,
 -1,
 1294086635,
 59,
 1294290215,
 1293989663,
 -1,
 -45786,
 1294248185,
 9916,
 -1,
 1294277836,
 65093,
 1294486826,
 1294218520,
 -1,
 -45783,
 1294440438,
 8980,
 -1,
 1294494620,
 167,
 -45781,
 1294459870,
 9913,
 -45780,
 1294648066,
 8726,
 -45779,
 1294710506,
 8480,
 -1,
 1294751248,
 8979,
 1294945597,
 1293927124,
 -1,
 1295011129,
 1294865780,
 -1,
 1295076662,
 1294969174,
 -1,
 1295142196,
 1295028623,
 -1,
 -45773,
 1295098470,
 8902,
 -1,
 1295142501,
 10017,
 -45771,
 1295075660,
 8795,
 -1,
 1295261050,
 9770,
 1295515647,
 1295011767,
 -1,
 -45768,
 1295408188,
 9882,
 -1,
 1295456354,
 9877,
 1295712255,
 1294969172,
 -1,
 -45765,
 1295606545,
 8803,
 -45764,
 1295665873,
 10025,
 -1,
 1295718708,
 9188,
 1295928650,
 1294889816,
 -1,
 1295994181,
 1295848820,
 -1,
 1296059716,
 1295945589,
 -1,
 1296125250,
 1296005455,
 10901,
 -1,
 1296043292,
 10903,
 1296302079,
 1296062199,
 10902,
 -1,
 1296174364,
 10904,
 -1,
 1296030834,
 42611,
 1296498687,
 1295947500,
 -1,
 1296518473,
 1296394431,
 -1,
 -45752,
 1296472054,
 10839,
 -1,
 1296506215,
 10840,
 -1,
 1296449671,
 9011,
 1296780627,
 1295884265,
 -1,
 1296846159,
 1296718894,
 8738,
 1296957439,
 1296762477,
 -1,
 -45746,
 1296880388,
 10657,
 -1,
 1296922245,
 10656,
 1297108306,
 1296766324,
 -1,
 -45743,
 1297068895,
 10055,
 -1,
 1297100424,
 32,
 -1,
 1297042107,
 8375,
 1297370455,
 1296731845,
 -1,
 1297435990,
 1297318390,
 9731,
 -1,
 1297354429,
 9924,
 -1,
 1297371382,
 10052,
 1297632602,
 1297313928,
 -1,
 -45735,
 1297600762,
 9760,
 -1,
 1297638451,
 9975,
 -45733,
 1297605365,
 8275,
 -1,
 1297745069,
 10700,
 1297961573,
 1206868107,
 -1,
 1298026610,
 1297880436,
 -1,
 1298091990,
 1297975519,
 -1,
 1298157501,
 1298027235,
 -1,
 1298223019,
 1298124981,
 -1,
 1298288265,
 1298165545,
 -1,
 1298353689,
 1298241120,
 -1,
 1298419081,
 1298312791,
 4527,
 1298530303,
 1298337491,
 -1,
 1298550126,
 1298440169,
 -1,
 1298615660,
 1298490438,
 4530,
 1298726911,
 1298534099,
 -1,
 -45719,
 1298647024,
 55257,
 -45718,
 1298709770,
 4563,
 -45717,
 1298768739,
 55258,
 -1,
 1298816206,
 4564,
 -45715,
 1298554075,
 4533,
 -1,
 1298931516,
 4567,
 1299139957,
 1298493576,
 -1,
 1299205491,
 1299083043,
 4528,
 1299316735,
 1299123923,
 -1,
 -45710,
 1299234058,
 4556,
 -1,
 1299274958,
 55254,
 -45708,
 1299143892,
 4568,
 -1,
 1299390536,
 4565,
 1299598714,
 1299088686,
 4529,
 1299709951,
 1299517139,
 -1,
 -45704,
 1299627274,
 4562,
 -45703,
 1299673711,
 4561,
 -1,
 1299733710,
 55256,
 1299926398,
 1299571899,
 -1,
 1299991933,
 1299880174,
 4569,
 -1,
 1299910645,
 55260,
 -1,
 1299954702,
 55259,
 1300188546,
 1299890900,
 -1,
 1300254081,
 1300129205,
 4558,
 -1,
 1300172789,
 4559,
 -1,
 1300192482,
 4532,
 1300450695,
 1300150047,
 -1,
 1300516230,
 1300412418,
 -1,
 -45691,
 1300479242,
 4566,
 -1,
 1300525679,
 55253,
 -1,
 1300458417,
 4531,
 -45688,
 1300401292,
 4557,
 -1,
 1300716750,
 4534,
 1300909482,
 1298380575,
 -1,
 1300975001,
 1300871170,
 -1,
 1301040527,
 1300937994,
 4539,
 1301151743,
 1300958931,
 -1,
 -45682,
 1301071856,
 55277,
 -1,
 1301115503,
 55276,
 1301302673,
 1301006320,
 55245,
 -1,
 1301221554,
 55246,
 1301433747,
 1301261911,
 4560,
 -1,
 1301352504,
 55255,
 -45676,
 1301390242,
 55270,
 -45675,
 1301515404,
 4607,
 -45674,
 1301579054,
 55264,
 -45673,
 1301639791,
 4521,
 -45672,
 1301701696,
 4590,
 -1,
 1301753905,
 55289,
 1302003711,
 1300917169,
 4538,
 1302069247,
 1301876435,
 -1,
 1302089118,
 1301988052,
 -1,
 -45667,
 1302029749,
 4584,
 -1,
 1302093026,
 55281,
 1302285729,
 1302044649,
 -1,
 -45664,
 1302225990,
 4586,
 -1,
 1302273852,
 55278,
 1302482340,
 1302229128,
 -1,
 -45661,
 1302425379,
 4583,
 -1,
 1302470728,
 55275,
 1302678951,
 1302408414,
 -1,
 -45658,
 1302619195,
 55279,
 -1,
 1302682823,
 55280,
 -45656,
 1302638167,
 4585,
 -45655,
 1302824238,
 55274,
 -1,
 1302879438,
 55282,
 1303072193,
 1300865001,
 -1,
 1303137720,
 1303012422,
 4536,
 1303248895,
 1303056083,
 -1,
 1303268783,
 1303166218,
 4537,
 -1,
 1303187836,
 55271,
 1303399857,
 1303227991,
 4579,
 -1,
 1303318697,
 55268,
 1303530932,
 1303325918,
 -1,
 -45645,
 1303471163,
 55272,
 -1,
 1303534791,
 55273,
 -45643,
 1303496688,
 55267,
 -45642,
 1303683939,
 4580,
 -45641,
 1303741742,
 55269,
 -1,
 1303796942,
 4581,
 1303989693,
 1303076059,
 4545,
 1304100863,
 1303908051,
 -1,
 -45637,
 1304020654,
 55291,
 -45636,
 1304083722,
 55290,
 -1,
 1304142754,
 4595,
 1304363007,
 1303912252,
 4587,
 1304428543,
 1304235731,
 -1,
 -45632,
 1304339362,
 55283,
 -1,
 1304391977,
 55284,
 1304579539,
 1303015560,
 -1,
 1304645068,
 1304522531,
 4520,
 1304756223,
 1304563411,
 -1,
 1304776134,
 1304673546,
 4522,
 -1,
 1304694859,
 4548,
 -45625,
 1304735319,
 4547,
 -45624,
 1304863650,
 4603,
 -45623,
 1304923276,
 4602,
 -45622,
 1304982073,
 4605,
 -45621,
 1305042126,
 4606,
 -1,
 1305096109,
 4604,
 1305300434,
 1304567872,
 -1,
 1305365968,
 1305255913,
 -1,
 -45617,
 1305306182,
 4582,
 -1,
 1305369819,
 4596,
 -45615,
 1305325143,
 55261,
 -1,
 1305511214,
 4578,
 -1,
 1305238740,
 4543,
 1305759205,
 1304528174,
 4535,
 1305870335,
 1305677523,
 -1,
 1305890266,
 1305786143,
 -1,
 1305955801,
 1305851906,
 -1,
 -45608,
 1305918730,
 4574,
 -1,
 1305971852,
 55263,
 -1,
 1305897905,
 4573,
 1306217950,
 1305845737,
 -1,
 1306283485,
 1306158150,
 4572,
 -1,
 1306202451,
 55265,
 -1,
 1306206012,
 4575,
 1306480097,
 1306143966,
 -1,
 -45600,
 1306420283,
 55266,
 -1,
 1306483911,
 4576,
 -45598,
 1306439255,
 4571,
 -45597,
 1306627212,
 55262,
 -45596,
 1306686063,
 4570,
 -1,
 1306746062,
 4577,
 1306938866,
 1305723604,
 -1,
 1307004401,
 1306879413,
 4526,
 1307115519,
 1306922707,
 -1,
 1307135466,
 1307032842,
 55248,
 -1,
 1307054155,
 55249,
 1307266541,
 1307061470,
 -1,
 -45588,
 1307206715,
 55250,
 -1,
 1307270343,
 55251,
 -45586,
 1307231918,
 55252,
 -45585,
 1307422295,
 4555,
 -45584,
 1307485090,
 55247,
 -1,
 1307538031,
 4554,
 -1,
 1306942690,
 4544,
 1307790847,
 1306889356,
 4523,
 1307901951,
 1307709139,
 -1,
 1307921911,
 1307820756,
 -1,
 -45578,
 1307862453,
 4550,
 -1,
 1307925730,
 4553,
 1308118522,
 1307847902,
 -1,
 -45575,
 1308058683,
 4524,
 -1,
 1308122311,
 55244,
 -45573,
 1308081418,
 4551,
 -45572,
 1308274263,
 55243,
 -45571,
 1308336332,
 4552,
 -45570,
 1308389999,
 4549,
 -1,
 1308449998,
 4525,
 1308642823,
 1307763899,
 -1,
 1308708358,
 1308605454,
 4592,
 1308819455,
 1308626643,
 -1,
 -45565,
 1308736778,
 4593,
 -45564,
 1308795084,
 4594,
 -45563,
 1308853550,
 55285,
 -1,
 1308908750,
 55286,
 -1,
 1308661998,
 4601,
 1309167117,
 1308581070,
 4546,
 1309278207,
 1309085395,
 -1,
 -45558,
 1309191767,
 4598,
 -45557,
 1309254562,
 4600,
 -45556,
 1309314188,
 4597,
 -1,
 1309377838,
 4599,
 1309560339,
 1309107264,
 4540,
 1309671423,
 1309478611,
 -1,
 1309691410,
 1309569160,
 -1,
 -45551,
 1309634339,
 4588,
 -1,
 1309695188,
 4591,
 -1,
 1309654991,
 4589,
 1309999103,
 1309486302,
 -1,
 1310019096,
 1309893691,
 4541,
 1310130175,
 1309937363,
 -1,
 -45545,
 1310048219,
 55288,
 -1,
 1310106530,
 55287,
 -1,
 1309957319,
 4542,
 1310392319,
 1298322037,
 -1,
 1310412351,
 1310319598,
 -1,
 1310477862,
 1310379594,
 4466,
 1310588927,
 1310396115,
 -1,
 1310608927,
 1310516411,
 4498,
 -1,
 1310560655,
 4497,
 1310740001,
 1310539911,
 4496,
 -1,
 1310691727,
 4495,
 1310871075,
 1310659956,
 4494,
 -1,
 1310802055,
 55223,
 -45532,
 1310838346,
 4499,
 -45531,
 1310953871,
 55224,
 -1,
 1311007103,
 4500,
 1311198769,
 1310429583,
 4461,
 1311309823,
 1311117011,
 -1,
 1311329836,
 1311237102,
 -1,
 1311395371,
 1311249780,
 4484,
 -1,
 1311326343,
 4485,
 -1,
 1311328367,
 4486,
 1311591982,
 1311249780,
 55218,
 -1,
 1311522951,
 55219,
 -45521,
 1311543695,
 4487,
 -45520,
 1311662463,
 4488,
 -1,
 1311721583,
 55220,
 1311919671,
 1311129735,
 4456,
 1312030719,
 1311871375,
 4455,
 1312096255,
 1311903443,
 -1,
 -45515,
 1312023594,
 4517,
 -45514,
 1312083530,
 4478,
 -1,
 1312133519,
 4477,
 1312312893,
 1311839604,
 4451,
 1312378428,
 1312231123,
 -1,
 -45510,
 1312351786,
 4473,
 -45509,
 1312411210,
 4516,
 -1,
 1312461199,
 4472,
 -1,
 1312309383,
 4452,
 1312751615,
 1312252287,
 4468,
 -1,
 1312625028,
 4503,
 1312837200,
 1310351743,
 4469,
 1312948223,
 1312755411,
 -1,
 1312968265,
 1312875502,
 -1,
 1313033797,
 1312888180,
 4505,
 -45500,
 1312964743,
 55230,
 -1,
 1313017989,
 55229,
 1313230407,
 1312964743,
 55232,
 -1,
 1313182095,
 55231,
 -45496,
 1313197642,
 55235,
 -1,
 1313313167,
 55234,
 1313492555,
 1312919951,
 4506,
 -1,
 1313411110,
 55233,
 1313623629,
 1313412468,
 4504,
 -1,
 1313581569,
 4509,
 -45490,
 1313590858,
 4507,
 -45489,
 1313694079,
 55236,
 -1,
 1313754176,
 4508,
 1313951326,
 1312768135,
 4454,
 1314016857,
 1313918538,
 4467,
 1314127871,
 1313935059,
 -1,
 1314147926,
 1314013319,
 55227,
 -45483,
 1314115146,
 4502,
 -1,
 1314165135,
 55226,
 -45481,
 1314115146,
 4501,
 -45480,
 1314296207,
 55228,
 -1,
 1314329972,
 55225,
 1314586623,
 1313968527,
 4453,
 1314652159,
 1314459347,
 -1,
 -45476,
 1314573898,
 4475,
 -45475,
 1314623887,
 4474,
 -1,
 1314671680,
 4476,
 1314868843,
 1313902991,
 4457,
 1314934378,
 1314787027,
 -1,
 1314999909,
 1314907118,
 -1,
 1315065443,
 1314930823,
 4481,
 -1,
 1315017103,
 55216,
 1315241983,
 1314985332,
 4518,
 -1,
 1315127431,
 4519,
 1315327591,
 1314951567,
 4482,
 -1,
 1315246118,
 55217,
 1315458665,
 1315258503,
 4480,
 -1,
 1315410319,
 4479,
 -1,
 1315425866,
 4483,
 -1,
 1314865287,
 4460,
 1315720824,
 1314788724,
 4449,
 1315786355,
 1315678721,
 4510,
 1315897343,
 1315704531,
 -1,
 1315917424,
 1315782791,
 55238,
 -1,
 1315869071,
 4511,
 -45455,
 1315884618,
 4512,
 -45454,
 1315987839,
 4513,
 -1,
 1316033908,
 55237,
 1316245111,
 1315704531,
 -1,
 -45451,
 1316212298,
 4471,
 -45450,
 1316262287,
 4470,
 -1,
 1316310080,
 4515,
 -1,
 1316176007,
 4450,
 1316572801,
 1315688010,
 4462,
 1316683775,
 1316490963,
 -1,
 1316703868,
 1316611259,
 4492,
 -1,
 1316655503,
 55221,
 1316834942,
 1316623732,
 4489,
 -1,
 1316765831,
 4490,
 -45441,
 1316802122,
 4493,
 -45440,
 1316905471,
 55222,
 -1,
 1316964466,
 4491,
 1317162631,
 1316543752,
 -1,
 1317228164,
 1317093511,
 4464,
 -1,
 1317179791,
 4463,
 1317359238,
 1317148020,
 4458,
 -1,
 1317290119,
 4459,
 -1,
 1317298559,
 4465,
 -45432,
 1317126084,
 4514,
 -1,
 1317490719,
 4448,
 1317687091,
 1298214877,
 -1,
 1317752495,
 1317648159,
 -1,
 1317818016,
 1317694385,
 4361,
 1317928959,
 1317736147,
 -1,
 1317949073,
 1317838825,
 -1,
 1318014608,
 1317889094,
 4402,
 -1,
 1317933131,
 4403,
 -1,
 1317952731,
 4410,
 1318211220,
 1317913300,
 -1,
 -45421,
 1318151605,
 4399,
 -1,
 1318214882,
 4409,
 1318407831,
 1318154376,
 -1,
 -45418,
 1318350627,
 4397,
 -1,
 1318411476,
 4408,
 1318604442,
 1318333662,
 -1,
 -45415,
 1318544443,
 4406,
 -1,
 1318608071,
 4407,
 -45413,
 1318567910,
 4404,
 -45412,
 1318760023,
 4400,
 -45411,
 1318816908,
 4398,
 -45410,
 1318880558,
 4401,
 -45409,
 1318937664,
 4405,
 -1,
 1319001294,
 4411,
 1319239679,
 1317779458,
 -1,
 1319259812,
 1319158484,
 -1,
 -45405,
 1319200181,
 4356,
 -1,
 1319263458,
 43385,
 1319456422,
 1319222538,
 4362,
 -1,
 1319375026,
 43381,
 1319587496,
 1319383089,
 4365,
 -1,
 1319505909,
 43384,
 -45399,
 1319560519,
 43388,
 -45398,
 1319677527,
 4377,
 -45397,
 1319740322,
 4360,
 -45396,
 1319799948,
 4372,
 -45395,
 1319858799,
 4353,
 -45394,
 1319920704,
 4423,
 -1,
 1319984334,
 4440,
 1320177357,
 1317707753,
 -1,
 1320242888,
 1320117318,
 4359,
 1320353791,
 1320160979,
 -1,
 1320373948,
 1320269599,
 -1,
 1320439483,
 1320315825,
 4385,
 1320550399,
 1320357587,
 -1,
 1320570552,
 1320469204,
 -1,
 -45385,
 1320510901,
 4387,
 -1,
 1320574178,
 43378,
 -45383,
 1320526754,
 4388,
 -45382,
 1320710767,
 4386,
 -1,
 1320759345,
 4390,
 -1,
 1320400903,
 4389,
 1321029311,
 1320338132,
 -1,
 -45378,
 1320969653,
 4384,
 -1,
 1321032930,
 4393,
 1321225922,
 1320972424,
 -1,
 -45375,
 1321168675,
 4382,
 -1,
 1321229524,
 43379,
 1321422533,
 1321151710,
 -1,
 -45372,
 1321362491,
 4391,
 -1,
 1321426119,
 4392,
 -45370,
 1321378659,
 4394,
 -45369,
 1321569420,
 4383,
 -1,
 1321622734,
 43380,
 1321815756,
 1320180955,
 4369,
 1321926655,
 1321733843,
 -1,
 -45365,
 1321837474,
 4438,
 -1,
 1321884878,
 43386,
 -1,
 1321738044,
 4416,
 1322143463,
 1320103134,
 -1,
 1322208988,
 1322081417,
 -1,
 1322274520,
 1322175628,
 -1,
 1322340053,
 1322235679,
 -1,
 1322405588,
 1322301442,
 -1,
 -45357,
 1322368266,
 4413,
 -1,
 1322397745,
 4431,
 -1,
 1322347441,
 4412,
 1322713087,
 1322265822,
 -1,
 -45353,
 1322607675,
 4430,
 -1,
 1322671303,
 4436,
 1322909695,
 1322208323,
 4366,
 1322975231,
 1322782419,
 -1,
 -45349,
 1322873401,
 4434,
 -1,
 1322933454,
 4435,
 1323126501,
 1322141816,
 -1,
 1323192034,
 1323087647,
 -1,
 1323257569,
 1323153410,
 -1,
 -45344,
 1323220234,
 4415,
 -1,
 1323249713,
 4433,
 -1,
 1323199409,
 4414,
 1323565055,
 1323117790,
 -1,
 -45340,
 1323459643,
 4432,
 -1,
 1323523271,
 4437,
 1323761663,
 1323066427,
 4364,
 -1,
 1323634729,
 4429,
 1323847417,
 1322102359,
 4357,
 1323958271,
 1323765459,
 -1,
 1323978479,
 1323874079,
 -1,
 1324044014,
 1323939842,
 -1,
 -45332,
 1324009456,
 43367,
 -45331,
 1324065698,
 43370,
 -1,
 1324118639,
 43365,
 -1,
 1323985841,
 43372,
 1324371699,
 1323921544,
 -1,
 -45327,
 1324314403,
 43364,
 -45326,
 1324375252,
 43374,
 -1,
 1324425288,
 43371,
 -45324,
 1324337136,
 43366,
 -45323,
 1324589986,
 43369,
 -45322,
 1324649612,
 4376,
 -45321,
 1324713262,
 43368,
 -45320,
 1324768462,
 4378,
 -1,
 1324822577,
 43373,
 1325027082,
 1323787328,
 4363,
 1325137919,
 1324945107,
 -1,
 1325158143,
 1325047785,
 -1,
 -45315,
 1325098054,
 4420,
 -45314,
 1325161691,
 4427,
 -1,
 1325211452,
 4422,
 1325420290,
 1325122260,
 -1,
 -45311,
 1325360565,
 4418,
 -1,
 1325423842,
 4426,
 1325616901,
 1325346014,
 -1,
 -45308,
 1325556795,
 4424,
 -1,
 1325620423,
 4425,
 -45306,
 1325579530,
 4421,
 -45305,
 1325772375,
 43382,
 -45304,
 1325827374,
 4419,
 -45303,
 1325888111,
 4417,
 -1,
 1325948110,
 43383,
 1326141204,
 1324991188,
 -1,
 1326206739,
 1326081461,
 4355,
 1326317567,
 1326124755,
 -1,
 -45298,
 1326234890,
 43362,
 -45297,
 1326296663,
 4446,
 -45296,
 1326359458,
 43361,
 -45295,
 1326417198,
 43360,
 -45294,
 1326477935,
 4375,
 -1,
 1326526513,
 43363,
 -1,
 1326144738,
 4368,
 1326796575,
 1326084232,
 -1,
 1326862108,
 1326719040,
 -1,
 1326927641,
 1326817257,
 -1,
 -45288,
 1326867526,
 4395,
 -1,
 1326931163,
 4439,
 -45286,
 1326890971,
 4396,
 -45285,
 1327083095,
 4379,
 -1,
 1327138094,
 4381,
 1327320862,
 1326804771,
 4352,
 -1,
 1327239548,
 4442,
 -1,
 1327258836,
 4367,
 1327517479,
 1326746764,
 4354,
 1327628287,
 1327435475,
 -1,
 -45278,
 1327548400,
 4373,
 -45277,
 1327611146,
 4443,
 -45276,
 1327670178,
 4374,
 -45275,
 1327723119,
 4371,
 -45274,
 1327783118,
 4445,
 -1,
 1327837233,
 4444,
 1328041773,
 1327465774,
 4358,
 1328152575,
 1327959763,
 -1,
 -45270,
 1328072688,
 43376,
 -45269,
 1328135434,
 43377,
 -45268,
 1328194466,
 4380,
 -1,
 1328247407,
 43375,
 1328434992,
 1328014523,
 -1,
 -45265,
 1328397326,
 4428,
 -1,
 1328453870,
 4441,
 1328631602,
 1328372942,
 4370,
 -1,
 1328550227,
 43387,
 -1,
 1328566303,
 4447,
 1328828328,
 1317632474,
 -1,
 1328893769,
 1328800750,
 -1,
 1328959292,
 1328824455,
 12630,
 1329024826,
 1328921614,
 12673,
 1329135615,
 1328942803,
 -1,
 -45255,
 1329052938,
 12674,
 -1,
 1329111244,
 12675,
 1329332223,
 1328976271,
 12629,
 -1,
 1329246728,
 12678,
 1329418049,
 1328926282,
 12640,
 1329528831,
 1329336019,
 -1,
 1329549120,
 1329456315,
 12683,
 -1,
 1329500559,
 12682,
 -1,
 1329488255,
 12684,
 1329745734,
 1329369487,
 12635,
 1329856511,
 1329663699,
 -1,
 1329876805,
 1329783850,
 12679,
 -1,
 1329807495,
 12680,
 -1,
 1329815935,
 12681,
 1330073416,
 1329665396,
 12625,
 -1,
 1330004103,
 12626,
 -1,
 1330012543,
 12642,
 1330270042,
 1328854815,
 -1,
 1330335571,
 1330231298,
 -1,
 -45236,
 1330300912,
 12600,
 -45235,
 1330363658,
 12614,
 -45234,
 1330422690,
 12611,
 -45233,
 1330482316,
 12645,
 -45232,
 1330541167,
 12594,
 -45231,
 1330603072,
 12672,
 -45230,
 1330666702,
 12677,
 -1,
 1330720817,
 12617,
 1330970623,
 1330277297,
 12613,
 1331036159,
 1330843347,
 -1,
 -45226,
 1330956272,
 12668,
 -45225,
 1331012514,
 12669,
 -45224,
 1331072140,
 12667,
 -45223,
 1331130991,
 12666,
 -1,
 1331179569,
 12670,
 1331384170,
 1330228823,
 12601,
 1331494911,
 1331302099,
 -1,
 1331515233,
 1331404777,
 -1,
 1331580767,
 1331455046,
 12604,
 -1,
 1331499347,
 12651,
 -45216,
 1331518683,
 12607,
 -1,
 1331633980,
 12652,
 1331842916,
 1331479252,
 -1,
 -45213,
 1331783093,
 12650,
 -1,
 1331846370,
 12606,
 1332039526,
 1331786351,
 12602,
 -1,
 1331958099,
 12649,
 -45209,
 1332012359,
 12653,
 -45208,
 1332133130,
 12605,
 -45207,
 1332184366,
 12603,
 -1,
 1332239566,
 12608,
 1332432760,
 1331339241,
 -1,
 1332498294,
 1332372550,
 12610,
 1332609023,
 1332416211,
 -1,
 1332629361,
 1332526346,
 12612,
 1332740095,
 1332547283,
 -1,
 -45200,
 1332660208,
 12661,
 -1,
 1332703855,
 12660,
 1332891508,
 1332593364,
 -1,
 -45197,
 1332831669,
 12659,
 -1,
 1332894946,
 12663,
 -45195,
 1332834927,
 12658,
 -1,
 1333014577,
 12662,
 -45193,
 1332436187,
 12621,
 -1,
 1333141308,
 12671,
 1333350274,
 1332375688,
 -1,
 1333415807,
 1333272640,
 -1,
 1333481341,
 1333370857,
 -1,
 -45188,
 1333421126,
 12664,
 -1,
 1333484763,
 12676,
 -45186,
 1333444571,
 12665,
 -1,
 1333626158,
 12657,
 1333809025,
 1333358371,
 12593,
 -1,
 1333727571,
 12595,
 -1,
 1333746900,
 12619,
 1334005641,
 1333300364,
 12596,
 1334116351,
 1333923539,
 -1,
 -45179,
 1334036464,
 12646,
 -45178,
 1334099210,
 12647,
 -45177,
 1334157516,
 12648,
 -45176,
 1334205646,
 12598,
 -1,
 1334259761,
 12597,
 1334464399,
 1333976328,
 -1,
 1334529932,
 1334395015,
 12638,
 -1,
 1334481295,
 12637,
 1334661006,
 1334449524,
 12632,
 -1,
 1334591623,
 12633,
 -1,
 1334600063,
 12639,
 1334857621,
 1334412590,
 12609,
 1334968319,
 1334775507,
 -1,
 1334988692,
 1334878185,
 -1,
 -45165,
 1334928454,
 12654,
 -1,
 1334976316,
 12656,
 -1,
 1334951178,
 12655,
 1335250841,
 1334777204,
 12623,
 1335316376,
 1335208449,
 12685,
 -1,
 1335246983,
 12686,
 -1,
 1335246983,
 12624,
 1335512988,
 1335181447,
 12628,
 -45157,
 1335479882,
 12641,
 -1,
 1335529871,
 12627,
 1335709599,
 1335476948,
 -1,
 -45154,
 1335649717,
 12599,
 -1,
 1335712994,
 12620,
 1335906209,
 1335660943,
 12631,
 -1,
 1335836807,
 12634,
 1336037283,
 1335845247,
 12643,
 -1,
 1335970896,
 12615,
 1336168358,
 1335962846,
 -1,
 -45147,
 1336108091,
 12616,
 -1,
 1336171719,
 12618,
 -45145,
 1336135242,
 12636,
 -1,
 1336302798,
 12622,
 -45143,
 1328790705,
 12334,
 -45142,
 1336430623,
 12644,
 -1,
 1336491244,
 12335,
 1336737791,
 1298196464,
 -1,
 1336758196,
 1336656596,
 -1,
 1336823728,
 1336728840,
 -1,
 -45137,
 1336775055,
 12322,
 -1,
 1336821839,
 12345,
 1337020339,
 1336760459,
 -1,
 -45134,
 1336978512,
 12323,
 -1,
 1337027798,
 12346,
 -1,
 1336952561,
 12344,
 1337282487,
 1336719135,
 -1,
 -45130,
 1337224942,
 12326,
 -1,
 1337281666,
 12327,
 1337479098,
 1337216598,
 -1,
 -45127,
 1337433072,
 12324,
 -1,
 1337486967,
 12325,
 -45125,
 1337431487,
 12321,
 -45124,
 1337625788,
 12329,
 -1,
 1337673015,
 12328,
 1337917439,
 1298125539,
 -1,
 1337937874,
 1337817562,
 -1,
 1338003394,
 1337886943,
 -1,
 -45119,
 1337938692,
 5925,
 -1,
 1337988468,
 5928,
 -45117,
 1337975850,
 5932,
 -45116,
 1338170672,
 5935,
 -45115,
 1338232394,
 5922,
 -45114,
 1338295061,
 5926,
 -45113,
 1338357657,
 5936,
 -45112,
 1338419631,
 5933,
 -45111,
 1338482766,
 5929,
 -45110,
 1338540082,
 5931,
 -45109,
 1338602413,
 5934,
 -45108,
 1338667167,
 5923,
 -45107,
 1338728831,
 5921,
 -45106,
 1338792105,
 5937,
 -45105,
 1338856196,
 5924,
 -45104,
 1338914443,
 5927,
 -45103,
 1338975912,
 5930,
 -1,
 1339037044,
 5920,
 1339248597,
 1337908406,
 -1,
 -45100,
 1339215434,
 5939,
 -1,
 1339253119,
 5938,
 -1,
 1339210837,
 5940,
 1339510894,
 1298037322,
 -1,
 1339576351,
 1339453769,
 -1,
 1339641886,
 1339490304,
 -1,
 1339707419,
 1339587034,
 -1,
 1339772907,
 1339668255,
 -1,
 1339838438,
 1339719966,
 -1,
 1339903968,
 1339810798,
 -1,
 -45090,
 1339870794,
 65389,
 -45089,
 1339920783,
 65390,
 -1,
 1339954548,
 65388,
 -45087,
 1339870794,
 65385,
 -45086,
 1340132489,
 65391,
 -45085,
 1340182927,
 65387,
 -45084,
 1340236159,
 65384,
 -45083,
 1340293255,
 65386,
 -1,
 1340347764,
 65383,
 -45081,
 1339805258,
 65405,
 -45080,
 1340510607,
 65407,
 -45079,
 1340563839,
 65404,
 -45078,
 1340620935,
 65406,
 -1,
 1340675444,
 65403,
 1340887025,
 1339721951,
 65437,
 -45075,
 1340853834,
 65415,
 -45074,
 1340903823,
 65417,
 -45073,
 1340957055,
 65414,
 -45072,
 1341014151,
 65416,
 -1,
 1341068660,
 65413,
 1341280247,
 1340850900,
 -1,
 -45069,
 1341247050,
 65410,
 -45068,
 1341297039,
 65412,
 -45067,
 1341350271,
 65409,
 -45066,
 1341407367,
 65411,
 -1,
 1341461876,
 65408,
 1341673469,
 1341237588,
 -1,
 -45063,
 1341640266,
 65433,
 -45062,
 1341690255,
 65435,
 -45061,
 1341743487,
 65432,
 -45060,
 1341800583,
 65434,
 -1,
 1341855092,
 65431,
 1342066691,
 1341620197,
 -1,
 -45057,
 1342033482,
 65425,
 -45056,
 1342083471,
 65427,
 -45055,
 1342136703,
 65424,
 -45054,
 1342193799,
 65426,
 -1,
 1342248308,
 65423,
 1342459913,
 1342009480,
 -1,
 -45051,
 1342426698,
 65400,
 -45050,
 1342476687,
 65402,
 -45049,
 1342529919,
 65399,
 -45048,
 1342587015,
 65401,
 -1,
 1342641524,
 65398,
 1342853135,
 1342396555,
 -1,
 -45045,
 1342819914,
 65420,
 -45044,
 1342869903,
 65422,
 -45043,
 1342923135,
 65419,
 -45042,
 1342980231,
 65421,
 -1,
 1343034740,
 65418,
 1343246355,
 1342825454,
 -1,
 -45039,
 1343213130,
 65429,
 -45038,
 1343263119,
 65430,
 -1,
 1343296884,
 65428,
 1343508502,
 1343216904,
 -1,
 -45035,
 1343459727,
 65382,
 -1,
 1343493492,
 65436,
 -45033,
 1343475274,
 65395,
 -45032,
 1343656335,
 65397,
 -45031,
 1343709567,
 65394,
 -45030,
 1343766663,
 65396,
 -1,
 1343821172,
 65393,
 -45028,
 1339677783,
 65438,
 -45027,
 1343994120,
 65439,
 -1,
 1344046304,
 65381,
 -1,
 1339559943,
 65392,
 1344295008,
 1339513426,
 -1,
 1344360543,
 1344240090,
 -1,
 1344426027,
 1344319063,
 65449,
 1344536575,
 1344343763,
 -1,
 1344557094,
 1344446441,
 -1,
 -45019,
 1344496710,
 65452,
 -1,
 1344560347,
 65455,
 -45017,
 1344521902,
 65454,
 -45016,
 1344716042,
 65453,
 -45015,
 1344767278,
 65451,
 -45014,
 1344828015,
 65450,
 -1,
 1344888014,
 65456,
 1345081395,
 1344398318,
 -1,
 1345146926,
 1345011847,
 65483,
 -1,
 1345098127,
 65482,
 1345278000,
 1345066356,
 65476,
 -1,
 1345208455,
 65477,
 -45007,
 1345244746,
 65495,
 -45006,
 1345360271,
 65490,
 -1,
 1345413503,
 65499,
 1345605691,
 1345042207,
 -1,
 1345671226,
 1345566722,
 -1,
 -45002,
 1345636336,
 65448,
 -45001,
 1345699082,
 65462,
 -45000,
 1345758114,
 65459,
 -44999,
 1345811055,
 65442,
 -1,
 1345859633,
 65465,
 -1,
 1345612721,
 65461,
 1346129985,
 1345576200,
 -1,
 1346195518,
 1346060423,
 65493,
 -1,
 1346146703,
 65492,
 1346326592,
 1346114932,
 65485,
 -1,
 1346257031,
 65486,
 -1,
 1346265471,
 65494,
 1346523205,
 1346084841,
 -1,
 1346588740,
 1346462790,
 65458,
 -1,
 1346507091,
 65460,
 -1,
 1346526427,
 65469,
 1346785353,
 1346473100,
 65444,
 1346895871,
 1346703059,
 -1,
 -44984,
 1346788558,
 65446,
 -1,
 1346842673,
 65445,
 1347047501,
 1346728072,
 -1,
 1347113036,
 1346989859,
 65441,
 -1,
 1347031379,
 65443,
 -1,
 1347050708,
 65467,
 1347309648,
 1346977927,
 65479,
 -44977,
 1347276362,
 65498,
 -1,
 1347326351,
 65478,
 1347506259,
 1347273428,
 -1,
 -44974,
 1347446197,
 65447,
 -1,
 1347509474,
 65468,
 1347702869,
 1347457423,
 65484,
 -1,
 1347633287,
 65487,
 1347833943,
 1347641727,
 65500,
 -1,
 1347767376,
 65463,
 1347965018,
 1347759326,
 -1,
 -44967,
 1347904571,
 65464,
 -1,
 1347968199,
 65466,
 1348161628,
 1347884404,
 65474,
 -1,
 1348092039,
 65475,
 -44963,
 1348128330,
 65491,
 -44962,
 1348240686,
 65457,
 -1,
 1348295886,
 65470,
 -1,
 1344294943,
 65440,
 1348554851,
 1344253537,
 -1,
 -44958,
 1348525409,
 65515,
 -1,
 1348534963,
 65379,
 1348751462,
 1348499077,
 -1,
 -44955,
 1348722017,
 65513,
 -1,
 1348731571,
 65378,
 1348948073,
 1348690882,
 -1,
 -44952,
 1348883138,
 65377,
 -1,
 1348940303,
 65380,
 -44950,
 1348918978,
 65518,
 -44949,
 1349113166,
 65514,
 -44948,
 1349145019,
 65512,
 -44947,
 1349205849,
 65516,
 -1,
 1349265991,
 65517,
 1349472369,
 1339459081,
 -1,
 -44944,
 1349434369,
 9773,
 -1,
 1349493651,
 9874,
 -1,
 1349413875,
 8202,
 1349734872,
 1297956999,
 -1,
 1349800230,
 1349659619,
 -1,
 1349865684,
 1349743448,
 -1,
 1349931212,
 1349798963,
 -1,
 1349996671,
 1349902119,
 -1,
 -44936,
 1349960798,
 64296,
 -44935,
 1350020365,
 64295,
 -44934,
 1350071525,
 64293,
 -44933,
 1350136011,
 64292,
 -44932,
 1350196008,
 64291,
 -44931,
 1350258770,
 64294,
 -44930,
 1350317783,
 64290,
 -1,
 1350376113,
 64289,
 1350586507,
 1349957407,
 -1,
 1350652041,
 1350524291,
 1513,
 1350762495,
 1350568995,
 -1,
 1350783110,
 1350645419,
 64329,
 1350893567,
 1350697288,
 -1,
 -44923,
 1350788962,
 64301,
 -1,
 1350851975,
 64300,
 1351090175,
 1350743839,
 -1,
 -44920,
 1350985570,
 64299,
 -1,
 1351048583,
 64298,
 1351286783,
 1350573274,
 1505,
 -1,
 1351158974,
 64321,
 1351372947,
 1350520882,
 -1,
 1351438478,
 1351328173,
 1507,
 -1,
 1351355582,
 64323,
 1351569552,
 1351381195,
 1498,
 -1,
 1351486654,
 64314,
 -44911,
 1351535622,
 1509,
 -44910,
 1351651495,
 1503,
 -1,
 1351713767,
 1501,
 1351897246,
 1351292276,
 -1,
 1351962781,
 1351840600,
 -1,
 1352028314,
 1351893890,
 1488,
 1352138751,
 1351945251,
 -1,
 -44904,
 1352050564,
 64303,
 -44903,
 1352114557,
 64302,
 -1,
 1352172089,
 64304,
 1352400895,
 1351992734,
 -1,
 -44900,
 1352311945,
 64297,
 -1,
 1352345197,
 64288,
 -1,
 1351935440,
 1506,
 1352618149,
 1351860948,
 -1,
 1352683681,
 1352579015,
 1510,
 -1,
 1352600766,
 64326,
 1352814755,
 1352616765,
 1496,
 -1,
 1352731838,
 64312,
 1352990719,
 1352738261,
 1514,
 -1,
 1352862910,
 64330,
 1353076905,
 1352590893,
 1497,
 1353187327,
 1352993827,
 -1,
 -44888,
 1353080230,
 64285,
 -1,
 1353135787,
 64313,
 1353339053,
 1353046240,
 1493,
 1353449471,
 1353255971,
 -1,
 -44884,
 1353342589,
 64331,
 -1,
 1353397931,
 64309,
 1353601201,
 1353294253,
 1508,
 1353711615,
 1353518115,
 -1,
 -44880,
 1353624070,
 64334,
 -1,
 1353660075,
 64324,
 1353863349,
 1353543883,
 1499,
 1353973759,
 1353780259,
 -1,
 -44876,
 1353886214,
 64333,
 -1,
 1353922219,
 64315,
 1354125496,
 1353800488,
 1492,
 -44873,
 1354089172,
 1495,
 -1,
 1354108376,
 64308,
 1354322108,
 1354049811,
 1489,
 1354432511,
 1354239011,
 -1,
 -44869,
 1354344966,
 64332,
 -1,
 1354380971,
 64305,
 1354584254,
 1354295146,
 1494,
 -1,
 1354501310,
 64310,
 1354715328,
 1354542349,
 1512,
 -1,
 1354632382,
 64328,
 1354846402,
 1354672047,
 1511,
 -1,
 1354763454,
 64327,
 1354977476,
 1354797223,
 1504,
 -1,
 1354894526,
 64320,
 1355108550,
 1354925031,
 1502,
 -1,
 1355025598,
 64318,
 1355239624,
 1355052261,
 1500,
 -1,
 1355156670,
 64316,
 1355370698,
 1355175309,
 1490,
 -1,
 1355287742,
 64306,
 1355546623,
 1355298519,
 1491,
 -1,
 1355418814,
 64307,
 1355677695,
 1349870751,
 -1,
 1355698387,
 1355605363,
 -1,
 1355763921,
 1355627599,
 -1,
 -44848,
 1355736621,
 1522,
 -1,
 1355798752,
 1520,
 -44846,
 1355736625,
 64287,
 -1,
 1355929828,
 1521,
 -1,
 1355619004,
 64335,
 1356157184,
 1349785398,
 -1,
 1356222684,
 1356130078,
 -1,
 1356288219,
 1356141940,
 -1,
 1356353754,
 1356244890,
 -1,
 -44839,
 1356310420,
 1428,
 -1,
 1356354362,
 1429,
 -1,
 1356313953,
 1432,
 -1,
 1356228991,
 1454,
 1356681443,
 1356186324,
 -1,
 1356746978,
 1356611719,
 -1,
 1356812513,
 1356692401,
 -1,
 -44832,
 1356769183,
 1449,
 -1,
 1356813386,
 1440,
 -1,
 1356782527,
 1435,
 -1,
 1356688329,
 1430,
 1357140200,
 1356627941,
 -1,
 1357205734,
 1357072870,
 1445,
 -1,
 1357120783,
 1446,
 -44825,
 1357173219,
 1443,
 -1,
 1357256977,
 1444,
 1357467884,
 1357075576,
 -1,
 1357533419,
 1357400694,
 1436,
 -1,
 1357448675,
 1437,
 -1,
 1357494992,
 1438,
 1357730031,
 1357440187,
 -1,
 -44818,
 1357695236,
 1434,
 -1,
 1357752862,
 1450,
 1357926642,
 1357690655,
 -1,
 -44815,
 1357863390,
 1427,
 -1,
 1357923523,
 1426,
 1358123253,
 1357883210,
 -1,
 -44812,
 1358083007,
 1439,
 -1,
 1358117568,
 1448,
 1358319864,
 1358078030,
 -1,
 -44809,
 1358292881,
 1441,
 -1,
 1358347213,
 1433,
 1358516475,
 1358247456,
 -1,
 -44806,
 1358447901,
 1453,
 -1,
 1358504339,
 1447,
 -44804,
 1358474677,
 1431,
 -44803,
 1358664799,
 1451,
 -44802,
 1358718554,
 1452,
 -44801,
 1358777324,
 1425,
 -1,
 1358832982,
 1442,
 1359040802,
 1356111849,
 -1,
 1359106330,
 1358992311,
 -1,
 1359171850,
 1359042699,
 -1,
 1359237383,
 1359094915,
 -1,
 -44795,
 1359198461,
 1457,
 -44794,
 1359259524,
 1459,
 -1,
 1359323517,
 1458,
 1359499529,
 1359189013,
 1465,
 -1,
 1359414337,
 1466,
 -1,
 1359441054,
 1460,
 1359696144,
 1359132447,
 -1,
 1359761678,
 1359632523,
 -1,
 -44787,
 1359701858,
 1473,
 -1,
 1359760495,
 1456,
 -44785,
 1359701858,
 1474,
 -1,
 1359889603,
 1462,
 1360089364,
 1359652676,
 -1,
 1360154899,
 1360010395,
 1464,
 -1,
 1360071060,
 1479,
 -1,
 1360121838,
 1467,
 -44779,
 1360055308,
 1461,
 -44778,
 1360308742,
 1471,
 -44777,
 1360372093,
 1463,
 -44776,
 1360430173,
 1469,
 -44775,
 1360490583,
 64286,
 -1,
 1360541362,
 1468,
 1360789503,
 1359073815,
 -1,
 1360810270,
 1360680056,
 -1,
 -44771,
 1360771792,
 1524,
 -1,
 1360808566,
 1523,
 -44769,
 1360772732,
 1475,
 -44768,
 1360961911,
 1472,
 -44767,
 1361023147,
 1478,
 -1,
 1361084991,
 1470,
 1361313791,
 1358987871,
 -1,
 -44764,
 1361237101,
 1476,
 -44763,
 1361281690,
 1455,
 -1,
 1361346173,
 1477,
 1361531269,
 1349772077,
 -1,
 1361596732,
 1361494740,
 -1,
 1361662267,
 1361533739,
 -1,
 1361727789,
 1361587422,
 -1,
 -44757,
 1361685416,
 19904,
 -44756,
 1361738592,
 19933,
 -1,
 1361782200,
 19953,
 1361989938,
 1361646964,
 -1,
 1362055473,
 1361946964,
 -1,
 -44752,
 1362009245,
 19954,
 -1,
 1362069691,
 19910,
 -1,
 1361980600,
 19932,
 1362317621,
 1361960200,
 -1,
 -44748,
 1362249200,
 19951,
 -1,
 1362304581,
 19959,
 -44746,
 1362275264,
 19905,
 -44745,
 1362461312,
 19957,
 -44744,
 1362522562,
 19955,
 -44743,
 1362587723,
 19961,
 -44742,
 1362646124,
 19960,
 -1,
 1362710282,
 19940,
 -1,
 1361619847,
 19913,
 1362972998,
 1361524256,
 -1,
 1363038529,
 1362903175,
 -1,
 -44737,
 1363007865,
 19956,
 -44736,
 1363049448,
 19943,
 -1,
 1363096502,
 19944,
 1363300676,
 1362977151,
 -1,
 -44733,
 1363263257,
 19962,
 -1,
 1363300314,
 19906,
 -44731,
 1363269061,
 19935,
 -1,
 1363419631,
 19939,
 1363628369,
 1362907875,
 -1,
 1363693904,
 1363585364,
 -1,
 1363759439,
 1363624326,
 -1,
 1363824974,
 1363714025,
 -1,
 1363890509,
 1363775887,
 -1,
 -44724,
 1363861100,
 19937,
 -1,
 1363918838,
 19917,
 -1,
 1363848418,
 19931,
 -1,
 1363788793,
 19929,
 -1,
 1363679038,
 19925,
 -1,
 1363617024,
 19948,
 1364349271,
 1363588895,
 -1,
 1364414805,
 1364295966,
 -1,
 -44716,
 1364378617,
 19912,
 -1,
 1364436552,
 19965,
 -44714,
 1364378646,
 19915,
 -1,
 1364567089,
 19926,
 1364742493,
 1364289328,
 -1,
 1364808027,
 1364691167,
 -1,
 -44710,
 1364759143,
 19928,
 -1,
 1364806020,
 19964,
 -44708,
 1364742502,
 19934,
 -1,
 1364931510,
 19945,
 1365135714,
 1364700036,
 -1,
 1365201249,
 1365099220,
 -1,
 -44704,
 1365169664,
 19927,
 -1,
 1365224347,
 19936,
 -1,
 1365171305,
 19952,
 1365463398,
 1365090281,
 -1,
 -44700,
 1365431971,
 19949,
 -44699,
 1365488646,
 19938,
 -1,
 1365524749,
 19914,
 1365725547,
 1365414287,
 -1,
 1365791082,
 1365681534,
 -1,
 -44695,
 1365749018,
 19950,
 -1,
 1365809674,
 19941,
 -1,
 1365716016,
 19942,
 1366053232,
 1365651944,
 -1,
 1366118767,
 1366001887,
 -1,
 -44690,
 1366082843,
 19923,
 -1,
 1366118723,
 19909,
 -1,
 1366066558,
 19947,
 1366380916,
 1365976694,
 -1,
 -44686,
 1366338447,
 19946,
 -44685,
 1366388238,
 19924,
 -1,
 1366442889,
 19967,
 1366643064,
 1366300020,
 -1,
 -44682,
 1366599091,
 19922,
 -44681,
 1366643320,
 19966,
 -1,
 1366699090,
 19958,
 1366905211,
 1366613256,
 -1,
 -44678,
 1366858027,
 19921,
 -1,
 1366890918,
 19908,
 1367101822,
 1366853172,
 -1,
 -44675,
 1367070525,
 19930,
 -1,
 1367095336,
 19918,
 1367298433,
 1367035478,
 -1,
 -44672,
 1367250072,
 19920,
 -1,
 1367295493,
 19916,
 -44670,
 1367270988,
 19907,
 -44669,
 1367440087,
 19963,
 -44668,
 1367498377,
 19911,
 -1,
 1367558167,
 19919,
 1367757268,
 1361450356,
 -1,
 1367822803,
 1367727358,
 -1,
 1367888273,
 1367747806,
 -1,
 1367953805,
 1367829532,
 11096,
 1368019340,
 1367870499,
 -1,
 -44661,
 1367982351,
 9955,
 -1,
 1368010833,
 11095,
 -1,
 1367946842,
 11097,
 1368281488,
 1367890728,
 -1,
 -44657,
 1368251624,
 10054,
 -1,
 1368273192,
 10004,
 -1,
 1368233343,
 10152,
 1368543645,
 1367811702,
 -1,
 1368609180,
 1368486928,
 -1,
 1368674711,
 1368526706,
 -1,
 -44651,
 1368637148,
 10167,
 -44650,
 1368699039,
 10168,
 -1,
 1368755748,
 10169,
 1368981503,
 1368588288,
 -1,
 1369002395,
 1368864217,
 -1,
 -44646,
 1368970545,
 10150,
 -1,
 1368997690,
 10149,
 -1,
 1368939348,
 10084,
 -1,
 1368529936,
 10008,
 1369330084,
 1368507092,
 -1,
 1369395619,
 1369260367,
 -1,
 1369461154,
 1369351478,
 -1,
 -44639,
 1369416634,
 10051,
 -1,
 1369449476,
 10045,
 -1,
 1369397850,
 10171,
 -1,
 1369353743,
 10142,
 1369788842,
 1369290527,
 -1,
 1369854376,
 1369729271,
 -1,
 -44633,
 1369820396,
 10075,
 -1,
 1369846305,
 10076,
 -44631,
 1369809238,
 10056,
 -1,
 1370004680,
 10136,
 1370182065,
 1369745748,
 -1,
 1370247600,
 1370121443,
 -1,
 1370313135,
 1370165444,
 -1,
 -44626,
 1370270002,
 10095,
 -1,
 1370303360,
 10097,
 -1,
 1370283361,
 10137,
 -1,
 1370200992,
 10140,
 1370640823,
 1370125144,
 -1,
 1370706357,
 1370571790,
 -1,
 -44620,
 1370663218,
 10094,
 -1,
 1370696576,
 10096,
 -44618,
 1370660728,
 10157,
 -1,
 1370825118,
 11093,
 1371034046,
 1370570887,
 -1,
 1371099579,
 1371005782,
 -1,
 -44614,
 1371062876,
 10071,
 -1,
 1371117923,
 10082,
 1371340799,
 1371038952,
 -1,
 -44611,
 1371260075,
 10059,
 -1,
 1371317446,
 10040,
 1371492802,
 1371004168,
 -1,
 -44608,
 1371431812,
 10132,
 -44607,
 1371495916,
 9947,
 -1,
 1371554532,
 10173,
 1371754950,
 1371443599,
 -1,
 -44604,
 1371723738,
 11094,
 -44603,
 1371789159,
 10030,
 -1,
 1371841031,
 10012,
 1372017099,
 1371682336,
 -1,
 1372082634,
 1371970356,
 -1,
 -44599,
 1372048620,
 10077,
 -1,
 1372074529,
 10078,
 -1,
 1372005265,
 10144,
 -44596,
 1371986524,
 10074,
 -44595,
 1372312740,
 10158,
 -44594,
 1372360228,
 10138,
 -44593,
 1372424227,
 10006,
 -44592,
 1372478298,
 10083,
 -44591,
 1372542893,
 10010,
 -44590,
 1372606933,
 10020,
 -1,
 1372660740,
 10033,
 -1,
 1367752745,
 9980,
 1372934615,
 1367702690,
 -1,
 -44586,
 1372867396,
 9937,
 -1,
 1372916372,
 9096,
 -1,
 1372894072,
 8889,
 1373196870,
 1349673343,
 -1,
 1373262404,
 1373153803,
 -1,
 1373327937,
 1373207002,
 -1,
 1373393392,
 1373288223,
 -1,
 1373458923,
 1373339934,
 -1,
 1373524449,
 1373430766,
 -1,
 -44577,
 1373490762,
 12421,
 -44576,
 1373540751,
 12423,
 -1,
 1373574516,
 12419,
 1373786596,
 1373466760,
 -1,
 -44573,
 1373716615,
 12438,
 -1,
 1373771124,
 12437,
 -44571,
 1373756720,
 12430,
 -44570,
 1373949514,
 12357,
 -44569,
 1374014601,
 12387,
 -44568,
 1374065039,
 12361,
 -44567,
 1374118271,
 12355,
 -44566,
 1374175367,
 12359,
 -1,
 1374229876,
 12353,
 -44564,
 1373425226,
 12377,
 -44563,
 1374392719,
 12381,
 -44562,
 1374445951,
 12375,
 -44561,
 1374503047,
 12379,
 -1,
 1374557556,
 12373,
 1374769654,
 1373341919,
 12435,
 -44558,
 1374735946,
 12396,
 -44557,
 1374785935,
 12398,
 -44556,
 1374839167,
 12395,
 -44555,
 1374896263,
 12397,
 -1,
 1374950772,
 12394,
 1375162876,
 1374742302,
 -1,
 -44552,
 1375129162,
 12378,
 -44551,
 1375179151,
 12382,
 -44550,
 1375232383,
 12376,
 -44549,
 1375289479,
 12380,
 -1,
 1375343988,
 12374,
 1375556098,
 1375126228,
 -1,
 -44546,
 1375522378,
 12388,
 -44545,
 1375572367,
 12392,
 -44544,
 1375625599,
 12385,
 -44543,
 1375682695,
 12390,
 -1,
 1375737204,
 12383,
 1375949320,
 1375512916,
 -1,
 -44540,
 1375915594,
 12427,
 -44539,
 1375965583,
 12429,
 -44538,
 1376018815,
 12426,
 -44537,
 1376075911,
 12428,
 -1,
 1376130420,
 12425,
 1376342542,
 1375903721,
 -1,
 -44534,
 1376308810,
 12407,
 -44533,
 1376358799,
 12413,
 -44532,
 1376412031,
 12404,
 -44531,
 1376469127,
 12410,
 -1,
 1376523636,
 12401,
 1376735764,
 1376288741,
 -1,
 -44528,
 1376702026,
 12416,
 -44527,
 1376752015,
 12418,
 -44526,
 1376805247,
 12415,
 -44525,
 1376862343,
 12417,
 -1,
 1376916852,
 12414,
 1377128986,
 1376678024,
 -1,
 -44522,
 1377095242,
 12367,
 -44521,
 1377145231,
 12371,
 -44520,
 1377198463,
 12365,
 -44519,
 1377255559,
 12369,
 -1,
 1377310068,
 12363,
 1377522208,
 1377065099,
 -1,
 -44516,
 1377488458,
 12405,
 -44515,
 1377538447,
 12411,
 -44514,
 1377591679,
 12402,
 -44513,
 1377648775,
 12408,
 -1,
 1377703284,
 12399,
 1377915430,
 1377456867,
 -1,
 -44510,
 1377881674,
 12368,
 -44509,
 1377931663,
 12372,
 -44508,
 1377984895,
 12366,
 -44507,
 1378041991,
 12370,
 -1,
 1378096500,
 12364,
 1378308652,
 1377842720,
 -1,
 -44504,
 1378274890,
 12389,
 -44503,
 1378324879,
 12393,
 -44502,
 1378378111,
 12386,
 -44501,
 1378435207,
 12391,
 -1,
 1378489716,
 12384,
 1378701874,
 1378231926,
 -1,
 -44498,
 1378668106,
 12406,
 -44497,
 1378718095,
 12412,
 -44496,
 1378771327,
 12403,
 -44495,
 1378828423,
 12409,
 -1,
 1378882932,
 12400,
 1379095095,
 1378671880,
 -1,
 -44492,
 1379045775,
 12434,
 -44491,
 1379099007,
 12432,
 -44490,
 1379156103,
 12433,
 -1,
 1379210612,
 12431,
 1379422779,
 1379066862,
 -1,
 -44487,
 1379389002,
 12422,
 -44486,
 1379438991,
 12424,
 -1,
 1379472756,
 12420,
 -44484,
 1379392759,
 12436,
 -44483,
 1379651146,
 12358,
 -44482,
 1379701135,
 12362,
 -44481,
 1379754367,
 12356,
 -44480,
 1379811463,
 12360,
 -1,
 1379865972,
 12354,
 -44478,
 1373297704,
 12446,
 -44477,
 1380019653,
 12445,
 -1,
 1380071893,
 12447,
 -44475,
 1373225154,
 9964,
 -1,
 1380209838,
 9889,
 1380405850,
 1373147535,
 -1,
 1380471379,
 1380365090,
 -1,
 1380536909,
 1380431969,
 -1,
 -44470,
 1380455745,
 9149,
 -44469,
 1380521158,
 9148,
 -44468,
 1380586316,
 9147,
 -1,
 1380651535,
 9146,
 1380864592,
 1380460150,
 -1,
 -44465,
 1380807720,
 11043,
 -1,
 1380851804,
 8213,
 -44463,
 1380811011,
 9897,
 -44462,
 1381006083,
 9135,
 -1,
 1381058044,
 8230,
 1381257814,
 1380437578,
 -1,
 -44459,
 1381218456,
 8962,
 -1,
 1381281237,
 8987,
 1381454425,
 1381221078,
 -1,
 -44456,
 1381416783,
 9832,
 -1,
 1381443892,
 9749,
 -1,
 1381402427,
 8763,
 1381716580,
 1380377582,
 -1,
 1381782115,
 1381670889,
 -1,
 1381847650,
 1381719078,
 8208,
 1381913184,
 1381761024,
 -1,
 -44449,
 1381883821,
 11802,
 -1,
 1381903423,
 8259,
 -44447,
 1381836100,
 8231,
 -1,
 1382027378,
 45,
 -1,
 1381798582,
 11794,
 -1,
 1381744731,
 9102,
 -1,
 1381676819,
 8372,
 1382438738,
 1297896163,
 -1,
 1382503716,
 1382394196,
 -1,
 1382569251,
 1382432903,
 -1,
 1382634745,
 1382499744,
 -1,
 1382699849,
 1382594335,
 -1,
 1382765379,
 1382646046,
 -1,
 1382830911,
 1382709722,
 -1,
 1382896279,
 1382782150,
 -1,
 1382961802,
 1382827168,
 969,
 1383071743,
 1382878243,
 -1,
 1383092859,
 1382981609,
 -1,
 1383158393,
 1383054458,
 8032,
 1383268351,
 1383071866,
 -1,
 1383289460,
 1383192597,
 8034,
 -1,
 1383203259,
 8098,
 1383420534,
 1383244493,
 8038,
 -1,
 1383334331,
 8102,
 1383551608,
 1383374806,
 8036,
 -1,
 1383465403,
 8100,
 -1,
 1383523950,
 8096,
 1383792639,
 1383090651,
 8182,
 -1,
 1383662011,
 8183,
 1383879300,
 1383020313,
 8033,
 1383989247,
 1383792762,
 -1,
 1384010367,
 1383913493,
 8035,
 -1,
 1383924155,
 8099,
 1384141441,
 1383965389,
 8039,
 -1,
 1384055227,
 8103,
 1384272515,
 1384095702,
 8037,
 -1,
 1384186299,
 8101,
 -1,
 1384244846,
 8097,
 1384469126,
 1383847957,
 8060,
 -1,
 1384382907,
 8178,
 1384600200,
 1384423382,
 8061,
 -1,
 1384513979,
 8180,
 -44407,
 1384572526,
 8179,
 -1,
 1384696309,
 974,
 1384906751,
 1382900491,
 959,
 1384972287,
 1384778787,
 -1,
 1384993424,
 1384883915,
 8000,
 1385103359,
 1384906874,
 -1,
 -44401,
 1385027605,
 8002,
 -1,
 1385078742,
 8004,
 1385255572,
 1384920857,
 8001,
 1385365503,
 1385169018,
 -1,
 -44397,
 1385289749,
 8003,
 -1,
 1385340886,
 8005,
 -44395,
 1385224213,
 8056,
 -44394,
 1385482741,
 972,
 -1,
 1385537494,
 8057,
 1385714370,
 1382826119,
 -1,
 1385779893,
 1385677589,
 951,
 1385889791,
 1385696291,
 -1,
 1385910950,
 1385799657,
 -1,
 1385976484,
 1385872506,
 7968,
 1386086399,
 1385889914,
 -1,
 1386107551,
 1386010645,
 7970,
 -1,
 1386021307,
 8082,
 1386238625,
 1386062541,
 7974,
 -1,
 1386152379,
 8086,
 1386369699,
 1386192854,
 7972,
 -1,
 1386283451,
 8084,
 -1,
 1386341998,
 8080,
 1386610687,
 1385908699,
 8134,
 -1,
 1386480059,
 8135,
 1386697391,
 1385838361,
 7969,
 1386807295,
 1386610810,
 -1,
 1386828458,
 1386731541,
 7971,
 -1,
 1386742203,
 8083,
 1386959532,
 1386783437,
 7975,
 -1,
 1386873275,
 8087,
 1387090606,
 1386913750,
 7973,
 -1,
 1387004347,
 8085,
 -1,
 1387062894,
 8081,
 1387287217,
 1386666005,
 8052,
 -1,
 1387200955,
 8130,
 1387418291,
 1387241430,
 8053,
 -1,
 1387332027,
 8132,
 -44364,
 1387390574,
 8131,
 -1,
 1387514357,
 942,
 1387724799,
 1385735889,
 949,
 1387790335,
 1387596835,
 -1,
 1387811515,
 1387701963,
 7952,
 1387921407,
 1387724922,
 -1,
 -44358,
 1387845653,
 7954,
 -1,
 1387896790,
 7956,
 1388073663,
 1387738905,
 7953,
 1388183551,
 1387987066,
 -1,
 -44354,
 1388107797,
 7955,
 -1,
 1388158934,
 7957,
 -44352,
 1388042261,
 8050,
 -44351,
 1388300789,
 941,
 -1,
 1388355542,
 8051,
 1388532454,
 1385633140,
 -1,
 1388597987,
 1388478176,
 945,
 1388707839,
 1388514339,
 -1,
 1388729041,
 1388617705,
 -1,
 1388794575,
 1388690554,
 7936,
 1388904447,
 1388707962,
 -1,
 1388925642,
 1388828693,
 7938,
 -1,
 1388839355,
 8066,
 1389056716,
 1388880589,
 7942,
 -1,
 1388970427,
 8070,
 1389187790,
 1389010902,
 7940,
 -1,
 1389101499,
 8068,
 -1,
 1389160046,
 8064,
 1389428735,
 1388726747,
 8118,
 -1,
 1389298107,
 8119,
 1389515482,
 1388656409,
 7937,
 1389625343,
 1389428858,
 -1,
 1389646549,
 1389549589,
 7939,
 -1,
 1389560251,
 8067,
 1389777623,
 1389601485,
 7943,
 -1,
 1389691323,
 8071,
 1389908697,
 1389731798,
 7941,
 -1,
 1389822395,
 8069,
 -1,
 1389880942,
 8065,
 1390105310,
 1389483950,
 -1,
 1390170845,
 1390027209,
 8048,
 -1,
 1390084539,
 8114,
 -1,
 1390127570,
 8112,
 1390367456,
 1390059478,
 8049,
 -1,
 1390281147,
 8116,
 -44319,
 1390339694,
 8115,
 -44318,
 1390463477,
 940,
 -1,
 1390510139,
 8113,
 1390739455,
 1388555045,
 -1,
 -44315,
 1390655470,
 883,
 -1,
 1390703276,
 985,
 1390891777,
 1388500201,
 965,
 1391001599,
 1390808099,
 -1,
 1391022836,
 1390884384,
 -1,
 1391088367,
 1390961208,
 971,
 1391198207,
 1391001722,
 -1,
 -44308,
 1391122453,
 8162,
 -44307,
 1391184373,
 944,
 -44306,
 1391239885,
 8167,
 -1,
 1391304662,
 8163,
 1391525887,
 1391010751,
 8017,
 1391591423,
 1391394938,
 -1,
 -44302,
 1391515669,
 8019,
 -44301,
 1391567565,
 8023,
 -1,
 1391632342,
 8021,
 1391809275,
 1390977001,
 -1,
 1391874810,
 1391770746,
 8016,
 1391984639,
 1391788154,
 -1,
 -44296,
 1391908885,
 8018,
 -44295,
 1391960781,
 8022,
 -1,
 1392025558,
 8020,
 -1,
 1391806939,
 8166,
 1392268030,
 1391777710,
 -1,
 -44291,
 1392224722,
 8160,
 -1,
 1392255433,
 8058,
 -44289,
 1392232949,
 973,
 -44288,
 1392418774,
 8059,
 -1,
 1392476219,
 8161,
 1392661276,
 1390832565,
 953,
 1392771071,
 1392577571,
 -1,
 1392792335,
 1392653856,
 -1,
 1392857866,
 1392730680,
 970,
 1392967679,
 1392771194,
 -1,
 -44281,
 1392891925,
 8146,
 -44280,
 1392953845,
 912,
 -44279,
 1393009357,
 8151,
 -1,
 1393074134,
 8147,
 1393295359,
 1392780223,
 7985,
 1393360895,
 1393164410,
 -1,
 -44275,
 1393285141,
 7987,
 -44274,
 1393337037,
 7991,
 -1,
 1393401814,
 7989,
 1393578774,
 1392746473,
 -1,
 1393644309,
 1393540218,
 7984,
 1393754111,
 1393557626,
 -1,
 -44269,
 1393678357,
 7986,
 -44268,
 1393730253,
 7990,
 -1,
 1393795030,
 7988,
 -1,
 1393576411,
 8150,
 1394037529,
 1393547182,
 -1,
 -44264,
 1393994194,
 8144,
 -1,
 1394024905,
 8054,
 -44262,
 1394002421,
 943,
 -44261,
 1394188246,
 8055,
 -1,
 1394245691,
 8145,
 1394430755,
 1392621343,
 -1,
 1394496288,
 1394349428,
 -1,
 -44257,
 1394444511,
 1019,
 -1,
 1394509703,
 993,
 -44255,
 1394460643,
 987,
 -44254,
 1394632064,
 963,
 -1,
 1394695775,
 1016,
 1394889512,
 1394384873,
 -1,
 -44251,
 1394850780,
 968,
 -44250,
 1394893183,
 960,
 -44249,
 1394957449,
 966,
 -1,
 1395006750,
 887,
 1395217196,
 1394847210,
 961,
 1395326975,
 1395133475,
 -1,
 -44245,
 1395238603,
 8164,
 -1,
 1395275545,
 8165,
 1395479343,
 1395180244,
 -1,
 -44242,
 1395416158,
 952,
 -1,
 1395467663,
 964,
 1395675954,
 1395421320,
 -1,
 -44239,
 1395627917,
 991,
 -1,
 1395662885,
 954,
 1395872565,
 1395602976,
 -1,
 -44236,
 1395811480,
 989,
 -1,
 1395869224,
 948,
 -44234,
 1395845068,
 950,
 -44233,
 1396040588,
 958,
 -44232,
 1396084759,
 957,
 -44231,
 1396148145,
 956,
 -44230,
 1396208863,
 955,
 -44229,
 1396268126,
 881,
 -44228,
 1396331370,
 947,
 -44227,
 1396396148,
 962,
 -44226,
 1396453289,
 967,
 -1,
 1396517143,
 946,
 1396724546,
 1382788453,
 -1,
 -44223,
 1396670289,
 891,
 -1,
 1396718603,
 893,
 -1,
 1396653067,
 892,
 1397030911,
 1382731678,
 -1,
 -44219,
 1396944362,
 7528,
 -44218,
 1397007199,
 7529,
 -44217,
 1397052266,
 7527,
 -44216,
 1397108649,
 7530,
 -1,
 1397172503,
 7526,
 1397380097,
 1382624733,
 -1,
 1397445627,
 1397322584,
 -1,
 1397511162,
 1397378099,
 -1,
 1397576565,
 1397462214,
 -1,
 1397642088,
 1397507232,
 937,
 1397751807,
 1397558307,
 -1,
 1397773147,
 1397661673,
 -1,
 1397838682,
 1397734522,
 8040,
 1397948415,
 1397751930,
 -1,
 1397969750,
 1397858281,
 -1,
 1398035285,
 1397901787,
 8046,
 -1,
 1397948724,
 8110,
 -1,
 1397994612,
 8104,
 1398231896,
 1397938197,
 8042,
 -1,
 1398145332,
 8106,
 1398407167,
 1398185942,
 8044,
 -1,
 1398276404,
 8108,
 -1,
 1397798004,
 8188,
 1398559589,
 1397700377,
 8041,
 1398669311,
 1398472826,
 -1,
 1398690657,
 1398579177,
 -1,
 1398756192,
 1398622683,
 8047,
 -1,
 1398669620,
 8111,
 -1,
 1398715508,
 8105,
 1398952803,
 1398659093,
 8043,
 -1,
 1398866228,
 8107,
 1399128063,
 1398906838,
 8045,
 -1,
 1398997300,
 8109,
 -44186,
 1398528021,
 8186,
 -44185,
 1399179765,
 911,
 -1,
 1399234518,
 8187,
 1399455743,
 1397580555,
 927,
 1399521279,
 1399327779,
 -1,
 1399542638,
 1399432907,
 8008,
 1399652351,
 1399455866,
 -1,
 -44179,
 1399576597,
 8010,
 -1,
 1399627734,
 8012,
 1399804786,
 1399469849,
 8009,
 1399914495,
 1399718010,
 -1,
 -44175,
 1399838741,
 8011,
 -1,
 1399889878,
 8013,
 -44173,
 1399773205,
 8184,
 -44172,
 1400031733,
 908,
 -1,
 1400086486,
 8185,
 1400263582,
 1397506183,
 -1,
 1400329105,
 1400226581,
 919,
 1400438783,
 1400245283,
 -1,
 1400460164,
 1400348649,
 -1,
 1400525699,
 1400421498,
 7976,
 1400635391,
 1400438906,
 -1,
 1400656767,
 1400545257,
 -1,
 1400722302,
 1400588763,
 7982,
 -1,
 1400635700,
 8094,
 -1,
 1400681588,
 8088,
 1400918913,
 1400625173,
 7978,
 -1,
 1400832308,
 8090,
 1401094143,
 1400872918,
 7980,
 -1,
 1400963380,
 8092,
 -1,
 1400484980,
 8140,
 1401246606,
 1400387353,
 7977,
 1401356287,
 1401159802,
 -1,
 1401377674,
 1401266153,
 -1,
 1401443209,
 1401309659,
 7983,
 -1,
 1401356596,
 8095,
 -1,
 1401402484,
 8089,
 1401639820,
 1401346069,
 7979,
 -1,
 1401553204,
 8091,
 1401815039,
 1401593814,
 7981,
 -1,
 1401684276,
 8093,
 -44145,
 1401214997,
 8138,
 -44144,
 1401866741,
 905,
 -1,
 1401921494,
 8139,
 1402142719,
 1400284881,
 917,
 1402208255,
 1402014755,
 -1,
 1402229655,
 1402119883,
 7960,
 1402339327,
 1402142842,
 -1,
 -44138,
 1402263573,
 7962,
 -1,
 1402314710,
 7964,
 1402491803,
 1402156825,
 7961,
 1402601471,
 1402404986,
 -1,
 -44134,
 1402525717,
 7963,
 -1,
 1402576854,
 7965,
 -44132,
 1402460181,
 8136,
 -44131,
 1402718709,
 904,
 -1,
 1402773462,
 8137,
 1402950590,
 1400182132,
 -1,
 1403016125,
 1402896096,
 913,
 1403125759,
 1402932259,
 -1,
 1403147181,
 1403035625,
 -1,
 1403212716,
 1403108474,
 7944,
 1403322367,
 1403125882,
 -1,
 1403343784,
 1403232233,
 -1,
 1403409319,
 1403275739,
 7950,
 -1,
 1403322676,
 8078,
 -1,
 1403368564,
 8072,
 1403605930,
 1403312149,
 7946,
 -1,
 1403519284,
 8074,
 1403781119,
 1403559894,
 7948,
 -1,
 1403650356,
 8076,
 -1,
 1403171956,
 8124,
 1403933623,
 1403074329,
 7945,
 1404043263,
 1403846778,
 -1,
 1404064691,
 1403953129,
 -1,
 1404130226,
 1403996635,
 7951,
 -1,
 1404043572,
 8079,
 -1,
 1404089460,
 8073,
 1404326837,
 1404033045,
 7947,
 -1,
 1404240180,
 8075,
 1404502015,
 1404280790,
 7949,
 -1,
 1404371252,
 8077,
 1404588986,
 1403901870,
 -1,
 -44103,
 1404545490,
 8120,
 -1,
 1404576201,
 8122,
 -44101,
 1404553717,
 902,
 -44100,
 1404739542,
 8123,
 -1,
 1404796987,
 8121,
 -1,
 1402972973,
 882,
 1405047762,
 1402891189,
 921,
 1405157375,
 1404963875,
 -1,
 1405178823,
 1405040160,
 -1,
 1405244358,
 1405100991,
 7993,
 1405353983,
 1405157498,
 -1,
 -44092,
 1405278229,
 7995,
 -44091,
 1405330125,
 7999,
 -1,
 1405394902,
 7997,
 -1,
 1405182520,
 938,
 1405637580,
 1405134539,
 7992,
 1405747199,
 1405550714,
 -1,
 -44086,
 1405671445,
 7994,
 -44085,
 1405723341,
 7998,
 -1,
 1405788118,
 7996,
 1405965263,
 1405605806,
 -1,
 -44082,
 1405921746,
 8152,
 -1,
 1405952457,
 8154,
 -44080,
 1405929973,
 906,
 -44079,
 1406115798,
 8155,
 -1,
 1406173243,
 8153,
 1406358497,
 1405015273,
 933,
 1406468095,
 1406274595,
 -1,
 1406489563,
 1406350880,
 -1,
 1406555098,
 1406411711,
 8025,
 1406664703,
 1406468218,
 -1,
 -44072,
 1406588949,
 8027,
 -44071,
 1406640845,
 8031,
 -1,
 1406705622,
 8029,
 -1,
 1406493240,
 939,
 1406948318,
 1406457774,
 -1,
 -44067,
 1406904786,
 8168,
 -1,
 1406935497,
 8170,
 -44065,
 1406913013,
 910,
 -44064,
 1407098838,
 8171,
 -1,
 1407156283,
 8169,
 1407341542,
 1406312425,
 -1,
 -44061,
 1407302620,
 936,
 -44060,
 1407345023,
 928,
 -44059,
 1407409289,
 934,
 -1,
 1407458590,
 886,
 1407669226,
 1407301407,
 -1,
 -44056,
 1407608192,
 931,
 -44055,
 1407671903,
 1015,
 -1,
 1407720766,
 1018,
 1407931373,
 1407632084,
 -1,
 -44052,
 1407867998,
 920,
 -1,
 1407919503,
 932,
 1408127983,
 1407888874,
 929,
 -1,
 1408044235,
 8172,
 -44048,
 1408100300,
 918,
 -44047,
 1408230284,
 926,
 -44046,
 1408274455,
 925,
 -44045,
 1408337841,
 924,
 -44044,
 1408398559,
 923,
 -44043,
 1408463126,
 922,
 -44042,
 1408523358,
 880,
 -44041,
 1408586602,
 915,
 -44040,
 1408645043,
 916,
 -44039,
 1408708521,
 935,
 -1,
 1408772375,
 914,
 -1,
 1397477876,
 1017,
 1409045502,
 1397402981,
 -1,
 -44035,
 1408991057,
 1021,
 -1,
 1409039371,
 1023,
 -44033,
 1409009313,
 1012,
 -44032,
 1409183951,
 975,
 -1,
 1409235979,
 1022,
 1409438806,
 1397298548,
 -1,
 1409504338,
 1409365022,
 -1,
 1409569832,
 1409426798,
 -1,
 1409635351,
 1409503241,
 -1,
 1409700880,
 1409603828,
 65859,
 1409810431,
 1409613824,
 -1,
 1409831947,
 1409729236,
 -1,
 1409897482,
 1409769487,
 65862,
 -1,
 1409813172,
 65870,
 -1,
 1409817386,
 65864,
 1410094095,
 1409769751,
 65861,
 1410203647,
 1410007040,
 -1,
 -44018,
 1410122697,
 65868,
 -1,
 1410187347,
 65875,
 -1,
 1410056275,
 65871,
 1410465791,
 1409635006,
 65860,
 1410531327,
 1410334720,
 -1,
 1410552854,
 1410450132,
 -1,
 1410618389,
 1410490383,
 65863,
 -1,
 1410534015,
 65878,
 -1,
 1410538282,
 65866,
 -1,
 1410515027,
 65873,
 1410880546,
 1409586627,
 -1,
 1410946077,
 1410816139,
 -1,
 1411011612,
 1410912873,
 -1,
 -44005,
 1410974665,
 65867,
 -1,
 1411039315,
 65874,
 -1,
 1410931530,
 65857,
 1411273760,
 1410909990,
 -1,
 -44001,
 1411236809,
 65869,
 -1,
 1411301459,
 65876,
 -43999,
 1411229781,
 65856,
 -1,
 1411399613,
 65858,
 1411645439,
 1410843946,
 -1,
 1411666982,
 1411564244,
 -1,
 -43995,
 1411604525,
 65877,
 -1,
 1411652394,
 65865,
 -43993,
 1411629139,
 65872,
 -1,
 1411810840,
 65879,
 1411994689,
 1409532628,
 -1,
 1412060217,
 1411931215,
 -1,
 1412125744,
 1412022996,
 -1,
 1412191278,
 1412061323,
 -1,
 -43987,
 1412148313,
 65899,
 -1,
 1412197590,
 65893,
 -43985,
 1412161935,
 65884,
 -1,
 1412318961,
 65892,
 1412518964,
 1412076991,
 65881,
 1412628479,
 1412431872,
 -1,
 -43981,
 1412548381,
 65905,
 -1,
 1412587799,
 65898,
 1412825087,
 1412452361,
 -1,
 1412846648,
 1412749559,
 -1,
 -43977,
 1412810525,
 65906,
 -1,
 1412849943,
 65902,
 -1,
 1412780734,
 65897,
 1413152767,
 1412019191,
 -1,
 1413174335,
 1413042185,
 -1,
 1413239869,
 1413142772,
 65887,
 -1,
 1413153894,
 65901,
 1413414911,
 1413173950,
 65894,
 -1,
 1413283918,
 65895,
 1413545983,
 1413137702,
 65888,
 -1,
 1413414990,
 65889,
 1413633095,
 1411931178,
 -1,
 1413698630,
 1413580248,
 -1,
 -43964,
 1413661990,
 65890,
 -43963,
 1413715391,
 65882,
 -1,
 1413763097,
 65896,
 -1,
 1413617781,
 65880,
 1414026315,
 1413564599,
 -1,
 1414091850,
 1413991778,
 65883,
 -1,
 1414005630,
 65886,
 -1,
 1414025420,
 65900,
 1414288462,
 1413950686,
 -1,
 -43955,
 1414260383,
 65885,
 -1,
 1414275847,
 65903,
 -43953,
 1414250708,
 65908,
 -43952,
 1414433291,
 65904,
 -43951,
 1414497346,
 65891,
 -1,
 1414543260,
 65907,
 1414747221,
 1409460564,
 -1,
 -43948,
 1414710095,
 65926,
 -1,
 1414765669,
 65927,
 -1,
 1414696346,
 903,
 1415009405,
 1409378710,
 -1,
 1415074911,
 1414927292,
 119327,
 -43943,
 1414993217,
 119356,
 -43942,
 1415058701,
 119355,
 -43941,
 1415124166,
 119354,
 -43940,
 1415189513,
 119353,
 -43939,
 1415254860,
 119352,
 -43938,
 1415320231,
 119351,
 -1,
 1415385487,
 119350,
 1415599207,
 1414992399,
 119325,
 -43935,
 1415517505,
 119337,
 -43934,
 1415582989,
 119336,
 -43933,
 1415648454,
 119335,
 -43932,
 1415713724,
 119334,
 -43931,
 1415779148,
 119333,
 -43930,
 1415844519,
 119332,
 -1,
 1415909903,
 119331,
 1416123502,
 1415516839,
 119326,
 -43927,
 1416041793,
 119343,
 -43926,
 1416107206,
 119342,
 -43925,
 1416172673,
 119341,
 -43924,
 1416238089,
 119340,
 -43923,
 1416303548,
 119339,
 -1,
 1416368972,
 119338,
 1416582260,
 1416041481,
 119328,
 -43920,
 1416500156,
 119361,
 -43919,
 1416565580,
 119360,
 -43918,
 1416630951,
 119359,
 -43917,
 1416696335,
 119358,
 -1,
 1416761743,
 119357,
 1416975483,
 1416500044,
 -1,
 -43914,
 1416893761,
 119349,
 -43913,
 1416959245,
 119348,
 -43912,
 1417024710,
 119347,
 -43911,
 1417090177,
 119346,
 -43910,
 1417155239,
 119345,
 -1,
 1417220495,
 119344,
 -43908,
 1416893709,
 119330,
 -1,
 1417352390,
 119329,
 1417565341,
 1414977454,
 -1,
 1417630876,
 1417515583,
 -1,
 1417696394,
 1417548303,
 119296,
 -43903,
 1417614657,
 119314,
 -43902,
 1417680141,
 119313,
 -43901,
 1417745606,
 119312,
 -43900,
 1417811073,
 119311,
 -43899,
 1417876489,
 119310,
 -43898,
 1417941948,
 119309,
 -43897,
 1418007372,
 119308,
 -43896,
 1418072743,
 119307,
 -43895,
 1418138127,
 119306,
 -1,
 1418203535,
 119305,
 1418417296,
 1417614345,
 119300,
 -43892,
 1418335164,
 119324,
 -43891,
 1418400588,
 119323,
 -43890,
 1418465959,
 119322,
 -43889,
 1418531343,
 119321,
 -1,
 1418596751,
 119320,
 1418810518,
 1418334887,
 119297,
 -43886,
 1418728380,
 119319,
 -43885,
 1418793804,
 119318,
 -43884,
 1418859175,
 119317,
 -43883,
 1418924559,
 119316,
 -1,
 1418989967,
 119315,
 -43881,
 1418728769,
 119304,
 -43880,
 1419121933,
 119303,
 -43879,
 1419187398,
 119302,
 -43878,
 1419252865,
 119301,
 -43877,
 1419318204,
 119299,
 -1,
 1419383628,
 119298,
 -1,
 1417552329,
 8175,
 1419662514,
 1417507672,
 -1,
 1419728045,
 1419594803,
 -1,
 1419793577,
 1419687711,
 -1,
 1419859111,
 1419739444,
 -1,
 1419924644,
 1419812841,
 -1,
 -43869,
 1419885532,
 7466,
 -1,
 1419927935,
 7464,
 -43867,
 1419881962,
 7465,
 -43866,
 1420063967,
 7463,
 -1,
 1420120938,
 7462,
 -43864,
 1419823075,
 986,
 -1,
 1420238128,
 992,
 -43862,
 1419765320,
 1011,
 -43861,
 1420391084,
 990,
 -43860,
 1420442000,
 988,
 -1,
 1420501310,
 984,
 1420711088,
 1419694573,
 -1,
 -43857,
 1420672030,
 1010,
 -1,
 1420708054,
 1013,
 -43855,
 1420664678,
 885,
 -1,
 1420848703,
 65923,
 1421038783,
 1419589152,
 -1,
 1421104313,
 1420976705,
 -1,
 1421169848,
 1421024619,
 -1,
 -43850,
 1421137941,
 8173,
 -43849,
 1421189837,
 8129,
 -1,
 1421254614,
 8174,
 -1,
 1421134325,
 901,
 1421497534,
 1421026239,
 8190,
 1421606911,
 1421410426,
 -1,
 -43844,
 1421531157,
 8157,
 -43843,
 1421583053,
 8159,
 -1,
 1421647830,
 8158,
 -1,
 1421453766,
 65915,
 1421890763,
 1421001428,
 -1,
 1421956293,
 1421826187,
 -1,
 1422021828,
 1421913172,
 -1,
 -43837,
 1421977743,
 65912,
 -1,
 1422037542,
 65918,
 -1,
 1421953893,
 977,
 1422283976,
 1421926802,
 -1,
 -43833,
 1422247657,
 65911,
 -1,
 1422299686,
 65917,
 -43831,
 1422243576,
 65929,
 -43830,
 1422431855,
 900,
 -1,
 1422465823,
 65914,
 1422677205,
 1421844457,
 -1,
 1422742737,
 1422638202,
 8127,
 1422852095,
 1422655610,
 -1,
 -43825,
 1422776341,
 8141,
 -43824,
 1422828237,
 8143,
 -1,
 1422893014,
 8142,
 -43822,
 1422701684,
 8126,
 -43821,
 1423008197,
 982,
 -43820,
 1423072410,
 981,
 -1,
 1423133147,
 8128,
 1423332571,
 1422627215,
 -1,
 1423398104,
 1423280930,
 65909,
 -1,
 1423310926,
 65910,
 -43815,
 1423369103,
 8189,
 -43814,
 1423495891,
 65924,
 -1,
 1423518397,
 65916,
 1423725793,
 1423274120,
 -1,
 1423791327,
 1423644020,
 -1,
 -43810,
 1423746437,
 1008,
 -1,
 1423794629,
 983,
 -43808,
 1423762578,
 65922,
 -1,
 1423939968,
 8125,
 1424119013,
 1423693041,
 -1,
 -43805,
 1424055984,
 978,
 -43804,
 1424111784,
 980,
 -1,
 1424168884,
 979,
 1424381162,
 1424075092,
 -1,
 1424446697,
 1424318050,
 -1,
 -43800,
 1424416977,
 1020,
 -1,
 1424474716,
 1009,
 -1,
 1424379145,
 1014,
 1424708845,
 1424352238,
 -1,
 -43796,
 1424663731,
 890,
 -1,
 1424703814,
 65913,
 1424905456,
 1424654309,
 -1,
 -43793,
 1424873137,
 119365,
 -1,
 1424903181,
 65921,
 1425102067,
 1424838230,
 -1,
 -43790,
 1425054781,
 65919,
 -1,
 1425108623,
 65920,
 -43788,
 1425074102,
 65930,
 -43787,
 1425269619,
 65925,
 -43786,
 1425320126,
 894,
 -43785,
 1425379443,
 884,
 -43784,
 1425430164,
 65928,
 -1,
 1425484060,
 976,
 1425735679,
 1382556847,
 -1,
 1425757449,
 1425641871,
 -1,
 1425822982,
 1425713494,
 -1,
 1425888513,
 1425784172,
 10878,
 1425997823,
 1425804545,
 -1,
 1426019584,
 1425872501,
 10882,
 -1,
 1425933673,
 10884,
 -1,
 1425959311,
 10880,
 1426216196,
 1425819894,
 -1,
 -43773,
 1426157158,
 8819,
 -1,
 1426201125,
 8805,
 -43771,
 1426159951,
 8823,
 -1,
 1426333738,
 10886,
 1426587647,
 1425791385,
 -1,
 -43768,
 1426486626,
 10916,
 -1,
 1426523034,
 8807,
 1426740502,
 1425675636,
 -1,
 1426806035,
 1426664270,
 -1,
 1426871568,
 1426765599,
 -1,
 1426937103,
 1426810587,
 -1,
 -43762,
 1426888708,
 10894,
 -1,
 1426921166,
 10896,
 -1,
 1426879793,
 10900,
 -43759,
 1426829471,
 10616,
 -43758,
 1427143001,
 10898,
 -1,
 1427193329,
 10892,
 1427439615,
 1426754144,
 -1,
 -43755,
 1427356902,
 10888,
 -1,
 1427410507,
 10890,
 1427592474,
 1426710386,
 -1,
 -43752,
 1427548364,
 10876,
 -43751,
 1427585832,
 8919,
 -1,
 1427648593,
 10874,
 1427854623,
 1427514998,
 -1,
 1427920158,
 1427822353,
 -1,
 -43747,
 1427861094,
 8935,
 -1,
 1427905061,
 8809,
 -1,
 1427851941,
 10917,
 1428182305,
 1427779990,
 10919,
 -1,
 1428095009,
 10921,
 -43742,
 1428143147,
 62,
 -1,
 1428244790,
 8923,
 -1,
 1382491625,
 96,
 1428510208,
 1382469194,
 -1,
 1428575638,
 1428451124,
 -1,
 1428641126,
 1428519386,
 -1,
 1428706606,
 1428608942,
 -1,
 1428772141,
 1428656725,
 -1,
 1428837675,
 1428728148,
 2699,
 -1,
 1428793684,
 2784,
 1429012479,
 1428779864,
 2700,
 -1,
 1428910936,
 2785,
 -1,
 1428690292,
 2741,
 1429165364,
 1428669140,
 -1,
 1429230898,
 1429127892,
 -1,
 -43727,
 1429166249,
 2720,
 -1,
 1429214580,
 2719,
 -43725,
 1429166249,
 2725,
 -1,
 1429345652,
 2724,
 1429558585,
 1429113055,
 -1,
 -43722,
 1429529642,
 2718,
 -43721,
 1429571899,
 2723,
 -43720,
 1429623556,
 2713,
 -1,
 1429673332,
 2728,
 1429886271,
 1429485088,
 -1,
 1429951805,
 1429812768,
 -1,
 -43716,
 1429887145,
 2722,
 -1,
 1429935476,
 2721,
 -43714,
 1429887145,
 2727,
 -1,
 1430066548,
 2726,
 1430279491,
 1429804404,
 2693,
 -43711,
 1430244938,
 2708,
 -43710,
 1430282623,
 2704,
 -1,
 1430328692,
 2694,
 1430541639,
 1430239007,
 -1,
 -43707,
 1430501273,
 2743,
 -43706,
 1430542505,
 2742,
 -1,
 1430590836,
 2744,
 1430803785,
 1430507082,
 2697,
 -1,
 1430769226,
 2698,
 1430934860,
 1430757353,
 -1,
 -43701,
 1430870185,
 2731,
 -1,
 1430918516,
 2730,
 1431131471,
 1430877016,
 -1,
 -43698,
 1431073709,
 2739,
 -1,
 1431115124,
 2738,
 1431328082,
 1431072904,
 -1,
 -43695,
 1431263401,
 2710,
 -1,
 1431311732,
 2709,
 1431524693,
 1431269161,
 -1,
 -43692,
 1431460009,
 2717,
 -1,
 1431508340,
 2716,
 1431721303,
 1431462271,
 2695,
 -1,
 1431658879,
 2696,
 1431852378,
 1431655139,
 -1,
 -43687,
 1431787689,
 2712,
 -1,
 1431836020,
 2711,
 1432048989,
 1431776478,
 -1,
 -43684,
 1431984297,
 2715,
 -1,
 1432032628,
 2714,
 1432245600,
 1431971446,
 -1,
 -43681,
 1432180905,
 2733,
 -1,
 1432229236,
 2732,
 -43679,
 1432216618,
 2735,
 -43678,
 1432398255,
 2736,
 -43677,
 1432457615,
 2707,
 -43676,
 1432518706,
 2734,
 -43675,
 1432574121,
 2745,
 -1,
 1432633479,
 2703,
 1432835453,
 1428610191,
 -1,
 1432900986,
 1432796208,
 -1,
 1432966509,
 1432869903,
 -1,
 1433032043,
 1432922452,
 2755,
 -1,
 1432987988,
 2756,
 1433206783,
 1432974168,
 2786,
 -1,
 1433105240,
 2787,
 1433294193,
 1432884596,
 -1,
 -43665,
 1433259594,
 2764,
 -43664,
 1433297279,
 2760,
 -1,
 1433343348,
 2750,
 1433556339,
 1433259594,
 2753,
 -1,
 1433521738,
 2754,
 1433687413,
 1433493887,
 2751,
 -1,
 1433624959,
 2752,
 1433818488,
 1433611679,
 -1,
 -43657,
 1433768335,
 2761,
 -1,
 1433813127,
 2757,
 -43655,
 1433768335,
 2763,
 -1,
 1433944199,
 2759,
 1434189823,
 1432825247,
 -1,
 -43652,
 1434096015,
 2705,
 -1,
 1434140807,
 2701,
 1434342795,
 1432762776,
 -1,
 1434408321,
 1434305236,
 -1,
 -43648,
 1434378639,
 2792,
 -1,
 1434411094,
 2793,
 1434604932,
 1434367775,
 -1,
 -43645,
 1434545902,
 2796,
 -1,
 1434602626,
 2797,
 1434801543,
 1434537558,
 -1,
 -43642,
 1434754032,
 2794,
 -1,
 1434807927,
 2795,
 -43640,
 1434773397,
 2790,
 -43639,
 1434949055,
 2791,
 -43638,
 1435012284,
 2799,
 -1,
 1435059511,
 2798,
 1435260308,
 1434303536,
 -1,
 1435325839,
 1435229029,
 -1,
 -43634,
 1435285541,
 2691,
 -1,
 1435347597,
 2765,
 1435522450,
 1435243892,
 -1,
 -43631,
 1435490245,
 2749,
 -1,
 1435537605,
 2690,
 -43629,
 1435471925,
 2748,
 -1,
 1435643316,
 2689,
 -43627,
 1435219660,
 2801,
 -1,
 1435800774,
 2768,
 1435981311,
 1428534161,
 -1,
 1436046808,
 1435924954,
 -1,
 1436112286,
 1436009172,
 -1,
 1436177820,
 1436074708,
 -1,
 -43621,
 1436113065,
 2592,
 -1,
 1436161396,
 2591,
 -43619,
 1436113065,
 2597,
 -1,
 1436292468,
 2596,
 1436505507,
 1436059871,
 -1,
 -43616,
 1436476458,
 2590,
 -43615,
 1436518715,
 2595,
 -43614,
 1436570372,
 2585,
 -1,
 1436620148,
 2600,
 1436833193,
 1436431904,
 -1,
 1436898727,
 1436759584,
 -1,
 -43610,
 1436833961,
 2594,
 -1,
 1436882292,
 2593,
 -43608,
 1436833961,
 2599,
 -1,
 1437013364,
 2598,
 1437226413,
 1436751220,
 2565,
 -43605,
 1437191754,
 2580,
 -43604,
 1437229439,
 2576,
 -1,
 1437275508,
 2566,
 1437488562,
 1437167752,
 -1,
 1437554097,
 1437423755,
 -1,
 -43600,
 1437489321,
 2649,
 -1,
 1437537652,
 2582,
 -1,
 1437472116,
 2581,
 1437816247,
 1437422307,
 -1,
 1437881782,
 1437751435,
 -1,
 -43595,
 1437817001,
 2650,
 -1,
 1437865332,
 2584,
 -1,
 1437799796,
 2583,
 1438143929,
 1437781578,
 2569,
 -1,
 1438109258,
 2570,
 1438275004,
 1438103327,
 -1,
 -43589,
 1438210217,
 2614,
 -1,
 1438258548,
 2616,
 1438471615,
 1438230868,
 -1,
 -43586,
 1438427567,
 2652,
 -1,
 1438455156,
 2608,
 1438668226,
 1438425065,
 -1,
 -43583,
 1438603433,
 2603,
 -1,
 1438651764,
 2602,
 1438864837,
 1438610264,
 -1,
 -43580,
 1438806957,
 2611,
 -1,
 1438848372,
 2610,
 1439061448,
 1438805801,
 -1,
 -43577,
 1438996649,
 2589,
 -1,
 1439044980,
 2588,
 1439258058,
 1438998911,
 2567,
 -1,
 1439195519,
 2568,
 1439389133,
 1439182046,
 -1,
 -43572,
 1439324329,
 2587,
 -1,
 1439372660,
 2586,
 1439585744,
 1439311478,
 -1,
 -43569,
 1439520937,
 2605,
 -1,
 1439569268,
 2604,
 -43567,
 1439557424,
 2651,
 -43566,
 1439753258,
 2607,
 -43565,
 1439815612,
 2613,
 -43564,
 1439864452,
 2579,
 -43563,
 1439924274,
 2606,
 -43562,
 1439979689,
 2617,
 -43561,
 1440042687,
 2654,
 -1,
 1440105255,
 2575,
 1440306662,
 1435974040,
 -1,
 1440372188,
 1440269012,
 -1,
 -43557,
 1440342415,
 2664,
 -1,
 1440374870,
 2665,
 1440568799,
 1440331551,
 -1,
 -43554,
 1440509678,
 2668,
 -1,
 1440566402,
 2669,
 1440765410,
 1440501334,
 -1,
 -43551,
 1440717808,
 2666,
 -1,
 1440771703,
 2667,
 -43549,
 1440737173,
 2662,
 -43548,
 1440912831,
 2663,
 -43547,
 1440976060,
 2671,
 -1,
 1441023287,
 2670,
 1441224177,
 1440275638,
 -1,
 1441289707,
 1441142132,
 -1,
 -43543,
 1441254986,
 2636,
 -43542,
 1441292671,
 2632,
 -1,
 1441338740,
 2622,
 1441551853,
 1441254986,
 2625,
 -1,
 1441517130,
 2626,
 1441682927,
 1441489279,
 2623,
 -1,
 1441620351,
 2624,
 -43536,
 1441633924,
 2635,
 -1,
 1441743655,
 2631,
 1441945082,
 1441184816,
 -1,
 1442010613,
 1441913701,
 -1,
 -43532,
 1441970213,
 2563,
 -1,
 1442032269,
 2637,
 -43530,
 1441981540,
 2677,
 -43529,
 1442172925,
 2641,
 -43528,
 1442222133,
 2620,
 -43527,
 1442261364,
 2562,
 -1,
 1442322401,
 2561,
 -43525,
 1441912231,
 2675,
 -43524,
 1442498784,
 2672,
 -43523,
 1442540691,
 2674,
 -43522,
 1442596260,
 2676,
 -1,
 1442650108,
 2673,
 -1,
 1435902214,
 8370,
 1442928302,
 1428439175,
 -1,
 1442993831,
 1442877839,
 -1,
 1443059362,
 1442950606,
 -1,
 1443124797,
 1443002842,
 -1,
 1443190283,
 1443059851,
 -1,
 1443255816,
 1443108212,
 -1,
 -43513,
 1443211604,
 4340,
 -1,
 1443250311,
 4336,
 -43511,
 1443205845,
 4341,
 -43510,
 1443390512,
 4338,
 -1,
 1443446919,
 4337,
 1443649041,
 1443114206,
 -1,
 1443714575,
 1443584139,
 -1,
 -43506,
 1443653424,
 4329,
 -1,
 1443700828,
 4333,
 -43504,
 1443653085,
 4332,
 -1,
 1443831102,
 4330,
 1444042262,
 1443611348,
 -1,
 1444107797,
 1443960180,
 -1,
 -43500,
 1444063572,
 4322,
 -1,
 1444120799,
 4311,
 -1,
 1444075049,
 4345,
 1444369945,
 1444013854,
 -1,
 -43496,
 1444305528,
 4319,
 -1,
 1444366065,
 4310,
 1444566556,
 1444329247,
 -1,
 -43493,
 1444502915,
 4328,
 -1,
 1444551998,
 4321,
 1444763167,
 1444519913,
 -1,
 -43490,
 1444698744,
 4324,
 -1,
 1444749404,
 4318,
 1444959778,
 1444704392,
 -1,
 -43487,
 1444895352,
 4325,
 -1,
 1444945214,
 4313,
 1445156389,
 1444900649,
 -1,
 -43484,
 1445094877,
 4331,
 -1,
 1445157401,
 4335,
 1445353000,
 1445090019,
 -1,
 -43481,
 1445288473,
 4326,
 -1,
 1445338430,
 4306,
 1445549611,
 1445281927,
 -1,
 -43478,
 1445497055,
 4308,
 -1,
 1445558914,
 4344,
 1445746222,
 1445467508,
 -1,
 -43475,
 1445693663,
 4304,
 -1,
 1445750576,
 4346,
 -43473,
 1445717523,
 4343,
 -43472,
 1445913401,
 4334,
 -43471,
 1445977682,
 4339,
 -43470,
 1446042530,
 4309,
 -43469,
 1446105555,
 4323,
 -43468,
 1446160893,
 4320,
 -43467,
 1446225808,
 4327,
 -43466,
 1446286637,
 4317,
 -43465,
 1446349231,
 4316,
 -43464,
 1446412790,
 4315,
 -43463,
 1446475134,
 4314,
 -43462,
 1446537008,
 4312,
 -43461,
 1446596617,
 4342,
 -43460,
 1446656792,
 4307,
 -1,
 1446717234,
 4305,
 1446925935,
 1443085834,
 -1,
 1446991429,
 1446860939,
 -1,
 1447056962,
 1446909300,
 -1,
 -43455,
 1447012692,
 11556,
 -1,
 1447051399,
 11552,
 -43453,
 1447006933,
 11557,
 -43452,
 1447191600,
 11554,
 -1,
 1447248007,
 11553,
 1447450187,
 1446915294,
 -1,
 1447515721,
 1447385227,
 -1,
 -43448,
 1447454512,
 11545,
 -1,
 1447501916,
 11549,
 -43446,
 1447454173,
 11548,
 -1,
 1447632190,
 11546,
 1447843406,
 1447421726,
 -1,
 -43443,
 1447778936,
 11535,
 -1,
 1447839473,
 11526,
 1448040017,
 1447805717,
 -1,
 -43440,
 1447995732,
 11538,
 -1,
 1448052959,
 11527,
 1448236628,
 1447999263,
 -1,
 -43437,
 1448172931,
 11544,
 -1,
 1448222014,
 11537,
 1448433239,
 1448189929,
 -1,
 -43434,
 1448368760,
 11540,
 -1,
 1448419420,
 11534,
 1448629850,
 1448374408,
 -1,
 -43431,
 1448565368,
 11541,
 -1,
 1448615230,
 11529,
 1448826461,
 1448570665,
 -1,
 -43428,
 1448764893,
 11547,
 -1,
 1448827417,
 11551,
 1449023072,
 1448760035,
 -1,
 -43425,
 1448958489,
 11542,
 -1,
 1449008446,
 11522,
 -43423,
 1448993593,
 11550,
 -43422,
 1449188946,
 11555,
 -43421,
 1449253794,
 11525,
 -43420,
 1449316819,
 11539,
 -43419,
 1449372157,
 11536,
 -43418,
 1449437072,
 11543,
 -43417,
 1449497901,
 11533,
 -43416,
 1449560495,
 11532,
 -43415,
 1449624054,
 11531,
 -43414,
 1449686398,
 11530,
 -43413,
 1449748272,
 11528,
 -43412,
 1449805553,
 11524,
 -43411,
 1449868056,
 11523,
 -43410,
 1449928498,
 11521,
 -1,
 1449991486,
 11520,
 1450202785,
 1446850052,
 -1,
 1450268279,
 1450137739,
 -1,
 1450333812,
 1450186100,
 -1,
 -43405,
 1450289492,
 4292,
 -1,
 1450328199,
 4288,
 -43403,
 1450283733,
 4293,
 -43402,
 1450468400,
 4290,
 -1,
 1450524807,
 4289,
 1450727037,
 1450192094,
 -1,
 1450792571,
 1450662027,
 -1,
 -43398,
 1450731312,
 4281,
 -1,
 1450778716,
 4285,
 -43396,
 1450730973,
 4284,
 -1,
 1450908990,
 4282,
 1451120256,
 1450698526,
 -1,
 -43393,
 1451055736,
 4271,
 -1,
 1451116273,
 4262,
 1451316867,
 1451082517,
 -1,
 -43390,
 1451272532,
 4274,
 -1,
 1451329759,
 4263,
 1451513478,
 1451276063,
 -1,
 -43387,
 1451449731,
 4280,
 -1,
 1451498814,
 4273,
 1451710089,
 1451466729,
 -1,
 -43384,
 1451645560,
 4276,
 -1,
 1451696220,
 4270,
 1451906700,
 1451651208,
 -1,
 -43381,
 1451842168,
 4277,
 -1,
 1451892030,
 4265,
 1452103311,
 1451847465,
 -1,
 -43378,
 1452041693,
 4283,
 -1,
 1452104217,
 4287,
 1452299922,
 1452036835,
 -1,
 -43375,
 1452235289,
 4278,
 -1,
 1452285246,
 4258,
 -43373,
 1452270393,
 4286,
 -43372,
 1452465746,
 4291,
 -43371,
 1452530594,
 4261,
 -43370,
 1452593619,
 4275,
 -43369,
 1452648957,
 4272,
 -43368,
 1452713872,
 4279,
 -43367,
 1452774701,
 4269,
 -43366,
 1452837295,
 4268,
 -43365,
 1452900854,
 4267,
 -43364,
 1452963198,
 4266,
 -43363,
 1453025072,
 4264,
 -43362,
 1453082353,
 4260,
 -43361,
 1453144856,
 4259,
 -43360,
 1453205298,
 4257,
 -1,
 1453268286,
 4256,
 -1,
 1450156282,
 4347,
 1453588479,
 1443005549,
 -1,
 1453610662,
 1453464600,
 -1,
 -43355,
 1453551206,
 8782,
 -1,
 1453595173,
 8785,
 -1,
 1453525366,
 8762,
 1453872811,
 1442914396,
 9881,
 1453981695,
 1453788189,
 -1,
 -43350,
 1453890741,
 9965,
 -1,
 1453917233,
 9966,
 -43348,
 1453835036,
 12307,
 -43347,
 1454093160,
 8368,
 -1,
 1454146963,
 9802,
 1454331695,
 1442870104,
 -1,
 1454397230,
 1454250209,
 -1,
 1454462703,
 1454358026,
 -1,
 1454528186,
 1454421791,
 -1,
 1454593718,
 1454463115,
 -1,
 1454659253,
 1454555925,
 11339,
 -1,
 1454613391,
 11356,
 -1,
 1454577012,
 11342,
 1454855864,
 1454539239,
 11348,
 -1,
 1454771820,
 11349,
 -43335,
 1454810008,
 11346,
 -1,
 1454931482,
 11332,
 1455118019,
 1454498798,
 -1,
 1455183552,
 1455046791,
 -1,
 1455249087,
 1455139156,
 -1,
 -43330,
 1455214154,
 11343,
 -1,
 1455251839,
 11344,
 -1,
 1455210868,
 11317,
 -43327,
 1455148618,
 11347,
 -43326,
 1455460751,
 11350,
 -1,
 1455498514,
 11345,
 1455707851,
 1455055231,
 11323,
 1455773383,
 1455679441,
 -1,
 -43322,
 1455713865,
 11355,
 -1,
 1455767687,
 11321,
 1455969994,
 1455725194,
 -1,
 -43319,
 1455930970,
 11351,
 -1,
 1455958360,
 11353,
 -1,
 1455918369,
 11322,
 1456232143,
 1455669972,
 -1,
 -43315,
 1456200930,
 11333,
 -43314,
 1456258012,
 11340,
 -1,
 1456321582,
 11357,
 1456494291,
 1456158240,
 -1,
 -43311,
 1456465784,
 11319,
 -43310,
 1456509498,
 11316,
 -1,
 1456566242,
 11324,
 1456756438,
 1456465694,
 -1,
 -43307,
 1456692767,
 11318,
 -1,
 1456752325,
 11320,
 1456953049,
 1456709609,
 -1,
 -43304,
 1456903162,
 11330,
 -1,
 1456947335,
 11338,
 1457149660,
 1456902543,
 -1,
 -43301,
 1457114249,
 11337,
 -1,
 1457164311,
 11329,
 1457346271,
 1457091416,
 -1,
 -43298,
 1457287282,
 11326,
 -1,
 1457333556,
 11358,
 1457542882,
 1457278550,
 -1,
 -43295,
 1457500948,
 11335,
 -1,
 1457548678,
 11354,
 1457739493,
 1457464950,
 -1,
 -43292,
 1457705134,
 11313,
 -1,
 1457742989,
 11352,
 -43290,
 1457707351,
 11314,
 -43289,
 1457901733,
 11334,
 -43288,
 1457959694,
 11331,
 -43287,
 1458014661,
 11328,
 -43286,
 1458079939,
 11327,
 -43285,
 1458139358,
 11325,
 -43284,
 1458199619,
 11336,
 -43283,
 1458263498,
 11315,
 -43282,
 1458319335,
 11341,
 -1,
 1458382450,
 11312,
 1458634751,
 1454386692,
 -1,
 1458657017,
 1458550559,
 -1,
 1458722549,
 1458591883,
 -1,
 1458788084,
 1458684693,
 11291,
 -1,
 1458742159,
 11308,
 -1,
 1458705780,
 11294,
 1458984695,
 1458668007,
 11300,
 -1,
 1458900588,
 11301,
 -43272,
 1458938776,
 11298,
 -1,
 1459060250,
 11284,
 1459246850,
 1458627566,
 -1,
 1459312383,
 1459175559,
 -1,
 1459377918,
 1459267924,
 -1,
 -43267,
 1459342922,
 11295,
 -1,
 1459380607,
 11296,
 -1,
 1459339636,
 11269,
 -43264,
 1459277386,
 11299,
 -43263,
 1459589519,
 11302,
 -1,
 1459627282,
 11297,
 1459836682,
 1459183999,
 11275,
 1459902214,
 1459808209,
 -1,
 -43259,
 1459842633,
 11307,
 -1,
 1459896455,
 11273,
 1460098825,
 1459853962,
 -1,
 -43256,
 1460059738,
 11303,
 -1,
 1460087128,
 11305,
 -1,
 1460047137,
 11274,
 1460360974,
 1459798740,
 -1,
 -43252,
 1460329698,
 11285,
 -43251,
 1460386780,
 11292,
 -1,
 1460450350,
 11309,
 1460623122,
 1460287008,
 -1,
 -43248,
 1460594552,
 11271,
 -43247,
 1460638266,
 11268,
 -1,
 1460695010,
 11276,
 1460885269,
 1460594462,
 -1,
 -43244,
 1460821535,
 11270,
 -1,
 1460881093,
 11272,
 1461081880,
 1460838377,
 -1,
 -43241,
 1461031930,
 11282,
 -1,
 1461076103,
 11290,
 1461278491,
 1461031311,
 -1,
 -43238,
 1461243017,
 11289,
 -1,
 1461293079,
 11281,
 1461475102,
 1461220184,
 -1,
 -43235,
 1461416050,
 11278,
 -1,
 1461462324,
 11310,
 1461671713,
 1461407318,
 -1,
 -43232,
 1461629716,
 11287,
 -1,
 1461677446,
 11306,
 1461868324,
 1461593718,
 -1,
 -43229,
 1461833902,
 11265,
 -1,
 1461871757,
 11304,
 -43227,
 1461836119,
 11266,
 -43226,
 1462030501,
 11286,
 -43225,
 1462088462,
 11283,
 -43224,
 1462143429,
 11280,
 -43223,
 1462208707,
 11279,
 -43222,
 1462268126,
 11277,
 -43221,
 1462328387,
 11288,
 -43220,
 1462392266,
 11267,
 -43219,
 1462448103,
 11293,
 -1,
 1462511218,
 11264,
 -1,
 1454327080,
 10726,
 1462785873,
 1454283464,
 -1,
 1462851381,
 1462733023,
 -1,
 1462916916,
 1462790242,
 -1,
 -43213,
 1462881833,
 66369,
 -1,
 1462895718,
 66378,
 -1,
 1462838728,
 66365,
 1463179064,
 1462813396,
 -1,
 -43209,
 1463115284,
 66360,
 -1,
 1463174552,
 66372,
 1463375675,
 1463116159,
 -1,
 -43206,
 1463341200,
 66358,
 -1,
 1463375017,
 66375,
 1463572286,
 1463310475,
 -1,
 -43203,
 1463541067,
 66376,
 -1,
 1463556311,
 66359,
 1463768897,
 1463489908,
 -1,
 -43200,
 1463707029,
 66356,
 -1,
 1463771362,
 66352,
 -43198,
 1463738214,
 66373,
 -43197,
 1463932508,
 66367,
 -43196,
 1463990331,
 66371,
 -43195,
 1464052271,
 66370,
 -43194,
 1464117115,
 66357,
 -43193,
 1464180886,
 66368,
 -43192,
 1464244924,
 66377,
 -43191,
 1464304162,
 66364,
 -43190,
 1464366225,
 66363,
 -43189,
 1464431408,
 66362,
 -43188,
 1464496071,
 66366,
 -43187,
 1464554876,
 66354,
 -43186,
 1464618726,
 66374,
 -43185,
 1464681870,
 66361,
 -43184,
 1464743618,
 66355,
 -1,
 1464805117,
 66353,
 -1,
 1462724255,
 8503,
 1465080661,
 1382379656,
 -1,
 1465145885,
 1464997236,
 -1,
 1465211130,
 1465092319,
 -1,
 1465276551,
 1465145421,
 -1,
 1465341835,
 1465235231,
 -1,
 1465407328,
 1465303764,
 -1,
 1465472860,
 1465356687,
 -1,
 1465538395,
 1465425897,
 12108,
 -1,
 1465492405,
 12169,
 -1,
 1465486083,
 12143,
 1465735007,
 1465401479,
 -1,
 -43170,
 1465688041,
 12091,
 -1,
 1465719911,
 12115,
 -1,
 1465654631,
 12148,
 1465997159,
 1465360361,
 -1,
 1466062692,
 1465925767,
 -1,
 -43165,
 1465991733,
 12180,
 -1,
 1466048604,
 12141,
 -43163,
 1466021134,
 12076,
 -43162,
 1466209961,
 12052,
 -1,
 1466264739,
 12144,
 1466455920,
 1465931915,
 -1,
 1466521453,
 1466405263,
 -1,
 1466586988,
 1466480160,
 -1,
 -43157,
 1466523728,
 12083,
 -1,
 1466571074,
 12203,
 -1,
 1466538570,
 12087,
 1466892287,
 1466450055,
 -1,
 -43153,
 1466792962,
 12185,
 -1,
 1466845331,
 12154,
 1467045749,
 1466384519,
 -1,
 -43150,
 1466989110,
 12163,
 -43149,
 1467039879,
 12178,
 -43148,
 1467101806,
 12036,
 -1,
 1467161076,
 12057,
 1467373434,
 1466987352,
 -1,
 1467438969,
 1467290996,
 -1,
 -43144,
 1467406580,
 12202,
 -1,
 1467464211,
 12035,
 -1,
 1467376379,
 12122,
 1467701118,
 1467290996,
 -1,
 -43140,
 1467671534,
 12104,
 -43139,
 1467711205,
 12228,
 -1,
 1467757534,
 12223,
 1467963265,
 1467638143,
 -1,
 -43136,
 1467907067,
 12151,
 -1,
 1467953504,
 12135,
 1468159876,
 1467886814,
 -1,
 -43133,
 1468117653,
 12098,
 -1,
 1468161667,
 12064,
 -43131,
 1468128858,
 12130,
 -43130,
 1468322259,
 12103,
 -43129,
 1468377119,
 12101,
 -43128,
 1468439430,
 12211,
 -43127,
 1468501687,
 12089,
 -43126,
 1468563737,
 12073,
 -1,
 1468625494,
 12138,
 1468815267,
 1465267744,
 -1,
 1468880790,
 1468764559,
 -1,
 1468946321,
 1468842708,
 12034,
 1469054975,
 1468908750,
 -1,
 -43120,
 1468974440,
 12136,
 -1,
 1469002101,
 12084,
 -43118,
 1468916082,
 12044,
 -43117,
 1469173655,
 12120,
 -43116,
 1469224950,
 12094,
 -43115,
 1469272803,
 12125,
 -1,
 1469318674,
 12111,
 1469536156,
 1468817791,
 -1,
 1469601690,
 1469495071,
 -1,
 -43111,
 1469565099,
 12196,
 -1,
 1469601931,
 12139,
 -43109,
 1469569958,
 12056,
 -1,
 1469752726,
 12099,
 1469929376,
 1469491540,
 -1,
 -43106,
 1469899758,
 12082,
 -43105,
 1469960565,
 12238,
 -1,
 1469978859,
 12243,
 1470234623,
 1469857927,
 -1,
 -43102,
 1470122335,
 12229,
 -1,
 1470178490,
 12109,
 1470388154,
 1468737142,
 -1,
 1470453674,
 1470337423,
 -1,
 -43098,
 1470422280,
 12088,
 -43097,
 1470466819,
 12219,
 -43096,
 1470529256,
 12134,
 -43095,
 1470578804,
 12189,
 -1,
 1470637164,
 12168,
 1470846894,
 1470409044,
 -1,
 -43092,
 1470813855,
 12160,
 -43091,
 1470852456,
 12090,
 -1,
 1470897499,
 12096,
 1471109042,
 1470788440,
 -1,
 -43088,
 1471074318,
 12205,
 -43087,
 1471125146,
 12174,
 -1,
 1471158123,
 12234,
 1471371190,
 1471046015,
 -1,
 -43084,
 1471335509,
 12191,
 -43083,
 1471392590,
 12227,
 -1,
 1471435491,
 12068,
 1471633337,
 1471288692,
 -1,
 -43080,
 1471578884,
 12149,
 -1,
 1471625328,
 12184,
 -1,
 1471562032,
 12182,
 1471895503,
 1470350036,
 -1,
 1471961023,
 1471850836,
 -1,
 -43075,
 1471900641,
 12237,
 -43074,
 1471955751,
 12106,
 -1,
 1472010091,
 12145,
 1472223171,
 1471878516,
 -1,
 -43071,
 1472171393,
 12209,
 -43070,
 1472232450,
 12220,
 -1,
 1472277123,
 12047,
 1472485317,
 1472192911,
 12038,
 -1,
 1472398394,
 12086,
 1472616392,
 1472451967,
 -1,
 -43065,
 1472579866,
 12244,
 -1,
 1472603954,
 12081,
 1472813003,
 1472565647,
 -1,
 -43062,
 1472764600,
 12242,
 -1,
 1472826478,
 12166,
 1473009614,
 1472749951,
 -1,
 -43059,
 1472951890,
 12129,
 -1,
 1473008760,
 12172,
 -1,
 1472939761,
 12055,
 1473271778,
 1471827542,
 -1,
 1473337301,
 1473208703,
 -1,
 -43054,
 1473296915,
 12226,
 -43053,
 1473358724,
 12117,
 -43052,
 1473402078,
 12222,
 -1,
 1473463775,
 12133,
 1473664985,
 1473254772,
 -1,
 -43049,
 1473627796,
 12119,
 -43048,
 1473678263,
 12123,
 -1,
 1473719944,
 12207,
 1473927132,
 1473620308,
 -1,
 -43045,
 1473876773,
 12236,
 -1,
 1473911024,
 12217,
 1474123743,
 1473868632,
 -1,
 -43042,
 1474094062,
 12214,
 -1,
 1474156324,
 12245,
 -43040,
 1474090367,
 12113,
 -43039,
 1474270928,
 12188,
 -1,
 1474314669,
 12155,
 1474516981,
 1473195230,
 -1,
 1474582505,
 1474466191,
 -1,
 -43035,
 1474551048,
 12124,
 -43034,
 1474615705,
 12045,
 -43033,
 1474671964,
 12075,
 -43032,
 1474725739,
 12112,
 -1,
 1474788760,
 12170,
 1474975727,
 1474523992,
 -1,
 1475041261,
 1474893172,
 -1,
 -43028,
 1475009800,
 12118,
 -1,
 1475053791,
 12114,
 -43026,
 1474992834,
 12176,
 -1,
 1475175504,
 12058,
 1475368947,
 1474893172,
 -1,
 -43023,
 1475336436,
 12147,
 -43022,
 1475399903,
 12224,
 -1,
 1475458585,
 12190,
 -43020,
 1475309154,
 12194,
 -1,
 1475566964,
 12070,
 1475762185,
 1474485512,
 -1,
 1475827706,
 1475679604,
 -1,
 1475893241,
 1475771387,
 12193,
 -1,
 1475806088,
 12175,
 -1,
 1475855730,
 12116,
 1476089853,
 1475782996,
 -1,
 -43012,
 1476040211,
 12206,
 -1,
 1476075434,
 12051,
 1476286464,
 1476039055,
 -1,
 -43009,
 1476244285,
 12079,
 -1,
 1476297206,
 12069,
 1476483075,
 1476224816,
 -1,
 -43006,
 1476411527,
 12195,
 -1,
 1476474400,
 12213,
 1476679686,
 1476417675,
 -1,
 -43003,
 1476619688,
 12137,
 -1,
 1476673922,
 12230,
 1476919295,
 1476608135,
 -1,
 -43000,
 1476837387,
 12177,
 -1,
 1476861973,
 12110,
 1477072923,
 1475706853,
 -1,
 1477138452,
 1477022095,
 -1,
 1477203984,
 1477103178,
 -1,
 1477269519,
 1477150943,
 -1,
 -42994,
 1477231496,
 12077,
 -1,
 1477260832,
 12201,
 -1,
 1477232143,
 12061,
 1477531667,
 1477159252,
 -1,
 -42990,
 1477493796,
 12165,
 -1,
 1477545188,
 12192,
 -1,
 1477481773,
 12105,
 1477793815,
 1477075327,
 -1,
 -42986,
 1477741819,
 12162,
 -1,
 1477803129,
 12233,
 1477990426,
 1477722247,
 -1,
 -42983,
 1477934354,
 12128,
 -1,
 1477977196,
 12161,
 -1,
 1477909822,
 12040,
 1478252587,
 1477014360,
 -1,
 1478318114,
 1478180999,
 -1,
 1478383648,
 1478235508,
 -1,
 -42977,
 1478346388,
 12208,
 -1,
 1478381142,
 12212,
 -42975,
 1478318099,
 12041,
 -1,
 1478509981,
 12210,
 1478711334,
 1478254975,
 -1,
 -42972,
 1478658819,
 12033,
 -42971,
 1478709030,
 12131,
 -1,
 1478768160,
 12039,
 1478973480,
 1478661651,
 12199,
 -1,
 1478888072,
 12085,
 1479147519,
 1478890868,
 -1,
 -42966,
 1479050011,
 12074,
 -1,
 1479094565,
 12107,
 1479301181,
 1478187147,
 -1,
 1479366706,
 1479218548,
 -1,
 1479432240,
 1479308120,
 -1,
 -42961,
 1479364252,
 12121,
 -1,
 1479420054,
 12093,
 -42959,
 1479379549,
 12095,
 -1,
 1479568368,
 12221,
 1479759927,
 1479315855,
 -1,
 1479825462,
 1479715156,
 -1,
 -42955,
 1479784600,
 12218,
 -1,
 1479837919,
 12179,
 -1,
 1479775202,
 12037,
 1480087612,
 1479688327,
 -1,
 1480153147,
 1480004980,
 -1,
 -42950,
 1480111641,
 12092,
 -1,
 1480144416,
 12216,
 -1,
 1480099688,
 12231,
 -1,
 1480025120,
 12054,
 1480480842,
 1479229575,
 -1,
 1480546370,
 1480398196,
 -1,
 1480611905,
 1480501588,
 12159,
 -1,
 1480574479,
 12063,
 -1,
 1480573652,
 12215,
 1480808516,
 1480513923,
 12241,
 -1,
 1480747175,
 12067,
 1480939591,
 1480755423,
 -1,
 -42938,
 1480902002,
 12042,
 -1,
 1480929739,
 12062,
 -42936,
 1480910011,
 12140,
 -42935,
 1481081617,
 12235,
 -1,
 1481139427,
 12043,
 1481332822,
 1480436052,
 -1,
 1481398351,
 1481269631,
 -1,
 -42931,
 1481365913,
 12078,
 -42930,
 1481397502,
 12053,
 -1,
 1481453192,
 12150,
 1481660499,
 1481315700,
 -1,
 -42927,
 1481622228,
 12239,
 -42926,
 1481678825,
 12097,
 -1,
 1481729840,
 12204,
 -42924,
 1481626067,
 12187,
 -42923,
 1481873054,
 12071,
 -1,
 1481917039,
 12186,
 1482119263,
 1481265891,
 -1,
 1482184794,
 1482068367,
 12065,
 -42919,
 1482126902,
 12198,
 -1,
 1482164822,
 12066,
 1482381405,
 1482140079,
 -1,
 -42916,
 1482342303,
 12171,
 -1,
 1482385200,
 12146,
 -42914,
 1482317803,
 12225,
 -1,
 1482499229,
 12200,
 1482709094,
 1482072041,
 -1,
 1482774627,
 1482664276,
 -1,
 -42910,
 1482724121,
 12126,
 -1,
 1482780273,
 12059,
 -42908,
 1482727233,
 12050,
 -42907,
 1482915359,
 12158,
 -1,
 1482974346,
 12183,
 1483167853,
 1482658191,
 -1,
 1483233386,
 1483120617,
 -1,
 -42903,
 1483187537,
 12167,
 -1,
 1483228916,
 12048,
 1483429996,
 1483180803,
 12032,
 -1,
 1483389187,
 12080,
 -1,
 1483372086,
 12156,
 1483626612,
 1483085172,
 -1,
 1483692145,
 1483584869,
 -1,
 -42896,
 1483644653,
 12142,
 -1,
 1483697783,
 12164,
 -42894,
 1483662183,
 12100,
 -42893,
 1483835997,
 12157,
 -1,
 1483887428,
 12060,
 1484085369,
 1483573471,
 -1,
 1484150904,
 1484034447,
 -1,
 -42889,
 1484112596,
 12102,
 -1,
 1484175512,
 12240,
 -1,
 1484081981,
 12153,
 1484413054,
 1484022143,
 -1,
 1484478589,
 1484359903,
 -1,
 -42884,
 1484437708,
 12173,
 -1,
 1484468002,
 12072,
 -1,
 1484402312,
 12046,
 1484740737,
 1484380078,
 -1,
 -42880,
 1484678725,
 12197,
 -1,
 1484725221,
 12181,
 1484937348,
 1484681003,
 -1,
 -42877,
 1484892500,
 12152,
 -1,
 1484928842,
 12127,
 -42875,
 1484907792,
 12232,
 -42874,
 1485100659,
 12132,
 -1,
 1485140605,
 12049,
 1485373439,
 1465223521,
 -1,
 1485396175,
 1485272658,
 -1,
 1485461710,
 1485360218,
 -1,
 1485527185,
 1485428654,
 -1,
 1485592720,
 1485476437,
 -1,
 1485658254,
 1485547860,
 3211,
 -1,
 1485613396,
 3296,
 1485832191,
 1485599576,
 3212,
 -1,
 1485730648,
 3297,
 -1,
 1485510004,
 3253,
 1485985943,
 1485488852,
 -1,
 1486051477,
 1485947604,
 -1,
 -42860,
 1485985961,
 3232,
 -1,
 1486034292,
 3231,
 -42858,
 1485985961,
 3237,
 -1,
 1486165364,
 3236,
 1486379164,
 1485932767,
 -1,
 -42855,
 1486349354,
 3230,
 -42854,
 1486391611,
 3235,
 -42853,
 1486443268,
 3225,
 -1,
 1486493044,
 3240,
 1486706850,
 1486304800,
 -1,
 1486772384,
 1486632480,
 -1,
 -42849,
 1486706857,
 3234,
 -1,
 1486755188,
 3233,
 -42847,
 1486706857,
 3239,
 -1,
 1486886260,
 3238,
 1487100070,
 1486624116,
 3205,
 -42844,
 1487064650,
 3220,
 -42843,
 1487102335,
 3216,
 -1,
 1487148404,
 3206,
 1487362218,
 1487058719,
 -1,
 -42840,
 1487320985,
 3255,
 -42839,
 1487362217,
 3254,
 -1,
 1487410548,
 3256,
 1487624364,
 1487326794,
 3209,
 -1,
 1487588938,
 3210,
 1487755439,
 1487579476,
 -1,
 -42834,
 1487710639,
 3249,
 -1,
 1487738228,
 3248,
 1487952050,
 1487708137,
 -1,
 -42831,
 1487886505,
 3243,
 -1,
 1487934836,
 3242,
 1488148660,
 1487901071,
 3218,
 -1,
 1488097679,
 3219,
 1488279735,
 1488089944,
 -1,
 -42826,
 1488221101,
 3251,
 -1,
 1488262516,
 3250,
 1488476346,
 1488220296,
 -1,
 -42823,
 1488410793,
 3222,
 -1,
 1488459124,
 3221,
 1488672957,
 1488416553,
 -1,
 -42820,
 1488607401,
 3229,
 -1,
 1488655732,
 3228,
 1488869567,
 1488609663,
 3207,
 -1,
 1488806271,
 3208,
 1489000642,
 1488802531,
 -1,
 -42815,
 1488935081,
 3224,
 -1,
 1488983412,
 3223,
 1489197252,
 1488928903,
 3214,
 -1,
 1489125511,
 3215,
 1489328327,
 1489120478,
 -1,
 -42810,
 1489262761,
 3227,
 -1,
 1489311092,
 3226,
 1489524938,
 1489249910,
 -1,
 -42807,
 1489459369,
 3245,
 -1,
 1489507700,
 3244,
 -42805,
 1489495082,
 3247,
 -42804,
 1489666098,
 3246,
 -42803,
 1489721513,
 3257,
 -1,
 1489784511,
 3294,
 -1,
 1485409360,
 3285,
 1490049249,
 1485364406,
 -1,
 1490114773,
 1490017295,
 -1,
 1490180307,
 1490069844,
 3267,
 -1,
 1490135380,
 3268,
 1490354175,
 1490121560,
 3298,
 -1,
 1490252632,
 3299,
 1490442457,
 1490031988,
 -1,
 -42793,
 1490406986,
 3276,
 -42792,
 1490444671,
 3272,
 -1,
 1490490740,
 3262,
 1490704603,
 1490406986,
 3265,
 -1,
 1490669130,
 3266,
 1490835677,
 1490653583,
 3274,
 -1,
 1490784655,
 3275,
 1490966751,
 1490772351,
 3263,
 -1,
 1490903423,
 3264,
 1491140607,
 1490894983,
 3270,
 -1,
 1491026055,
 3271,
 1491228911,
 1489975704,
 -1,
 1491294437,
 1491190484,
 -1,
 -42780,
 1491263887,
 3304,
 -1,
 1491296342,
 3305,
 1491491048,
 1491253023,
 -1,
 -42777,
 1491431150,
 3308,
 -1,
 1491487874,
 3309,
 1491687659,
 1491422806,
 -1,
 -42774,
 1491639280,
 3306,
 -1,
 1491693175,
 3307,
 -42772,
 1491658645,
 3302,
 -42771,
 1491834303,
 3303,
 -42770,
 1491897532,
 3311,
 -1,
 1491944759,
 3310,
 1492146425,
 1491188784,
 -1,
 1492211955,
 1492114277,
 -1,
 -42766,
 1492170789,
 3203,
 -1,
 1492232845,
 3277,
 1492408566,
 1492129140,
 -1,
 -42763,
 1492375493,
 3261,
 -1,
 1492422853,
 3202,
 -42761,
 1492374533,
 3314,
 -42760,
 1492553781,
 3260,
 -1,
 1492611078,
 3313,
 -1,
 1492064549,
 3286,
 1492867461,
 1465172890,
 -1,
 1492932992,
 1492779008,
 -1,
 1492998524,
 1492875738,
 -1,
 1493063974,
 1492956959,
 -1,
 1493129505,
 1493008670,
 -1,
 1493195013,
 1493084500,
 -1,
 -42751,
 1493159498,
 12797,
 -42750,
 1493209487,
 12799,
 -42749,
 1493262719,
 12796,
 -42748,
 1493319815,
 12798,
 -1,
 1493374324,
 12795,
 1493588235,
 1493129355,
 -1,
 -42745,
 1493552714,
 12791,
 -42744,
 1493602703,
 12793,
 -42743,
 1493655935,
 12790,
 -42742,
 1493713031,
 12792,
 -1,
 1493767540,
 12789,
 1493981455,
 1493558254,
 -1,
 -42739,
 1493945930,
 12517,
 -42738,
 1493995919,
 12519,
 -1,
 1494029684,
 12515,
 1494243603,
 1493921928,
 -1,
 -42735,
 1494208074,
 12784,
 -42734,
 1494237319,
 12534,
 -1,
 1494291828,
 12533,
 1494505750,
 1494205140,
 -1,
 -42731,
 1494470218,
 12483,
 -1,
 1494520207,
 12787,
 1494702361,
 1494464287,
 -1,
 -42728,
 1494666826,
 12786,
 -1,
 1494704511,
 12785,
 -42726,
 1494670640,
 12526,
 -42725,
 1494863434,
 12453,
 -42724,
 1494913423,
 12457,
 -42723,
 1494978583,
 12788,
 -42722,
 1495041969,
 12794,
 -42721,
 1495097727,
 12451,
 -42720,
 1495154823,
 12455,
 -1,
 1495209332,
 12449,
 -42718,
 1493093962,
 12473,
 -42717,
 1495372175,
 12477,
 -42716,
 1495425407,
 12471,
 -42715,
 1495482503,
 12475,
 -1,
 1495537012,
 12469,
 1495750956,
 1493010655,
 12531,
 -42712,
 1495715402,
 12492,
 -42711,
 1495765391,
 12494,
 -42710,
 1495818623,
 12491,
 -42709,
 1495875719,
 12493,
 -1,
 1495930228,
 12490,
 1496144178,
 1495721758,
 -1,
 -42706,
 1496108618,
 12474,
 -42705,
 1496158607,
 12478,
 -42704,
 1496211839,
 12472,
 -42703,
 1496268935,
 12476,
 -1,
 1496323444,
 12470,
 1496537400,
 1496111022,
 -1,
 -42700,
 1496501834,
 12532,
 -42699,
 1496551823,
 12538,
 -42698,
 1496605055,
 12536,
 -42697,
 1496662151,
 12537,
 -1,
 1496716660,
 12535,
 1496930622,
 1496498900,
 -1,
 -42694,
 1496895050,
 12484,
 -42693,
 1496945039,
 12488,
 -42692,
 1496998271,
 12481,
 -42691,
 1497055367,
 12486,
 -1,
 1497109876,
 12479,
 1497323844,
 1496885588,
 -1,
 -42688,
 1497288266,
 12523,
 -42687,
 1497338255,
 12525,
 -42686,
 1497391487,
 12522,
 -42685,
 1497448583,
 12524,
 -1,
 1497503092,
 12521,
 1497717066,
 1497276393,
 -1,
 -42682,
 1497681482,
 12503,
 -42681,
 1497731471,
 12509,
 -42680,
 1497784703,
 12500,
 -42679,
 1497841799,
 12506,
 -1,
 1497896308,
 12497,
 1498110288,
 1497661413,
 -1,
 -42676,
 1498074698,
 12512,
 -42675,
 1498124687,
 12514,
 -42674,
 1498177919,
 12511,
 -42673,
 1498235015,
 12513,
 -1,
 1498289524,
 12510,
 1498503510,
 1498050696,
 -1,
 -42670,
 1498467914,
 12463,
 -42669,
 1498517903,
 12467,
 -42668,
 1498571135,
 12461,
 -42667,
 1498628231,
 12465,
 -1,
 1498682740,
 12459,
 1498896732,
 1498437771,
 -1,
 -42664,
 1498861130,
 12501,
 -42663,
 1498911119,
 12507,
 -42662,
 1498964351,
 12498,
 -42661,
 1499021447,
 12504,
 -1,
 1499075956,
 12495,
 1499289954,
 1498829539,
 -1,
 -42658,
 1499254346,
 12464,
 -42657,
 1499304335,
 12468,
 -42656,
 1499357567,
 12462,
 -42655,
 1499414663,
 12466,
 -1,
 1499469172,
 12460,
 1499683176,
 1499215392,
 -1,
 -42652,
 1499647562,
 12485,
 -42651,
 1499697551,
 12489,
 -42650,
 1499750783,
 12482,
 -42649,
 1499807879,
 12487,
 -1,
 1499862388,
 12480,
 1500076398,
 1499604598,
 -1,
 -42646,
 1500040778,
 12502,
 -42645,
 1500090767,
 12508,
 -42644,
 1500143999,
 12499,
 -42643,
 1500201095,
 12505,
 -1,
 1500255604,
 12496,
 1500469619,
 1500044552,
 -1,
 -42640,
 1500418447,
 12530,
 -42639,
 1500471679,
 12528,
 -42638,
 1500528775,
 12529,
 -1,
 1500583284,
 12527,
 1500797303,
 1500439534,
 -1,
 -42635,
 1500761674,
 12518,
 -42634,
 1500811663,
 12520,
 -1,
 1500845428,
 12516,
 -42632,
 1500761674,
 12454,
 -42631,
 1501008271,
 12458,
 -42630,
 1501061503,
 12452,
 -42629,
 1501118599,
 12456,
 -1,
 1501173108,
 12450,
 -42627,
 1492966440,
 12542,
 -42626,
 1501332704,
 12539,
 -42625,
 1501392325,
 12541,
 -1,
 1501444552,
 12543,
 1501691903,
 1492848636,
 -1,
 -42622,
 1501617239,
 12443,
 -42621,
 1501673736,
 12444,
 -42620,
 1501734569,
 12540,
 -1,
 1501773074,
 12448,
 1501977053,
 1492807152,
 -1,
 1502042561,
 1501919706,
 -1,
 1502108046,
 1501967904,
 -1,
 1502173580,
 1502033440,
 -1,
 -42614,
 1502107817,
 69787,
 -42613,
 1502165109,
 69786,
 -1,
 1502221684,
 69785,
 -42611,
 1502107817,
 69793,
 -1,
 1502352756,
 69792,
 1502566804,
 1502069460,
 -1,
 1502632338,
 1502528212,
 -1,
 -42607,
 1502566569,
 69784,
 -1,
 1502614900,
 69783,
 -42605,
 1502566569,
 69791,
 -1,
 1502745972,
 69790,
 1502960025,
 1502513375,
 -1,
 -42602,
 1502929962,
 69782,
 -42601,
 1502972219,
 69789,
 -42600,
 1503023876,
 69777,
 -1,
 1503073652,
 69794,
 1503287709,
 1502877044,
 69763,
 -42597,
 1503252042,
 69772,
 -42596,
 1503289727,
 69770,
 -1,
 1503335796,
 69764,
 1503549857,
 1503246111,
 -1,
 -42593,
 1503508377,
 69805,
 -42592,
 1503549609,
 69804,
 -1,
 1503597940,
 69806,
 1503812003,
 1503514186,
 69767,
 -1,
 1503776330,
 69768,
 1503943078,
 1503766868,
 -1,
 -42587,
 1503877289,
 69788,
 -1,
 1503925620,
 69801,
 1504139689,
 1503895529,
 -1,
 -42584,
 1504073897,
 69796,
 -1,
 1504122228,
 69795,
 1504336300,
 1504080008,
 -1,
 -42581,
 1504270505,
 69774,
 -1,
 1504318836,
 69773,
 1504532911,
 1504276265,
 -1,
 -42578,
 1504467113,
 69781,
 -1,
 1504515444,
 69780,
 1504729521,
 1504469375,
 69765,
 -1,
 1504665983,
 69766,
 1504860596,
 1504662243,
 -1,
 -42573,
 1504794793,
 69776,
 -1,
 1504843124,
 69775,
 1505057207,
 1504783582,
 -1,
 -42570,
 1504991401,
 69779,
 -1,
 1505039732,
 69778,
 1505253818,
 1504978550,
 -1,
 -42567,
 1505188009,
 69798,
 -1,
 1505236340,
 69797,
 -42565,
 1505223722,
 69800,
 -42564,
 1505417148,
 69803,
 -42563,
 1505464719,
 69771,
 -42562,
 1505525810,
 69799,
 -42561,
 1505588141,
 69802,
 -42560,
 1505646761,
 69807,
 -1,
 1505706119,
 69769,
 1505909196,
 1502010550,
 -1,
 1505974726,
 1505826164,
 -1,
 -42556,
 1505939018,
 69816,
 -42555,
 1505976703,
 69814,
 -1,
 1506022772,
 69808,
 1506236872,
 1505939018,
 69811,
 -1,
 1506201162,
 69812,
 1506367946,
 1506173311,
 69809,
 -1,
 1506304383,
 69810,
 -42549,
 1506316687,
 69815,
 -1,
 1506427015,
 69813,
 1506630101,
 1505867551,
 -1,
 1506695636,
 1506567561,
 -1,
 1506761169,
 1506663269,
 -1,
 -42544,
 1506719781,
 69762,
 -1,
 1506781837,
 69817,
 -42542,
 1506709557,
 69818,
 -42541,
 1506880948,
 69760,
 -1,
 1506942871,
 69761,
 -1,
 1506624099,
 69822,
 1507219930,
 1506555424,
 -1,
 1507285465,
 1507171124,
 -1,
 -42536,
 1507244249,
 69823,
 -1,
 1507276522,
 69825,
 -1,
 1507204672,
 69824,
 -42533,
 1507168327,
 69821,
 -42532,
 1507477592,
 69820,
 -1,
 1507530305,
 69819,
 1507786751,
 1501946933,
 -1,
 1507809794,
 1507686874,
 -1,
 1507875299,
 1507756255,
 -1,
 -42527,
 1507845162,
 43281,
 -42526,
 1507873540,
 43277,
 -1,
 1507923316,
 43284,
 1508137446,
 1507836628,
 -1,
 -42523,
 1508071593,
 43294,
 -1,
 1508119924,
 43282,
 1508334057,
 1508095775,
 -1,
 -42520,
 1508268201,
 43279,
 -1,
 1508316532,
 43278,
 1508530668,
 1508286441,
 -1,
 -42517,
 1508464809,
 43286,
 -1,
 1508513140,
 43285,
 1508727279,
 1508479375,
 -1,
 -42514,
 1508675983,
 43301,
 -1,
 1508720775,
 43299,
 1508923890,
 1508667528,
 -1,
 -42511,
 1508858025,
 43275,
 -1,
 1508906356,
 43274,
 1509120501,
 1508857995,
 -1,
 -42508,
 1509081877,
 43283,
 -1,
 1509102964,
 43295,
 -42506,
 1509091120,
 43280,
 -42505,
 1509286954,
 43291,
 -42504,
 1509350704,
 43293,
 -42503,
 1509414844,
 43296,
 -42502,
 1509468591,
 43290,
 -42501,
 1509523506,
 43287,
 -42500,
 1509585837,
 43292,
 -42499,
 1509646719,
 43300,
 -42498,
 1509708548,
 43276,
 -42497,
 1509766795,
 43288,
 -42496,
 1509829947,
 43297,
 -42495,
 1509893800,
 43289,
 -1,
 1509954932,
 43298,
 1510169104,
 1507735960,
 -1,
 1510234630,
 1510130388,
 -1,
 -42491,
 1510203791,
 43266,
 -1,
 1510236246,
 43267,
 1510431241,
 1510192927,
 -1,
 -42488,
 1510371054,
 43270,
 -1,
 1510427778,
 43271,
 1510627852,
 1510362710,
 -1,
 -42485,
 1510579184,
 43268,
 -1,
 1510633079,
 43269,
 -42483,
 1510598549,
 43264,
 -42482,
 1510774207,
 43265,
 -42481,
 1510837436,
 43273,
 -1,
 1510884663,
 43272,
 1511086614,
 1510136975,
 -1,
 1511152147,
 1511050826,
 43304,
 -1,
 1511080071,
 43302,
 1511283221,
 1511080071,
 43303,
 -1,
 1511211143,
 43305,
 -1,
 1511231887,
 43306,
 1511479834,
 1511049654,
 -1,
 1511545369,
 1511402859,
 43308,
 -1,
 1511458929,
 43309,
 -1,
 1511498816,
 43307,
 1511784447,
 1511439408,
 -1,
 -42468,
 1511701463,
 43311,
 -1,
 1511732755,
 43310,
 1511938896,
 1465079947,
 -1,
 1512004339,
 1511883822,
 -1,
 1512069767,
 1511962399,
 -1,
 1512135272,
 1512039926,
 -1,
 1512200760,
 1512087529,
 -1,
 1512266292,
 1512155771,
 -1,
 1512331825,
 1512181459,
 -1,
 1512397355,
 1512253046,
 -1,
 1512462888,
 1512362747,
 -1,
 -42457,
 1512420339,
 6649,
 -1,
 1512469143,
 6633,
 1512701951,
 1512391972,
 -1,
 -42454,
 1512616947,
 6648,
 -1,
 1512665751,
 6632,
 1512856110,
 1512350636,
 -1,
 -42451,
 1512813555,
 6647,
 -1,
 1512862359,
 6631,
 1513095167,
 1512802399,
 -1,
 -42448,
 1513010163,
 6646,
 -1,
 1513058967,
 6630,
 1513291775,
 1512243200,
 -1,
 -42445,
 1513206771,
 6645,
 -1,
 1513255575,
 6629,
 1513445943,
 1512203678,
 -1,
 -42442,
 1513403379,
 6642,
 -1,
 1513452183,
 6626,
 -1,
 1513366732,
 6624,
 1513708110,
 1512126209,
 -1,
 1513773643,
 1513623251,
 -1,
 1513839169,
 1513725929,
 -1,
 1513904702,
 1513794175,
 -1,
 -42435,
 1513862131,
 6655,
 -1,
 1513910935,
 6639,
 1514143743,
 1513842078,
 -1,
 -42432,
 1514058739,
 6652,
 -1,
 1514107543,
 6636,
 1514297928,
 1513760374,
 -1,
 1514363461,
 1514263291,
 -1,
 -42428,
 1514320883,
 6654,
 -1,
 1514369687,
 6638,
 1514602495,
 1514292516,
 -1,
 -42425,
 1514517491,
 6653,
 -1,
 1514566295,
 6637,
 1514799103,
 1514244191,
 -1,
 -42422,
 1514714099,
 6651,
 -1,
 1514762903,
 6635,
 1514995711,
 1513684992,
 -1,
 -42419,
 1514910707,
 6650,
 -1,
 1514959511,
 6634,
 1515149917,
 1513650381,
 -1,
 1515215448,
 1515102185,
 -1,
 1515280983,
 1515170427,
 6133,
 1515388927,
 1515196115,
 -1,
 1515412053,
 1515267702,
 -1,
 -42412,
 1515377399,
 6137,
 -1,
 1515406625,
 6136,
 -42410,
 1515365288,
 6135,
 -1,
 1515554906,
 6134,
 -1,
 1515218331,
 6130,
 1515805275,
 1515136630,
 -1,
 -42406,
 1515770615,
 6132,
 -1,
 1515799841,
 6131,
 -42404,
 1515765433,
 6128,
 -1,
 1515948122,
 6129,
 1516132964,
 1515071094,
 -1,
 1516198497,
 1516098299,
 -1,
 -42400,
 1516155891,
 6644,
 -1,
 1516204695,
 6628,
 1516437503,
 1516127524,
 -1,
 -42397,
 1516352499,
 6643,
 -1,
 1516401303,
 6627,
 1516591719,
 1516079199,
 -1,
 -42394,
 1516549107,
 6641,
 -1,
 1516597911,
 6625,
 -1,
 1516555571,
 6640,
 1516896255,
 1512072585,
 -1,
 1516919407,
 1516775030,
 -1,
 1516984942,
 1516836212,
 -1,
 -42388,
 1516947034,
 6099,
 -42387,
 1517007641,
 6101,
 -1,
 1517064175,
 6091,
 -1,
 1516916291,
 6104,
 1517312627,
 1516859528,
 -1,
 -42383,
 1517262498,
 6106,
 -42382,
 1517312537,
 6100,
 -1,
 1517361603,
 6094,
 1517574775,
 1517229428,
 -1,
 -42379,
 1517541325,
 6108,
 -42378,
 1517603942,
 6109,
 -1,
 1517641958,
 6095,
 1517836922,
 1517535956,
 -1,
 -42375,
 1517793669,
 6090,
 -1,
 1517851111,
 6093,
 1518033533,
 1517791572,
 -1,
 -42372,
 1517982198,
 6092,
 -1,
 1518027049,
 6087,
 1518230144,
 1517956318,
 -1,
 -42369,
 1518179040,
 6098,
 -1,
 1518214383,
 6102,
 -42367,
 1518200558,
 6088,
 -42366,
 1518394314,
 6097,
 -42365,
 1518450676,
 6096,
 -42364,
 1518510955,
 6105,
 -42363,
 1518570676,
 6086,
 -42362,
 1518635171,
 6089,
 -1,
 1518696664,
 6103,
 1518885560,
 1512012250,
 -1,
 1518951057,
 1518846676,
 -1,
 1519016588,
 1518913039,
 -1,
 -42357,
 1518965135,
 6029,
 -1,
 1518998900,
 6027,
 1519213199,
 1518950539,
 -1,
 -42354,
 1519161743,
 6034,
 -1,
 1519195508,
 6032,
 -42352,
 1519161743,
 6033,
 -1,
 1519326580,
 6031,
 1519540886,
 1518897375,
 -1,
 -42349,
 1519511082,
 6025,
 -42348,
 1519554959,
 6035,
 -42347,
 1519619470,
 6030,
 -1,
 1519670813,
 6020,
 1519868572,
 1519480968,
 -1,
 1519934106,
 1519802507,
 -1,
 -42343,
 1519882639,
 6019,
 -1,
 1519916404,
 6017,
 -42341,
 1519882639,
 6018,
 -1,
 1520047476,
 6016,
 1520261794,
 1519791326,
 -1,
 1520327328,
 1520195723,
 -1,
 -42337,
 1520275855,
 6024,
 -1,
 1520309620,
 6022,
 -42335,
 1520275855,
 6023,
 -1,
 1520440692,
 6021,
 1520655014,
 1520219935,
 -1,
 -42332,
 1520615029,
 6046,
 -42331,
 1520654505,
 6045,
 -1,
 1520702836,
 6047,
 1520917163,
 1520607209,
 -1,
 1520982698,
 1520851083,
 -1,
 -42327,
 1520931215,
 6039,
 -1,
 1520964980,
 6037,
 -1,
 1520931215,
 6038,
 1521244846,
 1520857944,
 -1,
 -42323,
 1521193359,
 6043,
 -1,
 1521227124,
 6049,
 1521441457,
 1521169952,
 -1,
 -42320,
 1521389967,
 6028,
 -1,
 1521423732,
 6026,
 -42318,
 1521411626,
 6041,
 -42317,
 1521605644,
 6044,
 -42316,
 1521660884,
 6042,
 -42315,
 1521723210,
 6050,
 -42314,
 1521780276,
 6040,
 -42313,
 1521834153,
 6048,
 -1,
 1521886888,
 6036,
 1522096847,
 1518853263,
 -1,
 1522162380,
 1522056240,
 -1,
 1522227903,
 1522079092,
 -1,
 -42308,
 1522191946,
 6085,
 -42307,
 1522229631,
 6083,
 -42306,
 1522286727,
 6082,
 -1,
 1522341236,
 6070,
 1522555586,
 1522197486,
 6073,
 -42303,
 1522525166,
 6074,
 -1,
 1522537844,
 6079,
 1522752197,
 1522519626,
 6075,
 -42300,
 1522716234,
 6076,
 -1,
 1522734452,
 6077,
 1522948808,
 1522688383,
 6071,
 -42297,
 1522884991,
 6072,
 -1,
 1522942087,
 6080,
 1523145419,
 1522897295,
 -1,
 -42294,
 1523093903,
 6084,
 -1,
 1523138695,
 6078,
 -1,
 1523073159,
 6081,
 1523449855,
 1522100505,
 -1,
 -42290,
 1523361604,
 6068,
 -1,
 1523389812,
 6069,
 1523604196,
 1522034679,
 -1,
 1523669728,
 1523558212,
 -1,
 1523735253,
 1523633738,
 6055,
 1523800788,
 1523699274,
 6057,
 -1,
 1523767214,
 6058,
 -1,
 1523740808,
 6056,
 1523997402,
 1523651956,
 -1,
 -42281,
 1523961418,
 6067,
 -42280,
 1524016964,
 6051,
 -42279,
 1524064639,
 6064,
 -1,
 1524110708,
 6052,
 1524325085,
 1523947153,
 -1,
 -42276,
 1524288866,
 6066,
 -1,
 1524340159,
 6065,
 1524521695,
 1524261247,
 6053,
 -1,
 1524457855,
 6054,
 -1,
 1524449415,
 6063,
 1524718306,
 1523627765,
 6059,
 -1,
 1524687854,
 6060,
 1524891647,
 1524662200,
 6061,
 -1,
 1524818926,
 6062,
 1524980466,
 1523530136,
 -1,
 1525045992,
 1524941524,
 -1,
 -42265,
 1525014927,
 6114,
 -1,
 1525047382,
 6115,
 1525242603,
 1525004063,
 -1,
 -42262,
 1525182190,
 6118,
 -1,
 1525238914,
 6119,
 1525439214,
 1525173846,
 -1,
 -42259,
 1525390320,
 6116,
 -1,
 1525444215,
 6117,
 -42257,
 1525409685,
 6112,
 -42256,
 1525585343,
 6113,
 -42255,
 1525648572,
 6121,
 -1,
 1525695799,
 6120,
 -1,
 1524905412,
 6107,
 1526005759,
 1511924257,
 -1,
 1526029091,
 1525905882,
 -1,
 1526094588,
 1525990100,
 -1,
 1526160122,
 1526055636,
 -1,
 -42248,
 1526122022,
 68147,
 -42247,
 1526159529,
 68123,
 -1,
 1526207860,
 68122,
 -42245,
 1526093993,
 68128,
 -1,
 1526338932,
 68127,
 1526553346,
 1526019616,
 -1,
 1526618880,
 1526478368,
 -1,
 -42241,
 1526552745,
 68125,
 -1,
 1526601076,
 68124,
 -42239,
 1526552745,
 68130,
 -1,
 1526732148,
 68129,
 1526946566,
 1526511391,
 -1,
 -42236,
 1526904729,
 68142,
 -42235,
 1526945961,
 68141,
 -1,
 1526994292,
 68143,
 1527208714,
 1526892767,
 -1,
 -42232,
 1527178282,
 68121,
 -42231,
 1527220539,
 68126,
 -1,
 1527256436,
 68131,
 1527470862,
 1527148680,
 -1,
 -42228,
 1527410847,
 68146,
 -42227,
 1527470249,
 68113,
 -1,
 1527518580,
 68112,
 1527733009,
 1527422953,
 -1,
 -42224,
 1527666857,
 68133,
 -1,
 1527715188,
 68132,
 1527929620,
 1527665379,
 -1,
 -42221,
 1527863465,
 68115,
 -1,
 1527911796,
 68114,
 1528126231,
 1527852254,
 -1,
 -42218,
 1528060073,
 68118,
 -1,
 1528108404,
 68117,
 1528322842,
 1528047222,
 -1,
 -42215,
 1528256681,
 68135,
 -1,
 1528305012,
 68134,
 -42213,
 1528293168,
 68144,
 -42212,
 1528489002,
 68137,
 -42211,
 1528551356,
 68140,
 -42210,
 1528605103,
 68138,
 -42209,
 1528660018,
 68136,
 -42208,
 1528722349,
 68139,
 -42207,
 1528786731,
 68119,
 -42206,
 1528846505,
 68145,
 -1,
 1528894836,
 68096,
 1529109297,
 1525982971,
 -1,
 1529174825,
 1529034272,
 -1,
 1529240360,
 1529123215,
 -1,
 -42201,
 1529204536,
 68183,
 -1,
 1529266900,
 68176,
 -1,
 1529159232,
 68182,
 1529502508,
 1529115480,
 -1,
 -42197,
 1529453356,
 68181,
 -1,
 1529505930,
 68184,
 1529699119,
 1529425118,
 -1,
 -42194,
 1529654529,
 68179,
 -1,
 1529703452,
 68178,
 -42192,
 1529658850,
 68177,
 -1,
 1529840153,
 68180,
 1530026811,
 1529075630,
 -1,
 1530092346,
 1529978672,
 -1,
 1530157881,
 1530051632,
 -1,
 -42187,
 1530125336,
 68099,
 -42186,
 1530187338,
 68098,
 -42185,
 1530237327,
 68102,
 -42184,
 1530290559,
 68097,
 -1,
 1530347655,
 68101,
 -1,
 1530099964,
 68108,
 -1,
 1530031122,
 68159,
 1530682179,
 1529986096,
 -1,
 1530747711,
 1530608324,
 -1,
 -42178,
 1530711897,
 68109,
 -1,
 1530774241,
 68154,
 -42176,
 1530715093,
 68111,
 -42175,
 1530867273,
 68153,
 -42174,
 1530931031,
 68152,
 -1,
 1530994583,
 68110,
 1531206474,
 1530630207,
 -1,
 1531272007,
 1531167444,
 -1,
 -42170,
 1531240031,
 68165,
 -1,
 1531266801,
 68164,
 1531510783,
 1531221443,
 -1,
 -42167,
 1531430685,
 68167,
 -1,
 1531470103,
 68166,
 1531707391,
 1531132312,
 -1,
 1531730766,
 1531626196,
 -1,
 -42163,
 1531699599,
 68161,
 -1,
 1531732054,
 68162,
 -42161,
 1531680191,
 68160,
 -1,
 1531859408,
 68163,
 1532058451,
 1511866503,
 -1,
 -42158,
 1532028084,
 9000,
 -1,
 1532067758,
 8490,
 -42156,
 1532008610,
 12927,
 -1,
 1532193729,
 8365,
 1532386854,
 1465046958,
 -1,
 1532452275,
 1532302708,
 -1,
 1532517554,
 1532387713,
 -1,
 1532583073,
 1532478031,
 -1,
 1532648590,
 1532525595,
 -1,
 1532713869,
 1532594399,
 -1,
 1532779368,
 1532646115,
 42507,
 1532844901,
 1532711651,
 -1,
 1532910432,
 1532772487,
 42500,
 -42145,
 1532856543,
 42501,
 -1,
 1532903559,
 42271,
 1533107042,
 1532858767,
 42460,
 -1,
 1533055375,
 42384,
 -42141,
 1533070922,
 42421,
 -42140,
 1533174143,
 42308,
 -1,
 1533220212,
 42348,
 -42138,
 1532794157,
 42428,
 -42137,
 1533363953,
 42467,
 -1,
 1533418814,
 42315,
 1533631350,
 1532704288,
 -1,
 1533696881,
 1533579663,
 42450,
 1533762416,
 1533638229,
 -1,
 -42132,
 1533722306,
 42514,
 -42131,
 1533771826,
 42538,
 -42130,
 1533833375,
 42513,
 -42129,
 1533890239,
 42512,
 -1,
 1533950660,
 42539,
 -1,
 1533710735,
 42374,
 1534221171,
 1533624455,
 42490,
 -1,
 1534148743,
 42261,
 -42124,
 1534185034,
 42411,
 -42123,
 1534288255,
 42298,
 -1,
 1534334324,
 42337,
 1534548862,
 1533600750,
 -1,
 1534614393,
 1534497167,
 42464,
 -1,
 1534562703,
 42388,
 1534745467,
 1534541959,
 42506,
 -1,
 1534673031,
 42275,
 -42116,
 1534709322,
 42425,
 -42115,
 1534812543,
 42312,
 -1,
 1534858612,
 42352,
 1535073158,
 1534488361,
 -1,
 1535138689,
 1535021455,
 42457,
 -1,
 1535086991,
 42381,
 1535269763,
 1535066247,
 42497,
 -1,
 1535197319,
 42268,
 -42108,
 1535233610,
 42418,
 -42107,
 1535336831,
 42305,
 -1,
 1535382900,
 42344,
 1535597448,
 1535021455,
 42463,
 -1,
 1535545743,
 42387,
 1535728522,
 1535524999,
 42505,
 -1,
 1535656071,
 42274,
 -42101,
 1535692362,
 42424,
 -42100,
 1535795583,
 42311,
 -1,
 1535841652,
 42351,
 1536056229,
 1532657637,
 -1,
 1536121750,
 1535988743,
 -1,
 1536187281,
 1536070031,
 42438,
 -1,
 1536135567,
 42363,
 1536318355,
 1536114823,
 42478,
 -1,
 1536245895,
 42250,
 -42092,
 1536282186,
 42400,
 -42091,
 1536385407,
 42287,
 -1,
 1536431476,
 42326,
 1536646046,
 1536042614,
 -1,
 1536711577,
 1536594319,
 42436,
 -1,
 1536659855,
 42361,
 1536842651,
 1536639111,
 42475,
 -1,
 1536770183,
 42248,
 -42084,
 1536806474,
 42398,
 -42083,
 1536909695,
 42285,
 -1,
 1536955764,
 42323,
 1537170336,
 1536594319,
 42462,
 -1,
 1537118607,
 42386,
 1537301410,
 1537097863,
 42504,
 -1,
 1537228935,
 42273,
 -42077,
 1537265226,
 42423,
 -42076,
 1537368447,
 42310,
 -1,
 1537414516,
 42350,
 1537629117,
 1535981088,
 -1,
 1537694646,
 1537562763,
 -1,
 1537760175,
 1537628299,
 -1,
 1537825706,
 1537708431,
 42446,
 -1,
 1537773967,
 42370,
 1537956780,
 1537753223,
 42486,
 -1,
 1537884295,
 42257,
 -42067,
 1537920586,
 42407,
 -42066,
 1538023807,
 42294,
 -1,
 1538069876,
 42333,
 1538284465,
 1537708431,
 42445,
 -1,
 1538232719,
 42369,
 1538415539,
 1538211975,
 42485,
 -1,
 1538343047,
 42256,
 -42060,
 1538379338,
 42406,
 -42059,
 1538482559,
 42293,
 -1,
 1538528628,
 42332,
 1538743224,
 1537642895,
 42449,
 -1,
 1538691471,
 42373,
 1538874298,
 1538670727,
 42489,
 -1,
 1538801799,
 42260,
 -42053,
 1538838090,
 42410,
 -42052,
 1538941311,
 42297,
 -1,
 1538987380,
 42336,
 1539202000,
 1537568904,
 -1,
 1539267528,
 1539153897,
 -1,
 1539333058,
 1539195015,
 42476,
 -42047,
 1539279071,
 42477,
 -1,
 1539326087,
 42249,
 1539529668,
 1539281295,
 42437,
 -1,
 1539477903,
 42362,
 1539660742,
 1539446132,
 42324,
 -1,
 1539606751,
 42325,
 -42041,
 1539624522,
 42399,
 -1,
 1539727743,
 42286,
 1539922890,
 1539215759,
 42459,
 -1,
 1539871119,
 42383,
 1540053964,
 1539850375,
 42499,
 -1,
 1539981447,
 42270,
 1540185038,
 1539970420,
 42346,
 -1,
 1540131039,
 42347,
 -42033,
 1540148810,
 42420,
 -1,
 1540252031,
 42307,
 1540447203,
 1539134179,
 -1,
 1540512731,
 1540367990,
 -1,
 1540578261,
 1540460943,
 42439,
 -42028,
 1540526479,
 42364,
 -1,
 1540589791,
 42440,
 1540774872,
 1540505735,
 42479,
 -42025,
 1540720863,
 42480,
 -1,
 1540767879,
 42251,
 -42023,
 1540738634,
 42401,
 -42022,
 1540907391,
 42288,
 -1,
 1540953460,
 42327,
 1541168094,
 1540440199,
 42502,
 -42019,
 1541114079,
 42503,
 -1,
 1541161095,
 42272,
 1541364704,
 1541116303,
 42461,
 -1,
 1541312911,
 42385,
 -42015,
 1541328458,
 42422,
 -42014,
 1541431679,
 42309,
 -1,
 1541477748,
 42349,
 1541692403,
 1540417310,
 -1,
 1541757932,
 1541625995,
 -1,
 1541823463,
 1541706127,
 42454,
 -1,
 1541771663,
 42378,
 1541954537,
 1541750919,
 42494,
 -1,
 1541881991,
 42265,
 -42006,
 1541918282,
 42415,
 -42005,
 1542021503,
 42302,
 -1,
 1542067572,
 42341,
 1542282222,
 1541706127,
 42453,
 -1,
 1542230415,
 42377,
 1542413296,
 1542209671,
 42493,
 -1,
 1542340743,
 42264,
 -41999,
 1542377034,
 42414,
 -41998,
 1542480255,
 42301,
 -1,
 1542526324,
 42340,
 1542740994,
 1541659912,
 -1,
 1542806520,
 1542689167,
 42431,
 1542872055,
 1542754703,
 42356,
 -1,
 1542818015,
 42357,
 -1,
 1542818015,
 42432,
 1543068668,
 1542733959,
 42470,
 1543134203,
 1542996103,
 42243,
 -1,
 1543080159,
 42244,
 -1,
 1543080159,
 42471,
 1543330814,
 1543032394,
 42393,
 -1,
 1543276767,
 42394,
 1543461888,
 1543266687,
 42280,
 -1,
 1543407839,
 42281,
 1543634943,
 1543378292,
 42318,
 -1,
 1543538911,
 42319,
 1543724050,
 1542701780,
 -1,
 1543789579,
 1543657611,
 -1,
 1543855110,
 1543737743,
 42444,
 -1,
 1543803279,
 42368,
 1543986184,
 1543782535,
 42484,
 -1,
 1543913607,
 42255,
 -41975,
 1543949898,
 42405,
 -41974,
 1544053119,
 42292,
 -1,
 1544099188,
 42331,
 1544313869,
 1543737743,
 42443,
 -1,
 1544262031,
 42367,
 1544444943,
 1544241287,
 42483,
 -1,
 1544372359,
 42254,
 -41968,
 1544408650,
 42404,
 -41967,
 1544511871,
 42291,
 -1,
 1544557940,
 42330,
 1544772642,
 1543681823,
 -1,
 1544838171,
 1544706187,
 -1,
 1544903702,
 1544786319,
 42452,
 -1,
 1544851855,
 42376,
 1545034776,
 1544831111,
 42492,
 -1,
 1544962183,
 42263,
 -41959,
 1544998474,
 42413,
 -41958,
 1545101695,
 42300,
 -1,
 1545147764,
 42339,
 1545362461,
 1544786319,
 42451,
 -1,
 1545310607,
 42375,
 1545493535,
 1545289863,
 42491,
 -1,
 1545420935,
 42262,
 -41952,
 1545457226,
 42412,
 -41951,
 1545560447,
 42299,
 -1,
 1545606516,
 42338,
 1545821234,
 1544693366,
 -1,
 1545886763,
 1545754763,
 -1,
 1545952294,
 1545834895,
 42434,
 -1,
 1545900431,
 42359,
 1546083368,
 1545879687,
 42473,
 -1,
 1546010759,
 42246,
 -41943,
 1546047050,
 42396,
 -41942,
 1546150271,
 42283,
 -1,
 1546196340,
 42321,
 1546411053,
 1545834895,
 42435,
 -1,
 1546359183,
 42360,
 1546542127,
 1546338439,
 42474,
 -1,
 1546469511,
 42247,
 -41936,
 1546505802,
 42397,
 -41935,
 1546609023,
 42284,
 -1,
 1546655092,
 42322,
 1546869823,
 1545754763,
 -1,
 1546935350,
 1546817935,
 42429,
 -41931,
 1546883471,
 42355,
 -1,
 1546946783,
 42430,
 1547131961,
 1546862727,
 42468,
 -41928,
 1547077855,
 42469,
 -1,
 1547124871,
 42242,
 1547328571,
 1547095626,
 42391,
 -1,
 1547274463,
 42392,
 1547459645,
 1547264383,
 42278,
 -1,
 1547405535,
 42279,
 1547632639,
 1547375988,
 42316,
 -1,
 1547536607,
 42317,
 1547721800,
 1546810200,
 -1,
 1547787331,
 1547649159,
 42487,
 -41918,
 1547734106,
 42508,
 -1,
 1547780231,
 42258,
 1547983941,
 1547735439,
 42447,
 -1,
 1547932047,
 42371,
 -41914,
 1547947594,
 42408,
 -41913,
 1548050815,
 42295,
 -1,
 1548096884,
 42334,
 1548311632,
 1547690990,
 -1,
 1548377163,
 1548259727,
 42458,
 -1,
 1548325263,
 42382,
 1548508237,
 1548304519,
 42498,
 -1,
 1548435591,
 42269,
 -41906,
 1548471882,
 42419,
 -41905,
 1548575103,
 42306,
 -1,
 1548621172,
 42345,
 1548835928,
 1548277678,
 -1,
 1548901459,
 1548784015,
 42442,
 -1,
 1548849551,
 42366,
 1549032533,
 1548828807,
 42482,
 -1,
 1548959879,
 42253,
 -41898,
 1548996170,
 42403,
 -41897,
 1549099391,
 42290,
 -1,
 1549145460,
 42329,
 1549360224,
 1548790100,
 -1,
 1549425755,
 1549308303,
 42448,
 -1,
 1549373839,
 42372,
 1549556829,
 1549353095,
 42488,
 -1,
 1549484167,
 42259,
 -41890,
 1549520458,
 42409,
 -41889,
 1549623679,
 42296,
 -1,
 1549669748,
 42335,
 1549884520,
 1549311977,
 -1,
 1549950051,
 1549832591,
 42433,
 -1,
 1549898127,
 42358,
 1550081125,
 1549877383,
 42472,
 -1,
 1550008455,
 42245,
 -41882,
 1550044746,
 42395,
 -41881,
 1550147967,
 42282,
 -1,
 1550194036,
 42320,
 1550408816,
 1549823785,
 -1,
 1550474347,
 1550356879,
 42456,
 -1,
 1550422415,
 42380,
 1550605421,
 1550401671,
 42496,
 -1,
 1550532743,
 42267,
 -41874,
 1550569034,
 42417,
 -41873,
 1550672255,
 42304,
 -1,
 1550718324,
 42343,
 1550933112,
 1550339670,
 -1,
 1550998643,
 1550881167,
 42441,
 -1,
 1550946703,
 42365,
 1551129717,
 1550925959,
 42481,
 -1,
 1551057031,
 42252,
 -41866,
 1551093322,
 42402,
 -41865,
 1551196543,
 42289,
 -1,
 1551242612,
 42328,
 1551457408,
 1550855390,
 -1,
 1551522939,
 1551405455,
 42455,
 -1,
 1551470991,
 42379,
 1551654013,
 1551450247,
 42495,
 -1,
 1551581319,
 42266,
 -41858,
 1551617610,
 42416,
 -41857,
 1551720831,
 42303,
 -1,
 1551766900,
 42342,
 1551981700,
 1551405455,
 42426,
 1552047235,
 1551929743,
 42353,
 -1,
 1551993055,
 42354,
 -1,
 1551993055,
 42427,
 1552243848,
 1551908999,
 42465,
 1552309383,
 1552171143,
 42240,
 -1,
 1552255199,
 42241,
 -1,
 1552255199,
 42466,
 1552505994,
 1552207434,
 42389,
 -1,
 1552451807,
 42390,
 1552637068,
 1552441727,
 42276,
 -1,
 1552582879,
 42277,
 1552809983,
 1552553332,
 42313,
 -1,
 1552713951,
 42314,
 1552941055,
 1532592886,
 -1,
 1552964755,
 1552859860,
 -1,
 -41839,
 1552913939,
 42525,
 -41838,
 1552967847,
 42517,
 -1,
 1553012215,
 42521,
 1553226904,
 1552889376,
 -1,
 1553292439,
 1553174927,
 -1,
 -41834,
 1553241619,
 42523,
 -1,
 1553272965,
 42526,
 -1,
 1553210976,
 42522,
 1553554587,
 1553166472,
 -1,
 -41830,
 1553519217,
 42524,
 -1,
 1553548122,
 42516,
 1553751198,
 1553485398,
 -1,
 -41827,
 1553679194,
 42515,
 -1,
 1553733111,
 42520,
 -41825,
 1553697968,
 42518,
 -41824,
 1553887289,
 42527,
 -1,
 1553934134,
 42519,
 1554144431,
 1532508568,
 -1,
 1554209957,
 1554105044,
 -1,
 -41820,
 1554178447,
 42530,
 -1,
 1554210902,
 42531,
 1554406568,
 1554167583,
 -1,
 -41817,
 1554345710,
 42534,
 -1,
 1554402434,
 42535,
 1554603179,
 1554337366,
 -1,
 -41814,
 1554553840,
 42532,
 -1,
 1554607735,
 42533,
 -41812,
 1554573205,
 42528,
 -41811,
 1554748863,
 42529,
 -41810,
 1554812092,
 42537,
 -1,
 1554859319,
 42536,
 -41808,
 1554098366,
 42511,
 -41807,
 1554993858,
 42510,
 -1,
 1555051023,
 42509,
 1555300351,
 1532472895,
 -1,
 1555324194,
 1555173903,
 65024,
 1555389631,
 1555240257,
 917762,
 -41802,
 1555305793,
 917942,
 -41801,
 1555371277,
 917941,
 -41800,
 1555436742,
 917940,
 -41799,
 1555502209,
 917939,
 -41798,
 1555567625,
 917938,
 -41797,
 1555633084,
 917937,
 -41796,
 1555698508,
 917936,
 -41795,
 1555763879,
 917935,
 -41794,
 1555829263,
 917934,
 -1,
 1555894671,
 917933,
 1556110538,
 1555305741,
 917761,
 -41791,
 1556026689,
 917932,
 -41790,
 1556092173,
 917931,
 -41789,
 1556157638,
 917930,
 -41788,
 1556223105,
 917929,
 -41787,
 1556288521,
 917928,
 -41786,
 1556353980,
 917927,
 -41785,
 1556419404,
 917926,
 -41784,
 1556484775,
 917925,
 -41783,
 1556550159,
 917924,
 -1,
 1556615567,
 917923,
 1556831445,
 1556026566,
 917760,
 -41780,
 1556747585,
 917922,
 -41779,
 1556813069,
 917921,
 -41778,
 1556878534,
 917920,
 -41777,
 1556944001,
 917919,
 -41776,
 1557009417,
 917918,
 -41775,
 1557074876,
 917917,
 -41774,
 1557140300,
 917916,
 -41773,
 1557205671,
 917915,
 -41772,
 1557271055,
 917914,
 -1,
 1557336463,
 917913,
 1557552352,
 1556747393,
 65039,
 -41769,
 1557468481,
 917912,
 -41768,
 1557533965,
 917911,
 -41767,
 1557599430,
 917910,
 -41766,
 1557664897,
 917909,
 -41765,
 1557730313,
 917908,
 -41764,
 1557795772,
 917907,
 -41763,
 1557861196,
 917906,
 -41762,
 1557926567,
 917905,
 -41761,
 1557991951,
 917904,
 -1,
 1558057359,
 917903,
 1558273259,
 1557468169,
 65038,
 -41758,
 1558189377,
 917902,
 -41757,
 1558254861,
 917901,
 -41756,
 1558320326,
 917900,
 -41755,
 1558385793,
 917899,
 -41754,
 1558451209,
 917898,
 -41753,
 1558516668,
 917897,
 -41752,
 1558582092,
 917896,
 -41751,
 1558647463,
 917895,
 -41750,
 1558712847,
 917894,
 -1,
 1558778255,
 917893,
 1558994166,
 1558188988,
 65037,
 -41747,
 1558910273,
 917892,
 -41746,
 1558975757,
 917891,
 -41745,
 1559041222,
 917890,
 -41744,
 1559106689,
 917889,
 -41743,
 1559172105,
 917888,
 -41742,
 1559237564,
 917887,
 -41741,
 1559302988,
 917886,
 -41740,
 1559368359,
 917885,
 -41739,
 1559433743,
 917884,
 -1,
 1559499151,
 917883,
 1559715073,
 1558909772,
 65036,
 -41736,
 1559631169,
 917882,
 -41735,
 1559696653,
 917881,
 -41734,
 1559762118,
 917880,
 -41733,
 1559827585,
 917879,
 -41732,
 1559893001,
 917878,
 -41731,
 1559958460,
 917877,
 -41730,
 1560023884,
 917876,
 -41729,
 1560089255,
 917875,
 -41728,
 1560154639,
 917874,
 -1,
 1560220047,
 917873,
 1560435980,
 1559630503,
 65035,
 -41725,
 1560352065,
 917872,
 -41724,
 1560417549,
 917871,
 -41723,
 1560483014,
 917870,
 -41722,
 1560548481,
 917869,
 -41721,
 1560613897,
 917868,
 -41720,
 1560679356,
 917867,
 -41719,
 1560744780,
 917866,
 -41718,
 1560810151,
 917865,
 -41717,
 1560875535,
 917864,
 -1,
 1560940943,
 917863,
 1561156887,
 1560351247,
 65034,
 -41714,
 1561072961,
 917862,
 -41713,
 1561138445,
 917861,
 -41712,
 1561203910,
 917860,
 -41711,
 1561269377,
 917859,
 -41710,
 1561334793,
 917858,
 -41709,
 1561400252,
 917857,
 -41708,
 1561465676,
 917856,
 -41707,
 1561531047,
 917855,
 -41706,
 1561596431,
 917854,
 -1,
 1561661839,
 917853,
 1561919487,
 1561072015,
 65033,
 -41703,
 1561793857,
 917852,
 -41702,
 1561859341,
 917851,
 -41701,
 1561924806,
 917850,
 -41700,
 1561990273,
 917849,
 -41699,
 1562055689,
 917848,
 -41698,
 1562121148,
 917847,
 -41697,
 1562186572,
 917846,
 -41696,
 1562251943,
 917845,
 -41695,
 1562317327,
 917844,
 -1,
 1562382735,
 917843,
 1562598758,
 1555239591,
 65025,
 1562664238,
 1562514364,
 917767,
 -41691,
 1562580289,
 917992,
 -41690,
 1562645773,
 917991,
 -41689,
 1562711238,
 917990,
 -41688,
 1562776705,
 917989,
 -41687,
 1562842121,
 917988,
 -41686,
 1562907580,
 917987,
 -41685,
 1562973004,
 917986,
 -41684,
 1563038375,
 917985,
 -41683,
 1563103759,
 917984,
 -1,
 1563169167,
 917983,
 1563385145,
 1562579788,
 917766,
 -41680,
 1563301185,
 917982,
 -41679,
 1563366669,
 917981,
 -41678,
 1563432134,
 917980,
 -41677,
 1563497601,
 917979,
 -41676,
 1563563017,
 917978,
 -41675,
 1563628476,
 917977,
 -41674,
 1563693900,
 917976,
 -41673,
 1563759271,
 917975,
 -41672,
 1563824655,
 917974,
 -1,
 1563890063,
 917973,
 1564106052,
 1563300519,
 917765,
 -41669,
 1564022081,
 917972,
 -41668,
 1564087565,
 917971,
 -41667,
 1564153030,
 917970,
 -41666,
 1564218497,
 917969,
 -41665,
 1564283913,
 917968,
 -41664,
 1564349372,
 917967,
 -41663,
 1564414796,
 917966,
 -41662,
 1564480167,
 917965,
 -41661,
 1564545551,
 917964,
 -1,
 1564610959,
 917963,
 1564826959,
 1564021263,
 917764,
 -41658,
 1564742977,
 917962,
 -41657,
 1564808461,
 917961,
 -41656,
 1564873926,
 917960,
 -41655,
 1564939393,
 917959,
 -41654,
 1565004809,
 917958,
 -41653,
 1565070268,
 917957,
 -41652,
 1565135692,
 917956,
 -41651,
 1565201063,
 917955,
 -41650,
 1565266447,
 917954,
 -1,
 1565331855,
 917953,
 1565547866,
 1564742031,
 917763,
 -41647,
 1565463873,
 917952,
 -41646,
 1565529357,
 917951,
 -41645,
 1565594822,
 917950,
 -41644,
 1565660289,
 917949,
 -41643,
 1565725705,
 917948,
 -41642,
 1565791164,
 917947,
 -41641,
 1565856588,
 917946,
 -41640,
 1565921959,
 917945,
 -41639,
 1565987343,
 917944,
 -1,
 1566052751,
 917943,
 1566268770,
 1565463561,
 917768,
 -41636,
 1566184577,
 917999,
 -41635,
 1566249993,
 917998,
 -41634,
 1566315452,
 917997,
 -41633,
 1566380876,
 917996,
 -41632,
 1566446247,
 917995,
 -41631,
 1566511631,
 917994,
 -1,
 1566577039,
 917993,
 -41629,
 1566184769,
 917772,
 -41628,
 1566709005,
 917771,
 -41627,
 1566774470,
 917770,
 -1,
 1566839937,
 917769,
 1567055217,
 1562514753,
 65032,
 -41624,
 1566971201,
 917842,
 -41623,
 1567036685,
 917841,
 -41622,
 1567102150,
 917840,
 -41621,
 1567167617,
 917839,
 -41620,
 1567233033,
 917838,
 -41619,
 1567298492,
 917837,
 -41618,
 1567363916,
 917836,
 -41617,
 1567429287,
 917835,
 -41616,
 1567494671,
 917834,
 -1,
 1567560079,
 917833,
 1567776124,
 1566971149,
 65031,
 -41613,
 1567692097,
 917832,
 -41612,
 1567757581,
 917831,
 -41611,
 1567823046,
 917830,
 -41610,
 1567888513,
 917829,
 -41609,
 1567953929,
 917828,
 -41608,
 1568019388,
 917827,
 -41607,
 1568084812,
 917826,
 -41606,
 1568150183,
 917825,
 -41605,
 1568215567,
 917824,
 -1,
 1568280975,
 917823,
 1568497031,
 1567691974,
 65030,
 -41602,
 1568412993,
 917822,
 -41601,
 1568478477,
 917821,
 -41600,
 1568543942,
 917820,
 -41599,
 1568609409,
 917819,
 -41598,
 1568674825,
 917818,
 -41597,
 1568740284,
 917817,
 -41596,
 1568805708,
 917816,
 -41595,
 1568871079,
 917815,
 -41594,
 1568936463,
 917814,
 -1,
 1569001871,
 917813,
 1569217938,
 1568412801,
 65029,
 -41591,
 1569133889,
 917812,
 -41590,
 1569199373,
 917811,
 -41589,
 1569264838,
 917810,
 -41588,
 1569330305,
 917809,
 -41587,
 1569395721,
 917808,
 -41586,
 1569461180,
 917807,
 -41585,
 1569526604,
 917806,
 -41584,
 1569591975,
 917805,
 -41583,
 1569657359,
 917804,
 -1,
 1569722767,
 917803,
 1569938845,
 1569133577,
 65028,
 -41580,
 1569854785,
 917802,
 -41579,
 1569920269,
 917801,
 -41578,
 1569985734,
 917800,
 -41577,
 1570051201,
 917799,
 -41576,
 1570116617,
 917798,
 -41575,
 1570182076,
 917797,
 -41574,
 1570247500,
 917796,
 -41573,
 1570312871,
 917795,
 -41572,
 1570378255,
 917794,
 -1,
 1570443663,
 917793,
 1570659752,
 1569854396,
 65027,
 -41569,
 1570575681,
 917792,
 -41568,
 1570641165,
 917791,
 -41567,
 1570706630,
 917790,
 -41566,
 1570772097,
 917789,
 -41565,
 1570837513,
 917788,
 -41564,
 1570902972,
 917787,
 -41563,
 1570968396,
 917786,
 -41562,
 1571033767,
 917785,
 -41561,
 1571099151,
 917784,
 -1,
 1571164559,
 917783,
 1571422207,
 1570575180,
 65026,
 -41558,
 1571296577,
 917782,
 -41557,
 1571362061,
 917781,
 -41556,
 1571427526,
 917780,
 -41555,
 1571492993,
 917779,
 -41554,
 1571558409,
 917778,
 -41553,
 1571623868,
 917777,
 -41552,
 1571689292,
 917776,
 -41551,
 1571754663,
 917775,
 -41550,
 1571820047,
 917774,
 -1,
 1571885455,
 917773,
 1572101637,
 1532379271,
 -1,
 1572167139,
 1572026718,
 -1,
 1572232654,
 1572125744,
 -1,
 1572298174,
 1572148596,
 -1,
 1572363709,
 1572245709,
 -1,
 1572429242,
 1572329463,
 7403,
 -1,
 1572343404,
 7404,
 -41541,
 1572392702,
 7409,
 -41540,
 1572480752,
 7402,
 -1,
 1572544348,
 7401,
 -1,
 1572318064,
 7410,
 1572822468,
 1572264925,
 -1,
 1572888001,
 1572786179,
 7395,
 -1,
 1572802156,
 7399,
 1573019075,
 1572806542,
 7397,
 -1,
 1572933228,
 7400,
 -1,
 1572979253,
 7394,
 1573215689,
 1572776276,
 -1,
 1573281224,
 1573145927,
 -1,
 -41529,
 1573244931,
 7396,
 -1,
 1573265294,
 7398,
 -1,
 1573242467,
 7408,
 -41526,
 1573184585,
 7380,
 -41525,
 1573505268,
 7405,
 -41524,
 1573555366,
 7379,
 -41523,
 1573616936,
 7407,
 -1,
 1573674094,
 7406,
 1573912575,
 1572194742,
 -1,
 1573936596,
 1573839933,
 -1,
 1574002130,
 1573876069,
 7383,
 -1,
 1573915133,
 7385,
 -41517,
 1573939171,
 7382,
 -1,
 1574049976,
 7381,
 1574264280,
 1573896916,
 -1,
 -41514,
 1574232502,
 7390,
 -41513,
 1574285916,
 7387,
 -1,
 1574330551,
 7391,
 1574526427,
 1574203551,
 -1,
 -41510,
 1574487594,
 7388,
 -1,
 1574548975,
 7376,
 1574723038,
 1574451908,
 -1,
 -41507,
 1574686569,
 7386,
 -1,
 1574748897,
 7389,
 -41505,
 1574681267,
 7377,
 -41504,
 1574875487,
 7392,
 -41503,
 1574938176,
 7378,
 -41502,
 1574972839,
 7384,
 -1,
 1575036118,
 7393,
 1575247363,
 1572120916,
 -1,
 1575312895,
 1575208898,
 -1,
 1575378413,
 1575254765,
 124,
 1575485439,
 1575288832,
 -1,
 1575509484,
 1575411570,
 -1,
 1575575019,
 1575432265,
 -1,
 -41494,
 1575495763,
 10992,
 -1,
 1575556725,
 10991,
 -1,
 1575519456,
 9087,
 -1,
 1575439919,
 9168,
 1575902708,
 1575317735,
 -1,
 1575968242,
 1575846490,
 12337,
 1576075263,
 1575878656,
 -1,
 -41487,
 1575998583,
 12339,
 -1,
 1576042119,
 12341,
 1576271871,
 1575936285,
 12338,
 -1,
 1576143875,
 12340,
 1576361465,
 1575823186,
 -1,
 -41482,
 1576329267,
 10186,
 -41481,
 1576389509,
 10978,
 -41480,
 1576418592,
 10980,
 -1,
 1576478973,
 10704,
 -41478,
 1576331301,
 10650,
 -41477,
 1576650748,
 11823,
 -41476,
 1576698115,
 9896,
 -41475,
 1576756193,
 12347,
 -41474,
 1576817149,
 8286,
 -1,
 1576879612,
 8942,
 1577082370,
 1575281651,
 -1,
 -41471,
 1577023823,
 8920,
 -1,
 1577080567,
 8921,
 -1,
 1577040904,
 8483,
 -41468,
 1575206958,
 9910,
 -1,
 1577268536,
 10799,
 1577475617,
 1572065510,
 -1,
 1577541138,
 1577424323,
 -1,
 1577606666,
 1577501396,
 -1,
 -41463,
 1577541025,
 8531,
 -1,
 1577601030,
 8530,
 1577803277,
 1577563935,
 -1,
 -41460,
 1577742087,
 8537,
 -1,
 1577798860,
 8528,
 -41458,
 1577756757,
 188,
 -41457,
 1577946345,
 8529,
 -41456,
 1577998731,
 189,
 -41455,
 1578061836,
 8533,
 -1,
 1578124612,
 8539,
 1578327578,
 1577501396,
 -1,
 1578393111,
 1578262619,
 -1,
 -41451,
 1578346615,
 190,
 -41450,
 1578389522,
 8535,
 -1,
 1578452325,
 8540,
 1578696703,
 1578361234,
 -1,
 -41447,
 1578616538,
 8532,
 -1,
 1578651666,
 8534,
 1578851871,
 1578258006,
 -1,
 1578917406,
 1578790523,
 -1,
 -41443,
 1578876227,
 8538,
 -1,
 1578911077,
 8541,
 -1,
 1578867749,
 8536,
 -41440,
 1578821568,
 8585,
 -1,
 1579137497,
 8542,
 1579310629,
 1577410943,
 -1,
 -41437,
 1579265500,
 9805,
 -41436,
 1579306336,
 8983,
 -1,
 1579365710,
 9996,
 -1,
 1579259063,
 8752,
 1579639077,
 1532311072,
 -1,
 1579704156,
 1579585935,
 -1,
 1579769503,
 1579648416,
 -1,
 1579834980,
 1579735599,
 -1,
 1579900515,
 1579749077,
 -1,
 1579966003,
 1579816122,
 -1,
 -41427,
 1579881601,
 127123,
 -41426,
 1579947017,
 127122,
 -41425,
 1580012476,
 127121,
 -41424,
 1580077900,
 127120,
 -41423,
 1580143271,
 127119,
 -41422,
 1580208655,
 127118,
 -1,
 1580274063,
 127117,
 1580490299,
 1579881568,
 -1,
 -41419,
 1580405889,
 127116,
 -41418,
 1580471305,
 127115,
 -41417,
 1580536764,
 127114,
 -41416,
 1580602188,
 127113,
 -41415,
 1580667559,
 127112,
 -41414,
 1580732943,
 127111,
 -1,
 1580798351,
 127110,
 1581014595,
 1580405749,
 -1,
 -41411,
 1580930177,
 127109,
 -41410,
 1580995593,
 127108,
 -41409,
 1581061052,
 127107,
 -41408,
 1581126476,
 127106,
 -41407,
 1581191847,
 127105,
 -41406,
 1581257231,
 127104,
 -1,
 1581322639,
 127103,
 1581538891,
 1580929966,
 -1,
 -41403,
 1581454465,
 127102,
 -41402,
 1581519881,
 127101,
 -41401,
 1581585340,
 127100,
 -41400,
 1581650764,
 127099,
 -41399,
 1581716135,
 127098,
 -41398,
 1581781519,
 127097,
 -1,
 1581846927,
 127096,
 1582063187,
 1581454116,
 -1,
 -41395,
 1581978753,
 127095,
 -41394,
 1582044169,
 127094,
 -41393,
 1582109628,
 127093,
 -41392,
 1582175052,
 127092,
 -41391,
 1582240423,
 127091,
 -41390,
 1582305807,
 127090,
 -1,
 1582371215,
 127089,
 1582587483,
 1581978248,
 -1,
 -41387,
 1582503041,
 127088,
 -41386,
 1582568457,
 127087,
 -41385,
 1582633916,
 127086,
 -41384,
 1582699340,
 127085,
 -41383,
 1582764711,
 127084,
 -41382,
 1582830095,
 127083,
 -1,
 1582895503,
 127082,
 1583153151,
 1582502401,
 -1,
 -41379,
 1583027329,
 127081,
 -41378,
 1583092745,
 127080,
 -41377,
 1583158204,
 127079,
 -41376,
 1583223628,
 127078,
 -41375,
 1583288999,
 127077,
 -41374,
 1583354383,
 127076,
 -1,
 1583419791,
 127075,
 -1,
 1579811327,
 127074,
 1583742975,
 1579769549,
 -1,
 1583767198,
 1583615701,
 -1,
 1583832686,
 1583682746,
 -1,
 -41368,
 1583748225,
 127073,
 -41367,
 1583813641,
 127072,
 -41366,
 1583879100,
 127071,
 -41365,
 1583944524,
 127070,
 -41364,
 1584009895,
 127069,
 -41363,
 1584075279,
 127068,
 -1,
 1584140687,
 127067,
 1584356982,
 1583748192,
 -1,
 -41360,
 1584272513,
 127066,
 -41359,
 1584337929,
 127065,
 -41358,
 1584403388,
 127064,
 -41357,
 1584468812,
 127063,
 -41356,
 1584534183,
 127062,
 -41355,
 1584599567,
 127061,
 -1,
 1584664975,
 127060,
 1584881278,
 1584272373,
 -1,
 -41352,
 1584796801,
 127059,
 -41351,
 1584862217,
 127058,
 -41350,
 1584927676,
 127057,
 -41349,
 1584993100,
 127056,
 -41348,
 1585058471,
 127055,
 -41347,
 1585123855,
 127054,
 -1,
 1585189263,
 127053,
 1585405574,
 1584796590,
 -1,
 -41344,
 1585321089,
 127052,
 -41343,
 1585386505,
 127051,
 -41342,
 1585451964,
 127050,
 -41341,
 1585517388,
 127049,
 -41340,
 1585582759,
 127048,
 -41339,
 1585648143,
 127047,
 -1,
 1585713551,
 127046,
 1585929870,
 1585320740,
 -1,
 -41336,
 1585845377,
 127045,
 -41335,
 1585910793,
 127044,
 -41334,
 1585976252,
 127043,
 -41333,
 1586041676,
 127042,
 -41332,
 1586107047,
 127041,
 -41331,
 1586172431,
 127040,
 -1,
 1586237839,
 127039,
 1586454166,
 1585844872,
 -1,
 -41328,
 1586369665,
 127038,
 -41327,
 1586435081,
 127037,
 -41326,
 1586500540,
 127036,
 -41325,
 1586565964,
 127035,
 -41324,
 1586631335,
 127034,
 -41323,
 1586696719,
 127033,
 -1,
 1586762127,
 127032,
 1587019775,
 1586369025,
 -1,
 -41320,
 1586893953,
 127031,
 -41319,
 1586959369,
 127030,
 -41318,
 1587024828,
 127029,
 -41317,
 1587090252,
 127028,
 -41316,
 1587155623,
 127027,
 -41315,
 1587221007,
 127026,
 -1,
 1587286415,
 127025,
 -1,
 1583677951,
 127024,
 1587568395,
 1579732772,
 -1,
 1587633894,
 1587478528,
 -1,
 1587699378,
 1587555550,
 -1,
 1587764913,
 1587637306,
 -1,
 1587830448,
 1587689880,
 -1,
 1587895975,
 1587790548,
 -1,
 -41306,
 1587863951,
 9462,
 -1,
 1587896406,
 9463,
 1588092586,
 1587853087,
 -1,
 -41303,
 1588031214,
 9466,
 -1,
 1588087938,
 9467,
 1588289197,
 1588022870,
 -1,
 -41300,
 1588239344,
 9464,
 -1,
 1588293239,
 9465,
 -41298,
 1588237759,
 9461,
 -41297,
 1588432060,
 9469,
 -1,
 1588479287,
 9468,
 -1,
 1587777619,
 9470,
 -1,
 1587713190,
 10868,
 1588813500,
 1587656479,
 -1,
 1588879031,
 1588776522,
 -1,
 -41291,
 1588830950,
 8913,
 -41290,
 1588866661,
 10940,
 -1,
 1588931598,
 8912,
 1589141178,
 1588832293,
 -1,
 -41287,
 1589105279,
 10831,
 -1,
 1589144116,
 10830,
 -41285,
 1589103578,
 10988,
 -1,
 1589285994,
 11005,
 1589468869,
 1588753240,
 -1,
 1589534404,
 1589416335,
 -1,
 1589599937,
 1589501192,
 -1,
 -41280,
 1589513947,
 8222,
 -1,
 1589577112,
 8215,
 1589837823,
 1589532033,
 -1,
 -41277,
 1589745654,
 10836,
 -1,
 1589779815,
 10835,
 -1,
 1589461923,
 10645,
 1590058700,
 1589434936,
 -1,
 1590124235,
 1589978962,
 -1,
 1590189770,
 1590049871,
 -1,
 -41271,
 1590145087,
 8875,
 -1,
 1590196242,
 10981,
 -1,
 1590130706,
 10979,
 -1,
 1590065901,
 8214,
 1590517458,
 1590009833,
 -1,
 1590582993,
 1590470996,
 -1,
 1590648528,
 1590519446,
 8243,
 -1,
 1590561179,
 12318,
 -1,
 1590575654,
 10939,
 -1,
 1590525797,
 10746,
 1590910678,
 1590463392,
 -1,
 1590976213,
 1590851919,
 10913,
 -1,
 1590890158,
 10915,
 -1,
 1590908663,
 10914,
 1591172825,
 1590873674,
 -1,
 -41256,
 1591124036,
 10987,
 -1,
 1591184623,
 8915,
 1591369436,
 1591110078,
 -1,
 -41253,
 1591326182,
 8914,
 -1,
 1591367301,
 8748,
 1591566047,
 1591293472,
 -1,
 -41250,
 1591517103,
 10986,
 -1,
 1591548082,
 8225,
 -41248,
 1591533089,
 65100,
 -41247,
 1591717518,
 10646,
 -41246,
 1591781566,
 8263,
 -41245,
 1591841289,
 11799,
 -41244,
 1591893328,
 8223,
 -41243,
 1591954810,
 8252,
 -1,
 1592006567,
 733,
 1592221448,
 1587547859,
 -1,
 1592286973,
 1592181100,
 -1,
 1592352498,
 1592208861,
 -1,
 1592418027,
 1592303593,
 8473,
 -1,
 1592353151,
 8511,
 -41236,
 1592387358,
 8484,
 -41235,
 1592502612,
 8477,
 -41234,
 1592567620,
 8474,
 -41233,
 1592625375,
 8469,
 -41232,
 1592678539,
 8461,
 -41231,
 1592742762,
 8510,
 -1,
 1592798430,
 8450,
 1593007865,
 1592290720,
 -1,
 1593073400,
 1592966540,
 -1,
 -41227,
 1593012009,
 8521,
 -41226,
 1593074047,
 8520,
 -41225,
 1593131143,
 8519,
 -1,
 1593194016,
 8518,
 -1,
 1592995302,
 8517,
 1593466620,
 1592966540,
 -1,
 -41221,
 1593418630,
 8508,
 -1,
 1593463658,
 8509,
 -1,
 1593411866,
 8512,
 1593728775,
 1592228594,
 -1,
 1593794308,
 1593687395,
 -1,
 1593859842,
 1593723152,
 -1,
 -41215,
 1593801039,
 10907,
 -1,
 1593857783,
 10908,
 -41213,
 1593801126,
 11001,
 -1,
 1593988977,
 11002,
 1594228735,
 1593723152,
 -1,
 -41210,
 1594128719,
 10905,
 -1,
 1594185463,
 10906,
 -1,
 1593657208,
 10719,
 1594490879,
 1592145442,
 -1,
 -41206,
 1594392825,
 9891,
 -1,
 1594445707,
 9890,
 1594646333,
 1587536206,
 -1,
 1594711860,
 1594613082,
 -1,
 1594777371,
 1594627444,
 -1,
 1594842906,
 1594734002,
 8595,
 1594949631,
 1594753024,
 -1,
 1594973975,
 1594875762,
 -1,
 1595039508,
 1594935515,
 -1,
 -41197,
 1594994836,
 8627,
 -1,
 1595045951,
 8626,
 -41195,
 1594974070,
 10504,
 -41194,
 1595162006,
 8671,
 -1,
 1595224947,
 8629,
 -41192,
 1594935609,
 10515,
 -41191,
 1595373712,
 8693,
 -1,
 1595429455,
 8615,
 -1,
 1594788439,
 11796,
 1595694889,
 1594710723,
 -1,
 1595760420,
 1595635333,
 -1,
 1595825955,
 1595670528,
 -1,
 1595891489,
 1595746484,
 -1,
 -41184,
 1595856220,
 10607,
 -1,
 1595883369,
 10597,
 -41182,
 1595853113,
 10585,
 -1,
 1596019279,
 10593,
 -1,
 1595792724,
 8643,
 1596325887,
 1595715169,
 -1,
 1596350248,
 1596194816,
 -1,
 -41177,
 1596311865,
 10581,
 -1,
 1596346959,
 10589,
 -1,
 1596317012,
 8642,
 1596612396,
 1595654868,
 -1,
 -41173,
 1596580425,
 8609,
 -1,
 1596633641,
 10507,
 1596809007,
 1596536352,
 -1,
 -41170,
 1596758855,
 8659,
 -1,
 1596793733,
 8675,
 -41168,
 1596778520,
 8623,
 -41167,
 1596972726,
 8681,
 -41166,
 1597024227,
 10225,
 -41165,
 1597087880,
 8650,
 -1,
 1597123075,
 11015,
 1597333306,
 1594621952,
 -1,
 1597398839,
 1597293401,
 8868,
 -1,
 1597312097,
 10993,
 -41160,
 1597353673,
 8945,
 -41159,
 1597460630,
 10623,
 -1,
 1597514402,
 8964,
 1597767679,
 1597247734,
 -1,
 -41156,
 1597681444,
 10729,
 -1,
 1597732607,
 10728,
 1597923148,
 1594606292,
 -1,
 1597988679,
 1597883598,
 -1,
 1598054210,
 1597910238,
 -1,
 -41151,
 1598010503,
 8284,
 -1,
 1598057500,
 9676,
 -41149,
 1598016179,
 11784,
 -41148,
 1598209879,
 11034,
 -41147,
 1598271579,
 11798,
 -41146,
 1598329339,
 11795,
 -1,
 1598377892,
 10649,
 1598619647,
 1597898752,
 -1,
 -41143,
 1598530636,
 8724,
 -41142,
 1598592896,
 8901,
 -41141,
 1598653867,
 8760,
 -1,
 1598690933,
 729,
 1598906202,
 1597852239,
 -1,
 1598971729,
 1598858718,
 -1,
 1599037264,
 1598898720,
 8832,
 -1,
 1598949055,
 8928,
 -1,
 1598987516,
 8876,
 1599233877,
 1598894793,
 -1,
 1599299412,
 1599180289,
 8939,
 -1,
 1599211199,
 8941,
 -1,
 1599243252,
 8716,
 1599496023,
 1599193498,
 8833,
 -1,
 1599407807,
 8929,
 1599627097,
 1599421027,
 8740,
 -1,
 1599540773,
 10990,
 -1,
 1599558018,
 8878,
 -41125,
 1598852048,
 8363,
 -1,
 1599765609,
 36,
 1599955084,
 1579630727,
 -1,
 1600020492,
 1599920131,
 -1,
 1600085954,
 1599961562,
 -1,
 1600151400,
 1600042783,
 -1,
 1600216934,
 1600084107,
 -1,
 1600282469,
 1600166286,
 -1,
 -41117,
 1600229775,
 2322,
 -41116,
 1600274567,
 2318,
 -1,
 1600329076,
 2308,
 -1,
 1600198004,
 2358,
 -41113,
 1600173977,
 2359,
 -1,
 1600525684,
 2360,
 1600741233,
 1600075296,
 -1,
 1600806767,
 1600665120,
 -1,
 1600872301,
 1600730656,
 -1,
 -41108,
 1600805033,
 2396,
 -1,
 1600853364,
 2430,
 -41106,
 1600805033,
 2338,
 -1,
 1600984436,
 2337,
 -41104,
 1600739497,
 2343,
 -1,
 1601115508,
 2342,
 1601331064,
 1600706478,
 -1,
 1601396599,
 1601278549,
 -1,
 1601462133,
 1601349972,
 2315,
 -1,
 1601415508,
 2400,
 1601634303,
 1601401688,
 2316,
 -1,
 1601532760,
 2401,
 -1,
 1601312116,
 2357,
 1601789823,
 1601276127,
 -1,
 1601855356,
 1601734879,
 -1,
 -41093,
 1601800507,
 2345,
 -1,
 1601836404,
 2339,
 -41091,
 1601823786,
 2334,
 -41090,
 1601983236,
 2329,
 -1,
 1602033012,
 2344,
 1602248582,
 1601721059,
 -1,
 1602314115,
 1602181259,
 -1,
 -41086,
 1602246825,
 2394,
 -1,
 1602295156,
 2328,
 -41084,
 1602256392,
 2429,
 -41083,
 1602441988,
 2427,
 -1,
 1602491764,
 2327,
 1602707341,
 1602170078,
 -1,
 1602772876,
 1602622836,
 2330,
 1602879487,
 1602718451,
 -1,
 -41078,
 1602785679,
 2321,
 -41077,
 1602830471,
 2317,
 -1,
 1602884980,
 2418,
 -1,
 1602705577,
 2331,
 1603166099,
 1602667220,
 -1,
 1603231633,
 1603125972,
 -1,
 -41072,
 1603164329,
 2336,
 -1,
 1603212660,
 2335,
 -41070,
 1603164329,
 2341,
 -1,
 1603343732,
 2340,
 1603559319,
 1603081588,
 2309,
 -41067,
 1603522122,
 2324,
 -41066,
 1603559807,
 2320,
 -1,
 1603605876,
 2310,
 1603821467,
 1603512660,
 -1,
 -41063,
 1603774895,
 2353,
 -41062,
 1603819689,
 2397,
 -1,
 1603868020,
 2352,
 1604083616,
 1603760984,
 -1,
 1604149151,
 1604023128,
 -1,
 -41058,
 1604088749,
 2356,
 -1,
 1604130164,
 2355,
 -1,
 1604064628,
 2354,
 1604411301,
 1604022408,
 -1,
 1604476836,
 1604343947,
 -1,
 -41053,
 1604409513,
 2393,
 -1,
 1604457844,
 2326,
 -1,
 1604392308,
 2325,
 1604738985,
 1604349737,
 -1,
 -41049,
 1604677419,
 2428,
 -41048,
 1604737193,
 2333,
 -1,
 1604785524,
 2332,
 1605001133,
 1604658806,
 -1,
 -41045,
 1604933801,
 2349,
 -41044,
 1604986536,
 2431,
 -1,
 1605047668,
 2348,
 1605263280,
 1604970270,
 -1,
 -41041,
 1605195945,
 2425,
 -1,
 1605244276,
 2395,
 1605459891,
 1605231598,
 -1,
 -41038,
 1605428266,
 2399,
 -1,
 1605440884,
 2351,
 1605656501,
 1605422666,
 2313,
 -1,
 1605619274,
 2314,
 1605787576,
 1605607401,
 -1,
 -41033,
 1605720233,
 2347,
 -1,
 1605768564,
 2346,
 1605984186,
 1605722495,
 2311,
 -1,
 1605919103,
 2312,
 1606115261,
 1605916811,
 -1,
 -41028,
 1606042106,
 2426,
 -1,
 1606096244,
 2361,
 -41026,
 1606068042,
 2392,
 -41025,
 1606259087,
 2323,
 -41024,
 1606320178,
 2350,
 -41023,
 1606373055,
 2398,
 -1,
 1606434951,
 2319,
 1606639578,
 1600052406,
 -1,
 1606705096,
 1606605839,
 -1,
 1606770630,
 1606658388,
 2371,
 -1,
 1606723924,
 2372,
 1606942719,
 1606710104,
 2402,
 -1,
 1606841176,
 2403,
 1607032780,
 1606626719,
 -1,
 -41014,
 1606979983,
 2377,
 -41013,
 1607040319,
 2389,
 -1,
 1607090311,
 2373,
 1607294928,
 1606948212,
 -1,
 -41010,
 1607257674,
 2380,
 -41009,
 1607295359,
 2376,
 -1,
 1607341428,
 2366,
 1607557074,
 1607257674,
 2369,
 -1,
 1607519818,
 2370,
 1607688149,
 1607514973,
 -1,
 -41004,
 1607635343,
 2378,
 -1,
 1607680135,
 2374,
 1607884759,
 1607623039,
 2367,
 -1,
 1607819647,
 2368,
 -41000,
 1607837325,
 2382,
 -40999,
 1607963023,
 2379,
 -1,
 1608007815,
 2375,
 1608212466,
 1606596383,
 -1,
 1608277999,
 1608148361,
 -1,
 1608343523,
 1608199604,
 2305,
 1608450047,
 1608253440,
 -1,
 1608474593,
 1608368852,
 -1,
 -40992,
 1608442255,
 43253,
 -1,
 1608474710,
 43254,
 -40990,
 1608440771,
 43251,
 -1,
 1608590812,
 43255,
 1608802278,
 1608309605,
 -1,
 -40987,
 1608759333,
 2307,
 -1,
 1608821389,
 2381,
 1608998889,
 1608717684,
 -1,
 -40984,
 1608964037,
 2365,
 -1,
 1609011397,
 2306,
 -40982,
 1608957694,
 43250,
 -40981,
 1609148209,
 43256,
 -40980,
 1609207861,
 2364,
 -40979,
 1609263855,
 2304,
 -40978,
 1609325834,
 2417,
 -1,
 1609383091,
 43252,
 1609629695,
 1608239834,
 -1,
 -40975,
 1609551875,
 2385,
 -1,
 1609572238,
 2386,
 1609785347,
 1608136224,
 -1,
 1609850881,
 1609721210,
 -1,
 1609916407,
 1609810644,
 -1,
 -40970,
 1609884047,
 2408,
 -1,
 1609916502,
 2409,
 1610113018,
 1609873183,
 -1,
 -40967,
 1610051310,
 2412,
 -1,
 1610108034,
 2413,
 1610309629,
 1610042966,
 -1,
 -40964,
 1610259440,
 2410,
 -1,
 1610313335,
 2411,
 -40962,
 1610278805,
 2406,
 -40961,
 1610454463,
 2407,
 -40960,
 1610517692,
 2415,
 -1,
 1610564919,
 2414,
 -40958,
 1609800547,
 2405,
 -1,
 1610686016,
 2404,
 1610899462,
 1609716451,
 -1,
 -40955,
 1610853129,
 2387,
 -1,
 1610882989,
 43257,
 1611096073,
 1610814836,
 -1,
 -40952,
 1611019771,
 2388,
 -1,
 1611081734,
 2416,
 -40950,
 1611044038,
 2384,
 -40949,
 1611225929,
 43259,
 -1,
 1611279902,
 43258,
 1611489389,
 1599977247,
 -1,
 1611554924,
 1611418048,
 -1,
 1611620413,
 1611513354,
 -1,
 1611685914,
 1611546759,
 -1,
 1611751442,
 1611642655,
 66629,
 -1,
 1611683979,
 66631,
 1611882516,
 1611696351,
 66636,
 -1,
 1611813603,
 66637,
 -40939,
 1611848968,
 66639,
 -40938,
 1611974159,
 66627,
 -40937,
 1612032340,
 66633,
 -40936,
 1612087269,
 66635,
 -40935,
 1612149592,
 66634,
 -1,
 1612205654,
 66625,
 1612406817,
 1611643741,
 -1,
 1612472349,
 1612353935,
 66610,
 -1,
 1612419471,
 66611,
 1612603423,
 1612387700,
 66608,
 -1,
 1612535947,
 66609,
 -40928,
 1612538239,
 66606,
 -1,
 1612660871,
 66607,
 1612865576,
 1612348706,
 -1,
 1612931108,
 1612812687,
 66604,
 -1,
 1612878223,
 66605,
 1613062182,
 1612846452,
 66602,
 -1,
 1612994699,
 66603,
 -40921,
 1612996991,
 66600,
 -1,
 1613119623,
 66601,
 1613324331,
 1612834590,
 -1,
 -40918,
 1613257711,
 66632,
 -1,
 1613316903,
 66630,
 1613520942,
 1613284052,
 -1,
 -40915,
 1613454319,
 66628,
 -1,
 1613513511,
 66619,
 1613717553,
 1613468047,
 -1,
 -40912,
 1613683976,
 66613,
 -1,
 1613717887,
 66638,
 -40910,
 1613685966,
 66615,
 -40909,
 1613882087,
 66614,
 -40908,
 1613945180,
 66626,
 -40907,
 1613996504,
 66617,
 -40906,
 1614049682,
 66623,
 -40905,
 1614114687,
 66622,
 -40904,
 1614174347,
 66616,
 -40903,
 1614238703,
 66624,
 -40902,
 1614296939,
 66620,
 -40901,
 1614360455,
 66621,
 -40900,
 1614424103,
 66618,
 -1,
 1614489144,
 66612,
 1614741503,
 1611542020,
 -1,
 1614766153,
 1614626951,
 -1,
 1614831681,
 1614722847,
 66589,
 -1,
 1614764171,
 66591,
 1614962755,
 1614776543,
 66596,
 -1,
 1614893795,
 66597,
 -40892,
 1614929160,
 66599,
 -40891,
 1615054351,
 66587,
 -40890,
 1615112532,
 66593,
 -40889,
 1615167461,
 66595,
 -40888,
 1615229784,
 66594,
 -1,
 1615285846,
 66585,
 1615487056,
 1614723933,
 -1,
 1615552588,
 1615434127,
 66570,
 -1,
 1615499663,
 66571,
 1615683662,
 1615467892,
 66568,
 -1,
 1615616139,
 66569,
 -40881,
 1615618431,
 66566,
 -1,
 1615741063,
 66567,
 1615945815,
 1615428898,
 -1,
 1616011347,
 1615892879,
 66564,
 -1,
 1615958415,
 66565,
 1616142421,
 1615926644,
 66562,
 -1,
 1616074891,
 66563,
 -40874,
 1616077183,
 66560,
 -1,
 1616199815,
 66561,
 1616404570,
 1615914782,
 -1,
 -40871,
 1616337903,
 66592,
 -1,
 1616397095,
 66590,
 1616601181,
 1616364244,
 -1,
 -40868,
 1616534511,
 66588,
 -1,
 1616593703,
 66579,
 1616797792,
 1616548239,
 -1,
 -40865,
 1616764168,
 66573,
 -1,
 1616798079,
 66598,
 -40863,
 1616766158,
 66575,
 -40862,
 1616962279,
 66574,
 -40861,
 1617025372,
 66586,
 -40860,
 1617076696,
 66577,
 -40859,
 1617129874,
 66583,
 -40858,
 1617194879,
 66582,
 -40857,
 1617254539,
 66576,
 -40856,
 1617318895,
 66584,
 -40855,
 1617377131,
 66580,
 -40854,
 1617440647,
 66581,
 -40853,
 1617504295,
 66578,
 -1,
 1617569336,
 66572,
 -1,
 1611476686,
 9739,
 1617846404,
 1611435982,
 -1,
 1617911930,
 1617812024,
 -1,
 1617977463,
 1617829227,
 -1,
 1618042995,
 1617938947,
 -1,
 -40846,
 1617997409,
 9150,
 -1,
 1618048645,
 9163,
 1618239606,
 1617963736,
 -1,
 -40843,
 1618194017,
 9151,
 -1,
 1618245253,
 9164,
 -1,
 1618206210,
 9158,
 1618542591,
 1617944434,
 -1,
 -40839,
 1618463482,
 9155,
 -1,
 1618489410,
 9152,
 1618698367,
 1617875731,
 9162,
 1618804735,
 1618611235,
 -1,
 -40835,
 1618730498,
 9160,
 -40834,
 1618791162,
 9157,
 -1,
 1618817090,
 9154,
 1619066879,
 1618624068,
 9161,
 1619132415,
 1618938915,
 -1,
 -40830,
 1619058178,
 9159,
 -40829,
 1619118842,
 9156,
 -1,
 1619144770,
 9153,
 1619353736,
 1617778588,
 -1,
 -40826,
 1619311659,
 176,
 -40825,
 1619349211,
 8457,
 -1,
 1619406534,
 8451,
 1619615883,
 1619275835,
 -1,
 -40822,
 1619573128,
 9110,
 -1,
 1619611026,
 9192,
 -1,
 1619558136,
 8796,
 1619878168,
 1599889791,
 -1,
 1619943624,
 1619808995,
 -1,
 1620009146,
 1619881346,
 -1,
 1620074648,
 1619968724,
 -1,
 1620140180,
 1620042127,
 50,
 1620246527,
 1620049920,
 -1,
 -40813,
 1620136642,
 9353,
 -1,
 1620193807,
 127235,
 1620443135,
 1620074582,
 51,
 1620508671,
 1620312064,
 -1,
 -40809,
 1620398786,
 9354,
 -1,
 1620455951,
 127236,
 1620664481,
 1620031263,
 -1,
 1620730013,
 1620602606,
 54,
 1620836351,
 1620639744,
 -1,
 -40804,
 1620726466,
 9357,
 -1,
 1620783631,
 127239,
 1621032959,
 1620659330,
 55,
 1621098495,
 1620901888,
 -1,
 -40800,
 1620988610,
 9358,
 -1,
 1621045775,
 127240,
 1621254314,
 1620594262,
 -1,
 1621319846,
 1621203952,
 52,
 1621426175,
 1621229568,
 -1,
 -40795,
 1621316290,
 9355,
 -1,
 1621373455,
 127237,
 1621622783,
 1621257847,
 53,
 1621688319,
 1621491712,
 -1,
 -40791,
 1621578434,
 9356,
 -1,
 1621635599,
 127238,
 1621844142,
 1621223317,
 48,
 1621950463,
 1621753856,
 -1,
 -40787,
 1621840578,
 127232,
 -1,
 1621897743,
 127233,
 1622106290,
 1621792191,
 49,
 1622212607,
 1622016000,
 -1,
 -40783,
 1622102722,
 9352,
 -1,
 1622159887,
 127234,
 1622368438,
 1622052028,
 57,
 1622474751,
 1622278144,
 -1,
 -40779,
 1622364866,
 9360,
 -1,
 1622422031,
 127242,
 1622671359,
 1622295863,
 56,
 1622736895,
 1622540288,
 -1,
 -40775,
 1622627010,
 9359,
 -1,
 1622684175,
 127241,
 1622933503,
 1619962500,
 -1,
 1622958271,
 1622819172,
 119557,
 1623064575,
 1622900671,
 -1,
 -40770,
 1622987163,
 119556,
 -1,
 1623015860,
 119555,
 1623220418,
 1622899132,
 -1,
 -40767,
 1623156528,
 9869,
 -1,
 1623203424,
 9870,
 1623417029,
 1623152779,
 -1,
 -40764,
 1623380384,
 119554,
 -1,
 1623409082,
 119553,
 1623654399,
 1623348973,
 -1,
 -40761,
 1623549744,
 9871,
 -1,
 1623596640,
 9868,
 1623810294,
 1619889139,
 -1,
 1623875815,
 1623755574,
 -1,
 1623941337,
 1623832592,
 -1,
 1624006872,
 1623865752,
 -1,
 1624072399,
 1623966420,
 -1,
 -40754,
 1624039823,
 10123,
 -1,
 1624072278,
 10124,
 1624269010,
 1624028959,
 -1,
 -40751,
 1624207086,
 10127,
 -1,
 1624263810,
 10128,
 1624465621,
 1624198742,
 -1,
 -40748,
 1624415216,
 10125,
 -1,
 1624469111,
 10126,
 -40746,
 1624413631,
 10122,
 -40745,
 1624607932,
 10130,
 -1,
 1624655159,
 10129,
 -1,
 1623953491,
 10131,
 1624924390,
 1623865752,
 -1,
 1624989917,
 1624883924,
 -1,
 -40740,
 1624957327,
 10103,
 -1,
 1624989782,
 10104,
 1625186528,
 1624946463,
 -1,
 -40737,
 1625124590,
 10107,
 -1,
 1625181314,
 10108,
 1625383139,
 1625116246,
 -1,
 -40734,
 1625332720,
 10105,
 -1,
 1625386615,
 10106,
 -40732,
 1625331135,
 10102,
 -40731,
 1625525436,
 10110,
 -1,
 1625572663,
 10109,
 -1,
 1624870995,
 10111,
 1625882623,
 1623797905,
 -1,
 1625907445,
 1625766296,
 -1,
 1625972972,
 1625866964,
 -1,
 -40725,
 1625940367,
 10113,
 -1,
 1625972822,
 10114,
 1626169583,
 1625929503,
 -1,
 -40722,
 1626107630,
 10117,
 -1,
 1626164354,
 10118,
 1626366194,
 1626099286,
 -1,
 -40719,
 1626315760,
 10115,
 -1,
 1626369655,
 10116,
 -40717,
 1626314175,
 10112,
 -40716,
 1626508476,
 10120,
 -1,
 1626555703,
 10119,
 -1,
 1625854035,
 10121,
 1626824961,
 1623725428,
 -1,
 1626890496,
 1626767333,
 -1,
 1626956031,
 1626838458,
 -1,
 1627021566,
 1626922866,
 -1,
 -40709,
 1626982931,
 11032,
 -40708,
 1627041572,
 11031,
 -40707,
 1627092735,
 11030,
 -1,
 1627138798,
 11033,
 -1,
 1626969984,
 8900,
 -1,
 1626885080,
 8960,
 -1,
 1626818996,
 168,
 1627545864,
 1626751116,
 -1,
 -40701,
 1627460737,
 9861,
 -40700,
 1627526153,
 9860,
 -40699,
 1627591612,
 9859,
 -40698,
 1627657036,
 9858,
 -40697,
 1627722407,
 9857,
 -1,
 1627787791,
 9856,
 1628004625,
 1627510702,
 -1,
 1628070160,
 1627939199,
 -1,
 1628135695,
 1628028164,
 -1,
 1628201230,
 1628092191,
 -1,
 -40691,
 1628140930,
 8725,
 -1,
 1628202373,
 247,
 -1,
 1628162110,
 8903,
 -1,
 1628059658,
 8739,
 -1,
 1628018798,
 9902,
 1628594452,
 1627961119,
 -1,
 -40685,
 1628517138,
 9090,
 -1,
 1628575325,
 9933,
 -40683,
 1628556398,
 12291,
 -40682,
 1628744682,
 9107,
 -40681,
 1628800012,
 9009,
 -1,
 1628852158,
 8783,
 1629053216,
 1619793268,
 -1,
 1629118749,
 1629010656,
 -1,
 -40677,
 1629080323,
 10143,
 -40676,
 1629134555,
 65097,
 -1,
 1629191720,
 65101,
 -40674,
 1629074255,
 9619,
 -40673,
 1629321669,
 8504,
 -1,
 1629377689,
 8224,
 1629618175,
 1629006164,
 -1,
 1629643044,
 1629492596,
 -1,
 -40669,
 1629573768,
 10139,
 -1,
 1629630401,
 8367,
 -1,
 1629580983,
 9946,
 1629905753,
 1579585935,
 -1,
 1629971027,
 1629844312,
 -1,
 1630036499,
 1629894178,
 -1,
 1630101881,
 1629998284,
 -1,
 1630167383,
 1630050622,
 -1,
 1630232897,
 1630082420,
 68608,
 1630298422,
 1630158983,
 -1,
 -40659,
 1630266350,
 68632,
 -40658,
 1630323412,
 68677,
 -40657,
 1630385951,
 68670,
 -40656,
 1630447956,
 68668,
 -40655,
 1630505183,
 68644,
 -40654,
 1630565208,
 68640,
 -40653,
 1630630024,
 68634,
 -40652,
 1630687971,
 68623,
 -40651,
 1630746144,
 68627,
 -1,
 1630807670,
 68619,
 1631019320,
 1630254879,
 68669,
 -1,
 1630951563,
 68671,
 -40647,
 1630987246,
 68630,
 -40646,
 1631109844,
 68675,
 -40645,
 1631168852,
 68666,
 -40644,
 1631233860,
 68660,
 -40643,
 1631291615,
 68643,
 -40642,
 1631351640,
 68638,
 -40641,
 1631408867,
 68621,
 -40640,
 1631467040,
 68625,
 -1,
 1631528566,
 68617,
 1631740237,
 1630158983,
 -1,
 1631805767,
 1631684831,
 -1,
 -40636,
 1631773678,
 68650,
 -40635,
 1631830740,
 68646,
 -40634,
 1631867619,
 68653,
 -1,
 1631923422,
 68648,
 -40632,
 1631774494,
 68628,
 -40631,
 1632090643,
 68673,
 -40630,
 1632149481,
 68655,
 -40629,
 1632206821,
 68642,
 -40628,
 1632272101,
 68641,
 -1,
 1632316638,
 68658,
 1632526675,
 1631687055,
 68614,
 1632592208,
 1632452743,
 68615,
 -1,
 1632530568,
 68636,
 -40623,
 1632551636,
 68679,
 -40622,
 1632675652,
 68664,
 -1,
 1632739305,
 68656,
 1632919894,
 1632461183,
 68611,
 -40619,
 1632872260,
 68662,
 -1,
 1632906462,
 68657,
 -1,
 1632839634,
 68680,
 1633222655,
 1630135614,
 -1,
 1633247595,
 1633097076,
 68609,
 1633313121,
 1633173639,
 68610,
 1633378652,
 1633257695,
 68645,
 -1,
 1633309411,
 68654,
 -40611,
 1633346542,
 68633,
 -40610,
 1633469140,
 68678,
 -40609,
 1633513608,
 68635,
 -40608,
 1633571555,
 68624,
 -1,
 1633625718,
 68620,
 -40606,
 1633281006,
 68631,
 -40605,
 1633796820,
 68676,
 -40604,
 1633860115,
 68672,
 -40603,
 1633921364,
 68667,
 -40602,
 1633986372,
 68661,
 -40601,
 1634044855,
 68652,
 -40600,
 1634104152,
 68639,
 -40599,
 1634161379,
 68622,
 -40598,
 1634219552,
 68626,
 -1,
 1634281078,
 68618,
 1634492787,
 1633173639,
 68613,
 1634558320,
 1634437343,
 -1,
 -40594,
 1634526190,
 68651,
 -40593,
 1634583252,
 68647,
 -1,
 1634610398,
 68649,
 -40591,
 1634527006,
 68629,
 -40590,
 1634777619,
 68674,
 -1,
 1634807006,
 68659,
 1635017079,
 1634439567,
 -1,
 1635082614,
 1634943111,
 68616,
 -1,
 1635020936,
 68637,
 -1,
 1635034948,
 68665,
 1635319807,
 1634951551,
 68612,
 -1,
 1635231556,
 68663,
 1635410364,
 1630053134,
 -1,
 1635475891,
 1635367984,
 -1,
 1635541377,
 1635399200,
 -1,
 1635606911,
 1635456372,
 66477,
 1635713023,
 1635541344,
 66508,
 -1,
 1635585752,
 66509,
 -40576,
 1635569226,
 66479,
 -1,
 1635737983,
 66478,
 1635934597,
 1635456372,
 66464,
 1636040703,
 1635898795,
 66504,
 -40572,
 1635932329,
 66506,
 -1,
 1635978968,
 66505,
 1636196745,
 1635893972,
 -1,
 -40569,
 1636159050,
 66476,
 -40568,
 1636194473,
 66480,
 -1,
 1636242804,
 66475,
 1636458893,
 1636153119,
 -1,
 -40565,
 1636415385,
 66498,
 -40564,
 1636456617,
 66497,
 -1,
 1636504948,
 66495,
 1636721041,
 1636401125,
 -1,
 -40561,
 1636683338,
 66488,
 -40560,
 1636721023,
 66487,
 -1,
 1636767092,
 66486,
 1636983189,
 1636640374,
 -1,
 1637048724,
 1636898164,
 66482,
 -1,
 1636979460,
 66510,
 -1,
 1637013373,
 66511,
 1637245336,
 1636950788,
 -1,
 -40553,
 1637202523,
 66507,
 -1,
 1637225844,
 66471,
 1637441947,
 1637210030,
 -1,
 -40550,
 1637376383,
 66491,
 -1,
 1637422452,
 66490,
 1637638558,
 1637394772,
 -1,
 -40547,
 1637600842,
 66493,
 -1,
 1637619060,
 66492,
 1637835169,
 1637583071,
 -1,
 -40544,
 1637797450,
 66485,
 -1,
 1637815668,
 66484,
 1638031780,
 1637773448,
 -1,
 -40541,
 1637994058,
 66468,
 -1,
 1638012276,
 66467,
 1638228391,
 1637969705,
 -1,
 -40538,
 1638162815,
 66474,
 -1,
 1638208884,
 66473,
 1638425002,
 1638159075,
 -1,
 -40535,
 1638387274,
 66470,
 -1,
 1638405492,
 66469,
 -40533,
 1638393648,
 66496,
 -40532,
 1638589482,
 66489,
 -40531,
 1638649418,
 66466,
 -40530,
 1638703182,
 66481,
 -40529,
 1638757293,
 66494,
 -40528,
 1638818175,
 66465,
 -40527,
 1638881449,
 66499,
 -40526,
 1638944447,
 66483,
 -1,
 1639001403,
 66472,
 1639211451,
 1635422271,
 -1,
 1639276985,
 1639170772,
 -1,
 1639342520,
 1639243016,
 -1,
 -40521,
 1639289231,
 66514,
 -1,
 1639336015,
 66516,
 -1,
 1639270129,
 66515,
 -40518,
 1639224767,
 66513,
 -1,
 1639538967,
 66517,
 -1,
 1639178940,
 66512,
 1639801318,
 1635347872,
 -1,
 1639866848,
 1639741914,
 -1,
 1639932360,
 1639792775,
 66308,
 1639997889,
 1639888671,
 66324,
 -1,
 1639929995,
 66318,
 1640128963,
 1639950676,
 66323,
 -1,
 1640085279,
 66331,
 -40508,
 1640073439,
 66317,
 -40507,
 1640202213,
 66316,
 -40506,
 1640264536,
 66315,
 -40505,
 1640329961,
 66327,
 -1,
 1640386134,
 66330,
 1640587725,
 1639870600,
 -1,
 -40502,
 1640549962,
 66322,
 -40501,
 1640586024,
 66329,
 -40500,
 1640644743,
 66306,
 -1,
 1640699252,
 66314,
 1640915407,
 1640549962,
 66326,
 -1,
 1640877642,
 66334,
 1641046482,
 1640874708,
 -1,
 -40495,
 1640979240,
 66312,
 -1,
 1641037959,
 66325,
 1641243093,
 1640996841,
 -1,
 -40492,
 1641175848,
 66328,
 -1,
 1641234567,
 66320,
 1641439703,
 1641177471,
 66313,
 -1,
 1641374079,
 66333,
 -40488,
 1641408373,
 66310,
 -40487,
 1641535732,
 66309,
 -40486,
 1641593559,
 66321,
 -40485,
 1641648527,
 66319,
 -40484,
 1641700136,
 66311,
 -40483,
 1641756490,
 66307,
 -40482,
 1641820012,
 66332,
 -40481,
 1641883671,
 66305,
 -1,
 1641944436,
 66304,
 1642201087,
 1639813226,
 -1,
 1642226148,
 1642090505,
 -1,
 -40477,
 1642191092,
 66337,
 -1,
 1642222270,
 66339,
 -40475,
 1642186022,
 66338,
 -1,
 1642370495,
 66336,
 1642594303,
 1639759565,
 -1,
 1642619406,
 1642494426,
 -1,
 1642684910,
 1642578644,
 -1,
 1642750444,
 1642616971,
 -1,
 -40469,
 1642679266,
 68220,
 -1,
 1642735125,
 68219,
 -40467,
 1642679266,
 68215,
 -1,
 1642866197,
 68201,
 1643078132,
 1642641183,
 -1,
 1643143667,
 1642993012,
 -1,
 -40463,
 1643102932,
 68202,
 -40462,
 1643152340,
 68207,
 -1,
 1643198599,
 68206,
 -1,
 1643076995,
 68198,
 1643471353,
 1643001376,
 -1,
 1643536888,
 1643403433,
 -1,
 -40457,
 1643477461,
 68217,
 -1,
 1643526279,
 68211,
 -1,
 1643453252,
 68213,
 1643799036,
 1643409544,
 -1,
 -40453,
 1643732067,
 68205,
 -1,
 1643782083,
 68203,
 1643995646,
 1643731752,
 68192,
 -1,
 1643955727,
 68194,
 1644126721,
 1643926243,
 -1,
 -40448,
 1644062362,
 68212,
 -1,
 1644124963,
 68214,
 1644323332,
 1644041588,
 -1,
 -40445,
 1644291603,
 68210,
 -1,
 1644328572,
 68209,
 -40443,
 1644291952,
 68216,
 -40442,
 1644488255,
 68218,
 -40441,
 1644551727,
 68197,
 -40440,
 1644604685,
 68199,
 -40439,
 1644668856,
 68196,
 -40438,
 1644728487,
 68204,
 -40437,
 1644790759,
 68195,
 -40436,
 1644852459,
 68193,
 -40435,
 1644908326,
 68208,
 -1,
 1644964143,
 68200,
 1645215743,
 1642565691,
 -1,
 1645240850,
 1645095039,
 -1,
 -40431,
 1645188543,
 68221,
 -1,
 1645236249,
 68222,
 -1,
 1645169094,
 68223,
 1645543423,
 1629946509,
 -1,
 1645568570,
 1645443546,
 -1,
 1645634079,
 1645483380,
 -1,
 1645699611,
 1645548916,
 -1,
 -40424,
 1645665544,
 7267,
 -40423,
 1645707237,
 7266,
 -40422,
 1645768840,
 7264,
 -1,
 1645834025,
 7265,
 -40420,
 1645658836,
 7259,
 -40419,
 1645972407,
 7261,
 -40418,
 1646031704,
 7262,
 -1,
 1646088931,
 7260,
 1646289446,
 1645572952,
 -1,
 1646354978,
 1646204276,
 7258,
 -1,
 1646269812,
 7263,
 -40413,
 1646317130,
 7273,
 -40412,
 1646432655,
 7283,
 -40411,
 1646485887,
 7268,
 -1,
 1646542983,
 7278,
 1646748203,
 1646251594,
 -1,
 -40408,
 1646715886,
 7277,
 -40407,
 1646759290,
 7276,
 -40406,
 1646802464,
 7275,
 -1,
 1646865630,
 7274,
 1647075888,
 1646694799,
 -1,
 -40403,
 1647040430,
 7286,
 -40402,
 1647103000,
 7284,
 -40401,
 1647138955,
 7287,
 -1,
 1647191670,
 7285,
 1647403573,
 1647010175,
 -1,
 -40398,
 1647359775,
 7269,
 -40397,
 1647421780,
 7272,
 -40396,
 1647481146,
 7271,
 -1,
 1647532171,
 7270,
 1647771647,
 1647329415,
 -1,
 -40393,
 1647687013,
 7282,
 -40392,
 1647747049,
 7279,
 -40391,
 1647806687,
 7281,
 -1,
 1647851324,
 7280,
 1648058952,
 1645492632,
 -1,
 1648124478,
 1648018132,
 -1,
 -40387,
 1648091535,
 7250,
 -1,
 1648123990,
 7251,
 1648321089,
 1648080671,
 -1,
 -40384,
 1648258798,
 7254,
 -1,
 1648315522,
 7255,
 1648517700,
 1648250454,
 -1,
 -40381,
 1648466928,
 7252,
 -1,
 1648520823,
 7253,
 -40379,
 1648486293,
 7248,
 -40378,
 1648661951,
 7249,
 -40377,
 1648725180,
 7257,
 -1,
 1648772407,
 7256,
 1648976461,
 1648009193,
 -1,
 1649041996,
 1648939543,
 -1,
 -40373,
 1648986036,
 7294,
 -1,
 1649032502,
 7295,
 -1,
 1648974017,
 7292,
 1649304144,
 1648920497,
 -1,
 -40369,
 1649217434,
 7290,
 -1,
 1649281990,
 7288,
 -40367,
 1649257669,
 7291,
 -40366,
 1649431303,
 7289,
 -1,
 1649481996,
 7293,
 1649697485,
 1629923668,
 -1,
 1649763016,
 1649631615,
 -1,
 1649828551,
 1649730605,
 -1,
 1649894044,
 1649768922,
 -1,
 1649959518,
 1649858478,
 -1,
 1650025053,
 1649906261,
 -1,
 1650090587,
 1649977684,
 2827,
 -1,
 1650043220,
 2912,
 1650262015,
 1650029400,
 2828,
 -1,
 1650160472,
 2913,
 -1,
 1649939828,
 2869,
 1650418276,
 1649918676,
 -1,
 1650483810,
 1650377428,
 -1,
 -40351,
 1650415785,
 2848,
 -1,
 1650464116,
 2847,
 -40349,
 1650415785,
 2853,
 -1,
 1650595188,
 2852,
 1650811497,
 1650362591,
 -1,
 -40346,
 1650779178,
 2846,
 -40345,
 1650821435,
 2851,
 -40344,
 1650873092,
 2841,
 -1,
 1650922868,
 2856,
 1651139183,
 1650734624,
 -1,
 1651204717,
 1651062304,
 -1,
 -40340,
 1651136681,
 2850,
 -1,
 1651185012,
 2849,
 -40338,
 1651136681,
 2855,
 -1,
 1651316084,
 2854,
 1651532403,
 1651053940,
 2821,
 -40335,
 1651494474,
 2836,
 -40334,
 1651532159,
 2832,
 -1,
 1651578228,
 2822,
 1651794551,
 1651488543,
 -1,
 -40331,
 1651750809,
 2871,
 -40330,
 1651792041,
 2870,
 -1,
 1651840372,
 2872,
 1652056699,
 1651747156,
 -1,
 -40327,
 1652009391,
 2908,
 -40326,
 1652054185,
 2909,
 -1,
 1652102516,
 2864,
 1652318846,
 1652024302,
 -1,
 -40323,
 1652286506,
 2911,
 -1,
 1652299124,
 2863,
 1652515456,
 1652280906,
 2825,
 -1,
 1652477514,
 2826,
 1652646531,
 1652465641,
 -1,
 -40318,
 1652578473,
 2859,
 -1,
 1652626804,
 2858,
 1652843142,
 1652585304,
 -1,
 -40315,
 1652781997,
 2867,
 -1,
 1652823412,
 2866,
 1653039753,
 1652781192,
 -1,
 -40312,
 1652971689,
 2838,
 -1,
 1653020020,
 2837,
 1653236364,
 1652977449,
 -1,
 -40309,
 1653168297,
 2845,
 -1,
 1653216628,
 2844,
 1653432974,
 1653170559,
 2823,
 -1,
 1653367167,
 2824,
 1653564049,
 1653363427,
 -1,
 -40304,
 1653495977,
 2840,
 -1,
 1653544308,
 2839,
 1653760660,
 1653484766,
 -1,
 -40301,
 1653692585,
 2843,
 -1,
 1653740916,
 2842,
 1653957271,
 1653679734,
 -1,
 -40298,
 1653889193,
 2861,
 -1,
 1653937524,
 2860,
 -40296,
 1653923120,
 2929,
 -40295,
 1654100367,
 2835,
 -40294,
 1654161458,
 2862,
 -40293,
 1654216873,
 2873,
 -1,
 1654276231,
 2831,
 1654481580,
 1649859766,
 -1,
 1654547106,
 1654447119,
 -1,
 1654612640,
 1654499668,
 2883,
 -1,
 1654565204,
 2884,
 1654783999,
 1654551384,
 2914,
 -1,
 1654682456,
 2915,
 1654874790,
 1654461812,
 -1,
 -40284,
 1654836810,
 2892,
 -40283,
 1654874495,
 2888,
 -1,
 1654920564,
 2878,
 1655136936,
 1654836810,
 2881,
 -1,
 1655098954,
 2882,
 1655268010,
 1655071103,
 2879,
 -1,
 1655202175,
 2880,
 -40277,
 1655214479,
 2891,
 -1,
 1655324807,
 2887,
 1655530170,
 1654405528,
 -1,
 1655595696,
 1655489236,
 -1,
 -40273,
 1655562639,
 2920,
 -1,
 1655595094,
 2921,
 1655792307,
 1655551775,
 -1,
 -40270,
 1655729902,
 2924,
 -1,
 1655786626,
 2925,
 1655988918,
 1655721558,
 -1,
 -40267,
 1655938032,
 2922,
 -1,
 1655991927,
 2923,
 -40265,
 1655957397,
 2918,
 -40264,
 1656133055,
 2919,
 -40263,
 1656196284,
 2927,
 -1,
 1656243511,
 2926,
 1656447683,
 1655487536,
 -1,
 1656513214,
 1656413029,
 -1,
 -40259,
 1656469541,
 2819,
 -1,
 1656531597,
 2893,
 1656709825,
 1656427892,
 -1,
 -40256,
 1656674245,
 2877,
 -1,
 1656721605,
 2818,
 -40254,
 1656655925,
 2876,
 -1,
 1656827316,
 2817,
 1657037510,
 1656362356,
 -1,
 -40251,
 1656999503,
 2903,
 -1,
 1657037205,
 2902,
 -1,
 1656974682,
 2928,
 -1,
 1649759635,
 8886,
 1657365195,
 1649707478,
 -1,
 -40246,
 1657319304,
 64831,
 -1,
 1657370460,
 64830,
 -40244,
 1657325316,
 9766,
 -1,
 1657474332,
 10183,
 1657692926,
 1649655396,
 -1,
 1657758448,
 1657633242,
 -1,
 1657823954,
 1657673076,
 66710,
 -40239,
 1657763452,
 66688,
 -1,
 1657804148,
 66715,
 1658020565,
 1657779999,
 -1,
 -40236,
 1657953647,
 66697,
 -1,
 1658000756,
 66696,
 1658217175,
 1657966991,
 66713,
 -1,
 1658163599,
 66717,
 1658348250,
 1658155144,
 -1,
 -40231,
 1658280105,
 66693,
 -1,
 1658328576,
 66703,
 1658544860,
 1658273927,
 66711,
 -1,
 1658470535,
 66716,
 1658675935,
 1658467872,
 -1,
 -40226,
 1658607785,
 66698,
 -1,
 1658667832,
 66694,
 -40224,
 1658643498,
 66709,
 -40223,
 1658839844,
 66692,
 -40222,
 1658904111,
 66707,
 -40221,
 1658965578,
 66714,
 -40220,
 1659028245,
 66690,
 -40219,
 1659087279,
 66695,
 -40218,
 1659152205,
 66702,
 -40217,
 1659212020,
 66706,
 -40216,
 1659274548,
 66705,
 -40215,
 1659335656,
 66704,
 -40214,
 1659399979,
 66691,
 -40213,
 1659462015,
 66712,
 -40212,
 1659525289,
 66708,
 -40211,
 1659589380,
 66700,
 -40210,
 1659653823,
 66701,
 -40209,
 1659711069,
 66699,
 -1,
 1659774632,
 66689,
 1660026879,
 1657682328,
 -1,
 1660052212,
 1659945684,
 -1,
 -40205,
 1660019087,
 66722,
 -1,
 1660051542,
 66723,
 1660248823,
 1660008223,
 -1,
 -40202,
 1660186350,
 66726,
 -1,
 1660243074,
 66727,
 1660445434,
 1660178006,
 -1,
 -40199,
 1660394480,
 66724,
 -1,
 1660448375,
 66725,
 -40197,
 1660413845,
 66720,
 -40196,
 1660589503,
 66721,
 -40195,
 1660652732,
 66729,
 -1,
 1660699959,
 66728,
 1660904230,
 1657623267,
 -1,
 1660969765,
 1660836332,
 -1,
 1661035298,
 1660910042,
 -1,
 1661100805,
 1660997194,
 -1,
 -40189,
 1661053268,
 5778,
 -40188,
 1661101644,
 5783,
 -1,
 1661150394,
 5766,
 1661362953,
 1661026570,
 -1,
 -40185,
 1661305991,
 5785,
 -40184,
 1661352057,
 5779,
 -1,
 1661413697,
 5781,
 1661625100,
 1661318943,
 -1,
 -40181,
 1661586075,
 5774,
 -1,
 1661606206,
 5764,
 1661821711,
 1661571471,
 -1,
 -40178,
 1661774164,
 5782,
 -1,
 1661832570,
 5777,
 1662018322,
 1661765855,
 -1,
 -40175,
 1661954968,
 5765,
 -1,
 1662014509,
 5773,
 1662214933,
 1661952383,
 -1,
 -40172,
 1662161583,
 5780,
 -1,
 1662210086,
 5784,
 1662411544,
 1662135518,
 -1,
 -40169,
 1662358665,
 5769,
 -1,
 1662403977,
 5770,
 -40167,
 1662372020,
 5768,
 -40166,
 1662563975,
 5775,
 -40165,
 1662624252,
 5786,
 -40164,
 1662683071,
 5771,
 -40163,
 1662746431,
 5762,
 -40162,
 1662801508,
 5772,
 -40161,
 1662865193,
 5763,
 -40160,
 1662924487,
 5767,
 -40159,
 1662986301,
 5761,
 -1,
 1663048040,
 5776,
 -40157,
 1660993267,
 5760,
 -40156,
 1663217007,
 5788,
 -1,
 1663258415,
 5787,
 -1,
 1660917262,
 731,
 1663525689,
 1660854249,
 -1,
 1663591223,
 1663452913,
 -1,
 1663656754,
 1663500288,
 -1,
 1663722286,
 1663577829,
 -1,
 -40149,
 1663681682,
 10044,
 -40148,
 1663710249,
 10011,
 -40147,
 1663773268,
 10027,
 -1,
 1663837188,
 10034,
 1664049969,
 1663680888,
 -1,
 -40144,
 1664000742,
 10180,
 -1,
 1664035854,
 10179,
 -1,
 1663970139,
 9251,
 1664352255,
 1663569619,
 -1,
 1664377654,
 1664233637,
 -1,
 -40139,
 1664316309,
 9104,
 -1,
 1664374935,
 9103,
 -1,
 1664326882,
 10174,
 -40136,
 1663551678,
 8997,
 -1,
 1664591190,
 9741,
 1664770888,
 1663447986,
 -1,
 1664836414,
 1664689782,
 -1,
 -40132,
 1664789151,
 9286,
 -40131,
 1664851714,
 9285,
 -1,
 1664894493,
 9284,
 1665098561,
 1664759328,
 -1,
 -40128,
 1665047379,
 9290,
 -1,
 1665082196,
 9288,
 1665295172,
 1665019102,
 -1,
 -40125,
 1665259238,
 9289,
 -1,
 1665292646,
 9281,
 -40123,
 1665231661,
 9283,
 -40122,
 1665425056,
 9280,
 -40121,
 1665487259,
 9282,
 -1,
 1665539332,
 9287,
 1665753935,
 1664732746,
 -1,
 1665819470,
 1665714462,
 -1,
 -40117,
 1665785603,
 9885,
 -40116,
 1665824247,
 10015,
 -40115,
 1665882029,
 10009,
 -1,
 1665935956,
 10029,
 -1,
 1665763879,
 8485,
 1666212692,
 1665672822,
 -1,
 1666278227,
 1666153338,
 -1,
 -40110,
 1666241284,
 10662,
 -1,
 1666268719,
 10663,
 -1,
 1666215760,
 65532,
 1666540375,
 1666157322,
 -1,
 -40106,
 1666489992,
 11819,
 -1,
 1666545263,
 8228,
 -40104,
 1666505173,
 8254,
 -1,
 1666670150,
 8486,
 1666868589,
 1629858132,
 -1,
 1666933809,
 1666802047,
 -1,
 1666999335,
 1666864350,
 -1,
 1667064760,
 1666908160,
 -1,
 1667130223,
 1667020575,
 -1,
 1667195753,
 1667082296,
 93,
 1667301375,
 1667104768,
 -1,
 1667326822,
 1667227506,
 -1,
 1667392356,
 1667286985,
 -1,
 -40093,
 1667353096,
 10640,
 -1,
 1667377888,
 10638,
 -40091,
 1667355223,
 10636,
 -1,
 1667541220,
 8262,
 -40089,
 1667290208,
 9124,
 -40088,
 1667661409,
 9126,
 -1,
 1667714607,
 9125,
 1667916652,
 1667129727,
 -1,
 -40085,
 1667861540,
 8217,
 -1,
 1667905582,
 11815,
 -40083,
 1667878860,
 11779,
 -40082,
 1668040347,
 8908,
 -1,
 1668092197,
 10182,
 1668309887,
 1667044724,
 -1,
 1668375418,
 1668254719,
 8735,
 1668481023,
 1668284416,
 -1,
 1668506485,
 1668407154,
 -1,
 -40076,
 1668431779,
 9084,
 -1,
 1668489501,
 8894,
 1668703095,
 1668426598,
 12297,
 -1,
 1668615415,
 10642,
 -40072,
 1668667544,
 10652,
 -40071,
 1668792710,
 11776,
 -1,
 1668824102,
 11777,
 1669070847,
 1668327764,
 -1,
 1669096318,
 1668986145,
 -1,
 -40067,
 1669053922,
 8692,
 -1,
 1669083268,
 10228,
 -1,
 1669016831,
 10644,
 1669358473,
 1668275464,
 -1,
 1669424008,
 1669291483,
 -1,
 1669489540,
 1669344478,
 -1,
 -40061,
 1669453299,
 10628,
 -1,
 1669503346,
 12303,
 -40059,
 1669450349,
 12313,
 -40058,
 1669644126,
 12315,
 -40057,
 1669701926,
 10630,
 -1,
 1669757198,
 12311,
 -1,
 1669358788,
 10713,
 1670013842,
 1669282500,
 -1,
 1670079377,
 1669975849,
 -1,
 1670144910,
 1669993844,
 -1,
 -40051,
 1670100427,
 10608,
 -1,
 1670155287,
 12299,
 -40049,
 1670111046,
 10715,
 -40048,
 1670293795,
 8221,
 -1,
 1670357286,
 11817,
 -1,
 1670040626,
 11781,
 1670603674,
 1669934302,
 -1,
 1670669208,
 1670567411,
 125,
 1670774783,
 1670578176,
 -1,
 -40042,
 1670698114,
 9131,
 -40041,
 1670743287,
 9132,
 -1,
 1670807186,
 9133,
 -40039,
 1670617458,
 12301,
 -1,
 1670923650,
 8969,
 1671127969,
 1670562516,
 -1,
 1671193503,
 1671080276,
 -1,
 1671259038,
 1671127668,
 8895,
 -1,
 1671168012,
 10702,
 -1,
 1671176003,
 11786,
 -40032,
 1671141851,
 12309,
 -1,
 1671370603,
 8866,
 1671586726,
 1671078182,
 41,
 1671692287,
 1671495680,
 -1,
 -40028,
 1671615618,
 9118,
 -40027,
 1671659154,
 9120,
 -1,
 1671712303,
 9119,
 1671914409,
 1671551569,
 -1,
 -40024,
 1671864270,
 9145,
 -1,
 1671897222,
 11809,
 1672111020,
 1671860623,
 -1,
 -40021,
 1672075059,
 10198,
 -1,
 1672121106,
 9621,
 1672307631,
 1672042902,
 -1,
 -40018,
 1672254069,
 9616,
 -1,
 1672288111,
 9687,
 1672504242,
 1672236630,
 -1,
 -40015,
 1672445331,
 8971,
 -1,
 1672506637,
 10621,
 1672700853,
 1672423932,
 -1,
 -40012,
 1672661613,
 10648,
 -1,
 1672706318,
 12305,
 -40010,
 1672653393,
 11789,
 -40009,
 1672842720,
 8906,
 -1,
 1672904241,
 11805,
 1673094168,
 1667030362,
 -1,
 1673159648,
 1673011810,
 8594,
 1673225183,
 1673068544,
 -1,
 1673290701,
 1673191282,
 -1,
 1673356228,
 1673249492,
 -1,
 1673421761,
 1673271614,
 8611,
 1673527295,
 1673333795,
 -1,
 -40000,
 1673452311,
 10516,
 -1,
 1673477557,
 10517,
 1673723903,
 1673358269,
 -1,
 -39997,
 1673647401,
 11023,
 -1,
 1673674544,
 11022,
 1673880519,
 1673280196,
 -1,
 -39994,
 1673842562,
 8699,
 -1,
 1673907240,
 10513,
 -39992,
 1673845527,
 8696,
 -39991,
 1674035456,
 8603,
 -39990,
 1674093649,
 10565,
 -39989,
 1674149262,
 8620,
 -39988,
 1674206880,
 8618,
 -1,
 1674261346,
 8628,
 1674470357,
 1673249492,
 -1,
 1674535890,
 1674404058,
 -1,
 -39984,
 1674502916,
 10567,
 -39983,
 1674560009,
 11076,
 -1,
 1674598135,
 11075,
 1674838015,
 1674482074,
 -1,
 -39980,
 1674736667,
 10526,
 -1,
 1674780764,
 8677,
 1674994652,
 1674385019,
 -1,
 1675060185,
 1674947894,
 -1,
 -39976,
 1675020313,
 11084,
 -1,
 1675041825,
 11080,
 -39974,
 1675020313,
 10612,
 -39973,
 1675213676,
 10562,
 -1,
 1675238433,
 10613,
 1675453406,
 1674924623,
 8614,
 -1,
 1675365283,
 10528,
 -1,
 1675402683,
 8644,
 -1,
 1673138546,
 10522,
 1675715572,
 1673091770,
 -1,
 1675781107,
 1675681670,
 -1,
 1675846636,
 1675744004,
 -1,
 1675912171,
 1675755520,
 -1,
 1675977705,
 1675826811,
 -1,
 1676043240,
 1675916120,
 -1,
 -39961,
 1675990556,
 10604,
 -1,
 1676035188,
 10600,
 -1,
 1675997417,
 10596,
 -39958,
 1675938105,
 10579,
 -1,
 1676235343,
 10587,
 -1,
 1675877716,
 8640,
 1676541951,
 1675771439,
 -1,
 1676567538,
 1676410880,
 -1,
 -39953,
 1676527929,
 10583,
 -39952,
 1676563023,
 10591,
 -39951,
 1676617824,
 10605,
 -1,
 1676678823,
 10601,
 -1,
 1676533076,
 8641,
 -1,
 1675730384,
 8652,
 1677026309,
 1675674324,
 -1,
 1677091842,
 1676992911,
 -1,
 1677157377,
 1677004716,
 -1,
 1677222912,
 1677075048,
 -1,
 1677288447,
 1677188978,
 -1,
 1677353981,
 1677247363,
 10518,
 1677459455,
 1677265955,
 -1,
 -39940,
 1677384471,
 10519,
 -1,
 1677409717,
 10520,
 -39938,
 1677318935,
 10496,
 -1,
 1677540789,
 10497,
 -1,
 1677218383,
 10501,
 -1,
 1677183859,
 10512,
 -1,
 1677067348,
 8608,
 1677983743,
 1677046306,
 -1,
 -39932,
 1677866766,
 10511,
 -1,
 1677927010,
 8667,
 1678140432,
 1676949024,
 -1,
 1678205967,
 1678089012,
 -1,
 1678271502,
 1678123618,
 8658,
 1678337037,
 1678180352,
 -1,
 1678402572,
 1678303090,
 -1,
 -39925,
 1678367511,
 10499,
 -1,
 1678426368,
 8655,
 -1,
 1678332495,
 10503,
 -1,
 1678250354,
 10524,
 -1,
 1678194446,
 10509,
 -1,
 1678123909,
 8674,
 1678861332,
 1678105864,
 -1,
 1678926867,
 1678794209,
 8680,
 -1,
 1678836697,
 8688,
 -1,
 1678845428,
 8605,
 -39915,
 1678819216,
 8669,
 -39914,
 1679075299,
 11078,
 -39913,
 1679138952,
 8649,
 -1,
 1679202136,
 8702,
 1679385638,
 1673006803,
 -1,
 1679451165,
 1679346033,
 -1,
 -39909,
 1679400676,
 8238,
 -39908,
 1679458906,
 8207,
 -1,
 1679509082,
 8235,
 1679713313,
 1679402221,
 -1,
 -39905,
 1679637624,
 187,
 -39904,
 1679701473,
 10749,
 -1,
 1679761083,
 9002,
 1679975460,
 1679669023,
 -1,
 -39901,
 1679909740,
 10552,
 -1,
 1679972568,
 10153,
 1680211967,
 1679904456,
 4053,
 -1,
 1680084269,
 4055,
 -1,
 1679317558,
 10813,
 1680368685,
 1666943930,
 -1,
 -39895,
 1680319680,
 11824,
 -39894,
 1680381824,
 8728,
 -39893,
 1680435049,
 8790,
 -39892,
 1680492807,
 8791,
 -1,
 1680545397,
 730,
 1680761904,
 1680325773,
 -1,
 -39889,
 1680719580,
 10544,
 -1,
 1680756460,
 10539,
 -1,
 1680677394,
 65020,
 1681024197,
 1666895434,
 -1,
 1681089681,
 1680968839,
 -1,
 1681155211,
 1681029594,
 -1,
 1681220674,
 1681110815,
 -1,
 1681286207,
 1681154016,
 -1,
 -39881,
 1681254034,
 5863,
 -39880,
 1681313348,
 5840,
 -39879,
 1681374854,
 5836,
 -39878,
 1681431077,
 5805,
 -39877,
 1681492457,
 5823,
 -39876,
 1681555553,
 5849,
 -39875,
 1681611018,
 5821,
 -39874,
 1681664462,
 5843,
 -1,
 1681727583,
 5830,
 -39872,
 1681245184,
 5861,
 -39871,
 1681891235,
 5834,
 -1,
 1681941672,
 5835,
 1682138184,
 1681166735,
 5806,
 -39868,
 1682097721,
 5855,
 -39867,
 1682159466,
 5801,
 -39866,
 1682219556,
 5845,
 -39865,
 1682278623,
 5808,
 -1,
 1682325639,
 5807,
 1682531408,
 1682076504,
 -1,
 1682596943,
 1682478657,
 -1,
 -39861,
 1682564754,
 5862,
 -39860,
 1682610725,
 5804,
 -39859,
 1682669665,
 5848,
 -39858,
 1682725130,
 5820,
 -1,
 1682776164,
 5829,
 -1,
 1682515361,
 5850,
 1683055703,
 1682465151,
 -1,
 1683121235,
 1683000247,
 5853,
 -1,
 1683086918,
 5852,
 -39852,
 1683086922,
 5831,
 -39851,
 1683208265,
 5825,
 -39850,
 1683265526,
 5857,
 -1,
 1683304122,
 5864,
 1683514460,
 1682980999,
 5826,
 -39847,
 1683473935,
 5799,
 -39846,
 1683524535,
 5814,
 -39845,
 1683579222,
 5846,
 -1,
 1683628124,
 5856,
 1683842146,
 1683437088,
 5841,
 1683907681,
 1683790611,
 -1,
 -39841,
 1683857385,
 5844,
 -39840,
 1683917023,
 5824,
 -1,
 1683977048,
 5851,
 -1,
 1683822751,
 5854,
 1684235368,
 1683762398,
 5837,
 1684300902,
 1684160647,
 -1,
 -39835,
 1684244703,
 5811,
 -1,
 1684282011,
 5860,
 -39833,
 1684266597,
 5858,
 -1,
 1684413083,
 5859,
 1684628589,
 1684165347,
 5813,
 1684694124,
 1684553863,
 -1,
 -39829,
 1684646228,
 5828,
 -1,
 1684679331,
 5815,
 -1,
 1684611164,
 5816,
 1684956274,
 1684542836,
 -1,
 -39825,
 1684901638,
 5800,
 -39824,
 1684961875,
 5833,
 -39823,
 1685015137,
 5803,
 -1,
 1685073120,
 5802,
 1685283956,
 1684923374,
 5796,
 -1,
 1685236052,
 5795,
 1685415030,
 1685249288,
 5797,
 -1,
 1685377735,
 5817,
 1685546105,
 1685373652,
 -1,
 -39816,
 1685483223,
 5839,
 -1,
 1685545267,
 5798,
 1685742716,
 1685483910,
 -1,
 -39813,
 1685656948,
 5810,
 -1,
 1685718240,
 5812,
 1685939327,
 1685674153,
 -1,
 -39810,
 1685870034,
 5818,
 -1,
 1685931197,
 5819,
 -39808,
 1685907230,
 5838,
 -39807,
 1686102788,
 5866,
 -39806,
 1686165422,
 5793,
 -39805,
 1686230625,
 5794,
 -39804,
 1686284853,
 5809,
 -39803,
 1686349636,
 5865,
 -39802,
 1686414103,
 5832,
 -39801,
 1686473200,
 5822,
 -39800,
 1686536744,
 5847,
 -39799,
 1686597579,
 5827,
 -39798,
 1686654844,
 5792,
 -1,
 1686710427,
 5842,
 -39796,
 1681116483,
 5871,
 -39795,
 1686879430,
 5867,
 -39794,
 1686931429,
 5868,
 -39793,
 1686975535,
 5869,
 -39792,
 1687038019,
 5872,
 -1,
 1687101966,
 5870,
 1687315651,
 1681032340,
 -1,
 1687381168,
 1687261247,
 -1,
 1687446683,
 1687339732,
 -1,
 1687512215,
 1687411976,
 -1,
 -39786,
 1687458206,
 69235,
 -1,
 1687504975,
 69226,
 1687708826,
 1687443595,
 -1,
 -39783,
 1687661657,
 69236,
 -1,
 1687710934,
 69227,
 -1,
 1687635697,
 69225,
 1687970978,
 1687402271,
 -1,
 1688036511,
 1687908078,
 -1,
 -39778,
 1687997993,
 69230,
 -1,
 1688011878,
 69239,
 1688272895,
 1687964802,
 -1,
 -39775,
 1688194601,
 69231,
 -1,
 1688208486,
 69240,
 1688429737,
 1687899734,
 -1,
 1688495270,
 1688375695,
 -1,
 -39771,
 1688458637,
 69237,
 -1,
 1688516198,
 69228,
 1688731647,
 1688428927,
 -1,
 -39768,
 1688656148,
 69238,
 -1,
 1688687294,
 69229,
 1688888492,
 1688374460,
 -1,
 -39765,
 1688849961,
 69233,
 -1,
 1688863846,
 69242,
 1689085103,
 1688814903,
 -1,
 -39762,
 1689052142,
 69232,
 -1,
 1689060454,
 69241,
 -1,
 1689032170,
 69234,
 1689347261,
 1687304600,
 -1,
 1689412788,
 1689305812,
 -1,
 -39757,
 1689379215,
 69217,
 -1,
 1689411670,
 69218,
 1689609399,
 1689368351,
 -1,
 -39754,
 1689546478,
 69221,
 -1,
 1689603202,
 69222,
 1689806010,
 1689538134,
 -1,
 -39751,
 1689754608,
 69219,
 -1,
 1689808503,
 69220,
 -39749,
 1689753023,
 69216,
 -39748,
 1689947324,
 69224,
 -1,
 1689994551,
 69223,
 1690238975,
 1689276963,
 -1,
 1690264770,
 1690146243,
 -1,
 -39744,
 1690224319,
 69245,
 -39743,
 1690282069,
 69244,
 -1,
 1690327435,
 69243,
 -1,
 1690226175,
 69246,
 -39740,
 1687265756,
 8360,
 -1,
 1690531428,
 10740,
 1690723626,
 1680949383,
 -1,
 1690789109,
 1690660654,
 -1,
 1690854627,
 1690728922,
 -1,
 1690920145,
 1690798303,
 -1,
 1690985676,
 1690887150,
 -1,
 -39733,
 1690922795,
 43333,
 -1,
 1690965364,
 43323,
 1691182287,
 1690915555,
 -1,
 -39730,
 1691112196,
 43331,
 -1,
 1691161972,
 43314,
 -39728,
 1691104907,
 43332,
 -1,
 1691293044,
 43317,
 1691509972,
 1690861541,
 -1,
 -39725,
 1691428520,
 43330,
 -1,
 1691489652,
 43320,
 -39723,
 1691477034,
 43327,
 -39722,
 1691671856,
 43328,
 -39721,
 1691730709,
 43315,
 -39720,
 1691793305,
 43324,
 -39719,
 1691855279,
 43325,
 -39718,
 1691918414,
 43318,
 -39717,
 1691972525,
 43326,
 -39716,
 1692037279,
 43312,
 -39715,
 1692102443,
 43322,
 -39714,
 1692162217,
 43329,
 -39713,
 1692226308,
 43313,
 -39712,
 1692284555,
 43316,
 -39711,
 1692347707,
 43321,
 -39710,
 1692411560,
 43319,
 -1,
 1692472692,
 43334,
 1692689647,
 1690818478,
 -1,
 1692755182,
 1692639030,
 -1,
 1692820712,
 1692680327,
 43337,
 -39705,
 1692782154,
 43341,
 -1,
 1692800372,
 43342,
 1693017323,
 1692734836,
 -1,
 -39702,
 1692978762,
 43340,
 -1,
 1693016447,
 43338,
 -39700,
 1692978762,
 43336,
 -39699,
 1693159823,
 43339,
 -1,
 1693213055,
 43335,
 -1,
 1692691474,
 43347,
 1693476084,
 1692611218,
 -1,
 1693541618,
 1693419743,
 43344,
 -1,
 1693471459,
 43343,
 -39693,
 1693493588,
 43345,
 -1,
 1693603979,
 43346,
 -1,
 1693432025,
 43359,
 1693869333,
 1690753535,
 -1,
 1693934860,
 1693791778,
 -1,
 1694000379,
 1693893332,
 -1,
 1694065914,
 1693935103,
 8765,
 -1,
 1693975460,
 8909,
 -1,
 1694020176,
 8247,
 1694262527,
 1693924431,
 -1,
 1694328062,
 1694213739,
 8246,
 -1,
 1694239131,
 12317,
 -1,
 1694286121,
 10989,
 1694524674,
 1694218015,
 -1,
 -39679,
 1694451328,
 8271,
 -1,
 1694506792,
 8515,
 1694721285,
 1694474217,
 -1,
 -39676,
 1694675355,
 8245,
 -1,
 1694721523,
 8267,
 1694917895,
 1694637749,
 10659,
 -1,
 1694830254,
 10661,
 -39672,
 1694872769,
 9753,
 -39671,
 1695000766,
 11822,
 -39670,
 1695059593,
 8976,
 -39669,
 1695109536,
 11793,
 -1,
 1695172320,
 10672,
 1695416319,
 1693843456,
 -1,
 1695442194,
 1695334041,
 92,
 1695547391,
 1695350784,
 -1,
 -39664,
 1695473715,
 10743,
 -39663,
 1695524382,
 10184,
 -1,
 1695586176,
 10741,
 1695809535,
 1695402024,
 -1,
 -39660,
 1695723679,
 11079,
 -1,
 1695774793,
 11073,
 1695966497,
 1693791771,
 -1,
 1696032032,
 1695901920,
 -1,
 1696097567,
 1695993406,
 -1,
 -39655,
 1696011491,
 9849,
 -39654,
 1696076946,
 9848,
 -39653,
 1696142404,
 9847,
 -39652,
 1696207835,
 9846,
 -39651,
 1696273280,
 9845,
 -39650,
 1696338645,
 9844,
 -1,
 1696404060,
 9843,
 -1,
 1696027729,
 9850,
 -1,
 1695957691,
 9852,
 1696752934,
 1695921951,
 -1,
 1696818469,
 1696713541,
 -1,
 -39644,
 1696731815,
 9953,
 -1,
 1696797199,
 9952,
 -1,
 1696769355,
 8479,
 -39641,
 1696713952,
 9166,
 -39640,
 1697031160,
 65533,
 -39639,
 1697076653,
 174,
 -1,
 1697140650,
 8251,
 1697342818,
 1690669455,
 -1,
 1697408350,
 1697284602,
 -1,
 1697473870,
 1697353834,
 -1,
 1697539384,
 1697402454,
 -1,
 1697604919,
 1697472895,
 -1,
 1697670451,
 1697569012,
 8548,
 1697775615,
 1697579008,
 -1,
 -39630,
 1697695517,
 8577,
 -1,
 1697734935,
 8558,
 1697972223,
 1697600190,
 8556,
 1698037759,
 1697841152,
 -1,
 -39626,
 1697957661,
 8583,
 -1,
 1697988953,
 8582,
 -1,
 1697553392,
 8547,
 1698260287,
 1697497812,
 -1,
 1698325820,
 1698225416,
 -1,
 -39621,
 1698271631,
 8545,
 -1,
 1698317869,
 8555,
 1698522430,
 1698252529,
 8553,
 -1,
 1698433745,
 8578,
 -1,
 1698455638,
 8546,
 1698719045,
 1698207167,
 8544,
 1698824191,
 1698627584,
 -1,
 1698850115,
 1698744093,
 8559,
 -1,
 1698759274,
 8576,
 1699020799,
 1698783511,
 8557,
 -1,
 1698892497,
 8584,
 1699112265,
 1698674463,
 -1,
 1699177800,
 1699049198,
 8549,
 -1,
 1699087710,
 8581,
 -1,
 1699105922,
 8550,
 1699374412,
 1699037319,
 -1,
 -39605,
 1699314208,
 8554,
 -1,
 1699374307,
 8551,
 -39603,
 1699327376,
 8579,
 -1,
 1699515580,
 8552,
 1699702102,
 1697429279,
 -1,
 1699767637,
 1699627143,
 -1,
 1699833171,
 1699734467,
 -1,
 -39598,
 1699795129,
 65939,
 -1,
 1699815169,
 65936,
 -39596,
 1699790997,
 65944,
 -1,
 1699973190,
 65938,
 -1,
 1699702325,
 65941,
 1700226394,
 1699624480,
 -1,
 -39592,
 1700189259,
 65945,
 -39591,
 1700226759,
 65940,
 -1,
 1700284206,
 65942,
 -39589,
 1700188684,
 65937,
 -39588,
 1700440298,
 65943,
 -39587,
 1700474626,
 65947,
 -1,
 1700537134,
 65946,
 1700790271,
 1697367113,
 -1,
 -39584,
 1700682710,
 10085,
 -39583,
 1700745545,
 10087,
 -1,
 1700802068,
 8506,
 1701052415,
 1697256820,
 -1,
 1701078377,
 1700946303,
 -1,
 1701143912,
 1701034227,
 -1,
 -39578,
 1701101399,
 11787,
 -39577,
 1701145085,
 11782,
 -1,
 1701198831,
 11783,
 -1,
 1701087455,
 9926,
 1701471596,
 1701001355,
 -1,
 -39573,
 1701417434,
 9762,
 -1,
 1701457234,
 9143,
 -1,
 1701431482,
 8758,
 1701734253,
 1666818025,
 -1,
 1701799476,
 1701647732,
 -1,
 1701865006,
 1701751124,
 -1,
 1701930527,
 1701791755,
 -1,
 1701995944,
 1701868995,
 -1,
 1702061453,
 1701953034,
 -1,
 -39564,
 1702029086,
 9397,
 -39563,
 1702093806,
 9396,
 -39562,
 1702159108,
 9395,
 -39561,
 1702223112,
 9394,
 -39560,
 1702287278,
 9393,
 -39559,
 1702350410,
 9392,
 -39558,
 1702413012,
 9391,
 -39557,
 1702475551,
 9390,
 -39556,
 1702537556,
 9389,
 -39555,
 1702602564,
 9388,
 -39554,
 1702666217,
 9387,
 -39553,
 1702728079,
 9386,
 -39552,
 1702791391,
 9385,
 -39551,
 1702854629,
 9384,
 -39550,
 1702916952,
 9383,
 -39549,
 1702981768,
 9382,
 -39548,
 1703046953,
 9381,
 -39547,
 1703108991,
 9380,
 -39546,
 1703172235,
 9379,
 -39545,
 1703236323,
 9378,
 -39544,
 1703300694,
 9377,
 -39543,
 1703362695,
 9376,
 -39542,
 1703425568,
 9375,
 -39541,
 1703488734,
 9374,
 -39540,
 1703552630,
 9373,
 -1,
 1703613812,
 9372,
 1703870463,
 1701981700,
 -1,
 -39537,
 1703798558,
 127273,
 -39536,
 1703863278,
 127272,
 -39535,
 1703928580,
 127271,
 -39534,
 1703992584,
 127270,
 -39533,
 1704056750,
 127269,
 -39532,
 1704119882,
 127268,
 -39531,
 1704182484,
 127267,
 -39530,
 1704245023,
 127266,
 -39529,
 1704307028,
 127265,
 -39528,
 1704372036,
 127264,
 -39527,
 1704435689,
 127263,
 -39526,
 1704497551,
 127262,
 -39525,
 1704560863,
 127261,
 -39524,
 1704624101,
 127260,
 -39523,
 1704686424,
 127259,
 -39522,
 1704751240,
 127258,
 -39521,
 1704816425,
 127257,
 -39520,
 1704878463,
 127256,
 -39519,
 1704941707,
 127255,
 -39518,
 1705005795,
 127254,
 -39517,
 1705070166,
 127253,
 -39516,
 1705132167,
 127252,
 -39515,
 1705195040,
 127251,
 -39514,
 1705258206,
 127250,
 -39513,
 1705322102,
 127249,
 -1,
 1705383284,
 127248,
 1705600475,
 1701929911,
 -1,
 1705665974,
 1705555743,
 -1,
 1705731501,
 1705627210,
 -1,
 -39508,
 1705681703,
 12860,
 -1,
 1705740511,
 12848,
 1705928112,
 1705689812,
 -1,
 -39505,
 1705889802,
 12859,
 -1,
 1705939573,
 12849,
 1706124723,
 1705853063,
 -1,
 -39502,
 1706088835,
 12838,
 -1,
 1706129974,
 12866,
 -39500,
 1706074558,
 12853,
 -39499,
 1706267246,
 12851,
 -1,
 1706323694,
 12837,
 1706517949,
 1705594454,
 -1,
 1706583483,
 1706451327,
 -1,
 -39495,
 1706547444,
 12836,
 -39494,
 1706601348,
 12843,
 -1,
 1706658190,
 12854,
 -39492,
 1706531824,
 12835,
 -1,
 1706773301,
 12864,
 1706976707,
 1706470276,
 -1,
 1707042241,
 1706931999,
 -1,
 -39488,
 1707000532,
 12865,
 -1,
 1707056239,
 12862,
 -39486,
 1706993238,
 12857,
 -1,
 1707153239,
 12867,
 1707369927,
 1706934996,
 -1,
 -39483,
 1707336079,
 12833,
 -39482,
 1707368534,
 12834,
 -1,
 1707427569,
 12841,
 1707632075,
 1707294855,
 -1,
 -39479,
 1707577223,
 12861,
 -39478,
 1707631843,
 12839,
 -1,
 1707680460,
 12847,
 1707894222,
 1707597064,
 -1,
 -39475,
 1707841178,
 12845,
 -1,
 1707877546,
 12844,
 1708090833,
 1707837663,
 -1,
 -39472,
 1708025954,
 12840,
 -1,
 1708072131,
 12852,
 1708287444,
 1708031973,
 -1,
 -39469,
 1708234409,
 12842,
 -1,
 1708280688,
 12846,
 1708484055,
 1708207326,
 -1,
 -39466,
 1708430930,
 12855,
 -1,
 1708465060,
 12858,
 -39464,
 1708430783,
 12832,
 -39463,
 1708618747,
 12856,
 -39462,
 1708677901,
 12850,
 -1,
 1708727281,
 12863,
 1708942846,
 1705531986,
 -1,
 1709008355,
 1708862686,
 -1,
 1709073889,
 1708942395,
 12808,
 1709178879,
 1708982272,
 -1,
 -39456,
 1709100618,
 12828,
 -1,
 1709118836,
 12822,
 1709375487,
 1709006023,
 12809,
 -1,
 1709244418,
 12823,
 1709467112,
 1708966612,
 -1,
 1709532646,
 1709401525,
 12802,
 -1,
 1709441026,
 12816,
 1709703167,
 1709464802,
 12811,
 -1,
 1709572098,
 12825,
 1709794797,
 1709416425,
 -1,
 1709860331,
 1709728838,
 12805,
 -1,
 1709768706,
 12819,
 1710030847,
 1709792475,
 12812,
 -1,
 1709899778,
 12826,
 1710122482,
 1709731976,
 -1,
 1710188016,
 1710059299,
 12800,
 -1,
 1710096386,
 12814,
 1710358527,
 1710120148,
 12810,
 -1,
 1710227458,
 12824,
 1710450164,
 1710079242,
 12806,
 -1,
 1710358530,
 12820,
 1710581238,
 1710403159,
 12803,
 -1,
 1710489602,
 12817,
 1710712312,
 1710525580,
 12801,
 -1,
 1710620674,
 12815,
 1710843386,
 1710654766,
 12804,
 -1,
 1710751746,
 12818,
 1710974460,
 1710777408,
 12807,
 -1,
 1710882818,
 12821,
 1711144959,
 1710906574,
 12813,
 -1,
 1711013890,
 12827,
 1711236623,
 1708888127,
 -1,
 1711302149,
 1711194836,
 -1,
 1711367683,
 1711267410,
 -1,
 -39422,
 1711312901,
 9351,
 -1,
 1711374222,
 9343,
 -39420,
 1711300017,
 9344,
 -1,
 1711490801,
 9341,
 1711695368,
 1711257375,
 -1,
 -39417,
 1711632128,
 9347,
 -1,
 1711688880,
 9348,
 1711891979,
 1711623766,
 -1,
 -39414,
 1711840373,
 9345,
 -1,
 1711891565,
 9346,
 1712088590,
 1711816839,
 -1,
 -39411,
 1712028192,
 9342,
 -1,
 1712088321,
 9349,
 -1,
 1712032961,
 9350,
 1712350748,
 1711159704,
 -1,
 1712416275,
 1712308948,
 -1,
 -39406,
 1712382351,
 9333,
 -1,
 1712414806,
 9334,
 1712612886,
 1712371487,
 -1,
 -39403,
 1712549614,
 9337,
 -1,
 1712606338,
 9338,
 1712809497,
 1712541270,
 -1,
 -39400,
 1712757744,
 9335,
 -1,
 1712811639,
 9336,
 -39398,
 1712756159,
 9332,
 -39397,
 1712950460,
 9340,
 -1,
 1712997687,
 9339,
 1713242111,
 1712288442,
 -1,
 -39394,
 1713139650,
 12829,
 -1,
 1713177698,
 12830,
 1713399336,
 1701844340,
 -1,
 1713464869,
 1713339507,
 -1,
 1713530404,
 1713430386,
 -1,
 -39389,
 1713489945,
 10995,
 -1,
 1713528694,
 10994,
 -1,
 1713490226,
 8741,
 1713831935,
 1713395382,
 -1,
 -39385,
 1713740288,
 11791,
 -1,
 1713768968,
 8233,
 1714028543,
 1713357524,
 -1,
 1714054700,
 1713922602,
 -1,
 -39381,
 1713995716,
 9853,
 -1,
 1714029356,
 8706,
 -39379,
 1713998734,
 12880,
 -1,
 1714159710,
 12349,
 1714382385,
 1701822463,
 -1,
 -39376,
 1714344948,
 9106,
 -1,
 1714372381,
 9105,
 1714618367,
 1714320216,
 -1,
 -39373,
 1714520049,
 11801,
 -1,
 1714582910,
 9908,
 1714775784,
 1701730443,
 -1,
 1714841280,
 1714689396,
 -1,
 1714906752,
 1714771990,
 -1,
 1714972276,
 1714846170,
 -1,
 1715037761,
 1714930388,
 -1,
 1715103292,
 1714995924,
 -1,
 -39365,
 1715034281,
 43114,
 -1,
 1715082612,
 43113,
 1715299903,
 1715058463,
 -1,
 -39362,
 1715230889,
 43089,
 -1,
 1715279220,
 43088,
 -39360,
 1715230889,
 43081,
 -1,
 1715410292,
 43080,
 1715627590,
 1714981087,
 -1,
 -39357,
 1715594282,
 43079,
 -39356,
 1715636539,
 43116,
 -39355,
 1715688196,
 43075,
 -1,
 1715737972,
 43083,
 1715955274,
 1715582751,
 -1,
 -39352,
 1715896612,
 43094,
 -39351,
 1715951785,
 43098,
 -1,
 1716000116,
 43099,
 1716217422,
 1715877408,
 -1,
 -39348,
 1716184880,
 43090,
 -39347,
 1716205195,
 43115,
 -1,
 1716262260,
 43082,
 1716479570,
 1716137182,
 -1,
 1716545105,
 1716393332,
 43076,
 -1,
 1716488953,
 43123,
 -1,
 1716476073,
 43077,
 1716741717,
 1716393332,
 43101,
 -39340,
 1716698921,
 43120,
 -1,
 1716748037,
 43117,
 1716938328,
 1716709150,
 -1,
 -39337,
 1716869289,
 43092,
 -1,
 1716917620,
 43093,
 1717134939,
 1716902946,
 -1,
 -39334,
 1717074246,
 43118,
 -1,
 1717122611,
 43119,
 1717331550,
 1717084137,
 -1,
 -39331,
 1717262505,
 43085,
 -1,
 1717310836,
 43084,
 1717528161,
 1717268616,
 -1,
 -39328,
 1717459113,
 43073,
 -1,
 1717507444,
 43072,
 1717724772,
 1717457635,
 -1,
 -39325,
 1717654276,
 43109,
 -1,
 1717704052,
 43074,
 1717921382,
 1717649543,
 43104,
 -1,
 1717846151,
 43110,
 -39321,
 1717888042,
 43095,
 -39320,
 1718018852,
 43107,
 -39319,
 1718082864,
 43091,
 -39318,
 1718144586,
 43103,
 -39317,
 1718200751,
 43096,
 -39316,
 1718265674,
 43106,
 -39315,
 1718325647,
 43105,
 -39314,
 1718386738,
 43087,
 -39313,
 1718449069,
 43097,
 -39312,
 1718513451,
 43078,
 -39311,
 1718575487,
 43102,
 -39310,
 1718638761,
 43100,
 -39309,
 1718701759,
 43108,
 -1,
 1718757032,
 43086,
 1718969980,
 1714927391,
 -1,
 1719035515,
 1718931018,
 -1,
 1719101050,
 1718954456,
 -1,
 -39304,
 1719067690,
 43112,
 -39303,
 1719131440,
 43111,
 -1,
 1719183791,
 43121,
 -1,
 1719050922,
 43122,
 -1,
 1718970622,
 43124,
 1719494271,
 1718911583,
 -1,
 -39298,
 1719450215,
 43126,
 -1,
 1719483763,
 43127,
 -1,
 1719418113,
 43125,
 1719795711,
 1714842990,
 -1,
 1719821964,
 1719676126,
 -1,
 1719887494,
 1719767439,
 -1,
 1719953029,
 1719829179,
 66020,
 -1,
 1719888198,
 66045,
 -1,
 1719893836,
 66022,
 1720149642,
 1719801204,
 -1,
 -39288,
 1720107732,
 66028,
 -39287,
 1720169784,
 66018,
 -1,
 1720231648,
 66003,
 -39285,
 1720090410,
 66012,
 -1,
 1720343924,
 66004,
 1720542868,
 1719777055,
 -1,
 1720608400,
 1720474761,
 -1,
 -39281,
 1720557545,
 66024,
 -1,
 1720600031,
 66011,
 -39279,
 1720568491,
 66042,
 -39278,
 1720746283,
 66043,
 -39277,
 1720810331,
 66021,
 -1,
 1720854037,
 66015,
 1721067163,
 1720460918,
 -1,
 1721132696,
 1721012623,
 -1,
 -39273,
 1721097480,
 66010,
 -1,
 1721144561,
 66017,
 1721329306,
 1721058087,
 66033,
 -1,
 1721261594,
 66023,
 -1,
 1721291043,
 66027,
 1721525921,
 1721016297,
 -1,
 1721591455,
 1721463640,
 -1,
 -39266,
 1721553334,
 66001,
 -1,
 1721572941,
 66034,
 -39264,
 1721516762,
 66000,
 -1,
 1721704533,
 66036,
 1721919141,
 1721483988,
 -1,
 -39261,
 1721881310,
 66032,
 -39260,
 1721918146,
 66008,
 -1,
 1721967994,
 66002,
 1722181289,
 1721849995,
 -1,
 -39257,
 1722128735,
 66025,
 -39256,
 1722180428,
 66026,
 -1,
 1722238479,
 66006,
 1722443436,
 1722146056,
 -1,
 -39253,
 1722389705,
 66005,
 -1,
 1722426892,
 66044,
 1722640047,
 1722394964,
 -1,
 -39250,
 1722587651,
 66037,
 -1,
 1722621031,
 66029,
 1722836658,
 1722581042,
 -1,
 -39247,
 1722797175,
 66014,
 -1,
 1722845530,
 66013,
 1723033269,
 1722776176,
 -1,
 -39244,
 1722974136,
 66038,
 -1,
 1723020832,
 66016,
 1723229880,
 1722962659,
 -1,
 -39241,
 1723181812,
 66041,
 -1,
 1723213248,
 66007,
 1723426491,
 1723153092,
 -1,
 -39238,
 1723390196,
 66031,
 -1,
 1723431907,
 66019,
 -39236,
 1723390895,
 66035,
 -39235,
 1723572166,
 66039,
 -39234,
 1723617646,
 66040,
 -39233,
 1723678998,
 66030,
 -1,
 1723736674,
 66009,
 1723950821,
 1714787045,
 -1,
 1724016347,
 1723890138,
 -1,
 1724081862,
 1723971359,
 -1,
 -39228,
 1724013955,
 67860,
 -39227,
 1724073658,
 67854,
 -1,
 1724127234,
 67857,
 1724344009,
 1724039892,
 -1,
 -39224,
 1724271421,
 67848,
 -1,
 1724327311,
 67861,
 1724540619,
 1724275496,
 67844,
 -1,
 1724498644,
 67847,
 1724671694,
 1724454260,
 -1,
 -39219,
 1724611126,
 67840,
 -1,
 1724671792,
 67855,
 -39217,
 1724639042,
 67846,
 -39216,
 1724835373,
 67849,
 -39215,
 1724898814,
 67845,
 -39214,
 1724953730,
 67859,
 -39213,
 1725015983,
 67858,
 -39212,
 1725079981,
 67856,
 -39211,
 1725141159,
 67853,
 -39210,
 1725203431,
 67852,
 -39209,
 1725265114,
 67851,
 -39208,
 1725329611,
 67850,
 -39207,
 1725387621,
 67842,
 -39206,
 1725446062,
 67843,
 -1,
 1725507859,
 67841,
 1725720292,
 1723961407,
 -1,
 1725785826,
 1725678292,
 -1,
 1725851360,
 1725750536,
 -1,
 -39201,
 1725796751,
 67866,
 -1,
 1725843535,
 67864,
 -39199,
 1725784150,
 67867,
 -1,
 1725974257,
 67863,
 1726218239,
 1725732287,
 67862,
 -1,
 1726088294,
 67865,
 -1,
 1725686473,
 67871,
 1726414847,
 1723885099,
 -1,
 -39193,
 1726332102,
 5941,
 -1,
 1726365024,
 5942,
 1726572338,
 1714727252,
 -1,
 1726637865,
 1726496903,
 -1,
 1726703384,
 1726592799,
 -1,
 1726768919,
 1726629847,
 -1,
 1726834427,
 1726706520,
 -1,
 1726899962,
 1726759838,
 -1,
 1726965489,
 1726865071,
 -1,
 -39184,
 1726904590,
 65047,
 -1,
 1726952275,
 65091,
 1727162100,
 1726885086,
 -1,
 -39181,
 1727124979,
 65079,
 -1,
 1727175026,
 65089,
 -39179,
 1727122029,
 65081,
 -39178,
 1727315806,
 65095,
 -39177,
 1727373606,
 65077,
 -39176,
 1727413347,
 65085,
 -39175,
 1727474204,
 65083,
 -1,
 1727536827,
 65087,
 -1,
 1726848756,
 65075,
 1727817480,
 1726787175,
 -1,
 1727883007,
 1727782575,
 -1,
 -39170,
 1727822113,
 65048,
 -1,
 1727869779,
 65092,
 1728079618,
 1727802590,
 -1,
 -39167,
 1728042483,
 65080,
 -1,
 1728092530,
 65090,
 -39165,
 1728039533,
 65082,
 -39164,
 1728233310,
 65096,
 -39163,
 1728291110,
 65078,
 -39162,
 1728330851,
 65086,
 -39161,
 1728391708,
 65084,
 -1,
 1728454331,
 65088,
 1728669452,
 1727742087,
 -1,
 -39158,
 1728635718,
 65045,
 -39157,
 1728678116,
 65074,
 -1,
 1728741377,
 65073,
 1728931599,
 1728603074,
 -1,
 -39154,
 1728860866,
 65042,
 -1,
 1728918031,
 65041,
 1729128210,
 1728852456,
 -1,
 -39151,
 1729070583,
 65040,
 -1,
 1729133842,
 65043,
 -39149,
 1729093139,
 65076,
 -39148,
 1729285478,
 65072,
 -39147,
 1729345886,
 65044,
 -39146,
 1729407166,
 65046,
 -1,
 1729453854,
 65049,
 -1,
 1726690292,
 8478,
 1729718056,
 1726623412,
 8826,
 1729822719,
 1729626112,
 -1,
 1729849123,
 1729697403,
 -1,
 1729914654,
 1729805529,
 -1,
 -39139,
 1729859173,
 10929,
 -1,
 1729907027,
 10927,
 1730111265,
 1729859142,
 -1,
 -39136,
 1730038023,
 10933,
 -1,
 1730092065,
 10937,
 -39134,
 1730038099,
 10931,
 -1,
 1730223137,
 10935,
 1730438950,
 1729796093,
 -1,
 -39131,
 1730375270,
 8830,
 -1,
 1730419237,
 8828,
 -39129,
 1730400840,
 8880,
 -1,
 1730555017,
 8936,
 -1,
 1729682356,
 9111,
 1730832175,
 1726583183,
 -1,
 1730897710,
 1730781161,
 -1,
 1730963245,
 1730845140,
 8759,
 -1,
 1730877989,
 8733,
 -1,
 1730890305,
 8522,
 -1,
 1730834295,
 8965,
 1731264511,
 1730765183,
 -1,
 -39119,
 1731170092,
 9113,
 -1,
 1731232539,
 8242,
 1731422028,
 1726509912,
 -1,
 1731487560,
 1731382858,
 -1,
 1731553095,
 1731442463,
 -1,
 1731618630,
 1731463717,
 43,
 1731723263,
 1731526656,
 -1,
 1731749697,
 1731649394,
 -1,
 1731815227,
 1731708930,
 -1,
 -39110,
 1731733587,
 10790,
 -1,
 1731794549,
 10788,
 1732011838,
 1731770143,
 -1,
 -39107,
 1731973045,
 10791,
 -1,
 1732018510,
 10786,
 -39105,
 1731935035,
 10789,
 -39104,
 1732128995,
 10787,
 -1,
 1732192863,
 10792,
 1732405061,
 1731684147,
 -1,
 -39101,
 1732365050,
 10809,
 -39100,
 1732423477,
 10798,
 -1,
 1732474639,
 10797,
 -1,
 1732318850,
 10866,
 -1,
 1731530873,
 177,
 -1,
 1731512626,
 9799,
 1732902911,
 1731401076,
 -1,
 1732929355,
 1732807232,
 8462,
 -1,
 1732839496,
 8463,
 -1,
 1732849291,
 8984,
 1733125982,
 1731346567,
 -1,
 1733191513,
 1733077332,
 -1,
 1733257042,
 1733099520,
 -1,
 -39088,
 1733215535,
 8241,
 -39087,
 1733278763,
 8524,
 -1,
 1733330245,
 8240,
 1733519189,
 1733211935,
 -1,
 -39084,
 1733468613,
 8966,
 -1,
 1733530965,
 9977,
 1733715799,
 1733468721,
 10178,
 -1,
 1733627459,
 10977,
 -39080,
 1733657095,
 9854,
 -1,
 1733766875,
 37,
 1733977948,
 1733146399,
 -1,
 -39077,
 1733923267,
 8369,
 -1,
 1733970780,
 8359,
 -39075,
 1733921339,
 9999,
 -1,
 1734088524,
 9774,
 1734305637,
 1733058943,
 -1,
 1734371169,
 1734263923,
 8916,
 -1,
 1734282871,
 10970,
 -39070,
 1734326392,
 9811,
 -39069,
 1734447406,
 10031,
 -39068,
 1734506027,
 182,
 -1,
 1734553893,
 9935,
 1734764396,
 1734250895,
 -1,
 1734829930,
 1734719263,
 -1,
 1734895465,
 1734788015,
 12306,
 -1,
 1734804407,
 12320,
 -1,
 1734831644,
 8982,
 -39061,
 1734791737,
 163,
 -1,
 1735041016,
 8236,
 -1,
 1734726179,
 8200,
 1735289057,
 1701677279,
 -1,
 1735354386,
 1735213191,
 -1,
 1735419870,
 1735318794,
 -1,
 1735485405,
 1735377779,
 -1,
 1735550900,
 1735424474,
 -1,
 1735616399,
 1735491107,
 -1,
 1735681911,
 1735574228,
 -1,
 -39051,
 1735636889,
 6539,
 -39050,
 1735678121,
 6546,
 -1,
 1735726452,
 6545,
 1735944058,
 1735648004,
 -1,
 -39047,
 1735907260,
 6569,
 -1,
 1735923060,
 6534,
 1736140669,
 1735898911,
 -1,
 -39044,
 1736101566,
 6571,
 -1,
 1736119668,
 6540,
 1736337280,
 1736089577,
 -1,
 -39041,
 1736267945,
 6552,
 -1,
 1736316276,
 6551,
 1736533891,
 1736280287,
 -1,
 -39038,
 1736463108,
 6535,
 -1,
 1736512884,
 6547,
 1736730502,
 1736470664,
 -1,
 -39035,
 1736693692,
 6568,
 -1,
 1736709492,
 6533,
 -39033,
 1736696874,
 6541,
 -39032,
 1736890300,
 6558,
 -39031,
 1736943434,
 6529,
 -39030,
 1736998962,
 6553,
 -39029,
 1737061293,
 6559,
 -39028,
 1737119913,
 6563,
 -39027,
 1737182911,
 6557,
 -39026,
 1737242251,
 6564,
 -1,
 1737303720,
 6565,
 1737516972,
 1735548143,
 -1,
 1737582484,
 1737474772,
 -1,
 -39022,
 1737537433,
 6536,
 -39021,
 1737578665,
 6543,
 -1,
 1737626996,
 6542,
 1737844631,
 1737548548,
 -1,
 -39018,
 1737807804,
 6567,
 -1,
 1737823604,
 6531,
 1738041242,
 1737799455,
 -1,
 -39015,
 1738002110,
 6570,
 -1,
 1738020212,
 6537,
 1738237853,
 1737990121,
 -1,
 -39012,
 1738168489,
 6549,
 -1,
 1738216820,
 6548,
 1738434464,
 1738180831,
 -1,
 -39009,
 1738363652,
 6532,
 -1,
 1738413428,
 6544,
 1738631075,
 1738371208,
 -1,
 -39006,
 1738594236,
 6566,
 -1,
 1738610036,
 6530,
 -39004,
 1738597418,
 6538,
 -39003,
 1738790844,
 6555,
 -39002,
 1738843978,
 6528,
 -39001,
 1738899506,
 6550,
 -39000,
 1738961837,
 6556,
 -38999,
 1739020457,
 6560,
 -38998,
 1739083455,
 6554,
 -38997,
 1739142795,
 6561,
 -1,
 1739204264,
 6562,
 1739456511,
 1737445426,
 -1,
 1739483055,
 1739360479,
 6595,
 -1,
 1739412195,
 6594,
 -38992,
 1739446190,
 6593,
 -38991,
 1739554789,
 6596,
 -38990,
 1739616392,
 6597,
 -38989,
 1739666976,
 6598,
 -1,
 1739728502,
 6599,
 1739941832,
 1735515318,
 -1,
 1740007354,
 1739902538,
 6579,
 1740072888,
 1739931783,
 6585,
 -1,
 1740039150,
 6591,
 -38983,
 1740039150,
 6588,
 -1,
 1740164682,
 6580,
 1740335038,
 1739952527,
 6583,
 1740400573,
 1740248436,
 6584,
 -1,
 1740366830,
 6590,
 -1,
 1740366830,
 6589,
 1740597187,
 1740248436,
 -1,
 1740662721,
 1740510580,
 6577,
 -1,
 1740628974,
 6587,
 -38974,
 1740628974,
 6586,
 -1,
 1740718215,
 6582,
 1740924870,
 1740530047,
 -1,
 -38971,
 1740891118,
 6592,
 -1,
 1740923263,
 6578,
 -38969,
 1740889254,
 6576,
 -1,
 1741045895,
 6581,
 1741252566,
 1739864472,
 -1,
 1741318092,
 1741210324,
 -1,
 -38965,
 1741283727,
 6610,
 -1,
 1741316182,
 6611,
 1741514703,
 1741272863,
 -1,
 -38962,
 1741450990,
 6614,
 -1,
 1741507714,
 6615,
 1741711314,
 1741442646,
 -1,
 -38959,
 1741659120,
 6612,
 -1,
 1741713015,
 6613,
 -38957,
 1741678485,
 6608,
 -38956,
 1741854143,
 6609,
 -38955,
 1741917372,
 6617,
 -1,
 1741964599,
 6616,
 1742170075,
 1741210324,
 -1,
 1742235610,
 1742116351,
 -1,
 -38951,
 1742148263,
 6601,
 -1,
 1742213647,
 6600,
 -1,
 1742166520,
 6618,
 1742536703,
 1742126148,
 6622,
 -1,
 1742460846,
 6623,
 -1,
 1735441144,
 8362,
 1742694399,
 1735349181,
 -1,
 1742759934,
 1742630523,
 -1,
 1742825461,
 1742680187,
 -1,
 1742890993,
 1742770239,
 -1,
 1742956519,
 1742848724,
 -1,
 1743022054,
 1742921298,
 -1,
 -38939,
 1742966789,
 9460,
 -1,
 1743028110,
 9452,
 -1,
 1742953905,
 9453,
 1743284202,
 1742911263,
 -1,
 -38935,
 1743220480,
 9456,
 -1,
 1743277232,
 9457,
 1743480813,
 1743212118,
 -1,
 -38932,
 1743428725,
 9454,
 -1,
 1743479917,
 9455,
 1743677424,
 1743405191,
 -1,
 -38929,
 1743616544,
 9451,
 -1,
 1743676673,
 9458,
 -1,
 1743621313,
 9459,
 1743939572,
 1742829002,
 -1,
 -38925,
 1743888361,
 127327,
 -1,
 1743935627,
 127319,
 -1,
 1743862175,
 9471,
 1744240639,
 1742782325,
 -1,
 1744267259,
 1744139722,
 -1,
 -38920,
 1744216041,
 127359,
 -38919,
 1744273381,
 127356,
 -38918,
 1744335704,
 127355,
 -1,
 1744400169,
 127353,
 -38916,
 1744222105,
 127373,
 -38915,
 1744543822,
 127372,
 -1,
 1744593645,
 127371,
 -1,
 1742684790,
 8879,
 1744857103,
 1742630377,
 -1,
 1744922629,
 1744796055,
 -1,
 1744988164,
 1744849142,
 -1,
 -38909,
 1744924262,
 8820,
 -1,
 1744968229,
 8816,
 -1,
 1744918263,
 8824,
 1745250314,
 1744852831,
 -1,
 1745315849,
 1745176822,
 -1,
 -38904,
 1745251942,
 8821,
 -1,
 1745295909,
 8817,
 -1,
 1745254735,
 8825,
 1745616895,
 1745163636,
 -1,
 1745643534,
 1745488528,
 -1,
 -38899,
 1745593079,
 8841,
 -1,
 1745628187,
 8840,
 -1,
 1745593787,
 8775,
 -38896,
 1744823238,
 9112,
 -38895,
 1745868590,
 9906,
 -1,
 1745921766,
 9798,
 1746102364,
 1735291533,
 -1,
 1746167867,
 1746039640,
 -1,
 1746233401,
 1746095155,
 -1,
 1746298906,
 1746176223,
 2002,
 1746364440,
 1746265130,
 2018,
 -1,
 1746276043,
 2023,
 1746534399,
 1746277748,
 2019,
 -1,
 1746407115,
 2016,
 1746626592,
 1746235177,
 -1,
 1746692127,
 1746572661,
 -1,
 -38883,
 1746643375,
 2026,
 -38882,
 1746693931,
 2024,
 -1,
 1746743081,
 2025,
 -1,
 1746605428,
 2006,
 1747019811,
 1746577748,
 -1,
 -38878,
 1746971055,
 2010,
 -1,
 1746998644,
 2009,
 1747216421,
 1746964879,
 2000,
 -1,
 1747161487,
 1999,
 1747347495,
 1747140743,
 1997,
 -1,
 1747271815,
 1995,
 1747478569,
 1747269259,
 2008,
 -1,
 1747407897,
 2001,
 -38870,
 1747444778,
 2022,
 -38869,
 1747574064,
 2021,
 -38868,
 1747635786,
 1998,
 -38867,
 1747698453,
 2005,
 -38866,
 1747761049,
 2011,
 -38865,
 1747820622,
 2004,
 -38864,
 1747877938,
 2017,
 -38863,
 1747940269,
 2015,
 -38862,
 1748005023,
 2014,
 -38861,
 1748066687,
 1996,
 -38860,
 1748129961,
 2020,
 -38859,
 1748194314,
 2012,
 -38858,
 1748258495,
 2013,
 -38857,
 1748315945,
 2007,
 -38856,
 1748379304,
 2003,
 -1,
 1748440436,
 1994,
 -38854,
 1746181897,
 2037,
 -1,
 1748572598,
 2042,
 1748789321,
 1746090392,
 -1,
 1748854847,
 1748746964,
 -1,
 -38850,
 1748820367,
 1986,
 -1,
 1748852822,
 1987,
 1749051458,
 1748809503,
 -1,
 -38847,
 1748987630,
 1990,
 -1,
 1749044354,
 1991,
 1749248069,
 1748979286,
 -1,
 -38844,
 1749195760,
 1988,
 -1,
 1749249655,
 1989,
 -38842,
 1749215125,
 1984,
 -38841,
 1749390783,
 1985,
 -38840,
 1749454012,
 1993,
 -1,
 1749501239,
 1992,
 1749706839,
 1748709888,
 -1,
 1749772374,
 1749625226,
 -1,
 1749837904,
 1749712162,
 -1,
 -38835,
 1749791463,
 2033,
 -38834,
 1749843537,
 2032,
 -38833,
 1749900593,
 2031,
 -1,
 1749956632,
 2030,
 1750165588,
 1749793629,
 -1,
 -38830,
 1750119143,
 2029,
 -38829,
 1750171217,
 2028,
 -1,
 1750228273,
 2027,
 -38827,
 1750108595,
 2034,
 -1,
 1750351067,
 2035,
 -1,
 1749712946,
 2040,
 1750624346,
 1749664355,
 -1,
 -38823,
 1750570631,
 2038,
 -1,
 1750619150,
 2039,
 -38821,
 1750555963,
 2036,
 -1,
 1750748538,
 2041,
 1750952111,
 1746047375,
 -1,
 1751017611,
 1750903124,
 8893,
 1751083145,
 1750976018,
 -1,
 1751148653,
 1751047797,
 -1,
 1751214186,
 1751061876,
 -1,
 1751279721,
 1751168434,
 8598,
 1751384063,
 1751187456,
 -1,
 1751410790,
 1751304501,
 -1,
 -38811,
 1751350582,
 8632,
 -1,
 1751397196,
 8689,
 -38809,
 1751375913,
 10531,
 -38808,
 1751528652,
 10546,
 -1,
 1751588303,
 10535,
 -1,
 1751222954,
 10529,
 -38805,
 1751178934,
 11009,
 -38804,
 1751792806,
 8662,
 -1,
 1751853571,
 11017,
 1752066172,
 1751083037,
 -1,
 1752131703,
 1751994915,
 -1,
 1752197236,
 1752077763,
 -1,
 -38799,
 1752153368,
 43059,
 -38798,
 1752213589,
 43056,
 -38797,
 1752258955,
 43057,
 -1,
 1752319300,
 43060,
 1752563711,
 1752155967,
 -1,
 -38794,
 1752481074,
 43061,
 -1,
 1752541303,
 43058,
 1752721530,
 1752082372,
 -1,
 -38791,
 1752675886,
 43062,
 -1,
 1752731620,
 43065,
 -38789,
 1752676033,
 43064,
 -1,
 1752867815,
 43063,
 1753087999,
 1751990645,
 -1,
 1753114758,
 1752962420,
 -1,
 1753180293,
 1753068978,
 8599,
 1753284607,
 1753088000,
 -1,
 1753311363,
 1753166913,
 -1,
 -38782,
 1753267932,
 10542,
 -1,
 1753321013,
 10545,
 -38780,
 1753276457,
 10532,
 -1,
 1753423382,
 10536,
 -1,
 1753123518,
 10530,
 -38777,
 1753079478,
 11008,
 -38776,
 1753627814,
 8663,
 -1,
 1753688579,
 11016,
 1753939967,
 1751023833,
 8882,
 -1,
 1753810633,
 8884,
 1754032297,
 1750975188,
 -1,
 1754097830,
 1753939968,
 -1,
 1754163348,
 1754010996,
 -1,
 1754228881,
 1754073744,
 -1,
 -38768,
 1754178285,
 8837,
 -1,
 1754213395,
 8836,
 -38766,
 1754186378,
 8772,
 -38765,
 1754368235,
 8713,
 -1,
 1754430629,
 8777,
 1754622105,
 1754117919,
 -1,
 1754687640,
 1754572837,
 -1,
 -38761,
 1754634449,
 8931,
 -1,
 1754687096,
 8930,
 -1,
 1754621317,
 172,
 1754949788,
 1754579668,
 -1,
 -38757,
 1754904189,
 8877,
 -1,
 1754949119,
 8769,
 1755146398,
 1754893841,
 8938,
 -1,
 1755055817,
 8940,
 1755277473,
 1755072758,
 -1,
 -38752,
 1755213414,
 8813,
 -1,
 1755257381,
 8800,
 -38750,
 1755226394,
 8742,
 -38749,
 1755412815,
 8814,
 -38748,
 1755472800,
 8802,
 -38747,
 1755535095,
 8815,
 -1,
 1755590518,
 9083,
 1755840511,
 1754017665,
 -1,
 -38744,
 1755763876,
 10161,
 -1,
 1755807389,
 10159,
 1755998380,
 1753975007,
 -1,
 -38741,
 1755926963,
 10973,
 -1,
 1755975439,
 8209,
 -38739,
 1755940198,
 8303,
 -38738,
 1756106498,
 160,
 -1,
 1756169107,
 9940,
 1756391622,
 1750863606,
 -1,
 1756457142,
 1756310750,
 -1,
 1756522677,
 1756392506,
 -1,
 -38733,
 1756481621,
 10754,
 -38732,
 1756537970,
 10753,
 -1,
 1756576636,
 10752,
 -1,
 1756469226,
 8720,
 1756850362,
 1756418687,
 8899,
 1756954623,
 1756759681,
 -1,
 -38727,
 1756865612,
 10756,
 -1,
 1756904232,
 10755,
 1757112511,
 1756804895,
 -1,
 1757178046,
 1757063205,
 -1,
 -38723,
 1757139589,
 10758,
 -1,
 1757178433,
 10757,
 -1,
 1757139392,
 8721,
 1757440194,
 1757052141,
 -1,
 -38719,
 1757386742,
 8897,
 -1,
 1757420903,
 8896,
 -38717,
 1757404942,
 11007,
 -38716,
 1757595733,
 10761,
 -38715,
 1757652641,
 8719,
 -1,
 1757702708,
 8898,
 1757898971,
 1756352885,
 -1,
 1757964506,
 1757816959,
 -1,
 1758030030,
 1757922004,
 -1,
 1758095564,
 1757994578,
 -1,
 -38709,
 1758040073,
 9371,
 -1,
 1758101394,
 9363,
 -38707,
 1758027193,
 9364,
 -1,
 1758217979,
 9361,
 1758423251,
 1757984543,
 -1,
 1758488786,
 1758355839,
 -1,
 -38703,
 1758454734,
 9367,
 -1,
 1758483990,
 35,
 -1,
 1758416057,
 9368,
 1758750934,
 1758350934,
 -1,
 -38699,
 1758698621,
 9365,
 -1,
 1758749812,
 9366,
 1758947545,
 1758675079,
 -1,
 -38696,
 1758886438,
 9362,
 -1,
 1758946569,
 9369,
 -1,
 1758891210,
 9370,
 -1,
 1757891065,
 8470,
 1759313919,
 1757812084,
 -1,
 -38691,
 1759234247,
 8302,
 -38690,
 1759294903,
 8239,
 -38689,
 1759349341,
 8892,
 -38688,
 1759407100,
 8358,
 -1,
 1759455730,
 8711,
 1759668800,
 1735221631,
 -1,
 1759734147,
 1759590218,
 -1,
 1759799679,
 1759679321,
 -1,
 1759865161,
 1759757567,
 -1,
 1759930696,
 1759822443,
 -1,
 1759996181,
 1759852064,
 -1,
 1760061716,
 1759913531,
 -1,
 1760127234,
 1760019156,
 -1,
 1760192763,
 1760091400,
 -1,
 1760258298,
 1760116871,
 -1,
 1760323833,
 1760202757,
 13299,
 1760428031,
 1760235219,
 -1,
 1760454896,
 1760346836,
 -1,
 -38673,
 1760420239,
 13301,
 -1,
 1760452694,
 13302,
 1760651507,
 1760409375,
 -1,
 -38670,
 1760587502,
 13305,
 -1,
 1760644226,
 13306,
 1760848118,
 1760579158,
 -1,
 -38667,
 1760795632,
 13303,
 -1,
 1760849527,
 13304,
 -38665,
 1760794047,
 13300,
 -38664,
 1760988348,
 13308,
 -1,
 1761035575,
 13307,
 -1,
 1760264078,
 13291,
 -1,
 1760203151,
 13281,
 1761372417,
 1760123019,
 -1,
 1761437952,
 1761307851,
 -1,
 1761503487,
 1761403886,
 13309,
 -1,
 1761415304,
 13310,
 -1,
 1761428300,
 13292,
 -1,
 1761389648,
 13282,
 -1,
 1761298161,
 13289,
 1761831175,
 1760081695,
 -1,
 1761896709,
 1761767150,
 13285,
 -1,
 1761854682,
 13295,
 1762066431,
 1761823874,
 13286,
 -1,
 1761985754,
 13296,
 1762158861,
 1761758806,
 -1,
 1762224394,
 1762106352,
 13283,
 -1,
 1762182362,
 13293,
 1762394111,
 1762156927,
 -1,
 -38644,
 1762318580,
 13284,
 -1,
 1762349682,
 13294,
 1762552081,
 1762082951,
 -1,
 1762617616,
 1762485475,
 13287,
 -1,
 1762542412,
 13297,
 -1,
 1762556448,
 13290,
 1762814227,
 1762495676,
 13288,
 -1,
 1762772186,
 13298,
 -1,
 1762760127,
 13280,
 -1,
 1759986221,
 13003,
 1763076409,
 1759928329,
 -1,
 1763141926,
 1763033812,
 -1,
 1763207458,
 1763106056,
 -1,
 1763272993,
 1763131527,
 -1,
 1763338528,
 1763217413,
 13164,
 1763442687,
 1763249875,
 -1,
 1763469598,
 1763361492,
 -1,
 -38627,
 1763434895,
 13166,
 -1,
 1763467350,
 13167,
 -38625,
 1763415487,
 13165,
 -1,
 1763594704,
 13168,
 -1,
 1763278734,
 13156,
 -1,
 1763217807,
 13146,
 1763928357,
 1763137675,
 -1,
 -38620,
 1763880016,
 13147,
 -1,
 1763929295,
 13157,
 -1,
 1763854065,
 13154,
 1764190507,
 1763096351,
 -1,
 1764256041,
 1764126446,
 13150,
 -1,
 1764213978,
 13160,
 1764425727,
 1764183170,
 13151,
 -1,
 1764345050,
 13161,
 1764518193,
 1764118102,
 -1,
 1764583726,
 1764465648,
 13148,
 -1,
 1764541658,
 13158,
 1764753407,
 1764516223,
 -1,
 -38608,
 1764677876,
 13149,
 -1,
 1764708978,
 13159,
 1764911413,
 1764442247,
 -1,
 1764976948,
 1764844771,
 13152,
 -1,
 1764901708,
 13162,
 -1,
 1764915744,
 13155,
 1765173559,
 1764854972,
 13153,
 -1,
 1765131482,
 13163,
 -38600,
 1765140373,
 13144,
 -1,
 1765250495,
 13145,
 1765435710,
 1763012393,
 -1,
 1765501245,
 1765396042,
 -1,
 -38596,
 1765444355,
 12997,
 -1,
 1765507000,
 12998,
 -1,
 1765416839,
 12992,
 1765763393,
 1765376050,
 -1,
 -38592,
 1765729262,
 12996,
 -1,
 1765780257,
 12994,
 1765960004,
 1765676404,
 -1,
 -38589,
 1765920846,
 12999,
 -1,
 1765975654,
 12995,
 -38587,
 1765915058,
 13000,
 -38586,
 1766101652,
 13001,
 -38585,
 1766166204,
 13002,
 -1,
 1766215495,
 12993,
 -1,
 1759869724,
 12343,
 1766484319,
 1759780593,
 -1,
 1766549840,
 1766441684,
 -1,
 1766615374,
 1766480011,
 -1,
 -38579,
 1766567013,
 12692,
 -1,
 1766616180,
 12699,
 -38577,
 1766580825,
 12691,
 -1,
 1766758137,
 12694,
 1766943061,
 1766477398,
 -1,
 1767008596,
 1766890480,
 -1,
 -38573,
 1766966806,
 12700,
 -1,
 1766983112,
 12693,
 -1,
 1766943924,
 12697,
 1767270744,
 1766883301,
 -1,
 -38569,
 1767203624,
 12695,
 -1,
 1767251265,
 12703,
 -38567,
 1767225521,
 12698,
 -38566,
 1767419199,
 12689,
 -38565,
 1767478774,
 12690,
 -38564,
 1767537517,
 12688,
 -38563,
 1767594886,
 12701,
 -38562,
 1767653738,
 12702,
 -1,
 1767713553,
 12696,
 1767926131,
 1766405962,
 -1,
 1767991666,
 1767880835,
 -1,
 1768057194,
 1767948838,
 -1,
 1768122725,
 1768019033,
 -1,
 -38556,
 1768074849,
 12281,
 -1,
 1768126085,
 12280,
 1768319336,
 1768059736,
 -1,
 -38553,
 1768267612,
 12282,
 -1,
 1768309658,
 12279,
 -38551,
 1768237139,
 12278,
 -1,
 1768429173,
 12277,
 1768647021,
 1767995307,
 -1,
 -38548,
 1768599137,
 12272,
 -1,
 1768654015,
 12274,
 1768843632,
 1768560412,
 -1,
 -38545,
 1768785070,
 12275,
 -1,
 1768826963,
 12273,
 -38543,
 1768791730,
 12283,
 -1,
 1768968908,
 12276,
 -1,
 1767940445,
 12332,
 1769236854,
 1767845086,
 -1,
 -38539,
 1769182463,
 12289,
 -1,
 1769242088,
 12294,
 -38537,
 1769199788,
 12350,
 -38536,
 1769389805,
 12288,
 -38535,
 1769452275,
 12331,
 -38534,
 1769508958,
 12295,
 -38533,
 1769568784,
 12330,
 -38532,
 1769631173,
 12293,
 -38531,
 1769691574,
 12351,
 -38530,
 1769755330,
 12290,
 -1,
 1769818099,
 12333,
 1770061823,
 1759743900,
 -1,
 1770088834,
 1769982258,
 8801,
 -1,
 1769996623,
 10725,
 -1,
 1770053574,
 10855,
 1770285587,
 1759676639,
 -1,
 1770351059,
 1770239775,
 -1,
 1770416594,
 1770271746,
 -1,
 1770482094,
 1770370630,
 -1,
 1770547618,
 1770420698,
 -1,
 1770613133,
 1770501919,
 -1,
 1770678668,
 1770526068,
 -1,
 -38517,
 1770619860,
 68430,
 -1,
 1770666119,
 68433,
 -1,
 1770610051,
 68436,
 1770940816,
 1770570452,
 -1,
 -38513,
 1770867682,
 68424,
 -1,
 1770923541,
 68437,
 1771137426,
 1770871592,
 68420,
 -1,
 1771095567,
 68423,
 1771268501,
 1771050356,
 -1,
 -38508,
 1771234768,
 68431,
 -1,
 1771272500,
 68416,
 -38506,
 1771235178,
 68422,
 -38505,
 1771431487,
 68425,
 -38504,
 1771494959,
 68421,
 -38503,
 1771547917,
 68435,
 -38502,
 1771612088,
 68434,
 -38501,
 1771676077,
 68432,
 -38500,
 1771737255,
 68429,
 -38499,
 1771799527,
 68428,
 -38498,
 1771861227,
 68427,
 -38497,
 1771925777,
 68426,
 -38496,
 1771984269,
 68418,
 -38495,
 1772041949,
 68419,
 -1,
 1772103983,
 68417,
 1772355583,
 1770491967,
 -1,
 1772382633,
 1772274388,
 -1,
 1772448167,
 1772346632,
 -1,
 -38490,
 1772392847,
 68441,
 -1,
 1772439631,
 68445,
 -38488,
 1772380246,
 68442,
 -1,
 1772570353,
 68444,
 1772775853,
 1772328383,
 68440,
 1772879871,
 1772683264,
 -1,
 -38484,
 1772799773,
 68447,
 -1,
 1772839191,
 68446,
 -1,
 1772704208,
 68443,
 1773142015,
 1770413628,
 -1,
 1773169094,
 1773042138,
 -1,
 1773234613,
 1773123359,
 -1,
 1773300148,
 1773147508,
 -1,
 -38477,
 1773241300,
 68462,
 -1,
 1773287559,
 68464,
 -1,
 1773231491,
 68465,
 1773562296,
 1773191892,
 -1,
 -38473,
 1773489122,
 68456,
 -1,
 1773544981,
 68466,
 1773758906,
 1773493032,
 68452,
 -1,
 1773717007,
 68455,
 -38469,
 1773725546,
 68454,
 -38468,
 1773856319,
 68457,
 -38467,
 1773919800,
 68453,
 -38466,
 1773969837,
 68463,
 -38465,
 1774031015,
 68461,
 -38464,
 1774093291,
 68460,
 -38463,
 1774154987,
 68459,
 -38462,
 1774219537,
 68458,
 -38461,
 1774278029,
 68450,
 -38460,
 1774335709,
 68451,
 -38459,
 1774397743,
 68449,
 -1,
 1774459697,
 68448,
 1774714879,
 1773113407,
 -1,
 1774741965,
 1774633684,
 -1,
 1774807499,
 1774705928,
 -1,
 -38454,
 1774752143,
 68473,
 -1,
 1774798927,
 68477,
 -38452,
 1774739542,
 68474,
 -1,
 1774929649,
 68476,
 1775135185,
 1774687679,
 68472,
 1775239167,
 1775042560,
 -1,
 -38448,
 1775159069,
 68479,
 -1,
 1775198487,
 68478,
 -1,
 1775063504,
 68475,
 -1,
 1770342963,
 9088,
 1775528439,
 1770308731,
 -1,
 1775593960,
 1775479124,
 -1,
 1775659487,
 1775548625,
 8745,
 1775763455,
 1775566848,
 -1,
 1775790555,
 1775689586,
 -1,
 -38439,
 1775738538,
 10819,
 -38438,
 1775795446,
 10820,
 -1,
 1775844136,
 10816,
 1776052702,
 1775703675,
 -1,
 -38435,
 1776013951,
 10823,
 -1,
 1776035704,
 10825,
 -1,
 1775970492,
 10827,
 1776314853,
 1775596376,
 -1,
 1776380388,
 1776248952,
 -1,
 -38430,
 1776338316,
 65531,
 -38429,
 1776400766,
 65530,
 -1,
 1776426336,
 65529,
 -1,
 1776325241,
 9892,
 -38426,
 1776268268,
 8253,
 -38425,
 1776642981,
 10812,
 -1,
 1776692580,
 8890,
 1776943103,
 1775523461,
 8747,
 1777008639,
 1776812032,
 -1,
 1777035763,
 1776934770,
 -1,
 1777101294,
 1776996819,
 -1,
 -38419,
 1777036184,
 10778,
 -1,
 1777088508,
 10780,
 -38417,
 1777059975,
 10776,
 -38416,
 1777245866,
 10779,
 -38415,
 1777301593,
 10775,
 -38414,
 1777363508,
 10777,
 -1,
 1777417622,
 10766,
 1777625590,
 1776948596,
 -1,
 -38411,
 1777588666,
 10767,
 -1,
 1777644778,
 10773,
 -1,
 1777552943,
 9134,
 1777887751,
 1775490990,
 -1,
 1777953283,
 1777813855,
 -1,
 1778018816,
 1777910990,
 -1,
 -38405,
 1777980000,
 8276,
 -38404,
 1778034878,
 191,
 -38403,
 1778094985,
 8487,
 -38402,
 1778152993,
 8766,
 -38401,
 1778215442,
 11800,
 -1,
 1778273658,
 161,
 1778515967,
 1777973403,
 -1,
 -38398,
 1778441922,
 9689,
 -1,
 1778461759,
 9688,
 1778712575,
 1777888539,
 -1,
 -38395,
 1778632766,
 8290,
 -38394,
 1778694526,
 8291,
 -1,
 1778754636,
 8292,
 1778936331,
 1777815126,
 -1,
 1779001866,
 1778870642,
 8734,
 -1,
 1778910706,
 10718,
 -1,
 1778948431,
 8505,
 1779198480,
 1778855134,
 -1,
 1779264015,
 1779149700,
 -1,
 -38386,
 1779205147,
 8710,
 -1,
 1779245900,
 10721,
 -1,
 1779209496,
 10716,
 1779564543,
 1779129521,
 -1,
 -38382,
 1779483255,
 8298,
 -1,
 1779507353,
 8300,
 1779722815,
 1770225637,
 -1,
 1779788349,
 1779671741,
 -1,
 1779853872,
 1779726810,
 -1,
 1779919387,
 1779808031,
 -1,
 1779984922,
 1779832180,
 -1,
 -38375,
 1779925972,
 67662,
 -1,
 1779972231,
 67665,
 -1,
 1779916163,
 67668,
 1780247070,
 1779876564,
 -1,
 -38371,
 1780173794,
 67656,
 -1,
 1780229653,
 67669,
 1780443680,
 1780177704,
 67652,
 -1,
 1780401679,
 67655,
 1780574755,
 1780356468,
 -1,
 -38366,
 1780540880,
 67663,
 -1,
 1780578612,
 67648,
 -38364,
 1780541290,
 67654,
 -38363,
 1780737599,
 67657,
 -38362,
 1780801071,
 67653,
 -38361,
 1780854029,
 67667,
 -38360,
 1780918200,
 67666,
 -38359,
 1780982189,
 67664,
 -38358,
 1781043367,
 67661,
 -38357,
 1781105639,
 67660,
 -38356,
 1781167339,
 67659,
 -38355,
 1781231889,
 67658,
 -38354,
 1781290381,
 67650,
 -38353,
 1781348061,
 67651,
 -1,
 1781410095,
 67649,
 1781623356,
 1779798079,
 -1,
 1781688888,
 1781580500,
 -1,
 1781754421,
 1781652744,
 -1,
 -38348,
 1781698959,
 67673,
 -1,
 1781745743,
 67676,
 1781951031,
 1781679857,
 67675,
 -1,
 1781861073,
 67679,
 -1,
 1781882966,
 67674,
 1782185983,
 1781634495,
 67672,
 1782251519,
 1782054912,
 -1,
 -38341,
 1782171421,
 67678,
 -1,
 1782210839,
 67677,
 -1,
 1781577958,
 67671,
 1782513663,
 1779701931,
 8887,
 -1,
 1782384292,
 8787,
 -1,
 1779642015,
 9976,
 1782672134,
 1759596118,
 -1,
 1782737611,
 1782632010,
 -1,
 1782803142,
 1782676482,
 -1,
 1782868674,
 1782767423,
 -1,
 1782934148,
 1782805336,
 -1,
 1782999676,
 1782850843,
 -1,
 1783065185,
 1782955530,
 -1,
 -38328,
 1783031582,
 65370,
 -38327,
 1783096302,
 65369,
 -38326,
 1783161604,
 65368,
 -38325,
 1783225608,
 65367,
 -38324,
 1783289774,
 65366,
 -38323,
 1783352906,
 65365,
 -38322,
 1783415508,
 65364,
 -38321,
 1783478047,
 65363,
 -38320,
 1783540052,
 65362,
 -38319,
 1783605060,
 65361,
 -38318,
 1783668713,
 65360,
 -38317,
 1783730575,
 65359,
 -38316,
 1783793887,
 65358,
 -38315,
 1783857125,
 65357,
 -38314,
 1783919448,
 65356,
 -38313,
 1783984264,
 65355,
 -38312,
 1784049449,
 65354,
 -38311,
 1784111487,
 65353,
 -38310,
 1784174731,
 65352,
 -38309,
 1784238819,
 65351,
 -38308,
 1784303190,
 65350,
 -38307,
 1784365191,
 65349,
 -38306,
 1784428064,
 65348,
 -38305,
 1784491230,
 65347,
 -38304,
 1784555126,
 65346,
 -1,
 1784616308,
 65345,
 1784872959,
 1782984196,
 -1,
 -38301,
 1784801054,
 65338,
 -38300,
 1784865774,
 65337,
 -38299,
 1784931076,
 65336,
 -38298,
 1784995080,
 65335,
 -38297,
 1785059246,
 65334,
 -38296,
 1785122378,
 65333,
 -38295,
 1785184980,
 65332,
 -38294,
 1785247519,
 65331,
 -38293,
 1785309524,
 65330,
 -38292,
 1785374532,
 65329,
 -38291,
 1785438185,
 65328,
 -38290,
 1785500047,
 65327,
 -38289,
 1785563359,
 65326,
 -38288,
 1785626597,
 65325,
 -38287,
 1785688920,
 65324,
 -38286,
 1785753736,
 65323,
 -38285,
 1785818921,
 65322,
 -38284,
 1785880959,
 65321,
 -38283,
 1785944203,
 65320,
 -38282,
 1786008291,
 65319,
 -38281,
 1786072662,
 65318,
 -38280,
 1786134663,
 65317,
 -38279,
 1786197536,
 65316,
 -38278,
 1786260702,
 65315,
 -38277,
 1786324598,
 65314,
 -1,
 1786385780,
 65313,
 1786604163,
 1782923399,
 -1,
 1786669698,
 1786532449,
 -1,
 -38273,
 1786633951,
 65375,
 -38272,
 1786691422,
 65339,
 -38271,
 1786749222,
 65288,
 -1,
 1786787221,
 65371,
 -1,
 1786625971,
 65308,
 -1,
 1786552052,
 65343,
 1787128468,
 1782855200,
 -1,
 1787194003,
 1787061626,
 -1,
 1787259529,
 1787151060,
 -1,
 -38264,
 1787224463,
 65298,
 -1,
 1787256918,
 65299,
 1787456140,
 1787213599,
 -1,
 -38261,
 1787391726,
 65302,
 -1,
 1787448450,
 65303,
 1787652751,
 1787383382,
 -1,
 -38258,
 1787599856,
 65300,
 -1,
 1787653751,
 65301,
 -38256,
 1787619221,
 65296,
 -38255,
 1787794879,
 65297,
 -38254,
 1787858108,
 65305,
 -1,
 1787905335,
 65304,
 -1,
 1787139213,
 65284,
 1788177051,
 1787078996,
 -1,
 1788242586,
 1788110056,
 -1,
 -38249,
 1788206815,
 65376,
 -38248,
 1788264286,
 65341,
 -38247,
 1788322086,
 65289,
 -1,
 1788360085,
 65373,
 -1,
 1788169443,
 65340,
 1788635811,
 1788095710,
 -1,
 1788701345,
 1788580239,
 -1,
 1788766880,
 1788642804,
 -1,
 -38241,
 1788692906,
 65312,
 -1,
 1788745076,
 65292,
 -1,
 1788706066,
 65306,
 -38238,
 1788636243,
 65342,
 -1,
 1788954566,
 65504,
 1789160103,
 1788583913,
 -1,
 -38235,
 1789107094,
 65505,
 -38234,
 1789165430,
 65291,
 -1,
 1789217174,
 65285,
 1789422251,
 1789072756,
 -1,
 -38231,
 1789378675,
 65290,
 -38230,
 1789437296,
 65287,
 -1,
 1789495153,
 65286,
 1789684398,
 1789376287,
 -1,
 -38227,
 1789629539,
 65295,
 -1,
 1789675136,
 65307,
 1789881009,
 1789634497,
 -1,
 -38224,
 1789827730,
 65282,
 -1,
 1789872937,
 65311,
 1790077620,
 1789823199,
 -1,
 -38221,
 1790038443,
 65283,
 -1,
 1790089854,
 65506,
 1790274231,
 1790006893,
 -1,
 -38218,
 1790198155,
 65310,
 -1,
 1790256617,
 65344,
 1790470842,
 1790197895,
 -1,
 -38215,
 1790436166,
 65281,
 -1,
 1790486531,
 65309,
 -38213,
 1790436655,
 65509,
 -38212,
 1790632627,
 65510,
 -38211,
 1790696179,
 65372,
 -38210,
 1790756860,
 65374,
 -38209,
 1790804027,
 65507,
 -38208,
 1790861679,
 65293,
 -38207,
 1790923458,
 65294,
 -1,
 1790979049,
 65508,
 1791229951,
 1782775808,
 -1,
 -38204,
 1791148221,
 46,
 -38203,
 1791204541,
 10199,
 -1,
 1791240848,
 9608,
 1791453897,
 1782745311,
 -1,
 -38200,
 1791379853,
 9905,
 -1,
 1791440155,
 8289,
 -38198,
 1791408280,
 9179,
 -1,
 1791575489,
 9981,
 1791781598,
 1782681999,
 -1,
 1791847128,
 1791741514,
 -1,
 1791912663,
 1791797588,
 -1,
 1791978197,
 1791819776,
 -1,
 1792043730,
 1791900460,
 -1,
 -38191,
 1791993583,
 8280,
 -1,
 1792049754,
 8283,
 -38189,
 1792001170,
 10018,
 -38188,
 1792160211,
 10021,
 -1,
 1792222987,
 10019,
 -38186,
 1791936030,
 8732,
 -1,
 1792348315,
 8197,
 -1,
 1791856487,
 9970,
 1792671743,
 1791797588,
 -1,
 1792699100,
 1792569480,
 -1,
 -38181,
 1792632999,
 10972,
 -1,
 1792688843,
 11792,
 -38179,
 1792618270,
 8873,
 -1,
 1792802883,
 8704,
 1793026792,
 1791713663,
 -1,
 1793092322,
 1792989435,
 -1,
 -38175,
 1793042159,
 8281,
 -1,
 1793098330,
 11821,
 1793288933,
 1793022023,
 -1,
 -38172,
 1793244909,
 8199,
 -1,
 1793275657,
 8210,
 -38170,
 1793243922,
 9673,
 -38169,
 1793439240,
 9789,
 -1,
 1793494274,
 10765,
 1793682161,
 1792963416,
 -1,
 1793747693,
 1793626511,
 -1,
 1793813228,
 1793711724,
 9880,
 -1,
 1793722754,
 8277,
 -1,
 1793763953,
 10086,
 1794009840,
 1793660276,
 -1,
 -38161,
 1793968428,
 9189,
 -1,
 1794003688,
 9971,
 -1,
 1793936469,
 9884,
 1794271993,
 1793632596,
 -1,
 1794337525,
 1794216335,
 -1,
 -38156,
 1794302286,
 8994,
 -1,
 1794346813,
 10156,
 1794534136,
 1794250649,
 -1,
 -38153,
 1794489725,
 8260,
 -1,
 1794543755,
 8543,
 -1,
 1794459477,
 8355,
 1794796289,
 1794184564,
 -1,
 1794861823,
 1794735238,
 -1,
 1794927358,
 1794782273,
 -1,
 -38147,
 1794880181,
 10540,
 -1,
 1794936356,
 10543,
 -1,
 1794860948,
 9950,
 -38144,
 1794815478,
 9771,
 -1,
 1795110155,
 8507,
 1795358719,
 1794719879,
 -1,
 1795386117,
 1795260389,
 -1,
 -38140,
 1795320110,
 170,
 -1,
 1795365544,
 9792,
 -1,
 1795339746,
 9972,
 1795648420,
 1782632010,
 -1,
 1795713893,
 1795596265,
 -1,
 1795779385,
 1795677530,
 -1,
 1795844886,
 1795691892,
 -1,
 1795910421,
 1795798450,
 8593,
 1796014079,
 1795817472,
 -1,
 1796041490,
 1795940210,
 -1,
 1796107024,
 1795999963,
 -1,
 -38129,
 1796059284,
 8625,
 -1,
 1796110399,
 8624,
 -38127,
 1796038518,
 10505,
 -1,
 1796226454,
 8670,
 -38125,
 1796000057,
 10514,
 -38124,
 1796372595,
 8645,
 -1,
 1796428367,
 8613,
 -1,
 1795852887,
 11797,
 1796696868,
 1795775171,
 -1,
 1796762399,
 1796634245,
 -1,
 1796827934,
 1796669440,
 -1,
 1796893468,
 1796745396,
 -1,
 -38117,
 1796855132,
 10595,
 -1,
 1796882281,
 10606,
 -38115,
 1796852025,
 10584,
 -1,
 1797018191,
 10592,
 -1,
 1796791636,
 8639,
 1797324799,
 1796714081,
 -1,
 1797352227,
 1797193728,
 -1,
 -38110,
 1797310777,
 10580,
 -1,
 1797345871,
 10588,
 -1,
 1797315924,
 8638,
 1797614382,
 1796660911,
 -1,
 1797679916,
 1797530210,
 8679,
 1797783551,
 1797586944,
 -1,
 1797810987,
 1797690697,
 8683,
 1797914623,
 1797721123,
 -1,
 -38102,
 1797839452,
 8685,
 -1,
 1797873368,
 8684,
 -1,
 1797739087,
 8682,
 1798176767,
 1797602470,
 8686,
 -1,
 1798047328,
 8687,
 1798269747,
 1797571284,
 -1,
 1798335282,
 1798234511,
 -1,
 -38095,
 1798246325,
 10569,
 -1,
 1798308948,
 8607,
 -1,
 1798287913,
 10506,
 1798597430,
 1798190624,
 -1,
 -38091,
 1798544199,
 8657,
 -1,
 1798579077,
 8673,
 -38089,
 1798547427,
 10224,
 -38088,
 1798742152,
 8648,
 -1,
 1798777347,
 11014,
 1798990671,
 1795686400,
 -1,
 1799056192,
 1798913588,
 -1,
 1799121725,
 1798972002,
 8597,
 -1,
 1799031850,
 8616,
 -38082,
 1799085750,
 8691,
 -38081,
 1799175334,
 8661,
 -1,
 1799236099,
 11021,
 1799449415,
 1798973320,
 -1,
 1799514948,
 1799401224,
 -1,
 -38077,
 1799466839,
 10575,
 -1,
 1799517999,
 10572,
 1799749631,
 1799452389,
 -1,
 -38074,
 1799663447,
 10573,
 -1,
 1799714607,
 10577,
 1799908171,
 1799365218,
 -1,
 1799973706,
 1799838518,
 8963,
 -1,
 1799881258,
 8996,
 -1,
 1799883483,
 10685,
 1800170317,
 1799865177,
 8869,
 -1,
 1800080462,
 10207,
 -38066,
 1800122057,
 8944,
 -1,
 1800229014,
 10622,
 1800432482,
 1798939220,
 -1,
 1800498007,
 1800384103,
 -1,
 -38062,
 1800456954,
 9721,
 -38061,
 1800518258,
 10066,
 -38060,
 1800579021,
 9693,
 -38059,
 1800643114,
 10000,
 -38058,
 1800706073,
 9137,
 -1,
 1800749035,
 10064,
 1800956764,
 1800435338,
 -1,
 -38055,
 1800915706,
 9720,
 -38054,
 1800972237,
 9692,
 -38053,
 1801033789,
 9136,
 -1,
 1801073540,
 10196,
 1801284448,
 1800886672,
 -1,
 -38050,
 1801218744,
 9690,
 -38049,
 1801269314,
 9696,
 -1,
 1801333392,
 9600,
 -38047,
 1801229776,
 9620,
 -1,
 1801464430,
 9985,
 1801715711,
 1800343798,
 -1,
 -38044,
 1801629476,
 9710,
 -1,
 1801680639,
 9709,
 1801874318,
 1795642281,
 -1,
 1801939853,
 1801812442,
 -1,
 1802005357,
 1801893663,
 -1,
 1802070891,
 1801917812,
 -1,
 -38038,
 1802012139,
 66450,
 -1,
 1802057546,
 66453,
 -38036,
 1802027384,
 66461,
 -1,
 1802198403,
 66444,
 1802398577,
 1801962196,
 -1,
 -38033,
 1802342799,
 66458,
 -38032,
 1802394226,
 66456,
 -1,
 1802455869,
 66441,
 1802660724,
 1802364702,
 -1,
 -38029,
 1802620490,
 66449,
 -1,
 1802652504,
 66439,
 1802857335,
 1802596488,
 -1,
 -38026,
 1802786985,
 66435,
 -1,
 1802836103,
 66443,
 1803053945,
 1802788447,
 66437,
 -1,
 1803010837,
 66440,
 1803185020,
 1802982115,
 -1,
 -38021,
 1803114843,
 66457,
 -1,
 1803164901,
 66434,
 1803381631,
 1803105824,
 -1,
 -38018,
 1803311481,
 66447,
 -1,
 1803372072,
 66436,
 1803578242,
 1803294068,
 -1,
 -38015,
 1803517649,
 66432,
 -1,
 1803577136,
 66451,
 -38013,
 1803544109,
 66442,
 -38012,
 1803739535,
 66438,
 -38011,
 1803800138,
 66460,
 -38010,
 1803856616,
 66455,
 -38009,
 1803921331,
 66454,
 -38008,
 1803986668,
 66452,
 -38007,
 1804046503,
 66448,
 -38006,
 1804108775,
 66446,
 -38005,
 1804170463,
 66445,
 -38004,
 1804231039,
 66459,
 -1,
 1804282135,
 66433,
 -1,
 1801904828,
 66463,
 1804561311,
 1801816287,
 -1,
 1804626843,
 1804493183,
 -1,
 1804692378,
 1804571949,
 8746,
 1804795903,
 1804599296,
 -1,
 1804823446,
 1804722034,
 -1,
 -37996,
 1804770986,
 10818,
 -37995,
 1804830129,
 10817,
 -1,
 1804893442,
 10821,
 1805085593,
 1804736123,
 -1,
 -37992,
 1805019700,
 10822,
 -1,
 1805068129,
 10824,
 -1,
 1805002976,
 10826,
 -1,
 1804655079,
 9842,
 1805413278,
 1804547616,
 -1,
 -37987,
 1805357514,
 9100,
 -1,
 1805404717,
 8255,
 -1,
 1805353573,
 9903,
 1805675427,
 1804501769,
 9730,
 1805778943,
 1805582336,
 -1,
 -37982,
 1805705396,
 9748,
 -1,
 1805751604,
 9969,
 -1,
 1805626074,
 9797,
 1806003278,
 1795611912,
 -1,
 1806068788,
 1805932683,
 -1,
 1806134321,
 1806003624,
 -1,
 1806199856,
 1806041088,
 -1,
 1806265287,
 1806153503,
 -1,
 1806330810,
 1806215199,
 9633,
 1806434303,
 1806237696,
 -1,
 1806461881,
 1806360434,
 -1,
 1806527409,
 1806398296,
 -1,
 1806592944,
 1806475078,
 -1,
 -37969,
 1806544821,
 9714,
 -1,
 1806595975,
 9713,
 -1,
 1806517394,
 10212,
 1806855092,
 1806488665,
 -1,
 -37965,
 1806806965,
 9715,
 -1,
 1806858119,
 9712,
 1807051703,
 1806805332,
 -1,
 -37962,
 1806998461,
 9634,
 -1,
 1807050028,
 10213,
 -37960,
 1807014560,
 9707,
 -1,
 1807167213,
 9093,
 -1,
 1806381812,
 9635,
 1807444929,
 1806270437,
 -1,
 1807510464,
 1807358888,
 -1,
 1807575999,
 1807464223,
 -1,
 -37954,
 1807533092,
 11090,
 -1,
 1807591455,
 9643,
 -1,
 1807515337,
 11051,
 -1,
 1807443488,
 9786,
 -37950,
 1807405526,
 9788,
 -37949,
 1807860772,
 9734,
 -37948,
 1807917182,
 9828,
 -37947,
 1807965805,
 9750,
 -37946,
 1808026199,
 65094,
 -1,
 1808085254,
 9988,
 1808296929,
 1806183646,
 -1,
 1808362452,
 1808231452,
 9675,
 1808465919,
 1808272419,
 -1,
 1808493517,
 1808389209,
 -1,
 -37940,
 1808445365,
 9719,
 -1,
 1808496519,
 9716,
 1808690128,
 1808432730,
 -1,
 -37937,
 1808641973,
 9718,
 -1,
 1808693127,
 9717,
 1808886739,
 1808612036,
 -1,
 -37934,
 1808851285,
 10732,
 -1,
 1808909066,
 9862,
 -1,
 1808846197,
 9863,
 1809148892,
 1808292952,
 -1,
 1809214424,
 1809084552,
 -1,
 -37929,
 1809157280,
 9816,
 -1,
 1809213607,
 9812,
 -37927,
 1809167455,
 9814,
 -37926,
 1809361071,
 9813,
 -37925,
 1809424786,
 9817,
 -1,
 1809459655,
 9815,
 1809673184,
 1809094053,
 10209,
 1809776639,
 1809583139,
 -1,
 -37921,
 1809690948,
 10211,
 -1,
 1809741995,
 10210,
 -1,
 1809612590,
 9831,
 1810000880,
 1808217632,
 -1,
 1810066408,
 1809932875,
 9671,
 1810169855,
 1809973248,
 -1,
 -37915,
 1810096028,
 10192,
 -37914,
 1810153899,
 9826,
 -37913,
 1810196350,
 9931,
 -1,
 1810248405,
 9672,
 1810459629,
 1810014123,
 -1,
 1810525164,
 1810370745,
 -1,
 -37909,
 1810483962,
 9661,
 -1,
 1810546215,
 9663,
 -1,
 1810434406,
 9759,
 1810825215,
 1810410240,
 -1,
 -37905,
 1810727414,
 9920,
 -1,
 1810788954,
 9921,
 1810983930,
 1809951060,
 -1,
 1811049465,
 1810916579,
 -1,
 1811115000,
 1810960569,
 -1,
 1811180534,
 1811062761,
 -1,
 -37899,
 1811125207,
 9659,
 -1,
 1811171279,
 11092,
 -37897,
 1811139322,
 9655,
 -1,
 1811332647,
 9657,
 -1,
 1811024230,
 9758,
 -1,
 1810973267,
 9645,
 1811639300,
 1810920280,
 -1,
 1811704835,
 1811563418,
 -1,
 1811770368,
 1811615929,
 -1,
 -37890,
 1811729146,
 9665,
 -37889,
 1811791399,
 9667,
 -1,
 1811850469,
 9669,
 1812070399,
 1811677184,
 -1,
 -37886,
 1811981584,
 9756,
 -1,
 1812034802,
 9945,
 -1,
 1811620266,
 11036,
 1812294667,
 1811579775,
 -1,
 1812360201,
 1812248351,
 -1,
 -37881,
 1812317220,
 11088,
 -37880,
 1812375583,
 9723,
 -1,
 1812431305,
 9725,
 -37878,
 1812299465,
 11048,
 -1,
 1812543789,
 11046,
 1812753426,
 1812221526,
 -1,
 1812818960,
 1812689752,
 -1,
 1812884495,
 1812732051,
 9872,
 -1,
 1812794774,
 9983,
 -1,
 1812830392,
 10048,
 -37871,
 1812772139,
 9785,
 -1,
 1813027924,
 10023,
 1813212184,
 1812715929,
 -1,
 1813277719,
 1813170114,
 -1,
 -37867,
 1813228551,
 9647,
 -37866,
 1813267956,
 11055,
 -1,
 1813325646,
 11006,
 -1,
 1813242893,
 11038,
 1813605406,
 1813172996,
 -1,
 1813670941,
 1813516473,
 -1,
 1813736476,
 1813629690,
 9651,
 -1,
 1813646583,
 9708,
 -1,
 1813691943,
 9653,
 -1,
 1813580134,
 9757,
 1813998628,
 1813562068,
 -1,
 1814064162,
 1813948756,
 -1,
 -37855,
 1813996182,
 10177,
 -1,
 1814044603,
 9186,
 -37853,
 1814028955,
 9943,
 -1,
 1814185443,
 9743,
 1814391851,
 1813928075,
 -1,
 1814457384,
 1814335887,
 -1,
 -37849,
 1814418913,
 10710,
 -1,
 1814475564,
 11053,
 1814691839,
 1814380679,
 -1,
 -37846,
 1814618919,
 11041,
 -1,
 1814635196,
 9825,
 1814850606,
 1814339561,
 -1,
 -37843,
 1814775759,
 11040,
 -1,
 1814831353,
 9649,
 -37841,
 1814793347,
 10001,
 -1,
 1814965311,
 9702,
 -1,
 1806110590,
 10163,
 1815281663,
 1806058296,
 -1,
 -37837,
 1815162693,
 9855,
 -1,
 1815217727,
 9784,
 1815440451,
 1805981044,
 -1,
 1815505985,
 1815402414,
 -1,
 1815571516,
 1815471088,
 -1,
 1815637050,
 1815507800,
 -1,
 -37831,
 1815584500,
 65103,
 -1,
 1815636066,
 8967,
 -37829,
 1815584475,
 65099,
 -1,
 1815754505,
 12336,
 1816002559,
 1815494793,
 -1,
 1816030272,
 1815880329,
 -1,
 -37825,
 1815981665,
 10547,
 -1,
 1816032901,
 11071,
 -1,
 1815951113,
 12316,
 -37822,
 1815463023,
 8986,
 -1,
 1816245193,
 9888,
 1816423496,
 1815384463,
 -1,
 1816489031,
 1816374097,
 -1,
 -37818,
 1816443293,
 11825,
 -1,
 1816490028,
 8288,
 -1,
 1816430840,
 8361,
 1816751179,
 1816373588,
 -1,
 -37814,
 1816686083,
 9997,
 -1,
 1816740256,
 8768,
 1816985599,
 1816674439,
 -1,
 -37811,
 1816903710,
 9840,
 -1,
 1816934484,
 10172,
 1817144523,
 1805938473,
 -1,
 1817210055,
 1817056628,
 -1,
 1817275588,
 1817171981,
 -1,
 1817341065,
 1817212498,
 -1,
 1817406600,
 1817300058,
 -1,
 1817472091,
 1817348319,
 -1,
 1817537623,
 1817400068,
 43412,
 1817640959,
 1817445743,
 43402,
 -1,
 1817512371,
 43403,
 1817734233,
 1817502762,
 43418,
 -1,
 1817642475,
 43416,
 1817903103,
 1817646452,
 43428,
 -1,
 1817773547,
 43423,
 1817996384,
 1817428692,
 -1,
 1818061918,
 1817953045,
 43419,
 -1,
 1817970109,
 43420,
 1818230783,
 1817974132,
 43424,
 -1,
 1818101227,
 43425,
 1818324069,
 1817916960,
 -1,
 1818389603,
 1818244747,
 43421,
 -1,
 1818297789,
 43422,
 1818558463,
 1818301812,
 43426,
 -1,
 1818428861,
 43427,
 1818651753,
 1818277785,
 43441,
 1818755071,
 1818559930,
 -1,
 -37784,
 1818678738,
 43439,
 -1,
 1818695961,
 43440,
 1818913901,
 1818599502,
 43429,
 1819017215,
 1818820608,
 -1,
 -37780,
 1818921061,
 43430,
 -1,
 1818963736,
 43401,
 1819176049,
 1818849439,
 43407,
 1819279359,
 1819082752,
 -1,
 -37776,
 1819195441,
 43408,
 -1,
 1819248741,
 43409,
 1819438196,
 1819107711,
 43398,
 -37773,
 1819369855,
 43399,
 -1,
 1819411721,
 43397,
 1819634806,
 1819388335,
 43435,
 -1,
 1819541564,
 43436,
 1819765880,
 1819569963,
 43415,
 -1,
 1819674045,
 43417,
 1819896954,
 1819693828,
 43410,
 -1,
 1819805163,
 43411,
 1820028028,
 1819815227,
 43413,
 -1,
 1819936235,
 43414,
 1820159102,
 1819944616,
 43431,
 -1,
 1820067307,
 43432,
 1820290176,
 1820071284,
 43396,
 -1,
 1820221823,
 43405,
 -37759,
 1820255274,
 43434,
 -37758,
 1820384560,
 43438,
 -37757,
 1820446282,
 43400,
 -37756,
 1820496271,
 43406,
 -37755,
 1820557362,
 43433,
 -37754,
 1820619693,
 43437,
 -37753,
 1820678313,
 43442,
 -1,
 1820737671,
 43404,
 -1,
 1817334373,
 43457,
 1821011102,
 1817288782,
 -1,
 1821076635,
 1820931726,
 -1,
 1821142160,
 1821012824,
 -1,
 1821207695,
 1821101642,
 -1,
 -37746,
 1821150283,
 43465,
 -1,
 1821204776,
 43461,
 -1,
 1821141262,
 43464,
 1821469844,
 1821054324,
 -1,
 1821535379,
 1821390703,
 43466,
 -1,
 1821442102,
 43467,
 -1,
 1821477610,
 43459,
 1821731991,
 1821417449,
 -1,
 -37738,
 1821666552,
 43468,
 -1,
 1821712035,
 43463,
 -37736,
 1821695840,
 43462,
 -37735,
 1821886694,
 43486,
 -37734,
 1821933672,
 43460,
 -1,
 1821994239,
 43487,
 1822228479,
 1821019063,
 -1,
 -37731,
 1822141126,
 43471,
 -1,
 1822192292,
 43456,
 1822387372,
 1820932504,
 -1,
 1822452898,
 1822343892,
 -1,
 -37727,
 1822417295,
 43474,
 -1,
 1822449750,
 43475,
 1822649509,
 1822406431,
 -1,
 -37724,
 1822584558,
 43478,
 -1,
 1822641282,
 43479,
 1822846120,
 1822576214,
 -1,
 -37721,
 1822792688,
 43476,
 -1,
 1822846583,
 43477,
 -37719,
 1822812053,
 43472,
 -37718,
 1822987711,
 43473,
 -37717,
 1823050940,
 43481,
 -1,
 1823098167,
 43480,
 1823304888,
 1822350518,
 -1,
 1823370418,
 1823261396,
 -1,
 1823435953,
 1823282548,
 -1,
 -37712,
 1823389365,
 43444,
 -1,
 1823439707,
 43450,
 -1,
 1823380657,
 43445,
 1823698100,
 1823335152,
 43446,
 -1,
 1823606228,
 43447,
 1823829174,
 1823654320,
 43448,
 -1,
 1823737307,
 43449,
 -37705,
 1823777358,
 43452,
 -1,
 1823881780,
 43451,
 1824091326,
 1823259696,
 -1,
 1824156859,
 1824009896,
 43393,
 -1,
 1824066245,
 43443,
 -37700,
 1824120659,
 43395,
 -37699,
 1824235732,
 43392,
 -1,
 1824290331,
 43394,
 1824484546,
 1824010898,
 -1,
 -37696,
 1824432700,
 43454,
 -37695,
 1824485864,
 43453,
 -1,
 1824533832,
 43455,
 -37693,
 1824443674,
 43469,
 -1,
 1824698329,
 43458,
 1824915455,
 1817223364,
 -1,
 -37690,
 1824811079,
 12292,
 -1,
 1824859963,
 9979,
 1825074378,
 1817169482,
 -1,
 -37687,
 1825022945,
 9795,
 -1,
 1825082766,
 9909,
 -1,
 1825018790,
 10781,
 1825336554,
 1817094081,
 -1,
 1825402083,
 1825248628,
 -1,
 1825467617,
 1825324986,
 -1,
 1825533150,
 1825382231,
 -1,
 1825598683,
 1825494105,
 -1,
 1825664216,
 1825535621,
 9624,
 1825767423,
 1825570938,
 -1,
 1825795285,
 1825690765,
 -1,
 -37676,
 1825746529,
 9628,
 -1,
 1825797765,
 9627,
 1826029567,
 1825734234,
 -1,
 -37673,
 1825943137,
 9626,
 -1,
 1825994394,
 9625,
 1826226175,
 1825615457,
 9629,
 1826291711,
 1826095349,
 9630,
 -1,
 1826160901,
 9631,
 1826422783,
 1825537626,
 -1,
 -37667,
 1826336353,
 9623,
 -1,
 1826387589,
 9622,
 1826619391,
 1825494085,
 -1,
 -37664,
 1826530923,
 8279,
 -1,
 1826580940,
 10764,
 -37662,
 1825424809,
 10774,
 -1,
 1826731576,
 9833,
 1826909416,
 1825327906,
 -1,
 1826974951,
 1826816000,
 -1,
 -37658,
 1826914906,
 63,
 -1,
 1826966906,
 8264,
 -1,
 1826898596,
 8799,
 -37655,
 1826855570,
 34,
 -1,
 1827170264,
 9915,
 1827368197,
 1825302302,
 -1,
 1827433727,
 1827276311,
 -1,
 1827499251,
 1827387167,
 -1,
 1827564786,
 1827418018,
 -1,
 1827630321,
 1827512297,
 -1,
 -37648,
 1827582990,
 10785,
 -1,
 1827630031,
 10784,
 -1,
 1827549794,
 10783,
 -1,
 1827513722,
 10625,
 1827958009,
 1827449172,
 -1,
 1828023543,
 1827890408,
 -1,
 -37642,
 1827956330,
 10632,
 -1,
 1828006266,
 10634,
 -37640,
 1827947977,
 10814,
 -1,
 1828134542,
 10853,
 1828351228,
 1827894922,
 -1,
 -37637,
 1828284010,
 10631,
 -1,
 1828333946,
 10633,
 -37635,
 1828310579,
 10626,
 -37634,
 1828469505,
 10852,
 -1,
 1828529889,
 8959,
 1828782079,
 1827359234,
 -1,
 1828809987,
 1828687246,
 -1,
 -37630,
 1828751658,
 8204,
 -1,
 1828785922,
 65279,
 -37628,
 1828765421,
 8203,
 -1,
 1828941868,
 8205,
 1829175295,
 1827332868,
 -1,
 -37625,
 1829083126,
 8891,
 -1,
 1829110937,
 8999]
_charnames_32 = [
19793,
11930,
27880,
26833,
24411,
26456,
14011,
13811,
9736,
25505,
13995,
26421,
3790,
21089,
27331,
19716,
24746,
24750,
24720,
24724,
24738,
24742,
24729,
24733,
24758,
24754,
4033,
19747,
10007,
11882,
21793,
27877,
3789,
8552,
8979,
8903,
8854,
8603,
9011,
8889,
8872,
8725,
9007,
8933,
8798,
8989,
8836,
8493,
8969,
9003,
8776,
8757,
8693,
8649,
8959,
8947,
8999,
8819,
8917,
9640,
25869,
25438,
4958,
10100,
21795,
7965,
8373,
8284,
8206,
7908,
8445,
8358,
8264,
8174,
8452,
8342,
8139,
8413,
8240,
7848,
8400,
8438,
8103,
8069,
7780,
8020,
8387,
8426,
8459,
8324,
8304,
9689,
24037,
25491,
17793,
]

_charnames_160 = [
26797,
27135,
5207,
26474,
2535,
15318,
15581,
19753,
24832,
3985,
27395,
9862,
26776,
19720,
25896,
6527,
24709,
26438,
19316,
19317,
14004,
7772,
26467,
7770,
5209,
19330,
6524,
25630,
24077,
24079,
24084,
27131,
8589,
8590,
8555,
8583,
8570,
8580,
8591,
8906,
8635,
8637,
8606,
8624,
8745,
8747,
8738,
8733,
8643,
8849,
8543,
8545,
8516,
8524,
8513,
7346,
8535,
8688,
8690,
8680,
8653,
8834,
8720,
8101,
8006,
8007,
7968,
8000,
7983,
7995,
8008,
8287,
7942,
7944,
7911,
7929,
8193,
8195,
8185,
8180,
7960,
8255,
7897,
7899,
7871,
7879,
7868,
24845,
7892,
8061,
8063,
8051,
8024,
8340,
7838,
8330,
8586,
8003,
8572,
7985,
8585,
8002,
8913,
8295,
8908,
8290,
8912,
8294,
8909,
8291,
8863,
8212,
8859,
8221,
8625,
7930,
8636,
7943,
8622,
7927,
8632,
7938,
8617,
7922,
8892,
8361,
8899,
8369,
8898,
8368,
8893,
8362,
8881,
8273,
8884,
8276,
8735,
8182,
8742,
8190,
8746,
8194,
8741,
8189,
8731,
8234,
9017,
8475,
9010,
8456,
8942,
8351,
8357,
8817,
8161,
8806,
8144,
8807,
8145,
8813,
8152,
8809,
8156,
8852,
8260,
8844,
8246,
8845,
8247,
8261,
8648,
7964,
8530,
7884,
8544,
7898,
8512,
7867,
9016,
8473,
8792,
8125,
8786,
8118,
8787,
8119,
8769,
8081,
8763,
8075,
8764,
8076,
8760,
8072,
8698,
7816,
8699,
7817,
8705,
7825,
8675,
8046,
8683,
8057,
8689,
8062,
8685,
8055,
8664,
8035,
8686,
8059,
8956,
8436,
8833,
8339,
8825,
8932,
8323,
8922,
8309,
8929,
8314,
8162,
8379,
8987,
8984,
8378,
8718,
7834,
8547,
8911,
8293,
8601,
8869,
8867,
8214,
7809,
8795,
8774,
8548,
9013,
8449,
8897,
8902,
8282,
8756,
8740,
8945,
8355,
8155,
8173,
8713,
8841,
8249,
8534,
8496,
7851,
8551,
7907,
8975,
8408,
9081,
8717,
7833,
8647,
9067,
7827,
8708,
7830,
8706,
8667,
8038,
8692,
8965,
8826,
8331,
8926,
8317,
8638,
8641,
7953,
7951,
9084,
8719,
7835,
9075,
9082,
9087,
9086,
9079,
9068,
8871,
8858,
8229,
8818,
8810,
8171,
8853,
8850,
8263,
8562,
7975,
8739,
8186,
8523,
7878,
8682,
8053,
8656,
8027,
8659,
8030,
8658,
8029,
8657,
8028,
7808,
8571,
7984,
8567,
7980,
8593,
8010,
8895,
8364,
8894,
8363,
8943,
8352,
8537,
7894,
8538,
7895,
8640,
7950,
8457,
8870,
8857,
8225,
8900,
8370,
8886,
8958,
8851,
8259,
8581,
7996,
8594,
8011,
8536,
7893,
8569,
7982,
8587,
8004,
8623,
7928,
8633,
7940,
8732,
8178,
8743,
8191,
8511,
7866,
8542,
7896,
8784,
8111,
8791,
8124,
8663,
8034,
8687,
8060,
8762,
8074,
8696,
7814,
8835,
8341,
8883,
8275,
8839,
8209,
8549,
7905,
8931,
8322,
8566,
7979,
8615,
7920,
8514,
7869,
8526,
7881,
8507,
7862,
8508,
7863,
8830,
8336,
8142,
8244,
7813,
8231,
8239,
8444,
8584,
8910,
8292,
8816,
8704,
8083,
8316,
8901,
8371,
8985,
8691,
8712,
8631,
7936,
9009,
8458,
8772,
8441,
8789,
8121,
8829,
8334,
7791,
8014,
7792,
8383,
7901,
8289,
8215,
8216,
8135,
8095,
8098,
7903,
8128,
8131,
8300,
8232,
8367,
8099,
9042,
8372,
8138,
7788,
8278,
8281,
8187,
8203,
9040,
8151,
8154,
8157,
8172,
7797,
7798,
8420,
8251,
8256,
9055,
8386,
9030,
8299,
8412,
7783,
7786,
7787,
8113,
8120,
8115,
8134,
9022,
9041,
8086,
7954,
8233,
8100,
7958,
7804,
7826,
8064,
8065,
8395,
7803,
7802,
7801,
9049,
8318,
8312,
7945,
7949,
9076,
9085,
9074,
9063,
9072,
9044,
8298,
9043,
9059,
8455,
7806,
9038,
8440,
9077,
9066,
8227,
8236,
8228,
7843,
7845,
7846,
8451,
8170,
8168,
9071,
9073,
7789,
7790,
6618,
6619,
6613,
6586,
6538,
6539,
6552,
6622,
6620,
6791,
6761,
6788,
6797,
6717,
6713,
6703,
6779,
6716,
6704,
6714,
6774,
6759,
6675,
3400,
6786,
6751,
6798,
6778,
6694,
6696,
6698,
6700,
6789,
6770,
6670,
6671,
6773,
6758,
6792,
6750,
15582,
24395,
25644,
25381,
19674,
24293,
6718,
6673,
6574,
6594,
6559,
6621,
6589,
6731,
6768,
6743,
6689,
6725,
6782,
6783,
6785,
6776,
6762,
6687,
6695,
6681,
6693,
6692,
6749,
6747,
6748,
6690,
6711,
6795,
6735,
6794,
6734,
6630,
6799,
6680,
3668,
3678,
3485,
3728,
3696,
3764,
3744,
3590,
3621,
3767,
3648,
3587,
3479,
3759,
3569,
3585,
3481,
3738,
3732,
3474,
3651,
3475,
3669,
3679,
3548,
3643,
3539,
3766,
3542,
3753,
3596,
3776,
3705,
3777,
3653,
3592,
3622,
3647,
3476,
3487,
3762,
3758,
3748,
3741,
3480,
3486,
3746,
3739,
3731,
3704,
3559,
3583,
3730,
3720,
3555,
3721,
3556,
3640,
3740,
3724,
3726,
3774,
3760,
3582,
3670,
3680,
3662,
3663,
3664,
3661,
3749,
3716,
3568,
3538,
3785,
3768,
3694,
3546,
3752,
3674,
3633,
3543,
3783,
3773,
3532,
3634,
3631,
3641,
3591,
3690,
3576,
3771,
3581,
3580,
3578,
3579,
3571,
3584,
3577,
3491,
3503,
3501,
3513,
3510,
3505,
3520,
3517,
3515,
3495,
3511,
3509,
3508,
21493,
21306,
21437,
21220,
21750,
21680,
21477,
21287,
-1,
-1,
21739,
21312,
21314,
21313,
21749,
-1,
-1,
-1,
-1,
-1,
21705,
21688,
21434,
21589,
21404,
21391,
21455,
-1,
21363,
-1,
21470,
21350,
21255,
21407,
21497,
21494,
21495,
21393,
21487,
21366,
21483,
21438,
21492,
21491,
21490,
21489,
21488,
21352,
21475,
21485,
-1,
21479,
21484,
21458,
21476,
21496,
21474,
21325,
21446,
21466,
21217,
21184,
21172,
21273,
21228,
21187,
21310,
21307,
21300,
21173,
21301,
21144,
21293,
21249,
21297,
21305,
21304,
21303,
21302,
21130,
21285,
21288,
21308,
21281,
21294,
21222,
21286,
21309,
21284,
21101,
21252,
21225,
21141,
21246,
21129,
21503,
21752,
21700,
21730,
21732,
21731,
21715,
21714,
21726,
21676,
21221,
21671,
21280,
21675,
21299,
21674,
21296,
21672,
21279,
3925,
3833,
3959,
3867,
3939,
3847,
3952,
3860,
3955,
3863,
3924,
3832,
3920,
3828,
21725,
21736,
21678,
21673,
21502,
21679,
21737,
21480,
21282,
21498,
21481,
21278,
21735,
21500,
21504,
21501,
4327,
4315,
4363,
4435,
4443,
4358,
4413,
4392,
4492,
4480,
4484,
4397,
4312,
4331,
4340,
4362,
4417,
4416,
4490,
4428,
4367,
4325,
4370,
4377,
4314,
4338,
4305,
4279,
4288,
4273,
4468,
4474,
4286,
4284,
4399,
4436,
4290,
4445,
4398,
4453,
4344,
4343,
4450,
4383,
4349,
4272,
4390,
4387,
4188,
4187,
4262,
4199,
4138,
4096,
4141,
4148,
4085,
4109,
4076,
4050,
4059,
4044,
4246,
4240,
4057,
4055,
4170,
4207,
4061,
4216,
4169,
4224,
4115,
4114,
4221,
4154,
4120,
4043,
4161,
4158,
4098,
4086,
4134,
4206,
4214,
4129,
4184,
4163,
4264,
4252,
4256,
4168,
4083,
4102,
4111,
4133,
4469,
4247,
4388,
4159,
4320,
4091,
4481,
4253,
4319,
4090,
4412,
4183,
4322,
4093,
4311,
4082,
4478,
4244,
4493,
4265,
4333,
4104,
4334,
4105,
4442,
4213,
4466,
4237,
4470,
4248,
4471,
4249,
4304,
4075,
4502,
3462,
3458,
3471,
3459,
3460,
3466,
3469,
4339,
4110,
4355,
4126,
4287,
4058,
4432,
4203,
4430,
4201,
4433,
4204,
4374,
4145,
4380,
4151,
4310,
4081,
4307,
4078,
4308,
4079,
4409,
4180,
4278,
4049,
4496,
4268,
4476,
4242,
4421,
4192,
4285,
4056,
4402,
4173,
4351,
4122,
4352,
4123,
4449,
4220,
4495,
4267,
4457,
4228,
4458,
4229,
4342,
4113,
4419,
4190,
4420,
4191,
4500,
4375,
4146,
4309,
4080,
4281,
4052,
4277,
4048,
4275,
4046,
4313,
4084,
4289,
4060,
4245,
4425,
4196,
4424,
4195,
4497,
4269,
4328,
4099,
4353,
4124,
4354,
4125,
4373,
4144,
4379,
4150,
4422,
4193,
4330,
4101,
4332,
4103,
4472,
4250,
4407,
4178,
4408,
4179,
4291,
4062,
4441,
4212,
4440,
4211,
4439,
4210,
4456,
4227,
4434,
4205,
4385,
4156,
4431,
4202,
4448,
4219,
4447,
4218,
4298,
4069,
4297,
4068,
4299,
4070,
4296,
4067,
4303,
4074,
4302,
4073,
4301,
4072,
4300,
4071,
4463,
4234,
4283,
4054,
4482,
4254,
4467,
4238,
4389,
4160,
4491,
4263,
4489,
4261,
4426,
4197,
4282,
4053,
4276,
4047,
4477,
4243,
]

_charnames_1329 = [
13682,
13681,
13670,
13680,
13642,
13645,
13641,
13640,
13652,
13644,
13677,
13676,
13672,
13638,
13664,
13678,
13668,
13671,
13635,
13675,
13646,
13674,
13655,
13649,
13636,
13662,
13667,
13659,
13656,
13650,
13653,
13658,
13637,
13647,
13661,
13665,
13673,
13679,
-1,
-1,
13691,
13688,
13686,
13685,
13683,
13690,
13689,
-1,
13622,
13621,
13610,
13620,
13582,
13585,
13581,
13580,
13592,
13584,
13617,
13616,
13612,
13578,
13604,
13618,
13608,
13611,
13575,
13615,
13586,
13614,
13595,
13589,
13576,
13602,
13607,
13599,
13596,
13590,
13593,
13598,
13577,
13587,
13601,
13605,
13613,
13619,
13630,
-1,
13693,
13692,
-1,
-1,
-1,
-1,
-1,
-1,
20734,
20721,
20720,
20696,
20697,
20706,
20731,
20698,
20727,
20717,
20705,
20713,
20714,
20715,
20723,
20704,
20726,
20735,
20710,
20711,
20708,
20709,
20730,
20724,
20703,
20718,
20732,
20733,
20729,
20699,
20772,
20749,
20740,
20742,
20741,
20745,
20756,
20751,
20758,
20753,
20743,
20744,
20755,
20761,
20759,
20769,
20757,
20767,
20748,
20750,
20766,
20771,
20773,
20768,
20754,
]

_charnames_1488 = [
20629,
20664,
20680,
20682,
20661,
20649,
20668,
20662,
20641,
20645,
20622,
20657,
20678,
20626,
20676,
20625,
20674,
20617,
20637,
20620,
20653,
20624,
20639,
20672,
20670,
20608,
20643,
-1,
-1,
-1,
-1,
-1,
20688,
20690,
20687,
20765,
20764,
]

_charnames_1536 = [
13547,
13464,
13497,
13466,
-1,
-1,
13569,
13568,
13529,
13567,
13566,
14021,
13549,
13507,
13531,
13474,
13465,
13475,
13471,
13472,
13473,
13444,
13435,
13445,
13459,
13460,
13458,
13487,
-1,
-1,
13514,
13546,
-1,
12914,
12988,
12984,
13313,
12980,
13152,
12975,
13217,
12793,
12790,
12843,
13377,
12892,
13061,
12923,
12850,
13185,
13361,
13111,
13138,
13128,
12938,
12854,
13354,
13008,
13295,
13032,
13030,
13260,
13258,
13259,
13511,
13266,
13397,
13039,
13339,
13407,
13069,
12863,
13310,
13002,
13149,
13494,
13502,
13517,
13489,
13501,
13516,
13482,
13477,
13541,
13544,
13543,
13481,
13548,
13540,
13545,
13523,
13524,
13525,
13528,
13491,
-1,
13561,
13562,
13553,
13554,
13559,
13560,
13556,
13557,
13564,
13563,
13533,
13508,
13515,
13498,
12973,
12971,
13147,
12998,
12994,
12993,
12916,
12920,
12919,
13390,
12918,
12828,
12829,
13241,
12801,
12800,
13325,
12806,
13234,
12907,
12897,
13103,
12959,
12901,
12813,
12814,
12951,
12934,
12932,
12933,
12946,
12955,
12966,
12928,
12935,
13212,
13190,
13199,
13197,
13191,
13198,
13196,
13384,
13202,
13122,
13115,
13116,
13131,
13132,
12859,
13016,
12972,
13275,
13276,
13366,
13272,
13326,
13401,
13400,
13024,
13146,
13045,
13046,
13089,
13044,
13283,
13289,
13090,
13287,
13303,
13288,
13345,
13346,
13344,
13343,
13079,
13080,
13205,
13078,
13074,
12873,
12825,
12881,
12865,
12870,
12796,
13321,
13057,
13424,
13388,
13180,
13053,
13320,
13365,
13249,
13161,
13162,
13322,
13417,
13160,
13163,
13166,
13496,
13022,
13433,
13434,
13440,
13436,
13451,
13443,
13448,
13538,
13486,
13449,
13447,
13452,
13439,
13454,
13441,
13457,
13456,
13446,
13450,
13532,
13536,
13537,
13527,
13455,
12930,
13200,
11923,
11924,
11915,
11916,
11921,
11922,
11918,
11919,
11926,
11925,
13143,
12943,
13300,
13469,
13468,
12885,
18885,
18855,
18859,
18853,
18857,
18850,
18889,
18888,
18854,
18858,
18890,
18847,
18848,
18849,
-1,
18901,
18839,
18804,
18838,
18824,
18825,
18828,
18827,
18822,
18830,
18829,
18823,
18814,
18815,
18817,
18818,
18835,
18834,
18833,
18832,
18806,
18836,
18837,
18808,
18821,
18807,
18831,
18820,
18805,
18816,
18812,
18810,
18811,
18880,
18879,
18878,
18876,
18875,
18874,
18870,
18869,
18895,
18896,
18844,
18843,
18845,
18884,
18883,
18871,
18899,
18897,
18872,
18863,
18862,
18866,
18865,
18893,
18892,
18898,
18900,
-1,
-1,
18801,
18802,
18803,
13224,
13228,
13222,
13223,
13225,
13227,
13226,
12898,
12900,
12927,
12931,
13193,
13120,
13013,
13015,
13012,
13273,
13271,
13033,
13031,
13029,
13411,
13410,
13073,
13077,
13076,
13347,
13195,
13201,
13117,
12906,
12904,
13118,
13192,
12905,
12996,
12997,
13254,
13255,
13256,
13318,
13319,
13171,
13172,
12908,
13121,
13119,
13043,
18242,
18214,
18232,
18249,
18256,
18235,
18239,
18244,
18248,
18252,
18254,
18230,
18206,
18236,
18225,
18223,
18215,
18228,
18219,
18210,
18246,
18251,
18253,
18255,
18208,
18241,
18238,
18207,
18220,
18213,
18216,
18229,
18209,
18221,
18245,
18224,
18250,
18247,
18266,
18267,
18270,
18263,
18268,
18258,
18264,
18262,
18259,
18260,
18269,
18233,
]

_charnames_1984 = [
26693,
26694,
26685,
26686,
26691,
26692,
26688,
26689,
26696,
26695,
26680,
26662,
26674,
26661,
26667,
26660,
26659,
26664,
26645,
26679,
26670,
26668,
26655,
26678,
26663,
26658,
26657,
26669,
26676,
26677,
26673,
26672,
26649,
26671,
26646,
26648,
26675,
26666,
26665,
26647,
26653,
26654,
26652,
26707,
26706,
26705,
26703,
26702,
26701,
26700,
26708,
26709,
26714,
26681,
26712,
26713,
26710,
26715,
26682,
-1,
-1,
-1,
-1,
-1,
19155,
19142,
19152,
19154,
19135,
19143,
19144,
19136,
19132,
19145,
19151,
19150,
19149,
19148,
19139,
19137,
19153,
19131,
19147,
19146,
19140,
19133,
19195,
19196,
19197,
19200,
19204,
19199,
19162,
19173,
19165,
19159,
19170,
19164,
19158,
19169,
19202,
19168,
19160,
19171,
19203,
19161,
19172,
19163,
19167,
19198,
-1,
-1,
19190,
19181,
19178,
19192,
19179,
19187,
19205,
19191,
19183,
19189,
19184,
19188,
19180,
19186,
19177,
]

_charnames_2304 = [
24556,
24540,
24552,
24548,
24420,
24467,
24470,
24504,
24505,
24499,
24500,
24435,
24437,
24458,
24419,
24513,
24469,
24457,
24418,
24510,
24468,
24484,
24483,
24453,
24450,
24445,
24455,
24460,
24488,
24487,
24444,
24464,
24463,
24430,
24429,
24443,
24466,
24465,
24432,
24431,
24446,
24442,
24503,
24502,
24492,
24490,
24511,
24498,
24474,
24472,
24479,
24478,
24477,
24439,
24421,
24422,
24423,
24508,
-1,
-1,
24555,
24551,
24527,
24533,
24534,
24528,
24529,
24516,
24517,
24523,
24532,
24537,
24526,
24521,
24531,
24536,
24525,
24549,
24535,
-1,
24585,
24560,
24561,
24580,
24583,
24522,
-1,
-1,
24509,
24482,
24449,
24495,
24427,
24473,
24512,
24497,
24436,
24438,
24518,
24519,
24578,
24577,
24573,
24574,
24565,
24566,
24571,
24572,
24568,
24569,
24576,
24575,
24584,
24557,
24459,
-1,
-1,
-1,
-1,
-1,
-1,
24494,
24507,
24452,
24486,
24451,
24428,
24491,
-1,
16643,
16641,
16637,
-1,
16566,
16569,
16589,
16590,
16581,
16582,
16545,
16547,
-1,
-1,
16604,
16568,
-1,
-1,
16600,
16567,
16577,
16575,
16593,
16592,
16558,
16596,
16595,
16588,
16587,
16556,
16552,
16551,
16563,
16562,
16557,
16554,
16553,
16565,
16564,
16559,
-1,
16585,
16584,
16599,
16598,
16601,
16580,
16538,
-1,
16602,
-1,
-1,
-1,
16572,
16571,
16573,
16603,
-1,
-1,
16642,
16640,
16614,
16617,
16618,
16615,
16616,
16607,
16608,
-1,
-1,
16620,
16613,
-1,
-1,
16619,
16612,
16638,
16576,
]

_charnames_2519 = [
16658,
-1,
-1,
-1,
-1,
16542,
16543,
-1,
16579,
16546,
16548,
16609,
16610,
-1,
-1,
16631,
16632,
16623,
16624,
16629,
16630,
16626,
16627,
16634,
16633,
16540,
16541,
16655,
16654,
16649,
16647,
16648,
16651,
16650,
16652,
16656,
16657,
-1,
-1,
-1,
-1,
-1,
22009,
22008,
22003,
-1,
21929,
21932,
21960,
21961,
21943,
21944,
-1,
-1,
-1,
-1,
21975,
21931,
-1,
-1,
21971,
21930,
21937,
21936,
21942,
21941,
21921,
21964,
21963,
21959,
21958,
21919,
21915,
21914,
21926,
21925,
21920,
21917,
21916,
21928,
21927,
21922,
-1,
21953,
21952,
21967,
21966,
21972,
21969,
21950,
-1,
21956,
21955,
-1,
21970,
21946,
-1,
21947,
21973,
-1,
-1,
22007,
-1,
21994,
21997,
21998,
21995,
21996,
-1,
-1,
-1,
-1,
22000,
21993,
-1,
-1,
21999,
21992,
22004,
-1,
-1,
-1,
22006,
]

_charnames_2662 = [
21986,
21987,
21978,
21979,
21984,
21985,
21981,
21982,
21989,
21988,
22011,
22014,
22012,
22010,
22013,
22005,
]

_charnames_2689 = [
21907,
21905,
21901,
-1,
21823,
21826,
21845,
21846,
21831,
21832,
21801,
21803,
21884,
-1,
21861,
21825,
21883,
-1,
21858,
21824,
21841,
21840,
21849,
21848,
21815,
21852,
21851,
21844,
21843,
21813,
21809,
21808,
21820,
21819,
21814,
21811,
21810,
21822,
21821,
21816,
-1,
21835,
21834,
21855,
21854,
21859,
21856,
21857,
-1,
21838,
21837,
-1,
21805,
21829,
21828,
21830,
21860,
-1,
-1,
21906,
21904,
21872,
21875,
21876,
21873,
21874,
21865,
21866,
21879,
-1,
21881,
21871,
21878,
-1,
21880,
21870,
21902,
-1,
-1,
21909,
]

_charnames_2784 = [
21802,
21804,
21867,
21868,
-1,
-1,
21895,
21896,
21887,
21888,
21893,
21894,
21890,
21891,
21898,
21897,
-1,
21908,
]

_charnames_2817 = [
25282,
25280,
25276,
-1,
25199,
25202,
25228,
25229,
25214,
25215,
25177,
25179,
-1,
-1,
25243,
25201,
-1,
-1,
25240,
25200,
25224,
25223,
25232,
25231,
25191,
25235,
25234,
25227,
25226,
25189,
25185,
25184,
25196,
25195,
25190,
25187,
25186,
25198,
25197,
25192,
-1,
25218,
25217,
25238,
25237,
25241,
25213,
25210,
-1,
25221,
25220,
-1,
25181,
25205,
25204,
25206,
25242,
-1,
-1,
25281,
25279,
25253,
25256,
25257,
25254,
25255,
25246,
25247,
-1,
-1,
25259,
25252,
-1,
-1,
25258,
25251,
25277,
]

_charnames_2902 = [
25285,
25284,
-1,
-1,
-1,
-1,
25208,
25209,
-1,
25212,
25178,
25180,
25248,
25249,
-1,
-1,
25270,
25271,
25262,
25263,
25268,
25269,
25265,
25266,
25273,
25272,
25286,
25239,
]

_charnames_2946 = [
17431,
17429,
-1,
17356,
17359,
17379,
17380,
17369,
17370,
-1,
-1,
-1,
17381,
17382,
17358,
-1,
17377,
17378,
17357,
17387,
-1,
-1,
-1,
17354,
17390,
-1,
17388,
-1,
17353,
17372,
-1,
-1,
-1,
17352,
17373,
-1,
-1,
-1,
17355,
17351,
17385,
-1,
-1,
-1,
17386,
17383,
17376,
17375,
17368,
17367,
17366,
17384,
17362,
17361,
17363,
17389,
-1,
-1,
-1,
-1,
17412,
17417,
17418,
17413,
17414,
-1,
-1,
-1,
17419,
17420,
17411,
-1,
17415,
17416,
17410,
17430,
-1,
-1,
17437,
-1,
-1,
-1,
-1,
-1,
-1,
17433,
]

_charnames_3046 = [
17402,
17403,
17394,
17395,
17400,
17401,
17397,
17398,
17405,
17404,
17425,
17424,
17423,
17407,
17438,
17435,
17406,
17439,
17434,
17436,
17426,
-1,
-1,
-1,
-1,
-1,
-1,
17943,
17941,
17937,
-1,
17847,
17850,
17874,
17875,
17855,
17856,
17823,
17825,
-1,
17879,
17880,
17849,
-1,
17863,
17864,
17848,
17870,
17869,
17878,
17877,
17845,
17883,
17882,
17873,
17872,
17843,
17831,
17830,
17838,
17837,
17844,
17834,
17833,
17841,
17840,
17846,
-1,
17862,
17861,
17886,
17885,
17888,
17887,
17859,
17858,
17867,
17866,
-1,
17827,
17853,
17852,
17854,
17889,
-1,
-1,
-1,
17940,
17900,
17905,
17906,
17901,
17902,
17893,
17894,
-1,
17907,
17908,
17899,
-1,
17903,
17904,
17898,
17938,
]

_charnames_3157 = [
17890,
17944,
-1,
17832,
17839,
-1,
-1,
-1,
-1,
-1,
-1,
17824,
17826,
17895,
17896,
-1,
-1,
17919,
17920,
17911,
17912,
17917,
17918,
17914,
17915,
17922,
17921,
]

_charnames_3192 = [
17934,
17932,
17926,
17929,
17933,
17927,
17930,
17942,
-1,
-1,
22773,
22769,
-1,
22690,
22693,
22717,
22718,
22698,
22699,
22668,
22670,
-1,
22722,
22723,
22692,
-1,
22706,
22707,
22691,
22713,
22712,
22721,
22720,
22682,
22726,
22725,
22716,
22715,
22680,
22676,
22675,
22687,
22686,
22681,
22678,
22677,
22689,
22688,
22683,
-1,
22705,
22704,
22729,
22728,
22731,
22730,
22702,
22701,
22710,
22709,
-1,
22672,
22696,
22695,
22697,
22732,
-1,
-1,
22775,
22772,
22744,
22749,
22750,
22745,
22746,
22737,
22738,
-1,
22751,
22752,
22743,
-1,
22747,
22748,
22742,
22770,
]

_charnames_3294 = [
22733,
-1,
22669,
22671,
22739,
22740,
-1,
-1,
22763,
22764,
22755,
22756,
22761,
22762,
22758,
22759,
22766,
22765,
-1,
22776,
22774,
]

_charnames_3330 = [
6432,
6428,
-1,
6350,
6353,
6379,
6380,
6363,
6364,
6328,
6330,
-1,
6384,
6385,
6352,
-1,
6371,
6372,
6351,
6375,
6374,
6383,
6382,
6342,
6325,
6324,
6378,
6377,
6340,
6336,
6335,
6347,
6346,
6341,
6338,
6337,
6349,
6348,
6343,
-1,
6370,
6369,
6388,
6387,
6390,
6389,
6367,
6366,
6362,
6361,
6360,
6332,
6356,
6355,
6357,
6391,
-1,
-1,
-1,
6431,
6401,
6406,
6407,
6402,
6403,
6394,
6395,
-1,
6408,
6409,
6400,
-1,
6404,
6405,
6399,
6429,
]

_charnames_3424 = [
6329,
6331,
6396,
6397,
-1,
-1,
6421,
6422,
6413,
6414,
6419,
6420,
6416,
6417,
6424,
6423,
6437,
6436,
6435,
6440,
6441,
6442,
-1,
-1,
-1,
6425,
6319,
6318,
6322,
6320,
6321,
6323,
-1,
-1,
19507,
19509,
-1,
19416,
19420,
19414,
19415,
19448,
19449,
19466,
19467,
19443,
19444,
19446,
19447,
19472,
19473,
19419,
19469,
19470,
19417,
-1,
-1,
-1,
19408,
19431,
19410,
19433,
19477,
19455,
19411,
19434,
19409,
19432,
19460,
19459,
19454,
19402,
19425,
19405,
19428,
19439,
19452,
19403,
19426,
19406,
19429,
19463,
-1,
19453,
19407,
19430,
19412,
19435,
19436,
19418,
19474,
19476,
-1,
19464,
-1,
-1,
19475,
19458,
19438,
19462,
19478,
19440,
19479,
-1,
-1,
-1,
19508,
-1,
-1,
-1,
-1,
19504,
19492,
19500,
19491,
19499,
19490,
-1,
19497,
-1,
19503,
19483,
19498,
19488,
19487,
19486,
19485,
19502,
]

_charnames_3585 = [
18138,
18135,
18133,
18132,
18134,
18136,
18154,
18162,
18165,
18163,
18098,
18164,
18168,
18183,
18115,
18106,
18111,
18110,
18152,
18182,
18114,
18108,
18107,
18109,
18151,
18186,
18147,
18143,
18172,
18144,
18173,
18145,
18127,
18169,
18177,
18176,
18157,
18159,
18184,
18099,
18100,
18097,
18180,
18158,
18185,
18179,
18148,
18080,
18122,
18086,
18084,
18091,
18092,
18088,
18089,
18087,
18090,
18146,
-1,
-1,
-1,
-1,
18188,
18094,
18085,
18093,
18082,
18083,
18160,
18125,
18126,
18123,
18121,
18120,
18124,
18112,
18153,
18170,
18174,
18199,
18200,
18191,
18192,
18197,
18198,
18194,
18195,
18202,
18201,
18187,
18137,
]

_charnames_3713 = [
9116,
9115,
-1,
9114,
-1,
-1,
9111,
9134,
-1,
9118,
-1,
-1,
9109,
-1,
-1,
-1,
-1,
-1,
-1,
9133,
9102,
9101,
9100,
-1,
9110,
9135,
9107,
9106,
9127,
9105,
9128,
-1,
9132,
9129,
9122,
-1,
9121,
-1,
9130,
-1,
-1,
9119,
9125,
-1,
9131,
9124,
9182,
9137,
9148,
9141,
9139,
9149,
9150,
9142,
9143,
9144,
9145,
-1,
9147,
9176,
9175,
-1,
-1,
9151,
9152,
9153,
9138,
9140,
-1,
9181,
-1,
9172,
9171,
9170,
9173,
9183,
9180,
-1,
-1,
9164,
9165,
9156,
9157,
9162,
9163,
9159,
9160,
9167,
9166,
-1,
-1,
9178,
9179,
]

_charnames_3840 = [
17549,
17621,
17619,
17620,
17653,
17633,
17631,
17668,
17661,
17647,
17650,
17655,
17672,
17660,
17640,
17657,
17639,
17663,
17664,
17629,
17622,
17613,
17612,
17725,
17727,
17726,
17518,
17517,
17516,
17512,
17511,
17519,
17697,
17698,
17689,
17690,
17695,
17696,
17692,
17693,
17700,
17699,
17685,
17676,
17677,
17682,
17683,
17679,
17680,
17687,
17686,
17684,
17649,
17643,
17630,
17642,
17635,
17658,
17624,
17625,
17666,
17667,
17523,
17527,
17579,
17578,
17595,
17594,
17573,
17598,
17597,
17606,
-1,
17571,
17555,
17554,
17567,
17566,
17572,
17560,
17559,
17569,
17568,
17574,
17592,
17591,
17601,
17600,
17604,
17558,
17557,
17564,
17563,
17603,
17585,
17586,
17610,
17602,
17589,
17605,
17582,
17581,
17583,
17607,
17609,
17576,
17608,
17577,
17588,
-1,
-1,
-1,
-1,
17717,
17713,
17714,
17707,
17708,
17703,
17704,
17705,
17706,
17715,
17716,
17711,
17712,
17521,
17520,
17709,
17710,
17535,
17534,
17671,
17669,
17529,
17524,
17530,
17526,
17533,
17532,
-1,
-1,
-1,
-1,
17476,
17475,
17489,
17488,
17467,
17492,
17491,
17501,
-1,
17465,
17449,
17448,
17461,
17460,
17466,
17454,
17453,
17463,
17462,
17468,
17486,
17485,
17495,
17494,
17499,
17452,
17451,
17458,
17457,
17497,
17482,
17483,
17504,
17496,
17498,
17500,
17471,
17470,
17472,
17502,
17503,
17474,
17479,
17478,
17480,
-1,
17728,
17729,
17721,
17720,
17722,
17719,
17548,
17543,
17547,
17544,
17546,
17538,
17540,
17541,
17542,
-1,
17513,
17510,
17648,
17670,
17638,
17654,
17634,
25636,
9868,
25637,
9869,
]

_charnames_4096 = [
7397,
7369,
7466,
7465,
7434,
7488,
7487,
7483,
7482,
7433,
7431,
7444,
7443,
7455,
7454,
7432,
7446,
7445,
7457,
7456,
7435,
7477,
7476,
7491,
7490,
7428,
7492,
7474,
7480,
7462,
7419,
7494,
7479,
7467,
7416,
7484,
7485,
7470,
7471,
7447,
7427,
7493,
7468,
7594,
7577,
7590,
7591,
7585,
7586,
7592,
7574,
7589,
7588,
7593,
7528,
7532,
7521,
7522,
7527,
7613,
7615,
7614,
7616,
7464,
7606,
7607,
7598,
7599,
7604,
7605,
7601,
7602,
7609,
7608,
7531,
7513,
7557,
7559,
7553,
7558,
7399,
7417,
7437,
7438,
7439,
7440,
7569,
7570,
7571,
7572,
7425,
7426,
7424,
7423,
7618,
7619,
7620,
7418,
7567,
7624,
7623,
7460,
7461,
7584,
7583,
7519,
7518,
7517,
7516,
7515,
7450,
7449,
7451,
7595,
7580,
7579,
7581,
7406,
7405,
7411,
7414,
7407,
7402,
7413,
7403,
7409,
7412,
7415,
7408,
7410,
7621,
7566,
7563,
7564,
7565,
7507,
7506,
7505,
7504,
7511,
7510,
7512,
7473,
7529,
7543,
7544,
7535,
7536,
7541,
7542,
7538,
7539,
7546,
7545,
7525,
7524,
7575,
7576,
7555,
7556,
22176,
22175,
22161,
22174,
22173,
22164,
22143,
22146,
22172,
22155,
22171,
22170,
22169,
22168,
22152,
22142,
22166,
22149,
22145,
22165,
22151,
22154,
22160,
22167,
22148,
22137,
22140,
22157,
22139,
22138,
22162,
22158,
22131,
22134,
22133,
22163,
22130,
22132,
]

_charnames_4304 = [
22060,
22076,
22055,
22075,
22057,
22065,
22040,
22036,
22073,
22049,
22072,
22071,
22070,
22069,
22046,
22039,
22067,
22043,
22035,
22066,
22045,
22048,
22054,
22068,
22042,
22029,
22032,
22051,
22031,
22030,
22063,
22052,
22023,
22026,
22025,
22064,
22022,
22024,
22074,
22062,
22058,
22037,
22061,
22177,
6780,
-1,
-1,
-1,
20252,
20140,
20255,
20235,
20130,
20199,
20263,
20144,
20138,
20107,
20132,
20217,
20197,
20134,
20184,
20254,
20243,
20168,
20272,
20260,
20139,
20257,
20259,
20241,
20213,
20137,
20215,
20250,
20267,
20251,
20160,
20166,
20157,
20147,
20153,
20150,
20152,
20155,
20154,
20163,
20164,
20158,
20165,
20247,
20249,
20117,
20124,
20114,
20123,
20125,
20110,
20111,
20122,
20126,
20120,
20121,
20118,
20115,
20112,
20127,
20180,
20178,
20193,
20191,
20172,
20232,
20224,
20231,
20220,
20229,
20222,
20141,
20227,
20228,
20225,
20221,
20270,
20198,
20182,
20179,
20195,
20192,
20186,
20187,
20183,
20196,
20170,
20248,
20142,
20271,
20253,
20258,
20262,
20261,
20238,
20274,
20104,
20075,
20087,
20023,
20028,
20057,
20048,
20018,
20017,
20062,
20100,
20101,
20074,
20006,
20088,
20099,
20098,
20102,
19995,
20049,
20029,
20031,
20085,
20084,
20027,
20025,
20060,
20059,
20061,
20022,
20021,
20072,
20071,
20065,
20069,
20073,
20009,
20010,
20011,
20014,
20015,
20092,
20093,
20096,
20090,
20094,
20001,
20000,
19999,
19998,
19997,
20003,
20005,
20054,
20052,
20030,
20043,
20034,
20041,
20045,
20047,
20044,
20076,
20079,
20080,
20081,
20103,
20086,
20026,
20020,
20067,
20068,
19906,
19862,
19908,
19954,
19960,
19966,
19942,
19811,
19823,
19829,
19814,
19846,
19841,
19820,
19848,
19923,
19883,
19885,
19865,
19851,
19981,
19988,
19992,
19922,
19953,
19896,
19975,
19910,
19909,
19965,
19957,
19962,
19964,
19958,
19952,
19950,
19825,
19847,
19839,
19840,
19857,
19832,
19831,
19817,
19819,
19828,
19844,
19821,
19827,
19835,
19939,
19937,
19931,
19929,
19927,
19933,
19936,
19940,
19921,
19887,
19893,
19895,
19918,
19874,
19868,
19879,
19871,
19901,
19984,
19986,
19863,
19985,
19968,
19970,
19971,
19900,
19919,
19979,
19977,
19980,
19978,
19974,
19912,
19911,
19915,
19913,
19914,
19860,
11719,
11721,
11722,
11720,
11718,
11717,
11715,
11716,
11782,
11785,
11786,
11783,
11781,
11780,
11778,
11784,
11709,
11712,
11714,
11710,
11708,
11707,
11713,
11711,
11733,
11736,
11737,
11734,
11732,
11731,
11729,
11728,
11407,
11410,
11412,
11408,
11406,
11405,
11411,
11409,
11771,
11775,
11776,
11772,
11770,
11769,
11767,
11774,
11430,
11433,
11434,
11431,
11427,
11421,
11428,
11432,
11399,
11402,
11403,
11400,
11398,
11397,
11395,
11401,
11506,
11508,
11509,
11507,
11505,
11504,
11502,
11503,
11499,
-1,
11501,
11500,
11498,
11497,
-1,
-1,
11483,
11485,
11487,
11484,
11482,
11481,
11486,
-1,
11478,
-1,
11480,
11479,
11477,
11476,
-1,
-1,
11762,
11764,
11765,
11763,
11761,
11760,
11758,
11757,
11818,
11821,
11823,
11819,
11817,
11816,
11822,
11820,
11468,
11471,
11472,
11469,
11467,
11466,
11464,
11470,
11578,
11581,
11582,
11579,
11577,
11576,
11574,
11580,
11661,
11663,
11664,
11662,
11660,
11659,
11657,
11658,
11654,
-1,
11656,
11655,
11653,
11652,
-1,
-1,
11680,
11683,
11684,
11681,
11679,
11678,
11676,
11682,
11671,
11674,
11675,
11672,
11670,
11669,
11667,
11673,
11366,
11369,
11370,
11367,
11365,
11364,
11362,
11368,
11543,
11545,
11546,
11544,
11542,
11541,
11539,
11540,
11536,
-1,
11538,
11537,
11535,
11534,
-1,
-1,
11520,
11522,
11524,
11521,
11519,
11518,
11523,
-1,
11515,
-1,
11517,
11516,
11514,
11513,
-1,
-1,
11811,
11813,
11814,
11812,
11810,
11809,
11807,
11808,
11589,
11591,
11593,
11590,
11588,
11587,
11592,
-1,
11637,
11640,
11641,
11638,
11636,
11635,
11633,
11639,
11619,
11622,
11624,
11620,
11618,
11617,
11623,
11621,
11802,
11804,
11805,
11803,
11801,
11800,
11798,
11799,
11700,
11703,
11704,
11701,
11699,
11698,
11696,
11702,
11691,
11694,
11695,
11692,
11690,
11689,
11687,
11693,
11792,
11795,
11796,
11793,
11791,
11790,
11788,
11794,
11389,
11391,
11392,
11390,
11388,
11387,
11385,
11386,
11382,
-1,
11384,
11383,
11381,
11380,
-1,
-1,
11356,
11358,
11360,
11357,
11355,
11354,
11359,
11352,
11441,
11444,
11445,
11442,
11440,
11439,
11437,
11443,
11569,
11572,
11573,
11570,
11568,
11567,
11565,
11571,
11585,
11600,
11601,
11594,
11598,
11597,
11595,
11599,
11458,
11461,
11463,
11459,
11457,
11456,
11462,
11460,
11451,
11453,
11454,
11452,
11450,
11449,
11447,
11448,
11746,
11749,
11751,
11747,
11745,
11744,
11750,
11743,
11611,
11613,
11614,
11612,
11610,
11609,
11607,
11606,
11773,
11735,
11748,
-1,
-1,
-1,
-1,
11871,
11826,
11876,
11878,
11870,
11825,
11872,
11874,
11877,
11875,
11865,
11857,
11858,
11863,
11864,
11860,
11861,
11867,
11866,
11829,
11831,
11832,
11837,
11838,
11834,
11835,
11841,
11839,
11840,
11830,
-1,
-1,
-1,
11424,
11727,
11726,
11725,
11426,
11756,
11755,
11754,
11425,
11742,
11741,
11740,
11423,
11605,
11604,
11603,
11850,
11844,
11852,
11851,
11846,
11849,
11854,
11853,
11845,
11848,
-1,
-1,
-1,
-1,
-1,
-1,
5059,
5058,
5057,
5055,
5054,
5053,
5046,
5056,
5045,
5044,
5043,
5042,
5041,
5003,
5002,
5001,
4999,
4998,
4997,
5039,
5038,
5037,
5036,
5035,
5034,
5052,
5051,
5050,
5049,
5048,
4989,
5000,
4990,
4995,
4994,
4993,
4992,
4991,
5032,
5031,
5030,
5029,
5028,
5027,
4987,
4981,
4986,
4985,
4984,
4983,
4982,
5011,
4980,
5010,
4979,
5009,
4978,
5007,
5006,
5005,
5008,
4977,
4976,
4975,
4974,
4973,
4972,
4970,
4969,
4968,
4967,
4966,
4965,
5025,
5024,
5023,
5022,
5021,
5020,
5018,
5017,
5016,
5015,
5014,
5013,
]

_charnames_5120 = [
3338,
3334,
3314,
3331,
3333,
3293,
3309,
3104,
2753,
2751,
3311,
3312,
2771,
2849,
2898,
2845,
2899,
2846,
2878,
2843,
2879,
2844,
2912,
2895,
2847,
2897,
2848,
2913,
3318,
3101,
3340,
3149,
3147,
3148,
3144,
3134,
3133,
3139,
3138,
3146,
3143,
3145,
3140,
3335,
3332,
3310,
3321,
3273,
3266,
3271,
3272,
3268,
3270,
3099,
2693,
2692,
3264,
3265,
3263,
2832,
3259,
2828,
3260,
2829,
3256,
2826,
3258,
2827,
3261,
2830,
3262,
2831,
3098,
3254,
2824,
2684,
3030,
3024,
3028,
3029,
3026,
3027,
3102,
2606,
2607,
3022,
3023,
3009,
2822,
3005,
2818,
3006,
2819,
3003,
2816,
3004,
2817,
3007,
2820,
3008,
2821,
2915,
2968,
3000,
2999,
2998,
3001,
3292,
3286,
3290,
3291,
3288,
3289,
3108,
3284,
3285,
3283,
2857,
3281,
2853,
3282,
2854,
3279,
2851,
3280,
2852,
3276,
2855,
3278,
2856,
2918,
3274,
3275,
3088,
3087,
3086,
3089,
2769,
2755,
2766,
2767,
2764,
2765,
3109,
2542,
2754,
2763,
2865,
2759,
2861,
2760,
2862,
2757,
2859,
2758,
2860,
2761,
2863,
2762,
2864,
2919,
2541,
3053,
3200,
3195,
3204,
3205,
3197,
3198,
3106,
3193,
3194,
3192,
2841,
3188,
2837,
3189,
2838,
3186,
2835,
3187,
2836,
3190,
2839,
3191,
2840,
2917,
3184,
2833,
3206,
3317,
3054,
2967,
2921,
2964,
2965,
2957,
2959,
3105,
2901,
2920,
2949,
2875,
2947,
2873,
2948,
2874,
2916,
2900,
2714,
2966,
3183,
3177,
3181,
3182,
3179,
3180,
3107,
3175,
3176,
3167,
2799,
3163,
2795,
3164,
2796,
3161,
2793,
3162,
2794,
3165,
2797,
3166,
2798,
3159,
2791,
3203,
3094,
3056,
3092,
3093,
3084,
3091,
3103,
3032,
3055,
3083,
2782,
3079,
2778,
3080,
2779,
3077,
2776,
3078,
2777,
3081,
2780,
3082,
2781,
2906,
3031,
3316,
3076,
3224,
3199,
2904,
2910,
2908,
2907,
2905,
2909,
3075,
3073,
3074,
3067,
3069,
3070,
3072,
3066,
2790,
3062,
2786,
3063,
2787,
3059,
2784,
3061,
2785,
3064,
2788,
3065,
2789,
3057,
3127,
3120,
3125,
3126,
3122,
3124,
3100,
3118,
3119,
3117,
2813,
3113,
2809,
3114,
2810,
3111,
2807,
3112,
2808,
3115,
2811,
3116,
2812,
2914,
3095,
3232,
2805,
3052,
3253,
3252,
2804,
3244,
3248,
3249,
3246,
3247,
2800,
3242,
3243,
2802,
3240,
2867,
3233,
2866,
3202,
3158,
3153,
3129,
3150,
3154,
3155,
3151,
3152,
3156,
2876,
3128,
2988,
2963,
2984,
2961,
2985,
2962,
2982,
2983,
2986,
2987,
2980,
2823,
2969,
2997,
2996,
2991,
2993,
2990,
3020,
3019,
3018,
3021,
2931,
2927,
2928,
2925,
2926,
2929,
2930,
2924,
2932,
3339,
3325,
3329,
3330,
3327,
3328,
3323,
3324,
3322,
3015,
3014,
3011,
3016,
2870,
2869,
2868,
2871,
2936,
2940,
2941,
2938,
2939,
2934,
2935,
2933,
2950,
3040,
3039,
3036,
3041,
2892,
2891,
2890,
2893,
2881,
3171,
3172,
3169,
3170,
3173,
3174,
3168,
2977,
2973,
2974,
2971,
2972,
2975,
2976,
2970,
3319,
3227,
3226,
3225,
3228,
3212,
3211,
3210,
3213,
3217,
3216,
3215,
3218,
3222,
3221,
3220,
3223,
3046,
3045,
3043,
3047,
2612,
2613,
2610,
2611,
2614,
2615,
2733,
2734,
2731,
2732,
2735,
2736,
2726,
2727,
2724,
2725,
2728,
2729,
2688,
2689,
2686,
2687,
2690,
2691,
2583,
2584,
2581,
2582,
2585,
2586,
2555,
2556,
2553,
2554,
2557,
2558,
2704,
2705,
2702,
2703,
2706,
2707,
2701,
2623,
2624,
2619,
2620,
2625,
2621,
2651,
2652,
2649,
2650,
2653,
2654,
2644,
2645,
2642,
2643,
2646,
2647,
2641,
2711,
2712,
2709,
2710,
2713,
2715,
2740,
2741,
2738,
2739,
2742,
2743,
2719,
2720,
2717,
2718,
2721,
2722,
2666,
3049,
2667,
2663,
2664,
2668,
3051,
2669,
2659,
2660,
2657,
2658,
2661,
2662,
2680,
2681,
2678,
2679,
2682,
2683,
2598,
2599,
2596,
2597,
2600,
2601,
2674,
2675,
2672,
2673,
2676,
2677,
2563,
2564,
2561,
2562,
2565,
2566,
2569,
2570,
2567,
2568,
2571,
2572,
2697,
2698,
2695,
2696,
2699,
2700,
2694,
2752,
2591,
2592,
2589,
2590,
2593,
2594,
2636,
2637,
2634,
2635,
2638,
2639,
2630,
2631,
2628,
2629,
2632,
2633,
2627,
2576,
2577,
2574,
2575,
2578,
2579,
2747,
2748,
2745,
2746,
2749,
2750,
2549,
2550,
2547,
2548,
2551,
2552,
2768,
3157,
3326,
2937,
2953,
2954,
2951,
2952,
2955,
2956,
2889,
2885,
2886,
2883,
2884,
2887,
2888,
2894,
3209,
25378,
25376,
25372,
25374,
25355,
25360,
25348,
25375,
25368,
25366,
25367,
25371,
25373,
25361,
25354,
25369,
25377,
25358,
25346,
25351,
25363,
25352,
25357,
25347,
25364,
25350,
25370,
25380,
25379,
-1,
-1,
-1,
25737,
25729,
25730,
25715,
25714,
25716,
25720,
25688,
25710,
25668,
25713,
25712,
25675,
25657,
25666,
25671,
25670,
25731,
25722,
25700,
25723,
25704,
25689,
25707,
25708,
25717,
25725,
25726,
25677,
25660,
25734,
25658,
25695,
25684,
25687,
25736,
25706,
25678,
25662,
25683,
25733,
25711,
25664,
25665,
25656,
25698,
25727,
25719,
25655,
25692,
25738,
25661,
25694,
25669,
25690,
25735,
25676,
25659,
25679,
25696,
25682,
25681,
25697,
25667,
25691,
25685,
25702,
25703,
25701,
25663,
25674,
25654,
25686,
25732,
25728,
25740,
25741,
25742,
25744,
25739,
25743,
]

_charnames_5888 = [
17320,
17315,
17308,
17314,
17317,
17304,
17309,
17318,
17305,
17311,
17319,
17312,
17306,
-1,
17313,
17307,
17310,
17316,
17323,
17322,
17324,
]

_charnames_5920 = [
20433,
20428,
20420,
20427,
20430,
20416,
20421,
20431,
20417,
20424,
20432,
20425,
20418,
20423,
20426,
20419,
20422,
20429,
20436,
20435,
20437,
26342,
26343,
]

_charnames_5952 = [
16862,
16857,
16849,
16856,
16859,
16845,
16850,
16860,
16846,
16853,
16861,
16854,
16847,
16852,
16855,
16848,
16851,
16858,
16865,
16864,
]

_charnames_5984 = [
17343,
17339,
17332,
17338,
17340,
17328,
17333,
17341,
17329,
17335,
17342,
17336,
17330,
-1,
17337,
17331,
17334,
-1,
17346,
17345,
]

_charnames_6016 = [
23195,
23193,
23194,
23192,
23189,
23201,
23199,
23200,
23198,
23186,
23216,
23179,
23215,
23178,
23188,
23184,
23182,
23183,
23181,
23187,
23223,
23209,
23210,
23208,
23221,
23217,
23219,
23212,
23218,
23204,
23203,
23205,
23222,
23213,
23220,
23255,
23257,
23261,
23262,
23249,
23252,
23250,
23251,
23264,
23265,
23266,
23267,
23263,
23256,
23260,
23259,
23254,
23245,
23246,
23230,
23237,
23238,
23231,
23232,
23234,
23235,
23236,
23242,
23233,
23239,
23243,
23229,
23228,
23241,
23227,
23172,
23164,
23168,
23173,
23160,
23149,
23163,
23161,
23154,
23158,
23170,
23169,
23166,
23147,
23153,
23148,
23167,
23174,
23150,
23171,
23152,
23282,
23156,
23157,
-1,
-1,
23278,
23279,
23270,
23271,
23276,
23277,
23273,
23274,
23281,
23280,
-1,
-1,
-1,
-1,
-1,
-1,
23131,
23132,
23127,
23130,
23129,
23120,
23126,
23125,
23124,
23123,
-1,
-1,
-1,
-1,
-1,
-1,
6998,
6997,
6991,
6985,
6992,
6986,
6994,
6995,
6989,
6988,
6996,
6984,
6982,
6983,
6993,
-1,
6975,
6976,
6967,
6968,
6973,
6974,
6970,
6971,
6978,
6977,
-1,
-1,
-1,
-1,
-1,
-1,
6842,
6947,
6959,
6939,
6937,
6940,
6938,
6948,
6957,
6878,
6964,
6956,
6955,
6961,
6907,
6943,
6906,
6905,
6841,
6963,
6951,
6958,
6952,
6954,
6953,
6962,
6946,
6945,
6840,
6936,
6960,
6934,
6942,
6935,
6950,
6833,
6837,
6835,
6817,
6812,
6818,
6813,
6811,
6839,
6830,
6829,
6822,
6832,
6816,
6826,
6838,
6821,
6815,
6827,
6828,
6834,
6823,
6836,
6820,
6831,
6825,
6901,
6889,
6890,
6885,
6884,
6904,
6898,
6893,
6891,
6897,
6895,
6888,
6902,
6899,
6900,
6894,
6892,
6887,
6883,
6896,
6903,
6882,
6931,
6930,
6929,
6932,
6928,
]

_charnames_6272 = [
6856,
6872,
6852,
6873,
6868,
6877,
6848,
6855,
6867,
6875,
6866,
6876,
6847,
6846,
6854,
6865,
6849,
6851,
6863,
6862,
6874,
6859,
6860,
6857,
6810,
6809,
6926,
6923,
6921,
6925,
6914,
6918,
6915,
6917,
6922,
6920,
6911,
6912,
6871,
6870,
6927,
6853,
6924,
-1,
-1,
-1,
-1,
-1,
3308,
3320,
3313,
2896,
3269,
3267,
3257,
3025,
3287,
3277,
3196,
2958,
2922,
3178,
3090,
3033,
3068,
3071,
3060,
3123,
3121,
3245,
2945,
3299,
2946,
3300,
2943,
3297,
2944,
3298,
3241,
3237,
3238,
3235,
3236,
3239,
3304,
3303,
3306,
3307,
3305,
3295,
3301,
3302,
3336,
2877,
3142,
3135,
3251,
2801,
2803,
2981,
2979,
2995,
2992,
2994,
3013,
3012,
3038,
3037,
3044,
2617,
2605,
2622,
2618,
3050,
2665,
3231,
3230,
2604,
]

_charnames_6400 = [
9544,
9491,
9490,
9497,
9496,
9487,
9503,
9502,
9494,
9493,
9479,
9482,
9481,
9500,
9499,
9488,
9485,
9484,
9506,
9505,
9509,
9478,
9508,
9510,
9507,
9476,
9475,
9477,
9511,
-1,
-1,
-1,
9535,
9543,
9542,
9541,
9537,
9539,
9536,
9540,
9538,
9530,
9532,
9531,
-1,
-1,
-1,
-1,
9522,
9515,
9523,
9517,
9516,
9519,
9520,
9518,
9521,
9526,
9528,
9525,
-1,
-1,
-1,
-1,
9527,
-1,
-1,
-1,
9560,
9559,
9555,
9556,
9547,
9548,
9553,
9554,
9550,
9551,
9558,
9557,
17171,
17173,
17167,
17150,
17175,
17172,
17152,
17151,
17178,
17163,
17162,
17177,
17181,
17174,
17180,
17176,
17170,
17149,
17168,
17156,
17179,
17155,
17154,
17159,
17165,
17164,
17160,
17153,
17157,
17158,
-1,
-1,
17147,
17146,
17145,
17144,
17143,
]

_charnames_6528 = [
26533,
26504,
26530,
26518,
26526,
26501,
26489,
26497,
26513,
26521,
26531,
26484,
26492,
26502,
26515,
26514,
26527,
26486,
26485,
26498,
26524,
26523,
26534,
26495,
26494,
26505,
26537,
26532,
26535,
26508,
26503,
26506,
26536,
26538,
26539,
26507,
26509,
26510,
26529,
26517,
26500,
26488,
26520,
26491,
-1,
-1,
-1,
-1,
26566,
26559,
26565,
26549,
26553,
26567,
26562,
26554,
26555,
26550,
26561,
26560,
26552,
26557,
26556,
26551,
26564,
26543,
26542,
26541,
26544,
26545,
26546,
26547,
26585,
26584,
-1,
-1,
-1,
-1,
-1,
-1,
26578,
26579,
26570,
26571,
26576,
26577,
26573,
26574,
26581,
26580,
26586,
-1,
-1,
-1,
26587,
26588,
23095,
23142,
23094,
23139,
23136,
23091,
23088,
23085,
23082,
23079,
23117,
23114,
23104,
23111,
23108,
23101,
23143,
23141,
23093,
23138,
23135,
23090,
23087,
23084,
23081,
23078,
23116,
23113,
23103,
23110,
23107,
23100,
16826,
16829,
16813,
16812,
16824,
16832,
16818,
16817,
16821,
16830,
16815,
16814,
16831,
16827,
16810,
16809,
16819,
16823,
16825,
16820,
16822,
16833,
16828,
16837,
16835,
16838,
16836,
16839,
-1,
-1,
16840,
16841,
16912,
16911,
16910,
16885,
16883,
16884,
16933,
16921,
16920,
16894,
16896,
16893,
16932,
16928,
16923,
16944,
16897,
16929,
16915,
16914,
16888,
16887,
16934,
16945,
16918,
16917,
16925,
16891,
16899,
16890,
16941,
16895,
16922,
16927,
16930,
16900,
16902,
16939,
16907,
16906,
16908,
16924,
16903,
16946,
16898,
16937,
16938,
16935,
16936,
16943,
16940,
16901,
16942,
17035,
17036,
17040,
16965,
17043,
17039,
17042,
17037,
17044,
17041,
-1,
16962,
16992,
17001,
16995,
16998,
16999,
17000,
16991,
16990,
16988,
16989,
16982,
16984,
16986,
17002,
16994,
16987,
16993,
16997,
16985,
16964,
16972,
16971,
16953,
16952,
16951,
16975,
16967,
16954,
-1,
-1,
17045,
17027,
17028,
17019,
17020,
17025,
17026,
17022,
17023,
17030,
17029,
-1,
-1,
-1,
-1,
-1,
-1,
17013,
17014,
17005,
17006,
17011,
17012,
17008,
17009,
17016,
17015,
-1,
-1,
-1,
-1,
-1,
-1,
16968,
16969,
16961,
16957,
16977,
16979,
16974,
16966,
16955,
16956,
16959,
16960,
16978,
16980,
]

_charnames_6912 = [
16109,
16110,
16113,
16111,
16114,
15995,
15996,
16017,
16018,
16009,
16010,
16004,
16005,
16007,
16008,
16022,
15998,
16013,
16014,
15984,
15986,
16019,
16020,
15982,
16024,
16025,
16015,
16016,
15981,
15976,
15975,
15992,
15991,
15980,
15972,
15974,
15988,
15993,
15979,
16011,
16012,
16026,
16027,
16032,
16029,
16003,
16006,
16030,
16002,
16001,
15999,
16033,
16112,
16082,
16083,
16084,
16085,
16086,
16087,
16088,
16091,
16092,
16077,
16079,
16081,
16080,
16089,
16090,
16126,
15985,
15987,
15977,
16023,
16031,
16028,
15997,
-1,
-1,
-1,
-1,
16103,
16104,
16095,
16096,
16101,
16102,
16098,
16099,
16106,
16105,
16119,
16118,
16125,
16123,
16124,
16122,
16117,
16047,
16045,
16046,
16037,
16039,
16048,
16042,
16044,
16041,
16040,
16055,
16058,
16051,
16053,
16056,
16052,
16054,
16059,
16057,
16070,
16071,
16073,
16074,
16064,
16062,
16067,
16066,
16063,
-1,
-1,
-1,
19276,
19275,
19274,
19226,
19242,
19233,
19227,
19238,
19224,
19225,
19223,
19236,
19244,
19216,
19247,
19241,
19228,
19215,
19234,
19246,
19217,
19237,
19245,
19232,
19248,
19239,
19229,
19235,
19240,
19231,
19220,
19230,
19243,
19282,
19281,
19280,
19267,
19265,
19269,
19266,
19270,
19268,
19277,
-1,
-1,
-1,
19222,
19219,
19259,
19260,
19251,
19252,
19257,
19258,
19254,
19255,
19262,
19261,
]

_charnames_7168 = [
9892,
9890,
9891,
9908,
9907,
9887,
9914,
9913,
9923,
9886,
9880,
9879,
9896,
9888,
9884,
9882,
9883,
9911,
9910,
9917,
9916,
9902,
9901,
9878,
9877,
9894,
9918,
9921,
9922,
9905,
9904,
9920,
9899,
9898,
9919,
9924,
9966,
9967,
9956,
9954,
9952,
9953,
9950,
9951,
9955,
9942,
9947,
9948,
9940,
9946,
9945,
9944,
9941,
9943,
9969,
9970,
-1,
-1,
-1,
9961,
9962,
9963,
9960,
9959,
9935,
9936,
9927,
9928,
9933,
9934,
9930,
9931,
9938,
9937,
-1,
-1,
-1,
9875,
9874,
9895,
25156,
25157,
25148,
25149,
25154,
25155,
25151,
25152,
25159,
25158,
25120,
25115,
25118,
25116,
25117,
25121,
25113,
25114,
25112,
25111,
25124,
25137,
25140,
25139,
25138,
25122,
25130,
25129,
25128,
25127,
25125,
25143,
25145,
25144,
25142,
25123,
25133,
25135,
25132,
25134,
25167,
25169,
25166,
25168,
25164,
25170,
25162,
25163,
]

_charnames_7376 = [
24026,
24030,
24032,
24011,
24009,
24019,
24018,
24016,
24033,
24017,
24028,
24022,
24025,
24029,
24021,
24023,
24031,
24034,
24003,
23999,
24006,
24001,
24007,
24000,
24002,
23996,
23995,
23992,
23993,
24010,
24013,
24012,
24008,
23994,
23997,
]

_charnames_7424 = [
9046,
9047,
7793,
9045,
9062,
9061,
9037,
9035,
7795,
7799,
9058,
9057,
9039,
9056,
9025,
9027,
9029,
8088,
8089,
8090,
7796,
9028,
7836,
8385,
9054,
9024,
9033,
9031,
9052,
8091,
8093,
8092,
9051,
9050,
9048,
9036,
9083,
9080,
21670,
21669,
21667,
21668,
21666,
4499,
6641,
6642,
6639,
6640,
6657,
6656,
6636,
6655,
6654,
6653,
6652,
6651,
6650,
6649,
6648,
6635,
6637,
6638,
6647,
6633,
6646,
6645,
6643,
6601,
6535,
6602,
6537,
6575,
6598,
6565,
6562,
6593,
6543,
6570,
6544,
6623,
6611,
6569,
6590,
6592,
6546,
6576,
6606,
6533,
6583,
6563,
6540,
6604,
6603,
6577,
6573,
6600,
6572,
6557,
8487,
8484,
8482,
8481,
21320,
21318,
21316,
21317,
21319,
8068,
8381,
8223,
8448,
8419,
8258,
8407,
8123,
8116,
8085,
7828,
8320,
7807,
6672,
8200,
7841,
8478,
8204,
8403,
8477,
8066,
8380,
8222,
8447,
8365,
8353,
8158,
8418,
8257,
8406,
8122,
8084,
7957,
8394,
8464,
8319,
7999,
8015,
8217,
7937,
7904,
8130,
8097,
8188,
7902,
7956,
8056,
7952,
6536,
6549,
6558,
6567,
6588,
6624,
6599,
6561,
6545,
6617,
6616,
6551,
6553,
6614,
6596,
6597,
6556,
6612,
6541,
6610,
6609,
6555,
6578,
6607,
6564,
6568,
6548,
6585,
6584,
6554,
6605,
6542,
6579,
6581,
6582,
6566,
6547,
3594,
3595,
3725,
3723,
3700,
3672,
3698,
3682,
3673,
3683,
3498,
3745,
3699,
3586,
3763,
3770,
3742,
3755,
3754,
3519,
3494,
3493,
3492,
3506,
3502,
3504,
3518,
3526,
3516,
3499,
3525,
3524,
3514,
3523,
3522,
3497,
3512,
3500,
3507,
]

_charnames_7677 = [
3693,
3533,
3632,
8582,
7997,
8983,
8377,
8982,
8376,
8986,
8382,
8907,
8288,
8866,
8220,
8865,
8219,
8868,
8224,
8862,
8211,
8861,
8210,
8627,
7932,
8628,
7933,
8614,
7919,
8630,
7935,
8616,
7921,
9014,
8450,
8896,
8366,
8877,
8269,
8876,
8268,
8878,
8270,
8882,
8274,
8885,
8279,
8736,
8183,
8734,
8181,
8946,
8356,
8936,
8345,
8944,
8354,
8801,
8147,
8802,
8148,
8814,
8159,
8805,
8143,
8995,
8421,
8993,
8417,
8992,
8416,
8848,
8254,
8847,
8253,
8840,
8250,
8843,
8245,
8528,
7883,
8527,
7882,
8532,
7886,
8533,
7887,
8978,
8411,
8977,
8410,
8783,
8110,
8781,
8108,
8782,
8109,
8790,
8114,
8768,
8080,
8766,
8078,
8770,
8082,
8761,
8073,
8767,
8079,
8703,
7821,
8702,
7820,
8707,
7829,
8697,
7815,
8660,
8031,
8677,
8048,
8681,
8052,
8678,
8049,
8684,
8058,
8964,
8392,
8962,
8390,
8955,
8435,
8957,
8437,
8953,
8432,
8952,
8431,
8951,
8430,
9001,
8462,
9002,
8463,
8824,
8329,
8928,
8313,
8921,
8308,
8930,
8321,
8277,
7824,
8433,
8335,
7998,
8165,
8166,
8167,
8773,
8237,
8568,
7981,
8588,
8005,
8561,
7974,
8559,
7972,
8558,
7971,
8557,
7970,
8560,
7973,
8578,
7991,
8576,
7989,
8575,
7988,
8574,
7987,
8577,
7990,
8621,
7926,
8634,
7941,
8629,
7934,
8613,
7918,
8611,
7916,
8610,
7915,
8609,
7914,
8612,
7917,
8744,
8192,
8730,
8179,
8509,
7864,
8503,
7858,
8522,
7877,
8520,
7875,
8519,
7874,
8518,
7873,
8521,
7876,
8502,
7857,
8500,
7855,
8499,
7854,
8498,
7853,
8501,
7856,
8665,
8036,
8674,
8045,
8673,
8044,
8671,
8042,
8670,
8041,
8669,
8040,
8672,
8043,
8832,
8338,
8823,
8328,
8827,
8332,
8828,
8333,
8998,
8424,
8997,
8423,
8831,
8337,
21190,
21201,
21192,
21203,
21196,
21207,
21194,
21205,
21410,
21421,
21416,
21427,
21418,
21429,
21413,
21424,
21175,
21179,
21177,
21181,
21178,
21182,
-1,
-1,
21395,
21399,
21397,
21401,
21398,
21402,
-1,
-1,
21147,
21158,
21149,
21160,
21153,
21164,
21151,
21162,
21369,
21380,
21375,
21386,
21377,
21388,
21372,
21383,
21264,
21258,
21266,
21260,
21268,
21262,
21267,
21261,
21447,
21441,
21449,
21443,
21451,
21445,
21450,
21444,
21132,
21136,
21134,
21138,
21135,
21139,
-1,
-1,
21354,
21358,
21356,
21360,
21357,
21361,
-1,
-1,
21237,
21231,
21239,
21233,
21241,
21235,
21240,
21234,
-1,
21461,
-1,
21463,
-1,
21465,
-1,
21464,
21104,
21115,
21106,
21117,
21110,
21121,
21108,
21119,
21328,
21339,
21334,
21345,
21336,
21347,
21331,
21342,
21211,
21214,
21183,
21185,
21167,
21169,
21272,
21274,
21140,
21142,
21245,
21247,
21124,
21126,
-1,
-1,
21198,
21209,
21193,
21204,
21197,
21208,
21195,
21206,
21415,
21426,
21417,
21428,
21419,
21430,
21414,
21425,
21155,
21166,
21150,
21161,
21154,
21165,
21152,
21163,
21374,
21385,
21376,
21387,
21378,
21389,
21373,
21384,
21112,
21123,
21107,
21118,
21111,
21122,
21109,
21120,
21333,
21344,
21335,
21346,
21337,
21348,
21332,
21343,
21213,
21218,
21212,
21216,
21215,
-1,
21199,
21200,
21432,
21436,
21433,
21435,
21420,
21728,
21713,
21708,
21716,
21686,
21168,
21171,
21170,
-1,
21156,
21157,
21403,
21405,
21390,
21392,
21379,
21710,
21712,
21711,
21271,
21275,
21254,
21257,
-1,
-1,
21269,
21256,
21453,
21457,
21454,
21456,
-1,
21691,
21693,
21692,
21244,
21248,
21227,
21230,
21290,
21291,
21242,
21229,
21468,
21472,
21469,
21471,
21486,
21685,
21687,
21660,
-1,
-1,
21125,
21128,
21127,
-1,
21113,
21114,
21362,
21364,
21349,
21351,
21338,
21720,
21689,
-1,
11988,
11959,
11987,
11958,
18287,
27350,
19531,
27363,
26476,
18298,
20593,
27907,
27905,
27908,
9859,
25627,
21084,
26795,
27364,
11989,
11960,
21071,
24267,
24256,
9652,
25450,
19513,
19516,
9732,
25487,
24255,
24291,
24863,
24286,
16867,
18337,
25430,
18403,
21074,
21088,
9470,
26151,
9860,
25628,
26475,
9858,
25626,
26845,
26449,
26447,
26417,
24270,
18308,
25859,
25852,
25850,
3397,
19514,
19515,
25897,
24292,
27109,
25431,
27549,
5171,
3398,
13997,
21087,
27382,
9647,
25445,
24289,
27878,
11929,
17813,
25860,
16714,
16734,
10102,
25856,
5189,
18413,
3788,
19802,
27130,
27371,
18279,
27871,
27344,
27360,
18402,
27345,
24384,
18338,
24061,
7718,
27718,
27336,
27140,
27141,
27142,
-1,
-1,
-1,
-1,
-1,
27153,
14006,
27154,
14007,
26844,
26796,
19327,
19313,
-1,
-1,
19322,
19323,
19319,
19320,
19326,
19331,
19329,
19332,
19325,
19314,
19328,
19312,
19347,
19350,
19336,
19337,
19342,
19343,
19339,
19340,
19346,
19351,
19349,
19352,
19345,
19353,
19348,
-1,
8489,
8488,
8485,
8480,
8483,
]

_charnames_8352 = [
11995,
4035,
5221,
27384,
9634,
7771,
26847,
26459,
25795,
27719,
26589,
24410,
11996,
23380,
18397,
24867,
22188,
26458,
22015,
14016,
21092,
5210,
9633,
19794,
18069,
]

_charnames_8400 = [
3544,
3642,
3557,
3722,
3687,
3484,
3536,
3637,
3646,
3483,
3686,
3734,
3782,
3711,
3709,
3715,
3712,
3547,
3710,
3714,
3713,
3652,
3570,
3688,
3733,
3784,
3551,
3558,
3644,
3550,
3535,
3636,
3691,
]

_charnames_8448 = [
14008,
14015,
24305,
24711,
5206,
3399,
3404,
11997,
19740,
24710,
19738,
19731,
16797,
24303,
26441,
26442,
19730,
16796,
19729,
19737,
10151,
24302,
26842,
19715,
19727,
24297,
24301,
19726,
16795,
24300,
26391,
25893,
19756,
17946,
18341,
24066,
24299,
25422,
25432,
27132,
16794,
18394,
23378,
13975,
19734,
16798,
12004,
19739,
19733,
19732,
18395,
19728,
19736,
13992,
16663,
22353,
24862,
27146,
25953,
27392,
24314,
24315,
24304,
24298,
24316,
18387,
18386,
25857,
18385,
24312,
24311,
24310,
24309,
24308,
26413,
18391,
26448,
14019,
18388,
18975,
24076,
24078,
24073,
24072,
24088,
24080,
24089,
24085,
24094,
24075,
24092,
24081,
24086,
24093,
24096,
27383,
25919,
25914,
25918,
25911,
25903,
25926,
25928,
25931,
25933,
25916,
25930,
25915,
25907,
25923,
25906,
25921,
19632,
19622,
19624,
19631,
19628,
19637,
19638,
19641,
19642,
19625,
19640,
19623,
19630,
19635,
19629,
19634,
25922,
25905,
25917,
25932,
8132,
25927,
25910,
25909,
25924,
24095,
-1,
-1,
-1,
-1,
-1,
-1,
9761,
27402,
25529,
24334,
9661,
27451,
26721,
26750,
19698,
19708,
9776,
25544,
9850,
25619,
9833,
27441,
25601,
24362,
9765,
25533,
9796,
27412,
25564,
24345,
27452,
9779,
25547,
9778,
25546,
9674,
9665,
24367,
27407,
27406,
24339,
24338,
25548,
24342,
13966,
5194,
26724,
9783,
13967,
5195,
9811,
9818,
27427,
27422,
25579,
25586,
24360,
24355,
25566,
27411,
9798,
9853,
27447,
25622,
24370,
9819,
25587,
9843,
9671,
25611,
9839,
27444,
25607,
24365,
9668,
27454,
26731,
26759,
19705,
19713,
9836,
25604,
9851,
25620,
27409,
24341,
9847,
27445,
25615,
24366,
9782,
25556,
9849,
27429,
25617,
24368,
27435,
27431,
27434,
27433,
27436,
27437,
25618,
26725,
19701,
27453,
25468,
24344,
18281,
9775,
25543,
9664,
9773,
25541,
9666,
9854,
25623,
9675,
27357,
3793,
26155,
18291,
18292,
11950,
27149,
26848,
11933,
26770,
19649,
4027,
24404,
19661,
11992,
26820,
26805,
26814,
7757,
7766,
24392,
24844,
19755,
13996,
25641,
16868,
18605,
2537,
27349,
26412,
27144,
25456,
13971,
7721,
19787,
24847,
24407,
26148,
26785,
10139,
10128,
27093,
27536,
27112,
24283,
18318,
4028,
19394,
24101,
5196,
5192,
13964,
18293,
16668,
25964,
26411,
24394,
11931,
22182,
21081,
17795,
25848,
27133,
19517,
27722,
26779,
7765,
13998,
26769,
13806,
13809,
26638,
13981,
26771,
13983,
18316,
13988,
11910,
22180,
24855,
13810,
22181,
13807,
27198,
4036,
11897,
25642,
25643,
4037,
12003,
11911,
19764,
24715,
11905,
7738,
27879,
26784,
27008,
26787,
19770,
9981,
21763,
9984,
21768,
10006,
21789,
7363,
7364,
16662,
26783,
26786,
26788,
26627,
26632,
9980,
21762,
26626,
26631,
9982,
21764,
26628,
26633,
26392,
19374,
26405,
19387,
26404,
19386,
24398,
24405,
19355,
19286,
26768,
26767,
19362,
19293,
26637,
26636,
19364,
19295,
7357,
7360,
7359,
18666,
18689,
18669,
18692,
18614,
18616,
4912,
4928,
4922,
4906,
4908,
4924,
4933,
4938,
4909,
18780,
18783,
18790,
18793,
25504,
9717,
24373,
27467,
13999,
6801,
18342,
27356,
18304,
24264,
24400,
26778,
24409,
26622,
26406,
19388,
26761,
4025,
26762,
4026,
25287,
27197,
7361,
20951,
27111,
27910,
26846,
26717,
25460,
25500,
26817,
26816,
26821,
26806,
24830,
24393,
19762,
24846,
16529,
9757,
25526,
9656,
25453,
25849,
2531,
2532,
24246,
24244,
24282,
24280,
26463,
11906,
10000,
21784,
24064,
24065,
10008,
21794,
11903,
11904,
11902,
11901,
24399,
24406,
26775,
26774,
18668,
18691,
10005,
21788,
26407,
19389,
26780,
24402,
26781,
24403,
24062,
7769,
27469,
24375,
11940,
11936,
19651,
11941,
11939,
19652,
11937,
11938,
4023,
4021,
19659,
4022,
19660,
27902,
24831,
11947,
21076,
27464,
24377,
26414,
26451,
27705,
9696,
25497,
9750,
25520,
16514,
16519,
18347,
18352,
25865,
18698,
13702,
19757,
19752,
17947,
26473,
24099,
26443,
18393,
27713,
21077,
18353,
18348,
16520,
16515,
18362,
16526,
27379,
19693,
27465,
25399,
11972,
27911,
23377,
9864,
25632,
11973,
16659,
4573,
13989,
19018,
18380,
24854,
4031,
19785,
4016,
4015,
13784,
13778,
13732,
13713,
13714,
13730,
13725,
13758,
13761,
13779,
13802,
13726,
13733,
13721,
13731,
13791,
13786,
13722,
13727,
13763,
13741,
13753,
13711,
13716,
13742,
13773,
13718,
13768,
13749,
13719,
13715,
13769,
13745,
13710,
13735,
13752,
13754,
13794,
13760,
13771,
13736,
13759,
13724,
13770,
13750,
13777,
13795,
13762,
13743,
13792,
13799,
13800,
13764,
13748,
13798,
13776,
13780,
13729,
13728,
13744,
13772,
13782,
13787,
13788,
13797,
13801,
13783,
13789,
13796,
26789,
25459,
19611,
16667,
24043,
27090,
4029,
24850,
11956,
3792,
27576,
11991,
13985,
20950,
4887,
4921,
15580,
27548,
7005,
21091,
25397,
25396,
26160,
26159,
24853,
19719,
13706,
24713,
26408,
26639,
26416,
5199,
9738,
9740,
9739,
25507,
25509,
25508,
9648,
9650,
9649,
25446,
25448,
25447,
9691,
9692,
9693,
2533,
25493,
25494,
25495,
27126,
21073,
27482,
27477,
19392,
19393,
18360,
16522,
16523,
25963,
9752,
25511,
21068,
21067,
21066,
21065,
24689,
24692,
24697,
24707,
24702,
24696,
24706,
24701,
24694,
24705,
24700,
24703,
24698,
24690,
24693,
18712,
25894,
12005,
24044,
7751,
7748,
7749,
7747,
7742,
7743,
7744,
7745,
7750,
12000,
27337,
18361,
16525,
18363,
16527,
18359,
16524,
27681,
16660,
19772,
27374,
14009,
11946,
24714,
]

_charnames_9216 = [
19001,
18969,
18968,
18993,
18991,
18995,
19017,
19009,
19010,
19015,
19014,
19011,
19003,
19006,
18971,
18972,
18986,
18982,
18980,
18981,
18983,
19000,
18973,
18992,
19007,
18994,
18965,
18996,
19004,
19016,
19013,
19012,
18974,
18984,
16803,
25393,
18999,
18985,
18966,
]

_charnames_9280 = [
25413,
25411,
25414,
25412,
25405,
25404,
25403,
25415,
25408,
25410,
25407,
]

_charnames_9312 = [
4902,
4893,
4894,
4899,
4900,
4896,
4897,
4904,
4903,
4752,
4788,
4733,
4751,
4772,
4776,
4780,
4783,
4787,
4789,
4717,
26137,
26129,
26130,
26135,
26136,
26132,
26133,
26139,
26138,
26116,
26124,
26114,
26115,
26121,
26122,
26118,
26119,
26125,
26126,
26113,
24752,
24722,
24726,
24740,
24744,
24731,
24735,
24760,
24756,
26829,
26839,
26827,
26828,
26836,
26837,
26832,
26834,
26840,
26841,
26826,
25996,
25995,
25994,
25993,
25992,
25991,
25990,
25989,
25988,
25987,
25986,
25985,
25984,
25983,
25982,
25981,
25980,
25979,
25978,
25977,
25976,
25975,
25974,
25973,
25972,
25971,
4712,
4711,
4710,
4709,
4708,
4707,
4706,
4705,
4704,
4703,
4702,
4701,
4700,
4699,
4698,
4697,
4696,
4695,
4694,
4693,
4692,
4691,
4690,
4689,
4688,
4687,
4685,
4684,
4683,
4682,
4681,
4680,
4679,
4678,
4677,
4676,
4675,
4674,
4673,
4672,
4671,
4670,
4669,
4668,
4667,
4666,
4665,
4664,
4663,
4662,
4661,
4660,
4901,
26606,
26597,
26598,
26603,
26604,
26600,
26601,
26607,
26608,
26596,
24237,
24229,
24230,
24235,
24236,
24232,
24233,
24239,
24238,
24240,
26612,
16300,
16386,
16279,
16372,
16293,
16379,
16292,
16378,
16296,
16382,
16295,
16381,
16261,
16317,
16326,
16359,
16262,
16320,
16329,
16360,
16277,
16390,
16399,
16370,
16278,
16393,
16402,
16369,
16281,
16420,
16400,
16325,
16424,
16316,
16391,
16374,
16282,
16421,
16403,
16328,
16425,
16319,
16394,
16375,
16263,
16309,
16439,
16322,
16331,
16435,
16305,
16361,
16275,
16308,
16438,
16395,
16404,
16434,
16304,
16371,
16283,
16307,
16437,
16422,
16405,
16330,
16426,
16310,
16440,
16311,
16441,
16321,
16396,
16433,
16303,
16376,
16266,
16364,
16265,
16363,
16354,
16341,
16333,
16337,
16351,
16334,
16338,
16352,
16407,
16411,
16347,
16408,
16412,
16348,
16416,
16428,
16343,
16417,
16429,
16344,
16335,
16339,
16353,
16409,
16413,
16349,
16418,
16430,
16345,
16289,
16290,
16287,
16286,
16269,
16270,
16271,
16297,
16272,
16299,
16259,
16383,
16365,
16385,
16357,
16298,
16276,
16384,
16368,
27487,
10095,
10094,
10092,
10089,
10097,
10091,
10096,
27333,
9655,
9714,
9748,
9755,
9715,
9743,
9744,
25517,
9629,
7712,
24861,
27488,
25515,
27869,
27868,
27856,
27863,
27862,
27860,
27859,
27864,
27865,
27866,
16700,
27561,
27573,
27577,
18550,
18546,
18549,
18539,
18536,
18551,
16694,
27582,
16736,
27641,
16775,
27668,
16789,
27693,
16755,
27674,
16756,
27676,
16729,
27638,
16730,
27639,
16727,
27636,
16747,
27626,
16748,
27627,
16708,
27645,
16709,
27646,
16710,
27647,
16738,
27618,
27623,
27365,
10149,
27592,
24385,
4951,
16869,
16681,
4950,
4953,
4949,
4944,
4943,
4955,
9756,
25518,
27138,
27137,
27485,
10087,
27481,
27475,
10078,
10085,
27486,
10088,
16717,
16718,
16753,
16752,
27695,
18545,
18548,
18540,
18543,
27575,
27675,
27492,
27491,
9197,
27571,
27567,
27566,
27570,
27596,
27599,
27598,
27595,
27480,
27473,
10083,
27655,
16761,
27656,
16762,
10077,
16698,
5198,
27551,
19796,
3794,
16699,
27586,
9632,
18296,
19211,
14000,
24684,
4030,
25400,
16781,
27683,
16129,
16132,
16131,
19207,
27553,
21080,
27588,
16703,
19600,
25863,
16712,
16735,
27649,
27677,
27640,
27628,
19800,
3405,
25962,
16874,
3403,
13976,
25291,
5175,
5218,
5219,
19765,
27391,
14014,
20591,
26461,
15317,
18327,
18326,
18328,
18324,
18322,
18323,
18325,
18329,
27699,
27664,
27584,
16697,
27585,
27366,
9200,
7752,
27396,
11999,
6448,
27848,
19206,
27555,
26641,
26439,
13701,
17440,
22189,
3342,
10009,
24098,
9635,
19741,
19209,
3407,
14018,
26465,
27607,
27609,
27608,
27611,
27606,
27610,
16676,
16678,
16677,
16680,
16675,
16679,
16701,
27690,
27621,
16687,
27587,
16772,
16741,
27616,
21079,
27874,
11984,
16666,
16665,
7343,
7342,
7341,
27724,
12001,
27546,
25886,
25885,
25884,
25883,
25882,
25881,
25880,
25887,
16757,
25888,
26154,
26455,
27698,
24839,
24838,
24837,
24836,
24835,
24834,
27602,
27603,
16683,
16684,
7003,
7002,
24775,
24768,
24769,
24774,
27661,
16785,
20592,
13978,
5215,
19768,
19742,
13991,
27370,
22183,
19767,
14017,
27376,
25418,
18275,
18276,
27714,
21061,
24330,
24329,
27108,
6449,
6446,
6447,
24059,
21072,
7716,
7719,
7711,
6525,
24848,
27550,
4038,
27335,
26640,
5211,
26163,
27849,
24067,
5174,
16765,
19754,
19745,
27881,
19749,
19721,
16251,
18785,
27630,
27631,
16744,
16745,
19797,
19283,
25960,
16702,
18297,
18392,
18396,
27622,
5220,
24851,
-1,
26468,
3401,
20949,
4930,
5172,
26798,
13986,
16779,
27682,
16713,
27650,
24868,
20928,
9695,
18771,
27390,
16780,
25892,
25891,
-1,
20874,
-1,
-1,
-1,
-1,
16686,
19613,
5176,
3406,
21060,
22185,
22186,
6526,
7006,
27554,
27351,
27375,
27397,
19208,
18711,
19801,
27199,
26452,
18068,
27846,
20947,
27338,
2536,
27662,
-1,
27489,
16704,
10098,
27590,
-1,
17948,
17441,
14020,
11990,
-1,
-1,
24100,
27721,
10079,
26460,
27476,
27694,
16790,
5060,
20879,
7356,
20942,
16133,
20892,
25420,
20944,
25387,
20933,
9018,
19598,
25419,
6450,
19763,
27346,
27348,
20945,
27347,
16786,
27665,
-1,
19771,
4917,
25388,
16688,
25421,
20932,
26466,
19597,
20946,
25389,
11983,
11980,
11979,
19528,
11978,
20925,
18414,
19530,
18071,
25386,
20897,
19529,
16784,
27663,
11981,
4936,
20896,
19798,
17814,
20878,
19792,
20904,
16134,
11982,
20924,
-1,
19599,
-1,
10080,
27478,
10075,
27474,
-1,
-1,
-1,
16742,
20921,
9628,
7717,
20939,
20902,
20903,
20936,
20937,
-1,
-1,
2534,
20922,
20943,
20891,
25951,
27372,
25952,
7707,
7702,
7715,
7714,
7709,
7704,
20915,
20909,
20916,
20910,
9631,
9630,
7708,
7703,
24803,
24795,
24796,
24801,
24802,
24798,
24799,
24805,
24804,
24806,
24818,
24810,
24811,
24816,
24817,
24813,
24814,
24820,
24819,
24821,
24789,
24781,
24782,
24787,
24788,
24784,
24785,
24791,
24790,
24792,
20927,
-1,
-1,
-1,
20905,
20911,
20941,
24866,
20912,
18336,
20899,
24858,
20938,
16732,
18285,
18286,
16733,
20890,
20889,
18795,
20880,
25635,
9867,
16252,
27380,
20917,
20940,
26792,
-1,
26791,
4888,
27696,
16800,
16801,
16802,
20884,
20885,
20886,
18072,
20898,
27725,
20929,
25398,
-1,
18280,
27680,
26453,
25392,
25391,
9658,
25454,
25292,
25872,
19308,
24053,
-1,
10125,
-1,
-1,
-1,
27620,
13977,
11943,
10081,
27483,
9745,
25514,
27332,
9194,
9196,
9703,
9702,
9758,
10123,
10115,
27468,
10150,
27612,
27615,
27614,
27568,
27574,
6308,
6301,
6311,
6304,
6310,
6303,
6307,
6300,
6309,
6302,
27446,
24369,
13969,
5197,
25469,
10108,
10120,
10114,
10106,
10118,
10113,
10109,
10121,
10107,
10119,
10122,
15578,
15323,
15451,
15324,
15515,
15388,
15452,
15325,
15547,
15420,
15484,
15357,
15516,
15389,
15453,
15326,
15563,
15436,
15500,
15373,
15532,
15405,
15469,
15342,
15548,
15421,
15485,
15358,
15517,
15390,
15454,
15327,
15571,
15444,
15508,
15381,
15540,
15413,
15477,
15350,
15556,
15429,
15493,
15366,
15525,
15398,
15462,
15335,
15564,
15437,
15501,
15374,
15533,
15406,
15470,
15343,
15549,
15422,
15486,
15359,
15518,
15391,
15455,
15328,
15575,
15448,
15512,
15385,
15544,
15417,
15481,
15354,
15560,
15433,
15497,
15370,
15529,
15402,
15466,
15339,
15568,
15441,
15505,
15378,
15537,
15410,
15474,
15347,
15553,
15426,
15490,
15363,
15522,
15395,
15459,
15332,
15572,
15445,
15509,
15382,
15541,
15414,
15478,
15351,
15557,
15430,
15494,
15367,
15526,
15399,
15463,
15336,
15565,
15438,
15502,
15375,
15534,
15407,
15471,
15344,
15550,
15423,
15487,
15360,
15519,
15392,
15456,
15329,
15577,
15450,
15514,
15387,
15546,
15419,
15483,
15356,
15562,
15435,
15499,
15372,
15531,
15404,
15468,
15341,
15570,
15443,
15507,
15380,
15539,
15412,
15476,
15349,
15555,
15428,
15492,
15365,
15524,
15397,
15461,
15334,
15574,
15447,
15511,
15384,
15543,
15416,
15480,
15353,
15559,
15432,
15496,
15369,
15528,
15401,
15465,
15338,
15567,
15440,
15504,
15377,
15536,
15409,
15473,
15346,
15552,
15425,
15489,
15362,
15521,
15394,
15458,
15331,
15576,
15449,
15513,
15386,
15545,
15418,
15482,
15355,
15561,
15434,
15498,
15371,
15530,
15403,
15467,
15340,
15569,
15442,
15506,
15379,
15538,
15411,
15475,
15348,
15554,
15427,
15491,
15364,
15523,
15396,
15460,
15333,
15573,
15446,
15510,
15383,
15542,
15415,
15479,
15352,
15558,
15431,
15495,
15368,
15527,
15400,
15464,
15337,
15566,
15439,
15503,
15376,
15535,
15408,
15472,
15345,
15551,
15424,
15488,
15361,
15520,
15393,
15457,
15330,
25597,
25598,
9842,
25610,
9670,
25599,
9844,
25612,
24340,
27408,
27442,
24363,
9846,
25614,
9835,
25603,
25600,
25542,
27410,
24343,
25535,
25536,
25593,
25595,
25596,
9799,
25567,
9845,
25613,
9784,
25555,
9797,
25565,
26729,
26757,
26726,
26755,
19700,
19710,
26728,
26756,
19703,
19711,
25647,
27388,
19702,
26753,
27389,
25646,
26754,
26727,
27710,
13696,
13697,
13700,
13699,
25634,
9866,
18356,
16528,
18358,
18357,
10076,
10084,
13965,
5193,
25562,
9794,
19609,
25545,
9777,
25551,
9667,
27440,
9722,
9724,
27459,
27461,
9721,
27458,
9725,
27462,
9809,
25577,
27425,
24358,
9814,
25582,
27420,
24353,
9810,
25578,
27426,
24359,
9815,
25583,
27421,
24354,
9807,
27418,
25576,
24352,
9808,
9817,
25575,
25585,
9806,
9816,
25574,
25584,
27419,
24351,
25484,
11887,
17801,
9793,
25561,
25563,
9992,
9788,
21776,
19373,
9787,
19304,
9749,
25521,
27470,
24376,
18305,
27890,
27900,
9681,
25474,
9685,
25478,
27898,
27893,
27899,
27894,
9646,
25444,
9644,
25443,
9645,
25442,
9700,
25462,
9708,
25470,
24260,
24288,
9727,
25523,
24390,
24057,
7736,
25463,
7737,
13974,
14003,
19790,
19789,
18390,
25861,
13973,
25862,
25425,
25426,
7725,
7726,
7734,
7735,
7728,
7731,
7729,
7732,
25867,
11954,
11952,
11953,
11955,
4954,
4935,
4914,
4925,
4913,
4956,
4946,
4934,
27466,
4918,
4939,
4713,
4937,
4947,
4952,
18791,
18789,
18794,
18769,
18768,
18411,
18335,
18333,
19803,
18334,
25501,
9711,
24056,
16532,
16531,
16791,
17812,
17811,
27686,
16768,
9687,
25480,
9731,
25486,
27151,
17815,
27145,
24327,
18552,
27150,
19612,
11890,
11891,
27009,
22318,
18294,
24380,
24379,
16740,
16719,
27601,
16685,
11964,
11968,
11965,
11969,
11966,
11970,
25796,
25873,
19717,
25871,
16872,
16873,
24273,
18309,
9863,
25631,
17808,
7767,
26804,
26803,
26802,
26809,
26808,
26813,
26812,
18407,
18406,
26819,
6800,
19391,
27872,
27367,
27122,
27124,
4959,
13968,
9468,
9467,
9469,
27125,
27873,
27120,
27118,
27121,
27116,
27119,
27117,
27850,
9195,
27889,
27888,
27887,
26429,
26431,
26426,
26430,
26425,
26428,
26432,
7763,
7762,
7761,
7760,
26436,
26435,
24068,
7355,
7354,
19746,
19692,
7351,
7350,
4927,
7352,
4907,
26434,
7764,
7349,
27110,
25638,
27895,
14012,
27098,
27540,
27539,
27096,
27097,
27541,
27543,
27100,
27544,
27101,
27545,
27102,
5186,
5188,
24249,
24248,
5187,
10145,
10135,
24259,
24258,
18410,
18409,
19783,
19784,
10138,
10147,
10136,
10148,
10137,
10144,
10146,
10143,
19681,
10134,
10133,
27901,
27896,
11894,
27010,
18315,
18314,
17799,
17798,
19525,
4032,
11896,
13982,
13808,
11888,
26437,
11886,
24241,
18412,
18282,
11893,
11909,
10001,
21785,
9999,
21783,
9974,
21756,
9978,
21760,
9976,
21758,
9977,
21759,
9983,
21765,
9996,
21780,
9997,
21781,
9994,
21778,
9989,
21773,
9990,
21774,
9993,
21777,
9991,
21775,
19776,
19778,
19777,
19779,
24325,
24326,
24320,
24321,
19520,
19521,
19523,
19524,
24275,
24277,
24276,
21767,
21790,
10002,
21791,
10003,
21792,
19690,
9198,
19691,
9199,
11895,
26397,
19379,
26396,
19378,
26401,
19383,
26399,
19381,
26402,
19384,
26400,
19382,
24272,
24245,
19368,
19299,
19366,
19297,
19367,
19298,
19363,
19294,
19360,
19291,
19358,
19289,
19361,
19292,
19359,
19290,
18703,
18595,
5184,
5182,
5185,
5183,
19371,
19303,
19372,
19302,
19306,
19307,
11944,
26464,
18340,
27354,
26794,
19610,
19607,
19603,
26454,
24054,
24266,
24055,
24265,
10126,
19608,
19605,
19606,
24285,
24279,
24250,
25854,
24408,
24042,
24041,
24374,
26147,
26146,
18306,
18303,
18319,
18311,
18312,
24322,
24323,
18317,
9190,
24251,
27670,
26818,
26758,
26730,
19704,
19712,
9673,
9855,
27448,
24371,
26760,
26732,
19706,
19714,
9676,
27455,
25539,
25538,
9771,
9770,
18547,
18553,
18537,
18544,
24828,
24827,
24826,
24829,
24387,
16721,
27651,
16777,
27671,
16788,
27692,
27689,
16771,
21070,
16722,
16764,
27658,
16763,
27657,
16696,
16695,
27583,
16769,
27687,
16776,
27669,
9706,
18277,
9707,
10110,
9829,
9830,
9831,
9832,
9774,
9767,
9768,
9825,
9827,
9828,
9786,
27711,
11889,
25876,
9792,
25553,
25552,
9852,
25621,
25875,
25560,
17802,
9795,
9791,
25559,
-1,
-1,
-1,
27654,
16693,
27581,
16728,
27637,
20918,
20931,
20875,
20872,
20876,
]

_charnames_11264 = [
22317,
22306,
22308,
22315,
22288,
22270,
22291,
22287,
22292,
22277,
22281,
22274,
22289,
22313,
22300,
22312,
22311,
22298,
22294,
22310,
22264,
22283,
22309,
22303,
22314,
22297,
22295,
22258,
22284,
22316,
22260,
22268,
22269,
22273,
22263,
22271,
22261,
22262,
22272,
22279,
22307,
22280,
22304,
22276,
22259,
22285,
22301,
-1,
22254,
22243,
22245,
22252,
22225,
22207,
22228,
22224,
22229,
22214,
22218,
22211,
22226,
22250,
22237,
22249,
22248,
22235,
22231,
22247,
22201,
22220,
22246,
22240,
22251,
22234,
22232,
22195,
22221,
22253,
22197,
22205,
22206,
22210,
22200,
22208,
22198,
22199,
22209,
22216,
22244,
22217,
22241,
22213,
22196,
22222,
22238,
-1,
8803,
8149,
8812,
8972,
8788,
8001,
7823,
8879,
8271,
8938,
8347,
8923,
8310,
8600,
8994,
8710,
8711,
8393,
8954,
8434,
8396,
8888,
8283,
7847,
7939,
7785,
7889,
9034,
8486,
6644,
8771,
8925,
3961,
3869,
3964,
3872,
3956,
3864,
3921,
3829,
3970,
3878,
3926,
3834,
3963,
3871,
3953,
3861,
3943,
3851,
3969,
3877,
3941,
3849,
3949,
3857,
3968,
3876,
3967,
3875,
3940,
3848,
3891,
3799,
3947,
3855,
3966,
3874,
3927,
3835,
3944,
3852,
3965,
3873,
3958,
3866,
3938,
3846,
3946,
3854,
3913,
3821,
3919,
3827,
3906,
3814,
3934,
3842,
3917,
3825,
3916,
3824,
3932,
3840,
3902,
3810,
3928,
3836,
3935,
3843,
3901,
3809,
3904,
3812,
3962,
3870,
3918,
3826,
3897,
3805,
3895,
3803,
3950,
3858,
3898,
3806,
3896,
3804,
3903,
3811,
3905,
3813,
3900,
3808,
3912,
3820,
3910,
3818,
3909,
3817,
3911,
3819,
3885,
3888,
3887,
3881,
3886,
3884,
3882,
3931,
3839,
3933,
3841,
3975,
3974,
3973,
]

_charnames_11513 = [
3979,
3980,
3978,
3977,
3983,
3982,
3984,
22126,
22125,
22111,
22124,
22123,
22114,
22093,
22096,
22122,
22105,
22121,
22120,
22119,
22118,
22102,
22092,
22116,
22099,
22095,
22115,
22101,
22104,
22110,
22117,
22098,
22087,
22090,
22107,
22089,
22088,
22112,
22108,
22081,
22084,
22083,
22113,
22080,
22082,
]

_charnames_11568 = [
17733,
17757,
17758,
17750,
17752,
17787,
17767,
17734,
17737,
17735,
17736,
17773,
17768,
17747,
17776,
17749,
17755,
17788,
17784,
17756,
17770,
17748,
17777,
17762,
17782,
17772,
17740,
17791,
17781,
17766,
17765,
17764,
17779,
17783,
17763,
17771,
17753,
17754,
17751,
17780,
17790,
17744,
17745,
17746,
17741,
17743,
17769,
17742,
17761,
17760,
17759,
17738,
17785,
17739,
]

_charnames_11648 = [
11779,
11730,
11768,
11429,
11396,
11759,
11465,
11575,
11677,
11668,
11363,
11634,
11697,
11688,
11789,
11438,
11566,
11596,
11608,
11351,
11353,
11350,
11349,
]

_charnames_11680 = [
11416,
11418,
11420,
11417,
11415,
11414,
11419,
-1,
11559,
11561,
11563,
11560,
11558,
11557,
11562,
-1,
11628,
11630,
11632,
11629,
11627,
11626,
11631,
-1,
11552,
11554,
11556,
11553,
11551,
11550,
11555,
-1,
11491,
11493,
11495,
11492,
11490,
11489,
11494,
-1,
11528,
11530,
11532,
11529,
11527,
11526,
11531,
-1,
11646,
11648,
11650,
11647,
11645,
11644,
11649,
-1,
11374,
11376,
11378,
11375,
11373,
11372,
11377,
-1,
3443,
3444,
3451,
3440,
3427,
3428,
3449,
3420,
3419,
3418,
3446,
3445,
3417,
3415,
3434,
3450,
3433,
3453,
3437,
3436,
3452,
3416,
3454,
3425,
3439,
3447,
3431,
3430,
3424,
3448,
3442,
3423,
25464,
25465,
9657,
25452,
9735,
25489,
25958,
25959,
24386,
9712,
25502,
25957,
9677,
25525,
12006,
26150,
27355,
25866,
21090,
24389,
24346,
27413,
24388,
24290,
27134,
26162,
21086,
17807,
9759,
25527,
17806,
17805,
9753,
25512,
18354,
18349,
16521,
16516,
9653,
25451,
9733,
25488,
18404,
25429,
18788,
27361,
25864,
24058,
25640,
27717,
]

_charnames_11904 = [
1232,
1119,
1141,
1139,
1140,
1250,
1169,
1226,
1257,
1256,
1253,
1142,
1153,
1152,
1193,
1191,
1192,
1194,
1147,
1225,
1146,
1145,
1210,
1209,
1213,
1229,
-1,
1124,
1154,
1163,
1254,
1161,
1121,
1181,
1180,
1260,
1249,
1248,
1133,
1123,
1252,
1205,
1171,
1220,
1150,
1149,
1176,
1135,
1091,
1237,
1235,
1236,
1238,
1165,
1155,
1230,
1221,
1261,
1174,
1173,
1166,
1162,
1244,
1242,
1243,
1224,
1118,
1187,
1186,
1093,
1132,
1212,
1090,
1092,
1259,
1115,
1130,
1184,
1183,
1122,
1107,
1197,
1196,
1104,
1108,
1160,
1159,
1231,
1175,
1098,
1105,
1112,
1101,
1219,
1217,
1218,
1111,
1211,
1113,
1170,
1245,
1102,
1116,
1094,
1129,
1134,
1100,
1203,
1110,
1202,
1097,
1204,
1114,
1223,
1201,
1096,
]

_charnames_12032 = [
22634,
22563,
22413,
22392,
22387,
22582,
22467,
22565,
22554,
22560,
22597,
22601,
22417,
22501,
22653,
22466,
22633,
22662,
22627,
22524,
22373,
22605,
22588,
22478,
22426,
22388,
22510,
22626,
22643,
22543,
22598,
22592,
22403,
22615,
22617,
22595,
22453,
22527,
22516,
22612,
22652,
22409,
22569,
22502,
22372,
22541,
22604,
22526,
22635,
22471,
22429,
22378,
22416,
22567,
22468,
22380,
22437,
22408,
22444,
22365,
22585,
22575,
22419,
22576,
22445,
22609,
22402,
22427,
22641,
22406,
22646,
22405,
22395,
22547,
22461,
22570,
22361,
22434,
22536,
22421,
22503,
22495,
22508,
22366,
22521,
22482,
22507,
22486,
22418,
22574,
22393,
22487,
22500,
22420,
22625,
22659,
22552,
22476,
22404,
22564,
22661,
22484,
22439,
22400,
22415,
22532,
22410,
22425,
22599,
22371,
22639,
22363,
22374,
22462,
22620,
22512,
22367,
22455,
22606,
22399,
22658,
22648,
22383,
22497,
22636,
22642,
22628,
22591,
22443,
22553,
22549,
22385,
22640,
22545,
22474,
22632,
22441,
22362,
22504,
22619,
22477,
22651,
22448,
22520,
22509,
22535,
22386,
22581,
22370,
22656,
22457,
22629,
22456,
22382,
22613,
22611,
22496,
22440,
22514,
22451,
22546,
22519,
22515,
22529,
22424,
22655,
22616,
22566,
22622,
22542,
22391,
22379,
22610,
22447,
22523,
22488,
22558,
22464,
22561,
22407,
22559,
22530,
22493,
22593,
22586,
22491,
22580,
22438,
22465,
22577,
22483,
22397,
22513,
22621,
22481,
22452,
22396,
22433,
22533,
22587,
22660,
22550,
22449,
22600,
22490,
22460,
22430,
22608,
22647,
22594,
22473,
22431,
22470,
22494,
]

_charnames_12272 = [
26987,
26991,
26988,
26990,
26993,
26985,
26984,
26983,
26980,
26979,
26982,
26992,
-1,
-1,
-1,
-1,
26999,
26996,
27005,
24852,
27845,
27003,
26997,
27001,
9699,
25461,
9734,
25485,
9694,
25496,
9682,
25475,
9728,
25524,
26471,
22187,
9716,
25503,
9686,
25479,
9683,
25476,
9684,
25477,
27712,
25853,
24271,
10101,
26472,
20410,
20398,
20401,
20408,
20409,
20405,
20406,
20412,
20411,
27002,
27000,
26994,
27006,
20392,
20394,
27707,
24046,
24050,
24048,
24051,
24049,
4911,
26952,
20403,
20399,
20402,
24060,
6523,
26157,
26998,
27004,
-1,
20970,
21056,
20968,
21054,
20965,
21052,
20969,
21055,
20967,
21053,
21017,
21029,
21015,
21027,
21013,
21025,
21016,
21028,
21014,
21026,
20975,
20987,
20973,
20985,
20971,
20983,
20974,
20986,
20972,
20984,
20993,
21035,
20991,
21033,
20966,
20989,
21031,
20992,
21034,
20990,
21032,
20981,
20979,
20977,
20980,
20978,
21023,
21041,
21005,
21021,
21039,
21003,
21019,
21037,
21001,
21022,
21040,
21004,
21020,
21038,
21002,
21011,
21009,
21007,
21010,
21008,
20960,
21050,
20958,
21048,
20959,
21049,
20999,
20997,
20995,
20998,
20996,
20964,
21046,
21044,
21045,
21043,
20976,
21051,
20963,
20962,
-1,
-1,
3779,
3780,
22913,
22914,
21058,
21057,
21059,
22916,
22816,
22907,
22814,
22905,
22810,
22903,
22815,
22906,
22811,
22904,
22869,
22881,
22867,
22879,
22865,
22877,
22868,
22880,
22866,
22878,
22821,
22833,
22819,
22831,
22817,
22829,
22820,
22832,
22818,
22830,
22845,
22887,
22843,
22885,
22804,
22841,
22883,
22844,
22886,
22842,
22884,
22827,
22825,
22823,
22826,
22824,
22875,
22893,
22857,
22873,
22891,
22855,
22871,
22889,
22853,
22874,
22892,
22856,
22872,
22890,
22854,
22863,
22861,
22859,
22862,
22860,
22798,
22902,
22796,
22900,
22797,
22901,
22851,
22849,
22847,
22850,
22848,
22809,
22898,
22896,
22897,
22895,
22822,
22835,
22802,
22801,
22839,
22837,
22838,
22836,
22909,
22915,
22910,
22908,
22911,
-1,
-1,
-1,
-1,
-1,
16492,
16499,
16500,
16504,
16505,
16496,
16478,
16501,
16481,
16502,
16503,
16488,
16498,
16494,
16477,
16491,
16487,
16497,
16475,
16490,
16486,
16444,
16468,
16453,
16459,
16450,
16458,
16448,
16472,
16445,
16454,
16447,
16456,
16457,
16461,
16484,
16464,
16495,
16479,
16483,
16467,
-1,
-1,
-1,
20351,
20303,
20352,
20354,
20360,
20359,
20381,
20299,
20314,
20324,
20328,
20317,
20327,
20323,
20319,
20329,
20367,
20331,
20301,
20333,
20307,
20300,
20386,
20388,
20306,
20389,
20353,
20382,
20342,
20391,
20373,
20376,
20294,
20295,
20379,
20377,
20282,
20277,
20383,
20364,
20365,
20384,
20289,
20390,
20363,
20362,
20366,
20284,
20378,
20296,
20385,
20393,
20302,
20356,
20357,
20358,
20325,
20322,
20318,
20320,
20326,
20370,
20372,
20371,
20350,
20340,
20338,
20336,
20335,
20341,
20339,
20347,
20349,
20312,
20311,
20309,
20310,
20313,
20343,
20304,
20278,
20280,
20281,
20348,
20305,
20283,
20291,
20292,
20293,
20287,
20286,
20288,
20374,
20375,
-1,
26971,
26969,
26970,
26958,
26956,
26963,
26959,
26966,
26974,
26964,
26968,
26957,
26962,
26972,
26973,
26967,
16493,
16476,
16489,
16482,
16460,
16455,
16473,
16470,
16465,
16446,
16462,
16485,
16466,
16480,
16451,
16449,
16452,
16474,
16471,
16463,
16508,
16507,
16509,
16510,
]

_charnames_12736 = [
1291,
1294,
1293,
1298,
1281,
1265,
1272,
1273,
1270,
1280,
1271,
1268,
1274,
1269,
1266,
1296,
1263,
1277,
1287,
1285,
1297,
1264,
1276,
1278,
1282,
1284,
1286,
1290,
1288,
1292,
1279,
1283,
1275,
1267,
1289,
1295,
]

_charnames_12784 = [
22800,
22808,
22807,
22805,
22812,
22794,
22792,
22790,
22793,
22791,
22813,
22788,
22786,
22784,
22787,
22785,
26094,
26102,
26084,
26100,
26104,
26089,
26098,
26106,
26077,
26081,
26096,
26086,
26091,
26108,
26095,
26103,
26085,
26101,
26105,
26090,
26099,
26107,
26080,
26082,
26097,
26087,
26092,
26109,
26079,
26141,
26142,
-1,
26071,
26052,
26053,
26043,
26040,
26037,
26033,
26057,
26063,
26054,
26066,
26041,
26061,
26060,
26067,
26058,
26028,
26031,
26073,
26036,
26064,
26035,
26042,
26069,
26072,
26049,
26070,
26030,
26027,
26056,
26048,
26074,
26044,
26047,
26034,
26050,
4650,
4643,
4593,
4642,
4753,
4727,
4745,
4766,
4775,
4779,
4782,
4786,
26156,
4726,
4720,
4721,
4729,
4730,
4723,
4724,
4732,
4731,
4735,
4744,
4738,
4739,
4747,
4748,
4864,
4881,
4854,
4879,
4883,
4859,
4877,
4873,
4869,
4871,
4866,
4856,
4861,
4885,
4865,
4882,
4855,
4880,
4884,
4860,
4878,
4876,
4870,
4872,
4867,
4857,
4862,
4886,
4850,
4849,
4875,
23379,
4652,
4626,
4627,
4599,
4596,
4592,
4588,
4617,
4631,
4628,
4612,
4597,
4640,
4639,
4610,
4618,
4582,
4586,
4646,
4591,
4633,
4590,
4598,
4623,
4637,
4589,
4613,
4600,
4583,
4615,
4651,
4648,
4653,
4604,
4622,
4621,
4645,
4624,
4635,
4636,
4607,
4611,
4606,
4585,
4581,
4616,
4605,
4649,
4632,
4741,
4742,
4750,
4749,
4756,
4765,
4759,
4760,
4768,
4769,
4762,
4763,
4771,
4770,
4774,
26941,
26951,
26944,
26947,
26943,
26939,
26940,
26946,
26948,
26949,
26950,
26900,
18575,
18648,
18649,
9561,
4847,
4845,
4843,
4846,
4844,
4827,
4825,
4823,
4826,
4824,
4803,
4801,
4799,
4802,
4800,
4797,
4795,
4793,
4796,
4794,
4815,
4813,
4811,
4814,
4812,
4833,
4831,
4829,
4832,
4830,
4821,
4819,
4817,
4820,
4818,
4842,
4840,
4841,
4809,
4807,
4805,
4808,
4806,
4838,
4836,
4837,
4835,
-1,
18683,
18682,
18684,
18686,
18665,
18664,
18718,
18650,
18651,
18695,
18694,
18483,
18482,
18481,
18582,
18583,
18580,
18579,
18490,
18578,
18475,
18478,
18477,
18476,
18585,
18586,
18485,
18486,
18499,
18488,
18489,
18658,
18657,
18661,
18655,
18654,
18626,
18630,
18627,
18715,
18634,
18638,
18572,
18513,
18512,
18674,
18519,
18517,
18518,
18678,
18560,
18559,
18675,
18558,
18570,
18508,
18507,
18569,
18506,
18509,
18679,
18522,
18677,
18565,
18521,
18563,
18564,
18432,
18431,
18435,
18433,
18434,
18447,
18444,
18445,
18453,
18454,
18455,
18707,
18706,
18708,
18593,
18594,
18601,
18600,
18604,
18603,
18555,
26935,
26936,
26913,
26915,
26924,
26927,
26919,
26921,
26930,
26933,
26917,
26932,
26912,
26916,
26925,
26928,
26920,
26922,
26931,
26934,
26905,
26910,
26908,
26909,
26911,
18567,
18625,
18681,
18673,
18693,
18531,
18621,
18623,
18624,
18670,
18647,
18645,
18644,
18646,
18612,
18514,
18633,
18428,
18429,
18479,
18501,
18460,
18590,
18615,
18500,
18530,
18640,
18427,
18426,
18467,
18498,
18573,
18497,
18466,
18589,
18716,
18425,
18465,
18628,
18495,
18713,
18639,
18424,
18448,
18607,
18469,
18450,
18609,
18441,
18474,
18451,
18610,
18442,
18472,
18438,
18439,
18510,
18494,
18463,
18588,
18596,
18597,
18598,
18525,
18637,
18423,
18462,
18524,
18636,
18422,
18458,
18492,
18459,
18523,
18635,
18421,
18456,
18491,
18457,
18502,
18440,
18685,
18676,
18618,
18617,
18619,
18611,
18631,
18587,
18571,
18566,
18663,
18496,
18473,
18493,
18702,
18701,
18699,
18700,
18461,
18446,
18464,
18529,
18528,
18527,
18526,
18660,
18659,
18554,
18717,
18687,
26899,
26874,
26880,
26888,
26891,
26883,
26885,
26894,
26897,
26881,
26896,
26873,
26879,
26889,
26892,
26884,
26886,
26895,
26898,
26859,
26870,
26862,
26863,
26868,
26869,
26865,
26866,
26872,
26871,
26877,
26878,
18584,
]

_charnames_19904 = [
20778,
20789,
20803,
20865,
20858,
20846,
20784,
20867,
20819,
20795,
20837,
20821,
20864,
20812,
20861,
20868,
20863,
20857,
20853,
20845,
20850,
20815,
20822,
20831,
20825,
20814,
20860,
20813,
20785,
20779,
20827,
20804,
20832,
20811,
20836,
20805,
20794,
20841,
20842,
20799,
20800,
20828,
20849,
20847,
20816,
20835,
20840,
20787,
20833,
20780,
20783,
20791,
20798,
20790,
20855,
20788,
20793,
20792,
20802,
20866,
20826,
20820,
20854,
20851,
]

_charnames_40960 = [
15224,
15223,
15218,
15225,
15221,
15220,
15219,
15222,
15232,
15231,
15230,
15233,
15235,
15234,
15236,
15228,
15227,
15226,
15229,
15238,
15237,
15204,
14586,
14585,
14580,
14587,
14583,
14582,
14581,
14584,
14600,
14599,
14598,
14601,
14573,
14572,
14574,
14596,
14595,
14594,
14597,
14603,
14602,
14604,
14578,
14577,
14571,
14579,
14576,
14575,
14592,
14591,
14588,
14593,
14590,
14589,
15028,
15027,
15023,
15029,
15025,
15024,
15026,
15042,
15041,
15040,
15043,
15016,
15015,
15017,
15038,
15037,
15036,
15039,
15021,
15020,
15014,
15022,
15019,
15018,
15034,
15033,
15030,
15035,
15032,
15031,
14554,
14553,
14548,
14555,
14551,
14550,
14549,
14552,
14566,
14565,
14564,
14567,
14541,
14540,
14542,
14562,
14561,
14560,
14563,
14569,
14568,
14570,
14546,
14545,
14539,
14547,
14544,
14543,
14558,
14557,
14556,
14559,
14063,
14062,
14058,
14064,
14060,
14059,
14061,
14083,
14082,
14081,
14084,
14079,
14078,
14077,
14080,
14075,
14074,
14071,
14076,
14073,
14072,
14069,
14068,
14065,
14070,
14067,
14066,
14272,
14271,
14267,
14273,
14269,
14268,
14270,
14285,
14284,
14283,
14286,
14260,
14259,
14261,
14281,
14280,
14279,
14282,
14265,
14264,
14258,
14266,
14263,
14262,
14277,
14274,
14278,
14276,
14275,
14767,
14766,
14762,
14768,
14764,
14763,
14765,
14779,
14778,
14777,
14780,
14755,
14754,
14753,
14756,
14775,
14774,
14773,
14776,
14782,
14781,
14760,
14759,
14752,
14761,
14758,
14757,
14771,
14770,
14769,
14772,
15173,
15172,
15171,
15174,
15177,
15176,
15175,
15178,
15180,
15179,
15181,
15165,
15164,
15161,
15166,
15163,
15162,
15169,
15168,
15167,
15170,
14988,
14987,
14982,
14989,
14985,
14984,
14983,
14986,
15008,
15007,
15006,
15009,
15004,
15003,
15002,
15005,
15011,
15012,
15000,
14999,
14996,
15001,
14998,
14997,
14994,
14993,
14990,
14995,
14992,
14991,
14880,
14879,
14875,
14881,
14877,
14876,
14878,
14888,
14887,
14886,
14889,
14871,
14870,
14884,
14883,
14882,
14885,
14891,
14890,
14892,
14873,
14872,
14867,
14874,
14869,
14868,
15089,
15088,
15084,
15090,
15086,
15085,
15087,
15097,
15096,
15095,
15098,
15077,
15076,
15075,
15078,
15093,
15092,
15091,
15094,
15100,
15099,
15101,
15082,
15081,
15074,
15083,
15080,
15079,
14854,
14853,
14849,
14855,
14851,
14850,
14852,
14862,
14861,
14860,
14863,
14842,
14841,
14843,
14858,
14857,
14856,
14859,
14865,
14864,
14866,
14847,
14846,
14840,
14848,
14845,
14844,
14146,
14145,
14142,
14147,
14144,
14143,
14154,
14153,
14152,
14155,
14150,
14149,
14148,
14151,
14157,
14156,
14158,
14140,
14139,
14136,
14141,
14138,
14137,
14318,
14317,
14312,
14319,
14315,
14314,
14313,
14316,
14322,
14321,
14320,
14323,
14326,
14325,
14330,
14329,
14331,
14333,
14332,
14334,
14327,
14211,
14210,
14206,
14212,
14208,
14207,
14209,
14221,
14220,
14222,
14199,
14198,
14200,
14215,
14214,
14213,
14216,
14218,
14217,
14219,
14204,
14203,
14197,
14205,
14202,
14201,
14239,
14238,
14234,
14240,
14236,
14235,
14237,
14249,
14248,
14247,
14250,
14227,
14226,
14228,
14252,
14251,
14253,
14255,
14254,
14256,
14232,
14231,
14225,
14233,
14230,
14229,
14245,
14244,
14241,
14246,
14243,
14242,
14962,
14961,
14956,
14963,
14959,
14958,
14957,
14960,
14976,
14975,
14974,
14977,
14949,
14948,
14947,
14950,
14972,
14971,
14970,
14973,
14979,
14978,
14980,
14954,
14953,
14946,
14955,
14952,
14951,
14968,
14967,
14964,
14969,
14966,
14965,
14714,
14713,
14708,
14715,
14711,
14710,
14709,
14712,
14726,
14725,
14724,
14727,
14701,
14700,
14699,
14702,
14718,
14717,
14716,
14719,
14722,
14721,
14720,
14723,
14706,
14705,
14698,
14707,
14704,
14703,
15146,
15145,
15141,
15147,
15143,
15142,
15144,
15158,
15157,
15156,
15159,
15134,
15133,
15135,
15150,
15149,
15148,
15151,
15154,
15153,
15152,
15155,
15139,
15138,
15132,
15140,
15137,
15136,
14685,
14684,
14680,
14682,
14681,
14683,
14696,
14695,
14694,
14697,
14673,
14672,
14671,
14674,
14688,
14687,
14686,
14689,
14692,
14691,
14690,
14693,
14678,
14677,
14670,
14679,
14676,
14675,
14751,
14750,
14745,
14744,
14743,
14746,
14732,
14731,
14733,
14741,
14740,
14739,
14742,
14748,
14747,
14749,
14737,
14736,
14730,
14738,
14735,
14734,
14294,
14293,
14288,
14295,
14291,
14290,
14289,
14292,
14306,
14305,
14304,
14307,
14298,
14297,
14296,
14299,
14302,
14301,
14300,
14303,
14309,
14308,
14310,
14192,
14191,
14193,
14186,
14185,
14184,
14187,
14190,
14189,
14188,
14182,
14181,
14180,
14183,
14195,
14194,
14196,
14350,
14349,
14348,
14345,
14344,
14343,
14346,
14337,
14336,
14335,
14338,
14341,
14340,
14339,
14342,
14352,
14351,
14353,
15210,
15209,
15208,
15211,
15206,
15205,
15207,
15213,
15212,
15214,
15216,
15215,
15217,
14427,
14426,
14422,
14428,
14424,
14423,
14425,
14441,
14440,
14439,
14442,
14415,
14414,
14416,
14437,
14436,
14435,
14438,
14444,
14443,
14445,
14420,
14419,
14413,
14421,
14418,
14417,
14433,
14432,
14429,
14434,
14431,
14430,
14649,
14648,
14643,
14650,
14646,
14645,
14644,
14647,
14663,
14662,
14661,
14664,
14636,
14635,
14637,
14659,
14658,
14657,
14660,
14666,
14665,
14667,
14641,
14640,
14634,
14642,
14639,
14638,
14655,
14654,
14651,
14656,
14653,
14652,
14362,
14361,
14356,
14363,
14359,
14358,
14357,
14360,
14377,
14376,
14375,
14378,
14380,
14379,
14381,
14383,
14382,
14384,
14373,
14370,
14374,
14372,
14371,
14368,
14367,
14364,
14369,
14366,
14365,
14040,
14039,
14035,
14041,
14037,
14036,
14038,
14050,
14049,
14048,
14051,
14032,
14031,
14053,
14054,
14056,
14055,
14033,
14028,
14034,
14030,
14029,
14046,
14045,
14042,
14047,
14044,
14043,
14518,
14517,
14513,
14519,
14515,
14514,
14516,
14532,
14531,
14530,
14533,
14506,
14505,
14507,
14528,
14527,
14526,
14529,
14535,
14534,
14536,
14511,
14510,
14504,
14512,
14509,
14508,
14524,
14523,
14520,
14525,
14522,
14521,
14453,
14452,
14448,
14454,
14450,
14449,
14451,
14471,
14470,
14469,
14472,
14467,
14466,
14465,
14468,
14474,
14473,
14475,
14463,
14462,
14461,
14464,
14459,
14458,
14455,
14460,
14457,
14456,
14411,
14410,
14409,
14412,
14388,
14387,
14389,
14403,
14402,
14401,
14404,
14407,
14406,
14405,
14408,
14393,
14392,
14386,
14394,
14391,
14390,
14399,
14398,
14395,
14400,
14397,
14396,
14632,
14631,
14630,
14633,
14610,
14609,
14608,
14611,
14624,
14623,
14622,
14625,
14628,
14627,
14626,
14629,
14614,
14607,
14615,
14613,
14612,
14620,
14619,
14616,
14621,
14618,
14617,
14918,
14917,
14899,
14898,
14911,
14910,
14909,
14912,
14915,
14914,
14913,
14916,
14901,
14900,
14895,
14902,
14897,
14896,
14907,
14906,
14903,
14908,
14905,
14904,
14130,
14129,
14128,
14131,
14133,
14132,
14134,
14126,
14125,
14124,
14127,
14122,
14121,
14118,
14123,
14120,
14119,
14116,
14115,
14112,
14117,
14114,
14113,
14502,
14501,
14500,
14503,
14479,
14478,
14480,
14494,
14493,
14492,
14495,
14498,
14497,
14496,
14499,
14484,
14483,
14477,
14485,
14482,
14481,
14490,
14489,
14486,
14491,
14488,
14487,
14940,
14939,
14938,
14941,
14921,
14920,
14922,
14936,
14935,
14934,
14937,
14943,
14942,
14944,
14926,
14925,
14919,
14927,
14924,
14923,
14932,
14931,
14928,
14933,
14930,
14929,
14826,
14825,
14820,
14827,
14823,
14822,
14821,
14824,
14813,
14812,
14811,
14814,
14836,
14835,
14834,
14837,
14818,
14817,
14810,
14819,
14816,
14815,
14832,
14831,
14828,
14833,
14830,
14829,
15119,
15118,
15113,
15120,
15116,
15115,
15114,
15117,
15106,
15105,
15104,
15107,
15129,
15128,
15127,
15130,
15111,
15110,
15103,
15112,
15109,
15108,
15125,
15124,
15121,
15126,
15123,
15122,
14800,
14799,
14794,
14801,
14797,
14796,
14795,
14798,
14787,
14786,
14788,
14808,
14807,
14806,
14809,
14792,
14791,
14785,
14793,
14790,
14789,
14804,
14803,
14802,
14805,
14092,
14091,
14086,
14093,
14089,
14088,
14087,
14090,
14098,
14097,
14109,
14108,
14107,
14110,
14099,
14094,
14100,
14096,
14095,
14105,
14104,
14101,
14106,
14103,
14102,
14166,
14165,
14160,
14167,
14163,
14162,
14161,
14164,
14170,
14169,
14171,
14177,
14176,
14175,
14178,
14173,
14172,
14168,
14174,
15189,
15188,
15183,
15190,
15186,
15185,
15184,
15187,
15202,
15201,
15199,
15198,
15197,
15200,
15195,
15194,
15191,
15196,
15193,
15192,
15061,
15060,
15055,
15062,
15058,
15057,
15056,
15059,
15048,
15047,
15046,
15049,
15071,
15070,
15069,
15072,
15053,
15052,
15045,
15054,
15051,
15050,
15067,
15066,
15063,
15068,
15065,
15064,
-1,
-1,
-1,
15315,
15287,
15306,
15271,
15243,
15260,
15264,
15266,
15304,
15284,
15289,
15313,
15303,
15291,
15301,
15282,
15298,
15267,
15250,
15242,
15310,
15312,
15263,
15270,
15297,
15316,
15277,
15252,
15300,
15285,
15292,
15294,
15256,
15295,
15253,
15279,
15272,
15276,
15265,
15278,
15314,
15309,
15257,
15288,
15241,
15244,
15245,
15283,
15259,
15249,
15258,
15246,
15251,
15273,
15307,
]

_charnames_42192 = [
9622,
9589,
9588,
9608,
9577,
9576,
9603,
9597,
9596,
9619,
9611,
9610,
9607,
9575,
9574,
9617,
9594,
9618,
9586,
9582,
9583,
9593,
9600,
9615,
9599,
9621,
9616,
9585,
9614,
9602,
9612,
9613,
9604,
9605,
9620,
9590,
9578,
9580,
9579,
9591,
9567,
9572,
9570,
9571,
9568,
9569,
9625,
9624,
23685,
23686,
23608,
23545,
23546,
23652,
23591,
23598,
23450,
23489,
23442,
23511,
23668,
23636,
23566,
23559,
23474,
23467,
23618,
23644,
23481,
23410,
23582,
23575,
23535,
23528,
23676,
23660,
23426,
23628,
23499,
23391,
23517,
23457,
23433,
23418,
23690,
23691,
23611,
23612,
23550,
23551,
23654,
23593,
23600,
23452,
23495,
23444,
23513,
23670,
23638,
23568,
23561,
23476,
23469,
23622,
23646,
23483,
23412,
23584,
23577,
23537,
23530,
23678,
23662,
23428,
23630,
23503,
23395,
23521,
23459,
23435,
23420,
23692,
23693,
23399,
23613,
23614,
23552,
23553,
23655,
23594,
23601,
23453,
23492,
23493,
23445,
23514,
23671,
23639,
23569,
23562,
23477,
23470,
23623,
23647,
23484,
23413,
23585,
23578,
23538,
23531,
23679,
23663,
23429,
23631,
23500,
23501,
23396,
23522,
23460,
23436,
23421,
23681,
23682,
23604,
23541,
23542,
23650,
23589,
23596,
23448,
23491,
23440,
23507,
23666,
23634,
23564,
23557,
23472,
23465,
23620,
23642,
23479,
23408,
23580,
23573,
23533,
23526,
23674,
23658,
23424,
23626,
23497,
23393,
23519,
23455,
23431,
23416,
23688,
23689,
23609,
23610,
23548,
23549,
23653,
23592,
23599,
23451,
23494,
23443,
23512,
23669,
23637,
23567,
23560,
23475,
23468,
23621,
23645,
23482,
23411,
23583,
23576,
23536,
23529,
23677,
23661,
23427,
23629,
23502,
23394,
23520,
23458,
23434,
23419,
23680,
23683,
23397,
23603,
23605,
23540,
23543,
23649,
23588,
23595,
23447,
23490,
23439,
23506,
23508,
23665,
23633,
23563,
23556,
23471,
23464,
23619,
23641,
23478,
23401,
23579,
23572,
23532,
23525,
23673,
23657,
23423,
23625,
23496,
23392,
23518,
23454,
23430,
23415,
23684,
23687,
23398,
23606,
23607,
23544,
23547,
23651,
23590,
23597,
23449,
23487,
23488,
23441,
23509,
23510,
23667,
23635,
23565,
23558,
23473,
23466,
23616,
23643,
23480,
23409,
23581,
23574,
23534,
23527,
23675,
23659,
23425,
23627,
23498,
23389,
23390,
23515,
23516,
23456,
23432,
23417,
23387,
23617,
23729,
23728,
23727,
23406,
23405,
23403,
23708,
23706,
23697,
23710,
23712,
23709,
23698,
23703,
23701,
23705,
23696,
23702,
23711,
23723,
23724,
23715,
23716,
23721,
23722,
23718,
23719,
23726,
23725,
23404,
23407,
]

_charnames_42560 = [
4381,
4152,
4359,
4130,
4465,
4236,
4324,
4095,
4364,
4135,
4487,
4259,
4414,
4185,
4485,
4257,
4386,
4157,
4318,
4089,
4464,
4235,
4323,
4094,
4459,
4230,
4415,
4186,
4321,
4092,
4391,
4162,
-1,
-1,
4350,
4121,
4348,
4119,
4347,
4118,
4488,
4260,
4411,
4182,
4366,
4137,
4501,
3468,
3464,
3467,
3463,
19780,
]

_charnames_42620 = [
3470,
3457,
4504,
4503,
4365,
4136,
4361,
4132,
4376,
4147,
4460,
4231,
4360,
4131,
4401,
4172,
4403,
4174,
4395,
4166,
4396,
4167,
4404,
4175,
4451,
4222,
4341,
4112,
]

_charnames_42656 = [
16239,
16168,
16235,
16165,
16238,
16194,
16214,
16236,
16151,
16237,
16222,
16208,
16196,
16197,
16221,
16172,
16215,
16154,
16141,
16169,
16186,
16176,
16184,
16187,
16185,
16188,
16164,
16162,
16147,
16146,
16139,
16230,
16182,
16229,
16231,
16152,
16161,
16205,
16140,
16150,
16202,
16233,
16206,
16226,
16198,
16218,
16178,
16153,
16192,
16199,
16163,
16143,
16144,
16145,
16183,
16203,
16224,
16225,
16234,
16155,
16220,
16207,
16219,
16157,
16174,
16193,
16171,
16179,
16216,
16167,
16177,
16175,
16211,
16166,
16212,
16149,
16189,
16227,
16158,
16159,
16244,
16243,
16249,
16250,
16246,
16245,
16247,
16248,
]

_charnames_42752 = [
6663,
6668,
6660,
6665,
6662,
6667,
6661,
6666,
6729,
6766,
6741,
6685,
6723,
6730,
6767,
6742,
6686,
6724,
6732,
6769,
6744,
6682,
6726,
6754,
6755,
6756,
6701,
6707,
6710,
6709,
6708,
6697,
6627,
6626,
8645,
7962,
8646,
7963,
8887,
8280,
8723,
7842,
8724,
7844,
8914,
8301,
8915,
8302,
9060,
9053,
8602,
8019,
8599,
8018,
8598,
8017,
8595,
8012,
8596,
8013,
8597,
8016,
8796,
8133,
8939,
8348,
8937,
8346,
8940,
8349,
8988,
8384,
8815,
8160,
8541,
7891,
8540,
7890,
8550,
7906,
8973,
8404,
8976,
8409,
8974,
8405,
9005,
8442,
9006,
8443,
8793,
8126,
8797,
8137,
8963,
8391,
8966,
8397,
8967,
8398,
8721,
7839,
8722,
7840,
8968,
8399,
8642,
7959,
8755,
8205,
8916,
8303,
6775,
8238,
8169,
8425,
8262,
8136,
9026,
7810,
8067,
8754,
8202,
8753,
8201,
8752,
8715,
7800,
8714,
7805,
8751,
8199,
8750,
8198,
8749,
8197,
6699,
6674,
6629,
8775,
8102,
]

_charnames_43003 = [
9091,
9090,
9093,
9094,
9095,
18946,
18943,
18960,
18937,
18945,
18939,
18959,
18923,
18924,
18929,
18930,
18961,
18932,
18933,
18926,
18927,
18906,
18907,
18912,
18913,
18908,
18909,
18914,
18915,
18940,
18920,
18921,
18935,
18936,
18941,
18918,
18942,
18917,
18938,
18944,
18952,
18950,
18948,
18951,
18949,
18957,
18956,
18955,
18954,
-1,
-1,
-1,
-1,
26737,
26738,
26742,
26736,
26739,
26741,
26744,
26747,
26746,
26745,
-1,
-1,
-1,
-1,
-1,
-1,
26208,
26207,
26211,
26180,
26191,
26193,
26223,
26178,
26176,
26175,
26189,
26181,
26205,
26204,
26227,
26221,
26174,
26173,
26187,
26216,
26198,
26199,
26183,
26214,
26218,
26222,
26184,
26185,
26225,
26194,
26224,
26217,
26212,
26220,
26219,
26215,
26226,
26210,
26213,
26232,
26231,
26171,
26170,
26188,
26179,
26196,
26201,
26202,
26195,
26233,
26234,
26192,
26235,
26239,
26237,
26238,
]

_charnames_43136 = [
19126,
19124,
19046,
19049,
19070,
19071,
19054,
19055,
19024,
19025,
19026,
19027,
19075,
19076,
19048,
19059,
19060,
19047,
19066,
19065,
19074,
19073,
19038,
19079,
19078,
19069,
19068,
19036,
19032,
19031,
19043,
19042,
19037,
19034,
19033,
19045,
19044,
19039,
19058,
19057,
19082,
19081,
19085,
19083,
19084,
19063,
19028,
19052,
19051,
19053,
19086,
19062,
19127,
19096,
19101,
19102,
19097,
19098,
19089,
19090,
19091,
19092,
19103,
19104,
19095,
19099,
19100,
19094,
19125,
]

_charnames_43214 = [
19121,
19120,
19116,
19117,
19108,
19109,
19114,
19115,
19111,
19112,
19119,
19118,
-1,
-1,
-1,
-1,
-1,
-1,
3608,
3609,
3600,
3601,
3606,
3607,
3603,
3604,
3611,
3610,
3619,
3614,
3618,
3617,
3616,
3615,
3613,
3620,
24553,
24545,
24558,
24543,
24544,
24546,
24554,
24581,
24587,
24586,
-1,
-1,
-1,
-1,
23052,
23053,
23044,
23045,
23050,
23051,
23047,
23048,
23055,
23054,
23025,
23024,
23037,
23009,
23016,
23015,
23029,
23008,
23013,
23027,
23010,
23019,
23018,
23034,
23038,
23040,
23033,
23030,
23035,
23031,
23012,
23028,
23032,
23039,
23041,
23022,
23036,
23021,
23058,
23059,
23057,
23060,
23061,
23065,
23063,
23064,
23068,
23067,
25819,
25822,
25806,
25814,
25823,
25808,
25817,
25825,
25811,
25824,
25820,
25803,
25815,
25816,
25818,
25812,
25813,
25821,
25810,
25805,
25807,
25802,
25826,
25837,
25835,
25829,
25834,
25836,
25833,
25830,
25831,
25841,
25840,
25842,
25843,
25838,
]

_charnames_43359 = [
25844,
20240,
20239,
20237,
20242,
20208,
20205,
20211,
20203,
20214,
20212,
20204,
20210,
20206,
20216,
20209,
20268,
20265,
20266,
20151,
20161,
20167,
20133,
20230,
20233,
20135,
20131,
20171,
20273,
20136,
-1,
-1,
-1,
27836,
27833,
27837,
27835,
27774,
27763,
27761,
27762,
27778,
27756,
27733,
27734,
27783,
27775,
27779,
27757,
27759,
27760,
27768,
27769,
27732,
27770,
27771,
27766,
27736,
27767,
27735,
27740,
27741,
27745,
27746,
27738,
27742,
27743,
27747,
27748,
27737,
27753,
27755,
27772,
27773,
27780,
27776,
27764,
27765,
27781,
27777,
27751,
27752,
27749,
27782,
27834,
27823,
27825,
27826,
27827,
27828,
27829,
27824,
27831,
27830,
27840,
27839,
27841,
27805,
27784,
27843,
27795,
27801,
27790,
27799,
27798,
27791,
27789,
27793,
27794,
27797,
27842,
-1,
27804,
27816,
27817,
27808,
27809,
27814,
27815,
27811,
27812,
27819,
27818,
-1,
-1,
-1,
-1,
27800,
27802,
]

_charnames_43520 = [
5119,
5127,
5123,
5129,
5120,
5125,
5109,
5108,
5115,
5114,
5082,
5083,
5118,
5117,
5112,
5111,
5078,
5080,
5079,
5100,
5099,
5093,
5091,
5084,
5085,
5092,
5089,
5087,
5088,
5097,
5095,
5105,
5106,
5096,
5121,
5124,
5126,
5122,
5102,
5103,
5128,
5134,
5139,
5140,
5141,
5135,
5138,
5137,
5133,
5132,
5136,
5161,
5163,
5164,
5162,
]

_charnames_43584 = [
5073,
5074,
5066,
5158,
5075,
5068,
5065,
5071,
5067,
5070,
5072,
5069,
5159,
5160,
-1,
-1,
5152,
5153,
5144,
5145,
5150,
5151,
5147,
5148,
5155,
5154,
-1,
-1,
5170,
5168,
5167,
5169,
7395,
7390,
7389,
7384,
7383,
7380,
7378,
7377,
7374,
7373,
7375,
7381,
7393,
7387,
7386,
7396,
7625,
7392,
7391,
7394,
7497,
7496,
7498,
7552,
7551,
7550,
7469,
7530,
-1,
-1,
-1,
-1,
17057,
17088,
17055,
17086,
17056,
17087,
17075,
17106,
17052,
17083,
17065,
17096,
17066,
17097,
17069,
17100,
17050,
17081,
17077,
17108,
17059,
17090,
17060,
17091,
17051,
17082,
17078,
17109,
17062,
17093,
17063,
17094,
17076,
17107,
17072,
17103,
17067,
17098,
17070,
17101,
17073,
17104,
17068,
17099,
17074,
17105,
17071,
17102,
17139,
17116,
17121,
17118,
17117,
17124,
17123,
17138,
17122,
17119,
17120,
17113,
17112,
17114,
17115,
17136,
17135,
17133,
17134,
]

_charnames_43968 = [
7644,
7668,
7649,
7647,
7640,
7633,
7671,
7636,
7646,
7631,
7638,
7666,
7665,
7670,
7667,
7654,
7642,
7672,
7657,
7653,
7669,
7664,
7652,
7660,
7658,
7661,
7663,
7645,
7650,
7648,
7641,
7634,
7637,
7632,
7655,
7692,
7694,
7696,
7689,
7691,
7690,
7695,
7693,
7697,
7673,
7698,
-1,
-1,
7684,
7685,
7676,
7677,
7682,
7683,
7679,
7680,
7687,
7686,
]

_charnames_55216 = [
20066,
20070,
20012,
20013,
20016,
20091,
20095,
20002,
20004,
20056,
20053,
20051,
20055,
20036,
20035,
20038,
20037,
20042,
20040,
20039,
20046,
20082,
20078,
-1,
-1,
-1,
-1,
19963,
19961,
19855,
19856,
19951,
19944,
19945,
19947,
19948,
19949,
19845,
19826,
19858,
19833,
19816,
19818,
19837,
19836,
19920,
19938,
19928,
19861,
19932,
19935,
19892,
19888,
19894,
19859,
19886,
19890,
19891,
19880,
19875,
19854,
19853,
19872,
19877,
19878,
19869,
19881,
19903,
19904,
19972,
19973,
19991,
19990,
19864,
19899,
19898,
]

_charnames_63744 = [
856,
855,
854,
853,
852,
851,
850,
849,
848,
847,
846,
845,
844,
843,
842,
841,
839,
838,
837,
836,
835,
834,
833,
832,
831,
830,
829,
828,
827,
826,
825,
824,
822,
821,
820,
819,
818,
817,
816,
815,
814,
813,
812,
811,
810,
809,
808,
807,
805,
804,
803,
802,
801,
800,
799,
798,
797,
796,
795,
794,
793,
792,
791,
790,
788,
787,
786,
785,
784,
783,
782,
781,
780,
779,
778,
777,
776,
775,
774,
773,
771,
770,
769,
768,
767,
766,
765,
764,
763,
762,
761,
760,
759,
758,
757,
756,
754,
753,
752,
751,
750,
749,
748,
747,
746,
745,
744,
743,
742,
741,
740,
739,
737,
736,
735,
734,
733,
732,
731,
730,
729,
728,
727,
726,
725,
724,
723,
722,
720,
719,
718,
717,
716,
715,
714,
713,
712,
711,
710,
709,
708,
707,
706,
705,
703,
702,
701,
700,
699,
698,
697,
696,
695,
694,
693,
692,
691,
690,
689,
688,
686,
685,
684,
683,
682,
681,
680,
679,
678,
677,
676,
675,
674,
673,
672,
671,
669,
668,
667,
666,
665,
664,
663,
662,
661,
660,
659,
658,
657,
656,
655,
654,
652,
651,
650,
649,
648,
647,
646,
645,
644,
643,
642,
641,
640,
639,
638,
637,
635,
634,
633,
632,
631,
630,
629,
628,
627,
626,
625,
624,
623,
622,
621,
620,
618,
617,
616,
615,
614,
613,
612,
611,
610,
609,
608,
607,
606,
605,
604,
603,
601,
600,
599,
598,
597,
596,
595,
594,
593,
592,
591,
590,
589,
588,
587,
586,
1044,
1043,
1042,
1041,
1040,
1039,
1038,
1037,
1036,
1035,
1034,
1033,
1032,
1031,
1030,
1029,
1027,
1026,
1025,
1024,
1023,
1022,
1021,
1020,
1019,
1018,
1017,
1016,
1015,
1014,
1013,
1012,
1074,
1073,
1072,
1071,
1070,
1069,
1068,
1067,
1066,
1065,
1064,
1063,
1062,
1061,
-1,
-1,
1010,
1009,
1008,
1007,
1006,
1005,
1004,
1003,
1002,
1001,
1000,
999,
998,
997,
996,
995,
993,
992,
991,
990,
989,
988,
987,
986,
985,
984,
983,
982,
981,
980,
979,
978,
976,
975,
974,
973,
972,
971,
970,
969,
968,
967,
966,
965,
964,
963,
962,
961,
1059,
1058,
1057,
1056,
1055,
1054,
1053,
1052,
1051,
1050,
1049,
1048,
1047,
1046,
-1,
-1,
959,
958,
957,
956,
955,
954,
953,
952,
951,
950,
949,
948,
947,
946,
945,
944,
942,
941,
940,
939,
938,
937,
936,
935,
934,
933,
932,
931,
930,
929,
928,
927,
925,
924,
923,
922,
921,
920,
919,
918,
917,
916,
915,
914,
913,
912,
911,
910,
908,
907,
906,
905,
904,
903,
902,
901,
900,
899,
898,
897,
896,
895,
894,
893,
891,
890,
889,
888,
887,
886,
885,
884,
883,
882,
881,
880,
879,
878,
877,
876,
874,
873,
872,
871,
870,
869,
868,
867,
866,
865,
864,
863,
862,
861,
860,
859,
1085,
1084,
1083,
1082,
1081,
1080,
1079,
1078,
1077,
1076,
]

_charnames_64256 = [
8467,
8471,
8470,
8469,
8468,
8474,
8472,
]

_charnames_64275 = [
13626,
13628,
13627,
13629,
13625,
-1,
-1,
-1,
-1,
-1,
20647,
20760,
20689,
20636,
20606,
20605,
20603,
20602,
20601,
20604,
20600,
20599,
20635,
20616,
20615,
20613,
20612,
20632,
20631,
20633,
20667,
20681,
20683,
20663,
20652,
20669,
-1,
20642,
20648,
20623,
20660,
20679,
-1,
20677,
-1,
20675,
20618,
-1,
20621,
20656,
-1,
20640,
20673,
20671,
20610,
20644,
20651,
20666,
20659,
20655,
20691,
13000,
13001,
13244,
13247,
13245,
13246,
13335,
13338,
13336,
13337,
13237,
13240,
13238,
13239,
12832,
12835,
12833,
12834,
12809,
12812,
12810,
12811,
12838,
12841,
12839,
12840,
13369,
13372,
13370,
13371,
13329,
13332,
13330,
13331,
12962,
12965,
12963,
12964,
13106,
13109,
13107,
13108,
12823,
12827,
12824,
12826,
12817,
12820,
12818,
12819,
12957,
12958,
12948,
12949,
12968,
12969,
12953,
12954,
13386,
13387,
13214,
13215,
13035,
13038,
13036,
13037,
13291,
13294,
13292,
13293,
13306,
13309,
13307,
13308,
13093,
13096,
13094,
13095,
13082,
13083,
13208,
13211,
13209,
13210,
12883,
12884,
12868,
12872,
12869,
12871,
12876,
12879,
12877,
12878,
13173,
13174,
13168,
13169,
]

_charnames_64467 = [
13099,
13102,
13100,
13101,
13392,
13393,
13426,
13427,
13182,
13183,
13391,
13374,
13375,
13059,
13060,
13055,
13056,
13420,
13423,
13421,
13422,
13396,
13395,
12267,
12268,
12270,
12271,
12298,
12299,
12301,
12302,
12304,
12305,
12274,
12275,
12294,
12296,
12295,
12781,
12783,
12782,
13262,
13265,
13263,
13264,
12307,
12290,
12281,
12265,
12277,
12574,
12553,
12567,
12561,
12577,
12571,
12206,
12187,
12198,
12175,
12212,
12209,
12234,
12221,
12229,
12226,
12700,
12693,
12630,
12626,
12457,
12462,
12454,
12118,
12098,
12110,
12092,
12139,
12146,
12678,
12666,
12659,
12675,
12253,
12246,
12776,
12600,
12593,
12769,
12763,
12726,
12729,
12715,
12719,
12732,
12723,
12750,
12744,
12753,
12747,
12435,
12444,
12447,
12441,
12427,
12421,
12433,
12438,
12388,
12399,
12407,
12374,
12363,
12410,
12519,
12535,
12527,
12539,
12544,
12546,
12475,
12484,
12502,
12494,
12505,
12499,
12648,
12645,
12652,
12650,
12334,
12315,
12341,
12328,
12344,
12338,
12236,
12785,
12614,
12076,
12071,
12079,
12075,
12070,
12080,
12310,
12309,
12284,
12311,
12266,
12278,
12580,
12579,
12564,
12581,
12578,
12572,
12215,
12214,
12178,
12216,
12213,
12210,
12232,
12231,
12224,
12233,
12230,
12227,
12733,
12724,
12754,
12748,
12436,
12430,
12424,
12434,
12439,
12377,
12364,
12411,
12545,
12542,
12508,
12507,
12497,
12509,
12506,
12500,
12615,
12347,
12346,
12331,
12348,
12345,
12339,
12308,
12291,
12312,
12282,
12288,
12575,
12554,
12568,
12562,
12558,
12207,
12188,
12199,
12176,
12191,
12222,
12701,
12694,
12631,
12627,
12458,
12455,
12119,
12099,
12111,
12093,
12140,
12157,
12147,
12679,
12667,
12660,
12676,
12254,
12777,
12601,
12594,
12770,
12764,
12727,
12730,
12716,
12720,
12751,
12745,
12445,
12448,
12442,
12428,
12422,
12389,
12400,
12408,
12375,
12401,
12520,
12536,
12528,
12540,
12476,
12485,
12503,
12495,
12488,
12649,
12646,
12651,
12335,
12316,
12342,
12329,
12320,
12283,
12287,
12563,
12557,
12177,
12190,
12223,
12235,
12094,
12103,
12042,
12029,
12429,
12423,
12376,
12496,
12487,
12330,
12319,
12078,
12074,
12069,
12256,
12250,
12606,
12603,
12772,
12766,
12128,
12122,
12064,
12058,
12637,
12634,
12706,
12703,
12460,
12451,
12155,
12149,
12681,
12669,
12046,
12024,
12053,
12040,
12061,
12125,
12152,
12672,
12257,
12251,
12607,
12604,
12773,
12767,
12129,
12123,
12065,
12059,
12638,
12635,
12707,
12704,
12461,
12452,
12156,
12150,
12682,
12670,
12050,
12027,
12056,
12043,
12062,
12126,
12153,
12673,
12047,
12025,
12054,
12041,
12104,
12030,
12247,
12120,
12101,
12112,
12049,
12026,
12055,
12248,
12778,
12612,
12611,
25290,
25289,
]

_charnames_64848 = [
12203,
12184,
12183,
12185,
12195,
12171,
12172,
12170,
12689,
12688,
12623,
12624,
12100,
12115,
12116,
12089,
12088,
12090,
12086,
12085,
12136,
12135,
12144,
12021,
12020,
12048,
12038,
12037,
12035,
12034,
12664,
12657,
12656,
12242,
12241,
12244,
12243,
12598,
12589,
12588,
12591,
12760,
12759,
12761,
12713,
12712,
12740,
12742,
12395,
12396,
12397,
12384,
12385,
12405,
12404,
12371,
12370,
12533,
12532,
12531,
12517,
12515,
12525,
12524,
-1,
-1,
12516,
12643,
12642,
12481,
12482,
12468,
12467,
12473,
12491,
12492,
12325,
12324,
12569,
12202,
12204,
12194,
12196,
12169,
12173,
12690,
12698,
12691,
12108,
12137,
12022,
12663,
12386,
12372,
12317,
12336,
12326,
12541,
12741,
12480,
12739,
12394,
12590,
12419,
12470,
12523,
12381,
12418,
12382,
12471,
12697,
12632,
12514,
12721,
12555,
12417,
12597,
12143,
12107,
12472,
]

_charnames_65008 = [
12161,
12755,
12616,
12618,
12547,
12164,
12786,
12617,
12787,
12162,
12163,
12708,
25648,
12582,
-1,
-1,
23731,
23842,
23976,
23965,
23954,
23943,
23932,
23921,
23910,
23831,
23820,
23809,
23798,
23787,
23776,
23765,
26384,
26382,
26381,
26385,
26388,
26377,
26389,
26351,
26365,
26390,
-1,
-1,
-1,
-1,
-1,
-1,
3562,
3561,
3574,
3573,
3703,
3702,
3477,
]

_charnames_65072 = [
26387,
26379,
26378,
26362,
26386,
26358,
26372,
26354,
26368,
26356,
26370,
26360,
26374,
26359,
26373,
26361,
26375,
26355,
26369,
26352,
26366,
19750,
27589,
26357,
26371,
24859,
5204,
27706,
24287,
24860,
5205,
27704,
19664,
19685,
19688,
-1,
19682,
19665,
19683,
19653,
19655,
19669,
19645,
19670,
19646,
19668,
19644,
19684,
19680,
19679,
19676,
19686,
19671,
19687,
19654,
-1,
19647,
19689,
19677,
19663,
-1,
-1,
-1,
-1,
13495,
13512,
13503,
13513,
13518,
-1,
13493,
13492,
13506,
13505,
13521,
13520,
13485,
13484,
13480,
13479,
12915,
12990,
12991,
12986,
12987,
13315,
13316,
12982,
12983,
13155,
13158,
13156,
13157,
13006,
13007,
13230,
13233,
13231,
13232,
12795,
12797,
12803,
12805,
12804,
12798,
12846,
12849,
12847,
12848,
13380,
13383,
13381,
13382,
12910,
12913,
12911,
12912,
13064,
13067,
13065,
13066,
12936,
12937,
12852,
12853,
13203,
13204,
13363,
13364,
13124,
13127,
13125,
13126,
13141,
13145,
13142,
13144,
13134,
13137,
13135,
13136,
12941,
12945,
12942,
12944,
12857,
12861,
12858,
12860,
13357,
13360,
13358,
13359,
13018,
13021,
13019,
13020,
13298,
13302,
13299,
13301,
13278,
13281,
13279,
13280,
13403,
13406,
13404,
13405,
13048,
13051,
13049,
13050,
13349,
13352,
13350,
13351,
13413,
13416,
13414,
13415,
13085,
13088,
13086,
13087,
12887,
12890,
12888,
12889,
13323,
13324,
13004,
13005,
13176,
13179,
13177,
13178,
12360,
12361,
12357,
12358,
12354,
12355,
12365,
12366,
-1,
-1,
27906,
-1,
27320,
27311,
27314,
27283,
27302,
27306,
27305,
27264,
27288,
27304,
27301,
27295,
27327,
27328,
27308,
27279,
27280,
27271,
27272,
27277,
27278,
27274,
27275,
27282,
27281,
27296,
27309,
27266,
27321,
27317,
27312,
27294,
27259,
27258,
27257,
27256,
27255,
27254,
27253,
27252,
27251,
27250,
27249,
27248,
27247,
27246,
27245,
27244,
27243,
27242,
27241,
27240,
27239,
27238,
27237,
27236,
27235,
27234,
27263,
27290,
27287,
27297,
27267,
27318,
27232,
27231,
27230,
27229,
27228,
27227,
27226,
27225,
27224,
27223,
27222,
27221,
27220,
27219,
27218,
27217,
27216,
27215,
27214,
27213,
27212,
27211,
27210,
27209,
27208,
27207,
27265,
27324,
27289,
27325,
27262,
27286,
20583,
20581,
20578,
20584,
20509,
20500,
20453,
20451,
20448,
20452,
20450,
20447,
20445,
20446,
20449,
20510,
20506,
20504,
20502,
20505,
20503,
20488,
20486,
20484,
20487,
20485,
20458,
20456,
20454,
20457,
20455,
20470,
20468,
20466,
20469,
20467,
20464,
20462,
20460,
20463,
20461,
20494,
20492,
20490,
20493,
20491,
20482,
20480,
20478,
20481,
20479,
20498,
20496,
20497,
20476,
20474,
20472,
20475,
20473,
20501,
20459,
20507,
20508,
20575,
20554,
20536,
20555,
20549,
20552,
20551,
20561,
20533,
20513,
20521,
20520,
20516,
20519,
20518,
20517,
20522,
20573,
20546,
20535,
20547,
20538,
20534,
20566,
20568,
20537,
20569,
20556,
20562,
20548,
20574,
-1,
-1,
-1,
20570,
20571,
20526,
20527,
20559,
20557,
-1,
-1,
20525,
20524,
20563,
20542,
20543,
20564,
-1,
-1,
20529,
20572,
20541,
20540,
20544,
20528,
-1,
-1,
20558,
20530,
20565,
-1,
-1,
-1,
27298,
27300,
27315,
27326,
27329,
27322,
27323,
-1,
20587,
20580,
20586,
20577,
20588,
20589,
20585,
]

_charnames_65529 = [
27107,
27106,
27105,
25427,
25895,
-1,
-1,
9383,
9411,
9373,
9398,
9426,
9390,
9403,
9384,
9422,
9369,
9364,
9402,
-1,
9413,
9396,
9353,
9404,
9394,
9360,
9430,
9431,
9423,
9357,
9421,
9378,
9385,
9377,
9417,
9368,
9365,
9388,
9358,
9410,
9425,
9370,
9420,
9352,
9379,
9415,
-1,
9399,
9374,
9367,
9389,
9375,
9416,
9382,
9407,
9424,
9363,
9362,
9387,
9412,
9386,
9392,
9366,
9355,
9408,
9406,
-1,
9419,
9356,
-1,
9380,
9376,
9405,
9429,
9359,
9434,
9401,
9372,
9397,
9354,
9414,
9393,
9395,
9428,
9433,
-1,
-1,
9449,
9448,
9453,
9452,
9446,
9445,
9451,
9443,
9442,
9450,
9440,
9439,
9438,
9437,
]

_charnames_65664 = [
9227,
9226,
9225,
9212,
9211,
9210,
9224,
9223,
9221,
9220,
9218,
9217,
9215,
9214,
9277,
9276,
9275,
9274,
9273,
9461,
9460,
9281,
9280,
9279,
9458,
9457,
9271,
9270,
9269,
9268,
9267,
9257,
9256,
9255,
9254,
9253,
9462,
9252,
9251,
9250,
9238,
9237,
9236,
9235,
9234,
9233,
9232,
9231,
9230,
9229,
9248,
9247,
9246,
9245,
9244,
9243,
9242,
9241,
9240,
9265,
9264,
9263,
9262,
9261,
9260,
9259,
9284,
9283,
9314,
9313,
9311,
9310,
9309,
9308,
9307,
9306,
9304,
9303,
9302,
9301,
9300,
9299,
9463,
9298,
9297,
9295,
9294,
9293,
9292,
9291,
9290,
9289,
9288,
9287,
9348,
9338,
9337,
9336,
9335,
9334,
9333,
9332,
9331,
9330,
9329,
9327,
9326,
9325,
9324,
9323,
9322,
9321,
9320,
9319,
9318,
9345,
9344,
9343,
9342,
9341,
9340,
9346,
9347,
-1,
-1,
-1,
-1,
-1,
13884,
13885,
13891,
-1,
-1,
-1,
-1,
13871,
13816,
13823,
13846,
13853,
13832,
13838,
13865,
13859,
13829,
13820,
13827,
13850,
13857,
13833,
13839,
13866,
13860,
13874,
13819,
13826,
13849,
13856,
13837,
13843,
13870,
13864,
13873,
13818,
13825,
13848,
13855,
13836,
13842,
13869,
13863,
13830,
13821,
13828,
13851,
13858,
13834,
13840,
13867,
13861,
-1,
-1,
-1,
13882,
13879,
