#!/usr/bin/perl
#
# Generate the targets-meson.sgml file from targets-meson.txt
# Copyright (c) 2000-2025, PostgreSQL Global Development Group

use strict;
use warnings FATAL => 'all';

my $targets_meson_file = $ARGV[0];
open my $targets_meson, '<', $targets_meson_file or die;

print
  "<!-- autogenerated from doc/src/sgml/targets-meson.txt, do not edit -->\n";

# Find the start of each group of targets
while (<$targets_meson>)
{
	next if /^#/;

	if (/^(.*) Targets:$/)
	{
		my $targets = $1;
		my $targets_id = lc $targets;

		print qq(
<sect3 id="targets-meson-$targets_id">
 <title>$targets Targets</title>

 <variablelist>
);

		# Each target in the group
		while (<$targets_meson>)
		{
			next if /^#/;
			last if !/^\s+([^ ]+)\s+(.+)/;

			my $target = $1;
			my $desc = $2;
			my $target_id = $1;

			$target_id =~ s/\//-/g;

			print qq(
  <varlistentry id="meson-target-${target_id}">
    <term><option>${target}</option></term>
    <listitem>
     <para>
      ${desc}
     </para>
    </listitem>
  </varlistentry>
);
		}

		print qq(
 </variablelist>
</sect3>
);
	}
}

close $targets_meson;
