/*
 *                            COPYRIGHT
 *
 *  pcb-rnd, interactive printed circuit board design
 *  Copyright (C) 2018,2021 Tibor 'Igor2' Palinkas
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/pcb-rnd
 *    lead developer: http://repo.hu/projects/pcb-rnd/contact.html
 *    mailing list: pcb-rnd (at) list.repo.hu (send "subscribe")
 */

/* Preferences dialog, board tab */

#include <librnd/core/conf.h>
#include <librnd/plugins/lib_hid_common/dlg_pref.h>
#include "conf_core.h"
#include "stub_draw.h"

#define RND_EMPTY(a)           ((a) ? (a) : "")


void layersel_expose_cb(rnd_hid_attribute_t *attrib, rnd_hid_preview_t *prv, rnd_hid_gc_t gc, const rnd_hid_expose_ctx_t *e)
{
	pcb_stub_draw_csect(gc, e);
}

rnd_bool layersel_mouse_cb(rnd_hid_attribute_t *attrib, rnd_hid_preview_t *prv, rnd_hid_mouse_ev_t kind, rnd_coord_t x, rnd_coord_t y)
{
	return pcb_stub_draw_csect_mouse_ev(kind, x, y);
}

void layersel_free_cb(rnd_hid_attribute_t *attrib, void *user_ctx, void *hid_ctx)
{
}

void pcb_dlg_pref_layer_create(pref_ctx_t *ctx)
{
	rnd_box_t vbox = {0, 0, RND_MM_TO_COORD(150), RND_MM_TO_COORD(150)};

	RND_DAD_COMPFLAG(ctx->dlg, RND_HATF_EXPFILL);
	RND_DAD_BEGIN_VBOX(ctx->dlg);
		RND_DAD_COMPFLAG(ctx->dlg, RND_HATF_EXPFILL);
		RND_DAD_PREVIEW(ctx->dlg, layersel_expose_cb, layersel_mouse_cb, NULL, layersel_free_cb, &vbox, 200, 200, ctx);
			RND_DAD_COMPFLAG(ctx->dlg, RND_HATF_EXPFILL);
	RND_DAD_END(ctx->dlg);
}

static const rnd_pref_tab_hook_t pref_layer = {
	"Layers", RND_PREFTAB_AUTO_FREE_DATA,
	NULL, NULL,
	pcb_dlg_pref_layer_create,
	NULL, NULL
};

static void pcb_dlg_pref_layer_init(pref_ctx_t *ctx, int tab)
{
	PREF_INIT(ctx, &pref_layer);
}
#undef PREF_INIT_FUNC
#define PREF_INIT_FUNC pcb_dlg_pref_layer_init
