/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             avtparaDISOptions.C                              //
// ************************************************************************* //

#include <avtparaDISOptions.h>

#include <DBOptionsAttributes.h>
#include <DebugStream.h>

#include <cstdlib>
#include <cstring>

#include <string>
#include <vector>
using namespace std; 

// ****************************************************************************
//  Function: GetparaDISReadOptions
//
//  Purpose:
//      Creates the options for paraDIS readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: rcook -- generated by xml2avt
//  Creation:   Thu Mar 11 15:15:39 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetparaDISReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    // Allow user to set values by environment variables or by GUI.
    int useMNType = 0; 
    char *cp = getenv("PARADIS_USE_MN_MATERIALS"); 
    if (cp) {
      useMNType = atoi(cp); 
      debug1 << "PARADIS_USE_MN_MATERIALS is " << cp << " and useMNType is " << useMNType << endl; 
    }/*
       else {
      debug1 << "PARADIS_USE_MN_MATERIALS not found" << endl; 
    }
     */
    if (useMNType < 0) useMNType = 0; 
    if (useMNType > 1) useMNType = 1; 
    rv->SetEnum(PARADIS_MATERIAL_SET_CHOICE, useMNType); 
    
    vector<string> msetchoices; 
    msetchoices.push_back("Burgers type"); 
    msetchoices.push_back("MN type"); 
    rv->SetEnumStrings(PARADIS_MATERIAL_SET_CHOICE, msetchoices); 

    double threshold = -1.0; 
    cp = getenv("PARADIS_NN_ARM_THRESHOLD"); 
    if (cp) threshold = atof(cp); 
    rv->SetDouble(PARADIS_NN_ARM_THRESHOLD, threshold); 

    int debug=0;
    cp = getenv("PARADIS_VERBOSITY"); 
    if (cp) debug=atoi(cp); 
    debug1 << "paradis debug set to " << debug << endl;
    rv->SetInt(PARADIS_VERBOSITY, debug);
    
    cp = getenv("PARADIS_DEBUG_FILE");
    if (!cp) cp = (char*)"paradis_debug_output.log";
    rv->SetString(PARADIS_DEBUG_FILE, cp);
    
    debug = 0; 
    cp = getenv("PARADIS_ENABLE_DEBUG_OUTPUT"); 
    if (cp) debug=atoi(cp); 
    rv->SetBool(PARADIS_ENABLE_DEBUG_OUTPUT, debug); 
    
    return rv;

/* EXAMPLE OF OPTIONS
    rv->SetBool("Binary format", true);
    rv->SetBool("Big Endian", false);
    rv->SetEnum("Dimension", 1);
    vector<string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
}


// ****************************************************************************
//  Function: GetparaDISWriteOptions
//
//  Purpose:
//      Creates the options for paraDIS writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: rcook -- generated by xml2avt
//  Creation:   Thu Mar 11 15:15:39 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetparaDISWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
