/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.eventmodel;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLDeviceSensorNodeType;
import org.xj3d.core.eventmodel.DeviceFactory;
import org.xj3d.core.eventmodel.UserInputHandler;
import org.xj3d.device.ControllerDevice;
import org.xj3d.device.DeviceManager;
import org.xj3d.device.GamepadDevice;
import org.xj3d.device.GamepadState;
import org.xj3d.device.GenericHIDState;
import org.xj3d.device.InputDevice;
import org.xj3d.device.JoystickDevice;
import org.xj3d.device.JoystickState;
import org.xj3d.device.MidiDevice;
import org.xj3d.device.Tracker;
import org.xj3d.device.TrackerDevice;
import org.xj3d.device.TrackerState;
import org.xj3d.device.WheelDevice;
import org.xj3d.device.WheelState;

public class InputDeviceManager {
    private InputDevice[] devices;
    private TrackerState state;
    private ErrorReporter errorReporter;
    private TrackerDevice[] trackerDevices;
    private ControllerDevice[] controllerDevices;
    private MidiDevice[] midiDevices;
    private Tracker[] trackers;
    private GamepadState gamepadState;
    private JoystickState joystickState;
    private WheelState wheelState;
    private HashMap controllerMap;
    private DeviceFactory deviceFactory;
    private boolean initialized;
    private boolean activateSensors;

    public InputDeviceManager(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
        this.initialized = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.gamepadState = new GamepadState();
        this.joystickState = new JoystickState();
        this.wheelState = new WheelState();
        this.controllerMap = new HashMap();
        this.state = new TrackerState();
    }

    public void reinitialize(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
        this.initialize();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void initialize() {
        int n;
        int n2;
        DeviceManager[] deviceManagerArray = this.deviceFactory.getDeviceManagers();
        int n3 = deviceManagerArray.length;
        ArrayList<InputDevice> arrayList = new ArrayList<InputDevice>();
        ArrayList<InputDevice> arrayList2 = new ArrayList<InputDevice>();
        ArrayList<InputDevice> arrayList3 = new ArrayList<InputDevice>();
        for (int i = 0; i < n3; ++i) {
            DeviceManager deviceManager = deviceManagerArray[i];
            deviceManager.setErrorReporter(this.errorReporter);
            InputDevice[] inputDeviceArray = deviceManager.getDevices();
            for (n2 = 0; n2 < inputDeviceArray.length; ++n2) {
                InputDevice inputDevice = inputDeviceArray[n2];
                this.errorReporter.messageReport("Device found: " + inputDevice.getName());
                if (inputDevice instanceof TrackerDevice) {
                    arrayList2.add(inputDevice);
                }
                if (inputDevice instanceof ControllerDevice) {
                    arrayList.add(inputDevice);
                }
                if (!(inputDevice instanceof MidiDevice)) continue;
                arrayList3.add(inputDevice);
            }
        }
        if (arrayList2.size() == 0 && arrayList.size() == 0 && arrayList3.size() == 0) {
            this.errorReporter.messageReport("No devices registered in InputDeviceManager");
        }
        this.trackerDevices = new TrackerDevice[arrayList2.size()];
        arrayList2.toArray(this.trackerDevices);
        this.controllerDevices = new ControllerDevice[arrayList.size()];
        arrayList.toArray(this.controllerDevices);
        this.midiDevices = new MidiDevice[arrayList3.size()];
        arrayList3.toArray(this.midiDevices);
        arrayList2.clear();
        arrayList.clear();
        arrayList3.clear();
        n3 = this.trackerDevices.length;
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            TrackerDevice trackerDevice = this.trackerDevices[n];
            n2 += trackerDevice.getTrackerCount();
        }
        this.trackers = new Tracker[n2];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            Tracker[] trackerArray = this.trackerDevices[i].getTrackers();
            for (int j = 0; j < trackerArray.length; ++j) {
                this.trackers[n++] = trackerArray[j];
            }
        }
        this.initialized = true;
    }

    public void addX3DNode(VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType) {
        String string = vRMLDeviceSensorNodeType.getName();
        ArrayList<VRMLDeviceSensorNodeType> arrayList = (ArrayList<VRMLDeviceSensorNodeType>)this.controllerMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<VRMLDeviceSensorNodeType>();
            arrayList.add(vRMLDeviceSensorNodeType);
            this.controllerMap.put(string, arrayList);
            int n = this.controllerDevices.length;
            for (int i = 0; i < n; ++i) {
                if (!this.controllerDevices[i].getName().equals(string)) continue;
                vRMLDeviceSensorNodeType.setDevice(this.controllerDevices[i]);
            }
        } else {
            arrayList.add(vRMLDeviceSensorNodeType);
        }
    }

    public void removeX3DNode(VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType) {
        System.out.println("Got remove sensor node: " + vRMLDeviceSensorNodeType);
    }

    public void clear() {
        this.controllerMap.clear();
    }

    public void beginTrackerProcessing() {
        int n = this.trackers.length;
        this.activateSensors = true;
        for (int i = 0; i < n; ++i) {
            this.trackers[i].beginPolling();
        }
    }

    public void endTrackerProcessing() {
        int n = this.trackers.length;
        for (int i = 0; i < n; ++i) {
            this.trackers[i].endPolling();
        }
    }

    public void processTrackers(int n, boolean bl, UserInputHandler userInputHandler, boolean bl2) {
        if (!this.initialized) {
            return;
        }
        int n2 = this.controllerDevices.length;
        if (bl) {
            GenericHIDState genericHIDState = null;
            for (int i = 0; i < n2; ++i) {
                if (this.controllerDevices[i] instanceof GamepadDevice) {
                    ((GamepadDevice)this.controllerDevices[i]).getState(this.gamepadState);
                    genericHIDState = this.gamepadState;
                } else if (this.controllerDevices[i] instanceof JoystickDevice) {
                    ((JoystickDevice)this.controllerDevices[i]).getState(this.joystickState);
                    genericHIDState = this.joystickState;
                } else if (this.controllerDevices[i] instanceof WheelDevice) {
                    ((WheelDevice)this.controllerDevices[i]).getState(this.wheelState);
                    genericHIDState = this.wheelState;
                }
                ArrayList arrayList = (ArrayList)this.controllerMap.get(this.controllerDevices[i].getName());
                if (arrayList != null) {
                    int n3 = arrayList.size();
                    for (int j = 0; j < n3; ++j) {
                        VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType = (VRMLDeviceSensorNodeType)arrayList.get(j);
                        vRMLDeviceSensorNodeType.update(genericHIDState);
                    }
                }
                if (genericHIDState == null) continue;
                genericHIDState.clearChanged();
            }
        }
        n2 = this.trackers.length;
        block12: for (int i = 0; i < n2; ++i) {
            this.trackers[i].getState(n, 0, this.state);
            if (bl2) {
                userInputHandler.setActivateSensors(this.activateSensors);
            } else {
                userInputHandler.setActivateSensors(false);
            }
            switch (this.state.actionType) {
                case 128: {
                    userInputHandler.trackerButton(i, this.state);
                    continue block12;
                }
                case 2: {
                    userInputHandler.trackerPressed(i, this.state);
                    continue block12;
                }
                case 16: {
                    userInputHandler.trackerReleased(i, this.state);
                    continue block12;
                }
                case 32: {
                    userInputHandler.trackerMoved(i, this.state);
                    continue block12;
                }
                case 8: {
                    userInputHandler.trackerClicked(i, this.state);
                    continue block12;
                }
                case 4: {
                    userInputHandler.trackerDragged(i, this.state);
                    continue block12;
                }
                case 64: {
                    userInputHandler.trackerOrientation(i, this.state);
                    continue block12;
                }
                case 256: {
                    userInputHandler.trackerWheel(i, this.state);
                }
            }
        }
        if (bl && this.activateSensors) {
            userInputHandler.processNavigation();
        }
        if (userInputHandler.trackerIntersected()) {
            this.activateSensors = false;
        }
    }
}

