'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH DS1996 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1996
\- 64kbit Memory iButton
.SH SYNOPSIS
Non-volatile memory.
.PP
.B 0C
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-255|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.TP
.I 0C
DS1996
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
8192 bytes of memory.
.SS pages/page.0 ... pages/page.255 pages/page.ALL
.I read-write, binary
.br
Memory is split into 256 pages of 32 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1996
The
.B DS1996 (3)
is an iButton with static memory. Data is read/written with error checking (transparent to the user).
The
.B DS1992
,
.B DS1993
,
.B DS1995
, and
.B DS1996
differ in their function by the amount of on-board memory they possess. (The internal protocols are slightly different, but the
.I OWFS
system handles this automatically.)
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS1996.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
