
# This macro copies a complete directory tree but skips paths with ".svn", which are produced by Subversion.
MACRO(COPY_DIRECTORY_WITHOUT_SVN source destination)
	FILE(MAKE_DIRECTORY "${destination}")
	FILE(GLOB_RECURSE FILES_TO_BE_COPIED "${source}/*")
	FOREACH(path ${FILES_TO_BE_COPIED})	
		GET_FILENAME_COMPONENT(filename ${path} NAME)
		IF(NOT ${path} MATCHES ".svn")
			FILE(RELATIVE_PATH REL_PATH "${source}/" ${path})
			CONFIGURE_FILE(${path} "${destination}/${REL_PATH}" COPYONLY)
		ENDIF(NOT ${path} MATCHES ".svn")
	ENDFOREACH(path)
ENDMACRO(COPY_DIRECTORY_WITHOUT_SVN)
