/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.netbeans.junit.Manager;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModelTestBase;

/**
 * Test for fast closing and opening of the project
 * @author Vladimir Kvashin
 */
public class CloseAndOpenTest extends TraceModelTestBase {
    private static final boolean TRACE = false;

    public CloseAndOpenTest(String testName) {
        super(testName);
    }

    @Override
    protected File getTestCaseDataDir() {
        String dataPath = convertToModelImplDataDir("repository");
        String filePath = "common";
        return Manager.normalizeFile(new File(dataPath, filePath));
    }

    public void testCloseAndOpen0() throws Exception {
        closeAndOpen(2);
    }

    public void testCloseAndOpen1() throws Exception {
        closeAndOpen(2);
    }

    public void testCloseAndOpen2() throws Exception {
        closeAndOpen(2);
    }

    public void testCloseAndOpenN() throws Exception {
        closeAndOpen(Integer.getInteger("close.and.open.test.laps", 100));
    }

    private void closeAndOpen(int count) throws Exception {

        String logFileName = "testCloseAndOpen";
        File workDir = getWorkDir();

        File projectRoot = getDataFile("quote_nosyshdr"); // new File("/tmp/tiny.c");

        String lastError = null;
        StringBuilder numbers = new StringBuilder();
        for (int i = 0; i < count; i++) {

            File out = new File(workDir, logFileName + i + ".dat");
            File err = new File(workDir, logFileName + i + ".err");

            PrintStream streamOut = new PrintStream(out);
            final PrintStream streamErr = new FilteredPrintStream(err);


            DiagnosticExceptoins.Hook hook = new DiagnosticExceptoins.Hook() {

                @Override
                public void exception(Throwable thr) {
                    thr.printStackTrace(streamErr);
                }
            };
            DiagnosticExceptoins.setHook(hook);

            if (TRACE) {
                System.out.printf("Parsing project %s. Pass %d \n", projectRoot.getAbsolutePath(), i);
            }
            doTest(new String[]{projectRoot.getAbsolutePath()}, streamOut, streamErr);

            StringBuilder fileContent = new StringBuilder();
            boolean res = grep("(AssertionError)|(Exception)", err, fileContent);
            if (res) {
                if (numbers.length()>0) {
                    numbers.append(", ");
                }
                numbers.append(""+i);
                lastError = "Errors on iteration "+i+" in " + err.getAbsolutePath() + "\n" + fileContent;
            }
            resetProject();
        }
        if (lastError != null) {
            assertFalse(lastError+"\n all failed iterations are "+numbers.toString(), true);
        }
    }

    public boolean grep(String text, File file, StringBuilder fileContent) throws IOException {

        Pattern pattern = Pattern.compile(text);

        boolean found = false;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        for (String line = reader.readLine(); line != null; line = reader.readLine()) {
            if (fileContent != null) {
                fileContent.append(line).append("\n");
            }
            if (!found && pattern.matcher(line).find()) {
                found = true;
            }
        }
        return found;
    }
}
