/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.git.options;


import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.NbBundle;

@OptionsPanelController.Keywords(keywords={"git", "#GitOptionsPanel.kw1", "#GitOptionsPanel.kw2", "#GitOptionsPanel.kw3", "#GitOptionsPanel.kw4"},
        location="Team", tabTitle="#CTL_OptionsPanel.title")
@NbBundle.Messages({
    "CTL_OptionsPanel.title=Versioning",
    "GitOptionsPanel.kw1=versioning",
    "GitOptionsPanel.kw2=exclude new files from commit",
    "GitOptionsPanel.kw3=signed-off-by line",
    "GitOptionsPanel.kw4=non-sharable folders"
})
final class GitOptionsPanel extends javax.swing.JPanel {
    
    private String[] keywords;
    
    GitOptionsPanel () {
        initComponents();
    }
    
    @Override
    public void addNotify() {
        super.addNotify();        
    }

    @Override
    public void removeNotify() {        
        super.removeNotify();
    }

    Collection<String> getKeywords () {
        if (keywords == null) {
            keywords = new String[] {
                "GIT",
                Bundle.GitOptionsPanel_kw1().toUpperCase(),
                Bundle.GitOptionsPanel_kw2().toUpperCase(),
                Bundle.GitOptionsPanel_kw3().toUpperCase(),
                Bundle.GitOptionsPanel_kw4().toUpperCase()
            };
        }
        return Collections.unmodifiableList(Arrays.asList(keywords));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel2 = new javax.swing.JLabel();

        cbOpenOutputWindow.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(cbOpenOutputWindow, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.cbOpenOutputWindow.text")); // NOI18N
        cbOpenOutputWindow.setToolTipText(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "ACSD_cbOpenOutputWindow")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(excludeNewFiles, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.excludeNewFiles.text")); // NOI18N
        excludeNewFiles.setToolTipText(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.excludeNewFiles.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(signOffCheckBox, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.signOffCheckBox.text")); // NOI18N
        signOffCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.signOffCheckBox.TTtext")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbIgnoreNotSharableFiles, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.cbIgnoreNotSharableFiles.text")); // NOI18N
        cbIgnoreNotSharableFiles.setToolTipText(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.cbIgnoreNotSharableFiles.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.jLabel1.text")); // NOI18N

        jLabel2.setLabelFor(txtProjectAnnotation);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.jLabel2.text")); // NOI18N
        jLabel2.setToolTipText(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.jLabel2.TTtext")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnAddVariable, org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.btnAddVariable.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(txtProjectAnnotation)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnAddVariable)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jSeparator1))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(signOffCheckBox)
                                    .addComponent(excludeNewFiles)
                                    .addComponent(cbOpenOutputWindow)
                                    .addComponent(cbIgnoreNotSharableFiles))
                                .addGap(0, 0, Short.MAX_VALUE)))
                        .addGap(12, 12, 12))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cbOpenOutputWindow)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(excludeNewFiles)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(signOffCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbIgnoreNotSharableFiles)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel1)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(txtProjectAnnotation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnAddVariable))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        cbOpenOutputWindow.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.cbOpenOutputWindow.AccessibleContext.accessibleDescription_2")); // NOI18N
        excludeNewFiles.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.excludeNewFiles.AccessibleContext.accessibleName_2")); // NOI18N
        excludeNewFiles.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(GitOptionsPanel.class, "GitOptionsPanel.excludeNewFiles.AccessibleContext.accessibleDescription_2")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
 
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JButton btnAddVariable = new javax.swing.JButton();
    final javax.swing.JCheckBox cbIgnoreNotSharableFiles = new javax.swing.JCheckBox();
    final javax.swing.JCheckBox cbOpenOutputWindow = new javax.swing.JCheckBox();
    final javax.swing.JCheckBox excludeNewFiles = new javax.swing.JCheckBox();
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JSeparator jSeparator1;
    final javax.swing.JCheckBox signOffCheckBox = new javax.swing.JCheckBox();
    final javax.swing.JTextField txtProjectAnnotation = new javax.swing.JTextField();
    // End of variables declaration//GEN-END:variables
    
}
