/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "tut_stdafx.h"

#include "../stub_textentry.h"

namespace mforms {
namespace stub {

bool TextEntryImpl::create(::mforms::TextEntry *self, TextEntryType type)
{
  return true;
}

void TextEntryImpl::set_text(::mforms::TextEntry *self, const std::string &text)
{
}

void TextEntryImpl::set_max_length(::mforms::TextEntry *self, int len)
{
}

std::string TextEntryImpl::get_text(::mforms::TextEntry *self)
{
  return "";
}

void TextEntryImpl::set_read_only(::mforms::TextEntry *self, bool flag)
{
}

void TextEntryImpl::set_placeholder_text(TextEntry *self, const std::string &text)
{
}

//--------------------------------------------------------------------------------------------------

void TextEntryImpl::set_placeholder_color(TextEntry *self, const std::string &color)
{
}

//--------------------------------------------------------------------------------------------------

void TextEntryImpl::set_bordered(TextEntry *self, bool flag)
{
}

//--------------------------------------------------------------------------------------------------

TextEntryImpl::TextEntryImpl(::mforms::TextEntry *self, TextEntryType type)
  : ViewImpl(self)
{
}

void TextEntryImpl::activated(mforms::TextEntry *self)
{
}

void TextEntryImpl::init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

  f->_textentry_impl.create   = &TextEntryImpl::create;
  f->_textentry_impl.set_text = &TextEntryImpl::set_text;
  f->_textentry_impl.set_max_length = &TextEntryImpl::set_max_length;
  f->_textentry_impl.get_text = &TextEntryImpl::get_text;
  f->_textentry_impl.set_read_only= &TextEntryImpl::set_read_only;
  f->_textentry_impl.set_placeholder_text = &TextEntryImpl::set_placeholder_text;
  f->_textentry_impl.set_placeholder_color = &TextEntryImpl::set_placeholder_color;
  f->_textentry_impl.set_bordered = &TextEntryImpl::set_bordered;
}

};
};
