//------------------------------------------------------------------------------
// <copyright file="CodeSnippetCompileUnit.cs" company="Microsoft">
// 
// <OWNER>Microsoft</OWNER>
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>                                                                
//------------------------------------------------------------------------------

namespace System.CodeDom {

    using System.Diagnostics;
    using System;
    using Microsoft.Win32;
    using System.Collections;
    using System.Runtime.InteropServices;

    /// <devdoc>
    ///    <para>
    ///       Represents a snippet block of code.
    ///    </para>
    /// </devdoc>
    [
        ClassInterface(ClassInterfaceType.AutoDispatch),
        ComVisible(true),
        Serializable,
    ]
    public class CodeSnippetCompileUnit : CodeCompileUnit {
        private string value;
        private CodeLinePragma linePragma;

        public CodeSnippetCompileUnit() {
        }

        public CodeSnippetCompileUnit(string value) {
            Value = value;
        }

        /// <devdoc>
        ///    <para>
        ///       Gets or sets
        ///       the snippet
        ///       text of the code block to represent.
        ///    </para>
        /// </devdoc>
        public string Value {
            get {
                return (value == null) ? string.Empty : value;
            }
            set {
                this.value = value;
            }
        }

        /// <devdoc>
        ///    <para>
        ///       The line the code block starts on.
        ///    </para>
        /// </devdoc>
        public CodeLinePragma LinePragma {
            get {
                return linePragma;
            }
            set {
                linePragma = value;
            }
        }
    }
}
