#ifndef _COMPAT_LINUX_SEQ_FILE_H
#define _COMPAT_LINUX_SEQ_FILE_H

#include "../../compat/config.h"

#include_next <linux/seq_file.h>

#ifndef HAVE_DEFINE_SEQ_ATTRIBUTE
#define DEFINE_SEQ_ATTRIBUTE(__name)					\
static int __name ## _open(struct inode *inode, struct file *file)	\
{									\
	int ret = seq_open(file, &__name ## _sops);			\
	if (!ret && inode->i_private) {					\
		struct seq_file *seq_f = file->private_data;		\
		seq_f->private = inode->i_private;			\
	}								\
	return ret;							\
}									\
									\
static const struct file_operations __name ## _fops = {			\
	.owner		= THIS_MODULE,					\
	.open		= __name ## _open,				\
	.read		= seq_read,					\
	.llseek		= seq_lseek,					\
	.release	= seq_release,					\
}
#endif

#endif /* _COMPAT_LINUX_SEQ_FILE_H */
