/* subsystem.c generated by valac 0.16.1, the Vala compiler
 * generated from subsystem.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */
/**
 * Subsystem query interface
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <config.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define FSO_FRAMEWORK_TYPE_SUBSYSTEM (fso_framework_subsystem_get_type ())
#define FSO_FRAMEWORK_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_SUBSYSTEM, FsoFrameworkSubsystem))
#define FSO_FRAMEWORK_IS_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_SUBSYSTEM))
#define FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_SUBSYSTEM, FsoFrameworkSubsystemIface))

typedef struct _FsoFrameworkSubsystem FsoFrameworkSubsystem;
typedef struct _FsoFrameworkSubsystemIface FsoFrameworkSubsystemIface;

#define FSO_FRAMEWORK_TYPE_PLUGIN_INFO (fso_framework_plugin_info_get_type ())
typedef struct _FsoFrameworkPluginInfo FsoFrameworkPluginInfo;

#define FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM (fso_framework_abstract_subsystem_get_type ())
#define FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM, FsoFrameworkAbstractSubsystem))
#define FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM, FsoFrameworkAbstractSubsystemClass))
#define FSO_FRAMEWORK_IS_ABSTRACT_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM))
#define FSO_FRAMEWORK_IS_ABSTRACT_SUBSYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM))
#define FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM, FsoFrameworkAbstractSubsystemClass))

typedef struct _FsoFrameworkAbstractSubsystem FsoFrameworkAbstractSubsystem;
typedef struct _FsoFrameworkAbstractSubsystemClass FsoFrameworkAbstractSubsystemClass;
typedef struct _FsoFrameworkAbstractSubsystemPrivate FsoFrameworkAbstractSubsystemPrivate;

#define FSO_FRAMEWORK_TYPE_PLUGIN (fso_framework_plugin_get_type ())
#define FSO_FRAMEWORK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_PLUGIN, FsoFrameworkPlugin))
#define FSO_FRAMEWORK_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_PLUGIN))
#define FSO_FRAMEWORK_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_PLUGIN, FsoFrameworkPluginIface))

typedef struct _FsoFrameworkPlugin FsoFrameworkPlugin;
typedef struct _FsoFrameworkPluginIface FsoFrameworkPluginIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FSO_FRAMEWORK_TYPE_BASE_PLUGIN (fso_framework_base_plugin_get_type ())
#define FSO_FRAMEWORK_BASE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BASE_PLUGIN, FsoFrameworkBasePlugin))
#define FSO_FRAMEWORK_BASE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BASE_PLUGIN, FsoFrameworkBasePluginClass))
#define FSO_FRAMEWORK_IS_BASE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BASE_PLUGIN))
#define FSO_FRAMEWORK_IS_BASE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BASE_PLUGIN))
#define FSO_FRAMEWORK_BASE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BASE_PLUGIN, FsoFrameworkBasePluginClass))

typedef struct _FsoFrameworkBasePlugin FsoFrameworkBasePlugin;
typedef struct _FsoFrameworkBasePluginClass FsoFrameworkBasePluginClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__fso_framework_plugin_info_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__fso_framework_plugin_info_free0_ (var), NULL)))

#define FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM (fso_framework_base_subsystem_get_type ())
#define FSO_FRAMEWORK_BASE_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM, FsoFrameworkBaseSubsystem))
#define FSO_FRAMEWORK_BASE_SUBSYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM, FsoFrameworkBaseSubsystemClass))
#define FSO_FRAMEWORK_IS_BASE_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM))
#define FSO_FRAMEWORK_IS_BASE_SUBSYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM))
#define FSO_FRAMEWORK_BASE_SUBSYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM, FsoFrameworkBaseSubsystemClass))

typedef struct _FsoFrameworkBaseSubsystem FsoFrameworkBaseSubsystem;
typedef struct _FsoFrameworkBaseSubsystemClass FsoFrameworkBaseSubsystemClass;
typedef struct _FsoFrameworkBaseSubsystemPrivate FsoFrameworkBaseSubsystemPrivate;

#define FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT (fso_framework_dbus_export_object_get_type ())
#define FSO_FRAMEWORK_DBUS_EXPORT_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT, FsoFrameworkDBusExportObject))
#define FSO_FRAMEWORK_DBUS_EXPORT_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT, FsoFrameworkDBusExportObjectClass))
#define FSO_FRAMEWORK_IS_DBUS_EXPORT_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT))
#define FSO_FRAMEWORK_IS_DBUS_EXPORT_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT))
#define FSO_FRAMEWORK_DBUS_EXPORT_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT, FsoFrameworkDBusExportObjectClass))

typedef struct _FsoFrameworkDBusExportObject FsoFrameworkDBusExportObject;
typedef struct _FsoFrameworkDBusExportObjectClass FsoFrameworkDBusExportObjectClass;
typedef struct _FsoFrameworkDBusExportObjectPrivate FsoFrameworkDBusExportObjectPrivate;
typedef struct _FsoFrameworkParamSpecDBusExportObject FsoFrameworkParamSpecDBusExportObject;

#define FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM (fso_framework_dbus_subsystem_get_type ())
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM, FsoFrameworkDBusSubsystem))
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM, FsoFrameworkDBusSubsystemClass))
#define FSO_FRAMEWORK_IS_DBUS_SUBSYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM))
#define FSO_FRAMEWORK_IS_DBUS_SUBSYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM))
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM, FsoFrameworkDBusSubsystemClass))

typedef struct _FsoFrameworkDBusSubsystem FsoFrameworkDBusSubsystem;
typedef struct _FsoFrameworkDBusSubsystemClass FsoFrameworkDBusSubsystemClass;
typedef struct _FsoFrameworkDBusSubsystemPrivate FsoFrameworkDBusSubsystemPrivate;

#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION (fso_framework_dbus_subsystem_service_registration_get_type ())
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION, FsoFrameworkDBusSubsystemServiceRegistration))
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION, FsoFrameworkDBusSubsystemServiceRegistrationClass))
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_IS_SERVICE_REGISTRATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION))
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_IS_SERVICE_REGISTRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION))
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION, FsoFrameworkDBusSubsystemServiceRegistrationClass))

typedef struct _FsoFrameworkDBusSubsystemServiceRegistration FsoFrameworkDBusSubsystemServiceRegistration;
typedef struct _FsoFrameworkDBusSubsystemServiceRegistrationClass FsoFrameworkDBusSubsystemServiceRegistrationClass;
typedef struct _Block1Data Block1Data;
typedef struct _FsoFrameworkDBusSubsystemServiceRegistrationPrivate FsoFrameworkDBusSubsystemServiceRegistrationPrivate;
#define _fso_framework_dbus_subsystem_service_registration_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_dbus_subsystem_service_registration_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _FsoFrameworkDBusSubsystemParamSpecServiceRegistration FsoFrameworkDBusSubsystemParamSpecServiceRegistration;

struct _FsoFrameworkPluginInfo {
	gchar* name;
	gboolean loaded;
};

struct _FsoFrameworkSubsystemIface {
	GTypeInterface parent_iface;
	guint (*registerPlugins) (FsoFrameworkSubsystem* self);
	guint (*loadPlugins) (FsoFrameworkSubsystem* self);
	gchar* (*name) (FsoFrameworkSubsystem* self);
	GList* (*pluginsInfo) (FsoFrameworkSubsystem* self);
	void (*registerObjectForService) (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj);
	void (*registerObjectForServiceWithPrefix) (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj);
	void (*unregisterObjectForService) (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath);
	GObject** (*allObjectsWithPrefix) (FsoFrameworkSubsystem* self, const gchar* prefix, int* result_length1);
	void (*shutdown) (FsoFrameworkSubsystem* self);
};

struct _FsoFrameworkAbstractSubsystem {
	GObject parent_instance;
	FsoFrameworkAbstractSubsystemPrivate * priv;
	FsoFrameworkLogger* logger;
};

struct _FsoFrameworkAbstractSubsystemClass {
	GObjectClass parent_class;
	void (*registerObjectForService) (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj);
	void (*registerObjectForServiceWithPrefix) (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj);
	gboolean (*registerServiceObjectWithPrefix) (FsoFrameworkAbstractSubsystem* self, const gchar* servicename, const gchar* prefix, GObject* obj);
	GObject** (*allObjectsWithPrefix) (FsoFrameworkAbstractSubsystem* self, const gchar* prefix, int* result_length1);
	void (*unregisterObjectForService) (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath);
};

typedef enum  {
	FSO_FRAMEWORK_PLUGIN_ERROR_UNABLE_TO_LOAD,
	FSO_FRAMEWORK_PLUGIN_ERROR_REGISTER_NOT_FOUND,
	FSO_FRAMEWORK_PLUGIN_ERROR_FACTORY_NOT_FOUND,
	FSO_FRAMEWORK_PLUGIN_ERROR_UNABLE_TO_INITIALIZE
} FsoFrameworkPluginError;
#define FSO_FRAMEWORK_PLUGIN_ERROR fso_framework_plugin_error_quark ()
struct _FsoFrameworkPluginIface {
	GTypeInterface parent_iface;
	void (*loadAndInit) (FsoFrameworkPlugin* self, GError** error);
	void (*info) (FsoFrameworkPlugin* self, FsoFrameworkPluginInfo* result);
	void (*shutdown) (FsoFrameworkPlugin* self);
};

struct _FsoFrameworkAbstractSubsystemPrivate {
	gchar* _name;
	GList* _plugins;
};

struct _FsoFrameworkBaseSubsystem {
	FsoFrameworkAbstractSubsystem parent_instance;
	FsoFrameworkBaseSubsystemPrivate * priv;
};

struct _FsoFrameworkBaseSubsystemClass {
	FsoFrameworkAbstractSubsystemClass parent_class;
};

struct _FsoFrameworkDBusExportObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoFrameworkDBusExportObjectPrivate * priv;
	GObject* object;
	gint* registrations;
	gint registrations_length1;
};

struct _FsoFrameworkDBusExportObjectClass {
	GTypeClass parent_class;
	void (*finalize) (FsoFrameworkDBusExportObject *self);
};

struct _FsoFrameworkParamSpecDBusExportObject {
	GParamSpec parent_instance;
};

struct _FsoFrameworkDBusSubsystem {
	FsoFrameworkAbstractSubsystem parent_instance;
	FsoFrameworkDBusSubsystemPrivate * priv;
};

struct _FsoFrameworkDBusSubsystemClass {
	FsoFrameworkAbstractSubsystemClass parent_class;
};

struct _FsoFrameworkDBusSubsystemPrivate {
	GDBusConnection* connection;
	GeeHashMap* registrations;
	GeeHashMap* dbusobjects;
	GeeHashMap* counters;
	GeeHashSet* busnames;
	guint watch;
	GBusType bus_type;
};

struct _Block1Data {
	int _ref_count_;
	FsoFrameworkDBusSubsystem * self;
	gchar* servicename;
};

struct _FsoFrameworkDBusSubsystemServiceRegistration {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoFrameworkDBusSubsystemServiceRegistrationPrivate * priv;
	guint ref_id;
	gchar* object_path;
	GType iface_type;
};

struct _FsoFrameworkDBusSubsystemServiceRegistrationClass {
	GTypeClass parent_class;
	void (*finalize) (FsoFrameworkDBusSubsystemServiceRegistration *self);
};

struct _Block2Data {
	int _ref_count_;
	FsoFrameworkDBusSubsystem * self;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
};

struct _FsoFrameworkDBusSubsystemParamSpecServiceRegistration {
	GParamSpec parent_instance;
};


static gpointer fso_framework_abstract_subsystem_parent_class = NULL;
static FsoFrameworkSubsystemIface* fso_framework_abstract_subsystem_fso_framework_subsystem_parent_iface = NULL;
static gpointer fso_framework_base_subsystem_parent_class = NULL;
static gpointer fso_framework_dbus_export_object_parent_class = NULL;
static gpointer fso_framework_dbus_subsystem_parent_class = NULL;
static gpointer fso_framework_dbus_subsystem_service_registration_parent_class = NULL;

GType fso_framework_plugin_info_get_type (void) G_GNUC_CONST;
FsoFrameworkPluginInfo* fso_framework_plugin_info_dup (const FsoFrameworkPluginInfo* self);
void fso_framework_plugin_info_free (FsoFrameworkPluginInfo* self);
void fso_framework_plugin_info_copy (const FsoFrameworkPluginInfo* self, FsoFrameworkPluginInfo* dest);
void fso_framework_plugin_info_destroy (FsoFrameworkPluginInfo* self);
GType fso_framework_subsystem_get_type (void) G_GNUC_CONST;
guint fso_framework_subsystem_registerPlugins (FsoFrameworkSubsystem* self);
guint fso_framework_subsystem_loadPlugins (FsoFrameworkSubsystem* self);
gchar* fso_framework_subsystem_name (FsoFrameworkSubsystem* self);
GList* fso_framework_subsystem_pluginsInfo (FsoFrameworkSubsystem* self);
void fso_framework_subsystem_registerObjectForService (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj);
void fso_framework_subsystem_registerObjectForServiceWithPrefix (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj);
void fso_framework_subsystem_unregisterObjectForService (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath);
GObject** fso_framework_subsystem_allObjectsWithPrefix (FsoFrameworkSubsystem* self, const gchar* prefix, int* result_length1);
void fso_framework_subsystem_shutdown (FsoFrameworkSubsystem* self);
GType fso_framework_abstract_subsystem_get_type (void) G_GNUC_CONST;
GQuark fso_framework_plugin_error_quark (void);
GType fso_framework_plugin_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM, FsoFrameworkAbstractSubsystemPrivate))
enum  {
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
FsoFrameworkAbstractSubsystem* fso_framework_abstract_subsystem_construct (GType object_type, const gchar* name);
static guint fso_framework_abstract_subsystem_real_registerPlugins (FsoFrameworkSubsystem* base);
FsoFrameworkBasePlugin* fso_framework_base_plugin_new (const gchar* filename, FsoFrameworkSubsystem* subsystem);
FsoFrameworkBasePlugin* fso_framework_base_plugin_construct (GType object_type, const gchar* filename, FsoFrameworkSubsystem* subsystem);
GType fso_framework_base_plugin_get_type (void) G_GNUC_CONST;
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static guint fso_framework_abstract_subsystem_real_loadPlugins (FsoFrameworkSubsystem* base);
void fso_framework_plugin_loadAndInit (FsoFrameworkPlugin* self, GError** error);
static gchar* fso_framework_abstract_subsystem_real_name (FsoFrameworkSubsystem* base);
static GList* fso_framework_abstract_subsystem_real_pluginsInfo (FsoFrameworkSubsystem* base);
void fso_framework_plugin_info (FsoFrameworkPlugin* self, FsoFrameworkPluginInfo* result);
static void _fso_framework_plugin_info_free0_ (gpointer var);
static void _g_list_free__fso_framework_plugin_info_free0_ (GList* self);
void fso_framework_abstract_subsystem_registerObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj);
static void fso_framework_abstract_subsystem_real_registerObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj);
void fso_framework_abstract_subsystem_registerObjectForServiceWithPrefix (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj);
static void fso_framework_abstract_subsystem_real_registerObjectForServiceWithPrefix (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj);
gboolean fso_framework_abstract_subsystem_registerServiceObjectWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* servicename, const gchar* prefix, GObject* obj);
static gboolean fso_framework_abstract_subsystem_real_registerServiceObjectWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* servicename, const gchar* prefix, GObject* obj);
GObject** fso_framework_abstract_subsystem_allObjectsWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* prefix, int* result_length1);
static GObject** fso_framework_abstract_subsystem_real_allObjectsWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* prefix, int* result_length1);
void fso_framework_abstract_subsystem_unregisterObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath);
static void fso_framework_abstract_subsystem_real_unregisterObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath);
static void fso_framework_abstract_subsystem_real_shutdown (FsoFrameworkSubsystem* base);
void fso_framework_plugin_shutdown (FsoFrameworkPlugin* self);
static void fso_framework_abstract_subsystem_finalize (GObject* obj);
GType fso_framework_base_subsystem_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_BASE_SUBSYSTEM_DUMMY_PROPERTY
};
FsoFrameworkBaseSubsystem* fso_framework_base_subsystem_new (const gchar* name);
FsoFrameworkBaseSubsystem* fso_framework_base_subsystem_construct (GType object_type, const gchar* name);
gpointer fso_framework_dbus_export_object_ref (gpointer instance);
void fso_framework_dbus_export_object_unref (gpointer instance);
GParamSpec* fso_framework_param_spec_dbus_export_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_framework_value_set_dbus_export_object (GValue* value, gpointer v_object);
void fso_framework_value_take_dbus_export_object (GValue* value, gpointer v_object);
gpointer fso_framework_value_get_dbus_export_object (const GValue* value);
GType fso_framework_dbus_export_object_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_DBUS_EXPORT_OBJECT_DUMMY_PROPERTY
};
FsoFrameworkDBusExportObject* fso_framework_dbus_export_object_new (void);
FsoFrameworkDBusExportObject* fso_framework_dbus_export_object_construct (GType object_type);
static void fso_framework_dbus_export_object_finalize (FsoFrameworkDBusExportObject* obj);
GType fso_framework_dbus_subsystem_get_type (void) G_GNUC_CONST;
static gpointer fso_framework_dbus_subsystem_service_registration_ref (gpointer instance);
static void fso_framework_dbus_subsystem_service_registration_unref (gpointer instance);
static GParamSpec* fso_framework_dbus_subsystem_param_spec_service_registration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void fso_framework_dbus_subsystem_value_set_service_registration (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void fso_framework_dbus_subsystem_value_take_service_registration (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer fso_framework_dbus_subsystem_value_get_service_registration (const GValue* value) G_GNUC_UNUSED;
static GType fso_framework_dbus_subsystem_service_registration_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define FSO_FRAMEWORK_DBUS_SUBSYSTEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM, FsoFrameworkDBusSubsystemPrivate))
enum  {
	FSO_FRAMEWORK_DBUS_SUBSYSTEM_DUMMY_PROPERTY
};
FsoFrameworkDBusSubsystem* fso_framework_dbus_subsystem_new (const gchar* name, GBusType type);
FsoFrameworkDBusSubsystem* fso_framework_dbus_subsystem_construct (GType object_type, const gchar* name, GBusType type);
static void fso_framework_dbus_subsystem_ensureConnection (FsoFrameworkDBusSubsystem* self);
void fso_framework_dbus_subsystem_exportBusnames (FsoFrameworkDBusSubsystem* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda2_ (Block1Data* _data1_, GDBusConnection* conn, const gchar* name);
static void _____lambda2__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void ____lambda3_ (Block1Data* _data1_);
static void _____lambda3__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void fso_framework_dbus_subsystem_real_unregisterObjectForService (FsoFrameworkAbstractSubsystem* base, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath);
static void fso_framework_dbus_subsystem_real_registerObjectForService (FsoFrameworkAbstractSubsystem* base, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error);
static FsoFrameworkDBusSubsystemServiceRegistration* fso_framework_dbus_subsystem_service_registration_new (void);
static FsoFrameworkDBusSubsystemServiceRegistration* fso_framework_dbus_subsystem_service_registration_construct (GType object_type);
static gboolean ___lambda4_ (Block2Data* _data2_);
static gboolean ____lambda4__gsource_func (gpointer self);
static void fso_framework_dbus_subsystem_real_registerObjectForServiceWithPrefix (FsoFrameworkAbstractSubsystem* base, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefix, gconstpointer obj);
GDBusConnection* fso_framework_dbus_subsystem_dbusConnection (FsoFrameworkDBusSubsystem* self);
static GObject** fso_framework_dbus_subsystem_real_allObjectsWithPrefix (FsoFrameworkAbstractSubsystem* base, const gchar* prefix, int* result_length1);
static void _vala_array_add1 (GObject*** array, int* length, int* size, GObject* value);
enum  {
	FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION_DUMMY_PROPERTY
};
static void fso_framework_dbus_subsystem_service_registration_finalize (FsoFrameworkDBusSubsystemServiceRegistration* obj);
static void fso_framework_dbus_subsystem_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Register plugins for this subsystem.
     * @return the number of registered plugins.
     **/
guint fso_framework_subsystem_registerPlugins (FsoFrameworkSubsystem* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->registerPlugins (self);
}


/**
     * Load registered plugins for this subsystem.
     * @return the number of loaded plugins.
     * Plugins are loaded in the order they appear in the register,
     * which in turn is the order they are defined in the configuration
     * file. You can use this to express dependencies.
     **/
guint fso_framework_subsystem_loadPlugins (FsoFrameworkSubsystem* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->loadPlugins (self);
}


/**
     * @return the name of this subsystem.
     **/
gchar* fso_framework_subsystem_name (FsoFrameworkSubsystem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->name (self);
}


/**
     * @return plugin information.
     **/
GList* fso_framework_subsystem_pluginsInfo (FsoFrameworkSubsystem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->pluginsInfo (self);
}


/**
     * Register an object with the IPC mechanism.
     * If the service name is not claimed yet, attempt to claim it.
     **/
void fso_framework_subsystem_registerObjectForService (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->registerObjectForService (self, t_type, t_dup_func, t_destroy_func, servicename, objectpath, obj);
}


/**
     * Register an object with the IPC mechanism.
     * If the service name is not claimed yet, attempt to claim it.
     **/
void fso_framework_subsystem_registerObjectForServiceWithPrefix (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->registerObjectForServiceWithPrefix (self, t_type, t_dup_func, t_destroy_func, servicename, prefixpath, obj);
}


/**
     * Unregister an object with the IPC mechanism.
     **/
void fso_framework_subsystem_unregisterObjectForService (FsoFrameworkSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->unregisterObjectForService (self, t_type, t_dup_func, t_destroy_func, servicename, objectpath);
}


/**
     * Query registered plugins with a certain path prefix.
     **/
GObject** fso_framework_subsystem_allObjectsWithPrefix (FsoFrameworkSubsystem* self, const gchar* prefix, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->allObjectsWithPrefix (self, prefix, result_length1);
}


/**
     * Shutdown the subsystem. This will call shutdown on all plugins.
     **/
void fso_framework_subsystem_shutdown (FsoFrameworkSubsystem* self) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_SUBSYSTEM_GET_INTERFACE (self)->shutdown (self);
}


static void fso_framework_subsystem_base_init (FsoFrameworkSubsystemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * Signal sent, when a servicename has been acquired.
		     **/
		g_signal_new ("service_name_acquired", FSO_FRAMEWORK_TYPE_SUBSYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


/**
 * Subsystem Interface
 *
 * A subsystem hosts a number of plugins that can expose service objects
 * via an IPC mechanism such as DBus.
 */
GType fso_framework_subsystem_get_type (void) {
	static volatile gsize fso_framework_subsystem_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_subsystem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkSubsystemIface), (GBaseInitFunc) fso_framework_subsystem_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType fso_framework_subsystem_type_id;
		fso_framework_subsystem_type_id = g_type_register_static (G_TYPE_INTERFACE, "FsoFrameworkSubsystem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (fso_framework_subsystem_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&fso_framework_subsystem_type_id__volatile, fso_framework_subsystem_type_id);
	}
	return fso_framework_subsystem_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


FsoFrameworkAbstractSubsystem* fso_framework_abstract_subsystem_construct (GType object_type, const gchar* name) {
	FsoFrameworkAbstractSubsystem * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FsoFrameworkLogger* _tmp2_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (FsoFrameworkAbstractSubsystem*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = fso_framework_logger_createLogger ("libfsoframework", "subsystem");
	_g_object_unref0 (self->logger);
	self->logger = _tmp2_;
	return self;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static guint fso_framework_abstract_subsystem_real_registerPlugins (FsoFrameworkSubsystem* base) {
	FsoFrameworkAbstractSubsystem * self;
	guint result = 0U;
	GList* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	FsoFrameworkSmartKeyFile* _tmp11_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	FsoFrameworkSmartKeyFile* _tmp21_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GList* _tmp26_ = NULL;
	GList* _tmp27_;
	GList* names;
	gchar* _tmp28_ = NULL;
	gchar* defaultpath;
	FsoFrameworkSmartKeyFile* _tmp29_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* pluginpath;
	FsoFrameworkLogger* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GList* _tmp40_;
	FsoFrameworkLogger* _tmp61_;
	GList* _tmp62_;
	guint _tmp63_ = 0U;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	gboolean _tmp68_ = FALSE;
	GList* _tmp69_;
	guint _tmp70_ = 0U;
	self = (FsoFrameworkAbstractSubsystem*) base;
	_tmp0_ = self->priv->_plugins;
	g_assert (_tmp0_ == NULL);
	__g_list_free__g_object_unref0_0 (self->priv->_plugins);
	self->priv->_plugins = NULL;
	_tmp1_ = fso_framework_smart_key_file_defaultKeyFile ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_name;
	_tmp4_ = fso_framework_smart_key_file_hasSection (_tmp2_, _tmp3_);
	_tmp5_ = !_tmp4_;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		FsoFrameworkLogger* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp6_ = self->logger;
		_tmp7_ = self->priv->_name;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("No section for ", _tmp8_, " in configuration file. Not looking for plugins.", NULL);
		_tmp10_ = _tmp9_;
		fso_framework_logger_warning (_tmp6_, _tmp10_);
		_g_free0 (_tmp10_);
		result = (guint) 0;
		return result;
	}
	_tmp11_ = fso_framework_smart_key_file_defaultKeyFile ();
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_name;
	_tmp14_ = fso_framework_smart_key_file_boolValue (_tmp12_, _tmp13_, "disabled", FALSE);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp12_);
	if (_tmp15_) {
		FsoFrameworkLogger* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		_tmp16_ = self->logger;
		_tmp17_ = self->priv->_name;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("Subsystem ", _tmp18_, " has been disabled in configuration file. Not looking for plugins.", NULL);
		_tmp20_ = _tmp19_;
		fso_framework_logger_info (_tmp16_, _tmp20_);
		_g_free0 (_tmp20_);
		result = (guint) 0;
		return result;
	}
	_tmp21_ = fso_framework_smart_key_file_defaultKeyFile ();
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->_name;
	_tmp24_ = g_strconcat (_tmp23_, ".", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = fso_framework_smart_key_file_sectionsWithPrefix (_tmp22_, _tmp25_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	_g_object_unref0 (_tmp22_);
	names = _tmp27_;
	_tmp28_ = g_build_filename (PACKAGE_LIBDIR, "modules", NULL);
	defaultpath = _tmp28_;
	_tmp29_ = fso_framework_smart_key_file_defaultKeyFile ();
	_tmp30_ = _tmp29_;
	_tmp31_ = defaultpath;
	_tmp32_ = fso_framework_smart_key_file_stringValue (_tmp30_, "cornucopia", "plugin_path", _tmp31_);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (_tmp30_);
	pluginpath = _tmp33_;
	_tmp34_ = self->logger;
	_tmp35_ = pluginpath;
	_tmp36_ = string_to_string (_tmp35_);
	_tmp37_ = g_strconcat ("Pluginpath is ", _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = fso_framework_logger_debug (_tmp34_, _tmp38_);
	g_assert (_tmp39_);
	_g_free0 (_tmp38_);
	_tmp40_ = names;
	{
		GList* name_collection = NULL;
		GList* name_it = NULL;
		name_collection = _tmp40_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp41_;
			gchar* name = NULL;
			_tmp41_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp41_;
			{
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_;
				gchar* realname;
				gchar* filename = NULL;
				const gchar* _tmp48_;
				gboolean _tmp49_ = FALSE;
				const gchar* _tmp57_;
				FsoFrameworkBasePlugin* _tmp58_;
				FsoFrameworkBasePlugin* plugin;
				FsoFrameworkBasePlugin* _tmp59_;
				FsoFrameworkPlugin* _tmp60_;
				_tmp42_ = name;
				_tmp43_ = self->priv->_name;
				_tmp44_ = g_strconcat (_tmp43_, ".", NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = string_replace (_tmp42_, _tmp45_, "");
				_tmp47_ = _tmp46_;
				_g_free0 (_tmp45_);
				realname = _tmp47_;
				_tmp48_ = pluginpath;
				_tmp49_ = string_contains (_tmp48_, "./.libs");
				if (_tmp49_) {
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_ = NULL;
					_tmp50_ = pluginpath;
					_tmp51_ = realname;
					_tmp52_ = g_strdup_printf (_tmp50_, _tmp51_);
					_g_free0 (filename);
					filename = _tmp52_;
				} else {
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					gchar* _tmp56_ = NULL;
					_tmp53_ = pluginpath;
					_tmp54_ = self->priv->_name;
					_tmp55_ = realname;
					_tmp56_ = g_strdup_printf ("%s/%s/%s", _tmp53_, _tmp54_, _tmp55_);
					_g_free0 (filename);
					filename = _tmp56_;
				}
				_tmp57_ = filename;
				_tmp58_ = fso_framework_base_plugin_new (_tmp57_, (FsoFrameworkSubsystem*) self);
				plugin = _tmp58_;
				_tmp59_ = plugin;
				_tmp60_ = _g_object_ref0 ((FsoFrameworkPlugin*) _tmp59_);
				self->priv->_plugins = g_list_append (self->priv->_plugins, _tmp60_);
				_g_object_unref0 (plugin);
				_g_free0 (filename);
				_g_free0 (realname);
				_g_free0 (name);
			}
		}
	}
	_tmp61_ = self->logger;
	_tmp62_ = self->priv->_plugins;
	_tmp63_ = g_list_length (_tmp62_);
	_tmp64_ = g_strdup_printf ("%u", _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_strconcat ("Registered ", _tmp65_, " plugins", NULL);
	_tmp67_ = _tmp66_;
	_tmp68_ = fso_framework_logger_debug (_tmp61_, _tmp67_);
	g_assert (_tmp68_);
	_g_free0 (_tmp67_);
	_g_free0 (_tmp65_);
	_tmp69_ = self->priv->_plugins;
	_tmp70_ = g_list_length (_tmp69_);
	result = _tmp70_;
	_g_free0 (pluginpath);
	_g_free0 (defaultpath);
	__g_list_free__g_free0_0 (names);
	return result;
}


static guint fso_framework_abstract_subsystem_real_loadPlugins (FsoFrameworkSubsystem* base) {
	FsoFrameworkAbstractSubsystem * self;
	guint result = 0U;
	guint counter;
	GList* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (FsoFrameworkAbstractSubsystem*) base;
	counter = (guint) 0;
	_tmp0_ = self->priv->_plugins;
	{
		GList* plugin_collection = NULL;
		GList* plugin_it = NULL;
		plugin_collection = _tmp0_;
		for (plugin_it = plugin_collection; plugin_it != NULL; plugin_it = plugin_it->next) {
			FsoFrameworkPlugin* _tmp1_;
			FsoFrameworkPlugin* plugin = NULL;
			_tmp1_ = _g_object_ref0 ((FsoFrameworkPlugin*) plugin_it->data);
			plugin = _tmp1_;
			{
				{
					FsoFrameworkPlugin* _tmp2_;
					guint _tmp3_;
					_tmp2_ = plugin;
					fso_framework_plugin_loadAndInit (_tmp2_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_PLUGIN_ERROR) {
							goto __catch3_fso_framework_plugin_error;
						}
						_g_object_unref0 (plugin);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
					_tmp3_ = counter;
					counter = _tmp3_ + 1;
				}
				goto __finally3;
				__catch3_fso_framework_plugin_error:
				{
					GError* e = NULL;
					FsoFrameworkLogger* _tmp4_;
					GError* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp4_ = self->logger;
					_tmp5_ = e;
					_tmp6_ = _tmp5_->message;
					_tmp7_ = string_to_string (_tmp6_);
					_tmp8_ = g_strconcat ("Could not load plugin: ", _tmp7_, NULL);
					_tmp9_ = _tmp8_;
					fso_framework_logger_warning (_tmp4_, _tmp9_);
					_g_free0 (_tmp9_);
					_g_error_free0 (e);
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (plugin);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
				_g_object_unref0 (plugin);
			}
		}
	}
	result = counter;
	return result;
}


static gchar* fso_framework_abstract_subsystem_real_name (FsoFrameworkSubsystem* base) {
	FsoFrameworkAbstractSubsystem * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FsoFrameworkAbstractSubsystem*) base;
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _fso_framework_plugin_info_dup0 (gpointer self) {
	return self ? fso_framework_plugin_info_dup (self) : NULL;
}


static void _fso_framework_plugin_info_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (fso_framework_plugin_info_free (var), NULL));
}


static void _g_list_free__fso_framework_plugin_info_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _fso_framework_plugin_info_free0_, NULL);
	g_list_free (self);
}


static GList* fso_framework_abstract_subsystem_real_pluginsInfo (FsoFrameworkSubsystem* base) {
	FsoFrameworkAbstractSubsystem * self;
	GList* result = NULL;
	GList* list;
	GList* _tmp0_;
	self = (FsoFrameworkAbstractSubsystem*) base;
	list = NULL;
	_tmp0_ = self->priv->_plugins;
	{
		GList* plugin_collection = NULL;
		GList* plugin_it = NULL;
		plugin_collection = _tmp0_;
		for (plugin_it = plugin_collection; plugin_it != NULL; plugin_it = plugin_it->next) {
			FsoFrameworkPlugin* _tmp1_;
			FsoFrameworkPlugin* plugin = NULL;
			_tmp1_ = _g_object_ref0 ((FsoFrameworkPlugin*) plugin_it->data);
			plugin = _tmp1_;
			{
				FsoFrameworkPlugin* _tmp2_;
				FsoFrameworkPluginInfo _tmp3_ = {0};
				FsoFrameworkPluginInfo _tmp4_;
				FsoFrameworkPluginInfo* _tmp5_;
				_tmp2_ = plugin;
				fso_framework_plugin_info (_tmp2_, &_tmp3_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _fso_framework_plugin_info_dup0 (&_tmp4_);
				list = g_list_append (list, _tmp5_);
				fso_framework_plugin_info_destroy (&_tmp4_);
				_g_object_unref0 (plugin);
			}
		}
	}
	result = list;
	return result;
}


static void fso_framework_abstract_subsystem_real_registerObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj) {
	g_return_if_fail (servicename != NULL);
	g_return_if_fail (objectpath != NULL);
	g_assert_not_reached ();
}


void fso_framework_abstract_subsystem_registerObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_CLASS (self)->registerObjectForService (self, t_type, t_dup_func, t_destroy_func, servicename, objectpath, obj);
}


static void fso_framework_abstract_subsystem_real_registerObjectForServiceWithPrefix (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj) {
	g_return_if_fail (servicename != NULL);
	g_return_if_fail (prefixpath != NULL);
	g_assert_not_reached ();
}


void fso_framework_abstract_subsystem_registerObjectForServiceWithPrefix (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefixpath, gconstpointer obj) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_CLASS (self)->registerObjectForServiceWithPrefix (self, t_type, t_dup_func, t_destroy_func, servicename, prefixpath, obj);
}


static gboolean fso_framework_abstract_subsystem_real_registerServiceObjectWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* servicename, const gchar* prefix, GObject* obj) {
	gboolean result = FALSE;
	g_return_val_if_fail (servicename != NULL, FALSE);
	g_return_val_if_fail (prefix != NULL, FALSE);
	g_return_val_if_fail (obj != NULL, FALSE);
	g_assert_not_reached ();
	return result;
}


gboolean fso_framework_abstract_subsystem_registerServiceObjectWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* servicename, const gchar* prefix, GObject* obj) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_CLASS (self)->registerServiceObjectWithPrefix (self, servicename, prefix, obj);
}


static GObject** fso_framework_abstract_subsystem_real_allObjectsWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* prefix, int* result_length1) {
	GObject** result = NULL;
	g_assert_not_reached ();
	return result;
}


GObject** fso_framework_abstract_subsystem_allObjectsWithPrefix (FsoFrameworkAbstractSubsystem* self, const gchar* prefix, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_CLASS (self)->allObjectsWithPrefix (self, prefix, result_length1);
}


static void fso_framework_abstract_subsystem_real_unregisterObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath) {
	g_return_if_fail (servicename != NULL);
	g_return_if_fail (objectpath != NULL);
	g_assert_not_reached ();
}


void fso_framework_abstract_subsystem_unregisterObjectForService (FsoFrameworkAbstractSubsystem* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_CLASS (self)->unregisterObjectForService (self, t_type, t_dup_func, t_destroy_func, servicename, objectpath);
}


static void fso_framework_abstract_subsystem_real_shutdown (FsoFrameworkSubsystem* base) {
	FsoFrameworkAbstractSubsystem * self;
	GList* _tmp0_;
	self = (FsoFrameworkAbstractSubsystem*) base;
	_tmp0_ = self->priv->_plugins;
	{
		GList* plugin_collection = NULL;
		GList* plugin_it = NULL;
		plugin_collection = _tmp0_;
		for (plugin_it = plugin_collection; plugin_it != NULL; plugin_it = plugin_it->next) {
			FsoFrameworkPlugin* _tmp1_;
			FsoFrameworkPlugin* plugin = NULL;
			_tmp1_ = _g_object_ref0 ((FsoFrameworkPlugin*) plugin_it->data);
			plugin = _tmp1_;
			{
				FsoFrameworkPlugin* _tmp2_;
				_tmp2_ = plugin;
				fso_framework_plugin_shutdown (_tmp2_);
				_g_object_unref0 (plugin);
			}
		}
	}
}


static void fso_framework_abstract_subsystem_class_init (FsoFrameworkAbstractSubsystemClass * klass) {
	fso_framework_abstract_subsystem_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkAbstractSubsystemPrivate));
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->registerObjectForService = fso_framework_abstract_subsystem_real_registerObjectForService;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->registerObjectForServiceWithPrefix = fso_framework_abstract_subsystem_real_registerObjectForServiceWithPrefix;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->registerServiceObjectWithPrefix = fso_framework_abstract_subsystem_real_registerServiceObjectWithPrefix;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->allObjectsWithPrefix = fso_framework_abstract_subsystem_real_allObjectsWithPrefix;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->unregisterObjectForService = fso_framework_abstract_subsystem_real_unregisterObjectForService;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_abstract_subsystem_finalize;
}


static void fso_framework_abstract_subsystem_fso_framework_subsystem_interface_init (FsoFrameworkSubsystemIface * iface) {
	fso_framework_abstract_subsystem_fso_framework_subsystem_parent_iface = g_type_interface_peek_parent (iface);
	iface->registerPlugins = (guint (*)(FsoFrameworkSubsystem*)) fso_framework_abstract_subsystem_real_registerPlugins;
	iface->loadPlugins = (guint (*)(FsoFrameworkSubsystem*)) fso_framework_abstract_subsystem_real_loadPlugins;
	iface->name = (gchar* (*)(FsoFrameworkSubsystem*)) fso_framework_abstract_subsystem_real_name;
	iface->pluginsInfo = (GList* (*)(FsoFrameworkSubsystem*)) fso_framework_abstract_subsystem_real_pluginsInfo;
	iface->registerObjectForService = (void (*)(FsoFrameworkSubsystem*, GType, GBoxedCopyFunc, GDestroyNotify, const gchar*, const gchar*, gconstpointer)) fso_framework_abstract_subsystem_registerObjectForService;
	iface->registerObjectForServiceWithPrefix = (void (*)(FsoFrameworkSubsystem*, GType, GBoxedCopyFunc, GDestroyNotify, const gchar*, const gchar*, gconstpointer)) fso_framework_abstract_subsystem_registerObjectForServiceWithPrefix;
	iface->allObjectsWithPrefix = (GObject** (*)(FsoFrameworkSubsystem*, const gchar*, int*)) fso_framework_abstract_subsystem_allObjectsWithPrefix;
	iface->unregisterObjectForService = (void (*)(FsoFrameworkSubsystem*, GType, GBoxedCopyFunc, GDestroyNotify, const gchar*, const gchar*)) fso_framework_abstract_subsystem_unregisterObjectForService;
	iface->shutdown = (void (*)(FsoFrameworkSubsystem*)) fso_framework_abstract_subsystem_real_shutdown;
}


static void fso_framework_abstract_subsystem_instance_init (FsoFrameworkAbstractSubsystem * self) {
	self->priv = FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_GET_PRIVATE (self);
}


static void fso_framework_abstract_subsystem_finalize (GObject* obj) {
	FsoFrameworkAbstractSubsystem * self;
	self = FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM (obj);
	_g_object_unref0 (self->logger);
	_g_free0 (self->priv->_name);
	__g_list_free__g_object_unref0_0 (self->priv->_plugins);
	G_OBJECT_CLASS (fso_framework_abstract_subsystem_parent_class)->finalize (obj);
}


/**
 * AbstractSubsystem
 */
GType fso_framework_abstract_subsystem_get_type (void) {
	static volatile gsize fso_framework_abstract_subsystem_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_abstract_subsystem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkAbstractSubsystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_abstract_subsystem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkAbstractSubsystem), 0, (GInstanceInitFunc) fso_framework_abstract_subsystem_instance_init, NULL };
		static const GInterfaceInfo fso_framework_subsystem_info = { (GInterfaceInitFunc) fso_framework_abstract_subsystem_fso_framework_subsystem_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fso_framework_abstract_subsystem_type_id;
		fso_framework_abstract_subsystem_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkAbstractSubsystem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (fso_framework_abstract_subsystem_type_id, FSO_FRAMEWORK_TYPE_SUBSYSTEM, &fso_framework_subsystem_info);
		g_once_init_leave (&fso_framework_abstract_subsystem_type_id__volatile, fso_framework_abstract_subsystem_type_id);
	}
	return fso_framework_abstract_subsystem_type_id__volatile;
}


FsoFrameworkBaseSubsystem* fso_framework_base_subsystem_construct (GType object_type, const gchar* name) {
	FsoFrameworkBaseSubsystem * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (FsoFrameworkBaseSubsystem*) fso_framework_abstract_subsystem_construct (object_type, _tmp0_);
	return self;
}


FsoFrameworkBaseSubsystem* fso_framework_base_subsystem_new (const gchar* name) {
	return fso_framework_base_subsystem_construct (FSO_FRAMEWORK_TYPE_BASE_SUBSYSTEM, name);
}


static void fso_framework_base_subsystem_class_init (FsoFrameworkBaseSubsystemClass * klass) {
	fso_framework_base_subsystem_parent_class = g_type_class_peek_parent (klass);
}


static void fso_framework_base_subsystem_instance_init (FsoFrameworkBaseSubsystem * self) {
}


/**
 * BaseSubsystem
 */
GType fso_framework_base_subsystem_get_type (void) {
	static volatile gsize fso_framework_base_subsystem_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_base_subsystem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkBaseSubsystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_base_subsystem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkBaseSubsystem), 0, (GInstanceInitFunc) fso_framework_base_subsystem_instance_init, NULL };
		GType fso_framework_base_subsystem_type_id;
		fso_framework_base_subsystem_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM, "FsoFrameworkBaseSubsystem", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_base_subsystem_type_id__volatile, fso_framework_base_subsystem_type_id);
	}
	return fso_framework_base_subsystem_type_id__volatile;
}


FsoFrameworkDBusExportObject* fso_framework_dbus_export_object_construct (GType object_type) {
	FsoFrameworkDBusExportObject* self = NULL;
	self = (FsoFrameworkDBusExportObject*) g_type_create_instance (object_type);
	return self;
}


FsoFrameworkDBusExportObject* fso_framework_dbus_export_object_new (void) {
	return fso_framework_dbus_export_object_construct (FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT);
}


static void fso_framework_value_dbus_export_object_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_framework_value_dbus_export_object_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_framework_dbus_export_object_unref (value->data[0].v_pointer);
	}
}


static void fso_framework_value_dbus_export_object_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_framework_dbus_export_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_framework_value_dbus_export_object_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_framework_value_dbus_export_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoFrameworkDBusExportObject* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_framework_dbus_export_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_framework_value_dbus_export_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoFrameworkDBusExportObject** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_framework_dbus_export_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_framework_param_spec_dbus_export_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoFrameworkParamSpecDBusExportObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_framework_value_get_dbus_export_object (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT), NULL);
	return value->data[0].v_pointer;
}


void fso_framework_value_set_dbus_export_object (GValue* value, gpointer v_object) {
	FsoFrameworkDBusExportObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_framework_dbus_export_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_dbus_export_object_unref (old);
	}
}


void fso_framework_value_take_dbus_export_object (GValue* value, gpointer v_object) {
	FsoFrameworkDBusExportObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_TYPE_DBUS_EXPORT_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_dbus_export_object_unref (old);
	}
}


static void fso_framework_dbus_export_object_class_init (FsoFrameworkDBusExportObjectClass * klass) {
	fso_framework_dbus_export_object_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_DBUS_EXPORT_OBJECT_CLASS (klass)->finalize = fso_framework_dbus_export_object_finalize;
}


static void fso_framework_dbus_export_object_instance_init (FsoFrameworkDBusExportObject * self) {
	self->ref_count = 1;
}


static void fso_framework_dbus_export_object_finalize (FsoFrameworkDBusExportObject* obj) {
	FsoFrameworkDBusExportObject * self;
	self = FSO_FRAMEWORK_DBUS_EXPORT_OBJECT (obj);
	_g_object_unref0 (self->object);
	self->registrations = (g_free (self->registrations), NULL);
}


/**
 * DBusExportObject
 **/
GType fso_framework_dbus_export_object_get_type (void) {
	static volatile gsize fso_framework_dbus_export_object_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_dbus_export_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_framework_value_dbus_export_object_init, fso_framework_value_dbus_export_object_free_value, fso_framework_value_dbus_export_object_copy_value, fso_framework_value_dbus_export_object_peek_pointer, "p", fso_framework_value_dbus_export_object_collect_value, "p", fso_framework_value_dbus_export_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkDBusExportObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_dbus_export_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkDBusExportObject), 0, (GInstanceInitFunc) fso_framework_dbus_export_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_framework_dbus_export_object_type_id;
		fso_framework_dbus_export_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoFrameworkDBusExportObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_framework_dbus_export_object_type_id__volatile, fso_framework_dbus_export_object_type_id);
	}
	return fso_framework_dbus_export_object_type_id__volatile;
}


gpointer fso_framework_dbus_export_object_ref (gpointer instance) {
	FsoFrameworkDBusExportObject* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_framework_dbus_export_object_unref (gpointer instance) {
	FsoFrameworkDBusExportObject* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_FRAMEWORK_DBUS_EXPORT_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


FsoFrameworkDBusSubsystem* fso_framework_dbus_subsystem_construct (GType object_type, const gchar* name, GBusType type) {
	FsoFrameworkDBusSubsystem * self = NULL;
	const gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashSet* _tmp4_;
	GBusType _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (FsoFrameworkDBusSubsystem*) fso_framework_abstract_subsystem_construct (object_type, _tmp0_);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->registrations);
	self->priv->registrations = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->dbusobjects);
	self->priv->dbusobjects = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->counters);
	self->priv->counters = _tmp3_;
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->busnames);
	self->priv->busnames = _tmp4_;
	_tmp5_ = type;
	self->priv->bus_type = _tmp5_;
	return self;
}


FsoFrameworkDBusSubsystem* fso_framework_dbus_subsystem_new (const gchar* name, GBusType type) {
	return fso_framework_dbus_subsystem_construct (FSO_FRAMEWORK_TYPE_DBUS_SUBSYSTEM, name, type);
}


static void fso_framework_dbus_subsystem_ensureConnection (FsoFrameworkDBusSubsystem* self) {
	GDBusConnection* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connection;
	if (_tmp0_ == NULL) {
		FsoFrameworkLogger* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GDBusConnection* _tmp12_;
		_tmp1_ = ((FsoFrameworkAbstractSubsystem*) self)->logger;
		_tmp2_ = fso_framework_logger_debug (_tmp1_, "Connection not present yet; creating.");
		g_assert (_tmp2_);
		{
			GBusType _tmp3_;
			GDBusConnection* _tmp4_ = NULL;
			GDBusConnection* _tmp5_;
			_tmp3_ = self->priv->bus_type;
			_tmp4_ = g_bus_get_sync (_tmp3_, NULL, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_g_object_unref0 (self->priv->connection);
			self->priv->connection = _tmp5_;
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = ((FsoFrameworkAbstractSubsystem*) self)->logger;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			_tmp9_ = string_to_string (_tmp8_);
			_tmp10_ = g_strconcat ("Could not connect to DBus System bus: ", _tmp9_, ". dbus-daemon started?", NULL);
			_tmp11_ = _tmp10_;
			fso_framework_logger_critical (_tmp6_, _tmp11_);
			_g_free0 (_tmp11_);
			exit (-1);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->connection;
		g_assert (_tmp12_ != NULL);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FsoFrameworkDBusSubsystem * self;
		self = _data1_->self;
		_g_free0 (_data1_->servicename);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ____lambda2_ (Block1Data* _data1_, GDBusConnection* conn, const gchar* name) {
	FsoFrameworkDBusSubsystem * self;
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	self = _data1_->self;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = ((FsoFrameworkAbstractSubsystem*) self)->logger;
	_tmp1_ = name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("Successfully claimed ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = fso_framework_logger_debug (_tmp0_, _tmp4_);
	g_assert (_tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = _data1_->servicename;
	g_signal_emit_by_name ((FsoFrameworkSubsystem*) self, "service-name-acquired", _tmp6_);
}


static void _____lambda2__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	____lambda2_ (self, connection, name);
}


static void ____lambda3_ (Block1Data* _data1_) {
	FsoFrameworkDBusSubsystem * self;
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = _data1_->self;
	_tmp0_ = ((FsoFrameworkAbstractSubsystem*) self)->logger;
	_tmp1_ = _data1_->servicename;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("Can't claim busname ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	fso_framework_logger_critical (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	exit (-1);
}


static void _____lambda3__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	____lambda3_ (self);
}


void fso_framework_dbus_subsystem_exportBusnames (FsoFrameworkDBusSubsystem* self) {
	g_return_if_fail (self != NULL);
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _servicename_it;
		_tmp0_ = self->priv->busnames;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_servicename_it = _tmp1_;
		while (TRUE) {
			Block1Data* _data1_;
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			GDBusConnection* _tmp6_;
			const gchar* _tmp7_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp2_ = _servicename_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				block1_data_unref (_data1_);
				_data1_ = NULL;
				break;
			}
			_tmp4_ = _servicename_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			_data1_->servicename = (gchar*) _tmp5_;
			_tmp6_ = self->priv->connection;
			_tmp7_ = _data1_->servicename;
			g_bus_own_name_on_connection_with_closures (_tmp6_, _tmp7_, 0, (GClosure*) ((_____lambda2__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _____lambda2__gbus_name_acquired_callback, block1_data_ref (_data1_), block1_data_unref)), (GClosure*) ((_____lambda3__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _____lambda3__gbus_name_lost_callback, block1_data_ref (_data1_), block1_data_unref)));
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_g_object_unref0 (_servicename_it);
	}
}


static gpointer _fso_framework_dbus_subsystem_service_registration_ref0 (gpointer self) {
	return self ? fso_framework_dbus_subsystem_service_registration_ref (self) : NULL;
}


static void fso_framework_dbus_subsystem_real_unregisterObjectForService (FsoFrameworkAbstractSubsystem* base, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath) {
	FsoFrameworkDBusSubsystem * self;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* cleanedname;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	GeeArrayList* registrationsForService;
	GeeArrayList* _tmp8_;
	FsoFrameworkDBusSubsystemServiceRegistration* registrationToRemove;
	FsoFrameworkDBusSubsystemServiceRegistration* _tmp32_;
	self = (FsoFrameworkDBusSubsystem*) base;
	g_return_if_fail (servicename != NULL);
	g_return_if_fail (objectpath != NULL);
	fso_framework_dbus_subsystem_ensureConnection (self);
	_tmp0_ = objectpath;
	_tmp1_ = string_replace (_tmp0_, "-", "_");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, ":", "_");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	cleanedname = _tmp4_;
	_tmp5_ = self->priv->registrations;
	_tmp6_ = servicename;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
	registrationsForService = (GeeArrayList*) _tmp7_;
	_tmp8_ = registrationsForService;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (registrationsForService);
		_g_free0 (cleanedname);
		return;
	}
	registrationToRemove = NULL;
	{
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _registration_list;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _registration_size;
		gint _registration_index;
		_tmp9_ = registrationsForService;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_registration_list = _tmp10_;
		_tmp11_ = _registration_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_registration_size = _tmp13_;
		_registration_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_ = NULL;
			FsoFrameworkDBusSubsystemServiceRegistration* registration;
			gboolean _tmp20_ = FALSE;
			FsoFrameworkDBusSubsystemServiceRegistration* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gboolean _tmp26_;
			_tmp14_ = _registration_index;
			_registration_index = _tmp14_ + 1;
			_tmp15_ = _registration_index;
			_tmp16_ = _registration_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _registration_list;
			_tmp18_ = _registration_index;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
			registration = (FsoFrameworkDBusSubsystemServiceRegistration*) _tmp19_;
			_tmp21_ = registration;
			_tmp22_ = _tmp21_->object_path;
			_tmp23_ = objectpath;
			if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
				FsoFrameworkDBusSubsystemServiceRegistration* _tmp24_;
				GType _tmp25_;
				_tmp24_ = registration;
				_tmp25_ = _tmp24_->iface_type;
				_tmp20_ = _tmp25_ == t_type;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp26_ = _tmp20_;
			if (_tmp26_) {
				GDBusConnection* _tmp27_;
				FsoFrameworkDBusSubsystemServiceRegistration* _tmp28_;
				guint _tmp29_;
				FsoFrameworkDBusSubsystemServiceRegistration* _tmp30_;
				FsoFrameworkDBusSubsystemServiceRegistration* _tmp31_;
				_tmp27_ = self->priv->connection;
				_tmp28_ = registration;
				_tmp29_ = _tmp28_->ref_id;
				g_dbus_connection_unregister_object (_tmp27_, _tmp29_);
				_tmp30_ = registration;
				_tmp31_ = _fso_framework_dbus_subsystem_service_registration_ref0 (_tmp30_);
				_fso_framework_dbus_subsystem_service_registration_unref0 (registrationToRemove);
				registrationToRemove = _tmp31_;
				_fso_framework_dbus_subsystem_service_registration_unref0 (registration);
				break;
			}
			_fso_framework_dbus_subsystem_service_registration_unref0 (registration);
		}
		_g_object_unref0 (_registration_list);
	}
	_tmp32_ = registrationToRemove;
	if (_tmp32_ != NULL) {
		GeeArrayList* _tmp33_;
		FsoFrameworkDBusSubsystemServiceRegistration* _tmp34_;
		_tmp33_ = registrationsForService;
		_tmp34_ = registrationToRemove;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, _tmp34_);
	}
	_fso_framework_dbus_subsystem_service_registration_unref0 (registrationToRemove);
	_g_object_unref0 (registrationsForService);
	_g_free0 (cleanedname);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FsoFrameworkDBusSubsystem * self;
		GType t_type;
		GBoxedCopyFunc t_dup_func;
		GDestroyNotify t_destroy_func;
		self = _data2_->self;
		t_type = _data2_->t_type;
		t_dup_func = _data2_->t_dup_func;
		t_destroy_func = _data2_->t_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error) {
	void *func;
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
	if (!func) {
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
		return 0;
	}
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
}


static gboolean ___lambda4_ (Block2Data* _data2_) {
	FsoFrameworkDBusSubsystem * self;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gboolean result = FALSE;
	self = _data2_->self;
	t_type = _data2_->t_type;
	t_dup_func = _data2_->t_dup_func;
	t_destroy_func = _data2_->t_destroy_func;
	fso_framework_dbus_subsystem_exportBusnames (self);
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ (self);
	return result;
}


static void fso_framework_dbus_subsystem_real_registerObjectForService (FsoFrameworkAbstractSubsystem* base, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* objectpath, gconstpointer obj) {
	FsoFrameworkDBusSubsystem * self;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* cleanedname;
	FsoFrameworkLogger* _tmp32_;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeHashSet* _tmp40_;
	const gchar* _tmp41_;
	guint _tmp42_;
	GError * _inner_error_ = NULL;
	self = (FsoFrameworkDBusSubsystem*) base;
	g_return_if_fail (servicename != NULL);
	g_return_if_fail (objectpath != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->t_type = t_type;
	_data2_->t_dup_func = t_dup_func;
	_data2_->t_destroy_func = t_destroy_func;
	fso_framework_dbus_subsystem_ensureConnection (self);
	_tmp0_ = objectpath;
	_tmp1_ = string_replace (_tmp0_, "-", "_");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, ":", "_");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	cleanedname = _tmp4_;
	{
		GDBusConnection* _tmp5_;
		gconstpointer _tmp6_;
		guint _tmp7_ = 0U;
		guint refid;
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		gpointer _tmp10_ = NULL;
		GeeArrayList* registrationsForService;
		GeeArrayList* _tmp11_;
		gchar* _tmp16_;
		FsoFrameworkDBusSubsystemServiceRegistration* _tmp17_ = NULL;
		FsoFrameworkDBusSubsystemServiceRegistration* registration;
		GeeArrayList* _tmp18_;
		FsoFrameworkDBusSubsystemServiceRegistration* _tmp19_;
		GeeHashMap* _tmp20_;
		gconstpointer _tmp21_;
		_tmp5_ = self->priv->connection;
		_tmp6_ = obj;
		_tmp7_ = _vala_g_dbus_connection_register_object (t_type, _tmp6_, _tmp5_, cleanedname, &_inner_error_);
		refid = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp8_ = self->priv->registrations;
		_tmp9_ = servicename;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
		registrationsForService = (GeeArrayList*) _tmp10_;
		_tmp11_ = registrationsForService;
		if (_tmp11_ == NULL) {
			GeeArrayList* _tmp12_;
			GeeHashMap* _tmp13_;
			const gchar* _tmp14_;
			GeeArrayList* _tmp15_;
			_tmp12_ = gee_array_list_new (FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION, (GBoxedCopyFunc) fso_framework_dbus_subsystem_service_registration_ref, fso_framework_dbus_subsystem_service_registration_unref, NULL);
			_g_object_unref0 (registrationsForService);
			registrationsForService = _tmp12_;
			_tmp13_ = self->priv->registrations;
			_tmp14_ = servicename;
			_tmp15_ = registrationsForService;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, _tmp15_);
		}
		_tmp16_ = g_strdup (cleanedname);
		_tmp17_ = fso_framework_dbus_subsystem_service_registration_new ();
		_tmp17_->ref_id = refid;
		_g_free0 (_tmp17_->object_path);
		_tmp17_->object_path = _tmp16_;
		_tmp17_->iface_type = t_type;
		registration = _tmp17_;
		_tmp18_ = registrationsForService;
		_tmp19_ = registration;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
		_tmp20_ = self->priv->dbusobjects;
		_tmp21_ = obj;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, cleanedname, G_OBJECT (_tmp21_));
		_fso_framework_dbus_subsystem_service_registration_unref0 (registration);
		_g_object_unref0 (registrationsForService);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp22_;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = ((FsoFrameworkAbstractSubsystem*) self)->logger;
		_tmp23_ = g_type_name (t_type);
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = objectpath;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		_tmp29_ = string_to_string (_tmp28_);
		_tmp30_ = g_strconcat ("Could not register ", _tmp24_, " at ", _tmp26_, ": ", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		fso_framework_logger_error (_tmp22_, _tmp31_);
		_g_free0 (_tmp31_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (cleanedname);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp32_ = ((FsoFrameworkAbstractSubsystem*) self)->logger;
	_tmp33_ = g_type_name (t_type);
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = objectpath;
	_tmp36_ = string_to_string (_tmp35_);
	_tmp37_ = g_strconcat ("Registered ", _tmp34_, " at ", _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = fso_framework_logger_debug (_tmp32_, _tmp38_);
	g_assert (_tmp39_);
	_g_free0 (_tmp38_);
	_tmp40_ = self->priv->busnames;
	_tmp41_ = servicename;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
	_tmp42_ = self->priv->watch;
	if (_tmp42_ == ((guint) 0)) {
		guint _tmp43_ = 0U;
		_tmp43_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		self->priv->watch = _tmp43_;
	}
	_g_free0 (cleanedname);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void fso_framework_dbus_subsystem_real_registerObjectForServiceWithPrefix (FsoFrameworkAbstractSubsystem* base, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* servicename, const gchar* prefix, gconstpointer obj) {
	FsoFrameworkDBusSubsystem * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* hash;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_ = NULL;
	gint counter;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gconstpointer _tmp15_;
	GeeHashMap* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	self = (FsoFrameworkDBusSubsystem*) base;
	g_return_if_fail (servicename != NULL);
	g_return_if_fail (prefix != NULL);
	_tmp0_ = servicename;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = prefix;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat (_tmp1_, ":", _tmp3_, NULL);
	hash = _tmp4_;
	_tmp5_ = self->priv->counters;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, hash);
	counter = GPOINTER_TO_INT (_tmp6_);
	_tmp7_ = servicename;
	_tmp8_ = prefix;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = counter;
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp9_, "/", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = obj;
	fso_framework_abstract_subsystem_registerObjectForService ((FsoFrameworkAbstractSubsystem*) self, t_type, (GBoxedCopyFunc) t_dup_func, t_destroy_func, _tmp7_, _tmp14_, _tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp16_ = self->priv->counters;
	_tmp17_ = counter;
	counter = _tmp17_ + 1;
	_tmp18_ = counter;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, hash, _tmp18_);
	_g_free0 (hash);
}


GDBusConnection* fso_framework_dbus_subsystem_dbusConnection (FsoFrameworkDBusSubsystem* self) {
	GDBusConnection* result = NULL;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	fso_framework_dbus_subsystem_ensureConnection (self);
	_tmp0_ = self->priv->connection;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (GObject*** array, int* length, int* size, GObject* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GObject*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static GObject** fso_framework_dbus_subsystem_real_allObjectsWithPrefix (FsoFrameworkAbstractSubsystem* base, const gchar* prefix, int* result_length1) {
	FsoFrameworkDBusSubsystem * self;
	GObject** result = NULL;
	GObject** _tmp0_ = NULL;
	GObject** _result_;
	gint _result__length1;
	gint __result__size_;
	GObject** _tmp21_;
	gint _tmp21__length1;
	self = (FsoFrameworkDBusSubsystem*) base;
	_tmp0_ = g_new0 (GObject*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _objectname_it;
		_tmp1_ = self->priv->dbusobjects;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_objectname_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* objectname;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			gboolean _tmp16_;
			_tmp7_ = _objectname_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _objectname_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			objectname = (gchar*) _tmp10_;
			_tmp12_ = prefix;
			if (_tmp12_ == NULL) {
				_tmp11_ = TRUE;
			} else {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp13_ = objectname;
				_tmp14_ = prefix;
				_tmp15_ = g_str_has_prefix (_tmp13_, _tmp14_);
				_tmp11_ = _tmp15_;
			}
			_tmp16_ = _tmp11_;
			if (_tmp16_) {
				GObject** _tmp17_;
				gint _tmp17__length1;
				GeeHashMap* _tmp18_;
				const gchar* _tmp19_;
				gpointer _tmp20_ = NULL;
				_tmp17_ = _result_;
				_tmp17__length1 = _result__length1;
				_tmp18_ = self->priv->dbusobjects;
				_tmp19_ = objectname;
				_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
				_vala_array_add1 (&_result_, &_result__length1, &__result__size_, (GObject*) _tmp20_);
			}
			_g_free0 (objectname);
		}
		_g_object_unref0 (_objectname_it);
	}
	_tmp21_ = _result_;
	_tmp21__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	return result;
}


static FsoFrameworkDBusSubsystemServiceRegistration* fso_framework_dbus_subsystem_service_registration_construct (GType object_type) {
	FsoFrameworkDBusSubsystemServiceRegistration* self = NULL;
	self = (FsoFrameworkDBusSubsystemServiceRegistration*) g_type_create_instance (object_type);
	return self;
}


static FsoFrameworkDBusSubsystemServiceRegistration* fso_framework_dbus_subsystem_service_registration_new (void) {
	return fso_framework_dbus_subsystem_service_registration_construct (FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION);
}


static void fso_framework_dbus_subsystem_value_service_registration_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_framework_dbus_subsystem_value_service_registration_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_framework_dbus_subsystem_service_registration_unref (value->data[0].v_pointer);
	}
}


static void fso_framework_dbus_subsystem_value_service_registration_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_framework_dbus_subsystem_service_registration_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_framework_dbus_subsystem_value_service_registration_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_framework_dbus_subsystem_value_service_registration_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoFrameworkDBusSubsystemServiceRegistration* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_framework_dbus_subsystem_service_registration_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_framework_dbus_subsystem_value_service_registration_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoFrameworkDBusSubsystemServiceRegistration** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_framework_dbus_subsystem_service_registration_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* fso_framework_dbus_subsystem_param_spec_service_registration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoFrameworkDBusSubsystemParamSpecServiceRegistration* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer fso_framework_dbus_subsystem_value_get_service_registration (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION), NULL);
	return value->data[0].v_pointer;
}


static void fso_framework_dbus_subsystem_value_set_service_registration (GValue* value, gpointer v_object) {
	FsoFrameworkDBusSubsystemServiceRegistration* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_framework_dbus_subsystem_service_registration_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_dbus_subsystem_service_registration_unref (old);
	}
}


static void fso_framework_dbus_subsystem_value_take_service_registration (GValue* value, gpointer v_object) {
	FsoFrameworkDBusSubsystemServiceRegistration* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_DBUS_SUBSYSTEM_TYPE_SERVICE_REGISTRATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_dbus_subsystem_service_registration_unref (old);
	}
}


static void fso_framework_dbus_subsystem_service_registration_class_init (FsoFrameworkDBusSubsystemServiceRegistrationClass * klass) {
	fso_framework_dbus_subsystem_service_registration_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION_CLASS (klass)->finalize = fso_framework_dbus_subsystem_service_registration_finalize;
}


static void fso_framework_dbus_subsystem_service_registration_instance_init (FsoFrameworkDBusSubsystemServiceRegistration * self) {
	self->ref_count = 1;
}


static void fso_framework_dbus_subsystem_service_registration_finalize (FsoFrameworkDBusSubsystemServiceRegistration* obj) {
	FsoFrameworkDBusSubsystemServiceRegistration * self;
	self = FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION (obj);
	_g_free0 (self->object_path);
}


static GType fso_framework_dbus_subsystem_service_registration_get_type (void) {
	static volatile gsize fso_framework_dbus_subsystem_service_registration_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_dbus_subsystem_service_registration_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_framework_dbus_subsystem_value_service_registration_init, fso_framework_dbus_subsystem_value_service_registration_free_value, fso_framework_dbus_subsystem_value_service_registration_copy_value, fso_framework_dbus_subsystem_value_service_registration_peek_pointer, "p", fso_framework_dbus_subsystem_value_service_registration_collect_value, "p", fso_framework_dbus_subsystem_value_service_registration_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkDBusSubsystemServiceRegistrationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_dbus_subsystem_service_registration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkDBusSubsystemServiceRegistration), 0, (GInstanceInitFunc) fso_framework_dbus_subsystem_service_registration_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_framework_dbus_subsystem_service_registration_type_id;
		fso_framework_dbus_subsystem_service_registration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoFrameworkDBusSubsystemServiceRegistration", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_framework_dbus_subsystem_service_registration_type_id__volatile, fso_framework_dbus_subsystem_service_registration_type_id);
	}
	return fso_framework_dbus_subsystem_service_registration_type_id__volatile;
}


static gpointer fso_framework_dbus_subsystem_service_registration_ref (gpointer instance) {
	FsoFrameworkDBusSubsystemServiceRegistration* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void fso_framework_dbus_subsystem_service_registration_unref (gpointer instance) {
	FsoFrameworkDBusSubsystemServiceRegistration* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_FRAMEWORK_DBUS_SUBSYSTEM_SERVICE_REGISTRATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void fso_framework_dbus_subsystem_class_init (FsoFrameworkDBusSubsystemClass * klass) {
	fso_framework_dbus_subsystem_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkDBusSubsystemPrivate));
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->unregisterObjectForService = fso_framework_dbus_subsystem_real_unregisterObjectForService;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->registerObjectForService = fso_framework_dbus_subsystem_real_registerObjectForService;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->registerObjectForServiceWithPrefix = fso_framework_dbus_subsystem_real_registerObjectForServiceWithPrefix;
	FSO_FRAMEWORK_ABSTRACT_SUBSYSTEM_CLASS (klass)->allObjectsWithPrefix = fso_framework_dbus_subsystem_real_allObjectsWithPrefix;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_dbus_subsystem_finalize;
}


static void fso_framework_dbus_subsystem_instance_init (FsoFrameworkDBusSubsystem * self) {
	self->priv = FSO_FRAMEWORK_DBUS_SUBSYSTEM_GET_PRIVATE (self);
}


static void fso_framework_dbus_subsystem_finalize (GObject* obj) {
	FsoFrameworkDBusSubsystem * self;
	self = FSO_FRAMEWORK_DBUS_SUBSYSTEM (obj);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->registrations);
	_g_object_unref0 (self->priv->dbusobjects);
	_g_object_unref0 (self->priv->counters);
	_g_object_unref0 (self->priv->busnames);
	G_OBJECT_CLASS (fso_framework_dbus_subsystem_parent_class)->finalize (obj);
}


/**
 * DBusSubsystem
 */
GType fso_framework_dbus_subsystem_get_type (void) {
	static volatile gsize fso_framework_dbus_subsystem_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_dbus_subsystem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkDBusSubsystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_dbus_subsystem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkDBusSubsystem), 0, (GInstanceInitFunc) fso_framework_dbus_subsystem_instance_init, NULL };
		GType fso_framework_dbus_subsystem_type_id;
		fso_framework_dbus_subsystem_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_SUBSYSTEM, "FsoFrameworkDBusSubsystem", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_dbus_subsystem_type_id__volatile, fso_framework_dbus_subsystem_type_id);
	}
	return fso_framework_dbus_subsystem_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



