; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=thumbv8m.main -mcpu=cortex-m33 -loop-unroll -S < %s -o - | FileCheck %s
; RUN: opt -mtriple=thumbv7em -mcpu=cortex-m7 -loop-unroll -S < %s -o - | FileCheck %s

define void @test_three_blocks(i32* nocapture %Output,
;
; CHECK-LABEL: @test_three_blocks(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP8:%.*]] = icmp eq i32 [[MAXJ:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP8]], label [[FOR_COND_CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[MAXJ]], -1
; CHECK-NEXT:    [[XTRAITER:%.*]] = and i32 [[MAXJ]], 3
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[TMP0]], 3
; CHECK-NEXT:    br i1 [[TMP1]], label [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA:%.*]], label [[FOR_BODY_PREHEADER_NEW:%.*]]
; CHECK:       for.body.preheader.new:
; CHECK-NEXT:    [[UNROLL_ITER:%.*]] = sub i32 [[MAXJ]], [[XTRAITER]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond.cleanup.loopexit.unr-lcssa.loopexit:
; CHECK-NEXT:    [[TEMP_1_LCSSA_PH_PH:%.*]] = phi i32 [ [[TEMP_1_3:%.*]], [[FOR_INC_3:%.*]] ]
; CHECK-NEXT:    [[J_010_UNR_PH:%.*]] = phi i32 [ [[INC_3:%.*]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[TEMP_09_UNR_PH:%.*]] = phi i32 [ [[TEMP_1_3]], [[FOR_INC_3]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA]]
; CHECK:       for.cond.cleanup.loopexit.unr-lcssa:
; CHECK-NEXT:    [[TEMP_1_LCSSA_PH:%.*]] = phi i32 [ undef, [[FOR_BODY_PREHEADER]] ], [ [[TEMP_1_LCSSA_PH_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT:%.*]] ]
; CHECK-NEXT:    [[J_010_UNR:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER]] ], [ [[J_010_UNR_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]] ]
; CHECK-NEXT:    [[TEMP_09_UNR:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER]] ], [ [[TEMP_09_UNR_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]] ]
; CHECK-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i32 [[XTRAITER]], 0
; CHECK-NEXT:    br i1 [[LCMP_MOD]], label [[FOR_BODY_EPIL_PREHEADER:%.*]], label [[FOR_COND_CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.body.epil.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_EPIL:%.*]]
; CHECK:       for.body.epil:
; CHECK-NEXT:    [[ARRAYIDX_EPIL:%.*]] = getelementptr inbounds i32, i32* [[CONDITION:%.*]], i32 [[J_010_UNR]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARRAYIDX_EPIL]], align 4
; CHECK-NEXT:    [[TOBOOL_EPIL:%.*]] = icmp eq i32 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_EPIL]], label [[FOR_INC_EPIL:%.*]], label [[IF_THEN_EPIL:%.*]]
; CHECK:       if.then.epil:
; CHECK-NEXT:    [[ARRAYIDX1_EPIL:%.*]] = getelementptr inbounds i32, i32* [[INPUT:%.*]], i32 [[J_010_UNR]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARRAYIDX1_EPIL]], align 4
; CHECK-NEXT:    [[ADD_EPIL:%.*]] = add i32 [[TMP3]], [[TEMP_09_UNR]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL]]
; CHECK:       for.inc.epil:
; CHECK-NEXT:    [[TEMP_1_EPIL:%.*]] = phi i32 [ [[ADD_EPIL]], [[IF_THEN_EPIL]] ], [ [[TEMP_09_UNR]], [[FOR_BODY_EPIL]] ]
; CHECK-NEXT:    [[INC_EPIL:%.*]] = add nuw i32 [[J_010_UNR]], 1
; CHECK-NEXT:    [[EPIL_ITER_CMP:%.*]] = icmp ne i32 1, [[XTRAITER]]
; CHECK-NEXT:    br i1 [[EPIL_ITER_CMP]], label [[FOR_BODY_EPIL_1:%.*]], label [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA:%.*]]
; CHECK:       for.body.epil.1:
; CHECK-NEXT:    [[ARRAYIDX_EPIL_1:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_EPIL]]
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, i32* [[ARRAYIDX_EPIL_1]], align 4
; CHECK-NEXT:    [[TOBOOL_EPIL_1:%.*]] = icmp eq i32 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_EPIL_1]], label [[FOR_INC_EPIL_1:%.*]], label [[IF_THEN_EPIL_1:%.*]]
; CHECK:       if.then.epil.1:
; CHECK-NEXT:    [[ARRAYIDX1_EPIL_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_EPIL]]
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[ARRAYIDX1_EPIL_1]], align 4
; CHECK-NEXT:    [[ADD_EPIL_1:%.*]] = add i32 [[TMP5]], [[TEMP_1_EPIL]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL_1]]
; CHECK:       for.inc.epil.1:
; CHECK-NEXT:    [[TEMP_1_EPIL_1:%.*]] = phi i32 [ [[ADD_EPIL_1]], [[IF_THEN_EPIL_1]] ], [ [[TEMP_1_EPIL]], [[FOR_BODY_EPIL_1]] ]
; CHECK-NEXT:    [[INC_EPIL_1:%.*]] = add nuw i32 [[INC_EPIL]], 1
; CHECK-NEXT:    [[EPIL_ITER_CMP_1:%.*]] = icmp ne i32 2, [[XTRAITER]]
; CHECK-NEXT:    br i1 [[EPIL_ITER_CMP_1]], label [[FOR_BODY_EPIL_2:%.*]], label [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA]]
; CHECK:       for.body.epil.2:
; CHECK-NEXT:    [[ARRAYIDX_EPIL_2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_EPIL_1]]
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX_EPIL_2]], align 4
; CHECK-NEXT:    [[TOBOOL_EPIL_2:%.*]] = icmp eq i32 [[TMP6]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_EPIL_2]], label [[FOR_INC_EPIL_2:%.*]], label [[IF_THEN_EPIL_2:%.*]]
; CHECK:       if.then.epil.2:
; CHECK-NEXT:    [[ARRAYIDX1_EPIL_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_EPIL_1]]
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX1_EPIL_2]], align 4
; CHECK-NEXT:    [[ADD_EPIL_2:%.*]] = add i32 [[TMP7]], [[TEMP_1_EPIL_1]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL_2]]
; CHECK:       for.inc.epil.2:
; CHECK-NEXT:    [[TEMP_1_EPIL_2:%.*]] = phi i32 [ [[ADD_EPIL_2]], [[IF_THEN_EPIL_2]] ], [ [[TEMP_1_EPIL_1]], [[FOR_BODY_EPIL_2]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA]]
; CHECK:       for.cond.cleanup.loopexit.epilog-lcssa:
; CHECK-NEXT:    [[TEMP_1_LCSSA_PH1:%.*]] = phi i32 [ [[TEMP_1_EPIL]], [[FOR_INC_EPIL]] ], [ [[TEMP_1_EPIL_1]], [[FOR_INC_EPIL_1]] ], [ [[TEMP_1_EPIL_2]], [[FOR_INC_EPIL_2]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP_LOOPEXIT]]
; CHECK:       for.cond.cleanup.loopexit:
; CHECK-NEXT:    [[TEMP_1_LCSSA:%.*]] = phi i32 [ [[TEMP_1_LCSSA_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA]] ], [ [[TEMP_1_LCSSA_PH1]], [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    [[TEMP_0_LCSSA:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[TEMP_1_LCSSA]], [[FOR_COND_CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    store i32 [[TEMP_0_LCSSA]], i32* [[OUTPUT:%.*]], align 4
; CHECK-NEXT:    ret void
; CHECK:       for.body:
; CHECK-NEXT:    [[J_010:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER_NEW]] ], [ [[INC_3]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[TEMP_09:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER_NEW]] ], [ [[TEMP_1_3]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[NITER:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER_NEW]] ], [ [[NITER_NEXT_3:%.*]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[J_010]]
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[TMP8]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[FOR_INC:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[J_010]]
; CHECK-NEXT:    [[TMP9:%.*]] = load i32, i32* [[ARRAYIDX1]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[TMP9]], [[TEMP_09]]
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[TEMP_1:%.*]] = phi i32 [ [[ADD]], [[IF_THEN]] ], [ [[TEMP_09]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INC:%.*]] = add nuw nsw i32 [[J_010]], 1
; CHECK-NEXT:    [[NITER_NEXT:%.*]] = add nuw nsw i32 [[NITER]], 1
; CHECK-NEXT:    [[ARRAYIDX_1:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC]]
; CHECK-NEXT:    [[TMP10:%.*]] = load i32, i32* [[ARRAYIDX_1]], align 4
; CHECK-NEXT:    [[TOBOOL_1:%.*]] = icmp eq i32 [[TMP10]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_1]], label [[FOR_INC_1:%.*]], label [[IF_THEN_1:%.*]]
; CHECK:       if.then.1:
; CHECK-NEXT:    [[ARRAYIDX1_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC]]
; CHECK-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX1_1]], align 4
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[TMP11]], [[TEMP_1]]
; CHECK-NEXT:    br label [[FOR_INC_1]]
; CHECK:       for.inc.1:
; CHECK-NEXT:    [[TEMP_1_1:%.*]] = phi i32 [ [[ADD_1]], [[IF_THEN_1]] ], [ [[TEMP_1]], [[FOR_INC]] ]
; CHECK-NEXT:    [[INC_1:%.*]] = add nuw nsw i32 [[INC]], 1
; CHECK-NEXT:    [[NITER_NEXT_1:%.*]] = add nuw nsw i32 [[NITER_NEXT]], 1
; CHECK-NEXT:    [[ARRAYIDX_2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_1]]
; CHECK-NEXT:    [[TMP12:%.*]] = load i32, i32* [[ARRAYIDX_2]], align 4
; CHECK-NEXT:    [[TOBOOL_2:%.*]] = icmp eq i32 [[TMP12]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_2]], label [[FOR_INC_2:%.*]], label [[IF_THEN_2:%.*]]
; CHECK:       if.then.2:
; CHECK-NEXT:    [[ARRAYIDX1_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_1]]
; CHECK-NEXT:    [[TMP13:%.*]] = load i32, i32* [[ARRAYIDX1_2]], align 4
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[TMP13]], [[TEMP_1_1]]
; CHECK-NEXT:    br label [[FOR_INC_2]]
; CHECK:       for.inc.2:
; CHECK-NEXT:    [[TEMP_1_2:%.*]] = phi i32 [ [[ADD_2]], [[IF_THEN_2]] ], [ [[TEMP_1_1]], [[FOR_INC_1]] ]
; CHECK-NEXT:    [[INC_2:%.*]] = add nuw nsw i32 [[INC_1]], 1
; CHECK-NEXT:    [[NITER_NEXT_2:%.*]] = add nuw nsw i32 [[NITER_NEXT_1]], 1
; CHECK-NEXT:    [[ARRAYIDX_3:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_2]]
; CHECK-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARRAYIDX_3]], align 4
; CHECK-NEXT:    [[TOBOOL_3:%.*]] = icmp eq i32 [[TMP14]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_3]], label [[FOR_INC_3]], label [[IF_THEN_3:%.*]]
; CHECK:       if.then.3:
; CHECK-NEXT:    [[ARRAYIDX1_3:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_2]]
; CHECK-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX1_3]], align 4
; CHECK-NEXT:    [[ADD_3:%.*]] = add i32 [[TMP15]], [[TEMP_1_2]]
; CHECK-NEXT:    br label [[FOR_INC_3]]
; CHECK:       for.inc.3:
; CHECK-NEXT:    [[TEMP_1_3]] = phi i32 [ [[ADD_3]], [[IF_THEN_3]] ], [ [[TEMP_1_2]], [[FOR_INC_2]] ]
; CHECK-NEXT:    [[INC_3]] = add nuw i32 [[INC_2]], 1
; CHECK-NEXT:    [[NITER_NEXT_3]] = add i32 [[NITER_NEXT_2]], 1
; CHECK-NEXT:    [[NITER_NCMP_3:%.*]] = icmp eq i32 [[NITER_NEXT_3]], [[UNROLL_ITER]]
; CHECK-NEXT:    br i1 [[NITER_NCMP_3]], label [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]], label [[FOR_BODY]]
;
  i32* nocapture readonly %Condition,
  i32* nocapture readonly %Input,
  i32 %MaxJ) {
entry:
  %cmp8 = icmp eq i32 %MaxJ, 0
  br i1 %cmp8, label %for.cond.cleanup, label %for.body.preheader

for.body.preheader:                               ; preds = %entry
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.inc, %entry
  %temp.0.lcssa = phi i32 [ 0, %entry ], [ %temp.1, %for.inc ]
  store i32 %temp.0.lcssa, i32* %Output, align 4
  ret void

for.body:                                         ; preds = %for.body.preheader, %for.inc
  %j.010 = phi i32 [ %inc, %for.inc ], [ 0, %for.body.preheader ]
  %temp.09 = phi i32 [ %temp.1, %for.inc ], [ 0, %for.body.preheader ]
  %arrayidx = getelementptr inbounds i32, i32* %Condition, i32 %j.010
  %0 = load i32, i32* %arrayidx, align 4
  %tobool = icmp eq i32 %0, 0
  br i1 %tobool, label %for.inc, label %if.then

if.then:                                          ; preds = %for.body
  %arrayidx1 = getelementptr inbounds i32, i32* %Input, i32 %j.010
  %1 = load i32, i32* %arrayidx1, align 4
  %add = add i32 %1, %temp.09
  br label %for.inc

for.inc:                                          ; preds = %for.body, %if.then
  %temp.1 = phi i32 [ %add, %if.then ], [ %temp.09, %for.body ]
  %inc = add nuw i32 %j.010, 1
  %exitcond = icmp eq i32 %inc, %MaxJ
  br i1 %exitcond, label %for.cond.cleanup, label %for.body
}

define void @test_two_exits(i32* nocapture %Output,
;
; CHECK-LABEL: @test_two_exits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP14:%.*]] = icmp eq i32 [[MAXJ:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP14]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[J_016:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER]] ], [ [[INC_3:%.*]], [[IF_END_3:%.*]] ]
; CHECK-NEXT:    [[TEMP_015:%.*]] = phi i32 [ 0, [[FOR_BODY_PREHEADER]] ], [ [[TEMP_0_ADD_3:%.*]], [[IF_END_3]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[INPUT:%.*]], i32 [[J_016]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[TMP0]], 65535
; CHECK-NEXT:    br i1 [[CMP1]], label [[CLEANUP_LOOPEXIT:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION:%.*]], i32 [[J_016]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    [[ADD:%.*]] = select i1 [[TOBOOL]], i32 0, i32 [[TMP0]]
; CHECK-NEXT:    [[TEMP_0_ADD:%.*]] = add i32 [[ADD]], [[TEMP_015]]
; CHECK-NEXT:    [[INC:%.*]] = add nuw nsw i32 [[J_016]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[INC]], [[MAXJ]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY_1:%.*]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       for.body.1:
; CHECK-NEXT:    [[ARRAYIDX_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARRAYIDX_1]], align 4
; CHECK-NEXT:    [[CMP1_1:%.*]] = icmp ugt i32 [[TMP2]], 65535
; CHECK-NEXT:    br i1 [[CMP1_1]], label [[CLEANUP_LOOPEXIT]], label [[IF_END_1:%.*]]
; CHECK:       if.end.1:
; CHECK-NEXT:    [[ARRAYIDX2_1:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARRAYIDX2_1]], align 4
; CHECK-NEXT:    [[TOBOOL_1:%.*]] = icmp eq i32 [[TMP3]], 0
; CHECK-NEXT:    [[ADD_1:%.*]] = select i1 [[TOBOOL_1]], i32 0, i32 [[TMP2]]
; CHECK-NEXT:    [[TEMP_0_ADD_1:%.*]] = add i32 [[ADD_1]], [[TEMP_0_ADD]]
; CHECK-NEXT:    [[INC_1:%.*]] = add nuw nsw i32 [[INC]], 1
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp ult i32 [[INC_1]], [[MAXJ]]
; CHECK-NEXT:    br i1 [[CMP_1]], label [[FOR_BODY_2:%.*]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       for.body.2:
; CHECK-NEXT:    [[ARRAYIDX_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_1]]
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, i32* [[ARRAYIDX_2]], align 4
; CHECK-NEXT:    [[CMP1_2:%.*]] = icmp ugt i32 [[TMP4]], 65535
; CHECK-NEXT:    br i1 [[CMP1_2]], label [[CLEANUP_LOOPEXIT]], label [[IF_END_2:%.*]]
; CHECK:       if.end.2:
; CHECK-NEXT:    [[ARRAYIDX2_2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_1]]
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[ARRAYIDX2_2]], align 4
; CHECK-NEXT:    [[TOBOOL_2:%.*]] = icmp eq i32 [[TMP5]], 0
; CHECK-NEXT:    [[ADD_2:%.*]] = select i1 [[TOBOOL_2]], i32 0, i32 [[TMP4]]
; CHECK-NEXT:    [[TEMP_0_ADD_2:%.*]] = add i32 [[ADD_2]], [[TEMP_0_ADD_1]]
; CHECK-NEXT:    [[INC_2:%.*]] = add nuw nsw i32 [[INC_1]], 1
; CHECK-NEXT:    [[CMP_2:%.*]] = icmp ult i32 [[INC_2]], [[MAXJ]]
; CHECK-NEXT:    br i1 [[CMP_2]], label [[FOR_BODY_3:%.*]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       for.body.3:
; CHECK-NEXT:    [[ARRAYIDX_3:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_2]]
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX_3]], align 4
; CHECK-NEXT:    [[CMP1_3:%.*]] = icmp ugt i32 [[TMP6]], 65535
; CHECK-NEXT:    br i1 [[CMP1_3]], label [[CLEANUP_LOOPEXIT]], label [[IF_END_3]]
; CHECK:       if.end.3:
; CHECK-NEXT:    [[ARRAYIDX2_3:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_2]]
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX2_3]], align 4
; CHECK-NEXT:    [[TOBOOL_3:%.*]] = icmp eq i32 [[TMP7]], 0
; CHECK-NEXT:    [[ADD_3:%.*]] = select i1 [[TOBOOL_3]], i32 0, i32 [[TMP6]]
; CHECK-NEXT:    [[TEMP_0_ADD_3]] = add i32 [[ADD_3]], [[TEMP_0_ADD_2]]
; CHECK-NEXT:    [[INC_3]] = add nuw i32 [[INC_2]], 1
; CHECK-NEXT:    [[CMP_3:%.*]] = icmp ult i32 [[INC_3]], [[MAXJ]]
; CHECK-NEXT:    br i1 [[CMP_3]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[TEMP_0_LCSSA_PH:%.*]] = phi i32 [ [[TEMP_0_ADD]], [[IF_END]] ], [ [[TEMP_015]], [[FOR_BODY]] ], [ [[TEMP_0_ADD]], [[FOR_BODY_1]] ], [ [[TEMP_0_ADD_1]], [[IF_END_1]] ], [ [[TEMP_0_ADD_1]], [[FOR_BODY_2]] ], [ [[TEMP_0_ADD_2]], [[IF_END_2]] ], [ [[TEMP_0_ADD_2]], [[FOR_BODY_3]] ], [ [[TEMP_0_ADD_3]], [[IF_END_3]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[TEMP_0_LCSSA:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[TEMP_0_LCSSA_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    store i32 [[TEMP_0_LCSSA]], i32* [[OUTPUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
  i32* nocapture readonly %Condition,
  i32* nocapture readonly %Input,
  i32 %MaxJ) {
entry:
  %cmp14 = icmp eq i32 %MaxJ, 0
  br i1 %cmp14, label %cleanup, label %for.body.preheader

for.body.preheader:                               ; preds = %entry
  br label %for.body

for.body:                                         ; preds = %for.body.preheader, %if.end
  %j.016 = phi i32 [ %inc, %if.end ], [ 0, %for.body.preheader ]
  %temp.015 = phi i32 [ %temp.0.add, %if.end ], [ 0, %for.body.preheader ]
  %arrayidx = getelementptr inbounds i32, i32* %Input, i32 %j.016
  %0 = load i32, i32* %arrayidx, align 4
  %cmp1 = icmp ugt i32 %0, 65535
  br i1 %cmp1, label %cleanup, label %if.end

if.end:                                           ; preds = %for.body
  %arrayidx2 = getelementptr inbounds i32, i32* %Condition, i32 %j.016
  %1 = load i32, i32* %arrayidx2, align 4
  %tobool = icmp eq i32 %1, 0
  %add = select i1 %tobool, i32 0, i32 %0
  %temp.0.add = add i32 %add, %temp.015
  %inc = add nuw i32 %j.016, 1
  %cmp = icmp ult i32 %inc, %MaxJ
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %if.end, %for.body, %entry
  %temp.0.lcssa = phi i32 [ 0, %entry ], [ %temp.015, %for.body ], [ %temp.0.add, %if.end ]
  store i32 %temp.0.lcssa, i32* %Output, align 4
  ret void
}

define void @test_three_exits(i32* nocapture %Output,
;
; CHECK-LABEL: @test_three_exits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP20:%.*]] = icmp eq i32 [[MAXJ:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP20]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[J_022:%.*]] = phi i32 [ [[INC:%.*]], [[IF_END5:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[TEMP_021:%.*]] = phi i32 [ [[TEMP_0_ADD:%.*]], [[IF_END5]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[CONDITION:%.*]], i32 [[J_022]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[TMP0]], 65535
; CHECK-NEXT:    br i1 [[CMP1]], label [[CLEANUP_LOOPEXIT:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[INPUT:%.*]], i32 [[J_022]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ugt i32 [[TMP1]], 65535
; CHECK-NEXT:    br i1 [[CMP3]], label [[CLEANUP_LOOPEXIT]], label [[IF_END5]]
; CHECK:       if.end5:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[TMP0]], 0
; CHECK-NEXT:    [[ADD:%.*]] = select i1 [[TOBOOL]], i32 0, i32 [[TMP1]]
; CHECK-NEXT:    [[TEMP_0_ADD]] = add i32 [[ADD]], [[TEMP_021]]
; CHECK-NEXT:    [[INC]] = add nuw i32 [[J_022]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[INC]], [[MAXJ]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[TEMP_0_LCSSA_PH:%.*]] = phi i32 [ [[TEMP_0_ADD]], [[IF_END5]] ], [ [[TEMP_021]], [[FOR_BODY]] ], [ [[TEMP_021]], [[IF_END]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[TEMP_0_LCSSA:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[TEMP_0_LCSSA_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    store i32 [[TEMP_0_LCSSA]], i32* [[OUTPUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
  i32* nocapture readonly %Condition,
  i32* nocapture readonly %Input,
  i32 %MaxJ) {
entry:
  %cmp20 = icmp eq i32 %MaxJ, 0
  br i1 %cmp20, label %cleanup, label %for.body.preheader

for.body.preheader:                               ; preds = %entry
  br label %for.body

for.body:                                         ; preds = %for.body.preheader, %if.end5
  %j.022 = phi i32 [ %inc, %if.end5 ], [ 0, %for.body.preheader ]
  %temp.021 = phi i32 [ %temp.0.add, %if.end5 ], [ 0, %for.body.preheader ]
  %arrayidx = getelementptr inbounds i32, i32* %Condition, i32 %j.022
  %0 = load i32, i32* %arrayidx, align 4
  %cmp1 = icmp ugt i32 %0, 65535
  br i1 %cmp1, label %cleanup, label %if.end

if.end:                                           ; preds = %for.body
  %arrayidx2 = getelementptr inbounds i32, i32* %Input, i32 %j.022
  %1 = load i32, i32* %arrayidx2, align 4
  %cmp3 = icmp ugt i32 %1, 65535
  br i1 %cmp3, label %cleanup, label %if.end5

if.end5:                                          ; preds = %if.end
  %tobool = icmp eq i32 %0, 0
  %add = select i1 %tobool, i32 0, i32 %1
  %temp.0.add = add i32 %add, %temp.021
  %inc = add nuw i32 %j.022, 1
  %cmp = icmp ult i32 %inc, %MaxJ
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %if.end5, %for.body, %if.end, %entry
  %temp.0.lcssa = phi i32 [ 0, %entry ], [ %temp.021, %if.end ], [ %temp.021, %for.body ], [ %temp.0.add, %if.end5 ]
  store i32 %temp.0.lcssa, i32* %Output, align 4
  ret void
}

define void @test_four_blocks(i32* nocapture %Output,
;
; CHECK-LABEL: @test_four_blocks(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP25:%.*]] = icmp ugt i32 [[MAXJ:%.*]], 1
; CHECK-NEXT:    br i1 [[CMP25]], label [[FOR_BODY_LR_PH:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; CHECK:       for.body.lr.ph:
; CHECK-NEXT:    [[DOTPRE:%.*]] = load i32, i32* [[INPUT:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[MAXJ]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[MAXJ]], -2
; CHECK-NEXT:    [[XTRAITER:%.*]] = and i32 [[TMP0]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ult i32 [[TMP1]], 3
; CHECK-NEXT:    br i1 [[TMP2]], label [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA:%.*]], label [[FOR_BODY_LR_PH_NEW:%.*]]
; CHECK:       for.body.lr.ph.new:
; CHECK-NEXT:    [[UNROLL_ITER:%.*]] = sub i32 [[TMP0]], [[XTRAITER]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond.cleanup.loopexit.unr-lcssa.loopexit:
; CHECK-NEXT:    [[TEMP_1_LCSSA_PH_PH:%.*]] = phi i32 [ [[TEMP_1_3:%.*]], [[FOR_INC_3:%.*]] ]
; CHECK-NEXT:    [[DOTUNR_PH:%.*]] = phi i32 [ [[TMP23:%.*]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[J_027_UNR_PH:%.*]] = phi i32 [ [[INC_3:%.*]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[TEMP_026_UNR_PH:%.*]] = phi i32 [ [[TEMP_1_3]], [[FOR_INC_3]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA]]
; CHECK:       for.cond.cleanup.loopexit.unr-lcssa:
; CHECK-NEXT:    [[TEMP_1_LCSSA_PH:%.*]] = phi i32 [ undef, [[FOR_BODY_LR_PH]] ], [ [[TEMP_1_LCSSA_PH_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT:%.*]] ]
; CHECK-NEXT:    [[DOTUNR:%.*]] = phi i32 [ [[DOTPRE]], [[FOR_BODY_LR_PH]] ], [ [[DOTUNR_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]] ]
; CHECK-NEXT:    [[J_027_UNR:%.*]] = phi i32 [ 1, [[FOR_BODY_LR_PH]] ], [ [[J_027_UNR_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]] ]
; CHECK-NEXT:    [[TEMP_026_UNR:%.*]] = phi i32 [ 0, [[FOR_BODY_LR_PH]] ], [ [[TEMP_026_UNR_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]] ]
; CHECK-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i32 [[XTRAITER]], 0
; CHECK-NEXT:    br i1 [[LCMP_MOD]], label [[FOR_BODY_EPIL_PREHEADER:%.*]], label [[FOR_COND_CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.body.epil.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_EPIL:%.*]]
; CHECK:       for.body.epil:
; CHECK-NEXT:    [[ARRAYIDX_EPIL:%.*]] = getelementptr inbounds i32, i32* [[CONDITION:%.*]], i32 [[J_027_UNR]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARRAYIDX_EPIL]], align 4
; CHECK-NEXT:    [[CMP1_EPIL:%.*]] = icmp ugt i32 [[TMP3]], 65535
; CHECK-NEXT:    [[ARRAYIDX2_EPIL:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[J_027_UNR]]
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, i32* [[ARRAYIDX2_EPIL]], align 4
; CHECK-NEXT:    [[CMP4_EPIL:%.*]] = icmp ugt i32 [[TMP4]], [[DOTUNR]]
; CHECK-NEXT:    br i1 [[CMP1_EPIL]], label [[IF_THEN_EPIL:%.*]], label [[IF_ELSE_EPIL:%.*]]
; CHECK:       if.else.epil:
; CHECK-NEXT:    [[NOT_CMP4_EPIL:%.*]] = xor i1 [[CMP4_EPIL]], true
; CHECK-NEXT:    [[SUB_EPIL:%.*]] = sext i1 [[NOT_CMP4_EPIL]] to i32
; CHECK-NEXT:    [[SUB10_SINK_EPIL:%.*]] = add i32 [[J_027_UNR]], [[SUB_EPIL]]
; CHECK-NEXT:    [[ARRAYIDX11_EPIL:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK_EPIL]]
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[ARRAYIDX11_EPIL]], align 4
; CHECK-NEXT:    [[SUB13_EPIL:%.*]] = sub i32 [[TEMP_026_UNR]], [[TMP5]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL:%.*]]
; CHECK:       if.then.epil:
; CHECK-NEXT:    [[COND_EPIL:%.*]] = zext i1 [[CMP4_EPIL]] to i32
; CHECK-NEXT:    [[ADD_EPIL:%.*]] = add i32 [[TEMP_026_UNR]], [[COND_EPIL]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL]]
; CHECK:       for.inc.epil:
; CHECK-NEXT:    [[TEMP_1_EPIL:%.*]] = phi i32 [ [[ADD_EPIL]], [[IF_THEN_EPIL]] ], [ [[SUB13_EPIL]], [[IF_ELSE_EPIL]] ]
; CHECK-NEXT:    [[INC_EPIL:%.*]] = add nuw i32 [[J_027_UNR]], 1
; CHECK-NEXT:    [[EPIL_ITER_CMP:%.*]] = icmp ne i32 1, [[XTRAITER]]
; CHECK-NEXT:    br i1 [[EPIL_ITER_CMP]], label [[FOR_BODY_EPIL_1:%.*]], label [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA:%.*]]
; CHECK:       for.body.epil.1:
; CHECK-NEXT:    [[ARRAYIDX_EPIL_1:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_EPIL]]
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX_EPIL_1]], align 4
; CHECK-NEXT:    [[CMP1_EPIL_1:%.*]] = icmp ugt i32 [[TMP6]], 65535
; CHECK-NEXT:    [[ARRAYIDX2_EPIL_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_EPIL]]
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX2_EPIL_1]], align 4
; CHECK-NEXT:    [[CMP4_EPIL_1:%.*]] = icmp ugt i32 [[TMP7]], [[TMP4]]
; CHECK-NEXT:    br i1 [[CMP1_EPIL_1]], label [[IF_THEN_EPIL_1:%.*]], label [[IF_ELSE_EPIL_1:%.*]]
; CHECK:       if.else.epil.1:
; CHECK-NEXT:    [[NOT_CMP4_EPIL_1:%.*]] = xor i1 [[CMP4_EPIL_1]], true
; CHECK-NEXT:    [[SUB_EPIL_1:%.*]] = sext i1 [[NOT_CMP4_EPIL_1]] to i32
; CHECK-NEXT:    [[SUB10_SINK_EPIL_1:%.*]] = add i32 [[INC_EPIL]], [[SUB_EPIL_1]]
; CHECK-NEXT:    [[ARRAYIDX11_EPIL_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK_EPIL_1]]
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, i32* [[ARRAYIDX11_EPIL_1]], align 4
; CHECK-NEXT:    [[SUB13_EPIL_1:%.*]] = sub i32 [[TEMP_1_EPIL]], [[TMP8]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL_1:%.*]]
; CHECK:       if.then.epil.1:
; CHECK-NEXT:    [[COND_EPIL_1:%.*]] = zext i1 [[CMP4_EPIL_1]] to i32
; CHECK-NEXT:    [[ADD_EPIL_1:%.*]] = add i32 [[TEMP_1_EPIL]], [[COND_EPIL_1]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL_1]]
; CHECK:       for.inc.epil.1:
; CHECK-NEXT:    [[TEMP_1_EPIL_1:%.*]] = phi i32 [ [[ADD_EPIL_1]], [[IF_THEN_EPIL_1]] ], [ [[SUB13_EPIL_1]], [[IF_ELSE_EPIL_1]] ]
; CHECK-NEXT:    [[INC_EPIL_1:%.*]] = add nuw i32 [[INC_EPIL]], 1
; CHECK-NEXT:    [[EPIL_ITER_CMP_1:%.*]] = icmp ne i32 2, [[XTRAITER]]
; CHECK-NEXT:    br i1 [[EPIL_ITER_CMP_1]], label [[FOR_BODY_EPIL_2:%.*]], label [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA]]
; CHECK:       for.body.epil.2:
; CHECK-NEXT:    [[ARRAYIDX_EPIL_2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_EPIL_1]]
; CHECK-NEXT:    [[TMP9:%.*]] = load i32, i32* [[ARRAYIDX_EPIL_2]], align 4
; CHECK-NEXT:    [[CMP1_EPIL_2:%.*]] = icmp ugt i32 [[TMP9]], 65535
; CHECK-NEXT:    [[ARRAYIDX2_EPIL_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_EPIL_1]]
; CHECK-NEXT:    [[TMP10:%.*]] = load i32, i32* [[ARRAYIDX2_EPIL_2]], align 4
; CHECK-NEXT:    [[CMP4_EPIL_2:%.*]] = icmp ugt i32 [[TMP10]], [[TMP7]]
; CHECK-NEXT:    br i1 [[CMP1_EPIL_2]], label [[IF_THEN_EPIL_2:%.*]], label [[IF_ELSE_EPIL_2:%.*]]
; CHECK:       if.else.epil.2:
; CHECK-NEXT:    [[NOT_CMP4_EPIL_2:%.*]] = xor i1 [[CMP4_EPIL_2]], true
; CHECK-NEXT:    [[SUB_EPIL_2:%.*]] = sext i1 [[NOT_CMP4_EPIL_2]] to i32
; CHECK-NEXT:    [[SUB10_SINK_EPIL_2:%.*]] = add i32 [[INC_EPIL_1]], [[SUB_EPIL_2]]
; CHECK-NEXT:    [[ARRAYIDX11_EPIL_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK_EPIL_2]]
; CHECK-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX11_EPIL_2]], align 4
; CHECK-NEXT:    [[SUB13_EPIL_2:%.*]] = sub i32 [[TEMP_1_EPIL_1]], [[TMP11]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL_2:%.*]]
; CHECK:       if.then.epil.2:
; CHECK-NEXT:    [[COND_EPIL_2:%.*]] = zext i1 [[CMP4_EPIL_2]] to i32
; CHECK-NEXT:    [[ADD_EPIL_2:%.*]] = add i32 [[TEMP_1_EPIL_1]], [[COND_EPIL_2]]
; CHECK-NEXT:    br label [[FOR_INC_EPIL_2]]
; CHECK:       for.inc.epil.2:
; CHECK-NEXT:    [[TEMP_1_EPIL_2:%.*]] = phi i32 [ [[ADD_EPIL_2]], [[IF_THEN_EPIL_2]] ], [ [[SUB13_EPIL_2]], [[IF_ELSE_EPIL_2]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA]]
; CHECK:       for.cond.cleanup.loopexit.epilog-lcssa:
; CHECK-NEXT:    [[TEMP_1_LCSSA_PH1:%.*]] = phi i32 [ [[TEMP_1_EPIL]], [[FOR_INC_EPIL]] ], [ [[TEMP_1_EPIL_1]], [[FOR_INC_EPIL_1]] ], [ [[TEMP_1_EPIL_2]], [[FOR_INC_EPIL_2]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP_LOOPEXIT]]
; CHECK:       for.cond.cleanup.loopexit:
; CHECK-NEXT:    [[TEMP_1_LCSSA:%.*]] = phi i32 [ [[TEMP_1_LCSSA_PH]], [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA]] ], [ [[TEMP_1_LCSSA_PH1]], [[FOR_COND_CLEANUP_LOOPEXIT_EPILOG_LCSSA]] ]
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    [[TEMP_0_LCSSA:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[TEMP_1_LCSSA]], [[FOR_COND_CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    store i32 [[TEMP_0_LCSSA]], i32* [[OUTPUT:%.*]], align 4
; CHECK-NEXT:    ret void
; CHECK:       for.body:
; CHECK-NEXT:    [[TMP12:%.*]] = phi i32 [ [[DOTPRE]], [[FOR_BODY_LR_PH_NEW]] ], [ [[TMP23]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[J_027:%.*]] = phi i32 [ 1, [[FOR_BODY_LR_PH_NEW]] ], [ [[INC_3]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[TEMP_026:%.*]] = phi i32 [ 0, [[FOR_BODY_LR_PH_NEW]] ], [ [[TEMP_1_3]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[NITER:%.*]] = phi i32 [ 0, [[FOR_BODY_LR_PH_NEW]] ], [ [[NITER_NEXT_3:%.*]], [[FOR_INC_3]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[J_027]]
; CHECK-NEXT:    [[TMP13:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[TMP13]], 65535
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[J_027]]
; CHECK-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[CMP4:%.*]] = icmp ugt i32 [[TMP14]], [[TMP12]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[COND:%.*]] = zext i1 [[CMP4]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[TEMP_026]], [[COND]]
; CHECK-NEXT:    br label [[FOR_INC:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    [[NOT_CMP4:%.*]] = xor i1 [[CMP4]], true
; CHECK-NEXT:    [[SUB:%.*]] = sext i1 [[NOT_CMP4]] to i32
; CHECK-NEXT:    [[SUB10_SINK:%.*]] = add i32 [[J_027]], [[SUB]]
; CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK]]
; CHECK-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX11]], align 4
; CHECK-NEXT:    [[SUB13:%.*]] = sub i32 [[TEMP_026]], [[TMP15]]
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[TEMP_1:%.*]] = phi i32 [ [[ADD]], [[IF_THEN]] ], [ [[SUB13]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[INC:%.*]] = add nuw nsw i32 [[J_027]], 1
; CHECK-NEXT:    [[NITER_NEXT:%.*]] = add nuw nsw i32 [[NITER]], 1
; CHECK-NEXT:    [[ARRAYIDX_1:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC]]
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX_1]], align 4
; CHECK-NEXT:    [[CMP1_1:%.*]] = icmp ugt i32 [[TMP16]], 65535
; CHECK-NEXT:    [[ARRAYIDX2_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC]]
; CHECK-NEXT:    [[TMP17:%.*]] = load i32, i32* [[ARRAYIDX2_1]], align 4
; CHECK-NEXT:    [[CMP4_1:%.*]] = icmp ugt i32 [[TMP17]], [[TMP14]]
; CHECK-NEXT:    br i1 [[CMP1_1]], label [[IF_THEN_1:%.*]], label [[IF_ELSE_1:%.*]]
; CHECK:       if.else.1:
; CHECK-NEXT:    [[NOT_CMP4_1:%.*]] = xor i1 [[CMP4_1]], true
; CHECK-NEXT:    [[SUB_1:%.*]] = sext i1 [[NOT_CMP4_1]] to i32
; CHECK-NEXT:    [[SUB10_SINK_1:%.*]] = add i32 [[INC]], [[SUB_1]]
; CHECK-NEXT:    [[ARRAYIDX11_1:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK_1]]
; CHECK-NEXT:    [[TMP18:%.*]] = load i32, i32* [[ARRAYIDX11_1]], align 4
; CHECK-NEXT:    [[SUB13_1:%.*]] = sub i32 [[TEMP_1]], [[TMP18]]
; CHECK-NEXT:    br label [[FOR_INC_1:%.*]]
; CHECK:       if.then.1:
; CHECK-NEXT:    [[COND_1:%.*]] = zext i1 [[CMP4_1]] to i32
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[TEMP_1]], [[COND_1]]
; CHECK-NEXT:    br label [[FOR_INC_1]]
; CHECK:       for.inc.1:
; CHECK-NEXT:    [[TEMP_1_1:%.*]] = phi i32 [ [[ADD_1]], [[IF_THEN_1]] ], [ [[SUB13_1]], [[IF_ELSE_1]] ]
; CHECK-NEXT:    [[INC_1:%.*]] = add nuw nsw i32 [[INC]], 1
; CHECK-NEXT:    [[NITER_NEXT_1:%.*]] = add nuw nsw i32 [[NITER_NEXT]], 1
; CHECK-NEXT:    [[ARRAYIDX_2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_1]]
; CHECK-NEXT:    [[TMP19:%.*]] = load i32, i32* [[ARRAYIDX_2]], align 4
; CHECK-NEXT:    [[CMP1_2:%.*]] = icmp ugt i32 [[TMP19]], 65535
; CHECK-NEXT:    [[ARRAYIDX2_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_1]]
; CHECK-NEXT:    [[TMP20:%.*]] = load i32, i32* [[ARRAYIDX2_2]], align 4
; CHECK-NEXT:    [[CMP4_2:%.*]] = icmp ugt i32 [[TMP20]], [[TMP17]]
; CHECK-NEXT:    br i1 [[CMP1_2]], label [[IF_THEN_2:%.*]], label [[IF_ELSE_2:%.*]]
; CHECK:       if.else.2:
; CHECK-NEXT:    [[NOT_CMP4_2:%.*]] = xor i1 [[CMP4_2]], true
; CHECK-NEXT:    [[SUB_2:%.*]] = sext i1 [[NOT_CMP4_2]] to i32
; CHECK-NEXT:    [[SUB10_SINK_2:%.*]] = add i32 [[INC_1]], [[SUB_2]]
; CHECK-NEXT:    [[ARRAYIDX11_2:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK_2]]
; CHECK-NEXT:    [[TMP21:%.*]] = load i32, i32* [[ARRAYIDX11_2]], align 4
; CHECK-NEXT:    [[SUB13_2:%.*]] = sub i32 [[TEMP_1_1]], [[TMP21]]
; CHECK-NEXT:    br label [[FOR_INC_2:%.*]]
; CHECK:       if.then.2:
; CHECK-NEXT:    [[COND_2:%.*]] = zext i1 [[CMP4_2]] to i32
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[TEMP_1_1]], [[COND_2]]
; CHECK-NEXT:    br label [[FOR_INC_2]]
; CHECK:       for.inc.2:
; CHECK-NEXT:    [[TEMP_1_2:%.*]] = phi i32 [ [[ADD_2]], [[IF_THEN_2]] ], [ [[SUB13_2]], [[IF_ELSE_2]] ]
; CHECK-NEXT:    [[INC_2:%.*]] = add nuw i32 [[INC_1]], 1
; CHECK-NEXT:    [[NITER_NEXT_2:%.*]] = add nuw nsw i32 [[NITER_NEXT_1]], 1
; CHECK-NEXT:    [[ARRAYIDX_3:%.*]] = getelementptr inbounds i32, i32* [[CONDITION]], i32 [[INC_2]]
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX_3]], align 4
; CHECK-NEXT:    [[CMP1_3:%.*]] = icmp ugt i32 [[TMP22]], 65535
; CHECK-NEXT:    [[ARRAYIDX2_3:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[INC_2]]
; CHECK-NEXT:    [[TMP23]] = load i32, i32* [[ARRAYIDX2_3]], align 4
; CHECK-NEXT:    [[CMP4_3:%.*]] = icmp ugt i32 [[TMP23]], [[TMP20]]
; CHECK-NEXT:    br i1 [[CMP1_3]], label [[IF_THEN_3:%.*]], label [[IF_ELSE_3:%.*]]
; CHECK:       if.else.3:
; CHECK-NEXT:    [[NOT_CMP4_3:%.*]] = xor i1 [[CMP4_3]], true
; CHECK-NEXT:    [[SUB_3:%.*]] = sext i1 [[NOT_CMP4_3]] to i32
; CHECK-NEXT:    [[SUB10_SINK_3:%.*]] = add i32 [[INC_2]], [[SUB_3]]
; CHECK-NEXT:    [[ARRAYIDX11_3:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB10_SINK_3]]
; CHECK-NEXT:    [[TMP24:%.*]] = load i32, i32* [[ARRAYIDX11_3]], align 4
; CHECK-NEXT:    [[SUB13_3:%.*]] = sub i32 [[TEMP_1_2]], [[TMP24]]
; CHECK-NEXT:    br label [[FOR_INC_3]]
; CHECK:       if.then.3:
; CHECK-NEXT:    [[COND_3:%.*]] = zext i1 [[CMP4_3]] to i32
; CHECK-NEXT:    [[ADD_3:%.*]] = add i32 [[TEMP_1_2]], [[COND_3]]
; CHECK-NEXT:    br label [[FOR_INC_3]]
; CHECK:       for.inc.3:
; CHECK-NEXT:    [[TEMP_1_3]] = phi i32 [ [[ADD_3]], [[IF_THEN_3]] ], [ [[SUB13_3]], [[IF_ELSE_3]] ]
; CHECK-NEXT:    [[INC_3]] = add nuw nsw i32 [[INC_2]], 1
; CHECK-NEXT:    [[NITER_NEXT_3]] = add i32 [[NITER_NEXT_2]], 1
; CHECK-NEXT:    [[NITER_NCMP_3:%.*]] = icmp eq i32 [[NITER_NEXT_3]], [[UNROLL_ITER]]
; CHECK-NEXT:    br i1 [[NITER_NCMP_3]], label [[FOR_COND_CLEANUP_LOOPEXIT_UNR_LCSSA_LOOPEXIT]], label [[FOR_BODY]]
;
  i32* nocapture readonly %Condition,
  i32* nocapture readonly %Input,
  i32 %MaxJ) {
entry:
  %cmp25 = icmp ugt i32 %MaxJ, 1
  br i1 %cmp25, label %for.body.lr.ph, label %for.cond.cleanup

for.body.lr.ph:                                   ; preds = %entry
  %.pre = load i32, i32* %Input, align 4
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.inc, %entry
  %temp.0.lcssa = phi i32 [ 0, %entry ], [ %temp.1, %for.inc ]
  store i32 %temp.0.lcssa, i32* %Output, align 4
  ret void

for.body:                                         ; preds = %for.inc, %for.body.lr.ph
  %0 = phi i32 [ %.pre, %for.body.lr.ph ], [ %2, %for.inc ]
  %j.027 = phi i32 [ 1, %for.body.lr.ph ], [ %inc, %for.inc ]
  %temp.026 = phi i32 [ 0, %for.body.lr.ph ], [ %temp.1, %for.inc ]
  %arrayidx = getelementptr inbounds i32, i32* %Condition, i32 %j.027
  %1 = load i32, i32* %arrayidx, align 4
  %cmp1 = icmp ugt i32 %1, 65535
  %arrayidx2 = getelementptr inbounds i32, i32* %Input, i32 %j.027
  %2 = load i32, i32* %arrayidx2, align 4
  %cmp4 = icmp ugt i32 %2, %0
  br i1 %cmp1, label %if.then, label %if.else

if.then:                                          ; preds = %for.body
  %cond = zext i1 %cmp4 to i32
  %add = add i32 %temp.026, %cond
  br label %for.inc

if.else:                                          ; preds = %for.body
  %not.cmp4 = xor i1 %cmp4, true
  %sub = sext i1 %not.cmp4 to i32
  %sub10.sink = add i32 %j.027, %sub
  %arrayidx11 = getelementptr inbounds i32, i32* %Input, i32 %sub10.sink
  %3 = load i32, i32* %arrayidx11, align 4
  %sub13 = sub i32 %temp.026, %3
  br label %for.inc

for.inc:                                          ; preds = %if.then, %if.else
  %temp.1 = phi i32 [ %add, %if.then ], [ %sub13, %if.else ]
  %inc = add nuw i32 %j.027, 1
  %exitcond = icmp eq i32 %inc, %MaxJ
  br i1 %exitcond, label %for.cond.cleanup, label %for.body
}

define void @test_five_blocks(i32* nocapture %Output,
;
; CHECK-LABEL: @test_five_blocks(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP24:%.*]] = icmp ugt i32 [[MAXJ:%.*]], 1
; CHECK-NEXT:    br i1 [[CMP24]], label [[FOR_BODY_PREHEADER:%.*]], label [[CLEANUP:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[J_026:%.*]] = phi i32 [ [[INC:%.*]], [[FOR_INC:%.*]] ], [ 1, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[TEMP_025:%.*]] = phi i32 [ [[TEMP_1:%.*]], [[FOR_INC]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[INPUT:%.*]], i32 [[J_026]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[TMP0]], [[TEMP_025]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[ADD]], 16777215
; CHECK-NEXT:    br i1 [[CMP1]], label [[CLEANUP_LOOPEXIT:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[CONDITION:%.*]], i32 [[J_026]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ugt i32 [[TMP1]], 65535
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then4:
; CHECK-NEXT:    [[SUB:%.*]] = add i32 [[J_026]], -1
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, i32* [[INPUT]], i32 [[SUB]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[CMP7:%.*]] = icmp ugt i32 [[TMP0]], [[TMP2]]
; CHECK-NEXT:    [[COND:%.*]] = zext i1 [[CMP7]] to i32
; CHECK-NEXT:    [[ADD8:%.*]] = add i32 [[ADD]], [[COND]]
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       if.else:
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[ADD]], [[TMP0]]
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[TEMP_1]] = phi i32 [ [[ADD8]], [[IF_THEN4]] ], [ [[AND]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[INC]] = add nuw i32 [[J_026]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[INC]], [[MAXJ]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[TEMP_2_PH:%.*]] = phi i32 [ [[TEMP_1]], [[FOR_INC]] ], [ [[ADD]], [[FOR_BODY]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[TEMP_2:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[TEMP_2_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    store i32 [[TEMP_2]], i32* [[OUTPUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
  i32* nocapture readonly %Condition,
  i32* nocapture readonly %Input,
  i32 %MaxJ) {
entry:
  %cmp24 = icmp ugt i32 %MaxJ, 1
  br i1 %cmp24, label %for.body.preheader, label %cleanup

for.body.preheader:                               ; preds = %entry
  br label %for.body

for.body:                                         ; preds = %for.body.preheader, %for.inc
  %j.026 = phi i32 [ %inc, %for.inc ], [ 1, %for.body.preheader ]
  %temp.025 = phi i32 [ %temp.1, %for.inc ], [ 0, %for.body.preheader ]
  %arrayidx = getelementptr inbounds i32, i32* %Input, i32 %j.026
  %0 = load i32, i32* %arrayidx, align 4
  %add = add i32 %0, %temp.025
  %cmp1 = icmp ugt i32 %add, 16777215
  br i1 %cmp1, label %cleanup, label %if.end

if.end:                                           ; preds = %for.body
  %arrayidx2 = getelementptr inbounds i32, i32* %Condition, i32 %j.026
  %1 = load i32, i32* %arrayidx2, align 4
  %cmp3 = icmp ugt i32 %1, 65535
  br i1 %cmp3, label %if.then4, label %if.else

if.then4:                                         ; preds = %if.end
  %sub = add i32 %j.026, -1
  %arrayidx6 = getelementptr inbounds i32, i32* %Input, i32 %sub
  %2 = load i32, i32* %arrayidx6, align 4
  %cmp7 = icmp ugt i32 %0, %2
  %cond = zext i1 %cmp7 to i32
  %add8 = add i32 %add, %cond
  br label %for.inc

if.else:                                          ; preds = %if.end
  %and = and i32 %add, %0
  br label %for.inc

for.inc:                                          ; preds = %if.then4, %if.else
  %temp.1 = phi i32 [ %add8, %if.then4 ], [ %and, %if.else ]
  %inc = add nuw i32 %j.026, 1
  %cmp = icmp ult i32 %inc, %MaxJ
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.inc, %for.body, %entry
  %temp.2 = phi i32 [ 0, %entry ], [ %add, %for.body ], [ %temp.1, %for.inc ]
  store i32 %temp.2, i32* %Output, align 4
  ret void
}

%struct.Node = type { %struct.Node*, i32 }
define void @iterate_inc(%struct.Node* %n, i32 %limit) {
;
; CHECK-LABEL: @iterate_inc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL5:%.*]] = icmp eq %struct.Node* [[N:%.*]], null
; CHECK-NEXT:    br i1 [[TOBOOL5]], label [[WHILE_END:%.*]], label [[LAND_RHS_PREHEADER:%.*]]
; CHECK:       land.rhs.preheader:
; CHECK-NEXT:    br label [[LAND_RHS:%.*]]
; CHECK:       land.rhs:
; CHECK-NEXT:    [[LIST_ADDR_06:%.*]] = phi %struct.Node* [ [[N]], [[LAND_RHS_PREHEADER]] ], [ [[TMP11:%.*]], [[WHILE_BODY_3:%.*]] ]
; CHECK-NEXT:    [[VAL:%.*]] = getelementptr inbounds [[STRUCT_NODE:%.*]], %struct.Node* [[LIST_ADDR_06]], i32 0, i32 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VAL]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP0]], [[LIMIT:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[WHILE_BODY:%.*]], label [[WHILE_END_LOOPEXIT:%.*]]
; CHECK:       while.body:
; CHECK-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP0]], 1
; CHECK-NEXT:    store i32 [[INC]], i32* [[VAL]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast %struct.Node* [[LIST_ADDR_06]] to %struct.Node**
; CHECK-NEXT:    [[TMP2:%.*]] = load %struct.Node*, %struct.Node** [[TMP1]], align 4
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq %struct.Node* [[TMP2]], null
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[WHILE_END_LOOPEXIT]], label [[LAND_RHS_1:%.*]]
; CHECK:       land.rhs.1:
; CHECK-NEXT:    [[VAL_1:%.*]] = getelementptr inbounds [[STRUCT_NODE]], %struct.Node* [[TMP2]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[VAL_1]], align 4
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp slt i32 [[TMP3]], [[LIMIT]]
; CHECK-NEXT:    br i1 [[CMP_1]], label [[WHILE_BODY_1:%.*]], label [[WHILE_END_LOOPEXIT]]
; CHECK:       while.body.1:
; CHECK-NEXT:    [[INC_1:%.*]] = add nsw i32 [[TMP3]], 1
; CHECK-NEXT:    store i32 [[INC_1]], i32* [[VAL_1]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast %struct.Node* [[TMP2]] to %struct.Node**
; CHECK-NEXT:    [[TMP5:%.*]] = load %struct.Node*, %struct.Node** [[TMP4]], align 4
; CHECK-NEXT:    [[TOBOOL_1:%.*]] = icmp eq %struct.Node* [[TMP5]], null
; CHECK-NEXT:    br i1 [[TOBOOL_1]], label [[WHILE_END_LOOPEXIT]], label [[LAND_RHS_2:%.*]]
; CHECK:       land.rhs.2:
; CHECK-NEXT:    [[VAL_2:%.*]] = getelementptr inbounds [[STRUCT_NODE]], %struct.Node* [[TMP5]], i32 0, i32 1
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, i32* [[VAL_2]], align 4
; CHECK-NEXT:    [[CMP_2:%.*]] = icmp slt i32 [[TMP6]], [[LIMIT]]
; CHECK-NEXT:    br i1 [[CMP_2]], label [[WHILE_BODY_2:%.*]], label [[WHILE_END_LOOPEXIT]]
; CHECK:       while.body.2:
; CHECK-NEXT:    [[INC_2:%.*]] = add nsw i32 [[TMP6]], 1
; CHECK-NEXT:    store i32 [[INC_2]], i32* [[VAL_2]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast %struct.Node* [[TMP5]] to %struct.Node**
; CHECK-NEXT:    [[TMP8:%.*]] = load %struct.Node*, %struct.Node** [[TMP7]], align 4
; CHECK-NEXT:    [[TOBOOL_2:%.*]] = icmp eq %struct.Node* [[TMP8]], null
; CHECK-NEXT:    br i1 [[TOBOOL_2]], label [[WHILE_END_LOOPEXIT]], label [[LAND_RHS_3:%.*]]
; CHECK:       land.rhs.3:
; CHECK-NEXT:    [[VAL_3:%.*]] = getelementptr inbounds [[STRUCT_NODE]], %struct.Node* [[TMP8]], i32 0, i32 1
; CHECK-NEXT:    [[TMP9:%.*]] = load i32, i32* [[VAL_3]], align 4
; CHECK-NEXT:    [[CMP_3:%.*]] = icmp slt i32 [[TMP9]], [[LIMIT]]
; CHECK-NEXT:    br i1 [[CMP_3]], label [[WHILE_BODY_3]], label [[WHILE_END_LOOPEXIT]]
; CHECK:       while.body.3:
; CHECK-NEXT:    [[INC_3:%.*]] = add nsw i32 [[TMP9]], 1
; CHECK-NEXT:    store i32 [[INC_3]], i32* [[VAL_3]], align 4
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast %struct.Node* [[TMP8]] to %struct.Node**
; CHECK-NEXT:    [[TMP11]] = load %struct.Node*, %struct.Node** [[TMP10]], align 4
; CHECK-NEXT:    [[TOBOOL_3:%.*]] = icmp eq %struct.Node* [[TMP11]], null
; CHECK-NEXT:    br i1 [[TOBOOL_3]], label [[WHILE_END_LOOPEXIT]], label [[LAND_RHS]]
; CHECK:       while.end.loopexit:
; CHECK-NEXT:    br label [[WHILE_END]]
; CHECK:       while.end:
; CHECK-NEXT:    ret void
;
entry:
  %tobool5 = icmp eq %struct.Node* %n, null
  br i1 %tobool5, label %while.end, label %land.rhs.preheader

land.rhs.preheader:                               ; preds = %entry
  br label %land.rhs

land.rhs:                                         ; preds = %land.rhs.preheader, %while.body
  %list.addr.06 = phi %struct.Node* [ %2, %while.body ], [ %n, %land.rhs.preheader ]
  %val = getelementptr inbounds %struct.Node, %struct.Node* %list.addr.06, i32 0, i32 1
  %0 = load i32, i32* %val, align 4
  %cmp = icmp slt i32 %0, %limit
  br i1 %cmp, label %while.body, label %while.end

while.body:                                       ; preds = %land.rhs
  %inc = add nsw i32 %0, 1
  store i32 %inc, i32* %val, align 4
  %1 = bitcast %struct.Node* %list.addr.06 to %struct.Node**
  %2 = load %struct.Node*, %struct.Node** %1, align 4
  %tobool = icmp eq %struct.Node* %2, null
  br i1 %tobool, label %while.end, label %land.rhs

while.end:                                        ; preds = %land.rhs, %while.body, %entry
  ret void
}
