; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -basic-aa -gvn -enable-load-pre -S | FileCheck %s
; RUN: opt < %s -aa-pipeline=basic-aa -passes="gvn<load-pre>" -enable-load-pre=false -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64"

define i32 @test1(i32* %p, i1 %C) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[PRE_PRE:%.*]] = load i32, i32* [[P:%.*]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    store i32 0, i32* [[P]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[PRE:%.*]] = phi i32 [ 0, [[BLOCK3]] ], [ [[PRE_PRE]], [[BLOCK2]] ]
; CHECK-NEXT:    ret i32 [[PRE]]
;
block1:
  br i1 %C, label %block2, label %block3

block2:
  br label %block4

block3:
  store i32 0, i32* %p
  br label %block4

block4:
  %PRE = load i32, i32* %p
  ret i32 %PRE
}

; This is a simple phi translation case.
define i32 @test2(i32* %p, i32* %q, i1 %C) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[PRE_PRE:%.*]] = load i32, i32* [[Q:%.*]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    store i32 0, i32* [[P:%.*]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[PRE:%.*]] = phi i32 [ 0, [[BLOCK3]] ], [ [[PRE_PRE]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i32* [ [[P]], [[BLOCK3]] ], [ [[Q]], [[BLOCK2]] ]
; CHECK-NEXT:    ret i32 [[PRE]]
;
block1:
  br i1 %C, label %block2, label %block3

block2:
  br label %block4

block3:
  store i32 0, i32* %p
  br label %block4

block4:
  %P2 = phi i32* [%p, %block3], [%q, %block2]
  %PRE = load i32, i32* %P2
  ret i32 %PRE
}

; This is a PRE case that requires phi translation through a GEP.
define i32 @test3(i32* %p, i32* %q, i32** %Hack, i1 %C) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[B:%.*]] = getelementptr i32, i32* [[Q:%.*]], i32 1
; CHECK-NEXT:    store i32* [[B]], i32** [[HACK:%.*]], align 8
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[PRE_PRE:%.*]] = load i32, i32* [[B]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    [[A:%.*]] = getelementptr i32, i32* [[P:%.*]], i32 1
; CHECK-NEXT:    store i32 0, i32* [[A]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[PRE:%.*]] = phi i32 [ 0, [[BLOCK3]] ], [ [[PRE_PRE]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i32* [ [[P]], [[BLOCK3]] ], [ [[Q]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P3:%.*]] = getelementptr i32, i32* [[P2]], i32 1
; CHECK-NEXT:    ret i32 [[PRE]]
;
block1:
  %B = getelementptr i32, i32* %q, i32 1
  store i32* %B, i32** %Hack
  br i1 %C, label %block2, label %block3

block2:
  br label %block4

block3:
  %A = getelementptr i32, i32* %p, i32 1
  store i32 0, i32* %A
  br label %block4

block4:
  %P2 = phi i32* [%p, %block3], [%q, %block2]
  %P3 = getelementptr i32, i32* %P2, i32 1
  %PRE = load i32, i32* %P3
  ret i32 %PRE
}

;; Here the loaded address is available, but the computation is in 'block3'
;; which does not dominate 'block2'.
define i32 @test4(i32* %p, i32* %q, i32** %Hack, i1 %C) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[P3_PHI_TRANS_INSERT:%.*]] = getelementptr i32, i32* [[Q:%.*]], i32 1
; CHECK-NEXT:    [[PRE_PRE:%.*]] = load i32, i32* [[P3_PHI_TRANS_INSERT]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    [[B:%.*]] = getelementptr i32, i32* [[Q]], i32 1
; CHECK-NEXT:    store i32* [[B]], i32** [[HACK:%.*]], align 8
; CHECK-NEXT:    [[A:%.*]] = getelementptr i32, i32* [[P:%.*]], i32 1
; CHECK-NEXT:    store i32 0, i32* [[A]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[PRE:%.*]] = phi i32 [ 0, [[BLOCK3]] ], [ [[PRE_PRE]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i32* [ [[P]], [[BLOCK3]] ], [ [[Q]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P3:%.*]] = getelementptr i32, i32* [[P2]], i32 1
; CHECK-NEXT:    ret i32 [[PRE]]
;
block1:
  br i1 %C, label %block2, label %block3

block2:
  br label %block4

block3:
  %B = getelementptr i32, i32* %q, i32 1
  store i32* %B, i32** %Hack

  %A = getelementptr i32, i32* %p, i32 1
  store i32 0, i32* %A
  br label %block4

block4:
  %P2 = phi i32* [%p, %block3], [%q, %block2]
  %P3 = getelementptr i32, i32* %P2, i32 1
  %PRE = load i32, i32* %P3
  ret i32 %PRE
}

;void test5(int N, double *G) {
;  int j;
;  for (j = 0; j < N - 1; j++)
;    G[j] = G[j] + G[j+1];
;}

define void @test5(i32 %N, double* nocapture %G) nounwind ssp {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TMP1]], label [[BB_NPH:%.*]], label [[RETURN:%.*]]
; CHECK:       bb.nph:
; CHECK-NEXT:    [[TMP:%.*]] = zext i32 [[TMP0]] to i64
; CHECK-NEXT:    [[DOTPRE:%.*]] = load double, double* [[G:%.*]], align 8
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP2:%.*]] = phi double [ [[DOTPRE]], [[BB_NPH]] ], [ [[TMP3:%.*]], [[BB]] ]
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ 0, [[BB_NPH]] ], [ [[TMP6:%.*]], [[BB]] ]
; CHECK-NEXT:    [[TMP6]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr double, double* [[G]], i64 [[TMP6]]
; CHECK-NEXT:    [[SCEVGEP7:%.*]] = getelementptr double, double* [[G]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP3]] = load double, double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[TMP4:%.*]] = fadd double [[TMP2]], [[TMP3]]
; CHECK-NEXT:    store double [[TMP4]], double* [[SCEVGEP7]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[TMP6]], [[TMP]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[RETURN]], label [[BB]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %0 = add i32 %N, -1
  %1 = icmp sgt i32 %0, 0
  br i1 %1, label %bb.nph, label %return

bb.nph:
  %tmp = zext i32 %0 to i64
  br label %bb


bb:
  %indvar = phi i64 [ 0, %bb.nph ], [ %tmp6, %bb ]
  %tmp6 = add i64 %indvar, 1
  %scevgep = getelementptr double, double* %G, i64 %tmp6
  %scevgep7 = getelementptr double, double* %G, i64 %indvar
  %2 = load double, double* %scevgep7, align 8
  %3 = load double, double* %scevgep, align 8
  %4 = fadd double %2, %3
  store double %4, double* %scevgep7, align 8
  %exitcond = icmp eq i64 %tmp6, %tmp
  br i1 %exitcond, label %return, label %bb

; Should only be one load in the loop.

return:
  ret void
}

;void test6(int N, double *G) {
;  int j;
;  for (j = 0; j < N - 1; j++)
;    G[j+1] = G[j] + G[j+1];
;}

define void @test6(i32 %N, double* nocapture %G) nounwind ssp {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TMP1]], label [[BB_NPH:%.*]], label [[RETURN:%.*]]
; CHECK:       bb.nph:
; CHECK-NEXT:    [[TMP:%.*]] = zext i32 [[TMP0]] to i64
; CHECK-NEXT:    [[DOTPRE:%.*]] = load double, double* [[G:%.*]], align 8
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP2:%.*]] = phi double [ [[DOTPRE]], [[BB_NPH]] ], [ [[TMP4:%.*]], [[BB]] ]
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ 0, [[BB_NPH]] ], [ [[TMP6:%.*]], [[BB]] ]
; CHECK-NEXT:    [[TMP6]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr double, double* [[G]], i64 [[TMP6]]
; CHECK-NEXT:    [[SCEVGEP7:%.*]] = getelementptr double, double* [[G]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP3:%.*]] = load double, double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[TMP4]] = fadd double [[TMP2]], [[TMP3]]
; CHECK-NEXT:    store double [[TMP4]], double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[TMP6]], [[TMP]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[RETURN]], label [[BB]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %0 = add i32 %N, -1
  %1 = icmp sgt i32 %0, 0
  br i1 %1, label %bb.nph, label %return

bb.nph:
  %tmp = zext i32 %0 to i64
  br label %bb


bb:
  %indvar = phi i64 [ 0, %bb.nph ], [ %tmp6, %bb ]
  %tmp6 = add i64 %indvar, 1
  %scevgep = getelementptr double, double* %G, i64 %tmp6
  %scevgep7 = getelementptr double, double* %G, i64 %indvar
  %2 = load double, double* %scevgep7, align 8
  %3 = load double, double* %scevgep, align 8
  %4 = fadd double %2, %3
  store double %4, double* %scevgep, align 8
  %exitcond = icmp eq i64 %tmp6, %tmp
  br i1 %exitcond, label %return, label %bb

; Should only be one load in the loop.

return:
  ret void
}

;void test7(int N, double* G) {
;  long j;
;  G[1] = 1;
;  for (j = 1; j < N - 1; j++)
;      G[j+1] = G[j] + G[j+1];
;}

; This requires phi translation of the adds.
define void @test7(i32 %N, double* nocapture %G) nounwind ssp {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds double, double* [[G:%.*]], i64 1
; CHECK-NEXT:    store double 1.000000e+00, double* [[TMP0]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[N:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[TMP1]], 1
; CHECK-NEXT:    br i1 [[TMP2]], label [[BB_NPH:%.*]], label [[RETURN:%.*]]
; CHECK:       bb.nph:
; CHECK-NEXT:    [[TMP:%.*]] = sext i32 [[TMP1]] to i64
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP]], -1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP3:%.*]] = phi double [ 1.000000e+00, [[BB_NPH]] ], [ [[TMP5:%.*]], [[BB]] ]
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ 0, [[BB_NPH]] ], [ [[TMP9:%.*]], [[BB]] ]
; CHECK-NEXT:    [[TMP8:%.*]] = add i64 [[INDVAR]], 2
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr double, double* [[G]], i64 [[TMP8]]
; CHECK-NEXT:    [[TMP9]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[SCEVGEP10:%.*]] = getelementptr double, double* [[G]], i64 [[TMP9]]
; CHECK-NEXT:    [[TMP4:%.*]] = load double, double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[TMP5]] = fadd double [[TMP3]], [[TMP4]]
; CHECK-NEXT:    store double [[TMP5]], double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[TMP9]], [[TMP7]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[RETURN]], label [[BB]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %0 = getelementptr inbounds double, double* %G, i64 1
  store double 1.000000e+00, double* %0, align 8
  %1 = add i32 %N, -1
  %2 = icmp sgt i32 %1, 1
  br i1 %2, label %bb.nph, label %return

bb.nph:
  %tmp = sext i32 %1 to i64
  %tmp7 = add i64 %tmp, -1
  br label %bb

bb:
  %indvar = phi i64 [ 0, %bb.nph ], [ %tmp9, %bb ]
  %tmp8 = add i64 %indvar, 2
  %scevgep = getelementptr double, double* %G, i64 %tmp8
  %tmp9 = add i64 %indvar, 1
  %scevgep10 = getelementptr double, double* %G, i64 %tmp9
  %3 = load double, double* %scevgep10, align 8
  %4 = load double, double* %scevgep, align 8
  %5 = fadd double %3, %4
  store double %5, double* %scevgep, align 8
  %exitcond = icmp eq i64 %tmp9, %tmp7
  br i1 %exitcond, label %return, label %bb

; Should only be one load in the loop.

return:
  ret void
}

;; Here the loaded address isn't available in 'block2' at all, requiring a new
;; GEP to be inserted into it.
define i32 @test8(i32* %p, i32* %q, i32** %Hack, i1 %C) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[P3_PHI_TRANS_INSERT:%.*]] = getelementptr i32, i32* [[Q:%.*]], i32 1
; CHECK-NEXT:    [[PRE_PRE:%.*]] = load i32, i32* [[P3_PHI_TRANS_INSERT]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    [[A:%.*]] = getelementptr i32, i32* [[P:%.*]], i32 1
; CHECK-NEXT:    store i32 0, i32* [[A]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[PRE:%.*]] = phi i32 [ 0, [[BLOCK3]] ], [ [[PRE_PRE]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i32* [ [[P]], [[BLOCK3]] ], [ [[Q]], [[BLOCK2]] ]
; CHECK-NEXT:    [[P3:%.*]] = getelementptr i32, i32* [[P2]], i32 1
; CHECK-NEXT:    ret i32 [[PRE]]
;
block1:
  br i1 %C, label %block2, label %block3

block2:
  br label %block4

block3:
  %A = getelementptr i32, i32* %p, i32 1
  store i32 0, i32* %A
  br label %block4

block4:
  %P2 = phi i32* [%p, %block3], [%q, %block2]
  %P3 = getelementptr i32, i32* %P2, i32 1
  %PRE = load i32, i32* %P3
  ret i32 %PRE
}

;void test9(int N, double* G) {
;  long j;
;  for (j = 1; j < N - 1; j++)
;      G[j+1] = G[j] + G[j+1];
;}

; This requires phi translation of the adds.
define void @test9(i32 %N, double* nocapture %G) nounwind ssp {
; CHECK-LABEL: @test9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[TMP0]], 1
; CHECK-NEXT:    br i1 [[TMP1]], label [[BB_NPH:%.*]], label [[RETURN:%.*]]
; CHECK:       bb.nph:
; CHECK-NEXT:    [[TMP:%.*]] = sext i32 [[TMP0]] to i64
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP]], -1
; CHECK-NEXT:    [[SCEVGEP10_PHI_TRANS_INSERT:%.*]] = getelementptr double, double* [[G:%.*]], i64 1
; CHECK-NEXT:    [[DOTPRE:%.*]] = load double, double* [[SCEVGEP10_PHI_TRANS_INSERT]], align 8
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP2:%.*]] = phi double [ [[DOTPRE]], [[BB_NPH]] ], [ [[TMP4:%.*]], [[BB]] ]
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ 0, [[BB_NPH]] ], [ [[TMP9:%.*]], [[BB]] ]
; CHECK-NEXT:    [[TMP8:%.*]] = add i64 [[INDVAR]], 2
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr double, double* [[G]], i64 [[TMP8]]
; CHECK-NEXT:    [[TMP9]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[SCEVGEP10:%.*]] = getelementptr double, double* [[G]], i64 [[TMP9]]
; CHECK-NEXT:    [[TMP3:%.*]] = load double, double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[TMP4]] = fadd double [[TMP2]], [[TMP3]]
; CHECK-NEXT:    store double [[TMP4]], double* [[SCEVGEP]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[TMP9]], [[TMP7]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[RETURN]], label [[BB]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  add i32 0, 0
  %1 = add i32 %N, -1
  %2 = icmp sgt i32 %1, 1
  br i1 %2, label %bb.nph, label %return

bb.nph:
  %tmp = sext i32 %1 to i64
  %tmp7 = add i64 %tmp, -1
  br label %bb


bb:
  %indvar = phi i64 [ 0, %bb.nph ], [ %tmp9, %bb ]
  %tmp8 = add i64 %indvar, 2
  %scevgep = getelementptr double, double* %G, i64 %tmp8
  %tmp9 = add i64 %indvar, 1
  %scevgep10 = getelementptr double, double* %G, i64 %tmp9
  %3 = load double, double* %scevgep10, align 8
  %4 = load double, double* %scevgep, align 8
  %5 = fadd double %3, %4
  store double %5, double* %scevgep, align 8
  %exitcond = icmp eq i64 %tmp9, %tmp7
  br i1 %exitcond, label %return, label %bb

; Should only be one load in the loop.

return:
  ret void
}

;void test10(int N, double* G) {
;  long j;
;  for (j = 1; j < N - 1; j++)
;      G[j] = G[j] + G[j+1] + G[j-1];
;}

; PR5501
define void @test10(i32 %N, double* nocapture %G) nounwind ssp {
; CHECK-LABEL: @test10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[TMP0]], 1
; CHECK-NEXT:    br i1 [[TMP1]], label [[BB_NPH:%.*]], label [[RETURN:%.*]]
; CHECK:       bb.nph:
; CHECK-NEXT:    [[TMP:%.*]] = sext i32 [[TMP0]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = add i64 [[TMP]], -1
; CHECK-NEXT:    [[SCEVGEP12_PHI_TRANS_INSERT:%.*]] = getelementptr double, double* [[G:%.*]], i64 1
; CHECK-NEXT:    [[DOTPRE:%.*]] = load double, double* [[SCEVGEP12_PHI_TRANS_INSERT]], align 8
; CHECK-NEXT:    [[DOTPRE1:%.*]] = load double, double* [[G]], align 8
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP2:%.*]] = phi double [ [[DOTPRE1]], [[BB_NPH]] ], [ [[TMP6:%.*]], [[BB]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = phi double [ [[DOTPRE]], [[BB_NPH]] ], [ [[TMP4:%.*]], [[BB]] ]
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ 0, [[BB_NPH]] ], [ [[TMP11:%.*]], [[BB]] ]
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr double, double* [[G]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP9:%.*]] = add i64 [[INDVAR]], 2
; CHECK-NEXT:    [[SCEVGEP10:%.*]] = getelementptr double, double* [[G]], i64 [[TMP9]]
; CHECK-NEXT:    [[TMP11]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[SCEVGEP12:%.*]] = getelementptr double, double* [[G]], i64 [[TMP11]]
; CHECK-NEXT:    [[TMP4]] = load double, double* [[SCEVGEP10]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = fadd double [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6]] = fadd double [[TMP5]], [[TMP2]]
; CHECK-NEXT:    store double [[TMP6]], double* [[SCEVGEP12]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[TMP11]], [[TMP8]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[RETURN]], label [[BB]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %0 = add i32 %N, -1
  %1 = icmp sgt i32 %0, 1
  br i1 %1, label %bb.nph, label %return

bb.nph:
  %tmp = sext i32 %0 to i64
  %tmp8 = add i64 %tmp, -1
  br label %bb


bb:
  %indvar = phi i64 [ 0, %bb.nph ], [ %tmp11, %bb ]
  %scevgep = getelementptr double, double* %G, i64 %indvar
  %tmp9 = add i64 %indvar, 2
  %scevgep10 = getelementptr double, double* %G, i64 %tmp9
  %tmp11 = add i64 %indvar, 1
  %scevgep12 = getelementptr double, double* %G, i64 %tmp11
  %2 = load double, double* %scevgep12, align 8
  %3 = load double, double* %scevgep10, align 8
  %4 = fadd double %2, %3
  %5 = load double, double* %scevgep, align 8
  %6 = fadd double %4, %5
  store double %6, double* %scevgep12, align 8
  %exitcond = icmp eq i64 %tmp11, %tmp8
  br i1 %exitcond, label %return, label %bb

; Should only be one load in the loop.

return:
  ret void
}

; Test critical edge splitting.
define i32 @test11(i32* %p, i1 %C, i32 %N) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[N:%.*]], 1
; CHECK-NEXT:    br i1 [[COND]], label [[BLOCK2_BLOCK4_CRIT_EDGE:%.*]], label [[BLOCK5:%.*]]
; CHECK:       block2.block4_crit_edge:
; CHECK-NEXT:    [[PRE_PRE:%.*]] = load i32, i32* [[P:%.*]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    store i32 0, i32* [[P]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[PRE:%.*]] = phi i32 [ [[PRE_PRE]], [[BLOCK2_BLOCK4_CRIT_EDGE]] ], [ 0, [[BLOCK3]] ]
; CHECK-NEXT:    br label [[BLOCK5]]
; CHECK:       block5:
; CHECK-NEXT:    [[RET:%.*]] = phi i32 [ 0, [[BLOCK2]] ], [ [[PRE]], [[BLOCK4]] ]
; CHECK-NEXT:    ret i32 [[RET]]
;
block1:
  br i1 %C, label %block2, label %block3

block2:
  %cond = icmp sgt i32 %N, 1
  br i1 %cond, label %block4, label %block5

block3:
  store i32 0, i32* %p
  br label %block4

block4:
  %PRE = load i32, i32* %p
  br label %block5

block5:
  %ret = phi i32 [ 0, %block2 ], [ %PRE, %block4 ]
  ret i32 %ret
}

declare void @f()
declare void @g(i32)
declare i32 @__CxxFrameHandler3(...)

; Test that loads aren't PRE'd into EH pads.
define void @test12(i32* %p) personality i32 (...)* @__CxxFrameHandler3 {
; CHECK-LABEL: @test12(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    invoke void @f()
; CHECK-NEXT:    to label [[BLOCK2:%.*]] unwind label [[CATCH_DISPATCH:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    invoke void @f()
; CHECK-NEXT:    to label [[BLOCK3:%.*]] unwind label [[CLEANUP:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    ret void
; CHECK:       catch.dispatch:
; CHECK-NEXT:    [[CS1:%.*]] = catchswitch within none [label %catch] unwind label [[CLEANUP2:%.*]]
; CHECK:       catch:
; CHECK-NEXT:    [[C:%.*]] = catchpad within [[CS1]] []
; CHECK-NEXT:    catchret from [[C]] to label [[BLOCK2]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[C1:%.*]] = cleanuppad within none []
; CHECK-NEXT:    store i32 0, i32* [[P:%.*]], align 4
; CHECK-NEXT:    cleanupret from [[C1]] unwind label [[CLEANUP2]]
; CHECK:       cleanup2:
; CHECK-NEXT:    [[C2:%.*]] = cleanuppad within none []
; CHECK-NEXT:    [[NOTPRE:%.*]] = load i32, i32* [[P]], align 4
; CHECK-NEXT:    call void @g(i32 [[NOTPRE]])
; CHECK-NEXT:    cleanupret from [[C2]] unwind to caller
;
block1:
  invoke void @f()
  to label %block2 unwind label %catch.dispatch

block2:
  invoke void @f()
  to label %block3 unwind label %cleanup

block3:
  ret void

catch.dispatch:
  %cs1 = catchswitch within none [label %catch] unwind label %cleanup2

catch:
  %c = catchpad within %cs1 []
  catchret from %c to label %block2

cleanup:
  %c1 = cleanuppad within none []
  store i32 0, i32* %p
  cleanupret from %c1 unwind label %cleanup2

cleanup2:
  %c2 = cleanuppad within none []
  %NOTPRE = load i32, i32* %p
  call void @g(i32 %NOTPRE)
  cleanupret from %c2 unwind to caller
}

; Don't PRE load across potentially throwing calls.

define i32 @test13(i32* noalias nocapture readonly %x, i32* noalias nocapture %r, i32 %a) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[UU:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    store i32 [[UU]], i32* [[R:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    [[VV:%.*]] = load i32, i32* [[X]], align 4
; CHECK-NEXT:    ret i32 [[VV]]
;

entry:
  %tobool = icmp eq i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then


if.then:
  %uu = load i32, i32* %x, align 4
  store i32 %uu, i32* %r, align 4
  br label %if.end


if.end:
  call void @f()
  %vv = load i32, i32* %x, align 4
  ret i32 %vv
}

; Same as test13, but now the blocking function is not immediately in load's
; block.

define i32 @test14(i32* noalias nocapture readonly %x, i32* noalias nocapture %r, i32 %a) {
; CHECK-LABEL: @test14(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[UU:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    store i32 [[UU]], i32* [[R:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    [[VV:%.*]] = load i32, i32* [[X]], align 4
; CHECK-NEXT:    ret i32 [[VV]]
;

entry:
  %tobool = icmp eq i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then


if.then:
  %uu = load i32, i32* %x, align 4
  store i32 %uu, i32* %r, align 4
  br label %if.end


if.end:
  call void @f()
  br label %follow_1

follow_1:
  br label %follow_2

follow_2:
  %vv = load i32, i32* %x, align 4
  ret i32 %vv
}

; Same as test13, but %x here is dereferenceable. A pointer that is
; dereferenceable can be loaded from speculatively without a risk of trapping.
; Since it is OK to speculate, PRE is allowed.

define i32 @test15(i32* noalias nocapture readonly dereferenceable(8) align 4 %x, i32* noalias nocapture %r, i32 %a) nofree nosync {
; CHECK-LABEL: @test15(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[ENTRY_IF_END_CRIT_EDGE:%.*]], label [[IF_THEN:%.*]]
; CHECK:       entry.if.end_crit_edge:
; CHECK-NEXT:    [[VV_PRE:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[UU:%.*]] = load i32, i32* [[X]], align 4
; CHECK-NEXT:    store i32 [[UU]], i32* [[R:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[VV:%.*]] = phi i32 [ [[VV_PRE]], [[ENTRY_IF_END_CRIT_EDGE]] ], [ [[UU]], [[IF_THEN]] ]
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret i32 [[VV]]
;

entry:
  %tobool = icmp eq i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then


if.then:
  %uu = load i32, i32* %x, align 4
  store i32 %uu, i32* %r, align 4
  br label %if.end


if.end:
  call void @f()
  %vv = load i32, i32* %x, align 4
  ret i32 %vv


}

; Same as test14, but %x here is dereferenceable. A pointer that is
; dereferenceable can be loaded from speculatively without a risk of trapping.
; Since it is OK to speculate, PRE is allowed.

define i32 @test16(i32* noalias nocapture readonly dereferenceable(8) align 4 %x, i32* noalias nocapture %r, i32 %a) nofree nosync {
; CHECK-LABEL: @test16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[ENTRY_IF_END_CRIT_EDGE:%.*]], label [[IF_THEN:%.*]]
; CHECK:       entry.if.end_crit_edge:
; CHECK-NEXT:    [[VV_PRE:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[UU:%.*]] = load i32, i32* [[X]], align 4
; CHECK-NEXT:    store i32 [[UU]], i32* [[R:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[VV:%.*]] = phi i32 [ [[VV_PRE]], [[ENTRY_IF_END_CRIT_EDGE]] ], [ [[UU]], [[IF_THEN]] ]
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret i32 [[VV]]
;

entry:
  %tobool = icmp eq i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then


if.then:
  %uu = load i32, i32* %x, align 4
  store i32 %uu, i32* %r, align 4
  br label %if.end


if.end:
  call void @f()
  br label %follow_1


follow_1:
  br label %follow_2

follow_2:
  %vv = load i32, i32* %x, align 4
  ret i32 %vv
}
