/*
 * This file is part of Licq, an instant messaging client for UNIX.
 * Copyright (C) 2012 Licq developers <licq-dev@googlegroups.com>
 *
 * Licq is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Licq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Licq; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef SETTINGS_PLUGINS_H
#define SETTINGS_PLUGINS_H

#include <QObject>

class QPushButton;
class QTreeWidget;
class QTreeWidgetItem;
class QWidget;

namespace LicqQtGui
{
class SettingsDlg;

namespace Settings
{

/**
 * Settings pages for plugins
 */
class Plugins : public QObject
{
  Q_OBJECT

public:
  /**
   * Constructor
   *
   * @param parent Settings dialog
   */
  Plugins(SettingsDlg* parent);

  /// Destructor
  virtual ~Plugins() {}

private slots:
  /// Reload the plugin list
  void updatePluginList();

  /// Update buttons for current selection
  void updatePluginButtons();

  /// Load selected plugin
  void loadPlugin();

  /// Unload selected plugin
  void unloadPlugin();

  /// Enable selected plugin
  void enablePlugin();

  /// Disable selected plugin
  void disablePlugin();

  /// Plugin was double clicked
  void pluginDoubleClicked(QTreeWidgetItem* item, int index);

private:
  /**
   * Setup page for plugin management
   *
   * @param parent Parent widget for page
   * @return a widget with the plugin management
   */
  QWidget* createPagePlugins(QWidget* parent);

  QTreeWidget* myPluginsList;
  QPushButton* myLoadButton;
  QPushButton* myUnloadButton;
  QPushButton* myEnableButton;
  QPushButton* myDisableButton;
};

} // namespace Settings
} // namespace LicqQtGui

#endif
