/***************************************************************************
             addcontactnotification.cpp - AddressBookService notifications
                             -------------------
    begin                : Saturday August 7 2010
    copyright            : (C) 2010 by Timo Tambet
    email                : ttambet@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addressbooknotifications.h"
#include "../kmessdebug.h"
#include "notificationmanager.h"
#include "../network/soap/addressbookservice.h"


#include <KLocale>
#include <KNotification>

// Class constructor
AddressBookNotifications::AddressBookNotifications( NotificationManager* manager )
: manager_(manager)
{
  // Connect the activation signal to process notification actions
  connect( manager_, SIGNAL( eventActivated(NotificationManager::EventSettings, NotificationManager::Buttons) ),
           this,     SLOT  (       activate(NotificationManager::EventSettings, NotificationManager::Buttons) ) );
}



// Execute the action triggered in a notification
void AddressBookNotifications::activate( NotificationManager::EventSettings settings, NotificationManager::Buttons button )
{
  // The signal wasn't meant for us
  if( settings.sender != this )
  {
    return;
  }

  switch( button )
  {
    case NotificationManager::BUTTON_HIDE:
#ifdef KMESSDEBUG_ADDRESSBOOKNOTIFICATIONS
      kmDebug() << "Hiding added contact notification";
#endif
      break;
    default:
#ifdef KMESSDEBUG_ADDRESSBOOKNOTIFICATIONS
      kmDebug() << "Invalid button" << button;
#endif
      return;
  }
}



// Notify the user about this event (a new contact adding success)
void AddressBookNotifications::notify( const QString& id, AddressBookService::AddressBookUpdate updateType )
{
  QString text;
  QString notifyName;

  switch( updateType )
  {
    case AddressBookService::ContactAdded:
    case AddressBookService::ContactDeleted:
    case AddressBookService::ContactDeletedFromGroup:
    case AddressBookService::ContactAddedToGroup:
    case AddressBookService::ContactBlocked:
    case AddressBookService::ContactUnblock:
      notifyName = "contact changed";
      break;

    case AddressBookService::GroupAdded:
    case AddressBookService::GroupDeleted:
    case AddressBookService::GroupRenamed:
      notifyName = "group changed";
      break;

    default:
      kmWarning() << "Unknown AB change type:" << updateType;
      break;
  }

  if ( updateType == AddressBookService::ContactAdded )
  {
    // id holds the new contact's handle
    text = i18n( "<html>Contact <b>%1</b> added successfully.</html>", id );
  }
  else if ( updateType == AddressBookService::ContactDeleted )
  {
    // FIXME: Add Contact name in addressbookservice.cpp
    text = i18n( "<html>Contact deleted successfully</html>" );
  }
  else if ( updateType == AddressBookService::GroupAdded )
  {
    // FIXME: Add group name in addressbookservice.cpp
    text = i18n( "<html>Group added successfully.</html>" );
  }
  else if ( updateType == AddressBookService::GroupDeleted )
  {
    // FIXME: Add group name in addressbookservice.cpp
    text = i18n( "<html>Group deleted successfully.</html>" );
  }
  else if ( updateType == AddressBookService::GroupRenamed )
  {
    text = i18n( "<html>Group <b>%1</b> successfully renamed.</html>", id );
  }
  else if ( updateType == AddressBookService::ContactUnblock )
  {
     text = i18n( "<html>Contact <b>%1</b> has been unblocked.</html>", id );
  }
  else if ( updateType == AddressBookService::ContactBlocked )
  {
    text = i18n( "<html>Contact <b>%1</b> has been blocked.</html>", id );
  }
  else if ( updateType == AddressBookService::ContactAddedToGroup )
  {
    // FIXME: Add contact name in addressbookservice.cpp
    text = i18n( "<html>Contact added to group.</html>" );
  }
  else if ( updateType == AddressBookService::ContactDeletedFromGroup )
  {
    // FIXME: Add contact name in addressbookservice.cpp
    text = i18n( "<html>Contact removed from group.</html>" );
  }

  NotificationManager::EventSettings settings;
  settings.sender  = this;
  settings.widget  = 0;
  settings.contact = 0;
  settings.buttons = NotificationManager::BUTTON_HIDE;

  manager_->notify( notifyName, text, settings );
}



#include "addressbooknotifications.moc"
