# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
DEBIAN_RELEASES += 11
DEBIAN_11_CODENAME = bullseye

.PHONY: all
all:: debian-cloud-11.$(GARDEN_ARCH).qcow2 debian-cloud-11.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/debian/debian-11-genericcloud-$(call map_to_debian_arch,$(GARDEN_ARCH))-daily.qcow2

$(GARDEN_DL_DIR)/debian/debian-11-genericcloud-amd64-daily.qcow2 $(GARDEN_DL_DIR)/debian/debian-11-genericcloud-arm64-daily.qcow2: $(GARDEN_DL_DIR)/debian/debian-11-genericcloud-%-daily.qcow2: | $(GARDEN_DL_DIR)/debian
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud.debian.org/images/cloud/$(DEBIAN_11_CODENAME)/daily/latest/debian-11-genericcloud-$*-daily.qcow2)

$(GARDEN_DL_DIR)/debian/debian-cloud-11.x86_64.qcow2: | $(GARDEN_DL_DIR)/debian $(GARDEN_DL_DIR)/debian/debian-11-genericcloud-amd64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/debian/debian-cloud-11.aarch64.qcow2: | $(GARDEN_DL_DIR)/debian $(GARDEN_DL_DIR)/debian/debian-11-genericcloud-arm64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-cloud-11.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-11-genericcloud-*.qcow2
