/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ContextBeanFactoryReference
implements BeanFactoryReference {
    private ApplicationContext applicationContext;

    public ContextBeanFactoryReference(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public BeanFactory getFactory() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("ApplicationContext owned by this BeanFactoryReference has been released");
        }
        return this.applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() {
        if (this.applicationContext == null) return;
        ContextBeanFactoryReference contextBeanFactoryReference = this;
        synchronized (contextBeanFactoryReference) {
            ApplicationContext applicationContext = this.applicationContext;
            this.applicationContext = null;
            // ** MonitorExit[savedCtx] (shouldn't be in output)
            if (applicationContext == null || !(applicationContext instanceof ConfigurableApplicationContext)) return;
            ((ConfigurableApplicationContext)applicationContext).close();
            return;
        }
    }
}

