/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocLookupComparator;

class StringSortedHitQueue
extends FieldSortedHitQueue {
    StringSortedHitQueue(IndexReader reader, String string_field, int size) throws IOException {
        super(reader, string_field, size);
    }

    protected ScoreDocLookupComparator createComparator(IndexReader reader, String field) throws IOException {
        return StringSortedHitQueue.comparator(reader, field);
    }

    static ScoreDocLookupComparator comparator(IndexReader reader, String fieldname) throws IOException {
        TermEnum enumerator = reader.terms(new Term(fieldname, ""));
        return StringSortedHitQueue.comparator(reader, enumerator, fieldname);
    }

    static ScoreDocLookupComparator comparator(final IndexReader reader, final TermEnum enumerator, String fieldname) throws IOException {
        final String field = fieldname.intern();
        return new ScoreDocLookupComparator(){
            protected final int[] fieldOrder = this.generateSortIndex();
            protected String[] terms;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int[] generateSortIndex() throws IOException {
                int[] retArray = new int[reader.maxDoc()];
                String[] mterms = new String[reader.maxDoc()];
                if (retArray.length > 0) {
                    TermDocs termDocs = reader.termDocs();
                    int t = 0;
                    try {
                        if (enumerator.term() == null) {
                            throw new RuntimeException("no terms in field " + field);
                        }
                        do {
                            Term term;
                            if ((term = enumerator.term()).field() != field) {
                                break;
                            }
                            if (t >= mterms.length) {
                                throw new RuntimeException("there are more terms than documents in field \"" + field + "\"");
                            }
                            mterms[t] = term.text();
                            termDocs.seek(enumerator);
                            while (termDocs.next()) {
                                retArray[termDocs.doc()] = t;
                            }
                            ++t;
                        } while (enumerator.next());
                    }
                    finally {
                        termDocs.close();
                    }
                    if (t < mterms.length) {
                        this.terms = new String[t];
                        System.arraycopy(mterms, 0, this.terms, 0, t);
                    } else {
                        this.terms = mterms;
                    }
                }
                return retArray;
            }

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = this.fieldOrder[i.doc];
                int fj = this.fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public final int compareReverse(ScoreDoc i, ScoreDoc j) {
                int fi = this.fieldOrder[i.doc];
                int fj = this.fieldOrder[j.doc];
                if (fi > fj) {
                    return -1;
                }
                if (fi < fj) {
                    return 1;
                }
                return 0;
            }

            public final boolean sizeMatches(int n) {
                return this.fieldOrder.length == n;
            }

            public Comparable sortValue(ScoreDoc i) {
                return this.terms[this.fieldOrder[i.doc]];
            }

            public int sortType() {
                return 3;
            }
        };
    }
}

