/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __AGGREGATE_HPP_INCLUDED
#define __AGGREGATE_HPP_INCLUDED

#include <list>
#include "frontend/ast/Expression.hpp"
#include "frontend/ast/ElementAssociation.hpp"

namespace ast {

//! VHDL aggregate
/** This class represents an VHDL aggregate.
 */
class Aggregate : public Expression {
public:
	//! c'tor
	/** @param assocs list of element associations.
          * @param loc location of the aggregate.
          */
	Aggregate(
		std::list<ElementAssociation*>* assocs,
		Location loc
		) : 	Expression(loc),
			associations(assocs) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "Aggregate (";
		util::MiscUtil::listPut(this->associations, stream, ", ");
		stream << ")";
	}

	/** list of elements associations. */
	std::list<ElementAssociation*> *associations;

protected:
	/** Destructor */
	virtual ~Aggregate() {
		util::MiscUtil::lterminate(associations);
	}
};

}; /* namespace ast */

#endif /* __AGGREGATE_HPP_INCLUDED */
