/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class SequenceReader {
    private File seqFile;
    private Vector seqs;
    private boolean reading = false;

    public SequenceReader() {
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
        System.setSecurityManager(sm);
        fc.addChoosableFileFilter(new SequenceFilter());
        int returnVal = fc.showOpenDialog(fc);
        if (returnVal == 0) {
            this.seqFile = fc.getSelectedFile();
            this.readSequenceFile();
            this.reading = true;
        }
    }

    public SequenceReader(File seqFile) {
        this.seqFile = seqFile;
        this.readSequenceFile();
        this.reading = true;
    }

    public SequenceReader(String seqString) {
        this.readSequenceString(seqString);
        this.reading = true;
    }

    public boolean isReading() {
        return this.reading;
    }

    public Vector readSequenceFile() {
        BufferedReader in = null;
        try {
            int index1;
            in = new BufferedReader(new FileReader(this.seqFile));
            String line = in.readLine();
            if (line.startsWith(">")) {
                return this.readFastaFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            int index = line.indexOf("PileUp");
            if (index > -1) {
                return this.readMSFFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            index = line.indexOf("!!AA_MULTIPLE_ALIGNMENT");
            if (index > -1) {
                return this.readMSFFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            index = line.indexOf("!!NA_MULTIPLE_ALIGNMENT");
            if (index > -1) {
                return this.readMSFFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            index = line.indexOf("CLUSTAL");
            if (index > -1) {
                return this.readClustalFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            index = line.indexOf(":");
            if (index > -1 && (index = line.indexOf(",", index)) > -1 && (index1 = line.indexOf(",", index + 1)) > -1 && index1 - index == 2 && (index = line.indexOf(",", index1 + 1)) > -1 && index - index1 == 2) {
                this.readJPredFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            System.err.println("File format not recognised. Supported formats are 'fasta', 'msf', 'clustal', and 'jpred'.");
        }
        catch (IOException e) {
            System.out.println("SequenceReader Error");
        }
        return null;
    }

    public Vector readSequenceString(String seqString) {
        BufferedReader in = null;
        try {
            int index1;
            in = new BufferedReader(new StringReader(seqString));
            String line = in.readLine();
            if (line.startsWith(">")) {
                return this.readFastaFile(new BufferedReader(new StringReader(seqString)));
            }
            int index = line.indexOf("PileUp");
            if (index > -1) {
                return this.readMSFFile(new BufferedReader(new StringReader(seqString)));
            }
            index = line.indexOf("!!AA_MULTIPLE_ALIGNMENT");
            if (index > -1) {
                return this.readMSFFile(new BufferedReader(new StringReader(seqString)));
            }
            index = line.indexOf("!!NA_MULTIPLE_ALIGNMENT");
            if (index > -1) {
                return this.readMSFFile(new BufferedReader(new StringReader(seqString)));
            }
            index = line.indexOf("CLUSTAL");
            if (index > -1) {
                return this.readClustalFile(new BufferedReader(new StringReader(seqString)));
            }
            index = line.indexOf(":");
            if (index > -1 && (index = line.indexOf(",", index)) > -1 && (index1 = line.indexOf(",", index + 1)) > -1 && index1 - index == 2 && (index = line.indexOf(",", index1 + 1)) > -1 && index - index1 == 2) {
                this.readJPredFile(new BufferedReader(new StringReader(seqString)));
            }
        }
        catch (IOException e) {
            System.out.println("SequenceReader Error");
        }
        return null;
    }

    public Vector readFastaFile(BufferedReader in) {
        this.seqs = new Vector();
        String seqString = "";
        try {
            String line;
            String name = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (!seqString.equals("")) {
                        this.seqs.add(new Sequence(name, seqString));
                        seqString = "";
                        name = line.substring(1);
                        continue;
                    }
                    if (!line.startsWith(">") || !seqString.equals("")) continue;
                    name = line.substring(1);
                    continue;
                }
                seqString = seqString.concat(line);
            }
            in.close();
            if (!seqString.equals("")) {
                this.seqs.add(new Sequence(name, seqString));
            }
        }
        catch (IOException e) {
            System.out.println("SequenceReader FASTA Error");
        }
        return this.seqs;
    }

    public Vector readMSFFile(BufferedReader in) {
        this.seqs = new Vector();
        String seqString = "";
        try {
            String line;
            Sequence seq = null;
            String type = null;
            boolean header = true;
            Hashtable<String, Integer> seqIndex = new Hashtable<String, Integer>();
            int num = 0;
            while ((line = in.readLine()) != null) {
                StringTokenizer st;
                if (line.startsWith("//")) {
                    header = false;
                }
                if (line.equals("")) continue;
                if (header) {
                    st = new StringTokenizer(line, " ");
                    while (st.hasMoreTokens()) {
                        String bit = st.nextToken(" ").trim();
                        if (bit.startsWith("Name:")) {
                            String name = st.nextToken(" ").trim();
                            seq = new Sequence(name, "");
                            this.seqs.add(num, seq);
                            if (type != null) {
                                if (type.equalsIgnoreCase("P")) {
                                    seq.setType(true);
                                } else if (type.equalsIgnoreCase("N")) {
                                    seq.setType(false);
                                }
                            }
                            seqIndex.put(name, new Integer(num));
                            ++num;
                            continue;
                        }
                        if (bit.startsWith("Weight:")) {
                            seq.setWeight(Float.parseFloat(st.nextToken().trim()));
                            continue;
                        }
                        if (!bit.startsWith("Type:")) continue;
                        type = st.nextToken(" ").trim();
                    }
                    continue;
                }
                int index = line.indexOf(" ");
                if (index <= -1) continue;
                String name = line.substring(0, index);
                if (!seqIndex.containsKey(name)) {
                    System.out.println("Error reading sequence ");
                    continue;
                }
                st = new StringTokenizer(line.substring(index), " ");
                seqString = new String();
                while (st.hasMoreTokens()) {
                    seqString = seqString.concat(st.nextToken(" ").trim());
                }
                int seqInd = (Integer)seqIndex.get(name);
                seq = (Sequence)this.seqs.elementAt(seqInd);
                seq.appendToSequence(seqString);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("SequenceReader MSF Error");
        }
        return this.seqs;
    }

    public Vector readClustalFile(BufferedReader in) {
        this.seqs = new Vector();
        String seqString = "";
        try {
            String line;
            Hashtable<String, Integer> seqIndex = new Hashtable<String, Integer>();
            int num = 0;
            while ((line = in.readLine()) != null) {
                Sequence seq;
                int index;
                if ((line = line.trim()).equals("") || line.startsWith("CLUSTAL ") || (index = line.indexOf(" ")) <= -1) continue;
                String name = line.substring(0, index);
                if (!seqIndex.containsKey(name)) {
                    seqIndex.put(name, new Integer(num));
                    seq = new Sequence(name, "");
                    this.seqs.add(num++, seq);
                }
                StringTokenizer st = new StringTokenizer(line.substring(index), " ");
                seqString = new String();
                while (st.hasMoreTokens()) {
                    seqString = seqString.concat(st.nextToken(" ").trim());
                }
                int seqInd = (Integer)seqIndex.get(name);
                seq = (Sequence)this.seqs.elementAt(seqInd);
                seq.appendToSequence(seqString);
            }
        }
        catch (IOException e) {
            System.out.println("SequenceReader Clutal Error");
        }
        return this.seqs;
    }

    public Vector readJPredFile(BufferedReader in) {
        this.seqs = new Vector();
        System.out.println("readJPredFile");
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int index;
                if ((line = line.trim()).equals("") || (index = line.indexOf(":")) <= -1) continue;
                int index1 = line.indexOf(";") + 1;
                if (index1 < 0) {
                    index1 = 0;
                }
                String name = line.substring(index1, index);
                line = line.substring(index + 1);
                StringTokenizer st = new StringTokenizer(line, ",");
                StringBuffer seqString = new StringBuffer();
                while (st.hasMoreTokens()) {
                    seqString = seqString.append(st.nextToken(",").trim());
                }
                Sequence seq = new Sequence(name, seqString.toString());
                this.seqs.add(seq);
            }
        }
        catch (IOException e) {
            System.out.println("SequenceReader JPred Error");
        }
        return this.seqs;
    }

    public int getNumberOfSequences() {
        return this.seqs.size();
    }

    public Sequence getSequence(int index) {
        return (Sequence)this.seqs.get(index);
    }

    public Vector getSequenceVector() {
        return this.seqs;
    }

    public File getSequenceFile() {
        return this.seqFile;
    }
}

