
/*
 * (C) Copyright 2005- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */

#pragma once

#include "grib_accessor_class_gen.h"

class grib_accessor_gds_not_present_bitmap_t : public grib_accessor_gen_t
{
public:
    grib_accessor_gds_not_present_bitmap_t() :
        grib_accessor_gen_t() { class_name_ = "gds_not_present_bitmap"; }
    grib_accessor* create_empty_accessor() override { return new grib_accessor_gds_not_present_bitmap_t{}; }
    long get_native_type() override;
    int pack_double(const double* val, size_t* len) override;
    int unpack_double(double* val, size_t* len) override;
    int value_count(long*) override;
    void init(const long, grib_arguments*) override;

private:
    const char* missing_value_;
    const char* number_of_values_;
    const char* number_of_points_;
    const char* latitude_of_first_point_;
    const char* ni_;
};
