//this file is autogenerated using stringify.bat (premake --stringify) in the build folder of this project
static const char* pairsKernelsCL= \
"__kernel void moveObjectsKernel(__global float4* posOrnColors, int numObjects)\n"
"{\n"
"	int iGID = get_global_id(0);\n"
"	if (iGID>=numObjects)\n"
"		return;\n"
"	__global float4* positions = &posOrnColors[0];\n"
"	if (iGID<0.5*numObjects)\n"
"	{\n"
"		positions[iGID].y +=0.01f;\n"
"	}\n"
"	__global float4* colors = &posOrnColors[numObjects*2];\n"
"	colors[iGID] = (float4)(0,0,1,1);\n"
"}\n"
"__kernel void colorPairsKernel2(__global float4* posOrnColors, int numObjects, __global const int4* pairs, int indexOffset, int numPairs)\n"
"{\n"
"	int iPairId = get_global_id(0);\n"
"	if (iPairId>=numPairs)\n"
"		return;\n"
"	__global float4* colors = &posOrnColors[numObjects*2];\n"
"	int iObjectA = pairs[iPairId].x-indexOffset;\n"
"	int iObjectB = pairs[iPairId].y-indexOffset;\n"
"	colors[iObjectA] = (float4)(1,0,0,1);\n"
"	colors[iObjectB] = (float4)(1,0,0,1);\n"
"}\n"
"__kernel void \n"
"  sineWaveKernel( __global float4* posOrnColors, __global float* pBodyTimes,float timeStepPos, float mAmplitude,const int numNodes)\n"
"{\n"
"	int nodeID = get_global_id(0);\n"
"	if( nodeID < numNodes )\n"
"	{\n"
"		pBodyTimes[nodeID] += timeStepPos;\n"
"		float4 position = posOrnColors[nodeID];\n"
"		position.x = native_cos(pBodyTimes[nodeID]*2.17f)*mAmplitude + native_sin(pBodyTimes[nodeID])*mAmplitude*0.5f;\n"
"		position.y = native_cos(pBodyTimes[nodeID]*1.38f)*mAmplitude + native_sin(pBodyTimes[nodeID]*mAmplitude);\n"
"		position.z = native_cos(pBodyTimes[nodeID]*2.17f)*mAmplitude + native_sin(pBodyTimes[nodeID]*0.777f)*mAmplitude;\n"
"		\n"
"		posOrnColors[nodeID] = position;\n"
"		__global float4* colors = &posOrnColors[numNodes*2];\n"
"		colors[nodeID] = (float4)(0,0,1,1);\n"
"	}\n"
"}\n"
"typedef struct \n"
"{\n"
"	float			fx;\n"
"	float			fy;\n"
"	float			fz;\n"
"	int	uw;\n"
"} b3AABBCL;\n"
"__kernel void updateAabbSimple( __global float4* posOrnColors, const int numNodes, __global b3AABBCL* pAABB)\n"
"{\n"
"	int nodeId = get_global_id(0);\n"
"	if( nodeId < numNodes )\n"
"	{\n"
"	\n"
"		b3AABBCL orgAabbMin = pAABB[nodeId*2];\n"
"		b3AABBCL orgAabbMax = pAABB[nodeId*2+1];\n"
"		int orgNodeId = orgAabbMin.uw;\n"
"		int orgBroadphaseIndex = orgAabbMax.uw;\n"
"		\n"
"		float4 position = posOrnColors[nodeId];\n"
"		float4 argAabbMinVec = (float4)(orgAabbMin.fx,orgAabbMin.fy,orgAabbMin.fz,0.f);\n"
"		float4 argAabbMaxVec = (float4)(orgAabbMax.fx,orgAabbMax.fy,orgAabbMax.fz,0.f);\n"
"		float4 halfExtents = 0.5f*(argAabbMaxVec-argAabbMinVec);\n"
"		\n"
"		pAABB[nodeId*2].fx = position.x-halfExtents.x;\n"
"		pAABB[nodeId*2].fy = position.y-halfExtents.y;\n"
"		pAABB[nodeId*2].fz = position.z-halfExtents.z;\n"
"		pAABB[nodeId*2].uw = orgNodeId;\n"
"		pAABB[nodeId*2+1].fx = position.x+halfExtents.x;\n"
"		pAABB[nodeId*2+1].fy = position.y+halfExtents.y;\n"
"		pAABB[nodeId*2+1].fz = position.z+halfExtents.z;\n"
"		pAABB[nodeId*2+1].uw = orgBroadphaseIndex;		\n"
"	}\n"
"}\n"
;
