#---------------------------------------------------------------------------------------------------
#  Compiler.cmake
#---------------------------------------------------------------------------------------------------

#--- Need to locate thead libraries and options to set properly some compilation flags ---

find_package(Threads)

#--- Print the final compiler flags ---

message(STATUS "BornAgain Platform: ${BA_PLATFORM}")
message(STATUS "BornAgain Architecture: ${BA_ARCHITECTURE}")

message(STATUS "Default compiler flags (may be changed in later CMake steps):")
if(CMAKE_CONFIGURATION_TYPES)
    if("Release" IN_LIST CMAKE_CONFIGURATION_TYPES)
        message("    Release: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELEASE}")
    endif()
    if("Debug" IN_LIST CMAKE_CONFIGURATION_TYPES)
        message("    Debug: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_DEBUG}")
    endif()
    if("RelWithDebInfo" IN_LIST CMAKE_CONFIGURATION_TYPES)
        message("    RelWithDebInfo: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELWITHDEBINFO}")
    endif()
    if("MinSizeRel" IN_LIST CMAKE_CONFIGURATION_TYPES)
        message("    MinSizeRel: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_MINSIZEREL}")
    endif()
else()
    if(CMAKE_BUILD_TYPE STREQUAL "Release")
        message("    ${CMAKE_BUILD_TYPE}: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELEASE}")
    elseif(CMAKE_BUILD_TYPE STREQUAL "Debug")
        message("    ${CMAKE_BUILD_TYPE}: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_DEBUG}")
    elseif(CMAKE_BUILD_TYPE STREQUAL "RelWithDebInfo")
        message("    ${CMAKE_BUILD_TYPE}: ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELWITHDEBINFO}")
    endif()
endif()

message(STATUS "Shared linker Flags: ${CMAKE_SHARED_LINKER_FLAGS}")
message(STATUS "Exe linker Flags: ${CMAKE_EXE_LINKER_FLAGS}")
