//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/FeNiBilayerBuilder.h
//! @brief     Defines various sample builder classes to
//!            test polarized specular computations
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2020
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_SAMPLE_STANDARDSAMPLES_FENIBILAYERBUILDER_H
#define BORNAGAIN_SAMPLE_STANDARDSAMPLES_FENIBILAYERBUILDER_H

class MultiLayer;


namespace ExemplarySamples {

MultiLayer* createFeNiBilayer();

} // namespace ExemplarySamples

namespace ExemplarySamples {

MultiLayer* createFeNiBilayerTanh();

} // namespace ExemplarySamples

namespace ExemplarySamples {

MultiLayer* createFeNiBilayerNC();

} // namespace ExemplarySamples

namespace ExemplarySamples {

MultiLayer* createFeNiBilayerSpinFlip();

} // namespace ExemplarySamples

namespace ExemplarySamples {

MultiLayer* createFeNiBilayerSpinFlipTanh();

} // namespace ExemplarySamples

namespace ExemplarySamples {

MultiLayer* createFeNiBilayerSpinFlipNC();

} // namespace ExemplarySamples

#endif // BORNAGAIN_SAMPLE_STANDARDSAMPLES_FENIBILAYERBUILDER_H
