#ifndef _DUDE_H_
#define _DUDE_H_

#include <string>
#include <vector>


struct PartInfo {
    std::string name;
    std::string desc;
    std::string cfgname;
    int cfglineno;
};


struct ProgrammerInfo {
    std::string name;
    std::string desc;
    std::string cfgname;
    int cfglineno;
};


struct AvrProgrammerConfig {
    std::string name;
    
    uint32_t part_flash_pagesize;
    uint32_t part_flash_pagecount;
    uint32_t part_eeprom_pagesize;
    uint32_t part_eeprom_pagecount;
    uint32_t part_signature;
    
    uint8_t isp_enter_timeout;
    uint8_t isp_enter_stabDelay;
    uint8_t isp_enter_cmdexeDelay;
    uint8_t isp_enter_synchLoops;
    uint8_t isp_enter_byteDelay;
    uint8_t isp_enter_pollValue;
    uint8_t isp_enter_pollIndex;
    uint8_t isp_enter_cmd1;
    uint8_t isp_enter_cmd2;
    uint8_t isp_enter_cmd3;
    uint8_t isp_enter_cmd4;
    uint8_t isp_leave_preDelay;
    uint8_t isp_leave_postDelay;
    uint8_t isp_erase_eraseDelay;
    uint8_t isp_erase_pollMethod;
    uint8_t isp_erase_cmd1;
    uint8_t isp_erase_cmd2;
    uint8_t isp_erase_cmd3;
    uint8_t isp_erase_cmd4;
    
    uint8_t isp_program_flash_mode;
    uint8_t isp_program_flash_delay;
    uint8_t isp_program_flash_cmd1;
    uint8_t isp_program_flash_cmd2;
    uint8_t isp_program_flash_cmd3;
    uint8_t isp_program_flash_poll1;
    uint8_t isp_program_flash_poll2;
    uint8_t isp_read_flash_cmd1;
    
    uint8_t isp_program_eeprom_mode;
    uint8_t isp_program_eeprom_delay;
    uint8_t isp_program_eeprom_cmd1;
    uint8_t isp_program_eeprom_cmd2;
    uint8_t isp_program_eeprom_cmd3;
    uint8_t isp_program_eeprom_poll1;
    uint8_t isp_program_eeprom_poll2;
    uint8_t isp_read_eeprom_cmd1;
    
    uint8_t isp_program_fuse_cmd1;
    uint8_t isp_program_fuse_cmd2;
    uint8_t isp_program_fuse_cmd3;
    uint8_t isp_program_fuse_cmd4;
    uint8_t isp_read_fuse_RetAddr;
    uint8_t isp_read_fuse_cmd1;
    uint8_t isp_read_fuse_cmd2;
    uint8_t isp_read_fuse_cmd3;
    uint8_t isp_read_fuse_cmd4;
    
    uint8_t isp_program_lock_cmd1;
    uint8_t isp_program_lock_cmd2;
    uint8_t isp_program_lock_cmd3;
    uint8_t isp_program_lock_cmd4;
    uint8_t isp_read_lock_RetAddr;
    uint8_t isp_read_lock_cmd1;
    uint8_t isp_read_lock_cmd2;
    uint8_t isp_read_lock_cmd3;
    uint8_t isp_read_lock_cmd4;
    
    uint8_t isp_read_signature_RetAddr;
    uint8_t isp_read_signature_cmd1;
    uint8_t isp_read_signature_cmd2;
    uint8_t isp_read_signature_cmd3;
    uint8_t isp_read_signature_cmd4;

    uint8_t isp_read_osccal_RetAddr;
    uint8_t isp_read_osccal_cmd1;
    uint8_t isp_read_osccal_cmd2;
    uint8_t isp_read_osccal_cmd3;
    uint8_t isp_read_osccal_cmd4;
    
    
};


extern std::vector<ProgrammerInfo> dude_programmers;
extern std::vector<PartInfo> dude_parts;

void dude_initialize();
void dude_loadAvrProgrammerConfig(AvrProgrammerConfig & cfg, const std::string & name);

#endif // _DUDE_H_
