/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier.structurals;

import java.util.HashSet;
import java.util.Hashtable;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.verifier.structurals.ExceptionHandler;

public class ExceptionHandlers {
    private Hashtable<InstructionHandle, HashSet<ExceptionHandler>> exceptionhandlers = new Hashtable();

    public ExceptionHandlers(MethodGen mg) {
        CodeExceptionGen[] cegs = mg.getExceptionHandlers();
        int i = 0;
        while (i < cegs.length) {
            ExceptionHandler eh = new ExceptionHandler(cegs[i].getCatchType(), cegs[i].getHandlerPC());
            InstructionHandle ih = cegs[i].getStartPC();
            while (ih != cegs[i].getEndPC().getNext()) {
                HashSet<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
                ih = ih.getNext();
            }
            ++i;
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle ih) {
        HashSet<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
        if (hs == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] ret = new ExceptionHandler[hs.size()];
        return hs.toArray(ret);
    }
}

