/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jiapi.file.ClassFile;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.Field;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.attribute.Attribute;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.JiapiField;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.Loader;

public class ClassViewer
extends JFrame
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private LinkedList<ClassFile> clazzes = new LinkedList();
    private JTree tree;
    private JTextArea right;

    public static void main(String[] args) throws Exception {
        ClassViewer cv = new ClassViewer();
        Loader l = new Loader();
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            JiapiClass cf = null;
            cf = f.exists() ? l.loadClass(new FileInputStream(f)) : l.loadClass(args[i]);
            cv.addClassFile(cf.getClassFile());
        }
        cv.createUI();
        cv.setVisible(true);
    }

    private void createUI() {
        this.tree = this.createTree();
        this.tree.addTreeSelectionListener(this);
        this.right = new JTextArea();
        JScrollPane lPane = new JScrollPane(this.tree);
        JScrollPane rPane = new JScrollPane(this.right);
        JSplitPane sp = new JSplitPane(1, lPane, rPane);
        sp.setDividerLocation(0.5);
        this.add(sp);
        this.setSize(400, 300);
    }

    private JTree createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("/");
        for (int i = 0; i < this.clazzes.size(); ++i) {
            Method[] methods;
            ClassFile cf = this.clazzes.get(i);
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(new TreeNode(cf));
            root.add(classNode);
            DefaultMutableTreeNode cp = new DefaultMutableTreeNode(new TreeNode(cf.getConstantPool()));
            classNode.add(cp);
            this.addAttributeNodes(classNode, "Class attributes", cf.getAttributes());
            Field[] fields = cf.getFields().toArray(new Field[0]);
            if (fields.length > 0) {
                DefaultMutableTreeNode fieldsNode = new DefaultMutableTreeNode("Fields");
                classNode.add(fieldsNode);
                for (int j = 0; j < fields.length; ++j) {
                    DefaultMutableTreeNode fieldNode = new DefaultMutableTreeNode(new TreeNode(fields[j]));
                    fieldsNode.add(fieldNode);
                    this.addAttributeNodes(fieldNode, "Field attributes", fields[j].getAttributes());
                }
            }
            if ((methods = cf.getMethods().toArray(new Method[0])).length <= 0) continue;
            DefaultMutableTreeNode methodsNode = new DefaultMutableTreeNode("Methods");
            classNode.add(methodsNode);
            for (int j = 0; j < methods.length; ++j) {
                DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode(new TreeNode(methods[j]));
                methodsNode.add(methodNode);
                this.addAttributeNodes(methodNode, "Method attributes", methods[j].getAttributes());
            }
        }
        JTree tree = new JTree(root);
        return tree;
    }

    private void addAttributeNodes(DefaultMutableTreeNode parent, String label, List<Attribute> attrs) {
        if (attrs.size() > 0) {
            DefaultMutableTreeNode attrsNode = new DefaultMutableTreeNode(label);
            parent.add(attrsNode);
            for (int i = 0; i < attrs.size(); ++i) {
                DefaultMutableTreeNode attrNode = new DefaultMutableTreeNode(new TreeNode(attrs.get(i)));
                attrsNode.add(attrNode);
            }
        }
    }

    private void addClassFile(ClassFile cf) {
        this.clazzes.add(cf);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (o instanceof TreeNode) {
            TreeNode tn = (TreeNode)o;
            this.right.setText(this.toText(tn.data));
        }
    }

    private String toText(Object data) {
        if (data instanceof ClassFile) {
            ClassFile cf = (ClassFile)data;
            String txt = "Major: " + cf.getMajorVersion() + "\n";
            txt = txt + "Minor: " + cf.getMinorVersion() + "\n";
            txt = txt + Modifier.toString(cf.getAccessFlags() & 0xFFDF) + " class " + cf.getClassName() + " extends " + cf.getSuperclassName() + "\n";
            List l = cf.getInterfaces();
            if (l.size() > 0) {
                txt = txt + "Implemented interfaces: \n";
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    txt = txt + i.next() + "\n";
                }
            }
            return txt;
        }
        if (data instanceof Field) {
            JiapiField jf = new JiapiField((Field)data);
            return Modifier.toString(jf.getModifiers()) + " " + jf.getTypeName();
        }
        if (data instanceof Method) {
            JiapiMethod jm = new JiapiMethod((Method)data);
            StringBuffer sb = new StringBuffer();
            sb.append(jm + "\n");
            sb.append(" max-stack: " + jm.getMaxStack() + "\n");
            sb.append(" max-locals: " + jm.getMaxLocals() + "\n");
            sb.append("-------\n");
            InstructionList il = jm.getInstructionList();
            for (int i = 0; i < il.size(); ++i) {
                sb.append(i + ": " + il.get(i) + "\n");
            }
            return sb.toString();
        }
        return data.toString();
    }

    private class TreeNode {
        private String label;
        private Object data;

        public TreeNode(ClassFile cf) {
            this.label = cf.getClassName();
            this.data = cf;
        }

        public TreeNode(ConstantPool constantPool) {
            this.label = "Constant pool";
            this.data = constantPool;
        }

        public TreeNode(Attribute attribute) {
            this.label = attribute.getName();
            this.data = attribute;
        }

        public TreeNode(Field field) {
            this.label = field.getName();
            this.data = field;
        }

        public TreeNode(Method method) {
            this.label = method.getName();
            this.data = method;
        }

        public String toString() {
            return this.label;
        }
    }
}

