/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.importer.SchemaReader;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.schema.Schema;
import net.sf.saxon.schema.SchemaException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.validate.Sink;
import org.xml.sax.InputSource;

public class Validate {
    protected Configuration config = new Configuration();
    protected boolean useURLs = false;
    protected NamePool namePool = NamePool.getDefaultNamePool();
    protected boolean showTime = false;
    protected int repeat = 1;

    public static void main(String[] args) throws Exception {
        new Validate().doMain(args, " java net.sf.saxon.Validate");
    }

    protected void doMain(String[] args, String name) {
        String sourceFileName = null;
        String schemaFileName = null;
        try {
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    this.badUsage(name, "No source file name");
                }
                if (args[i].charAt(0) != '-') break;
                if (args[i].equals("-u")) {
                    this.useURLs = true;
                    ++i;
                    continue;
                }
                if (args[i].equals("-t")) {
                    System.err.println(Version.getProductTitle());
                    System.err.println("Java version " + System.getProperty("java.version"));
                    Loader.setTracing(true);
                    this.showTime = true;
                    ++i;
                    continue;
                }
                if (args[i].equals("-x")) {
                    if (args.length < ++i + 2) {
                        this.badUsage(name, "No source parser class");
                    }
                    String sourceParserName = args[i++];
                    this.config.setSourceParserClass(sourceParserName);
                    continue;
                }
                if (args[i].equals("-r")) {
                    if (args.length < ++i + 2) {
                        this.badUsage(name, "No URIResolver class");
                    }
                    String r = args[i++];
                    this.config.setURIResolver(Validate.makeURIResolver(r));
                    continue;
                }
                if (args[i].equals("-?")) {
                    this.badUsage(name, "");
                    continue;
                }
                if (args[i].equals("-")) break;
                this.badUsage(name, "Unknown option " + args[i]);
            }
            if (args.length < i + 1) {
                this.badUsage(name, "No source file name");
            }
            sourceFileName = args[i++];
            if (args.length >= i + 1) {
                schemaFileName = args[i++];
            }
            Source source = Validate.loadDocument(sourceFileName, this.useURLs, this.config);
            long startTime = new Date().getTime();
            if (schemaFileName != null) {
                Source schemaSource;
                if (this.useURLs || schemaFileName.startsWith("http:") || schemaFileName.startsWith("file:")) {
                    schemaSource = this.config.getURIResolver().resolve(schemaFileName, null);
                    if (schemaSource == null) {
                        schemaSource = new StandardURIResolver().resolve(schemaFileName, null);
                    }
                } else if (schemaFileName.equals("-")) {
                    schemaSource = new SAXSource(this.config.getSourceParser(), new InputSource(System.in));
                } else {
                    File sheetFile = new File(schemaFileName);
                    if (!sheetFile.exists()) {
                        Validate.quit("Schema file " + sheetFile + " does not exist", 2);
                    }
                    InputSource eis = new InputSource(sheetFile.toURI().toString());
                    schemaSource = new SAXSource(this.config.getSourceParser(), eis);
                }
                if (schemaSource == null) {
                    Validate.quit("URIResolver for schema file must return a Source", 2);
                }
                this.config.setSchemaValidation(true);
                Schema schema = SchemaReader.read((Source)schemaSource, (Configuration)this.config, (NamePool)this.namePool);
                this.config.addSchema(schema);
                if (this.showTime) {
                    long endTime = new Date().getTime();
                    System.err.println("Schema preparation time: " + (endTime - startTime) + " milliseconds");
                    startTime = endTime;
                }
            } else {
                this.config.setSchemaValidation(true);
            }
            this.processFile(source);
        }
        catch (SchemaException err) {
            Validate.quit("Schema processing failed: " + err.getMessage(), 2);
        }
        catch (ValidationException err) {
            try {
                this.config.getErrorListener().error(err);
            }
            catch (Exception err2) {
                // empty catch block
            }
            Validate.quit("Validation of source document failed", 2);
        }
        catch (TransformerException err) {
            try {
                this.config.getErrorListener().error(err);
            }
            catch (Exception err2) {
                // empty catch block
            }
            Validate.quit("Processing failed", 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            Validate.quit("Transformation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            Validate.quit("Fatal error during transformation: " + err2.getMessage(), 2);
        }
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    public static Source loadDocument(String sourceFileName, boolean useURLs, Configuration config) throws TransformerException {
        Source sourceInput;
        if (useURLs || sourceFileName.startsWith("http:") || sourceFileName.startsWith("file:")) {
            sourceInput = config.getURIResolver().resolve(sourceFileName, null);
            if (sourceInput == null) {
                sourceInput = new StandardURIResolver().resolve(sourceFileName, null);
            }
        } else if (sourceFileName.equals("-")) {
            sourceInput = new SAXSource(config.getSourceParser(), new InputSource(System.in));
        } else {
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                Validate.quit("Source file " + sourceFile + " does not exist", 2);
            }
            InputSource eis = new InputSource(sourceFile.toURI().toString());
            sourceInput = new SAXSource(config.getSourceParser(), eis);
        }
        return sourceInput;
    }

    public void processFile(Source source) throws TransformerException {
        int r = 0;
        while (r < this.repeat) {
            if (this.showTime) {
                System.err.println("Processing " + source.getSystemId());
            }
            long startTime = new Date().getTime();
            new Sender(this.config).send(source, (Receiver)new Sink(), this.namePool, false);
            if (this.showTime) {
                long endTime = new Date().getTime();
                System.err.println("Execution time: " + (endTime - startTime) + " milliseconds");
                long l = endTime;
            }
            ++r;
        }
    }

    protected void badUsage(String name, String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println(Version.getProductTitle());
        }
        System.err.println("Usage: " + name + " [options] source-doc schema-doc");
        System.err.println("Options: ");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -v              Validate source documents using DTD");
        System.err.println("  -x classname    Use specified SAX parser for source file");
        System.err.println("  -?              Display this message ");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }

    public static URIResolver makeURIResolver(String className) throws TransformerException {
        Object obj = Loader.getInstance(className);
        if (obj instanceof URIResolver) {
            return (URIResolver)obj;
        }
        throw new TransformerException("Class " + className + " is not a URIResolver");
    }
}

