# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the ios_l2_interfaces module
"""


class L2_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_l2_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "access": {
                    "type": "dict",
                    "options": {"vlan": {"type": "int"}, "vlan_name": {"type": "str"}},
                },
                "voice": {
                    "type": "dict",
                    "options": {
                        "vlan": {"type": "int"},
                        "vlan_tag": {"choices": ["dot1p", "none", "untagged"], "type": "str"},
                        "vlan_name": {"type": "str"},
                    },
                },
                "trunk": {
                    "type": "dict",
                    "options": {
                        "allowed_vlans": {"type": "list", "elements": "str"},
                        "native_vlan": {"type": "int"},
                        "encapsulation": {"choices": ["dot1q", "isl", "negotiate"], "type": "str"},
                        "pruning_vlans": {"type": "list", "elements": "str"},
                    },
                },
                "mode": {
                    "type": "str",
                    "choices": [
                        "access",
                        "trunk",
                        "dot1q_tunnel",
                        "dynamic",
                        "dynamic_auto",
                        "dynamic_desirable",
                        "private_vlan_host",
                        "private_vlan_promiscuous",
                        "private_vlan_trunk",
                    ],
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
