/*
 * ion/de/brush.h
 *
 * Copyright (c) Tuomo Valkonen 1999-2007.
 *
 * See the included file LICENSE for details.
 */

#ifndef ION_DE_BRUSH_H
#define ION_DE_BRUSH_H

#include <libextl/extl.h>

#include <ioncore/common.h>
#include <ioncore/gr.h>
#include <ioncore/rectangle.h>

#ifdef HAVE_X11_XFT
#include <X11/Xft/Xft.h>
#endif /* HAVE_X11_XFT */

INTRCLASS(DEBrush);

#include "style.h"
#include "colour.h"


typedef void DEBrushExtrasFn(DEBrush *brush,
                             const WRectangle *g,
                             DEColourGroup *cg,
                             const GrBorderWidths *bdw,
                             const GrFontExtents *fnte,
                             const GrStyleSpec *a1,
                             const GrStyleSpec *a2,
                             bool pre, int index);

DECLCLASS(DEBrush){
    GrBrush grbrush;
    DEStyle *d;
#ifdef HAVE_X11_XFT
    XftDraw *draw;
#endif
    DEBrushExtrasFn *extras_fn;
    int indicator_w;
    Window win;
    bool clip_set;

    GrStyleSpec current_attr;
};

extern DEBrush *de_get_brush(Window win, WRootWin *rootwin,
                             const char *style);

extern DEBrush *create_debrush(Window win,
                               const GrStyleSpec *spec, DEStyle *style);
extern bool debrush_init(DEBrush *brush, Window win,
                         const GrStyleSpec *spec, DEStyle *style);
extern void debrush_deinit(DEBrush *brush);

extern DEBrush *debrush_get_slave(DEBrush *brush, WRootWin *rootwin,
                                  const char *style);

extern void debrush_release(DEBrush *brush);


extern DEColourGroup *debrush_get_colour_group2(DEBrush *brush,
                                                const GrStyleSpec *a1,
                                                const GrStyleSpec *a2);

extern DEColourGroup *debrush_get_colour_group(DEBrush *brush,
                                               const GrStyleSpec *attr);

extern DEColourGroup *debrush_get_current_colour_group(DEBrush *brush);

/* Begin/end */

extern void debrush_begin(DEBrush *brush, const WRectangle *geom, int flags);
extern void debrush_end(DEBrush *brush);

extern void debrush_init_attr(DEBrush *brush, const GrStyleSpec *spec);
extern void debrush_set_attr(DEBrush *brush, GrAttr attr);
extern void debrush_unset_attr(DEBrush *brush, GrAttr attr);
extern GrStyleSpec *debrush_get_current_attr(DEBrush *brush);

/* Information */

extern void debrush_get_border_widths(DEBrush *brush, GrBorderWidths *bdw);
extern bool debrush_get_extra(DEBrush *brush, const char *key, char type,
                              void *data);

/* Borders & boxes */

extern void debrush_draw_border(DEBrush *brush,
                                const WRectangle *geom);
extern void debrush_draw_borderline(DEBrush *brush, const WRectangle *geom,
                                    GrBorderLine line);

extern void debrush_draw_textbox(DEBrush *brush, const WRectangle *geom,
                                 const char *text, bool needfill);

extern void debrush_draw_textboxes(DEBrush *brush, const WRectangle *geom,
                                   int n, const GrTextElem *elem,
                                   bool needfill);

extern DEBrushExtrasFn debrush_tab_extras;
extern DEBrushExtrasFn debrush_menuentry_extras;

/* Misc */

extern void debrush_set_window_shape(DEBrush *brush, bool rough,
                                     int n, const WRectangle *rects);

extern void debrush_enable_transparency(DEBrush *brush, GrTransparency mode);

extern void debrush_fill_area(DEBrush *brush, const WRectangle *geom);
extern void debrush_clear_area(DEBrush *brush, const WRectangle *geom);

#ifdef HAVE_X11_XFT
XftDraw *debrush_get_draw(DEBrush *brush, Drawable d);
#endif

#endif /* ION_DE_BRUSH_H */
