#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 16:30:06 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/headandslice/headandslice_net.py,v 1.14 2009/07/31 00:54:52 vareille Exp $
#
# $Id: headandslice_net.py,v 1.14 2009/07/31 00:54:52 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
masterNet.createUserPanel('Panel_0' ,width=196, height=126)
## loading libraries ##
from Volume.VisionInterface.VolumeNodes import vollib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_0 = Viewer(constrkw={}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_0,265,284)
    apply(Viewer_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    ##
        ## Saving State for Viewer
    Viewer_0.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 837, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 52.707600000000006, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 145, 'd1scale': 0.012999999999999999}
    apply(Viewer_0.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_0.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [31.499998092651367, 31.500001907348633, 31.500001907348633], 'rotation': [0.086349413, -0.97646981, -0.19761209, 0.0, 0.89508241, 0.16313493, -0.41498724, 0.0, 0.43745998, -0.14104521, 0.8881076, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.25427312, 0.25427312, 0.25427312], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-31.793123, -31.435675, -33.981407], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_0.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_0.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_0.vi.rootObject:
        Viewer_0.vi.rootObject.clipP = []
        Viewer_0.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_0=None

try:
    ## saving node OrthoSliceZ ##
    from Volume.VisionInterface.VolumeNodes import OrthoSlice
    OrthoSliceZ_1 = OrthoSlice(constrkw={}, name='OrthoSliceZ', library=vollib)
    masterNet.addNode(OrthoSliceZ_1,76,153)
    OrthoSliceZ_1.inputPortByName['axis'].widget.set(r"z", run=False)
    apply(OrthoSliceZ_1.inputPortByName['sliceNumber'].widget.configure, (), {'max': 63, 'labelCfg': {'text': 'Z sliceNumber:'}, 'widgetPlacerCfg': {'rely': '0.2556', 'relx': '0.6364'}, 'master': 'Panel_0'})
    OrthoSliceZ_1.inputPortByName['sliceNumber'].widget.set(29, run=False)
    OrthoSliceZ_1.inputPortByName['colorMap'].widget.set({'mini': -7.5834474563598633, 'initialValue': None, 'name': 'cmap', 'ramp': [[0.17599999999999927, 0.0, 1.0, 1.0], [0.0, 0.093999999999999639, 1.0, 1.0], [0.0, 0.36999999999999988, 1.0, 1.0], [0.0, 0.64599999999999946, 1.0, 1.0], [0.0, 0.9159999999999997, 1.0, 1.0], [0.0, 1.0, 0.80800000000000127, 0.36599999999999999], [0.0, 1.0, 0.53200000000000036, 0.33700000000000002], [0.0, 1.0, 0.26199999999999979, 0.34300000000000003], [0.049999999999999822, 1.0, 0.0, 0.35999999999999999], [0.32000000000000006, 1.0, 0.0, 0.371], [0.59599999999999898, 1.0, 0.0, 0.38900000000000001], [0.87199999999999989, 1.0, 0.0, 1.0], [1.0, 0.85799999999999987, 0.0, 1.0], [1.0, 0.58200000000000007, 0.0, 1.0], [1.0, 0.30599999999999999, 0.0, 1.0], [1.0, 0.0, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 2}, 'maxi': 253.0, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 2}, 'labelCfg': {'text': 'colorMap'}, 'class': 'NEColorMap'}, run=False)
    OrthoSliceZ_1.inputPortByName['transparency'].widget.set(r"alpha", run=False)
    OrthoSliceZ_1.inputPortByName['name'].widget.set(r"", run=False)
    OrthoSliceZ_1.inputPortByName['geoms'].widget.set(r"OrthoSliceZ", run=False)
    apply(OrthoSliceZ_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore OrthoSlice named OrthoSliceZ in network masterNet"
    print_exc()
    OrthoSliceZ_1=None

try:
    ## saving node OrthoSliceY ##
    from Volume.VisionInterface.VolumeNodes import OrthoSlice
    OrthoSliceY_2 = OrthoSlice(constrkw={}, name='OrthoSliceY', library=vollib)
    masterNet.addNode(OrthoSliceY_2,183,152)
    OrthoSliceY_2.inputPortByName['axis'].widget.set(r"y", run=False)
    apply(OrthoSliceY_2.inputPortByName['sliceNumber'].widget.configure, (), {'max': 63, 'labelCfg': {'text': 'Y sliceNumber:'}, 'widgetPlacerCfg': {'rely': '0.5397', 'relx': '0.6276'}, 'master': 'Panel_0'})
    OrthoSliceY_2.inputPortByName['sliceNumber'].widget.set(20, run=False)
    OrthoSliceY_2.inputPortByName['colorMap'].widget.set({'mini': -7.5834474563598633, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.6666666865348817, 0.246], [0.0, 1.0, 0.40000003576278698, 0.26300000000000001], [0.0, 1.0, 0.13333338499069225, 0.26900000000000002], [0.13333326578140148, 1.0, 0.0, 0.28599999999999998], [0.3999999165534962, 1.0, 0.0, 0.29699999999999999], [0.66666662693023615, 1.0, 0.0, 0.29699999999999999], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 2}, 'maxi': 253.0, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 2}, 'labelCfg': {'text': 'colorMap'}, 'class': 'NEColorMap'}, run=False)
    OrthoSliceY_2.inputPortByName['transparency'].widget.set(r"alpha", run=False)
    OrthoSliceY_2.inputPortByName['name'].widget.set(r"", run=False)
    OrthoSliceY_2.inputPortByName['geoms'].widget.set(r"OrthoSliceY", run=False)
    apply(OrthoSliceY_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore OrthoSlice named OrthoSliceY in network masterNet"
    print_exc()
    OrthoSliceY_2=None

try:
    ## saving node Grid3DBB ##
    from Volume.VisionInterface.VolumeNodes import BoundingBox
    Grid3DBB_3 = BoundingBox(constrkw={}, name='Grid3DBB', library=vollib)
    masterNet.addNode(Grid3DBB_3,345,25)
    Grid3DBB_3.inputPortByName['name'].widget.set(r"", run=False)
    Grid3DBB_3.inputPortByName['geoms'].widget.set(r"Grid3DBB", run=False)
    apply(Grid3DBB_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore BoundingBox named Grid3DBB in network masterNet"
    print_exc()
    Grid3DBB_3=None

try:
    ## saving node ReadAnyMap ##
    from Volume.VisionInterface.VolumeNodes import ReadAnyMap
    ReadAnyMap_4 = ReadAnyMap(constrkw={}, name='ReadAnyMap', library=vollib)
    masterNet.addNode(ReadAnyMap_4,11,3)
    ReadAnyMap_4.inputPortByName['filename'].widget.set(r"ct_head.rawiv", run=False)
except:
    print "WARNING: failed to restore ReadAnyMap named ReadAnyMap in network masterNet"
    print_exc()
    ReadAnyMap_4=None

try:
    ## saving node OrthoSliceX ##
    from Volume.VisionInterface.VolumeNodes import OrthoSlice
    OrthoSliceX_5 = OrthoSlice(constrkw={}, name='OrthoSliceX', library=vollib)
    masterNet.addNode(OrthoSliceX_5,364,154)
    OrthoSliceX_5.inputPortByName['axis'].widget.set(r"x", run=False)
    apply(OrthoSliceX_5.inputPortByName['sliceNumber'].widget.configure, (), {'max': 63, 'labelCfg': {'text': 'X sliceNumber:'}, 'widgetPlacerCfg': {'rely': '0.8175', 'relx': '0.6122'}, 'master': 'Panel_0'})
    OrthoSliceX_5.inputPortByName['sliceNumber'].widget.set(18, run=False)
    OrthoSliceX_5.inputPortByName['colorMap'].widget.set({'mini': -7.5834474563598633, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.66666668653488159, 1.0], [0.0, 1.0, 0.40000003576278687, 1.0], [0.0, 1.0, 0.13333338499069214, 1.0], [0.13333326578140259, 1.0, 0.0, 1.0], [0.39999991655349731, 1.0, 0.0, 1.0], [0.66666662693023682, 1.0, 0.0, 1.0], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 2}, 'maxi': 253.0, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 2}, 'labelCfg': {'text': 'colorMap'}, 'class': 'NEColorMap'}, run=False)
    OrthoSliceX_5.inputPortByName['transparency'].widget.set(r"alpha", run=False)
    OrthoSliceX_5.inputPortByName['name'].widget.set(r"", run=False)
    OrthoSliceX_5.inputPortByName['geoms'].widget.set(r"OrthoSliceX", run=False)
    apply(OrthoSliceX_5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore OrthoSlice named OrthoSliceX in network masterNet"
    print_exc()
    OrthoSliceX_5=None

try:
    ## saving node UT-Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    UT_Isocontour_6 = Isocontour(constrkw={}, name='UT-Isocontour', library=vollib)
    masterNet.addNode(UT_Isocontour_6,450,21)
    apply(UT_Isocontour_6.inputPortByName['isovalue'].widget.configure, (), {'max': 253.0, 'min': 0.0})
    UT_Isocontour_6.inputPortByName['isovalue'].widget.set(65.4823529412, run=False)
    UT_Isocontour_6.inputPortByName['calculatesignatures'].widget.set(1, run=False)
    UT_Isocontour_6.inputPortByName['verbosity'].widget.set(0, run=False)
    apply(UT_Isocontour_6.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Isocontour named UT-Isocontour in network masterNet"
    print_exc()
    UT_Isocontour_6=None

try:
    ## saving node indexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indexedPolygons_7 = IndexedPolygonsNE(constrkw={}, name='indexedPolygons', library=vizlib)
    masterNet.addNode(indexedPolygons_7,450,217)
    indexedPolygons_7.inputPortByName['name'].widget.set(r"", run=False)
    indexedPolygons_7.inputPortByName['geoms'].widget.set(r"indexedPolygons", run=False)
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indexedPolygons in network masterNet"
    print_exc()
    indexedPolygons_7=None

#masterNet.run()
masterNet.freeze()

## saving connections for network headandslice ##
if OrthoSliceZ_1 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            OrthoSliceZ_1, Viewer_0, "OrthoSlice", "geometries", blocking=True
            , splitratio=[1.0, 0.77720164407479264])
    except:
        print "WARNING: failed to restore connection between OrthoSliceZ_1 and Viewer_0 in network masterNet"
if OrthoSliceY_2 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            OrthoSliceY_2, Viewer_0, "OrthoSlice", "geometries", blocking=True
            , splitratio=[0.33202429492177166, 0.29219764174937257])
    except:
        print "WARNING: failed to restore connection between OrthoSliceY_2 and Viewer_0 in network masterNet"
if Grid3DBB_3 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, Viewer_0, "Grid3DBB", "geometries", blocking=True
            , splitratio=[0.64029630615033006, 0.29661350546128723])
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and Viewer_0 in network masterNet"
if ReadAnyMap_4 is not None and Grid3DBB_3 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, Grid3DBB_3, "grid", "grid", blocking=True
            , splitratio=[0.74071126812554322, -0.28947368421052594])
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and Grid3DBB_3 in network masterNet"
if ReadAnyMap_4 is not None and OrthoSliceY_2 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, OrthoSliceY_2, "grid", "grid", blocking=True
            , splitratio=[0.70285128293251065, 0.42813315945252928])
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and OrthoSliceY_2 in network masterNet"
if ReadAnyMap_4 is not None and OrthoSliceZ_1 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, OrthoSliceZ_1, "grid", "grid", blocking=True
            , splitratio=[0.36913206352825373, 0.27703093996238543])
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and OrthoSliceZ_1 in network masterNet"
if ReadAnyMap_4 is not None and OrthoSliceX_5 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, OrthoSliceX_5, "grid", "grid", blocking=True
            , splitratio=[1.0, 0.41720162199684357])
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and OrthoSliceX_5 in network masterNet"
if OrthoSliceX_5 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            OrthoSliceX_5, Viewer_0, "OrthoSlice", "geometries", blocking=True
            , splitratio=[1.0, 0.28385622484724293])
    except:
        print "WARNING: failed to restore connection between OrthoSliceX_5 and Viewer_0 in network masterNet"
if ReadAnyMap_4 is not None and UT_Isocontour_6 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, UT_Isocontour_6, "grid", "grid3D", blocking=True
            , splitratio=[0.56339269000041625, -0.26190476190476192])
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and UT_Isocontour_6 in network masterNet"
if Grid3DBB_3 is not None and OrthoSliceY_2 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, OrthoSliceY_2, "Grid3DBB", "parent", blocking=True
            , splitratio=[0.42996524147399096, 0.55430549664968143])
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and OrthoSliceY_2 in network masterNet"
if Grid3DBB_3 is not None and OrthoSliceZ_1 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, OrthoSliceZ_1, "Grid3DBB", "parent", blocking=True
            , splitratio=[0.41137763730563182, 0.69804763138487724])
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and OrthoSliceZ_1 in network masterNet"
if Grid3DBB_3 is not None and OrthoSliceX_5 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, OrthoSliceX_5, "Grid3DBB", "parent", blocking=True
            , splitratio=[0.53922597465684263, 0.71160162880511235])
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and OrthoSliceX_5 in network masterNet"
if UT_Isocontour_6 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, indexedPolygons_7, "coords", "coords", blocking=True
            , splitratio=[0.63451094292734411, 0.59474042648552494])
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and indexedPolygons_7 in network masterNet"
if UT_Isocontour_6 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, indexedPolygons_7, "indices", "indices", blocking=True
            , splitratio=[0.62726016731981316, 0.21594631387175778])
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and indexedPolygons_7 in network masterNet"
if UT_Isocontour_6 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, indexedPolygons_7, "normals", "vnormals", blocking=True
            , splitratio=[0.45166737747182206, 0.6482549550181349])
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and indexedPolygons_7 in network masterNet"
if indexedPolygons_7 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            indexedPolygons_7, Viewer_0, "indexedPolygons", "geometries", blocking=True
            , splitratio=[0.43120977929287985, 0.27479221453460317])
    except:
        print "WARNING: failed to restore connection between indexedPolygons_7 and Viewer_0 in network masterNet"
if Grid3DBB_3 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, indexedPolygons_7, "Grid3DBB", "parent", blocking=True
            , splitratio=[0.46877957340016974, 0.5961115553824986])
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and indexedPolygons_7 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Viewer_0(self=Viewer_0, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|Grid3DBB
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'Grid3DBB', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Grid3DBB
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Grid3DBB

    ## Clipping Planes for Grid3DBB
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Grid3DBB

    ## Object root|Grid3DBB|OrthoSliceZ
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 0, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'OrthoSliceZ', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|OrthoSliceZ')
    if obj:
        apply(obj.Set, (), state)

    ## Material for OrthoSliceZ
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for OrthoSliceZ

    ## Clipping Planes for OrthoSliceZ
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for OrthoSliceZ

    ## Object root|Grid3DBB|OrthoSliceY
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 0, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'OrthoSliceY', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|OrthoSliceY')
    if obj:
        apply(obj.Set, (), state)

    ## Material for OrthoSliceY
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for OrthoSliceY

    ## Clipping Planes for OrthoSliceY
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for OrthoSliceY

    ## Object root|Grid3DBB|OrthoSliceX
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 0, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'OrthoSliceX', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|OrthoSliceX')
    if obj:
        apply(obj.Set, (), state)

    ## Material for OrthoSliceX
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for OrthoSliceX

    ## Clipping Planes for OrthoSliceX
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for OrthoSliceX

    ## Object root|Grid3DBB|indexedPolygons
    ## End Object root|Grid3DBB|indexedPolygons

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 52.707600000000006, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [31.499998092651367, 31.500001907348633, 31.500001907348633], 'rotation': [0.086349413, -0.97646981, -0.19761209, 0.0, 0.89508241, 0.16313493, -0.41498724, 0.0, 0.43745998, -0.14104521, 0.8881076, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.25427312, 0.25427312, 0.25427312], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-31.793123, -31.435675, -33.981407], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_0.restoreStates_cb = Viewer_0.restoreStatesFirstRun = loadSavedStates_Viewer_0
Viewer_0.menu.add_separator()
Viewer_0.menu.add_command(label='Restore states', command=Viewer_0.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

