/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.haplotype;

import com.google.java.contract.Requires;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.tools.walkers.haplotypecaller.PairHMMLikelihoodCalculationEngine;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;

public class HaplotypeLDCalculator {
    private final List<Haplotype> haplotypes;
    private final Map<String, PerReadAlleleLikelihoodMap> haplotypeReadMap;
    private List<Map<Haplotype, Double>> haplotypeLikelihoodsPerSample = null;
    private final double[] table = new double[4];

    protected HaplotypeLDCalculator() {
        this.haplotypes = Collections.emptyList();
        this.haplotypeReadMap = Collections.emptyMap();
    }

    public HaplotypeLDCalculator(List<Haplotype> haplotypes, Map<String, PerReadAlleleLikelihoodMap> haplotypeReadMap) {
        this.haplotypes = haplotypes;
        this.haplotypeReadMap = haplotypeReadMap;
    }

    private void buildHaplotypeLikelihoodsPerSampleIfNecessary() {
        if (this.haplotypeLikelihoodsPerSample == null) {
            Set<String> samples = this.haplotypeReadMap.keySet();
            this.haplotypeLikelihoodsPerSample = new LinkedList<Map<Haplotype, Double>>();
            for (String sample : samples) {
                HashMap<Haplotype, Double> map = new HashMap<Haplotype, Double>(this.haplotypes.size());
                for (Haplotype h : this.haplotypes) {
                    double haplotypeLikelihood = PairHMMLikelihoodCalculationEngine.computeDiploidHaplotypeLikelihoods((String)sample, this.haplotypeReadMap, Collections.singletonList(Allele.create((Allele)h, (boolean)true)), (boolean)false)[0][0];
                    map.put(h, haplotypeLikelihood);
                }
                this.haplotypeLikelihoodsPerSample.add(map);
            }
        }
    }

    protected double computeProbOfBeingPhased(VariantContext first, VariantContext second) {
        this.buildHaplotypeLikelihoodsPerSampleIfNecessary();
        Arrays.fill(this.table, Double.NEGATIVE_INFINITY);
        for (Map<Haplotype, Double> entry : this.haplotypeLikelihoodsPerSample) {
            for (Map.Entry<Haplotype, Double> haplotypeLikelihood : entry.entrySet()) {
                Haplotype h = haplotypeLikelihood.getKey();
                VariantContext thisHapVC = (VariantContext)h.getEventMap().get(first.getStart());
                VariantContext nextHapVC = (VariantContext)h.getEventMap().get(second.getStart());
                int i = thisHapVC == null ? 0 : 1;
                int j = nextHapVC == null ? 0 : 1;
                int index = 2 * i + j;
                this.table[index] = MathUtils.approximateLog10SumLog10(this.table[index], haplotypeLikelihood.getValue());
            }
        }
        return this.pPhased(this.table);
    }

    @Requires(value={"table.length == 4"})
    protected double pPhased(double[] table) {
        double[] normTable = MathUtils.normalizeFromLog10(table, true);
        double x11 = normTable[0];
        double x12 = normTable[1];
        double x21 = normTable[2];
        double x22 = normTable[3];
        double p11_22 = MathUtils.approximateLog10SumLog10(x11 + x22, x22 + x22);
        double p11_12_21 = MathUtils.approximateLog10SumLog10(x11 + x12, x11 + x21, x12 + x21);
        double p22_12_21 = MathUtils.approximateLog10SumLog10(x22 + x12, x22 + x21, x12 + x21);
        double p22_12 = x22 + x12;
        double p22_21 = x22 + x21;
        double pOthers = MathUtils.approximateLog10SumLog10(new double[]{p11_12_21, p22_12_21, p22_12, p22_21});
        double log10phased = p11_22 - MathUtils.approximateLog10SumLog10(p11_22, pOthers);
        return Math.pow(10.0, log10phased);
    }

    protected double pPhasedTest(double x11, double x12, double x21, double x22) {
        return this.pPhased(new double[]{x11, x12, x21, x22});
    }
}

