/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Platform;
import org.fest.util.Strings;

public class AWT {
    private static final String APPLET_APPLET_VIEWER_CLASS = "sun.applet.AppletViewer";
    private static final String ROOT_FRAME_CLASSNAME = Strings.concat((Object[])new Object[]{SwingUtilities.class.getName(), "$"});

    public static boolean isPointInScreenBoundaries(JComponent c, Point p) {
        Point where = AWT.translate(c, p.x, p.y);
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return screen.contains(where);
    }

    public static boolean isPointInScreenBoundaries(Point p) {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return screen.contains(p);
    }

    public static Window[] ownerLessWindows() {
        try {
            return (Window[])Reflection.staticMethod((String)"getOwnerlessWindows").withReturnType(Window[].class).in(Window.class).invoke(new Object[0]);
        }
        catch (RuntimeException e) {
            return new Window[0];
        }
    }

    @RunsInCurrentThread
    public static Point translate(Component c, int x, int y) {
        Point p = AWT.locationOnScreenOf(c);
        if (p == null) {
            return null;
        }
        p.translate(x, y);
        return p;
    }

    @RunsInEDT
    public static Point visibleCenterOf(final Component c) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                if (c instanceof JComponent) {
                    return AWT.centerOfVisibleRect((JComponent)c);
                }
                return AWT.centerOf(c);
            }
        });
    }

    @RunsInCurrentThread
    public static Point centerOf(Component c) {
        Dimension size = c.getSize();
        return new Point(size.width / 2, size.height / 2);
    }

    @RunsInCurrentThread
    public static Point centerOfVisibleRect(JComponent c) {
        Rectangle r = c.getVisibleRect();
        return AWT.centerOf(r);
    }

    @RunsInCurrentThread
    public static Point centerOf(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @RunsInCurrentThread
    public static Insets insetsFrom(Container c) {
        try {
            Insets insets = c.getInsets();
            if (insets != null) {
                return insets;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Insets(0, 0, 0, 0);
    }

    public static boolean isAppletViewer(Component c) {
        return c != null && APPLET_APPLET_VIEWER_CLASS.equals(c.getClass().getName());
    }

    public static boolean isSharedInvisibleFrame(Component c) {
        if (c == null) {
            return false;
        }
        return c instanceof Frame && (c == JOptionPane.getRootFrame() || c.getClass().getName().startsWith(ROOT_FRAME_CLASSNAME));
    }

    @RunsInCurrentThread
    public static boolean isHeavyWeightPopup(Component c) {
        if (!(c instanceof Window) || c instanceof Dialog || c instanceof Frame) {
            return false;
        }
        String name = AWT.obtainNameSafely(c);
        if ("###overrideRedirect###".equals(name) || "###focusableSwingPopup###".equals(name)) {
            return true;
        }
        String typeName = c.getClass().getName();
        return typeName.indexOf("PopupFactory$WindowPopup") != -1 || typeName.indexOf("HeavyWeightWindow") != -1;
    }

    @RunsInCurrentThread
    private static String obtainNameSafely(Component c) {
        try {
            return c.getName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @RunsInCurrentThread
    public static Component invokerOf(Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        return parent != null ? AWT.invokerOf(parent) : null;
    }

    @RunsInCurrentThread
    public static Point locationOnScreenOf(Component c) {
        if (!AWT.isAWTTreeLockHeld()) {
            return new Point(c.getLocationOnScreen());
        }
        if (!c.isShowing()) {
            return null;
        }
        Point location = new Point(c.getLocation());
        if (c instanceof Window) {
            return location;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        Point parentLocation = AWT.locationOnScreenOf(parent);
        location.translate(parentLocation.x, parentLocation.y);
        return location;
    }

    public static boolean popupOnPress() {
        return !Platform.isWindows();
    }

    public static int popupMask() {
        return 4;
    }

    public static boolean isAWTTreeLockHeld() {
        Frame[] frames = Frame.getFrames();
        if (frames.length == 0) {
            return false;
        }
        ThreadStateChecker checker = new ThreadStateChecker(frames[0].getTreeLock());
        try {
            checker.start();
            if (checker.isAlive()) {
                checker.join(100L);
            }
            return checker.isAlive();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private AWT() {
    }

    private static class ThreadStateChecker
    extends Thread {
        private final Object lock;

        public ThreadStateChecker(Object lock) {
            super("Thread state checker");
            this.setDaemon(true);
            this.lock = lock;
        }

        public synchronized void start() {
            super.start();
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
                this.setName(super.getName());
            }
        }
    }
}

